% Skript uebDFTAufloesung.m
%
% Aufruf:  uebDFTAufloesung
%
% bung zur spektralen Auflsung der DFT/FFT.
%
% Autor: Prof. Dr. Ottmar Beucher
%        HS Karlsruhe
% Version: 1.2
% Datum: 15.11.2014/23.05.2018

% Abtastung mit 1024 Punkten
fa=16; Ta=1/16;
N = 1024;
t = (0:Ta:(N-1)*Ta);
x = sin(2*pi*t)+sin(2*pi*1.02*t);

% Spektrum mit 1024 Punkten
sp = fft(x,N);

% Abtastung mit 4096 Punkten
N = 4096;
t1 = (0:Ta:(N-1)*Ta);
x1 = sin(2*pi*t1)+sin(2*pi*1.02*t1);

% Spekrum mit 4096 Punkten
sp1 = fft(x1,N);
subplot(211)
df = fa/1024;
frq = (0:df:1023*df);

% Grafische Darstellung
plot(frq,abs(sp),'k','Linewidth',2);
grid
xlabel('Frequenz/Hz')
ylabel('|DFT|')
axis([0.6,1.4,0,600])  % Ausschnitt vergrern
subplot(212)
df = fa/4096;
frq = (0:df:4095*df);
plot(frq,abs(sp1),'b','Linewidth',2);
grid
xlabel('Frequenz/Hz')
ylabel('|DFT|')
axis([0.6,1.4,0,2200])  % Ausschnitt vergrern