function [] = uebDFTFFT(N)
%
% Aufruf: uebDFTFFT(N)
%
% Berechnung DFT fr verschiedene Datenmengen mit
% Hilfe der direkten Berechnung der DFT (Funktion diedft.m)
% und einer FFT-Berechnung.
%
% Das Signal (ein Zufallssignal) wird intern erzeugt.
%
% Das Programm gibt beim Start und bei Beendigung der Berechnung
% eine Meldung aus. Ziel ist der Vergleich der Berechnungszeit
% fr DFT und FFT.
%
% Eingabeparameter:    N    Anzahl der Datenpunkte
%
% Ausgabeparameter:    keine
%
% Autor: Prof. Dr. Ottmar Beucher
%        HS Karlsruhe
% Version: 1.2
% Datum: 15.11.2014/23.05.2018

% Signal erzeugen
randn('state',sum(100*clock));
signal = randn(1,N);

% DFT direkt berechnen
fabtast = 1;                % Virtuelle Abtastrate 1 gewhlt
df = fabtast/N;
frq = (0:df:(N-1)*df);      % Frequenzraster der DFT

tic
fprintf('\nStart der direkten Berechnung der DFT');
diedft(signal, frq, fabtast);  % DFT berechnen
fprintf('\nEnde der direkten Berechnung der DFT\n');
toc

% Zum Vergelich mit einer FFT berechen
tic
fprintf('\nStart der Berechnung mit einer FFT');
fft(signal,N);
fprintf('\nEnde der Berechnung mit einer FFT\n');
toc
