% Skript uebDFTLsg.m
%
% Aufruf:  uebDFTLsg
%
% Vergleich einer 1-K-DFT fr die Signale
%
% x1(t) = sin(2*pi*t) und x2(t) = sin(3*pi*t)
%
% mit einer Darstellung der Amplitudenspektren
%
% Autor: Prof. Dr. Ottmar Beucher
%        HS Karlsruhe
% Version: 1.3
% Datum: 15.11.2014/23.05.2018


T =1/4; N = 1024;    %s. Aufgabenstellung der bung
fa = 1/T;            % Abtastrate
tn = (0:T:(N-1)*T);
x1 = sin(2*pi*tn);
x2 = sin(3*pi*tn);
F1 = fft(x1,N);
F2 = fft(x2,N);
F1 = fftshift(F1);   % Spektrum auf Nyquist-Band 
F2 = fftshift(F2); 

% Darstellung der Amplitudenspektren
df = 4/N;           % Frequenzabstand in Hz
subplot(211)
frq = (-fa/2:df:fa/2-df);
plot(frq, abs(F1), 'k', 'LineWidth', 3);
grid
xlabel('Frequenz/Hz')
ylabel('|F_1|')
subplot(212)
plot(frq, abs(F2), 'b', 'LineWidth', 3);
grid
xlabel('Frequenz/Hz')
ylabel('|F_2|')
