% Skript uebDTFT.m
%
% Aufruf:  uebDTFT
%
% Nherungsweise Besimmung der DTFT 
% des approximativ bandbegrenzten a-periodischen
% Signals
%
% x(t) = exp(-t).*sin(4*t)     (t>=0)
%
% Autor: Prof. Dr. Ottmar Beucher
%        HS Karlsruhe
% Version: 1.2
% Datum: 15.11.2014/23.05.2018

fa = 100;                     % Abtastrate festlegen
N = 1000;                     % Zahl der Abtastwerte festlegen
T = 1/fa;                     % Abtastintervalllnge festlegen
t = (0:T:(N-1)*T);            % Abtastzeitpunkte festlegen
                              % Abtastwerte des Beispielsignals
fn = exp(-t).*sin(4*t);           

% Signal zur Testzwecken plotten
figure                        % Neues Darstellungsfenster aufmachen
plot(t, fn, 'b', 'LineWidth',3)  
grid
axis([0,10,min(fn),max(fn)])                              
xlabel('Zeit t/ s')
ylabel('Ampl.')

% FFT berechnen mit Zero-Paddig der Daten auf
% 4096 Werte. Durch FFT wird die DTFT an den Sttzstellen
% des DFT-Frequenzrasters berechnet. Das Zero-Padding
% bewirkt eine Interpolation zwischen den Sttzstellen
Spfn = fft(fn, 4096);         % Zero-Padding erfolgt automatisch
AmpSpfn = abs(Spfn);          % Betragsspektrum

% Grafische Darstellung des Amplitudenspektrums und des
% um den Faktor (1/T) = fa skalierten DTFT-Spektrums
df = fa/4096;        % DFT Frequenzraster
f = (0:df:fa/2-df);  % Hertz-Frequenzen
om = 2*pi*f;         % in rad/s

% Berechnung des Betrages des Fourierspektrums zum Vergleich
% s. Script-File bspFTnperiod
Xquad = (-4./(om.^2-2*i*om-17)).*...
                    (-4./(om.^2+2*i*om-17));
AspNum = sqrt(abs(Xquad));
                     % Plot des Amplitudenspektrums
                     % und des skalierten DTFT-Spektrums
figure
plot(f,AspNum,'b',f, T*AmpSpfn(1:2048), 'r--', 'LineWidth',3)
grid
axis([0,10,0,0.63])
xlabel('Frequenz/Hz')
ylabel('|X| und X_{DTFT}')



