% Skript uebDTFT2.m
%
% Aufruf:  uebDTFT2
%
% Berechnung DFT fr ein 6-Punkt-Signal. Vergleich mit einer
% DFT mit 4096-Punkt Zero-Padding.
%
% Autor: Prof. Dr. Ottmar Beucher
%        HS Karlsruhe
% Version: 1.2
% Datum: 15.11.2014/23.05.2018

clear all

signal = [1, -1, 1, -1, 1, -1];  % gegebenes diskretes Signal
omega = (0:0.01:2*pi);           % normierte Frequenzen

% Berechnung der DTFT
DTFT = zeros(size(omega));       % DTFT vorinitialisieren
k = (0:1:5);                     % Indexmenge der Signalwerte
for n = 1:length(omega)          % DTFT fr alle omega berechnen
    expom = exp(-1i*k*omega(n));
    DTFT(n) = signal*expom';
end

% DTFT-Betragsspektrum grafisch darstellen
subplot(211)
plot(omega,abs(DTFT),'b','LineWidth', 3);
grid
xlabel('Frequenz/rad')
ylabel('|DTFT|')
axis([0,2*pi,0,1.1*max(abs(DTFT))])

subplot(212)
% 4-K DFT mit Zero-Padding Hilfe des FFT-Kommandos berechnen
Spsig2 = fft(signal, 4*1024);
domega = 2*pi/4096;
omega2 = (0:domega:4095*domega);
plot(omega2,abs(Spsig2),'k','LineWidth', 3)
grid
xlabel('Frequenz/rad')
ylabel('|DFT-Zero-Pad.|')
axis([0,2*pi,0,1.1*max(abs(Spsig2))])





