% Script uebDigiFIR.m
%
% Aufruf: uebDigiFIR
%
% Skript-File zur Bestimmung des bertragungsverhaltens
% zweier FIR-Filter
%
% Autor: Prof. Dr. Ottmar Beucher
%        HS Karlsruhe
% Version: 2.2
% Datum: 16.11.2014/23.05.2018

% Vorinitialisierungen
z= tf('z',1);

% bertragungsfunktionen im Bildbereich definieren
G = (-z^2+2*z-1)/(z^2);
H = (-z^3+2*z-1)/(z^3);

% Bode-Diagramm plotten
omega = (0:0.001:pi);      % Frequenzen in rad
[AG0,PG0] = bode(G,omega);
[AH1,PH1] = bode(H,omega);

% Plot vorbereiten (nur Amplitudengang)
AG0 = AG0(:); AH1 = AH1(:);
PG0 = pi*PG0(:)/180; PH1 = pi*PH1(:)/180;

% Phasen um 360 Gard entsprechend 2*pi anpassen
% (hier ntig, da bode nicht selbst "matched")
PG0 = PG0-2*pi; PH1 = PH1-2*pi;

% Bode-Diagramme plotten
figure
subplot(211)
semilogx(omega, 20*log10(abs(AG0)),'b', 'Linewidth', 3)
grid
xlabel('Frequenz \Omega/rad')
ylabel('|G(\Omega)|')
axis([0,pi,min(20*log10(abs(AG0))),max(20*log10(abs(AG0)))])
subplot(212)
semilogx(omega, PG0,'k', 'Linewidth', 3)
grid
xlabel('Frequenz \Omega/rad')
ylabel('arg G(\Omega)')
axis([0,pi,min(PG0),max(PG0)])

figure
subplot(211)
semilogx(omega, 20*log10(abs(AH1)),'r', 'Linewidth', 3)
grid
xlabel('Frequenz \Omega/rad')
ylabel('|H(\Omega)|')
axis([0,pi,min(20*log10(abs(AH1))),max(20*log10(abs(AH1)))])
subplot(212)
semilogx(omega, PH1,'k', 'Linewidth', 3)
grid
xlabel('Frequenz \Omega/rad')
ylabel('arg H(\Omega)')
axis([0,pi,min(PH1),max(PH1)])

