function [hn, HOmega] = uebDigiFiltEntwurf(N)
%
% Aufruf:          [hn, HOmega] = uebDigiFiltEntwurf(N);
% Aufrufbeispiel:  [hn, HOmega] = uebDigiFiltEntwurf(100);
%
% MATLAB-Programm zum Entwurf eines FIR-Filters
% fr einen Bandpass mit den normierten Grenzfrequenzen
% pi/3 und pi/2 auf der Basis der Kleinsten-Quadrate-
% Approximation der bertragungsfunktion (= Abschneiden
% der idealen Impulsantwort)
%
% Eingangsparameter:      N      Index, um Impulsantwort-
%                                ausschnitt h_n fr n zwischen 
%                                -N und N zu definieren.
%
% Ausgangsparameter       hn     abgeschnittene und verschobene
%                                Impulsantwort
%                         HOmega bertragungsfunktion im 
%                                (normierten) Frequenzbereich
%
% Autor: Prof. Dr. Ottmar Beucher
%        HS Karlsruhe
% Version: 1.2
% Datum: 16.11.2014/23.05.2018

% Impulsantwortausschnitt (Verschiebung
% automatisch durch Zuordnung zum "Zeit"-Vektor
% (0:1:2*N-1) bzw. (1:1:2*N)
n = (-N:1:N);
hn = (1/2)*sinc(n/2)-(1/3)*sinc(n/3);

% Bestimmung der bertragungsfunktion auf dem
% normierten Frequenzintervall [0,pi]
% Da es sich um ein FIR-Filter handelt, gibt es nur
% B-Koeffizienten (s. Definition freqz) und A=[1].
frqn = (0:0.01:pi);
[HOmega,Omega] = freqz(hn,1,frqn);
                              
% Idealen Bandpass zum Vergleich berechnen
BPideal = (Omega>=pi/3)&(Omega<=pi/2);

% Amplitudengnge plotten
plot(Omega, abs(HOmega), 'r', Omega, BPideal, 'b', 'LineWidth',3)
grid
axis([0, pi, 0, 1.3])
xlabel('normierte Frequenz/rad')
ylabel('|H(\omega)|')



                                 