function [hn, HOmega] = uebDigiFiltEntwurf2(N)
%
% Aufruf:          [hn, HOmega] = uebDigiFiltEntwurf2(N)
% Aufrufbeispiel:  [hn, HOmega] = uebDigiFiltEntwurf2(100)
%
% MATLAB-Programm zum Entwurf eines FIR-Filters
% fr einen Hochpass mit der normierten Grenzfrequenz
% pi/2 auf der Basis der Kleinsten-Quadrate-
% Approximation der bertragungsfunktion (= Abschneiden
% der idealen Impulsantwort)
%
% Eingangsparameter:      N      Index, um Impulsantwort-
%                                ausschnitt h_n fr n zwischen 
%                                -N und N zu definieren.
%
% Ausgangsparameter       hn     abgeschnittene und verschobene
%                                Impulsantwort
%                         HOmega bertragungsfunktion im 
%                                (normierten) Frequenzbereich
%
% Autor: Prof. Dr. Ottmar Beucher
%        HS Karlsruhe
% Version: 1.02
% Datum: 16.11.2014/23.05.2018

% Impulsantwortausschnitt (Verschiebung
% automatisch durch Zuordnung zum "Zeit"-Vektor
% (0:1:2*N-1) bzw. (1:1:2*N)
n = (-N:1:N);
indx0 = find(n==0);
hn = -(1/2)*sinc(n/2);
hn(indx0) = hn(indx0)+1; % diskreten Impuls aufaddieren
tn = n+N+1; 

% Bestimmung der bertragungsfunktion auf dem
% normierten Frequenzintervall [0,pi]
% Da es sich um ein FIR-Filter handelt, gibt es nur
% B-Koeffizienten (s. Definition freqz) und A=[1].
frqn = (0:0.01:pi);
[HOmega,Omega] = freqz(hn,1,frqn);
                              
% Idealer Hochpass zum Vergleich berechnen
BPideal = (Omega>=pi/2) ;

% Amplitudengnge plotten
plot(Omega, abs(HOmega), 'r', Omega, BPideal, 'k', 'LineWidth',3)
grid
axis([0, pi, 0, 1.3])
xlabel('normierte Frequenz/rad')
ylabel('|H(\omega)|')



                                 