% Script uebFR.m
%
% Aufruf: uebFR
%
% Berechnungen zu bung 59 zur Bestimmung
% der Fourier-Reihenentwicklung einer periodischen Funktion
% mit der Symbolic Math Toolbox
%
% Autor: Prof. Dr. Ottmar Beucher
%        HS Karlsruhe
% Version: 1.2
% Datum: 30.10.2014/22.05.2018

% Definition der Funktion f(t)
syms t T k
assume(k, 'integer')
f = t^2/T^2;

% Berechnung des a0-Koeffizienten
a0 = (2/T)*int(f,0,T)

% Berechnung der ak-Koeffizienten fr k>=1
cosk = cos(k*2*pi*t/T)
ak = (2/T)*int(f*cosk,0,T)
ak = simplify(ak)
pretty(ak)

% Berechnung der bk-Koeffizienten fr k>=1
sink = sin(k*2*pi*t/T)
bk = (2/T)*int(f*sink,0,T)
bk = simplify(bk)
pretty(bk)
         