% Script uebFiltEntwurf.m
%
% Aufruf: uebFiltEntwurf
%
% MATLAB-Befehle zum Entwurf eines Butterworth-Tiefpass-Filters
% 4. Ordnung mit 3-dB-Grenzfrequenz 50 Hz und eines 
% Tschebyscheff-Tiefpassfilters 1. Art und 4. Ordnung
% mit 1 dB Welligkeit und mit Grenzfrequenz 50 Hz.
%
% Autor: Prof. Dr. Ottmar Beucher
%        HS Karlsruhe
% Version: 1.2
% Datum: 30.10.2014/22.05.2018 

% Butterworthfilter  
omegap=2*pi*50;               % Grenzfrequenz
N = 4;                        % Filterordnung
                              % Filterentwurf
[B,A] = butter(N, omegap,'low','s');

% Tschebyscheff-Filter
[Bc,Ac] = cheby1(N, 1, omegap,'low','s');

% bertragungsfunktionen definieren
BW = tf(B,A);
Ch1 = tf(Bc,Ac);


% Darstellung der Amplitudengnge
frq = (0:0.5:200);
omega=2*pi*frq;               % Frequenzvektor zur
                              % Plotdarstellung

                              % Bode-Diagramme
[ABW,PBW] = bode(BW,omega);
[ACh1,PCh1] = bode(Ch1,omega);
ABW = ABW(:);
ACh1 = ACh1(:);

% Amplitudengnge plotten
subplot(211)
semilogx(frq, 20*log10(ABW), 'k', 'LineWidth',3)
grid
axis([0, 200, -30, 5])
xlabel('Frequenz/Hz')
ylabel('Amp.gang')
title('Butterworth-Tiefpass')

subplot(212)
semilogx(frq, 20*log10(ACh1), 'b', 'LineWidth',3)
grid
axis([0, 200, -30, 5])
xlabel('Frequenz/Hz')
ylabel('Amp.gang')
title('Tschebyscheff-Tiefpass')


                                 