% Script uebFiltEntwurf2.m
%
% Aufruf: uebFiltEntwurf2
%
% MATLAB-Befehle zum Entwurf eines Butterworth-Tiefpass-Filters
% 3. Ordnung Grenzfrequenz 30 Hz, Sperrfrequenz 100 Hz,
% Toleranz im Durchlassbereich -1 dB, Toleranz im 
% Sperrlassbereich -25 dB
%
% Autor: Prof. Dr. Ottmar Beucher
%        HS Karlsruhe
% Version: 1.2
% Datum: 30.10.2014/22.05.2018

                % Zhlerkoeffizienten von H(s)
B = [1];
                % Nennerkoeffizienten von H(s)
A = [.7598e-7, 0.3588e-4, .8471e-2, 1];

                % Frequenzvektor von 0 bis 120 Hz
                % in rad pro sec
frq = (0:0.1:120);
omega = 2*pi*frq;

                % Frequenz und Phasengang im Intervall
                % 0 bis 120 Hz, Frequenzabstand 0.1 Hz
[betrag,phase] = bode(B,A,omega);
betrag = betrag(:);
phase = phase(:);

                % bertragungsfunktion in logarithmischer
                % Darstellung (nur Amplitudengang)
semilogx(frq, 20*log10(betrag), 'b', 'Linewidth', 3);
axis([0,120,-35,2])
grid
xlabel('Frequenz / Hz');
ylabel('|H(j\omega)|');









