% Script uebGLZ.m
%
% Aufruf: uebGLZ
%
% Berechnungen zu bung 62 zur Bestimmung
% der Gruppenlaufzeit eines LTI-Systems (Filters)
%
% Autor: Prof. Dr. Ottmar Beucher
%        HS Karlsruhe
% Version: 1.2
% Datum: 30.10.2014/22.05.2018

% Definition der bertragungsfunktion im
% Bildbereich
s = tf('s');
H = (s-1)/(s+1);

% Definition des Frequenzbereichs
domega = 0.01;
omega = (0:domega:10);

% Aufruf der Funktion bode
[Ampl, Phs] = bode(H,omega);

% Bestimmung de Phasengangs
Phase = Phs(:)*2*pi/360;

% Numerische Ableitung des Phasengangs
% da die numerische Ableitungsfunktion
% diff den Vektor um ein Element verkrzt
% wird Phase am Anfang durch einen sinnvollen
% Wert ergnzt. Dazu wird die "Ableitung"
% des nchsten Punktes verwendet
dp = Phase(1)-Phase(2);
Ph = [Phase(1)+dp;Phase];

% numerische Ableitung
domPhase = diff(Ph)/domega;

% Numerische Bestimmung der Gruppenlaufzeit
tgnum = -domPhase;

% Theoretische Formel fr die Gruppenlaufzeit
tg = 2./(omega.^2+1);

% Vergleich der beiden Vektoren
tg = tg';
[tg(1:20),tgnum(1:20)]

% Plot der beiden Ergebnisse
plot(omega, tg, 'b', omega, tgnum, 'r--', 'LineWidth',2)
xlabel('Frequenz/rad/s')
ylabel('t_g(\omega)/s')
grid