% Script uebHs1.m
%
% Aufruf: uebHs1
%
% Berechnungen zu bung 30 zur Bestimmung
% der bertragungsfunktion im Bildbereich eines LTI-Systems
% und anderer Kenngren des Systems
%
% Autor: Prof. Dr. Ottmar Beucher
%        HS Karlsruhe
% Version: 1.2
% Datum: 18.10.2014/22.05.2018

% Teilaufgabe (a)
s = tf('s')

% bertragungsfunktionen der Blcke
H1 = 1 + 1/(10*s)+s/2
H2 = 1/(0.5*s+1)*(1/s)

% Vorwrtszweig berechnen
Hvor = series(H1,H2)

% Rckkopplung und Gesamt-bertragungs-
% funktion H berechnen
H3 = 2/(0.1*s+1)
H = feedback(Hvor,H3,-1)

% Mit der Funktion minreal ggf. vereinfachen
H = minreal(H)

% Teilaufgabe (b)
syms p
% Definition der bertragungsfunktionen
H1 = 1 + 1/(10*p)+p/2
H2 = 1/(0.5*p+1)*(1/p)
H3 = 2/(0.1*p+1)

% Definition der Gesamt-bertragungsfunktion
Hp = H1*H2/(1+H1*H2*H3)

% Ggf. Vereinfachen mit simplify
Hp = simplify(Hp)

% Ggf. lesbarere Ausgabe mit pretty
pretty(Hp)

% Teilaufgabe (c)
% Bestimmung der Impuls- und Sprungantwort
H

% Impulsantwort bestimmen
zeit = (0:0.01:5);
[impant,t]=impulse(H,zeit);

% Sprungantwort bestimmen
[spant,t]=step(H,zeit);

% Antworten grafisch darstellen
plot(t,impant,'k',t,spant,'b','LineWidth',3)
grid
xlabel('Zeit')
ylabel('Ampl.')


% Teilaufgabe (d)
% Bestimmung des Endwertes der Sprungantwort
grosserZeitwert = 100;
santw =step(H,grosserZeitwert);
endwert = santw(end)
    
% Teilaufgabe (e)
% Stabilittsprfung
pole(H)

