% Script uebHs2.m
%
% Aufruf:     uebHs2
%
% Berechnungen zu bungsaufgabe 33 zur Bestimmung
% der bertragungsfunktion im Bildbereich eines LTI-Systems
% und anderer Kenngren des Systems
%
% Autor: Prof. Dr. Ottmar Beucher
%        HS Karlsruhe
% Version: 2.2
% Datum: 18.10.2014/22.05.2018

s = tf('s')
 
% bertragungsfunktion im Bildbereich
H = 1/(s^2-3*s+2)

% Numerische Berechnung der Impulsantwort
t = (0:0.01:1);
[iant,zeit] = impulse(H,t);

% Numerische Berechnung der Sprungantwort
[sant,zeit] = step(H,t);

% Vergleich mit der theoretischen Lsung
% (Impulsantwort)
h = exp(2*t)-exp(t);
plot(t,iant,'r.',t,h,'b--', 'LineWidth',3)
grid
xlabel('Zeit/s')
ylabel('Ampl.')
title('Theoretische und simulierte Impulsantwort')
[iant(1:10),(h(1:10))']

ys = (1/2)*exp(2*t)-exp(t)+1/2;
figure
plot(t,sant,'r.',t,ys,'b--', 'LineWidth',3)
grid
xlabel('Zeit/s')
ylabel('Ampl.')
title('Theoretische und simulierte Sprungantwort')
[sant(1:10),(ys(1:10))']

% Bestimmung einer Zustandsraumdarstellung
ZRD = ss(H)