% Script uebHs3.m
%
% Aufruf:     uebHs3
%
% Berechnungen zur bungsaufgabe 34 zur Bestimmung
% der bertragungsfunktion im Bildbereich eines LTI-Systems
% und anderer Kenngren des Systems
%
% Autor: Prof. Dr. Ottmar Beucher
%        HS Karlsruhe
% Version: 2.2
% Datum: 18.10.2014/22.05.2018 

s = tf('s')
 
% bertragungsfunktion im Bildbereich
H = (s+1)/(s^2+2*s-1)

% Numerische Berechnung der Impulsantwort
t = (0:0.1:5);
[iant,~] = impulse(H,t);

% Numerische Berechnung der Sprungantwort
[sant,zeit] = step(H,t);

% Vergleich mit der theoretischen Lsung
h = exp(-t).*cosh(sqrt(2)*t);
figure
plot(t,iant,'r-.',t,h,'b--', 'LineWidth',3)  
xlabel('Zeit/s')
ylabel('Ampl.')
title('Theoretische und simulierte Impulsantwort')
grid
[iant(1:10),(h(1:10))']

ys =  1/(2*(sqrt(2)-1))*exp((sqrt(2)-1)*t)...
      -1/(2*(sqrt(2)+1))*exp(-(sqrt(2)+1)*t)...
      - 1;
figure
plot(t,sant,'r-.',t,ys,'b--', 'LineWidth',3)    
grid
xlabel('Zeit/s')
ylabel('Ampl.')
title('Theoretische und simulierte Sprungantwort')
[sant(1:10),(ys(1:10))']

% Bestimmung einer Zustandsraumdarstellung
ZRD = ss(H)


% Systemmatrix theoretisch berechnet
A =[ 0 , 1; 1 , -2]

% Systemmatrix mit MATLAB berechnet
a = ZRD.a

% Jordansche Normalformen beider Matrizen
[VA, JA] = jordan(A)
[Va, Ja] = jordan(a)

% Definition einer Pransformationsmatrix P
P = Va*inv(VA)

% Probe:
P*A*inv(P)
a



