% Script uebHs5.m
%
% Aufruf:     uebHs5
%
% Berechnungen zur bungsaufgabe 37 zur Bestimmung
% der bertragungsfunktion im Bildbereich des Viertelfahrzeugmodells
% und anderer Kenngren des Systems
%
% Autor: Prof. Dr. Ottmar Beucher
%        HS Karlsruhe
% Version: 1.2
% Datum: 19.10.2014/22.05.2018

% Definition der Parameter (siehe init_viertelkfzDGL4.m)
% Werte nach Steffani (www.steffani.de/hfst/simulation/folie.pdf)
mA = 186;         % Masse A (Aufbau in Kg)
mR = 41;          % Masse R (Rad in Kg)
cA = 41.1*10^3;   % Feder 1 (Aufbau in N/m)
cR = 380*10^3;    % Feder 2 (Rad in N/m)
d = 25.0*10^2;    % Dmpfung (Aufbau in Ns/m)

% davon abgeleitete Gren (s. Lehrbuch)
a1 = -cA/mA;
a2 = -d/mA;
b1 = cA/mR;
b2 = d/mR;
gamma = cR/mR;

% Definition der Zustandsmatrizen
A = [0, 0, 1, 0;
     0, 0, 0, 1;
     a1, -a1, a2, -a2;
     b1, -b1-gamma, b2, -b2]
 
B = [0; 0; 0; gamma]

C = [1, 0, 0, 0]

D = 0

% Definition eines Zustandsraumobjekts
ZRD = ss(A,B,C,D)

% Bestimmung der bertragungsfunktion im
% Bildbereich
H = tf(ZRD)

% Bestimmung der Koeffizienten der Differentialgleichung
% (Zahlformat in preferences auf long umstellen!)
get(H);
Nennerkoeffizienten = (H.den{1})'
Zaehlerkoeffizienten = (H.num{1})'

