% Skript uebImpantConv.m
%
% Aufruf: uebImpantConv
%
% Lsung zu bung 26 Lehrbuch 
% "Signale und Systeme - Theorie,Simulation,Anwendung"
%
% Autor: Prof. Dr. Ottmar Beucher
%        HS Karlsruhe
% Version: 1.2
% Datum: 30.09.2014/22.05.2018

endt = 20;                 % Lnge Zeitausschnitt
dt = 0.01;                 % Diskretisierungsschrittweite
t = (-endt:dt:endt);       % Zeitauschnitt
h = (t>=0).*t.*exp(-t);    % Impulsantwort
x = exp(-abs(t));          % Eingangssignal

y = conv(h,x)*dt;          % Nherung des Faltungsintegrals
                           % (beachte dt muss eingerechnet werden!)

ct = (-2*endt:dt:2*endt);  % Zeitbereich Faltung

                           % Exakter Wert der Systemantwort laut
                           % berechneter Formel
yexakt= (1/4)*(exp(-abs(ct)).*(ct<0)+...
        (ct>=0).*exp(-ct).*(2*ct.^2+2*ct+1));

                           % Vergleichsplot
subplot(121)
plot(ct, yexakt,'b', 'LineWidth',3)
grid
axis([-10,10,0,0.5])
xlabel('Zeit /s')
ylabel('y(t) exakt')

subplot(122)
plot(ct,y,'k', 'LineWidth',3)
grid
axis([-10,10,0,0.5])
xlabel('Zeit /s')
ylabel('y(t) approximiert')
