% Skript uebfensterDFTbsp.m
%
% Aufruf:  uebfensterDFTbsp
%
% Beispiel fr die Auswirkung der Fenstertechnik
% bei Leakage. Es wird fr das Signal
%
%      cos(2*pi*3.7*t)
%
% das DFT-Dpektrum mit rechteckgefensterten Daten
% mit DFT-Spektren verglichen, bei denen zuvor die Daten 
% Blackman- und Hanning-gefenstert wurden.
%
% Autor: Prof. Dr. Ottmar Beucher
%        HS Karlsruhe
% Version: 1.2
% Datum: 15.11.2014/23.05.2018

N = 32;                     % Fensterlnge festlegen
T = 1/16; fa = 1/T;         % Abtastintervall/rate festlegen
t = (0:T:(N-1)*T);          % Abtastzeitpunkte festlegen
frq = (0:fa/N:(N-1)*fa/N);  % Frequenzvektor festlegen
fn = cos(2*pi*3.7*t);       % Abtastwerte einer Cosinusschwingung mit
                            % Frequenz 3.7 Hz bestimmen
Spec = fft(fn);             % fft (DFT) berechnen

%%% Spektrum darstellen
figure                      % Plot des Rechteck-Fensters        
stem(frq,abs(Spec),'k','LineWidth',3);  
axis([0,16,0,14])          % Grafikachsen anpassen
grid
xlabel('Frequenz/Hz');
ylabel('|DFT|');
title('Amplitudenspektrum bei Verwendung des Rechteck-Fensters');

% DFT mit Blackman-Fensterung berechnen
Spec = fft(fn.*(blackman(N)'));

%%% Spektrum darstellen
figure                      % Plot des Rechteck-Fensters        
stem(frq,abs(Spec),'b','LineWidth',3);  
axis([0,16,0,8])          % Grafikachsen anpassen
grid
xlabel('Frequenz/Hz');
ylabel('|DFT|');
title('Amplitudenspektrum bei Verwendung des Blackman-Fensters');


% DFT mit Hanning-Fensterung berechnen
Spec = fft(fn.*(hanning(N)'));

%%% Spektrum darstellen
figure                      % Plot des Rechteck-Fensters        
stem(frq,abs(Spec),'r','LineWidth',3);  
axis([0,16,0,8])          % Grafikachsen anpassen
grid
xlabel('Frequenz/Hz');
ylabel('|DFT|');
title('Amplitudenspektrum bei Verwendung des Hanning-Fensters');
