model SIRModellEndemieImpfung
//S->I->R (Stoppzeit =864.000.000 sec = 10.0000 d)
  parameter Real a=0.00002/3600; //Infektionsrate pro sec a=0.00002 1/h
  parameter Real b=0.01/3600; //Heilungsrate pro sec b=0.01 1/h
  parameter Real d=0.00005/3600; //Sterbe- und Geburtenrate d=0.00005 1/h
  parameter Real p=0.9; //Anteil der geimpften Neugeborenen
  parameter Real q=1-p; //Anteil der nicht geimpften Neugeborenen
  Real S(start=990); //Infizierbare Personen
  Real I(start=10); //Infizierte Personen
  Real R(start=0); //Immune Personen
equation
  der(S)=-a*S*I+d*q*(S+R+I)-d*S;
  der(I)=a*S*I-b*I-d*I;
  der(R)=b*I-d*R+d*p*(S+R+I);
annotation(
    experiment(StartTime = 0, StopTime = 864000000, Tolerance = 1e-10, Interval = 1.728e+06));end SIRModellEndemieImpfung;
