model bakterium
  parameter Real kX=0.000241389 "Maximale spezifische Wachstumsrate";
  parameter Real YXN=6.383 "Ausbeute an g Biomasse pro g Stickstoff";
  parameter Real YXS=0.113 "Ausbeute an g Biomasse pro g Kohlenstoff";
  parameter Real mS=0.000050833 "Aufrechterhaltungskoeffizient";
  parameter Real kP=0.000003806 "Maximale spezifische Produktionsrate";
  parameter Real X0=0.057 "Biomassekonzentration bei t=0";
  parameter Real N0=0.25 "Stickstoffkonzentration bei t=0";
  parameter Real S0=40 "Kohlenstoffkonzentration bei t=0";
  parameter Real P0=0 "Xanthankonzentration bei t=0";
  Real X(start=X0) "Biomassekonzentration";
  Real N(start=N0) "Stickstoffkonzentration";
  Real S(start=S0) "Kohlenstoffkonzentration";
  Real P(start=P0) "Xanthankonzentration";
equation
  der(X) = kX/YXN*X*(N0*YXN+X0-X);
  der(N) = -1/YXN*der(X);
  der(S) = -1/YXS*der(X)-mS*X;
  der(P) = kP*S*X;
annotation(
    experiment(StartTime = 0, StopTime = 252000, Tolerance = 1e-06, Interval = 504));end bakterium;
