model bakterium_temp
  parameter Real YXN = 6.383 "Ausbeute an g Biomasse pro g Stickstoff";
  parameter Real YXS = 0.113 "Ausbeute an g Biomasse pro g Kohlenstoff";
  parameter Real mS = 0.000050833 "Aufrechterhaltungskoeffizient";
  parameter Real kP = 0.000003806 "Maximale spezifische Produktionsrate";
  parameter Real X0 = 0.057 "Biomassekonzentration bei t=0";
  parameter Real N0 = 0.25 "Stickstoffkonzentration bei t=0";
  parameter Real S0 = 40 "Kohlenstoffkonzentration bei t=0";
  parameter Real P0 = 0 "Xanthankonzentration bei t=0";
  parameter Real a = 0.0003741 "Steigung der Regressionsgerade";
  parameter Real T0 = 6.867 "konzeptionelle Temperatur";
  parameter Real T = 22 "Temperatur in °C";
  Real X(start = X0) "Biomassekonzentration";
  Real N(start = N0) "Stickstoffkonzentration";
  Real S(start = S0) "Kohlenstoffkonzentration";
  Real P(start = P0) "Xanthankonzentration";
  parameter Real muX=(a * (T - T0))^2 "Maximale spezifische Wachstumsrate";
equation
  der(X) = muX *X* (1 - X / (N0 * YXN + X0));
  der(N) = -1 / YXN * der(X);
  der(S) = (-1 / YXS * der(X)) - mS * X;
  der(P) = kP * S * X;
  annotation(
    experiment(StartTime = 0, StopTime = 252000, Tolerance = 1e-06, Interval = 504));
end bakterium_temp;
