model wechselstromnetzwerk
  Modelica.Electrical.Analog.Basic.Resistor R1(R = 20) annotation(
    Placement(visible = true, transformation(origin = {-20, -28}, extent = {{10, -10}, {-10, 10}}, rotation = 0)));
  Modelica.Electrical.Analog.Basic.Resistor R2(R = 10) annotation(
    Placement(visible = true, transformation(origin = {64, 12}, extent = {{-10, -10}, {10, 10}}, rotation = -90)));
  Modelica.Electrical.Analog.Basic.Inductor L(L = 5) annotation(
    Placement(visible = true, transformation(origin = {20, 12}, extent = {{10, -10}, {-10, 10}}, rotation = 90)));
  Modelica.Electrical.Analog.Basic.Ground g annotation(
    Placement(visible = true, transformation(origin = {-60, -38}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  Modelica.Electrical.Analog.Sources.SineVoltage U0(V = 10, freqHz = 0.32) annotation(
    Placement(visible = true, transformation(origin = {-60, 12}, extent = {{10, -10}, {-10, 10}}, rotation = 90)));
equation
  connect(U0.p, L.p) annotation(
    Line(points = {{-60, 22}, {-60, 52}, {20, 52}, {20, 22}}, color = {0, 0, 255}));
  connect(g.p, U0.n) annotation(
    Line(points = {{-60, -28}, {-60, 2}}, color = {0, 0, 255}));
  connect(R1.n, g.p) annotation(
    Line(points = {{-30, -28}, {-60, -28}}, color = {0, 0, 255}));
  connect(L.n, R1.p) annotation(
    Line(points = {{20, 2}, {20, -28}, {-10, -28}}, color = {0, 0, 255}));
  connect(L.p, R2.p) annotation(
    Line(points = {{20, 22}, {20, 52}, {64, 52}, {64, 22}}, color = {0, 0, 255}));
  connect(R2.n, L.n) annotation(
    Line(points = {{64, 2}, {64, -28}, {20, -28}, {20, 2}}, color = {0, 0, 255}));
  annotation(
    uses(Modelica(version = "3.2.2")));
end wechselstromnetzwerk;
