function [x,y]=rungekutta(N,f,a,b,ya)
    h=(b-a)/(N-1); 
    x=a:h:b;        
    y(1)=ya;
    for i=2:N
        k1=f(x(i-1),y(i-1));
        k2=f(x(i-1)+h/2,y(i-1)+h/2*k1);
        k3=f(x(i-1)+h/2,y(i-1)+h/2*k2);
        k4=f(x(i-1)+h,y(i-1)+h*k3);
        y(i)=y(i-1)+h*(k1/6+k2/3+k3/3+k4/6);
    end
end