(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 9.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     14121,        412]
NotebookOptionsPosition[     13724,        395]
NotebookOutlinePosition[     14066,        410]
CellTagsIndexPosition[     14023,        407]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
   RowBox[{
   "Differentialgleichungen", " ", "f\[UDoubleDot]r", " ", "Einsteiger", " ", 
    "Kapitel", " ", "2"}], ":", " ", 
   RowBox[{"Mathematica", "-", 
    RowBox[{"Code", " ", "und", " ", "Programme"}]}]}], "*)"}]], "Input",
 CellChangeTimes->{{3.761503651038785*^9, 3.761503719111705*^9}, {
  3.7705745932929335`*^9, 3.7705745939013343`*^9}}],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"StreamPlot", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "y"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", 
      RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"y", ",", 
      RowBox[{"-", "3"}], ",", "3"}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.761587081938431*^9, 3.7615871245109053`*^9}, {
  3.762432058208027*^9, 3.7624321242947435`*^9}, {3.762432158289203*^9, 
  3.7624321591628046`*^9}}],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       SuperscriptBox["\[ExponentialE]", "x"], ",", 
       RowBox[{"-", 
        SuperscriptBox["\[ExponentialE]", "x"]}], ",", 
       RowBox[{"2", 
        SuperscriptBox["\[ExponentialE]", "x"]}], ",", 
       RowBox[{
        RowBox[{"-", "2"}], 
        SuperscriptBox["\[ExponentialE]", "x"]}], ",", 
       RowBox[{"3", 
        SuperscriptBox["\[ExponentialE]", "x"]}], ",", 
       RowBox[{
        RowBox[{"-", "3"}], 
        SuperscriptBox["\[ExponentialE]", "x"]}], ",", 
       RowBox[{"0.5", 
        SuperscriptBox["\[ExponentialE]", "x"]}], ",", 
       RowBox[{
        RowBox[{"-", "0.5"}], 
        SuperscriptBox["\[ExponentialE]", "x"]}], ",", 
       RowBox[{"0.25", 
        SuperscriptBox["\[ExponentialE]", "x"]}], ",", 
       RowBox[{"0.25", 
        SuperscriptBox["\[ExponentialE]", "x"]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "3"}], ",", "3"}], "}"}]}], ",", 
     RowBox[{"AspectRatio", "\[Rule]", "Automatic"}]}], "]"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Show", "[", 
    RowBox[{
     RowBox[{"StreamPlot", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "y"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"y", ",", 
         RowBox[{"-", "3"}], ",", "3"}], "}"}]}], "]"}], ",", 
     RowBox[{"Plot", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["\[ExponentialE]", "x"], ",", 
         RowBox[{"-", 
          SuperscriptBox["\[ExponentialE]", "x"]}], ",", 
         RowBox[{"2", 
          SuperscriptBox["\[ExponentialE]", "x"]}], ",", 
         RowBox[{
          RowBox[{"-", "2"}], 
          SuperscriptBox["\[ExponentialE]", "x"]}], ",", 
         RowBox[{"3", 
          SuperscriptBox["\[ExponentialE]", "x"]}], ",", 
         RowBox[{
          RowBox[{"-", "3"}], 
          SuperscriptBox["\[ExponentialE]", "x"]}], ",", 
         RowBox[{"0.5", 
          SuperscriptBox["\[ExponentialE]", "x"]}], ",", 
         RowBox[{
          RowBox[{"-", "0.5"}], 
          SuperscriptBox["\[ExponentialE]", "x"]}], ",", 
         RowBox[{"0.25", 
          SuperscriptBox["\[ExponentialE]", "x"]}], ",", 
         RowBox[{"0.25", 
          SuperscriptBox["\[ExponentialE]", "x"]}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
       RowBox[{"PlotRange", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "3"}], ",", "3"}], "}"}]}], ",", 
       RowBox[{"AspectRatio", "\[Rule]", "Automatic"}]}], "]"}]}], 
    "]"}]}]}]], "Input",
 CellChangeTimes->{
  3.7615871637137747`*^9, {3.761587230809492*^9, 3.7615872337578974`*^9}, {
   3.762777422273387*^9, 3.76277744664063*^9}}],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"2.2", ".2"}], "*)"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"DSolve", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       SuperscriptBox["y", "\[Prime]",
        MultilineFunction->None], "[", "x", "]"}], "\[Equal]", 
      RowBox[{"3", 
       RowBox[{"y", "[", "x", "]"}]}]}], ",", 
     RowBox[{"y", "[", "x", "]"}], ",", "x"}], "]"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"DSolve", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       SuperscriptBox["y", "\[Prime]",
        MultilineFunction->None], "[", "x", "]"}], "\[Equal]", 
      RowBox[{
       RowBox[{"3", 
        RowBox[{"y", "[", "x", "]"}]}], "+", "x"}]}], ",", 
     RowBox[{"y", "[", "x", "]"}], ",", "x"}], "]"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"2.2", ".3"}], "*)"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"DSolve", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       SuperscriptBox["u", "\[Prime]",
        MultilineFunction->None], "[", "t", "]"}], "\[Equal]", 
      RowBox[{
       RowBox[{
        FractionBox["1", "t"], 
        RowBox[{"u", "[", "t", "]"}]}], "+", 
       SuperscriptBox["t", "2"]}]}], ",", 
     RowBox[{"u", "[", "t", "]"}], ",", "t"}], "]"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"FullSimplify", "[", 
    RowBox[{"DSolve", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{
           SuperscriptBox["u", "\[Prime]",
            MultilineFunction->None], "[", "t", "]"}], "+", 
          RowBox[{"2", "t", " ", 
           RowBox[{"u", "[", "t", "]"}]}]}], "\[Equal]", 
         SuperscriptBox["t", "3"]}], ",", 
        RowBox[{
         RowBox[{"u", "[", "0", "]"}], "\[Equal]", "1"}]}], "}"}], ",", 
      RowBox[{"u", "[", "t", "]"}], ",", "t"}], "]"}], "]"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"2.3", ".3"}], "*)"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"DSolve", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"x", " ", 
        RowBox[{
         SuperscriptBox["y", "\[Prime]",
          MultilineFunction->None], "[", "x", "]"}]}], "-", 
       RowBox[{"4", 
        RowBox[{"y", "[", "x", "]"}]}], "+", 
       RowBox[{"x", " ", 
        SuperscriptBox[
         RowBox[{"y", "[", "x", "]"}], "2"]}]}], "\[Equal]", "0"}], ",", 
     RowBox[{"y", "[", "x", "]"}], ",", "x"}], "]"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"2.4", ".2"}], "*)"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     SubscriptBox["Q", "C"], "[", "t_", "]"}], ":=", 
    RowBox[{"3", "*", 
     SuperscriptBox["10", 
      RowBox[{"-", "4"}]], 
     RowBox[{"(", 
      RowBox[{"1", "-", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"-", "t"}]]}], ")"}]}]}], "\[IndentingNewLine]", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{
      SubscriptBox["Q", "C"], "[", "t", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "10"}], "}"}], ",", " ", 
     RowBox[{"AxesLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
       "\"\<t in s\>\"", ",", 
        "\"\<\!\(\*SubscriptBox[\(Q\), \(C\)]\)(t) in C\>\""}], "}"}]}]}], 
    "]"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     SubscriptBox["Q", "C"], "[", "t_", "]"}], ":=", 
    RowBox[{"3", "*", 
     SuperscriptBox["10", 
      RowBox[{"-", "4"}]], 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"-", "t"}]]}]}], "\[IndentingNewLine]", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{
      SubscriptBox["Q", "C"], "[", "t", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "10"}], "}"}], ",", " ", 
     RowBox[{"AxesLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
       "\"\<t in s\>\"", ",", 
        "\"\<\!\(\*SubscriptBox[\(Q\), \(C\)]\)(t) in C\>\""}], "}"}]}]}], 
    "]"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"2.4", ".3"}], "*)"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"DSolve", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"i", "'"}], "[", "t", "]"}], "+", 
       RowBox[{
        FractionBox["R", "L"], 
        RowBox[{"i", "[", "t", "]"}]}]}], "\[Equal]", 
      RowBox[{
       FractionBox["U0", "L"], 
       RowBox[{"Sin", "[", 
        RowBox[{"omega", " ", "t"}], "]"}]}]}], ",", 
     RowBox[{"i", "[", "t", "]"}], ",", "t"}], "]"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"i", "[", "t_", "]"}], ":=", 
    RowBox[{
     RowBox[{"5.92", 
      RowBox[{"Sin", "[", 
       RowBox[{"314", "t"}], "]"}]}], "-", 
     RowBox[{"1.86", 
      RowBox[{"Cos", "[", 
       RowBox[{"314", "t"}], "]"}]}], "+", 
     RowBox[{"1.86", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{"-", "1000"}], "t"}]]}]}]}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"i", "[", "t", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "0.05"}], "}"}], ",", 
     RowBox[{"AxesLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"\"\<t in s\>\"", ",", "\"\<I(t) in A\>\""}], "}"}]}]}], "]"}],
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"i", "[", "t", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "0.005"}], "}"}], ",", 
     RowBox[{"AxesLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"\"\<t in s\>\"", ",", "\"\<I(t) in A\>\""}], "}"}]}]}], "]"}],
    "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"2.4", ".4"}], "*)"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"Solve", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"100", "-", 
       RowBox[{"80", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          FractionBox[
           RowBox[{"-", "1"}], "20"], "t"}]]}]}], "\[Equal]", "80"}], ",", 
     "t", ",", "Reals"}], "]"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"data", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "1.6"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"27", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"50", ",", "2.53"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"60", ",", "3.03"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"70", ",", "3.69"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"80", ",", "4.45"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"90", ",", "5.32"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"100", ",", "6.13"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"110", ",", "6.92"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"115", ",", "7.35"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"116", ",", "7.44"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"nlm", "=", 
    RowBox[{"NonlinearModelFit", "[", 
     RowBox[{"data", ",", 
      RowBox[{
       RowBox[{"a", "/", 
        RowBox[{"(", 
         RowBox[{"1", "+", 
          RowBox[{"b", "*", 
           RowBox[{"Exp", "[", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"-", "c"}], ")"}], "*", "x"}], "]"}]}]}], ")"}]}], "+", 
       "d"}], ",", 
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], 
     "]"}]}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"g", "[", "x_", "]"}], ":=", 
    RowBox[{"1.4877", "+", 
     RowBox[{"8.0929", "/", 
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{"56.1089", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{
           RowBox[{"-", "0.0434"}], "x"}]]}]}], ")"}]}]}]}]}]}]], "Input",
 CellChangeTimes->{{3.761587222619478*^9, 3.761587227658287*^9}, {
   3.761587260309144*^9, 3.7615872704335623`*^9}, {3.7615873135052376`*^9, 
   3.761587524698408*^9}, {3.7615875806089067`*^9, 3.7615876532270346`*^9}, {
   3.7615877406183877`*^9, 3.761587757232417*^9}, 3.761587811692113*^9, {
   3.7615878739518223`*^9, 3.7615878867126446`*^9}, {3.761587920642704*^9, 
   3.7615879267267146`*^9}, {3.7615879714207935`*^9, 3.761588103989826*^9}, {
   3.7615882002731953`*^9, 3.761588495706514*^9}, {3.7615885588866253`*^9, 
   3.7615885736130505`*^9}, {3.7627774494194345`*^9, 3.762777476859883*^9}, {
   3.7627775126951456`*^9, 3.7627775289669743`*^9}, {3.762777562820034*^9, 
   3.7627776649740133`*^9}, {3.7627788480318947`*^9, 3.762778882151155*^9}}],

Cell[BoxData[
 RowBox[{"gmax", ":=", 
  RowBox[{"Limit", "[", 
   RowBox[{
    RowBox[{"g", "[", "x", "]"}], ",", 
    RowBox[{"x", "\[Rule]", "Infinity"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.76158859033628*^9, 3.761588612394719*^9}}]
},
WindowSize->{707, 867},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
FrontEndVersion->"9.0 for Microsoft Windows (64-bit) (January 25, 2013)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[557, 20, 394, 9, 52, "Input"],
Cell[954, 31, 520, 14, 52, "Input"],
Cell[1477, 47, 3085, 87, 142, "Input"],
Cell[4565, 136, 8910, 249, 1050, "Input"],
Cell[13478, 387, 242, 6, 31, "Input"]
}
]
*)

(* End of internal cache information *)
