(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 9.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     16422,        510]
NotebookOptionsPosition[     15940,        491]
NotebookOutlinePosition[     16282,        506]
CellTagsIndexPosition[     16239,        503]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
   RowBox[{
   "Differentialgleichungen", " ", "f\[UDoubleDot]r", " ", "Einsteiger", " ", 
    "Kapitel", " ", "3"}], ":", " ", 
   RowBox[{"Mathematica", "-", 
    RowBox[{"Code", " ", "und", " ", "Programme"}]}]}], "*)"}]], "Input",
 CellChangeTimes->{{3.761503651038785*^9, 3.761503719111705*^9}, {
  3.761503782203617*^9, 3.7615037825936174`*^9}, {3.770574576110303*^9, 
  3.770574576781104*^9}}],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"3.1", ".1"}], "*)"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"DSolve", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"y", "''"}], "[", "x", "]"}], "-", 
       RowBox[{"9", 
        RowBox[{"y", "[", "x", "]"}]}]}], "\[Equal]", "0"}], ",", 
     RowBox[{"y", "[", "x", "]"}], ",", "x"}], "]"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"DSolve", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"y", "''"}], "[", "x", "]"}], "+", 
       RowBox[{"4", 
        RowBox[{
         RowBox[{"y", "'"}], "[", "x", "]"}]}], "+", 
       RowBox[{"4", 
        RowBox[{"y", "[", "x", "]"}]}]}], "\[Equal]", "0"}], ",", 
     RowBox[{"y", "[", "x", "]"}], ",", "x"}], "]"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"DSolve", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"y", "''"}], "[", "x", "]"}], "+", 
       RowBox[{"6", 
        RowBox[{
         RowBox[{"y", "'"}], "[", "x", "]"}]}], "+", 
       RowBox[{"45", 
        RowBox[{"y", "[", "x", "]"}]}]}], "\[Equal]", "0"}], ",", 
     RowBox[{"y", "[", "x", "]"}], ",", "x"}], "]"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"DSolve", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"4", 
          RowBox[{
           RowBox[{"y", "''"}], "[", "x", "]"}]}], "-", 
         RowBox[{"9", 
          RowBox[{"y", "[", "x", "]"}]}]}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{"y", "[", "0", "]"}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{"y", "'"}], "[", "0", "]"}], "\[Equal]", "1"}]}], "}"}], ",", 
     RowBox[{"y", "[", "x", "]"}], ",", "x"}], "]"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"FullSimplify", "[", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "/", "3"}], ")"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        RowBox[{"E", "^", 
         RowBox[{"(", 
          RowBox[{"3", "*", "x"}], ")"}]}]}], ")"}], "/", 
      RowBox[{"E", "^", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"3", "*", "x"}], ")"}], "/", "2"}], ")"}]}]}]}], "]"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"3.2", ".1"}], "*)"}]}]}]], "Input",
 CellChangeTimes->{{3.7616572768658075`*^9, 3.761657559383704*^9}, {
  3.762777761326783*^9, 3.762777817472282*^9}, {3.76277877704877*^9, 
  3.7627787803111763`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"LaplaceTransform", "[", 
   RowBox[{
    RowBox[{"E", "^", 
     RowBox[{"(", 
      RowBox[{"a", "*", "t"}], ")"}]}], ",", "t", ",", "s"}], "]"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"(*", "3.3", "*)"}]}]}], "Input",
 CellChangeTimes->{{3.761657608714991*^9, 3.761657635922439*^9}, {
   3.7627778355859137`*^9, 3.762777841763525*^9}, 3.762778783056781*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"DSolve", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"u", "''"}], "[", "t", "]"}], "-", 
      RowBox[{"5", 
       RowBox[{
        RowBox[{"u", "'"}], "[", "t", "]"}]}], "+", 
      RowBox[{"6", 
       RowBox[{"u", "[", "t", "]"}]}]}], "\[Equal]", 
     RowBox[{"t", "*", 
      RowBox[{"E", "^", "t"}]}]}], ",", 
    RowBox[{"u", "[", "t", "]"}], ",", "t"}], "]"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", "3.4", "*)"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"DSolve", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"y", "''"}], "[", "x", "]"}], "-", 
        RowBox[{"9", 
         RowBox[{"y", "[", "x", "]"}]}]}], "\[Equal]", "0"}], ",", 
      RowBox[{
       RowBox[{"y", "[", "0", "]"}], "\[Equal]", "1"}], ",", 
      RowBox[{
       RowBox[{"y", "[", "1", "]"}], "\[Equal]", "2"}]}], "}"}], ",", 
    RowBox[{"y", "[", "x", "]"}], ",", "x"}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Solve", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"C1", "+", "C2"}], "\[Equal]", "1"}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"C1", "*", 
         RowBox[{"E", "^", "3"}]}], "+", 
        RowBox[{"C2", "/", 
         RowBox[{"E", "^", "3"}]}]}], "\[Equal]", "2"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"C1", ",", "C2"}], "}"}]}], "]"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"3.6", ".2"}], "*)"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"DSolve", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"x", "''"}], "[", "t", "]"}], "+", 
        RowBox[{"4", 
         RowBox[{
          RowBox[{"x", "'"}], "[", "t", "]"}]}], "+", 
        RowBox[{"60", 
         RowBox[{"x", "[", "t", "]"}]}]}], "\[Equal]", "0"}], ",", 
      RowBox[{
       RowBox[{"x", "[", "0", "]"}], "\[Equal]", "0.1"}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"x", "'"}], "[", "0", "]"}], "\[Equal]", "0"}]}], "}"}], ",", 
    RowBox[{"x", "[", "t", "]"}], ",", "t"}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"DSolve", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"x", "''"}], "[", "t", "]"}], "+", 
        RowBox[{"4", 
         RowBox[{
          RowBox[{"x", "'"}], "[", "t", "]"}]}], "+", 
        RowBox[{"x", "[", "t", "]"}]}], "\[Equal]", "0"}], ",", 
      RowBox[{
       RowBox[{"x", "[", "0", "]"}], "\[Equal]", "1"}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"x", "'"}], "[", "0", "]"}], "\[Equal]", "0"}]}], "}"}], ",", 
    RowBox[{"x", "[", "t", "]"}], ",", "t"}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"DSolve", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"x", "''"}], "[", "t", "]"}], "+", 
        RowBox[{"4", 
         RowBox[{
          RowBox[{"x", "'"}], "[", "t", "]"}]}], "+", 
        RowBox[{"x", "[", "t", "]"}]}], "\[Equal]", "0"}], ",", 
      RowBox[{
       RowBox[{"x", "[", "0", "]"}], "\[Equal]", "1"}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"x", "'"}], "[", "0", "]"}], "\[Equal]", "1"}]}], "}"}], ",", 
    RowBox[{"x", "[", "t", "]"}], ",", "t"}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"DSolve", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"x", "''"}], "[", "t", "]"}], "+", 
        RowBox[{"2", 
         RowBox[{
          RowBox[{"x", "'"}], "[", "t", "]"}]}], "+", 
        RowBox[{"x", "[", "t", "]"}]}], "\[Equal]", "0"}], ",", 
      RowBox[{
       RowBox[{"x", "[", "0", "]"}], "\[Equal]", "1"}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"x", "'"}], "[", "0", "]"}], "\[Equal]", "0"}]}], "}"}], ",", 
    RowBox[{"x", "[", "t", "]"}], ",", "t"}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"DSolve", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"x", "''"}], "[", "t", "]"}], "+", 
        RowBox[{"2", 
         RowBox[{
          RowBox[{"x", "'"}], "[", "t", "]"}]}], "+", 
        RowBox[{"x", "[", "t", "]"}]}], "\[Equal]", "0"}], ",", 
      RowBox[{
       RowBox[{"x", "[", "0", "]"}], "\[Equal]", "0"}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"x", "'"}], "[", "0", "]"}], "\[Equal]", "1"}]}], "}"}], ",", 
    RowBox[{"x", "[", "t", "]"}], ",", "t"}], "]"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"3.6", ".4"}], "*)"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"x", "[", 
   RowBox[{"t_", ",", "Omega_"}], "]"}], ":=", 
  RowBox[{
   RowBox[{"0.1", 
    RowBox[{"Sin", "[", "t", "]"}]}], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"0.1", 
       RowBox[{"(", 
        RowBox[{"Cos", "[", 
         RowBox[{"Omega", " ", "t"}], "]"}], ")"}]}], "-", 
      RowBox[{"Cos", "[", "t", "]"}]}], ")"}], "/", 
    RowBox[{"(", 
     RowBox[{"1", "-", 
      RowBox[{"Omega", "^", "2"}]}], ")"}]}]}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Plot", "[", 
   RowBox[{
    RowBox[{"x", "[", 
     RowBox[{"t", ",", "0.5"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"t", ",", "0", ",", "100"}], "}"}], ",", 
    RowBox[{"AxesLabel", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"\"\<t\>\"", ",", "\"\<x(t)\>\""}], "}"}]}]}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Plot", "[", 
   RowBox[{
    RowBox[{"x", "[", 
     RowBox[{"t", ",", "0.9"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"t", ",", "0", ",", "200"}], "}"}], ",", 
    RowBox[{"AxesLabel", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"\"\<t\>\"", ",", "\"\<x(t)\>\""}], "}"}]}]}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Plot", "[", 
   RowBox[{
    RowBox[{"x", "[", 
     RowBox[{"t", ",", "1.1"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"t", ",", "0", ",", "200"}], "}"}], ",", 
    RowBox[{"AxesLabel", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"\"\<t\>\"", ",", "\"\<x(t)\>\""}], "}"}]}]}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Plot", "[", 
   RowBox[{
    RowBox[{"x", "[", 
     RowBox[{"t", ",", "2"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"t", ",", "0", ",", "50"}], "}"}], ",", 
    RowBox[{"AxesLabel", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"\"\<t\>\"", ",", "\"\<x(t)\>\""}], "}"}]}]}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"A", "=", "1"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"B", "=", "1"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   SubscriptBox["\[Omega]", "0"], "=", "10"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   SubscriptBox["\[Omega]", "1"], "=", "1"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", "t_", "]"}], ":=", 
   RowBox[{"A", " ", 
    RowBox[{"Sin", "[", 
     RowBox[{
      SubscriptBox["\[Omega]", "0"], "t"}], "]"}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"g", "[", "t_", "]"}], ":=", 
   RowBox[{"B", " ", 
    RowBox[{"Sin", "[", 
     RowBox[{
      SubscriptBox["\[Omega]", "1"], "t"}], "]"}]}]}], ";"}], "\n", 
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"f", "[", "t", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", 
     RowBox[{"-", "10"}], ",", "10"}], "}"}]}], "]"}], "\n", 
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"g", "[", "t", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", 
     RowBox[{"-", "10"}], ",", "10"}], "}"}]}], "]"}], "\n", 
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"A", " ", 
    RowBox[{"Sin", "[", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        SubscriptBox["\[Omega]", "0"], "+", 
        RowBox[{"A", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{
           SubscriptBox["\[Omega]", "1"], "t"}], "]"}]}]}], ")"}], "t"}], 
     "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", 
     RowBox[{"-", "20"}], ",", "20"}], "}"}], ",", 
   RowBox[{"PlotStyle", "->", 
    RowBox[{"RGBColor", "[", 
     RowBox[{"1", ",", "0", ",", "0"}], "]"}]}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.7616576991377506`*^9, 3.761657902746709*^9}, {
  3.7616579334183626`*^9, 3.7616580199733152`*^9}, {3.7616580514873705`*^9, 
  3.7616581371979213`*^9}, {3.761658215609659*^9, 3.761658289447589*^9}, {
  3.7616584008855853`*^9, 3.7616586365516*^9}, {3.761658720063547*^9, 
  3.7616587207655478`*^9}, {3.7627778589859548`*^9, 3.762777904041834*^9}, {
  3.7627779451333065`*^9, 3.7627779519037185`*^9}, {3.7627787848819838`*^9, 
  3.762778797424406*^9}}],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"3.6", ".6"}], "*)"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"g", " ", "=", " ", "9.81"}], ";"}], " ", "\n", 
   RowBox[{
    RowBox[{"l", " ", "=", " ", "10"}], ";"}], " ", "\n", 
   RowBox[{"s", " ", "=", " ", 
    RowBox[{"NDSolve", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"g", "*", 
             RowBox[{"Sin", "[", 
              RowBox[{"\[Phi]", "[", "t", "]"}], "]"}]}], ")"}], "/", "l"}], 
          " ", "+", " ", 
          RowBox[{
           RowBox[{
            RowBox[{"Derivative", "[", "2", "]"}], "[", "\[Phi]", "]"}], "[", 
           "t", "]"}]}], " ", "==", " ", "0"}], ",", " ", 
        RowBox[{
         RowBox[{"\[Phi]", "[", "0", "]"}], " ", "==", " ", 
         RowBox[{"Pi", "/", "4"}]}], ",", " ", "\n", "    ", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"Derivative", "[", "1", "]"}], "[", "\[Phi]", "]"}], "[", 
          "0", "]"}], " ", "==", " ", "0"}]}], "}"}], ",", " ", "\[Phi]", ",",
       " ", 
      RowBox[{"{", 
       RowBox[{"t", ",", " ", "0", ",", " ", "30"}], "}"}]}], "]"}]}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.76165881273271*^9, 3.7616588165235167`*^9}, {
   3.7627779930273905`*^9, 3.762778002871008*^9}, 3.7627788012620125`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Plot", "[", 
   RowBox[{
    RowBox[{"Evaluate", "[", 
     RowBox[{
      RowBox[{"\[Phi]", "[", "t", "]"}], "/.", "s"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"t", ",", "0", ",", "30"}], "}"}], ",", 
    RowBox[{"PlotRange", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "1"}], "}"}]}], ",", 
    RowBox[{"AxesLabel", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"\"\<t\>\"", ",", "\"\<Phi(t)\>\""}], "}"}]}]}], "]"}], 
  "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{{3.761658859363192*^9, 3.761658920237499*^9}, {
  3.762778016476232*^9, 3.762778022778643*^9}, {3.7627788051932197`*^9, 
  3.762778818610243*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"3.6", ".7"}], "*)"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{"Integrate", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"n", " ", "*", "Pi"}], ")"}], "/", "L"}], ")"}], "*", "x"}],
       "]"}], "^", "2"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "L"}], "}"}]}], "]"}]}]], "Input"]
},
WindowSize->{707, 867},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
FrontEndVersion->"9.0 for Microsoft Windows (64-bit) (January 25, 2013)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[557, 20, 441, 10, 52, "Input"],
Cell[1001, 32, 2698, 81, 312, "Input"],
Cell[3702, 115, 452, 11, 92, "Input"],
Cell[4157, 128, 9096, 280, 872, "Input"],
Cell[13256, 410, 1500, 40, 192, "Input"],
Cell[14759, 452, 697, 19, 72, "Input"],
Cell[15459, 473, 477, 16, 72, "Input"]
}
]
*)

(* End of internal cache information *)
