(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 9.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     18292,        533]
NotebookOptionsPosition[     17808,        514]
NotebookOutlinePosition[     18152,        529]
CellTagsIndexPosition[     18109,        526]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
   RowBox[{
   "Differentialgleichungen", " ", "f\[UDoubleDot]r", " ", "Einsteiger", " ", 
    "Kapitel", " ", "4"}], ":", " ", 
   RowBox[{"Mathematica", "-", 
    RowBox[{"Code", " ", "und", " ", "Programme"}]}]}], "*)"}]], "Input",
 CellChangeTimes->{{3.761503651038785*^9, 3.761503719111705*^9}, {
  3.761503782203617*^9, 3.7615037825936174`*^9}, {3.7615038373505154`*^9, 
  3.7615038378809166`*^9}, {3.770574560335675*^9, 3.770574560990876*^9}}],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"(*", "4.2", "*)"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"DSolve", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         SuperscriptBox["u", "\[Prime]",
          MultilineFunction->None], "[", "t", "]"}], "\[Equal]", 
        RowBox[{
         RowBox[{"2", " ", 
          RowBox[{"u", "[", "t", "]"}]}], "+", 
         RowBox[{"v", "[", "t", "]"}]}]}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["v", "\[Prime]",
          MultilineFunction->None], "[", "t", "]"}], "\[Equal]", 
        RowBox[{
         RowBox[{"u", "[", "t", "]"}], "+", 
         RowBox[{"2", " ", 
          RowBox[{"v", "[", "t", "]"}]}]}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"u", "[", "t", "]"}], ",", 
       RowBox[{"v", "[", "t", "]"}]}], "}"}], ",", "t"}], "]"}], "\n", 
   RowBox[{"FullSimplify", "[", 
    RowBox[{"DSolve", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          SuperscriptBox["u", "\[Prime]",
           MultilineFunction->None], "[", "t", "]"}], "\[Equal]", 
         RowBox[{
          RowBox[{"2", " ", 
           RowBox[{"u", "[", "t", "]"}]}], "+", 
          RowBox[{"v", "[", "t", "]"}]}]}], ",", 
        RowBox[{
         RowBox[{
          SuperscriptBox["v", "\[Prime]",
           MultilineFunction->None], "[", "t", "]"}], "\[Equal]", 
         RowBox[{
          RowBox[{"u", "[", "t", "]"}], "+", 
          RowBox[{"2", " ", 
           RowBox[{"v", "[", "t", "]"}]}]}]}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"u", "[", "t", "]"}], ",", 
        RowBox[{"v", "[", "t", "]"}]}], "}"}], ",", "t"}], "]"}], "]"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", "4.3", "*)"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"DSolve", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         SuperscriptBox["u", "\[Prime]",
          MultilineFunction->None], "[", "t", "]"}], "\[Equal]", 
        RowBox[{
         RowBox[{"4", " ", 
          RowBox[{"u", "[", "t", "]"}]}], "-", 
         RowBox[{"v", "[", "t", "]"}], "+", 
         SuperscriptBox["\[ExponentialE]", "t"]}]}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["v", "\[Prime]",
          MultilineFunction->None], "[", "t", "]"}], "\[Equal]", 
        RowBox[{
         RowBox[{"2", " ", 
          RowBox[{"u", "[", "t", "]"}]}], "+", 
         RowBox[{"2", " ", 
          RowBox[{"v", "[", "t", "]"}]}], "-", 
         SuperscriptBox["\[ExponentialE]", "t"]}]}], ",", 
       RowBox[{
        RowBox[{"u", "[", "0", "]"}], "\[Equal]", "1"}], ",", 
       RowBox[{
        RowBox[{"v", "[", "0", "]"}], "\[Equal]", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"u", "[", "t", "]"}], ",", 
       RowBox[{"v", "[", "t", "]"}]}], "}"}], ",", "t"}], "]"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"Simplify", "[", 
    RowBox[{"DSolve", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          SuperscriptBox["u", "\[Prime]",
           MultilineFunction->None], "[", "t", "]"}], "\[Equal]", 
         RowBox[{
          RowBox[{"4", " ", 
           RowBox[{"u", "[", "t", "]"}]}], "-", 
          RowBox[{"v", "[", "t", "]"}], "+", 
          SuperscriptBox["\[ExponentialE]", "t"]}]}], ",", 
        RowBox[{
         RowBox[{
          SuperscriptBox["v", "\[Prime]",
           MultilineFunction->None], "[", "t", "]"}], "\[Equal]", 
         RowBox[{
          RowBox[{"2", " ", 
           RowBox[{"u", "[", "t", "]"}]}], "+", 
          RowBox[{"2", " ", 
           RowBox[{"v", "[", "t", "]"}]}], "-", 
          SuperscriptBox["\[ExponentialE]", "t"]}]}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"u", "[", "t", "]"}], ",", 
        RowBox[{"v", "[", "t", "]"}]}], "}"}], ",", "t"}], "]"}], "]"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"4.6", ".1"}], "*)"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"2.66", "*", 
    RowBox[{"10", "^", "21"}], "*", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Log", "[", "2", "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"584400", "*", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"Log", "[", "2", "]"}], "/", "584400"}], "-", 
          RowBox[{
           RowBox[{"Log", "[", "2", "]"}], "/", "3.8235"}]}], ")"}]}], 
       ")"}]}], ")"}], "*", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"E", "^", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "365"}], "*", 
           RowBox[{"Log", "[", "2", "]"}]}], ")"}], "/", "3.8235"}], ")"}]}], 
      "-", 
      RowBox[{"E", "^", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "365"}], "*", 
           RowBox[{"Log", "[", "2", "]"}]}], ")"}], "/", "584400"}], 
        ")"}]}]}], ")"}]}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"DSolve", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         SuperscriptBox[
          SubscriptBox["N", "1"], "\[Prime]",
          MultilineFunction->None], "[", "t", "]"}], "\[Equal]", 
        RowBox[{
         RowBox[{"-", 
          SubscriptBox["\[Lambda]", "1"]}], " ", 
         RowBox[{
          SubscriptBox["N", "1"], "[", "t", "]"}]}]}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox[
          SubscriptBox["N", "2"], "\[Prime]",
          MultilineFunction->None], "[", "t", "]"}], "\[Equal]", 
        RowBox[{
         RowBox[{
          SubscriptBox["\[Lambda]", "1"], " ", 
          RowBox[{
           SubscriptBox["N", "1"], "[", "t", "]"}]}], "-", 
         RowBox[{
          SubscriptBox["\[Lambda]", "2"], 
          RowBox[{
           SubscriptBox["N", "2"], "[", "t", "]"}]}]}]}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox[
          SubscriptBox["N", "3"], "\[Prime]",
          MultilineFunction->None], "[", "t", "]"}], "\[Equal]", 
        RowBox[{
         RowBox[{
          SubscriptBox["\[Lambda]", "2"], " ", 
          RowBox[{
           SubscriptBox["N", "2"], "[", "t", "]"}]}], "-", 
         RowBox[{
          SubscriptBox["\[Lambda]", "3"], 
          RowBox[{
           SubscriptBox["N", "3"], "[", "t", "]"}]}]}]}], ",", 
       RowBox[{
        RowBox[{
         SubscriptBox["N", "1"], "[", "0", "]"}], "\[Equal]", 
        SubscriptBox["N", "0"]}], ",", 
       RowBox[{
        RowBox[{
         SubscriptBox["N", "2"], "[", "0", "]"}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{
         SubscriptBox["N", "3"], "[", "0", "]"}], "\[Equal]", "0"}]}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        SubscriptBox["N", "1"], "[", "t", "]"}], ",", 
       RowBox[{
        SubscriptBox["N", "2"], "[", "t", "]"}], ",", 
       RowBox[{
        SubscriptBox["N", "3"], "[", "t", "]"}]}], "}"}], ",", "t"}], "]"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{
        SubscriptBox["N", "1"], "[", "t", "]"}], "\[Rule]", 
       RowBox[{
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{"-", "t"}], " ", 
          SubscriptBox["\[Lambda]", "1"]}]], " ", 
        SubscriptBox["N", "0"]}]}], ",", 
      RowBox[{
       RowBox[{
        SubscriptBox["N", "2"], "[", "t", "]"}], "\[Rule]", 
       RowBox[{"-", 
        FractionBox[
         RowBox[{
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "t"}], " ", 
             SubscriptBox["\[Lambda]", "1"]}], "-", 
            RowBox[{"t", " ", 
             SubscriptBox["\[Lambda]", "2"]}]}]], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{"t", " ", 
               SubscriptBox["\[Lambda]", "1"]}]]}], "+", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{"t", " ", 
              SubscriptBox["\[Lambda]", "2"]}]]}], ")"}], " ", 
          SubscriptBox["N", "0"], " ", 
          SubscriptBox["\[Lambda]", "1"]}], 
         RowBox[{
          SubscriptBox["\[Lambda]", "1"], "-", 
          SubscriptBox["\[Lambda]", "2"]}]]}]}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        SubscriptBox["N", "3"], "[", "t", "]"}], "\[Rule]", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "t"}], " ", 
             SubscriptBox["\[Lambda]", "1"]}], "-", 
            RowBox[{"t", " ", 
             SubscriptBox["\[Lambda]", "2"]}], "-", 
            RowBox[{"t", " ", 
             SubscriptBox["\[Lambda]", "3"]}]}]], " ", 
          SubscriptBox["N", "0"], " ", 
          SubscriptBox["\[Lambda]", "1"], " ", 
          SubscriptBox["\[Lambda]", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{
               RowBox[{"t", " ", 
                SubscriptBox["\[Lambda]", "1"]}], "+", 
               RowBox[{"t", " ", 
                SubscriptBox["\[Lambda]", "2"]}]}]], " ", 
             SubscriptBox["\[Lambda]", "1"]}], "-", 
            RowBox[{
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{
               RowBox[{"t", " ", 
                SubscriptBox["\[Lambda]", "1"]}], "+", 
               RowBox[{"t", " ", 
                SubscriptBox["\[Lambda]", "3"]}]}]], " ", 
             SubscriptBox["\[Lambda]", "1"]}], "-", 
            RowBox[{
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{
               RowBox[{"t", " ", 
                SubscriptBox["\[Lambda]", "1"]}], "+", 
               RowBox[{"t", " ", 
                SubscriptBox["\[Lambda]", "2"]}]}]], " ", 
             SubscriptBox["\[Lambda]", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{
               RowBox[{"t", " ", 
                SubscriptBox["\[Lambda]", "2"]}], "+", 
               RowBox[{"t", " ", 
                SubscriptBox["\[Lambda]", "3"]}]}]], " ", 
             SubscriptBox["\[Lambda]", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{
               RowBox[{"t", " ", 
                SubscriptBox["\[Lambda]", "1"]}], "+", 
               RowBox[{"t", " ", 
                SubscriptBox["\[Lambda]", "3"]}]}]], " ", 
             SubscriptBox["\[Lambda]", "3"]}], "-", 
            RowBox[{
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{
               RowBox[{"t", " ", 
                SubscriptBox["\[Lambda]", "2"]}], "+", 
               RowBox[{"t", " ", 
                SubscriptBox["\[Lambda]", "3"]}]}]], " ", 
             SubscriptBox["\[Lambda]", "3"]}]}], ")"}]}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            SubscriptBox["\[Lambda]", "1"], "-", 
            SubscriptBox["\[Lambda]", "2"]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            SubscriptBox["\[Lambda]", "1"], "-", 
            SubscriptBox["\[Lambda]", "3"]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            SubscriptBox["\[Lambda]", "2"], "-", 
            SubscriptBox["\[Lambda]", "3"]}], ")"}]}], ")"}]}]}]}], "}"}], 
    "}"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"4.6", ".2"}], "*)"}]}]}]], "Input",
 CellChangeTimes->{{3.762431587170398*^9, 3.762431587341998*^9}, {
  3.762431618606454*^9, 3.762431646111302*^9}, {3.7624316806195626`*^9, 
  3.7624316866723733`*^9}, {3.762431725114841*^9, 3.762431734802458*^9}, {
  3.762778048692289*^9, 3.7627780752767353`*^9}, {3.762778112812402*^9, 
  3.762778180893921*^9}, {3.762778734786296*^9, 3.762778744475913*^9}}],

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{"Expand", "[", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       SubscriptBox["k", "12"], "+", 
       SubscriptBox["k", "13"], "+", 
       SubscriptBox["k", "21"]}], ")"}], "2"], "-", 
    RowBox[{"4", 
     SubscriptBox["k", "13"], 
     SubscriptBox["k", "21"]}]}], "]"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       SubscriptBox["M", "2"], "'"}], "[", "t", "]"}], "+", 
     RowBox[{
      SubscriptBox["k", "21"], " ", 
      RowBox[{
       SubscriptBox["M", "2"], "[", "t", "]"}]}]}], "\[Equal]", 
    RowBox[{
     SubscriptBox["k", "12"], 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        SubscriptBox["C", "1"], 
        SuperscriptBox["\[ExponentialE]", 
         SubscriptBox["\[Lambda]", "1"]]}], "+", 
       RowBox[{
        SubscriptBox["C", "2"], 
        SuperscriptBox["\[ExponentialE]", 
         SubscriptBox["\[Lambda]", "2"]]}], "-", 
       FractionBox["s", 
        SubscriptBox["k", "13"]]}], ")"}]}]}], ",", 
   RowBox[{
    SubscriptBox["M", "2"], "[", "t", "]"}], ",", "t"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"4.6", ".3"}], "*)"}], "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{
  3.7624320255883694`*^9, {3.762778194419145*^9, 3.762778200659156*^9}, {
   3.7627787601851406`*^9, 3.7627787618699436`*^9}, {3.771399716754691*^9, 
   3.7713997169262915`*^9}, {3.7713997620897713`*^9, 3.771399762276972*^9}, {
   3.771400829443272*^9, 3.771400834701481*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"R1", ":=", "20"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"R2", ":=", "20"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"L1", ":=", "10"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"L2", ":=", "10"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"U0", ":=", "5"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Omega0", ":=", "2"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"I1", "[", "t", "]"}], "\[Equal]", 
      RowBox[{
       RowBox[{"I2", "[", "t", "]"}], "+", 
       RowBox[{"I3", "[", "t", "]"}]}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"R1", " ", 
        RowBox[{"I1", "[", "t", "]"}]}], "+", 
       RowBox[{"R2", " ", 
        RowBox[{"I2", "[", "t", "]"}]}], "+", 
       RowBox[{"L1", " ", 
        RowBox[{
         RowBox[{"I1", "'"}], "[", "t", "]"}]}]}], "\[Equal]", 
      RowBox[{"U0", " ", 
       RowBox[{"Cos", "[", 
        RowBox[{"Omega0", " ", "t"}], "]"}]}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"L2", " ", 
        RowBox[{
         RowBox[{"I3", "'"}], "[", "t", "]"}]}], "-", 
       RowBox[{"R2", " ", 
        RowBox[{"I2", "[", "t", "]"}]}]}], "==", "0"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"I1", "[", "0", "]"}], "==", "0"}], ",", 
     RowBox[{
      RowBox[{"I2", "[", "0", "]"}], "==", "0"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"I1", "[", "t", "]"}], ",", 
     RowBox[{"I2", "[", "t", "]"}], ",", 
     RowBox[{"I3", "[", "t", "]"}]}], "}"}], ",", "t"}], 
  "]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.7624319811408916`*^9, 3.7624319814840918`*^9}, {
   3.7627782156683826`*^9, 3.7627782165263844`*^9}, 3.771400824636463*^9, {
   3.771406058808033*^9, 3.7714060679994497`*^9}}],

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"I2", "''"}], "[", "t", "]"}], "+", 
       RowBox[{"6", " ", 
        RowBox[{
         RowBox[{"I2", "'"}], "[", "t", "]"}]}], "+", 
       RowBox[{"4", 
        RowBox[{"I2", "[", "t", "]"}]}]}], "==", 
      RowBox[{"-", 
       RowBox[{"Sin", "[", 
        RowBox[{"2", "t"}], "]"}]}]}], ",", 
     RowBox[{
      RowBox[{"I2", "[", "0", "]"}], "\[Equal]", "0"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"I2", "'"}], "[", "0", "]"}], "\[Equal]", "0.5"}]}], "}"}], 
   ",", 
   RowBox[{"I2", "[", "t", "]"}], ",", "t"}], "]"}]], "Input",
 CellChangeTimes->{{3.771405676667302*^9, 3.7714057498680315`*^9}, {
  3.7714057983533173`*^9, 3.7714058576514225`*^9}, {3.7714060406280007`*^9, 
  3.771406042375204*^9}}]
},
WindowSize->{707, 867},
WindowMargins->{{-2, Automatic}, {Automatic, -1}},
FrontEndVersion->"9.0 for Microsoft Windows (64-bit) (January 25, 2013)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[557, 20, 491, 10, 52, "Input"],
Cell[1051, 32, 12375, 343, 759, "Input"],
Cell[13429, 377, 368, 12, 33, "Input"],
Cell[13800, 391, 821, 27, 48, "Input"],
Cell[14624, 420, 429, 8, 72, "Input"],
Cell[15056, 430, 1881, 54, 212, "Input"],
Cell[16940, 486, 864, 26, 52, "Input"]
}
]
*)

(* End of internal cache information *)
