(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 9.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[      7457,        237]
NotebookOptionsPosition[      6984,        218]
NotebookOutlinePosition[      7326,        233]
CellTagsIndexPosition[      7283,        230]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
   RowBox[{
   "Differentialgleichungen", " ", "f\[UDoubleDot]r", " ", "Einsteiger", " ", 
    "Kapitel", " ", "5"}], ":", " ", 
   RowBox[{"Mathematica", "-", 
    RowBox[{"Code", " ", "und", " ", "Programme"}]}]}], "*)"}]], "Input",
 CellChangeTimes->{{3.761503651038785*^9, 3.761503719111705*^9}, {
  3.761503782203617*^9, 3.7615037825936174`*^9}, {3.761503866807169*^9, 
  3.76150386729077*^9}, {3.7705745460254498`*^9, 3.7705745466806507`*^9}}],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"5.1", ".1"}], "*)"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Plot3D", "[", 
    RowBox[{
     RowBox[{"x1", "+", 
      RowBox[{"2", "*", 
       RowBox[{"x2", "^", "2"}]}]}], ",", 
     RowBox[{"{", 
      RowBox[{"x1", ",", "0", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x2", ",", "0", ",", "2"}], "}"}]}], "]"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"Plot3D", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"0.01", "*", "x2"}], "+", 
      RowBox[{"E", "^", "x1"}], "+", 
      RowBox[{"0.5", "*", "x1", "*", 
       RowBox[{"Sin", "[", "x2", "]"}]}]}], ",", 
     RowBox[{"{", 
      RowBox[{"x1", ",", 
       RowBox[{"-", "10"}], ",", "10"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x2", ",", 
       RowBox[{"-", "10"}], ",", "10"}], "}"}]}], "]"}], 
   "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.76233107861147*^9, 3.762331180390049*^9}, {
  3.762331272873012*^9, 3.7623313074446726`*^9}, {3.7623314165582647`*^9, 
  3.7623315040004187`*^9}, {3.762778245776435*^9, 3.7627782846235037`*^9}, {
  3.762778669401581*^9, 3.7627786788113976`*^9}}],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{"5.1", ".2"}], "*)"}]], "Input",
 CellChangeTimes->{{3.7627786824618034`*^9, 3.7627787016966376`*^9}}],

Cell[BoxData[{
 RowBox[{"D", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x2", "*", 
     RowBox[{"E", "^", 
      RowBox[{"(", 
       RowBox[{"2", "*", "x1"}], ")"}]}]}], "-", 
    RowBox[{"x3", "^", "2"}]}], ",", "x1"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"D", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x2", "*", 
     RowBox[{"E", "^", 
      RowBox[{"(", 
       RowBox[{"2", "*", "x1"}], ")"}]}]}], "-", 
    RowBox[{"x3", "^", "2"}]}], ",", "x2"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"D", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x2", "*", 
     RowBox[{"E", "^", 
      RowBox[{"(", 
       RowBox[{"2", "*", "x1"}], ")"}]}]}], "-", 
    RowBox[{"x3", "^", "2"}]}], ",", "x3"}], 
  "]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.762331527917261*^9, 3.762331613924212*^9}, {
  3.7623316897297454`*^9, 3.7623316899169455`*^9}, {3.7627787068602467`*^9, 
  3.762778716487464*^9}}],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{"5.2", ".2"}], "*)"}]], "Input",
 CellChangeTimes->{{3.7627783068691425`*^9, 3.7627783073215437`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"DSolve", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"u", "[", 
          RowBox[{"x", ",", " ", "t"}], "]"}], ",", " ", "x"}], "]"}]}], " ", 
      "+", " ", 
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"u", "[", 
         RowBox[{"x", ",", " ", "t"}], "]"}], ",", " ", "t"}], "]"}]}], " ", "==",
      " ", "1"}], ",", " ", 
    RowBox[{"u", "[", 
     RowBox[{"x", ",", " ", "t"}], "]"}], ",", " ", 
    RowBox[{"{", 
     RowBox[{"x", ",", " ", "t"}], "}"}]}], "]"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"DSolve", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         RowBox[{"D", "[", 
          RowBox[{
           RowBox[{"u", "[", 
            RowBox[{"x", ",", "t"}], "]"}], ",", "x"}], "]"}]}], "+", 
        RowBox[{"D", "[", 
         RowBox[{
          RowBox[{"u", "[", 
           RowBox[{"x", ",", "t"}], "]"}], ",", "t"}], "]"}]}], "\[Equal]", 
       "1"}], ",", 
      RowBox[{
       RowBox[{"u", "[", 
        RowBox[{"x", ",", "1"}], "]"}], "\[Equal]", "2"}]}], "}"}], ",", 
    RowBox[{"u", "[", 
     RowBox[{"x", ",", "t"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "t"}], "}"}]}], "]"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"2", "*", "x", "*", 
        RowBox[{"D", "[", 
         RowBox[{
          RowBox[{"u", "[", 
           RowBox[{"x", ",", "t"}], "]"}], ",", "x"}], "]"}]}], "+", 
       RowBox[{"t", "*", 
        RowBox[{"D", "[", 
         RowBox[{
          RowBox[{"u", "[", 
           RowBox[{"x", ",", "t"}], "]"}], ",", "t"}], "]"}]}]}], "\[Equal]", 
      RowBox[{"x", "*", 
       RowBox[{"u", "[", 
        RowBox[{"x", ",", "t"}], "]"}]}]}], ",", 
     RowBox[{
      RowBox[{"u", "[", 
       RowBox[{"x", ",", "1"}], "]"}], "\[Equal]", 
      RowBox[{"x", "*", 
       RowBox[{"E", "^", "x"}]}]}]}], "}"}], ",", 
   RowBox[{"u", "[", 
    RowBox[{"x", ",", "t"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "t"}], "}"}]}], "]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.76233168651614*^9, 3.7623317425710382`*^9}, {
  3.7623317886555195`*^9, 3.7623317944119296`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"5.3", ".1"}], "*)"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{"DSolve", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "/", 
         RowBox[{"c", "^", "2"}]}], ")"}], "*", 
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"z", "[", 
          RowBox[{"x", ",", " ", "t"}], "]"}], ",", " ", 
         RowBox[{"{", 
          RowBox[{"t", ",", " ", "2"}], "}"}]}], "]"}]}], " ", "-", " ", 
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"z", "[", 
         RowBox[{"x", ",", " ", "t"}], "]"}], ",", " ", 
        RowBox[{"{", 
         RowBox[{"x", ",", " ", "2"}], "}"}]}], "]"}]}], " ", "==", " ", 
     "0"}], ",", " ", 
    RowBox[{"z", "[", 
     RowBox[{"x", ",", " ", "t"}], "]"}], ",", " ", 
    RowBox[{"{", 
     RowBox[{"x", ",", " ", "t"}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.762331797344735*^9, 3.7623318108719587`*^9}, {
  3.7627783262151766`*^9, 3.7627783355907936`*^9}}]
},
WindowSize->{707, 867},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
FrontEndVersion->"9.0 for Microsoft Windows (64-bit) (January 25, 2013)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[557, 20, 490, 10, 52, "Input"],
Cell[1050, 32, 1224, 33, 152, "Input"],
Cell[2277, 67, 142, 3, 31, "Input"],
Cell[2422, 72, 908, 28, 92, "Input"],
Cell[3333, 102, 142, 3, 31, "Input"],
Cell[3478, 107, 2450, 76, 192, "Input"],
Cell[5931, 185, 1049, 31, 92, "Input"]
}
]
*)

(* End of internal cache information *)
