(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 9.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     15450,        491]
NotebookOptionsPosition[     14620,        463]
NotebookOutlinePosition[     14964,        478]
CellTagsIndexPosition[     14921,        475]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
   RowBox[{
   "Differentialgleichungen", " ", "f\[UDoubleDot]r", " ", "Einsteiger", " ", 
    "Kapitel", " ", "8"}], ":", " ", 
   RowBox[{"Mathematica", "-", 
    RowBox[{"Code", " ", "und", " ", "Programme"}]}]}], "*)"}]], "Input",
 CellChangeTimes->{{3.761503651038785*^9, 3.761503719111705*^9}, {
  3.761503782203617*^9, 3.7615037825936174`*^9}, {3.7615038925818157`*^9, 
  3.7615038928470163`*^9}, {3.770574494107157*^9, 3.770574496962962*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"8.2", ".1"}], "*)"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"f", "[", "x_", "]"}], ":=", 
    RowBox[{
     SuperscriptBox["x", "3"], "+", 
     RowBox[{"2", 
      SuperscriptBox["x", "2"]}]}]}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"Solve", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"f", "[", "x", "]"}], " ", "==", " ", "0"}], ",", " ", "x"}], 
    "]"}], "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.762331995151084*^9, 3.7623320282553415`*^9}, {
  3.7627784019895105`*^9, 3.7627784270451546`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Plot", "[", 
   RowBox[{
    RowBox[{"f", "[", "x", "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", 
      RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
    RowBox[{"AxesLabel", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"\"\<x\>\"", ",", "\"\<f(x)\>\""}], "}"}]}]}], "]"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{{3.7623320219207306`*^9, 3.762332022092331*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Plot", "[", 
   RowBox[{
    RowBox[{"f", "[", "x", "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", 
      RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
    RowBox[{"AxesLabel", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"\"\<x\>\"", ",", "\"\<f(x)\>\""}], "}"}]}]}], "]"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{{3.76233204438577*^9, 3.7623320445417705`*^9}}],

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"f", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
   RowBox[{"AxesLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<x\>\"", ",", "\"\<f(x)\>\""}], "}"}]}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"Thickness", "[", "0.005", "]"}]}]}], "]"}]], "Input"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Solve", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "-", 
      RowBox[{"5", "x"}], "+", "6"}], "\[Equal]", "0"}], ",", "x"}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Solve", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"2", "x"}], "-", 
        RowBox[{"5", "y"}]}], "\[Equal]", "3"}], ",", 
      RowBox[{
       RowBox[{"x", "+", "y"}], "\[Equal]", "5"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}]}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"NSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"E", "^", "x"}], "-", 
     RowBox[{"5", "x"}]}], "\[Equal]", "0"}], ",", "x"}], "]"}]}], "Input",
 CellChangeTimes->{{3.762332079409832*^9, 3.762332181954812*^9}}],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"D", "[", 
   RowBox[{
    RowBox[{"f", "[", "x", "]"}], ",", "x"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.762332195944239*^9, 3.76233219656824*^9}}],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"D", "[", 
   RowBox[{
    RowBox[{"f", "[", "x", "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "2"}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.762332204383854*^9, 3.762332205101455*^9}}],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Integrate", "[", 
    RowBox[{
     RowBox[{"f", "[", "x", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "2"}], "}"}]}], "]"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"Integrate", "[", 
    RowBox[{
     RowBox[{"f", "[", "x", "]"}], ",", "x"}], "]"}], 
   "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.762332215288273*^9, 3.762332237286312*^9}, 
   3.7627786483103437`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"8.2", ".2"}], "*)"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{"Plot3D", "[", 
   RowBox[{
    RowBox[{"Sin", "[", 
     RowBox[{"x", " ", "y"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", 
      RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"y", ",", 
      RowBox[{"-", "2"}], ",", "2"}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.7623322489395323`*^9, 3.762332287927001*^9}, {
   3.762778446123988*^9, 3.762778453643201*^9}, 3.762778649761146*^9}],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"ParametricPlot3D", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"Cos", "[", "t", "]"}], "*", 
       RowBox[{"Cos", "[", "u", "]"}]}], ",", 
      RowBox[{
       RowBox[{"Sin", "[", "t", "]"}], "*", 
       RowBox[{"Cos", "[", "u", "]"}]}], ",", 
      RowBox[{"Sin", "[", "u", "]"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"t", ",", "0", ",", 
      RowBox[{"2", " ", "Pi"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"u", ",", 
      RowBox[{
       RowBox[{"-", "Pi"}], "/", "2"}], ",", 
      RowBox[{"Pi", "/", "2"}]}], "}"}], ",", 
    RowBox[{"Axes", "\[Rule]", "None"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.7623323085190372`*^9, 3.7623324183990307`*^9}}],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"ParametricPlot3D", "[", 
    RowBox[{
     RowBox[{"{", " ", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"Cos", "[", "t", "]"}], 
         RowBox[{"(", 
          RowBox[{"3", "+", 
           RowBox[{"Cos", "[", "u", "]"}]}], ")"}]}], "+", 
        RowBox[{
         RowBox[{"Cos", "[", "t", "]"}], 
         RowBox[{"Cos", "[", "u", "]"}]}]}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{"Sin", "[", "t", "]"}], " ", 
         RowBox[{"(", 
          RowBox[{"3", "+", 
           RowBox[{"Cos", "[", "u", "]"}]}], ")"}]}], "+", 
        RowBox[{
         RowBox[{"Sin", "[", "t", "]"}], " ", 
         RowBox[{"Cos", "[", "u", "]"}]}]}], ",", 
       RowBox[{"2", " ", 
        RowBox[{"Sin", "[", "u", "]"}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", 
       RowBox[{"2", " ", "Pi"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"u", ",", "0", ",", 
       RowBox[{"2", " ", "Pi"}]}], "}"}], ",", 
     RowBox[{"Axes", "\[Rule]", "None"}]}], "]"}], 
   "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.7623324525484905`*^9, 3.7623324531880918`*^9}, 
   3.762778652725151*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"8.2", ".3"}], "*)"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"For", "[", 
    RowBox[{
     RowBox[{"n", "=", "1"}], ",", 
     RowBox[{"n", "\[LessEqual]", "10"}], ",", 
     RowBox[{"n", "++"}], ",", 
     RowBox[{"Print", "[", 
      SuperscriptBox["n", "2"], "]"}]}], "]"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"While", "[", 
    RowBox[{
     RowBox[{"n", ">", "1"}], ",", 
     RowBox[{
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Mod", "[", 
          RowBox[{"n", ",", "2"}], "]"}], "\[Equal]", "0"}], ",", 
        RowBox[{"n", "=", 
         RowBox[{"n", "/", "2"}]}], ",", 
        RowBox[{"n", "=", 
         RowBox[{
          RowBox[{"3", "n"}], "+", "1"}]}]}], "]"}], ";", 
      RowBox[{"Print", "[", "n", "]"}]}]}], "]"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"F", "[", "1", "]"}], ":=", "1"}], ";"}], "\n", 
   RowBox[{
    RowBox[{
     RowBox[{"F", "[", "2", "]"}], ":=", "1"}], ";"}], "\n", 
   RowBox[{
    RowBox[{"F", "[", "n_", "]"}], ":=", 
    RowBox[{
     RowBox[{"F", "[", 
      RowBox[{"n", "-", "1"}], "]"}], "+", 
     RowBox[{"F", "[", 
      RowBox[{"n", "-", "2"}], "]"}]}]}], "\n", 
   RowBox[{"For", "[", 
    RowBox[{
     RowBox[{"n", "=", "1"}], ",", 
     RowBox[{"n", "\[LessEqual]", "20"}], ",", 
     RowBox[{"n", "++"}], ",", 
     RowBox[{"Print", "[", 
      RowBox[{"F", "[", "n", "]"}], "]"}]}], "]"}], 
   "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.7623324878533525`*^9, 3.762332535318237*^9}, 
   3.7623325669766927`*^9, {3.762778462521617*^9, 3.762778471320032*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"J", "=", "2013"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"a", "=", 
   RowBox[{"Mod", "[", 
    RowBox[{"J", ",", "19"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"b", "=", 
   RowBox[{"Mod", "[", 
    RowBox[{"J", ",", "4"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"c", "=", 
   RowBox[{"Mod", "[", 
    RowBox[{"J", ",", "7"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"d", "=", 
   RowBox[{"Mod", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"19", "a"}], "+", "m"}], ",", "30"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"e", "=", 
   RowBox[{"Mod", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"2", "b"}], "+", 
      RowBox[{"4", "c"}], "+", 
      RowBox[{"6", "d"}], "+", "n"}], ",", "7"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"k", "=", 
   RowBox[{"Quotient", "[", 
    RowBox[{"J", ",", "100"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"p", "=", 
   RowBox[{"Quotient", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"8", "k"}], "+", "13"}], ",", "25"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"q", "=", 
   RowBox[{"Quotient", "[", 
    RowBox[{"k", ",", "4"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"m", "=", 
   RowBox[{"Mod", "[", 
    RowBox[{
     RowBox[{"15", "+", "k", "-", "p", "-", "q"}], ",", "30"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"n", "=", 
   RowBox[{"Mod", "[", 
    RowBox[{
     RowBox[{"4", "+", "k", "-", "q"}], ",", "7"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"J", " "}], "\[IndentingNewLine]", 
 RowBox[{"Print", "[", "\"\<ist Ostersonntag am\>\"", 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"If", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"22", "+", "d", "+", "e"}], "\[LessEqual]", "31"}], ",", 
   RowBox[{
    RowBox[{"N", "[", 
     RowBox[{"22", "+", "d", "+", "e"}], "]"}], "\"\<M\[ADoubleDot]rz\>\""}], 
   ",", 
   RowBox[{
    RowBox[{"N", "[", 
     RowBox[{"d", "+", "e", "-", "9"}], "]"}], " ", "\"\<April\>\""}]}], 
  "]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.7623326365256147`*^9, 3.7623326442028284`*^9}}],

Cell[BoxData[""], "Input",
 CellChangeTimes->{3.762332859166607*^9}],

Cell[BoxData[{
 RowBox[{"Print", "[", "\"\<Lotka-Volterrasches Raeuber-Beute-Modell\>\"", 
  "]"}], "\n", 
 RowBox[{
  RowBox[{"a1", ":=", "0.007"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"d1", ":=", "0.00002"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"a2", ":=", "1"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"d2", ":=", "0.001"}], ";"}], "\n", 
 RowBox[{"sol", "=", 
  RowBox[{"NDSolve", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"Derivative", "[", "1", "]"}], "[", "r", "]"}], "[", "t", 
        "]"}], "\[Equal]", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"-", "a1"}], ")"}], "*", 
         RowBox[{"r", "[", "t", "]"}]}], "+", 
        RowBox[{"d1", "*", 
         RowBox[{"r", "[", "t", "]"}], "*", 
         RowBox[{"b", "[", "t", "]"}]}]}]}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"Derivative", "[", "1", "]"}], "[", "b", "]"}], "[", "t", 
        "]"}], "\[Equal]", 
       RowBox[{
        RowBox[{"a2", "*", 
         RowBox[{"b", "[", "t", "]"}]}], "-", 
        RowBox[{"d2", "*", 
         RowBox[{"r", "[", "t", "]"}], "*", 
         RowBox[{"b", "[", "t", "]"}]}]}]}], ",", 
      RowBox[{
       RowBox[{"r", "[", "0", "]"}], "\[Equal]", "500"}], ",", 
      RowBox[{
       RowBox[{"b", "[", "0", "]"}], "\[Equal]", "8000"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"r", ",", "b"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"t", ",", "500"}], "}"}]}], "]"}]}], "\n", 
 RowBox[{
  RowBox[{"f", "[", "t_", "]"}], ":=", 
  RowBox[{
   RowBox[{"r", "[", "t", "]"}], "/.", "sol"}]}], "\n", 
 RowBox[{
  RowBox[{"g", "[", "t_", "]"}], ":=", 
  RowBox[{
   RowBox[{"b", "[", "t", "]"}], "/.", "sol"}]}], "\n", 
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"f", "[", "t", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "500"}], "}"}], ",", 
   RowBox[{"AxesLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<t\>\"", ",", "\"\<Anzahl der Raeuber\>\""}], "}"}]}]}], 
  "]"}], "\n", 
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"g", "[", "t", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "500"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0", ",", "11000"}], "}"}]}], ",", 
   RowBox[{"AxesLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<t\>\"", ",", "\"\<Anzahl der Beutetiere\>\""}], "}"}]}]}], 
  "]"}], "\n", 
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"f", "[", "t", "]"}], ",", 
     RowBox[{"g", "[", "t", "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "500"}], "}"}], ",", 
   RowBox[{"AxesLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<t\>\"", ",", "\"\<Anzahl der Raeuber/Beutetiere\>\""}], 
     "}"}]}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0", ",", "11000"}], "}"}]}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.7623329855542946`*^9, 3.7623329855542946`*^9}}]
},
WindowSize->{707, 867},
WindowMargins->{{-22, Automatic}, {Automatic, 2}},
FrontEndVersion->"9.0 for Microsoft Windows (64-bit) (January 25, 2013)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[557, 20, 491, 10, 52, "Input"],
Cell[1051, 32, 646, 19, 132, "Input"],
Cell[1700, 53, 445, 12, 72, "Input"],
Cell[2148, 67, 444, 12, 72, "Input"],
Cell[2595, 81, 397, 11, 52, "Input"],
Cell[2995, 94, 888, 29, 112, "Input"],
Cell[3886, 125, 232, 5, 72, "Input"],
Cell[4121, 132, 284, 7, 72, "Input"],
Cell[4408, 141, 523, 14, 132, "Input"],
Cell[4934, 157, 571, 16, 72, "Input"],
Cell[5508, 175, 797, 22, 92, "Input"],
Cell[6308, 199, 1225, 36, 112, "Input"],
Cell[7536, 237, 1756, 52, 255, "Input"],
Cell[9295, 291, 2246, 73, 312, "Input"],
Cell[11544, 366, 68, 1, 31, "Input"],
Cell[11615, 369, 3001, 92, 312, "Input"]
}
]
*)

(* End of internal cache information *)
