(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 9.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[      7054,        205]
NotebookOptionsPosition[      6579,        186]
NotebookOutlinePosition[      6921,        201]
CellTagsIndexPosition[      6878,        198]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
   "Differentialgleichungen", " ", "f\[UDoubleDot]r", " ", "Einsteiger", " ", 
    "Kapitel", " ", "8", 
    RowBox[{"L\[ODoubleDot]sungen", ":", " ", 
     RowBox[{"Mathematica", "-", 
      RowBox[{"Code", " ", "und", " ", "Programme"}]}]}]}], "*)"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"Aufgabe", " ", "8.9"}], " ", "*)"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"a", "[", "r_", "]"}], " ", ":=", " ", 
    RowBox[{"Pi", "*", 
     RowBox[{"r", "^", "2"}]}]}], "\n", 
   RowBox[{
    RowBox[{"u", "[", "r_", "]"}], " ", ":=", " ", 
    RowBox[{"2", "*", "Pi", "*", "r"}]}], "\n", 
   RowBox[{
    RowBox[{"r", " ", "=", " ", "5"}], ";"}], " ", "\n", 
   RowBox[{"Print", "[", "\"\<Der Flaecheninhalt betraegt \>\"", "]"}], "\n", 
   RowBox[{"Evaluate", "[", 
    RowBox[{"a", "[", "r", "]"}], "]"}], "\n", 
   RowBox[{"Print", "[", "\"\<Der Umfang betraegt \>\"", "]"}], "\n", 
   RowBox[{"Evaluate", "[", 
    RowBox[{"u", "[", "r", "]"}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.7431590277982683`*^9, 3.743159031979076*^9}, {
  3.743159080276761*^9, 3.7431592062472105`*^9}, {3.7623330900536785`*^9, 
  3.76233309064648*^9}, {3.762333133268755*^9, 3.7623331405091677`*^9}, {
  3.762778518448715*^9, 3.7627785515071735`*^9}, {3.762778608481474*^9, 
  3.762778611211478*^9}, {3.7705745195442023`*^9, 3.7705745211052055`*^9}}],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"Aufgabe", " ", "8.10"}], " ", "*)"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Solve", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"3", "x"}], "-", 
         RowBox[{"6", "y"}], "+", "z"}], "\[Equal]", "4"}], ",", 
       RowBox[{
        RowBox[{"x", "+", "y", "+", "z"}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{"4", "x"}], "-", 
         RowBox[{"5", "y"}], "-", 
         RowBox[{"7", "z"}]}], "\[Equal]", "3"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "]"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Aufgabe", " ", "8.11"}], " ", "*)"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"FullSimplify", "[", 
    RowBox[{
     RowBox[{"D", "[", 
      RowBox[{"E", "^", 
       RowBox[{"E", "^", "x"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "5"}], "}"}]}], "]"}], 
   "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.762333179308436*^9, 3.762333287811627*^9}, {
  3.762778535517145*^9, 3.762778566842*^9}, {3.7627786142846837`*^9, 
  3.7627786244715014`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Aufgabe", " ", "8.12"}], " ", "*)"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{"For", "[", 
   RowBox[{
    RowBox[{"n", "=", "1"}], ",", 
    RowBox[{"n", "\[LessEqual]", "100"}], ",", 
    RowBox[{"n", "++"}], ",", 
    RowBox[{"Print", "[", 
     RowBox[{"{", 
      RowBox[{"n", ",", 
       RowBox[{"Sqrt", "[", "n", "]"}], ",", 
       RowBox[{"N", "[", 
        RowBox[{"Sqrt", "[", "n", "]"}], "]"}], ",", "6"}], "}"}], "]"}]}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.7623332952996397`*^9, 3.7623333511673384`*^9}, {
  3.762778571758009*^9, 3.762778576843618*^9}}],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"Aufgabe", " ", "8.13"}], " ", "*)"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"StepIncrements", "[", "n_", "]"}], ":=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"-", "1"}], ")"}], "^", 
      RowBox[{"Random", "[", "Integer", "]"}]}], ",", 
     RowBox[{"{", "n", "}"}]}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.76233338032679*^9, 3.762333380919591*^9}, {
   3.7627785812428255`*^9, 3.7627785846592317`*^9}, 3.762778626858306*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"W1D", "[", "n_", "]"}], " ", ":=", " ", 
  RowBox[{"FoldList", "[", 
   RowBox[{"Plus", ",", " ", "0", ",", " ", 
    RowBox[{"StepIncrements", "[", "n", "]"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.7623333876744027`*^9, 3.7623334048364325`*^9}}],

Cell[BoxData[
 RowBox[{"W1D", "[", "150", "]"}]], "Input",
 CellChangeTimes->{{3.7623333943824143`*^9, 3.7623334139312487`*^9}}],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"Aufgabe", " ", "8.14"}], " ", "*)"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{"For", "[", 
   RowBox[{
    RowBox[{"a", "=", "1"}], ",", 
    RowBox[{"a", "\[LessEqual]", "9"}], ",", 
    RowBox[{"a", "++"}], ",", 
    RowBox[{"For", "[", 
     RowBox[{
      RowBox[{"b", "=", "0"}], ",", 
      RowBox[{"b", "\[LessEqual]", "9"}], ",", 
      RowBox[{"b", "++"}], ",", 
      RowBox[{"For", "[", 
       RowBox[{
        RowBox[{"c", "=", "0"}], ",", 
        RowBox[{"c", "\[LessEqual]", "9"}], ",", 
        RowBox[{"c", "++"}], ",", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"100", "a"}], "+", 
            RowBox[{"10", "b"}], "+", "c"}], "==", 
           RowBox[{
            SuperscriptBox["a", "3"], "+", 
            SuperscriptBox["b", "3"], "+", 
            SuperscriptBox["c", "3"]}]}], ",", 
          RowBox[{"Print", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"100", "a"}], "+", 
             RowBox[{"10", "b"}], "+", "c"}], ",", 
            RowBox[{
             SuperscriptBox["a", "3"], "+", 
             SuperscriptBox["b", "3"], "+", 
             SuperscriptBox["c", "3"]}]}], "]"}]}], "]"}]}], "]"}]}], "]"}]}],
    "]"}]}]], "Input",
 CellChangeTimes->{{3.7623334682213445`*^9, 3.7623334763353586`*^9}, {
   3.7627785936448474`*^9, 3.762778597264054*^9}, 3.7627786305555124`*^9}]
},
WindowSize->{707, 867},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
FrontEndVersion->"9.0 for Microsoft Windows (64-bit) (January 25, 2013)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[557, 20, 1501, 33, 272, "Input"],
Cell[2061, 55, 1337, 37, 212, "Input"],
Cell[3401, 94, 655, 18, 72, "Input"],
Cell[4059, 114, 595, 15, 92, "Input"],
Cell[4657, 131, 286, 6, 31, "Input"],
Cell[4946, 139, 128, 2, 31, "Input"],
Cell[5077, 143, 1498, 41, 160, "Input"]
}
]
*)

(* End of internal cache information *)
