(function(global2, factory2) {
  typeof exports === "object" && typeof module !== "undefined" ? factory2(require("node:fs"), require("node:os"), require("node:path"), require("electron"), require("path"), require("fs"), require("url"), require("stream"), require("zlib"), require("worker_threads"), require("module"), require("async_hooks"), require("events"), require("perf_hooks"), require("node:util"), require("diagnostics_channel"), require("util"), require("os"), require("tty"), require("node:readline"), require("node:worker_threads"), require("node:child_process"), require("child_process"), require("net"), require("http"), require("https"), require("node:stream"), require("node:process"), require("assert"), require("buffer"), require("node:fs/promises"), require("crypto"), require("fs/promises"), require("tls")) : typeof define === "function" && define.amd ? define(["node:fs", "node:os", "node:path", "electron", "path", "fs", "url", "stream", "zlib", "worker_threads", "module", "async_hooks", "events", "perf_hooks", "node:util", "diagnostics_channel", "util", "os", "tty", "node:readline", "node:worker_threads", "node:child_process", "child_process", "net", "http", "https", "node:stream", "node:process", "assert", "buffer", "node:fs/promises", "crypto", "fs/promises", "tls"], factory2) : (global2 = typeof globalThis !== "undefined" ? globalThis : global2 || self, factory2(global2.node_fs, global2.os$8, global2.path$l, global2.electron, global2.path$k, global2.require$$0$2, global2.Url, global2.Stream, global2.zlib$2, global2.require$$3, global2.require$$1$3, global2.require$$1$4, global2.require$$0$5, global2.perf_hooks$2, global2.util$b, global2.require$$0$4, global2.require$$5$1, global2.require$$0$1, global2.require$$0$3, global2.node_readline, global2.node_worker_threads, global2.node_child_process, global2.require$$0$7, global2.require$$0$6, global2.http$3, global2.require$$1$5, global2.node_stream, global2.process$4, global2.require$$0$8, global2.require$$0$9, global2.fs$b, global2.crypto$4, global2.fs$c, global2.require$$1$6));
})(this, function(node_fs, os$8, path$l, electron$1, path$k, require$$0$2, Url, Stream, zlib$2, require$$3, require$$1$3, require$$1$4, require$$0$5, perf_hooks$2, util$b, require$$0$4, require$$5$1, require$$0$1, require$$0$3, node_readline, node_worker_threads, node_child_process, require$$0$7, require$$0$6, http$3, require$$1$5, node_stream, process$4, require$$0$8, require$$0$9, fs$b, crypto$4, fs$c, require$$1$6) {
  "use strict";var __defProp = Object.defineProperty;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __publicField = (obj, key, value) => __defNormalProp(obj, typeof key !== "symbol" ? key + "" : key, value);
;
!function() {
  try {
    var e2 = "undefined" != typeof window ? window : "undefined" != typeof global ? global : "undefined" != typeof self ? self : {}, n2 = new e2.Error().stack;
    n2 && (e2._sentryDebugIds = e2._sentryDebugIds || {}, e2._sentryDebugIds[n2] = "a0817396-e0f4-440a-9e29-9cfb96a9679f", e2._sentryDebugIdIdentifier = "sentry-dbid-a0817396-e0f4-440a-9e29-9cfb96a9679f");
  } catch (e3) {
  }
}();

  var _a2, _b, _c;
  var _documentCurrentScript = typeof document !== "undefined" ? document.currentScript : null;
  function _interopNamespaceDefault(e2) {
    const n2 = Object.create(null, { [Symbol.toStringTag]: { value: "Module" } });
    if (e2) {
      for (const k2 in e2) {
        if (k2 !== "default") {
          const d2 = Object.getOwnPropertyDescriptor(e2, k2);
          Object.defineProperty(n2, k2, d2.get ? d2 : {
            enumerable: true,
            get: () => e2[k2]
          });
        }
      }
    }
    n2.default = e2;
    return Object.freeze(n2);
  }
  function _mergeNamespaces(n2, m2) {
    for (var i2 = 0; i2 < m2.length; i2++) {
      const e2 = m2[i2];
      if (typeof e2 !== "string" && !Array.isArray(e2)) {
        for (const k2 in e2) {
          if (k2 !== "default" && !(k2 in n2)) {
            const d2 = Object.getOwnPropertyDescriptor(e2, k2);
            if (d2) {
              Object.defineProperty(n2, k2, d2.get ? d2 : {
                enumerable: true,
                get: () => e2[k2]
              });
            }
          }
        }
      }
    }
    return Object.freeze(Object.defineProperty(n2, Symbol.toStringTag, { value: "Module" }));
  }
  const os__namespace = /* @__PURE__ */ _interopNamespaceDefault(os$8);
  const electron__namespace = /* @__PURE__ */ _interopNamespaceDefault(electron$1);
  const path__namespace = /* @__PURE__ */ _interopNamespaceDefault(path$k);
  const Url__namespace = /* @__PURE__ */ _interopNamespaceDefault(Url);
  const util__namespace = /* @__PURE__ */ _interopNamespaceDefault(util$b);
  const fs__namespace = /* @__PURE__ */ _interopNamespaceDefault(fs$b);
  const DEBUG_BUILD$3 = typeof __SENTRY_DEBUG__ === "undefined" || __SENTRY_DEBUG__;
  const SDK_VERSION$1 = "8.42.0";
  const GLOBAL_OBJ = globalThis;
  function getGlobalSingleton(name2, creator, obj) {
    const gbl = GLOBAL_OBJ;
    const __SENTRY__ = gbl.__SENTRY__ = gbl.__SENTRY__ || {};
    const versionedCarrier = __SENTRY__[SDK_VERSION$1] = __SENTRY__[SDK_VERSION$1] || {};
    return versionedCarrier[name2] || (versionedCarrier[name2] = creator());
  }
  const DEBUG_BUILD$2 = typeof __SENTRY_DEBUG__ === "undefined" || __SENTRY_DEBUG__;
  const PREFIX = "Sentry Logger ";
  const CONSOLE_LEVELS = [
    "debug",
    "info",
    "warn",
    "error",
    "log",
    "assert",
    "trace"
  ];
  const originalConsoleMethods = {};
  function consoleSandbox(callback) {
    if (!("console" in GLOBAL_OBJ)) {
      return callback();
    }
    const console2 = GLOBAL_OBJ.console;
    const wrappedFuncs = {};
    const wrappedLevels = Object.keys(originalConsoleMethods);
    wrappedLevels.forEach((level) => {
      const originalConsoleMethod = originalConsoleMethods[level];
      wrappedFuncs[level] = console2[level];
      console2[level] = originalConsoleMethod;
    });
    try {
      return callback();
    } finally {
      wrappedLevels.forEach((level) => {
        console2[level] = wrappedFuncs[level];
      });
    }
  }
  function makeLogger$1() {
    let enabled = false;
    const logger2 = {
      enable: () => {
        enabled = true;
      },
      disable: () => {
        enabled = false;
      },
      isEnabled: () => enabled
    };
    if (DEBUG_BUILD$2) {
      CONSOLE_LEVELS.forEach((name2) => {
        logger2[name2] = (...args2) => {
          if (enabled) {
            consoleSandbox(() => {
              GLOBAL_OBJ.console[name2](`${PREFIX}[${name2}]:`, ...args2);
            });
          }
        };
      });
    } else {
      CONSOLE_LEVELS.forEach((name2) => {
        logger2[name2] = () => void 0;
      });
    }
    return logger2;
  }
  const logger$2 = getGlobalSingleton("logger", makeLogger$1);
  const STACKTRACE_FRAME_LIMIT = 50;
  const UNKNOWN_FUNCTION = "?";
  const WEBPACK_ERROR_REGEXP = /\(error: (.*)\)/;
  const STRIP_FRAME_REGEXP = /captureMessage|captureException/;
  function createStackParser(...parsers) {
    const sortedParsers = parsers.sort((a2, b2) => a2[0] - b2[0]).map((p2) => p2[1]);
    return (stack, skipFirstLines = 0, framesToPop = 0) => {
      const frames = [];
      const lines = stack.split("\n");
      for (let i2 = skipFirstLines; i2 < lines.length; i2++) {
        const line = lines[i2];
        if (line.length > 1024) {
          continue;
        }
        const cleanedLine = WEBPACK_ERROR_REGEXP.test(line) ? line.replace(WEBPACK_ERROR_REGEXP, "$1") : line;
        if (cleanedLine.match(/\S*Error: /)) {
          continue;
        }
        for (const parser of sortedParsers) {
          const frame = parser(cleanedLine);
          if (frame) {
            frames.push(frame);
            break;
          }
        }
        if (frames.length >= STACKTRACE_FRAME_LIMIT + framesToPop) {
          break;
        }
      }
      return stripSentryFramesAndReverse(frames.slice(framesToPop));
    };
  }
  function stackParserFromStackParserOptions(stackParser) {
    if (Array.isArray(stackParser)) {
      return createStackParser(...stackParser);
    }
    return stackParser;
  }
  function stripSentryFramesAndReverse(stack) {
    if (!stack.length) {
      return [];
    }
    const localStack = Array.from(stack);
    if (/sentryWrapped/.test(getLastStackFrame(localStack).function || "")) {
      localStack.pop();
    }
    localStack.reverse();
    if (STRIP_FRAME_REGEXP.test(getLastStackFrame(localStack).function || "")) {
      localStack.pop();
      if (STRIP_FRAME_REGEXP.test(getLastStackFrame(localStack).function || "")) {
        localStack.pop();
      }
    }
    return localStack.slice(0, STACKTRACE_FRAME_LIMIT).map((frame) => ({
      ...frame,
      filename: frame.filename || getLastStackFrame(localStack).filename,
      function: frame.function || UNKNOWN_FUNCTION
    }));
  }
  function getLastStackFrame(arr) {
    return arr[arr.length - 1] || {};
  }
  const defaultFunctionName = "<anonymous>";
  function getFunctionName(fn) {
    try {
      if (!fn || typeof fn !== "function") {
        return defaultFunctionName;
      }
      return fn.name || defaultFunctionName;
    } catch (e2) {
      return defaultFunctionName;
    }
  }
  const handlers = {};
  const instrumented = {};
  function addHandler$1(type2, handler) {
    handlers[type2] = handlers[type2] || [];
    handlers[type2].push(handler);
  }
  function maybeInstrument(type2, instrumentFn) {
    if (!instrumented[type2]) {
      instrumented[type2] = true;
      try {
        instrumentFn();
      } catch (e2) {
        DEBUG_BUILD$2 && logger$2.error(`Error while instrumenting ${type2}`, e2);
      }
    }
  }
  function triggerHandlers(type2, data2) {
    const typeHandlers = type2 && handlers[type2];
    if (!typeHandlers) {
      return;
    }
    for (const handler of typeHandlers) {
      try {
        handler(data2);
      } catch (e2) {
        DEBUG_BUILD$2 && logger$2.error(
          `Error while triggering instrumentation handler.
Type: ${type2}
Name: ${getFunctionName(handler)}
Error:`,
          e2
        );
      }
    }
  }
  let _oldOnErrorHandler = null;
  function addGlobalErrorInstrumentationHandler(handler) {
    const type2 = "error";
    addHandler$1(type2, handler);
    maybeInstrument(type2, instrumentError);
  }
  function instrumentError() {
    _oldOnErrorHandler = GLOBAL_OBJ.onerror;
    GLOBAL_OBJ.onerror = function(msg, url2, line, column, error2) {
      const handlerData = {
        column,
        error: error2,
        line,
        msg,
        url: url2
      };
      triggerHandlers("error", handlerData);
      if (_oldOnErrorHandler && !_oldOnErrorHandler.__SENTRY_LOADER__) {
        return _oldOnErrorHandler.apply(this, arguments);
      }
      return false;
    };
    GLOBAL_OBJ.onerror.__SENTRY_INSTRUMENTED__ = true;
  }
  let _oldOnUnhandledRejectionHandler = null;
  function addGlobalUnhandledRejectionInstrumentationHandler(handler) {
    const type2 = "unhandledrejection";
    addHandler$1(type2, handler);
    maybeInstrument(type2, instrumentUnhandledRejection);
  }
  function instrumentUnhandledRejection() {
    _oldOnUnhandledRejectionHandler = GLOBAL_OBJ.onunhandledrejection;
    GLOBAL_OBJ.onunhandledrejection = function(e2) {
      const handlerData = e2;
      triggerHandlers("unhandledrejection", handlerData);
      if (_oldOnUnhandledRejectionHandler && !_oldOnUnhandledRejectionHandler.__SENTRY_LOADER__) {
        return _oldOnUnhandledRejectionHandler.apply(this, arguments);
      }
      return true;
    };
    GLOBAL_OBJ.onunhandledrejection.__SENTRY_INSTRUMENTED__ = true;
  }
  function getMainCarrier() {
    getSentryCarrier(GLOBAL_OBJ);
    return GLOBAL_OBJ;
  }
  function getSentryCarrier(carrier) {
    const __SENTRY__ = carrier.__SENTRY__ = carrier.__SENTRY__ || {};
    __SENTRY__.version = __SENTRY__.version || SDK_VERSION$1;
    return __SENTRY__[SDK_VERSION$1] = __SENTRY__[SDK_VERSION$1] || {};
  }
  const objectToString$2 = Object.prototype.toString;
  function isError(wat) {
    switch (objectToString$2.call(wat)) {
      case "[object Error]":
      case "[object Exception]":
      case "[object DOMException]":
      case "[object WebAssembly.Exception]":
        return true;
      default:
        return isInstanceOf(wat, Error);
    }
  }
  function isBuiltin(wat, className) {
    return objectToString$2.call(wat) === `[object ${className}]`;
  }
  function isErrorEvent$1(wat) {
    return isBuiltin(wat, "ErrorEvent");
  }
  function isString$1(wat) {
    return isBuiltin(wat, "String");
  }
  function isParameterizedString(wat) {
    return typeof wat === "object" && wat !== null && "__sentry_template_string__" in wat && "__sentry_template_values__" in wat;
  }
  function isPrimitive$1(wat) {
    return wat === null || isParameterizedString(wat) || typeof wat !== "object" && typeof wat !== "function";
  }
  function isPlainObject$1(wat) {
    return isBuiltin(wat, "Object");
  }
  function isEvent(wat) {
    return typeof Event !== "undefined" && isInstanceOf(wat, Event);
  }
  function isElement(wat) {
    return typeof Element !== "undefined" && isInstanceOf(wat, Element);
  }
  function isRegExp(wat) {
    return isBuiltin(wat, "RegExp");
  }
  function isThenable(wat) {
    return Boolean(wat && wat.then && typeof wat.then === "function");
  }
  function isSyntheticEvent(wat) {
    return isPlainObject$1(wat) && "nativeEvent" in wat && "preventDefault" in wat && "stopPropagation" in wat;
  }
  function isInstanceOf(wat, base) {
    try {
      return wat instanceof base;
    } catch (_e2) {
      return false;
    }
  }
  function isVueViewModel(wat) {
    return !!(typeof wat === "object" && wat !== null && (wat.__isVue || wat._isVue));
  }
  const WINDOW = GLOBAL_OBJ;
  const DEFAULT_MAX_STRING_LENGTH = 80;
  function htmlTreeAsString(elem, options = {}) {
    if (!elem) {
      return "<unknown>";
    }
    try {
      let currentElem = elem;
      const MAX_TRAVERSE_HEIGHT = 5;
      const out = [];
      let height = 0;
      let len = 0;
      const separator2 = " > ";
      const sepLength = separator2.length;
      let nextStr;
      const keyAttrs = Array.isArray(options) ? options : options.keyAttrs;
      const maxStringLength = !Array.isArray(options) && options.maxStringLength || DEFAULT_MAX_STRING_LENGTH;
      while (currentElem && height++ < MAX_TRAVERSE_HEIGHT) {
        nextStr = _htmlElementAsString(currentElem, keyAttrs);
        if (nextStr === "html" || height > 1 && len + out.length * sepLength + nextStr.length >= maxStringLength) {
          break;
        }
        out.push(nextStr);
        len += nextStr.length;
        currentElem = currentElem.parentNode;
      }
      return out.reverse().join(separator2);
    } catch (_oO) {
      return "<unknown>";
    }
  }
  function _htmlElementAsString(el, keyAttrs) {
    const elem = el;
    const out = [];
    if (!elem || !elem.tagName) {
      return "";
    }
    if (WINDOW.HTMLElement) {
      if (elem instanceof HTMLElement && elem.dataset) {
        if (elem.dataset["sentryComponent"]) {
          return elem.dataset["sentryComponent"];
        }
        if (elem.dataset["sentryElement"]) {
          return elem.dataset["sentryElement"];
        }
      }
    }
    out.push(elem.tagName.toLowerCase());
    const keyAttrPairs = keyAttrs && keyAttrs.length ? keyAttrs.filter((keyAttr) => elem.getAttribute(keyAttr)).map((keyAttr) => [keyAttr, elem.getAttribute(keyAttr)]) : null;
    if (keyAttrPairs && keyAttrPairs.length) {
      keyAttrPairs.forEach((keyAttrPair) => {
        out.push(`[${keyAttrPair[0]}="${keyAttrPair[1]}"]`);
      });
    } else {
      if (elem.id) {
        out.push(`#${elem.id}`);
      }
      const className = elem.className;
      if (className && isString$1(className)) {
        const classes = className.split(/\s+/);
        for (const c2 of classes) {
          out.push(`.${c2}`);
        }
      }
    }
    const allowedAttrs = ["aria-label", "type", "name", "title", "alt"];
    for (const k2 of allowedAttrs) {
      const attr = elem.getAttribute(k2);
      if (attr) {
        out.push(`[${k2}="${attr}"]`);
      }
    }
    return out.join("");
  }
  function truncate(str, max2 = 0) {
    if (typeof str !== "string" || max2 === 0) {
      return str;
    }
    return str.length <= max2 ? str : `${str.slice(0, max2)}...`;
  }
  function snipLine(line, colno) {
    let newLine = line;
    const lineLength = newLine.length;
    if (lineLength <= 150) {
      return newLine;
    }
    if (colno > lineLength) {
      colno = lineLength;
    }
    let start = Math.max(colno - 60, 0);
    if (start < 5) {
      start = 0;
    }
    let end = Math.min(start + 140, lineLength);
    if (end > lineLength - 5) {
      end = lineLength;
    }
    if (end === lineLength) {
      start = Math.max(end - 140, 0);
    }
    newLine = newLine.slice(start, end);
    if (start > 0) {
      newLine = `'{snip} ${newLine}`;
    }
    if (end < lineLength) {
      newLine += " {snip}";
    }
    return newLine;
  }
  function isMatchingPattern(value, pattern, requireExactStringMatch = false) {
    if (!isString$1(value)) {
      return false;
    }
    if (isRegExp(pattern)) {
      return pattern.test(value);
    }
    if (isString$1(pattern)) {
      return requireExactStringMatch ? value === pattern : value.includes(pattern);
    }
    return false;
  }
  function stringMatchesSomePattern(testString, patterns = [], requireExactStringMatch = false) {
    return patterns.some((pattern) => isMatchingPattern(testString, pattern, requireExactStringMatch));
  }
  function fill(source, name2, replacementFactory) {
    if (!(name2 in source)) {
      return;
    }
    const original = source[name2];
    const wrapped = replacementFactory(original);
    if (typeof wrapped === "function") {
      markFunctionWrapped(wrapped, original);
    }
    try {
      source[name2] = wrapped;
    } catch (e2) {
      DEBUG_BUILD$2 && logger$2.log(`Failed to replace method "${name2}" in object`, source);
    }
  }
  function addNonEnumerableProperty(obj, name2, value) {
    try {
      Object.defineProperty(obj, name2, {
        // enumerable: false, // the default, so we can save on bundle size by not explicitly setting it
        value,
        writable: true,
        configurable: true
      });
    } catch (o_O) {
      DEBUG_BUILD$2 && logger$2.log(`Failed to add non-enumerable property "${name2}" to object`, obj);
    }
  }
  function markFunctionWrapped(wrapped, original) {
    try {
      const proto = original.prototype || {};
      wrapped.prototype = original.prototype = proto;
      addNonEnumerableProperty(wrapped, "__sentry_original__", original);
    } catch (o_O) {
    }
  }
  function getOriginalFunction(func) {
    return func.__sentry_original__;
  }
  function convertToPlainObject(value) {
    if (isError(value)) {
      return {
        message: value.message,
        name: value.name,
        stack: value.stack,
        ...getOwnProperties(value)
      };
    } else if (isEvent(value)) {
      const newObj = {
        type: value.type,
        target: serializeEventTarget(value.target),
        currentTarget: serializeEventTarget(value.currentTarget),
        ...getOwnProperties(value)
      };
      if (typeof CustomEvent !== "undefined" && isInstanceOf(value, CustomEvent)) {
        newObj.detail = value.detail;
      }
      return newObj;
    } else {
      return value;
    }
  }
  function serializeEventTarget(target) {
    try {
      return isElement(target) ? htmlTreeAsString(target) : Object.prototype.toString.call(target);
    } catch (_oO) {
      return "<unknown>";
    }
  }
  function getOwnProperties(obj) {
    if (typeof obj === "object" && obj !== null) {
      const extractedProps = {};
      for (const property in obj) {
        if (Object.prototype.hasOwnProperty.call(obj, property)) {
          extractedProps[property] = obj[property];
        }
      }
      return extractedProps;
    } else {
      return {};
    }
  }
  function extractExceptionKeysForMessage(exception, maxLength = 40) {
    const keys2 = Object.keys(convertToPlainObject(exception));
    keys2.sort();
    const firstKey = keys2[0];
    if (!firstKey) {
      return "[object has no keys]";
    }
    if (firstKey.length >= maxLength) {
      return truncate(firstKey, maxLength);
    }
    for (let includedKeys = keys2.length; includedKeys > 0; includedKeys--) {
      const serialized = keys2.slice(0, includedKeys).join(", ");
      if (serialized.length > maxLength) {
        continue;
      }
      if (includedKeys === keys2.length) {
        return serialized;
      }
      return truncate(serialized, maxLength);
    }
    return "";
  }
  function dropUndefinedKeys(inputValue) {
    const memoizationMap = /* @__PURE__ */ new Map();
    return _dropUndefinedKeys(inputValue, memoizationMap);
  }
  function _dropUndefinedKeys(inputValue, memoizationMap) {
    if (isPojo(inputValue)) {
      const memoVal = memoizationMap.get(inputValue);
      if (memoVal !== void 0) {
        return memoVal;
      }
      const returnValue = {};
      memoizationMap.set(inputValue, returnValue);
      for (const key of Object.getOwnPropertyNames(inputValue)) {
        if (typeof inputValue[key] !== "undefined") {
          returnValue[key] = _dropUndefinedKeys(inputValue[key], memoizationMap);
        }
      }
      return returnValue;
    }
    if (Array.isArray(inputValue)) {
      const memoVal = memoizationMap.get(inputValue);
      if (memoVal !== void 0) {
        return memoVal;
      }
      const returnValue = [];
      memoizationMap.set(inputValue, returnValue);
      inputValue.forEach((item) => {
        returnValue.push(_dropUndefinedKeys(item, memoizationMap));
      });
      return returnValue;
    }
    return inputValue;
  }
  function isPojo(input) {
    if (!isPlainObject$1(input)) {
      return false;
    }
    try {
      const name2 = Object.getPrototypeOf(input).constructor.name;
      return !name2 || name2 === "Object";
    } catch (e2) {
      return true;
    }
  }
  const ONE_SECOND_IN_MS = 1e3;
  function dateTimestampInSeconds() {
    return Date.now() / ONE_SECOND_IN_MS;
  }
  function createUnixTimestampInSecondsFunc() {
    const { performance } = GLOBAL_OBJ;
    if (!performance || !performance.now) {
      return dateTimestampInSeconds;
    }
    const approxStartingTimeOrigin = Date.now() - performance.now();
    const timeOrigin = performance.timeOrigin == void 0 ? approxStartingTimeOrigin : performance.timeOrigin;
    return () => {
      return (timeOrigin + performance.now()) / ONE_SECOND_IN_MS;
    };
  }
  const timestampInSeconds = createUnixTimestampInSecondsFunc();
  (() => {
    const { performance } = GLOBAL_OBJ;
    if (!performance || !performance.now) {
      return void 0;
    }
    const threshold = 3600 * 1e3;
    const performanceNow = performance.now();
    const dateNow = Date.now();
    const timeOriginDelta = performance.timeOrigin ? Math.abs(performance.timeOrigin + performanceNow - dateNow) : threshold;
    const timeOriginIsReliable = timeOriginDelta < threshold;
    const navigationStart = performance.timing && performance.timing.navigationStart;
    const hasNavigationStart = typeof navigationStart === "number";
    const navigationStartDelta = hasNavigationStart ? Math.abs(navigationStart + performanceNow - dateNow) : threshold;
    const navigationStartIsReliable = navigationStartDelta < threshold;
    if (timeOriginIsReliable || navigationStartIsReliable) {
      if (timeOriginDelta <= navigationStartDelta) {
        return performance.timeOrigin;
      } else {
        return navigationStart;
      }
    }
    return dateNow;
  })();
  function uuid4() {
    const gbl = GLOBAL_OBJ;
    const crypto2 = gbl.crypto || gbl.msCrypto;
    let getRandomByte = () => Math.random() * 16;
    try {
      if (crypto2 && crypto2.randomUUID) {
        return crypto2.randomUUID().replace(/-/g, "");
      }
      if (crypto2 && crypto2.getRandomValues) {
        getRandomByte = () => {
          const typedArray = new Uint8Array(1);
          crypto2.getRandomValues(typedArray);
          return typedArray[0];
        };
      }
    } catch (_2) {
    }
    return ("10000000100040008000" + 1e11).replace(
      /[018]/g,
      (c2) => (
        // eslint-disable-next-line no-bitwise
        (c2 ^ (getRandomByte() & 15) >> c2 / 4).toString(16)
      )
    );
  }
  function getFirstException(event) {
    return event.exception && event.exception.values ? event.exception.values[0] : void 0;
  }
  function getEventDescription(event) {
    const { message: message2, event_id: eventId } = event;
    if (message2) {
      return message2;
    }
    const firstException = getFirstException(event);
    if (firstException) {
      if (firstException.type && firstException.value) {
        return `${firstException.type}: ${firstException.value}`;
      }
      return firstException.type || firstException.value || eventId || "<unknown>";
    }
    return eventId || "<unknown>";
  }
  function addExceptionTypeValue(event, value, type2) {
    const exception = event.exception = event.exception || {};
    const values = exception.values = exception.values || [];
    const firstException = values[0] = values[0] || {};
    if (!firstException.value) {
      firstException.value = "";
    }
    if (!firstException.type) {
      firstException.type = "Error";
    }
  }
  function addExceptionMechanism(event, newMechanism) {
    const firstException = getFirstException(event);
    if (!firstException) {
      return;
    }
    const defaultMechanism = { type: "generic", handled: true };
    const currentMechanism = firstException.mechanism;
    firstException.mechanism = { ...defaultMechanism, ...currentMechanism, ...newMechanism };
    if (newMechanism && "data" in newMechanism) {
      const mergedData = { ...currentMechanism && currentMechanism.data, ...newMechanism.data };
      firstException.mechanism.data = mergedData;
    }
  }
  const SEMVER_REGEXP = /^(0|[1-9]\d*)\.(0|[1-9]\d*)\.(0|[1-9]\d*)(?:-((?:0|[1-9]\d*|\d*[a-zA-Z-][0-9a-zA-Z-]*)(?:\.(?:0|[1-9]\d*|\d*[a-zA-Z-][0-9a-zA-Z-]*))*))?(?:\+([0-9a-zA-Z-]+(?:\.[0-9a-zA-Z-]+)*))?$/;
  function _parseInt(input) {
    return parseInt(input || "", 10);
  }
  function parseSemver(input) {
    const match = input.match(SEMVER_REGEXP) || [];
    const major2 = _parseInt(match[1]);
    const minor2 = _parseInt(match[2]);
    const patch2 = _parseInt(match[3]);
    return {
      buildmetadata: match[5],
      major: isNaN(major2) ? void 0 : major2,
      minor: isNaN(minor2) ? void 0 : minor2,
      patch: isNaN(patch2) ? void 0 : patch2,
      prerelease: match[4]
    };
  }
  function checkOrSetAlreadyCaught(exception) {
    if (isAlreadyCaptured(exception)) {
      return true;
    }
    try {
      addNonEnumerableProperty(exception, "__sentry_captured__", true);
    } catch (err) {
    }
    return false;
  }
  function isAlreadyCaptured(exception) {
    try {
      return exception.__sentry_captured__;
    } catch (e2) {
    }
  }
  var States;
  (function(States2) {
    const PENDING = 0;
    States2[States2["PENDING"] = PENDING] = "PENDING";
    const RESOLVED = 1;
    States2[States2["RESOLVED"] = RESOLVED] = "RESOLVED";
    const REJECTED = 2;
    States2[States2["REJECTED"] = REJECTED] = "REJECTED";
  })(States || (States = {}));
  function resolvedSyncPromise(value) {
    return new SyncPromise((resolve2) => {
      resolve2(value);
    });
  }
  function rejectedSyncPromise(reason) {
    return new SyncPromise((_2, reject) => {
      reject(reason);
    });
  }
  class SyncPromise {
    constructor(executor) {
      SyncPromise.prototype.__init.call(this);
      SyncPromise.prototype.__init2.call(this);
      SyncPromise.prototype.__init3.call(this);
      SyncPromise.prototype.__init4.call(this);
      this._state = States.PENDING;
      this._handlers = [];
      try {
        executor(this._resolve, this._reject);
      } catch (e2) {
        this._reject(e2);
      }
    }
    /** JSDoc */
    then(onfulfilled, onrejected) {
      return new SyncPromise((resolve2, reject) => {
        this._handlers.push([
          false,
          (result) => {
            if (!onfulfilled) {
              resolve2(result);
            } else {
              try {
                resolve2(onfulfilled(result));
              } catch (e2) {
                reject(e2);
              }
            }
          },
          (reason) => {
            if (!onrejected) {
              reject(reason);
            } else {
              try {
                resolve2(onrejected(reason));
              } catch (e2) {
                reject(e2);
              }
            }
          }
        ]);
        this._executeHandlers();
      });
    }
    /** JSDoc */
    catch(onrejected) {
      return this.then((val) => val, onrejected);
    }
    /** JSDoc */
    finally(onfinally) {
      return new SyncPromise((resolve2, reject) => {
        let val;
        let isRejected;
        return this.then(
          (value) => {
            isRejected = false;
            val = value;
            if (onfinally) {
              onfinally();
            }
          },
          (reason) => {
            isRejected = true;
            val = reason;
            if (onfinally) {
              onfinally();
            }
          }
        ).then(() => {
          if (isRejected) {
            reject(val);
            return;
          }
          resolve2(val);
        });
      });
    }
    /** JSDoc */
    __init() {
      this._resolve = (value) => {
        this._setResult(States.RESOLVED, value);
      };
    }
    /** JSDoc */
    __init2() {
      this._reject = (reason) => {
        this._setResult(States.REJECTED, reason);
      };
    }
    /** JSDoc */
    __init3() {
      this._setResult = (state, value) => {
        if (this._state !== States.PENDING) {
          return;
        }
        if (isThenable(value)) {
          void value.then(this._resolve, this._reject);
          return;
        }
        this._state = state;
        this._value = value;
        this._executeHandlers();
      };
    }
    /** JSDoc */
    __init4() {
      this._executeHandlers = () => {
        if (this._state === States.PENDING) {
          return;
        }
        const cachedHandlers = this._handlers.slice();
        this._handlers = [];
        cachedHandlers.forEach((handler) => {
          if (handler[0]) {
            return;
          }
          if (this._state === States.RESOLVED) {
            handler[1](this._value);
          }
          if (this._state === States.REJECTED) {
            handler[2](this._value);
          }
          handler[0] = true;
        });
      };
    }
  }
  function makeSession(context2) {
    const startingTime = timestampInSeconds();
    const session = {
      sid: uuid4(),
      init: true,
      timestamp: startingTime,
      started: startingTime,
      duration: 0,
      status: "ok",
      errors: 0,
      ignoreDuration: false,
      toJSON: () => sessionToJSON(session)
    };
    if (context2) {
      updateSession(session, context2);
    }
    return session;
  }
  function updateSession(session, context2 = {}) {
    if (context2.user) {
      if (!session.ipAddress && context2.user.ip_address) {
        session.ipAddress = context2.user.ip_address;
      }
      if (!session.did && !context2.did) {
        session.did = context2.user.id || context2.user.email || context2.user.username;
      }
    }
    session.timestamp = context2.timestamp || timestampInSeconds();
    if (context2.abnormal_mechanism) {
      session.abnormal_mechanism = context2.abnormal_mechanism;
    }
    if (context2.ignoreDuration) {
      session.ignoreDuration = context2.ignoreDuration;
    }
    if (context2.sid) {
      session.sid = context2.sid.length === 32 ? context2.sid : uuid4();
    }
    if (context2.init !== void 0) {
      session.init = context2.init;
    }
    if (!session.did && context2.did) {
      session.did = `${context2.did}`;
    }
    if (typeof context2.started === "number") {
      session.started = context2.started;
    }
    if (session.ignoreDuration) {
      session.duration = void 0;
    } else if (typeof context2.duration === "number") {
      session.duration = context2.duration;
    } else {
      const duration = session.timestamp - session.started;
      session.duration = duration >= 0 ? duration : 0;
    }
    if (context2.release) {
      session.release = context2.release;
    }
    if (context2.environment) {
      session.environment = context2.environment;
    }
    if (!session.ipAddress && context2.ipAddress) {
      session.ipAddress = context2.ipAddress;
    }
    if (!session.userAgent && context2.userAgent) {
      session.userAgent = context2.userAgent;
    }
    if (typeof context2.errors === "number") {
      session.errors = context2.errors;
    }
    if (context2.status) {
      session.status = context2.status;
    }
  }
  function closeSession(session, status) {
    let context2 = {};
    if (session.status === "ok") {
      context2 = { status: "exited" };
    }
    updateSession(session, context2);
  }
  function sessionToJSON(session) {
    return dropUndefinedKeys({
      sid: `${session.sid}`,
      init: session.init,
      // Make sure that sec is converted to ms for date constructor
      started: new Date(session.started * 1e3).toISOString(),
      timestamp: new Date(session.timestamp * 1e3).toISOString(),
      status: session.status,
      errors: session.errors,
      did: typeof session.did === "number" || typeof session.did === "string" ? `${session.did}` : void 0,
      duration: session.duration,
      abnormal_mechanism: session.abnormal_mechanism,
      attrs: {
        release: session.release,
        environment: session.environment,
        ip_address: session.ipAddress,
        user_agent: session.userAgent
      }
    });
  }
  function generateTraceId() {
    return uuid4();
  }
  function generateSpanId() {
    return uuid4().substring(16);
  }
  function merge$1(initialObj, mergeObj, levels = 2) {
    if (!mergeObj || typeof mergeObj !== "object" || levels <= 0) {
      return mergeObj;
    }
    if (initialObj && mergeObj && Object.keys(mergeObj).length === 0) {
      return initialObj;
    }
    const output = { ...initialObj };
    for (const key in mergeObj) {
      if (Object.prototype.hasOwnProperty.call(mergeObj, key)) {
        output[key] = merge$1(output[key], mergeObj[key], levels - 1);
      }
    }
    return output;
  }
  const SCOPE_SPAN_FIELD = "_sentrySpan";
  function _setSpanForScope(scope2, span) {
    if (span) {
      addNonEnumerableProperty(scope2, SCOPE_SPAN_FIELD, span);
    } else {
      delete scope2[SCOPE_SPAN_FIELD];
    }
  }
  function _getSpanForScope(scope2) {
    return scope2[SCOPE_SPAN_FIELD];
  }
  const DEFAULT_MAX_BREADCRUMBS = 100;
  class ScopeClass {
    /** Flag if notifying is happening. */
    /** Callback for client to receive scope changes. */
    /** Callback list that will be called during event processing. */
    /** Array of breadcrumbs. */
    /** User */
    /** Tags */
    /** Extra */
    /** Contexts */
    /** Attachments */
    /** Propagation Context for distributed tracing */
    /**
     * A place to stash data which is needed at some point in the SDK's event processing pipeline but which shouldn't get
     * sent to Sentry
     */
    /** Fingerprint */
    /** Severity */
    /**
     * Transaction Name
     *
     * IMPORTANT: The transaction name on the scope has nothing to do with root spans/transaction objects.
     * It's purpose is to assign a transaction to the scope that's added to non-transaction events.
     */
    /** Session */
    /** Request Mode Session Status */
    /** The client on this scope */
    /** Contains the last event id of a captured event.  */
    // NOTE: Any field which gets added here should get added not only to the constructor but also to the `clone` method.
    constructor() {
      this._notifyingListeners = false;
      this._scopeListeners = [];
      this._eventProcessors = [];
      this._breadcrumbs = [];
      this._attachments = [];
      this._user = {};
      this._tags = {};
      this._extra = {};
      this._contexts = {};
      this._sdkProcessingMetadata = {};
      this._propagationContext = {
        traceId: generateTraceId(),
        spanId: generateSpanId()
      };
    }
    /**
     * @inheritDoc
     */
    clone() {
      const newScope = new ScopeClass();
      newScope._breadcrumbs = [...this._breadcrumbs];
      newScope._tags = { ...this._tags };
      newScope._extra = { ...this._extra };
      newScope._contexts = { ...this._contexts };
      newScope._user = this._user;
      newScope._level = this._level;
      newScope._session = this._session;
      newScope._transactionName = this._transactionName;
      newScope._fingerprint = this._fingerprint;
      newScope._eventProcessors = [...this._eventProcessors];
      newScope._requestSession = this._requestSession;
      newScope._attachments = [...this._attachments];
      newScope._sdkProcessingMetadata = { ...this._sdkProcessingMetadata };
      newScope._propagationContext = { ...this._propagationContext };
      newScope._client = this._client;
      newScope._lastEventId = this._lastEventId;
      _setSpanForScope(newScope, _getSpanForScope(this));
      return newScope;
    }
    /**
     * @inheritDoc
     */
    setClient(client) {
      this._client = client;
    }
    /**
     * @inheritDoc
     */
    setLastEventId(lastEventId) {
      this._lastEventId = lastEventId;
    }
    /**
     * @inheritDoc
     */
    getClient() {
      return this._client;
    }
    /**
     * @inheritDoc
     */
    lastEventId() {
      return this._lastEventId;
    }
    /**
     * @inheritDoc
     */
    addScopeListener(callback) {
      this._scopeListeners.push(callback);
    }
    /**
     * @inheritDoc
     */
    addEventProcessor(callback) {
      this._eventProcessors.push(callback);
      return this;
    }
    /**
     * @inheritDoc
     */
    setUser(user) {
      this._user = user || {
        email: void 0,
        id: void 0,
        ip_address: void 0,
        username: void 0
      };
      if (this._session) {
        updateSession(this._session, { user });
      }
      this._notifyScopeListeners();
      return this;
    }
    /**
     * @inheritDoc
     */
    getUser() {
      return this._user;
    }
    /**
     * @inheritDoc
     */
    getRequestSession() {
      return this._requestSession;
    }
    /**
     * @inheritDoc
     */
    setRequestSession(requestSession) {
      this._requestSession = requestSession;
      return this;
    }
    /**
     * @inheritDoc
     */
    setTags(tags) {
      this._tags = {
        ...this._tags,
        ...tags
      };
      this._notifyScopeListeners();
      return this;
    }
    /**
     * @inheritDoc
     */
    setTag(key, value) {
      this._tags = { ...this._tags, [key]: value };
      this._notifyScopeListeners();
      return this;
    }
    /**
     * @inheritDoc
     */
    setExtras(extras) {
      this._extra = {
        ...this._extra,
        ...extras
      };
      this._notifyScopeListeners();
      return this;
    }
    /**
     * @inheritDoc
     */
    setExtra(key, extra) {
      this._extra = { ...this._extra, [key]: extra };
      this._notifyScopeListeners();
      return this;
    }
    /**
     * @inheritDoc
     */
    setFingerprint(fingerprint) {
      this._fingerprint = fingerprint;
      this._notifyScopeListeners();
      return this;
    }
    /**
     * @inheritDoc
     */
    setLevel(level) {
      this._level = level;
      this._notifyScopeListeners();
      return this;
    }
    /**
     * @inheritDoc
     */
    setTransactionName(name2) {
      this._transactionName = name2;
      this._notifyScopeListeners();
      return this;
    }
    /**
     * @inheritDoc
     */
    setContext(key, context2) {
      if (context2 === null) {
        delete this._contexts[key];
      } else {
        this._contexts[key] = context2;
      }
      this._notifyScopeListeners();
      return this;
    }
    /**
     * @inheritDoc
     */
    setSession(session) {
      if (!session) {
        delete this._session;
      } else {
        this._session = session;
      }
      this._notifyScopeListeners();
      return this;
    }
    /**
     * @inheritDoc
     */
    getSession() {
      return this._session;
    }
    /**
     * @inheritDoc
     */
    update(captureContext) {
      if (!captureContext) {
        return this;
      }
      const scopeToMerge = typeof captureContext === "function" ? captureContext(this) : captureContext;
      const [scopeInstance, requestSession] = scopeToMerge instanceof Scope ? [scopeToMerge.getScopeData(), scopeToMerge.getRequestSession()] : isPlainObject$1(scopeToMerge) ? [captureContext, captureContext.requestSession] : [];
      const { tags, extra, user, contexts, level, fingerprint = [], propagationContext } = scopeInstance || {};
      this._tags = { ...this._tags, ...tags };
      this._extra = { ...this._extra, ...extra };
      this._contexts = { ...this._contexts, ...contexts };
      if (user && Object.keys(user).length) {
        this._user = user;
      }
      if (level) {
        this._level = level;
      }
      if (fingerprint.length) {
        this._fingerprint = fingerprint;
      }
      if (propagationContext) {
        this._propagationContext = propagationContext;
      }
      if (requestSession) {
        this._requestSession = requestSession;
      }
      return this;
    }
    /**
     * @inheritDoc
     */
    clear() {
      this._breadcrumbs = [];
      this._tags = {};
      this._extra = {};
      this._user = {};
      this._contexts = {};
      this._level = void 0;
      this._transactionName = void 0;
      this._fingerprint = void 0;
      this._requestSession = void 0;
      this._session = void 0;
      _setSpanForScope(this, void 0);
      this._attachments = [];
      this.setPropagationContext({ traceId: generateTraceId() });
      this._notifyScopeListeners();
      return this;
    }
    /**
     * @inheritDoc
     */
    addBreadcrumb(breadcrumb, maxBreadcrumbs) {
      const maxCrumbs = typeof maxBreadcrumbs === "number" ? maxBreadcrumbs : DEFAULT_MAX_BREADCRUMBS;
      if (maxCrumbs <= 0) {
        return this;
      }
      const mergedBreadcrumb = {
        timestamp: dateTimestampInSeconds(),
        ...breadcrumb
      };
      const breadcrumbs = this._breadcrumbs;
      breadcrumbs.push(mergedBreadcrumb);
      this._breadcrumbs = breadcrumbs.length > maxCrumbs ? breadcrumbs.slice(-maxCrumbs) : breadcrumbs;
      this._notifyScopeListeners();
      return this;
    }
    /**
     * @inheritDoc
     */
    getLastBreadcrumb() {
      return this._breadcrumbs[this._breadcrumbs.length - 1];
    }
    /**
     * @inheritDoc
     */
    clearBreadcrumbs() {
      this._breadcrumbs = [];
      this._notifyScopeListeners();
      return this;
    }
    /**
     * @inheritDoc
     */
    addAttachment(attachment) {
      this._attachments.push(attachment);
      return this;
    }
    /**
     * @inheritDoc
     */
    clearAttachments() {
      this._attachments = [];
      return this;
    }
    /** @inheritDoc */
    getScopeData() {
      return {
        breadcrumbs: this._breadcrumbs,
        attachments: this._attachments,
        contexts: this._contexts,
        tags: this._tags,
        extra: this._extra,
        user: this._user,
        level: this._level,
        fingerprint: this._fingerprint || [],
        eventProcessors: this._eventProcessors,
        propagationContext: this._propagationContext,
        sdkProcessingMetadata: this._sdkProcessingMetadata,
        transactionName: this._transactionName,
        span: _getSpanForScope(this)
      };
    }
    /**
     * @inheritDoc
     */
    setSDKProcessingMetadata(newData) {
      this._sdkProcessingMetadata = merge$1(this._sdkProcessingMetadata, newData, 2);
      return this;
    }
    /**
     * @inheritDoc
     */
    setPropagationContext(context2) {
      this._propagationContext = {
        // eslint-disable-next-line deprecation/deprecation
        spanId: generateSpanId(),
        ...context2
      };
      return this;
    }
    /**
     * @inheritDoc
     */
    getPropagationContext() {
      return this._propagationContext;
    }
    /**
     * @inheritDoc
     */
    captureException(exception, hint) {
      const eventId = hint && hint.event_id ? hint.event_id : uuid4();
      if (!this._client) {
        logger$2.warn("No client configured on scope - will not capture exception!");
        return eventId;
      }
      const syntheticException = new Error("Sentry syntheticException");
      this._client.captureException(
        exception,
        {
          originalException: exception,
          syntheticException,
          ...hint,
          event_id: eventId
        },
        this
      );
      return eventId;
    }
    /**
     * @inheritDoc
     */
    captureMessage(message2, level, hint) {
      const eventId = hint && hint.event_id ? hint.event_id : uuid4();
      if (!this._client) {
        logger$2.warn("No client configured on scope - will not capture message!");
        return eventId;
      }
      const syntheticException = new Error(message2);
      this._client.captureMessage(
        message2,
        level,
        {
          originalException: message2,
          syntheticException,
          ...hint,
          event_id: eventId
        },
        this
      );
      return eventId;
    }
    /**
     * @inheritDoc
     */
    captureEvent(event, hint) {
      const eventId = hint && hint.event_id ? hint.event_id : uuid4();
      if (!this._client) {
        logger$2.warn("No client configured on scope - will not capture event!");
        return eventId;
      }
      this._client.captureEvent(event, { ...hint, event_id: eventId }, this);
      return eventId;
    }
    /**
     * This will be called on every set call.
     */
    _notifyScopeListeners() {
      if (!this._notifyingListeners) {
        this._notifyingListeners = true;
        this._scopeListeners.forEach((callback) => {
          callback(this);
        });
        this._notifyingListeners = false;
      }
    }
  }
  const Scope = ScopeClass;
  function getDefaultCurrentScope() {
    return getGlobalSingleton("defaultCurrentScope", () => new Scope());
  }
  function getDefaultIsolationScope() {
    return getGlobalSingleton("defaultIsolationScope", () => new Scope());
  }
  class AsyncContextStack {
    constructor(scope2, isolationScope) {
      let assignedScope;
      if (!scope2) {
        assignedScope = new Scope();
      } else {
        assignedScope = scope2;
      }
      let assignedIsolationScope;
      if (!isolationScope) {
        assignedIsolationScope = new Scope();
      } else {
        assignedIsolationScope = isolationScope;
      }
      this._stack = [{ scope: assignedScope }];
      this._isolationScope = assignedIsolationScope;
    }
    /**
     * Fork a scope for the stack.
     */
    withScope(callback) {
      const scope2 = this._pushScope();
      let maybePromiseResult;
      try {
        maybePromiseResult = callback(scope2);
      } catch (e2) {
        this._popScope();
        throw e2;
      }
      if (isThenable(maybePromiseResult)) {
        return maybePromiseResult.then(
          (res) => {
            this._popScope();
            return res;
          },
          (e2) => {
            this._popScope();
            throw e2;
          }
        );
      }
      this._popScope();
      return maybePromiseResult;
    }
    /**
     * Get the client of the stack.
     */
    getClient() {
      return this.getStackTop().client;
    }
    /**
     * Returns the scope of the top stack.
     */
    getScope() {
      return this.getStackTop().scope;
    }
    /**
     * Get the isolation scope for the stack.
     */
    getIsolationScope() {
      return this._isolationScope;
    }
    /**
     * Returns the topmost scope layer in the order domain > local > process.
     */
    getStackTop() {
      return this._stack[this._stack.length - 1];
    }
    /**
     * Push a scope to the stack.
     */
    _pushScope() {
      const scope2 = this.getScope().clone();
      this._stack.push({
        client: this.getClient(),
        scope: scope2
      });
      return scope2;
    }
    /**
     * Pop a scope from the stack.
     */
    _popScope() {
      if (this._stack.length <= 1) return false;
      return !!this._stack.pop();
    }
  }
  function getAsyncContextStack() {
    const registry = getMainCarrier();
    const sentry = getSentryCarrier(registry);
    return sentry.stack = sentry.stack || new AsyncContextStack(getDefaultCurrentScope(), getDefaultIsolationScope());
  }
  function withScope$1(callback) {
    return getAsyncContextStack().withScope(callback);
  }
  function withSetScope(scope2, callback) {
    const stack = getAsyncContextStack();
    return stack.withScope(() => {
      stack.getStackTop().scope = scope2;
      return callback(scope2);
    });
  }
  function withIsolationScope(callback) {
    return getAsyncContextStack().withScope(() => {
      return callback(getAsyncContextStack().getIsolationScope());
    });
  }
  function getStackAsyncContextStrategy() {
    return {
      withIsolationScope,
      withScope: withScope$1,
      withSetScope,
      withSetIsolationScope: (_isolationScope, callback) => {
        return withIsolationScope(callback);
      },
      getCurrentScope: () => getAsyncContextStack().getScope(),
      getIsolationScope: () => getAsyncContextStack().getIsolationScope()
    };
  }
  function setAsyncContextStrategy(strategy) {
    const registry = getMainCarrier();
    const sentry = getSentryCarrier(registry);
    sentry.acs = strategy;
  }
  function getAsyncContextStrategy(carrier) {
    const sentry = getSentryCarrier(carrier);
    if (sentry.acs) {
      return sentry.acs;
    }
    return getStackAsyncContextStrategy();
  }
  function getCurrentScope() {
    const carrier = getMainCarrier();
    const acs = getAsyncContextStrategy(carrier);
    return acs.getCurrentScope();
  }
  function getIsolationScope() {
    const carrier = getMainCarrier();
    const acs = getAsyncContextStrategy(carrier);
    return acs.getIsolationScope();
  }
  function getGlobalScope() {
    return getGlobalSingleton("globalScope", () => new Scope());
  }
  function withScope(...rest) {
    const carrier = getMainCarrier();
    const acs = getAsyncContextStrategy(carrier);
    if (rest.length === 2) {
      const [scope2, callback] = rest;
      if (!scope2) {
        return acs.withScope(callback);
      }
      return acs.withSetScope(scope2, callback);
    }
    return acs.withScope(rest[0]);
  }
  function getClient() {
    return getCurrentScope().getClient();
  }
  function getTraceContextFromScope(scope2) {
    const propagationContext = scope2.getPropagationContext();
    const { traceId, spanId, parentSpanId } = propagationContext;
    const traceContext = dropUndefinedKeys({
      trace_id: traceId,
      span_id: spanId,
      parent_span_id: parentSpanId
    });
    return traceContext;
  }
  const METRICS_SPAN_FIELD = "_sentryMetrics";
  function getMetricSummaryJsonForSpan(span) {
    const storage = span[METRICS_SPAN_FIELD];
    if (!storage) {
      return void 0;
    }
    const output = {};
    for (const [, [exportKey, summary]] of storage) {
      const arr = output[exportKey] || (output[exportKey] = []);
      arr.push(dropUndefinedKeys(summary));
    }
    return output;
  }
  function updateMetricSummaryOnSpan(span, metricType, sanitizedName, value, unit, tags, bucketKey) {
    const existingStorage = span[METRICS_SPAN_FIELD];
    const storage = existingStorage || (span[METRICS_SPAN_FIELD] = /* @__PURE__ */ new Map());
    const exportKey = `${metricType}:${sanitizedName}@${unit}`;
    const bucketItem = storage.get(bucketKey);
    if (bucketItem) {
      const [, summary] = bucketItem;
      storage.set(bucketKey, [
        exportKey,
        {
          min: Math.min(summary.min, value),
          max: Math.max(summary.max, value),
          count: summary.count += 1,
          sum: summary.sum += value,
          tags: summary.tags
        }
      ]);
    } else {
      storage.set(bucketKey, [
        exportKey,
        {
          min: value,
          max: value,
          count: 1,
          sum: value,
          tags
        }
      ]);
    }
  }
  const SEMANTIC_ATTRIBUTE_SENTRY_SOURCE = "sentry.source";
  const SEMANTIC_ATTRIBUTE_SENTRY_SAMPLE_RATE = "sentry.sample_rate";
  const SEMANTIC_ATTRIBUTE_SENTRY_OP = "sentry.op";
  const SEMANTIC_ATTRIBUTE_SENTRY_ORIGIN = "sentry.origin";
  const SEMANTIC_ATTRIBUTE_SENTRY_MEASUREMENT_UNIT = "sentry.measurement_unit";
  const SEMANTIC_ATTRIBUTE_SENTRY_MEASUREMENT_VALUE = "sentry.measurement_value";
  const SEMANTIC_ATTRIBUTE_PROFILE_ID = "sentry.profile_id";
  const SEMANTIC_ATTRIBUTE_EXCLUSIVE_TIME = "sentry.exclusive_time";
  const SPAN_STATUS_UNSET = 0;
  const SPAN_STATUS_OK = 1;
  const SPAN_STATUS_ERROR = 2;
  function getSpanStatusFromHttpCode(httpStatus) {
    if (httpStatus < 400 && httpStatus >= 100) {
      return { code: SPAN_STATUS_OK };
    }
    if (httpStatus >= 400 && httpStatus < 500) {
      switch (httpStatus) {
        case 401:
          return { code: SPAN_STATUS_ERROR, message: "unauthenticated" };
        case 403:
          return { code: SPAN_STATUS_ERROR, message: "permission_denied" };
        case 404:
          return { code: SPAN_STATUS_ERROR, message: "not_found" };
        case 409:
          return { code: SPAN_STATUS_ERROR, message: "already_exists" };
        case 413:
          return { code: SPAN_STATUS_ERROR, message: "failed_precondition" };
        case 429:
          return { code: SPAN_STATUS_ERROR, message: "resource_exhausted" };
        case 499:
          return { code: SPAN_STATUS_ERROR, message: "cancelled" };
        default:
          return { code: SPAN_STATUS_ERROR, message: "invalid_argument" };
      }
    }
    if (httpStatus >= 500 && httpStatus < 600) {
      switch (httpStatus) {
        case 501:
          return { code: SPAN_STATUS_ERROR, message: "unimplemented" };
        case 503:
          return { code: SPAN_STATUS_ERROR, message: "unavailable" };
        case 504:
          return { code: SPAN_STATUS_ERROR, message: "deadline_exceeded" };
        default:
          return { code: SPAN_STATUS_ERROR, message: "internal_error" };
      }
    }
    return { code: SPAN_STATUS_ERROR, message: "unknown_error" };
  }
  function setHttpStatus(span, httpStatus) {
    span.setAttribute("http.response.status_code", httpStatus);
    const spanStatus = getSpanStatusFromHttpCode(httpStatus);
    if (spanStatus.message !== "unknown_error") {
      span.setStatus(spanStatus);
    }
  }
  const SENTRY_BAGGAGE_KEY_PREFIX = "sentry-";
  const SENTRY_BAGGAGE_KEY_PREFIX_REGEX = /^sentry-/;
  const MAX_BAGGAGE_STRING_LENGTH = 8192;
  function baggageHeaderToDynamicSamplingContext(baggageHeader) {
    const baggageObject = parseBaggageHeader(baggageHeader);
    if (!baggageObject) {
      return void 0;
    }
    const dynamicSamplingContext = Object.entries(baggageObject).reduce((acc, [key, value]) => {
      if (key.match(SENTRY_BAGGAGE_KEY_PREFIX_REGEX)) {
        const nonPrefixedKey = key.slice(SENTRY_BAGGAGE_KEY_PREFIX.length);
        acc[nonPrefixedKey] = value;
      }
      return acc;
    }, {});
    if (Object.keys(dynamicSamplingContext).length > 0) {
      return dynamicSamplingContext;
    } else {
      return void 0;
    }
  }
  function dynamicSamplingContextToSentryBaggageHeader(dynamicSamplingContext) {
    if (!dynamicSamplingContext) {
      return void 0;
    }
    const sentryPrefixedDSC = Object.entries(dynamicSamplingContext).reduce(
      (acc, [dscKey, dscValue]) => {
        if (dscValue) {
          acc[`${SENTRY_BAGGAGE_KEY_PREFIX}${dscKey}`] = dscValue;
        }
        return acc;
      },
      {}
    );
    return objectToBaggageHeader(sentryPrefixedDSC);
  }
  function parseBaggageHeader(baggageHeader) {
    if (!baggageHeader || !isString$1(baggageHeader) && !Array.isArray(baggageHeader)) {
      return void 0;
    }
    if (Array.isArray(baggageHeader)) {
      return baggageHeader.reduce((acc, curr) => {
        const currBaggageObject = baggageHeaderToObject(curr);
        Object.entries(currBaggageObject).forEach(([key, value]) => {
          acc[key] = value;
        });
        return acc;
      }, {});
    }
    return baggageHeaderToObject(baggageHeader);
  }
  function baggageHeaderToObject(baggageHeader) {
    return baggageHeader.split(",").map((baggageEntry) => baggageEntry.split("=").map((keyOrValue) => decodeURIComponent(keyOrValue.trim()))).reduce((acc, [key, value]) => {
      if (key && value) {
        acc[key] = value;
      }
      return acc;
    }, {});
  }
  function objectToBaggageHeader(object2) {
    if (Object.keys(object2).length === 0) {
      return void 0;
    }
    return Object.entries(object2).reduce((baggageHeader, [objectKey, objectValue], currentIndex) => {
      const baggageEntry = `${encodeURIComponent(objectKey)}=${encodeURIComponent(objectValue)}`;
      const newBaggageHeader = currentIndex === 0 ? baggageEntry : `${baggageHeader},${baggageEntry}`;
      if (newBaggageHeader.length > MAX_BAGGAGE_STRING_LENGTH) {
        DEBUG_BUILD$2 && logger$2.warn(
          `Not adding key: ${objectKey} with val: ${objectValue} to baggage header due to exceeding baggage size limits.`
        );
        return baggageHeader;
      } else {
        return newBaggageHeader;
      }
    }, "");
  }
  const TRACEPARENT_REGEXP = new RegExp(
    "^[ \\t]*([0-9a-f]{32})?-?([0-9a-f]{16})?-?([01])?[ \\t]*$"
    // whitespace
  );
  function extractTraceparentData(traceparent) {
    if (!traceparent) {
      return void 0;
    }
    const matches = traceparent.match(TRACEPARENT_REGEXP);
    if (!matches) {
      return void 0;
    }
    let parentSampled;
    if (matches[3] === "1") {
      parentSampled = true;
    } else if (matches[3] === "0") {
      parentSampled = false;
    }
    return {
      traceId: matches[1],
      parentSampled,
      parentSpanId: matches[2]
    };
  }
  function propagationContextFromHeaders(sentryTrace, baggage) {
    const traceparentData = extractTraceparentData(sentryTrace);
    const dynamicSamplingContext = baggageHeaderToDynamicSamplingContext(baggage);
    if (!traceparentData || !traceparentData.traceId) {
      return { traceId: generateTraceId(), spanId: generateSpanId() };
    }
    const { traceId, parentSpanId, parentSampled } = traceparentData;
    const virtualSpanId = generateSpanId();
    return {
      traceId,
      parentSpanId,
      spanId: virtualSpanId,
      sampled: parentSampled,
      dsc: dynamicSamplingContext || {}
      // If we have traceparent data but no DSC it means we are not head of trace and we must freeze it
    };
  }
  function generateSentryTraceHeader(traceId = uuid4(), spanId = uuid4().substring(16), sampled) {
    let sampledString = "";
    if (sampled !== void 0) {
      sampledString = sampled ? "-1" : "-0";
    }
    return `${traceId}-${spanId}${sampledString}`;
  }
  const TRACE_FLAG_NONE = 0;
  const TRACE_FLAG_SAMPLED = 1;
  let hasShownSpanDropWarning = false;
  function spanToTransactionTraceContext(span) {
    const { spanId: span_id, traceId: trace_id } = span.spanContext();
    const { data: data2, op, parent_span_id, status, origin } = spanToJSON(span);
    return dropUndefinedKeys({
      parent_span_id,
      span_id,
      trace_id,
      data: data2,
      op,
      status,
      origin
    });
  }
  function spanToTraceContext(span) {
    const { spanId: span_id, traceId: trace_id } = span.spanContext();
    const { parent_span_id } = spanToJSON(span);
    return dropUndefinedKeys({ parent_span_id, span_id, trace_id });
  }
  function spanToTraceHeader(span) {
    const { traceId, spanId } = span.spanContext();
    const sampled = spanIsSampled(span);
    return generateSentryTraceHeader(traceId, spanId, sampled);
  }
  function spanTimeInputToSeconds(input) {
    if (typeof input === "number") {
      return ensureTimestampInSeconds(input);
    }
    if (Array.isArray(input)) {
      return input[0] + input[1] / 1e9;
    }
    if (input instanceof Date) {
      return ensureTimestampInSeconds(input.getTime());
    }
    return timestampInSeconds();
  }
  function ensureTimestampInSeconds(timestamp) {
    const isMs = timestamp > 9999999999;
    return isMs ? timestamp / 1e3 : timestamp;
  }
  function spanToJSON(span) {
    if (spanIsSentrySpan(span)) {
      return span.getSpanJSON();
    }
    try {
      const { spanId: span_id, traceId: trace_id } = span.spanContext();
      if (spanIsOpenTelemetrySdkTraceBaseSpan(span)) {
        const { attributes, startTime, name: name2, endTime, parentSpanId, status } = span;
        return dropUndefinedKeys({
          span_id,
          trace_id,
          data: attributes,
          description: name2,
          parent_span_id: parentSpanId,
          start_timestamp: spanTimeInputToSeconds(startTime),
          // This is [0,0] by default in OTEL, in which case we want to interpret this as no end time
          timestamp: spanTimeInputToSeconds(endTime) || void 0,
          status: getStatusMessage(status),
          op: attributes[SEMANTIC_ATTRIBUTE_SENTRY_OP],
          origin: attributes[SEMANTIC_ATTRIBUTE_SENTRY_ORIGIN],
          _metrics_summary: getMetricSummaryJsonForSpan(span)
        });
      }
      return {
        span_id,
        trace_id
      };
    } catch (e2) {
      return {};
    }
  }
  function spanIsOpenTelemetrySdkTraceBaseSpan(span) {
    const castSpan = span;
    return !!castSpan.attributes && !!castSpan.startTime && !!castSpan.name && !!castSpan.endTime && !!castSpan.status;
  }
  function spanIsSentrySpan(span) {
    return typeof span.getSpanJSON === "function";
  }
  function spanIsSampled(span) {
    const { traceFlags } = span.spanContext();
    return traceFlags === TRACE_FLAG_SAMPLED;
  }
  function getStatusMessage(status) {
    if (!status || status.code === SPAN_STATUS_UNSET) {
      return void 0;
    }
    if (status.code === SPAN_STATUS_OK) {
      return "ok";
    }
    return status.message || "unknown_error";
  }
  const CHILD_SPANS_FIELD = "_sentryChildSpans";
  const ROOT_SPAN_FIELD = "_sentryRootSpan";
  function addChildSpanToSpan(span, childSpan) {
    const rootSpan = span[ROOT_SPAN_FIELD] || span;
    addNonEnumerableProperty(childSpan, ROOT_SPAN_FIELD, rootSpan);
    if (span[CHILD_SPANS_FIELD]) {
      span[CHILD_SPANS_FIELD].add(childSpan);
    } else {
      addNonEnumerableProperty(span, CHILD_SPANS_FIELD, /* @__PURE__ */ new Set([childSpan]));
    }
  }
  function getSpanDescendants(span) {
    const resultSet = /* @__PURE__ */ new Set();
    function addSpanChildren(span2) {
      if (resultSet.has(span2)) {
        return;
      } else if (spanIsSampled(span2)) {
        resultSet.add(span2);
        const childSpans = span2[CHILD_SPANS_FIELD] ? Array.from(span2[CHILD_SPANS_FIELD]) : [];
        for (const childSpan of childSpans) {
          addSpanChildren(childSpan);
        }
      }
    }
    addSpanChildren(span);
    return Array.from(resultSet);
  }
  function getRootSpan(span) {
    return span[ROOT_SPAN_FIELD] || span;
  }
  function getActiveSpan$2() {
    const carrier = getMainCarrier();
    const acs = getAsyncContextStrategy(carrier);
    if (acs.getActiveSpan) {
      return acs.getActiveSpan();
    }
    return _getSpanForScope(getCurrentScope());
  }
  function updateMetricSummaryOnActiveSpan(metricType, sanitizedName, value, unit, tags, bucketKey) {
    const span = getActiveSpan$2();
    if (span) {
      updateMetricSummaryOnSpan(span, metricType, sanitizedName, value, unit, tags, bucketKey);
    }
  }
  function showSpanDropWarning() {
    if (!hasShownSpanDropWarning) {
      consoleSandbox(() => {
        console.warn(
          "[Sentry] Deprecation warning: Returning null from `beforeSendSpan` will be disallowed from SDK version 9.0.0 onwards. The callback will only support mutating spans. To drop certain spans, configure the respective integrations directly."
        );
      });
      hasShownSpanDropWarning = true;
    }
  }
  let errorsInstrumented = false;
  function registerSpanErrorInstrumentation() {
    if (errorsInstrumented) {
      return;
    }
    errorsInstrumented = true;
    addGlobalErrorInstrumentationHandler(errorCallback);
    addGlobalUnhandledRejectionInstrumentationHandler(errorCallback);
  }
  function errorCallback() {
    const activeSpan = getActiveSpan$2();
    const rootSpan = activeSpan && getRootSpan(activeSpan);
    if (rootSpan) {
      const message2 = "internal_error";
      DEBUG_BUILD$3 && logger$2.log(`[Tracing] Root span: ${message2} -> Global error occurred`);
      rootSpan.setStatus({ code: SPAN_STATUS_ERROR, message: message2 });
    }
  }
  errorCallback.tag = "sentry_tracingErrorCallback";
  const SCOPE_ON_START_SPAN_FIELD = "_sentryScope";
  const ISOLATION_SCOPE_ON_START_SPAN_FIELD = "_sentryIsolationScope";
  function setCapturedScopesOnSpan(span, scope2, isolationScope) {
    if (span) {
      addNonEnumerableProperty(span, ISOLATION_SCOPE_ON_START_SPAN_FIELD, isolationScope);
      addNonEnumerableProperty(span, SCOPE_ON_START_SPAN_FIELD, scope2);
    }
  }
  function getCapturedScopesOnSpan(span) {
    return {
      scope: span[SCOPE_ON_START_SPAN_FIELD],
      isolationScope: span[ISOLATION_SCOPE_ON_START_SPAN_FIELD]
    };
  }
  function hasTracingEnabled(maybeOptions) {
    if (typeof __SENTRY_TRACING__ === "boolean" && !__SENTRY_TRACING__) {
      return false;
    }
    const client = getClient();
    const options = maybeOptions || client && client.getOptions();
    return !!options && (options.enableTracing || "tracesSampleRate" in options || "tracesSampler" in options);
  }
  class SentryNonRecordingSpan {
    constructor(spanContext = {}) {
      this._traceId = spanContext.traceId || uuid4();
      this._spanId = spanContext.spanId || uuid4().substring(16);
    }
    /** @inheritdoc */
    spanContext() {
      return {
        spanId: this._spanId,
        traceId: this._traceId,
        traceFlags: TRACE_FLAG_NONE
      };
    }
    /** @inheritdoc */
    // eslint-disable-next-line @typescript-eslint/no-empty-function
    end(_timestamp) {
    }
    /** @inheritdoc */
    setAttribute(_key, _value) {
      return this;
    }
    /** @inheritdoc */
    setAttributes(_values) {
      return this;
    }
    /** @inheritdoc */
    setStatus(_status) {
      return this;
    }
    /** @inheritdoc */
    updateName(_name) {
      return this;
    }
    /** @inheritdoc */
    isRecording() {
      return false;
    }
    /** @inheritdoc */
    addEvent(_name, _attributesOrStartTime, _startTime) {
      return this;
    }
    /**
     * This should generally not be used,
     * but we need it for being compliant with the OTEL Span interface.
     *
     * @hidden
     * @internal
     */
    addLink(_link) {
      return this;
    }
    /**
     * This should generally not be used,
     * but we need it for being compliant with the OTEL Span interface.
     *
     * @hidden
     * @internal
     */
    addLinks(_links) {
      return this;
    }
    /**
     * This should generally not be used,
     * but we need it for being compliant with the OTEL Span interface.
     *
     * @hidden
     * @internal
     */
    recordException(_exception, _time) {
    }
  }
  function handleCallbackErrors(fn, onError, onFinally = () => {
  }) {
    let maybePromiseResult;
    try {
      maybePromiseResult = fn();
    } catch (e2) {
      onError(e2);
      onFinally();
      throw e2;
    }
    return maybeHandlePromiseRejection(maybePromiseResult, onError, onFinally);
  }
  function maybeHandlePromiseRejection(value, onError, onFinally) {
    if (isThenable(value)) {
      return value.then(
        (res) => {
          onFinally();
          return res;
        },
        (e2) => {
          onError(e2);
          onFinally();
          throw e2;
        }
      );
    }
    onFinally();
    return value;
  }
  const DEFAULT_ENVIRONMENT$1 = "production";
  const FROZEN_DSC_FIELD = "_frozenDsc";
  function freezeDscOnSpan(span, dsc) {
    const spanWithMaybeDsc = span;
    addNonEnumerableProperty(spanWithMaybeDsc, FROZEN_DSC_FIELD, dsc);
  }
  function getDynamicSamplingContextFromClient(trace_id, client) {
    const options = client.getOptions();
    const { publicKey: public_key } = client.getDsn() || {};
    const dsc = dropUndefinedKeys({
      environment: options.environment || DEFAULT_ENVIRONMENT$1,
      release: options.release,
      public_key,
      trace_id
    });
    client.emit("createDsc", dsc);
    return dsc;
  }
  function getDynamicSamplingContextFromScope(client, scope2) {
    const propagationContext = scope2.getPropagationContext();
    return propagationContext.dsc || getDynamicSamplingContextFromClient(propagationContext.traceId, client);
  }
  function getDynamicSamplingContextFromSpan(span) {
    const client = getClient();
    if (!client) {
      return {};
    }
    const rootSpan = getRootSpan(span);
    const frozenDsc = rootSpan[FROZEN_DSC_FIELD];
    if (frozenDsc) {
      return frozenDsc;
    }
    const traceState = rootSpan.spanContext().traceState;
    const traceStateDsc = traceState && traceState.get("sentry.dsc");
    const dscOnTraceState = traceStateDsc && baggageHeaderToDynamicSamplingContext(traceStateDsc);
    if (dscOnTraceState) {
      return dscOnTraceState;
    }
    const dsc = getDynamicSamplingContextFromClient(span.spanContext().traceId, client);
    const jsonSpan = spanToJSON(rootSpan);
    const attributes = jsonSpan.data || {};
    const maybeSampleRate = attributes[SEMANTIC_ATTRIBUTE_SENTRY_SAMPLE_RATE];
    if (maybeSampleRate != null) {
      dsc.sample_rate = `${maybeSampleRate}`;
    }
    const source = attributes[SEMANTIC_ATTRIBUTE_SENTRY_SOURCE];
    const name2 = jsonSpan.description;
    if (source !== "url" && name2) {
      dsc.transaction = name2;
    }
    if (hasTracingEnabled()) {
      dsc.sampled = String(spanIsSampled(rootSpan));
    }
    client.emit("createDsc", dsc, rootSpan);
    return dsc;
  }
  function logSpanStart(span) {
    if (!DEBUG_BUILD$3) return;
    const { description: description2 = "< unknown name >", op = "< unknown op >", parent_span_id: parentSpanId } = spanToJSON(span);
    const { spanId } = span.spanContext();
    const sampled = spanIsSampled(span);
    const rootSpan = getRootSpan(span);
    const isRootSpan = rootSpan === span;
    const header = `[Tracing] Starting ${sampled ? "sampled" : "unsampled"} ${isRootSpan ? "root " : ""}span`;
    const infoParts = [`op: ${op}`, `name: ${description2}`, `ID: ${spanId}`];
    if (parentSpanId) {
      infoParts.push(`parent ID: ${parentSpanId}`);
    }
    if (!isRootSpan) {
      const { op: op2, description: description3 } = spanToJSON(rootSpan);
      infoParts.push(`root ID: ${rootSpan.spanContext().spanId}`);
      if (op2) {
        infoParts.push(`root op: ${op2}`);
      }
      if (description3) {
        infoParts.push(`root description: ${description3}`);
      }
    }
    logger$2.log(`${header}
  ${infoParts.join("\n  ")}`);
  }
  function logSpanEnd(span) {
    if (!DEBUG_BUILD$3) return;
    const { description: description2 = "< unknown name >", op = "< unknown op >" } = spanToJSON(span);
    const { spanId } = span.spanContext();
    const rootSpan = getRootSpan(span);
    const isRootSpan = rootSpan === span;
    const msg = `[Tracing] Finishing "${op}" ${isRootSpan ? "root " : ""}span "${description2}" with ID ${spanId}`;
    logger$2.log(msg);
  }
  function parseSampleRate(sampleRate) {
    if (typeof sampleRate === "boolean") {
      return Number(sampleRate);
    }
    const rate = typeof sampleRate === "string" ? parseFloat(sampleRate) : sampleRate;
    if (typeof rate !== "number" || isNaN(rate) || rate < 0 || rate > 1) {
      DEBUG_BUILD$3 && logger$2.warn(
        `[Tracing] Given sample rate is invalid. Sample rate must be a boolean or a number between 0 and 1. Got ${JSON.stringify(
          sampleRate
        )} of type ${JSON.stringify(typeof sampleRate)}.`
      );
      return void 0;
    }
    return rate;
  }
  function sampleSpan(options, samplingContext) {
    if (!hasTracingEnabled(options)) {
      return [false];
    }
    let sampleRate;
    if (typeof options.tracesSampler === "function") {
      sampleRate = options.tracesSampler(samplingContext);
    } else if (samplingContext.parentSampled !== void 0) {
      sampleRate = samplingContext.parentSampled;
    } else if (typeof options.tracesSampleRate !== "undefined") {
      sampleRate = options.tracesSampleRate;
    } else {
      sampleRate = 1;
    }
    const parsedSampleRate = parseSampleRate(sampleRate);
    if (parsedSampleRate === void 0) {
      DEBUG_BUILD$3 && logger$2.warn("[Tracing] Discarding transaction because of invalid sample rate.");
      return [false];
    }
    if (!parsedSampleRate) {
      DEBUG_BUILD$3 && logger$2.log(
        `[Tracing] Discarding transaction because ${typeof options.tracesSampler === "function" ? "tracesSampler returned 0 or false" : "a negative sampling decision was inherited or tracesSampleRate is set to 0"}`
      );
      return [false, parsedSampleRate];
    }
    const shouldSample = Math.random() < parsedSampleRate;
    if (!shouldSample) {
      DEBUG_BUILD$3 && logger$2.log(
        `[Tracing] Discarding transaction because it's not included in the random sample (sampling rate = ${Number(
          sampleRate
        )})`
      );
      return [false, parsedSampleRate];
    }
    return [true, parsedSampleRate];
  }
  const DSN_REGEX = /^(?:(\w+):)\/\/(?:(\w+)(?::(\w+)?)?@)([\w.-]+)(?::(\d+))?\/(.+)/;
  function isValidProtocol(protocol) {
    return protocol === "http" || protocol === "https";
  }
  function dsnToString(dsn, withPassword = false) {
    const { host, path: path2, pass, port, projectId, protocol, publicKey } = dsn;
    return `${protocol}://${publicKey}${withPassword && pass ? `:${pass}` : ""}@${host}${port ? `:${port}` : ""}/${path2 ? `${path2}/` : path2}${projectId}`;
  }
  function dsnFromString(str) {
    const match = DSN_REGEX.exec(str);
    if (!match) {
      consoleSandbox(() => {
        console.error(`Invalid Sentry Dsn: ${str}`);
      });
      return void 0;
    }
    const [protocol, publicKey, pass = "", host = "", port = "", lastPath = ""] = match.slice(1);
    let path2 = "";
    let projectId = lastPath;
    const split = projectId.split("/");
    if (split.length > 1) {
      path2 = split.slice(0, -1).join("/");
      projectId = split.pop();
    }
    if (projectId) {
      const projectMatch = projectId.match(/^\d+/);
      if (projectMatch) {
        projectId = projectMatch[0];
      }
    }
    return dsnFromComponents({ host, pass, path: path2, projectId, port, protocol, publicKey });
  }
  function dsnFromComponents(components) {
    return {
      protocol: components.protocol,
      publicKey: components.publicKey || "",
      pass: components.pass || "",
      host: components.host,
      port: components.port || "",
      path: components.path || "",
      projectId: components.projectId
    };
  }
  function validateDsn(dsn) {
    if (!DEBUG_BUILD$2) {
      return true;
    }
    const { port, projectId, protocol } = dsn;
    const requiredComponents = ["protocol", "publicKey", "host", "projectId"];
    const hasMissingRequiredComponent = requiredComponents.find((component) => {
      if (!dsn[component]) {
        logger$2.error(`Invalid Sentry Dsn: ${component} missing`);
        return true;
      }
      return false;
    });
    if (hasMissingRequiredComponent) {
      return false;
    }
    if (!projectId.match(/^\d+$/)) {
      logger$2.error(`Invalid Sentry Dsn: Invalid projectId ${projectId}`);
      return false;
    }
    if (!isValidProtocol(protocol)) {
      logger$2.error(`Invalid Sentry Dsn: Invalid protocol ${protocol}`);
      return false;
    }
    if (port && isNaN(parseInt(port, 10))) {
      logger$2.error(`Invalid Sentry Dsn: Invalid port ${port}`);
      return false;
    }
    return true;
  }
  function makeDsn(from) {
    const components = typeof from === "string" ? dsnFromString(from) : dsnFromComponents(from);
    if (!components || !validateDsn(components)) {
      return void 0;
    }
    return components;
  }
  function memoBuilder() {
    const hasWeakSet = typeof WeakSet === "function";
    const inner = hasWeakSet ? /* @__PURE__ */ new WeakSet() : [];
    function memoize(obj) {
      if (hasWeakSet) {
        if (inner.has(obj)) {
          return true;
        }
        inner.add(obj);
        return false;
      }
      for (let i2 = 0; i2 < inner.length; i2++) {
        const value = inner[i2];
        if (value === obj) {
          return true;
        }
      }
      inner.push(obj);
      return false;
    }
    function unmemoize(obj) {
      if (hasWeakSet) {
        inner.delete(obj);
      } else {
        for (let i2 = 0; i2 < inner.length; i2++) {
          if (inner[i2] === obj) {
            inner.splice(i2, 1);
            break;
          }
        }
      }
    }
    return [memoize, unmemoize];
  }
  function normalize$1(input, depth = 100, maxProperties = Infinity) {
    try {
      return visit("", input, depth, maxProperties);
    } catch (err) {
      return { ERROR: `**non-serializable** (${err})` };
    }
  }
  function normalizeToSize(object2, depth = 3, maxSize = 100 * 1024) {
    const normalized = normalize$1(object2, depth);
    if (jsonSize(normalized) > maxSize) {
      return normalizeToSize(object2, depth - 1, maxSize);
    }
    return normalized;
  }
  function visit(key, value, depth = Infinity, maxProperties = Infinity, memo = memoBuilder()) {
    const [memoize, unmemoize] = memo;
    if (value == null || // this matches null and undefined -> eqeq not eqeqeq
    ["boolean", "string"].includes(typeof value) || typeof value === "number" && Number.isFinite(value)) {
      return value;
    }
    const stringified = stringifyValue(key, value);
    if (!stringified.startsWith("[object ")) {
      return stringified;
    }
    if (value["__sentry_skip_normalization__"]) {
      return value;
    }
    const remainingDepth = typeof value["__sentry_override_normalization_depth__"] === "number" ? value["__sentry_override_normalization_depth__"] : depth;
    if (remainingDepth === 0) {
      return stringified.replace("object ", "");
    }
    if (memoize(value)) {
      return "[Circular ~]";
    }
    const valueWithToJSON = value;
    if (valueWithToJSON && typeof valueWithToJSON.toJSON === "function") {
      try {
        const jsonValue = valueWithToJSON.toJSON();
        return visit("", jsonValue, remainingDepth - 1, maxProperties, memo);
      } catch (err) {
      }
    }
    const normalized = Array.isArray(value) ? [] : {};
    let numAdded = 0;
    const visitable = convertToPlainObject(value);
    for (const visitKey in visitable) {
      if (!Object.prototype.hasOwnProperty.call(visitable, visitKey)) {
        continue;
      }
      if (numAdded >= maxProperties) {
        normalized[visitKey] = "[MaxProperties ~]";
        break;
      }
      const visitValue = visitable[visitKey];
      normalized[visitKey] = visit(visitKey, visitValue, remainingDepth - 1, maxProperties, memo);
      numAdded++;
    }
    unmemoize(value);
    return normalized;
  }
  function stringifyValue(key, value) {
    try {
      if (key === "domain" && value && typeof value === "object" && value._events) {
        return "[Domain]";
      }
      if (key === "domainEmitter") {
        return "[DomainEmitter]";
      }
      if (typeof global !== "undefined" && value === global) {
        return "[Global]";
      }
      if (typeof window !== "undefined" && value === window) {
        return "[Window]";
      }
      if (typeof document !== "undefined" && value === document) {
        return "[Document]";
      }
      if (isVueViewModel(value)) {
        return "[VueViewModel]";
      }
      if (isSyntheticEvent(value)) {
        return "[SyntheticEvent]";
      }
      if (typeof value === "number" && !Number.isFinite(value)) {
        return `[${value}]`;
      }
      if (typeof value === "function") {
        return `[Function: ${getFunctionName(value)}]`;
      }
      if (typeof value === "symbol") {
        return `[${String(value)}]`;
      }
      if (typeof value === "bigint") {
        return `[BigInt: ${String(value)}]`;
      }
      const objName = getConstructorName(value);
      if (/^HTML(\w*)Element$/.test(objName)) {
        return `[HTMLElement: ${objName}]`;
      }
      return `[object ${objName}]`;
    } catch (err) {
      return `**non-serializable** (${err})`;
    }
  }
  function getConstructorName(value) {
    const prototype = Object.getPrototypeOf(value);
    return prototype ? prototype.constructor.name : "null prototype";
  }
  function utf8Length(value) {
    return ~-encodeURI(value).split(/%..|./).length;
  }
  function jsonSize(value) {
    return utf8Length(JSON.stringify(value));
  }
  function normalizeUrlToBase(url2, basePath) {
    const escapedBase = basePath.replace(/\\/g, "/").replace(/[|\\{}()[\]^$+*?.]/g, "\\$&");
    let newUrl = url2;
    try {
      newUrl = decodeURI(url2);
    } catch (_Oo) {
    }
    return newUrl.replace(/\\/g, "/").replace(/webpack:\/?/g, "").replace(new RegExp(`(file://)?/*${escapedBase}/*`, "ig"), "app:///");
  }
  function createEnvelope(headers, items = []) {
    return [headers, items];
  }
  function addItemToEnvelope(envelope, newItem) {
    const [headers, items] = envelope;
    return [headers, [...items, newItem]];
  }
  function forEachEnvelopeItem(envelope, callback) {
    const envelopeItems = envelope[1];
    for (const envelopeItem of envelopeItems) {
      const envelopeItemType = envelopeItem[0].type;
      const result = callback(envelopeItem, envelopeItemType);
      if (result) {
        return true;
      }
    }
    return false;
  }
  function envelopeContainsItemType(envelope, types2) {
    return forEachEnvelopeItem(envelope, (_2, type2) => types2.includes(type2));
  }
  function encodeUTF8(input) {
    return GLOBAL_OBJ.__SENTRY__ && GLOBAL_OBJ.__SENTRY__.encodePolyfill ? GLOBAL_OBJ.__SENTRY__.encodePolyfill(input) : new TextEncoder().encode(input);
  }
  function decodeUTF8(input) {
    return GLOBAL_OBJ.__SENTRY__ && GLOBAL_OBJ.__SENTRY__.decodePolyfill ? GLOBAL_OBJ.__SENTRY__.decodePolyfill(input) : new TextDecoder().decode(input);
  }
  function serializeEnvelope(envelope) {
    const [envHeaders, items] = envelope;
    let parts = JSON.stringify(envHeaders);
    function append(next) {
      if (typeof parts === "string") {
        parts = typeof next === "string" ? parts + next : [encodeUTF8(parts), next];
      } else {
        parts.push(typeof next === "string" ? encodeUTF8(next) : next);
      }
    }
    for (const item of items) {
      const [itemHeaders, payload] = item;
      append(`
${JSON.stringify(itemHeaders)}
`);
      if (typeof payload === "string" || payload instanceof Uint8Array) {
        append(payload);
      } else {
        let stringifiedPayload;
        try {
          stringifiedPayload = JSON.stringify(payload);
        } catch (e2) {
          stringifiedPayload = JSON.stringify(normalize$1(payload));
        }
        append(stringifiedPayload);
      }
    }
    return typeof parts === "string" ? parts : concatBuffers(parts);
  }
  function concatBuffers(buffers) {
    const totalLength = buffers.reduce((acc, buf) => acc + buf.length, 0);
    const merged = new Uint8Array(totalLength);
    let offset = 0;
    for (const buffer2 of buffers) {
      merged.set(buffer2, offset);
      offset += buffer2.length;
    }
    return merged;
  }
  function parseEnvelope(env2) {
    let buffer2 = typeof env2 === "string" ? encodeUTF8(env2) : env2;
    function readBinary(length) {
      const bin = buffer2.subarray(0, length);
      buffer2 = buffer2.subarray(length + 1);
      return bin;
    }
    function readJson() {
      let i2 = buffer2.indexOf(10);
      if (i2 < 0) {
        i2 = buffer2.length;
      }
      return JSON.parse(decodeUTF8(readBinary(i2)));
    }
    const envelopeHeader = readJson();
    const items = [];
    while (buffer2.length) {
      const itemHeader = readJson();
      const binaryLength = typeof itemHeader.length === "number" ? itemHeader.length : void 0;
      items.push([itemHeader, binaryLength ? readBinary(binaryLength) : readJson()]);
    }
    return [envelopeHeader, items];
  }
  function createSpanEnvelopeItem(spanJson) {
    const spanHeaders = {
      type: "span"
    };
    return [spanHeaders, spanJson];
  }
  function createAttachmentEnvelopeItem(attachment) {
    const buffer2 = typeof attachment.data === "string" ? encodeUTF8(attachment.data) : attachment.data;
    return [
      dropUndefinedKeys({
        type: "attachment",
        length: buffer2.length,
        filename: attachment.filename,
        content_type: attachment.contentType,
        attachment_type: attachment.attachmentType
      }),
      buffer2
    ];
  }
  const ITEM_TYPE_TO_DATA_CATEGORY_MAP = {
    session: "session",
    sessions: "session",
    attachment: "attachment",
    transaction: "transaction",
    event: "error",
    client_report: "internal",
    user_report: "default",
    profile: "profile",
    profile_chunk: "profile",
    replay_event: "replay",
    replay_recording: "replay",
    check_in: "monitor",
    feedback: "feedback",
    span: "span",
    statsd: "metric_bucket"
  };
  function envelopeItemTypeToDataCategory(type2) {
    return ITEM_TYPE_TO_DATA_CATEGORY_MAP[type2];
  }
  function getSdkMetadataForEnvelopeHeader(metadataOrEvent) {
    if (!metadataOrEvent || !metadataOrEvent.sdk) {
      return;
    }
    const { name: name2, version: version2 } = metadataOrEvent.sdk;
    return { name: name2, version: version2 };
  }
  function createEventEnvelopeHeaders(event, sdkInfo, tunnel, dsn) {
    const dynamicSamplingContext = event.sdkProcessingMetadata && event.sdkProcessingMetadata.dynamicSamplingContext;
    return {
      event_id: event.event_id,
      sent_at: (/* @__PURE__ */ new Date()).toISOString(),
      ...sdkInfo && { sdk: sdkInfo },
      ...!!tunnel && dsn && { dsn: dsnToString(dsn) },
      ...dynamicSamplingContext && {
        trace: dropUndefinedKeys({ ...dynamicSamplingContext })
      }
    };
  }
  function enhanceEventWithSdkInfo(event, sdkInfo) {
    if (!sdkInfo) {
      return event;
    }
    event.sdk = event.sdk || {};
    event.sdk.name = event.sdk.name || sdkInfo.name;
    event.sdk.version = event.sdk.version || sdkInfo.version;
    event.sdk.integrations = [...event.sdk.integrations || [], ...sdkInfo.integrations || []];
    event.sdk.packages = [...event.sdk.packages || [], ...sdkInfo.packages || []];
    return event;
  }
  function createSessionEnvelope(session, dsn, metadata, tunnel) {
    const sdkInfo = getSdkMetadataForEnvelopeHeader(metadata);
    const envelopeHeaders = {
      sent_at: (/* @__PURE__ */ new Date()).toISOString(),
      ...sdkInfo && { sdk: sdkInfo },
      ...!!tunnel && dsn && { dsn: dsnToString(dsn) }
    };
    const envelopeItem = "aggregates" in session ? [{ type: "sessions" }, session] : [{ type: "session" }, session.toJSON()];
    return createEnvelope(envelopeHeaders, [envelopeItem]);
  }
  function createEventEnvelope(event, dsn, metadata, tunnel) {
    const sdkInfo = getSdkMetadataForEnvelopeHeader(metadata);
    const eventType = event.type && event.type !== "replay_event" ? event.type : "event";
    enhanceEventWithSdkInfo(event, metadata && metadata.sdk);
    const envelopeHeaders = createEventEnvelopeHeaders(event, sdkInfo, tunnel, dsn);
    delete event.sdkProcessingMetadata;
    const eventItem = [{ type: eventType }, event];
    return createEnvelope(envelopeHeaders, [eventItem]);
  }
  function createSpanEnvelope(spans, client) {
    function dscHasRequiredProps(dsc2) {
      return !!dsc2.trace_id && !!dsc2.public_key;
    }
    const dsc = getDynamicSamplingContextFromSpan(spans[0]);
    const dsn = client && client.getDsn();
    const tunnel = client && client.getOptions().tunnel;
    const headers = {
      sent_at: (/* @__PURE__ */ new Date()).toISOString(),
      ...dscHasRequiredProps(dsc) && { trace: dsc },
      ...!!tunnel && dsn && { dsn: dsnToString(dsn) }
    };
    const beforeSendSpan = client && client.getOptions().beforeSendSpan;
    const convertToSpanJSON = beforeSendSpan ? (span) => {
      const spanJson = beforeSendSpan(spanToJSON(span));
      if (!spanJson) {
        showSpanDropWarning();
      }
      return spanJson;
    } : (span) => spanToJSON(span);
    const items = [];
    for (const span of spans) {
      const spanJson = convertToSpanJSON(span);
      if (spanJson) {
        items.push(createSpanEnvelopeItem(spanJson));
      }
    }
    return createEnvelope(headers, items);
  }
  function timedEventsToMeasurements(events2) {
    if (!events2 || events2.length === 0) {
      return void 0;
    }
    const measurements = {};
    events2.forEach((event) => {
      const attributes = event.attributes || {};
      const unit = attributes[SEMANTIC_ATTRIBUTE_SENTRY_MEASUREMENT_UNIT];
      const value = attributes[SEMANTIC_ATTRIBUTE_SENTRY_MEASUREMENT_VALUE];
      if (typeof unit === "string" && typeof value === "number") {
        measurements[event.name] = { value, unit };
      }
    });
    return measurements;
  }
  const MAX_SPAN_COUNT$1 = 1e3;
  class SentrySpan {
    /** Epoch timestamp in seconds when the span started. */
    /** Epoch timestamp in seconds when the span ended. */
    /** Internal keeper of the status */
    /** The timed events added to this span. */
    /** if true, treat span as a standalone span (not part of a transaction) */
    /**
     * You should never call the constructor manually, always use `Sentry.startSpan()`
     * or other span methods.
     * @internal
     * @hideconstructor
     * @hidden
     */
    constructor(spanContext = {}) {
      this._traceId = spanContext.traceId || uuid4();
      this._spanId = spanContext.spanId || uuid4().substring(16);
      this._startTime = spanContext.startTimestamp || timestampInSeconds();
      this._attributes = {};
      this.setAttributes({
        [SEMANTIC_ATTRIBUTE_SENTRY_ORIGIN]: "manual",
        [SEMANTIC_ATTRIBUTE_SENTRY_OP]: spanContext.op,
        ...spanContext.attributes
      });
      this._name = spanContext.name;
      if (spanContext.parentSpanId) {
        this._parentSpanId = spanContext.parentSpanId;
      }
      if ("sampled" in spanContext) {
        this._sampled = spanContext.sampled;
      }
      if (spanContext.endTimestamp) {
        this._endTime = spanContext.endTimestamp;
      }
      this._events = [];
      this._isStandaloneSpan = spanContext.isStandalone;
      if (this._endTime) {
        this._onSpanEnded();
      }
    }
    /**
     * This should generally not be used,
     * but it is needed for being compliant with the OTEL Span interface.
     *
     * @hidden
     * @internal
     */
    addLink(_link) {
      return this;
    }
    /**
     * This should generally not be used,
     * but it is needed for being compliant with the OTEL Span interface.
     *
     * @hidden
     * @internal
     */
    addLinks(_links) {
      return this;
    }
    /**
     * This should generally not be used,
     * but it is needed for being compliant with the OTEL Span interface.
     *
     * @hidden
     * @internal
     */
    recordException(_exception, _time) {
    }
    /** @inheritdoc */
    spanContext() {
      const { _spanId: spanId, _traceId: traceId, _sampled: sampled } = this;
      return {
        spanId,
        traceId,
        traceFlags: sampled ? TRACE_FLAG_SAMPLED : TRACE_FLAG_NONE
      };
    }
    /** @inheritdoc */
    setAttribute(key, value) {
      if (value === void 0) {
        delete this._attributes[key];
      } else {
        this._attributes[key] = value;
      }
      return this;
    }
    /** @inheritdoc */
    setAttributes(attributes) {
      Object.keys(attributes).forEach((key) => this.setAttribute(key, attributes[key]));
      return this;
    }
    /**
     * This should generally not be used,
     * but we need it for browser tracing where we want to adjust the start time afterwards.
     * USE THIS WITH CAUTION!
     *
     * @hidden
     * @internal
     */
    updateStartTime(timeInput) {
      this._startTime = spanTimeInputToSeconds(timeInput);
    }
    /**
     * @inheritDoc
     */
    setStatus(value) {
      this._status = value;
      return this;
    }
    /**
     * @inheritDoc
     */
    updateName(name2) {
      this._name = name2;
      this.setAttribute(SEMANTIC_ATTRIBUTE_SENTRY_SOURCE, "custom");
      return this;
    }
    /** @inheritdoc */
    end(endTimestamp) {
      if (this._endTime) {
        return;
      }
      this._endTime = spanTimeInputToSeconds(endTimestamp);
      logSpanEnd(this);
      this._onSpanEnded();
    }
    /**
     * Get JSON representation of this span.
     *
     * @hidden
     * @internal This method is purely for internal purposes and should not be used outside
     * of SDK code. If you need to get a JSON representation of a span,
     * use `spanToJSON(span)` instead.
     */
    getSpanJSON() {
      return dropUndefinedKeys({
        data: this._attributes,
        description: this._name,
        op: this._attributes[SEMANTIC_ATTRIBUTE_SENTRY_OP],
        parent_span_id: this._parentSpanId,
        span_id: this._spanId,
        start_timestamp: this._startTime,
        status: getStatusMessage(this._status),
        timestamp: this._endTime,
        trace_id: this._traceId,
        origin: this._attributes[SEMANTIC_ATTRIBUTE_SENTRY_ORIGIN],
        _metrics_summary: getMetricSummaryJsonForSpan(this),
        profile_id: this._attributes[SEMANTIC_ATTRIBUTE_PROFILE_ID],
        exclusive_time: this._attributes[SEMANTIC_ATTRIBUTE_EXCLUSIVE_TIME],
        measurements: timedEventsToMeasurements(this._events),
        is_segment: this._isStandaloneSpan && getRootSpan(this) === this || void 0,
        segment_id: this._isStandaloneSpan ? getRootSpan(this).spanContext().spanId : void 0
      });
    }
    /** @inheritdoc */
    isRecording() {
      return !this._endTime && !!this._sampled;
    }
    /**
     * @inheritdoc
     */
    addEvent(name2, attributesOrStartTime, startTime) {
      DEBUG_BUILD$3 && logger$2.log("[Tracing] Adding an event to span:", name2);
      const time = isSpanTimeInput(attributesOrStartTime) ? attributesOrStartTime : startTime || timestampInSeconds();
      const attributes = isSpanTimeInput(attributesOrStartTime) ? {} : attributesOrStartTime || {};
      const event = {
        name: name2,
        time: spanTimeInputToSeconds(time),
        attributes
      };
      this._events.push(event);
      return this;
    }
    /**
     * This method should generally not be used,
     * but for now we need a way to publicly check if the `_isStandaloneSpan` flag is set.
     * USE THIS WITH CAUTION!
     * @internal
     * @hidden
     * @experimental
     */
    isStandaloneSpan() {
      return !!this._isStandaloneSpan;
    }
    /** Emit `spanEnd` when the span is ended. */
    _onSpanEnded() {
      const client = getClient();
      if (client) {
        client.emit("spanEnd", this);
      }
      const isSegmentSpan = this._isStandaloneSpan || this === getRootSpan(this);
      if (!isSegmentSpan) {
        return;
      }
      if (this._isStandaloneSpan) {
        if (this._sampled) {
          sendSpanEnvelope(createSpanEnvelope([this], client));
        } else {
          DEBUG_BUILD$3 && logger$2.log("[Tracing] Discarding standalone span because its trace was not chosen to be sampled.");
          if (client) {
            client.recordDroppedEvent("sample_rate", "span");
          }
        }
        return;
      }
      const transactionEvent = this._convertSpanToTransaction();
      if (transactionEvent) {
        const scope2 = getCapturedScopesOnSpan(this).scope || getCurrentScope();
        scope2.captureEvent(transactionEvent);
      }
    }
    /**
     * Finish the transaction & prepare the event to send to Sentry.
     */
    _convertSpanToTransaction() {
      if (!isFullFinishedSpan(spanToJSON(this))) {
        return void 0;
      }
      if (!this._name) {
        DEBUG_BUILD$3 && logger$2.warn("Transaction has no name, falling back to `<unlabeled transaction>`.");
        this._name = "<unlabeled transaction>";
      }
      const { scope: capturedSpanScope, isolationScope: capturedSpanIsolationScope } = getCapturedScopesOnSpan(this);
      const scope2 = capturedSpanScope || getCurrentScope();
      const client = scope2.getClient() || getClient();
      if (this._sampled !== true) {
        DEBUG_BUILD$3 && logger$2.log("[Tracing] Discarding transaction because its trace was not chosen to be sampled.");
        if (client) {
          client.recordDroppedEvent("sample_rate", "transaction");
        }
        return void 0;
      }
      const finishedSpans = getSpanDescendants(this).filter((span) => span !== this && !isStandaloneSpan(span));
      const spans = finishedSpans.map((span) => spanToJSON(span)).filter(isFullFinishedSpan);
      const source = this._attributes[SEMANTIC_ATTRIBUTE_SENTRY_SOURCE];
      const transaction = {
        contexts: {
          trace: spanToTransactionTraceContext(this)
        },
        spans: (
          // spans.sort() mutates the array, but `spans` is already a copy so we can safely do this here
          // we do not use spans anymore after this point
          spans.length > MAX_SPAN_COUNT$1 ? spans.sort((a2, b2) => a2.start_timestamp - b2.start_timestamp).slice(0, MAX_SPAN_COUNT$1) : spans
        ),
        start_timestamp: this._startTime,
        timestamp: this._endTime,
        transaction: this._name,
        type: "transaction",
        sdkProcessingMetadata: {
          capturedSpanScope,
          capturedSpanIsolationScope,
          ...dropUndefinedKeys({
            dynamicSamplingContext: getDynamicSamplingContextFromSpan(this)
          })
        },
        _metrics_summary: getMetricSummaryJsonForSpan(this),
        ...source && {
          transaction_info: {
            source
          }
        }
      };
      const measurements = timedEventsToMeasurements(this._events);
      const hasMeasurements = measurements && Object.keys(measurements).length;
      if (hasMeasurements) {
        DEBUG_BUILD$3 && logger$2.log(
          "[Measurements] Adding measurements to transaction event",
          JSON.stringify(measurements, void 0, 2)
        );
        transaction.measurements = measurements;
      }
      return transaction;
    }
  }
  function isSpanTimeInput(value) {
    return value && typeof value === "number" || value instanceof Date || Array.isArray(value);
  }
  function isFullFinishedSpan(input) {
    return !!input.start_timestamp && !!input.timestamp && !!input.span_id && !!input.trace_id;
  }
  function isStandaloneSpan(span) {
    return span instanceof SentrySpan && span.isStandaloneSpan();
  }
  function sendSpanEnvelope(envelope) {
    const client = getClient();
    if (!client) {
      return;
    }
    const spanItems = envelope[1];
    if (!spanItems || spanItems.length === 0) {
      client.recordDroppedEvent("before_send", "span");
      return;
    }
    client.sendEnvelope(envelope);
  }
  const SUPPRESS_TRACING_KEY$1 = "__SENTRY_SUPPRESS_TRACING__";
  function startSpanManual$1(options, callback) {
    const acs = getAcs();
    if (acs.startSpanManual) {
      return acs.startSpanManual(options, callback);
    }
    const spanArguments = parseSentrySpanArguments(options);
    const { forceTransaction, parentSpan: customParentSpan } = options;
    return withScope(options.scope, () => {
      const wrapper = getActiveSpanWrapper$1(customParentSpan);
      return wrapper(() => {
        const scope2 = getCurrentScope();
        const parentSpan = getParentSpan(scope2);
        const shouldSkipSpan = options.onlyIfParent && !parentSpan;
        const activeSpan = shouldSkipSpan ? new SentryNonRecordingSpan() : createChildOrRootSpan({
          parentSpan,
          spanArguments,
          forceTransaction,
          scope: scope2
        });
        _setSpanForScope(scope2, activeSpan);
        function finishAndSetSpan() {
          activeSpan.end();
        }
        return handleCallbackErrors(
          () => callback(activeSpan, finishAndSetSpan),
          () => {
            const { status } = spanToJSON(activeSpan);
            if (activeSpan.isRecording() && (!status || status === "ok")) {
              activeSpan.setStatus({ code: SPAN_STATUS_ERROR, message: "internal_error" });
            }
          }
        );
      });
    });
  }
  function startInactiveSpan$1(options) {
    const acs = getAcs();
    if (acs.startInactiveSpan) {
      return acs.startInactiveSpan(options);
    }
    const spanArguments = parseSentrySpanArguments(options);
    const { forceTransaction, parentSpan: customParentSpan } = options;
    const wrapper = options.scope ? (callback) => withScope(options.scope, callback) : customParentSpan !== void 0 ? (callback) => withActiveSpan$1(customParentSpan, callback) : (callback) => callback();
    return wrapper(() => {
      const scope2 = getCurrentScope();
      const parentSpan = getParentSpan(scope2);
      const shouldSkipSpan = options.onlyIfParent && !parentSpan;
      if (shouldSkipSpan) {
        return new SentryNonRecordingSpan();
      }
      return createChildOrRootSpan({
        parentSpan,
        spanArguments,
        forceTransaction,
        scope: scope2
      });
    });
  }
  function withActiveSpan$1(span, callback) {
    const acs = getAcs();
    if (acs.withActiveSpan) {
      return acs.withActiveSpan(span, callback);
    }
    return withScope((scope2) => {
      _setSpanForScope(scope2, span || void 0);
      return callback(scope2);
    });
  }
  function createChildOrRootSpan({
    parentSpan,
    spanArguments,
    forceTransaction,
    scope: scope2
  }) {
    if (!hasTracingEnabled()) {
      return new SentryNonRecordingSpan();
    }
    const isolationScope = getIsolationScope();
    let span;
    if (parentSpan && !forceTransaction) {
      span = _startChildSpan(parentSpan, scope2, spanArguments);
      addChildSpanToSpan(parentSpan, span);
    } else if (parentSpan) {
      const dsc = getDynamicSamplingContextFromSpan(parentSpan);
      const { traceId, spanId: parentSpanId } = parentSpan.spanContext();
      const parentSampled = spanIsSampled(parentSpan);
      span = _startRootSpan(
        {
          traceId,
          parentSpanId,
          ...spanArguments
        },
        scope2,
        parentSampled
      );
      freezeDscOnSpan(span, dsc);
    } else {
      const {
        traceId,
        dsc,
        parentSpanId,
        sampled: parentSampled
      } = {
        ...isolationScope.getPropagationContext(),
        ...scope2.getPropagationContext()
      };
      span = _startRootSpan(
        {
          traceId,
          parentSpanId,
          ...spanArguments
        },
        scope2,
        parentSampled
      );
      if (dsc) {
        freezeDscOnSpan(span, dsc);
      }
    }
    logSpanStart(span);
    setCapturedScopesOnSpan(span, scope2, isolationScope);
    return span;
  }
  function parseSentrySpanArguments(options) {
    const exp = options.experimental || {};
    const initialCtx = {
      isStandalone: exp.standalone,
      ...options
    };
    if (options.startTime) {
      const ctx = { ...initialCtx };
      ctx.startTimestamp = spanTimeInputToSeconds(options.startTime);
      delete ctx.startTime;
      return ctx;
    }
    return initialCtx;
  }
  function getAcs() {
    const carrier = getMainCarrier();
    return getAsyncContextStrategy(carrier);
  }
  function _startRootSpan(spanArguments, scope2, parentSampled) {
    const client = getClient();
    const options = client && client.getOptions() || {};
    const { name: name2 = "", attributes } = spanArguments;
    const [sampled, sampleRate] = scope2.getScopeData().sdkProcessingMetadata[SUPPRESS_TRACING_KEY$1] ? [false] : sampleSpan(options, {
      name: name2,
      parentSampled,
      attributes,
      transactionContext: {
        name: name2,
        parentSampled
      }
    });
    const rootSpan = new SentrySpan({
      ...spanArguments,
      attributes: {
        [SEMANTIC_ATTRIBUTE_SENTRY_SOURCE]: "custom",
        ...spanArguments.attributes
      },
      sampled
    });
    if (sampleRate !== void 0) {
      rootSpan.setAttribute(SEMANTIC_ATTRIBUTE_SENTRY_SAMPLE_RATE, sampleRate);
    }
    if (client) {
      client.emit("spanStart", rootSpan);
    }
    return rootSpan;
  }
  function _startChildSpan(parentSpan, scope2, spanArguments) {
    const { spanId, traceId } = parentSpan.spanContext();
    const sampled = scope2.getScopeData().sdkProcessingMetadata[SUPPRESS_TRACING_KEY$1] ? false : spanIsSampled(parentSpan);
    const childSpan = sampled ? new SentrySpan({
      ...spanArguments,
      parentSpanId: spanId,
      traceId,
      sampled
    }) : new SentryNonRecordingSpan({ traceId });
    addChildSpanToSpan(parentSpan, childSpan);
    const client = getClient();
    if (client) {
      client.emit("spanStart", childSpan);
      if (spanArguments.endTimestamp) {
        client.emit("spanEnd", childSpan);
      }
    }
    return childSpan;
  }
  function getParentSpan(scope2) {
    const span = _getSpanForScope(scope2);
    if (!span) {
      return void 0;
    }
    const client = getClient();
    const options = client ? client.getOptions() : {};
    if (options.parentSpanIsAlwaysRootSpan) {
      return getRootSpan(span);
    }
    return span;
  }
  function getActiveSpanWrapper$1(parentSpan) {
    return parentSpan !== void 0 ? (callback) => {
      return withActiveSpan$1(parentSpan, callback);
    } : (callback) => callback();
  }
  function notifyEventProcessors(processors, event, hint, index2 = 0) {
    return new SyncPromise((resolve2, reject) => {
      const processor = processors[index2];
      if (event === null || typeof processor !== "function") {
        resolve2(event);
      } else {
        const result = processor({ ...event }, hint);
        DEBUG_BUILD$3 && processor.id && result === null && logger$2.log(`Event processor "${processor.id}" dropped event`);
        if (isThenable(result)) {
          void result.then((final) => notifyEventProcessors(processors, final, hint, index2 + 1).then(resolve2)).then(null, reject);
        } else {
          void notifyEventProcessors(processors, result, hint, index2 + 1).then(resolve2).then(null, reject);
        }
      }
    });
  }
  let parsedStackResults;
  let lastKeysCount;
  let cachedFilenameDebugIds;
  function getFilenameToDebugIdMap(stackParser) {
    const debugIdMap = GLOBAL_OBJ._sentryDebugIds;
    if (!debugIdMap) {
      return {};
    }
    const debugIdKeys = Object.keys(debugIdMap);
    if (cachedFilenameDebugIds && debugIdKeys.length === lastKeysCount) {
      return cachedFilenameDebugIds;
    }
    lastKeysCount = debugIdKeys.length;
    cachedFilenameDebugIds = debugIdKeys.reduce((acc, stackKey) => {
      if (!parsedStackResults) {
        parsedStackResults = {};
      }
      const result = parsedStackResults[stackKey];
      if (result) {
        acc[result[0]] = result[1];
      } else {
        const parsedStack = stackParser(stackKey);
        for (let i2 = parsedStack.length - 1; i2 >= 0; i2--) {
          const stackFrame = parsedStack[i2];
          const filename = stackFrame && stackFrame.filename;
          const debugId = debugIdMap[stackKey];
          if (filename && debugId) {
            acc[filename] = debugId;
            parsedStackResults[stackKey] = [filename, debugId];
            break;
          }
        }
      }
      return acc;
    }, {});
    return cachedFilenameDebugIds;
  }
  function applyScopeDataToEvent(event, data2) {
    const { fingerprint, span, breadcrumbs, sdkProcessingMetadata } = data2;
    applyDataToEvent(event, data2);
    if (span) {
      applySpanToEvent(event, span);
    }
    applyFingerprintToEvent(event, fingerprint);
    applyBreadcrumbsToEvent(event, breadcrumbs);
    applySdkMetadataToEvent(event, sdkProcessingMetadata);
  }
  function mergeScopeData(data2, mergeData) {
    const {
      extra,
      tags,
      user,
      contexts,
      level,
      sdkProcessingMetadata,
      breadcrumbs,
      fingerprint,
      eventProcessors,
      attachments,
      propagationContext,
      transactionName,
      span
    } = mergeData;
    mergeAndOverwriteScopeData(data2, "extra", extra);
    mergeAndOverwriteScopeData(data2, "tags", tags);
    mergeAndOverwriteScopeData(data2, "user", user);
    mergeAndOverwriteScopeData(data2, "contexts", contexts);
    data2.sdkProcessingMetadata = merge$1(data2.sdkProcessingMetadata, sdkProcessingMetadata, 2);
    if (level) {
      data2.level = level;
    }
    if (transactionName) {
      data2.transactionName = transactionName;
    }
    if (span) {
      data2.span = span;
    }
    if (breadcrumbs.length) {
      data2.breadcrumbs = [...data2.breadcrumbs, ...breadcrumbs];
    }
    if (fingerprint.length) {
      data2.fingerprint = [...data2.fingerprint, ...fingerprint];
    }
    if (eventProcessors.length) {
      data2.eventProcessors = [...data2.eventProcessors, ...eventProcessors];
    }
    if (attachments.length) {
      data2.attachments = [...data2.attachments, ...attachments];
    }
    data2.propagationContext = { ...data2.propagationContext, ...propagationContext };
  }
  function mergeAndOverwriteScopeData(data2, prop, mergeVal) {
    data2[prop] = merge$1(data2[prop], mergeVal, 1);
  }
  function applyDataToEvent(event, data2) {
    const { extra, tags, user, contexts, level, transactionName } = data2;
    const cleanedExtra = dropUndefinedKeys(extra);
    if (cleanedExtra && Object.keys(cleanedExtra).length) {
      event.extra = { ...cleanedExtra, ...event.extra };
    }
    const cleanedTags = dropUndefinedKeys(tags);
    if (cleanedTags && Object.keys(cleanedTags).length) {
      event.tags = { ...cleanedTags, ...event.tags };
    }
    const cleanedUser = dropUndefinedKeys(user);
    if (cleanedUser && Object.keys(cleanedUser).length) {
      event.user = { ...cleanedUser, ...event.user };
    }
    const cleanedContexts = dropUndefinedKeys(contexts);
    if (cleanedContexts && Object.keys(cleanedContexts).length) {
      event.contexts = { ...cleanedContexts, ...event.contexts };
    }
    if (level) {
      event.level = level;
    }
    if (transactionName && event.type !== "transaction") {
      event.transaction = transactionName;
    }
  }
  function applyBreadcrumbsToEvent(event, breadcrumbs) {
    const mergedBreadcrumbs = [...event.breadcrumbs || [], ...breadcrumbs];
    event.breadcrumbs = mergedBreadcrumbs.length ? mergedBreadcrumbs : void 0;
  }
  function applySdkMetadataToEvent(event, sdkProcessingMetadata) {
    event.sdkProcessingMetadata = {
      ...event.sdkProcessingMetadata,
      ...sdkProcessingMetadata
    };
  }
  function applySpanToEvent(event, span) {
    event.contexts = {
      trace: spanToTraceContext(span),
      ...event.contexts
    };
    event.sdkProcessingMetadata = {
      dynamicSamplingContext: getDynamicSamplingContextFromSpan(span),
      ...event.sdkProcessingMetadata
    };
    const rootSpan = getRootSpan(span);
    const transactionName = spanToJSON(rootSpan).description;
    if (transactionName && !event.transaction && event.type === "transaction") {
      event.transaction = transactionName;
    }
  }
  function applyFingerprintToEvent(event, fingerprint) {
    event.fingerprint = event.fingerprint ? Array.isArray(event.fingerprint) ? event.fingerprint : [event.fingerprint] : [];
    if (fingerprint) {
      event.fingerprint = event.fingerprint.concat(fingerprint);
    }
    if (event.fingerprint && !event.fingerprint.length) {
      delete event.fingerprint;
    }
  }
  function prepareEvent(options, event, hint, scope2, client, isolationScope) {
    const { normalizeDepth = 3, normalizeMaxBreadth = 1e3 } = options;
    const prepared = {
      ...event,
      event_id: event.event_id || hint.event_id || uuid4(),
      timestamp: event.timestamp || dateTimestampInSeconds()
    };
    const integrations = hint.integrations || options.integrations.map((i2) => i2.name);
    applyClientOptions(prepared, options);
    applyIntegrationsMetadata(prepared, integrations);
    if (client) {
      client.emit("applyFrameMetadata", event);
    }
    if (event.type === void 0) {
      applyDebugIds(prepared, options.stackParser);
    }
    const finalScope = getFinalScope(scope2, hint.captureContext);
    if (hint.mechanism) {
      addExceptionMechanism(prepared, hint.mechanism);
    }
    const clientEventProcessors = client ? client.getEventProcessors() : [];
    const data2 = getGlobalScope().getScopeData();
    if (isolationScope) {
      const isolationData = isolationScope.getScopeData();
      mergeScopeData(data2, isolationData);
    }
    if (finalScope) {
      const finalScopeData = finalScope.getScopeData();
      mergeScopeData(data2, finalScopeData);
    }
    const attachments = [...hint.attachments || [], ...data2.attachments];
    if (attachments.length) {
      hint.attachments = attachments;
    }
    applyScopeDataToEvent(prepared, data2);
    const eventProcessors = [
      ...clientEventProcessors,
      // Run scope event processors _after_ all other processors
      ...data2.eventProcessors
    ];
    const result = notifyEventProcessors(eventProcessors, prepared, hint);
    return result.then((evt) => {
      if (evt) {
        applyDebugMeta(evt);
      }
      if (typeof normalizeDepth === "number" && normalizeDepth > 0) {
        return normalizeEvent(evt, normalizeDepth, normalizeMaxBreadth);
      }
      return evt;
    });
  }
  function applyClientOptions(event, options) {
    const { environment, release, dist, maxValueLength = 250 } = options;
    event.environment = event.environment || environment || DEFAULT_ENVIRONMENT$1;
    if (!event.release && release) {
      event.release = release;
    }
    if (!event.dist && dist) {
      event.dist = dist;
    }
    if (event.message) {
      event.message = truncate(event.message, maxValueLength);
    }
    const exception = event.exception && event.exception.values && event.exception.values[0];
    if (exception && exception.value) {
      exception.value = truncate(exception.value, maxValueLength);
    }
    const request = event.request;
    if (request && request.url) {
      request.url = truncate(request.url, maxValueLength);
    }
  }
  function applyDebugIds(event, stackParser) {
    const filenameDebugIdMap = getFilenameToDebugIdMap(stackParser);
    try {
      event.exception.values.forEach((exception) => {
        exception.stacktrace.frames.forEach((frame) => {
          if (filenameDebugIdMap && frame.filename) {
            frame.debug_id = filenameDebugIdMap[frame.filename];
          }
        });
      });
    } catch (e2) {
    }
  }
  function applyDebugMeta(event) {
    const filenameDebugIdMap = {};
    try {
      event.exception.values.forEach((exception) => {
        exception.stacktrace.frames.forEach((frame) => {
          if (frame.debug_id) {
            if (frame.abs_path) {
              filenameDebugIdMap[frame.abs_path] = frame.debug_id;
            } else if (frame.filename) {
              filenameDebugIdMap[frame.filename] = frame.debug_id;
            }
            delete frame.debug_id;
          }
        });
      });
    } catch (e2) {
    }
    if (Object.keys(filenameDebugIdMap).length === 0) {
      return;
    }
    event.debug_meta = event.debug_meta || {};
    event.debug_meta.images = event.debug_meta.images || [];
    const images = event.debug_meta.images;
    Object.entries(filenameDebugIdMap).forEach(([filename, debug_id]) => {
      images.push({
        type: "sourcemap",
        code_file: filename,
        debug_id
      });
    });
  }
  function applyIntegrationsMetadata(event, integrationNames) {
    if (integrationNames.length > 0) {
      event.sdk = event.sdk || {};
      event.sdk.integrations = [...event.sdk.integrations || [], ...integrationNames];
    }
  }
  function normalizeEvent(event, depth, maxBreadth) {
    if (!event) {
      return null;
    }
    const normalized = {
      ...event,
      ...event.breadcrumbs && {
        breadcrumbs: event.breadcrumbs.map((b2) => ({
          ...b2,
          ...b2.data && {
            data: normalize$1(b2.data, depth, maxBreadth)
          }
        }))
      },
      ...event.user && {
        user: normalize$1(event.user, depth, maxBreadth)
      },
      ...event.contexts && {
        contexts: normalize$1(event.contexts, depth, maxBreadth)
      },
      ...event.extra && {
        extra: normalize$1(event.extra, depth, maxBreadth)
      }
    };
    if (event.contexts && event.contexts.trace && normalized.contexts) {
      normalized.contexts.trace = event.contexts.trace;
      if (event.contexts.trace.data) {
        normalized.contexts.trace.data = normalize$1(event.contexts.trace.data, depth, maxBreadth);
      }
    }
    if (event.spans) {
      normalized.spans = event.spans.map((span) => {
        return {
          ...span,
          ...span.data && {
            data: normalize$1(span.data, depth, maxBreadth)
          }
        };
      });
    }
    return normalized;
  }
  function getFinalScope(scope2, captureContext) {
    if (!captureContext) {
      return scope2;
    }
    const finalScope = scope2 ? scope2.clone() : new Scope();
    finalScope.update(captureContext);
    return finalScope;
  }
  function parseEventHintOrCaptureContext(hint) {
    if (!hint) {
      return void 0;
    }
    if (hintIsScopeOrFunction(hint)) {
      return { captureContext: hint };
    }
    if (hintIsScopeContext(hint)) {
      return {
        captureContext: hint
      };
    }
    return hint;
  }
  function hintIsScopeOrFunction(hint) {
    return hint instanceof Scope || typeof hint === "function";
  }
  const captureContextKeys = [
    "user",
    "level",
    "extra",
    "contexts",
    "tags",
    "fingerprint",
    "requestSession",
    "propagationContext"
  ];
  function hintIsScopeContext(hint) {
    return Object.keys(hint).some((key) => captureContextKeys.includes(key));
  }
  function captureException(exception, hint) {
    return getCurrentScope().captureException(exception, parseEventHintOrCaptureContext(hint));
  }
  function captureMessage(message2, captureContext) {
    const level = typeof captureContext === "string" ? captureContext : void 0;
    const context2 = typeof captureContext !== "string" ? { captureContext } : void 0;
    return getCurrentScope().captureMessage(message2, level, context2);
  }
  function captureEvent(event, hint) {
    return getCurrentScope().captureEvent(event, hint);
  }
  function setUser(user) {
    getIsolationScope().setUser(user);
  }
  async function flush(timeout) {
    const client = getClient();
    if (client) {
      return client.flush(timeout);
    }
    DEBUG_BUILD$3 && logger$2.warn("Cannot flush events. No client defined.");
    return Promise.resolve(false);
  }
  function isEnabled() {
    const client = getClient();
    return !!client && client.getOptions().enabled !== false && !!client.getTransport();
  }
  function startSession$1(context2) {
    const client = getClient();
    const isolationScope = getIsolationScope();
    const currentScope = getCurrentScope();
    const { release, environment = DEFAULT_ENVIRONMENT$1 } = client && client.getOptions() || {};
    const { userAgent: userAgent2 } = GLOBAL_OBJ.navigator || {};
    const session = makeSession({
      release,
      environment,
      user: currentScope.getUser() || isolationScope.getUser(),
      ...userAgent2 && { userAgent: userAgent2 },
      ...context2
    });
    const currentSession = isolationScope.getSession();
    if (currentSession && currentSession.status === "ok") {
      updateSession(currentSession, { status: "exited" });
    }
    endSession$1();
    isolationScope.setSession(session);
    currentScope.setSession(session);
    return session;
  }
  function endSession$1() {
    const isolationScope = getIsolationScope();
    const currentScope = getCurrentScope();
    const session = currentScope.getSession() || isolationScope.getSession();
    if (session) {
      closeSession(session);
    }
    _sendSessionUpdate();
    isolationScope.setSession();
    currentScope.setSession();
  }
  function _sendSessionUpdate() {
    const isolationScope = getIsolationScope();
    const currentScope = getCurrentScope();
    const client = getClient();
    const session = currentScope.getSession() || isolationScope.getSession();
    if (session && client) {
      client.captureSession(session);
    }
  }
  function captureSession(end = false) {
    if (end) {
      endSession$1();
      return;
    }
    _sendSessionUpdate();
  }
  class SessionFlusher {
    // Cast to any so that it can use Node.js timeout
    // eslint-disable-next-line @typescript-eslint/no-explicit-any
    constructor(client, attrs) {
      this._client = client;
      this.flushTimeout = 60;
      this._pendingAggregates = /* @__PURE__ */ new Map();
      this._isEnabled = true;
      this._intervalId = setInterval(() => this.flush(), this.flushTimeout * 1e3);
      if (this._intervalId.unref) {
        this._intervalId.unref();
      }
      this._sessionAttrs = attrs;
    }
    /** Checks if `pendingAggregates` has entries, and if it does flushes them by calling `sendSession` */
    flush() {
      const sessionAggregates = this.getSessionAggregates();
      if (sessionAggregates.aggregates.length === 0) {
        return;
      }
      this._pendingAggregates = /* @__PURE__ */ new Map();
      this._client.sendSession(sessionAggregates);
    }
    /** Massages the entries in `pendingAggregates` and returns aggregated sessions */
    getSessionAggregates() {
      const aggregates = Array.from(this._pendingAggregates.values());
      const sessionAggregates = {
        attrs: this._sessionAttrs,
        aggregates
      };
      return dropUndefinedKeys(sessionAggregates);
    }
    /** JSDoc */
    close() {
      clearInterval(this._intervalId);
      this._isEnabled = false;
      this.flush();
    }
    /**
     * Wrapper function for _incrementSessionStatusCount that checks if the instance of SessionFlusher is enabled then
     * fetches the session status of the request from `Scope.getRequestSession().status` on the scope and passes them to
     * `_incrementSessionStatusCount` along with the start date
     */
    incrementSessionStatusCount() {
      if (!this._isEnabled) {
        return;
      }
      const isolationScope = getIsolationScope();
      const requestSession = isolationScope.getRequestSession();
      if (requestSession && requestSession.status) {
        this._incrementSessionStatusCount(requestSession.status, /* @__PURE__ */ new Date());
        isolationScope.setRequestSession(void 0);
      }
    }
    /**
     * Increments status bucket in pendingAggregates buffer (internal state) corresponding to status of
     * the session received
     */
    _incrementSessionStatusCount(status, date) {
      const sessionStartedTrunc = new Date(date).setSeconds(0, 0);
      let aggregationCounts = this._pendingAggregates.get(sessionStartedTrunc);
      if (!aggregationCounts) {
        aggregationCounts = { started: new Date(sessionStartedTrunc).toISOString() };
        this._pendingAggregates.set(sessionStartedTrunc, aggregationCounts);
      }
      switch (status) {
        case "errored":
          aggregationCounts.errored = (aggregationCounts.errored || 0) + 1;
          return aggregationCounts.errored;
        case "ok":
          aggregationCounts.exited = (aggregationCounts.exited || 0) + 1;
          return aggregationCounts.exited;
        default:
          aggregationCounts.crashed = (aggregationCounts.crashed || 0) + 1;
          return aggregationCounts.crashed;
      }
    }
  }
  const SENTRY_API_VERSION = "7";
  function getBaseApiEndpoint(dsn) {
    const protocol = dsn.protocol ? `${dsn.protocol}:` : "";
    const port = dsn.port ? `:${dsn.port}` : "";
    return `${protocol}//${dsn.host}${port}${dsn.path ? `/${dsn.path}` : ""}/api/`;
  }
  function _getIngestEndpoint(dsn) {
    return `${getBaseApiEndpoint(dsn)}${dsn.projectId}/envelope/`;
  }
  function _encodedAuth(dsn, sdkInfo) {
    const params = {
      sentry_version: SENTRY_API_VERSION
    };
    if (dsn.publicKey) {
      params.sentry_key = dsn.publicKey;
    }
    if (sdkInfo) {
      params.sentry_client = `${sdkInfo.name}/${sdkInfo.version}`;
    }
    return new URLSearchParams(params).toString();
  }
  function getEnvelopeEndpointWithUrlEncodedAuth(dsn, tunnel, sdkInfo) {
    return tunnel ? tunnel : `${_getIngestEndpoint(dsn)}?${_encodedAuth(dsn, sdkInfo)}`;
  }
  const installedIntegrations = [];
  function filterDuplicates(integrations) {
    const integrationsByName = {};
    integrations.forEach((currentInstance) => {
      const { name: name2 } = currentInstance;
      const existingInstance = integrationsByName[name2];
      if (existingInstance && !existingInstance.isDefaultInstance && currentInstance.isDefaultInstance) {
        return;
      }
      integrationsByName[name2] = currentInstance;
    });
    return Object.values(integrationsByName);
  }
  function getIntegrationsToSetup(options) {
    const defaultIntegrations = options.defaultIntegrations || [];
    const userIntegrations = options.integrations;
    defaultIntegrations.forEach((integration) => {
      integration.isDefaultInstance = true;
    });
    let integrations;
    if (Array.isArray(userIntegrations)) {
      integrations = [...defaultIntegrations, ...userIntegrations];
    } else if (typeof userIntegrations === "function") {
      const resolvedUserIntegrations = userIntegrations(defaultIntegrations);
      integrations = Array.isArray(resolvedUserIntegrations) ? resolvedUserIntegrations : [resolvedUserIntegrations];
    } else {
      integrations = defaultIntegrations;
    }
    const finalIntegrations = filterDuplicates(integrations);
    const debugIndex = finalIntegrations.findIndex((integration) => integration.name === "Debug");
    if (debugIndex > -1) {
      const [debugInstance] = finalIntegrations.splice(debugIndex, 1);
      finalIntegrations.push(debugInstance);
    }
    return finalIntegrations;
  }
  function setupIntegrations(client, integrations) {
    const integrationIndex = {};
    integrations.forEach((integration) => {
      if (integration) {
        setupIntegration(client, integration, integrationIndex);
      }
    });
    return integrationIndex;
  }
  function afterSetupIntegrations(client, integrations) {
    for (const integration of integrations) {
      if (integration && integration.afterAllSetup) {
        integration.afterAllSetup(client);
      }
    }
  }
  function setupIntegration(client, integration, integrationIndex) {
    if (integrationIndex[integration.name]) {
      DEBUG_BUILD$3 && logger$2.log(`Integration skipped because it was already installed: ${integration.name}`);
      return;
    }
    integrationIndex[integration.name] = integration;
    if (installedIntegrations.indexOf(integration.name) === -1 && typeof integration.setupOnce === "function") {
      integration.setupOnce();
      installedIntegrations.push(integration.name);
    }
    if (integration.setup && typeof integration.setup === "function") {
      integration.setup(client);
    }
    if (typeof integration.preprocessEvent === "function") {
      const callback = integration.preprocessEvent.bind(integration);
      client.on("preprocessEvent", (event, hint) => callback(event, hint, client));
    }
    if (typeof integration.processEvent === "function") {
      const callback = integration.processEvent.bind(integration);
      const processor = Object.assign((event, hint) => callback(event, hint, client), {
        id: integration.name
      });
      client.addEventProcessor(processor);
    }
    DEBUG_BUILD$3 && logger$2.log(`Integration installed: ${integration.name}`);
  }
  function defineIntegration(fn) {
    return fn;
  }
  function createClientReportEnvelope(discarded_events, dsn, timestamp) {
    const clientReportItem = [
      { type: "client_report" },
      {
        timestamp: dateTimestampInSeconds(),
        discarded_events
      }
    ];
    return createEnvelope(dsn ? { dsn } : {}, [clientReportItem]);
  }
  class SentryError extends Error {
    /** Display name of this error instance. */
    constructor(message2, logLevel = "warn") {
      super(message2);
      this.message = message2;
      this.name = new.target.prototype.constructor.name;
      Object.setPrototypeOf(this, new.target.prototype);
      this.logLevel = logLevel;
    }
  }
  const ALREADY_SEEN_ERROR = "Not capturing exception because it's already been captured.";
  class BaseClient {
    /** Options passed to the SDK. */
    /** The client Dsn, if specified in options. Without this Dsn, the SDK will be disabled. */
    /** Array of set up integrations. */
    /** Number of calls being processed */
    /** Holds flushable  */
    // eslint-disable-next-line @typescript-eslint/ban-types
    /**
     * Initializes this client instance.
     *
     * @param options Options for the client.
     */
    constructor(options) {
      this._options = options;
      this._integrations = {};
      this._numProcessing = 0;
      this._outcomes = {};
      this._hooks = {};
      this._eventProcessors = [];
      if (options.dsn) {
        this._dsn = makeDsn(options.dsn);
      } else {
        DEBUG_BUILD$3 && logger$2.warn("No DSN provided, client will not send events.");
      }
      if (this._dsn) {
        const url2 = getEnvelopeEndpointWithUrlEncodedAuth(
          this._dsn,
          options.tunnel,
          options._metadata ? options._metadata.sdk : void 0
        );
        this._transport = options.transport({
          tunnel: this._options.tunnel,
          recordDroppedEvent: this.recordDroppedEvent.bind(this),
          ...options.transportOptions,
          url: url2
        });
      }
      const tracingOptions = ["enableTracing", "tracesSampleRate", "tracesSampler"];
      const undefinedOption = tracingOptions.find((option) => option in options && options[option] == void 0);
      if (undefinedOption) {
        consoleSandbox(() => {
          console.warn(
            `[Sentry] Deprecation warning: \`${undefinedOption}\` is set to undefined, which leads to tracing being enabled. In v9, a value of \`undefined\` will result in tracing being disabled.`
          );
        });
      }
    }
    /**
     * @inheritDoc
     */
    // eslint-disable-next-line @typescript-eslint/no-explicit-any
    captureException(exception, hint, scope2) {
      const eventId = uuid4();
      if (checkOrSetAlreadyCaught(exception)) {
        DEBUG_BUILD$3 && logger$2.log(ALREADY_SEEN_ERROR);
        return eventId;
      }
      const hintWithEventId = {
        event_id: eventId,
        ...hint
      };
      this._process(
        this.eventFromException(exception, hintWithEventId).then(
          (event) => this._captureEvent(event, hintWithEventId, scope2)
        )
      );
      return hintWithEventId.event_id;
    }
    /**
     * @inheritDoc
     */
    captureMessage(message2, level, hint, currentScope) {
      const hintWithEventId = {
        event_id: uuid4(),
        ...hint
      };
      const eventMessage = isParameterizedString(message2) ? message2 : String(message2);
      const promisedEvent = isPrimitive$1(message2) ? this.eventFromMessage(eventMessage, level, hintWithEventId) : this.eventFromException(message2, hintWithEventId);
      this._process(promisedEvent.then((event) => this._captureEvent(event, hintWithEventId, currentScope)));
      return hintWithEventId.event_id;
    }
    /**
     * @inheritDoc
     */
    captureEvent(event, hint, currentScope) {
      const eventId = uuid4();
      if (hint && hint.originalException && checkOrSetAlreadyCaught(hint.originalException)) {
        DEBUG_BUILD$3 && logger$2.log(ALREADY_SEEN_ERROR);
        return eventId;
      }
      const hintWithEventId = {
        event_id: eventId,
        ...hint
      };
      const sdkProcessingMetadata = event.sdkProcessingMetadata || {};
      const capturedSpanScope = sdkProcessingMetadata.capturedSpanScope;
      this._process(this._captureEvent(event, hintWithEventId, capturedSpanScope || currentScope));
      return hintWithEventId.event_id;
    }
    /**
     * @inheritDoc
     */
    captureSession(session) {
      if (!(typeof session.release === "string")) {
        DEBUG_BUILD$3 && logger$2.warn("Discarded session because of missing or non-string release");
      } else {
        this.sendSession(session);
        updateSession(session, { init: false });
      }
    }
    /**
     * @inheritDoc
     */
    getDsn() {
      return this._dsn;
    }
    /**
     * @inheritDoc
     */
    getOptions() {
      return this._options;
    }
    /**
     * @see SdkMetadata
     *
     * @return The metadata of the SDK
     */
    getSdkMetadata() {
      return this._options._metadata;
    }
    /**
     * @inheritDoc
     */
    getTransport() {
      return this._transport;
    }
    /**
     * @inheritDoc
     */
    flush(timeout) {
      const transport = this._transport;
      if (transport) {
        this.emit("flush");
        return this._isClientDoneProcessing(timeout).then((clientFinished) => {
          return transport.flush(timeout).then((transportFlushed) => clientFinished && transportFlushed);
        });
      } else {
        return resolvedSyncPromise(true);
      }
    }
    /**
     * @inheritDoc
     */
    close(timeout) {
      return this.flush(timeout).then((result) => {
        this.getOptions().enabled = false;
        this.emit("close");
        return result;
      });
    }
    /** Get all installed event processors. */
    getEventProcessors() {
      return this._eventProcessors;
    }
    /** @inheritDoc */
    addEventProcessor(eventProcessor) {
      this._eventProcessors.push(eventProcessor);
    }
    /** @inheritdoc */
    init() {
      if (this._isEnabled() || // Force integrations to be setup even if no DSN was set when we have
      // Spotlight enabled. This is particularly important for browser as we
      // don't support the `spotlight` option there and rely on the users
      // adding the `spotlightBrowserIntegration()` to their integrations which
      // wouldn't get initialized with the check below when there's no DSN set.
      this._options.integrations.some(({ name: name2 }) => name2.startsWith("Spotlight"))) {
        this._setupIntegrations();
      }
    }
    /**
     * Gets an installed integration by its name.
     *
     * @returns The installed integration or `undefined` if no integration with that `name` was installed.
     */
    getIntegrationByName(integrationName) {
      return this._integrations[integrationName];
    }
    /**
     * @inheritDoc
     */
    addIntegration(integration) {
      const isAlreadyInstalled = this._integrations[integration.name];
      setupIntegration(this, integration, this._integrations);
      if (!isAlreadyInstalled) {
        afterSetupIntegrations(this, [integration]);
      }
    }
    /**
     * @inheritDoc
     */
    sendEvent(event, hint = {}) {
      this.emit("beforeSendEvent", event, hint);
      let env2 = createEventEnvelope(event, this._dsn, this._options._metadata, this._options.tunnel);
      for (const attachment of hint.attachments || []) {
        env2 = addItemToEnvelope(env2, createAttachmentEnvelopeItem(attachment));
      }
      const promise2 = this.sendEnvelope(env2);
      if (promise2) {
        promise2.then((sendResponse) => this.emit("afterSendEvent", event, sendResponse), null);
      }
    }
    /**
     * @inheritDoc
     */
    sendSession(session) {
      const env2 = createSessionEnvelope(session, this._dsn, this._options._metadata, this._options.tunnel);
      this.sendEnvelope(env2);
    }
    /**
     * @inheritDoc
     */
    recordDroppedEvent(reason, category, eventOrCount) {
      if (this._options.sendClientReports) {
        const count = typeof eventOrCount === "number" ? eventOrCount : 1;
        const key = `${reason}:${category}`;
        DEBUG_BUILD$3 && logger$2.log(`Recording outcome: "${key}"${count > 1 ? ` (${count} times)` : ""}`);
        this._outcomes[key] = (this._outcomes[key] || 0) + count;
      }
    }
    // Keep on() & emit() signatures in sync with types' client.ts interface
    /* eslint-disable @typescript-eslint/unified-signatures */
    /** @inheritdoc */
    /** @inheritdoc */
    on(hook, callback) {
      const hooks = this._hooks[hook] = this._hooks[hook] || [];
      hooks.push(callback);
      return () => {
        const cbIndex = hooks.indexOf(callback);
        if (cbIndex > -1) {
          hooks.splice(cbIndex, 1);
        }
      };
    }
    /** @inheritdoc */
    /** @inheritdoc */
    emit(hook, ...rest) {
      const callbacks = this._hooks[hook];
      if (callbacks) {
        callbacks.forEach((callback) => callback(...rest));
      }
    }
    /**
     * @inheritdoc
     */
    sendEnvelope(envelope) {
      this.emit("beforeEnvelope", envelope);
      if (this._isEnabled() && this._transport) {
        return this._transport.send(envelope).then(null, (reason) => {
          DEBUG_BUILD$3 && logger$2.error("Error while sending envelope:", reason);
          return reason;
        });
      }
      DEBUG_BUILD$3 && logger$2.error("Transport disabled");
      return resolvedSyncPromise({});
    }
    /* eslint-enable @typescript-eslint/unified-signatures */
    /** Setup integrations for this client. */
    _setupIntegrations() {
      const { integrations } = this._options;
      this._integrations = setupIntegrations(this, integrations);
      afterSetupIntegrations(this, integrations);
    }
    /** Updates existing session based on the provided event */
    _updateSessionFromEvent(session, event) {
      let crashed = false;
      let errored = false;
      const exceptions = event.exception && event.exception.values;
      if (exceptions) {
        errored = true;
        for (const ex of exceptions) {
          const mechanism = ex.mechanism;
          if (mechanism && mechanism.handled === false) {
            crashed = true;
            break;
          }
        }
      }
      const sessionNonTerminal = session.status === "ok";
      const shouldUpdateAndSend = sessionNonTerminal && session.errors === 0 || sessionNonTerminal && crashed;
      if (shouldUpdateAndSend) {
        updateSession(session, {
          ...crashed && { status: "crashed" },
          errors: session.errors || Number(errored || crashed)
        });
        this.captureSession(session);
      }
    }
    /**
     * Determine if the client is finished processing. Returns a promise because it will wait `timeout` ms before saying
     * "no" (resolving to `false`) in order to give the client a chance to potentially finish first.
     *
     * @param timeout The time, in ms, after which to resolve to `false` if the client is still busy. Passing `0` (or not
     * passing anything) will make the promise wait as long as it takes for processing to finish before resolving to
     * `true`.
     * @returns A promise which will resolve to `true` if processing is already done or finishes before the timeout, and
     * `false` otherwise
     */
    _isClientDoneProcessing(timeout) {
      return new SyncPromise((resolve2) => {
        let ticked = 0;
        const tick = 1;
        const interval = setInterval(() => {
          if (this._numProcessing == 0) {
            clearInterval(interval);
            resolve2(true);
          } else {
            ticked += tick;
            if (timeout && ticked >= timeout) {
              clearInterval(interval);
              resolve2(false);
            }
          }
        }, tick);
      });
    }
    /** Determines whether this SDK is enabled and a transport is present. */
    _isEnabled() {
      return this.getOptions().enabled !== false && this._transport !== void 0;
    }
    /**
     * Adds common information to events.
     *
     * The information includes release and environment from `options`,
     * breadcrumbs and context (extra, tags and user) from the scope.
     *
     * Information that is already present in the event is never overwritten. For
     * nested objects, such as the context, keys are merged.
     *
     * @param event The original event.
     * @param hint May contain additional information about the original exception.
     * @param currentScope A scope containing event metadata.
     * @returns A new event with more information.
     */
    _prepareEvent(event, hint, currentScope = getCurrentScope(), isolationScope = getIsolationScope()) {
      const options = this.getOptions();
      const integrations = Object.keys(this._integrations);
      if (!hint.integrations && integrations.length > 0) {
        hint.integrations = integrations;
      }
      this.emit("preprocessEvent", event, hint);
      if (!event.type) {
        isolationScope.setLastEventId(event.event_id || hint.event_id);
      }
      return prepareEvent(options, event, hint, currentScope, this, isolationScope).then((evt) => {
        if (evt === null) {
          return evt;
        }
        evt.contexts = {
          trace: getTraceContextFromScope(currentScope),
          ...evt.contexts
        };
        const dynamicSamplingContext = getDynamicSamplingContextFromScope(this, currentScope);
        evt.sdkProcessingMetadata = {
          dynamicSamplingContext,
          ...evt.sdkProcessingMetadata
        };
        return evt;
      });
    }
    /**
     * Processes the event and logs an error in case of rejection
     * @param event
     * @param hint
     * @param scope
     */
    _captureEvent(event, hint = {}, scope2) {
      return this._processEvent(event, hint, scope2).then(
        (finalEvent) => {
          return finalEvent.event_id;
        },
        (reason) => {
          if (DEBUG_BUILD$3) {
            const sentryError = reason;
            if (sentryError.logLevel === "log") {
              logger$2.log(sentryError.message);
            } else {
              logger$2.warn(sentryError);
            }
          }
          return void 0;
        }
      );
    }
    /**
     * Processes an event (either error or message) and sends it to Sentry.
     *
     * This also adds breadcrumbs and context information to the event. However,
     * platform specific meta data (such as the User's IP address) must be added
     * by the SDK implementor.
     *
     *
     * @param event The event to send to Sentry.
     * @param hint May contain additional information about the original exception.
     * @param currentScope A scope containing event metadata.
     * @returns A SyncPromise that resolves with the event or rejects in case event was/will not be send.
     */
    _processEvent(event, hint, currentScope) {
      const options = this.getOptions();
      const { sampleRate } = options;
      const isTransaction = isTransactionEvent(event);
      const isError2 = isErrorEvent(event);
      const eventType = event.type || "error";
      const beforeSendLabel = `before send for type \`${eventType}\``;
      const parsedSampleRate = typeof sampleRate === "undefined" ? void 0 : parseSampleRate(sampleRate);
      if (isError2 && typeof parsedSampleRate === "number" && Math.random() > parsedSampleRate) {
        this.recordDroppedEvent("sample_rate", "error", event);
        return rejectedSyncPromise(
          new SentryError(
            `Discarding event because it's not included in the random sample (sampling rate = ${sampleRate})`,
            "log"
          )
        );
      }
      const dataCategory = eventType === "replay_event" ? "replay" : eventType;
      const sdkProcessingMetadata = event.sdkProcessingMetadata || {};
      const capturedSpanIsolationScope = sdkProcessingMetadata.capturedSpanIsolationScope;
      return this._prepareEvent(event, hint, currentScope, capturedSpanIsolationScope).then((prepared) => {
        if (prepared === null) {
          this.recordDroppedEvent("event_processor", dataCategory, event);
          throw new SentryError("An event processor returned `null`, will not send event.", "log");
        }
        const isInternalException = hint.data && hint.data.__sentry__ === true;
        if (isInternalException) {
          return prepared;
        }
        const result = processBeforeSend(this, options, prepared, hint);
        return _validateBeforeSendResult(result, beforeSendLabel);
      }).then((processedEvent) => {
        if (processedEvent === null) {
          this.recordDroppedEvent("before_send", dataCategory, event);
          if (isTransaction) {
            const spans = event.spans || [];
            const spanCount = 1 + spans.length;
            this.recordDroppedEvent("before_send", "span", spanCount);
          }
          throw new SentryError(`${beforeSendLabel} returned \`null\`, will not send event.`, "log");
        }
        const session = currentScope && currentScope.getSession();
        if (!isTransaction && session) {
          this._updateSessionFromEvent(session, processedEvent);
        }
        if (isTransaction) {
          const spanCountBefore = processedEvent.sdkProcessingMetadata && processedEvent.sdkProcessingMetadata.spanCountBeforeProcessing || 0;
          const spanCountAfter = processedEvent.spans ? processedEvent.spans.length : 0;
          const droppedSpanCount = spanCountBefore - spanCountAfter;
          if (droppedSpanCount > 0) {
            this.recordDroppedEvent("before_send", "span", droppedSpanCount);
          }
        }
        const transactionInfo = processedEvent.transaction_info;
        if (isTransaction && transactionInfo && processedEvent.transaction !== event.transaction) {
          const source = "custom";
          processedEvent.transaction_info = {
            ...transactionInfo,
            source
          };
        }
        this.sendEvent(processedEvent, hint);
        return processedEvent;
      }).then(null, (reason) => {
        if (reason instanceof SentryError) {
          throw reason;
        }
        this.captureException(reason, {
          data: {
            __sentry__: true
          },
          originalException: reason
        });
        throw new SentryError(
          `Event processing pipeline threw an error, original event will not be sent. Details have been sent as a new event.
Reason: ${reason}`
        );
      });
    }
    /**
     * Occupies the client with processing and event
     */
    _process(promise2) {
      this._numProcessing++;
      void promise2.then(
        (value) => {
          this._numProcessing--;
          return value;
        },
        (reason) => {
          this._numProcessing--;
          return reason;
        }
      );
    }
    /**
     * Clears outcomes on this client and returns them.
     */
    _clearOutcomes() {
      const outcomes = this._outcomes;
      this._outcomes = {};
      return Object.entries(outcomes).map(([key, quantity]) => {
        const [reason, category] = key.split(":");
        return {
          reason,
          category,
          quantity
        };
      });
    }
    /**
     * Sends client reports as an envelope.
     */
    _flushOutcomes() {
      DEBUG_BUILD$3 && logger$2.log("Flushing outcomes...");
      const outcomes = this._clearOutcomes();
      if (outcomes.length === 0) {
        DEBUG_BUILD$3 && logger$2.log("No outcomes to send");
        return;
      }
      if (!this._dsn) {
        DEBUG_BUILD$3 && logger$2.log("No dsn provided, will not send outcomes");
        return;
      }
      DEBUG_BUILD$3 && logger$2.log("Sending outcomes:", outcomes);
      const envelope = createClientReportEnvelope(outcomes, this._options.tunnel && dsnToString(this._dsn));
      this.sendEnvelope(envelope);
    }
    /**
     * @inheritDoc
     */
    // eslint-disable-next-line @typescript-eslint/no-explicit-any
  }
  function _validateBeforeSendResult(beforeSendResult, beforeSendLabel) {
    const invalidValueError = `${beforeSendLabel} must return \`null\` or a valid event.`;
    if (isThenable(beforeSendResult)) {
      return beforeSendResult.then(
        (event) => {
          if (!isPlainObject$1(event) && event !== null) {
            throw new SentryError(invalidValueError);
          }
          return event;
        },
        (e2) => {
          throw new SentryError(`${beforeSendLabel} rejected with ${e2}`);
        }
      );
    } else if (!isPlainObject$1(beforeSendResult) && beforeSendResult !== null) {
      throw new SentryError(invalidValueError);
    }
    return beforeSendResult;
  }
  function processBeforeSend(client, options, event, hint) {
    const { beforeSend, beforeSendTransaction, beforeSendSpan } = options;
    if (isErrorEvent(event) && beforeSend) {
      return beforeSend(event, hint);
    }
    if (isTransactionEvent(event)) {
      if (event.spans && beforeSendSpan) {
        const processedSpans = [];
        for (const span of event.spans) {
          const processedSpan = beforeSendSpan(span);
          if (processedSpan) {
            processedSpans.push(processedSpan);
          } else {
            showSpanDropWarning();
            client.recordDroppedEvent("before_send", "span");
          }
        }
        event.spans = processedSpans;
      }
      if (beforeSendTransaction) {
        if (event.spans) {
          const spanCountBefore = event.spans.length;
          event.sdkProcessingMetadata = {
            ...event.sdkProcessingMetadata,
            spanCountBeforeProcessing: spanCountBefore
          };
        }
        return beforeSendTransaction(event, hint);
      }
    }
    return event;
  }
  function isErrorEvent(event) {
    return event.type === void 0;
  }
  function isTransactionEvent(event) {
    return event.type === "transaction";
  }
  function createCheckInEnvelope(checkIn, dynamicSamplingContext, metadata, tunnel, dsn) {
    const headers = {
      sent_at: (/* @__PURE__ */ new Date()).toISOString()
    };
    if (metadata && metadata.sdk) {
      headers.sdk = {
        name: metadata.sdk.name,
        version: metadata.sdk.version
      };
    }
    if (!!tunnel && !!dsn) {
      headers.dsn = dsnToString(dsn);
    }
    if (dynamicSamplingContext) {
      headers.trace = dropUndefinedKeys(dynamicSamplingContext);
    }
    const item = createCheckInEnvelopeItem(checkIn);
    return createEnvelope(headers, [item]);
  }
  function createCheckInEnvelopeItem(checkIn) {
    const checkInHeaders = {
      type: "check_in"
    };
    return [checkInHeaders, checkIn];
  }
  function parseStackFrames(stackParser, error2) {
    return stackParser(error2.stack || "", 1);
  }
  function exceptionFromError(stackParser, error2) {
    const exception = {
      type: error2.name || error2.constructor.name,
      value: error2.message
    };
    const frames = parseStackFrames(stackParser, error2);
    if (frames.length) {
      exception.stacktrace = { frames };
    }
    return exception;
  }
  function getErrorPropertyFromObject(obj) {
    for (const prop in obj) {
      if (Object.prototype.hasOwnProperty.call(obj, prop)) {
        const value = obj[prop];
        if (value instanceof Error) {
          return value;
        }
      }
    }
    return void 0;
  }
  function getMessageForObject(exception) {
    if ("name" in exception && typeof exception.name === "string") {
      let message2 = `'${exception.name}' captured as exception`;
      if ("message" in exception && typeof exception.message === "string") {
        message2 += ` with message '${exception.message}'`;
      }
      return message2;
    } else if ("message" in exception && typeof exception.message === "string") {
      return exception.message;
    }
    const keys2 = extractExceptionKeysForMessage(exception);
    if (isErrorEvent$1(exception)) {
      return `Event \`ErrorEvent\` captured as exception with message \`${exception.message}\``;
    }
    const className = getObjectClassName(exception);
    return `${className && className !== "Object" ? `'${className}'` : "Object"} captured as exception with keys: ${keys2}`;
  }
  function getObjectClassName(obj) {
    try {
      const prototype = Object.getPrototypeOf(obj);
      return prototype ? prototype.constructor.name : void 0;
    } catch (e2) {
    }
  }
  function getException(client, mechanism, exception, hint) {
    if (isError(exception)) {
      return [exception, void 0];
    }
    mechanism.synthetic = true;
    if (isPlainObject$1(exception)) {
      const normalizeDepth = client && client.getOptions().normalizeDepth;
      const extras = { ["__serialized__"]: normalizeToSize(exception, normalizeDepth) };
      const errorFromProp = getErrorPropertyFromObject(exception);
      if (errorFromProp) {
        return [errorFromProp, extras];
      }
      const message2 = getMessageForObject(exception);
      const ex2 = hint && hint.syntheticException || new Error(message2);
      ex2.message = message2;
      return [ex2, extras];
    }
    const ex = hint && hint.syntheticException || new Error(exception);
    ex.message = `${exception}`;
    return [ex, void 0];
  }
  function eventFromUnknownInput(client, stackParser, exception, hint) {
    const providedMechanism = hint && hint.data && hint.data.mechanism;
    const mechanism = providedMechanism || {
      handled: true,
      type: "generic"
    };
    const [ex, extras] = getException(client, mechanism, exception, hint);
    const event = {
      exception: {
        values: [exceptionFromError(stackParser, ex)]
      }
    };
    if (extras) {
      event.extra = extras;
    }
    addExceptionTypeValue(event);
    addExceptionMechanism(event, mechanism);
    return {
      ...event,
      event_id: hint && hint.event_id
    };
  }
  function eventFromMessage(stackParser, message2, level = "info", hint, attachStacktrace) {
    const event = {
      event_id: hint && hint.event_id,
      level
    };
    if (attachStacktrace && hint && hint.syntheticException) {
      const frames = parseStackFrames(stackParser, hint.syntheticException);
      if (frames.length) {
        event.exception = {
          values: [
            {
              value: message2,
              stacktrace: { frames }
            }
          ]
        };
      }
    }
    if (isParameterizedString(message2)) {
      const { __sentry_template_string__, __sentry_template_values__ } = message2;
      event.logentry = {
        message: __sentry_template_string__,
        params: __sentry_template_values__
      };
      return event;
    }
    event.message = message2;
    return event;
  }
  class ServerRuntimeClient extends BaseClient {
    /**
     * Creates a new Edge SDK instance.
     * @param options Configuration options for this SDK.
     */
    constructor(options) {
      registerSpanErrorInstrumentation();
      super(options);
    }
    /**
     * @inheritDoc
     */
    eventFromException(exception, hint) {
      return resolvedSyncPromise(eventFromUnknownInput(this, this._options.stackParser, exception, hint));
    }
    /**
     * @inheritDoc
     */
    eventFromMessage(message2, level = "info", hint) {
      return resolvedSyncPromise(
        eventFromMessage(this._options.stackParser, message2, level, hint, this._options.attachStacktrace)
      );
    }
    /**
     * @inheritDoc
     */
    // eslint-disable-next-line @typescript-eslint/no-explicit-any
    captureException(exception, hint, scope2) {
      if (this._options.autoSessionTracking && this._sessionFlusher) {
        const requestSession = getIsolationScope().getRequestSession();
        if (requestSession && requestSession.status === "ok") {
          requestSession.status = "errored";
        }
      }
      return super.captureException(exception, hint, scope2);
    }
    /**
     * @inheritDoc
     */
    captureEvent(event, hint, scope2) {
      if (this._options.autoSessionTracking && this._sessionFlusher) {
        const eventType = event.type || "exception";
        const isException = eventType === "exception" && event.exception && event.exception.values && event.exception.values.length > 0;
        if (isException) {
          const requestSession = getIsolationScope().getRequestSession();
          if (requestSession && requestSession.status === "ok") {
            requestSession.status = "errored";
          }
        }
      }
      return super.captureEvent(event, hint, scope2);
    }
    /**
     *
     * @inheritdoc
     */
    close(timeout) {
      if (this._sessionFlusher) {
        this._sessionFlusher.close();
      }
      return super.close(timeout);
    }
    /** Method that initialises an instance of SessionFlusher on Client */
    initSessionFlusher() {
      const { release, environment } = this._options;
      if (!release) {
        DEBUG_BUILD$3 && logger$2.warn("Cannot initialise an instance of SessionFlusher if no release is provided!");
      } else {
        this._sessionFlusher = new SessionFlusher(this, {
          release,
          environment
        });
      }
    }
    /**
     * Create a cron monitor check in and send it to Sentry.
     *
     * @param checkIn An object that describes a check in.
     * @param upsertMonitorConfig An optional object that describes a monitor config. Use this if you want
     * to create a monitor automatically when sending a check in.
     */
    captureCheckIn(checkIn, monitorConfig, scope2) {
      const id = "checkInId" in checkIn && checkIn.checkInId ? checkIn.checkInId : uuid4();
      if (!this._isEnabled()) {
        DEBUG_BUILD$3 && logger$2.warn("SDK not enabled, will not capture checkin.");
        return id;
      }
      const options = this.getOptions();
      const { release, environment, tunnel } = options;
      const serializedCheckIn = {
        check_in_id: id,
        monitor_slug: checkIn.monitorSlug,
        status: checkIn.status,
        release,
        environment
      };
      if ("duration" in checkIn) {
        serializedCheckIn.duration = checkIn.duration;
      }
      if (monitorConfig) {
        serializedCheckIn.monitor_config = {
          schedule: monitorConfig.schedule,
          checkin_margin: monitorConfig.checkinMargin,
          max_runtime: monitorConfig.maxRuntime,
          timezone: monitorConfig.timezone,
          failure_issue_threshold: monitorConfig.failureIssueThreshold,
          recovery_threshold: monitorConfig.recoveryThreshold
        };
      }
      const [dynamicSamplingContext, traceContext] = this._getTraceInfoFromScope(scope2);
      if (traceContext) {
        serializedCheckIn.contexts = {
          trace: traceContext
        };
      }
      const envelope = createCheckInEnvelope(
        serializedCheckIn,
        dynamicSamplingContext,
        this.getSdkMetadata(),
        tunnel,
        this.getDsn()
      );
      DEBUG_BUILD$3 && logger$2.info("Sending checkin:", checkIn.monitorSlug, checkIn.status);
      this.sendEnvelope(envelope);
      return id;
    }
    /**
     * Method responsible for capturing/ending a request session by calling `incrementSessionStatusCount` to increment
     * appropriate session aggregates bucket
     */
    _captureRequestSession() {
      if (!this._sessionFlusher) {
        DEBUG_BUILD$3 && logger$2.warn("Discarded request mode session because autoSessionTracking option was disabled");
      } else {
        this._sessionFlusher.incrementSessionStatusCount();
      }
    }
    /**
     * @inheritDoc
     */
    _prepareEvent(event, hint, scope2, isolationScope) {
      if (this._options.platform) {
        event.platform = event.platform || this._options.platform;
      }
      if (this._options.runtime) {
        event.contexts = {
          ...event.contexts,
          runtime: (event.contexts || {}).runtime || this._options.runtime
        };
      }
      if (this._options.serverName) {
        event.server_name = event.server_name || this._options.serverName;
      }
      return super._prepareEvent(event, hint, scope2, isolationScope);
    }
    /** Extract trace information from scope */
    _getTraceInfoFromScope(scope2) {
      if (!scope2) {
        return [void 0, void 0];
      }
      const span = _getSpanForScope(scope2);
      const traceContext = span ? spanToTraceContext(span) : getTraceContextFromScope(scope2);
      const dynamicSamplingContext = span ? getDynamicSamplingContextFromSpan(span) : getDynamicSamplingContextFromScope(this, scope2);
      return [dynamicSamplingContext, traceContext];
    }
  }
  function makePromiseBuffer(limit) {
    const buffer2 = [];
    function isReady() {
      return limit === void 0 || buffer2.length < limit;
    }
    function remove(task) {
      return buffer2.splice(buffer2.indexOf(task), 1)[0] || Promise.resolve(void 0);
    }
    function add(taskProducer) {
      if (!isReady()) {
        return rejectedSyncPromise(new SentryError("Not adding Promise because buffer limit was reached."));
      }
      const task = taskProducer();
      if (buffer2.indexOf(task) === -1) {
        buffer2.push(task);
      }
      void task.then(() => remove(task)).then(
        null,
        () => remove(task).then(null, () => {
        })
      );
      return task;
    }
    function drain(timeout) {
      return new SyncPromise((resolve2, reject) => {
        let counter = buffer2.length;
        if (!counter) {
          return resolve2(true);
        }
        const capturedSetTimeout = setTimeout(() => {
          if (timeout && timeout > 0) {
            resolve2(false);
          }
        }, timeout);
        buffer2.forEach((item) => {
          void resolvedSyncPromise(item).then(() => {
            if (!--counter) {
              clearTimeout(capturedSetTimeout);
              resolve2(true);
            }
          }, reject);
        });
      });
    }
    return {
      $: buffer2,
      add,
      drain
    };
  }
  const DEFAULT_RETRY_AFTER = 60 * 1e3;
  function parseRetryAfterHeader(header, now = Date.now()) {
    const headerDelay = parseInt(`${header}`, 10);
    if (!isNaN(headerDelay)) {
      return headerDelay * 1e3;
    }
    const headerDate = Date.parse(`${header}`);
    if (!isNaN(headerDate)) {
      return headerDate - now;
    }
    return DEFAULT_RETRY_AFTER;
  }
  function disabledUntil(limits, dataCategory) {
    return limits[dataCategory] || limits.all || 0;
  }
  function isRateLimited(limits, dataCategory, now = Date.now()) {
    return disabledUntil(limits, dataCategory) > now;
  }
  function updateRateLimits(limits, { statusCode, headers }, now = Date.now()) {
    const updatedRateLimits = {
      ...limits
    };
    const rateLimitHeader = headers && headers["x-sentry-rate-limits"];
    const retryAfterHeader = headers && headers["retry-after"];
    if (rateLimitHeader) {
      for (const limit of rateLimitHeader.trim().split(",")) {
        const [retryAfter, categories, , , namespaces] = limit.split(":", 5);
        const headerDelay = parseInt(retryAfter, 10);
        const delay2 = (!isNaN(headerDelay) ? headerDelay : 60) * 1e3;
        if (!categories) {
          updatedRateLimits.all = now + delay2;
        } else {
          for (const category of categories.split(";")) {
            if (category === "metric_bucket") {
              if (!namespaces || namespaces.split(";").includes("custom")) {
                updatedRateLimits[category] = now + delay2;
              }
            } else {
              updatedRateLimits[category] = now + delay2;
            }
          }
        }
      }
    } else if (retryAfterHeader) {
      updatedRateLimits.all = now + parseRetryAfterHeader(retryAfterHeader, now);
    } else if (statusCode === 429) {
      updatedRateLimits.all = now + 60 * 1e3;
    }
    return updatedRateLimits;
  }
  const DEFAULT_TRANSPORT_BUFFER_SIZE = 64;
  function createTransport(options, makeRequest, buffer2 = makePromiseBuffer(
    options.bufferSize || DEFAULT_TRANSPORT_BUFFER_SIZE
  )) {
    let rateLimits = {};
    const flush2 = (timeout) => buffer2.drain(timeout);
    function send(envelope) {
      const filteredEnvelopeItems = [];
      forEachEnvelopeItem(envelope, (item, type2) => {
        const dataCategory = envelopeItemTypeToDataCategory(type2);
        if (isRateLimited(rateLimits, dataCategory)) {
          const event = getEventForEnvelopeItem(item, type2);
          options.recordDroppedEvent("ratelimit_backoff", dataCategory, event);
        } else {
          filteredEnvelopeItems.push(item);
        }
      });
      if (filteredEnvelopeItems.length === 0) {
        return resolvedSyncPromise({});
      }
      const filteredEnvelope = createEnvelope(envelope[0], filteredEnvelopeItems);
      const recordEnvelopeLoss = (reason) => {
        forEachEnvelopeItem(filteredEnvelope, (item, type2) => {
          const event = getEventForEnvelopeItem(item, type2);
          options.recordDroppedEvent(reason, envelopeItemTypeToDataCategory(type2), event);
        });
      };
      const requestTask = () => makeRequest({ body: serializeEnvelope(filteredEnvelope) }).then(
        (response) => {
          if (response.statusCode !== void 0 && (response.statusCode < 200 || response.statusCode >= 300)) {
            DEBUG_BUILD$3 && logger$2.warn(`Sentry responded with status code ${response.statusCode} to sent event.`);
          }
          rateLimits = updateRateLimits(rateLimits, response);
          return response;
        },
        (error2) => {
          recordEnvelopeLoss("network_error");
          throw error2;
        }
      );
      return buffer2.add(requestTask).then(
        (result) => result,
        (error2) => {
          if (error2 instanceof SentryError) {
            DEBUG_BUILD$3 && logger$2.error("Skipped sending event because buffer is full.");
            recordEnvelopeLoss("queue_overflow");
            return resolvedSyncPromise({});
          } else {
            throw error2;
          }
        }
      );
    }
    return {
      send,
      flush: flush2
    };
  }
  function getEventForEnvelopeItem(item, type2) {
    if (type2 !== "event" && type2 !== "transaction") {
      return void 0;
    }
    return Array.isArray(item) ? item[1] : void 0;
  }
  const MIN_DELAY = 100;
  const START_DELAY = 5e3;
  const MAX_DELAY = 36e5;
  function makeOfflineTransport(createTransport2) {
    function log2(...args2) {
      DEBUG_BUILD$3 && logger$2.info("[Offline]:", ...args2);
    }
    return (options) => {
      const transport = createTransport2(options);
      if (!options.createStore) {
        throw new Error("No `createStore` function was provided");
      }
      const store = options.createStore(options);
      let retryDelay = START_DELAY;
      let flushTimer;
      function shouldQueue(env2, error2, retryDelay2) {
        if (envelopeContainsItemType(env2, ["client_report"])) {
          return false;
        }
        if (options.shouldStore) {
          return options.shouldStore(env2, error2, retryDelay2);
        }
        return true;
      }
      function flushIn(delay2) {
        if (flushTimer) {
          clearTimeout(flushTimer);
        }
        flushTimer = setTimeout(async () => {
          flushTimer = void 0;
          const found = await store.shift();
          if (found) {
            log2("Attempting to send previously queued event");
            found[0].sent_at = (/* @__PURE__ */ new Date()).toISOString();
            void send(found, true).catch((e2) => {
              log2("Failed to retry sending", e2);
            });
          }
        }, delay2);
        if (typeof flushTimer !== "number" && flushTimer.unref) {
          flushTimer.unref();
        }
      }
      function flushWithBackOff() {
        if (flushTimer) {
          return;
        }
        flushIn(retryDelay);
        retryDelay = Math.min(retryDelay * 2, MAX_DELAY);
      }
      async function send(envelope, isRetry = false) {
        if (!isRetry && envelopeContainsItemType(envelope, ["replay_event", "replay_recording"])) {
          await store.push(envelope);
          flushIn(MIN_DELAY);
          return {};
        }
        try {
          const result = await transport.send(envelope);
          let delay2 = MIN_DELAY;
          if (result) {
            if (result.headers && result.headers["retry-after"]) {
              delay2 = parseRetryAfterHeader(result.headers["retry-after"]);
            } else if (result.headers && result.headers["x-sentry-rate-limits"]) {
              delay2 = 6e4;
            } else if ((result.statusCode || 0) >= 400) {
              return result;
            }
          }
          flushIn(delay2);
          retryDelay = START_DELAY;
          return result;
        } catch (e2) {
          if (await shouldQueue(envelope, e2, retryDelay)) {
            if (isRetry) {
              await store.unshift(envelope);
            } else {
              await store.push(envelope);
            }
            flushWithBackOff();
            log2("Error sending. Event queued.", e2);
            return {};
          } else {
            throw e2;
          }
        }
      }
      if (options.flushAtStartup) {
        flushWithBackOff();
      }
      return {
        send,
        flush: (t2) => transport.flush(t2)
      };
    };
  }
  function applySdkMetadata(options, name2, names = [name2], source = "npm") {
    const metadata = options._metadata || {};
    if (!metadata.sdk) {
      metadata.sdk = {
        name: `sentry.javascript.${name2}`,
        packages: names.map((name3) => ({
          name: `${source}:@sentry/${name3}`,
          version: SDK_VERSION$1
        })),
        version: SDK_VERSION$1
      };
    }
    options._metadata = metadata;
  }
  function getTraceData$1(options = {}) {
    const client = getClient();
    if (!isEnabled() || !client) {
      return {};
    }
    const carrier = getMainCarrier();
    const acs = getAsyncContextStrategy(carrier);
    if (acs.getTraceData) {
      return acs.getTraceData(options);
    }
    const scope2 = getCurrentScope();
    const span = options.span || getActiveSpan$2();
    const sentryTrace = span ? spanToTraceHeader(span) : scopeToTraceHeader(scope2);
    const dsc = span ? getDynamicSamplingContextFromSpan(span) : getDynamicSamplingContextFromScope(client, scope2);
    const baggage = dynamicSamplingContextToSentryBaggageHeader(dsc);
    const isValidSentryTraceHeader = TRACEPARENT_REGEXP.test(sentryTrace);
    if (!isValidSentryTraceHeader) {
      logger$2.warn("Invalid sentry-trace data. Cannot generate trace data");
      return {};
    }
    return {
      "sentry-trace": sentryTrace,
      baggage
    };
  }
  function scopeToTraceHeader(scope2) {
    const { traceId, sampled, spanId } = scope2.getPropagationContext();
    return generateSentryTraceHeader(traceId, spanId, sampled);
  }
  const DEFAULT_BREADCRUMBS = 100;
  function addBreadcrumb(breadcrumb, hint) {
    const client = getClient();
    const isolationScope = getIsolationScope();
    if (!client) return;
    const { beforeBreadcrumb = null, maxBreadcrumbs = DEFAULT_BREADCRUMBS } = client.getOptions();
    if (maxBreadcrumbs <= 0) return;
    const timestamp = dateTimestampInSeconds();
    const mergedBreadcrumb = { timestamp, ...breadcrumb };
    const finalBreadcrumb = beforeBreadcrumb ? consoleSandbox(() => beforeBreadcrumb(mergedBreadcrumb, hint)) : mergedBreadcrumb;
    if (finalBreadcrumb === null) return;
    if (client.emit) {
      client.emit("beforeAddBreadcrumb", finalBreadcrumb, hint);
    }
    isolationScope.addBreadcrumb(finalBreadcrumb, maxBreadcrumbs);
  }
  let originalFunctionToString;
  const INTEGRATION_NAME$7 = "FunctionToString";
  const SETUP_CLIENTS = /* @__PURE__ */ new WeakMap();
  const _functionToStringIntegration = () => {
    return {
      name: INTEGRATION_NAME$7,
      setupOnce() {
        originalFunctionToString = Function.prototype.toString;
        try {
          Function.prototype.toString = function(...args2) {
            const originalFunction = getOriginalFunction(this);
            const context2 = SETUP_CLIENTS.has(getClient()) && originalFunction !== void 0 ? originalFunction : this;
            return originalFunctionToString.apply(context2, args2);
          };
        } catch (e2) {
        }
      },
      setup(client) {
        SETUP_CLIENTS.set(client, true);
      }
    };
  };
  const functionToStringIntegration = defineIntegration(_functionToStringIntegration);
  const DEFAULT_IGNORE_ERRORS = [
    /^Script error\.?$/,
    /^Javascript error: Script error\.? on line 0$/,
    /^ResizeObserver loop completed with undelivered notifications.$/,
    // The browser logs this when a ResizeObserver handler takes a bit longer. Usually this is not an actual issue though. It indicates slowness.
    /^Cannot redefine property: googletag$/,
    // This is thrown when google tag manager is used in combination with an ad blocker
    "undefined is not an object (evaluating 'a.L')",
    // Random error that happens but not actionable or noticeable to end-users.
    `can't redefine non-configurable property "solana"`,
    // Probably a browser extension or custom browser (Brave) throwing this error
    "vv().getRestrictions is not a function. (In 'vv().getRestrictions(1,a)', 'vv().getRestrictions' is undefined)",
    // Error thrown by GTM, seemingly not affecting end-users
    "Can't find variable: _AutofillCallbackHandler"
    // Unactionable error in instagram webview https://developers.facebook.com/community/threads/320013549791141/
  ];
  const INTEGRATION_NAME$6 = "InboundFilters";
  const _inboundFiltersIntegration = (options = {}) => {
    return {
      name: INTEGRATION_NAME$6,
      processEvent(event, _hint, client) {
        const clientOptions = client.getOptions();
        const mergedOptions = _mergeOptions(options, clientOptions);
        return _shouldDropEvent(event, mergedOptions) ? null : event;
      }
    };
  };
  const inboundFiltersIntegration = defineIntegration(_inboundFiltersIntegration);
  function _mergeOptions(internalOptions = {}, clientOptions = {}) {
    return {
      allowUrls: [...internalOptions.allowUrls || [], ...clientOptions.allowUrls || []],
      denyUrls: [...internalOptions.denyUrls || [], ...clientOptions.denyUrls || []],
      ignoreErrors: [
        ...internalOptions.ignoreErrors || [],
        ...clientOptions.ignoreErrors || [],
        ...internalOptions.disableErrorDefaults ? [] : DEFAULT_IGNORE_ERRORS
      ],
      ignoreTransactions: [...internalOptions.ignoreTransactions || [], ...clientOptions.ignoreTransactions || []],
      ignoreInternal: internalOptions.ignoreInternal !== void 0 ? internalOptions.ignoreInternal : true
    };
  }
  function _shouldDropEvent(event, options) {
    if (options.ignoreInternal && _isSentryError(event)) {
      DEBUG_BUILD$3 && logger$2.warn(`Event dropped due to being internal Sentry Error.
Event: ${getEventDescription(event)}`);
      return true;
    }
    if (_isIgnoredError(event, options.ignoreErrors)) {
      DEBUG_BUILD$3 && logger$2.warn(
        `Event dropped due to being matched by \`ignoreErrors\` option.
Event: ${getEventDescription(event)}`
      );
      return true;
    }
    if (_isUselessError(event)) {
      DEBUG_BUILD$3 && logger$2.warn(
        `Event dropped due to not having an error message, error type or stacktrace.
Event: ${getEventDescription(
          event
        )}`
      );
      return true;
    }
    if (_isIgnoredTransaction(event, options.ignoreTransactions)) {
      DEBUG_BUILD$3 && logger$2.warn(
        `Event dropped due to being matched by \`ignoreTransactions\` option.
Event: ${getEventDescription(event)}`
      );
      return true;
    }
    if (_isDeniedUrl(event, options.denyUrls)) {
      DEBUG_BUILD$3 && logger$2.warn(
        `Event dropped due to being matched by \`denyUrls\` option.
Event: ${getEventDescription(
          event
        )}.
Url: ${_getEventFilterUrl(event)}`
      );
      return true;
    }
    if (!_isAllowedUrl(event, options.allowUrls)) {
      DEBUG_BUILD$3 && logger$2.warn(
        `Event dropped due to not being matched by \`allowUrls\` option.
Event: ${getEventDescription(
          event
        )}.
Url: ${_getEventFilterUrl(event)}`
      );
      return true;
    }
    return false;
  }
  function _isIgnoredError(event, ignoreErrors) {
    if (event.type || !ignoreErrors || !ignoreErrors.length) {
      return false;
    }
    return _getPossibleEventMessages(event).some((message2) => stringMatchesSomePattern(message2, ignoreErrors));
  }
  function _isIgnoredTransaction(event, ignoreTransactions) {
    if (event.type !== "transaction" || !ignoreTransactions || !ignoreTransactions.length) {
      return false;
    }
    const name2 = event.transaction;
    return name2 ? stringMatchesSomePattern(name2, ignoreTransactions) : false;
  }
  function _isDeniedUrl(event, denyUrls) {
    if (!denyUrls || !denyUrls.length) {
      return false;
    }
    const url2 = _getEventFilterUrl(event);
    return !url2 ? false : stringMatchesSomePattern(url2, denyUrls);
  }
  function _isAllowedUrl(event, allowUrls) {
    if (!allowUrls || !allowUrls.length) {
      return true;
    }
    const url2 = _getEventFilterUrl(event);
    return !url2 ? true : stringMatchesSomePattern(url2, allowUrls);
  }
  function _getPossibleEventMessages(event) {
    const possibleMessages = [];
    if (event.message) {
      possibleMessages.push(event.message);
    }
    let lastException;
    try {
      lastException = event.exception.values[event.exception.values.length - 1];
    } catch (e2) {
    }
    if (lastException) {
      if (lastException.value) {
        possibleMessages.push(lastException.value);
        if (lastException.type) {
          possibleMessages.push(`${lastException.type}: ${lastException.value}`);
        }
      }
    }
    return possibleMessages;
  }
  function _isSentryError(event) {
    try {
      return event.exception.values[0].type === "SentryError";
    } catch (e2) {
    }
    return false;
  }
  function _getLastValidUrl(frames = []) {
    for (let i2 = frames.length - 1; i2 >= 0; i2--) {
      const frame = frames[i2];
      if (frame && frame.filename !== "<anonymous>" && frame.filename !== "[native code]") {
        return frame.filename || null;
      }
    }
    return null;
  }
  function _getEventFilterUrl(event) {
    try {
      let frames;
      try {
        frames = event.exception.values[0].stacktrace.frames;
      } catch (e2) {
      }
      return frames ? _getLastValidUrl(frames) : null;
    } catch (oO) {
      DEBUG_BUILD$3 && logger$2.error(`Cannot extract url for event ${getEventDescription(event)}`);
      return null;
    }
  }
  function _isUselessError(event) {
    if (event.type) {
      return false;
    }
    if (!event.exception || !event.exception.values || event.exception.values.length === 0) {
      return false;
    }
    return (
      // No top-level message
      !event.message && // There are no exception values that have a stacktrace, a non-generic-Error type or value
      !event.exception.values.some((value) => value.stacktrace || value.type && value.type !== "Error" || value.value)
    );
  }
  function applyAggregateErrorsToEvent(exceptionFromErrorImplementation, parser, maxValueLimit = 250, key, limit, event, hint) {
    if (!event.exception || !event.exception.values || !hint || !isInstanceOf(hint.originalException, Error)) {
      return;
    }
    const originalException = event.exception.values.length > 0 ? event.exception.values[event.exception.values.length - 1] : void 0;
    if (originalException) {
      event.exception.values = truncateAggregateExceptions(
        aggregateExceptionsFromError(
          exceptionFromErrorImplementation,
          parser,
          limit,
          hint.originalException,
          key,
          event.exception.values,
          originalException,
          0
        ),
        maxValueLimit
      );
    }
  }
  function aggregateExceptionsFromError(exceptionFromErrorImplementation, parser, limit, error2, key, prevExceptions, exception, exceptionId) {
    if (prevExceptions.length >= limit + 1) {
      return prevExceptions;
    }
    let newExceptions = [...prevExceptions];
    if (isInstanceOf(error2[key], Error)) {
      applyExceptionGroupFieldsForParentException(exception, exceptionId);
      const newException = exceptionFromErrorImplementation(parser, error2[key]);
      const newExceptionId = newExceptions.length;
      applyExceptionGroupFieldsForChildException(newException, key, newExceptionId, exceptionId);
      newExceptions = aggregateExceptionsFromError(
        exceptionFromErrorImplementation,
        parser,
        limit,
        error2[key],
        key,
        [newException, ...newExceptions],
        newException,
        newExceptionId
      );
    }
    if (Array.isArray(error2.errors)) {
      error2.errors.forEach((childError, i2) => {
        if (isInstanceOf(childError, Error)) {
          applyExceptionGroupFieldsForParentException(exception, exceptionId);
          const newException = exceptionFromErrorImplementation(parser, childError);
          const newExceptionId = newExceptions.length;
          applyExceptionGroupFieldsForChildException(newException, `errors[${i2}]`, newExceptionId, exceptionId);
          newExceptions = aggregateExceptionsFromError(
            exceptionFromErrorImplementation,
            parser,
            limit,
            childError,
            key,
            [newException, ...newExceptions],
            newException,
            newExceptionId
          );
        }
      });
    }
    return newExceptions;
  }
  function applyExceptionGroupFieldsForParentException(exception, exceptionId) {
    exception.mechanism = exception.mechanism || { type: "generic", handled: true };
    exception.mechanism = {
      ...exception.mechanism,
      ...exception.type === "AggregateError" && { is_exception_group: true },
      exception_id: exceptionId
    };
  }
  function applyExceptionGroupFieldsForChildException(exception, source, exceptionId, parentId) {
    exception.mechanism = exception.mechanism || { type: "generic", handled: true };
    exception.mechanism = {
      ...exception.mechanism,
      type: "chained",
      source,
      exception_id: exceptionId,
      parent_id: parentId
    };
  }
  function truncateAggregateExceptions(exceptions, maxValueLength) {
    return exceptions.map((exception) => {
      if (exception.value) {
        exception.value = truncate(exception.value, maxValueLength);
      }
      return exception;
    });
  }
  const DEFAULT_KEY = "cause";
  const DEFAULT_LIMIT = 5;
  const INTEGRATION_NAME$5 = "LinkedErrors";
  const _linkedErrorsIntegration = (options = {}) => {
    const limit = options.limit || DEFAULT_LIMIT;
    const key = options.key || DEFAULT_KEY;
    return {
      name: INTEGRATION_NAME$5,
      preprocessEvent(event, hint, client) {
        const options2 = client.getOptions();
        applyAggregateErrorsToEvent(
          exceptionFromError,
          options2.stackParser,
          options2.maxValueLength,
          key,
          limit,
          event,
          hint
        );
      }
    };
  };
  const linkedErrorsIntegration = defineIntegration(_linkedErrorsIntegration);
  function parseUrl(url2) {
    if (!url2) {
      return {};
    }
    const match = url2.match(/^(([^:/?#]+):)?(\/\/([^/?#]*))?([^?#]*)(\?([^#]*))?(#(.*))?$/);
    if (!match) {
      return {};
    }
    const query = match[6] || "";
    const fragment = match[8] || "";
    return {
      host: match[4],
      path: match[5],
      protocol: match[2],
      search: query,
      hash: fragment,
      relative: match[5] + query + fragment
      // everything minus origin
    };
  }
  function stripUrlQueryAndFragment(urlPath) {
    return urlPath.split(/[?#]/, 1)[0];
  }
  function getSanitizedUrlString(url2) {
    const { protocol, host, path: path2 } = url2;
    const filteredHost = host && host.replace(/^.*@/, "[filtered]:[filtered]@").replace(/(:80)$/, "").replace(/(:443)$/, "") || "";
    return `${protocol ? `${protocol}://` : ""}${filteredHost}${path2}`;
  }
  function addConsoleInstrumentationHandler(handler) {
    const type2 = "console";
    addHandler$1(type2, handler);
    maybeInstrument(type2, instrumentConsole);
  }
  function instrumentConsole() {
    if (!("console" in GLOBAL_OBJ)) {
      return;
    }
    CONSOLE_LEVELS.forEach(function(level) {
      if (!(level in GLOBAL_OBJ.console)) {
        return;
      }
      fill(GLOBAL_OBJ.console, level, function(originalConsoleMethod) {
        originalConsoleMethods[level] = originalConsoleMethod;
        return function(...args2) {
          const handlerData = { args: args2, level };
          triggerHandlers("console", handlerData);
          const log2 = originalConsoleMethods[level];
          log2 && log2.apply(GLOBAL_OBJ.console, args2);
        };
      });
    });
  }
  function severityLevelFromString(level) {
    return level === "warn" ? "warning" : ["fatal", "error", "warning", "log", "info", "debug"].includes(level) ? level : "log";
  }
  const splitPathRe = /^(\S+:\\|\/?)([\s\S]*?)((?:\.{1,2}|[^/\\]+?|)(\.[^./\\]*|))(?:[/\\]*)$/;
  function splitPath(filename) {
    const truncated = filename.length > 1024 ? `<truncated>${filename.slice(-1024)}` : filename;
    const parts = splitPathRe.exec(truncated);
    return parts ? parts.slice(1) : [];
  }
  function dirname(path2) {
    const result = splitPath(path2);
    const root2 = result[0] || "";
    let dir = result[1];
    if (!root2 && !dir) {
      return ".";
    }
    if (dir) {
      dir = dir.slice(0, dir.length - 1);
    }
    return root2 + dir;
  }
  function basename(path2, ext) {
    let f2 = splitPath(path2)[2] || "";
    return f2;
  }
  const COUNTER_METRIC_TYPE = "c";
  const GAUGE_METRIC_TYPE = "g";
  const SET_METRIC_TYPE = "s";
  const DISTRIBUTION_METRIC_TYPE = "d";
  const DEFAULT_FLUSH_INTERVAL = 1e4;
  const MAX_WEIGHT = 1e4;
  function getMetricsAggregatorForClient$1(client, Aggregator) {
    const globalMetricsAggregators = getGlobalSingleton(
      "globalMetricsAggregators",
      () => /* @__PURE__ */ new WeakMap()
    );
    const aggregator = globalMetricsAggregators.get(client);
    if (aggregator) {
      return aggregator;
    }
    const newAggregator = new Aggregator(client);
    client.on("flush", () => newAggregator.flush());
    client.on("close", () => newAggregator.close());
    globalMetricsAggregators.set(client, newAggregator);
    return newAggregator;
  }
  function addToMetricsAggregator(Aggregator, metricType, name2, value, data2 = {}) {
    const client = data2.client || getClient();
    if (!client) {
      return;
    }
    const span = getActiveSpan$2();
    const rootSpan = span ? getRootSpan(span) : void 0;
    const transactionName = rootSpan && spanToJSON(rootSpan).description;
    const { unit, tags, timestamp } = data2;
    const { release, environment } = client.getOptions();
    const metricTags = {};
    if (release) {
      metricTags.release = release;
    }
    if (environment) {
      metricTags.environment = environment;
    }
    if (transactionName) {
      metricTags.transaction = transactionName;
    }
    DEBUG_BUILD$3 && logger$2.log(`Adding value of ${value} to ${metricType} metric ${name2}`);
    const aggregator = getMetricsAggregatorForClient$1(client, Aggregator);
    aggregator.add(metricType, name2, value, unit, { ...metricTags, ...tags }, timestamp);
  }
  function increment$1(aggregator, name2, value = 1, data2) {
    addToMetricsAggregator(aggregator, COUNTER_METRIC_TYPE, name2, ensureNumber(value), data2);
  }
  function distribution$1(aggregator, name2, value, data2) {
    addToMetricsAggregator(aggregator, DISTRIBUTION_METRIC_TYPE, name2, ensureNumber(value), data2);
  }
  function timing$1(aggregator, name2, value, unit = "second", data2) {
    if (typeof value === "function") {
      const startTime = timestampInSeconds();
      return startSpanManual$1(
        {
          op: "metrics.timing",
          name: name2,
          startTime,
          onlyIfParent: true
        },
        (span) => {
          return handleCallbackErrors(
            () => value(),
            () => {
            },
            () => {
              const endTime = timestampInSeconds();
              const timeDiff = endTime - startTime;
              distribution$1(aggregator, name2, timeDiff, { ...data2, unit: "second" });
              span.end(endTime);
            }
          );
        }
      );
    }
    distribution$1(aggregator, name2, value, { ...data2, unit });
  }
  function set$1(aggregator, name2, value, data2) {
    addToMetricsAggregator(aggregator, SET_METRIC_TYPE, name2, value, data2);
  }
  function gauge$1(aggregator, name2, value, data2) {
    addToMetricsAggregator(aggregator, GAUGE_METRIC_TYPE, name2, ensureNumber(value), data2);
  }
  const metrics$1 = {
    increment: increment$1,
    distribution: distribution$1,
    set: set$1,
    gauge: gauge$1,
    timing: timing$1,
    /**
     * @ignore This is for internal use only.
     */
    getMetricsAggregatorForClient: getMetricsAggregatorForClient$1
  };
  function ensureNumber(number) {
    return typeof number === "string" ? parseInt(number) : number;
  }
  function getBucketKey(metricType, name2, unit, tags) {
    const stringifiedTags = Object.entries(dropUndefinedKeys(tags)).sort((a2, b2) => a2[0].localeCompare(b2[0]));
    return `${metricType}${name2}${unit}${stringifiedTags}`;
  }
  function simpleHash(s2) {
    let rv = 0;
    for (let i2 = 0; i2 < s2.length; i2++) {
      const c2 = s2.charCodeAt(i2);
      rv = (rv << 5) - rv + c2;
      rv &= rv;
    }
    return rv >>> 0;
  }
  function serializeMetricBuckets(metricBucketItems) {
    let out = "";
    for (const item of metricBucketItems) {
      const tagEntries = Object.entries(item.tags);
      const maybeTags = tagEntries.length > 0 ? `|#${tagEntries.map(([key, value]) => `${key}:${value}`).join(",")}` : "";
      out += `${item.name}@${item.unit}:${item.metric}|${item.metricType}${maybeTags}|T${item.timestamp}
`;
    }
    return out;
  }
  function sanitizeUnit(unit) {
    return unit.replace(/[^\w]+/gi, "_");
  }
  function sanitizeMetricKey(key) {
    return key.replace(/[^\w\-.]+/gi, "_");
  }
  function sanitizeTagKey(key) {
    return key.replace(/[^\w\-./]+/gi, "");
  }
  const tagValueReplacements = [
    ["\n", "\\n"],
    ["\r", "\\r"],
    ["	", "\\t"],
    ["\\", "\\\\"],
    ["|", "\\u{7c}"],
    [",", "\\u{2c}"]
  ];
  function getCharOrReplacement(input) {
    for (const [search, replacement] of tagValueReplacements) {
      if (input === search) {
        return replacement;
      }
    }
    return input;
  }
  function sanitizeTagValue(value) {
    return [...value].reduce((acc, char) => acc + getCharOrReplacement(char), "");
  }
  function sanitizeTags(unsanitizedTags) {
    const tags = {};
    for (const key in unsanitizedTags) {
      if (Object.prototype.hasOwnProperty.call(unsanitizedTags, key)) {
        const sanitizedKey = sanitizeTagKey(key);
        tags[sanitizedKey] = sanitizeTagValue(String(unsanitizedTags[key]));
      }
    }
    return tags;
  }
  function captureAggregateMetrics(client, metricBucketItems) {
    logger$2.log(`Flushing aggregated metrics, number of metrics: ${metricBucketItems.length}`);
    const dsn = client.getDsn();
    const metadata = client.getSdkMetadata();
    const tunnel = client.getOptions().tunnel;
    const metricsEnvelope = createMetricEnvelope(metricBucketItems, dsn, metadata, tunnel);
    client.sendEnvelope(metricsEnvelope);
  }
  function createMetricEnvelope(metricBucketItems, dsn, metadata, tunnel) {
    const headers = {
      sent_at: (/* @__PURE__ */ new Date()).toISOString()
    };
    if (metadata && metadata.sdk) {
      headers.sdk = {
        name: metadata.sdk.name,
        version: metadata.sdk.version
      };
    }
    if (!!tunnel && dsn) {
      headers.dsn = dsnToString(dsn);
    }
    const item = createMetricEnvelopeItem(metricBucketItems);
    return createEnvelope(headers, [item]);
  }
  function createMetricEnvelopeItem(metricBucketItems) {
    const payload = serializeMetricBuckets(metricBucketItems);
    const metricHeaders = {
      type: "statsd",
      length: payload.length
    };
    return [metricHeaders, payload];
  }
  class CounterMetric {
    constructor(_value) {
      this._value = _value;
    }
    /** @inheritDoc */
    get weight() {
      return 1;
    }
    /** @inheritdoc */
    add(value) {
      this._value += value;
    }
    /** @inheritdoc */
    toString() {
      return `${this._value}`;
    }
  }
  class GaugeMetric {
    constructor(value) {
      this._last = value;
      this._min = value;
      this._max = value;
      this._sum = value;
      this._count = 1;
    }
    /** @inheritDoc */
    get weight() {
      return 5;
    }
    /** @inheritdoc */
    add(value) {
      this._last = value;
      if (value < this._min) {
        this._min = value;
      }
      if (value > this._max) {
        this._max = value;
      }
      this._sum += value;
      this._count++;
    }
    /** @inheritdoc */
    toString() {
      return `${this._last}:${this._min}:${this._max}:${this._sum}:${this._count}`;
    }
  }
  class DistributionMetric {
    constructor(first) {
      this._value = [first];
    }
    /** @inheritDoc */
    get weight() {
      return this._value.length;
    }
    /** @inheritdoc */
    add(value) {
      this._value.push(value);
    }
    /** @inheritdoc */
    toString() {
      return this._value.join(":");
    }
  }
  class SetMetric {
    constructor(first) {
      this.first = first;
      this._value = /* @__PURE__ */ new Set([first]);
    }
    /** @inheritDoc */
    get weight() {
      return this._value.size;
    }
    /** @inheritdoc */
    add(value) {
      this._value.add(value);
    }
    /** @inheritdoc */
    toString() {
      return Array.from(this._value).map((val) => typeof val === "string" ? simpleHash(val) : val).join(":");
    }
  }
  const METRIC_MAP = {
    [COUNTER_METRIC_TYPE]: CounterMetric,
    [GAUGE_METRIC_TYPE]: GaugeMetric,
    [DISTRIBUTION_METRIC_TYPE]: DistributionMetric,
    [SET_METRIC_TYPE]: SetMetric
  };
  class MetricsAggregator {
    // TODO(@anonrig): Use FinalizationRegistry to have a proper way of flushing the buckets
    // when the aggregator is garbage collected.
    // Ref: https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/FinalizationRegistry
    // Different metrics have different weights. We use this to limit the number of metrics
    // that we store in memory.
    // We adjust the type here to add the `unref()` part, as setInterval can technically return a number of a NodeJS.Timer.
    // SDKs are required to shift the flush interval by random() * rollup_in_seconds.
    // That shift is determined once per startup to create jittering.
    // An SDK is required to perform force flushing ahead of scheduled time if the memory
    // pressure is too high. There is no rule for this other than that SDKs should be tracking
    // abstract aggregation complexity (eg: a counter only carries a single float, whereas a
    // distribution is a float per emission).
    //
    // Force flush is used on either shutdown, flush() or when we exceed the max weight.
    constructor(_client) {
      this._client = _client;
      this._buckets = /* @__PURE__ */ new Map();
      this._bucketsTotalWeight = 0;
      this._interval = setInterval(() => this._flush(), DEFAULT_FLUSH_INTERVAL);
      if (this._interval.unref) {
        this._interval.unref();
      }
      this._flushShift = Math.floor(Math.random() * DEFAULT_FLUSH_INTERVAL / 1e3);
      this._forceFlush = false;
    }
    /**
     * @inheritDoc
     */
    add(metricType, unsanitizedName, value, unsanitizedUnit = "none", unsanitizedTags = {}, maybeFloatTimestamp = timestampInSeconds()) {
      const timestamp = Math.floor(maybeFloatTimestamp);
      const name2 = sanitizeMetricKey(unsanitizedName);
      const tags = sanitizeTags(unsanitizedTags);
      const unit = sanitizeUnit(unsanitizedUnit);
      const bucketKey = getBucketKey(metricType, name2, unit, tags);
      let bucketItem = this._buckets.get(bucketKey);
      const previousWeight = bucketItem && metricType === SET_METRIC_TYPE ? bucketItem.metric.weight : 0;
      if (bucketItem) {
        bucketItem.metric.add(value);
        if (bucketItem.timestamp < timestamp) {
          bucketItem.timestamp = timestamp;
        }
      } else {
        bucketItem = {
          // @ts-expect-error we don't need to narrow down the type of value here, saves bundle size.
          metric: new METRIC_MAP[metricType](value),
          timestamp,
          metricType,
          name: name2,
          unit,
          tags
        };
        this._buckets.set(bucketKey, bucketItem);
      }
      const val = typeof value === "string" ? bucketItem.metric.weight - previousWeight : value;
      updateMetricSummaryOnActiveSpan(metricType, name2, val, unit, unsanitizedTags, bucketKey);
      this._bucketsTotalWeight += bucketItem.metric.weight;
      if (this._bucketsTotalWeight >= MAX_WEIGHT) {
        this.flush();
      }
    }
    /**
     * Flushes the current metrics to the transport via the transport.
     */
    flush() {
      this._forceFlush = true;
      this._flush();
    }
    /**
     * Shuts down metrics aggregator and clears all metrics.
     */
    close() {
      this._forceFlush = true;
      clearInterval(this._interval);
      this._flush();
    }
    /**
     * Flushes the buckets according to the internal state of the aggregator.
     * If it is a force flush, which happens on shutdown, it will flush all buckets.
     * Otherwise, it will only flush buckets that are older than the flush interval,
     * and according to the flush shift.
     *
     * This function mutates `_forceFlush` and `_bucketsTotalWeight` properties.
     */
    _flush() {
      if (this._forceFlush) {
        this._forceFlush = false;
        this._bucketsTotalWeight = 0;
        this._captureMetrics(this._buckets);
        this._buckets.clear();
        return;
      }
      const cutoffSeconds = Math.floor(timestampInSeconds()) - DEFAULT_FLUSH_INTERVAL / 1e3 - this._flushShift;
      const flushedBuckets = /* @__PURE__ */ new Map();
      for (const [key, bucket] of this._buckets) {
        if (bucket.timestamp <= cutoffSeconds) {
          flushedBuckets.set(key, bucket);
          this._bucketsTotalWeight -= bucket.metric.weight;
        }
      }
      for (const [key] of flushedBuckets) {
        this._buckets.delete(key);
      }
      this._captureMetrics(flushedBuckets);
    }
    /**
     * Only captures a subset of the buckets passed to this function.
     * @param flushedBuckets
     */
    _captureMetrics(flushedBuckets) {
      if (flushedBuckets.size > 0) {
        const buckets = Array.from(flushedBuckets).map(([, bucketItem]) => bucketItem);
        captureAggregateMetrics(this._client, buckets);
      }
    }
  }
  function increment(name2, value = 1, data2) {
    metrics$1.increment(MetricsAggregator, name2, value, data2);
  }
  function distribution(name2, value, data2) {
    metrics$1.distribution(MetricsAggregator, name2, value, data2);
  }
  function set(name2, value, data2) {
    metrics$1.set(MetricsAggregator, name2, value, data2);
  }
  function gauge(name2, value, data2) {
    metrics$1.gauge(MetricsAggregator, name2, value, data2);
  }
  function timing(name2, value, unit = "second", data2) {
    return metrics$1.timing(MetricsAggregator, name2, value, unit, data2);
  }
  function getMetricsAggregatorForClient(client) {
    return metrics$1.getMetricsAggregatorForClient(client, MetricsAggregator);
  }
  const metricsDefault = {
    increment,
    distribution,
    set,
    gauge,
    timing,
    /**
     * @ignore This is for internal use only.
     */
    getMetricsAggregatorForClient
  };
  function getBreadcrumbLogLevelFromHttpStatusCode(statusCode) {
    if (statusCode === void 0) {
      return void 0;
    } else if (statusCode >= 400 && statusCode < 500) {
      return "warning";
    } else if (statusCode >= 500) {
      return "error";
    } else {
      return void 0;
    }
  }
  function filenameIsInApp(filename, isNative = false) {
    const isInternal = isNative || filename && // It's not internal if it's an absolute linux path
    !filename.startsWith("/") && // It's not internal if it's an absolute windows path
    !filename.match(/^[A-Z]:/) && // It's not internal if the path is starting with a dot
    !filename.startsWith(".") && // It's not internal if the frame has a protocol. In node, this is usually the case if the file got pre-processed with a bundler like webpack
    !filename.match(/^[a-zA-Z]([a-zA-Z0-9.\-+])*:\/\//);
    return !isInternal && filename !== void 0 && !filename.includes("node_modules/");
  }
  function node$2(getModule) {
    const FILENAME_MATCH = /^\s*[-]{4,}$/;
    const FULL_MATCH = /at (?:async )?(?:(.+?)\s+\()?(?:(.+):(\d+):(\d+)?|([^)]+))\)?/;
    return (line) => {
      const lineMatch = line.match(FULL_MATCH);
      if (lineMatch) {
        let object2;
        let method2;
        let functionName;
        let typeName;
        let methodName;
        if (lineMatch[1]) {
          functionName = lineMatch[1];
          let methodStart = functionName.lastIndexOf(".");
          if (functionName[methodStart - 1] === ".") {
            methodStart--;
          }
          if (methodStart > 0) {
            object2 = functionName.slice(0, methodStart);
            method2 = functionName.slice(methodStart + 1);
            const objectEnd = object2.indexOf(".Module");
            if (objectEnd > 0) {
              functionName = functionName.slice(objectEnd + 1);
              object2 = object2.slice(0, objectEnd);
            }
          }
          typeName = void 0;
        }
        if (method2) {
          typeName = object2;
          methodName = method2;
        }
        if (method2 === "<anonymous>") {
          methodName = void 0;
          functionName = void 0;
        }
        if (functionName === void 0) {
          methodName = methodName || UNKNOWN_FUNCTION;
          functionName = typeName ? `${typeName}.${methodName}` : methodName;
        }
        let filename = lineMatch[2] && lineMatch[2].startsWith("file://") ? lineMatch[2].slice(7) : lineMatch[2];
        const isNative = lineMatch[5] === "native";
        if (filename && filename.match(/\/[A-Z]:/)) {
          filename = filename.slice(1);
        }
        if (!filename && lineMatch[5] && !isNative) {
          filename = lineMatch[5];
        }
        return {
          filename,
          module: getModule ? getModule(filename) : void 0,
          function: functionName,
          lineno: _parseIntOrUndefined(lineMatch[3]),
          colno: _parseIntOrUndefined(lineMatch[4]),
          in_app: filenameIsInApp(filename || "", isNative)
        };
      }
      if (line.match(FILENAME_MATCH)) {
        return {
          filename: line
        };
      }
      return void 0;
    };
  }
  function nodeStackLineParser(getModule) {
    return [90, node$2(getModule)];
  }
  function _parseIntOrUndefined(input) {
    return parseInt(input || "", 10) || void 0;
  }
  function watchdogTimer(createTimer, pollInterval, anrThreshold, callback) {
    const timer = createTimer();
    let triggered = false;
    let enabled = true;
    setInterval(() => {
      const diffMs = timer.getTimeMs();
      if (triggered === false && diffMs > pollInterval + anrThreshold) {
        triggered = true;
        if (enabled) {
          callback();
        }
      }
      if (diffMs < pollInterval + anrThreshold) {
        triggered = false;
      }
    }, 20);
    return {
      poll: () => {
        timer.reset();
      },
      enabled: (state) => {
        enabled = state;
      }
    };
  }
  function callFrameToStackFrame(frame, url2, getModuleFromFilename) {
    const filename = url2 ? url2.replace(/^file:\/\//, "") : void 0;
    const colno = frame.location.columnNumber ? frame.location.columnNumber + 1 : void 0;
    const lineno = frame.location.lineNumber ? frame.location.lineNumber + 1 : void 0;
    return dropUndefinedKeys({
      filename,
      module: getModuleFromFilename(filename),
      function: frame.functionName || UNKNOWN_FUNCTION,
      colno,
      lineno,
      in_app: filename ? filenameIsInApp(filename) : void 0
    });
  }
  class LRUMap {
    constructor(_maxSize) {
      this._maxSize = _maxSize;
      this._cache = /* @__PURE__ */ new Map();
    }
    /** Get the current size of the cache */
    get size() {
      return this._cache.size;
    }
    /** Get an entry or undefined if it was not in the cache. Re-inserts to update the recently used order */
    get(key) {
      const value = this._cache.get(key);
      if (value === void 0) {
        return void 0;
      }
      this._cache.delete(key);
      this._cache.set(key, value);
      return value;
    }
    /** Insert an entry and evict an older entry if we've reached maxSize */
    set(key, value) {
      if (this._cache.size >= this._maxSize) {
        this._cache.delete(this._cache.keys().next().value);
      }
      this._cache.set(key, value);
    }
    /** Remove an entry and return the entry if it was in the cache */
    remove(key) {
      const value = this._cache.get(key);
      if (value) {
        this._cache.delete(key);
      }
      return value;
    }
    /** Clear all entries */
    clear() {
      this._cache.clear();
    }
    /** Get all the keys */
    keys() {
      return Array.from(this._cache.keys());
    }
    /** Get all the values */
    values() {
      const values = [];
      this._cache.forEach((value) => values.push(value));
      return values;
    }
  }
  function _nullishCoalesce(lhs, rhsFn) {
    return lhs != null ? lhs : rhsFn();
  }
  function _optionalChain(ops) {
    let lastAccessLHS = void 0;
    let value = ops[0];
    let i2 = 1;
    while (i2 < ops.length) {
      const op = ops[i2];
      const fn = ops[i2 + 1];
      i2 += 2;
      if ((op === "optionalAccess" || op === "optionalCall") && value == null) {
        return;
      }
      if (op === "access" || op === "optionalAccess") {
        lastAccessLHS = value;
        value = fn(value);
      } else if (op === "call" || op === "optionalCall") {
        value = fn((...args2) => value.call(lastAccessLHS, ...args2));
        lastAccessLHS = void 0;
      }
    }
    return value;
  }
  var _globalThis$3 = typeof globalThis === "object" ? globalThis : global;
  var VERSION$2 = "1.9.0";
  var re$4 = /^(\d+)\.(\d+)\.(\d+)(-(.+))?$/;
  function _makeCompatibilityCheck(ownVersion) {
    var acceptedVersions = /* @__PURE__ */ new Set([ownVersion]);
    var rejectedVersions = /* @__PURE__ */ new Set();
    var myVersionMatch = ownVersion.match(re$4);
    if (!myVersionMatch) {
      return function() {
        return false;
      };
    }
    var ownVersionParsed = {
      major: +myVersionMatch[1],
      minor: +myVersionMatch[2],
      patch: +myVersionMatch[3],
      prerelease: myVersionMatch[4]
    };
    if (ownVersionParsed.prerelease != null) {
      return function isExactmatch(globalVersion) {
        return globalVersion === ownVersion;
      };
    }
    function _reject(v2) {
      rejectedVersions.add(v2);
      return false;
    }
    function _accept(v2) {
      acceptedVersions.add(v2);
      return true;
    }
    return function isCompatible2(globalVersion) {
      if (acceptedVersions.has(globalVersion)) {
        return true;
      }
      if (rejectedVersions.has(globalVersion)) {
        return false;
      }
      var globalVersionMatch = globalVersion.match(re$4);
      if (!globalVersionMatch) {
        return _reject(globalVersion);
      }
      var globalVersionParsed = {
        major: +globalVersionMatch[1],
        minor: +globalVersionMatch[2],
        patch: +globalVersionMatch[3],
        prerelease: globalVersionMatch[4]
      };
      if (globalVersionParsed.prerelease != null) {
        return _reject(globalVersion);
      }
      if (ownVersionParsed.major !== globalVersionParsed.major) {
        return _reject(globalVersion);
      }
      if (ownVersionParsed.major === 0) {
        if (ownVersionParsed.minor === globalVersionParsed.minor && ownVersionParsed.patch <= globalVersionParsed.patch) {
          return _accept(globalVersion);
        }
        return _reject(globalVersion);
      }
      if (ownVersionParsed.minor <= globalVersionParsed.minor) {
        return _accept(globalVersion);
      }
      return _reject(globalVersion);
    };
  }
  var isCompatible = _makeCompatibilityCheck(VERSION$2);
  var major$2 = VERSION$2.split(".")[0];
  var GLOBAL_OPENTELEMETRY_API_KEY = Symbol.for("opentelemetry.js.api." + major$2);
  var _global$3 = _globalThis$3;
  function registerGlobal(type2, instance, diag2, allowOverride) {
    var _a3;
    if (allowOverride === void 0) {
      allowOverride = false;
    }
    var api = _global$3[GLOBAL_OPENTELEMETRY_API_KEY] = (_a3 = _global$3[GLOBAL_OPENTELEMETRY_API_KEY]) !== null && _a3 !== void 0 ? _a3 : {
      version: VERSION$2
    };
    if (!allowOverride && api[type2]) {
      var err = new Error("@opentelemetry/api: Attempted duplicate registration of API: " + type2);
      diag2.error(err.stack || err.message);
      return false;
    }
    if (api.version !== VERSION$2) {
      var err = new Error("@opentelemetry/api: Registration of version v" + api.version + " for " + type2 + " does not match previously registered API v" + VERSION$2);
      diag2.error(err.stack || err.message);
      return false;
    }
    api[type2] = instance;
    diag2.debug("@opentelemetry/api: Registered a global for " + type2 + " v" + VERSION$2 + ".");
    return true;
  }
  function getGlobal(type2) {
    var _a3, _b2;
    var globalVersion = (_a3 = _global$3[GLOBAL_OPENTELEMETRY_API_KEY]) === null || _a3 === void 0 ? void 0 : _a3.version;
    if (!globalVersion || !isCompatible(globalVersion)) {
      return;
    }
    return (_b2 = _global$3[GLOBAL_OPENTELEMETRY_API_KEY]) === null || _b2 === void 0 ? void 0 : _b2[type2];
  }
  function unregisterGlobal(type2, diag2) {
    diag2.debug("@opentelemetry/api: Unregistering a global for " + type2 + " v" + VERSION$2 + ".");
    var api = _global$3[GLOBAL_OPENTELEMETRY_API_KEY];
    if (api) {
      delete api[type2];
    }
  }
  var __read$b = function(o2, n2) {
    var m2 = typeof Symbol === "function" && o2[Symbol.iterator];
    if (!m2) return o2;
    var i2 = m2.call(o2), r2, ar = [], e2;
    try {
      while ((n2 === void 0 || n2-- > 0) && !(r2 = i2.next()).done) ar.push(r2.value);
    } catch (error2) {
      e2 = { error: error2 };
    } finally {
      try {
        if (r2 && !r2.done && (m2 = i2["return"])) m2.call(i2);
      } finally {
        if (e2) throw e2.error;
      }
    }
    return ar;
  };
  var __spreadArray$7 = function(to, from, pack) {
    if (pack || arguments.length === 2) for (var i2 = 0, l2 = from.length, ar; i2 < l2; i2++) {
      if (ar || !(i2 in from)) {
        if (!ar) ar = Array.prototype.slice.call(from, 0, i2);
        ar[i2] = from[i2];
      }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
  };
  var DiagComponentLogger = (
    /** @class */
    function() {
      function DiagComponentLogger2(props) {
        this._namespace = props.namespace || "DiagComponentLogger";
      }
      DiagComponentLogger2.prototype.debug = function() {
        var args2 = [];
        for (var _i = 0; _i < arguments.length; _i++) {
          args2[_i] = arguments[_i];
        }
        return logProxy("debug", this._namespace, args2);
      };
      DiagComponentLogger2.prototype.error = function() {
        var args2 = [];
        for (var _i = 0; _i < arguments.length; _i++) {
          args2[_i] = arguments[_i];
        }
        return logProxy("error", this._namespace, args2);
      };
      DiagComponentLogger2.prototype.info = function() {
        var args2 = [];
        for (var _i = 0; _i < arguments.length; _i++) {
          args2[_i] = arguments[_i];
        }
        return logProxy("info", this._namespace, args2);
      };
      DiagComponentLogger2.prototype.warn = function() {
        var args2 = [];
        for (var _i = 0; _i < arguments.length; _i++) {
          args2[_i] = arguments[_i];
        }
        return logProxy("warn", this._namespace, args2);
      };
      DiagComponentLogger2.prototype.verbose = function() {
        var args2 = [];
        for (var _i = 0; _i < arguments.length; _i++) {
          args2[_i] = arguments[_i];
        }
        return logProxy("verbose", this._namespace, args2);
      };
      return DiagComponentLogger2;
    }()
  );
  function logProxy(funcName, namespace2, args2) {
    var logger2 = getGlobal("diag");
    if (!logger2) {
      return;
    }
    args2.unshift(namespace2);
    return logger2[funcName].apply(logger2, __spreadArray$7([], __read$b(args2), false));
  }
  var DiagLogLevel;
  (function(DiagLogLevel2) {
    DiagLogLevel2[DiagLogLevel2["NONE"] = 0] = "NONE";
    DiagLogLevel2[DiagLogLevel2["ERROR"] = 30] = "ERROR";
    DiagLogLevel2[DiagLogLevel2["WARN"] = 50] = "WARN";
    DiagLogLevel2[DiagLogLevel2["INFO"] = 60] = "INFO";
    DiagLogLevel2[DiagLogLevel2["DEBUG"] = 70] = "DEBUG";
    DiagLogLevel2[DiagLogLevel2["VERBOSE"] = 80] = "VERBOSE";
    DiagLogLevel2[DiagLogLevel2["ALL"] = 9999] = "ALL";
  })(DiagLogLevel || (DiagLogLevel = {}));
  function createLogLevelDiagLogger(maxLevel, logger2) {
    if (maxLevel < DiagLogLevel.NONE) {
      maxLevel = DiagLogLevel.NONE;
    } else if (maxLevel > DiagLogLevel.ALL) {
      maxLevel = DiagLogLevel.ALL;
    }
    logger2 = logger2 || {};
    function _filterFunc(funcName, theLevel) {
      var theFunc = logger2[funcName];
      if (typeof theFunc === "function" && maxLevel >= theLevel) {
        return theFunc.bind(logger2);
      }
      return function() {
      };
    }
    return {
      error: _filterFunc("error", DiagLogLevel.ERROR),
      warn: _filterFunc("warn", DiagLogLevel.WARN),
      info: _filterFunc("info", DiagLogLevel.INFO),
      debug: _filterFunc("debug", DiagLogLevel.DEBUG),
      verbose: _filterFunc("verbose", DiagLogLevel.VERBOSE)
    };
  }
  var __read$a = function(o2, n2) {
    var m2 = typeof Symbol === "function" && o2[Symbol.iterator];
    if (!m2) return o2;
    var i2 = m2.call(o2), r2, ar = [], e2;
    try {
      while ((n2 === void 0 || n2-- > 0) && !(r2 = i2.next()).done) ar.push(r2.value);
    } catch (error2) {
      e2 = { error: error2 };
    } finally {
      try {
        if (r2 && !r2.done && (m2 = i2["return"])) m2.call(i2);
      } finally {
        if (e2) throw e2.error;
      }
    }
    return ar;
  };
  var __spreadArray$6 = function(to, from, pack) {
    if (pack || arguments.length === 2) for (var i2 = 0, l2 = from.length, ar; i2 < l2; i2++) {
      if (ar || !(i2 in from)) {
        if (!ar) ar = Array.prototype.slice.call(from, 0, i2);
        ar[i2] = from[i2];
      }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
  };
  var API_NAME$4 = "diag";
  var DiagAPI = (
    /** @class */
    function() {
      function DiagAPI2() {
        function _logProxy(funcName) {
          return function() {
            var args2 = [];
            for (var _i = 0; _i < arguments.length; _i++) {
              args2[_i] = arguments[_i];
            }
            var logger2 = getGlobal("diag");
            if (!logger2)
              return;
            return logger2[funcName].apply(logger2, __spreadArray$6([], __read$a(args2), false));
          };
        }
        var self2 = this;
        var setLogger = function(logger2, optionsOrLogLevel) {
          var _a3, _b2, _c2;
          if (optionsOrLogLevel === void 0) {
            optionsOrLogLevel = { logLevel: DiagLogLevel.INFO };
          }
          if (logger2 === self2) {
            var err = new Error("Cannot use diag as the logger for itself. Please use a DiagLogger implementation like ConsoleDiagLogger or a custom implementation");
            self2.error((_a3 = err.stack) !== null && _a3 !== void 0 ? _a3 : err.message);
            return false;
          }
          if (typeof optionsOrLogLevel === "number") {
            optionsOrLogLevel = {
              logLevel: optionsOrLogLevel
            };
          }
          var oldLogger = getGlobal("diag");
          var newLogger = createLogLevelDiagLogger((_b2 = optionsOrLogLevel.logLevel) !== null && _b2 !== void 0 ? _b2 : DiagLogLevel.INFO, logger2);
          if (oldLogger && !optionsOrLogLevel.suppressOverrideMessage) {
            var stack = (_c2 = new Error().stack) !== null && _c2 !== void 0 ? _c2 : "<failed to generate stacktrace>";
            oldLogger.warn("Current logger will be overwritten from " + stack);
            newLogger.warn("Current logger will overwrite one already registered from " + stack);
          }
          return registerGlobal("diag", newLogger, self2, true);
        };
        self2.setLogger = setLogger;
        self2.disable = function() {
          unregisterGlobal(API_NAME$4, self2);
        };
        self2.createComponentLogger = function(options) {
          return new DiagComponentLogger(options);
        };
        self2.verbose = _logProxy("verbose");
        self2.debug = _logProxy("debug");
        self2.info = _logProxy("info");
        self2.warn = _logProxy("warn");
        self2.error = _logProxy("error");
      }
      DiagAPI2.instance = function() {
        if (!this._instance) {
          this._instance = new DiagAPI2();
        }
        return this._instance;
      };
      return DiagAPI2;
    }()
  );
  var __read$9 = function(o2, n2) {
    var m2 = typeof Symbol === "function" && o2[Symbol.iterator];
    if (!m2) return o2;
    var i2 = m2.call(o2), r2, ar = [], e2;
    try {
      while ((n2 === void 0 || n2-- > 0) && !(r2 = i2.next()).done) ar.push(r2.value);
    } catch (error2) {
      e2 = { error: error2 };
    } finally {
      try {
        if (r2 && !r2.done && (m2 = i2["return"])) m2.call(i2);
      } finally {
        if (e2) throw e2.error;
      }
    }
    return ar;
  };
  var __values$8 = function(o2) {
    var s2 = typeof Symbol === "function" && Symbol.iterator, m2 = s2 && o2[s2], i2 = 0;
    if (m2) return m2.call(o2);
    if (o2 && typeof o2.length === "number") return {
      next: function() {
        if (o2 && i2 >= o2.length) o2 = void 0;
        return { value: o2 && o2[i2++], done: !o2 };
      }
    };
    throw new TypeError(s2 ? "Object is not iterable." : "Symbol.iterator is not defined.");
  };
  var BaggageImpl = (
    /** @class */
    function() {
      function BaggageImpl2(entries) {
        this._entries = entries ? new Map(entries) : /* @__PURE__ */ new Map();
      }
      BaggageImpl2.prototype.getEntry = function(key) {
        var entry = this._entries.get(key);
        if (!entry) {
          return void 0;
        }
        return Object.assign({}, entry);
      };
      BaggageImpl2.prototype.getAllEntries = function() {
        return Array.from(this._entries.entries()).map(function(_a3) {
          var _b2 = __read$9(_a3, 2), k2 = _b2[0], v2 = _b2[1];
          return [k2, v2];
        });
      };
      BaggageImpl2.prototype.setEntry = function(key, entry) {
        var newBaggage = new BaggageImpl2(this._entries);
        newBaggage._entries.set(key, entry);
        return newBaggage;
      };
      BaggageImpl2.prototype.removeEntry = function(key) {
        var newBaggage = new BaggageImpl2(this._entries);
        newBaggage._entries.delete(key);
        return newBaggage;
      };
      BaggageImpl2.prototype.removeEntries = function() {
        var e_1, _a3;
        var keys2 = [];
        for (var _i = 0; _i < arguments.length; _i++) {
          keys2[_i] = arguments[_i];
        }
        var newBaggage = new BaggageImpl2(this._entries);
        try {
          for (var keys_1 = __values$8(keys2), keys_1_1 = keys_1.next(); !keys_1_1.done; keys_1_1 = keys_1.next()) {
            var key = keys_1_1.value;
            newBaggage._entries.delete(key);
          }
        } catch (e_1_1) {
          e_1 = { error: e_1_1 };
        } finally {
          try {
            if (keys_1_1 && !keys_1_1.done && (_a3 = keys_1.return)) _a3.call(keys_1);
          } finally {
            if (e_1) throw e_1.error;
          }
        }
        return newBaggage;
      };
      BaggageImpl2.prototype.clear = function() {
        return new BaggageImpl2();
      };
      return BaggageImpl2;
    }()
  );
  var baggageEntryMetadataSymbol = Symbol("BaggageEntryMetadata");
  var diag$1 = DiagAPI.instance();
  function createBaggage(entries) {
    if (entries === void 0) {
      entries = {};
    }
    return new BaggageImpl(new Map(Object.entries(entries)));
  }
  function baggageEntryMetadataFromString(str) {
    if (typeof str !== "string") {
      diag$1.error("Cannot create baggage metadata from unknown type: " + typeof str);
      str = "";
    }
    return {
      __TYPE__: baggageEntryMetadataSymbol,
      toString: function() {
        return str;
      }
    };
  }
  function createContextKey(description2) {
    return Symbol.for(description2);
  }
  var BaseContext = (
    /** @class */
    /* @__PURE__ */ function() {
      function BaseContext2(parentContext) {
        var self2 = this;
        self2._currentContext = parentContext ? new Map(parentContext) : /* @__PURE__ */ new Map();
        self2.getValue = function(key) {
          return self2._currentContext.get(key);
        };
        self2.setValue = function(key, value) {
          var context2 = new BaseContext2(self2._currentContext);
          context2._currentContext.set(key, value);
          return context2;
        };
        self2.deleteValue = function(key) {
          var context2 = new BaseContext2(self2._currentContext);
          context2._currentContext.delete(key);
          return context2;
        };
      }
      return BaseContext2;
    }()
  );
  var ROOT_CONTEXT = new BaseContext();
  var consoleMap = [
    { n: "error", c: "error" },
    { n: "warn", c: "warn" },
    { n: "info", c: "info" },
    { n: "debug", c: "debug" },
    { n: "verbose", c: "trace" }
  ];
  var DiagConsoleLogger = (
    /** @class */
    /* @__PURE__ */ function() {
      function DiagConsoleLogger2() {
        function _consoleFunc(funcName) {
          return function() {
            var args2 = [];
            for (var _i = 0; _i < arguments.length; _i++) {
              args2[_i] = arguments[_i];
            }
            if (console) {
              var theFunc = console[funcName];
              if (typeof theFunc !== "function") {
                theFunc = console.log;
              }
              if (typeof theFunc === "function") {
                return theFunc.apply(console, args2);
              }
            }
          };
        }
        for (var i2 = 0; i2 < consoleMap.length; i2++) {
          this[consoleMap[i2].n] = _consoleFunc(consoleMap[i2].c);
        }
      }
      return DiagConsoleLogger2;
    }()
  );
  var __extends$3 = /* @__PURE__ */ function() {
    var extendStatics = function(d2, b2) {
      extendStatics = Object.setPrototypeOf || { __proto__: [] } instanceof Array && function(d3, b3) {
        d3.__proto__ = b3;
      } || function(d3, b3) {
        for (var p2 in b3) if (Object.prototype.hasOwnProperty.call(b3, p2)) d3[p2] = b3[p2];
      };
      return extendStatics(d2, b2);
    };
    return function(d2, b2) {
      if (typeof b2 !== "function" && b2 !== null)
        throw new TypeError("Class extends value " + String(b2) + " is not a constructor or null");
      extendStatics(d2, b2);
      function __() {
        this.constructor = d2;
      }
      d2.prototype = b2 === null ? Object.create(b2) : (__.prototype = b2.prototype, new __());
    };
  }();
  var NoopMeter = (
    /** @class */
    function() {
      function NoopMeter2() {
      }
      NoopMeter2.prototype.createGauge = function(_name, _options) {
        return NOOP_GAUGE_METRIC;
      };
      NoopMeter2.prototype.createHistogram = function(_name, _options) {
        return NOOP_HISTOGRAM_METRIC;
      };
      NoopMeter2.prototype.createCounter = function(_name, _options) {
        return NOOP_COUNTER_METRIC;
      };
      NoopMeter2.prototype.createUpDownCounter = function(_name, _options) {
        return NOOP_UP_DOWN_COUNTER_METRIC;
      };
      NoopMeter2.prototype.createObservableGauge = function(_name, _options) {
        return NOOP_OBSERVABLE_GAUGE_METRIC;
      };
      NoopMeter2.prototype.createObservableCounter = function(_name, _options) {
        return NOOP_OBSERVABLE_COUNTER_METRIC;
      };
      NoopMeter2.prototype.createObservableUpDownCounter = function(_name, _options) {
        return NOOP_OBSERVABLE_UP_DOWN_COUNTER_METRIC;
      };
      NoopMeter2.prototype.addBatchObservableCallback = function(_callback, _observables) {
      };
      NoopMeter2.prototype.removeBatchObservableCallback = function(_callback) {
      };
      return NoopMeter2;
    }()
  );
  var NoopMetric = (
    /** @class */
    /* @__PURE__ */ function() {
      function NoopMetric2() {
      }
      return NoopMetric2;
    }()
  );
  var NoopCounterMetric = (
    /** @class */
    function(_super) {
      __extends$3(NoopCounterMetric2, _super);
      function NoopCounterMetric2() {
        return _super !== null && _super.apply(this, arguments) || this;
      }
      NoopCounterMetric2.prototype.add = function(_value, _attributes) {
      };
      return NoopCounterMetric2;
    }(NoopMetric)
  );
  var NoopUpDownCounterMetric = (
    /** @class */
    function(_super) {
      __extends$3(NoopUpDownCounterMetric2, _super);
      function NoopUpDownCounterMetric2() {
        return _super !== null && _super.apply(this, arguments) || this;
      }
      NoopUpDownCounterMetric2.prototype.add = function(_value, _attributes) {
      };
      return NoopUpDownCounterMetric2;
    }(NoopMetric)
  );
  var NoopGaugeMetric = (
    /** @class */
    function(_super) {
      __extends$3(NoopGaugeMetric2, _super);
      function NoopGaugeMetric2() {
        return _super !== null && _super.apply(this, arguments) || this;
      }
      NoopGaugeMetric2.prototype.record = function(_value, _attributes) {
      };
      return NoopGaugeMetric2;
    }(NoopMetric)
  );
  var NoopHistogramMetric = (
    /** @class */
    function(_super) {
      __extends$3(NoopHistogramMetric2, _super);
      function NoopHistogramMetric2() {
        return _super !== null && _super.apply(this, arguments) || this;
      }
      NoopHistogramMetric2.prototype.record = function(_value, _attributes) {
      };
      return NoopHistogramMetric2;
    }(NoopMetric)
  );
  var NoopObservableMetric = (
    /** @class */
    function() {
      function NoopObservableMetric2() {
      }
      NoopObservableMetric2.prototype.addCallback = function(_callback) {
      };
      NoopObservableMetric2.prototype.removeCallback = function(_callback) {
      };
      return NoopObservableMetric2;
    }()
  );
  var NoopObservableCounterMetric = (
    /** @class */
    function(_super) {
      __extends$3(NoopObservableCounterMetric2, _super);
      function NoopObservableCounterMetric2() {
        return _super !== null && _super.apply(this, arguments) || this;
      }
      return NoopObservableCounterMetric2;
    }(NoopObservableMetric)
  );
  var NoopObservableGaugeMetric = (
    /** @class */
    function(_super) {
      __extends$3(NoopObservableGaugeMetric2, _super);
      function NoopObservableGaugeMetric2() {
        return _super !== null && _super.apply(this, arguments) || this;
      }
      return NoopObservableGaugeMetric2;
    }(NoopObservableMetric)
  );
  var NoopObservableUpDownCounterMetric = (
    /** @class */
    function(_super) {
      __extends$3(NoopObservableUpDownCounterMetric2, _super);
      function NoopObservableUpDownCounterMetric2() {
        return _super !== null && _super.apply(this, arguments) || this;
      }
      return NoopObservableUpDownCounterMetric2;
    }(NoopObservableMetric)
  );
  var NOOP_METER = new NoopMeter();
  var NOOP_COUNTER_METRIC = new NoopCounterMetric();
  var NOOP_GAUGE_METRIC = new NoopGaugeMetric();
  var NOOP_HISTOGRAM_METRIC = new NoopHistogramMetric();
  var NOOP_UP_DOWN_COUNTER_METRIC = new NoopUpDownCounterMetric();
  var NOOP_OBSERVABLE_COUNTER_METRIC = new NoopObservableCounterMetric();
  var NOOP_OBSERVABLE_GAUGE_METRIC = new NoopObservableGaugeMetric();
  var NOOP_OBSERVABLE_UP_DOWN_COUNTER_METRIC = new NoopObservableUpDownCounterMetric();
  function createNoopMeter() {
    return NOOP_METER;
  }
  var ValueType;
  (function(ValueType2) {
    ValueType2[ValueType2["INT"] = 0] = "INT";
    ValueType2[ValueType2["DOUBLE"] = 1] = "DOUBLE";
  })(ValueType || (ValueType = {}));
  var defaultTextMapGetter = {
    get: function(carrier, key) {
      if (carrier == null) {
        return void 0;
      }
      return carrier[key];
    },
    keys: function(carrier) {
      if (carrier == null) {
        return [];
      }
      return Object.keys(carrier);
    }
  };
  var defaultTextMapSetter = {
    set: function(carrier, key, value) {
      if (carrier == null) {
        return;
      }
      carrier[key] = value;
    }
  };
  var __read$8 = function(o2, n2) {
    var m2 = typeof Symbol === "function" && o2[Symbol.iterator];
    if (!m2) return o2;
    var i2 = m2.call(o2), r2, ar = [], e2;
    try {
      while ((n2 === void 0 || n2-- > 0) && !(r2 = i2.next()).done) ar.push(r2.value);
    } catch (error2) {
      e2 = { error: error2 };
    } finally {
      try {
        if (r2 && !r2.done && (m2 = i2["return"])) m2.call(i2);
      } finally {
        if (e2) throw e2.error;
      }
    }
    return ar;
  };
  var __spreadArray$5 = function(to, from, pack) {
    if (pack || arguments.length === 2) for (var i2 = 0, l2 = from.length, ar; i2 < l2; i2++) {
      if (ar || !(i2 in from)) {
        if (!ar) ar = Array.prototype.slice.call(from, 0, i2);
        ar[i2] = from[i2];
      }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
  };
  var NoopContextManager = (
    /** @class */
    function() {
      function NoopContextManager2() {
      }
      NoopContextManager2.prototype.active = function() {
        return ROOT_CONTEXT;
      };
      NoopContextManager2.prototype.with = function(_context, fn, thisArg) {
        var args2 = [];
        for (var _i = 3; _i < arguments.length; _i++) {
          args2[_i - 3] = arguments[_i];
        }
        return fn.call.apply(fn, __spreadArray$5([thisArg], __read$8(args2), false));
      };
      NoopContextManager2.prototype.bind = function(_context, target) {
        return target;
      };
      NoopContextManager2.prototype.enable = function() {
        return this;
      };
      NoopContextManager2.prototype.disable = function() {
        return this;
      };
      return NoopContextManager2;
    }()
  );
  var __read$7 = function(o2, n2) {
    var m2 = typeof Symbol === "function" && o2[Symbol.iterator];
    if (!m2) return o2;
    var i2 = m2.call(o2), r2, ar = [], e2;
    try {
      while ((n2 === void 0 || n2-- > 0) && !(r2 = i2.next()).done) ar.push(r2.value);
    } catch (error2) {
      e2 = { error: error2 };
    } finally {
      try {
        if (r2 && !r2.done && (m2 = i2["return"])) m2.call(i2);
      } finally {
        if (e2) throw e2.error;
      }
    }
    return ar;
  };
  var __spreadArray$4 = function(to, from, pack) {
    if (pack || arguments.length === 2) for (var i2 = 0, l2 = from.length, ar; i2 < l2; i2++) {
      if (ar || !(i2 in from)) {
        if (!ar) ar = Array.prototype.slice.call(from, 0, i2);
        ar[i2] = from[i2];
      }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
  };
  var API_NAME$3 = "context";
  var NOOP_CONTEXT_MANAGER = new NoopContextManager();
  var ContextAPI = (
    /** @class */
    function() {
      function ContextAPI2() {
      }
      ContextAPI2.getInstance = function() {
        if (!this._instance) {
          this._instance = new ContextAPI2();
        }
        return this._instance;
      };
      ContextAPI2.prototype.setGlobalContextManager = function(contextManager) {
        return registerGlobal(API_NAME$3, contextManager, DiagAPI.instance());
      };
      ContextAPI2.prototype.active = function() {
        return this._getContextManager().active();
      };
      ContextAPI2.prototype.with = function(context2, fn, thisArg) {
        var _a3;
        var args2 = [];
        for (var _i = 3; _i < arguments.length; _i++) {
          args2[_i - 3] = arguments[_i];
        }
        return (_a3 = this._getContextManager()).with.apply(_a3, __spreadArray$4([context2, fn, thisArg], __read$7(args2), false));
      };
      ContextAPI2.prototype.bind = function(context2, target) {
        return this._getContextManager().bind(context2, target);
      };
      ContextAPI2.prototype._getContextManager = function() {
        return getGlobal(API_NAME$3) || NOOP_CONTEXT_MANAGER;
      };
      ContextAPI2.prototype.disable = function() {
        this._getContextManager().disable();
        unregisterGlobal(API_NAME$3, DiagAPI.instance());
      };
      return ContextAPI2;
    }()
  );
  var TraceFlags;
  (function(TraceFlags2) {
    TraceFlags2[TraceFlags2["NONE"] = 0] = "NONE";
    TraceFlags2[TraceFlags2["SAMPLED"] = 1] = "SAMPLED";
  })(TraceFlags || (TraceFlags = {}));
  var INVALID_SPANID = "0000000000000000";
  var INVALID_TRACEID = "00000000000000000000000000000000";
  var INVALID_SPAN_CONTEXT = {
    traceId: INVALID_TRACEID,
    spanId: INVALID_SPANID,
    traceFlags: TraceFlags.NONE
  };
  var NonRecordingSpan = (
    /** @class */
    function() {
      function NonRecordingSpan2(_spanContext) {
        if (_spanContext === void 0) {
          _spanContext = INVALID_SPAN_CONTEXT;
        }
        this._spanContext = _spanContext;
      }
      NonRecordingSpan2.prototype.spanContext = function() {
        return this._spanContext;
      };
      NonRecordingSpan2.prototype.setAttribute = function(_key, _value) {
        return this;
      };
      NonRecordingSpan2.prototype.setAttributes = function(_attributes) {
        return this;
      };
      NonRecordingSpan2.prototype.addEvent = function(_name, _attributes) {
        return this;
      };
      NonRecordingSpan2.prototype.addLink = function(_link) {
        return this;
      };
      NonRecordingSpan2.prototype.addLinks = function(_links) {
        return this;
      };
      NonRecordingSpan2.prototype.setStatus = function(_status) {
        return this;
      };
      NonRecordingSpan2.prototype.updateName = function(_name) {
        return this;
      };
      NonRecordingSpan2.prototype.end = function(_endTime) {
      };
      NonRecordingSpan2.prototype.isRecording = function() {
        return false;
      };
      NonRecordingSpan2.prototype.recordException = function(_exception, _time) {
      };
      return NonRecordingSpan2;
    }()
  );
  var SPAN_KEY = createContextKey("OpenTelemetry Context Key SPAN");
  function getSpan(context2) {
    return context2.getValue(SPAN_KEY) || void 0;
  }
  function getActiveSpan$1() {
    return getSpan(ContextAPI.getInstance().active());
  }
  function setSpan(context2, span) {
    return context2.setValue(SPAN_KEY, span);
  }
  function deleteSpan(context2) {
    return context2.deleteValue(SPAN_KEY);
  }
  function setSpanContext(context2, spanContext) {
    return setSpan(context2, new NonRecordingSpan(spanContext));
  }
  function getSpanContext(context2) {
    var _a3;
    return (_a3 = getSpan(context2)) === null || _a3 === void 0 ? void 0 : _a3.spanContext();
  }
  var VALID_TRACEID_REGEX = /^([0-9a-f]{32})$/i;
  var VALID_SPANID_REGEX = /^[0-9a-f]{16}$/i;
  function isValidTraceId(traceId) {
    return VALID_TRACEID_REGEX.test(traceId) && traceId !== INVALID_TRACEID;
  }
  function isValidSpanId(spanId) {
    return VALID_SPANID_REGEX.test(spanId) && spanId !== INVALID_SPANID;
  }
  function isSpanContextValid(spanContext) {
    return isValidTraceId(spanContext.traceId) && isValidSpanId(spanContext.spanId);
  }
  function wrapSpanContext(spanContext) {
    return new NonRecordingSpan(spanContext);
  }
  var contextApi = ContextAPI.getInstance();
  var NoopTracer = (
    /** @class */
    function() {
      function NoopTracer2() {
      }
      NoopTracer2.prototype.startSpan = function(name2, options, context2) {
        if (context2 === void 0) {
          context2 = contextApi.active();
        }
        var root2 = Boolean(options === null || options === void 0 ? void 0 : options.root);
        if (root2) {
          return new NonRecordingSpan();
        }
        var parentFromContext = context2 && getSpanContext(context2);
        if (isSpanContext(parentFromContext) && isSpanContextValid(parentFromContext)) {
          return new NonRecordingSpan(parentFromContext);
        } else {
          return new NonRecordingSpan();
        }
      };
      NoopTracer2.prototype.startActiveSpan = function(name2, arg2, arg3, arg4) {
        var opts;
        var ctx;
        var fn;
        if (arguments.length < 2) {
          return;
        } else if (arguments.length === 2) {
          fn = arg2;
        } else if (arguments.length === 3) {
          opts = arg2;
          fn = arg3;
        } else {
          opts = arg2;
          ctx = arg3;
          fn = arg4;
        }
        var parentContext = ctx !== null && ctx !== void 0 ? ctx : contextApi.active();
        var span = this.startSpan(name2, opts, parentContext);
        var contextWithSpanSet = setSpan(parentContext, span);
        return contextApi.with(contextWithSpanSet, fn, void 0, span);
      };
      return NoopTracer2;
    }()
  );
  function isSpanContext(spanContext) {
    return typeof spanContext === "object" && typeof spanContext["spanId"] === "string" && typeof spanContext["traceId"] === "string" && typeof spanContext["traceFlags"] === "number";
  }
  var NOOP_TRACER = new NoopTracer();
  var ProxyTracer = (
    /** @class */
    function() {
      function ProxyTracer2(_provider, name2, version2, options) {
        this._provider = _provider;
        this.name = name2;
        this.version = version2;
        this.options = options;
      }
      ProxyTracer2.prototype.startSpan = function(name2, options, context2) {
        return this._getTracer().startSpan(name2, options, context2);
      };
      ProxyTracer2.prototype.startActiveSpan = function(_name, _options, _context, _fn) {
        var tracer = this._getTracer();
        return Reflect.apply(tracer.startActiveSpan, tracer, arguments);
      };
      ProxyTracer2.prototype._getTracer = function() {
        if (this._delegate) {
          return this._delegate;
        }
        var tracer = this._provider.getDelegateTracer(this.name, this.version, this.options);
        if (!tracer) {
          return NOOP_TRACER;
        }
        this._delegate = tracer;
        return this._delegate;
      };
      return ProxyTracer2;
    }()
  );
  var NoopTracerProvider = (
    /** @class */
    function() {
      function NoopTracerProvider2() {
      }
      NoopTracerProvider2.prototype.getTracer = function(_name, _version, _options) {
        return new NoopTracer();
      };
      return NoopTracerProvider2;
    }()
  );
  var NOOP_TRACER_PROVIDER = new NoopTracerProvider();
  var ProxyTracerProvider = (
    /** @class */
    function() {
      function ProxyTracerProvider2() {
      }
      ProxyTracerProvider2.prototype.getTracer = function(name2, version2, options) {
        var _a3;
        return (_a3 = this.getDelegateTracer(name2, version2, options)) !== null && _a3 !== void 0 ? _a3 : new ProxyTracer(this, name2, version2, options);
      };
      ProxyTracerProvider2.prototype.getDelegate = function() {
        var _a3;
        return (_a3 = this._delegate) !== null && _a3 !== void 0 ? _a3 : NOOP_TRACER_PROVIDER;
      };
      ProxyTracerProvider2.prototype.setDelegate = function(delegate) {
        this._delegate = delegate;
      };
      ProxyTracerProvider2.prototype.getDelegateTracer = function(name2, version2, options) {
        var _a3;
        return (_a3 = this._delegate) === null || _a3 === void 0 ? void 0 : _a3.getTracer(name2, version2, options);
      };
      return ProxyTracerProvider2;
    }()
  );
  var SamplingDecision$1;
  (function(SamplingDecision2) {
    SamplingDecision2[SamplingDecision2["NOT_RECORD"] = 0] = "NOT_RECORD";
    SamplingDecision2[SamplingDecision2["RECORD"] = 1] = "RECORD";
    SamplingDecision2[SamplingDecision2["RECORD_AND_SAMPLED"] = 2] = "RECORD_AND_SAMPLED";
  })(SamplingDecision$1 || (SamplingDecision$1 = {}));
  var SpanKind;
  (function(SpanKind2) {
    SpanKind2[SpanKind2["INTERNAL"] = 0] = "INTERNAL";
    SpanKind2[SpanKind2["SERVER"] = 1] = "SERVER";
    SpanKind2[SpanKind2["CLIENT"] = 2] = "CLIENT";
    SpanKind2[SpanKind2["PRODUCER"] = 3] = "PRODUCER";
    SpanKind2[SpanKind2["CONSUMER"] = 4] = "CONSUMER";
  })(SpanKind || (SpanKind = {}));
  var SpanStatusCode;
  (function(SpanStatusCode2) {
    SpanStatusCode2[SpanStatusCode2["UNSET"] = 0] = "UNSET";
    SpanStatusCode2[SpanStatusCode2["OK"] = 1] = "OK";
    SpanStatusCode2[SpanStatusCode2["ERROR"] = 2] = "ERROR";
  })(SpanStatusCode || (SpanStatusCode = {}));
  var VALID_KEY_CHAR_RANGE$1 = "[_0-9a-z-*/]";
  var VALID_KEY$1 = "[a-z]" + VALID_KEY_CHAR_RANGE$1 + "{0,255}";
  var VALID_VENDOR_KEY$1 = "[a-z0-9]" + VALID_KEY_CHAR_RANGE$1 + "{0,240}@[a-z]" + VALID_KEY_CHAR_RANGE$1 + "{0,13}";
  var VALID_KEY_REGEX$1 = new RegExp("^(?:" + VALID_KEY$1 + "|" + VALID_VENDOR_KEY$1 + ")$");
  var VALID_VALUE_BASE_REGEX$1 = /^[ -~]{0,255}[!-~]$/;
  var INVALID_VALUE_COMMA_EQUAL_REGEX$1 = /,|=/;
  function validateKey$1(key) {
    return VALID_KEY_REGEX$1.test(key);
  }
  function validateValue$1(value) {
    return VALID_VALUE_BASE_REGEX$1.test(value) && !INVALID_VALUE_COMMA_EQUAL_REGEX$1.test(value);
  }
  var MAX_TRACE_STATE_ITEMS$1 = 32;
  var MAX_TRACE_STATE_LEN$1 = 512;
  var LIST_MEMBERS_SEPARATOR$1 = ",";
  var LIST_MEMBER_KEY_VALUE_SPLITTER$1 = "=";
  var TraceStateImpl = (
    /** @class */
    function() {
      function TraceStateImpl2(rawTraceState) {
        this._internalState = /* @__PURE__ */ new Map();
        if (rawTraceState)
          this._parse(rawTraceState);
      }
      TraceStateImpl2.prototype.set = function(key, value) {
        var traceState = this._clone();
        if (traceState._internalState.has(key)) {
          traceState._internalState.delete(key);
        }
        traceState._internalState.set(key, value);
        return traceState;
      };
      TraceStateImpl2.prototype.unset = function(key) {
        var traceState = this._clone();
        traceState._internalState.delete(key);
        return traceState;
      };
      TraceStateImpl2.prototype.get = function(key) {
        return this._internalState.get(key);
      };
      TraceStateImpl2.prototype.serialize = function() {
        var _this = this;
        return this._keys().reduce(function(agg, key) {
          agg.push(key + LIST_MEMBER_KEY_VALUE_SPLITTER$1 + _this.get(key));
          return agg;
        }, []).join(LIST_MEMBERS_SEPARATOR$1);
      };
      TraceStateImpl2.prototype._parse = function(rawTraceState) {
        if (rawTraceState.length > MAX_TRACE_STATE_LEN$1)
          return;
        this._internalState = rawTraceState.split(LIST_MEMBERS_SEPARATOR$1).reverse().reduce(function(agg, part) {
          var listMember = part.trim();
          var i2 = listMember.indexOf(LIST_MEMBER_KEY_VALUE_SPLITTER$1);
          if (i2 !== -1) {
            var key = listMember.slice(0, i2);
            var value = listMember.slice(i2 + 1, part.length);
            if (validateKey$1(key) && validateValue$1(value)) {
              agg.set(key, value);
            }
          }
          return agg;
        }, /* @__PURE__ */ new Map());
        if (this._internalState.size > MAX_TRACE_STATE_ITEMS$1) {
          this._internalState = new Map(Array.from(this._internalState.entries()).reverse().slice(0, MAX_TRACE_STATE_ITEMS$1));
        }
      };
      TraceStateImpl2.prototype._keys = function() {
        return Array.from(this._internalState.keys()).reverse();
      };
      TraceStateImpl2.prototype._clone = function() {
        var traceState = new TraceStateImpl2();
        traceState._internalState = new Map(this._internalState);
        return traceState;
      };
      return TraceStateImpl2;
    }()
  );
  function createTraceState(rawTraceState) {
    return new TraceStateImpl(rawTraceState);
  }
  var context = ContextAPI.getInstance();
  var diag = DiagAPI.instance();
  var NoopMeterProvider = (
    /** @class */
    function() {
      function NoopMeterProvider2() {
      }
      NoopMeterProvider2.prototype.getMeter = function(_name, _version, _options) {
        return NOOP_METER;
      };
      return NoopMeterProvider2;
    }()
  );
  var NOOP_METER_PROVIDER = new NoopMeterProvider();
  var API_NAME$2 = "metrics";
  var MetricsAPI = (
    /** @class */
    function() {
      function MetricsAPI2() {
      }
      MetricsAPI2.getInstance = function() {
        if (!this._instance) {
          this._instance = new MetricsAPI2();
        }
        return this._instance;
      };
      MetricsAPI2.prototype.setGlobalMeterProvider = function(provider) {
        return registerGlobal(API_NAME$2, provider, DiagAPI.instance());
      };
      MetricsAPI2.prototype.getMeterProvider = function() {
        return getGlobal(API_NAME$2) || NOOP_METER_PROVIDER;
      };
      MetricsAPI2.prototype.getMeter = function(name2, version2, options) {
        return this.getMeterProvider().getMeter(name2, version2, options);
      };
      MetricsAPI2.prototype.disable = function() {
        unregisterGlobal(API_NAME$2, DiagAPI.instance());
      };
      return MetricsAPI2;
    }()
  );
  var metrics = MetricsAPI.getInstance();
  var NoopTextMapPropagator = (
    /** @class */
    function() {
      function NoopTextMapPropagator2() {
      }
      NoopTextMapPropagator2.prototype.inject = function(_context, _carrier) {
      };
      NoopTextMapPropagator2.prototype.extract = function(context2, _carrier) {
        return context2;
      };
      NoopTextMapPropagator2.prototype.fields = function() {
        return [];
      };
      return NoopTextMapPropagator2;
    }()
  );
  var BAGGAGE_KEY = createContextKey("OpenTelemetry Baggage Key");
  function getBaggage(context2) {
    return context2.getValue(BAGGAGE_KEY) || void 0;
  }
  function getActiveBaggage() {
    return getBaggage(ContextAPI.getInstance().active());
  }
  function setBaggage(context2, baggage) {
    return context2.setValue(BAGGAGE_KEY, baggage);
  }
  function deleteBaggage(context2) {
    return context2.deleteValue(BAGGAGE_KEY);
  }
  var API_NAME$1 = "propagation";
  var NOOP_TEXT_MAP_PROPAGATOR = new NoopTextMapPropagator();
  var PropagationAPI = (
    /** @class */
    function() {
      function PropagationAPI2() {
        this.createBaggage = createBaggage;
        this.getBaggage = getBaggage;
        this.getActiveBaggage = getActiveBaggage;
        this.setBaggage = setBaggage;
        this.deleteBaggage = deleteBaggage;
      }
      PropagationAPI2.getInstance = function() {
        if (!this._instance) {
          this._instance = new PropagationAPI2();
        }
        return this._instance;
      };
      PropagationAPI2.prototype.setGlobalPropagator = function(propagator) {
        return registerGlobal(API_NAME$1, propagator, DiagAPI.instance());
      };
      PropagationAPI2.prototype.inject = function(context2, carrier, setter) {
        if (setter === void 0) {
          setter = defaultTextMapSetter;
        }
        return this._getGlobalPropagator().inject(context2, carrier, setter);
      };
      PropagationAPI2.prototype.extract = function(context2, carrier, getter) {
        if (getter === void 0) {
          getter = defaultTextMapGetter;
        }
        return this._getGlobalPropagator().extract(context2, carrier, getter);
      };
      PropagationAPI2.prototype.fields = function() {
        return this._getGlobalPropagator().fields();
      };
      PropagationAPI2.prototype.disable = function() {
        unregisterGlobal(API_NAME$1, DiagAPI.instance());
      };
      PropagationAPI2.prototype._getGlobalPropagator = function() {
        return getGlobal(API_NAME$1) || NOOP_TEXT_MAP_PROPAGATOR;
      };
      return PropagationAPI2;
    }()
  );
  var propagation = PropagationAPI.getInstance();
  var API_NAME = "trace";
  var TraceAPI = (
    /** @class */
    function() {
      function TraceAPI2() {
        this._proxyTracerProvider = new ProxyTracerProvider();
        this.wrapSpanContext = wrapSpanContext;
        this.isSpanContextValid = isSpanContextValid;
        this.deleteSpan = deleteSpan;
        this.getSpan = getSpan;
        this.getActiveSpan = getActiveSpan$1;
        this.getSpanContext = getSpanContext;
        this.setSpan = setSpan;
        this.setSpanContext = setSpanContext;
      }
      TraceAPI2.getInstance = function() {
        if (!this._instance) {
          this._instance = new TraceAPI2();
        }
        return this._instance;
      };
      TraceAPI2.prototype.setGlobalTracerProvider = function(provider) {
        var success = registerGlobal(API_NAME, this._proxyTracerProvider, DiagAPI.instance());
        if (success) {
          this._proxyTracerProvider.setDelegate(provider);
        }
        return success;
      };
      TraceAPI2.prototype.getTracerProvider = function() {
        return getGlobal(API_NAME) || this._proxyTracerProvider;
      };
      TraceAPI2.prototype.getTracer = function(name2, version2) {
        return this.getTracerProvider().getTracer(name2, version2);
      };
      TraceAPI2.prototype.disable = function() {
        unregisterGlobal(API_NAME, DiagAPI.instance());
        this._proxyTracerProvider = new ProxyTracerProvider();
      };
      return TraceAPI2;
    }()
  );
  var trace = TraceAPI.getInstance();
  const index = {
    context,
    diag,
    metrics,
    propagation,
    trace
  };
  const esm$2 = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
    __proto__: null,
    DiagConsoleLogger,
    get DiagLogLevel() {
      return DiagLogLevel;
    },
    INVALID_SPANID,
    INVALID_SPAN_CONTEXT,
    INVALID_TRACEID,
    ProxyTracer,
    ProxyTracerProvider,
    ROOT_CONTEXT,
    get SamplingDecision() {
      return SamplingDecision$1;
    },
    get SpanKind() {
      return SpanKind;
    },
    get SpanStatusCode() {
      return SpanStatusCode;
    },
    get TraceFlags() {
      return TraceFlags;
    },
    get ValueType() {
      return ValueType;
    },
    baggageEntryMetadataFromString,
    context,
    createContextKey,
    createNoopMeter,
    createTraceState,
    default: index,
    defaultTextMapGetter,
    defaultTextMapSetter,
    diag,
    isSpanContextValid,
    isValidSpanId,
    isValidTraceId,
    metrics,
    propagation,
    trace
  }, Symbol.toStringTag, { value: "Module" }));
  var _global$2 = typeof window !== "undefined" ? window : typeof global !== "undefined" ? global : typeof self !== "undefined" ? self : {};
  _global$2.SENTRY_RELEASE = { id: "403cd70f263b170d32852f34f42da5c9f586b9c7" };
  var commonjsGlobal = typeof globalThis !== "undefined" ? globalThis : typeof window !== "undefined" ? window : typeof global !== "undefined" ? global : typeof self !== "undefined" ? self : {};
  function getDefaultExportFromCjs(x2) {
    return x2 && x2.__esModule && Object.prototype.hasOwnProperty.call(x2, "default") ? x2["default"] : x2;
  }
  function getAugmentedNamespace(n2) {
    if (n2.__esModule) return n2;
    var f2 = n2.default;
    if (typeof f2 == "function") {
      var a2 = function a3() {
        if (this instanceof a3) {
          return Reflect.construct(f2, arguments, this.constructor);
        }
        return f2.apply(this, arguments);
      };
      a2.prototype = f2.prototype;
    } else a2 = {};
    Object.defineProperty(a2, "__esModule", { value: true });
    Object.keys(n2).forEach(function(k2) {
      var d2 = Object.getOwnPropertyDescriptor(n2, k2);
      Object.defineProperty(a2, k2, d2.get ? d2 : {
        enumerable: true,
        get: function() {
          return n2[k2];
        }
      });
    });
    return a2;
  }
  const require$$0 = /* @__PURE__ */ getAugmentedNamespace(esm$2);
  var re$3 = { exports: {} };
  const SEMVER_SPEC_VERSION = "2.0.0";
  const MAX_LENGTH$1 = 256;
  const MAX_SAFE_INTEGER$3 = Number.MAX_SAFE_INTEGER || /* istanbul ignore next */
  9007199254740991;
  const MAX_SAFE_COMPONENT_LENGTH = 16;
  const MAX_SAFE_BUILD_LENGTH = MAX_LENGTH$1 - 6;
  const RELEASE_TYPES = [
    "major",
    "premajor",
    "minor",
    "preminor",
    "patch",
    "prepatch",
    "prerelease"
  ];
  var constants$3 = {
    MAX_LENGTH: MAX_LENGTH$1,
    MAX_SAFE_COMPONENT_LENGTH,
    MAX_SAFE_BUILD_LENGTH,
    MAX_SAFE_INTEGER: MAX_SAFE_INTEGER$3,
    RELEASE_TYPES,
    SEMVER_SPEC_VERSION,
    FLAG_INCLUDE_PRERELEASE: 1,
    FLAG_LOOSE: 2
  };
  const debug$4 = typeof process === "object" && process.env && process.env.NODE_DEBUG && /\bsemver\b/i.test(process.env.NODE_DEBUG) ? (...args2) => console.error("SEMVER", ...args2) : () => {
  };
  var debug_1 = debug$4;
  (function(module2, exports2) {
    const {
      MAX_SAFE_COMPONENT_LENGTH: MAX_SAFE_COMPONENT_LENGTH2,
      MAX_SAFE_BUILD_LENGTH: MAX_SAFE_BUILD_LENGTH2,
      MAX_LENGTH: MAX_LENGTH2
    } = constants$3;
    const debug2 = debug_1;
    exports2 = module2.exports = {};
    const re2 = exports2.re = [];
    const safeRe = exports2.safeRe = [];
    const src2 = exports2.src = [];
    const t2 = exports2.t = {};
    let R2 = 0;
    const LETTERDASHNUMBER = "[a-zA-Z0-9-]";
    const safeRegexReplacements = [
      ["\\s", 1],
      ["\\d", MAX_LENGTH2],
      [LETTERDASHNUMBER, MAX_SAFE_BUILD_LENGTH2]
    ];
    const makeSafeRegex = (value) => {
      for (const [token, max2] of safeRegexReplacements) {
        value = value.split(`${token}*`).join(`${token}{0,${max2}}`).split(`${token}+`).join(`${token}{1,${max2}}`);
      }
      return value;
    };
    const createToken = (name2, value, isGlobal) => {
      const safe = makeSafeRegex(value);
      const index2 = R2++;
      debug2(name2, index2, value);
      t2[name2] = index2;
      src2[index2] = value;
      re2[index2] = new RegExp(value, isGlobal ? "g" : void 0);
      safeRe[index2] = new RegExp(safe, isGlobal ? "g" : void 0);
    };
    createToken("NUMERICIDENTIFIER", "0|[1-9]\\d*");
    createToken("NUMERICIDENTIFIERLOOSE", "\\d+");
    createToken("NONNUMERICIDENTIFIER", `\\d*[a-zA-Z-]${LETTERDASHNUMBER}*`);
    createToken("MAINVERSION", `(${src2[t2.NUMERICIDENTIFIER]})\\.(${src2[t2.NUMERICIDENTIFIER]})\\.(${src2[t2.NUMERICIDENTIFIER]})`);
    createToken("MAINVERSIONLOOSE", `(${src2[t2.NUMERICIDENTIFIERLOOSE]})\\.(${src2[t2.NUMERICIDENTIFIERLOOSE]})\\.(${src2[t2.NUMERICIDENTIFIERLOOSE]})`);
    createToken("PRERELEASEIDENTIFIER", `(?:${src2[t2.NUMERICIDENTIFIER]}|${src2[t2.NONNUMERICIDENTIFIER]})`);
    createToken("PRERELEASEIDENTIFIERLOOSE", `(?:${src2[t2.NUMERICIDENTIFIERLOOSE]}|${src2[t2.NONNUMERICIDENTIFIER]})`);
    createToken("PRERELEASE", `(?:-(${src2[t2.PRERELEASEIDENTIFIER]}(?:\\.${src2[t2.PRERELEASEIDENTIFIER]})*))`);
    createToken("PRERELEASELOOSE", `(?:-?(${src2[t2.PRERELEASEIDENTIFIERLOOSE]}(?:\\.${src2[t2.PRERELEASEIDENTIFIERLOOSE]})*))`);
    createToken("BUILDIDENTIFIER", `${LETTERDASHNUMBER}+`);
    createToken("BUILD", `(?:\\+(${src2[t2.BUILDIDENTIFIER]}(?:\\.${src2[t2.BUILDIDENTIFIER]})*))`);
    createToken("FULLPLAIN", `v?${src2[t2.MAINVERSION]}${src2[t2.PRERELEASE]}?${src2[t2.BUILD]}?`);
    createToken("FULL", `^${src2[t2.FULLPLAIN]}$`);
    createToken("LOOSEPLAIN", `[v=\\s]*${src2[t2.MAINVERSIONLOOSE]}${src2[t2.PRERELEASELOOSE]}?${src2[t2.BUILD]}?`);
    createToken("LOOSE", `^${src2[t2.LOOSEPLAIN]}$`);
    createToken("GTLT", "((?:<|>)?=?)");
    createToken("XRANGEIDENTIFIERLOOSE", `${src2[t2.NUMERICIDENTIFIERLOOSE]}|x|X|\\*`);
    createToken("XRANGEIDENTIFIER", `${src2[t2.NUMERICIDENTIFIER]}|x|X|\\*`);
    createToken("XRANGEPLAIN", `[v=\\s]*(${src2[t2.XRANGEIDENTIFIER]})(?:\\.(${src2[t2.XRANGEIDENTIFIER]})(?:\\.(${src2[t2.XRANGEIDENTIFIER]})(?:${src2[t2.PRERELEASE]})?${src2[t2.BUILD]}?)?)?`);
    createToken("XRANGEPLAINLOOSE", `[v=\\s]*(${src2[t2.XRANGEIDENTIFIERLOOSE]})(?:\\.(${src2[t2.XRANGEIDENTIFIERLOOSE]})(?:\\.(${src2[t2.XRANGEIDENTIFIERLOOSE]})(?:${src2[t2.PRERELEASELOOSE]})?${src2[t2.BUILD]}?)?)?`);
    createToken("XRANGE", `^${src2[t2.GTLT]}\\s*${src2[t2.XRANGEPLAIN]}$`);
    createToken("XRANGELOOSE", `^${src2[t2.GTLT]}\\s*${src2[t2.XRANGEPLAINLOOSE]}$`);
    createToken("COERCEPLAIN", `${"(^|[^\\d])(\\d{1,"}${MAX_SAFE_COMPONENT_LENGTH2}})(?:\\.(\\d{1,${MAX_SAFE_COMPONENT_LENGTH2}}))?(?:\\.(\\d{1,${MAX_SAFE_COMPONENT_LENGTH2}}))?`);
    createToken("COERCE", `${src2[t2.COERCEPLAIN]}(?:$|[^\\d])`);
    createToken("COERCEFULL", src2[t2.COERCEPLAIN] + `(?:${src2[t2.PRERELEASE]})?(?:${src2[t2.BUILD]})?(?:$|[^\\d])`);
    createToken("COERCERTL", src2[t2.COERCE], true);
    createToken("COERCERTLFULL", src2[t2.COERCEFULL], true);
    createToken("LONETILDE", "(?:~>?)");
    createToken("TILDETRIM", `(\\s*)${src2[t2.LONETILDE]}\\s+`, true);
    exports2.tildeTrimReplace = "$1~";
    createToken("TILDE", `^${src2[t2.LONETILDE]}${src2[t2.XRANGEPLAIN]}$`);
    createToken("TILDELOOSE", `^${src2[t2.LONETILDE]}${src2[t2.XRANGEPLAINLOOSE]}$`);
    createToken("LONECARET", "(?:\\^)");
    createToken("CARETTRIM", `(\\s*)${src2[t2.LONECARET]}\\s+`, true);
    exports2.caretTrimReplace = "$1^";
    createToken("CARET", `^${src2[t2.LONECARET]}${src2[t2.XRANGEPLAIN]}$`);
    createToken("CARETLOOSE", `^${src2[t2.LONECARET]}${src2[t2.XRANGEPLAINLOOSE]}$`);
    createToken("COMPARATORLOOSE", `^${src2[t2.GTLT]}\\s*(${src2[t2.LOOSEPLAIN]})$|^$`);
    createToken("COMPARATOR", `^${src2[t2.GTLT]}\\s*(${src2[t2.FULLPLAIN]})$|^$`);
    createToken("COMPARATORTRIM", `(\\s*)${src2[t2.GTLT]}\\s*(${src2[t2.LOOSEPLAIN]}|${src2[t2.XRANGEPLAIN]})`, true);
    exports2.comparatorTrimReplace = "$1$2$3";
    createToken("HYPHENRANGE", `^\\s*(${src2[t2.XRANGEPLAIN]})\\s+-\\s+(${src2[t2.XRANGEPLAIN]})\\s*$`);
    createToken("HYPHENRANGELOOSE", `^\\s*(${src2[t2.XRANGEPLAINLOOSE]})\\s+-\\s+(${src2[t2.XRANGEPLAINLOOSE]})\\s*$`);
    createToken("STAR", "(<|>)?=?\\s*\\*");
    createToken("GTE0", "^\\s*>=\\s*0\\.0\\.0\\s*$");
    createToken("GTE0PRE", "^\\s*>=\\s*0\\.0\\.0-0\\s*$");
  })(re$3, re$3.exports);
  var reExports = re$3.exports;
  const looseOption = Object.freeze({ loose: true });
  const emptyOpts = Object.freeze({});
  const parseOptions$2 = (options) => {
    if (!options) {
      return emptyOpts;
    }
    if (typeof options !== "object") {
      return looseOption;
    }
    return options;
  };
  var parseOptions_1 = parseOptions$2;
  const numeric = /^[0-9]+$/;
  const compareIdentifiers$1 = (a2, b2) => {
    const anum = numeric.test(a2);
    const bnum = numeric.test(b2);
    if (anum && bnum) {
      a2 = +a2;
      b2 = +b2;
    }
    return a2 === b2 ? 0 : anum && !bnum ? -1 : bnum && !anum ? 1 : a2 < b2 ? -1 : 1;
  };
  const rcompareIdentifiers = (a2, b2) => compareIdentifiers$1(b2, a2);
  var identifiers$1 = {
    compareIdentifiers: compareIdentifiers$1,
    rcompareIdentifiers
  };
  const debug$3 = debug_1;
  const { MAX_LENGTH, MAX_SAFE_INTEGER: MAX_SAFE_INTEGER$2 } = constants$3;
  const { safeRe: re$2, t: t$1 } = reExports;
  const parseOptions$1 = parseOptions_1;
  const { compareIdentifiers } = identifiers$1;
  let SemVer$d = class SemVer2 {
    constructor(version2, options) {
      options = parseOptions$1(options);
      if (version2 instanceof SemVer2) {
        if (version2.loose === !!options.loose && version2.includePrerelease === !!options.includePrerelease) {
          return version2;
        } else {
          version2 = version2.version;
        }
      } else if (typeof version2 !== "string") {
        throw new TypeError(`Invalid version. Must be a string. Got type "${typeof version2}".`);
      }
      if (version2.length > MAX_LENGTH) {
        throw new TypeError(
          `version is longer than ${MAX_LENGTH} characters`
        );
      }
      debug$3("SemVer", version2, options);
      this.options = options;
      this.loose = !!options.loose;
      this.includePrerelease = !!options.includePrerelease;
      const m2 = version2.trim().match(options.loose ? re$2[t$1.LOOSE] : re$2[t$1.FULL]);
      if (!m2) {
        throw new TypeError(`Invalid Version: ${version2}`);
      }
      this.raw = version2;
      this.major = +m2[1];
      this.minor = +m2[2];
      this.patch = +m2[3];
      if (this.major > MAX_SAFE_INTEGER$2 || this.major < 0) {
        throw new TypeError("Invalid major version");
      }
      if (this.minor > MAX_SAFE_INTEGER$2 || this.minor < 0) {
        throw new TypeError("Invalid minor version");
      }
      if (this.patch > MAX_SAFE_INTEGER$2 || this.patch < 0) {
        throw new TypeError("Invalid patch version");
      }
      if (!m2[4]) {
        this.prerelease = [];
      } else {
        this.prerelease = m2[4].split(".").map((id) => {
          if (/^[0-9]+$/.test(id)) {
            const num = +id;
            if (num >= 0 && num < MAX_SAFE_INTEGER$2) {
              return num;
            }
          }
          return id;
        });
      }
      this.build = m2[5] ? m2[5].split(".") : [];
      this.format();
    }
    format() {
      this.version = `${this.major}.${this.minor}.${this.patch}`;
      if (this.prerelease.length) {
        this.version += `-${this.prerelease.join(".")}`;
      }
      return this.version;
    }
    toString() {
      return this.version;
    }
    compare(other) {
      debug$3("SemVer.compare", this.version, this.options, other);
      if (!(other instanceof SemVer2)) {
        if (typeof other === "string" && other === this.version) {
          return 0;
        }
        other = new SemVer2(other, this.options);
      }
      if (other.version === this.version) {
        return 0;
      }
      return this.compareMain(other) || this.comparePre(other);
    }
    compareMain(other) {
      if (!(other instanceof SemVer2)) {
        other = new SemVer2(other, this.options);
      }
      return compareIdentifiers(this.major, other.major) || compareIdentifiers(this.minor, other.minor) || compareIdentifiers(this.patch, other.patch);
    }
    comparePre(other) {
      if (!(other instanceof SemVer2)) {
        other = new SemVer2(other, this.options);
      }
      if (this.prerelease.length && !other.prerelease.length) {
        return -1;
      } else if (!this.prerelease.length && other.prerelease.length) {
        return 1;
      } else if (!this.prerelease.length && !other.prerelease.length) {
        return 0;
      }
      let i2 = 0;
      do {
        const a2 = this.prerelease[i2];
        const b2 = other.prerelease[i2];
        debug$3("prerelease compare", i2, a2, b2);
        if (a2 === void 0 && b2 === void 0) {
          return 0;
        } else if (b2 === void 0) {
          return 1;
        } else if (a2 === void 0) {
          return -1;
        } else if (a2 === b2) {
          continue;
        } else {
          return compareIdentifiers(a2, b2);
        }
      } while (++i2);
    }
    compareBuild(other) {
      if (!(other instanceof SemVer2)) {
        other = new SemVer2(other, this.options);
      }
      let i2 = 0;
      do {
        const a2 = this.build[i2];
        const b2 = other.build[i2];
        debug$3("build compare", i2, a2, b2);
        if (a2 === void 0 && b2 === void 0) {
          return 0;
        } else if (b2 === void 0) {
          return 1;
        } else if (a2 === void 0) {
          return -1;
        } else if (a2 === b2) {
          continue;
        } else {
          return compareIdentifiers(a2, b2);
        }
      } while (++i2);
    }
    // preminor will bump the version up to the next minor release, and immediately
    // down to pre-release. premajor and prepatch work the same way.
    inc(release, identifier, identifierBase) {
      switch (release) {
        case "premajor":
          this.prerelease.length = 0;
          this.patch = 0;
          this.minor = 0;
          this.major++;
          this.inc("pre", identifier, identifierBase);
          break;
        case "preminor":
          this.prerelease.length = 0;
          this.patch = 0;
          this.minor++;
          this.inc("pre", identifier, identifierBase);
          break;
        case "prepatch":
          this.prerelease.length = 0;
          this.inc("patch", identifier, identifierBase);
          this.inc("pre", identifier, identifierBase);
          break;
        case "prerelease":
          if (this.prerelease.length === 0) {
            this.inc("patch", identifier, identifierBase);
          }
          this.inc("pre", identifier, identifierBase);
          break;
        case "major":
          if (this.minor !== 0 || this.patch !== 0 || this.prerelease.length === 0) {
            this.major++;
          }
          this.minor = 0;
          this.patch = 0;
          this.prerelease = [];
          break;
        case "minor":
          if (this.patch !== 0 || this.prerelease.length === 0) {
            this.minor++;
          }
          this.patch = 0;
          this.prerelease = [];
          break;
        case "patch":
          if (this.prerelease.length === 0) {
            this.patch++;
          }
          this.prerelease = [];
          break;
        case "pre": {
          const base = Number(identifierBase) ? 1 : 0;
          if (!identifier && identifierBase === false) {
            throw new Error("invalid increment argument: identifier is empty");
          }
          if (this.prerelease.length === 0) {
            this.prerelease = [base];
          } else {
            let i2 = this.prerelease.length;
            while (--i2 >= 0) {
              if (typeof this.prerelease[i2] === "number") {
                this.prerelease[i2]++;
                i2 = -2;
              }
            }
            if (i2 === -1) {
              if (identifier === this.prerelease.join(".") && identifierBase === false) {
                throw new Error("invalid increment argument: identifier already exists");
              }
              this.prerelease.push(base);
            }
          }
          if (identifier) {
            let prerelease2 = [identifier, base];
            if (identifierBase === false) {
              prerelease2 = [identifier];
            }
            if (compareIdentifiers(this.prerelease[0], identifier) === 0) {
              if (isNaN(this.prerelease[1])) {
                this.prerelease = prerelease2;
              }
            } else {
              this.prerelease = prerelease2;
            }
          }
          break;
        }
        default:
          throw new Error(`invalid increment argument: ${release}`);
      }
      this.raw = this.format();
      if (this.build.length) {
        this.raw += `+${this.build.join(".")}`;
      }
      return this;
    }
  };
  var semver$1 = SemVer$d;
  const SemVer$c = semver$1;
  const parse$b = (version2, options, throwErrors = false) => {
    if (version2 instanceof SemVer$c) {
      return version2;
    }
    try {
      return new SemVer$c(version2, options);
    } catch (er) {
      if (!throwErrors) {
        return null;
      }
      throw er;
    }
  };
  var parse_1$2 = parse$b;
  const parse$a = parse_1$2;
  const valid$2 = (version2, options) => {
    const v2 = parse$a(version2, options);
    return v2 ? v2.version : null;
  };
  var valid_1 = valid$2;
  const parse$9 = parse_1$2;
  const clean$1 = (version2, options) => {
    const s2 = parse$9(version2.trim().replace(/^[=v]+/, ""), options);
    return s2 ? s2.version : null;
  };
  var clean_1 = clean$1;
  const SemVer$b = semver$1;
  const inc$1 = (version2, release, options, identifier, identifierBase) => {
    if (typeof options === "string") {
      identifierBase = identifier;
      identifier = options;
      options = void 0;
    }
    try {
      return new SemVer$b(
        version2 instanceof SemVer$b ? version2.version : version2,
        options
      ).inc(release, identifier, identifierBase).version;
    } catch (er) {
      return null;
    }
  };
  var inc_1 = inc$1;
  const parse$8 = parse_1$2;
  const diff$1 = (version1, version2) => {
    const v1 = parse$8(version1, null, true);
    const v2 = parse$8(version2, null, true);
    const comparison = v1.compare(v2);
    if (comparison === 0) {
      return null;
    }
    const v1Higher = comparison > 0;
    const highVersion = v1Higher ? v1 : v2;
    const lowVersion = v1Higher ? v2 : v1;
    const highHasPre = !!highVersion.prerelease.length;
    const lowHasPre = !!lowVersion.prerelease.length;
    if (lowHasPre && !highHasPre) {
      if (!lowVersion.patch && !lowVersion.minor) {
        return "major";
      }
      if (highVersion.patch) {
        return "patch";
      }
      if (highVersion.minor) {
        return "minor";
      }
      return "major";
    }
    const prefix = highHasPre ? "pre" : "";
    if (v1.major !== v2.major) {
      return prefix + "major";
    }
    if (v1.minor !== v2.minor) {
      return prefix + "minor";
    }
    if (v1.patch !== v2.patch) {
      return prefix + "patch";
    }
    return "prerelease";
  };
  var diff_1 = diff$1;
  const SemVer$a = semver$1;
  const major$1 = (a2, loose) => new SemVer$a(a2, loose).major;
  var major_1 = major$1;
  const SemVer$9 = semver$1;
  const minor$1 = (a2, loose) => new SemVer$9(a2, loose).minor;
  var minor_1 = minor$1;
  const SemVer$8 = semver$1;
  const patch$1 = (a2, loose) => new SemVer$8(a2, loose).patch;
  var patch_1 = patch$1;
  const parse$7 = parse_1$2;
  const prerelease$1 = (version2, options) => {
    const parsed2 = parse$7(version2, options);
    return parsed2 && parsed2.prerelease.length ? parsed2.prerelease : null;
  };
  var prerelease_1 = prerelease$1;
  const SemVer$7 = semver$1;
  const compare$b = (a2, b2, loose) => new SemVer$7(a2, loose).compare(new SemVer$7(b2, loose));
  var compare_1 = compare$b;
  const compare$a = compare_1;
  const rcompare$1 = (a2, b2, loose) => compare$a(b2, a2, loose);
  var rcompare_1 = rcompare$1;
  const compare$9 = compare_1;
  const compareLoose$1 = (a2, b2) => compare$9(a2, b2, true);
  var compareLoose_1 = compareLoose$1;
  const SemVer$6 = semver$1;
  const compareBuild$3 = (a2, b2, loose) => {
    const versionA = new SemVer$6(a2, loose);
    const versionB = new SemVer$6(b2, loose);
    return versionA.compare(versionB) || versionA.compareBuild(versionB);
  };
  var compareBuild_1 = compareBuild$3;
  const compareBuild$2 = compareBuild_1;
  const sort$1 = (list, loose) => list.sort((a2, b2) => compareBuild$2(a2, b2, loose));
  var sort_1 = sort$1;
  const compareBuild$1 = compareBuild_1;
  const rsort$1 = (list, loose) => list.sort((a2, b2) => compareBuild$1(b2, a2, loose));
  var rsort_1 = rsort$1;
  const compare$8 = compare_1;
  const gt$4 = (a2, b2, loose) => compare$8(a2, b2, loose) > 0;
  var gt_1 = gt$4;
  const compare$7 = compare_1;
  const lt$3 = (a2, b2, loose) => compare$7(a2, b2, loose) < 0;
  var lt_1 = lt$3;
  const compare$6 = compare_1;
  const eq$3 = (a2, b2, loose) => compare$6(a2, b2, loose) === 0;
  var eq_1 = eq$3;
  const compare$5 = compare_1;
  const neq$2 = (a2, b2, loose) => compare$5(a2, b2, loose) !== 0;
  var neq_1 = neq$2;
  const compare$4 = compare_1;
  const gte$3 = (a2, b2, loose) => compare$4(a2, b2, loose) >= 0;
  var gte_1 = gte$3;
  const compare$3 = compare_1;
  const lte$3 = (a2, b2, loose) => compare$3(a2, b2, loose) <= 0;
  var lte_1 = lte$3;
  const eq$2 = eq_1;
  const neq$1 = neq_1;
  const gt$3 = gt_1;
  const gte$2 = gte_1;
  const lt$2 = lt_1;
  const lte$2 = lte_1;
  const cmp$1 = (a2, op, b2, loose) => {
    switch (op) {
      case "===":
        if (typeof a2 === "object") {
          a2 = a2.version;
        }
        if (typeof b2 === "object") {
          b2 = b2.version;
        }
        return a2 === b2;
      case "!==":
        if (typeof a2 === "object") {
          a2 = a2.version;
        }
        if (typeof b2 === "object") {
          b2 = b2.version;
        }
        return a2 !== b2;
      case "":
      case "=":
      case "==":
        return eq$2(a2, b2, loose);
      case "!=":
        return neq$1(a2, b2, loose);
      case ">":
        return gt$3(a2, b2, loose);
      case ">=":
        return gte$2(a2, b2, loose);
      case "<":
        return lt$2(a2, b2, loose);
      case "<=":
        return lte$2(a2, b2, loose);
      default:
        throw new TypeError(`Invalid operator: ${op}`);
    }
  };
  var cmp_1 = cmp$1;
  const SemVer$5 = semver$1;
  const parse$6 = parse_1$2;
  const { safeRe: re$1, t } = reExports;
  const coerce$1 = (version2, options) => {
    if (version2 instanceof SemVer$5) {
      return version2;
    }
    if (typeof version2 === "number") {
      version2 = String(version2);
    }
    if (typeof version2 !== "string") {
      return null;
    }
    options = options || {};
    let match = null;
    if (!options.rtl) {
      match = version2.match(options.includePrerelease ? re$1[t.COERCEFULL] : re$1[t.COERCE]);
    } else {
      const coerceRtlRegex = options.includePrerelease ? re$1[t.COERCERTLFULL] : re$1[t.COERCERTL];
      let next;
      while ((next = coerceRtlRegex.exec(version2)) && (!match || match.index + match[0].length !== version2.length)) {
        if (!match || next.index + next[0].length !== match.index + match[0].length) {
          match = next;
        }
        coerceRtlRegex.lastIndex = next.index + next[1].length + next[2].length;
      }
      coerceRtlRegex.lastIndex = -1;
    }
    if (match === null) {
      return null;
    }
    const major2 = match[2];
    const minor2 = match[3] || "0";
    const patch2 = match[4] || "0";
    const prerelease2 = options.includePrerelease && match[5] ? `-${match[5]}` : "";
    const build = options.includePrerelease && match[6] ? `+${match[6]}` : "";
    return parse$6(`${major2}.${minor2}.${patch2}${prerelease2}${build}`, options);
  };
  var coerce_1 = coerce$1;
  class LRUCache {
    constructor() {
      this.max = 1e3;
      this.map = /* @__PURE__ */ new Map();
    }
    get(key) {
      const value = this.map.get(key);
      if (value === void 0) {
        return void 0;
      } else {
        this.map.delete(key);
        this.map.set(key, value);
        return value;
      }
    }
    delete(key) {
      return this.map.delete(key);
    }
    set(key, value) {
      const deleted = this.delete(key);
      if (!deleted && value !== void 0) {
        if (this.map.size >= this.max) {
          const firstKey = this.map.keys().next().value;
          this.delete(firstKey);
        }
        this.map.set(key, value);
      }
      return this;
    }
  }
  var lrucache = LRUCache;
  var range;
  var hasRequiredRange;
  function requireRange() {
    if (hasRequiredRange) return range;
    hasRequiredRange = 1;
    const SPACE_CHARACTERS = /\s+/g;
    class Range2 {
      constructor(range2, options) {
        options = parseOptions2(options);
        if (range2 instanceof Range2) {
          if (range2.loose === !!options.loose && range2.includePrerelease === !!options.includePrerelease) {
            return range2;
          } else {
            return new Range2(range2.raw, options);
          }
        }
        if (range2 instanceof Comparator2) {
          this.raw = range2.value;
          this.set = [[range2]];
          this.formatted = void 0;
          return this;
        }
        this.options = options;
        this.loose = !!options.loose;
        this.includePrerelease = !!options.includePrerelease;
        this.raw = range2.trim().replace(SPACE_CHARACTERS, " ");
        this.set = this.raw.split("||").map((r2) => this.parseRange(r2.trim())).filter((c2) => c2.length);
        if (!this.set.length) {
          throw new TypeError(`Invalid SemVer Range: ${this.raw}`);
        }
        if (this.set.length > 1) {
          const first = this.set[0];
          this.set = this.set.filter((c2) => !isNullSet(c2[0]));
          if (this.set.length === 0) {
            this.set = [first];
          } else if (this.set.length > 1) {
            for (const c2 of this.set) {
              if (c2.length === 1 && isAny(c2[0])) {
                this.set = [c2];
                break;
              }
            }
          }
        }
        this.formatted = void 0;
      }
      get range() {
        if (this.formatted === void 0) {
          this.formatted = "";
          for (let i2 = 0; i2 < this.set.length; i2++) {
            if (i2 > 0) {
              this.formatted += "||";
            }
            const comps = this.set[i2];
            for (let k2 = 0; k2 < comps.length; k2++) {
              if (k2 > 0) {
                this.formatted += " ";
              }
              this.formatted += comps[k2].toString().trim();
            }
          }
        }
        return this.formatted;
      }
      format() {
        return this.range;
      }
      toString() {
        return this.range;
      }
      parseRange(range2) {
        const memoOpts = (this.options.includePrerelease && FLAG_INCLUDE_PRERELEASE) | (this.options.loose && FLAG_LOOSE);
        const memoKey = memoOpts + ":" + range2;
        const cached = cache.get(memoKey);
        if (cached) {
          return cached;
        }
        const loose = this.options.loose;
        const hr = loose ? re2[t2.HYPHENRANGELOOSE] : re2[t2.HYPHENRANGE];
        range2 = range2.replace(hr, hyphenReplace(this.options.includePrerelease));
        debug2("hyphen replace", range2);
        range2 = range2.replace(re2[t2.COMPARATORTRIM], comparatorTrimReplace);
        debug2("comparator trim", range2);
        range2 = range2.replace(re2[t2.TILDETRIM], tildeTrimReplace);
        debug2("tilde trim", range2);
        range2 = range2.replace(re2[t2.CARETTRIM], caretTrimReplace);
        debug2("caret trim", range2);
        let rangeList = range2.split(" ").map((comp) => parseComparator(comp, this.options)).join(" ").split(/\s+/).map((comp) => replaceGTE0(comp, this.options));
        if (loose) {
          rangeList = rangeList.filter((comp) => {
            debug2("loose invalid filter", comp, this.options);
            return !!comp.match(re2[t2.COMPARATORLOOSE]);
          });
        }
        debug2("range list", rangeList);
        const rangeMap = /* @__PURE__ */ new Map();
        const comparators = rangeList.map((comp) => new Comparator2(comp, this.options));
        for (const comp of comparators) {
          if (isNullSet(comp)) {
            return [comp];
          }
          rangeMap.set(comp.value, comp);
        }
        if (rangeMap.size > 1 && rangeMap.has("")) {
          rangeMap.delete("");
        }
        const result = [...rangeMap.values()];
        cache.set(memoKey, result);
        return result;
      }
      intersects(range2, options) {
        if (!(range2 instanceof Range2)) {
          throw new TypeError("a Range is required");
        }
        return this.set.some((thisComparators) => {
          return isSatisfiable(thisComparators, options) && range2.set.some((rangeComparators) => {
            return isSatisfiable(rangeComparators, options) && thisComparators.every((thisComparator) => {
              return rangeComparators.every((rangeComparator) => {
                return thisComparator.intersects(rangeComparator, options);
              });
            });
          });
        });
      }
      // if ANY of the sets match ALL of its comparators, then pass
      test(version2) {
        if (!version2) {
          return false;
        }
        if (typeof version2 === "string") {
          try {
            version2 = new SemVer2(version2, this.options);
          } catch (er) {
            return false;
          }
        }
        for (let i2 = 0; i2 < this.set.length; i2++) {
          if (testSet(this.set[i2], version2, this.options)) {
            return true;
          }
        }
        return false;
      }
    }
    range = Range2;
    const LRU = lrucache;
    const cache = new LRU();
    const parseOptions2 = parseOptions_1;
    const Comparator2 = requireComparator();
    const debug2 = debug_1;
    const SemVer2 = semver$1;
    const {
      safeRe: re2,
      t: t2,
      comparatorTrimReplace,
      tildeTrimReplace,
      caretTrimReplace
    } = reExports;
    const { FLAG_INCLUDE_PRERELEASE, FLAG_LOOSE } = constants$3;
    const isNullSet = (c2) => c2.value === "<0.0.0-0";
    const isAny = (c2) => c2.value === "";
    const isSatisfiable = (comparators, options) => {
      let result = true;
      const remainingComparators = comparators.slice();
      let testComparator = remainingComparators.pop();
      while (result && remainingComparators.length) {
        result = remainingComparators.every((otherComparator) => {
          return testComparator.intersects(otherComparator, options);
        });
        testComparator = remainingComparators.pop();
      }
      return result;
    };
    const parseComparator = (comp, options) => {
      debug2("comp", comp, options);
      comp = replaceCarets(comp, options);
      debug2("caret", comp);
      comp = replaceTildes(comp, options);
      debug2("tildes", comp);
      comp = replaceXRanges(comp, options);
      debug2("xrange", comp);
      comp = replaceStars(comp, options);
      debug2("stars", comp);
      return comp;
    };
    const isX = (id) => !id || id.toLowerCase() === "x" || id === "*";
    const replaceTildes = (comp, options) => {
      return comp.trim().split(/\s+/).map((c2) => replaceTilde(c2, options)).join(" ");
    };
    const replaceTilde = (comp, options) => {
      const r2 = options.loose ? re2[t2.TILDELOOSE] : re2[t2.TILDE];
      return comp.replace(r2, (_2, M2, m2, p2, pr) => {
        debug2("tilde", comp, _2, M2, m2, p2, pr);
        let ret;
        if (isX(M2)) {
          ret = "";
        } else if (isX(m2)) {
          ret = `>=${M2}.0.0 <${+M2 + 1}.0.0-0`;
        } else if (isX(p2)) {
          ret = `>=${M2}.${m2}.0 <${M2}.${+m2 + 1}.0-0`;
        } else if (pr) {
          debug2("replaceTilde pr", pr);
          ret = `>=${M2}.${m2}.${p2}-${pr} <${M2}.${+m2 + 1}.0-0`;
        } else {
          ret = `>=${M2}.${m2}.${p2} <${M2}.${+m2 + 1}.0-0`;
        }
        debug2("tilde return", ret);
        return ret;
      });
    };
    const replaceCarets = (comp, options) => {
      return comp.trim().split(/\s+/).map((c2) => replaceCaret(c2, options)).join(" ");
    };
    const replaceCaret = (comp, options) => {
      debug2("caret", comp, options);
      const r2 = options.loose ? re2[t2.CARETLOOSE] : re2[t2.CARET];
      const z2 = options.includePrerelease ? "-0" : "";
      return comp.replace(r2, (_2, M2, m2, p2, pr) => {
        debug2("caret", comp, _2, M2, m2, p2, pr);
        let ret;
        if (isX(M2)) {
          ret = "";
        } else if (isX(m2)) {
          ret = `>=${M2}.0.0${z2} <${+M2 + 1}.0.0-0`;
        } else if (isX(p2)) {
          if (M2 === "0") {
            ret = `>=${M2}.${m2}.0${z2} <${M2}.${+m2 + 1}.0-0`;
          } else {
            ret = `>=${M2}.${m2}.0${z2} <${+M2 + 1}.0.0-0`;
          }
        } else if (pr) {
          debug2("replaceCaret pr", pr);
          if (M2 === "0") {
            if (m2 === "0") {
              ret = `>=${M2}.${m2}.${p2}-${pr} <${M2}.${m2}.${+p2 + 1}-0`;
            } else {
              ret = `>=${M2}.${m2}.${p2}-${pr} <${M2}.${+m2 + 1}.0-0`;
            }
          } else {
            ret = `>=${M2}.${m2}.${p2}-${pr} <${+M2 + 1}.0.0-0`;
          }
        } else {
          debug2("no pr");
          if (M2 === "0") {
            if (m2 === "0") {
              ret = `>=${M2}.${m2}.${p2}${z2} <${M2}.${m2}.${+p2 + 1}-0`;
            } else {
              ret = `>=${M2}.${m2}.${p2}${z2} <${M2}.${+m2 + 1}.0-0`;
            }
          } else {
            ret = `>=${M2}.${m2}.${p2} <${+M2 + 1}.0.0-0`;
          }
        }
        debug2("caret return", ret);
        return ret;
      });
    };
    const replaceXRanges = (comp, options) => {
      debug2("replaceXRanges", comp, options);
      return comp.split(/\s+/).map((c2) => replaceXRange(c2, options)).join(" ");
    };
    const replaceXRange = (comp, options) => {
      comp = comp.trim();
      const r2 = options.loose ? re2[t2.XRANGELOOSE] : re2[t2.XRANGE];
      return comp.replace(r2, (ret, gtlt, M2, m2, p2, pr) => {
        debug2("xRange", comp, ret, gtlt, M2, m2, p2, pr);
        const xM = isX(M2);
        const xm = xM || isX(m2);
        const xp = xm || isX(p2);
        const anyX = xp;
        if (gtlt === "=" && anyX) {
          gtlt = "";
        }
        pr = options.includePrerelease ? "-0" : "";
        if (xM) {
          if (gtlt === ">" || gtlt === "<") {
            ret = "<0.0.0-0";
          } else {
            ret = "*";
          }
        } else if (gtlt && anyX) {
          if (xm) {
            m2 = 0;
          }
          p2 = 0;
          if (gtlt === ">") {
            gtlt = ">=";
            if (xm) {
              M2 = +M2 + 1;
              m2 = 0;
              p2 = 0;
            } else {
              m2 = +m2 + 1;
              p2 = 0;
            }
          } else if (gtlt === "<=") {
            gtlt = "<";
            if (xm) {
              M2 = +M2 + 1;
            } else {
              m2 = +m2 + 1;
            }
          }
          if (gtlt === "<") {
            pr = "-0";
          }
          ret = `${gtlt + M2}.${m2}.${p2}${pr}`;
        } else if (xm) {
          ret = `>=${M2}.0.0${pr} <${+M2 + 1}.0.0-0`;
        } else if (xp) {
          ret = `>=${M2}.${m2}.0${pr} <${M2}.${+m2 + 1}.0-0`;
        }
        debug2("xRange return", ret);
        return ret;
      });
    };
    const replaceStars = (comp, options) => {
      debug2("replaceStars", comp, options);
      return comp.trim().replace(re2[t2.STAR], "");
    };
    const replaceGTE0 = (comp, options) => {
      debug2("replaceGTE0", comp, options);
      return comp.trim().replace(re2[options.includePrerelease ? t2.GTE0PRE : t2.GTE0], "");
    };
    const hyphenReplace = (incPr) => ($0, from, fM, fm, fp, fpr, fb, to, tM, tm, tp, tpr) => {
      if (isX(fM)) {
        from = "";
      } else if (isX(fm)) {
        from = `>=${fM}.0.0${incPr ? "-0" : ""}`;
      } else if (isX(fp)) {
        from = `>=${fM}.${fm}.0${incPr ? "-0" : ""}`;
      } else if (fpr) {
        from = `>=${from}`;
      } else {
        from = `>=${from}${incPr ? "-0" : ""}`;
      }
      if (isX(tM)) {
        to = "";
      } else if (isX(tm)) {
        to = `<${+tM + 1}.0.0-0`;
      } else if (isX(tp)) {
        to = `<${tM}.${+tm + 1}.0-0`;
      } else if (tpr) {
        to = `<=${tM}.${tm}.${tp}-${tpr}`;
      } else if (incPr) {
        to = `<${tM}.${tm}.${+tp + 1}-0`;
      } else {
        to = `<=${to}`;
      }
      return `${from} ${to}`.trim();
    };
    const testSet = (set2, version2, options) => {
      for (let i2 = 0; i2 < set2.length; i2++) {
        if (!set2[i2].test(version2)) {
          return false;
        }
      }
      if (version2.prerelease.length && !options.includePrerelease) {
        for (let i2 = 0; i2 < set2.length; i2++) {
          debug2(set2[i2].semver);
          if (set2[i2].semver === Comparator2.ANY) {
            continue;
          }
          if (set2[i2].semver.prerelease.length > 0) {
            const allowed = set2[i2].semver;
            if (allowed.major === version2.major && allowed.minor === version2.minor && allowed.patch === version2.patch) {
              return true;
            }
          }
        }
        return false;
      }
      return true;
    };
    return range;
  }
  var comparator;
  var hasRequiredComparator;
  function requireComparator() {
    if (hasRequiredComparator) return comparator;
    hasRequiredComparator = 1;
    const ANY2 = Symbol("SemVer ANY");
    class Comparator2 {
      static get ANY() {
        return ANY2;
      }
      constructor(comp, options) {
        options = parseOptions2(options);
        if (comp instanceof Comparator2) {
          if (comp.loose === !!options.loose) {
            return comp;
          } else {
            comp = comp.value;
          }
        }
        comp = comp.trim().split(/\s+/).join(" ");
        debug2("comparator", comp, options);
        this.options = options;
        this.loose = !!options.loose;
        this.parse(comp);
        if (this.semver === ANY2) {
          this.value = "";
        } else {
          this.value = this.operator + this.semver.version;
        }
        debug2("comp", this);
      }
      parse(comp) {
        const r2 = this.options.loose ? re2[t2.COMPARATORLOOSE] : re2[t2.COMPARATOR];
        const m2 = comp.match(r2);
        if (!m2) {
          throw new TypeError(`Invalid comparator: ${comp}`);
        }
        this.operator = m2[1] !== void 0 ? m2[1] : "";
        if (this.operator === "=") {
          this.operator = "";
        }
        if (!m2[2]) {
          this.semver = ANY2;
        } else {
          this.semver = new SemVer2(m2[2], this.options.loose);
        }
      }
      toString() {
        return this.value;
      }
      test(version2) {
        debug2("Comparator.test", version2, this.options.loose);
        if (this.semver === ANY2 || version2 === ANY2) {
          return true;
        }
        if (typeof version2 === "string") {
          try {
            version2 = new SemVer2(version2, this.options);
          } catch (er) {
            return false;
          }
        }
        return cmp2(version2, this.operator, this.semver, this.options);
      }
      intersects(comp, options) {
        if (!(comp instanceof Comparator2)) {
          throw new TypeError("a Comparator is required");
        }
        if (this.operator === "") {
          if (this.value === "") {
            return true;
          }
          return new Range2(comp.value, options).test(this.value);
        } else if (comp.operator === "") {
          if (comp.value === "") {
            return true;
          }
          return new Range2(this.value, options).test(comp.semver);
        }
        options = parseOptions2(options);
        if (options.includePrerelease && (this.value === "<0.0.0-0" || comp.value === "<0.0.0-0")) {
          return false;
        }
        if (!options.includePrerelease && (this.value.startsWith("<0.0.0") || comp.value.startsWith("<0.0.0"))) {
          return false;
        }
        if (this.operator.startsWith(">") && comp.operator.startsWith(">")) {
          return true;
        }
        if (this.operator.startsWith("<") && comp.operator.startsWith("<")) {
          return true;
        }
        if (this.semver.version === comp.semver.version && this.operator.includes("=") && comp.operator.includes("=")) {
          return true;
        }
        if (cmp2(this.semver, "<", comp.semver, options) && this.operator.startsWith(">") && comp.operator.startsWith("<")) {
          return true;
        }
        if (cmp2(this.semver, ">", comp.semver, options) && this.operator.startsWith("<") && comp.operator.startsWith(">")) {
          return true;
        }
        return false;
      }
    }
    comparator = Comparator2;
    const parseOptions2 = parseOptions_1;
    const { safeRe: re2, t: t2 } = reExports;
    const cmp2 = cmp_1;
    const debug2 = debug_1;
    const SemVer2 = semver$1;
    const Range2 = requireRange();
    return comparator;
  }
  const Range$9 = requireRange();
  const satisfies$4 = (version2, range2, options) => {
    try {
      range2 = new Range$9(range2, options);
    } catch (er) {
      return false;
    }
    return range2.test(version2);
  };
  var satisfies_1 = satisfies$4;
  const Range$8 = requireRange();
  const toComparators$1 = (range2, options) => new Range$8(range2, options).set.map((comp) => comp.map((c2) => c2.value).join(" ").trim().split(" "));
  var toComparators_1 = toComparators$1;
  const SemVer$4 = semver$1;
  const Range$7 = requireRange();
  const maxSatisfying$1 = (versions, range2, options) => {
    let max2 = null;
    let maxSV = null;
    let rangeObj = null;
    try {
      rangeObj = new Range$7(range2, options);
    } catch (er) {
      return null;
    }
    versions.forEach((v2) => {
      if (rangeObj.test(v2)) {
        if (!max2 || maxSV.compare(v2) === -1) {
          max2 = v2;
          maxSV = new SemVer$4(max2, options);
        }
      }
    });
    return max2;
  };
  var maxSatisfying_1 = maxSatisfying$1;
  const SemVer$3 = semver$1;
  const Range$6 = requireRange();
  const minSatisfying$1 = (versions, range2, options) => {
    let min = null;
    let minSV = null;
    let rangeObj = null;
    try {
      rangeObj = new Range$6(range2, options);
    } catch (er) {
      return null;
    }
    versions.forEach((v2) => {
      if (rangeObj.test(v2)) {
        if (!min || minSV.compare(v2) === 1) {
          min = v2;
          minSV = new SemVer$3(min, options);
        }
      }
    });
    return min;
  };
  var minSatisfying_1 = minSatisfying$1;
  const SemVer$2 = semver$1;
  const Range$5 = requireRange();
  const gt$2 = gt_1;
  const minVersion$1 = (range2, loose) => {
    range2 = new Range$5(range2, loose);
    let minver = new SemVer$2("0.0.0");
    if (range2.test(minver)) {
      return minver;
    }
    minver = new SemVer$2("0.0.0-0");
    if (range2.test(minver)) {
      return minver;
    }
    minver = null;
    for (let i2 = 0; i2 < range2.set.length; ++i2) {
      const comparators = range2.set[i2];
      let setMin = null;
      comparators.forEach((comparator2) => {
        const compver = new SemVer$2(comparator2.semver.version);
        switch (comparator2.operator) {
          case ">":
            if (compver.prerelease.length === 0) {
              compver.patch++;
            } else {
              compver.prerelease.push(0);
            }
            compver.raw = compver.format();
          case "":
          case ">=":
            if (!setMin || gt$2(compver, setMin)) {
              setMin = compver;
            }
            break;
          case "<":
          case "<=":
            break;
          default:
            throw new Error(`Unexpected operation: ${comparator2.operator}`);
        }
      });
      if (setMin && (!minver || gt$2(minver, setMin))) {
        minver = setMin;
      }
    }
    if (minver && range2.test(minver)) {
      return minver;
    }
    return null;
  };
  var minVersion_1 = minVersion$1;
  const Range$4 = requireRange();
  const validRange$1 = (range2, options) => {
    try {
      return new Range$4(range2, options).range || "*";
    } catch (er) {
      return null;
    }
  };
  var valid$1 = validRange$1;
  const SemVer$1 = semver$1;
  const Comparator$2 = requireComparator();
  const { ANY: ANY$1 } = Comparator$2;
  const Range$3 = requireRange();
  const satisfies$3 = satisfies_1;
  const gt$1 = gt_1;
  const lt$1 = lt_1;
  const lte$1 = lte_1;
  const gte$1 = gte_1;
  const outside$3 = (version2, range2, hilo, options) => {
    version2 = new SemVer$1(version2, options);
    range2 = new Range$3(range2, options);
    let gtfn, ltefn, ltfn, comp, ecomp;
    switch (hilo) {
      case ">":
        gtfn = gt$1;
        ltefn = lte$1;
        ltfn = lt$1;
        comp = ">";
        ecomp = ">=";
        break;
      case "<":
        gtfn = lt$1;
        ltefn = gte$1;
        ltfn = gt$1;
        comp = "<";
        ecomp = "<=";
        break;
      default:
        throw new TypeError('Must provide a hilo val of "<" or ">"');
    }
    if (satisfies$3(version2, range2, options)) {
      return false;
    }
    for (let i2 = 0; i2 < range2.set.length; ++i2) {
      const comparators = range2.set[i2];
      let high = null;
      let low = null;
      comparators.forEach((comparator2) => {
        if (comparator2.semver === ANY$1) {
          comparator2 = new Comparator$2(">=0.0.0");
        }
        high = high || comparator2;
        low = low || comparator2;
        if (gtfn(comparator2.semver, high.semver, options)) {
          high = comparator2;
        } else if (ltfn(comparator2.semver, low.semver, options)) {
          low = comparator2;
        }
      });
      if (high.operator === comp || high.operator === ecomp) {
        return false;
      }
      if ((!low.operator || low.operator === comp) && ltefn(version2, low.semver)) {
        return false;
      } else if (low.operator === ecomp && ltfn(version2, low.semver)) {
        return false;
      }
    }
    return true;
  };
  var outside_1 = outside$3;
  const outside$2 = outside_1;
  const gtr$1 = (version2, range2, options) => outside$2(version2, range2, ">", options);
  var gtr_1 = gtr$1;
  const outside$1 = outside_1;
  const ltr$1 = (version2, range2, options) => outside$1(version2, range2, "<", options);
  var ltr_1 = ltr$1;
  const Range$2 = requireRange();
  const intersects$1 = (r1, r2, options) => {
    r1 = new Range$2(r1, options);
    r2 = new Range$2(r2, options);
    return r1.intersects(r2, options);
  };
  var intersects_1 = intersects$1;
  const satisfies$2 = satisfies_1;
  const compare$2 = compare_1;
  var simplify = (versions, range2, options) => {
    const set2 = [];
    let first = null;
    let prev = null;
    const v2 = versions.sort((a2, b2) => compare$2(a2, b2, options));
    for (const version2 of v2) {
      const included = satisfies$2(version2, range2, options);
      if (included) {
        prev = version2;
        if (!first) {
          first = version2;
        }
      } else {
        if (prev) {
          set2.push([first, prev]);
        }
        prev = null;
        first = null;
      }
    }
    if (first) {
      set2.push([first, null]);
    }
    const ranges = [];
    for (const [min, max2] of set2) {
      if (min === max2) {
        ranges.push(min);
      } else if (!max2 && min === v2[0]) {
        ranges.push("*");
      } else if (!max2) {
        ranges.push(`>=${min}`);
      } else if (min === v2[0]) {
        ranges.push(`<=${max2}`);
      } else {
        ranges.push(`${min} - ${max2}`);
      }
    }
    const simplified = ranges.join(" || ");
    const original = typeof range2.raw === "string" ? range2.raw : String(range2);
    return simplified.length < original.length ? simplified : range2;
  };
  const Range$1 = requireRange();
  const Comparator$1 = requireComparator();
  const { ANY } = Comparator$1;
  const satisfies$1 = satisfies_1;
  const compare$1 = compare_1;
  const subset$1 = (sub, dom, options = {}) => {
    if (sub === dom) {
      return true;
    }
    sub = new Range$1(sub, options);
    dom = new Range$1(dom, options);
    let sawNonNull = false;
    OUTER: for (const simpleSub of sub.set) {
      for (const simpleDom of dom.set) {
        const isSub = simpleSubset(simpleSub, simpleDom, options);
        sawNonNull = sawNonNull || isSub !== null;
        if (isSub) {
          continue OUTER;
        }
      }
      if (sawNonNull) {
        return false;
      }
    }
    return true;
  };
  const minimumVersionWithPreRelease = [new Comparator$1(">=0.0.0-0")];
  const minimumVersion = [new Comparator$1(">=0.0.0")];
  const simpleSubset = (sub, dom, options) => {
    if (sub === dom) {
      return true;
    }
    if (sub.length === 1 && sub[0].semver === ANY) {
      if (dom.length === 1 && dom[0].semver === ANY) {
        return true;
      } else if (options.includePrerelease) {
        sub = minimumVersionWithPreRelease;
      } else {
        sub = minimumVersion;
      }
    }
    if (dom.length === 1 && dom[0].semver === ANY) {
      if (options.includePrerelease) {
        return true;
      } else {
        dom = minimumVersion;
      }
    }
    const eqSet = /* @__PURE__ */ new Set();
    let gt2, lt2;
    for (const c2 of sub) {
      if (c2.operator === ">" || c2.operator === ">=") {
        gt2 = higherGT(gt2, c2, options);
      } else if (c2.operator === "<" || c2.operator === "<=") {
        lt2 = lowerLT(lt2, c2, options);
      } else {
        eqSet.add(c2.semver);
      }
    }
    if (eqSet.size > 1) {
      return null;
    }
    let gtltComp;
    if (gt2 && lt2) {
      gtltComp = compare$1(gt2.semver, lt2.semver, options);
      if (gtltComp > 0) {
        return null;
      } else if (gtltComp === 0 && (gt2.operator !== ">=" || lt2.operator !== "<=")) {
        return null;
      }
    }
    for (const eq2 of eqSet) {
      if (gt2 && !satisfies$1(eq2, String(gt2), options)) {
        return null;
      }
      if (lt2 && !satisfies$1(eq2, String(lt2), options)) {
        return null;
      }
      for (const c2 of dom) {
        if (!satisfies$1(eq2, String(c2), options)) {
          return false;
        }
      }
      return true;
    }
    let higher, lower;
    let hasDomLT, hasDomGT;
    let needDomLTPre = lt2 && !options.includePrerelease && lt2.semver.prerelease.length ? lt2.semver : false;
    let needDomGTPre = gt2 && !options.includePrerelease && gt2.semver.prerelease.length ? gt2.semver : false;
    if (needDomLTPre && needDomLTPre.prerelease.length === 1 && lt2.operator === "<" && needDomLTPre.prerelease[0] === 0) {
      needDomLTPre = false;
    }
    for (const c2 of dom) {
      hasDomGT = hasDomGT || c2.operator === ">" || c2.operator === ">=";
      hasDomLT = hasDomLT || c2.operator === "<" || c2.operator === "<=";
      if (gt2) {
        if (needDomGTPre) {
          if (c2.semver.prerelease && c2.semver.prerelease.length && c2.semver.major === needDomGTPre.major && c2.semver.minor === needDomGTPre.minor && c2.semver.patch === needDomGTPre.patch) {
            needDomGTPre = false;
          }
        }
        if (c2.operator === ">" || c2.operator === ">=") {
          higher = higherGT(gt2, c2, options);
          if (higher === c2 && higher !== gt2) {
            return false;
          }
        } else if (gt2.operator === ">=" && !satisfies$1(gt2.semver, String(c2), options)) {
          return false;
        }
      }
      if (lt2) {
        if (needDomLTPre) {
          if (c2.semver.prerelease && c2.semver.prerelease.length && c2.semver.major === needDomLTPre.major && c2.semver.minor === needDomLTPre.minor && c2.semver.patch === needDomLTPre.patch) {
            needDomLTPre = false;
          }
        }
        if (c2.operator === "<" || c2.operator === "<=") {
          lower = lowerLT(lt2, c2, options);
          if (lower === c2 && lower !== lt2) {
            return false;
          }
        } else if (lt2.operator === "<=" && !satisfies$1(lt2.semver, String(c2), options)) {
          return false;
        }
      }
      if (!c2.operator && (lt2 || gt2) && gtltComp !== 0) {
        return false;
      }
    }
    if (gt2 && hasDomLT && !lt2 && gtltComp !== 0) {
      return false;
    }
    if (lt2 && hasDomGT && !gt2 && gtltComp !== 0) {
      return false;
    }
    if (needDomGTPre || needDomLTPre) {
      return false;
    }
    return true;
  };
  const higherGT = (a2, b2, options) => {
    if (!a2) {
      return b2;
    }
    const comp = compare$1(a2.semver, b2.semver, options);
    return comp > 0 ? a2 : comp < 0 ? b2 : b2.operator === ">" && a2.operator === ">=" ? b2 : a2;
  };
  const lowerLT = (a2, b2, options) => {
    if (!a2) {
      return b2;
    }
    const comp = compare$1(a2.semver, b2.semver, options);
    return comp < 0 ? a2 : comp > 0 ? b2 : b2.operator === "<" && a2.operator === "<=" ? b2 : a2;
  };
  var subset_1 = subset$1;
  const internalRe = reExports;
  const constants$2 = constants$3;
  const SemVer = semver$1;
  const identifiers = identifiers$1;
  const parse$5 = parse_1$2;
  const valid = valid_1;
  const clean = clean_1;
  const inc = inc_1;
  const diff = diff_1;
  const major = major_1;
  const minor = minor_1;
  const patch = patch_1;
  const prerelease = prerelease_1;
  const compare = compare_1;
  const rcompare = rcompare_1;
  const compareLoose = compareLoose_1;
  const compareBuild = compareBuild_1;
  const sort = sort_1;
  const rsort = rsort_1;
  const gt = gt_1;
  const lt = lt_1;
  const eq$1 = eq_1;
  const neq = neq_1;
  const gte = gte_1;
  const lte = lte_1;
  const cmp = cmp_1;
  const coerce = coerce_1;
  const Comparator = requireComparator();
  const Range = requireRange();
  const satisfies = satisfies_1;
  const toComparators = toComparators_1;
  const maxSatisfying = maxSatisfying_1;
  const minSatisfying = minSatisfying_1;
  const minVersion = minVersion_1;
  const validRange = valid$1;
  const outside = outside_1;
  const gtr = gtr_1;
  const ltr = ltr_1;
  const intersects = intersects_1;
  const simplifyRange = simplify;
  const subset = subset_1;
  var semver = {
    parse: parse$5,
    valid,
    clean,
    inc,
    diff,
    major,
    minor,
    patch,
    prerelease,
    compare,
    rcompare,
    compareLoose,
    compareBuild,
    sort,
    rsort,
    gt,
    lt,
    eq: eq$1,
    neq,
    gte,
    lte,
    cmp,
    coerce,
    Comparator,
    Range,
    satisfies,
    toComparators,
    maxSatisfying,
    minSatisfying,
    minVersion,
    validRange,
    outside,
    gtr,
    ltr,
    intersects,
    simplifyRange,
    subset,
    SemVer,
    re: internalRe.re,
    src: internalRe.src,
    tokens: internalRe.t,
    SEMVER_SPEC_VERSION: constants$2.SEMVER_SPEC_VERSION,
    RELEASE_TYPES: constants$2.RELEASE_TYPES,
    compareIdentifiers: identifiers.compareIdentifiers,
    rcompareIdentifiers: identifiers.rcompareIdentifiers
  };
  function isFunction$3(funktion) {
    return typeof funktion === "function";
  }
  var logger$1 = console.error.bind(console);
  function defineProperty(obj, name2, value) {
    var enumerable = !!obj[name2] && obj.propertyIsEnumerable(name2);
    Object.defineProperty(obj, name2, {
      configurable: true,
      enumerable,
      writable: true,
      value
    });
  }
  function shimmer(options) {
    if (options && options.logger) {
      if (!isFunction$3(options.logger)) logger$1("new logger isn't a function, not replacing");
      else logger$1 = options.logger;
    }
  }
  function wrap(nodule, name2, wrapper) {
    if (!nodule || !nodule[name2]) {
      logger$1("no original function " + name2 + " to wrap");
      return;
    }
    if (!wrapper) {
      logger$1("no wrapper function");
      logger$1(new Error().stack);
      return;
    }
    if (!isFunction$3(nodule[name2]) || !isFunction$3(wrapper)) {
      logger$1("original object and wrapper must be functions");
      return;
    }
    var original = nodule[name2];
    var wrapped = wrapper(original, name2);
    defineProperty(wrapped, "__original", original);
    defineProperty(wrapped, "__unwrap", function() {
      if (nodule[name2] === wrapped) defineProperty(nodule, name2, original);
    });
    defineProperty(wrapped, "__wrapped", true);
    defineProperty(nodule, name2, wrapped);
    return wrapped;
  }
  function massWrap(nodules, names, wrapper) {
    if (!nodules) {
      logger$1("must provide one or more modules to patch");
      logger$1(new Error().stack);
      return;
    } else if (!Array.isArray(nodules)) {
      nodules = [nodules];
    }
    if (!(names && Array.isArray(names))) {
      logger$1("must provide one or more functions to wrap on modules");
      return;
    }
    nodules.forEach(function(nodule) {
      names.forEach(function(name2) {
        wrap(nodule, name2, wrapper);
      });
    });
  }
  function unwrap(nodule, name2) {
    if (!nodule || !nodule[name2]) {
      logger$1("no function to unwrap.");
      logger$1(new Error().stack);
      return;
    }
    if (!nodule[name2].__unwrap) {
      logger$1("no original to unwrap to -- has " + name2 + " already been unwrapped?");
    } else {
      return nodule[name2].__unwrap();
    }
  }
  function massUnwrap(nodules, names) {
    if (!nodules) {
      logger$1("must provide one or more modules to patch");
      logger$1(new Error().stack);
      return;
    } else if (!Array.isArray(nodules)) {
      nodules = [nodules];
    }
    if (!(names && Array.isArray(names))) {
      logger$1("must provide one or more functions to unwrap on modules");
      return;
    }
    nodules.forEach(function(nodule) {
      names.forEach(function(name2) {
        unwrap(nodule, name2);
      });
    });
  }
  shimmer.wrap = wrap;
  shimmer.massWrap = massWrap;
  shimmer.unwrap = unwrap;
  shimmer.massUnwrap = massUnwrap;
  var shimmer_1 = shimmer;
  var requireInTheMiddle = { exports: {} };
  var os$7 = require$$0$1;
  var homedir$2 = os$7.homedir || function homedir2() {
    var home = process.env.HOME;
    var user = process.env.LOGNAME || process.env.USER || process.env.LNAME || process.env.USERNAME;
    if (process.platform === "win32") {
      return process.env.USERPROFILE || process.env.HOMEDRIVE + process.env.HOMEPATH || home || null;
    }
    if (process.platform === "darwin") {
      return home || (user ? "/Users/" + user : null);
    }
    if (process.platform === "linux") {
      return home || (process.getuid() === 0 ? "/root" : user ? "/home/" + user : null);
    }
    return home || null;
  };
  var caller$2 = function() {
    var origPrepareStackTrace = Error.prepareStackTrace;
    Error.prepareStackTrace = function(_2, stack2) {
      return stack2;
    };
    var stack = new Error().stack;
    Error.prepareStackTrace = origPrepareStackTrace;
    return stack[2].getFileName();
  };
  var pathParse = { exports: {} };
  var hasRequiredPathParse;
  function requirePathParse() {
    if (hasRequiredPathParse) return pathParse.exports;
    hasRequiredPathParse = 1;
    var isWindows2 = process.platform === "win32";
    var splitWindowsRe = /^(((?:[a-zA-Z]:|[\\\/]{2}[^\\\/]+[\\\/]+[^\\\/]+)?[\\\/]?)(?:[^\\\/]*[\\\/])*)((\.{1,2}|[^\\\/]+?|)(\.[^.\/\\]*|))[\\\/]*$/;
    var win32 = {};
    function win32SplitPath(filename) {
      return splitWindowsRe.exec(filename).slice(1);
    }
    win32.parse = function(pathString) {
      if (typeof pathString !== "string") {
        throw new TypeError(
          "Parameter 'pathString' must be a string, not " + typeof pathString
        );
      }
      var allParts = win32SplitPath(pathString);
      if (!allParts || allParts.length !== 5) {
        throw new TypeError("Invalid path '" + pathString + "'");
      }
      return {
        root: allParts[1],
        dir: allParts[0] === allParts[1] ? allParts[0] : allParts[0].slice(0, -1),
        base: allParts[2],
        ext: allParts[4],
        name: allParts[3]
      };
    };
    var splitPathRe2 = /^((\/?)(?:[^\/]*\/)*)((\.{1,2}|[^\/]+?|)(\.[^.\/]*|))[\/]*$/;
    var posix = {};
    function posixSplitPath(filename) {
      return splitPathRe2.exec(filename).slice(1);
    }
    posix.parse = function(pathString) {
      if (typeof pathString !== "string") {
        throw new TypeError(
          "Parameter 'pathString' must be a string, not " + typeof pathString
        );
      }
      var allParts = posixSplitPath(pathString);
      if (!allParts || allParts.length !== 5) {
        throw new TypeError("Invalid path '" + pathString + "'");
      }
      return {
        root: allParts[1],
        dir: allParts[0].slice(0, -1),
        base: allParts[2],
        ext: allParts[4],
        name: allParts[3]
      };
    };
    if (isWindows2)
      pathParse.exports = win32.parse;
    else
      pathParse.exports = posix.parse;
    pathParse.exports.posix = posix.parse;
    pathParse.exports.win32 = win32.parse;
    return pathParse.exports;
  }
  var path$j = path$k;
  var parse$4 = path$j.parse || requirePathParse();
  var getNodeModulesDirs = function getNodeModulesDirs2(absoluteStart, modules) {
    var prefix = "/";
    if (/^([A-Za-z]:)/.test(absoluteStart)) {
      prefix = "";
    } else if (/^\\\\/.test(absoluteStart)) {
      prefix = "\\\\";
    }
    var paths = [absoluteStart];
    var parsed2 = parse$4(absoluteStart);
    while (parsed2.dir !== paths[paths.length - 1]) {
      paths.push(parsed2.dir);
      parsed2 = parse$4(parsed2.dir);
    }
    return paths.reduce(function(dirs, aPath) {
      return dirs.concat(modules.map(function(moduleDir) {
        return path$j.resolve(prefix, aPath, moduleDir);
      }));
    }, []);
  };
  var nodeModulesPaths$2 = function nodeModulesPaths2(start, opts, request) {
    var modules = opts && opts.moduleDirectory ? [].concat(opts.moduleDirectory) : ["node_modules"];
    if (opts && typeof opts.paths === "function") {
      return opts.paths(
        request,
        start,
        function() {
          return getNodeModulesDirs(start, modules);
        },
        opts
      );
    }
    var dirs = getNodeModulesDirs(start, modules);
    return opts && opts.paths ? dirs.concat(opts.paths) : dirs;
  };
  var normalizeOptions$3 = function(x2, opts) {
    return opts || {};
  };
  var ERROR_MESSAGE = "Function.prototype.bind called on incompatible ";
  var toStr = Object.prototype.toString;
  var max = Math.max;
  var funcType = "[object Function]";
  var concatty = function concatty2(a2, b2) {
    var arr = [];
    for (var i2 = 0; i2 < a2.length; i2 += 1) {
      arr[i2] = a2[i2];
    }
    for (var j2 = 0; j2 < b2.length; j2 += 1) {
      arr[j2 + a2.length] = b2[j2];
    }
    return arr;
  };
  var slicy = function slicy2(arrLike, offset) {
    var arr = [];
    for (var i2 = offset, j2 = 0; i2 < arrLike.length; i2 += 1, j2 += 1) {
      arr[j2] = arrLike[i2];
    }
    return arr;
  };
  var joiny = function(arr, joiner) {
    var str = "";
    for (var i2 = 0; i2 < arr.length; i2 += 1) {
      str += arr[i2];
      if (i2 + 1 < arr.length) {
        str += joiner;
      }
    }
    return str;
  };
  var implementation$1 = function bind2(that) {
    var target = this;
    if (typeof target !== "function" || toStr.apply(target) !== funcType) {
      throw new TypeError(ERROR_MESSAGE + target);
    }
    var args2 = slicy(arguments, 1);
    var bound;
    var binder = function() {
      if (this instanceof bound) {
        var result = target.apply(
          this,
          concatty(args2, arguments)
        );
        if (Object(result) === result) {
          return result;
        }
        return this;
      }
      return target.apply(
        that,
        concatty(args2, arguments)
      );
    };
    var boundLength = max(0, target.length - args2.length);
    var boundArgs = [];
    for (var i2 = 0; i2 < boundLength; i2++) {
      boundArgs[i2] = "$" + i2;
    }
    bound = Function("binder", "return function (" + joiny(boundArgs, ",") + "){ return binder.apply(this,arguments); }")(binder);
    if (target.prototype) {
      var Empty = function Empty2() {
      };
      Empty.prototype = target.prototype;
      bound.prototype = new Empty();
      Empty.prototype = null;
    }
    return bound;
  };
  var implementation = implementation$1;
  var functionBind = Function.prototype.bind || implementation;
  var call = Function.prototype.call;
  var $hasOwn = Object.prototype.hasOwnProperty;
  var bind = functionBind;
  var hasown = bind.call(call, $hasOwn);
  const assert$3 = true;
  const async_hooks$1 = ">= 8";
  const buffer_ieee754$1 = ">= 0.5 && < 0.9.7";
  const buffer$1 = true;
  const child_process$1 = true;
  const cluster$1 = ">= 0.5";
  const console$2 = true;
  const constants$1 = true;
  const crypto$3 = true;
  const _debug_agent$1 = ">= 1 && < 8";
  const _debugger$1 = "< 8";
  const dgram$1 = true;
  const diagnostics_channel$1 = [
    ">= 14.17 && < 15",
    ">= 15.1"
  ];
  const dns$1 = true;
  const domain$1 = ">= 0.7.12";
  const events$1 = true;
  const freelist$1 = "< 6";
  const fs$a = true;
  const _http_agent$1 = ">= 0.11.1";
  const _http_client$1 = ">= 0.11.1";
  const _http_common$1 = ">= 0.11.1";
  const _http_incoming$1 = ">= 0.11.1";
  const _http_outgoing$1 = ">= 0.11.1";
  const _http_server$1 = ">= 0.11.1";
  const http$2 = true;
  const http2$1 = ">= 8.8";
  const https$2 = true;
  const inspector$1 = ">= 8";
  const _linklist$1 = "< 8";
  const module$2 = true;
  const net$1 = true;
  const os$6 = true;
  const path$i = true;
  const perf_hooks$1 = ">= 8.5";
  const process$3 = ">= 1";
  const punycode$1 = ">= 0.5";
  const querystring$1 = true;
  const readline$1 = true;
  const repl$1 = true;
  const smalloc$1 = ">= 0.11.5 && < 3";
  const _stream_duplex$1 = ">= 0.9.4";
  const _stream_transform$1 = ">= 0.9.4";
  const _stream_wrap$1 = ">= 1.4.1";
  const _stream_passthrough$1 = ">= 0.9.4";
  const _stream_readable$1 = ">= 0.9.4";
  const _stream_writable$1 = ">= 0.9.4";
  const stream$3 = true;
  const string_decoder$1 = true;
  const sys$1 = [
    ">= 0.4 && < 0.7",
    ">= 0.8"
  ];
  const timers$1 = true;
  const _tls_common$1 = ">= 0.11.13";
  const _tls_legacy$1 = ">= 0.11.3 && < 10";
  const _tls_wrap$1 = ">= 0.11.3";
  const tls$1 = true;
  const trace_events$1 = ">= 10";
  const tty$1 = true;
  const url$1 = true;
  const util$a = true;
  const v8$1 = ">= 1";
  const vm$1 = true;
  const wasi$1 = [
    ">= 13.4 && < 13.5",
    ">= 18.17 && < 19",
    ">= 20"
  ];
  const worker_threads$1 = ">= 11.7";
  const zlib$1 = ">= 0.5";
  const require$$1$2 = {
    assert: assert$3,
    "node:assert": [
      ">= 14.18 && < 15",
      ">= 16"
    ],
    "assert/strict": ">= 15",
    "node:assert/strict": ">= 16",
    async_hooks: async_hooks$1,
    "node:async_hooks": [
      ">= 14.18 && < 15",
      ">= 16"
    ],
    buffer_ieee754: buffer_ieee754$1,
    buffer: buffer$1,
    "node:buffer": [
      ">= 14.18 && < 15",
      ">= 16"
    ],
    child_process: child_process$1,
    "node:child_process": [
      ">= 14.18 && < 15",
      ">= 16"
    ],
    cluster: cluster$1,
    "node:cluster": [
      ">= 14.18 && < 15",
      ">= 16"
    ],
    console: console$2,
    "node:console": [
      ">= 14.18 && < 15",
      ">= 16"
    ],
    constants: constants$1,
    "node:constants": [
      ">= 14.18 && < 15",
      ">= 16"
    ],
    crypto: crypto$3,
    "node:crypto": [
      ">= 14.18 && < 15",
      ">= 16"
    ],
    _debug_agent: _debug_agent$1,
    _debugger: _debugger$1,
    dgram: dgram$1,
    "node:dgram": [
      ">= 14.18 && < 15",
      ">= 16"
    ],
    diagnostics_channel: diagnostics_channel$1,
    "node:diagnostics_channel": [
      ">= 14.18 && < 15",
      ">= 16"
    ],
    dns: dns$1,
    "node:dns": [
      ">= 14.18 && < 15",
      ">= 16"
    ],
    "dns/promises": ">= 15",
    "node:dns/promises": ">= 16",
    domain: domain$1,
    "node:domain": [
      ">= 14.18 && < 15",
      ">= 16"
    ],
    events: events$1,
    "node:events": [
      ">= 14.18 && < 15",
      ">= 16"
    ],
    freelist: freelist$1,
    fs: fs$a,
    "node:fs": [
      ">= 14.18 && < 15",
      ">= 16"
    ],
    "fs/promises": [
      ">= 10 && < 10.1",
      ">= 14"
    ],
    "node:fs/promises": [
      ">= 14.18 && < 15",
      ">= 16"
    ],
    _http_agent: _http_agent$1,
    "node:_http_agent": [
      ">= 14.18 && < 15",
      ">= 16"
    ],
    _http_client: _http_client$1,
    "node:_http_client": [
      ">= 14.18 && < 15",
      ">= 16"
    ],
    _http_common: _http_common$1,
    "node:_http_common": [
      ">= 14.18 && < 15",
      ">= 16"
    ],
    _http_incoming: _http_incoming$1,
    "node:_http_incoming": [
      ">= 14.18 && < 15",
      ">= 16"
    ],
    _http_outgoing: _http_outgoing$1,
    "node:_http_outgoing": [
      ">= 14.18 && < 15",
      ">= 16"
    ],
    _http_server: _http_server$1,
    "node:_http_server": [
      ">= 14.18 && < 15",
      ">= 16"
    ],
    http: http$2,
    "node:http": [
      ">= 14.18 && < 15",
      ">= 16"
    ],
    http2: http2$1,
    "node:http2": [
      ">= 14.18 && < 15",
      ">= 16"
    ],
    https: https$2,
    "node:https": [
      ">= 14.18 && < 15",
      ">= 16"
    ],
    inspector: inspector$1,
    "node:inspector": [
      ">= 14.18 && < 15",
      ">= 16"
    ],
    "inspector/promises": [
      ">= 19"
    ],
    "node:inspector/promises": [
      ">= 19"
    ],
    _linklist: _linklist$1,
    module: module$2,
    "node:module": [
      ">= 14.18 && < 15",
      ">= 16"
    ],
    net: net$1,
    "node:net": [
      ">= 14.18 && < 15",
      ">= 16"
    ],
    "node-inspect/lib/_inspect": ">= 7.6 && < 12",
    "node-inspect/lib/internal/inspect_client": ">= 7.6 && < 12",
    "node-inspect/lib/internal/inspect_repl": ">= 7.6 && < 12",
    os: os$6,
    "node:os": [
      ">= 14.18 && < 15",
      ">= 16"
    ],
    path: path$i,
    "node:path": [
      ">= 14.18 && < 15",
      ">= 16"
    ],
    "path/posix": ">= 15.3",
    "node:path/posix": ">= 16",
    "path/win32": ">= 15.3",
    "node:path/win32": ">= 16",
    perf_hooks: perf_hooks$1,
    "node:perf_hooks": [
      ">= 14.18 && < 15",
      ">= 16"
    ],
    process: process$3,
    "node:process": [
      ">= 14.18 && < 15",
      ">= 16"
    ],
    punycode: punycode$1,
    "node:punycode": [
      ">= 14.18 && < 15",
      ">= 16"
    ],
    querystring: querystring$1,
    "node:querystring": [
      ">= 14.18 && < 15",
      ">= 16"
    ],
    readline: readline$1,
    "node:readline": [
      ">= 14.18 && < 15",
      ">= 16"
    ],
    "readline/promises": ">= 17",
    "node:readline/promises": ">= 17",
    repl: repl$1,
    "node:repl": [
      ">= 14.18 && < 15",
      ">= 16"
    ],
    "node:sea": [
      ">= 20.12 && < 21",
      ">= 21.7"
    ],
    smalloc: smalloc$1,
    "node:sqlite": ">= 23.4",
    _stream_duplex: _stream_duplex$1,
    "node:_stream_duplex": [
      ">= 14.18 && < 15",
      ">= 16"
    ],
    _stream_transform: _stream_transform$1,
    "node:_stream_transform": [
      ">= 14.18 && < 15",
      ">= 16"
    ],
    _stream_wrap: _stream_wrap$1,
    "node:_stream_wrap": [
      ">= 14.18 && < 15",
      ">= 16"
    ],
    _stream_passthrough: _stream_passthrough$1,
    "node:_stream_passthrough": [
      ">= 14.18 && < 15",
      ">= 16"
    ],
    _stream_readable: _stream_readable$1,
    "node:_stream_readable": [
      ">= 14.18 && < 15",
      ">= 16"
    ],
    _stream_writable: _stream_writable$1,
    "node:_stream_writable": [
      ">= 14.18 && < 15",
      ">= 16"
    ],
    stream: stream$3,
    "node:stream": [
      ">= 14.18 && < 15",
      ">= 16"
    ],
    "stream/consumers": ">= 16.7",
    "node:stream/consumers": ">= 16.7",
    "stream/promises": ">= 15",
    "node:stream/promises": ">= 16",
    "stream/web": ">= 16.5",
    "node:stream/web": ">= 16.5",
    string_decoder: string_decoder$1,
    "node:string_decoder": [
      ">= 14.18 && < 15",
      ">= 16"
    ],
    sys: sys$1,
    "node:sys": [
      ">= 14.18 && < 15",
      ">= 16"
    ],
    "test/reporters": ">= 19.9 && < 20.2",
    "node:test/reporters": [
      ">= 18.17 && < 19",
      ">= 19.9",
      ">= 20"
    ],
    "test/mock_loader": ">= 22.3 && < 22.7",
    "node:test/mock_loader": ">= 22.3 && < 22.7",
    "node:test": [
      ">= 16.17 && < 17",
      ">= 18"
    ],
    timers: timers$1,
    "node:timers": [
      ">= 14.18 && < 15",
      ">= 16"
    ],
    "timers/promises": ">= 15",
    "node:timers/promises": ">= 16",
    _tls_common: _tls_common$1,
    "node:_tls_common": [
      ">= 14.18 && < 15",
      ">= 16"
    ],
    _tls_legacy: _tls_legacy$1,
    _tls_wrap: _tls_wrap$1,
    "node:_tls_wrap": [
      ">= 14.18 && < 15",
      ">= 16"
    ],
    tls: tls$1,
    "node:tls": [
      ">= 14.18 && < 15",
      ">= 16"
    ],
    trace_events: trace_events$1,
    "node:trace_events": [
      ">= 14.18 && < 15",
      ">= 16"
    ],
    tty: tty$1,
    "node:tty": [
      ">= 14.18 && < 15",
      ">= 16"
    ],
    url: url$1,
    "node:url": [
      ">= 14.18 && < 15",
      ">= 16"
    ],
    util: util$a,
    "node:util": [
      ">= 14.18 && < 15",
      ">= 16"
    ],
    "util/types": ">= 15.3",
    "node:util/types": ">= 16",
    "v8/tools/arguments": ">= 10 && < 12",
    "v8/tools/codemap": [
      ">= 4.4 && < 5",
      ">= 5.2 && < 12"
    ],
    "v8/tools/consarray": [
      ">= 4.4 && < 5",
      ">= 5.2 && < 12"
    ],
    "v8/tools/csvparser": [
      ">= 4.4 && < 5",
      ">= 5.2 && < 12"
    ],
    "v8/tools/logreader": [
      ">= 4.4 && < 5",
      ">= 5.2 && < 12"
    ],
    "v8/tools/profile_view": [
      ">= 4.4 && < 5",
      ">= 5.2 && < 12"
    ],
    "v8/tools/splaytree": [
      ">= 4.4 && < 5",
      ">= 5.2 && < 12"
    ],
    v8: v8$1,
    "node:v8": [
      ">= 14.18 && < 15",
      ">= 16"
    ],
    vm: vm$1,
    "node:vm": [
      ">= 14.18 && < 15",
      ">= 16"
    ],
    wasi: wasi$1,
    "node:wasi": [
      ">= 18.17 && < 19",
      ">= 20"
    ],
    worker_threads: worker_threads$1,
    "node:worker_threads": [
      ">= 14.18 && < 15",
      ">= 16"
    ],
    zlib: zlib$1,
    "node:zlib": [
      ">= 14.18 && < 15",
      ">= 16"
    ]
  };
  var hasOwn = hasown;
  function specifierIncluded(current, specifier) {
    var nodeParts = current.split(".");
    var parts = specifier.split(" ");
    var op = parts.length > 1 ? parts[0] : "=";
    var versionParts = (parts.length > 1 ? parts[1] : parts[0]).split(".");
    for (var i2 = 0; i2 < 3; ++i2) {
      var cur = parseInt(nodeParts[i2] || 0, 10);
      var ver = parseInt(versionParts[i2] || 0, 10);
      if (cur === ver) {
        continue;
      }
      if (op === "<") {
        return cur < ver;
      }
      if (op === ">=") {
        return cur >= ver;
      }
      return false;
    }
    return op === ">=";
  }
  function matchesRange(current, range2) {
    var specifiers2 = range2.split(/ ?&& ?/);
    if (specifiers2.length === 0) {
      return false;
    }
    for (var i2 = 0; i2 < specifiers2.length; ++i2) {
      if (!specifierIncluded(current, specifiers2[i2])) {
        return false;
      }
    }
    return true;
  }
  function versionIncluded(nodeVersion, specifierValue) {
    if (typeof specifierValue === "boolean") {
      return specifierValue;
    }
    var current = typeof nodeVersion === "undefined" ? process.versions && process.versions.node : nodeVersion;
    if (typeof current !== "string") {
      throw new TypeError(typeof nodeVersion === "undefined" ? "Unable to determine current node version" : "If provided, a valid node version is required");
    }
    if (specifierValue && typeof specifierValue === "object") {
      for (var i2 = 0; i2 < specifierValue.length; ++i2) {
        if (matchesRange(current, specifierValue[i2])) {
          return true;
        }
      }
      return false;
    }
    return matchesRange(current, specifierValue);
  }
  var data$1 = require$$1$2;
  var isCoreModule$2 = function isCore2(x2, nodeVersion) {
    return hasOwn(data$1, x2) && versionIncluded(nodeVersion, data$1[x2]);
  };
  var fs$9 = require$$0$2;
  var getHomedir$1 = homedir$2;
  var path$h = path$k;
  var caller$1 = caller$2;
  var nodeModulesPaths$1 = nodeModulesPaths$2;
  var normalizeOptions$2 = normalizeOptions$3;
  var isCore$3 = isCoreModule$2;
  var realpathFS$1 = process.platform !== "win32" && fs$9.realpath && typeof fs$9.realpath.native === "function" ? fs$9.realpath.native : fs$9.realpath;
  var homedir$1 = getHomedir$1();
  var defaultPaths$1 = function() {
    return [
      path$h.join(homedir$1, ".node_modules"),
      path$h.join(homedir$1, ".node_libraries")
    ];
  };
  var defaultIsFile$1 = function isFile(file2, cb) {
    fs$9.stat(file2, function(err, stat) {
      if (!err) {
        return cb(null, stat.isFile() || stat.isFIFO());
      }
      if (err.code === "ENOENT" || err.code === "ENOTDIR") return cb(null, false);
      return cb(err);
    });
  };
  var defaultIsDir$1 = function isDirectory(dir, cb) {
    fs$9.stat(dir, function(err, stat) {
      if (!err) {
        return cb(null, stat.isDirectory());
      }
      if (err.code === "ENOENT" || err.code === "ENOTDIR") return cb(null, false);
      return cb(err);
    });
  };
  var defaultRealpath = function realpath(x2, cb) {
    realpathFS$1(x2, function(realpathErr, realPath) {
      if (realpathErr && realpathErr.code !== "ENOENT") cb(realpathErr);
      else cb(null, realpathErr ? x2 : realPath);
    });
  };
  var maybeRealpath = function maybeRealpath2(realpath, x2, opts, cb) {
    if (opts && opts.preserveSymlinks === false) {
      realpath(x2, cb);
    } else {
      cb(null, x2);
    }
  };
  var defaultReadPackage = function defaultReadPackage2(readFile, pkgfile, cb) {
    readFile(pkgfile, function(readFileErr, body) {
      if (readFileErr) cb(readFileErr);
      else {
        try {
          var pkg = JSON.parse(body);
          cb(null, pkg);
        } catch (jsonErr) {
          cb(null);
        }
      }
    });
  };
  var getPackageCandidates$1 = function getPackageCandidates2(x2, start, opts) {
    var dirs = nodeModulesPaths$1(start, opts, x2);
    for (var i2 = 0; i2 < dirs.length; i2++) {
      dirs[i2] = path$h.join(dirs[i2], x2);
    }
    return dirs;
  };
  var async$1 = function resolve2(x2, options, callback) {
    var cb = callback;
    var opts = options;
    if (typeof options === "function") {
      cb = opts;
      opts = {};
    }
    if (typeof x2 !== "string") {
      var err = new TypeError("Path must be a string.");
      return process.nextTick(function() {
        cb(err);
      });
    }
    opts = normalizeOptions$2(x2, opts);
    var isFile = opts.isFile || defaultIsFile$1;
    var isDirectory = opts.isDirectory || defaultIsDir$1;
    var readFile = opts.readFile || fs$9.readFile;
    var realpath = opts.realpath || defaultRealpath;
    var readPackage = opts.readPackage || defaultReadPackage;
    if (opts.readFile && opts.readPackage) {
      var conflictErr = new TypeError("`readFile` and `readPackage` are mutually exclusive.");
      return process.nextTick(function() {
        cb(conflictErr);
      });
    }
    var packageIterator = opts.packageIterator;
    var extensions = opts.extensions || [".js"];
    var includeCoreModules = opts.includeCoreModules !== false;
    var basedir = opts.basedir || path$h.dirname(caller$1());
    var parent = opts.filename || basedir;
    opts.paths = opts.paths || defaultPaths$1();
    var absoluteStart = path$h.resolve(basedir);
    maybeRealpath(
      realpath,
      absoluteStart,
      opts,
      function(err2, realStart) {
        if (err2) cb(err2);
        else init2(realStart);
      }
    );
    var res;
    function init2(basedir2) {
      if (/^(?:\.\.?(?:\/|$)|\/|([A-Za-z]:)?[/\\])/.test(x2)) {
        res = path$h.resolve(basedir2, x2);
        if (x2 === "." || x2 === ".." || x2.slice(-1) === "/") res += "/";
        if (/\/$/.test(x2) && res === basedir2) {
          loadAsDirectory(res, opts.package, onfile);
        } else loadAsFile(res, opts.package, onfile);
      } else if (includeCoreModules && isCore$3(x2)) {
        return cb(null, x2);
      } else loadNodeModules(x2, basedir2, function(err2, n2, pkg) {
        if (err2) cb(err2);
        else if (n2) {
          return maybeRealpath(realpath, n2, opts, function(err3, realN) {
            if (err3) {
              cb(err3);
            } else {
              cb(null, realN, pkg);
            }
          });
        } else {
          var moduleError = new Error("Cannot find module '" + x2 + "' from '" + parent + "'");
          moduleError.code = "MODULE_NOT_FOUND";
          cb(moduleError);
        }
      });
    }
    function onfile(err2, m2, pkg) {
      if (err2) cb(err2);
      else if (m2) cb(null, m2, pkg);
      else loadAsDirectory(res, function(err3, d2, pkg2) {
        if (err3) cb(err3);
        else if (d2) {
          maybeRealpath(realpath, d2, opts, function(err4, realD) {
            if (err4) {
              cb(err4);
            } else {
              cb(null, realD, pkg2);
            }
          });
        } else {
          var moduleError = new Error("Cannot find module '" + x2 + "' from '" + parent + "'");
          moduleError.code = "MODULE_NOT_FOUND";
          cb(moduleError);
        }
      });
    }
    function loadAsFile(x3, thePackage, callback2) {
      var loadAsFilePackage = thePackage;
      var cb2 = callback2;
      if (typeof loadAsFilePackage === "function") {
        cb2 = loadAsFilePackage;
        loadAsFilePackage = void 0;
      }
      var exts = [""].concat(extensions);
      load2(exts, x3, loadAsFilePackage);
      function load2(exts2, x4, loadPackage) {
        if (exts2.length === 0) return cb2(null, void 0, loadPackage);
        var file2 = x4 + exts2[0];
        var pkg = loadPackage;
        if (pkg) onpkg(null, pkg);
        else loadpkg(path$h.dirname(file2), onpkg);
        function onpkg(err2, pkg_, dir) {
          pkg = pkg_;
          if (err2) return cb2(err2);
          if (dir && pkg && opts.pathFilter) {
            var rfile = path$h.relative(dir, file2);
            var rel = rfile.slice(0, rfile.length - exts2[0].length);
            var r2 = opts.pathFilter(pkg, x4, rel);
            if (r2) return load2(
              [""].concat(extensions.slice()),
              path$h.resolve(dir, r2),
              pkg
            );
          }
          isFile(file2, onex);
        }
        function onex(err2, ex) {
          if (err2) return cb2(err2);
          if (ex) return cb2(null, file2, pkg);
          load2(exts2.slice(1), x4, pkg);
        }
      }
    }
    function loadpkg(dir, cb2) {
      if (dir === "" || dir === "/") return cb2(null);
      if (process.platform === "win32" && /^\w:[/\\]*$/.test(dir)) {
        return cb2(null);
      }
      if (/[/\\]node_modules[/\\]*$/.test(dir)) return cb2(null);
      maybeRealpath(realpath, dir, opts, function(unwrapErr, pkgdir) {
        if (unwrapErr) return loadpkg(path$h.dirname(dir), cb2);
        var pkgfile = path$h.join(pkgdir, "package.json");
        isFile(pkgfile, function(err2, ex) {
          if (!ex) return loadpkg(path$h.dirname(dir), cb2);
          readPackage(readFile, pkgfile, function(err3, pkgParam) {
            if (err3) cb2(err3);
            var pkg = pkgParam;
            if (pkg && opts.packageFilter) {
              pkg = opts.packageFilter(pkg, pkgfile);
            }
            cb2(null, pkg, dir);
          });
        });
      });
    }
    function loadAsDirectory(x3, loadAsDirectoryPackage, callback2) {
      var cb2 = callback2;
      var fpkg = loadAsDirectoryPackage;
      if (typeof fpkg === "function") {
        cb2 = fpkg;
        fpkg = opts.package;
      }
      maybeRealpath(realpath, x3, opts, function(unwrapErr, pkgdir) {
        if (unwrapErr) return cb2(unwrapErr);
        var pkgfile = path$h.join(pkgdir, "package.json");
        isFile(pkgfile, function(err2, ex) {
          if (err2) return cb2(err2);
          if (!ex) return loadAsFile(path$h.join(x3, "index"), fpkg, cb2);
          readPackage(readFile, pkgfile, function(err3, pkgParam) {
            if (err3) return cb2(err3);
            var pkg = pkgParam;
            if (pkg && opts.packageFilter) {
              pkg = opts.packageFilter(pkg, pkgfile);
            }
            if (pkg && pkg.main) {
              if (typeof pkg.main !== "string") {
                var mainError = new TypeError("package “" + pkg.name + "” `main` must be a string");
                mainError.code = "INVALID_PACKAGE_MAIN";
                return cb2(mainError);
              }
              if (pkg.main === "." || pkg.main === "./") {
                pkg.main = "index";
              }
              loadAsFile(path$h.resolve(x3, pkg.main), pkg, function(err4, m2, pkg2) {
                if (err4) return cb2(err4);
                if (m2) return cb2(null, m2, pkg2);
                if (!pkg2) return loadAsFile(path$h.join(x3, "index"), pkg2, cb2);
                var dir = path$h.resolve(x3, pkg2.main);
                loadAsDirectory(dir, pkg2, function(err5, n2, pkg3) {
                  if (err5) return cb2(err5);
                  if (n2) return cb2(null, n2, pkg3);
                  loadAsFile(path$h.join(x3, "index"), pkg3, cb2);
                });
              });
              return;
            }
            loadAsFile(path$h.join(x3, "/index"), pkg, cb2);
          });
        });
      });
    }
    function processDirs(cb2, dirs) {
      if (dirs.length === 0) return cb2(null, void 0);
      var dir = dirs[0];
      isDirectory(path$h.dirname(dir), isdir);
      function isdir(err2, isdir2) {
        if (err2) return cb2(err2);
        if (!isdir2) return processDirs(cb2, dirs.slice(1));
        loadAsFile(dir, opts.package, onfile2);
      }
      function onfile2(err2, m2, pkg) {
        if (err2) return cb2(err2);
        if (m2) return cb2(null, m2, pkg);
        loadAsDirectory(dir, opts.package, ondir);
      }
      function ondir(err2, n2, pkg) {
        if (err2) return cb2(err2);
        if (n2) return cb2(null, n2, pkg);
        processDirs(cb2, dirs.slice(1));
      }
    }
    function loadNodeModules(x3, start, cb2) {
      var thunk = function() {
        return getPackageCandidates$1(x3, start, opts);
      };
      processDirs(
        cb2,
        packageIterator ? packageIterator(x3, start, thunk, opts) : thunk()
      );
    }
  };
  const assert$2 = true;
  const async_hooks = ">= 8";
  const buffer_ieee754 = ">= 0.5 && < 0.9.7";
  const buffer = true;
  const child_process = true;
  const cluster = ">= 0.5";
  const console$1 = true;
  const constants = true;
  const crypto$2 = true;
  const _debug_agent = ">= 1 && < 8";
  const _debugger = "< 8";
  const dgram = true;
  const diagnostics_channel = [
    ">= 14.17 && < 15",
    ">= 15.1"
  ];
  const dns = true;
  const domain = ">= 0.7.12";
  const events = true;
  const freelist = "< 6";
  const fs$8 = true;
  const _http_agent = ">= 0.11.1";
  const _http_client = ">= 0.11.1";
  const _http_common = ">= 0.11.1";
  const _http_incoming = ">= 0.11.1";
  const _http_outgoing = ">= 0.11.1";
  const _http_server = ">= 0.11.1";
  const http$1 = true;
  const http2 = ">= 8.8";
  const https$1 = true;
  const inspector = ">= 8";
  const _linklist = "< 8";
  const module$1 = true;
  const net = true;
  const os$5 = true;
  const path$g = true;
  const perf_hooks = ">= 8.5";
  const process$2 = ">= 1";
  const punycode = ">= 0.5";
  const querystring = true;
  const readline = true;
  const repl = true;
  const smalloc = ">= 0.11.5 && < 3";
  const _stream_duplex = ">= 0.9.4";
  const _stream_transform = ">= 0.9.4";
  const _stream_wrap = ">= 1.4.1";
  const _stream_passthrough = ">= 0.9.4";
  const _stream_readable = ">= 0.9.4";
  const _stream_writable = ">= 0.9.4";
  const stream$2 = true;
  const string_decoder = true;
  const sys = [
    ">= 0.4 && < 0.7",
    ">= 0.8"
  ];
  const timers = true;
  const _tls_common = ">= 0.11.13";
  const _tls_legacy = ">= 0.11.3 && < 10";
  const _tls_wrap = ">= 0.11.3";
  const tls = true;
  const trace_events = ">= 10";
  const tty = true;
  const url = true;
  const util$9 = true;
  const v8 = ">= 1";
  const vm = true;
  const wasi = [
    ">= 13.4 && < 13.5",
    ">= 18.17 && < 19",
    ">= 20"
  ];
  const worker_threads = ">= 11.7";
  const zlib = ">= 0.5";
  const require$$1$1 = {
    assert: assert$2,
    "node:assert": [
      ">= 14.18 && < 15",
      ">= 16"
    ],
    "assert/strict": ">= 15",
    "node:assert/strict": ">= 16",
    async_hooks,
    "node:async_hooks": [
      ">= 14.18 && < 15",
      ">= 16"
    ],
    buffer_ieee754,
    buffer,
    "node:buffer": [
      ">= 14.18 && < 15",
      ">= 16"
    ],
    child_process,
    "node:child_process": [
      ">= 14.18 && < 15",
      ">= 16"
    ],
    cluster,
    "node:cluster": [
      ">= 14.18 && < 15",
      ">= 16"
    ],
    console: console$1,
    "node:console": [
      ">= 14.18 && < 15",
      ">= 16"
    ],
    constants,
    "node:constants": [
      ">= 14.18 && < 15",
      ">= 16"
    ],
    crypto: crypto$2,
    "node:crypto": [
      ">= 14.18 && < 15",
      ">= 16"
    ],
    _debug_agent,
    _debugger,
    dgram,
    "node:dgram": [
      ">= 14.18 && < 15",
      ">= 16"
    ],
    diagnostics_channel,
    "node:diagnostics_channel": [
      ">= 14.18 && < 15",
      ">= 16"
    ],
    dns,
    "node:dns": [
      ">= 14.18 && < 15",
      ">= 16"
    ],
    "dns/promises": ">= 15",
    "node:dns/promises": ">= 16",
    domain,
    "node:domain": [
      ">= 14.18 && < 15",
      ">= 16"
    ],
    events,
    "node:events": [
      ">= 14.18 && < 15",
      ">= 16"
    ],
    freelist,
    fs: fs$8,
    "node:fs": [
      ">= 14.18 && < 15",
      ">= 16"
    ],
    "fs/promises": [
      ">= 10 && < 10.1",
      ">= 14"
    ],
    "node:fs/promises": [
      ">= 14.18 && < 15",
      ">= 16"
    ],
    _http_agent,
    "node:_http_agent": [
      ">= 14.18 && < 15",
      ">= 16"
    ],
    _http_client,
    "node:_http_client": [
      ">= 14.18 && < 15",
      ">= 16"
    ],
    _http_common,
    "node:_http_common": [
      ">= 14.18 && < 15",
      ">= 16"
    ],
    _http_incoming,
    "node:_http_incoming": [
      ">= 14.18 && < 15",
      ">= 16"
    ],
    _http_outgoing,
    "node:_http_outgoing": [
      ">= 14.18 && < 15",
      ">= 16"
    ],
    _http_server,
    "node:_http_server": [
      ">= 14.18 && < 15",
      ">= 16"
    ],
    http: http$1,
    "node:http": [
      ">= 14.18 && < 15",
      ">= 16"
    ],
    http2,
    "node:http2": [
      ">= 14.18 && < 15",
      ">= 16"
    ],
    https: https$1,
    "node:https": [
      ">= 14.18 && < 15",
      ">= 16"
    ],
    inspector,
    "node:inspector": [
      ">= 14.18 && < 15",
      ">= 16"
    ],
    "inspector/promises": [
      ">= 19"
    ],
    "node:inspector/promises": [
      ">= 19"
    ],
    _linklist,
    module: module$1,
    "node:module": [
      ">= 14.18 && < 15",
      ">= 16"
    ],
    net,
    "node:net": [
      ">= 14.18 && < 15",
      ">= 16"
    ],
    "node-inspect/lib/_inspect": ">= 7.6 && < 12",
    "node-inspect/lib/internal/inspect_client": ">= 7.6 && < 12",
    "node-inspect/lib/internal/inspect_repl": ">= 7.6 && < 12",
    os: os$5,
    "node:os": [
      ">= 14.18 && < 15",
      ">= 16"
    ],
    path: path$g,
    "node:path": [
      ">= 14.18 && < 15",
      ">= 16"
    ],
    "path/posix": ">= 15.3",
    "node:path/posix": ">= 16",
    "path/win32": ">= 15.3",
    "node:path/win32": ">= 16",
    perf_hooks,
    "node:perf_hooks": [
      ">= 14.18 && < 15",
      ">= 16"
    ],
    process: process$2,
    "node:process": [
      ">= 14.18 && < 15",
      ">= 16"
    ],
    punycode,
    "node:punycode": [
      ">= 14.18 && < 15",
      ">= 16"
    ],
    querystring,
    "node:querystring": [
      ">= 14.18 && < 15",
      ">= 16"
    ],
    readline,
    "node:readline": [
      ">= 14.18 && < 15",
      ">= 16"
    ],
    "readline/promises": ">= 17",
    "node:readline/promises": ">= 17",
    repl,
    "node:repl": [
      ">= 14.18 && < 15",
      ">= 16"
    ],
    "node:sea": [
      ">= 20.12 && < 21",
      ">= 21.7"
    ],
    smalloc,
    "node:sqlite": ">= 23.4",
    _stream_duplex,
    "node:_stream_duplex": [
      ">= 14.18 && < 15",
      ">= 16"
    ],
    _stream_transform,
    "node:_stream_transform": [
      ">= 14.18 && < 15",
      ">= 16"
    ],
    _stream_wrap,
    "node:_stream_wrap": [
      ">= 14.18 && < 15",
      ">= 16"
    ],
    _stream_passthrough,
    "node:_stream_passthrough": [
      ">= 14.18 && < 15",
      ">= 16"
    ],
    _stream_readable,
    "node:_stream_readable": [
      ">= 14.18 && < 15",
      ">= 16"
    ],
    _stream_writable,
    "node:_stream_writable": [
      ">= 14.18 && < 15",
      ">= 16"
    ],
    stream: stream$2,
    "node:stream": [
      ">= 14.18 && < 15",
      ">= 16"
    ],
    "stream/consumers": ">= 16.7",
    "node:stream/consumers": ">= 16.7",
    "stream/promises": ">= 15",
    "node:stream/promises": ">= 16",
    "stream/web": ">= 16.5",
    "node:stream/web": ">= 16.5",
    string_decoder,
    "node:string_decoder": [
      ">= 14.18 && < 15",
      ">= 16"
    ],
    sys,
    "node:sys": [
      ">= 14.18 && < 15",
      ">= 16"
    ],
    "test/reporters": ">= 19.9 && < 20.2",
    "node:test/reporters": [
      ">= 18.17 && < 19",
      ">= 19.9",
      ">= 20"
    ],
    "test/mock_loader": ">= 22.3 && < 22.7",
    "node:test/mock_loader": ">= 22.3 && < 22.7",
    "node:test": [
      ">= 16.17 && < 17",
      ">= 18"
    ],
    timers,
    "node:timers": [
      ">= 14.18 && < 15",
      ">= 16"
    ],
    "timers/promises": ">= 15",
    "node:timers/promises": ">= 16",
    _tls_common,
    "node:_tls_common": [
      ">= 14.18 && < 15",
      ">= 16"
    ],
    _tls_legacy,
    _tls_wrap,
    "node:_tls_wrap": [
      ">= 14.18 && < 15",
      ">= 16"
    ],
    tls,
    "node:tls": [
      ">= 14.18 && < 15",
      ">= 16"
    ],
    trace_events,
    "node:trace_events": [
      ">= 14.18 && < 15",
      ">= 16"
    ],
    tty,
    "node:tty": [
      ">= 14.18 && < 15",
      ">= 16"
    ],
    url,
    "node:url": [
      ">= 14.18 && < 15",
      ">= 16"
    ],
    util: util$9,
    "node:util": [
      ">= 14.18 && < 15",
      ">= 16"
    ],
    "util/types": ">= 15.3",
    "node:util/types": ">= 16",
    "v8/tools/arguments": ">= 10 && < 12",
    "v8/tools/codemap": [
      ">= 4.4 && < 5",
      ">= 5.2 && < 12"
    ],
    "v8/tools/consarray": [
      ">= 4.4 && < 5",
      ">= 5.2 && < 12"
    ],
    "v8/tools/csvparser": [
      ">= 4.4 && < 5",
      ">= 5.2 && < 12"
    ],
    "v8/tools/logreader": [
      ">= 4.4 && < 5",
      ">= 5.2 && < 12"
    ],
    "v8/tools/profile_view": [
      ">= 4.4 && < 5",
      ">= 5.2 && < 12"
    ],
    "v8/tools/splaytree": [
      ">= 4.4 && < 5",
      ">= 5.2 && < 12"
    ],
    v8,
    "node:v8": [
      ">= 14.18 && < 15",
      ">= 16"
    ],
    vm,
    "node:vm": [
      ">= 14.18 && < 15",
      ">= 16"
    ],
    wasi,
    "node:wasi": [
      ">= 18.17 && < 19",
      ">= 20"
    ],
    worker_threads,
    "node:worker_threads": [
      ">= 14.18 && < 15",
      ">= 16"
    ],
    zlib,
    "node:zlib": [
      ">= 14.18 && < 15",
      ">= 16"
    ]
  };
  var isCoreModule$1 = isCoreModule$2;
  var data = require$$1$1;
  var core$2 = {};
  for (var mod in data) {
    if (Object.prototype.hasOwnProperty.call(data, mod)) {
      core$2[mod] = isCoreModule$1(mod);
    }
  }
  var core_1$1 = core$2;
  var isCoreModule = isCoreModule$2;
  var isCore$2 = function isCore2(x2) {
    return isCoreModule(x2);
  };
  var isCore$1 = isCoreModule$2;
  var fs$7 = require$$0$2;
  var path$f = path$k;
  var getHomedir = homedir$2;
  var caller = caller$2;
  var nodeModulesPaths = nodeModulesPaths$2;
  var normalizeOptions$1 = normalizeOptions$3;
  var realpathFS = process.platform !== "win32" && fs$7.realpathSync && typeof fs$7.realpathSync.native === "function" ? fs$7.realpathSync.native : fs$7.realpathSync;
  var homedir = getHomedir();
  var defaultPaths = function() {
    return [
      path$f.join(homedir, ".node_modules"),
      path$f.join(homedir, ".node_libraries")
    ];
  };
  var defaultIsFile = function isFile(file2) {
    try {
      var stat = fs$7.statSync(file2, { throwIfNoEntry: false });
    } catch (e2) {
      if (e2 && (e2.code === "ENOENT" || e2.code === "ENOTDIR")) return false;
      throw e2;
    }
    return !!stat && (stat.isFile() || stat.isFIFO());
  };
  var defaultIsDir = function isDirectory(dir) {
    try {
      var stat = fs$7.statSync(dir, { throwIfNoEntry: false });
    } catch (e2) {
      if (e2 && (e2.code === "ENOENT" || e2.code === "ENOTDIR")) return false;
      throw e2;
    }
    return !!stat && stat.isDirectory();
  };
  var defaultRealpathSync = function realpathSync(x2) {
    try {
      return realpathFS(x2);
    } catch (realpathErr) {
      if (realpathErr.code !== "ENOENT") {
        throw realpathErr;
      }
    }
    return x2;
  };
  var maybeRealpathSync = function maybeRealpathSync2(realpathSync, x2, opts) {
    if (opts && opts.preserveSymlinks === false) {
      return realpathSync(x2);
    }
    return x2;
  };
  var defaultReadPackageSync = function defaultReadPackageSync2(readFileSync, pkgfile) {
    var body = readFileSync(pkgfile);
    try {
      var pkg = JSON.parse(body);
      return pkg;
    } catch (jsonErr) {
    }
  };
  var getPackageCandidates = function getPackageCandidates2(x2, start, opts) {
    var dirs = nodeModulesPaths(start, opts, x2);
    for (var i2 = 0; i2 < dirs.length; i2++) {
      dirs[i2] = path$f.join(dirs[i2], x2);
    }
    return dirs;
  };
  var sync$1 = function resolveSync(x2, options) {
    if (typeof x2 !== "string") {
      throw new TypeError("Path must be a string.");
    }
    var opts = normalizeOptions$1(x2, options);
    var isFile = opts.isFile || defaultIsFile;
    var readFileSync = opts.readFileSync || fs$7.readFileSync;
    var isDirectory = opts.isDirectory || defaultIsDir;
    var realpathSync = opts.realpathSync || defaultRealpathSync;
    var readPackageSync = opts.readPackageSync || defaultReadPackageSync;
    if (opts.readFileSync && opts.readPackageSync) {
      throw new TypeError("`readFileSync` and `readPackageSync` are mutually exclusive.");
    }
    var packageIterator = opts.packageIterator;
    var extensions = opts.extensions || [".js"];
    var includeCoreModules = opts.includeCoreModules !== false;
    var basedir = opts.basedir || path$f.dirname(caller());
    var parent = opts.filename || basedir;
    opts.paths = opts.paths || defaultPaths();
    var absoluteStart = maybeRealpathSync(realpathSync, path$f.resolve(basedir), opts);
    if (/^(?:\.\.?(?:\/|$)|\/|([A-Za-z]:)?[/\\])/.test(x2)) {
      var res = path$f.resolve(absoluteStart, x2);
      if (x2 === "." || x2 === ".." || x2.slice(-1) === "/") res += "/";
      var m2 = loadAsFileSync(res) || loadAsDirectorySync(res);
      if (m2) return maybeRealpathSync(realpathSync, m2, opts);
    } else if (includeCoreModules && isCore$1(x2)) {
      return x2;
    } else {
      var n2 = loadNodeModulesSync(x2, absoluteStart);
      if (n2) return maybeRealpathSync(realpathSync, n2, opts);
    }
    var err = new Error("Cannot find module '" + x2 + "' from '" + parent + "'");
    err.code = "MODULE_NOT_FOUND";
    throw err;
    function loadAsFileSync(x3) {
      var pkg = loadpkg(path$f.dirname(x3));
      if (pkg && pkg.dir && pkg.pkg && opts.pathFilter) {
        var rfile = path$f.relative(pkg.dir, x3);
        var r2 = opts.pathFilter(pkg.pkg, x3, rfile);
        if (r2) {
          x3 = path$f.resolve(pkg.dir, r2);
        }
      }
      if (isFile(x3)) {
        return x3;
      }
      for (var i2 = 0; i2 < extensions.length; i2++) {
        var file2 = x3 + extensions[i2];
        if (isFile(file2)) {
          return file2;
        }
      }
    }
    function loadpkg(dir) {
      if (dir === "" || dir === "/") return;
      if (process.platform === "win32" && /^\w:[/\\]*$/.test(dir)) {
        return;
      }
      if (/[/\\]node_modules[/\\]*$/.test(dir)) return;
      var pkgfile = path$f.join(maybeRealpathSync(realpathSync, dir, opts), "package.json");
      if (!isFile(pkgfile)) {
        return loadpkg(path$f.dirname(dir));
      }
      var pkg = readPackageSync(readFileSync, pkgfile);
      if (pkg && opts.packageFilter) {
        pkg = opts.packageFilter(
          pkg,
          /*pkgfile,*/
          dir
        );
      }
      return { pkg, dir };
    }
    function loadAsDirectorySync(x3) {
      var pkgfile = path$f.join(maybeRealpathSync(realpathSync, x3, opts), "/package.json");
      if (isFile(pkgfile)) {
        try {
          var pkg = readPackageSync(readFileSync, pkgfile);
        } catch (e2) {
        }
        if (pkg && opts.packageFilter) {
          pkg = opts.packageFilter(
            pkg,
            /*pkgfile,*/
            x3
          );
        }
        if (pkg && pkg.main) {
          if (typeof pkg.main !== "string") {
            var mainError = new TypeError("package “" + pkg.name + "” `main` must be a string");
            mainError.code = "INVALID_PACKAGE_MAIN";
            throw mainError;
          }
          if (pkg.main === "." || pkg.main === "./") {
            pkg.main = "index";
          }
          try {
            var m3 = loadAsFileSync(path$f.resolve(x3, pkg.main));
            if (m3) return m3;
            var n3 = loadAsDirectorySync(path$f.resolve(x3, pkg.main));
            if (n3) return n3;
          } catch (e2) {
          }
        }
      }
      return loadAsFileSync(path$f.join(x3, "/index"));
    }
    function loadNodeModulesSync(x3, start) {
      var thunk = function() {
        return getPackageCandidates(x3, start, opts);
      };
      var dirs = packageIterator ? packageIterator(x3, start, thunk, opts) : thunk();
      for (var i2 = 0; i2 < dirs.length; i2++) {
        var dir = dirs[i2];
        if (isDirectory(path$f.dirname(dir))) {
          var m3 = loadAsFileSync(dir);
          if (m3) return m3;
          var n3 = loadAsDirectorySync(dir);
          if (n3) return n3;
        }
      }
    }
  };
  var async = async$1;
  async.core = core_1$1;
  async.isCore = isCore$2;
  async.sync = sync$1;
  var resolve$1 = async;
  var src$4 = { exports: {} };
  var browser$1 = { exports: {} };
  var ms$1;
  var hasRequiredMs$1;
  function requireMs$1() {
    if (hasRequiredMs$1) return ms$1;
    hasRequiredMs$1 = 1;
    var s2 = 1e3;
    var m2 = s2 * 60;
    var h2 = m2 * 60;
    var d2 = h2 * 24;
    var w2 = d2 * 7;
    var y2 = d2 * 365.25;
    ms$1 = function(val, options) {
      options = options || {};
      var type2 = typeof val;
      if (type2 === "string" && val.length > 0) {
        return parse2(val);
      } else if (type2 === "number" && isFinite(val)) {
        return options.long ? fmtLong(val) : fmtShort(val);
      }
      throw new Error(
        "val is not a non-empty string or a valid number. val=" + JSON.stringify(val)
      );
    };
    function parse2(str) {
      str = String(str);
      if (str.length > 100) {
        return;
      }
      var match = /^(-?(?:\d+)?\.?\d+) *(milliseconds?|msecs?|ms|seconds?|secs?|s|minutes?|mins?|m|hours?|hrs?|h|days?|d|weeks?|w|years?|yrs?|y)?$/i.exec(
        str
      );
      if (!match) {
        return;
      }
      var n2 = parseFloat(match[1]);
      var type2 = (match[2] || "ms").toLowerCase();
      switch (type2) {
        case "years":
        case "year":
        case "yrs":
        case "yr":
        case "y":
          return n2 * y2;
        case "weeks":
        case "week":
        case "w":
          return n2 * w2;
        case "days":
        case "day":
        case "d":
          return n2 * d2;
        case "hours":
        case "hour":
        case "hrs":
        case "hr":
        case "h":
          return n2 * h2;
        case "minutes":
        case "minute":
        case "mins":
        case "min":
        case "m":
          return n2 * m2;
        case "seconds":
        case "second":
        case "secs":
        case "sec":
        case "s":
          return n2 * s2;
        case "milliseconds":
        case "millisecond":
        case "msecs":
        case "msec":
        case "ms":
          return n2;
        default:
          return void 0;
      }
    }
    function fmtShort(ms2) {
      var msAbs = Math.abs(ms2);
      if (msAbs >= d2) {
        return Math.round(ms2 / d2) + "d";
      }
      if (msAbs >= h2) {
        return Math.round(ms2 / h2) + "h";
      }
      if (msAbs >= m2) {
        return Math.round(ms2 / m2) + "m";
      }
      if (msAbs >= s2) {
        return Math.round(ms2 / s2) + "s";
      }
      return ms2 + "ms";
    }
    function fmtLong(ms2) {
      var msAbs = Math.abs(ms2);
      if (msAbs >= d2) {
        return plural(ms2, msAbs, d2, "day");
      }
      if (msAbs >= h2) {
        return plural(ms2, msAbs, h2, "hour");
      }
      if (msAbs >= m2) {
        return plural(ms2, msAbs, m2, "minute");
      }
      if (msAbs >= s2) {
        return plural(ms2, msAbs, s2, "second");
      }
      return ms2 + " ms";
    }
    function plural(ms2, msAbs, n2, name2) {
      var isPlural = msAbs >= n2 * 1.5;
      return Math.round(ms2 / n2) + " " + name2 + (isPlural ? "s" : "");
    }
    return ms$1;
  }
  var common$1;
  var hasRequiredCommon;
  function requireCommon() {
    if (hasRequiredCommon) return common$1;
    hasRequiredCommon = 1;
    function setup(env2) {
      createDebug.debug = createDebug;
      createDebug.default = createDebug;
      createDebug.coerce = coerce2;
      createDebug.disable = disable;
      createDebug.enable = enable;
      createDebug.enabled = enabled;
      createDebug.humanize = requireMs$1();
      createDebug.destroy = destroy;
      Object.keys(env2).forEach((key) => {
        createDebug[key] = env2[key];
      });
      createDebug.names = [];
      createDebug.skips = [];
      createDebug.formatters = {};
      function selectColor(namespace2) {
        let hash = 0;
        for (let i2 = 0; i2 < namespace2.length; i2++) {
          hash = (hash << 5) - hash + namespace2.charCodeAt(i2);
          hash |= 0;
        }
        return createDebug.colors[Math.abs(hash) % createDebug.colors.length];
      }
      createDebug.selectColor = selectColor;
      function createDebug(namespace2) {
        let prevTime;
        let enableOverride = null;
        let namespacesCache;
        let enabledCache;
        function debug2(...args2) {
          if (!debug2.enabled) {
            return;
          }
          const self2 = debug2;
          const curr = Number(/* @__PURE__ */ new Date());
          const ms2 = curr - (prevTime || curr);
          self2.diff = ms2;
          self2.prev = prevTime;
          self2.curr = curr;
          prevTime = curr;
          args2[0] = createDebug.coerce(args2[0]);
          if (typeof args2[0] !== "string") {
            args2.unshift("%O");
          }
          let index2 = 0;
          args2[0] = args2[0].replace(/%([a-zA-Z%])/g, (match, format2) => {
            if (match === "%%") {
              return "%";
            }
            index2++;
            const formatter = createDebug.formatters[format2];
            if (typeof formatter === "function") {
              const val = args2[index2];
              match = formatter.call(self2, val);
              args2.splice(index2, 1);
              index2--;
            }
            return match;
          });
          createDebug.formatArgs.call(self2, args2);
          const logFn = self2.log || createDebug.log;
          logFn.apply(self2, args2);
        }
        debug2.namespace = namespace2;
        debug2.useColors = createDebug.useColors();
        debug2.color = createDebug.selectColor(namespace2);
        debug2.extend = extend;
        debug2.destroy = createDebug.destroy;
        Object.defineProperty(debug2, "enabled", {
          enumerable: true,
          configurable: false,
          get: () => {
            if (enableOverride !== null) {
              return enableOverride;
            }
            if (namespacesCache !== createDebug.namespaces) {
              namespacesCache = createDebug.namespaces;
              enabledCache = createDebug.enabled(namespace2);
            }
            return enabledCache;
          },
          set: (v2) => {
            enableOverride = v2;
          }
        });
        if (typeof createDebug.init === "function") {
          createDebug.init(debug2);
        }
        return debug2;
      }
      function extend(namespace2, delimiter) {
        const newDebug = createDebug(this.namespace + (typeof delimiter === "undefined" ? ":" : delimiter) + namespace2);
        newDebug.log = this.log;
        return newDebug;
      }
      function enable(namespaces) {
        createDebug.save(namespaces);
        createDebug.namespaces = namespaces;
        createDebug.names = [];
        createDebug.skips = [];
        const split = (typeof namespaces === "string" ? namespaces : "").trim().replace(" ", ",").split(",").filter(Boolean);
        for (const ns of split) {
          if (ns[0] === "-") {
            createDebug.skips.push(ns.slice(1));
          } else {
            createDebug.names.push(ns);
          }
        }
      }
      function matchesTemplate(search, template) {
        let searchIndex = 0;
        let templateIndex = 0;
        let starIndex = -1;
        let matchIndex = 0;
        while (searchIndex < search.length) {
          if (templateIndex < template.length && (template[templateIndex] === search[searchIndex] || template[templateIndex] === "*")) {
            if (template[templateIndex] === "*") {
              starIndex = templateIndex;
              matchIndex = searchIndex;
              templateIndex++;
            } else {
              searchIndex++;
              templateIndex++;
            }
          } else if (starIndex !== -1) {
            templateIndex = starIndex + 1;
            matchIndex++;
            searchIndex = matchIndex;
          } else {
            return false;
          }
        }
        while (templateIndex < template.length && template[templateIndex] === "*") {
          templateIndex++;
        }
        return templateIndex === template.length;
      }
      function disable() {
        const namespaces = [
          ...createDebug.names,
          ...createDebug.skips.map((namespace2) => "-" + namespace2)
        ].join(",");
        createDebug.enable("");
        return namespaces;
      }
      function enabled(name2) {
        for (const skip of createDebug.skips) {
          if (matchesTemplate(name2, skip)) {
            return false;
          }
        }
        for (const ns of createDebug.names) {
          if (matchesTemplate(name2, ns)) {
            return true;
          }
        }
        return false;
      }
      function coerce2(val) {
        if (val instanceof Error) {
          return val.stack || val.message;
        }
        return val;
      }
      function destroy() {
        console.warn("Instance method `debug.destroy()` is deprecated and no longer does anything. It will be removed in the next major version of `debug`.");
      }
      createDebug.enable(createDebug.load());
      return createDebug;
    }
    common$1 = setup;
    return common$1;
  }
  var hasRequiredBrowser$1;
  function requireBrowser$1() {
    if (hasRequiredBrowser$1) return browser$1.exports;
    hasRequiredBrowser$1 = 1;
    (function(module2, exports2) {
      exports2.formatArgs = formatArgs;
      exports2.save = save;
      exports2.load = load2;
      exports2.useColors = useColors;
      exports2.storage = localstorage();
      exports2.destroy = /* @__PURE__ */ (() => {
        let warned = false;
        return () => {
          if (!warned) {
            warned = true;
            console.warn("Instance method `debug.destroy()` is deprecated and no longer does anything. It will be removed in the next major version of `debug`.");
          }
        };
      })();
      exports2.colors = [
        "#0000CC",
        "#0000FF",
        "#0033CC",
        "#0033FF",
        "#0066CC",
        "#0066FF",
        "#0099CC",
        "#0099FF",
        "#00CC00",
        "#00CC33",
        "#00CC66",
        "#00CC99",
        "#00CCCC",
        "#00CCFF",
        "#3300CC",
        "#3300FF",
        "#3333CC",
        "#3333FF",
        "#3366CC",
        "#3366FF",
        "#3399CC",
        "#3399FF",
        "#33CC00",
        "#33CC33",
        "#33CC66",
        "#33CC99",
        "#33CCCC",
        "#33CCFF",
        "#6600CC",
        "#6600FF",
        "#6633CC",
        "#6633FF",
        "#66CC00",
        "#66CC33",
        "#9900CC",
        "#9900FF",
        "#9933CC",
        "#9933FF",
        "#99CC00",
        "#99CC33",
        "#CC0000",
        "#CC0033",
        "#CC0066",
        "#CC0099",
        "#CC00CC",
        "#CC00FF",
        "#CC3300",
        "#CC3333",
        "#CC3366",
        "#CC3399",
        "#CC33CC",
        "#CC33FF",
        "#CC6600",
        "#CC6633",
        "#CC9900",
        "#CC9933",
        "#CCCC00",
        "#CCCC33",
        "#FF0000",
        "#FF0033",
        "#FF0066",
        "#FF0099",
        "#FF00CC",
        "#FF00FF",
        "#FF3300",
        "#FF3333",
        "#FF3366",
        "#FF3399",
        "#FF33CC",
        "#FF33FF",
        "#FF6600",
        "#FF6633",
        "#FF9900",
        "#FF9933",
        "#FFCC00",
        "#FFCC33"
      ];
      function useColors() {
        if (typeof window !== "undefined" && window.process && (window.process.type === "renderer" || window.process.__nwjs)) {
          return true;
        }
        if (typeof navigator !== "undefined" && navigator.userAgent && navigator.userAgent.toLowerCase().match(/(edge|trident)\/(\d+)/)) {
          return false;
        }
        let m2;
        return typeof document !== "undefined" && document.documentElement && document.documentElement.style && document.documentElement.style.WebkitAppearance || // Is firebug? http://stackoverflow.com/a/398120/376773
        typeof window !== "undefined" && window.console && (window.console.firebug || window.console.exception && window.console.table) || // Is firefox >= v31?
        // https://developer.mozilla.org/en-US/docs/Tools/Web_Console#Styling_messages
        typeof navigator !== "undefined" && navigator.userAgent && (m2 = navigator.userAgent.toLowerCase().match(/firefox\/(\d+)/)) && parseInt(m2[1], 10) >= 31 || // Double check webkit in userAgent just in case we are in a worker
        typeof navigator !== "undefined" && navigator.userAgent && navigator.userAgent.toLowerCase().match(/applewebkit\/(\d+)/);
      }
      function formatArgs(args2) {
        args2[0] = (this.useColors ? "%c" : "") + this.namespace + (this.useColors ? " %c" : " ") + args2[0] + (this.useColors ? "%c " : " ") + "+" + module2.exports.humanize(this.diff);
        if (!this.useColors) {
          return;
        }
        const c2 = "color: " + this.color;
        args2.splice(1, 0, c2, "color: inherit");
        let index2 = 0;
        let lastC = 0;
        args2[0].replace(/%[a-zA-Z%]/g, (match) => {
          if (match === "%%") {
            return;
          }
          index2++;
          if (match === "%c") {
            lastC = index2;
          }
        });
        args2.splice(lastC, 0, c2);
      }
      exports2.log = console.debug || console.log || (() => {
      });
      function save(namespaces) {
        try {
          if (namespaces) {
            exports2.storage.setItem("debug", namespaces);
          } else {
            exports2.storage.removeItem("debug");
          }
        } catch (error2) {
        }
      }
      function load2() {
        let r2;
        try {
          r2 = exports2.storage.getItem("debug");
        } catch (error2) {
        }
        if (!r2 && typeof process !== "undefined" && "env" in process) {
          r2 = process.env.DEBUG;
        }
        return r2;
      }
      function localstorage() {
        try {
          return localStorage;
        } catch (error2) {
        }
      }
      module2.exports = requireCommon()(exports2);
      const { formatters } = module2.exports;
      formatters.j = function(v2) {
        try {
          return JSON.stringify(v2);
        } catch (error2) {
          return "[UnexpectedJSONParseError]: " + error2.message;
        }
      };
    })(browser$1, browser$1.exports);
    return browser$1.exports;
  }
  var node$1 = { exports: {} };
  var hasFlag;
  var hasRequiredHasFlag;
  function requireHasFlag() {
    if (hasRequiredHasFlag) return hasFlag;
    hasRequiredHasFlag = 1;
    hasFlag = (flag, argv = process.argv) => {
      const prefix = flag.startsWith("-") ? "" : flag.length === 1 ? "-" : "--";
      const position = argv.indexOf(prefix + flag);
      const terminatorPosition = argv.indexOf("--");
      return position !== -1 && (terminatorPosition === -1 || position < terminatorPosition);
    };
    return hasFlag;
  }
  var supportsColor_1;
  var hasRequiredSupportsColor;
  function requireSupportsColor() {
    if (hasRequiredSupportsColor) return supportsColor_1;
    hasRequiredSupportsColor = 1;
    const os2 = require$$0$1;
    const tty2 = require$$0$3;
    const hasFlag2 = requireHasFlag();
    const { env: env2 } = process;
    let forceColor;
    if (hasFlag2("no-color") || hasFlag2("no-colors") || hasFlag2("color=false") || hasFlag2("color=never")) {
      forceColor = 0;
    } else if (hasFlag2("color") || hasFlag2("colors") || hasFlag2("color=true") || hasFlag2("color=always")) {
      forceColor = 1;
    }
    if ("FORCE_COLOR" in env2) {
      if (env2.FORCE_COLOR === "true") {
        forceColor = 1;
      } else if (env2.FORCE_COLOR === "false") {
        forceColor = 0;
      } else {
        forceColor = env2.FORCE_COLOR.length === 0 ? 1 : Math.min(parseInt(env2.FORCE_COLOR, 10), 3);
      }
    }
    function translateLevel(level) {
      if (level === 0) {
        return false;
      }
      return {
        level,
        hasBasic: true,
        has256: level >= 2,
        has16m: level >= 3
      };
    }
    function supportsColor(haveStream, streamIsTTY) {
      if (forceColor === 0) {
        return 0;
      }
      if (hasFlag2("color=16m") || hasFlag2("color=full") || hasFlag2("color=truecolor")) {
        return 3;
      }
      if (hasFlag2("color=256")) {
        return 2;
      }
      if (haveStream && !streamIsTTY && forceColor === void 0) {
        return 0;
      }
      const min = forceColor || 0;
      if (env2.TERM === "dumb") {
        return min;
      }
      if (process.platform === "win32") {
        const osRelease = os2.release().split(".");
        if (Number(osRelease[0]) >= 10 && Number(osRelease[2]) >= 10586) {
          return Number(osRelease[2]) >= 14931 ? 3 : 2;
        }
        return 1;
      }
      if ("CI" in env2) {
        if (["TRAVIS", "CIRCLECI", "APPVEYOR", "GITLAB_CI", "GITHUB_ACTIONS", "BUILDKITE"].some((sign) => sign in env2) || env2.CI_NAME === "codeship") {
          return 1;
        }
        return min;
      }
      if ("TEAMCITY_VERSION" in env2) {
        return /^(9\.(0*[1-9]\d*)\.|\d{2,}\.)/.test(env2.TEAMCITY_VERSION) ? 1 : 0;
      }
      if (env2.COLORTERM === "truecolor") {
        return 3;
      }
      if ("TERM_PROGRAM" in env2) {
        const version2 = parseInt((env2.TERM_PROGRAM_VERSION || "").split(".")[0], 10);
        switch (env2.TERM_PROGRAM) {
          case "iTerm.app":
            return version2 >= 3 ? 3 : 2;
          case "Apple_Terminal":
            return 2;
        }
      }
      if (/-256(color)?$/i.test(env2.TERM)) {
        return 2;
      }
      if (/^screen|^xterm|^vt100|^vt220|^rxvt|color|ansi|cygwin|linux/i.test(env2.TERM)) {
        return 1;
      }
      if ("COLORTERM" in env2) {
        return 1;
      }
      return min;
    }
    function getSupportLevel(stream2) {
      const level = supportsColor(stream2, stream2 && stream2.isTTY);
      return translateLevel(level);
    }
    supportsColor_1 = {
      supportsColor: getSupportLevel,
      stdout: translateLevel(supportsColor(true, tty2.isatty(1))),
      stderr: translateLevel(supportsColor(true, tty2.isatty(2)))
    };
    return supportsColor_1;
  }
  var hasRequiredNode$1;
  function requireNode$1() {
    if (hasRequiredNode$1) return node$1.exports;
    hasRequiredNode$1 = 1;
    (function(module2, exports2) {
      const tty2 = require$$0$3;
      const util2 = require$$5$1;
      exports2.init = init2;
      exports2.log = log2;
      exports2.formatArgs = formatArgs;
      exports2.save = save;
      exports2.load = load2;
      exports2.useColors = useColors;
      exports2.destroy = util2.deprecate(
        () => {
        },
        "Instance method `debug.destroy()` is deprecated and no longer does anything. It will be removed in the next major version of `debug`."
      );
      exports2.colors = [6, 2, 3, 4, 5, 1];
      try {
        const supportsColor = requireSupportsColor();
        if (supportsColor && (supportsColor.stderr || supportsColor).level >= 2) {
          exports2.colors = [
            20,
            21,
            26,
            27,
            32,
            33,
            38,
            39,
            40,
            41,
            42,
            43,
            44,
            45,
            56,
            57,
            62,
            63,
            68,
            69,
            74,
            75,
            76,
            77,
            78,
            79,
            80,
            81,
            92,
            93,
            98,
            99,
            112,
            113,
            128,
            129,
            134,
            135,
            148,
            149,
            160,
            161,
            162,
            163,
            164,
            165,
            166,
            167,
            168,
            169,
            170,
            171,
            172,
            173,
            178,
            179,
            184,
            185,
            196,
            197,
            198,
            199,
            200,
            201,
            202,
            203,
            204,
            205,
            206,
            207,
            208,
            209,
            214,
            215,
            220,
            221
          ];
        }
      } catch (error2) {
      }
      exports2.inspectOpts = Object.keys(process.env).filter((key) => {
        return /^debug_/i.test(key);
      }).reduce((obj, key) => {
        const prop = key.substring(6).toLowerCase().replace(/_([a-z])/g, (_2, k2) => {
          return k2.toUpperCase();
        });
        let val = process.env[key];
        if (/^(yes|on|true|enabled)$/i.test(val)) {
          val = true;
        } else if (/^(no|off|false|disabled)$/i.test(val)) {
          val = false;
        } else if (val === "null") {
          val = null;
        } else {
          val = Number(val);
        }
        obj[prop] = val;
        return obj;
      }, {});
      function useColors() {
        return "colors" in exports2.inspectOpts ? Boolean(exports2.inspectOpts.colors) : tty2.isatty(process.stderr.fd);
      }
      function formatArgs(args2) {
        const { namespace: name2, useColors: useColors2 } = this;
        if (useColors2) {
          const c2 = this.color;
          const colorCode = "\x1B[3" + (c2 < 8 ? c2 : "8;5;" + c2);
          const prefix = `  ${colorCode};1m${name2} \x1B[0m`;
          args2[0] = prefix + args2[0].split("\n").join("\n" + prefix);
          args2.push(colorCode + "m+" + module2.exports.humanize(this.diff) + "\x1B[0m");
        } else {
          args2[0] = getDate() + name2 + " " + args2[0];
        }
      }
      function getDate() {
        if (exports2.inspectOpts.hideDate) {
          return "";
        }
        return (/* @__PURE__ */ new Date()).toISOString() + " ";
      }
      function log2(...args2) {
        return process.stderr.write(util2.formatWithOptions(exports2.inspectOpts, ...args2) + "\n");
      }
      function save(namespaces) {
        if (namespaces) {
          process.env.DEBUG = namespaces;
        } else {
          delete process.env.DEBUG;
        }
      }
      function load2() {
        return process.env.DEBUG;
      }
      function init2(debug2) {
        debug2.inspectOpts = {};
        const keys2 = Object.keys(exports2.inspectOpts);
        for (let i2 = 0; i2 < keys2.length; i2++) {
          debug2.inspectOpts[keys2[i2]] = exports2.inspectOpts[keys2[i2]];
        }
      }
      module2.exports = requireCommon()(exports2);
      const { formatters } = module2.exports;
      formatters.o = function(v2) {
        this.inspectOpts.colors = this.useColors;
        return util2.inspect(v2, this.inspectOpts).split("\n").map((str) => str.trim()).join(" ");
      };
      formatters.O = function(v2) {
        this.inspectOpts.colors = this.useColors;
        return util2.inspect(v2, this.inspectOpts);
      };
    })(node$1, node$1.exports);
    return node$1.exports;
  }
  if (typeof process === "undefined" || process.type === "renderer" || process.browser === true || process.__nwjs) {
    src$4.exports = requireBrowser$1();
  } else {
    src$4.exports = requireNode$1();
  }
  var srcExports$2 = src$4.exports;
  var path$e = path$k;
  var moduleDetailsFromPath$1 = function(file2) {
    var segments = file2.split(path$e.sep);
    var index2 = segments.lastIndexOf("node_modules");
    if (index2 === -1) return;
    if (!segments[index2 + 1]) return;
    var scoped = segments[index2 + 1][0] === "@";
    var name2 = scoped ? segments[index2 + 1] + "/" + segments[index2 + 2] : segments[index2 + 1];
    var offset = scoped ? 3 : 2;
    return {
      name: name2,
      basedir: segments.slice(0, index2 + offset).join(path$e.sep),
      path: segments.slice(index2 + offset).join(path$e.sep)
    };
  };
  const name = "require-in-the-middle";
  const version$2 = "7.4.0";
  const description = "Module to hook into the Node.js require function";
  const main$4 = "index.js";
  const types$3 = "types/index.d.ts";
  const dependencies = {
    debug: "^4.3.5",
    "module-details-from-path": "^1.0.3",
    resolve: "^1.22.8"
  };
  const devDependencies = {
    "@babel/core": "^7.9.0",
    "@babel/preset-env": "^7.9.5",
    "@babel/preset-typescript": "^7.9.0",
    "@babel/register": "^7.9.0",
    "ipp-printer": "^1.0.0",
    patterns: "^1.0.3",
    roundround: "^0.2.0",
    semver: "^6.3.0",
    standard: "^14.3.1",
    tape: "^4.11.0"
  };
  const scripts = {
    test: "npm run test:lint && npm run test:tape && npm run test:babel",
    "test:lint": "standard",
    "test:tape": "tape test/*.js",
    "test:babel": "node test/babel/babel-register.js"
  };
  const repository = {
    type: "git",
    url: "git+https://github.com/elastic/require-in-the-middle.git"
  };
  const keywords = [
    "require",
    "hook",
    "shim",
    "shimmer",
    "shimming",
    "patch",
    "monkey",
    "monkeypatch",
    "module",
    "load"
  ];
  const files = [
    "types"
  ];
  const author = "Thomas Watson Steen <w@tson.dk> (https://twitter.com/wa7son)";
  const license = "MIT";
  const bugs = {
    url: "https://github.com/elastic/require-in-the-middle/issues"
  };
  const homepage = "https://github.com/elastic/require-in-the-middle#readme";
  const engines = {
    node: ">=8.6.0"
  };
  const require$$5 = {
    name,
    version: version$2,
    description,
    main: main$4,
    types: types$3,
    dependencies,
    devDependencies,
    scripts,
    repository,
    keywords,
    files,
    author,
    license,
    bugs,
    homepage,
    engines
  };
  const path$d = path$k;
  const Module = require$$1$3;
  const resolve = resolve$1;
  const debug$2 = srcExports$2("require-in-the-middle");
  const moduleDetailsFromPath = moduleDetailsFromPath$1;
  requireInTheMiddle.exports = Hook$1;
  var Hook_1$1 = requireInTheMiddle.exports.Hook = Hook$1;
  let isCore;
  if (Module.isBuiltin) {
    isCore = Module.isBuiltin;
  } else {
    const [major2, minor2] = process.versions.node.split(".").map(Number);
    if (major2 === 8 && minor2 < 8) {
      isCore = (moduleName2) => {
        if (moduleName2 === "http2") {
          return true;
        }
        return !!resolve.core[moduleName2];
      };
    } else {
      isCore = (moduleName2) => {
        return !!resolve.core[moduleName2];
      };
    }
  }
  const normalize = /([/\\]index)?(\.js)?$/;
  class ExportsCache {
    constructor() {
      this._localCache = /* @__PURE__ */ new Map();
      this._kRitmExports = Symbol("RitmExports");
    }
    has(filename, isBuiltin2) {
      if (this._localCache.has(filename)) {
        return true;
      } else if (!isBuiltin2) {
        const mod2 = require.cache[filename];
        return !!(mod2 && this._kRitmExports in mod2);
      } else {
        return false;
      }
    }
    get(filename, isBuiltin2) {
      const cachedExports = this._localCache.get(filename);
      if (cachedExports !== void 0) {
        return cachedExports;
      } else if (!isBuiltin2) {
        const mod2 = require.cache[filename];
        return mod2 && mod2[this._kRitmExports];
      }
    }
    set(filename, exports2, isBuiltin2) {
      if (isBuiltin2) {
        this._localCache.set(filename, exports2);
      } else if (filename in require.cache) {
        require.cache[filename][this._kRitmExports] = exports2;
      } else {
        debug$2('non-core module is unexpectedly not in require.cache: "%s"', filename);
        this._localCache.set(filename, exports2);
      }
    }
  }
  function Hook$1(modules, options, onrequire) {
    if (this instanceof Hook$1 === false) return new Hook$1(modules, options, onrequire);
    if (typeof modules === "function") {
      onrequire = modules;
      modules = null;
      options = null;
    } else if (typeof options === "function") {
      onrequire = options;
      options = null;
    }
    if (typeof Module._resolveFilename !== "function") {
      console.error("Error: Expected Module._resolveFilename to be a function (was: %s) - aborting!", typeof Module._resolveFilename);
      console.error("Please report this error as an issue related to Node.js %s at %s", process.version, require$$5.bugs.url);
      return;
    }
    this._cache = new ExportsCache();
    this._unhooked = false;
    this._origRequire = Module.prototype.require;
    const self2 = this;
    const patching = /* @__PURE__ */ new Set();
    const internals = options ? options.internals === true : false;
    const hasWhitelist = Array.isArray(modules);
    debug$2("registering require hook");
    this._require = Module.prototype.require = function(id) {
      if (self2._unhooked === true) {
        debug$2("ignoring require call - module is soft-unhooked");
        return self2._origRequire.apply(this, arguments);
      }
      return patchedRequire.call(this, arguments, false);
    };
    if (typeof process.getBuiltinModule === "function") {
      this._origGetBuiltinModule = process.getBuiltinModule;
      this._getBuiltinModule = process.getBuiltinModule = function(id) {
        if (self2._unhooked === true) {
          debug$2("ignoring process.getBuiltinModule call - module is soft-unhooked");
          return self2._origGetBuiltinModule.apply(this, arguments);
        }
        return patchedRequire.call(this, arguments, true);
      };
    }
    function patchedRequire(args2, coreOnly) {
      const id = args2[0];
      const core2 = isCore(id);
      let filename;
      if (core2) {
        filename = id;
        if (id.startsWith("node:")) {
          const idWithoutPrefix = id.slice(5);
          if (isCore(idWithoutPrefix)) {
            filename = idWithoutPrefix;
          }
        }
      } else if (coreOnly) {
        debug$2("call to process.getBuiltinModule with unknown built-in id");
        return self2._origGetBuiltinModule.apply(this, args2);
      } else {
        try {
          filename = Module._resolveFilename(id, this);
        } catch (resolveErr) {
          debug$2('Module._resolveFilename("%s") threw %j, calling original Module.require', id, resolveErr.message);
          return self2._origRequire.apply(this, args2);
        }
      }
      let moduleName2, basedir;
      debug$2("processing %s module require('%s'): %s", core2 === true ? "core" : "non-core", id, filename);
      if (self2._cache.has(filename, core2) === true) {
        debug$2("returning already patched cached module: %s", filename);
        return self2._cache.get(filename, core2);
      }
      const isPatching = patching.has(filename);
      if (isPatching === false) {
        patching.add(filename);
      }
      const exports2 = coreOnly ? self2._origGetBuiltinModule.apply(this, args2) : self2._origRequire.apply(this, args2);
      if (isPatching === true) {
        debug$2("module is in the process of being patched already - ignoring: %s", filename);
        return exports2;
      }
      patching.delete(filename);
      if (core2 === true) {
        if (hasWhitelist === true && modules.includes(filename) === false) {
          debug$2("ignoring core module not on whitelist: %s", filename);
          return exports2;
        }
        moduleName2 = filename;
      } else if (hasWhitelist === true && modules.includes(filename)) {
        const parsedPath = path$d.parse(filename);
        moduleName2 = parsedPath.name;
        basedir = parsedPath.dir;
      } else {
        const stat = moduleDetailsFromPath(filename);
        if (stat === void 0) {
          debug$2("could not parse filename: %s", filename);
          return exports2;
        }
        moduleName2 = stat.name;
        basedir = stat.basedir;
        const fullModuleName = resolveModuleName(stat);
        debug$2("resolved filename to module: %s (id: %s, resolved: %s, basedir: %s)", moduleName2, id, fullModuleName, basedir);
        let matchFound = false;
        if (hasWhitelist) {
          if (!id.startsWith(".") && modules.includes(id)) {
            moduleName2 = id;
            matchFound = true;
          }
          if (!modules.includes(moduleName2) && !modules.includes(fullModuleName)) {
            return exports2;
          }
          if (modules.includes(fullModuleName) && fullModuleName !== moduleName2) {
            moduleName2 = fullModuleName;
            matchFound = true;
          }
        }
        if (!matchFound) {
          let res;
          try {
            res = resolve.sync(moduleName2, { basedir });
          } catch (e2) {
            debug$2("could not resolve module: %s", moduleName2);
            self2._cache.set(filename, exports2, core2);
            return exports2;
          }
          if (res !== filename) {
            if (internals === true) {
              moduleName2 = moduleName2 + path$d.sep + path$d.relative(basedir, filename);
              debug$2("preparing to process require of internal file: %s", moduleName2);
            } else {
              debug$2("ignoring require of non-main module file: %s", res);
              self2._cache.set(filename, exports2, core2);
              return exports2;
            }
          }
        }
      }
      self2._cache.set(filename, exports2, core2);
      debug$2("calling require hook: %s", moduleName2);
      const patchedExports = onrequire(exports2, moduleName2, basedir);
      self2._cache.set(filename, patchedExports, core2);
      debug$2("returning module: %s", moduleName2);
      return patchedExports;
    }
  }
  Hook$1.prototype.unhook = function() {
    this._unhooked = true;
    if (this._require === Module.prototype.require) {
      Module.prototype.require = this._origRequire;
      debug$2("require unhook successful");
    } else {
      debug$2("require unhook unsuccessful");
    }
    if (process.getBuiltinModule !== void 0) {
      if (this._getBuiltinModule === process.getBuiltinModule) {
        process.getBuiltinModule = this._origGetBuiltinModule;
        debug$2("process.getBuiltinModule unhook successful");
      } else {
        debug$2("process.getBuiltinModule unhook unsuccessful");
      }
    }
  };
  function resolveModuleName(stat) {
    const normalizedPath = path$d.sep !== "/" ? stat.path.split(path$d.sep).join("/") : stat.path;
    return path$d.posix.join(stat.name, normalizedPath).replace(normalize, "");
  }
  var importInTheMiddle = { exports: {} };
  var register$1 = {};
  const importHooks$1 = [];
  const setters = /* @__PURE__ */ new WeakMap();
  const getters = /* @__PURE__ */ new WeakMap();
  const specifiers$1 = /* @__PURE__ */ new Map();
  const toHook$1 = [];
  const proxyHandler = {
    set(target, name2, value) {
      return setters.get(target)[name2](value);
    },
    get(target, name2) {
      if (name2 === Symbol.toStringTag) {
        return "Module";
      }
      const getter = getters.get(target)[name2];
      if (typeof getter === "function") {
        return getter();
      }
    },
    defineProperty(target, property, descriptor) {
      if (!("value" in descriptor)) {
        throw new Error("Getters/setters are not supported for exports property descriptors.");
      }
      return setters.get(target)[property](descriptor.value);
    }
  };
  function register(name2, namespace2, set2, get, specifier) {
    specifiers$1.set(name2, specifier);
    setters.set(namespace2, set2);
    getters.set(namespace2, get);
    const proxy = new Proxy(namespace2, proxyHandler);
    importHooks$1.forEach((hook) => hook(name2, proxy));
    toHook$1.push([name2, proxy]);
  }
  register$1.register = register;
  register$1.importHooks = importHooks$1;
  register$1.specifiers = specifiers$1;
  register$1.toHook = toHook$1;
  const path$c = path$k;
  const parse$3 = moduleDetailsFromPath$1;
  const { fileURLToPath } = Url;
  const { MessageChannel } = require$$3;
  const {
    importHooks,
    specifiers,
    toHook
  } = register$1;
  function addHook(hook) {
    importHooks.push(hook);
    toHook.forEach(([name2, namespace2]) => hook(name2, namespace2));
  }
  function removeHook(hook) {
    const index2 = importHooks.indexOf(hook);
    if (index2 > -1) {
      importHooks.splice(index2, 1);
    }
  }
  function callHookFn(hookFn, namespace2, name2, baseDir) {
    const newDefault = hookFn(namespace2, name2, baseDir);
    if (newDefault && newDefault !== namespace2) {
      namespace2.default = newDefault;
    }
  }
  let sendModulesToLoader;
  function createAddHookMessageChannel() {
    const { port1, port2 } = new MessageChannel();
    let pendingAckCount = 0;
    let resolveFn;
    sendModulesToLoader = (modules) => {
      pendingAckCount++;
      port1.postMessage(modules);
    };
    port1.on("message", () => {
      pendingAckCount--;
      if (resolveFn && pendingAckCount <= 0) {
        resolveFn();
      }
    }).unref();
    function waitForAllMessagesAcknowledged() {
      const timer = setInterval(() => {
      }, 1e3);
      const promise2 = new Promise((resolve2) => {
        resolveFn = resolve2;
      }).then(() => {
        clearInterval(timer);
      });
      if (pendingAckCount === 0) {
        resolveFn();
      }
      return promise2;
    }
    const addHookMessagePort = port2;
    const registerOptions = { data: { addHookMessagePort, include: [] }, transferList: [addHookMessagePort] };
    return { registerOptions, addHookMessagePort, waitForAllMessagesAcknowledged };
  }
  function Hook(modules, options, hookFn) {
    if (this instanceof Hook === false) return new Hook(modules, options, hookFn);
    if (typeof modules === "function") {
      hookFn = modules;
      modules = null;
      options = null;
    } else if (typeof options === "function") {
      hookFn = options;
      options = null;
    }
    const internals = options ? options.internals === true : false;
    if (sendModulesToLoader && Array.isArray(modules)) {
      sendModulesToLoader(modules);
    }
    this._iitmHook = (name2, namespace2) => {
      const filename = name2;
      const isBuiltin2 = name2.startsWith("node:");
      let baseDir;
      if (isBuiltin2) {
        name2 = name2.replace(/^node:/, "");
      } else {
        if (name2.startsWith("file://")) {
          try {
            name2 = fileURLToPath(name2);
          } catch (e2) {
          }
        }
        const details = parse$3(name2);
        if (details) {
          name2 = details.name;
          baseDir = details.basedir;
        }
      }
      if (modules) {
        for (const moduleName2 of modules) {
          if (moduleName2 === name2) {
            if (baseDir) {
              if (internals) {
                name2 = name2 + path$c.sep + path$c.relative(baseDir, fileURLToPath(filename));
              } else {
                if (!baseDir.endsWith(specifiers.get(filename))) continue;
              }
            }
            callHookFn(hookFn, namespace2, name2, baseDir);
          }
        }
      } else {
        callHookFn(hookFn, namespace2, name2, baseDir);
      }
    };
    addHook(this._iitmHook);
  }
  Hook.prototype.unhook = function() {
    removeHook(this._iitmHook);
  };
  importInTheMiddle.exports = Hook;
  var Hook_1 = importInTheMiddle.exports.Hook = Hook;
  importInTheMiddle.exports.addHook = addHook;
  importInTheMiddle.exports.removeHook = removeHook;
  importInTheMiddle.exports.createAddHookMessageChannel = createAddHookMessageChannel;
  var TMP_DB_SYSTEM = "db.system";
  var TMP_DB_STATEMENT = "db.statement";
  var TMP_EXCEPTION_TYPE = "exception.type";
  var TMP_EXCEPTION_MESSAGE = "exception.message";
  var TMP_EXCEPTION_STACKTRACE = "exception.stacktrace";
  var TMP_FAAS_TRIGGER = "faas.trigger";
  var TMP_HTTP_METHOD = "http.method";
  var TMP_HTTP_URL = "http.url";
  var TMP_HTTP_TARGET = "http.target";
  var TMP_HTTP_STATUS_CODE = "http.status_code";
  var TMP_MESSAGING_SYSTEM = "messaging.system";
  var TMP_RPC_SERVICE = "rpc.service";
  var TMP_RPC_GRPC_STATUS_CODE = "rpc.grpc.status_code";
  var SEMATTRS_DB_SYSTEM = TMP_DB_SYSTEM;
  var SEMATTRS_DB_STATEMENT = TMP_DB_STATEMENT;
  var SEMATTRS_EXCEPTION_TYPE = TMP_EXCEPTION_TYPE;
  var SEMATTRS_EXCEPTION_MESSAGE = TMP_EXCEPTION_MESSAGE;
  var SEMATTRS_EXCEPTION_STACKTRACE = TMP_EXCEPTION_STACKTRACE;
  var SEMATTRS_FAAS_TRIGGER = TMP_FAAS_TRIGGER;
  var SEMATTRS_HTTP_METHOD = TMP_HTTP_METHOD;
  var SEMATTRS_HTTP_URL = TMP_HTTP_URL;
  var SEMATTRS_HTTP_TARGET = TMP_HTTP_TARGET;
  var SEMATTRS_HTTP_STATUS_CODE = TMP_HTTP_STATUS_CODE;
  var SEMATTRS_MESSAGING_SYSTEM = TMP_MESSAGING_SYSTEM;
  var SEMATTRS_RPC_SERVICE = TMP_RPC_SERVICE;
  var SEMATTRS_RPC_GRPC_STATUS_CODE = TMP_RPC_GRPC_STATUS_CODE;
  var TMP_PROCESS_RUNTIME_NAME = "process.runtime.name";
  var TMP_SERVICE_NAME = "service.name";
  var TMP_SERVICE_NAMESPACE = "service.namespace";
  var TMP_TELEMETRY_SDK_NAME = "telemetry.sdk.name";
  var TMP_TELEMETRY_SDK_LANGUAGE = "telemetry.sdk.language";
  var TMP_TELEMETRY_SDK_VERSION = "telemetry.sdk.version";
  var SEMRESATTRS_PROCESS_RUNTIME_NAME = TMP_PROCESS_RUNTIME_NAME;
  var SEMRESATTRS_SERVICE_NAME = TMP_SERVICE_NAME;
  var SEMRESATTRS_SERVICE_NAMESPACE = TMP_SERVICE_NAMESPACE;
  var SEMRESATTRS_TELEMETRY_SDK_NAME = TMP_TELEMETRY_SDK_NAME;
  var SEMRESATTRS_TELEMETRY_SDK_LANGUAGE = TMP_TELEMETRY_SDK_LANGUAGE;
  var SEMRESATTRS_TELEMETRY_SDK_VERSION = TMP_TELEMETRY_SDK_VERSION;
  var TMP_TELEMETRYSDKLANGUAGEVALUES_NODEJS = "nodejs";
  var TELEMETRYSDKLANGUAGEVALUES_NODEJS = TMP_TELEMETRYSDKLANGUAGEVALUES_NODEJS;
  var ATTR_HTTP_REQUEST_METHOD = "http.request.method";
  var ATTR_HTTP_RESPONSE_STATUS_CODE = "http.response.status_code";
  var ATTR_HTTP_ROUTE = "http.route";
  var ATTR_SERVICE_NAME = "service.name";
  var ATTR_SERVICE_VERSION = "service.version";
  var ATTR_URL_FULL = "url.full";
  var SUPPRESS_TRACING_KEY = createContextKey("OpenTelemetry SDK Context Key SUPPRESS_TRACING");
  function suppressTracing$1(context2) {
    return context2.setValue(SUPPRESS_TRACING_KEY, true);
  }
  function unsuppressTracing(context2) {
    return context2.deleteValue(SUPPRESS_TRACING_KEY);
  }
  function isTracingSuppressed(context2) {
    return context2.getValue(SUPPRESS_TRACING_KEY) === true;
  }
  var BAGGAGE_KEY_PAIR_SEPARATOR = "=";
  var BAGGAGE_PROPERTIES_SEPARATOR = ";";
  var BAGGAGE_ITEMS_SEPARATOR = ",";
  var BAGGAGE_HEADER = "baggage";
  var BAGGAGE_MAX_NAME_VALUE_PAIRS = 180;
  var BAGGAGE_MAX_PER_NAME_VALUE_PAIRS = 4096;
  var BAGGAGE_MAX_TOTAL_LENGTH = 8192;
  var __read$6 = function(o2, n2) {
    var m2 = typeof Symbol === "function" && o2[Symbol.iterator];
    if (!m2) return o2;
    var i2 = m2.call(o2), r2, ar = [], e2;
    try {
      while ((n2 === void 0 || n2-- > 0) && !(r2 = i2.next()).done) ar.push(r2.value);
    } catch (error2) {
      e2 = { error: error2 };
    } finally {
      try {
        if (r2 && !r2.done && (m2 = i2["return"])) m2.call(i2);
      } finally {
        if (e2) throw e2.error;
      }
    }
    return ar;
  };
  function serializeKeyPairs(keyPairs) {
    return keyPairs.reduce(function(hValue, current) {
      var value = "" + hValue + (hValue !== "" ? BAGGAGE_ITEMS_SEPARATOR : "") + current;
      return value.length > BAGGAGE_MAX_TOTAL_LENGTH ? hValue : value;
    }, "");
  }
  function getKeyPairs(baggage) {
    return baggage.getAllEntries().map(function(_a3) {
      var _b2 = __read$6(_a3, 2), key = _b2[0], value = _b2[1];
      var entry = encodeURIComponent(key) + "=" + encodeURIComponent(value.value);
      if (value.metadata !== void 0) {
        entry += BAGGAGE_PROPERTIES_SEPARATOR + value.metadata.toString();
      }
      return entry;
    });
  }
  function parsePairKeyValue(entry) {
    var valueProps = entry.split(BAGGAGE_PROPERTIES_SEPARATOR);
    if (valueProps.length <= 0)
      return;
    var keyPairPart = valueProps.shift();
    if (!keyPairPart)
      return;
    var separatorIndex = keyPairPart.indexOf(BAGGAGE_KEY_PAIR_SEPARATOR);
    if (separatorIndex <= 0)
      return;
    var key = decodeURIComponent(keyPairPart.substring(0, separatorIndex).trim());
    var value = decodeURIComponent(keyPairPart.substring(separatorIndex + 1).trim());
    var metadata;
    if (valueProps.length > 0) {
      metadata = baggageEntryMetadataFromString(valueProps.join(BAGGAGE_PROPERTIES_SEPARATOR));
    }
    return { key, value, metadata };
  }
  function parseKeyPairsIntoRecord(value) {
    if (typeof value !== "string" || value.length === 0)
      return {};
    return value.split(BAGGAGE_ITEMS_SEPARATOR).map(function(entry) {
      return parsePairKeyValue(entry);
    }).filter(function(keyPair) {
      return keyPair !== void 0 && keyPair.value.length > 0;
    }).reduce(function(headers, keyPair) {
      headers[keyPair.key] = keyPair.value;
      return headers;
    }, {});
  }
  var W3CBaggagePropagator = (
    /** @class */
    function() {
      function W3CBaggagePropagator2() {
      }
      W3CBaggagePropagator2.prototype.inject = function(context2, carrier, setter) {
        var baggage = propagation.getBaggage(context2);
        if (!baggage || isTracingSuppressed(context2))
          return;
        var keyPairs = getKeyPairs(baggage).filter(function(pair) {
          return pair.length <= BAGGAGE_MAX_PER_NAME_VALUE_PAIRS;
        }).slice(0, BAGGAGE_MAX_NAME_VALUE_PAIRS);
        var headerValue = serializeKeyPairs(keyPairs);
        if (headerValue.length > 0) {
          setter.set(carrier, BAGGAGE_HEADER, headerValue);
        }
      };
      W3CBaggagePropagator2.prototype.extract = function(context2, carrier, getter) {
        var headerValue = getter.get(carrier, BAGGAGE_HEADER);
        var baggageString = Array.isArray(headerValue) ? headerValue.join(BAGGAGE_ITEMS_SEPARATOR) : headerValue;
        if (!baggageString)
          return context2;
        var baggage = {};
        if (baggageString.length === 0) {
          return context2;
        }
        var pairs = baggageString.split(BAGGAGE_ITEMS_SEPARATOR);
        pairs.forEach(function(entry) {
          var keyPair = parsePairKeyValue(entry);
          if (keyPair) {
            var baggageEntry = { value: keyPair.value };
            if (keyPair.metadata) {
              baggageEntry.metadata = keyPair.metadata;
            }
            baggage[keyPair.key] = baggageEntry;
          }
        });
        if (Object.entries(baggage).length === 0) {
          return context2;
        }
        return propagation.setBaggage(context2, propagation.createBaggage(baggage));
      };
      W3CBaggagePropagator2.prototype.fields = function() {
        return [BAGGAGE_HEADER];
      };
      return W3CBaggagePropagator2;
    }()
  );
  var AnchoredClock = (
    /** @class */
    function() {
      function AnchoredClock2(systemClock, monotonicClock) {
        this._monotonicClock = monotonicClock;
        this._epochMillis = systemClock.now();
        this._performanceMillis = monotonicClock.now();
      }
      AnchoredClock2.prototype.now = function() {
        var delta = this._monotonicClock.now() - this._performanceMillis;
        return this._epochMillis + delta;
      };
      return AnchoredClock2;
    }()
  );
  var __values$7 = function(o2) {
    var s2 = typeof Symbol === "function" && Symbol.iterator, m2 = s2 && o2[s2], i2 = 0;
    if (m2) return m2.call(o2);
    if (o2 && typeof o2.length === "number") return {
      next: function() {
        if (o2 && i2 >= o2.length) o2 = void 0;
        return { value: o2 && o2[i2++], done: !o2 };
      }
    };
    throw new TypeError(s2 ? "Object is not iterable." : "Symbol.iterator is not defined.");
  };
  var __read$5 = function(o2, n2) {
    var m2 = typeof Symbol === "function" && o2[Symbol.iterator];
    if (!m2) return o2;
    var i2 = m2.call(o2), r2, ar = [], e2;
    try {
      while ((n2 === void 0 || n2-- > 0) && !(r2 = i2.next()).done) ar.push(r2.value);
    } catch (error2) {
      e2 = { error: error2 };
    } finally {
      try {
        if (r2 && !r2.done && (m2 = i2["return"])) m2.call(i2);
      } finally {
        if (e2) throw e2.error;
      }
    }
    return ar;
  };
  function sanitizeAttributes(attributes) {
    var e_1, _a3;
    var out = {};
    if (typeof attributes !== "object" || attributes == null) {
      return out;
    }
    try {
      for (var _b2 = __values$7(Object.entries(attributes)), _c2 = _b2.next(); !_c2.done; _c2 = _b2.next()) {
        var _d = __read$5(_c2.value, 2), key = _d[0], val = _d[1];
        if (!isAttributeKey(key)) {
          diag.warn("Invalid attribute key: " + key);
          continue;
        }
        if (!isAttributeValue(val)) {
          diag.warn("Invalid attribute value set for key: " + key);
          continue;
        }
        if (Array.isArray(val)) {
          out[key] = val.slice();
        } else {
          out[key] = val;
        }
      }
    } catch (e_1_1) {
      e_1 = { error: e_1_1 };
    } finally {
      try {
        if (_c2 && !_c2.done && (_a3 = _b2.return)) _a3.call(_b2);
      } finally {
        if (e_1) throw e_1.error;
      }
    }
    return out;
  }
  function isAttributeKey(key) {
    return typeof key === "string" && key.length > 0;
  }
  function isAttributeValue(val) {
    if (val == null) {
      return true;
    }
    if (Array.isArray(val)) {
      return isHomogeneousAttributeValueArray(val);
    }
    return isValidPrimitiveAttributeValue(val);
  }
  function isHomogeneousAttributeValueArray(arr) {
    var e_2, _a3;
    var type2;
    try {
      for (var arr_1 = __values$7(arr), arr_1_1 = arr_1.next(); !arr_1_1.done; arr_1_1 = arr_1.next()) {
        var element = arr_1_1.value;
        if (element == null)
          continue;
        if (!type2) {
          if (isValidPrimitiveAttributeValue(element)) {
            type2 = typeof element;
            continue;
          }
          return false;
        }
        if (typeof element === type2) {
          continue;
        }
        return false;
      }
    } catch (e_2_1) {
      e_2 = { error: e_2_1 };
    } finally {
      try {
        if (arr_1_1 && !arr_1_1.done && (_a3 = arr_1.return)) _a3.call(arr_1);
      } finally {
        if (e_2) throw e_2.error;
      }
    }
    return true;
  }
  function isValidPrimitiveAttributeValue(val) {
    switch (typeof val) {
      case "number":
      case "boolean":
      case "string":
        return true;
    }
    return false;
  }
  function loggingErrorHandler() {
    return function(ex) {
      diag.error(stringifyException(ex));
    };
  }
  function stringifyException(ex) {
    if (typeof ex === "string") {
      return ex;
    } else {
      return JSON.stringify(flattenException(ex));
    }
  }
  function flattenException(ex) {
    var result = {};
    var current = ex;
    while (current !== null) {
      Object.getOwnPropertyNames(current).forEach(function(propertyName) {
        if (result[propertyName])
          return;
        var value = current[propertyName];
        if (value) {
          result[propertyName] = String(value);
        }
      });
      current = Object.getPrototypeOf(current);
    }
    return result;
  }
  var delegateHandler = loggingErrorHandler();
  function setGlobalErrorHandler(handler) {
    delegateHandler = handler;
  }
  function globalErrorHandler(ex) {
    try {
      delegateHandler(ex);
    } catch (_a3) {
    }
  }
  var TracesSamplerValues;
  (function(TracesSamplerValues2) {
    TracesSamplerValues2["AlwaysOff"] = "always_off";
    TracesSamplerValues2["AlwaysOn"] = "always_on";
    TracesSamplerValues2["ParentBasedAlwaysOff"] = "parentbased_always_off";
    TracesSamplerValues2["ParentBasedAlwaysOn"] = "parentbased_always_on";
    TracesSamplerValues2["ParentBasedTraceIdRatio"] = "parentbased_traceidratio";
    TracesSamplerValues2["TraceIdRatio"] = "traceidratio";
  })(TracesSamplerValues || (TracesSamplerValues = {}));
  var DEFAULT_LIST_SEPARATOR = ",";
  var ENVIRONMENT_BOOLEAN_KEYS = ["OTEL_SDK_DISABLED"];
  function isEnvVarABoolean(key) {
    return ENVIRONMENT_BOOLEAN_KEYS.indexOf(key) > -1;
  }
  var ENVIRONMENT_NUMBERS_KEYS = [
    "OTEL_BSP_EXPORT_TIMEOUT",
    "OTEL_BSP_MAX_EXPORT_BATCH_SIZE",
    "OTEL_BSP_MAX_QUEUE_SIZE",
    "OTEL_BSP_SCHEDULE_DELAY",
    "OTEL_BLRP_EXPORT_TIMEOUT",
    "OTEL_BLRP_MAX_EXPORT_BATCH_SIZE",
    "OTEL_BLRP_MAX_QUEUE_SIZE",
    "OTEL_BLRP_SCHEDULE_DELAY",
    "OTEL_ATTRIBUTE_VALUE_LENGTH_LIMIT",
    "OTEL_ATTRIBUTE_COUNT_LIMIT",
    "OTEL_SPAN_ATTRIBUTE_VALUE_LENGTH_LIMIT",
    "OTEL_SPAN_ATTRIBUTE_COUNT_LIMIT",
    "OTEL_LOGRECORD_ATTRIBUTE_VALUE_LENGTH_LIMIT",
    "OTEL_LOGRECORD_ATTRIBUTE_COUNT_LIMIT",
    "OTEL_SPAN_EVENT_COUNT_LIMIT",
    "OTEL_SPAN_LINK_COUNT_LIMIT",
    "OTEL_SPAN_ATTRIBUTE_PER_EVENT_COUNT_LIMIT",
    "OTEL_SPAN_ATTRIBUTE_PER_LINK_COUNT_LIMIT",
    "OTEL_EXPORTER_OTLP_TIMEOUT",
    "OTEL_EXPORTER_OTLP_TRACES_TIMEOUT",
    "OTEL_EXPORTER_OTLP_METRICS_TIMEOUT",
    "OTEL_EXPORTER_OTLP_LOGS_TIMEOUT",
    "OTEL_EXPORTER_JAEGER_AGENT_PORT"
  ];
  function isEnvVarANumber(key) {
    return ENVIRONMENT_NUMBERS_KEYS.indexOf(key) > -1;
  }
  var ENVIRONMENT_LISTS_KEYS = [
    "OTEL_NO_PATCH_MODULES",
    "OTEL_PROPAGATORS",
    "OTEL_SEMCONV_STABILITY_OPT_IN"
  ];
  function isEnvVarAList(key) {
    return ENVIRONMENT_LISTS_KEYS.indexOf(key) > -1;
  }
  var DEFAULT_ATTRIBUTE_VALUE_LENGTH_LIMIT = Infinity;
  var DEFAULT_ATTRIBUTE_COUNT_LIMIT = 128;
  var DEFAULT_SPAN_ATTRIBUTE_PER_EVENT_COUNT_LIMIT = 128;
  var DEFAULT_SPAN_ATTRIBUTE_PER_LINK_COUNT_LIMIT = 128;
  var DEFAULT_ENVIRONMENT = {
    OTEL_SDK_DISABLED: false,
    CONTAINER_NAME: "",
    ECS_CONTAINER_METADATA_URI_V4: "",
    ECS_CONTAINER_METADATA_URI: "",
    HOSTNAME: "",
    KUBERNETES_SERVICE_HOST: "",
    NAMESPACE: "",
    OTEL_BSP_EXPORT_TIMEOUT: 3e4,
    OTEL_BSP_MAX_EXPORT_BATCH_SIZE: 512,
    OTEL_BSP_MAX_QUEUE_SIZE: 2048,
    OTEL_BSP_SCHEDULE_DELAY: 5e3,
    OTEL_BLRP_EXPORT_TIMEOUT: 3e4,
    OTEL_BLRP_MAX_EXPORT_BATCH_SIZE: 512,
    OTEL_BLRP_MAX_QUEUE_SIZE: 2048,
    OTEL_BLRP_SCHEDULE_DELAY: 5e3,
    OTEL_EXPORTER_JAEGER_AGENT_HOST: "",
    OTEL_EXPORTER_JAEGER_AGENT_PORT: 6832,
    OTEL_EXPORTER_JAEGER_ENDPOINT: "",
    OTEL_EXPORTER_JAEGER_PASSWORD: "",
    OTEL_EXPORTER_JAEGER_USER: "",
    OTEL_EXPORTER_OTLP_ENDPOINT: "",
    OTEL_EXPORTER_OTLP_TRACES_ENDPOINT: "",
    OTEL_EXPORTER_OTLP_METRICS_ENDPOINT: "",
    OTEL_EXPORTER_OTLP_LOGS_ENDPOINT: "",
    OTEL_EXPORTER_OTLP_HEADERS: "",
    OTEL_EXPORTER_OTLP_TRACES_HEADERS: "",
    OTEL_EXPORTER_OTLP_METRICS_HEADERS: "",
    OTEL_EXPORTER_OTLP_LOGS_HEADERS: "",
    OTEL_EXPORTER_OTLP_TIMEOUT: 1e4,
    OTEL_EXPORTER_OTLP_TRACES_TIMEOUT: 1e4,
    OTEL_EXPORTER_OTLP_METRICS_TIMEOUT: 1e4,
    OTEL_EXPORTER_OTLP_LOGS_TIMEOUT: 1e4,
    OTEL_EXPORTER_ZIPKIN_ENDPOINT: "http://localhost:9411/api/v2/spans",
    OTEL_LOG_LEVEL: DiagLogLevel.INFO,
    OTEL_NO_PATCH_MODULES: [],
    OTEL_PROPAGATORS: ["tracecontext", "baggage"],
    OTEL_RESOURCE_ATTRIBUTES: "",
    OTEL_SERVICE_NAME: "",
    OTEL_ATTRIBUTE_VALUE_LENGTH_LIMIT: DEFAULT_ATTRIBUTE_VALUE_LENGTH_LIMIT,
    OTEL_ATTRIBUTE_COUNT_LIMIT: DEFAULT_ATTRIBUTE_COUNT_LIMIT,
    OTEL_SPAN_ATTRIBUTE_VALUE_LENGTH_LIMIT: DEFAULT_ATTRIBUTE_VALUE_LENGTH_LIMIT,
    OTEL_SPAN_ATTRIBUTE_COUNT_LIMIT: DEFAULT_ATTRIBUTE_COUNT_LIMIT,
    OTEL_LOGRECORD_ATTRIBUTE_VALUE_LENGTH_LIMIT: DEFAULT_ATTRIBUTE_VALUE_LENGTH_LIMIT,
    OTEL_LOGRECORD_ATTRIBUTE_COUNT_LIMIT: DEFAULT_ATTRIBUTE_COUNT_LIMIT,
    OTEL_SPAN_EVENT_COUNT_LIMIT: 128,
    OTEL_SPAN_LINK_COUNT_LIMIT: 128,
    OTEL_SPAN_ATTRIBUTE_PER_EVENT_COUNT_LIMIT: DEFAULT_SPAN_ATTRIBUTE_PER_EVENT_COUNT_LIMIT,
    OTEL_SPAN_ATTRIBUTE_PER_LINK_COUNT_LIMIT: DEFAULT_SPAN_ATTRIBUTE_PER_LINK_COUNT_LIMIT,
    OTEL_TRACES_EXPORTER: "",
    OTEL_TRACES_SAMPLER: TracesSamplerValues.ParentBasedAlwaysOn,
    OTEL_TRACES_SAMPLER_ARG: "",
    OTEL_LOGS_EXPORTER: "",
    OTEL_EXPORTER_OTLP_INSECURE: "",
    OTEL_EXPORTER_OTLP_TRACES_INSECURE: "",
    OTEL_EXPORTER_OTLP_METRICS_INSECURE: "",
    OTEL_EXPORTER_OTLP_LOGS_INSECURE: "",
    OTEL_EXPORTER_OTLP_CERTIFICATE: "",
    OTEL_EXPORTER_OTLP_TRACES_CERTIFICATE: "",
    OTEL_EXPORTER_OTLP_METRICS_CERTIFICATE: "",
    OTEL_EXPORTER_OTLP_LOGS_CERTIFICATE: "",
    OTEL_EXPORTER_OTLP_COMPRESSION: "",
    OTEL_EXPORTER_OTLP_TRACES_COMPRESSION: "",
    OTEL_EXPORTER_OTLP_METRICS_COMPRESSION: "",
    OTEL_EXPORTER_OTLP_LOGS_COMPRESSION: "",
    OTEL_EXPORTER_OTLP_CLIENT_KEY: "",
    OTEL_EXPORTER_OTLP_TRACES_CLIENT_KEY: "",
    OTEL_EXPORTER_OTLP_METRICS_CLIENT_KEY: "",
    OTEL_EXPORTER_OTLP_LOGS_CLIENT_KEY: "",
    OTEL_EXPORTER_OTLP_CLIENT_CERTIFICATE: "",
    OTEL_EXPORTER_OTLP_TRACES_CLIENT_CERTIFICATE: "",
    OTEL_EXPORTER_OTLP_METRICS_CLIENT_CERTIFICATE: "",
    OTEL_EXPORTER_OTLP_LOGS_CLIENT_CERTIFICATE: "",
    OTEL_EXPORTER_OTLP_PROTOCOL: "http/protobuf",
    OTEL_EXPORTER_OTLP_TRACES_PROTOCOL: "http/protobuf",
    OTEL_EXPORTER_OTLP_METRICS_PROTOCOL: "http/protobuf",
    OTEL_EXPORTER_OTLP_LOGS_PROTOCOL: "http/protobuf",
    OTEL_EXPORTER_OTLP_METRICS_TEMPORALITY_PREFERENCE: "cumulative",
    OTEL_SEMCONV_STABILITY_OPT_IN: []
  };
  function parseBoolean(key, environment, values) {
    if (typeof values[key] === "undefined") {
      return;
    }
    var value = String(values[key]);
    environment[key] = value.toLowerCase() === "true";
  }
  function parseNumber(name2, environment, values, min, max2) {
    if (min === void 0) {
      min = -Infinity;
    }
    if (max2 === void 0) {
      max2 = Infinity;
    }
    if (typeof values[name2] !== "undefined") {
      var value = Number(values[name2]);
      if (!isNaN(value)) {
        if (value < min) {
          environment[name2] = min;
        } else if (value > max2) {
          environment[name2] = max2;
        } else {
          environment[name2] = value;
        }
      }
    }
  }
  function parseStringList(name2, output, input, separator2) {
    if (separator2 === void 0) {
      separator2 = DEFAULT_LIST_SEPARATOR;
    }
    var givenValue = input[name2];
    if (typeof givenValue === "string") {
      output[name2] = givenValue.split(separator2).map(function(v2) {
        return v2.trim();
      });
    }
  }
  var logLevelMap = {
    ALL: DiagLogLevel.ALL,
    VERBOSE: DiagLogLevel.VERBOSE,
    DEBUG: DiagLogLevel.DEBUG,
    INFO: DiagLogLevel.INFO,
    WARN: DiagLogLevel.WARN,
    ERROR: DiagLogLevel.ERROR,
    NONE: DiagLogLevel.NONE
  };
  function setLogLevelFromEnv(key, environment, values) {
    var value = values[key];
    if (typeof value === "string") {
      var theLevel = logLevelMap[value.toUpperCase()];
      if (theLevel != null) {
        environment[key] = theLevel;
      }
    }
  }
  function parseEnvironment(values) {
    var environment = {};
    for (var env2 in DEFAULT_ENVIRONMENT) {
      var key = env2;
      switch (key) {
        case "OTEL_LOG_LEVEL":
          setLogLevelFromEnv(key, environment, values);
          break;
        default:
          if (isEnvVarABoolean(key)) {
            parseBoolean(key, environment, values);
          } else if (isEnvVarANumber(key)) {
            parseNumber(key, environment, values);
          } else if (isEnvVarAList(key)) {
            parseStringList(key, environment, values);
          } else {
            var value = values[key];
            if (typeof value !== "undefined" && value !== null) {
              environment[key] = String(value);
            }
          }
      }
    }
    return environment;
  }
  function getEnv$1() {
    var processEnv = parseEnvironment(process.env);
    return Object.assign({}, DEFAULT_ENVIRONMENT, processEnv);
  }
  function getEnvWithoutDefaults() {
    return parseEnvironment(process.env);
  }
  var _globalThis$2 = typeof globalThis === "object" ? globalThis : global;
  function intValue(charCode) {
    if (charCode >= 48 && charCode <= 57) {
      return charCode - 48;
    }
    if (charCode >= 97 && charCode <= 102) {
      return charCode - 87;
    }
    return charCode - 55;
  }
  function hexToBinary(hexStr) {
    var buf = new Uint8Array(hexStr.length / 2);
    var offset = 0;
    for (var i2 = 0; i2 < hexStr.length; i2 += 2) {
      var hi = intValue(hexStr.charCodeAt(i2));
      var lo = intValue(hexStr.charCodeAt(i2 + 1));
      buf[offset++] = hi << 4 | lo;
    }
    return buf;
  }
  function hexToBase64(hexStr) {
    return Buffer.from(hexToBinary(hexStr)).toString("base64");
  }
  var SPAN_ID_BYTES$1 = 8;
  var TRACE_ID_BYTES$1 = 16;
  var RandomIdGenerator$1 = (
    /** @class */
    /* @__PURE__ */ function() {
      function RandomIdGenerator2() {
        this.generateTraceId = getIdGenerator$1(TRACE_ID_BYTES$1);
        this.generateSpanId = getIdGenerator$1(SPAN_ID_BYTES$1);
      }
      return RandomIdGenerator2;
    }()
  );
  var SHARED_BUFFER$1 = Buffer.allocUnsafe(TRACE_ID_BYTES$1);
  function getIdGenerator$1(bytes) {
    return function generateId() {
      for (var i2 = 0; i2 < bytes / 4; i2++) {
        SHARED_BUFFER$1.writeUInt32BE(Math.random() * Math.pow(2, 32) >>> 0, i2 * 4);
      }
      for (var i2 = 0; i2 < bytes; i2++) {
        if (SHARED_BUFFER$1[i2] > 0) {
          break;
        } else if (i2 === bytes - 1) {
          SHARED_BUFFER$1[bytes - 1] = 1;
        }
      }
      return SHARED_BUFFER$1.toString("hex", 0, bytes);
    };
  }
  var otperformance = perf_hooks$2.performance;
  var VERSION$1 = "1.30.0";
  var _a;
  var SDK_INFO = (_a = {}, _a[SEMRESATTRS_TELEMETRY_SDK_NAME] = "opentelemetry", _a[SEMRESATTRS_PROCESS_RUNTIME_NAME] = "node", _a[SEMRESATTRS_TELEMETRY_SDK_LANGUAGE] = TELEMETRYSDKLANGUAGEVALUES_NODEJS, _a[SEMRESATTRS_TELEMETRY_SDK_VERSION] = VERSION$1, _a);
  function unrefTimer(timer) {
    timer.unref();
  }
  var NANOSECOND_DIGITS = 9;
  var NANOSECOND_DIGITS_IN_MILLIS = 6;
  var MILLISECONDS_TO_NANOSECONDS = Math.pow(10, NANOSECOND_DIGITS_IN_MILLIS);
  var SECOND_TO_NANOSECONDS = Math.pow(10, NANOSECOND_DIGITS);
  function millisToHrTime(epochMillis) {
    var epochSeconds = epochMillis / 1e3;
    var seconds = Math.trunc(epochSeconds);
    var nanos = Math.round(epochMillis % 1e3 * MILLISECONDS_TO_NANOSECONDS);
    return [seconds, nanos];
  }
  function getTimeOrigin() {
    var timeOrigin = otperformance.timeOrigin;
    if (typeof timeOrigin !== "number") {
      var perf = otperformance;
      timeOrigin = perf.timing && perf.timing.fetchStart;
    }
    return timeOrigin;
  }
  function hrTime(performanceNow) {
    var timeOrigin = millisToHrTime(getTimeOrigin());
    var now = millisToHrTime(typeof performanceNow === "number" ? performanceNow : otperformance.now());
    return addHrTimes(timeOrigin, now);
  }
  function timeInputToHrTime(time) {
    if (isTimeInputHrTime(time)) {
      return time;
    } else if (typeof time === "number") {
      if (time < getTimeOrigin()) {
        return hrTime(time);
      } else {
        return millisToHrTime(time);
      }
    } else if (time instanceof Date) {
      return millisToHrTime(time.getTime());
    } else {
      throw TypeError("Invalid input type");
    }
  }
  function hrTimeDuration(startTime, endTime) {
    var seconds = endTime[0] - startTime[0];
    var nanos = endTime[1] - startTime[1];
    if (nanos < 0) {
      seconds -= 1;
      nanos += SECOND_TO_NANOSECONDS;
    }
    return [seconds, nanos];
  }
  function hrTimeToTimeStamp(time) {
    var precision = NANOSECOND_DIGITS;
    var tmp = "" + "0".repeat(precision) + time[1] + "Z";
    var nanoString = tmp.substring(tmp.length - precision - 1);
    var date = new Date(time[0] * 1e3).toISOString();
    return date.replace("000Z", nanoString);
  }
  function hrTimeToNanoseconds(time) {
    return time[0] * SECOND_TO_NANOSECONDS + time[1];
  }
  function hrTimeToMilliseconds(time) {
    return time[0] * 1e3 + time[1] / 1e6;
  }
  function hrTimeToMicroseconds(time) {
    return time[0] * 1e6 + time[1] / 1e3;
  }
  function isTimeInputHrTime(value) {
    return Array.isArray(value) && value.length === 2 && typeof value[0] === "number" && typeof value[1] === "number";
  }
  function isTimeInput(value) {
    return isTimeInputHrTime(value) || typeof value === "number" || value instanceof Date;
  }
  function addHrTimes(time1, time2) {
    var out = [time1[0] + time2[0], time1[1] + time2[1]];
    if (out[1] >= SECOND_TO_NANOSECONDS) {
      out[1] -= SECOND_TO_NANOSECONDS;
      out[0] += 1;
    }
    return out;
  }
  var ExportResultCode;
  (function(ExportResultCode2) {
    ExportResultCode2[ExportResultCode2["SUCCESS"] = 0] = "SUCCESS";
    ExportResultCode2[ExportResultCode2["FAILED"] = 1] = "FAILED";
  })(ExportResultCode || (ExportResultCode = {}));
  var __values$6 = function(o2) {
    var s2 = typeof Symbol === "function" && Symbol.iterator, m2 = s2 && o2[s2], i2 = 0;
    if (m2) return m2.call(o2);
    if (o2 && typeof o2.length === "number") return {
      next: function() {
        if (o2 && i2 >= o2.length) o2 = void 0;
        return { value: o2 && o2[i2++], done: !o2 };
      }
    };
    throw new TypeError(s2 ? "Object is not iterable." : "Symbol.iterator is not defined.");
  };
  var CompositePropagator = (
    /** @class */
    function() {
      function CompositePropagator2(config2) {
        if (config2 === void 0) {
          config2 = {};
        }
        var _a3;
        this._propagators = (_a3 = config2.propagators) !== null && _a3 !== void 0 ? _a3 : [];
        this._fields = Array.from(new Set(this._propagators.map(function(p2) {
          return typeof p2.fields === "function" ? p2.fields() : [];
        }).reduce(function(x2, y2) {
          return x2.concat(y2);
        }, [])));
      }
      CompositePropagator2.prototype.inject = function(context2, carrier, setter) {
        var e_1, _a3;
        try {
          for (var _b2 = __values$6(this._propagators), _c2 = _b2.next(); !_c2.done; _c2 = _b2.next()) {
            var propagator = _c2.value;
            try {
              propagator.inject(context2, carrier, setter);
            } catch (err) {
              diag.warn("Failed to inject with " + propagator.constructor.name + ". Err: " + err.message);
            }
          }
        } catch (e_1_1) {
          e_1 = { error: e_1_1 };
        } finally {
          try {
            if (_c2 && !_c2.done && (_a3 = _b2.return)) _a3.call(_b2);
          } finally {
            if (e_1) throw e_1.error;
          }
        }
      };
      CompositePropagator2.prototype.extract = function(context2, carrier, getter) {
        return this._propagators.reduce(function(ctx, propagator) {
          try {
            return propagator.extract(ctx, carrier, getter);
          } catch (err) {
            diag.warn("Failed to extract with " + propagator.constructor.name + ". Err: " + err.message);
          }
          return ctx;
        }, context2);
      };
      CompositePropagator2.prototype.fields = function() {
        return this._fields.slice();
      };
      return CompositePropagator2;
    }()
  );
  var VALID_KEY_CHAR_RANGE = "[_0-9a-z-*/]";
  var VALID_KEY = "[a-z]" + VALID_KEY_CHAR_RANGE + "{0,255}";
  var VALID_VENDOR_KEY = "[a-z0-9]" + VALID_KEY_CHAR_RANGE + "{0,240}@[a-z]" + VALID_KEY_CHAR_RANGE + "{0,13}";
  var VALID_KEY_REGEX = new RegExp("^(?:" + VALID_KEY + "|" + VALID_VENDOR_KEY + ")$");
  var VALID_VALUE_BASE_REGEX = /^[ -~]{0,255}[!-~]$/;
  var INVALID_VALUE_COMMA_EQUAL_REGEX = /,|=/;
  function validateKey(key) {
    return VALID_KEY_REGEX.test(key);
  }
  function validateValue(value) {
    return VALID_VALUE_BASE_REGEX.test(value) && !INVALID_VALUE_COMMA_EQUAL_REGEX.test(value);
  }
  var MAX_TRACE_STATE_ITEMS = 32;
  var MAX_TRACE_STATE_LEN = 512;
  var LIST_MEMBERS_SEPARATOR = ",";
  var LIST_MEMBER_KEY_VALUE_SPLITTER = "=";
  var TraceState = (
    /** @class */
    function() {
      function TraceState2(rawTraceState) {
        this._internalState = /* @__PURE__ */ new Map();
        if (rawTraceState)
          this._parse(rawTraceState);
      }
      TraceState2.prototype.set = function(key, value) {
        var traceState = this._clone();
        if (traceState._internalState.has(key)) {
          traceState._internalState.delete(key);
        }
        traceState._internalState.set(key, value);
        return traceState;
      };
      TraceState2.prototype.unset = function(key) {
        var traceState = this._clone();
        traceState._internalState.delete(key);
        return traceState;
      };
      TraceState2.prototype.get = function(key) {
        return this._internalState.get(key);
      };
      TraceState2.prototype.serialize = function() {
        var _this = this;
        return this._keys().reduce(function(agg, key) {
          agg.push(key + LIST_MEMBER_KEY_VALUE_SPLITTER + _this.get(key));
          return agg;
        }, []).join(LIST_MEMBERS_SEPARATOR);
      };
      TraceState2.prototype._parse = function(rawTraceState) {
        if (rawTraceState.length > MAX_TRACE_STATE_LEN)
          return;
        this._internalState = rawTraceState.split(LIST_MEMBERS_SEPARATOR).reverse().reduce(function(agg, part) {
          var listMember = part.trim();
          var i2 = listMember.indexOf(LIST_MEMBER_KEY_VALUE_SPLITTER);
          if (i2 !== -1) {
            var key = listMember.slice(0, i2);
            var value = listMember.slice(i2 + 1, part.length);
            if (validateKey(key) && validateValue(value)) {
              agg.set(key, value);
            }
          }
          return agg;
        }, /* @__PURE__ */ new Map());
        if (this._internalState.size > MAX_TRACE_STATE_ITEMS) {
          this._internalState = new Map(Array.from(this._internalState.entries()).reverse().slice(0, MAX_TRACE_STATE_ITEMS));
        }
      };
      TraceState2.prototype._keys = function() {
        return Array.from(this._internalState.keys()).reverse();
      };
      TraceState2.prototype._clone = function() {
        var traceState = new TraceState2();
        traceState._internalState = new Map(this._internalState);
        return traceState;
      };
      return TraceState2;
    }()
  );
  var TRACE_PARENT_HEADER = "traceparent";
  var TRACE_STATE_HEADER = "tracestate";
  var VERSION = "00";
  var VERSION_PART = "(?!ff)[\\da-f]{2}";
  var TRACE_ID_PART = "(?![0]{32})[\\da-f]{32}";
  var PARENT_ID_PART = "(?![0]{16})[\\da-f]{16}";
  var FLAGS_PART = "[\\da-f]{2}";
  var TRACE_PARENT_REGEX = new RegExp("^\\s?(" + VERSION_PART + ")-(" + TRACE_ID_PART + ")-(" + PARENT_ID_PART + ")-(" + FLAGS_PART + ")(-.*)?\\s?$");
  function parseTraceParent(traceParent) {
    var match = TRACE_PARENT_REGEX.exec(traceParent);
    if (!match)
      return null;
    if (match[1] === "00" && match[5])
      return null;
    return {
      traceId: match[2],
      spanId: match[3],
      traceFlags: parseInt(match[4], 16)
    };
  }
  var W3CTraceContextPropagator = (
    /** @class */
    function() {
      function W3CTraceContextPropagator2() {
      }
      W3CTraceContextPropagator2.prototype.inject = function(context2, carrier, setter) {
        var spanContext = trace.getSpanContext(context2);
        if (!spanContext || isTracingSuppressed(context2) || !isSpanContextValid(spanContext))
          return;
        var traceParent = VERSION + "-" + spanContext.traceId + "-" + spanContext.spanId + "-0" + Number(spanContext.traceFlags || TraceFlags.NONE).toString(16);
        setter.set(carrier, TRACE_PARENT_HEADER, traceParent);
        if (spanContext.traceState) {
          setter.set(carrier, TRACE_STATE_HEADER, spanContext.traceState.serialize());
        }
      };
      W3CTraceContextPropagator2.prototype.extract = function(context2, carrier, getter) {
        var traceParentHeader = getter.get(carrier, TRACE_PARENT_HEADER);
        if (!traceParentHeader)
          return context2;
        var traceParent = Array.isArray(traceParentHeader) ? traceParentHeader[0] : traceParentHeader;
        if (typeof traceParent !== "string")
          return context2;
        var spanContext = parseTraceParent(traceParent);
        if (!spanContext)
          return context2;
        spanContext.isRemote = true;
        var traceStateHeader = getter.get(carrier, TRACE_STATE_HEADER);
        if (traceStateHeader) {
          var state = Array.isArray(traceStateHeader) ? traceStateHeader.join(",") : traceStateHeader;
          spanContext.traceState = new TraceState(typeof state === "string" ? state : void 0);
        }
        return trace.setSpanContext(context2, spanContext);
      };
      W3CTraceContextPropagator2.prototype.fields = function() {
        return [TRACE_PARENT_HEADER, TRACE_STATE_HEADER];
      };
      return W3CTraceContextPropagator2;
    }()
  );
  var RPC_METADATA_KEY = createContextKey("OpenTelemetry SDK Context Key RPC_METADATA");
  var RPCType;
  (function(RPCType2) {
    RPCType2["HTTP"] = "http";
  })(RPCType || (RPCType = {}));
  function setRPCMetadata(context2, meta) {
    return context2.setValue(RPC_METADATA_KEY, meta);
  }
  function deleteRPCMetadata(context2) {
    return context2.deleteValue(RPC_METADATA_KEY);
  }
  function getRPCMetadata(context2) {
    return context2.getValue(RPC_METADATA_KEY);
  }
  var AlwaysOffSampler$1 = (
    /** @class */
    function() {
      function AlwaysOffSampler2() {
      }
      AlwaysOffSampler2.prototype.shouldSample = function() {
        return {
          decision: SamplingDecision$1.NOT_RECORD
        };
      };
      AlwaysOffSampler2.prototype.toString = function() {
        return "AlwaysOffSampler";
      };
      return AlwaysOffSampler2;
    }()
  );
  var AlwaysOnSampler$1 = (
    /** @class */
    function() {
      function AlwaysOnSampler2() {
      }
      AlwaysOnSampler2.prototype.shouldSample = function() {
        return {
          decision: SamplingDecision$1.RECORD_AND_SAMPLED
        };
      };
      AlwaysOnSampler2.prototype.toString = function() {
        return "AlwaysOnSampler";
      };
      return AlwaysOnSampler2;
    }()
  );
  var ParentBasedSampler$1 = (
    /** @class */
    function() {
      function ParentBasedSampler2(config2) {
        var _a3, _b2, _c2, _d;
        this._root = config2.root;
        if (!this._root) {
          globalErrorHandler(new Error("ParentBasedSampler must have a root sampler configured"));
          this._root = new AlwaysOnSampler$1();
        }
        this._remoteParentSampled = (_a3 = config2.remoteParentSampled) !== null && _a3 !== void 0 ? _a3 : new AlwaysOnSampler$1();
        this._remoteParentNotSampled = (_b2 = config2.remoteParentNotSampled) !== null && _b2 !== void 0 ? _b2 : new AlwaysOffSampler$1();
        this._localParentSampled = (_c2 = config2.localParentSampled) !== null && _c2 !== void 0 ? _c2 : new AlwaysOnSampler$1();
        this._localParentNotSampled = (_d = config2.localParentNotSampled) !== null && _d !== void 0 ? _d : new AlwaysOffSampler$1();
      }
      ParentBasedSampler2.prototype.shouldSample = function(context2, traceId, spanName, spanKind, attributes, links) {
        var parentContext = trace.getSpanContext(context2);
        if (!parentContext || !isSpanContextValid(parentContext)) {
          return this._root.shouldSample(context2, traceId, spanName, spanKind, attributes, links);
        }
        if (parentContext.isRemote) {
          if (parentContext.traceFlags & TraceFlags.SAMPLED) {
            return this._remoteParentSampled.shouldSample(context2, traceId, spanName, spanKind, attributes, links);
          }
          return this._remoteParentNotSampled.shouldSample(context2, traceId, spanName, spanKind, attributes, links);
        }
        if (parentContext.traceFlags & TraceFlags.SAMPLED) {
          return this._localParentSampled.shouldSample(context2, traceId, spanName, spanKind, attributes, links);
        }
        return this._localParentNotSampled.shouldSample(context2, traceId, spanName, spanKind, attributes, links);
      };
      ParentBasedSampler2.prototype.toString = function() {
        return "ParentBased{root=" + this._root.toString() + ", remoteParentSampled=" + this._remoteParentSampled.toString() + ", remoteParentNotSampled=" + this._remoteParentNotSampled.toString() + ", localParentSampled=" + this._localParentSampled.toString() + ", localParentNotSampled=" + this._localParentNotSampled.toString() + "}";
      };
      return ParentBasedSampler2;
    }()
  );
  var TraceIdRatioBasedSampler$1 = (
    /** @class */
    function() {
      function TraceIdRatioBasedSampler2(_ratio) {
        if (_ratio === void 0) {
          _ratio = 0;
        }
        this._ratio = _ratio;
        this._ratio = this._normalize(_ratio);
        this._upperBound = Math.floor(this._ratio * 4294967295);
      }
      TraceIdRatioBasedSampler2.prototype.shouldSample = function(context2, traceId) {
        return {
          decision: isValidTraceId(traceId) && this._accumulate(traceId) < this._upperBound ? SamplingDecision$1.RECORD_AND_SAMPLED : SamplingDecision$1.NOT_RECORD
        };
      };
      TraceIdRatioBasedSampler2.prototype.toString = function() {
        return "TraceIdRatioBased{" + this._ratio + "}";
      };
      TraceIdRatioBasedSampler2.prototype._normalize = function(ratio) {
        if (typeof ratio !== "number" || isNaN(ratio))
          return 0;
        return ratio >= 1 ? 1 : ratio <= 0 ? 0 : ratio;
      };
      TraceIdRatioBasedSampler2.prototype._accumulate = function(traceId) {
        var accumulation = 0;
        for (var i2 = 0; i2 < traceId.length / 8; i2++) {
          var pos = i2 * 8;
          var part = parseInt(traceId.slice(pos, pos + 8), 16);
          accumulation = (accumulation ^ part) >>> 0;
        }
        return accumulation;
      };
      return TraceIdRatioBasedSampler2;
    }()
  );
  var objectTag$3 = "[object Object]";
  var nullTag$1 = "[object Null]";
  var undefinedTag$1 = "[object Undefined]";
  var funcProto$2 = Function.prototype;
  var funcToString$2 = funcProto$2.toString;
  var objectCtorString = funcToString$2.call(Object);
  var getPrototype = overArg$1(Object.getPrototypeOf, Object);
  var objectProto$c = Object.prototype;
  var hasOwnProperty$9 = objectProto$c.hasOwnProperty;
  var symToStringTag$2 = Symbol ? Symbol.toStringTag : void 0;
  var nativeObjectToString$2 = objectProto$c.toString;
  function overArg$1(func, transform2) {
    return function(arg) {
      return func(transform2(arg));
    };
  }
  function isPlainObject(value) {
    if (!isObjectLike$1(value) || baseGetTag$1(value) !== objectTag$3) {
      return false;
    }
    var proto = getPrototype(value);
    if (proto === null) {
      return true;
    }
    var Ctor = hasOwnProperty$9.call(proto, "constructor") && proto.constructor;
    return typeof Ctor == "function" && Ctor instanceof Ctor && funcToString$2.call(Ctor) === objectCtorString;
  }
  function isObjectLike$1(value) {
    return value != null && typeof value == "object";
  }
  function baseGetTag$1(value) {
    if (value == null) {
      return value === void 0 ? undefinedTag$1 : nullTag$1;
    }
    return symToStringTag$2 && symToStringTag$2 in Object(value) ? getRawTag$1(value) : objectToString$1(value);
  }
  function getRawTag$1(value) {
    var isOwn = hasOwnProperty$9.call(value, symToStringTag$2), tag = value[symToStringTag$2];
    var unmasked = false;
    try {
      value[symToStringTag$2] = void 0;
      unmasked = true;
    } catch (e2) {
    }
    var result = nativeObjectToString$2.call(value);
    if (unmasked) {
      if (isOwn) {
        value[symToStringTag$2] = tag;
      } else {
        delete value[symToStringTag$2];
      }
    }
    return result;
  }
  function objectToString$1(value) {
    return nativeObjectToString$2.call(value);
  }
  var MAX_LEVEL = 20;
  function merge() {
    var args2 = [];
    for (var _i = 0; _i < arguments.length; _i++) {
      args2[_i] = arguments[_i];
    }
    var result = args2.shift();
    var objects = /* @__PURE__ */ new WeakMap();
    while (args2.length > 0) {
      result = mergeTwoObjects(result, args2.shift(), 0, objects);
    }
    return result;
  }
  function takeValue(value) {
    if (isArray$1(value)) {
      return value.slice();
    }
    return value;
  }
  function mergeTwoObjects(one, two, level, objects) {
    if (level === void 0) {
      level = 0;
    }
    var result;
    if (level > MAX_LEVEL) {
      return void 0;
    }
    level++;
    if (isPrimitive(one) || isPrimitive(two) || isFunction$2(two)) {
      result = takeValue(two);
    } else if (isArray$1(one)) {
      result = one.slice();
      if (isArray$1(two)) {
        for (var i2 = 0, j2 = two.length; i2 < j2; i2++) {
          result.push(takeValue(two[i2]));
        }
      } else if (isObject$1(two)) {
        var keys2 = Object.keys(two);
        for (var i2 = 0, j2 = keys2.length; i2 < j2; i2++) {
          var key = keys2[i2];
          result[key] = takeValue(two[key]);
        }
      }
    } else if (isObject$1(one)) {
      if (isObject$1(two)) {
        if (!shouldMerge(one, two)) {
          return two;
        }
        result = Object.assign({}, one);
        var keys2 = Object.keys(two);
        for (var i2 = 0, j2 = keys2.length; i2 < j2; i2++) {
          var key = keys2[i2];
          var twoValue = two[key];
          if (isPrimitive(twoValue)) {
            if (typeof twoValue === "undefined") {
              delete result[key];
            } else {
              result[key] = twoValue;
            }
          } else {
            var obj1 = result[key];
            var obj2 = twoValue;
            if (wasObjectReferenced(one, key, objects) || wasObjectReferenced(two, key, objects)) {
              delete result[key];
            } else {
              if (isObject$1(obj1) && isObject$1(obj2)) {
                var arr1 = objects.get(obj1) || [];
                var arr2 = objects.get(obj2) || [];
                arr1.push({ obj: one, key });
                arr2.push({ obj: two, key });
                objects.set(obj1, arr1);
                objects.set(obj2, arr2);
              }
              result[key] = mergeTwoObjects(result[key], twoValue, level, objects);
            }
          }
        }
      } else {
        result = two;
      }
    }
    return result;
  }
  function wasObjectReferenced(obj, key, objects) {
    var arr = objects.get(obj[key]) || [];
    for (var i2 = 0, j2 = arr.length; i2 < j2; i2++) {
      var info2 = arr[i2];
      if (info2.key === key && info2.obj === obj) {
        return true;
      }
    }
    return false;
  }
  function isArray$1(value) {
    return Array.isArray(value);
  }
  function isFunction$2(value) {
    return typeof value === "function";
  }
  function isObject$1(value) {
    return !isPrimitive(value) && !isArray$1(value) && !isFunction$2(value) && typeof value === "object";
  }
  function isPrimitive(value) {
    return typeof value === "string" || typeof value === "number" || typeof value === "boolean" || typeof value === "undefined" || value instanceof Date || value instanceof RegExp || value === null;
  }
  function shouldMerge(one, two) {
    if (!isPlainObject(one) || !isPlainObject(two)) {
      return false;
    }
    return true;
  }
  var __extends$2 = /* @__PURE__ */ function() {
    var extendStatics = function(d2, b2) {
      extendStatics = Object.setPrototypeOf || { __proto__: [] } instanceof Array && function(d3, b3) {
        d3.__proto__ = b3;
      } || function(d3, b3) {
        for (var p2 in b3) if (Object.prototype.hasOwnProperty.call(b3, p2)) d3[p2] = b3[p2];
      };
      return extendStatics(d2, b2);
    };
    return function(d2, b2) {
      if (typeof b2 !== "function" && b2 !== null)
        throw new TypeError("Class extends value " + String(b2) + " is not a constructor or null");
      extendStatics(d2, b2);
      function __() {
        this.constructor = d2;
      }
      d2.prototype = b2 === null ? Object.create(b2) : (__.prototype = b2.prototype, new __());
    };
  }();
  var TimeoutError = (
    /** @class */
    function(_super) {
      __extends$2(TimeoutError2, _super);
      function TimeoutError2(message2) {
        var _this = _super.call(this, message2) || this;
        Object.setPrototypeOf(_this, TimeoutError2.prototype);
        return _this;
      }
      return TimeoutError2;
    }(Error)
  );
  function callWithTimeout(promise2, timeout) {
    var timeoutHandle;
    var timeoutPromise = new Promise(function timeoutFunction(_resolve, reject) {
      timeoutHandle = setTimeout(function timeoutHandler() {
        reject(new TimeoutError("Operation timed out."));
      }, timeout);
    });
    return Promise.race([promise2, timeoutPromise]).then(function(result) {
      clearTimeout(timeoutHandle);
      return result;
    }, function(reason) {
      clearTimeout(timeoutHandle);
      throw reason;
    });
  }
  var __values$5 = function(o2) {
    var s2 = typeof Symbol === "function" && Symbol.iterator, m2 = s2 && o2[s2], i2 = 0;
    if (m2) return m2.call(o2);
    if (o2 && typeof o2.length === "number") return {
      next: function() {
        if (o2 && i2 >= o2.length) o2 = void 0;
        return { value: o2 && o2[i2++], done: !o2 };
      }
    };
    throw new TypeError(s2 ? "Object is not iterable." : "Symbol.iterator is not defined.");
  };
  function urlMatches(url2, urlToMatch) {
    if (typeof urlToMatch === "string") {
      return url2 === urlToMatch;
    } else {
      return !!url2.match(urlToMatch);
    }
  }
  function isUrlIgnored(url2, ignoredUrls) {
    var e_1, _a3;
    if (!ignoredUrls) {
      return false;
    }
    try {
      for (var ignoredUrls_1 = __values$5(ignoredUrls), ignoredUrls_1_1 = ignoredUrls_1.next(); !ignoredUrls_1_1.done; ignoredUrls_1_1 = ignoredUrls_1.next()) {
        var ignoreUrl = ignoredUrls_1_1.value;
        if (urlMatches(url2, ignoreUrl)) {
          return true;
        }
      }
    } catch (e_1_1) {
      e_1 = { error: e_1_1 };
    } finally {
      try {
        if (ignoredUrls_1_1 && !ignoredUrls_1_1.done && (_a3 = ignoredUrls_1.return)) _a3.call(ignoredUrls_1);
      } finally {
        if (e_1) throw e_1.error;
      }
    }
    return false;
  }
  function isWrapped$1(func) {
    return typeof func === "function" && typeof func.__original === "function" && typeof func.__unwrap === "function" && func.__wrapped === true;
  }
  var Deferred = (
    /** @class */
    function() {
      function Deferred2() {
        var _this = this;
        this._promise = new Promise(function(resolve2, reject) {
          _this._resolve = resolve2;
          _this._reject = reject;
        });
      }
      Object.defineProperty(Deferred2.prototype, "promise", {
        get: function() {
          return this._promise;
        },
        enumerable: false,
        configurable: true
      });
      Deferred2.prototype.resolve = function(val) {
        this._resolve(val);
      };
      Deferred2.prototype.reject = function(err) {
        this._reject(err);
      };
      return Deferred2;
    }()
  );
  var __read$4 = function(o2, n2) {
    var m2 = typeof Symbol === "function" && o2[Symbol.iterator];
    if (!m2) return o2;
    var i2 = m2.call(o2), r2, ar = [], e2;
    try {
      while ((n2 === void 0 || n2-- > 0) && !(r2 = i2.next()).done) ar.push(r2.value);
    } catch (error2) {
      e2 = { error: error2 };
    } finally {
      try {
        if (r2 && !r2.done && (m2 = i2["return"])) m2.call(i2);
      } finally {
        if (e2) throw e2.error;
      }
    }
    return ar;
  };
  var __spreadArray$3 = function(to, from, pack) {
    if (pack || arguments.length === 2) for (var i2 = 0, l2 = from.length, ar; i2 < l2; i2++) {
      if (ar || !(i2 in from)) {
        if (!ar) ar = Array.prototype.slice.call(from, 0, i2);
        ar[i2] = from[i2];
      }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
  };
  var BindOnceFuture = (
    /** @class */
    function() {
      function BindOnceFuture2(_callback, _that) {
        this._callback = _callback;
        this._that = _that;
        this._isCalled = false;
        this._deferred = new Deferred();
      }
      Object.defineProperty(BindOnceFuture2.prototype, "isCalled", {
        get: function() {
          return this._isCalled;
        },
        enumerable: false,
        configurable: true
      });
      Object.defineProperty(BindOnceFuture2.prototype, "promise", {
        get: function() {
          return this._deferred.promise;
        },
        enumerable: false,
        configurable: true
      });
      BindOnceFuture2.prototype.call = function() {
        var _a3;
        var _this = this;
        var args2 = [];
        for (var _i = 0; _i < arguments.length; _i++) {
          args2[_i] = arguments[_i];
        }
        if (!this._isCalled) {
          this._isCalled = true;
          try {
            Promise.resolve((_a3 = this._callback).call.apply(_a3, __spreadArray$3([this._that], __read$4(args2), false))).then(function(val) {
              return _this._deferred.resolve(val);
            }, function(err) {
              return _this._deferred.reject(err);
            });
          } catch (err) {
            this._deferred.reject(err);
          }
        }
        return this._deferred.promise;
      };
      return BindOnceFuture2;
    }()
  );
  function _export(exporter, arg) {
    return new Promise(function(resolve2) {
      context.with(suppressTracing$1(context.active()), function() {
        exporter.export(arg, function(result) {
          resolve2(result);
        });
      });
    });
  }
  var baggageUtils = {
    getKeyPairs,
    serializeKeyPairs,
    parseKeyPairsIntoRecord,
    parsePairKeyValue
  };
  var internal = {
    _export
  };
  const esm$1 = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
    __proto__: null,
    AlwaysOffSampler: AlwaysOffSampler$1,
    AlwaysOnSampler: AlwaysOnSampler$1,
    AnchoredClock,
    BindOnceFuture,
    CompositePropagator,
    DEFAULT_ATTRIBUTE_COUNT_LIMIT,
    DEFAULT_ATTRIBUTE_VALUE_LENGTH_LIMIT,
    DEFAULT_ENVIRONMENT,
    DEFAULT_SPAN_ATTRIBUTE_PER_EVENT_COUNT_LIMIT,
    DEFAULT_SPAN_ATTRIBUTE_PER_LINK_COUNT_LIMIT,
    get ExportResultCode() {
      return ExportResultCode;
    },
    ParentBasedSampler: ParentBasedSampler$1,
    get RPCType() {
      return RPCType;
    },
    RandomIdGenerator: RandomIdGenerator$1,
    SDK_INFO,
    TRACE_PARENT_HEADER,
    TRACE_STATE_HEADER,
    TimeoutError,
    TraceIdRatioBasedSampler: TraceIdRatioBasedSampler$1,
    TraceState,
    get TracesSamplerValues() {
      return TracesSamplerValues;
    },
    VERSION: VERSION$1,
    W3CBaggagePropagator,
    W3CTraceContextPropagator,
    _globalThis: _globalThis$2,
    addHrTimes,
    baggageUtils,
    callWithTimeout,
    deleteRPCMetadata,
    getEnv: getEnv$1,
    getEnvWithoutDefaults,
    getRPCMetadata,
    getTimeOrigin,
    globalErrorHandler,
    hexToBase64,
    hexToBinary,
    hrTime,
    hrTimeDuration,
    hrTimeToMicroseconds,
    hrTimeToMilliseconds,
    hrTimeToNanoseconds,
    hrTimeToTimeStamp,
    internal,
    isAttributeKey,
    isAttributeValue,
    isTimeInput,
    isTimeInputHrTime,
    isTracingSuppressed,
    isUrlIgnored,
    isWrapped: isWrapped$1,
    loggingErrorHandler,
    merge,
    millisToHrTime,
    otperformance,
    parseEnvironment,
    parseTraceParent,
    sanitizeAttributes,
    setGlobalErrorHandler,
    setRPCMetadata,
    suppressTracing: suppressTracing$1,
    timeInputToHrTime,
    unrefTimer,
    unsuppressTracing,
    urlMatches
  }, Symbol.toStringTag, { value: "Module" }));
  var ExceptionEventName = "exception";
  var __assign$2 = function() {
    __assign$2 = Object.assign || function(t2) {
      for (var s2, i2 = 1, n2 = arguments.length; i2 < n2; i2++) {
        s2 = arguments[i2];
        for (var p2 in s2) if (Object.prototype.hasOwnProperty.call(s2, p2))
          t2[p2] = s2[p2];
      }
      return t2;
    };
    return __assign$2.apply(this, arguments);
  };
  var __values$4 = function(o2) {
    var s2 = typeof Symbol === "function" && Symbol.iterator, m2 = s2 && o2[s2], i2 = 0;
    if (m2) return m2.call(o2);
    if (o2 && typeof o2.length === "number") return {
      next: function() {
        if (o2 && i2 >= o2.length) o2 = void 0;
        return { value: o2 && o2[i2++], done: !o2 };
      }
    };
    throw new TypeError(s2 ? "Object is not iterable." : "Symbol.iterator is not defined.");
  };
  var __read$3 = function(o2, n2) {
    var m2 = typeof Symbol === "function" && o2[Symbol.iterator];
    if (!m2) return o2;
    var i2 = m2.call(o2), r2, ar = [], e2;
    try {
      while ((n2 === void 0 || n2-- > 0) && !(r2 = i2.next()).done) ar.push(r2.value);
    } catch (error2) {
      e2 = { error: error2 };
    } finally {
      try {
        if (r2 && !r2.done && (m2 = i2["return"])) m2.call(i2);
      } finally {
        if (e2) throw e2.error;
      }
    }
    return ar;
  };
  var __spreadArray$2 = function(to, from, pack) {
    if (pack || arguments.length === 2) for (var i2 = 0, l2 = from.length, ar; i2 < l2; i2++) {
      if (ar || !(i2 in from)) {
        if (!ar) ar = Array.prototype.slice.call(from, 0, i2);
        ar[i2] = from[i2];
      }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
  };
  var Span = (
    /** @class */
    function() {
      function Span2(parentTracer, context2, spanName, spanContext, kind, parentSpanId, links, startTime, _deprecatedClock, attributes) {
        if (links === void 0) {
          links = [];
        }
        this.attributes = {};
        this.links = [];
        this.events = [];
        this._droppedAttributesCount = 0;
        this._droppedEventsCount = 0;
        this._droppedLinksCount = 0;
        this.status = {
          code: SpanStatusCode.UNSET
        };
        this.endTime = [0, 0];
        this._ended = false;
        this._duration = [-1, -1];
        this.name = spanName;
        this._spanContext = spanContext;
        this.parentSpanId = parentSpanId;
        this.kind = kind;
        this.links = links;
        var now = Date.now();
        this._performanceStartTime = otperformance.now();
        this._performanceOffset = now - (this._performanceStartTime + getTimeOrigin());
        this._startTimeProvided = startTime != null;
        this.startTime = this._getTime(startTime !== null && startTime !== void 0 ? startTime : now);
        this.resource = parentTracer.resource;
        this.instrumentationLibrary = parentTracer.instrumentationLibrary;
        this._spanLimits = parentTracer.getSpanLimits();
        this._attributeValueLengthLimit = this._spanLimits.attributeValueLengthLimit || 0;
        if (attributes != null) {
          this.setAttributes(attributes);
        }
        this._spanProcessor = parentTracer.getActiveSpanProcessor();
        this._spanProcessor.onStart(this, context2);
      }
      Span2.prototype.spanContext = function() {
        return this._spanContext;
      };
      Span2.prototype.setAttribute = function(key, value) {
        if (value == null || this._isSpanEnded())
          return this;
        if (key.length === 0) {
          diag.warn("Invalid attribute key: " + key);
          return this;
        }
        if (!isAttributeValue(value)) {
          diag.warn("Invalid attribute value set for key: " + key);
          return this;
        }
        if (Object.keys(this.attributes).length >= this._spanLimits.attributeCountLimit && !Object.prototype.hasOwnProperty.call(this.attributes, key)) {
          this._droppedAttributesCount++;
          return this;
        }
        this.attributes[key] = this._truncateToSize(value);
        return this;
      };
      Span2.prototype.setAttributes = function(attributes) {
        var e_1, _a3;
        try {
          for (var _b2 = __values$4(Object.entries(attributes)), _c2 = _b2.next(); !_c2.done; _c2 = _b2.next()) {
            var _d = __read$3(_c2.value, 2), k2 = _d[0], v2 = _d[1];
            this.setAttribute(k2, v2);
          }
        } catch (e_1_1) {
          e_1 = { error: e_1_1 };
        } finally {
          try {
            if (_c2 && !_c2.done && (_a3 = _b2.return)) _a3.call(_b2);
          } finally {
            if (e_1) throw e_1.error;
          }
        }
        return this;
      };
      Span2.prototype.addEvent = function(name2, attributesOrStartTime, timeStamp) {
        if (this._isSpanEnded())
          return this;
        if (this._spanLimits.eventCountLimit === 0) {
          diag.warn("No events allowed.");
          this._droppedEventsCount++;
          return this;
        }
        if (this.events.length >= this._spanLimits.eventCountLimit) {
          if (this._droppedEventsCount === 0) {
            diag.debug("Dropping extra events.");
          }
          this.events.shift();
          this._droppedEventsCount++;
        }
        if (isTimeInput(attributesOrStartTime)) {
          if (!isTimeInput(timeStamp)) {
            timeStamp = attributesOrStartTime;
          }
          attributesOrStartTime = void 0;
        }
        var attributes = sanitizeAttributes(attributesOrStartTime);
        this.events.push({
          name: name2,
          attributes,
          time: this._getTime(timeStamp),
          droppedAttributesCount: 0
        });
        return this;
      };
      Span2.prototype.addLink = function(link) {
        this.links.push(link);
        return this;
      };
      Span2.prototype.addLinks = function(links) {
        var _a3;
        (_a3 = this.links).push.apply(_a3, __spreadArray$2([], __read$3(links), false));
        return this;
      };
      Span2.prototype.setStatus = function(status) {
        if (this._isSpanEnded())
          return this;
        this.status = __assign$2({}, status);
        if (this.status.message != null && typeof status.message !== "string") {
          diag.warn("Dropping invalid status.message of type '" + typeof status.message + "', expected 'string'");
          delete this.status.message;
        }
        return this;
      };
      Span2.prototype.updateName = function(name2) {
        if (this._isSpanEnded())
          return this;
        this.name = name2;
        return this;
      };
      Span2.prototype.end = function(endTime) {
        if (this._isSpanEnded()) {
          diag.error(this.name + " " + this._spanContext.traceId + "-" + this._spanContext.spanId + " - You can only call end() on a span once.");
          return;
        }
        this._ended = true;
        this.endTime = this._getTime(endTime);
        this._duration = hrTimeDuration(this.startTime, this.endTime);
        if (this._duration[0] < 0) {
          diag.warn("Inconsistent start and end time, startTime > endTime. Setting span duration to 0ms.", this.startTime, this.endTime);
          this.endTime = this.startTime.slice();
          this._duration = [0, 0];
        }
        if (this._droppedEventsCount > 0) {
          diag.warn("Dropped " + this._droppedEventsCount + " events because eventCountLimit reached");
        }
        this._spanProcessor.onEnd(this);
      };
      Span2.prototype._getTime = function(inp) {
        if (typeof inp === "number" && inp <= otperformance.now()) {
          return hrTime(inp + this._performanceOffset);
        }
        if (typeof inp === "number") {
          return millisToHrTime(inp);
        }
        if (inp instanceof Date) {
          return millisToHrTime(inp.getTime());
        }
        if (isTimeInputHrTime(inp)) {
          return inp;
        }
        if (this._startTimeProvided) {
          return millisToHrTime(Date.now());
        }
        var msDuration = otperformance.now() - this._performanceStartTime;
        return addHrTimes(this.startTime, millisToHrTime(msDuration));
      };
      Span2.prototype.isRecording = function() {
        return this._ended === false;
      };
      Span2.prototype.recordException = function(exception, time) {
        var attributes = {};
        if (typeof exception === "string") {
          attributes[SEMATTRS_EXCEPTION_MESSAGE] = exception;
        } else if (exception) {
          if (exception.code) {
            attributes[SEMATTRS_EXCEPTION_TYPE] = exception.code.toString();
          } else if (exception.name) {
            attributes[SEMATTRS_EXCEPTION_TYPE] = exception.name;
          }
          if (exception.message) {
            attributes[SEMATTRS_EXCEPTION_MESSAGE] = exception.message;
          }
          if (exception.stack) {
            attributes[SEMATTRS_EXCEPTION_STACKTRACE] = exception.stack;
          }
        }
        if (attributes[SEMATTRS_EXCEPTION_TYPE] || attributes[SEMATTRS_EXCEPTION_MESSAGE]) {
          this.addEvent(ExceptionEventName, attributes, time);
        } else {
          diag.warn("Failed to record an exception " + exception);
        }
      };
      Object.defineProperty(Span2.prototype, "duration", {
        get: function() {
          return this._duration;
        },
        enumerable: false,
        configurable: true
      });
      Object.defineProperty(Span2.prototype, "ended", {
        get: function() {
          return this._ended;
        },
        enumerable: false,
        configurable: true
      });
      Object.defineProperty(Span2.prototype, "droppedAttributesCount", {
        get: function() {
          return this._droppedAttributesCount;
        },
        enumerable: false,
        configurable: true
      });
      Object.defineProperty(Span2.prototype, "droppedEventsCount", {
        get: function() {
          return this._droppedEventsCount;
        },
        enumerable: false,
        configurable: true
      });
      Object.defineProperty(Span2.prototype, "droppedLinksCount", {
        get: function() {
          return this._droppedLinksCount;
        },
        enumerable: false,
        configurable: true
      });
      Span2.prototype._isSpanEnded = function() {
        if (this._ended) {
          diag.warn("Can not execute the operation on ended Span {traceId: " + this._spanContext.traceId + ", spanId: " + this._spanContext.spanId + "}");
        }
        return this._ended;
      };
      Span2.prototype._truncateToLimitUtil = function(value, limit) {
        if (value.length <= limit) {
          return value;
        }
        return value.substring(0, limit);
      };
      Span2.prototype._truncateToSize = function(value) {
        var _this = this;
        var limit = this._attributeValueLengthLimit;
        if (limit <= 0) {
          diag.warn("Attribute value limit must be positive, got " + limit);
          return value;
        }
        if (typeof value === "string") {
          return this._truncateToLimitUtil(value, limit);
        }
        if (Array.isArray(value)) {
          return value.map(function(val) {
            return typeof val === "string" ? _this._truncateToLimitUtil(val, limit) : val;
          });
        }
        return value;
      };
      return Span2;
    }()
  );
  var SamplingDecision;
  (function(SamplingDecision2) {
    SamplingDecision2[SamplingDecision2["NOT_RECORD"] = 0] = "NOT_RECORD";
    SamplingDecision2[SamplingDecision2["RECORD"] = 1] = "RECORD";
    SamplingDecision2[SamplingDecision2["RECORD_AND_SAMPLED"] = 2] = "RECORD_AND_SAMPLED";
  })(SamplingDecision || (SamplingDecision = {}));
  var AlwaysOffSampler = (
    /** @class */
    function() {
      function AlwaysOffSampler2() {
      }
      AlwaysOffSampler2.prototype.shouldSample = function() {
        return {
          decision: SamplingDecision.NOT_RECORD
        };
      };
      AlwaysOffSampler2.prototype.toString = function() {
        return "AlwaysOffSampler";
      };
      return AlwaysOffSampler2;
    }()
  );
  var AlwaysOnSampler = (
    /** @class */
    function() {
      function AlwaysOnSampler2() {
      }
      AlwaysOnSampler2.prototype.shouldSample = function() {
        return {
          decision: SamplingDecision.RECORD_AND_SAMPLED
        };
      };
      AlwaysOnSampler2.prototype.toString = function() {
        return "AlwaysOnSampler";
      };
      return AlwaysOnSampler2;
    }()
  );
  var ParentBasedSampler = (
    /** @class */
    function() {
      function ParentBasedSampler2(config2) {
        var _a3, _b2, _c2, _d;
        this._root = config2.root;
        if (!this._root) {
          globalErrorHandler(new Error("ParentBasedSampler must have a root sampler configured"));
          this._root = new AlwaysOnSampler();
        }
        this._remoteParentSampled = (_a3 = config2.remoteParentSampled) !== null && _a3 !== void 0 ? _a3 : new AlwaysOnSampler();
        this._remoteParentNotSampled = (_b2 = config2.remoteParentNotSampled) !== null && _b2 !== void 0 ? _b2 : new AlwaysOffSampler();
        this._localParentSampled = (_c2 = config2.localParentSampled) !== null && _c2 !== void 0 ? _c2 : new AlwaysOnSampler();
        this._localParentNotSampled = (_d = config2.localParentNotSampled) !== null && _d !== void 0 ? _d : new AlwaysOffSampler();
      }
      ParentBasedSampler2.prototype.shouldSample = function(context2, traceId, spanName, spanKind, attributes, links) {
        var parentContext = trace.getSpanContext(context2);
        if (!parentContext || !isSpanContextValid(parentContext)) {
          return this._root.shouldSample(context2, traceId, spanName, spanKind, attributes, links);
        }
        if (parentContext.isRemote) {
          if (parentContext.traceFlags & TraceFlags.SAMPLED) {
            return this._remoteParentSampled.shouldSample(context2, traceId, spanName, spanKind, attributes, links);
          }
          return this._remoteParentNotSampled.shouldSample(context2, traceId, spanName, spanKind, attributes, links);
        }
        if (parentContext.traceFlags & TraceFlags.SAMPLED) {
          return this._localParentSampled.shouldSample(context2, traceId, spanName, spanKind, attributes, links);
        }
        return this._localParentNotSampled.shouldSample(context2, traceId, spanName, spanKind, attributes, links);
      };
      ParentBasedSampler2.prototype.toString = function() {
        return "ParentBased{root=" + this._root.toString() + ", remoteParentSampled=" + this._remoteParentSampled.toString() + ", remoteParentNotSampled=" + this._remoteParentNotSampled.toString() + ", localParentSampled=" + this._localParentSampled.toString() + ", localParentNotSampled=" + this._localParentNotSampled.toString() + "}";
      };
      return ParentBasedSampler2;
    }()
  );
  var TraceIdRatioBasedSampler = (
    /** @class */
    function() {
      function TraceIdRatioBasedSampler2(_ratio) {
        if (_ratio === void 0) {
          _ratio = 0;
        }
        this._ratio = _ratio;
        this._ratio = this._normalize(_ratio);
        this._upperBound = Math.floor(this._ratio * 4294967295);
      }
      TraceIdRatioBasedSampler2.prototype.shouldSample = function(context2, traceId) {
        return {
          decision: isValidTraceId(traceId) && this._accumulate(traceId) < this._upperBound ? SamplingDecision.RECORD_AND_SAMPLED : SamplingDecision.NOT_RECORD
        };
      };
      TraceIdRatioBasedSampler2.prototype.toString = function() {
        return "TraceIdRatioBased{" + this._ratio + "}";
      };
      TraceIdRatioBasedSampler2.prototype._normalize = function(ratio) {
        if (typeof ratio !== "number" || isNaN(ratio))
          return 0;
        return ratio >= 1 ? 1 : ratio <= 0 ? 0 : ratio;
      };
      TraceIdRatioBasedSampler2.prototype._accumulate = function(traceId) {
        var accumulation = 0;
        for (var i2 = 0; i2 < traceId.length / 8; i2++) {
          var pos = i2 * 8;
          var part = parseInt(traceId.slice(pos, pos + 8), 16);
          accumulation = (accumulation ^ part) >>> 0;
        }
        return accumulation;
      };
      return TraceIdRatioBasedSampler2;
    }()
  );
  var FALLBACK_OTEL_TRACES_SAMPLER = TracesSamplerValues.AlwaysOn;
  var DEFAULT_RATIO = 1;
  function loadDefaultConfig() {
    var env2 = getEnv$1();
    return {
      sampler: buildSamplerFromEnv(env2),
      forceFlushTimeoutMillis: 3e4,
      generalLimits: {
        attributeValueLengthLimit: env2.OTEL_ATTRIBUTE_VALUE_LENGTH_LIMIT,
        attributeCountLimit: env2.OTEL_ATTRIBUTE_COUNT_LIMIT
      },
      spanLimits: {
        attributeValueLengthLimit: env2.OTEL_SPAN_ATTRIBUTE_VALUE_LENGTH_LIMIT,
        attributeCountLimit: env2.OTEL_SPAN_ATTRIBUTE_COUNT_LIMIT,
        linkCountLimit: env2.OTEL_SPAN_LINK_COUNT_LIMIT,
        eventCountLimit: env2.OTEL_SPAN_EVENT_COUNT_LIMIT,
        attributePerEventCountLimit: env2.OTEL_SPAN_ATTRIBUTE_PER_EVENT_COUNT_LIMIT,
        attributePerLinkCountLimit: env2.OTEL_SPAN_ATTRIBUTE_PER_LINK_COUNT_LIMIT
      },
      mergeResourceWithDefaults: true
    };
  }
  function buildSamplerFromEnv(environment) {
    if (environment === void 0) {
      environment = getEnv$1();
    }
    switch (environment.OTEL_TRACES_SAMPLER) {
      case TracesSamplerValues.AlwaysOn:
        return new AlwaysOnSampler();
      case TracesSamplerValues.AlwaysOff:
        return new AlwaysOffSampler();
      case TracesSamplerValues.ParentBasedAlwaysOn:
        return new ParentBasedSampler({
          root: new AlwaysOnSampler()
        });
      case TracesSamplerValues.ParentBasedAlwaysOff:
        return new ParentBasedSampler({
          root: new AlwaysOffSampler()
        });
      case TracesSamplerValues.TraceIdRatio:
        return new TraceIdRatioBasedSampler(getSamplerProbabilityFromEnv(environment));
      case TracesSamplerValues.ParentBasedTraceIdRatio:
        return new ParentBasedSampler({
          root: new TraceIdRatioBasedSampler(getSamplerProbabilityFromEnv(environment))
        });
      default:
        diag.error('OTEL_TRACES_SAMPLER value "' + environment.OTEL_TRACES_SAMPLER + " invalid, defaulting to " + FALLBACK_OTEL_TRACES_SAMPLER + '".');
        return new AlwaysOnSampler();
    }
  }
  function getSamplerProbabilityFromEnv(environment) {
    if (environment.OTEL_TRACES_SAMPLER_ARG === void 0 || environment.OTEL_TRACES_SAMPLER_ARG === "") {
      diag.error("OTEL_TRACES_SAMPLER_ARG is blank, defaulting to " + DEFAULT_RATIO + ".");
      return DEFAULT_RATIO;
    }
    var probability = Number(environment.OTEL_TRACES_SAMPLER_ARG);
    if (isNaN(probability)) {
      diag.error("OTEL_TRACES_SAMPLER_ARG=" + environment.OTEL_TRACES_SAMPLER_ARG + " was given, but it is invalid, defaulting to " + DEFAULT_RATIO + ".");
      return DEFAULT_RATIO;
    }
    if (probability < 0 || probability > 1) {
      diag.error("OTEL_TRACES_SAMPLER_ARG=" + environment.OTEL_TRACES_SAMPLER_ARG + " was given, but it is out of range ([0..1]), defaulting to " + DEFAULT_RATIO + ".");
      return DEFAULT_RATIO;
    }
    return probability;
  }
  function mergeConfig(userConfig) {
    var perInstanceDefaults = {
      sampler: buildSamplerFromEnv()
    };
    var DEFAULT_CONFIG = loadDefaultConfig();
    var target = Object.assign({}, DEFAULT_CONFIG, perInstanceDefaults, userConfig);
    target.generalLimits = Object.assign({}, DEFAULT_CONFIG.generalLimits, userConfig.generalLimits || {});
    target.spanLimits = Object.assign({}, DEFAULT_CONFIG.spanLimits, userConfig.spanLimits || {});
    return target;
  }
  function reconfigureLimits(userConfig) {
    var _a3, _b2, _c2, _d, _e2, _f, _g, _h, _j, _k, _l, _m;
    var spanLimits = Object.assign({}, userConfig.spanLimits);
    var parsedEnvConfig = getEnvWithoutDefaults();
    spanLimits.attributeCountLimit = (_f = (_e2 = (_d = (_b2 = (_a3 = userConfig.spanLimits) === null || _a3 === void 0 ? void 0 : _a3.attributeCountLimit) !== null && _b2 !== void 0 ? _b2 : (_c2 = userConfig.generalLimits) === null || _c2 === void 0 ? void 0 : _c2.attributeCountLimit) !== null && _d !== void 0 ? _d : parsedEnvConfig.OTEL_SPAN_ATTRIBUTE_COUNT_LIMIT) !== null && _e2 !== void 0 ? _e2 : parsedEnvConfig.OTEL_ATTRIBUTE_COUNT_LIMIT) !== null && _f !== void 0 ? _f : DEFAULT_ATTRIBUTE_COUNT_LIMIT;
    spanLimits.attributeValueLengthLimit = (_m = (_l = (_k = (_h = (_g = userConfig.spanLimits) === null || _g === void 0 ? void 0 : _g.attributeValueLengthLimit) !== null && _h !== void 0 ? _h : (_j = userConfig.generalLimits) === null || _j === void 0 ? void 0 : _j.attributeValueLengthLimit) !== null && _k !== void 0 ? _k : parsedEnvConfig.OTEL_SPAN_ATTRIBUTE_VALUE_LENGTH_LIMIT) !== null && _l !== void 0 ? _l : parsedEnvConfig.OTEL_ATTRIBUTE_VALUE_LENGTH_LIMIT) !== null && _m !== void 0 ? _m : DEFAULT_ATTRIBUTE_VALUE_LENGTH_LIMIT;
    return Object.assign({}, userConfig, { spanLimits });
  }
  var BatchSpanProcessorBase = (
    /** @class */
    function() {
      function BatchSpanProcessorBase2(_exporter, config2) {
        this._exporter = _exporter;
        this._isExporting = false;
        this._finishedSpans = [];
        this._droppedSpansCount = 0;
        var env2 = getEnv$1();
        this._maxExportBatchSize = typeof (config2 === null || config2 === void 0 ? void 0 : config2.maxExportBatchSize) === "number" ? config2.maxExportBatchSize : env2.OTEL_BSP_MAX_EXPORT_BATCH_SIZE;
        this._maxQueueSize = typeof (config2 === null || config2 === void 0 ? void 0 : config2.maxQueueSize) === "number" ? config2.maxQueueSize : env2.OTEL_BSP_MAX_QUEUE_SIZE;
        this._scheduledDelayMillis = typeof (config2 === null || config2 === void 0 ? void 0 : config2.scheduledDelayMillis) === "number" ? config2.scheduledDelayMillis : env2.OTEL_BSP_SCHEDULE_DELAY;
        this._exportTimeoutMillis = typeof (config2 === null || config2 === void 0 ? void 0 : config2.exportTimeoutMillis) === "number" ? config2.exportTimeoutMillis : env2.OTEL_BSP_EXPORT_TIMEOUT;
        this._shutdownOnce = new BindOnceFuture(this._shutdown, this);
        if (this._maxExportBatchSize > this._maxQueueSize) {
          diag.warn("BatchSpanProcessor: maxExportBatchSize must be smaller or equal to maxQueueSize, setting maxExportBatchSize to match maxQueueSize");
          this._maxExportBatchSize = this._maxQueueSize;
        }
      }
      BatchSpanProcessorBase2.prototype.forceFlush = function() {
        if (this._shutdownOnce.isCalled) {
          return this._shutdownOnce.promise;
        }
        return this._flushAll();
      };
      BatchSpanProcessorBase2.prototype.onStart = function(_span, _parentContext) {
      };
      BatchSpanProcessorBase2.prototype.onEnd = function(span) {
        if (this._shutdownOnce.isCalled) {
          return;
        }
        if ((span.spanContext().traceFlags & TraceFlags.SAMPLED) === 0) {
          return;
        }
        this._addToBuffer(span);
      };
      BatchSpanProcessorBase2.prototype.shutdown = function() {
        return this._shutdownOnce.call();
      };
      BatchSpanProcessorBase2.prototype._shutdown = function() {
        var _this = this;
        return Promise.resolve().then(function() {
          return _this.onShutdown();
        }).then(function() {
          return _this._flushAll();
        }).then(function() {
          return _this._exporter.shutdown();
        });
      };
      BatchSpanProcessorBase2.prototype._addToBuffer = function(span) {
        if (this._finishedSpans.length >= this._maxQueueSize) {
          if (this._droppedSpansCount === 0) {
            diag.debug("maxQueueSize reached, dropping spans");
          }
          this._droppedSpansCount++;
          return;
        }
        if (this._droppedSpansCount > 0) {
          diag.warn("Dropped " + this._droppedSpansCount + " spans because maxQueueSize reached");
          this._droppedSpansCount = 0;
        }
        this._finishedSpans.push(span);
        this._maybeStartTimer();
      };
      BatchSpanProcessorBase2.prototype._flushAll = function() {
        var _this = this;
        return new Promise(function(resolve2, reject) {
          var promises = [];
          var count = Math.ceil(_this._finishedSpans.length / _this._maxExportBatchSize);
          for (var i2 = 0, j2 = count; i2 < j2; i2++) {
            promises.push(_this._flushOneBatch());
          }
          Promise.all(promises).then(function() {
            resolve2();
          }).catch(reject);
        });
      };
      BatchSpanProcessorBase2.prototype._flushOneBatch = function() {
        var _this = this;
        this._clearTimer();
        if (this._finishedSpans.length === 0) {
          return Promise.resolve();
        }
        return new Promise(function(resolve2, reject) {
          var timer = setTimeout(function() {
            reject(new Error("Timeout"));
          }, _this._exportTimeoutMillis);
          context.with(suppressTracing$1(context.active()), function() {
            var spans;
            if (_this._finishedSpans.length <= _this._maxExportBatchSize) {
              spans = _this._finishedSpans;
              _this._finishedSpans = [];
            } else {
              spans = _this._finishedSpans.splice(0, _this._maxExportBatchSize);
            }
            var doExport = function() {
              return _this._exporter.export(spans, function(result) {
                var _a3;
                clearTimeout(timer);
                if (result.code === ExportResultCode.SUCCESS) {
                  resolve2();
                } else {
                  reject((_a3 = result.error) !== null && _a3 !== void 0 ? _a3 : new Error("BatchSpanProcessor: span export failed"));
                }
              });
            };
            var pendingResources = null;
            for (var i2 = 0, len = spans.length; i2 < len; i2++) {
              var span = spans[i2];
              if (span.resource.asyncAttributesPending && span.resource.waitForAsyncAttributes) {
                pendingResources !== null && pendingResources !== void 0 ? pendingResources : pendingResources = [];
                pendingResources.push(span.resource.waitForAsyncAttributes());
              }
            }
            if (pendingResources === null) {
              doExport();
            } else {
              Promise.all(pendingResources).then(doExport, function(err) {
                globalErrorHandler(err);
                reject(err);
              });
            }
          });
        });
      };
      BatchSpanProcessorBase2.prototype._maybeStartTimer = function() {
        var _this = this;
        if (this._isExporting)
          return;
        var flush2 = function() {
          _this._isExporting = true;
          _this._flushOneBatch().finally(function() {
            _this._isExporting = false;
            if (_this._finishedSpans.length > 0) {
              _this._clearTimer();
              _this._maybeStartTimer();
            }
          }).catch(function(e2) {
            _this._isExporting = false;
            globalErrorHandler(e2);
          });
        };
        if (this._finishedSpans.length >= this._maxExportBatchSize) {
          return flush2();
        }
        if (this._timer !== void 0)
          return;
        this._timer = setTimeout(function() {
          return flush2();
        }, this._scheduledDelayMillis);
        unrefTimer(this._timer);
      };
      BatchSpanProcessorBase2.prototype._clearTimer = function() {
        if (this._timer !== void 0) {
          clearTimeout(this._timer);
          this._timer = void 0;
        }
      };
      return BatchSpanProcessorBase2;
    }()
  );
  var __extends$1 = /* @__PURE__ */ function() {
    var extendStatics = function(d2, b2) {
      extendStatics = Object.setPrototypeOf || { __proto__: [] } instanceof Array && function(d3, b3) {
        d3.__proto__ = b3;
      } || function(d3, b3) {
        for (var p2 in b3) if (Object.prototype.hasOwnProperty.call(b3, p2)) d3[p2] = b3[p2];
      };
      return extendStatics(d2, b2);
    };
    return function(d2, b2) {
      if (typeof b2 !== "function" && b2 !== null)
        throw new TypeError("Class extends value " + String(b2) + " is not a constructor or null");
      extendStatics(d2, b2);
      function __() {
        this.constructor = d2;
      }
      d2.prototype = b2 === null ? Object.create(b2) : (__.prototype = b2.prototype, new __());
    };
  }();
  var BatchSpanProcessor = (
    /** @class */
    function(_super) {
      __extends$1(BatchSpanProcessor2, _super);
      function BatchSpanProcessor2() {
        return _super !== null && _super.apply(this, arguments) || this;
      }
      BatchSpanProcessor2.prototype.onShutdown = function() {
      };
      return BatchSpanProcessor2;
    }(BatchSpanProcessorBase)
  );
  var SPAN_ID_BYTES = 8;
  var TRACE_ID_BYTES = 16;
  var RandomIdGenerator = (
    /** @class */
    /* @__PURE__ */ function() {
      function RandomIdGenerator2() {
        this.generateTraceId = getIdGenerator(TRACE_ID_BYTES);
        this.generateSpanId = getIdGenerator(SPAN_ID_BYTES);
      }
      return RandomIdGenerator2;
    }()
  );
  var SHARED_BUFFER = Buffer.allocUnsafe(TRACE_ID_BYTES);
  function getIdGenerator(bytes) {
    return function generateId() {
      for (var i2 = 0; i2 < bytes / 4; i2++) {
        SHARED_BUFFER.writeUInt32BE(Math.random() * Math.pow(2, 32) >>> 0, i2 * 4);
      }
      for (var i2 = 0; i2 < bytes; i2++) {
        if (SHARED_BUFFER[i2] > 0) {
          break;
        } else if (i2 === bytes - 1) {
          SHARED_BUFFER[bytes - 1] = 1;
        }
      }
      return SHARED_BUFFER.toString("hex", 0, bytes);
    };
  }
  var Tracer = (
    /** @class */
    function() {
      function Tracer2(instrumentationLibrary, config2, _tracerProvider) {
        this._tracerProvider = _tracerProvider;
        var localConfig = mergeConfig(config2);
        this._sampler = localConfig.sampler;
        this._generalLimits = localConfig.generalLimits;
        this._spanLimits = localConfig.spanLimits;
        this._idGenerator = config2.idGenerator || new RandomIdGenerator();
        this.resource = _tracerProvider.resource;
        this.instrumentationLibrary = instrumentationLibrary;
      }
      Tracer2.prototype.startSpan = function(name2, options, context$1) {
        var _a3, _b2, _c2;
        if (options === void 0) {
          options = {};
        }
        if (context$1 === void 0) {
          context$1 = context.active();
        }
        if (options.root) {
          context$1 = trace.deleteSpan(context$1);
        }
        var parentSpan = trace.getSpan(context$1);
        if (isTracingSuppressed(context$1)) {
          diag.debug("Instrumentation suppressed, returning Noop Span");
          var nonRecordingSpan = trace.wrapSpanContext(INVALID_SPAN_CONTEXT);
          return nonRecordingSpan;
        }
        var parentSpanContext = parentSpan === null || parentSpan === void 0 ? void 0 : parentSpan.spanContext();
        var spanId = this._idGenerator.generateSpanId();
        var traceId;
        var traceState;
        var parentSpanId;
        if (!parentSpanContext || !trace.isSpanContextValid(parentSpanContext)) {
          traceId = this._idGenerator.generateTraceId();
        } else {
          traceId = parentSpanContext.traceId;
          traceState = parentSpanContext.traceState;
          parentSpanId = parentSpanContext.spanId;
        }
        var spanKind = (_a3 = options.kind) !== null && _a3 !== void 0 ? _a3 : SpanKind.INTERNAL;
        var links = ((_b2 = options.links) !== null && _b2 !== void 0 ? _b2 : []).map(function(link) {
          return {
            context: link.context,
            attributes: sanitizeAttributes(link.attributes)
          };
        });
        var attributes = sanitizeAttributes(options.attributes);
        var samplingResult = this._sampler.shouldSample(context$1, traceId, name2, spanKind, attributes, links);
        traceState = (_c2 = samplingResult.traceState) !== null && _c2 !== void 0 ? _c2 : traceState;
        var traceFlags = samplingResult.decision === SamplingDecision$1.RECORD_AND_SAMPLED ? TraceFlags.SAMPLED : TraceFlags.NONE;
        var spanContext = { traceId, spanId, traceFlags, traceState };
        if (samplingResult.decision === SamplingDecision$1.NOT_RECORD) {
          diag.debug("Recording is off, propagating context in a non-recording span");
          var nonRecordingSpan = trace.wrapSpanContext(spanContext);
          return nonRecordingSpan;
        }
        var initAttributes = sanitizeAttributes(Object.assign(attributes, samplingResult.attributes));
        var span = new Span(this, context$1, name2, spanContext, spanKind, parentSpanId, links, options.startTime, void 0, initAttributes);
        return span;
      };
      Tracer2.prototype.startActiveSpan = function(name2, arg2, arg3, arg4) {
        var opts;
        var ctx;
        var fn;
        if (arguments.length < 2) {
          return;
        } else if (arguments.length === 2) {
          fn = arg2;
        } else if (arguments.length === 3) {
          opts = arg2;
          fn = arg3;
        } else {
          opts = arg2;
          ctx = arg3;
          fn = arg4;
        }
        var parentContext = ctx !== null && ctx !== void 0 ? ctx : context.active();
        var span = this.startSpan(name2, opts, parentContext);
        var contextWithSpanSet = trace.setSpan(parentContext, span);
        return context.with(contextWithSpanSet, fn, void 0, span);
      };
      Tracer2.prototype.getGeneralLimits = function() {
        return this._generalLimits;
      };
      Tracer2.prototype.getSpanLimits = function() {
        return this._spanLimits;
      };
      Tracer2.prototype.getActiveSpanProcessor = function() {
        return this._tracerProvider.getActiveSpanProcessor();
      };
      return Tracer2;
    }()
  );
  function defaultServiceName() {
    return "unknown_service:" + process.argv0;
  }
  var __assign$1 = function() {
    __assign$1 = Object.assign || function(t2) {
      for (var s2, i2 = 1, n2 = arguments.length; i2 < n2; i2++) {
        s2 = arguments[i2];
        for (var p2 in s2) if (Object.prototype.hasOwnProperty.call(s2, p2))
          t2[p2] = s2[p2];
      }
      return t2;
    };
    return __assign$1.apply(this, arguments);
  };
  var __awaiter$1 = function(thisArg, _arguments, P2, generator) {
    function adopt(value) {
      return value instanceof P2 ? value : new P2(function(resolve2) {
        resolve2(value);
      });
    }
    return new (P2 || (P2 = Promise))(function(resolve2, reject) {
      function fulfilled(value) {
        try {
          step(generator.next(value));
        } catch (e2) {
          reject(e2);
        }
      }
      function rejected(value) {
        try {
          step(generator["throw"](value));
        } catch (e2) {
          reject(e2);
        }
      }
      function step(result) {
        result.done ? resolve2(result.value) : adopt(result.value).then(fulfilled, rejected);
      }
      step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
  };
  var __generator$1 = function(thisArg, body) {
    var _2 = { label: 0, sent: function() {
      if (t2[0] & 1) throw t2[1];
      return t2[1];
    }, trys: [], ops: [] }, f2, y2, t2, g2;
    return g2 = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g2[Symbol.iterator] = function() {
      return this;
    }), g2;
    function verb(n2) {
      return function(v2) {
        return step([n2, v2]);
      };
    }
    function step(op) {
      if (f2) throw new TypeError("Generator is already executing.");
      while (_2) try {
        if (f2 = 1, y2 && (t2 = op[0] & 2 ? y2["return"] : op[0] ? y2["throw"] || ((t2 = y2["return"]) && t2.call(y2), 0) : y2.next) && !(t2 = t2.call(y2, op[1])).done) return t2;
        if (y2 = 0, t2) op = [op[0] & 2, t2.value];
        switch (op[0]) {
          case 0:
          case 1:
            t2 = op;
            break;
          case 4:
            _2.label++;
            return { value: op[1], done: false };
          case 5:
            _2.label++;
            y2 = op[1];
            op = [0];
            continue;
          case 7:
            op = _2.ops.pop();
            _2.trys.pop();
            continue;
          default:
            if (!(t2 = _2.trys, t2 = t2.length > 0 && t2[t2.length - 1]) && (op[0] === 6 || op[0] === 2)) {
              _2 = 0;
              continue;
            }
            if (op[0] === 3 && (!t2 || op[1] > t2[0] && op[1] < t2[3])) {
              _2.label = op[1];
              break;
            }
            if (op[0] === 6 && _2.label < t2[1]) {
              _2.label = t2[1];
              t2 = op;
              break;
            }
            if (t2 && _2.label < t2[2]) {
              _2.label = t2[2];
              _2.ops.push(op);
              break;
            }
            if (t2[2]) _2.ops.pop();
            _2.trys.pop();
            continue;
        }
        op = body.call(thisArg, _2);
      } catch (e2) {
        op = [6, e2];
        y2 = 0;
      } finally {
        f2 = t2 = 0;
      }
      if (op[0] & 5) throw op[1];
      return { value: op[0] ? op[1] : void 0, done: true };
    }
  };
  var __read$2 = function(o2, n2) {
    var m2 = typeof Symbol === "function" && o2[Symbol.iterator];
    if (!m2) return o2;
    var i2 = m2.call(o2), r2, ar = [], e2;
    try {
      while ((n2 === void 0 || n2-- > 0) && !(r2 = i2.next()).done) ar.push(r2.value);
    } catch (error2) {
      e2 = { error: error2 };
    } finally {
      try {
        if (r2 && !r2.done && (m2 = i2["return"])) m2.call(i2);
      } finally {
        if (e2) throw e2.error;
      }
    }
    return ar;
  };
  var Resource = (
    /** @class */
    function() {
      function Resource2(attributes, asyncAttributesPromise) {
        var _this = this;
        var _a3;
        this._attributes = attributes;
        this.asyncAttributesPending = asyncAttributesPromise != null;
        this._syncAttributes = (_a3 = this._attributes) !== null && _a3 !== void 0 ? _a3 : {};
        this._asyncAttributesPromise = asyncAttributesPromise === null || asyncAttributesPromise === void 0 ? void 0 : asyncAttributesPromise.then(function(asyncAttributes) {
          _this._attributes = Object.assign({}, _this._attributes, asyncAttributes);
          _this.asyncAttributesPending = false;
          return asyncAttributes;
        }, function(err) {
          diag.debug("a resource's async attributes promise rejected: %s", err);
          _this.asyncAttributesPending = false;
          return {};
        });
      }
      Resource2.empty = function() {
        return Resource2.EMPTY;
      };
      Resource2.default = function() {
        var _a3;
        return new Resource2((_a3 = {}, _a3[SEMRESATTRS_SERVICE_NAME] = defaultServiceName(), _a3[SEMRESATTRS_TELEMETRY_SDK_LANGUAGE] = SDK_INFO[SEMRESATTRS_TELEMETRY_SDK_LANGUAGE], _a3[SEMRESATTRS_TELEMETRY_SDK_NAME] = SDK_INFO[SEMRESATTRS_TELEMETRY_SDK_NAME], _a3[SEMRESATTRS_TELEMETRY_SDK_VERSION] = SDK_INFO[SEMRESATTRS_TELEMETRY_SDK_VERSION], _a3));
      };
      Object.defineProperty(Resource2.prototype, "attributes", {
        get: function() {
          var _a3;
          if (this.asyncAttributesPending) {
            diag.error("Accessing resource attributes before async attributes settled");
          }
          return (_a3 = this._attributes) !== null && _a3 !== void 0 ? _a3 : {};
        },
        enumerable: false,
        configurable: true
      });
      Resource2.prototype.waitForAsyncAttributes = function() {
        return __awaiter$1(this, void 0, void 0, function() {
          return __generator$1(this, function(_a3) {
            switch (_a3.label) {
              case 0:
                if (!this.asyncAttributesPending) return [3, 2];
                return [4, this._asyncAttributesPromise];
              case 1:
                _a3.sent();
                _a3.label = 2;
              case 2:
                return [
                  2
                  /*return*/
                ];
            }
          });
        });
      };
      Resource2.prototype.merge = function(other) {
        var _this = this;
        var _a3;
        if (!other)
          return this;
        var mergedSyncAttributes = __assign$1(__assign$1({}, this._syncAttributes), (_a3 = other._syncAttributes) !== null && _a3 !== void 0 ? _a3 : other.attributes);
        if (!this._asyncAttributesPromise && !other._asyncAttributesPromise) {
          return new Resource2(mergedSyncAttributes);
        }
        var mergedAttributesPromise = Promise.all([
          this._asyncAttributesPromise,
          other._asyncAttributesPromise
        ]).then(function(_a4) {
          var _b2;
          var _c2 = __read$2(_a4, 2), thisAsyncAttributes = _c2[0], otherAsyncAttributes = _c2[1];
          return __assign$1(__assign$1(__assign$1(__assign$1({}, _this._syncAttributes), thisAsyncAttributes), (_b2 = other._syncAttributes) !== null && _b2 !== void 0 ? _b2 : other.attributes), otherAsyncAttributes);
        });
        return new Resource2(mergedSyncAttributes, mergedAttributesPromise);
      };
      Resource2.EMPTY = new Resource2({});
      return Resource2;
    }()
  );
  var __values$3 = function(o2) {
    var s2 = typeof Symbol === "function" && Symbol.iterator, m2 = s2 && o2[s2], i2 = 0;
    if (m2) return m2.call(o2);
    if (o2 && typeof o2.length === "number") return {
      next: function() {
        if (o2 && i2 >= o2.length) o2 = void 0;
        return { value: o2 && o2[i2++], done: !o2 };
      }
    };
    throw new TypeError(s2 ? "Object is not iterable." : "Symbol.iterator is not defined.");
  };
  var MultiSpanProcessor = (
    /** @class */
    function() {
      function MultiSpanProcessor2(_spanProcessors) {
        this._spanProcessors = _spanProcessors;
      }
      MultiSpanProcessor2.prototype.forceFlush = function() {
        var e_1, _a3;
        var promises = [];
        try {
          for (var _b2 = __values$3(this._spanProcessors), _c2 = _b2.next(); !_c2.done; _c2 = _b2.next()) {
            var spanProcessor = _c2.value;
            promises.push(spanProcessor.forceFlush());
          }
        } catch (e_1_1) {
          e_1 = { error: e_1_1 };
        } finally {
          try {
            if (_c2 && !_c2.done && (_a3 = _b2.return)) _a3.call(_b2);
          } finally {
            if (e_1) throw e_1.error;
          }
        }
        return new Promise(function(resolve2) {
          Promise.all(promises).then(function() {
            resolve2();
          }).catch(function(error2) {
            globalErrorHandler(error2 || new Error("MultiSpanProcessor: forceFlush failed"));
            resolve2();
          });
        });
      };
      MultiSpanProcessor2.prototype.onStart = function(span, context2) {
        var e_2, _a3;
        try {
          for (var _b2 = __values$3(this._spanProcessors), _c2 = _b2.next(); !_c2.done; _c2 = _b2.next()) {
            var spanProcessor = _c2.value;
            spanProcessor.onStart(span, context2);
          }
        } catch (e_2_1) {
          e_2 = { error: e_2_1 };
        } finally {
          try {
            if (_c2 && !_c2.done && (_a3 = _b2.return)) _a3.call(_b2);
          } finally {
            if (e_2) throw e_2.error;
          }
        }
      };
      MultiSpanProcessor2.prototype.onEnd = function(span) {
        var e_3, _a3;
        try {
          for (var _b2 = __values$3(this._spanProcessors), _c2 = _b2.next(); !_c2.done; _c2 = _b2.next()) {
            var spanProcessor = _c2.value;
            spanProcessor.onEnd(span);
          }
        } catch (e_3_1) {
          e_3 = { error: e_3_1 };
        } finally {
          try {
            if (_c2 && !_c2.done && (_a3 = _b2.return)) _a3.call(_b2);
          } finally {
            if (e_3) throw e_3.error;
          }
        }
      };
      MultiSpanProcessor2.prototype.shutdown = function() {
        var e_4, _a3;
        var promises = [];
        try {
          for (var _b2 = __values$3(this._spanProcessors), _c2 = _b2.next(); !_c2.done; _c2 = _b2.next()) {
            var spanProcessor = _c2.value;
            promises.push(spanProcessor.shutdown());
          }
        } catch (e_4_1) {
          e_4 = { error: e_4_1 };
        } finally {
          try {
            if (_c2 && !_c2.done && (_a3 = _b2.return)) _a3.call(_b2);
          } finally {
            if (e_4) throw e_4.error;
          }
        }
        return new Promise(function(resolve2, reject) {
          Promise.all(promises).then(function() {
            resolve2();
          }, reject);
        });
      };
      return MultiSpanProcessor2;
    }()
  );
  var NoopSpanProcessor = (
    /** @class */
    function() {
      function NoopSpanProcessor2() {
      }
      NoopSpanProcessor2.prototype.onStart = function(_span, _context) {
      };
      NoopSpanProcessor2.prototype.onEnd = function(_span) {
      };
      NoopSpanProcessor2.prototype.shutdown = function() {
        return Promise.resolve();
      };
      NoopSpanProcessor2.prototype.forceFlush = function() {
        return Promise.resolve();
      };
      return NoopSpanProcessor2;
    }()
  );
  var __read$1 = function(o2, n2) {
    var m2 = typeof Symbol === "function" && o2[Symbol.iterator];
    if (!m2) return o2;
    var i2 = m2.call(o2), r2, ar = [], e2;
    try {
      while ((n2 === void 0 || n2-- > 0) && !(r2 = i2.next()).done) ar.push(r2.value);
    } catch (error2) {
      e2 = { error: error2 };
    } finally {
      try {
        if (r2 && !r2.done && (m2 = i2["return"])) m2.call(i2);
      } finally {
        if (e2) throw e2.error;
      }
    }
    return ar;
  };
  var __spreadArray$1 = function(to, from, pack) {
    if (pack || arguments.length === 2) for (var i2 = 0, l2 = from.length, ar; i2 < l2; i2++) {
      if (ar || !(i2 in from)) {
        if (!ar) ar = Array.prototype.slice.call(from, 0, i2);
        ar[i2] = from[i2];
      }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
  };
  var ForceFlushState;
  (function(ForceFlushState2) {
    ForceFlushState2[ForceFlushState2["resolved"] = 0] = "resolved";
    ForceFlushState2[ForceFlushState2["timeout"] = 1] = "timeout";
    ForceFlushState2[ForceFlushState2["error"] = 2] = "error";
    ForceFlushState2[ForceFlushState2["unresolved"] = 3] = "unresolved";
  })(ForceFlushState || (ForceFlushState = {}));
  var BasicTracerProvider = (
    /** @class */
    function() {
      function BasicTracerProvider2(config2) {
        if (config2 === void 0) {
          config2 = {};
        }
        var _a3, _b2;
        this._registeredSpanProcessors = [];
        this._tracers = /* @__PURE__ */ new Map();
        var mergedConfig = merge({}, loadDefaultConfig(), reconfigureLimits(config2));
        this.resource = (_a3 = mergedConfig.resource) !== null && _a3 !== void 0 ? _a3 : Resource.empty();
        if (mergedConfig.mergeResourceWithDefaults) {
          this.resource = Resource.default().merge(this.resource);
        }
        this._config = Object.assign({}, mergedConfig, {
          resource: this.resource
        });
        if ((_b2 = config2.spanProcessors) === null || _b2 === void 0 ? void 0 : _b2.length) {
          this._registeredSpanProcessors = __spreadArray$1([], __read$1(config2.spanProcessors), false);
          this.activeSpanProcessor = new MultiSpanProcessor(this._registeredSpanProcessors);
        } else {
          var defaultExporter = this._buildExporterFromEnv();
          if (defaultExporter !== void 0) {
            var batchProcessor = new BatchSpanProcessor(defaultExporter);
            this.activeSpanProcessor = batchProcessor;
          } else {
            this.activeSpanProcessor = new NoopSpanProcessor();
          }
        }
      }
      BasicTracerProvider2.prototype.getTracer = function(name2, version2, options) {
        var key = name2 + "@" + (version2 || "") + ":" + ((options === null || options === void 0 ? void 0 : options.schemaUrl) || "");
        if (!this._tracers.has(key)) {
          this._tracers.set(key, new Tracer({ name: name2, version: version2, schemaUrl: options === null || options === void 0 ? void 0 : options.schemaUrl }, this._config, this));
        }
        return this._tracers.get(key);
      };
      BasicTracerProvider2.prototype.addSpanProcessor = function(spanProcessor) {
        if (this._registeredSpanProcessors.length === 0) {
          this.activeSpanProcessor.shutdown().catch(function(err) {
            return diag.error("Error while trying to shutdown current span processor", err);
          });
        }
        this._registeredSpanProcessors.push(spanProcessor);
        this.activeSpanProcessor = new MultiSpanProcessor(this._registeredSpanProcessors);
      };
      BasicTracerProvider2.prototype.getActiveSpanProcessor = function() {
        return this.activeSpanProcessor;
      };
      BasicTracerProvider2.prototype.register = function(config2) {
        if (config2 === void 0) {
          config2 = {};
        }
        trace.setGlobalTracerProvider(this);
        if (config2.propagator === void 0) {
          config2.propagator = this._buildPropagatorFromEnv();
        }
        if (config2.contextManager) {
          context.setGlobalContextManager(config2.contextManager);
        }
        if (config2.propagator) {
          propagation.setGlobalPropagator(config2.propagator);
        }
      };
      BasicTracerProvider2.prototype.forceFlush = function() {
        var timeout = this._config.forceFlushTimeoutMillis;
        var promises = this._registeredSpanProcessors.map(function(spanProcessor) {
          return new Promise(function(resolve2) {
            var state;
            var timeoutInterval = setTimeout(function() {
              resolve2(new Error("Span processor did not completed within timeout period of " + timeout + " ms"));
              state = ForceFlushState.timeout;
            }, timeout);
            spanProcessor.forceFlush().then(function() {
              clearTimeout(timeoutInterval);
              if (state !== ForceFlushState.timeout) {
                state = ForceFlushState.resolved;
                resolve2(state);
              }
            }).catch(function(error2) {
              clearTimeout(timeoutInterval);
              state = ForceFlushState.error;
              resolve2(error2);
            });
          });
        });
        return new Promise(function(resolve2, reject) {
          Promise.all(promises).then(function(results) {
            var errors = results.filter(function(result) {
              return result !== ForceFlushState.resolved;
            });
            if (errors.length > 0) {
              reject(errors);
            } else {
              resolve2();
            }
          }).catch(function(error2) {
            return reject([error2]);
          });
        });
      };
      BasicTracerProvider2.prototype.shutdown = function() {
        return this.activeSpanProcessor.shutdown();
      };
      BasicTracerProvider2.prototype._getPropagator = function(name2) {
        var _a3;
        return (_a3 = this.constructor._registeredPropagators.get(name2)) === null || _a3 === void 0 ? void 0 : _a3();
      };
      BasicTracerProvider2.prototype._getSpanExporter = function(name2) {
        var _a3;
        return (_a3 = this.constructor._registeredExporters.get(name2)) === null || _a3 === void 0 ? void 0 : _a3();
      };
      BasicTracerProvider2.prototype._buildPropagatorFromEnv = function() {
        var _this = this;
        var uniquePropagatorNames = Array.from(new Set(getEnv$1().OTEL_PROPAGATORS));
        var propagators = uniquePropagatorNames.map(function(name2) {
          var propagator = _this._getPropagator(name2);
          if (!propagator) {
            diag.warn('Propagator "' + name2 + '" requested through environment variable is unavailable.');
          }
          return propagator;
        });
        var validPropagators = propagators.reduce(function(list, item) {
          if (item) {
            list.push(item);
          }
          return list;
        }, []);
        if (validPropagators.length === 0) {
          return;
        } else if (uniquePropagatorNames.length === 1) {
          return validPropagators[0];
        } else {
          return new CompositePropagator({
            propagators: validPropagators
          });
        }
      };
      BasicTracerProvider2.prototype._buildExporterFromEnv = function() {
        var exporterName = getEnv$1().OTEL_TRACES_EXPORTER;
        if (exporterName === "none" || exporterName === "")
          return;
        var exporter = this._getSpanExporter(exporterName);
        if (!exporter) {
          diag.error('Exporter "' + exporterName + '" requested through environment variable is unavailable.');
        }
        return exporter;
      };
      BasicTracerProvider2._registeredPropagators = /* @__PURE__ */ new Map([
        ["tracecontext", function() {
          return new W3CTraceContextPropagator();
        }],
        ["baggage", function() {
          return new W3CBaggagePropagator();
        }]
      ]);
      BasicTracerProvider2._registeredExporters = /* @__PURE__ */ new Map();
      return BasicTracerProvider2;
    }()
  );
  var NoopLogger$1 = (
    /** @class */
    function() {
      function NoopLogger2() {
      }
      NoopLogger2.prototype.emit = function(_logRecord) {
      };
      return NoopLogger2;
    }()
  );
  var NOOP_LOGGER = new NoopLogger$1();
  var NoopLoggerProvider$1 = (
    /** @class */
    function() {
      function NoopLoggerProvider2() {
      }
      NoopLoggerProvider2.prototype.getLogger = function(_name, _version, _options) {
        return new NoopLogger$1();
      };
      return NoopLoggerProvider2;
    }()
  );
  var NOOP_LOGGER_PROVIDER$1 = new NoopLoggerProvider$1();
  var ProxyLogger = (
    /** @class */
    function() {
      function ProxyLogger2(_provider, name2, version2, options) {
        this._provider = _provider;
        this.name = name2;
        this.version = version2;
        this.options = options;
      }
      ProxyLogger2.prototype.emit = function(logRecord) {
        this._getLogger().emit(logRecord);
      };
      ProxyLogger2.prototype._getLogger = function() {
        if (this._delegate) {
          return this._delegate;
        }
        var logger2 = this._provider.getDelegateLogger(this.name, this.version, this.options);
        if (!logger2) {
          return NOOP_LOGGER;
        }
        this._delegate = logger2;
        return this._delegate;
      };
      return ProxyLogger2;
    }()
  );
  var ProxyLoggerProvider = (
    /** @class */
    function() {
      function ProxyLoggerProvider2() {
      }
      ProxyLoggerProvider2.prototype.getLogger = function(name2, version2, options) {
        var _a3;
        return (_a3 = this.getDelegateLogger(name2, version2, options)) !== null && _a3 !== void 0 ? _a3 : new ProxyLogger(this, name2, version2, options);
      };
      ProxyLoggerProvider2.prototype.getDelegate = function() {
        var _a3;
        return (_a3 = this._delegate) !== null && _a3 !== void 0 ? _a3 : NOOP_LOGGER_PROVIDER$1;
      };
      ProxyLoggerProvider2.prototype.setDelegate = function(delegate) {
        this._delegate = delegate;
      };
      ProxyLoggerProvider2.prototype.getDelegateLogger = function(name2, version2, options) {
        var _a3;
        return (_a3 = this._delegate) === null || _a3 === void 0 ? void 0 : _a3.getLogger(name2, version2, options);
      };
      return ProxyLoggerProvider2;
    }()
  );
  var _globalThis$1 = typeof globalThis === "object" ? globalThis : global;
  var GLOBAL_LOGS_API_KEY$1 = Symbol.for("io.opentelemetry.js.api.logs");
  var _global$1 = _globalThis$1;
  function makeGetter$1(requiredVersion, instance, fallback) {
    return function(version2) {
      return version2 === requiredVersion ? instance : fallback;
    };
  }
  var API_BACKWARDS_COMPATIBILITY_VERSION$1 = 1;
  var LogsAPI$1 = (
    /** @class */
    function() {
      function LogsAPI2() {
        this._proxyLoggerProvider = new ProxyLoggerProvider();
      }
      LogsAPI2.getInstance = function() {
        if (!this._instance) {
          this._instance = new LogsAPI2();
        }
        return this._instance;
      };
      LogsAPI2.prototype.setGlobalLoggerProvider = function(provider) {
        if (_global$1[GLOBAL_LOGS_API_KEY$1]) {
          return this.getLoggerProvider();
        }
        _global$1[GLOBAL_LOGS_API_KEY$1] = makeGetter$1(API_BACKWARDS_COMPATIBILITY_VERSION$1, provider, NOOP_LOGGER_PROVIDER$1);
        this._proxyLoggerProvider.setDelegate(provider);
        return provider;
      };
      LogsAPI2.prototype.getLoggerProvider = function() {
        var _a3, _b2;
        return (_b2 = (_a3 = _global$1[GLOBAL_LOGS_API_KEY$1]) === null || _a3 === void 0 ? void 0 : _a3.call(_global$1, API_BACKWARDS_COMPATIBILITY_VERSION$1)) !== null && _b2 !== void 0 ? _b2 : this._proxyLoggerProvider;
      };
      LogsAPI2.prototype.getLogger = function(name2, version2, options) {
        return this.getLoggerProvider().getLogger(name2, version2, options);
      };
      LogsAPI2.prototype.disable = function() {
        delete _global$1[GLOBAL_LOGS_API_KEY$1];
        this._proxyLoggerProvider = new ProxyLoggerProvider();
      };
      return LogsAPI2;
    }()
  );
  var logs$1 = LogsAPI$1.getInstance();
  function enableInstrumentations$1(instrumentations, tracerProvider, meterProvider, loggerProvider) {
    for (var i2 = 0, j2 = instrumentations.length; i2 < j2; i2++) {
      var instrumentation = instrumentations[i2];
      if (tracerProvider) {
        instrumentation.setTracerProvider(tracerProvider);
      }
      if (meterProvider) {
        instrumentation.setMeterProvider(meterProvider);
      }
      if (loggerProvider && instrumentation.setLoggerProvider) {
        instrumentation.setLoggerProvider(loggerProvider);
      }
      if (!instrumentation.getConfig().enabled) {
        instrumentation.enable();
      }
    }
  }
  function disableInstrumentations$1(instrumentations) {
    instrumentations.forEach(function(instrumentation) {
      return instrumentation.disable();
    });
  }
  function registerInstrumentations$1(options) {
    var _a3, _b2;
    var tracerProvider = options.tracerProvider || trace.getTracerProvider();
    var meterProvider = options.meterProvider || metrics.getMeterProvider();
    var loggerProvider = options.loggerProvider || logs$1.getLoggerProvider();
    var instrumentations = (_b2 = (_a3 = options.instrumentations) === null || _a3 === void 0 ? void 0 : _a3.flat()) !== null && _b2 !== void 0 ? _b2 : [];
    enableInstrumentations$1(instrumentations, tracerProvider, meterProvider, loggerProvider);
    return function() {
      disableInstrumentations$1(instrumentations);
    };
  }
  const SEMANTIC_ATTRIBUTE_SENTRY_PARENT_IS_REMOTE = "sentry.parentIsRemote";
  const SEMANTIC_ATTRIBUTE_SENTRY_GRAPHQL_OPERATION = "sentry.graphql.operation";
  function spanHasAttributes(span) {
    const castSpan = span;
    return !!castSpan.attributes && typeof castSpan.attributes === "object";
  }
  function spanHasKind(span) {
    const castSpan = span;
    return typeof castSpan.kind === "number";
  }
  function spanHasStatus(span) {
    const castSpan = span;
    return !!castSpan.status;
  }
  function spanHasName(span) {
    const castSpan = span;
    return !!castSpan.name;
  }
  function getRequestSpanData(span) {
    if (!spanHasAttributes(span)) {
      return {};
    }
    const maybeUrlAttribute = span.attributes[ATTR_URL_FULL] || span.attributes[SEMATTRS_HTTP_URL];
    const data2 = {
      url: maybeUrlAttribute,
      // eslint-disable-next-line deprecation/deprecation
      "http.method": span.attributes[ATTR_HTTP_REQUEST_METHOD] || span.attributes[SEMATTRS_HTTP_METHOD]
    };
    if (!data2["http.method"] && data2.url) {
      data2["http.method"] = "GET";
    }
    try {
      if (typeof maybeUrlAttribute === "string") {
        const url2 = parseUrl(maybeUrlAttribute);
        data2.url = getSanitizedUrlString(url2);
        if (url2.search) {
          data2["http.query"] = url2.search;
        }
        if (url2.hash) {
          data2["http.fragment"] = url2.hash;
        }
      }
    } catch (e2) {
    }
    return data2;
  }
  function getSpanKind(span) {
    if (spanHasKind(span)) {
      return span.kind;
    }
    return SpanKind.INTERNAL;
  }
  const SENTRY_TRACE_HEADER = "sentry-trace";
  const SENTRY_BAGGAGE_HEADER = "baggage";
  const SENTRY_TRACE_STATE_DSC = "sentry.dsc";
  const SENTRY_TRACE_STATE_PARENT_SPAN_ID = "sentry.parent_span_id";
  const SENTRY_TRACE_STATE_SAMPLED_NOT_RECORDING = "sentry.sampled_not_recording";
  const SENTRY_TRACE_STATE_URL = "sentry.url";
  const SENTRY_SCOPES_CONTEXT_KEY = createContextKey("sentry_scopes");
  const SENTRY_FORK_ISOLATION_SCOPE_CONTEXT_KEY = createContextKey("sentry_fork_isolation_scope");
  const SENTRY_FORK_SET_SCOPE_CONTEXT_KEY = createContextKey("sentry_fork_set_scope");
  const SENTRY_FORK_SET_ISOLATION_SCOPE_CONTEXT_KEY = createContextKey("sentry_fork_set_isolation_scope");
  const SCOPE_CONTEXT_FIELD = "_scopeContext";
  function getScopesFromContext(context2) {
    return context2.getValue(SENTRY_SCOPES_CONTEXT_KEY);
  }
  function setScopesOnContext(context2, scopes) {
    return context2.setValue(SENTRY_SCOPES_CONTEXT_KEY, scopes);
  }
  function setContextOnScope(scope2, context2) {
    addNonEnumerableProperty(scope2, SCOPE_CONTEXT_FIELD, context2);
  }
  function getContextFromScope(scope2) {
    return scope2[SCOPE_CONTEXT_FIELD];
  }
  function inferSpanData(name2, attributes, kind) {
    const httpMethod = attributes[ATTR_HTTP_REQUEST_METHOD] || attributes[SEMATTRS_HTTP_METHOD];
    if (httpMethod) {
      return descriptionForHttpMethod({ attributes, name: name2, kind }, httpMethod);
    }
    const dbSystem = attributes[SEMATTRS_DB_SYSTEM];
    const opIsCache = typeof attributes[SEMANTIC_ATTRIBUTE_SENTRY_OP] === "string" && attributes[SEMANTIC_ATTRIBUTE_SENTRY_OP].startsWith("cache.");
    if (dbSystem && !opIsCache) {
      return descriptionForDbSystem({ attributes, name: name2 });
    }
    const rpcService = attributes[SEMATTRS_RPC_SERVICE];
    if (rpcService) {
      return {
        op: "rpc",
        description: name2,
        source: "route"
      };
    }
    const messagingSystem = attributes[SEMATTRS_MESSAGING_SYSTEM];
    if (messagingSystem) {
      return {
        op: "message",
        description: name2,
        source: "route"
      };
    }
    const faasTrigger = attributes[SEMATTRS_FAAS_TRIGGER];
    if (faasTrigger) {
      return { op: faasTrigger.toString(), description: name2, source: "route" };
    }
    return { op: void 0, description: name2, source: "custom" };
  }
  function parseSpanDescription(span) {
    const attributes = spanHasAttributes(span) ? span.attributes : {};
    const name2 = spanHasName(span) ? span.name : "<unknown>";
    const kind = getSpanKind(span);
    return inferSpanData(name2, attributes, kind);
  }
  function descriptionForDbSystem({ attributes, name: name2 }) {
    const statement = attributes[SEMATTRS_DB_STATEMENT];
    const description2 = statement ? statement.toString() : name2;
    return { op: "db", description: description2, source: "task" };
  }
  function descriptionForHttpMethod({ name: name2, kind, attributes }, httpMethod) {
    const opParts = ["http"];
    switch (kind) {
      case SpanKind.CLIENT:
        opParts.push("client");
        break;
      case SpanKind.SERVER:
        opParts.push("server");
        break;
    }
    if (attributes["sentry.http.prefetch"]) {
      opParts.push("prefetch");
    }
    const { urlPath, url: url2, query, fragment, hasRoute } = getSanitizedUrl(attributes, kind);
    if (!urlPath) {
      return { op: opParts.join("."), description: name2, source: "custom" };
    }
    const graphqlOperationsAttribute = attributes[SEMANTIC_ATTRIBUTE_SENTRY_GRAPHQL_OPERATION];
    const baseDescription = `${httpMethod} ${urlPath}`;
    const description2 = graphqlOperationsAttribute ? `${baseDescription} (${getGraphqlOperationNamesFromAttribute(graphqlOperationsAttribute)})` : baseDescription;
    const source = hasRoute || urlPath === "/" ? "route" : "url";
    const data2 = {};
    if (url2) {
      data2.url = url2;
    }
    if (query) {
      data2["http.query"] = query;
    }
    if (fragment) {
      data2["http.fragment"] = fragment;
    }
    const isClientOrServerKind = kind === SpanKind.CLIENT || kind === SpanKind.SERVER;
    const origin = attributes[SEMANTIC_ATTRIBUTE_SENTRY_ORIGIN] || "manual";
    const isManualSpan = !`${origin}`.startsWith("auto");
    const useInferredDescription = isClientOrServerKind || !isManualSpan;
    return {
      op: opParts.join("."),
      description: useInferredDescription ? description2 : name2,
      source: useInferredDescription ? source : "custom",
      data: data2
    };
  }
  function getGraphqlOperationNamesFromAttribute(attr) {
    if (Array.isArray(attr)) {
      const sorted = attr.slice().sort();
      if (sorted.length <= 5) {
        return sorted.join(", ");
      } else {
        return `${sorted.slice(0, 5).join(", ")}, +${sorted.length - 5}`;
      }
    }
    return `${attr}`;
  }
  function getSanitizedUrl(attributes, kind) {
    const httpTarget = attributes[SEMATTRS_HTTP_TARGET];
    const httpUrl = attributes[SEMATTRS_HTTP_URL] || attributes[ATTR_URL_FULL];
    const httpRoute = attributes[ATTR_HTTP_ROUTE];
    const parsedUrl = typeof httpUrl === "string" ? parseUrl(httpUrl) : void 0;
    const url2 = parsedUrl ? getSanitizedUrlString(parsedUrl) : void 0;
    const query = parsedUrl && parsedUrl.search ? parsedUrl.search : void 0;
    const fragment = parsedUrl && parsedUrl.hash ? parsedUrl.hash : void 0;
    if (typeof httpRoute === "string") {
      return { urlPath: httpRoute, url: url2, query, fragment, hasRoute: true };
    }
    if (kind === SpanKind.SERVER && typeof httpTarget === "string") {
      return { urlPath: stripUrlQueryAndFragment(httpTarget), url: url2, query, fragment, hasRoute: false };
    }
    if (parsedUrl) {
      return { urlPath: url2, url: url2, query, fragment, hasRoute: false };
    }
    if (typeof httpTarget === "string") {
      return { urlPath: stripUrlQueryAndFragment(httpTarget), url: url2, query, fragment, hasRoute: false };
    }
    return { urlPath: void 0, url: url2, query, fragment, hasRoute: false };
  }
  function makeTraceState({
    parentSpanId,
    dsc,
    sampled
  }) {
    const dscString = dsc ? dynamicSamplingContextToSentryBaggageHeader(dsc) : void 0;
    const traceStateBase = new TraceState().set(SENTRY_TRACE_STATE_PARENT_SPAN_ID, parentSpanId || "");
    const traceStateWithDsc = dscString ? traceStateBase.set(SENTRY_TRACE_STATE_DSC, dscString) : traceStateBase;
    return sampled === false ? traceStateWithDsc.set(SENTRY_TRACE_STATE_SAMPLED_NOT_RECORDING, "1") : traceStateWithDsc;
  }
  function getActiveSpan() {
    return trace.getActiveSpan();
  }
  const DEBUG_BUILD$1 = typeof __SENTRY_DEBUG__ === "undefined" || __SENTRY_DEBUG__;
  function _optionalChain$7(ops) {
    let lastAccessLHS = void 0;
    let value = ops[0];
    let i2 = 1;
    while (i2 < ops.length) {
      const op = ops[i2];
      const fn = ops[i2 + 1];
      i2 += 2;
      if ((op === "optionalAccess" || op === "optionalCall") && value == null) {
        return void 0;
      }
      if (op === "access" || op === "optionalAccess") {
        lastAccessLHS = value;
        value = fn(value);
      } else if (op === "call" || op === "optionalCall") {
        value = fn((...args2) => value.call(lastAccessLHS, ...args2));
        lastAccessLHS = void 0;
      }
    }
    return value;
  }
  function getSamplingDecision(spanContext) {
    const { traceFlags, traceState } = spanContext;
    const sampledNotRecording = traceState ? traceState.get(SENTRY_TRACE_STATE_SAMPLED_NOT_RECORDING) === "1" : false;
    if (traceFlags === TraceFlags.SAMPLED) {
      return true;
    }
    if (sampledNotRecording) {
      return false;
    }
    const dscString = traceState ? traceState.get(SENTRY_TRACE_STATE_DSC) : void 0;
    const dsc = dscString ? baggageHeaderToDynamicSamplingContext(dscString) : void 0;
    if (_optionalChain$7([dsc, "optionalAccess", (_2) => _2.sampled]) === "true") {
      return true;
    }
    if (_optionalChain$7([dsc, "optionalAccess", (_2) => _2.sampled]) === "false") {
      return false;
    }
    return void 0;
  }
  const setupElements = /* @__PURE__ */ new Set();
  function setIsSetup(element) {
    setupElements.add(element);
  }
  function _optionalChain$6(ops) {
    let lastAccessLHS = void 0;
    let value = ops[0];
    let i2 = 1;
    while (i2 < ops.length) {
      const op = ops[i2];
      const fn = ops[i2 + 1];
      i2 += 2;
      if ((op === "optionalAccess" || op === "optionalCall") && value == null) {
        return void 0;
      }
      if (op === "access" || op === "optionalAccess") {
        lastAccessLHS = value;
        value = fn(value);
      } else if (op === "call" || op === "optionalCall") {
        value = fn((...args2) => value.call(lastAccessLHS, ...args2));
        lastAccessLHS = void 0;
      }
    }
    return value;
  }
  function getPropagationContextFromSpan(span) {
    const spanContext = span.spanContext();
    const { traceId, spanId, traceState } = spanContext;
    const dscString = traceState ? traceState.get(SENTRY_TRACE_STATE_DSC) : void 0;
    const traceStateDsc = dscString ? baggageHeaderToDynamicSamplingContext(dscString) : void 0;
    const parentSpanId = traceState ? traceState.get(SENTRY_TRACE_STATE_PARENT_SPAN_ID) || void 0 : void 0;
    const sampled = getSamplingDecision(spanContext);
    const dsc = traceStateDsc || getDynamicSamplingContextFromSpan(getRootSpan(span));
    return {
      traceId,
      spanId,
      sampled,
      parentSpanId,
      dsc
    };
  }
  class SentryPropagator extends W3CBaggagePropagator {
    /** A map of URLs that have already been checked for if they match tracePropagationTargets. */
    constructor() {
      super();
      setIsSetup("SentryPropagator");
      this._urlMatchesTargetsMap = new LRUMap(100);
    }
    /**
     * @inheritDoc
     */
    inject(context2, carrier, setter) {
      if (isTracingSuppressed(context2)) {
        DEBUG_BUILD$1 && logger$2.log("[Tracing] Not injecting trace data for url because tracing is suppressed.");
        return;
      }
      const activeSpan = trace.getSpan(context2);
      const url2 = activeSpan && getCurrentURL(activeSpan);
      const tracePropagationTargets = _optionalChain$6([getClient, "call", (_2) => _2(), "optionalAccess", (_2) => _2.getOptions, "call", (_3) => _3(), "optionalAccess", (_4) => _4.tracePropagationTargets]);
      if (!shouldPropagateTraceForUrl(url2, tracePropagationTargets, this._urlMatchesTargetsMap)) {
        DEBUG_BUILD$1 && logger$2.log(
          "[Tracing] Not injecting trace data for url because it does not match tracePropagationTargets:",
          url2
        );
        return;
      }
      const existingBaggageHeader = getExistingBaggage(carrier);
      let baggage = propagation.getBaggage(context2) || propagation.createBaggage({});
      const { dynamicSamplingContext, traceId, spanId, sampled } = getInjectionData(context2);
      if (existingBaggageHeader) {
        const baggageEntries = parseBaggageHeader(existingBaggageHeader);
        if (baggageEntries) {
          Object.entries(baggageEntries).forEach(([key, value]) => {
            baggage = baggage.setEntry(key, { value });
          });
        }
      }
      if (dynamicSamplingContext) {
        baggage = Object.entries(dynamicSamplingContext).reduce((b2, [dscKey, dscValue]) => {
          if (dscValue) {
            return b2.setEntry(`${SENTRY_BAGGAGE_KEY_PREFIX}${dscKey}`, { value: dscValue });
          }
          return b2;
        }, baggage);
      }
      if (traceId && traceId !== INVALID_TRACEID) {
        setter.set(carrier, SENTRY_TRACE_HEADER, generateSentryTraceHeader(traceId, spanId, sampled));
      }
      super.inject(propagation.setBaggage(context2, baggage), carrier, setter);
    }
    /**
     * @inheritDoc
     */
    extract(context2, carrier, getter) {
      const maybeSentryTraceHeader = getter.get(carrier, SENTRY_TRACE_HEADER);
      const baggage = getter.get(carrier, SENTRY_BAGGAGE_HEADER);
      const sentryTrace = maybeSentryTraceHeader ? Array.isArray(maybeSentryTraceHeader) ? maybeSentryTraceHeader[0] : maybeSentryTraceHeader : void 0;
      const propagationContext = propagationContextFromHeaders(sentryTrace, baggage);
      const ctxWithSpanContext = getContextWithRemoteActiveSpan(context2, { sentryTrace, baggage });
      const scopes = getScopesFromContext(ctxWithSpanContext);
      const newScopes = {
        scope: scopes ? scopes.scope.clone() : getCurrentScope().clone(),
        isolationScope: scopes ? scopes.isolationScope : getIsolationScope()
      };
      newScopes.scope.setPropagationContext(propagationContext);
      return setScopesOnContext(ctxWithSpanContext, newScopes);
    }
    /**
     * @inheritDoc
     */
    fields() {
      return [SENTRY_TRACE_HEADER, SENTRY_BAGGAGE_HEADER];
    }
  }
  const NOT_PROPAGATED_MESSAGE = "[Tracing] Not injecting trace data for url because it does not match tracePropagationTargets:";
  function shouldPropagateTraceForUrl(url2, tracePropagationTargets, decisionMap) {
    if (typeof url2 !== "string" || !tracePropagationTargets) {
      return true;
    }
    const cachedDecision = _optionalChain$6([decisionMap, "optionalAccess", (_5) => _5.get, "call", (_6) => _6(url2)]);
    if (cachedDecision !== void 0) {
      DEBUG_BUILD$1 && !cachedDecision && logger$2.log(NOT_PROPAGATED_MESSAGE, url2);
      return cachedDecision;
    }
    const decision = stringMatchesSomePattern(url2, tracePropagationTargets);
    _optionalChain$6([decisionMap, "optionalAccess", (_7) => _7.set, "call", (_8) => _8(url2, decision)]);
    DEBUG_BUILD$1 && !decision && logger$2.log(NOT_PROPAGATED_MESSAGE, url2);
    return decision;
  }
  function getInjectionData(context2) {
    const span = trace.getSpan(context2);
    const spanIsRemote = _optionalChain$6([span, "optionalAccess", (_9) => _9.spanContext, "call", (_10) => _10(), "access", (_11) => _11.isRemote]);
    if (span && !spanIsRemote) {
      const spanContext = span.spanContext();
      const dynamicSamplingContext2 = getDynamicSamplingContextFromSpan(span);
      return {
        dynamicSamplingContext: dynamicSamplingContext2,
        traceId: spanContext.traceId,
        spanId: spanContext.spanId,
        sampled: getSamplingDecision(spanContext)
      };
    }
    const scope2 = _optionalChain$6([getScopesFromContext, "call", (_12) => _12(context2), "optionalAccess", (_13) => _13.scope]) || getCurrentScope();
    const client = getClient();
    const propagationContext = scope2.getPropagationContext();
    const dynamicSamplingContext = client ? getDynamicSamplingContextFromScope(client, scope2) : void 0;
    return {
      dynamicSamplingContext,
      traceId: propagationContext.traceId,
      // TODO(v9): Use generateSpanId() instead
      // eslint-disable-next-line deprecation/deprecation
      spanId: propagationContext.spanId,
      sampled: propagationContext.sampled
    };
  }
  function getContextWithRemoteActiveSpan(ctx, { sentryTrace, baggage }) {
    const propagationContext = propagationContextFromHeaders(sentryTrace, baggage);
    const spanContext = generateSpanContextForPropagationContext(propagationContext);
    return trace.setSpanContext(ctx, spanContext);
  }
  function getExistingBaggage(carrier) {
    try {
      const baggage = carrier[SENTRY_BAGGAGE_HEADER];
      return Array.isArray(baggage) ? baggage.join(",") : baggage;
    } catch (e2) {
      return void 0;
    }
  }
  function getCurrentURL(span) {
    const spanData = spanToJSON(span).data;
    const urlAttribute = _optionalChain$6([spanData, "optionalAccess", (_14) => _14[SEMATTRS_HTTP_URL]]) || _optionalChain$6([spanData, "optionalAccess", (_15) => _15[ATTR_URL_FULL]]);
    if (urlAttribute) {
      return urlAttribute;
    }
    const urlTraceState = _optionalChain$6([span, "access", (_16) => _16.spanContext, "call", (_17) => _17(), "access", (_18) => _18.traceState, "optionalAccess", (_19) => _19.get, "call", (_20) => _20(SENTRY_TRACE_STATE_URL)]);
    if (urlTraceState) {
      return urlTraceState;
    }
    return void 0;
  }
  function generateSpanContextForPropagationContext(propagationContext) {
    const traceState = makeTraceState({
      parentSpanId: propagationContext.parentSpanId,
      dsc: propagationContext.dsc,
      sampled: propagationContext.sampled
    });
    const spanContext = {
      traceId: propagationContext.traceId,
      spanId: propagationContext.parentSpanId || "",
      isRemote: true,
      traceFlags: propagationContext.sampled ? TraceFlags.SAMPLED : TraceFlags.NONE,
      traceState
    };
    return spanContext;
  }
  function _optionalChain$5(ops) {
    let lastAccessLHS = void 0;
    let value = ops[0];
    let i2 = 1;
    while (i2 < ops.length) {
      const op = ops[i2];
      const fn = ops[i2 + 1];
      i2 += 2;
      if ((op === "optionalAccess" || op === "optionalCall") && value == null) {
        return void 0;
      }
      if (op === "access" || op === "optionalAccess") {
        lastAccessLHS = value;
        value = fn(value);
      } else if (op === "call" || op === "optionalCall") {
        value = fn((...args2) => value.call(lastAccessLHS, ...args2));
        lastAccessLHS = void 0;
      }
    }
    return value;
  }
  function startSpan(options, callback) {
    const tracer = getTracer();
    const { name: name2, parentSpan: customParentSpan } = options;
    const wrapper = getActiveSpanWrapper(customParentSpan);
    return wrapper(() => {
      const activeCtx = getContext(options.scope, options.forceTransaction);
      const shouldSkipSpan = options.onlyIfParent && !trace.getSpan(activeCtx);
      const ctx = shouldSkipSpan ? suppressTracing$1(activeCtx) : activeCtx;
      const spanOptions = getSpanOptions(options);
      return tracer.startActiveSpan(name2, spanOptions, ctx, (span) => {
        return handleCallbackErrors(
          () => callback(span),
          () => {
            if (spanToJSON(span).status === void 0) {
              span.setStatus({ code: SpanStatusCode.ERROR });
            }
          },
          () => span.end()
        );
      });
    });
  }
  function startSpanManual(options, callback) {
    const tracer = getTracer();
    const { name: name2, parentSpan: customParentSpan } = options;
    const wrapper = getActiveSpanWrapper(customParentSpan);
    return wrapper(() => {
      const activeCtx = getContext(options.scope, options.forceTransaction);
      const shouldSkipSpan = options.onlyIfParent && !trace.getSpan(activeCtx);
      const ctx = shouldSkipSpan ? suppressTracing$1(activeCtx) : activeCtx;
      const spanOptions = getSpanOptions(options);
      return tracer.startActiveSpan(name2, spanOptions, ctx, (span) => {
        return handleCallbackErrors(
          () => callback(span, () => span.end()),
          () => {
            if (spanToJSON(span).status === void 0) {
              span.setStatus({ code: SpanStatusCode.ERROR });
            }
          }
        );
      });
    });
  }
  function startInactiveSpan(options) {
    const tracer = getTracer();
    const { name: name2, parentSpan: customParentSpan } = options;
    const wrapper = getActiveSpanWrapper(customParentSpan);
    return wrapper(() => {
      const activeCtx = getContext(options.scope, options.forceTransaction);
      const shouldSkipSpan = options.onlyIfParent && !trace.getSpan(activeCtx);
      const ctx = shouldSkipSpan ? suppressTracing$1(activeCtx) : activeCtx;
      const spanOptions = getSpanOptions(options);
      const span = tracer.startSpan(name2, spanOptions, ctx);
      return span;
    });
  }
  function withActiveSpan(span, callback) {
    const newContextWithActiveSpan = span ? trace.setSpan(context.active(), span) : trace.deleteSpan(context.active());
    return context.with(newContextWithActiveSpan, () => callback(getCurrentScope()));
  }
  function getTracer() {
    const client = getClient();
    return client && client.tracer || trace.getTracer("@sentry/opentelemetry", SDK_VERSION$1);
  }
  function getSpanOptions(options) {
    const { startTime, attributes, kind, op } = options;
    const fixedStartTime = typeof startTime === "number" ? ensureTimestampInMilliseconds(startTime) : startTime;
    return {
      attributes: op ? {
        [SEMANTIC_ATTRIBUTE_SENTRY_OP]: op,
        ...attributes
      } : attributes,
      kind,
      startTime: fixedStartTime
    };
  }
  function ensureTimestampInMilliseconds(timestamp) {
    const isMs = timestamp < 9999999999;
    return isMs ? timestamp * 1e3 : timestamp;
  }
  function getContext(scope2, forceTransaction) {
    const ctx = getContextForScope(scope2);
    const actualScope = _optionalChain$5([getScopesFromContext, "call", (_2) => _2(ctx), "optionalAccess", (_2) => _2.scope]);
    const parentSpan = trace.getSpan(ctx);
    if (!parentSpan) {
      const client = getClient();
      if (actualScope && client) {
        const propagationContext = actualScope.getPropagationContext();
        const traceState2 = makeTraceState({
          parentSpanId: propagationContext.parentSpanId,
          // Not defined yet, we want to pick this up on-demand only
          dsc: void 0,
          sampled: propagationContext.sampled
        });
        const spanOptions2 = {
          traceId: propagationContext.traceId,
          // eslint-disable-next-line deprecation/deprecation
          spanId: propagationContext.parentSpanId || propagationContext.spanId,
          isRemote: true,
          traceFlags: propagationContext.sampled ? TraceFlags.SAMPLED : TraceFlags.NONE,
          traceState: traceState2
        };
        return trace.setSpanContext(ctx, spanOptions2);
      }
      return ctx;
    }
    if (!forceTransaction) {
      return ctx;
    }
    const ctxWithoutSpan = trace.deleteSpan(ctx);
    const { spanId, traceId } = parentSpan.spanContext();
    const sampled = getSamplingDecision(parentSpan.spanContext());
    const rootSpan = getRootSpan(parentSpan);
    const dsc = getDynamicSamplingContextFromSpan(rootSpan);
    const traceState = makeTraceState({
      dsc,
      parentSpanId: spanId !== INVALID_SPANID ? spanId : void 0,
      sampled
    });
    const spanOptions = {
      traceId,
      spanId,
      isRemote: true,
      traceFlags: sampled ? TraceFlags.SAMPLED : TraceFlags.NONE,
      traceState
    };
    const ctxWithSpanContext = trace.setSpanContext(ctxWithoutSpan, spanOptions);
    return ctxWithSpanContext;
  }
  function getContextForScope(scope2) {
    if (scope2) {
      const ctx = getContextFromScope(scope2);
      if (ctx) {
        return ctx;
      }
    }
    return context.active();
  }
  function getTraceContextForScope(client, scope2) {
    const ctx = getContextFromScope(scope2);
    const span = ctx && trace.getSpan(ctx);
    const traceContext = span ? spanToTraceContext(span) : getTraceContextFromScope(scope2);
    const dynamicSamplingContext = span ? getDynamicSamplingContextFromSpan(span) : getDynamicSamplingContextFromScope(client, scope2);
    return [dynamicSamplingContext, traceContext];
  }
  function getActiveSpanWrapper(parentSpan) {
    return parentSpan !== void 0 ? (callback) => {
      return withActiveSpan(parentSpan, callback);
    } : (callback) => callback();
  }
  function suppressTracing(callback) {
    const ctx = suppressTracing$1(context.active());
    return context.with(ctx, callback);
  }
  function getTraceData({ span } = {}) {
    let ctx = context.active();
    if (span) {
      const { scope: scope2 } = getCapturedScopesOnSpan(span);
      ctx = scope2 && getContextFromScope(scope2) || trace.setSpan(context.active(), span);
    }
    const { traceId, spanId, sampled, dynamicSamplingContext } = getInjectionData(ctx);
    return {
      "sentry-trace": generateSentryTraceHeader(traceId, spanId, sampled),
      baggage: dynamicSamplingContextToSentryBaggageHeader(dynamicSamplingContext)
    };
  }
  function setOpenTelemetryContextAsyncContextStrategy() {
    function getScopes() {
      const ctx = context.active();
      const scopes = getScopesFromContext(ctx);
      if (scopes) {
        return scopes;
      }
      return {
        scope: getDefaultCurrentScope(),
        isolationScope: getDefaultIsolationScope()
      };
    }
    function withScope2(callback) {
      const ctx = context.active();
      return context.with(ctx, () => {
        return callback(getCurrentScope2());
      });
    }
    function withSetScope2(scope2, callback) {
      const ctx = context.active();
      return context.with(ctx.setValue(SENTRY_FORK_SET_SCOPE_CONTEXT_KEY, scope2), () => {
        return callback(scope2);
      });
    }
    function withIsolationScope2(callback) {
      const ctx = context.active();
      return context.with(ctx.setValue(SENTRY_FORK_ISOLATION_SCOPE_CONTEXT_KEY, true), () => {
        return callback(getIsolationScope2());
      });
    }
    function withSetIsolationScope(isolationScope, callback) {
      const ctx = context.active();
      return context.with(ctx.setValue(SENTRY_FORK_SET_ISOLATION_SCOPE_CONTEXT_KEY, isolationScope), () => {
        return callback(getIsolationScope2());
      });
    }
    function getCurrentScope2() {
      return getScopes().scope;
    }
    function getIsolationScope2() {
      return getScopes().isolationScope;
    }
    setAsyncContextStrategy({
      withScope: withScope2,
      withSetScope: withSetScope2,
      withSetIsolationScope,
      withIsolationScope: withIsolationScope2,
      getCurrentScope: getCurrentScope2,
      getIsolationScope: getIsolationScope2,
      startSpan,
      startSpanManual,
      startInactiveSpan,
      getActiveSpan,
      suppressTracing,
      getTraceData,
      // The types here don't fully align, because our own `Span` type is narrower
      // than the OTEL one - but this is OK for here, as we now we'll only have OTEL spans passed around
      withActiveSpan
    });
  }
  function _optionalChain$3(ops) {
    let lastAccessLHS = void 0;
    let value = ops[0];
    let i2 = 1;
    while (i2 < ops.length) {
      const op = ops[i2];
      const fn = ops[i2 + 1];
      i2 += 2;
      if ((op === "optionalAccess" || op === "optionalCall") && value == null) {
        return void 0;
      }
      if (op === "access" || op === "optionalAccess") {
        lastAccessLHS = value;
        value = fn(value);
      } else if (op === "call" || op === "optionalCall") {
        value = fn((...args2) => value.call(lastAccessLHS, ...args2));
        lastAccessLHS = void 0;
      }
    }
    return value;
  }
  function wrapContextManagerClass(ContextManagerClass) {
    class SentryContextManager2 extends ContextManagerClass {
      constructor(...args2) {
        super(...args2);
        setIsSetup("SentryContextManager");
      }
      /**
       * Overwrite with() of the original AsyncLocalStorageContextManager
       * to ensure we also create new scopes per context.
       */
      with(context2, fn, thisArg, ...args2) {
        const currentScopes = getScopesFromContext(context2);
        const currentScope = _optionalChain$3([currentScopes, "optionalAccess", (_2) => _2.scope]) || getCurrentScope();
        const currentIsolationScope = _optionalChain$3([currentScopes, "optionalAccess", (_2) => _2.isolationScope]) || getIsolationScope();
        const shouldForkIsolationScope = context2.getValue(SENTRY_FORK_ISOLATION_SCOPE_CONTEXT_KEY) === true;
        const scope2 = context2.getValue(SENTRY_FORK_SET_SCOPE_CONTEXT_KEY);
        const isolationScope = context2.getValue(SENTRY_FORK_SET_ISOLATION_SCOPE_CONTEXT_KEY);
        const newCurrentScope = scope2 || currentScope.clone();
        const newIsolationScope = isolationScope || (shouldForkIsolationScope ? currentIsolationScope.clone() : currentIsolationScope);
        const scopes = { scope: newCurrentScope, isolationScope: newIsolationScope };
        const ctx1 = setScopesOnContext(context2, scopes);
        const ctx2 = ctx1.deleteValue(SENTRY_FORK_ISOLATION_SCOPE_CONTEXT_KEY).deleteValue(SENTRY_FORK_SET_SCOPE_CONTEXT_KEY).deleteValue(SENTRY_FORK_SET_ISOLATION_SCOPE_CONTEXT_KEY);
        setContextOnScope(newCurrentScope, ctx2);
        return super.with(ctx2, fn, thisArg, ...args2);
      }
    }
    return SentryContextManager2;
  }
  function groupSpansWithParents(spans) {
    const nodeMap = /* @__PURE__ */ new Map();
    for (const span of spans) {
      createOrUpdateSpanNodeAndRefs(nodeMap, span);
    }
    return Array.from(nodeMap, function([_id, spanNode]) {
      return spanNode;
    });
  }
  function getLocalParentId(span) {
    const parentIsRemote = span.attributes[SEMANTIC_ATTRIBUTE_SENTRY_PARENT_IS_REMOTE] === true;
    return !parentIsRemote ? span.parentSpanId : void 0;
  }
  function createOrUpdateSpanNodeAndRefs(nodeMap, span) {
    const id = span.spanContext().spanId;
    const parentId = getLocalParentId(span);
    if (!parentId) {
      createOrUpdateNode(nodeMap, { id, span, children: [] });
      return;
    }
    const parentNode = createOrGetParentNode(nodeMap, parentId);
    const node2 = createOrUpdateNode(nodeMap, { id, span, parentNode, children: [] });
    parentNode.children.push(node2);
  }
  function createOrGetParentNode(nodeMap, id) {
    const existing = nodeMap.get(id);
    if (existing) {
      return existing;
    }
    return createOrUpdateNode(nodeMap, { id, children: [] });
  }
  function createOrUpdateNode(nodeMap, spanNode) {
    const existing = nodeMap.get(spanNode.id);
    if (existing && existing.span) {
      return existing;
    }
    if (existing && !existing.span) {
      existing.span = spanNode.span;
      existing.parentNode = spanNode.parentNode;
      return existing;
    }
    nodeMap.set(spanNode.id, spanNode);
    return spanNode;
  }
  const canonicalGrpcErrorCodesMap = {
    "1": "cancelled",
    "2": "unknown_error",
    "3": "invalid_argument",
    "4": "deadline_exceeded",
    "5": "not_found",
    "6": "already_exists",
    "7": "permission_denied",
    "8": "resource_exhausted",
    "9": "failed_precondition",
    "10": "aborted",
    "11": "out_of_range",
    "12": "unimplemented",
    "13": "internal_error",
    "14": "unavailable",
    "15": "data_loss",
    "16": "unauthenticated"
  };
  const isStatusErrorMessageValid = (message2) => {
    return Object.values(canonicalGrpcErrorCodesMap).includes(message2);
  };
  function mapStatus(span) {
    const attributes = spanHasAttributes(span) ? span.attributes : {};
    const status = spanHasStatus(span) ? span.status : void 0;
    if (status) {
      if (status.code === SpanStatusCode.OK) {
        return { code: SPAN_STATUS_OK };
      } else if (status.code === SpanStatusCode.ERROR) {
        if (typeof status.message === "undefined") {
          const inferredStatus2 = inferStatusFromAttributes(attributes);
          if (inferredStatus2) {
            return inferredStatus2;
          }
        }
        if (status.message && isStatusErrorMessageValid(status.message)) {
          return { code: SPAN_STATUS_ERROR, message: status.message };
        } else {
          return { code: SPAN_STATUS_ERROR, message: "unknown_error" };
        }
      }
    }
    const inferredStatus = inferStatusFromAttributes(attributes);
    if (inferredStatus) {
      return inferredStatus;
    }
    if (status && status.code === SpanStatusCode.UNSET) {
      return { code: SPAN_STATUS_OK };
    } else {
      return { code: SPAN_STATUS_ERROR, message: "unknown_error" };
    }
  }
  function inferStatusFromAttributes(attributes) {
    const httpCodeAttribute = attributes[ATTR_HTTP_RESPONSE_STATUS_CODE] || attributes[SEMATTRS_HTTP_STATUS_CODE];
    const grpcCodeAttribute = attributes[SEMATTRS_RPC_GRPC_STATUS_CODE];
    const numberHttpCode = typeof httpCodeAttribute === "number" ? httpCodeAttribute : typeof httpCodeAttribute === "string" ? parseInt(httpCodeAttribute) : void 0;
    if (typeof numberHttpCode === "number") {
      return getSpanStatusFromHttpCode(numberHttpCode);
    }
    if (typeof grpcCodeAttribute === "string") {
      return { code: SPAN_STATUS_ERROR, message: canonicalGrpcErrorCodesMap[grpcCodeAttribute] || "unknown_error" };
    }
    return void 0;
  }
  function _optionalChain$2(ops) {
    let lastAccessLHS = void 0;
    let value = ops[0];
    let i2 = 1;
    while (i2 < ops.length) {
      const op = ops[i2];
      const fn = ops[i2 + 1];
      i2 += 2;
      if ((op === "optionalAccess" || op === "optionalCall") && value == null) {
        return void 0;
      }
      if (op === "access" || op === "optionalAccess") {
        lastAccessLHS = value;
        value = fn(value);
      } else if (op === "call" || op === "optionalCall") {
        value = fn((...args2) => value.call(lastAccessLHS, ...args2));
        lastAccessLHS = void 0;
      }
    }
    return value;
  }
  const MAX_SPAN_COUNT = 1e3;
  const DEFAULT_TIMEOUT = 300;
  class SentrySpanExporter {
    /*
     * A quick explanation on the buckets: We do bucketing of finished spans for efficiency. This span exporter is
     * accumulating spans until a root span is encountered and then it flushes all the spans that are descendants of that
     * root span. Because it is totally in the realm of possibilities that root spans are never finished, and we don't
     * want to accumulate spans indefinitely in memory, we need to periodically evacuate spans. Naively we could simply
     * store the spans in an array and each time a new span comes in we could iterate through the entire array and
     * evacuate all spans that have an end-timestamp that is older than our limit. This could get quite expensive because
     * we would have to iterate a potentially large number of spans every time we evacuate. We want to avoid these large
     * bursts of computation.
     *
     * Instead we go for a bucketing approach and put spans into buckets, based on what second
     * (modulo the time limit) the span was put into the exporter. With buckets, when we decide to evacuate, we can
     * iterate through the bucket entries instead, which have an upper bound of items, making the evacuation much more
     * efficient. Cleaning up also becomes much more efficient since it simply involves de-referencing a bucket within the
     * bucket array, and letting garbage collection take care of the rest.
     */
    constructor(options) {
      this._finishedSpanBucketSize = _optionalChain$2([options, "optionalAccess", (_2) => _2.timeout]) || DEFAULT_TIMEOUT;
      this._finishedSpanBuckets = new Array(this._finishedSpanBucketSize).fill(void 0);
      this._lastCleanupTimestampInS = Math.floor(Date.now() / 1e3);
      this._spansToBucketEntry = /* @__PURE__ */ new WeakMap();
    }
    /** Export a single span. */
    export(span) {
      const currentTimestampInS = Math.floor(Date.now() / 1e3);
      if (this._lastCleanupTimestampInS !== currentTimestampInS) {
        let droppedSpanCount = 0;
        this._finishedSpanBuckets.forEach((bucket, i2) => {
          if (bucket && bucket.timestampInS <= currentTimestampInS - this._finishedSpanBucketSize) {
            droppedSpanCount += bucket.spans.size;
            this._finishedSpanBuckets[i2] = void 0;
          }
        });
        if (droppedSpanCount > 0) {
          DEBUG_BUILD$1 && logger$2.log(
            `SpanExporter dropped ${droppedSpanCount} spans because they were pending for more than ${this._finishedSpanBucketSize} seconds.`
          );
        }
        this._lastCleanupTimestampInS = currentTimestampInS;
      }
      const currentBucketIndex = currentTimestampInS % this._finishedSpanBucketSize;
      const currentBucket = this._finishedSpanBuckets[currentBucketIndex] || {
        timestampInS: currentTimestampInS,
        spans: /* @__PURE__ */ new Set()
      };
      this._finishedSpanBuckets[currentBucketIndex] = currentBucket;
      currentBucket.spans.add(span);
      this._spansToBucketEntry.set(span, currentBucket);
      if (!getLocalParentId(span)) {
        this._clearTimeout();
        this._flushTimeout = setTimeout(() => {
          this.flush();
        }, 1);
      }
    }
    /** Try to flush any pending spans immediately. */
    flush() {
      this._clearTimeout();
      const finishedSpans = [];
      this._finishedSpanBuckets.forEach((bucket) => {
        if (bucket) {
          finishedSpans.push(...bucket.spans);
        }
      });
      const sentSpans = maybeSend(finishedSpans);
      const sentSpanCount = sentSpans.size;
      const remainingOpenSpanCount = finishedSpans.length - sentSpanCount;
      DEBUG_BUILD$1 && logger$2.log(`SpanExporter exported ${sentSpanCount} spans, ${remainingOpenSpanCount} unsent spans remaining`);
      sentSpans.forEach((span) => {
        const bucketEntry = this._spansToBucketEntry.get(span);
        if (bucketEntry) {
          bucketEntry.spans.delete(span);
        }
      });
    }
    /** Clear the exporter. */
    clear() {
      this._finishedSpanBuckets = this._finishedSpanBuckets.fill(void 0);
      this._clearTimeout();
    }
    /** Clear the flush timeout. */
    _clearTimeout() {
      if (this._flushTimeout) {
        clearTimeout(this._flushTimeout);
        this._flushTimeout = void 0;
      }
    }
  }
  function maybeSend(spans) {
    const grouped = groupSpansWithParents(spans);
    const sentSpans = /* @__PURE__ */ new Set();
    const rootNodes = getCompletedRootNodes(grouped);
    rootNodes.forEach((root2) => {
      const span = root2.span;
      sentSpans.add(span);
      const transactionEvent = createTransactionForOtelSpan(span);
      const spans2 = transactionEvent.spans || [];
      root2.children.forEach((child) => {
        createAndFinishSpanForOtelSpan(child, spans2, sentSpans);
      });
      transactionEvent.spans = spans2.length > MAX_SPAN_COUNT ? spans2.sort((a2, b2) => a2.start_timestamp - b2.start_timestamp).slice(0, MAX_SPAN_COUNT) : spans2;
      const measurements = timedEventsToMeasurements(span.events);
      if (measurements) {
        transactionEvent.measurements = measurements;
      }
      captureEvent(transactionEvent);
    });
    return sentSpans;
  }
  function nodeIsCompletedRootNode(node2) {
    return !!node2.span && !node2.parentNode;
  }
  function getCompletedRootNodes(nodes) {
    return nodes.filter(nodeIsCompletedRootNode);
  }
  function parseSpan(span) {
    const attributes = span.attributes;
    const origin = attributes[SEMANTIC_ATTRIBUTE_SENTRY_ORIGIN];
    const op = attributes[SEMANTIC_ATTRIBUTE_SENTRY_OP];
    const source = attributes[SEMANTIC_ATTRIBUTE_SENTRY_SOURCE];
    return { origin, op, source };
  }
  function createTransactionForOtelSpan(span) {
    const { op, description: description2, data: data2, origin = "manual", source } = getSpanData(span);
    const capturedSpanScopes = getCapturedScopesOnSpan(span);
    const sampleRate = span.attributes[SEMANTIC_ATTRIBUTE_SENTRY_SAMPLE_RATE];
    const attributes = dropUndefinedKeys({
      [SEMANTIC_ATTRIBUTE_SENTRY_SOURCE]: source,
      [SEMANTIC_ATTRIBUTE_SENTRY_SAMPLE_RATE]: sampleRate,
      [SEMANTIC_ATTRIBUTE_SENTRY_OP]: op,
      [SEMANTIC_ATTRIBUTE_SENTRY_ORIGIN]: origin,
      ...data2,
      ...removeSentryAttributes(span.attributes)
    });
    const { traceId: trace_id, spanId: span_id } = span.spanContext();
    const parentSpanIdFromTraceState = _optionalChain$2([span, "access", (_2) => _2.spanContext, "call", (_3) => _3(), "access", (_4) => _4.traceState, "optionalAccess", (_5) => _5.get, "call", (_6) => _6(SENTRY_TRACE_STATE_PARENT_SPAN_ID)]);
    const parent_span_id = typeof parentSpanIdFromTraceState === "string" ? parentSpanIdFromTraceState || void 0 : span.parentSpanId;
    const status = mapStatus(span);
    const traceContext = dropUndefinedKeys({
      parent_span_id,
      span_id,
      trace_id,
      data: attributes,
      origin,
      op,
      status: getStatusMessage(status)
      // As per protocol, span status is allowed to be undefined
    });
    const transactionEvent = {
      contexts: {
        trace: traceContext,
        otel: {
          resource: span.resource.attributes
        }
      },
      spans: [],
      start_timestamp: spanTimeInputToSeconds(span.startTime),
      timestamp: spanTimeInputToSeconds(span.endTime),
      transaction: description2,
      type: "transaction",
      sdkProcessingMetadata: {
        ...dropUndefinedKeys({
          capturedSpanScope: capturedSpanScopes.scope,
          capturedSpanIsolationScope: capturedSpanScopes.isolationScope,
          sampleRate,
          dynamicSamplingContext: getDynamicSamplingContextFromSpan(span)
        })
      },
      ...source && {
        transaction_info: {
          source
        }
      },
      _metrics_summary: getMetricSummaryJsonForSpan(span)
    };
    return transactionEvent;
  }
  function createAndFinishSpanForOtelSpan(node2, spans, sentSpans) {
    const span = node2.span;
    if (span) {
      sentSpans.add(span);
    }
    const shouldDrop = !span;
    if (shouldDrop) {
      node2.children.forEach((child) => {
        createAndFinishSpanForOtelSpan(child, spans, sentSpans);
      });
      return;
    }
    const span_id = span.spanContext().spanId;
    const trace_id = span.spanContext().traceId;
    const { attributes, startTime, endTime, parentSpanId } = span;
    const { op, description: description2, data: data2, origin = "manual" } = getSpanData(span);
    const allData = dropUndefinedKeys({
      [SEMANTIC_ATTRIBUTE_SENTRY_ORIGIN]: origin,
      [SEMANTIC_ATTRIBUTE_SENTRY_OP]: op,
      ...removeSentryAttributes(attributes),
      ...data2
    });
    const status = mapStatus(span);
    const spanJSON = dropUndefinedKeys({
      span_id,
      trace_id,
      data: allData,
      description: description2,
      parent_span_id: parentSpanId,
      start_timestamp: spanTimeInputToSeconds(startTime),
      // This is [0,0] by default in OTEL, in which case we want to interpret this as no end time
      timestamp: spanTimeInputToSeconds(endTime) || void 0,
      status: getStatusMessage(status),
      // As per protocol, span status is allowed to be undefined
      op,
      origin,
      _metrics_summary: getMetricSummaryJsonForSpan(span),
      measurements: timedEventsToMeasurements(span.events)
    });
    spans.push(spanJSON);
    node2.children.forEach((child) => {
      createAndFinishSpanForOtelSpan(child, spans, sentSpans);
    });
  }
  function getSpanData(span) {
    const { op: definedOp, source: definedSource, origin } = parseSpan(span);
    const { op: inferredOp, description: description2, source: inferredSource, data: inferredData } = parseSpanDescription(span);
    const op = definedOp || inferredOp;
    const source = definedSource || inferredSource;
    const data2 = { ...inferredData, ...getData(span) };
    return {
      op,
      description: description2,
      source,
      origin,
      data: data2
    };
  }
  function removeSentryAttributes(data2) {
    const cleanedData = { ...data2 };
    delete cleanedData[SEMANTIC_ATTRIBUTE_SENTRY_SAMPLE_RATE];
    delete cleanedData[SEMANTIC_ATTRIBUTE_SENTRY_PARENT_IS_REMOTE];
    return cleanedData;
  }
  function getData(span) {
    const attributes = span.attributes;
    const data2 = {};
    if (span.kind !== SpanKind.INTERNAL) {
      data2["otel.kind"] = SpanKind[span.kind];
    }
    const maybeHttpStatusCodeAttribute = attributes[SEMATTRS_HTTP_STATUS_CODE];
    if (maybeHttpStatusCodeAttribute) {
      data2[ATTR_HTTP_RESPONSE_STATUS_CODE] = maybeHttpStatusCodeAttribute;
    }
    const requestData = getRequestSpanData(span);
    if (requestData.url) {
      data2.url = requestData.url;
    }
    if (requestData["http.query"]) {
      data2["http.query"] = requestData["http.query"].slice(1);
    }
    if (requestData["http.fragment"]) {
      data2["http.fragment"] = requestData["http.fragment"].slice(1);
    }
    return data2;
  }
  function _optionalChain$1(ops) {
    let lastAccessLHS = void 0;
    let value = ops[0];
    let i2 = 1;
    while (i2 < ops.length) {
      const op = ops[i2];
      const fn = ops[i2 + 1];
      i2 += 2;
      if ((op === "optionalAccess" || op === "optionalCall") && value == null) {
        return void 0;
      }
      if (op === "access" || op === "optionalAccess") {
        lastAccessLHS = value;
        value = fn(value);
      } else if (op === "call" || op === "optionalCall") {
        value = fn((...args2) => value.call(lastAccessLHS, ...args2));
        lastAccessLHS = void 0;
      }
    }
    return value;
  }
  function onSpanStart(span, parentContext) {
    const parentSpan = trace.getSpan(parentContext);
    let scopes = getScopesFromContext(parentContext);
    if (parentSpan && !parentSpan.spanContext().isRemote) {
      addChildSpanToSpan(parentSpan, span);
    }
    if (parentSpan && parentSpan.spanContext().isRemote) {
      span.setAttribute(SEMANTIC_ATTRIBUTE_SENTRY_PARENT_IS_REMOTE, true);
    }
    if (parentContext === ROOT_CONTEXT) {
      scopes = {
        scope: getDefaultCurrentScope(),
        isolationScope: getDefaultIsolationScope()
      };
    }
    if (scopes) {
      setCapturedScopesOnSpan(span, scopes.scope, scopes.isolationScope);
    }
    logSpanStart(span);
    const client = getClient();
    _optionalChain$1([client, "optionalAccess", (_2) => _2.emit, "call", (_2) => _2("spanStart", span)]);
  }
  function onSpanEnd(span) {
    logSpanEnd(span);
    const client = getClient();
    _optionalChain$1([client, "optionalAccess", (_3) => _3.emit, "call", (_4) => _4("spanEnd", span)]);
  }
  class SentrySpanProcessor {
    constructor(options) {
      setIsSetup("SentrySpanProcessor");
      this._exporter = new SentrySpanExporter(options);
    }
    /**
     * @inheritDoc
     */
    async forceFlush() {
      this._exporter.flush();
    }
    /**
     * @inheritDoc
     */
    async shutdown() {
      this._exporter.clear();
    }
    /**
     * @inheritDoc
     */
    onStart(span, parentContext) {
      onSpanStart(span, parentContext);
    }
    /** @inheritDoc */
    onEnd(span) {
      onSpanEnd(span);
      this._exporter.export(span);
    }
  }
  class SentrySampler {
    constructor(client) {
      this._client = client;
      setIsSetup("SentrySampler");
    }
    /** @inheritDoc */
    shouldSample(context2, traceId, spanName, spanKind, spanAttributes, _links) {
      const options = this._client.getOptions();
      const parentSpan = getValidSpan(context2);
      const parentContext = _optionalChain([parentSpan, "optionalAccess", (_2) => _2.spanContext, "call", (_2) => _2()]);
      if (!hasTracingEnabled(options)) {
        return wrapSamplingDecision({ decision: void 0, context: context2, spanAttributes });
      }
      const maybeSpanHttpMethod = spanAttributes[SEMATTRS_HTTP_METHOD] || spanAttributes[ATTR_HTTP_REQUEST_METHOD];
      if (spanKind === SpanKind.CLIENT && maybeSpanHttpMethod && (!parentSpan || _optionalChain([parentContext, "optionalAccess", (_3) => _3.isRemote]))) {
        return wrapSamplingDecision({ decision: void 0, context: context2, spanAttributes });
      }
      const parentSampled = parentSpan ? getParentSampled(parentSpan, traceId, spanName) : void 0;
      const {
        description: inferredSpanName,
        data: inferredAttributes,
        op
      } = inferSpanData(spanName, spanAttributes, spanKind);
      const mergedAttributes = {
        ...inferredAttributes,
        ...spanAttributes
      };
      if (op) {
        mergedAttributes[SEMANTIC_ATTRIBUTE_SENTRY_OP] = op;
      }
      const mutableSamplingDecision = { decision: true };
      this._client.emit(
        "beforeSampling",
        {
          spanAttributes: mergedAttributes,
          spanName: inferredSpanName,
          parentSampled,
          parentContext
        },
        mutableSamplingDecision
      );
      if (!mutableSamplingDecision.decision) {
        return wrapSamplingDecision({ decision: void 0, context: context2, spanAttributes });
      }
      const [sampled, sampleRate] = sampleSpan(options, {
        name: inferredSpanName,
        attributes: mergedAttributes,
        transactionContext: {
          name: inferredSpanName,
          parentSampled
        },
        parentSampled
      });
      const attributes = {
        [SEMANTIC_ATTRIBUTE_SENTRY_SAMPLE_RATE]: sampleRate
      };
      const method2 = `${maybeSpanHttpMethod}`.toUpperCase();
      if (method2 === "OPTIONS" || method2 === "HEAD") {
        DEBUG_BUILD$1 && logger$2.log(`[Tracing] Not sampling span because HTTP method is '${method2}' for ${spanName}`);
        return {
          ...wrapSamplingDecision({ decision: SamplingDecision.NOT_RECORD, context: context2, spanAttributes }),
          attributes
        };
      }
      if (!sampled) {
        return {
          ...wrapSamplingDecision({ decision: SamplingDecision.NOT_RECORD, context: context2, spanAttributes }),
          attributes
        };
      }
      return {
        ...wrapSamplingDecision({ decision: SamplingDecision.RECORD_AND_SAMPLED, context: context2, spanAttributes }),
        attributes
      };
    }
    /** Returns the sampler name or short description with the configuration. */
    toString() {
      return "SentrySampler";
    }
  }
  function getParentRemoteSampled(parentSpan) {
    const traceId = parentSpan.spanContext().traceId;
    const traceparentData = getPropagationContextFromSpan(parentSpan);
    return traceparentData && traceId === traceparentData.traceId ? traceparentData.sampled : void 0;
  }
  function getParentSampled(parentSpan, traceId, spanName) {
    const parentContext = parentSpan.spanContext();
    if (isSpanContextValid(parentContext) && parentContext.traceId === traceId) {
      if (parentContext.isRemote) {
        const parentSampled2 = getParentRemoteSampled(parentSpan);
        DEBUG_BUILD$1 && logger$2.log(`[Tracing] Inheriting remote parent's sampled decision for ${spanName}: ${parentSampled2}`);
        return parentSampled2;
      }
      const parentSampled = getSamplingDecision(parentContext);
      DEBUG_BUILD$1 && logger$2.log(`[Tracing] Inheriting parent's sampled decision for ${spanName}: ${parentSampled}`);
      return parentSampled;
    }
    return void 0;
  }
  function wrapSamplingDecision({
    decision,
    context: context2,
    spanAttributes
  }) {
    const traceState = getBaseTraceState(context2, spanAttributes);
    if (decision == void 0) {
      return { decision: SamplingDecision.NOT_RECORD, traceState };
    }
    if (decision === SamplingDecision.NOT_RECORD) {
      return { decision, traceState: traceState.set(SENTRY_TRACE_STATE_SAMPLED_NOT_RECORDING, "1") };
    }
    return { decision, traceState };
  }
  function getBaseTraceState(context2, spanAttributes) {
    const parentSpan = trace.getSpan(context2);
    const parentContext = _optionalChain([parentSpan, "optionalAccess", (_4) => _4.spanContext, "call", (_5) => _5()]);
    let traceState = _optionalChain([parentContext, "optionalAccess", (_6) => _6.traceState]) || new TraceState();
    const url2 = spanAttributes[SEMATTRS_HTTP_URL] || spanAttributes[ATTR_URL_FULL];
    if (url2 && typeof url2 === "string") {
      traceState = traceState.set(SENTRY_TRACE_STATE_URL, url2);
    }
    return traceState;
  }
  function getValidSpan(context2) {
    const span = trace.getSpan(context2);
    return span && isSpanContextValid(span.spanContext()) ? span : void 0;
  }
  const DEBUG_BUILD = typeof __SENTRY_DEBUG__ === "undefined" || __SENTRY_DEBUG__;
  var src$3 = {};
  var undici = {};
  var NoopLogger = (
    /** @class */
    function() {
      function NoopLogger2() {
      }
      NoopLogger2.prototype.emit = function(_logRecord) {
      };
      return NoopLogger2;
    }()
  );
  var NoopLoggerProvider = (
    /** @class */
    function() {
      function NoopLoggerProvider2() {
      }
      NoopLoggerProvider2.prototype.getLogger = function(_name, _version, _options) {
        return new NoopLogger();
      };
      return NoopLoggerProvider2;
    }()
  );
  var NOOP_LOGGER_PROVIDER = new NoopLoggerProvider();
  var _globalThis = typeof globalThis === "object" ? globalThis : global;
  var GLOBAL_LOGS_API_KEY = Symbol.for("io.opentelemetry.js.api.logs");
  var _global = _globalThis;
  function makeGetter(requiredVersion, instance, fallback) {
    return function(version2) {
      return version2 === requiredVersion ? instance : fallback;
    };
  }
  var API_BACKWARDS_COMPATIBILITY_VERSION = 1;
  var LogsAPI = (
    /** @class */
    function() {
      function LogsAPI2() {
      }
      LogsAPI2.getInstance = function() {
        if (!this._instance) {
          this._instance = new LogsAPI2();
        }
        return this._instance;
      };
      LogsAPI2.prototype.setGlobalLoggerProvider = function(provider) {
        if (_global[GLOBAL_LOGS_API_KEY]) {
          return this.getLoggerProvider();
        }
        _global[GLOBAL_LOGS_API_KEY] = makeGetter(API_BACKWARDS_COMPATIBILITY_VERSION, provider, NOOP_LOGGER_PROVIDER);
        return provider;
      };
      LogsAPI2.prototype.getLoggerProvider = function() {
        var _a3, _b2;
        return (_b2 = (_a3 = _global[GLOBAL_LOGS_API_KEY]) === null || _a3 === void 0 ? void 0 : _a3.call(_global, API_BACKWARDS_COMPATIBILITY_VERSION)) !== null && _b2 !== void 0 ? _b2 : NOOP_LOGGER_PROVIDER;
      };
      LogsAPI2.prototype.getLogger = function(name2, version2, options) {
        return this.getLoggerProvider().getLogger(name2, version2, options);
      };
      LogsAPI2.prototype.disable = function() {
        delete _global[GLOBAL_LOGS_API_KEY];
      };
      return LogsAPI2;
    }()
  );
  var logs = LogsAPI.getInstance();
  function enableInstrumentations(instrumentations, tracerProvider, meterProvider, loggerProvider) {
    for (var i2 = 0, j2 = instrumentations.length; i2 < j2; i2++) {
      var instrumentation = instrumentations[i2];
      if (tracerProvider) {
        instrumentation.setTracerProvider(tracerProvider);
      }
      if (meterProvider) {
        instrumentation.setMeterProvider(meterProvider);
      }
      if (loggerProvider && instrumentation.setLoggerProvider) {
        instrumentation.setLoggerProvider(loggerProvider);
      }
      if (!instrumentation.getConfig().enabled) {
        instrumentation.enable();
      }
    }
  }
  function disableInstrumentations(instrumentations) {
    instrumentations.forEach(function(instrumentation) {
      return instrumentation.disable();
    });
  }
  function registerInstrumentations(options) {
    var _a3, _b2;
    var tracerProvider = options.tracerProvider || trace.getTracerProvider();
    var meterProvider = options.meterProvider || metrics.getMeterProvider();
    var loggerProvider = options.loggerProvider || logs.getLoggerProvider();
    var instrumentations = (_b2 = (_a3 = options.instrumentations) === null || _a3 === void 0 ? void 0 : _a3.flat()) !== null && _b2 !== void 0 ? _b2 : [];
    enableInstrumentations(instrumentations, tracerProvider, meterProvider, loggerProvider);
    return function() {
      disableInstrumentations(instrumentations);
    };
  }
  var __assign = function() {
    __assign = Object.assign || function(t2) {
      for (var s2, i2 = 1, n2 = arguments.length; i2 < n2; i2++) {
        s2 = arguments[i2];
        for (var p2 in s2) if (Object.prototype.hasOwnProperty.call(s2, p2))
          t2[p2] = s2[p2];
      }
      return t2;
    };
    return __assign.apply(this, arguments);
  };
  var InstrumentationAbstract = (
    /** @class */
    function() {
      function InstrumentationAbstract2(instrumentationName, instrumentationVersion, config2) {
        this.instrumentationName = instrumentationName;
        this.instrumentationVersion = instrumentationVersion;
        this._config = {};
        this._wrap = shimmer_1.wrap;
        this._unwrap = shimmer_1.unwrap;
        this._massWrap = shimmer_1.massWrap;
        this._massUnwrap = shimmer_1.massUnwrap;
        this.setConfig(config2);
        this._diag = diag.createComponentLogger({
          namespace: instrumentationName
        });
        this._tracer = trace.getTracer(instrumentationName, instrumentationVersion);
        this._meter = metrics.getMeter(instrumentationName, instrumentationVersion);
        this._logger = logs.getLogger(instrumentationName, instrumentationVersion);
        this._updateMetricInstruments();
      }
      Object.defineProperty(InstrumentationAbstract2.prototype, "meter", {
        /* Returns meter */
        get: function() {
          return this._meter;
        },
        enumerable: false,
        configurable: true
      });
      InstrumentationAbstract2.prototype.setMeterProvider = function(meterProvider) {
        this._meter = meterProvider.getMeter(this.instrumentationName, this.instrumentationVersion);
        this._updateMetricInstruments();
      };
      Object.defineProperty(InstrumentationAbstract2.prototype, "logger", {
        /* Returns logger */
        get: function() {
          return this._logger;
        },
        enumerable: false,
        configurable: true
      });
      InstrumentationAbstract2.prototype.setLoggerProvider = function(loggerProvider) {
        this._logger = loggerProvider.getLogger(this.instrumentationName, this.instrumentationVersion);
      };
      InstrumentationAbstract2.prototype.getModuleDefinitions = function() {
        var _a3;
        var initResult = (_a3 = this.init()) !== null && _a3 !== void 0 ? _a3 : [];
        if (!Array.isArray(initResult)) {
          return [initResult];
        }
        return initResult;
      };
      InstrumentationAbstract2.prototype._updateMetricInstruments = function() {
        return;
      };
      InstrumentationAbstract2.prototype.getConfig = function() {
        return this._config;
      };
      InstrumentationAbstract2.prototype.setConfig = function(config2) {
        this._config = __assign({ enabled: true }, config2);
      };
      InstrumentationAbstract2.prototype.setTracerProvider = function(tracerProvider) {
        this._tracer = tracerProvider.getTracer(this.instrumentationName, this.instrumentationVersion);
      };
      Object.defineProperty(InstrumentationAbstract2.prototype, "tracer", {
        /* Returns tracer */
        get: function() {
          return this._tracer;
        },
        enumerable: false,
        configurable: true
      });
      InstrumentationAbstract2.prototype._runSpanCustomizationHook = function(hookHandler, triggerName, span, info2) {
        if (!hookHandler) {
          return;
        }
        try {
          hookHandler(span, info2);
        } catch (e2) {
          this._diag.error("Error running span customization hook due to exception in handler", { triggerName }, e2);
        }
      };
      return InstrumentationAbstract2;
    }()
  );
  var __values$2 = function(o2) {
    var s2 = typeof Symbol === "function" && Symbol.iterator, m2 = s2 && o2[s2], i2 = 0;
    if (m2) return m2.call(o2);
    if (o2 && typeof o2.length === "number") return {
      next: function() {
        if (o2 && i2 >= o2.length) o2 = void 0;
        return { value: o2 && o2[i2++], done: !o2 };
      }
    };
    throw new TypeError(s2 ? "Object is not iterable." : "Symbol.iterator is not defined.");
  };
  var __read = function(o2, n2) {
    var m2 = typeof Symbol === "function" && o2[Symbol.iterator];
    if (!m2) return o2;
    var i2 = m2.call(o2), r2, ar = [], e2;
    try {
      while ((n2 === void 0 || n2-- > 0) && !(r2 = i2.next()).done) ar.push(r2.value);
    } catch (error2) {
      e2 = { error: error2 };
    } finally {
      try {
        if (r2 && !r2.done && (m2 = i2["return"])) m2.call(i2);
      } finally {
        if (e2) throw e2.error;
      }
    }
    return ar;
  };
  var __spreadArray = function(to, from, pack) {
    if (pack || arguments.length === 2) for (var i2 = 0, l2 = from.length, ar; i2 < l2; i2++) {
      if (ar || !(i2 in from)) {
        if (!ar) ar = Array.prototype.slice.call(from, 0, i2);
        ar[i2] = from[i2];
      }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
  };
  var ModuleNameSeparator = "/";
  var ModuleNameTrieNode = (
    /** @class */
    /* @__PURE__ */ function() {
      function ModuleNameTrieNode2() {
        this.hooks = [];
        this.children = /* @__PURE__ */ new Map();
      }
      return ModuleNameTrieNode2;
    }()
  );
  var ModuleNameTrie = (
    /** @class */
    function() {
      function ModuleNameTrie2() {
        this._trie = new ModuleNameTrieNode();
        this._counter = 0;
      }
      ModuleNameTrie2.prototype.insert = function(hook) {
        var e_1, _a3;
        var trieNode = this._trie;
        try {
          for (var _b2 = __values$2(hook.moduleName.split(ModuleNameSeparator)), _c2 = _b2.next(); !_c2.done; _c2 = _b2.next()) {
            var moduleNamePart = _c2.value;
            var nextNode = trieNode.children.get(moduleNamePart);
            if (!nextNode) {
              nextNode = new ModuleNameTrieNode();
              trieNode.children.set(moduleNamePart, nextNode);
            }
            trieNode = nextNode;
          }
        } catch (e_1_1) {
          e_1 = { error: e_1_1 };
        } finally {
          try {
            if (_c2 && !_c2.done && (_a3 = _b2.return)) _a3.call(_b2);
          } finally {
            if (e_1) throw e_1.error;
          }
        }
        trieNode.hooks.push({ hook, insertedId: this._counter++ });
      };
      ModuleNameTrie2.prototype.search = function(moduleName2, _a3) {
        var e_2, _b2;
        var _c2 = _a3 === void 0 ? {} : _a3, maintainInsertionOrder = _c2.maintainInsertionOrder, fullOnly = _c2.fullOnly;
        var trieNode = this._trie;
        var results = [];
        var foundFull = true;
        try {
          for (var _d = __values$2(moduleName2.split(ModuleNameSeparator)), _e2 = _d.next(); !_e2.done; _e2 = _d.next()) {
            var moduleNamePart = _e2.value;
            var nextNode = trieNode.children.get(moduleNamePart);
            if (!nextNode) {
              foundFull = false;
              break;
            }
            if (!fullOnly) {
              results.push.apply(results, __spreadArray([], __read(nextNode.hooks), false));
            }
            trieNode = nextNode;
          }
        } catch (e_2_1) {
          e_2 = { error: e_2_1 };
        } finally {
          try {
            if (_e2 && !_e2.done && (_b2 = _d.return)) _b2.call(_d);
          } finally {
            if (e_2) throw e_2.error;
          }
        }
        if (fullOnly && foundFull) {
          results.push.apply(results, __spreadArray([], __read(trieNode.hooks), false));
        }
        if (results.length === 0) {
          return [];
        }
        if (results.length === 1) {
          return [results[0].hook];
        }
        if (maintainInsertionOrder) {
          results.sort(function(a2, b2) {
            return a2.insertedId - b2.insertedId;
          });
        }
        return results.map(function(_a4) {
          var hook = _a4.hook;
          return hook;
        });
      };
      return ModuleNameTrie2;
    }()
  );
  var __values$1 = function(o2) {
    var s2 = typeof Symbol === "function" && Symbol.iterator, m2 = s2 && o2[s2], i2 = 0;
    if (m2) return m2.call(o2);
    if (o2 && typeof o2.length === "number") return {
      next: function() {
        if (o2 && i2 >= o2.length) o2 = void 0;
        return { value: o2 && o2[i2++], done: !o2 };
      }
    };
    throw new TypeError(s2 ? "Object is not iterable." : "Symbol.iterator is not defined.");
  };
  var isMocha = [
    "afterEach",
    "after",
    "beforeEach",
    "before",
    "describe",
    "it"
  ].every(function(fn) {
    return typeof global[fn] === "function";
  });
  var RequireInTheMiddleSingleton = (
    /** @class */
    function() {
      function RequireInTheMiddleSingleton2() {
        this._moduleNameTrie = new ModuleNameTrie();
        this._initialize();
      }
      RequireInTheMiddleSingleton2.prototype._initialize = function() {
        var _this = this;
        new Hook_1$1(
          // Intercept all `require` calls; we will filter the matching ones below
          null,
          { internals: true },
          function(exports2, name2, basedir) {
            var e_1, _a3;
            var normalizedModuleName = normalizePathSeparators(name2);
            var matches = _this._moduleNameTrie.search(normalizedModuleName, {
              maintainInsertionOrder: true,
              // For core modules (e.g. `fs`), do not match on sub-paths (e.g. `fs/promises').
              // This matches the behavior of `require-in-the-middle`.
              // `basedir` is always `undefined` for core modules.
              fullOnly: basedir === void 0
            });
            try {
              for (var matches_1 = __values$1(matches), matches_1_1 = matches_1.next(); !matches_1_1.done; matches_1_1 = matches_1.next()) {
                var onRequire = matches_1_1.value.onRequire;
                exports2 = onRequire(exports2, name2, basedir);
              }
            } catch (e_1_1) {
              e_1 = { error: e_1_1 };
            } finally {
              try {
                if (matches_1_1 && !matches_1_1.done && (_a3 = matches_1.return)) _a3.call(matches_1);
              } finally {
                if (e_1) throw e_1.error;
              }
            }
            return exports2;
          }
        );
      };
      RequireInTheMiddleSingleton2.prototype.register = function(moduleName2, onRequire) {
        var hooked = { moduleName: moduleName2, onRequire };
        this._moduleNameTrie.insert(hooked);
        return hooked;
      };
      RequireInTheMiddleSingleton2.getInstance = function() {
        var _a3;
        if (isMocha)
          return new RequireInTheMiddleSingleton2();
        return this._instance = (_a3 = this._instance) !== null && _a3 !== void 0 ? _a3 : new RequireInTheMiddleSingleton2();
      };
      return RequireInTheMiddleSingleton2;
    }()
  );
  function normalizePathSeparators(moduleNameOrPath) {
    return path__namespace.sep !== ModuleNameSeparator ? moduleNameOrPath.split(path__namespace.sep).join(ModuleNameSeparator) : moduleNameOrPath;
  }
  var __awaiter = function(thisArg, _arguments, P2, generator) {
    function adopt(value) {
      return value instanceof P2 ? value : new P2(function(resolve2) {
        resolve2(value);
      });
    }
    return new (P2 || (P2 = Promise))(function(resolve2, reject) {
      function fulfilled(value) {
        try {
          step(generator.next(value));
        } catch (e2) {
          reject(e2);
        }
      }
      function rejected(value) {
        try {
          step(generator["throw"](value));
        } catch (e2) {
          reject(e2);
        }
      }
      function step(result) {
        result.done ? resolve2(result.value) : adopt(result.value).then(fulfilled, rejected);
      }
      step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
  };
  var __generator = function(thisArg, body) {
    var _2 = { label: 0, sent: function() {
      if (t2[0] & 1) throw t2[1];
      return t2[1];
    }, trys: [], ops: [] }, f2, y2, t2, g2;
    return g2 = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g2[Symbol.iterator] = function() {
      return this;
    }), g2;
    function verb(n2) {
      return function(v2) {
        return step([n2, v2]);
      };
    }
    function step(op) {
      if (f2) throw new TypeError("Generator is already executing.");
      while (_2) try {
        if (f2 = 1, y2 && (t2 = op[0] & 2 ? y2["return"] : op[0] ? y2["throw"] || ((t2 = y2["return"]) && t2.call(y2), 0) : y2.next) && !(t2 = t2.call(y2, op[1])).done) return t2;
        if (y2 = 0, t2) op = [op[0] & 2, t2.value];
        switch (op[0]) {
          case 0:
          case 1:
            t2 = op;
            break;
          case 4:
            _2.label++;
            return { value: op[1], done: false };
          case 5:
            _2.label++;
            y2 = op[1];
            op = [0];
            continue;
          case 7:
            op = _2.ops.pop();
            _2.trys.pop();
            continue;
          default:
            if (!(t2 = _2.trys, t2 = t2.length > 0 && t2[t2.length - 1]) && (op[0] === 6 || op[0] === 2)) {
              _2 = 0;
              continue;
            }
            if (op[0] === 3 && (!t2 || op[1] > t2[0] && op[1] < t2[3])) {
              _2.label = op[1];
              break;
            }
            if (op[0] === 6 && _2.label < t2[1]) {
              _2.label = t2[1];
              t2 = op;
              break;
            }
            if (t2 && _2.label < t2[2]) {
              _2.label = t2[2];
              _2.ops.push(op);
              break;
            }
            if (t2[2]) _2.ops.pop();
            _2.trys.pop();
            continue;
        }
        op = body.call(thisArg, _2);
      } catch (e2) {
        op = [6, e2];
        y2 = 0;
      } finally {
        f2 = t2 = 0;
      }
      if (op[0] & 5) throw op[1];
      return { value: op[0] ? op[1] : void 0, done: true };
    }
  };
  function safeExecuteInTheMiddle(execute, onFinish, preventThrowingError) {
    var error2;
    var result;
    try {
      result = execute();
    } catch (e2) {
      error2 = e2;
    } finally {
      onFinish(error2, result);
      if (error2 && !preventThrowingError) {
        throw error2;
      }
      return result;
    }
  }
  function safeExecuteInTheMiddleAsync(execute, onFinish, preventThrowingError) {
    return __awaiter(this, void 0, void 0, function() {
      var error2, result, e_1;
      return __generator(this, function(_a3) {
        switch (_a3.label) {
          case 0:
            _a3.trys.push([0, 2, 3, 4]);
            return [4, execute()];
          case 1:
            result = _a3.sent();
            return [3, 4];
          case 2:
            e_1 = _a3.sent();
            error2 = e_1;
            return [3, 4];
          case 3:
            onFinish(error2, result);
            if (error2 && !preventThrowingError) {
              throw error2;
            }
            return [2, result];
          case 4:
            return [
              2
              /*return*/
            ];
        }
      });
    });
  }
  function isWrapped(func) {
    return typeof func === "function" && typeof func.__original === "function" && typeof func.__unwrap === "function" && func.__wrapped === true;
  }
  var __extends = /* @__PURE__ */ function() {
    var extendStatics = function(d2, b2) {
      extendStatics = Object.setPrototypeOf || { __proto__: [] } instanceof Array && function(d3, b3) {
        d3.__proto__ = b3;
      } || function(d3, b3) {
        for (var p2 in b3) if (Object.prototype.hasOwnProperty.call(b3, p2)) d3[p2] = b3[p2];
      };
      return extendStatics(d2, b2);
    };
    return function(d2, b2) {
      if (typeof b2 !== "function" && b2 !== null)
        throw new TypeError("Class extends value " + String(b2) + " is not a constructor or null");
      extendStatics(d2, b2);
      function __() {
        this.constructor = d2;
      }
      d2.prototype = b2 === null ? Object.create(b2) : (__.prototype = b2.prototype, new __());
    };
  }();
  var __values = function(o2) {
    var s2 = typeof Symbol === "function" && Symbol.iterator, m2 = s2 && o2[s2], i2 = 0;
    if (m2) return m2.call(o2);
    if (o2 && typeof o2.length === "number") return {
      next: function() {
        if (o2 && i2 >= o2.length) o2 = void 0;
        return { value: o2 && o2[i2++], done: !o2 };
      }
    };
    throw new TypeError(s2 ? "Object is not iterable." : "Symbol.iterator is not defined.");
  };
  var InstrumentationBase = (
    /** @class */
    function(_super) {
      __extends(InstrumentationBase2, _super);
      function InstrumentationBase2(instrumentationName, instrumentationVersion, config2) {
        var _this = _super.call(this, instrumentationName, instrumentationVersion, config2) || this;
        _this._hooks = [];
        _this._requireInTheMiddleSingleton = RequireInTheMiddleSingleton.getInstance();
        _this._enabled = false;
        _this._wrap = function(moduleExports2, name2, wrapper) {
          if (isWrapped(moduleExports2[name2])) {
            _this._unwrap(moduleExports2, name2);
          }
          if (!require$$5$1.types.isProxy(moduleExports2)) {
            return shimmer_1.wrap(moduleExports2, name2, wrapper);
          } else {
            var wrapped = shimmer_1.wrap(Object.assign({}, moduleExports2), name2, wrapper);
            Object.defineProperty(moduleExports2, name2, {
              value: wrapped
            });
            return wrapped;
          }
        };
        _this._unwrap = function(moduleExports2, name2) {
          if (!require$$5$1.types.isProxy(moduleExports2)) {
            return shimmer_1.unwrap(moduleExports2, name2);
          } else {
            return Object.defineProperty(moduleExports2, name2, {
              value: moduleExports2[name2]
            });
          }
        };
        _this._massWrap = function(moduleExportsArray, names, wrapper) {
          if (!moduleExportsArray) {
            diag.error("must provide one or more modules to patch");
            return;
          } else if (!Array.isArray(moduleExportsArray)) {
            moduleExportsArray = [moduleExportsArray];
          }
          if (!(names && Array.isArray(names))) {
            diag.error("must provide one or more functions to wrap on modules");
            return;
          }
          moduleExportsArray.forEach(function(moduleExports2) {
            names.forEach(function(name2) {
              _this._wrap(moduleExports2, name2, wrapper);
            });
          });
        };
        _this._massUnwrap = function(moduleExportsArray, names) {
          if (!moduleExportsArray) {
            diag.error("must provide one or more modules to patch");
            return;
          } else if (!Array.isArray(moduleExportsArray)) {
            moduleExportsArray = [moduleExportsArray];
          }
          if (!(names && Array.isArray(names))) {
            diag.error("must provide one or more functions to wrap on modules");
            return;
          }
          moduleExportsArray.forEach(function(moduleExports2) {
            names.forEach(function(name2) {
              _this._unwrap(moduleExports2, name2);
            });
          });
        };
        var modules = _this.init();
        if (modules && !Array.isArray(modules)) {
          modules = [modules];
        }
        _this._modules = modules || [];
        if (_this._config.enabled) {
          _this.enable();
        }
        return _this;
      }
      InstrumentationBase2.prototype._warnOnPreloadedModules = function() {
        var _this = this;
        this._modules.forEach(function(module2) {
          var name2 = module2.name;
          try {
            var resolvedModule = require.resolve(name2);
            if (require.cache[resolvedModule]) {
              _this._diag.warn("Module " + name2 + " has been loaded before " + _this.instrumentationName + " so it might not work, please initialize it before requiring " + name2);
            }
          } catch (_a3) {
          }
        });
      };
      InstrumentationBase2.prototype._extractPackageVersion = function(baseDir) {
        try {
          var json = require$$0$2.readFileSync(path__namespace.join(baseDir, "package.json"), {
            encoding: "utf8"
          });
          var version2 = JSON.parse(json).version;
          return typeof version2 === "string" ? version2 : void 0;
        } catch (error2) {
          diag.warn("Failed extracting version", baseDir);
        }
        return void 0;
      };
      InstrumentationBase2.prototype._onRequire = function(module2, exports2, name2, baseDir) {
        var _this = this;
        var _a3;
        if (!baseDir) {
          if (typeof module2.patch === "function") {
            module2.moduleExports = exports2;
            if (this._enabled) {
              this._diag.debug("Applying instrumentation patch for nodejs core module on require hook", {
                module: module2.name
              });
              return module2.patch(exports2);
            }
          }
          return exports2;
        }
        var version2 = this._extractPackageVersion(baseDir);
        module2.moduleVersion = version2;
        if (module2.name === name2) {
          if (isSupported(module2.supportedVersions, version2, module2.includePrerelease)) {
            if (typeof module2.patch === "function") {
              module2.moduleExports = exports2;
              if (this._enabled) {
                this._diag.debug("Applying instrumentation patch for module on require hook", {
                  module: module2.name,
                  version: module2.moduleVersion,
                  baseDir
                });
                return module2.patch(exports2, module2.moduleVersion);
              }
            }
          }
          return exports2;
        }
        var files2 = (_a3 = module2.files) !== null && _a3 !== void 0 ? _a3 : [];
        var normalizedName = path__namespace.normalize(name2);
        var supportedFileInstrumentations = files2.filter(function(f2) {
          return f2.name === normalizedName;
        }).filter(function(f2) {
          return isSupported(f2.supportedVersions, version2, module2.includePrerelease);
        });
        return supportedFileInstrumentations.reduce(function(patchedExports, file2) {
          file2.moduleExports = patchedExports;
          if (_this._enabled) {
            _this._diag.debug("Applying instrumentation patch for nodejs module file on require hook", {
              module: module2.name,
              version: module2.moduleVersion,
              fileName: file2.name,
              baseDir
            });
            return file2.patch(patchedExports, module2.moduleVersion);
          }
          return patchedExports;
        }, exports2);
      };
      InstrumentationBase2.prototype.enable = function() {
        var e_1, _a3, e_2, _b2, e_3, _c2;
        var _this = this;
        if (this._enabled) {
          return;
        }
        this._enabled = true;
        if (this._hooks.length > 0) {
          try {
            for (var _d = __values(this._modules), _e2 = _d.next(); !_e2.done; _e2 = _d.next()) {
              var module_1 = _e2.value;
              if (typeof module_1.patch === "function" && module_1.moduleExports) {
                this._diag.debug("Applying instrumentation patch for nodejs module on instrumentation enabled", {
                  module: module_1.name,
                  version: module_1.moduleVersion
                });
                module_1.patch(module_1.moduleExports, module_1.moduleVersion);
              }
              try {
                for (var _f = (e_2 = void 0, __values(module_1.files)), _g = _f.next(); !_g.done; _g = _f.next()) {
                  var file2 = _g.value;
                  if (file2.moduleExports) {
                    this._diag.debug("Applying instrumentation patch for nodejs module file on instrumentation enabled", {
                      module: module_1.name,
                      version: module_1.moduleVersion,
                      fileName: file2.name
                    });
                    file2.patch(file2.moduleExports, module_1.moduleVersion);
                  }
                }
              } catch (e_2_1) {
                e_2 = { error: e_2_1 };
              } finally {
                try {
                  if (_g && !_g.done && (_b2 = _f.return)) _b2.call(_f);
                } finally {
                  if (e_2) throw e_2.error;
                }
              }
            }
          } catch (e_1_1) {
            e_1 = { error: e_1_1 };
          } finally {
            try {
              if (_e2 && !_e2.done && (_a3 = _d.return)) _a3.call(_d);
            } finally {
              if (e_1) throw e_1.error;
            }
          }
          return;
        }
        this._warnOnPreloadedModules();
        var _loop_1 = function(module_22) {
          var hookFn = function(exports2, name2, baseDir) {
            return _this._onRequire(module_22, exports2, name2, baseDir);
          };
          var onRequire = function(exports2, name2, baseDir) {
            return _this._onRequire(module_22, exports2, name2, baseDir);
          };
          var hook = path__namespace.isAbsolute(module_22.name) ? new Hook_1$1([module_22.name], { internals: true }, onRequire) : this_1._requireInTheMiddleSingleton.register(module_22.name, onRequire);
          this_1._hooks.push(hook);
          var esmHook = new Hook_1([module_22.name], { internals: false }, hookFn);
          this_1._hooks.push(esmHook);
        };
        var this_1 = this;
        try {
          for (var _h = __values(this._modules), _j = _h.next(); !_j.done; _j = _h.next()) {
            var module_2 = _j.value;
            _loop_1(module_2);
          }
        } catch (e_3_1) {
          e_3 = { error: e_3_1 };
        } finally {
          try {
            if (_j && !_j.done && (_c2 = _h.return)) _c2.call(_h);
          } finally {
            if (e_3) throw e_3.error;
          }
        }
      };
      InstrumentationBase2.prototype.disable = function() {
        var e_4, _a3, e_5, _b2;
        if (!this._enabled) {
          return;
        }
        this._enabled = false;
        try {
          for (var _c2 = __values(this._modules), _d = _c2.next(); !_d.done; _d = _c2.next()) {
            var module_3 = _d.value;
            if (typeof module_3.unpatch === "function" && module_3.moduleExports) {
              this._diag.debug("Removing instrumentation patch for nodejs module on instrumentation disabled", {
                module: module_3.name,
                version: module_3.moduleVersion
              });
              module_3.unpatch(module_3.moduleExports, module_3.moduleVersion);
            }
            try {
              for (var _e2 = (e_5 = void 0, __values(module_3.files)), _f = _e2.next(); !_f.done; _f = _e2.next()) {
                var file2 = _f.value;
                if (file2.moduleExports) {
                  this._diag.debug("Removing instrumentation patch for nodejs module file on instrumentation disabled", {
                    module: module_3.name,
                    version: module_3.moduleVersion,
                    fileName: file2.name
                  });
                  file2.unpatch(file2.moduleExports, module_3.moduleVersion);
                }
              }
            } catch (e_5_1) {
              e_5 = { error: e_5_1 };
            } finally {
              try {
                if (_f && !_f.done && (_b2 = _e2.return)) _b2.call(_e2);
              } finally {
                if (e_5) throw e_5.error;
              }
            }
          }
        } catch (e_4_1) {
          e_4 = { error: e_4_1 };
        } finally {
          try {
            if (_d && !_d.done && (_a3 = _c2.return)) _a3.call(_c2);
          } finally {
            if (e_4) throw e_4.error;
          }
        }
      };
      InstrumentationBase2.prototype.isEnabled = function() {
        return this._enabled;
      };
      return InstrumentationBase2;
    }(InstrumentationAbstract)
  );
  function isSupported(supportedVersions, version2, includePrerelease) {
    if (typeof version2 === "undefined") {
      return supportedVersions.includes("*");
    }
    return supportedVersions.some(function(supportedVersion) {
      return semver.satisfies(version2, supportedVersion, { includePrerelease });
    });
  }
  var InstrumentationNodeModuleDefinition = (
    /** @class */
    /* @__PURE__ */ function() {
      function InstrumentationNodeModuleDefinition2(name2, supportedVersions, patch2, unpatch, files2) {
        this.name = name2;
        this.supportedVersions = supportedVersions;
        this.patch = patch2;
        this.unpatch = unpatch;
        this.files = files2 || [];
      }
      return InstrumentationNodeModuleDefinition2;
    }()
  );
  var InstrumentationNodeModuleFile = (
    /** @class */
    /* @__PURE__ */ function() {
      function InstrumentationNodeModuleFile2(name2, supportedVersions, patch2, unpatch) {
        this.supportedVersions = supportedVersions;
        this.patch = patch2;
        this.unpatch = unpatch;
        this.name = path$k.normalize(name2);
      }
      return InstrumentationNodeModuleFile2;
    }()
  );
  const esm = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
    __proto__: null,
    InstrumentationBase,
    InstrumentationNodeModuleDefinition,
    InstrumentationNodeModuleFile,
    isWrapped,
    registerInstrumentations,
    safeExecuteInTheMiddle,
    safeExecuteInTheMiddleAsync
  }, Symbol.toStringTag, { value: "Module" }));
  const require$$2 = /* @__PURE__ */ getAugmentedNamespace(esm);
  var version$1 = {};
  Object.defineProperty(version$1, "__esModule", { value: true });
  version$1.PACKAGE_NAME = version$1.PACKAGE_VERSION = void 0;
  version$1.PACKAGE_VERSION = "0.6.0";
  version$1.PACKAGE_NAME = "@opentelemetry/instrumentation-undici";
  var SemanticAttributes = {};
  Object.defineProperty(SemanticAttributes, "__esModule", { value: true });
  SemanticAttributes.SemanticAttributes = void 0;
  SemanticAttributes.SemanticAttributes = {
    /**
     * State of the HTTP connection in the HTTP connection pool.
     */
    HTTP_CONNECTION_STATE: "http.connection.state",
    /**
      * Describes a class of error the operation ended with.
      *
      * Note: The `error.type` SHOULD be predictable and SHOULD have low cardinality.
    Instrumentations SHOULD document the list of errors they report.
    
    The cardinality of `error.type` within one instrumentation library SHOULD be low.
    Telemetry consumers that aggregate data from multiple instrumentation libraries and applications
    should be prepared for `error.type` to have high cardinality at query time when no
    additional filters are applied.
    
    If the operation has completed successfully, instrumentations SHOULD NOT set `error.type`.
    
    If a specific domain defines its own set of error identifiers (such as HTTP or gRPC status codes),
    it&#39;s RECOMMENDED to:
    
    * Use a domain-specific attribute
    * Set `error.type` to capture all errors, regardless of whether they are defined within the domain-specific set or not.
      */
    ERROR_TYPE: "error.type",
    /**
     * The size of the request payload body in bytes. This is the number of bytes transferred excluding headers and is often, but not always, present as the [Content-Length](https://www.rfc-editor.org/rfc/rfc9110.html#field.content-length) header. For requests using transport encoding, this should be the compressed size.
     */
    HTTP_REQUEST_BODY_SIZE: "http.request.body.size",
    /**
      * HTTP request method.
      *
      * Note: HTTP request method value SHOULD be &#34;known&#34; to the instrumentation.
    By default, this convention defines &#34;known&#34; methods as the ones listed in [RFC9110](https://www.rfc-editor.org/rfc/rfc9110.html#name-methods)
    and the PATCH method defined in [RFC5789](https://www.rfc-editor.org/rfc/rfc5789.html).
    
    If the HTTP request method is not known to instrumentation, it MUST set the `http.request.method` attribute to `_OTHER`.
    
    If the HTTP instrumentation could end up converting valid HTTP request methods to `_OTHER`, then it MUST provide a way to override
    the list of known HTTP methods. If this override is done via environment variable, then the environment variable MUST be named
    OTEL_INSTRUMENTATION_HTTP_KNOWN_METHODS and support a comma-separated list of case-sensitive known HTTP methods
    (this list MUST be a full override of the default known method, it is not a list of known methods in addition to the defaults).
    
    HTTP method names are case-sensitive and `http.request.method` attribute value MUST match a known HTTP method name exactly.
    Instrumentations for specific web frameworks that consider HTTP methods to be case insensitive, SHOULD populate a canonical equivalent.
    Tracing instrumentations that do so, MUST also set `http.request.method_original` to the original value.
      */
    HTTP_REQUEST_METHOD: "http.request.method",
    /**
     * Original HTTP method sent by the client in the request line.
     */
    HTTP_REQUEST_METHOD_ORIGINAL: "http.request.method_original",
    /**
     * The ordinal number of request resending attempt (for any reason, including redirects).
     *
     * Note: The resend count SHOULD be updated each time an HTTP request gets resent by the client, regardless of what was the cause of the resending (e.g. redirection, authorization failure, 503 Server Unavailable, network issues, or any other).
     */
    HTTP_REQUEST_RESEND_COUNT: "http.request.resend_count",
    /**
     * The size of the response payload body in bytes. This is the number of bytes transferred excluding headers and is often, but not always, present as the [Content-Length](https://www.rfc-editor.org/rfc/rfc9110.html#field.content-length) header. For requests using transport encoding, this should be the compressed size.
     */
    HTTP_RESPONSE_BODY_SIZE: "http.response.body.size",
    /**
     * [HTTP response status code](https://tools.ietf.org/html/rfc7231#section-6).
     */
    HTTP_RESPONSE_STATUS_CODE: "http.response.status_code",
    /**
      * The matched route, that is, the path template in the format used by the respective server framework.
      *
      * Note: MUST NOT be populated when this is not supported by the HTTP server framework as the route attribute should have low-cardinality and the URI path can NOT substitute it.
    SHOULD include the [application root](/docs/http/http-spans.md#http-server-definitions) if there is one.
      */
    HTTP_ROUTE: "http.route",
    /**
     * Peer address of the network connection - IP address or Unix domain socket name.
     */
    NETWORK_PEER_ADDRESS: "network.peer.address",
    /**
     * Peer port number of the network connection.
     */
    NETWORK_PEER_PORT: "network.peer.port",
    /**
     * [OSI application layer](https://osi-model.com/application-layer/) or non-OSI equivalent.
     *
     * Note: The value SHOULD be normalized to lowercase.
     */
    NETWORK_PROTOCOL_NAME: "network.protocol.name",
    /**
     * Version of the protocol specified in `network.protocol.name`.
     *
     * Note: `network.protocol.version` refers to the version of the protocol used and might be different from the protocol client&#39;s version. If the HTTP client has a version of `0.27.2`, but sends HTTP version `1.1`, this attribute should be set to `1.1`.
     */
    NETWORK_PROTOCOL_VERSION: "network.protocol.version",
    /**
     * Server domain name if available without reverse DNS lookup; otherwise, IP address or Unix domain socket name.
     *
     * Note: When observed from the client side, and when communicating through an intermediary, `server.address` SHOULD represent the server address behind any intermediaries, for example proxies, if it&#39;s available.
     */
    SERVER_ADDRESS: "server.address",
    /**
     * Server port number.
     *
     * Note: When observed from the client side, and when communicating through an intermediary, `server.port` SHOULD represent the server port behind any intermediaries, for example proxies, if it&#39;s available.
     */
    SERVER_PORT: "server.port",
    /**
      * Absolute URL describing a network resource according to [RFC3986](https://www.rfc-editor.org/rfc/rfc3986).
      *
      * Note: For network calls, URL usually has `scheme://host[:port][path][?query][#fragment]` format, where the fragment is not transmitted over HTTP, but if it is known, it SHOULD be included nevertheless.
    `url.full` MUST NOT contain credentials passed via URL in form of `https://username:password@www.example.com/`. In such case username and password SHOULD be redacted and attribute&#39;s value SHOULD be `https://REDACTED:REDACTED@www.example.com/`.
    `url.full` SHOULD capture the absolute URL when it is available (or can be reconstructed) and SHOULD NOT be validated or modified except for sanitizing purposes.
      */
    URL_FULL: "url.full",
    /**
     * The [URI path](https://www.rfc-editor.org/rfc/rfc3986#section-3.3) component.
     */
    URL_PATH: "url.path",
    /**
     * The [URI query](https://www.rfc-editor.org/rfc/rfc3986#section-3.4) component.
     *
     * Note: Sensitive content provided in query string SHOULD be scrubbed when instrumentations can identify it.
     */
    URL_QUERY: "url.query",
    /**
     * The [URI scheme](https://www.rfc-editor.org/rfc/rfc3986#section-3.1) component identifying the used protocol.
     */
    URL_SCHEME: "url.scheme",
    /**
     * Value of the [HTTP User-Agent](https://www.rfc-editor.org/rfc/rfc9110.html#field.user-agent) header sent by the client.
     */
    USER_AGENT_ORIGINAL: "user_agent.original"
  };
  const require$$1 = /* @__PURE__ */ getAugmentedNamespace(esm$1);
  Object.defineProperty(undici, "__esModule", { value: true });
  undici.UndiciInstrumentation = void 0;
  const diagch = require$$0$4;
  const url_1 = Url;
  const instrumentation_1 = require$$2;
  const api_1$2 = require$$0;
  const version_1 = version$1;
  const SemanticAttributes_1 = SemanticAttributes;
  const core_1 = require$$1;
  class UndiciInstrumentation extends instrumentation_1.InstrumentationBase {
    constructor(config2 = {}) {
      super(version_1.PACKAGE_NAME, version_1.PACKAGE_VERSION, config2);
      this._recordFromReq = /* @__PURE__ */ new WeakMap();
    }
    // No need to instrument files/modules
    init() {
      return void 0;
    }
    disable() {
      super.disable();
      this._channelSubs.forEach((sub) => sub.channel.unsubscribe(sub.onMessage));
      this._channelSubs.length = 0;
    }
    enable() {
      super.enable();
      this._channelSubs = this._channelSubs || [];
      if (this._channelSubs.length > 0) {
        return;
      }
      this.subscribeToChannel("undici:request:create", this.onRequestCreated.bind(this));
      this.subscribeToChannel("undici:client:sendHeaders", this.onRequestHeaders.bind(this));
      this.subscribeToChannel("undici:request:headers", this.onResponseHeaders.bind(this));
      this.subscribeToChannel("undici:request:trailers", this.onDone.bind(this));
      this.subscribeToChannel("undici:request:error", this.onError.bind(this));
    }
    _updateMetricInstruments() {
      this._httpClientDurationHistogram = this.meter.createHistogram("http.client.request.duration", {
        description: "Measures the duration of outbound HTTP requests.",
        unit: "s",
        valueType: api_1$2.ValueType.DOUBLE,
        advice: {
          explicitBucketBoundaries: [
            5e-3,
            0.01,
            0.025,
            0.05,
            0.075,
            0.1,
            0.25,
            0.5,
            0.75,
            1,
            2.5,
            5,
            7.5,
            10
          ]
        }
      });
    }
    subscribeToChannel(diagnosticChannel, onMessage) {
      const channel = diagch.channel(diagnosticChannel);
      channel.subscribe(onMessage);
      this._channelSubs.push({
        name: diagnosticChannel,
        channel,
        onMessage
      });
    }
    // This is the 1st message we receive for each request (fired after request creation). Here we will
    // create the span and populate some atttributes, then link the span to the request for further
    // span processing
    onRequestCreated({ request }) {
      const config2 = this.getConfig();
      const enabled = config2.enabled !== false;
      const shouldIgnoreReq = (0, instrumentation_1.safeExecuteInTheMiddle)(() => {
        var _a3;
        return !enabled || request.method === "CONNECT" || ((_a3 = config2.ignoreRequestHook) === null || _a3 === void 0 ? void 0 : _a3.call(config2, request));
      }, (e2) => e2 && this._diag.error("caught ignoreRequestHook error: ", e2), true);
      if (shouldIgnoreReq) {
        return;
      }
      const startTime = (0, core_1.hrTime)();
      const requestUrl = new url_1.URL(request.origin + request.path);
      const urlScheme = requestUrl.protocol.replace(":", "");
      const requestMethod = this.getRequestMethod(request.method);
      const attributes = {
        [SemanticAttributes_1.SemanticAttributes.HTTP_REQUEST_METHOD]: requestMethod,
        [SemanticAttributes_1.SemanticAttributes.HTTP_REQUEST_METHOD_ORIGINAL]: request.method,
        [SemanticAttributes_1.SemanticAttributes.URL_FULL]: requestUrl.toString(),
        [SemanticAttributes_1.SemanticAttributes.URL_PATH]: requestUrl.pathname,
        [SemanticAttributes_1.SemanticAttributes.URL_QUERY]: requestUrl.search,
        [SemanticAttributes_1.SemanticAttributes.URL_SCHEME]: urlScheme
      };
      const schemePorts = { https: "443", http: "80" };
      const serverAddress = requestUrl.hostname;
      const serverPort = requestUrl.port || schemePorts[urlScheme];
      attributes[SemanticAttributes_1.SemanticAttributes.SERVER_ADDRESS] = serverAddress;
      if (serverPort && !isNaN(Number(serverPort))) {
        attributes[SemanticAttributes_1.SemanticAttributes.SERVER_PORT] = Number(serverPort);
      }
      let userAgent2;
      if (Array.isArray(request.headers)) {
        const idx = request.headers.findIndex((h2) => h2.toLowerCase() === "user-agent");
        if (idx >= 0) {
          userAgent2 = request.headers[idx + 1];
        }
      } else if (typeof request.headers === "string") {
        const headers = request.headers.split("\r\n");
        const uaHeader = headers.find((h2) => h2.toLowerCase().startsWith("user-agent"));
        userAgent2 = uaHeader && uaHeader.substring(uaHeader.indexOf(":") + 1).trim();
      }
      if (userAgent2) {
        attributes[SemanticAttributes_1.SemanticAttributes.USER_AGENT_ORIGINAL] = userAgent2;
      }
      const hookAttributes = (0, instrumentation_1.safeExecuteInTheMiddle)(() => {
        var _a3;
        return (_a3 = config2.startSpanHook) === null || _a3 === void 0 ? void 0 : _a3.call(config2, request);
      }, (e2) => e2 && this._diag.error("caught startSpanHook error: ", e2), true);
      if (hookAttributes) {
        Object.entries(hookAttributes).forEach(([key, val]) => {
          attributes[key] = val;
        });
      }
      const activeCtx = api_1$2.context.active();
      const currentSpan = api_1$2.trace.getSpan(activeCtx);
      let span;
      if (config2.requireParentforSpans && (!currentSpan || !api_1$2.trace.isSpanContextValid(currentSpan.spanContext()))) {
        span = api_1$2.trace.wrapSpanContext(api_1$2.INVALID_SPAN_CONTEXT);
      } else {
        span = this.tracer.startSpan(requestMethod === "_OTHER" ? "HTTP" : requestMethod, {
          kind: api_1$2.SpanKind.CLIENT,
          attributes
        }, activeCtx);
      }
      (0, instrumentation_1.safeExecuteInTheMiddle)(() => {
        var _a3;
        return (_a3 = config2.requestHook) === null || _a3 === void 0 ? void 0 : _a3.call(config2, span, request);
      }, (e2) => e2 && this._diag.error("caught requestHook error: ", e2), true);
      const requestContext = api_1$2.trace.setSpan(api_1$2.context.active(), span);
      const addedHeaders = {};
      api_1$2.propagation.inject(requestContext, addedHeaders);
      const headerEntries = Object.entries(addedHeaders);
      for (let i2 = 0; i2 < headerEntries.length; i2++) {
        const [k2, v2] = headerEntries[i2];
        if (typeof request.addHeader === "function") {
          request.addHeader(k2, v2);
        } else if (typeof request.headers === "string") {
          request.headers += `${k2}: ${v2}\r
`;
        } else if (Array.isArray(request.headers)) {
          request.headers.push(k2, v2);
        }
      }
      this._recordFromReq.set(request, { span, attributes, startTime });
    }
    // This is the 2nd message we receive for each request. It is fired when connection with
    // the remote is established and about to send the first byte. Here we do have info about the
    // remote address and port so we can populate some `network.*` attributes into the span
    onRequestHeaders({ request, socket }) {
      var _a3;
      const record = this._recordFromReq.get(request);
      if (!record) {
        return;
      }
      const config2 = this.getConfig();
      const { span } = record;
      const { remoteAddress, remotePort } = socket;
      const spanAttributes = {
        [SemanticAttributes_1.SemanticAttributes.NETWORK_PEER_ADDRESS]: remoteAddress,
        [SemanticAttributes_1.SemanticAttributes.NETWORK_PEER_PORT]: remotePort
      };
      if ((_a3 = config2.headersToSpanAttributes) === null || _a3 === void 0 ? void 0 : _a3.requestHeaders) {
        const headersToAttribs = new Set(config2.headersToSpanAttributes.requestHeaders.map((n2) => n2.toLowerCase()));
        const rawHeaders = Array.isArray(request.headers) ? request.headers : request.headers.split("\r\n");
        rawHeaders.forEach((h2, idx) => {
          const sepIndex = h2.indexOf(":");
          const hasSeparator = sepIndex !== -1;
          const name2 = (hasSeparator ? h2.substring(0, sepIndex) : h2).toLowerCase();
          const value = hasSeparator ? h2.substring(sepIndex + 1) : rawHeaders[idx + 1];
          if (headersToAttribs.has(name2)) {
            spanAttributes[`http.request.header.${name2}`] = value.trim();
          }
        });
      }
      span.setAttributes(spanAttributes);
    }
    // This is the 3rd message we get for each request and it's fired when the server
    // headers are received, body may not be accessible yet.
    // From the response headers we can set the status and content length
    onResponseHeaders({ request, response }) {
      var _a3, _b2;
      const record = this._recordFromReq.get(request);
      if (!record) {
        return;
      }
      const { span, attributes } = record;
      const spanAttributes = {
        [SemanticAttributes_1.SemanticAttributes.HTTP_RESPONSE_STATUS_CODE]: response.statusCode
      };
      const config2 = this.getConfig();
      (0, instrumentation_1.safeExecuteInTheMiddle)(() => {
        var _a4;
        return (_a4 = config2.responseHook) === null || _a4 === void 0 ? void 0 : _a4.call(config2, span, { request, response });
      }, (e2) => e2 && this._diag.error("caught responseHook error: ", e2), true);
      const headersToAttribs = /* @__PURE__ */ new Set();
      if ((_a3 = config2.headersToSpanAttributes) === null || _a3 === void 0 ? void 0 : _a3.responseHeaders) {
        (_b2 = config2.headersToSpanAttributes) === null || _b2 === void 0 ? void 0 : _b2.responseHeaders.forEach((name2) => headersToAttribs.add(name2.toLowerCase()));
      }
      for (let idx = 0; idx < response.headers.length; idx = idx + 2) {
        const name2 = response.headers[idx].toString().toLowerCase();
        const value = response.headers[idx + 1];
        if (headersToAttribs.has(name2)) {
          spanAttributes[`http.response.header.${name2}`] = value.toString();
        }
        if (name2 === "content-length") {
          const contentLength = Number(value.toString());
          if (!isNaN(contentLength)) {
            spanAttributes["http.response.header.content-length"] = contentLength;
          }
        }
      }
      span.setAttributes(spanAttributes);
      span.setStatus({
        code: response.statusCode >= 400 ? api_1$2.SpanStatusCode.ERROR : api_1$2.SpanStatusCode.UNSET
      });
      record.attributes = Object.assign(attributes, spanAttributes);
    }
    // This is the last event we receive if the request went without any errors
    onDone({ request }) {
      const record = this._recordFromReq.get(request);
      if (!record) {
        return;
      }
      const { span, attributes, startTime } = record;
      span.end();
      this._recordFromReq.delete(request);
      this.recordRequestDuration(attributes, startTime);
    }
    // This is the event we get when something is wrong in the request like
    // - invalid options when calling `fetch` global API or any undici method for request
    // - connectivity errors such as unreachable host
    // - requests aborted through an `AbortController.signal`
    // NOTE: server errors are considered valid responses and it's the lib consumer
    // who should deal with that.
    onError({ request, error: error2 }) {
      const record = this._recordFromReq.get(request);
      if (!record) {
        return;
      }
      const { span, attributes, startTime } = record;
      span.recordException(error2);
      span.setStatus({
        code: api_1$2.SpanStatusCode.ERROR,
        message: error2.message
      });
      span.end();
      this._recordFromReq.delete(request);
      attributes[SemanticAttributes_1.SemanticAttributes.ERROR_TYPE] = error2.message;
      this.recordRequestDuration(attributes, startTime);
    }
    recordRequestDuration(attributes, startTime) {
      const metricsAttributes = {};
      const keysToCopy = [
        SemanticAttributes_1.SemanticAttributes.HTTP_RESPONSE_STATUS_CODE,
        SemanticAttributes_1.SemanticAttributes.HTTP_REQUEST_METHOD,
        SemanticAttributes_1.SemanticAttributes.SERVER_ADDRESS,
        SemanticAttributes_1.SemanticAttributes.SERVER_PORT,
        SemanticAttributes_1.SemanticAttributes.URL_SCHEME,
        SemanticAttributes_1.SemanticAttributes.ERROR_TYPE
      ];
      keysToCopy.forEach((key) => {
        if (key in attributes) {
          metricsAttributes[key] = attributes[key];
        }
      });
      const durationSeconds = (0, core_1.hrTimeToMilliseconds)((0, core_1.hrTimeDuration)(startTime, (0, core_1.hrTime)())) / 1e3;
      this._httpClientDurationHistogram.record(durationSeconds, metricsAttributes);
    }
    getRequestMethod(original) {
      const knownMethods = {
        CONNECT: true,
        OPTIONS: true,
        HEAD: true,
        GET: true,
        POST: true,
        PUT: true,
        PATCH: true,
        DELETE: true,
        TRACE: true
      };
      if (original.toUpperCase() in knownMethods) {
        return original.toUpperCase();
      }
      return "_OTHER";
    }
  }
  undici.UndiciInstrumentation = UndiciInstrumentation;
  var types$2 = {};
  Object.defineProperty(types$2, "__esModule", { value: true });
  (function(exports2) {
    var __createBinding = commonjsGlobal && commonjsGlobal.__createBinding || (Object.create ? function(o2, m2, k2, k22) {
      if (k22 === void 0) k22 = k2;
      Object.defineProperty(o2, k22, { enumerable: true, get: function() {
        return m2[k2];
      } });
    } : function(o2, m2, k2, k22) {
      if (k22 === void 0) k22 = k2;
      o2[k22] = m2[k2];
    });
    var __exportStar = commonjsGlobal && commonjsGlobal.__exportStar || function(m2, exports3) {
      for (var p2 in m2) if (p2 !== "default" && !Object.prototype.hasOwnProperty.call(exports3, p2)) __createBinding(exports3, m2, p2);
    };
    Object.defineProperty(exports2, "__esModule", { value: true });
    __exportStar(undici, exports2);
    __exportStar(types$2, exports2);
  })(src$3);
  const _nativeNodeFetchIntegration = (options = {}) => {
    const _breadcrumbs = typeof options.breadcrumbs === "undefined" ? true : options.breadcrumbs;
    const _ignoreOutgoingRequests = options.ignoreOutgoingRequests;
    return {
      name: "NodeFetch",
      setupOnce() {
        const propagationDecisionMap = new LRUMap(100);
        const instrumentation = new src$3.UndiciInstrumentation({
          requireParentforSpans: false,
          ignoreRequestHook: (request) => {
            const url2 = getAbsoluteUrl(request.origin, request.path);
            const shouldIgnore = _ignoreOutgoingRequests && url2 && _ignoreOutgoingRequests(url2);
            if (shouldIgnore) {
              return true;
            }
            if (!hasTracingEnabled()) {
              const tracePropagationTargets = _optionalChain([getClient, "call", (_2) => _2(), "optionalAccess", (_3) => _3.getOptions, "call", (_4) => _4(), "access", (_5) => _5.tracePropagationTargets]);
              const addedHeaders = shouldPropagateTraceForUrl(url2, tracePropagationTargets, propagationDecisionMap) ? getTraceData$1() : {};
              const requestHeaders = request.headers;
              if (Array.isArray(requestHeaders)) {
                Object.entries(addedHeaders).forEach((headers) => requestHeaders.push(...headers));
              } else {
                request.headers += Object.entries(addedHeaders).map(([k2, v2]) => `${k2}: ${v2}\r
`).join("");
              }
              return true;
            }
            return false;
          },
          startSpanHook: () => {
            return {
              [SEMANTIC_ATTRIBUTE_SENTRY_ORIGIN]: "auto.http.otel.node_fetch"
            };
          },
          responseHook: (_2, { request, response }) => {
            if (_breadcrumbs) {
              addRequestBreadcrumb$1(request, response);
            }
          }
        });
        registerInstrumentations$1({ instrumentations: [instrumentation] });
      }
    };
  };
  const nativeNodeFetchIntegration = defineIntegration(_nativeNodeFetchIntegration);
  function addRequestBreadcrumb$1(request, response) {
    const data2 = getBreadcrumbData(request);
    const statusCode = response.statusCode;
    const level = getBreadcrumbLogLevelFromHttpStatusCode(statusCode);
    addBreadcrumb(
      {
        category: "http",
        data: {
          status_code: statusCode,
          ...data2
        },
        type: "http",
        level
      },
      {
        event: "response",
        request,
        response
      }
    );
  }
  function getBreadcrumbData(request) {
    try {
      const url2 = new URL(request.path, request.origin);
      const parsedUrl = parseUrl(url2.toString());
      const data2 = {
        url: getSanitizedUrlString(parsedUrl),
        "http.method": request.method || "GET"
      };
      if (parsedUrl.search) {
        data2["http.query"] = parsedUrl.search;
      }
      if (parsedUrl.hash) {
        data2["http.fragment"] = parsedUrl.hash;
      }
      return data2;
    } catch (e2) {
      return {};
    }
  }
  function getAbsoluteUrl(origin, path2 = "/") {
    const url2 = `${origin}`;
    if (url2.endsWith("/") && path2.startsWith("/")) {
      return `${url2}${path2.slice(1)}`;
    }
    if (!url2.endsWith("/") && !path2.startsWith("/")) {
      return `${url2}/${path2.slice(1)}`;
    }
    return `${url2}${path2}`;
  }
  const INTEGRATION_NAME$4 = "Console";
  const consoleIntegration = defineIntegration(() => {
    return {
      name: INTEGRATION_NAME$4,
      setup(client) {
        addConsoleInstrumentationHandler(({ args: args2, level }) => {
          if (getClient() !== client) {
            return;
          }
          addBreadcrumb(
            {
              category: "console",
              level: severityLevelFromString(level),
              message: truncate(util__namespace.format.apply(void 0, args2), 2048)
              // 2KB
            },
            {
              input: [...args2],
              level
            }
          );
        });
      }
    };
  });
  const readFileAsync = util$b.promisify(node_fs.readFile);
  const readDirAsync = util$b.promisify(node_fs.readdir);
  const INTEGRATION_NAME$3 = "Context";
  const _nodeContextIntegration = (options = {}) => {
    let cachedContext;
    const _options = {
      app: true,
      os: true,
      device: true,
      culture: true,
      cloudResource: true,
      ...options
    };
    async function addContext(event) {
      if (cachedContext === void 0) {
        cachedContext = _getContexts();
      }
      const updatedContext = _updateContext(await cachedContext);
      event.contexts = {
        ...event.contexts,
        app: { ...updatedContext.app, ..._optionalChain([event, "access", (_2) => _2.contexts, "optionalAccess", (_2) => _2.app]) },
        os: { ...updatedContext.os, ..._optionalChain([event, "access", (_3) => _3.contexts, "optionalAccess", (_4) => _4.os]) },
        device: { ...updatedContext.device, ..._optionalChain([event, "access", (_5) => _5.contexts, "optionalAccess", (_6) => _6.device]) },
        culture: { ...updatedContext.culture, ..._optionalChain([event, "access", (_7) => _7.contexts, "optionalAccess", (_8) => _8.culture]) },
        cloud_resource: { ...updatedContext.cloud_resource, ..._optionalChain([event, "access", (_9) => _9.contexts, "optionalAccess", (_10) => _10.cloud_resource]) }
      };
      return event;
    }
    async function _getContexts() {
      const contexts = {};
      if (_options.os) {
        contexts.os = await getOsContext();
      }
      if (_options.app) {
        contexts.app = getAppContext();
      }
      if (_options.device) {
        contexts.device = getDeviceContext(_options.device);
      }
      if (_options.culture) {
        const culture = getCultureContext();
        if (culture) {
          contexts.culture = culture;
        }
      }
      if (_options.cloudResource) {
        contexts.cloud_resource = getCloudResourceContext();
      }
      return contexts;
    }
    return {
      name: INTEGRATION_NAME$3,
      processEvent(event) {
        return addContext(event);
      }
    };
  };
  const nodeContextIntegration = defineIntegration(_nodeContextIntegration);
  function _updateContext(contexts) {
    if (_optionalChain([contexts, "optionalAccess", (_11) => _11.app, "optionalAccess", (_12) => _12.app_memory])) {
      contexts.app.app_memory = process.memoryUsage().rss;
    }
    if (_optionalChain([contexts, "optionalAccess", (_13) => _13.app, "optionalAccess", (_14) => _14.free_memory]) && typeof process.availableMemory === "function") {
      const freeMemory = _optionalChain([process, "access", (_15) => _15.availableMemory, "optionalCall", (_16) => _16()]);
      if (freeMemory != null) {
        contexts.app.free_memory = freeMemory;
      }
    }
    if (_optionalChain([contexts, "optionalAccess", (_17) => _17.device, "optionalAccess", (_18) => _18.free_memory])) {
      contexts.device.free_memory = os__namespace.freemem();
    }
    return contexts;
  }
  async function getOsContext() {
    const platformId = os__namespace.platform();
    switch (platformId) {
      case "darwin":
        return getDarwinInfo();
      case "linux":
        return getLinuxInfo();
      default:
        return {
          name: PLATFORM_NAMES[platformId] || platformId,
          version: os__namespace.release()
        };
    }
  }
  function getCultureContext() {
    try {
      if (typeof process.versions.icu !== "string") {
        return;
      }
      const january = /* @__PURE__ */ new Date(9e8);
      const spanish = new Intl.DateTimeFormat("es", { month: "long" });
      if (spanish.format(january) === "enero") {
        const options = Intl.DateTimeFormat().resolvedOptions();
        return {
          locale: options.locale,
          timezone: options.timeZone
        };
      }
    } catch (err) {
    }
    return;
  }
  function getAppContext() {
    const app_memory = process.memoryUsage().rss;
    const app_start_time = new Date(Date.now() - process.uptime() * 1e3).toISOString();
    const appContext = { app_start_time, app_memory };
    if (typeof process.availableMemory === "function") {
      const freeMemory = _optionalChain([process, "access", (_19) => _19.availableMemory, "optionalCall", (_20) => _20()]);
      if (freeMemory != null) {
        appContext.free_memory = freeMemory;
      }
    }
    return appContext;
  }
  function getDeviceContext(deviceOpt) {
    const device = {};
    let uptime;
    try {
      uptime = os__namespace.uptime && os__namespace.uptime();
    } catch (e2) {
    }
    if (typeof uptime === "number") {
      device.boot_time = new Date(Date.now() - uptime * 1e3).toISOString();
    }
    device.arch = os__namespace.arch();
    if (deviceOpt === true || deviceOpt.memory) {
      device.memory_size = os__namespace.totalmem();
      device.free_memory = os__namespace.freemem();
    }
    if (deviceOpt === true || deviceOpt.cpu) {
      const cpuInfo = os__namespace.cpus();
      const firstCpu = cpuInfo && cpuInfo[0];
      if (firstCpu) {
        device.processor_count = cpuInfo.length;
        device.cpu_description = firstCpu.model;
        device.processor_frequency = firstCpu.speed;
      }
    }
    return device;
  }
  const PLATFORM_NAMES = {
    aix: "IBM AIX",
    freebsd: "FreeBSD",
    openbsd: "OpenBSD",
    sunos: "SunOS",
    win32: "Windows"
  };
  const LINUX_DISTROS = [
    { name: "fedora-release", distros: ["Fedora"] },
    { name: "redhat-release", distros: ["Red Hat Linux", "Centos"] },
    { name: "redhat_version", distros: ["Red Hat Linux"] },
    { name: "SuSE-release", distros: ["SUSE Linux"] },
    { name: "lsb-release", distros: ["Ubuntu Linux", "Arch Linux"] },
    { name: "debian_version", distros: ["Debian"] },
    { name: "debian_release", distros: ["Debian"] },
    { name: "arch-release", distros: ["Arch Linux"] },
    { name: "gentoo-release", distros: ["Gentoo Linux"] },
    { name: "novell-release", distros: ["SUSE Linux"] },
    { name: "alpine-release", distros: ["Alpine Linux"] }
  ];
  const LINUX_VERSIONS = {
    alpine: (content) => content,
    arch: (content) => matchFirst(/distrib_release=(.*)/, content),
    centos: (content) => matchFirst(/release ([^ ]+)/, content),
    debian: (content) => content,
    fedora: (content) => matchFirst(/release (..)/, content),
    mint: (content) => matchFirst(/distrib_release=(.*)/, content),
    red: (content) => matchFirst(/release ([^ ]+)/, content),
    suse: (content) => matchFirst(/VERSION = (.*)\n/, content),
    ubuntu: (content) => matchFirst(/distrib_release=(.*)/, content)
  };
  function matchFirst(regex2, text) {
    const match = regex2.exec(text);
    return match ? match[1] : void 0;
  }
  async function getDarwinInfo() {
    const darwinInfo = {
      kernel_version: os__namespace.release(),
      name: "Mac OS X",
      version: `10.${Number(os__namespace.release().split(".")[0]) - 4}`
    };
    try {
      const output = await new Promise((resolve2, reject) => {
        node_child_process.execFile("/usr/bin/sw_vers", (error2, stdout) => {
          if (error2) {
            reject(error2);
            return;
          }
          resolve2(stdout);
        });
      });
      darwinInfo.name = matchFirst(/^ProductName:\s+(.*)$/m, output);
      darwinInfo.version = matchFirst(/^ProductVersion:\s+(.*)$/m, output);
      darwinInfo.build = matchFirst(/^BuildVersion:\s+(.*)$/m, output);
    } catch (e2) {
    }
    return darwinInfo;
  }
  function getLinuxDistroId(name2) {
    return name2.split(" ")[0].toLowerCase();
  }
  async function getLinuxInfo() {
    const linuxInfo = {
      kernel_version: os__namespace.release(),
      name: "Linux"
    };
    try {
      const etcFiles = await readDirAsync("/etc");
      const distroFile = LINUX_DISTROS.find((file2) => etcFiles.includes(file2.name));
      if (!distroFile) {
        return linuxInfo;
      }
      const distroPath = path$l.join("/etc", distroFile.name);
      const contents = (await readFileAsync(distroPath, { encoding: "utf-8" })).toLowerCase();
      const { distros } = distroFile;
      linuxInfo.name = distros.find((d2) => contents.indexOf(getLinuxDistroId(d2)) >= 0) || distros[0];
      const id = getLinuxDistroId(linuxInfo.name);
      linuxInfo.version = _optionalChain([LINUX_VERSIONS, "access", (_21) => _21[id], "optionalCall", (_22) => _22(contents)]);
    } catch (e2) {
    }
    return linuxInfo;
  }
  function getCloudResourceContext() {
    if (process.env.VERCEL) {
      return {
        "cloud.provider": "vercel",
        "cloud.region": process.env.VERCEL_REGION
      };
    } else if (process.env.AWS_REGION) {
      return {
        "cloud.provider": "aws",
        "cloud.region": process.env.AWS_REGION,
        "cloud.platform": process.env.AWS_EXECUTION_ENV
      };
    } else if (process.env.GCP_PROJECT) {
      return {
        "cloud.provider": "gcp"
      };
    } else if (process.env.ALIYUN_REGION_ID) {
      return {
        "cloud.provider": "alibaba_cloud",
        "cloud.region": process.env.ALIYUN_REGION_ID
      };
    } else if (process.env.WEBSITE_SITE_NAME && process.env.REGION_NAME) {
      return {
        "cloud.provider": "azure",
        "cloud.region": process.env.REGION_NAME
      };
    } else if (process.env.IBM_CLOUD_REGION) {
      return {
        "cloud.provider": "ibm_cloud",
        "cloud.region": process.env.IBM_CLOUD_REGION
      };
    } else if (process.env.TENCENTCLOUD_REGION) {
      return {
        "cloud.provider": "tencent_cloud",
        "cloud.region": process.env.TENCENTCLOUD_REGION,
        "cloud.account.id": process.env.TENCENTCLOUD_APPID,
        "cloud.availability_zone": process.env.TENCENTCLOUD_ZONE
      };
    } else if (process.env.NETLIFY) {
      return {
        "cloud.provider": "netlify"
      };
    } else if (process.env.FLY_REGION) {
      return {
        "cloud.provider": "fly.io",
        "cloud.region": process.env.FLY_REGION
      };
    } else if (process.env.DYNO) {
      return {
        "cloud.provider": "heroku"
      };
    } else {
      return void 0;
    }
  }
  const LRU_FILE_CONTENTS_CACHE = new LRUMap(10);
  const LRU_FILE_CONTENTS_FS_READ_FAILED = new LRUMap(20);
  const DEFAULT_LINES_OF_CONTEXT = 7;
  const INTEGRATION_NAME$2 = "ContextLines";
  const MAX_CONTEXTLINES_COLNO = 1e3;
  const MAX_CONTEXTLINES_LINENO = 1e4;
  function emplace(map, key, contents) {
    const value = map.get(key);
    if (value === void 0) {
      map.set(key, contents);
      return contents;
    }
    return value;
  }
  function shouldSkipContextLinesForFile(path2) {
    if (path2.startsWith("node:")) return true;
    if (path2.endsWith(".min.js")) return true;
    if (path2.endsWith(".min.cjs")) return true;
    if (path2.endsWith(".min.mjs")) return true;
    if (path2.startsWith("data:")) return true;
    return false;
  }
  function shouldSkipContextLinesForFrame(frame) {
    if (frame.lineno !== void 0 && frame.lineno > MAX_CONTEXTLINES_LINENO) return true;
    if (frame.colno !== void 0 && frame.colno > MAX_CONTEXTLINES_COLNO) return true;
    return false;
  }
  function rangeExistsInContentCache(file2, range2) {
    const contents = LRU_FILE_CONTENTS_CACHE.get(file2);
    if (contents === void 0) return false;
    for (let i2 = range2[0]; i2 <= range2[1]; i2++) {
      if (contents[i2] === void 0) {
        return false;
      }
    }
    return true;
  }
  function makeLineReaderRanges(lines, linecontext) {
    if (!lines.length) {
      return [];
    }
    let i2 = 0;
    const line = lines[0];
    if (typeof line !== "number") {
      return [];
    }
    let current = makeContextRange(line, linecontext);
    const out = [];
    while (true) {
      if (i2 === lines.length - 1) {
        out.push(current);
        break;
      }
      const next = lines[i2 + 1];
      if (typeof next !== "number") {
        break;
      }
      if (next <= current[1]) {
        current[1] = next + linecontext;
      } else {
        out.push(current);
        current = makeContextRange(next, linecontext);
      }
      i2++;
    }
    return out;
  }
  function getContextLinesFromFile(path2, ranges, output) {
    return new Promise((resolve2, _reject) => {
      const stream2 = node_fs.createReadStream(path2);
      const lineReaded = node_readline.createInterface({
        input: stream2
      });
      let lineNumber = 0;
      let currentRangeIndex = 0;
      const range2 = ranges[currentRangeIndex];
      if (range2 === void 0) {
        resolve2();
        return;
      }
      let rangeStart = range2[0];
      let rangeEnd = range2[1];
      function onStreamError(e2) {
        LRU_FILE_CONTENTS_FS_READ_FAILED.set(path2, 1);
        DEBUG_BUILD && logger$2.error(`Failed to read file: ${path2}. Error: ${e2}`);
        lineReaded.close();
        lineReaded.removeAllListeners();
        resolve2();
      }
      stream2.on("error", onStreamError);
      lineReaded.on("error", onStreamError);
      lineReaded.on("close", resolve2);
      lineReaded.on("line", (line) => {
        lineNumber++;
        if (lineNumber < rangeStart) return;
        output[lineNumber] = snipLine(line, 0);
        if (lineNumber >= rangeEnd) {
          if (currentRangeIndex === ranges.length - 1) {
            lineReaded.close();
            lineReaded.removeAllListeners();
            return;
          }
          currentRangeIndex++;
          const range3 = ranges[currentRangeIndex];
          if (range3 === void 0) {
            lineReaded.close();
            lineReaded.removeAllListeners();
            return;
          }
          rangeStart = range3[0];
          rangeEnd = range3[1];
        }
      });
    });
  }
  async function addSourceContext(event, contextLines) {
    const filesToLines = {};
    if (contextLines > 0 && _optionalChain([event, "access", (_2) => _2.exception, "optionalAccess", (_2) => _2.values])) {
      for (const exception of event.exception.values) {
        if (!_optionalChain([exception, "access", (_3) => _3.stacktrace, "optionalAccess", (_4) => _4.frames, "optionalAccess", (_5) => _5.length])) {
          continue;
        }
        for (let i2 = exception.stacktrace.frames.length - 1; i2 >= 0; i2--) {
          const frame = exception.stacktrace.frames[i2];
          const filename = _optionalChain([frame, "optionalAccess", (_6) => _6.filename]);
          if (!frame || typeof filename !== "string" || typeof frame.lineno !== "number" || shouldSkipContextLinesForFile(filename) || shouldSkipContextLinesForFrame(frame)) {
            continue;
          }
          const filesToLinesOutput = filesToLines[filename];
          if (!filesToLinesOutput) filesToLines[filename] = [];
          filesToLines[filename].push(frame.lineno);
        }
      }
    }
    const files2 = Object.keys(filesToLines);
    if (files2.length == 0) {
      return event;
    }
    const readlinePromises = [];
    for (const file2 of files2) {
      if (LRU_FILE_CONTENTS_FS_READ_FAILED.get(file2)) {
        continue;
      }
      const filesToLineRanges = filesToLines[file2];
      if (!filesToLineRanges) {
        continue;
      }
      filesToLineRanges.sort((a2, b2) => a2 - b2);
      const ranges = makeLineReaderRanges(filesToLineRanges, contextLines);
      if (ranges.every((r2) => rangeExistsInContentCache(file2, r2))) {
        continue;
      }
      const cache = emplace(LRU_FILE_CONTENTS_CACHE, file2, {});
      readlinePromises.push(getContextLinesFromFile(file2, ranges, cache));
    }
    await Promise.all(readlinePromises).catch(() => {
      DEBUG_BUILD && logger$2.log("Failed to read one or more source files and resolve context lines");
    });
    if (contextLines > 0 && _optionalChain([event, "access", (_7) => _7.exception, "optionalAccess", (_8) => _8.values])) {
      for (const exception of event.exception.values) {
        if (exception.stacktrace && exception.stacktrace.frames && exception.stacktrace.frames.length > 0) {
          addSourceContextToFrames(exception.stacktrace.frames, contextLines, LRU_FILE_CONTENTS_CACHE);
        }
      }
    }
    return event;
  }
  function addSourceContextToFrames(frames, contextLines, cache) {
    for (const frame of frames) {
      if (frame.filename && frame.context_line === void 0 && typeof frame.lineno === "number") {
        const contents = cache.get(frame.filename);
        if (contents === void 0) {
          continue;
        }
        addContextToFrame(frame.lineno, frame, contextLines, contents);
      }
    }
  }
  function clearLineContext(frame) {
    delete frame.pre_context;
    delete frame.context_line;
    delete frame.post_context;
  }
  function addContextToFrame(lineno, frame, contextLines, contents) {
    if (frame.lineno === void 0 || contents === void 0) {
      DEBUG_BUILD && logger$2.error("Cannot resolve context for frame with no lineno or file contents");
      return;
    }
    frame.pre_context = [];
    for (let i2 = makeRangeStart(lineno, contextLines); i2 < lineno; i2++) {
      const line = contents[i2];
      if (line === void 0) {
        clearLineContext(frame);
        DEBUG_BUILD && logger$2.error(`Could not find line ${i2} in file ${frame.filename}`);
        return;
      }
      frame.pre_context.push(line);
    }
    if (contents[lineno] === void 0) {
      clearLineContext(frame);
      DEBUG_BUILD && logger$2.error(`Could not find line ${lineno} in file ${frame.filename}`);
      return;
    }
    frame.context_line = contents[lineno];
    const end = makeRangeEnd(lineno, contextLines);
    frame.post_context = [];
    for (let i2 = lineno + 1; i2 <= end; i2++) {
      const line = contents[i2];
      if (line === void 0) {
        break;
      }
      frame.post_context.push(line);
    }
  }
  function makeRangeStart(line, linecontext) {
    return Math.max(1, line - linecontext);
  }
  function makeRangeEnd(line, linecontext) {
    return line + linecontext;
  }
  function makeContextRange(line, linecontext) {
    return [makeRangeStart(line, linecontext), makeRangeEnd(line, linecontext)];
  }
  const _contextLinesIntegration = (options = {}) => {
    const contextLines = options.frameContextLines !== void 0 ? options.frameContextLines : DEFAULT_LINES_OF_CONTEXT;
    return {
      name: INTEGRATION_NAME$2,
      processEvent(event) {
        return addSourceContext(event, contextLines);
      }
    };
  };
  const contextLinesIntegration = defineIntegration(_contextLinesIntegration);
  const NODE_VERSION = parseSemver(process.versions.node);
  const NODE_MAJOR = NODE_VERSION.major;
  const LOCAL_VARIABLES_KEY = "__SENTRY_ERROR_LOCAL_VARIABLES__";
  function createRateLimiter(maxPerSecond, enable, disable) {
    let count = 0;
    let retrySeconds = 5;
    let disabledTimeout = 0;
    setInterval(() => {
      if (disabledTimeout === 0) {
        if (count > maxPerSecond) {
          retrySeconds *= 2;
          disable(retrySeconds);
          if (retrySeconds > 86400) {
            retrySeconds = 86400;
          }
          disabledTimeout = retrySeconds;
        }
      } else {
        disabledTimeout -= 1;
        if (disabledTimeout === 0) {
          enable();
        }
      }
      count = 0;
    }, 1e3).unref();
    return () => {
      count += 1;
    };
  }
  function isAnonymous(name2) {
    return name2 !== void 0 && (name2.length === 0 || name2 === "?" || name2 === "<anonymous>");
  }
  function functionNamesMatch(a2, b2) {
    return a2 === b2 || isAnonymous(a2) && isAnonymous(b2);
  }
  const base64WorkerScript = "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";
  function log$1(...args2) {
    logger$2.log("[LocalVariables]", ...args2);
  }
  const localVariablesAsyncIntegration = defineIntegration((integrationOptions = {}) => {
    function addLocalVariablesToException(exception, localVariables) {
      const frames = (_optionalChain([exception, "access", (_2) => _2.stacktrace, "optionalAccess", (_2) => _2.frames]) || []).filter((frame) => frame.function !== "new Promise");
      for (let i2 = 0; i2 < frames.length; i2++) {
        const frameIndex = frames.length - i2 - 1;
        const frameLocalVariables = localVariables[i2];
        const frame = frames[frameIndex];
        if (!frame || !frameLocalVariables) {
          break;
        }
        if (
          // We need to have vars to add
          frameLocalVariables.vars === void 0 || // We're not interested in frames that are not in_app because the vars are not relevant
          frame.in_app === false || // The function names need to match
          !functionNamesMatch(frame.function, frameLocalVariables.function)
        ) {
          continue;
        }
        frame.vars = frameLocalVariables.vars;
      }
    }
    function addLocalVariablesToEvent(event, hint) {
      if (hint.originalException && typeof hint.originalException === "object" && LOCAL_VARIABLES_KEY in hint.originalException && Array.isArray(hint.originalException[LOCAL_VARIABLES_KEY])) {
        for (const exception of _optionalChain([event, "access", (_3) => _3.exception, "optionalAccess", (_4) => _4.values]) || []) {
          addLocalVariablesToException(exception, hint.originalException[LOCAL_VARIABLES_KEY]);
        }
        hint.originalException[LOCAL_VARIABLES_KEY] = void 0;
      }
      return event;
    }
    async function startInspector() {
      const inspector2 = await import("node:inspector");
      if (!inspector2.url()) {
        inspector2.open(0);
      }
    }
    function startWorker(options) {
      const worker = new node_worker_threads.Worker(new URL(`data:application/javascript;base64,${base64WorkerScript}`), {
        workerData: options,
        // We don't want any Node args to be passed to the worker
        execArgv: []
      });
      process.on("exit", () => {
        worker.terminate();
      });
      worker.once("error", (err) => {
        log$1("Worker error", err);
      });
      worker.once("exit", (code) => {
        log$1("Worker exit", code);
      });
      worker.unref();
    }
    return {
      name: "LocalVariablesAsync",
      setup(client) {
        const clientOptions = client.getOptions();
        if (!clientOptions.includeLocalVariables) {
          return;
        }
        const options = {
          ...integrationOptions,
          debug: logger$2.isEnabled()
        };
        startInspector().then(
          () => {
            try {
              startWorker(options);
            } catch (e2) {
              logger$2.error("Failed to start worker", e2);
            }
          },
          (e2) => {
            logger$2.error("Failed to start inspector", e2);
          }
        );
      },
      processEvent(event, hint) {
        return addLocalVariablesToEvent(event, hint);
      }
    };
  });
  function hashFrames(frames) {
    if (frames === void 0) {
      return;
    }
    return frames.slice(-10).reduce((acc, frame) => `${acc},${frame.function},${frame.lineno},${frame.colno}`, "");
  }
  function hashFromStack(stackParser, stack) {
    if (stack === void 0) {
      return void 0;
    }
    return hashFrames(stackParser(stack, 1));
  }
  function createCallbackList(complete) {
    let callbacks = [];
    let completedCalled = false;
    function checkedComplete(result) {
      callbacks = [];
      if (completedCalled) {
        return;
      }
      completedCalled = true;
      complete(result);
    }
    callbacks.push(checkedComplete);
    function add(fn) {
      callbacks.push(fn);
    }
    function next(result) {
      const popped = callbacks.pop() || checkedComplete;
      try {
        popped(result);
      } catch (_2) {
        checkedComplete(result);
      }
    }
    return { add, next };
  }
  class AsyncSession {
    /** Throws if inspector API is not available */
    constructor(_session) {
      this._session = _session;
    }
    static async create(orDefault) {
      if (orDefault) {
        return orDefault;
      }
      const inspector2 = await import("node:inspector");
      return new AsyncSession(new inspector2.Session());
    }
    /** @inheritdoc */
    configureAndConnect(onPause, captureAll) {
      this._session.connect();
      this._session.on("Debugger.paused", (event) => {
        onPause(event, () => {
          this._session.post("Debugger.resume");
        });
      });
      this._session.post("Debugger.enable");
      this._session.post("Debugger.setPauseOnExceptions", { state: captureAll ? "all" : "uncaught" });
    }
    setPauseOnExceptions(captureAll) {
      this._session.post("Debugger.setPauseOnExceptions", { state: captureAll ? "all" : "uncaught" });
    }
    /** @inheritdoc */
    getLocalVariables(objectId, complete) {
      this._getProperties(objectId, (props) => {
        const { add, next } = createCallbackList(complete);
        for (const prop of props) {
          if (_optionalChain([prop, "optionalAccess", (_2) => _2.value, "optionalAccess", (_3) => _3.objectId]) && _optionalChain([prop, "optionalAccess", (_4) => _4.value, "access", (_5) => _5.className]) === "Array") {
            const id = prop.value.objectId;
            add((vars) => this._unrollArray(id, prop.name, vars, next));
          } else if (_optionalChain([prop, "optionalAccess", (_6) => _6.value, "optionalAccess", (_7) => _7.objectId]) && _optionalChain([prop, "optionalAccess", (_8) => _8.value, "optionalAccess", (_9) => _9.className]) === "Object") {
            const id = prop.value.objectId;
            add((vars) => this._unrollObject(id, prop.name, vars, next));
          } else if (_optionalChain([prop, "optionalAccess", (_10) => _10.value])) {
            add((vars) => this._unrollOther(prop, vars, next));
          }
        }
        next({});
      });
    }
    /**
     * Gets all the PropertyDescriptors of an object
     */
    _getProperties(objectId, next) {
      this._session.post(
        "Runtime.getProperties",
        {
          objectId,
          ownProperties: true
        },
        (err, params) => {
          if (err) {
            next([]);
          } else {
            next(params.result);
          }
        }
      );
    }
    /**
     * Unrolls an array property
     */
    _unrollArray(objectId, name2, vars, next) {
      this._getProperties(objectId, (props) => {
        vars[name2] = props.filter((v2) => v2.name !== "length" && !isNaN(parseInt(v2.name, 10))).sort((a2, b2) => parseInt(a2.name, 10) - parseInt(b2.name, 10)).map((v2) => _optionalChain([v2, "optionalAccess", (_11) => _11.value, "optionalAccess", (_12) => _12.value]));
        next(vars);
      });
    }
    /**
     * Unrolls an object property
     */
    _unrollObject(objectId, name2, vars, next) {
      this._getProperties(objectId, (props) => {
        vars[name2] = props.map((v2) => [v2.name, _optionalChain([v2, "optionalAccess", (_13) => _13.value, "optionalAccess", (_14) => _14.value])]).reduce((obj, [key, val]) => {
          obj[key] = val;
          return obj;
        }, {});
        next(vars);
      });
    }
    /**
     * Unrolls other properties
     */
    _unrollOther(prop, vars, next) {
      if (prop.value) {
        if ("value" in prop.value) {
          if (prop.value.value === void 0 || prop.value.value === null) {
            vars[prop.name] = `<${prop.value.value}>`;
          } else {
            vars[prop.name] = prop.value.value;
          }
        } else if ("description" in prop.value && prop.value.type !== "function") {
          vars[prop.name] = `<${prop.value.description}>`;
        } else if (prop.value.type === "undefined") {
          vars[prop.name] = "<undefined>";
        }
      }
      next(vars);
    }
  }
  const INTEGRATION_NAME$1 = "LocalVariables";
  const _localVariablesSyncIntegration = (options = {}, sessionOverride) => {
    const cachedFrames = new LRUMap(20);
    let rateLimiter;
    let shouldProcessEvent = false;
    function addLocalVariablesToException(exception) {
      const hash = hashFrames(_optionalChain([exception, "optionalAccess", (_15) => _15.stacktrace, "optionalAccess", (_16) => _16.frames]));
      if (hash === void 0) {
        return;
      }
      const cachedFrame = cachedFrames.remove(hash);
      if (cachedFrame === void 0) {
        return;
      }
      const frames = (_optionalChain([exception, "access", (_17) => _17.stacktrace, "optionalAccess", (_18) => _18.frames]) || []).filter((frame) => frame.function !== "new Promise");
      for (let i2 = 0; i2 < frames.length; i2++) {
        const frameIndex = frames.length - i2 - 1;
        const cachedFrameVariable = cachedFrame[i2];
        const frameVariable = frames[frameIndex];
        if (!frameVariable || !cachedFrameVariable) {
          break;
        }
        if (
          // We need to have vars to add
          cachedFrameVariable.vars === void 0 || // We're not interested in frames that are not in_app because the vars are not relevant
          frameVariable.in_app === false || // The function names need to match
          !functionNamesMatch(frameVariable.function, cachedFrameVariable.function)
        ) {
          continue;
        }
        frameVariable.vars = cachedFrameVariable.vars;
      }
    }
    function addLocalVariablesToEvent(event) {
      for (const exception of _optionalChain([event, "optionalAccess", (_19) => _19.exception, "optionalAccess", (_20) => _20.values]) || []) {
        addLocalVariablesToException(exception);
      }
      return event;
    }
    return {
      name: INTEGRATION_NAME$1,
      setupOnce() {
        const client = getClient();
        const clientOptions = _optionalChain([client, "optionalAccess", (_21) => _21.getOptions, "call", (_22) => _22()]);
        if (!_optionalChain([clientOptions, "optionalAccess", (_23) => _23.includeLocalVariables])) {
          return;
        }
        const unsupportedNodeVersion = NODE_MAJOR < 18;
        if (unsupportedNodeVersion) {
          logger$2.log("The `LocalVariables` integration is only supported on Node >= v18.");
          return;
        }
        AsyncSession.create(sessionOverride).then(
          (session) => {
            function handlePaused(stackParser, { params: { reason, data: data2, callFrames } }, complete) {
              if (reason !== "exception" && reason !== "promiseRejection") {
                complete();
                return;
              }
              _optionalChain([rateLimiter, "optionalCall", (_24) => _24()]);
              const exceptionHash = hashFromStack(stackParser, _optionalChain([data2, "optionalAccess", (_25) => _25.description]));
              if (exceptionHash == void 0) {
                complete();
                return;
              }
              const { add, next } = createCallbackList((frames) => {
                cachedFrames.set(exceptionHash, frames);
                complete();
              });
              for (let i2 = 0; i2 < Math.min(callFrames.length, 5); i2++) {
                const { scopeChain, functionName, this: obj } = callFrames[i2];
                const localScope = scopeChain.find((scope2) => scope2.type === "local");
                const fn = obj.className === "global" || !obj.className ? functionName : `${obj.className}.${functionName}`;
                if (_optionalChain([localScope, "optionalAccess", (_26) => _26.object, "access", (_27) => _27.objectId]) === void 0) {
                  add((frames) => {
                    frames[i2] = { function: fn };
                    next(frames);
                  });
                } else {
                  const id = localScope.object.objectId;
                  add(
                    (frames) => _optionalChain([session, "optionalAccess", (_28) => _28.getLocalVariables, "call", (_29) => _29(id, (vars) => {
                      frames[i2] = { function: fn, vars };
                      next(frames);
                    })])
                  );
                }
              }
              next([]);
            }
            const captureAll = options.captureAllExceptions !== false;
            session.configureAndConnect(
              (ev, complete) => handlePaused(clientOptions.stackParser, ev, complete),
              captureAll
            );
            if (captureAll) {
              const max2 = options.maxExceptionsPerSecond || 50;
              rateLimiter = createRateLimiter(
                max2,
                () => {
                  logger$2.log("Local variables rate-limit lifted.");
                  _optionalChain([session, "optionalAccess", (_30) => _30.setPauseOnExceptions, "call", (_31) => _31(true)]);
                },
                (seconds) => {
                  logger$2.log(
                    `Local variables rate-limit exceeded. Disabling capturing of caught exceptions for ${seconds} seconds.`
                  );
                  _optionalChain([session, "optionalAccess", (_32) => _32.setPauseOnExceptions, "call", (_33) => _33(false)]);
                }
              );
            }
            shouldProcessEvent = true;
          },
          (error2) => {
            logger$2.log("The `LocalVariables` integration failed to start.", error2);
          }
        );
      },
      processEvent(event) {
        if (shouldProcessEvent) {
          return addLocalVariablesToEvent(event);
        }
        return event;
      },
      // These are entirely for testing
      _getCachedFramesCount() {
        return cachedFrames.size;
      },
      _getFirstCachedFrame() {
        return cachedFrames.values()[0];
      }
    };
  };
  const localVariablesSyncIntegration = defineIntegration(_localVariablesSyncIntegration);
  const localVariablesIntegration = (options = {}) => {
    return NODE_VERSION.major < 19 ? localVariablesSyncIntegration(options) : localVariablesAsyncIntegration(options);
  };
  const DEFAULT_SHUTDOWN_TIMEOUT = 2e3;
  function logAndExitProcess(error2) {
    consoleSandbox(() => {
      console.error(error2);
    });
    const client = getClient();
    if (client === void 0) {
      DEBUG_BUILD && logger$2.warn("No NodeClient was defined, we are exiting the process now.");
      global.process.exit(1);
      return;
    }
    const options = client.getOptions();
    const timeout = options && options.shutdownTimeout && options.shutdownTimeout > 0 && options.shutdownTimeout || DEFAULT_SHUTDOWN_TIMEOUT;
    client.close(timeout).then(
      (result) => {
        if (!result) {
          DEBUG_BUILD && logger$2.warn("We reached the timeout for emptying the request buffer, still exiting now!");
        }
        global.process.exit(1);
      },
      (error3) => {
        DEBUG_BUILD && logger$2.error(error3);
      }
    );
  }
  const INTEGRATION_NAME = "OnUnhandledRejection";
  const _onUnhandledRejectionIntegration = (options = {}) => {
    const mode2 = options.mode || "warn";
    return {
      name: INTEGRATION_NAME,
      setup(client) {
        global.process.on("unhandledRejection", makeUnhandledPromiseHandler(client, { mode: mode2 }));
      }
    };
  };
  const onUnhandledRejectionIntegration = defineIntegration(_onUnhandledRejectionIntegration);
  function makeUnhandledPromiseHandler(client, options) {
    return function sendUnhandledPromise(reason, promise2) {
      if (getClient() !== client) {
        return;
      }
      captureException(reason, {
        originalException: promise2,
        captureContext: {
          extra: { unhandledPromiseRejection: true }
        },
        mechanism: {
          handled: false,
          type: "onunhandledrejection"
        }
      });
      handleRejection(reason, options);
    };
  }
  function handleRejection(reason, options) {
    const rejectionWarning = "This error originated either by throwing inside of an async function without a catch block, or by rejecting a promise which was not handled with .catch(). The promise rejected with the reason:";
    if (options.mode === "warn") {
      consoleSandbox(() => {
        console.warn(rejectionWarning);
        console.error(reason && reason.stack ? reason.stack : reason);
      });
    } else if (options.mode === "strict") {
      consoleSandbox(() => {
        console.warn(rejectionWarning);
      });
      logAndExitProcess(reason);
    }
  }
  var src$2 = {};
  var AsyncHooksContextManager$1 = {};
  var AbstractAsyncHooksContextManager$1 = {};
  Object.defineProperty(AbstractAsyncHooksContextManager$1, "__esModule", { value: true });
  AbstractAsyncHooksContextManager$1.AbstractAsyncHooksContextManager = void 0;
  const events_1 = require$$0$5;
  const ADD_LISTENER_METHODS = [
    "addListener",
    "on",
    "once",
    "prependListener",
    "prependOnceListener"
  ];
  class AbstractAsyncHooksContextManager {
    constructor() {
      this._kOtListeners = Symbol("OtListeners");
      this._wrapped = false;
    }
    /**
     * Binds a the certain context or the active one to the target function and then returns the target
     * @param context A context (span) to be bind to target
     * @param target a function or event emitter. When target or one of its callbacks is called,
     *  the provided context will be used as the active context for the duration of the call.
     */
    bind(context2, target) {
      if (target instanceof events_1.EventEmitter) {
        return this._bindEventEmitter(context2, target);
      }
      if (typeof target === "function") {
        return this._bindFunction(context2, target);
      }
      return target;
    }
    _bindFunction(context2, target) {
      const manager = this;
      const contextWrapper = function(...args2) {
        return manager.with(context2, () => target.apply(this, args2));
      };
      Object.defineProperty(contextWrapper, "length", {
        enumerable: false,
        configurable: true,
        writable: false,
        value: target.length
      });
      return contextWrapper;
    }
    /**
     * By default, EventEmitter call their callback with their context, which we do
     * not want, instead we will bind a specific context to all callbacks that
     * go through it.
     * @param context the context we want to bind
     * @param ee EventEmitter an instance of EventEmitter to patch
     */
    _bindEventEmitter(context2, ee2) {
      const map = this._getPatchMap(ee2);
      if (map !== void 0)
        return ee2;
      this._createPatchMap(ee2);
      ADD_LISTENER_METHODS.forEach((methodName) => {
        if (ee2[methodName] === void 0)
          return;
        ee2[methodName] = this._patchAddListener(ee2, ee2[methodName], context2);
      });
      if (typeof ee2.removeListener === "function") {
        ee2.removeListener = this._patchRemoveListener(ee2, ee2.removeListener);
      }
      if (typeof ee2.off === "function") {
        ee2.off = this._patchRemoveListener(ee2, ee2.off);
      }
      if (typeof ee2.removeAllListeners === "function") {
        ee2.removeAllListeners = this._patchRemoveAllListeners(ee2, ee2.removeAllListeners);
      }
      return ee2;
    }
    /**
     * Patch methods that remove a given listener so that we match the "patched"
     * version of that listener (the one that propagate context).
     * @param ee EventEmitter instance
     * @param original reference to the patched method
     */
    _patchRemoveListener(ee2, original) {
      const contextManager = this;
      return function(event, listener) {
        var _a3;
        const events2 = (_a3 = contextManager._getPatchMap(ee2)) === null || _a3 === void 0 ? void 0 : _a3[event];
        if (events2 === void 0) {
          return original.call(this, event, listener);
        }
        const patchedListener = events2.get(listener);
        return original.call(this, event, patchedListener || listener);
      };
    }
    /**
     * Patch methods that remove all listeners so we remove our
     * internal references for a given event.
     * @param ee EventEmitter instance
     * @param original reference to the patched method
     */
    _patchRemoveAllListeners(ee2, original) {
      const contextManager = this;
      return function(event) {
        const map = contextManager._getPatchMap(ee2);
        if (map !== void 0) {
          if (arguments.length === 0) {
            contextManager._createPatchMap(ee2);
          } else if (map[event] !== void 0) {
            delete map[event];
          }
        }
        return original.apply(this, arguments);
      };
    }
    /**
     * Patch methods on an event emitter instance that can add listeners so we
     * can force them to propagate a given context.
     * @param ee EventEmitter instance
     * @param original reference to the patched method
     * @param [context] context to propagate when calling listeners
     */
    _patchAddListener(ee2, original, context2) {
      const contextManager = this;
      return function(event, listener) {
        if (contextManager._wrapped) {
          return original.call(this, event, listener);
        }
        let map = contextManager._getPatchMap(ee2);
        if (map === void 0) {
          map = contextManager._createPatchMap(ee2);
        }
        let listeners = map[event];
        if (listeners === void 0) {
          listeners = /* @__PURE__ */ new WeakMap();
          map[event] = listeners;
        }
        const patchedListener = contextManager.bind(context2, listener);
        listeners.set(listener, patchedListener);
        contextManager._wrapped = true;
        try {
          return original.call(this, event, patchedListener);
        } finally {
          contextManager._wrapped = false;
        }
      };
    }
    _createPatchMap(ee2) {
      const map = /* @__PURE__ */ Object.create(null);
      ee2[this._kOtListeners] = map;
      return map;
    }
    _getPatchMap(ee2) {
      return ee2[this._kOtListeners];
    }
  }
  AbstractAsyncHooksContextManager$1.AbstractAsyncHooksContextManager = AbstractAsyncHooksContextManager;
  Object.defineProperty(AsyncHooksContextManager$1, "__esModule", { value: true });
  AsyncHooksContextManager$1.AsyncHooksContextManager = void 0;
  const api_1$1 = require$$0;
  const asyncHooks = require$$1$4;
  const AbstractAsyncHooksContextManager_1$1 = AbstractAsyncHooksContextManager$1;
  class AsyncHooksContextManager extends AbstractAsyncHooksContextManager_1$1.AbstractAsyncHooksContextManager {
    constructor() {
      super();
      this._contexts = /* @__PURE__ */ new Map();
      this._stack = [];
      this._asyncHook = asyncHooks.createHook({
        init: this._init.bind(this),
        before: this._before.bind(this),
        after: this._after.bind(this),
        destroy: this._destroy.bind(this),
        promiseResolve: this._destroy.bind(this)
      });
    }
    active() {
      var _a3;
      return (_a3 = this._stack[this._stack.length - 1]) !== null && _a3 !== void 0 ? _a3 : api_1$1.ROOT_CONTEXT;
    }
    with(context2, fn, thisArg, ...args2) {
      this._enterContext(context2);
      try {
        return fn.call(thisArg, ...args2);
      } finally {
        this._exitContext();
      }
    }
    enable() {
      this._asyncHook.enable();
      return this;
    }
    disable() {
      this._asyncHook.disable();
      this._contexts.clear();
      this._stack = [];
      return this;
    }
    /**
     * Init hook will be called when userland create a async context, setting the
     * context as the current one if it exist.
     * @param uid id of the async context
     * @param type the resource type
     */
    _init(uid, type2) {
      if (type2 === "TIMERWRAP")
        return;
      const context2 = this._stack[this._stack.length - 1];
      if (context2 !== void 0) {
        this._contexts.set(uid, context2);
      }
    }
    /**
     * Destroy hook will be called when a given context is no longer used so we can
     * remove its attached context.
     * @param uid uid of the async context
     */
    _destroy(uid) {
      this._contexts.delete(uid);
    }
    /**
     * Before hook is called just before executing a async context.
     * @param uid uid of the async context
     */
    _before(uid) {
      const context2 = this._contexts.get(uid);
      if (context2 !== void 0) {
        this._enterContext(context2);
      }
    }
    /**
     * After hook is called just after completing the execution of a async context.
     */
    _after() {
      this._exitContext();
    }
    /**
     * Set the given context as active
     */
    _enterContext(context2) {
      this._stack.push(context2);
    }
    /**
     * Remove the context at the root of the stack
     */
    _exitContext() {
      this._stack.pop();
    }
  }
  AsyncHooksContextManager$1.AsyncHooksContextManager = AsyncHooksContextManager;
  var AsyncLocalStorageContextManager$1 = {};
  Object.defineProperty(AsyncLocalStorageContextManager$1, "__esModule", { value: true });
  AsyncLocalStorageContextManager$1.AsyncLocalStorageContextManager = void 0;
  const api_1 = require$$0;
  const async_hooks_1 = require$$1$4;
  const AbstractAsyncHooksContextManager_1 = AbstractAsyncHooksContextManager$1;
  class AsyncLocalStorageContextManager extends AbstractAsyncHooksContextManager_1.AbstractAsyncHooksContextManager {
    constructor() {
      super();
      this._asyncLocalStorage = new async_hooks_1.AsyncLocalStorage();
    }
    active() {
      var _a3;
      return (_a3 = this._asyncLocalStorage.getStore()) !== null && _a3 !== void 0 ? _a3 : api_1.ROOT_CONTEXT;
    }
    with(context2, fn, thisArg, ...args2) {
      const cb = thisArg == null ? fn : fn.bind(thisArg);
      return this._asyncLocalStorage.run(context2, cb, ...args2);
    }
    enable() {
      return this;
    }
    disable() {
      this._asyncLocalStorage.disable();
      return this;
    }
  }
  AsyncLocalStorageContextManager$1.AsyncLocalStorageContextManager = AsyncLocalStorageContextManager;
  (function(exports2) {
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.AsyncLocalStorageContextManager = exports2.AsyncHooksContextManager = void 0;
    var AsyncHooksContextManager_1 = AsyncHooksContextManager$1;
    Object.defineProperty(exports2, "AsyncHooksContextManager", { enumerable: true, get: function() {
      return AsyncHooksContextManager_1.AsyncHooksContextManager;
    } });
    var AsyncLocalStorageContextManager_1 = AsyncLocalStorageContextManager$1;
    Object.defineProperty(exports2, "AsyncLocalStorageContextManager", { enumerable: true, get: function() {
      return AsyncLocalStorageContextManager_1.AsyncLocalStorageContextManager;
    } });
  })(src$2);
  const SentryContextManager = wrapContextManagerClass(src$2.AsyncLocalStorageContextManager);
  function normalizeWindowsPath(path2) {
    return path2.replace(/^[A-Z]:/, "").replace(/\\/g, "/");
  }
  function createGetModuleFromFilename(basePath = process.argv[1] ? dirname(process.argv[1]) : process.cwd(), isWindows2 = path$l.sep === "\\") {
    const normalizedBase = isWindows2 ? normalizeWindowsPath(basePath) : basePath;
    return (filename) => {
      if (!filename) {
        return;
      }
      const normalizedFilename = isWindows2 ? normalizeWindowsPath(filename) : filename;
      let { dir, base: file2, ext } = path$l.posix.parse(normalizedFilename);
      if (ext === ".js" || ext === ".mjs" || ext === ".cjs") {
        file2 = file2.slice(0, ext.length * -1);
      }
      if (!dir) {
        dir = ".";
      }
      const n2 = dir.lastIndexOf("/node_modules");
      if (n2 > -1) {
        return `${dir.slice(n2 + 14).replace(/\//g, ".")}:${file2}`;
      }
      if (dir.startsWith(normalizedBase)) {
        let moduleName2 = dir.slice(normalizedBase.length + 1).replace(/\//g, ".");
        if (moduleName2) {
          moduleName2 += ":";
        }
        moduleName2 += file2;
        return moduleName2;
      }
      return file2;
    };
  }
  const DEFAULT_CLIENT_REPORT_FLUSH_INTERVAL_MS = 6e4;
  class NodeClient extends ServerRuntimeClient {
    constructor(options) {
      const clientOptions = {
        ...options,
        platform: "node",
        runtime: { name: "node", version: global.process.version },
        serverName: options.serverName || global.process.env.SENTRY_NAME || os__namespace.hostname()
      };
      if (options.openTelemetryInstrumentations) {
        registerInstrumentations$1({
          instrumentations: options.openTelemetryInstrumentations
        });
      }
      applySdkMetadata(clientOptions, "node");
      logger$2.log(
        `Initializing Sentry: process: ${process.pid}, thread: ${require$$3.isMainThread ? "main" : `worker-${require$$3.threadId}`}.`
      );
      super(clientOptions);
    }
    /** Get the OTEL tracer. */
    get tracer() {
      if (this._tracer) {
        return this._tracer;
      }
      const name2 = "@sentry/node";
      const version2 = SDK_VERSION$1;
      const tracer = trace.getTracer(name2, version2);
      this._tracer = tracer;
      return tracer;
    }
    // Eslint ignore explanation: This is already documented in super.
    // eslint-disable-next-line jsdoc/require-jsdoc
    async flush(timeout) {
      const provider = this.traceProvider;
      const spanProcessor = _optionalChain([provider, "optionalAccess", (_2) => _2.activeSpanProcessor]);
      if (spanProcessor) {
        await spanProcessor.forceFlush();
      }
      if (this.getOptions().sendClientReports) {
        this._flushOutcomes();
      }
      return super.flush(timeout);
    }
    // Eslint ignore explanation: This is already documented in super.
    // eslint-disable-next-line jsdoc/require-jsdoc
    close(timeout) {
      if (this._clientReportInterval) {
        clearInterval(this._clientReportInterval);
      }
      if (this._clientReportOnExitFlushListener) {
        process.off("beforeExit", this._clientReportOnExitFlushListener);
      }
      return super.close(timeout);
    }
    /**
     * Will start tracking client reports for this client.
     *
     * NOTICE: This method will create an interval that is periodically called and attach a `process.on('beforeExit')`
     * hook. To clean up these resources, call `.close()` when you no longer intend to use the client. Not doing so will
     * result in a memory leak.
     */
    // The reason client reports need to be manually activated with this method instead of just enabling them in a
    // constructor, is that if users periodically and unboundedly create new clients, we will create more and more
    // intervals and beforeExit listeners, thus leaking memory. In these situations, users are required to call
    // `client.close()` in order to dispose of the acquired resources.
    // We assume that calling this method in Sentry.init() is a sensible default, because calling Sentry.init() over and
    // over again would also result in memory leaks.
    // Note: We have experimented with using `FinalizationRegisty` to clear the interval when the client is garbage
    // collected, but it did not work, because the cleanup function never got called.
    startClientReportTracking() {
      const clientOptions = this.getOptions();
      if (clientOptions.sendClientReports) {
        this._clientReportOnExitFlushListener = () => {
          this._flushOutcomes();
        };
        this._clientReportInterval = setInterval(
          () => {
            DEBUG_BUILD && logger$2.log("Flushing client reports based on interval.");
            this._flushOutcomes();
          },
          _nullishCoalesce(clientOptions.clientReportFlushInterval, () => DEFAULT_CLIENT_REPORT_FLUSH_INTERVAL_MS)
        ).unref();
        process.on("beforeExit", this._clientReportOnExitFlushListener);
      }
    }
    /** Custom implementation for OTEL, so we can handle scope-span linking. */
    _getTraceInfoFromScope(scope2) {
      if (!scope2) {
        return [void 0, void 0];
      }
      return getTraceContextForScope(this, scope2);
    }
  }
  function initOpenTelemetry(client) {
    if (client.getOptions().debug) {
      setupOpenTelemetryLogger();
    }
    const provider = setupOtel(client);
    client.traceProvider = provider;
  }
  function setupOtel(client) {
    const provider = new BasicTracerProvider({
      sampler: new SentrySampler(client),
      resource: new Resource({
        [ATTR_SERVICE_NAME]: "node",
        // eslint-disable-next-line deprecation/deprecation
        [SEMRESATTRS_SERVICE_NAMESPACE]: "sentry",
        [ATTR_SERVICE_VERSION]: SDK_VERSION$1
      }),
      forceFlushTimeoutMillis: 500
    });
    provider.addSpanProcessor(
      new SentrySpanProcessor({
        timeout: client.getOptions().maxSpanWaitDuration
      })
    );
    provider.register({
      propagator: new SentryPropagator(),
      contextManager: new SentryContextManager()
    });
    return provider;
  }
  function setupOpenTelemetryLogger() {
    const otelLogger = new Proxy(logger$2, {
      get(target, prop, receiver) {
        const actualProp = prop === "verbose" ? "debug" : prop;
        return Reflect.get(target, actualProp, receiver);
      }
    });
    diag.disable();
    diag.setLogger(otelLogger, DiagLogLevel.DEBUG);
  }
  let RENDERERS;
  function trackRendererProperties() {
    if (RENDERERS) {
      return;
    }
    const renderers = RENDERERS = /* @__PURE__ */ new Map();
    function updateUrl(id, url2) {
      const state = renderers.get(id) || { id };
      state.url = normalizeUrlToBase(url2, electron$1.app.getAppPath());
      renderers.set(id, state);
    }
    function updateTitle(id, title) {
      const state = renderers.get(id) || { id };
      state.title = title;
      renderers.set(id, state);
    }
    electron$1.app.on("web-contents-created", (_2, contents) => {
      const id = contents.id;
      contents.on("did-navigate", (_3, url2) => updateUrl(id, url2));
      contents.on("did-navigate-in-page", (_3, url2) => updateUrl(id, url2));
      contents.on("page-title-updated", (_3, title) => updateTitle(id, title));
      contents.on("destroyed", () => {
        setTimeout(() => {
          renderers.delete(id);
        }, 5e3);
      });
    });
  }
  function getRendererProperties(id) {
    return RENDERERS == null ? void 0 : RENDERERS.get(id);
  }
  const DEFAULT_OPTIONS$2 = {
    // We exclude events starting with remote as they can be quite verbose
    app: (name2) => !name2.startsWith("remote-"),
    autoUpdater: () => true,
    webContents: (name2) => ["dom-ready", "context-menu", "load-url", "destroyed"].includes(name2),
    browserWindow: (name2) => [
      "closed",
      "close",
      "unresponsive",
      "responsive",
      "show",
      "blur",
      "focus",
      "hide",
      "maximize",
      "minimize",
      "restore",
      "enter-full-screen",
      "leave-full-screen"
    ].includes(name2),
    screen: () => true,
    powerMonitor: () => true,
    captureWindowTitles: false
  };
  function normalizeOptions(options) {
    return Object.keys(options).reduce((obj, k2) => {
      if (k2 === "captureWindowTitles") {
        obj[k2] = !!options[k2];
      } else {
        const val = options[k2];
        if (Array.isArray(val)) {
          obj[k2] = (name2) => val.includes(name2);
        } else if (typeof val === "function" || val === false) {
          obj[k2] = val;
        }
      }
      return obj;
    }, {});
  }
  const electronBreadcrumbsIntegration = defineIntegration((userOptions = {}) => {
    const options = {
      ...DEFAULT_OPTIONS$2,
      ...normalizeOptions(userOptions)
    };
    function patchEventEmitter(emitter2, category, shouldCapture, id) {
      const emit2 = emitter2.emit.bind(emitter2);
      emitter2.emit = (event, ...args2) => {
        var _a3, _b2;
        if (shouldCapture && shouldCapture(event)) {
          const breadcrumb = {
            category: "electron",
            message: `${category}.${event}`,
            timestamp: (/* @__PURE__ */ new Date()).getTime() / 1e3,
            type: "ui"
          };
          if (id) {
            breadcrumb.data = { ...getRendererProperties(id) };
            if (!options.captureWindowTitles && ((_a3 = breadcrumb.data) == null ? void 0 : _a3.title)) {
              (_b2 = breadcrumb.data) == null ? true : delete _b2.title;
            }
          }
          addBreadcrumb(breadcrumb);
        }
        return emit2(event, ...args2);
      };
    }
    return {
      name: "ElectronBreadcrumbs",
      setup(client) {
        const clientOptions = client.getOptions();
        trackRendererProperties();
        electron$1.app.whenReady().then(() => {
          if (options.screen) {
            patchEventEmitter(electron$1.screen, "screen", options.screen);
          }
          if (options.powerMonitor) {
            patchEventEmitter(electron$1.powerMonitor, "powerMonitor", options.powerMonitor);
          }
        }, () => {
        });
        if (options.app) {
          patchEventEmitter(electron$1.app, "app", options.app);
        }
        if (options.autoUpdater) {
          patchEventEmitter(electron$1.autoUpdater, "autoUpdater", options.autoUpdater);
        }
        if (options.browserWindow) {
          electron$1.app.on("browser-window-created", (_2, window2) => {
            var _a3;
            const id = window2.webContents.id;
            const windowName = ((_a3 = clientOptions == null ? void 0 : clientOptions.getRendererName) == null ? void 0 : _a3.call(clientOptions, window2.webContents)) || "window";
            patchEventEmitter(window2, windowName, options.browserWindow, id);
          });
        }
        if (options.webContents) {
          electron$1.app.on("web-contents-created", (_2, contents) => {
            var _a3;
            const id = contents.id;
            const webContentsName = ((_a3 = clientOptions == null ? void 0 : clientOptions.getRendererName) == null ? void 0 : _a3.call(clientOptions, contents)) || "renderer";
            patchEventEmitter(contents, webContentsName, options.webContents, id);
          });
        }
      }
    };
  });
  const onUncaughtExceptionIntegration = defineIntegration(() => {
    return {
      name: "OnUncaughtException",
      setup(client) {
        const options = client.getOptions();
        global.process.on("uncaughtException", (error2) => {
          captureException(error2, {
            originalException: error2,
            captureContext: {
              level: "fatal"
            },
            data: {
              mechanism: {
                handled: false,
                type: "generic"
              }
            }
          });
          client.flush(options.shutdownTimeout || 2e3).then(() => {
            if (options == null ? void 0 : options.onFatalError) {
              options.onFatalError(error2);
            } else if (global.process.listenerCount("uncaughtException") <= 2) {
              console.error("Uncaught Exception:");
              console.error(error2);
              const ref = error2.stack;
              const stack = ref !== void 0 ? ref : `${error2.name}: ${error2.message}`;
              const message2 = `Uncaught Exception:
${stack}`;
              electron$1.dialog.showErrorBox("A JavaScript error occurred in the main process", message2);
            }
          }, () => {
          });
        });
      }
    };
  });
  function getScopeData() {
    const globalScope = getGlobalScope().getScopeData();
    const isolationScope = getIsolationScope().getScopeData();
    const currentScope = getCurrentScope().getScopeData();
    mergeScopeData(globalScope, isolationScope);
    mergeScopeData(globalScope, currentScope);
    globalScope.eventProcessors = [];
    return globalScope;
  }
  function addScopeListener(callback) {
    getIsolationScope().addScopeListener((isolation) => {
      const merged = getScopeData();
      callback(merged, isolation);
    });
    getCurrentScope().addScopeListener((current) => {
      const merged = getScopeData();
      callback(merged, current);
    });
    getGlobalScope().addScopeListener((global2) => {
      const merged = getScopeData();
      callback(merged, global2);
    });
  }
  const SDK_VERSION = "5.8.0";
  const SDK_NAME = "sentry.javascript.electron";
  function getSdkInfo() {
    return {
      name: SDK_NAME,
      packages: [
        {
          name: "npm:@sentry/electron",
          version: SDK_VERSION
        }
      ],
      version: SDK_VERSION
    };
  }
  function getDefaultReleaseName() {
    const app_name = electron$1.app.name || electron$1.app.getName();
    return `${app_name.replace(/\W/g, "-")}@${electron$1.app.getVersion()}`;
  }
  function getDefaultEnvironment$1() {
    return electron$1.app.isPackaged ? "production" : "development";
  }
  async function getEventDefaults(client) {
    let event = { message: "test" };
    const eventHint = {};
    for (const processor of client.getEventProcessors()) {
      if (event === null)
        break;
      event = await processor(event, eventHint);
    }
    event == null ? true : delete event.message;
    return event || {};
  }
  var IPCMode;
  (function(IPCMode2) {
    IPCMode2[IPCMode2["Classic"] = 1] = "Classic";
    IPCMode2[IPCMode2["Protocol"] = 2] = "Protocol";
    IPCMode2[IPCMode2["Both"] = 3] = "Both";
  })(IPCMode || (IPCMode = {}));
  const PROTOCOL_SCHEME = "sentry-ipc";
  var IPCChannel;
  (function(IPCChannel2) {
    IPCChannel2["RENDERER_START"] = "sentry-electron.renderer-start";
    IPCChannel2["EVENT"] = "sentry-electron.event";
    IPCChannel2["SCOPE"] = "sentry-electron.scope";
    IPCChannel2["ENVELOPE"] = "sentry-electron.envelope";
    IPCChannel2["STATUS"] = "sentry-electron.status";
    IPCChannel2["ADD_METRIC"] = "sentry-electron.add-metric";
  })(IPCChannel || (IPCChannel = {}));
  const RENDERER_ID_HEADER = "sentry-electron-renderer-id";
  const UTILITY_PROCESS_MAGIC_MESSAGE_KEY = "__sentry_message_port_message__";
  function isMagicMessage(msg) {
    return !!(msg && typeof msg === "object" && UTILITY_PROCESS_MAGIC_MESSAGE_KEY in msg);
  }
  function getMagicMessage() {
    return { [UTILITY_PROCESS_MAGIC_MESSAGE_KEY]: true };
  }
  const parsed = parseSemver(process.versions.electron);
  const version = { major: parsed.major || 0, minor: parsed.minor || 0, patch: parsed.patch || 0 };
  const EXIT_REASONS = [
    "clean-exit",
    "abnormal-exit",
    "killed",
    "crashed",
    "oom",
    "launch-failed",
    "integrity-failure"
  ];
  function getSentryCachePath() {
    return path$k.join(electron$1.app.getPath("userData"), "sentry");
  }
  function crashpadLinux() {
    if (version.major >= 16) {
      return true;
    }
    return electron$1.app.commandLine.hasSwitch("enable-crashpad");
  }
  function usesCrashpad() {
    return process.platform !== "linux" || crashpadLinux();
  }
  function supportsProtocolHandle() {
    return version.major >= 25;
  }
  function registerProtocol(protocol, scheme, callback) {
    if (supportsProtocolHandle()) {
      protocol.handle(scheme, async (request) => {
        callback({
          windowId: request.headers.get(RENDERER_ID_HEADER) || void 0,
          url: request.url,
          body: Buffer.from(await request.arrayBuffer())
        });
        return new Response("");
      });
    } else {
      protocol.registerStringProtocol(scheme, (request, complete) => {
        var _a3, _b2;
        callback({
          windowId: request.headers[RENDERER_ID_HEADER],
          url: request.url,
          body: (_b2 = (_a3 = request.uploadData) == null ? void 0 : _a3[0]) == null ? void 0 : _b2.bytes
        });
        complete("");
      });
    }
  }
  let Mutex$1 = class Mutex {
    constructor() {
      this._entries = [];
      this._waiters = [];
      this._value = 1;
    }
    /** Run a task when all pending tasks are complete */
    async runExclusive(task) {
      const release = await this._acquire();
      try {
        return await task();
      } finally {
        release();
      }
    }
    /** Gets a promise that resolves when all pending tasks are complete */
    _acquire() {
      return new Promise((resolve2, reject) => {
        this._entries.push({ resolve: resolve2, reject });
        this._dispatch();
      });
    }
    /** Releases after a task is complete */
    _release() {
      this._value += 1;
      this._dispatch();
    }
    /** Dispatches pending tasks */
    _dispatch() {
      var _a3;
      for (let weight = this._value; weight > 0; weight--) {
        const queueEntry = (_a3 = this._entries) == null ? void 0 : _a3.shift();
        if (!queueEntry)
          continue;
        this._value -= weight;
        weight = this._value + 1;
        queueEntry.resolve(this._newReleaser());
      }
      this._drainUnlockWaiters();
    }
    /** Creates a new releaser */
    _newReleaser() {
      let called = false;
      return () => {
        if (called)
          return;
        called = true;
        this._release();
      };
    }
    /** Drain unlock waiters */
    _drainUnlockWaiters() {
      for (let weight = this._value; weight > 0; weight--) {
        if (!this._waiters[weight - 1])
          continue;
        this._waiters.forEach((waiter) => waiter());
        this._waiters = [];
      }
    }
  };
  const dateFormat = /^\d{4}-\d{2}-\d{2}T\d{2}:\d{2}:\d{2}\.*\d{0,10}Z$/;
  function dateReviver(_2, value) {
    if (typeof value === "string" && dateFormat.test(value)) {
      return new Date(value);
    }
    return value;
  }
  class Store {
    /**
     * Creates a new store.
     *
     * @param path A unique filename to store this data.
     * @param id A unique filename to store this data.
     * @param initial An initial value to initialize data with.
     */
    constructor(path2, id, initial) {
      this._lock = new Mutex$1();
      this._path = path$k.join(path2, `${id}.json`);
      this._initial = initial;
    }
    /**
     * Updates data by replacing it with the given value.
     * @param data New data to replace the previous one.
     */
    async set(data2) {
      await this._lock.runExclusive(async () => {
        this._data = data2;
        try {
          if (data2 === void 0) {
            try {
              await require$$0$2.promises.unlink(this._path);
            } catch (_2) {
            }
          } else {
            await require$$0$2.promises.mkdir(path$k.dirname(this._path), { recursive: true });
            await require$$0$2.promises.writeFile(this._path, JSON.stringify(data2));
          }
        } catch (e2) {
          logger$2.warn("Failed to write to store", e2);
        }
      });
    }
    /**
     * Returns the current data.
     *
     * When invoked for the first time, it will try to load previously stored data
     * from disk. If the file does not exist, the initial value provided to the
     * constructor is used.
     */
    async get() {
      return this._lock.runExclusive(async () => {
        if (this._data === void 0) {
          try {
            this._data = JSON.parse(await require$$0$2.promises.readFile(this._path, "utf8"), dateReviver);
          } catch (e2) {
            this._data = this._initial;
          }
        }
        return this._data;
      });
    }
    /**
     * Updates data by passing it through the given function.
     * @param fn A function receiving the current data and returning new one.
     */
    async update(fn) {
      await this.set(fn(await this.get()));
    }
    /** Returns store to its initial state */
    async clear() {
      await this.set(this._initial);
    }
    /** Gets the Date that the file was last modified */
    async getModifiedDate() {
      var _a3;
      try {
        return (_a3 = await require$$0$2.promises.stat(this._path)) == null ? void 0 : _a3.mtime;
      } catch (_2) {
        return void 0;
      }
    }
  }
  class BufferedWriteStore extends Store {
    /**
     * Creates a new ThrottledStore.
     *
     * @param path A unique filename to store this data.
     * @param id A unique filename to store this data.
     * @param initial An initial value to initialize data with.
     * @param throttleTime The minimum time between writes
     */
    constructor(path2, id, initial, _throttleTime = 500) {
      super(path2, id, initial);
      this._throttleTime = _throttleTime;
    }
    /** @inheritdoc */
    async set(data2) {
      var _a3;
      this._data = data2;
      this._pendingWrite = {
        // We overwrite the data for the pending write so that the latest data is written in the next flush
        data: data2,
        // If there is already a pending timeout, we keep that rather than starting the timeout again
        timeout: ((_a3 = this._pendingWrite) == null ? void 0 : _a3.timeout) || setTimeout(() => this._writePending(), this._throttleTime)
      };
    }
    /** Writes the pending write to disk */
    _writePending() {
      if (this._pendingWrite) {
        const data2 = this._pendingWrite.data;
        this._pendingWrite = void 0;
        super.set(data2).catch(() => {
        });
      }
    }
  }
  const PERSIST_INTERVAL_MS = 6e4;
  let sessionStore;
  let previousSession;
  function getSessionStore() {
    if (!sessionStore) {
      sessionStore = new Store(getSentryCachePath(), "session", void 0);
      previousSession = sessionStore.get();
    }
    return sessionStore;
  }
  let persistTimer;
  function startSession(sendOnCreate) {
    const session = startSession$1();
    if (sendOnCreate) {
      captureSession();
    }
    getSessionStore().set(session).catch(() => {
    });
    persistTimer = setInterval(async () => {
      const currentSession = getCurrentScope().getSession();
      if (currentSession && currentSession.status === "ok") {
        await getSessionStore().set(currentSession);
      }
    }, PERSIST_INTERVAL_MS);
  }
  async function endSession() {
    if (persistTimer) {
      clearInterval(persistTimer);
    }
    const session = getCurrentScope().getSession();
    if (session) {
      if (session.status === "ok") {
        logger$2.log("Ending session");
        endSession$1();
      } else {
        logger$2.log("Session was already ended");
      }
    } else {
      logger$2.log("No session");
    }
    await getSessionStore().clear();
    await flush(2e3);
  }
  async function checkPreviousSession(crashed) {
    var _a3, _b2;
    const client = getClient();
    const previous = await previousSession;
    if (previous && client) {
      if (previous.status !== "ok") {
        previousSession = void 0;
        return;
      }
      const status = crashed ? "crashed" : "abnormal";
      logger$2.log(`Found previous ${status} session`);
      const sesh = makeSession(previous);
      updateSession(sesh, {
        status,
        errors: (sesh.errors || 0) + 1,
        release: (_a3 = previous.attrs) == null ? void 0 : _a3.release,
        environment: (_b2 = previous.attrs) == null ? void 0 : _b2.environment
      });
      await client.sendSession(sesh);
      previousSession = void 0;
    }
  }
  function sessionCrashed() {
    if (persistTimer) {
      clearInterval(persistTimer);
    }
    logger$2.log("Session Crashed");
    const session = getCurrentScope().getSession();
    if (!session) {
      logger$2.log("No session to update");
      return;
    }
    if (session.status === "ok") {
      logger$2.log("Setting session as crashed");
      const errors = session.errors + 1;
      updateSession(session, { status: "crashed", errors });
      captureSession();
    } else {
      logger$2.log("Session already ended");
    }
  }
  function sessionAnr() {
    if (persistTimer) {
      clearInterval(persistTimer);
    }
    const session = getCurrentScope().getSession();
    if (!session) {
      return;
    }
    if (session.status === "ok") {
      logger$2.log("Setting session as abnormal ANR");
      updateSession(session, { status: "abnormal", abnormal_mechanism: "anr_foreground" });
      captureSession();
    }
  }
  function endSessionOnExit() {
    electron$1.app.on("before-quit", () => {
      electron$1.app.removeListener("will-quit", exitHandler);
      electron$1.app.on("will-quit", exitHandler);
    });
  }
  const exitHandler = async (event) => {
    if (event.defaultPrevented) {
      return;
    }
    logger$2.log("[Session] Exit Handler");
    event.preventDefault();
    try {
      await endSession();
    } catch (e2) {
      logger$2.warn("[Session] Error ending session:", e2);
    }
    electron$1.app.exit();
  };
  const MAX_AGE_DAYS = 30;
  const MS_PER_DAY = 24 * 3600 * 1e3;
  const NOT_MODIFIED_MS = 1e3;
  const MAX_RETRY_MS = 5e3;
  const RETRY_DELAY_MS = 500;
  const MAX_RETRIES = MAX_RETRY_MS / RETRY_DELAY_MS;
  const MINIDUMP_HEADER = "MDMP";
  function delay(ms2) {
    return new Promise((resolve2) => setTimeout(resolve2, ms2));
  }
  function createMinidumpLoader(getMinidumpPaths, preProcessFile = (file2) => file2) {
    const mutex = new Mutex$1();
    return async (deleteAll, callback) => {
      await mutex.runExclusive(async () => {
        for (const path2 of await getMinidumpPaths()) {
          try {
            if (deleteAll) {
              continue;
            }
            logger$2.log("Found minidump", path2);
            let stats = await require$$0$2.promises.stat(path2);
            const thirtyDaysAgo = (/* @__PURE__ */ new Date()).getTime() - MAX_AGE_DAYS * MS_PER_DAY;
            if (stats.mtimeMs < thirtyDaysAgo) {
              logger$2.log(`Ignoring minidump as it is over ${MAX_AGE_DAYS} days old`);
              continue;
            }
            let retries = 0;
            while (retries <= MAX_RETRIES) {
              const twoSecondsAgo = (/* @__PURE__ */ new Date()).getTime() - NOT_MODIFIED_MS;
              if (stats.mtimeMs < twoSecondsAgo) {
                const file2 = await require$$0$2.promises.readFile(path2);
                const data2 = preProcessFile(file2);
                if (data2.length < 1e4 || data2.subarray(0, 4).toString() !== MINIDUMP_HEADER) {
                  logger$2.warn("Dropping minidump as it appears invalid.");
                  break;
                }
                logger$2.log("Sending minidump");
                callback({
                  attachmentType: "event.minidump",
                  filename: basename(path2),
                  data: data2
                });
                break;
              }
              logger$2.log(`Waiting. Minidump has been modified in the last ${NOT_MODIFIED_MS} milliseconds.`);
              retries += 1;
              await delay(RETRY_DELAY_MS);
              stats = await require$$0$2.promises.stat(path2);
            }
            if (retries >= MAX_RETRIES) {
              logger$2.warn("Timed out waiting for minidump to stop being modified");
            }
          } catch (e2) {
            logger$2.error("Failed to load minidump", e2);
          } finally {
            try {
              await require$$0$2.promises.unlink(path2);
            } catch (e2) {
              logger$2.warn("Could not delete minidump", path2);
            }
          }
        }
      });
    };
  }
  async function deleteCrashpadMetadataFile(crashesDirectory, waitMs = 100) {
    if (waitMs > 2e3) {
      return;
    }
    const metadataPath = path$k.join(crashesDirectory, "metadata");
    try {
      await require$$0$2.promises.unlink(metadataPath);
      logger$2.log("Deleted Crashpad metadata file", metadataPath);
    } catch (e2) {
      if (e2.code && e2.code == "EBUSY") {
        setTimeout(async () => {
          await deleteCrashpadMetadataFile(crashesDirectory, waitMs * 2);
        }, waitMs);
      }
    }
  }
  async function readDirsAsync(paths) {
    const found = [];
    for (const path2 of paths) {
      try {
        const files2 = await require$$0$2.promises.readdir(path2);
        found.push(...files2.map((file2) => path$k.join(path2, file2)));
      } catch (_2) {
      }
    }
    return found;
  }
  function crashpadMinidumpLoader() {
    const crashesDirectory = electron$1.app.getPath("crashDumps");
    const crashpadSubDirectory = process.platform === "win32" ? "reports" : "completed";
    const dumpDirectories = [path$k.join(crashesDirectory, crashpadSubDirectory)];
    if (process.platform === "darwin") {
      dumpDirectories.push(path$k.join(crashesDirectory, "pending"));
    }
    return createMinidumpLoader(async () => {
      await deleteCrashpadMetadataFile(crashesDirectory).catch((error2) => logger$2.error(error2));
      const files2 = await readDirsAsync(dumpDirectories);
      return files2.filter((file2) => file2.endsWith(".dmp"));
    });
  }
  function minidumpFromBreakpadMultipart(file2) {
    const binaryStart = file2.lastIndexOf("Content-Type: application/octet-stream");
    if (binaryStart > 0) {
      const dumpStart = file2.indexOf(MINIDUMP_HEADER, binaryStart);
      const dumpEnd = file2.lastIndexOf("----------------------------");
      if (dumpStart > 0 && dumpEnd > 0 && dumpEnd > dumpStart) {
        return file2.subarray(dumpStart, dumpEnd);
      }
    }
    return file2;
  }
  function removeBreakpadMetadata(crashesDirectory, paths) {
    Promise.all(paths.filter((file2) => file2.endsWith(".txt") && !file2.endsWith("log.txt")).map(async (file2) => {
      const path2 = path$k.join(crashesDirectory, file2);
      try {
        await require$$0$2.promises.unlink(path2);
      } catch (e2) {
        logger$2.warn("Could not delete", path2);
      }
    })).catch(() => {
    });
  }
  function breakpadMinidumpLoader() {
    const crashesDirectory = electron$1.app.getPath("crashDumps");
    return createMinidumpLoader(async () => {
      const files2 = await require$$0$2.promises.readdir(crashesDirectory);
      removeBreakpadMetadata(crashesDirectory, files2);
      return files2.filter((file2) => file2.endsWith(".dmp")).map((file2) => path$k.join(crashesDirectory, file2));
    }, minidumpFromBreakpadMultipart);
  }
  function getMinidumpLoader() {
    return usesCrashpad() ? crashpadMinidumpLoader() : breakpadMinidumpLoader();
  }
  const sentryMinidumpIntegration = defineIntegration((options = {}) => {
    let minidumpsRemaining = options.maxMinidumpsPerSession || 10;
    let scopeStore;
    let scopeLastRun;
    let minidumpLoader;
    function startCrashReporter() {
      logger$2.log("Starting Electron crashReporter");
      electron$1.crashReporter.start({
        companyName: "",
        ignoreSystemCrashHandler: true,
        productName: electron$1.app.name || electron$1.app.getName(),
        // Empty string doesn't work for Linux Crashpad and no submitURL doesn't work for older versions of Electron
        submitURL: "https://f.a.k/e",
        uploadToServer: false,
        compress: true
      });
    }
    function setupScopeListener(client) {
      function scopeChanged(scope2) {
        setImmediate(async () => scopeStore == null ? void 0 : scopeStore.set({
          scope: scope2,
          event: await getEventDefaults(client)
        }));
      }
      addScopeListener((scope2) => {
        scopeChanged(scope2);
      });
      scopeChanged(getScopeData());
    }
    async function sendNativeCrashes(client, eventIn) {
      var _a3, _b2, _c2, _d;
      const event = eventIn;
      if (((_a3 = event.tags) == null ? void 0 : _a3["event.process"]) === "browser") {
        const previousRun = await scopeLastRun;
        if (previousRun) {
          if (previousRun.scope) {
            applyScopeDataToEvent(event, previousRun.scope);
          }
          event.release = ((_b2 = previousRun.event) == null ? void 0 : _b2.release) || event.release;
          event.environment = ((_c2 = previousRun.event) == null ? void 0 : _c2.environment) || event.environment;
          event.contexts = ((_d = previousRun.event) == null ? void 0 : _d.contexts) || event.contexts;
        }
      }
      if (!event) {
        return false;
      }
      if (minidumpsRemaining <= 0) {
        logger$2.log("Not sending minidumps because the limit has been reached");
      }
      const deleteAll = client.getOptions().enabled === false || minidumpsRemaining <= 0;
      let minidumpFound = false;
      await (minidumpLoader == null ? void 0 : minidumpLoader(deleteAll, (attachment) => {
        minidumpFound = true;
        if (minidumpsRemaining > 0) {
          minidumpsRemaining -= 1;
          captureEvent(event, { attachments: [attachment] });
        }
      }));
      return minidumpFound;
    }
    async function sendRendererCrash(client, options2, contents, details) {
      var _a3;
      const { getRendererName: getRendererName2 } = options2;
      const crashedProcess = (getRendererName2 == null ? void 0 : getRendererName2(contents)) || "renderer";
      logger$2.log(`'${crashedProcess}' process '${details.reason}'`);
      const found = await sendNativeCrashes(client, {
        contexts: {
          electron: {
            crashed_url: ((_a3 = getRendererProperties(contents.id)) == null ? void 0 : _a3.url) || "unknown",
            details
          }
        },
        level: "fatal",
        // The default is javascript
        platform: "native",
        tags: {
          "event.environment": "native",
          "event.process": crashedProcess,
          "exit.reason": details.reason
        }
      });
      if (found) {
        sessionCrashed();
      }
    }
    async function sendChildProcessCrash(client, options2, details) {
      logger$2.log(`${details.type} process has ${details.reason}`);
      const found = await sendNativeCrashes(client, {
        contexts: {
          electron: { details }
        },
        level: "fatal",
        // The default is javascript
        platform: "native",
        tags: {
          "event.environment": "native",
          "event.process": details.type,
          "exit.reason": details.reason,
          event_type: "native"
        }
      });
      if (found) {
        sessionCrashed();
      }
    }
    return {
      name: "SentryMinidump",
      setup(client) {
        if (process.mas) {
          return;
        }
        startCrashReporter();
        scopeStore = new BufferedWriteStore(getSentryCachePath(), "scope_v3", {
          scope: new Scope().getScopeData()
        });
        scopeLastRun = scopeStore.get();
        minidumpLoader = getMinidumpLoader();
        const options2 = client.getOptions();
        setupScopeListener(client);
        if (!(options2 == null ? void 0 : options2.dsn)) {
          throw new SentryError("Attempted to enable Electron native crash reporter but no DSN was supplied");
        }
        trackRendererProperties();
        electron$1.app.on("render-process-gone", async (_2, contents, details) => {
          if (EXIT_REASONS.includes(details.reason)) {
            await sendRendererCrash(client, options2, contents, details);
          }
        });
        electron$1.app.on("child-process-gone", async (_2, details) => {
          if (EXIT_REASONS.includes(details.reason)) {
            await sendChildProcessCrash(client, options2, details);
          }
        });
        sendNativeCrashes(client, {
          level: "fatal",
          platform: "native",
          tags: {
            "event.environment": "native",
            "event.process": "browser"
          }
        }).then((minidumpsFound) => (
          // Check for previous uncompleted session. If a previous session exists
          // and no minidumps were found, its likely an abnormal exit
          checkPreviousSession(minidumpsFound)
        )).catch((error2) => logger$2.error(error2));
      }
    };
  });
  var isMergeableObject = function isMergeableObject2(value) {
    return isNonNullObject(value) && !isSpecial(value);
  };
  function isNonNullObject(value) {
    return !!value && typeof value === "object";
  }
  function isSpecial(value) {
    var stringValue = Object.prototype.toString.call(value);
    return stringValue === "[object RegExp]" || stringValue === "[object Date]" || isReactElement(value);
  }
  var canUseSymbol = typeof Symbol === "function" && Symbol.for;
  var REACT_ELEMENT_TYPE = canUseSymbol ? Symbol.for("react.element") : 60103;
  function isReactElement(value) {
    return value.$$typeof === REACT_ELEMENT_TYPE;
  }
  function emptyTarget(val) {
    return Array.isArray(val) ? [] : {};
  }
  function cloneUnlessOtherwiseSpecified(value, options) {
    return options.clone !== false && options.isMergeableObject(value) ? deepmerge(emptyTarget(value), value, options) : value;
  }
  function defaultArrayMerge(target, source, options) {
    return target.concat(source).map(function(element) {
      return cloneUnlessOtherwiseSpecified(element, options);
    });
  }
  function getMergeFunction(key, options) {
    if (!options.customMerge) {
      return deepmerge;
    }
    var customMerge = options.customMerge(key);
    return typeof customMerge === "function" ? customMerge : deepmerge;
  }
  function getEnumerableOwnPropertySymbols(target) {
    return Object.getOwnPropertySymbols ? Object.getOwnPropertySymbols(target).filter(function(symbol) {
      return Object.propertyIsEnumerable.call(target, symbol);
    }) : [];
  }
  function getKeys(target) {
    return Object.keys(target).concat(getEnumerableOwnPropertySymbols(target));
  }
  function propertyIsOnObject(object2, property) {
    try {
      return property in object2;
    } catch (_2) {
      return false;
    }
  }
  function propertyIsUnsafe(target, key) {
    return propertyIsOnObject(target, key) && !(Object.hasOwnProperty.call(target, key) && Object.propertyIsEnumerable.call(target, key));
  }
  function mergeObject(target, source, options) {
    var destination = {};
    if (options.isMergeableObject(target)) {
      getKeys(target).forEach(function(key) {
        destination[key] = cloneUnlessOtherwiseSpecified(target[key], options);
      });
    }
    getKeys(source).forEach(function(key) {
      if (propertyIsUnsafe(target, key)) {
        return;
      }
      if (propertyIsOnObject(target, key) && options.isMergeableObject(source[key])) {
        destination[key] = getMergeFunction(key, options)(target[key], source[key], options);
      } else {
        destination[key] = cloneUnlessOtherwiseSpecified(source[key], options);
      }
    });
    return destination;
  }
  function deepmerge(target, source, options) {
    options = options || {};
    options.arrayMerge = options.arrayMerge || defaultArrayMerge;
    options.isMergeableObject = options.isMergeableObject || isMergeableObject;
    options.cloneUnlessOtherwiseSpecified = cloneUnlessOtherwiseSpecified;
    var sourceIsArray = Array.isArray(source);
    var targetIsArray = Array.isArray(target);
    var sourceAndTargetTypesMatch = sourceIsArray === targetIsArray;
    if (!sourceAndTargetTypesMatch) {
      return cloneUnlessOtherwiseSpecified(source, options);
    } else if (sourceIsArray) {
      return options.arrayMerge(target, source, options);
    } else {
      return mergeObject(target, source, options);
    }
  }
  deepmerge.all = function deepmergeAll(array, options) {
    if (!Array.isArray(array)) {
      throw new Error("first argument should be an array");
    }
    return array.reduce(function(prev, next) {
      return deepmerge(prev, next, options);
    }, {});
  };
  var deepmerge_1 = deepmerge;
  var cjs = deepmerge_1;
  const deepMerge = /* @__PURE__ */ getDefaultExportFromCjs(cjs);
  function removePrivateProperties(event) {
    var _a3, _b2;
    (_a3 = event.sdkProcessingMetadata) == null ? true : delete _a3.capturedSpanScope;
    (_b2 = event.sdkProcessingMetadata) == null ? true : delete _b2.capturedSpanIsolationScope;
    for (const span of event.spans || []) {
      delete span.spanRecorder;
    }
  }
  function mergeEvents(defaults, event) {
    removePrivateProperties(event);
    const newEvent = deepMerge(defaults, event);
    if (event.spans || defaults.spans) {
      newEvent.spans = event.spans || defaults.spans;
    }
    return {
      ...newEvent,
      sdk: {
        ...defaults.sdk,
        ...event.sdk
      }
    };
  }
  function normalizePaths(event, basePath) {
    var _a3, _b2, _c2, _d, _e2, _f;
    for (const exception of ((_a3 = event.exception) == null ? void 0 : _a3.values) || []) {
      for (const frame of ((_b2 = exception.stacktrace) == null ? void 0 : _b2.frames) || []) {
        if (frame.filename) {
          frame.filename = normalizeUrlToBase(frame.filename, basePath);
        }
      }
    }
    for (const debugImage of ((_c2 = event.debug_meta) == null ? void 0 : _c2.images) || []) {
      if (debugImage.type === "sourcemap") {
        debugImage.code_file = normalizeUrlToBase(debugImage.code_file, basePath);
      }
    }
    if (event.transaction) {
      event.transaction = normalizeUrlToBase(event.transaction, basePath);
    }
    const { request = {} } = event;
    if (request.url) {
      request.url = normalizeUrlToBase(request.url, basePath);
    }
    if (((_e2 = (_d = event.contexts) == null ? void 0 : _d.feedback) == null ? void 0 : _e2.url) && typeof event.contexts.feedback.url === "string") {
      event.contexts.feedback.url = normalizeUrlToBase(event.contexts.feedback.url, basePath);
    }
    if (event.spans) {
      for (const span of event.spans) {
        if ((_f = span.description) == null ? void 0 : _f.startsWith("file://")) {
          span.description = normalizeUrlToBase(span.description, basePath);
        }
      }
    }
    return event;
  }
  function normalizeUrlsInReplayEnvelope(envelope, basePath) {
    let modifiedEnvelope = createEnvelope(envelope[0]);
    let isReplay = false;
    forEachEnvelopeItem(envelope, (item, type2) => {
      var _a3;
      if (type2 === "replay_event") {
        isReplay = true;
        const [headers, event] = item;
        const currentScope = getCurrentScope().getScopeData();
        event.breadcrumbs = currentScope.breadcrumbs;
        event.tags = currentScope.tags;
        event.user = currentScope.user;
        if (Array.isArray(event.urls)) {
          event.urls = event.urls.map((url2) => normalizeUrlToBase(url2, basePath));
        }
        if ((_a3 = event == null ? void 0 : event.request) == null ? void 0 : _a3.url) {
          event.request.url = normalizeUrlToBase(event.request.url, basePath);
        }
        modifiedEnvelope = addItemToEnvelope(modifiedEnvelope, [headers, event]);
      } else if (type2 === "replay_recording") {
        modifiedEnvelope = addItemToEnvelope(modifiedEnvelope, item);
      }
    });
    return isReplay ? modifiedEnvelope : envelope;
  }
  function normaliseProfile(profile, basePath) {
    for (const frame of profile.profile.frames) {
      if (frame.abs_path) {
        frame.abs_path = normalizeUrlToBase(frame.abs_path, basePath);
      }
    }
  }
  function getPreloadPath() {
    try {
      return require.resolve("../../preload/index.js");
    } catch (_2) {
      try {
        const currentDir = Url.fileURLToPath(typeof document === "undefined" && typeof location === "undefined" ? require("url").pathToFileURL(__filename).href : typeof document === "undefined" ? location.href : _documentCurrentScript && _documentCurrentScript.tagName.toUpperCase() === "SCRIPT" && _documentCurrentScript.src || new URL("index.js", document.baseURI).href);
        return path$k.resolve(currentDir, "..", "..", "..", "..", "preload", "index.js");
      } catch (_3) {
      }
    }
    return void 0;
  }
  const preloadInjectionIntegration = defineIntegration(() => {
    return {
      name: "PreloadInjection",
      setup(client) {
        const options = client.getOptions();
        if ((options.ipcMode & IPCMode.Classic) === 0) {
          return;
        }
        electron$1.app.once("ready", () => {
          const path2 = getPreloadPath();
          if (path2 && typeof path2 === "string" && path$k.isAbsolute(path2) && require$$0$2.existsSync(path2)) {
            for (const sesh of options.getSessions()) {
              const existing = sesh.getPreloads();
              sesh.setPreloads([path2, ...existing]);
            }
          } else {
            logger$2.log("The preload script could not be injected automatically. This is most likely caused by bundling of the main process");
          }
        });
      }
    };
  });
  const mainProcessSessionIntegration = defineIntegration((options = {}) => {
    return {
      name: "MainProcessSession",
      setup() {
        startSession(!!options.sendOnCreate);
        endSessionOnExit();
      }
    };
  });
  const DEFAULT_OPTIONS$1 = {
    screen: true
  };
  const additionalContextIntegration = defineIntegration((userOptions = {}) => {
    const _lazyDeviceContext = {};
    const options = {
      ...DEFAULT_OPTIONS$1,
      ...userOptions
    };
    function _setPrimaryDisplayInfo() {
      const display = electron$1.screen.getPrimaryDisplay();
      const width = Math.floor(display.size.width * display.scaleFactor);
      const height = Math.floor(display.size.height * display.scaleFactor);
      _lazyDeviceContext.screen_density = display.scaleFactor;
      _lazyDeviceContext.screen_resolution = `${width}x${height}`;
    }
    return {
      name: "AdditionalContext",
      setup() {
        electron$1.app.whenReady().then(() => {
          const { screen: screen$1 } = options;
          if (screen$1) {
            _setPrimaryDisplayInfo();
            electron$1.screen.on("display-metrics-changed", () => {
              _setPrimaryDisplayInfo();
            });
          }
        }, () => {
        });
      },
      processEvent(event) {
        const device = _lazyDeviceContext;
        return mergeEvents(event, { contexts: { device } });
      }
    };
  });
  function parseOptions(optionsIn) {
    const { method: method2, options } = typeof optionsIn === "string" ? (
      // eslint-disable-next-line deprecation/deprecation
      { method: "GET", options: Url__namespace.parse(optionsIn) }
    ) : { method: (optionsIn.method || "GET").toUpperCase(), options: optionsIn };
    let url2 = "url" in options ? options.url : void 0;
    if (!url2) {
      const urlObj = {};
      urlObj.protocol = options.protocol || "http:";
      if (options.host) {
        urlObj.host = options.host;
      } else {
        if (options.hostname) {
          urlObj.hostname = options.hostname;
        } else {
          urlObj.hostname = "localhost";
        }
        if (options.port) {
          urlObj.port = options.port;
        }
      }
      const pathObj = Url__namespace.parse(options.path || "/");
      urlObj.pathname = pathObj.pathname;
      urlObj.search = pathObj.search;
      urlObj.hash = pathObj.hash;
      url2 = Url__namespace.format(urlObj);
    }
    return {
      method: method2,
      url: url2
    };
  }
  function addHeadersToRequest(request, url2, sentryTraceHeader, dynamicSamplingContext) {
    logger$2.log(`[Tracing] Adding sentry-trace header ${sentryTraceHeader} to outgoing request to "${url2}": `);
    request.setHeader("sentry-trace", sentryTraceHeader);
    const sentryBaggageHeader = dynamicSamplingContextToSentryBaggageHeader(dynamicSamplingContext);
    if (sentryBaggageHeader) {
      request.setHeader("baggage", sentryBaggageHeader);
    }
  }
  function createWrappedRequestFactory(options, tracePropagationTargets) {
    const createSpanUrlMap = new LRUMap(100);
    const headersUrlMap = new LRUMap(100);
    const shouldCreateSpan = (method2, url2) => {
      if (options.tracing === void 0) {
        return true;
      }
      if (options.tracing === false) {
        return false;
      }
      const key = `${method2}:${url2}`;
      const cachedDecision = createSpanUrlMap.get(key);
      if (cachedDecision !== void 0) {
        return cachedDecision;
      }
      const decision = options.tracing === true || options.tracing(method2, url2);
      createSpanUrlMap.set(key, decision);
      return decision;
    };
    const shouldAttachTraceData = (method2, url2) => {
      const key = `${method2}:${url2}`;
      const cachedDecision = headersUrlMap.get(key);
      if (cachedDecision !== void 0) {
        return cachedDecision;
      }
      if (tracePropagationTargets) {
        const decision = stringMatchesSomePattern(url2, tracePropagationTargets);
        headersUrlMap.set(key, decision);
        return decision;
      }
      return true;
    };
    return function wrappedRequestMethodFactory(originalRequestMethod) {
      return function requestMethod(reqOptions) {
        const { url: url2, method: method2 } = parseOptions(reqOptions);
        const request = originalRequestMethod.apply(this, [reqOptions]);
        if (url2.match(/sentry_key/) || request.getHeader("x-sentry-auth")) {
          return request;
        }
        const span = shouldCreateSpan(method2, url2) ? startInactiveSpan$1({
          name: `${method2} ${url2}`,
          onlyIfParent: true,
          attributes: {
            url: url2,
            type: "net.request",
            "http.method": method2
          },
          op: "http.client"
        }) : new SentryNonRecordingSpan();
        span.setAttribute(SEMANTIC_ATTRIBUTE_SENTRY_ORIGIN, "auto.http.electron.net");
        if (shouldAttachTraceData(method2, url2)) {
          const { traceId, spanId, sampled, dsc } = {
            ...getIsolationScope().getPropagationContext(),
            ...getCurrentScope().getPropagationContext()
          };
          if (span.isRecording()) {
            const sentryTraceHeader = spanToTraceHeader(span);
            const dynamicSamplingContext = dsc || getDynamicSamplingContextFromSpan(span);
            addHeadersToRequest(request, url2, sentryTraceHeader, dynamicSamplingContext);
          } else {
            const sentryTraceHeader = generateSentryTraceHeader(traceId, spanId, sampled);
            const client = getClient();
            const dynamicSamplingContext = dsc || (client ? getDynamicSamplingContextFromClient(traceId, client) : void 0);
            addHeadersToRequest(request, url2, sentryTraceHeader, dynamicSamplingContext);
          }
        }
        return request.once("response", function(res) {
          if (options.breadcrumbs !== false) {
            addRequestBreadcrumb("response", method2, url2, this, res);
          }
          if (res.statusCode) {
            setHttpStatus(span, res.statusCode);
          }
          span.end();
        }).once("error", function(_error) {
          if (options.breadcrumbs !== false) {
            addRequestBreadcrumb("error", method2, url2, this, void 0);
          }
          setHttpStatus(span, 500);
          span.end();
        });
      };
    };
  }
  function addRequestBreadcrumb(event, method2, url2, req, res) {
    addBreadcrumb({
      type: "http",
      category: "electron.net",
      data: {
        url: url2,
        method: method2,
        status_code: res == null ? void 0 : res.statusCode
      }
    }, {
      event,
      request: req,
      response: res
    });
  }
  const electronNetIntegration = defineIntegration((options = {}) => {
    return {
      name: "ElectronNet",
      setup() {
        var _a3;
        const clientOptions = (_a3 = getClient()) == null ? void 0 : _a3.getOptions();
        if (options.breadcrumbs === false && options.tracing === false) {
          return;
        }
        fill(electron$1.net, "request", createWrappedRequestFactory(options, clientOptions == null ? void 0 : clientOptions.tracePropagationTargets));
      }
    };
  });
  const DEFAULT_OPTIONS = {
    breadcrumbs: EXIT_REASONS,
    events: ["abnormal-exit", "launch-failed", "integrity-failure"]
  };
  function getMessageAndSeverity(reason, proc) {
    const message2 = `'${proc}' process exited with '${reason}'`;
    switch (reason) {
      case "abnormal-exit":
      case "killed":
        return { message: message2, level: "warning" };
      case "crashed":
      case "oom":
      case "launch-failed":
      case "integrity-failure":
        return { message: message2, level: "fatal" };
      default:
        return { message: message2, level: "debug" };
    }
  }
  const childProcessIntegration = defineIntegration((userOptions = {}) => {
    const { breadcrumbs, events: events2 } = userOptions;
    const options = {
      breadcrumbs: Array.isArray(breadcrumbs) ? breadcrumbs : breadcrumbs === false ? [] : DEFAULT_OPTIONS.breadcrumbs,
      events: Array.isArray(events2) ? events2 : events2 === false ? [] : DEFAULT_OPTIONS.events
    };
    return {
      name: "ChildProcess",
      setup(client) {
        const { breadcrumbs: breadcrumbs2, events: events3 } = options;
        const allReasons = Array.from(/* @__PURE__ */ new Set([...breadcrumbs2, ...events3]));
        if (allReasons.length > 0) {
          const clientOptions = client.getOptions();
          electron$1.app.on("child-process-gone", (_2, details) => {
            const { reason } = details;
            if (events3.includes(reason)) {
              const { message: message2, level } = getMessageAndSeverity(details.reason, details.type);
              captureMessage(message2, { level, tags: { "event.process": details.type } });
            }
            if (breadcrumbs2.includes(reason)) {
              addBreadcrumb({
                type: "process",
                category: "child-process",
                ...getMessageAndSeverity(details.reason, details.type),
                data: details
              });
            }
          });
          electron$1.app.on("render-process-gone", (_2, contents, details) => {
            var _a3;
            const { reason } = details;
            const name2 = ((_a3 = clientOptions == null ? void 0 : clientOptions.getRendererName) == null ? void 0 : _a3.call(clientOptions, contents)) || "renderer";
            if (events3.includes(reason)) {
              const { message: message2, level } = getMessageAndSeverity(details.reason, name2);
              captureMessage(message2, level);
            }
            if (breadcrumbs2.includes(reason)) {
              addBreadcrumb({
                type: "process",
                category: "child-process",
                ...getMessageAndSeverity(details.reason, name2),
                data: details
              });
            }
          });
        }
      }
    };
  });
  const screenshotsIntegration = defineIntegration(() => {
    return {
      name: "Screenshots",
      async processEvent(event, hint, client) {
        const attachScreenshot = !!client.getOptions().attachScreenshot;
        if (!attachScreenshot) {
          return event;
        }
        if (!event.transaction && event.platform !== "native") {
          let count = 1;
          for (const window2 of electron$1.BrowserWindow.getAllWindows()) {
            if (!hint.attachments) {
              hint.attachments = [];
            }
            try {
              if (!window2.isDestroyed() && window2.isVisible()) {
                const filename = count === 1 ? "screenshot.png" : `screenshot-${count}.png`;
                const image = await window2.capturePage();
                hint.attachments.push({ filename, data: image.toPNG(), contentType: "image/png" });
                count += 1;
              }
            } catch (e2) {
              logger$2.error("Error capturing screenshot", e2);
            }
          }
        }
        return event;
      }
    };
  });
  const DOCUMENT_POLICY_HEADER = "Document-Policy";
  const JS_PROFILING_HEADER = "js-profiling";
  let RENDERER_PROFILES;
  function rendererProfileFromIpc(event, profile) {
    if (!RENDERER_PROFILES) {
      return;
    }
    const profile_id = profile.event_id;
    RENDERER_PROFILES.set(profile_id, profile);
    if (event) {
      event.contexts = {
        ...event.contexts,
        // Re-add the profile context which we can later use to find the correct profile
        profile: {
          profile_id
        }
      };
    }
  }
  function addJsProfilingHeader(responseHeaders = {}) {
    if (responseHeaders[DOCUMENT_POLICY_HEADER]) {
      const docPolicy = responseHeaders[DOCUMENT_POLICY_HEADER];
      if (Array.isArray(docPolicy)) {
        docPolicy.push(JS_PROFILING_HEADER);
      } else {
        responseHeaders[DOCUMENT_POLICY_HEADER] = [docPolicy, JS_PROFILING_HEADER];
      }
    } else {
      responseHeaders[DOCUMENT_POLICY_HEADER] = JS_PROFILING_HEADER;
    }
    return { responseHeaders };
  }
  const rendererProfilingIntegration = defineIntegration(() => {
    return {
      name: "RendererProfiling",
      setup(client) {
        var _a3;
        const options = client.getOptions();
        if (!options.enableRendererProfiling) {
          return;
        }
        RENDERER_PROFILES = new LRUMap(10);
        electron$1.app.on("ready", () => {
          for (const sesh of options.getSessions()) {
            sesh.webRequest.onHeadersReceived((details, callback) => {
              callback(addJsProfilingHeader(details.responseHeaders));
            });
          }
        });
        (_a3 = client.on) == null ? void 0 : _a3.call(client, "beforeEnvelope", (envelope) => {
          let profile_id;
          forEachEnvelopeItem(envelope, (item, type2) => {
            var _a4, _b2;
            if (type2 !== "transaction") {
              return;
            }
            for (let j2 = 1; j2 < item.length; j2++) {
              const event = item[j2];
              if ((_b2 = (_a4 = event == null ? void 0 : event.contexts) == null ? void 0 : _a4.profile) == null ? void 0 : _b2.profile_id) {
                profile_id = event.contexts.profile.profile_id;
                delete event.contexts.profile;
              }
            }
          });
          if (!profile_id) {
            return;
          }
          const profile = RENDERER_PROFILES == null ? void 0 : RENDERER_PROFILES.remove(profile_id);
          if (!profile) {
            return;
          }
          normaliseProfile(profile, electron$1.app.getAppPath());
          profile.release = options.release || getDefaultReleaseName();
          profile.environment = options.environment || getDefaultEnvironment$1();
          envelope[1].push([{ type: "profile" }, profile]);
        });
      }
    };
  });
  const normalizePathsIntegration = defineIntegration(() => {
    return {
      name: "NormalizePaths",
      processEvent(event) {
        return normalizePaths(event, electron$1.app.getAppPath());
      }
    };
  });
  function getAppMemory() {
    return electron$1.app.getAppMetrics().reduce((acc, metric) => acc + metric.memory.workingSetSize * 1024, 0);
  }
  const electronContextIntegration = defineIntegration(() => {
    return {
      name: "ElectronContext",
      processEvent(event, _2, client) {
        var _a3, _b2, _c2, _d, _e2;
        delete event.server_name;
        (_a3 = event.tags) == null ? true : delete _a3.server_name;
        (_b2 = event.contexts) == null ? true : delete _b2.runtime;
        (_d = (_c2 = event.contexts) == null ? void 0 : _c2.app) == null ? true : delete _d.app_memory;
        if ((_e2 = event.request) == null ? void 0 : _e2.headers) {
          delete event.request.headers["User-Agent"];
        }
        const { release = getDefaultReleaseName(), environment = getDefaultEnvironment$1() } = client.getOptions();
        return mergeEvents({
          contexts: {
            app: {
              app_name: electron$1.app.name || electron$1.app.getName(),
              app_version: electron$1.app.getVersion(),
              build_type: process.mas ? "app-store" : process.windowsStore ? "windows-store" : void 0,
              app_memory: getAppMemory(),
              app_arch: process.arch
            },
            browser: {
              name: "Chrome"
            },
            chrome: {
              name: "Chrome",
              type: "runtime",
              version: process.versions.chrome
            },
            device: {
              family: "Desktop"
            },
            node: {
              name: "Node",
              type: "runtime",
              version: process.versions.node
            },
            runtime: {
              name: "Electron",
              version: process.versions.electron
            }
          },
          environment,
          release,
          tags: {
            "event.origin": "electron",
            "event.environment": "javascript",
            "event.process": "browser"
          }
        }, event);
      }
    };
  });
  const GZIP_THRESHOLD = 1024 * 32;
  function streamFromBody(body) {
    return new Stream.Readable({
      read() {
        this.push(body);
        this.push(null);
      }
    });
  }
  function getRequestOptions(url2) {
    const { hostname, pathname, port, protocol, search } = new Url.URL(url2);
    return {
      method: "POST",
      hostname,
      path: `${pathname}${search}`,
      port: parseInt(port, 10),
      protocol
    };
  }
  function makeElectronTransport(options) {
    return createTransport(options, createElectronNetRequestExecutor(options.url, options.headers || {}));
  }
  function createElectronNetRequestExecutor(url2, baseHeaders) {
    baseHeaders["Content-Type"] = "application/x-sentry-envelope";
    return function makeRequest(request) {
      return electron$1.app.whenReady().then(() => new Promise((resolve2, reject) => {
        let bodyStream = streamFromBody(request.body);
        const headers = { ...baseHeaders };
        if (request.body.length > GZIP_THRESHOLD) {
          headers["content-encoding"] = "gzip";
          bodyStream = bodyStream.pipe(zlib$2.createGzip());
        }
        const req = electron$1.net.request(getRequestOptions(url2));
        for (const [header, value] of Object.entries(headers)) {
          req.setHeader(header, value);
        }
        req.on("response", (res) => {
          res.on("error", reject);
          res.on("data", () => {
          });
          res.on("end", () => {
          });
          const retryAfterHeader = res.headers["retry-after"] ?? null;
          const rateLimitsHeader = res.headers["x-sentry-rate-limits"] ?? null;
          resolve2({
            statusCode: res.statusCode,
            headers: dropUndefinedKeys({
              "retry-after": Array.isArray(retryAfterHeader) ? retryAfterHeader[0] || null : retryAfterHeader,
              "x-sentry-rate-limits": Array.isArray(rateLimitsHeader) ? rateLimitsHeader[0] || null : rateLimitsHeader
            })
          });
        });
        req.on("error", reject);
        bodyStream.pipe(req);
      }));
    };
  }
  const MILLISECONDS_PER_DAY = 864e5;
  function isOutdated(request, maxAgeDays) {
    const cutOff = Date.now() - MILLISECONDS_PER_DAY * maxAgeDays;
    return request.date.getTime() < cutOff;
  }
  function getSentAtFromEnvelope(envelope) {
    const header = envelope[0];
    if (typeof header.sent_at === "string") {
      return new Date(header.sent_at);
    }
    return void 0;
  }
  function createOfflineStore(userOptions) {
    function log2(...args2) {
      logger$2.log(`[Offline Store]:`, ...args2);
    }
    const options = {
      maxAgeDays: userOptions.maxAgeDays || 30,
      maxQueueSize: userOptions.maxQueueSize || 30,
      queuePath: userOptions.queuePath || path$k.join(getSentryCachePath(), "queue")
    };
    const queue = new Store(options.queuePath, "queue-v2", []);
    function removeBody(id) {
      require$$0$2.promises.unlink(path$k.join(options.queuePath, id)).catch(() => {
      });
    }
    function removeStaleRequests(queue2) {
      while (queue2[0] && isOutdated(queue2[0], options.maxAgeDays)) {
        const removed = queue2.shift();
        log2("Removing stale envelope", removed);
        removeBody(removed.id);
      }
    }
    async function insert(env2, which2, previousDate) {
      log2(`${which2}ing envelope into offline storage`);
      const id = uuid4();
      try {
        const data2 = serializeEnvelope(env2);
        await require$$0$2.promises.mkdir(options.queuePath, { recursive: true });
        await require$$0$2.promises.writeFile(path$k.join(options.queuePath, id), data2);
      } catch (e2) {
        log2("Failed to save", e2);
      }
      await queue.update((queue2) => {
        if (which2 === "push") {
          removeStaleRequests(queue2);
          if (queue2.length >= options.maxQueueSize) {
            removeBody(id);
            return queue2;
          }
        }
        queue2[which2]({ id, date: previousDate || getSentAtFromEnvelope(env2) || /* @__PURE__ */ new Date() });
        return queue2;
      });
    }
    let lastShiftedDate;
    return {
      push: async (env2) => {
        await insert(env2, "push");
      },
      unshift: async (env2) => {
        await insert(env2, "unshift", lastShiftedDate);
      },
      shift: async () => {
        log2("Popping envelope from offline storage");
        let request;
        await queue.update((queue2) => {
          removeStaleRequests(queue2);
          request = queue2.shift();
          return queue2;
        });
        if (request) {
          try {
            const data2 = await require$$0$2.promises.readFile(path$k.join(options.queuePath, request.id));
            removeBody(request.id);
            lastShiftedDate = request.date;
            return parseEnvelope(data2);
          } catch (e2) {
            log2("Failed to read", e2);
          }
        }
        return void 0;
      }
    };
  }
  function makeShouldSendTransport(baseTransport) {
    return (options) => {
      const transport = baseTransport(options);
      return {
        ...transport,
        send: async (envelope) => {
          const shouldAttemptSend = options.shouldSend === void 0 || await options.shouldSend(envelope);
          if (shouldAttemptSend) {
            return transport.send(envelope);
          }
          throw new Error("'shouldSend' callback returned false. Skipped sending.");
        }
      };
    };
  }
  function makeElectronOfflineTransport(baseTransport = makeElectronTransport) {
    return (userOptions) => {
      return makeOfflineTransport(makeShouldSendTransport(baseTransport))({
        flushAtStartup: true,
        createStore: createOfflineStore,
        ...userOptions
      });
    };
  }
  function eventFromEnvelope(envelope) {
    let event;
    const attachments = [];
    let profile;
    forEachEnvelopeItem(envelope, (item, type2) => {
      if (type2 === "event" || type2 === "transaction" || type2 === "feedback") {
        event = Array.isArray(item) ? item[1] : void 0;
      } else if (type2 === "attachment") {
        const [headers, data2] = item;
        attachments.push({
          filename: headers.filename,
          attachmentType: headers.attachment_type,
          contentType: headers.content_type,
          data: data2
        });
      } else if (type2 === "profile") {
        profile = item[1];
      }
    });
    return event ? [event, attachments, profile] : void 0;
  }
  function getRendererName(contents) {
    var _a3, _b2;
    const options = (_a3 = getClient()) == null ? void 0 : _a3.getOptions();
    return (_b2 = options == null ? void 0 : options.getRendererName) == null ? void 0 : _b2.call(options, contents);
  }
  function sendRendererAnrEvent(contents, blockedMs, frames) {
    sessionAnr();
    const rendererName = getRendererName(contents) || "renderer";
    const event = {
      level: "error",
      exception: {
        values: [
          {
            type: "ApplicationNotResponding",
            value: `Application Not Responding for at least ${blockedMs} ms`,
            stacktrace: { frames },
            mechanism: {
              // This ensures the UI doesn't say 'Crashed in' for the stack trace
              type: "ANR"
            }
          }
        ]
      },
      tags: {
        "event.process": rendererName
      }
    };
    captureEvent(event);
  }
  function rendererDebugger(contents, pausedStack) {
    contents.debugger.attach("1.3");
    const scripts2 = /* @__PURE__ */ new Map();
    const getModuleFromFilename = createGetModuleFromFilename(electron$1.app.getAppPath());
    contents.debugger.on("message", (_2, method2, params) => {
      if (method2 === "Debugger.scriptParsed") {
        const param = params;
        scripts2.set(param.scriptId, param.url);
      } else if (method2 === "Debugger.paused") {
        const param = params;
        if (param.reason !== "other") {
          return;
        }
        const callFrames = [...param.callFrames];
        contents.debugger.sendCommand("Debugger.resume").then(null, () => {
        });
        const stackFrames = stripSentryFramesAndReverse(callFrames.map((frame) => callFrameToStackFrame(frame, scripts2.get(frame.location.scriptId), getModuleFromFilename)));
        pausedStack(stackFrames);
      }
    });
    contents.debugger.sendCommand("Debugger.enable").catch(() => {
    });
    return () => {
      return contents.debugger.sendCommand("Debugger.pause");
    };
  }
  let rendererWatchdogTimers;
  function createHrTimer() {
    let lastPoll = process.hrtime();
    return {
      getTimeMs: () => {
        const [seconds, nanoSeconds] = process.hrtime(lastPoll);
        return Math.floor(seconds * 1e3 + nanoSeconds / 1e6);
      },
      reset: () => {
        lastPoll = process.hrtime();
      }
    };
  }
  function createRendererAnrStatusHandler() {
    function log2(message2, ...args2) {
      logger$2.log(`[Renderer ANR] ${message2}`, ...args2);
    }
    return (message2, contents) => {
      rendererWatchdogTimers = rendererWatchdogTimers || /* @__PURE__ */ new Map();
      let watchdog = rendererWatchdogTimers.get(contents);
      if (watchdog === void 0) {
        log2("Renderer sent first status message", message2.config);
        let pauseAndCapture;
        if (message2.config.captureStackTrace) {
          log2("Connecting to debugger");
          pauseAndCapture = rendererDebugger(contents, (frames) => {
            log2("Event captured with stack frames");
            sendRendererAnrEvent(contents, message2.config.anrThreshold, frames);
          });
        }
        watchdog = watchdogTimer(createHrTimer, 100, message2.config.anrThreshold, async () => {
          log2("Watchdog timeout");
          if (pauseAndCapture) {
            log2("Pausing debugger to capture stack trace");
            pauseAndCapture();
          } else {
            log2("Capturing event");
            sendRendererAnrEvent(contents, message2.config.anrThreshold);
          }
        });
        contents.once("destroyed", () => {
          rendererWatchdogTimers == null ? void 0 : rendererWatchdogTimers.delete(contents);
        });
        rendererWatchdogTimers.set(contents, watchdog);
      }
      watchdog.poll();
      if (message2.status !== "alive") {
        log2("Renderer visibility changed", message2.status);
        watchdog.enabled(message2.status === "visible");
      }
    };
  }
  let KNOWN_RENDERERS;
  let WINDOW_ID_TO_WEB_CONTENTS;
  const SENTRY_CUSTOM_SCHEME = {
    scheme: PROTOCOL_SCHEME,
    privileges: { bypassCSP: true, corsEnabled: true, supportFetchAPI: true, secure: true }
  };
  function newProtocolRenderer() {
    KNOWN_RENDERERS = KNOWN_RENDERERS || /* @__PURE__ */ new Set();
    WINDOW_ID_TO_WEB_CONTENTS = WINDOW_ID_TO_WEB_CONTENTS || /* @__PURE__ */ new Map();
    for (const wc of electron$1.webContents.getAllWebContents()) {
      const wcId = wc.id;
      if (KNOWN_RENDERERS.has(wcId)) {
        continue;
      }
      if (!wc.isDestroyed()) {
        wc.executeJavaScript("window.__SENTRY_RENDERER_ID__").then((windowId) => {
          if (windowId && KNOWN_RENDERERS && WINDOW_ID_TO_WEB_CONTENTS) {
            KNOWN_RENDERERS.add(wcId);
            WINDOW_ID_TO_WEB_CONTENTS.set(windowId, wcId);
            wc.once("destroyed", () => {
              KNOWN_RENDERERS == null ? void 0 : KNOWN_RENDERERS.delete(wcId);
              WINDOW_ID_TO_WEB_CONTENTS == null ? void 0 : WINDOW_ID_TO_WEB_CONTENTS.delete(windowId);
            });
          }
        }, logger$2.error);
      }
    }
  }
  function captureEventFromRenderer(options, event, attachments, contents) {
    var _a3, _b2, _c2, _d;
    const process2 = contents ? ((_a3 = options == null ? void 0 : options.getRendererName) == null ? void 0 : _a3.call(options, contents)) || "renderer" : "renderer";
    event.breadcrumbs = event.breadcrumbs || [];
    delete event.environment;
    (_b2 = event.sdk) == null ? true : delete _b2.name;
    (_c2 = event.sdk) == null ? true : delete _c2.version;
    (_d = event.sdk) == null ? true : delete _d.packages;
    captureEvent(mergeEvents(event, { tags: { "event.process": process2 } }), { attachments });
  }
  function handleEvent(options, jsonEvent, contents) {
    let event;
    try {
      event = JSON.parse(jsonEvent);
    } catch {
      logger$2.warn("sentry-electron received an invalid event message");
      return;
    }
    captureEventFromRenderer(options, event, [], contents);
  }
  function handleEnvelope(options, env2, contents) {
    var _a3, _b2;
    const envelope = parseEnvelope(env2);
    const eventAndAttachments = eventFromEnvelope(envelope);
    if (eventAndAttachments) {
      const [event, attachments, profile] = eventAndAttachments;
      if (profile) {
        rendererProfileFromIpc(event, profile);
      }
      captureEventFromRenderer(options, event, attachments, contents);
    } else {
      const normalizedEnvelope = normalizeUrlsInReplayEnvelope(envelope, electron$1.app.getAppPath());
      void ((_b2 = (_a3 = getClient()) == null ? void 0 : _a3.getTransport()) == null ? void 0 : _b2.send(normalizedEnvelope));
    }
  }
  function handleMetric(metric) {
    const client = getClient();
    if (!client) {
      return;
    }
    const metricsAggregator = metricsDefault.getMetricsAggregatorForClient(client);
    metricsAggregator.add(metric.metricType, metric.name, metric.value, metric.unit, metric.tags, metric.timestamp);
  }
  function hasKeys(obj) {
    return obj != void 0 && Object.keys(obj).length > 0;
  }
  function handleScope(options, jsonScope) {
    let sentScope;
    try {
      sentScope = JSON.parse(jsonScope);
    } catch {
      logger$2.warn("sentry-electron received an invalid scope message");
      return;
    }
    const scope2 = getCurrentScope();
    if (hasKeys(sentScope.user)) {
      scope2.setUser(sentScope.user);
    }
    if (hasKeys(sentScope.tags)) {
      scope2.setTags(sentScope.tags);
    }
    if (hasKeys(sentScope.extra)) {
      scope2.setExtras(sentScope.extra);
    }
    for (const attachment of sentScope.attachments || []) {
      scope2.addAttachment(attachment);
    }
    const breadcrumb = sentScope.breadcrumbs.pop();
    if (breadcrumb) {
      scope2.addBreadcrumb(breadcrumb, (options == null ? void 0 : options.maxBreadcrumbs) || 100);
    }
  }
  function configureProtocol(options) {
    if (electron$1.app.isReady()) {
      throw new SentryError("Sentry SDK should be initialized before the Electron app 'ready' event is fired");
    }
    electron$1.protocol.registerSchemesAsPrivileged([SENTRY_CUSTOM_SCHEME]);
    electron$1.protocol.registerSchemesAsPrivileged = new Proxy(electron$1.protocol.registerSchemesAsPrivileged, {
      apply: (target, __, args2) => {
        target([...args2[0], SENTRY_CUSTOM_SCHEME]);
      }
    });
    const rendererStatusChanged = createRendererAnrStatusHandler();
    electron$1.app.whenReady().then(() => {
      for (const sesh of options.getSessions()) {
        registerProtocol(sesh.protocol, PROTOCOL_SCHEME, (request) => {
          const getWebContents = () => {
            const webContentsId = request.windowId ? WINDOW_ID_TO_WEB_CONTENTS == null ? void 0 : WINDOW_ID_TO_WEB_CONTENTS.get(request.windowId) : void 0;
            return webContentsId ? electron$1.webContents.fromId(webContentsId) : void 0;
          };
          const data2 = request.body;
          if (request.url.startsWith(`${PROTOCOL_SCHEME}://${IPCChannel.RENDERER_START}`)) {
            newProtocolRenderer();
          } else if (request.url.startsWith(`${PROTOCOL_SCHEME}://${IPCChannel.EVENT}`) && data2) {
            handleEvent(options, data2.toString(), getWebContents());
          } else if (request.url.startsWith(`${PROTOCOL_SCHEME}://${IPCChannel.SCOPE}`) && data2) {
            handleScope(options, data2.toString());
          } else if (request.url.startsWith(`${PROTOCOL_SCHEME}://${IPCChannel.ENVELOPE}`) && data2) {
            handleEnvelope(options, data2, getWebContents());
          } else if (request.url.startsWith(`${PROTOCOL_SCHEME}://${IPCChannel.ADD_METRIC}`) && data2) {
            handleMetric(JSON.parse(data2.toString()));
          } else if (request.url.startsWith(`${PROTOCOL_SCHEME}://${IPCChannel.STATUS}`) && data2) {
            const contents = getWebContents();
            if (contents) {
              const status = JSON.parse(data2.toString()).status;
              rendererStatusChanged(status, contents);
            }
          }
        });
      }
    }).catch((error2) => logger$2.error(error2));
  }
  function configureClassic(options) {
    electron$1.ipcMain.on(IPCChannel.RENDERER_START, ({ sender }) => {
      const id = sender.id;
      KNOWN_RENDERERS = KNOWN_RENDERERS || /* @__PURE__ */ new Set();
      if (KNOWN_RENDERERS.has(id)) {
        return;
      }
      if (!sender.isDestroyed()) {
        KNOWN_RENDERERS.add(id);
        sender.once("destroyed", () => {
          KNOWN_RENDERERS == null ? void 0 : KNOWN_RENDERERS.delete(id);
        });
      }
    });
    electron$1.ipcMain.on(IPCChannel.EVENT, ({ sender }, jsonEvent) => handleEvent(options, jsonEvent, sender));
    electron$1.ipcMain.on(IPCChannel.SCOPE, (_2, jsonScope) => handleScope(options, jsonScope));
    electron$1.ipcMain.on(IPCChannel.ENVELOPE, ({ sender }, env2) => handleEnvelope(options, env2, sender));
    const rendererStatusChanged = createRendererAnrStatusHandler();
    electron$1.ipcMain.on(IPCChannel.STATUS, ({ sender }, status) => rendererStatusChanged(status, sender));
    electron$1.ipcMain.on(IPCChannel.ADD_METRIC, (_2, metric) => handleMetric(metric));
  }
  function configureIPC(options) {
    if ((options.ipcMode & IPCMode.Protocol) > 0) {
      configureProtocol(options);
    }
    if ((options.ipcMode & IPCMode.Classic) > 0) {
      configureClassic(options);
    }
  }
  const defaultStackParser = createStackParser(nodeStackLineParser(createGetModuleFromFilename(electron$1.app.getAppPath())));
  function log(message2) {
    logger$2.log(`[Utility Process] ${message2}`);
  }
  function configureUtilityProcessIPC() {
    var _a3;
    if (!((_a3 = electron__namespace.utilityProcess) == null ? void 0 : _a3.fork)) {
      return;
    }
    electron__namespace.utilityProcess.fork = new Proxy(electron__namespace.utilityProcess.fork, {
      apply: (target, thisArg, args2) => {
        const child = target.apply(thisArg, args2);
        function getProcessName() {
          const [, , options] = args2;
          return (options == null ? void 0 : options.serviceName) || `pid:${child.pid}`;
        }
        child.on("message", (msg) => {
          if (isMagicMessage(msg)) {
            log(`SDK started in utility process '${getProcessName()}'`);
            const { port1, port2 } = new electron__namespace.MessageChannelMain();
            port2.on("message", (msg2) => {
              if (msg2.data instanceof Uint8Array || typeof msg2.data === "string") {
                handleEnvelopeFromUtility(msg2.data);
              }
            });
            port2.start();
            child.postMessage(getMagicMessage(), [port1]);
          }
        });
        child.on = new Proxy(child.on, {
          apply: (target2, thisArg2, [event, listener]) => {
            if (event === "message") {
              return target2.apply(thisArg2, [
                "message",
                (msg) => {
                  if (isMagicMessage(msg)) {
                    return;
                  }
                  return listener(msg);
                }
              ]);
            }
            return target2.apply(thisArg2, [event, listener]);
          }
        });
        return child;
      }
    });
  }
  function handleEnvelopeFromUtility(env2) {
    var _a3, _b2;
    const envelope = parseEnvelope(env2);
    const eventAndAttachments = eventFromEnvelope(envelope);
    if (eventAndAttachments) {
      const [event, attachments] = eventAndAttachments;
      captureEventFromUtility(event, attachments);
    } else {
      void ((_b2 = (_a3 = getClient()) == null ? void 0 : _a3.getTransport()) == null ? void 0 : _b2.send(envelope));
    }
  }
  function captureEventFromUtility(event, attachments) {
    var _a3, _b2, _c2;
    delete event.environment;
    delete event.release;
    (_a3 = event.sdk) == null ? true : delete _a3.name;
    (_b2 = event.sdk) == null ? true : delete _b2.version;
    (_c2 = event.sdk) == null ? true : delete _c2.packages;
    captureEvent(mergeEvents(event, { tags: { "event.process": "utility" } }), { attachments });
  }
  function getDefaultIntegrations(options) {
    const integrations = [
      // Electron integrations
      sentryMinidumpIntegration(),
      electronBreadcrumbsIntegration(),
      electronNetIntegration(),
      electronContextIntegration(),
      childProcessIntegration(),
      onUncaughtExceptionIntegration(),
      preloadInjectionIntegration(),
      additionalContextIntegration(),
      screenshotsIntegration(),
      // Node integrations
      inboundFiltersIntegration(),
      functionToStringIntegration(),
      linkedErrorsIntegration(),
      consoleIntegration(),
      nativeNodeFetchIntegration(),
      onUnhandledRejectionIntegration(),
      contextLinesIntegration(),
      localVariablesIntegration(),
      nodeContextIntegration({ cloudResource: false }),
      // We want paths to be normailzed after we've captured context
      normalizePathsIntegration()
    ];
    if (options.autoSessionTracking !== false) {
      integrations.push(mainProcessSessionIntegration());
    }
    if (options.attachScreenshot) {
      integrations.push(screenshotsIntegration());
    }
    if (options.enableRendererProfiling) {
      integrations.push(rendererProfilingIntegration());
    }
    return integrations;
  }
  function init(userOptions) {
    const optionsWithDefaults = {
      _metadata: { sdk: getSdkInfo() },
      ipcMode: IPCMode.Both,
      release: getDefaultReleaseName(),
      environment: getDefaultEnvironment$1(),
      defaultIntegrations: getDefaultIntegrations(userOptions),
      transport: makeElectronOfflineTransport(),
      transportOptions: {},
      getSessions: () => [electron$1.session.defaultSession],
      ...userOptions,
      stackParser: stackParserFromStackParserOptions(userOptions.stackParser || defaultStackParser)
    };
    const options = {
      ...optionsWithDefaults,
      integrations: getIntegrationsToSetup(optionsWithDefaults)
    };
    if (options.debug) {
      logger$2.enable();
    }
    removeRedundantIntegrations(options);
    configureIPC(options);
    configureUtilityProcessIPC();
    setOpenTelemetryContextAsyncContextStrategy();
    const scope2 = getCurrentScope();
    scope2.update(options.initialScope);
    const client = new NodeClient(options);
    scope2.setClient(client);
    client.init();
    if (!options.skipOpenTelemetrySetup) {
      initOpenTelemetry(client);
    }
  }
  const INTEGRATION_OVERRIDES = [
    { userAdded: "ElectronMinidump", toRemove: "SentryMinidump" },
    { userAdded: "BrowserWindowSession", toRemove: "MainProcessSession" }
  ];
  function removeRedundantIntegrations(options) {
    for (const { userAdded, toRemove } of INTEGRATION_OVERRIDES) {
      if (options.integrations.some((i2) => i2.name === userAdded)) {
        options.integrations = options.integrations.filter((i2) => i2.name !== toRemove);
      }
    }
  }
  var src$1 = { exports: {} };
  var browser = { exports: {} };
  var debug$1 = { exports: {} };
  var ms;
  var hasRequiredMs;
  function requireMs() {
    if (hasRequiredMs) return ms;
    hasRequiredMs = 1;
    var s2 = 1e3;
    var m2 = s2 * 60;
    var h2 = m2 * 60;
    var d2 = h2 * 24;
    var y2 = d2 * 365.25;
    ms = function(val, options) {
      options = options || {};
      var type2 = typeof val;
      if (type2 === "string" && val.length > 0) {
        return parse2(val);
      } else if (type2 === "number" && isNaN(val) === false) {
        return options.long ? fmtLong(val) : fmtShort(val);
      }
      throw new Error(
        "val is not a non-empty string or a valid number. val=" + JSON.stringify(val)
      );
    };
    function parse2(str) {
      str = String(str);
      if (str.length > 100) {
        return;
      }
      var match = /^((?:\d+)?\.?\d+) *(milliseconds?|msecs?|ms|seconds?|secs?|s|minutes?|mins?|m|hours?|hrs?|h|days?|d|years?|yrs?|y)?$/i.exec(
        str
      );
      if (!match) {
        return;
      }
      var n2 = parseFloat(match[1]);
      var type2 = (match[2] || "ms").toLowerCase();
      switch (type2) {
        case "years":
        case "year":
        case "yrs":
        case "yr":
        case "y":
          return n2 * y2;
        case "days":
        case "day":
        case "d":
          return n2 * d2;
        case "hours":
        case "hour":
        case "hrs":
        case "hr":
        case "h":
          return n2 * h2;
        case "minutes":
        case "minute":
        case "mins":
        case "min":
        case "m":
          return n2 * m2;
        case "seconds":
        case "second":
        case "secs":
        case "sec":
        case "s":
          return n2 * s2;
        case "milliseconds":
        case "millisecond":
        case "msecs":
        case "msec":
        case "ms":
          return n2;
        default:
          return void 0;
      }
    }
    function fmtShort(ms2) {
      if (ms2 >= d2) {
        return Math.round(ms2 / d2) + "d";
      }
      if (ms2 >= h2) {
        return Math.round(ms2 / h2) + "h";
      }
      if (ms2 >= m2) {
        return Math.round(ms2 / m2) + "m";
      }
      if (ms2 >= s2) {
        return Math.round(ms2 / s2) + "s";
      }
      return ms2 + "ms";
    }
    function fmtLong(ms2) {
      return plural(ms2, d2, "day") || plural(ms2, h2, "hour") || plural(ms2, m2, "minute") || plural(ms2, s2, "second") || ms2 + " ms";
    }
    function plural(ms2, n2, name2) {
      if (ms2 < n2) {
        return;
      }
      if (ms2 < n2 * 1.5) {
        return Math.floor(ms2 / n2) + " " + name2;
      }
      return Math.ceil(ms2 / n2) + " " + name2 + "s";
    }
    return ms;
  }
  var hasRequiredDebug;
  function requireDebug() {
    if (hasRequiredDebug) return debug$1.exports;
    hasRequiredDebug = 1;
    (function(module2, exports2) {
      exports2 = module2.exports = createDebug.debug = createDebug["default"] = createDebug;
      exports2.coerce = coerce2;
      exports2.disable = disable;
      exports2.enable = enable;
      exports2.enabled = enabled;
      exports2.humanize = requireMs();
      exports2.names = [];
      exports2.skips = [];
      exports2.formatters = {};
      var prevTime;
      function selectColor(namespace2) {
        var hash = 0, i2;
        for (i2 in namespace2) {
          hash = (hash << 5) - hash + namespace2.charCodeAt(i2);
          hash |= 0;
        }
        return exports2.colors[Math.abs(hash) % exports2.colors.length];
      }
      function createDebug(namespace2) {
        function debug2() {
          if (!debug2.enabled) return;
          var self2 = debug2;
          var curr = +/* @__PURE__ */ new Date();
          var ms2 = curr - (prevTime || curr);
          self2.diff = ms2;
          self2.prev = prevTime;
          self2.curr = curr;
          prevTime = curr;
          var args2 = new Array(arguments.length);
          for (var i2 = 0; i2 < args2.length; i2++) {
            args2[i2] = arguments[i2];
          }
          args2[0] = exports2.coerce(args2[0]);
          if ("string" !== typeof args2[0]) {
            args2.unshift("%O");
          }
          var index2 = 0;
          args2[0] = args2[0].replace(/%([a-zA-Z%])/g, function(match, format2) {
            if (match === "%%") return match;
            index2++;
            var formatter = exports2.formatters[format2];
            if ("function" === typeof formatter) {
              var val = args2[index2];
              match = formatter.call(self2, val);
              args2.splice(index2, 1);
              index2--;
            }
            return match;
          });
          exports2.formatArgs.call(self2, args2);
          var logFn = debug2.log || exports2.log || console.log.bind(console);
          logFn.apply(self2, args2);
        }
        debug2.namespace = namespace2;
        debug2.enabled = exports2.enabled(namespace2);
        debug2.useColors = exports2.useColors();
        debug2.color = selectColor(namespace2);
        if ("function" === typeof exports2.init) {
          exports2.init(debug2);
        }
        return debug2;
      }
      function enable(namespaces) {
        exports2.save(namespaces);
        exports2.names = [];
        exports2.skips = [];
        var split = (typeof namespaces === "string" ? namespaces : "").split(/[\s,]+/);
        var len = split.length;
        for (var i2 = 0; i2 < len; i2++) {
          if (!split[i2]) continue;
          namespaces = split[i2].replace(/\*/g, ".*?");
          if (namespaces[0] === "-") {
            exports2.skips.push(new RegExp("^" + namespaces.substr(1) + "$"));
          } else {
            exports2.names.push(new RegExp("^" + namespaces + "$"));
          }
        }
      }
      function disable() {
        exports2.enable("");
      }
      function enabled(name2) {
        var i2, len;
        for (i2 = 0, len = exports2.skips.length; i2 < len; i2++) {
          if (exports2.skips[i2].test(name2)) {
            return false;
          }
        }
        for (i2 = 0, len = exports2.names.length; i2 < len; i2++) {
          if (exports2.names[i2].test(name2)) {
            return true;
          }
        }
        return false;
      }
      function coerce2(val) {
        if (val instanceof Error) return val.stack || val.message;
        return val;
      }
    })(debug$1, debug$1.exports);
    return debug$1.exports;
  }
  var hasRequiredBrowser;
  function requireBrowser() {
    if (hasRequiredBrowser) return browser.exports;
    hasRequiredBrowser = 1;
    (function(module2, exports2) {
      exports2 = module2.exports = requireDebug();
      exports2.log = log2;
      exports2.formatArgs = formatArgs;
      exports2.save = save;
      exports2.load = load2;
      exports2.useColors = useColors;
      exports2.storage = "undefined" != typeof chrome && "undefined" != typeof chrome.storage ? chrome.storage.local : localstorage();
      exports2.colors = [
        "lightseagreen",
        "forestgreen",
        "goldenrod",
        "dodgerblue",
        "darkorchid",
        "crimson"
      ];
      function useColors() {
        if (typeof window !== "undefined" && window.process && window.process.type === "renderer") {
          return true;
        }
        return typeof document !== "undefined" && document.documentElement && document.documentElement.style && document.documentElement.style.WebkitAppearance || // is firebug? http://stackoverflow.com/a/398120/376773
        typeof window !== "undefined" && window.console && (window.console.firebug || window.console.exception && window.console.table) || // is firefox >= v31?
        // https://developer.mozilla.org/en-US/docs/Tools/Web_Console#Styling_messages
        typeof navigator !== "undefined" && navigator.userAgent && navigator.userAgent.toLowerCase().match(/firefox\/(\d+)/) && parseInt(RegExp.$1, 10) >= 31 || // double check webkit in userAgent just in case we are in a worker
        typeof navigator !== "undefined" && navigator.userAgent && navigator.userAgent.toLowerCase().match(/applewebkit\/(\d+)/);
      }
      exports2.formatters.j = function(v2) {
        try {
          return JSON.stringify(v2);
        } catch (err) {
          return "[UnexpectedJSONParseError]: " + err.message;
        }
      };
      function formatArgs(args2) {
        var useColors2 = this.useColors;
        args2[0] = (useColors2 ? "%c" : "") + this.namespace + (useColors2 ? " %c" : " ") + args2[0] + (useColors2 ? "%c " : " ") + "+" + exports2.humanize(this.diff);
        if (!useColors2) return;
        var c2 = "color: " + this.color;
        args2.splice(1, 0, c2, "color: inherit");
        var index2 = 0;
        var lastC = 0;
        args2[0].replace(/%[a-zA-Z%]/g, function(match) {
          if ("%%" === match) return;
          index2++;
          if ("%c" === match) {
            lastC = index2;
          }
        });
        args2.splice(lastC, 0, c2);
      }
      function log2() {
        return "object" === typeof console && console.log && Function.prototype.apply.call(console.log, console, arguments);
      }
      function save(namespaces) {
        try {
          if (null == namespaces) {
            exports2.storage.removeItem("debug");
          } else {
            exports2.storage.debug = namespaces;
          }
        } catch (e2) {
        }
      }
      function load2() {
        var r2;
        try {
          r2 = exports2.storage.debug;
        } catch (e2) {
        }
        if (!r2 && typeof process !== "undefined" && "env" in process) {
          r2 = process.env.DEBUG;
        }
        return r2;
      }
      exports2.enable(load2());
      function localstorage() {
        try {
          return window.localStorage;
        } catch (e2) {
        }
      }
    })(browser, browser.exports);
    return browser.exports;
  }
  var node = { exports: {} };
  var hasRequiredNode;
  function requireNode() {
    if (hasRequiredNode) return node.exports;
    hasRequiredNode = 1;
    (function(module2, exports2) {
      var tty2 = require$$0$3;
      var util2 = require$$5$1;
      exports2 = module2.exports = requireDebug();
      exports2.init = init2;
      exports2.log = log2;
      exports2.formatArgs = formatArgs;
      exports2.save = save;
      exports2.load = load2;
      exports2.useColors = useColors;
      exports2.colors = [6, 2, 3, 4, 5, 1];
      exports2.inspectOpts = Object.keys(process.env).filter(function(key) {
        return /^debug_/i.test(key);
      }).reduce(function(obj, key) {
        var prop = key.substring(6).toLowerCase().replace(/_([a-z])/g, function(_2, k2) {
          return k2.toUpperCase();
        });
        var val = process.env[key];
        if (/^(yes|on|true|enabled)$/i.test(val)) val = true;
        else if (/^(no|off|false|disabled)$/i.test(val)) val = false;
        else if (val === "null") val = null;
        else val = Number(val);
        obj[prop] = val;
        return obj;
      }, {});
      var fd = parseInt(process.env.DEBUG_FD, 10) || 2;
      if (1 !== fd && 2 !== fd) {
        util2.deprecate(function() {
        }, "except for stderr(2) and stdout(1), any other usage of DEBUG_FD is deprecated. Override debug.log if you want to use a different log function (https://git.io/debug_fd)")();
      }
      var stream2 = 1 === fd ? process.stdout : 2 === fd ? process.stderr : createWritableStdioStream(fd);
      function useColors() {
        return "colors" in exports2.inspectOpts ? Boolean(exports2.inspectOpts.colors) : tty2.isatty(fd);
      }
      exports2.formatters.o = function(v2) {
        this.inspectOpts.colors = this.useColors;
        return util2.inspect(v2, this.inspectOpts).split("\n").map(function(str) {
          return str.trim();
        }).join(" ");
      };
      exports2.formatters.O = function(v2) {
        this.inspectOpts.colors = this.useColors;
        return util2.inspect(v2, this.inspectOpts);
      };
      function formatArgs(args2) {
        var name2 = this.namespace;
        var useColors2 = this.useColors;
        if (useColors2) {
          var c2 = this.color;
          var prefix = "  \x1B[3" + c2 + ";1m" + name2 + " \x1B[0m";
          args2[0] = prefix + args2[0].split("\n").join("\n" + prefix);
          args2.push("\x1B[3" + c2 + "m+" + exports2.humanize(this.diff) + "\x1B[0m");
        } else {
          args2[0] = (/* @__PURE__ */ new Date()).toUTCString() + " " + name2 + " " + args2[0];
        }
      }
      function log2() {
        return stream2.write(util2.format.apply(util2, arguments) + "\n");
      }
      function save(namespaces) {
        if (null == namespaces) {
          delete process.env.DEBUG;
        } else {
          process.env.DEBUG = namespaces;
        }
      }
      function load2() {
        return process.env.DEBUG;
      }
      function createWritableStdioStream(fd2) {
        var stream3;
        var tty_wrap = process.binding("tty_wrap");
        switch (tty_wrap.guessHandleType(fd2)) {
          case "TTY":
            stream3 = new tty2.WriteStream(fd2);
            stream3._type = "tty";
            if (stream3._handle && stream3._handle.unref) {
              stream3._handle.unref();
            }
            break;
          case "FILE":
            var fs2 = require$$0$2;
            stream3 = new fs2.SyncWriteStream(fd2, { autoClose: false });
            stream3._type = "fs";
            break;
          case "PIPE":
          case "TCP":
            var net2 = require$$0$6;
            stream3 = new net2.Socket({
              fd: fd2,
              readable: false,
              writable: true
            });
            stream3.readable = false;
            stream3.read = null;
            stream3._type = "pipe";
            if (stream3._handle && stream3._handle.unref) {
              stream3._handle.unref();
            }
            break;
          default:
            throw new Error("Implement me. Unknown stream file type!");
        }
        stream3.fd = fd2;
        stream3._isStdio = true;
        return stream3;
      }
      function init2(debug2) {
        debug2.inspectOpts = {};
        var keys2 = Object.keys(exports2.inspectOpts);
        for (var i2 = 0; i2 < keys2.length; i2++) {
          debug2.inspectOpts[keys2[i2]] = exports2.inspectOpts[keys2[i2]];
        }
      }
      exports2.enable(load2());
    })(node, node.exports);
    return node.exports;
  }
  if (typeof process !== "undefined" && process.type === "renderer") {
    src$1.exports = requireBrowser();
  } else {
    src$1.exports = requireNode();
  }
  var srcExports$1 = src$1.exports;
  var path$b = path$k;
  var spawn$2 = require$$0$7.spawn;
  var debug = srcExports$1("electron-squirrel-startup");
  var app = electron$1.app;
  var run = function(args2, done) {
    var updateExe = path$b.resolve(path$b.dirname(process.execPath), "..", "Update.exe");
    debug("Spawning `%s` with args `%s`", updateExe, args2);
    spawn$2(updateExe, args2, {
      detached: true
    }).on("close", done);
  };
  var check = function() {
    if (process.platform === "win32") {
      var cmd = process.argv[1];
      debug("processing squirrel command `%s`", cmd);
      var target = path$b.basename(process.execPath);
      if (cmd === "--squirrel-install" || cmd === "--squirrel-updated") {
        run(["--createShortcut=" + target], app.quit);
        return true;
      }
      if (cmd === "--squirrel-uninstall") {
        run(["--removeShortcut=" + target], app.quit);
        return true;
      }
      if (cmd === "--squirrel-obsolete") {
        app.quit();
        return true;
      }
    }
    return false;
  };
  var electronSquirrelStartup = check();
  const squirrelStartup = /* @__PURE__ */ getDefaultExportFromCjs(electronSquirrelStartup);
  const appClientName = "Desktop Kauai";
  const appOrigin = "https://app.shortwave.com";
  const appVersion = "2026-02-18";
  const buildCommit = "403cd70f263b170d32852f34f42da5c9f586b9c7";
  const buildVersion = "1";
  const bundleId = "com.shortwave.desktopapp";
  const desktopAppUrlScheme = "shortwave";
  const desktopPublishConfig = {
    publishBucket: "shortwave-downloads",
    publishProjectId: "shortwave-marketing-website",
    publishUrl: "https://storage.googleapis.com/shortwave-downloads/desktop_app"
  };
  const firebaseConfig = {
    apiKey: "AIzaSyC0ACK6F73MNsDwLPqAxqh87oBCRaiTbQ0",
    appId: "1:281799484056:web:6543de5ec4a34a75a666ed",
    authDomain: "subspace-prod-272821.firebaseapp.com",
    messagingSenderId: "281799484056",
    messagingVapidKey: "BKNvhFXtHQ9V3-cEbpNTikX7iB49X53wFQiokPWu9SFx4rE3bTWxPbzvOcOiAz2hU2rEH6Zp167z6ez6mRbTQJ8",
    projectId: "subspace-prod-272821"
  };
  const isDeveloperMode = false;
  const localDesktopAppUrlScheme = "shortwave-dev";
  const macIconName = "icon_darwin";
  const productName = "Shortwave";
  const protocolVersion = 53;
  const sentryDsn = "https://e01eac25ced295e954d501cd9080bcd3@o373565.ingest.us.sentry.io/4508303521480704";
  const winIconName = "icon_win32";
  const config = {
    appClientName,
    appOrigin,
    appVersion,
    buildCommit,
    buildVersion,
    bundleId,
    desktopAppUrlScheme,
    desktopPublishConfig,
    firebaseConfig,
    isDeveloperMode,
    localDesktopAppUrlScheme,
    macIconName,
    productName,
    protocolVersion,
    sentryDsn,
    winIconName
  };
  var SupportedPlatform = /* @__PURE__ */ ((SupportedPlatform2) => {
    SupportedPlatform2["Windows"] = "win32";
    SupportedPlatform2["MacOS"] = "darwin";
    return SupportedPlatform2;
  })(SupportedPlatform || {});
  let platform;
  switch (process.platform) {
    case "win32":
      platform = "win32";
      break;
    case "darwin":
      platform = "darwin";
      break;
    default:
      throw new Error(`Unsupported platform: ${process.platform}`);
  }
  var Platform;
  ((Platform2) => {
    function select2(options) {
      return options[platform];
    }
    Platform2.select = select2;
  })(Platform || (Platform = {}));
  const userAgent = `${electron$1.app.name}/${electron$1.app.getVersion()} (${require$$0$1.platform()}: ${require$$0$1.arch()})`;
  class AutoUpdaterService {
    constructor(logger2) {
      __publicField(this, "feedUrl");
      __publicField(this, "availableUpdate", null);
      __publicField(this, "updateAvailableHandlers", /* @__PURE__ */ new Set());
      this.logger = logger2;
      this.feedUrl = Platform.select({
        [SupportedPlatform.Windows]: `${config.desktopPublishConfig.publishUrl}/win32/x64`,
        [SupportedPlatform.MacOS]: `${config.desktopPublishConfig.publishUrl}/darwin/universal/RELEASES.json`
      });
      if (!electron$1.app.isPackaged) {
        this.logger.info("Running app in un-packaged mode. Skipping auto updater setup.");
        return;
      }
      this.logger.info(`Setting up auto updater. Feed URL: ${this.feedUrl}`);
      electron$1.autoUpdater.setFeedURL({
        url: this.feedUrl,
        headers: {
          "User-Agent": userAgent
        },
        serverType: "json"
      });
      electron$1.autoUpdater.on("error", (error2) => {
        this.logger.warn("Failed to check for updates", { error: error2 });
      });
      electron$1.autoUpdater.on("checking-for-update", () => {
        this.logger.info("Checking for update...");
      });
      electron$1.autoUpdater.on("update-available", () => {
        this.logger.info("Update available; downloading...");
      });
      electron$1.autoUpdater.on("update-not-available", () => {
        this.logger.info("Update not available");
      });
      electron$1.autoUpdater.on(
        "update-downloaded",
        (event, releaseNotes, releaseName, releaseDate, updateURL) => {
          this.logger.info(
            `Update downloaded: ${JSON.stringify({ releaseNotes, releaseName, releaseDate, updateURL })}`
          );
          this.availableUpdate = releaseName;
          for (const handler of this.updateAvailableHandlers) {
            handler(releaseName);
          }
        }
      );
      electron$1.autoUpdater.checkForUpdates();
      setInterval(
        () => {
          electron$1.autoUpdater.checkForUpdates();
        },
        // every 24 hours
        24 * 60 * 60 * 1e3
      );
    }
    getAvailableUpdate() {
      return this.availableUpdate;
    }
    onUpdateAvailable(handler) {
      this.updateAvailableHandlers.add(handler);
      if (this.availableUpdate) {
        handler(this.availableUpdate);
      }
      return () => {
        this.updateAvailableHandlers.delete(handler);
      };
    }
    checkForUpdates() {
      electron$1.autoUpdater.checkForUpdates();
    }
    async quitAndInstall() {
      electron$1.autoUpdater.quitAndInstall();
    }
  }
  const registerContextMenuHandler = (window2, options) => {
    const handleContextMenu = (event, params) => {
      const { editFlags, isEditable, misspelledWord, selectionText, linkURL } = params;
      const { canCopy, canCut } = editFlags;
      const hasText = selectionText.length > 0;
      const isLink = Boolean(linkURL);
      const trimmedSelectionText = selectionText.trim().slice(0, 25).replace(/&/g, "&&");
      const contextMenuItems = {
        separator: { type: "separator" },
        learnSpelling: {
          id: "learnSpelling",
          label: "&Learn Spelling",
          visible: Boolean(isEditable && hasText && misspelledWord),
          click() {
            window2.webContents.session.addWordToSpellCheckerDictionary(misspelledWord);
          }
        },
        lookUpSelection: {
          id: "lookUpSelection",
          label: `Look Up “${trimmedSelectionText}”`,
          visible: process.platform === "darwin" && hasText && !isLink,
          click() {
            if (process.platform === "darwin") {
              window2.webContents.showDefinitionForSelection();
            }
          }
        },
        cut: {
          id: "cut",
          label: "Cu&t",
          enabled: canCut,
          visible: params.isEditable,
          click() {
            window2.webContents.cut();
          }
        },
        copy: {
          id: "copy",
          label: "&Copy",
          enabled: canCopy,
          visible: params.isEditable || hasText,
          click() {
            window2.webContents.copy();
          }
        },
        paste: {
          id: "paste",
          label: "&Paste",
          enabled: editFlags.canPaste,
          visible: params.isEditable,
          click() {
            window2.webContents.paste();
          }
        },
        selectAll: {
          id: "selectAll",
          label: "Select &All",
          visible: process.platform !== "darwin" && (params.isEditable || hasText),
          click() {
            window2.webContents.selectAll();
          }
        },
        copyLink: {
          id: "copyLink",
          label: "Copy Lin&k",
          visible: params.linkURL.length > 0 && params.mediaType === "none",
          click() {
            electron$1.clipboard.write({
              bookmark: params.linkText,
              text: params.linkURL
            });
          }
        },
        copyImage: {
          id: "copyImage",
          label: "Cop&y Image",
          visible: params.mediaType === "image",
          click() {
            window2.webContents.copyImageAt(params.x, params.y);
          }
        },
        copyImageAddress: {
          id: "copyImageAddress",
          label: "C&opy Image Address",
          visible: params.mediaType === "image",
          click() {
            electron$1.clipboard.write({
              bookmark: params.srcURL,
              text: params.srcURL
            });
          }
        },
        copyVideoAddress: {
          id: "copyVideoAddress",
          label: "Copy Video Ad&dress",
          visible: params.mediaType === "video",
          click() {
            electron$1.clipboard.write({
              bookmark: params.srcURL,
              text: params.srcURL
            });
          }
        },
        inspect: {
          id: "inspect",
          label: "I&nspect Element",
          visible: options.isDev,
          click() {
            var _a3;
            window2.webContents.inspectElement(params.x, params.y);
            if (window2.webContents.isDevToolsOpened()) {
              (_a3 = window2.webContents.devToolsWebContents) == null ? void 0 : _a3.focus();
            }
          }
        },
        services: {
          id: "services",
          label: "Services",
          role: "services",
          visible: process.platform === "darwin" && (params.isEditable || hasText)
        }
      };
      let dictionarySuggestions = [];
      if (hasText && params.misspelledWord && params.dictionarySuggestions.length > 0) {
        dictionarySuggestions = params.dictionarySuggestions.map((suggestion) => ({
          id: "dictionarySuggestions",
          label: suggestion,
          visible: Boolean(params.isEditable && hasText && params.misspelledWord),
          click() {
            window2.webContents.replaceMisspelling(suggestion);
          }
        }));
      } else {
        dictionarySuggestions.push({
          id: "dictionarySuggestions",
          label: "No Guesses Found",
          visible: Boolean(hasText && params.misspelledWord),
          enabled: false
        });
      }
      function filterHiddenMenuItems(items) {
        return items.filter(
          (item) => !!item && item.visible !== false
        );
      }
      const menuTemplate = filterHiddenMenuItems([
        dictionarySuggestions.length > 0 ? contextMenuItems.separator : null,
        ...dictionarySuggestions,
        contextMenuItems.separator,
        contextMenuItems.learnSpelling,
        contextMenuItems.separator,
        contextMenuItems.lookUpSelection,
        contextMenuItems.separator,
        contextMenuItems.cut,
        contextMenuItems.copy,
        contextMenuItems.paste,
        contextMenuItems.selectAll,
        contextMenuItems.separator,
        contextMenuItems.copyImage,
        contextMenuItems.copyImageAddress,
        contextMenuItems.copyVideoAddress,
        contextMenuItems.separator,
        contextMenuItems.copyLink,
        contextMenuItems.separator,
        contextMenuItems.inspect,
        contextMenuItems.services,
        contextMenuItems.separator
      ]);
      const menu = electron$1.Menu.buildFromTemplate(menuTemplate);
      menu.popup({ window: window2 });
    };
    window2.webContents.on("context-menu", handleContextMenu);
    return () => {
      window2.webContents.off("context-menu", handleContextMenu);
    };
  };
  const APP_SCHEMES = [config.desktopAppUrlScheme, "mailto"];
  const SUPPORTED_SCHEMES = [...APP_SCHEMES, "http", "https"];
  class DeepLinksService {
    constructor(logger2) {
      __publicField(this, "deepLinkEventsQueue", []);
      __publicField(this, "handler");
      this.logger = logger2;
    }
    setHandler(handler) {
      if (this.handler) {
        throw new Error("Attempted to set deep link handler, but handler already set");
      }
      this.handler = handler;
      for (const url2 of this.deepLinkEventsQueue) {
        handler(url2);
      }
      this.deepLinkEventsQueue = [];
    }
    handleDeepLinkUrl(url2) {
      this.logger.info("Received deep link url");
      if (this.handler) {
        this.handler(url2);
      } else {
        this.logger.info("No handler set, adding to queue");
        this.deepLinkEventsQueue.push(url2);
      }
    }
    // This needs to happen at the top level of the app before it emits the ready event
    static setup(logger2) {
      const gotTheLock = electron$1.app.requestSingleInstanceLock();
      if (!gotTheLock) electron$1.app.quit();
      for (const protocol of APP_SCHEMES) {
        const set2 = electron$1.app.setAsDefaultProtocolClient(protocol);
        if (!set2) {
          logger2.warn(`Failed to set as default protocol client for protocol "${protocol}"`);
        }
      }
      const deepLinks2 = new DeepLinksService(logger2);
      electron$1.app.on("second-instance", (event, commandLine) => {
        logger2.info("Received second-instance event");
        let url2;
        try {
          const urlString = commandLine[commandLine.length - 1];
          url2 = new URL(urlString);
        } catch (_2) {
          return;
        }
        if (!SUPPORTED_SCHEMES.some((protocol) => url2.protocol === `${protocol}:`)) {
          logger2.info(`Command line argument is not a supported protocol (scheme: ${url2.protocol})`);
          return;
        }
        deepLinks2.handleDeepLinkUrl(url2);
      });
      electron$1.app.on("open-url", (event, url2) => {
        logger2.info("Received open-url event");
        const parsed2 = new URL(url2);
        event.preventDefault();
        deepLinks2.handleDeepLinkUrl(parsed2);
      });
      return deepLinks2;
    }
  }
  var IPCEvent = /* @__PURE__ */ ((IPCEvent2) => {
    IPCEvent2["SetAsDefaultMailApp"] = "set-as-default-mail-app";
    IPCEvent2["SetDebugMode"] = "set-debug-mode";
    IPCEvent2["RestartAndUpdate"] = "restart-and-update";
    IPCEvent2["SetSentryUserId"] = "set-sentry-user-id";
    IPCEvent2["GetAppVersion"] = "get-app-version";
    IPCEvent2["Print"] = "print";
    IPCEvent2["OpenSystemNotificationSettings"] = "open-system-notification-settings";
    IPCEvent2["ClearNotificationsForAccount"] = "clear-notifications-for-account";
    IPCEvent2["CallMcpTool"] = "call-mcp-tool";
    IPCEvent2["UpdateMcpConfig"] = "update-mcp-config";
    IPCEvent2["PushNotification"] = "push-notification";
    IPCEvent2["PushToken"] = "push-token";
    IPCEvent2["Mailto"] = "mailto";
    IPCEvent2["UpdateAvailable"] = "update-available";
    IPCEvent2["OauthToken"] = "oauth-token";
    IPCEvent2["OpenAppLink"] = "open-app-link";
    IPCEvent2["McpConfigUpdate"] = "mcp-config-update";
    return IPCEvent2;
  })(IPCEvent || {});
  var FindInPageIPCEvent = /* @__PURE__ */ ((FindInPageIPCEvent2) => {
    FindInPageIPCEvent2["FindInPage"] = "find-in-page";
    FindInPageIPCEvent2["StopFindInPage"] = "stop-find-in-page";
    FindInPageIPCEvent2["CloseFindInPage"] = "close-find-in-page";
    FindInPageIPCEvent2["FindInPageResult"] = "find-in-page-result";
    return FindInPageIPCEvent2;
  })(FindInPageIPCEvent || {});
  const fs$6 = require$$0$2;
  const path$a = path$k;
  var packageJson$1 = {
    findAndReadPackageJson,
    tryReadJsonAt
  };
  function findAndReadPackageJson() {
    return tryReadJsonAt(getMainModulePath()) || tryReadJsonAt(extractPathFromArgs()) || tryReadJsonAt(process.resourcesPath, "app.asar") || tryReadJsonAt(process.resourcesPath, "app") || tryReadJsonAt(process.cwd()) || { name: void 0, version: void 0 };
  }
  function tryReadJsonAt(...searchPaths) {
    if (!searchPaths[0]) {
      return void 0;
    }
    try {
      const searchPath = path$a.join(...searchPaths);
      const fileName = findUp("package.json", searchPath);
      if (!fileName) {
        return void 0;
      }
      const json = JSON.parse(fs$6.readFileSync(fileName, "utf8"));
      const name2 = (json == null ? void 0 : json.productName) || (json == null ? void 0 : json.name);
      if (!name2 || name2.toLowerCase() === "electron") {
        return void 0;
      }
      if (name2) {
        return { name: name2, version: json == null ? void 0 : json.version };
      }
      return void 0;
    } catch (e2) {
      return void 0;
    }
  }
  function findUp(fileName, cwd) {
    let currentPath = cwd;
    while (true) {
      const parsedPath = path$a.parse(currentPath);
      const root2 = parsedPath.root;
      const dir = parsedPath.dir;
      if (fs$6.existsSync(path$a.join(currentPath, fileName))) {
        return path$a.resolve(path$a.join(currentPath, fileName));
      }
      if (currentPath === root2) {
        return null;
      }
      currentPath = dir;
    }
  }
  function extractPathFromArgs() {
    const matchedArgs = process.argv.filter((arg) => {
      return arg.indexOf("--user-data-dir=") === 0;
    });
    if (matchedArgs.length === 0 || typeof matchedArgs[0] !== "string") {
      return null;
    }
    const userDataDir = matchedArgs[0];
    return userDataDir.replace("--user-data-dir=", "");
  }
  function getMainModulePath() {
    var _a3;
    try {
      return (_a3 = require.main) == null ? void 0 : _a3.filename;
    } catch {
      return void 0;
    }
  }
  const childProcess$1 = require$$0$7;
  const os$4 = require$$0$1;
  const path$9 = path$k;
  const packageJson = packageJson$1;
  let NodeExternalApi$1 = class NodeExternalApi {
    constructor() {
      __publicField(this, "appName");
      __publicField(this, "appPackageJson");
      __publicField(this, "platform", process.platform);
    }
    getAppLogPath(appName = this.getAppName()) {
      if (this.platform === "darwin") {
        return path$9.join(this.getSystemPathHome(), "Library/Logs", appName);
      }
      return path$9.join(this.getAppUserDataPath(appName), "logs");
    }
    getAppName() {
      var _a3;
      const appName = this.appName || ((_a3 = this.getAppPackageJson()) == null ? void 0 : _a3.name);
      if (!appName) {
        throw new Error(
          "electron-log can't determine the app name. It tried these methods:\n1. Use `electron.app.name`\n2. Use productName or name from the nearest package.json`\nYou can also set it through log.transports.file.setAppName()"
        );
      }
      return appName;
    }
    /**
     * @private
     * @returns {undefined}
     */
    getAppPackageJson() {
      if (typeof this.appPackageJson !== "object") {
        this.appPackageJson = packageJson.findAndReadPackageJson();
      }
      return this.appPackageJson;
    }
    getAppUserDataPath(appName = this.getAppName()) {
      return appName ? path$9.join(this.getSystemPathAppData(), appName) : void 0;
    }
    getAppVersion() {
      var _a3;
      return (_a3 = this.getAppPackageJson()) == null ? void 0 : _a3.version;
    }
    getElectronLogPath() {
      return this.getAppLogPath();
    }
    getMacOsVersion() {
      const release = Number(os$4.release().split(".")[0]);
      if (release <= 19) {
        return `10.${release - 4}`;
      }
      return release - 9;
    }
    /**
     * @protected
     * @returns {string}
     */
    getOsVersion() {
      let osName = os$4.type().replace("_", " ");
      let osVersion = os$4.release();
      if (osName === "Darwin") {
        osName = "macOS";
        osVersion = this.getMacOsVersion();
      }
      return `${osName} ${osVersion}`;
    }
    /**
     * @return {PathVariables}
     */
    getPathVariables() {
      const appName = this.getAppName();
      const appVersion2 = this.getAppVersion();
      const self2 = this;
      return {
        appData: this.getSystemPathAppData(),
        appName,
        appVersion: appVersion2,
        get electronDefaultDir() {
          return self2.getElectronLogPath();
        },
        home: this.getSystemPathHome(),
        libraryDefaultDir: this.getAppLogPath(appName),
        libraryTemplate: this.getAppLogPath("{appName}"),
        temp: this.getSystemPathTemp(),
        userData: this.getAppUserDataPath(appName)
      };
    }
    getSystemPathAppData() {
      const home = this.getSystemPathHome();
      switch (this.platform) {
        case "darwin": {
          return path$9.join(home, "Library/Application Support");
        }
        case "win32": {
          return process.env.APPDATA || path$9.join(home, "AppData/Roaming");
        }
        default: {
          return process.env.XDG_CONFIG_HOME || path$9.join(home, ".config");
        }
      }
    }
    getSystemPathHome() {
      var _a3;
      return ((_a3 = os$4.homedir) == null ? void 0 : _a3.call(os$4)) || process.env.HOME;
    }
    getSystemPathTemp() {
      return os$4.tmpdir();
    }
    getVersions() {
      return {
        app: `${this.getAppName()} ${this.getAppVersion()}`,
        electron: void 0,
        os: this.getOsVersion()
      };
    }
    isDev() {
      return process.env.NODE_ENV === "development" || process.env.ELECTRON_IS_DEV === "1";
    }
    isElectron() {
      return Boolean(process.versions.electron);
    }
    onAppEvent(_eventName, _handler) {
    }
    onAppReady(handler) {
      handler();
    }
    onEveryWebContentsEvent(eventName, handler) {
    }
    /**
     * Listen to async messages sent from opposite process
     * @param {string} channel
     * @param {function} listener
     */
    onIpc(channel, listener) {
    }
    onIpcInvoke(channel, listener) {
    }
    /**
     * @param {string} url
     * @param {Function} [logFunction]
     */
    openUrl(url2, logFunction = console.error) {
      const startMap = { darwin: "open", win32: "start", linux: "xdg-open" };
      const start = startMap[process.platform] || "xdg-open";
      childProcess$1.exec(`${start} ${url2}`, {}, (err) => {
        if (err) {
          logFunction(err);
        }
      });
    }
    setAppName(appName) {
      this.appName = appName;
    }
    setPlatform(platform2) {
      this.platform = platform2;
    }
    setPreloadFileForSessions({
      filePath,
      // eslint-disable-line no-unused-vars
      includeFutureSession = true,
      // eslint-disable-line no-unused-vars
      getSessions = () => []
      // eslint-disable-line no-unused-vars
    }) {
    }
    /**
     * Sent a message to opposite process
     * @param {string} channel
     * @param {any} message
     */
    sendIpc(channel, message2) {
    }
    showErrorBox(title, message2) {
    }
  };
  var NodeExternalApi_1 = NodeExternalApi$1;
  const path$8 = path$k;
  const NodeExternalApi = NodeExternalApi_1;
  let ElectronExternalApi$1 = class ElectronExternalApi extends NodeExternalApi {
    /**
     * @param {object} options
     * @param {typeof Electron} [options.electron]
     */
    constructor({ electron: electron2 } = {}) {
      super();
      /**
       * @type {typeof Electron}
       */
      __publicField(this, "electron");
      this.electron = electron2;
    }
    getAppName() {
      var _a3, _b2;
      let appName;
      try {
        appName = this.appName || ((_a3 = this.electron.app) == null ? void 0 : _a3.name) || ((_b2 = this.electron.app) == null ? void 0 : _b2.getName());
      } catch {
      }
      return appName || super.getAppName();
    }
    getAppUserDataPath(appName) {
      return this.getPath("userData") || super.getAppUserDataPath(appName);
    }
    getAppVersion() {
      var _a3;
      let appVersion2;
      try {
        appVersion2 = (_a3 = this.electron.app) == null ? void 0 : _a3.getVersion();
      } catch {
      }
      return appVersion2 || super.getAppVersion();
    }
    getElectronLogPath() {
      return this.getPath("logs") || super.getElectronLogPath();
    }
    /**
     * @private
     * @param {any} name
     * @returns {string|undefined}
     */
    getPath(name2) {
      var _a3;
      try {
        return (_a3 = this.electron.app) == null ? void 0 : _a3.getPath(name2);
      } catch {
        return void 0;
      }
    }
    getVersions() {
      return {
        app: `${this.getAppName()} ${this.getAppVersion()}`,
        electron: `Electron ${process.versions.electron}`,
        os: this.getOsVersion()
      };
    }
    getSystemPathAppData() {
      return this.getPath("appData") || super.getSystemPathAppData();
    }
    isDev() {
      var _a3;
      if (((_a3 = this.electron.app) == null ? void 0 : _a3.isPackaged) !== void 0) {
        return !this.electron.app.isPackaged;
      }
      if (typeof process.execPath === "string") {
        const execFileName = path$8.basename(process.execPath).toLowerCase();
        return execFileName.startsWith("electron");
      }
      return super.isDev();
    }
    onAppEvent(eventName, handler) {
      var _a3;
      (_a3 = this.electron.app) == null ? void 0 : _a3.on(eventName, handler);
      return () => {
        var _a4;
        (_a4 = this.electron.app) == null ? void 0 : _a4.off(eventName, handler);
      };
    }
    onAppReady(handler) {
      var _a3, _b2, _c2;
      if ((_a3 = this.electron.app) == null ? void 0 : _a3.isReady()) {
        handler();
      } else if ((_b2 = this.electron.app) == null ? void 0 : _b2.once) {
        (_c2 = this.electron.app) == null ? void 0 : _c2.once("ready", handler);
      } else {
        handler();
      }
    }
    onEveryWebContentsEvent(eventName, handler) {
      var _a3, _b2, _c2;
      (_b2 = (_a3 = this.electron.webContents) == null ? void 0 : _a3.getAllWebContents()) == null ? void 0 : _b2.forEach((webContents) => {
        webContents.on(eventName, handler);
      });
      (_c2 = this.electron.app) == null ? void 0 : _c2.on("web-contents-created", onWebContentsCreated);
      return () => {
        var _a4, _b3;
        (_a4 = this.electron.webContents) == null ? void 0 : _a4.getAllWebContents().forEach((webContents) => {
          webContents.off(eventName, handler);
        });
        (_b3 = this.electron.app) == null ? void 0 : _b3.off("web-contents-created", onWebContentsCreated);
      };
      function onWebContentsCreated(_2, webContents) {
        webContents.on(eventName, handler);
      }
    }
    /**
     * Listen to async messages sent from opposite process
     * @param {string} channel
     * @param {function} listener
     */
    onIpc(channel, listener) {
      var _a3;
      (_a3 = this.electron.ipcMain) == null ? void 0 : _a3.on(channel, listener);
    }
    onIpcInvoke(channel, listener) {
      var _a3, _b2;
      (_b2 = (_a3 = this.electron.ipcMain) == null ? void 0 : _a3.handle) == null ? void 0 : _b2.call(_a3, channel, listener);
    }
    /**
     * @param {string} url
     * @param {Function} [logFunction]
     */
    openUrl(url2, logFunction = console.error) {
      var _a3;
      (_a3 = this.electron.shell) == null ? void 0 : _a3.openExternal(url2).catch(logFunction);
    }
    setPreloadFileForSessions({
      filePath,
      includeFutureSession = true,
      getSessions = () => {
        var _a3;
        return [(_a3 = this.electron.session) == null ? void 0 : _a3.defaultSession];
      }
    }) {
      for (const session of getSessions().filter(Boolean)) {
        setPreload(session);
      }
      if (includeFutureSession) {
        this.onAppEvent("session-created", (session) => {
          setPreload(session);
        });
      }
      function setPreload(session) {
        session.setPreloads([...session.getPreloads(), filePath]);
      }
    }
    /**
     * Sent a message to opposite process
     * @param {string} channel
     * @param {any} message
     */
    sendIpc(channel, message2) {
      var _a3, _b2;
      (_b2 = (_a3 = this.electron.BrowserWindow) == null ? void 0 : _a3.getAllWindows()) == null ? void 0 : _b2.forEach((wnd) => {
        var _a4;
        if (((_a4 = wnd.webContents) == null ? void 0 : _a4.isDestroyed()) === false) {
          wnd.webContents.send(channel, message2);
        }
      });
    }
    showErrorBox(title, message2) {
      var _a3;
      (_a3 = this.electron.dialog) == null ? void 0 : _a3.showErrorBox(title, message2);
    }
  };
  var ElectronExternalApi_1 = ElectronExternalApi$1;
  var electronLogPreload = { exports: {} };
  (function(module2) {
    let electron2 = {};
    try {
      electron2 = require("electron");
    } catch (e2) {
    }
    if (electron2.ipcRenderer) {
      initialize2(electron2);
    }
    {
      module2.exports = initialize2;
    }
    function initialize2({ contextBridge, ipcRenderer }) {
      if (!ipcRenderer) {
        return;
      }
      ipcRenderer.on("__ELECTRON_LOG_IPC__", (_2, message2) => {
        window.postMessage({ cmd: "message", ...message2 });
      });
      ipcRenderer.invoke("__ELECTRON_LOG__", { cmd: "getOptions" }).catch((e2) => console.error(new Error(
        `electron-log isn't initialized in the main process. Please call log.initialize() before. ${e2.message}`
      )));
      const electronLog = {
        sendToMain(message2) {
          try {
            ipcRenderer.send("__ELECTRON_LOG__", message2);
          } catch (e2) {
            console.error("electronLog.sendToMain ", e2, "data:", message2);
            ipcRenderer.send("__ELECTRON_LOG__", {
              cmd: "errorHandler",
              error: { message: e2 == null ? void 0 : e2.message, stack: e2 == null ? void 0 : e2.stack },
              errorName: "sendToMain"
            });
          }
        },
        log(...data2) {
          electronLog.sendToMain({ data: data2, level: "info" });
        }
      };
      for (const level of ["error", "warn", "info", "verbose", "debug", "silly"]) {
        electronLog[level] = (...data2) => electronLog.sendToMain({
          data: data2,
          level
        });
      }
      if (contextBridge && process.contextIsolated) {
        try {
          contextBridge.exposeInMainWorld("__electronLog", electronLog);
        } catch {
        }
      }
      if (typeof window === "object") {
        window.__electronLog = electronLog;
      } else {
        __electronLog = electronLog;
      }
    }
  })(electronLogPreload);
  var electronLogPreloadExports = electronLogPreload.exports;
  const fs$5 = require$$0$2;
  const os$3 = require$$0$1;
  const path$7 = path$k;
  const preloadInitializeFn = electronLogPreloadExports;
  var initialize$1 = {
    initialize({
      externalApi: externalApi2,
      getSessions,
      includeFutureSession,
      logger: logger2,
      preload = true,
      spyRendererConsole = false
    }) {
      externalApi2.onAppReady(() => {
        try {
          if (preload) {
            initializePreload({
              externalApi: externalApi2,
              getSessions,
              includeFutureSession,
              preloadOption: preload
            });
          }
          if (spyRendererConsole) {
            initializeSpyRendererConsole({ externalApi: externalApi2, logger: logger2 });
          }
        } catch (err) {
          logger2.warn(err);
        }
      });
    }
  };
  function initializePreload({
    externalApi: externalApi2,
    getSessions,
    includeFutureSession,
    preloadOption
  }) {
    let preloadPath = typeof preloadOption === "string" ? preloadOption : void 0;
    try {
      preloadPath = path$7.resolve(
        __dirname,
        "../renderer/electron-log-preload.js"
      );
    } catch {
    }
    if (!preloadPath || !fs$5.existsSync(preloadPath)) {
      preloadPath = path$7.join(
        externalApi2.getAppUserDataPath() || os$3.tmpdir(),
        "electron-log-preload.js"
      );
      const preloadCode = `
      try {
        (${preloadInitializeFn.toString()})(require('electron'));
      } catch(e) {
        console.error(e);
      }
    `;
      fs$5.writeFileSync(preloadPath, preloadCode, "utf8");
    }
    externalApi2.setPreloadFileForSessions({
      filePath: preloadPath,
      includeFutureSession,
      getSessions
    });
  }
  function initializeSpyRendererConsole({ externalApi: externalApi2, logger: logger2 }) {
    const levels = ["verbose", "info", "warning", "error"];
    externalApi2.onEveryWebContentsEvent(
      "console-message",
      (event, level, message2) => {
        logger2.processMessage({
          data: [message2],
          level: levels[level],
          variables: { processType: "renderer" }
        });
      }
    );
  }
  var scope = scopeFactory$1;
  function scopeFactory$1(logger2) {
    return Object.defineProperties(scope2, {
      defaultLabel: { value: "", writable: true },
      labelPadding: { value: true, writable: true },
      maxLabelLength: { value: 0, writable: true },
      labelLength: {
        get() {
          switch (typeof scope2.labelPadding) {
            case "boolean":
              return scope2.labelPadding ? scope2.maxLabelLength : 0;
            case "number":
              return scope2.labelPadding;
            default:
              return 0;
          }
        }
      }
    });
    function scope2(label) {
      scope2.maxLabelLength = Math.max(scope2.maxLabelLength, label.length);
      const newScope = {};
      for (const level of logger2.levels) {
        newScope[level] = (...d2) => logger2.logData(d2, { level, scope: label });
      }
      newScope.log = newScope.info;
      return newScope;
    }
  }
  let Buffering$1 = class Buffering {
    constructor({ processMessage: processMessage2 }) {
      this.processMessage = processMessage2;
      this.buffer = [];
      this.enabled = false;
      this.begin = this.begin.bind(this);
      this.commit = this.commit.bind(this);
      this.reject = this.reject.bind(this);
    }
    addMessage(message2) {
      this.buffer.push(message2);
    }
    begin() {
      this.enabled = [];
    }
    commit() {
      this.enabled = false;
      this.buffer.forEach((item) => this.processMessage(item));
      this.buffer = [];
    }
    reject() {
      this.enabled = false;
      this.buffer = [];
    }
  };
  var Buffering_1 = Buffering$1;
  const scopeFactory = scope;
  const Buffering = Buffering_1;
  let Logger$1 = (_a2 = class {
    constructor({
      allowUnknownLevel = false,
      dependencies: dependencies2 = {},
      errorHandler,
      eventLogger,
      initializeFn,
      isDev = false,
      levels = ["error", "warn", "info", "verbose", "debug", "silly"],
      logId,
      transportFactories = {},
      variables
    } = {}) {
      __publicField(this, "dependencies", {});
      __publicField(this, "errorHandler", null);
      __publicField(this, "eventLogger", null);
      __publicField(this, "functions", {});
      __publicField(this, "hooks", []);
      __publicField(this, "isDev", false);
      __publicField(this, "levels", null);
      __publicField(this, "logId", null);
      __publicField(this, "scope", null);
      __publicField(this, "transports", {});
      __publicField(this, "variables", {});
      this.addLevel = this.addLevel.bind(this);
      this.create = this.create.bind(this);
      this.initialize = this.initialize.bind(this);
      this.logData = this.logData.bind(this);
      this.processMessage = this.processMessage.bind(this);
      this.allowUnknownLevel = allowUnknownLevel;
      this.buffering = new Buffering(this);
      this.dependencies = dependencies2;
      this.initializeFn = initializeFn;
      this.isDev = isDev;
      this.levels = levels;
      this.logId = logId;
      this.scope = scopeFactory(this);
      this.transportFactories = transportFactories;
      this.variables = variables || {};
      for (const name2 of this.levels) {
        this.addLevel(name2, false);
      }
      this.log = this.info;
      this.functions.log = this.log;
      this.errorHandler = errorHandler;
      errorHandler == null ? void 0 : errorHandler.setOptions({ ...dependencies2, logFn: this.error });
      this.eventLogger = eventLogger;
      eventLogger == null ? void 0 : eventLogger.setOptions({ ...dependencies2, logger: this });
      for (const [name2, factory2] of Object.entries(transportFactories)) {
        this.transports[name2] = factory2(this, dependencies2);
      }
      _a2.instances[logId] = this;
    }
    static getInstance({ logId }) {
      return this.instances[logId] || this.instances.default;
    }
    addLevel(level, index2 = this.levels.length) {
      if (index2 !== false) {
        this.levels.splice(index2, 0, level);
      }
      this[level] = (...args2) => this.logData(args2, { level });
      this.functions[level] = this[level];
    }
    catchErrors(options) {
      this.processMessage(
        {
          data: ["log.catchErrors is deprecated. Use log.errorHandler instead"],
          level: "warn"
        },
        { transports: ["console"] }
      );
      return this.errorHandler.startCatching(options);
    }
    create(options) {
      if (typeof options === "string") {
        options = { logId: options };
      }
      return new _a2({
        dependencies: this.dependencies,
        errorHandler: this.errorHandler,
        initializeFn: this.initializeFn,
        isDev: this.isDev,
        transportFactories: this.transportFactories,
        variables: { ...this.variables },
        ...options
      });
    }
    compareLevels(passLevel, checkLevel, levels = this.levels) {
      const pass = levels.indexOf(passLevel);
      const check2 = levels.indexOf(checkLevel);
      if (check2 === -1 || pass === -1) {
        return true;
      }
      return check2 <= pass;
    }
    initialize(options = {}) {
      this.initializeFn({ logger: this, ...this.dependencies, ...options });
    }
    logData(data2, options = {}) {
      if (this.buffering.enabled) {
        this.buffering.addMessage({ data: data2, ...options });
      } else {
        this.processMessage({ data: data2, ...options });
      }
    }
    processMessage(message2, { transports = this.transports } = {}) {
      if (message2.cmd === "errorHandler") {
        this.errorHandler.handle(message2.error, {
          errorName: message2.errorName,
          processType: "renderer",
          showDialog: Boolean(message2.showDialog)
        });
        return;
      }
      let level = message2.level;
      if (!this.allowUnknownLevel) {
        level = this.levels.includes(message2.level) ? message2.level : "info";
      }
      const normalizedMessage = {
        date: /* @__PURE__ */ new Date(),
        logId: this.logId,
        ...message2,
        level,
        variables: {
          ...this.variables,
          ...message2.variables
        }
      };
      for (const [transName, transFn] of this.transportEntries(transports)) {
        if (typeof transFn !== "function" || transFn.level === false) {
          continue;
        }
        if (!this.compareLevels(transFn.level, message2.level)) {
          continue;
        }
        try {
          const transformedMsg = this.hooks.reduce((msg, hook) => {
            return msg ? hook(msg, transFn, transName) : msg;
          }, normalizedMessage);
          if (transformedMsg) {
            transFn({ ...transformedMsg, data: [...transformedMsg.data] });
          }
        } catch (e2) {
          this.processInternalErrorFn(e2);
        }
      }
    }
    processInternalErrorFn(_e2) {
    }
    transportEntries(transports = this.transports) {
      const transportArray = Array.isArray(transports) ? transports : Object.entries(transports);
      return transportArray.map((item) => {
        switch (typeof item) {
          case "string":
            return this.transports[item] ? [item, this.transports[item]] : null;
          case "function":
            return [item.name, item];
          default:
            return Array.isArray(item) ? item : null;
        }
      }).filter(Boolean);
    }
  }, __publicField(_a2, "instances", {}), _a2);
  var Logger_1 = Logger$1;
  let ErrorHandler$1 = class ErrorHandler {
    constructor({
      externalApi: externalApi2,
      logFn = void 0,
      onError = void 0,
      showDialog = void 0
    } = {}) {
      __publicField(this, "externalApi");
      __publicField(this, "isActive", false);
      __publicField(this, "logFn");
      __publicField(this, "onError");
      __publicField(this, "showDialog", true);
      this.createIssue = this.createIssue.bind(this);
      this.handleError = this.handleError.bind(this);
      this.handleRejection = this.handleRejection.bind(this);
      this.setOptions({ externalApi: externalApi2, logFn, onError, showDialog });
      this.startCatching = this.startCatching.bind(this);
      this.stopCatching = this.stopCatching.bind(this);
    }
    handle(error2, {
      logFn = this.logFn,
      onError = this.onError,
      processType = "browser",
      showDialog = this.showDialog,
      errorName = ""
    } = {}) {
      var _a3;
      error2 = normalizeError(error2);
      try {
        if (typeof onError === "function") {
          const versions = ((_a3 = this.externalApi) == null ? void 0 : _a3.getVersions()) || {};
          const createIssue = this.createIssue;
          const result = onError({
            createIssue,
            error: error2,
            errorName,
            processType,
            versions
          });
          if (result === false) {
            return;
          }
        }
        errorName ? logFn(errorName, error2) : logFn(error2);
        if (showDialog && !errorName.includes("rejection") && this.externalApi) {
          this.externalApi.showErrorBox(
            `A JavaScript error occurred in the ${processType} process`,
            error2.stack
          );
        }
      } catch {
        console.error(error2);
      }
    }
    setOptions({ externalApi: externalApi2, logFn, onError, showDialog }) {
      if (typeof externalApi2 === "object") {
        this.externalApi = externalApi2;
      }
      if (typeof logFn === "function") {
        this.logFn = logFn;
      }
      if (typeof onError === "function") {
        this.onError = onError;
      }
      if (typeof showDialog === "boolean") {
        this.showDialog = showDialog;
      }
    }
    startCatching({ onError, showDialog } = {}) {
      if (this.isActive) {
        return;
      }
      this.isActive = true;
      this.setOptions({ onError, showDialog });
      process.on("uncaughtException", this.handleError);
      process.on("unhandledRejection", this.handleRejection);
    }
    stopCatching() {
      this.isActive = false;
      process.removeListener("uncaughtException", this.handleError);
      process.removeListener("unhandledRejection", this.handleRejection);
    }
    createIssue(pageUrl, queryParams) {
      var _a3;
      (_a3 = this.externalApi) == null ? void 0 : _a3.openUrl(
        `${pageUrl}?${new URLSearchParams(queryParams).toString()}`
      );
    }
    handleError(error2) {
      this.handle(error2, { errorName: "Unhandled" });
    }
    handleRejection(reason) {
      const error2 = reason instanceof Error ? reason : new Error(JSON.stringify(reason));
      this.handle(error2, { errorName: "Unhandled rejection" });
    }
  };
  function normalizeError(e2) {
    if (e2 instanceof Error) {
      return e2;
    }
    if (e2 && typeof e2 === "object") {
      if (e2.message) {
        return Object.assign(new Error(e2.message), e2);
      }
      try {
        return new Error(JSON.stringify(e2));
      } catch (serErr) {
        return new Error(`Couldn't normalize error ${String(e2)}: ${serErr}`);
      }
    }
    return new Error(`Can't normalize error ${String(e2)}`);
  }
  var ErrorHandler_1 = ErrorHandler$1;
  let EventLogger$1 = class EventLogger {
    constructor(options = {}) {
      __publicField(this, "disposers", []);
      __publicField(this, "format", "{eventSource}#{eventName}:");
      __publicField(this, "formatters", {
        app: {
          "certificate-error": ({ args: args2 }) => {
            return this.arrayToObject(args2.slice(1, 4), [
              "url",
              "error",
              "certificate"
            ]);
          },
          "child-process-gone": ({ args: args2 }) => {
            return args2.length === 1 ? args2[0] : args2;
          },
          "render-process-gone": ({ args: [webContents, details] }) => {
            return details && typeof details === "object" ? { ...details, ...this.getWebContentsDetails(webContents) } : [];
          }
        },
        webContents: {
          "console-message": ({ args: [level, message2, line, sourceId] }) => {
            if (level < 3) {
              return void 0;
            }
            return { message: message2, source: `${sourceId}:${line}` };
          },
          "did-fail-load": ({ args: args2 }) => {
            return this.arrayToObject(args2, [
              "errorCode",
              "errorDescription",
              "validatedURL",
              "isMainFrame",
              "frameProcessId",
              "frameRoutingId"
            ]);
          },
          "did-fail-provisional-load": ({ args: args2 }) => {
            return this.arrayToObject(args2, [
              "errorCode",
              "errorDescription",
              "validatedURL",
              "isMainFrame",
              "frameProcessId",
              "frameRoutingId"
            ]);
          },
          "plugin-crashed": ({ args: args2 }) => {
            return this.arrayToObject(args2, ["name", "version"]);
          },
          "preload-error": ({ args: args2 }) => {
            return this.arrayToObject(args2, ["preloadPath", "error"]);
          }
        }
      });
      __publicField(this, "events", {
        app: {
          "certificate-error": true,
          "child-process-gone": true,
          "render-process-gone": true
        },
        webContents: {
          // 'console-message': true,
          "did-fail-load": true,
          "did-fail-provisional-load": true,
          "plugin-crashed": true,
          "preload-error": true,
          "unresponsive": true
        }
      });
      __publicField(this, "externalApi");
      __publicField(this, "level", "error");
      __publicField(this, "scope", "");
      this.setOptions(options);
    }
    setOptions({
      events: events2,
      externalApi: externalApi2,
      level,
      logger: logger2,
      format: format2,
      formatters,
      scope: scope2
    }) {
      if (typeof events2 === "object") {
        this.events = events2;
      }
      if (typeof externalApi2 === "object") {
        this.externalApi = externalApi2;
      }
      if (typeof level === "string") {
        this.level = level;
      }
      if (typeof logger2 === "object") {
        this.logger = logger2;
      }
      if (typeof format2 === "string" || typeof format2 === "function") {
        this.format = format2;
      }
      if (typeof formatters === "object") {
        this.formatters = formatters;
      }
      if (typeof scope2 === "string") {
        this.scope = scope2;
      }
    }
    startLogging(options = {}) {
      this.setOptions(options);
      this.disposeListeners();
      for (const eventName of this.getEventNames(this.events.app)) {
        this.disposers.push(
          this.externalApi.onAppEvent(eventName, (...handlerArgs) => {
            this.handleEvent({ eventSource: "app", eventName, handlerArgs });
          })
        );
      }
      for (const eventName of this.getEventNames(this.events.webContents)) {
        this.disposers.push(
          this.externalApi.onEveryWebContentsEvent(
            eventName,
            (...handlerArgs) => {
              this.handleEvent(
                { eventSource: "webContents", eventName, handlerArgs }
              );
            }
          )
        );
      }
    }
    stopLogging() {
      this.disposeListeners();
    }
    arrayToObject(array, fieldNames) {
      const obj = {};
      fieldNames.forEach((fieldName, index2) => {
        obj[fieldName] = array[index2];
      });
      if (array.length > fieldNames.length) {
        obj.unknownArgs = array.slice(fieldNames.length);
      }
      return obj;
    }
    disposeListeners() {
      this.disposers.forEach((disposer) => disposer());
      this.disposers = [];
    }
    formatEventLog({ eventName, eventSource, handlerArgs }) {
      var _a3;
      const [event, ...args2] = handlerArgs;
      if (typeof this.format === "function") {
        return this.format({ args: args2, event, eventName, eventSource });
      }
      const formatter = (_a3 = this.formatters[eventSource]) == null ? void 0 : _a3[eventName];
      let formattedArgs = args2;
      if (typeof formatter === "function") {
        formattedArgs = formatter({ args: args2, event, eventName, eventSource });
      }
      if (!formattedArgs) {
        return void 0;
      }
      const eventData = {};
      if (Array.isArray(formattedArgs)) {
        eventData.args = formattedArgs;
      } else if (typeof formattedArgs === "object") {
        Object.assign(eventData, formattedArgs);
      }
      if (eventSource === "webContents") {
        Object.assign(eventData, this.getWebContentsDetails(event == null ? void 0 : event.sender));
      }
      const title = this.format.replace("{eventSource}", eventSource === "app" ? "App" : "WebContents").replace("{eventName}", eventName);
      return [title, eventData];
    }
    getEventNames(eventMap) {
      if (!eventMap || typeof eventMap !== "object") {
        return [];
      }
      return Object.entries(eventMap).filter(([_2, listen]) => listen).map(([eventName]) => eventName);
    }
    getWebContentsDetails(webContents) {
      if (!(webContents == null ? void 0 : webContents.loadURL)) {
        return {};
      }
      try {
        return {
          webContents: {
            id: webContents.id,
            url: webContents.getURL()
          }
        };
      } catch {
        return {};
      }
    }
    handleEvent({ eventName, eventSource, handlerArgs }) {
      var _a3;
      const log2 = this.formatEventLog({ eventName, eventSource, handlerArgs });
      if (log2) {
        const logFns = this.scope ? this.logger.scope(this.scope) : this.logger;
        (_a3 = logFns == null ? void 0 : logFns[this.level]) == null ? void 0 : _a3.call(logFns, ...log2);
      }
    }
  };
  var EventLogger_1 = EventLogger$1;
  var transform_1 = { transform: transform$5 };
  function transform$5({
    logger: logger2,
    message: message2,
    transport,
    initialData = (message2 == null ? void 0 : message2.data) || [],
    transforms = transport == null ? void 0 : transport.transforms
  }) {
    return transforms.reduce((data2, trans) => {
      if (typeof trans === "function") {
        return trans({ data: data2, logger: logger2, message: message2, transport });
      }
      return data2;
    }, initialData);
  }
  const { transform: transform$4 } = transform_1;
  var format$2 = {
    concatFirstStringElements: concatFirstStringElements$2,
    formatScope,
    formatText,
    formatVariables,
    timeZoneFromOffset,
    format({ message: message2, logger: logger2, transport, data: data2 = message2 == null ? void 0 : message2.data }) {
      switch (typeof transport.format) {
        case "string": {
          return transform$4({
            message: message2,
            logger: logger2,
            transforms: [formatVariables, formatScope, formatText],
            transport,
            initialData: [transport.format, ...data2]
          });
        }
        case "function": {
          return transport.format({
            data: data2,
            level: (message2 == null ? void 0 : message2.level) || "info",
            logger: logger2,
            message: message2,
            transport
          });
        }
        default: {
          return data2;
        }
      }
    }
  };
  function concatFirstStringElements$2({ data: data2 }) {
    if (typeof data2[0] !== "string" || typeof data2[1] !== "string") {
      return data2;
    }
    if (data2[0].match(/%[1cdfiOos]/)) {
      return data2;
    }
    return [`${data2[0]} ${data2[1]}`, ...data2.slice(2)];
  }
  function timeZoneFromOffset(minutesOffset) {
    const minutesPositive = Math.abs(minutesOffset);
    const sign = minutesOffset > 0 ? "-" : "+";
    const hours = Math.floor(minutesPositive / 60).toString().padStart(2, "0");
    const minutes = (minutesPositive % 60).toString().padStart(2, "0");
    return `${sign}${hours}:${minutes}`;
  }
  function formatScope({ data: data2, logger: logger2, message: message2 }) {
    const { defaultLabel, labelLength } = (logger2 == null ? void 0 : logger2.scope) || {};
    const template = data2[0];
    let label = message2.scope;
    if (!label) {
      label = defaultLabel;
    }
    let scopeText;
    if (label === "") {
      scopeText = labelLength > 0 ? "".padEnd(labelLength + 3) : "";
    } else if (typeof label === "string") {
      scopeText = ` (${label})`.padEnd(labelLength + 3);
    } else {
      scopeText = "";
    }
    data2[0] = template.replace("{scope}", scopeText);
    return data2;
  }
  function formatVariables({ data: data2, message: message2 }) {
    let template = data2[0];
    if (typeof template !== "string") {
      return data2;
    }
    template = template.replace("{level}]", `${message2.level}]`.padEnd(6, " "));
    const date = message2.date || /* @__PURE__ */ new Date();
    data2[0] = template.replace(/\{(\w+)}/g, (substring, name2) => {
      var _a3;
      switch (name2) {
        case "level":
          return message2.level || "info";
        case "logId":
          return message2.logId;
        case "y":
          return date.getFullYear().toString(10);
        case "m":
          return (date.getMonth() + 1).toString(10).padStart(2, "0");
        case "d":
          return date.getDate().toString(10).padStart(2, "0");
        case "h":
          return date.getHours().toString(10).padStart(2, "0");
        case "i":
          return date.getMinutes().toString(10).padStart(2, "0");
        case "s":
          return date.getSeconds().toString(10).padStart(2, "0");
        case "ms":
          return date.getMilliseconds().toString(10).padStart(3, "0");
        case "z":
          return timeZoneFromOffset(date.getTimezoneOffset());
        case "iso":
          return date.toISOString();
        default: {
          return ((_a3 = message2.variables) == null ? void 0 : _a3[name2]) || substring;
        }
      }
    }).trim();
    return data2;
  }
  function formatText({ data: data2 }) {
    const template = data2[0];
    if (typeof template !== "string") {
      return data2;
    }
    const textTplPosition = template.lastIndexOf("{text}");
    if (textTplPosition === template.length - 6) {
      data2[0] = template.replace(/\s?{text}/, "");
      if (data2[0] === "") {
        data2.shift();
      }
      return data2;
    }
    const templatePieces = template.split("{text}");
    let result = [];
    if (templatePieces[0] !== "") {
      result.push(templatePieces[0]);
    }
    result = result.concat(data2.slice(1));
    if (templatePieces[1] !== "") {
      result.push(templatePieces[1]);
    }
    return result;
  }
  var object$1 = { exports: {} };
  (function(module2) {
    const util2 = require$$5$1;
    module2.exports = {
      serialize,
      maxDepth({ data: data2, transport, depth = (transport == null ? void 0 : transport.depth) ?? 6 }) {
        if (!data2) {
          return data2;
        }
        if (depth < 1) {
          if (Array.isArray(data2)) return "[array]";
          if (typeof data2 === "object" && data2) return "[object]";
          return data2;
        }
        if (Array.isArray(data2)) {
          return data2.map((child) => module2.exports.maxDepth({
            data: child,
            depth: depth - 1
          }));
        }
        if (typeof data2 !== "object") {
          return data2;
        }
        if (data2 && typeof data2.toISOString === "function") {
          return data2;
        }
        if (data2 === null) {
          return null;
        }
        if (data2 instanceof Error) {
          return data2;
        }
        const newJson = {};
        for (const i2 in data2) {
          if (!Object.prototype.hasOwnProperty.call(data2, i2)) continue;
          newJson[i2] = module2.exports.maxDepth({
            data: data2[i2],
            depth: depth - 1
          });
        }
        return newJson;
      },
      toJSON({ data: data2 }) {
        return JSON.parse(JSON.stringify(data2, createSerializer()));
      },
      toString({ data: data2, transport }) {
        const inspectOptions = (transport == null ? void 0 : transport.inspectOptions) || {};
        const simplifiedData = data2.map((item) => {
          if (item === void 0) {
            return void 0;
          }
          try {
            const str = JSON.stringify(item, createSerializer(), "  ");
            return str === void 0 ? void 0 : JSON.parse(str);
          } catch (e2) {
            return item;
          }
        });
        return util2.formatWithOptions(inspectOptions, ...simplifiedData);
      }
    };
    function createSerializer(options = {}) {
      const seen = /* @__PURE__ */ new WeakSet();
      return function(key, value) {
        if (typeof value === "object" && value !== null) {
          if (seen.has(value)) {
            return void 0;
          }
          seen.add(value);
        }
        return serialize(key, value, options);
      };
    }
    function serialize(key, value, options = {}) {
      const serializeMapAndSet = (options == null ? void 0 : options.serializeMapAndSet) !== false;
      if (value instanceof Error) {
        return value.stack;
      }
      if (!value) {
        return value;
      }
      if (typeof value === "function") {
        return `[function] ${value.toString()}`;
      }
      if (value instanceof Date) {
        return value.toISOString();
      }
      if (serializeMapAndSet && value instanceof Map && Object.fromEntries) {
        return Object.fromEntries(value);
      }
      if (serializeMapAndSet && value instanceof Set && Array.from) {
        return Array.from(value);
      }
      return value;
    }
  })(object$1);
  var objectExports = object$1.exports;
  var style = {
    transformStyles,
    applyAnsiStyles({ data: data2 }) {
      return transformStyles(data2, styleToAnsi, resetAnsiStyle);
    },
    removeStyles({ data: data2 }) {
      return transformStyles(data2, () => "");
    }
  };
  const ANSI_COLORS = {
    unset: "\x1B[0m",
    black: "\x1B[30m",
    red: "\x1B[31m",
    green: "\x1B[32m",
    yellow: "\x1B[33m",
    blue: "\x1B[34m",
    magenta: "\x1B[35m",
    cyan: "\x1B[36m",
    white: "\x1B[37m"
  };
  function styleToAnsi(style2) {
    const color = style2.replace(/color:\s*(\w+).*/, "$1").toLowerCase();
    return ANSI_COLORS[color] || "";
  }
  function resetAnsiStyle(string) {
    return string + ANSI_COLORS.unset;
  }
  function transformStyles(data2, onStyleFound, onStyleApplied) {
    const foundStyles = {};
    return data2.reduce((result, item, index2, array) => {
      if (foundStyles[index2]) {
        return result;
      }
      if (typeof item === "string") {
        let valueIndex = index2;
        let styleApplied = false;
        item = item.replace(/%[1cdfiOos]/g, (match) => {
          valueIndex += 1;
          if (match !== "%c") {
            return match;
          }
          const style2 = array[valueIndex];
          if (typeof style2 === "string") {
            foundStyles[valueIndex] = true;
            styleApplied = true;
            return onStyleFound(style2, item);
          }
          return match;
        });
        if (styleApplied && onStyleApplied) {
          item = onStyleApplied(item);
        }
      }
      result.push(item);
      return result;
    }, []);
  }
  const { concatFirstStringElements: concatFirstStringElements$1, format: format$1 } = format$2;
  const { maxDepth: maxDepth$2, toJSON: toJSON$2 } = objectExports;
  const { applyAnsiStyles, removeStyles: removeStyles$2 } = style;
  const { transform: transform$3 } = transform_1;
  const consoleMethods = {
    error: console.error,
    warn: console.warn,
    info: console.info,
    verbose: console.info,
    debug: console.debug,
    silly: console.debug,
    log: console.log
  };
  var console_1 = consoleTransportFactory;
  const separator = process.platform === "win32" ? ">" : "›";
  const DEFAULT_FORMAT = `%c{h}:{i}:{s}.{ms}{scope}%c ${separator} {text}`;
  Object.assign(consoleTransportFactory, {
    DEFAULT_FORMAT
  });
  function consoleTransportFactory(logger2) {
    return Object.assign(transport, {
      format: DEFAULT_FORMAT,
      level: "silly",
      transforms: [
        addTemplateColors,
        format$1,
        formatStyles,
        concatFirstStringElements$1,
        maxDepth$2,
        toJSON$2
      ],
      useStyles: process.env.FORCE_STYLES,
      writeFn({ message: message2 }) {
        const consoleLogFn = consoleMethods[message2.level] || consoleMethods.info;
        consoleLogFn(...message2.data);
      }
    });
    function transport(message2) {
      const data2 = transform$3({ logger: logger2, message: message2, transport });
      transport.writeFn({
        message: { ...message2, data: data2 }
      });
    }
  }
  function addTemplateColors({ data: data2, message: message2, transport }) {
    if (transport.format !== DEFAULT_FORMAT) {
      return data2;
    }
    return [`color:${levelToStyle(message2.level)}`, "color:unset", ...data2];
  }
  function canUseStyles(useStyleValue, level) {
    if (typeof useStyleValue === "boolean") {
      return useStyleValue;
    }
    const useStderr = level === "error" || level === "warn";
    const stream2 = useStderr ? process.stderr : process.stdout;
    return stream2 && stream2.isTTY;
  }
  function formatStyles(args2) {
    const { message: message2, transport } = args2;
    const useStyles = canUseStyles(transport.useStyles, message2.level);
    const nextTransform = useStyles ? applyAnsiStyles : removeStyles$2;
    return nextTransform(args2);
  }
  function levelToStyle(level) {
    const map = { error: "red", warn: "yellow", info: "cyan", default: "unset" };
    return map[level] || map.default;
  }
  const EventEmitter$2 = require$$0$5;
  const fs$4 = require$$0$2;
  const os$2 = require$$0$1;
  let File$3 = class File extends EventEmitter$2 {
    constructor({
      path: path2,
      writeOptions = { encoding: "utf8", flag: "a", mode: 438 },
      writeAsync = false
    }) {
      super();
      __publicField(this, "asyncWriteQueue", []);
      __publicField(this, "bytesWritten", 0);
      __publicField(this, "hasActiveAsyncWriting", false);
      __publicField(this, "path", null);
      __publicField(this, "initialSize");
      __publicField(this, "writeOptions", null);
      __publicField(this, "writeAsync", false);
      this.path = path2;
      this.writeOptions = writeOptions;
      this.writeAsync = writeAsync;
    }
    get size() {
      return this.getSize();
    }
    clear() {
      try {
        fs$4.writeFileSync(this.path, "", {
          mode: this.writeOptions.mode,
          flag: "w"
        });
        this.reset();
        return true;
      } catch (e2) {
        if (e2.code === "ENOENT") {
          return true;
        }
        this.emit("error", e2, this);
        return false;
      }
    }
    crop(bytesAfter) {
      try {
        const content = readFileSyncFromEnd(this.path, bytesAfter || 4096);
        this.clear();
        this.writeLine(`[log cropped]${os$2.EOL}${content}`);
      } catch (e2) {
        this.emit(
          "error",
          new Error(`Couldn't crop file ${this.path}. ${e2.message}`),
          this
        );
      }
    }
    getSize() {
      if (this.initialSize === void 0) {
        try {
          const stats = fs$4.statSync(this.path);
          this.initialSize = stats.size;
        } catch (e2) {
          this.initialSize = 0;
        }
      }
      return this.initialSize + this.bytesWritten;
    }
    increaseBytesWrittenCounter(text) {
      this.bytesWritten += Buffer.byteLength(text, this.writeOptions.encoding);
    }
    isNull() {
      return false;
    }
    nextAsyncWrite() {
      const file2 = this;
      if (this.hasActiveAsyncWriting || this.asyncWriteQueue.length === 0) {
        return;
      }
      const text = this.asyncWriteQueue.join("");
      this.asyncWriteQueue = [];
      this.hasActiveAsyncWriting = true;
      fs$4.writeFile(this.path, text, this.writeOptions, (e2) => {
        file2.hasActiveAsyncWriting = false;
        if (e2) {
          file2.emit(
            "error",
            new Error(`Couldn't write to ${file2.path}. ${e2.message}`),
            this
          );
        } else {
          file2.increaseBytesWrittenCounter(text);
        }
        file2.nextAsyncWrite();
      });
    }
    reset() {
      this.initialSize = void 0;
      this.bytesWritten = 0;
    }
    toString() {
      return this.path;
    }
    writeLine(text) {
      text += os$2.EOL;
      if (this.writeAsync) {
        this.asyncWriteQueue.push(text);
        this.nextAsyncWrite();
        return;
      }
      try {
        fs$4.writeFileSync(this.path, text, this.writeOptions);
        this.increaseBytesWrittenCounter(text);
      } catch (e2) {
        this.emit(
          "error",
          new Error(`Couldn't write to ${this.path}. ${e2.message}`),
          this
        );
      }
    }
  };
  var File_1 = File$3;
  function readFileSyncFromEnd(filePath, bytesCount) {
    const buffer2 = Buffer.alloc(bytesCount);
    const stats = fs$4.statSync(filePath);
    const readLength = Math.min(stats.size, bytesCount);
    const offset = Math.max(0, stats.size - bytesCount);
    const fd = fs$4.openSync(filePath, "r");
    const totalBytes = fs$4.readSync(fd, buffer2, 0, readLength, offset);
    fs$4.closeSync(fd);
    return buffer2.toString("utf8", 0, totalBytes);
  }
  const File$2 = File_1;
  let NullFile$1 = class NullFile extends File$2 {
    clear() {
    }
    crop() {
    }
    getSize() {
      return 0;
    }
    isNull() {
      return true;
    }
    writeLine() {
    }
  };
  var NullFile_1 = NullFile$1;
  const EventEmitter$1 = require$$0$5;
  const fs$3 = require$$0$2;
  const path$6 = path$k;
  const File$1 = File_1;
  const NullFile = NullFile_1;
  let FileRegistry$1 = class FileRegistry extends EventEmitter$1 {
    constructor() {
      super();
      __publicField(this, "store", {});
      this.emitError = this.emitError.bind(this);
    }
    /**
     * Provide a File object corresponding to the filePath
     * @param {string} filePath
     * @param {WriteOptions} [writeOptions]
     * @param {boolean} [writeAsync]
     * @return {File}
     */
    provide({ filePath, writeOptions = {}, writeAsync = false }) {
      let file2;
      try {
        filePath = path$6.resolve(filePath);
        if (this.store[filePath]) {
          return this.store[filePath];
        }
        file2 = this.createFile({ filePath, writeOptions, writeAsync });
      } catch (e2) {
        file2 = new NullFile({ path: filePath });
        this.emitError(e2, file2);
      }
      file2.on("error", this.emitError);
      this.store[filePath] = file2;
      return file2;
    }
    /**
     * @param {string} filePath
     * @param {WriteOptions} writeOptions
     * @param {boolean} async
     * @return {File}
     * @private
     */
    createFile({ filePath, writeOptions, writeAsync }) {
      this.testFileWriting({ filePath, writeOptions });
      return new File$1({ path: filePath, writeOptions, writeAsync });
    }
    /**
     * @param {Error} error
     * @param {File} file
     * @private
     */
    emitError(error2, file2) {
      this.emit("error", error2, file2);
    }
    /**
     * @param {string} filePath
     * @param {WriteOptions} writeOptions
     * @private
     */
    testFileWriting({ filePath, writeOptions }) {
      fs$3.mkdirSync(path$6.dirname(filePath), { recursive: true });
      fs$3.writeFileSync(filePath, "", { flag: "a", mode: writeOptions.mode });
    }
  };
  var FileRegistry_1 = FileRegistry$1;
  const fs$2 = require$$0$2;
  const os$1 = require$$0$1;
  const path$5 = path$k;
  const FileRegistry = FileRegistry_1;
  const { transform: transform$2 } = transform_1;
  const { removeStyles: removeStyles$1 } = style;
  const {
    format,
    concatFirstStringElements
  } = format$2;
  const { toString } = objectExports;
  var file = fileTransportFactory;
  const globalRegistry = new FileRegistry();
  function fileTransportFactory(logger2, { registry = globalRegistry, externalApi: externalApi2 } = {}) {
    let pathVariables;
    if (registry.listenerCount("error") < 1) {
      registry.on("error", (e2, file2) => {
        logConsole(`Can't write to ${file2}`, e2);
      });
    }
    return Object.assign(transport, {
      fileName: getDefaultFileName(logger2.variables.processType),
      format: "[{y}-{m}-{d} {h}:{i}:{s}.{ms}] [{level}]{scope} {text}",
      getFile,
      inspectOptions: { depth: 5 },
      level: "silly",
      maxSize: 1024 ** 2,
      readAllLogs,
      sync: true,
      transforms: [removeStyles$1, format, concatFirstStringElements, toString],
      writeOptions: { flag: "a", mode: 438, encoding: "utf8" },
      archiveLogFn(file2) {
        const oldPath = file2.toString();
        const inf = path$5.parse(oldPath);
        try {
          fs$2.renameSync(oldPath, path$5.join(inf.dir, `${inf.name}.old${inf.ext}`));
        } catch (e2) {
          logConsole("Could not rotate log", e2);
          const quarterOfMaxSize = Math.round(transport.maxSize / 4);
          file2.crop(Math.min(quarterOfMaxSize, 256 * 1024));
        }
      },
      resolvePathFn(vars) {
        return path$5.join(vars.libraryDefaultDir, vars.fileName);
      },
      setAppName(name2) {
        logger2.dependencies.externalApi.setAppName(name2);
      }
    });
    function transport(message2) {
      const file2 = getFile(message2);
      const needLogRotation = transport.maxSize > 0 && file2.size > transport.maxSize;
      if (needLogRotation) {
        transport.archiveLogFn(file2);
        file2.reset();
      }
      const content = transform$2({ logger: logger2, message: message2, transport });
      file2.writeLine(content);
    }
    function initializeOnFirstAccess() {
      if (pathVariables) {
        return;
      }
      pathVariables = Object.create(
        Object.prototype,
        {
          ...Object.getOwnPropertyDescriptors(
            externalApi2.getPathVariables()
          ),
          fileName: {
            get() {
              return transport.fileName;
            },
            enumerable: true
          }
        }
      );
      if (typeof transport.archiveLog === "function") {
        transport.archiveLogFn = transport.archiveLog;
        logConsole("archiveLog is deprecated. Use archiveLogFn instead");
      }
      if (typeof transport.resolvePath === "function") {
        transport.resolvePathFn = transport.resolvePath;
        logConsole("resolvePath is deprecated. Use resolvePathFn instead");
      }
    }
    function logConsole(message2, error2 = null, level = "error") {
      const data2 = [`electron-log.transports.file: ${message2}`];
      if (error2) {
        data2.push(error2);
      }
      logger2.transports.console({ data: data2, date: /* @__PURE__ */ new Date(), level });
    }
    function getFile(msg) {
      initializeOnFirstAccess();
      const filePath = transport.resolvePathFn(pathVariables, msg);
      return registry.provide({
        filePath,
        writeAsync: !transport.sync,
        writeOptions: transport.writeOptions
      });
    }
    function readAllLogs({ fileFilter = (f2) => f2.endsWith(".log") } = {}) {
      initializeOnFirstAccess();
      const logsPath = path$5.dirname(transport.resolvePathFn(pathVariables));
      if (!fs$2.existsSync(logsPath)) {
        return [];
      }
      return fs$2.readdirSync(logsPath).map((fileName) => path$5.join(logsPath, fileName)).filter(fileFilter).map((logPath) => {
        try {
          return {
            path: logPath,
            lines: fs$2.readFileSync(logPath, "utf8").split(os$1.EOL)
          };
        } catch {
          return null;
        }
      }).filter(Boolean);
    }
  }
  function getDefaultFileName(processType = process.type) {
    switch (processType) {
      case "renderer":
        return "renderer.log";
      case "worker":
        return "worker.log";
      default:
        return "main.log";
    }
  }
  const { maxDepth: maxDepth$1, toJSON: toJSON$1 } = objectExports;
  const { transform: transform$1 } = transform_1;
  var ipc = ipcTransportFactory;
  function ipcTransportFactory(logger2, { externalApi: externalApi2 }) {
    Object.assign(transport, {
      depth: 3,
      eventId: "__ELECTRON_LOG_IPC__",
      level: logger2.isDev ? "silly" : false,
      transforms: [toJSON$1, maxDepth$1]
    });
    return (externalApi2 == null ? void 0 : externalApi2.isElectron()) ? transport : void 0;
    function transport(message2) {
      var _a3;
      if (((_a3 = message2 == null ? void 0 : message2.variables) == null ? void 0 : _a3.processType) === "renderer") {
        return;
      }
      externalApi2 == null ? void 0 : externalApi2.sendIpc(transport.eventId, {
        ...message2,
        data: transform$1({ logger: logger2, message: message2, transport })
      });
    }
  }
  const http = http$3;
  const https = require$$1$5;
  const { transform } = transform_1;
  const { removeStyles } = style;
  const { toJSON, maxDepth } = objectExports;
  var remote = remoteTransportFactory;
  function remoteTransportFactory(logger2) {
    return Object.assign(transport, {
      client: { name: "electron-application" },
      depth: 6,
      level: false,
      requestOptions: {},
      transforms: [removeStyles, toJSON, maxDepth],
      makeBodyFn({ message: message2 }) {
        return JSON.stringify({
          client: transport.client,
          data: message2.data,
          date: message2.date.getTime(),
          level: message2.level,
          scope: message2.scope,
          variables: message2.variables
        });
      },
      processErrorFn({ error: error2 }) {
        logger2.processMessage(
          {
            data: [`electron-log: can't POST ${transport.url}`, error2],
            level: "warn"
          },
          { transports: ["console", "file"] }
        );
      },
      sendRequestFn({ serverUrl, requestOptions, body }) {
        const httpTransport = serverUrl.startsWith("https:") ? https : http;
        const request = httpTransport.request(serverUrl, {
          method: "POST",
          ...requestOptions,
          headers: {
            "Content-Type": "application/json",
            "Content-Length": body.length,
            ...requestOptions.headers
          }
        });
        request.write(body);
        request.end();
        return request;
      }
    });
    function transport(message2) {
      if (!transport.url) {
        return;
      }
      const body = transport.makeBodyFn({
        logger: logger2,
        message: { ...message2, data: transform({ logger: logger2, message: message2, transport }) },
        transport
      });
      const request = transport.sendRequestFn({
        serverUrl: transport.url,
        requestOptions: transport.requestOptions,
        body: Buffer.from(body, "utf8")
      });
      request.on("error", (error2) => transport.processErrorFn({
        error: error2,
        logger: logger2,
        message: message2,
        request,
        transport
      }));
    }
  }
  const Logger = Logger_1;
  const ErrorHandler = ErrorHandler_1;
  const EventLogger = EventLogger_1;
  const transportConsole = console_1;
  const transportFile = file;
  const transportIpc = ipc;
  const transportRemote = remote;
  var createDefaultLogger_1 = createDefaultLogger$1;
  function createDefaultLogger$1({ dependencies: dependencies2, initializeFn }) {
    var _a3;
    const defaultLogger2 = new Logger({
      dependencies: dependencies2,
      errorHandler: new ErrorHandler(),
      eventLogger: new EventLogger(),
      initializeFn,
      isDev: (_a3 = dependencies2.externalApi) == null ? void 0 : _a3.isDev(),
      logId: "default",
      transportFactories: {
        console: transportConsole,
        file: transportFile,
        ipc: transportIpc,
        remote: transportRemote
      },
      variables: {
        processType: "main"
      }
    });
    defaultLogger2.default = defaultLogger2;
    defaultLogger2.Logger = Logger;
    defaultLogger2.processInternalErrorFn = (e2) => {
      defaultLogger2.transports.console.writeFn({
        message: {
          data: ["Unhandled electron-log error", e2],
          level: "error"
        }
      });
    };
    return defaultLogger2;
  }
  const electron = electron$1;
  const ElectronExternalApi = ElectronExternalApi_1;
  const { initialize } = initialize$1;
  const createDefaultLogger = createDefaultLogger_1;
  const externalApi = new ElectronExternalApi({ electron });
  const defaultLogger = createDefaultLogger({
    dependencies: { externalApi },
    initializeFn: initialize
  });
  var main$3 = defaultLogger;
  externalApi.onIpc("__ELECTRON_LOG__", (_2, message2) => {
    if (message2.scope) {
      defaultLogger.Logger.getInstance(message2).scope(message2.scope);
    }
    const date = new Date(message2.date);
    processMessage({
      ...message2,
      date: date.getTime() ? date : /* @__PURE__ */ new Date()
    });
  });
  externalApi.onIpcInvoke("__ELECTRON_LOG__", (_2, { cmd = "", logId }) => {
    switch (cmd) {
      case "getOptions": {
        const logger2 = defaultLogger.Logger.getInstance({ logId });
        return {
          levels: logger2.levels,
          logId
        };
      }
      default: {
        processMessage({ data: [`Unknown cmd '${cmd}'`], level: "error" });
        return {};
      }
    }
  });
  function processMessage(message2) {
    var _a3;
    (_a3 = defaultLogger.Logger.getInstance(message2)) == null ? void 0 : _a3.processMessage(message2);
  }
  const main$1 = main$3;
  var main_1 = main$1;
  const main$2 = /* @__PURE__ */ getDefaultExportFromCjs(main_1);
  const rawLogger = /* @__PURE__ */ _mergeNamespaces({
    __proto__: null,
    default: main$2
  }, [main_1]);
  function makeLogger(logger2) {
    return {
      debug(message2) {
        logger2.debug(message2);
      },
      info(message2) {
        logger2.info(message2);
      },
      warn(message2, details) {
        captureEvent({
          message: message2,
          level: "warning",
          extra: details ? { ...details } : void 0
        });
        logger2.warn(message2, details == null ? void 0 : details.error);
      },
      error(message2, details) {
        captureEvent({
          message: message2,
          level: "error",
          extra: details ? { ...details } : void 0
        });
        logger2.error(message2, details == null ? void 0 : details.error);
      }
    };
  }
  function scopeLogger(scope2) {
    return makeLogger(main_1.scope(scope2));
  }
  const logger = makeLogger(rawLogger);
  main_1.initialize();
  main_1.eventLogger.startLogging();
  process.on("uncaughtException", function(err) {
    captureException(err);
    main_1.error("Uncaught Exception", err);
  });
  console.log = (...args2) => main_1.log(...args2);
  console.info = (...args2) => main_1.info(...args2);
  console.error = (...args2) => main_1.error(...args2);
  var util$8;
  (function(util2) {
    util2.assertEqual = (_2) => {
    };
    function assertIs(_arg) {
    }
    util2.assertIs = assertIs;
    function assertNever2(_x) {
      throw new Error();
    }
    util2.assertNever = assertNever2;
    util2.arrayToEnum = (items) => {
      const obj = {};
      for (const item of items) {
        obj[item] = item;
      }
      return obj;
    };
    util2.getValidEnumValues = (obj) => {
      const validKeys = util2.objectKeys(obj).filter((k2) => typeof obj[obj[k2]] !== "number");
      const filtered = {};
      for (const k2 of validKeys) {
        filtered[k2] = obj[k2];
      }
      return util2.objectValues(filtered);
    };
    util2.objectValues = (obj) => {
      return util2.objectKeys(obj).map(function(e2) {
        return obj[e2];
      });
    };
    util2.objectKeys = typeof Object.keys === "function" ? (obj) => Object.keys(obj) : (object2) => {
      const keys2 = [];
      for (const key in object2) {
        if (Object.prototype.hasOwnProperty.call(object2, key)) {
          keys2.push(key);
        }
      }
      return keys2;
    };
    util2.find = (arr, checker) => {
      for (const item of arr) {
        if (checker(item))
          return item;
      }
      return void 0;
    };
    util2.isInteger = typeof Number.isInteger === "function" ? (val) => Number.isInteger(val) : (val) => typeof val === "number" && Number.isFinite(val) && Math.floor(val) === val;
    function joinValues(array, separator2 = " | ") {
      return array.map((val) => typeof val === "string" ? `'${val}'` : val).join(separator2);
    }
    util2.joinValues = joinValues;
    util2.jsonStringifyReplacer = (_2, value) => {
      if (typeof value === "bigint") {
        return value.toString();
      }
      return value;
    };
  })(util$8 || (util$8 = {}));
  var objectUtil;
  (function(objectUtil2) {
    objectUtil2.mergeShapes = (first, second) => {
      return {
        ...first,
        ...second
        // second overwrites first
      };
    };
  })(objectUtil || (objectUtil = {}));
  const ZodParsedType = util$8.arrayToEnum([
    "string",
    "nan",
    "number",
    "integer",
    "float",
    "boolean",
    "date",
    "bigint",
    "symbol",
    "function",
    "undefined",
    "null",
    "array",
    "object",
    "unknown",
    "promise",
    "void",
    "never",
    "map",
    "set"
  ]);
  const getParsedType = (data2) => {
    const t2 = typeof data2;
    switch (t2) {
      case "undefined":
        return ZodParsedType.undefined;
      case "string":
        return ZodParsedType.string;
      case "number":
        return Number.isNaN(data2) ? ZodParsedType.nan : ZodParsedType.number;
      case "boolean":
        return ZodParsedType.boolean;
      case "function":
        return ZodParsedType.function;
      case "bigint":
        return ZodParsedType.bigint;
      case "symbol":
        return ZodParsedType.symbol;
      case "object":
        if (Array.isArray(data2)) {
          return ZodParsedType.array;
        }
        if (data2 === null) {
          return ZodParsedType.null;
        }
        if (data2.then && typeof data2.then === "function" && data2.catch && typeof data2.catch === "function") {
          return ZodParsedType.promise;
        }
        if (typeof Map !== "undefined" && data2 instanceof Map) {
          return ZodParsedType.map;
        }
        if (typeof Set !== "undefined" && data2 instanceof Set) {
          return ZodParsedType.set;
        }
        if (typeof Date !== "undefined" && data2 instanceof Date) {
          return ZodParsedType.date;
        }
        return ZodParsedType.object;
      default:
        return ZodParsedType.unknown;
    }
  };
  const ZodIssueCode = util$8.arrayToEnum([
    "invalid_type",
    "invalid_literal",
    "custom",
    "invalid_union",
    "invalid_union_discriminator",
    "invalid_enum_value",
    "unrecognized_keys",
    "invalid_arguments",
    "invalid_return_type",
    "invalid_date",
    "invalid_string",
    "too_small",
    "too_big",
    "invalid_intersection_types",
    "not_multiple_of",
    "not_finite"
  ]);
  class ZodError extends Error {
    get errors() {
      return this.issues;
    }
    constructor(issues) {
      super();
      this.issues = [];
      this.addIssue = (sub) => {
        this.issues = [...this.issues, sub];
      };
      this.addIssues = (subs = []) => {
        this.issues = [...this.issues, ...subs];
      };
      const actualProto = new.target.prototype;
      if (Object.setPrototypeOf) {
        Object.setPrototypeOf(this, actualProto);
      } else {
        this.__proto__ = actualProto;
      }
      this.name = "ZodError";
      this.issues = issues;
    }
    format(_mapper) {
      const mapper = _mapper || function(issue) {
        return issue.message;
      };
      const fieldErrors = { _errors: [] };
      const processError = (error2) => {
        for (const issue of error2.issues) {
          if (issue.code === "invalid_union") {
            issue.unionErrors.map(processError);
          } else if (issue.code === "invalid_return_type") {
            processError(issue.returnTypeError);
          } else if (issue.code === "invalid_arguments") {
            processError(issue.argumentsError);
          } else if (issue.path.length === 0) {
            fieldErrors._errors.push(mapper(issue));
          } else {
            let curr = fieldErrors;
            let i2 = 0;
            while (i2 < issue.path.length) {
              const el = issue.path[i2];
              const terminal = i2 === issue.path.length - 1;
              if (!terminal) {
                curr[el] = curr[el] || { _errors: [] };
              } else {
                curr[el] = curr[el] || { _errors: [] };
                curr[el]._errors.push(mapper(issue));
              }
              curr = curr[el];
              i2++;
            }
          }
        }
      };
      processError(this);
      return fieldErrors;
    }
    static assert(value) {
      if (!(value instanceof ZodError)) {
        throw new Error(`Not a ZodError: ${value}`);
      }
    }
    toString() {
      return this.message;
    }
    get message() {
      return JSON.stringify(this.issues, util$8.jsonStringifyReplacer, 2);
    }
    get isEmpty() {
      return this.issues.length === 0;
    }
    flatten(mapper = (issue) => issue.message) {
      const fieldErrors = {};
      const formErrors = [];
      for (const sub of this.issues) {
        if (sub.path.length > 0) {
          const firstEl = sub.path[0];
          fieldErrors[firstEl] = fieldErrors[firstEl] || [];
          fieldErrors[firstEl].push(mapper(sub));
        } else {
          formErrors.push(mapper(sub));
        }
      }
      return { formErrors, fieldErrors };
    }
    get formErrors() {
      return this.flatten();
    }
  }
  ZodError.create = (issues) => {
    const error2 = new ZodError(issues);
    return error2;
  };
  const errorMap = (issue, _ctx) => {
    let message2;
    switch (issue.code) {
      case ZodIssueCode.invalid_type:
        if (issue.received === ZodParsedType.undefined) {
          message2 = "Required";
        } else {
          message2 = `Expected ${issue.expected}, received ${issue.received}`;
        }
        break;
      case ZodIssueCode.invalid_literal:
        message2 = `Invalid literal value, expected ${JSON.stringify(issue.expected, util$8.jsonStringifyReplacer)}`;
        break;
      case ZodIssueCode.unrecognized_keys:
        message2 = `Unrecognized key(s) in object: ${util$8.joinValues(issue.keys, ", ")}`;
        break;
      case ZodIssueCode.invalid_union:
        message2 = `Invalid input`;
        break;
      case ZodIssueCode.invalid_union_discriminator:
        message2 = `Invalid discriminator value. Expected ${util$8.joinValues(issue.options)}`;
        break;
      case ZodIssueCode.invalid_enum_value:
        message2 = `Invalid enum value. Expected ${util$8.joinValues(issue.options)}, received '${issue.received}'`;
        break;
      case ZodIssueCode.invalid_arguments:
        message2 = `Invalid function arguments`;
        break;
      case ZodIssueCode.invalid_return_type:
        message2 = `Invalid function return type`;
        break;
      case ZodIssueCode.invalid_date:
        message2 = `Invalid date`;
        break;
      case ZodIssueCode.invalid_string:
        if (typeof issue.validation === "object") {
          if ("includes" in issue.validation) {
            message2 = `Invalid input: must include "${issue.validation.includes}"`;
            if (typeof issue.validation.position === "number") {
              message2 = `${message2} at one or more positions greater than or equal to ${issue.validation.position}`;
            }
          } else if ("startsWith" in issue.validation) {
            message2 = `Invalid input: must start with "${issue.validation.startsWith}"`;
          } else if ("endsWith" in issue.validation) {
            message2 = `Invalid input: must end with "${issue.validation.endsWith}"`;
          } else {
            util$8.assertNever(issue.validation);
          }
        } else if (issue.validation !== "regex") {
          message2 = `Invalid ${issue.validation}`;
        } else {
          message2 = "Invalid";
        }
        break;
      case ZodIssueCode.too_small:
        if (issue.type === "array")
          message2 = `Array must contain ${issue.exact ? "exactly" : issue.inclusive ? `at least` : `more than`} ${issue.minimum} element(s)`;
        else if (issue.type === "string")
          message2 = `String must contain ${issue.exact ? "exactly" : issue.inclusive ? `at least` : `over`} ${issue.minimum} character(s)`;
        else if (issue.type === "number")
          message2 = `Number must be ${issue.exact ? `exactly equal to ` : issue.inclusive ? `greater than or equal to ` : `greater than `}${issue.minimum}`;
        else if (issue.type === "bigint")
          message2 = `Number must be ${issue.exact ? `exactly equal to ` : issue.inclusive ? `greater than or equal to ` : `greater than `}${issue.minimum}`;
        else if (issue.type === "date")
          message2 = `Date must be ${issue.exact ? `exactly equal to ` : issue.inclusive ? `greater than or equal to ` : `greater than `}${new Date(Number(issue.minimum))}`;
        else
          message2 = "Invalid input";
        break;
      case ZodIssueCode.too_big:
        if (issue.type === "array")
          message2 = `Array must contain ${issue.exact ? `exactly` : issue.inclusive ? `at most` : `less than`} ${issue.maximum} element(s)`;
        else if (issue.type === "string")
          message2 = `String must contain ${issue.exact ? `exactly` : issue.inclusive ? `at most` : `under`} ${issue.maximum} character(s)`;
        else if (issue.type === "number")
          message2 = `Number must be ${issue.exact ? `exactly` : issue.inclusive ? `less than or equal to` : `less than`} ${issue.maximum}`;
        else if (issue.type === "bigint")
          message2 = `BigInt must be ${issue.exact ? `exactly` : issue.inclusive ? `less than or equal to` : `less than`} ${issue.maximum}`;
        else if (issue.type === "date")
          message2 = `Date must be ${issue.exact ? `exactly` : issue.inclusive ? `smaller than or equal to` : `smaller than`} ${new Date(Number(issue.maximum))}`;
        else
          message2 = "Invalid input";
        break;
      case ZodIssueCode.custom:
        message2 = `Invalid input`;
        break;
      case ZodIssueCode.invalid_intersection_types:
        message2 = `Intersection results could not be merged`;
        break;
      case ZodIssueCode.not_multiple_of:
        message2 = `Number must be a multiple of ${issue.multipleOf}`;
        break;
      case ZodIssueCode.not_finite:
        message2 = "Number must be finite";
        break;
      default:
        message2 = _ctx.defaultError;
        util$8.assertNever(issue);
    }
    return { message: message2 };
  };
  let overrideErrorMap = errorMap;
  function getErrorMap() {
    return overrideErrorMap;
  }
  const makeIssue = (params) => {
    const { data: data2, path: path2, errorMaps, issueData } = params;
    const fullPath = [...path2, ...issueData.path || []];
    const fullIssue = {
      ...issueData,
      path: fullPath
    };
    if (issueData.message !== void 0) {
      return {
        ...issueData,
        path: fullPath,
        message: issueData.message
      };
    }
    let errorMessage = "";
    const maps = errorMaps.filter((m2) => !!m2).slice().reverse();
    for (const map of maps) {
      errorMessage = map(fullIssue, { data: data2, defaultError: errorMessage }).message;
    }
    return {
      ...issueData,
      path: fullPath,
      message: errorMessage
    };
  };
  function addIssueToContext(ctx, issueData) {
    const overrideMap = getErrorMap();
    const issue = makeIssue({
      issueData,
      data: ctx.data,
      path: ctx.path,
      errorMaps: [
        ctx.common.contextualErrorMap,
        // contextual error map is first priority
        ctx.schemaErrorMap,
        // then schema-bound map if available
        overrideMap,
        // then global override map
        overrideMap === errorMap ? void 0 : errorMap
        // then global default map
      ].filter((x2) => !!x2)
    });
    ctx.common.issues.push(issue);
  }
  class ParseStatus {
    constructor() {
      this.value = "valid";
    }
    dirty() {
      if (this.value === "valid")
        this.value = "dirty";
    }
    abort() {
      if (this.value !== "aborted")
        this.value = "aborted";
    }
    static mergeArray(status, results) {
      const arrayValue = [];
      for (const s2 of results) {
        if (s2.status === "aborted")
          return INVALID;
        if (s2.status === "dirty")
          status.dirty();
        arrayValue.push(s2.value);
      }
      return { status: status.value, value: arrayValue };
    }
    static async mergeObjectAsync(status, pairs) {
      const syncPairs = [];
      for (const pair of pairs) {
        const key = await pair.key;
        const value = await pair.value;
        syncPairs.push({
          key,
          value
        });
      }
      return ParseStatus.mergeObjectSync(status, syncPairs);
    }
    static mergeObjectSync(status, pairs) {
      const finalObject = {};
      for (const pair of pairs) {
        const { key, value } = pair;
        if (key.status === "aborted")
          return INVALID;
        if (value.status === "aborted")
          return INVALID;
        if (key.status === "dirty")
          status.dirty();
        if (value.status === "dirty")
          status.dirty();
        if (key.value !== "__proto__" && (typeof value.value !== "undefined" || pair.alwaysSet)) {
          finalObject[key.value] = value.value;
        }
      }
      return { status: status.value, value: finalObject };
    }
  }
  const INVALID = Object.freeze({
    status: "aborted"
  });
  const DIRTY = (value) => ({ status: "dirty", value });
  const OK = (value) => ({ status: "valid", value });
  const isAborted = (x2) => x2.status === "aborted";
  const isDirty = (x2) => x2.status === "dirty";
  const isValid = (x2) => x2.status === "valid";
  const isAsync = (x2) => typeof Promise !== "undefined" && x2 instanceof Promise;
  var errorUtil;
  (function(errorUtil2) {
    errorUtil2.errToObj = (message2) => typeof message2 === "string" ? { message: message2 } : message2 || {};
    errorUtil2.toString = (message2) => typeof message2 === "string" ? message2 : message2 == null ? void 0 : message2.message;
  })(errorUtil || (errorUtil = {}));
  class ParseInputLazyPath {
    constructor(parent, value, path2, key) {
      this._cachedPath = [];
      this.parent = parent;
      this.data = value;
      this._path = path2;
      this._key = key;
    }
    get path() {
      if (!this._cachedPath.length) {
        if (Array.isArray(this._key)) {
          this._cachedPath.push(...this._path, ...this._key);
        } else {
          this._cachedPath.push(...this._path, this._key);
        }
      }
      return this._cachedPath;
    }
  }
  const handleResult = (ctx, result) => {
    if (isValid(result)) {
      return { success: true, data: result.value };
    } else {
      if (!ctx.common.issues.length) {
        throw new Error("Validation failed but no issues detected.");
      }
      return {
        success: false,
        get error() {
          if (this._error)
            return this._error;
          const error2 = new ZodError(ctx.common.issues);
          this._error = error2;
          return this._error;
        }
      };
    }
  };
  function processCreateParams(params) {
    if (!params)
      return {};
    const { errorMap: errorMap2, invalid_type_error, required_error, description: description2 } = params;
    if (errorMap2 && (invalid_type_error || required_error)) {
      throw new Error(`Can't use "invalid_type_error" or "required_error" in conjunction with custom error map.`);
    }
    if (errorMap2)
      return { errorMap: errorMap2, description: description2 };
    const customMap = (iss, ctx) => {
      const { message: message2 } = params;
      if (iss.code === "invalid_enum_value") {
        return { message: message2 ?? ctx.defaultError };
      }
      if (typeof ctx.data === "undefined") {
        return { message: message2 ?? required_error ?? ctx.defaultError };
      }
      if (iss.code !== "invalid_type")
        return { message: ctx.defaultError };
      return { message: message2 ?? invalid_type_error ?? ctx.defaultError };
    };
    return { errorMap: customMap, description: description2 };
  }
  class ZodType {
    get description() {
      return this._def.description;
    }
    _getType(input) {
      return getParsedType(input.data);
    }
    _getOrReturnCtx(input, ctx) {
      return ctx || {
        common: input.parent.common,
        data: input.data,
        parsedType: getParsedType(input.data),
        schemaErrorMap: this._def.errorMap,
        path: input.path,
        parent: input.parent
      };
    }
    _processInputParams(input) {
      return {
        status: new ParseStatus(),
        ctx: {
          common: input.parent.common,
          data: input.data,
          parsedType: getParsedType(input.data),
          schemaErrorMap: this._def.errorMap,
          path: input.path,
          parent: input.parent
        }
      };
    }
    _parseSync(input) {
      const result = this._parse(input);
      if (isAsync(result)) {
        throw new Error("Synchronous parse encountered promise.");
      }
      return result;
    }
    _parseAsync(input) {
      const result = this._parse(input);
      return Promise.resolve(result);
    }
    parse(data2, params) {
      const result = this.safeParse(data2, params);
      if (result.success)
        return result.data;
      throw result.error;
    }
    safeParse(data2, params) {
      const ctx = {
        common: {
          issues: [],
          async: (params == null ? void 0 : params.async) ?? false,
          contextualErrorMap: params == null ? void 0 : params.errorMap
        },
        path: (params == null ? void 0 : params.path) || [],
        schemaErrorMap: this._def.errorMap,
        parent: null,
        data: data2,
        parsedType: getParsedType(data2)
      };
      const result = this._parseSync({ data: data2, path: ctx.path, parent: ctx });
      return handleResult(ctx, result);
    }
    "~validate"(data2) {
      var _a3, _b2;
      const ctx = {
        common: {
          issues: [],
          async: !!this["~standard"].async
        },
        path: [],
        schemaErrorMap: this._def.errorMap,
        parent: null,
        data: data2,
        parsedType: getParsedType(data2)
      };
      if (!this["~standard"].async) {
        try {
          const result = this._parseSync({ data: data2, path: [], parent: ctx });
          return isValid(result) ? {
            value: result.value
          } : {
            issues: ctx.common.issues
          };
        } catch (err) {
          if ((_b2 = (_a3 = err == null ? void 0 : err.message) == null ? void 0 : _a3.toLowerCase()) == null ? void 0 : _b2.includes("encountered")) {
            this["~standard"].async = true;
          }
          ctx.common = {
            issues: [],
            async: true
          };
        }
      }
      return this._parseAsync({ data: data2, path: [], parent: ctx }).then((result) => isValid(result) ? {
        value: result.value
      } : {
        issues: ctx.common.issues
      });
    }
    async parseAsync(data2, params) {
      const result = await this.safeParseAsync(data2, params);
      if (result.success)
        return result.data;
      throw result.error;
    }
    async safeParseAsync(data2, params) {
      const ctx = {
        common: {
          issues: [],
          contextualErrorMap: params == null ? void 0 : params.errorMap,
          async: true
        },
        path: (params == null ? void 0 : params.path) || [],
        schemaErrorMap: this._def.errorMap,
        parent: null,
        data: data2,
        parsedType: getParsedType(data2)
      };
      const maybeAsyncResult = this._parse({ data: data2, path: ctx.path, parent: ctx });
      const result = await (isAsync(maybeAsyncResult) ? maybeAsyncResult : Promise.resolve(maybeAsyncResult));
      return handleResult(ctx, result);
    }
    refine(check2, message2) {
      const getIssueProperties = (val) => {
        if (typeof message2 === "string" || typeof message2 === "undefined") {
          return { message: message2 };
        } else if (typeof message2 === "function") {
          return message2(val);
        } else {
          return message2;
        }
      };
      return this._refinement((val, ctx) => {
        const result = check2(val);
        const setError = () => ctx.addIssue({
          code: ZodIssueCode.custom,
          ...getIssueProperties(val)
        });
        if (typeof Promise !== "undefined" && result instanceof Promise) {
          return result.then((data2) => {
            if (!data2) {
              setError();
              return false;
            } else {
              return true;
            }
          });
        }
        if (!result) {
          setError();
          return false;
        } else {
          return true;
        }
      });
    }
    refinement(check2, refinementData) {
      return this._refinement((val, ctx) => {
        if (!check2(val)) {
          ctx.addIssue(typeof refinementData === "function" ? refinementData(val, ctx) : refinementData);
          return false;
        } else {
          return true;
        }
      });
    }
    _refinement(refinement) {
      return new ZodEffects({
        schema: this,
        typeName: ZodFirstPartyTypeKind.ZodEffects,
        effect: { type: "refinement", refinement }
      });
    }
    superRefine(refinement) {
      return this._refinement(refinement);
    }
    constructor(def) {
      this.spa = this.safeParseAsync;
      this._def = def;
      this.parse = this.parse.bind(this);
      this.safeParse = this.safeParse.bind(this);
      this.parseAsync = this.parseAsync.bind(this);
      this.safeParseAsync = this.safeParseAsync.bind(this);
      this.spa = this.spa.bind(this);
      this.refine = this.refine.bind(this);
      this.refinement = this.refinement.bind(this);
      this.superRefine = this.superRefine.bind(this);
      this.optional = this.optional.bind(this);
      this.nullable = this.nullable.bind(this);
      this.nullish = this.nullish.bind(this);
      this.array = this.array.bind(this);
      this.promise = this.promise.bind(this);
      this.or = this.or.bind(this);
      this.and = this.and.bind(this);
      this.transform = this.transform.bind(this);
      this.brand = this.brand.bind(this);
      this.default = this.default.bind(this);
      this.catch = this.catch.bind(this);
      this.describe = this.describe.bind(this);
      this.pipe = this.pipe.bind(this);
      this.readonly = this.readonly.bind(this);
      this.isNullable = this.isNullable.bind(this);
      this.isOptional = this.isOptional.bind(this);
      this["~standard"] = {
        version: 1,
        vendor: "zod",
        validate: (data2) => this["~validate"](data2)
      };
    }
    optional() {
      return ZodOptional.create(this, this._def);
    }
    nullable() {
      return ZodNullable.create(this, this._def);
    }
    nullish() {
      return this.nullable().optional();
    }
    array() {
      return ZodArray.create(this);
    }
    promise() {
      return ZodPromise.create(this, this._def);
    }
    or(option) {
      return ZodUnion.create([this, option], this._def);
    }
    and(incoming) {
      return ZodIntersection.create(this, incoming, this._def);
    }
    transform(transform2) {
      return new ZodEffects({
        ...processCreateParams(this._def),
        schema: this,
        typeName: ZodFirstPartyTypeKind.ZodEffects,
        effect: { type: "transform", transform: transform2 }
      });
    }
    default(def) {
      const defaultValueFunc = typeof def === "function" ? def : () => def;
      return new ZodDefault({
        ...processCreateParams(this._def),
        innerType: this,
        defaultValue: defaultValueFunc,
        typeName: ZodFirstPartyTypeKind.ZodDefault
      });
    }
    brand() {
      return new ZodBranded({
        typeName: ZodFirstPartyTypeKind.ZodBranded,
        type: this,
        ...processCreateParams(this._def)
      });
    }
    catch(def) {
      const catchValueFunc = typeof def === "function" ? def : () => def;
      return new ZodCatch({
        ...processCreateParams(this._def),
        innerType: this,
        catchValue: catchValueFunc,
        typeName: ZodFirstPartyTypeKind.ZodCatch
      });
    }
    describe(description2) {
      const This = this.constructor;
      return new This({
        ...this._def,
        description: description2
      });
    }
    pipe(target) {
      return ZodPipeline.create(this, target);
    }
    readonly() {
      return ZodReadonly.create(this);
    }
    isOptional() {
      return this.safeParse(void 0).success;
    }
    isNullable() {
      return this.safeParse(null).success;
    }
  }
  const cuidRegex = /^c[^\s-]{8,}$/i;
  const cuid2Regex = /^[0-9a-z]+$/;
  const ulidRegex = /^[0-9A-HJKMNP-TV-Z]{26}$/i;
  const uuidRegex = /^[0-9a-fA-F]{8}\b-[0-9a-fA-F]{4}\b-[0-9a-fA-F]{4}\b-[0-9a-fA-F]{4}\b-[0-9a-fA-F]{12}$/i;
  const nanoidRegex = /^[a-z0-9_-]{21}$/i;
  const jwtRegex = /^[A-Za-z0-9-_]+\.[A-Za-z0-9-_]+\.[A-Za-z0-9-_]*$/;
  const durationRegex = /^[-+]?P(?!$)(?:(?:[-+]?\d+Y)|(?:[-+]?\d+[.,]\d+Y$))?(?:(?:[-+]?\d+M)|(?:[-+]?\d+[.,]\d+M$))?(?:(?:[-+]?\d+W)|(?:[-+]?\d+[.,]\d+W$))?(?:(?:[-+]?\d+D)|(?:[-+]?\d+[.,]\d+D$))?(?:T(?=[\d+-])(?:(?:[-+]?\d+H)|(?:[-+]?\d+[.,]\d+H$))?(?:(?:[-+]?\d+M)|(?:[-+]?\d+[.,]\d+M$))?(?:[-+]?\d+(?:[.,]\d+)?S)?)??$/;
  const emailRegex = /^(?!\.)(?!.*\.\.)([A-Z0-9_'+\-\.]*)[A-Z0-9_+-]@([A-Z0-9][A-Z0-9\-]*\.)+[A-Z]{2,}$/i;
  const _emojiRegex = `^(\\p{Extended_Pictographic}|\\p{Emoji_Component})+$`;
  let emojiRegex;
  const ipv4Regex = /^(?:(?:25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9][0-9]|[0-9])\.){3}(?:25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9][0-9]|[0-9])$/;
  const ipv4CidrRegex = /^(?:(?:25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9][0-9]|[0-9])\.){3}(?:25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9][0-9]|[0-9])\/(3[0-2]|[12]?[0-9])$/;
  const ipv6Regex = /^(([0-9a-fA-F]{1,4}:){7,7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:)|fe80:(:[0-9a-fA-F]{0,4}){0,4}%[0-9a-zA-Z]{1,}|::(ffff(:0{1,4}){0,1}:){0,1}((25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])\.){3,3}(25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])|([0-9a-fA-F]{1,4}:){1,4}:((25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])\.){3,3}(25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9]))$/;
  const ipv6CidrRegex = /^(([0-9a-fA-F]{1,4}:){7,7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:)|fe80:(:[0-9a-fA-F]{0,4}){0,4}%[0-9a-zA-Z]{1,}|::(ffff(:0{1,4}){0,1}:){0,1}((25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])\.){3,3}(25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])|([0-9a-fA-F]{1,4}:){1,4}:((25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])\.){3,3}(25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9]))\/(12[0-8]|1[01][0-9]|[1-9]?[0-9])$/;
  const base64Regex = /^([0-9a-zA-Z+/]{4})*(([0-9a-zA-Z+/]{2}==)|([0-9a-zA-Z+/]{3}=))?$/;
  const base64urlRegex = /^([0-9a-zA-Z-_]{4})*(([0-9a-zA-Z-_]{2}(==)?)|([0-9a-zA-Z-_]{3}(=)?))?$/;
  const dateRegexSource = `((\\d\\d[2468][048]|\\d\\d[13579][26]|\\d\\d0[48]|[02468][048]00|[13579][26]00)-02-29|\\d{4}-((0[13578]|1[02])-(0[1-9]|[12]\\d|3[01])|(0[469]|11)-(0[1-9]|[12]\\d|30)|(02)-(0[1-9]|1\\d|2[0-8])))`;
  const dateRegex = new RegExp(`^${dateRegexSource}$`);
  function timeRegexSource(args2) {
    let secondsRegexSource = `[0-5]\\d`;
    if (args2.precision) {
      secondsRegexSource = `${secondsRegexSource}\\.\\d{${args2.precision}}`;
    } else if (args2.precision == null) {
      secondsRegexSource = `${secondsRegexSource}(\\.\\d+)?`;
    }
    const secondsQuantifier = args2.precision ? "+" : "?";
    return `([01]\\d|2[0-3]):[0-5]\\d(:${secondsRegexSource})${secondsQuantifier}`;
  }
  function timeRegex(args2) {
    return new RegExp(`^${timeRegexSource(args2)}$`);
  }
  function datetimeRegex(args2) {
    let regex2 = `${dateRegexSource}T${timeRegexSource(args2)}`;
    const opts = [];
    opts.push(args2.local ? `Z?` : `Z`);
    if (args2.offset)
      opts.push(`([+-]\\d{2}:?\\d{2})`);
    regex2 = `${regex2}(${opts.join("|")})`;
    return new RegExp(`^${regex2}$`);
  }
  function isValidIP(ip, version2) {
    if ((version2 === "v4" || !version2) && ipv4Regex.test(ip)) {
      return true;
    }
    if ((version2 === "v6" || !version2) && ipv6Regex.test(ip)) {
      return true;
    }
    return false;
  }
  function isValidJWT(jwt, alg) {
    if (!jwtRegex.test(jwt))
      return false;
    try {
      const [header] = jwt.split(".");
      if (!header)
        return false;
      const base642 = header.replace(/-/g, "+").replace(/_/g, "/").padEnd(header.length + (4 - header.length % 4) % 4, "=");
      const decoded = JSON.parse(atob(base642));
      if (typeof decoded !== "object" || decoded === null)
        return false;
      if ("typ" in decoded && (decoded == null ? void 0 : decoded.typ) !== "JWT")
        return false;
      if (!decoded.alg)
        return false;
      if (alg && decoded.alg !== alg)
        return false;
      return true;
    } catch {
      return false;
    }
  }
  function isValidCidr(ip, version2) {
    if ((version2 === "v4" || !version2) && ipv4CidrRegex.test(ip)) {
      return true;
    }
    if ((version2 === "v6" || !version2) && ipv6CidrRegex.test(ip)) {
      return true;
    }
    return false;
  }
  class ZodString extends ZodType {
    _parse(input) {
      if (this._def.coerce) {
        input.data = String(input.data);
      }
      const parsedType = this._getType(input);
      if (parsedType !== ZodParsedType.string) {
        const ctx2 = this._getOrReturnCtx(input);
        addIssueToContext(ctx2, {
          code: ZodIssueCode.invalid_type,
          expected: ZodParsedType.string,
          received: ctx2.parsedType
        });
        return INVALID;
      }
      const status = new ParseStatus();
      let ctx = void 0;
      for (const check2 of this._def.checks) {
        if (check2.kind === "min") {
          if (input.data.length < check2.value) {
            ctx = this._getOrReturnCtx(input, ctx);
            addIssueToContext(ctx, {
              code: ZodIssueCode.too_small,
              minimum: check2.value,
              type: "string",
              inclusive: true,
              exact: false,
              message: check2.message
            });
            status.dirty();
          }
        } else if (check2.kind === "max") {
          if (input.data.length > check2.value) {
            ctx = this._getOrReturnCtx(input, ctx);
            addIssueToContext(ctx, {
              code: ZodIssueCode.too_big,
              maximum: check2.value,
              type: "string",
              inclusive: true,
              exact: false,
              message: check2.message
            });
            status.dirty();
          }
        } else if (check2.kind === "length") {
          const tooBig = input.data.length > check2.value;
          const tooSmall = input.data.length < check2.value;
          if (tooBig || tooSmall) {
            ctx = this._getOrReturnCtx(input, ctx);
            if (tooBig) {
              addIssueToContext(ctx, {
                code: ZodIssueCode.too_big,
                maximum: check2.value,
                type: "string",
                inclusive: true,
                exact: true,
                message: check2.message
              });
            } else if (tooSmall) {
              addIssueToContext(ctx, {
                code: ZodIssueCode.too_small,
                minimum: check2.value,
                type: "string",
                inclusive: true,
                exact: true,
                message: check2.message
              });
            }
            status.dirty();
          }
        } else if (check2.kind === "email") {
          if (!emailRegex.test(input.data)) {
            ctx = this._getOrReturnCtx(input, ctx);
            addIssueToContext(ctx, {
              validation: "email",
              code: ZodIssueCode.invalid_string,
              message: check2.message
            });
            status.dirty();
          }
        } else if (check2.kind === "emoji") {
          if (!emojiRegex) {
            emojiRegex = new RegExp(_emojiRegex, "u");
          }
          if (!emojiRegex.test(input.data)) {
            ctx = this._getOrReturnCtx(input, ctx);
            addIssueToContext(ctx, {
              validation: "emoji",
              code: ZodIssueCode.invalid_string,
              message: check2.message
            });
            status.dirty();
          }
        } else if (check2.kind === "uuid") {
          if (!uuidRegex.test(input.data)) {
            ctx = this._getOrReturnCtx(input, ctx);
            addIssueToContext(ctx, {
              validation: "uuid",
              code: ZodIssueCode.invalid_string,
              message: check2.message
            });
            status.dirty();
          }
        } else if (check2.kind === "nanoid") {
          if (!nanoidRegex.test(input.data)) {
            ctx = this._getOrReturnCtx(input, ctx);
            addIssueToContext(ctx, {
              validation: "nanoid",
              code: ZodIssueCode.invalid_string,
              message: check2.message
            });
            status.dirty();
          }
        } else if (check2.kind === "cuid") {
          if (!cuidRegex.test(input.data)) {
            ctx = this._getOrReturnCtx(input, ctx);
            addIssueToContext(ctx, {
              validation: "cuid",
              code: ZodIssueCode.invalid_string,
              message: check2.message
            });
            status.dirty();
          }
        } else if (check2.kind === "cuid2") {
          if (!cuid2Regex.test(input.data)) {
            ctx = this._getOrReturnCtx(input, ctx);
            addIssueToContext(ctx, {
              validation: "cuid2",
              code: ZodIssueCode.invalid_string,
              message: check2.message
            });
            status.dirty();
          }
        } else if (check2.kind === "ulid") {
          if (!ulidRegex.test(input.data)) {
            ctx = this._getOrReturnCtx(input, ctx);
            addIssueToContext(ctx, {
              validation: "ulid",
              code: ZodIssueCode.invalid_string,
              message: check2.message
            });
            status.dirty();
          }
        } else if (check2.kind === "url") {
          try {
            new URL(input.data);
          } catch {
            ctx = this._getOrReturnCtx(input, ctx);
            addIssueToContext(ctx, {
              validation: "url",
              code: ZodIssueCode.invalid_string,
              message: check2.message
            });
            status.dirty();
          }
        } else if (check2.kind === "regex") {
          check2.regex.lastIndex = 0;
          const testResult = check2.regex.test(input.data);
          if (!testResult) {
            ctx = this._getOrReturnCtx(input, ctx);
            addIssueToContext(ctx, {
              validation: "regex",
              code: ZodIssueCode.invalid_string,
              message: check2.message
            });
            status.dirty();
          }
        } else if (check2.kind === "trim") {
          input.data = input.data.trim();
        } else if (check2.kind === "includes") {
          if (!input.data.includes(check2.value, check2.position)) {
            ctx = this._getOrReturnCtx(input, ctx);
            addIssueToContext(ctx, {
              code: ZodIssueCode.invalid_string,
              validation: { includes: check2.value, position: check2.position },
              message: check2.message
            });
            status.dirty();
          }
        } else if (check2.kind === "toLowerCase") {
          input.data = input.data.toLowerCase();
        } else if (check2.kind === "toUpperCase") {
          input.data = input.data.toUpperCase();
        } else if (check2.kind === "startsWith") {
          if (!input.data.startsWith(check2.value)) {
            ctx = this._getOrReturnCtx(input, ctx);
            addIssueToContext(ctx, {
              code: ZodIssueCode.invalid_string,
              validation: { startsWith: check2.value },
              message: check2.message
            });
            status.dirty();
          }
        } else if (check2.kind === "endsWith") {
          if (!input.data.endsWith(check2.value)) {
            ctx = this._getOrReturnCtx(input, ctx);
            addIssueToContext(ctx, {
              code: ZodIssueCode.invalid_string,
              validation: { endsWith: check2.value },
              message: check2.message
            });
            status.dirty();
          }
        } else if (check2.kind === "datetime") {
          const regex2 = datetimeRegex(check2);
          if (!regex2.test(input.data)) {
            ctx = this._getOrReturnCtx(input, ctx);
            addIssueToContext(ctx, {
              code: ZodIssueCode.invalid_string,
              validation: "datetime",
              message: check2.message
            });
            status.dirty();
          }
        } else if (check2.kind === "date") {
          const regex2 = dateRegex;
          if (!regex2.test(input.data)) {
            ctx = this._getOrReturnCtx(input, ctx);
            addIssueToContext(ctx, {
              code: ZodIssueCode.invalid_string,
              validation: "date",
              message: check2.message
            });
            status.dirty();
          }
        } else if (check2.kind === "time") {
          const regex2 = timeRegex(check2);
          if (!regex2.test(input.data)) {
            ctx = this._getOrReturnCtx(input, ctx);
            addIssueToContext(ctx, {
              code: ZodIssueCode.invalid_string,
              validation: "time",
              message: check2.message
            });
            status.dirty();
          }
        } else if (check2.kind === "duration") {
          if (!durationRegex.test(input.data)) {
            ctx = this._getOrReturnCtx(input, ctx);
            addIssueToContext(ctx, {
              validation: "duration",
              code: ZodIssueCode.invalid_string,
              message: check2.message
            });
            status.dirty();
          }
        } else if (check2.kind === "ip") {
          if (!isValidIP(input.data, check2.version)) {
            ctx = this._getOrReturnCtx(input, ctx);
            addIssueToContext(ctx, {
              validation: "ip",
              code: ZodIssueCode.invalid_string,
              message: check2.message
            });
            status.dirty();
          }
        } else if (check2.kind === "jwt") {
          if (!isValidJWT(input.data, check2.alg)) {
            ctx = this._getOrReturnCtx(input, ctx);
            addIssueToContext(ctx, {
              validation: "jwt",
              code: ZodIssueCode.invalid_string,
              message: check2.message
            });
            status.dirty();
          }
        } else if (check2.kind === "cidr") {
          if (!isValidCidr(input.data, check2.version)) {
            ctx = this._getOrReturnCtx(input, ctx);
            addIssueToContext(ctx, {
              validation: "cidr",
              code: ZodIssueCode.invalid_string,
              message: check2.message
            });
            status.dirty();
          }
        } else if (check2.kind === "base64") {
          if (!base64Regex.test(input.data)) {
            ctx = this._getOrReturnCtx(input, ctx);
            addIssueToContext(ctx, {
              validation: "base64",
              code: ZodIssueCode.invalid_string,
              message: check2.message
            });
            status.dirty();
          }
        } else if (check2.kind === "base64url") {
          if (!base64urlRegex.test(input.data)) {
            ctx = this._getOrReturnCtx(input, ctx);
            addIssueToContext(ctx, {
              validation: "base64url",
              code: ZodIssueCode.invalid_string,
              message: check2.message
            });
            status.dirty();
          }
        } else {
          util$8.assertNever(check2);
        }
      }
      return { status: status.value, value: input.data };
    }
    _regex(regex2, validation, message2) {
      return this.refinement((data2) => regex2.test(data2), {
        validation,
        code: ZodIssueCode.invalid_string,
        ...errorUtil.errToObj(message2)
      });
    }
    _addCheck(check2) {
      return new ZodString({
        ...this._def,
        checks: [...this._def.checks, check2]
      });
    }
    email(message2) {
      return this._addCheck({ kind: "email", ...errorUtil.errToObj(message2) });
    }
    url(message2) {
      return this._addCheck({ kind: "url", ...errorUtil.errToObj(message2) });
    }
    emoji(message2) {
      return this._addCheck({ kind: "emoji", ...errorUtil.errToObj(message2) });
    }
    uuid(message2) {
      return this._addCheck({ kind: "uuid", ...errorUtil.errToObj(message2) });
    }
    nanoid(message2) {
      return this._addCheck({ kind: "nanoid", ...errorUtil.errToObj(message2) });
    }
    cuid(message2) {
      return this._addCheck({ kind: "cuid", ...errorUtil.errToObj(message2) });
    }
    cuid2(message2) {
      return this._addCheck({ kind: "cuid2", ...errorUtil.errToObj(message2) });
    }
    ulid(message2) {
      return this._addCheck({ kind: "ulid", ...errorUtil.errToObj(message2) });
    }
    base64(message2) {
      return this._addCheck({ kind: "base64", ...errorUtil.errToObj(message2) });
    }
    base64url(message2) {
      return this._addCheck({
        kind: "base64url",
        ...errorUtil.errToObj(message2)
      });
    }
    jwt(options) {
      return this._addCheck({ kind: "jwt", ...errorUtil.errToObj(options) });
    }
    ip(options) {
      return this._addCheck({ kind: "ip", ...errorUtil.errToObj(options) });
    }
    cidr(options) {
      return this._addCheck({ kind: "cidr", ...errorUtil.errToObj(options) });
    }
    datetime(options) {
      if (typeof options === "string") {
        return this._addCheck({
          kind: "datetime",
          precision: null,
          offset: false,
          local: false,
          message: options
        });
      }
      return this._addCheck({
        kind: "datetime",
        precision: typeof (options == null ? void 0 : options.precision) === "undefined" ? null : options == null ? void 0 : options.precision,
        offset: (options == null ? void 0 : options.offset) ?? false,
        local: (options == null ? void 0 : options.local) ?? false,
        ...errorUtil.errToObj(options == null ? void 0 : options.message)
      });
    }
    date(message2) {
      return this._addCheck({ kind: "date", message: message2 });
    }
    time(options) {
      if (typeof options === "string") {
        return this._addCheck({
          kind: "time",
          precision: null,
          message: options
        });
      }
      return this._addCheck({
        kind: "time",
        precision: typeof (options == null ? void 0 : options.precision) === "undefined" ? null : options == null ? void 0 : options.precision,
        ...errorUtil.errToObj(options == null ? void 0 : options.message)
      });
    }
    duration(message2) {
      return this._addCheck({ kind: "duration", ...errorUtil.errToObj(message2) });
    }
    regex(regex2, message2) {
      return this._addCheck({
        kind: "regex",
        regex: regex2,
        ...errorUtil.errToObj(message2)
      });
    }
    includes(value, options) {
      return this._addCheck({
        kind: "includes",
        value,
        position: options == null ? void 0 : options.position,
        ...errorUtil.errToObj(options == null ? void 0 : options.message)
      });
    }
    startsWith(value, message2) {
      return this._addCheck({
        kind: "startsWith",
        value,
        ...errorUtil.errToObj(message2)
      });
    }
    endsWith(value, message2) {
      return this._addCheck({
        kind: "endsWith",
        value,
        ...errorUtil.errToObj(message2)
      });
    }
    min(minLength, message2) {
      return this._addCheck({
        kind: "min",
        value: minLength,
        ...errorUtil.errToObj(message2)
      });
    }
    max(maxLength, message2) {
      return this._addCheck({
        kind: "max",
        value: maxLength,
        ...errorUtil.errToObj(message2)
      });
    }
    length(len, message2) {
      return this._addCheck({
        kind: "length",
        value: len,
        ...errorUtil.errToObj(message2)
      });
    }
    /**
     * Equivalent to `.min(1)`
     */
    nonempty(message2) {
      return this.min(1, errorUtil.errToObj(message2));
    }
    trim() {
      return new ZodString({
        ...this._def,
        checks: [...this._def.checks, { kind: "trim" }]
      });
    }
    toLowerCase() {
      return new ZodString({
        ...this._def,
        checks: [...this._def.checks, { kind: "toLowerCase" }]
      });
    }
    toUpperCase() {
      return new ZodString({
        ...this._def,
        checks: [...this._def.checks, { kind: "toUpperCase" }]
      });
    }
    get isDatetime() {
      return !!this._def.checks.find((ch) => ch.kind === "datetime");
    }
    get isDate() {
      return !!this._def.checks.find((ch) => ch.kind === "date");
    }
    get isTime() {
      return !!this._def.checks.find((ch) => ch.kind === "time");
    }
    get isDuration() {
      return !!this._def.checks.find((ch) => ch.kind === "duration");
    }
    get isEmail() {
      return !!this._def.checks.find((ch) => ch.kind === "email");
    }
    get isURL() {
      return !!this._def.checks.find((ch) => ch.kind === "url");
    }
    get isEmoji() {
      return !!this._def.checks.find((ch) => ch.kind === "emoji");
    }
    get isUUID() {
      return !!this._def.checks.find((ch) => ch.kind === "uuid");
    }
    get isNANOID() {
      return !!this._def.checks.find((ch) => ch.kind === "nanoid");
    }
    get isCUID() {
      return !!this._def.checks.find((ch) => ch.kind === "cuid");
    }
    get isCUID2() {
      return !!this._def.checks.find((ch) => ch.kind === "cuid2");
    }
    get isULID() {
      return !!this._def.checks.find((ch) => ch.kind === "ulid");
    }
    get isIP() {
      return !!this._def.checks.find((ch) => ch.kind === "ip");
    }
    get isCIDR() {
      return !!this._def.checks.find((ch) => ch.kind === "cidr");
    }
    get isBase64() {
      return !!this._def.checks.find((ch) => ch.kind === "base64");
    }
    get isBase64url() {
      return !!this._def.checks.find((ch) => ch.kind === "base64url");
    }
    get minLength() {
      let min = null;
      for (const ch of this._def.checks) {
        if (ch.kind === "min") {
          if (min === null || ch.value > min)
            min = ch.value;
        }
      }
      return min;
    }
    get maxLength() {
      let max2 = null;
      for (const ch of this._def.checks) {
        if (ch.kind === "max") {
          if (max2 === null || ch.value < max2)
            max2 = ch.value;
        }
      }
      return max2;
    }
  }
  ZodString.create = (params) => {
    return new ZodString({
      checks: [],
      typeName: ZodFirstPartyTypeKind.ZodString,
      coerce: (params == null ? void 0 : params.coerce) ?? false,
      ...processCreateParams(params)
    });
  };
  function floatSafeRemainder(val, step) {
    const valDecCount = (val.toString().split(".")[1] || "").length;
    const stepDecCount = (step.toString().split(".")[1] || "").length;
    const decCount = valDecCount > stepDecCount ? valDecCount : stepDecCount;
    const valInt = Number.parseInt(val.toFixed(decCount).replace(".", ""));
    const stepInt = Number.parseInt(step.toFixed(decCount).replace(".", ""));
    return valInt % stepInt / 10 ** decCount;
  }
  class ZodNumber extends ZodType {
    constructor() {
      super(...arguments);
      this.min = this.gte;
      this.max = this.lte;
      this.step = this.multipleOf;
    }
    _parse(input) {
      if (this._def.coerce) {
        input.data = Number(input.data);
      }
      const parsedType = this._getType(input);
      if (parsedType !== ZodParsedType.number) {
        const ctx2 = this._getOrReturnCtx(input);
        addIssueToContext(ctx2, {
          code: ZodIssueCode.invalid_type,
          expected: ZodParsedType.number,
          received: ctx2.parsedType
        });
        return INVALID;
      }
      let ctx = void 0;
      const status = new ParseStatus();
      for (const check2 of this._def.checks) {
        if (check2.kind === "int") {
          if (!util$8.isInteger(input.data)) {
            ctx = this._getOrReturnCtx(input, ctx);
            addIssueToContext(ctx, {
              code: ZodIssueCode.invalid_type,
              expected: "integer",
              received: "float",
              message: check2.message
            });
            status.dirty();
          }
        } else if (check2.kind === "min") {
          const tooSmall = check2.inclusive ? input.data < check2.value : input.data <= check2.value;
          if (tooSmall) {
            ctx = this._getOrReturnCtx(input, ctx);
            addIssueToContext(ctx, {
              code: ZodIssueCode.too_small,
              minimum: check2.value,
              type: "number",
              inclusive: check2.inclusive,
              exact: false,
              message: check2.message
            });
            status.dirty();
          }
        } else if (check2.kind === "max") {
          const tooBig = check2.inclusive ? input.data > check2.value : input.data >= check2.value;
          if (tooBig) {
            ctx = this._getOrReturnCtx(input, ctx);
            addIssueToContext(ctx, {
              code: ZodIssueCode.too_big,
              maximum: check2.value,
              type: "number",
              inclusive: check2.inclusive,
              exact: false,
              message: check2.message
            });
            status.dirty();
          }
        } else if (check2.kind === "multipleOf") {
          if (floatSafeRemainder(input.data, check2.value) !== 0) {
            ctx = this._getOrReturnCtx(input, ctx);
            addIssueToContext(ctx, {
              code: ZodIssueCode.not_multiple_of,
              multipleOf: check2.value,
              message: check2.message
            });
            status.dirty();
          }
        } else if (check2.kind === "finite") {
          if (!Number.isFinite(input.data)) {
            ctx = this._getOrReturnCtx(input, ctx);
            addIssueToContext(ctx, {
              code: ZodIssueCode.not_finite,
              message: check2.message
            });
            status.dirty();
          }
        } else {
          util$8.assertNever(check2);
        }
      }
      return { status: status.value, value: input.data };
    }
    gte(value, message2) {
      return this.setLimit("min", value, true, errorUtil.toString(message2));
    }
    gt(value, message2) {
      return this.setLimit("min", value, false, errorUtil.toString(message2));
    }
    lte(value, message2) {
      return this.setLimit("max", value, true, errorUtil.toString(message2));
    }
    lt(value, message2) {
      return this.setLimit("max", value, false, errorUtil.toString(message2));
    }
    setLimit(kind, value, inclusive, message2) {
      return new ZodNumber({
        ...this._def,
        checks: [
          ...this._def.checks,
          {
            kind,
            value,
            inclusive,
            message: errorUtil.toString(message2)
          }
        ]
      });
    }
    _addCheck(check2) {
      return new ZodNumber({
        ...this._def,
        checks: [...this._def.checks, check2]
      });
    }
    int(message2) {
      return this._addCheck({
        kind: "int",
        message: errorUtil.toString(message2)
      });
    }
    positive(message2) {
      return this._addCheck({
        kind: "min",
        value: 0,
        inclusive: false,
        message: errorUtil.toString(message2)
      });
    }
    negative(message2) {
      return this._addCheck({
        kind: "max",
        value: 0,
        inclusive: false,
        message: errorUtil.toString(message2)
      });
    }
    nonpositive(message2) {
      return this._addCheck({
        kind: "max",
        value: 0,
        inclusive: true,
        message: errorUtil.toString(message2)
      });
    }
    nonnegative(message2) {
      return this._addCheck({
        kind: "min",
        value: 0,
        inclusive: true,
        message: errorUtil.toString(message2)
      });
    }
    multipleOf(value, message2) {
      return this._addCheck({
        kind: "multipleOf",
        value,
        message: errorUtil.toString(message2)
      });
    }
    finite(message2) {
      return this._addCheck({
        kind: "finite",
        message: errorUtil.toString(message2)
      });
    }
    safe(message2) {
      return this._addCheck({
        kind: "min",
        inclusive: true,
        value: Number.MIN_SAFE_INTEGER,
        message: errorUtil.toString(message2)
      })._addCheck({
        kind: "max",
        inclusive: true,
        value: Number.MAX_SAFE_INTEGER,
        message: errorUtil.toString(message2)
      });
    }
    get minValue() {
      let min = null;
      for (const ch of this._def.checks) {
        if (ch.kind === "min") {
          if (min === null || ch.value > min)
            min = ch.value;
        }
      }
      return min;
    }
    get maxValue() {
      let max2 = null;
      for (const ch of this._def.checks) {
        if (ch.kind === "max") {
          if (max2 === null || ch.value < max2)
            max2 = ch.value;
        }
      }
      return max2;
    }
    get isInt() {
      return !!this._def.checks.find((ch) => ch.kind === "int" || ch.kind === "multipleOf" && util$8.isInteger(ch.value));
    }
    get isFinite() {
      let max2 = null;
      let min = null;
      for (const ch of this._def.checks) {
        if (ch.kind === "finite" || ch.kind === "int" || ch.kind === "multipleOf") {
          return true;
        } else if (ch.kind === "min") {
          if (min === null || ch.value > min)
            min = ch.value;
        } else if (ch.kind === "max") {
          if (max2 === null || ch.value < max2)
            max2 = ch.value;
        }
      }
      return Number.isFinite(min) && Number.isFinite(max2);
    }
  }
  ZodNumber.create = (params) => {
    return new ZodNumber({
      checks: [],
      typeName: ZodFirstPartyTypeKind.ZodNumber,
      coerce: (params == null ? void 0 : params.coerce) || false,
      ...processCreateParams(params)
    });
  };
  class ZodBigInt extends ZodType {
    constructor() {
      super(...arguments);
      this.min = this.gte;
      this.max = this.lte;
    }
    _parse(input) {
      if (this._def.coerce) {
        try {
          input.data = BigInt(input.data);
        } catch {
          return this._getInvalidInput(input);
        }
      }
      const parsedType = this._getType(input);
      if (parsedType !== ZodParsedType.bigint) {
        return this._getInvalidInput(input);
      }
      let ctx = void 0;
      const status = new ParseStatus();
      for (const check2 of this._def.checks) {
        if (check2.kind === "min") {
          const tooSmall = check2.inclusive ? input.data < check2.value : input.data <= check2.value;
          if (tooSmall) {
            ctx = this._getOrReturnCtx(input, ctx);
            addIssueToContext(ctx, {
              code: ZodIssueCode.too_small,
              type: "bigint",
              minimum: check2.value,
              inclusive: check2.inclusive,
              message: check2.message
            });
            status.dirty();
          }
        } else if (check2.kind === "max") {
          const tooBig = check2.inclusive ? input.data > check2.value : input.data >= check2.value;
          if (tooBig) {
            ctx = this._getOrReturnCtx(input, ctx);
            addIssueToContext(ctx, {
              code: ZodIssueCode.too_big,
              type: "bigint",
              maximum: check2.value,
              inclusive: check2.inclusive,
              message: check2.message
            });
            status.dirty();
          }
        } else if (check2.kind === "multipleOf") {
          if (input.data % check2.value !== BigInt(0)) {
            ctx = this._getOrReturnCtx(input, ctx);
            addIssueToContext(ctx, {
              code: ZodIssueCode.not_multiple_of,
              multipleOf: check2.value,
              message: check2.message
            });
            status.dirty();
          }
        } else {
          util$8.assertNever(check2);
        }
      }
      return { status: status.value, value: input.data };
    }
    _getInvalidInput(input) {
      const ctx = this._getOrReturnCtx(input);
      addIssueToContext(ctx, {
        code: ZodIssueCode.invalid_type,
        expected: ZodParsedType.bigint,
        received: ctx.parsedType
      });
      return INVALID;
    }
    gte(value, message2) {
      return this.setLimit("min", value, true, errorUtil.toString(message2));
    }
    gt(value, message2) {
      return this.setLimit("min", value, false, errorUtil.toString(message2));
    }
    lte(value, message2) {
      return this.setLimit("max", value, true, errorUtil.toString(message2));
    }
    lt(value, message2) {
      return this.setLimit("max", value, false, errorUtil.toString(message2));
    }
    setLimit(kind, value, inclusive, message2) {
      return new ZodBigInt({
        ...this._def,
        checks: [
          ...this._def.checks,
          {
            kind,
            value,
            inclusive,
            message: errorUtil.toString(message2)
          }
        ]
      });
    }
    _addCheck(check2) {
      return new ZodBigInt({
        ...this._def,
        checks: [...this._def.checks, check2]
      });
    }
    positive(message2) {
      return this._addCheck({
        kind: "min",
        value: BigInt(0),
        inclusive: false,
        message: errorUtil.toString(message2)
      });
    }
    negative(message2) {
      return this._addCheck({
        kind: "max",
        value: BigInt(0),
        inclusive: false,
        message: errorUtil.toString(message2)
      });
    }
    nonpositive(message2) {
      return this._addCheck({
        kind: "max",
        value: BigInt(0),
        inclusive: true,
        message: errorUtil.toString(message2)
      });
    }
    nonnegative(message2) {
      return this._addCheck({
        kind: "min",
        value: BigInt(0),
        inclusive: true,
        message: errorUtil.toString(message2)
      });
    }
    multipleOf(value, message2) {
      return this._addCheck({
        kind: "multipleOf",
        value,
        message: errorUtil.toString(message2)
      });
    }
    get minValue() {
      let min = null;
      for (const ch of this._def.checks) {
        if (ch.kind === "min") {
          if (min === null || ch.value > min)
            min = ch.value;
        }
      }
      return min;
    }
    get maxValue() {
      let max2 = null;
      for (const ch of this._def.checks) {
        if (ch.kind === "max") {
          if (max2 === null || ch.value < max2)
            max2 = ch.value;
        }
      }
      return max2;
    }
  }
  ZodBigInt.create = (params) => {
    return new ZodBigInt({
      checks: [],
      typeName: ZodFirstPartyTypeKind.ZodBigInt,
      coerce: (params == null ? void 0 : params.coerce) ?? false,
      ...processCreateParams(params)
    });
  };
  class ZodBoolean extends ZodType {
    _parse(input) {
      if (this._def.coerce) {
        input.data = Boolean(input.data);
      }
      const parsedType = this._getType(input);
      if (parsedType !== ZodParsedType.boolean) {
        const ctx = this._getOrReturnCtx(input);
        addIssueToContext(ctx, {
          code: ZodIssueCode.invalid_type,
          expected: ZodParsedType.boolean,
          received: ctx.parsedType
        });
        return INVALID;
      }
      return OK(input.data);
    }
  }
  ZodBoolean.create = (params) => {
    return new ZodBoolean({
      typeName: ZodFirstPartyTypeKind.ZodBoolean,
      coerce: (params == null ? void 0 : params.coerce) || false,
      ...processCreateParams(params)
    });
  };
  class ZodDate extends ZodType {
    _parse(input) {
      if (this._def.coerce) {
        input.data = new Date(input.data);
      }
      const parsedType = this._getType(input);
      if (parsedType !== ZodParsedType.date) {
        const ctx2 = this._getOrReturnCtx(input);
        addIssueToContext(ctx2, {
          code: ZodIssueCode.invalid_type,
          expected: ZodParsedType.date,
          received: ctx2.parsedType
        });
        return INVALID;
      }
      if (Number.isNaN(input.data.getTime())) {
        const ctx2 = this._getOrReturnCtx(input);
        addIssueToContext(ctx2, {
          code: ZodIssueCode.invalid_date
        });
        return INVALID;
      }
      const status = new ParseStatus();
      let ctx = void 0;
      for (const check2 of this._def.checks) {
        if (check2.kind === "min") {
          if (input.data.getTime() < check2.value) {
            ctx = this._getOrReturnCtx(input, ctx);
            addIssueToContext(ctx, {
              code: ZodIssueCode.too_small,
              message: check2.message,
              inclusive: true,
              exact: false,
              minimum: check2.value,
              type: "date"
            });
            status.dirty();
          }
        } else if (check2.kind === "max") {
          if (input.data.getTime() > check2.value) {
            ctx = this._getOrReturnCtx(input, ctx);
            addIssueToContext(ctx, {
              code: ZodIssueCode.too_big,
              message: check2.message,
              inclusive: true,
              exact: false,
              maximum: check2.value,
              type: "date"
            });
            status.dirty();
          }
        } else {
          util$8.assertNever(check2);
        }
      }
      return {
        status: status.value,
        value: new Date(input.data.getTime())
      };
    }
    _addCheck(check2) {
      return new ZodDate({
        ...this._def,
        checks: [...this._def.checks, check2]
      });
    }
    min(minDate, message2) {
      return this._addCheck({
        kind: "min",
        value: minDate.getTime(),
        message: errorUtil.toString(message2)
      });
    }
    max(maxDate, message2) {
      return this._addCheck({
        kind: "max",
        value: maxDate.getTime(),
        message: errorUtil.toString(message2)
      });
    }
    get minDate() {
      let min = null;
      for (const ch of this._def.checks) {
        if (ch.kind === "min") {
          if (min === null || ch.value > min)
            min = ch.value;
        }
      }
      return min != null ? new Date(min) : null;
    }
    get maxDate() {
      let max2 = null;
      for (const ch of this._def.checks) {
        if (ch.kind === "max") {
          if (max2 === null || ch.value < max2)
            max2 = ch.value;
        }
      }
      return max2 != null ? new Date(max2) : null;
    }
  }
  ZodDate.create = (params) => {
    return new ZodDate({
      checks: [],
      coerce: (params == null ? void 0 : params.coerce) || false,
      typeName: ZodFirstPartyTypeKind.ZodDate,
      ...processCreateParams(params)
    });
  };
  class ZodSymbol extends ZodType {
    _parse(input) {
      const parsedType = this._getType(input);
      if (parsedType !== ZodParsedType.symbol) {
        const ctx = this._getOrReturnCtx(input);
        addIssueToContext(ctx, {
          code: ZodIssueCode.invalid_type,
          expected: ZodParsedType.symbol,
          received: ctx.parsedType
        });
        return INVALID;
      }
      return OK(input.data);
    }
  }
  ZodSymbol.create = (params) => {
    return new ZodSymbol({
      typeName: ZodFirstPartyTypeKind.ZodSymbol,
      ...processCreateParams(params)
    });
  };
  class ZodUndefined extends ZodType {
    _parse(input) {
      const parsedType = this._getType(input);
      if (parsedType !== ZodParsedType.undefined) {
        const ctx = this._getOrReturnCtx(input);
        addIssueToContext(ctx, {
          code: ZodIssueCode.invalid_type,
          expected: ZodParsedType.undefined,
          received: ctx.parsedType
        });
        return INVALID;
      }
      return OK(input.data);
    }
  }
  ZodUndefined.create = (params) => {
    return new ZodUndefined({
      typeName: ZodFirstPartyTypeKind.ZodUndefined,
      ...processCreateParams(params)
    });
  };
  class ZodNull extends ZodType {
    _parse(input) {
      const parsedType = this._getType(input);
      if (parsedType !== ZodParsedType.null) {
        const ctx = this._getOrReturnCtx(input);
        addIssueToContext(ctx, {
          code: ZodIssueCode.invalid_type,
          expected: ZodParsedType.null,
          received: ctx.parsedType
        });
        return INVALID;
      }
      return OK(input.data);
    }
  }
  ZodNull.create = (params) => {
    return new ZodNull({
      typeName: ZodFirstPartyTypeKind.ZodNull,
      ...processCreateParams(params)
    });
  };
  class ZodAny extends ZodType {
    constructor() {
      super(...arguments);
      this._any = true;
    }
    _parse(input) {
      return OK(input.data);
    }
  }
  ZodAny.create = (params) => {
    return new ZodAny({
      typeName: ZodFirstPartyTypeKind.ZodAny,
      ...processCreateParams(params)
    });
  };
  class ZodUnknown extends ZodType {
    constructor() {
      super(...arguments);
      this._unknown = true;
    }
    _parse(input) {
      return OK(input.data);
    }
  }
  ZodUnknown.create = (params) => {
    return new ZodUnknown({
      typeName: ZodFirstPartyTypeKind.ZodUnknown,
      ...processCreateParams(params)
    });
  };
  class ZodNever extends ZodType {
    _parse(input) {
      const ctx = this._getOrReturnCtx(input);
      addIssueToContext(ctx, {
        code: ZodIssueCode.invalid_type,
        expected: ZodParsedType.never,
        received: ctx.parsedType
      });
      return INVALID;
    }
  }
  ZodNever.create = (params) => {
    return new ZodNever({
      typeName: ZodFirstPartyTypeKind.ZodNever,
      ...processCreateParams(params)
    });
  };
  class ZodVoid extends ZodType {
    _parse(input) {
      const parsedType = this._getType(input);
      if (parsedType !== ZodParsedType.undefined) {
        const ctx = this._getOrReturnCtx(input);
        addIssueToContext(ctx, {
          code: ZodIssueCode.invalid_type,
          expected: ZodParsedType.void,
          received: ctx.parsedType
        });
        return INVALID;
      }
      return OK(input.data);
    }
  }
  ZodVoid.create = (params) => {
    return new ZodVoid({
      typeName: ZodFirstPartyTypeKind.ZodVoid,
      ...processCreateParams(params)
    });
  };
  class ZodArray extends ZodType {
    _parse(input) {
      const { ctx, status } = this._processInputParams(input);
      const def = this._def;
      if (ctx.parsedType !== ZodParsedType.array) {
        addIssueToContext(ctx, {
          code: ZodIssueCode.invalid_type,
          expected: ZodParsedType.array,
          received: ctx.parsedType
        });
        return INVALID;
      }
      if (def.exactLength !== null) {
        const tooBig = ctx.data.length > def.exactLength.value;
        const tooSmall = ctx.data.length < def.exactLength.value;
        if (tooBig || tooSmall) {
          addIssueToContext(ctx, {
            code: tooBig ? ZodIssueCode.too_big : ZodIssueCode.too_small,
            minimum: tooSmall ? def.exactLength.value : void 0,
            maximum: tooBig ? def.exactLength.value : void 0,
            type: "array",
            inclusive: true,
            exact: true,
            message: def.exactLength.message
          });
          status.dirty();
        }
      }
      if (def.minLength !== null) {
        if (ctx.data.length < def.minLength.value) {
          addIssueToContext(ctx, {
            code: ZodIssueCode.too_small,
            minimum: def.minLength.value,
            type: "array",
            inclusive: true,
            exact: false,
            message: def.minLength.message
          });
          status.dirty();
        }
      }
      if (def.maxLength !== null) {
        if (ctx.data.length > def.maxLength.value) {
          addIssueToContext(ctx, {
            code: ZodIssueCode.too_big,
            maximum: def.maxLength.value,
            type: "array",
            inclusive: true,
            exact: false,
            message: def.maxLength.message
          });
          status.dirty();
        }
      }
      if (ctx.common.async) {
        return Promise.all([...ctx.data].map((item, i2) => {
          return def.type._parseAsync(new ParseInputLazyPath(ctx, item, ctx.path, i2));
        })).then((result2) => {
          return ParseStatus.mergeArray(status, result2);
        });
      }
      const result = [...ctx.data].map((item, i2) => {
        return def.type._parseSync(new ParseInputLazyPath(ctx, item, ctx.path, i2));
      });
      return ParseStatus.mergeArray(status, result);
    }
    get element() {
      return this._def.type;
    }
    min(minLength, message2) {
      return new ZodArray({
        ...this._def,
        minLength: { value: minLength, message: errorUtil.toString(message2) }
      });
    }
    max(maxLength, message2) {
      return new ZodArray({
        ...this._def,
        maxLength: { value: maxLength, message: errorUtil.toString(message2) }
      });
    }
    length(len, message2) {
      return new ZodArray({
        ...this._def,
        exactLength: { value: len, message: errorUtil.toString(message2) }
      });
    }
    nonempty(message2) {
      return this.min(1, message2);
    }
  }
  ZodArray.create = (schema, params) => {
    return new ZodArray({
      type: schema,
      minLength: null,
      maxLength: null,
      exactLength: null,
      typeName: ZodFirstPartyTypeKind.ZodArray,
      ...processCreateParams(params)
    });
  };
  function deepPartialify(schema) {
    if (schema instanceof ZodObject) {
      const newShape = {};
      for (const key in schema.shape) {
        const fieldSchema = schema.shape[key];
        newShape[key] = ZodOptional.create(deepPartialify(fieldSchema));
      }
      return new ZodObject({
        ...schema._def,
        shape: () => newShape
      });
    } else if (schema instanceof ZodArray) {
      return new ZodArray({
        ...schema._def,
        type: deepPartialify(schema.element)
      });
    } else if (schema instanceof ZodOptional) {
      return ZodOptional.create(deepPartialify(schema.unwrap()));
    } else if (schema instanceof ZodNullable) {
      return ZodNullable.create(deepPartialify(schema.unwrap()));
    } else if (schema instanceof ZodTuple) {
      return ZodTuple.create(schema.items.map((item) => deepPartialify(item)));
    } else {
      return schema;
    }
  }
  class ZodObject extends ZodType {
    constructor() {
      super(...arguments);
      this._cached = null;
      this.nonstrict = this.passthrough;
      this.augment = this.extend;
    }
    _getCached() {
      if (this._cached !== null)
        return this._cached;
      const shape = this._def.shape();
      const keys2 = util$8.objectKeys(shape);
      this._cached = { shape, keys: keys2 };
      return this._cached;
    }
    _parse(input) {
      const parsedType = this._getType(input);
      if (parsedType !== ZodParsedType.object) {
        const ctx2 = this._getOrReturnCtx(input);
        addIssueToContext(ctx2, {
          code: ZodIssueCode.invalid_type,
          expected: ZodParsedType.object,
          received: ctx2.parsedType
        });
        return INVALID;
      }
      const { status, ctx } = this._processInputParams(input);
      const { shape, keys: shapeKeys } = this._getCached();
      const extraKeys = [];
      if (!(this._def.catchall instanceof ZodNever && this._def.unknownKeys === "strip")) {
        for (const key in ctx.data) {
          if (!shapeKeys.includes(key)) {
            extraKeys.push(key);
          }
        }
      }
      const pairs = [];
      for (const key of shapeKeys) {
        const keyValidator = shape[key];
        const value = ctx.data[key];
        pairs.push({
          key: { status: "valid", value: key },
          value: keyValidator._parse(new ParseInputLazyPath(ctx, value, ctx.path, key)),
          alwaysSet: key in ctx.data
        });
      }
      if (this._def.catchall instanceof ZodNever) {
        const unknownKeys = this._def.unknownKeys;
        if (unknownKeys === "passthrough") {
          for (const key of extraKeys) {
            pairs.push({
              key: { status: "valid", value: key },
              value: { status: "valid", value: ctx.data[key] }
            });
          }
        } else if (unknownKeys === "strict") {
          if (extraKeys.length > 0) {
            addIssueToContext(ctx, {
              code: ZodIssueCode.unrecognized_keys,
              keys: extraKeys
            });
            status.dirty();
          }
        } else if (unknownKeys === "strip") ;
        else {
          throw new Error(`Internal ZodObject error: invalid unknownKeys value.`);
        }
      } else {
        const catchall = this._def.catchall;
        for (const key of extraKeys) {
          const value = ctx.data[key];
          pairs.push({
            key: { status: "valid", value: key },
            value: catchall._parse(
              new ParseInputLazyPath(ctx, value, ctx.path, key)
              //, ctx.child(key), value, getParsedType(value)
            ),
            alwaysSet: key in ctx.data
          });
        }
      }
      if (ctx.common.async) {
        return Promise.resolve().then(async () => {
          const syncPairs = [];
          for (const pair of pairs) {
            const key = await pair.key;
            const value = await pair.value;
            syncPairs.push({
              key,
              value,
              alwaysSet: pair.alwaysSet
            });
          }
          return syncPairs;
        }).then((syncPairs) => {
          return ParseStatus.mergeObjectSync(status, syncPairs);
        });
      } else {
        return ParseStatus.mergeObjectSync(status, pairs);
      }
    }
    get shape() {
      return this._def.shape();
    }
    strict(message2) {
      errorUtil.errToObj;
      return new ZodObject({
        ...this._def,
        unknownKeys: "strict",
        ...message2 !== void 0 ? {
          errorMap: (issue, ctx) => {
            var _a3, _b2;
            const defaultError = ((_b2 = (_a3 = this._def).errorMap) == null ? void 0 : _b2.call(_a3, issue, ctx).message) ?? ctx.defaultError;
            if (issue.code === "unrecognized_keys")
              return {
                message: errorUtil.errToObj(message2).message ?? defaultError
              };
            return {
              message: defaultError
            };
          }
        } : {}
      });
    }
    strip() {
      return new ZodObject({
        ...this._def,
        unknownKeys: "strip"
      });
    }
    passthrough() {
      return new ZodObject({
        ...this._def,
        unknownKeys: "passthrough"
      });
    }
    // const AugmentFactory =
    //   <Def extends ZodObjectDef>(def: Def) =>
    //   <Augmentation extends ZodRawShape>(
    //     augmentation: Augmentation
    //   ): ZodObject<
    //     extendShape<ReturnType<Def["shape"]>, Augmentation>,
    //     Def["unknownKeys"],
    //     Def["catchall"]
    //   > => {
    //     return new ZodObject({
    //       ...def,
    //       shape: () => ({
    //         ...def.shape(),
    //         ...augmentation,
    //       }),
    //     }) as any;
    //   };
    extend(augmentation) {
      return new ZodObject({
        ...this._def,
        shape: () => ({
          ...this._def.shape(),
          ...augmentation
        })
      });
    }
    /**
     * Prior to zod@1.0.12 there was a bug in the
     * inferred type of merged objects. Please
     * upgrade if you are experiencing issues.
     */
    merge(merging) {
      const merged = new ZodObject({
        unknownKeys: merging._def.unknownKeys,
        catchall: merging._def.catchall,
        shape: () => ({
          ...this._def.shape(),
          ...merging._def.shape()
        }),
        typeName: ZodFirstPartyTypeKind.ZodObject
      });
      return merged;
    }
    // merge<
    //   Incoming extends AnyZodObject,
    //   Augmentation extends Incoming["shape"],
    //   NewOutput extends {
    //     [k in keyof Augmentation | keyof Output]: k extends keyof Augmentation
    //       ? Augmentation[k]["_output"]
    //       : k extends keyof Output
    //       ? Output[k]
    //       : never;
    //   },
    //   NewInput extends {
    //     [k in keyof Augmentation | keyof Input]: k extends keyof Augmentation
    //       ? Augmentation[k]["_input"]
    //       : k extends keyof Input
    //       ? Input[k]
    //       : never;
    //   }
    // >(
    //   merging: Incoming
    // ): ZodObject<
    //   extendShape<T, ReturnType<Incoming["_def"]["shape"]>>,
    //   Incoming["_def"]["unknownKeys"],
    //   Incoming["_def"]["catchall"],
    //   NewOutput,
    //   NewInput
    // > {
    //   const merged: any = new ZodObject({
    //     unknownKeys: merging._def.unknownKeys,
    //     catchall: merging._def.catchall,
    //     shape: () =>
    //       objectUtil.mergeShapes(this._def.shape(), merging._def.shape()),
    //     typeName: ZodFirstPartyTypeKind.ZodObject,
    //   }) as any;
    //   return merged;
    // }
    setKey(key, schema) {
      return this.augment({ [key]: schema });
    }
    // merge<Incoming extends AnyZodObject>(
    //   merging: Incoming
    // ): //ZodObject<T & Incoming["_shape"], UnknownKeys, Catchall> = (merging) => {
    // ZodObject<
    //   extendShape<T, ReturnType<Incoming["_def"]["shape"]>>,
    //   Incoming["_def"]["unknownKeys"],
    //   Incoming["_def"]["catchall"]
    // > {
    //   // const mergedShape = objectUtil.mergeShapes(
    //   //   this._def.shape(),
    //   //   merging._def.shape()
    //   // );
    //   const merged: any = new ZodObject({
    //     unknownKeys: merging._def.unknownKeys,
    //     catchall: merging._def.catchall,
    //     shape: () =>
    //       objectUtil.mergeShapes(this._def.shape(), merging._def.shape()),
    //     typeName: ZodFirstPartyTypeKind.ZodObject,
    //   }) as any;
    //   return merged;
    // }
    catchall(index2) {
      return new ZodObject({
        ...this._def,
        catchall: index2
      });
    }
    pick(mask) {
      const shape = {};
      for (const key of util$8.objectKeys(mask)) {
        if (mask[key] && this.shape[key]) {
          shape[key] = this.shape[key];
        }
      }
      return new ZodObject({
        ...this._def,
        shape: () => shape
      });
    }
    omit(mask) {
      const shape = {};
      for (const key of util$8.objectKeys(this.shape)) {
        if (!mask[key]) {
          shape[key] = this.shape[key];
        }
      }
      return new ZodObject({
        ...this._def,
        shape: () => shape
      });
    }
    /**
     * @deprecated
     */
    deepPartial() {
      return deepPartialify(this);
    }
    partial(mask) {
      const newShape = {};
      for (const key of util$8.objectKeys(this.shape)) {
        const fieldSchema = this.shape[key];
        if (mask && !mask[key]) {
          newShape[key] = fieldSchema;
        } else {
          newShape[key] = fieldSchema.optional();
        }
      }
      return new ZodObject({
        ...this._def,
        shape: () => newShape
      });
    }
    required(mask) {
      const newShape = {};
      for (const key of util$8.objectKeys(this.shape)) {
        if (mask && !mask[key]) {
          newShape[key] = this.shape[key];
        } else {
          const fieldSchema = this.shape[key];
          let newField = fieldSchema;
          while (newField instanceof ZodOptional) {
            newField = newField._def.innerType;
          }
          newShape[key] = newField;
        }
      }
      return new ZodObject({
        ...this._def,
        shape: () => newShape
      });
    }
    keyof() {
      return createZodEnum(util$8.objectKeys(this.shape));
    }
  }
  ZodObject.create = (shape, params) => {
    return new ZodObject({
      shape: () => shape,
      unknownKeys: "strip",
      catchall: ZodNever.create(),
      typeName: ZodFirstPartyTypeKind.ZodObject,
      ...processCreateParams(params)
    });
  };
  ZodObject.strictCreate = (shape, params) => {
    return new ZodObject({
      shape: () => shape,
      unknownKeys: "strict",
      catchall: ZodNever.create(),
      typeName: ZodFirstPartyTypeKind.ZodObject,
      ...processCreateParams(params)
    });
  };
  ZodObject.lazycreate = (shape, params) => {
    return new ZodObject({
      shape,
      unknownKeys: "strip",
      catchall: ZodNever.create(),
      typeName: ZodFirstPartyTypeKind.ZodObject,
      ...processCreateParams(params)
    });
  };
  class ZodUnion extends ZodType {
    _parse(input) {
      const { ctx } = this._processInputParams(input);
      const options = this._def.options;
      function handleResults(results) {
        for (const result of results) {
          if (result.result.status === "valid") {
            return result.result;
          }
        }
        for (const result of results) {
          if (result.result.status === "dirty") {
            ctx.common.issues.push(...result.ctx.common.issues);
            return result.result;
          }
        }
        const unionErrors = results.map((result) => new ZodError(result.ctx.common.issues));
        addIssueToContext(ctx, {
          code: ZodIssueCode.invalid_union,
          unionErrors
        });
        return INVALID;
      }
      if (ctx.common.async) {
        return Promise.all(options.map(async (option) => {
          const childCtx = {
            ...ctx,
            common: {
              ...ctx.common,
              issues: []
            },
            parent: null
          };
          return {
            result: await option._parseAsync({
              data: ctx.data,
              path: ctx.path,
              parent: childCtx
            }),
            ctx: childCtx
          };
        })).then(handleResults);
      } else {
        let dirty = void 0;
        const issues = [];
        for (const option of options) {
          const childCtx = {
            ...ctx,
            common: {
              ...ctx.common,
              issues: []
            },
            parent: null
          };
          const result = option._parseSync({
            data: ctx.data,
            path: ctx.path,
            parent: childCtx
          });
          if (result.status === "valid") {
            return result;
          } else if (result.status === "dirty" && !dirty) {
            dirty = { result, ctx: childCtx };
          }
          if (childCtx.common.issues.length) {
            issues.push(childCtx.common.issues);
          }
        }
        if (dirty) {
          ctx.common.issues.push(...dirty.ctx.common.issues);
          return dirty.result;
        }
        const unionErrors = issues.map((issues2) => new ZodError(issues2));
        addIssueToContext(ctx, {
          code: ZodIssueCode.invalid_union,
          unionErrors
        });
        return INVALID;
      }
    }
    get options() {
      return this._def.options;
    }
  }
  ZodUnion.create = (types2, params) => {
    return new ZodUnion({
      options: types2,
      typeName: ZodFirstPartyTypeKind.ZodUnion,
      ...processCreateParams(params)
    });
  };
  const getDiscriminator = (type2) => {
    if (type2 instanceof ZodLazy) {
      return getDiscriminator(type2.schema);
    } else if (type2 instanceof ZodEffects) {
      return getDiscriminator(type2.innerType());
    } else if (type2 instanceof ZodLiteral) {
      return [type2.value];
    } else if (type2 instanceof ZodEnum) {
      return type2.options;
    } else if (type2 instanceof ZodNativeEnum) {
      return util$8.objectValues(type2.enum);
    } else if (type2 instanceof ZodDefault) {
      return getDiscriminator(type2._def.innerType);
    } else if (type2 instanceof ZodUndefined) {
      return [void 0];
    } else if (type2 instanceof ZodNull) {
      return [null];
    } else if (type2 instanceof ZodOptional) {
      return [void 0, ...getDiscriminator(type2.unwrap())];
    } else if (type2 instanceof ZodNullable) {
      return [null, ...getDiscriminator(type2.unwrap())];
    } else if (type2 instanceof ZodBranded) {
      return getDiscriminator(type2.unwrap());
    } else if (type2 instanceof ZodReadonly) {
      return getDiscriminator(type2.unwrap());
    } else if (type2 instanceof ZodCatch) {
      return getDiscriminator(type2._def.innerType);
    } else {
      return [];
    }
  };
  class ZodDiscriminatedUnion extends ZodType {
    _parse(input) {
      const { ctx } = this._processInputParams(input);
      if (ctx.parsedType !== ZodParsedType.object) {
        addIssueToContext(ctx, {
          code: ZodIssueCode.invalid_type,
          expected: ZodParsedType.object,
          received: ctx.parsedType
        });
        return INVALID;
      }
      const discriminator = this.discriminator;
      const discriminatorValue = ctx.data[discriminator];
      const option = this.optionsMap.get(discriminatorValue);
      if (!option) {
        addIssueToContext(ctx, {
          code: ZodIssueCode.invalid_union_discriminator,
          options: Array.from(this.optionsMap.keys()),
          path: [discriminator]
        });
        return INVALID;
      }
      if (ctx.common.async) {
        return option._parseAsync({
          data: ctx.data,
          path: ctx.path,
          parent: ctx
        });
      } else {
        return option._parseSync({
          data: ctx.data,
          path: ctx.path,
          parent: ctx
        });
      }
    }
    get discriminator() {
      return this._def.discriminator;
    }
    get options() {
      return this._def.options;
    }
    get optionsMap() {
      return this._def.optionsMap;
    }
    /**
     * The constructor of the discriminated union schema. Its behaviour is very similar to that of the normal z.union() constructor.
     * However, it only allows a union of objects, all of which need to share a discriminator property. This property must
     * have a different value for each object in the union.
     * @param discriminator the name of the discriminator property
     * @param types an array of object schemas
     * @param params
     */
    static create(discriminator, options, params) {
      const optionsMap = /* @__PURE__ */ new Map();
      for (const type2 of options) {
        const discriminatorValues = getDiscriminator(type2.shape[discriminator]);
        if (!discriminatorValues.length) {
          throw new Error(`A discriminator value for key \`${discriminator}\` could not be extracted from all schema options`);
        }
        for (const value of discriminatorValues) {
          if (optionsMap.has(value)) {
            throw new Error(`Discriminator property ${String(discriminator)} has duplicate value ${String(value)}`);
          }
          optionsMap.set(value, type2);
        }
      }
      return new ZodDiscriminatedUnion({
        typeName: ZodFirstPartyTypeKind.ZodDiscriminatedUnion,
        discriminator,
        options,
        optionsMap,
        ...processCreateParams(params)
      });
    }
  }
  function mergeValues(a2, b2) {
    const aType = getParsedType(a2);
    const bType = getParsedType(b2);
    if (a2 === b2) {
      return { valid: true, data: a2 };
    } else if (aType === ZodParsedType.object && bType === ZodParsedType.object) {
      const bKeys = util$8.objectKeys(b2);
      const sharedKeys = util$8.objectKeys(a2).filter((key) => bKeys.indexOf(key) !== -1);
      const newObj = { ...a2, ...b2 };
      for (const key of sharedKeys) {
        const sharedValue = mergeValues(a2[key], b2[key]);
        if (!sharedValue.valid) {
          return { valid: false };
        }
        newObj[key] = sharedValue.data;
      }
      return { valid: true, data: newObj };
    } else if (aType === ZodParsedType.array && bType === ZodParsedType.array) {
      if (a2.length !== b2.length) {
        return { valid: false };
      }
      const newArray = [];
      for (let index2 = 0; index2 < a2.length; index2++) {
        const itemA = a2[index2];
        const itemB = b2[index2];
        const sharedValue = mergeValues(itemA, itemB);
        if (!sharedValue.valid) {
          return { valid: false };
        }
        newArray.push(sharedValue.data);
      }
      return { valid: true, data: newArray };
    } else if (aType === ZodParsedType.date && bType === ZodParsedType.date && +a2 === +b2) {
      return { valid: true, data: a2 };
    } else {
      return { valid: false };
    }
  }
  class ZodIntersection extends ZodType {
    _parse(input) {
      const { status, ctx } = this._processInputParams(input);
      const handleParsed = (parsedLeft, parsedRight) => {
        if (isAborted(parsedLeft) || isAborted(parsedRight)) {
          return INVALID;
        }
        const merged = mergeValues(parsedLeft.value, parsedRight.value);
        if (!merged.valid) {
          addIssueToContext(ctx, {
            code: ZodIssueCode.invalid_intersection_types
          });
          return INVALID;
        }
        if (isDirty(parsedLeft) || isDirty(parsedRight)) {
          status.dirty();
        }
        return { status: status.value, value: merged.data };
      };
      if (ctx.common.async) {
        return Promise.all([
          this._def.left._parseAsync({
            data: ctx.data,
            path: ctx.path,
            parent: ctx
          }),
          this._def.right._parseAsync({
            data: ctx.data,
            path: ctx.path,
            parent: ctx
          })
        ]).then(([left, right]) => handleParsed(left, right));
      } else {
        return handleParsed(this._def.left._parseSync({
          data: ctx.data,
          path: ctx.path,
          parent: ctx
        }), this._def.right._parseSync({
          data: ctx.data,
          path: ctx.path,
          parent: ctx
        }));
      }
    }
  }
  ZodIntersection.create = (left, right, params) => {
    return new ZodIntersection({
      left,
      right,
      typeName: ZodFirstPartyTypeKind.ZodIntersection,
      ...processCreateParams(params)
    });
  };
  class ZodTuple extends ZodType {
    _parse(input) {
      const { status, ctx } = this._processInputParams(input);
      if (ctx.parsedType !== ZodParsedType.array) {
        addIssueToContext(ctx, {
          code: ZodIssueCode.invalid_type,
          expected: ZodParsedType.array,
          received: ctx.parsedType
        });
        return INVALID;
      }
      if (ctx.data.length < this._def.items.length) {
        addIssueToContext(ctx, {
          code: ZodIssueCode.too_small,
          minimum: this._def.items.length,
          inclusive: true,
          exact: false,
          type: "array"
        });
        return INVALID;
      }
      const rest = this._def.rest;
      if (!rest && ctx.data.length > this._def.items.length) {
        addIssueToContext(ctx, {
          code: ZodIssueCode.too_big,
          maximum: this._def.items.length,
          inclusive: true,
          exact: false,
          type: "array"
        });
        status.dirty();
      }
      const items = [...ctx.data].map((item, itemIndex) => {
        const schema = this._def.items[itemIndex] || this._def.rest;
        if (!schema)
          return null;
        return schema._parse(new ParseInputLazyPath(ctx, item, ctx.path, itemIndex));
      }).filter((x2) => !!x2);
      if (ctx.common.async) {
        return Promise.all(items).then((results) => {
          return ParseStatus.mergeArray(status, results);
        });
      } else {
        return ParseStatus.mergeArray(status, items);
      }
    }
    get items() {
      return this._def.items;
    }
    rest(rest) {
      return new ZodTuple({
        ...this._def,
        rest
      });
    }
  }
  ZodTuple.create = (schemas, params) => {
    if (!Array.isArray(schemas)) {
      throw new Error("You must pass an array of schemas to z.tuple([ ... ])");
    }
    return new ZodTuple({
      items: schemas,
      typeName: ZodFirstPartyTypeKind.ZodTuple,
      rest: null,
      ...processCreateParams(params)
    });
  };
  class ZodRecord extends ZodType {
    get keySchema() {
      return this._def.keyType;
    }
    get valueSchema() {
      return this._def.valueType;
    }
    _parse(input) {
      const { status, ctx } = this._processInputParams(input);
      if (ctx.parsedType !== ZodParsedType.object) {
        addIssueToContext(ctx, {
          code: ZodIssueCode.invalid_type,
          expected: ZodParsedType.object,
          received: ctx.parsedType
        });
        return INVALID;
      }
      const pairs = [];
      const keyType = this._def.keyType;
      const valueType = this._def.valueType;
      for (const key in ctx.data) {
        pairs.push({
          key: keyType._parse(new ParseInputLazyPath(ctx, key, ctx.path, key)),
          value: valueType._parse(new ParseInputLazyPath(ctx, ctx.data[key], ctx.path, key)),
          alwaysSet: key in ctx.data
        });
      }
      if (ctx.common.async) {
        return ParseStatus.mergeObjectAsync(status, pairs);
      } else {
        return ParseStatus.mergeObjectSync(status, pairs);
      }
    }
    get element() {
      return this._def.valueType;
    }
    static create(first, second, third) {
      if (second instanceof ZodType) {
        return new ZodRecord({
          keyType: first,
          valueType: second,
          typeName: ZodFirstPartyTypeKind.ZodRecord,
          ...processCreateParams(third)
        });
      }
      return new ZodRecord({
        keyType: ZodString.create(),
        valueType: first,
        typeName: ZodFirstPartyTypeKind.ZodRecord,
        ...processCreateParams(second)
      });
    }
  }
  class ZodMap extends ZodType {
    get keySchema() {
      return this._def.keyType;
    }
    get valueSchema() {
      return this._def.valueType;
    }
    _parse(input) {
      const { status, ctx } = this._processInputParams(input);
      if (ctx.parsedType !== ZodParsedType.map) {
        addIssueToContext(ctx, {
          code: ZodIssueCode.invalid_type,
          expected: ZodParsedType.map,
          received: ctx.parsedType
        });
        return INVALID;
      }
      const keyType = this._def.keyType;
      const valueType = this._def.valueType;
      const pairs = [...ctx.data.entries()].map(([key, value], index2) => {
        return {
          key: keyType._parse(new ParseInputLazyPath(ctx, key, ctx.path, [index2, "key"])),
          value: valueType._parse(new ParseInputLazyPath(ctx, value, ctx.path, [index2, "value"]))
        };
      });
      if (ctx.common.async) {
        const finalMap = /* @__PURE__ */ new Map();
        return Promise.resolve().then(async () => {
          for (const pair of pairs) {
            const key = await pair.key;
            const value = await pair.value;
            if (key.status === "aborted" || value.status === "aborted") {
              return INVALID;
            }
            if (key.status === "dirty" || value.status === "dirty") {
              status.dirty();
            }
            finalMap.set(key.value, value.value);
          }
          return { status: status.value, value: finalMap };
        });
      } else {
        const finalMap = /* @__PURE__ */ new Map();
        for (const pair of pairs) {
          const key = pair.key;
          const value = pair.value;
          if (key.status === "aborted" || value.status === "aborted") {
            return INVALID;
          }
          if (key.status === "dirty" || value.status === "dirty") {
            status.dirty();
          }
          finalMap.set(key.value, value.value);
        }
        return { status: status.value, value: finalMap };
      }
    }
  }
  ZodMap.create = (keyType, valueType, params) => {
    return new ZodMap({
      valueType,
      keyType,
      typeName: ZodFirstPartyTypeKind.ZodMap,
      ...processCreateParams(params)
    });
  };
  class ZodSet extends ZodType {
    _parse(input) {
      const { status, ctx } = this._processInputParams(input);
      if (ctx.parsedType !== ZodParsedType.set) {
        addIssueToContext(ctx, {
          code: ZodIssueCode.invalid_type,
          expected: ZodParsedType.set,
          received: ctx.parsedType
        });
        return INVALID;
      }
      const def = this._def;
      if (def.minSize !== null) {
        if (ctx.data.size < def.minSize.value) {
          addIssueToContext(ctx, {
            code: ZodIssueCode.too_small,
            minimum: def.minSize.value,
            type: "set",
            inclusive: true,
            exact: false,
            message: def.minSize.message
          });
          status.dirty();
        }
      }
      if (def.maxSize !== null) {
        if (ctx.data.size > def.maxSize.value) {
          addIssueToContext(ctx, {
            code: ZodIssueCode.too_big,
            maximum: def.maxSize.value,
            type: "set",
            inclusive: true,
            exact: false,
            message: def.maxSize.message
          });
          status.dirty();
        }
      }
      const valueType = this._def.valueType;
      function finalizeSet(elements2) {
        const parsedSet = /* @__PURE__ */ new Set();
        for (const element of elements2) {
          if (element.status === "aborted")
            return INVALID;
          if (element.status === "dirty")
            status.dirty();
          parsedSet.add(element.value);
        }
        return { status: status.value, value: parsedSet };
      }
      const elements = [...ctx.data.values()].map((item, i2) => valueType._parse(new ParseInputLazyPath(ctx, item, ctx.path, i2)));
      if (ctx.common.async) {
        return Promise.all(elements).then((elements2) => finalizeSet(elements2));
      } else {
        return finalizeSet(elements);
      }
    }
    min(minSize, message2) {
      return new ZodSet({
        ...this._def,
        minSize: { value: minSize, message: errorUtil.toString(message2) }
      });
    }
    max(maxSize, message2) {
      return new ZodSet({
        ...this._def,
        maxSize: { value: maxSize, message: errorUtil.toString(message2) }
      });
    }
    size(size, message2) {
      return this.min(size, message2).max(size, message2);
    }
    nonempty(message2) {
      return this.min(1, message2);
    }
  }
  ZodSet.create = (valueType, params) => {
    return new ZodSet({
      valueType,
      minSize: null,
      maxSize: null,
      typeName: ZodFirstPartyTypeKind.ZodSet,
      ...processCreateParams(params)
    });
  };
  class ZodLazy extends ZodType {
    get schema() {
      return this._def.getter();
    }
    _parse(input) {
      const { ctx } = this._processInputParams(input);
      const lazySchema = this._def.getter();
      return lazySchema._parse({ data: ctx.data, path: ctx.path, parent: ctx });
    }
  }
  ZodLazy.create = (getter, params) => {
    return new ZodLazy({
      getter,
      typeName: ZodFirstPartyTypeKind.ZodLazy,
      ...processCreateParams(params)
    });
  };
  class ZodLiteral extends ZodType {
    _parse(input) {
      if (input.data !== this._def.value) {
        const ctx = this._getOrReturnCtx(input);
        addIssueToContext(ctx, {
          received: ctx.data,
          code: ZodIssueCode.invalid_literal,
          expected: this._def.value
        });
        return INVALID;
      }
      return { status: "valid", value: input.data };
    }
    get value() {
      return this._def.value;
    }
  }
  ZodLiteral.create = (value, params) => {
    return new ZodLiteral({
      value,
      typeName: ZodFirstPartyTypeKind.ZodLiteral,
      ...processCreateParams(params)
    });
  };
  function createZodEnum(values, params) {
    return new ZodEnum({
      values,
      typeName: ZodFirstPartyTypeKind.ZodEnum,
      ...processCreateParams(params)
    });
  }
  class ZodEnum extends ZodType {
    _parse(input) {
      if (typeof input.data !== "string") {
        const ctx = this._getOrReturnCtx(input);
        const expectedValues = this._def.values;
        addIssueToContext(ctx, {
          expected: util$8.joinValues(expectedValues),
          received: ctx.parsedType,
          code: ZodIssueCode.invalid_type
        });
        return INVALID;
      }
      if (!this._cache) {
        this._cache = new Set(this._def.values);
      }
      if (!this._cache.has(input.data)) {
        const ctx = this._getOrReturnCtx(input);
        const expectedValues = this._def.values;
        addIssueToContext(ctx, {
          received: ctx.data,
          code: ZodIssueCode.invalid_enum_value,
          options: expectedValues
        });
        return INVALID;
      }
      return OK(input.data);
    }
    get options() {
      return this._def.values;
    }
    get enum() {
      const enumValues = {};
      for (const val of this._def.values) {
        enumValues[val] = val;
      }
      return enumValues;
    }
    get Values() {
      const enumValues = {};
      for (const val of this._def.values) {
        enumValues[val] = val;
      }
      return enumValues;
    }
    get Enum() {
      const enumValues = {};
      for (const val of this._def.values) {
        enumValues[val] = val;
      }
      return enumValues;
    }
    extract(values, newDef = this._def) {
      return ZodEnum.create(values, {
        ...this._def,
        ...newDef
      });
    }
    exclude(values, newDef = this._def) {
      return ZodEnum.create(this.options.filter((opt) => !values.includes(opt)), {
        ...this._def,
        ...newDef
      });
    }
  }
  ZodEnum.create = createZodEnum;
  class ZodNativeEnum extends ZodType {
    _parse(input) {
      const nativeEnumValues = util$8.getValidEnumValues(this._def.values);
      const ctx = this._getOrReturnCtx(input);
      if (ctx.parsedType !== ZodParsedType.string && ctx.parsedType !== ZodParsedType.number) {
        const expectedValues = util$8.objectValues(nativeEnumValues);
        addIssueToContext(ctx, {
          expected: util$8.joinValues(expectedValues),
          received: ctx.parsedType,
          code: ZodIssueCode.invalid_type
        });
        return INVALID;
      }
      if (!this._cache) {
        this._cache = new Set(util$8.getValidEnumValues(this._def.values));
      }
      if (!this._cache.has(input.data)) {
        const expectedValues = util$8.objectValues(nativeEnumValues);
        addIssueToContext(ctx, {
          received: ctx.data,
          code: ZodIssueCode.invalid_enum_value,
          options: expectedValues
        });
        return INVALID;
      }
      return OK(input.data);
    }
    get enum() {
      return this._def.values;
    }
  }
  ZodNativeEnum.create = (values, params) => {
    return new ZodNativeEnum({
      values,
      typeName: ZodFirstPartyTypeKind.ZodNativeEnum,
      ...processCreateParams(params)
    });
  };
  class ZodPromise extends ZodType {
    unwrap() {
      return this._def.type;
    }
    _parse(input) {
      const { ctx } = this._processInputParams(input);
      if (ctx.parsedType !== ZodParsedType.promise && ctx.common.async === false) {
        addIssueToContext(ctx, {
          code: ZodIssueCode.invalid_type,
          expected: ZodParsedType.promise,
          received: ctx.parsedType
        });
        return INVALID;
      }
      const promisified = ctx.parsedType === ZodParsedType.promise ? ctx.data : Promise.resolve(ctx.data);
      return OK(promisified.then((data2) => {
        return this._def.type.parseAsync(data2, {
          path: ctx.path,
          errorMap: ctx.common.contextualErrorMap
        });
      }));
    }
  }
  ZodPromise.create = (schema, params) => {
    return new ZodPromise({
      type: schema,
      typeName: ZodFirstPartyTypeKind.ZodPromise,
      ...processCreateParams(params)
    });
  };
  class ZodEffects extends ZodType {
    innerType() {
      return this._def.schema;
    }
    sourceType() {
      return this._def.schema._def.typeName === ZodFirstPartyTypeKind.ZodEffects ? this._def.schema.sourceType() : this._def.schema;
    }
    _parse(input) {
      const { status, ctx } = this._processInputParams(input);
      const effect = this._def.effect || null;
      const checkCtx = {
        addIssue: (arg) => {
          addIssueToContext(ctx, arg);
          if (arg.fatal) {
            status.abort();
          } else {
            status.dirty();
          }
        },
        get path() {
          return ctx.path;
        }
      };
      checkCtx.addIssue = checkCtx.addIssue.bind(checkCtx);
      if (effect.type === "preprocess") {
        const processed = effect.transform(ctx.data, checkCtx);
        if (ctx.common.async) {
          return Promise.resolve(processed).then(async (processed2) => {
            if (status.value === "aborted")
              return INVALID;
            const result = await this._def.schema._parseAsync({
              data: processed2,
              path: ctx.path,
              parent: ctx
            });
            if (result.status === "aborted")
              return INVALID;
            if (result.status === "dirty")
              return DIRTY(result.value);
            if (status.value === "dirty")
              return DIRTY(result.value);
            return result;
          });
        } else {
          if (status.value === "aborted")
            return INVALID;
          const result = this._def.schema._parseSync({
            data: processed,
            path: ctx.path,
            parent: ctx
          });
          if (result.status === "aborted")
            return INVALID;
          if (result.status === "dirty")
            return DIRTY(result.value);
          if (status.value === "dirty")
            return DIRTY(result.value);
          return result;
        }
      }
      if (effect.type === "refinement") {
        const executeRefinement = (acc) => {
          const result = effect.refinement(acc, checkCtx);
          if (ctx.common.async) {
            return Promise.resolve(result);
          }
          if (result instanceof Promise) {
            throw new Error("Async refinement encountered during synchronous parse operation. Use .parseAsync instead.");
          }
          return acc;
        };
        if (ctx.common.async === false) {
          const inner = this._def.schema._parseSync({
            data: ctx.data,
            path: ctx.path,
            parent: ctx
          });
          if (inner.status === "aborted")
            return INVALID;
          if (inner.status === "dirty")
            status.dirty();
          executeRefinement(inner.value);
          return { status: status.value, value: inner.value };
        } else {
          return this._def.schema._parseAsync({ data: ctx.data, path: ctx.path, parent: ctx }).then((inner) => {
            if (inner.status === "aborted")
              return INVALID;
            if (inner.status === "dirty")
              status.dirty();
            return executeRefinement(inner.value).then(() => {
              return { status: status.value, value: inner.value };
            });
          });
        }
      }
      if (effect.type === "transform") {
        if (ctx.common.async === false) {
          const base = this._def.schema._parseSync({
            data: ctx.data,
            path: ctx.path,
            parent: ctx
          });
          if (!isValid(base))
            return INVALID;
          const result = effect.transform(base.value, checkCtx);
          if (result instanceof Promise) {
            throw new Error(`Asynchronous transform encountered during synchronous parse operation. Use .parseAsync instead.`);
          }
          return { status: status.value, value: result };
        } else {
          return this._def.schema._parseAsync({ data: ctx.data, path: ctx.path, parent: ctx }).then((base) => {
            if (!isValid(base))
              return INVALID;
            return Promise.resolve(effect.transform(base.value, checkCtx)).then((result) => ({
              status: status.value,
              value: result
            }));
          });
        }
      }
      util$8.assertNever(effect);
    }
  }
  ZodEffects.create = (schema, effect, params) => {
    return new ZodEffects({
      schema,
      typeName: ZodFirstPartyTypeKind.ZodEffects,
      effect,
      ...processCreateParams(params)
    });
  };
  ZodEffects.createWithPreprocess = (preprocess, schema, params) => {
    return new ZodEffects({
      schema,
      effect: { type: "preprocess", transform: preprocess },
      typeName: ZodFirstPartyTypeKind.ZodEffects,
      ...processCreateParams(params)
    });
  };
  class ZodOptional extends ZodType {
    _parse(input) {
      const parsedType = this._getType(input);
      if (parsedType === ZodParsedType.undefined) {
        return OK(void 0);
      }
      return this._def.innerType._parse(input);
    }
    unwrap() {
      return this._def.innerType;
    }
  }
  ZodOptional.create = (type2, params) => {
    return new ZodOptional({
      innerType: type2,
      typeName: ZodFirstPartyTypeKind.ZodOptional,
      ...processCreateParams(params)
    });
  };
  class ZodNullable extends ZodType {
    _parse(input) {
      const parsedType = this._getType(input);
      if (parsedType === ZodParsedType.null) {
        return OK(null);
      }
      return this._def.innerType._parse(input);
    }
    unwrap() {
      return this._def.innerType;
    }
  }
  ZodNullable.create = (type2, params) => {
    return new ZodNullable({
      innerType: type2,
      typeName: ZodFirstPartyTypeKind.ZodNullable,
      ...processCreateParams(params)
    });
  };
  class ZodDefault extends ZodType {
    _parse(input) {
      const { ctx } = this._processInputParams(input);
      let data2 = ctx.data;
      if (ctx.parsedType === ZodParsedType.undefined) {
        data2 = this._def.defaultValue();
      }
      return this._def.innerType._parse({
        data: data2,
        path: ctx.path,
        parent: ctx
      });
    }
    removeDefault() {
      return this._def.innerType;
    }
  }
  ZodDefault.create = (type2, params) => {
    return new ZodDefault({
      innerType: type2,
      typeName: ZodFirstPartyTypeKind.ZodDefault,
      defaultValue: typeof params.default === "function" ? params.default : () => params.default,
      ...processCreateParams(params)
    });
  };
  class ZodCatch extends ZodType {
    _parse(input) {
      const { ctx } = this._processInputParams(input);
      const newCtx = {
        ...ctx,
        common: {
          ...ctx.common,
          issues: []
        }
      };
      const result = this._def.innerType._parse({
        data: newCtx.data,
        path: newCtx.path,
        parent: {
          ...newCtx
        }
      });
      if (isAsync(result)) {
        return result.then((result2) => {
          return {
            status: "valid",
            value: result2.status === "valid" ? result2.value : this._def.catchValue({
              get error() {
                return new ZodError(newCtx.common.issues);
              },
              input: newCtx.data
            })
          };
        });
      } else {
        return {
          status: "valid",
          value: result.status === "valid" ? result.value : this._def.catchValue({
            get error() {
              return new ZodError(newCtx.common.issues);
            },
            input: newCtx.data
          })
        };
      }
    }
    removeCatch() {
      return this._def.innerType;
    }
  }
  ZodCatch.create = (type2, params) => {
    return new ZodCatch({
      innerType: type2,
      typeName: ZodFirstPartyTypeKind.ZodCatch,
      catchValue: typeof params.catch === "function" ? params.catch : () => params.catch,
      ...processCreateParams(params)
    });
  };
  class ZodNaN extends ZodType {
    _parse(input) {
      const parsedType = this._getType(input);
      if (parsedType !== ZodParsedType.nan) {
        const ctx = this._getOrReturnCtx(input);
        addIssueToContext(ctx, {
          code: ZodIssueCode.invalid_type,
          expected: ZodParsedType.nan,
          received: ctx.parsedType
        });
        return INVALID;
      }
      return { status: "valid", value: input.data };
    }
  }
  ZodNaN.create = (params) => {
    return new ZodNaN({
      typeName: ZodFirstPartyTypeKind.ZodNaN,
      ...processCreateParams(params)
    });
  };
  class ZodBranded extends ZodType {
    _parse(input) {
      const { ctx } = this._processInputParams(input);
      const data2 = ctx.data;
      return this._def.type._parse({
        data: data2,
        path: ctx.path,
        parent: ctx
      });
    }
    unwrap() {
      return this._def.type;
    }
  }
  class ZodPipeline extends ZodType {
    _parse(input) {
      const { status, ctx } = this._processInputParams(input);
      if (ctx.common.async) {
        const handleAsync = async () => {
          const inResult = await this._def.in._parseAsync({
            data: ctx.data,
            path: ctx.path,
            parent: ctx
          });
          if (inResult.status === "aborted")
            return INVALID;
          if (inResult.status === "dirty") {
            status.dirty();
            return DIRTY(inResult.value);
          } else {
            return this._def.out._parseAsync({
              data: inResult.value,
              path: ctx.path,
              parent: ctx
            });
          }
        };
        return handleAsync();
      } else {
        const inResult = this._def.in._parseSync({
          data: ctx.data,
          path: ctx.path,
          parent: ctx
        });
        if (inResult.status === "aborted")
          return INVALID;
        if (inResult.status === "dirty") {
          status.dirty();
          return {
            status: "dirty",
            value: inResult.value
          };
        } else {
          return this._def.out._parseSync({
            data: inResult.value,
            path: ctx.path,
            parent: ctx
          });
        }
      }
    }
    static create(a2, b2) {
      return new ZodPipeline({
        in: a2,
        out: b2,
        typeName: ZodFirstPartyTypeKind.ZodPipeline
      });
    }
  }
  class ZodReadonly extends ZodType {
    _parse(input) {
      const result = this._def.innerType._parse(input);
      const freeze = (data2) => {
        if (isValid(data2)) {
          data2.value = Object.freeze(data2.value);
        }
        return data2;
      };
      return isAsync(result) ? result.then((data2) => freeze(data2)) : freeze(result);
    }
    unwrap() {
      return this._def.innerType;
    }
  }
  ZodReadonly.create = (type2, params) => {
    return new ZodReadonly({
      innerType: type2,
      typeName: ZodFirstPartyTypeKind.ZodReadonly,
      ...processCreateParams(params)
    });
  };
  ({
    object: ZodObject.lazycreate
  });
  var ZodFirstPartyTypeKind;
  (function(ZodFirstPartyTypeKind2) {
    ZodFirstPartyTypeKind2["ZodString"] = "ZodString";
    ZodFirstPartyTypeKind2["ZodNumber"] = "ZodNumber";
    ZodFirstPartyTypeKind2["ZodNaN"] = "ZodNaN";
    ZodFirstPartyTypeKind2["ZodBigInt"] = "ZodBigInt";
    ZodFirstPartyTypeKind2["ZodBoolean"] = "ZodBoolean";
    ZodFirstPartyTypeKind2["ZodDate"] = "ZodDate";
    ZodFirstPartyTypeKind2["ZodSymbol"] = "ZodSymbol";
    ZodFirstPartyTypeKind2["ZodUndefined"] = "ZodUndefined";
    ZodFirstPartyTypeKind2["ZodNull"] = "ZodNull";
    ZodFirstPartyTypeKind2["ZodAny"] = "ZodAny";
    ZodFirstPartyTypeKind2["ZodUnknown"] = "ZodUnknown";
    ZodFirstPartyTypeKind2["ZodNever"] = "ZodNever";
    ZodFirstPartyTypeKind2["ZodVoid"] = "ZodVoid";
    ZodFirstPartyTypeKind2["ZodArray"] = "ZodArray";
    ZodFirstPartyTypeKind2["ZodObject"] = "ZodObject";
    ZodFirstPartyTypeKind2["ZodUnion"] = "ZodUnion";
    ZodFirstPartyTypeKind2["ZodDiscriminatedUnion"] = "ZodDiscriminatedUnion";
    ZodFirstPartyTypeKind2["ZodIntersection"] = "ZodIntersection";
    ZodFirstPartyTypeKind2["ZodTuple"] = "ZodTuple";
    ZodFirstPartyTypeKind2["ZodRecord"] = "ZodRecord";
    ZodFirstPartyTypeKind2["ZodMap"] = "ZodMap";
    ZodFirstPartyTypeKind2["ZodSet"] = "ZodSet";
    ZodFirstPartyTypeKind2["ZodFunction"] = "ZodFunction";
    ZodFirstPartyTypeKind2["ZodLazy"] = "ZodLazy";
    ZodFirstPartyTypeKind2["ZodLiteral"] = "ZodLiteral";
    ZodFirstPartyTypeKind2["ZodEnum"] = "ZodEnum";
    ZodFirstPartyTypeKind2["ZodEffects"] = "ZodEffects";
    ZodFirstPartyTypeKind2["ZodNativeEnum"] = "ZodNativeEnum";
    ZodFirstPartyTypeKind2["ZodOptional"] = "ZodOptional";
    ZodFirstPartyTypeKind2["ZodNullable"] = "ZodNullable";
    ZodFirstPartyTypeKind2["ZodDefault"] = "ZodDefault";
    ZodFirstPartyTypeKind2["ZodCatch"] = "ZodCatch";
    ZodFirstPartyTypeKind2["ZodPromise"] = "ZodPromise";
    ZodFirstPartyTypeKind2["ZodBranded"] = "ZodBranded";
    ZodFirstPartyTypeKind2["ZodPipeline"] = "ZodPipeline";
    ZodFirstPartyTypeKind2["ZodReadonly"] = "ZodReadonly";
  })(ZodFirstPartyTypeKind || (ZodFirstPartyTypeKind = {}));
  const stringType = ZodString.create;
  const numberType = ZodNumber.create;
  ZodNaN.create;
  ZodBigInt.create;
  const booleanType = ZodBoolean.create;
  ZodDate.create;
  ZodSymbol.create;
  ZodUndefined.create;
  ZodNull.create;
  const anyType = ZodAny.create;
  const unknownType = ZodUnknown.create;
  ZodNever.create;
  ZodVoid.create;
  const arrayType = ZodArray.create;
  const objectType = ZodObject.create;
  ZodObject.strictCreate;
  const unionType = ZodUnion.create;
  const discriminatedUnionType = ZodDiscriminatedUnion.create;
  ZodIntersection.create;
  ZodTuple.create;
  const recordType = ZodRecord.create;
  ZodMap.create;
  ZodSet.create;
  ZodLazy.create;
  const literalType = ZodLiteral.create;
  const enumType = ZodEnum.create;
  ZodNativeEnum.create;
  ZodPromise.create;
  ZodEffects.create;
  const optionalType = ZodOptional.create;
  ZodNullable.create;
  ZodEffects.createWithPreprocess;
  const LATEST_PROTOCOL_VERSION = "2024-11-05";
  const SUPPORTED_PROTOCOL_VERSIONS = [
    LATEST_PROTOCOL_VERSION,
    "2024-10-07"
  ];
  const JSONRPC_VERSION = "2.0";
  const ProgressTokenSchema = unionType([stringType(), numberType().int()]);
  const CursorSchema = stringType();
  const BaseRequestParamsSchema = objectType({
    _meta: optionalType(objectType({
      /**
       * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
       */
      progressToken: optionalType(ProgressTokenSchema)
    }).passthrough())
  }).passthrough();
  const RequestSchema = objectType({
    method: stringType(),
    params: optionalType(BaseRequestParamsSchema)
  });
  const BaseNotificationParamsSchema = objectType({
    /**
     * This parameter name is reserved by MCP to allow clients and servers to attach additional metadata to their notifications.
     */
    _meta: optionalType(objectType({}).passthrough())
  }).passthrough();
  const NotificationSchema = objectType({
    method: stringType(),
    params: optionalType(BaseNotificationParamsSchema)
  });
  const ResultSchema = objectType({
    /**
     * This result property is reserved by the protocol to allow clients and servers to attach additional metadata to their responses.
     */
    _meta: optionalType(objectType({}).passthrough())
  }).passthrough();
  const RequestIdSchema = unionType([stringType(), numberType().int()]);
  const JSONRPCRequestSchema = objectType({
    jsonrpc: literalType(JSONRPC_VERSION),
    id: RequestIdSchema
  }).merge(RequestSchema).strict();
  const JSONRPCNotificationSchema = objectType({
    jsonrpc: literalType(JSONRPC_VERSION)
  }).merge(NotificationSchema).strict();
  const JSONRPCResponseSchema = objectType({
    jsonrpc: literalType(JSONRPC_VERSION),
    id: RequestIdSchema,
    result: ResultSchema
  }).strict();
  var ErrorCode;
  (function(ErrorCode2) {
    ErrorCode2[ErrorCode2["ConnectionClosed"] = -32e3] = "ConnectionClosed";
    ErrorCode2[ErrorCode2["RequestTimeout"] = -32001] = "RequestTimeout";
    ErrorCode2[ErrorCode2["ParseError"] = -32700] = "ParseError";
    ErrorCode2[ErrorCode2["InvalidRequest"] = -32600] = "InvalidRequest";
    ErrorCode2[ErrorCode2["MethodNotFound"] = -32601] = "MethodNotFound";
    ErrorCode2[ErrorCode2["InvalidParams"] = -32602] = "InvalidParams";
    ErrorCode2[ErrorCode2["InternalError"] = -32603] = "InternalError";
  })(ErrorCode || (ErrorCode = {}));
  const JSONRPCErrorSchema = objectType({
    jsonrpc: literalType(JSONRPC_VERSION),
    id: RequestIdSchema,
    error: objectType({
      /**
       * The error type that occurred.
       */
      code: numberType().int(),
      /**
       * A short description of the error. The message SHOULD be limited to a concise single sentence.
       */
      message: stringType(),
      /**
       * Additional information about the error. The value of this member is defined by the sender (e.g. detailed error information, nested errors etc.).
       */
      data: optionalType(unknownType())
    })
  }).strict();
  const JSONRPCMessageSchema = unionType([
    JSONRPCRequestSchema,
    JSONRPCNotificationSchema,
    JSONRPCResponseSchema,
    JSONRPCErrorSchema
  ]);
  const EmptyResultSchema = ResultSchema.strict();
  const CancelledNotificationSchema = NotificationSchema.extend({
    method: literalType("notifications/cancelled"),
    params: BaseNotificationParamsSchema.extend({
      /**
       * The ID of the request to cancel.
       *
       * This MUST correspond to the ID of a request previously issued in the same direction.
       */
      requestId: RequestIdSchema,
      /**
       * An optional string describing the reason for the cancellation. This MAY be logged or presented to the user.
       */
      reason: stringType().optional()
    })
  });
  const ImplementationSchema = objectType({
    name: stringType(),
    version: stringType()
  }).passthrough();
  const ClientCapabilitiesSchema = objectType({
    /**
     * Experimental, non-standard capabilities that the client supports.
     */
    experimental: optionalType(objectType({}).passthrough()),
    /**
     * Present if the client supports sampling from an LLM.
     */
    sampling: optionalType(objectType({}).passthrough()),
    /**
     * Present if the client supports listing roots.
     */
    roots: optionalType(objectType({
      /**
       * Whether the client supports issuing notifications for changes to the roots list.
       */
      listChanged: optionalType(booleanType())
    }).passthrough())
  }).passthrough();
  const InitializeRequestSchema = RequestSchema.extend({
    method: literalType("initialize"),
    params: BaseRequestParamsSchema.extend({
      /**
       * The latest version of the Model Context Protocol that the client supports. The client MAY decide to support older versions as well.
       */
      protocolVersion: stringType(),
      capabilities: ClientCapabilitiesSchema,
      clientInfo: ImplementationSchema
    })
  });
  const ServerCapabilitiesSchema = objectType({
    /**
     * Experimental, non-standard capabilities that the server supports.
     */
    experimental: optionalType(objectType({}).passthrough()),
    /**
     * Present if the server supports sending log messages to the client.
     */
    logging: optionalType(objectType({}).passthrough()),
    /**
     * Present if the server offers any prompt templates.
     */
    prompts: optionalType(objectType({
      /**
       * Whether this server supports issuing notifications for changes to the prompt list.
       */
      listChanged: optionalType(booleanType())
    }).passthrough()),
    /**
     * Present if the server offers any resources to read.
     */
    resources: optionalType(objectType({
      /**
       * Whether this server supports clients subscribing to resource updates.
       */
      subscribe: optionalType(booleanType()),
      /**
       * Whether this server supports issuing notifications for changes to the resource list.
       */
      listChanged: optionalType(booleanType())
    }).passthrough()),
    /**
     * Present if the server offers any tools to call.
     */
    tools: optionalType(objectType({
      /**
       * Whether this server supports issuing notifications for changes to the tool list.
       */
      listChanged: optionalType(booleanType())
    }).passthrough())
  }).passthrough();
  const InitializeResultSchema = ResultSchema.extend({
    /**
     * The version of the Model Context Protocol that the server wants to use. This may not match the version that the client requested. If the client cannot support this version, it MUST disconnect.
     */
    protocolVersion: stringType(),
    capabilities: ServerCapabilitiesSchema,
    serverInfo: ImplementationSchema,
    /**
     * Instructions describing how to use the server and its features.
     *
     * This can be used by clients to improve the LLM's understanding of available tools, resources, etc. It can be thought of like a "hint" to the model. For example, this information MAY be added to the system prompt.
     */
    instructions: optionalType(stringType())
  });
  const InitializedNotificationSchema = NotificationSchema.extend({
    method: literalType("notifications/initialized")
  });
  const PingRequestSchema = RequestSchema.extend({
    method: literalType("ping")
  });
  const ProgressSchema = objectType({
    /**
     * The progress thus far. This should increase every time progress is made, even if the total is unknown.
     */
    progress: numberType(),
    /**
     * Total number of items to process (or total progress required), if known.
     */
    total: optionalType(numberType())
  }).passthrough();
  const ProgressNotificationSchema = NotificationSchema.extend({
    method: literalType("notifications/progress"),
    params: BaseNotificationParamsSchema.merge(ProgressSchema).extend({
      /**
       * The progress token which was given in the initial request, used to associate this notification with the request that is proceeding.
       */
      progressToken: ProgressTokenSchema
    })
  });
  const PaginatedRequestSchema = RequestSchema.extend({
    params: BaseRequestParamsSchema.extend({
      /**
       * An opaque token representing the current pagination position.
       * If provided, the server should return results starting after this cursor.
       */
      cursor: optionalType(CursorSchema)
    }).optional()
  });
  const PaginatedResultSchema = ResultSchema.extend({
    /**
     * An opaque token representing the pagination position after the last returned result.
     * If present, there may be more results available.
     */
    nextCursor: optionalType(CursorSchema)
  });
  const ResourceContentsSchema = objectType({
    /**
     * The URI of this resource.
     */
    uri: stringType(),
    /**
     * The MIME type of this resource, if known.
     */
    mimeType: optionalType(stringType())
  }).passthrough();
  const TextResourceContentsSchema = ResourceContentsSchema.extend({
    /**
     * The text of the item. This must only be set if the item can actually be represented as text (not binary data).
     */
    text: stringType()
  });
  const BlobResourceContentsSchema = ResourceContentsSchema.extend({
    /**
     * A base64-encoded string representing the binary data of the item.
     */
    blob: stringType().base64()
  });
  const ResourceSchema = objectType({
    /**
     * The URI of this resource.
     */
    uri: stringType(),
    /**
     * A human-readable name for this resource.
     *
     * This can be used by clients to populate UI elements.
     */
    name: stringType(),
    /**
     * A description of what this resource represents.
     *
     * This can be used by clients to improve the LLM's understanding of available resources. It can be thought of like a "hint" to the model.
     */
    description: optionalType(stringType()),
    /**
     * The MIME type of this resource, if known.
     */
    mimeType: optionalType(stringType())
  }).passthrough();
  const ResourceTemplateSchema = objectType({
    /**
     * A URI template (according to RFC 6570) that can be used to construct resource URIs.
     */
    uriTemplate: stringType(),
    /**
     * A human-readable name for the type of resource this template refers to.
     *
     * This can be used by clients to populate UI elements.
     */
    name: stringType(),
    /**
     * A description of what this template is for.
     *
     * This can be used by clients to improve the LLM's understanding of available resources. It can be thought of like a "hint" to the model.
     */
    description: optionalType(stringType()),
    /**
     * The MIME type for all resources that match this template. This should only be included if all resources matching this template have the same type.
     */
    mimeType: optionalType(stringType())
  }).passthrough();
  const ListResourcesRequestSchema = PaginatedRequestSchema.extend({
    method: literalType("resources/list")
  });
  const ListResourcesResultSchema = PaginatedResultSchema.extend({
    resources: arrayType(ResourceSchema)
  });
  const ListResourceTemplatesRequestSchema = PaginatedRequestSchema.extend({
    method: literalType("resources/templates/list")
  });
  const ListResourceTemplatesResultSchema = PaginatedResultSchema.extend({
    resourceTemplates: arrayType(ResourceTemplateSchema)
  });
  const ReadResourceRequestSchema = RequestSchema.extend({
    method: literalType("resources/read"),
    params: BaseRequestParamsSchema.extend({
      /**
       * The URI of the resource to read. The URI can use any protocol; it is up to the server how to interpret it.
       */
      uri: stringType()
    })
  });
  const ReadResourceResultSchema = ResultSchema.extend({
    contents: arrayType(unionType([TextResourceContentsSchema, BlobResourceContentsSchema]))
  });
  const ResourceListChangedNotificationSchema = NotificationSchema.extend({
    method: literalType("notifications/resources/list_changed")
  });
  const SubscribeRequestSchema = RequestSchema.extend({
    method: literalType("resources/subscribe"),
    params: BaseRequestParamsSchema.extend({
      /**
       * The URI of the resource to subscribe to. The URI can use any protocol; it is up to the server how to interpret it.
       */
      uri: stringType()
    })
  });
  const UnsubscribeRequestSchema = RequestSchema.extend({
    method: literalType("resources/unsubscribe"),
    params: BaseRequestParamsSchema.extend({
      /**
       * The URI of the resource to unsubscribe from.
       */
      uri: stringType()
    })
  });
  const ResourceUpdatedNotificationSchema = NotificationSchema.extend({
    method: literalType("notifications/resources/updated"),
    params: BaseNotificationParamsSchema.extend({
      /**
       * The URI of the resource that has been updated. This might be a sub-resource of the one that the client actually subscribed to.
       */
      uri: stringType()
    })
  });
  const PromptArgumentSchema = objectType({
    /**
     * The name of the argument.
     */
    name: stringType(),
    /**
     * A human-readable description of the argument.
     */
    description: optionalType(stringType()),
    /**
     * Whether this argument must be provided.
     */
    required: optionalType(booleanType())
  }).passthrough();
  const PromptSchema = objectType({
    /**
     * The name of the prompt or prompt template.
     */
    name: stringType(),
    /**
     * An optional description of what this prompt provides
     */
    description: optionalType(stringType()),
    /**
     * A list of arguments to use for templating the prompt.
     */
    arguments: optionalType(arrayType(PromptArgumentSchema))
  }).passthrough();
  const ListPromptsRequestSchema = PaginatedRequestSchema.extend({
    method: literalType("prompts/list")
  });
  const ListPromptsResultSchema = PaginatedResultSchema.extend({
    prompts: arrayType(PromptSchema)
  });
  const GetPromptRequestSchema = RequestSchema.extend({
    method: literalType("prompts/get"),
    params: BaseRequestParamsSchema.extend({
      /**
       * The name of the prompt or prompt template.
       */
      name: stringType(),
      /**
       * Arguments to use for templating the prompt.
       */
      arguments: optionalType(recordType(stringType()))
    })
  });
  const TextContentSchema = objectType({
    type: literalType("text"),
    /**
     * The text content of the message.
     */
    text: stringType()
  }).passthrough();
  const ImageContentSchema = objectType({
    type: literalType("image"),
    /**
     * The base64-encoded image data.
     */
    data: stringType().base64(),
    /**
     * The MIME type of the image. Different providers may support different image types.
     */
    mimeType: stringType()
  }).passthrough();
  const EmbeddedResourceSchema = objectType({
    type: literalType("resource"),
    resource: unionType([TextResourceContentsSchema, BlobResourceContentsSchema])
  }).passthrough();
  const PromptMessageSchema = objectType({
    role: enumType(["user", "assistant"]),
    content: unionType([
      TextContentSchema,
      ImageContentSchema,
      EmbeddedResourceSchema
    ])
  }).passthrough();
  const GetPromptResultSchema = ResultSchema.extend({
    /**
     * An optional description for the prompt.
     */
    description: optionalType(stringType()),
    messages: arrayType(PromptMessageSchema)
  });
  const PromptListChangedNotificationSchema = NotificationSchema.extend({
    method: literalType("notifications/prompts/list_changed")
  });
  const ToolSchema = objectType({
    /**
     * The name of the tool.
     */
    name: stringType(),
    /**
     * A human-readable description of the tool.
     */
    description: optionalType(stringType()),
    /**
     * A JSON Schema object defining the expected parameters for the tool.
     */
    inputSchema: objectType({
      type: literalType("object"),
      properties: optionalType(objectType({}).passthrough())
    }).passthrough()
  }).passthrough();
  const ListToolsRequestSchema = PaginatedRequestSchema.extend({
    method: literalType("tools/list")
  });
  const ListToolsResultSchema = PaginatedResultSchema.extend({
    tools: arrayType(ToolSchema)
  });
  const CallToolResultSchema = ResultSchema.extend({
    content: arrayType(unionType([TextContentSchema, ImageContentSchema, EmbeddedResourceSchema])),
    isError: booleanType().default(false).optional()
  });
  CallToolResultSchema.or(ResultSchema.extend({
    toolResult: unknownType()
  }));
  const CallToolRequestSchema = RequestSchema.extend({
    method: literalType("tools/call"),
    params: BaseRequestParamsSchema.extend({
      name: stringType(),
      arguments: optionalType(recordType(unknownType()))
    })
  });
  const ToolListChangedNotificationSchema = NotificationSchema.extend({
    method: literalType("notifications/tools/list_changed")
  });
  const LoggingLevelSchema = enumType([
    "debug",
    "info",
    "notice",
    "warning",
    "error",
    "critical",
    "alert",
    "emergency"
  ]);
  const SetLevelRequestSchema = RequestSchema.extend({
    method: literalType("logging/setLevel"),
    params: BaseRequestParamsSchema.extend({
      /**
       * The level of logging that the client wants to receive from the server. The server should send all logs at this level and higher (i.e., more severe) to the client as notifications/logging/message.
       */
      level: LoggingLevelSchema
    })
  });
  const LoggingMessageNotificationSchema = NotificationSchema.extend({
    method: literalType("notifications/message"),
    params: BaseNotificationParamsSchema.extend({
      /**
       * The severity of this log message.
       */
      level: LoggingLevelSchema,
      /**
       * An optional name of the logger issuing this message.
       */
      logger: optionalType(stringType()),
      /**
       * The data to be logged, such as a string message or an object. Any JSON serializable type is allowed here.
       */
      data: unknownType()
    })
  });
  const ModelHintSchema = objectType({
    /**
     * A hint for a model name.
     */
    name: stringType().optional()
  }).passthrough();
  const ModelPreferencesSchema = objectType({
    /**
     * Optional hints to use for model selection.
     */
    hints: optionalType(arrayType(ModelHintSchema)),
    /**
     * How much to prioritize cost when selecting a model.
     */
    costPriority: optionalType(numberType().min(0).max(1)),
    /**
     * How much to prioritize sampling speed (latency) when selecting a model.
     */
    speedPriority: optionalType(numberType().min(0).max(1)),
    /**
     * How much to prioritize intelligence and capabilities when selecting a model.
     */
    intelligencePriority: optionalType(numberType().min(0).max(1))
  }).passthrough();
  const SamplingMessageSchema = objectType({
    role: enumType(["user", "assistant"]),
    content: unionType([TextContentSchema, ImageContentSchema])
  }).passthrough();
  const CreateMessageRequestSchema = RequestSchema.extend({
    method: literalType("sampling/createMessage"),
    params: BaseRequestParamsSchema.extend({
      messages: arrayType(SamplingMessageSchema),
      /**
       * An optional system prompt the server wants to use for sampling. The client MAY modify or omit this prompt.
       */
      systemPrompt: optionalType(stringType()),
      /**
       * A request to include context from one or more MCP servers (including the caller), to be attached to the prompt. The client MAY ignore this request.
       */
      includeContext: optionalType(enumType(["none", "thisServer", "allServers"])),
      temperature: optionalType(numberType()),
      /**
       * The maximum number of tokens to sample, as requested by the server. The client MAY choose to sample fewer tokens than requested.
       */
      maxTokens: numberType().int(),
      stopSequences: optionalType(arrayType(stringType())),
      /**
       * Optional metadata to pass through to the LLM provider. The format of this metadata is provider-specific.
       */
      metadata: optionalType(objectType({}).passthrough()),
      /**
       * The server's preferences for which model to select.
       */
      modelPreferences: optionalType(ModelPreferencesSchema)
    })
  });
  const CreateMessageResultSchema = ResultSchema.extend({
    /**
     * The name of the model that generated the message.
     */
    model: stringType(),
    /**
     * The reason why sampling stopped.
     */
    stopReason: optionalType(enumType(["endTurn", "stopSequence", "maxTokens"]).or(stringType())),
    role: enumType(["user", "assistant"]),
    content: discriminatedUnionType("type", [
      TextContentSchema,
      ImageContentSchema
    ])
  });
  const ResourceReferenceSchema = objectType({
    type: literalType("ref/resource"),
    /**
     * The URI or URI template of the resource.
     */
    uri: stringType()
  }).passthrough();
  const PromptReferenceSchema = objectType({
    type: literalType("ref/prompt"),
    /**
     * The name of the prompt or prompt template
     */
    name: stringType()
  }).passthrough();
  const CompleteRequestSchema = RequestSchema.extend({
    method: literalType("completion/complete"),
    params: BaseRequestParamsSchema.extend({
      ref: unionType([PromptReferenceSchema, ResourceReferenceSchema]),
      /**
       * The argument's information
       */
      argument: objectType({
        /**
         * The name of the argument
         */
        name: stringType(),
        /**
         * The value of the argument to use for completion matching.
         */
        value: stringType()
      }).passthrough()
    })
  });
  const CompleteResultSchema = ResultSchema.extend({
    completion: objectType({
      /**
       * An array of completion values. Must not exceed 100 items.
       */
      values: arrayType(stringType()).max(100),
      /**
       * The total number of completion options available. This can exceed the number of values actually sent in the response.
       */
      total: optionalType(numberType().int()),
      /**
       * Indicates whether there are additional completion options beyond those provided in the current response, even if the exact total is unknown.
       */
      hasMore: optionalType(booleanType())
    }).passthrough()
  });
  const RootSchema = objectType({
    /**
     * The URI identifying the root. This *must* start with file:// for now.
     */
    uri: stringType().startsWith("file://"),
    /**
     * An optional name for the root.
     */
    name: optionalType(stringType())
  }).passthrough();
  const ListRootsRequestSchema = RequestSchema.extend({
    method: literalType("roots/list")
  });
  const ListRootsResultSchema = ResultSchema.extend({
    roots: arrayType(RootSchema)
  });
  const RootsListChangedNotificationSchema = NotificationSchema.extend({
    method: literalType("notifications/roots/list_changed")
  });
  unionType([
    PingRequestSchema,
    InitializeRequestSchema,
    CompleteRequestSchema,
    SetLevelRequestSchema,
    GetPromptRequestSchema,
    ListPromptsRequestSchema,
    ListResourcesRequestSchema,
    ListResourceTemplatesRequestSchema,
    ReadResourceRequestSchema,
    SubscribeRequestSchema,
    UnsubscribeRequestSchema,
    CallToolRequestSchema,
    ListToolsRequestSchema
  ]);
  unionType([
    CancelledNotificationSchema,
    ProgressNotificationSchema,
    InitializedNotificationSchema,
    RootsListChangedNotificationSchema
  ]);
  unionType([
    EmptyResultSchema,
    CreateMessageResultSchema,
    ListRootsResultSchema
  ]);
  unionType([
    PingRequestSchema,
    CreateMessageRequestSchema,
    ListRootsRequestSchema
  ]);
  unionType([
    CancelledNotificationSchema,
    ProgressNotificationSchema,
    LoggingMessageNotificationSchema,
    ResourceUpdatedNotificationSchema,
    ResourceListChangedNotificationSchema,
    ToolListChangedNotificationSchema,
    PromptListChangedNotificationSchema
  ]);
  unionType([
    EmptyResultSchema,
    InitializeResultSchema,
    CompleteResultSchema,
    GetPromptResultSchema,
    ListPromptsResultSchema,
    ListResourcesResultSchema,
    ListResourceTemplatesResultSchema,
    ReadResourceResultSchema,
    CallToolResultSchema,
    ListToolsResultSchema
  ]);
  class McpError extends Error {
    constructor(code, message2, data2) {
      super(`MCP error ${code}: ${message2}`);
      this.code = code;
      this.data = data2;
      this.name = "McpError";
    }
  }
  const DEFAULT_REQUEST_TIMEOUT_MSEC = 6e4;
  class Protocol {
    constructor(_options) {
      this._options = _options;
      this._requestMessageId = 0;
      this._requestHandlers = /* @__PURE__ */ new Map();
      this._requestHandlerAbortControllers = /* @__PURE__ */ new Map();
      this._notificationHandlers = /* @__PURE__ */ new Map();
      this._responseHandlers = /* @__PURE__ */ new Map();
      this._progressHandlers = /* @__PURE__ */ new Map();
      this._timeoutInfo = /* @__PURE__ */ new Map();
      this.setNotificationHandler(CancelledNotificationSchema, (notification) => {
        const controller = this._requestHandlerAbortControllers.get(notification.params.requestId);
        controller === null || controller === void 0 ? void 0 : controller.abort(notification.params.reason);
      });
      this.setNotificationHandler(ProgressNotificationSchema, (notification) => {
        this._onprogress(notification);
      });
      this.setRequestHandler(
        PingRequestSchema,
        // Automatic pong by default.
        (_request) => ({})
      );
    }
    _setupTimeout(messageId, timeout, maxTotalTimeout, onTimeout) {
      this._timeoutInfo.set(messageId, {
        timeoutId: setTimeout(onTimeout, timeout),
        startTime: Date.now(),
        timeout,
        maxTotalTimeout,
        onTimeout
      });
    }
    _resetTimeout(messageId) {
      const info2 = this._timeoutInfo.get(messageId);
      if (!info2)
        return false;
      const totalElapsed = Date.now() - info2.startTime;
      if (info2.maxTotalTimeout && totalElapsed >= info2.maxTotalTimeout) {
        this._timeoutInfo.delete(messageId);
        throw new McpError(ErrorCode.RequestTimeout, "Maximum total timeout exceeded", { maxTotalTimeout: info2.maxTotalTimeout, totalElapsed });
      }
      clearTimeout(info2.timeoutId);
      info2.timeoutId = setTimeout(info2.onTimeout, info2.timeout);
      return true;
    }
    _cleanupTimeout(messageId) {
      const info2 = this._timeoutInfo.get(messageId);
      if (info2) {
        clearTimeout(info2.timeoutId);
        this._timeoutInfo.delete(messageId);
      }
    }
    /**
     * Attaches to the given transport, starts it, and starts listening for messages.
     *
     * The Protocol object assumes ownership of the Transport, replacing any callbacks that have already been set, and expects that it is the only user of the Transport instance going forward.
     */
    async connect(transport) {
      this._transport = transport;
      this._transport.onclose = () => {
        this._onclose();
      };
      this._transport.onerror = (error2) => {
        this._onerror(error2);
      };
      this._transport.onmessage = (message2) => {
        if (!("method" in message2)) {
          this._onresponse(message2);
        } else if ("id" in message2) {
          this._onrequest(message2);
        } else {
          this._onnotification(message2);
        }
      };
      await this._transport.start();
    }
    _onclose() {
      var _a3;
      const responseHandlers = this._responseHandlers;
      this._responseHandlers = /* @__PURE__ */ new Map();
      this._progressHandlers.clear();
      this._transport = void 0;
      (_a3 = this.onclose) === null || _a3 === void 0 ? void 0 : _a3.call(this);
      const error2 = new McpError(ErrorCode.ConnectionClosed, "Connection closed");
      for (const handler of responseHandlers.values()) {
        handler(error2);
      }
    }
    _onerror(error2) {
      var _a3;
      (_a3 = this.onerror) === null || _a3 === void 0 ? void 0 : _a3.call(this, error2);
    }
    _onnotification(notification) {
      var _a3;
      const handler = (_a3 = this._notificationHandlers.get(notification.method)) !== null && _a3 !== void 0 ? _a3 : this.fallbackNotificationHandler;
      if (handler === void 0) {
        return;
      }
      Promise.resolve().then(() => handler(notification)).catch((error2) => this._onerror(new Error(`Uncaught error in notification handler: ${error2}`)));
    }
    _onrequest(request) {
      var _a3, _b2, _c2;
      const handler = (_a3 = this._requestHandlers.get(request.method)) !== null && _a3 !== void 0 ? _a3 : t