(function polyfill() {
  const relList = document.createElement("link").relList;
  if (relList && relList.supports && relList.supports("modulepreload")) {
    return;
  }
  for (const link of document.querySelectorAll('link[rel="modulepreload"]')) {
    processPreload(link);
  }
  new MutationObserver((mutations) => {
    for (const mutation of mutations) {
      if (mutation.type !== "childList") {
        continue;
      }
      for (const node of mutation.addedNodes) {
        if (node.tagName === "LINK" && node.rel === "modulepreload")
          processPreload(node);
      }
    }
  }).observe(document, { childList: true, subtree: true });
  function getFetchOpts(link) {
    const fetchOpts = {};
    if (link.integrity) fetchOpts.integrity = link.integrity;
    if (link.referrerPolicy) fetchOpts.referrerPolicy = link.referrerPolicy;
    if (link.crossOrigin === "use-credentials")
      fetchOpts.credentials = "include";
    else if (link.crossOrigin === "anonymous") fetchOpts.credentials = "omit";
    else fetchOpts.credentials = "same-origin";
    return fetchOpts;
  }
  function processPreload(link) {
    if (link.ep)
      return;
    link.ep = true;
    const fetchOpts = getFetchOpts(link);
    fetch(link.href, fetchOpts);
  }
})();
const FIND_IN_PAGE_API_NAME = "findAPI";
const api = window[FIND_IN_PAGE_API_NAME];
function updateState(elements, result) {
  if (result === null) {
    elements.countLabel.innerText = "";
    elements.next.classList.add("disabled");
    elements.prev.classList.add("disabled");
    return;
  }
  elements.countLabel.innerText = `${result.activeMatchOrdinal}/${result.matches}`;
  if (result.matches === 0) {
    elements.next.classList.add("disabled");
    elements.prev.classList.add("disabled");
  } else {
    elements.next.classList.remove("disabled");
    elements.prev.classList.remove("disabled");
  }
}
function setupPageFind() {
  const pageElements = {
    input: document.getElementById("find-input"),
    countLabel: document.getElementById("find-count"),
    next: document.getElementById("find-next-button"),
    prev: document.getElementById("find-prev-button"),
    close: document.getElementById("find-close-button")
  };
  pageElements.close.addEventListener("click", () => {
    api.closeFindInPage();
  });
  pageElements.next.addEventListener("click", () => {
    api.findInPage({
      searchText: pageElements.input.value,
      forward: true,
      findNext: false
    });
  });
  pageElements.prev.addEventListener("click", () => {
    api.findInPage({
      searchText: pageElements.input.value,
      forward: false,
      findNext: false
    });
  });
  api.onFoundInPage((result) => {
    updateState(pageElements, result);
  });
  pageElements.input.addEventListener("input", () => {
    const value = pageElements.input.value;
    if (value === "") {
      updateState(pageElements, null);
      api.stopFindInPage();
    } else {
      window[FIND_IN_PAGE_API_NAME].findInPage({
        searchText: value,
        forward: true,
        findNext: true
      });
    }
  });
  pageElements.input.addEventListener("keydown", (event) => {
    if (!pageElements.input.value) return;
    if (event.key === "Enter") {
      api.findInPage({
        searchText: pageElements.input.value,
        forward: !event.shiftKey,
        findNext: false
      });
    }
  });
}
setupPageFind();
