"use strict";
var FindInPageIPCEvent = /* @__PURE__ */ ((FindInPageIPCEvent2) => {
  FindInPageIPCEvent2["FindInPage"] = "find-in-page";
  FindInPageIPCEvent2["StopFindInPage"] = "stop-find-in-page";
  FindInPageIPCEvent2["CloseFindInPage"] = "close-find-in-page";
  FindInPageIPCEvent2["FindInPageResult"] = "find-in-page-result";
  return FindInPageIPCEvent2;
})(FindInPageIPCEvent || {});
const FIND_IN_PAGE_API_NAME = "findAPI";
const { contextBridge, ipcRenderer } = require("electron");
contextBridge.exposeInMainWorld(FIND_IN_PAGE_API_NAME, {
  findInPage: (params) => ipcRenderer.invoke(FindInPageIPCEvent.FindInPage, params),
  closeFindInPage: () => ipcRenderer.invoke(FindInPageIPCEvent.CloseFindInPage),
  stopFindInPage: () => ipcRenderer.invoke(FindInPageIPCEvent.StopFindInPage),
  onFoundInPage: (callback) => {
    const callbackWrapper = (event, result) => callback(result);
    ipcRenderer.on(FindInPageIPCEvent.FindInPageResult, callbackWrapper);
    return () => ipcRenderer.off(FindInPageIPCEvent.FindInPageResult, callbackWrapper);
  }
});
