(function(global2, factory) {
  typeof exports === "object" && typeof module !== "undefined" ? factory(require("electron")) : typeof define === "function" && define.amd ? define(["electron"], factory) : (global2 = typeof globalThis !== "undefined" ? globalThis : global2 || self, factory(global2.electron));
})(this, function(electron) {
  "use strict";;
!function() {
  try {
    var e = "undefined" != typeof window ? window : "undefined" != typeof global ? global : "undefined" != typeof self ? self : {}, n = new e.Error().stack;
    n && (e._sentryDebugIds = e._sentryDebugIds || {}, e._sentryDebugIds[n] = "37c41627-5f3a-4415-8e9c-1d662a20cacc", e._sentryDebugIdIdentifier = "sentry-dbid-37c41627-5f3a-4415-8e9c-1d662a20cacc");
  } catch (e2) {
  }
}();

  var IPCMode;
  (function(IPCMode2) {
    IPCMode2[IPCMode2["Classic"] = 1] = "Classic";
    IPCMode2[IPCMode2["Protocol"] = 2] = "Protocol";
    IPCMode2[IPCMode2["Both"] = 3] = "Both";
  })(IPCMode || (IPCMode = {}));
  var IPCChannel;
  (function(IPCChannel2) {
    IPCChannel2["RENDERER_START"] = "sentry-electron.renderer-start";
    IPCChannel2["EVENT"] = "sentry-electron.event";
    IPCChannel2["SCOPE"] = "sentry-electron.scope";
    IPCChannel2["ENVELOPE"] = "sentry-electron.envelope";
    IPCChannel2["STATUS"] = "sentry-electron.status";
    IPCChannel2["ADD_METRIC"] = "sentry-electron.add-metric";
  })(IPCChannel || (IPCChannel = {}));
  if (window.__SENTRY_IPC__) {
    console.log("Sentry Electron preload has already been run");
  } else {
    const ipcObject = {
      sendRendererStart: () => electron.ipcRenderer.send(IPCChannel.RENDERER_START),
      sendScope: (scopeJson) => electron.ipcRenderer.send(IPCChannel.SCOPE, scopeJson),
      sendEvent: (eventJson) => electron.ipcRenderer.send(IPCChannel.EVENT, eventJson),
      sendEnvelope: (envelope) => electron.ipcRenderer.send(IPCChannel.ENVELOPE, envelope),
      sendStatus: (status) => electron.ipcRenderer.send(IPCChannel.STATUS, status),
      sendAddMetric: (metric) => electron.ipcRenderer.send(IPCChannel.ADD_METRIC, metric)
    };
    window.__SENTRY_IPC__ = ipcObject;
    if (electron.contextBridge) {
      try {
        electron.contextBridge.exposeInMainWorld("__SENTRY_IPC__", ipcObject);
      } catch (e) {
      }
    }
  }
  var _global = typeof window !== "undefined" ? window : typeof global !== "undefined" ? global : typeof self !== "undefined" ? self : {};
  _global.SENTRY_RELEASE = { id: "403cd70f263b170d32852f34f42da5c9f586b9c7" };
  const INJECTED_DESKTOP_APP_BRIDGE_KEY = "INJECTED_DESKTOP_APP_BRIDGE";
  const appClientName = "Desktop Kauai";
  const protocolVersion = 53;
  var IPCEvent = /* @__PURE__ */ ((IPCEvent2) => {
    IPCEvent2["SetAsDefaultMailApp"] = "set-as-default-mail-app";
    IPCEvent2["SetDebugMode"] = "set-debug-mode";
    IPCEvent2["RestartAndUpdate"] = "restart-and-update";
    IPCEvent2["SetSentryUserId"] = "set-sentry-user-id";
    IPCEvent2["GetAppVersion"] = "get-app-version";
    IPCEvent2["Print"] = "print";
    IPCEvent2["OpenSystemNotificationSettings"] = "open-system-notification-settings";
    IPCEvent2["ClearNotificationsForAccount"] = "clear-notifications-for-account";
    IPCEvent2["CallMcpTool"] = "call-mcp-tool";
    IPCEvent2["UpdateMcpConfig"] = "update-mcp-config";
    IPCEvent2["PushNotification"] = "push-notification";
    IPCEvent2["PushToken"] = "push-token";
    IPCEvent2["Mailto"] = "mailto";
    IPCEvent2["UpdateAvailable"] = "update-available";
    IPCEvent2["OauthToken"] = "oauth-token";
    IPCEvent2["OpenAppLink"] = "open-app-link";
    IPCEvent2["McpConfigUpdate"] = "mcp-config-update";
    return IPCEvent2;
  })(IPCEvent || {});
  const { contextBridge, ipcRenderer } = require("electron");
  const desktopAppBridge = {
    config: {
      clientName: appClientName,
      protocolVersion
    },
    // TODO(desktop-app): Make these calls typed
    async setAsDefaultMailApp() {
      return await ipcRenderer.invoke(IPCEvent.SetAsDefaultMailApp);
    },
    async setDebugMode(isDebugModeEnabled) {
      await ipcRenderer.invoke(IPCEvent.SetDebugMode, isDebugModeEnabled);
    },
    async restartAndUpdate() {
      await ipcRenderer.invoke(IPCEvent.RestartAndUpdate);
    },
    async setSentryUser(user) {
      await ipcRenderer.invoke(IPCEvent.SetSentryUserId, user);
    },
    async getAppVersion() {
      return await ipcRenderer.invoke(IPCEvent.GetAppVersion);
    },
    async print(title) {
      await ipcRenderer.invoke(IPCEvent.Print, title);
    },
    async openSystemNotificationSettings() {
      await ipcRenderer.invoke(IPCEvent.OpenSystemNotificationSettings);
    },
    clearNotificationsForAccount(accountId) {
      ipcRenderer.invoke(IPCEvent.ClearNotificationsForAccount, accountId);
    },
    async updateMcpConfig(update) {
      await ipcRenderer.invoke(IPCEvent.UpdateMcpConfig, update);
    },
    async callMcpTool(params) {
      return await ipcRenderer.invoke(IPCEvent.CallMcpTool, params);
    },
    handleUpdateAvailable: makeHandler(IPCEvent.UpdateAvailable, true),
    handlePushNotification: makeHandler(IPCEvent.PushNotification),
    handlePushToken: makeHandler(IPCEvent.PushToken, true),
    handleMailto: makeHandler(IPCEvent.Mailto),
    handleOauthToken: makeHandler(IPCEvent.OauthToken),
    handleOpenAppLink: makeHandler(IPCEvent.OpenAppLink),
    handleMcpConfigUpdate: makeHandler(IPCEvent.McpConfigUpdate, true)
  };
  function callHandler(handler, args) {
    handler(...args);
  }
  function makeHandler(event, idempotent = false) {
    let queue = [];
    let latestArgs = null;
    const handlers = /* @__PURE__ */ new Set();
    const listener = (_event, ...args) => {
      if (idempotent) {
        latestArgs = { event, args };
      }
      if (handlers.size === 0) {
        if (!idempotent) {
          queue.push({ event, args });
        }
      } else {
        for (const handler of handlers) {
          callHandler(handler, args);
        }
      }
    };
    ipcRenderer.on(event, listener);
    return (handler) => {
      if (idempotent) {
        if (latestArgs) {
          callHandler(handler, latestArgs.args);
        }
      } else {
        for (const { args } of queue) {
          callHandler(handler, args);
        }
        queue = [];
      }
      handlers.add(handler);
      return () => handlers.delete(handler);
    };
  }
  contextBridge.exposeInMainWorld(INJECTED_DESKTOP_APP_BRIDGE_KEY, desktopAppBridge);
});
//# sourceMappingURL=preload.js.map
