/*
 * Decompiled with CFR 0.152.
 */
package de.corneliusmay.silkspawners.plugin;

import de.corneliusmay.silkspawners.api.NMS;
import de.corneliusmay.silkspawners.plugin.bukkit.Metrics;
import de.corneliusmay.silkspawners.plugin.commands.SilkSpawnersCommandHandler;
import de.corneliusmay.silkspawners.plugin.commands.executors.ExplosionCommand;
import de.corneliusmay.silkspawners.plugin.commands.executors.GiveCommand;
import de.corneliusmay.silkspawners.plugin.commands.executors.HelpCommand;
import de.corneliusmay.silkspawners.plugin.commands.executors.LocaleCommand;
import de.corneliusmay.silkspawners.plugin.commands.executors.PermissionsCommand;
import de.corneliusmay.silkspawners.plugin.commands.executors.SetCommand;
import de.corneliusmay.silkspawners.plugin.commands.executors.VersionCommand;
import de.corneliusmay.silkspawners.plugin.config.PluginConfig;
import de.corneliusmay.silkspawners.plugin.config.handler.ConfigLoader;
import de.corneliusmay.silkspawners.plugin.config.handler.ConfigValue;
import de.corneliusmay.silkspawners.plugin.listeners.BlockBreakListener;
import de.corneliusmay.silkspawners.plugin.listeners.BlockPlaceListener;
import de.corneliusmay.silkspawners.plugin.listeners.PlayerInteractListener;
import de.corneliusmay.silkspawners.plugin.listeners.SpawnerBreakListener;
import de.corneliusmay.silkspawners.plugin.locale.LocaleHandler;
import de.corneliusmay.silkspawners.plugin.utils.Logger;
import de.corneliusmay.silkspawners.plugin.version.VersionChecker;
import de.corneliusmay.silkspawners.plugin.version.VersionHandler;
import java.util.Locale;
import org.bukkit.Bukkit;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;

public class SilkSpawners
extends JavaPlugin {
    private static SilkSpawners instance;
    private Logger log;
    private NMS nmsHandler;
    private LocaleHandler locale;
    private VersionChecker versionChecker;
    private SilkSpawnersCommandHandler commandHandler;

    @Override
    public void onEnable() {
        instance = this;
        new ConfigLoader(this).load();
        this.log = new Logger((String)new ConfigValue(PluginConfig.MESSAGE_PREFIX).get());
        this.log.info("Starting SilkSpawners v" + VersionChecker.getInstalledVersion());
        this.log.info("Loading Cross-Version support");
        VersionHandler versionHandler = new VersionHandler();
        if (!versionHandler.load()) {
            return;
        }
        this.nmsHandler = versionHandler.getNmsHandler();
        this.log.info("Loading locale file");
        this.locale = new LocaleHandler((Locale)new ConfigValue(PluginConfig.MESSAGE_LOCALE).get());
        if (this.locale.getResourceBundle() == null) {
            return;
        }
        this.versionChecker = new VersionChecker();
        if (((Boolean)new ConfigValue(PluginConfig.UPDATE_CHECK_ENABLED).get()).booleanValue()) {
            this.startUpdateChecker();
        } else {
            this.log.warn("Update checking is disabled");
        }
        this.log.info("Starting metrics service. You can disable the collection of anonymous usage data by editing the config file under /plugins/bStats/");
        new Metrics(this, 15215);
        this.log.info("Registering listeners");
        this.registerListeners();
        this.log.info("Registering commands");
        this.registerCommands();
        this.log.info("Started SilkSpawners v" + VersionChecker.getInstalledVersion());
    }

    private void startUpdateChecker() {
        this.log.info("Starting update checker");
        this.versionChecker.start((Integer)new ConfigValue(PluginConfig.UPDATE_CHECK_INTERVAL).get());
    }

    private void registerListeners() {
        PluginManager pm = Bukkit.getPluginManager();
        pm.registerEvents(new BlockBreakListener(), this);
        pm.registerEvents(new BlockPlaceListener(), this);
        pm.registerEvents(new SpawnerBreakListener(), this);
        pm.registerEvents(new PlayerInteractListener(), this);
    }

    private void registerCommands() {
        this.commandHandler = new SilkSpawnersCommandHandler();
        this.commandHandler.registerCommand(new HelpCommand());
        this.commandHandler.registerCommand(new GiveCommand());
        this.commandHandler.registerCommand(new SetCommand());
        this.commandHandler.registerCommand(new ExplosionCommand());
        this.commandHandler.registerCommand(new VersionCommand());
        this.commandHandler.registerCommand(new LocaleCommand());
        this.commandHandler.registerCommand(new PermissionsCommand());
        this.getCommand("silkspawners").setExecutor(this.commandHandler);
        this.getCommand("silkspawners").setTabCompleter(this.commandHandler.getTabCompleter());
    }

    @Override
    public void onDisable() {
        if (this.versionChecker == null) {
            return;
        }
        this.log.info("Stopping version checker");
        this.versionChecker.stop();
    }

    public static SilkSpawners getInstance() {
        return instance;
    }

    public Logger getLog() {
        return this.log;
    }

    public NMS getNmsHandler() {
        return this.nmsHandler;
    }

    public LocaleHandler getLocale() {
        return this.locale;
    }

    public VersionChecker getVersionChecker() {
        return this.versionChecker;
    }

    public SilkSpawnersCommandHandler getCommandHandler() {
        return this.commandHandler;
    }
}

