/*
 * Decompiled with CFR 0.152.
 */
package de.corneliusmay.silkspawners.plugin.commands;

import de.corneliusmay.silkspawners.plugin.SilkSpawners;
import de.corneliusmay.silkspawners.plugin.commands.TabCompletion;
import org.bukkit.command.CommandSender;

public abstract class SilkSpawnersCommand {
    private final String command;
    private final boolean requiresPermission;
    private final TabCompletion[] completions;

    public SilkSpawnersCommand(String command, Boolean requiresPermission, TabCompletion ... completions) {
        this.command = command;
        this.requiresPermission = requiresPermission;
        this.completions = completions;
    }

    public final boolean hasPermission(CommandSender sender) {
        if (!this.requiresPermission) {
            return true;
        }
        return sender.hasPermission(this.getPermissionString());
    }

    public final String getPermissionString() {
        return "silkspawners.command." + this.command;
    }

    protected final String getMessage(String key, Object ... args) {
        return SilkSpawners.getInstance().getLocale().getMessage("COMMAND_" + this.command.toUpperCase() + "_" + key, args);
    }

    public boolean insufficientPermission(CommandSender sender) {
        sender.sendMessage(SilkSpawners.getInstance().getLocale().getMessage("COMMAND_INSUFFICIENT_PERMISSIONS", new Object[0]));
        return false;
    }

    public boolean invalidSyntax(CommandSender sender) {
        sender.sendMessage(this.getMessage("USAGE", new Object[0]));
        return false;
    }

    public abstract boolean execute(CommandSender var1, String[] var2);

    public String getCommand() {
        return this.command;
    }

    public TabCompletion[] getCompletions() {
        return this.completions;
    }
}

