/*
 * Decompiled with CFR 0.152.
 */
package de.corneliusmay.silkspawners.plugin.commands;

import de.corneliusmay.silkspawners.plugin.SilkSpawners;
import de.corneliusmay.silkspawners.plugin.commands.SilkSpawnersCommand;
import de.corneliusmay.silkspawners.plugin.commands.SilkSpawnersTabCompleter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;

public class SilkSpawnersCommandHandler
implements CommandExecutor {
    private final List<SilkSpawnersCommand> commands = new ArrayList<SilkSpawnersCommand>();
    private final SilkSpawnersTabCompleter tabCompleter = new SilkSpawnersTabCompleter(this);

    @Override
    public boolean onCommand(CommandSender commandSender, Command c, String s, String[] args) {
        if (args.length < 1) {
            commandSender.sendMessage(SilkSpawners.getInstance().getLocale().getMessage("COMMAND_NOT_FOUND", this.getAvailableCommandsString(commandSender)));
            return false;
        }
        SilkSpawnersCommand command = this.getCommand(args[0]);
        if (command == null) {
            commandSender.sendMessage(SilkSpawners.getInstance().getLocale().getMessage("COMMAND_NOT_FOUND", this.getAvailableCommandsString(commandSender)));
            return false;
        }
        if (!command.hasPermission(commandSender)) {
            return command.insufficientPermission(commandSender);
        }
        return command.execute(commandSender, Arrays.copyOfRange(args, 1, args.length));
    }

    public void registerCommand(SilkSpawnersCommand command) {
        if (this.getCommand(command.getCommand()) != null) {
            return;
        }
        this.commands.add(command);
    }

    public SilkSpawnersCommand getCommand(String command) {
        return this.commands.stream().filter(c -> c.getCommand().equalsIgnoreCase(command)).findFirst().orElse(null);
    }

    public List<String> getCommands(CommandSender cs) {
        return this.commands.stream().filter(c -> c.hasPermission(cs)).map(SilkSpawnersCommand::getCommand).collect(Collectors.toList());
    }

    public String getAvailableCommandsString(CommandSender cs) {
        return " - /silkspawners " + Arrays.toString(this.getCommands(cs).toArray(String[]::new)).replace("[", "").replace("]", "").replace(", ", "\n - /silkspawners ");
    }

    public List<SilkSpawnersCommand> getCommands() {
        return this.commands;
    }

    public SilkSpawnersTabCompleter getTabCompleter() {
        return this.tabCompleter;
    }
}

