/*
 * Decompiled with CFR 0.152.
 */
package de.corneliusmay.silkspawners.plugin.commands;

import de.corneliusmay.silkspawners.plugin.commands.SilkSpawnersCommand;
import de.corneliusmay.silkspawners.plugin.commands.SilkSpawnersCommandHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.util.StringUtil;

class SilkSpawnersTabCompleter
implements TabCompleter {
    private final SilkSpawnersCommandHandler commandHandler;

    public SilkSpawnersTabCompleter(SilkSpawnersCommandHandler commandHandler) {
        this.commandHandler = commandHandler;
    }

    @Override
    public List<String> onTabComplete(CommandSender commandSender, Command c, String s, String[] args) {
        args = (String[])Arrays.stream(args).map(String::toLowerCase).toList().toArray(String[]::new);
        ArrayList<String> completions = new ArrayList<String>();
        SilkSpawnersCommand command = this.commandHandler.getCommand(args[0]);
        if (args.length < 2) {
            StringUtil.copyPartialMatches(args[args.length - 1], this.commandHandler.getCommands(commandSender), completions);
        } else if (command != null && command.getCompletions().length >= args.length - 1 && command.hasPermission(commandSender)) {
            StringUtil.copyPartialMatches(args[args.length - 1], command.getCompletions()[args.length - 2].update(command, commandSender), completions);
        }
        Collections.sort(completions);
        return completions;
    }
}

