/*
 * Decompiled with CFR 0.152.
 */
package de.corneliusmay.silkspawners.plugin.commands.executors;

import de.corneliusmay.silkspawners.plugin.SilkSpawners;
import de.corneliusmay.silkspawners.plugin.commands.SilkSpawnersCommand;
import de.corneliusmay.silkspawners.plugin.commands.StaticTabCompletion;
import de.corneliusmay.silkspawners.plugin.commands.completers.OnlinePlayersTabCompleter;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.permissions.PermissionAttachment;

public class ExplosionCommand
extends SilkSpawnersCommand {
    public ExplosionCommand() {
        super("explosion", true, new StaticTabCompletion("enable", "disable", "setting"), new OnlinePlayersTabCompleter());
    }

    @Override
    public boolean execute(CommandSender sender, String[] args) {
        if (args.length != 2) {
            return this.invalidSyntax(sender);
        }
        Player p = Bukkit.getPlayer(args[1]);
        if (p == null) {
            sender.sendMessage(this.getMessage("PLAYER_NOT_FOUND", args[1]));
            return false;
        }
        PermissionAttachment attachment = p.addAttachment(SilkSpawners.getInstance());
        switch (args[0].toLowerCase()) {
            case "enable": 
            case "e": {
                attachment.setPermission("silkspawners.explosion", true);
                sender.sendMessage(this.getMessage("ENABLED", p.getName()));
                break;
            }
            case "disable": 
            case "d": {
                attachment.setPermission("silkspawners.explosion", false);
                sender.sendMessage(this.getMessage("DISABLED", p.getName()));
                break;
            }
            case "setting": 
            case "s": {
                sender.sendMessage(this.getMessage("SETTING_" + (p.hasPermission("silkspawners.explosion") ? "ENABLED" : "DISABLED"), p.getName()));
                break;
            }
            default: {
                this.invalidSyntax(sender);
            }
        }
        return true;
    }
}

