/*
 * Decompiled with CFR 0.152.
 */
package de.corneliusmay.silkspawners.plugin.commands.executors;

import de.corneliusmay.silkspawners.plugin.commands.SilkSpawnersCommand;
import de.corneliusmay.silkspawners.plugin.commands.completers.EntityTabCompleter;
import de.corneliusmay.silkspawners.plugin.spawner.Spawner;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;

public class SetCommand
extends SilkSpawnersCommand {
    public SetCommand() {
        super("set", true, new EntityTabCompleter());
    }

    @Override
    public boolean execute(CommandSender sender, String[] args) {
        if (args.length != 1) {
            return this.invalidSyntax(sender);
        }
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.getMessage("PLAYERS_ONLY", new Object[0]));
            return false;
        }
        Player player = (Player)sender;
        Spawner newSpawner = new Spawner(EntityType.fromName(args[0]));
        if (!newSpawner.isValid()) {
            sender.sendMessage(this.getMessage("ENTITY_NOT_FOUND", args[0]));
            return false;
        }
        if (!player.hasPermission(this.getPermissionString() + "." + newSpawner.getEntityType().getName())) {
            sender.sendMessage(this.getMessage("INSUFFICIENT_ENTITY_PERMISSION", newSpawner.serializedName()));
            return false;
        }
        Block block = player.getTargetBlockExact(5);
        Spawner spawner = new Spawner(block);
        if (!spawner.isValid()) {
            sender.sendMessage(this.getMessage("INVALID_TARGET", new Object[0]));
            return false;
        }
        newSpawner.setSpawnerBlockType(block);
        sender.sendMessage(this.getMessage("SUCCESS", newSpawner.serializedName()));
        return true;
    }
}

