/*
 * Decompiled with CFR 0.152.
 */
package de.corneliusmay.silkspawners.plugin.listeners;

import de.corneliusmay.silkspawners.plugin.SilkSpawners;
import de.corneliusmay.silkspawners.plugin.config.PluginConfig;
import de.corneliusmay.silkspawners.plugin.config.handler.ConfigValue;
import de.corneliusmay.silkspawners.plugin.spawner.Spawner;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.block.Block;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.plugin.Plugin;

public class PlayerInteractListener
implements Listener {
    private final List<Block> editedSpawners = Collections.synchronizedList(new ArrayList());

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerInteract(PlayerInteractEvent e) {
        if (e.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        Block block = e.getClickedBlock();
        Spawner spawner = new Spawner(block);
        if (!spawner.isValid()) {
            return;
        }
        if (this.editedSpawners.stream().anyMatch(b -> b.getLocation().equals(block.getLocation()))) {
            e.setCancelled(true);
            return;
        }
        this.editedSpawners.add(block);
        Bukkit.getScheduler().runTaskLater((Plugin)SilkSpawners.getInstance(), () -> {
            Spawner newSpawner = new Spawner(block.getWorld().getBlockAt(block.getLocation()));
            if (!e.getPlayer().hasPermission("silkspawners.change." + spawner.getEntityType().getName()) && spawner.getEntityType() != newSpawner.getEntityType()) {
                spawner.setSpawnerBlockType(block);
                if (((Boolean)new ConfigValue(PluginConfig.SPAWNER_MESSAGE_DENY_CHANGE).get()).booleanValue()) {
                    e.getPlayer().sendMessage(SilkSpawners.getInstance().getLocale().getMessage("SPAWNER_CHANGE_DENIED", new Object[0]));
                }
            }
            Bukkit.getScheduler().runTaskLater((Plugin)SilkSpawners.getInstance(), () -> this.editedSpawners.remove(block), 5L);
        }, 5L);
    }
}

