/*
 * Decompiled with CFR 0.152.
 */
package de.corneliusmay.silkspawners.plugin.spawner;

import de.corneliusmay.silkspawners.plugin.SilkSpawners;
import de.corneliusmay.silkspawners.plugin.config.PluginConfig;
import de.corneliusmay.silkspawners.plugin.config.handler.ConfigValue;
import de.corneliusmay.silkspawners.plugin.config.handler.ConfigValueArray;
import de.corneliusmay.silkspawners.plugin.utils.ItemBuilder;
import org.bukkit.Bukkit;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.entity.EntityType;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class Spawner {
    private EntityType entityType;
    private ItemStack itemStack;
    private final String prefix = (String)new ConfigValue(PluginConfig.SPAWNER_ITEM_PREFIX).get();
    private final String oldPrefix = (String)new ConfigValue(PluginConfig.SPAWNER_ITEM_PREFIX_OLD).get();

    public Spawner(Block block) {
        if (block == null) {
            return;
        }
        if (block.getType() != SilkSpawners.getInstance().getNmsHandler().getSpawnerMaterial()) {
            return;
        }
        CreatureSpawner creatureSpawner = (CreatureSpawner)block.getState();
        this.entityType = creatureSpawner.getSpawnedType();
        this.itemStack = this.generateItemStack();
    }

    public Spawner(ItemStack itemStack) {
        this.itemStack = itemStack;
        if (itemStack == null) {
            return;
        }
        if (itemStack.getType() != SilkSpawners.getInstance().getNmsHandler().getSpawnerMaterial()) {
            return;
        }
        if (itemStack.getItemMeta() == null || itemStack.getItemMeta().getLore() == null) {
            return;
        }
        this.entityType = this.getSpawnerEntity(itemStack.getItemMeta().getLore().get(0));
    }

    public Spawner(EntityType entityType) {
        this.entityType = entityType;
        this.itemStack = this.generateItemStack();
    }

    public void setSpawnerBlockType(Block block) {
        if (!this.isValid()) {
            return;
        }
        Bukkit.getScheduler().runTaskLater((Plugin)SilkSpawners.getInstance(), () -> {
            BlockState blockState = block.getState();
            if (!(blockState instanceof CreatureSpawner)) {
                return;
            }
            CreatureSpawner creatureSpawner = (CreatureSpawner)blockState;
            creatureSpawner.setSpawnedType(this.entityType);
            blockState.update();
        }, 5L);
    }

    private ItemStack generateItemStack() {
        if (this.entityType == null || this.entityType.getName() == null) {
            return null;
        }
        return new ItemBuilder(SilkSpawners.getInstance().getNmsHandler().getSpawnerMaterial()).setDisplayName((String)new ConfigValue(PluginConfig.SPAWNER_ITEM_NAME).get()).addToLore(this.serializedName()).addToLore(new ConfigValueArray(PluginConfig.SPAWNER_ITEM_LORE).get()).build();
    }

    private EntityType getSpawnerEntity(String lore) {
        if (lore.startsWith(this.prefix)) {
            return EntityType.fromName(lore.replace(this.prefix, "").toLowerCase());
        }
        if (!this.oldPrefix.equals("") && lore.startsWith(this.oldPrefix)) {
            return EntityType.fromName(lore.replace(this.oldPrefix, "").toLowerCase());
        }
        return null;
    }

    public String serializedName() {
        return this.prefix + this.entityType.getName().substring(0, 1).toUpperCase() + this.entityType.getName().substring(1);
    }

    public boolean isValid() {
        return this.itemStack != null && this.entityType != null && this.entityType.isSpawnable();
    }

    public EntityType getEntityType() {
        return this.entityType;
    }

    public ItemStack getItemStack() {
        return this.itemStack;
    }
}

