/*
 * Decompiled with CFR 0.152.
 */
package de.corneliusmay.silkspawners.plugin.utils;

import java.util.ArrayList;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class ItemBuilder {
    private final ItemStack stack;
    private final ItemMeta meta;

    public ItemBuilder(Material material, int amount) {
        this.stack = new ItemStack(material, amount);
        this.meta = this.stack.getItemMeta();
    }

    public ItemBuilder(Material material) {
        this.stack = new ItemStack(material, 1);
        this.meta = this.stack.getItemMeta();
    }

    public ItemBuilder setDisplayName(String displayName) {
        this.meta.setDisplayName(displayName);
        return this;
    }

    public ItemBuilder addToLore(String lore) {
        ArrayList loreList = this.meta.getLore() == null ? new ArrayList() : (ArrayList)this.meta.getLore();
        loreList.add(lore);
        this.meta.setLore(loreList);
        return this;
    }

    public ItemBuilder addToLore(List<String> loreArray) {
        for (String lore : loreArray) {
            this.addToLore(lore);
        }
        return this;
    }

    public ItemStack build() {
        this.stack.setItemMeta(this.meta);
        return this.stack;
    }
}

