/*
 * Decompiled with CFR 0.152.
 */
package de.corneliusmay.silkspawners.plugin.version;

import de.corneliusmay.silkspawners.plugin.SilkSpawners;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

public class VersionChecker {
    private boolean running;
    private String latestVersion;
    private final ExecutorService pool = Executors.newFixedThreadPool(1);
    private final HttpClient client = HttpClient.newHttpClient();

    public void start(int interval) {
        if (this.running) {
            return;
        }
        this.running = true;
        this.pool.execute(() -> this.run(interval));
    }

    public void stop() {
        this.running = false;
        this.pool.shutdownNow();
    }

    private void run(int interval) {
        while (this.running) {
            try {
                SilkSpawners.getInstance().getLog().info("Checking for updates");
                if (!this.updateLatestVersion()) {
                    SilkSpawners.getInstance().getLog().error("Error getting latest version");
                } else if (!this.check()) {
                    SilkSpawners.getInstance().getLog().warn("\u00a7eUpdate available! Download at https://www.spigotmc.org/resources/silkspawners.60063/ \u00a7f\nInstalled version: v" + VersionChecker.getInstalledVersion() + "\nLatest version: v" + this.latestVersion);
                } else {
                    SilkSpawners.getInstance().getLog().info("The plugin is up to date (v" + this.latestVersion + ")");
                }
                TimeUnit.HOURS.sleep(interval);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private boolean updateLatestVersion() {
        try {
            HttpRequest request = HttpRequest.newBuilder().uri(URI.create("https://storage.googleapis.com/silkspawners/version.html")).GET().build();
            this.latestVersion = this.client.send(request, HttpResponse.BodyHandlers.ofString()).body().replace("\r", "").replace("\n", "");
            return true;
        }
        catch (IOException | InterruptedException ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public boolean check() {
        return this.latestVersion.equals(VersionChecker.getInstalledVersion());
    }

    public static String getInstalledVersion() {
        return SilkSpawners.getInstance().getDescription().getVersion();
    }

    public String getLatestVersion() {
        return this.latestVersion;
    }
}

