"use strict";
(globalThis["__googlesitekit_webpackJsonp"] = globalThis["__googlesitekit_webpackJsonp"] || []).push([["googlesitekit-modules-pagespeed-insights"],{

/***/ "./js/components/Accordion.js":
/*!************************************!*\
  !*** ./js/components/Accordion.js ***!
  \************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Accordion)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _wordpress_keycodes__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @wordpress/keycodes */ "../node_modules/@wordpress/keycodes/build-module/index.js");
/* harmony import */ var _svg_icons_chevron_down_v2_svg__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/svg/icons/chevron-down-v2.svg */ "./svg/icons/chevron-down-v2.svg");
/* harmony import */ var _IconWrapper__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./IconWrapper */ "./js/components/IconWrapper.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Accordion component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */



function Accordion({
  title,
  children,
  initialOpen,
  onOpen,
  onClose,
  disabled
}) {
  const [isActive, setActive] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_4__.useState)(!!initialOpen);
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_4__.useEffect)(() => {
    if (isActive && onOpen && typeof onOpen === 'function') {
      onOpen();
    } else if (!isActive && onClose && typeof onClose === 'function') {
      onClose();
    }
  }, [isActive, onClose, onOpen]);
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_4__.useEffect)(() => {
    if (disabled && isActive) {
      setActive(false);
    }
  }, [disabled, isActive]);
  const toggleAccordion = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_4__.useCallback)(event => {
    if (event.type === 'keydown' && ![_wordpress_keycodes__WEBPACK_IMPORTED_MODULE_5__.ENTER, _wordpress_keycodes__WEBPACK_IMPORTED_MODULE_5__.SPACE].includes(event.keyCode)) {
      return;
    }

    // Prevent scroll when spacebar is hit.
    event.preventDefault();
    setActive(!isActive);
  }, [isActive]);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-accordion', {
      'googlesitekit-accordion--disabled': disabled
    }),
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
      className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-accordion__header', {
        'is-active': isActive
      }),
      onClick: toggleAccordion,
      onKeyDown: toggleAccordion,
      tabIndex: disabled ? -1 : 0,
      role: "button",
      children: [title, /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_IconWrapper__WEBPACK_IMPORTED_MODULE_2__["default"], {
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_svg_icons_chevron_down_v2_svg__WEBPACK_IMPORTED_MODULE_1__["default"], {
          width: 12,
          height: 12
        })
      })]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
      className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-accordion__content', {
        'is-active': isActive
      }),
      children: children
    })]
  });
}
Accordion.propTypes = {
  title: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().node).isRequired,
  children: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().node).isRequired,
  initialOpen: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().bool),
  onOpen: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().func),
  onClose: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().func),
  disabled: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().bool)
};

/***/ }),

/***/ "./js/components/Badge.js":
/*!********************************!*\
  !*** ./js/components/Badge.js ***!
  \********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Badge component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * WordPress dependencies
 */


const Badge = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.forwardRef)(({
  label,
  className,
  hasLeftSpacing = false,
  ...rest
}, ref) => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("span", {
  ref: ref,
  ...rest,
  className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-badge', className, {
    'googlesitekit-badge--has-left-spacing': hasLeftSpacing
  }),
  children: label
}));
Badge.displayName = 'Badge';
Badge.propTypes = {
  label: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string).isRequired,
  hasLeftSpacing: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().bool)
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Badge);

/***/ }),

/***/ "./js/components/ChangeArrow.js":
/*!**************************************!*\
  !*** ./js/components/ChangeArrow.js ***!
  \**************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * External dependencies
 */



function ChangeArrow({
  direction,
  invertColor,
  width,
  height
}) {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("svg", {
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-change-arrow', `googlesitekit-change-arrow--${direction}`, {
      'googlesitekit-change-arrow--inverted-color': invertColor
    }),
    width: width,
    height: height,
    viewBox: "0 0 10 10",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg",
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("path", {
      d: "M5.625 10L5.625 2.375L9.125 5.875L10 5L5 -1.76555e-07L-2.7055e-07 5L0.875 5.875L4.375 2.375L4.375 10L5.625 10Z",
      fill: "currentColor"
    })
  });
}
ChangeArrow.propTypes = {
  direction: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().string),
  invertColor: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().bool),
  width: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().number),
  height: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().number)
};
ChangeArrow.defaultProps = {
  direction: 'up',
  invertColor: false,
  width: 9,
  height: 9
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ChangeArrow);

/***/ }),

/***/ "./js/components/DeviceSizeTabBar.js":
/*!*******************************************!*\
  !*** ./js/components/DeviceSizeTabBar.js ***!
  \*******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-components */ "googlesitekit-components");
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _svg_icons_device_size_mobile_icon_svg__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/svg/icons/device-size-mobile-icon.svg */ "./svg/icons/device-size-mobile-icon.svg");
/* harmony import */ var _svg_icons_device_size_desktop_icon_svg__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/svg/icons/device-size-desktop-icon.svg */ "./svg/icons/device-size-desktop-icon.svg");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * DeviceSizeTabBar component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */




function DeviceSizeTabBar({
  activeTab,
  disabled = false,
  handleDeviceSizeUpdate,
  deviceSizes = [{
    slug: 'mobile',
    label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Mobile', 'google-site-kit'),
    icon: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(_svg_icons_device_size_mobile_icon_svg__WEBPACK_IMPORTED_MODULE_2__["default"], {
      width: "15",
      height: "22"
    })
  }, {
    slug: 'desktop',
    label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Desktop', 'google-site-kit'),
    icon: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(_svg_icons_device_size_desktop_icon_svg__WEBPACK_IMPORTED_MODULE_3__["default"], {
      width: "23",
      height: "17"
    })
  }]
}) {
  const onUpdate = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_5__.useCallback)(index => {
    const device = deviceSizes[index];
    handleDeviceSizeUpdate(device, index);
  }, [deviceSizes, handleDeviceSizeUpdate]);
  if (!deviceSizes?.length) {
    return null;
  }
  const activeIndex = deviceSizes.findIndex(({
    slug
  }) => slug === activeTab);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__.TabBar, {
    className: "googlesitekit-device-size-tab-bar",
    activeIndex: activeIndex,
    handleActiveIndexUpdate: onUpdate,
    children: deviceSizes.map(({
      icon,
      label
    }, i) => {
      return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__.Tab, {
        "aria-label": label,
        disabled: disabled,
        focusOnActivate: false,
        children: icon
      }, `google-sitekit-device-size-tab-key-${i}`);
    })
  });
}
DeviceSizeTabBar.propTypes = {
  activeTab: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().string),
  disabled: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().bool),
  deviceSizes: prop_types__WEBPACK_IMPORTED_MODULE_6___default().arrayOf(prop_types__WEBPACK_IMPORTED_MODULE_6___default().shape({
    label: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().string),
    slug: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().string),
    icon: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().node)
  })),
  handleDeviceSizeUpdate: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().func)
};
DeviceSizeTabBar.defaultProps = {
  handleDeviceSizeUpdate: () => {}
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (DeviceSizeTabBar);

/***/ }),

/***/ "./js/components/ErrorNotice.js":
/*!**************************************!*\
  !*** ./js/components/ErrorNotice.js ***!
  \**************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ ErrorNotice)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_url__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @wordpress/url */ "../node_modules/@wordpress/url/build-module/is-url.js");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _js_util_errors__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/util/errors */ "./js/util/errors.js");
/* harmony import */ var _Notice__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./Notice */ "./js/components/Notice/index.js");
/* harmony import */ var _js_util__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/util */ "./js/util/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * ErrorNotice component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */




/**
 * Internal dependencies
 */





function ErrorNotice({
  className,
  error,
  hasButton = false,
  storeName,
  message = error.message,
  noPrefix = false,
  skipRetryMessage,
  hideIcon = false
}) {
  const dispatch = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useDispatch)();
  const selectorData = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => {
    if (!storeName) {
      return null;
    }
    return select(storeName).getSelectorDataForError(error);
  });
  const handleRetry = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.useCallback)(() => {
    dispatch(selectorData.storeName).invalidateResolution(selectorData.name, selectorData.args);
  }, [dispatch, selectorData]);

  // Do not display if there is no error and no direct message text is passed as a direct prop.
  // Also do not display if the error is for missing scopes as these are handled by a popup modal.
  if (!message || (0,_js_util_errors__WEBPACK_IMPORTED_MODULE_2__.isPermissionScopeError)(error)) {
    return null;
  }
  const shouldDisplayRetry = hasButton && (0,_js_util_errors__WEBPACK_IMPORTED_MODULE_2__.isErrorRetryable)(error, selectorData);

  /**
   * Error message to display to the user. Sometimes we append a retry message
   * or a reconnect URL, so we create a new variable for the message to display.
   */
  let errorMessageWithModifications = message;

  // Append "Try again" messaging if no retry button is present.
  if (!hasButton && !skipRetryMessage) {
    errorMessageWithModifications = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.sprintf)(/* translators: %s: Error message from Google API. */
    (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('%s (Please try again.)', 'google-site-kit'), errorMessageWithModifications);
  }
  if (!noPrefix) {
    errorMessageWithModifications = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.sprintf)(/* translators: $%s: Error message */
    (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Error: %s', 'google-site-kit'), errorMessageWithModifications);
  }
  const reconnectURL = error?.data?.reconnectURL;
  if (reconnectURL && (0,_wordpress_url__WEBPACK_IMPORTED_MODULE_7__.isURL)(reconnectURL)) {
    /**
     * This error message uses HTML tags without using
     * `createInterpolateElement` because the error messages
     * that come from the server/API can also contain HTML (eg. links)
     * we want to render.
     *
     * Instead of creating a React node using `createInterpolateElement`,
     * we use `dangerouslySetInnerHTML` to allow the HTML we create and from
     * the server/API to be rendered as-intended.
     */
    errorMessageWithModifications = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.sprintf)(/* translators: 1: Original error message 2: Reconnect URL */
    (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('%1$s To fix this, <a href="%2$s">redo the plugin setup</a>.', 'google-site-kit'), errorMessageWithModifications, reconnectURL);
  }
  const sanitizeArgs = {
    ALLOWED_TAGS: ['a'],
    ALLOWED_ATTR: ['href']
  };
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_Notice__WEBPACK_IMPORTED_MODULE_3__["default"], {
    className: className,
    type: _Notice__WEBPACK_IMPORTED_MODULE_3__["default"].TYPES.ERROR,
    description:
    /*#__PURE__*/
    // The error messages that come from the server/API can contain
    // HTML (eg. links), so we use `dangerouslySetInnerHTML` and sanitize
    // the HTML to render these links.
    //
    // We tried to use `createInterpolateElement` but it does not work
    // with HTML tags that come from the server/API.
    (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("span", {
      dangerouslySetInnerHTML: (0,_js_util__WEBPACK_IMPORTED_MODULE_4__.sanitizeHTML)(errorMessageWithModifications, sanitizeArgs)
    }),
    ctaButton: shouldDisplayRetry ? {
      label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Retry', 'google-site-kit'),
      onClick: handleRetry
    } : undefined,
    hideIcon: hideIcon
  });
}
ErrorNotice.propTypes = {
  className: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().string),
  error: prop_types__WEBPACK_IMPORTED_MODULE_8___default().shape({
    message: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().string)
  }),
  hasButton: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().bool),
  storeName: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().string),
  message: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().string),
  noPrefix: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().bool),
  skipRetryMessage: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().bool),
  hideIcon: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().bool)
};

/***/ }),

/***/ "./js/components/IconWrapper.js":
/*!**************************************!*\
  !*** ./js/components/IconWrapper.js ***!
  \**************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ IconWrapper)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * IconWrapper component.
 *
 * Site Kit by Google, Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


function IconWrapper({
  children,
  marginLeft,
  marginRight
}) {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("span", {
    className: "googlesitekit-icon-wrapper",
    style: {
      marginLeft,
      marginRight
    },
    children: children
  });
}
IconWrapper.propTypes = {
  children: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().node).isRequired,
  marginLeft: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().number),
  marginRight: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().number)
};

/***/ }),

/***/ "./js/components/InfoTooltip.js":
/*!**************************************!*\
  !*** ./js/components/InfoTooltip.js ***!
  \**************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ InfoTooltip)
/* harmony export */ });
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-components */ "googlesitekit-components");
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _svg_icons_info_green_svg__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/svg/icons/info-green.svg */ "./svg/icons/info-green.svg");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * InfoTooltip component.
 *
 * Site Kit by Google, Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * Internal dependencies
 */



function InfoTooltip({
  onOpen,
  title,
  tooltipClassName
}) {
  if (!title) {
    return null;
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__.Tooltip, {
    className: "googlesitekit-info-tooltip",
    tooltipClassName: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-info-tooltip__content', tooltipClassName),
    title: title,
    placement: "top",
    enterTouchDelay: 0,
    leaveTouchDelay: 5000,
    onOpen: onOpen,
    interactive: true,
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("span", {
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_svg_icons_info_green_svg__WEBPACK_IMPORTED_MODULE_2__["default"], {
        width: "16",
        height: "16"
      })
    })
  });
}
InfoTooltip.propTypes = {
  onOpen: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().func),
  title: prop_types__WEBPACK_IMPORTED_MODULE_4___default().oneOfType([(prop_types__WEBPACK_IMPORTED_MODULE_4___default().string), (prop_types__WEBPACK_IMPORTED_MODULE_4___default().element)]),
  tooltipClassName: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().string)
};

/***/ }),

/***/ "./js/components/Link.js":
/*!*******************************!*\
  !*** ./js/components/Link.js ***!
  \*******************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_10__);
/* harmony import */ var react_router_dom__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! react-router-dom */ "../node_modules/react-router-dom/esm/react-router-dom.js");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _svg_icons_arrow_svg__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/svg/icons/arrow.svg */ "./svg/icons/arrow.svg");
/* harmony import */ var _svg_icons_arrow_inverse_svg__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/svg/icons/arrow-inverse.svg */ "./svg/icons/arrow-inverse.svg");
/* harmony import */ var _svg_icons_back_svg__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/svg/icons/back.svg */ "./svg/icons/back.svg");
/* harmony import */ var _svg_icons_external_svg__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/svg/icons/external.svg */ "./svg/icons/external.svg");
/* harmony import */ var _IconWrapper__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./IconWrapper */ "./js/components/IconWrapper.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Link component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */




/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */






const BUTTON = 'BUTTON';
const BUTTON_DISABLED = 'BUTTON_DISABLED';
const EXTERNAL_LINK = 'EXTERNAL_LINK';
const LINK = 'LINK';
const ROUTER_LINK = 'ROUTER_LINK';
const Link = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_8__.forwardRef)((props, ref) => {
  const {
    'aria-label': ariaLabelProp,
    secondary = false,
    arrow = false,
    back = false,
    caps = false,
    children,
    className = '',
    danger = false,
    disabled = false,
    external = false,
    hideExternalIndicator = false,
    href = '',
    inverse = false,
    noFlex = false,
    onClick,
    small = false,
    standalone = false,
    linkButton = false,
    to,
    leadingIcon,
    trailingIcon,
    ...otherProps
  } = props;
  function getType() {
    // Force button element if `onClick` prop is passed and there's no `href`
    // or `to` prop.
    if (!href && !to && onClick) {
      if (disabled) {
        return BUTTON_DISABLED;
      }
      return BUTTON;
    }

    // Only `RouterLink` uses the `to` prop.
    if (to) {
      return ROUTER_LINK;
    }

    // The external prop means this is an external link, which will also output
    // an `<a>` tag.
    if (external) {
      return EXTERNAL_LINK;
    }

    // A regular `<a>` tag without external indicators.
    return LINK;
  }
  const type = getType();
  function getLinkComponent() {
    if (type === BUTTON || type === BUTTON_DISABLED) {
      return 'button';
    }
    if (type === ROUTER_LINK) {
      return react_router_dom__WEBPACK_IMPORTED_MODULE_9__.Link;
    }
    return 'a';
  }
  function getAriaLabel() {
    // Otherwise, create an ARIA label if the link opens in a new window
    // or is disabled, to add extra context to the link.
    let labelSuffix;
    if (type === EXTERNAL_LINK) {
      labelSuffix = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__._x)('(opens in a new tab)', 'screen reader text', 'google-site-kit');
    }
    if (type === BUTTON_DISABLED) {
      labelSuffix = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__._x)('(disabled)', 'screen reader text', 'google-site-kit');
    }
    if (!labelSuffix) {
      return ariaLabelProp;
    }

    // If an ARIA label was supplied, use that.
    if (ariaLabelProp) {
      return `${ariaLabelProp} ${labelSuffix}`;
    }

    // Otherwise, use the children prop if it's a string.
    if (typeof children === 'string') {
      return `${children} ${labelSuffix}`;
    }

    // If there isn't a string we can use to create the label, we shouldn't
    // make one; otherwise we'll only create an ARIA label that says
    // "(opens in a new tab)", which is not good.
    return undefined;
  }
  const LinkComponent = getLinkComponent();
  const ariaLabel = getAriaLabel();

  // Set the prefix/suffix icons, based on the type of link this is and
  // the props supplied.
  let leadingIconToUse = leadingIcon;
  let trailingIconToUse = trailingIcon;
  if (back) {
    leadingIconToUse = /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_svg_icons_back_svg__WEBPACK_IMPORTED_MODULE_4__["default"], {
      width: 14,
      height: 14
    });
  }
  if (external && !hideExternalIndicator) {
    trailingIconToUse = /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_svg_icons_external_svg__WEBPACK_IMPORTED_MODULE_5__["default"], {
      width: 14,
      height: 14
    });
  }
  if (arrow && !inverse) {
    trailingIconToUse = /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_svg_icons_arrow_svg__WEBPACK_IMPORTED_MODULE_2__["default"], {
      width: 14,
      height: 14
    });
  }
  if (arrow && inverse) {
    trailingIconToUse = /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_svg_icons_arrow_inverse_svg__WEBPACK_IMPORTED_MODULE_3__["default"], {
      width: 14,
      height: 14
    });
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsxs)(LinkComponent, {
    "aria-label": ariaLabel,
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-cta-link', className, {
      'googlesitekit-cta-link--secondary': secondary,
      'googlesitekit-cta-link--inverse': inverse,
      'googlesitekit-cta-link--small': small,
      'googlesitekit-cta-link--caps': caps,
      'googlesitekit-cta-link--danger': danger,
      'googlesitekit-cta-link--disabled': disabled,
      'googlesitekit-cta-link--standalone': standalone,
      'googlesitekit-cta-link--link-button': linkButton,
      'googlesitekit-cta-link--no-flex': !!noFlex
    }),
    disabled: disabled,
    href: (type === LINK || type === EXTERNAL_LINK) && !disabled ? href : undefined,
    onClick: onClick,
    rel: type === EXTERNAL_LINK ? 'noopener noreferrer' : undefined,
    ref: ref,
    target: type === EXTERNAL_LINK ? '_blank' : undefined,
    to: to,
    ...otherProps,
    children: [!!leadingIconToUse && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_IconWrapper__WEBPACK_IMPORTED_MODULE_6__["default"], {
      marginRight: 5,
      children: leadingIconToUse
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)("span", {
      className: "googlesitekit-cta-link__contents",
      children: children
    }), !!trailingIconToUse && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_IconWrapper__WEBPACK_IMPORTED_MODULE_6__["default"], {
      marginLeft: 5,
      children: trailingIconToUse
    })]
  });
});
Link.propTypes = {
  arrow: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().bool),
  back: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().bool),
  caps: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().bool),
  children: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().node),
  className: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().string),
  danger: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().bool),
  disabled: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().bool),
  external: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().bool),
  hideExternalIndicator: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().bool),
  href: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().string),
  inverse: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().bool),
  leadingIcon: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().node),
  linkButton: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().bool),
  noFlex: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().bool),
  onClick: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().func),
  small: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().bool),
  standalone: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().bool),
  to: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().string),
  trailingIcon: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().node)
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Link);

/***/ }),

/***/ "./js/components/Notice/CTAButton.js":
/*!*******************************************!*\
  !*** ./js/components/Notice/CTAButton.js ***!
  \*******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ CTAButton)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! googlesitekit-components */ "googlesitekit-components");
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_components__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _svg_icons_external_svg__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/svg/icons/external.svg */ "./svg/icons/external.svg");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * Internal dependencies
 */



function CTAButton({
  label,
  disabled,
  inProgress,
  onClick,
  href,
  external,
  hideExternalIndicator
}) {
  let trailingIconToUse;
  if (external && !hideExternalIndicator) {
    trailingIconToUse = /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)(_svg_icons_external_svg__WEBPACK_IMPORTED_MODULE_1__["default"], {
      width: 14,
      height: 14
    });
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_0__.SpinnerButton, {
    className: "googlesitekit-notice__cta",
    disabled: disabled,
    isSaving: inProgress,
    onClick: onClick,
    href: href,
    target: external ? '_blank' : '_self',
    trailingIcon: trailingIconToUse,
    children: label
  });
}
CTAButton.propTypes = {
  label: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string).isRequired,
  disabled: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().bool),
  inProgress: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().bool),
  onClick: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().func),
  href: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  external: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().bool),
  hideExternalIndicator: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().bool)
};

/***/ }),

/***/ "./js/components/Notice/Description.js":
/*!*********************************************!*\
  !*** ./js/components/Notice/Description.js ***!
  \*********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Description)
/* harmony export */ });
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



function Description({
  className,
  children
}) {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("p", {
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-notice__description', className),
    children: children
  });
}
Description.propTypes = {
  className: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().string),
  children: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().node)
};

/***/ }),

/***/ "./js/components/Notice/DismissButton.js":
/*!***********************************************!*\
  !*** ./js/components/Notice/DismissButton.js ***!
  \***********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ DismissButton)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-components */ "googlesitekit-components");
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */


function DismissButton({
  label = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Got it', 'google-site-kit'),
  onClick,
  disabled
}) {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__.Button, {
    onClick: onClick,
    disabled: disabled,
    tertiary: true,
    children: label
  });
}
DismissButton.propTypes = {
  label: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  onClick: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().func).isRequired,
  disabled: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().bool)
};

/***/ }),

/***/ "./js/components/Notice/Icon.js":
/*!**************************************!*\
  !*** ./js/components/Notice/Icon.js ***!
  \**************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Icon)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _svg_icons_check_fill_svg__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @/svg/icons/check-fill.svg */ "./svg/icons/check-fill.svg");
/* harmony import */ var _svg_icons_warning_notice_svg__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/svg/icons/warning-notice.svg */ "./svg/icons/warning-notice.svg");
/* harmony import */ var _svg_icons_star_fill_svg__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/svg/icons/star-fill.svg */ "./svg/icons/star-fill.svg");
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./constants */ "./js/components/Notice/constants.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * Internal dependencies
 */





const typeIconMap = {
  [_constants__WEBPACK_IMPORTED_MODULE_3__.TYPES.NEW]: _svg_icons_star_fill_svg__WEBPACK_IMPORTED_MODULE_2__["default"],
  [_constants__WEBPACK_IMPORTED_MODULE_3__.TYPES.SUCCESS]: _svg_icons_check_fill_svg__WEBPACK_IMPORTED_MODULE_0__["default"],
  [_constants__WEBPACK_IMPORTED_MODULE_3__.TYPES.INFO]: _svg_icons_warning_notice_svg__WEBPACK_IMPORTED_MODULE_1__["default"],
  [_constants__WEBPACK_IMPORTED_MODULE_3__.TYPES.WARNING]: _svg_icons_warning_notice_svg__WEBPACK_IMPORTED_MODULE_1__["default"],
  [_constants__WEBPACK_IMPORTED_MODULE_3__.TYPES.ERROR]: _svg_icons_warning_notice_svg__WEBPACK_IMPORTED_MODULE_1__["default"]
};
function Icon({
  type
}) {
  const IconComponent = typeIconMap[type] || _svg_icons_warning_notice_svg__WEBPACK_IMPORTED_MODULE_1__["default"];
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(IconComponent, {
    width: 24,
    height: 24
  });
}
Icon.propTypes = {
  type: prop_types__WEBPACK_IMPORTED_MODULE_5___default().oneOf(Object.values(_constants__WEBPACK_IMPORTED_MODULE_3__.TYPES))
};

/***/ }),

/***/ "./js/components/Notice/Title.js":
/*!***************************************!*\
  !*** ./js/components/Notice/Title.js ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Title)
/* harmony export */ });
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



function Title({
  className,
  children
}) {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("p", {
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-notice__title', className),
    children: children
  });
}
Title.propTypes = {
  className: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().string),
  children: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().node)
};

/***/ }),

/***/ "./js/components/Notice/constants.js":
/*!*******************************************!*\
  !*** ./js/components/Notice/constants.js ***!
  \*******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   TYPES: () => (/* binding */ TYPES)
/* harmony export */ });
/**
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

const TYPES = {
  NEW: 'new',
  SUCCESS: 'success',
  WARNING: 'warning',
  INFO: 'info',
  ERROR: 'error'
};

/***/ }),

/***/ "./js/components/Notice/index.js":
/*!***************************************!*\
  !*** ./js/components/Notice/index.js ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _Icon__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Icon */ "./js/components/Notice/Icon.js");
/* harmony import */ var _Title__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./Title */ "./js/components/Notice/Title.js");
/* harmony import */ var _Description__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./Description */ "./js/components/Notice/Description.js");
/* harmony import */ var _CTAButton__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./CTAButton */ "./js/components/Notice/CTAButton.js");
/* harmony import */ var _DismissButton__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./DismissButton */ "./js/components/Notice/DismissButton.js");
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./constants */ "./js/components/Notice/constants.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */







const Notice = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_8__.forwardRef)(({
  className,
  title,
  description,
  dismissButton,
  ctaButton,
  type = _constants__WEBPACK_IMPORTED_MODULE_6__.TYPES.INFO,
  children,
  hideIcon
}, ref) => {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsxs)("div", {
    ref: ref,
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-notice', `googlesitekit-notice--${type}`, className),
    children: [!hideIcon && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)("div", {
      className: "googlesitekit-notice__icon",
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_Icon__WEBPACK_IMPORTED_MODULE_1__["default"], {
        type: type
      })
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsxs)("div", {
      className: "googlesitekit-notice__content",
      children: [title && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_Title__WEBPACK_IMPORTED_MODULE_2__["default"], {
        children: title
      }), description && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_Description__WEBPACK_IMPORTED_MODULE_3__["default"], {
        children: description
      })]
    }), (dismissButton?.label || dismissButton?.onClick || ctaButton?.label && (ctaButton?.onClick || ctaButton?.href) || children) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsxs)("div", {
      className: "googlesitekit-notice__action",
      children: [children, (dismissButton?.label || dismissButton?.onClick) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_DismissButton__WEBPACK_IMPORTED_MODULE_5__["default"], {
        label: dismissButton.label,
        onClick: dismissButton.onClick,
        disabled: dismissButton.disabled
      }), ctaButton?.label && (ctaButton?.onClick || ctaButton?.href) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_CTAButton__WEBPACK_IMPORTED_MODULE_4__["default"], {
        label: ctaButton.label,
        onClick: ctaButton.onClick,
        inProgress: ctaButton.inProgress,
        disabled: ctaButton.disabled,
        href: ctaButton.href,
        external: ctaButton.external,
        hideExternalIndicator: ctaButton.hideExternalIndicator
      })]
    })]
  });
});
Notice.TYPES = _constants__WEBPACK_IMPORTED_MODULE_6__.TYPES;
Notice.propTypes = {
  className: (prop_types__WEBPACK_IMPORTED_MODULE_9___default().string),
  title: prop_types__WEBPACK_IMPORTED_MODULE_9___default().oneOfType([(prop_types__WEBPACK_IMPORTED_MODULE_9___default().string), (prop_types__WEBPACK_IMPORTED_MODULE_9___default().object)]),
  description: (prop_types__WEBPACK_IMPORTED_MODULE_9___default().node),
  type: prop_types__WEBPACK_IMPORTED_MODULE_9___default().oneOf(Object.values(_constants__WEBPACK_IMPORTED_MODULE_6__.TYPES)),
  dismissButton: prop_types__WEBPACK_IMPORTED_MODULE_9___default().shape(_DismissButton__WEBPACK_IMPORTED_MODULE_5__["default"].propTypes),
  ctaButton: prop_types__WEBPACK_IMPORTED_MODULE_9___default().shape({
    ..._CTAButton__WEBPACK_IMPORTED_MODULE_4__["default"].propTypes,
    label: (prop_types__WEBPACK_IMPORTED_MODULE_9___default().string) // CTAButton label should not be required for this parent component.
  }),
  children: (prop_types__WEBPACK_IMPORTED_MODULE_9___default().node),
  hideIcon: (prop_types__WEBPACK_IMPORTED_MODULE_9___default().bool)
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Notice);

/***/ }),

/***/ "./js/components/PreviewBlock.js":
/*!***************************************!*\
  !*** ./js/components/PreviewBlock.js ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/hooks/useBreakpoint */ "./js/hooks/useBreakpoint.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * PreviewBlock component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * Internal dependencies
 */


function PreviewBlock({
  className,
  width,
  height,
  shape,
  padding,
  smallWidth,
  smallHeight,
  tabletWidth,
  tabletHeight,
  desktopWidth,
  desktopHeight
}) {
  const breakpoint = (0,_js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_1__.useBreakpoint)();
  const blockDimensions = {
    width: {
      [_js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_1__.BREAKPOINT_SMALL]: smallWidth,
      [_js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_1__.BREAKPOINT_TABLET]: tabletWidth,
      [_js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_1__.BREAKPOINT_DESKTOP]: desktopWidth,
      [_js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_1__.BREAKPOINT_XLARGE]: desktopWidth
    },
    height: {
      [_js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_1__.BREAKPOINT_SMALL]: smallHeight,
      [_js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_1__.BREAKPOINT_TABLET]: tabletHeight,
      [_js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_1__.BREAKPOINT_DESKTOP]: desktopHeight,
      [_js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_1__.BREAKPOINT_XLARGE]: desktopWidth
    }
  };
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("div", {
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-preview-block', className, {
      'googlesitekit-preview-block--padding': padding
    }),
    style: {
      width: blockDimensions.width[breakpoint] || width,
      height: blockDimensions.height[breakpoint] || height
    },
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("div", {
      className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-preview-block__wrapper', {
        'googlesitekit-preview-block__wrapper--circle': shape === 'circular'
      })
    })
  });
}
PreviewBlock.propTypes = {
  className: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  width: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  height: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  shape: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  padding: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().bool),
  smallWidth: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  smallHeight: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  tabletWidth: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  tabletHeight: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  desktopWidth: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  desktopHeight: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string)
};
PreviewBlock.defaultProps = {
  className: undefined,
  width: '100px',
  height: '100px',
  shape: 'square',
  padding: false,
  smallWidth: undefined,
  smallHeight: undefined,
  tabletWidth: undefined,
  tabletHeight: undefined,
  desktopWidth: undefined,
  desktopHeight: undefined
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (PreviewBlock);

/***/ }),

/***/ "./js/components/PreviewBlocks.js":
/*!****************************************!*\
  !*** ./js/components/PreviewBlocks.js ***!
  \****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _PreviewBlock__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./PreviewBlock */ "./js/components/PreviewBlock.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * PreviewBlocks component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * Internal dependencies
 */


function PreviewBlocks({
  width,
  height,
  shape,
  count,
  smallWidth,
  smallHeight,
  tabletWidth,
  tabletHeight,
  desktopWidth,
  desktopHeight
}) {
  const toReturn = [];
  let i = 0;
  while (i++ < count) {
    toReturn.push(/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)(_PreviewBlock__WEBPACK_IMPORTED_MODULE_0__["default"], {
      width: width,
      height: height,
      shape: shape,
      smallWidth: smallWidth,
      smallHeight: smallHeight,
      tabletWidth: tabletWidth,
      tabletHeight: tabletHeight,
      desktopWidth: desktopWidth,
      desktopHeight: desktopHeight
    }, i));
  }
  return toReturn;
}
PreviewBlocks.propTypes = {
  width: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().string),
  height: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().string),
  shape: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().string),
  count: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().number),
  smallWidth: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().string),
  smallHeight: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().string),
  tabletWidth: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().string),
  tabletHeight: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().string),
  desktopWidth: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().string),
  desktopHeight: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().string)
};
PreviewBlocks.defaultProps = {
  width: '100px',
  height: '100px',
  shape: 'square',
  count: 1
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (PreviewBlocks);

/***/ }),

/***/ "./js/components/ReportErrorActions.js":
/*!*********************************************!*\
  !*** ./js/components/ReportErrorActions.js ***!
  \*********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ ReportErrorActions)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_11___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_11__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/@wordpress/element/build-module/create-interpolate-element.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! googlesitekit-components */ "googlesitekit-components");
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_components__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/googlesitekit/datastore/site/constants */ "./js/googlesitekit/datastore/site/constants.js");
/* harmony import */ var _js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/googlesitekit/modules/datastore/constants */ "./js/googlesitekit/modules/datastore/constants.js");
/* harmony import */ var _js_util_errors__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/util/errors */ "./js/util/errors.js");
/* harmony import */ var _js_hooks_useViewOnly__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @/js/hooks/useViewOnly */ "./js/hooks/useViewOnly.js");
/* harmony import */ var _Link__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./Link */ "./js/components/Link.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * ReportErrorActions component.
 *
 * Site Kit by Google, Copyright 2022 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */








function ReportErrorActions(props) {
  const {
    moduleSlug,
    error,
    GetHelpLink,
    hideGetHelpLink,
    buttonVariant,
    onRetry,
    onRequestAccess,
    getHelpClassName,
    RequestAccessButton,
    RetryButton
  } = props;
  const isViewOnly = (0,_js_hooks_useViewOnly__WEBPACK_IMPORTED_MODULE_6__["default"])();
  const storeName = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_4__.CORE_MODULES).getModuleStoreName(moduleSlug));
  const requestAccessURL = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => typeof select(storeName)?.getServiceEntityAccessURL === 'function' ? select(storeName).getServiceEntityAccessURL() : null);
  const errors = Array.isArray(error) ? error : [error];
  const errorsWithSelectorData = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => errors.map(err => {
    const selectorData = select(storeName)?.getSelectorDataForError(err);
    return {
      ...err,
      selectorData
    };
  }));
  const retryableErrors = errorsWithSelectorData?.filter(err => (0,_js_util_errors__WEBPACK_IMPORTED_MODULE_5__.isErrorRetryable)(err, err.selectorData) && err.selectorData.name === 'getReport');
  const showRetry = !!retryableErrors.length;
  const errorTroubleshootingLinkURL = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => {
    const err = {
      ...(showRetry ? retryableErrors[0] : errors[0])
    };
    if ((0,_js_util_errors__WEBPACK_IMPORTED_MODULE_5__.isInsufficientPermissionsError)(err)) {
      err.code = `${moduleSlug}_insufficient_permissions`;
    }
    return select(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_SITE).getErrorTroubleshootingLinkURL(err);
  });
  const dispatch = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useDispatch)();
  const hasInsufficientPermissionsError = errors.some(err => (0,_js_util_errors__WEBPACK_IMPORTED_MODULE_5__.isInsufficientPermissionsError)(err));
  const handleRetry = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.useCallback)(() => {
    retryableErrors.forEach(err => {
      const {
        selectorData
      } = err;
      dispatch(selectorData.storeName).invalidateResolution(selectorData.name, selectorData.args);
    });
    onRetry?.();
  }, [dispatch, retryableErrors, onRetry]);
  const showRequestAccessURL = requestAccessURL && hasInsufficientPermissionsError && !isViewOnly;
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsxs)("div", {
    className: "googlesitekit-report-error-actions",
    children: [showRequestAccessURL && (typeof RequestAccessButton === 'function' ? /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(RequestAccessButton, {
      requestAccessURL: requestAccessURL
    }) : /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_2__.Button, {
      onClick: onRequestAccess,
      href: requestAccessURL,
      target: "_blank",
      danger: buttonVariant === 'danger',
      tertiary: buttonVariant === 'tertiary',
      children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Request access', 'google-site-kit')
    })), showRetry && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsxs)(_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.Fragment, {
      children: [typeof RetryButton === 'function' ? /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(RetryButton, {
        handleRetry: handleRetry
      }) : /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_2__.Button, {
        onClick: handleRetry,
        danger: buttonVariant === 'danger',
        tertiary: buttonVariant === 'tertiary',
        children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Retry', 'google-site-kit')
      }), !hideGetHelpLink && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)("span", {
        className: "googlesitekit-error-retry-text",
        children: (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_10__["default"])((0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Retry didn’t work? <HelpLink />', 'google-site-kit'), {
          HelpLink: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(_Link__WEBPACK_IMPORTED_MODULE_7__["default"], {
            href: errorTroubleshootingLinkURL,
            external: true,
            hideExternalIndicator: true,
            children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Get help', 'google-site-kit')
          })
        })
      })]
    }), !showRetry && !hideGetHelpLink && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)("div", {
      className: getHelpClassName,
      children: typeof GetHelpLink === 'function' ? /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(GetHelpLink, {
        linkURL: errorTroubleshootingLinkURL
      }) : /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(_Link__WEBPACK_IMPORTED_MODULE_7__["default"], {
        href: errorTroubleshootingLinkURL,
        external: true,
        hideExternalIndicator: true,
        children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Get help', 'google-site-kit')
      })
    })]
  });
}
ReportErrorActions.propTypes = {
  moduleSlug: (prop_types__WEBPACK_IMPORTED_MODULE_11___default().string).isRequired,
  error: prop_types__WEBPACK_IMPORTED_MODULE_11___default().oneOfType([prop_types__WEBPACK_IMPORTED_MODULE_11___default().arrayOf((prop_types__WEBPACK_IMPORTED_MODULE_11___default().object)), (prop_types__WEBPACK_IMPORTED_MODULE_11___default().object)]).isRequired,
  GetHelpLink: (prop_types__WEBPACK_IMPORTED_MODULE_11___default().elementType),
  hideGetHelpLink: (prop_types__WEBPACK_IMPORTED_MODULE_11___default().bool),
  buttonVariant: (prop_types__WEBPACK_IMPORTED_MODULE_11___default().string),
  onRetry: (prop_types__WEBPACK_IMPORTED_MODULE_11___default().func),
  onRequestAccess: (prop_types__WEBPACK_IMPORTED_MODULE_11___default().func),
  getHelpClassName: (prop_types__WEBPACK_IMPORTED_MODULE_11___default().string),
  RequestAccessButton: (prop_types__WEBPACK_IMPORTED_MODULE_11___default().elementType),
  RetryButton: (prop_types__WEBPACK_IMPORTED_MODULE_11___default().elementType)
};

/***/ }),

/***/ "./js/components/Root/ViewContextContext.js":
/*!**************************************************!*\
  !*** ./js/components/Root/ViewContextContext.js ***!
  \**************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Consumer: () => (/* binding */ Consumer),
/* harmony export */   Provider: () => (/* binding */ Provider),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/**
 * View Context context for React components.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */

const ViewContextContext = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createContext)('');
const {
  Consumer,
  Provider
} = ViewContextContext;
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ViewContextContext);

/***/ }),

/***/ "./js/components/Spinner.js":
/*!**********************************!*\
  !*** ./js/components/Spinner.js ***!
  \**********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Spinner component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * A single module. Keeps track of its own active state and settings.
 */

function Spinner({
  isSaving,
  style = {}
}) {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("span", {
    className: "spinner",
    style: {
      display: isSaving ? 'inline-block' : 'none',
      float: 'none',
      marginTop: '0',
      visibility: 'visible',
      ...style
    }
  });
}
Spinner.propTypes = {
  isSaving: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().bool),
  style: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().object)
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Spinner);

/***/ }),

/***/ "./js/components/Typography/P.js":
/*!***************************************!*\
  !*** ./js/components/Typography/P.js ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ P)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @/js/hooks/useBreakpoint */ "./js/hooks/useBreakpoint.js");
/* harmony import */ var ___WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! . */ "./js/components/Typography/index.js");
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./constants */ "./js/components/Typography/constants.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * Internal dependencies
 */




function P({
  type = _constants__WEBPACK_IMPORTED_MODULE_2__.TYPE_BODY,
  size,
  children,
  ...props
}) {
  const breakpoint = (0,_js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_0__.useBreakpoint)();
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(___WEBPACK_IMPORTED_MODULE_1__["default"], {
    as: "p",
    type: type,
    size: size || (breakpoint === _js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_0__.BREAKPOINT_SMALL ? _constants__WEBPACK_IMPORTED_MODULE_2__.SIZE_SMALL : _constants__WEBPACK_IMPORTED_MODULE_2__.SIZE_MEDIUM),
    ...props,
    children: children
  });
}
P.propTypes = {
  type: prop_types__WEBPACK_IMPORTED_MODULE_4___default().oneOf(_constants__WEBPACK_IMPORTED_MODULE_2__.VALID_TYPES),
  size: prop_types__WEBPACK_IMPORTED_MODULE_4___default().oneOf(_constants__WEBPACK_IMPORTED_MODULE_2__.VALID_SIZES)
};

/***/ }),

/***/ "./js/components/Typography/constants.js":
/*!***********************************************!*\
  !*** ./js/components/Typography/constants.js ***!
  \***********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   SIZE_LARGE: () => (/* binding */ SIZE_LARGE),
/* harmony export */   SIZE_MEDIUM: () => (/* binding */ SIZE_MEDIUM),
/* harmony export */   SIZE_SMALL: () => (/* binding */ SIZE_SMALL),
/* harmony export */   TYPE_BODY: () => (/* binding */ TYPE_BODY),
/* harmony export */   TYPE_DISPLAY: () => (/* binding */ TYPE_DISPLAY),
/* harmony export */   TYPE_HEADLINE: () => (/* binding */ TYPE_HEADLINE),
/* harmony export */   TYPE_LABEL: () => (/* binding */ TYPE_LABEL),
/* harmony export */   TYPE_TITLE: () => (/* binding */ TYPE_TITLE),
/* harmony export */   VALID_SIZES: () => (/* binding */ VALID_SIZES),
/* harmony export */   VALID_TYPES: () => (/* binding */ VALID_TYPES)
/* harmony export */ });
/**
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

const TYPE_DISPLAY = 'display';
const TYPE_HEADLINE = 'headline';
const TYPE_TITLE = 'title';
const TYPE_BODY = 'body';
const TYPE_LABEL = 'label';
const VALID_TYPES = [TYPE_BODY, TYPE_DISPLAY, TYPE_HEADLINE, TYPE_LABEL, TYPE_TITLE];
const SIZE_SMALL = 'small';
const SIZE_MEDIUM = 'medium';
const SIZE_LARGE = 'large';
const VALID_SIZES = [SIZE_SMALL, SIZE_MEDIUM, SIZE_LARGE];

/***/ }),

/***/ "./js/components/Typography/index.js":
/*!*******************************************!*\
  !*** ./js/components/Typography/index.js ***!
  \*******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Typography)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./constants */ "./js/components/Typography/constants.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * Internal dependencies
 */


function Typography({
  className,
  type,
  size,
  as: Component = 'span',
  children,
  ...props
}) {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)(Component, {
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-typography', className, {
      [`googlesitekit-typography--${type}`]: type && _constants__WEBPACK_IMPORTED_MODULE_1__.VALID_TYPES.includes(type),
      [`googlesitekit-typography--${size}`]: size && _constants__WEBPACK_IMPORTED_MODULE_1__.VALID_SIZES.includes(size)
    }),
    ...props,
    children: children
  });
}
Typography.propTypes = {
  className: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  type: prop_types__WEBPACK_IMPORTED_MODULE_3___default().oneOf(_constants__WEBPACK_IMPORTED_MODULE_1__.VALID_TYPES),
  size: prop_types__WEBPACK_IMPORTED_MODULE_3___default().oneOf(_constants__WEBPACK_IMPORTED_MODULE_1__.VALID_SIZES),
  as: prop_types__WEBPACK_IMPORTED_MODULE_3___default().oneOfType([(prop_types__WEBPACK_IMPORTED_MODULE_3___default().string), (prop_types__WEBPACK_IMPORTED_MODULE_3___default().elementType)])
};

/***/ }),

/***/ "./js/features/index.js":
/*!******************************!*\
  !*** ./js/features/index.js ***!
  \******************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   enabledFeatures: () => (/* binding */ enabledFeatures),
/* harmony export */   isFeatureEnabled: () => (/* binding */ isFeatureEnabled)
/* harmony export */ });
/**
 * Feature flags.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

const enabledFeatures = new Set(__webpack_require__.g?._googlesitekitBaseData?.enabledFeatures || []);

/**
 * Returns true if a feature is enabled; false otherwise.
 *
 * @since 1.25.0
 * @since 1.33.0 Changed _enabledFeatures argument to be a `Set` instead of `Array`.
 *
 * @param {string} feature            The name of the feature to check.
 * @param {Set}    [_enabledFeatures] Optional. The set of enabled features. Uses `enabledFeatures` set by the server in a global JS variable, by default.
 * @return {boolean} `true` if a feature is enabled; `false` otherwise.
 */
function isFeatureEnabled(feature, _enabledFeatures = enabledFeatures) {
  if (!(_enabledFeatures instanceof Set)) {
    return false;
  }
  return _enabledFeatures.has(feature);
}

/***/ }),

/***/ "./js/googlesitekit-modules-pagespeed-insights.js":
/*!********************************************************!*\
  !*** ./js/googlesitekit-modules-pagespeed-insights.js ***!
  \********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var googlesitekit_modules__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-modules */ "googlesitekit-modules");
/* harmony import */ var googlesitekit_modules__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_modules__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var googlesitekit_widgets__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! googlesitekit-widgets */ "googlesitekit-widgets");
/* harmony import */ var googlesitekit_widgets__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_widgets__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var googlesitekit_notifications__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! googlesitekit-notifications */ "googlesitekit-notifications");
/* harmony import */ var googlesitekit_notifications__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_notifications__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _modules_pagespeed_insights__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./modules/pagespeed-insights */ "./js/modules/pagespeed-insights/index.js");
/**
 * PageSpeed Insights module entrypoint.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Internal dependencies
 */





(0,_modules_pagespeed_insights__WEBPACK_IMPORTED_MODULE_4__.registerStore)((googlesitekit_data__WEBPACK_IMPORTED_MODULE_0___default()));
(0,_modules_pagespeed_insights__WEBPACK_IMPORTED_MODULE_4__.registerModule)((googlesitekit_modules__WEBPACK_IMPORTED_MODULE_1___default()));
(0,_modules_pagespeed_insights__WEBPACK_IMPORTED_MODULE_4__.registerWidgets)((googlesitekit_widgets__WEBPACK_IMPORTED_MODULE_2___default()));
(0,_modules_pagespeed_insights__WEBPACK_IMPORTED_MODULE_4__.registerNotifications)((googlesitekit_notifications__WEBPACK_IMPORTED_MODULE_3___default()));

/***/ }),

/***/ "./js/googlesitekit/constants.js":
/*!***************************************!*\
  !*** ./js/googlesitekit/constants.js ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ANCHOR_ID_CONTENT: () => (/* binding */ ANCHOR_ID_CONTENT),
/* harmony export */   ANCHOR_ID_KEY_METRICS: () => (/* binding */ ANCHOR_ID_KEY_METRICS),
/* harmony export */   ANCHOR_ID_MONETIZATION: () => (/* binding */ ANCHOR_ID_MONETIZATION),
/* harmony export */   ANCHOR_ID_SPEED: () => (/* binding */ ANCHOR_ID_SPEED),
/* harmony export */   ANCHOR_ID_TRAFFIC: () => (/* binding */ ANCHOR_ID_TRAFFIC),
/* harmony export */   SITE_KIT_VIEW_CONTEXTS: () => (/* binding */ SITE_KIT_VIEW_CONTEXTS),
/* harmony export */   SITE_KIT_VIEW_ONLY_CONTEXTS: () => (/* binding */ SITE_KIT_VIEW_ONLY_CONTEXTS),
/* harmony export */   VIEW_CONTEXT_ACTIVATION: () => (/* binding */ VIEW_CONTEXT_ACTIVATION),
/* harmony export */   VIEW_CONTEXT_ADMIN_BAR: () => (/* binding */ VIEW_CONTEXT_ADMIN_BAR),
/* harmony export */   VIEW_CONTEXT_ADMIN_BAR_VIEW_ONLY: () => (/* binding */ VIEW_CONTEXT_ADMIN_BAR_VIEW_ONLY),
/* harmony export */   VIEW_CONTEXT_AD_BLOCKING_RECOVERY: () => (/* binding */ VIEW_CONTEXT_AD_BLOCKING_RECOVERY),
/* harmony export */   VIEW_CONTEXT_ENTITY_DASHBOARD: () => (/* binding */ VIEW_CONTEXT_ENTITY_DASHBOARD),
/* harmony export */   VIEW_CONTEXT_ENTITY_DASHBOARD_VIEW_ONLY: () => (/* binding */ VIEW_CONTEXT_ENTITY_DASHBOARD_VIEW_ONLY),
/* harmony export */   VIEW_CONTEXT_MAIN_DASHBOARD: () => (/* binding */ VIEW_CONTEXT_MAIN_DASHBOARD),
/* harmony export */   VIEW_CONTEXT_MAIN_DASHBOARD_VIEW_ONLY: () => (/* binding */ VIEW_CONTEXT_MAIN_DASHBOARD_VIEW_ONLY),
/* harmony export */   VIEW_CONTEXT_METRIC_SELECTION: () => (/* binding */ VIEW_CONTEXT_METRIC_SELECTION),
/* harmony export */   VIEW_CONTEXT_MODULE: () => (/* binding */ VIEW_CONTEXT_MODULE),
/* harmony export */   VIEW_CONTEXT_MODULE_SETUP: () => (/* binding */ VIEW_CONTEXT_MODULE_SETUP),
/* harmony export */   VIEW_CONTEXT_POSTS_LIST: () => (/* binding */ VIEW_CONTEXT_POSTS_LIST),
/* harmony export */   VIEW_CONTEXT_SETTINGS: () => (/* binding */ VIEW_CONTEXT_SETTINGS),
/* harmony export */   VIEW_CONTEXT_SPLASH: () => (/* binding */ VIEW_CONTEXT_SPLASH),
/* harmony export */   VIEW_CONTEXT_USER_INPUT: () => (/* binding */ VIEW_CONTEXT_USER_INPUT),
/* harmony export */   VIEW_CONTEXT_WP_BLOCK_EDITOR: () => (/* binding */ VIEW_CONTEXT_WP_BLOCK_EDITOR),
/* harmony export */   VIEW_CONTEXT_WP_DASHBOARD: () => (/* binding */ VIEW_CONTEXT_WP_DASHBOARD),
/* harmony export */   VIEW_CONTEXT_WP_DASHBOARD_VIEW_ONLY: () => (/* binding */ VIEW_CONTEXT_WP_DASHBOARD_VIEW_ONLY)
/* harmony export */ });
/**
 * Core constants.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

const VIEW_CONTEXT_MAIN_DASHBOARD = 'mainDashboard';
const VIEW_CONTEXT_ENTITY_DASHBOARD = 'entityDashboard';
const VIEW_CONTEXT_MAIN_DASHBOARD_VIEW_ONLY = 'mainDashboardViewOnly';
const VIEW_CONTEXT_ENTITY_DASHBOARD_VIEW_ONLY = 'entityDashboardViewOnly';
const VIEW_CONTEXT_POSTS_LIST = 'postsList';
const VIEW_CONTEXT_USER_INPUT = 'userInput';
const VIEW_CONTEXT_ACTIVATION = 'activation';
const VIEW_CONTEXT_SPLASH = 'splash';
const VIEW_CONTEXT_ADMIN_BAR = 'adminBar';
const VIEW_CONTEXT_ADMIN_BAR_VIEW_ONLY = 'adminBarViewOnly';
const VIEW_CONTEXT_SETTINGS = 'settings';
const VIEW_CONTEXT_AD_BLOCKING_RECOVERY = 'adBlockingRecovery';
const VIEW_CONTEXT_MODULE = 'module';
const VIEW_CONTEXT_WP_DASHBOARD = 'wpDashboard';
const VIEW_CONTEXT_WP_DASHBOARD_VIEW_ONLY = 'wpDashboardViewOnly';
const VIEW_CONTEXT_MODULE_SETUP = 'moduleSetup';
const VIEW_CONTEXT_METRIC_SELECTION = 'metricSelection';
const VIEW_CONTEXT_WP_BLOCK_EDITOR = 'wpBlockEditor';

// Anchor ID Constants
const ANCHOR_ID_KEY_METRICS = 'key-metrics';
const ANCHOR_ID_TRAFFIC = 'traffic';
const ANCHOR_ID_CONTENT = 'content';
const ANCHOR_ID_SPEED = 'speed';
const ANCHOR_ID_MONETIZATION = 'monetization';

// Site Kit only view contexts
const SITE_KIT_VIEW_CONTEXTS = [VIEW_CONTEXT_MAIN_DASHBOARD, VIEW_CONTEXT_ENTITY_DASHBOARD, VIEW_CONTEXT_MAIN_DASHBOARD_VIEW_ONLY, VIEW_CONTEXT_ENTITY_DASHBOARD_VIEW_ONLY, VIEW_CONTEXT_USER_INPUT, VIEW_CONTEXT_SPLASH, VIEW_CONTEXT_SETTINGS, VIEW_CONTEXT_MODULE_SETUP, VIEW_CONTEXT_METRIC_SELECTION];

// Site Kit view-only contexts
const SITE_KIT_VIEW_ONLY_CONTEXTS = [VIEW_CONTEXT_MAIN_DASHBOARD_VIEW_ONLY, VIEW_CONTEXT_ENTITY_DASHBOARD_VIEW_ONLY, VIEW_CONTEXT_ADMIN_BAR_VIEW_ONLY, VIEW_CONTEXT_WP_DASHBOARD_VIEW_ONLY];

/***/ }),

/***/ "./js/googlesitekit/data/create-error-store.js":
/*!*****************************************************!*\
  !*** ./js/googlesitekit/data/create-error-store.js ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   actions: () => (/* binding */ actions),
/* harmony export */   createErrorStore: () => (/* binding */ createErrorStore),
/* harmony export */   generateErrorKey: () => (/* binding */ generateErrorKey)
/* harmony export */ });
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @wordpress/data */ "../node_modules/@wordpress/data/build-module/factory.js");
/* harmony import */ var invariant__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! invariant */ "../node_modules/invariant/browser.js");
/* harmony import */ var invariant__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(invariant__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var md5__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! md5 */ "../node_modules/md5/md5.js");
/* harmony import */ var md5__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(md5__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _js_util__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/util */ "./js/util/index.js");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__);
/**
 * API function to create fetch store.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */


/**
 * External dependencies
 */


const RECEIVE_ERROR = 'RECEIVE_ERROR';
const CLEAR_ERROR = 'CLEAR_ERROR';
const CLEAR_ERRORS = 'CLEAR_ERRORS';

/**
 * Internal dependencies
 */


function generateErrorKey(baseName, args) {
  if (args && Array.isArray(args)) {
    const stringifiedArgs = args.map(item => {
      return 'object' === typeof item ? (0,_js_util__WEBPACK_IMPORTED_MODULE_2__.stringifyObject)(item) : item;
    });
    return `${baseName}::${md5__WEBPACK_IMPORTED_MODULE_1___default()(JSON.stringify(stringifiedArgs))}`;
  }
  return baseName;
}
const actions = {
  receiveError(error, baseName, args = []) {
    invariant__WEBPACK_IMPORTED_MODULE_0___default()(error, 'error is required.');
    invariant__WEBPACK_IMPORTED_MODULE_0___default()(baseName, 'baseName is required.');
    invariant__WEBPACK_IMPORTED_MODULE_0___default()(args && Array.isArray(args), 'args must be an array.');
    return {
      type: RECEIVE_ERROR,
      payload: {
        error,
        baseName,
        args
      }
    };
  },
  clearError(baseName, args = []) {
    invariant__WEBPACK_IMPORTED_MODULE_0___default()(baseName, 'baseName is required.');
    invariant__WEBPACK_IMPORTED_MODULE_0___default()(args && Array.isArray(args), 'args must be an array.');
    return {
      type: CLEAR_ERROR,
      payload: {
        baseName,
        args
      }
    };
  },
  clearErrors(baseName) {
    return {
      type: CLEAR_ERRORS,
      payload: {
        baseName
      }
    };
  }
};
function createErrorStore(storeName) {
  invariant__WEBPACK_IMPORTED_MODULE_0___default()(storeName, 'storeName must be defined.');
  const initialState = {
    errors: {},
    errorArgs: {}
  };
  const reducer = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__.createReducer)((state, {
    type,
    payload
  }) => {
    switch (type) {
      case RECEIVE_ERROR:
        {
          const {
            baseName,
            args,
            error
          } = payload;
          const key = generateErrorKey(baseName, args);
          state.errors = state.errors || {};
          state.errorArgs = state.errorArgs || {};
          state.errors[key] = error;
          state.errorArgs[key] = args;
          break;
        }
      case CLEAR_ERROR:
        {
          const {
            baseName,
            args
          } = payload;
          const key = generateErrorKey(baseName, args);
          state.errors = state.errors || {};
          state.errorArgs = state.errorArgs || {};
          delete state.errors[key];
          delete state.errorArgs[key];
          break;
        }
      case CLEAR_ERRORS:
        {
          const {
            baseName
          } = payload;
          if (baseName) {
            state.errors = state.errors || {};
            state.errorArgs = state.errorArgs || {};
            for (const key in state.errors) {
              if (key === baseName || key.startsWith(`${baseName}::`)) {
                delete state.errors[key];
                delete state.errorArgs[key];
              }
            }
          } else {
            state.errors = {};
            state.errorArgs = {};
          }
          break;
        }
    }
  });
  const controls = {};
  const resolvers = {};
  const selectors = {
    /**
     * Retrieves the error object from state.
     *
     * Error object has the format:
     *
     * ```
     * {
     *   code: <String>,
     *   message: <String>,
     *   data: <Object>
     * }
     * ```
     *
     * @since 1.15.0
     *
     * @param {Object}      state        Data store's state.
     * @param {string}      selectorName Selector name.
     * @param {Array.<any>} [args]       Arguments passed to selector (default `[]`).
     * @return {(Object|undefined)} Error object if exists, otherwise undefined.
     */
    getErrorForSelector(state, selectorName, args = []) {
      invariant__WEBPACK_IMPORTED_MODULE_0___default()(selectorName, 'selectorName is required.');
      return selectors.getError(state, selectorName, args);
    },
    /**
     * Retrieves the error object from state.
     *
     *```
     * {
     *   code: <String>,
     *   message: <String>,
     *   data: <Object>
     * }
     * ```
     *
     * @since 1.15.0
     *
     * @param {Object}      state      Data store's state.
     * @param {string}      actionName Action name.
     * @param {Array.<any>} [args]     Arguments passed to action (default `[]`).
     * @return {(Object|undefined)} Error object if exists, otherwise undefined.
     */
    getErrorForAction(state, actionName, args = []) {
      invariant__WEBPACK_IMPORTED_MODULE_0___default()(actionName, 'actionName is required.');
      return selectors.getError(state, actionName, args);
    },
    /**
     * Retrieves the error object from state.
     *
     *```
     * {
     *   code: <String>,
     *   message: <String>,
     *   data: <Object>
     * }
     * ```
     *
     * @since 1.15.0
     * @private
     *
     * @param {Object}      state      Data store's state.
     * @param {string}      [baseName] Selector or action name.
     * @param {Array.<any>} [args]     Arguments array.
     * @return {(Object|undefined)} Error object if exists, otherwise undefined.
     */
    getError(state, baseName, args) {
      const {
        errors
      } = state;
      invariant__WEBPACK_IMPORTED_MODULE_0___default()(baseName, 'baseName is required.');
      return errors[generateErrorKey(baseName, args)];
    },
    /**
     * Gets a list of all unique errors.
     *
     * @since 1.19.0
     *
     * @param {Object} state Data store's state.
     * @return {Object[]} Unique set of errors.
     */
    getErrors(state) {
      const errorsSet = new Set(Object.values(state.errors));
      return Array.from(errorsSet);
    },
    /**
     * Gets the meta-data for a given error object, or null if the error is not found.
     *
     * Returns meta-data in the format:
     *
     * ```
     *	{
     *		baseName: <string>,
     *		args: <Array>
     *	}
     * ```
     *
     * @since 1.84.0
     *
     * @param {Object} state Data store's state.
     * @param {Object} error Error object.
     * @return {Object|null} Meta-data for the given error object, or null if the error is not found.
     */
    getMetaDataForError(state, error) {
      const key = Object.keys(state.errors).find(errorKey => state.errors[errorKey] === error);
      if (key) {
        const baseName = key.substring(0, key.indexOf('::'));
        return {
          baseName,
          args: state.errorArgs[key]
        };
      }
      return null;
    },
    /**
     * Gets the selector data for a given error object, or null if no selector data is available.
     *
     * Returns selector data in the format:
     *
     * ```
     *	{
     *		storeName: <string>,
     *		name: <string>,
     *		args: <Array>
     *	}
     * ```
     *
     * @since 1.87.0
     *
     * @param {Object} state Data store's state.
     * @param {Object} error Error object.
     * @return {Object|null} Selector data for the given error object, or null if no selector data is available.
     */
    getSelectorDataForError: (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_4__.createRegistrySelector)(select => function (state, error) {
      const metaData = select(storeName).getMetaDataForError(error);
      if (metaData) {
        const {
          baseName: name,
          args
        } = metaData;
        const isSelector = !!select(storeName)[name];
        if (isSelector) {
          return {
            storeName,
            name,
            args
          };
        }
      }
      return null;
    }),
    /**
     * Determines whether the datastore has errors or not.
     *
     * @since 1.15.0
     *
     * @param {Object} state Data store's state.
     * @return {boolean} TRUE if the datastore has errors, otherwise FALSE.
     */
    hasErrors(state) {
      return selectors.getErrors(state).length > 0;
    }
  };
  return {
    initialState,
    actions,
    controls,
    reducer,
    resolvers,
    selectors
  };
}

/***/ }),

/***/ "./js/googlesitekit/data/create-fetch-store.js":
/*!*****************************************************!*\
  !*** ./js/googlesitekit/data/create-fetch-store.js ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   createFetchStore: () => (/* binding */ createFetchStore)
/* harmony export */ });
/* harmony import */ var invariant__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! invariant */ "../node_modules/invariant/browser.js");
/* harmony import */ var invariant__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(invariant__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! lodash */ "../node_modules/lodash/lodash.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _create_error_store__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./create-error-store */ "./js/googlesitekit/data/create-error-store.js");
/* harmony import */ var _transform_case__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./transform-case */ "./js/googlesitekit/data/transform-case.js");
/* harmony import */ var _js_util__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/util */ "./js/util/index.js");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_5__);
/**
 * API function to create fetch store.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * Internal dependencies
 */




function defaultReducerCallback(state) {
  return state;
}
function defaultArgsToParams() {
  return {};
}
function defaultValidateParams() {}

// Get access to error store action creators.
// If the parent store doesn't include the error store,
// yielded error actions will be a no-op.
const {
  clearError,
  receiveError
} = _create_error_store__WEBPACK_IMPORTED_MODULE_2__.actions;

/**
 * Creates a store object implementing the necessary infrastructure for a
 * single fetch action.
 *
 * This function returns a partial store object with the following:
 * * action creators to fetch and to receive the data
 * * control to issue the API request
 * * reducer to set API request flag and receive the response
 * * selector to check whether the API request is in progress via a flag
 *
 * The names of the pieces are based on the baseName provided.
 * For example, if baseName is 'saveSettings':
 * * The fetch action creator is called 'fetchSaveSettings'.
 * * The receive action creator is called 'receiveSaveSettings'.
 * * The fetching selector is called 'isFetchingSaveSettings'.
 *
 * All parts of the returned store objects should be considered internal. A
 * public action or selector should be implemented to actually call the
 * fetch action included in the returned store object.
 *
 * For example, if the fetch store is intended for an API-based
 * action 'storeMySetting':
 * * The basename passed should be 'storeMySetting'.
 * * The action 'storeMySetting' should call 'fetchStoreMySetting'.
 *
 * Or, if the fetch store is intended for an API-based selector
 * 'getSomeData':
 * * The baseName passed should be 'getSomeData'.
 * * The resolver for 'getSomeData' should call 'fetchGetSomeData'.
 *
 * @since 1.10.0
 * @private
 *
 * @param {Object}   args                   Arguments for creating the fetch store.
 * @param {string}   args.baseName          The base name to use for all the created infrastructure.
 * @param {Function} args.controlCallback   Callback function to issue the API request. Will be used inside the
 *                                          control. The function receives a params object based on argsToParams,
 *                                          i.e. the respective values passed to the action.
 * @param {Function} [args.reducerCallback] Optional. Callback function to modify state based on the API response.
 *                                          Will be used inside the reducer. The function receives the store's state
 *                                          object as first parameter, the API response as second parameter, and the
 *                                          params object for the request (see above) as third parameter. If not
 *                                          provided, the default will return the unmodified state.
 * @param {Function} [args.argsToParams]    Optional. Function that reduces the given list of arguments
 *                                          into a object of key/value parameters, with the argument names used as keys.
 *                                          If not provided, the default function will return an empty object,
 *                                          essentially indicating that no arguments are supported/required.
 * @param {Function} [args.validateParams]  Optional. Function that validates the given parameters object created by `argsToParams`.
 *                                          Any invalid parameters should cause a respective error to be thrown.
 * @return {Object} Partial store object with properties 'actions', 'controls', 'reducer', 'resolvers', and 'selectors'.
 */
function createFetchStore({
  baseName,
  controlCallback,
  reducerCallback = defaultReducerCallback,
  argsToParams = defaultArgsToParams,
  validateParams = defaultValidateParams
}) {
  invariant__WEBPACK_IMPORTED_MODULE_0___default()(baseName, 'baseName is required.');
  invariant__WEBPACK_IMPORTED_MODULE_0___default()('function' === typeof controlCallback, 'controlCallback is required and must be a function.');
  invariant__WEBPACK_IMPORTED_MODULE_0___default()('function' === typeof reducerCallback, 'reducerCallback must be a function.');
  invariant__WEBPACK_IMPORTED_MODULE_0___default()('function' === typeof argsToParams, 'argsToParams must be a function.');
  invariant__WEBPACK_IMPORTED_MODULE_0___default()('function' === typeof validateParams, 'validateParams must be a function.');

  // If validating the result of argsToParams without any arguments does not result in an error, we
  // know params is okay to be empty.
  let requiresParams;
  try {
    validateParams(argsToParams());
    requiresParams = false;
  } catch (error) {
    requiresParams = true;
  }
  const pascalCaseBaseName = (0,_transform_case__WEBPACK_IMPORTED_MODULE_3__.camelCaseToPascalCase)(baseName);
  const constantBaseName = (0,_transform_case__WEBPACK_IMPORTED_MODULE_3__.camelCaseToConstantCase)(baseName);
  const FETCH = `FETCH_${constantBaseName}`;
  const START_FETCH = `START_${FETCH}`;
  const FINISH_FETCH = `FINISH_${FETCH}`;
  const CATCH_FETCH = `CATCH_${FETCH}`;
  const RECEIVE = `RECEIVE_${constantBaseName}`;
  const fetchCreator = `fetch${pascalCaseBaseName}`;
  const receiveCreator = `receive${pascalCaseBaseName}`;
  const isFetching = `isFetching${pascalCaseBaseName}`;
  const initialState = {
    [isFetching]: {}
  };
  function* fetchGenerator(params, args) {
    let response;
    let error;
    yield {
      payload: {
        params
      },
      type: START_FETCH
    };
    yield clearError(baseName, args);
    try {
      response = yield {
        payload: {
          params
        },
        type: FETCH
      };
      yield actions[receiveCreator](response, params);
      yield {
        payload: {
          params
        },
        type: FINISH_FETCH
      };
    } catch (e) {
      error = e;
      yield receiveError(error, baseName, args);
      yield {
        payload: {
          params
        },
        type: CATCH_FETCH
      };
    }
    return {
      response,
      error
    };
  }
  const actions = {
    [fetchCreator](...args) {
      const params = argsToParams(...args);
      // In order for params validation to throw an error as expected,
      // this function cannot be a generator.
      validateParams(params);

      // The normal fetch action generator is invoked as the return here
      // to preserve asynchronous behavior without registering another action creator.
      return fetchGenerator(params, args);
    },
    [receiveCreator](response, params) {
      invariant__WEBPACK_IMPORTED_MODULE_0___default()(response !== undefined, 'response is required.');
      if (requiresParams) {
        invariant__WEBPACK_IMPORTED_MODULE_0___default()((0,lodash__WEBPACK_IMPORTED_MODULE_1__.isPlainObject)(params), 'params is required.');
        validateParams(params);
      } else {
        params = {};
      }
      return {
        payload: {
          response,
          params
        },
        type: RECEIVE
      };
    }
  };
  const controls = {
    [FETCH]: ({
      payload
    }) => {
      return controlCallback(payload.params);
    }
  };
  const reducer = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_5__.createReducer)((state, {
    type,
    payload
  }) => {
    switch (type) {
      case START_FETCH:
        {
          const {
            params
          } = payload;
          state[isFetching] = state[isFetching] || {};
          state[isFetching][(0,_js_util__WEBPACK_IMPORTED_MODULE_4__.stringifyObject)(params)] = true;
          return state;
        }
      case RECEIVE:
        {
          const {
            response,
            params
          } = payload;
          return reducerCallback(state, response, params);
        }
      case FINISH_FETCH:
        {
          const {
            params
          } = payload;
          state[isFetching] = state[isFetching] || {};
          state[isFetching][(0,_js_util__WEBPACK_IMPORTED_MODULE_4__.stringifyObject)(params)] = false;
          return state;
        }
      case CATCH_FETCH:
        {
          const {
            params
          } = payload;
          state[isFetching] = state[isFetching] || {};
          state[isFetching][(0,_js_util__WEBPACK_IMPORTED_MODULE_4__.stringifyObject)(params)] = false;
          return state;
        }
      default:
        return state;
    }
  });
  const selectors = {
    [isFetching]: (state, ...args) => {
      if (state[isFetching] === undefined) {
        return false;
      }
      let params;
      try {
        params = argsToParams(...args);
        validateParams(params);
      } catch (err) {
        // If parameters are invalid, fail silently here. It likely is
        // because some dependency selector is still resolving.
        return false;
      }
      return !!state[isFetching][(0,_js_util__WEBPACK_IMPORTED_MODULE_4__.stringifyObject)(params)];
    }
  };
  return {
    initialState,
    actions,
    controls,
    reducer,
    resolvers: {},
    selectors
  };
}

/***/ }),

/***/ "./js/googlesitekit/data/transform-case.js":
/*!*************************************************!*\
  !*** ./js/googlesitekit/data/transform-case.js ***!
  \*************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   camelCaseToConstantCase: () => (/* binding */ camelCaseToConstantCase),
/* harmony export */   camelCaseToPascalCase: () => (/* binding */ camelCaseToPascalCase),
/* harmony export */   hyphenCaseToPascalCase: () => (/* binding */ hyphenCaseToPascalCase)
/* harmony export */ });
/**
 * Data store utilities for transforming names to a certain case.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Transforms a camelCase name into its PascalCase name.
 *
 * @since 1.10.0
 * @private
 *
 * @param {string} name "camelCase" name to transform.
 * @return {string} PascalCase name.
 */
function camelCaseToPascalCase(name) {
  return name.charAt(0).toUpperCase() + name.slice(1);
}

/**
 * Transforms a camelCase name into its CONSTANT_CASE name.
 *
 * @since 1.10.0
 * @private
 *
 * @param {string} name "camelCase" name to transform.
 * @return {string} CONSTANT_CASE name.
 */
function camelCaseToConstantCase(name) {
  return name.replace(/([a-z0-9]{1})([A-Z]{1})/g, '$1_$2').toUpperCase();
}

/**
 * Transforms a hyphen-case name into its PascalCase name.
 *
 * @since 1.30.0
 * @private
 *
 * @param {string} name "hyphen-case" name to transform.
 * @return {string} PascalCase name.
 */
function hyphenCaseToPascalCase(name) {
  return name.split('-').map(part => part.charAt(0).toUpperCase() + part.slice(1)).join('');
}

/***/ }),

/***/ "./js/googlesitekit/datastore/site/constants.js":
/*!******************************************************!*\
  !*** ./js/googlesitekit/datastore/site/constants.js ***!
  \******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   AMP_MODE_PRIMARY: () => (/* binding */ AMP_MODE_PRIMARY),
/* harmony export */   AMP_MODE_SECONDARY: () => (/* binding */ AMP_MODE_SECONDARY),
/* harmony export */   CORE_SITE: () => (/* binding */ CORE_SITE),
/* harmony export */   GOOGLE_TAG_GATEWAY_MODULES: () => (/* binding */ GOOGLE_TAG_GATEWAY_MODULES)
/* harmony export */ });
/* harmony import */ var _js_modules_ads_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @/js/modules/ads/constants */ "./js/modules/ads/constants.js");
/* harmony import */ var _js_modules_analytics_4_constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/modules/analytics-4/constants */ "./js/modules/analytics-4/constants.js");
/* harmony import */ var _js_modules_tagmanager_constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/modules/tagmanager/constants */ "./js/modules/tagmanager/constants.js");
/**
 * `core/site` data store: constants.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Internal dependencies
 */



const CORE_SITE = 'core/site';
const AMP_MODE_PRIMARY = 'primary';
const AMP_MODE_SECONDARY = 'secondary';
const GOOGLE_TAG_GATEWAY_MODULES = [_js_modules_analytics_4_constants__WEBPACK_IMPORTED_MODULE_1__.MODULE_SLUG_ANALYTICS_4, _js_modules_ads_constants__WEBPACK_IMPORTED_MODULE_0__.MODULE_SLUG_ADS, _js_modules_tagmanager_constants__WEBPACK_IMPORTED_MODULE_2__.MODULE_SLUG_TAGMANAGER];

/***/ }),

/***/ "./js/googlesitekit/datastore/ui/constants.js":
/*!****************************************************!*\
  !*** ./js/googlesitekit/datastore/ui/constants.js ***!
  \****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ACTIVE_CONTEXT_ID: () => (/* binding */ ACTIVE_CONTEXT_ID),
/* harmony export */   CORE_UI: () => (/* binding */ CORE_UI)
/* harmony export */ });
/**
 * `core/ui` data store: constants.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

const CORE_UI = 'core/ui';
const ACTIVE_CONTEXT_ID = 'activeContextID';

/***/ }),

/***/ "./js/googlesitekit/modules/datastore/constants.js":
/*!*********************************************************!*\
  !*** ./js/googlesitekit/modules/datastore/constants.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   CORE_MODULES: () => (/* binding */ CORE_MODULES),
/* harmony export */   ERROR_CODE_INSUFFICIENT_MODULE_DEPENDENCIES: () => (/* binding */ ERROR_CODE_INSUFFICIENT_MODULE_DEPENDENCIES)
/* harmony export */ });
/**
 * `core/modules` data store: constants.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

const CORE_MODULES = 'core/modules';
const ERROR_CODE_INSUFFICIENT_MODULE_DEPENDENCIES = 'insufficient_module_dependencies';

/***/ }),

/***/ "./js/googlesitekit/notifications/components/layout/NoticeNotification.js":
/*!********************************************************************************!*\
  !*** ./js/googlesitekit/notifications/components/layout/NoticeNotification.js ***!
  \********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ NoticeNotification)
/* harmony export */ });
/* harmony import */ var _js_components_Notice__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @/js/components/Notice */ "./js/components/Notice/index.js");
/* harmony import */ var _js_googlesitekit_notifications_hooks_useNotificationEvents__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/googlesitekit/notifications/hooks/useNotificationEvents */ "./js/googlesitekit/notifications/hooks/useNotificationEvents.js");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _js_googlesitekit_notifications_datastore_constants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/googlesitekit/notifications/datastore/constants */ "./js/googlesitekit/notifications/datastore/constants.js");
/* harmony import */ var _js_material_components__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/material-components */ "./js/material-components/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Internal dependencies
 */







function NoticeNotification({
  notificationID,
  children,
  dismissButton,
  ctaButton,
  gaTrackingEventArgs,
  ...props
}) {
  const trackEvents = (0,_js_googlesitekit_notifications_hooks_useNotificationEvents__WEBPACK_IMPORTED_MODULE_1__["default"])(notificationID, gaTrackingEventArgs?.category, {
    confirmAction: gaTrackingEventArgs?.confirmAction,
    dismissAction: gaTrackingEventArgs?.dismissAction
  });
  const {
    dismissNotification
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.useDispatch)(_js_googlesitekit_notifications_datastore_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_NOTIFICATIONS);
  async function handleDismissWithTrackEvent(event) {
    await dismissButton?.onClick?.(event);
    trackEvents.dismiss(gaTrackingEventArgs?.label, gaTrackingEventArgs?.value);
    dismissNotification(notificationID, {
      ...(dismissButton?.dismissOptions || {})
    });
  }
  async function handleCTAClickWithTrackEvent(event) {
    await ctaButton?.onClick?.(event);
    trackEvents.confirm(gaTrackingEventArgs?.label, gaTrackingEventArgs?.value);
    if (ctaButton?.dismissOnClick) {
      dismissNotification(notificationID, {
        ...(ctaButton?.dismissOptions || {})
      });
    }
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_js_material_components__WEBPACK_IMPORTED_MODULE_4__.Grid, {
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_js_material_components__WEBPACK_IMPORTED_MODULE_4__.Row, {
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_js_material_components__WEBPACK_IMPORTED_MODULE_4__.Cell, {
        size: 12,
        alignMiddle: true,
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_js_components_Notice__WEBPACK_IMPORTED_MODULE_0__["default"], {
          dismissButton: {
            ...dismissButton,
            onClick: handleDismissWithTrackEvent
          },
          ctaButton: {
            ...ctaButton,
            onClick: handleCTAClickWithTrackEvent
          },
          ...props,
          children: children
        })
      })
    })
  });
}
NoticeNotification.propTypes = {
  notificationID: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().string).isRequired,
  children: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().node),
  dismissButton: prop_types__WEBPACK_IMPORTED_MODULE_6___default().oneOfType([(prop_types__WEBPACK_IMPORTED_MODULE_6___default().bool), (prop_types__WEBPACK_IMPORTED_MODULE_6___default().object)]),
  ctaButton: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().object),
  gaTrackingEventArgs: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().object)
};

/***/ }),

/***/ "./js/googlesitekit/notifications/constants.js":
/*!*****************************************************!*\
  !*** ./js/googlesitekit/notifications/constants.js ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   GTG_AUTO_ENABLE_NOTIFICATION: () => (/* binding */ GTG_AUTO_ENABLE_NOTIFICATION),
/* harmony export */   GTG_HEALTH_CHECK_WARNING_NOTIFICATION_ID: () => (/* binding */ GTG_HEALTH_CHECK_WARNING_NOTIFICATION_ID),
/* harmony export */   NOTIFICATION_AREAS: () => (/* binding */ NOTIFICATION_AREAS),
/* harmony export */   NOTIFICATION_GROUPS: () => (/* binding */ NOTIFICATION_GROUPS),
/* harmony export */   PRIORITY: () => (/* binding */ PRIORITY)
/* harmony export */ });
/**
 * Notifications API constants.
 *
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

const GTG_HEALTH_CHECK_WARNING_NOTIFICATION_ID = 'warning-notification-gtg';
const GTG_AUTO_ENABLE_NOTIFICATION = 'gtg-auto-enable-notification';
const PRIORITY = {
  ERROR_HIGH: 30,
  ERROR_LOW: 60,
  WARNING: 100,
  INFO: 150,
  SETUP_CTA_HIGH: 150,
  SETUP_CTA_LOW: 200
};
const NOTIFICATION_AREAS = {
  HEADER: 'notification-area-header',
  DASHBOARD_TOP: 'notification-area-dashboard-top',
  OVERLAYS: 'notification-area-overlays'
};
const NOTIFICATION_GROUPS = {
  DEFAULT: 'default',
  SETUP_CTAS: 'setup-ctas'
};

/***/ }),

/***/ "./js/googlesitekit/notifications/datastore/constants.js":
/*!***************************************************************!*\
  !*** ./js/googlesitekit/notifications/datastore/constants.js ***!
  \***************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   CORE_NOTIFICATIONS: () => (/* binding */ CORE_NOTIFICATIONS),
/* harmony export */   NOTIFICATION_VIEW_CONTEXTS: () => (/* binding */ NOTIFICATION_VIEW_CONTEXTS)
/* harmony export */ });
/* harmony import */ var _js_googlesitekit_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @/js/googlesitekit/constants */ "./js/googlesitekit/constants.js");
/**
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


const CORE_NOTIFICATIONS = 'core/notifications';
const NOTIFICATION_VIEW_CONTEXTS = [_js_googlesitekit_constants__WEBPACK_IMPORTED_MODULE_0__.VIEW_CONTEXT_SPLASH, _js_googlesitekit_constants__WEBPACK_IMPORTED_MODULE_0__.VIEW_CONTEXT_MAIN_DASHBOARD, _js_googlesitekit_constants__WEBPACK_IMPORTED_MODULE_0__.VIEW_CONTEXT_ENTITY_DASHBOARD, _js_googlesitekit_constants__WEBPACK_IMPORTED_MODULE_0__.VIEW_CONTEXT_MAIN_DASHBOARD_VIEW_ONLY, _js_googlesitekit_constants__WEBPACK_IMPORTED_MODULE_0__.VIEW_CONTEXT_ENTITY_DASHBOARD_VIEW_ONLY];

/***/ }),

/***/ "./js/googlesitekit/notifications/hooks/useNotificationEvents.js":
/*!***********************************************************************!*\
  !*** ./js/googlesitekit/notifications/hooks/useNotificationEvents.js ***!
  \***********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ useNotificationEvents)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @/js/hooks/useViewContext */ "./js/hooks/useViewContext.js");
/* harmony import */ var _js_util__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/util */ "./js/util/index.js");
/**
 * `useNotificationEvents` hook.
 *
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */


function useNotificationEvents(id, category, {
  viewAction = 'view_notification',
  confirmAction = 'confirm_notification',
  dismissAction = 'dismiss_notification',
  clickLearnMoreAction = 'click_learn_more_link'
} = {}) {
  const viewContext = (0,_js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_0__["default"])();
  const eventCategory = category !== null && category !== void 0 ? category : `${viewContext}_${id}`;
  const view = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useCallback)((...args) => {
    return (0,_js_util__WEBPACK_IMPORTED_MODULE_1__.trackEvent)(eventCategory, viewAction, ...args);
  }, [eventCategory, viewAction]);
  const confirm = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useCallback)((...args) => {
    return (0,_js_util__WEBPACK_IMPORTED_MODULE_1__.trackEvent)(eventCategory, confirmAction, ...args);
  }, [eventCategory, confirmAction]);
  const dismiss = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useCallback)((...args) => {
    return (0,_js_util__WEBPACK_IMPORTED_MODULE_1__.trackEvent)(eventCategory, dismissAction, ...args);
  }, [eventCategory, dismissAction]);
  const clickLearnMore = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useCallback)((...args) => {
    return (0,_js_util__WEBPACK_IMPORTED_MODULE_1__.trackEvent)(eventCategory, clickLearnMoreAction, ...args);
  }, [eventCategory, clickLearnMoreAction]);
  return {
    view,
    confirm,
    dismiss,
    clickLearnMore
  };
}

/***/ }),

/***/ "./js/googlesitekit/widgets/default-areas.js":
/*!***************************************************!*\
  !*** ./js/googlesitekit/widgets/default-areas.js ***!
  \***************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   AREA_ENTITY_DASHBOARD_CONTENT_PRIMARY: () => (/* binding */ AREA_ENTITY_DASHBOARD_CONTENT_PRIMARY),
/* harmony export */   AREA_ENTITY_DASHBOARD_MONETIZATION_PRIMARY: () => (/* binding */ AREA_ENTITY_DASHBOARD_MONETIZATION_PRIMARY),
/* harmony export */   AREA_ENTITY_DASHBOARD_SPEED_PRIMARY: () => (/* binding */ AREA_ENTITY_DASHBOARD_SPEED_PRIMARY),
/* harmony export */   AREA_ENTITY_DASHBOARD_TRAFFIC_PRIMARY: () => (/* binding */ AREA_ENTITY_DASHBOARD_TRAFFIC_PRIMARY),
/* harmony export */   AREA_MAIN_DASHBOARD_CONTENT_PRIMARY: () => (/* binding */ AREA_MAIN_DASHBOARD_CONTENT_PRIMARY),
/* harmony export */   AREA_MAIN_DASHBOARD_KEY_METRICS_PRIMARY: () => (/* binding */ AREA_MAIN_DASHBOARD_KEY_METRICS_PRIMARY),
/* harmony export */   AREA_MAIN_DASHBOARD_MONETIZATION_PRIMARY: () => (/* binding */ AREA_MAIN_DASHBOARD_MONETIZATION_PRIMARY),
/* harmony export */   AREA_MAIN_DASHBOARD_SPEED_PRIMARY: () => (/* binding */ AREA_MAIN_DASHBOARD_SPEED_PRIMARY),
/* harmony export */   AREA_MAIN_DASHBOARD_TRAFFIC_AUDIENCE_SEGMENTATION: () => (/* binding */ AREA_MAIN_DASHBOARD_TRAFFIC_AUDIENCE_SEGMENTATION),
/* harmony export */   AREA_MAIN_DASHBOARD_TRAFFIC_PRIMARY: () => (/* binding */ AREA_MAIN_DASHBOARD_TRAFFIC_PRIMARY),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/**
 * Widgets API default areas
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// Main dashboard
const AREA_MAIN_DASHBOARD_KEY_METRICS_PRIMARY = 'mainDashboardKeyMetricsPrimary';
const AREA_MAIN_DASHBOARD_TRAFFIC_PRIMARY = 'mainDashboardTrafficPrimary';
const AREA_MAIN_DASHBOARD_TRAFFIC_AUDIENCE_SEGMENTATION = 'mainDashboardTrafficAudienceSegmentation';
const AREA_MAIN_DASHBOARD_CONTENT_PRIMARY = 'mainDashboardContentPrimary';
const AREA_MAIN_DASHBOARD_SPEED_PRIMARY = 'mainDashboardSpeedPrimary';
const AREA_MAIN_DASHBOARD_MONETIZATION_PRIMARY = 'mainDashboardMonetizationPrimary';
// Entity dashboard
const AREA_ENTITY_DASHBOARD_TRAFFIC_PRIMARY = 'entityDashboardTrafficPrimary';
const AREA_ENTITY_DASHBOARD_CONTENT_PRIMARY = 'entityDashboardContentPrimary';
const AREA_ENTITY_DASHBOARD_SPEED_PRIMARY = 'entityDashboardSpeedPrimary';
const AREA_ENTITY_DASHBOARD_MONETIZATION_PRIMARY = 'entityDashboardMonetizationPrimary';
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  // Main dashboard
  AREA_MAIN_DASHBOARD_KEY_METRICS_PRIMARY,
  AREA_MAIN_DASHBOARD_TRAFFIC_PRIMARY,
  AREA_MAIN_DASHBOARD_CONTENT_PRIMARY,
  AREA_MAIN_DASHBOARD_SPEED_PRIMARY,
  AREA_MAIN_DASHBOARD_MONETIZATION_PRIMARY,
  // Entity dashboard
  AREA_ENTITY_DASHBOARD_TRAFFIC_PRIMARY,
  AREA_ENTITY_DASHBOARD_CONTENT_PRIMARY,
  AREA_ENTITY_DASHBOARD_SPEED_PRIMARY,
  AREA_ENTITY_DASHBOARD_MONETIZATION_PRIMARY
});

/***/ }),

/***/ "./js/hooks/useBreakpoint.js":
/*!***********************************!*\
  !*** ./js/hooks/useBreakpoint.js ***!
  \***********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   BREAKPOINT_DESKTOP: () => (/* binding */ BREAKPOINT_DESKTOP),
/* harmony export */   BREAKPOINT_SMALL: () => (/* binding */ BREAKPOINT_SMALL),
/* harmony export */   BREAKPOINT_TABLET: () => (/* binding */ BREAKPOINT_TABLET),
/* harmony export */   BREAKPOINT_XLARGE: () => (/* binding */ BREAKPOINT_XLARGE),
/* harmony export */   useBreakpoint: () => (/* binding */ useBreakpoint)
/* harmony export */ });
/* harmony import */ var _useWindowSize__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./useWindowSize */ "./js/hooks/useWindowSize.js");
/**
 * `useBreakpoint` hook.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


const BREAKPOINT_XLARGE = 'xlarge';
const BREAKPOINT_DESKTOP = 'desktop';
const BREAKPOINT_TABLET = 'tablet';
const BREAKPOINT_SMALL = 'small';

/**
 * Retrieves the current breakpoint.
 *
 * @since 1.29.0
 *
 * @return {string} The current breakpoint according to the window size.
 */
function useBreakpoint() {
  const onlyWidth = (0,_useWindowSize__WEBPACK_IMPORTED_MODULE_0__.useWindowWidth)();
  if (onlyWidth > 1280) {
    return BREAKPOINT_XLARGE;
  }
  if (onlyWidth > 960) {
    return BREAKPOINT_DESKTOP;
  }
  if (onlyWidth > 600) {
    return BREAKPOINT_TABLET;
  }
  return BREAKPOINT_SMALL;
}

/***/ }),

/***/ "./js/hooks/useQueryArg.js":
/*!*********************************!*\
  !*** ./js/hooks/useQueryArg.js ***!
  \*********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _wordpress_url__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/url */ "../node_modules/@wordpress/url/build-module/get-query-arg.js");
/* harmony import */ var _wordpress_url__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/url */ "../node_modules/@wordpress/url/build-module/add-query-args.js");
/**
 * `useQueryArg` hook.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */



/**
 * Uses a location query param as a variable in a component.
 *
 * @since 1.24.0
 *
 * @param {string} key            The query param key to be used.
 * @param {string} [initialValue] Optional. The initial value for the query param to be used.
 * @param {Object} [_global]      The global window object.
 * @return {Array} The getter and setter for the query param state.
 */
function useQueryArg(key, initialValue, _global = __webpack_require__.g) {
  const [value, setValue] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.useState)((0,_wordpress_url__WEBPACK_IMPORTED_MODULE_1__.getQueryArg)(_global.location.href, key) || initialValue);
  function onSetValue(newValue) {
    setValue(newValue);
    const newURL = (0,_wordpress_url__WEBPACK_IMPORTED_MODULE_2__.addQueryArgs)(_global.location.href, {
      [key]: newValue
    });
    _global.history.replaceState(null, '', newURL);
  }
  return [value, onSetValue];
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (useQueryArg);

/***/ }),

/***/ "./js/hooks/useViewContext.js":
/*!************************************!*\
  !*** ./js/hooks/useViewContext.js ***!
  \************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _js_components_Root_ViewContextContext__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @/js/components/Root/ViewContextContext */ "./js/components/Root/ViewContextContext.js");
/**
 * `useViewContext` hook.
 *
 * Site Kit by Google, Copyright 2022 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */



/**
 * Returns the current Site Kit viewing context, eg. "dashboard",
 * "entity dashboard", "view-only dashboard", etc.
 *
 * @since 1.74.0
 *
 * @return {string} The current "viewing context" value for the plugin.
 */
function useViewContext() {
  const viewContext = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useContext)(_js_components_Root_ViewContextContext__WEBPACK_IMPORTED_MODULE_0__["default"]);
  return viewContext;
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (useViewContext);

/***/ }),

/***/ "./js/hooks/useViewOnly.js":
/*!*********************************!*\
  !*** ./js/hooks/useViewOnly.js ***!
  \*********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ useViewOnly)
/* harmony export */ });
/* harmony import */ var _js_googlesitekit_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @/js/googlesitekit/constants */ "./js/googlesitekit/constants.js");
/* harmony import */ var _useViewContext__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./useViewContext */ "./js/hooks/useViewContext.js");
/**
 * `useViewOnly` hook.
 *
 * Site Kit by Google, Copyright 2022 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Internal dependencies
 */



/**
 * Determines if the current view context is a "view only" dashboard context.
 *
 * @since 1.72.0
 *
 * @return {boolean} True if current context is a view-only dashboard context, false otherwise.
 */
function useViewOnly() {
  const viewContext = (0,_useViewContext__WEBPACK_IMPORTED_MODULE_1__["default"])();
  return _js_googlesitekit_constants__WEBPACK_IMPORTED_MODULE_0__.SITE_KIT_VIEW_ONLY_CONTEXTS.includes(viewContext);
}

/***/ }),

/***/ "./js/hooks/useWindowSize.js":
/*!***********************************!*\
  !*** ./js/hooks/useWindowSize.js ***!
  \***********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   useWindowHeight: () => (/* binding */ useWindowHeight),
/* harmony export */   useWindowSize: () => (/* binding */ useWindowSize),
/* harmony export */   useWindowWidth: () => (/* binding */ useWindowWidth)
/* harmony export */ });
/* harmony import */ var _react_hook_throttle__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @react-hook/throttle */ "../node_modules/@react-hook/throttle/dist/module/index.js");
/* harmony import */ var _react_hook_event__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @react-hook/event */ "../node_modules/@react-hook/event/dist/module/index.js");
/**
 * `useWindowSize` hook.
 *
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// Copied from https://github.com/jaredLunde/react-hook/blob/b8ac9515e26937e838a36a27001dc46c7f46a390/packages/window-size/throttled/src/index.tsx
// Modified to use global.innerWidth and global.innerHeight instead of document.documentElement.clientWidth and document.documentElement.clientHeight.

/**
 * External dependencies
 */


const emptyObj = {};
const win = typeof __webpack_require__.g === 'undefined' ? null : __webpack_require__.g;
function getSize() {
  return [__webpack_require__.g.innerWidth, __webpack_require__.g.innerHeight];
}
function useWindowSize(options = emptyObj) {
  const {
    fps,
    leading,
    initialWidth = 0,
    initialHeight = 0
  } = options;
  const [size, setThrottledSize] = (0,_react_hook_throttle__WEBPACK_IMPORTED_MODULE_0__.useThrottle)(/* istanbul ignore next */
  typeof document === 'undefined' ? [initialWidth, initialHeight] : getSize, fps, leading);
  function setSize() {
    return setThrottledSize(getSize);
  }
  (0,_react_hook_event__WEBPACK_IMPORTED_MODULE_1__["default"])(win, 'resize', setSize);
  (0,_react_hook_event__WEBPACK_IMPORTED_MODULE_1__["default"])(win, 'orientationchange', setSize);
  return size;
}
function useWindowHeight(options) {
  return useWindowSize(options)[1];
}
function useWindowWidth(options) {
  return useWindowSize(options)[0];
}

/***/ }),

/***/ "./js/material-components/index.js":
/*!*****************************************!*\
  !*** ./js/material-components/index.js ***!
  \*****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Cell: () => (/* reexport safe */ _layout__WEBPACK_IMPORTED_MODULE_1__.Cell),
/* harmony export */   Dialog: () => (/* reexport default from dynamic */ _material_react_dialog__WEBPACK_IMPORTED_MODULE_0___default.a),
/* harmony export */   DialogContent: () => (/* reexport safe */ _material_react_dialog__WEBPACK_IMPORTED_MODULE_0__.DialogContent),
/* harmony export */   DialogFooter: () => (/* reexport safe */ _material_react_dialog__WEBPACK_IMPORTED_MODULE_0__.DialogFooter),
/* harmony export */   Grid: () => (/* reexport safe */ _layout__WEBPACK_IMPORTED_MODULE_1__.Grid),
/* harmony export */   MDCCheckbox: () => (/* reexport safe */ _material_checkbox__WEBPACK_IMPORTED_MODULE_7__.MDCCheckbox),
/* harmony export */   MDCDialog: () => (/* reexport safe */ _material_dialog__WEBPACK_IMPORTED_MODULE_6__.MDCDialog),
/* harmony export */   MDCFormField: () => (/* reexport safe */ _material_form_field__WEBPACK_IMPORTED_MODULE_3__.MDCFormField),
/* harmony export */   MDCMenu: () => (/* reexport safe */ _material_menu__WEBPACK_IMPORTED_MODULE_8__.MDCMenu),
/* harmony export */   MDCRadio: () => (/* reexport safe */ _material_radio__WEBPACK_IMPORTED_MODULE_4__.MDCRadio),
/* harmony export */   MDCRipple: () => (/* reexport safe */ _material_ripple__WEBPACK_IMPORTED_MODULE_2__.MDCRipple),
/* harmony export */   MDCSwitch: () => (/* reexport safe */ _material_switch__WEBPACK_IMPORTED_MODULE_5__.MDCSwitch),
/* harmony export */   Row: () => (/* reexport safe */ _layout__WEBPACK_IMPORTED_MODULE_1__.Row)
/* harmony export */ });
/* harmony import */ var _material_ripple__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @material/ripple */ "../node_modules/@material/ripple/component.js");
/* harmony import */ var _material_form_field__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @material/form-field */ "../node_modules/@material/form-field/component.js");
/* harmony import */ var _material_radio__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @material/radio */ "../node_modules/@material/radio/component.js");
/* harmony import */ var _material_switch__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @material/switch */ "../node_modules/@material/switch/component.js");
/* harmony import */ var _material_dialog__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @material/dialog */ "../node_modules/@material/dialog/component.js");
/* harmony import */ var _material_checkbox__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @material/checkbox */ "../node_modules/@material/checkbox/component.js");
/* harmony import */ var _material_menu__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @material/menu */ "../node_modules/@material/menu/component.js");
/* harmony import */ var _material_react_dialog__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @material/react-dialog */ "../node_modules/@material/react-dialog/dist/index.js");
/* harmony import */ var _material_react_dialog__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_material_react_dialog__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _layout__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./layout */ "./js/material-components/layout/index.js");
/**
 * Material components.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */











/***/ }),

/***/ "./js/material-components/layout/Cell.js":
/*!***********************************************!*\
  !*** ./js/material-components/layout/Cell.js ***!
  \***********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Cell)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Material UI > Layout > Cell component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



function Cell(props) {
  const {
    className,
    alignTop,
    alignMiddle,
    alignBottom,
    alignRight,
    alignLeft,
    smAlignRight,
    mdAlignRight,
    lgAlignRight,
    smSize,
    smStart,
    smOrder,
    mdSize,
    mdStart,
    mdOrder,
    lgSize,
    lgStart,
    lgOrder,
    size,
    children,
    ...otherProps
  } = props;
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", {
    ...otherProps,
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()(className, 'mdc-layout-grid__cell', {
      'mdc-layout-grid__cell--align-top': alignTop,
      'mdc-layout-grid__cell--align-middle': alignMiddle,
      'mdc-layout-grid__cell--align-bottom': alignBottom,
      'mdc-layout-grid__cell--align-right': alignRight,
      'mdc-layout-grid__cell--align-left': alignLeft,
      'mdc-layout-grid__cell--align-right-phone': smAlignRight,
      'mdc-layout-grid__cell--align-right-tablet': mdAlignRight,
      'mdc-layout-grid__cell--align-right-desktop': lgAlignRight,
      [`mdc-layout-grid__cell--span-${size}`]: 12 >= size && size > 0,
      [`mdc-layout-grid__cell--span-${lgSize}-desktop`]: 12 >= lgSize && lgSize > 0,
      [`mdc-layout-grid__cell--start-${lgStart}-desktop`]: 12 >= lgStart && lgStart > 0,
      [`mdc-layout-grid__cell--order-${lgOrder}-desktop`]: 12 >= lgOrder && lgOrder > 0,
      [`mdc-layout-grid__cell--span-${mdSize}-tablet`]: 8 >= mdSize && mdSize > 0,
      [`mdc-layout-grid__cell--start-${mdStart}-tablet`]: 8 >= mdStart && mdStart > 0,
      [`mdc-layout-grid__cell--order-${mdOrder}-tablet`]: 8 >= mdOrder && mdOrder > 0,
      [`mdc-layout-grid__cell--span-${smSize}-phone`]: 4 >= smSize && smSize > 0,
      [`mdc-layout-grid__cell--start-${smStart}-phone`]: 4 >= smStart && smStart > 0,
      [`mdc-layout-grid__cell--order-${smOrder}-phone`]: 4 >= smOrder && smOrder > 0
    }),
    children: children
  });
}
Cell.propTypes = {
  smSize: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().number),
  smStart: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().number),
  smOrder: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().number),
  mdSize: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().number),
  mdStart: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().number),
  mdOrder: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().number),
  lgSize: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().number),
  lgStart: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().number),
  lgOrder: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().number),
  size: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().number),
  alignTop: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().bool),
  alignMiddle: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().bool),
  alignBottom: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().bool),
  alignRight: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().bool),
  alignLeft: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().bool),
  smAlignRight: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().bool),
  mdAlignRight: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().bool),
  lgAlignRight: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().bool),
  className: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().string),
  children: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().node)
};
Cell.defaultProps = {
  className: '',
  size: 0,
  smSize: 0,
  smStart: 0,
  smOrder: 0,
  mdSize: 0,
  mdStart: 0,
  mdOrder: 0,
  lgSize: 0,
  lgStart: 0,
  lgOrder: 0
};

/***/ }),

/***/ "./js/material-components/layout/Grid.js":
/*!***********************************************!*\
  !*** ./js/material-components/layout/Grid.js ***!
  \***********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Material UI > Layout > Grid component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * WordPress dependencies
 */


const Grid = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.forwardRef)(({
  alignLeft,
  fill,
  className,
  children,
  collapsed,
  ...otherProps
}, ref) => {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", {
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('mdc-layout-grid', className, {
      'mdc-layout-grid--align-left': alignLeft,
      'mdc-layout-grid--collapsed': collapsed,
      'mdc-layout-grid--fill': fill
    }),
    ...otherProps,
    ref: ref,
    children: children
  });
});
Grid.displayName = 'Grid';
Grid.propTypes = {
  alignLeft: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().bool),
  fill: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().bool),
  className: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  collapsed: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().bool),
  children: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().node)
};
Grid.defaultProps = {
  className: ''
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Grid);

/***/ }),

/***/ "./js/material-components/layout/Row.js":
/*!**********************************************!*\
  !*** ./js/material-components/layout/Row.js ***!
  \**********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Material UI > Layout > Row component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * WordPress dependencies
 */


const Row = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.forwardRef)(({
  className,
  children,
  ...otherProps
}, ref) => {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", {
    ref: ref,
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('mdc-layout-grid__inner', className),
    ...otherProps,
    children: children
  });
});
Row.displayName = 'Row';
Row.propTypes = {
  className: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  children: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().node)
};
Row.defaultProps = {
  className: ''
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Row);

/***/ }),

/***/ "./js/material-components/layout/index.js":
/*!************************************************!*\
  !*** ./js/material-components/layout/index.js ***!
  \************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Cell: () => (/* reexport safe */ _Cell__WEBPACK_IMPORTED_MODULE_0__["default"]),
/* harmony export */   Grid: () => (/* reexport safe */ _Grid__WEBPACK_IMPORTED_MODULE_2__["default"]),
/* harmony export */   Row: () => (/* reexport safe */ _Row__WEBPACK_IMPORTED_MODULE_1__["default"])
/* harmony export */ });
/* harmony import */ var _Cell__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./Cell */ "./js/material-components/layout/Cell.js");
/* harmony import */ var _Row__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Row */ "./js/material-components/layout/Row.js");
/* harmony import */ var _Grid__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./Grid */ "./js/material-components/layout/Grid.js");
/**
 * Material UI > Layout components.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */





/***/ }),

/***/ "./js/modules/ads/constants.js":
/*!*************************************!*\
  !*** ./js/modules/ads/constants.js ***!
  \*************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   MODULE_SLUG_ADS: () => (/* binding */ MODULE_SLUG_ADS)
/* harmony export */ });
/**
 * Ads module constants.
 *
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

const MODULE_SLUG_ADS = 'ads';

/***/ }),

/***/ "./js/modules/analytics-4/constants.js":
/*!*********************************************!*\
  !*** ./js/modules/analytics-4/constants.js ***!
  \*********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ACTIVATION_ACKNOWLEDGEMENT_TOOLTIP_STATE_KEY: () => (/* binding */ ACTIVATION_ACKNOWLEDGEMENT_TOOLTIP_STATE_KEY),
/* harmony export */   ACTIVATION_STEP_IN_PROGRESS: () => (/* binding */ ACTIVATION_STEP_IN_PROGRESS),
/* harmony export */   ACTIVATION_STEP_REMINDER: () => (/* binding */ ACTIVATION_STEP_REMINDER),
/* harmony export */   ACTIVATION_STEP_SETUP: () => (/* binding */ ACTIVATION_STEP_SETUP),
/* harmony export */   ACTIVATION_STEP_SUCCESS: () => (/* binding */ ACTIVATION_STEP_SUCCESS),
/* harmony export */   ENHANCED_MEASUREMENT_ACTIVATION_BANNER_TOOLTIP_STATE_KEY: () => (/* binding */ ENHANCED_MEASUREMENT_ACTIVATION_BANNER_TOOLTIP_STATE_KEY),
/* harmony export */   GA4_ACTIVATION_BANNER_STATE_KEY: () => (/* binding */ GA4_ACTIVATION_BANNER_STATE_KEY),
/* harmony export */   GA4_AUTO_SWITCH_DATE: () => (/* binding */ GA4_AUTO_SWITCH_DATE),
/* harmony export */   KM_CONNECT_GA4_CTA_WIDGET_DISMISSED_ITEM_KEY: () => (/* binding */ KM_CONNECT_GA4_CTA_WIDGET_DISMISSED_ITEM_KEY),
/* harmony export */   LEGACY_ENHANCED_MEASUREMENT_ACTIVATION_BANNER_DISMISSED_ITEM_KEY: () => (/* binding */ LEGACY_ENHANCED_MEASUREMENT_ACTIVATION_BANNER_DISMISSED_ITEM_KEY),
/* harmony export */   MODULE_SLUG_ANALYTICS_4: () => (/* binding */ MODULE_SLUG_ANALYTICS_4),
/* harmony export */   REPORT_ARGS_DATA_FILTERS_KEY: () => (/* binding */ REPORT_ARGS_DATA_FILTERS_KEY),
/* harmony export */   REPORT_ARGS_NAV_KEY: () => (/* binding */ REPORT_ARGS_NAV_KEY),
/* harmony export */   REPORT_ARGS_SELECTED_DIMENSION_KEY: () => (/* binding */ REPORT_ARGS_SELECTED_DIMENSION_KEY),
/* harmony export */   REPORT_ARGS_SELECTED_METRIC_KEY: () => (/* binding */ REPORT_ARGS_SELECTED_METRIC_KEY)
/* harmony export */ });
/**
 * GA4 module constants.
 *
 * Site Kit by Google, Copyright 2022 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

const ACTIVATION_STEP_REMINDER = 0;
const ACTIVATION_STEP_SETUP = 1;
const ACTIVATION_STEP_SUCCESS = 2;
const ACTIVATION_STEP_IN_PROGRESS = 3;
const ACTIVATION_ACKNOWLEDGEMENT_TOOLTIP_STATE_KEY = 'activation-acknowledgement-tooltip-state';
const GA4_ACTIVATION_BANNER_STATE_KEY = 'ga4-activation-banner-state';
const ENHANCED_MEASUREMENT_ACTIVATION_BANNER_TOOLTIP_STATE_KEY = 'enhanced-measurement-activation-banner-tooltip-state';
const LEGACY_ENHANCED_MEASUREMENT_ACTIVATION_BANNER_DISMISSED_ITEM_KEY = 'enhanced-measurement-activation-banner-dismissed-item';
const REPORT_ARGS_SELECTED_METRIC_KEY = '_r.explorerCard..selmet';
const REPORT_ARGS_SELECTED_DIMENSION_KEY = '_r.explorerCard..seldim';
const REPORT_ARGS_DATA_FILTERS_KEY = '_r..dataFilters';
const REPORT_ARGS_NAV_KEY = '_r..nav';
const KM_CONNECT_GA4_CTA_WIDGET_DISMISSED_ITEM_KEY = 'key-metrics-connect-ga4-cta-widget';

/**
 * Date that Site Kit will automatically switch to using GA4: September 25, 2023.
 *
 * With Site Kit's maximum date range being three months, once this period has passed since the UA cutoff date,
 * it will no longer be able to show any historical data for UA and will automatically switch to GA4.
 * For operational reasons, we automatically make the switch a few days before the three month cutoff point.
 *
 * @since 1.107.0
 * @see UA_CUTOFF_DATE.
 */
const GA4_AUTO_SWITCH_DATE = '2023-09-25';
const MODULE_SLUG_ANALYTICS_4 = 'analytics-4';

/***/ }),

/***/ "./js/modules/pagespeed-insights/components/common/FieldReportMetrics.js":
/*!*******************************************************************************!*\
  !*** ./js/modules/pagespeed-insights/components/common/FieldReportMetrics.js ***!
  \*******************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ FieldReportMetrics)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_13___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_13__);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/@wordpress/element/build-module/create-interpolate-element.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _ReportMetric__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./ReportMetric */ "./js/modules/pagespeed-insights/components/common/ReportMetric.js");
/* harmony import */ var _MetricsLearnMoreLink__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./MetricsLearnMoreLink */ "./js/modules/pagespeed-insights/components/common/MetricsLearnMoreLink.js");
/* harmony import */ var _INPLearnMoreLink__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./INPLearnMoreLink */ "./js/modules/pagespeed-insights/components/common/INPLearnMoreLink.js");
/* harmony import */ var _js_components_ReportErrorActions__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/components/ReportErrorActions */ "./js/components/ReportErrorActions.js");
/* harmony import */ var _js_util_errors__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @/js/util/errors */ "./js/util/errors.js");
/* harmony import */ var _js_modules_pagespeed_insights_util_constants__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @/js/modules/pagespeed-insights/util/constants */ "./js/modules/pagespeed-insights/util/constants.js");
/* harmony import */ var _js_components_ErrorNotice__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @/js/components/ErrorNotice */ "./js/components/ErrorNotice.js");
/* harmony import */ var _js_components_Typography__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @/js/components/Typography */ "./js/components/Typography/index.js");
/* harmony import */ var _js_components_Typography_P__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @/js/components/Typography/P */ "./js/components/Typography/P.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * PageSpeed Insights Lab Data report metrics component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */










function FieldReportMetrics({
  data,
  error
}) {
  const {
    LARGEST_CONTENTFUL_PAINT_MS: largestContentfulPaint,
    CUMULATIVE_LAYOUT_SHIFT_SCORE: cumulativeLayoutShift,
    INTERACTION_TO_NEXT_PAINT: interactionToNextPaint
  } = data?.loadingExperience?.metrics || {};
  if (error) {
    const errorMessage = (0,_js_util_errors__WEBPACK_IMPORTED_MODULE_6__.getReportErrorMessage)(error);
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("div", {
      className: "googlesitekit-pagespeed-insights-web-vitals-metrics",
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("div", {
        className: "googlesitekit-pagespeed-report__row googlesitekit-pagespeed-report__row--error",
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_js_components_ErrorNotice__WEBPACK_IMPORTED_MODULE_8__["default"], {
          message: errorMessage
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_js_components_ReportErrorActions__WEBPACK_IMPORTED_MODULE_5__["default"], {
          moduleSlug: "pagespeed-insights",
          error: error
        })]
      })
    });
  }
  if (!largestContentfulPaint && !cumulativeLayoutShift && !interactionToNextPaint) {
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("div", {
      className: "googlesitekit-pagespeed-insights-web-vitals-metrics googlesitekit-pagespeed-insights-web-vitals-metrics--field-data-unavailable",
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("div", {
        className: "googlesitekit-pagespeed-insights-web-vitals-metrics__field-data-unavailable-content",
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_js_components_Typography__WEBPACK_IMPORTED_MODULE_9__["default"], {
          as: "h3",
          type: "headline",
          size: "small",
          children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Field data unavailable', 'google-site-kit')
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_js_components_Typography_P__WEBPACK_IMPORTED_MODULE_10__["default"], {
          children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Field data shows how real users actually loaded and interacted with your page. We don’t have enough real-world experience and speed data for this page. It may be new, or not enough users with Chrome browsers have visited it yet.', 'google-site-kit')
        })]
      })
    });
  }

  // Convert milliseconds to seconds with 1 fraction digit.
  const lcpSeconds = (Math.round(largestContentfulPaint?.percentile / 100) / 10).toFixed(1);
  // Convert 2 digit score to a decimal between 0 and 1, with 2 fraction digits.
  const cls = (cumulativeLayoutShift?.percentile / 100).toFixed(2);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("div", {
    className: "googlesitekit-pagespeed-insights-web-vitals-metrics",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("div", {
      className: "googlesitekit-pagespeed-report__row googlesitekit-pagespeed-report__row--first",
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_js_components_Typography_P__WEBPACK_IMPORTED_MODULE_10__["default"], {
        children: (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_12__["default"])((0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Field data shows how real users actually loaded and interacted with your page over time. <LearnMoreLink />', 'google-site-kit'), {
          LearnMoreLink: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_MetricsLearnMoreLink__WEBPACK_IMPORTED_MODULE_3__["default"], {})
        })
      })
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("table", {
      className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-table', 'googlesitekit-table--with-list'),
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("thead", {
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("tr", {
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("th", {
            children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Metric Name', 'google-site-kit')
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("th", {
            children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Metric Value', 'google-site-kit')
          })]
        })
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("tbody", {
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_ReportMetric__WEBPACK_IMPORTED_MODULE_2__["default"], {
          title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__._x)('Largest Contentful Paint', 'core web vitals name', 'google-site-kit'),
          description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Time it takes for the page to load', 'google-site-kit'),
          displayValue: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.sprintf)(/* translators: %s: number of seconds */
          (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__._x)('%s s', 'duration', 'google-site-kit'), lcpSeconds),
          category: largestContentfulPaint?.category,
          isUnavailable: !largestContentfulPaint
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_ReportMetric__WEBPACK_IMPORTED_MODULE_2__["default"], {
          title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__._x)('Cumulative Layout Shift', 'core web vitals name', 'google-site-kit'),
          description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('How stable the elements on the page are', 'google-site-kit'),
          displayValue: cls,
          category: cumulativeLayoutShift?.category,
          isUnavailable: !cumulativeLayoutShift
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_ReportMetric__WEBPACK_IMPORTED_MODULE_2__["default"], {
          title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__._x)('Interaction to Next Paint', 'core web vitals name', 'google-site-kit'),
          description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('How quickly your page responds when people interact with it', 'google-site-kit'),
          displayValue: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.sprintf)(/* translators: %s: number of milliseconds */
          (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__._x)('%s ms', 'duration', 'google-site-kit'), interactionToNextPaint?.percentile),
          category: interactionToNextPaint?.category || _js_modules_pagespeed_insights_util_constants__WEBPACK_IMPORTED_MODULE_7__.CATEGORY_AVERAGE,
          isUnavailable: !interactionToNextPaint,
          hintText: (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_12__["default"])((0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('INP is a new Core Web Vital that replaced FID in March 2024. <LearnMoreLink />', 'google-site-kit'), {
            LearnMoreLink: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_INPLearnMoreLink__WEBPACK_IMPORTED_MODULE_4__["default"], {})
          }),
          isLast: true
        })]
      })]
    })]
  });
}
FieldReportMetrics.propTypes = {
  data: (prop_types__WEBPACK_IMPORTED_MODULE_13___default().object),
  error: (prop_types__WEBPACK_IMPORTED_MODULE_13___default().object)
};

/***/ }),

/***/ "./js/modules/pagespeed-insights/components/common/INPLearnMoreLink.js":
/*!*****************************************************************************!*\
  !*** ./js/modules/pagespeed-insights/components/common/INPLearnMoreLink.js ***!
  \*****************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ INPLearnMoreLink)
/* harmony export */ });
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _js_components_Link__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/components/Link */ "./js/components/Link.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * INP Learn More Link component.
 *
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */


function INPLearnMoreLink() {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)(_js_components_Link__WEBPACK_IMPORTED_MODULE_1__["default"], {
    href: "https://web.dev/inp-cwv/",
    "aria-label": (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Learn more about INP replacing FID.', 'google-site-kit'),
    external: true,
    children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Learn more', 'google-site-kit')
  });
}

/***/ }),

/***/ "./js/modules/pagespeed-insights/components/common/LabReportMetrics.js":
/*!*****************************************************************************!*\
  !*** ./js/modules/pagespeed-insights/components/common/LabReportMetrics.js ***!
  \*****************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ LabReportMetrics)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_10__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/@wordpress/element/build-module/create-interpolate-element.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _ReportMetric__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./ReportMetric */ "./js/modules/pagespeed-insights/components/common/ReportMetric.js");
/* harmony import */ var _MetricsLearnMoreLink__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./MetricsLearnMoreLink */ "./js/modules/pagespeed-insights/components/common/MetricsLearnMoreLink.js");
/* harmony import */ var _js_modules_pagespeed_insights_util__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/modules/pagespeed-insights/util */ "./js/modules/pagespeed-insights/util/index.js");
/* harmony import */ var _js_util_errors__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/util/errors */ "./js/util/errors.js");
/* harmony import */ var _js_components_ReportErrorActions__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/components/ReportErrorActions */ "./js/components/ReportErrorActions.js");
/* harmony import */ var _js_components_ErrorNotice__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @/js/components/ErrorNotice */ "./js/components/ErrorNotice.js");
/* harmony import */ var _js_components_Typography_P__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @/js/components/Typography/P */ "./js/components/Typography/P.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * PageSpeed Insights Lab Data report metrics component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */








function LabReportMetrics({
  data,
  error
}) {
  const largestContentfulPaint = data?.lighthouseResult?.audits?.['largest-contentful-paint'];
  const cumulativeLayoutShift = data?.lighthouseResult?.audits?.['cumulative-layout-shift'];
  const totalBlockingTime = data?.lighthouseResult?.audits?.['total-blocking-time'];
  if (error) {
    const errorMessage = (0,_js_util_errors__WEBPACK_IMPORTED_MODULE_4__.getReportErrorMessage)(error);
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)("div", {
      className: "googlesitekit-pagespeed-insights-web-vitals-metrics",
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsxs)("div", {
        className: "googlesitekit-pagespeed-report__row googlesitekit-pagespeed-report__row--error",
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(_js_components_ErrorNotice__WEBPACK_IMPORTED_MODULE_6__["default"], {
          error: error,
          message: errorMessage,
          hasButton: true
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(_js_components_ReportErrorActions__WEBPACK_IMPORTED_MODULE_5__["default"], {
          moduleSlug: "pagespeed-insights",
          error: error
        })]
      })
    });
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsxs)("div", {
    className: "googlesitekit-pagespeed-insights-web-vitals-metrics",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)("div", {
      className: "googlesitekit-pagespeed-report__row googlesitekit-pagespeed-report__row--first",
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(_js_components_Typography_P__WEBPACK_IMPORTED_MODULE_7__["default"], {
        children: (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__["default"])((0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Lab data is a snapshot of how your page performs right now, measured in tests we run in a controlled environment. <LearnMoreLink />', 'google-site-kit'), {
          LearnMoreLink: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(_MetricsLearnMoreLink__WEBPACK_IMPORTED_MODULE_2__["default"], {})
        })
      })
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsxs)("table", {
      className: "googlesitekit-table googlesitekit-table--with-list",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)("thead", {
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsxs)("tr", {
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)("th", {
            children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Metric Name', 'google-site-kit')
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)("th", {
            children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Metric Value', 'google-site-kit')
          })]
        })
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsxs)("tbody", {
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(_ReportMetric__WEBPACK_IMPORTED_MODULE_1__["default"], {
          title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__._x)('Largest Contentful Paint', 'core web vitals name', 'google-site-kit'),
          description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Time it takes for the page to load', 'google-site-kit'),
          displayValue: largestContentfulPaint?.displayValue || '0',
          category: (0,_js_modules_pagespeed_insights_util__WEBPACK_IMPORTED_MODULE_3__.getScoreCategory)(largestContentfulPaint?.score || 0)
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(_ReportMetric__WEBPACK_IMPORTED_MODULE_1__["default"], {
          title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__._x)('Cumulative Layout Shift', 'core web vitals name', 'google-site-kit'),
          description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('How stable the elements on the page are', 'google-site-kit'),
          displayValue: cumulativeLayoutShift?.displayValue || '0',
          category: (0,_js_modules_pagespeed_insights_util__WEBPACK_IMPORTED_MODULE_3__.getScoreCategory)(cumulativeLayoutShift?.score || 0)
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(_ReportMetric__WEBPACK_IMPORTED_MODULE_1__["default"], {
          title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Total Blocking Time', 'google-site-kit'),
          description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('How long people had to wait after the page loaded before they could click something', 'google-site-kit'),
          displayValue: totalBlockingTime?.displayValue || '0',
          category: (0,_js_modules_pagespeed_insights_util__WEBPACK_IMPORTED_MODULE_3__.getScoreCategory)(totalBlockingTime?.score || 0),
          hintText: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)("br", {}),
          isLast: true
        })]
      })]
    })]
  });
}
LabReportMetrics.propTypes = {
  data: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().object),
  error: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().object)
};

/***/ }),

/***/ "./js/modules/pagespeed-insights/components/common/MetricsLearnMoreLink.js":
/*!*********************************************************************************!*\
  !*** ./js/modules/pagespeed-insights/components/common/MetricsLearnMoreLink.js ***!
  \*********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ MetricsLearnMoreLink)
/* harmony export */ });
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _js_components_Link__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/components/Link */ "./js/components/Link.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Metrics Learn More Link component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */


function MetricsLearnMoreLink() {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)(_js_components_Link__WEBPACK_IMPORTED_MODULE_1__["default"], {
    href: "https://web.dev/user-centric-performance-metrics/#how-metrics-are-measured",
    "aria-label": (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Learn more how metrics are measured.', 'google-site-kit'),
    external: true,
    children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Learn more', 'google-site-kit')
  });
}

/***/ }),

/***/ "./js/modules/pagespeed-insights/components/common/Recommendation.js":
/*!***************************************************************************!*\
  !*** ./js/modules/pagespeed-insights/components/common/Recommendation.js ***!
  \***************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Recommendation)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _js_modules_pagespeed_insights_datastore_constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/modules/pagespeed-insights/datastore/constants */ "./js/modules/pagespeed-insights/datastore/constants.js");
/* harmony import */ var _js_components_Accordion__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/components/Accordion */ "./js/components/Accordion.js");
/* harmony import */ var _js_util__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/util */ "./js/util/index.js");
/* harmony import */ var _js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/hooks/useViewContext */ "./js/hooks/useViewContext.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Recommendation component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * Internal dependencies
 */






function Recommendation(props) {
  const {
    auditID,
    title,
    referenceURL,
    strategy
  } = props;
  const viewContext = (0,_js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_4__["default"])();
  const onOpen = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.useCallback)(() => {
    (0,_js_util__WEBPACK_IMPORTED_MODULE_3__.trackEvent)(`${viewContext}_pagespeed-widget`, 'stack_pack_expand', auditID);
  }, [auditID, viewContext]);
  const stackPack = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useSelect)(select => select(_js_modules_pagespeed_insights_datastore_constants__WEBPACK_IMPORTED_MODULE_1__.MODULES_PAGESPEED_INSIGHTS).getStackPackDescription(referenceURL, strategy, auditID, 'wordpress'));
  if (!stackPack) {
    return null;
  }
  const content = (0,_js_util__WEBPACK_IMPORTED_MODULE_3__.markdownToHTML)(stackPack.description);
  const sanitizeArgs = {
    ALLOWED_TAGS: ['a', 'p'],
    ALLOWED_ATTR: ['href', 'rel', 'target']
  };
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_js_components_Accordion__WEBPACK_IMPORTED_MODULE_2__["default"], {
    id: auditID,
    title: title,
    onOpen: onOpen,
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("div", {
      dangerouslySetInnerHTML: (0,_js_util__WEBPACK_IMPORTED_MODULE_3__.sanitizeHTML)(content, sanitizeArgs)
    })
  });
}
Recommendation.propTypes = {
  auditID: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().string).isRequired,
  title: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().string).isRequired,
  referenceURL: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().string).isRequired,
  strategy: prop_types__WEBPACK_IMPORTED_MODULE_7___default().oneOf([_js_modules_pagespeed_insights_datastore_constants__WEBPACK_IMPORTED_MODULE_1__.STRATEGY_MOBILE, _js_modules_pagespeed_insights_datastore_constants__WEBPACK_IMPORTED_MODULE_1__.STRATEGY_DESKTOP]).isRequired
};

/***/ }),

/***/ "./js/modules/pagespeed-insights/components/common/Recommendations.js":
/*!****************************************************************************!*\
  !*** ./js/modules/pagespeed-insights/components/common/Recommendations.js ***!
  \****************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Recommendations)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _js_modules_pagespeed_insights_datastore_constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/modules/pagespeed-insights/datastore/constants */ "./js/modules/pagespeed-insights/datastore/constants.js");
/* harmony import */ var _svg_graphics_zero_state_yellow_svg__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/svg/graphics/zero-state-yellow.svg */ "./svg/graphics/zero-state-yellow.svg");
/* harmony import */ var _Recommendation__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./Recommendation */ "./js/modules/pagespeed-insights/components/common/Recommendation.js");
/* harmony import */ var _js_material_components__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/material-components */ "./js/material-components/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Recommendations component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */





function Recommendations({
  className,
  recommendations,
  referenceURL,
  strategy
}) {
  if (!recommendations?.length) {
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(_js_material_components__WEBPACK_IMPORTED_MODULE_5__.Grid, {
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)(_js_material_components__WEBPACK_IMPORTED_MODULE_5__.Row, {
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(_js_material_components__WEBPACK_IMPORTED_MODULE_5__.Cell, {
          children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('No recommendations for now', 'google-site-kit')
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(_js_material_components__WEBPACK_IMPORTED_MODULE_5__.Cell, {
          className: "googlesitekit-pagespeed__zero-recommendations",
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(_svg_graphics_zero_state_yellow_svg__WEBPACK_IMPORTED_MODULE_3__["default"], {})
        })]
      })
    });
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)("div", {
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-pagespeed--recommendations', className),
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("div", {
      className: "googlesitekit-pagespeed-recommendations__title",
      children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Recommendations on how to improve your site', 'google-site-kit')
    }), recommendations.map(({
      id,
      title
    }) => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(_Recommendation__WEBPACK_IMPORTED_MODULE_4__["default"], {
      auditID: id,
      title: title,
      referenceURL: referenceURL,
      strategy: strategy
    }, id))]
  });
}
Recommendations.propTypes = {
  className: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().string),
  recommendations: prop_types__WEBPACK_IMPORTED_MODULE_7___default().arrayOf((prop_types__WEBPACK_IMPORTED_MODULE_7___default().object)),
  referenceURL: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().string).isRequired,
  strategy: prop_types__WEBPACK_IMPORTED_MODULE_7___default().oneOf([_js_modules_pagespeed_insights_datastore_constants__WEBPACK_IMPORTED_MODULE_2__.STRATEGY_MOBILE, _js_modules_pagespeed_insights_datastore_constants__WEBPACK_IMPORTED_MODULE_2__.STRATEGY_DESKTOP]).isRequired
};
Recommendations.defaultProps = {
  className: ''
};

/***/ }),

/***/ "./js/modules/pagespeed-insights/components/common/ReportDetailsLink.js":
/*!******************************************************************************!*\
  !*** ./js/modules/pagespeed-insights/components/common/ReportDetailsLink.js ***!
  \******************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ ReportDetailsLink)
/* harmony export */ });
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/@wordpress/element/build-module/create-interpolate-element.js");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _js_modules_pagespeed_insights_datastore_constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/modules/pagespeed-insights/datastore/constants */ "./js/modules/pagespeed-insights/datastore/constants.js");
/* harmony import */ var _js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/googlesitekit/datastore/site/constants */ "./js/googlesitekit/datastore/site/constants.js");
/* harmony import */ var _js_components_Link__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/components/Link */ "./js/components/Link.js");
/* harmony import */ var _js_components_Typography_P__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/components/Typography/P */ "./js/components/Typography/P.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Report Details Link component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */






function ReportDetailsLink() {
  const referenceURL = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_SITE).getCurrentReferenceURL());
  const pagespeedInsightsURL = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_modules_pagespeed_insights_datastore_constants__WEBPACK_IMPORTED_MODULE_2__.MODULES_PAGESPEED_INSIGHTS).getServiceURL({
    path: 'report',
    query: {
      url: referenceURL
    }
  }));
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(_js_components_Typography_P__WEBPACK_IMPORTED_MODULE_5__["default"], {
    size: "small",
    type: "label",
    children: (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_7__["default"])((0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.sprintf)(/* translators: %s: link with translated service name */
    (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('View details at %s', 'google-site-kit'), `<a>${(0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__._x)('PageSpeed Insights', 'Service name', 'google-site-kit')}</a>`), {
      a: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(_js_components_Link__WEBPACK_IMPORTED_MODULE_4__["default"], {
        href: pagespeedInsightsURL,
        external: true
      })
    })
  });
}

/***/ }),

/***/ "./js/modules/pagespeed-insights/components/common/ReportMetric.js":
/*!*************************************************************************!*\
  !*** ./js/modules/pagespeed-insights/components/common/ReportMetric.js ***!
  \*************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ ReportMetric)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _js_modules_pagespeed_insights_util_constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/modules/pagespeed-insights/util/constants */ "./js/modules/pagespeed-insights/util/constants.js");
/* harmony import */ var _js_components_Badge__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/components/Badge */ "./js/components/Badge.js");
/* harmony import */ var _js_components_InfoTooltip__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/components/InfoTooltip */ "./js/components/InfoTooltip.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * PageSpeed Insights Report Metric component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */




function ReportMetric({
  title,
  description,
  displayValue,
  category,
  experimental,
  isLast,
  isHidden,
  isUnavailable,
  hintText
}) {
  // Normalize the category case.
  category = category?.toLowerCase();
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)("tr", {
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-pagespeed-report__row', 'googlesitekit-pagespeed-report-metric', {
      'googlesitekit-pagespeed-report__row--last': isLast,
      'googlesitekit-pagespeed-report__row--hidden': isHidden,
      'googlesitekit-pagespeed-report__row--unavailable': isUnavailable
    }),
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)("td", {
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)("div", {
        className: "googlesitekit-pagespeed-report-metric__title",
        children: [title, !!experimental && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_js_components_Badge__WEBPACK_IMPORTED_MODULE_3__["default"], {
          label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Experimental', 'google-site-kit'),
          className: "googlesitekit-pagespeed-report-metric__badge"
        }), isUnavailable && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_js_components_InfoTooltip__WEBPACK_IMPORTED_MODULE_4__["default"], {
          title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Field data is still being gathered for this metric and will become available once your site gets sufficient traffic', 'google-site-kit')
        })]
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("div", {
        className: "googlesitekit-pagespeed-report-metric__description",
        children: description
      }), hintText && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("div", {
        className: "googlesitekit-pagespeed-report-metric__hint-text",
        children: hintText
      })]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("td", {
      className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-pagespeed-report-metric-value', {
        [`googlesitekit-pagespeed-report-metric--${category}`]: !!category
      }),
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)("div", {
        className: "googlesitekit-pagespeed-report-metric-value-container",
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("div", {
          className: "googlesitekit-pagespeed-report-metric-value__display-value",
          children: isUnavailable ? '—' : displayValue
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)("div", {
          className: "googlesitekit-pagespeed-report-metric-value__rating",
          children: [isUnavailable && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("span", {
            children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('gathering data', 'google-site-kit')
          }), !isUnavailable && category === _js_modules_pagespeed_insights_util_constants__WEBPACK_IMPORTED_MODULE_2__.CATEGORY_FAST && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("span", {
            children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__._x)('Good', 'Performance rating', 'google-site-kit')
          }), !isUnavailable && category === _js_modules_pagespeed_insights_util_constants__WEBPACK_IMPORTED_MODULE_2__.CATEGORY_AVERAGE && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("span", {
            children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__._x)('Needs improvement', 'Performance rating', 'google-site-kit')
          }), !isUnavailable && category === _js_modules_pagespeed_insights_util_constants__WEBPACK_IMPORTED_MODULE_2__.CATEGORY_SLOW && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("span", {
            children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__._x)('Poor', 'Performance rating', 'google-site-kit')
          })]
        })]
      })
    })]
  });
}
ReportMetric.propTypes = {
  title: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().string).isRequired,
  description: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().string).isRequired,
  displayValue: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().string).isRequired,
  category: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().string),
  experimental: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().bool),
  isLast: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().bool),
  isHidden: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().bool),
  hintText: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().node)
};

/***/ }),

/***/ "./js/modules/pagespeed-insights/components/dashboard/DashboardPageSpeed/Content.js":
/*!******************************************************************************************!*\
  !*** ./js/modules/pagespeed-insights/components/dashboard/DashboardPageSpeed/Content.js ***!
  \******************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Content)
/* harmony export */ });
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _js_modules_pagespeed_insights_components_common_LabReportMetrics__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/modules/pagespeed-insights/components/common/LabReportMetrics */ "./js/modules/pagespeed-insights/components/common/LabReportMetrics.js");
/* harmony import */ var _js_modules_pagespeed_insights_components_common_FieldReportMetrics__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/modules/pagespeed-insights/components/common/FieldReportMetrics */ "./js/modules/pagespeed-insights/components/common/FieldReportMetrics.js");
/* harmony import */ var _js_modules_pagespeed_insights_components_common_Recommendations__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/modules/pagespeed-insights/components/common/Recommendations */ "./js/modules/pagespeed-insights/components/common/Recommendations.js");
/* harmony import */ var _js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/googlesitekit/datastore/site/constants */ "./js/googlesitekit/datastore/site/constants.js");
/* harmony import */ var _js_googlesitekit_datastore_ui_constants__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @/js/googlesitekit/datastore/ui/constants */ "./js/googlesitekit/datastore/ui/constants.js");
/* harmony import */ var _js_modules_pagespeed_insights_datastore_constants__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @/js/modules/pagespeed-insights/datastore/constants */ "./js/modules/pagespeed-insights/datastore/constants.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * PageSpeed Widget Content component.
 *
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * Internal dependencies
 */








function Content({
  isFetching,
  recommendations,
  reportData,
  reportError
}) {
  const referenceURL = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_5__.CORE_SITE).getCurrentReferenceURL());
  const strategy = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_datastore_ui_constants__WEBPACK_IMPORTED_MODULE_6__.CORE_UI).getValue(_js_modules_pagespeed_insights_datastore_constants__WEBPACK_IMPORTED_MODULE_7__.UI_STRATEGY)) || _js_modules_pagespeed_insights_datastore_constants__WEBPACK_IMPORTED_MODULE_7__.STRATEGY_MOBILE;
  const dataSrc = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_datastore_ui_constants__WEBPACK_IMPORTED_MODULE_6__.CORE_UI).getValue(_js_modules_pagespeed_insights_datastore_constants__WEBPACK_IMPORTED_MODULE_7__.UI_DATA_SOURCE)) || _js_modules_pagespeed_insights_datastore_constants__WEBPACK_IMPORTED_MODULE_7__.DATA_SRC_LAB;
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsxs)("section", {
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()({
      'googlesitekit-pagespeed-widget__refreshing': isFetching
    }),
    children: [dataSrc === _js_modules_pagespeed_insights_datastore_constants__WEBPACK_IMPORTED_MODULE_7__.DATA_SRC_LAB && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(_js_modules_pagespeed_insights_components_common_LabReportMetrics__WEBPACK_IMPORTED_MODULE_2__["default"], {
      data: reportData,
      error: reportError
    }), dataSrc === _js_modules_pagespeed_insights_datastore_constants__WEBPACK_IMPORTED_MODULE_7__.DATA_SRC_FIELD && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(_js_modules_pagespeed_insights_components_common_FieldReportMetrics__WEBPACK_IMPORTED_MODULE_3__["default"], {
      data: reportData,
      error: reportError
    }), dataSrc === _js_modules_pagespeed_insights_datastore_constants__WEBPACK_IMPORTED_MODULE_7__.DATA_SRC_RECOMMENDATIONS && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(_js_modules_pagespeed_insights_components_common_Recommendations__WEBPACK_IMPORTED_MODULE_4__["default"], {
      className: classnames__WEBPACK_IMPORTED_MODULE_0___default()({
        'googlesitekit-pagespeed-widget__refreshing': isFetching
      }),
      recommendations: recommendations,
      referenceURL: referenceURL,
      strategy: strategy
    })]
  });
}

/***/ }),

/***/ "./js/modules/pagespeed-insights/components/dashboard/DashboardPageSpeed/Footer.js":
/*!*****************************************************************************************!*\
  !*** ./js/modules/pagespeed-insights/components/dashboard/DashboardPageSpeed/Footer.js ***!
  \*****************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Footer)
/* harmony export */ });
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var googlesitekit_api__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! googlesitekit-api */ "googlesitekit-api");
/* harmony import */ var googlesitekit_api__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_api__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _js_components_Link__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/components/Link */ "./js/components/Link.js");
/* harmony import */ var _js_modules_pagespeed_insights_components_common_ReportDetailsLink__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/modules/pagespeed-insights/components/common/ReportDetailsLink */ "./js/modules/pagespeed-insights/components/common/ReportDetailsLink.js");
/* harmony import */ var _js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @/js/googlesitekit/datastore/site/constants */ "./js/googlesitekit/datastore/site/constants.js");
/* harmony import */ var _js_googlesitekit_datastore_ui_constants__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @/js/googlesitekit/datastore/ui/constants */ "./js/googlesitekit/datastore/ui/constants.js");
/* harmony import */ var _js_modules_pagespeed_insights_datastore_constants__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @/js/modules/pagespeed-insights/datastore/constants */ "./js/modules/pagespeed-insights/datastore/constants.js");
/* harmony import */ var _js_modules_pagespeed_insights_constants__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @/js/modules/pagespeed-insights/constants */ "./js/modules/pagespeed-insights/constants.js");
/* harmony import */ var _js_components_Spinner__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @/js/components/Spinner */ "./js/components/Spinner.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * PageSpeed Widget Footer component.
 *
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */










function Footer({
  isFetching
}) {
  const referenceURL = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__.useSelect)(select => select(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_6__.CORE_SITE).getCurrentReferenceURL());
  const dataSrc = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__.useSelect)(select => select(_js_googlesitekit_datastore_ui_constants__WEBPACK_IMPORTED_MODULE_7__.CORE_UI).getValue(_js_modules_pagespeed_insights_datastore_constants__WEBPACK_IMPORTED_MODULE_8__.UI_DATA_SOURCE)) || _js_modules_pagespeed_insights_datastore_constants__WEBPACK_IMPORTED_MODULE_8__.DATA_SRC_LAB;
  const {
    invalidateResolution
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__.useDispatch)(_js_modules_pagespeed_insights_datastore_constants__WEBPACK_IMPORTED_MODULE_8__.MODULES_PAGESPEED_INSIGHTS);
  const updateReport = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_12__.useCallback)(async event => {
    event.preventDefault();

    // Invalidate the PageSpeed API request caches.
    await (0,googlesitekit_api__WEBPACK_IMPORTED_MODULE_2__.invalidateCache)('modules', _js_modules_pagespeed_insights_constants__WEBPACK_IMPORTED_MODULE_9__.MODULE_SLUG_PAGESPEED_INSIGHTS, 'pagespeed');

    // Invalidate the cached resolver.
    invalidateResolution('getReport', [referenceURL, _js_modules_pagespeed_insights_datastore_constants__WEBPACK_IMPORTED_MODULE_8__.STRATEGY_DESKTOP]);
    invalidateResolution('getReport', [referenceURL, _js_modules_pagespeed_insights_datastore_constants__WEBPACK_IMPORTED_MODULE_8__.STRATEGY_MOBILE]);
  }, [invalidateResolution, referenceURL]);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("div", {
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-pagespeed-report__footer', {
      'googlesitekit-pagespeed-report__footer--with-action': dataSrc === _js_modules_pagespeed_insights_datastore_constants__WEBPACK_IMPORTED_MODULE_8__.DATA_SRC_LAB
    }),
    children: [dataSrc === _js_modules_pagespeed_insights_datastore_constants__WEBPACK_IMPORTED_MODULE_8__.DATA_SRC_LAB && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("div", {
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_js_components_Link__WEBPACK_IMPORTED_MODULE_4__["default"], {
        onClick: updateReport,
        disabled: isFetching,
        children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Run test again', 'google-site-kit')
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_js_components_Spinner__WEBPACK_IMPORTED_MODULE_10__["default"], {
        isSaving: isFetching
      })]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_js_modules_pagespeed_insights_components_common_ReportDetailsLink__WEBPACK_IMPORTED_MODULE_5__["default"], {})]
  });
}

/***/ }),

/***/ "./js/modules/pagespeed-insights/components/dashboard/DashboardPageSpeed/Header.js":
/*!*****************************************************************************************!*\
  !*** ./js/modules/pagespeed-insights/components/dashboard/DashboardPageSpeed/Header.js ***!
  \*****************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-components */ "googlesitekit-components");
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _js_components_DeviceSizeTabBar__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/components/DeviceSizeTabBar */ "./js/components/DeviceSizeTabBar.js");
/* harmony import */ var _js_googlesitekit_datastore_ui_constants__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/googlesitekit/datastore/ui/constants */ "./js/googlesitekit/datastore/ui/constants.js");
/* harmony import */ var _js_modules_pagespeed_insights_datastore_constants__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/modules/pagespeed-insights/datastore/constants */ "./js/modules/pagespeed-insights/datastore/constants.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * PageSpeed Widget Header component.
 *
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */






const Header = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_7__.forwardRef)(({
  isFetching,
  updateActiveTab
}, ref) => {
  const strategy = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.useSelect)(select => select(_js_googlesitekit_datastore_ui_constants__WEBPACK_IMPORTED_MODULE_4__.CORE_UI).getValue(_js_modules_pagespeed_insights_datastore_constants__WEBPACK_IMPORTED_MODULE_5__.UI_STRATEGY)) || _js_modules_pagespeed_insights_datastore_constants__WEBPACK_IMPORTED_MODULE_5__.STRATEGY_MOBILE;
  const dataSrc = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.useSelect)(select => select(_js_googlesitekit_datastore_ui_constants__WEBPACK_IMPORTED_MODULE_4__.CORE_UI).getValue(_js_modules_pagespeed_insights_datastore_constants__WEBPACK_IMPORTED_MODULE_5__.UI_DATA_SOURCE)) || _js_modules_pagespeed_insights_datastore_constants__WEBPACK_IMPORTED_MODULE_5__.DATA_SRC_LAB;
  const {
    setValues
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.useDispatch)(_js_googlesitekit_datastore_ui_constants__WEBPACK_IMPORTED_MODULE_4__.CORE_UI);

  // Update the active tab for "mobile" or "desktop".
  const updateActiveDeviceSize = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_7__.useCallback)(({
    slug
  }) => {
    if (slug === _js_modules_pagespeed_insights_datastore_constants__WEBPACK_IMPORTED_MODULE_5__.STRATEGY_DESKTOP) {
      setValues({
        [_js_modules_pagespeed_insights_datastore_constants__WEBPACK_IMPORTED_MODULE_5__.UI_STRATEGY]: _js_modules_pagespeed_insights_datastore_constants__WEBPACK_IMPORTED_MODULE_5__.STRATEGY_DESKTOP
      });
    } else {
      setValues({
        [_js_modules_pagespeed_insights_datastore_constants__WEBPACK_IMPORTED_MODULE_5__.UI_STRATEGY]: _js_modules_pagespeed_insights_datastore_constants__WEBPACK_IMPORTED_MODULE_5__.STRATEGY_MOBILE
      });
    }
  }, [setValues]);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)("header", {
    className: "googlesitekit-pagespeed-widget__header",
    ref: ref,
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("div", {
      className: "googlesitekit-pagespeed-widget__data-src-tabs",
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__.TabBar, {
        activeIndex: [_js_modules_pagespeed_insights_datastore_constants__WEBPACK_IMPORTED_MODULE_5__.DATA_SRC_LAB, _js_modules_pagespeed_insights_datastore_constants__WEBPACK_IMPORTED_MODULE_5__.DATA_SRC_FIELD, _js_modules_pagespeed_insights_datastore_constants__WEBPACK_IMPORTED_MODULE_5__.DATA_SRC_RECOMMENDATIONS].indexOf(dataSrc),
        handleActiveIndexUpdate: updateActiveTab,
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__.Tab, {
          focusOnActivate: false,
          "aria-labelledby": `googlesitekit-pagespeed-widget__data-src-tab-${_js_modules_pagespeed_insights_datastore_constants__WEBPACK_IMPORTED_MODULE_5__.DATA_SRC_LAB}`,
          disabled: isFetching,
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("span", {
            id: `googlesitekit-pagespeed-widget__data-src-tab-${_js_modules_pagespeed_insights_datastore_constants__WEBPACK_IMPORTED_MODULE_5__.DATA_SRC_LAB}`,
            className: "mdc-tab__text-label",
            children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('In the Lab', 'google-site-kit')
          })
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__.Tab, {
          focusOnActivate: false,
          "aria-labelledby": `googlesitekit-pagespeed-widget__data-src-tab-${_js_modules_pagespeed_insights_datastore_constants__WEBPACK_IMPORTED_MODULE_5__.DATA_SRC_FIELD}`,
          disabled: isFetching,
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("span", {
            id: `googlesitekit-pagespeed-widget__data-src-tab-${_js_modules_pagespeed_insights_datastore_constants__WEBPACK_IMPORTED_MODULE_5__.DATA_SRC_FIELD}`,
            className: "mdc-tab__text-label",
            children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('In the Field', 'google-site-kit')
          })
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__.Tab, {
          focusOnActivate: false,
          "aria-labelledby": `googlesitekit-pagespeed-widget__data-src-tab-${_js_modules_pagespeed_insights_datastore_constants__WEBPACK_IMPORTED_MODULE_5__.DATA_SRC_RECOMMENDATIONS}`,
          disabled: isFetching,
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("span", {
            id: `googlesitekit-pagespeed-widget__data-src-tab-${_js_modules_pagespeed_insights_datastore_constants__WEBPACK_IMPORTED_MODULE_5__.DATA_SRC_RECOMMENDATIONS}`,
            className: "mdc-tab__text-label",
            children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('How to improve', 'google-site-kit')
          })
        })]
      })
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("div", {
      className: "googlesitekit-pagespeed-widget__device-size-tab-bar-wrapper",
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(_js_components_DeviceSizeTabBar__WEBPACK_IMPORTED_MODULE_3__["default"], {
        activeTab: strategy,
        disabled: isFetching,
        handleDeviceSizeUpdate: updateActiveDeviceSize
      })
    })]
  });
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Header);

/***/ }),

/***/ "./js/modules/pagespeed-insights/components/dashboard/DashboardPageSpeed/Loading.js":
/*!******************************************************************************************!*\
  !*** ./js/modules/pagespeed-insights/components/dashboard/DashboardPageSpeed/Loading.js ***!
  \******************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Loading)
/* harmony export */ });
/* harmony import */ var _js_components_PreviewBlocks__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @/js/components/PreviewBlocks */ "./js/components/PreviewBlocks.js");
/* harmony import */ var _js_components_PreviewBlock__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/components/PreviewBlock */ "./js/components/PreviewBlock.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Dashboard PageSpeed Loading component.
 *
 * Site Kit by Google, Copyright 2022 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Internal dependencies
 */



function Loading() {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)("div", {
    className: "googlesitekit-pagespeed-widget__content",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)("header", {
      className: "googlesitekit-pagespeed-widget__header",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("div", {
        className: "googlesitekit-pagespeed-widget__data-src-tabs",
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)(_js_components_PreviewBlocks__WEBPACK_IMPORTED_MODULE_0__["default"], {
          count: 3,
          smallWidth: "70px",
          smallHeight: "48px",
          width: "120px",
          height: "48px"
        })
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("div", {
        className: "googlesitekit-pagespeed-widget__device-size-tab-bar-wrapper",
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)(_js_components_PreviewBlocks__WEBPACK_IMPORTED_MODULE_0__["default"], {
          count: 2,
          width: "56px",
          height: "32px"
        })
      })]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("section", {
      className: "googlesitekit-pagespeed-widget__values",
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)(_js_components_PreviewBlocks__WEBPACK_IMPORTED_MODULE_0__["default"], {
        count: 5,
        smallWidth: "100%",
        smallHeight: "90px",
        width: "100%",
        height: "78px"
      })
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("div", {
      className: "googlesitekit-pagespeed-report__row",
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)(_js_components_PreviewBlock__WEBPACK_IMPORTED_MODULE_1__["default"], {
        width: "130px",
        height: "40px"
      })
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("div", {
      className: "googlesitekit-pagespeed-report__footer",
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)(_js_components_PreviewBlock__WEBPACK_IMPORTED_MODULE_1__["default"], {
        width: "224px",
        height: "40px"
      })
    })]
  });
}

/***/ }),

/***/ "./js/modules/pagespeed-insights/components/dashboard/DashboardPageSpeed/index.js":
/*!****************************************************************************************!*\
  !*** ./js/modules/pagespeed-insights/components/dashboard/DashboardPageSpeed/index.js ***!
  \****************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ DashboardPageSpeed)
/* harmony export */ });
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react_use__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! react-use */ "../node_modules/react-use/esm/useIntersection.js");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! googlesitekit-components */ "googlesitekit-components");
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_components__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _js_util_tracking__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/util/tracking */ "./js/util/tracking/index.js");
/* harmony import */ var _js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/googlesitekit/datastore/site/constants */ "./js/googlesitekit/datastore/site/constants.js");
/* harmony import */ var _js_googlesitekit_datastore_ui_constants__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @/js/googlesitekit/datastore/ui/constants */ "./js/googlesitekit/datastore/ui/constants.js");
/* harmony import */ var _js_modules_pagespeed_insights_datastore_constants__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @/js/modules/pagespeed-insights/datastore/constants */ "./js/modules/pagespeed-insights/datastore/constants.js");
/* harmony import */ var _js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @/js/hooks/useViewContext */ "./js/hooks/useViewContext.js");
/* harmony import */ var _Loading__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./Loading */ "./js/modules/pagespeed-insights/components/dashboard/DashboardPageSpeed/Loading.js");
/* harmony import */ var _Header__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./Header */ "./js/modules/pagespeed-insights/components/dashboard/DashboardPageSpeed/Header.js");
/* harmony import */ var _Footer__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./Footer */ "./js/modules/pagespeed-insights/components/dashboard/DashboardPageSpeed/Footer.js");
/* harmony import */ var _Content__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ./Content */ "./js/modules/pagespeed-insights/components/dashboard/DashboardPageSpeed/Content.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Dashboard PageSpeed Widget component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */












const TAB_INDEX_LAB = 0;
const TAB_INDEX_FIELD = 1;
const TAB_INDEX_RECOMMENDATIONS = 2;
function DashboardPageSpeed() {
  const trackingRef = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_14__.useRef)();
  const [hasBeenInView, setHasBeenInView] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_14__.useState)(false);
  const viewContext = (0,_js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_8__["default"])();
  const referenceURL = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__.useSelect)(select => select(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_5__.CORE_SITE).getCurrentReferenceURL());
  const strategy = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__.useSelect)(select => select(_js_googlesitekit_datastore_ui_constants__WEBPACK_IMPORTED_MODULE_6__.CORE_UI).getValue(_js_modules_pagespeed_insights_datastore_constants__WEBPACK_IMPORTED_MODULE_7__.UI_STRATEGY)) || _js_modules_pagespeed_insights_datastore_constants__WEBPACK_IMPORTED_MODULE_7__.STRATEGY_MOBILE;
  const dataSrc = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__.useSelect)(select => select(_js_googlesitekit_datastore_ui_constants__WEBPACK_IMPORTED_MODULE_6__.CORE_UI).getValue(_js_modules_pagespeed_insights_datastore_constants__WEBPACK_IMPORTED_MODULE_7__.UI_DATA_SOURCE)) || _js_modules_pagespeed_insights_datastore_constants__WEBPACK_IMPORTED_MODULE_7__.DATA_SRC_LAB;
  const {
    isFetchingMobile,
    isFetchingDesktop,
    errorMobile,
    errorDesktop
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__.useSelect)(select => {
    const store = select(_js_modules_pagespeed_insights_datastore_constants__WEBPACK_IMPORTED_MODULE_7__.MODULES_PAGESPEED_INSIGHTS);
    return {
      isFetchingMobile: !store.hasFinishedResolution('getReport', [referenceURL, _js_modules_pagespeed_insights_datastore_constants__WEBPACK_IMPORTED_MODULE_7__.STRATEGY_MOBILE]),
      errorMobile: store.getErrorForSelector('getReport', [referenceURL, _js_modules_pagespeed_insights_datastore_constants__WEBPACK_IMPORTED_MODULE_7__.STRATEGY_MOBILE]),
      isFetchingDesktop: !store.hasFinishedResolution('getReport', [referenceURL, _js_modules_pagespeed_insights_datastore_constants__WEBPACK_IMPORTED_MODULE_7__.STRATEGY_DESKTOP]),
      errorDesktop: store.getErrorForSelector('getReport', [referenceURL, _js_modules_pagespeed_insights_datastore_constants__WEBPACK_IMPORTED_MODULE_7__.STRATEGY_DESKTOP])
    };
  });
  const reportMobile = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__.useInViewSelect)(select => select(_js_modules_pagespeed_insights_datastore_constants__WEBPACK_IMPORTED_MODULE_7__.MODULES_PAGESPEED_INSIGHTS).getReport(referenceURL, _js_modules_pagespeed_insights_datastore_constants__WEBPACK_IMPORTED_MODULE_7__.STRATEGY_MOBILE), [referenceURL]);
  const reportDesktop = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__.useInViewSelect)(select => select(_js_modules_pagespeed_insights_datastore_constants__WEBPACK_IMPORTED_MODULE_7__.MODULES_PAGESPEED_INSIGHTS).getReport(referenceURL, _js_modules_pagespeed_insights_datastore_constants__WEBPACK_IMPORTED_MODULE_7__.STRATEGY_DESKTOP), [referenceURL]);
  const {
    setValues
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__.useDispatch)(_js_googlesitekit_datastore_ui_constants__WEBPACK_IMPORTED_MODULE_6__.CORE_UI);
  const intersectionEntry = (0,react_use__WEBPACK_IMPORTED_MODULE_15__["default"])(trackingRef, {
    threshold: 0.25
  });
  const inView = !!intersectionEntry?.intersectionRatio;
  const isFetching = strategy === _js_modules_pagespeed_insights_datastore_constants__WEBPACK_IMPORTED_MODULE_7__.STRATEGY_MOBILE ? isFetchingMobile : isFetchingDesktop;
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_14__.useEffect)(() => {
    if (inView && !hasBeenInView) {
      (0,_js_util_tracking__WEBPACK_IMPORTED_MODULE_4__.trackEvent)(`${viewContext}_pagespeed-widget`, 'widget_view');
      (0,_js_util_tracking__WEBPACK_IMPORTED_MODULE_4__.trackEvent)(`${viewContext}_pagespeed-widget`, 'default_tab_view', dataSrc.replace('data_', ''));
      setHasBeenInView(true);
    }
  }, [inView, dataSrc, viewContext, hasBeenInView]);

  // Update the active tab for "In the Lab" or "In The Field".
  const updateActiveTab = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_14__.useCallback)(dataSrcIndex => {
    let eventLabel;
    switch (dataSrcIndex) {
      case TAB_INDEX_LAB:
        setValues({
          [_js_modules_pagespeed_insights_datastore_constants__WEBPACK_IMPORTED_MODULE_7__.UI_DATA_SOURCE]: _js_modules_pagespeed_insights_datastore_constants__WEBPACK_IMPORTED_MODULE_7__.DATA_SRC_LAB
        });
        eventLabel = 'lab';
        break;
      case TAB_INDEX_FIELD:
        setValues({
          [_js_modules_pagespeed_insights_datastore_constants__WEBPACK_IMPORTED_MODULE_7__.UI_DATA_SOURCE]: _js_modules_pagespeed_insights_datastore_constants__WEBPACK_IMPORTED_MODULE_7__.DATA_SRC_FIELD
        });
        eventLabel = 'field';
        break;
      case TAB_INDEX_RECOMMENDATIONS:
        setValues({
          [_js_modules_pagespeed_insights_datastore_constants__WEBPACK_IMPORTED_MODULE_7__.UI_DATA_SOURCE]: _js_modules_pagespeed_insights_datastore_constants__WEBPACK_IMPORTED_MODULE_7__.DATA_SRC_RECOMMENDATIONS
        });
        eventLabel = 'recommendations';
        break;
      default:
        break;
    }
    (0,_js_util_tracking__WEBPACK_IMPORTED_MODULE_4__.trackEvent)(`${viewContext}_pagespeed-widget`, 'tab_select', eventLabel);
  }, [setValues, viewContext]);
  const reportData = strategy === _js_modules_pagespeed_insights_datastore_constants__WEBPACK_IMPORTED_MODULE_7__.STRATEGY_MOBILE ? reportMobile : reportDesktop;
  const reportError = strategy === _js_modules_pagespeed_insights_datastore_constants__WEBPACK_IMPORTED_MODULE_7__.STRATEGY_MOBILE ? errorMobile : errorDesktop;
  const finishedResolution = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__.useSelect)(select => select(_js_modules_pagespeed_insights_datastore_constants__WEBPACK_IMPORTED_MODULE_7__.MODULES_PAGESPEED_INSIGHTS).hasFinishedResolution('getReport', [referenceURL, strategy]));
  const recommendations = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__.useInViewSelect)(select => {
    if (reportError) {
      return [];
    }
    const allAudits = select(_js_modules_pagespeed_insights_datastore_constants__WEBPACK_IMPORTED_MODULE_7__.MODULES_PAGESPEED_INSIGHTS).getAuditsWithStackPack(referenceURL, strategy, 'wordpress');
    if (!allAudits || !Object.keys(allAudits).length) {
      return [];
    }
    return Object.values(allAudits).filter(({
      scoreDisplayMode,
      score
    }) => scoreDisplayMode === 'metricSavings' && score < 1).sort((a, b) => {
      // If the scores are the same, sort alphabetically by
      // audit slug. This is how the API returns audits.
      if (a.score === b.score) {
        return a.id < b.id ? -1 : 1;
      }
      return a.score - b.score;
    }).map(({
      id,
      title
    }) => ({
      id,
      title
    }));
  }, [referenceURL, strategy, finishedResolution]);

  // Set the default data source based on report data.
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_14__.useEffect)(() => {
    if (reportMobile?.loadingExperience?.metrics && reportDesktop?.loadingExperience?.metrics) {
      setValues({
        [_js_modules_pagespeed_insights_datastore_constants__WEBPACK_IMPORTED_MODULE_7__.UI_DATA_SOURCE]: _js_modules_pagespeed_insights_datastore_constants__WEBPACK_IMPORTED_MODULE_7__.DATA_SRC_FIELD
      });
    }
  }, [reportMobile, reportDesktop, setValues]);
  const isLoading = !referenceURL || isFetching && !reportData || !dataSrc;
  const isFieldTabWithData = dataSrc === _js_modules_pagespeed_insights_datastore_constants__WEBPACK_IMPORTED_MODULE_7__.DATA_SRC_FIELD && ['LARGEST_CONTENTFUL_PAINT_MS', 'CUMULATIVE_LAYOUT_SHIFT_SCORE', 'FIRST_INPUT_DELAY_MS'].every(key => reportData?.loadingExperience?.metrics?.[key]);
  if (isLoading) {
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx)("div", {
      id: "googlesitekit-pagespeed-header",
      className: "googlesitekit-pagespeed-widget__content-wrapper googlesitekit-pagespeed-widget__content-wrapper--loading",
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx)(_Loading__WEBPACK_IMPORTED_MODULE_9__["default"], {})
    });
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx)("div", {
    id: "googlesitekit-pagespeed-header" // Used by jump link.
    ,
    className: "googlesitekit-pagespeed-widget__content-wrapper",
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsxs)("div", {
      className: "googlesitekit-pagespeed-widget__content",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx)(_Header__WEBPACK_IMPORTED_MODULE_10__["default"], {
        ref: trackingRef,
        isFetching: isFetching,
        updateActiveTab: updateActiveTab
      }), isFetching && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx)("div", {
        className: "googlesitekit-pagespeed-widget__refreshing-progress-bar-wrapper",
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_2__.ProgressBar, {
          compress: true
        })
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx)(_Content__WEBPACK_IMPORTED_MODULE_12__["default"], {
        isFetching: isFetching,
        recommendations: recommendations,
        reportData: reportData,
        reportError: reportError
      }), (dataSrc === _js_modules_pagespeed_insights_datastore_constants__WEBPACK_IMPORTED_MODULE_7__.DATA_SRC_LAB || isFieldTabWithData) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx)("div", {
        className: "googlesitekit-pagespeed-report__row",
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_2__.Button, {
          className: classnames__WEBPACK_IMPORTED_MODULE_0___default()({
            'googlesitekit-pagespeed__recommendations-cta--hidden': !recommendations?.length
          }),
          disabled: isFetching,
          onClick: () => updateActiveTab(TAB_INDEX_RECOMMENDATIONS),
          children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('How to improve', 'google-site-kit')
        })
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx)(_Footer__WEBPACK_IMPORTED_MODULE_11__["default"], {
        isFetching: isFetching
      })]
    })
  });
}

/***/ }),

/***/ "./js/modules/pagespeed-insights/components/dashboard/DashboardPageSpeedWidget.js":
/*!****************************************************************************************!*\
  !*** ./js/modules/pagespeed-insights/components/dashboard/DashboardPageSpeedWidget.js ***!
  \****************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _DashboardPageSpeed__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./DashboardPageSpeed */ "./js/modules/pagespeed-insights/components/dashboard/DashboardPageSpeed/index.js");
/* harmony import */ var _js_util_when_active__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/util/when-active */ "./js/util/when-active.js");
/* harmony import */ var _js_modules_pagespeed_insights_constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/modules/pagespeed-insights/constants */ "./js/modules/pagespeed-insights/constants.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Dashboard PageSpeed Widget component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Internal dependencies
 */




function DashboardPageSpeedWidget({
  Widget
}) {
  // Pass class to omit regular widget padding and legacy widget class to use original styles.
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(Widget, {
    className: "googlesitekit-pagespeed-widget",
    noPadding: true,
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_DashboardPageSpeed__WEBPACK_IMPORTED_MODULE_0__["default"], {})
  });
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ((0,_js_util_when_active__WEBPACK_IMPORTED_MODULE_1__["default"])({
  moduleName: _js_modules_pagespeed_insights_constants__WEBPACK_IMPORTED_MODULE_2__.MODULE_SLUG_PAGESPEED_INSIGHTS
})(DashboardPageSpeedWidget));

/***/ }),

/***/ "./js/modules/pagespeed-insights/components/notifications/SetupSuccessNotification.js":
/*!********************************************************************************************!*\
  !*** ./js/modules/pagespeed-insights/components/notifications/SetupSuccessNotification.js ***!
  \********************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ SetupSuccessNotification)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_10__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _js_googlesitekit_notifications_datastore_constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/googlesitekit/notifications/datastore/constants */ "./js/googlesitekit/notifications/datastore/constants.js");
/* harmony import */ var _js_googlesitekit_notifications_components_layout_NoticeNotification__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/googlesitekit/notifications/components/layout/NoticeNotification */ "./js/googlesitekit/notifications/components/layout/NoticeNotification.js");
/* harmony import */ var _js_components_Notice_constants__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/components/Notice/constants */ "./js/components/Notice/constants.js");
/* harmony import */ var _js_hooks_useQueryArg__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/hooks/useQueryArg */ "./js/hooks/useQueryArg.js");
/* harmony import */ var _js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @/js/hooks/useBreakpoint */ "./js/hooks/useBreakpoint.js");
/* harmony import */ var _js_util_scroll__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @/js/util/scroll */ "./js/util/scroll.js");
/* harmony import */ var _js_googlesitekit_constants__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @/js/googlesitekit/constants */ "./js/googlesitekit/constants.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * SetupSuccessNotification component.
 *
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */









function SetupSuccessNotification({
  id,
  Notification
}) {
  const breakpoint = (0,_js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_6__.useBreakpoint)();
  const [, setNotification] = (0,_js_hooks_useQueryArg__WEBPACK_IMPORTED_MODULE_5__["default"])('notification');
  const [, setSlug] = (0,_js_hooks_useQueryArg__WEBPACK_IMPORTED_MODULE_5__["default"])('slug');
  const {
    dismissNotification
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useDispatch)(_js_googlesitekit_notifications_datastore_constants__WEBPACK_IMPORTED_MODULE_2__.CORE_NOTIFICATIONS);
  function onDismiss() {
    setNotification(undefined);
    setSlug(undefined);
  }
  const anchorLink = `#${_js_googlesitekit_constants__WEBPACK_IMPORTED_MODULE_8__.ANCHOR_ID_SPEED}`;
  function onJumpLinkClick(event) {
    event.preventDefault();
    dismissNotification(id);
    onDismiss();
    __webpack_require__.g.history.replaceState({}, '', anchorLink);
    __webpack_require__.g.scrollTo({
      top: (0,_js_util_scroll__WEBPACK_IMPORTED_MODULE_7__.getNavigationalScrollTop)(anchorLink, breakpoint),
      behavior: 'smooth'
    });
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)(Notification, {
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)(_js_googlesitekit_notifications_components_layout_NoticeNotification__WEBPACK_IMPORTED_MODULE_3__["default"], {
      notificationID: id,
      type: _js_components_Notice_constants__WEBPACK_IMPORTED_MODULE_4__.TYPES.SUCCESS,
      title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Congrats on completing the setup for PageSpeed Insights!', 'google-site-kit'),
      description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Jump to the bottom of the dashboard to see how fast your home page is', 'google-site-kit'),
      dismissButton: {
        onClick: onDismiss
      },
      ctaButton: {
        label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Show me', 'google-site-kit'),
        onClick: onJumpLinkClick
      }
    })
  });
}
SetupSuccessNotification.propTypes = {
  id: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().string).isRequired,
  Notification: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().elementType).isRequired
};

/***/ }),

/***/ "./js/modules/pagespeed-insights/components/settings/SettingsView.js":
/*!***************************************************************************!*\
  !*** ./js/modules/pagespeed-insights/components/settings/SettingsView.js ***!
  \***************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ SettingsView)
/* harmony export */ });
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _js_util__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/util */ "./js/util/index.js");
/* harmony import */ var _js_modules_pagespeed_insights_datastore_constants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/modules/pagespeed-insights/datastore/constants */ "./js/modules/pagespeed-insights/datastore/constants.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * PageSpeed Insights Settings View component
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */




function SettingsView() {
  const dashboardPermalink = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_modules_pagespeed_insights_datastore_constants__WEBPACK_IMPORTED_MODULE_3__.MODULES_PAGESPEED_INSIGHTS).getAdminScreenURL());
  const content = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.sprintf)(/* translators: %s: is the URL to the Site Kit dashboard. */
  (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('To view insights, <a href="%s">visit the dashboard</a>', 'google-site-kit'), `${dashboardPermalink}#speed`);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("p", {
    dangerouslySetInnerHTML: (0,_js_util__WEBPACK_IMPORTED_MODULE_2__.sanitizeHTML)(content, {
      ALLOWED_TAGS: ['a'],
      ALLOWED_ATTR: ['href']
    })
  });
}

/***/ }),

/***/ "./js/modules/pagespeed-insights/components/settings/index.js":
/*!********************************************************************!*\
  !*** ./js/modules/pagespeed-insights/components/settings/index.js ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   SettingsView: () => (/* reexport safe */ _SettingsView__WEBPACK_IMPORTED_MODULE_0__["default"])
/* harmony export */ });
/* harmony import */ var _SettingsView__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./SettingsView */ "./js/modules/pagespeed-insights/components/settings/SettingsView.js");
/**
 * PageSpeed Insights Settings components.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */



/***/ }),

/***/ "./js/modules/pagespeed-insights/constants.js":
/*!****************************************************!*\
  !*** ./js/modules/pagespeed-insights/constants.js ***!
  \****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   MODULE_SLUG_PAGESPEED_INSIGHTS: () => (/* binding */ MODULE_SLUG_PAGESPEED_INSIGHTS)
/* harmony export */ });
/**
 * Pagespeed Insights module constants.
 *
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

const MODULE_SLUG_PAGESPEED_INSIGHTS = 'pagespeed-insights';

/***/ }),

/***/ "./js/modules/pagespeed-insights/datastore/base.js":
/*!*********************************************************!*\
  !*** ./js/modules/pagespeed-insights/datastore/base.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var googlesitekit_modules__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! googlesitekit-modules */ "googlesitekit-modules");
/* harmony import */ var googlesitekit_modules__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_modules__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./constants */ "./js/modules/pagespeed-insights/datastore/constants.js");
/* harmony import */ var _js_modules_pagespeed_insights_constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/modules/pagespeed-insights/constants */ "./js/modules/pagespeed-insights/constants.js");
/**
 * `modules/pagespeed-insights` base data store
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Internal dependencies
 */



const baseModuleStore = googlesitekit_modules__WEBPACK_IMPORTED_MODULE_0___default().createModuleStore(_js_modules_pagespeed_insights_constants__WEBPACK_IMPORTED_MODULE_2__.MODULE_SLUG_PAGESPEED_INSIGHTS, {
  storeName: _constants__WEBPACK_IMPORTED_MODULE_1__.MODULES_PAGESPEED_INSIGHTS,
  requiresSetup: false,
  settingSlugs: ['ownerID']
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (baseModuleStore);

/***/ }),

/***/ "./js/modules/pagespeed-insights/datastore/constants.js":
/*!**************************************************************!*\
  !*** ./js/modules/pagespeed-insights/datastore/constants.js ***!
  \**************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   DATA_SRC_FIELD: () => (/* binding */ DATA_SRC_FIELD),
/* harmony export */   DATA_SRC_LAB: () => (/* binding */ DATA_SRC_LAB),
/* harmony export */   DATA_SRC_RECOMMENDATIONS: () => (/* binding */ DATA_SRC_RECOMMENDATIONS),
/* harmony export */   MODULES_PAGESPEED_INSIGHTS: () => (/* binding */ MODULES_PAGESPEED_INSIGHTS),
/* harmony export */   STRATEGY_DESKTOP: () => (/* binding */ STRATEGY_DESKTOP),
/* harmony export */   STRATEGY_MOBILE: () => (/* binding */ STRATEGY_MOBILE),
/* harmony export */   UI_DATA_SOURCE: () => (/* binding */ UI_DATA_SOURCE),
/* harmony export */   UI_STRATEGY: () => (/* binding */ UI_STRATEGY)
/* harmony export */ });
/**
 * `modules/pagespeed-insights` data store constants.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

const MODULES_PAGESPEED_INSIGHTS = 'modules/pagespeed-insights';

// Report strategies.
const STRATEGY_MOBILE = 'mobile';
const STRATEGY_DESKTOP = 'desktop';
// Report data sources.
const DATA_SRC_LAB = 'data_lab';
const DATA_SRC_FIELD = 'data_field';
const DATA_SRC_RECOMMENDATIONS = 'data_recommendations';

// Dashboard widgets using the UI store.
const UI_STRATEGY = 'dashboardPageSpeedWidgetStrategy';
const UI_DATA_SOURCE = 'dashboardPageSpeedWidgetDataSource';

/***/ }),

/***/ "./js/modules/pagespeed-insights/datastore/index.js":
/*!**********************************************************!*\
  !*** ./js/modules/pagespeed-insights/datastore/index.js ***!
  \**********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   registerStore: () => (/* binding */ registerStore)
/* harmony export */ });
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _report__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./report */ "./js/modules/pagespeed-insights/datastore/report.js");
/* harmony import */ var _service__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./service */ "./js/modules/pagespeed-insights/datastore/service.js");
/* harmony import */ var _base__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./base */ "./js/modules/pagespeed-insights/datastore/base.js");
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./constants */ "./js/modules/pagespeed-insights/datastore/constants.js");
/**
 * `modules/pagespeed-insights` data store
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Internal dependencies
 */





const store = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.combineStores)(_base__WEBPACK_IMPORTED_MODULE_3__["default"], _report__WEBPACK_IMPORTED_MODULE_1__["default"], _service__WEBPACK_IMPORTED_MODULE_2__["default"]);
function registerStore(registry) {
  registry.registerStore(_constants__WEBPACK_IMPORTED_MODULE_4__.MODULES_PAGESPEED_INSIGHTS, store);
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (store);

/***/ }),

/***/ "./js/modules/pagespeed-insights/datastore/report.js":
/*!***********************************************************!*\
  !*** ./js/modules/pagespeed-insights/datastore/report.js ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   actions: () => (/* binding */ actions),
/* harmony export */   controls: () => (/* binding */ controls),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   initialState: () => (/* binding */ initialState),
/* harmony export */   reducer: () => (/* binding */ reducer),
/* harmony export */   resolvers: () => (/* binding */ resolvers),
/* harmony export */   selectors: () => (/* binding */ selectors)
/* harmony export */ });
/* harmony import */ var invariant__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! invariant */ "../node_modules/invariant/browser.js");
/* harmony import */ var invariant__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(invariant__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_url__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @wordpress/url */ "../node_modules/@wordpress/url/build-module/is-url.js");
/* harmony import */ var googlesitekit_api__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-api */ "googlesitekit-api");
/* harmony import */ var googlesitekit_api__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_api__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./constants */ "./js/modules/pagespeed-insights/datastore/constants.js");
/* harmony import */ var _js_modules_pagespeed_insights_constants__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/modules/pagespeed-insights/constants */ "./js/modules/pagespeed-insights/constants.js");
/* harmony import */ var _js_googlesitekit_data_create_fetch_store__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/googlesitekit/data/create-fetch-store */ "./js/googlesitekit/data/create-fetch-store.js");
/**
 * `modules/pagespeed-insights` data store: report.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */





const fetchGetReportStore = (0,_js_googlesitekit_data_create_fetch_store__WEBPACK_IMPORTED_MODULE_5__.createFetchStore)({
  baseName: 'getReport',
  controlCallback: ({
    strategy,
    url
  }) => {
    return (0,googlesitekit_api__WEBPACK_IMPORTED_MODULE_1__.get)('modules', _js_modules_pagespeed_insights_constants__WEBPACK_IMPORTED_MODULE_4__.MODULE_SLUG_PAGESPEED_INSIGHTS, 'pagespeed', {
      strategy,
      url
    });
  },
  reducerCallback: (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.createReducer)((state, report, {
    strategy,
    url
  }) => {
    state.reports = state.reports || {};
    state.reports[`${strategy}::${url}`] = report;
  }),
  argsToParams: (url, strategy) => {
    return {
      strategy,
      url
    };
  },
  validateParams: ({
    strategy,
    url
  } = {}) => {
    invariant__WEBPACK_IMPORTED_MODULE_0___default()((0,_wordpress_url__WEBPACK_IMPORTED_MODULE_6__.isURL)(url), 'a valid url is required to fetch a report.');
    invariant__WEBPACK_IMPORTED_MODULE_0___default()(typeof strategy === 'string', 'a valid strategy is required to fetch a report.');
  }
});
const baseInitialState = {
  reports: {}
};
const baseResolvers = {
  *getReport(url, strategy) {
    if (!url || !strategy) {
      return;
    }
    yield fetchGetReportStore.actions.fetchGetReport(url, strategy);
  }
};
const baseSelectors = {
  /**
   * Gets a PageSpeed Insights report for the given strategy and URL.
   *
   * @since 1.10.0
   *
   * @param {Object} state    Data store's state.
   * @param {string} url      URL used for generating the report.
   * @param {string} strategy Strategy used for generating the report.
   * @return {(Object|undefined)} A PageSpeed Insights report; `undefined` if not loaded.
   */
  getReport(state, url, strategy) {
    const {
      reports
    } = state;
    return reports[`${strategy}::${url}`];
  },
  /**
   * Gets report audits for the given strategy and URL.
   *
   * @since 1.22.0
   *
   * @param {Object} state Data store's state.
   * @return {(Object|undefined)} Report audits.
   */
  getAudits: (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.createRegistrySelector)(select => (state, url, strategy) => {
    const report = select(_constants__WEBPACK_IMPORTED_MODULE_3__.MODULES_PAGESPEED_INSIGHTS).getReport(url, strategy);
    if (report === undefined) {
      return undefined;
    }
    const {
      lighthouseResult
    } = report || {};
    const {
      audits
    } = lighthouseResult || {};
    if (!audits) {
      return {};
    }
    return audits;
  }),
  /**
   * Gets report audits for the given strategy and URL and stack pack.
   *
   * The selector essentially filters audits to include only those that have
   * a description available in the requested stack pack.
   *
   * @since 1.22.0
   *
   * @param {Object} state Data store's state.
   * @return {(Object|undefined)} Report audits.
   */
  getAuditsWithStackPack: (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.createRegistrySelector)(select => (state, url, strategy, stackPackID) => {
    const audits = select(_constants__WEBPACK_IMPORTED_MODULE_3__.MODULES_PAGESPEED_INSIGHTS).getAudits(url, strategy);
    if (!audits) {
      return {};
    }
    const filteredAudits = {};
    Object.keys(audits).forEach(auditID => {
      const stackPack = select(_constants__WEBPACK_IMPORTED_MODULE_3__.MODULES_PAGESPEED_INSIGHTS).getStackPackDescription(url, strategy, auditID, stackPackID);
      if (stackPack) {
        filteredAudits[auditID] = audits[auditID];
      }
    });
    return filteredAudits;
  }),
  /**
   * Gets stack pack descriptions for a sepcific report audit.
   *
   * @since 1.22.0
   *
   * @param {Object} state Data store's state.
   * @return {(Object|null|undefined)} Stack pack description object for an
   *                                   audit, null if the given stack pack is
   *                                   not available for the audit, undefined
   *                                   if not loaded yet.
   */
  getStackPackDescription: (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.createRegistrySelector)(select => (state, url, strategy, auditID, stackPackID) => {
    const report = select(_constants__WEBPACK_IMPORTED_MODULE_3__.MODULES_PAGESPEED_INSIGHTS).getReport(url, strategy);
    if (report === undefined) {
      return undefined;
    }
    const {
      lighthouseResult
    } = report || {};
    const {
      stackPacks
    } = lighthouseResult || [];
    if (!Array.isArray(stackPacks)) {
      return null;
    }
    const stackPack = stackPacks.find(({
      id,
      descriptions
    }) => id === stackPackID && !!descriptions[auditID]);
    if (!stackPack) {
      return null;
    }
    return {
      id: stackPack.id,
      icon: stackPack.iconDataURL,
      title: stackPack.title,
      description: stackPack.descriptions[auditID]
    };
  })
};
const store = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.combineStores)(fetchGetReportStore, {
  initialState: baseInitialState,
  resolvers: baseResolvers,
  selectors: baseSelectors
});
const initialState = store.initialState;
const actions = store.actions;
const controls = store.controls;
const reducer = store.reducer;
const resolvers = store.resolvers;
const selectors = store.selectors;
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (store);

/***/ }),

/***/ "./js/modules/pagespeed-insights/datastore/service.js":
/*!************************************************************!*\
  !*** ./js/modules/pagespeed-insights/datastore/service.js ***!
  \************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   selectors: () => (/* binding */ selectors)
/* harmony export */ });
/* harmony import */ var _wordpress_url__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/url */ "../node_modules/@wordpress/url/build-module/add-query-args.js");
/**
 * `modules/pagespeed-insights` data store: service.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */

const selectors = {
  /**
   * Gets a URL to the service.
   *
   * @since 1.14.0
   *
   * @param {Object} state        Data store's state.
   * @param {Object} [args]       Object containing optional path and query args.
   * @param {string} [args.path]  A path to append to the base url.
   * @param {Object} [args.query] Object of query params to be added to the URL.
   * @return {string} The URL to the service.
   */
  getServiceURL: (state, {
    path,
    query
  } = {}) => {
    const baseURI = 'https://pagespeed.web.dev';
    if (path) {
      const sanitizedPath = !path.match(/^\//) ? `/${path}` : path;
      return (0,_wordpress_url__WEBPACK_IMPORTED_MODULE_0__.addQueryArgs)(`${baseURI}${sanitizedPath}`, query);
    }
    return (0,_wordpress_url__WEBPACK_IMPORTED_MODULE_0__.addQueryArgs)(baseURI, query);
  }
};
const store = {
  selectors
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (store);

/***/ }),

/***/ "./js/modules/pagespeed-insights/index.js":
/*!************************************************!*\
  !*** ./js/modules/pagespeed-insights/index.js ***!
  \************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   NOTIFICATIONS: () => (/* binding */ NOTIFICATIONS),
/* harmony export */   registerModule: () => (/* binding */ registerModule),
/* harmony export */   registerNotifications: () => (/* binding */ registerNotifications),
/* harmony export */   registerStore: () => (/* reexport safe */ _datastore__WEBPACK_IMPORTED_MODULE_10__.registerStore),
/* harmony export */   registerWidgets: () => (/* binding */ registerWidgets)
/* harmony export */ });
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_url__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @wordpress/url */ "../node_modules/@wordpress/url/build-module/get-query-arg.js");
/* harmony import */ var _js_googlesitekit_widgets_default_areas__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/googlesitekit/widgets/default-areas */ "./js/googlesitekit/widgets/default-areas.js");
/* harmony import */ var _components_settings__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./components/settings */ "./js/modules/pagespeed-insights/components/settings/index.js");
/* harmony import */ var _components_dashboard_DashboardPageSpeedWidget__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./components/dashboard/DashboardPageSpeedWidget */ "./js/modules/pagespeed-insights/components/dashboard/DashboardPageSpeedWidget.js");
/* harmony import */ var _svg_graphics_pagespeed_insights_svg__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/svg/graphics/pagespeed-insights.svg */ "./svg/graphics/pagespeed-insights.svg");
/* harmony import */ var _datastore_constants__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./datastore/constants */ "./js/modules/pagespeed-insights/datastore/constants.js");
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./constants */ "./js/modules/pagespeed-insights/constants.js");
/* harmony import */ var _js_googlesitekit_notifications_constants__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @/js/googlesitekit/notifications/constants */ "./js/googlesitekit/notifications/constants.js");
/* harmony import */ var _js_googlesitekit_constants__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @/js/googlesitekit/constants */ "./js/googlesitekit/constants.js");
/* harmony import */ var _components_notifications_SetupSuccessNotification__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./components/notifications/SetupSuccessNotification */ "./js/modules/pagespeed-insights/components/notifications/SetupSuccessNotification.js");
/* harmony import */ var _datastore__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./datastore */ "./js/modules/pagespeed-insights/datastore/index.js");
/**
 * PageSpeed Insights module initialization.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */










function registerModule(modules) {
  modules.registerModule(_constants__WEBPACK_IMPORTED_MODULE_6__.MODULE_SLUG_PAGESPEED_INSIGHTS, {
    storeName: _datastore_constants__WEBPACK_IMPORTED_MODULE_5__.MODULES_PAGESPEED_INSIGHTS,
    SettingsViewComponent: _components_settings__WEBPACK_IMPORTED_MODULE_2__.SettingsView,
    Icon: _svg_graphics_pagespeed_insights_svg__WEBPACK_IMPORTED_MODULE_4__["default"],
    features: [(0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Website performance reports for mobile and desktop will be disabled', 'google-site-kit')],
    overrideSetupSuccessNotification: true
  });
}
function registerWidgets(widgets) {
  widgets.registerWidget('pagespeedInsightsWebVitals', {
    Component: _components_dashboard_DashboardPageSpeedWidget__WEBPACK_IMPORTED_MODULE_3__["default"],
    width: widgets.WIDGET_WIDTHS.FULL,
    wrapWidget: false,
    modules: [_constants__WEBPACK_IMPORTED_MODULE_6__.MODULE_SLUG_PAGESPEED_INSIGHTS]
  }, [_js_googlesitekit_widgets_default_areas__WEBPACK_IMPORTED_MODULE_1__.AREA_MAIN_DASHBOARD_SPEED_PRIMARY, _js_googlesitekit_widgets_default_areas__WEBPACK_IMPORTED_MODULE_1__.AREA_ENTITY_DASHBOARD_SPEED_PRIMARY]);
}
const NOTIFICATIONS = {
  'setup-success-notification-psi': {
    Component: _components_notifications_SetupSuccessNotification__WEBPACK_IMPORTED_MODULE_9__["default"],
    areaSlug: _js_googlesitekit_notifications_constants__WEBPACK_IMPORTED_MODULE_7__.NOTIFICATION_AREAS.DASHBOARD_TOP,
    viewContexts: [_js_googlesitekit_constants__WEBPACK_IMPORTED_MODULE_8__.VIEW_CONTEXT_MAIN_DASHBOARD],
    checkRequirements: () => {
      const notification = (0,_wordpress_url__WEBPACK_IMPORTED_MODULE_11__.getQueryArg)(location.href, 'notification');
      const slug = (0,_wordpress_url__WEBPACK_IMPORTED_MODULE_11__.getQueryArg)(location.href, 'slug');
      if ('authentication_success' === notification && slug === _constants__WEBPACK_IMPORTED_MODULE_6__.MODULE_SLUG_PAGESPEED_INSIGHTS) {
        return true;
      }
      return false;
    }
  }
};
function registerNotifications(notificationsAPI) {
  for (const notificationID in NOTIFICATIONS) {
    notificationsAPI.registerNotification(notificationID, NOTIFICATIONS[notificationID]);
  }
}

/***/ }),

/***/ "./js/modules/pagespeed-insights/util/constants.js":
/*!*********************************************************!*\
  !*** ./js/modules/pagespeed-insights/util/constants.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   CATEGORY_AVERAGE: () => (/* binding */ CATEGORY_AVERAGE),
/* harmony export */   CATEGORY_FAST: () => (/* binding */ CATEGORY_FAST),
/* harmony export */   CATEGORY_SLOW: () => (/* binding */ CATEGORY_SLOW)
/* harmony export */ });
/**
 * PageSpeed Insights - Component constants.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// Performance categories.
const CATEGORY_FAST = 'fast';
const CATEGORY_AVERAGE = 'average';
const CATEGORY_SLOW = 'slow';

/***/ }),

/***/ "./js/modules/pagespeed-insights/util/index.js":
/*!*****************************************************!*\
  !*** ./js/modules/pagespeed-insights/util/index.js ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   getScoreCategory: () => (/* binding */ getScoreCategory)
/* harmony export */ });
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./constants */ "./js/modules/pagespeed-insights/util/constants.js");
/**
 * PageSpeed Insights dashboard utility functions.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */


/**
 * Retrieves the score category slug based on the given score.
 *
 * @since 1.0.0
 *
 * @param {number} score Score between 1.0 and 0.0.
 * @return {string} Either 'fast', 'average', or 'slow'.
 */
function getScoreCategory(score) {
  if (0.9 <= score) {
    return _constants__WEBPACK_IMPORTED_MODULE_0__.CATEGORY_FAST;
  }
  if (0.5 <= score) {
    return _constants__WEBPACK_IMPORTED_MODULE_0__.CATEGORY_AVERAGE;
  }
  return _constants__WEBPACK_IMPORTED_MODULE_0__.CATEGORY_SLOW;
}

/***/ }),

/***/ "./js/modules/tagmanager/constants.js":
/*!********************************************!*\
  !*** ./js/modules/tagmanager/constants.js ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   MODULE_SLUG_TAGMANAGER: () => (/* binding */ MODULE_SLUG_TAGMANAGER)
/* harmony export */ });
/**
 * Tag Manager module constants.
 *
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

const MODULE_SLUG_TAGMANAGER = 'tagmanager';

/***/ }),

/***/ "./js/util/chart.js":
/*!**************************!*\
  !*** ./js/util/chart.js ***!
  \**************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   calculateDifferenceBetweenChartValues: () => (/* binding */ calculateDifferenceBetweenChartValues),
/* harmony export */   getChartDifferenceArrow: () => (/* binding */ getChartDifferenceArrow),
/* harmony export */   isSingleSlice: () => (/* binding */ isSingleSlice)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/@wordpress/element/build-module/serialize.js");
/* harmony import */ var _js_components_ChangeArrow__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @/js/components/ChangeArrow */ "./js/components/ChangeArrow.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Utility functions for charts.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */


/**
 * Gets the up/down SVG arrow for Google Chart tooltips.
 *
 * @since 1.30.0
 *
 * @param {number}  difference            The difference which can be positive or negative.
 * @param {string}  [options]             Options to be passed to the ChangeArrow component.
 * @param {boolean} [options.invertColor] Whether we need to reverse the +/- colors of the arrow.
 * @return {string} SVG for the +/- difference.
 */

function getChartDifferenceArrow(difference, options = {}) {
  if (Number.isNaN(Number(difference))) {
    return '';
  }
  const {
    invertColor = false
  } = options;
  return (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__["default"])(/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)(_js_components_ChangeArrow__WEBPACK_IMPORTED_MODULE_0__["default"], {
    direction: difference > 0 ? 'up' : 'down',
    invertColor: invertColor
  }));
}

/**
 * Checks if there is a single row of data or one row is contributing 100% of the total for a given dimension.
 *
 * @since 1.31.0
 *
 * @param {Array.<Object>} report An array of report data objects.
 * @return {(boolean|undefined)} Returns undefined if report is undefined, true/false for the above conditions.
 */
function isSingleSlice(report) {
  if (report === undefined) {
    return undefined;
  }
  if (report?.[0]?.data?.rows?.length === 1 || report?.[0]?.data?.rows?.[0]?.metrics?.[0]?.values?.[0] === report?.[0]?.data?.totals?.[0]?.values?.[0]) {
    return true;
  }
  return false;
}

/**
 * Calculates difference between two chart values.
 *
 * @since 1.48.0
 *
 * @param {number} currentValue  Current chart value.
 * @param {number} previousValue Previous chart value.
 * @return {number} The difference.
 */
function calculateDifferenceBetweenChartValues(currentValue, previousValue) {
  if (currentValue > 0 && previousValue > 0) {
    return currentValue / previousValue - 1;
  }
  if (currentValue > 0) {
    return 1;
  }
  if (previousValue > 0) {
    return -1;
  }
  return 0;
}

/***/ }),

/***/ "./js/util/convert-time.js":
/*!*********************************!*\
  !*** ./js/util/convert-time.js ***!
  \*********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   convertDateStringToUNIXTimestamp: () => (/* binding */ convertDateStringToUNIXTimestamp),
/* harmony export */   convertSecondsToArray: () => (/* binding */ convertSecondsToArray)
/* harmony export */ });
/**
 * Time related utility functions.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Converts seconds into an array with the following values [HH, MM, SS, MS] as described below.
 * HH: hours.
 * MM: minutes.
 * SS: seconds.
 * MS: milliseconds.
 *
 * For example, passing 196.385 returns [ 0, 3, 16, 385 ].
 *
 * @since 1.27.0
 *
 * @param {number} seconds The number of seconds.
 * @return {Array} Array containing the hours, minutes, seconds and milliseconds.
 */
function convertSecondsToArray(seconds) {
  seconds = parseFloat(seconds);
  if (isNaN(seconds) || 0 === seconds) {
    return [0, 0, 0, 0];
  }
  return [Math.floor(seconds / 60 / 60), Math.floor(seconds / 60 % 60), Math.floor(seconds % 60), Math.floor(seconds * 1000) - Math.floor(seconds) * 1000];
}

/**
 * Converts Date time string into UNIX timestamp in milliseconds.
 *
 * For example, passing "2014-10-02T15:01:23Z" returns 1412262083000.
 *
 * @since 1.116.0
 *
 * @param {string} dateStringValue The date time string.
 * @return {number} UNIX timestamp in milliseconds.
 */
function convertDateStringToUNIXTimestamp(dateStringValue) {
  const unixTimestamp = dateStringValue && !Number.isInteger(dateStringValue) ?
  // Valid use of `new Date()` with an argument, because this should only
  // be passed full time strings, not `YYYY-MM-DD` style dates.
  //
  // See: https://github.com/google/site-kit-wp/pull/9459#discussion_r1790660073
  // eslint-disable-next-line sitekit/no-direct-date
  new Date(dateStringValue).getTime() : dateStringValue;
  if (isNaN(unixTimestamp) || !unixTimestamp) {
    return 0;
  }
  return unixTimestamp;
}

/***/ }),

/***/ "./js/util/dates.js":
/*!**************************!*\
  !*** ./js/util/dates.js ***!
  \**************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   DAY_IN_SECONDS: () => (/* binding */ DAY_IN_SECONDS),
/* harmony export */   HOUR_IN_SECONDS: () => (/* binding */ HOUR_IN_SECONDS),
/* harmony export */   INVALID_DATE_INSTANCE_ERROR: () => (/* binding */ INVALID_DATE_INSTANCE_ERROR),
/* harmony export */   INVALID_DATE_RANGE_ERROR: () => (/* binding */ INVALID_DATE_RANGE_ERROR),
/* harmony export */   INVALID_DATE_STRING_ERROR: () => (/* binding */ INVALID_DATE_STRING_ERROR),
/* harmony export */   MINUTE_IN_SECONDS: () => (/* binding */ MINUTE_IN_SECONDS),
/* harmony export */   MONTH_IN_SECONDS: () => (/* binding */ MONTH_IN_SECONDS),
/* harmony export */   WEEK_IN_SECONDS: () => (/* binding */ WEEK_IN_SECONDS),
/* harmony export */   dateSub: () => (/* binding */ dateSub),
/* harmony export */   getAvailableDateRanges: () => (/* binding */ getAvailableDateRanges),
/* harmony export */   getCurrentDateRangeDayCount: () => (/* binding */ getCurrentDateRangeDayCount),
/* harmony export */   getDateString: () => (/* binding */ getDateString),
/* harmony export */   getPreviousDate: () => (/* binding */ getPreviousDate),
/* harmony export */   isValidDateRange: () => (/* binding */ isValidDateRange),
/* harmony export */   isValidDateString: () => (/* binding */ isValidDateString),
/* harmony export */   stringToDate: () => (/* binding */ stringToDate)
/* harmony export */ });
/* harmony import */ var invariant__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! invariant */ "../node_modules/invariant/browser.js");
/* harmony import */ var invariant__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(invariant__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! lodash */ "../node_modules/lodash/lodash.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__);
/**
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * WordPress dependencies
 */

const INVALID_DATE_INSTANCE_ERROR = 'Date param must construct to a valid date instance or be a valid date instance itself.';
const INVALID_DATE_STRING_ERROR = 'Invalid dateString parameter, it must be a string.';
const INVALID_DATE_RANGE_ERROR = 'Invalid date range, it must be a string with the format "last-x-days".';
const MINUTE_IN_SECONDS = 60;
const HOUR_IN_SECONDS = 60 * MINUTE_IN_SECONDS;
const DAY_IN_SECONDS = 24 * HOUR_IN_SECONDS;
const WEEK_IN_SECONDS = 7 * DAY_IN_SECONDS;
const MONTH_IN_SECONDS = 30 * DAY_IN_SECONDS;

/**
 * Gets the hash of available date ranges.
 *
 * @since 1.12.0
 *
 * @return {Object} The object hash where every key is a date range slug, and the value is an object with the date range slug and its translation.
 */
function getAvailableDateRanges() {
  function label(days) {
    return (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.sprintf)(/* translators: %s: number of days */
    (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__._n)('Last %s day', 'Last %s days', days, 'google-site-kit'), days);
  }
  return {
    'last-7-days': {
      slug: 'last-7-days',
      label: label(7),
      days: 7
    },
    'last-14-days': {
      slug: 'last-14-days',
      label: label(14),
      days: 14
    },
    'last-28-days': {
      slug: 'last-28-days',
      label: label(28),
      days: 28
    },
    'last-90-days': {
      slug: 'last-90-days',
      label: label(90),
      days: 90
    }
  };
}

/**
 * Gets the current dateRange day count.
 *
 * @since 1.19.0
 * @since 1.26.0 `dateRange` is now a required argument.
 *
 * @param {string} dateRange The date range slug.
 * @return {number} The number of days in the range.
 */
function getCurrentDateRangeDayCount(dateRange) {
  const daysMatch = dateRange.match(/last-(\d+)-days/);
  if (daysMatch && daysMatch[1]) {
    return parseInt(daysMatch[1], 10);
  }
  throw new Error('Unrecognized date range slug.');
}

/**
 * Asserts whether a given date string is valid or invalid.
 *
 * @since 1.18.0
 *
 * @param {string} dateString Date string to be asserted against. Defaults to an empty string.
 * @return {boolean}          True if the given date string is valid.
 */
function isValidDateString(dateString = '') {
  if (!(0,lodash__WEBPACK_IMPORTED_MODULE_1__.isString)(dateString)) {
    return false;
  }
  const dateArray = dateString.split('-');
  if (dateArray.length !== 3) {
    return false;
  }

  // Valid use of `new Date()`, constructing a new date from the string.
  // eslint-disable-next-line sitekit/no-direct-date
  const date = new Date(dateString);
  return (0,lodash__WEBPACK_IMPORTED_MODULE_1__.isDate)(date) && !isNaN(date);
}

/**
 * Parses the given Date instance and returns a date string (YYYY-MM-DD).
 *
 * @since 1.18.0
 * @since 1.85.0 Updated the function signature to only accept a Date argument.
 *
 * @param {Date} date Date to parse into a string.
 * @return {string}                 The parsed date string (YYYY-MM-DD).
 */
function getDateString(date) {
  invariant__WEBPACK_IMPORTED_MODULE_0___default()((0,lodash__WEBPACK_IMPORTED_MODULE_1__.isDate)(date) && !isNaN(date), INVALID_DATE_INSTANCE_ERROR);
  const month = `${date.getMonth() + 1}`;
  const day = `${date.getDate()}`;
  const year = date.getFullYear();
  return [year, month.length < 2 ? `0${month}` : month, day.length < 2 ? `0${day}` : day].join('-');
}

/**
 * Converts a valid date string to a Date instance.
 *
 * @since 1.38.0
 *
 * @param {string} dateString The date string to parse.
 * @return {Date} Date instance.
 */
function stringToDate(dateString) {
  invariant__WEBPACK_IMPORTED_MODULE_0___default()(isValidDateString(dateString), INVALID_DATE_STRING_ERROR);

  /**
   * Split date into explicit parts rather than pass directly into date constructor
   * to avoid timezone issues caused by parsing as UTC. Ensures date is accurate for
   * the user's local time, otherwise has a chance to return a different day than was
   * passed in depending on timezone.
   */
  const [year, month, day] = dateString.split('-');
  return new Date(year, month - 1, day);
}

/**
 * Parses the given date and returns the previous date (daysBefore).
 *
 * @since 1.18.0
 *
 * @param {string} relativeDate Date string (YYYY-MM-DD) to subtract days from.
 * @param {number} daysBefore   Number of days to subtract from relativeDate.
 * @return {string}             The date string (YYYY-MM-DD) for the previous date.
 */
function getPreviousDate(relativeDate, daysBefore) {
  return getDateString(dateSub(relativeDate, daysBefore * DAY_IN_SECONDS));
}

/**
 * Asserts whether a given dateRange string is valid or invalid.
 *
 * @since 1.18.0
 *
 * @param {string} dateRange Date string to be asserted against. Defaults to an empty string.
 * @return {boolean}          True if the given dateRange string is valid.
 */
function isValidDateRange(dateRange) {
  const parts = dateRange.split('-');
  return parts.length === 3 && parts[0] === 'last' && !Number.isNaN(parts[1]) && !Number.isNaN(parseFloat(parts[1])) && parts[2] === 'days';
}

/**
 * Subtracts duration from the prodived date and returns it.
 *
 * @since 1.132.0
 *
 * @param {Date|string} relativeDate Date string (YYYY-MM-DD) or date object to subtract duration from.
 * @param {number}      duration     The duration in seconds to subtract from relativeDate.
 * @return {Date} Resulting date.
 */
function dateSub(relativeDate, duration) {
  invariant__WEBPACK_IMPORTED_MODULE_0___default()(isValidDateString(relativeDate) || (0,lodash__WEBPACK_IMPORTED_MODULE_1__.isDate)(relativeDate) && !isNaN(relativeDate), INVALID_DATE_STRING_ERROR);
  const timestamp = isValidDateString(relativeDate) ? Date.parse(relativeDate) : relativeDate.getTime();

  // Valid use of `new Date()` using calculations.
  // eslint-disable-next-line sitekit/no-direct-date
  return new Date(timestamp - duration * 1000);
}

/***/ }),

/***/ "./js/util/errors.js":
/*!***************************!*\
  !*** ./js/util/errors.js ***!
  \***************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ERROR_CODE_MISSING_REQUIRED_SCOPE: () => (/* binding */ ERROR_CODE_MISSING_REQUIRED_SCOPE),
/* harmony export */   ERROR_INTERNAL_SERVER_ERROR: () => (/* binding */ ERROR_INTERNAL_SERVER_ERROR),
/* harmony export */   ERROR_INVALID_JSON: () => (/* binding */ ERROR_INVALID_JSON),
/* harmony export */   ERROR_REASON_BAD_REQUEST: () => (/* binding */ ERROR_REASON_BAD_REQUEST),
/* harmony export */   ERROR_REASON_FORBIDDEN: () => (/* binding */ ERROR_REASON_FORBIDDEN),
/* harmony export */   ERROR_REASON_INSUFFICIENT_PERMISSIONS: () => (/* binding */ ERROR_REASON_INSUFFICIENT_PERMISSIONS),
/* harmony export */   getReportErrorMessage: () => (/* binding */ getReportErrorMessage),
/* harmony export */   isAuthError: () => (/* binding */ isAuthError),
/* harmony export */   isErrorRetryable: () => (/* binding */ isErrorRetryable),
/* harmony export */   isInsufficientPermissionsError: () => (/* binding */ isInsufficientPermissionsError),
/* harmony export */   isPermissionScopeError: () => (/* binding */ isPermissionScopeError),
/* harmony export */   isWPError: () => (/* binding */ isWPError)
/* harmony export */ });
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! lodash */ "../node_modules/lodash/lodash.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__);
/**
 * Error Utilities.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */


// Error codes and reasons.
const ERROR_CODE_MISSING_REQUIRED_SCOPE = 'missing_required_scopes'; // When scopes are missing.
const ERROR_REASON_INSUFFICIENT_PERMISSIONS = 'insufficientPermissions';
const ERROR_REASON_FORBIDDEN = 'forbidden';
const ERROR_INTERNAL_SERVER_ERROR = 'internal_server_error';
const ERROR_INVALID_JSON = 'invalid_json';
const ERROR_REASON_BAD_REQUEST = 'bad_request';

/**
 * Checks if the provided object is an instance of WP_Error class.
 *
 * @since 1.13.0
 *
 * @param {Object} obj The object to check.
 * @return {boolean} TRUE if the object has "code", "data" and "message" properties, otherwise FALSE.
 */
function isWPError(obj) {
  return (0,lodash__WEBPACK_IMPORTED_MODULE_0__.isPlainObject)(obj) && obj.hasOwnProperty('code') && (typeof obj.code === 'string' || typeof obj.code === 'number') && obj.hasOwnProperty('message') && typeof obj.message === 'string' && obj.hasOwnProperty('data'); // We don't check "obj.data" type because it can be anything.
}

/**
 * Checks if the given error is a permission scope error.
 *
 * @since 1.9.0
 * @private
 *
 * @param {Object} error Input to test as a possible permission scope error.
 * @return {boolean} TRUE if permission scope error, otherwise FALSE.
 */
function isPermissionScopeError(error) {
  return error?.code === ERROR_CODE_MISSING_REQUIRED_SCOPE;
}

/**
 * Checks if the given error has insufficient permissions reason.
 *
 * @since 1.16.0
 * @since 1.70.0 Add support for "forbidden" reason.
 *
 * @param {Object} error The error object to check.
 * @return {boolean} TRUE if it's insufficient permissions error, otherwise FALSE.
 */
function isInsufficientPermissionsError(error) {
  return [ERROR_REASON_INSUFFICIENT_PERMISSIONS, ERROR_REASON_FORBIDDEN].includes(error?.data?.reason);
}

/**
 * Checks if the given error is an auth error.
 *
 * @since 1.78.0
 *
 * @param {Object} error The error object to check.
 * @return {boolean} TRUE if it's an auth error, otherwise FALSE.
 */
function isAuthError(error) {
  return !!error?.data?.reconnectURL;
}

/**
 * Checks if the given error can be retried.
 *
 * @since 1.86.0
 *
 * @param {Object} error          The error object to check.
 * @param {Object} [selectorData] The error's associated selector data object.
 * @return {boolean} TRUE if the error is retryable, otherwise FALSE.
 */
function isErrorRetryable(error, selectorData) {
  return !!selectorData?.storeName && !isInsufficientPermissionsError(error) && !isPermissionScopeError(error) && !isAuthError(error);
}

/**
 * Sets the error message for specific error codes.
 *
 * @since 1.92.0
 *
 * @param {Object} error The error object to check.
 * @return {Object} The updated error object.
 */
function getReportErrorMessage(error) {
  if (error?.code === ERROR_INTERNAL_SERVER_ERROR) {
    return (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('There was a critical error on this website while fetching data', 'google-site-kit');
  } else if (error?.code === ERROR_INVALID_JSON) {
    return (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('The server provided an invalid response', 'google-site-kit');
  }
  return error?.message;
}

/***/ }),

/***/ "./js/util/finite-number-or-zero.js":
/*!******************************************!*\
  !*** ./js/util/finite-number-or-zero.js ***!
  \******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   finiteNumberOrZero: () => (/* binding */ finiteNumberOrZero)
/* harmony export */ });
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! lodash */ "../node_modules/lodash/lodash.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_0__);
/**
 * Utility function `finiteNumberOrZero()`.
 *
 * Site Kit by Google, Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * Returns the passed value if it's a finite number, otherwise returns 0.
 *
 * @since 1.98.0
 *
 * @param {any} value The value to check.
 * @return {number} The finite number `value`, or 0 if `value` is not a finite number.
 */
function finiteNumberOrZero(value) {
  return (0,lodash__WEBPACK_IMPORTED_MODULE_0__.isFinite)(value) ? value : 0;
}

/***/ }),

/***/ "./js/util/i18n.js":
/*!*************************!*\
  !*** ./js/util/i18n.js ***!
  \*************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   createDurationFormat: () => (/* binding */ createDurationFormat),
/* harmony export */   expandNumFmtOptions: () => (/* binding */ expandNumFmtOptions),
/* harmony export */   getLocale: () => (/* binding */ getLocale),
/* harmony export */   listFormat: () => (/* binding */ listFormat),
/* harmony export */   numFmt: () => (/* binding */ numFmt),
/* harmony export */   numberFormat: () => (/* binding */ numberFormat),
/* harmony export */   prepareForReadableLargeNumber: () => (/* binding */ prepareForReadableLargeNumber),
/* harmony export */   readableLargeNumber: () => (/* binding */ readableLargeNumber)
/* harmony export */ });
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! lodash */ "../node_modules/lodash/lodash.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var memize__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! memize */ "../node_modules/memize/index.js");
/* harmony import */ var memize__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(memize__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__);
/**
 * Internationalization Utilities.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * WordPress dependencies
 */


/**
 * Converts seconds to a display ready string indicating
 * the number of hours, minutes and seconds that have elapsed.
 *
 * For example, passing 65 returns '1m 5s'.
 *
 * @since 1.0.0
 * @since 1.28.0 Refactored and renamed to improve localization.
 * @private
 *
 * @param {number}                     durationInSeconds The number of seconds.
 * @param {(Intl.NumberFormatOptions)} [options]         Optional formatting options.
 * @return {string} Human readable string indicating time elapsed.
 */
function durationFormat(durationInSeconds, options = {}) {
  const {
    formatUnit,
    formatDecimal
  } = createDurationFormat(durationInSeconds, options);
  try {
    // Some browsers, e.g. Safari, throw a RangeError when options.style is
    // not one of decimal, percent, or currency.
    return formatUnit();
  } catch {
    // Fallback to XXh YYm ZZs using localized decimals with hardcoded units.
    return formatDecimal();
  }
}

/**
 * Converts seconds to a display ready string indicating
 * the number of hours, minutes and seconds that have elapsed
 * in ISO format - HH:mm:ss.
 *
 * If the duration is less than an hour, the HH part of the string
 * is truncated.
 * For example, passing 65 returns '01:05'.
 * Passing 5400 returns '01:30:00'.
 *
 * @since 1.111.0
 * @private
 *
 * @param {number} durationInSeconds The number of seconds.
 * @return {string} Human readable string indicating time elapsed.
 */
function durationISOFormat(durationInSeconds) {
  let {
    hours,
    minutes,
    seconds
  } = parseDuration(durationInSeconds);
  seconds = ('0' + seconds).slice(-2);
  minutes = ('0' + minutes).slice(-2);
  hours = ('0' + hours).slice(-2);
  return hours === '00' ? `${minutes}:${seconds}` : `${hours}:${minutes}:${seconds}`;
}

/**
 * Parses the duration in seconds into hours, minutes and seconds.
 *
 * @since 1.111.0
 * @private
 *
 * @param {number} durationInSeconds The number of seconds.
 * @return {Object} Number of hours, minutes and seconds equivalent
 * to the given duration in seconds.
 */
function parseDuration(durationInSeconds) {
  durationInSeconds = parseInt(durationInSeconds, 10);
  if (Number.isNaN(durationInSeconds)) {
    durationInSeconds = 0;
  }
  const hours = Math.floor(durationInSeconds / 60 / 60);
  const minutes = Math.floor(durationInSeconds / 60 % 60);
  const seconds = Math.floor(durationInSeconds % 60);
  return {
    hours,
    minutes,
    seconds
  };
}

/**
 * Creates duration formatting utilities.
 *
 * Not intended to be used directly.
 * Use `numFmt( number, { style: 'duration' } )` instead.
 *
 * @since 1.29.0
 * @private
 *
 * @param {number} durationInSeconds Duration to format.
 * @param {Object} [options]         Formatting options.
 * @return {Object} Formatting functions.
 */
function createDurationFormat(durationInSeconds, options = {}) {
  const {
    hours,
    minutes,
    seconds
  } = parseDuration(durationInSeconds);
  return {
    hours,
    minutes,
    seconds,
    formatUnit() {
      const {
        unitDisplay = 'short',
        ...restOptions
      } = options;
      const commonOptions = {
        unitDisplay,
        ...restOptions,
        style: 'unit'
      };
      if (durationInSeconds === 0) {
        return numberFormat(seconds, {
          ...commonOptions,
          unit: 'second'
        });
      }
      return (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.sprintf)(/* translators: 1: formatted seconds, 2: formatted minutes, 3: formatted hours */
      (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__._x)('%3$s %2$s %1$s', 'duration of time: hh mm ss', 'google-site-kit'), seconds ? numberFormat(seconds, {
        ...commonOptions,
        unit: 'second'
      }) : '', minutes ? numberFormat(minutes, {
        ...commonOptions,
        unit: 'minute'
      }) : '', hours ? numberFormat(hours, {
        ...commonOptions,
        unit: 'hour'
      }) : '').trim();
    },
    /**
     * Formats the duration using integers and translatable strings.
     * This is only used as a fallback when the above `formatUnit` fails.
     *
     * @since 1.29.0
     *
     * @return {string} Formatted duration.
     */
    formatDecimal() {
      const formattedSeconds = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.sprintf)(
      // translators: %s: number of seconds with "s" as the abbreviated unit.
      (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('%ds', 'google-site-kit'), seconds);
      if (durationInSeconds === 0) {
        return formattedSeconds;
      }
      const formattedMinutes = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.sprintf)(
      // translators: %s: number of minutes with "m" as the abbreviated unit.
      (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('%dm', 'google-site-kit'), minutes);
      const formattedHours = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.sprintf)(
      // translators: %s: number of hours with "h" as the abbreviated unit.
      (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('%dh', 'google-site-kit'), hours);
      return (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.sprintf)(/* translators: 1: formatted seconds, 2: formatted minutes, 3: formatted hours */
      (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__._x)('%3$s %2$s %1$s', 'duration of time: hh mm ss', 'google-site-kit'), seconds ? formattedSeconds : '', minutes ? formattedMinutes : '', hours ? formattedHours : '').trim();
    }
  };
}

/**
 * Prepares a number to be used in readableLargeNumber.
 *
 * @since 1.7.0
 *
 * @param {number} number The large number to prepare.
 * @return {number} The prepared number.
 */
function prepareForReadableLargeNumber(number) {
  if (1000000 <= number) {
    return Math.round(number / 100000) / 10;
  }
  if (10000 <= number) {
    return Math.round(number / 1000);
  }
  if (1000 <= number) {
    return Math.round(number / 100) / 10;
  }
  return number;
}

/**
 * Formats a large number for shortened display.
 *
 * @since 1.0.0
 *
 * @param {number} number The large number to format.
 * @return {string} The formatted number.
 */
function readableLargeNumber(number) {
  const withSingleDecimal = {
    minimumFractionDigits: 1,
    maximumFractionDigits: 1
  };

  // Numbers over 1,000,000 round normally and display a single decimal unless the decimal is 0.
  if (1000000 <= number) {
    return (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.sprintf)(
    // translators: %s: an abbreviated number in millions.
    (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('%sM', 'google-site-kit'), numberFormat(prepareForReadableLargeNumber(number), number % 10 === 0 ? {} : withSingleDecimal));
  }

  // Numbers between 10,000 and 1,000,000 round normally and have no decimals
  if (10000 <= number) {
    return (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.sprintf)(
    // translators: %s: an abbreviated number in thousands.
    (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('%sK', 'google-site-kit'), numberFormat(prepareForReadableLargeNumber(number)));
  }

  // Numbers between 1,000 and 10,000 round normally and display a single decimal unless the decimal is 0.
  if (1000 <= number) {
    return (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.sprintf)(
    // translators: %s: an abbreviated number in thousands.
    (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('%sK', 'google-site-kit'), numberFormat(prepareForReadableLargeNumber(number), number % 10 === 0 ? {} : withSingleDecimal));
  }
  return numberFormat(number, {
    signDisplay: 'never',
    maximumFractionDigits: 1
  });
}

/**
 * Parses formatting options and returns an object with options for selected formatting.
 *
 * @since 1.103.0
 *
 * @param {(Intl.NumberFormatOptions|string)} options Formatting options or unit shorthand. Possible shorthand values are '%', 's', or a currency code.
 * @return {Object} Formatting options.
 */
function expandNumFmtOptions(options) {
  let formatOptions = {};

  // Expand shorthand values for units.
  if ('%' === options) {
    formatOptions = {
      style: 'percent',
      maximumFractionDigits: 2
    };
  } else if ('s' === options) {
    formatOptions = {
      style: 'duration',
      unitDisplay: 'narrow'
    };
  } else if (!!options && typeof options === 'string') {
    formatOptions = {
      style: 'currency',
      currency: options
    };
  } else if ((0,lodash__WEBPACK_IMPORTED_MODULE_0__.isPlainObject)(options)) {
    formatOptions = {
      ...options
    };
  }
  return formatOptions;
}

/**
 * Formats a number with unit using the JS Internationalization Number Format API.
 *
 * In addition to the supported 'style' values of the lower-level `numberFormat` function, this function
 * supports two additional 'style' values 'metric' and 'duration' (expects a number in seconds).
 *
 * Another differentiation in behavior is that by default the function will use 'metric' formatting instead
 * of 'decimal' formatting.
 *
 * @since 1.24.0
 *
 * @param {number|string}                     number    The number to format.
 * @param {(Intl.NumberFormatOptions|string)} [options] Formatting options or unit shorthand.
 *                                                      Possible shorthand values are '%', 's',
 *                                                      or a currency code.
 * @return {string} The formatted number.
 */
function numFmt(number, options = {}) {
  // Cast parsable values to numeric types.
  number = (0,lodash__WEBPACK_IMPORTED_MODULE_0__.isFinite)(number) ? number : Number(number);
  if (!(0,lodash__WEBPACK_IMPORTED_MODULE_0__.isFinite)(number)) {
    // eslint-disable-next-line no-console
    console.warn('Invalid number', number, typeof number);
    number = 0;
  }
  const formatOptions = expandNumFmtOptions(options);
  const {
    style = 'metric'
  } = formatOptions; // Note: `metric` is our custom, default style.

  if ('metric' === style) {
    return readableLargeNumber(number);
  }
  if ('duration' === style) {
    return durationFormat(number, formatOptions);
  }
  if ('durationISO' === style) {
    return durationISOFormat(number);
  }
  return numberFormat(number, formatOptions);
}

// Warn once for a given message.
const warnOnce = memize__WEBPACK_IMPORTED_MODULE_1___default()(console.warn); // eslint-disable-line no-console

/**
 * Formats a number using the JS Internationalization Number Format API.
 *
 * @since 1.8.0
 * @see {@link https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/NumberFormat/NumberFormat|`options` parameter} For all available formatting options.
 *
 * @param {number}                   number           The number to format.
 * @param {Intl.NumberFormatOptions} [options]        Formatting options.
 * @param {string}                   [options.locale] Locale to use for formatting. Defaults to current locale used by Site Kit.
 * @return {string} The formatted number.
 */
function numberFormat(number, options = {}) {
  const {
    locale = getLocale(),
    ...formatOptions
  } = options;
  try {
    /**
     * Per https://github.com/google/site-kit-wp/issues/3255 there have been issues with some versions of Safari
     * on some operating systems throwing issues with some parameters in the formatOptions.
     *
     * If an error is thrown, we remove some troublesome params from the formatOptions object and fallback to no formatting.
     *
     * This allows us to degrade somewhat gracefully without breaking the dashboard for users of unaffected browsers.
     */
    return new Intl.NumberFormat(locale, formatOptions).format(number);
  } catch (error) {
    warnOnce(`Site Kit numberFormat error: Intl.NumberFormat( ${JSON.stringify(locale)}, ${JSON.stringify(formatOptions)} ).format( ${typeof number} )`, error.message);
  }

  // Remove these key/values from formatOptions.
  const unstableFormatOptionValues = {
    currencyDisplay: 'narrow',
    currencySign: 'accounting',
    style: 'unit'
  };

  // Remove these keys from formatOptions irrespective of value.
  const unstableFormatOptions = ['signDisplay', 'compactDisplay'];
  const reducedFormatOptions = {};
  for (const [key, value] of Object.entries(formatOptions)) {
    if (unstableFormatOptionValues[key] && value === unstableFormatOptionValues[key]) {
      continue;
    }
    if (unstableFormatOptions.includes(key)) {
      continue;
    }
    reducedFormatOptions[key] = value;
  }
  try {
    return new Intl.NumberFormat(locale, reducedFormatOptions).format(number);
  } catch {
    return new Intl.NumberFormat(locale).format(number);
  }
}

/**
 * Flattens an array of strings into a string using the JS Internationalization List Format API.
 *
 * @since 1.23.0
 * @see {@link https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Intl/ListFormat/ListFormat|`options` parameter} For all available options.
 *
 * @param {Array}  list             The list to flatten.
 * @param {Object} [options]        Formatting options.
 * @param {string} [options.locale] Locale to use for formatting. Defaults to current locale used by Site Kit.
 * @param {string} [options.style]  Length of the formatted message. Defaults to long.
 * @param {string} [options.type]   Type of list. Defaults to 'conjunction' (A, B, and C).
 *                                  Also available 'disjunction' (A, B, or C)
 *                                  Also available 'unit' (5 pounds, 12 ounces)
 * @return {string} The flattened list.
 */
function listFormat(list, options = {}) {
  const {
    locale = getLocale(),
    style = 'long',
    type = 'conjunction'
  } = options;

  // Not all browsers support Intl.Listformat per
  // https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Intl/ListFormat/ListFormat#Browser_compatibility
  // We've seen that the built versions don't polyfill for the unsupported browsers (iOS/safari) so we provide a fallback.
  if (Intl.ListFormat) {
    const formatter = new Intl.ListFormat(locale, {
      style,
      type
    });
    return formatter.format(list);
  }

  /* translators: used between list items, there is a space after the comma. */
  const listSeparator = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)(', ', 'google-site-kit');
  return list.join(listSeparator);
}

/**
 * Gets the current locale for use with browser APIs.
 *
 * @since 1.8.0
 *
 * @param {Object} _global The global window object.
 * @return {string} Current Site Kit locale if set, otherwise the current language set by the browser.
 *                  E.g. `en-US` or `de-DE`
 */
function getLocale(_global = __webpack_require__.g) {
  const siteKitLocale = (0,lodash__WEBPACK_IMPORTED_MODULE_0__.get)(_global, ['_googlesitekitLegacyData', 'locale']);
  if (siteKitLocale) {
    const matches = siteKitLocale.match(/^(\w{2})?(_)?(\w{2})/);
    if (matches && matches[0]) {
      return matches[0].replace(/_/g, '-');
    }
  }
  return _global.navigator.language;
}

/***/ }),

/***/ "./js/util/index.js":
/*!**************************!*\
  !*** ./js/util/index.js ***!
  \**************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   DAY_IN_SECONDS: () => (/* reexport safe */ _dates__WEBPACK_IMPORTED_MODULE_8__.DAY_IN_SECONDS),
/* harmony export */   HOUR_IN_SECONDS: () => (/* reexport safe */ _dates__WEBPACK_IMPORTED_MODULE_8__.HOUR_IN_SECONDS),
/* harmony export */   INVALID_DATE_INSTANCE_ERROR: () => (/* reexport safe */ _dates__WEBPACK_IMPORTED_MODULE_8__.INVALID_DATE_INSTANCE_ERROR),
/* harmony export */   INVALID_DATE_RANGE_ERROR: () => (/* reexport safe */ _dates__WEBPACK_IMPORTED_MODULE_8__.INVALID_DATE_RANGE_ERROR),
/* harmony export */   INVALID_DATE_STRING_ERROR: () => (/* reexport safe */ _dates__WEBPACK_IMPORTED_MODULE_8__.INVALID_DATE_STRING_ERROR),
/* harmony export */   MINUTE_IN_SECONDS: () => (/* reexport safe */ _dates__WEBPACK_IMPORTED_MODULE_8__.MINUTE_IN_SECONDS),
/* harmony export */   MONTH_IN_SECONDS: () => (/* reexport safe */ _dates__WEBPACK_IMPORTED_MODULE_8__.MONTH_IN_SECONDS),
/* harmony export */   WEEK_IN_SECONDS: () => (/* reexport safe */ _dates__WEBPACK_IMPORTED_MODULE_8__.WEEK_IN_SECONDS),
/* harmony export */   calculateChange: () => (/* binding */ calculateChange),
/* harmony export */   calculateDifferenceBetweenChartValues: () => (/* reexport safe */ _chart__WEBPACK_IMPORTED_MODULE_9__.calculateDifferenceBetweenChartValues),
/* harmony export */   convertDateStringToUNIXTimestamp: () => (/* reexport safe */ _convert_time__WEBPACK_IMPORTED_MODULE_7__.convertDateStringToUNIXTimestamp),
/* harmony export */   convertSecondsToArray: () => (/* reexport safe */ _convert_time__WEBPACK_IMPORTED_MODULE_7__.convertSecondsToArray),
/* harmony export */   createDurationFormat: () => (/* reexport safe */ _i18n__WEBPACK_IMPORTED_MODULE_5__.createDurationFormat),
/* harmony export */   dateSub: () => (/* reexport safe */ _dates__WEBPACK_IMPORTED_MODULE_8__.dateSub),
/* harmony export */   decodeHTMLEntity: () => (/* binding */ decodeHTMLEntity),
/* harmony export */   expandNumFmtOptions: () => (/* reexport safe */ _i18n__WEBPACK_IMPORTED_MODULE_5__.expandNumFmtOptions),
/* harmony export */   getAvailableDateRanges: () => (/* reexport safe */ _dates__WEBPACK_IMPORTED_MODULE_8__.getAvailableDateRanges),
/* harmony export */   getChartDifferenceArrow: () => (/* reexport safe */ _chart__WEBPACK_IMPORTED_MODULE_9__.getChartDifferenceArrow),
/* harmony export */   getCurrentDateRangeDayCount: () => (/* reexport safe */ _dates__WEBPACK_IMPORTED_MODULE_8__.getCurrentDateRangeDayCount),
/* harmony export */   getDateString: () => (/* reexport safe */ _dates__WEBPACK_IMPORTED_MODULE_8__.getDateString),
/* harmony export */   getFullURL: () => (/* reexport safe */ _urls__WEBPACK_IMPORTED_MODULE_10__.getFullURL),
/* harmony export */   getLocale: () => (/* reexport safe */ _i18n__WEBPACK_IMPORTED_MODULE_5__.getLocale),
/* harmony export */   getPreviousDate: () => (/* reexport safe */ _dates__WEBPACK_IMPORTED_MODULE_8__.getPreviousDate),
/* harmony export */   getStorage: () => (/* reexport safe */ _storage__WEBPACK_IMPORTED_MODULE_4__.getStorage),
/* harmony export */   getURLPath: () => (/* reexport safe */ _urls__WEBPACK_IMPORTED_MODULE_10__.getURLPath),
/* harmony export */   isHashOnly: () => (/* reexport safe */ _urls__WEBPACK_IMPORTED_MODULE_10__.isHashOnly),
/* harmony export */   isNumeric: () => (/* reexport safe */ _isnumeric__WEBPACK_IMPORTED_MODULE_12__.isNumeric),
/* harmony export */   isSingleSlice: () => (/* reexport safe */ _chart__WEBPACK_IMPORTED_MODULE_9__.isSingleSlice),
/* harmony export */   isValidDateRange: () => (/* reexport safe */ _dates__WEBPACK_IMPORTED_MODULE_8__.isValidDateRange),
/* harmony export */   isValidDateString: () => (/* reexport safe */ _dates__WEBPACK_IMPORTED_MODULE_8__.isValidDateString),
/* harmony export */   isValidNumericID: () => (/* reexport safe */ _is_valid_numeric_id__WEBPACK_IMPORTED_MODULE_11__.isValidNumericID),
/* harmony export */   listFormat: () => (/* reexport safe */ _i18n__WEBPACK_IMPORTED_MODULE_5__.listFormat),
/* harmony export */   markdownToHTML: () => (/* reexport safe */ _markdown__WEBPACK_IMPORTED_MODULE_6__.markdownToHTML),
/* harmony export */   normalizeURL: () => (/* reexport safe */ _urls__WEBPACK_IMPORTED_MODULE_10__.normalizeURL),
/* harmony export */   numFmt: () => (/* reexport safe */ _i18n__WEBPACK_IMPORTED_MODULE_5__.numFmt),
/* harmony export */   numberFormat: () => (/* reexport safe */ _i18n__WEBPACK_IMPORTED_MODULE_5__.numberFormat),
/* harmony export */   partitionReport: () => (/* reexport safe */ _partition_report__WEBPACK_IMPORTED_MODULE_14__.partitionReport),
/* harmony export */   prepareForReadableLargeNumber: () => (/* reexport safe */ _i18n__WEBPACK_IMPORTED_MODULE_5__.prepareForReadableLargeNumber),
/* harmony export */   readableLargeNumber: () => (/* reexport safe */ _i18n__WEBPACK_IMPORTED_MODULE_5__.readableLargeNumber),
/* harmony export */   safelySort: () => (/* reexport safe */ _safely_sort__WEBPACK_IMPORTED_MODULE_13__.safelySort),
/* harmony export */   sanitizeHTML: () => (/* reexport safe */ _sanitize__WEBPACK_IMPORTED_MODULE_2__.sanitizeHTML),
/* harmony export */   shortenURL: () => (/* reexport safe */ _urls__WEBPACK_IMPORTED_MODULE_10__.shortenURL),
/* harmony export */   storageAvailable: () => (/* reexport safe */ _storage__WEBPACK_IMPORTED_MODULE_4__.storageAvailable),
/* harmony export */   stringToDate: () => (/* reexport safe */ _dates__WEBPACK_IMPORTED_MODULE_8__.stringToDate),
/* harmony export */   stringifyObject: () => (/* reexport safe */ _stringify__WEBPACK_IMPORTED_MODULE_3__.stringifyObject),
/* harmony export */   trackEvent: () => (/* reexport safe */ _tracking__WEBPACK_IMPORTED_MODULE_1__.trackEvent),
/* harmony export */   trackEventOnce: () => (/* reexport safe */ _tracking__WEBPACK_IMPORTED_MODULE_1__.trackEventOnce),
/* harmony export */   untrailingslashit: () => (/* reexport safe */ _sanitize__WEBPACK_IMPORTED_MODULE_2__.untrailingslashit),
/* harmony export */   validateJSON: () => (/* binding */ validateJSON)
/* harmony export */ });
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! lodash */ "../node_modules/lodash/lodash.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _tracking__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./tracking */ "./js/util/tracking/index.js");
/* harmony import */ var _sanitize__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./sanitize */ "./js/util/sanitize.js");
/* harmony import */ var _stringify__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./stringify */ "./js/util/stringify.js");
/* harmony import */ var _storage__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./storage */ "./js/util/storage.js");
/* harmony import */ var _i18n__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./i18n */ "./js/util/i18n.js");
/* harmony import */ var _markdown__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./markdown */ "./js/util/markdown.js");
/* harmony import */ var _convert_time__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./convert-time */ "./js/util/convert-time.js");
/* harmony import */ var _dates__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./dates */ "./js/util/dates.js");
/* harmony import */ var _chart__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./chart */ "./js/util/chart.js");
/* harmony import */ var _urls__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./urls */ "./js/util/urls.js");
/* harmony import */ var _is_valid_numeric_id__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./is-valid-numeric-id */ "./js/util/is-valid-numeric-id.js");
/* harmony import */ var _isnumeric__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ./isnumeric */ "./js/util/isnumeric.js");
/* harmony import */ var _safely_sort__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ./safely-sort */ "./js/util/safely-sort.js");
/* harmony import */ var _partition_report__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ./partition-report */ "./js/util/partition-report.js");
/**
 * Utility functions.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * Internal dependencies
 */
















/**
 * Calculates the change between two values.
 *
 * @since 1.24.0
 *
 * @param {number} previous The previous value.
 * @param {number} current  The current value.
 * @return {(number|null)} The percent change. Null if the input or output is invalid.
 */
function calculateChange(previous, current) {
  function isZero(value) {
    return value === '0' || value === 0;
  }

  // Prevent null result when both values are legitimately zero.
  if (isZero(previous) && isZero(current)) {
    return 0;
  }

  // Prevent divide by zero errors.
  if (isZero(previous) || Number.isNaN(previous)) {
    return null;
  }

  // Avoid NaN at all costs.
  const change = (current - previous) / previous;
  if (Number.isNaN(change) || !Number.isFinite(change)) {
    return null;
  }
  return change;
}

/**
 * Verifies whether JSON is valid.
 *
 * @since 1.0.0
 *
 * @param {string} stringToValidate The string to validate.
 * @return {boolean} Indicates JSON is valid.
 */
function validateJSON(stringToValidate) {
  try {
    return JSON.parse(stringToValidate) && !!stringToValidate;
  } catch (e) {
    return false;
  }
}

/**
 * Converts HTML text into an HTML entity.
 *
 * _.unescape doesn't seem to decode some entities for admin bar titles.
 * adding combination in this helper as a workaround.
 *
 * @since 1.0.0
 *
 * @param {string} str The string to decode.
 * @return {string} Decoded HTML entity.
 */
function decodeHTMLEntity(str) {
  if (!str) {
    return '';
  }
  const decoded = str.replace(/&#(\d+);/g, (match, dec) => {
    return String.fromCharCode(dec);
  }).replace(/(\\)/g, '');
  return (0,lodash__WEBPACK_IMPORTED_MODULE_0__.unescape)(decoded);
}

/***/ }),

/***/ "./js/util/is-valid-numeric-id.js":
/*!****************************************!*\
  !*** ./js/util/is-valid-numeric-id.js ***!
  \****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   isValidNumericID: () => (/* binding */ isValidNumericID)
/* harmony export */ });
/**
 * Utility function related to checking if a given value is numeric.
 *
 * Site Kit by Google, Copyright 2022 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Checks the given value to see if it is a positive integer.
 *
 * @since 1.11.0 Function introduced.
 * @since 1.90.0 Moved outside Tag Manager to a generic utility function.
 *
 * @param {*} input Value to check.
 * @return {boolean} Validity.
 */
function isValidNumericID(input) {
  const id = parseFloat(input) || 0;
  if (!Number.isInteger(id)) {
    return false;
  }
  return id > 0;
}

/***/ }),

/***/ "./js/util/isnumeric.js":
/*!******************************!*\
  !*** ./js/util/isnumeric.js ***!
  \******************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   isNumeric: () => (/* binding */ isNumeric)
/* harmony export */ });
/**
 * Utility function related to checking if a given value is numeric.
 *
 * Site Kit by Google, Copyright 2022 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Checks if a given value is numeric.
 *
 * @since 1.80.0
 *
 * @param {*} value The value to check.
 * @return {boolean} TRUE if a value is numeric FALSE otherwise.
 */
function isNumeric(value) {
  if (typeof value === 'number') {
    return true;
  }
  const string = (value || '').toString();
  if (!string) {
    return false;
  }
  return !isNaN(string);
}

/***/ }),

/***/ "./js/util/markdown.js":
/*!*****************************!*\
  !*** ./js/util/markdown.js ***!
  \*****************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   markdownToHTML: () => (/* binding */ markdownToHTML)
/* harmony export */ });
/**
 * Markdown utility.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Replaces markdown links with its HTML equivalents.
 *
 * @since 1.22.0
 *
 * @param {string} text Markdown text.
 * @return {string} Text with HTML links.
 */
function markdownLinks(text) {
  return text.replace(new RegExp('\\[([^\\]]+)\\]\\((https?://[^/]+\\.\\w+/?.*?)\\)', 'gi'), '<a href="$2" target="_blank" rel="noopener noreferrer">$1</a>');
}

/**
 * Adds paragraphs to the text.
 *
 * @since 1.22.0
 *
 * @param {string} text Markdown text.
 * @return {string} Text with HTML links.
 */
function markdownParagraphs(text) {
  return `<p>${text.replace(/\n{2,}/g, '</p><p>')}</p>`;
}

/**
 * Replaces line breaks in the text.
 *
 * @since 1.22.0
 *
 * @param {string} text Markdown text.
 * @return {string} Text with HTML links.
 */
function markdownBreaks(text) {
  return text.replace(/\n/gi, '<br>');
}

/**
 * Converts markdown to HTML.
 *
 * @since 1.22.0
 *
 * @param {string} text Markdown text.
 * @return {string} HTML version of the markdown text.
 */
function markdownToHTML(text) {
  const rules = [markdownLinks, markdownParagraphs, markdownBreaks];
  let html = text;
  for (const rule of rules) {
    html = rule(html);
  }
  return html;
}

/***/ }),

/***/ "./js/util/partition-report.js":
/*!*************************************!*\
  !*** ./js/util/partition-report.js ***!
  \*************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   partitionReport: () => (/* binding */ partitionReport)
/* harmony export */ });
/* harmony import */ var invariant__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! invariant */ "../node_modules/invariant/browser.js");
/* harmony import */ var invariant__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(invariant__WEBPACK_IMPORTED_MODULE_0__);
/**
 * Report partitioning utility.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * Splits report data into segments for current and comparison ranges.
 *
 * @since 1.33.0
 * @since 1.34.0 Updated to support incomplete `report` arrays.
 *
 * @param {Array}  report               Report rows.
 * @param {Object} args                 Additional arguments.
 * @param {number} args.dateRangeLength Date range length of report segments.
 * @return {Object} Object with keys for `compareRange` and `currentRange`.
 */
function partitionReport(report, {
  dateRangeLength
}) {
  invariant__WEBPACK_IMPORTED_MODULE_0___default()(Array.isArray(report), 'report must be an array to partition.');
  invariant__WEBPACK_IMPORTED_MODULE_0___default()(Number.isInteger(dateRangeLength) && dateRangeLength > 0, 'dateRangeLength must be a positive integer.');

  // Use a negative date range length for reverse slicing.
  const _dateRangeLength = -1 * dateRangeLength;
  return {
    // The current range should always be sliced from the end.
    currentRange: report.slice(_dateRangeLength),
    // The compare range continues from where the current left off (slicing towards the start),
    // and may be shorter (where older data is not available yet) which is fine.
    compareRange: report.slice(_dateRangeLength * 2, _dateRangeLength)
  };
}

/***/ }),

/***/ "./js/util/purify.js":
/*!***************************!*\
  !*** ./js/util/purify.js ***!
  \***************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   purify: () => (/* binding */ purify)
/* harmony export */ });
/* harmony import */ var dompurify__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! dompurify */ "../node_modules/dompurify/dist/purify.js");
/* harmony import */ var dompurify__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(dompurify__WEBPACK_IMPORTED_MODULE_0__);
/**
 * External dependencies
 */

const purify = dompurify__WEBPACK_IMPORTED_MODULE_0___default()(__webpack_require__.g);

/***/ }),

/***/ "./js/util/safely-sort.js":
/*!********************************!*\
  !*** ./js/util/safely-sort.js ***!
  \********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   safelySort: () => (/* binding */ safelySort)
/* harmony export */ });
/**
 * `safelySort` utility function.
 *
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Sorts an array without causing the mutation if the given parameter is an array.
 * If the parameter is not an array, it returns the parameter as is.
 *
 * @since 1.110.0
 * @since 1.128.0 Moved to the common utility directory from the key metrics directory.
 *
 * @param {Array|*} arr Param to be sorted.
 * @return {Array|*} 	Safely sorted array without mutation.
 */
function safelySort(arr) {
  return Array.isArray(arr) ? [...arr].sort() : arr;
}

/***/ }),

/***/ "./js/util/sanitize.js":
/*!*****************************!*\
  !*** ./js/util/sanitize.js ***!
  \*****************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   sanitizeHTML: () => (/* binding */ sanitizeHTML),
/* harmony export */   untrailingslashit: () => (/* binding */ untrailingslashit)
/* harmony export */ });
/* harmony import */ var _purify__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./purify */ "./js/util/purify.js");
/**
 * Internal dependencies
 */

function sanitizeHTML(unsafeHTML, domPurifyConfig = {}) {
  return {
    __html: _purify__WEBPACK_IMPORTED_MODULE_0__.purify.sanitize(unsafeHTML, domPurifyConfig)
  };
}

/**
 * Takes a string or an URL object, removes the trailing slash if any and returns it.
 *
 * @since 1.20.0
 * @private
 *
 * @param {Object|string} url A string with or without trailing slash or an URL object.
 * @return {string|undefined} The URL string after removing the trailing slash.
 */
function untrailingslashit(url) {
  const originalURL = typeof url === 'object' ? url.toString() : url;
  return originalURL?.replace?.(/\/+$/, '');
}

/***/ }),

/***/ "./js/util/scroll.js":
/*!***************************!*\
  !*** ./js/util/scroll.js ***!
  \***************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   getNavigationalScrollTop: () => (/* binding */ getNavigationalScrollTop),
/* harmony export */   getStickyHeaderHeight: () => (/* binding */ getStickyHeaderHeight),
/* harmony export */   getStickyHeaderHeightWithoutNav: () => (/* binding */ getStickyHeaderHeightWithoutNav)
/* harmony export */ });
/* harmony import */ var _js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @/js/hooks/useBreakpoint */ "./js/hooks/useBreakpoint.js");
/* harmony import */ var _finite_number_or_zero__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./finite-number-or-zero */ "./js/util/finite-number-or-zero.js");
/**
 * Utility functions related to window scrolling.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Internal dependencies
 */



/**
 * Gets the y coordinate to scroll to the top of a context element, taking the sticky admin bar, header and navigation height into account.
 *
 * @since 1.137.0 Renamed from getContextScrollTop to getNavigationalScrollTop.
 *
 * @param {string} selector   Selector for the element to scroll to. The id (prepend #) or class (prepend .).
 * @param {string} breakpoint The current breakpoint.
 * @return {number} The offset to scroll to.
 */
function getNavigationalScrollTop(selector, breakpoint) {
  const contextElement = document.querySelector(selector);
  if (!contextElement) {
    return 0;
  }
  const contextTop = contextElement.getBoundingClientRect().top;
  const headerHeight = getStickyHeaderHeight(breakpoint);
  return contextTop + __webpack_require__.g.scrollY - headerHeight;
}

/**
 * Gets the height of the sticky header.
 *
 * @since 1.69.0
 * @since 1.98.0 Renamed from `getHeaderHeight()` to `getStickyHeaderHeight()`.
 *
 * @param {string} breakpoint The current breakpoint.
 * @return {number} The height of the sticky header.
 */
function getStickyHeaderHeight(breakpoint) {
  let headerHeight = getStickyHeaderHeightWithoutNav(breakpoint);
  const navigation = document.querySelectorAll('.googlesitekit-navigation, .googlesitekit-entity-header');
  headerHeight += Array.from(navigation).reduce((height, el) => height + el.offsetHeight, 0);
  return headerHeight;
}

/**
 * Returns the height of the sticky WordPress admin bar, if present.
 *
 * @since 1.98.0
 *
 * @param {string} breakpoint The current breakpoint.
 * @return {number} The height of the sticky WordPress admin bar, if present.
 */
function getWordPressAdminBarHeight(breakpoint) {
  // WordPress admin bar is only sticky for breakpoints larger than BREAKPOINT_SMALL. If it's also not sticky then we can return a height of 0.
  const wpAdminBar = document.querySelector('#wpadminbar');
  if (wpAdminBar && breakpoint !== _js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_0__.BREAKPOINT_SMALL) {
    return wpAdminBar.offsetHeight;
  }
  return 0;
}

/**
 * Returns the height of the sticky Site Kit header including the sticky WordPress admin bar when it's present.
 *
 * @since 1.98.0
 *
 * @param {string} breakpoint The current breakpoint.
 * @return {number} The height of the sticky Site Kit header including the sticky WordPress admin bar when it's present.
 */
function getGoogleSiteKitHeaderHeight(breakpoint) {
  // This function calculates the height of the sticky Site Kit header including the sticky WordPress admin bar when it's present.
  const header = document.querySelector('.googlesitekit-header');
  if (header) {
    // If the breakpoint is BREAKPOINT_SMALL, the WordPress admin bar is not sticky and we can return the height of the Site Kit header alone.
    // Otherwise, we use the value of the bottom of the Site Kit header's bounding box as this will take into account the sticky WordPress admin bar.
    if (breakpoint === _js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_0__.BREAKPOINT_SMALL) {
      return header.offsetHeight;
    }
    const headerBottom = header.getBoundingClientRect().bottom;
    // In case the header is unexpectedly _not_ sticky and the value for .bottom is negative, we return 0.
    return headerBottom < 0 ? 0 : headerBottom;
  }
  return 0;
}

/**
 * Gets the height of the sticky header without the Site Kit navigation bar.
 *
 * @since 1.95.0
 * @since 1.98.0 Renamed from `getHeaderHeightWithoutNav()` to `getStickyHeaderHeightWithoutNav()`.
 *
 * @param {string} breakpoint The current breakpoint.
 * @return {number} The height of the sticky header without the navigation bar.
 */
function getStickyHeaderHeightWithoutNav(breakpoint) {
  let headerHeight = 0;
  const header = document.querySelector('.googlesitekit-header');
  const isSiteKitHeaderSticky = !!header && __webpack_require__.g.getComputedStyle(header).position === 'sticky';
  if (isSiteKitHeaderSticky) {
    headerHeight = getGoogleSiteKitHeaderHeight(breakpoint);
  } else {
    // If the Site Kit header is not sticky, we only need to calculate the height of the sticky WordPress admin bar.
    headerHeight = getWordPressAdminBarHeight(breakpoint);
  }

  // Provide a safety net in case something unexpected has happened.
  headerHeight = (0,_finite_number_or_zero__WEBPACK_IMPORTED_MODULE_1__.finiteNumberOrZero)(headerHeight);
  return headerHeight < 0 ? 0 : headerHeight;
}

/***/ }),

/***/ "./js/util/storage.js":
/*!****************************!*\
  !*** ./js/util/storage.js ***!
  \****************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   getStorage: () => (/* binding */ getStorage),
/* harmony export */   storageAvailable: () => (/* binding */ storageAvailable)
/* harmony export */ });
/**
 * Storage abstraction.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Detects whether browser storage is both supported and available.
 *
 * @since 1.0.0
 *
 * @param {string} type Browser storage to test. ex localStorage or sessionStorage.
 * @return {boolean} True if the given storage is available, false otherwise.
 */
function storageAvailable(type) {
  const storage = __webpack_require__.g[type];
  if (!storage) {
    return false;
  }
  try {
    const x = '__storage_test__';
    storage.setItem(x, x);
    storage.removeItem(x);
    return true;
  } catch (e) {
    return e instanceof DOMException && (
    // everything except Firefox
    22 === e.code ||
    // Firefox
    1014 === e.code ||
    // test name field too, because code might not be present
    // everything except Firefox
    'QuotaExceededError' === e.name ||
    // Firefox
    'NS_ERROR_DOM_QUOTA_REACHED' === e.name) &&
    // acknowledge QuotaExceededError only if there's something already stored
    0 !== storage.length;
  }
}

// Custom no-op implementation of window.Storage.
class NullStorage {
  get length() {
    return 0;
  }
  key() {
    return null;
  }
  getItem() {
    return null;
  }
  setItem() {
    // Empty method body.
  }
  removeItem() {
    // Empty method body.
  }
  clear() {
    // Empty method body.
  }
}
let storageObj;

/**
 * Gets the storage object to use.
 *
 * @since 1.0.0
 *
 * @return {Storage} Either window.sessionStorage, window.localStorage', or a
 *                   no-op implementation if neither is available.
 */
function getStorage() {
  // Only run the logic to determine the storage object once.
  if (!storageObj) {
    if (storageAvailable('sessionStorage')) {
      storageObj = __webpack_require__.g.sessionStorage;
    } else if (storageAvailable('localStorage')) {
      storageObj = __webpack_require__.g.localStorage;
    } else {
      storageObj = new NullStorage();
    }
  }
  return storageObj;
}

/***/ }),

/***/ "./js/util/stringify.js":
/*!******************************!*\
  !*** ./js/util/stringify.js ***!
  \******************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   stringifyObject: () => (/* binding */ stringifyObject)
/* harmony export */ });
/* harmony import */ var md5__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! md5 */ "../node_modules/md5/md5.js");
/* harmony import */ var md5__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(md5__WEBPACK_IMPORTED_MODULE_0__);
/**
 * Stringify function.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * Transforms an object into a hash string.
 *
 * This function can be used to e.g. generate cache keys, based on the given
 * object. Object properties are sorted, so even if they are provided in
 * different order, the hash will match. The function furthermore supports
 * nested objects.
 *
 * @since 1.7.0
 *
 * @param {Object} obj The object to stringify.
 * @return {string} Hash for the object.
 */
function stringifyObject(obj) {
  return md5__WEBPACK_IMPORTED_MODULE_0___default()(JSON.stringify(sortObjectProperties(obj)));
}
function sortObjectProperties(obj) {
  const orderedData = {};
  Object.keys(obj).sort().forEach(key => {
    let val = obj[key];
    if (val && 'object' === typeof val && !Array.isArray(val)) {
      val = sortObjectProperties(val);
    }
    orderedData[key] = val;
  });
  return orderedData;
}

/***/ }),

/***/ "./js/util/tracking/constants.js":
/*!***************************************!*\
  !*** ./js/util/tracking/constants.js ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   DATA_LAYER: () => (/* binding */ DATA_LAYER),
/* harmony export */   SCRIPT_IDENTIFIER: () => (/* binding */ SCRIPT_IDENTIFIER)
/* harmony export */ });
/**
 * Constants related to event tracking.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Data layer global used for internal/private Site Kit data.
 *
 * @since 1.8.0
 * @private
 */
const DATA_LAYER = '_googlesitekitDataLayer';

/**
 * The `gtag` `<script>` identifier.
 *
 * @since 1.8.0
 * @private
 */
const SCRIPT_IDENTIFIER = 'data-googlesitekit-gtag';

/***/ }),

/***/ "./js/util/tracking/createDataLayerPush.js":
/*!*************************************************!*\
  !*** ./js/util/tracking/createDataLayerPush.js ***!
  \*************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ createDataLayerPush)
/* harmony export */ });
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./constants */ "./js/util/tracking/constants.js");
/**
 * Internal dependencies
 */


/**
 * Returns a function which, when invoked will initialize the dataLayer and push data onto it.
 *
 * @since 1.3.0
 *
 * @param {Object} target Object to enhance with dataLayer data.
 * @return {Function} Function that pushes data onto the dataLayer.
 */
function createDataLayerPush(target) {
  /**
   * Pushes data onto the data layer.
   *
   * Must push an instance of Arguments to the target.
   * Using an ES6 spread operator (i.e. `...args`) will cause tracking events to
   * _silently_ fail.
   *
   * @since 1.0.0
   * @see {@link https://github.com/google/site-kit-wp/issues/1181}
   */
  return function dataLayerPush() {
    target[_constants__WEBPACK_IMPORTED_MODULE_0__.DATA_LAYER] = target[_constants__WEBPACK_IMPORTED_MODULE_0__.DATA_LAYER] || [];
    target[_constants__WEBPACK_IMPORTED_MODULE_0__.DATA_LAYER].push(arguments);
  };
}

/***/ }),

/***/ "./js/util/tracking/createInitializeSnippet.js":
/*!*****************************************************!*\
  !*** ./js/util/tracking/createInitializeSnippet.js ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ createInitializeSnippet)
/* harmony export */ });
/* harmony import */ var _createDataLayerPush__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./createDataLayerPush */ "./js/util/tracking/createDataLayerPush.js");
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./constants */ "./js/util/tracking/constants.js");
/* harmony import */ var _js_features_index__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/features/index */ "./js/features/index.js");
/**
 * Internal dependencies
 */




/**
 * Returns a function which, when invoked injects the gtag script if necessary.
 *
 * @since 1.44.0
 *
 * @param {Object} config          Tracking configuration.
 * @param {Object} dataLayerTarget Data layer parent object.
 * @return {Function} Function that injects gtag script if it isn't yet present.
 */
function createInitializeSnippet(config, dataLayerTarget) {
  const dataLayerPush = (0,_createDataLayerPush__WEBPACK_IMPORTED_MODULE_0__["default"])(dataLayerTarget);
  let hasInsertedTag;
  const {
    activeModules,
    referenceSiteURL,
    userIDHash,
    userRoles = [],
    isAuthenticated,
    pluginVersion
  } = config;

  /**
   * Injects the necessary script tag if not present.
   *
   * @since 1.118.0
   *
   * @return {boolean|Object} Tag src as scriptTagSrc property.
   */
  return function initializeSnippet() {
    const {
      document
    } = __webpack_require__.g;
    if (undefined === hasInsertedTag) {
      hasInsertedTag = !!document.querySelector(`script[${_constants__WEBPACK_IMPORTED_MODULE_1__.SCRIPT_IDENTIFIER}]`);
    }
    if (hasInsertedTag) {
      return false;
    }
    hasInsertedTag = true;

    // Sometimes the user roles returned by Site Kit/WordPress is not an
    // array, as expected, so we guard against it here.
    //
    // See: https://github.com/google/site-kit-wp/issues/8266
    const userRolesAsString = userRoles?.length ? userRoles.join(',') : '';

    // We should use the real time, and not the reference date, when
    // measuring when we initialized tracking.
    dataLayerPush('js', new Date()); // eslint-disable-line sitekit/no-direct-date
    dataLayerPush('config', config.trackingID, {
      groups: 'site_kit',
      send_page_view: config.isSiteKitScreen,
      domain: referenceSiteURL,
      plugin_version: pluginVersion || '',
      enabled_features: Array.from(_js_features_index__WEBPACK_IMPORTED_MODULE_2__.enabledFeatures).join(','),
      active_modules: activeModules.join(','),
      authenticated: isAuthenticated ? '1' : '0',
      user_properties: {
        user_roles: userRolesAsString,
        user_identifier: userIDHash
      }
    });

    // If not present, inject it and initialize dataLayer.
    const scriptTag = document.createElement('script');
    scriptTag.setAttribute(_constants__WEBPACK_IMPORTED_MODULE_1__.SCRIPT_IDENTIFIER, '');
    scriptTag.async = true;
    scriptTag.src = `https://www.googletagmanager.com/gtag/js?id=${config.trackingID}&l=${_constants__WEBPACK_IMPORTED_MODULE_1__.DATA_LAYER}`;
    document.head.appendChild(scriptTag);
    return {
      scriptTagSrc: `https://www.googletagmanager.com/gtag/js?id=${config.trackingID}&l=${_constants__WEBPACK_IMPORTED_MODULE_1__.DATA_LAYER}`
    };
  };
}

/***/ }),

/***/ "./js/util/tracking/createTrackEvent.js":
/*!**********************************************!*\
  !*** ./js/util/tracking/createTrackEvent.js ***!
  \**********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ createTrackEvent)
/* harmony export */ });
/* harmony import */ var _createDataLayerPush__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./createDataLayerPush */ "./js/util/tracking/createDataLayerPush.js");
/**
 * Internal dependencies
 */


/**
 * Returns a function which, when invoked tracks a single event.
 *
 * @since 1.3.0
 *
 * @param {Object}   config            Tracking configuration.
 * @param {Object}   dataLayerTarget   Data layer parent object.
 * @param {Function} initializeSnippet Function to initialize tracking.
 * @param {Object}   _global           The global window object.
 * @return {Function} Function that tracks an event.
 */
function createTrackEvent(config, dataLayerTarget, initializeSnippet, _global) {
  const dataLayerPush = (0,_createDataLayerPush__WEBPACK_IMPORTED_MODULE_0__["default"])(dataLayerTarget);

  /**
   * Send an Analytics tracking event.
   *
   * @since 1.3.0
   *
   * @param {string} category The category of the event.
   * @param {string} action   The action name of the event.
   * @param {string} [label]  Optional. The label of the event.
   * @param {number} [value]  Optional. A non-negative integer that will appear as the event value.
   * @return {Promise} Promise that always resolves.
   */
  // eslint-disable-next-line require-await
  return async function trackEvent(category, action, label, value) {
    const {
      trackingEnabled
    } = config;
    if (!trackingEnabled) {
      // Resolve immediately if tracking is disabled.
      return null;
    }
    initializeSnippet();
    const eventData = {
      send_to: 'site_kit',
      event_category: category,
      event_label: label,
      value
    };
    return new Promise(resolve => {
      // This timeout ensures a tracking event does not block the user
      // event if it is not sent (in time).
      // If the event beacon fails, it shouldn't reject the promise since event
      // tracking should not result in user-facing errors. It will just
      // trigger a console warning.
      function failCallback() {
        _global.console.warn(`Tracking event "${action}" (category "${category}") took too long to fire.`);
        resolve();
      }
      const failTimeout = setTimeout(failCallback, 1000);
      // eslint-disable-next-line camelcase
      function event_callback() {
        clearTimeout(failTimeout);
        resolve();
      }
      dataLayerPush('event', action, {
        ...eventData,
        event_callback
      });

      // If the client-side opt-out is present, the event_callback will never be called
      // so we call it here to prevent the warning and added delay.
      if (_global._gaUserPrefs?.ioo?.()) {
        event_callback();
      }
    });
  };
}

/***/ }),

/***/ "./js/util/tracking/createTracking.js":
/*!********************************************!*\
  !*** ./js/util/tracking/createTracking.js ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ createTracking)
/* harmony export */ });
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! lodash */ "../node_modules/lodash/lodash.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _createInitializeSnippet__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./createInitializeSnippet */ "./js/util/tracking/createInitializeSnippet.js");
/* harmony import */ var _createTrackEvent__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./createTrackEvent */ "./js/util/tracking/createTrackEvent.js");
/**
 * Site Kit by Google, Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * Internal dependencies
 */


const DEFAULT_CONFIG = {
  activeModules: [],
  isAuthenticated: false,
  referenceSiteURL: '',
  trackingEnabled: false,
  trackingID: '',
  userIDHash: '',
  userRoles: []
};

/**
 * Initializes tracking.
 *
 * @since 1.3.0
 *
 * @param {Object} newConfig       New configuration.
 * @param {Object} dataLayerTarget Data layer parent object.
 * @param {Object} _global         The global window object.
 * @return {Object} Tracking config.
 */
function createTracking(newConfig, dataLayerTarget = __webpack_require__.g, _global = __webpack_require__.g) {
  const config = {
    ...DEFAULT_CONFIG,
    ...newConfig
  };
  // Remove any trailing slash from the reference URL.
  if (config.referenceSiteURL) {
    config.referenceSiteURL = config.referenceSiteURL.toString().replace(/\/+$/, '');
  }
  const initializeSnippet = (0,_createInitializeSnippet__WEBPACK_IMPORTED_MODULE_1__["default"])(config, dataLayerTarget);
  const trackEvent = (0,_createTrackEvent__WEBPACK_IMPORTED_MODULE_2__["default"])(config, dataLayerTarget, initializeSnippet, _global);
  const onceTrackedEventsMap = {};
  function trackEventOnce(...params) {
    const key = JSON.stringify(params);
    if (!onceTrackedEventsMap[key]) {
      onceTrackedEventsMap[key] = (0,lodash__WEBPACK_IMPORTED_MODULE_0__.once)(trackEvent);
    }
    onceTrackedEventsMap[key](...params);
  }
  return {
    enableTracking: function enableTracking() {
      config.trackingEnabled = true;
    },
    disableTracking: function disableTracking() {
      config.trackingEnabled = false;
    },
    initializeSnippet,
    isTrackingEnabled: function isTrackingEnabled() {
      return !!config.trackingEnabled;
    },
    trackEvent,
    trackEventOnce
  };
}

/***/ }),

/***/ "./js/util/tracking/index.js":
/*!***********************************!*\
  !*** ./js/util/tracking/index.js ***!
  \***********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   disableTracking: () => (/* binding */ disableTracking),
/* harmony export */   enableTracking: () => (/* binding */ enableTracking),
/* harmony export */   isTrackingEnabled: () => (/* binding */ isTrackingEnabled),
/* harmony export */   toggleTracking: () => (/* binding */ toggleTracking),
/* harmony export */   trackEvent: () => (/* binding */ trackEvent),
/* harmony export */   trackEventOnce: () => (/* binding */ trackEventOnce)
/* harmony export */ });
/* harmony import */ var _createTracking__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./createTracking */ "./js/util/tracking/createTracking.js");
/**
 * Event tracking utilities.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/* eslint-disable sitekit/jsdoc-no-unnamed-boolean-params */

/**
 * Internal dependencies
 */

const {
  activeModules = [],
  isSiteKitScreen,
  trackingEnabled,
  trackingID,
  referenceSiteURL,
  userIDHash,
  isAuthenticated,
  userRoles
} = __webpack_require__.g._googlesitekitTrackingData || {};
const {
  GOOGLESITEKIT_VERSION: pluginVersion
} = __webpack_require__.g;
const initialConfig = {
  activeModules,
  trackingEnabled,
  trackingID,
  referenceSiteURL,
  userIDHash,
  isSiteKitScreen,
  userRoles,
  isAuthenticated,
  pluginVersion
};
const {
  enableTracking,
  disableTracking,
  isTrackingEnabled,
  initializeSnippet,
  trackEvent,
  trackEventOnce
} = (0,_createTracking__WEBPACK_IMPORTED_MODULE_0__["default"])(initialConfig);

/**
 * Changes the active state of tracking.
 *
 * @since 1.3.0
 *
 * @param {boolean} activeStatus The new state to set.
 */
function toggleTracking(activeStatus) {
  if (!!activeStatus) {
    enableTracking();
  } else {
    disableTracking();
  }
}

// Bootstrap on import if tracking is allowed.
if (isSiteKitScreen && trackingEnabled) {
  initializeSnippet();
}


/***/ }),

/***/ "./js/util/urls.js":
/*!*************************!*\
  !*** ./js/util/urls.js ***!
  \*************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   getFullURL: () => (/* binding */ getFullURL),
/* harmony export */   getURLPath: () => (/* binding */ getURLPath),
/* harmony export */   isHashOnly: () => (/* binding */ isHashOnly),
/* harmony export */   normalizeURL: () => (/* binding */ normalizeURL),
/* harmony export */   shortenURL: () => (/* binding */ shortenURL)
/* harmony export */ });
/* harmony import */ var _wordpress_url__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/url */ "../node_modules/@wordpress/url/build-module/is-url.js");
/**
 * URL pathname getter utility function.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */


/**
 * Returns the path from a URL, omitting its protocol, hostname, query params, and hash.
 *
 * @since 1.24.0
 *
 * @param {string} url The URL to get the path from.
 * @return {string} The URL path.
 */
function getURLPath(url) {
  try {
    return new URL(url).pathname;
  } catch {}
  return null;
}

/**
 * Returns the absolute URL from a path including the siteURL.
 *
 * @since 1.32.0
 *
 * @param {string} siteURL The siteURL fo the WordPress install.
 * @param {string} path    The path.
 * @return {string} The URL path.
 */
function getFullURL(siteURL, path) {
  try {
    return new URL(path, siteURL).href;
  } catch {}
  return (typeof siteURL === 'string' ? siteURL : '') + (typeof path === 'string' ? path : '');
}

/**
 * Normalizes URL by removing protocol, www subdomain and trailing slash.
 *
 * @since 1.33.0
 *
 * @param {string} incomingURL The original URL.
 * @return {string} Normalized URL.
 */
function normalizeURL(incomingURL) {
  if (typeof incomingURL !== 'string') {
    return incomingURL;
  }
  return incomingURL
  // Remove protocol and optional "www." prefix from the URL.
  .replace(/^https?:\/\/(www\.)?/i, '')
  // Remove trailing slash.
  .replace(/\/$/, '');
}

/**
 * Checks if a string is not a full URL and simply a hash / anchor link.
 *
 * @since 1.49.0
 *
 * @param {string} url The URL or Hash string to test.
 * @return {boolean} Returns true if the string is only a hash and not a full URL.
 */
function isHashOnly(url) {
  return /^#\w[A-Za-z0-9-_]*$/.test(url);
}

/**
 * Shortens a URL to fit a given length.
 *
 * @since 1.49.0
 *
 * @param {string} url      The original URL to shorten.
 * @param {number} maxChars The maximum length of the URL.
 * @return {string} The shortened URL.
 */
function shortenURL(url, maxChars) {
  if (!(0,_wordpress_url__WEBPACK_IMPORTED_MODULE_0__.isURL)(url)) {
    return url;
  }
  if (url.length <= maxChars) {
    return url;
  }
  const urlObject = new URL(url);
  const shortenedURL = url.replace(urlObject.origin, '');
  if (shortenedURL.length < maxChars) {
    return shortenedURL;
  }
  const extraChars = shortenedURL.length - Math.floor(maxChars) + 1; // 1 is the length of "…".
  return '…' + shortenedURL.substr(extraChars);
}

/***/ }),

/***/ "./js/util/when-active.js":
/*!********************************!*\
  !*** ./js/util/when-active.js ***!
  \********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ whenActive)
/* harmony export */ });
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/googlesitekit/modules/datastore/constants */ "./js/googlesitekit/modules/datastore/constants.js");
/* harmony import */ var _js_googlesitekit_data_transform_case__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/googlesitekit/data/transform-case */ "./js/googlesitekit/data/transform-case.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * `whenActive` HOC.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Internal dependencies
 */




/**
 * Higher-Order Component to render wrapped components when selected module is active and connected.
 *
 * A higher-order component is used here instead of hooks because there is potential for
 * related selectors in components this HOC wraps to call out to resolvers that call endpoints
 * for modules that aren't active. This would cause 404s at best and possibly errors, so
 * it's better to wrap them in HOCs and "return early".
 *
 * @since 1.16.0
 *
 * @param {Object}      options                       Options for enhancing function.
 * @param {string}      options.moduleName            Name of a module to check.
 * @param {WPComponent} [options.FallbackComponent]   Optional. Fallback component to render when the module is not active.
 * @param {WPComponent} [options.IncompleteComponent] Optional. Fallback component to render when the module is active but not connected.
 * @return {Function} Enhancing function.
 */

function whenActive({
  moduleName,
  FallbackComponent,
  IncompleteComponent
}) {
  return WrappedComponent => {
    function WhenActiveComponent(props) {
      const module = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useSelect)(select => select(_js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_1__.CORE_MODULES).getModule(moduleName), [moduleName]);

      // Return null if the module is not loaded yet or doesn't exist.
      if (!module) {
        return null;
      }

      // This component isn't widget-specific but widgets need to use `WidgetNull`
      // from props when rendering "null" output.
      const DefaultFallbackComponent = FallbackComponent || props.WidgetNull || null;

      // Return a fallback if the module is not active.
      if (module.active === false) {
        return DefaultFallbackComponent && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(DefaultFallbackComponent, {
          ...props
        });
      }

      // Return a fallback if the module is active but not connected yet.
      if (module.connected === false) {
        // If no IncompleteComponent is provided, use the default fallback.
        const IncompleteFallbackComponent = IncompleteComponent || DefaultFallbackComponent;
        return IncompleteFallbackComponent && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(IncompleteFallbackComponent, {
          ...props
        });
      }

      // Return the active and connected component.
      return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(WrappedComponent, {
        ...props
      });
    }
    WhenActiveComponent.displayName = `When${(0,_js_googlesitekit_data_transform_case__WEBPACK_IMPORTED_MODULE_2__.hyphenCaseToPascalCase)(moduleName)}Active`;
    if (WrappedComponent.displayName || WrappedComponent.name) {
      WhenActiveComponent.displayName += `(${WrappedComponent.displayName || WrappedComponent.name})`;
    }
    return WhenActiveComponent;
  };
}

/***/ }),

/***/ "./svg/graphics/pagespeed-insights.svg":
/*!*********************************************!*\
  !*** ./svg/graphics/pagespeed-insights.svg ***!
  \*********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "../node_modules/react/index.js");
var _defs, _path, _path2, _path3, _path4, _path5, _path6, _circle, _circle2, _path7, _path8, _path9, _path0;
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }

const SvgPagespeedInsights = props => /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("svg", _extends({
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 183.95 158.81"
}, props), _defs || (_defs = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("defs", null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("radialGradient", {
  id: "pagespeed-insights_svg__b",
  cx: 1360.51,
  cy: 10958.05,
  r: 458.83,
  gradientTransform: "matrix(.5 0 0 .5 -675.69 -5476.24)",
  gradientUnits: "userSpaceOnUse"
}, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("stop", {
  offset: 0,
  stopColor: "#fff",
  stopOpacity: 0.1
}), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("stop", {
  offset: 1,
  stopColor: "#fff",
  stopOpacity: 0
})), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("linearGradient", {
  id: "pagespeed-insights_svg__a",
  x1: 1572.36,
  x2: 1691.74,
  y1: 11164.11,
  y2: 11283.49,
  gradientTransform: "matrix(.5 0 0 .5 -675.69 -5476.24)",
  gradientUnits: "userSpaceOnUse"
}, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("stop", {
  offset: 0,
  stopColor: "#212121",
  stopOpacity: 0.2
}), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("stop", {
  offset: 1,
  stopColor: "#212121",
  stopOpacity: 0
})))), _path || (_path = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("path", {
  fill: "#e1e1e1",
  d: "M183.93 25.08v121.19a12.53 12.53 0 0 1-12.54 12.54H12.58A12.53 12.53 0 0 1 0 146.27V25.08z"
})), _path2 || (_path2 = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("path", {
  fill: "#c2c2c2",
  d: "M12.58 0h158.81a12.53 12.53 0 0 1 12.54 12.54v12.54H0V12.54A12.53 12.53 0 0 1 12.58 0"
})), _path3 || (_path3 = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("path", {
  fill: "#fff",
  fillOpacity: 0.2,
  d: "M171.39 0H12.58A12.57 12.57 0 0 0 0 12.54v1A12.58 12.58 0 0 1 12.58 1h158.81a12.59 12.59 0 0 1 12.54 12.54v-1A12.58 12.58 0 0 0 171.39 0"
})), _path4 || (_path4 = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("path", {
  fill: "#212121",
  fillOpacity: 0.1,
  d: "M0 25.08h183.93v1H0z"
})), _path5 || (_path5 = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("path", {
  fill: "#4285f4",
  d: "M91.91 62.69a66.76 66.76 0 0 0-66.76 66.86c0 1.4-.09 3.14 0 4.18h29.13a36 36 0 0 1 0-4.18 37.64 37.64 0 0 1 57.36-32l21-21a66.62 66.62 0 0 0-40.73-13.86"
})), _path6 || (_path6 = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("path", {
  fill: "#f44336",
  d: "m132.64 76.52-21 21a37.59 37.59 0 0 1 17.9 32 36 36 0 0 1 0 4.18h29.27c.08-1 0-2.78 0-4.18a66.73 66.73 0 0 0-26.17-53"
})), _circle || (_circle = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("circle", {
  cx: 16.76,
  cy: 12.54,
  r: 4.18,
  fill: "#eee"
})), _circle2 || (_circle2 = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("circle", {
  cx: 33.48,
  cy: 12.54,
  r: 4.18,
  fill: "#eee"
})), _path7 || (_path7 = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("path", {
  fill: "#212121",
  fillOpacity: 0.1,
  d: "M171.41 157.76H12.54A12.57 12.57 0 0 1 0 145.23v1a12.57 12.57 0 0 0 12.54 12.54h158.87a12.58 12.58 0 0 0 12.59-12.5v-1a12.58 12.58 0 0 1-12.54 12.53z"
})), _path8 || (_path8 = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("path", {
  fill: "#9e9e9e",
  d: "M132.86 79.06a2.06 2.06 0 0 0 .39-1.22 2.1 2.1 0 0 0-2.09-2.09 2 2 0 0 0-1.28.46l-45.57 35.07a12.53 12.53 0 1 0 18.37 16.41l30.17-48.65z"
})), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("path", {
  fill: "#fff",
  d: "m84.31 112.33 45.57-35.09a2.06 2.06 0 0 1 1.28-.46 2.09 2.09 0 0 1 2 1.55 2 2 0 0 0-2-2.59 2 2 0 0 0-1.28.46l-45.57 35.07a12.5 12.5 0 0 0-4.87 9.92v.56a12.49 12.49 0 0 1 4.87-9.42",
  opacity: 0.2,
  style: {
    isolation: "isolate"
  }
}), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("path", {
  fill: "#212121",
  d: "m132.86 79.06-30.17 48.65a12.51 12.51 0 0 1-23.21-5.93v.48a12.52 12.52 0 0 0 23.24 6.5l30.14-48.66a2 2 0 0 0 .39-1.22 2 2 0 0 0-.08-.54 2.3 2.3 0 0 1-.31.72",
  opacity: 0.2,
  style: {
    isolation: "isolate"
  }
}), _path9 || (_path9 = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("path", {
  fill: "url(#pagespeed-insights_svg__a)",
  d: "M132.82 76.58a2 2 0 0 1 .43 1.26 2.06 2.06 0 0 1-.39 1.22l-30.17 48.65a12.53 12.53 0 0 1-18.84 3.05l28.08 28.07h59.47a12.53 12.53 0 0 0 12.54-12.54v-18.61z"
})), _path0 || (_path0 = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("path", {
  fill: "url(#pagespeed-insights_svg__b)",
  d: "M183.93 12.54A12.53 12.53 0 0 0 171.39 0H12.58A12.53 12.53 0 0 0 0 12.54v133.73a12.53 12.53 0 0 0 12.54 12.54h158.85a12.53 12.53 0 0 0 12.54-12.54z"
})));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (SvgPagespeedInsights);

/***/ }),

/***/ "./svg/graphics/zero-state-yellow.svg":
/*!********************************************!*\
  !*** ./svg/graphics/zero-state-yellow.svg ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "../node_modules/react/index.js");
var _path, _path2, _path3, _path4, _path5, _path6, _path7, _ellipse, _path8;
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }

const SvgZeroStateYellow = props => /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("svg", _extends({
  xmlns: "http://www.w3.org/2000/svg",
  fill: "none",
  viewBox: "0 0 400 400"
}, props), _path || (_path = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("path", {
  stroke: "#F29900",
  strokeLinejoin: "round",
  strokeWidth: 9.4,
  d: "M281.11 316.17a16 16 0 0 1-20.69 15.23M118.86 316.17a16 16 0 0 0 20.69 15.23M201 300.22h-66.19a16 16 0 0 0-16 15.95"
})), _path2 || (_path2 = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("path", {
  stroke: "#F29900",
  strokeLinejoin: "round",
  strokeWidth: 9.4,
  d: "M198.06 300.22h67.1a16 16 0 0 1 15.95 15.95"
})), _path3 || (_path3 = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("path", {
  stroke: "#FBBC04",
  strokeLinejoin: "round",
  strokeWidth: 9.4,
  d: "M249.64 206.74c-1.42 24.59 12.3 59.39 35.05 71.31 15.3 8 34.85 1.6 37.66-16.54C324.46 247.84 316.82 233 308 223c0 0 14.73-2.8 14.73-21.22M150.36 206.74c1.42 24.59-12.3 59.39-35.05 71.31-15.3 8-34.85 1.6-37.66-16.54C75.54 247.84 83.18 233 92 223c0 0-14.73-2.8-14.73-21.22"
})), _path4 || (_path4 = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("path", {
  fill: "#F9AB00",
  d: "M145.23 76.68h109.53v219.7H145.23z"
})), _path5 || (_path5 = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("path", {
  stroke: "#FFF",
  strokeMiterlimit: 10,
  strokeWidth: 6.66,
  d: "M172.74 142.94c13.38 16.48 37.19 21.05 54.28 0"
})), _path6 || (_path6 = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("path", {
  stroke: "#F29900",
  strokeLinejoin: "round",
  strokeWidth: 9.4,
  d: "m260.42 331.4-141.56-45.03-10.4 28.08"
})), _path7 || (_path7 = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("path", {
  stroke: "#F29900",
  strokeLinejoin: "round",
  strokeWidth: 9.4,
  d: "m139.55 331.4 141.56-45.03 10.4 28.08"
})), _ellipse || (_ellipse = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("ellipse", {
  cx: 200,
  cy: 381.74,
  fill: "#F1F3F4",
  rx: 79.51,
  ry: 8.26
})), _path8 || (_path8 = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("path", {
  stroke: "#E8EAED",
  strokeLinecap: "round",
  strokeMiterlimit: 10,
  strokeWidth: 6,
  d: "M200 10v31.42M105 35.46l15.71 27.2M35.46 105l27.2 15.71M10 200h31.42M35.46 295l27.2-15.71M364.54 295l-27.2-15.71M390 200h-31.42M364.54 105l-27.2 15.71M295 35.46l-15.71 27.2"
})));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (SvgZeroStateYellow);

/***/ }),

/***/ "./svg/icons/arrow-inverse.svg":
/*!*************************************!*\
  !*** ./svg/icons/arrow-inverse.svg ***!
  \*************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "../node_modules/react/index.js");
var _g;
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }

const SvgArrowInverse = props => /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("svg", _extends({
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 13 13"
}, props), _g || (_g = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("g", {
  fill: "none",
  fillRule: "evenodd"
}, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("circle", {
  cx: 6.5,
  cy: 6.5,
  r: 6.5,
  fill: "#FFF"
}), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("path", {
  fill: "currentColor",
  d: "M3.461 6.96h5.15L6.36 9.21a.464.464 0 0 0 .325.79.46.46 0 0 0 .325-.135l3.037-3.038a.46.46 0 0 0 0-.65L7.015 3.135a.46.46 0 0 0-.65.65L8.61 6.039H3.461a.46.46 0 0 0-.461.46c0 .254.207.462.461.462z"
}), ".")));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (SvgArrowInverse);

/***/ }),

/***/ "./svg/icons/arrow.svg":
/*!*****************************!*\
  !*** ./svg/icons/arrow.svg ***!
  \*****************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "../node_modules/react/index.js");
var _g;
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }

const SvgArrow = props => /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("svg", _extends({
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 13 13"
}, props), _g || (_g = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("g", {
  fill: "none",
  fillRule: "evenodd"
}, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("circle", {
  cx: 6.5,
  cy: 6.5,
  r: 6.5,
  fill: "currentColor"
}), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("path", {
  fill: "#FFF",
  d: "M3.461 6.96h5.15L6.36 9.21a.464.464 0 0 0 .325.79.46.46 0 0 0 .325-.135l3.037-3.038a.46.46 0 0 0 0-.65L7.015 3.135a.46.46 0 0 0-.65.65L8.61 6.039H3.461a.46.46 0 0 0-.461.46c0 .254.207.462.461.462z"
}), ".")));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (SvgArrow);

/***/ }),

/***/ "./svg/icons/back.svg":
/*!****************************!*\
  !*** ./svg/icons/back.svg ***!
  \****************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "../node_modules/react/index.js");
var _path;
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }

const SvgBack = props => /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("svg", _extends({
  xmlns: "http://www.w3.org/2000/svg",
  fill: "currentColor",
  viewBox: "0 0 24 24"
}, props), _path || (_path = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("path", {
  d: "m12 20-8-8 8-8 1.425 1.4-5.6 5.6H20v2H7.825l5.6 5.6z"
})));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (SvgBack);

/***/ }),

/***/ "./svg/icons/check-fill.svg":
/*!**********************************!*\
  !*** ./svg/icons/check-fill.svg ***!
  \**********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "../node_modules/react/index.js");
var _path;
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }

const SvgCheckFill = props => /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("svg", _extends({
  xmlns: "http://www.w3.org/2000/svg",
  fill: "none",
  viewBox: "0 0 24 24"
}, props), _path || (_path = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("path", {
  fill: "currentColor",
  fillRule: "evenodd",
  d: "M12 1C5.925 1 1 5.925 1 12s4.925 11 11 11 11-4.925 11-11S18.075 1 12 1m4.806 8.592.592-.806-1.612-1.184-.592.806-3.89 5.296c-.166.226-.36.296-.512.296s-.346-.07-.512-.296l-1.474-2.007-.592-.806-1.612 1.184.592.806 1.474 2.007C9.191 15.6 9.971 16 10.792 16s1.6-.4 2.124-1.112z",
  clipRule: "evenodd"
})));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (SvgCheckFill);

/***/ }),

/***/ "./svg/icons/chevron-down-v2.svg":
/*!***************************************!*\
  !*** ./svg/icons/chevron-down-v2.svg ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "../node_modules/react/index.js");
var _path;
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }

const SvgChevronDownV2 = props => /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("svg", _extends({
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 12 8"
}, props), _path || (_path = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("path", {
  fill: "currentColor",
  fillRule: "evenodd",
  d: "M10.6.6 12 2 6 8 0 2 1.4.6 6 5.2z"
})));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (SvgChevronDownV2);

/***/ }),

/***/ "./svg/icons/device-size-desktop-icon.svg":
/*!************************************************!*\
  !*** ./svg/icons/device-size-desktop-icon.svg ***!
  \************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "../node_modules/react/index.js");
var _path, _path2;
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }

const SvgDeviceSizeDesktopIcon = props => /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("svg", _extends({
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 4 24 16"
}, props), _path || (_path = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("path", {
  fill: "none",
  d: "M0 0h24v24H0z"
})), _path2 || (_path2 = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("path", {
  fill: "currentColor",
  d: "M20 18c1.1 0 1.99-.9 1.99-2L22 6c0-1.1-.9-2-2-2H4c-1.1 0-2 .9-2 2v10c0 1.1.9 2 2 2H0v2h24v-2zM4 6h16v10H4z"
})));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (SvgDeviceSizeDesktopIcon);

/***/ }),

/***/ "./svg/icons/device-size-mobile-icon.svg":
/*!***********************************************!*\
  !*** ./svg/icons/device-size-mobile-icon.svg ***!
  \***********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "../node_modules/react/index.js");
var _path, _path2;
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }

const SvgDeviceSizeMobileIcon = props => /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("svg", _extends({
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "5 1 14 22"
}, props), _path || (_path = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("path", {
  fill: "none",
  d: "M0 0h24v24H0z"
})), _path2 || (_path2 = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("path", {
  fill: "currentColor",
  d: "M17 1.01 7 1c-1.1 0-2 .9-2 2v18c0 1.1.9 2 2 2h10c1.1 0 2-.9 2-2V3c0-1.1-.9-1.99-2-1.99M17 19H7V5h10z"
})));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (SvgDeviceSizeMobileIcon);

/***/ }),

/***/ "./svg/icons/external.svg":
/*!********************************!*\
  !*** ./svg/icons/external.svg ***!
  \********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "../node_modules/react/index.js");
var _path;
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }

const SvgExternal = props => /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("svg", _extends({
  xmlns: "http://www.w3.org/2000/svg",
  fill: "currentColor",
  viewBox: "0 0 24 24"
}, props), _path || (_path = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("path", {
  d: "M5 21a2 2 0 0 1-1.425-.575A2 2 0 0 1 3 19V5q0-.825.575-1.4Q4.175 3 5 3h7v2H5v14h14v-7h2v7q0 .825-.6 1.425Q19.825 21 19 21zm4.7-5.3-1.4-1.4L17.6 5H14V3h7v7h-2V6.4z"
})));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (SvgExternal);

/***/ }),

/***/ "./svg/icons/info-green.svg":
/*!**********************************!*\
  !*** ./svg/icons/info-green.svg ***!
  \**********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "../node_modules/react/index.js");
var _path;
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }

const SvgInfoGreen = props => /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("svg", _extends({
  xmlns: "http://www.w3.org/2000/svg",
  fill: "none",
  viewBox: "0 0 16 16"
}, props), _path || (_path = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("path", {
  fill: "currentColor",
  d: "M7.334 11.333h1.333v-4H7.334zM8.001 6a.658.658 0 0 0 .667-.667.6.6 0 0 0-.2-.467.6.6 0 0 0-.467-.2.66.66 0 0 0-.667.667q0 .284.183.483A.7.7 0 0 0 8.001 6m0 8.666a6.6 6.6 0 0 1-2.6-.516 6.9 6.9 0 0 1-2.117-1.434A6.9 6.9 0 0 1 1.851 10.6 6.6 6.6 0 0 1 1.334 8q0-1.385.517-2.6a6.9 6.9 0 0 1 1.433-2.117q.9-.9 2.117-1.417A6.4 6.4 0 0 1 8 1.333q1.383 0 2.6.533a6.6 6.6 0 0 1 2.116 1.417q.9.9 1.417 2.117.533 1.215.533 2.6 0 1.383-.533 2.6a6.6 6.6 0 0 1-1.417 2.116 6.9 6.9 0 0 1-2.116 1.434 6.6 6.6 0 0 1-2.6.516m0-1.333q2.233 0 3.783-1.55T13.334 8t-1.55-3.784-3.783-1.55-3.784 1.55T2.667 8t1.55 3.783 3.784 1.55"
})));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (SvgInfoGreen);

/***/ }),

/***/ "./svg/icons/star-fill.svg":
/*!*********************************!*\
  !*** ./svg/icons/star-fill.svg ***!
  \*********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "../node_modules/react/index.js");
var _path;
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }

const SvgStarFill = props => /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("svg", _extends({
  xmlns: "http://www.w3.org/2000/svg",
  fill: "none",
  viewBox: "0 0 24 24"
}, props), _path || (_path = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("path", {
  fill: "currentColor",
  d: "m5.825 22 2.325-7.6L2 10h7.6L12 2l2.4 8H22l-6.15 4.4 2.325 7.6L12 17.3z"
})));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (SvgStarFill);

/***/ }),

/***/ "./svg/icons/warning-notice.svg":
/*!**************************************!*\
  !*** ./svg/icons/warning-notice.svg ***!
  \**************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "../node_modules/react/index.js");
var _path;
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }

const SvgWarningNotice = props => /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("svg", _extends({
  xmlns: "http://www.w3.org/2000/svg",
  fill: "none",
  viewBox: "0 0 24 24"
}, props), _path || (_path = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("path", {
  fill: "currentColor",
  d: "M12 1c6.075 0 11 4.925 11 11s-4.925 11-11 11S1 18.075 1 12 5.925 1 12 1m0 14a1.5 1.5 0 1 0 0 3 1.5 1.5 0 0 0 0-3m-1-2h2V6h-2z"
})));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (SvgWarningNotice);

/***/ }),

/***/ "@wordpress/i18n":
/*!*****************************************!*\
  !*** external ["googlesitekit","i18n"] ***!
  \*****************************************/
/***/ ((module) => {

module.exports = googlesitekit.i18n;

/***/ }),

/***/ "googlesitekit-api":
/*!****************************************!*\
  !*** external ["googlesitekit","api"] ***!
  \****************************************/
/***/ ((module) => {

module.exports = googlesitekit.api;

/***/ }),

/***/ "googlesitekit-components":
/*!***********************************************!*\
  !*** external ["googlesitekit","components"] ***!
  \***********************************************/
/***/ ((module) => {

module.exports = googlesitekit.components;

/***/ }),

/***/ "googlesitekit-data":
/*!*****************************************!*\
  !*** external ["googlesitekit","data"] ***!
  \*****************************************/
/***/ ((module) => {

module.exports = googlesitekit.data;

/***/ }),

/***/ "googlesitekit-modules":
/*!********************************************!*\
  !*** external ["googlesitekit","modules"] ***!
  \********************************************/
/***/ ((module) => {

module.exports = googlesitekit.modules;

/***/ }),

/***/ "googlesitekit-notifications":
/*!**************************************************!*\
  !*** external ["googlesitekit","notifications"] ***!
  \**************************************************/
/***/ ((module) => {

module.exports = googlesitekit.notifications;

/***/ }),

/***/ "googlesitekit-widgets":
/*!********************************************!*\
  !*** external ["googlesitekit","widgets"] ***!
  \********************************************/
/***/ ((module) => {

module.exports = googlesitekit.widgets;

/***/ })

},
/******/ __webpack_require__ => { // webpackRuntimeModules
/******/ var __webpack_exec__ = (moduleId) => (__webpack_require__(__webpack_require__.s = moduleId))
/******/ __webpack_require__.O(0, ["googlesitekit-vendor"], () => (__webpack_exec__("./js/googlesitekit-modules-pagespeed-insights.js")));
/******/ var __webpack_exports__ = __webpack_require__.O();
/******/ }
]);
//# sourceMappingURL=googlesitekit-modules-pagespeed-insights.js.map