"use strict";
(globalThis["__googlesitekit_webpackJsonp"] = globalThis["__googlesitekit_webpackJsonp"] || []).push([["googlesitekit-main-dashboard"],{

/***/ "./js/api-fetch-shim.js":
/*!******************************!*\
  !*** ./js/api-fetch-shim.js ***!
  \******************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   __esModule: () => (/* reexport safe */ _wordpress_api_fetch_non_shim__WEBPACK_IMPORTED_MODULE_0__.__esModule),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_api_fetch_non_shim__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/api-fetch__non-shim */ "../node_modules/@wordpress/api-fetch/build/index.js");
/* harmony import */ var _googlesitekit_api_middleware_preloading_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./googlesitekit/api/middleware/preloading.js */ "./js/googlesitekit/api/middleware/preloading.js");
/**
 * API Fetch Shim.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */

const {
  nonce,
  nonceEndpoint,
  preloadedData,
  rootURL
} = __webpack_require__.g._googlesitekitAPIFetchData || {};
_wordpress_api_fetch_non_shim__WEBPACK_IMPORTED_MODULE_0__["default"].nonceEndpoint = nonceEndpoint;
_wordpress_api_fetch_non_shim__WEBPACK_IMPORTED_MODULE_0__["default"].nonceMiddleware = _wordpress_api_fetch_non_shim__WEBPACK_IMPORTED_MODULE_0__["default"].createNonceMiddleware(nonce);
_wordpress_api_fetch_non_shim__WEBPACK_IMPORTED_MODULE_0__["default"].rootURLMiddleware = _wordpress_api_fetch_non_shim__WEBPACK_IMPORTED_MODULE_0__["default"].createRootURLMiddleware(rootURL);
_wordpress_api_fetch_non_shim__WEBPACK_IMPORTED_MODULE_0__["default"].preloadingMiddleware = (0,_googlesitekit_api_middleware_preloading_js__WEBPACK_IMPORTED_MODULE_1__["default"])(preloadedData);
_wordpress_api_fetch_non_shim__WEBPACK_IMPORTED_MODULE_0__["default"].use(_wordpress_api_fetch_non_shim__WEBPACK_IMPORTED_MODULE_0__["default"].nonceMiddleware);
_wordpress_api_fetch_non_shim__WEBPACK_IMPORTED_MODULE_0__["default"].use(_wordpress_api_fetch_non_shim__WEBPACK_IMPORTED_MODULE_0__["default"].mediaUploadMiddleware);
_wordpress_api_fetch_non_shim__WEBPACK_IMPORTED_MODULE_0__["default"].use(_wordpress_api_fetch_non_shim__WEBPACK_IMPORTED_MODULE_0__["default"].rootURLMiddleware);
_wordpress_api_fetch_non_shim__WEBPACK_IMPORTED_MODULE_0__["default"].use(_wordpress_api_fetch_non_shim__WEBPACK_IMPORTED_MODULE_0__["default"].preloadingMiddleware);

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_wordpress_api_fetch_non_shim__WEBPACK_IMPORTED_MODULE_0__["default"]);

/***/ }),

/***/ "./js/components/AdminMenuTooltip/AdminMenuTooltip.js":
/*!************************************************************!*\
  !*** ./js/components/AdminMenuTooltip/AdminMenuTooltip.js ***!
  \************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   AdminMenuTooltip: () => (/* binding */ AdminMenuTooltip)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _js_components_JoyrideTooltip__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/components/JoyrideTooltip */ "./js/components/JoyrideTooltip.js");
/* harmony import */ var _js_googlesitekit_datastore_ui_constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/googlesitekit/datastore/ui/constants */ "./js/googlesitekit/datastore/ui/constants.js");
/* harmony import */ var _js_util__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/util */ "./js/util/index.js");
/* harmony import */ var _js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/hooks/useViewContext */ "./js/hooks/useViewContext.js");
/* harmony import */ var _js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/hooks/useBreakpoint */ "./js/hooks/useBreakpoint.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * AdminMenuTooltip component.
 *
 * Site Kit by Google, Copyright 2022 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */







function AdminMenuTooltip() {
  const viewContext = (0,_js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_4__["default"])();
  const {
    setValue
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useDispatch)(_js_googlesitekit_datastore_ui_constants__WEBPACK_IMPORTED_MODULE_2__.CORE_UI);
  const breakpoint = (0,_js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_5__.useBreakpoint)();
  const {
    isTooltipVisible = false,
    tooltipSlug,
    title,
    content,
    dismissLabel
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useSelect)(select => select(_js_googlesitekit_datastore_ui_constants__WEBPACK_IMPORTED_MODULE_2__.CORE_UI).getValue('admin-menu-tooltip') || {
    isTooltipVisible: false
  });
  function handleViewTooltip() {
    (0,_js_util__WEBPACK_IMPORTED_MODULE_3__.trackEvent)(`${viewContext}_${tooltipSlug}`, 'tooltip_view');
  }
  const handleDismissTooltip = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_7__.useCallback)(() => {
    // Track dismiss event.
    if (tooltipSlug) {
      (0,_js_util__WEBPACK_IMPORTED_MODULE_3__.trackEvent)(`${viewContext}_${tooltipSlug}`, 'tooltip_dismiss');
    }
    setValue('admin-menu-tooltip', undefined);
  }, [setValue, tooltipSlug, viewContext]);
  if (!isTooltipVisible) {
    return null;
  }
  const defaultTarget = '#adminmenu [href*="page=googlesitekit-settings"]';
  const isMobileTablet = breakpoint === _js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_5__.BREAKPOINT_SMALL || breakpoint === _js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_5__.BREAKPOINT_TABLET;
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(_js_components_JoyrideTooltip__WEBPACK_IMPORTED_MODULE_1__["default"], {
    target: isMobileTablet ? 'body' : defaultTarget,
    placement: isMobileTablet ? 'center' : 'right',
    className: isMobileTablet ? 'googlesitekit-tour-tooltip__modal_step' : 'googlesitekit-tour-tooltip__fixed-settings-tooltip',
    disableOverlay: !isMobileTablet,
    slug: "ga4-activation-banner-admin-menu-tooltip",
    title: title,
    content: content,
    dismissLabel: dismissLabel,
    onView: handleViewTooltip,
    onDismiss: handleDismissTooltip
  });
}

/***/ }),

/***/ "./js/components/AdminMenuTooltip/index.js":
/*!*************************************************!*\
  !*** ./js/components/AdminMenuTooltip/index.js ***!
  \*************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   AdminMenuTooltip: () => (/* reexport safe */ _AdminMenuTooltip__WEBPACK_IMPORTED_MODULE_1__.AdminMenuTooltip),
/* harmony export */   useShowTooltip: () => (/* reexport safe */ _useShowTooltip__WEBPACK_IMPORTED_MODULE_0__.useShowTooltip)
/* harmony export */ });
/* harmony import */ var _useShowTooltip__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./useShowTooltip */ "./js/components/AdminMenuTooltip/useShowTooltip.js");
/* harmony import */ var _AdminMenuTooltip__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./AdminMenuTooltip */ "./js/components/AdminMenuTooltip/AdminMenuTooltip.js");



/***/ }),

/***/ "./js/components/AdminMenuTooltip/useShowTooltip.js":
/*!**********************************************************!*\
  !*** ./js/components/AdminMenuTooltip/useShowTooltip.js ***!
  \**********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   useShowTooltip: () => (/* binding */ useShowTooltip)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _js_googlesitekit_datastore_ui_constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/googlesitekit/datastore/ui/constants */ "./js/googlesitekit/datastore/ui/constants.js");



function useShowTooltip(tooltipSettings) {
  const {
    setValue
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useDispatch)(_js_googlesitekit_datastore_ui_constants__WEBPACK_IMPORTED_MODULE_1__.CORE_UI);
  return (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useCallback)(() => {
    setValue('admin-menu-tooltip', {
      isTooltipVisible: true,
      ...tooltipSettings
    });
  }, [setValue, tooltipSettings]);
}

/***/ }),

/***/ "./js/components/Badge.js":
/*!********************************!*\
  !*** ./js/components/Badge.js ***!
  \********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Badge component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * WordPress dependencies
 */


const Badge = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.forwardRef)(({
  label,
  className,
  hasLeftSpacing = false,
  ...rest
}, ref) => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("span", {
  ref: ref,
  ...rest,
  className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-badge', className, {
    'googlesitekit-badge--has-left-spacing': hasLeftSpacing
  }),
  children: label
}));
Badge.displayName = 'Badge';
Badge.propTypes = {
  label: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string).isRequired,
  hasLeftSpacing: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().bool)
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Badge);

/***/ }),

/***/ "./js/components/BadgeWithTooltip.js":
/*!*******************************************!*\
  !*** ./js/components/BadgeWithTooltip.js ***!
  \*******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ BadgeWithTooltip)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _InfoTooltip__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./InfoTooltip */ "./js/components/InfoTooltip.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * BadgeWithTooltip component.
 *
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * Internal dependencies
 */


function BadgeWithTooltip({
  className = '',
  label,
  onTooltipOpen,
  tooltipTitle
}) {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)("span", {
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-badge-with-tooltip', 'googlesitekit-badge', className),
    children: [label, tooltipTitle && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)(_InfoTooltip__WEBPACK_IMPORTED_MODULE_1__["default"], {
      onOpen: onTooltipOpen,
      title: tooltipTitle
    })]
  });
}
BadgeWithTooltip.propTypes = {
  onTooltipOpen: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().func),
  tooltipTitle: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().node),
  className: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  label: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().node).isRequired
};

/***/ }),

/***/ "./js/components/Banner/CTAButton.js":
/*!*******************************************!*\
  !*** ./js/components/Banner/CTAButton.js ***!
  \*******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ CTAButton)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! googlesitekit-components */ "googlesitekit-components");
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_components__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * Internal dependencies
 */


function CTAButton({
  label,
  ariaLabel,
  disabled,
  inProgress,
  onClick,
  href
}) {
  if (!label || !onClick && !href) {
    return null;
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_0__.SpinnerButton, {
    className: "googlesitekit-banner__cta",
    "aria-label": ariaLabel,
    disabled: disabled || inProgress,
    isSaving: inProgress,
    onClick: onClick,
    href: href,
    children: label
  });
}
CTAButton.propTypes = {
  label: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().string),
  ariaLabel: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().string),
  disabled: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().bool),
  inProgress: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().bool),
  onClick: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().func),
  href: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().string),
  dismissOnClick: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().bool),
  dismissOptions: prop_types__WEBPACK_IMPORTED_MODULE_2___default().shape({
    expiresInSeconds: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().number),
    skipHidingFromQueue: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().bool)
  })
};

/***/ }),

/***/ "./js/components/Banner/Description.js":
/*!*********************************************!*\
  !*** ./js/components/Banner/Description.js ***!
  \*********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Description)
/* harmony export */ });
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _js_util__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/util */ "./js/util/index.js");
/* harmony import */ var _LearnMoreLink__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./LearnMoreLink */ "./js/components/Banner/LearnMoreLink.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */



function Description({
  className,
  description,
  learnMoreLink,
  additionalDescription,
  children
}) {
  function renderDescription() {
    if ((0,_wordpress_element__WEBPACK_IMPORTED_MODULE_4__.isValidElement)(description)) {
      return description;
    }
    if ('string' === typeof description) {
      return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("span", {
        dangerouslySetInnerHTML: (0,_js_util__WEBPACK_IMPORTED_MODULE_1__.sanitizeHTML)(description, {
          ALLOWED_TAGS: ['strong', 'em', 'br', 'a'],
          ALLOWED_ATTR: ['href']
        })
      });
    }
    return description;
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-banner__description', className),
    children: [renderDescription(), ' ', learnMoreLink?.href && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_LearnMoreLink__WEBPACK_IMPORTED_MODULE_2__["default"], {
      ...learnMoreLink
    }), additionalDescription && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
      className: "googlesitekit-banner__additional-description",
      children: additionalDescription
    }), children]
  });
}
Description.propTypes = {
  className: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().string),
  description: prop_types__WEBPACK_IMPORTED_MODULE_5___default().oneOfType([(prop_types__WEBPACK_IMPORTED_MODULE_5___default().string), (prop_types__WEBPACK_IMPORTED_MODULE_5___default().node)]),
  learnMoreLink: prop_types__WEBPACK_IMPORTED_MODULE_5___default().shape(_LearnMoreLink__WEBPACK_IMPORTED_MODULE_2__["default"].propTypes),
  additionalDescription: prop_types__WEBPACK_IMPORTED_MODULE_5___default().oneOfType([(prop_types__WEBPACK_IMPORTED_MODULE_5___default().string), (prop_types__WEBPACK_IMPORTED_MODULE_5___default().node)]),
  children: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().node)
};

/***/ }),

/***/ "./js/components/Banner/DismissButton.js":
/*!***********************************************!*\
  !*** ./js/components/Banner/DismissButton.js ***!
  \***********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ DismissButton)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-components */ "googlesitekit-components");
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */


function DismissButton({
  className,
  label = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Maybe later', 'google-site-kit'),
  onClick,
  disabled,
  tertiary = true
}) {
  if (!onClick) {
    return null;
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__.Button, {
    className: className,
    onClick: onClick,
    disabled: disabled,
    tertiary: tertiary,
    children: label
  });
}
DismissButton.propTypes = {
  className: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  label: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  onClick: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().func),
  disabled: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().bool),
  tertiary: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().bool),
  dismissOptions: prop_types__WEBPACK_IMPORTED_MODULE_3___default().shape({
    expiresInSeconds: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().number),
    skipHidingFromQueue: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().bool)
  })
};

/***/ }),

/***/ "./js/components/Banner/Footer.js":
/*!****************************************!*\
  !*** ./js/components/Banner/Footer.js ***!
  \****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Footer)
/* harmony export */ });
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



function Footer({
  className,
  children
}) {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", {
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-banner__footer', className),
    children: children
  });
}
Footer.propTypes = {
  className: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().string),
  children: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().node)
};

/***/ }),

/***/ "./js/components/Banner/HelpText.js":
/*!******************************************!*\
  !*** ./js/components/Banner/HelpText.js ***!
  \******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ HelpText)
/* harmony export */ });
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



function HelpText({
  className,
  children
}) {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("p", {
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-banner__help-text', className),
    children: children
  });
}
HelpText.propTypes = {
  className: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().string),
  children: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().node)
};

/***/ }),

/***/ "./js/components/Banner/LearnMoreLink.js":
/*!***********************************************!*\
  !*** ./js/components/Banner/LearnMoreLink.js ***!
  \***********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ LearnMoreLink)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _js_components_Link__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/components/Link */ "./js/components/Link.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */


function LearnMoreLink({
  href,
  className,
  label = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Learn more', 'google-site-kit'),
  external = true,
  onClick = () => {}
}) {
  if (!href) {
    return null;
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)(_js_components_Link__WEBPACK_IMPORTED_MODULE_1__["default"], {
    href: href,
    className: className,
    onClick: onClick,
    external: external,
    children: label
  });
}
LearnMoreLink.propTypes = {
  href: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string).isRequired,
  className: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  label: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  external: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().bool),
  onClick: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().func)
};

/***/ }),

/***/ "./js/components/Banner/Title.js":
/*!***************************************!*\
  !*** ./js/components/Banner/Title.js ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Title)
/* harmony export */ });
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



function Title({
  className,
  children
}) {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("p", {
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-banner__title', className),
    children: children
  });
}
Title.propTypes = {
  className: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().string),
  children: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().node)
};

/***/ }),

/***/ "./js/components/Banner/TitleIcon.js":
/*!*******************************************!*\
  !*** ./js/components/Banner/TitleIcon.js ***!
  \*******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ TitleIcon)
/* harmony export */ });
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



function TitleIcon({
  className,
  children
}) {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", {
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-banner__title-icon', className),
    children: children
  });
}
TitleIcon.propTypes = {
  className: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().string),
  children: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().node)
};

/***/ }),

/***/ "./js/components/Banner/index.js":
/*!***************************************!*\
  !*** ./js/components/Banner/index.js ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_13___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_13__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/hooks/useBreakpoint */ "./js/hooks/useBreakpoint.js");
/* harmony import */ var _TitleIcon__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./TitleIcon */ "./js/components/Banner/TitleIcon.js");
/* harmony import */ var _Title__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./Title */ "./js/components/Banner/Title.js");
/* harmony import */ var _Description__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./Description */ "./js/components/Banner/Description.js");
/* harmony import */ var _HelpText__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./HelpText */ "./js/components/Banner/HelpText.js");
/* harmony import */ var _LearnMoreLink__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./LearnMoreLink */ "./js/components/Banner/LearnMoreLink.js");
/* harmony import */ var _CTAButton__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./CTAButton */ "./js/components/Banner/CTAButton.js");
/* harmony import */ var _DismissButton__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./DismissButton */ "./js/components/Banner/DismissButton.js");
/* harmony import */ var _Footer__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./Footer */ "./js/components/Banner/Footer.js");
/* harmony import */ var _js_components_Notice__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @/js/components/Notice */ "./js/components/Notice/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */











const Banner = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_12__.forwardRef)(({
  className,
  titleIcon,
  title,
  description,
  additionalDescription,
  errorText,
  helpText,
  learnMoreLink,
  dismissButton,
  ctaButton,
  svg,
  // NOTE: SVGs must be imported with the ?url suffix for use as a backgroundImage in this component.
  footer
}, ref) => {
  const breakpoint = (0,_js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_1__.useBreakpoint)();
  const isMobileOrTablet = breakpoint === _js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_1__.BREAKPOINT_SMALL || breakpoint === _js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_1__.BREAKPOINT_TABLET;
  let SVGData = null;
  if (isMobileOrTablet && svg?.mobile) {
    SVGData = svg.mobile;
  } else if (!isMobileOrTablet && svg?.desktop) {
    SVGData = svg.desktop;
  }
  const svgMode = svg?.verticalPosition ? svg.verticalPosition : 'center';
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("div", {
    ref: ref,
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-banner', className),
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("div", {
      className: "googlesitekit-banner__content",
      children: [titleIcon && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_TitleIcon__WEBPACK_IMPORTED_MODULE_2__["default"], {
        children: titleIcon
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_Title__WEBPACK_IMPORTED_MODULE_3__["default"], {
        children: title
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_Description__WEBPACK_IMPORTED_MODULE_4__["default"], {
        description: description,
        learnMoreLink: learnMoreLink,
        additionalDescription: additionalDescription
      }), helpText && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_HelpText__WEBPACK_IMPORTED_MODULE_5__["default"], {
        children: helpText
      }), errorText && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_js_components_Notice__WEBPACK_IMPORTED_MODULE_10__["default"], {
        type: "error",
        description: errorText
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("div", {
        className: "googlesitekit-notice__action",
        children: [ctaButton && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_CTAButton__WEBPACK_IMPORTED_MODULE_7__["default"], {
          ...ctaButton
        }), dismissButton?.onClick && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_DismissButton__WEBPACK_IMPORTED_MODULE_8__["default"], {
          ...dismissButton
        })]
      })]
    }), SVGData && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("div", {
      className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-banner__svg-wrapper', {
        [`googlesitekit-banner__svg-wrapper--${svgMode}`]: svgMode
      }),
      style: {
        backgroundImage: `url(${SVGData})`
      }
    }), footer && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_Footer__WEBPACK_IMPORTED_MODULE_9__["default"], {
      children: footer
    })]
  });
});
Banner.propTypes = {
  titleIcon: (prop_types__WEBPACK_IMPORTED_MODULE_13___default().node),
  title: (prop_types__WEBPACK_IMPORTED_MODULE_13___default().string),
  description: prop_types__WEBPACK_IMPORTED_MODULE_13___default().oneOfType([(prop_types__WEBPACK_IMPORTED_MODULE_13___default().string), (prop_types__WEBPACK_IMPORTED_MODULE_13___default().node)]),
  additionalDescription: prop_types__WEBPACK_IMPORTED_MODULE_13___default().oneOfType([(prop_types__WEBPACK_IMPORTED_MODULE_13___default().string), (prop_types__WEBPACK_IMPORTED_MODULE_13___default().node)]),
  errorText: (prop_types__WEBPACK_IMPORTED_MODULE_13___default().string),
  helpText: (prop_types__WEBPACK_IMPORTED_MODULE_13___default().string),
  learnMoreLink: prop_types__WEBPACK_IMPORTED_MODULE_13___default().shape(_LearnMoreLink__WEBPACK_IMPORTED_MODULE_6__["default"].propTypes),
  dismissButton: prop_types__WEBPACK_IMPORTED_MODULE_13___default().shape(_DismissButton__WEBPACK_IMPORTED_MODULE_8__["default"].propTypes),
  ctaButton: prop_types__WEBPACK_IMPORTED_MODULE_13___default().shape(_CTAButton__WEBPACK_IMPORTED_MODULE_7__["default"].propTypes),
  svg: prop_types__WEBPACK_IMPORTED_MODULE_13___default().shape({
    desktop: (prop_types__WEBPACK_IMPORTED_MODULE_13___default().elementType),
    mobile: (prop_types__WEBPACK_IMPORTED_MODULE_13___default().elementType),
    verticalPosition: prop_types__WEBPACK_IMPORTED_MODULE_13___default().oneOf(['top', 'center', 'bottom'])
  }),
  footer: (prop_types__WEBPACK_IMPORTED_MODULE_13___default().node)
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Banner);

/***/ }),

/***/ "./js/components/ChangeArrow.js":
/*!**************************************!*\
  !*** ./js/components/ChangeArrow.js ***!
  \**************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * External dependencies
 */



function ChangeArrow({
  direction,
  invertColor,
  width,
  height
}) {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("svg", {
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-change-arrow', `googlesitekit-change-arrow--${direction}`, {
      'googlesitekit-change-arrow--inverted-color': invertColor
    }),
    width: width,
    height: height,
    viewBox: "0 0 10 10",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg",
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("path", {
      d: "M5.625 10L5.625 2.375L9.125 5.875L10 5L5 -1.76555e-07L-2.7055e-07 5L0.875 5.875L4.375 2.375L4.375 10L5.625 10Z",
      fill: "currentColor"
    })
  });
}
ChangeArrow.propTypes = {
  direction: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().string),
  invertColor: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().bool),
  width: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().number),
  height: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().number)
};
ChangeArrow.defaultProps = {
  direction: 'up',
  invertColor: false,
  width: 9,
  height: 9
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ChangeArrow);

/***/ }),

/***/ "./js/components/ChangeBadge.js":
/*!**************************************!*\
  !*** ./js/components/ChangeBadge.js ***!
  \**************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ ChangeBadge)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _js_util__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/util */ "./js/util/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * ChangeBadge component.
 *
 * Site Kit by Google, Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * Internal dependencies
 */


function ChangeBadge(props) {
  const {
    previousValue,
    currentValue,
    isAbsolute
  } = props;
  const change = isAbsolute ? currentValue - previousValue : (0,_js_util__WEBPACK_IMPORTED_MODULE_1__.calculateChange)(previousValue, currentValue);
  const isNegative = change < 0;
  const isZero = change === 0;

  // Do not display the change badge if the change value can't be calculated.
  if (change === null) {
    return null;
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("div", {
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-change-badge', {
      'googlesitekit-change-badge--negative': isNegative,
      'googlesitekit-change-badge--zero': isZero
    }),
    children: (0,_js_util__WEBPACK_IMPORTED_MODULE_1__.numFmt)(change, {
      style: 'percent',
      signDisplay: 'exceptZero',
      maximumFractionDigits: 1
    })
  });
}
ChangeBadge.propTypes = {
  isAbsolute: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().bool),
  previousValue: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().number).isRequired,
  currentValue: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().number).isRequired
};

/***/ }),

/***/ "./js/components/DashboardEntryPoint.js":
/*!**********************************************!*\
  !*** ./js/components/DashboardEntryPoint.js ***!
  \**********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ DashboardEntryPoint)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _setup_ModuleSetup__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./setup/ModuleSetup */ "./js/components/setup/ModuleSetup.js");
/* harmony import */ var _DashboardMainApp__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./DashboardMainApp */ "./js/components/DashboardMainApp.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * DashboardEntryPoint component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * Internal dependencies
 */



function DashboardEntryPoint({
  setupModuleSlug
}) {
  if (!!setupModuleSlug) {
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)(_setup_ModuleSetup__WEBPACK_IMPORTED_MODULE_0__["default"], {
      moduleSlug: setupModuleSlug
    });
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)(_DashboardMainApp__WEBPACK_IMPORTED_MODULE_1__["default"], {});
}
DashboardEntryPoint.propTypes = {
  setupModuleSlug: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string)
};

/***/ }),

/***/ "./js/components/DashboardMainApp.js":
/*!*******************************************!*\
  !*** ./js/components/DashboardMainApp.js ***!
  \*******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ DashboardMainApp)
/* harmony export */ });
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_33__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var react_use__WEBPACK_IMPORTED_MODULE_34__ = __webpack_require__(/*! react-use */ "../node_modules/react-use/esm/useMount.js");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _js_googlesitekit_widgets_default_contexts__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/googlesitekit/widgets/default-contexts */ "./js/googlesitekit/widgets/default-contexts.js");
/* harmony import */ var _js_util__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/util */ "./js/util/index.js");
/* harmony import */ var _Header__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./Header */ "./js/components/Header.js");
/* harmony import */ var _dashboard_sharing_DashboardSharingSettingsButton__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./dashboard-sharing/DashboardSharingSettingsButton */ "./js/components/dashboard-sharing/DashboardSharingSettingsButton.js");
/* harmony import */ var _js_googlesitekit_widgets_components_WidgetContextRenderer__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @/js/googlesitekit/widgets/components/WidgetContextRenderer */ "./js/googlesitekit/widgets/components/WidgetContextRenderer.js");
/* harmony import */ var _js_modules_analytics_4_components_audience_segmentation_dashboard__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @/js/modules/analytics-4/components/audience-segmentation/dashboard */ "./js/modules/analytics-4/components/audience-segmentation/dashboard/index.js");
/* harmony import */ var _EntitySearchInput__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./EntitySearchInput */ "./js/components/EntitySearchInput.js");
/* harmony import */ var _DateRangeSelector__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./DateRangeSelector */ "./js/components/DateRangeSelector.js");
/* harmony import */ var _help_HelpMenu__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./help/HelpMenu */ "./js/components/help/HelpMenu.js");
/* harmony import */ var _surveys_SurveyViewTrigger__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./surveys/SurveyViewTrigger */ "./js/components/surveys/SurveyViewTrigger.js");
/* harmony import */ var _surveys_CurrentSurveyPortal__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ./surveys/CurrentSurveyPortal */ "./js/components/surveys/CurrentSurveyPortal.js");
/* harmony import */ var _ScrollEffect__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ./ScrollEffect */ "./js/components/ScrollEffect.js");
/* harmony import */ var _KeyMetrics_MetricsSelectionPanel__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ./KeyMetrics/MetricsSelectionPanel */ "./js/components/KeyMetrics/MetricsSelectionPanel/index.js");
/* harmony import */ var _js_googlesitekit_constants__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! @/js/googlesitekit/constants */ "./js/googlesitekit/constants.js");
/* harmony import */ var _js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! @/js/googlesitekit/datastore/user/constants */ "./js/googlesitekit/datastore/user/constants.js");
/* harmony import */ var _js_googlesitekit_widgets_datastore_constants__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! @/js/googlesitekit/widgets/datastore/constants */ "./js/googlesitekit/widgets/datastore/constants.js");
/* harmony import */ var _js_hooks_useViewOnly__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! @/js/hooks/useViewOnly */ "./js/hooks/useViewOnly.js");
/* harmony import */ var _js_googlesitekit_datastore_forms_constants__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! @/js/googlesitekit/datastore/forms/constants */ "./js/googlesitekit/datastore/forms/constants.js");
/* harmony import */ var _notifications_OfflineNotification__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! ./notifications/OfflineNotification */ "./js/components/notifications/OfflineNotification.js");
/* harmony import */ var _ModuleDashboardEffects__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! ./ModuleDashboardEffects */ "./js/components/ModuleDashboardEffects.js");
/* harmony import */ var _js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(/*! @/js/hooks/useBreakpoint */ "./js/hooks/useBreakpoint.js");
/* harmony import */ var _js_hooks_useMonitorInternetConnection__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(/*! @/js/hooks/useMonitorInternetConnection */ "./js/hooks/useMonitorInternetConnection.js");
/* harmony import */ var _js_hooks_useQueryArg__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(/*! @/js/hooks/useQueryArg */ "./js/hooks/useQueryArg.js");
/* harmony import */ var _js_util_scroll__WEBPACK_IMPORTED_MODULE_25__ = __webpack_require__(/*! @/js/util/scroll */ "./js/util/scroll.js");
/* harmony import */ var _js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_26__ = __webpack_require__(/*! @/js/googlesitekit/datastore/site/constants */ "./js/googlesitekit/datastore/site/constants.js");
/* harmony import */ var _KeyMetrics_hooks_useDisplayCTAWidget__WEBPACK_IMPORTED_MODULE_27__ = __webpack_require__(/*! ./KeyMetrics/hooks/useDisplayCTAWidget */ "./js/components/KeyMetrics/hooks/useDisplayCTAWidget.js");
/* harmony import */ var _notifications_Notifications__WEBPACK_IMPORTED_MODULE_28__ = __webpack_require__(/*! ./notifications/Notifications */ "./js/components/notifications/Notifications.js");
/* harmony import */ var _js_googlesitekit_notifications_constants__WEBPACK_IMPORTED_MODULE_29__ = __webpack_require__(/*! @/js/googlesitekit/notifications/constants */ "./js/googlesitekit/notifications/constants.js");
/* harmony import */ var _AdminMenuTooltip__WEBPACK_IMPORTED_MODULE_30__ = __webpack_require__(/*! ./AdminMenuTooltip */ "./js/components/AdminMenuTooltip/index.js");
/* harmony import */ var _js_hooks_useFormValue__WEBPACK_IMPORTED_MODULE_31__ = __webpack_require__(/*! @/js/hooks/useFormValue */ "./js/hooks/useFormValue.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_32__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * DashboardMainApp component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */
































function DashboardMainApp() {
  const [showSurveyPortal, setShowSurveyPortal] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_33__.useState)(false);
  const viewOnlyDashboard = (0,_js_hooks_useViewOnly__WEBPACK_IMPORTED_MODULE_18__["default"])();
  const breakpoint = (0,_js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_22__.useBreakpoint)();
  const [widgetArea, setWidgetArea] = (0,_js_hooks_useQueryArg__WEBPACK_IMPORTED_MODULE_24__["default"])('widgetArea');
  const {
    setValues
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useDispatch)(_js_googlesitekit_datastore_forms_constants__WEBPACK_IMPORTED_MODULE_19__.CORE_FORMS);
  const grantedScopes = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_16__.CORE_USER).getGrantedScopes());
  const temporaryPersistedPermissionsError = (0,_js_hooks_useFormValue__WEBPACK_IMPORTED_MODULE_31__["default"])(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_16__.FORM_TEMPORARY_PERSIST_PERMISSION_ERROR, 'permissionsError');
  const hasReceivedGrantedScopes = grantedScopes !== undefined && temporaryPersistedPermissionsError?.data?.scopes?.some(scope => grantedScopes.includes(scope));
  const configuredAudiences = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_16__.CORE_USER).getConfiguredAudiences());
  (0,react_use__WEBPACK_IMPORTED_MODULE_34__["default"])(() => {
    // Render the current survey portal in 5 seconds after the initial rendering.
    if (!viewOnlyDashboard) {
      setTimeout(() => setShowSurveyPortal(true), 5000);
    }

    // Scroll to a widget area if specified in the URL.
    if (widgetArea) {
      const widgetClass = `.googlesitekit-widget-area--${widgetArea}`;
      setTimeout(() => {
        function scrollToWidgetArea() {
          __webpack_require__.g.scrollTo({
            top: (0,_js_util_scroll__WEBPACK_IMPORTED_MODULE_25__.getNavigationalScrollTop)(widgetClass, breakpoint),
            behavior: 'smooth'
          });
        }
        function handleScrollEnd() {
          scrollToWidgetArea();
          __webpack_require__.g.removeEventListener('scrollend', handleScrollEnd);
        }
        __webpack_require__.g.addEventListener('scrollend', handleScrollEnd);
        scrollToWidgetArea();
        setWidgetArea(undefined);
      }, 100);
    }
  });
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_33__.useEffect)(() => {
    if (temporaryPersistedPermissionsError !== undefined && hasReceivedGrantedScopes) {
      setValues(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_16__.FORM_TEMPORARY_PERSIST_PERMISSION_ERROR, {
        permissionsError: {}
      });
    }
  }, [hasReceivedGrantedScopes, setValues, temporaryPersistedPermissionsError]);
  const viewableModules = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => {
    if (!viewOnlyDashboard) {
      return null;
    }
    return select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_16__.CORE_USER).getViewableModules();
  });
  const widgetContextOptions = {
    modules: viewableModules ? viewableModules : undefined
  };
  const isKeyMetricsActive = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_widgets_datastore_constants__WEBPACK_IMPORTED_MODULE_17__.CORE_WIDGETS).isWidgetContextActive(_js_googlesitekit_widgets_default_contexts__WEBPACK_IMPORTED_MODULE_2__.CONTEXT_MAIN_DASHBOARD_KEY_METRICS, widgetContextOptions));
  const isTrafficActive = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_widgets_datastore_constants__WEBPACK_IMPORTED_MODULE_17__.CORE_WIDGETS).isWidgetContextActive(_js_googlesitekit_widgets_default_contexts__WEBPACK_IMPORTED_MODULE_2__.CONTEXT_MAIN_DASHBOARD_TRAFFIC, widgetContextOptions));
  const isContentActive = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_widgets_datastore_constants__WEBPACK_IMPORTED_MODULE_17__.CORE_WIDGETS).isWidgetContextActive(_js_googlesitekit_widgets_default_contexts__WEBPACK_IMPORTED_MODULE_2__.CONTEXT_MAIN_DASHBOARD_CONTENT, widgetContextOptions));
  const isSpeedActive = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_widgets_datastore_constants__WEBPACK_IMPORTED_MODULE_17__.CORE_WIDGETS).isWidgetContextActive(_js_googlesitekit_widgets_default_contexts__WEBPACK_IMPORTED_MODULE_2__.CONTEXT_MAIN_DASHBOARD_SPEED, widgetContextOptions));
  const isMonetizationActive = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_widgets_datastore_constants__WEBPACK_IMPORTED_MODULE_17__.CORE_WIDGETS).isWidgetContextActive(_js_googlesitekit_widgets_default_contexts__WEBPACK_IMPORTED_MODULE_2__.CONTEXT_MAIN_DASHBOARD_MONETIZATION, widgetContextOptions));
  const isKeyMetricsWidgetHidden = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_16__.CORE_USER).isKeyMetricsWidgetHidden());
  const displayCTAWidget = (0,_KeyMetrics_hooks_useDisplayCTAWidget__WEBPACK_IMPORTED_MODULE_27__["default"])();
  const showKeyMetricsSelectionPanel = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => {
    if (select(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_26__.CORE_SITE).isKeyMetricsSetupCompleted() === true && isKeyMetricsWidgetHidden === false) {
      return true;
    }
    return select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_16__.CORE_USER).isAuthenticated() && select(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_26__.CORE_SITE).isKeyMetricsSetupCompleted() === false && displayCTAWidget;
  });
  (0,_js_hooks_useMonitorInternetConnection__WEBPACK_IMPORTED_MODULE_23__.useMonitorInternetConnection)();
  let lastWidgetAnchor = null;
  if (isMonetizationActive) {
    lastWidgetAnchor = _js_googlesitekit_constants__WEBPACK_IMPORTED_MODULE_15__.ANCHOR_ID_MONETIZATION;
  } else if (isSpeedActive) {
    lastWidgetAnchor = _js_googlesitekit_constants__WEBPACK_IMPORTED_MODULE_15__.ANCHOR_ID_SPEED;
  } else if (isContentActive) {
    lastWidgetAnchor = _js_googlesitekit_constants__WEBPACK_IMPORTED_MODULE_15__.ANCHOR_ID_CONTENT;
  } else if (isTrafficActive) {
    lastWidgetAnchor = _js_googlesitekit_constants__WEBPACK_IMPORTED_MODULE_15__.ANCHOR_ID_TRAFFIC;
  } else if (isKeyMetricsActive) {
    lastWidgetAnchor = _js_googlesitekit_constants__WEBPACK_IMPORTED_MODULE_15__.ANCHOR_ID_KEY_METRICS;
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_32__.jsxs)(_wordpress_element__WEBPACK_IMPORTED_MODULE_33__.Fragment, {
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_32__.jsx)(_ScrollEffect__WEBPACK_IMPORTED_MODULE_13__["default"], {}), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_32__.jsx)(_ModuleDashboardEffects__WEBPACK_IMPORTED_MODULE_21__["default"], {}), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_32__.jsx)(_AdminMenuTooltip__WEBPACK_IMPORTED_MODULE_30__.AdminMenuTooltip, {}), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_32__.jsxs)(_Header__WEBPACK_IMPORTED_MODULE_4__["default"], {
      showNavigation: true,
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_32__.jsx)(_EntitySearchInput__WEBPACK_IMPORTED_MODULE_8__["default"], {}), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_32__.jsx)(_DateRangeSelector__WEBPACK_IMPORTED_MODULE_9__["default"], {}), !viewOnlyDashboard && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_32__.jsx)(_dashboard_sharing_DashboardSharingSettingsButton__WEBPACK_IMPORTED_MODULE_5__["default"], {}), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_32__.jsx)(_help_HelpMenu__WEBPACK_IMPORTED_MODULE_10__["default"], {})]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_32__.jsxs)("div", {
      className: "googlesitekit-page-content",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_32__.jsx)(_notifications_Notifications__WEBPACK_IMPORTED_MODULE_28__["default"], {
        areaSlug: _js_googlesitekit_notifications_constants__WEBPACK_IMPORTED_MODULE_29__.NOTIFICATION_AREAS.DASHBOARD_TOP
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_32__.jsx)(_notifications_Notifications__WEBPACK_IMPORTED_MODULE_28__["default"], {
        areaSlug: _js_googlesitekit_notifications_constants__WEBPACK_IMPORTED_MODULE_29__.NOTIFICATION_AREAS.DASHBOARD_TOP,
        groupID: _js_googlesitekit_notifications_constants__WEBPACK_IMPORTED_MODULE_29__.NOTIFICATION_GROUPS.SETUP_CTAS
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_32__.jsx)(_notifications_Notifications__WEBPACK_IMPORTED_MODULE_28__["default"], {
        areaSlug: _js_googlesitekit_notifications_constants__WEBPACK_IMPORTED_MODULE_29__.NOTIFICATION_AREAS.OVERLAYS,
        groupID: _js_googlesitekit_notifications_constants__WEBPACK_IMPORTED_MODULE_29__.NOTIFICATION_GROUPS.SETUP_CTAS
      }), isKeyMetricsWidgetHidden !== true && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_32__.jsx)(_js_googlesitekit_widgets_components_WidgetContextRenderer__WEBPACK_IMPORTED_MODULE_6__["default"], {
        id: _js_googlesitekit_constants__WEBPACK_IMPORTED_MODULE_15__.ANCHOR_ID_KEY_METRICS,
        slug: _js_googlesitekit_widgets_default_contexts__WEBPACK_IMPORTED_MODULE_2__.CONTEXT_MAIN_DASHBOARD_KEY_METRICS,
        className: classnames__WEBPACK_IMPORTED_MODULE_0___default()({
          'googlesitekit-widget-context--last': lastWidgetAnchor === _js_googlesitekit_constants__WEBPACK_IMPORTED_MODULE_15__.ANCHOR_ID_KEY_METRICS
        })
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_32__.jsx)(_js_googlesitekit_widgets_components_WidgetContextRenderer__WEBPACK_IMPORTED_MODULE_6__["default"], {
        id: _js_googlesitekit_constants__WEBPACK_IMPORTED_MODULE_15__.ANCHOR_ID_TRAFFIC,
        slug: _js_googlesitekit_widgets_default_contexts__WEBPACK_IMPORTED_MODULE_2__.CONTEXT_MAIN_DASHBOARD_TRAFFIC,
        className: classnames__WEBPACK_IMPORTED_MODULE_0___default()({
          'googlesitekit-widget-context--last': lastWidgetAnchor === _js_googlesitekit_constants__WEBPACK_IMPORTED_MODULE_15__.ANCHOR_ID_TRAFFIC
        })
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_32__.jsx)(_js_googlesitekit_widgets_components_WidgetContextRenderer__WEBPACK_IMPORTED_MODULE_6__["default"], {
        id: _js_googlesitekit_constants__WEBPACK_IMPORTED_MODULE_15__.ANCHOR_ID_CONTENT,
        slug: _js_googlesitekit_widgets_default_contexts__WEBPACK_IMPORTED_MODULE_2__.CONTEXT_MAIN_DASHBOARD_CONTENT,
        className: classnames__WEBPACK_IMPORTED_MODULE_0___default()({
          'googlesitekit-widget-context--last': lastWidgetAnchor === _js_googlesitekit_constants__WEBPACK_IMPORTED_MODULE_15__.ANCHOR_ID_CONTENT
        })
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_32__.jsx)(_js_googlesitekit_widgets_components_WidgetContextRenderer__WEBPACK_IMPORTED_MODULE_6__["default"], {
        id: _js_googlesitekit_constants__WEBPACK_IMPORTED_MODULE_15__.ANCHOR_ID_SPEED,
        slug: _js_googlesitekit_widgets_default_contexts__WEBPACK_IMPORTED_MODULE_2__.CONTEXT_MAIN_DASHBOARD_SPEED,
        className: classnames__WEBPACK_IMPORTED_MODULE_0___default()({
          'googlesitekit-widget-context--last': lastWidgetAnchor === _js_googlesitekit_constants__WEBPACK_IMPORTED_MODULE_15__.ANCHOR_ID_SPEED
        })
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_32__.jsx)(_js_googlesitekit_widgets_components_WidgetContextRenderer__WEBPACK_IMPORTED_MODULE_6__["default"], {
        id: _js_googlesitekit_constants__WEBPACK_IMPORTED_MODULE_15__.ANCHOR_ID_MONETIZATION,
        slug: _js_googlesitekit_widgets_default_contexts__WEBPACK_IMPORTED_MODULE_2__.CONTEXT_MAIN_DASHBOARD_MONETIZATION,
        className: classnames__WEBPACK_IMPORTED_MODULE_0___default()({
          'googlesitekit-widget-context--last': lastWidgetAnchor === _js_googlesitekit_constants__WEBPACK_IMPORTED_MODULE_15__.ANCHOR_ID_MONETIZATION
        })
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_32__.jsx)(_notifications_OfflineNotification__WEBPACK_IMPORTED_MODULE_20__["default"], {})]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_32__.jsx)(_surveys_SurveyViewTrigger__WEBPACK_IMPORTED_MODULE_11__["default"], {
      triggerID: "view_dashboard",
      ttl: _js_util__WEBPACK_IMPORTED_MODULE_3__.DAY_IN_SECONDS
    }), showSurveyPortal && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_32__.jsx)(_surveys_CurrentSurveyPortal__WEBPACK_IMPORTED_MODULE_12__["default"], {}), showKeyMetricsSelectionPanel && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_32__.jsx)(_KeyMetrics_MetricsSelectionPanel__WEBPACK_IMPORTED_MODULE_14__["default"], {}), configuredAudiences && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_32__.jsx)(_js_modules_analytics_4_components_audience_segmentation_dashboard__WEBPACK_IMPORTED_MODULE_7__.AudienceSelectionPanel, {}), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_32__.jsx)(_notifications_OfflineNotification__WEBPACK_IMPORTED_MODULE_20__["default"], {})]
  });
}

/***/ }),

/***/ "./js/components/DashboardNavigation/Navigation/hooks/useNavChipHelpers.js":
/*!*********************************************************************************!*\
  !*** ./js/components/DashboardNavigation/Navigation/hooks/useNavChipHelpers.js ***!
  \*********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ useNavChipHelpers)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _js_util_scroll__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @/js/util/scroll */ "./js/util/scroll.js");
/* harmony import */ var _js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/hooks/useBreakpoint */ "./js/hooks/useBreakpoint.js");
/* harmony import */ var _js_hooks_useViewOnly__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/hooks/useViewOnly */ "./js/hooks/useViewOnly.js");
/* harmony import */ var _js_googlesitekit_constants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/googlesitekit/constants */ "./js/googlesitekit/constants.js");
/**
 * Navigation `useNavChipHelpers` hook.
 *
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */





/**
 * Returns helper data and functions for navigation chips.
 *
 * @since 1.159.0
 *
 * @param {Object}        params                 Parameters for the hook.
 * @param {Array<string>} params.visibleSections The sections that are currently visible.
 * @return {Object} An object containing helper data and functions for navigation chips.
 */
function useNavChipHelpers({
  visibleSections
}) {
  const breakpoint = (0,_js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_1__.useBreakpoint)();
  const viewOnlyDashboard = (0,_js_hooks_useViewOnly__WEBPACK_IMPORTED_MODULE_2__["default"])();

  /**
   * Gets the default chip ID based on the visibility of various sections.
   *
   * @since 1.159.0
   *
   * @return {string} The default chip ID.
   */
  const getDefaultChipID = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_4__.useCallback)(() => {
    if (visibleSections.includes(_js_googlesitekit_constants__WEBPACK_IMPORTED_MODULE_3__.ANCHOR_ID_KEY_METRICS)) {
      return _js_googlesitekit_constants__WEBPACK_IMPORTED_MODULE_3__.ANCHOR_ID_KEY_METRICS;
    }
    if (!viewOnlyDashboard) {
      return _js_googlesitekit_constants__WEBPACK_IMPORTED_MODULE_3__.ANCHOR_ID_TRAFFIC;
    }
    return visibleSections[0] || '';
  }, [viewOnlyDashboard, visibleSections]);
  const defaultChipID = getDefaultChipID();

  /**
   * Checks if a chip ID is valid based on the visible sections.
   *
   * @since 1.159.0
   *
   * @param {string} chipID The chip ID to validate.
   * @return {boolean} True if the chip ID is valid, false otherwise.
   */
  const isValidChipID = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_4__.useCallback)(chipID => visibleSections.includes(chipID), [visibleSections]);

  /**
   * Updates the URL hash to reflect the selected chip ID.
   *
   * @since 1.159.0
   *
   * @param {string} chipID The chip ID to update in the URL hash.
   * @return {void}
   */
  const updateURLHash = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_4__.useCallback)(chipID => {
    __webpack_require__.g.history.replaceState({}, '', `#${chipID}`);
  }, []);

  /**
   * Calculates the scroll position for a given chip ID.
   *
   * @since 1.159.0
   *
   * @param {string} chipID The chip ID for which to calculate the scroll position.
   * @return {number} The calculated scroll position.
   */
  const calculateScrollPosition = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_4__.useCallback)(chipID => {
    return chipID !== defaultChipID ? (0,_js_util_scroll__WEBPACK_IMPORTED_MODULE_0__.getNavigationalScrollTop)(`#${chipID}`, breakpoint) : 0;
  }, [breakpoint, defaultChipID]);

  /**
   * Scrolls to the position of a given chip ID.
   *
   * @since 1.159.0
   *
   * @param {string} chipID The chip ID to scroll to.
   * @return {void}
   */
  const scrollToChip = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_4__.useCallback)(chipID => {
    __webpack_require__.g.scrollTo({
      top: calculateScrollPosition(chipID, breakpoint, defaultChipID),
      behavior: 'smooth'
    });
  }, [breakpoint, calculateScrollPosition, defaultChipID]);

  /**
   * Finds the closest section ID based on the current scroll position.
   *
   * @since 1.159.0
   *
   * @param {Object} ref The reference to the navigation element.
   * @return {string} The ID of the closest section.
   */
  const findClosestSection = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_4__.useCallback)(ref => {
    var _ref$current$getBound;
    const entityHeader = document.querySelector('.googlesitekit-entity-header')?.getBoundingClientRect?.()?.bottom;
    const {
      bottom
    } = (_ref$current$getBound = ref?.current?.getBoundingClientRect?.()) !== null && _ref$current$getBound !== void 0 ? _ref$current$getBound : {};
    const margin = 20;
    let closest;
    let closestID = defaultChipID;
    for (const areaID of visibleSections) {
      const area = document.getElementById(areaID);
      if (!area) {
        continue;
      }
      const top = area.getBoundingClientRect().top - margin - (entityHeader || bottom || 0);
      if (top < 0 && (closest === undefined || closest < top)) {
        closest = top;
        closestID = areaID;
      }
    }
    return closestID;
  }, [defaultChipID, visibleSections]);
  return {
    calculateScrollPosition,
    defaultChipID,
    findClosestSection,
    isValidChipID,
    scrollToChip,
    updateURLHash
  };
}

/***/ }),

/***/ "./js/components/DashboardNavigation/Navigation/hooks/useVisibleSections.js":
/*!**********************************************************************************!*\
  !*** ./js/components/DashboardNavigation/Navigation/hooks/useVisibleSections.js ***!
  \**********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   contexts: () => (/* binding */ contexts),
/* harmony export */   "default": () => (/* binding */ useVisibleSections)
/* harmony export */ });
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _js_googlesitekit_constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/googlesitekit/constants */ "./js/googlesitekit/constants.js");
/* harmony import */ var _js_googlesitekit_widgets_default_contexts__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/googlesitekit/widgets/default-contexts */ "./js/googlesitekit/widgets/default-contexts.js");
/* harmony import */ var _js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/googlesitekit/datastore/user/constants */ "./js/googlesitekit/datastore/user/constants.js");
/* harmony import */ var _js_googlesitekit_widgets_datastore_constants__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/googlesitekit/widgets/datastore/constants */ "./js/googlesitekit/widgets/datastore/constants.js");
/* harmony import */ var _js_hooks_useDashboardType__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/hooks/useDashboardType */ "./js/hooks/useDashboardType.js");
/* harmony import */ var _js_hooks_useViewOnly__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @/js/hooks/useViewOnly */ "./js/hooks/useViewOnly.js");
/**
 * Navigation `useVisibleSections` hook.
 *
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Internal dependencies
 */







const contexts = {
  [_js_hooks_useDashboardType__WEBPACK_IMPORTED_MODULE_5__.DASHBOARD_TYPE_MAIN]: {
    [_js_googlesitekit_constants__WEBPACK_IMPORTED_MODULE_1__.ANCHOR_ID_KEY_METRICS]: _js_googlesitekit_widgets_default_contexts__WEBPACK_IMPORTED_MODULE_2__.CONTEXT_MAIN_DASHBOARD_KEY_METRICS,
    [_js_googlesitekit_constants__WEBPACK_IMPORTED_MODULE_1__.ANCHOR_ID_TRAFFIC]: _js_googlesitekit_widgets_default_contexts__WEBPACK_IMPORTED_MODULE_2__.CONTEXT_MAIN_DASHBOARD_TRAFFIC,
    [_js_googlesitekit_constants__WEBPACK_IMPORTED_MODULE_1__.ANCHOR_ID_CONTENT]: _js_googlesitekit_widgets_default_contexts__WEBPACK_IMPORTED_MODULE_2__.CONTEXT_MAIN_DASHBOARD_CONTENT,
    [_js_googlesitekit_constants__WEBPACK_IMPORTED_MODULE_1__.ANCHOR_ID_SPEED]: _js_googlesitekit_widgets_default_contexts__WEBPACK_IMPORTED_MODULE_2__.CONTEXT_MAIN_DASHBOARD_SPEED,
    [_js_googlesitekit_constants__WEBPACK_IMPORTED_MODULE_1__.ANCHOR_ID_MONETIZATION]: _js_googlesitekit_widgets_default_contexts__WEBPACK_IMPORTED_MODULE_2__.CONTEXT_MAIN_DASHBOARD_MONETIZATION
  },
  [_js_hooks_useDashboardType__WEBPACK_IMPORTED_MODULE_5__.DASHBOARD_TYPE_ENTITY]: {
    [_js_googlesitekit_constants__WEBPACK_IMPORTED_MODULE_1__.ANCHOR_ID_TRAFFIC]: _js_googlesitekit_widgets_default_contexts__WEBPACK_IMPORTED_MODULE_2__.CONTEXT_ENTITY_DASHBOARD_TRAFFIC,
    [_js_googlesitekit_constants__WEBPACK_IMPORTED_MODULE_1__.ANCHOR_ID_CONTENT]: _js_googlesitekit_widgets_default_contexts__WEBPACK_IMPORTED_MODULE_2__.CONTEXT_ENTITY_DASHBOARD_CONTENT,
    [_js_googlesitekit_constants__WEBPACK_IMPORTED_MODULE_1__.ANCHOR_ID_SPEED]: _js_googlesitekit_widgets_default_contexts__WEBPACK_IMPORTED_MODULE_2__.CONTEXT_ENTITY_DASHBOARD_SPEED,
    [_js_googlesitekit_constants__WEBPACK_IMPORTED_MODULE_1__.ANCHOR_ID_MONETIZATION]: _js_googlesitekit_widgets_default_contexts__WEBPACK_IMPORTED_MODULE_2__.CONTEXT_ENTITY_DASHBOARD_MONETIZATION
  }
};

/**
 * Returns the visible sections for the dashboard navigation.
 *
 * @since 1.159.0
 *
 * @return {Array<string>} The visible sections.
 */
function useVisibleSections() {
  const dashboardType = (0,_js_hooks_useDashboardType__WEBPACK_IMPORTED_MODULE_5__["default"])();
  const viewOnlyDashboard = (0,_js_hooks_useViewOnly__WEBPACK_IMPORTED_MODULE_6__["default"])();
  return (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useSelect)(select => {
    const viewableModules = viewOnlyDashboard ? select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_USER).getViewableModules() : null;
    const isKeyMetricsWidgetHidden = select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_USER).isKeyMetricsWidgetHidden();
    const widgetContextOptions = {
      modules: viewableModules ? viewableModules : undefined
    };
    return Object.keys(contexts[dashboardType]).reduce((visibleSections, section) => {
      // Skip key metrics section if it's hidden.
      if (section === _js_googlesitekit_constants__WEBPACK_IMPORTED_MODULE_1__.ANCHOR_ID_KEY_METRICS && isKeyMetricsWidgetHidden) {
        return visibleSections;
      }
      if (select(_js_googlesitekit_widgets_datastore_constants__WEBPACK_IMPORTED_MODULE_4__.CORE_WIDGETS).isWidgetContextActive(contexts[dashboardType][section], widgetContextOptions)) {
        visibleSections.push(section);
      }
      return visibleSections;
    }, []);
  });
}

/***/ }),

/***/ "./js/components/DashboardNavigation/Navigation/index.js":
/*!***************************************************************!*\
  !*** ./js/components/DashboardNavigation/Navigation/index.js ***!
  \***************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Navigation)
/* harmony export */ });
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react_use__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! react-use */ "../node_modules/react-use/esm/useMount.js");
/* harmony import */ var _material_react_chips__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @material/react-chips */ "../node_modules/@material/react-chips/dist/index.js");
/* harmony import */ var _material_react_chips__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_material_react_chips__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_compose__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! @wordpress/compose */ "../node_modules/@wordpress/compose/build-module/hooks/use-throttle/index.js");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _js_googlesitekit_constants__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/googlesitekit/constants */ "./js/googlesitekit/constants.js");
/* harmony import */ var _js_googlesitekit_datastore_ui_constants__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/googlesitekit/datastore/ui/constants */ "./js/googlesitekit/datastore/ui/constants.js");
/* harmony import */ var _js_util__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @/js/util */ "./js/util/index.js");
/* harmony import */ var _js_hooks_useDashboardType__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @/js/hooks/useDashboardType */ "./js/hooks/useDashboardType.js");
/* harmony import */ var _hooks_useNavChipHelpers__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./hooks/useNavChipHelpers */ "./js/components/DashboardNavigation/Navigation/hooks/useNavChipHelpers.js");
/* harmony import */ var _js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @/js/hooks/useViewContext */ "./js/hooks/useViewContext.js");
/* harmony import */ var _hooks_useVisibleSections__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./hooks/useVisibleSections */ "./js/components/DashboardNavigation/Navigation/hooks/useVisibleSections.js");
/* harmony import */ var _svg_icons_nav_content_icon_svg__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @/svg/icons/nav-content-icon.svg */ "./svg/icons/nav-content-icon.svg");
/* harmony import */ var _svg_icons_nav_key_metrics_icon_svg__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! @/svg/icons/nav-key-metrics-icon.svg */ "./svg/icons/nav-key-metrics-icon.svg");
/* harmony import */ var _svg_icons_nav_monetization_icon_svg__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! @/svg/icons/nav-monetization-icon.svg */ "./svg/icons/nav-monetization-icon.svg");
/* harmony import */ var _svg_icons_nav_speed_icon_svg__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! @/svg/icons/nav-speed-icon.svg */ "./svg/icons/nav-speed-icon.svg");
/* harmony import */ var _svg_icons_nav_traffic_icon_svg__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! @/svg/icons/nav-traffic-icon.svg */ "./svg/icons/nav-traffic-icon.svg");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Navigation component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */




/**
 * WordPress dependencies
 */




/**
 * Internal dependencies
 */














function Navigation() {
  const dashboardType = (0,_js_hooks_useDashboardType__WEBPACK_IMPORTED_MODULE_7__["default"])();
  const elementRef = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_17__.useRef)();
  const viewContext = (0,_js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_9__["default"])();
  const visibleSections = (0,_hooks_useVisibleSections__WEBPACK_IMPORTED_MODULE_10__["default"])();
  const {
    calculateScrollPosition,
    defaultChipID,
    findClosestSection,
    isValidChipID,
    scrollToChip,
    updateURLHash
  } = (0,_hooks_useNavChipHelpers__WEBPACK_IMPORTED_MODULE_8__["default"])({
    visibleSections
  });
  const initialHash = __webpack_require__.g.location.hash?.substring(1);
  const [isJumpingTo, setIsJumpingTo] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_17__.useState)(initialHash || undefined);
  const [isSticky, setIsSticky] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_17__.useState)(false);
  const [selectedID, setSelectedID] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_17__.useState)(initialHash);
  const {
    setValue
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__.useDispatch)(_js_googlesitekit_datastore_ui_constants__WEBPACK_IMPORTED_MODULE_5__.CORE_UI);

  /**
   * Handles the selection of a chip.
   *
   * @since 1.159.0
   *
   * @param {Object} event The click event.
   * @return {void}
   */
  const handleSelect = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_17__.useCallback)(({
    target
  }) => {
    const chip = target.closest('.mdc-chip');
    const chipID =
    // Uses non-acronym case to meet DOM data attribute standards.
    // eslint-disable-next-line sitekit/acronym-case
    chip?.dataset?.contextId;

    // Update URL and scroll to the selected chip.
    updateURLHash(chipID);
    setIsJumpingTo(chipID);
    scrollToChip(chipID);

    // Track user event.
    (0,_js_util__WEBPACK_IMPORTED_MODULE_6__.trackEvent)(`${viewContext}_navigation`, 'tab_select', chipID);
    setTimeout(() => {
      setValue(_js_googlesitekit_datastore_ui_constants__WEBPACK_IMPORTED_MODULE_5__.ACTIVE_CONTEXT_ID, chipID);
    }, 50);
  }, [scrollToChip, setValue, updateURLHash, viewContext]);

  /**
   * Determines the sticky state of navigation based on scroll position.
   *
   * @since 1.159.0
   *
   * @return {void}
   */
  const handleSticky = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_17__.useCallback)(() => {
    if (!elementRef?.current) {
      return;
    }
    const {
      top
    } = elementRef?.current?.getBoundingClientRect();
    if (__webpack_require__.g.scrollY === 0) {
      setIsSticky(false);
    } else {
      const headerBottom = document.querySelector('.googlesitekit-header')?.getBoundingClientRect?.()?.bottom;
      setIsSticky(top === headerBottom);
    }
  }, []);

  /**
   * Determines the selected state of a chip based on scroll position.
   *
   * @since 1.159.0
   *
   * @param {Event} event The scroll event.
   * @return {void}
   */
  const handleSelectedChip = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_17__.useCallback)(event => {
    function changeSelectedChip(chipID) {
      setValue(_js_googlesitekit_datastore_ui_constants__WEBPACK_IMPORTED_MODULE_5__.ACTIVE_CONTEXT_ID, undefined);
      setSelectedID(chipID);
      setIsJumpingTo(undefined);
    }
    const closestID = findClosestSection(elementRef);

    // Check if user clicked on a chip and is actively jumping to it.
    if (isJumpingTo) {
      if (isJumpingTo === closestID) {
        changeSelectedChip(closestID);
      }
    } else {
      const {
        hash
      } = __webpack_require__.g.location;
      if (closestID !== hash?.substring(1)) {
        if (event) {
          (0,_js_util__WEBPACK_IMPORTED_MODULE_6__.trackEvent)(`${viewContext}_navigation`, 'tab_scroll', closestID);
        }
        updateURLHash(closestID);
        changeSelectedChip(closestID);
      }
    }
  }, [findClosestSection, isJumpingTo, setValue, updateURLHash, viewContext]);

  // Set up initial chip on mount.
  (0,react_use__WEBPACK_IMPORTED_MODULE_18__["default"])(() => {
    // If no initial hash is set, set the default chip as selected.
    if (!initialHash) {
      setSelectedID(defaultChipID);
      setTimeout(() => updateURLHash(defaultChipID));
      return;
    }
    const chipID = isValidChipID(initialHash) ? initialHash : defaultChipID;

    // Set initial/default chip ID in state.
    setSelectedID(chipID);
    setValue(_js_googlesitekit_datastore_ui_constants__WEBPACK_IMPORTED_MODULE_5__.ACTIVE_CONTEXT_ID, chipID);

    // Scroll to the chip position.
    setTimeout(() => {
      const scrollTo = calculateScrollPosition(chipID);
      if (__webpack_require__.g.scrollY === scrollTo) {
        setValue(_js_googlesitekit_datastore_ui_constants__WEBPACK_IMPORTED_MODULE_5__.ACTIVE_CONTEXT_ID, undefined);
        return;
      }
      scrollToChip(chipID);
    }, 50);
  });
  const onScroll = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_17__.useCallback)(event => {
    handleSticky();
    handleSelectedChip(event);
  }, [handleSelectedChip, handleSticky]);
  const throttledOnScroll = (0,_wordpress_compose__WEBPACK_IMPORTED_MODULE_19__["default"])(onScroll, 150);

  // Handle scroll events to update sticky state and selected chip.
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_17__.useEffect)(() => {
    __webpack_require__.g.addEventListener('scroll', throttledOnScroll);
    return () => {
      __webpack_require__.g.removeEventListener('scroll', throttledOnScroll);
    };
  }, [throttledOnScroll]);
  const chips = {
    [_js_googlesitekit_constants__WEBPACK_IMPORTED_MODULE_4__.ANCHOR_ID_KEY_METRICS]: {
      label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Key metrics', 'google-site-kit'),
      icon: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx)(_svg_icons_nav_key_metrics_icon_svg__WEBPACK_IMPORTED_MODULE_12__["default"], {
        width: "18",
        height: "16"
      })
    },
    [_js_googlesitekit_constants__WEBPACK_IMPORTED_MODULE_4__.ANCHOR_ID_TRAFFIC]: {
      label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Traffic', 'google-site-kit'),
      icon: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx)(_svg_icons_nav_traffic_icon_svg__WEBPACK_IMPORTED_MODULE_15__["default"], {
        width: "18",
        height: "16"
      })
    },
    [_js_googlesitekit_constants__WEBPACK_IMPORTED_MODULE_4__.ANCHOR_ID_CONTENT]: {
      label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Content', 'google-site-kit'),
      icon: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx)(_svg_icons_nav_content_icon_svg__WEBPACK_IMPORTED_MODULE_11__["default"], {
        width: "18",
        height: "18"
      })
    },
    [_js_googlesitekit_constants__WEBPACK_IMPORTED_MODULE_4__.ANCHOR_ID_SPEED]: {
      label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Speed', 'google-site-kit'),
      icon: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx)(_svg_icons_nav_speed_icon_svg__WEBPACK_IMPORTED_MODULE_14__["default"], {
        width: "20",
        height: "16"
      })
    },
    [_js_googlesitekit_constants__WEBPACK_IMPORTED_MODULE_4__.ANCHOR_ID_MONETIZATION]: {
      label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Monetization', 'google-site-kit'),
      icon: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx)(_svg_icons_nav_monetization_icon_svg__WEBPACK_IMPORTED_MODULE_13__["default"], {
        width: "18",
        height: "16"
      })
    }
  };
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx)("nav", {
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('mdc-chip-set', 'googlesitekit-navigation', `googlesitekit-navigation--${dashboardType}`, {
      'googlesitekit-navigation--is-sticky': isSticky
    }),
    ref: elementRef,
    children: visibleSections.map(anchorID => {
      return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx)(_material_react_chips__WEBPACK_IMPORTED_MODULE_1__.Chip, {
        id: anchorID,
        label: chips[anchorID].label,
        leadingIcon: chips[anchorID].icon,
        onClick: handleSelect,
        selected: selectedID === anchorID,
        "data-context-id": anchorID
      }, anchorID);
    })
  });
}

/***/ }),

/***/ "./js/components/DashboardNavigation/index.js":
/*!****************************************************!*\
  !*** ./js/components/DashboardNavigation/index.js ***!
  \****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ DashboardNavigation)
/* harmony export */ });
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/googlesitekit/datastore/user/constants */ "./js/googlesitekit/datastore/user/constants.js");
/* harmony import */ var _js_hooks_useViewOnly__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/hooks/useViewOnly */ "./js/hooks/useViewOnly.js");
/* harmony import */ var _js_components_LoadingWrapper__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/components/LoadingWrapper */ "./js/components/LoadingWrapper.js");
/* harmony import */ var _Navigation__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./Navigation */ "./js/components/DashboardNavigation/Navigation/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * DashboardNavigation component.
 *
 * Site Kit by Google, Copyright 2022 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Internal dependencies
 */






function DashboardNavigation() {
  const viewOnlyDashboard = (0,_js_hooks_useViewOnly__WEBPACK_IMPORTED_MODULE_2__["default"])();
  const viewableModules = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useSelect)(select => {
    if (!viewOnlyDashboard) {
      return null;
    }
    return select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_1__.CORE_USER).getViewableModules();
  });
  const keyMetrics = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useSelect)(select => select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_1__.CORE_USER).getKeyMetrics());

  // The Navigation component relies on the resolution of the above selectors to check if individual
  // widgetContexts are active. The results of these checks are used to determine the `defaultChipID`
  // which 'highlights' the first chip and sets the corresponding hash on page load.
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_js_components_LoadingWrapper__WEBPACK_IMPORTED_MODULE_3__["default"], {
    loading: viewableModules === undefined || keyMetrics === undefined,
    width: "100%",
    smallHeight: "59px",
    height: "71px",
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_Navigation__WEBPACK_IMPORTED_MODULE_4__["default"], {})
  });
}

/***/ }),

/***/ "./js/components/DateRangeSelector.js":
/*!********************************************!*\
  !*** ./js/components/DateRangeSelector.js ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ DateRangeSelector)
/* harmony export */ });
/* harmony import */ var react_use__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! react-use */ "../node_modules/react-use/esm/useClickAway.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _wordpress_keycodes__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! @wordpress/keycodes */ "../node_modules/@wordpress/keycodes/build-module/index.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! googlesitekit-components */ "googlesitekit-components");
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_components__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _svg_icons_date_range_svg__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/svg/icons/date-range.svg */ "./svg/icons/date-range.svg");
/* harmony import */ var _js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/googlesitekit/datastore/user/constants */ "./js/googlesitekit/datastore/user/constants.js");
/* harmony import */ var _js_hooks_useKeyCodesInside__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @/js/hooks/useKeyCodesInside */ "./js/hooks/useKeyCodesInside.js");
/* harmony import */ var _js_util__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @/js/util */ "./js/util/index.js");
/* harmony import */ var _js_googlesitekit_datastore_ui_constants__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @/js/googlesitekit/datastore/ui/constants */ "./js/googlesitekit/datastore/ui/constants.js");
/* harmony import */ var _js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @/js/hooks/useViewContext */ "./js/hooks/useViewContext.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Date range selector component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * WordPress dependencies
 */




/**
 * Internal dependencies
 */









function DateRangeSelector() {
  const ranges = (0,_js_util__WEBPACK_IMPORTED_MODULE_7__.getAvailableDateRanges)();
  const dateRange = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.useSelect)(select => select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_5__.CORE_USER).getDateRange());
  const {
    setDateRange
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.useDispatch)(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_5__.CORE_USER);
  const {
    resetInViewHook
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.useDispatch)(_js_googlesitekit_datastore_ui_constants__WEBPACK_IMPORTED_MODULE_8__.CORE_UI);
  const [menuOpen, setMenuOpen] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_11__.useState)(false);
  const menuWrapperRef = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_11__.useRef)();
  const viewContext = (0,_js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_9__["default"])();
  (0,react_use__WEBPACK_IMPORTED_MODULE_12__["default"])(menuWrapperRef, () => setMenuOpen(false));
  (0,_js_hooks_useKeyCodesInside__WEBPACK_IMPORTED_MODULE_6__.useKeyCodesInside)([_wordpress_keycodes__WEBPACK_IMPORTED_MODULE_13__.ESCAPE, _wordpress_keycodes__WEBPACK_IMPORTED_MODULE_13__.TAB], menuWrapperRef, () => setMenuOpen(false));
  const handleMenu = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_11__.useCallback)(() => {
    setMenuOpen(!menuOpen);
  }, [menuOpen]);
  const handleMenuItemSelect = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_11__.useCallback)(index => {
    const newDateRange = Object.values(ranges)[index].slug;
    if (dateRange !== newDateRange) {
      (0,_js_util__WEBPACK_IMPORTED_MODULE_7__.trackEvent)(`${viewContext}_headerbar`, 'change_daterange', newDateRange);
    }
    resetInViewHook();
    setDateRange(newDateRange);
    setMenuOpen(false);
  }, [ranges, dateRange, resetInViewHook, setDateRange, viewContext]);
  const currentDateRangeLabel = ranges[dateRange]?.label;
  const menuItems = Object.values(ranges).map(range => range.label);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsxs)("div", {
    ref: menuWrapperRef,
    className: "googlesitekit-date-range-selector googlesitekit-dropdown-menu mdc-menu-surface--anchor",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_3__.Button, {
      className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('mdc-button--dropdown', 'googlesitekit-header__dropdown', 'googlesitekit-header__date-range-selector-menu', 'googlesitekit-border-radius-round--phone', 'googlesitekit-button-icon--phone'),
      onClick: handleMenu,
      icon: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)(_svg_icons_date_range_svg__WEBPACK_IMPORTED_MODULE_4__["default"], {
        width: "20",
        height: "20"
      }),
      "aria-haspopup": "menu",
      "aria-expanded": menuOpen,
      "aria-controls": "date-range-selector-menu",
      title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Date range', 'google-site-kit'),
      tooltipEnterDelayInMS: 500,
      text: true,
      tooltip: true,
      children: currentDateRangeLabel
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_3__.Menu, {
      menuOpen: menuOpen,
      menuItems: menuItems,
      onSelected: handleMenuItemSelect,
      id: "date-range-selector-menu",
      className: "googlesitekit-width-auto"
    })]
  });
}

/***/ }),

/***/ "./js/components/EntityHeader.js":
/*!***************************************!*\
  !*** ./js/components/EntityHeader.js ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_compose__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! @wordpress/compose */ "../node_modules/@wordpress/compose/build-module/hooks/use-throttle/index.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! googlesitekit-components */ "googlesitekit-components");
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_components__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/googlesitekit/datastore/site/constants */ "./js/googlesitekit/datastore/site/constants.js");
/* harmony import */ var _svg_icons_keyboard_backspace_svg__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/svg/icons/keyboard-backspace.svg */ "./svg/icons/keyboard-backspace.svg");
/* harmony import */ var _js_googlesitekit_datastore_location_constants__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/googlesitekit/datastore/location/constants */ "./js/googlesitekit/datastore/location/constants.js");
/* harmony import */ var _Link__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./Link */ "./js/components/Link.js");
/* harmony import */ var _Typography_P__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./Typography/P */ "./js/components/Typography/P.js");
/* harmony import */ var _js_util_urls__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @/js/util/urls */ "./js/util/urls.js");
/* harmony import */ var _js_util__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @/js/util */ "./js/util/index.js");
/* harmony import */ var _js_hooks_useDashboardType__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @/js/hooks/useDashboardType */ "./js/hooks/useDashboardType.js");
/* harmony import */ var _js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @/js/hooks/useViewContext */ "./js/hooks/useViewContext.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * EntityHeader component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */




/**
 * Internal dependencies
 */












function EntityHeader() {
  const viewContext = (0,_js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_11__["default"])();
  const dashboardType = (0,_js_hooks_useDashboardType__WEBPACK_IMPORTED_MODULE_10__["default"])();
  const currentEntityTitle = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_SITE).getCurrentEntityTitle());
  const entityURL = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_SITE).getCurrentEntityURL());
  const headerDetailsRef = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_13__.useRef)();
  const [url, setURL] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_13__.useState)(entityURL);
  const shortenEntityURL = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_13__.useCallback)(() => {
    if (!headerDetailsRef.current) {
      return;
    }

    // Remove 40 px for margins + SVG at the end of the URL link.
    const availableWidth = headerDetailsRef.current.clientWidth - 40;
    const urlFontSize = __webpack_require__.g.getComputedStyle(headerDetailsRef.current.lastChild, null).getPropertyValue('font-size');
    const fontSize = parseFloat(urlFontSize);

    // 2 is appox. the minimum character constant for sans-serif fonts:
    // https://pearsonified.com/characters-per-line/
    const maxChars = availableWidth * 2 / fontSize;
    setURL((0,_js_util_urls__WEBPACK_IMPORTED_MODULE_8__.shortenURL)(entityURL, maxChars));
  }, [entityURL]);
  const throttledShortenEntityURL = (0,_wordpress_compose__WEBPACK_IMPORTED_MODULE_14__["default"])(shortenEntityURL, 150);
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_13__.useEffect)(() => {
    __webpack_require__.g.addEventListener('resize', throttledShortenEntityURL);
    return () => {
      __webpack_require__.g.removeEventListener('resize', throttledShortenEntityURL);
    };
  }, [throttledShortenEntityURL]);
  const {
    navigateTo
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useDispatch)(_js_googlesitekit_datastore_location_constants__WEBPACK_IMPORTED_MODULE_5__.CORE_LOCATION);
  const returnURL = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_SITE).getAdminURL('googlesitekit-dashboard'));
  const onClick = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_13__.useCallback)(() => {
    (0,_js_util__WEBPACK_IMPORTED_MODULE_9__.trackEvent)(`${viewContext}_navigation`, 'return_to_dashboard');
    navigateTo(returnURL);
  }, [returnURL, navigateTo, viewContext]);
  if (_js_hooks_useDashboardType__WEBPACK_IMPORTED_MODULE_10__.DASHBOARD_TYPE_ENTITY !== dashboardType || entityURL === null || currentEntityTitle === null) {
    return null;
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsxs)("div", {
    className: "googlesitekit-entity-header",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx)("div", {
      className: "googlesitekit-entity-header__back",
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_2__.Button, {
        icon: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx)(_svg_icons_keyboard_backspace_svg__WEBPACK_IMPORTED_MODULE_4__["default"], {
          width: 24,
          height: 24
        })
        // This is duplicated because on small screens, the text supplied to the
        // Button is rendered as a sub-component and is set to `display: none`,
        // but the button itself remains on-screen (and thus this aria-label is
        // accessible to screen-readers).
        ,
        "aria-label": (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Back to dashboard', 'google-site-kit'),
        onClick: onClick,
        text: true,
        tertiary: true,
        children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Back to dashboard', 'google-site-kit')
      })
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsxs)("div", {
      ref: headerDetailsRef,
      className: "googlesitekit-entity-header__details",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx)(_Typography_P__WEBPACK_IMPORTED_MODULE_7__["default"], {
        children: currentEntityTitle
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx)(_Link__WEBPACK_IMPORTED_MODULE_6__["default"], {
        href: entityURL,
        "aria-label": entityURL,
        secondary: true,
        external: true,
        children: url
      })]
    })]
  });
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (EntityHeader);

/***/ }),

/***/ "./js/components/EntitySearchInput.js":
/*!********************************************!*\
  !*** ./js/components/EntitySearchInput.js ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_use__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! react-use */ "../node_modules/react-use/esm/useMount.js");
/* harmony import */ var react_use__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! react-use */ "../node_modules/react-use/esm/useUpdateEffect.js");
/* harmony import */ var _wordpress_compose__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! @wordpress/compose */ "../node_modules/@wordpress/compose/build-module/hooks/use-instance-id/index.js");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! googlesitekit-components */ "googlesitekit-components");
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_components__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _VisuallyHidden__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./VisuallyHidden */ "./js/components/VisuallyHidden.js");
/* harmony import */ var _svg_icons_magnifying_glass_svg__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/svg/icons/magnifying-glass.svg */ "./svg/icons/magnifying-glass.svg");
/* harmony import */ var _svg_icons_close_dark_svg__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/svg/icons/close-dark.svg */ "./svg/icons/close-dark.svg");
/* harmony import */ var _PostSearcherAutoSuggest__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./PostSearcherAutoSuggest */ "./js/components/PostSearcherAutoSuggest.js");
/* harmony import */ var _js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @/js/googlesitekit/datastore/site/constants */ "./js/googlesitekit/datastore/site/constants.js");
/* harmony import */ var _js_googlesitekit_datastore_location_constants__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @/js/googlesitekit/datastore/location/constants */ "./js/googlesitekit/datastore/location/constants.js");
/* harmony import */ var _js_util__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @/js/util */ "./js/util/index.js");
/* harmony import */ var _js_hooks_useDashboardType__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @/js/hooks/useDashboardType */ "./js/hooks/useDashboardType.js");
/* harmony import */ var _js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @/js/hooks/useViewContext */ "./js/hooks/useViewContext.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * EntitySearchInput component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */




/**
 * Internal dependencies
 */












function EntitySearchInput() {
  const instanceID = (0,_wordpress_compose__WEBPACK_IMPORTED_MODULE_13__["default"])(EntitySearchInput, 'EntitySearchInput');
  const [isOpen, setIsOpen] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_14__.useState)(false);
  const [isLoading, setIsLoading] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_14__.useState)(false);
  const [isActive, setIsActive] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_14__.useState)(false);
  const viewContext = (0,_js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_11__["default"])();
  const dashboardType = (0,_js_hooks_useDashboardType__WEBPACK_IMPORTED_MODULE_10__["default"])();
  const buttonRef = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_14__.useRef)();
  const onOpen = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_14__.useCallback)(() => {
    (0,_js_util__WEBPACK_IMPORTED_MODULE_9__.trackEvent)(`${viewContext}_headerbar`, 'open_urlsearch');
    setIsOpen(true);
  }, [viewContext]);
  const onClose = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_14__.useCallback)(() => {
    (0,_js_util__WEBPACK_IMPORTED_MODULE_9__.trackEvent)(`${viewContext}_headerbar`, 'close_urlsearch');
    setIsOpen(false);
  }, [viewContext]);
  const [match, setMatch] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_14__.useState)({});
  const detailsURL = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => match?.url ? select(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_7__.CORE_SITE).getAdminURL('googlesitekit-dashboard', {
    permaLink: match.url
  }) : null);
  const {
    navigateTo
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useDispatch)(_js_googlesitekit_datastore_location_constants__WEBPACK_IMPORTED_MODULE_8__.CORE_LOCATION);
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_14__.useEffect)(() => {
    if (detailsURL) {
      (0,_js_util__WEBPACK_IMPORTED_MODULE_9__.trackEvent)(`${viewContext}_headerbar_urlsearch`, 'open_urldetails').finally(() => {
        navigateTo(detailsURL);
      });
    }
  }, [detailsURL, navigateTo, viewContext]);
  (0,react_use__WEBPACK_IMPORTED_MODULE_15__["default"])(() => {
    if (dashboardType === _js_hooks_useDashboardType__WEBPACK_IMPORTED_MODULE_10__.DASHBOARD_TYPE_ENTITY) {
      setIsOpen(true);
    }
  });
  (0,react_use__WEBPACK_IMPORTED_MODULE_16__["default"])(() => {
    if (!isOpen) {
      buttonRef?.current?.focus();
    }
  }, [isOpen]);
  if (isOpen) {
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsxs)("div", {
      className: "googlesitekit-entity-search googlesitekit-entity-search--is-open",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx)(_VisuallyHidden__WEBPACK_IMPORTED_MODULE_3__["default"], {
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx)("label", {
          htmlFor: instanceID,
          children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Page/URL Search', 'google-site-kit')
        })
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx)(_PostSearcherAutoSuggest__WEBPACK_IMPORTED_MODULE_6__["default"], {
        id: instanceID,
        match: match,
        setIsActive: setIsActive,
        setMatch: setMatch,
        placeholder: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Enter title or URL…', 'google-site-kit'),
        isLoading: isLoading,
        setIsLoading: setIsLoading,
        showDropdown: isActive,
        onClose: onClose
        /* eslint-disable-next-line jsx-a11y/no-autofocus */,
        autoFocus: true
      }), isLoading && isActive && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_2__.ProgressBar, {
        className: "googlesitekit-entity-search__loading",
        compress: true
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx)("div", {
        className: "googlesitekit-entity-search__actions",
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_2__.Button, {
          onClick: onClose,
          trailingIcon: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx)(_svg_icons_close_dark_svg__WEBPACK_IMPORTED_MODULE_5__["default"], {
            width: "30",
            height: "20"
          }),
          className: "googlesitekit-entity-search__close",
          title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Close', 'google-site-kit'),
          tooltipEnterDelayInMS: 500,
          text: true,
          tooltip: true
        })
      })]
    });
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx)("div", {
    className: "googlesitekit-entity-search",
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_2__.Button, {
      className: "googlesitekit-border-radius-round--phone googlesitekit-button-icon--phone",
      onClick: onOpen,
      ref: buttonRef,
      title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Search', 'google-site-kit'),
      trailingIcon: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx)(_svg_icons_magnifying_glass_svg__WEBPACK_IMPORTED_MODULE_4__["default"], {
        width: "20",
        height: "20"
      }),
      tooltipEnterDelayInMS: 500,
      text: true,
      tooltip: true,
      children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('URL Search', 'google-site-kit')
    })
  });
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (EntitySearchInput);

/***/ }),

/***/ "./js/components/ErrorHandler/index.js":
/*!*********************************************!*\
  !*** ./js/components/ErrorHandler/index.js ***!
  \*********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _js_components_GenericErrorHandlerActions__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/components/GenericErrorHandlerActions */ "./js/components/GenericErrorHandlerActions.js");
/* harmony import */ var _js_components_Root_ViewContextContext__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/components/Root/ViewContextContext */ "./js/components/Root/ViewContextContext.js");
/* harmony import */ var _js_googlesitekit_notifications_components_layout_BannerNotification__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/googlesitekit/notifications/components/layout/BannerNotification */ "./js/googlesitekit/notifications/components/layout/BannerNotification.js");
/* harmony import */ var _js_util__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/util */ "./js/util/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * ErrorHandler component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */





class ErrorHandler extends _wordpress_element__WEBPACK_IMPORTED_MODULE_6__.Component {
  constructor(props) {
    super(props);
    this.state = {
      error: null,
      info: null,
      copied: false
    };
  }
  componentDidCatch(error, info) {
    __webpack_require__.g.console.error('Caught an error:', error, info);
    this.setState({
      error,
      info
    });
    (0,_js_util__WEBPACK_IMPORTED_MODULE_4__.trackEvent)('react_error', `handle_${this.context || 'unknown'}_error`,
    // label has a max-length of 500 bytes.
    `${error?.message}\n${info?.componentStack}`.slice(0, 500));
  }
  render() {
    const {
      children
    } = this.props;
    const {
      error,
      info
    } = this.state;

    // If there is no caught error, render the children components normally.
    if (!error) {
      return children;
    }
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_js_googlesitekit_notifications_components_layout_BannerNotification__WEBPACK_IMPORTED_MODULE_3__["default"], {
      notificationID: "googlesitekit-error",
      className: "googlesitekit-error-handler",
      type: "error",
      title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Site Kit encountered an error', 'google-site-kit'),
      description: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)(_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.Fragment, {
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_js_components_GenericErrorHandlerActions__WEBPACK_IMPORTED_MODULE_1__["default"], {
          message: error.message,
          componentStack: info.componentStack
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)("pre", {
          className: "googlesitekit-overflow-auto",
          children: [error.message, info.componentStack]
        })]
      })
    });
  }
}
ErrorHandler.contextType = _js_components_Root_ViewContextContext__WEBPACK_IMPORTED_MODULE_2__["default"];
ErrorHandler.propTypes = {
  /** @ignore */
  children: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().node).isRequired
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ErrorHandler);

/***/ }),

/***/ "./js/components/ErrorNotice.js":
/*!**************************************!*\
  !*** ./js/components/ErrorNotice.js ***!
  \**************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ ErrorNotice)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_url__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @wordpress/url */ "../node_modules/@wordpress/url/build-module/is-url.js");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _js_util_errors__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/util/errors */ "./js/util/errors.js");
/* harmony import */ var _Notice__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./Notice */ "./js/components/Notice/index.js");
/* harmony import */ var _js_util__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/util */ "./js/util/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * ErrorNotice component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */




/**
 * Internal dependencies
 */





function ErrorNotice({
  className,
  error,
  hasButton = false,
  storeName,
  message = error.message,
  noPrefix = false,
  skipRetryMessage,
  hideIcon = false
}) {
  const dispatch = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useDispatch)();
  const selectorData = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => {
    if (!storeName) {
      return null;
    }
    return select(storeName).getSelectorDataForError(error);
  });
  const handleRetry = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.useCallback)(() => {
    dispatch(selectorData.storeName).invalidateResolution(selectorData.name, selectorData.args);
  }, [dispatch, selectorData]);

  // Do not display if there is no error and no direct message text is passed as a direct prop.
  // Also do not display if the error is for missing scopes as these are handled by a popup modal.
  if (!message || (0,_js_util_errors__WEBPACK_IMPORTED_MODULE_2__.isPermissionScopeError)(error)) {
    return null;
  }
  const shouldDisplayRetry = hasButton && (0,_js_util_errors__WEBPACK_IMPORTED_MODULE_2__.isErrorRetryable)(error, selectorData);

  /**
   * Error message to display to the user. Sometimes we append a retry message
   * or a reconnect URL, so we create a new variable for the message to display.
   */
  let errorMessageWithModifications = message;

  // Append "Try again" messaging if no retry button is present.
  if (!hasButton && !skipRetryMessage) {
    errorMessageWithModifications = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.sprintf)(/* translators: %s: Error message from Google API. */
    (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('%s (Please try again.)', 'google-site-kit'), errorMessageWithModifications);
  }
  if (!noPrefix) {
    errorMessageWithModifications = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.sprintf)(/* translators: $%s: Error message */
    (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Error: %s', 'google-site-kit'), errorMessageWithModifications);
  }
  const reconnectURL = error?.data?.reconnectURL;
  if (reconnectURL && (0,_wordpress_url__WEBPACK_IMPORTED_MODULE_7__.isURL)(reconnectURL)) {
    /**
     * This error message uses HTML tags without using
     * `createInterpolateElement` because the error messages
     * that come from the server/API can also contain HTML (eg. links)
     * we want to render.
     *
     * Instead of creating a React node using `createInterpolateElement`,
     * we use `dangerouslySetInnerHTML` to allow the HTML we create and from
     * the server/API to be rendered as-intended.
     */
    errorMessageWithModifications = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.sprintf)(/* translators: 1: Original error message 2: Reconnect URL */
    (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('%1$s To fix this, <a href="%2$s">redo the plugin setup</a>.', 'google-site-kit'), errorMessageWithModifications, reconnectURL);
  }
  const sanitizeArgs = {
    ALLOWED_TAGS: ['a'],
    ALLOWED_ATTR: ['href']
  };
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_Notice__WEBPACK_IMPORTED_MODULE_3__["default"], {
    className: className,
    type: _Notice__WEBPACK_IMPORTED_MODULE_3__["default"].TYPES.ERROR,
    description:
    /*#__PURE__*/
    // The error messages that come from the server/API can contain
    // HTML (eg. links), so we use `dangerouslySetInnerHTML` and sanitize
    // the HTML to render these links.
    //
    // We tried to use `createInterpolateElement` but it does not work
    // with HTML tags that come from the server/API.
    (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("span", {
      dangerouslySetInnerHTML: (0,_js_util__WEBPACK_IMPORTED_MODULE_4__.sanitizeHTML)(errorMessageWithModifications, sanitizeArgs)
    }),
    ctaButton: shouldDisplayRetry ? {
      label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Retry', 'google-site-kit'),
      onClick: handleRetry
    } : undefined,
    hideIcon: hideIcon
  });
}
ErrorNotice.propTypes = {
  className: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().string),
  error: prop_types__WEBPACK_IMPORTED_MODULE_8___default().shape({
    message: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().string)
  }),
  hasButton: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().bool),
  storeName: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().string),
  message: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().string),
  noPrefix: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().bool),
  skipRetryMessage: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().bool),
  hideIcon: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().bool)
};

/***/ }),

/***/ "./js/components/FeatureTours.js":
/*!***************************************!*\
  !*** ./js/components/FeatureTours.js ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ FeatureTours)
/* harmony export */ });
/* harmony import */ var react_use__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! react-use */ "../node_modules/react-use/esm/useMount.js");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/googlesitekit/datastore/user/constants */ "./js/googlesitekit/datastore/user/constants.js");
/* harmony import */ var _js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/hooks/useViewContext */ "./js/hooks/useViewContext.js");
/* harmony import */ var _TourTooltips__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./TourTooltips */ "./js/components/TourTooltips.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Feature Tours component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */





function FeatureTours() {
  const viewContext = (0,_js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_2__["default"])();
  const {
    triggerTourForView
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useDispatch)(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_1__.CORE_USER);
  (0,react_use__WEBPACK_IMPORTED_MODULE_5__["default"])(() => {
    triggerTourForView(viewContext);
  });
  const tour = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useSelect)(select => select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_1__.CORE_USER).getCurrentTour());
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.useEffect)(() => {
    if (!tour) {
      // Return noop cleanup function to satisfy consistent-return rule.
      return () => {};
    }
    const dashboardElement = document.getElementById('js-googlesitekit-main-dashboard');
    if (!dashboardElement) {
      // Return noop cleanup function to satisfy consistent-return rule.
      return () => {};
    }
    const observer = new ResizeObserver(() => {
      __webpack_require__.g.dispatchEvent(new Event('resize'));
    });
    observer.observe(dashboardElement);
    return () => {
      observer.disconnect();
    };
  }, [tour]);
  if (!tour) {
    return null;
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(_TourTooltips__WEBPACK_IMPORTED_MODULE_3__["default"], {
    tourID: tour.slug,
    steps: tour.steps,
    gaEventCategory: tour.gaEventCategory,
    callback: tour.callback
  });
}

/***/ }),

/***/ "./js/components/FeaturesProvider/FeaturesContext.js":
/*!***********************************************************!*\
  !*** ./js/components/FeaturesProvider/FeaturesContext.js ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _js_features__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @/js/features */ "./js/features/index.js");
/**
 * Feature Flags context for React components.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */

const FeaturesContext = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createContext)(_js_features__WEBPACK_IMPORTED_MODULE_0__.enabledFeatures);
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (FeaturesContext);

/***/ }),

/***/ "./js/components/FeaturesProvider/index.js":
/*!*************************************************!*\
  !*** ./js/components/FeaturesProvider/index.js ***!
  \*************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Consumer: () => (/* binding */ Consumer),
/* harmony export */   Provider: () => (/* binding */ Provider),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _FeaturesContext__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./FeaturesContext */ "./js/components/FeaturesProvider/FeaturesContext.js");
/**
 * Feature Flags Provider component.
 *
 * Site Kit by Google, Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Internal dependencies
 */

const {
  Consumer,
  Provider
} = _FeaturesContext__WEBPACK_IMPORTED_MODULE_0__["default"];
const FeaturesProvider = Provider;
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (FeaturesProvider);

/***/ }),

/***/ "./js/components/GenericErrorHandlerActions.js":
/*!*****************************************************!*\
  !*** ./js/components/GenericErrorHandlerActions.js ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ GenericErrorHandlerActions)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Link__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Link */ "./js/components/Link.js");
/* harmony import */ var _ReportErrorButton__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./ReportErrorButton */ "./js/components/ReportErrorButton/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * GenericErrorHandlerActions component.
 *
 * Site Kit by Google, Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */



function GenericErrorHandlerActions({
  message,
  componentStack
}) {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
    className: "googlesitekit-generic-error-handler-actions",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_ReportErrorButton__WEBPACK_IMPORTED_MODULE_2__["default"], {
      message: message,
      componentStack: componentStack
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_Link__WEBPACK_IMPORTED_MODULE_1__["default"], {
      href: "https://wordpress.org/support/plugin/google-site-kit/",
      external: true,
      children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Report this problem', 'google-site-kit')
    })]
  });
}
GenericErrorHandlerActions.propTypes = {
  message: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().string),
  componentStack: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().string)
};

/***/ }),

/***/ "./js/components/Header.js":
/*!*********************************!*\
  !*** ./js/components/Header.js ***!
  \*********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_21___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_21__);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react_use_observer__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! react-use-observer */ "../node_modules/react-use-observer/es/useMutationObserver.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _Logo__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./Logo */ "./js/components/Logo.js");
/* harmony import */ var _UserMenu__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./UserMenu */ "./js/components/UserMenu/index.js");
/* harmony import */ var _js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/googlesitekit/datastore/user/constants */ "./js/googlesitekit/datastore/user/constants.js");
/* harmony import */ var _js_material_components__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @/js/material-components */ "./js/material-components/index.js");
/* harmony import */ var _DashboardNavigation__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./DashboardNavigation */ "./js/components/DashboardNavigation/index.js");
/* harmony import */ var _EntityHeader__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./EntityHeader */ "./js/components/EntityHeader.js");
/* harmony import */ var _ViewOnlyMenu__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./ViewOnlyMenu */ "./js/components/ViewOnlyMenu/index.js");
/* harmony import */ var _js_hooks_useViewOnly__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @/js/hooks/useViewOnly */ "./js/hooks/useViewOnly.js");
/* harmony import */ var _js_hooks_useDashboardType__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @/js/hooks/useDashboardType */ "./js/hooks/useDashboardType.js");
/* harmony import */ var _Link__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ./Link */ "./js/components/Link.js");
/* harmony import */ var _notifications_LegacyNotifications__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ./notifications/LegacyNotifications */ "./js/components/notifications/LegacyNotifications.js");
/* harmony import */ var _notifications_Notifications__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ./notifications/Notifications */ "./js/components/notifications/Notifications.js");
/* harmony import */ var _js_googlesitekit_notifications_constants__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! @/js/googlesitekit/notifications/constants */ "./js/googlesitekit/notifications/constants.js");
/* harmony import */ var _js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! @/js/googlesitekit/datastore/site/constants */ "./js/googlesitekit/datastore/site/constants.js");
/* harmony import */ var _js_hooks_useGlobalTrackingEffect__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! @/js/hooks/useGlobalTrackingEffect */ "./js/hooks/useGlobalTrackingEffect.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Header component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */




/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */

















function Header({
  children,
  subHeader,
  showNavigation
}) {
  const isDashboard = !!(0,_js_hooks_useDashboardType__WEBPACK_IMPORTED_MODULE_11__["default"])();
  const isViewOnly = (0,_js_hooks_useViewOnly__WEBPACK_IMPORTED_MODULE_10__["default"])();
  (0,_js_hooks_useGlobalTrackingEffect__WEBPACK_IMPORTED_MODULE_17__.useGlobalTrackingEffect)();
  const dashboardURL = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.useSelect)(select => select(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_16__.CORE_SITE).getAdminURL('googlesitekit-dashboard'));
  const isAuthenticated = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.useSelect)(select => select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_5__.CORE_USER).isAuthenticated());
  const [subHeaderRef, subHeaderMutation] = (0,react_use_observer__WEBPACK_IMPORTED_MODULE_19__["default"])({
    childList: true
  });
  const hasSubheader = !!subHeaderMutation.target?.childElementCount;
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsxs)(_wordpress_element__WEBPACK_IMPORTED_MODULE_20__.Fragment, {
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx)("header", {
      className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-header', {
        'googlesitekit-header--has-subheader': hasSubheader,
        'googlesitekit-header--has-navigation': showNavigation
      }),
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx)(_js_material_components__WEBPACK_IMPORTED_MODULE_6__.Grid, {
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsxs)(_js_material_components__WEBPACK_IMPORTED_MODULE_6__.Row, {
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx)(_js_material_components__WEBPACK_IMPORTED_MODULE_6__.Cell, {
            smSize: 1,
            mdSize: 2,
            lgSize: 4,
            className: "googlesitekit-header__logo",
            alignMiddle: true,
            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx)(_Link__WEBPACK_IMPORTED_MODULE_12__["default"], {
              "aria-label": (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Go to dashboard', 'google-site-kit'),
              className: "googlesitekit-header__logo-link",
              href: dashboardURL,
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx)(_Logo__WEBPACK_IMPORTED_MODULE_3__["default"], {})
            })
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsxs)(_js_material_components__WEBPACK_IMPORTED_MODULE_6__.Cell, {
            smSize: 3,
            mdSize: 6,
            lgSize: 8,
            className: "googlesitekit-header__children",
            alignMiddle: true,
            children: [children, !isAuthenticated && isDashboard && isViewOnly && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx)(_ViewOnlyMenu__WEBPACK_IMPORTED_MODULE_9__["default"], {}), isAuthenticated && !isViewOnly && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx)(_UserMenu__WEBPACK_IMPORTED_MODULE_4__["default"], {})]
          })]
        })
      })
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx)("div", {
      className: "googlesitekit-subheader",
      ref: subHeaderRef,
      children: subHeader
    }), showNavigation && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx)(_DashboardNavigation__WEBPACK_IMPORTED_MODULE_7__["default"], {}), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx)(_EntityHeader__WEBPACK_IMPORTED_MODULE_8__["default"], {}), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx)(_notifications_LegacyNotifications__WEBPACK_IMPORTED_MODULE_13__["default"], {}), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx)(_notifications_Notifications__WEBPACK_IMPORTED_MODULE_14__["default"], {
      areaSlug: _js_googlesitekit_notifications_constants__WEBPACK_IMPORTED_MODULE_15__.NOTIFICATION_AREAS.HEADER
    })]
  });
}
Header.displayName = 'Header';
Header.propTypes = {
  children: (prop_types__WEBPACK_IMPORTED_MODULE_21___default().node),
  subHeader: (prop_types__WEBPACK_IMPORTED_MODULE_21___default().element),
  showNavigation: (prop_types__WEBPACK_IMPORTED_MODULE_21___default().bool)
};
Header.defaultProps = {
  children: null,
  subHeader: null
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Header);

/***/ }),

/***/ "./js/components/IconWrapper.js":
/*!**************************************!*\
  !*** ./js/components/IconWrapper.js ***!
  \**************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ IconWrapper)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * IconWrapper component.
 *
 * Site Kit by Google, Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


function IconWrapper({
  children,
  marginLeft,
  marginRight
}) {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("span", {
    className: "googlesitekit-icon-wrapper",
    style: {
      marginLeft,
      marginRight
    },
    children: children
  });
}
IconWrapper.propTypes = {
  children: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().node).isRequired,
  marginLeft: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().number),
  marginRight: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().number)
};

/***/ }),

/***/ "./js/components/InViewProvider/InViewContext.js":
/*!*******************************************************!*\
  !*** ./js/components/InViewProvider/InViewContext.js ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/**
 * InView context for React components.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */

const InViewContext = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createContext)(false);
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (InViewContext);

/***/ }),

/***/ "./js/components/InViewProvider/index.js":
/*!***********************************************!*\
  !*** ./js/components/InViewProvider/index.js ***!
  \***********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Consumer: () => (/* binding */ Consumer),
/* harmony export */   Provider: () => (/* binding */ Provider),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _InViewContext__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./InViewContext */ "./js/components/InViewProvider/InViewContext.js");
/**
 * In-view Provider component.
 *
 * Site Kit by Google, Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Internal dependencies
 */

const {
  Consumer,
  Provider
} = _InViewContext__WEBPACK_IMPORTED_MODULE_0__["default"];
const InViewProvider = Provider;
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (InViewProvider);

/***/ }),

/***/ "./js/components/InfoTooltip.js":
/*!**************************************!*\
  !*** ./js/components/InfoTooltip.js ***!
  \**************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ InfoTooltip)
/* harmony export */ });
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-components */ "googlesitekit-components");
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _svg_icons_info_green_svg__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/svg/icons/info-green.svg */ "./svg/icons/info-green.svg");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * InfoTooltip component.
 *
 * Site Kit by Google, Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * Internal dependencies
 */



function InfoTooltip({
  onOpen,
  title,
  tooltipClassName
}) {
  if (!title) {
    return null;
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__.Tooltip, {
    className: "googlesitekit-info-tooltip",
    tooltipClassName: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-info-tooltip__content', tooltipClassName),
    title: title,
    placement: "top",
    enterTouchDelay: 0,
    leaveTouchDelay: 5000,
    onOpen: onOpen,
    interactive: true,
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("span", {
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_svg_icons_info_green_svg__WEBPACK_IMPORTED_MODULE_2__["default"], {
        width: "16",
        height: "16"
      })
    })
  });
}
InfoTooltip.propTypes = {
  onOpen: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().func),
  title: prop_types__WEBPACK_IMPORTED_MODULE_4___default().oneOfType([(prop_types__WEBPACK_IMPORTED_MODULE_4___default().string), (prop_types__WEBPACK_IMPORTED_MODULE_4___default().element)]),
  tooltipClassName: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().string)
};

/***/ }),

/***/ "./js/components/JoyrideTooltip.js":
/*!*****************************************!*\
  !*** ./js/components/JoyrideTooltip.js ***!
  \*****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ JoyrideTooltip)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var react_joyride__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! react-joyride */ "../node_modules/react-joyride/dist/index.mjs");
/* harmony import */ var react_use__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! react-use */ "../node_modules/react-use/esm/useInterval.js");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _TourTooltip__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./TourTooltip */ "./js/components/TourTooltip.js");
/* harmony import */ var _Portal__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Portal */ "./js/components/Portal.js");
/* harmony import */ var _TourTooltips__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./TourTooltips */ "./js/components/TourTooltips.js");
/* harmony import */ var _js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/hooks/useBreakpoint */ "./js/hooks/useBreakpoint.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * JoyRideTooltip component.
 *
 * Site Kit by Google, Copyright 2022 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */




/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */





function JoyrideTooltip(props) {
  const {
    title,
    content,
    dismissLabel,
    disableOverlay = true,
    target,
    cta = false,
    className,
    styles = {},
    slug = '',
    placement = 'auto',
    onDismiss = () => {},
    onView = () => {},
    onTourStart = () => {},
    onTourEnd = () => {}
  } = props;
  function checkIfTargetExists() {
    return !!__webpack_require__.g.document.querySelector(target);
  }
  const [targetExists, setTargetExists] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_5__.useState)(checkIfTargetExists);
  const breakpoint = (0,_js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_3__.useBreakpoint)();
  const isMobileTablet = breakpoint === _js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_3__.BREAKPOINT_SMALL || breakpoint === _js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_3__.BREAKPOINT_TABLET;
  const [shouldRun, setShouldRun] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_5__.useState)(true);
  const previousIsMobileTabletRef = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_5__.useRef)(isMobileTablet);
  (0,react_use__WEBPACK_IMPORTED_MODULE_6__["default"])(() => {
    if (checkIfTargetExists()) {
      setTargetExists(true);
    }
  },
  // An delay of null will stop the interval.
  targetExists ? null : 250);
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_5__.useEffect)(() => {
    // eslint-disable-next-line sitekit/function-declaration-consistency
    let disconnect = () => {};
    if (typeof __webpack_require__.g.ResizeObserver === 'function') {
      const targetElement = __webpack_require__.g.document.querySelector(target);
      if (targetElement) {
        const resizeObserver = new ResizeObserver(() => {
          // Dispatch a window resize event to trigger the tooltip to reposition.
          __webpack_require__.g.dispatchEvent(new Event('resize'));
        });
        resizeObserver.observe(targetElement);
        disconnect = () => resizeObserver.disconnect();
      }
    }
    return disconnect;
  }, [target, targetExists]);

  // Reset the component between mobile and desktop layouts they use different
  // targets which requires the tooltip to be re-rendered to display correctly.
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_5__.useEffect)(() => {
    let timeoutID;
    if (previousIsMobileTabletRef.current !== isMobileTablet) {
      setShouldRun(false);
      timeoutID = setTimeout(() => {
        setShouldRun(true);
      }, 50);
      previousIsMobileTabletRef.current = isMobileTablet;
    }
    return () => {
      if (timeoutID) {
        clearTimeout(timeoutID);
      }
    };
  }, [isMobileTablet]);

  // Joyride expects the step's target to be in the DOM immediately
  // so we need to wait for it in some cases, e.g. loading data.
  if (!targetExists) {
    return null;
  }
  const steps = [{
    title,
    target,
    content,
    disableBeacon: true,
    isFixed: true,
    placement,
    cta,
    className
  }];

  // Provides button content as well as aria-label & title attribute values.
  const joyrideLocale = {
    close: dismissLabel,
    last: dismissLabel
  };
  function callback({
    type
  }) {
    switch (type) {
      case react_joyride__WEBPACK_IMPORTED_MODULE_7__.EVENTS.TOUR_START:
        onTourStart();
        __webpack_require__.g.document.body.classList.add('googlesitekit-showing-tooltip');
        break;
      case react_joyride__WEBPACK_IMPORTED_MODULE_7__.EVENTS.TOUR_END:
        onTourEnd();
        __webpack_require__.g.document.body.classList.remove('googlesitekit-showing-tooltip');
        break;
      case react_joyride__WEBPACK_IMPORTED_MODULE_7__.EVENTS.STEP_AFTER:
        // This is not strictly necessary as the tooltip will hide without it,
        // but this allows the consumer of the component to clean up
        // post-dismiss.
        onDismiss();
        break;
      case react_joyride__WEBPACK_IMPORTED_MODULE_7__.EVENTS.TOOLTIP:
        onView();
        break;
    }
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(_Portal__WEBPACK_IMPORTED_MODULE_1__["default"], {
    slug: slug,
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(react_joyride__WEBPACK_IMPORTED_MODULE_7__["default"], {
      callback: callback,
      disableOverlay: disableOverlay,
      spotlightPadding: 0,
      floaterProps: _TourTooltips__WEBPACK_IMPORTED_MODULE_2__.floaterProps,
      locale: joyrideLocale,
      steps: steps,
      styles: {
        ..._TourTooltips__WEBPACK_IMPORTED_MODULE_2__.joyrideStyles,
        ...styles,
        options: {
          ..._TourTooltips__WEBPACK_IMPORTED_MODULE_2__.joyrideStyles.options,
          ...styles?.options
        },
        spotlight: {
          ..._TourTooltips__WEBPACK_IMPORTED_MODULE_2__.joyrideStyles.spotlight,
          ...styles?.spotlight
        }
      },
      tooltipComponent: _TourTooltip__WEBPACK_IMPORTED_MODULE_0__["default"],
      run: shouldRun,
      disableScrolling: true
    })
  });
}
JoyrideTooltip.propTypes = {
  title: prop_types__WEBPACK_IMPORTED_MODULE_8__.PropTypes.node,
  content: prop_types__WEBPACK_IMPORTED_MODULE_8__.PropTypes.string,
  disableOverlay: prop_types__WEBPACK_IMPORTED_MODULE_8__.PropTypes.bool,
  dismissLabel: prop_types__WEBPACK_IMPORTED_MODULE_8__.PropTypes.string,
  target: prop_types__WEBPACK_IMPORTED_MODULE_8__.PropTypes.string.isRequired,
  onDismiss: prop_types__WEBPACK_IMPORTED_MODULE_8__.PropTypes.func,
  onShow: prop_types__WEBPACK_IMPORTED_MODULE_8__.PropTypes.func,
  className: prop_types__WEBPACK_IMPORTED_MODULE_8__.PropTypes.string,
  styles: prop_types__WEBPACK_IMPORTED_MODULE_8__.PropTypes.object,
  slug: prop_types__WEBPACK_IMPORTED_MODULE_8__.PropTypes.string,
  placement: prop_types__WEBPACK_IMPORTED_MODULE_8__.PropTypes.string,
  onView: prop_types__WEBPACK_IMPORTED_MODULE_8__.PropTypes.func
};

/***/ }),

/***/ "./js/components/KeyMetrics/ChipTabGroup/Chip.js":
/*!*******************************************************!*\
  !*** ./js/components/KeyMetrics/ChipTabGroup/Chip.js ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Chip)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-components */ "googlesitekit-components");
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _js_components_KeyMetrics_constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/components/KeyMetrics/constants */ "./js/components/KeyMetrics/constants.js");
/* harmony import */ var _svg_icons_check_2_svg__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/svg/icons/check-2.svg */ "./svg/icons/check-2.svg");
/* harmony import */ var _svg_icons_star_fill_svg__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/svg/icons/star-fill.svg */ "./svg/icons/star-fill.svg");
/* harmony import */ var _js_components_Null__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/components/Null */ "./js/components/Null.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Chip component.
 *
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * Internal dependencies
 */






const icons = {
  [_js_components_KeyMetrics_constants__WEBPACK_IMPORTED_MODULE_2__.KEY_METRICS_GROUP_CURRENT.SLUG]: _svg_icons_check_2_svg__WEBPACK_IMPORTED_MODULE_3__["default"],
  [_js_components_KeyMetrics_constants__WEBPACK_IMPORTED_MODULE_2__.KEY_METRICS_GROUP_SUGGESTED.SLUG]: _svg_icons_star_fill_svg__WEBPACK_IMPORTED_MODULE_4__["default"]
};
function Chip({
  slug,
  label,
  isActive,
  onClick,
  hasNewBadge = false,
  selectedCount = 0
}) {
  const Icon = icons[slug] || _js_components_Null__WEBPACK_IMPORTED_MODULE_5__["default"];
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__.Button, {
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-chip-tab-group__chip-item', {
      'googlesitekit-chip-tab-group__chip-item--active': isActive
    }),
    icon: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(Icon, {
      width: 12,
      height: 12,
      className: `googlesitekit-chip-tab-group__chip-item-svg googlesitekit-chip-tab-group__chip-item-svg__${slug}`
    }),
    trailingIcon: selectedCount > 0 ? /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)("span", {
      className: "googlesitekit-chip-tab-group__chip-item-count",
      children: ["(", selectedCount, ")"]
    }) : null,
    onClick: () => onClick(slug),
    children: [label, hasNewBadge && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("span", {
      className: "googlesitekit-chip-tab-group__chip-item-new-dot"
    })]
  });
}
Chip.propTypes = {
  slug: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().string).isRequired,
  label: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().string).isRequired,
  isActive: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().bool),
  hasNewBadge: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().bool),
  selectedCount: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().number),
  onClick: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().func).isRequired
};

/***/ }),

/***/ "./js/components/KeyMetrics/ChipTabGroup/TabContent.js":
/*!*************************************************************!*\
  !*** ./js/components/KeyMetrics/ChipTabGroup/TabContent.js ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ TabContent)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _js_components_KeyMetrics_MetricsSelectionPanel_MetricItem__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/components/KeyMetrics/MetricsSelectionPanel/MetricItem */ "./js/components/KeyMetrics/MetricsSelectionPanel/MetricItem.js");
/* harmony import */ var _svg_graphics_key_metrics_no_selected_items_svg__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/svg/graphics/key-metrics-no-selected-items.svg */ "./svg/graphics/key-metrics-no-selected-items.svg");
/* harmony import */ var _js_components_Typography_P__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/components/Typography/P */ "./js/components/Typography/P.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * TabContent component.
 *
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */




function TabContent({
  activeMetricItems,
  newlyDetectedMetrics,
  savedItemSlugs
}) {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsxs)("div", {
    className: "googlesitekit-chip-tab-group__tab-item",
    children: [Object.keys(activeMetricItems).map(slug => {
      const metricGroup = activeMetricItems[slug].group;
      const isNewlyDetected = newlyDetectedMetrics?.[metricGroup]?.includes(slug);
      return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(_js_components_KeyMetrics_MetricsSelectionPanel_MetricItem__WEBPACK_IMPORTED_MODULE_1__["default"], {
        slug: slug,
        savedItemSlugs: savedItemSlugs,
        isNewlyDetected: isNewlyDetected,
        ...activeMetricItems[slug]
      }, slug);
    }), !Object.keys(activeMetricItems).length && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsxs)("div", {
      className: "googlesitekit-chip-tab-group__graphic",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(_svg_graphics_key_metrics_no_selected_items_svg__WEBPACK_IMPORTED_MODULE_2__["default"], {
        height: 250
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(_js_components_Typography_P__WEBPACK_IMPORTED_MODULE_3__["default"], {
        children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('No metrics were selected yet', 'google-site-kit')
      })]
    })]
  });
}
TabContent.propTypes = {
  activeMetricItems: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().object).isRequired,
  newlyDetectedMetrics: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().object).isRequired,
  savedItemSlugs: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().array)
};

/***/ }),

/***/ "./js/components/KeyMetrics/ChipTabGroup/TabItems.js":
/*!***********************************************************!*\
  !*** ./js/components/KeyMetrics/ChipTabGroup/TabItems.js ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ TabItems)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! googlesitekit-components */ "googlesitekit-components");
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_components__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Chip__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Chip */ "./js/components/KeyMetrics/ChipTabGroup/Chip.js");
/* harmony import */ var _svg_icons_check_2_svg__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/svg/icons/check-2.svg */ "./svg/icons/check-2.svg");
/* harmony import */ var _svg_icons_star_fill_svg__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/svg/icons/star-fill.svg */ "./svg/icons/star-fill.svg");
/* harmony import */ var _js_components_Null__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/components/Null */ "./js/components/Null.js");
/* harmony import */ var _js_components_KeyMetrics_constants__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/components/KeyMetrics/constants */ "./js/components/KeyMetrics/constants.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * TabItems component.
 *
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * Internal dependencies
 */







const icons = {
  [_js_components_KeyMetrics_constants__WEBPACK_IMPORTED_MODULE_5__.KEY_METRICS_GROUP_CURRENT.SLUG]: _svg_icons_check_2_svg__WEBPACK_IMPORTED_MODULE_2__["default"],
  [_js_components_KeyMetrics_constants__WEBPACK_IMPORTED_MODULE_5__.KEY_METRICS_GROUP_SUGGESTED.SLUG]: _svg_icons_star_fill_svg__WEBPACK_IMPORTED_MODULE_3__["default"]
};
function TabItems({
  containerRef,
  isMobileBreakpoint,
  chipItemRows,
  allGroups,
  isActive,
  onChipChange,
  selectedCounts,
  newlyDetectedMetrics,
  activeGroupIndex
}) {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)("div", {
    className: "googlesitekit-chip-tab-group__tab-items",
    ref: containerRef,
    children: [!isMobileBreakpoint && chipItemRows.map(row => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("div", {
      className: "googlesitekit-chip-tab-group__tab-items-row",
      children: row.map(group => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(_Chip__WEBPACK_IMPORTED_MODULE_1__["default"], {
        slug: group.SLUG,
        label: group.LABEL,
        hasNewBadge: !!newlyDetectedMetrics?.[group.SLUG],
        isActive: group.SLUG === isActive,
        onClick: onChipChange,
        selectedCount: selectedCounts[group.SLUG]
      }, group.SLUG))
    }, `row-${row[0].SLUG}`)), isMobileBreakpoint && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_0__.TabBar, {
      activeIndex: activeGroupIndex,
      handleActiveIndexUpdate: index => onChipChange(null, index),
      children: allGroups.map((group, index) => {
        const Icon = icons[group.SLUG] || _js_components_Null__WEBPACK_IMPORTED_MODULE_4__["default"];
        return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_0__.Tab, {
          "aria-label": group.LABEL,
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(Icon, {
            width: 12,
            height: 12,
            className: `googlesitekit-chip-tab-group__chip-item-svg googlesitekit-chip-tab-group__tab-item-mobile-svg googlesitekit-chip-tab-group__chip-item-svg__${group.SLUG}`
          }), group.LABEL, selectedCounts[group.SLUG] > 0 && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)("span", {
            className: "googlesitekit-chip-tab-group__chip-item-count",
            children: ["(", selectedCounts[group.SLUG], ")"]
          }), !!newlyDetectedMetrics?.[group.SLUG] && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("span", {
            className: "googlesitekit-chip-tab-group__chip-item-new-dot"
          })]
        }, index);
      })
    })]
  });
}
TabItems.propTypes = {
  containerRef: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().object),
  isMobileBreakpoint: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().bool),
  chipItemRows: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().array).isRequired,
  allGroups: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().array).isRequired,
  isActive: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().string).isRequired,
  onChipChange: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().func).isRequired,
  selectedCounts: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().object).isRequired,
  newlyDetectedMetrics: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().object).isRequired,
  activeGroupIndex: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().number).isRequired
};

/***/ }),

/***/ "./js/components/KeyMetrics/ChipTabGroup/index.js":
/*!********************************************************!*\
  !*** ./js/components/KeyMetrics/ChipTabGroup/index.js ***!
  \********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ ChipTabGroup)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _wordpress_compose__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! @wordpress/compose */ "../node_modules/@wordpress/compose/build-module/hooks/use-previous/index.js");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _js_components_KeyMetrics_constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/components/KeyMetrics/constants */ "./js/components/KeyMetrics/constants.js");
/* harmony import */ var _js_googlesitekit_datastore_forms_constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/googlesitekit/datastore/forms/constants */ "./js/googlesitekit/datastore/forms/constants.js");
/* harmony import */ var _js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/modules/analytics-4/datastore/constants */ "./js/modules/analytics-4/datastore/constants.js");
/* harmony import */ var _js_modules_analytics_4_constants__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/modules/analytics-4/constants */ "./js/modules/analytics-4/constants.js");
/* harmony import */ var _js_googlesitekit_datastore_ui_constants__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/googlesitekit/datastore/ui/constants */ "./js/googlesitekit/datastore/ui/constants.js");
/* harmony import */ var _js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @/js/googlesitekit/datastore/user/constants */ "./js/googlesitekit/datastore/user/constants.js");
/* harmony import */ var _js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @/js/googlesitekit/modules/datastore/constants */ "./js/googlesitekit/modules/datastore/constants.js");
/* harmony import */ var _js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @/js/hooks/useBreakpoint */ "./js/hooks/useBreakpoint.js");
/* harmony import */ var _js_hooks_useFormValue__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @/js/hooks/useFormValue */ "./js/hooks/useFormValue.js");
/* harmony import */ var _js_components_KeyMetrics_hooks_useCurrentlyActiveEvents__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @/js/components/KeyMetrics/hooks/useCurrentlyActiveEvents */ "./js/components/KeyMetrics/hooks/useCurrentlyActiveEvents.js");
/* harmony import */ var _js_components_KeyMetrics_hooks_useKeyMetricsGroups__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @/js/components/KeyMetrics/hooks/useKeyMetricsGroups */ "./js/components/KeyMetrics/hooks/useKeyMetricsGroups.js");
/* harmony import */ var _js_components_KeyMetrics_hooks_useFilteredKeyMetrics__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! @/js/components/KeyMetrics/hooks/useFilteredKeyMetrics */ "./js/components/KeyMetrics/hooks/useFilteredKeyMetrics.js");
/* harmony import */ var _js_components_KeyMetrics_hooks_useOverflowingTabs__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! @/js/components/KeyMetrics/hooks/useOverflowingTabs */ "./js/components/KeyMetrics/hooks/useOverflowingTabs.js");
/* harmony import */ var _js_components_KeyMetrics_hooks_useNewBadgeEvents__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! @/js/components/KeyMetrics/hooks/useNewBadgeEvents */ "./js/components/KeyMetrics/hooks/useNewBadgeEvents.js");
/* harmony import */ var _TabItems__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ./TabItems */ "./js/components/KeyMetrics/ChipTabGroup/TabItems.js");
/* harmony import */ var _TabContent__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ./TabContent */ "./js/components/KeyMetrics/ChipTabGroup/TabContent.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * ChipTabGroup component.
 *
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */


















const emptyArray = Object.freeze([]);
function ChipTabGroup({
  allMetricItems,
  savedItemSlugs
}) {
  const containerRef = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_18__.useRef)();
  const [isActive, setIsActive] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_18__.useState)(_js_components_KeyMetrics_constants__WEBPACK_IMPORTED_MODULE_1__.KEY_METRICS_GROUP_CURRENT.SLUG);
  // Used for mobile chip tabs, which leverages the TabBar component for seemless horizontal scroll
  // but it accepts a numerical index for the active tab.
  const [activeGroupIndex, setActiveGroupIndex] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_18__.useState)(0);
  const breakpoint = (0,_js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_8__.useBreakpoint)();
  const isMobileBreakpoint = breakpoint === _js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_8__.BREAKPOINT_SMALL;
  const selectedMetrics = (0,_js_hooks_useFormValue__WEBPACK_IMPORTED_MODULE_9__["default"])(_js_components_KeyMetrics_constants__WEBPACK_IMPORTED_MODULE_1__.KEY_METRICS_SELECTION_FORM, _js_components_KeyMetrics_constants__WEBPACK_IMPORTED_MODULE_1__.KEY_METRICS_SELECTED);
  const effectiveSelection = (0,_js_hooks_useFormValue__WEBPACK_IMPORTED_MODULE_9__["default"])(_js_components_KeyMetrics_constants__WEBPACK_IMPORTED_MODULE_1__.KEY_METRICS_SELECTION_FORM, _js_components_KeyMetrics_constants__WEBPACK_IMPORTED_MODULE_1__.EFFECTIVE_SELECTION) || emptyArray;
  const unstagedSelection = (0,_js_hooks_useFormValue__WEBPACK_IMPORTED_MODULE_9__["default"])(_js_components_KeyMetrics_constants__WEBPACK_IMPORTED_MODULE_1__.KEY_METRICS_SELECTION_FORM, _js_components_KeyMetrics_constants__WEBPACK_IMPORTED_MODULE_1__.UNSTAGED_SELECTION) || emptyArray;
  const isUserInputCompleted = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useSelect)(select => select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_6__.CORE_USER).isUserInputCompleted());
  const currentlyActiveEvents = (0,_js_components_KeyMetrics_hooks_useCurrentlyActiveEvents__WEBPACK_IMPORTED_MODULE_10__["default"])();
  const isGA4Connected = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useSelect)(select => select(_js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_7__.CORE_MODULES).isModuleConnected(_js_modules_analytics_4_constants__WEBPACK_IMPORTED_MODULE_4__.MODULE_SLUG_ANALYTICS_4));
  const detectedEvents = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useSelect)(select => {
    if (!isGA4Connected) {
      return [];
    }
    return select(_js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_3__.MODULES_ANALYTICS_4).getDetectedEvents();
  });
  const answerBasedMetrics = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useSelect)(select => select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_6__.CORE_USER).getAnswerBasedMetrics(null, [...(currentlyActiveEvents || []), ...(detectedEvents || [])]));
  const {
    keyMetricsGroups,
    dynamicGroups
  } = (0,_js_components_KeyMetrics_hooks_useKeyMetricsGroups__WEBPACK_IMPORTED_MODULE_11__["default"])({
    detectedEvents,
    currentlyActiveEvents,
    isUserInputCompleted,
    answerBasedMetrics
  });
  const allGroups = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_18__.useMemo)(() => [...dynamicGroups, ...keyMetricsGroups], [dynamicGroups, keyMetricsGroups]);
  const newBadgeEvents = (0,_js_components_KeyMetrics_hooks_useNewBadgeEvents__WEBPACK_IMPORTED_MODULE_14__["default"])();
  const conversionReportingEventWidgets = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useSelect)(select => {
    if (!isGA4Connected) {
      return [];
    }
    return select(_js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_3__.MODULES_ANALYTICS_4).getKeyMetricsConversionEventWidgets();
  });
  const {
    selectedCounts,
    activeMetricItems,
    newlyDetectedMetrics
  } = (0,_js_components_KeyMetrics_hooks_useFilteredKeyMetrics__WEBPACK_IMPORTED_MODULE_12__["default"])({
    allMetricItems,
    isActive,
    effectiveSelection,
    answerBasedMetrics,
    selectedMetrics,
    newBadgeEvents,
    conversionReportingEventWidgets
  });
  const {
    setValues
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useDispatch)(_js_googlesitekit_datastore_forms_constants__WEBPACK_IMPORTED_MODULE_2__.CORE_FORMS);
  const resetUnstagedSelection = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_18__.useCallback)(() => {
    setValues(_js_components_KeyMetrics_constants__WEBPACK_IMPORTED_MODULE_1__.KEY_METRICS_SELECTION_FORM, {
      [_js_components_KeyMetrics_constants__WEBPACK_IMPORTED_MODULE_1__.KEY_METRICS_SELECTED]: selectedMetrics,
      [_js_components_KeyMetrics_constants__WEBPACK_IMPORTED_MODULE_1__.EFFECTIVE_SELECTION]: [...effectiveSelection, ...unstagedSelection],
      [_js_components_KeyMetrics_constants__WEBPACK_IMPORTED_MODULE_1__.UNSTAGED_SELECTION]: []
    });
  }, [selectedMetrics, effectiveSelection, unstagedSelection, setValues]);
  const onChipChange = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_18__.useCallback)((slug, index) => {
    if (!slug) {
      // Set active group for mobile tabs.
      const activeGroup = allGroups[index];
      setActiveGroupIndex(index);
      setIsActive(activeGroup.SLUG);
    } else {
      setIsActive(slug);
    }
    if (unstagedSelection.length) {
      resetUnstagedSelection();
    }
  }, [allGroups, unstagedSelection, setIsActive, resetUnstagedSelection]);
  const isSelectionPanelOpen = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useSelect)(select => select(_js_googlesitekit_datastore_ui_constants__WEBPACK_IMPORTED_MODULE_5__.CORE_UI).getValue(_js_components_KeyMetrics_constants__WEBPACK_IMPORTED_MODULE_1__.KEY_METRICS_SELECTION_PANEL_OPENED_KEY));
  const isSelectionPanelOpenPrevious = (0,_wordpress_compose__WEBPACK_IMPORTED_MODULE_19__["default"])(isSelectionPanelOpen);
  const newlyDetectedMetricsKeys = Object.keys(newlyDetectedMetrics);
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_18__.useEffect)(() => {
    // Ensure that current selection group is always active when selection panel re-opens.
    if (!isSelectionPanelOpenPrevious && isSelectionPanelOpen) {
      setIsActive(_js_components_KeyMetrics_constants__WEBPACK_IMPORTED_MODULE_1__.KEY_METRICS_GROUP_CURRENT.SLUG);
      setActiveGroupIndex(0);
      if (newlyDetectedMetricsKeys.length && isMobileBreakpoint) {
        const firstNewlyDetectedGroup = allGroups.find(group => group.SLUG === newlyDetectedMetricsKeys[0]);
        setActiveGroupIndex(allGroups.indexOf(firstNewlyDetectedGroup));
        setIsActive(firstNewlyDetectedGroup.SLUG);
      } else {
        setActiveGroupIndex(0);
        setIsActive(_js_components_KeyMetrics_constants__WEBPACK_IMPORTED_MODULE_1__.KEY_METRICS_GROUP_CURRENT.SLUG);
      }
    }
    if (isSelectionPanelOpenPrevious && !isSelectionPanelOpen) {
      // Reset the unstaged selection when selection panel is closed.
      resetUnstagedSelection();
    }
  }, [isSelectionPanelOpen, isSelectionPanelOpenPrevious, unstagedSelection, allGroups, isMobileBreakpoint, newlyDetectedMetricsKeys, resetUnstagedSelection]);
  (0,_js_components_KeyMetrics_hooks_useOverflowingTabs__WEBPACK_IMPORTED_MODULE_13__["default"])({
    containerRef,
    isMobileBreakpoint,
    isSelectionPanelOpen,
    isSelectionPanelOpenPrevious
  });
  const chipItemRows = [[...dynamicGroups, ...keyMetricsGroups.slice(0, 2)], [...keyMetricsGroups.slice(2)]];
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_17__.jsxs)("div", {
    className: "googlesitekit-chip-tab-group",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_17__.jsx)(_TabItems__WEBPACK_IMPORTED_MODULE_15__["default"], {
      containerRef: containerRef,
      isMobileBreakpoint: isMobileBreakpoint,
      chipItemRows: chipItemRows,
      allGroups: allGroups,
      isActive: isActive,
      onChipChange: onChipChange,
      selectedCounts: selectedCounts,
      newlyDetectedMetrics: newlyDetectedMetrics,
      activeGroupIndex: activeGroupIndex
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_17__.jsx)(_TabContent__WEBPACK_IMPORTED_MODULE_16__["default"], {
      activeMetricItems: activeMetricItems,
      newlyDetectedMetrics: newlyDetectedMetrics,
      savedItemSlugs: savedItemSlugs
    })]
  });
}

/***/ }),

/***/ "./js/components/KeyMetrics/MetricsSelectionPanel/CustomDimensionsNotice.js":
/*!**********************************************************************************!*\
  !*** ./js/components/KeyMetrics/MetricsSelectionPanel/CustomDimensionsNotice.js ***!
  \**********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_compose__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! @wordpress/compose */ "../node_modules/@wordpress/compose/build-module/hooks/use-previous/index.js");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/googlesitekit/datastore/user/constants */ "./js/googlesitekit/datastore/user/constants.js");
/* harmony import */ var _js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/modules/analytics-4/datastore/constants */ "./js/modules/analytics-4/datastore/constants.js");
/* harmony import */ var _js_modules_analytics_4_constants__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/modules/analytics-4/constants */ "./js/modules/analytics-4/constants.js");
/* harmony import */ var _js_components_KeyMetrics_constants__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/components/KeyMetrics/constants */ "./js/components/KeyMetrics/constants.js");
/* harmony import */ var _js_components_KeyMetrics_key_metrics_widgets__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @/js/components/KeyMetrics/key-metrics-widgets */ "./js/components/KeyMetrics/key-metrics-widgets.js");
/* harmony import */ var _js_util_geometry__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @/js/util/geometry */ "./js/util/geometry.js");
/* harmony import */ var _js_util_when_active__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @/js/util/when-active */ "./js/util/when-active.js");
/* harmony import */ var _js_hooks_useFormValue__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @/js/hooks/useFormValue */ "./js/hooks/useFormValue.js");
/* harmony import */ var _js_components_Typography_P__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @/js/components/Typography/P */ "./js/components/Typography/P.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Key Metrics Selection Panel Notice
 *
 * Site Kit by Google, Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */




/**
 * Internal dependencies
 */











function CustomDimensionsNotice() {
  const selectedMetrics = (0,_js_hooks_useFormValue__WEBPACK_IMPORTED_MODULE_9__["default"])(_js_components_KeyMetrics_constants__WEBPACK_IMPORTED_MODULE_5__.KEY_METRICS_SELECTION_FORM, _js_components_KeyMetrics_constants__WEBPACK_IMPORTED_MODULE_5__.KEY_METRICS_SELECTED);
  const requiredCustomDimensions = selectedMetrics?.flatMap(tileName => {
    const tile = _js_components_KeyMetrics_key_metrics_widgets__WEBPACK_IMPORTED_MODULE_6__.KEY_METRICS_WIDGETS[tileName];
    return tile?.requiredCustomDimensions || [];
  });
  const hasMissingCustomDimensions = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useInViewSelect)(select => {
    if (!requiredCustomDimensions?.length) {
      return false;
    }
    return !select(_js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_3__.MODULES_ANALYTICS_4).hasCustomDimensions(requiredCustomDimensions);
  }, [requiredCustomDimensions]);
  const hasAnalytics4EditScope = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useInViewSelect)(select => select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_2__.CORE_USER).hasScope(_js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_3__.EDIT_SCOPE));

  // This is called here to ensure that the list of available custom dimensions is
  // synced and loaded, preventing flickers of the notice.
  (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useInViewSelect)(select => select(_js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_3__.MODULES_ANALYTICS_4).getAvailableCustomDimensions());
  const previousHasMissingCustomDimensions = (0,_wordpress_compose__WEBPACK_IMPORTED_MODULE_12__["default"])(hasMissingCustomDimensions);
  const noticeRef = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_13__.useRef)();

  // Scroll the metric item being overlapped by the notice that appears
  // when the item selected (normally the last item in the panel) requires
  // custom dimension permissions.
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_13__.useEffect)(() => {
    if (hasMissingCustomDimensions && previousHasMissingCustomDimensions === false) {
      const currentFocusedElement = __webpack_require__.g.document.activeElement;
      if (currentFocusedElement && currentFocusedElement.closest('.googlesitekit-selection-panel-item') && (0,_js_util_geometry__WEBPACK_IMPORTED_MODULE_7__.elementsOverlap)(noticeRef.current, currentFocusedElement)) {
        currentFocusedElement.scrollIntoView();
      }
    }
  }, [hasMissingCustomDimensions, previousHasMissingCustomDimensions]);
  if (hasMissingCustomDimensions === false) {
    return null;
  }
  const customDimensionMessage = hasAnalytics4EditScope ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('The metrics you selected require more data tracking. We will update your Analytics property after saving your selection.', 'google-site-kit') : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('The metrics you selected require more data tracking. You will be directed to update your Analytics property after saving your selection.', 'google-site-kit');
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("div", {
    className: "googlesitekit-selection-panel-notice",
    ref: noticeRef,
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_js_components_Typography_P__WEBPACK_IMPORTED_MODULE_10__["default"], {
      children: customDimensionMessage
    })
  });
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ((0,_js_util_when_active__WEBPACK_IMPORTED_MODULE_8__["default"])({
  moduleName: _js_modules_analytics_4_constants__WEBPACK_IMPORTED_MODULE_4__.MODULE_SLUG_ANALYTICS_4
})(CustomDimensionsNotice));

/***/ }),

/***/ "./js/components/KeyMetrics/MetricsSelectionPanel/Footer.js":
/*!******************************************************************!*\
  !*** ./js/components/KeyMetrics/MetricsSelectionPanel/Footer.js ***!
  \******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Footer)
/* harmony export */ });
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! lodash */ "../node_modules/lodash/lodash.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_20___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_20__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/googlesitekit/datastore/user/constants */ "./js/googlesitekit/datastore/user/constants.js");
/* harmony import */ var _js_googlesitekit_datastore_forms_constants__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/googlesitekit/datastore/forms/constants */ "./js/googlesitekit/datastore/forms/constants.js");
/* harmony import */ var _js_googlesitekit_datastore_location_constants__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/googlesitekit/datastore/location/constants */ "./js/googlesitekit/datastore/location/constants.js");
/* harmony import */ var _js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @/js/googlesitekit/modules/datastore/constants */ "./js/googlesitekit/modules/datastore/constants.js");
/* harmony import */ var _js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @/js/googlesitekit/datastore/site/constants */ "./js/googlesitekit/datastore/site/constants.js");
/* harmony import */ var _js_components_KeyMetrics_constants__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @/js/components/KeyMetrics/constants */ "./js/components/KeyMetrics/constants.js");
/* harmony import */ var _js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @/js/modules/analytics-4/datastore/constants */ "./js/modules/analytics-4/datastore/constants.js");
/* harmony import */ var _js_modules_analytics_4_constants__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @/js/modules/analytics-4/constants */ "./js/modules/analytics-4/constants.js");
/* harmony import */ var _js_components_KeyMetrics_key_metrics_widgets__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @/js/components/KeyMetrics/key-metrics-widgets */ "./js/components/KeyMetrics/key-metrics-widgets.js");
/* harmony import */ var _js_util_errors__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! @/js/util/errors */ "./js/util/errors.js");
/* harmony import */ var _js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! @/js/hooks/useViewContext */ "./js/hooks/useViewContext.js");
/* harmony import */ var _js_googlesitekit_data_create_snapshot_store__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! @/js/googlesitekit/data/create-snapshot-store */ "./js/googlesitekit/data/create-snapshot-store.js");
/* harmony import */ var _js_util__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! @/js/util */ "./js/util/index.js");
/* harmony import */ var _SelectionPanelFooter__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ./SelectionPanelFooter */ "./js/components/KeyMetrics/MetricsSelectionPanel/SelectionPanelFooter.js");
/* harmony import */ var _js_hooks_useFormValue__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! @/js/hooks/useFormValue */ "./js/hooks/useFormValue.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Key Metrics Selection Panel Footer
 *
 * Site Kit by Google, Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */

















function Footer({
  isOpen,
  closePanel = lodash__WEBPACK_IMPORTED_MODULE_0__.noop,
  savedMetrics,
  onNavigationToOAuthURL = () => {},
  isFullScreen = false
}) {
  const registry = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.useRegistry)();
  const viewContext = (0,_js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_13__["default"])();
  const selectedMetrics = (0,_js_hooks_useFormValue__WEBPACK_IMPORTED_MODULE_17__["default"])(_js_components_KeyMetrics_constants__WEBPACK_IMPORTED_MODULE_8__.KEY_METRICS_SELECTION_FORM, _js_components_KeyMetrics_constants__WEBPACK_IMPORTED_MODULE_8__.KEY_METRICS_SELECTED);
  const isSavingSettings = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.useSelect)(select => select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_USER).isSavingKeyMetricsSettings());
  const trackingCategory = `${viewContext}_kmw-sidebar`;
  const requiredCustomDimensions = selectedMetrics?.flatMap(tileName => {
    const tile = _js_components_KeyMetrics_key_metrics_widgets__WEBPACK_IMPORTED_MODULE_11__.KEY_METRICS_WIDGETS[tileName];
    return tile?.requiredCustomDimensions || [];
  });
  const hasMissingCustomDimensions = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.useInViewSelect)(select => {
    if (!requiredCustomDimensions?.length) {
      return false;
    }
    const hasCustomDimensions = select(_js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_9__.MODULES_ANALYTICS_4).hasCustomDimensions(requiredCustomDimensions);
    return !hasCustomDimensions;
  }, [requiredCustomDimensions]);
  const hasAnalytics4EditScope = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.useInViewSelect)(select => select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_USER).hasScope(_js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_9__.EDIT_SCOPE));
  const isGA4Connected = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.useSelect)(select => select(_js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_6__.CORE_MODULES).isModuleConnected(_js_modules_analytics_4_constants__WEBPACK_IMPORTED_MODULE_10__.MODULE_SLUG_ANALYTICS_4));

  // The `custom_dimensions` query value is arbitrary and serves two purposes:
  // 1. To ensure that `authentication_success` isn't appended when returning from OAuth.
  // 2. To guarantee it doesn't match any existing notifications in the `BannerNotifications` component, thus preventing any unintended displays.
  const redirectURL = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.useSelect)(select => select(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_7__.CORE_SITE).getAdminURL('googlesitekit-dashboard', {
    notification: 'custom_dimensions'
  }));
  const isNavigatingToOAuthURL = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.useSelect)(select => {
    const OAuthURL = select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_USER).getConnectURL({
      additionalScopes: [_js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_9__.EDIT_SCOPE],
      redirectURL
    });
    if (!OAuthURL) {
      return false;
    }
    return select(_js_googlesitekit_datastore_location_constants__WEBPACK_IMPORTED_MODULE_5__.CORE_LOCATION).isNavigatingTo(OAuthURL);
  });
  const mainDashboardURL = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.useSelect)(select => select(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_7__.CORE_SITE).getAdminURL('googlesitekit-dashboard'));
  const isNavigatingToMainDashboard = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.useSelect)(select => {
    return !!mainDashboardURL && select(_js_googlesitekit_datastore_location_constants__WEBPACK_IMPORTED_MODULE_5__.CORE_LOCATION).isNavigatingTo(mainDashboardURL);
  });
  const {
    saveKeyMetricsSettings,
    setPermissionScopeError
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.useDispatch)(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_USER);
  const {
    setValues
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.useDispatch)(_js_googlesitekit_datastore_forms_constants__WEBPACK_IMPORTED_MODULE_4__.CORE_FORMS);
  const {
    navigateTo
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.useDispatch)(_js_googlesitekit_datastore_location_constants__WEBPACK_IMPORTED_MODULE_5__.CORE_LOCATION);
  const conversionReportingSpecificKeyMetricsWidgets = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.useSelect)(select => select(_js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_9__.MODULES_ANALYTICS_4).getKeyMetricsConversionEventWidgets());
  const saveSettings = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_19__.useCallback)(async widgetSlugs => {
    // We could simply return the value of `saveKeyMetricsSettings()` here,
    // but this makes the expected return value more explicit.
    const {
      error
    } = await saveKeyMetricsSettings({
      widgetSlugs
    });
    return {
      error
    };
  }, [saveKeyMetricsSettings]);
  const onSaveSuccess = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_19__.useCallback)(async selectedItemSlugs => {
    const userSavedConversionReportingKeyMetricsList = Object.values(conversionReportingSpecificKeyMetricsWidgets).flat().some(slug => selectedItemSlugs.includes(slug));

    // Include the conversion_reporting tracking label if necessary.
    if (userSavedConversionReportingKeyMetricsList) {
      (0,_js_util__WEBPACK_IMPORTED_MODULE_15__.trackEvent)(trackingCategory, 'metrics_sidebar_save', 'conversion_reporting');
    } else {
      (0,_js_util__WEBPACK_IMPORTED_MODULE_15__.trackEvent)(trackingCategory, 'metrics_sidebar_save');
    }
    if (isGA4Connected && hasMissingCustomDimensions) {
      setValues(_js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_9__.FORM_CUSTOM_DIMENSIONS_CREATE, {
        autoSubmit: true
      });
      if (!hasAnalytics4EditScope) {
        // Let parent component know that the user is navigating to OAuth URL
        // so that the panel is kept open.
        onNavigationToOAuthURL();

        // Ensure the panel is closed, just in case the user navigates to
        // the OAuth URL before the function is fully executed.
        closePanel();
        setPermissionScopeError({
          code: _js_util_errors__WEBPACK_IMPORTED_MODULE_12__.ERROR_CODE_MISSING_REQUIRED_SCOPE,
          message: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Additional permissions are required to create new Analytics custom dimensions', 'google-site-kit'),
          data: {
            status: 403,
            scopes: [_js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_9__.EDIT_SCOPE],
            skipModal: true,
            redirectURL
          }
        });
        return;
      }

      // Snapshot `CORE_FORMS` store to ensure the form data is retained
      // across page navigations.
      if (isFullScreen) {
        await (0,_js_googlesitekit_data_create_snapshot_store__WEBPACK_IMPORTED_MODULE_14__.snapshotAllStores)(registry);
      }
    }

    // In the full screen app, navigate to the dashboard after saving.
    if (isFullScreen) {
      navigateTo(mainDashboardURL);
    }
  }, [conversionReportingSpecificKeyMetricsWidgets, isGA4Connected, hasMissingCustomDimensions, isFullScreen, trackingCategory, setValues, hasAnalytics4EditScope, onNavigationToOAuthURL, closePanel, setPermissionScopeError, redirectURL, registry, navigateTo, mainDashboardURL]);
  const onCancel = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_19__.useCallback)(() => {
    (0,_js_util__WEBPACK_IMPORTED_MODULE_15__.trackEvent)(trackingCategory, 'metrics_sidebar_cancel');

    // In the full screen app, navigate to the dashboard after canceling.
    if (isFullScreen) {
      navigateTo(mainDashboardURL);
    }
  }, [isFullScreen, mainDashboardURL, navigateTo, trackingCategory]);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx)(_SelectionPanelFooter__WEBPACK_IMPORTED_MODULE_16__["default"], {
    savedItemSlugs: savedMetrics,
    selectedItemSlugs: selectedMetrics,
    saveSettings: saveSettings,
    minSelectedItemCount: _js_components_KeyMetrics_constants__WEBPACK_IMPORTED_MODULE_8__.MIN_SELECTED_METRICS_COUNT,
    maxSelectedItemCount: _js_components_KeyMetrics_constants__WEBPACK_IMPORTED_MODULE_8__.MAX_SELECTED_METRICS_COUNT,
    isBusy: isSavingSettings || isNavigatingToOAuthURL || isNavigatingToMainDashboard && isFullScreen,
    onSaveSuccess: () => {
      onSaveSuccess(selectedMetrics);
    },
    onCancel: onCancel,
    isOpen: isOpen,
    closePanel: closePanel,
    isFullScreen: isFullScreen
  });
}
Footer.propTypes = {
  isOpen: (prop_types__WEBPACK_IMPORTED_MODULE_20___default().bool),
  closePanel: (prop_types__WEBPACK_IMPORTED_MODULE_20___default().func),
  savedMetrics: (prop_types__WEBPACK_IMPORTED_MODULE_20___default().array),
  onNavigationToOAuthURL: (prop_types__WEBPACK_IMPORTED_MODULE_20___default().func),
  isFullScreen: (prop_types__WEBPACK_IMPORTED_MODULE_20___default().bool)
};

/***/ }),

/***/ "./js/components/KeyMetrics/MetricsSelectionPanel/Header.js":
/*!******************************************************************!*\
  !*** ./js/components/KeyMetrics/MetricsSelectionPanel/Header.js ***!
  \******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Header)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_13___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_13__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/@wordpress/element/build-module/create-interpolate-element.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _js_googlesitekit_datastore_location_constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/googlesitekit/datastore/location/constants */ "./js/googlesitekit/datastore/location/constants.js");
/* harmony import */ var _js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/googlesitekit/datastore/site/constants */ "./js/googlesitekit/datastore/site/constants.js");
/* harmony import */ var _js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/googlesitekit/datastore/user/constants */ "./js/googlesitekit/datastore/user/constants.js");
/* harmony import */ var _js_components_KeyMetrics_constants__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/components/KeyMetrics/constants */ "./js/components/KeyMetrics/constants.js");
/* harmony import */ var _js_components_Link__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @/js/components/Link */ "./js/components/Link.js");
/* harmony import */ var _js_components_SelectionPanel__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @/js/components/SelectionPanel */ "./js/components/SelectionPanel/index.js");
/* harmony import */ var _js_hooks_useViewOnly__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @/js/hooks/useViewOnly */ "./js/hooks/useViewOnly.js");
/* harmony import */ var _js_components_Typography_P__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @/js/components/Typography/P */ "./js/components/Typography/P.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Key Metrics Selection Panel Header
 *
 * Site Kit by Google, Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */










function Header({
  closePanel
}) {
  const isViewOnly = (0,_js_hooks_useViewOnly__WEBPACK_IMPORTED_MODULE_8__["default"])();
  const adminSettingsURL = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_SITE).getSiteKitAdminSettingsURL());
  const isSavingSettings = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_4__.CORE_USER).isSavingKeyMetricsSettings());
  const {
    navigateTo
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useDispatch)(_js_googlesitekit_datastore_location_constants__WEBPACK_IMPORTED_MODULE_2__.CORE_LOCATION);
  const onSettingsClick = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_11__.useCallback)(() => navigateTo(adminSettingsURL), [adminSettingsURL, navigateTo]);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)(_js_components_SelectionPanel__WEBPACK_IMPORTED_MODULE_7__.SelectionPanelHeader, {
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.sprintf)(/* translators: %d: number of max allowed metrics */
    (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Select up to %d metrics', 'google-site-kit'), _js_components_KeyMetrics_constants__WEBPACK_IMPORTED_MODULE_5__.MAX_SELECTED_METRICS_COUNT),
    onCloseClick: closePanel,
    children: !isViewOnly && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)(_js_components_Typography_P__WEBPACK_IMPORTED_MODULE_9__["default"], {
      children: (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_12__["default"])((0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Edit your personalized goals or deactivate this widget in <link><strong>Settings</strong></link>', 'google-site-kit'), {
        link: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)(_js_components_Link__WEBPACK_IMPORTED_MODULE_6__["default"], {
          onClick: onSettingsClick,
          disabled: isSavingSettings,
          secondary: true
        }),
        strong: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)("strong", {})
      })
    })
  });
}
Header.propTypes = {
  closePanel: (prop_types__WEBPACK_IMPORTED_MODULE_13___default().func).isRequired
};

/***/ }),

/***/ "./js/components/KeyMetrics/MetricsSelectionPanel/KeyMetricsError.js":
/*!***************************************************************************!*\
  !*** ./js/components/KeyMetrics/MetricsSelectionPanel/KeyMetricsError.js ***!
  \***************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! lodash */ "../node_modules/lodash/lodash.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/googlesitekit/datastore/user/constants */ "./js/googlesitekit/datastore/user/constants.js");
/* harmony import */ var _js_components_KeyMetrics_constants__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/components/KeyMetrics/constants */ "./js/components/KeyMetrics/constants.js");
/* harmony import */ var _js_modules_analytics_4_constants__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/modules/analytics-4/constants */ "./js/modules/analytics-4/constants.js");
/* harmony import */ var _js_components_SelectionPanel_SelectionPanelError__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @/js/components/SelectionPanel/SelectionPanelError */ "./js/components/SelectionPanel/SelectionPanelError.js");
/* harmony import */ var _js_util__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @/js/util */ "./js/util/index.js");
/* harmony import */ var _js_util_when_active__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @/js/util/when-active */ "./js/util/when-active.js");
/* harmony import */ var _js_hooks_useFormValue__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @/js/hooks/useFormValue */ "./js/hooks/useFormValue.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Key Metrics Selection Panel Error
 *
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */









function KeyMetricsError({
  savedMetrics
}) {
  const selectedMetrics = (0,_js_hooks_useFormValue__WEBPACK_IMPORTED_MODULE_9__["default"])(_js_components_KeyMetrics_constants__WEBPACK_IMPORTED_MODULE_4__.KEY_METRICS_SELECTION_FORM, _js_components_KeyMetrics_constants__WEBPACK_IMPORTED_MODULE_4__.KEY_METRICS_SELECTED);
  const keyMetricsSettings = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.useInViewSelect)(select => select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_USER).getKeyMetricsSettings());
  const haveSettingsChanged = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_11__.useMemo)(() => {
    // Arrays need to be sorted to match in `isEqual`.
    return !(0,lodash__WEBPACK_IMPORTED_MODULE_0__.isEqual)((0,_js_util__WEBPACK_IMPORTED_MODULE_7__.safelySort)(selectedMetrics), (0,_js_util__WEBPACK_IMPORTED_MODULE_7__.safelySort)(savedMetrics));
  }, [savedMetrics, selectedMetrics]);
  const saveError = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.useSelect)(select => select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_USER).getErrorForAction('saveKeyMetricsSettings', [{
    ...keyMetricsSettings,
    widgetSlugs: selectedMetrics
  }]));
  const selectedMetricsCount = selectedMetrics?.length || 0;
  let metricsLimitError;
  if (selectedMetricsCount < _js_components_KeyMetrics_constants__WEBPACK_IMPORTED_MODULE_4__.MIN_SELECTED_METRICS_COUNT) {
    metricsLimitError = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.sprintf)(/* translators: 1: Minimum number of metrics that can be selected. 2: Number of selected metrics. */
    (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Select at least %1$d metrics (%2$d selected)', 'google-site-kit'), _js_components_KeyMetrics_constants__WEBPACK_IMPORTED_MODULE_4__.MIN_SELECTED_METRICS_COUNT, selectedMetricsCount);
  } else if (selectedMetricsCount > _js_components_KeyMetrics_constants__WEBPACK_IMPORTED_MODULE_4__.MAX_SELECTED_METRICS_COUNT) {
    metricsLimitError = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.sprintf)(/* translators: 1: Maximum number of metrics that can be selected. 2: Number of selected metrics. */
    (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Select up to %1$d metrics (%2$d selected)', 'google-site-kit'), _js_components_KeyMetrics_constants__WEBPACK_IMPORTED_MODULE_4__.MAX_SELECTED_METRICS_COUNT, selectedMetricsCount);
  }
  let error = saveError;
  if (haveSettingsChanged && metricsLimitError) {
    error = {
      message: metricsLimitError
    };
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)(_js_components_SelectionPanel_SelectionPanelError__WEBPACK_IMPORTED_MODULE_6__["default"], {
    error: error,
    skipRetryMessage: !!metricsLimitError
  });
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ((0,_js_util_when_active__WEBPACK_IMPORTED_MODULE_8__["default"])({
  moduleName: _js_modules_analytics_4_constants__WEBPACK_IMPORTED_MODULE_5__.MODULE_SLUG_ANALYTICS_4
})(KeyMetricsError));

/***/ }),

/***/ "./js/components/KeyMetrics/MetricsSelectionPanel/MetricItem.js":
/*!**********************************************************************!*\
  !*** ./js/components/KeyMetrics/MetricsSelectionPanel/MetricItem.js ***!
  \**********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ MetricItem)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_10__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _js_googlesitekit_datastore_forms_constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/googlesitekit/datastore/forms/constants */ "./js/googlesitekit/datastore/forms/constants.js");
/* harmony import */ var _js_googlesitekit_widgets_datastore_constants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/googlesitekit/widgets/datastore/constants */ "./js/googlesitekit/widgets/datastore/constants.js");
/* harmony import */ var _js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/googlesitekit/modules/datastore/constants */ "./js/googlesitekit/modules/datastore/constants.js");
/* harmony import */ var _js_components_KeyMetrics_constants__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/components/KeyMetrics/constants */ "./js/components/KeyMetrics/constants.js");
/* harmony import */ var _js_components_SelectionPanel__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @/js/components/SelectionPanel */ "./js/components/SelectionPanel/index.js");
/* harmony import */ var _js_hooks_useFormValue__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @/js/hooks/useFormValue */ "./js/hooks/useFormValue.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Key Metrics Selection Panel MetricItem
 *
 * Site Kit by Google, Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */








function MetricItem({
  slug,
  title,
  description,
  isNewlyDetected,
  savedItemSlugs = []
}) {
  const disconnectedModules = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => {
    const {
      getModule
    } = select(_js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_4__.CORE_MODULES);
    const widget = select(_js_googlesitekit_widgets_datastore_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_WIDGETS).getWidget(slug);
    return widget?.modules.reduce((modulesAcc, widgetSlug) => {
      const module = getModule(widgetSlug);
      if (module?.connected || !module?.name) {
        return modulesAcc;
      }
      return [...modulesAcc, module.name];
    }, []);
  });
  const selectedMetrics = (0,_js_hooks_useFormValue__WEBPACK_IMPORTED_MODULE_7__["default"])(_js_components_KeyMetrics_constants__WEBPACK_IMPORTED_MODULE_5__.KEY_METRICS_SELECTION_FORM, _js_components_KeyMetrics_constants__WEBPACK_IMPORTED_MODULE_5__.KEY_METRICS_SELECTED);
  const {
    getValue
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_datastore_forms_constants__WEBPACK_IMPORTED_MODULE_2__.CORE_FORMS));
  const {
    setValues
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useDispatch)(_js_googlesitekit_datastore_forms_constants__WEBPACK_IMPORTED_MODULE_2__.CORE_FORMS);
  const onCheckboxChange = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.useCallback)(event => {
    const metrics = getValue(_js_components_KeyMetrics_constants__WEBPACK_IMPORTED_MODULE_5__.KEY_METRICS_SELECTION_FORM, _js_components_KeyMetrics_constants__WEBPACK_IMPORTED_MODULE_5__.KEY_METRICS_SELECTED);
    const currentlySelectedMetrics = event.target.checked ? metrics.concat([slug]) : metrics.filter(selectedMetric => selectedMetric !== slug);
    setValues(_js_components_KeyMetrics_constants__WEBPACK_IMPORTED_MODULE_5__.KEY_METRICS_SELECTION_FORM, {
      [_js_components_KeyMetrics_constants__WEBPACK_IMPORTED_MODULE_5__.KEY_METRICS_SELECTED]: currentlySelectedMetrics,
      // Unstaged list creates a copy of KM selected list, but unstaged
      // is stored temporary to collect the final selection that will
      // be transfered over to effective selection on tab change and then it is reset.
      [_js_components_KeyMetrics_constants__WEBPACK_IMPORTED_MODULE_5__.UNSTAGED_SELECTION]: currentlySelectedMetrics
    });
  }, [getValue, setValues, slug]);
  const isMetricSelected = selectedMetrics?.includes(slug);
  const isMetricDisabled = !savedItemSlugs.includes(slug) && disconnectedModules.length > 0;
  const id = `key-metric-selection-checkbox-${slug}`;
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(_js_components_SelectionPanel__WEBPACK_IMPORTED_MODULE_6__.SelectionPanelItem, {
    id: id,
    slug: slug,
    title: title,
    description: description,
    isNewlyDetected: isNewlyDetected,
    isItemSelected: isMetricSelected,
    isItemDisabled: isMetricDisabled,
    onCheckboxChange: onCheckboxChange,
    children: disconnectedModules.length > 0 && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)("div", {
      className: "googlesitekit-selection-panel-item-error",
      children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.sprintf)(/* translators: %s: module names. */
      (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__._n)('%s is disconnected, no data to show', '%s are disconnected, no data to show', disconnectedModules.length, 'google-site-kit'), disconnectedModules.join((0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)(' and ', 'google-site-kit')))
    })
  });
}
MetricItem.propTypes = {
  slug: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().string).isRequired,
  title: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().string).isRequired,
  description: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().string).isRequired,
  isNewlyDetected: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().bool),
  savedItemSlugs: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().array)
};

/***/ }),

/***/ "./js/components/KeyMetrics/MetricsSelectionPanel/MetricItems.js":
/*!***********************************************************************!*\
  !*** ./js/components/KeyMetrics/MetricsSelectionPanel/MetricItems.js ***!
  \***********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ MetricItems)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/googlesitekit/datastore/user/constants */ "./js/googlesitekit/datastore/user/constants.js");
/* harmony import */ var _js_components_KeyMetrics_key_metrics_widgets__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/components/KeyMetrics/key-metrics-widgets */ "./js/components/KeyMetrics/key-metrics-widgets.js");
/* harmony import */ var _js_hooks_useViewOnly__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/hooks/useViewOnly */ "./js/hooks/useViewOnly.js");
/* harmony import */ var _SelectionPanelItems__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./SelectionPanelItems */ "./js/components/KeyMetrics/MetricsSelectionPanel/SelectionPanelItems.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Key Metrics Selection Panel Metrics Listing
 *
 * Site Kit by Google, Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * Internal dependencies
 */






function MetricItems({
  savedMetrics
}) {
  const isViewOnlyDashboard = (0,_js_hooks_useViewOnly__WEBPACK_IMPORTED_MODULE_3__["default"])();
  const {
    isKeyMetricAvailable
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useSelect)(select => select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_1__.CORE_USER));
  const displayInSelectionPanel = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useInViewSelect)(select => {
    return metric => _js_components_KeyMetrics_key_metrics_widgets__WEBPACK_IMPORTED_MODULE_2__.KEY_METRICS_WIDGETS[metric].displayInSelectionPanel({
      select,
      isViewOnlyDashboard,
      slug: metric
    });
  }, [isViewOnlyDashboard]);
  function metricsListReducer(acc, metricSlug) {
    if (!isKeyMetricAvailable(metricSlug)) {
      return acc;
    }
    if (displayInSelectionPanel === undefined || typeof _js_components_KeyMetrics_key_metrics_widgets__WEBPACK_IMPORTED_MODULE_2__.KEY_METRICS_WIDGETS[metricSlug].displayInSelectionPanel === 'function' && !displayInSelectionPanel(metricSlug)) {
      return acc;
    }
    const {
      title,
      description,
      metadata: {
        group
      }
    } = _js_components_KeyMetrics_key_metrics_widgets__WEBPACK_IMPORTED_MODULE_2__.KEY_METRICS_WIDGETS[metricSlug];
    return {
      ...acc,
      [metricSlug]: {
        title,
        description,
        group
      }
    };
  }
  const allMetricItems = Object.keys(_js_components_KeyMetrics_key_metrics_widgets__WEBPACK_IMPORTED_MODULE_2__.KEY_METRICS_WIDGETS).reduce(metricsListReducer, {});
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_SelectionPanelItems__WEBPACK_IMPORTED_MODULE_4__["default"], {
    savedItemSlugs: savedMetrics,
    allMetricItems: allMetricItems
  });
}
MetricItems.propTypes = {
  savedMetrics: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().array)
};

/***/ }),

/***/ "./js/components/KeyMetrics/MetricsSelectionPanel/Panel.js":
/*!*****************************************************************!*\
  !*** ./js/components/KeyMetrics/MetricsSelectionPanel/Panel.js ***!
  \*****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Panel)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _js_googlesitekit_datastore_forms_constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/googlesitekit/datastore/forms/constants */ "./js/googlesitekit/datastore/forms/constants.js");
/* harmony import */ var _js_googlesitekit_datastore_ui_constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/googlesitekit/datastore/ui/constants */ "./js/googlesitekit/datastore/ui/constants.js");
/* harmony import */ var _js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/googlesitekit/datastore/user/constants */ "./js/googlesitekit/datastore/user/constants.js");
/* harmony import */ var _js_components_KeyMetrics_constants__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/components/KeyMetrics/constants */ "./js/components/KeyMetrics/constants.js");
/* harmony import */ var _PanelContent__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./PanelContent */ "./js/components/KeyMetrics/MetricsSelectionPanel/PanelContent.js");
/* harmony import */ var _js_components_SelectionPanel__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @/js/components/SelectionPanel */ "./js/components/SelectionPanel/index.js");
/* harmony import */ var _js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @/js/hooks/useViewContext */ "./js/hooks/useViewContext.js");
/* harmony import */ var _js_util__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @/js/util */ "./js/util/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Selection Panel
 *
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */










function Panel() {
  const viewContext = (0,_js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_7__["default"])();
  const isOpen = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useSelect)(select => select(_js_googlesitekit_datastore_ui_constants__WEBPACK_IMPORTED_MODULE_2__.CORE_UI).getValue(_js_components_KeyMetrics_constants__WEBPACK_IMPORTED_MODULE_4__.KEY_METRICS_SELECTION_PANEL_OPENED_KEY));
  const savedViewableMetrics = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useInViewSelect)(select => {
    const metrics = select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_USER).getKeyMetrics();
    if (!Array.isArray(metrics)) {
      return [];
    }
    const {
      isKeyMetricAvailable
    } = select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_USER);
    return metrics.filter(isKeyMetricAvailable);
  });
  const {
    setValues
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useDispatch)(_js_googlesitekit_datastore_forms_constants__WEBPACK_IMPORTED_MODULE_1__.CORE_FORMS);
  const {
    setValue
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useDispatch)(_js_googlesitekit_datastore_ui_constants__WEBPACK_IMPORTED_MODULE_2__.CORE_UI);
  const onSideSheetOpen = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_10__.useCallback)(() => {
    setValues(_js_components_KeyMetrics_constants__WEBPACK_IMPORTED_MODULE_4__.KEY_METRICS_SELECTION_FORM, {
      [_js_components_KeyMetrics_constants__WEBPACK_IMPORTED_MODULE_4__.KEY_METRICS_SELECTED]: savedViewableMetrics,
      [_js_components_KeyMetrics_constants__WEBPACK_IMPORTED_MODULE_4__.EFFECTIVE_SELECTION]: savedViewableMetrics
    });
    (0,_js_util__WEBPACK_IMPORTED_MODULE_8__.trackEvent)(`${viewContext}_kmw-sidebar`, 'metrics_sidebar_view');
  }, [savedViewableMetrics, setValues, viewContext]);
  const closePanel = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_10__.useCallback)(() => {
    if (isOpen) {
      setValue(_js_components_KeyMetrics_constants__WEBPACK_IMPORTED_MODULE_4__.KEY_METRICS_SELECTION_PANEL_OPENED_KEY, false);
    }
  }, [setValue, isOpen]);
  const [isNavigatingToOAuthURL, setIsNavigatingToOAuthURL] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_10__.useState)(false);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)(_js_components_SelectionPanel__WEBPACK_IMPORTED_MODULE_6__["default"], {
    isOpen: isOpen || isNavigatingToOAuthURL,
    onOpen: onSideSheetOpen,
    closePanel: closePanel,
    className: "googlesitekit-km-selection-panel googlesitekit-acr-km-selection-panel",
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)(_PanelContent__WEBPACK_IMPORTED_MODULE_5__["default"], {
      isOpen: isOpen,
      closePanel: closePanel,
      savedViewableMetrics: savedViewableMetrics,
      setIsNavigatingToOAuthURL: setIsNavigatingToOAuthURL
    })
  });
}

/***/ }),

/***/ "./js/components/KeyMetrics/MetricsSelectionPanel/PanelContent.js":
/*!************************************************************************!*\
  !*** ./js/components/KeyMetrics/MetricsSelectionPanel/PanelContent.js ***!
  \************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ PanelContent)
/* harmony export */ });
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! lodash */ "../node_modules/lodash/lodash.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _CustomDimensionsNotice__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./CustomDimensionsNotice */ "./js/components/KeyMetrics/MetricsSelectionPanel/CustomDimensionsNotice.js");
/* harmony import */ var _Header__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./Header */ "./js/components/KeyMetrics/MetricsSelectionPanel/Header.js");
/* harmony import */ var _Footer__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./Footer */ "./js/components/KeyMetrics/MetricsSelectionPanel/Footer.js");
/* harmony import */ var _MetricItems__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./MetricItems */ "./js/components/KeyMetrics/MetricsSelectionPanel/MetricItems.js");
/* harmony import */ var _KeyMetricsError__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./KeyMetricsError */ "./js/components/KeyMetrics/MetricsSelectionPanel/KeyMetricsError.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Selection Panel Content
 *
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */




/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */






function PanelContent({
  isOpen = false,
  closePanel,
  savedViewableMetrics,
  showHeader = true,
  setIsNavigatingToOAuthURL = lodash__WEBPACK_IMPORTED_MODULE_1__.noop,
  isFullScreen = false
}) {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsxs)(_wordpress_element__WEBPACK_IMPORTED_MODULE_8__.Fragment, {
    children: [showHeader && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_Header__WEBPACK_IMPORTED_MODULE_3__["default"], {
      closePanel: closePanel
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_MetricItems__WEBPACK_IMPORTED_MODULE_5__["default"], {
      savedMetrics: savedViewableMetrics
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_CustomDimensionsNotice__WEBPACK_IMPORTED_MODULE_2__["default"], {}), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsxs)("div", {
      className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-user-input__footer-container', {
        'googlesitekit-user-input__footer-container--fullscreen': isFullScreen
      }),
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_KeyMetricsError__WEBPACK_IMPORTED_MODULE_6__["default"], {
        savedMetrics: savedViewableMetrics
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_Footer__WEBPACK_IMPORTED_MODULE_4__["default"], {
        isOpen: isOpen,
        closePanel: closePanel,
        savedMetrics: savedViewableMetrics,
        onNavigationToOAuthURL: () => {
          setIsNavigatingToOAuthURL(true);
        },
        isFullScreen: isFullScreen
      })]
    })]
  });
}
PanelContent.propTypes = {
  isOpen: (prop_types__WEBPACK_IMPORTED_MODULE_9___default().bool),
  closePanel: (prop_types__WEBPACK_IMPORTED_MODULE_9___default().func),
  savedViewableMetrics: (prop_types__WEBPACK_IMPORTED_MODULE_9___default().array),
  showHeader: (prop_types__WEBPACK_IMPORTED_MODULE_9___default().bool),
  setIsNavigatingToOAuthURL: (prop_types__WEBPACK_IMPORTED_MODULE_9___default().func),
  isFullScreen: (prop_types__WEBPACK_IMPORTED_MODULE_9___default().bool)
};

/***/ }),

/***/ "./js/components/KeyMetrics/MetricsSelectionPanel/SelectionPanelFooter.js":
/*!********************************************************************************!*\
  !*** ./js/components/KeyMetrics/MetricsSelectionPanel/SelectionPanelFooter.js ***!
  \********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ SelectionPanelFooter)
/* harmony export */ });
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! lodash */ "../node_modules/lodash/lodash.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_10__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/@wordpress/element/build-module/create-interpolate-element.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! googlesitekit-components */ "googlesitekit-components");
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_components__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _js_util__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/util */ "./js/util/index.js");
/* harmony import */ var _js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/modules/analytics-4/datastore/constants */ "./js/modules/analytics-4/datastore/constants.js");
/* harmony import */ var _js_components_PreviewBlock__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @/js/components/PreviewBlock */ "./js/components/PreviewBlock.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Selection Panel Footer component.
 *
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */






function SelectionPanelFooter({
  savedItemSlugs = [],
  selectedItemSlugs = [],
  saveSettings = () => {},
  minSelectedItemCount = 0,
  maxSelectedItemCount = 0,
  isBusy,
  onSaveSuccess = () => {},
  onCancel = () => {},
  isOpen,
  closePanel = () => {},
  isFullScreen = false
}) {
  const [finalButtonText, setFinalButtonText] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_8__.useState)(null);
  const [wasSaved, setWasSaved] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_8__.useState)(false);
  const isLoading = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.useSelect)(select => select(_js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_5__.MODULES_ANALYTICS_4).isFetchingSyncAvailableAudiences());
  const haveSettingsChanged = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_8__.useMemo)(() => {
    // Arrays need to be sorted to match in `isEqual`.
    return !(0,lodash__WEBPACK_IMPORTED_MODULE_0__.isEqual)((0,_js_util__WEBPACK_IMPORTED_MODULE_4__.safelySort)(selectedItemSlugs), (0,_js_util__WEBPACK_IMPORTED_MODULE_4__.safelySort)(savedItemSlugs));
  }, [savedItemSlugs, selectedItemSlugs]);
  let currentButtonText = savedItemSlugs?.length > 0 && haveSettingsChanged ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Apply changes', 'google-site-kit') : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Save selection', 'google-site-kit');
  if (isFullScreen) {
    currentButtonText = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Complete setup', 'google-site-kit');
  }
  const onSaveClick = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_8__.useCallback)(async () => {
    const {
      error
    } = await saveSettings(selectedItemSlugs);
    if (!error) {
      onSaveSuccess();

      // Close the panel after saving.
      closePanel();
      if (!isFullScreen) {
        // Lock the button label while panel is closing.
        setFinalButtonText(currentButtonText);
        setWasSaved(true);
      }
    }
  }, [saveSettings, selectedItemSlugs, onSaveSuccess, closePanel, isFullScreen, currentButtonText]);
  const onCancelClick = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_8__.useCallback)(() => {
    closePanel();
    onCancel();
  }, [closePanel, onCancel]);
  const [prevIsOpen, setPrevIsOpen] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_8__.useState)(null);
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_8__.useEffect)(() => {
    if (prevIsOpen !== null) {
      // If current isOpen is true, and different from prevIsOpen
      // meaning it transitioned from false to true and it is not
      // in closing transition, we should reset the button label
      // locked when save button was clicked.
      if (prevIsOpen !== isOpen) {
        if (isOpen) {
          setFinalButtonText(null);
          setWasSaved(false);
        }
      }
    }
    setPrevIsOpen(isOpen);
  }, [isOpen, prevIsOpen]);
  const selectedItemCount = selectedItemSlugs?.length || 0;
  const itemCountElement = isLoading ? /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_js_components_PreviewBlock__WEBPACK_IMPORTED_MODULE_6__["default"], {
    width: "89px",
    height: "20px"
  }) : /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)("p", {
    className: "googlesitekit-selection-panel-footer__item-count",
    children: (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__["default"])((0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.sprintf)(/* translators: 1: Number of selected items. 2: Maximum number of items that can be selected. */
    (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('%1$d selected <MaxCount>(up to %2$d)</MaxCount>', 'google-site-kit'), selectedItemCount, maxSelectedItemCount), {
      MaxCount: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)("span", {
        className: "googlesitekit-selection-panel-footer__item-count--max-count"
      })
    })
  });
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)("footer", {
    className: "googlesitekit-selection-panel-footer",
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)("div", {
      className: "googlesitekit-selection-panel-footer__content",
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsxs)("div", {
        className: "googlesitekit-selection-panel-footer__actions",
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_3__.Button, {
          onClick: onCancelClick,
          disabled: isBusy,
          tertiary: true,
          children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Cancel', 'google-site-kit')
        }), itemCountElement, /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_3__.SpinnerButton, {
          onClick: onSaveClick,
          isSaving: isBusy,
          disabled: selectedItemCount < minSelectedItemCount || selectedItemCount > maxSelectedItemCount || isBusy || !isOpen && wasSaved,
          children: finalButtonText || currentButtonText
        })]
      })
    })
  });
}
SelectionPanelFooter.propTypes = {
  savedItemSlugs: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().array),
  selectedItemSlugs: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().array),
  saveSettings: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().func),
  saveError: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().object),
  itemLimitError: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().string),
  minSelectedItemCount: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().number),
  maxSelectedItemCount: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().number),
  isBusy: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().bool),
  onSaveSuccess: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().func),
  onCancel: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().func),
  isOpen: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().bool),
  closePanel: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().func),
  isFullScreen: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().bool)
};

/***/ }),

/***/ "./js/components/KeyMetrics/MetricsSelectionPanel/SelectionPanelItems.js":
/*!*******************************************************************************!*\
  !*** ./js/components/KeyMetrics/MetricsSelectionPanel/SelectionPanelItems.js ***!
  \*******************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ SelectionPanelItems)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _js_components_KeyMetrics_ChipTabGroup__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @/js/components/KeyMetrics/ChipTabGroup */ "./js/components/KeyMetrics/ChipTabGroup/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Selection Panel Items component.
 *
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * Internal dependencies
 */


function SelectionPanelItems({
  savedItemSlugs = [],
  allMetricItems
}) {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", {
    className: "googlesitekit-selection-panel-items",
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)(_js_components_KeyMetrics_ChipTabGroup__WEBPACK_IMPORTED_MODULE_0__["default"], {
      savedItemSlugs: savedItemSlugs,
      allMetricItems: allMetricItems
    })
  });
}
SelectionPanelItems.propTypes = {
  savedItemSlugs: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().array),
  allMetricItems: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().object).isRequired
};

/***/ }),

/***/ "./js/components/KeyMetrics/MetricsSelectionPanel/index.js":
/*!*****************************************************************!*\
  !*** ./js/components/KeyMetrics/MetricsSelectionPanel/index.js ***!
  \*****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ MetricsSelectionPanel)
/* harmony export */ });
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _js_googlesitekit_datastore_ui_constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/googlesitekit/datastore/ui/constants */ "./js/googlesitekit/datastore/ui/constants.js");
/* harmony import */ var _js_components_KeyMetrics_constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/components/KeyMetrics/constants */ "./js/components/KeyMetrics/constants.js");
/* harmony import */ var _js_components_InViewProvider__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/components/InViewProvider */ "./js/components/InViewProvider/index.js");
/* harmony import */ var _Panel__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./Panel */ "./js/components/KeyMetrics/MetricsSelectionPanel/Panel.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Key Metrics Selection Panel
 *
 * Site Kit by Google, Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Internal dependencies
 */






function MetricsSelectionPanel() {
  const isOpen = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useSelect)(select => select(_js_googlesitekit_datastore_ui_constants__WEBPACK_IMPORTED_MODULE_1__.CORE_UI).getValue(_js_components_KeyMetrics_constants__WEBPACK_IMPORTED_MODULE_2__.KEY_METRICS_SELECTION_PANEL_OPENED_KEY));
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_js_components_InViewProvider__WEBPACK_IMPORTED_MODULE_3__["default"], {
    value: {
      key: 'MetricsSelectionPanel',
      value: !!isOpen
    },
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_Panel__WEBPACK_IMPORTED_MODULE_4__["default"], {})
  });
}

/***/ }),

/***/ "./js/components/KeyMetrics/constants.js":
/*!***********************************************!*\
  !*** ./js/components/KeyMetrics/constants.js ***!
  \***********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   EFFECTIVE_SELECTION: () => (/* binding */ EFFECTIVE_SELECTION),
/* harmony export */   KEY_METRICS_GROUP_CONTENT_PERFORMANCE: () => (/* binding */ KEY_METRICS_GROUP_CONTENT_PERFORMANCE),
/* harmony export */   KEY_METRICS_GROUP_CURRENT: () => (/* binding */ KEY_METRICS_GROUP_CURRENT),
/* harmony export */   KEY_METRICS_GROUP_DRIVING_TRAFFIC: () => (/* binding */ KEY_METRICS_GROUP_DRIVING_TRAFFIC),
/* harmony export */   KEY_METRICS_GROUP_GENERATING_LEADS: () => (/* binding */ KEY_METRICS_GROUP_GENERATING_LEADS),
/* harmony export */   KEY_METRICS_GROUP_SELLING_PRODUCTS: () => (/* binding */ KEY_METRICS_GROUP_SELLING_PRODUCTS),
/* harmony export */   KEY_METRICS_GROUP_SUGGESTED: () => (/* binding */ KEY_METRICS_GROUP_SUGGESTED),
/* harmony export */   KEY_METRICS_GROUP_VISITORS: () => (/* binding */ KEY_METRICS_GROUP_VISITORS),
/* harmony export */   KEY_METRICS_SELECTED: () => (/* binding */ KEY_METRICS_SELECTED),
/* harmony export */   KEY_METRICS_SELECTION_FORM: () => (/* binding */ KEY_METRICS_SELECTION_FORM),
/* harmony export */   KEY_METRICS_SELECTION_PANEL_OPENED_KEY: () => (/* binding */ KEY_METRICS_SELECTION_PANEL_OPENED_KEY),
/* harmony export */   KEY_METRICS_SETUP_CTA_WIDGET_SLUG: () => (/* binding */ KEY_METRICS_SETUP_CTA_WIDGET_SLUG),
/* harmony export */   MAX_SELECTED_METRICS_COUNT: () => (/* binding */ MAX_SELECTED_METRICS_COUNT),
/* harmony export */   MIN_SELECTED_METRICS_COUNT: () => (/* binding */ MIN_SELECTED_METRICS_COUNT),
/* harmony export */   UNSTAGED_SELECTION: () => (/* binding */ UNSTAGED_SELECTION)
/* harmony export */ });
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/**
 * Key Metrics components - constants.
 *
 * Site Kit by Google, Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */

const KEY_METRICS_SETUP_CTA_WIDGET_SLUG = 'key-metrics-setup-cta-widget';
const KEY_METRICS_SELECTION_PANEL_OPENED_KEY = 'googlesitekit-key-metrics-selection-panel-opened';
const KEY_METRICS_SELECTION_FORM = 'key-metrics-selection-form';
const KEY_METRICS_SELECTED = 'key-metrics-selected';
const EFFECTIVE_SELECTION = 'key-metrics-effective-selection';
const UNSTAGED_SELECTION = 'key-metrics-unstaged-selection';
const MIN_SELECTED_METRICS_COUNT = 2;
const MAX_SELECTED_METRICS_COUNT = 8;
const KEY_METRICS_GROUP_CURRENT = {
  SLUG: 'current-selection',
  LABEL: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Current selection', 'google-site-kit')
};
const KEY_METRICS_GROUP_SUGGESTED = {
  SLUG: 'suggested',
  LABEL: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Suggested', 'google-site-kit')
};
const KEY_METRICS_GROUP_VISITORS = {
  SLUG: 'visitors',
  LABEL: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Visitors', 'google-site-kit')
};
const KEY_METRICS_GROUP_DRIVING_TRAFFIC = {
  SLUG: 'driving-traffic',
  LABEL: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Driving traffic', 'google-site-kit')
};
const KEY_METRICS_GROUP_GENERATING_LEADS = {
  SLUG: 'generating-leads',
  LABEL: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Generating leads', 'google-site-kit')
};
const KEY_METRICS_GROUP_SELLING_PRODUCTS = {
  SLUG: 'selling-products',
  LABEL: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Selling products', 'google-site-kit')
};
const KEY_METRICS_GROUP_CONTENT_PERFORMANCE = {
  SLUG: 'content-performance',
  LABEL: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Content performance', 'google-site-kit')
};

/***/ }),

/***/ "./js/components/KeyMetrics/hooks/useCurrentlyActiveEvents.js":
/*!********************************************************************!*\
  !*** ./js/components/KeyMetrics/hooks/useCurrentlyActiveEvents.js ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ useCurrentlyActiveEvents)
/* harmony export */ });
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/googlesitekit/datastore/user/constants */ "./js/googlesitekit/datastore/user/constants.js");
/* harmony import */ var _js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/modules/analytics-4/datastore/constants */ "./js/modules/analytics-4/datastore/constants.js");
/**
 * The useCurrentlyActiveEvents hook.
 *
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Internal dependencies
 */




/**
 * Gets the list of currently active conversion events based on user selection
 * or user input settings.
 *
 * @since n.e.x.t
 *
 * @return {Array<string>|undefined} List of currently active conversion events.
 */
function useCurrentlyActiveEvents() {
  return (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useSelect)(select => {
    const userPickedMetrics = select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_1__.CORE_USER).getUserPickedMetrics();
    if (userPickedMetrics?.length) {
      // Safe to access without GA4 connection; no network request.
      const keyMetricsConversionEventWidgets = select(_js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_2__.MODULES_ANALYTICS_4).getKeyMetricsConversionEventWidgets();
      return Object.keys(keyMetricsConversionEventWidgets).filter(event => userPickedMetrics.some(metric => keyMetricsConversionEventWidgets[event].includes(metric)));
    }
    const userInputSettings = select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_1__.CORE_USER).getUserInputSettings();
    return userInputSettings?.includeConversionEvents?.values;
  });
}

/***/ }),

/***/ "./js/components/KeyMetrics/hooks/useDisplayCTAWidget.js":
/*!***************************************************************!*\
  !*** ./js/components/KeyMetrics/hooks/useDisplayCTAWidget.js ***!
  \***************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ useDisplayCTAWidget)
/* harmony export */ });
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/googlesitekit/modules/datastore/constants */ "./js/googlesitekit/modules/datastore/constants.js");
/* harmony import */ var _js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/googlesitekit/datastore/user/constants */ "./js/googlesitekit/datastore/user/constants.js");
/* harmony import */ var _js_components_KeyMetrics_constants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/components/KeyMetrics/constants */ "./js/components/KeyMetrics/constants.js");
/* harmony import */ var _js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/modules/analytics-4/datastore/constants */ "./js/modules/analytics-4/datastore/constants.js");
/* harmony import */ var _js_modules_analytics_4_constants__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/modules/analytics-4/constants */ "./js/modules/analytics-4/constants.js");
/* harmony import */ var _js_modules_search_console_datastore_constants__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @/js/modules/search-console/datastore/constants */ "./js/modules/search-console/datastore/constants.js");
/* harmony import */ var _js_modules_search_console_constants__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @/js/modules/search-console/constants */ "./js/modules/search-console/constants.js");
/**
 * Determines whether the CTA widget should be displayed.
 *
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Internal dependencies
 */









/**
 * Determines whether the CTA widget should be displayed.
 *
 * @since 1.140.0
 *
 * @return {boolean} Whether the CTA widget should be displayed.
 */
function useDisplayCTAWidget() {
  return (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useSelect)(select => {
    const isDismissed = select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_2__.CORE_USER).isItemDismissed(_js_components_KeyMetrics_constants__WEBPACK_IMPORTED_MODULE_3__.KEY_METRICS_SETUP_CTA_WIDGET_SLUG);
    const isDismissingItem = select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_2__.CORE_USER).isDismissingItem(_js_components_KeyMetrics_constants__WEBPACK_IMPORTED_MODULE_3__.KEY_METRICS_SETUP_CTA_WIDGET_SLUG);

    // We call isGatheringData() within this hook for completeness as we do not want to rely
    // on it being called in other components. This selector makes report requests which, if they return
    // data, then the `data-available` transients are set. These transients are prefetched as a global on
    // the next page load.

    const searchConsoleDataAvailableOnLoad = isModuleDataAvailableOnLoad(select, _js_modules_search_console_constants__WEBPACK_IMPORTED_MODULE_7__.MODULE_SLUG_SEARCH_CONSOLE, _js_modules_search_console_datastore_constants__WEBPACK_IMPORTED_MODULE_6__.MODULES_SEARCH_CONSOLE);
    const analyticsDataAvailableOnLoad = isModuleDataAvailableOnLoad(select, _js_modules_analytics_4_constants__WEBPACK_IMPORTED_MODULE_5__.MODULE_SLUG_ANALYTICS_4, _js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_4__.MODULES_ANALYTICS_4);
    return isDismissed === false && isDismissingItem === false && searchConsoleDataAvailableOnLoad && analyticsDataAvailableOnLoad;
  }, []);
}
function isModuleDataAvailableOnLoad(select, slug, storeName) {
  if (select(_js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_1__.CORE_MODULES).isModuleConnected(slug)) {
    const {
      isGatheringData,
      isDataAvailableOnLoad
    } = select(storeName);
    isGatheringData();
    return isDataAvailableOnLoad();
  }
  return false;
}

/***/ }),

/***/ "./js/components/KeyMetrics/hooks/useFilteredKeyMetrics.js":
/*!*****************************************************************!*\
  !*** ./js/components/KeyMetrics/hooks/useFilteredKeyMetrics.js ***!
  \*****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ useFilteredKeyMetrics)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _js_components_KeyMetrics_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @/js/components/KeyMetrics/constants */ "./js/components/KeyMetrics/constants.js");
/**
 * The useFilteredKeyMetrics hook.
 *
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */


/**
 * Filters and aggregates key metrics for the active group.
 *
 * @since n.e.x.t
 *
 * @param {Object} args                                 Arguments.
 * @param {Object} args.allMetricItems                  All metric items keyed by slug.
 * @param {string} args.isActive                        Active group slug.
 * @param {Array}  args.effectiveSelection              Effective selection list.
 * @param {Array}  args.answerBasedMetrics              Tailored metrics for suggested group.
 * @param {Array}  args.selectedMetrics                 Currently selected metrics.
 * @param {Array}  args.newBadgeEvents                  Events that should show the "New" badge.
 * @param {Object} args.conversionReportingEventWidgets Mapping of event => [metric slugs].
 * @return {Object}                                     Object with `selectedCounts`, `activeMetricItems`, and `newlyDetectedMetrics`.
 */
function useFilteredKeyMetrics({
  allMetricItems = {},
  isActive,
  effectiveSelection = [],
  answerBasedMetrics = [],
  selectedMetrics = [],
  newBadgeEvents = [],
  conversionReportingEventWidgets = {}
}) {
  return (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useMemo)(() => {
    // Currently selected group does not include total selected number, so it will always be 0.
    const selectedCounts = {
      [_js_components_KeyMetrics_constants__WEBPACK_IMPORTED_MODULE_0__.KEY_METRICS_GROUP_CURRENT.SLUG]: 0
    };
    const activeMetricItems = {};
    const newlyDetectedMetrics = {};
    for (const metricItemSlug in allMetricItems) {
      const metricGroup = allMetricItems[metricItemSlug].group;
      if (metricGroup === isActive || isActive === _js_components_KeyMetrics_constants__WEBPACK_IMPORTED_MODULE_0__.KEY_METRICS_GROUP_CURRENT.SLUG && effectiveSelection.includes(metricItemSlug)) {
        activeMetricItems[metricItemSlug] = allMetricItems[metricItemSlug];
      }
      if (isActive === _js_components_KeyMetrics_constants__WEBPACK_IMPORTED_MODULE_0__.KEY_METRICS_GROUP_SUGGESTED.SLUG && answerBasedMetrics.includes(metricItemSlug)) {
        if (answerBasedMetrics.includes(metricItemSlug)) {
          activeMetricItems[metricItemSlug] = allMetricItems[metricItemSlug];
        }
      }
      if (!selectedCounts[metricGroup]) {
        const selectedCount = Object.keys(allMetricItems).filter(slug => {
          // Check if metric slug is in selectedMetrics, so the group count is reflected in real time as metrics are checked/unchecked.
          if (allMetricItems[slug].group === metricGroup && selectedMetrics?.includes(slug)) {
            return true;
          }
          return false;
        }).length;
        selectedCounts[metricGroup] = selectedCount;
      }

      // Check if metric is conversion event related and if new badge should be included.
      if (newBadgeEvents?.length) {
        const isNewlyDetectedKeyMetrics = newBadgeEvents.some(conversionEvent => conversionReportingEventWidgets[conversionEvent].includes(metricItemSlug));
        if (isNewlyDetectedKeyMetrics) {
          var _newlyDetectedMetrics;
          newlyDetectedMetrics[metricGroup] = [...((_newlyDetectedMetrics = newlyDetectedMetrics[metricGroup]) !== null && _newlyDetectedMetrics !== void 0 ? _newlyDetectedMetrics : []), metricItemSlug];
        }
      }
    }
    return {
      selectedCounts,
      activeMetricItems,
      newlyDetectedMetrics
    };
  }, [allMetricItems, isActive, effectiveSelection, answerBasedMetrics, selectedMetrics, newBadgeEvents, conversionReportingEventWidgets]);
}

/***/ }),

/***/ "./js/components/KeyMetrics/hooks/useKeyMetricsGroups.js":
/*!***************************************************************!*\
  !*** ./js/components/KeyMetrics/hooks/useKeyMetricsGroups.js ***!
  \***************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ useKeyMetricsGroups)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @/js/modules/analytics-4/datastore/constants */ "./js/modules/analytics-4/datastore/constants.js");
/* harmony import */ var _js_components_KeyMetrics_constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/components/KeyMetrics/constants */ "./js/components/KeyMetrics/constants.js");
/**
 * The useKeyMetricsGroups hook.
 *
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */



/**
 * Computes the key metrics groups and supporting flags for tailoring.
 *
 * @since n.e.x.t
 *
 * @param {Object}  args                       Arguments.
 * @param {Array}   args.detectedEvents        Detected GA4 events.
 * @param {Array}   args.currentlyActiveEvents Currently active events from settings/user picks.
 * @param {boolean} args.isUserInputCompleted  Whether user input is completed.
 * @param {Array}   args.answerBasedMetrics    Tailored metrics based on answers/events.
 * @return {Object}                            Object with `hasGeneratingLeadsGroup`, `hasSellingProductsGroup`, `keyMetricsGroups`, and `dynamicGroups`.
 */
function useKeyMetricsGroups({
  detectedEvents = [],
  currentlyActiveEvents = [],
  isUserInputCompleted,
  answerBasedMetrics = []
}) {
  const hasGeneratingLeadsGroup = [_js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_0__.ENUM_CONVERSION_EVENTS.SUBMIT_LEAD_FORM, _js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_0__.ENUM_CONVERSION_EVENTS.CONTACT, _js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_0__.ENUM_CONVERSION_EVENTS.GENERATE_LEAD].filter(item => detectedEvents?.includes(item) || currentlyActiveEvents?.includes(item));
  const hasSellingProductsGroup = [_js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_0__.ENUM_CONVERSION_EVENTS.ADD_TO_CART, _js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_0__.ENUM_CONVERSION_EVENTS.PURCHASE].filter(item => detectedEvents?.includes(item) || currentlyActiveEvents?.includes(item));
  const keyMetricsGroups = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useMemo)(() => {
    return [_js_components_KeyMetrics_constants__WEBPACK_IMPORTED_MODULE_1__.KEY_METRICS_GROUP_VISITORS, _js_components_KeyMetrics_constants__WEBPACK_IMPORTED_MODULE_1__.KEY_METRICS_GROUP_DRIVING_TRAFFIC, ...(hasGeneratingLeadsGroup?.length ? [_js_components_KeyMetrics_constants__WEBPACK_IMPORTED_MODULE_1__.KEY_METRICS_GROUP_GENERATING_LEADS] : []), ...(hasSellingProductsGroup?.length ? [_js_components_KeyMetrics_constants__WEBPACK_IMPORTED_MODULE_1__.KEY_METRICS_GROUP_SELLING_PRODUCTS] : []), _js_components_KeyMetrics_constants__WEBPACK_IMPORTED_MODULE_1__.KEY_METRICS_GROUP_CONTENT_PERFORMANCE];
  }, [hasGeneratingLeadsGroup, hasSellingProductsGroup]);
  const dynamicGroups = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useMemo)(() => {
    if (isUserInputCompleted && answerBasedMetrics?.length) {
      return [_js_components_KeyMetrics_constants__WEBPACK_IMPORTED_MODULE_1__.KEY_METRICS_GROUP_CURRENT, _js_components_KeyMetrics_constants__WEBPACK_IMPORTED_MODULE_1__.KEY_METRICS_GROUP_SUGGESTED];
    }
    return [_js_components_KeyMetrics_constants__WEBPACK_IMPORTED_MODULE_1__.KEY_METRICS_GROUP_CURRENT];
  }, [isUserInputCompleted, answerBasedMetrics]);
  return {
    hasGeneratingLeadsGroup,
    hasSellingProductsGroup,
    keyMetricsGroups,
    dynamicGroups
  };
}

/***/ }),

/***/ "./js/components/KeyMetrics/hooks/useNewBadgeEvents.js":
/*!*************************************************************!*\
  !*** ./js/components/KeyMetrics/hooks/useNewBadgeEvents.js ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ useNewBadgeEvents)
/* harmony export */ });
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/googlesitekit/modules/datastore/constants */ "./js/googlesitekit/modules/datastore/constants.js");
/* harmony import */ var _js_modules_analytics_4_constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/modules/analytics-4/constants */ "./js/modules/analytics-4/constants.js");
/* harmony import */ var _js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/modules/analytics-4/datastore/constants */ "./js/modules/analytics-4/datastore/constants.js");
/**
 * UseNewBadgeEvents hook.
 *
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Internal dependencies
 */





/**
 * Returns the list of conversion events for which the "New" badge should be shown.
 *
 * Mirrors the logic previously in ChipTabGroup for computing `newBadgeEvents`.
 *
 * @since n.e.x.t
 *
 * @return {Array<string>} List of events for which to show the "New" badge.
 */
function useNewBadgeEvents() {
  return (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useSelect)(select => {
    const isGA4Connected = select(_js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_1__.CORE_MODULES).isModuleConnected(_js_modules_analytics_4_constants__WEBPACK_IMPORTED_MODULE_2__.MODULE_SLUG_ANALYTICS_4);
    if (!isGA4Connected) {
      return [];
    }
    const detectedEvents = select(_js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_3__.MODULES_ANALYTICS_4).getDetectedEvents();
    const badgeEvents = select(_js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_3__.MODULES_ANALYTICS_4).getNewBadgeEvents();
    if (detectedEvents?.length && badgeEvents?.length) {
      const detectedLeadEvents = detectedEvents.filter(event => _js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_3__.CONVERSION_REPORTING_LEAD_EVENTS.includes(event));
      const newLeadEvents = badgeEvents.filter(event => _js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_3__.CONVERSION_REPORTING_LEAD_EVENTS.includes(event));
      const newNonLeadEvents = badgeEvents.filter(event => !_js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_3__.CONVERSION_REPORTING_LEAD_EVENTS.includes(event));
      if (detectedLeadEvents?.length > 1 && newLeadEvents.length > 0) {
        return newNonLeadEvents;
      }
    }
    return badgeEvents;
  });
}

/***/ }),

/***/ "./js/components/KeyMetrics/hooks/useOverflowingTabs.js":
/*!**************************************************************!*\
  !*** ./js/components/KeyMetrics/hooks/useOverflowingTabs.js ***!
  \**************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ useOverflowingTabs)
/* harmony export */ });
/* harmony import */ var react_use__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react-use */ "../node_modules/react-use/esm/useMount.js");
/* harmony import */ var react_use__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react-use */ "../node_modules/react-use/esm/useUnmount.js");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _js_hooks_useDebounce__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @/js/hooks/useDebounce */ "./js/hooks/useDebounce.js");
/**
 * The useOverflowingTabs hook.
 *
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */


/**
 * Ensures that on small screens the last tab is visually cut off to imply
 * scroll, and wires up resize handling and open transitions.
 *
 * @since n.e.x.t
 *
 * @param {Object}  args                              Arguments.
 * @param {Object}  args.containerRef                 Ref to the container element.
 * @param {boolean} args.isMobileBreakpoint           Whether current breakpoint is small.
 * @param {boolean} args.isSelectionPanelOpen         Current open state for selection panel.
 * @param {boolean} args.isSelectionPanelOpenPrevious Previous open state for selection panel.
 */
function useOverflowingTabs({
  containerRef,
  isMobileBreakpoint,
  isSelectionPanelOpen,
  isSelectionPanelOpenPrevious
}) {
  // It is not always clear that tabs are scrollable on mobile, so we need to ensure that the last tab item
  // is cutoff to indicate that there are more tabs to scroll to.
  const maybeCutOffLastTabItem = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useCallback)(() => {
    const scrollContainer = containerRef.current?.querySelector('.mdc-tab-scroller__scroll-content');
    if (!isMobileBreakpoint) {
      return;
    }
    const tabItems = containerRef.current?.querySelectorAll('.googlesitekit-chip-tab-group__tab-items .mdc-tab');
    if (!tabItems?.length || !scrollContainer) {
      return;
    }
    const containerRect = containerRef.current?.getBoundingClientRect();
    const visibleItems = [];
    tabItems.forEach((tabItem, index) => {
      const tabItemRect = tabItem.getBoundingClientRect();
      if (tabItemRect.left >= containerRect.left && tabItemRect.right <= containerRect.right) {
        visibleItems.push(index);
      }
    });
    const nextTabItem = tabItems[visibleItems.length];
    if (!nextTabItem) {
      return;
    }
    const nextTabItemRect = nextTabItem.getBoundingClientRect();

    // If the next tab item is either completely off-screen or only barely
    // visible (i.e. cut off by 15px or less, meaning most likely it is still
    // outside the visible area), reduce the column gap so that the last tab
    // item appears properly truncated.
    if (nextTabItemRect.left >= containerRect.right || nextTabItemRect.left - containerRect.right < 0 && -(nextTabItemRect.left - containerRect.right) <= 20) {
      // If there is an inline gap of 2px we already adjusted it once, and
      // the last item is still not cut off, we need to adjust the column
      // gap to 20px to ensure the last item is cut off.
      if (scrollContainer.style.columnGap === '2px') {
        scrollContainer.style.columnGap = '20px';
      } else {
        scrollContainer.style.columnGap = '2px';
      }
      maybeCutOffLastTabItem();
    }
  }, [containerRef, isMobileBreakpoint]);

  // Debounce the maybeCutOffLastTabItem function
  const debouncedMaybeCutOffLastTabItem = (0,_js_hooks_useDebounce__WEBPACK_IMPORTED_MODULE_0__.useDebounce)(maybeCutOffLastTabItem, 50);
  (0,react_use__WEBPACK_IMPORTED_MODULE_2__["default"])(() => {
    __webpack_require__.g.addEventListener('resize', debouncedMaybeCutOffLastTabItem);
  });
  (0,react_use__WEBPACK_IMPORTED_MODULE_3__["default"])(() => __webpack_require__.g.removeEventListener('resize', debouncedMaybeCutOffLastTabItem));
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useEffect)(() => {
    if (!isSelectionPanelOpenPrevious && isSelectionPanelOpen) {
      maybeCutOffLastTabItem();
    }
  }, [isSelectionPanelOpen, isSelectionPanelOpenPrevious, maybeCutOffLastTabItem]);
}

/***/ }),

/***/ "./js/components/KeyMetrics/key-metrics-widgets.js":
/*!*********************************************************!*\
  !*** ./js/components/KeyMetrics/key-metrics-widgets.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   KEY_METRICS_WIDGETS: () => (/* binding */ KEY_METRICS_WIDGETS)
/* harmony export */ });
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/googlesitekit/datastore/user/constants */ "./js/googlesitekit/datastore/user/constants.js");
/* harmony import */ var _js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/googlesitekit/datastore/site/constants */ "./js/googlesitekit/datastore/site/constants.js");
/* harmony import */ var _js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/modules/analytics-4/datastore/constants */ "./js/modules/analytics-4/datastore/constants.js");
/* harmony import */ var _shouldDisplayWidgetWithConversionEvent__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./shouldDisplayWidgetWithConversionEvent */ "./js/components/KeyMetrics/shouldDisplayWidgetWithConversionEvent.js");
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./constants */ "./js/components/KeyMetrics/constants.js");
/**
 * Key Metrics widgets metadata.
 *
 * Site Kit by Google, Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */






/**
 * Determines whether to show a widget the requires Analytics 4 and AdSense to be linked.
 *
 * For admin dashboards, the widget will be shown if both modules are activate so that
 * the connection CTA can be shown if they have not been linked.
 *
 * For view-only dashboards, the widget will only be displayed if both modules are linked.
 *
 * @since 1.121.0
 *
 * @param {Object}   options                     Options object.
 * @param {Function} options.select              Data store select function.
 * @param {boolean}  options.isViewOnlyDashboard Whether the current dashboard is view only.
 * @return {boolean} Whether to display the widget.
 */
function shouldDisplayWidgetWithAnalytics4AndAdSenseLinked({
  select,
  isViewOnlyDashboard
}) {
  if (!isViewOnlyDashboard) {
    return true;
  }
  if (isViewOnlyDashboard && select(_js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_3__.MODULES_ANALYTICS_4).getAdSenseLinked()) {
    return true;
  }
  return false;
}

/**
 * Determines whether to display a widget that requires custom dimensions in the key
 * metrics selection panel.
 *
 * All widgets are displayed in authenticated dashboard. However, in view only dashboard,
 * widgets that require custom dimensions will only be displayed if the required custom
 * dimensions are available in the shared property.
 *
 * This function is attached to the widget object that requires the custom dimensions and
 * has the `requiredCustomDimensions` property.
 *
 * @since 1.113.0
 *
 * @param {Object}   options                     Options object.
 * @param {Function} options.select              Data store select function.
 * @param {boolean}  options.isViewOnlyDashboard Whether the current dashboard is view only.
 * @return {boolean} Whether to display the widget.
 */
function shouldDisplayWidgetWithCustomDimensions({
  select,
  isViewOnlyDashboard
}) {
  if (!isViewOnlyDashboard) {
    return true;
  }
  return select(_js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_3__.MODULES_ANALYTICS_4).hasCustomDimensions(
  // This property is available to the widget object that requires the
  // custom dimensions, where the function is attached.
  this.requiredCustomDimensions);
}
const KEY_METRICS_WIDGETS = {
  [_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_1__.KM_ANALYTICS_ADSENSE_TOP_EARNING_CONTENT]: {
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Top earning pages', 'google-site-kit'),
    description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Pages that generated the most AdSense revenue', 'google-site-kit'),
    infoTooltip: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Pages that generated the most AdSense revenue', 'google-site-kit'),
    displayInSelectionPanel: shouldDisplayWidgetWithAnalytics4AndAdSenseLinked,
    displayInList: shouldDisplayWidgetWithAnalytics4AndAdSenseLinked,
    metadata: {
      group: _constants__WEBPACK_IMPORTED_MODULE_5__.KEY_METRICS_GROUP_CONTENT_PERFORMANCE.SLUG
    }
  },
  [_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_1__.KM_ANALYTICS_TOP_RECENT_TRENDING_PAGES]: {
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Top recent trending pages', 'google-site-kit'),
    description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Pages with the most pageviews published in the last 3 days', 'google-site-kit'),
    infoTooltip: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Pages with the most pageviews published in the last 3 days', 'google-site-kit'),
    requiredCustomDimensions: ['googlesitekit_post_date'],
    displayInSelectionPanel: shouldDisplayWidgetWithCustomDimensions,
    displayInWidgetArea: shouldDisplayWidgetWithCustomDimensions,
    displayInList: shouldDisplayWidgetWithCustomDimensions,
    metadata: {
      group: _constants__WEBPACK_IMPORTED_MODULE_5__.KEY_METRICS_GROUP_CONTENT_PERFORMANCE.SLUG
    }
  },
  [_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_1__.KM_ANALYTICS_POPULAR_AUTHORS]: {
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Most popular authors by pageviews', 'google-site-kit'),
    description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Authors whose posts got the most visits', 'google-site-kit'),
    infoTooltip: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Authors whose posts got the most visits', 'google-site-kit'),
    requiredCustomDimensions: ['googlesitekit_post_author'],
    displayInSelectionPanel: shouldDisplayWidgetWithCustomDimensions,
    displayInWidgetArea: shouldDisplayWidgetWithCustomDimensions,
    displayInList: shouldDisplayWidgetWithCustomDimensions,
    metadata: {
      group: _constants__WEBPACK_IMPORTED_MODULE_5__.KEY_METRICS_GROUP_CONTENT_PERFORMANCE.SLUG
    }
  },
  [_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_1__.KM_ANALYTICS_TOP_CATEGORIES]: {
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Top categories by pageviews', 'google-site-kit'),
    description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Categories that your site visitors viewed the most', 'google-site-kit'),
    infoTooltip: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Categories that your site visitors viewed the most', 'google-site-kit'),
    requiredCustomDimensions: ['googlesitekit_post_categories'],
    displayInSelectionPanel: shouldDisplayWidgetWithCustomDimensions,
    displayInWidgetArea: shouldDisplayWidgetWithCustomDimensions,
    displayInList: shouldDisplayWidgetWithCustomDimensions,
    metadata: {
      group: _constants__WEBPACK_IMPORTED_MODULE_5__.KEY_METRICS_GROUP_CONTENT_PERFORMANCE.SLUG
    }
  },
  [_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_1__.KM_ANALYTICS_POPULAR_CONTENT]: {
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Most popular content by pageviews', 'google-site-kit'),
    description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Pages that brought in the most visitors', 'google-site-kit'),
    infoTooltip: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Pages your visitors read the most', 'google-site-kit'),
    metadata: {
      group: _constants__WEBPACK_IMPORTED_MODULE_5__.KEY_METRICS_GROUP_CONTENT_PERFORMANCE.SLUG
    }
  },
  [_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_1__.KM_ANALYTICS_POPULAR_PRODUCTS]: {
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Most popular products by pageviews', 'google-site-kit'),
    description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Products that brought in the most visitors', 'google-site-kit'),
    requiredCustomDimensions: ['googlesitekit_post_type'],
    displayInSelectionPanel: ({
      select
    }) => select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_1__.CORE_USER).isKeyMetricActive(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_1__.KM_ANALYTICS_POPULAR_PRODUCTS) || select(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_2__.CORE_SITE).getProductPostType(),
    displayInWidgetArea: shouldDisplayWidgetWithCustomDimensions,
    metadata: {
      group: _constants__WEBPACK_IMPORTED_MODULE_5__.KEY_METRICS_GROUP_SELLING_PRODUCTS.SLUG
    }
  },
  [_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_1__.KM_ANALYTICS_PAGES_PER_VISIT]: {
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Pages per visit', 'google-site-kit'),
    description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Number of pages visitors viewed per session on average', 'google-site-kit'),
    infoTooltip: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Number of pages visitors viewed per session on average', 'google-site-kit'),
    metadata: {
      group: _constants__WEBPACK_IMPORTED_MODULE_5__.KEY_METRICS_GROUP_VISITORS.SLUG
    }
  },
  [_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_1__.KM_ANALYTICS_VISIT_LENGTH]: {
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Visit length', 'google-site-kit'),
    description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Average duration of engaged visits', 'google-site-kit'),
    infoTooltip: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Average duration of engaged visits', 'google-site-kit'),
    metadata: {
      group: _constants__WEBPACK_IMPORTED_MODULE_5__.KEY_METRICS_GROUP_VISITORS.SLUG
    }
  },
  [_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_1__.KM_ANALYTICS_VISITS_PER_VISITOR]: {
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Visits per visitor', 'google-site-kit'),
    description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Average number of sessions per site visitor', 'google-site-kit'),
    infoTooltip: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Average number of sessions per site visitor', 'google-site-kit'),
    metadata: {
      group: _constants__WEBPACK_IMPORTED_MODULE_5__.KEY_METRICS_GROUP_VISITORS.SLUG
    }
  },
  [_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_1__.KM_ANALYTICS_MOST_ENGAGING_PAGES]: {
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Most engaging pages', 'google-site-kit'),
    description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Pages with the highest engagement rate', 'google-site-kit'),
    infoTooltip: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Pages with the highest engagement rate', 'google-site-kit'),
    metadata: {
      group: _constants__WEBPACK_IMPORTED_MODULE_5__.KEY_METRICS_GROUP_CONTENT_PERFORMANCE.SLUG
    }
  },
  [_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_1__.KM_ANALYTICS_LEAST_ENGAGING_PAGES]: {
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Least engaging pages', 'google-site-kit'),
    description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Pages with the highest percentage of visitors that left without engagement with your site', 'google-site-kit'),
    infoTooltip: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Percentage of visitors that left without engagement with your site', 'google-site-kit'),
    metadata: {
      group: _constants__WEBPACK_IMPORTED_MODULE_5__.KEY_METRICS_GROUP_CONTENT_PERFORMANCE.SLUG
    }
  },
  [_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_1__.KM_ANALYTICS_TOP_RETURNING_VISITOR_PAGES]: {
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Top pages by returning visitors', 'google-site-kit'),
    description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Pages that attracted the most returning visitors', 'google-site-kit'),
    infoTooltip: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Pages that attracted the most returning visitors', 'google-site-kit'),
    metadata: {
      group: _constants__WEBPACK_IMPORTED_MODULE_5__.KEY_METRICS_GROUP_VISITORS.SLUG
    }
  },
  [_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_1__.KM_ANALYTICS_NEW_VISITORS]: {
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('New visitors', 'google-site-kit'),
    description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('How many new visitors you got and how the overall audience changed', 'google-site-kit'),
    infoTooltip: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Portion of visitors who visited your site for the first time in this timeframe', 'google-site-kit'),
    metadata: {
      group: _constants__WEBPACK_IMPORTED_MODULE_5__.KEY_METRICS_GROUP_VISITORS.SLUG
    }
  },
  [_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_1__.KM_ANALYTICS_RETURNING_VISITORS]: {
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Returning visitors', 'google-site-kit'),
    description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Portion of people who visited your site more than once', 'google-site-kit'),
    infoTooltip: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Portion of your site’s visitors that returned at least once in this timeframe', 'google-site-kit'),
    metadata: {
      group: _constants__WEBPACK_IMPORTED_MODULE_5__.KEY_METRICS_GROUP_VISITORS.SLUG
    }
  },
  [_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_1__.KM_ANALYTICS_TOP_TRAFFIC_SOURCE]: {
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Top traffic source', 'google-site-kit'),
    description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Channel which brought in the most visitors to your site', 'google-site-kit'),
    infoTooltip: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Channel (e.g. social, paid, search) that brought in the most visitors to your site', 'google-site-kit'),
    metadata: {
      group: _constants__WEBPACK_IMPORTED_MODULE_5__.KEY_METRICS_GROUP_DRIVING_TRAFFIC.SLUG
    }
  },
  [_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_1__.KM_ANALYTICS_TOP_TRAFFIC_SOURCE_DRIVING_ADD_TO_CART]: {
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Top traffic source driving add to cart', 'google-site-kit'),
    description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Channel which brought in the most add to cart events to your site', 'google-site-kit'),
    infoTooltip: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Channel (e.g. social, paid, search) that brought in the most add to cart events to your site', 'google-site-kit'),
    requiredConversionEventName: [_js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_3__.ENUM_CONVERSION_EVENTS.ADD_TO_CART],
    displayInSelectionPanel: _shouldDisplayWidgetWithConversionEvent__WEBPACK_IMPORTED_MODULE_4__.shouldDisplayWidgetWithConversionEvent,
    displayInList: _shouldDisplayWidgetWithConversionEvent__WEBPACK_IMPORTED_MODULE_4__.shouldDisplayWidgetWithConversionEvent,
    metadata: {
      group: _constants__WEBPACK_IMPORTED_MODULE_5__.KEY_METRICS_GROUP_SELLING_PRODUCTS.SLUG
    }
  },
  [_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_1__.KM_ANALYTICS_TOP_TRAFFIC_SOURCE_DRIVING_LEADS]: {
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Top traffic source driving leads', 'google-site-kit'),
    description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Channel which brought in the most leads to your site', 'google-site-kit'),
    infoTooltip: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Channel (e.g. social, paid, search) that brought in the most leads to your site', 'google-site-kit'),
    requiredConversionEventName: [_js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_3__.ENUM_CONVERSION_EVENTS.SUBMIT_LEAD_FORM, _js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_3__.ENUM_CONVERSION_EVENTS.CONTACT, _js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_3__.ENUM_CONVERSION_EVENTS.GENERATE_LEAD],
    displayInSelectionPanel: _shouldDisplayWidgetWithConversionEvent__WEBPACK_IMPORTED_MODULE_4__.shouldDisplayWidgetWithConversionEvent,
    displayInList: _shouldDisplayWidgetWithConversionEvent__WEBPACK_IMPORTED_MODULE_4__.shouldDisplayWidgetWithConversionEvent,
    metadata: {
      group: _constants__WEBPACK_IMPORTED_MODULE_5__.KEY_METRICS_GROUP_GENERATING_LEADS.SLUG
    }
  },
  [_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_1__.KM_ANALYTICS_TOP_TRAFFIC_SOURCE_DRIVING_PURCHASES]: {
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Top traffic source driving purchases', 'google-site-kit'),
    description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Channel which brought in the most purchases to your site', 'google-site-kit'),
    infoTooltip: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Channel (e.g. social, paid, search) that brought in the most purchases to your site', 'google-site-kit'),
    requiredConversionEventName: [_js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_3__.ENUM_CONVERSION_EVENTS.PURCHASE],
    displayInSelectionPanel: _shouldDisplayWidgetWithConversionEvent__WEBPACK_IMPORTED_MODULE_4__.shouldDisplayWidgetWithConversionEvent,
    displayInList: _shouldDisplayWidgetWithConversionEvent__WEBPACK_IMPORTED_MODULE_4__.shouldDisplayWidgetWithConversionEvent,
    metadata: {
      group: _constants__WEBPACK_IMPORTED_MODULE_5__.KEY_METRICS_GROUP_SELLING_PRODUCTS.SLUG
    }
  },
  [_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_1__.KM_ANALYTICS_ENGAGED_TRAFFIC_SOURCE]: {
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Most engaged traffic source', 'google-site-kit'),
    description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Visitors coming via this channel spent the most time on your site', 'google-site-kit'),
    infoTooltip: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Channel (e.g. social, paid, search) that brought in the most visitors who had a meaningful engagement with your site', 'google-site-kit'),
    metadata: {
      group: _constants__WEBPACK_IMPORTED_MODULE_5__.KEY_METRICS_GROUP_DRIVING_TRAFFIC.SLUG
    }
  },
  [_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_1__.KM_ANALYTICS_TOP_CONVERTING_TRAFFIC_SOURCE]: {
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Top converting traffic source', 'google-site-kit'),
    description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Channel which brought in the most visits that resulted in key events', 'google-site-kit'),
    infoTooltip: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Channel (e.g. social, paid, search) that brought in visitors who generated the most key events', 'google-site-kit'),
    metadata: {
      group: _constants__WEBPACK_IMPORTED_MODULE_5__.KEY_METRICS_GROUP_DRIVING_TRAFFIC.SLUG
    }
  },
  [_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_1__.KM_ANALYTICS_TOP_CITIES]: {
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Top cities driving traffic', 'google-site-kit'),
    description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Which cities you get the most visitors from', 'google-site-kit'),
    infoTooltip: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('The cities where most of your visitors came from', 'google-site-kit'),
    metadata: {
      group: _constants__WEBPACK_IMPORTED_MODULE_5__.KEY_METRICS_GROUP_DRIVING_TRAFFIC.SLUG
    }
  },
  [_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_1__.KM_ANALYTICS_TOP_CITIES_DRIVING_LEADS]: {
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Top cities driving leads', 'google-site-kit'),
    description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Cities driving the most contact form submissions', 'google-site-kit'),
    infoTooltip: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Cities driving the most contact form submissions', 'google-site-kit'),
    requiredConversionEventName: [_js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_3__.ENUM_CONVERSION_EVENTS.SUBMIT_LEAD_FORM, _js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_3__.ENUM_CONVERSION_EVENTS.CONTACT, _js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_3__.ENUM_CONVERSION_EVENTS.GENERATE_LEAD],
    displayInSelectionPanel: _shouldDisplayWidgetWithConversionEvent__WEBPACK_IMPORTED_MODULE_4__.shouldDisplayWidgetWithConversionEvent,
    displayInList: _shouldDisplayWidgetWithConversionEvent__WEBPACK_IMPORTED_MODULE_4__.shouldDisplayWidgetWithConversionEvent,
    metadata: {
      group: _constants__WEBPACK_IMPORTED_MODULE_5__.KEY_METRICS_GROUP_GENERATING_LEADS.SLUG
    }
  },
  [_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_1__.KM_ANALYTICS_TOP_CITIES_DRIVING_ADD_TO_CART]: {
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Top cities driving add to cart', 'google-site-kit'),
    description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Cities where visitors most frequently add products to their carts', 'google-site-kit'),
    infoTooltip: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Cities where visitors most frequently add products to their carts', 'google-site-kit'),
    requiredConversionEventName: [_js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_3__.ENUM_CONVERSION_EVENTS.ADD_TO_CART],
    displayInSelectionPanel: _shouldDisplayWidgetWithConversionEvent__WEBPACK_IMPORTED_MODULE_4__.shouldDisplayWidgetWithConversionEvent,
    displayInList: _shouldDisplayWidgetWithConversionEvent__WEBPACK_IMPORTED_MODULE_4__.shouldDisplayWidgetWithConversionEvent,
    metadata: {
      group: _constants__WEBPACK_IMPORTED_MODULE_5__.KEY_METRICS_GROUP_SELLING_PRODUCTS.SLUG
    }
  },
  [_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_1__.KM_ANALYTICS_TOP_CITIES_DRIVING_PURCHASES]: {
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Top cities driving purchases', 'google-site-kit'),
    description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Cities driving the most purchases', 'google-site-kit'),
    infoTooltip: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Cities driving the most purchases', 'google-site-kit'),
    requiredConversionEventName: [_js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_3__.ENUM_CONVERSION_EVENTS.PURCHASE],
    displayInSelectionPanel: _shouldDisplayWidgetWithConversionEvent__WEBPACK_IMPORTED_MODULE_4__.shouldDisplayWidgetWithConversionEvent,
    displayInList: _shouldDisplayWidgetWithConversionEvent__WEBPACK_IMPORTED_MODULE_4__.shouldDisplayWidgetWithConversionEvent,
    metadata: {
      group: _constants__WEBPACK_IMPORTED_MODULE_5__.KEY_METRICS_GROUP_SELLING_PRODUCTS.SLUG
    }
  },
  [_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_1__.KM_ANALYTICS_TOP_DEVICE_DRIVING_PURCHASES]: {
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Top device driving purchases', 'google-site-kit'),
    description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Top device driving the most purchases', 'google-site-kit'),
    infoTooltip: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Top device driving the most purchases', 'google-site-kit'),
    requiredConversionEventName: [_js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_3__.ENUM_CONVERSION_EVENTS.PURCHASE],
    displayInSelectionPanel: _shouldDisplayWidgetWithConversionEvent__WEBPACK_IMPORTED_MODULE_4__.shouldDisplayWidgetWithConversionEvent,
    displayInList: _shouldDisplayWidgetWithConversionEvent__WEBPACK_IMPORTED_MODULE_4__.shouldDisplayWidgetWithConversionEvent,
    metadata: {
      group: _constants__WEBPACK_IMPORTED_MODULE_5__.KEY_METRICS_GROUP_SELLING_PRODUCTS.SLUG
    }
  },
  [_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_1__.KM_ANALYTICS_TOP_COUNTRIES]: {
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Top countries driving traffic', 'google-site-kit'),
    description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Which countries you get the most visitors from', 'google-site-kit'),
    infoTooltip: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('The countries where most of your visitors came from', 'google-site-kit'),
    metadata: {
      group: _constants__WEBPACK_IMPORTED_MODULE_5__.KEY_METRICS_GROUP_DRIVING_TRAFFIC.SLUG
    }
  },
  [_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_1__.KM_SEARCH_CONSOLE_POPULAR_KEYWORDS]: {
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Top performing keywords', 'google-site-kit'),
    description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('What people searched for before they came to your site', 'google-site-kit'),
    infoTooltip: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('The top search queries for your site by highest clickthrough rate', 'google-site-kit'),
    metadata: {
      group: _constants__WEBPACK_IMPORTED_MODULE_5__.KEY_METRICS_GROUP_DRIVING_TRAFFIC.SLUG
    }
  },
  [_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_1__.KM_ANALYTICS_TOP_PAGES_DRIVING_LEADS]: {
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Top pages driving leads', 'google-site-kit'),
    description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Pages on which forms are most frequently submitted', 'google-site-kit'),
    requiredConversionEventName: [_js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_3__.ENUM_CONVERSION_EVENTS.SUBMIT_LEAD_FORM, _js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_3__.ENUM_CONVERSION_EVENTS.CONTACT, _js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_3__.ENUM_CONVERSION_EVENTS.GENERATE_LEAD],
    displayInSelectionPanel: _shouldDisplayWidgetWithConversionEvent__WEBPACK_IMPORTED_MODULE_4__.shouldDisplayWidgetWithConversionEvent,
    displayInList: _shouldDisplayWidgetWithConversionEvent__WEBPACK_IMPORTED_MODULE_4__.shouldDisplayWidgetWithConversionEvent,
    metadata: {
      group: _constants__WEBPACK_IMPORTED_MODULE_5__.KEY_METRICS_GROUP_GENERATING_LEADS.SLUG
    }
  }
};


/***/ }),

/***/ "./js/components/KeyMetrics/shouldDisplayWidgetWithConversionEvent.js":
/*!****************************************************************************!*\
  !*** ./js/components/KeyMetrics/shouldDisplayWidgetWithConversionEvent.js ***!
  \****************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   shouldDisplayWidgetWithConversionEvent: () => (/* binding */ shouldDisplayWidgetWithConversionEvent)
/* harmony export */ });
/* harmony import */ var _js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @/js/googlesitekit/datastore/user/constants */ "./js/googlesitekit/datastore/user/constants.js");
/* harmony import */ var _js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/modules/analytics-4/datastore/constants */ "./js/modules/analytics-4/datastore/constants.js");
/**
 * Key Metrics shouldDisplayWidgetWithConversionEvent function.
 *
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Internal dependencies
 */



/**
 * Determines whether to display a widget that requires conversion reporting events
 * in the key metrics selection panel.
 *
 * This function is attached to the widget object that requires the conversion reporting events and
 * has the `requiredConversionEventName` property.
 *
 * @since 1.136.0
 * @since 1.137.0 Moved function to its own file.
 *
 * @param {Object}   options        Options object.
 * @param {Function} options.select Data store select function.
 * @param {string}   options.slug   Key metric widget slug.
 * @return {boolean} Whether to display the widget.
 */
function shouldDisplayWidgetWithConversionEvent({
  select,
  slug
}) {
  return select(_js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_1__.MODULES_ANALYTICS_4).hasConversionReportingEvents(
  // This property is available to the widget object that requires the
  // conversion reporting events, where the function is attached.
  this.requiredConversionEventName) || select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_0__.CORE_USER).isKeyMetricActive(slug);
}

/***/ }),

/***/ "./js/components/LeanCTABanner.js":
/*!****************************************!*\
  !*** ./js/components/LeanCTABanner.js ***!
  \****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * LeanCTABanner component.
 *
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * WordPress dependencies
 */


const LeanCTABanner = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.forwardRef)(({
  className,
  children,
  Icon,
  SVGGraphic
}, ref) => {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsxs)("div", {
    ref: ref,
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-lean-cta-banner', className),
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsxs)("div", {
      className: "googlesitekit-lean-cta-banner__body",
      children: [Icon && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", {
        className: "googlesitekit-lean-cta-banner__body-icon",
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)(Icon, {
          width: "32",
          height: "32"
        })
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", {
        className: "googlesitekit-lean-cta-banner__body-content",
        children: children
      })]
    }), SVGGraphic && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", {
      className: "googlesitekit-lean-cta-banner__graphic",
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)(SVGGraphic, {})
    })]
  });
});
LeanCTABanner.propTypes = {
  className: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  children: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().node).isRequired,
  Icon: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().elementType),
  SVGGraphic: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().elementType)
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (LeanCTABanner);

/***/ }),

/***/ "./js/components/Link.js":
/*!*******************************!*\
  !*** ./js/components/Link.js ***!
  \*******************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_10__);
/* harmony import */ var react_router_dom__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! react-router-dom */ "../node_modules/react-router-dom/esm/react-router-dom.js");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _svg_icons_arrow_svg__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/svg/icons/arrow.svg */ "./svg/icons/arrow.svg");
/* harmony import */ var _svg_icons_arrow_inverse_svg__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/svg/icons/arrow-inverse.svg */ "./svg/icons/arrow-inverse.svg");
/* harmony import */ var _svg_icons_back_svg__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/svg/icons/back.svg */ "./svg/icons/back.svg");
/* harmony import */ var _svg_icons_external_svg__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/svg/icons/external.svg */ "./svg/icons/external.svg");
/* harmony import */ var _IconWrapper__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./IconWrapper */ "./js/components/IconWrapper.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Link component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */




/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */






const BUTTON = 'BUTTON';
const BUTTON_DISABLED = 'BUTTON_DISABLED';
const EXTERNAL_LINK = 'EXTERNAL_LINK';
const LINK = 'LINK';
const ROUTER_LINK = 'ROUTER_LINK';
const Link = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_8__.forwardRef)((props, ref) => {
  const {
    'aria-label': ariaLabelProp,
    secondary = false,
    arrow = false,
    back = false,
    caps = false,
    children,
    className = '',
    danger = false,
    disabled = false,
    external = false,
    hideExternalIndicator = false,
    href = '',
    inverse = false,
    noFlex = false,
    onClick,
    small = false,
    standalone = false,
    linkButton = false,
    to,
    leadingIcon,
    trailingIcon,
    ...otherProps
  } = props;
  function getType() {
    // Force button element if `onClick` prop is passed and there's no `href`
    // or `to` prop.
    if (!href && !to && onClick) {
      if (disabled) {
        return BUTTON_DISABLED;
      }
      return BUTTON;
    }

    // Only `RouterLink` uses the `to` prop.
    if (to) {
      return ROUTER_LINK;
    }

    // The external prop means this is an external link, which will also output
    // an `<a>` tag.
    if (external) {
      return EXTERNAL_LINK;
    }

    // A regular `<a>` tag without external indicators.
    return LINK;
  }
  const type = getType();
  function getLinkComponent() {
    if (type === BUTTON || type === BUTTON_DISABLED) {
      return 'button';
    }
    if (type === ROUTER_LINK) {
      return react_router_dom__WEBPACK_IMPORTED_MODULE_9__.Link;
    }
    return 'a';
  }
  function getAriaLabel() {
    // Otherwise, create an ARIA label if the link opens in a new window
    // or is disabled, to add extra context to the link.
    let labelSuffix;
    if (type === EXTERNAL_LINK) {
      labelSuffix = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__._x)('(opens in a new tab)', 'screen reader text', 'google-site-kit');
    }
    if (type === BUTTON_DISABLED) {
      labelSuffix = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__._x)('(disabled)', 'screen reader text', 'google-site-kit');
    }
    if (!labelSuffix) {
      return ariaLabelProp;
    }

    // If an ARIA label was supplied, use that.
    if (ariaLabelProp) {
      return `${ariaLabelProp} ${labelSuffix}`;
    }

    // Otherwise, use the children prop if it's a string.
    if (typeof children === 'string') {
      return `${children} ${labelSuffix}`;
    }

    // If there isn't a string we can use to create the label, we shouldn't
    // make one; otherwise we'll only create an ARIA label that says
    // "(opens in a new tab)", which is not good.
    return undefined;
  }
  const LinkComponent = getLinkComponent();
  const ariaLabel = getAriaLabel();

  // Set the prefix/suffix icons, based on the type of link this is and
  // the props supplied.
  let leadingIconToUse = leadingIcon;
  let trailingIconToUse = trailingIcon;
  if (back) {
    leadingIconToUse = /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_svg_icons_back_svg__WEBPACK_IMPORTED_MODULE_4__["default"], {
      width: 14,
      height: 14
    });
  }
  if (external && !hideExternalIndicator) {
    trailingIconToUse = /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_svg_icons_external_svg__WEBPACK_IMPORTED_MODULE_5__["default"], {
      width: 14,
      height: 14
    });
  }
  if (arrow && !inverse) {
    trailingIconToUse = /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_svg_icons_arrow_svg__WEBPACK_IMPORTED_MODULE_2__["default"], {
      width: 14,
      height: 14
    });
  }
  if (arrow && inverse) {
    trailingIconToUse = /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_svg_icons_arrow_inverse_svg__WEBPACK_IMPORTED_MODULE_3__["default"], {
      width: 14,
      height: 14
    });
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsxs)(LinkComponent, {
    "aria-label": ariaLabel,
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-cta-link', className, {
      'googlesitekit-cta-link--secondary': secondary,
      'googlesitekit-cta-link--inverse': inverse,
      'googlesitekit-cta-link--small': small,
      'googlesitekit-cta-link--caps': caps,
      'googlesitekit-cta-link--danger': danger,
      'googlesitekit-cta-link--disabled': disabled,
      'googlesitekit-cta-link--standalone': standalone,
      'googlesitekit-cta-link--link-button': linkButton,
      'googlesitekit-cta-link--no-flex': !!noFlex
    }),
    disabled: disabled,
    href: (type === LINK || type === EXTERNAL_LINK) && !disabled ? href : undefined,
    onClick: onClick,
    rel: type === EXTERNAL_LINK ? 'noopener noreferrer' : undefined,
    ref: ref,
    target: type === EXTERNAL_LINK ? '_blank' : undefined,
    to: to,
    ...otherProps,
    children: [!!leadingIconToUse && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_IconWrapper__WEBPACK_IMPORTED_MODULE_6__["default"], {
      marginRight: 5,
      children: leadingIconToUse
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)("span", {
      className: "googlesitekit-cta-link__contents",
      children: children
    }), !!trailingIconToUse && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_IconWrapper__WEBPACK_IMPORTED_MODULE_6__["default"], {
      marginLeft: 5,
      children: trailingIconToUse
    })]
  });
});
Link.propTypes = {
  arrow: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().bool),
  back: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().bool),
  caps: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().bool),
  children: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().node),
  className: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().string),
  danger: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().bool),
  disabled: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().bool),
  external: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().bool),
  hideExternalIndicator: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().bool),
  href: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().string),
  inverse: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().bool),
  leadingIcon: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().node),
  linkButton: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().bool),
  noFlex: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().bool),
  onClick: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().func),
  small: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().bool),
  standalone: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().bool),
  to: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().string),
  trailingIcon: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().node)
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Link);

/***/ }),

/***/ "./js/components/LoadingWrapper.js":
/*!*****************************************!*\
  !*** ./js/components/LoadingWrapper.js ***!
  \*****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ LoadingWrapper)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _PreviewBlock__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./PreviewBlock */ "./js/components/PreviewBlock.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * LoadingWrapper component.
 *
 * Site Kit by Google, Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * Internal dependencies
 */


function LoadingWrapper({
  loading,
  children,
  ...previewBlockProps
}) {
  if (loading) {
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)(_PreviewBlock__WEBPACK_IMPORTED_MODULE_0__["default"], {
      ...previewBlockProps
    });
  }
  return children;
}
LoadingWrapper.propTypes = {
  loading: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().bool),
  children: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().node),
  ..._PreviewBlock__WEBPACK_IMPORTED_MODULE_0__["default"].propTypes
};

/***/ }),

/***/ "./js/components/Logo.js":
/*!*******************************!*\
  !*** ./js/components/Logo.js ***!
  \*******************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _svg_graphics_logo_g_svg__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/svg/graphics/logo-g.svg */ "./svg/graphics/logo-g.svg");
/* harmony import */ var _svg_graphics_logo_sitekit_svg__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/svg/graphics/logo-sitekit.svg */ "./svg/graphics/logo-sitekit.svg");
/* harmony import */ var _VisuallyHidden__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./VisuallyHidden */ "./js/components/VisuallyHidden.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Logo component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */




function Logo() {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsxs)("div", {
    className: "googlesitekit-logo",
    "aria-hidden": "true",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(_svg_graphics_logo_g_svg__WEBPACK_IMPORTED_MODULE_1__["default"], {
      className: "googlesitekit-logo__logo-g",
      height: "34",
      width: "32"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(_svg_graphics_logo_sitekit_svg__WEBPACK_IMPORTED_MODULE_2__["default"], {
      className: "googlesitekit-logo__logo-sitekit",
      height: "26",
      width: "99"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(_VisuallyHidden__WEBPACK_IMPORTED_MODULE_3__["default"], {
      children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Site Kit by Google Logo', 'google-site-kit')
    })]
  });
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Logo);

/***/ }),

/***/ "./js/components/ModalDialog.js":
/*!**************************************!*\
  !*** ./js/components/ModalDialog.js ***!
  \**************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_compose__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @wordpress/compose */ "../node_modules/@wordpress/compose/build-module/hooks/use-instance-id/index.js");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/@wordpress/element/build-module/create-interpolate-element.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! googlesitekit-components */ "googlesitekit-components");
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_components__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _svg_icons_warning_svg__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/svg/icons/warning.svg */ "./svg/icons/warning.svg");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * ModalDialog component.
 *
 * Site Kit by Google, Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * WordPress dependencies
 */




/**
 * Internal dependencies
 */



function ModalDialog({
  className = '',
  dialogActive = false,
  handleCancel = null,
  onOpen = null,
  onClose = null,
  title = null,
  provides,
  handleConfirm,
  subtitle,
  confirmButton = null,
  dependentModules,
  danger = false,
  inProgress = false,
  small = false,
  medium = false,
  buttonLink = null
}) {
  const instanceID = (0,_wordpress_compose__WEBPACK_IMPORTED_MODULE_5__["default"])(ModalDialog);
  const describedByID = `googlesitekit-dialog-description-${instanceID}`;
  const hasProvides = !!(provides && provides.length);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsxs)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_2__.Dialog, {
    open: dialogActive,
    onOpen: onOpen,
    onClose: onClose,
    "aria-describedby": hasProvides ? describedByID : undefined,
    tabIndex: "-1",
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()(className, {
      'googlesitekit-dialog-sm': small,
      'googlesitekit-dialog-md': medium
    }),
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsxs)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_2__.DialogTitle, {
      children: [danger && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(_svg_icons_warning_svg__WEBPACK_IMPORTED_MODULE_3__["default"], {
        width: 28,
        height: 28
      }), title]
    }),
    // Ensure we don't render anything at all if subtitle is falsy, as Dialog expects all its children to be elements and a falsy value will result in an error.
    subtitle ? /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("p", {
      className: "mdc-dialog__lead",
      children: subtitle
    }) : [], /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsxs)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_2__.DialogContent, {
      children: [hasProvides && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("section", {
        id: describedByID,
        className: "mdc-dialog__provides",
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("ul", {
          className: "mdc-list mdc-list--underlined mdc-list--non-interactive",
          children: provides.map(attribute => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("li", {
            className: "mdc-list-item",
            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("span", {
              className: "mdc-list-item__text",
              children: attribute
            })
          }, attribute))
        })
      }), dependentModules && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("p", {
        className: "mdc-dialog__dependencies",
        children: (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__["default"])((0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.sprintf)(/* translators: %s is replaced with the dependent modules. */
        (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('<strong>Note:</strong> %s', 'google-site-kit'), dependentModules), {
          strong: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("strong", {})
        })
      })]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsxs)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_2__.DialogFooter, {
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_2__.Button, {
        className: "mdc-dialog__cancel-button",
        onClick: handleCancel,
        disabled: inProgress,
        tertiary: true,
        children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Cancel', 'google-site-kit')
      }), buttonLink ? /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_2__.Button, {
        href: buttonLink,
        onClick: handleConfirm,
        target: "_blank",
        danger: danger,
        children: confirmButton
      }) : /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_2__.SpinnerButton, {
        onClick: handleConfirm,
        danger: danger,
        disabled: inProgress,
        isSaving: inProgress,
        children: confirmButton || (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Disconnect', 'google-site-kit')
      })]
    })]
  });
}
ModalDialog.displayName = 'Dialog';
ModalDialog.propTypes = {
  className: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().string),
  dialogActive: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().bool),
  handleDialog: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().func),
  handleConfirm: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().func).isRequired,
  onOpen: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().func),
  onClose: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().func),
  title: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().string),
  confirmButton: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().string),
  danger: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().bool),
  small: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().bool),
  medium: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().bool),
  buttonLink: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().string)
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ModalDialog);

/***/ }),

/***/ "./js/components/ModuleDashboardEffects.js":
/*!*************************************************!*\
  !*** ./js/components/ModuleDashboardEffects.js ***!
  \*************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ ModuleDashboardEffects)
/* harmony export */ });
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/googlesitekit/modules/datastore/constants */ "./js/googlesitekit/modules/datastore/constants.js");
/* harmony import */ var _js_hooks_useDashboardType__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/hooks/useDashboardType */ "./js/hooks/useDashboardType.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * ModuleDashboardEffects component.
 *
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Internal dependencies
 */




const dashboardTypeComponentMap = {
  [_js_hooks_useDashboardType__WEBPACK_IMPORTED_MODULE_2__.DASHBOARD_TYPE_MAIN]: 'DashboardMainEffectComponent',
  [_js_hooks_useDashboardType__WEBPACK_IMPORTED_MODULE_2__.DASHBOARD_TYPE_ENTITY]: 'DashboardEntityEffectComponent'
};
function ModuleDashboardEffects() {
  const dashboardType = (0,_js_hooks_useDashboardType__WEBPACK_IMPORTED_MODULE_2__["default"])();
  const modules = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useSelect)(select => select(_js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_1__.CORE_MODULES).getModules());
  if (!modules) {
    return null;
  }
  const moduleComponentKey = dashboardTypeComponentMap[dashboardType];
  return Object.values(modules).reduce((elements, module) => {
    const ModuleEffectComponent = module[moduleComponentKey];
    if (!module.active || !ModuleEffectComponent) {
      return elements;
    }
    return [...elements, /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(ModuleEffectComponent, {}, module.slug)];
  }, []);
}

/***/ }),

/***/ "./js/components/ModuleIcon.js":
/*!*************************************!*\
  !*** ./js/components/ModuleIcon.js ***!
  \*************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ ModuleIcon)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/googlesitekit/modules/datastore/constants */ "./js/googlesitekit/modules/datastore/constants.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * ModuleIcon component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * Internal dependencies
 */



function ModuleIcon({
  slug,
  size,
  ...props
}) {
  const ModuleIconComponent = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useSelect)(select => select(_js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_1__.CORE_MODULES).getModuleIcon(slug));
  if (!ModuleIconComponent) {
    return null;
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)(ModuleIconComponent, {
    width: size,
    height: size,
    ...props
  });
}
ModuleIcon.propTypes = {
  slug: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string).isRequired,
  size: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().number)
};
ModuleIcon.defaultProps = {
  size: 33
};

/***/ }),

/***/ "./js/components/NewBadge.js":
/*!***********************************!*\
  !*** ./js/components/NewBadge.js ***!
  \***********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! googlesitekit-components */ "googlesitekit-components");
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_components__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _Badge__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./Badge */ "./js/components/Badge.js");
/* harmony import */ var _Link__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./Link */ "./js/components/Link.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * NewBadge component.
 *
 * Site Kit by Google, Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */




function NewBadge({
  tooltipTitle,
  learnMoreLink,
  forceOpen,
  hasLeftSpacing,
  hasNoSpacing,
  onLearnMoreClick = () => {}
}) {
  const badgeComponent = /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_Badge__WEBPACK_IMPORTED_MODULE_3__["default"], {
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-new-badge', {
      'googlesitekit-new-badge--has-no-spacing': hasNoSpacing
    }),
    label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('New', 'google-site-kit'),
    hasLeftSpacing: hasLeftSpacing
  });
  if (!tooltipTitle) {
    return badgeComponent;
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_2__.Tooltip, {
    tooltipClassName: "googlesitekit-new-badge__tooltip",
    title: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)(_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.Fragment, {
      children: [tooltipTitle, /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("br", {}), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_Link__WEBPACK_IMPORTED_MODULE_4__["default"], {
        href: learnMoreLink,
        onClick: onLearnMoreClick,
        external: true,
        hideExternalIndicator: true,
        children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Learn more', 'google-site-kit')
      })]
    }),
    placement: "top",
    enterTouchDelay: 0,
    leaveTouchDelay: 5000,
    open: forceOpen,
    interactive: true,
    children: badgeComponent
  });
}
NewBadge.propTypes = {
  tooltipTitle: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().string),
  learnMoreLink: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().string),
  forceOpen: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().bool),
  onLearnMoreClick: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().func),
  hasLeftSpacing: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().bool),
  hasNoSpacing: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().bool)
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (NewBadge);

/***/ }),

/***/ "./js/components/Notice/CTAButton.js":
/*!*******************************************!*\
  !*** ./js/components/Notice/CTAButton.js ***!
  \*******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ CTAButton)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! googlesitekit-components */ "googlesitekit-components");
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_components__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _svg_icons_external_svg__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/svg/icons/external.svg */ "./svg/icons/external.svg");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * Internal dependencies
 */



function CTAButton({
  label,
  disabled,
  inProgress,
  onClick,
  href,
  external,
  hideExternalIndicator
}) {
  let trailingIconToUse;
  if (external && !hideExternalIndicator) {
    trailingIconToUse = /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)(_svg_icons_external_svg__WEBPACK_IMPORTED_MODULE_1__["default"], {
      width: 14,
      height: 14
    });
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_0__.SpinnerButton, {
    className: "googlesitekit-notice__cta",
    disabled: disabled,
    isSaving: inProgress,
    onClick: onClick,
    href: href,
    target: external ? '_blank' : '_self',
    trailingIcon: trailingIconToUse,
    children: label
  });
}
CTAButton.propTypes = {
  label: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string).isRequired,
  disabled: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().bool),
  inProgress: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().bool),
  onClick: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().func),
  href: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  external: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().bool),
  hideExternalIndicator: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().bool)
};

/***/ }),

/***/ "./js/components/Notice/Description.js":
/*!*********************************************!*\
  !*** ./js/components/Notice/Description.js ***!
  \*********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Description)
/* harmony export */ });
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



function Description({
  className,
  children
}) {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("p", {
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-notice__description', className),
    children: children
  });
}
Description.propTypes = {
  className: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().string),
  children: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().node)
};

/***/ }),

/***/ "./js/components/Notice/DismissButton.js":
/*!***********************************************!*\
  !*** ./js/components/Notice/DismissButton.js ***!
  \***********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ DismissButton)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-components */ "googlesitekit-components");
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */


function DismissButton({
  label = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Got it', 'google-site-kit'),
  onClick,
  disabled
}) {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__.Button, {
    onClick: onClick,
    disabled: disabled,
    tertiary: true,
    children: label
  });
}
DismissButton.propTypes = {
  label: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  onClick: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().func).isRequired,
  disabled: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().bool)
};

/***/ }),

/***/ "./js/components/Notice/Icon.js":
/*!**************************************!*\
  !*** ./js/components/Notice/Icon.js ***!
  \**************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Icon)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _svg_icons_check_fill_svg__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @/svg/icons/check-fill.svg */ "./svg/icons/check-fill.svg");
/* harmony import */ var _svg_icons_warning_notice_svg__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/svg/icons/warning-notice.svg */ "./svg/icons/warning-notice.svg");
/* harmony import */ var _svg_icons_star_fill_svg__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/svg/icons/star-fill.svg */ "./svg/icons/star-fill.svg");
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./constants */ "./js/components/Notice/constants.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * Internal dependencies
 */





const typeIconMap = {
  [_constants__WEBPACK_IMPORTED_MODULE_3__.TYPES.NEW]: _svg_icons_star_fill_svg__WEBPACK_IMPORTED_MODULE_2__["default"],
  [_constants__WEBPACK_IMPORTED_MODULE_3__.TYPES.SUCCESS]: _svg_icons_check_fill_svg__WEBPACK_IMPORTED_MODULE_0__["default"],
  [_constants__WEBPACK_IMPORTED_MODULE_3__.TYPES.INFO]: _svg_icons_warning_notice_svg__WEBPACK_IMPORTED_MODULE_1__["default"],
  [_constants__WEBPACK_IMPORTED_MODULE_3__.TYPES.WARNING]: _svg_icons_warning_notice_svg__WEBPACK_IMPORTED_MODULE_1__["default"],
  [_constants__WEBPACK_IMPORTED_MODULE_3__.TYPES.ERROR]: _svg_icons_warning_notice_svg__WEBPACK_IMPORTED_MODULE_1__["default"]
};
function Icon({
  type
}) {
  const IconComponent = typeIconMap[type] || _svg_icons_warning_notice_svg__WEBPACK_IMPORTED_MODULE_1__["default"];
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(IconComponent, {
    width: 24,
    height: 24
  });
}
Icon.propTypes = {
  type: prop_types__WEBPACK_IMPORTED_MODULE_5___default().oneOf(Object.values(_constants__WEBPACK_IMPORTED_MODULE_3__.TYPES))
};

/***/ }),

/***/ "./js/components/Notice/Title.js":
/*!***************************************!*\
  !*** ./js/components/Notice/Title.js ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Title)
/* harmony export */ });
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



function Title({
  className,
  children
}) {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("p", {
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-notice__title', className),
    children: children
  });
}
Title.propTypes = {
  className: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().string),
  children: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().node)
};

/***/ }),

/***/ "./js/components/Notice/constants.js":
/*!*******************************************!*\
  !*** ./js/components/Notice/constants.js ***!
  \*******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   TYPES: () => (/* binding */ TYPES)
/* harmony export */ });
/**
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

const TYPES = {
  NEW: 'new',
  SUCCESS: 'success',
  WARNING: 'warning',
  INFO: 'info',
  ERROR: 'error'
};

/***/ }),

/***/ "./js/components/Notice/index.js":
/*!***************************************!*\
  !*** ./js/components/Notice/index.js ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _Icon__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Icon */ "./js/components/Notice/Icon.js");
/* harmony import */ var _Title__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./Title */ "./js/components/Notice/Title.js");
/* harmony import */ var _Description__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./Description */ "./js/components/Notice/Description.js");
/* harmony import */ var _CTAButton__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./CTAButton */ "./js/components/Notice/CTAButton.js");
/* harmony import */ var _DismissButton__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./DismissButton */ "./js/components/Notice/DismissButton.js");
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./constants */ "./js/components/Notice/constants.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */







const Notice = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_8__.forwardRef)(({
  className,
  title,
  description,
  dismissButton,
  ctaButton,
  type = _constants__WEBPACK_IMPORTED_MODULE_6__.TYPES.INFO,
  children,
  hideIcon
}, ref) => {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsxs)("div", {
    ref: ref,
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-notice', `googlesitekit-notice--${type}`, className),
    children: [!hideIcon && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)("div", {
      className: "googlesitekit-notice__icon",
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_Icon__WEBPACK_IMPORTED_MODULE_1__["default"], {
        type: type
      })
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsxs)("div", {
      className: "googlesitekit-notice__content",
      children: [title && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_Title__WEBPACK_IMPORTED_MODULE_2__["default"], {
        children: title
      }), description && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_Description__WEBPACK_IMPORTED_MODULE_3__["default"], {
        children: description
      })]
    }), (dismissButton?.label || dismissButton?.onClick || ctaButton?.label && (ctaButton?.onClick || ctaButton?.href) || children) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsxs)("div", {
      className: "googlesitekit-notice__action",
      children: [children, (dismissButton?.label || dismissButton?.onClick) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_DismissButton__WEBPACK_IMPORTED_MODULE_5__["default"], {
        label: dismissButton.label,
        onClick: dismissButton.onClick,
        disabled: dismissButton.disabled
      }), ctaButton?.label && (ctaButton?.onClick || ctaButton?.href) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_CTAButton__WEBPACK_IMPORTED_MODULE_4__["default"], {
        label: ctaButton.label,
        onClick: ctaButton.onClick,
        inProgress: ctaButton.inProgress,
        disabled: ctaButton.disabled,
        href: ctaButton.href,
        external: ctaButton.external,
        hideExternalIndicator: ctaButton.hideExternalIndicator
      })]
    })]
  });
});
Notice.TYPES = _constants__WEBPACK_IMPORTED_MODULE_6__.TYPES;
Notice.propTypes = {
  className: (prop_types__WEBPACK_IMPORTED_MODULE_9___default().string),
  title: prop_types__WEBPACK_IMPORTED_MODULE_9___default().oneOfType([(prop_types__WEBPACK_IMPORTED_MODULE_9___default().string), (prop_types__WEBPACK_IMPORTED_MODULE_9___default().object)]),
  description: (prop_types__WEBPACK_IMPORTED_MODULE_9___default().node),
  type: prop_types__WEBPACK_IMPORTED_MODULE_9___default().oneOf(Object.values(_constants__WEBPACK_IMPORTED_MODULE_6__.TYPES)),
  dismissButton: prop_types__WEBPACK_IMPORTED_MODULE_9___default().shape(_DismissButton__WEBPACK_IMPORTED_MODULE_5__["default"].propTypes),
  ctaButton: prop_types__WEBPACK_IMPORTED_MODULE_9___default().shape({
    ..._CTAButton__WEBPACK_IMPORTED_MODULE_4__["default"].propTypes,
    label: (prop_types__WEBPACK_IMPORTED_MODULE_9___default().string) // CTAButton label should not be required for this parent component.
  }),
  children: (prop_types__WEBPACK_IMPORTED_MODULE_9___default().node),
  hideIcon: (prop_types__WEBPACK_IMPORTED_MODULE_9___default().bool)
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Notice);

/***/ }),

/***/ "./js/components/NotificationFromServer.js":
/*!*************************************************!*\
  !*** ./js/components/NotificationFromServer.js ***!
  \*************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _js_googlesitekit_notifications_components_layout_BannerNotification__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @/js/googlesitekit/notifications/components/layout/BannerNotification */ "./js/googlesitekit/notifications/components/layout/BannerNotification.js");
/* harmony import */ var _js_util__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/util */ "./js/util/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * NotificationFromServer component.
 *
 * Component used to render notifications from the server, such as
 * those from `CORE_SITE` or `MODULES_*` data stores.
 *
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */



/**
 * Maps props received from the server (e.g. from a `select( CORE_SITE ).getNotifications()`
 * selector call) to the props expected by the new BannerNotification component.
 *
 * @since 1.157.0
 *
 * @param {Object}     props                     Component props.
 * @param {string}     props.id                  Notification ID/slug.
 * @param {?ReactNode} props.titleIcon           Icon to display above the title.
 * @param {string}     props.title               Notification title/heading.
 * @param {?ReactNode} props.content             Description for notification.
 * @param {string}     props.ctaLabel            Label for the call-to-action button.
 * @param {?string}    props.ctaTarget           `target` for the call-to-action link, e.g. `_blank`. Optional.
 * @param {?string}    props.ctaURL              URL for the call-to-action link.
 * @param {?boolean}   props.dismissible         Whether the notification is dismissible. Optional.
 * @param {?string}    props.dismissLabel        Label for the dismiss button. Optional.
 * @param {?string}    props.learnMoreLabel      Label for the "Learn More" link. Optional.
 * @param {?string}    props.learnMoreURL        URL for the "Learn More" link. Optional.
 * @param {?Function}  props.onCTAClick          Callback to run when CTA is clicked. Optional.
 * @param {?Function}  props.onDismissClick      Callback to run when the Dismiss button is clicked. Optional.
 * @param {?Object}    props.gaTrackingEventArgs Custom GA tracking event category and label options. Optional.
 * @return {JSX.Element} Notification component.
 */

function NotificationFromServer({
  id,
  titleIcon,
  title,
  content,
  ctaLabel,
  ctaTarget,
  ctaURL,
  dismissible,
  dismissLabel,
  learnMoreLabel,
  learnMoreURL,
  onCTAClick,
  onDismissClick,
  gaTrackingEventArgs
}) {
  // Notifications from the server should not be dismissed permanently in the database.
  // CoreSiteBannerNotifications are "marked as accepted/dismissed" on the server.
  // AdSense Alerts are not dismissed permanently either, they keep coming back until the
  // issue that raises the alert is resolved. Thus we expire the dismissal after an hour,
  // which was the behaviour prevalent in the legacy BannerNotification component that cached
  // dismissals for an hour in browser storage.
  const dismissOptions = {
    expiresInSeconds: _js_util__WEBPACK_IMPORTED_MODULE_1__.HOUR_IN_SECONDS
  };
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)(_js_googlesitekit_notifications_components_layout_BannerNotification__WEBPACK_IMPORTED_MODULE_0__["default"], {
    notificationID: id,
    type: _js_googlesitekit_notifications_components_layout_BannerNotification__WEBPACK_IMPORTED_MODULE_0__.TYPES.WARNING,
    titleIcon: titleIcon ? titleIcon : undefined,
    title: title,
    description: content,
    learnMoreLink: learnMoreURL ? {
      label: learnMoreLabel,
      href: learnMoreURL
    } : undefined,
    ctaButton: {
      label: ctaLabel,
      href: ctaURL,
      target: ctaTarget,
      onClick: onCTAClick,
      dismissOptions
    },
    dismissButton: dismissible ? {
      label: dismissLabel,
      onClick: onDismissClick,
      dismissOptions
    } : undefined,
    gaTrackingEventArgs: gaTrackingEventArgs
  });
}
NotificationFromServer.propTypes = {
  id: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string).isRequired,
  title: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string).isRequired,
  content: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().node),
  ctaLabel: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  ctaTarget: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  ctaURL: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  dismissible: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().bool),
  dismissLabel: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  learnMoreLabel: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  learnMoreURL: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  onCTAClick: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().func),
  onDismissClick: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().func),
  gaTrackingEventArgs: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().object)
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (NotificationFromServer);

/***/ }),

/***/ "./js/components/Null.js":
/*!*******************************!*\
  !*** ./js/components/Null.js ***!
  \*******************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Null)
/* harmony export */ });
/**
 * Null component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

function Null() {
  return null;
}

/***/ }),

/***/ "./js/components/OptIn.js":
/*!********************************!*\
  !*** ./js/components/OptIn.js ***!
  \********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ OptIn)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_12___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_12__);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/@wordpress/element/build-module/create-interpolate-element.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! googlesitekit-components */ "googlesitekit-components");
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_components__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/googlesitekit/datastore/user/constants */ "./js/googlesitekit/datastore/user/constants.js");
/* harmony import */ var _js_util_tracking__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/util/tracking */ "./js/util/tracking/index.js");
/* harmony import */ var _Link__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./Link */ "./js/components/Link.js");
/* harmony import */ var _js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @/js/hooks/useViewContext */ "./js/hooks/useViewContext.js");
/* harmony import */ var _js_hooks_useDebounce__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @/js/hooks/useDebounce */ "./js/hooks/useDebounce.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * OptIn component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */








function OptIn({
  id = 'googlesitekit-opt-in',
  name = 'optIn',
  className,
  trackEventCategory,
  alignLeftCheckbox = false
}) {
  const [checked, setChecked] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_10__.useState)();
  const enabled = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.useSelect)(select => select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_4__.CORE_USER).isTrackingEnabled());
  const error = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.useSelect)(select => select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_4__.CORE_USER).getErrorForAction('setTrackingEnabled', [!enabled]));
  const {
    setTrackingEnabled
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.useDispatch)(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_4__.CORE_USER);
  const viewContext = (0,_js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_7__["default"])();
  const handleOptIn = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_10__.useCallback)(async isChecked => {
    const {
      response,
      error: responseError
    } = await setTrackingEnabled(isChecked);
    if (!responseError) {
      (0,_js_util_tracking__WEBPACK_IMPORTED_MODULE_5__.toggleTracking)(response.enabled);
      if (response.enabled) {
        (0,_js_util_tracking__WEBPACK_IMPORTED_MODULE_5__.trackEvent)(trackEventCategory || viewContext, 'tracking_optin');
      }
    } else {
      setChecked(enabled);
    }
  }, [enabled, setTrackingEnabled, trackEventCategory, viewContext]);
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_10__.useEffect)(() => {
    if (enabled !== undefined && checked === undefined) {
      setChecked(enabled);
    }
  }, [enabled, checked]);
  const debouncedHandleOptIn = (0,_js_hooks_useDebounce__WEBPACK_IMPORTED_MODULE_8__.useDebounce)(handleOptIn, 300);
  const handleCheck = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_10__.useCallback)(e => {
    const isChecked = e.target.checked;
    setChecked(isChecked);
    debouncedHandleOptIn(isChecked);
  }, [debouncedHandleOptIn]);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsxs)("div", {
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-opt-in', className),
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_3__.Checkbox, {
      id: id,
      name: name,
      value: "1",
      checked: checked,
      onChange: handleCheck,
      loading: enabled === undefined,
      alignLeft: alignLeftCheckbox,
      children: (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_11__["default"])((0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('<span>Help us improve Site Kit by sharing anonymous usage data.</span> <span>All collected data is treated in accordance with the <a>Google Privacy Policy.</a></span>', 'google-site-kit'), {
        a: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)(_Link__WEBPACK_IMPORTED_MODULE_6__["default"], {
          href: "https://policies.google.com/privacy",
          external: true
        }, "link"),
        span: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)("span", {})
      })
    }), error?.message && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)("div", {
      className: "googlesitekit-error-text",
      children: error?.message
    })]
  });
}
OptIn.propTypes = {
  id: (prop_types__WEBPACK_IMPORTED_MODULE_12___default().string),
  name: (prop_types__WEBPACK_IMPORTED_MODULE_12___default().string),
  className: (prop_types__WEBPACK_IMPORTED_MODULE_12___default().string),
  trackEventCategory: (prop_types__WEBPACK_IMPORTED_MODULE_12___default().string),
  alignLeftCheckbox: (prop_types__WEBPACK_IMPORTED_MODULE_12___default().bool)
};

/***/ }),

/***/ "./js/components/OverlayCard/Body.js":
/*!*******************************************!*\
  !*** ./js/components/OverlayCard/Body.js ***!
  \*******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Body)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @/js/hooks/useBreakpoint */ "./js/hooks/useBreakpoint.js");
/* harmony import */ var _Title__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Title */ "./js/components/OverlayCard/Title.js");
/* harmony import */ var _Description__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./Description */ "./js/components/OverlayCard/Description.js");
/* harmony import */ var _DismissButton__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./DismissButton */ "./js/components/OverlayCard/DismissButton.js");
/* harmony import */ var _CTAButton__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./CTAButton */ "./js/components/OverlayCard/CTAButton.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * OverlayCard Body component.
 *
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */






function Body({
  title,
  description,
  ctaButton,
  dismissButton,
  GraphicDesktop,
  GraphicMobile
}) {
  const breakpoint = (0,_js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_0__.useBreakpoint)();
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)(_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.Fragment, {
    children: [breakpoint !== _js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_0__.BREAKPOINT_SMALL && GraphicDesktop && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("div", {
      className: "googlesitekit-overlay-card__graphic",
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(GraphicDesktop, {})
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)("div", {
      className: "googlesitekit-overlay-card__body",
      children: [title && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_Title__WEBPACK_IMPORTED_MODULE_1__["default"], {
        children: title
      }), description && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_Description__WEBPACK_IMPORTED_MODULE_2__["default"], {
        children: description
      })]
    }), (ctaButton || dismissButton) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)("div", {
      className: "googlesitekit-overlay-card__actions",
      children: [dismissButton && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_DismissButton__WEBPACK_IMPORTED_MODULE_3__["default"], {
        ...dismissButton
      }), ctaButton && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_CTAButton__WEBPACK_IMPORTED_MODULE_4__["default"], {
        ...ctaButton
      })]
    }), breakpoint === _js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_0__.BREAKPOINT_SMALL && GraphicMobile && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(GraphicMobile, {})]
  });
}
Body.propTypes = {
  title: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().node),
  description: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().node),
  ctaButton: prop_types__WEBPACK_IMPORTED_MODULE_7___default().shape({
    ..._DismissButton__WEBPACK_IMPORTED_MODULE_3__.buttonProps,
    href: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().string),
    target: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().string),
    trailingIcon: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().element)
  }),
  dismissButton: prop_types__WEBPACK_IMPORTED_MODULE_7___default().shape({
    ..._DismissButton__WEBPACK_IMPORTED_MODULE_3__.buttonProps
  }),
  GraphicDesktop: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().elementType),
  GraphicMobile: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().elementType)
};

/***/ }),

/***/ "./js/components/OverlayCard/CTAButton.js":
/*!************************************************!*\
  !*** ./js/components/OverlayCard/CTAButton.js ***!
  \************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ CTAButton)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! googlesitekit-components */ "googlesitekit-components");
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_components__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _DismissButton__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./DismissButton */ "./js/components/OverlayCard/DismissButton.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * OverlayCard CTAButton component.
 *
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * Internal dependencies
 */



function CTAButton(props) {
  const {
    label,
    ...otherProps
  } = props;
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_0__.Button, {
    ...otherProps,
    children: label
  });
}
CTAButton.propTypes = {
  ..._DismissButton__WEBPACK_IMPORTED_MODULE_1__.buttonProps,
  href: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  target: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  trailingIcon: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().object)
};

/***/ }),

/***/ "./js/components/OverlayCard/Description.js":
/*!**************************************************!*\
  !*** ./js/components/OverlayCard/Description.js ***!
  \**************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Description)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * OverlayCard Description component.
 *
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


function Description({
  children
}) {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("p", {
    className: "googlesitekit-overlay-card__description",
    children: children
  });
}
Description.propTypes = {
  children: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().node).isRequired
};

/***/ }),

/***/ "./js/components/OverlayCard/DismissButton.js":
/*!****************************************************!*\
  !*** ./js/components/OverlayCard/DismissButton.js ***!
  \****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   buttonProps: () => (/* binding */ buttonProps),
/* harmony export */   "default": () => (/* binding */ DismissButton)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-components */ "googlesitekit-components");
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * OverlayCard DismissButton component.
 *
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */


function DismissButton({
  label = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Maybe later', 'google-site-kit'),
  onClick,
  disabled
}) {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__.Button, {
    onClick: onClick,
    disabled: disabled,
    tertiary: true,
    children: label
  });
}
const buttonProps = {
  label: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  onClick: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().func),
  disabled: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().bool)
};
DismissButton.propTypes = buttonProps;

/***/ }),

/***/ "./js/components/OverlayCard/Title.js":
/*!********************************************!*\
  !*** ./js/components/OverlayCard/Title.js ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Title)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _js_components_Typography__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @/js/components/Typography */ "./js/components/Typography/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * OverlayCard Title component.
 *
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



function Title({
  children
}) {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)(_js_components_Typography__WEBPACK_IMPORTED_MODULE_0__["default"], {
    as: "h3",
    size: "medium",
    type: "title",
    className: "googlesitekit-overlay-card__title",
    children: children
  });
}
Title.propTypes = {
  children: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().node).isRequired
};

/***/ }),

/***/ "./js/components/OverlayCard/index.js":
/*!********************************************!*\
  !*** ./js/components/OverlayCard/index.js ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ OverlayCard)
/* harmony export */ });
/* harmony import */ var _material_ui_core__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @material-ui/core */ "../node_modules/@material-ui/core/esm/Slide/Slide.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/hooks/useBreakpoint */ "./js/hooks/useBreakpoint.js");
/* harmony import */ var _Body__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./Body */ "./js/components/OverlayCard/Body.js");
/* harmony import */ var _DismissButton__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./DismissButton */ "./js/components/OverlayCard/DismissButton.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * OverlayCard component.
 *
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */




/**
 * Internal dependencies
 */




function OverlayCard(props) {
  const {
    visible,
    className,
    ...cardProps
  } = props;
  const breakpoint = (0,_js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_1__.useBreakpoint)();
  if (!visible) {
    return null;
  }
  const body = /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("div", {
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-overlay-card', className),
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(_Body__WEBPACK_IMPORTED_MODULE_2__["default"], {
      ...cardProps
    })
  });
  if (breakpoint === _js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_1__.BREAKPOINT_SMALL) {
    return body;
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(_material_ui_core__WEBPACK_IMPORTED_MODULE_5__["default"], {
    direction: "up",
    in: visible,
    children: body
  });
}
OverlayCard.propTypes = {
  className: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().string),
  title: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().string),
  description: prop_types__WEBPACK_IMPORTED_MODULE_6___default().oneOfType([(prop_types__WEBPACK_IMPORTED_MODULE_6___default().string), (prop_types__WEBPACK_IMPORTED_MODULE_6___default().object)]),
  ctaButton: prop_types__WEBPACK_IMPORTED_MODULE_6___default().shape({
    ..._DismissButton__WEBPACK_IMPORTED_MODULE_3__.buttonProps,
    href: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().string),
    target: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().string),
    trailingIcon: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().object)
  }),
  dismissButton: prop_types__WEBPACK_IMPORTED_MODULE_6___default().shape(_DismissButton__WEBPACK_IMPORTED_MODULE_3__.buttonProps),
  GraphicDesktop: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().elementType),
  GraphicMobile: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().elementType),
  visible: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().bool)
};
OverlayCard.defaultProps = {
  visible: false
};

/***/ }),

/***/ "./js/components/PermissionsModal/AuthenticatedPermissionsModal.js":
/*!*************************************************************************!*\
  !*** ./js/components/PermissionsModal/AuthenticatedPermissionsModal.js ***!
  \*************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _js_components_RefocusableModalDialog__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/components/RefocusableModalDialog */ "./js/components/RefocusableModalDialog.js");
/* harmony import */ var _js_googlesitekit_datastore_forms_constants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/googlesitekit/datastore/forms/constants */ "./js/googlesitekit/datastore/forms/constants.js");
/* harmony import */ var _js_googlesitekit_datastore_location_constants__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/googlesitekit/datastore/location/constants */ "./js/googlesitekit/datastore/location/constants.js");
/* harmony import */ var _js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/googlesitekit/datastore/user/constants */ "./js/googlesitekit/datastore/user/constants.js");
/* harmony import */ var _js_googlesitekit_data_create_snapshot_store__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @/js/googlesitekit/data/create-snapshot-store */ "./js/googlesitekit/data/create-snapshot-store.js");
/* harmony import */ var _js_components_Portal__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @/js/components/Portal */ "./js/components/Portal.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * AuthenticatedPermissionsModal component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */








function AuthenticatedPermissionsModal() {
  const registry = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useRegistry)();
  const permissionsError = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_5__.CORE_USER).getPermissionScopeError());
  const unsatisfiedScopes = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_5__.CORE_USER).getUnsatisfiedScopes());
  const connectURL = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_5__.CORE_USER).getConnectURL({
    additionalScopes: permissionsError?.data?.scopes,
    redirectURL: permissionsError?.data?.redirectURL || __webpack_require__.g.location.href,
    errorRedirectURL: permissionsError?.data?.errorRedirectURL
  }));
  const {
    clearPermissionScopeError
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useDispatch)(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_5__.CORE_USER);
  const {
    navigateTo
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useDispatch)(_js_googlesitekit_datastore_location_constants__WEBPACK_IMPORTED_MODULE_4__.CORE_LOCATION);
  const {
    setValues
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useDispatch)(_js_googlesitekit_datastore_forms_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_FORMS);
  const onCancel = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.useCallback)(() => {
    clearPermissionScopeError();
  }, [clearPermissionScopeError]);
  const onConfirm = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.useCallback)(async () => {
    // Temporary store permissions error, so data like `scopes` and `redirectURL`
    // can be used in `Permission error` notification.
    setValues(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_5__.FORM_TEMPORARY_PERSIST_PERMISSION_ERROR, {
      permissionsError
    });
    // If we have a datastores to snapshot before navigating away to the
    // authorization page, do that first.
    await (0,_js_googlesitekit_data_create_snapshot_store__WEBPACK_IMPORTED_MODULE_6__.snapshotAllStores)(registry);

    // Navigate to the authorization page.
    navigateTo(connectURL);
  }, [registry, connectURL, navigateTo, permissionsError, setValues]);
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.useEffect)(() => {
    // If error has flag to skip the modal, redirect to the authorization
    // page immediately without prompting the user, essentially short-
    // circuiting to the confirm step.
    async function confirmIfSkipModal() {
      if (permissionsError?.data?.skipModal && permissionsError?.data?.scopes?.length) {
        await onConfirm();
      }
    }
    confirmIfSkipModal();
  }, [onConfirm, permissionsError]);
  if (!permissionsError) {
    return null;
  }

  // If there aren't any scopes for us to request, there's no reason to show
  // the modal. Log a console warning if this happens and return `null`.
  if (!permissionsError?.data?.scopes?.length) {
    __webpack_require__.g.console.warn('permissionsError lacks scopes array to use for redirect, so not showing the PermissionsModal. permissionsError was:', permissionsError);
    return null;
  }
  if (permissionsError?.data?.skipModal) {
    return null;
  }
  if (unsatisfiedScopes && permissionsError?.data?.scopes.every(scope => unsatisfiedScopes.includes(scope))) {
    return null;
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(_js_components_Portal__WEBPACK_IMPORTED_MODULE_7__["default"], {
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(_js_components_RefocusableModalDialog__WEBPACK_IMPORTED_MODULE_2__["default"], {
      title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Additional Permissions Required', 'google-site-kit'),
      subtitle: permissionsError.message,
      confirmButton: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Proceed', 'google-site-kit'),
      handleConfirm: onConfirm,
      handleCancel: onCancel,
      onClose: onCancel,
      dialogActive: true,
      medium: true
    })
  });
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (AuthenticatedPermissionsModal);

/***/ }),

/***/ "./js/components/PermissionsModal/index.js":
/*!*************************************************!*\
  !*** ./js/components/PermissionsModal/index.js ***!
  \*************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _AuthenticatedPermissionsModal__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./AuthenticatedPermissionsModal */ "./js/components/PermissionsModal/AuthenticatedPermissionsModal.js");
/* harmony import */ var _js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/googlesitekit/datastore/user/constants */ "./js/googlesitekit/datastore/user/constants.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * PermissionsModal component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Internal dependencies
 */




function PermissionsModal() {
  const isAuthenticated = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useSelect)(select => select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_2__.CORE_USER).isAuthenticated());
  if (isAuthenticated) {
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_AuthenticatedPermissionsModal__WEBPACK_IMPORTED_MODULE_1__["default"], {});
  }
  return null;
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (PermissionsModal);

/***/ }),

/***/ "./js/components/Portal.js":
/*!*********************************!*\
  !*** ./js/components/Portal.js ***!
  \*********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_use__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react-use */ "../node_modules/react-use/esm/useEffectOnce.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react-dom/index.js");
/**
 * Portal component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * WordPress dependencies
 */

function Portal({
  children,
  slug
}) {
  // Using state as we need `el` to not change when the component re-renders
  const [el] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.useState)(document.createElement('div'));
  (0,react_use__WEBPACK_IMPORTED_MODULE_1__["default"])(() => {
    if (slug) {
      el.classList.add(`googlesitekit-portal-${slug}`);
    }
    const root = document.querySelector('.googlesitekit-plugin') || document.body;
    root.appendChild(el);
    return () => root.removeChild(el);
  });
  return (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.createPortal)(children, el);
}
Portal.propTypes = {
  slug: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  children: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().node)
};
Portal.defaultProps = {
  slug: '',
  children: null
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Portal);

/***/ }),

/***/ "./js/components/PostSearcherAutoSuggest.js":
/*!**************************************************!*\
  !*** ./js/components/PostSearcherAutoSuggest.js ***!
  \**************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ PostSearcherAutoSuggest)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var _reach_combobox__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @reach/combobox */ "../node_modules/@reach/combobox/dist/combobox.esm.js");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_keycodes__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @wordpress/keycodes */ "../node_modules/@wordpress/keycodes/build-module/index.js");
/* harmony import */ var googlesitekit_api__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! googlesitekit-api */ "googlesitekit-api");
/* harmony import */ var googlesitekit_api__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_api__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _js_hooks_useDebouncedState__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/hooks/useDebouncedState */ "./js/hooks/useDebouncedState.js");
/* harmony import */ var _js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/googlesitekit/datastore/site/constants */ "./js/googlesitekit/datastore/site/constants.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * PostSearcherAutoSuggest component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * WordPress dependencies
 */




/**
 * Internal dependencies
 */





function noop() {}
function PostSearcherAutoSuggest({
  id,
  match,
  setMatch,
  isLoading,
  showDropdown = true,
  setIsLoading = noop,
  setIsActive = noop,
  autoFocus,
  setCanSubmit = noop,
  onClose = noop,
  placeholder = ''
}) {
  const lastFetchRequest = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_7__.useRef)();
  const [searchTerm, setSearchTerm] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_7__.useState)('');

  // eslint-disable-next-line camelcase
  const postTitleFromMatch = match?.title;
  /**
   * As a fix for #4562, we should hide the loading indicator
   * after pressing enter/return key on a URL Entity Search Result.
   *
   * In the useEffect condition we check for:
   * `debouncedValue !== postTitleFromMatch` to set the loading state to true.
   * However, the `debouncedValue` is always delayed. Hence this condition is always true.
   * Hence the loading state is to true.
   * Therefore, we need to set the debounce delay/timer value to `0` if the
   * `searchTerm === postTitleFromMatch` to not to set the loading state to true.
   */
  const debouncedValue = (0,_js_hooks_useDebouncedState__WEBPACK_IMPORTED_MODULE_4__.useDebouncedState)(searchTerm, searchTerm === postTitleFromMatch ? 0 : 200);
  const [results, setResults] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_7__.useState)([]);
  const noResultsMessage = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('No results found', 'google-site-kit');
  const currentEntityTitle = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__.useSelect)(select => select(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_5__.CORE_SITE).getCurrentEntityTitle());
  const postTitle = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_7__.useRef)(null);
  const onFocus = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_7__.useCallback)(() => {
    setIsActive(true);
  }, [setIsActive]);
  const onBlur = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_7__.useCallback)(event => {
    if (!event.relatedTarget?.classList.contains('autocomplete__option--result')) {
      var _ref, _postTitle$current;
      setIsActive(false);
      setSearchTerm((_ref = (_postTitle$current = postTitle.current) !== null && _postTitle$current !== void 0 ? _postTitle$current : currentEntityTitle) !== null && _ref !== void 0 ? _ref : '');
    }
  }, [currentEntityTitle, setIsActive]);
  const onSelectCallback = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_7__.useCallback)(value => {
    if (Array.isArray(results) && value !== noResultsMessage) {
      const foundMatch = results.find(post => post.title.toLowerCase() === value.toLowerCase());
      if (foundMatch) {
        postTitle.current = foundMatch.title;
        setCanSubmit(true);
        setMatch(foundMatch);
        setSearchTerm(foundMatch.title);
      } else {
        postTitle.current = null;
      }
    } else {
      postTitle.current = null;
      setCanSubmit(false);
    }
  }, [results, setCanSubmit, setMatch, noResultsMessage, setSearchTerm]);
  const onInputChange = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_7__.useCallback)(event => {
    setCanSubmit(false);
    setSearchTerm(event.target.value);
  }, [setCanSubmit]);
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_7__.useEffect)(() => {
    if (debouncedValue !== '' && debouncedValue !== currentEntityTitle && debouncedValue?.toLowerCase() !== postTitleFromMatch?.toLowerCase()) {
      /**
       * Create AbortController instance to pass
       * the signal property to the API.get() method.
       */
      const controller = typeof AbortController === 'undefined' ? undefined : new AbortController();
      (async function request() {
        setIsLoading(true);
        const fetchPromise = (0,googlesitekit_api__WEBPACK_IMPORTED_MODULE_2__.get)('core', 'search', 'entity-search', {
          query: encodeURIComponent(debouncedValue)
        }, {
          useCache: false,
          signal: controller?.signal
        });
        lastFetchRequest.current = fetchPromise;
        try {
          const response = await fetchPromise;
          setResults(response);
        } catch {
          setResults(null);
        } finally {
          if (fetchPromise === lastFetchRequest.current) {
            setIsLoading(false);
          }
        }
      })();

      // Clean-up abort
      return () => controller?.abort();
    }
    // Return noop cleanup function to satisfy consistent-return rule.
    return () => {};
  }, [debouncedValue, setIsLoading, currentEntityTitle, postTitleFromMatch]);
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_7__.useEffect)(() => {
    if (!searchTerm) {
      setResults([]);
    }
  }, [searchTerm]);
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_7__.useEffect)(() => {
    if (currentEntityTitle) {
      setSearchTerm(currentEntityTitle);
    }
  }, [currentEntityTitle]);
  const inputRef = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_7__.useRef)();
  const onKeyDown = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_7__.useCallback)(e => {
    const input = inputRef.current;
    switch (e.keyCode) {
      case _wordpress_keycodes__WEBPACK_IMPORTED_MODULE_8__.HOME:
        if (input?.value) {
          e.preventDefault();
          input.selectionStart = 0;
          input.selectionEnd = 0;
        }
        break;
      case _wordpress_keycodes__WEBPACK_IMPORTED_MODULE_8__.END:
        if (input?.value) {
          e.preventDefault();
          input.selectionStart = input.value.length;
          input.selectionEnd = input.value.length;
        }
        break;
      default:
        break;
    }
    switch (e.keyCode) {
      case _wordpress_keycodes__WEBPACK_IMPORTED_MODULE_8__.ESCAPE:
        onClose();
        break;
      case _wordpress_keycodes__WEBPACK_IMPORTED_MODULE_8__.ENTER:
        onSelectCallback(searchTerm);
        break;
      default:
        break;
    }
  }, [onClose, onSelectCallback, searchTerm]);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)(_reach_combobox__WEBPACK_IMPORTED_MODULE_0__.Combobox, {
    className: "autocomplete__wrapper",
    onSelect: onSelectCallback,
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(_reach_combobox__WEBPACK_IMPORTED_MODULE_0__.ComboboxInput, {
      ref: inputRef,
      id: id,
      className: "autocomplete__input autocomplete__input--default",
      type: "text",
      onBlur: onBlur,
      onChange: onInputChange,
      onFocus: onFocus,
      placeholder: placeholder,
      onKeyDown: onKeyDown,
      value: searchTerm
      /* eslint-disable-next-line jsx-a11y/no-autofocus */,
      autoFocus: autoFocus
    }), !isLoading && showDropdown && debouncedValue !== currentEntityTitle && debouncedValue !== '' && results?.length === 0 && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(_reach_combobox__WEBPACK_IMPORTED_MODULE_0__.ComboboxPopover, {
      portal: false,
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(_reach_combobox__WEBPACK_IMPORTED_MODULE_0__.ComboboxList, {
        className: "autocomplete__menu autocomplete__menu--inline",
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(_reach_combobox__WEBPACK_IMPORTED_MODULE_0__.ComboboxOption, {
          value: noResultsMessage,
          className: "autocomplete__option autocomplete__option--no-results"
        })
      })
    }), showDropdown && debouncedValue !== '' && debouncedValue !== currentEntityTitle && results?.length > 0 && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(_reach_combobox__WEBPACK_IMPORTED_MODULE_0__.ComboboxPopover, {
      portal: false,
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(_reach_combobox__WEBPACK_IMPORTED_MODULE_0__.ComboboxList, {
        className: "autocomplete__menu autocomplete__menu--inline",
        children: results.map(({
          id: ID,
          title
        }) => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(_reach_combobox__WEBPACK_IMPORTED_MODULE_0__.ComboboxOption, {
          value: title,
          className: "autocomplete__option autocomplete__option--result"
        }, ID))
      })
    })]
  });
}
PostSearcherAutoSuggest.propTypes = {
  id: (prop_types__WEBPACK_IMPORTED_MODULE_9___default().string),
  match: (prop_types__WEBPACK_IMPORTED_MODULE_9___default().object),
  setCanSubmit: (prop_types__WEBPACK_IMPORTED_MODULE_9___default().func),
  setMatch: (prop_types__WEBPACK_IMPORTED_MODULE_9___default().func),
  isLoading: (prop_types__WEBPACK_IMPORTED_MODULE_9___default().bool),
  setIsLoading: (prop_types__WEBPACK_IMPORTED_MODULE_9___default().func),
  onKeyDown: (prop_types__WEBPACK_IMPORTED_MODULE_9___default().func),
  autoFocus: (prop_types__WEBPACK_IMPORTED_MODULE_9___default().bool),
  placeholder: (prop_types__WEBPACK_IMPORTED_MODULE_9___default().string)
};

/***/ }),

/***/ "./js/components/PreviewBlock.js":
/*!***************************************!*\
  !*** ./js/components/PreviewBlock.js ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/hooks/useBreakpoint */ "./js/hooks/useBreakpoint.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * PreviewBlock component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * Internal dependencies
 */


function PreviewBlock({
  className,
  width,
  height,
  shape,
  padding,
  smallWidth,
  smallHeight,
  tabletWidth,
  tabletHeight,
  desktopWidth,
  desktopHeight
}) {
  const breakpoint = (0,_js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_1__.useBreakpoint)();
  const blockDimensions = {
    width: {
      [_js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_1__.BREAKPOINT_SMALL]: smallWidth,
      [_js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_1__.BREAKPOINT_TABLET]: tabletWidth,
      [_js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_1__.BREAKPOINT_DESKTOP]: desktopWidth,
      [_js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_1__.BREAKPOINT_XLARGE]: desktopWidth
    },
    height: {
      [_js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_1__.BREAKPOINT_SMALL]: smallHeight,
      [_js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_1__.BREAKPOINT_TABLET]: tabletHeight,
      [_js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_1__.BREAKPOINT_DESKTOP]: desktopHeight,
      [_js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_1__.BREAKPOINT_XLARGE]: desktopWidth
    }
  };
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("div", {
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-preview-block', className, {
      'googlesitekit-preview-block--padding': padding
    }),
    style: {
      width: blockDimensions.width[breakpoint] || width,
      height: blockDimensions.height[breakpoint] || height
    },
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("div", {
      className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-preview-block__wrapper', {
        'googlesitekit-preview-block__wrapper--circle': shape === 'circular'
      })
    })
  });
}
PreviewBlock.propTypes = {
  className: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  width: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  height: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  shape: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  padding: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().bool),
  smallWidth: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  smallHeight: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  tabletWidth: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  tabletHeight: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  desktopWidth: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  desktopHeight: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string)
};
PreviewBlock.defaultProps = {
  className: undefined,
  width: '100px',
  height: '100px',
  shape: 'square',
  padding: false,
  smallWidth: undefined,
  smallHeight: undefined,
  tabletWidth: undefined,
  tabletHeight: undefined,
  desktopWidth: undefined,
  desktopHeight: undefined
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (PreviewBlock);

/***/ }),

/***/ "./js/components/RecoverableModules.js":
/*!*********************************************!*\
  !*** ./js/components/RecoverableModules.js ***!
  \*********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ RecoverableModules)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/googlesitekit/modules/datastore/constants */ "./js/googlesitekit/modules/datastore/constants.js");
/* harmony import */ var _notifications_CTA__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./notifications/CTA */ "./js/components/notifications/CTA.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * RecoverableModules component.
 *
 * Site Kit by Google, Copyright 2022 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */




function RecoverableModules({
  moduleSlugs
}) {
  const moduleNames = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => {
    const modules = select(_js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_2__.CORE_MODULES).getModules();
    if (modules === undefined) {
      return undefined;
    }
    return moduleSlugs.map(moduleSlug => modules[moduleSlug].name);
  });
  if (moduleNames === undefined) {
    return null;
  }
  const description = moduleNames.length === 1 ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.sprintf)(/* translators: %s: Module name */
  (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('%s data was previously shared by an admin who no longer has access. Please contact another admin to restore it.', 'google-site-kit'), moduleNames[0]) : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.sprintf)(/* translators: %s: List of module names */
  (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('The data for the following modules was previously shared by an admin who no longer has access: %s. Please contact another admin to restore it.', 'google-site-kit'), moduleNames.join((0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__._x)(', ', 'Recoverable modules', 'google-site-kit')));
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(_notifications_CTA__WEBPACK_IMPORTED_MODULE_3__["default"], {
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Data Unavailable', 'google-site-kit'),
    description: description
  });
}
RecoverableModules.propTypes = {
  moduleSlugs: prop_types__WEBPACK_IMPORTED_MODULE_5___default().arrayOf((prop_types__WEBPACK_IMPORTED_MODULE_5___default().string)).isRequired
};

/***/ }),

/***/ "./js/components/RefocusableModalDialog.js":
/*!*************************************************!*\
  !*** ./js/components/RefocusableModalDialog.js ***!
  \*************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _wordpress_compose__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @wordpress/compose */ "../node_modules/@wordpress/compose/build-module/hooks/use-previous/index.js");
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! googlesitekit-components */ "googlesitekit-components");
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_components__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _ModalDialog__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./ModalDialog */ "./js/components/ModalDialog.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * ModalDialog component.
 *
 * Site Kit by Google, Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */



// Use a singleton variable to store the clicked element before any dialog opens.
// We need to do this at the module level since the component may not be mounted
// when the user initiates an action that will open the dialog.

let previouslyClickedElement = null;

// Set up a global event listener to capture the clicked element before any dialog opens.
// This needs to happen at the module level to ensure it's set up before any user interaction.
function setupFocusTracker() {
  if (typeof __webpack_require__.g === 'undefined' || !__webpack_require__.g.document || __webpack_require__.g._googlesitekitModalFocusTrackerInitialized) {
    return;
  }
  function captureActiveElementOnClick(event) {
    // Store the clicked (or keyboard-activated) element when user clicks.
    // This will be the element that was clicked right before the dialog opens.
    const nearestParentButtonOrAnchor = event.target.closest('button, a, input');
    if (nearestParentButtonOrAnchor && !nearestParentButtonOrAnchor.classList.contains('mdc-dialog__cancel-button')) {
      previouslyClickedElement = nearestParentButtonOrAnchor;
    }
  }
  __webpack_require__.g.document.addEventListener('mousedown', captureActiveElementOnClick);
  __webpack_require__.g.document.addEventListener('keydown', event => {
    if (event.key === 'Enter' || event.key === ' ') {
      captureActiveElementOnClick(event);
    }
  });
  __webpack_require__.g._googlesitekitModalFocusTrackerInitialized = true;
}
setupFocusTracker();
function RefocusableModalDialog({
  dialogActive = false,
  refocusQuerySelector = null,
  ...modalDialogProps
}) {
  const handleElementRefocus = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_3__.useCallback)(() => {
    setTimeout(() => {
      const elementToFocus = refocusQuerySelector ? document.querySelector(refocusQuerySelector) : previouslyClickedElement;
      if (elementToFocus && document.body.contains(elementToFocus)) {
        elementToFocus.focus();
      }
      if (!refocusQuerySelector) {
        previouslyClickedElement = null;
      }
    });
  }, [refocusQuerySelector]);
  const previousDialogActive = (0,_wordpress_compose__WEBPACK_IMPORTED_MODULE_4__["default"])(dialogActive);
  // Handle re-focus of the button which triggered the modal.
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_3__.useEffect)(() => {
    if (previousDialogActive === true && dialogActive === false) {
      handleElementRefocus();
    }
    return () => {
      // In majority of cases the modal is conditionally rendered, so dialogActive
      // will not be passed, as component will be unmounted/removed from the DOM.
      handleElementRefocus();
    };
  }, [previousDialogActive, dialogActive, handleElementRefocus]);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)(_ModalDialog__WEBPACK_IMPORTED_MODULE_1__["default"], {
    dialogActive: dialogActive,
    ...modalDialogProps
  });
}
RefocusableModalDialog.propTypes = {
  dialogActive: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().bool),
  refocusQuerySelector: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().string),
  ...googlesitekit_components__WEBPACK_IMPORTED_MODULE_0__.Dialog.propTypes
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (RefocusableModalDialog);

/***/ }),

/***/ "./js/components/ReportError.js":
/*!**************************************!*\
  !*** ./js/components/ReportError.js ***!
  \**************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ ReportError)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_13___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_13__);
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! lodash */ "../node_modules/lodash/lodash.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/googlesitekit/modules/datastore/constants */ "./js/googlesitekit/modules/datastore/constants.js");
/* harmony import */ var _js_util_errors__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/util/errors */ "./js/util/errors.js");
/* harmony import */ var _js_util_insufficient_permissions_error_description__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/util/insufficient-permissions-error-description */ "./js/util/insufficient-permissions-error-description.js");
/* harmony import */ var _js_util_purify__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @/js/util/purify */ "./js/util/purify.js");
/* harmony import */ var _notifications_CTA__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./notifications/CTA */ "./js/components/notifications/CTA.js");
/* harmony import */ var _ReportErrorActions__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./ReportErrorActions */ "./js/components/ReportErrorActions.js");
/* harmony import */ var _js_hooks_useViewOnly__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @/js/hooks/useViewOnly */ "./js/hooks/useViewOnly.js");
/* harmony import */ var _ErrorNotice__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./ErrorNotice */ "./js/components/ErrorNotice.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * ReportError component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */










function ReportError({
  moduleSlug,
  error
}) {
  const isViewOnly = (0,_js_hooks_useViewOnly__WEBPACK_IMPORTED_MODULE_9__["default"])();
  const module = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.useSelect)(select => select(_js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_MODULES).getModule(moduleSlug));
  const errors = Array.isArray(error) ? error : [error];
  let title;
  function getMessage(err) {
    if ((0,_js_util_errors__WEBPACK_IMPORTED_MODULE_4__.isInsufficientPermissionsError)(err)) {
      if (isViewOnly) {
        title = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.sprintf)(/* translators: %s: module name */
        (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Access lost to %s', 'google-site-kit'), module?.name);
        return (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.sprintf)(/* translators: %s: module name */
        (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('The administrator sharing this module with you has lost access to the %s service, so you won’t be able to see stats from it on the Site Kit dashboard. You can contact them or another administrator to restore access.', 'google-site-kit'), module?.name);
      }
      title = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.sprintf)(/* translators: %s: module name */
      (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Insufficient permissions in %s', 'google-site-kit'), module?.name);
      return (0,_js_util_insufficient_permissions_error_description__WEBPACK_IMPORTED_MODULE_5__.getInsufficientPermissionsErrorDescription)(err.message, module);
    }
    return (0,_js_util_errors__WEBPACK_IMPORTED_MODULE_4__.getReportErrorMessage)(err);
  }
  const uniqueErrors = (0,lodash__WEBPACK_IMPORTED_MODULE_0__.uniqWith)(errors.map(err => ({
    ...err,
    message: getMessage(err),
    reconnectURL: err.data?.reconnectURL
  })), (errorA, errorB) => errorA.message === errorB.message && errorA.reconnectURL === errorB.reconnectURL);
  const hasInsufficientPermissionsError = errors.some(err => (0,_js_util_errors__WEBPACK_IMPORTED_MODULE_4__.isInsufficientPermissionsError)(err));
  if (!hasInsufficientPermissionsError && uniqueErrors.length === 1) {
    title = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.sprintf)(/* translators: %s: module name */
    (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Data error in %s', 'google-site-kit'), module?.name);
  } else if (!hasInsufficientPermissionsError && uniqueErrors.length > 1) {
    title = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.sprintf)(/* translators: %s: module name */
    (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Data errors in %s', 'google-site-kit'), module?.name);
  }
  const description = /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_wordpress_element__WEBPACK_IMPORTED_MODULE_12__.Fragment, {
    children: uniqueErrors.map(errorForNotice => {
      const reconnectURL = errorForNotice?.data?.reconnectURL;
      return reconnectURL ? /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_ErrorNotice__WEBPACK_IMPORTED_MODULE_10__["default"], {
        error: errorForNotice,
        message: errorForNotice.message
      }, errorForNotice.message) : /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("p", {
        children: _js_util_purify__WEBPACK_IMPORTED_MODULE_6__.purify.sanitize(errorForNotice.message, {
          // Ensures no HTML tags are passed as they would be
          // escaped by React and appear as strings.
          ALLOWED_TAGS: []
        })
      }, errorForNotice.message);
    })
  });
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_notifications_CTA__WEBPACK_IMPORTED_MODULE_7__["default"], {
    title: title,
    description: description,
    error: true,
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_ReportErrorActions__WEBPACK_IMPORTED_MODULE_8__["default"], {
      moduleSlug: moduleSlug,
      error: error
    })
  });
}
ReportError.propTypes = {
  moduleSlug: (prop_types__WEBPACK_IMPORTED_MODULE_13___default().string).isRequired,
  error: prop_types__WEBPACK_IMPORTED_MODULE_13___default().oneOfType([prop_types__WEBPACK_IMPORTED_MODULE_13___default().arrayOf((prop_types__WEBPACK_IMPORTED_MODULE_13___default().object)), (prop_types__WEBPACK_IMPORTED_MODULE_13___default().object)]).isRequired
};

/***/ }),

/***/ "./js/components/ReportErrorActions.js":
/*!*********************************************!*\
  !*** ./js/components/ReportErrorActions.js ***!
  \*********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ ReportErrorActions)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_11___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_11__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/@wordpress/element/build-module/create-interpolate-element.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! googlesitekit-components */ "googlesitekit-components");
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_components__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/googlesitekit/datastore/site/constants */ "./js/googlesitekit/datastore/site/constants.js");
/* harmony import */ var _js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/googlesitekit/modules/datastore/constants */ "./js/googlesitekit/modules/datastore/constants.js");
/* harmony import */ var _js_util_errors__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/util/errors */ "./js/util/errors.js");
/* harmony import */ var _js_hooks_useViewOnly__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @/js/hooks/useViewOnly */ "./js/hooks/useViewOnly.js");
/* harmony import */ var _Link__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./Link */ "./js/components/Link.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * ReportErrorActions component.
 *
 * Site Kit by Google, Copyright 2022 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */








function ReportErrorActions(props) {
  const {
    moduleSlug,
    error,
    GetHelpLink,
    hideGetHelpLink,
    buttonVariant,
    onRetry,
    onRequestAccess,
    getHelpClassName,
    RequestAccessButton,
    RetryButton
  } = props;
  const isViewOnly = (0,_js_hooks_useViewOnly__WEBPACK_IMPORTED_MODULE_6__["default"])();
  const storeName = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_4__.CORE_MODULES).getModuleStoreName(moduleSlug));
  const requestAccessURL = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => typeof select(storeName)?.getServiceEntityAccessURL === 'function' ? select(storeName).getServiceEntityAccessURL() : null);
  const errors = Array.isArray(error) ? error : [error];
  const errorsWithSelectorData = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => errors.map(err => {
    const selectorData = select(storeName)?.getSelectorDataForError(err);
    return {
      ...err,
      selectorData
    };
  }));
  const retryableErrors = errorsWithSelectorData?.filter(err => (0,_js_util_errors__WEBPACK_IMPORTED_MODULE_5__.isErrorRetryable)(err, err.selectorData) && err.selectorData.name === 'getReport');
  const showRetry = !!retryableErrors.length;
  const errorTroubleshootingLinkURL = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => {
    const err = {
      ...(showRetry ? retryableErrors[0] : errors[0])
    };
    if ((0,_js_util_errors__WEBPACK_IMPORTED_MODULE_5__.isInsufficientPermissionsError)(err)) {
      err.code = `${moduleSlug}_insufficient_permissions`;
    }
    return select(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_SITE).getErrorTroubleshootingLinkURL(err);
  });
  const dispatch = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useDispatch)();
  const hasInsufficientPermissionsError = errors.some(err => (0,_js_util_errors__WEBPACK_IMPORTED_MODULE_5__.isInsufficientPermissionsError)(err));
  const handleRetry = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.useCallback)(() => {
    retryableErrors.forEach(err => {
      const {
        selectorData
      } = err;
      dispatch(selectorData.storeName).invalidateResolution(selectorData.name, selectorData.args);
    });
    onRetry?.();
  }, [dispatch, retryableErrors, onRetry]);
  const showRequestAccessURL = requestAccessURL && hasInsufficientPermissionsError && !isViewOnly;
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsxs)("div", {
    className: "googlesitekit-report-error-actions",
    children: [showRequestAccessURL && (typeof RequestAccessButton === 'function' ? /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(RequestAccessButton, {
      requestAccessURL: requestAccessURL
    }) : /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_2__.Button, {
      onClick: onRequestAccess,
      href: requestAccessURL,
      target: "_blank",
      danger: buttonVariant === 'danger',
      tertiary: buttonVariant === 'tertiary',
      children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Request access', 'google-site-kit')
    })), showRetry && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsxs)(_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.Fragment, {
      children: [typeof RetryButton === 'function' ? /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(RetryButton, {
        handleRetry: handleRetry
      }) : /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_2__.Button, {
        onClick: handleRetry,
        danger: buttonVariant === 'danger',
        tertiary: buttonVariant === 'tertiary',
        children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Retry', 'google-site-kit')
      }), !hideGetHelpLink && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)("span", {
        className: "googlesitekit-error-retry-text",
        children: (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_10__["default"])((0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Retry didn’t work? <HelpLink />', 'google-site-kit'), {
          HelpLink: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(_Link__WEBPACK_IMPORTED_MODULE_7__["default"], {
            href: errorTroubleshootingLinkURL,
            external: true,
            hideExternalIndicator: true,
            children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Get help', 'google-site-kit')
          })
        })
      })]
    }), !showRetry && !hideGetHelpLink && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)("div", {
      className: getHelpClassName,
      children: typeof GetHelpLink === 'function' ? /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(GetHelpLink, {
        linkURL: errorTroubleshootingLinkURL
      }) : /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(_Link__WEBPACK_IMPORTED_MODULE_7__["default"], {
        href: errorTroubleshootingLinkURL,
        external: true,
        hideExternalIndicator: true,
        children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Get help', 'google-site-kit')
      })
    })]
  });
}
ReportErrorActions.propTypes = {
  moduleSlug: (prop_types__WEBPACK_IMPORTED_MODULE_11___default().string).isRequired,
  error: prop_types__WEBPACK_IMPORTED_MODULE_11___default().oneOfType([prop_types__WEBPACK_IMPORTED_MODULE_11___default().arrayOf((prop_types__WEBPACK_IMPORTED_MODULE_11___default().object)), (prop_types__WEBPACK_IMPORTED_MODULE_11___default().object)]).isRequired,
  GetHelpLink: (prop_types__WEBPACK_IMPORTED_MODULE_11___default().elementType),
  hideGetHelpLink: (prop_types__WEBPACK_IMPORTED_MODULE_11___default().bool),
  buttonVariant: (prop_types__WEBPACK_IMPORTED_MODULE_11___default().string),
  onRetry: (prop_types__WEBPACK_IMPORTED_MODULE_11___default().func),
  onRequestAccess: (prop_types__WEBPACK_IMPORTED_MODULE_11___default().func),
  getHelpClassName: (prop_types__WEBPACK_IMPORTED_MODULE_11___default().string),
  RequestAccessButton: (prop_types__WEBPACK_IMPORTED_MODULE_11___default().elementType),
  RetryButton: (prop_types__WEBPACK_IMPORTED_MODULE_11___default().elementType)
};

/***/ }),

/***/ "./js/components/ReportErrorButton/index.js":
/*!**************************************************!*\
  !*** ./js/components/ReportErrorButton/index.js ***!
  \**************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var clipboard_copy__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! clipboard-copy */ "../node_modules/clipboard-copy/index.js");
/* harmony import */ var clipboard_copy__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(clipboard_copy__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @wordpress/icons */ "../node_modules/@wordpress/icons/build-module/icon/index.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @wordpress/icons */ "../node_modules/@wordpress/icons/build-module/library/check.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @wordpress/icons */ "../node_modules/@wordpress/icons/build-module/library/stack.js");
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! googlesitekit-components */ "googlesitekit-components");
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_components__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * ReportErrorButton component.
 *
 * Site Kit by Google, Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * WordPress dependencies
 */




/**
 * Internal dependencies
 */


function ReportErrorButton({
  message,
  componentStack
}) {
  const [copied, setCopied] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_4__.useState)(false);
  function onErrorClick() {
    // Copy message with wrapping backticks for code block formatting on wp.org.
    clipboard_copy__WEBPACK_IMPORTED_MODULE_0___default()(`\`\`\`\n${message}\n${componentStack}\n\`\`\``);
    setCopied(true);
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_2__.Button, {
    "aria-label": copied ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Error message copied to clipboard. Click to copy the error message again.', 'google-site-kit') : undefined,
    onClick: onErrorClick,
    trailingIcon: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_icons__WEBPACK_IMPORTED_MODULE_5__["default"], {
      className: "mdc-button__icon",
      icon: copied ? _wordpress_icons__WEBPACK_IMPORTED_MODULE_6__["default"] : _wordpress_icons__WEBPACK_IMPORTED_MODULE_7__["default"]
    }),
    children: copied ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Copied to clipboard', 'google-site-kit') : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Copy error contents', 'google-site-kit')
  });
}
ReportErrorButton.propTypes = {
  message: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().string),
  componentStack: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().string)
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ReportErrorButton);

/***/ }),

/***/ "./js/components/ReportZero.js":
/*!*************************************!*\
  !*** ./js/components/ReportZero.js ***!
  \*************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ ReportZero)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/googlesitekit/modules/datastore/constants */ "./js/googlesitekit/modules/datastore/constants.js");
/* harmony import */ var _notifications_CTA__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./notifications/CTA */ "./js/components/notifications/CTA.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * ReportZero component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */




function ReportZero({
  moduleSlug
}) {
  const module = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_2__.CORE_MODULES).getModule(moduleSlug));
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(_notifications_CTA__WEBPACK_IMPORTED_MODULE_3__["default"], {
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.sprintf)(/* translators: %s: Module name */
    (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('%s Gathering Data', 'google-site-kit'), module?.name),
    description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.sprintf)(/* translators: %s: Module name */
    (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('%s data is not yet available, please check back later', 'google-site-kit'), module?.name)
  });
}
ReportZero.propTypes = {
  moduleSlug: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().string).isRequired
};

/***/ }),

/***/ "./js/components/RestoreSnapshots/index.js":
/*!*************************************************!*\
  !*** ./js/components/RestoreSnapshots/index.js ***!
  \*************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _js_googlesitekit_data_create_snapshot_store__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/googlesitekit/data/create-snapshot-store */ "./js/googlesitekit/data/create-snapshot-store.js");
/**
 * Snapshot restoration component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */


function RestoreSnapshots({
  children
}) {
  const registry = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useRegistry)();
  const [restoredSnapshots, setRestoredSnapshots] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(false);
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useEffect)(() => {
    if (!restoredSnapshots) {
      (async () => {
        await (0,_js_googlesitekit_data_create_snapshot_store__WEBPACK_IMPORTED_MODULE_1__.restoreAllSnapshots)(registry);
        setRestoredSnapshots(true);
      })();
    }
  }, [registry, restoredSnapshots]);
  if (!restoredSnapshots) {
    return null;
  }
  return children;
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (RestoreSnapshots);

/***/ }),

/***/ "./js/components/Root/ViewContextContext.js":
/*!**************************************************!*\
  !*** ./js/components/Root/ViewContextContext.js ***!
  \**************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Consumer: () => (/* binding */ Consumer),
/* harmony export */   Provider: () => (/* binding */ Provider),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/**
 * View Context context for React components.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */

const ViewContextContext = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createContext)('');
const {
  Consumer,
  Provider
} = ViewContextContext;
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ViewContextContext);

/***/ }),

/***/ "./js/components/Root/index.js":
/*!*************************************!*\
  !*** ./js/components/Root/index.js ***!
  \*************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Root)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_14___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_14__);
/* harmony import */ var _material_ui_core__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @material-ui/core */ "../node_modules/@material-ui/core/esm/styles/createMuiStrictModeTheme.js");
/* harmony import */ var _material_ui_core__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! @material-ui/core */ "../node_modules/@material-ui/styles/esm/ThemeProvider/ThemeProvider.js");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _js_components_ErrorHandler__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/components/ErrorHandler */ "./js/components/ErrorHandler/index.js");
/* harmony import */ var _js_components_FeaturesProvider__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/components/FeaturesProvider */ "./js/components/FeaturesProvider/index.js");
/* harmony import */ var _js_features__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/features */ "./js/features/index.js");
/* harmony import */ var _js_components_PermissionsModal__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/components/PermissionsModal */ "./js/components/PermissionsModal/index.js");
/* harmony import */ var _js_components_RestoreSnapshots__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/components/RestoreSnapshots */ "./js/components/RestoreSnapshots/index.js");
/* harmony import */ var _js_components_FeatureTours__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @/js/components/FeatureTours */ "./js/components/FeatureTours.js");
/* harmony import */ var _ViewContextContext__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./ViewContextContext */ "./js/components/Root/ViewContextContext.js");
/* harmony import */ var _js_components_InViewProvider__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @/js/components/InViewProvider */ "./js/components/InViewProvider/index.js");
/* harmony import */ var _js_util_is_site_kit_screen__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @/js/util/is-site-kit-screen */ "./js/util/is-site-kit-screen.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Root component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */











function Root({
  children,
  registry,
  viewContext = null
}) {
  const theme =  false ? 0 : _material_ui_core__WEBPACK_IMPORTED_MODULE_11__["default"]; // eslint-disable-line camelcase

  const [inViewState] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_12__.useState)({
    key: 'Root',
    value: true
  });
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)(_wordpress_element__WEBPACK_IMPORTED_MODULE_12__.StrictMode, {
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)(_js_components_InViewProvider__WEBPACK_IMPORTED_MODULE_8__["default"], {
      value: inViewState,
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)(googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.RegistryProvider, {
        value: registry,
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)(_js_components_FeaturesProvider__WEBPACK_IMPORTED_MODULE_2__["default"], {
          value: _js_features__WEBPACK_IMPORTED_MODULE_3__.enabledFeatures,
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)(_ViewContextContext__WEBPACK_IMPORTED_MODULE_7__.Provider, {
            value: viewContext,
            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)(_material_ui_core__WEBPACK_IMPORTED_MODULE_13__["default"], {
              theme: theme(),
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsxs)(_js_components_ErrorHandler__WEBPACK_IMPORTED_MODULE_1__["default"], {
                children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsxs)(_js_components_RestoreSnapshots__WEBPACK_IMPORTED_MODULE_5__["default"], {
                  children: [children, viewContext && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)(_js_components_FeatureTours__WEBPACK_IMPORTED_MODULE_6__["default"], {})]
                }), (0,_js_util_is_site_kit_screen__WEBPACK_IMPORTED_MODULE_9__.isSiteKitScreen)(viewContext) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)(_js_components_PermissionsModal__WEBPACK_IMPORTED_MODULE_4__["default"], {})]
              })
            })
          })
        })
      })
    })
  });
}
Root.propTypes = {
  children: (prop_types__WEBPACK_IMPORTED_MODULE_14___default().node),
  registry: (prop_types__WEBPACK_IMPORTED_MODULE_14___default().object),
  viewContext: (prop_types__WEBPACK_IMPORTED_MODULE_14___default().string).isRequired
};
Root.defaultProps = {
  registry: (googlesitekit_data__WEBPACK_IMPORTED_MODULE_0___default())
};

/***/ }),

/***/ "./js/components/ScrollEffect.js":
/*!***************************************!*\
  !*** ./js/components/ScrollEffect.js ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ ScrollEffect)
/* harmony export */ });
/* harmony import */ var _js_hooks_useHasScrolledEffect__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @/js/hooks/useHasScrolledEffect */ "./js/hooks/useHasScrolledEffect.js");
/**
 * ScrollEffect component.
 *
 * Site Kit by Google, Copyright 2022 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Internal dependencies
 */

function ScrollEffect() {
  (0,_js_hooks_useHasScrolledEffect__WEBPACK_IMPORTED_MODULE_0__.useHasScrolledEffect)();
  return null;
}

/***/ }),

/***/ "./js/components/SelectionBox.js":
/*!***************************************!*\
  !*** ./js/components/SelectionBox.js ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ SelectionBox)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-components */ "googlesitekit-components");
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * SelectionBox component.
 *
 * Site Kit by Google, Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * Internal dependencies
 */


function SelectionBox({
  badge,
  checked,
  children,
  disabled,
  id,
  onChange,
  title,
  value
}) {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("div", {
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-selection-box', {
      'googlesitekit-selection-box--disabled': disabled
    }),
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__.Checkbox, {
      checked: checked,
      description: children,
      disabled: disabled,
      id: id,
      name: id,
      onChange: onChange,
      value: value,
      badge: badge,
      children: title
    })
  });
}
SelectionBox.propTypes = {
  badge: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().node),
  checked: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().bool),
  children: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().node),
  disabled: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().bool),
  id: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  onChange: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().func),
  title: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  value: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string)
};

/***/ }),

/***/ "./js/components/SelectionPanel/SelectionPanel.js":
/*!********************************************************!*\
  !*** ./js/components/SelectionPanel/SelectionPanel.js ***!
  \********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ SelectionPanel)
/* harmony export */ });
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _js_components_SideSheet__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/components/SideSheet */ "./js/components/SideSheet.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Selection Panel component.
 *
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * Internal dependencies
 */


function SelectionPanel({
  children,
  isOpen,
  isLoading,
  onOpen,
  closePanel,
  className
}) {
  const classNameSelector = className?.split(/\s+/).map(name => `.${name}`).join('');
  const initialFocus = classNameSelector ? `${classNameSelector} .googlesitekit-selection-panel-item .googlesitekit-selection-box input` : '.googlesitekit-selection-panel-item .googlesitekit-selection-box input';
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)(_js_components_SideSheet__WEBPACK_IMPORTED_MODULE_1__["default"], {
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-selection-panel', className),
    isOpen: isOpen,
    isLoading: isLoading,
    onOpen: onOpen,
    closeSheet: closePanel,
    focusTrapOptions: {
      initialFocus
    },
    children: children
  });
}
SelectionPanel.propTypes = {
  children: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().node),
  isOpen: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().bool),
  isLoading: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().bool),
  onOpen: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().func),
  closePanel: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().func),
  className: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string)
};

/***/ }),

/***/ "./js/components/SelectionPanel/SelectionPanelError.js":
/*!*************************************************************!*\
  !*** ./js/components/SelectionPanel/SelectionPanelError.js ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ SelectionPanelError)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _js_util_geometry__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @/js/util/geometry */ "./js/util/geometry.js");
/* harmony import */ var _js_components_ErrorNotice__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/components/ErrorNotice */ "./js/components/ErrorNotice.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Selection Panel Error
 *
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */



function SelectionPanelError({
  error,
  noPrefix = true,
  skipRetryMessage = true
}) {
  const noticeRef = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_3__.useRef)();

  // Scroll the metric item (normally the last item in the panel)
  // being overlapped by the error.
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_3__.useEffect)(() => {
    if (error) {
      const currentFocusedElement = __webpack_require__.g.document.activeElement;
      if (currentFocusedElement && currentFocusedElement.closest('.googlesitekit-selection-panel-item') && (0,_js_util_geometry__WEBPACK_IMPORTED_MODULE_0__.elementsOverlap)(noticeRef.current, currentFocusedElement)) {
        currentFocusedElement.scrollIntoView();
      }
    }
  }, [error]);
  if (!error) {
    return null;
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("div", {
    ref: noticeRef,
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)(_js_components_ErrorNotice__WEBPACK_IMPORTED_MODULE_1__["default"], {
      className: "googlesitekit-notice--square googlesitekit-selection-panel-error",
      error: error,
      noPrefix: noPrefix,
      skipRetryMessage: skipRetryMessage
    })
  });
}
SelectionPanelError.propTypes = {
  error: prop_types__WEBPACK_IMPORTED_MODULE_4___default().shape({
    message: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().string)
  }),
  noPrefix: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().bool),
  skipRetryMessage: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().bool)
};

/***/ }),

/***/ "./js/components/SelectionPanel/SelectionPanelFooter.js":
/*!**************************************************************!*\
  !*** ./js/components/SelectionPanel/SelectionPanelFooter.js ***!
  \**************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ SelectionPanelFooter)
/* harmony export */ });
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! lodash */ "../node_modules/lodash/lodash.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_12___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_12__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/@wordpress/element/build-module/create-interpolate-element.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! googlesitekit-components */ "googlesitekit-components");
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_components__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _js_components_ErrorNotice__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/components/ErrorNotice */ "./js/components/ErrorNotice.js");
/* harmony import */ var _js_util__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/util */ "./js/util/index.js");
/* harmony import */ var _js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @/js/modules/analytics-4/datastore/constants */ "./js/modules/analytics-4/datastore/constants.js");
/* harmony import */ var _js_components_PreviewBlock__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @/js/components/PreviewBlock */ "./js/components/PreviewBlock.js");
/* harmony import */ var _js_components_Notice__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @/js/components/Notice */ "./js/components/Notice/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Selection Panel Footer component.
 *
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */








function SelectionPanelFooter({
  savedItemSlugs = [],
  selectedItemSlugs = [],
  saveSettings = () => {},
  saveError,
  itemLimitError,
  minSelectedItemCount = 0,
  maxSelectedItemCount = 0,
  isBusy,
  onSaveSuccess = () => {},
  onCancel = () => {},
  isOpen,
  closePanel = () => {}
}) {
  const [finalButtonText, setFinalButtonText] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_10__.useState)(null);
  const [wasSaved, setWasSaved] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_10__.useState)(false);
  const isLoading = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.useSelect)(select => select(_js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_6__.MODULES_ANALYTICS_4).isFetchingSyncAvailableAudiences());
  const haveSettingsChanged = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_10__.useMemo)(() => {
    // Arrays need to be sorted to match in `isEqual`.
    return !(0,lodash__WEBPACK_IMPORTED_MODULE_0__.isEqual)((0,_js_util__WEBPACK_IMPORTED_MODULE_5__.safelySort)(selectedItemSlugs), (0,_js_util__WEBPACK_IMPORTED_MODULE_5__.safelySort)(savedItemSlugs));
  }, [savedItemSlugs, selectedItemSlugs]);
  const currentButtonText = savedItemSlugs?.length > 0 && haveSettingsChanged ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Apply changes', 'google-site-kit') : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Save selection', 'google-site-kit');
  const onSaveClick = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_10__.useCallback)(async () => {
    const {
      error
    } = await saveSettings(selectedItemSlugs);
    if (!error) {
      onSaveSuccess();

      // Close the panel after saving.
      closePanel();

      // Lock the button label while panel is closing.
      setFinalButtonText(currentButtonText);
      setWasSaved(true);
    }
  }, [saveSettings, selectedItemSlugs, onSaveSuccess, closePanel, currentButtonText]);
  const onCancelClick = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_10__.useCallback)(() => {
    closePanel();
    onCancel();
  }, [closePanel, onCancel]);
  const [prevIsOpen, setPrevIsOpen] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_10__.useState)(null);
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_10__.useEffect)(() => {
    if (prevIsOpen !== null) {
      // If current isOpen is true, and different from prevIsOpen
      // meaning it transitioned from false to true and it is not
      // in closing transition, we should reset the button label
      // locked when save button was clicked.
      if (prevIsOpen !== isOpen) {
        if (isOpen) {
          setFinalButtonText(null);
          setWasSaved(false);
        }
      }
    }
    setPrevIsOpen(isOpen);
  }, [isOpen, prevIsOpen]);
  const selectedItemCount = selectedItemSlugs?.length || 0;
  const itemCountElement = isLoading ? /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)(_js_components_PreviewBlock__WEBPACK_IMPORTED_MODULE_7__["default"], {
    width: "89px",
    height: "20px"
  }) : /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)("p", {
    className: "googlesitekit-selection-panel-footer__item-count",
    children: (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_11__["default"])((0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.sprintf)(/* translators: 1: Number of selected items. 2: Maximum number of items that can be selected. */
    (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('%1$d selected <MaxCount>(up to %2$d)</MaxCount>', 'google-site-kit'), selectedItemCount, maxSelectedItemCount), {
      MaxCount: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)("span", {
        className: "googlesitekit-selection-panel-footer__item-count--max-count"
      })
    })
  });
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsxs)("footer", {
    className: "googlesitekit-selection-panel-footer",
    children: [saveError && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)(_js_components_ErrorNotice__WEBPACK_IMPORTED_MODULE_4__["default"], {
      error: saveError
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsxs)("div", {
      className: "googlesitekit-selection-panel-footer__content",
      children: [haveSettingsChanged && itemLimitError ? /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)(_js_components_Notice__WEBPACK_IMPORTED_MODULE_8__["default"], {
        type: _js_components_Notice__WEBPACK_IMPORTED_MODULE_8__["default"].TYPES.ERROR,
        description: itemLimitError
      }) : itemCountElement, /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsxs)("div", {
        className: "googlesitekit-selection-panel-footer__actions",
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_3__.Button, {
          onClick: onCancelClick,
          disabled: isBusy,
          tertiary: true,
          children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Cancel', 'google-site-kit')
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_3__.SpinnerButton, {
          onClick: onSaveClick,
          isSaving: isBusy,
          disabled: selectedItemCount < minSelectedItemCount || selectedItemCount > maxSelectedItemCount || isBusy || !isOpen && wasSaved,
          children: finalButtonText || currentButtonText
        })]
      })]
    })]
  });
}
SelectionPanelFooter.propTypes = {
  savedItemSlugs: (prop_types__WEBPACK_IMPORTED_MODULE_12___default().array),
  selectedItemSlugs: (prop_types__WEBPACK_IMPORTED_MODULE_12___default().array),
  saveSettings: (prop_types__WEBPACK_IMPORTED_MODULE_12___default().func),
  saveError: (prop_types__WEBPACK_IMPORTED_MODULE_12___default().object),
  itemLimitError: (prop_types__WEBPACK_IMPORTED_MODULE_12___default().string),
  minSelectedItemCount: (prop_types__WEBPACK_IMPORTED_MODULE_12___default().number),
  maxSelectedItemCount: (prop_types__WEBPACK_IMPORTED_MODULE_12___default().number),
  isBusy: (prop_types__WEBPACK_IMPORTED_MODULE_12___default().bool),
  onSaveSuccess: (prop_types__WEBPACK_IMPORTED_MODULE_12___default().func),
  onCancel: (prop_types__WEBPACK_IMPORTED_MODULE_12___default().func),
  isOpen: (prop_types__WEBPACK_IMPORTED_MODULE_12___default().bool),
  closePanel: (prop_types__WEBPACK_IMPORTED_MODULE_12___default().func)
};

/***/ }),

/***/ "./js/components/SelectionPanel/SelectionPanelHeader.js":
/*!**************************************************************!*\
  !*** ./js/components/SelectionPanel/SelectionPanelHeader.js ***!
  \**************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ SelectionPanelHeader)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _js_components_Link__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @/js/components/Link */ "./js/components/Link.js");
/* harmony import */ var _svg_icons_close_svg__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/svg/icons/close.svg */ "./svg/icons/close.svg");
/* harmony import */ var _js_components_Typography__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/components/Typography */ "./js/components/Typography/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Selection Panel Header component.
 *
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * Internal dependencies
 */




function SelectionPanelHeader({
  children,
  title,
  onCloseClick
}) {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("header", {
    className: "googlesitekit-selection-panel-header",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
      className: "googlesitekit-selection-panel-header__row",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_js_components_Typography__WEBPACK_IMPORTED_MODULE_2__["default"], {
        as: "h3",
        size: "small",
        type: "headline",
        children: title
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_js_components_Link__WEBPACK_IMPORTED_MODULE_0__["default"], {
        className: "googlesitekit-selection-panel-header__close",
        onClick: onCloseClick,
        linkButton: true,
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_svg_icons_close_svg__WEBPACK_IMPORTED_MODULE_1__["default"], {
          width: "15",
          height: "15"
        })
      })]
    }), children]
  });
}
SelectionPanelHeader.propTypes = {
  children: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().node),
  title: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().string),
  onCloseClick: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().func)
};

/***/ }),

/***/ "./js/components/SelectionPanel/SelectionPanelItem.js":
/*!************************************************************!*\
  !*** ./js/components/SelectionPanel/SelectionPanelItem.js ***!
  \************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ SelectionPanelItem)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _js_components_SelectionBox__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/components/SelectionBox */ "./js/components/SelectionBox.js");
/* harmony import */ var _js_components_Badge__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/components/Badge */ "./js/components/Badge.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Selection Panel Item component.
 *
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */



function SelectionPanelItem({
  children,
  id,
  slug,
  title,
  description,
  isItemSelected,
  isItemDisabled,
  onCheckboxChange,
  subtitle,
  suffix,
  badge,
  isNewlyDetected
}) {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
    className: "googlesitekit-selection-panel-item",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)(_js_components_SelectionBox__WEBPACK_IMPORTED_MODULE_1__["default"], {
      badge: badge,
      checked: isItemSelected,
      disabled: isItemDisabled,
      id: id,
      onChange: onCheckboxChange,
      title: title,
      value: slug,
      children: [subtitle && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("span", {
        className: "googlesitekit-selection-panel-item__subtitle",
        children: subtitle
      }), description, children]
    }), isNewlyDetected && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_js_components_Badge__WEBPACK_IMPORTED_MODULE_2__["default"], {
      label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('New', 'google-site-kit')
    }), suffix && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("span", {
      className: "googlesitekit-selection-panel-item__suffix",
      children: suffix
    })]
  });
}
SelectionPanelItem.propTypes = {
  children: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().node),
  id: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().string),
  slug: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().string),
  title: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().string),
  description: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().string),
  isItemSelected: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().bool),
  isItemDisabled: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().bool),
  onCheckboxChange: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().func),
  subtitle: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().string),
  suffix: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().node),
  badge: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().node),
  isNewlyDetected: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().bool)
};

/***/ }),

/***/ "./js/components/SelectionPanel/SelectionPanelItems.js":
/*!*************************************************************!*\
  !*** ./js/components/SelectionPanel/SelectionPanelItems.js ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ SelectionPanelItems)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Selection Panel Items component.
 *
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */



function SelectionPanelItems({
  currentSelectionTitle = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Current selection', 'google-site-kit'),
  availableItemsTitle = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Additional items', 'google-site-kit'),
  savedItemSlugs = [],
  availableSavedItems = {},
  availableUnsavedItems = {},
  ItemComponent,
  notice
}) {
  function renderItems(items) {
    return Object.keys(items).map(slug => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)(ItemComponent, {
      slug: slug,
      savedItemSlugs: savedItemSlugs,
      ...items[slug]
    }, slug));
  }
  const availableUnsavedItemsCount = Object.keys(availableUnsavedItems).length;
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsxs)("div", {
    className: "googlesitekit-selection-panel-items",
    children: [
    // Split list into two sections with sub-headings for current selection and
    // additional items if there are already saved items.
    savedItemSlugs.length !== 0 && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsxs)(_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.Fragment, {
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("p", {
        className: "googlesitekit-selection-panel-items__subheading",
        children: currentSelectionTitle
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", {
        className: "googlesitekit-selection-panel-items__subsection",
        children: renderItems(availableSavedItems)
      }), availableUnsavedItemsCount > 0 && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("p", {
        className: "googlesitekit-selection-panel-items__subheading",
        children: availableItemsTitle
      })]
    }), availableUnsavedItemsCount > 0 && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", {
      className: "googlesitekit-selection-panel-items__subsection",
      children: renderItems(availableUnsavedItems)
    }), notice]
  });
}
SelectionPanelItems.propTypes = {
  currentSelectionTitle: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  availableItemsTitle: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  savedItemSlugs: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().array),
  availableSavedItems: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().object),
  availableUnsavedItems: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().object),
  ItemComponent: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().elementType),
  notice: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().node)
};

/***/ }),

/***/ "./js/components/SelectionPanel/index.js":
/*!***********************************************!*\
  !*** ./js/components/SelectionPanel/index.js ***!
  \***********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   SelectionPanelFooter: () => (/* reexport safe */ _SelectionPanelFooter__WEBPACK_IMPORTED_MODULE_4__["default"]),
/* harmony export */   SelectionPanelHeader: () => (/* reexport safe */ _SelectionPanelHeader__WEBPACK_IMPORTED_MODULE_1__["default"]),
/* harmony export */   SelectionPanelItem: () => (/* reexport safe */ _SelectionPanelItem__WEBPACK_IMPORTED_MODULE_2__["default"]),
/* harmony export */   SelectionPanelItems: () => (/* reexport safe */ _SelectionPanelItems__WEBPACK_IMPORTED_MODULE_3__["default"]),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _SelectionPanel__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./SelectionPanel */ "./js/components/SelectionPanel/SelectionPanel.js");
/* harmony import */ var _SelectionPanelHeader__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./SelectionPanelHeader */ "./js/components/SelectionPanel/SelectionPanelHeader.js");
/* harmony import */ var _SelectionPanelItem__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./SelectionPanelItem */ "./js/components/SelectionPanel/SelectionPanelItem.js");
/* harmony import */ var _SelectionPanelItems__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./SelectionPanelItems */ "./js/components/SelectionPanel/SelectionPanelItems.js");
/* harmony import */ var _SelectionPanelFooter__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./SelectionPanelFooter */ "./js/components/SelectionPanel/SelectionPanelFooter.js");
/**
 * Selection Panel components.
 *
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Internal dependencies
 */





/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_SelectionPanel__WEBPACK_IMPORTED_MODULE_0__["default"]);

/***/ }),

/***/ "./js/components/SideSheet.js":
/*!************************************!*\
  !*** ./js/components/SideSheet.js ***!
  \************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ SideSheet)
/* harmony export */ });
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var focus_trap_react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! focus-trap-react */ "../node_modules/focus-trap-react/dist/focus-trap-react.js");
/* harmony import */ var focus_trap_react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(focus_trap_react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var react_use__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! react-use */ "../node_modules/react-use/esm/useClickAway.js");
/* harmony import */ var react_use__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! react-use */ "../node_modules/react-use/esm/useKey.js");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _wordpress_keycodes__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @wordpress/keycodes */ "../node_modules/@wordpress/keycodes/build-module/index.js");
/* harmony import */ var _Portal__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./Portal */ "./js/components/Portal.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * SideSheet component
 *
 * This component is named after Material Side Sheets
 * (https://m3.material.io/components/side-sheets/overview), which is
 * planned but not yet implemented for Web. Once available, we could look
 * into moving this to `googlesitekit-components` and replacing it with
 * the Material implementation.
 *
 * Site Kit by Google, Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */





/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */


function SideSheet({
  className,
  children,
  isOpen,
  isLoading,
  onOpen = () => {},
  closeSheet = () => {},
  focusTrapOptions = {}
}) {
  const sideSheetRef = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_4__.useRef)();
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_4__.useEffect)(() => {
    if (isOpen) {
      onOpen();
      document.body.classList.add('googlesitekit-side-sheet-scroll-lock');
    } else {
      document.body.classList.remove('googlesitekit-side-sheet-scroll-lock');
    }
  }, [isOpen, onOpen]);
  (0,react_use__WEBPACK_IMPORTED_MODULE_5__["default"])(sideSheetRef, closeSheet);
  (0,react_use__WEBPACK_IMPORTED_MODULE_6__["default"])(event => isOpen && _wordpress_keycodes__WEBPACK_IMPORTED_MODULE_7__.ESCAPE === event.keyCode, closeSheet);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)(_Portal__WEBPACK_IMPORTED_MODULE_2__["default"], {
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)((focus_trap_react__WEBPACK_IMPORTED_MODULE_1___default()), {
      active: !!isOpen && !isLoading,
      focusTrapOptions: {
        fallbackFocus: 'body',
        ...focusTrapOptions
      },
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("section", {
        ref: sideSheetRef,
        className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-side-sheet', className, {
          'googlesitekit-side-sheet--open': isOpen
        }),
        role: "dialog",
        "aria-modal": "true",
        "aria-hidden": !isOpen,
        tabIndex: "0",
        children: children
      })
    }), isOpen && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("span", {
      className: "googlesitekit-side-sheet-overlay"
    })]
  });
}
SideSheet.propTypes = {
  className: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().string),
  children: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().node),
  isOpen: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().bool),
  isLoading: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().bool),
  onOpen: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().func),
  closeSheet: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().func),
  focusTrapOptions: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().object)
};

/***/ }),

/***/ "./js/components/SourceLink.js":
/*!*************************************!*\
  !*** ./js/components/SourceLink.js ***!
  \*************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/@wordpress/element/build-module/create-interpolate-element.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _Link__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./Link */ "./js/components/Link.js");
/* harmony import */ var _js_hooks_useViewOnly__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/hooks/useViewOnly */ "./js/hooks/useViewOnly.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * SourceLink component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */



function SourceLink({
  name,
  href,
  className,
  external
}) {
  const viewOnlyDashboard = (0,_js_hooks_useViewOnly__WEBPACK_IMPORTED_MODULE_3__["default"])();
  if (viewOnlyDashboard) {
    return null;
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("div", {
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-source-link', className),
    children: (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_5__["default"])((0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.sprintf)(/* translators: %s: source link */
    (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Source: %s', 'google-site-kit'), `<a>${name}</a>`), {
      a: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(_Link__WEBPACK_IMPORTED_MODULE_2__["default"], {
        href: href,
        external: external
      }, "link")
    })
  });
}
SourceLink.propTypes = {
  name: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().string),
  href: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().string),
  className: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().string),
  external: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().bool)
};
SourceLink.defaultProps = {
  name: '',
  href: '',
  className: '',
  external: false
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (SourceLink);

/***/ }),

/***/ "./js/components/TourTooltip.js":
/*!**************************************!*\
  !*** ./js/components/TourTooltip.js ***!
  \**************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ TourTooltip)
/* harmony export */ });
/* harmony import */ var _material_react_card__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @material/react-card */ "../node_modules/@material/react-card/dist/index.js");
/* harmony import */ var _material_react_card__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_material_react_card__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! googlesitekit-components */ "googlesitekit-components");
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_components__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _js_util_create_incremental_array_by_size__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/util/create-incremental-array-by-size */ "./js/util/create-incremental-array-by-size.js");
/* harmony import */ var _svg_icons_close_svg__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/svg/icons/close.svg */ "./svg/icons/close.svg");
/* harmony import */ var _Typography__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./Typography */ "./js/components/Typography/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * TourTooltip component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */




/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */





function TourTooltip({
  backProps,
  closeProps,
  index,
  primaryProps,
  size,
  step,
  tooltipProps
}) {
  const indicatorArray = size > 1 ? (0,_js_util_create_incremental_array_by_size__WEBPACK_IMPORTED_MODULE_4__.createIncrementalArrayBySize)(size) : [];
  function getIndicatorClassName(indicatorIndex) {
    return classnames__WEBPACK_IMPORTED_MODULE_1___default()('googlesitekit-tooltip-indicator', {
      active: indicatorIndex === index
    });
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)("div", {
    className: classnames__WEBPACK_IMPORTED_MODULE_1___default()('googlesitekit-tour-tooltip', step.className),
    ...tooltipProps,
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsxs)((_material_react_card__WEBPACK_IMPORTED_MODULE_0___default()), {
      className: "googlesitekit-tooltip-card",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsxs)("div", {
        className: "googlesitekit-tooltip-body",
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_Typography__WEBPACK_IMPORTED_MODULE_6__["default"], {
          as: "h2",
          className: "googlesitekit-tooltip-title",
          size: "medium",
          type: "title",
          children: step.title
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)("div", {
          className: "googlesitekit-tooltip-content",
          children: step.content
        })]
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsxs)(_material_react_card__WEBPACK_IMPORTED_MODULE_0__.CardActions, {
        className: "googlesitekit-tooltip-actions",
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)("ul", {
          className: "googlesitekit-tooltip-indicators",
          children: indicatorArray.map(indicatorIndex => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)("li", {
            className: getIndicatorClassName(indicatorIndex)
          }, `indicator-${indicatorIndex}`))
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsxs)("div", {
          className: "googlesitekit-tooltip-buttons",
          children: [index !== 0 && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_3__.Button, {
            className: "googlesitekit-tooltip-button",
            text: true,
            ...backProps,
            children: backProps.title
          }), step.cta, primaryProps.title && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_3__.Button, {
            className: "googlesitekit-tooltip-button",
            text: true,
            ...primaryProps,
            children: primaryProps.title
          })]
        })]
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_3__.Button, {
        className: "googlesitekit-tooltip-close",
        icon: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_svg_icons_close_svg__WEBPACK_IMPORTED_MODULE_5__["default"], {
          width: "14",
          height: "14"
        }),
        onClick: closeProps.onClick,
        "aria-label": (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Close', 'google-site-kit'),
        text: true,
        hideTooltipTitle: true
      })]
    })
  });
}

/**
 * All props are provided directly from `react-joyride`, intended for custom components.
 *
 * @since 1.28.0
 * @see {@link https://docs.react-joyride.com/custom-components#props-1}.
 */
TourTooltip.propTypes = {
  backProps: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().object).isRequired,
  closeProps: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().object).isRequired,
  index: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().number).isRequired,
  isLastStep: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().bool).isRequired,
  primaryProps: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().object).isRequired,
  size: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().number).isRequired,
  step: prop_types__WEBPACK_IMPORTED_MODULE_8___default().shape({
    content: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().node),
    title: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().node),
    cta: prop_types__WEBPACK_IMPORTED_MODULE_8___default().oneOfType([(prop_types__WEBPACK_IMPORTED_MODULE_8___default().element), (prop_types__WEBPACK_IMPORTED_MODULE_8___default().bool)]),
    className: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().string)
  }).isRequired,
  tooltipProps: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().object).isRequired
};

/***/ }),

/***/ "./js/components/TourTooltips.js":
/*!***************************************!*\
  !*** ./js/components/TourTooltips.js ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   GA_ACTIONS: () => (/* binding */ GA_ACTIONS),
/* harmony export */   "default": () => (/* binding */ TourTooltips),
/* harmony export */   floaterProps: () => (/* binding */ floaterProps),
/* harmony export */   joyrideStyles: () => (/* binding */ joyrideStyles)
/* harmony export */ });
/* harmony import */ var react_use__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! react-use */ "../node_modules/react-use/esm/useMount.js");
/* harmony import */ var react_joyride__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! react-joyride */ "../node_modules/react-joyride/dist/index.mjs");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_10__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _js_googlesitekit_datastore_ui_constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/googlesitekit/datastore/ui/constants */ "./js/googlesitekit/datastore/ui/constants.js");
/* harmony import */ var _js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/googlesitekit/datastore/user/constants */ "./js/googlesitekit/datastore/user/constants.js");
/* harmony import */ var _js_util_tracking__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/util/tracking */ "./js/util/tracking/index.js");
/* harmony import */ var _TourTooltip__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./TourTooltip */ "./js/components/TourTooltip.js");
/* harmony import */ var _js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @/js/hooks/useViewContext */ "./js/hooks/useViewContext.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * TourTooltips component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */




/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */







/** For available options, see: {@link https://github.com/gilbarbara/react-joyride/blob/3e08384415a831b20ce21c8423b6c271ad419fbf/src/styles.js}. */

const joyrideStyles = {
  options: {
    arrowColor: '#3c7251',
    // $c-content-primary
    backgroundColor: '#3c7251',
    // $c-content-primary
    overlayColor: 'rgba(0, 0, 0, 0.6)',
    textColor: '#fff',
    // $c-content-on-primary
    zIndex: 20000
  },
  spotlight: {
    border: '2px solid #3c7251',
    // $c-content-primary
    backgroundColor: '#fff'
  }
};

// Provides button content as well as aria-label & title attribute values.
const joyrideLocale = {
  back: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Back', 'google-site-kit'),
  close: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Close', 'google-site-kit'),
  last: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Got it', 'google-site-kit'),
  next: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Next', 'google-site-kit')
};

/** For available options, see: {@link https://github.com/gilbarbara/react-floater#props}. */
const floaterProps = {
  disableAnimation: true,
  styles: {
    arrow: {
      length: 8,
      margin: 56,
      spread: 16
    },
    floater: {
      filter: 'drop-shadow(rgba(60, 64, 67, 0.3) 0px 1px 2px) drop-shadow(rgba(60, 64, 67, 0.15) 0px 2px 6px)'
    }
  }
};

// GA Event Tracking actions (do not change!)
const GA_ACTIONS = {
  VIEW: 'feature_tooltip_view',
  NEXT: 'feature_tooltip_advance',
  PREV: 'feature_tooltip_return',
  DISMISS: 'feature_tooltip_dismiss',
  COMPLETE: 'feature_tooltip_complete'
};
function TourTooltips({
  steps,
  tourID,
  gaEventCategory,
  callback
}) {
  const stepKey = `${tourID}-step`;
  const runKey = `${tourID}-run`;
  const {
    setValue
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useDispatch)(_js_googlesitekit_datastore_ui_constants__WEBPACK_IMPORTED_MODULE_2__.CORE_UI);
  const {
    dismissTour
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useDispatch)(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_USER);
  const registry = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useRegistry)();
  const viewContext = (0,_js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_6__["default"])();
  const stepIndex = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_datastore_ui_constants__WEBPACK_IMPORTED_MODULE_2__.CORE_UI).getValue(stepKey) || 0);
  const run = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => {
    return select(_js_googlesitekit_datastore_ui_constants__WEBPACK_IMPORTED_MODULE_2__.CORE_UI).getValue(runKey) && select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_USER).isTourDismissed(tourID) === false;
  });
  function changeStep(index, action) {
    return setValue(stepKey, index + (action === react_joyride__WEBPACK_IMPORTED_MODULE_8__.ACTIONS.PREV ? -1 : 1));
  }
  function startTour() {
    __webpack_require__.g.document.body.classList.add('googlesitekit-showing-feature-tour', `googlesitekit-showing-feature-tour--${tourID}`);
    setValue(runKey, true);
  }
  function endTour() {
    __webpack_require__.g.document.body.classList.remove('googlesitekit-showing-feature-tour', `googlesitekit-showing-feature-tour--${tourID}`);
    // Dismiss tour to avoid unwanted repeat viewing.
    dismissTour(tourID);
  }
  function trackAllTourEvents({
    index,
    action,
    lifecycle,
    size,
    status,
    type
  }) {
    // The index is 0-based, but step numbers are 1-based.
    const stepNumber = index + 1;
    const eventCategory = typeof gaEventCategory === 'function' ? gaEventCategory(viewContext) : gaEventCategory;
    if (type === react_joyride__WEBPACK_IMPORTED_MODULE_8__.EVENTS.TOOLTIP && lifecycle === react_joyride__WEBPACK_IMPORTED_MODULE_8__.LIFECYCLE.TOOLTIP) {
      (0,_js_util_tracking__WEBPACK_IMPORTED_MODULE_4__.trackEvent)(eventCategory, GA_ACTIONS.VIEW, stepNumber);
    } else if (action === react_joyride__WEBPACK_IMPORTED_MODULE_8__.ACTIONS.CLOSE && lifecycle === react_joyride__WEBPACK_IMPORTED_MODULE_8__.LIFECYCLE.COMPLETE) {
      (0,_js_util_tracking__WEBPACK_IMPORTED_MODULE_4__.trackEvent)(eventCategory, GA_ACTIONS.DISMISS, stepNumber);
    } else if (action === react_joyride__WEBPACK_IMPORTED_MODULE_8__.ACTIONS.NEXT && status === react_joyride__WEBPACK_IMPORTED_MODULE_8__.STATUS.FINISHED && type === react_joyride__WEBPACK_IMPORTED_MODULE_8__.EVENTS.TOUR_END &&
    // Here we need to additionally check the size === stepNumber because
    // it is the only way to differentiate the status/event combination
    // from an identical combination that happens immediately after completion
    // on index `0` to avoid duplicate measurement.
    size === stepNumber) {
      (0,_js_util_tracking__WEBPACK_IMPORTED_MODULE_4__.trackEvent)(eventCategory, GA_ACTIONS.COMPLETE, stepNumber);
    }
    if (lifecycle !== react_joyride__WEBPACK_IMPORTED_MODULE_8__.LIFECYCLE.COMPLETE || status === react_joyride__WEBPACK_IMPORTED_MODULE_8__.STATUS.FINISHED) {
      return;
    }
    if (action === react_joyride__WEBPACK_IMPORTED_MODULE_8__.ACTIONS.PREV) {
      (0,_js_util_tracking__WEBPACK_IMPORTED_MODULE_4__.trackEvent)(eventCategory, GA_ACTIONS.PREV, stepNumber);
    }
    if (action === react_joyride__WEBPACK_IMPORTED_MODULE_8__.ACTIONS.NEXT) {
      (0,_js_util_tracking__WEBPACK_IMPORTED_MODULE_4__.trackEvent)(eventCategory, GA_ACTIONS.NEXT, stepNumber);
    }
  }

  /**
   * Handles `react-joyride` state changes using callback function.
   *
   * @typedef {Object} JoyrideCallbackData
   * @property {string} action The action that updated the state.
   * @property {status} status The tour's status.
   * @property {number} index  Step index.
   * @property {string} type   Specific type (tour, step, beacon).
   *
   * @since 1.28.0
   * @since 1.38.0 Calls new callback prop.
   * @see {@link https://docs.react-joyride.com/callback} Example data provided by `react-joyride`.
   * @see {@link https://docs.react-joyride.com/constants} State & lifecycle constants used by `react-joyride`.
   *
   * @param {JoyrideCallbackData} data Data object provided via `react-joyride` callback prop.
   */
  function handleJoyrideCallback(data) {
    trackAllTourEvents(data);
    const {
      action,
      index,
      status,
      step,
      type
    } = data;
    const hasCloseAction = action === react_joyride__WEBPACK_IMPORTED_MODULE_8__.ACTIONS.CLOSE;
    const shouldChangeStep = !hasCloseAction && [react_joyride__WEBPACK_IMPORTED_MODULE_8__.EVENTS.STEP_AFTER, react_joyride__WEBPACK_IMPORTED_MODULE_8__.EVENTS.TARGET_NOT_FOUND].includes(type);
    const isFinishedOrSkipped = [react_joyride__WEBPACK_IMPORTED_MODULE_8__.STATUS.FINISHED, react_joyride__WEBPACK_IMPORTED_MODULE_8__.STATUS.SKIPPED].includes(status);
    const shouldCloseFromButtonClick = hasCloseAction && type === react_joyride__WEBPACK_IMPORTED_MODULE_8__.EVENTS.STEP_AFTER;
    const shouldEndTour = isFinishedOrSkipped || shouldCloseFromButtonClick;

    // Center the target in the viewport when transitioning to the step.
    if (react_joyride__WEBPACK_IMPORTED_MODULE_8__.EVENTS.STEP_BEFORE === type) {
      let el = step.target;
      if ('string' === typeof step.target) {
        el = __webpack_require__.g.document.querySelector(step.target);
      }
      el?.scrollIntoView?.({
        block: 'center'
      });
    }
    if (shouldChangeStep) {
      changeStep(index, action);
    } else if (shouldEndTour) {
      endTour();
    }
    if (callback) {
      callback(data, registry);
    }
  }

  // Start tour on initial render
  (0,react_use__WEBPACK_IMPORTED_MODULE_9__["default"])(startTour);
  const parsedSteps = steps.map(step => ({
    disableBeacon: true,
    isFixed: true,
    placement: 'auto',
    ...step
  }));
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(react_joyride__WEBPACK_IMPORTED_MODULE_8__["default"], {
    callback: handleJoyrideCallback,
    floaterProps: floaterProps,
    locale: joyrideLocale,
    run: run,
    stepIndex: stepIndex,
    steps: parsedSteps,
    styles: joyrideStyles,
    tooltipComponent: _TourTooltip__WEBPACK_IMPORTED_MODULE_5__["default"],
    continuous: true,
    disableOverlayClose: true,
    disableScrolling: true,
    showProgress: true
  });
}

/** For available properties & docs for `steps`, see: {@link https://docs.react-joyride.com/step#options}. */
TourTooltips.propTypes = {
  steps: prop_types__WEBPACK_IMPORTED_MODULE_10___default().arrayOf((prop_types__WEBPACK_IMPORTED_MODULE_10___default().object)).isRequired,
  tourID: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().string).isRequired,
  gaEventCategory: prop_types__WEBPACK_IMPORTED_MODULE_10___default().oneOfType([(prop_types__WEBPACK_IMPORTED_MODULE_10___default().string), (prop_types__WEBPACK_IMPORTED_MODULE_10___default().func)]).isRequired,
  callback: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().func)
};

/***/ }),

/***/ "./js/components/Typography/P.js":
/*!***************************************!*\
  !*** ./js/components/Typography/P.js ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ P)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @/js/hooks/useBreakpoint */ "./js/hooks/useBreakpoint.js");
/* harmony import */ var ___WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! . */ "./js/components/Typography/index.js");
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./constants */ "./js/components/Typography/constants.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * Internal dependencies
 */




function P({
  type = _constants__WEBPACK_IMPORTED_MODULE_2__.TYPE_BODY,
  size,
  children,
  ...props
}) {
  const breakpoint = (0,_js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_0__.useBreakpoint)();
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(___WEBPACK_IMPORTED_MODULE_1__["default"], {
    as: "p",
    type: type,
    size: size || (breakpoint === _js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_0__.BREAKPOINT_SMALL ? _constants__WEBPACK_IMPORTED_MODULE_2__.SIZE_SMALL : _constants__WEBPACK_IMPORTED_MODULE_2__.SIZE_MEDIUM),
    ...props,
    children: children
  });
}
P.propTypes = {
  type: prop_types__WEBPACK_IMPORTED_MODULE_4___default().oneOf(_constants__WEBPACK_IMPORTED_MODULE_2__.VALID_TYPES),
  size: prop_types__WEBPACK_IMPORTED_MODULE_4___default().oneOf(_constants__WEBPACK_IMPORTED_MODULE_2__.VALID_SIZES)
};

/***/ }),

/***/ "./js/components/Typography/constants.js":
/*!***********************************************!*\
  !*** ./js/components/Typography/constants.js ***!
  \***********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   SIZE_LARGE: () => (/* binding */ SIZE_LARGE),
/* harmony export */   SIZE_MEDIUM: () => (/* binding */ SIZE_MEDIUM),
/* harmony export */   SIZE_SMALL: () => (/* binding */ SIZE_SMALL),
/* harmony export */   TYPE_BODY: () => (/* binding */ TYPE_BODY),
/* harmony export */   TYPE_DISPLAY: () => (/* binding */ TYPE_DISPLAY),
/* harmony export */   TYPE_HEADLINE: () => (/* binding */ TYPE_HEADLINE),
/* harmony export */   TYPE_LABEL: () => (/* binding */ TYPE_LABEL),
/* harmony export */   TYPE_TITLE: () => (/* binding */ TYPE_TITLE),
/* harmony export */   VALID_SIZES: () => (/* binding */ VALID_SIZES),
/* harmony export */   VALID_TYPES: () => (/* binding */ VALID_TYPES)
/* harmony export */ });
/**
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

const TYPE_DISPLAY = 'display';
const TYPE_HEADLINE = 'headline';
const TYPE_TITLE = 'title';
const TYPE_BODY = 'body';
const TYPE_LABEL = 'label';
const VALID_TYPES = [TYPE_BODY, TYPE_DISPLAY, TYPE_HEADLINE, TYPE_LABEL, TYPE_TITLE];
const SIZE_SMALL = 'small';
const SIZE_MEDIUM = 'medium';
const SIZE_LARGE = 'large';
const VALID_SIZES = [SIZE_SMALL, SIZE_MEDIUM, SIZE_LARGE];

/***/ }),

/***/ "./js/components/Typography/index.js":
/*!*******************************************!*\
  !*** ./js/components/Typography/index.js ***!
  \*******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Typography)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./constants */ "./js/components/Typography/constants.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * Internal dependencies
 */


function Typography({
  className,
  type,
  size,
  as: Component = 'span',
  children,
  ...props
}) {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)(Component, {
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-typography', className, {
      [`googlesitekit-typography--${type}`]: type && _constants__WEBPACK_IMPORTED_MODULE_1__.VALID_TYPES.includes(type),
      [`googlesitekit-typography--${size}`]: size && _constants__WEBPACK_IMPORTED_MODULE_1__.VALID_SIZES.includes(size)
    }),
    ...props,
    children: children
  });
}
Typography.propTypes = {
  className: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  type: prop_types__WEBPACK_IMPORTED_MODULE_3___default().oneOf(_constants__WEBPACK_IMPORTED_MODULE_1__.VALID_TYPES),
  size: prop_types__WEBPACK_IMPORTED_MODULE_3___default().oneOf(_constants__WEBPACK_IMPORTED_MODULE_1__.VALID_SIZES),
  as: prop_types__WEBPACK_IMPORTED_MODULE_3___default().oneOfType([(prop_types__WEBPACK_IMPORTED_MODULE_3___default().string), (prop_types__WEBPACK_IMPORTED_MODULE_3___default().elementType)])
};

/***/ }),

/***/ "./js/components/UserMenu/Details.js":
/*!*******************************************!*\
  !*** ./js/components/UserMenu/Details.js ***!
  \*******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Details)
/* harmony export */ });
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/googlesitekit/datastore/user/constants */ "./js/googlesitekit/datastore/user/constants.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * UserMenu Details component.
 *
 * Site Kit by Google, Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */



function Details() {
  const userPicture = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_2__.CORE_USER).getPicture());
  const userFullName = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_2__.CORE_USER).getFullName());
  const userEmail = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_2__.CORE_USER).getEmail());
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
    className: "googlesitekit-user-menu__details",
    "aria-label": (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Google account', 'google-site-kit'),
    children: [!!userPicture && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("img", {
      className: "googlesitekit-user-menu__details-avatar",
      src: userPicture,
      alt: ""
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
      className: "googlesitekit-user-menu__details-info",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("p", {
        className: "googlesitekit-user-menu__details-info__name",
        children: userFullName
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("p", {
        className: "googlesitekit-user-menu__details-info__email",
        "aria-label": (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Email', 'google-site-kit'),
        children: userEmail
      })]
    })]
  });
}

/***/ }),

/***/ "./js/components/UserMenu/Item.js":
/*!****************************************!*\
  !*** ./js/components/UserMenu/Item.js ***!
  \****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Item)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * UserMenu Item component.
 *
 * Site Kit by Google, Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


function Item({
  icon,
  label
}) {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
    className: "googlesitekit-user-menu__item",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", {
      className: "googlesitekit-user-menu__item-icon",
      children: icon
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("span", {
      className: "googlesitekit-user-menu__item-label",
      children: label
    })]
  });
}
Item.propTypes = {
  icon: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().node),
  label: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string)
};

/***/ }),

/***/ "./js/components/UserMenu/index.js":
/*!*****************************************!*\
  !*** ./js/components/UserMenu/index.js ***!
  \*****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ UserMenu)
/* harmony export */ });
/* harmony import */ var react_use__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! react-use */ "../node_modules/react-use/esm/useClickAway.js");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_keycodes__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! @wordpress/keycodes */ "../node_modules/@wordpress/keycodes/build-module/index.js");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! googlesitekit-components */ "googlesitekit-components");
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_components__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _js_components_ModalDialog__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/components/ModalDialog */ "./js/components/ModalDialog.js");
/* harmony import */ var _js_util__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/util */ "./js/util/index.js");
/* harmony import */ var _js_googlesitekit_api_cache__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/googlesitekit/api/cache */ "./js/googlesitekit/api/cache.js");
/* harmony import */ var _js_components_Portal__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @/js/components/Portal */ "./js/components/Portal.js");
/* harmony import */ var _Details__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./Details */ "./js/components/UserMenu/Details.js");
/* harmony import */ var _Item__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./Item */ "./js/components/UserMenu/Item.js");
/* harmony import */ var _svg_icons_disconnect_svg__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @/svg/icons/disconnect.svg */ "./svg/icons/disconnect.svg");
/* harmony import */ var _svg_icons_manage_sites_svg__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @/svg/icons/manage-sites.svg */ "./svg/icons/manage-sites.svg");
/* harmony import */ var _js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @/js/googlesitekit/datastore/site/constants */ "./js/googlesitekit/datastore/site/constants.js");
/* harmony import */ var _js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! @/js/googlesitekit/datastore/user/constants */ "./js/googlesitekit/datastore/user/constants.js");
/* harmony import */ var _js_googlesitekit_datastore_location_constants__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! @/js/googlesitekit/datastore/location/constants */ "./js/googlesitekit/datastore/location/constants.js");
/* harmony import */ var _js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! @/js/modules/analytics-4/datastore/constants */ "./js/modules/analytics-4/datastore/constants.js");
/* harmony import */ var _js_hooks_useKeyCodesInside__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! @/js/hooks/useKeyCodesInside */ "./js/hooks/useKeyCodesInside.js");
/* harmony import */ var _js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! @/js/hooks/useViewContext */ "./js/hooks/useViewContext.js");
/* harmony import */ var _js_hooks_useFormValue__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! @/js/hooks/useFormValue */ "./js/hooks/useFormValue.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * UserMenu component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */




/**
 * Internal dependencies
 */


















function UserMenu() {
  const proxyPermissionsURL = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_11__.CORE_SITE).getProxyPermissionsURL());
  const userEmail = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_12__.CORE_USER).getEmail());
  const userPicture = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_12__.CORE_USER).getPicture());
  const userFullName = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_12__.CORE_USER).getFullName());
  const postDisconnectURL = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_11__.CORE_SITE).getAdminURL('googlesitekit-splash', {
    googlesitekit_context: 'revoked'
  }));
  const isAutoCreatingCustomDimensionsForAudience = (0,_js_hooks_useFormValue__WEBPACK_IMPORTED_MODULE_17__["default"])(_js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_14__.AUDIENCE_TILE_CUSTOM_DIMENSION_CREATE, 'isAutoCreatingCustomDimensionsForAudience');
  const [dialogActive, toggleDialog] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_19__.useState)(false);
  const [menuOpen, setMenuOpen] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_19__.useState)(false);
  const menuWrapperRef = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_19__.useRef)();
  const menuButtonRef = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_19__.useRef)();
  const viewContext = (0,_js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_16__["default"])();
  const {
    navigateTo
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useDispatch)(_js_googlesitekit_datastore_location_constants__WEBPACK_IMPORTED_MODULE_13__.CORE_LOCATION);
  (0,react_use__WEBPACK_IMPORTED_MODULE_20__["default"])(menuWrapperRef, () => setMenuOpen(false));
  (0,_js_hooks_useKeyCodesInside__WEBPACK_IMPORTED_MODULE_15__.useKeyCodesInside)([_wordpress_keycodes__WEBPACK_IMPORTED_MODULE_21__.ESCAPE, _wordpress_keycodes__WEBPACK_IMPORTED_MODULE_21__.TAB], menuWrapperRef, () => {
    setMenuOpen(false);
    // Reinstate menu button focus when menu is closed.
    menuButtonRef.current?.focus();
  });
  function handleClose() {
    toggleDialog(false);
    setMenuOpen(false);
  }
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_19__.useEffect)(() => {
    function handleEscapeKeyPress(e) {
      // Close if Escape key is pressed.
      if (_wordpress_keycodes__WEBPACK_IMPORTED_MODULE_21__.ESCAPE === e.keyCode) {
        handleClose();
      }
    }
    __webpack_require__.g.addEventListener('keyup', handleEscapeKeyPress);
    return () => {
      __webpack_require__.g.removeEventListener('keyup', handleEscapeKeyPress);
    };
  }, []);
  const handleMenu = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_19__.useCallback)(() => {
    if (!menuOpen) {
      (0,_js_util__WEBPACK_IMPORTED_MODULE_4__.trackEvent)(`${viewContext}_headerbar`, 'open_usermenu');
    }
    setMenuOpen(!menuOpen);
  }, [menuOpen, viewContext]);
  const handleDialog = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_19__.useCallback)(() => {
    toggleDialog(!dialogActive);
    setMenuOpen(false);
  }, [dialogActive]);
  const handleMenuItemSelect = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_19__.useCallback)(async (_index, event) => {
    const {
      detail: {
        item
      }
    } = event;
    switch (item?.id) {
      case 'manage-sites':
        if (proxyPermissionsURL) {
          await (0,_js_util__WEBPACK_IMPORTED_MODULE_4__.trackEvent)(`${viewContext}_headerbar_usermenu`, 'manage_sites');
          navigateTo(proxyPermissionsURL);
        }
        break;
      case 'disconnect':
        handleDialog();
        break;
      default:
        handleMenu();
    }
  }, [proxyPermissionsURL, handleMenu, handleDialog, navigateTo, viewContext]);

  // Log the user out if they confirm the dialog.
  const handleUnlinkConfirm = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_19__.useCallback)(async () => {
    // Close the modal.
    toggleDialog(false);
    await (0,_js_googlesitekit_api_cache__WEBPACK_IMPORTED_MODULE_5__.clearCache)();
    await (0,_js_util__WEBPACK_IMPORTED_MODULE_4__.trackEvent)(`${viewContext}_headerbar_usermenu`, 'disconnect_user');

    // Navigate back to the splash screen to reconnect.
    navigateTo(postDisconnectURL);
  }, [postDisconnectURL, navigateTo, viewContext]);
  if (!userEmail) {
    return null;
  }
  let accountLabel;
  if (userFullName && userEmail) {
    accountLabel = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.sprintf)(/* translators: Account info text. 1: User's (full) name 2: User's email address. */
    (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Google Account for %1$s (Email: %2$s)', 'google-site-kit'), userFullName, userEmail);
  }
  if (userFullName && !userEmail) {
    accountLabel = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.sprintf)(/* translators: Account info text. 1: User's (full) name. */
    (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Google Account for %1$s', 'google-site-kit'), userFullName);
  }
  if (!userFullName && userEmail) {
    accountLabel = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.sprintf)(/* translators: Account info text. 1: User's email address. */
    (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Google Account (Email: %1$s)', 'google-site-kit'), userEmail);
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsxs)(_wordpress_element__WEBPACK_IMPORTED_MODULE_19__.Fragment, {
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsxs)("div", {
      ref: menuWrapperRef,
      className: "googlesitekit-user-selector googlesitekit-dropdown-menu googlesitekit-dropdown-menu__icon-menu mdc-menu-surface--anchor",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_2__.Button, {
        disabled: isAutoCreatingCustomDimensionsForAudience,
        ref: menuButtonRef,
        className: "googlesitekit-header__dropdown mdc-button--dropdown googlesitekit-border-radius-round--tablet googlesitekit-border-radius-round--phone googlesitekit-border-radius-round googlesitekit-button-icon",
        onClick: handleMenu,
        icon: !!userPicture && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx)("i", {
          className: "mdc-button__icon mdc-button__account",
          "aria-hidden": "true",
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx)("img", {
            className: "mdc-button__icon--image",
            src: userPicture,
            alt: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('User Avatar', 'google-site-kit')
          })
        }),
        "aria-haspopup": "menu",
        "aria-expanded": menuOpen,
        "aria-controls": "user-menu",
        "aria-label": isAutoCreatingCustomDimensionsForAudience ? undefined : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Account', 'google-site-kit'),
        tooltipEnterDelayInMS: 500,
        customizedTooltip: isAutoCreatingCustomDimensionsForAudience ? null : /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsxs)("span", {
          "aria-label": accountLabel,
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx)("strong", {
            children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Google Account', 'google-site-kit')
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx)("br", {}), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx)("br", {}), userFullName, userFullName && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx)("br", {}), userEmail]
        }),
        text: true,
        tooltip: true
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsxs)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_2__.Menu, {
        className: "googlesitekit-user-menu",
        menuOpen: menuOpen,
        onSelected: handleMenuItemSelect,
        id: "user-menu",
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx)("li", {
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx)(_Details__WEBPACK_IMPORTED_MODULE_7__["default"], {})
        }), !!proxyPermissionsURL && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx)("li", {
          id: "manage-sites",
          className: "mdc-list-item",
          role: "menuitem",
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx)(_Item__WEBPACK_IMPORTED_MODULE_8__["default"], {
            icon: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx)(_svg_icons_manage_sites_svg__WEBPACK_IMPORTED_MODULE_10__["default"], {
              width: "22"
            }),
            label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Manage Sites', 'google-site-kit')
          })
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx)("li", {
          id: "disconnect",
          className: "mdc-list-item",
          role: "menuitem",
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx)(_Item__WEBPACK_IMPORTED_MODULE_8__["default"], {
            icon: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx)(_svg_icons_disconnect_svg__WEBPACK_IMPORTED_MODULE_9__["default"], {
              width: "22"
            }),
            label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Disconnect', 'google-site-kit')
          })
        })]
      })]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx)(_js_components_Portal__WEBPACK_IMPORTED_MODULE_6__["default"], {
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx)(_js_components_ModalDialog__WEBPACK_IMPORTED_MODULE_3__["default"], {
        dialogActive: dialogActive,
        handleConfirm: handleUnlinkConfirm,
        handleCancel: handleClose,
        onClose: handleClose,
        title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Disconnect', 'google-site-kit'),
        subtitle: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Disconnecting Site Kit by Google will remove your access to all services. After disconnecting, you will need to re-authorize to restore service.', 'google-site-kit'),
        confirmButton: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Disconnect', 'google-site-kit'),
        danger: true,
        small: true
      })
    })]
  });
}

/***/ }),

/***/ "./js/components/ViewOnlyMenu/Description.js":
/*!***************************************************!*\
  !*** ./js/components/ViewOnlyMenu/Description.js ***!
  \***************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Description)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/@wordpress/element/build-module/create-interpolate-element.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! googlesitekit-components */ "googlesitekit-components");
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_components__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _js_components_Typography_P__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/components/Typography/P */ "./js/components/Typography/P.js");
/* harmony import */ var _js_googlesitekit_datastore_location_constants__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/googlesitekit/datastore/location/constants */ "./js/googlesitekit/datastore/location/constants.js");
/* harmony import */ var _js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/googlesitekit/datastore/site/constants */ "./js/googlesitekit/datastore/site/constants.js");
/* harmony import */ var _js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @/js/googlesitekit/datastore/user/constants */ "./js/googlesitekit/datastore/user/constants.js");
/* harmony import */ var _js_util__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @/js/util */ "./js/util/index.js");
/* harmony import */ var _js_components_Link__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @/js/components/Link */ "./js/components/Link.js");
/* harmony import */ var _js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @/js/hooks/useViewContext */ "./js/hooks/useViewContext.js");
/* harmony import */ var _js_googlesitekit_api_cache__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @/js/googlesitekit/api/cache */ "./js/googlesitekit/api/cache.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * ViewOnlyMenu > Description component.
 *
 * Site Kit by Google, Copyright 2022 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */











function Description() {
  const viewContext = (0,_js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_9__["default"])();
  const canAuthenticate = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_6__.CORE_USER).hasCapability(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_6__.PERMISSION_AUTHENTICATE));
  const proxySetupURL = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_5__.CORE_SITE).getProxySetupURL());
  const documentationURL = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => {
    return select(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_5__.CORE_SITE).getDocumentationLinkURL('dashboard-sharing');
  });
  const {
    navigateTo
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useDispatch)(_js_googlesitekit_datastore_location_constants__WEBPACK_IMPORTED_MODULE_4__.CORE_LOCATION);
  const onButtonClick = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_12__.useCallback)(async event => {
    event.preventDefault();
    await Promise.all([
    // Cache the start of the user setup journey.
    // This will be used for event tracking logic after successful setup.
    (0,_js_googlesitekit_api_cache__WEBPACK_IMPORTED_MODULE_10__.setItem)('start_user_setup', true), (0,_js_util__WEBPACK_IMPORTED_MODULE_7__.trackEvent)(`${viewContext}_headerbar_viewonly`, 'start_user_setup', proxySetupURL ? 'proxy' : 'custom-oauth')]);
    navigateTo(proxySetupURL);
  }, [proxySetupURL, navigateTo, viewContext]);
  const onLinkClick = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_12__.useCallback)(() => {
    (0,_js_util__WEBPACK_IMPORTED_MODULE_7__.trackEvent)(`${viewContext}_headerbar_viewonly`, 'click_learn_more_link');
  }, [viewContext]);
  const description = canAuthenticate ? (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_13__["default"])((0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("You can see stats from all shared Google services, but you can't make any changes. <strong>Sign in to connect more services and control sharing access.</strong>", 'google-site-kit'), {
    strong: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("strong", {})
  }) : (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_13__["default"])((0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("You can see stats from all shared Google services, but you can't make any changes. <a>Learn more</a>", 'google-site-kit'), {
    a: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_js_components_Link__WEBPACK_IMPORTED_MODULE_8__["default"], {
      href: documentationURL,
      onClick: onLinkClick,
      "aria-label": (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Learn more about dashboard sharing', 'google-site-kit'),
      external: true
    })
  });
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("li", {
    className: "googlesitekit-view-only-menu__list-item googlesitekit-view-only-menu__description",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_js_components_Typography_P__WEBPACK_IMPORTED_MODULE_3__["default"], {
      children: description
    }), canAuthenticate && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_2__.Button, {
      onClick: onButtonClick,
      children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__._x)('Sign in with Google', 'Service name', 'google-site-kit')
    })]
  });
}

/***/ }),

/***/ "./js/components/ViewOnlyMenu/Service.js":
/*!***********************************************!*\
  !*** ./js/components/ViewOnlyMenu/Service.js ***!
  \***********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Service)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/@wordpress/element/build-module/create-interpolate-element.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/googlesitekit/modules/datastore/constants */ "./js/googlesitekit/modules/datastore/constants.js");
/* harmony import */ var _js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/googlesitekit/datastore/user/constants */ "./js/googlesitekit/datastore/user/constants.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * ViewOnlyMenu > Service component.
 *
 * Site Kit by Google, Copyright 2022 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */




function Service({
  module
}) {
  const canAuthenticate = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_USER).hasCapability(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_3__.PERMISSION_AUTHENTICATE));
  const {
    name,
    owner
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_2__.CORE_MODULES).getModule(module) || {});
  const Icon = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_2__.CORE_MODULES).getModuleIcon(module));
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsxs)("li", {
    className: "googlesitekit-view-only-menu__service",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("span", {
      className: "googlesitekit-view-only-menu__service--icon",
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(Icon, {
        height: 26
      })
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("span", {
      className: "googlesitekit-view-only-menu__service--name",
      children: name
    }), canAuthenticate && owner?.login && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("span", {
      className: "googlesitekit-view-only-menu__service--owner",
      children: (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_5__["default"])((0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.sprintf)(/* translators: %s: module owner Google Account email address */
      (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Shared by <strong>%s</strong>', 'google-site-kit'), owner.login), {
        strong: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("strong", {
          title: owner.login
        })
      })
    })]
  });
}
Service.propTypes = {
  module: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().string).isRequired
};

/***/ }),

/***/ "./js/components/ViewOnlyMenu/SharedServices.js":
/*!******************************************************!*\
  !*** ./js/components/ViewOnlyMenu/SharedServices.js ***!
  \******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ SharedServices)
/* harmony export */ });
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/googlesitekit/datastore/user/constants */ "./js/googlesitekit/datastore/user/constants.js");
/* harmony import */ var _Service__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./Service */ "./js/components/ViewOnlyMenu/Service.js");
/* harmony import */ var _js_components_Typography__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/components/Typography */ "./js/components/Typography/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * ViewOnlyMenu > SharedServices component.
 *
 * Site Kit by Google, Copyright 2022 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */





function SharedServices() {
  const viewableModules = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_2__.CORE_USER).getViewableModules());
  if (viewableModules === undefined) {
    return null;
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)("li", {
    className: "googlesitekit-view-only-menu__list-item",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_js_components_Typography__WEBPACK_IMPORTED_MODULE_4__["default"], {
      as: "h4",
      size: "large",
      type: "title",
      children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Shared services', 'google-site-kit')
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("ul", {
      children: viewableModules.map(moduleSlug => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_Service__WEBPACK_IMPORTED_MODULE_3__["default"], {
        module: moduleSlug
      }, moduleSlug))
    })]
  });
}

/***/ }),

/***/ "./js/components/ViewOnlyMenu/Tracking.js":
/*!************************************************!*\
  !*** ./js/components/ViewOnlyMenu/Tracking.js ***!
  \************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Tracking)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/@wordpress/element/build-module/create-interpolate-element.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _js_components_OptIn__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/components/OptIn */ "./js/components/OptIn.js");
/* harmony import */ var _js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/hooks/useViewContext */ "./js/hooks/useViewContext.js");
/* harmony import */ var _js_components_Typography_P__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/components/Typography/P */ "./js/components/Typography/P.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * ViewOnlyMenu > Tracking component.
 *
 * Site Kit by Google, Copyright 2022 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */




function Tracking() {
  const viewContext = (0,_js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_2__["default"])();
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsxs)("li", {
    className: "googlesitekit-view-only-menu__list-item",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(_js_components_Typography_P__WEBPACK_IMPORTED_MODULE_3__["default"], {
      children: (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_5__["default"])((0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Thanks for using Site Kit!<br />Help us make it even better', 'google-site-kit'), {
        br: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("br", {})
      })
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(_js_components_OptIn__WEBPACK_IMPORTED_MODULE_1__["default"], {
      trackEventCategory: `${viewContext}_headerbar_viewonly`,
      alignCheckboxLeft: true
    })]
  });
}

/***/ }),

/***/ "./js/components/ViewOnlyMenu/index.js":
/*!*********************************************!*\
  !*** ./js/components/ViewOnlyMenu/index.js ***!
  \*********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ ViewOnlyMenu)
/* harmony export */ });
/* harmony import */ var react_use__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! react-use */ "../node_modules/react-use/esm/useClickAway.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_keycodes__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! @wordpress/keycodes */ "../node_modules/@wordpress/keycodes/build-module/index.js");
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! googlesitekit-components */ "googlesitekit-components");
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_components__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/hooks/useViewContext */ "./js/hooks/useViewContext.js");
/* harmony import */ var _js_hooks_useKeyCodesInside__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/hooks/useKeyCodesInside */ "./js/hooks/useKeyCodesInside.js");
/* harmony import */ var _js_util__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/util */ "./js/util/index.js");
/* harmony import */ var _svg_icons_view_svg__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @/svg/icons/view.svg */ "./svg/icons/view.svg");
/* harmony import */ var _Description__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./Description */ "./js/components/ViewOnlyMenu/Description.js");
/* harmony import */ var _SharedServices__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./SharedServices */ "./js/components/ViewOnlyMenu/SharedServices.js");
/* harmony import */ var _Tracking__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./Tracking */ "./js/components/ViewOnlyMenu/Tracking.js");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_10__);
/* harmony import */ var _js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @/js/googlesitekit/datastore/user/constants */ "./js/googlesitekit/datastore/user/constants.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * ViewOnlyMenu component.
 *
 * Site Kit by Google, Copyright 2022 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * WordPress dependencies
 */




/**
 * Internal dependencies
 */











function ViewOnlyMenu() {
  const [menuOpen, setMenuOpen] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_13__.useState)(false);
  const menuWrapperRef = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_13__.useRef)();
  const viewContext = (0,_js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_3__["default"])();
  (0,react_use__WEBPACK_IMPORTED_MODULE_14__["default"])(menuWrapperRef, () => setMenuOpen(false));
  (0,_js_hooks_useKeyCodesInside__WEBPACK_IMPORTED_MODULE_4__.useKeyCodesInside)([_wordpress_keycodes__WEBPACK_IMPORTED_MODULE_15__.ESCAPE, _wordpress_keycodes__WEBPACK_IMPORTED_MODULE_15__.TAB], menuWrapperRef, () => setMenuOpen(false));
  const toggleMenu = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_13__.useCallback)(() => {
    if (!menuOpen) {
      (0,_js_util__WEBPACK_IMPORTED_MODULE_5__.trackEvent)(`${viewContext}_headerbar`, 'open_viewonly');
    }
    setMenuOpen(!menuOpen);
  }, [menuOpen, viewContext]);
  const canAuthenticate = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_10__.useSelect)(select => select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_11__.CORE_USER).hasCapability(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_11__.PERMISSION_AUTHENTICATE));
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsxs)("div", {
    ref: menuWrapperRef,
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-view-only-menu', 'googlesitekit-dropdown-menu', 'googlesitekit-dropdown-menu__icon-menu', 'mdc-menu-surface--anchor', {
      'googlesitekit-view-only-menu--user-can-authenticate': canAuthenticate
    }),
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_2__.Button, {
      className: "googlesitekit-header__dropdown mdc-button--dropdown googlesitekit-border-radius-round--phone googlesitekit-button-icon",
      onClick: toggleMenu,
      icon: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx)("span", {
        className: "mdc-button__icon",
        "aria-hidden": "true",
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx)(_svg_icons_view_svg__WEBPACK_IMPORTED_MODULE_6__["default"], {
          className: "mdc-button__icon--image"
        })
      }),
      "aria-haspopup": "menu",
      "aria-expanded": menuOpen,
      "aria-controls": "view-only-menu",
      "aria-label": (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('View only', 'google-site-kit'),
      tooltipEnterDelayInMS: 500,
      text: true,
      tooltip: true,
      children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('View only', 'google-site-kit')
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsxs)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_2__.Menu, {
      menuOpen: menuOpen,
      onSelected: toggleMenu,
      id: "view-only-menu",
      nonInteractive: true,
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx)(_Description__WEBPACK_IMPORTED_MODULE_7__["default"], {}), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx)(_SharedServices__WEBPACK_IMPORTED_MODULE_8__["default"], {}), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx)("li", {
        className: "mdc-list-divider",
        role: "separator"
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx)(_Tracking__WEBPACK_IMPORTED_MODULE_9__["default"], {})]
    })]
  });
}

/***/ }),

/***/ "./js/components/VisuallyHidden.js":
/*!*****************************************!*\
  !*** ./js/components/VisuallyHidden.js ***!
  \*****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Visually Hidden component, mainly used for screen-reader text.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



function VisuallyHidden({
  className,
  children,
  ...otherProps
}) {
  if (!children) {
    return null;
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("span", {
    ...otherProps,
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('screen-reader-text', className),
    children: children
  });
}
VisuallyHidden.propTypes = {
  className: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().string),
  children: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().node)
};
VisuallyHidden.defaultProps = {
  className: ''
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (VisuallyHidden);

/***/ }),

/***/ "./js/components/WidgetErrorHandler/index.js":
/*!***************************************************!*\
  !*** ./js/components/WidgetErrorHandler/index.js ***!
  \***************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var clipboard_copy__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! clipboard-copy */ "../node_modules/clipboard-copy/index.js");
/* harmony import */ var clipboard_copy__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(clipboard_copy__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _js_components_notifications_CTA__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/components/notifications/CTA */ "./js/components/notifications/CTA.js");
/* harmony import */ var _js_components_GenericErrorHandlerActions__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/components/GenericErrorHandlerActions */ "./js/components/GenericErrorHandlerActions.js");
/* harmony import */ var _js_components_Root_ViewContextContext__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/components/Root/ViewContextContext */ "./js/components/Root/ViewContextContext.js");
/* harmony import */ var _js_util__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/util */ "./js/util/index.js");
/* harmony import */ var _js_components_Typography_P__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @/js/components/Typography/P */ "./js/components/Typography/P.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * WidgetErrorHandler component.
 *
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */






class WidgetErrorHandler extends _wordpress_element__WEBPACK_IMPORTED_MODULE_8__.Component {
  constructor(props) {
    super(props);
    this.state = {
      error: null,
      info: null
    };
    this.onErrorClick = this.onErrorClick.bind(this);
  }
  componentDidCatch(error, info) {
    __webpack_require__.g.console.error('Widget error:', error, info);
    this.setState({
      error,
      info
    });
    (0,_js_util__WEBPACK_IMPORTED_MODULE_5__.trackEvent)('widget_error', `handle_${this.context || 'unknown'}_error`,
    // label has a max-length of 500 bytes.
    `${this.props.slug}_${error?.message}\n${info?.componentStack}`.slice(0, 500 - this.props.slug.length - 1));
  }
  onErrorClick() {
    const {
      error,
      info
    } = this.state;

    // Copy message with wrapping backticks for code block formatting on wp.org.
    clipboard_copy__WEBPACK_IMPORTED_MODULE_0___default()(`\`${error?.message}\n${info?.componentStack}\``);
  }
  render() {
    const {
      children
    } = this.props;
    const {
      error,
      info
    } = this.state;

    // If there is no caught error, render the children components normally.
    if (!error) {
      return children;
    }
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)("div", {
      className: "googlesitekit-widget-error-handler",
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_js_components_notifications_CTA__WEBPACK_IMPORTED_MODULE_2__["default"], {
        description: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsxs)(_wordpress_element__WEBPACK_IMPORTED_MODULE_8__.Fragment, {
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_js_components_Typography_P__WEBPACK_IMPORTED_MODULE_6__["default"], {
            children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('An error prevented this Widget from being displayed properly. Report the exact contents of the error on the support forum to find out what caused it.', 'google-site-kit')
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_js_components_GenericErrorHandlerActions__WEBPACK_IMPORTED_MODULE_3__["default"], {
            message: error.message,
            componentStack: info.componentStack
          })]
        }),
        onErrorClick: this.onErrorClick,
        onClick: this.onErrorClick,
        title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Error in Widget', 'google-site-kit'),
        error: true
      })
    });
  }
}
WidgetErrorHandler.contextType = _js_components_Root_ViewContextContext__WEBPACK_IMPORTED_MODULE_4__["default"];
WidgetErrorHandler.propTypes = {
  /** @ignore */
  children: (prop_types__WEBPACK_IMPORTED_MODULE_9___default().node).isRequired
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (WidgetErrorHandler);

/***/ }),

/***/ "./js/components/dashboard-sharing/DashboardSharingDialog/Footer/Notice.js":
/*!*********************************************************************************!*\
  !*** ./js/components/dashboard-sharing/DashboardSharingDialog/Footer/Notice.js ***!
  \*********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Notice)
/* harmony export */ });
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/@wordpress/element/build-module/create-interpolate-element.js");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/googlesitekit/modules/datastore/constants */ "./js/googlesitekit/modules/datastore/constants.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * DashboardSharingSettings Notice component.
 *
 * Site Kit by Google, Copyright 2022 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */



function Notice() {
  const canSubmitSharingChanges = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_2__.CORE_MODULES).canSubmitSharingChanges());
  const haveSharingSettingsChangedManagement = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_2__.CORE_MODULES).haveSharingSettingsExpanded('management'));
  const haveSharingSettingsChangedRoles = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_2__.CORE_MODULES).haveSharingSettingsExpanded('sharedRoles'));
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("p", {
    className: "googlesitekit-dashboard-sharing-settings__notice",
    children: [haveSharingSettingsChangedManagement && canSubmitSharingChanges && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("span", {
      children: (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_4__["default"])((0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('By clicking <strong>Apply</strong>, you will give other authenticated admins of your site permission to manage view-only access to Site Kit dashboard data from the chosen Google service', 'google-site-kit'), {
        strong: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("strong", {})
      })
    }), !haveSharingSettingsChangedManagement && canSubmitSharingChanges && haveSharingSettingsChangedRoles && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("span", {
      children: (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_4__["default"])((0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('By clicking <strong>Apply</strong>, you’re granting the selected roles view-only access to data from the Google services you’ve connected via your account', 'google-site-kit'), {
        strong: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("strong", {})
      })
    })]
  });
}

/***/ }),

/***/ "./js/components/dashboard-sharing/DashboardSharingDialog/Footer/index.js":
/*!********************************************************************************!*\
  !*** ./js/components/dashboard-sharing/DashboardSharingDialog/Footer/index.js ***!
  \********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Footer)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_13___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_13__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-components */ "googlesitekit-components");
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/googlesitekit/modules/datastore/constants */ "./js/googlesitekit/modules/datastore/constants.js");
/* harmony import */ var _js_googlesitekit_datastore_ui_constants__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/googlesitekit/datastore/ui/constants */ "./js/googlesitekit/datastore/ui/constants.js");
/* harmony import */ var _js_components_dashboard_sharing_DashboardSharingSettings_constants__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/components/dashboard-sharing/DashboardSharingSettings/constants */ "./js/components/dashboard-sharing/DashboardSharingSettings/constants.js");
/* harmony import */ var _js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @/js/hooks/useViewContext */ "./js/hooks/useViewContext.js");
/* harmony import */ var _js_util__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @/js/util */ "./js/util/index.js");
/* harmony import */ var _js_components_Link__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @/js/components/Link */ "./js/components/Link.js");
/* harmony import */ var _Notice__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./Notice */ "./js/components/dashboard-sharing/DashboardSharingDialog/Footer/Notice.js");
/* harmony import */ var _js_components_ErrorNotice__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @/js/components/ErrorNotice */ "./js/components/ErrorNotice.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * DashboardSharingSettings Footer component.
 *
 * Site Kit by Google, Copyright 2022 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */











function Footer({
  closeDialog,
  openResetDialog
}) {
  const viewContext = (0,_js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_6__["default"])();
  const [errorNotice, setErrorNotice] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_12__.useState)(null);
  const [isResetting, setIsResetting] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_12__.useState)(false);
  const canSubmitSharingChanges = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.useSelect)(select => select(_js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_MODULES).canSubmitSharingChanges());
  const isSaving = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.useSelect)(select => select(_js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_MODULES).isDoingSubmitSharingChanges());
  const haveSharingSettingsChangedManagement = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.useSelect)(select => select(_js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_MODULES).haveSharingSettingsExpanded('management'));
  const haveSharingSettingsChangedRoles = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.useSelect)(select => select(_js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_MODULES).haveSharingSettingsExpanded('sharedRoles'));
  const haveSharingSettingsUpdated = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.useSelect)(select => select(_js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_MODULES).haveSharingSettingsUpdated());
  const settingsDialogOpen = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.useSelect)(select => !!select(_js_googlesitekit_datastore_ui_constants__WEBPACK_IMPORTED_MODULE_4__.CORE_UI).getValue(_js_components_dashboard_sharing_DashboardSharingSettings_constants__WEBPACK_IMPORTED_MODULE_5__.SETTINGS_DIALOG));
  const resetDialogOpen = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.useSelect)(select => !!select(_js_googlesitekit_datastore_ui_constants__WEBPACK_IMPORTED_MODULE_4__.CORE_UI).getValue(_js_components_dashboard_sharing_DashboardSharingSettings_constants__WEBPACK_IMPORTED_MODULE_5__.RESET_SETTINGS_DIALOG));
  const {
    resetSharingSettings,
    saveSharingSettings
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.useDispatch)(_js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_MODULES);
  const {
    setValue
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.useDispatch)(_js_googlesitekit_datastore_ui_constants__WEBPACK_IMPORTED_MODULE_4__.CORE_UI);
  const onApply = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_12__.useCallback)(async () => {
    setErrorNotice(null);
    const {
      error
    } = await saveSharingSettings();
    if (error) {
      setErrorNotice(error.message);
      return;
    }
    (0,_js_util__WEBPACK_IMPORTED_MODULE_7__.trackEvent)(`${viewContext}_sharing`, 'settings_confirm');

    // Reset the state to enable modules in when not editing or saving.
    setValue(_js_components_dashboard_sharing_DashboardSharingSettings_constants__WEBPACK_IMPORTED_MODULE_5__.EDITING_USER_ROLE_SELECT_SLUG_KEY, undefined);
    closeDialog();
  }, [viewContext, saveSharingSettings, setValue, closeDialog]);
  const onReset = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_12__.useCallback)(async () => {
    setErrorNotice(null);
    setIsResetting(true);
    const {
      error
    } = await resetSharingSettings();
    if (error) {
      setErrorNotice(error.message);
      return;
    }
    setIsResetting(false);
    closeDialog();
  }, [closeDialog, resetSharingSettings]);
  const onCancel = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_12__.useCallback)(() => {
    (0,_js_util__WEBPACK_IMPORTED_MODULE_7__.trackEvent)(`${viewContext}_sharing`, 'settings_cancel');
    closeDialog();
  }, [closeDialog, viewContext]);
  const showNotice = errorNotice || haveSharingSettingsChangedManagement || haveSharingSettingsChangedRoles;
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("div", {
    className: "googlesitekit-dashboard-sharing-settings__footer",
    children: [showNotice && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("div", {
      className: "googlesitekit-dashboard-sharing-settings__footer-notice",
      children: [errorNotice && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_js_components_ErrorNotice__WEBPACK_IMPORTED_MODULE_10__["default"], {
        message: errorNotice
      }), !errorNotice && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_Notice__WEBPACK_IMPORTED_MODULE_9__["default"], {})]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("div", {
      className: "googlesitekit-dashboard-sharing-settings__footer-actions",
      children: [haveSharingSettingsUpdated && settingsDialogOpen && !showNotice && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("div", {
        className: "googlesitekit-dashboard-sharing-settings__footer-actions-left",
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_js_components_Link__WEBPACK_IMPORTED_MODULE_8__["default"], {
          onClick: openResetDialog,
          className: "googlesitekit-reset-sharing-permissions-button",
          danger: true,
          children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Reset sharing permissions', 'google-site-kit')
        })
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("div", {
        className: "googlesitekit-dashboard-sharing-settings__footer-actions-right",
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__.Button, {
          onClick: onCancel,
          tertiary: true,
          children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Cancel', 'google-site-kit')
        }), settingsDialogOpen && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__.SpinnerButton, {
          onClick: onApply,
          disabled: isSaving || !canSubmitSharingChanges,
          isSaving: isSaving,
          children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Apply', 'google-site-kit')
        }), resetDialogOpen && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__.SpinnerButton, {
          onClick: onReset,
          disabled: isResetting,
          isSaving: isResetting,
          danger: true,
          children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Reset', 'google-site-kit')
        })]
      })]
    })]
  });
}
Footer.propTypes = {
  closeDialog: (prop_types__WEBPACK_IMPORTED_MODULE_13___default().func).isRequired,
  openResetDialog: (prop_types__WEBPACK_IMPORTED_MODULE_13___default().func).isRequired
};

/***/ }),

/***/ "./js/components/dashboard-sharing/DashboardSharingDialog/index.js":
/*!*************************************************************************!*\
  !*** ./js/components/dashboard-sharing/DashboardSharingDialog/index.js ***!
  \*************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ DashboardSharingDialog)
/* harmony export */ });
/* harmony import */ var react_use__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! react-use */ "../node_modules/react-use/esm/useWindowScroll.js");
/* harmony import */ var react_use__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! react-use */ "../node_modules/react-use/esm/useKey.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/@wordpress/element/build-module/create-interpolate-element.js");
/* harmony import */ var _wordpress_keycodes__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! @wordpress/keycodes */ "../node_modules/@wordpress/keycodes/build-module/index.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! @wordpress/icons */ "../node_modules/@wordpress/icons/build-module/icon/index.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(/*! @wordpress/icons */ "../node_modules/@wordpress/icons/build-module/library/arrow-left.js");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! googlesitekit-components */ "googlesitekit-components");
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_components__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _js_googlesitekit_datastore_ui_constants__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/googlesitekit/datastore/ui/constants */ "./js/googlesitekit/datastore/ui/constants.js");
/* harmony import */ var _js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/googlesitekit/datastore/site/constants */ "./js/googlesitekit/datastore/site/constants.js");
/* harmony import */ var _js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @/js/googlesitekit/modules/datastore/constants */ "./js/googlesitekit/modules/datastore/constants.js");
/* harmony import */ var _js_components_dashboard_sharing_DashboardSharingSettings_constants__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @/js/components/dashboard-sharing/DashboardSharingSettings/constants */ "./js/components/dashboard-sharing/DashboardSharingSettings/constants.js");
/* harmony import */ var _js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @/js/hooks/useBreakpoint */ "./js/hooks/useBreakpoint.js");
/* harmony import */ var _js_components_Portal__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @/js/components/Portal */ "./js/components/Portal.js");
/* harmony import */ var _js_material_components__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @/js/material-components */ "./js/material-components/index.js");
/* harmony import */ var _svg_icons_share_svg__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @/svg/icons/share.svg */ "./svg/icons/share.svg");
/* harmony import */ var _js_components_Link__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! @/js/components/Link */ "./js/components/Link.js");
/* harmony import */ var _js_components_dashboard_sharing_DashboardSharingSettings__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! @/js/components/dashboard-sharing/DashboardSharingSettings */ "./js/components/dashboard-sharing/DashboardSharingSettings/index.js");
/* harmony import */ var _Footer__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ./Footer */ "./js/components/dashboard-sharing/DashboardSharingDialog/Footer/index.js");
/* harmony import */ var _js_components_Typography__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! @/js/components/Typography */ "./js/components/Typography/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * DashboardSharingDialog component.
 *
 * Site Kit by Google, Copyright 2022 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * WordPress dependencies
 */





/**
 * Internal dependencies
 */















function DashboardSharingDialog() {
  const [shouldFocusResetButton, setShouldFocusResetButton] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_17__.useState)(false);
  const ref = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_17__.useRef)(undefined);
  const breakpoint = (0,_js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_8__.useBreakpoint)();
  const {
    y
  } = (0,react_use__WEBPACK_IMPORTED_MODULE_18__["default"])();
  const {
    setValue
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.useDispatch)(_js_googlesitekit_datastore_ui_constants__WEBPACK_IMPORTED_MODULE_4__.CORE_UI);
  const {
    rollbackSharingSettings
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.useDispatch)(_js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_6__.CORE_MODULES);
  const settingsDialogOpen = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.useSelect)(select => !!select(_js_googlesitekit_datastore_ui_constants__WEBPACK_IMPORTED_MODULE_4__.CORE_UI).getValue(_js_components_dashboard_sharing_DashboardSharingSettings_constants__WEBPACK_IMPORTED_MODULE_7__.SETTINGS_DIALOG));
  const resetDialogOpen = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.useSelect)(select => !!select(_js_googlesitekit_datastore_ui_constants__WEBPACK_IMPORTED_MODULE_4__.CORE_UI).getValue(_js_components_dashboard_sharing_DashboardSharingSettings_constants__WEBPACK_IMPORTED_MODULE_7__.RESET_SETTINGS_DIALOG));
  const editingUserRoleSelect = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.useSelect)(select => select(_js_googlesitekit_datastore_ui_constants__WEBPACK_IMPORTED_MODULE_4__.CORE_UI).getValue(_js_components_dashboard_sharing_DashboardSharingSettings_constants__WEBPACK_IMPORTED_MODULE_7__.EDITING_USER_ROLE_SELECT_SLUG_KEY));
  const haveSettingsChanged = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.useSelect)(select => select(_js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_6__.CORE_MODULES).haveSharingSettingsChanged());
  const documentationURL = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.useSelect)(select => {
    return select(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_5__.CORE_SITE).getDocumentationLinkURL('dashboard-sharing');
  });
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_17__.useEffect)(() => {
    if (shouldFocusResetButton) {
      const resetButton = document.querySelector('.googlesitekit-reset-sharing-permissions-button');
      if (resetButton) {
        resetButton.focus();
      }
      setShouldFocusResetButton(false);
    }
  }, [shouldFocusResetButton]);
  const dialogStyles = {};
  // On mobile, the dialog box's flexbox is set to stretch items within to cover
  // the whole screen. But we have to move the box and adjust its height below the
  // WP Admin bar of 46px which gradually scrolls off the screen.
  if (breakpoint === _js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_8__.BREAKPOINT_SMALL) {
    dialogStyles.top = `${y < 46 ? 46 - y : 0}px`;
    dialogStyles.height = `calc(100% - 46px + ${y < 46 ? y : 46}px)`;
  }

  // Rollback any temporary selections to saved values if settings have changed and modal is closed.
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_17__.useEffect)(() => {
    if (!settingsDialogOpen && haveSettingsChanged) {
      rollbackSharingSettings();
    }
  }, [settingsDialogOpen, haveSettingsChanged, rollbackSharingSettings]);
  const openSettingsDialog = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_17__.useCallback)(() => {
    setValue(_js_components_dashboard_sharing_DashboardSharingSettings_constants__WEBPACK_IMPORTED_MODULE_7__.SETTINGS_DIALOG, true);
  }, [setValue]);
  const closeSettingsDialog = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_17__.useCallback)(() => {
    setValue(_js_components_dashboard_sharing_DashboardSharingSettings_constants__WEBPACK_IMPORTED_MODULE_7__.SETTINGS_DIALOG, false);
    setValue(_js_components_dashboard_sharing_DashboardSharingSettings_constants__WEBPACK_IMPORTED_MODULE_7__.EDITING_USER_ROLE_SELECT_SLUG_KEY, undefined);
  }, [setValue]);
  const openResetDialog = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_17__.useCallback)(() => {
    closeSettingsDialog();
    setValue(_js_components_dashboard_sharing_DashboardSharingSettings_constants__WEBPACK_IMPORTED_MODULE_7__.RESET_SETTINGS_DIALOG, true);
  }, [closeSettingsDialog, setValue]);
  const closeResetDialog = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_17__.useCallback)(() => {
    setValue(_js_components_dashboard_sharing_DashboardSharingSettings_constants__WEBPACK_IMPORTED_MODULE_7__.RESET_SETTINGS_DIALOG, false);
    openSettingsDialog();
    setShouldFocusResetButton(true);
  }, [openSettingsDialog, setValue]);
  const closeDialog = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_17__.useCallback)(() => {
    if (resetDialogOpen) {
      closeResetDialog();
      return;
    }
    closeSettingsDialog();
  }, [closeResetDialog, closeSettingsDialog, resetDialogOpen]);

  // Handle scrim click for reset dialog.
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_17__.useEffect)(() => {
    if (!resetDialogOpen || !ref.current) {
      return () => {};
    }
    const {
      current: {
        ownerDocument
      }
    } = ref;
    function handleScrimClick(event) {
      if (event.target.classList.contains('mdc-dialog__scrim')) {
        closeResetDialog();
      }
    }
    ownerDocument.addEventListener('click', handleScrimClick);
    return () => {
      ownerDocument.removeEventListener('click', handleScrimClick);
    };
  }, [ref, resetDialogOpen, closeResetDialog]);

  // Pressing the Escape key should close the reset dialog.
  (0,react_use__WEBPACK_IMPORTED_MODULE_19__["default"])(event => resetDialogOpen && _wordpress_keycodes__WEBPACK_IMPORTED_MODULE_20__.ESCAPE === event.keyCode, closeResetDialog);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx)(_js_components_Portal__WEBPACK_IMPORTED_MODULE_9__["default"], {
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsxs)(_js_material_components__WEBPACK_IMPORTED_MODULE_10__.Dialog, {
      open: settingsDialogOpen || resetDialogOpen,
      onClose: closeDialog,
      className: "googlesitekit-dialog googlesitekit-sharing-settings-dialog",
      style: dialogStyles
      /* Prevent default modal behavior as we are simulating multiple modals within a single modal here for the settings and reset dialogs. */,
      escapeKeyAction: editingUserRoleSelect === undefined && !resetDialogOpen ? 'close' : '',
      scrimClickAction: editingUserRoleSelect === undefined && !resetDialogOpen ? 'close' : '',
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx)("div", {
        className: "googlesitekit-dialog__back-wrapper",
        "aria-hidden": breakpoint !== _js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_8__.BREAKPOINT_SMALL,
        ref: ref,
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_3__.Button, {
          "aria-label": (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Back', 'google-site-kit'),
          className: "googlesitekit-dialog__back",
          onClick: closeDialog,
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx)(_wordpress_icons__WEBPACK_IMPORTED_MODULE_21__["default"], {
            icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_22__["default"]
          })
        })
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsxs)(_js_material_components__WEBPACK_IMPORTED_MODULE_10__.DialogContent, {
        className: "googlesitekit-dialog__content",
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsxs)("div", {
          className: "googlesitekit-dialog__header",
          children: [settingsDialogOpen && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx)("div", {
            className: "googlesitekit-dialog__header-icon",
            "aria-hidden": breakpoint === _js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_8__.BREAKPOINT_SMALL,
            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx)("span", {
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx)(_svg_icons_share_svg__WEBPACK_IMPORTED_MODULE_11__["default"], {
                width: 20,
                height: 20
              })
            })
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsxs)("div", {
            className: "googlesitekit-dialog__header-titles",
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsxs)(_js_components_Typography__WEBPACK_IMPORTED_MODULE_15__["default"], {
              as: "h2",
              className: "googlesitekit-dialog__title",
              size: "medium",
              type: "headline",
              children: [settingsDialogOpen && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx)("span", {
                children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Dashboard sharing & permissions', 'google-site-kit')
              }), resetDialogOpen && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx)("span", {
                children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Reset dashboard sharing permissions', 'google-site-kit')
              })]
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsxs)("p", {
              className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-dialog__subtitle', {
                'googlesitekit-dialog__subtitle--emphasis': resetDialogOpen
              }),
              children: [settingsDialogOpen && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx)("span", {
                children: (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_23__["default"])((0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Share a view-only version of your Site Kit dashboard with other WordPress roles. <a>Learn more</a>', 'google-site-kit'), {
                  a: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx)(_js_components_Link__WEBPACK_IMPORTED_MODULE_12__["default"], {
                    "aria-label": (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Learn more about dashboard sharing', 'google-site-kit'),
                    href: documentationURL,
                    external: true
                  })
                })
              }), resetDialogOpen && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx)("span", {
                children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Warning: Resetting these permissions will remove view-only access for all users. Are you sure you want to reset all dashboard sharing permissions?', 'google-site-kit')
              })]
            })]
          })]
        }), settingsDialogOpen && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx)("div", {
          className: "googlesitekit-dialog__main",
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx)(_js_components_dashboard_sharing_DashboardSharingSettings__WEBPACK_IMPORTED_MODULE_13__["default"], {})
        })]
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx)(_js_material_components__WEBPACK_IMPORTED_MODULE_10__.DialogFooter, {
        className: "googlesitekit-dialog__footer",
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx)(_Footer__WEBPACK_IMPORTED_MODULE_14__["default"], {
          closeDialog: closeDialog,
          openResetDialog: openResetDialog
        })
      })]
    })
  });
}

/***/ }),

/***/ "./js/components/dashboard-sharing/DashboardSharingSettings/Module.js":
/*!****************************************************************************!*\
  !*** ./js/components/dashboard-sharing/DashboardSharingSettings/Module.js ***!
  \****************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Module)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_14___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_14__);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _js_components_ModuleIcon__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/components/ModuleIcon */ "./js/components/ModuleIcon.js");
/* harmony import */ var _js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/hooks/useViewContext */ "./js/hooks/useViewContext.js");
/* harmony import */ var _js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/googlesitekit/modules/datastore/constants */ "./js/googlesitekit/modules/datastore/constants.js");
/* harmony import */ var _js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/googlesitekit/datastore/site/constants */ "./js/googlesitekit/datastore/site/constants.js");
/* harmony import */ var _js_googlesitekit_datastore_ui_constants__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @/js/googlesitekit/datastore/ui/constants */ "./js/googlesitekit/datastore/ui/constants.js");
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./constants */ "./js/components/dashboard-sharing/DashboardSharingSettings/constants.js");
/* harmony import */ var _js_util__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @/js/util */ "./js/util/index.js");
/* harmony import */ var _js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @/js/googlesitekit/datastore/user/constants */ "./js/googlesitekit/datastore/user/constants.js");
/* harmony import */ var _ModuleViewAccess__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./ModuleViewAccess */ "./js/components/dashboard-sharing/DashboardSharingSettings/ModuleViewAccess.js");
/* harmony import */ var _ModuleManageAccess__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./ModuleManageAccess */ "./js/components/dashboard-sharing/DashboardSharingSettings/ModuleManageAccess.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * DashboardSharingSettings Module component.
 *
 * Site Kit by Google, Copyright 2022 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */












function Module({
  moduleSlug,
  moduleName,
  ownerUsername,
  recoverable
}) {
  const viewContext = (0,_js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_3__["default"])();
  const moduleRef = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_13__.useRef)();
  const [manageViewAccess, setManageViewAccess] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_13__.useState)(undefined);
  const hasRecoverableModules = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_4__.CORE_MODULES).hasRecoverableModules());
  const hasMultipleAdmins = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_5__.CORE_SITE).hasMultipleAdmins());
  const showManageColumn = hasRecoverableModules || hasMultipleAdmins;
  const management = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => {
    var _select$getSharingMan;
    return (_select$getSharingMan = select(_js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_4__.CORE_MODULES).getSharingManagement(moduleSlug)) !== null && _select$getSharingMan !== void 0 ? _select$getSharingMan : 'owner';
  });
  const hasOwnedModule = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_9__.CORE_USER).hasCapability(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_9__.PERMISSION_DELEGATE_MODULE_SHARING_MANAGEMENT, moduleSlug));
  const hasSharingCapability = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_9__.CORE_USER).hasCapability(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_9__.PERMISSION_MANAGE_MODULE_SHARING_OPTIONS, moduleSlug));
  const sharedOwnershipModules = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_4__.CORE_MODULES).getSharedOwnershipModules());
  const editingUserRolesSlug = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_datastore_ui_constants__WEBPACK_IMPORTED_MODULE_6__.CORE_UI).getValue(_constants__WEBPACK_IMPORTED_MODULE_7__.EDITING_USER_ROLE_SELECT_SLUG_KEY));
  const isSaving = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_4__.CORE_MODULES).isDoingSubmitSharingChanges());
  const recoverableModuleSupportLink = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_5__.CORE_SITE).getDocumentationLinkURL('dashboard-sharing-module-recovery'));
  const {
    setSharingManagement
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useDispatch)(_js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_4__.CORE_MODULES);
  const sharedOwnershipModule = sharedOwnershipModules && Object.keys(sharedOwnershipModules).includes(moduleSlug);
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_13__.useEffect)(() => {
    if (sharedOwnershipModule) {
      setManageViewAccess('all_admins');
    } else {
      setManageViewAccess(management);
    }
  }, [management, sharedOwnershipModule]);
  const haveSharingSettingsManagementChanged = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_4__.CORE_MODULES).haveModuleSharingSettingsChanged(moduleSlug, 'management'));
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_13__.useEffect)(() => {
    if (haveSharingSettingsManagementChanged) {
      (0,_js_util__WEBPACK_IMPORTED_MODULE_8__.trackEvent)(`${viewContext}_sharing`, `change_management_${management}`, moduleSlug);
    }
  }, [haveSharingSettingsManagementChanged, management, moduleSlug, viewContext]);
  const handleOnChange = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_13__.useCallback)(event => {
    const value = event.target.value;
    setManageViewAccess(value);
    setSharingManagement(moduleSlug, value);
  }, [setSharingManagement, setManageViewAccess, moduleSlug]);
  const isEditingUserRoles = moduleSlug === editingUserRolesSlug;
  const isLocked = !isEditingUserRoles && editingUserRolesSlug !== undefined || isSaving;
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsxs)("div", {
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-dashboard-sharing-settings__module', 'googlesitekit-dashboard-sharing-settings__row', {
      'googlesitekit-dashboard-sharing-settings__row--editing': isEditingUserRoles,
      'googlesitekit-dashboard-sharing-settings__row--disabled': isLocked
    }),
    ref: moduleRef,
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsxs)("div", {
      className: "googlesitekit-dashboard-sharing-settings__column--product",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx)(_js_components_ModuleIcon__WEBPACK_IMPORTED_MODULE_2__["default"], {
        slug: moduleSlug,
        size: 48
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx)("span", {
        className: "googlesitekit-dashboard-sharing-settings__module-name",
        children: moduleName
      })]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx)("div", {
      className: "googlesitekit-dashboard-sharing-settings__column--view",
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx)(_ModuleViewAccess__WEBPACK_IMPORTED_MODULE_10__["default"], {
        moduleSlug: moduleSlug,
        isLocked: isLocked,
        hasSharingCapability: hasSharingCapability,
        recoverable: recoverable,
        recoverableModuleSupportLink: recoverableModuleSupportLink,
        ref: moduleRef
      })
    }), showManageColumn && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx)("div", {
      className: "googlesitekit-dashboard-sharing-settings__column--manage",
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx)(_ModuleManageAccess__WEBPACK_IMPORTED_MODULE_11__["default"], {
        sharedOwnershipModule: sharedOwnershipModule,
        hasOwnedModule: hasOwnedModule,
        ownerUsername: ownerUsername,
        hasSharingCapability: hasSharingCapability,
        manageViewAccess: manageViewAccess,
        onChange: handleOnChange
      })
    })]
  });
}
Module.propTypes = {
  moduleSlug: (prop_types__WEBPACK_IMPORTED_MODULE_14___default().string).isRequired,
  moduleName: (prop_types__WEBPACK_IMPORTED_MODULE_14___default().string).isRequired,
  ownerUsername: (prop_types__WEBPACK_IMPORTED_MODULE_14___default().string),
  recoverable: (prop_types__WEBPACK_IMPORTED_MODULE_14___default().bool)
};

/***/ }),

/***/ "./js/components/dashboard-sharing/DashboardSharingSettings/ModuleManageAccess.js":
/*!****************************************************************************************!*\
  !*** ./js/components/dashboard-sharing/DashboardSharingSettings/ModuleManageAccess.js ***!
  \****************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ ModuleManageAccess)
/* harmony export */ });
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/icons */ "../node_modules/@wordpress/icons/build-module/icon/index.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @wordpress/icons */ "../node_modules/@wordpress/icons/build-module/library/info.js");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/@wordpress/element/build-module/create-interpolate-element.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-components */ "googlesitekit-components");
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * ModuleManageAccess component for DashboardSharingSettings.
 *
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */




/**
 * Internal dependencies
 */



const viewAccessOptions = [{
  value: 'owner',
  label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Only me', 'google-site-kit')
}, {
  value: 'all_admins',
  label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Any admin signed in with Google', 'google-site-kit')
}];
function ModuleManageAccess({
  sharedOwnershipModule,
  hasOwnedModule,
  ownerUsername,
  hasSharingCapability,
  manageViewAccess,
  onChange
}) {
  if (sharedOwnershipModule) {
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)("p", {
      className: "googlesitekit-dashboard-sharing-settings__note",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("span", {
        children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Any admin signed in with Google', 'google-site-kit')
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__.Tooltip, {
        title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('This service requires general access to Google APIs rather than access to a specific user-owned property/entity, so view access is manageable by any admin signed in with Google.', 'google-site-kit'),
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("span", {
          className: "googlesitekit-dashboard-sharing-settings__tooltip-icon",
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)(_wordpress_icons__WEBPACK_IMPORTED_MODULE_3__["default"], {
            icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_4__["default"],
            size: 18
          })
        })
      })]
    });
  }
  if (hasOwnedModule) {
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__.Select, {
      className: "googlesitekit-dashboard-sharing-settings__select",
      value: manageViewAccess,
      options: viewAccessOptions,
      onChange: onChange,
      onClick: onChange,
      outlined: true
    });
  }
  if (ownerUsername) {
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)("p", {
      className: "googlesitekit-dashboard-sharing-settings__note",
      children: [(0,_wordpress_element__WEBPACK_IMPORTED_MODULE_5__["default"])((0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.sprintf)(/* translators: %s: user who manages the module. */
      (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('<span>Managed by</span> <strong>%s</strong>', 'google-site-kit'), ownerUsername), {
        span: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("span", {}),
        strong: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("strong", {})
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__.Tooltip, {
        title: hasSharingCapability ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.sprintf)(/* translators: %s: name of the user who manages the module. */
        (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('%s has connected this and given managing permissions to all admins. You can change who can view this on the dashboard.', 'google-site-kit'), ownerUsername) : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.sprintf)(/* translators: %s: name of the user who manages the module. */
        (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Contact %s to change who can manage view access for this module', 'google-site-kit'), ownerUsername),
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("span", {
          className: "googlesitekit-dashboard-sharing-settings__tooltip-icon",
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)(_wordpress_icons__WEBPACK_IMPORTED_MODULE_3__["default"], {
            icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_4__["default"],
            size: 18
          })
        })
      })]
    });
  }
  return null;
}
ModuleManageAccess.propTypes = {
  sharedOwnershipModule: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().bool),
  hasOwnedModule: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().bool),
  ownerUsername: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().string),
  hasSharingCapability: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().bool),
  manageViewAccess: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().string),
  onChange: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().func).isRequired
};

/***/ }),

/***/ "./js/components/dashboard-sharing/DashboardSharingSettings/ModuleViewAccess.js":
/*!**************************************************************************************!*\
  !*** ./js/components/dashboard-sharing/DashboardSharingSettings/ModuleViewAccess.js ***!
  \**************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/@wordpress/element/build-module/create-interpolate-element.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var _js_components_dashboard_sharing_UserRoleSelect__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/components/dashboard-sharing/UserRoleSelect */ "./js/components/dashboard-sharing/UserRoleSelect.js");
/* harmony import */ var _js_components_Notice__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/components/Notice */ "./js/components/Notice/index.js");
/* harmony import */ var _js_components_Link__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/components/Link */ "./js/components/Link.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * ModuleViewAccess component for DashboardSharingSettings.
 *
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */





const ModuleViewAccess = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_5__.forwardRef)(({
  moduleSlug,
  isLocked,
  hasSharingCapability,
  recoverable,
  recoverableModuleSupportLink
}, ref) => {
  if (hasSharingCapability) {
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(_js_components_dashboard_sharing_UserRoleSelect__WEBPACK_IMPORTED_MODULE_1__["default"], {
      moduleSlug: moduleSlug,
      isLocked: isLocked,
      ref: ref
    });
  }
  if (recoverable) {
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(_js_components_Notice__WEBPACK_IMPORTED_MODULE_2__["default"], {
      className: "googlesitekit-notice--small",
      type: _js_components_Notice__WEBPACK_IMPORTED_MODULE_2__["default"].TYPES.WARNING,
      description: (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__["default"])((0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Managing user required to manage view access. <a>Learn more</a>', 'google-site-kit'), {
        a: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(_js_components_Link__WEBPACK_IMPORTED_MODULE_3__["default"], {
          href: recoverableModuleSupportLink,
          external: true,
          hideExternalIndicator: true
        })
      }),
      hideIcon: true
    });
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("p", {
    className: "googlesitekit-dashboard-sharing-settings__note",
    children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Contact managing user to manage view access', 'google-site-kit')
  });
});
ModuleViewAccess.propTypes = {
  moduleSlug: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().string).isRequired,
  isLocked: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().bool).isRequired,
  hasSharingCapability: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().bool),
  recoverable: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().bool),
  recoverableModuleSupportLink: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().string)
};
ModuleViewAccess.displayName = 'ModuleViewAccess';
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ModuleViewAccess);

/***/ }),

/***/ "./js/components/dashboard-sharing/DashboardSharingSettings/constants.js":
/*!*******************************************************************************!*\
  !*** ./js/components/dashboard-sharing/DashboardSharingSettings/constants.js ***!
  \*******************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   EDITING_USER_ROLE_SELECT_SLUG_KEY: () => (/* binding */ EDITING_USER_ROLE_SELECT_SLUG_KEY),
/* harmony export */   RESET_SETTINGS_DIALOG: () => (/* binding */ RESET_SETTINGS_DIALOG),
/* harmony export */   SETTINGS_DIALOG: () => (/* binding */ SETTINGS_DIALOG)
/* harmony export */ });
/**
 * DashboardSharingSettings constants.
 *
 * Site Kit by Google, Copyright 2022 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

const EDITING_USER_ROLE_SELECT_SLUG_KEY = 'editing-user-role-select-slug-key';
const SETTINGS_DIALOG = 'dashboardSharingDialogOpen';
const RESET_SETTINGS_DIALOG = 'resetSharingDialogOpen';

/***/ }),

/***/ "./js/components/dashboard-sharing/DashboardSharingSettings/index.js":
/*!***************************************************************************!*\
  !*** ./js/components/dashboard-sharing/DashboardSharingSettings/index.js ***!
  \***************************************************************************/
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ DashboardSharingSettings)
/* harmony export */ });
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _Module__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./Module */ "./js/components/dashboard-sharing/DashboardSharingSettings/Module.js");
/* harmony import */ var _js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/googlesitekit/modules/datastore/constants */ "./js/googlesitekit/modules/datastore/constants.js");
/* harmony import */ var _js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/googlesitekit/datastore/site/constants */ "./js/googlesitekit/datastore/site/constants.js");
/* harmony import */ var _js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @/js/googlesitekit/datastore/user/constants */ "./js/googlesitekit/datastore/user/constants.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/* module decorator */ module = __webpack_require__.hmd(module);
/**
 * DashboardSharingSettings component.
 *
 * Site Kit by Google, Copyright 2022 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */






function DashboardSharingSettings() {
  const hasRecoverableModules = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.useSelect)(select => select(_js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_4__.CORE_MODULES).hasRecoverableModules());
  const hasMultipleAdmins = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.useSelect)(select => select(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_5__.CORE_SITE).hasMultipleAdmins());
  const showManageColumn = hasRecoverableModules || hasMultipleAdmins;
  const sortedShareableModules = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.useSelect)(select => {
    const userID = select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_6__.CORE_USER).getID();
    const shareableModules = select(_js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_4__.CORE_MODULES).getShareableModules();
    const owned = [];
    const manageable = [];
    const rest = [];
    for (module of Object.values(shareableModules)) {
      if (module.owner?.id === userID) {
        owned.push(module);
      } else if (select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_6__.CORE_USER).hasCapability(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_6__.PERMISSION_MANAGE_MODULE_SHARING_OPTIONS, module.slug)) {
        manageable.push(module);
      } else {
        rest.push(module);
      }
    }
    return [...owned, ...manageable, ...rest];
  });
  if (sortedShareableModules === undefined) {
    return null;
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsxs)("div", {
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-dashboard-sharing-settings', {
      'googlesitekit-dashboard-sharing-settings--has-multiple-admins': showManageColumn
    }),
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsxs)("header", {
      className: "googlesitekit-dashboard-sharing-settings__header googlesitekit-dashboard-sharing-settings__row",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)("div", {
        className: "googlesitekit-dashboard-sharing-settings__column--product",
        children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Product', 'google-site-kit')
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)("div", {
        className: "googlesitekit-dashboard-sharing-settings__column--view",
        children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Who can view', 'google-site-kit')
      }), showManageColumn && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)("div", {
        className: "googlesitekit-dashboard-sharing-settings__column--manage",
        children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Who can manage view access', 'google-site-kit')
      })]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)("div", {
      className: "googlesitekit-dashboard-sharing-settings__main",
      children: sortedShareableModules.map(({
        slug,
        name,
        owner,
        recoverable
      }) => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_Module__WEBPACK_IMPORTED_MODULE_3__["default"], {
        moduleSlug: slug,
        moduleName: name,
        ownerUsername: owner?.login,
        recoverable: recoverable
      }, slug))
    })]
  });
}

/***/ }),

/***/ "./js/components/dashboard-sharing/DashboardSharingSettingsButton.js":
/*!***************************************************************************!*\
  !*** ./js/components/dashboard-sharing/DashboardSharingSettingsButton.js ***!
  \***************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ DashboardSharingSettingsButton)
/* harmony export */ });
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! googlesitekit-components */ "googlesitekit-components");
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_components__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _svg_icons_share_svg__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/svg/icons/share.svg */ "./svg/icons/share.svg");
/* harmony import */ var _js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/hooks/useViewContext */ "./js/hooks/useViewContext.js");
/* harmony import */ var _js_util__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/util */ "./js/util/index.js");
/* harmony import */ var _js_googlesitekit_datastore_ui_constants__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @/js/googlesitekit/datastore/ui/constants */ "./js/googlesitekit/datastore/ui/constants.js");
/* harmony import */ var _js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @/js/googlesitekit/datastore/site/constants */ "./js/googlesitekit/datastore/site/constants.js");
/* harmony import */ var _js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @/js/modules/analytics-4/datastore/constants */ "./js/modules/analytics-4/datastore/constants.js");
/* harmony import */ var _DashboardSharingSettings_constants__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./DashboardSharingSettings/constants */ "./js/components/dashboard-sharing/DashboardSharingSettings/constants.js");
/* harmony import */ var _DashboardSharingDialog__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./DashboardSharingDialog */ "./js/components/dashboard-sharing/DashboardSharingDialog/index.js");
/* harmony import */ var _js_hooks_useFormValue__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @/js/hooks/useFormValue */ "./js/hooks/useFormValue.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * DashboardSharingSettingsButton component.
 *
 * Site Kit by Google, Copyright 2022 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */












function DashboardSharingSettingsButton() {
  const viewContext = (0,_js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_4__["default"])();
  const {
    setValue
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useDispatch)(_js_googlesitekit_datastore_ui_constants__WEBPACK_IMPORTED_MODULE_6__.CORE_UI);
  const hasMultipleAdmins = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_7__.CORE_SITE).hasMultipleAdmins());
  const isAutoCreatingCustomDimensionsForAudience = (0,_js_hooks_useFormValue__WEBPACK_IMPORTED_MODULE_11__["default"])(_js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_8__.AUDIENCE_TILE_CUSTOM_DIMENSION_CREATE, 'isAutoCreatingCustomDimensionsForAudience');
  const openDialog = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_13__.useCallback)(() => {
    (0,_js_util__WEBPACK_IMPORTED_MODULE_5__.trackEvent)(`${viewContext}_headerbar`, 'open_sharing', hasMultipleAdmins ? 'advanced' : 'simple');
    setValue(_DashboardSharingSettings_constants__WEBPACK_IMPORTED_MODULE_9__.SETTINGS_DIALOG, true);
  }, [setValue, viewContext, hasMultipleAdmins]);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsxs)(_wordpress_element__WEBPACK_IMPORTED_MODULE_13__.Fragment, {
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_2__.Button, {
      "aria-label": (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Open sharing settings', 'google-site-kit'),
      className: "googlesitekit-sharing-settings__button googlesitekit-header__dropdown googlesitekit-border-radius-round googlesitekit-button-icon",
      onClick: openDialog,
      icon: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx)(_svg_icons_share_svg__WEBPACK_IMPORTED_MODULE_3__["default"], {
        width: 20,
        height: 20
      }),
      tooltipEnterDelayInMS: 500,
      disabled: isAutoCreatingCustomDimensionsForAudience
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx)(_DashboardSharingDialog__WEBPACK_IMPORTED_MODULE_10__["default"], {})]
  });
}

/***/ }),

/***/ "./js/components/dashboard-sharing/UserRoleSelect.js":
/*!***********************************************************!*\
  !*** ./js/components/dashboard-sharing/UserRoleSelect.js ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_16___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_16__);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_keycodes__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! @wordpress/keycodes */ "../node_modules/@wordpress/keycodes/build-module/index.js");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! googlesitekit-components */ "googlesitekit-components");
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_components__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _js_components_Link__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/components/Link */ "./js/components/Link.js");
/* harmony import */ var _svg_icons_share_svg__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/svg/icons/share.svg */ "./svg/icons/share.svg");
/* harmony import */ var _svg_icons_check_svg__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @/svg/icons/check.svg */ "./svg/icons/check.svg");
/* harmony import */ var _js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @/js/hooks/useViewContext */ "./js/hooks/useViewContext.js");
/* harmony import */ var _js_hooks_useKeyCodesInside__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @/js/hooks/useKeyCodesInside */ "./js/hooks/useKeyCodesInside.js");
/* harmony import */ var _js_util__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @/js/util */ "./js/util/index.js");
/* harmony import */ var _js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @/js/googlesitekit/modules/datastore/constants */ "./js/googlesitekit/modules/datastore/constants.js");
/* harmony import */ var _js_googlesitekit_datastore_ui_constants__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @/js/googlesitekit/datastore/ui/constants */ "./js/googlesitekit/datastore/ui/constants.js");
/* harmony import */ var _DashboardSharingSettings_constants__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ./DashboardSharingSettings/constants */ "./js/components/dashboard-sharing/DashboardSharingSettings/constants.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * UserRoleSelect component.
 *
 * Site Kit by Google, Copyright 2022 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * WordPress dependencies
 */




/**
 * Internal dependencies
 */












const ALL_CHIP_ID = 'all';
const ALL_CHIP_DISPLAY_NAME = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('All', 'google-site-kit');
const UserRoleSelect = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_14__.forwardRef)(({
  moduleSlug,
  isLocked = false
}, ref) => {
  const viewContext = (0,_js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_7__["default"])();
  const roleSelectRef = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_14__.useRef)();
  const {
    setSharedRoles
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.useDispatch)(_js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_10__.CORE_MODULES);
  const {
    setValue
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.useDispatch)(_js_googlesitekit_datastore_ui_constants__WEBPACK_IMPORTED_MODULE_11__.CORE_UI);
  const shareableRoles = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.useSelect)(select => select(_js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_10__.CORE_MODULES).getShareableRoles());
  const sharedRoles = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.useSelect)(select => select(_js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_10__.CORE_MODULES).getSharedRoles(moduleSlug));
  const editingUserRoleSelect = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.useSelect)(select => select(_js_googlesitekit_datastore_ui_constants__WEBPACK_IMPORTED_MODULE_11__.CORE_UI).getValue(_DashboardSharingSettings_constants__WEBPACK_IMPORTED_MODULE_12__.EDITING_USER_ROLE_SELECT_SLUG_KEY));
  const editMode = editingUserRoleSelect === moduleSlug;
  (0,_js_hooks_useKeyCodesInside__WEBPACK_IMPORTED_MODULE_8__.useKeyCodesInside)([_wordpress_keycodes__WEBPACK_IMPORTED_MODULE_15__.ESCAPE], ref, () => {
    if (editMode) {
      setValue(_DashboardSharingSettings_constants__WEBPACK_IMPORTED_MODULE_12__.EDITING_USER_ROLE_SELECT_SLUG_KEY, undefined);
    }
  });
  const haveSharingSettingsRolesChanged = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.useSelect)(select => select(_js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_10__.CORE_MODULES).haveModuleSharingSettingsChanged(moduleSlug, 'sharedRoles'));
  const toggleEditMode = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_14__.useCallback)(() => {
    if (!editMode) {
      // Set the state to disable modules in when editing user roles
      setValue(_DashboardSharingSettings_constants__WEBPACK_IMPORTED_MODULE_12__.EDITING_USER_ROLE_SELECT_SLUG_KEY, moduleSlug);
    } else {
      // Reset the state to enable modules in when not editing.
      setValue(_DashboardSharingSettings_constants__WEBPACK_IMPORTED_MODULE_12__.EDITING_USER_ROLE_SELECT_SLUG_KEY, undefined);
      if (haveSharingSettingsRolesChanged) {
        (0,_js_util__WEBPACK_IMPORTED_MODULE_9__.trackEvent)(`${viewContext}_sharing`, 'change_shared_roles', moduleSlug);
      }
    }
  }, [editMode, haveSharingSettingsRolesChanged, moduleSlug, setValue, viewContext]);
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_14__.useEffect)(() => {
    if (!roleSelectRef.current) {
      return;
    }
    if (editMode) {
      // Focus on the "All" roles button.
      roleSelectRef.current.firstChild.focus();
    } else {
      // Focus on the role select button.
      roleSelectRef.current.focus();
    }
  }, [editMode]);
  const toggleChip = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_14__.useCallback)(({
    type,
    target,
    keyCode
  }) => {
    if (type === 'keydown' && keyCode !== _wordpress_keycodes__WEBPACK_IMPORTED_MODULE_15__.ENTER) {
      return;
    }
    const chip = target.closest('.mdc-chip');
    const chipID = chip?.dataset?.chipId; // eslint-disable-line sitekit/acronym-case

    if (!chipID) {
      return;
    }
    let updatedSharedRoles;
    if (chipID === ALL_CHIP_ID) {
      if (sharedRoles?.length === shareableRoles?.length) {
        updatedSharedRoles = [];
      } else {
        updatedSharedRoles = shareableRoles.map(({
          id
        }) => id);
      }
    } else if (sharedRoles === null) {
      updatedSharedRoles = [chipID];
    } else if (sharedRoles.includes(chipID)) {
      updatedSharedRoles = sharedRoles.filter(role => role !== chipID);
    } else {
      updatedSharedRoles = [...sharedRoles, chipID];
    }
    setSharedRoles(moduleSlug, updatedSharedRoles);
  }, [moduleSlug, setSharedRoles, sharedRoles, shareableRoles]);
  function getSharedRolesDisplayNames() {
    const roleDisplayNames = shareableRoles?.reduce((acc, role) => {
      if (sharedRoles.includes(role.id)) {
        acc.push(role.displayName);
      }
      return acc;
    }, []);
    return roleDisplayNames.join(', ');
  }
  if (!shareableRoles) {
    return null;
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsxs)("div", {
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-user-role-select', {
      'googlesitekit-user-role-select--open': editMode
    }),
    children: [!editMode && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_3__.Button, {
      "aria-label": (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Edit roles', 'google-site-kit'),
      className: "googlesitekit-user-role-select__button",
      onClick: toggleEditMode,
      icon: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx)(_svg_icons_share_svg__WEBPACK_IMPORTED_MODULE_5__["default"], {
        width: 23,
        height: 23
      }),
      tabIndex: isLocked ? -1 : undefined,
      ref: roleSelectRef
    }), !editMode && sharedRoles?.length > 0 && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx)("span", {
      className: "googlesitekit-user-role-select__current-roles",
      children: getSharedRolesDisplayNames()
    }), !editMode && (!sharedRoles || sharedRoles?.length === 0) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx)("span", {
      className: "googlesitekit-user-role-select__add-roles",
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx)(_js_components_Link__WEBPACK_IMPORTED_MODULE_4__["default"], {
        onClick: toggleEditMode,
        tabIndex: isLocked ? -1 : undefined,
        children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Add roles', 'google-site-kit')
      })
    }), editMode && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsxs)(_wordpress_element__WEBPACK_IMPORTED_MODULE_14__.Fragment, {
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsxs)("div", {
        className: "googlesitekit-user-role-select__chipset",
        ref: roleSelectRef,
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_3__.Chip, {
          id: ALL_CHIP_ID,
          label: ALL_CHIP_DISPLAY_NAME,
          onClick: toggleChip,
          onKeyDown: toggleChip,
          selected: sharedRoles?.length === shareableRoles?.length,
          className: "googlesitekit-user-role-select__chip--all"
        }), shareableRoles.map(({
          id,
          displayName
        }, index) => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_3__.Chip, {
          id: id,
          label: displayName,
          onClick: toggleChip,
          onKeyDown: toggleChip,
          selected: sharedRoles?.includes(id)
        }, index))]
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_3__.Button, {
        "aria-label": (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Done editing roles', 'google-site-kit'),
        title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Done', 'google-site-kit'),
        className: "googlesitekit-user-role-select__button",
        onClick: toggleEditMode,
        icon: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx)(_svg_icons_check_svg__WEBPACK_IMPORTED_MODULE_6__["default"], {
          width: 18,
          height: 18
        }),
        tabIndex: isLocked ? -1 : undefined
      })]
    })]
  });
});
UserRoleSelect.propTypes = {
  moduleSlug: (prop_types__WEBPACK_IMPORTED_MODULE_16___default().string).isRequired,
  isLocked: (prop_types__WEBPACK_IMPORTED_MODULE_16___default().bool)
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (UserRoleSelect);

/***/ }),

/***/ "./js/components/help/HelpMenu.js":
/*!****************************************!*\
  !*** ./js/components/help/HelpMenu.js ***!
  \****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ HelpMenu)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_15___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_15__);
/* harmony import */ var react_use__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! react-use */ "../node_modules/react-use/esm/useClickAway.js");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _wordpress_keycodes__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! @wordpress/keycodes */ "../node_modules/@wordpress/keycodes/build-module/index.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! googlesitekit-components */ "googlesitekit-components");
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_components__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _svg_icons_help_svg__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/svg/icons/help.svg */ "./svg/icons/help.svg");
/* harmony import */ var _js_hooks_useKeyCodesInside__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/hooks/useKeyCodesInside */ "./js/hooks/useKeyCodesInside.js");
/* harmony import */ var _js_util__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/util */ "./js/util/index.js");
/* harmony import */ var _HelpMenuLink__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./HelpMenuLink */ "./js/components/help/HelpMenuLink.js");
/* harmony import */ var _js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @/js/googlesitekit/modules/datastore/constants */ "./js/googlesitekit/modules/datastore/constants.js");
/* harmony import */ var _js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @/js/hooks/useViewContext */ "./js/hooks/useViewContext.js");
/* harmony import */ var _js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @/js/googlesitekit/datastore/site/constants */ "./js/googlesitekit/datastore/site/constants.js");
/* harmony import */ var _js_modules_adsense_constants__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @/js/modules/adsense/constants */ "./js/modules/adsense/constants.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * HelpMenu component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * WordPress dependencies
 */




/**
 * Internal dependencies
 */











function HelpMenu({
  children
}) {
  const [menuOpen, setMenuOpen] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_12__.useState)(false);
  const menuWrapperRef = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_12__.useRef)();
  const viewContext = (0,_js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_8__["default"])();
  (0,react_use__WEBPACK_IMPORTED_MODULE_13__["default"])(menuWrapperRef, () => setMenuOpen(false));
  (0,_js_hooks_useKeyCodesInside__WEBPACK_IMPORTED_MODULE_4__.useKeyCodesInside)([_wordpress_keycodes__WEBPACK_IMPORTED_MODULE_14__.ESCAPE, _wordpress_keycodes__WEBPACK_IMPORTED_MODULE_14__.TAB], menuWrapperRef, () => setMenuOpen(false));
  const adSenseModuleActive = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_7__.CORE_MODULES).isModuleActive(_js_modules_adsense_constants__WEBPACK_IMPORTED_MODULE_10__.MODULE_SLUG_ADSENSE));
  const handleMenu = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_12__.useCallback)(() => {
    if (!menuOpen) {
      (0,_js_util__WEBPACK_IMPORTED_MODULE_5__.trackEvent)(`${viewContext}_headerbar`, 'open_helpmenu');
    }
    setMenuOpen(!menuOpen);
  }, [menuOpen, viewContext]);
  const handleMenuSelected = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_12__.useCallback)(() => {
    setMenuOpen(false);
  }, []);
  const fixCommonIssuesURL = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => {
    return select(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_9__.CORE_SITE).getDocumentationLinkURL('fix-common-issues');
  });
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("div", {
    ref: menuWrapperRef,
    className: "googlesitekit-dropdown-menu googlesitekit-dropdown-menu__icon-menu mdc-menu-surface--anchor",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_2__.Button, {
      "aria-controls": "googlesitekit-help-menu",
      "aria-expanded": menuOpen,
      "aria-label": (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Help', 'google-site-kit'),
      "aria-haspopup": "menu",
      className: "googlesitekit-header__dropdown googlesitekit-border-radius-round googlesitekit-button-icon googlesitekit-help-menu__button mdc-button--dropdown",
      icon: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_svg_icons_help_svg__WEBPACK_IMPORTED_MODULE_3__["default"], {
        width: "20",
        height: "20"
      }),
      onClick: handleMenu,
      tooltipEnterDelayInMS: 500,
      text: true
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_2__.Menu, {
      className: "googlesitekit-width-auto",
      menuOpen: menuOpen,
      id: "googlesitekit-help-menu",
      onSelected: handleMenuSelected,
      children: [children, /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_HelpMenuLink__WEBPACK_IMPORTED_MODULE_6__["default"], {
        gaEventLabel: "fix_common_issues",
        href: fixCommonIssuesURL,
        children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Fix common issues', 'google-site-kit')
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_HelpMenuLink__WEBPACK_IMPORTED_MODULE_6__["default"], {
        gaEventLabel: "documentation",
        href: "https://sitekit.withgoogle.com/documentation/",
        children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Read help docs', 'google-site-kit')
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_HelpMenuLink__WEBPACK_IMPORTED_MODULE_6__["default"], {
        gaEventLabel: "support_forum",
        href: "https://wordpress.org/support/plugin/google-site-kit/",
        children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Get support', 'google-site-kit')
      }), adSenseModuleActive && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_HelpMenuLink__WEBPACK_IMPORTED_MODULE_6__["default"], {
        gaEventLabel: "adsense_help",
        href: "https://support.google.com/adsense/",
        children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Get help with AdSense', 'google-site-kit')
      })]
    })]
  });
}
HelpMenu.propTypes = {
  children: (prop_types__WEBPACK_IMPORTED_MODULE_15___default().node)
};

/***/ }),

/***/ "./js/components/help/HelpMenuLink.js":
/*!********************************************!*\
  !*** ./js/components/help/HelpMenuLink.js ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _js_components_Link__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @/js/components/Link */ "./js/components/Link.js");
/* harmony import */ var _js_util__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/util */ "./js/util/index.js");
/* harmony import */ var _js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/hooks/useViewContext */ "./js/hooks/useViewContext.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * HelpMenuLink component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */




function HelpMenuLink({
  children,
  href,
  gaEventLabel
}) {
  const viewContext = (0,_js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_2__["default"])();
  const onClick = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_4__.useCallback)(async () => {
    if (gaEventLabel) {
      await (0,_js_util__WEBPACK_IMPORTED_MODULE_1__.trackEvent)(`${viewContext}_headerbar_helpmenu`, 'click_outgoing_link', gaEventLabel);
    }
  }, [gaEventLabel, viewContext]);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("li", {
    className: "googlesitekit-help-menu-link mdc-list-item",
    role: "none",
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_js_components_Link__WEBPACK_IMPORTED_MODULE_0__["default"], {
      className: "mdc-list-item__text",
      href: href,
      role: "menuitem",
      onClick: onClick,
      external: true,
      hideExternalIndicator: true,
      children: children
    })
  });
}
HelpMenuLink.propTypes = {
  children: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().node).isRequired,
  href: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().string).isRequired,
  gaEventLabel: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().string)
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (HelpMenuLink);

/***/ }),

/***/ "./js/components/notifications/CTA.js":
/*!********************************************!*\
  !*** ./js/components/notifications/CTA.js ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-components */ "googlesitekit-components");
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _js_components_Link__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/components/Link */ "./js/components/Link.js");
/* harmony import */ var _js_components_Typography__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/components/Typography */ "./js/components/Typography/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * CTA component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * Internal dependencies
 */




function CTA({
  title,
  headerText,
  headerContent,
  description,
  ctaLink,
  ctaLabel,
  ctaLinkExternal,
  ctaType,
  error,
  onClick,
  'aria-label': ariaLabel,
  children
}) {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsxs)("div", {
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-cta', {
      'googlesitekit-cta--error': error
    }),
    children: [(headerText || headerContent) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsxs)("div", {
      className: "googlesitekit-cta__header",
      children: [headerText && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(_js_components_Typography__WEBPACK_IMPORTED_MODULE_3__["default"], {
        as: "h2",
        size: "small",
        type: "label",
        className: "googlesitekit-cta__header_text",
        children: headerText
      }), headerContent]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsxs)("div", {
      className: "googlesitekit-cta__body",
      children: [title && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(_js_components_Typography__WEBPACK_IMPORTED_MODULE_3__["default"], {
        as: "h3",
        size: "small",
        type: "title",
        className: "googlesitekit-cta__title",
        children: title
      }), description && typeof description === 'string' && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("p", {
        className: "googlesitekit-cta__description",
        children: description
      }), description && typeof description !== 'string' && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("div", {
        className: "googlesitekit-cta__description",
        children: description
      }), ctaLabel && ctaType === 'button' && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__.Button, {
        "aria-label": ariaLabel,
        href: ctaLink,
        onClick: onClick,
        children: ctaLabel
      }), ctaLabel && ctaType === 'link' && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(_js_components_Link__WEBPACK_IMPORTED_MODULE_2__["default"], {
        href: ctaLink,
        onClick: onClick,
        "aria-label": ariaLabel,
        external: ctaLinkExternal,
        hideExternalIndicator: ctaLinkExternal,
        arrow: true,
        children: ctaLabel
      }), children]
    })]
  });
}
CTA.propTypes = {
  title: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().string).isRequired,
  headerText: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().string),
  description: prop_types__WEBPACK_IMPORTED_MODULE_5___default().oneOfType([(prop_types__WEBPACK_IMPORTED_MODULE_5___default().string), (prop_types__WEBPACK_IMPORTED_MODULE_5___default().node)]),
  ctaLink: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().string),
  ctaLinkExternal: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().bool),
  ctaLabel: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().string),
  ctaType: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().string),
  'aria-label': (prop_types__WEBPACK_IMPORTED_MODULE_5___default().string),
  error: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().bool),
  onClick: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().func),
  children: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().node),
  headerContent: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().node)
};
CTA.defaultProps = {
  title: '',
  headerText: '',
  headerContent: '',
  description: '',
  ctaLink: '',
  ctaLabel: '',
  ctaType: 'link',
  error: false,
  onClick: () => {}
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (CTA);

/***/ }),

/***/ "./js/components/notifications/CoreSiteBannerNotification.js":
/*!*******************************************************************!*\
  !*** ./js/components/notifications/CoreSiteBannerNotification.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/googlesitekit/datastore/site/constants */ "./js/googlesitekit/datastore/site/constants.js");
/* harmony import */ var _js_components_NotificationFromServer__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/components/NotificationFromServer */ "./js/components/NotificationFromServer.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * CoreSiteBannerNotification component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */




function CoreSiteBannerNotification({
  id,
  ...props
}) {
  const {
    dismissNotification,
    acceptNotification
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useDispatch)(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_2__.CORE_SITE);
  const onCTAClick = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_5__.useCallback)(() => {
    acceptNotification(id);
  }, [id, acceptNotification]);
  const onDismissClick = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_5__.useCallback)(() => {
    dismissNotification(id);
  }, [id, dismissNotification]);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(_js_components_NotificationFromServer__WEBPACK_IMPORTED_MODULE_3__["default"], {
    onCTAClick: onCTAClick,
    onDismissClick: onDismissClick,
    ...props,
    id: id
  });
}
CoreSiteBannerNotification.propTypes = {
  content: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().string),
  ctaLabel: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().string),
  ctaTarget: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().string),
  ctaURL: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().string),
  dismissLabel: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().string),
  dismissible: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().bool),
  gaTrackingEventArgs: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().object),
  id: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().string).isRequired,
  learnMoreLabel: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().string),
  learnMoreURL: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().string),
  title: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().string).isRequired
};
CoreSiteBannerNotification.defaultProps = {
  content: '',
  ctaLabel: '',
  ctaTarget: '',
  ctaURL: '',
  dismissLabel: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('OK, Got it!', 'google-site-kit'),
  dismissible: true,
  learnMoreLabel: '',
  learnMoreURL: ''
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (CoreSiteBannerNotification);

/***/ }),

/***/ "./js/components/notifications/CoreSiteBannerNotifications.js":
/*!********************************************************************!*\
  !*** ./js/components/notifications/CoreSiteBannerNotifications.js ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/hooks/useViewContext */ "./js/hooks/useViewContext.js");
/* harmony import */ var _js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/googlesitekit/datastore/site/constants */ "./js/googlesitekit/datastore/site/constants.js");
/* harmony import */ var _js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/googlesitekit/datastore/user/constants */ "./js/googlesitekit/datastore/user/constants.js");
/* harmony import */ var _js_googlesitekit_notifications_datastore_constants__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/googlesitekit/notifications/datastore/constants */ "./js/googlesitekit/notifications/datastore/constants.js");
/* harmony import */ var _js_googlesitekit_notifications_constants__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/googlesitekit/notifications/constants */ "./js/googlesitekit/notifications/constants.js");
/* harmony import */ var _CoreSiteBannerNotification__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./CoreSiteBannerNotification */ "./js/components/notifications/CoreSiteBannerNotification.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * CoreSiteBannerNotifications component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */








const MAX_SECONDS_FOR_SURVEY = 5;

/**
 * Registers notifications from the server, if any exist in the data store.
 *
 * This is a side-effect component that does not render anything directly.
 *
 * @since 1.157.0
 *
 * @return {null} Returns null as this component does not render anything directly.
 */
function CoreSiteBannerNotifications() {
  const viewContext = (0,_js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_1__["default"])();
  const [surveysHaveLoaded, setSurveysHaveLoaded] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_8__.useState)(false);
  const [hasSurveys, setHasSurveys] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_8__.useState)(false);

  // This check doesn't rely on an actual date; we only need to track the
  // elapsed number of seconds since this component was rendered to see when
  // to cause a survey to appear after page load.
  const startTime = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_8__.useRef)(Date.now()); // eslint-disable-line sitekit/no-direct-date

  const surveys = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useSelect)(select => select(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_2__.CORE_SITE).isUsingProxy() && select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_USER).areSurveysOnCooldown() === false ? select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_USER).getCurrentSurvey() : null);
  const [registeredNotifications, setRegisteredNotifications] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_8__.useState)([]);
  const {
    registerNotification
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useDispatch)(_js_googlesitekit_notifications_datastore_constants__WEBPACK_IMPORTED_MODULE_4__.CORE_NOTIFICATIONS);
  const notifications = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useSelect)(select => select(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_2__.CORE_SITE).getNotifications());
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_8__.useEffect)(() => {
    const timer = setTimeout(() => {
      if (!hasSurveys) {
        setSurveysHaveLoaded(true);
      }
    }, MAX_SECONDS_FOR_SURVEY * 1000);
    return () => {
      clearTimeout(timer);
    };
  }, [hasSurveys]);
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_8__.useEffect)(() => {
    const secondsElapsed = Math.floor(
    // See comment above; this is just about tracking elapsed
    // seconds since this component first rendered, so we
    // shouldn't use the reference date.
    (Date.now() - startTime.current) / 1000 // eslint-disable-line sitekit/no-direct-date
    );
    // Surveys that were received in time prevent the render, surveys loaded
    // after a set amount of time do not prevent notifications from rendering.
    if (secondsElapsed < MAX_SECONDS_FOR_SURVEY && surveys) {
      setHasSurveys(true);
    }
  }, [startTime, surveys, setHasSurveys]);
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_8__.useEffect)(() => {
    // If surveys haven't loaded yet or there are surveys on-screen, we don't
    // register any server notifications.
    if (!surveysHaveLoaded || hasSurveys) {
      return;
    }

    // Register any notifications from the server that haven't yet been
    // registered.
    //
    // (Usually there will be one, if any, notification from the server.)
    notifications?.forEach(notification => {
      if (registeredNotifications.includes(notification.id)) {
        return;
      }

      // Before refactoring our Banner Notifications, `CoreSiteBannerNotification` added the
      // constant GA event category (initalised below) but the notification ID from the server
      // was passed as the event label to differentiate multiple notifications from
      // the server. So we continue to do that here for consistency with historical events.
      const gaTrackingEventArgs = {
        category: `${viewContext}_remote-site-notification`,
        label: notification.id
      };
      registerNotification(notification.id, {
        Component({
          Notification
        }) {
          return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(Notification, {
            gaTrackingEventArgs: gaTrackingEventArgs,
            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_CoreSiteBannerNotification__WEBPACK_IMPORTED_MODULE_6__["default"], {
              ...notification,
              gaTrackingEventArgs: gaTrackingEventArgs
            })
          });
        },
        priority: notification.priority,
        areaSlug: _js_googlesitekit_notifications_constants__WEBPACK_IMPORTED_MODULE_5__.NOTIFICATION_AREAS.HEADER,
        isDismissible: notification.dismissible
      });
      setRegisteredNotifications(previousRegisteredNotifications => {
        previousRegisteredNotifications.push(notification.id);
        return previousRegisteredNotifications;
      });
    });
  }, [viewContext, hasSurveys, notifications, registerNotification, registeredNotifications, surveysHaveLoaded]);
  return null;
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (CoreSiteBannerNotifications);

/***/ }),

/***/ "./js/components/notifications/InternalServerError.js":
/*!************************************************************!*\
  !*** ./js/components/notifications/InternalServerError.js ***!
  \************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ InternalServerError)
/* harmony export */ });
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/googlesitekit/datastore/site/constants */ "./js/googlesitekit/datastore/site/constants.js");
/* harmony import */ var _js_googlesitekit_notifications_components_layout_BannerNotification__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/googlesitekit/notifications/components/layout/BannerNotification */ "./js/googlesitekit/notifications/components/layout/BannerNotification.js");
/* harmony import */ var _js_googlesitekit_notifications_components_Notification__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/googlesitekit/notifications/components/Notification */ "./js/googlesitekit/notifications/components/Notification/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * InternalServerError component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Internal dependencies
 */





function InternalServerError() {
  const error = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useSelect)(select => select(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_1__.CORE_SITE).getInternalServerError());
  if (!error) {
    return null;
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(_js_googlesitekit_notifications_components_Notification__WEBPACK_IMPORTED_MODULE_3__["default"], {
    id: "internal-server-error",
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(_js_googlesitekit_notifications_components_layout_BannerNotification__WEBPACK_IMPORTED_MODULE_2__["default"], {
      notificationID: "internal-server-error",
      type: _js_googlesitekit_notifications_components_layout_BannerNotification__WEBPACK_IMPORTED_MODULE_2__.TYPES.ERROR,
      title: error.title,
      description: error.description
    })
  });
}

/***/ }),

/***/ "./js/components/notifications/LegacyNotifications.js":
/*!************************************************************!*\
  !*** ./js/components/notifications/LegacyNotifications.js ***!
  \************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ LegacyNotifications)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/googlesitekit/datastore/user/constants */ "./js/googlesitekit/datastore/user/constants.js");
/* harmony import */ var _CoreSiteBannerNotifications__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./CoreSiteBannerNotifications */ "./js/components/notifications/CoreSiteBannerNotifications.js");
/* harmony import */ var _js_hooks_useViewOnly__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/hooks/useViewOnly */ "./js/hooks/useViewOnly.js");
/* harmony import */ var _js_hooks_useDashboardType__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/hooks/useDashboardType */ "./js/hooks/useDashboardType.js");
/* harmony import */ var _InternalServerError__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./InternalServerError */ "./js/components/notifications/InternalServerError.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * BannerNotifications component.
 *
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */







function LegacyNotifications() {
  const viewOnly = (0,_js_hooks_useViewOnly__WEBPACK_IMPORTED_MODULE_3__["default"])();
  const dashboardType = (0,_js_hooks_useDashboardType__WEBPACK_IMPORTED_MODULE_4__["default"])();
  const isAuthenticated = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useSelect)(select => select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_1__.CORE_USER).isAuthenticated());
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)(_wordpress_element__WEBPACK_IMPORTED_MODULE_7__.Fragment, {
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(_InternalServerError__WEBPACK_IMPORTED_MODULE_5__["default"], {}), !viewOnly && dashboardType === _js_hooks_useDashboardType__WEBPACK_IMPORTED_MODULE_4__.DASHBOARD_TYPE_MAIN && isAuthenticated && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(_CoreSiteBannerNotifications__WEBPACK_IMPORTED_MODULE_2__["default"], {})]
  });
}

/***/ }),

/***/ "./js/components/notifications/Notifications.js":
/*!******************************************************!*\
  !*** ./js/components/notifications/Notifications.js ***!
  \******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Notifications)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/hooks/useViewContext */ "./js/hooks/useViewContext.js");
/* harmony import */ var _js_googlesitekit_notifications_datastore_constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/googlesitekit/notifications/datastore/constants */ "./js/googlesitekit/notifications/datastore/constants.js");
/* harmony import */ var _js_googlesitekit_notifications_constants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/googlesitekit/notifications/constants */ "./js/googlesitekit/notifications/constants.js");
/* harmony import */ var _js_googlesitekit_notifications_util_component_props__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/googlesitekit/notifications/util/component-props */ "./js/googlesitekit/notifications/util/component-props.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Notifications component.
 *
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * Internal dependencies
 */






function Notifications({
  areaSlug,
  groupID = _js_googlesitekit_notifications_constants__WEBPACK_IMPORTED_MODULE_3__.NOTIFICATION_GROUPS.DEFAULT
}) {
  const viewContext = (0,_js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_1__["default"])();
  const queuedNotifications = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useSelect)(select => select(_js_googlesitekit_notifications_datastore_constants__WEBPACK_IMPORTED_MODULE_2__.CORE_NOTIFICATIONS).getQueuedNotifications(viewContext, groupID));
  if (queuedNotifications?.[0] === undefined || queuedNotifications?.[0]?.areaSlug !== areaSlug) {
    return null;
  }
  const {
    id,
    Component: ActiveNotification
  } = queuedNotifications[0];
  const props = {
    ...(0,_js_googlesitekit_notifications_util_component_props__WEBPACK_IMPORTED_MODULE_4__.getNotificationComponentProps)(id)
  };
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(ActiveNotification, {
    ...props
  });
}
Notifications.propTypes = {
  viewContext: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().string),
  areaSlug: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().string)
};

/***/ }),

/***/ "./js/components/notifications/OfflineNotification.js":
/*!************************************************************!*\
  !*** ./js/components/notifications/OfflineNotification.js ***!
  \************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _js_googlesitekit_datastore_ui_constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/googlesitekit/datastore/ui/constants */ "./js/googlesitekit/datastore/ui/constants.js");
/* harmony import */ var _js_components_Notice__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/components/Notice */ "./js/components/Notice/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * OfflineNotification component.
 *
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */




function OfflineNotification() {
  const [dismissed, setDismissed] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_5__.useState)(false);
  const isOnline = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_datastore_ui_constants__WEBPACK_IMPORTED_MODULE_2__.CORE_UI).getIsOnline());
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_5__.useEffect)(() => {
    if (isOnline && dismissed) {
      setDismissed(false);
    }
  }, [isOnline, dismissed]);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("div", {
    "aria-live": "polite",
    children: !isOnline && !dismissed && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(_js_components_Notice__WEBPACK_IMPORTED_MODULE_3__["default"], {
      className: "googlesitekit-notice-snackbar--bottom-right",
      type: _js_components_Notice__WEBPACK_IMPORTED_MODULE_3__["default"].TYPES.WARNING,
      description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('You are currently offline. Some features may not be available.', 'google-site-kit'),
      ctaButton: {
        label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('OK, Got it!', 'google-site-kit'),
        onClick: () => setDismissed(true)
      }
    })
  });
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (OfflineNotification);

/***/ }),

/***/ "./js/components/setup/ModuleSetup.js":
/*!********************************************!*\
  !*** ./js/components/setup/ModuleSetup.js ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ ModuleSetup)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_15___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_15__);
/* harmony import */ var react_use__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! react-use */ "../node_modules/react-use/esm/useMount.js");
/* harmony import */ var use_memo_one__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! use-memo-one */ "../node_modules/use-memo-one/dist/use-memo-one.esm.js");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/googlesitekit/datastore/site/constants */ "./js/googlesitekit/datastore/site/constants.js");
/* harmony import */ var _js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/googlesitekit/modules/datastore/constants */ "./js/googlesitekit/modules/datastore/constants.js");
/* harmony import */ var _js_googlesitekit_datastore_location_constants__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/googlesitekit/datastore/location/constants */ "./js/googlesitekit/datastore/location/constants.js");
/* harmony import */ var _js_googlesitekit_api_cache__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/googlesitekit/api/cache */ "./js/googlesitekit/api/cache.js");
/* harmony import */ var _js_util__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @/js/util */ "./js/util/index.js");
/* harmony import */ var _js_components_help_HelpMenu__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @/js/components/help/HelpMenu */ "./js/components/help/HelpMenu.js");
/* harmony import */ var _js_material_components__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @/js/material-components */ "./js/material-components/index.js");
/* harmony import */ var _js_components_Header__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @/js/components/Header */ "./js/components/Header.js");
/* harmony import */ var _ModuleSetupFooter__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./ModuleSetupFooter */ "./js/components/setup/ModuleSetupFooter.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * ModuleSetup component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */




/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */











function ModuleSetup({
  moduleSlug
}) {
  const {
    navigateTo
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useDispatch)(_js_googlesitekit_datastore_location_constants__WEBPACK_IMPORTED_MODULE_4__.CORE_LOCATION);
  const module = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_MODULES).getModule(moduleSlug));
  const registry = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useRegistry)();

  /**
   * When module setup done, we redirect the user to Site Kit dashboard.
   *
   * @since 1.0.0
   * @since 1.18.0 Added optional redirectURL parameter.
   *
   * @param {string} [redirectURL] URL to redirect to when complete. Defaults to Site Kit dashboard.
   */
  const finishSetup = (0,use_memo_one__WEBPACK_IMPORTED_MODULE_12__.useCallbackOne)(async redirectURL => {
    await (0,_js_googlesitekit_api_cache__WEBPACK_IMPORTED_MODULE_5__.deleteItem)('module_setup');
    await (0,_js_util__WEBPACK_IMPORTED_MODULE_6__.trackEvent)('moduleSetup', 'complete_module_setup', moduleSlug);
    if (redirectURL) {
      navigateTo(redirectURL);
      return;
    }
    const {
      select,
      resolveSelect
    } = registry;
    await resolveSelect(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_2__.CORE_SITE).getSiteInfo();
    const adminURL = select(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_2__.CORE_SITE).getAdminURL('googlesitekit-dashboard', {
      notification: 'authentication_success',
      slug: moduleSlug
    });
    navigateTo(adminURL);
  }, [registry, navigateTo, moduleSlug]);
  const onCompleteSetup = module?.onCompleteSetup;
  const onCompleteSetupCallback = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_13__.useCallback)(() => onCompleteSetup(registry, finishSetup), [onCompleteSetup, registry, finishSetup]);
  const onCancelButtonClick = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_13__.useCallback)(async () => {
    await (0,_js_util__WEBPACK_IMPORTED_MODULE_6__.trackEvent)('moduleSetup', 'cancel_module_setup', moduleSlug);
  }, [moduleSlug]);
  (0,react_use__WEBPACK_IMPORTED_MODULE_14__["default"])(() => {
    (0,_js_util__WEBPACK_IMPORTED_MODULE_6__.trackEvent)('moduleSetup', 'view_module_setup', moduleSlug);
  });
  if (!module?.SetupComponent) {
    return null;
  }
  const {
    SetupComponent
  } = module;
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)(_wordpress_element__WEBPACK_IMPORTED_MODULE_13__.Fragment, {
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_js_components_Header__WEBPACK_IMPORTED_MODULE_9__["default"], {
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_js_components_help_HelpMenu__WEBPACK_IMPORTED_MODULE_7__["default"], {})
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("div", {
      className: "googlesitekit-setup",
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_js_material_components__WEBPACK_IMPORTED_MODULE_8__.Grid, {
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_js_material_components__WEBPACK_IMPORTED_MODULE_8__.Row, {
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_js_material_components__WEBPACK_IMPORTED_MODULE_8__.Cell, {
            size: 12,
            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("section", {
              className: "googlesitekit-setup__wrapper",
              children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_js_material_components__WEBPACK_IMPORTED_MODULE_8__.Grid, {
                children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_js_material_components__WEBPACK_IMPORTED_MODULE_8__.Row, {
                  children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)(_js_material_components__WEBPACK_IMPORTED_MODULE_8__.Cell, {
                    size: 12,
                    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("p", {
                      className: "googlesitekit-setup__intro-title",
                      children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Connect Service', 'google-site-kit')
                    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(SetupComponent, {
                      module: module,
                      finishSetup: finishSetup
                    })]
                  })
                })
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_ModuleSetupFooter__WEBPACK_IMPORTED_MODULE_10__["default"], {
                module: module,
                onCancel: onCancelButtonClick,
                onComplete: typeof onCompleteSetup === 'function' ? onCompleteSetupCallback : undefined
              })]
            })
          })
        })
      })
    })]
  });
}
ModuleSetup.propTypes = {
  moduleSlug: (prop_types__WEBPACK_IMPORTED_MODULE_15___default().string).isRequired
};

/***/ }),

/***/ "./js/components/setup/ModuleSetupFooter.js":
/*!**************************************************!*\
  !*** ./js/components/setup/ModuleSetupFooter.js ***!
  \**************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ ModuleSetupFooter)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_10__);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/googlesitekit/datastore/site/constants */ "./js/googlesitekit/datastore/site/constants.js");
/* harmony import */ var _js_material_components__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/material-components */ "./js/material-components/index.js");
/* harmony import */ var _js_components_Link__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/components/Link */ "./js/components/Link.js");
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! googlesitekit-components */ "googlesitekit-components");
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_components__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var _js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @/js/googlesitekit/modules/datastore/constants */ "./js/googlesitekit/modules/datastore/constants.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * ModuleSetupFooter component.
 *
 * Site Kit by Google, Copyright 2022 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */







function ModuleSetupFooter({
  module,
  onCancel,
  onComplete
}) {
  const [isSaving, setIsSaving] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.useState)(false);
  const settingsPageURL = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.useSelect)(select => select(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_SITE).getAdminURL('googlesitekit-settings'));
  const isSetupBlocked = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.useSelect)(select => select(module?.storeName)?.isSetupBlocked?.());
  const canSubmitChanges = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.useSelect)(select => select(_js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_7__.CORE_MODULES).canSubmitChanges(module?.slug));
  const onCompleteSubmit = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.useCallback)(async () => {
    setIsSaving(true);
    await onComplete();
    setIsSaving(false);
  }, [setIsSaving, onComplete]);
  if (!module) {
    return null;
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)("div", {
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-setup__footer', `googlesitekit-setup__footer--${module?.slug}`),
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(_js_material_components__WEBPACK_IMPORTED_MODULE_4__.Grid, {
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsxs)(_js_material_components__WEBPACK_IMPORTED_MODULE_4__.Row, {
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(_js_material_components__WEBPACK_IMPORTED_MODULE_4__.Cell, {
          smSize: 2,
          mdSize: 4,
          lgSize: 6,
          alignMiddle: true,
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(_js_components_Link__WEBPACK_IMPORTED_MODULE_5__["default"], {
            id: `setup-${module.slug}-cancel`,
            href: settingsPageURL,
            onClick: onCancel,
            children: isSetupBlocked ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Back', 'google-site-kit') : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Cancel', 'google-site-kit')
          })
        }), onComplete && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(_js_material_components__WEBPACK_IMPORTED_MODULE_4__.Cell, {
          smSize: 2,
          mdSize: 4,
          lgSize: 6,
          alignRight: true,
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_6__.SpinnerButton, {
            id: `setup-${module.slug}-complete`,
            onClick: onCompleteSubmit,
            disabled: !canSubmitChanges || isSaving,
            isSaving: isSaving,
            children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Complete Setup', 'google-site-kit')
          })
        })]
      })
    })
  });
}
ModuleSetupFooter.propTypes = {
  module: prop_types__WEBPACK_IMPORTED_MODULE_10___default().shape({
    slug: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().string).isRequired,
    storeName: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().string).isRequired
  }).isRequired,
  onCancel: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().func).isRequired,
  onComplete: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().func)
};

/***/ }),

/***/ "./js/components/surveys/CurrentSurvey/SurveyQuestion.js":
/*!***************************************************************!*\
  !*** ./js/components/surveys/CurrentSurvey/SurveyQuestion.js ***!
  \***************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ SurveyQuestion)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _js_components_surveys_SurveyQuestionRating__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/components/surveys/SurveyQuestionRating */ "./js/components/surveys/SurveyQuestionRating.js");
/* harmony import */ var _js_components_surveys_SurveyQuestionOpenText__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/components/surveys/SurveyQuestionOpenText */ "./js/components/surveys/SurveyQuestionOpenText.js");
/* harmony import */ var _js_components_surveys_SurveyQuestionMultiSelect__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/components/surveys/SurveyQuestionMultiSelect */ "./js/components/surveys/SurveyQuestionMultiSelect.js");
/* harmony import */ var _js_components_surveys_SurveyQuestionSingleSelect__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/components/surveys/SurveyQuestionSingleSelect */ "./js/components/surveys/SurveyQuestionSingleSelect.js");
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./constants */ "./js/components/surveys/CurrentSurvey/constants.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * SurveyQuestion component.
 *
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */






function SurveyQuestion({
  currentQuestion,
  answerQuestion,
  dismissSurvey,
  isLastQuestion
}) {
  const commonProps = {
    key: currentQuestion.question_text,
    answerQuestion,
    dismissSurvey,
    question: currentQuestion.question_text,
    submitButtonText: isLastQuestion ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Submit', 'google-site-kit') : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Next', 'google-site-kit')
  };
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)(_wordpress_element__WEBPACK_IMPORTED_MODULE_7__.Fragment, {
    children: [currentQuestion.question_type === _constants__WEBPACK_IMPORTED_MODULE_5__.SURVEY_QUESTION_TYPE.MULTI_SELECT && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(_js_components_surveys_SurveyQuestionMultiSelect__WEBPACK_IMPORTED_MODULE_3__["default"], {
      ...commonProps,
      choices: currentQuestion.question.answer_choice,
      minChoices: currentQuestion.question.min_choices,
      maxChoices: currentQuestion.question.max_choices
    }), currentQuestion.question_type === _constants__WEBPACK_IMPORTED_MODULE_5__.SURVEY_QUESTION_TYPE.OPEN_TEXT && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(_js_components_surveys_SurveyQuestionOpenText__WEBPACK_IMPORTED_MODULE_2__["default"], {
      ...commonProps,
      subtitle: currentQuestion.question.subtitle,
      placeholder: currentQuestion.question.placeholder
    }), currentQuestion.question_type === _constants__WEBPACK_IMPORTED_MODULE_5__.SURVEY_QUESTION_TYPE.RATING && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(_js_components_surveys_SurveyQuestionRating__WEBPACK_IMPORTED_MODULE_1__["default"], {
      ...commonProps,
      choices: currentQuestion.question.answer_choice
    }), currentQuestion.question_type === _constants__WEBPACK_IMPORTED_MODULE_5__.SURVEY_QUESTION_TYPE.SINGLE_SELECT && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(_js_components_surveys_SurveyQuestionSingleSelect__WEBPACK_IMPORTED_MODULE_4__["default"], {
      ...commonProps,
      choices: currentQuestion.question.answer_choice
    })]
  });
}
SurveyQuestion.propTypes = {
  currentQuestion: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().object).isRequired,
  answerQuestion: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().func).isRequired,
  dismissSurvey: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().func).isRequired,
  isLastQuestion: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().bool).isRequired
};

/***/ }),

/***/ "./js/components/surveys/CurrentSurvey/constants.js":
/*!**********************************************************!*\
  !*** ./js/components/surveys/CurrentSurvey/constants.js ***!
  \**********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   SURVEY_QUESTION_TYPE: () => (/* binding */ SURVEY_QUESTION_TYPE)
/* harmony export */ });
/**
 * CurrentSurvey component constants.
 *
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

const SURVEY_QUESTION_TYPE = {
  MULTI_SELECT: 'multi_select',
  OPEN_TEXT: 'open_text',
  RATING: 'rating',
  SINGLE_SELECT: 'single_select'
};

/***/ }),

/***/ "./js/components/surveys/CurrentSurvey/index.js":
/*!******************************************************!*\
  !*** ./js/components/surveys/CurrentSurvey/index.js ***!
  \******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ CurrentSurvey)
/* harmony export */ });
/* harmony import */ var react_use__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! react-use */ "../node_modules/react-use/esm/useMount.js");
/* harmony import */ var _material_ui_core__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! @material-ui/core */ "../node_modules/@material-ui/core/esm/Slide/Slide.js");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _js_googlesitekit_datastore_forms_constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/googlesitekit/datastore/forms/constants */ "./js/googlesitekit/datastore/forms/constants.js");
/* harmony import */ var _js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/googlesitekit/datastore/user/constants */ "./js/googlesitekit/datastore/user/constants.js");
/* harmony import */ var _js_components_surveys_SurveyCompletion__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/components/surveys/SurveyCompletion */ "./js/components/surveys/SurveyCompletion.js");
/* harmony import */ var _js_components_surveys_SurveyTerms__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/components/surveys/SurveyTerms */ "./js/components/surveys/SurveyTerms.js");
/* harmony import */ var _SurveyQuestion__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./SurveyQuestion */ "./js/components/surveys/CurrentSurvey/SurveyQuestion.js");
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./utils */ "./js/components/surveys/CurrentSurvey/utils.js");
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./constants */ "./js/components/surveys/CurrentSurvey/constants.js");
/* harmony import */ var _js_hooks_useFormValue__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @/js/hooks/useFormValue */ "./js/hooks/useFormValue.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * CurrentSurvey component.
 *
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */










const SURVEY_ANSWER_DELAY_MS = 300;
const defaultAnswers = Object.freeze([]);
function CurrentSurvey() {
  const [sentSurveyShownEvent, setSentSurveyShownEvent] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_10__.useState)(false);
  const [sentCompletionEvent, setSentCompletionEvent] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_10__.useState)(false);
  const [animateSurvey, setAnimateSurvey] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_10__.useState)(false);
  const [hasAnsweredQuestion, setHasAnsweredQuestion] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_10__.useState)(false);
  const completions = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useSelect)(select => select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_2__.CORE_USER).getCurrentSurveyCompletions());
  const questions = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useSelect)(select => select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_2__.CORE_USER).getCurrentSurveyQuestions());
  const surveySession = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useSelect)(select => select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_2__.CORE_USER).getCurrentSurveySession());
  const isTrackingEnabled = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useSelect)(select => select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_2__.CORE_USER).isTrackingEnabled());
  const formName = surveySession ? `survey-${surveySession.session_id}` : null;
  const shouldHide = (0,_js_hooks_useFormValue__WEBPACK_IMPORTED_MODULE_8__["default"])(formName, 'hideSurvey');
  const answers = (0,_js_hooks_useFormValue__WEBPACK_IMPORTED_MODULE_8__["default"])(formName, 'answers') || defaultAnswers;
  const {
    setValues
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useDispatch)(_js_googlesitekit_datastore_forms_constants__WEBPACK_IMPORTED_MODULE_1__.CORE_FORMS);
  const {
    sendSurveyEvent
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useDispatch)(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_2__.CORE_USER);
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_10__.useEffect)(() => {
    if (questions?.length && !sentSurveyShownEvent) {
      setSentSurveyShownEvent(true);
      sendSurveyEvent('survey_shown');
    }
  }, [questions, sentSurveyShownEvent, sendSurveyEvent]);
  const {
    currentQuestion,
    currentQuestionOrdinal
  } = (0,_utils__WEBPACK_IMPORTED_MODULE_6__.getCurrentQuestionAndOrdinal)(questions, answers);
  const answerQuestion = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_10__.useCallback)(answer => {
    if (hasAnsweredQuestion) {
      return;
    }
    setHasAnsweredQuestion(true);
    sendSurveyEvent('question_answered', {
      // eslint-disable-next-line camelcase
      question_ordinal: currentQuestion?.question_ordinal,
      answer
    });
    setTimeout(() => {
      setValues(formName, {
        answers: [...answers, {
          // eslint-disable-next-line camelcase
          question_ordinal: currentQuestion?.question_ordinal,
          answer
        }]
      });
      setHasAnsweredQuestion(false);
    }, SURVEY_ANSWER_DELAY_MS);
  }, [answers, currentQuestion, formName, sendSurveyEvent, setValues, hasAnsweredQuestion]);
  const triggeredCompletion = (0,_utils__WEBPACK_IMPORTED_MODULE_6__.getTriggeredCompletion)(questions, answers, completions, currentQuestionOrdinal);
  const ctaOnClick = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_10__.useCallback)(() => {
    sendSurveyEvent('follow_up_link_clicked', {
      completion_ordinal: triggeredCompletion?.completion_ordinal // eslint-disable-line camelcase
    });
    sendSurveyEvent('survey_closed');
    setValues(formName, {
      hideSurvey: true
    });
  }, [formName, sendSurveyEvent, setValues, triggeredCompletion]);
  const dismissSurvey = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_10__.useCallback)(() => {
    sendSurveyEvent('survey_closed');
    setAnimateSurvey(false);
  }, [sendSurveyEvent]);
  const handleAnimationOnExited = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_10__.useCallback)(() => {
    setValues(formName, {
      hideSurvey: true
    });
  }, [formName, setValues]);
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_10__.useEffect)(() => {
    if (triggeredCompletion && !sentCompletionEvent) {
      setSentCompletionEvent(true);
      sendSurveyEvent('completion_shown', {
        completion_ordinal: triggeredCompletion?.completion_ordinal // eslint-disable-line camelcase
      });
    }
  }, [sentCompletionEvent, sendSurveyEvent, triggeredCompletion]);
  (0,react_use__WEBPACK_IMPORTED_MODULE_11__["default"])(() => {
    setAnimateSurvey(true);
  });
  if (shouldHide || !questions || !completions || isTrackingEnabled === undefined) {
    return null;
  }
  if (triggeredCompletion) {
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)(_material_ui_core__WEBPACK_IMPORTED_MODULE_12__["default"], {
      direction: "up",
      in: animateSurvey,
      onExited: handleAnimationOnExited,
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)("div", {
        className: "googlesitekit-survey",
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)(_js_components_surveys_SurveyCompletion__WEBPACK_IMPORTED_MODULE_3__["default"], {
          dismissSurvey: dismissSurvey,
          ctaOnClick: ctaOnClick,
          ctaText: triggeredCompletion.follow_up_text,
          ctaURL: triggeredCompletion.follow_up_url,
          title: triggeredCompletion.completion_title,
          children: triggeredCompletion.completion_text
        })
      })
    });
  }

  // eslint-disable-next-line camelcase
  if (!Object.values(_constants__WEBPACK_IMPORTED_MODULE_7__.SURVEY_QUESTION_TYPE).includes(currentQuestion?.question_type)) {
    return null;
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)(_material_ui_core__WEBPACK_IMPORTED_MODULE_12__["default"], {
    direction: "up",
    in: animateSurvey,
    onExited: handleAnimationOnExited,
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsxs)("div", {
      className: "googlesitekit-survey",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)(_SurveyQuestion__WEBPACK_IMPORTED_MODULE_5__["default"], {
        currentQuestion: currentQuestion,
        answerQuestion: answerQuestion,
        dismissSurvey: dismissSurvey,
        isLastQuestion: (0,_utils__WEBPACK_IMPORTED_MODULE_6__.isLastQuestion)(questions, currentQuestion)
      }), isTrackingEnabled === false && currentQuestion?.question_ordinal === 1 &&
      /*#__PURE__*/
      // eslint-disable-line camelcase
      (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)("div", {
        className: "googlesitekit-survey__footer",
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)(_js_components_surveys_SurveyTerms__WEBPACK_IMPORTED_MODULE_4__["default"], {})
      })]
    })
  });
}

/***/ }),

/***/ "./js/components/surveys/CurrentSurvey/utils.js":
/*!******************************************************!*\
  !*** ./js/components/surveys/CurrentSurvey/utils.js ***!
  \******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   getCurrentQuestionAndOrdinal: () => (/* binding */ getCurrentQuestionAndOrdinal),
/* harmony export */   getTriggeredCompletion: () => (/* binding */ getTriggeredCompletion),
/* harmony export */   isLastQuestion: () => (/* binding */ isLastQuestion)
/* harmony export */ });
/**
 * CurrentSurvey utility functions.
 *
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Gets the current question and its ordinal.
 *
 * @since 1.154.0
 *
 * @param {Object[]} questions The questions in the survey.
 * @param {Object[]} answers   The answers to the questions.
 * @return {Object} The current question and its ordinal.
 */
function getCurrentQuestionAndOrdinal(questions, answers) {
  const ordinalAnswerMap = createOrdinalAnswerMap(answers);
  let currentQuestionOrdinal = Math.max(0, ...answers.map(answer => answer.question_ordinal)) + 1;
  const currentQuestion = questions?.find(question => {
    const {
      question_ordinal: questionOrdinal,
      trigger_condition: conditions
    } = question;

    // Ignore questions that have ordinal lower than the current one.
    if (questionOrdinal < currentQuestionOrdinal) {
      return false;
    }
    if (Array.isArray(conditions) && conditions.length > 0) {
      for (const condition of conditions) {
        // Get the answer for the question in the condition and return
        // early if there is no answer for that question yet.
        const answer = ordinalAnswerMap[condition.question_ordinal];
        if (!answer) {
          currentQuestionOrdinal++;
          return false;
        }

        // If we have the answer, check if it is one of the expected answers
        // for the condition.
        const allowedAnswers = condition.answer_ordinal || [];

        // If the answer is a single number, we check whether it is in the
        // allowed answers and return early if it is not.
        if (!Array.isArray(answer) && !allowedAnswers.includes(answer)) {
          currentQuestionOrdinal++;
          return false;
        }

        // If the answer is multiple-choice, check whether any of its values
        // is in the allowed answers and return early if none of answer values
        // are included in the allowed answers list.
        if (Array.isArray(answer)) {
          const hasAnswers = answer.some(({
            answer_ordinal: answerOrdinal
          }) => allowedAnswers.includes(answerOrdinal));
          if (!hasAnswers) {
            currentQuestionOrdinal++;
            break;
          }
        }
      }
    }
    return questionOrdinal === currentQuestionOrdinal;
  });
  return {
    currentQuestion,
    currentQuestionOrdinal
  };
}

/**
 * Gets the triggered completion.
 *
 * @since 1.154.0
 *
 * @param {Object[]} questions              The questions in the survey.
 * @param {Object[]} answers                The answers to the questions.
 * @param {Object[]} completions            The completions in the survey.
 * @param {number}   currentQuestionOrdinal The ordinal of the current question.
 * @return {Object} The triggered completion.
 */
function getTriggeredCompletion(questions, answers, completions, currentQuestionOrdinal) {
  const ordinalAnswerMap = createOrdinalAnswerMap(answers);

  // Check to see if a completion trigger has been met.
  let triggeredCompletion;
  if (questions?.length && currentQuestionOrdinal > questions.length) {
    triggeredCompletion = (completions || []).find(completion => {
      const conditions = completion.trigger_condition || [];
      for (const condition of conditions) {
        // If a question was answered with the appropriate value, a completion
        // trigger has been fulfilled and we should treat this survey as
        // complete.
        if (condition.answer_ordinal.includes(ordinalAnswerMap[condition.question_ordinal])) {
          // eslint-disable-line camelcase
          triggeredCompletion = completion;
          return true;
        }
      }
      return false;
    });

    // If no specific trigger has been found but all questions are answered, use
    // the first available trigger.
    if (!triggeredCompletion) {
      triggeredCompletion = completions[0];
    }
  }
  return triggeredCompletion;
}

/**
 * Checks if the current question is the last question in the survey.
 *
 * @since 1.154.0
 *
 * @param {Object[]} questions       The questions in the survey.
 * @param {Object}   currentQuestion The current question.
 * @return {boolean} Whether the current question is the last question in the survey.
 */
function isLastQuestion(questions, currentQuestion) {
  // To properly determine the submit button label, we need to check if the current
  // question is the last question in the survey. This is done by checking if
  // there are any trigger conditions that reference the current question. If
  // there are no trigger conditions, it means that the current question is the
  // last question in the survey.
  return questions.some(({
    trigger_condition: conditions
  }) => {
    if (!Array.isArray(conditions) || conditions.length === 0) {
      return false;
    }
    return conditions.some(condition => condition.question_ordinal === currentQuestion.question_ordinal);
  }) === false;
}

/**
 * Creates a map of question ordinals to answers.
 *
 * @since 1.154.0
 *
 * @param {Object[]} answers The answers to the questions.
 * @return {Object} The map of question ordinals to answers.
 */
function createOrdinalAnswerMap(answers) {
  return answers.reduce((acc, {
    question_ordinal: ordinal,
    answer
  }) => ({
    ...acc,
    [ordinal]: answer.answer.answer_ordinal || answer.answer
  }), {});
}

/***/ }),

/***/ "./js/components/surveys/CurrentSurveyPortal.js":
/*!******************************************************!*\
  !*** ./js/components/surveys/CurrentSurveyPortal.js ***!
  \******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ CurrentSurveyPortal)
/* harmony export */ });
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/googlesitekit/datastore/site/constants */ "./js/googlesitekit/datastore/site/constants.js");
/* harmony import */ var _js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/googlesitekit/datastore/user/constants */ "./js/googlesitekit/datastore/user/constants.js");
/* harmony import */ var _CurrentSurvey__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./CurrentSurvey */ "./js/components/surveys/CurrentSurvey/index.js");
/* harmony import */ var _js_components_Portal__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/components/Portal */ "./js/components/Portal.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * CurrentSurveyPortal component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Internal dependencies
 */






function CurrentSurveyPortal() {
  const currentSurvey = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useSelect)(select => select(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_1__.CORE_SITE).isUsingProxy() && select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_2__.CORE_USER).areSurveysOnCooldown() === false ? select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_2__.CORE_USER).getCurrentSurvey() : null);
  if (!currentSurvey) {
    return null;
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_js_components_Portal__WEBPACK_IMPORTED_MODULE_4__["default"], {
    slug: "survey",
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_CurrentSurvey__WEBPACK_IMPORTED_MODULE_3__["default"], {})
  });
}

/***/ }),

/***/ "./js/components/surveys/SurveyCompletion.js":
/*!***************************************************!*\
  !*** ./js/components/surveys/SurveyCompletion.js ***!
  \***************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! googlesitekit-components */ "googlesitekit-components");
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_components__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _SurveyHeader__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./SurveyHeader */ "./js/components/surveys/SurveyHeader.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * SurveyCompletion component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * Internal dependencies
 */



function SurveyCompletion({
  title,
  children,
  ctaText,
  ctaURL,
  ctaOnClick,
  dismissSurvey
}) {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)("div", {
    className: "googlesitekit-survey__completion",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)(_SurveyHeader__WEBPACK_IMPORTED_MODULE_1__["default"], {
      title: title,
      dismissSurvey: dismissSurvey
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("div", {
      className: "googlesitekit-survey__body",
      children: children
    }), ctaURL && ctaText && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("div", {
      className: "googlesitekit-survey__footer",
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_0__.Button, {
        href: ctaURL,
        onClick: ctaOnClick,
        target: "_blank",
        children: ctaText
      })
    })]
  });
}
SurveyCompletion.propTypes = {
  title: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string).isRequired,
  children: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().node),
  ctaText: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  ctaURL: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  ctaOnClick: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().func),
  dismissSurvey: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().func).isRequired
};
SurveyCompletion.defaultProps = {
  title: '',
  children: null,
  ctaText: '',
  ctaURL: '',
  ctaOnClick: null
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (SurveyCompletion);

/***/ }),

/***/ "./js/components/surveys/SurveyHeader.js":
/*!***********************************************!*\
  !*** ./js/components/surveys/SurveyHeader.js ***!
  \***********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @wordpress/icons */ "../node_modules/@wordpress/icons/build-module/icon/index.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @wordpress/icons */ "../node_modules/@wordpress/icons/build-module/library/close-small.js");
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-components */ "googlesitekit-components");
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _svg_graphics_logo_g_svg__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/svg/graphics/logo-g.svg */ "./svg/graphics/logo-g.svg");
/* harmony import */ var _js_components_Typography__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/components/Typography */ "./js/components/Typography/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * SurveyHeader component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */




function SurveyHeader({
  title,
  dismissSurvey
}) {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsxs)("div", {
    className: "googlesitekit-survey__header",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("div", {
      className: "googlesitekit-survey__header-logo",
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(_svg_graphics_logo_g_svg__WEBPACK_IMPORTED_MODULE_2__["default"], {
        width: 24,
        height: 24
      })
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsxs)("div", {
      className: "googlesitekit-survey__header-details",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(_js_components_Typography__WEBPACK_IMPORTED_MODULE_3__["default"], {
        as: "h3",
        type: "headline",
        size: "small",
        children: title
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__.Button, {
        "aria-label": (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Dismiss', 'google-site-kit'),
        icon: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(_wordpress_icons__WEBPACK_IMPORTED_MODULE_5__["default"], {
          icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_6__["default"],
          size: 40
        }),
        onClick: dismissSurvey,
        className: "googlesitekit-survey__header-close"
      })]
    })]
  });
}
SurveyHeader.propTypes = {
  title: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().string).isRequired,
  dismissSurvey: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().func).isRequired
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (SurveyHeader);

/***/ }),

/***/ "./js/components/surveys/SurveyQuestionMultiSelect.js":
/*!************************************************************!*\
  !*** ./js/components/surveys/SurveyQuestionMultiSelect.js ***!
  \************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_10__);
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! lodash */ "../node_modules/lodash/lodash.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_compose__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @wordpress/compose */ "../node_modules/@wordpress/compose/build-module/hooks/use-instance-id/index.js");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! googlesitekit-components */ "googlesitekit-components");
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_components__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _SurveyHeader__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./SurveyHeader */ "./js/components/surveys/SurveyHeader.js");
/* harmony import */ var _js_components_VisuallyHidden__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/components/VisuallyHidden */ "./js/components/VisuallyHidden.js");
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./constants */ "./js/components/surveys/constants.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * SurveyQuestionMultiSelect component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */




/**
 * WordPress dependencies
 */




/**
 * Internal dependencies
 */





function SurveyQuestionMultiSelect({
  question,
  choices,
  answerQuestion,
  dismissSurvey,
  minChoices = 1,
  maxChoices,
  submitButtonText
}) {
  const instanceID = (0,_wordpress_compose__WEBPACK_IMPORTED_MODULE_8__["default"])(SurveyQuestionMultiSelect, 'SurveyQuestionMultiSelect');

  // eslint-disable-next-line camelcase
  const mappedChoices = choices.map(({
    answer_ordinal,
    write_in
  }) => {
    // write_in means we need to support free text for that option (answer_text holds this in state).
    const optionalKeys = write_in ? {
      answer_text: ''
    } : {}; // eslint-disable-line camelcase

    return {
      answer_ordinal,
      selected: false,
      ...optionalKeys
    };
  });
  const initialState = (0,lodash__WEBPACK_IMPORTED_MODULE_1__.keyBy)(mappedChoices, 'answer_ordinal');
  const [selectedValues, setSelectedValues] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.useState)(initialState);

  // eslint-disable-next-line camelcase
  function handleCheck(answer_ordinal) {
    const newState = {
      ...selectedValues,
      [answer_ordinal]: {
        ...selectedValues[answer_ordinal],
        selected: !selectedValues[answer_ordinal].selected
      }
    };
    setSelectedValues(newState);
  }

  // eslint-disable-next-line camelcase
  function handleAnswerChange(event, answer_ordinal) {
    const newState = {
      ...selectedValues,
      [answer_ordinal]: {
        ...selectedValues[answer_ordinal],
        answer_text: event.target.value?.slice(0, _constants__WEBPACK_IMPORTED_MODULE_6__.SURVEY_INPUT_MAX_CHARACTER_LIMIT)
      }
    };
    setSelectedValues(newState);
  }
  function handleSubmit() {
    const answer = Object.values(selectedValues).filter(({
      selected
    }) => selected)
    // eslint-disable-next-line camelcase
    .map(({
      answer_ordinal,
      answer_text
    }) => {
      // eslint-disable-next-line camelcase
      if (answer_text) {
        return {
          answer_ordinal,
          answer_text
        };
      }
      return {
        answer_ordinal
      };
    });
    answerQuestion({
      answer
    });
  }
  const hasEmptySelectedTextValue =
  // eslint-disable-next-line camelcase
  choices.filter(({
    write_in,
    answer_ordinal
  }) => {
    // eslint-disable-next-line camelcase
    if (write_in) {
      // eslint-disable-next-line camelcase
      const {
        selected,
        answer_text
      } = selectedValues[answer_ordinal];
      if (selected && answer_text.length === 0) {
        return true;
      }
    }
    return false;
  }).length > 0;
  const totalSelectedValues = Object.values(selectedValues).filter(({
    selected
  }) => selected).length;
  const hasLessThanMinChoices = totalSelectedValues < minChoices;
  const hasMaximumNumberOfChoices = maxChoices && totalSelectedValues === maxChoices;
  const isSubmitButtonDisabled = hasEmptySelectedTextValue || hasLessThanMinChoices;
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsxs)("div", {
    className: "googlesitekit-survey__multi-select",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_SurveyHeader__WEBPACK_IMPORTED_MODULE_4__["default"], {
      title: question,
      dismissSurvey: dismissSurvey
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)("div", {
      className: "googlesitekit-survey__body",
      children:
      // eslint-disable-next-line camelcase
      choices.map(({
        answer_ordinal,
        text,
        write_in
      }) => {
        const answer = selectedValues[answer_ordinal];
        // eslint-disable-next-line camelcase
        const id = `${instanceID}-answer-${answer_ordinal}`;
        return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsxs)("div", {
          className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-survey__multi-select__choice', {
            'googlesitekit-survey__multi-select__choice--disabled': hasMaximumNumberOfChoices && !answer.selected
          }),
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_3__.Checkbox, {
            checked: answer.selected,
            disabled: hasMaximumNumberOfChoices && !answer.selected,
            onChange: () => handleCheck(answer_ordinal)
            // Checkbox requires value prop to be a string.
            // eslint-disable-next-line camelcase
            ,
            value: `${answer_ordinal}`,
            id: id,
            name: id,
            children: text
          }),
          // eslint-disable-next-line camelcase
          write_in && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsxs)(_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.Fragment, {
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_js_components_VisuallyHidden__WEBPACK_IMPORTED_MODULE_5__["default"], {
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)("label", {
                htmlFor: `${id}-write-in`,
                children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.sprintf)(/* translators: %s: Option name */
                (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Text input for option %s', 'google-site-kit'), text)
              })
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_3__.TextField, {
              id: `${id}-write-in`,
              onChange: event => handleAnswerChange(event, answer_ordinal),
              value: answer.answer_text,
              disabled: !answer.selected
            })]
          })]
        }, id);
      })
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsxs)("div", {
      className: "googlesitekit-survey__footer",
      children: [minChoices > 1 && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_3__.HelperText, {
        persistent: true,
        children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.sprintf)(/* translators: %s: the number of answers. */
        (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Choose at least %s answers', 'google-site-kit'), minChoices)
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_3__.Button, {
        onClick: handleSubmit,
        disabled: isSubmitButtonDisabled,
        children: submitButtonText
      })]
    })]
  });
}
SurveyQuestionMultiSelect.propTypes = {
  question: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().string).isRequired,
  choices: prop_types__WEBPACK_IMPORTED_MODULE_10___default().arrayOf(prop_types__WEBPACK_IMPORTED_MODULE_10___default().shape({
    answer_ordinal: prop_types__WEBPACK_IMPORTED_MODULE_10___default().oneOfType([(prop_types__WEBPACK_IMPORTED_MODULE_10___default().string), (prop_types__WEBPACK_IMPORTED_MODULE_10___default().number)]),
    text: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().string),
    write_in: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().bool)
  })).isRequired,
  answerQuestion: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().func).isRequired,
  dismissSurvey: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().func).isRequired,
  minChoices: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().number),
  maxChoices: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().number),
  submitButtonText: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().string).isRequired
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (SurveyQuestionMultiSelect);

/***/ }),

/***/ "./js/components/surveys/SurveyQuestionOpenText.js":
/*!*********************************************************!*\
  !*** ./js/components/surveys/SurveyQuestionOpenText.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _wordpress_compose__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @wordpress/compose */ "../node_modules/@wordpress/compose/build-module/hooks/use-instance-id/index.js");
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! googlesitekit-components */ "googlesitekit-components");
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_components__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _SurveyHeader__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./SurveyHeader */ "./js/components/surveys/SurveyHeader.js");
/* harmony import */ var _js_components_VisuallyHidden__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/components/VisuallyHidden */ "./js/components/VisuallyHidden.js");
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./constants */ "./js/components/surveys/constants.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * SurveyQuestionOpenText component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */





function SurveyQuestionOpenText({
  question,
  answerQuestion,
  placeholder,
  subtitle,
  dismissSurvey,
  submitButtonText
}) {
  const [value, setValue] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_5__.useState)('');
  function handleSubmit() {
    answerQuestion({
      answer: value
    });
  }
  const onChange = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_5__.useCallback)(event => {
    setValue(event.target.value.slice(0, _constants__WEBPACK_IMPORTED_MODULE_3__.SURVEY_INPUT_MAX_CHARACTER_LIMIT));
  }, [setValue]);
  const instanceID = (0,_wordpress_compose__WEBPACK_IMPORTED_MODULE_6__["default"])(SurveyQuestionOpenText, 'SurveyQuestionOpenText');
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsxs)("div", {
    className: "googlesitekit-survey__open-text",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(_SurveyHeader__WEBPACK_IMPORTED_MODULE_1__["default"], {
      title: question,
      dismissSurvey: dismissSurvey
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsxs)("div", {
      className: "googlesitekit-survey__body",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(_js_components_VisuallyHidden__WEBPACK_IMPORTED_MODULE_2__["default"], {
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("label", {
          htmlFor: instanceID,
          children: placeholder
        })
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_0__.TextField, {
        name: `survey-opentext-${instanceID}`,
        helperText: subtitle,
        onChange: onChange,
        label: placeholder,
        inputType: "textarea",
        id: instanceID,
        value: value,
        textarea: true
      })]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("div", {
      className: "googlesitekit-survey__footer",
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_0__.Button, {
        disabled: value.length === 0,
        onClick: handleSubmit,
        children: submitButtonText
      })
    })]
  });
}
SurveyQuestionOpenText.propTypes = {
  question: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().string).isRequired,
  subtitle: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().string).isRequired,
  placeholder: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().string).isRequired,
  answerQuestion: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().func).isRequired,
  dismissSurvey: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().func).isRequired,
  submitButtonText: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().string).isRequired
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (SurveyQuestionOpenText);

/***/ }),

/***/ "./js/components/surveys/SurveyQuestionRating.js":
/*!*******************************************************!*\
  !*** ./js/components/surveys/SurveyQuestionRating.js ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _SurveyHeader__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./SurveyHeader */ "./js/components/surveys/SurveyHeader.js");
/* harmony import */ var _SurveyQuestionRatingChoice__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./SurveyQuestionRatingChoice */ "./js/components/surveys/SurveyQuestionRatingChoice.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * SurveyQuestionRating component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * Internal dependencies
 */



function SurveyQuestionRating({
  question,
  choices,
  answerQuestion,
  dismissSurvey
}) {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)("div", {
    className: "googlesitekit-survey__question-rating",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)(_SurveyHeader__WEBPACK_IMPORTED_MODULE_0__["default"], {
      title: question,
      dismissSurvey: dismissSurvey
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("div", {
      className: "googlesitekit-survey__body",
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("div", {
        className: "googlesitekit-survey__choices",
        children: choices.map((choice, index) => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)(_SurveyQuestionRatingChoice__WEBPACK_IMPORTED_MODULE_1__["default"], {
          choice: choice,
          answerQuestion: answerQuestion
        }, index))
      })
    })]
  });
}
SurveyQuestionRating.propTypes = {
  question: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string).isRequired,
  choices: prop_types__WEBPACK_IMPORTED_MODULE_3___default().arrayOf(prop_types__WEBPACK_IMPORTED_MODULE_3___default().shape({
    answer_ordinal: prop_types__WEBPACK_IMPORTED_MODULE_3___default().oneOfType([(prop_types__WEBPACK_IMPORTED_MODULE_3___default().string), (prop_types__WEBPACK_IMPORTED_MODULE_3___default().number)]),
    text: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string)
  })).isRequired,
  answerQuestion: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().func).isRequired,
  dismissSurvey: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().func).isRequired
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (SurveyQuestionRating);

/***/ }),

/***/ "./js/components/surveys/SurveyQuestionRatingChoice.js":
/*!*************************************************************!*\
  !*** ./js/components/surveys/SurveyQuestionRatingChoice.js ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! googlesitekit-components */ "googlesitekit-components");
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_components__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _js_components_Typography_P__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/components/Typography/P */ "./js/components/Typography/P.js");
/* harmony import */ var _svg_icons_survey_unhappy_svg__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/svg/icons/survey-unhappy.svg */ "./svg/icons/survey-unhappy.svg");
/* harmony import */ var _svg_icons_survey_dissatisfied_svg__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/svg/icons/survey-dissatisfied.svg */ "./svg/icons/survey-dissatisfied.svg");
/* harmony import */ var _svg_icons_survey_neutral_svg__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/svg/icons/survey-neutral.svg */ "./svg/icons/survey-neutral.svg");
/* harmony import */ var _svg_icons_survey_satisfied_svg__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/svg/icons/survey-satisfied.svg */ "./svg/icons/survey-satisfied.svg");
/* harmony import */ var _svg_icons_survey_delighted_svg__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @/svg/icons/survey-delighted.svg */ "./svg/icons/survey-delighted.svg");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * SurveyQuestionRatingChoice component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */








const ordinalIconMap = {
  1: _svg_icons_survey_unhappy_svg__WEBPACK_IMPORTED_MODULE_2__["default"],
  2: _svg_icons_survey_dissatisfied_svg__WEBPACK_IMPORTED_MODULE_3__["default"],
  3: _svg_icons_survey_neutral_svg__WEBPACK_IMPORTED_MODULE_4__["default"],
  4: _svg_icons_survey_satisfied_svg__WEBPACK_IMPORTED_MODULE_5__["default"],
  5: _svg_icons_survey_delighted_svg__WEBPACK_IMPORTED_MODULE_6__["default"]
};
function SurveyQuestionRatingChoice({
  choice,
  answerQuestion
}) {
  const handleButtonClick = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_8__.useCallback)(() => {
    if (typeof answerQuestion === 'function') {
      answerQuestion({
        answer: {
          answer_ordinal: choice.answer_ordinal
        }
      });
    }
  }, [answerQuestion, choice]);
  const Icon = ordinalIconMap[choice.answer_ordinal];
  if (!Icon) {
    return null;
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsxs)("div", {
    className: "googlesitekit-survey__choice",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_0__.Button, {
      icon: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(Icon, {
        width: 30,
        height: 30
      }),
      "aria-label": choice.text,
      onClick: handleButtonClick
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_js_components_Typography_P__WEBPACK_IMPORTED_MODULE_1__["default"], {
      children: choice.text
    })]
  });
}
SurveyQuestionRatingChoice.propTypes = {
  choice: prop_types__WEBPACK_IMPORTED_MODULE_9___default().shape({
    answer_ordinal: prop_types__WEBPACK_IMPORTED_MODULE_9___default().oneOfType([(prop_types__WEBPACK_IMPORTED_MODULE_9___default().string), (prop_types__WEBPACK_IMPORTED_MODULE_9___default().number)]),
    text: (prop_types__WEBPACK_IMPORTED_MODULE_9___default().string)
  }).isRequired
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (SurveyQuestionRatingChoice);

/***/ }),

/***/ "./js/components/surveys/SurveyQuestionSingleSelect.js":
/*!*************************************************************!*\
  !*** ./js/components/surveys/SurveyQuestionSingleSelect.js ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! googlesitekit-components */ "googlesitekit-components");
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_components__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _SurveyHeader__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./SurveyHeader */ "./js/components/surveys/SurveyHeader.js");
/* harmony import */ var _SurveyQuestionSingleSelectChoice__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./SurveyQuestionSingleSelectChoice */ "./js/components/surveys/SurveyQuestionSingleSelectChoice.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * SurveyQuestionSingleSelect component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */




function SurveyQuestionSingleSelect({
  question,
  choices,
  answerQuestion,
  dismissSurvey,
  submitButtonText
}) {
  const [value, setValue] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_4__.useState)('');
  const [writeIn, setWriteIn] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_4__.useState)('');
  const mappedChoices = choices.map(choice => ({
    ...choice,
    // Radio requires value prop to be a string.
    answer_ordinal: `${choice.answer_ordinal}`
  }));
  const currentSelectedOptionHasWriteIn = !!value && mappedChoices.filter(({
    answer_ordinal,
    write_in
  } // eslint-disable-line camelcase
  ) => answer_ordinal === value && write_in // eslint-disable-line camelcase
  ).length > 0;
  function handleSubmit() {
    const answerTextOptionalKey = currentSelectedOptionHasWriteIn ? {
      answer_text: writeIn
    } : {};
    answerQuestion({
      answer: {
        answer_ordinal: Number(value),
        ...answerTextOptionalKey
      }
    });
  }
  const isSubmitButtonDisabled = value === '' || currentSelectedOptionHasWriteIn && writeIn === '';
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
    className: "googlesitekit-single-select",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_SurveyHeader__WEBPACK_IMPORTED_MODULE_1__["default"], {
      title: question,
      dismissSurvey: dismissSurvey
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
      className: "googlesitekit-survey__body",
      children: mappedChoices.map((choice, id) => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_SurveyQuestionSingleSelectChoice__WEBPACK_IMPORTED_MODULE_2__["default"], {
        value: value,
        setValue: setValue,
        writeIn: writeIn,
        setWriteIn: setWriteIn,
        choice: choice
      }, id))
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
      className: "googlesitekit-survey__footer",
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_0__.Button, {
        onClick: handleSubmit,
        disabled: isSubmitButtonDisabled,
        children: submitButtonText
      })
    })]
  });
}
SurveyQuestionSingleSelect.propTypes = {
  question: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().string).isRequired,
  choices: prop_types__WEBPACK_IMPORTED_MODULE_5___default().arrayOf(prop_types__WEBPACK_IMPORTED_MODULE_5___default().shape({
    answer_ordinal: prop_types__WEBPACK_IMPORTED_MODULE_5___default().oneOfType([(prop_types__WEBPACK_IMPORTED_MODULE_5___default().string), (prop_types__WEBPACK_IMPORTED_MODULE_5___default().number)]),
    text: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().string),
    write_in: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().bool)
  })).isRequired,
  answerQuestion: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().func).isRequired,
  dismissSurvey: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().func).isRequired
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (SurveyQuestionSingleSelect);

/***/ }),

/***/ "./js/components/surveys/SurveyQuestionSingleSelectChoice.js":
/*!*******************************************************************!*\
  !*** ./js/components/surveys/SurveyQuestionSingleSelectChoice.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-components */ "googlesitekit-components");
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _js_components_VisuallyHidden__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/components/VisuallyHidden */ "./js/components/VisuallyHidden.js");
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./constants */ "./js/components/surveys/constants.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * SurveyQuestionSingleSelectChoice component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */




function SurveyQuestionSingleSelectChoice({
  value,
  setValue,
  writeIn,
  setWriteIn,
  choice
}) {
  const {
    answer_ordinal,
    text,
    write_in
  } = choice; // eslint-disable-line camelcase
  const isChecked = value === answer_ordinal; // eslint-disable-line camelcase
  const uniqueID = `googlesitekit-survey__multi-select-${answer_ordinal}-${text}`; // eslint-disable-line camelcase

  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsxs)("div", {
    className: "googlesitekit-single-select__choice",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__.Radio, {
      id: text.replace(/ /g, '-'),
      value: answer_ordinal // eslint-disable-line camelcase
      ,
      checked: isChecked,
      name: text,
      onClick: () => setValue(answer_ordinal),
      children: text
    }), write_in &&
    /*#__PURE__*/
    // eslint-disable-line camelcase
    (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsxs)(_wordpress_element__WEBPACK_IMPORTED_MODULE_5__.Fragment, {
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(_js_components_VisuallyHidden__WEBPACK_IMPORTED_MODULE_2__["default"], {
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("label", {
          htmlFor: uniqueID,
          children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.sprintf)(/* translators: %s: Option name */
          (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Text input for option %s', 'google-site-kit'), text)
        })
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__.TextField, {
        id: uniqueID,
        onChange: event => setWriteIn(event.target.value.slice(0, _constants__WEBPACK_IMPORTED_MODULE_3__.SURVEY_INPUT_MAX_CHARACTER_LIMIT)),
        value: writeIn,
        disabled: !isChecked
      })]
    })]
  });
}
SurveyQuestionSingleSelectChoice.propTypes = {
  choice: prop_types__WEBPACK_IMPORTED_MODULE_6___default().shape({
    answer_ordinal: prop_types__WEBPACK_IMPORTED_MODULE_6___default().oneOfType([(prop_types__WEBPACK_IMPORTED_MODULE_6___default().string), (prop_types__WEBPACK_IMPORTED_MODULE_6___default().number)]),
    text: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().string),
    write_in: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().bool)
  }),
  value: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().string).isRequired,
  setValue: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().func).isRequired,
  writeIn: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().string).isRequired,
  setWriteIn: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().func).isRequired
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (SurveyQuestionSingleSelectChoice);

/***/ }),

/***/ "./js/components/surveys/SurveyTerms.js":
/*!**********************************************!*\
  !*** ./js/components/surveys/SurveyTerms.js ***!
  \**********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ SurveyTerms)
/* harmony export */ });
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/@wordpress/element/build-module/create-interpolate-element.js");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/googlesitekit/datastore/site/constants */ "./js/googlesitekit/datastore/site/constants.js");
/* harmony import */ var _js_components_Link__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/components/Link */ "./js/components/Link.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * SurveyTerms component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */




function SurveyTerms() {
  const privacy = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_2__.CORE_SITE).getGooglePrivacyPolicyURL());
  const terms = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_2__.CORE_SITE).getGoogleTermsURL());
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("p", {
    className: "googlesitekit-survey__terms",
    children: (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_5__["default"])((0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('By continuing, you agree to allow Google to use your answers and account info to improve services, per our <privacy>Privacy</privacy> & <terms>Terms</terms>.', 'google-site-kit'), {
      privacy: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(_js_components_Link__WEBPACK_IMPORTED_MODULE_3__["default"], {
        href: privacy,
        external: true,
        hideExternalIndicator: true,
        noFlex: true
      }),
      terms: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(_js_components_Link__WEBPACK_IMPORTED_MODULE_3__["default"], {
        href: terms,
        external: true,
        hideExternalIndicator: true,
        noFlex: true
      })
    })
  });
}

/***/ }),

/***/ "./js/components/surveys/SurveyViewTrigger.js":
/*!****************************************************!*\
  !*** ./js/components/surveys/SurveyViewTrigger.js ***!
  \****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ SurveyViewTrigger)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/googlesitekit/datastore/user/constants */ "./js/googlesitekit/datastore/user/constants.js");
/**
 * SurveyViewTrigger component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */


/**
 * External dependencies
 */


/**
 * Internal dependencies
 */


function SurveyViewTrigger({
  triggerID,
  ttl = 0
}) {
  const {
    triggerSurvey
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useDispatch)(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_1__.CORE_USER);
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useEffect)(() => {
    triggerSurvey(triggerID, {
      ttl
    });
  }, [triggerID, ttl, triggerSurvey]);
  return null;
}
SurveyViewTrigger.propTypes = {
  triggerID: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string).isRequired,
  ttl: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().number)
};

/***/ }),

/***/ "./js/components/surveys/constants.js":
/*!********************************************!*\
  !*** ./js/components/surveys/constants.js ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   SURVEY_INPUT_MAX_CHARACTER_LIMIT: () => (/* binding */ SURVEY_INPUT_MAX_CHARACTER_LIMIT)
/* harmony export */ });
/**
 * Survey constants.
 *
 * Site Kit by Google, Copyright 2022 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

const SURVEY_INPUT_MAX_CHARACTER_LIMIT = 200;

/***/ }),

/***/ "./js/features/index.js":
/*!******************************!*\
  !*** ./js/features/index.js ***!
  \******************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   enabledFeatures: () => (/* binding */ enabledFeatures),
/* harmony export */   isFeatureEnabled: () => (/* binding */ isFeatureEnabled)
/* harmony export */ });
/**
 * Feature flags.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

const enabledFeatures = new Set(__webpack_require__.g?._googlesitekitBaseData?.enabledFeatures || []);

/**
 * Returns true if a feature is enabled; false otherwise.
 *
 * @since 1.25.0
 * @since 1.33.0 Changed _enabledFeatures argument to be a `Set` instead of `Array`.
 *
 * @param {string} feature            The name of the feature to check.
 * @param {Set}    [_enabledFeatures] Optional. The set of enabled features. Uses `enabledFeatures` set by the server in a global JS variable, by default.
 * @return {boolean} `true` if a feature is enabled; `false` otherwise.
 */
function isFeatureEnabled(feature, _enabledFeatures = enabledFeatures) {
  if (!(_enabledFeatures instanceof Set)) {
    return false;
  }
  return _enabledFeatures.has(feature);
}

/***/ }),

/***/ "./js/googlesitekit-main-dashboard.js":
/*!********************************************!*\
  !*** ./js/googlesitekit-main-dashboard.js ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _wordpress_dom_ready__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @wordpress/dom-ready */ "../node_modules/@wordpress/dom-ready/build-module/index.js");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react-dom/index.js");
/* harmony import */ var _googlesitekit_api_cache__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./googlesitekit/api/cache */ "./js/googlesitekit/api/cache.js");
/* harmony import */ var _components_Root__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./components/Root */ "./js/components/Root/index.js");
/* harmony import */ var _googlesitekit_constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./googlesitekit/constants */ "./js/googlesitekit/constants.js");
/* harmony import */ var _components_DashboardEntryPoint__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./components/DashboardEntryPoint */ "./js/components/DashboardEntryPoint.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Dashboard component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */





// Initialize the app once the DOM is ready.

(0,_wordpress_dom_ready__WEBPACK_IMPORTED_MODULE_5__["default"])(async () => {
  if (__webpack_require__.g._googlesitekitLegacyData.admin.resetSession) {
    await (0,_googlesitekit_api_cache__WEBPACK_IMPORTED_MODULE_0__.clearCache)();
  }
  const renderTarget = document.getElementById('js-googlesitekit-main-dashboard');
  if (renderTarget) {
    const {
      setupModuleSlug,
      viewOnly
    } = renderTarget.dataset;
    let viewContext = _googlesitekit_constants__WEBPACK_IMPORTED_MODULE_2__.VIEW_CONTEXT_MODULE_SETUP;
    if (!setupModuleSlug) {
      viewContext = viewOnly ? _googlesitekit_constants__WEBPACK_IMPORTED_MODULE_2__.VIEW_CONTEXT_MAIN_DASHBOARD_VIEW_ONLY : _googlesitekit_constants__WEBPACK_IMPORTED_MODULE_2__.VIEW_CONTEXT_MAIN_DASHBOARD;
    }
    (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.render)(/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(_components_Root__WEBPACK_IMPORTED_MODULE_1__["default"], {
      viewContext: viewContext,
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(_components_DashboardEntryPoint__WEBPACK_IMPORTED_MODULE_3__["default"], {
        setupModuleSlug: setupModuleSlug
      })
    }), renderTarget);
  }
});

/***/ }),

/***/ "./js/googlesitekit/api/cache.js":
/*!***************************************!*\
  !*** ./js/googlesitekit/api/cache.js ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   STORAGE_KEY_PREFIX: () => (/* binding */ STORAGE_KEY_PREFIX),
/* harmony export */   STORAGE_KEY_PREFIX_ROOT: () => (/* binding */ STORAGE_KEY_PREFIX_ROOT),
/* harmony export */   clearCache: () => (/* binding */ clearCache),
/* harmony export */   deleteItem: () => (/* binding */ deleteItem),
/* harmony export */   getItem: () => (/* binding */ getItem),
/* harmony export */   getKeys: () => (/* binding */ getKeys),
/* harmony export */   getStorage: () => (/* binding */ getStorage),
/* harmony export */   isStorageAvailable: () => (/* binding */ isStorageAvailable),
/* harmony export */   resetDefaultStorageOrder: () => (/* binding */ resetDefaultStorageOrder),
/* harmony export */   setItem: () => (/* binding */ setItem),
/* harmony export */   setSelectedStorageBackend: () => (/* binding */ setSelectedStorageBackend),
/* harmony export */   setStorageOrder: () => (/* binding */ setStorageOrder)
/* harmony export */ });
/* harmony import */ var _js_util__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @/js/util */ "./js/util/index.js");
/**
 * Caching functions and cache management for API requests.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Internal dependencies
 */


/**
 * Prefix used for all Site Kit keys.
 *
 * Anything not using this prefix should not be touched by this library.
 *
 * @since 1.96.0
 * @private
 */
const STORAGE_KEY_PREFIX_ROOT = 'googlesitekit_';

/**
 * Prefix used for all Site Kit keys for the current Site Kit version.
 *
 * Anything not using this key should not be touched by this library.
 *
 * @since 1.5.0
 * @since 1.92.0 Updated to include a user, session, and blog-specific hash.
 * @since 1.96.0 Updated to make use of the new STORAGE_KEY_PREFIX_ROOT constant.
 * @private
 */
const STORAGE_KEY_PREFIX = `${STORAGE_KEY_PREFIX_ROOT}${"1.162.0"}_${__webpack_require__.g._googlesitekitBaseData.storagePrefix}_`;
const defaultOrder = ['sessionStorage', 'localStorage'];
let storageBackend;
let storageOrder = [...defaultOrder];

/**
 * Overrides the storage backend.
 *
 * Largely used for tests. Should not be used directly.
 *
 * @since 1.5.0
 * @private
 *
 * @param {*} backend Backend to set for the cache.
 */
function setSelectedStorageBackend(backend) {
  storageBackend = backend;
}

/**
 * Overrides the priority of storage mechanisms.
 *
 * Largely used for tests. Implicitly resets the selected storage backend,
 * causing `_getStorage` to re-run its checks for the best available
 * storage backend.
 *
 * @since 1.5.0
 * @private
 *
 * @param {Array} order Ordered array of storage backends to use.
 */
function setStorageOrder(order) {
  storageOrder = [...order];
  setSelectedStorageBackend(undefined);
}

/**
 * Resets the storage mechanism order.
 *
 * Largely used for tests. Implicitly resets the selected storage backend,
 * causing `_getStorage` to re-run its checks for the best available
 * storage backend.
 *
 * @since 1.5.0
 * @private
 */
function resetDefaultStorageOrder() {
  storageOrder = [...defaultOrder];
  setSelectedStorageBackend(undefined);
}

/**
 * Detects whether browser storage is both supported and available.
 *
 * @since 1.5.0
 * @private
 *
 * @param {string} type Browser storage to test. Should be one of `localStorage` or `sessionStorage`.
 * @return {boolean} True if the given storage is available, false otherwise.
 */
// eslint-disable-next-line require-await
async function isStorageAvailable(type) {
  const storage = __webpack_require__.g[type];
  if (!storage) {
    return false;
  }
  try {
    const x = '__storage_test__';
    storage.setItem(x, x);
    storage.removeItem(x);
    return true;
  } catch (e) {
    return e instanceof DOMException && (
    // everything except Firefox
    22 === e.code ||
    // Firefox
    1014 === e.code ||
    // test name field too, because code might not be present
    // everything except Firefox
    'QuotaExceededError' === e.name ||
    // Firefox
    'NS_ERROR_DOM_QUOTA_REACHED' === e.name) &&
    // acknowledge QuotaExceededError only if there's something already stored
    0 !== storage.length;
  }
}

/**
 * Gets the storage object to use.
 *
 * @since 1.5.0
 * @private
 *
 * @return {Storage|null} A storage mechanism (`localStorage` or `sessionStorage`) if available; otherwise returns `null`.
 */
async function getStorage() {
  if (storageBackend !== undefined) {
    return storageBackend;
  }

  // Only run the logic to determine the storage object once.
  for (const backend of storageOrder) {
    if (storageBackend) {
      continue;
    }
    if (await isStorageAvailable(backend)) {
      storageBackend = __webpack_require__.g[backend];
    }
  }
  if (storageBackend === undefined) {
    storageBackend = null;
  }
  return storageBackend;
}

/**
 * Gets cached data.
 *
 * Get cached data from the persistent storage cache.
 *
 * @since 1.5.0
 *
 * @param {string} key Name of cache key.
 * @return {Promise} A promise returned, containing an object with the cached value (if found) and whether or not there was a cache hit.
 */
async function getItem(key) {
  const storage = await getStorage();
  if (storage) {
    const cachedData = storage.getItem(`${STORAGE_KEY_PREFIX}${key}`);
    if (cachedData) {
      const parsedData = JSON.parse(cachedData);
      const {
        timestamp,
        ttl,
        value,
        isError
      } = parsedData;

      // Ensure a timestamp is found, otherwise this isn't a valid cache hit.
      // (We don't check for a truthy `value`, because it could be legitimately
      // false-y if `0`, `null`, etc.)
      if (timestamp && (!ttl ||
      // Ensure the cached data isn't too old.
      // The cache dates shouldn't rely on reference
      // dates for cache expiration. This is a case
      // where we actually want to rely on
      // the _actual_ date/time the data was set.
      Math.round(Date.now() / 1000) - timestamp < ttl) // eslint-disable-line sitekit/no-direct-date
      ) {
        return {
          cacheHit: true,
          value,
          isError
        };
      }
    }
  }
  return {
    cacheHit: false,
    value: undefined
  };
}

/**
 * Sets cached data using a key.
 *
 * Save data to the relevant local storage mechanism, if available.
 * By default, data is saved with a one hour (60 minute) TTL.
 *
 * @since 1.5.0
 *
 * @param {string}  key              Name of cache key.
 * @param {*}       value            Value to store in the cache.
 * @param {Object}  args             Optional object containing ttl, timestamp and isError keys.
 * @param {number}  [args.ttl]       Optional. Validity of the cached item in seconds.
 * @param {number}  [args.timestamp] Optional. Timestamp when the cached item was created.
 * @param {boolean} [args.isError]   Optional. Whether the cached item is an error.
 * @return {Promise} A promise: resolves to `true` if the value was saved; `false` if not (usually because no storage method was available).
 */
async function setItem(key, value, {
  ttl = _js_util__WEBPACK_IMPORTED_MODULE_0__.HOUR_IN_SECONDS,
  // Cached times should rely on real times, not the reference date,
  // so the cache timeouts are consistent even when changing
  // the reference dates when developing/testing.
  timestamp = Math.round(Date.now() / 1000),
  // eslint-disable-line sitekit/no-direct-date
  isError = false
} = {}) {
  const storage = await getStorage();
  if (storage) {
    try {
      storage.setItem(`${STORAGE_KEY_PREFIX}${key}`, JSON.stringify({
        timestamp,
        ttl,
        value,
        isError
      }));
      return true;
    } catch (error) {
      __webpack_require__.g.console.warn('Encountered an unexpected storage error:', error);
      return false;
    }
  }
  return false;
}

/**
 * Removes cached data by key.
 *
 * Remove one piece of cached data from the persistent storage cache, by key.
 *
 * @since 1.5.0
 *
 * @param {string} key Name of cache key.
 * @return {Promise} A promise: resolves to `true` if the value was deleted; `false` if not (usually because no storage method was available).
 */
async function deleteItem(key) {
  const storage = await getStorage();
  if (storage) {
    try {
      const fullKey = key.startsWith(STORAGE_KEY_PREFIX_ROOT) ? key : `${STORAGE_KEY_PREFIX}${key}`;
      storage.removeItem(fullKey);
      return true;
    } catch (error) {
      __webpack_require__.g.console.warn('Encountered an unexpected storage error:', error);
      return false;
    }
  }
  return false;
}

/**
 * Gets all cache keys created by Site Kit.
 *
 * @since 1.5.0
 *
 * @return {Promise} A promise: resolves to an array of all keys.
 */
async function getKeys() {
  const storage = await getStorage();
  if (storage) {
    try {
      const keys = [];
      for (let i = 0; i < storage.length; i++) {
        const itemKey = storage.key(i);
        if (itemKey.indexOf(STORAGE_KEY_PREFIX_ROOT) === 0) {
          keys.push(itemKey);
        }
      }
      return keys;
    } catch (error) {
      __webpack_require__.g.console.warn('Encountered an unexpected storage error:', error);
      return [];
    }
  }
  return [];
}

/**
 * Removes the entire cache created by Site Kit.
 *
 * @since 1.5.0
 *
 * @return {Promise} A promise: resolves to `true` if the cache was cleared; `false` if there was an error.
 */
async function clearCache() {
  const storage = await getStorage();
  if (storage) {
    const keys = await getKeys();
    for (const key of keys) {
      await deleteItem(key);
    }
    return true;
  }
  return false;
}

/***/ }),

/***/ "./js/googlesitekit/api/middleware/preloading.js":
/*!*******************************************************!*\
  !*** ./js/googlesitekit/api/middleware/preloading.js ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_api_fetch_build_middlewares_preloading__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/api-fetch/build/middlewares/preloading */ "../node_modules/@wordpress/api-fetch/build/middlewares/preloading.js");
/**
 * Custom preloading middleware.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies.
 */


/**
 * Creates a preloading middleware.
 *
 * Based on preloadMiddleware from from @wordpress/api-fetch, this middle is a single-use per-endpoint and provides cached
 * data for the first request only and any subsequent requests reach the server.
 *
 * @since 1.13.0
 *
 * @param {Object} preloadedData Preloaded data paths.
 * @return {Function} Function.
 */
function createPreloadingMiddleware(preloadedData) {
  const cache = Object.keys(preloadedData).reduce((result, path) => {
    result[(0,_wordpress_api_fetch_build_middlewares_preloading__WEBPACK_IMPORTED_MODULE_0__.getStablePath)(path)] = preloadedData[path];
    return result;
  }, {});
  let cacheHasExpired = false;
  return (options, next) => {
    if (cacheHasExpired) {
      return next(options);
    }
    setTimeout(() => {
      cacheHasExpired = true;
    }, 3000);
    const {
      parse = true
    } = options;
    const uri = options.path;
    if (typeof options.path === 'string') {
      const method = options.method?.toUpperCase() || 'GET';
      const path = (0,_wordpress_api_fetch_build_middlewares_preloading__WEBPACK_IMPORTED_MODULE_0__.getStablePath)(uri);
      if (parse && 'GET' === method && cache[path]) {
        const result = Promise.resolve(cache[path].body);
        delete cache[path];
        return result;
      } else if ('OPTIONS' === method && cache[method] && cache[method][path]) {
        const result = Promise.resolve(cache[method][path]);
        delete cache[method][path];
        return result;
      }
    }
    return next(options);
  };
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (createPreloadingMiddleware);

/***/ }),

/***/ "./js/googlesitekit/components-gm2/Button/MaybeTooltip.js":
/*!****************************************************************!*\
  !*** ./js/googlesitekit/components-gm2/Button/MaybeTooltip.js ***!
  \****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ MaybeTooltip)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _js_googlesitekit_components_gm2_Tooltip__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @/js/googlesitekit/components-gm2/Tooltip */ "./js/googlesitekit/components-gm2/Tooltip.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * MaybeTooltip component.
 *
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * Internal dependencies
 */


function MaybeTooltip({
  children,
  disabled = false,
  tooltip = false,
  tooltipTitle = null,
  hasIconOnly = false,
  tooltipEnterDelayInMS = 100
}) {
  if (!disabled && (tooltip && tooltipTitle || hasIconOnly && tooltipTitle)) {
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)(_js_googlesitekit_components_gm2_Tooltip__WEBPACK_IMPORTED_MODULE_0__["default"], {
      title: tooltipTitle,
      enterDelay: tooltipEnterDelayInMS,
      children: children
    });
  }
  return children;
}
MaybeTooltip.propTypes = {
  children: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().node).isRequired,
  disabled: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().bool),
  tooltip: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().bool),
  tooltipTitle: prop_types__WEBPACK_IMPORTED_MODULE_2___default().oneOfType([(prop_types__WEBPACK_IMPORTED_MODULE_2___default().string), (prop_types__WEBPACK_IMPORTED_MODULE_2___default().element)]),
  hasIconOnly: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().bool),
  tooltipEnterDelayInMS: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().number)
};

/***/ }),

/***/ "./js/googlesitekit/components-gm2/Button/SemanticButton.js":
/*!******************************************************************!*\
  !*** ./js/googlesitekit/components-gm2/Button/SemanticButton.js ***!
  \******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * SemanticButton component.
 *
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * WordPress dependencies
 */


const SemanticButton = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.forwardRef)(({
  children,
  href,
  text,
  className,
  danger,
  disabled,
  target,
  'aria-label': ariaLabel,
  inverse,
  tertiary,
  callout,
  calloutStyle,
  ...extraProps
}, ref) => {
  // Use a button if disabled, even if a href is provided to ensure expected behavior.
  const ButtonTag = href && !disabled ? 'a' : 'button';
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)(ButtonTag, {
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('mdc-button', className, {
      'mdc-button--raised': !text && !tertiary && !callout,
      'mdc-button--danger': danger,
      'mdc-button--inverse': inverse,
      'mdc-button--tertiary': tertiary,
      'mdc-button--callout': callout,
      'mdc-button--callout-primary': callout || calloutStyle === 'primary',
      'mdc-button--callout-warning': calloutStyle === 'warning',
      'mdc-button--callout-error': calloutStyle === 'error'
    }),
    href: disabled ? undefined : href,
    ref: ref,
    disabled: !!disabled,
    "aria-label": ariaLabel,
    target: target || '_self',
    role: 'a' === ButtonTag ? 'button' : undefined,
    ...extraProps,
    children: children
  });
});
SemanticButton.propTypes = {
  children: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().node),
  href: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  text: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().bool),
  className: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  danger: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().bool),
  disabled: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().bool),
  target: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  'aria-label': (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  inverse: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().bool),
  tertiary: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().bool),
  callout: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().bool),
  calloutStyle: prop_types__WEBPACK_IMPORTED_MODULE_3___default().oneOf(['primary', 'warning', 'error'])
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (SemanticButton);

/***/ }),

/***/ "./js/googlesitekit/components-gm2/Button/index.js":
/*!*********************************************************!*\
  !*** ./js/googlesitekit/components-gm2/Button/index.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var _react_hook_merged_ref__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @react-hook/merged-ref */ "../node_modules/@react-hook/merged-ref/dist/module/index.js");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _js_material_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/material-components */ "./js/material-components/index.js");
/* harmony import */ var _SemanticButton__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./SemanticButton */ "./js/googlesitekit/components-gm2/Button/SemanticButton.js");
/* harmony import */ var _MaybeTooltip__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./MaybeTooltip */ "./js/googlesitekit/components-gm2/Button/MaybeTooltip.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Button component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */




const Button = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_5__.forwardRef)(({
  children,
  href = null,
  text = false,
  className = '',
  danger = false,
  disabled = false,
  target,
  icon = null,
  trailingIcon = null,
  'aria-label': ariaLabel,
  title = null,
  customizedTooltip = null,
  tooltip = false,
  inverse = false,
  hideTooltipTitle = false,
  tooltipEnterDelayInMS = 100,
  tertiary = false,
  callout = false,
  calloutStyle = null,
  ...extraProps
}, ref) => {
  const buttonRef = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_5__.useCallback)(el => {
    if (el !== null) {
      _js_material_components__WEBPACK_IMPORTED_MODULE_1__.MDCRipple.attachTo(el);
    }
  }, []);
  const mergedRefs = (0,_react_hook_merged_ref__WEBPACK_IMPORTED_MODULE_6__["default"])(ref, buttonRef);
  function getAriaLabel() {
    let label = ariaLabel;
    if (target !== '_blank') {
      return label;
    }
    const newTabText = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__._x)('(opens in a new tab)', 'screen reader text', 'google-site-kit');
    if (typeof children === 'string') {
      label = label || children;
    }
    if (label) {
      return `${label} ${newTabText}`;
    }
    return newTabText;
  }
  const tooltipTitle = !hideTooltipTitle ? title || customizedTooltip || ariaLabel : null;
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(_MaybeTooltip__WEBPACK_IMPORTED_MODULE_3__["default"], {
    disabled: disabled,
    tooltip: tooltip,
    tooltipTitle: tooltipTitle,
    hasIconOnly: !!icon && children === undefined,
    tooltipEnterDelayInMS: tooltipEnterDelayInMS,
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsxs)(_SemanticButton__WEBPACK_IMPORTED_MODULE_2__["default"], {
      href: href,
      disabled: disabled,
      className: className,
      danger: danger,
      text: text,
      tertiary: tertiary,
      inverse: inverse,
      callout: callout,
      calloutStyle: calloutStyle,
      ref: mergedRefs,
      "aria-label": getAriaLabel(),
      target: target || '_self',
      ...extraProps,
      children: [icon, children && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("span", {
        className: "mdc-button__label",
        children: children
      }), trailingIcon]
    })
  });
});
Button.propTypes = {
  onClick: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().func),
  children: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().node),
  href: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().string),
  text: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().bool),
  className: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().string),
  danger: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().bool),
  disabled: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().bool),
  icon: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().element),
  trailingIcon: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().element),
  title: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().string),
  customizedTooltip: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().element),
  tooltip: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().bool),
  inverse: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().bool),
  hideTooltipTitle: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().bool),
  callout: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().bool),
  calloutStyle: prop_types__WEBPACK_IMPORTED_MODULE_7___default().oneOf(['primary', 'warning', 'error'])
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Button);

/***/ }),

/***/ "./js/googlesitekit/components-gm2/CircularProgress.js":
/*!*************************************************************!*\
  !*** ./js/googlesitekit/components-gm2/CircularProgress.js ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ CircularProgress)
/* harmony export */ });
/* harmony import */ var _material_ui_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @material-ui/core */ "../node_modules/@material-ui/core/esm/CircularProgress/CircularProgress.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * CircularProgress component.
 *
 * Site Kit by Google, Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


function CircularProgress(props) {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_material_ui_core__WEBPACK_IMPORTED_MODULE_1__["default"], {
    ...props
  });
}

/***/ }),

/***/ "./js/googlesitekit/components-gm2/SpinnerButton.js":
/*!**********************************************************!*\
  !*** ./js/googlesitekit/components-gm2/SpinnerButton.js ***!
  \**********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   SPINNER_POSITION: () => (/* binding */ SPINNER_POSITION),
/* harmony export */   "default": () => (/* binding */ SpinnerButton)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Button__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Button */ "./js/googlesitekit/components-gm2/Button/index.js");
/* harmony import */ var _CircularProgress__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./CircularProgress */ "./js/googlesitekit/components-gm2/CircularProgress.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Site Kit by Google, Copyright 2022 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * Internal dependencies
 */



const SPINNER_POSITION = {
  BEFORE: 'before',
  AFTER: 'after'
};
function SpinnerButton(props) {
  const {
    className,
    onClick = () => {},
    isSaving = false,
    spinnerPosition = SPINNER_POSITION.AFTER,
    ...restProps
  } = props;
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_Button__WEBPACK_IMPORTED_MODULE_1__["default"], {
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()(className, 'googlesitekit-button-icon--spinner', {
      'googlesitekit-button-icon--spinner__running': isSaving,
      'googlesitekit-button-icon--spinner__before': spinnerPosition === SPINNER_POSITION.BEFORE,
      'googlesitekit-button-icon--spinner__after': spinnerPosition === SPINNER_POSITION.AFTER
    }),
    icon: isSaving && spinnerPosition === SPINNER_POSITION.BEFORE ? /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_CircularProgress__WEBPACK_IMPORTED_MODULE_2__["default"], {
      size: 14
    }) : undefined,
    trailingIcon: isSaving && spinnerPosition === SPINNER_POSITION.AFTER ? /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_CircularProgress__WEBPACK_IMPORTED_MODULE_2__["default"], {
      size: 14
    }) : undefined,
    onClick: onClick,
    ...restProps
  });
}
SpinnerButton.propTypes = {
  className: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().string),
  onClick: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().func),
  isSaving: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().bool),
  spinnerPosition: prop_types__WEBPACK_IMPORTED_MODULE_4___default().oneOf(Object.values(SPINNER_POSITION))
};

/***/ }),

/***/ "./js/googlesitekit/components-gm2/Tooltip.js":
/*!****************************************************!*\
  !*** ./js/googlesitekit/components-gm2/Tooltip.js ***!
  \****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Tooltip)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _material_ui_core__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @material-ui/core */ "../node_modules/@material-ui/core/esm/Tooltip/Tooltip.js");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Tooltip component.
 *
 * Site Kit by Google, Copyright 2022 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */




/**
 * WordPress dependencies
 */


function Tooltip({
  children,
  popperClassName,
  tooltipClassName,
  onOpen,
  onClose,
  ...props
}) {
  const isOpen = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useRef)(false);
  const handleOpen = onOpen ? () => {
    // This fixes a bug where the `onOpen` callback is called when the tooltip is already open.
    if (isOpen.current) {
      return;
    }
    isOpen.current = true;
    onOpen?.();
  } : undefined;
  const handleClose = onOpen ? () => {
    isOpen.current = false;
    onClose?.();
  } : onClose;
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)(_material_ui_core__WEBPACK_IMPORTED_MODULE_3__["default"], {
    classes: {
      popper: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-tooltip-popper', popperClassName),
      tooltip: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-tooltip', tooltipClassName)
    },
    onOpen: handleOpen,
    onClose: handleClose,
    ...props,
    arrow: true,
    children: children
  });
}
Tooltip.propTypes = {
  children: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().node),
  popperClassName: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().string),
  tooltipClassName: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().string),
  onOpen: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().func),
  onClose: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().func)
};

/***/ }),

/***/ "./js/googlesitekit/constants.js":
/*!***************************************!*\
  !*** ./js/googlesitekit/constants.js ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ANCHOR_ID_CONTENT: () => (/* binding */ ANCHOR_ID_CONTENT),
/* harmony export */   ANCHOR_ID_KEY_METRICS: () => (/* binding */ ANCHOR_ID_KEY_METRICS),
/* harmony export */   ANCHOR_ID_MONETIZATION: () => (/* binding */ ANCHOR_ID_MONETIZATION),
/* harmony export */   ANCHOR_ID_SPEED: () => (/* binding */ ANCHOR_ID_SPEED),
/* harmony export */   ANCHOR_ID_TRAFFIC: () => (/* binding */ ANCHOR_ID_TRAFFIC),
/* harmony export */   SITE_KIT_VIEW_CONTEXTS: () => (/* binding */ SITE_KIT_VIEW_CONTEXTS),
/* harmony export */   SITE_KIT_VIEW_ONLY_CONTEXTS: () => (/* binding */ SITE_KIT_VIEW_ONLY_CONTEXTS),
/* harmony export */   VIEW_CONTEXT_ACTIVATION: () => (/* binding */ VIEW_CONTEXT_ACTIVATION),
/* harmony export */   VIEW_CONTEXT_ADMIN_BAR: () => (/* binding */ VIEW_CONTEXT_ADMIN_BAR),
/* harmony export */   VIEW_CONTEXT_ADMIN_BAR_VIEW_ONLY: () => (/* binding */ VIEW_CONTEXT_ADMIN_BAR_VIEW_ONLY),
/* harmony export */   VIEW_CONTEXT_AD_BLOCKING_RECOVERY: () => (/* binding */ VIEW_CONTEXT_AD_BLOCKING_RECOVERY),
/* harmony export */   VIEW_CONTEXT_ENTITY_DASHBOARD: () => (/* binding */ VIEW_CONTEXT_ENTITY_DASHBOARD),
/* harmony export */   VIEW_CONTEXT_ENTITY_DASHBOARD_VIEW_ONLY: () => (/* binding */ VIEW_CONTEXT_ENTITY_DASHBOARD_VIEW_ONLY),
/* harmony export */   VIEW_CONTEXT_MAIN_DASHBOARD: () => (/* binding */ VIEW_CONTEXT_MAIN_DASHBOARD),
/* harmony export */   VIEW_CONTEXT_MAIN_DASHBOARD_VIEW_ONLY: () => (/* binding */ VIEW_CONTEXT_MAIN_DASHBOARD_VIEW_ONLY),
/* harmony export */   VIEW_CONTEXT_METRIC_SELECTION: () => (/* binding */ VIEW_CONTEXT_METRIC_SELECTION),
/* harmony export */   VIEW_CONTEXT_MODULE: () => (/* binding */ VIEW_CONTEXT_MODULE),
/* harmony export */   VIEW_CONTEXT_MODULE_SETUP: () => (/* binding */ VIEW_CONTEXT_MODULE_SETUP),
/* harmony export */   VIEW_CONTEXT_POSTS_LIST: () => (/* binding */ VIEW_CONTEXT_POSTS_LIST),
/* harmony export */   VIEW_CONTEXT_SETTINGS: () => (/* binding */ VIEW_CONTEXT_SETTINGS),
/* harmony export */   VIEW_CONTEXT_SPLASH: () => (/* binding */ VIEW_CONTEXT_SPLASH),
/* harmony export */   VIEW_CONTEXT_USER_INPUT: () => (/* binding */ VIEW_CONTEXT_USER_INPUT),
/* harmony export */   VIEW_CONTEXT_WP_BLOCK_EDITOR: () => (/* binding */ VIEW_CONTEXT_WP_BLOCK_EDITOR),
/* harmony export */   VIEW_CONTEXT_WP_DASHBOARD: () => (/* binding */ VIEW_CONTEXT_WP_DASHBOARD),
/* harmony export */   VIEW_CONTEXT_WP_DASHBOARD_VIEW_ONLY: () => (/* binding */ VIEW_CONTEXT_WP_DASHBOARD_VIEW_ONLY)
/* harmony export */ });
/**
 * Core constants.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

const VIEW_CONTEXT_MAIN_DASHBOARD = 'mainDashboard';
const VIEW_CONTEXT_ENTITY_DASHBOARD = 'entityDashboard';
const VIEW_CONTEXT_MAIN_DASHBOARD_VIEW_ONLY = 'mainDashboardViewOnly';
const VIEW_CONTEXT_ENTITY_DASHBOARD_VIEW_ONLY = 'entityDashboardViewOnly';
const VIEW_CONTEXT_POSTS_LIST = 'postsList';
const VIEW_CONTEXT_USER_INPUT = 'userInput';
const VIEW_CONTEXT_ACTIVATION = 'activation';
const VIEW_CONTEXT_SPLASH = 'splash';
const VIEW_CONTEXT_ADMIN_BAR = 'adminBar';
const VIEW_CONTEXT_ADMIN_BAR_VIEW_ONLY = 'adminBarViewOnly';
const VIEW_CONTEXT_SETTINGS = 'settings';
const VIEW_CONTEXT_AD_BLOCKING_RECOVERY = 'adBlockingRecovery';
const VIEW_CONTEXT_MODULE = 'module';
const VIEW_CONTEXT_WP_DASHBOARD = 'wpDashboard';
const VIEW_CONTEXT_WP_DASHBOARD_VIEW_ONLY = 'wpDashboardViewOnly';
const VIEW_CONTEXT_MODULE_SETUP = 'moduleSetup';
const VIEW_CONTEXT_METRIC_SELECTION = 'metricSelection';
const VIEW_CONTEXT_WP_BLOCK_EDITOR = 'wpBlockEditor';

// Anchor ID Constants
const ANCHOR_ID_KEY_METRICS = 'key-metrics';
const ANCHOR_ID_TRAFFIC = 'traffic';
const ANCHOR_ID_CONTENT = 'content';
const ANCHOR_ID_SPEED = 'speed';
const ANCHOR_ID_MONETIZATION = 'monetization';

// Site Kit only view contexts
const SITE_KIT_VIEW_CONTEXTS = [VIEW_CONTEXT_MAIN_DASHBOARD, VIEW_CONTEXT_ENTITY_DASHBOARD, VIEW_CONTEXT_MAIN_DASHBOARD_VIEW_ONLY, VIEW_CONTEXT_ENTITY_DASHBOARD_VIEW_ONLY, VIEW_CONTEXT_USER_INPUT, VIEW_CONTEXT_SPLASH, VIEW_CONTEXT_SETTINGS, VIEW_CONTEXT_MODULE_SETUP, VIEW_CONTEXT_METRIC_SELECTION];

// Site Kit view-only contexts
const SITE_KIT_VIEW_ONLY_CONTEXTS = [VIEW_CONTEXT_MAIN_DASHBOARD_VIEW_ONLY, VIEW_CONTEXT_ENTITY_DASHBOARD_VIEW_ONLY, VIEW_CONTEXT_ADMIN_BAR_VIEW_ONLY, VIEW_CONTEXT_WP_DASHBOARD_VIEW_ONLY];

/***/ }),

/***/ "./js/googlesitekit/data/create-snapshot-store.js":
/*!********************************************************!*\
  !*** ./js/googlesitekit/data/create-snapshot-store.js ***!
  \********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   createSnapshotStore: () => (/* binding */ createSnapshotStore),
/* harmony export */   getStoresWithSnapshots: () => (/* binding */ getStoresWithSnapshots),
/* harmony export */   restoreAllSnapshots: () => (/* binding */ restoreAllSnapshots),
/* harmony export */   snapshotAllStores: () => (/* binding */ snapshotAllStores)
/* harmony export */ });
/* harmony import */ var invariant__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! invariant */ "../node_modules/invariant/browser.js");
/* harmony import */ var invariant__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(invariant__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _js_googlesitekit_api_cache__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/googlesitekit/api/cache */ "./js/googlesitekit/api/cache.js");
/* harmony import */ var _js_util__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/util */ "./js/util/index.js");
/**
 * Provides a datastore for snapshotting and restoring state.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * Internal dependencies
 */




// Actions
const CREATE_SNAPSHOT = 'CREATE_SNAPSHOT';
const DELETE_SNAPSHOT = 'DELETE_SNAPSHOT';
const RESTORE_SNAPSHOT = 'RESTORE_SNAPSHOT';
const SET_STATE_FROM_SNAPSHOT = 'SET_STATE_FROM_SNAPSHOT';

/**
 * Creates a store object that includes actions and controls for restoring/creating state snapshots.
 *
 * @since 1.9.0
 * @private
 *
 * @param {string} storeName The name of the store to snapshot in the cache.
 * @return {Object} The snapshot store object.
 */
function createSnapshotStore(storeName) {
  invariant__WEBPACK_IMPORTED_MODULE_0___default()(storeName, 'storeName is required to create a snapshot store.');
  const initialState = {};
  const actions = {
    /**
     * Deletes a snapshot of state for a storeName, using our cache API.
     *
     * @since 1.9.0
     * @private
     *
     * @return {boolean} Cache deletion response.
     */
    *deleteSnapshot() {
      const cacheResult = yield {
        payload: {},
        type: DELETE_SNAPSHOT
      };
      return cacheResult;
    },
    /**
     * Restores a snapshot of state for a storeName, if available, using our cache API.
     *
     * @since 1.9.0
     * @private
     *
     * @param {Object}  [options]                   Options object.
     * @param {boolean} [options.clearAfterRestore] Whether or not to delete snapshot after restore. Default: true.
     * @return {boolean} Cache restoration response.
     */
    *restoreSnapshot(options = {}) {
      const {
        clearAfterRestore = true
      } = options;
      const {
        cacheHit,
        value
      } = yield {
        payload: {},
        type: RESTORE_SNAPSHOT
      };
      if (cacheHit) {
        yield {
          payload: {
            snapshot: value
          },
          type: SET_STATE_FROM_SNAPSHOT
        };
        if (clearAfterRestore) {
          yield {
            payload: {},
            type: DELETE_SNAPSHOT
          };
        }
      }
      return cacheHit;
    },
    /**
     * Creates a snapshot of the current state of this store, using our cache API.
     *
     * @since 1.9.0
     * @private
     *
     * @return {boolean} Cache write response.
     */
    *createSnapshot() {
      const cacheResult = yield {
        payload: {},
        type: CREATE_SNAPSHOT
      };
      return cacheResult;
    }
  };
  const controls = {
    [DELETE_SNAPSHOT]: () => {
      return (0,_js_googlesitekit_api_cache__WEBPACK_IMPORTED_MODULE_2__.deleteItem)(`datastore::cache::${storeName}`);
    },
    [CREATE_SNAPSHOT]: (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.createRegistryControl)(registry => () => {
      return (0,_js_googlesitekit_api_cache__WEBPACK_IMPORTED_MODULE_2__.setItem)(`datastore::cache::${storeName}`, registry.stores[storeName].store.getState());
    }),
    [RESTORE_SNAPSHOT]: () => {
      // Only get snapshots made within the last hour.
      return (0,_js_googlesitekit_api_cache__WEBPACK_IMPORTED_MODULE_2__.getItem)(`datastore::cache::${storeName}`, _js_util__WEBPACK_IMPORTED_MODULE_3__.HOUR_IN_SECONDS);
    }
  };
  function reducer(state = initialState, {
    type,
    payload
  }) {
    // eslint-disable-line no-shadow
    switch (type) {
      case SET_STATE_FROM_SNAPSHOT:
        {
          const {
            snapshot
          } = payload;
          // Exclude any top-level errors from the restored state.
          // eslint-disable-next-line no-unused-vars
          const {
            error,
            ...newState
          } = snapshot;
          return newState;
        }
      default:
        {
          return state;
        }
    }
  }
  return {
    initialState,
    actions,
    controls,
    reducer
  };
}

/**
 * Inspects a registry to find all stores that support our snapshot features.
 *
 * @since 1.9.0
 * @private
 *
 * @param {wp.data.registry} registry Optional. Registry object to inspect for stores that support state restoration. Defaults to `googlesitekit.data`.
 * @return {Object} The snapshot store object.
 */
function getStoresWithSnapshots(registry = (googlesitekit_data__WEBPACK_IMPORTED_MODULE_1___default())) {
  return Object.values(registry.stores).filter(store => {
    return Object.keys(store.getActions()).includes('restoreSnapshot');
  });
}

/**
 * Creates snapshots of all supporting stores.
 *
 * @since 1.9.0
 * @private
 *
 * @param {wp.data.registry} [registry] Optional. Registry object to inspect for stores that support state restoration. Defaults to `googlesitekit.data`.
 * @return {Promise} Promise resolves once all snapshots have been taken.
 */
function snapshotAllStores(registry = (googlesitekit_data__WEBPACK_IMPORTED_MODULE_1___default())) {
  return Promise.all(getStoresWithSnapshots(registry).map(store => {
    return store.getActions().createSnapshot();
  }));
}

/**
 * Restores state for all snapshots that support it.
 *
 * Only restores snapshots for stores that have `restoreSnapshot` action, and
 * clears the snapshot afterward, so more stores will not be restored unless
 * a snapshot was saved on the last pageview.
 *
 * @since 1.9.0
 * @private
 *
 * @param {wp.data.registry} [registry] Optional. Registry object to inspect for stores that support state restoration. Defaults to `googlesitekit.data`.
 * @return {Promise} Promise resolves once all snapshots have been restored.
 */
function restoreAllSnapshots(registry = (googlesitekit_data__WEBPACK_IMPORTED_MODULE_1___default())) {
  return Promise.all(getStoresWithSnapshots(registry).map(store => {
    return store.getActions().restoreSnapshot();
  }));
}

/***/ }),

/***/ "./js/googlesitekit/data/transform-case.js":
/*!*************************************************!*\
  !*** ./js/googlesitekit/data/transform-case.js ***!
  \*************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   camelCaseToConstantCase: () => (/* binding */ camelCaseToConstantCase),
/* harmony export */   camelCaseToPascalCase: () => (/* binding */ camelCaseToPascalCase),
/* harmony export */   hyphenCaseToPascalCase: () => (/* binding */ hyphenCaseToPascalCase)
/* harmony export */ });
/**
 * Data store utilities for transforming names to a certain case.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Transforms a camelCase name into its PascalCase name.
 *
 * @since 1.10.0
 * @private
 *
 * @param {string} name "camelCase" name to transform.
 * @return {string} PascalCase name.
 */
function camelCaseToPascalCase(name) {
  return name.charAt(0).toUpperCase() + name.slice(1);
}

/**
 * Transforms a camelCase name into its CONSTANT_CASE name.
 *
 * @since 1.10.0
 * @private
 *
 * @param {string} name "camelCase" name to transform.
 * @return {string} CONSTANT_CASE name.
 */
function camelCaseToConstantCase(name) {
  return name.replace(/([a-z0-9]{1})([A-Z]{1})/g, '$1_$2').toUpperCase();
}

/**
 * Transforms a hyphen-case name into its PascalCase name.
 *
 * @since 1.30.0
 * @private
 *
 * @param {string} name "hyphen-case" name to transform.
 * @return {string} PascalCase name.
 */
function hyphenCaseToPascalCase(name) {
  return name.split('-').map(part => part.charAt(0).toUpperCase() + part.slice(1)).join('');
}

/***/ }),

/***/ "./js/googlesitekit/datastore/forms/constants.js":
/*!*******************************************************!*\
  !*** ./js/googlesitekit/datastore/forms/constants.js ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   CORE_FORMS: () => (/* binding */ CORE_FORMS)
/* harmony export */ });
/**
 * `core/forms` data store: constants.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

const CORE_FORMS = 'core/forms';

/***/ }),

/***/ "./js/googlesitekit/datastore/location/constants.js":
/*!**********************************************************!*\
  !*** ./js/googlesitekit/datastore/location/constants.js ***!
  \**********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   CORE_LOCATION: () => (/* binding */ CORE_LOCATION)
/* harmony export */ });
/**
 * `core/location` data store: constants.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

const CORE_LOCATION = 'core/location';

/***/ }),

/***/ "./js/googlesitekit/datastore/site/constants.js":
/*!******************************************************!*\
  !*** ./js/googlesitekit/datastore/site/constants.js ***!
  \******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   AMP_MODE_PRIMARY: () => (/* binding */ AMP_MODE_PRIMARY),
/* harmony export */   AMP_MODE_SECONDARY: () => (/* binding */ AMP_MODE_SECONDARY),
/* harmony export */   CORE_SITE: () => (/* binding */ CORE_SITE)
/* harmony export */ });
/**
 * `core/site` data store: constants.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

const CORE_SITE = 'core/site';
const AMP_MODE_PRIMARY = 'primary';
const AMP_MODE_SECONDARY = 'secondary';

/***/ }),

/***/ "./js/googlesitekit/datastore/ui/constants.js":
/*!****************************************************!*\
  !*** ./js/googlesitekit/datastore/ui/constants.js ***!
  \****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ACTIVE_CONTEXT_ID: () => (/* binding */ ACTIVE_CONTEXT_ID),
/* harmony export */   CORE_UI: () => (/* binding */ CORE_UI)
/* harmony export */ });
/**
 * `core/ui` data store: constants.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

const CORE_UI = 'core/ui';
const ACTIVE_CONTEXT_ID = 'activeContextID';

/***/ }),

/***/ "./js/googlesitekit/datastore/user/constants.js":
/*!******************************************************!*\
  !*** ./js/googlesitekit/datastore/user/constants.js ***!
  \******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   CORE_USER: () => (/* binding */ CORE_USER),
/* harmony export */   DISCONNECTED_REASON_CONNECTED_URL_MISMATCH: () => (/* binding */ DISCONNECTED_REASON_CONNECTED_URL_MISMATCH),
/* harmony export */   ERROR_CODE_ADBLOCKER_ACTIVE: () => (/* binding */ ERROR_CODE_ADBLOCKER_ACTIVE),
/* harmony export */   FORM_TEMPORARY_PERSIST_PERMISSION_ERROR: () => (/* binding */ FORM_TEMPORARY_PERSIST_PERMISSION_ERROR),
/* harmony export */   GLOBAL_SURVEYS_TIMEOUT_SLUG: () => (/* binding */ GLOBAL_SURVEYS_TIMEOUT_SLUG),
/* harmony export */   KM_ANALYTICS_ADSENSE_TOP_EARNING_CONTENT: () => (/* binding */ KM_ANALYTICS_ADSENSE_TOP_EARNING_CONTENT),
/* harmony export */   KM_ANALYTICS_ENGAGED_TRAFFIC_SOURCE: () => (/* binding */ KM_ANALYTICS_ENGAGED_TRAFFIC_SOURCE),
/* harmony export */   KM_ANALYTICS_LEAST_ENGAGING_PAGES: () => (/* binding */ KM_ANALYTICS_LEAST_ENGAGING_PAGES),
/* harmony export */   KM_ANALYTICS_MOST_ENGAGING_PAGES: () => (/* binding */ KM_ANALYTICS_MOST_ENGAGING_PAGES),
/* harmony export */   KM_ANALYTICS_NEW_VISITORS: () => (/* binding */ KM_ANALYTICS_NEW_VISITORS),
/* harmony export */   KM_ANALYTICS_PAGES_PER_VISIT: () => (/* binding */ KM_ANALYTICS_PAGES_PER_VISIT),
/* harmony export */   KM_ANALYTICS_POPULAR_AUTHORS: () => (/* binding */ KM_ANALYTICS_POPULAR_AUTHORS),
/* harmony export */   KM_ANALYTICS_POPULAR_CONTENT: () => (/* binding */ KM_ANALYTICS_POPULAR_CONTENT),
/* harmony export */   KM_ANALYTICS_POPULAR_PRODUCTS: () => (/* binding */ KM_ANALYTICS_POPULAR_PRODUCTS),
/* harmony export */   KM_ANALYTICS_RETURNING_VISITORS: () => (/* binding */ KM_ANALYTICS_RETURNING_VISITORS),
/* harmony export */   KM_ANALYTICS_TOP_CATEGORIES: () => (/* binding */ KM_ANALYTICS_TOP_CATEGORIES),
/* harmony export */   KM_ANALYTICS_TOP_CITIES: () => (/* binding */ KM_ANALYTICS_TOP_CITIES),
/* harmony export */   KM_ANALYTICS_TOP_CITIES_DRIVING_ADD_TO_CART: () => (/* binding */ KM_ANALYTICS_TOP_CITIES_DRIVING_ADD_TO_CART),
/* harmony export */   KM_ANALYTICS_TOP_CITIES_DRIVING_LEADS: () => (/* binding */ KM_ANALYTICS_TOP_CITIES_DRIVING_LEADS),
/* harmony export */   KM_ANALYTICS_TOP_CITIES_DRIVING_PURCHASES: () => (/* binding */ KM_ANALYTICS_TOP_CITIES_DRIVING_PURCHASES),
/* harmony export */   KM_ANALYTICS_TOP_CONVERTING_TRAFFIC_SOURCE: () => (/* binding */ KM_ANALYTICS_TOP_CONVERTING_TRAFFIC_SOURCE),
/* harmony export */   KM_ANALYTICS_TOP_COUNTRIES: () => (/* binding */ KM_ANALYTICS_TOP_COUNTRIES),
/* harmony export */   KM_ANALYTICS_TOP_DEVICE_DRIVING_PURCHASES: () => (/* binding */ KM_ANALYTICS_TOP_DEVICE_DRIVING_PURCHASES),
/* harmony export */   KM_ANALYTICS_TOP_PAGES_DRIVING_LEADS: () => (/* binding */ KM_ANALYTICS_TOP_PAGES_DRIVING_LEADS),
/* harmony export */   KM_ANALYTICS_TOP_RECENT_TRENDING_PAGES: () => (/* binding */ KM_ANALYTICS_TOP_RECENT_TRENDING_PAGES),
/* harmony export */   KM_ANALYTICS_TOP_RETURNING_VISITOR_PAGES: () => (/* binding */ KM_ANALYTICS_TOP_RETURNING_VISITOR_PAGES),
/* harmony export */   KM_ANALYTICS_TOP_TRAFFIC_SOURCE: () => (/* binding */ KM_ANALYTICS_TOP_TRAFFIC_SOURCE),
/* harmony export */   KM_ANALYTICS_TOP_TRAFFIC_SOURCE_DRIVING_ADD_TO_CART: () => (/* binding */ KM_ANALYTICS_TOP_TRAFFIC_SOURCE_DRIVING_ADD_TO_CART),
/* harmony export */   KM_ANALYTICS_TOP_TRAFFIC_SOURCE_DRIVING_LEADS: () => (/* binding */ KM_ANALYTICS_TOP_TRAFFIC_SOURCE_DRIVING_LEADS),
/* harmony export */   KM_ANALYTICS_TOP_TRAFFIC_SOURCE_DRIVING_PURCHASES: () => (/* binding */ KM_ANALYTICS_TOP_TRAFFIC_SOURCE_DRIVING_PURCHASES),
/* harmony export */   KM_ANALYTICS_VISITS_PER_VISITOR: () => (/* binding */ KM_ANALYTICS_VISITS_PER_VISITOR),
/* harmony export */   KM_ANALYTICS_VISIT_LENGTH: () => (/* binding */ KM_ANALYTICS_VISIT_LENGTH),
/* harmony export */   KM_SEARCH_CONSOLE_POPULAR_KEYWORDS: () => (/* binding */ KM_SEARCH_CONSOLE_POPULAR_KEYWORDS),
/* harmony export */   PERMISSION_AUTHENTICATE: () => (/* binding */ PERMISSION_AUTHENTICATE),
/* harmony export */   PERMISSION_DELEGATE_MODULE_SHARING_MANAGEMENT: () => (/* binding */ PERMISSION_DELEGATE_MODULE_SHARING_MANAGEMENT),
/* harmony export */   PERMISSION_MANAGE_MODULE_SHARING_OPTIONS: () => (/* binding */ PERMISSION_MANAGE_MODULE_SHARING_OPTIONS),
/* harmony export */   PERMISSION_MANAGE_OPTIONS: () => (/* binding */ PERMISSION_MANAGE_OPTIONS),
/* harmony export */   PERMISSION_READ_SHARED_MODULE_DATA: () => (/* binding */ PERMISSION_READ_SHARED_MODULE_DATA),
/* harmony export */   PERMISSION_SETUP: () => (/* binding */ PERMISSION_SETUP),
/* harmony export */   PERMISSION_UPDATE_PLUGINS: () => (/* binding */ PERMISSION_UPDATE_PLUGINS),
/* harmony export */   PERMISSION_VIEW_DASHBOARD: () => (/* binding */ PERMISSION_VIEW_DASHBOARD),
/* harmony export */   PERMISSION_VIEW_MODULE_DETAILS: () => (/* binding */ PERMISSION_VIEW_MODULE_DETAILS),
/* harmony export */   PERMISSION_VIEW_POSTS_INSIGHTS: () => (/* binding */ PERMISSION_VIEW_POSTS_INSIGHTS),
/* harmony export */   PERMISSION_VIEW_SHARED_DASHBOARD: () => (/* binding */ PERMISSION_VIEW_SHARED_DASHBOARD),
/* harmony export */   allKeyMetricsTileWidgets: () => (/* binding */ allKeyMetricsTileWidgets),
/* harmony export */   keyMetricsGA4Widgets: () => (/* binding */ keyMetricsGA4Widgets)
/* harmony export */ });
/**
 * `core/user` data store: constants.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

const CORE_USER = 'core/user';
const DISCONNECTED_REASON_CONNECTED_URL_MISMATCH = 'connected_url_mismatch';
const GLOBAL_SURVEYS_TIMEOUT_SLUG = '__global';
const FORM_TEMPORARY_PERSIST_PERMISSION_ERROR = 'temporary_persist_permission_error';
const ERROR_CODE_ADBLOCKER_ACTIVE = 'adblocker_active';

// Permissions list.
const PERMISSION_AUTHENTICATE = 'googlesitekit_authenticate';
const PERMISSION_SETUP = 'googlesitekit_setup';
const PERMISSION_VIEW_POSTS_INSIGHTS = 'googlesitekit_view_posts_insights';
const PERMISSION_VIEW_DASHBOARD = 'googlesitekit_view_dashboard';
const PERMISSION_VIEW_SHARED_DASHBOARD = 'googlesitekit_view_shared_dashboard';
const PERMISSION_VIEW_MODULE_DETAILS = 'googlesitekit_view_module_details';
const PERMISSION_MANAGE_OPTIONS = 'googlesitekit_manage_options';
const PERMISSION_READ_SHARED_MODULE_DATA = 'googlesitekit_read_shared_module_data';
const PERMISSION_MANAGE_MODULE_SHARING_OPTIONS = 'googlesitekit_manage_module_sharing_options';
const PERMISSION_DELEGATE_MODULE_SHARING_MANAGEMENT = 'googlesitekit_delegate_module_sharing_management';
const PERMISSION_UPDATE_PLUGINS = 'googlesitekit_update_plugins';

// Key Metrics Widgets
const KM_ANALYTICS_ADSENSE_TOP_EARNING_CONTENT = 'kmAnalyticsAdSenseTopEarningContent';
const KM_ANALYTICS_ENGAGED_TRAFFIC_SOURCE = 'kmAnalyticsEngagedTrafficSource';
const KM_ANALYTICS_LEAST_ENGAGING_PAGES = 'kmAnalyticsLeastEngagingPages';
const KM_ANALYTICS_NEW_VISITORS = 'kmAnalyticsNewVisitors';
const KM_ANALYTICS_POPULAR_AUTHORS = 'kmAnalyticsPopularAuthors';
const KM_ANALYTICS_POPULAR_CONTENT = 'kmAnalyticsPopularContent';
const KM_ANALYTICS_POPULAR_PRODUCTS = 'kmAnalyticsPopularProducts';
const KM_ANALYTICS_RETURNING_VISITORS = 'kmAnalyticsReturningVisitors';
const KM_ANALYTICS_TOP_CITIES = 'kmAnalyticsTopCities';
const KM_ANALYTICS_TOP_CITIES_DRIVING_LEADS = 'kmAnalyticsTopCitiesDrivingLeads';
const KM_ANALYTICS_TOP_CITIES_DRIVING_ADD_TO_CART = 'kmAnalyticsTopCitiesDrivingAddToCart';
const KM_ANALYTICS_TOP_CITIES_DRIVING_PURCHASES = 'kmAnalyticsTopCitiesDrivingPurchases';
const KM_ANALYTICS_TOP_DEVICE_DRIVING_PURCHASES = 'kmAnalyticsTopDeviceDrivingPurchases';
const KM_ANALYTICS_TOP_CONVERTING_TRAFFIC_SOURCE = 'kmAnalyticsTopConvertingTrafficSource';
const KM_ANALYTICS_TOP_COUNTRIES = 'kmAnalyticsTopCountries';
const KM_ANALYTICS_TOP_PAGES_DRIVING_LEADS = 'kmAnalyticsTopPagesDrivingLeads';
const KM_ANALYTICS_TOP_RECENT_TRENDING_PAGES = 'kmAnalyticsTopRecentTrendingPages';
const KM_ANALYTICS_TOP_TRAFFIC_SOURCE = 'kmAnalyticsTopTrafficSource';
const KM_ANALYTICS_TOP_TRAFFIC_SOURCE_DRIVING_ADD_TO_CART = 'kmAnalyticsTopTrafficSourceDrivingAddToCart';
const KM_ANALYTICS_TOP_TRAFFIC_SOURCE_DRIVING_LEADS = 'kmAnalyticsTopTrafficSourceDrivingLeads';
const KM_ANALYTICS_TOP_TRAFFIC_SOURCE_DRIVING_PURCHASES = 'kmAnalyticsTopTrafficSourceDrivingPurchases';
const KM_ANALYTICS_PAGES_PER_VISIT = 'kmAnalyticsPagesPerVisit';
const KM_ANALYTICS_VISIT_LENGTH = 'kmAnalyticsVisitLength';
const KM_ANALYTICS_TOP_RETURNING_VISITOR_PAGES = 'kmAnalyticsTopReturningVisitorPages';
const KM_SEARCH_CONSOLE_POPULAR_KEYWORDS = 'kmSearchConsolePopularKeywords';
const KM_ANALYTICS_VISITS_PER_VISITOR = 'kmAnalyticsVisitsPerVisitor';
const KM_ANALYTICS_MOST_ENGAGING_PAGES = 'kmAnalyticsMostEngagingPages';
const KM_ANALYTICS_TOP_CATEGORIES = 'kmAnalyticsTopCategories';
const keyMetricsGA4Widgets = [KM_ANALYTICS_ADSENSE_TOP_EARNING_CONTENT, KM_ANALYTICS_ENGAGED_TRAFFIC_SOURCE, KM_ANALYTICS_LEAST_ENGAGING_PAGES, KM_ANALYTICS_NEW_VISITORS, KM_ANALYTICS_POPULAR_AUTHORS, KM_ANALYTICS_POPULAR_CONTENT, KM_ANALYTICS_POPULAR_PRODUCTS, KM_ANALYTICS_RETURNING_VISITORS, KM_ANALYTICS_TOP_CATEGORIES, KM_ANALYTICS_TOP_CITIES, KM_ANALYTICS_TOP_CITIES_DRIVING_LEADS, KM_ANALYTICS_TOP_CITIES_DRIVING_ADD_TO_CART, KM_ANALYTICS_TOP_CITIES_DRIVING_PURCHASES, KM_ANALYTICS_TOP_DEVICE_DRIVING_PURCHASES, KM_ANALYTICS_TOP_CONVERTING_TRAFFIC_SOURCE, KM_ANALYTICS_TOP_COUNTRIES, KM_ANALYTICS_TOP_RECENT_TRENDING_PAGES, KM_ANALYTICS_TOP_TRAFFIC_SOURCE, KM_ANALYTICS_TOP_TRAFFIC_SOURCE_DRIVING_ADD_TO_CART, KM_ANALYTICS_PAGES_PER_VISIT, KM_ANALYTICS_VISIT_LENGTH, KM_ANALYTICS_TOP_RETURNING_VISITOR_PAGES, KM_ANALYTICS_VISITS_PER_VISITOR, KM_ANALYTICS_MOST_ENGAGING_PAGES, KM_ANALYTICS_TOP_CATEGORIES];
const allKeyMetricsTileWidgets = [...keyMetricsGA4Widgets, KM_SEARCH_CONSOLE_POPULAR_KEYWORDS];

/***/ }),

/***/ "./js/googlesitekit/modules/datastore/constants.js":
/*!*********************************************************!*\
  !*** ./js/googlesitekit/modules/datastore/constants.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   CORE_MODULES: () => (/* binding */ CORE_MODULES),
/* harmony export */   ERROR_CODE_INSUFFICIENT_MODULE_DEPENDENCIES: () => (/* binding */ ERROR_CODE_INSUFFICIENT_MODULE_DEPENDENCIES)
/* harmony export */ });
/**
 * `core/modules` data store: constants.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

const CORE_MODULES = 'core/modules';
const ERROR_CODE_INSUFFICIENT_MODULE_DEPENDENCIES = 'insufficient_module_dependencies';

/***/ }),

/***/ "./js/googlesitekit/notifications/components/Notification/ViewedStateObserver.js":
/*!***************************************************************************************!*\
  !*** ./js/googlesitekit/notifications/components/Notification/ViewedStateObserver.js ***!
  \***************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ ViewedStateObserver)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _js_googlesitekit_datastore_ui_constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/googlesitekit/datastore/ui/constants */ "./js/googlesitekit/datastore/ui/constants.js");
/* harmony import */ var _js_googlesitekit_notifications_datastore_constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/googlesitekit/notifications/datastore/constants */ "./js/googlesitekit/notifications/datastore/constants.js");
/* harmony import */ var _js_hooks_useLatestIntersection__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/hooks/useLatestIntersection */ "./js/hooks/useLatestIntersection.js");
/* harmony import */ var _js_googlesitekit_notifications_hooks_useHasBeenViewed__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/googlesitekit/notifications/hooks/useHasBeenViewed */ "./js/googlesitekit/notifications/hooks/useHasBeenViewed.js");
/**
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */





function ViewedStateObserver({
  id,
  observeRef,
  threshold
}) {
  const intersectionEntry = (0,_js_hooks_useLatestIntersection__WEBPACK_IMPORTED_MODULE_3__["default"])(observeRef, {
    threshold
  });
  const {
    setValue
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useDispatch)(_js_googlesitekit_datastore_ui_constants__WEBPACK_IMPORTED_MODULE_1__.CORE_UI);
  const {
    markNotificationSeen
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useDispatch)(_js_googlesitekit_notifications_datastore_constants__WEBPACK_IMPORTED_MODULE_2__.CORE_NOTIFICATIONS);
  const isInView = !!intersectionEntry?.isIntersecting;
  const viewed = (0,_js_googlesitekit_notifications_hooks_useHasBeenViewed__WEBPACK_IMPORTED_MODULE_4__.useHasBeenViewed)(id);
  const timeoutRef = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_5__.useRef)();
  function clearExistingTimeout() {
    if (timeoutRef.current) {
      clearTimeout(timeoutRef.current);
    }
  }
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_5__.useEffect)(() => {
    // If notification is not viewed yet and is in view, start the timer.
    if (!viewed && isInView) {
      clearExistingTimeout();

      // Set a new timeout for 3 seconds.
      timeoutRef.current = setTimeout(() => {
        // Only mark as viewed if still in view after 3 seconds.
        if (intersectionEntry?.isIntersecting) {
          setValue(_js_googlesitekit_notifications_hooks_useHasBeenViewed__WEBPACK_IMPORTED_MODULE_4__.useHasBeenViewed.getKey(id), true);
          markNotificationSeen(id);
        }
      }, 3000);
    } else if (!isInView && timeoutRef.current) {
      clearExistingTimeout();
    }

    // Cleanup function to clear timeout on unmount or when dependencies change.
    return () => {
      clearExistingTimeout();
    };
  }, [viewed, isInView, setValue, markNotificationSeen, id, intersectionEntry]);
  return null;
}
ViewedStateObserver.propTypes = {
  id: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().string),
  observeRef: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().object),
  threshold: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().number)
};

/***/ }),

/***/ "./js/googlesitekit/notifications/components/Notification/index.js":
/*!*************************************************************************!*\
  !*** ./js/googlesitekit/notifications/components/Notification/index.js ***!
  \*************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Notification)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _ViewedStateObserver__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./ViewedStateObserver */ "./js/googlesitekit/notifications/components/Notification/ViewedStateObserver.js");
/* harmony import */ var _js_googlesitekit_notifications_hooks_useHasBeenViewed__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/googlesitekit/notifications/hooks/useHasBeenViewed */ "./js/googlesitekit/notifications/hooks/useHasBeenViewed.js");
/* harmony import */ var _js_googlesitekit_notifications_hooks_useNotificationEvents__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/googlesitekit/notifications/hooks/useNotificationEvents */ "./js/googlesitekit/notifications/hooks/useNotificationEvents.js");
/* harmony import */ var _js_googlesitekit_notifications_datastore_constants__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/googlesitekit/notifications/datastore/constants */ "./js/googlesitekit/notifications/datastore/constants.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */






function Notification({
  id,
  className,
  gaTrackingEventArgs,
  children,
  onView
}) {
  const ref = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.useRef)();
  const viewed = (0,_js_googlesitekit_notifications_hooks_useHasBeenViewed__WEBPACK_IMPORTED_MODULE_2__.useHasBeenViewed)(id);
  const trackEvents = (0,_js_googlesitekit_notifications_hooks_useNotificationEvents__WEBPACK_IMPORTED_MODULE_3__["default"])(id, gaTrackingEventArgs?.category, {
    viewAction: gaTrackingEventArgs?.viewAction
  });
  const [isViewedOnce, setIsViewedOnce] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.useState)(false);
  const viewedDates = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useSelect)(select => select(_js_googlesitekit_notifications_datastore_constants__WEBPACK_IMPORTED_MODULE_4__.CORE_NOTIFICATIONS).getNotificationSeenDates(id));
  const {
    dismissNotification
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useDispatch)(_js_googlesitekit_notifications_datastore_constants__WEBPACK_IMPORTED_MODULE_4__.CORE_NOTIFICATIONS);

  // Track view once and check if notification should be dismissed.
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.useEffect)(() => {
    if (!isViewedOnce && viewed) {
      trackEvents.view(gaTrackingEventArgs?.label, gaTrackingEventArgs?.value);
      onView?.();
      setIsViewedOnce(true);
    }

    // If the notification has been viewed on 3 distinct days, dismiss it permanently for the next view.
    if (viewedDates?.length >= 3) {
      dismissNotification(id, {
        skipHidingFromQueue: true
      });
    }
  }, [viewed, trackEvents, isViewedOnce, gaTrackingEventArgs, onView, viewedDates, dismissNotification, id]);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)("section", {
    id: id,
    ref: ref,
    className: className,
    children: [children, !viewed && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_ViewedStateObserver__WEBPACK_IMPORTED_MODULE_1__["default"], {
      id: id,
      observeRef: ref,
      threshold: 0.5
    })]
  });
}
Notification.propTypes = {
  id: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().string),
  className: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().string),
  gaTrackingEventArgs: prop_types__WEBPACK_IMPORTED_MODULE_7___default().shape({
    category: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().string),
    viewAction: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().string),
    label: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().string),
    value: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().string)
  }),
  children: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().node),
  onView: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().func)
};

/***/ }),

/***/ "./js/googlesitekit/notifications/components/layout/BannerNotification.js":
/*!********************************************************************************!*\
  !*** ./js/googlesitekit/notifications/components/layout/BannerNotification.js ***!
  \********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   TYPES: () => (/* binding */ TYPES),
/* harmony export */   "default": () => (/* binding */ BannerNotification)
/* harmony export */ });
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_12___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_12__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _js_googlesitekit_notifications_datastore_constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/googlesitekit/notifications/datastore/constants */ "./js/googlesitekit/notifications/datastore/constants.js");
/* harmony import */ var _js_googlesitekit_notifications_hooks_useNotificationEvents__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/googlesitekit/notifications/hooks/useNotificationEvents */ "./js/googlesitekit/notifications/hooks/useNotificationEvents.js");
/* harmony import */ var _js_components_Banner__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/components/Banner */ "./js/components/Banner/index.js");
/* harmony import */ var _js_components_Banner_LearnMoreLink__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/components/Banner/LearnMoreLink */ "./js/components/Banner/LearnMoreLink.js");
/* harmony import */ var _js_components_Banner_CTAButton__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @/js/components/Banner/CTAButton */ "./js/components/Banner/CTAButton.js");
/* harmony import */ var _js_components_Banner_DismissButton__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @/js/components/Banner/DismissButton */ "./js/components/Banner/DismissButton.js");
/* harmony import */ var _js_material_components__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*!