"use strict";
(globalThis["__googlesitekit_webpackJsonp"] = globalThis["__googlesitekit_webpackJsonp"] || []).push([["googlesitekit-modules"],{

/***/ "./js/components/ChangeArrow.js":
/*!**************************************!*\
  !*** ./js/components/ChangeArrow.js ***!
  \**************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * External dependencies
 */



function ChangeArrow({
  direction,
  invertColor,
  width,
  height
}) {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("svg", {
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-change-arrow', `googlesitekit-change-arrow--${direction}`, {
      'googlesitekit-change-arrow--inverted-color': invertColor
    }),
    width: width,
    height: height,
    viewBox: "0 0 10 10",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg",
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("path", {
      d: "M5.625 10L5.625 2.375L9.125 5.875L10 5L5 -1.76555e-07L-2.7055e-07 5L0.875 5.875L4.375 2.375L4.375 10L5.625 10Z",
      fill: "currentColor"
    })
  });
}
ChangeArrow.propTypes = {
  direction: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().string),
  invertColor: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().bool),
  width: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().number),
  height: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().number)
};
ChangeArrow.defaultProps = {
  direction: 'up',
  invertColor: false,
  width: 9,
  height: 9
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ChangeArrow);

/***/ }),

/***/ "./js/components/IconWrapper.js":
/*!**************************************!*\
  !*** ./js/components/IconWrapper.js ***!
  \**************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ IconWrapper)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * IconWrapper component.
 *
 * Site Kit by Google, Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


function IconWrapper({
  children,
  marginLeft,
  marginRight
}) {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("span", {
    className: "googlesitekit-icon-wrapper",
    style: {
      marginLeft,
      marginRight
    },
    children: children
  });
}
IconWrapper.propTypes = {
  children: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().node).isRequired,
  marginLeft: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().number),
  marginRight: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().number)
};

/***/ }),

/***/ "./js/components/Link.js":
/*!*******************************!*\
  !*** ./js/components/Link.js ***!
  \*******************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_10__);
/* harmony import */ var react_router_dom__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! react-router-dom */ "../node_modules/react-router-dom/esm/react-router-dom.js");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _svg_icons_arrow_svg__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/svg/icons/arrow.svg */ "./svg/icons/arrow.svg");
/* harmony import */ var _svg_icons_arrow_inverse_svg__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/svg/icons/arrow-inverse.svg */ "./svg/icons/arrow-inverse.svg");
/* harmony import */ var _svg_icons_back_svg__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/svg/icons/back.svg */ "./svg/icons/back.svg");
/* harmony import */ var _svg_icons_external_svg__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/svg/icons/external.svg */ "./svg/icons/external.svg");
/* harmony import */ var _IconWrapper__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./IconWrapper */ "./js/components/IconWrapper.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Link component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */




/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */






const BUTTON = 'BUTTON';
const BUTTON_DISABLED = 'BUTTON_DISABLED';
const EXTERNAL_LINK = 'EXTERNAL_LINK';
const LINK = 'LINK';
const ROUTER_LINK = 'ROUTER_LINK';
const Link = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_8__.forwardRef)((props, ref) => {
  const {
    'aria-label': ariaLabelProp,
    secondary = false,
    arrow = false,
    back = false,
    caps = false,
    children,
    className = '',
    danger = false,
    disabled = false,
    external = false,
    hideExternalIndicator = false,
    href = '',
    inverse = false,
    noFlex = false,
    onClick,
    small = false,
    standalone = false,
    linkButton = false,
    to,
    leadingIcon,
    trailingIcon,
    ...otherProps
  } = props;
  function getType() {
    // Force button element if `onClick` prop is passed and there's no `href`
    // or `to` prop.
    if (!href && !to && onClick) {
      if (disabled) {
        return BUTTON_DISABLED;
      }
      return BUTTON;
    }

    // Only `RouterLink` uses the `to` prop.
    if (to) {
      return ROUTER_LINK;
    }

    // The external prop means this is an external link, which will also output
    // an `<a>` tag.
    if (external) {
      return EXTERNAL_LINK;
    }

    // A regular `<a>` tag without external indicators.
    return LINK;
  }
  const type = getType();
  function getLinkComponent() {
    if (type === BUTTON || type === BUTTON_DISABLED) {
      return 'button';
    }
    if (type === ROUTER_LINK) {
      return react_router_dom__WEBPACK_IMPORTED_MODULE_9__.Link;
    }
    return 'a';
  }
  function getAriaLabel() {
    // Otherwise, create an ARIA label if the link opens in a new window
    // or is disabled, to add extra context to the link.
    let labelSuffix;
    if (type === EXTERNAL_LINK) {
      labelSuffix = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__._x)('(opens in a new tab)', 'screen reader text', 'google-site-kit');
    }
    if (type === BUTTON_DISABLED) {
      labelSuffix = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__._x)('(disabled)', 'screen reader text', 'google-site-kit');
    }
    if (!labelSuffix) {
      return ariaLabelProp;
    }

    // If an ARIA label was supplied, use that.
    if (ariaLabelProp) {
      return `${ariaLabelProp} ${labelSuffix}`;
    }

    // Otherwise, use the children prop if it's a string.
    if (typeof children === 'string') {
      return `${children} ${labelSuffix}`;
    }

    // If there isn't a string we can use to create the label, we shouldn't
    // make one; otherwise we'll only create an ARIA label that says
    // "(opens in a new tab)", which is not good.
    return undefined;
  }
  const LinkComponent = getLinkComponent();
  const ariaLabel = getAriaLabel();

  // Set the prefix/suffix icons, based on the type of link this is and
  // the props supplied.
  let leadingIconToUse = leadingIcon;
  let trailingIconToUse = trailingIcon;
  if (back) {
    leadingIconToUse = /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_svg_icons_back_svg__WEBPACK_IMPORTED_MODULE_4__["default"], {
      width: 14,
      height: 14
    });
  }
  if (external && !hideExternalIndicator) {
    trailingIconToUse = /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_svg_icons_external_svg__WEBPACK_IMPORTED_MODULE_5__["default"], {
      width: 14,
      height: 14
    });
  }
  if (arrow && !inverse) {
    trailingIconToUse = /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_svg_icons_arrow_svg__WEBPACK_IMPORTED_MODULE_2__["default"], {
      width: 14,
      height: 14
    });
  }
  if (arrow && inverse) {
    trailingIconToUse = /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_svg_icons_arrow_inverse_svg__WEBPACK_IMPORTED_MODULE_3__["default"], {
      width: 14,
      height: 14
    });
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsxs)(LinkComponent, {
    "aria-label": ariaLabel,
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-cta-link', className, {
      'googlesitekit-cta-link--secondary': secondary,
      'googlesitekit-cta-link--inverse': inverse,
      'googlesitekit-cta-link--small': small,
      'googlesitekit-cta-link--caps': caps,
      'googlesitekit-cta-link--danger': danger,
      'googlesitekit-cta-link--disabled': disabled,
      'googlesitekit-cta-link--standalone': standalone,
      'googlesitekit-cta-link--link-button': linkButton,
      'googlesitekit-cta-link--no-flex': !!noFlex
    }),
    disabled: disabled,
    href: (type === LINK || type === EXTERNAL_LINK) && !disabled ? href : undefined,
    onClick: onClick,
    rel: type === EXTERNAL_LINK ? 'noopener noreferrer' : undefined,
    ref: ref,
    target: type === EXTERNAL_LINK ? '_blank' : undefined,
    to: to,
    ...otherProps,
    children: [!!leadingIconToUse && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_IconWrapper__WEBPACK_IMPORTED_MODULE_6__["default"], {
      marginRight: 5,
      children: leadingIconToUse
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)("span", {
      className: "googlesitekit-cta-link__contents",
      children: children
    }), !!trailingIconToUse && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_IconWrapper__WEBPACK_IMPORTED_MODULE_6__["default"], {
      marginLeft: 5,
      children: trailingIconToUse
    })]
  });
});
Link.propTypes = {
  arrow: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().bool),
  back: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().bool),
  caps: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().bool),
  children: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().node),
  className: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().string),
  danger: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().bool),
  disabled: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().bool),
  external: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().bool),
  hideExternalIndicator: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().bool),
  href: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().string),
  inverse: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().bool),
  leadingIcon: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().node),
  linkButton: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().bool),
  noFlex: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().bool),
  onClick: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().func),
  small: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().bool),
  standalone: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().bool),
  to: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().string),
  trailingIcon: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().node)
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Link);

/***/ }),

/***/ "./js/components/Notice/CTAButton.js":
/*!*******************************************!*\
  !*** ./js/components/Notice/CTAButton.js ***!
  \*******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ CTAButton)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! googlesitekit-components */ "googlesitekit-components");
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_components__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _svg_icons_external_svg__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/svg/icons/external.svg */ "./svg/icons/external.svg");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * Internal dependencies
 */



function CTAButton({
  label,
  disabled,
  inProgress,
  onClick,
  href,
  external,
  hideExternalIndicator
}) {
  let trailingIconToUse;
  if (external && !hideExternalIndicator) {
    trailingIconToUse = /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)(_svg_icons_external_svg__WEBPACK_IMPORTED_MODULE_1__["default"], {
      width: 14,
      height: 14
    });
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_0__.SpinnerButton, {
    className: "googlesitekit-notice__cta",
    disabled: disabled,
    isSaving: inProgress,
    onClick: onClick,
    href: href,
    target: external ? '_blank' : '_self',
    trailingIcon: trailingIconToUse,
    children: label
  });
}
CTAButton.propTypes = {
  label: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string).isRequired,
  disabled: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().bool),
  inProgress: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().bool),
  onClick: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().func),
  href: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  external: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().bool),
  hideExternalIndicator: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().bool)
};

/***/ }),

/***/ "./js/components/Notice/Description.js":
/*!*********************************************!*\
  !*** ./js/components/Notice/Description.js ***!
  \*********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Description)
/* harmony export */ });
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



function Description({
  className,
  children
}) {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("p", {
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-notice__description', className),
    children: children
  });
}
Description.propTypes = {
  className: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().string),
  children: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().node)
};

/***/ }),

/***/ "./js/components/Notice/DismissButton.js":
/*!***********************************************!*\
  !*** ./js/components/Notice/DismissButton.js ***!
  \***********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ DismissButton)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-components */ "googlesitekit-components");
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */


function DismissButton({
  label = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Got it', 'google-site-kit'),
  onClick,
  disabled
}) {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__.Button, {
    onClick: onClick,
    disabled: disabled,
    tertiary: true,
    children: label
  });
}
DismissButton.propTypes = {
  label: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  onClick: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().func).isRequired,
  disabled: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().bool)
};

/***/ }),

/***/ "./js/components/Notice/Icon.js":
/*!**************************************!*\
  !*** ./js/components/Notice/Icon.js ***!
  \**************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Icon)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _svg_icons_check_fill_svg__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @/svg/icons/check-fill.svg */ "./svg/icons/check-fill.svg");
/* harmony import */ var _svg_icons_warning_notice_svg__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/svg/icons/warning-notice.svg */ "./svg/icons/warning-notice.svg");
/* harmony import */ var _svg_icons_star_fill_svg__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/svg/icons/star-fill.svg */ "./svg/icons/star-fill.svg");
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./constants */ "./js/components/Notice/constants.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * Internal dependencies
 */





const typeIconMap = {
  [_constants__WEBPACK_IMPORTED_MODULE_3__.TYPES.NEW]: _svg_icons_star_fill_svg__WEBPACK_IMPORTED_MODULE_2__["default"],
  [_constants__WEBPACK_IMPORTED_MODULE_3__.TYPES.SUCCESS]: _svg_icons_check_fill_svg__WEBPACK_IMPORTED_MODULE_0__["default"],
  [_constants__WEBPACK_IMPORTED_MODULE_3__.TYPES.INFO]: _svg_icons_warning_notice_svg__WEBPACK_IMPORTED_MODULE_1__["default"],
  [_constants__WEBPACK_IMPORTED_MODULE_3__.TYPES.WARNING]: _svg_icons_warning_notice_svg__WEBPACK_IMPORTED_MODULE_1__["default"],
  [_constants__WEBPACK_IMPORTED_MODULE_3__.TYPES.ERROR]: _svg_icons_warning_notice_svg__WEBPACK_IMPORTED_MODULE_1__["default"]
};
function Icon({
  type
}) {
  const IconComponent = typeIconMap[type] || _svg_icons_warning_notice_svg__WEBPACK_IMPORTED_MODULE_1__["default"];
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(IconComponent, {
    width: 24,
    height: 24
  });
}
Icon.propTypes = {
  type: prop_types__WEBPACK_IMPORTED_MODULE_5___default().oneOf(Object.values(_constants__WEBPACK_IMPORTED_MODULE_3__.TYPES))
};

/***/ }),

/***/ "./js/components/Notice/Title.js":
/*!***************************************!*\
  !*** ./js/components/Notice/Title.js ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Title)
/* harmony export */ });
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



function Title({
  className,
  children
}) {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("p", {
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-notice__title', className),
    children: children
  });
}
Title.propTypes = {
  className: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().string),
  children: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().node)
};

/***/ }),

/***/ "./js/components/Notice/constants.js":
/*!*******************************************!*\
  !*** ./js/components/Notice/constants.js ***!
  \*******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   TYPES: () => (/* binding */ TYPES)
/* harmony export */ });
/**
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

const TYPES = {
  NEW: 'new',
  SUCCESS: 'success',
  WARNING: 'warning',
  INFO: 'info',
  ERROR: 'error'
};

/***/ }),

/***/ "./js/components/Notice/index.js":
/*!***************************************!*\
  !*** ./js/components/Notice/index.js ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _Icon__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Icon */ "./js/components/Notice/Icon.js");
/* harmony import */ var _Title__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./Title */ "./js/components/Notice/Title.js");
/* harmony import */ var _Description__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./Description */ "./js/components/Notice/Description.js");
/* harmony import */ var _CTAButton__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./CTAButton */ "./js/components/Notice/CTAButton.js");
/* harmony import */ var _DismissButton__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./DismissButton */ "./js/components/Notice/DismissButton.js");
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./constants */ "./js/components/Notice/constants.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */







const Notice = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_8__.forwardRef)(({
  className,
  title,
  description,
  dismissButton,
  ctaButton,
  type = _constants__WEBPACK_IMPORTED_MODULE_6__.TYPES.INFO,
  children,
  hideIcon
}, ref) => {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsxs)("div", {
    ref: ref,
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-notice', `googlesitekit-notice--${type}`, className),
    children: [!hideIcon && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)("div", {
      className: "googlesitekit-notice__icon",
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_Icon__WEBPACK_IMPORTED_MODULE_1__["default"], {
        type: type
      })
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsxs)("div", {
      className: "googlesitekit-notice__content",
      children: [title && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_Title__WEBPACK_IMPORTED_MODULE_2__["default"], {
        children: title
      }), description && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_Description__WEBPACK_IMPORTED_MODULE_3__["default"], {
        children: description
      })]
    }), (dismissButton?.label || dismissButton?.onClick || ctaButton?.label && (ctaButton?.onClick || ctaButton?.href) || children) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsxs)("div", {
      className: "googlesitekit-notice__action",
      children: [children, (dismissButton?.label || dismissButton?.onClick) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_DismissButton__WEBPACK_IMPORTED_MODULE_5__["default"], {
        label: dismissButton.label,
        onClick: dismissButton.onClick,
        disabled: dismissButton.disabled
      }), ctaButton?.label && (ctaButton?.onClick || ctaButton?.href) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_CTAButton__WEBPACK_IMPORTED_MODULE_4__["default"], {
        label: ctaButton.label,
        onClick: ctaButton.onClick,
        inProgress: ctaButton.inProgress,
        disabled: ctaButton.disabled,
        href: ctaButton.href,
        external: ctaButton.external,
        hideExternalIndicator: ctaButton.hideExternalIndicator
      })]
    })]
  });
});
Notice.TYPES = _constants__WEBPACK_IMPORTED_MODULE_6__.TYPES;
Notice.propTypes = {
  className: (prop_types__WEBPACK_IMPORTED_MODULE_9___default().string),
  title: prop_types__WEBPACK_IMPORTED_MODULE_9___default().oneOfType([(prop_types__WEBPACK_IMPORTED_MODULE_9___default().string), (prop_types__WEBPACK_IMPORTED_MODULE_9___default().object)]),
  description: (prop_types__WEBPACK_IMPORTED_MODULE_9___default().node),
  type: prop_types__WEBPACK_IMPORTED_MODULE_9___default().oneOf(Object.values(_constants__WEBPACK_IMPORTED_MODULE_6__.TYPES)),
  dismissButton: prop_types__WEBPACK_IMPORTED_MODULE_9___default().shape(_DismissButton__WEBPACK_IMPORTED_MODULE_5__["default"].propTypes),
  ctaButton: prop_types__WEBPACK_IMPORTED_MODULE_9___default().shape({
    ..._CTAButton__WEBPACK_IMPORTED_MODULE_4__["default"].propTypes,
    label: (prop_types__WEBPACK_IMPORTED_MODULE_9___default().string) // CTAButton label should not be required for this parent component.
  }),
  children: (prop_types__WEBPACK_IMPORTED_MODULE_9___default().node),
  hideIcon: (prop_types__WEBPACK_IMPORTED_MODULE_9___default().bool)
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Notice);

/***/ }),

/***/ "./js/components/notifications/AdBlockerWarning.js":
/*!*********************************************************!*\
  !*** ./js/components/notifications/AdBlockerWarning.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ AdBlockerWarning)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/googlesitekit/datastore/site/constants */ "./js/googlesitekit/datastore/site/constants.js");
/* harmony import */ var _js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/googlesitekit/modules/datastore/constants */ "./js/googlesitekit/modules/datastore/constants.js");
/* harmony import */ var _AdBlockerWarningMessage__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./AdBlockerWarningMessage */ "./js/components/notifications/AdBlockerWarningMessage.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * AdSense AdBlockerWarning component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * Internal dependencies
 */





function AdBlockerWarning({
  moduleSlug,
  className
}) {
  const storeName = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useSelect)(select => select(_js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_2__.CORE_MODULES).getModuleStoreName(moduleSlug));
  const adBlockerWarningMessage = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useSelect)(select => select(storeName)?.getAdBlockerWarningMessage());
  const getHelpLink = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useSelect)(select => select(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_1__.CORE_SITE).getDocumentationLinkURL(`${moduleSlug}-ad-blocker-detected`));
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(_AdBlockerWarningMessage__WEBPACK_IMPORTED_MODULE_3__["default"], {
    className: className,
    getHelpLink: getHelpLink,
    warningMessage: adBlockerWarningMessage
  });
}
AdBlockerWarning.propTypes = {
  className: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().string),
  moduleSlug: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().string).isRequired
};

/***/ }),

/***/ "./js/components/notifications/AdBlockerWarningMessage.js":
/*!****************************************************************!*\
  !*** ./js/components/notifications/AdBlockerWarningMessage.js ***!
  \****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ AdBlockerWarningMessage)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/@wordpress/element/build-module/create-interpolate-element.js");
/* harmony import */ var _js_components_Link__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/components/Link */ "./js/components/Link.js");
/* harmony import */ var _svg_icons_external_rounded_svg__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/svg/icons/external-rounded.svg */ "./svg/icons/external-rounded.svg");
/* harmony import */ var _js_components_Notice__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/components/Notice */ "./js/components/Notice/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * AdBlockerWarningMessage component.
 *
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */




function AdBlockerWarningMessage({
  getHelpLink = '',
  warningMessage = null
}) {
  if (!warningMessage) {
    return null;
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(_js_components_Notice__WEBPACK_IMPORTED_MODULE_3__["default"], {
    className: "googlesitekit-notice--small",
    type: _js_components_Notice__WEBPACK_IMPORTED_MODULE_3__["default"].TYPES.WARNING,
    description: (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_5__["default"])((0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.sprintf)(/* translators: 1: The warning message. 2: "Get help" text. */
    (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('%1$s. <Link><Strong>%2$s</Strong></Link>', 'google-site-kit'), warningMessage, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Get help', 'google-site-kit')), {
      Link: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(_js_components_Link__WEBPACK_IMPORTED_MODULE_1__["default"], {
        href: getHelpLink,
        trailingIcon: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(_svg_icons_external_rounded_svg__WEBPACK_IMPORTED_MODULE_2__["default"], {
          width: 15,
          height: 15
        }),
        external: true,
        hideExternalIndicator: true
      }),
      Strong: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("strong", {})
    }),
    hideIcon: true
  });
}
AdBlockerWarningMessage.propTypes = {
  getHelpLink: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().string),
  warningMessage: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().string)
};

/***/ }),

/***/ "./js/components/notifications/ModuleSettingsWarning.js":
/*!**************************************************************!*\
  !*** ./js/components/notifications/ModuleSettingsWarning.js ***!
  \**************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ ModuleSettingsWarning)
/* harmony export */ });
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/googlesitekit/modules/datastore/constants */ "./js/googlesitekit/modules/datastore/constants.js");
/* harmony import */ var _js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/googlesitekit/datastore/user/constants */ "./js/googlesitekit/datastore/user/constants.js");
/* harmony import */ var _AdBlockerWarning__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./AdBlockerWarning */ "./js/components/notifications/AdBlockerWarning.js");
/* harmony import */ var _js_components_Notice__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/components/Notice */ "./js/components/Notice/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * ModuleSettingsWarning component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Internal dependencies
 */






function ModuleSettingsWarning({
  slug
}) {
  const error = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useSelect)(select => select(_js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_1__.CORE_MODULES)?.getCheckRequirementsError(slug));
  if (!error) {
    return null;
  }

  // The AdBlockerWarning component also renders the "Get help"
  // documentation URL in addition to the error message.
  if (_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_2__.ERROR_CODE_ADBLOCKER_ACTIVE === error.code) {
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_AdBlockerWarning__WEBPACK_IMPORTED_MODULE_3__["default"], {
      moduleSlug: slug
    });
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_js_components_Notice__WEBPACK_IMPORTED_MODULE_4__["default"], {
    className: "googlesitekit-notice--small",
    type: _js_components_Notice__WEBPACK_IMPORTED_MODULE_4__["default"].TYPES.WARNING,
    description: error.message,
    hideIcon: true
  });
}

/***/ }),

/***/ "./js/components/settings/DefaultSettingsSetupIncomplete.js":
/*!******************************************************************!*\
  !*** ./js/components/settings/DefaultSettingsSetupIncomplete.js ***!
  \******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ DefaultSettingsSetupIncomplete)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/@wordpress/element/build-module/create-interpolate-element.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _js_components_Link__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/components/Link */ "./js/components/Link.js");
/* harmony import */ var _js_components_notifications_ModuleSettingsWarning_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/components/notifications/ModuleSettingsWarning.js */ "./js/components/notifications/ModuleSettingsWarning.js");
/* harmony import */ var _js_material_components_layout__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/material-components/layout */ "./js/material-components/layout/index.js");
/* harmony import */ var _js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/googlesitekit/modules/datastore/constants */ "./js/googlesitekit/modules/datastore/constants.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * DefaultSettingsSetupIncomplete component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */






function DefaultSettingsSetupIncomplete({
  slug
}) {
  const storeName = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_5__.CORE_MODULES).getModuleStoreName(slug));
  const adminReauthURL = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(storeName)?.getAdminReauthURL?.());
  const requirementsError = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_5__.CORE_MODULES)?.getCheckRequirementsError(slug));
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)(_js_material_components_layout__WEBPACK_IMPORTED_MODULE_4__.Cell, {
    size: 12,
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("div", {
      className: "googlesitekit-settings-module__fields-group googlesitekit-settings-module__fields-group--no-border",
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(_js_components_notifications_ModuleSettingsWarning_js__WEBPACK_IMPORTED_MODULE_3__["default"], {
        slug: slug
      })
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("div", {
      className: "googlesitekit-settings-module__fields-group-title",
      children: (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_7__["default"])((0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Setup incomplete: <a>continue module setup</a>', 'google-site-kit'), {
        a: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(_js_components_Link__WEBPACK_IMPORTED_MODULE_2__["default"], {
          className: "googlesitekit-settings-module__edit-button",
          href: adminReauthURL,
          disabled: requirementsError ? true : false
        })
      })
    })]
  });
}
DefaultSettingsSetupIncomplete.propTypes = {
  slug: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().string).isRequired
};

/***/ }),

/***/ "./js/features/index.js":
/*!******************************!*\
  !*** ./js/features/index.js ***!
  \******************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   enabledFeatures: () => (/* binding */ enabledFeatures),
/* harmony export */   isFeatureEnabled: () => (/* binding */ isFeatureEnabled)
/* harmony export */ });
/**
 * Feature flags.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

const enabledFeatures = new Set(__webpack_require__.g?._googlesitekitBaseData?.enabledFeatures || []);

/**
 * Returns true if a feature is enabled; false otherwise.
 *
 * @since 1.25.0
 * @since 1.33.0 Changed _enabledFeatures argument to be a `Set` instead of `Array`.
 *
 * @param {string} feature            The name of the feature to check.
 * @param {Set}    [_enabledFeatures] Optional. The set of enabled features. Uses `enabledFeatures` set by the server in a global JS variable, by default.
 * @return {boolean} `true` if a feature is enabled; `false` otherwise.
 */
function isFeatureEnabled(feature, _enabledFeatures = enabledFeatures) {
  if (!(_enabledFeatures instanceof Set)) {
    return false;
  }
  return _enabledFeatures.has(feature);
}

/***/ }),

/***/ "./js/googlesitekit-modules.js":
/*!*************************************!*\
  !*** ./js/googlesitekit-modules.js ***!
  \*************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _googlesitekit_modules__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./googlesitekit/modules */ "./js/googlesitekit/modules/index.js");
/**
 * Modules API.
 *
 * Provides API functions to manage modules.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Internal dependencies
 */


(0,_googlesitekit_modules__WEBPACK_IMPORTED_MODULE_1__.registerStore)((googlesitekit_data__WEBPACK_IMPORTED_MODULE_0___default()));
const Modules = (0,_googlesitekit_modules__WEBPACK_IMPORTED_MODULE_1__.createModules)((googlesitekit_data__WEBPACK_IMPORTED_MODULE_0___default()));
if (typeof __webpack_require__.g.googlesitekit === 'undefined') {
  __webpack_require__.g.googlesitekit = {};
}
__webpack_require__.g.googlesitekit.modules = Modules;
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Modules);

/***/ }),

/***/ "./js/googlesitekit/data/create-error-store.js":
/*!*****************************************************!*\
  !*** ./js/googlesitekit/data/create-error-store.js ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   actions: () => (/* binding */ actions),
/* harmony export */   createErrorStore: () => (/* binding */ createErrorStore),
/* harmony export */   generateErrorKey: () => (/* binding */ generateErrorKey)
/* harmony export */ });
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @wordpress/data */ "../node_modules/@wordpress/data/build-module/factory.js");
/* harmony import */ var invariant__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! invariant */ "../node_modules/invariant/browser.js");
/* harmony import */ var invariant__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(invariant__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var md5__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! md5 */ "../node_modules/md5/md5.js");
/* harmony import */ var md5__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(md5__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _js_util__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/util */ "./js/util/index.js");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__);
/**
 * API function to create fetch store.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */


/**
 * External dependencies
 */


const RECEIVE_ERROR = 'RECEIVE_ERROR';
const CLEAR_ERROR = 'CLEAR_ERROR';
const CLEAR_ERRORS = 'CLEAR_ERRORS';

/**
 * Internal dependencies
 */


function generateErrorKey(baseName, args) {
  if (args && Array.isArray(args)) {
    const stringifiedArgs = args.map(item => {
      return 'object' === typeof item ? (0,_js_util__WEBPACK_IMPORTED_MODULE_2__.stringifyObject)(item) : item;
    });
    return `${baseName}::${md5__WEBPACK_IMPORTED_MODULE_1___default()(JSON.stringify(stringifiedArgs))}`;
  }
  return baseName;
}
const actions = {
  receiveError(error, baseName, args = []) {
    invariant__WEBPACK_IMPORTED_MODULE_0___default()(error, 'error is required.');
    invariant__WEBPACK_IMPORTED_MODULE_0___default()(baseName, 'baseName is required.');
    invariant__WEBPACK_IMPORTED_MODULE_0___default()(args && Array.isArray(args), 'args must be an array.');
    return {
      type: RECEIVE_ERROR,
      payload: {
        error,
        baseName,
        args
      }
    };
  },
  clearError(baseName, args = []) {
    invariant__WEBPACK_IMPORTED_MODULE_0___default()(baseName, 'baseName is required.');
    invariant__WEBPACK_IMPORTED_MODULE_0___default()(args && Array.isArray(args), 'args must be an array.');
    return {
      type: CLEAR_ERROR,
      payload: {
        baseName,
        args
      }
    };
  },
  clearErrors(baseName) {
    return {
      type: CLEAR_ERRORS,
      payload: {
        baseName
      }
    };
  }
};
function createErrorStore(storeName) {
  invariant__WEBPACK_IMPORTED_MODULE_0___default()(storeName, 'storeName must be defined.');
  const initialState = {
    errors: {},
    errorArgs: {}
  };
  const reducer = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__.createReducer)((state, {
    type,
    payload
  }) => {
    switch (type) {
      case RECEIVE_ERROR:
        {
          const {
            baseName,
            args,
            error
          } = payload;
          const key = generateErrorKey(baseName, args);
          state.errors = state.errors || {};
          state.errorArgs = state.errorArgs || {};
          state.errors[key] = error;
          state.errorArgs[key] = args;
          break;
        }
      case CLEAR_ERROR:
        {
          const {
            baseName,
            args
          } = payload;
          const key = generateErrorKey(baseName, args);
          state.errors = state.errors || {};
          state.errorArgs = state.errorArgs || {};
          delete state.errors[key];
          delete state.errorArgs[key];
          break;
        }
      case CLEAR_ERRORS:
        {
          const {
            baseName
          } = payload;
          if (baseName) {
            state.errors = state.errors || {};
            state.errorArgs = state.errorArgs || {};
            for (const key in state.errors) {
              if (key === baseName || key.startsWith(`${baseName}::`)) {
                delete state.errors[key];
                delete state.errorArgs[key];
              }
            }
          } else {
            state.errors = {};
            state.errorArgs = {};
          }
          break;
        }
    }
  });
  const controls = {};
  const resolvers = {};
  const selectors = {
    /**
     * Retrieves the error object from state.
     *
     * Error object has the format:
     *
     * ```
     * {
     *   code: <String>,
     *   message: <String>,
     *   data: <Object>
     * }
     * ```
     *
     * @since 1.15.0
     *
     * @param {Object}      state        Data store's state.
     * @param {string}      selectorName Selector name.
     * @param {Array.<any>} [args]       Arguments passed to selector (default `[]`).
     * @return {(Object|undefined)} Error object if exists, otherwise undefined.
     */
    getErrorForSelector(state, selectorName, args = []) {
      invariant__WEBPACK_IMPORTED_MODULE_0___default()(selectorName, 'selectorName is required.');
      return selectors.getError(state, selectorName, args);
    },
    /**
     * Retrieves the error object from state.
     *
     *```
     * {
     *   code: <String>,
     *   message: <String>,
     *   data: <Object>
     * }
     * ```
     *
     * @since 1.15.0
     *
     * @param {Object}      state      Data store's state.
     * @param {string}      actionName Action name.
     * @param {Array.<any>} [args]     Arguments passed to action (default `[]`).
     * @return {(Object|undefined)} Error object if exists, otherwise undefined.
     */
    getErrorForAction(state, actionName, args = []) {
      invariant__WEBPACK_IMPORTED_MODULE_0___default()(actionName, 'actionName is required.');
      return selectors.getError(state, actionName, args);
    },
    /**
     * Retrieves the error object from state.
     *
     *```
     * {
     *   code: <String>,
     *   message: <String>,
     *   data: <Object>
     * }
     * ```
     *
     * @since 1.15.0
     * @private
     *
     * @param {Object}      state      Data store's state.
     * @param {string}      [baseName] Selector or action name.
     * @param {Array.<any>} [args]     Arguments array.
     * @return {(Object|undefined)} Error object if exists, otherwise undefined.
     */
    getError(state, baseName, args) {
      const {
        errors
      } = state;
      invariant__WEBPACK_IMPORTED_MODULE_0___default()(baseName, 'baseName is required.');
      return errors[generateErrorKey(baseName, args)];
    },
    /**
     * Gets a list of all unique errors.
     *
     * @since 1.19.0
     *
     * @param {Object} state Data store's state.
     * @return {Object[]} Unique set of errors.
     */
    getErrors(state) {
      const errorsSet = new Set(Object.values(state.errors));
      return Array.from(errorsSet);
    },
    /**
     * Gets the meta-data for a given error object, or null if the error is not found.
     *
     * Returns meta-data in the format:
     *
     * ```
     *	{
     *		baseName: <string>,
     *		args: <Array>
     *	}
     * ```
     *
     * @since 1.84.0
     *
     * @param {Object} state Data store's state.
     * @param {Object} error Error object.
     * @return {Object|null} Meta-data for the given error object, or null if the error is not found.
     */
    getMetaDataForError(state, error) {
      const key = Object.keys(state.errors).find(errorKey => state.errors[errorKey] === error);
      if (key) {
        const baseName = key.substring(0, key.indexOf('::'));
        return {
          baseName,
          args: state.errorArgs[key]
        };
      }
      return null;
    },
    /**
     * Gets the selector data for a given error object, or null if no selector data is available.
     *
     * Returns selector data in the format:
     *
     * ```
     *	{
     *		storeName: <string>,
     *		name: <string>,
     *		args: <Array>
     *	}
     * ```
     *
     * @since 1.87.0
     *
     * @param {Object} state Data store's state.
     * @param {Object} error Error object.
     * @return {Object|null} Selector data for the given error object, or null if no selector data is available.
     */
    getSelectorDataForError: (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_4__.createRegistrySelector)(select => function (state, error) {
      const metaData = select(storeName).getMetaDataForError(error);
      if (metaData) {
        const {
          baseName: name,
          args
        } = metaData;
        const isSelector = !!select(storeName)[name];
        if (isSelector) {
          return {
            storeName,
            name,
            args
          };
        }
      }
      return null;
    }),
    /**
     * Determines whether the datastore has errors or not.
     *
     * @since 1.15.0
     *
     * @param {Object} state Data store's state.
     * @return {boolean} TRUE if the datastore has errors, otherwise FALSE.
     */
    hasErrors(state) {
      return selectors.getErrors(state).length > 0;
    }
  };
  return {
    initialState,
    actions,
    controls,
    reducer,
    resolvers,
    selectors
  };
}

/***/ }),

/***/ "./js/googlesitekit/data/create-fetch-store.js":
/*!*****************************************************!*\
  !*** ./js/googlesitekit/data/create-fetch-store.js ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   createFetchStore: () => (/* binding */ createFetchStore)
/* harmony export */ });
/* harmony import */ var invariant__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! invariant */ "../node_modules/invariant/browser.js");
/* harmony import */ var invariant__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(invariant__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! lodash */ "../node_modules/lodash/lodash.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _create_error_store__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./create-error-store */ "./js/googlesitekit/data/create-error-store.js");
/* harmony import */ var _transform_case__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./transform-case */ "./js/googlesitekit/data/transform-case.js");
/* harmony import */ var _js_util__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/util */ "./js/util/index.js");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_5__);
/**
 * API function to create fetch store.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * Internal dependencies
 */




function defaultReducerCallback(state) {
  return state;
}
function defaultArgsToParams() {
  return {};
}
function defaultValidateParams() {}

// Get access to error store action creators.
// If the parent store doesn't include the error store,
// yielded error actions will be a no-op.
const {
  clearError,
  receiveError
} = _create_error_store__WEBPACK_IMPORTED_MODULE_2__.actions;

/**
 * Creates a store object implementing the necessary infrastructure for a
 * single fetch action.
 *
 * This function returns a partial store object with the following:
 * * action creators to fetch and to receive the data
 * * control to issue the API request
 * * reducer to set API request flag and receive the response
 * * selector to check whether the API request is in progress via a flag
 *
 * The names of the pieces are based on the baseName provided.
 * For example, if baseName is 'saveSettings':
 * * The fetch action creator is called 'fetchSaveSettings'.
 * * The receive action creator is called 'receiveSaveSettings'.
 * * The fetching selector is called 'isFetchingSaveSettings'.
 *
 * All parts of the returned store objects should be considered internal. A
 * public action or selector should be implemented to actually call the
 * fetch action included in the returned store object.
 *
 * For example, if the fetch store is intended for an API-based
 * action 'storeMySetting':
 * * The basename passed should be 'storeMySetting'.
 * * The action 'storeMySetting' should call 'fetchStoreMySetting'.
 *
 * Or, if the fetch store is intended for an API-based selector
 * 'getSomeData':
 * * The baseName passed should be 'getSomeData'.
 * * The resolver for 'getSomeData' should call 'fetchGetSomeData'.
 *
 * @since 1.10.0
 * @private
 *
 * @param {Object}   args                   Arguments for creating the fetch store.
 * @param {string}   args.baseName          The base name to use for all the created infrastructure.
 * @param {Function} args.controlCallback   Callback function to issue the API request. Will be used inside the
 *                                          control. The function receives a params object based on argsToParams,
 *                                          i.e. the respective values passed to the action.
 * @param {Function} [args.reducerCallback] Optional. Callback function to modify state based on the API response.
 *                                          Will be used inside the reducer. The function receives the store's state
 *                                          object as first parameter, the API response as second parameter, and the
 *                                          params object for the request (see above) as third parameter. If not
 *                                          provided, the default will return the unmodified state.
 * @param {Function} [args.argsToParams]    Optional. Function that reduces the given list of arguments
 *                                          into a object of key/value parameters, with the argument names used as keys.
 *                                          If not provided, the default function will return an empty object,
 *                                          essentially indicating that no arguments are supported/required.
 * @param {Function} [args.validateParams]  Optional. Function that validates the given parameters object created by `argsToParams`.
 *                                          Any invalid parameters should cause a respective error to be thrown.
 * @return {Object} Partial store object with properties 'actions', 'controls', 'reducer', 'resolvers', and 'selectors'.
 */
function createFetchStore({
  baseName,
  controlCallback,
  reducerCallback = defaultReducerCallback,
  argsToParams = defaultArgsToParams,
  validateParams = defaultValidateParams
}) {
  invariant__WEBPACK_IMPORTED_MODULE_0___default()(baseName, 'baseName is required.');
  invariant__WEBPACK_IMPORTED_MODULE_0___default()('function' === typeof controlCallback, 'controlCallback is required and must be a function.');
  invariant__WEBPACK_IMPORTED_MODULE_0___default()('function' === typeof reducerCallback, 'reducerCallback must be a function.');
  invariant__WEBPACK_IMPORTED_MODULE_0___default()('function' === typeof argsToParams, 'argsToParams must be a function.');
  invariant__WEBPACK_IMPORTED_MODULE_0___default()('function' === typeof validateParams, 'validateParams must be a function.');

  // If validating the result of argsToParams without any arguments does not result in an error, we
  // know params is okay to be empty.
  let requiresParams;
  try {
    validateParams(argsToParams());
    requiresParams = false;
  } catch (error) {
    requiresParams = true;
  }
  const pascalCaseBaseName = (0,_transform_case__WEBPACK_IMPORTED_MODULE_3__.camelCaseToPascalCase)(baseName);
  const constantBaseName = (0,_transform_case__WEBPACK_IMPORTED_MODULE_3__.camelCaseToConstantCase)(baseName);
  const FETCH = `FETCH_${constantBaseName}`;
  const START_FETCH = `START_${FETCH}`;
  const FINISH_FETCH = `FINISH_${FETCH}`;
  const CATCH_FETCH = `CATCH_${FETCH}`;
  const RECEIVE = `RECEIVE_${constantBaseName}`;
  const fetchCreator = `fetch${pascalCaseBaseName}`;
  const receiveCreator = `receive${pascalCaseBaseName}`;
  const isFetching = `isFetching${pascalCaseBaseName}`;
  const initialState = {
    [isFetching]: {}
  };
  function* fetchGenerator(params, args) {
    let response;
    let error;
    yield {
      payload: {
        params
      },
      type: START_FETCH
    };
    yield clearError(baseName, args);
    try {
      response = yield {
        payload: {
          params
        },
        type: FETCH
      };
      yield actions[receiveCreator](response, params);
      yield {
        payload: {
          params
        },
        type: FINISH_FETCH
      };
    } catch (e) {
      error = e;
      yield receiveError(error, baseName, args);
      yield {
        payload: {
          params
        },
        type: CATCH_FETCH
      };
    }
    return {
      response,
      error
    };
  }
  const actions = {
    [fetchCreator](...args) {
      const params = argsToParams(...args);
      // In order for params validation to throw an error as expected,
      // this function cannot be a generator.
      validateParams(params);

      // The normal fetch action generator is invoked as the return here
      // to preserve asynchronous behavior without registering another action creator.
      return fetchGenerator(params, args);
    },
    [receiveCreator](response, params) {
      invariant__WEBPACK_IMPORTED_MODULE_0___default()(response !== undefined, 'response is required.');
      if (requiresParams) {
        invariant__WEBPACK_IMPORTED_MODULE_0___default()((0,lodash__WEBPACK_IMPORTED_MODULE_1__.isPlainObject)(params), 'params is required.');
        validateParams(params);
      } else {
        params = {};
      }
      return {
        payload: {
          response,
          params
        },
        type: RECEIVE
      };
    }
  };
  const controls = {
    [FETCH]: ({
      payload
    }) => {
      return controlCallback(payload.params);
    }
  };
  const reducer = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_5__.createReducer)((state, {
    type,
    payload
  }) => {
    switch (type) {
      case START_FETCH:
        {
          const {
            params
          } = payload;
          state[isFetching] = state[isFetching] || {};
          state[isFetching][(0,_js_util__WEBPACK_IMPORTED_MODULE_4__.stringifyObject)(params)] = true;
          return state;
        }
      case RECEIVE:
        {
          const {
            response,
            params
          } = payload;
          return reducerCallback(state, response, params);
        }
      case FINISH_FETCH:
        {
          const {
            params
          } = payload;
          state[isFetching] = state[isFetching] || {};
          state[isFetching][(0,_js_util__WEBPACK_IMPORTED_MODULE_4__.stringifyObject)(params)] = false;
          return state;
        }
      case CATCH_FETCH:
        {
          const {
            params
          } = payload;
          state[isFetching] = state[isFetching] || {};
          state[isFetching][(0,_js_util__WEBPACK_IMPORTED_MODULE_4__.stringifyObject)(params)] = false;
          return state;
        }
      default:
        return state;
    }
  });
  const selectors = {
    [isFetching]: (state, ...args) => {
      if (state[isFetching] === undefined) {
        return false;
      }
      let params;
      try {
        params = argsToParams(...args);
        validateParams(params);
      } catch (err) {
        // If parameters are invalid, fail silently here. It likely is
        // because some dependency selector is still resolving.
        return false;
      }
      return !!state[isFetching][(0,_js_util__WEBPACK_IMPORTED_MODULE_4__.stringifyObject)(params)];
    }
  };
  return {
    initialState,
    actions,
    controls,
    reducer,
    resolvers: {},
    selectors
  };
}

/***/ }),

/***/ "./js/googlesitekit/data/create-notifications-store.js":
/*!*************************************************************!*\
  !*** ./js/googlesitekit/data/create-notifications-store.js ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   createNotificationsStore: () => (/* binding */ createNotificationsStore)
/* harmony export */ });
/* harmony import */ var invariant__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! invariant */ "../node_modules/invariant/browser.js");
/* harmony import */ var invariant__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(invariant__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var googlesitekit_api__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-api */ "googlesitekit-api");
/* harmony import */ var googlesitekit_api__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_api__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _create_fetch_store__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./create-fetch-store */ "./js/googlesitekit/data/create-fetch-store.js");
/**
 * Provides API functions to create a datastore for notifications.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * Internal dependencies
 */




/**
 * Creates a store object that includes actions and selectors for managing notifications.
 *
 * The three required parameters hook up the store to the respective REST API endpoint.
 *
 * @since 1.6.0
 * @private
 *
 * @param {string}  type              The data to access. One of 'core' or 'modules'.
 * @param {string}  identifier        The data identifier, eg. a module slug like search-console.
 * @param {string}  datapoint         The endpoint to request data from, e.g. 'notifications'.
 * @param {Object}  options           Optional. Options to consider for the store.
 * @param {boolean} options.server    Enable server notifications. `true` by default.
 * @param {number}  options.storeName Store name to use. Default is '{type}/{identifier}'.
 * @return {Object} The notifications store object, with additional `STORE_NAME` and
 *                  `initialState` properties.
 */
function createNotificationsStore(type, identifier, datapoint, {
  server = true,
  storeName = undefined
} = {}) {
  invariant__WEBPACK_IMPORTED_MODULE_0___default()(type, 'type is required.');
  invariant__WEBPACK_IMPORTED_MODULE_0___default()(identifier, 'identifier is required.');
  invariant__WEBPACK_IMPORTED_MODULE_0___default()(datapoint, 'datapoint is required.');
  const STORE_NAME = storeName || `${type}/${identifier}`;
  const initialState = {
    serverNotifications: server ? undefined : {}
  };
  const fetchGetNotificationsStore = (0,_create_fetch_store__WEBPACK_IMPORTED_MODULE_3__.createFetchStore)({
    baseName: 'getNotifications',
    controlCallback: () => {
      return (0,googlesitekit_api__WEBPACK_IMPORTED_MODULE_1__.get)(type, identifier, datapoint);
    },
    reducerCallback: (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.createReducer)((state, notifications) => {
      state.serverNotifications = notifications.reduce((acc, notification) => {
        return {
          ...acc,
          [notification.id]: notification
        };
      }, {});
    })
  });
  const actions = {};
  const controls = {};

  // eslint-disable-next-line no-shadow
  function reducer(state = initialState, {
    type
  }) {
    switch (type) {
      default:
        {
          return state;
        }
    }
  }
  const resolvers = {
    *getNotifications() {
      const registry = yield googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.commonActions.getRegistry();
      const notifications = registry.select(STORE_NAME).getNotifications();
      if (!notifications) {
        yield fetchGetNotificationsStore.actions.fetchGetNotifications();
      }
    }
  };

  // If server notifications are disabled, we should remove the getNotifications
  // resolver. If we set it as `undefined` we'll encounter issues with an `undefined`
  // resolver, because @wordpress/data will still try to register the resolver because
  // it sees a key. And this is nicer than a no-op resolver.
  if (!server) {
    delete resolvers.getNotifications;
  }
  const selectors = {
    /**
     * Gets the current notifications.
     *
     * Returns `undefined` if notifications are not available/loaded.
     *
     * @since 1.6.0
     *
     * @param {Object} state Data store's state.
     * @return {(Array|undefined)} Current list of notifications.
     */
    getNotifications(state) {
      const {
        serverNotifications
      } = state;

      // If there are no client notifications and the server notifications
      // haven't loaded yet, return `undefined` (the value of
      // `serverNotifications` here) to signify to anything using this
      // selector that notifications have not loaded yet.
      if ('undefined' === typeof serverNotifications) {
        return serverNotifications;
      }

      // If there are any notifications from either the client or server,
      // we should return them, even if the server notifications haven't
      // finished loading yet.
      return Object.values({
        ...(serverNotifications || {})
      });
    }
  };
  const store = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.combineStores)(fetchGetNotificationsStore, {
    initialState,
    actions,
    controls,
    reducer,
    resolvers,
    selectors
  });
  return {
    ...store,
    STORE_NAME
  };
}

/***/ }),

/***/ "./js/googlesitekit/data/create-settings-store.js":
/*!********************************************************!*\
  !*** ./js/googlesitekit/data/create-settings-store.js ***!
  \********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   INVARIANT_DOING_SUBMIT_CHANGES: () => (/* binding */ INVARIANT_DOING_SUBMIT_CHANGES),
/* harmony export */   INVARIANT_SETTINGS_NOT_CHANGED: () => (/* binding */ INVARIANT_SETTINGS_NOT_CHANGED),
/* harmony export */   createSettingsStore: () => (/* binding */ createSettingsStore),
/* harmony export */   makeDefaultCanSubmitChanges: () => (/* binding */ makeDefaultCanSubmitChanges),
/* harmony export */   makeDefaultHaveSettingsChanged: () => (/* binding */ makeDefaultHaveSettingsChanged),
/* harmony export */   makeDefaultRollbackChanges: () => (/* binding */ makeDefaultRollbackChanges),
/* harmony export */   makeDefaultSubmitChanges: () => (/* binding */ makeDefaultSubmitChanges)
/* harmony export */ });
/* harmony import */ var invariant__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! invariant */ "../node_modules/invariant/browser.js");
/* harmony import */ var invariant__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(invariant__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! lodash */ "../node_modules/lodash/lodash.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var googlesitekit_api__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! googlesitekit-api */ "googlesitekit-api");
/* harmony import */ var googlesitekit_api__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_api__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./utils */ "./js/googlesitekit/data/utils.js");
/* harmony import */ var _transform_case__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./transform-case */ "./js/googlesitekit/data/transform-case.js");
/* harmony import */ var _create_fetch_store__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./create-fetch-store */ "./js/googlesitekit/data/create-fetch-store.js");
/* harmony import */ var _js_googlesitekit_data_create_error_store__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @/js/googlesitekit/data/create-error-store */ "./js/googlesitekit/data/create-error-store.js");
/**
 * Provides API functions to create a datastore for settings.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * Internal dependencies
 */







// Get access to error store action creators.
// If the parent store doesn't include the error store,
// yielded error actions will be a no-op.
const {
  clearError,
  receiveError
} = _js_googlesitekit_data_create_error_store__WEBPACK_IMPORTED_MODULE_7__.actions;

// Invariant error messages.
const INVARIANT_DOING_SUBMIT_CHANGES = 'cannot submit changes while submitting changes';
const INVARIANT_SETTINGS_NOT_CHANGED = 'cannot submit changes if settings have not changed';

// Actions
const SET_SETTINGS = 'SET_SETTINGS';
const ROLLBACK_SETTINGS = 'ROLLBACK_SETTINGS';
const ROLLBACK_SETTING = 'ROLLBACK_SETTING';

/**
 * Creates a store object that includes actions and selectors for managing settings.
 *
 * The first three parameters hook up the store to the respective REST API endpoint,
 * while the fourth defines the names of the sub-settings to support.
 *
 * @since 1.6.0
 * @since 1.129.0 Added haveSettingsChanged optional paramter.
 * @private
 *
 * @param {string}        type                                  The data to access. One of 'core' or 'modules'.
 * @param {string}        identifier                            The data identifier, eg. a module slug like `search-console`.
 * @param {string}        datapoint                             The endpoint to request data from, e.g. 'settings'.
 * @param {Object}        options                               Optional. Options to consider for the store.
 * @param {Array}         [options.ownedSettingsSlugs]          Optional. List of "owned settings" for this module, if they exist.
 * @param {number}        [options.storeName]                   Store name to use. Default is '{type}/{identifier}'.
 * @param {Array}         [options.settingSlugs]                List of the slugs that are part of the settings object handled by the respective API endpoint.
 * @param {Object}        [options.initialSettings]             Optional. An initial set of settings as key-value pairs.
 * @param {Function|null} [options.validateHaveSettingsChanged] Optional. Custom callback to determine if settings have changed.
 * @return {Object} The settings store object, with additional `STORE_NAME` and
 *                  `initialState` properties.
 */
function createSettingsStore(type, identifier, datapoint, {
  ownedSettingsSlugs = undefined,
  storeName = undefined,
  settingSlugs = [],
  initialSettings = undefined,
  validateHaveSettingsChanged = makeDefaultHaveSettingsChanged()
} = {}) {
  invariant__WEBPACK_IMPORTED_MODULE_0___default()(type, 'type is required.');
  invariant__WEBPACK_IMPORTED_MODULE_0___default()(identifier, 'identifier is required.');
  invariant__WEBPACK_IMPORTED_MODULE_0___default()(datapoint, 'datapoint is required.');
  const STORE_NAME = storeName || `${type}/${identifier}`;
  const initialState = {
    ownedSettingsSlugs,
    settings: initialSettings,
    savedSettings: undefined
  };
  const fetchGetSettingsStore = (0,_create_fetch_store__WEBPACK_IMPORTED_MODULE_6__.createFetchStore)({
    baseName: 'getSettings',
    controlCallback: () => {
      return (0,googlesitekit_api__WEBPACK_IMPORTED_MODULE_2__.get)(type, identifier, datapoint, {}, {
        useCache: false
      });
    },
    reducerCallback: (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__.createReducer)((state, values) => {
      state.savedSettings = {
        ...values
      };
      state.settings = {
        ...values,
        // In case settings were already changed, they should take precedence.
        ...(state.settings || {})
      };
    })
  });
  const fetchSaveSettingsStore = (0,_create_fetch_store__WEBPACK_IMPORTED_MODULE_6__.createFetchStore)({
    baseName: 'saveSettings',
    controlCallback: params => {
      const {
        values
      } = params;
      return (0,googlesitekit_api__WEBPACK_IMPORTED_MODULE_2__.set)(type, identifier, datapoint, values);
    },
    reducerCallback: (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__.createReducer)((state, values) => {
      state.savedSettings = {
        ...values
      };
      // Ensure client settings are refreshed from server.
      state.settings = {
        ...values
      };
    }),
    argsToParams: values => {
      return {
        values
      };
    },
    validateParams: ({
      values
    } = {}) => {
      invariant__WEBPACK_IMPORTED_MODULE_0___default()((0,lodash__WEBPACK_IMPORTED_MODULE_1__.isPlainObject)(values), 'values is required.');
    }
  });

  // This will be populated further down with reducer functions for individual settings.
  const settingReducers = {};
  const actions = {
    /**
     * Sets settings for the given values.
     *
     * @since 1.6.0
     *
     * @param {Object} values Settings with their values to set.
     * @return {Object} Redux-style action.
     */
    setSettings(values) {
      invariant__WEBPACK_IMPORTED_MODULE_0___default()((0,lodash__WEBPACK_IMPORTED_MODULE_1__.isPlainObject)(values), 'values is required.');
      return {
        payload: {
          values
        },
        type: SET_SETTINGS
      };
    },
    /**
     * Returns the current settings back to the current saved values.
     *
     * @since 1.7.1
     * @private
     *
     * @return {Object} Redux-style action.
     */
    rollbackSettings() {
      return {
        payload: {},
        type: ROLLBACK_SETTINGS
      };
    },
    /**
     * Returns a specific setting back to the current saved value.
     *
     * @since 1.147.0
     *
     * @param {string} setting The setting to rollback.
     * @return {Object} Redux-style action.
     */
    rollbackSetting(setting) {
      invariant__WEBPACK_IMPORTED_MODULE_0___default()(setting, 'setting is required.');
      return {
        payload: {
          setting
        },
        type: ROLLBACK_SETTING
      };
    },
    /**
     * Saves all current settings to the server.
     *
     * @since 1.6.0
     *
     * @return {Object} Response and error, if any.
     */
    *saveSettings() {
      const registry = yield googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__.commonActions.getRegistry();
      yield clearError('saveSettings', []);
      const values = registry.select(STORE_NAME).getSettings();
      const {
        response,
        error
      } = yield fetchSaveSettingsStore.actions.fetchSaveSettings(values);
      if (error) {
        // Store error manually since saveSettings signature differs from fetchSaveSettings.
        yield receiveError(error, 'saveSettings', []);
      }
      return {
        response,
        error
      };
    }
  };
  const controls = {};

  // eslint-disable-next-line no-shadow
  const reducer = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__.createReducer)((state, {
    type,
    payload
  }) => {
    switch (type) {
      case SET_SETTINGS:
        {
          const {
            values
          } = payload;
          state.settings = {
            ...(state.settings || {}),
            ...values
          };
          break;
        }
      case ROLLBACK_SETTINGS:
        {
          state.settings = state.savedSettings;
          break;
        }
      case ROLLBACK_SETTING:
        {
          const {
            setting
          } = payload;
          if (state.savedSettings[setting]) {
            state.settings = {
              ...(state.settings || {}),
              [setting]: state.savedSettings[setting]
            };
          }
          break;
        }
      default:
        {
          // Check if this action is for a reducer for an individual setting.
          if ('undefined' !== typeof settingReducers[type]) {
            settingReducers[type](state, {
              type,
              payload
            });
          }
          break;
        }
    }
  });
  const resolvers = {
    *getSettings() {
      const registry = yield googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__.commonActions.getRegistry();
      const existingSettings = registry.select(STORE_NAME).getSettings();
      // If settings are already present, don't fetch them.
      if (!existingSettings) {
        yield fetchGetSettingsStore.actions.fetchGetSettings();
      }
    }
  };
  const {
    safeSelector: haveSettingsChanged,
    dangerousSelector: __dangerousHaveSettingsChanged
  } = (0,_utils__WEBPACK_IMPORTED_MODULE_4__.createValidationSelector)(validateHaveSettingsChanged);
  const selectors = {
    /**
     * Indicates whether the current settings have changed from what is saved.
     *
     * @since 1.6.0
     * @since 1.77.0 Added ability to filter settings using `keys` argument.
     * @since 1.129.0 Changed the approach to use validateHaveSettingsChanged callback.
     * @since 1.131.0 Updated implementation to use safeSelector and dangerousSelector returned from createValidationSelector.
     *
     * @param {Object}     state Data store's state.
     * @param {Array|null} keys  Settings keys to check; if not provided, all settings are checked.
     * @return {boolean} True if the settings have changed, false otherwise.
     */
    haveSettingsChanged,
    __dangerousHaveSettingsChanged,
    /**
     * Gets the current settings.
     *
     * Returns `undefined` if notifications are not available/loaded.
     *
     * @since 1.6.0
     *
     * @param {Object} state Data store's state.
     * @return {(Object|undefined)} Settings with their values, or undefined.
     */
    getSettings(state) {
      return state.settings;
    },
    /**
     * Indicates whether the provided setting has changed from what is saved.
     *
     * @since 1.72.0
     *
     * @param {Object} state   Data store's state.
     * @param {string} setting The setting we want to check for saved changes.
     * @return {boolean} True if the settings have changed, false otherwise.
     */
    hasSettingChanged(state, setting) {
      invariant__WEBPACK_IMPORTED_MODULE_0___default()(setting, 'setting is required.');
      const {
        settings,
        savedSettings
      } = state;
      if (!settings || !savedSettings) {
        return false;
      }
      return !(0,lodash__WEBPACK_IMPORTED_MODULE_1__.isEqual)(settings[setting], savedSettings[setting]);
    },
    /**
     * Indicates whether saving the settings is currently in progress.
     *
     * @since 1.6.0
     *
     * @param {Object} state Data store's state.
     * @return {boolean} True if the settings are being saved, false otherwise.
     */
    isDoingSaveSettings(state) {
      // Since isFetchingSaveSettings (via createFetchStore)
      // holds information based on specific values but we only need
      // generic information here, we need to check whether ANY such
      // request is in progress.
      return Object.values(state.isFetchingSaveSettings).some(Boolean);
    },
    /**
     * Gets the owned settings slugs for this module.
     *
     * @since 1.77.0
     *
     * @param {Object} state Data store's state.
     * @return {Array|null} The array of owned settings slugs for this module if they exist. Returns `null` if no owned settings slugs exist.
     */
    getOwnedSettingsSlugs: state => {
      return state.ownedSettingsSlugs;
    },
    /**
     * Returns `true` if a module's "own settings" have changed; `false` if not.
     *
     * @since 1.77.0
     *
     * @param {Object} state Data store's state.
     * @return {boolean} `true` if the module's "own settings" have changed; `false` if not.
     */
    haveOwnedSettingsChanged: (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__.createRegistrySelector)(select => () => {
      const ownedSettingsSlugsToCheck = select(STORE_NAME).getOwnedSettingsSlugs();
      return select(STORE_NAME).haveSettingsChanged(ownedSettingsSlugsToCheck);
    })
  };

  // Define individual actions, selectors and related for sub-settings.
  settingSlugs.forEach(slug => {
    const pascalCaseSlug = (0,_transform_case__WEBPACK_IMPORTED_MODULE_5__.camelCaseToPascalCase)(slug);
    const constantSlug = (0,_transform_case__WEBPACK_IMPORTED_MODULE_5__.camelCaseToConstantCase)(slug);

    /**
     * Sets the setting indicated by the action name to the given value.
     *
     * @since 1.6.0
     *
     * @param {*} value Value for the setting.
     * @return {Object} Redux-style action.
     */
    actions[`set${pascalCaseSlug}`] = value => {
      invariant__WEBPACK_IMPORTED_MODULE_0___default()(typeof value !== 'undefined', `value is required for calls to set${pascalCaseSlug}().`);
      return {
        payload: {
          value
        },
        type: `SET_${constantSlug}`
      };
    };
    settingReducers[`SET_${constantSlug}`] = (state, {
      payload
    }) => {
      const {
        value
      } = payload;
      state.settings = {
        ...(state.settings || {}),
        [slug]: value
      };
    };

    /**
     * Gets the current value for the setting indicated by the selector name.
     *
     * @since 1.6.0
     *
     * @return {*} Setting value, or undefined.
     */
    selectors[`get${pascalCaseSlug}`] = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__.createRegistrySelector)(select => () => {
      const settings = select(STORE_NAME).getSettings() || {};
      return settings[slug];
    });
  });
  const store = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__.combineStores)(googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__.commonStore, fetchGetSettingsStore, fetchSaveSettingsStore, {
    initialState,
    actions,
    controls,
    reducer,
    resolvers,
    selectors
  });
  return {
    ...store,
    STORE_NAME
  };
}

/**
 * Creates a default submitChanges control function.
 *
 * @since 1.21.0
 *
 * @param {string} slug      Module slug.
 * @param {string} storeName Datastore slug.
 * @return {Function} Control function to submit changes.
 */
function makeDefaultSubmitChanges(slug, storeName) {
  return async ({
    select,
    dispatch
  }) => {
    if (select(storeName).haveSettingsChanged()) {
      const {
        error
      } = await dispatch(storeName).saveSettings();
      if (error) {
        return {
          error
        };
      }
    }
    await (0,googlesitekit_api__WEBPACK_IMPORTED_MODULE_2__.invalidateCache)('modules', slug);
    return {};
  };
}

/**
 * Creates a default rollbackChanges control function.
 *
 * @since 1.45.0
 *
 * @param {string} storeName Datastore slug.
 * @return {Function} Control function to rollback settings changes.
 */
function makeDefaultRollbackChanges(storeName) {
  return ({
    select,
    dispatch
  }) => {
    if (select(storeName).haveSettingsChanged()) {
      return dispatch(storeName).rollbackSettings();
    }
    return {};
  };
}

/**
 * Creates a default canSubmitChanges function.
 *
 * @since 1.21.0
 *
 * @param {string} storeName Datastore slug.
 * @return {Function} A function to check if settings can be submitted.
 */
function makeDefaultCanSubmitChanges(storeName) {
  return select => {
    const strictSelect = (0,_utils__WEBPACK_IMPORTED_MODULE_4__.createStrictSelect)(select);
    const {
      haveSettingsChanged,
      isDoingSubmitChanges
    } = strictSelect(storeName);
    invariant__WEBPACK_IMPORTED_MODULE_0___default()(!isDoingSubmitChanges(), INVARIANT_DOING_SUBMIT_CHANGES);
    invariant__WEBPACK_IMPORTED_MODULE_0___default()(haveSettingsChanged(), INVARIANT_SETTINGS_NOT_CHANGED);
  };
}

/**
 * Creates Default haveSettingsChanged.
 *
 * @since 1.129.0
 *
 * @return {boolean} True if the settings have changed, false otherwise.
 */
function makeDefaultHaveSettingsChanged() {
  return (select, state, keys) => {
    const {
      settings,
      savedSettings
    } = state;
    if (keys) {
      invariant__WEBPACK_IMPORTED_MODULE_0___default()(!(0,lodash__WEBPACK_IMPORTED_MODULE_1__.isEqual)((0,lodash__WEBPACK_IMPORTED_MODULE_1__.pick)(settings, keys), (0,lodash__WEBPACK_IMPORTED_MODULE_1__.pick)(savedSettings, keys)), INVARIANT_SETTINGS_NOT_CHANGED);
    }
    invariant__WEBPACK_IMPORTED_MODULE_0___default()(!(0,lodash__WEBPACK_IMPORTED_MODULE_1__.isEqual)(settings, savedSettings), INVARIANT_SETTINGS_NOT_CHANGED);
  };
}

/***/ }),

/***/ "./js/googlesitekit/data/transform-case.js":
/*!*************************************************!*\
  !*** ./js/googlesitekit/data/transform-case.js ***!
  \*************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   camelCaseToConstantCase: () => (/* binding */ camelCaseToConstantCase),
/* harmony export */   camelCaseToPascalCase: () => (/* binding */ camelCaseToPascalCase),
/* harmony export */   hyphenCaseToPascalCase: () => (/* binding */ hyphenCaseToPascalCase)
/* harmony export */ });
/**
 * Data store utilities for transforming names to a certain case.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Transforms a camelCase name into its PascalCase name.
 *
 * @since 1.10.0
 * @private
 *
 * @param {string} name "camelCase" name to transform.
 * @return {string} PascalCase name.
 */
function camelCaseToPascalCase(name) {
  return name.charAt(0).toUpperCase() + name.slice(1);
}

/**
 * Transforms a camelCase name into its CONSTANT_CASE name.
 *
 * @since 1.10.0
 * @private
 *
 * @param {string} name "camelCase" name to transform.
 * @return {string} CONSTANT_CASE name.
 */
function camelCaseToConstantCase(name) {
  return name.replace(/([a-z0-9]{1})([A-Z]{1})/g, '$1_$2').toUpperCase();
}

/**
 * Transforms a hyphen-case name into its PascalCase name.
 *
 * @since 1.30.0
 * @private
 *
 * @param {string} name "hyphen-case" name to transform.
 * @return {string} PascalCase name.
 */
function hyphenCaseToPascalCase(name) {
  return name.split('-').map(part => part.charAt(0).toUpperCase() + part.slice(1)).join('');
}

/***/ }),

/***/ "./js/googlesitekit/data/utils.js":
/*!****************************************!*\
  !*** ./js/googlesitekit/data/utils.js ***!
  \****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   collect: () => (/* binding */ collect),
/* harmony export */   collectActions: () => (/* binding */ collectActions),
/* harmony export */   collectControls: () => (/* binding */ collectControls),
/* harmony export */   collectName: () => (/* binding */ collectName),
/* harmony export */   collectReducers: () => (/* binding */ collectReducers),
/* harmony export */   collectResolvers: () => (/* binding */ collectResolvers),
/* harmony export */   collectSelectors: () => (/* binding */ collectSelectors),
/* harmony export */   collectState: () => (/* binding */ collectState),
/* harmony export */   combineStores: () => (/* binding */ combineStores),
/* harmony export */   commonActions: () => (/* binding */ commonActions),
/* harmony export */   commonControls: () => (/* binding */ commonControls),
/* harmony export */   commonStore: () => (/* binding */ commonStore),
/* harmony export */   createStrictSelect: () => (/* binding */ createStrictSelect),
/* harmony export */   createValidatedAction: () => (/* binding */ createValidatedAction),
/* harmony export */   createValidationSelector: () => (/* binding */ createValidationSelector)
/* harmony export */ });
/* harmony import */ var invariant__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! invariant */ "../node_modules/invariant/browser.js");
/* harmony import */ var invariant__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(invariant__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var memize__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! memize */ "../node_modules/memize/index.js");
/* harmony import */ var memize__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(memize__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! lodash */ "../node_modules/lodash/lodash.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/data */ "../node_modules/@wordpress/data/build-module/factory.js");
/**
 * Data store utilities.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */




/**
 * WordPress dependencies
 */

const GET_REGISTRY = 'GET_REGISTRY';
const AWAIT = 'AWAIT';

/**
 * Collects and combines multiple objects of similar shape.
 *
 * Used to combine objects like actions, selectors, etc. for a data
 * store while ensuring no keys/action names/selector names are duplicated.
 *
 * Effectively this is an object spread, but throws an error if keys are
 * duplicated.
 *
 * @since 1.5.0
 * @private
 *
 * @param {...Object} items A list of arguments, each one should be an object to combine into one.
 * @return {Object} The combined object.
 */
function collect(...items) {
  const collectedObject = items.reduce((acc, item) => {
    return {
      ...acc,
      ...item
    };
  }, {});
  const functionNames = items.reduce((acc, itemSet) => {
    return [...acc, ...Object.keys(itemSet)];
  }, []);
  const duplicates = findDuplicates(functionNames);
  invariant__WEBPACK_IMPORTED_MODULE_0___default()(duplicates.length === 0, `collect() cannot accept collections with duplicate keys. Your call to collect() contains the following duplicated functions: ${duplicates.join(', ')}. Check your data stores for duplicates.`);
  return collectedObject;
}

/**
 * Collects all actions.
 *
 * @since 1.5.0
 *
 * @param {...Object} args A list of objects, each containing their own actions.
 * @return {Object} The combined object.
 */
const collectActions = collect;

/**
 * Collects all controls.
 *
 * @since 1.5.0
 *
 * @param {...Object} args A list of objects, each containing their own controls.
 * @return {Object} The combined object.
 */
const collectControls = collect;

/**
 * Collects all reducers and (optionally) provides initial state.
 *
 * If the first argument passed is not a function, it will be used as the
 * combined reducer's `initialState`.
 *
 * @since 1.5.0
 *
 * @param {...(Object|Function)} args A list of reducers, each containing their own controls. If the first argument is not a function, it will be used as the combined reducer's `initialState`.
 * @return {Function} A Redux-style reducer.
 */
function collectReducers(...args) {
  const reducers = [...args];
  let initialState;
  if (typeof reducers[0] !== 'function') {
    initialState = reducers.shift();
  }
  return (state = initialState, action = {}) => {
    return reducers.reduce((newState, reducer) => {
      return reducer(newState, action);
    }, state);
  };
}

/**
 * Collects all resolvers.
 *
 * @since 1.5.0
 *
 * @param {...Object} args A list of objects, each containing their own resolvers.
 * @return {Object} The combined object.
 */
const collectResolvers = collect;

/**
 * Collects all selectors.
 *
 * @since 1.5.0
 *
 * @param {...Object} args A list of objects, each containing their own selectors.
 * @return {Object} The combined object.
 */
const collectSelectors = collect;

/**
 * Collects all state values.
 *
 * @since 1.5.0
 *
 * @param {...Object} args A list of objects, each containing their own state values.
 * @return {Object} The combined object.
 */
const collectState = collect;

/**
 * Collects all store names.
 *
 * This function's main purpose is to ensure generated store names for a single store match.
 *
 * @since 1.6.0
 *
 * @param {...string} args A list of store names, all of which must be equal.
 * @return {string} The single store name.
 */
function collectName(...args) {
  const names = [...args];
  const duplicates = findDuplicates(names);
  invariant__WEBPACK_IMPORTED_MODULE_0___default()(duplicates.length === names.length - 1, 'collectName() must not receive different names.');
  return names.shift();
}

/**
 * Passes through state unmodified; eg. an empty reducer.
 *
 * @since 1.8.0
 * @private
 *
 * @param {Object} state A store's state.
 * @return {Object} The same state data as passed in `state`.
 */
function passthroughReducer(state) {
  return state;
}

/**
 * Combines multiple stores.
 *
 * @since 1.8.0
 *
 * @param {...Object} stores A list of objects, each a store containing one or more of the following keys: initialState, actions, controls, reducer, resolvers, selectors.
 * @return {Object} The combined store.
 */
function combineStores(...stores) {
  const combinedInitialState = collectState(...stores.map(store => store.initialState || {}));
  return {
    initialState: combinedInitialState,
    controls: collectControls(...stores.map(store => store.controls || {})),
    actions: collectActions(...stores.map(store => store.actions || {})),
    reducer: collectReducers(combinedInitialState, ...stores.map(store => store.reducer || passthroughReducer)),
    resolvers: collectResolvers(...stores.map(store => store.resolvers || {})),
    selectors: collectSelectors(...stores.map(store => store.selectors || {}))
  };
}

/**
 * An object of common actions most stores will use.
 *
 * @since 1.7.0
 *
 * @return {Object} Key/value list of common actions most stores will want.
 */
const commonActions = {
  /**
   * Dispatches an action and calls a control to get the current data registry.
   *
   * Useful for controls and resolvers that wish to dispatch actions/use selectors
   * on the current data registry.
   *
   * @since 1.7.0
   *
   * @return {Object} FSA-compatible action.
   */
  getRegistry() {
    return {
      payload: {},
      type: GET_REGISTRY
    };
  },
  /**
   * Dispatches an action and calls a control to return the promise resolution.
   *
   * Useful for controls and resolvers that wish to call an asynchronous function or other promise.
   *
   * @since 1.22.0
   *
   * @param {Promise} value A promise to resolve.
   * @return {Object} Object with resolved promise.
   */
  *await(value) {
    return {
      payload: {
        value
      },
      type: AWAIT
    };
  }
};

/**
 * An object of common controls most stores will use.
 *
 * @since 1.7.0
 *
 * @return {Object} Key/value list of common controls most stores will want.
 */
const commonControls = {
  /**
   * Returns the current registry.
   *
   * Useful for controls and resolvers that wish to dispatch actions/use selectors
   * on the current data registry.
   *
   * @since 1.7.0
   *
   * @return {Object} FSA-compatible action.
   */
  [GET_REGISTRY]: (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_3__.createRegistryControl)(registry => () => registry),
  /**
   * Returns a resolved promise.
   *
   * @since 1.22.0
   *
   * @param {Object} payload         Object containing a promise.
   * @param {Object} payload.payload Object containing a promise.
   * @return {*} Resolved promise.
   */
  [AWAIT]: ({
    payload
  }) => payload.value
};

/**
 * Finds all duplicate items in an array and return them.
 *
 * @since 1.5.0
 * @private
 *
 * @param {Array} array Any array.
 * @return {Array} All values in the input array that were duplicated.
 */
function findDuplicates(array) {
  const duplicates = [];
  const counts = {};
  for (let i = 0; i < array.length; i++) {
    const item = array[i];
    counts[item] = counts[item] >= 1 ? counts[item] + 1 : 1;
    if (counts[item] > 1) {
      duplicates.push(item);
    }
  }
  return duplicates;
}

/**
 * A store containing the common actions, controls and reducer that all stores will use.
 *
 * @since 1.8.0
 *
 * @return {Object} Object with common actions, controls and reducer.
 */
const commonStore = {
  actions: commonActions,
  controls: commonControls,
  reducer: passthroughReducer
};

/**
 * Creates a strict version of registry.select for ensuring that a selector is resolved at the time of calling.
 *
 * Not intended to be used directly. This is useful in the context of validation functions
 * to save checking for undefined on every result.
 *
 * Given the registry.select function instance, a new function is returned
 * with the same API as `select()` but will throw an error if the result
 * of the selector function is `undefined`.
 *
 * Ideally this would use something like `hasFinishedResolution` instead,
 * but there is no way to traverse the selectors used internally to identify
 * dependent selectors that have resolvers as many selectors are composed of
 * higher-level selectors internally which is where a resolver is normally implemented.
 *
 * @since 1.18.0
 * @private
 *
 * @param {Function} select The registry.select function.
 * @return {Function} The strict version of registry.select.
 */
function createStrictSelect(select) {
  return storeName => {
    return getStrictSelectors(select(storeName));
  };
}

// Based on {@link https://github.com/WordPress/gutenberg/blob/b1c8026087dfb026eff0a023a5f7febe28c876de/packages/data/src/registry.js#L91}
const getStrictSelectors = memize__WEBPACK_IMPORTED_MODULE_1___default()(selectors => (0,lodash__WEBPACK_IMPORTED_MODULE_2__.mapValues)(selectors, (selector, selectorName) => (...args) => {
  const returnValue = selector(...args);
  invariant__WEBPACK_IMPORTED_MODULE_0___default()(returnValue !== undefined, `${selectorName}(...) is not resolved`);
  return returnValue;
}));

/**
 * Creates two registry selectors that call the incoming function to validate the current state.
 *
 * @since 1.19.0
 *
 * @param {Function} validate         Validation function callback.
 * @param {Object}   [options]        Options to modify the behavior of the generated selectors.
 * @param {boolean}  [options.negate] Whether to negate the boolean result or not. Default: false.
 * @return {Object} Safe and dangerous selectors.
 */
function createValidationSelector(validate, {
  negate = false
} = {}) {
  const safeSelector = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_3__.createRegistrySelector)(select => (state, ...args) => {
    const pass = negate ? false : true;
    const fail = negate ? true : false;
    try {
      validate(select, state, ...args);
      return pass;
    } catch {
      return fail;
    }
  });
  const dangerousSelector = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_3__.createRegistrySelector)(select => (state, ...args) => {
    validate(select, state, ...args);
  });
  return {
    safeSelector,
    dangerousSelector
  };
}

/**
 * Creates a validated action creator.
 *
 * @since 1.32.0
 *
 * @param {Function} validate      A function for validating action arguments.
 * @param {Function} actionCreator A function for returning or yielding redux-style actions.
 * @return {Function} An enhanced action creator.
 */
function createValidatedAction(validate, actionCreator) {
  invariant__WEBPACK_IMPORTED_MODULE_0___default()(typeof validate === 'function', 'a validator function is required.');
  invariant__WEBPACK_IMPORTED_MODULE_0___default()(typeof actionCreator === 'function', 'an action creator function is required.');
  invariant__WEBPACK_IMPORTED_MODULE_0___default()(validate[Symbol.toStringTag] !== 'Generator' && validate[Symbol.toStringTag] !== 'GeneratorFunction', 'an action’s validator function must not be a generator.');
  return (...args) => {
    validate(...args);
    return actionCreator(...args);
  };
}

/***/ }),

/***/ "./js/googlesitekit/datastore/site/constants.js":
/*!******************************************************!*\
  !*** ./js/googlesitekit/datastore/site/constants.js ***!
  \******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   AMP_MODE_PRIMARY: () => (/* binding */ AMP_MODE_PRIMARY),
/* harmony export */   AMP_MODE_SECONDARY: () => (/* binding */ AMP_MODE_SECONDARY),
/* harmony export */   CORE_SITE: () => (/* binding */ CORE_SITE)
/* harmony export */ });
/**
 * `core/site` data store: constants.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

const CORE_SITE = 'core/site';
const AMP_MODE_PRIMARY = 'primary';
const AMP_MODE_SECONDARY = 'secondary';

/***/ }),

/***/ "./js/googlesitekit/datastore/user/constants.js":
/*!******************************************************!*\
  !*** ./js/googlesitekit/datastore/user/constants.js ***!
  \******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   CORE_USER: () => (/* binding */ CORE_USER),
/* harmony export */   DISCONNECTED_REASON_CONNECTED_URL_MISMATCH: () => (/* binding */ DISCONNECTED_REASON_CONNECTED_URL_MISMATCH),
/* harmony export */   ERROR_CODE_ADBLOCKER_ACTIVE: () => (/* binding */ ERROR_CODE_ADBLOCKER_ACTIVE),
/* harmony export */   FORM_TEMPORARY_PERSIST_PERMISSION_ERROR: () => (/* binding */ FORM_TEMPORARY_PERSIST_PERMISSION_ERROR),
/* harmony export */   GLOBAL_SURVEYS_TIMEOUT_SLUG: () => (/* binding */ GLOBAL_SURVEYS_TIMEOUT_SLUG),
/* harmony export */   KM_ANALYTICS_ADSENSE_TOP_EARNING_CONTENT: () => (/* binding */ KM_ANALYTICS_ADSENSE_TOP_EARNING_CONTENT),
/* harmony export */   KM_ANALYTICS_ENGAGED_TRAFFIC_SOURCE: () => (/* binding */ KM_ANALYTICS_ENGAGED_TRAFFIC_SOURCE),
/* harmony export */   KM_ANALYTICS_LEAST_ENGAGING_PAGES: () => (/* binding */ KM_ANALYTICS_LEAST_ENGAGING_PAGES),
/* harmony export */   KM_ANALYTICS_MOST_ENGAGING_PAGES: () => (/* binding */ KM_ANALYTICS_MOST_ENGAGING_PAGES),
/* harmony export */   KM_ANALYTICS_NEW_VISITORS: () => (/* binding */ KM_ANALYTICS_NEW_VISITORS),
/* harmony export */   KM_ANALYTICS_PAGES_PER_VISIT: () => (/* binding */ KM_ANALYTICS_PAGES_PER_VISIT),
/* harmony export */   KM_ANALYTICS_POPULAR_AUTHORS: () => (/* binding */ KM_ANALYTICS_POPULAR_AUTHORS),
/* harmony export */   KM_ANALYTICS_POPULAR_CONTENT: () => (/* binding */ KM_ANALYTICS_POPULAR_CONTENT),
/* harmony export */   KM_ANALYTICS_POPULAR_PRODUCTS: () => (/* binding */ KM_ANALYTICS_POPULAR_PRODUCTS),
/* harmony export */   KM_ANALYTICS_RETURNING_VISITORS: () => (/* binding */ KM_ANALYTICS_RETURNING_VISITORS),
/* harmony export */   KM_ANALYTICS_TOP_CATEGORIES: () => (/* binding */ KM_ANALYTICS_TOP_CATEGORIES),
/* harmony export */   KM_ANALYTICS_TOP_CITIES: () => (/* binding */ KM_ANALYTICS_TOP_CITIES),
/* harmony export */   KM_ANALYTICS_TOP_CITIES_DRIVING_ADD_TO_CART: () => (/* binding */ KM_ANALYTICS_TOP_CITIES_DRIVING_ADD_TO_CART),
/* harmony export */   KM_ANALYTICS_TOP_CITIES_DRIVING_LEADS: () => (/* binding */ KM_ANALYTICS_TOP_CITIES_DRIVING_LEADS),
/* harmony export */   KM_ANALYTICS_TOP_CITIES_DRIVING_PURCHASES: () => (/* binding */ KM_ANALYTICS_TOP_CITIES_DRIVING_PURCHASES),
/* harmony export */   KM_ANALYTICS_TOP_CONVERTING_TRAFFIC_SOURCE: () => (/* binding */ KM_ANALYTICS_TOP_CONVERTING_TRAFFIC_SOURCE),
/* harmony export */   KM_ANALYTICS_TOP_COUNTRIES: () => (/* binding */ KM_ANALYTICS_TOP_COUNTRIES),
/* harmony export */   KM_ANALYTICS_TOP_DEVICE_DRIVING_PURCHASES: () => (/* binding */ KM_ANALYTICS_TOP_DEVICE_DRIVING_PURCHASES),
/* harmony export */   KM_ANALYTICS_TOP_PAGES_DRIVING_LEADS: () => (/* binding */ KM_ANALYTICS_TOP_PAGES_DRIVING_LEADS),
/* harmony export */   KM_ANALYTICS_TOP_RECENT_TRENDING_PAGES: () => (/* binding */ KM_ANALYTICS_TOP_RECENT_TRENDING_PAGES),
/* harmony export */   KM_ANALYTICS_TOP_RETURNING_VISITOR_PAGES: () => (/* binding */ KM_ANALYTICS_TOP_RETURNING_VISITOR_PAGES),
/* harmony export */   KM_ANALYTICS_TOP_TRAFFIC_SOURCE: () => (/* binding */ KM_ANALYTICS_TOP_TRAFFIC_SOURCE),
/* harmony export */   KM_ANALYTICS_TOP_TRAFFIC_SOURCE_DRIVING_ADD_TO_CART: () => (/* binding */ KM_ANALYTICS_TOP_TRAFFIC_SOURCE_DRIVING_ADD_TO_CART),
/* harmony export */   KM_ANALYTICS_TOP_TRAFFIC_SOURCE_DRIVING_LEADS: () => (/* binding */ KM_ANALYTICS_TOP_TRAFFIC_SOURCE_DRIVING_LEADS),
/* harmony export */   KM_ANALYTICS_TOP_TRAFFIC_SOURCE_DRIVING_PURCHASES: () => (/* binding */ KM_ANALYTICS_TOP_TRAFFIC_SOURCE_DRIVING_PURCHASES),
/* harmony export */   KM_ANALYTICS_VISITS_PER_VISITOR: () => (/* binding */ KM_ANALYTICS_VISITS_PER_VISITOR),
/* harmony export */   KM_ANALYTICS_VISIT_LENGTH: () => (/* binding */ KM_ANALYTICS_VISIT_LENGTH),
/* harmony export */   KM_SEARCH_CONSOLE_POPULAR_KEYWORDS: () => (/* binding */ KM_SEARCH_CONSOLE_POPULAR_KEYWORDS),
/* harmony export */   PERMISSION_AUTHENTICATE: () => (/* binding */ PERMISSION_AUTHENTICATE),
/* harmony export */   PERMISSION_DELEGATE_MODULE_SHARING_MANAGEMENT: () => (/* binding */ PERMISSION_DELEGATE_MODULE_SHARING_MANAGEMENT),
/* harmony export */   PERMISSION_MANAGE_MODULE_SHARING_OPTIONS: () => (/* binding */ PERMISSION_MANAGE_MODULE_SHARING_OPTIONS),
/* harmony export */   PERMISSION_MANAGE_OPTIONS: () => (/* binding */ PERMISSION_MANAGE_OPTIONS),
/* harmony export */   PERMISSION_READ_SHARED_MODULE_DATA: () => (/* binding */ PERMISSION_READ_SHARED_MODULE_DATA),
/* harmony export */   PERMISSION_SETUP: () => (/* binding */ PERMISSION_SETUP),
/* harmony export */   PERMISSION_UPDATE_PLUGINS: () => (/* binding */ PERMISSION_UPDATE_PLUGINS),
/* harmony export */   PERMISSION_VIEW_DASHBOARD: () => (/* binding */ PERMISSION_VIEW_DASHBOARD),
/* harmony export */   PERMISSION_VIEW_MODULE_DETAILS: () => (/* binding */ PERMISSION_VIEW_MODULE_DETAILS),
/* harmony export */   PERMISSION_VIEW_POSTS_INSIGHTS: () => (/* binding */ PERMISSION_VIEW_POSTS_INSIGHTS),
/* harmony export */   PERMISSION_VIEW_SHARED_DASHBOARD: () => (/* binding */ PERMISSION_VIEW_SHARED_DASHBOARD),
/* harmony export */   allKeyMetricsTileWidgets: () => (/* binding */ allKeyMetricsTileWidgets),
/* harmony export */   keyMetricsGA4Widgets: () => (/* binding */ keyMetricsGA4Widgets)
/* harmony export */ });
/**
 * `core/user` data store: constants.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

const CORE_USER = 'core/user';
const DISCONNECTED_REASON_CONNECTED_URL_MISMATCH = 'connected_url_mismatch';
const GLOBAL_SURVEYS_TIMEOUT_SLUG = '__global';
const FORM_TEMPORARY_PERSIST_PERMISSION_ERROR = 'temporary_persist_permission_error';
const ERROR_CODE_ADBLOCKER_ACTIVE = 'adblocker_active';

// Permissions list.
const PERMISSION_AUTHENTICATE = 'googlesitekit_authenticate';
const PERMISSION_SETUP = 'googlesitekit_setup';
const PERMISSION_VIEW_POSTS_INSIGHTS = 'googlesitekit_view_posts_insights';
const PERMISSION_VIEW_DASHBOARD = 'googlesitekit_view_dashboard';
const PERMISSION_VIEW_SHARED_DASHBOARD = 'googlesitekit_view_shared_dashboard';
const PERMISSION_VIEW_MODULE_DETAILS = 'googlesitekit_view_module_details';
const PERMISSION_MANAGE_OPTIONS = 'googlesitekit_manage_options';
const PERMISSION_READ_SHARED_MODULE_DATA = 'googlesitekit_read_shared_module_data';
const PERMISSION_MANAGE_MODULE_SHARING_OPTIONS = 'googlesitekit_manage_module_sharing_options';
const PERMISSION_DELEGATE_MODULE_SHARING_MANAGEMENT = 'googlesitekit_delegate_module_sharing_management';
const PERMISSION_UPDATE_PLUGINS = 'googlesitekit_update_plugins';

// Key Metrics Widgets
const KM_ANALYTICS_ADSENSE_TOP_EARNING_CONTENT = 'kmAnalyticsAdSenseTopEarningContent';
const KM_ANALYTICS_ENGAGED_TRAFFIC_SOURCE = 'kmAnalyticsEngagedTrafficSource';
const KM_ANALYTICS_LEAST_ENGAGING_PAGES = 'kmAnalyticsLeastEngagingPages';
const KM_ANALYTICS_NEW_VISITORS = 'kmAnalyticsNewVisitors';
const KM_ANALYTICS_POPULAR_AUTHORS = 'kmAnalyticsPopularAuthors';
const KM_ANALYTICS_POPULAR_CONTENT = 'kmAnalyticsPopularContent';
const KM_ANALYTICS_POPULAR_PRODUCTS = 'kmAnalyticsPopularProducts';
const KM_ANALYTICS_RETURNING_VISITORS = 'kmAnalyticsReturningVisitors';
const KM_ANALYTICS_TOP_CITIES = 'kmAnalyticsTopCities';
const KM_ANALYTICS_TOP_CITIES_DRIVING_LEADS = 'kmAnalyticsTopCitiesDrivingLeads';
const KM_ANALYTICS_TOP_CITIES_DRIVING_ADD_TO_CART = 'kmAnalyticsTopCitiesDrivingAddToCart';
const KM_ANALYTICS_TOP_CITIES_DRIVING_PURCHASES = 'kmAnalyticsTopCitiesDrivingPurchases';
const KM_ANALYTICS_TOP_DEVICE_DRIVING_PURCHASES = 'kmAnalyticsTopDeviceDrivingPurchases';
const KM_ANALYTICS_TOP_CONVERTING_TRAFFIC_SOURCE = 'kmAnalyticsTopConvertingTrafficSource';
const KM_ANALYTICS_TOP_COUNTRIES = 'kmAnalyticsTopCountries';
const KM_ANALYTICS_TOP_PAGES_DRIVING_LEADS = 'kmAnalyticsTopPagesDrivingLeads';
const KM_ANALYTICS_TOP_RECENT_TRENDING_PAGES = 'kmAnalyticsTopRecentTrendingPages';
const KM_ANALYTICS_TOP_TRAFFIC_SOURCE = 'kmAnalyticsTopTrafficSource';
const KM_ANALYTICS_TOP_TRAFFIC_SOURCE_DRIVING_ADD_TO_CART = 'kmAnalyticsTopTrafficSourceDrivingAddToCart';
const KM_ANALYTICS_TOP_TRAFFIC_SOURCE_DRIVING_LEADS = 'kmAnalyticsTopTrafficSourceDrivingLeads';
const KM_ANALYTICS_TOP_TRAFFIC_SOURCE_DRIVING_PURCHASES = 'kmAnalyticsTopTrafficSourceDrivingPurchases';
const KM_ANALYTICS_PAGES_PER_VISIT = 'kmAnalyticsPagesPerVisit';
const KM_ANALYTICS_VISIT_LENGTH = 'kmAnalyticsVisitLength';
const KM_ANALYTICS_TOP_RETURNING_VISITOR_PAGES = 'kmAnalyticsTopReturningVisitorPages';
const KM_SEARCH_CONSOLE_POPULAR_KEYWORDS = 'kmSearchConsolePopularKeywords';
const KM_ANALYTICS_VISITS_PER_VISITOR = 'kmAnalyticsVisitsPerVisitor';
const KM_ANALYTICS_MOST_ENGAGING_PAGES = 'kmAnalyticsMostEngagingPages';
const KM_ANALYTICS_TOP_CATEGORIES = 'kmAnalyticsTopCategories';
const keyMetricsGA4Widgets = [KM_ANALYTICS_ADSENSE_TOP_EARNING_CONTENT, KM_ANALYTICS_ENGAGED_TRAFFIC_SOURCE, KM_ANALYTICS_LEAST_ENGAGING_PAGES, KM_ANALYTICS_NEW_VISITORS, KM_ANALYTICS_POPULAR_AUTHORS, KM_ANALYTICS_POPULAR_CONTENT, KM_ANALYTICS_POPULAR_PRODUCTS, KM_ANALYTICS_RETURNING_VISITORS, KM_ANALYTICS_TOP_CATEGORIES, KM_ANALYTICS_TOP_CITIES, KM_ANALYTICS_TOP_CITIES_DRIVING_LEADS, KM_ANALYTICS_TOP_CITIES_DRIVING_ADD_TO_CART, KM_ANALYTICS_TOP_CITIES_DRIVING_PURCHASES, KM_ANALYTICS_TOP_DEVICE_DRIVING_PURCHASES, KM_ANALYTICS_TOP_CONVERTING_TRAFFIC_SOURCE, KM_ANALYTICS_TOP_COUNTRIES, KM_ANALYTICS_TOP_RECENT_TRENDING_PAGES, KM_ANALYTICS_TOP_TRAFFIC_SOURCE, KM_ANALYTICS_TOP_TRAFFIC_SOURCE_DRIVING_ADD_TO_CART, KM_ANALYTICS_PAGES_PER_VISIT, KM_ANALYTICS_VISIT_LENGTH, KM_ANALYTICS_TOP_RETURNING_VISITOR_PAGES, KM_ANALYTICS_VISITS_PER_VISITOR, KM_ANALYTICS_MOST_ENGAGING_PAGES, KM_ANALYTICS_TOP_CATEGORIES];
const allKeyMetricsTileWidgets = [...keyMetricsGA4Widgets, KM_SEARCH_CONSOLE_POPULAR_KEYWORDS];

/***/ }),

/***/ "./js/googlesitekit/modules/create-info-store.js":
/*!*******************************************************!*\
  !*** ./js/googlesitekit/modules/create-info-store.js ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   createInfoStore: () => (/* binding */ createInfoStore)
/* harmony export */ });
/* harmony import */ var invariant__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! invariant */ "../node_modules/invariant/browser.js");
/* harmony import */ var invariant__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(invariant__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_url__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @wordpress/url */ "../node_modules/@wordpress/url/build-module/add-query-args.js");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/googlesitekit/datastore/site/constants */ "./js/googlesitekit/datastore/site/constants.js");
/* harmony import */ var _js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/googlesitekit/datastore/user/constants */ "./js/googlesitekit/datastore/user/constants.js");
/**
 * `core/modules` data store: info.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/* eslint-disable sitekit/jsdoc-no-unnamed-boolean-params */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */




// Actions
const WAIT_FOR_REAUTH_RESOLVERS = 'WAIT_FOR_REAUTH_RESOLVERS';

/**
 * Creates a store object that has selectors for managing site info.
 *
 * @since 1.10.0
 * @private
 *
 * @param {string}  slug                 Slug of the module that the store is for.
 * @param {Object}  args                 Arguments to configure the store.
 * @param {number}  args.storeName       Store name to use.
 * @param {boolean} [args.requiresSetup] Optional. Store flag, for requires setup. Default is 'true'.
 * @return {Object} The info store object.
 */
function createInfoStore(slug, {
  storeName = undefined,
  requiresSetup = true
} = {}) {
  invariant__WEBPACK_IMPORTED_MODULE_0___default()(storeName, 'storeName is required.');
  const initialState = {};
  const actions = {};
  const controls = {
    [WAIT_FOR_REAUTH_RESOLVERS]: (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.createRegistryControl)(registry => async () => {
      const {
        resolveSelect
      } = registry;
      const {
        getAuthentication,
        getConnectURL
      } = resolveSelect(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_USER);
      const {
        getSiteInfo
      } = resolveSelect(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_2__.CORE_SITE);
      await Promise.all([
      // Authentication is needed for checking `needsReauthentication`.
      getAuthentication(),
      // Site info is needed for the `adminURL`.
      getSiteInfo(),
      // `connectURL` is needed for the `reAuthURL` when reauthentication
      // is needed.
      getConnectURL()]);
    })
  };
  function reducer(state) {
    return state;
  }
  const resolvers = {
    *getAdminReauthURL() {
      yield {
        type: WAIT_FOR_REAUTH_RESOLVERS
      };
    }
  };
  const selectors = {
    /**
     * Returns admin screen URL.
     *
     * @since 1.10.0
     *
     * @param {(Object|undefined)} queryArgs Query arguments to add to admin URL.
     * @return {(string|undefined)} The admin screen URL.
     */
    getAdminScreenURL: (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.createRegistrySelector)(select => (state, queryArgs) => {
      return select(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_2__.CORE_SITE).getAdminURL('googlesitekit-dashboard', queryArgs);
    }),
    /**
     * Returns admin reauthentication URL.
     *
     * @since 1.10.0
     *
     * @param {boolean} reAuth The module activation status. Default is true.
     * @return {(string|undefined)} The admin reauthentication URL, or
     *                              undefined if not loaded yet.
     */
    getAdminReauthURL: (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.createRegistrySelector)(select => (state, reAuth = true) => {
      const needsReauthentication = select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_USER).needsReauthentication();
      if (needsReauthentication === undefined) {
        return undefined;
      }
      const noSetupQueryArgs = {};
      if (!requiresSetup && reAuth === true) {
        noSetupQueryArgs.notification = 'authentication_success';
        noSetupQueryArgs.reAuth = undefined;
      }
      const redirectURL = select(storeName).getAdminScreenURL({
        slug,
        reAuth,
        ...noSetupQueryArgs
      });
      if (redirectURL === undefined) {
        return undefined;
      }
      if (!needsReauthentication) {
        return redirectURL;
      }
      const connectURL = select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_USER).getConnectURL({
        redirectURL
      });
      return (0,_wordpress_url__WEBPACK_IMPORTED_MODULE_4__.addQueryArgs)(connectURL, {
        status: reAuth
      });
    })
  };
  return {
    STORE_NAME: storeName,
    initialState,
    actions,
    controls,
    reducer,
    resolvers,
    selectors
  };
}

/***/ }),

/***/ "./js/googlesitekit/modules/create-module-store.js":
/*!*********************************************************!*\
  !*** ./js/googlesitekit/modules/create-module-store.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   createModuleStore: () => (/* binding */ createModuleStore)
/* harmony export */ });
/* harmony import */ var invariant__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! invariant */ "../node_modules/invariant/browser.js");
/* harmony import */ var invariant__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(invariant__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _js_googlesitekit_data_create_notifications_store__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/googlesitekit/data/create-notifications-store */ "./js/googlesitekit/data/create-notifications-store.js");
/* harmony import */ var _js_googlesitekit_data_create_settings_store__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/googlesitekit/data/create-settings-store */ "./js/googlesitekit/data/create-settings-store.js");
/* harmony import */ var _js_googlesitekit_data_create_error_store__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/googlesitekit/data/create-error-store */ "./js/googlesitekit/data/create-error-store.js");
/* harmony import */ var _create_info_store__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./create-info-store */ "./js/googlesitekit/modules/create-info-store.js");
/* harmony import */ var _create_submit_changes_store__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./create-submit-changes-store */ "./js/googlesitekit/modules/create-submit-changes-store.js");
/* harmony import */ var _js_googlesitekit_data_utils__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @/js/googlesitekit/data/utils */ "./js/googlesitekit/data/utils.js");
/**
 * Provides API functions to create a datastore for a module.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * Internal dependencies
 */








/**
 * Creates a base store object for a Site Kit module.
 *
 * Every module that intends to register its own store must use this function
 * to get the base store. It can then combine the base module with its own
 * selectors and actions to individualize the store.
 *
 * The return object of this function also includes a `STORE_NAME` property,
 * the value of which must be used as the name when registering the store.
 *
 * @since 1.6.0
 *
 * @param {string}   slug                            Slug of the module that the store is for.
 * @param {Object}   args                            Arguments to consider for the store.
 * @param {number}   args.storeName                  Store name to use.
 * @param {Array}    [args.settingSlugs]             Optional. If the module store should support settings, this needs to be a list of the slugs that are part of the module and handled by the module's 'modules/{slug}/data/settings' API endpoint. Default is undefined.
 * @param {Array}    [args.ownedSettingsSlugs]       Optional. List of "owned settings" for this module, if they exist.
 * @param {Object}   [args.initialSettings]          Optional. An initial set of settings for the module as key-value pairs.
 * @param {boolean}  [args.requiresSetup]            Optional. Store flag for requires setup. Default is 'true'.
 * @param {Function} [args.submitChanges]            Optional. Submit settings changes handler.
 * @param {Function} [args.rollbackChanges]          Optional. Rollbacks settings changes handler.
 * @param {Function} [args.validateCanSubmitChanges] Optional. A function to validate whether module settings can be submitted.
 * @param {Function} [args.validateIsSetupBlocked]   Optional. A function to validate whether module setup is terminally blocked from continuing.
 * @return {Object} The base module store object, with additional `STORE_NAME` and
 *                  `initialState` properties.
 */
function createModuleStore(slug, args = {}) {
  const {
    storeName,
    settingSlugs,
    ownedSettingsSlugs = undefined,
    initialSettings = undefined,
    requiresSetup = true,
    submitChanges,
    rollbackChanges,
    validateHaveSettingsChanged = null,
    validateCanSubmitChanges,
    validateIsSetupBlocked = undefined
  } = args;
  invariant__WEBPACK_IMPORTED_MODULE_0___default()(slug, 'slug is required.');
  invariant__WEBPACK_IMPORTED_MODULE_0___default()(storeName, 'storeName is required.');
  const notificationsStore = (0,_js_googlesitekit_data_create_notifications_store__WEBPACK_IMPORTED_MODULE_2__.createNotificationsStore)('modules', slug, 'notifications', {
    storeName
  });
  const infoStore = (0,_create_info_store__WEBPACK_IMPORTED_MODULE_5__.createInfoStore)(slug, {
    storeName,
    requiresSetup
  });
  const setupBlockedStore = {};
  if (requiresSetup && validateIsSetupBlocked) {
    const {
      safeSelector: isSetupBlocked,
      dangerousSelector: __dangerousIsSetupBlocked
    } = (0,_js_googlesitekit_data_utils__WEBPACK_IMPORTED_MODULE_7__.createValidationSelector)(validateIsSetupBlocked, {
      negate: true
    });
    setupBlockedStore.selectors = {
      isSetupBlocked,
      __dangerousIsSetupBlocked
    };
  }
  let combinedStore = {};
  if ('undefined' !== typeof settingSlugs) {
    const settingsStore = (0,_js_googlesitekit_data_create_settings_store__WEBPACK_IMPORTED_MODULE_3__.createSettingsStore)('modules', slug, 'settings', {
      ownedSettingsSlugs,
      storeName,
      settingSlugs,
      initialSettings,
      validateHaveSettingsChanged: validateHaveSettingsChanged || (0,_js_googlesitekit_data_create_settings_store__WEBPACK_IMPORTED_MODULE_3__.makeDefaultHaveSettingsChanged)()
    });
    const submitChangesStore = (0,_create_submit_changes_store__WEBPACK_IMPORTED_MODULE_6__.createSubmitChangesStore)({
      submitChanges: submitChanges || (0,_js_googlesitekit_data_create_settings_store__WEBPACK_IMPORTED_MODULE_3__.makeDefaultSubmitChanges)(slug, storeName),
      rollbackChanges: rollbackChanges || (0,_js_googlesitekit_data_create_settings_store__WEBPACK_IMPORTED_MODULE_3__.makeDefaultRollbackChanges)(storeName),
      validateCanSubmitChanges: validateCanSubmitChanges || (0,_js_googlesitekit_data_create_settings_store__WEBPACK_IMPORTED_MODULE_3__.makeDefaultCanSubmitChanges)(storeName)
    });

    // To prevent duplication errors during combining stores, we don't need to combine
    // commonStore here since settingsStore already uses commonActions and commonControls
    // from the commonStore.
    combinedStore = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.combineStores)(notificationsStore, settingsStore, submitChangesStore, infoStore, (0,_js_googlesitekit_data_create_error_store__WEBPACK_IMPORTED_MODULE_4__.createErrorStore)(storeName), setupBlockedStore);
  } else {
    combinedStore = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.combineStores)(googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.commonStore, notificationsStore, infoStore, setupBlockedStore, (0,_js_googlesitekit_data_create_error_store__WEBPACK_IMPORTED_MODULE_4__.createErrorStore)(storeName), (0,_create_submit_changes_store__WEBPACK_IMPORTED_MODULE_6__.createSubmitChangesStore)({
      submitChanges,
      validateCanSubmitChanges
    }));
  }
  combinedStore.STORE_NAME = storeName;
  return combinedStore;
}

/***/ }),

/***/ "./js/googlesitekit/modules/create-submit-changes-store.js":
/*!*****************************************************************!*\
  !*** ./js/googlesitekit/modules/create-submit-changes-store.js ***!
  \*****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   createSubmitChangesStore: () => (/* binding */ createSubmitChangesStore)
/* harmony export */ });
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _js_googlesitekit_data_utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/googlesitekit/data/utils */ "./js/googlesitekit/data/utils.js");
/* harmony import */ var _js_googlesitekit_data_create_error_store__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/googlesitekit/data/create-error-store */ "./js/googlesitekit/data/create-error-store.js");
/**
 * API function to create submit changes store.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Internal dependencies
 */




// Get access to error store action creators.
// If the parent store doesn't include the error store,
// yielded error actions will be a no-op.
const {
  clearError,
  receiveError
} = _js_googlesitekit_data_create_error_store__WEBPACK_IMPORTED_MODULE_2__.actions;

// Actions
const SUBMIT_CHANGES = 'SUBMIT_CHANGES';
const ROLLBACK_CHANGES = 'ROLLBACK_CHANGES';
const START_SUBMIT_CHANGES = 'START_SUBMIT_CHANGES';
const FINISH_SUBMIT_CHANGES = 'FINISH_SUBMIT_CHANGES';

/**
 * Creates a store object implementing the necessary infrastructure for submitting module settings.
 *
 * @since 1.21.0
 *
 * @param {Object}   args                            Arguments for creating the submitChanges store.
 * @param {Function} [args.submitChanges]            Optional. Callback function to issue the submit changes request. Will be used inside the submit changes control.
 * @param {Function} [args.rollbackChanges]          Optional. Callback function to rollback module settings changes.
 * @param {Function} [args.validateCanSubmitChanges] Optional. A helper function to validate that settings can be submitted.
 * @return {Object} Partial store object with properties 'actions', 'controls', 'reducer', 'resolvers', and 'selectors'.
 */
function createSubmitChangesStore(args) {
  const {
    submitChanges = () => ({}),
    rollbackChanges = () => ({}),
    validateCanSubmitChanges = () => {}
  } = args || {};
  const initialState = {
    isDoingSubmitChanges: false
  };
  const actions = {
    /**
     * Submits all changes currently present in the client, persisting them on the server.
     *
     * @since 1.21.0
     *
     * @return {Object} Empty object on success, object with `error` property on failure.
     */
    *submitChanges() {
      yield clearError('submitChanges', []);
      yield {
        type: START_SUBMIT_CHANGES,
        payload: {}
      };
      const result = yield {
        type: SUBMIT_CHANGES,
        payload: {}
      };
      if (result?.error) {
        yield receiveError(result.error, 'submitChanges', []);
      }
      yield {
        type: FINISH_SUBMIT_CHANGES,
        payload: {}
      };
      return result;
    },
    /**
     * Rolls back changes.
     *
     * @since 1.45.0
     *
     * @return {Object} Empty object on success, object with `error` property on failure.
     */
    *rollbackChanges() {
      const result = yield {
        type: ROLLBACK_CHANGES,
        payload: {}
      };
      return result;
    }
  };
  const reducer = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.createReducer)((state, {
    type
  }) => {
    switch (type) {
      case START_SUBMIT_CHANGES:
        state.isDoingSubmitChanges = true;
        break;
      case FINISH_SUBMIT_CHANGES:
        state.isDoingSubmitChanges = false;
        break;
      default:
        break;
    }
  });
  const controls = {
    [SUBMIT_CHANGES]: (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.createRegistryControl)(registry => (...actionArgs) => submitChanges(registry, ...actionArgs)),
    [ROLLBACK_CHANGES]: (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.createRegistryControl)(registry => (...actionArgs) => rollbackChanges(registry, ...actionArgs))
  };
  const resolvers = {};
  const {
    safeSelector: canSubmitChanges,
    dangerousSelector: __dangerousCanSubmitChanges
  } = (0,_js_googlesitekit_data_utils__WEBPACK_IMPORTED_MODULE_1__.createValidationSelector)(validateCanSubmitChanges);
  const selectors = {
    canSubmitChanges,
    __dangerousCanSubmitChanges,
    /**
     * Checks whether changes are currently being submitted.
     *
     * @since 1.21.0
     *
     * @param {Object} state Data store's state.
     * @return {boolean} TRUE if submitting, otherwise FALSE.
     */
    isDoingSubmitChanges(state) {
      return !!state.isDoingSubmitChanges;
    }
  };
  return {
    initialState,
    actions,
    controls,
    reducer,
    resolvers,
    selectors
  };
}

/***/ }),

/***/ "./js/googlesitekit/modules/datastore/constants.js":
/*!*********************************************************!*\
  !*** ./js/googlesitekit/modules/datastore/constants.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   CORE_MODULES: () => (/* binding */ CORE_MODULES),
/* harmony export */   ERROR_CODE_INSUFFICIENT_MODULE_DEPENDENCIES: () => (/* binding */ ERROR_CODE_INSUFFICIENT_MODULE_DEPENDENCIES)
/* harmony export */ });
/**
 * `core/modules` data store: constants.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

const CORE_MODULES = 'core/modules';
const ERROR_CODE_INSUFFICIENT_MODULE_DEPENDENCIES = 'insufficient_module_dependencies';

/***/ }),

/***/ "./js/googlesitekit/modules/datastore/index.js":
/*!*****************************************************!*\
  !*** ./js/googlesitekit/modules/datastore/index.js ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   actions: () => (/* binding */ actions),
/* harmony export */   controls: () => (/* binding */ controls),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   initialState: () => (/* binding */ initialState),
/* harmony export */   reducer: () => (/* binding */ reducer),
/* harmony export */   registerStore: () => (/* binding */ registerStore),
/* harmony export */   resolvers: () => (/* binding */ resolvers),
/* harmony export */   selectors: () => (/* binding */ selectors)
/* harmony export */ });
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _settings_panel__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./settings-panel */ "./js/googlesitekit/modules/datastore/settings-panel.js");
/* harmony import */ var _settings__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./settings */ "./js/googlesitekit/modules/datastore/settings.js");
/* harmony import */ var _modules__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./modules */ "./js/googlesitekit/modules/datastore/modules.js");
/* harmony import */ var _sharing_settings__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./sharing-settings */ "./js/googlesitekit/modules/datastore/sharing-settings.js");
/* harmony import */ var _js_googlesitekit_data_create_error_store__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/googlesitekit/data/create-error-store */ "./js/googlesitekit/data/create-error-store.js");
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./constants */ "./js/googlesitekit/modules/datastore/constants.js");
/**
 * `core/modules` data store
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Internal dependencies
 */







const store = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.combineStores)(googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.commonStore, _modules__WEBPACK_IMPORTED_MODULE_3__["default"], (0,_js_googlesitekit_data_create_error_store__WEBPACK_IMPORTED_MODULE_5__.createErrorStore)(_constants__WEBPACK_IMPORTED_MODULE_6__.CORE_MODULES), _settings_panel__WEBPACK_IMPORTED_MODULE_1__["default"], _settings__WEBPACK_IMPORTED_MODULE_2__["default"], _sharing_settings__WEBPACK_IMPORTED_MODULE_4__["default"]);
const initialState = store.initialState;
const actions = store.actions;
const controls = store.controls;
const reducer = store.reducer;
const resolvers = store.resolvers;
const selectors = store.selectors;
function registerStore(registry) {
  registry.registerStore(_constants__WEBPACK_IMPORTED_MODULE_6__.CORE_MODULES, store);
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (store);

/***/ }),

/***/ "./js/googlesitekit/modules/datastore/modules.js":
/*!*******************************************************!*\
  !*** ./js/googlesitekit/modules/datastore/modules.js ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   actions: () => (/* binding */ actions),
/* harmony export */   baseControls: () => (/* binding */ baseControls),
/* harmony export */   controls: () => (/* binding */ controls),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   initialState: () => (/* binding */ initialState),
/* harmony export */   reducer: () => (/* binding */ reducer),
/* harmony export */   resolvers: () => (/* binding */ resolvers),
/* harmony export */   selectors: () => (/* binding */ selectors)
/* harmony export */ });
/* harmony import */ var memize__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! memize */ "../node_modules/memize/index.js");
/* harmony import */ var memize__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(memize__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var invariant__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! invariant */ "../node_modules/invariant/browser.js");
/* harmony import */ var invariant__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(invariant__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! lodash */ "../node_modules/lodash/lodash.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var googlesitekit_api__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! googlesitekit-api */ "googlesitekit-api");
/* harmony import */ var googlesitekit_api__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_api__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./constants */ "./js/googlesitekit/modules/datastore/constants.js");
/* harmony import */ var _js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @/js/googlesitekit/datastore/site/constants */ "./js/googlesitekit/datastore/site/constants.js");
/* harmony import */ var _js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @/js/googlesitekit/datastore/user/constants */ "./js/googlesitekit/datastore/user/constants.js");
/* harmony import */ var _js_googlesitekit_data_create_fetch_store__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @/js/googlesitekit/data/create-fetch-store */ "./js/googlesitekit/data/create-fetch-store.js");
/* harmony import */ var _js_util__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @/js/util */ "./js/util/index.js");
/* harmony import */ var _js_components_settings_DefaultSettingsSetupIncomplete__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @/js/components/settings/DefaultSettingsSetupIncomplete */ "./js/components/settings/DefaultSettingsSetupIncomplete.js");
/* harmony import */ var _js_googlesitekit_data_utils__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! @/js/googlesitekit/data/utils */ "./js/googlesitekit/data/utils.js");
/**
 * `core/modules` data store: module info.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/* eslint-disable sitekit/jsdoc-no-unnamed-boolean-params */

/**
 * External dependencies
 */




/**
 * WordPress dependencies
 */
// This is used for JSDoc purposes.
// eslint-disable-next-line no-unused-vars



/**
 * Internal dependencies
 */










// Actions.
const REFETCH_AUTHENTICATION = 'REFETCH_AUTHENTICATION';
const SELECT_MODULE_REAUTH_URL = 'SELECT_MODULE_REAUTH_URL';
const REGISTER_MODULE = 'REGISTER_MODULE';
const RECEIVE_CHECK_REQUIREMENTS_ERROR = 'RECEIVE_CHECK_REQUIREMENTS_ERROR';
const RECEIVE_CHECK_REQUIREMENTS_SUCCESS = 'RECEIVE_CHECK_REQUIREMENTS_SUCCESS';
const RECEIVE_RECOVERABLE_MODULES = 'RECEIVE_RECOVERABLE_MODULES';
const RECEIVE_SHARED_OWNERSHIP_MODULES = 'RECEIVE_SHARED_OWNERSHIP_MODULES';
const CLEAR_RECOVERED_MODULES = 'CLEAR_RECOVERED_MODULES';
const RECEIVE_INLINE_MODULES_DATA = 'RECEIVE_INLINE_MODULES_DATA';
const moduleDefaults = {
  slug: '',
  storeName: null,
  name: '',
  description: '',
  homepage: null,
  internal: false,
  active: false,
  connected: false,
  dependencies: [],
  dependants: [],
  order: 10,
  features: [],
  Icon: null,
  SettingsEditComponent: null,
  SettingsViewComponent: null,
  SettingsSetupIncompleteComponent: _js_components_settings_DefaultSettingsSetupIncomplete__WEBPACK_IMPORTED_MODULE_11__["default"],
  SetupComponent: null,
  onCompleteSetup: undefined,
  checkRequirements: () => true,
  DashboardMainEffectComponent: null,
  DashboardEntityEffectComponent: null
};
const normalizeModules = memize__WEBPACK_IMPORTED_MODULE_0___default()((serverDefinitions, clientDefinitions) => {
  // Module properties in `clientDefinitions` will overwrite `serverDefinitions`
  // but only for keys whose values are not `undefined`.
  const modules = (0,lodash__WEBPACK_IMPORTED_MODULE_2__.merge)({}, serverDefinitions, clientDefinitions);
  return Object.keys(modules).map(slug => {
    const module = {
      ...modules[slug],
      slug
    };
    // Fill any `undefined` values with defaults.
    (0,lodash__WEBPACK_IMPORTED_MODULE_2__.defaults)(module, {
      name: slug
    }, moduleDefaults);
    return module;
  }).sort((a, b) => a.order - b.order || a.name?.localeCompare(b.name)).reduce((acc, module) => {
    return {
      ...acc,
      [module.slug]: module
    };
  }, {});
});

/**
 * Gets a memoized object mapping recoverable module slugs to their corresponding
 * module objects.
 *
 * @since 1.78.0
 *
 * @param {Object} modules            Module definitions.
 * @param {Array}  recoverableModules Array of recoverable module slugs.
 * @return {Object} Map of recoverable module slugs to their corresponding module objects.
 */
const calculateRecoverableModules = memize__WEBPACK_IMPORTED_MODULE_0___default()((modules, recoverableModules) => Object.values(modules).reduce((recoverable, module) => {
  if (recoverableModules.includes(module.slug)) {
    return {
      ...recoverable,
      [module.slug]: module
    };
  }
  return recoverable;
}, {}));
const fetchGetModulesStore = (0,_js_googlesitekit_data_create_fetch_store__WEBPACK_IMPORTED_MODULE_9__.createFetchStore)({
  baseName: 'getModules',
  controlCallback: () => {
    return (0,googlesitekit_api__WEBPACK_IMPORTED_MODULE_4__.get)('core', 'modules', 'list', null, {
      useCache: false
    });
  },
  reducerCallback: (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_5__.createReducer)((state, modules) => {
    state.isAwaitingModulesRefresh = false;
    state.serverDefinitions = modules.reduce((acc, module) => {
      return {
        ...acc,
        [module.slug]: module
      };
    }, {});
  })
});
const fetchSetModuleActivationStore = (0,_js_googlesitekit_data_create_fetch_store__WEBPACK_IMPORTED_MODULE_9__.createFetchStore)({
  baseName: 'setModuleActivation',
  controlCallback: ({
    slug,
    active
  }) => {
    return (0,googlesitekit_api__WEBPACK_IMPORTED_MODULE_4__.set)('core', 'modules', 'activation', {
      slug,
      active
    });
  },
  reducerCallback: (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_5__.createReducer)(state => {
    // Updated module activation state is handled by re-fetching module
    // data instead, so this reducer just sets the below flag.
    state.isAwaitingModulesRefresh = true;
  }),
  argsToParams: (slug, active) => {
    return {
      slug,
      active
    };
  },
  validateParams: ({
    slug,
    active
  } = {}) => {
    invariant__WEBPACK_IMPORTED_MODULE_1___default()(slug, 'slug is required.');
    invariant__WEBPACK_IMPORTED_MODULE_1___default()(active !== undefined, 'active is required.');
  }
});
const fetchCheckModuleAccessStore = (0,_js_googlesitekit_data_create_fetch_store__WEBPACK_IMPORTED_MODULE_9__.createFetchStore)({
  baseName: 'checkModuleAccess',
  controlCallback: ({
    slug
  }) => {
    return (0,googlesitekit_api__WEBPACK_IMPORTED_MODULE_4__.set)('core', 'modules', 'check-access', {
      slug
    });
  },
  reducerCallback: (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_5__.createReducer)((state, {
    access
  }, {
    slug
  }) => {
    state.moduleAccess[slug] = access;
  }),
  argsToParams: slug => {
    return {
      slug
    };
  },
  validateParams: ({
    slug
  }) => {
    invariant__WEBPACK_IMPORTED_MODULE_1___default()(slug, 'slug is required.');
  }
});
const fetchRecoverModulesStore = (0,_js_googlesitekit_data_create_fetch_store__WEBPACK_IMPORTED_MODULE_9__.createFetchStore)({
  baseName: 'recoverModules',
  controlCallback: ({
    slugs
  }) => {
    return (0,googlesitekit_api__WEBPACK_IMPORTED_MODULE_4__.set)('core', 'modules', 'recover-modules', {
      slugs
    });
  },
  reducerCallback: (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_5__.createReducer)((state, recoveredModules) => {
    state.recoveredModules = recoveredModules;
  }),
  argsToParams: slugs => {
    return {
      slugs
    };
  },
  validateParams: ({
    slugs
  }) => {
    invariant__WEBPACK_IMPORTED_MODULE_1___default()(slugs, 'slugs is required.');
  }
});
const baseInitialState = {
  clientDefinitions: {},
  serverDefinitions: undefined,
  // This value is to indicate that modules data needs to be refreshed after
  // a module activation update, since the activation is technically complete
  // before this data has been refreshed.
  isAwaitingModulesRefresh: false,
  checkRequirementsResults: {},
  moduleAccess: {},
  recoverableModules: undefined,
  sharedOwnershipModules: undefined,
  recoveredModules: undefined,
  inlineModulesData: undefined
};
const baseActions = {
  /**
   * Activates a module on the server.
   *
   * Activate a module (based on the slug provided).
   *
   * @since 1.8.0
   *
   * @param {string} slug Slug of the module to activate.
   * @return {Object} Object with `{response, error}`. On success, `response.moduleReauthURL`
   *                  is set to redirect the user to the corresponding module setup or OAuth
   *                  consent screen.
   */
  *activateModule(slug) {
    const {
      response,
      error
    } = yield baseActions.setModuleActivation(slug, true);
    if (response?.success === true) {
      const moduleReauthURL = yield {
        payload: {
          slug
        },
        type: SELECT_MODULE_REAUTH_URL
      };
      return {
        response: {
          ...response,
          moduleReauthURL
        },
        error
      };
    }
    return {
      response,
      error
    };
  },
  /**
   * Deactivates a module on the server.
   *
   * Deactivate a module (based on the slug provided).
   *
   * @since 1.8.0
   *
   * @param {string} slug Slug of the module to activate.
   * @return {Object}      Object with `{response, error}`.
   */
  *deactivateModule(slug) {
    const {
      response,
      error
    } = yield baseActions.setModuleActivation(slug, false);
    return {
      response,
      error
    };
  },
  /**
   * (De)activates a module on the server.
   *
   * POSTs to the `core/modules/activation` endpoint to set the `active` status
   * supplied for the give `slug`.
   *
   * @since 1.8.0
   * @private
   *
   * @param {string}  slug   Slug of the module to activate/deactivate.
   * @param {boolean} active `true` to activate; `false` to deactivate.
   * @return {Object}         Object with `{response, error}`.
   */
  setModuleActivation: (0,_js_googlesitekit_data_utils__WEBPACK_IMPORTED_MODULE_12__.createValidatedAction)((slug, active) => {
    invariant__WEBPACK_IMPORTED_MODULE_1___default()(slug, 'slug is required.');
    invariant__WEBPACK_IMPORTED_MODULE_1___default()(active !== undefined, 'active is required.');
  }, function* (slug, active) {
    const {
      response,
      error
    } = yield fetchSetModuleActivationStore.actions.fetchSetModuleActivation(slug, active);
    if (response?.success === true) {
      // Fetch (or re-fetch) all modules, with their updated status.
      // TODO: This is temporary disabled until Site Kit no longer relies
      // on page reloads between module activation changes.
      // yield fetchGetModulesStore.actions.fetchGetModules();

      yield {
        payload: {},
        type: REFETCH_AUTHENTICATION
      };
    }
    return {
      response,
      error
    };
  }),
  /**
   * Registers a module.
   *
   * @since 1.13.0
   * @since 1.20.0 Introduced the ability to register settings and setup components.
   * @since 1.22.0 Introduced the ability to add a checkRequirements function.
   * @since 1.23.0 Introduced the ability to register an Icon component.
   * @since 1.24.0 Introduced the ability to explictly define a module store name.
   *
   * @param {string}         slug                                        Module slug.
   * @param {Object}         [settings]                                  Optional. Module settings.
   * @param {string}         [settings.storeName]                        Optional. Module storeName. If none is provided we assume no store exists for this module.
   * @param {string}         [settings.name]                             Optional. Module name. Default is the slug.
   * @param {string}         [settings.description]                      Optional. Module description. Default empty string.
   * @param {Array.<string>} [settings.features]                         Optional. Module features. Default empty array.
   * @param {WPComponent}    [settings.Icon]                             Optional. React component to render module icon. Default none.
   * @param {number}         [settings.order]                            Optional. Numeric indicator for module order. Default 10.
   * @param {string}         [settings.homepage]                         Optional. Module homepage URL. Default empty string.
   * @param {WPComponent}    [settings.SettingsEditComponent]            Optional. React component to render the settings edit panel. Default none.
   * @param {WPComponent}    [settings.SettingsViewComponent]            Optional. React component to render the settings view panel. Default none.
   * @param {WPComponent}    [settings.SettingsSetupIncompleteComponent] Optional. React component to render the incomplete settings panel. Default none.
   * @param {WPComponent}    [settings.SetupComponent]                   Optional. React component to render the setup panel. Default none.
   * @param {boolean}        [settings.overrideSetupSuccessNotification] Optional. Flag to denote whether to render a custom setup success notification. Default `false`.
   * @param {Function}       [settings.onCompleteSetup]                  Optional. Function to use as a complete CTA callback. Default `undefined`.
   * @param {Function}       [settings.checkRequirements]                Optional. Function to check requirements for the module. Throws a WP error object for error or returns on success.
   * @param {WPComponent}    [settings.DashboardMainEffectComponent]     Optional. React component to render the effects on main dashboard. Default none.
   * @param {WPComponent}    [settings.DashboardEntityEffectComponent]   Optional. React component to render the effects on entity dashboard. Default none.
   */
  registerModule: (0,_js_googlesitekit_data_utils__WEBPACK_IMPORTED_MODULE_12__.createValidatedAction)(slug => {
    invariant__WEBPACK_IMPORTED_MODULE_1___default()(slug, 'module slug is required');
  }, function* (slug, {
    storeName,
    name,
    description,
    features,
    Icon,
    order,
    homepage,
    SettingsEditComponent,
    SettingsViewComponent,
    SettingsSetupIncompleteComponent,
    SetupComponent,
    overrideSetupSuccessNotification = false,
    onCompleteSetup,
    checkRequirements,
    DashboardMainEffectComponent,
    DashboardEntityEffectComponent
  } = {}) {
    const settings = {
      storeName,
      name,
      description,
      features,
      Icon,
      order,
      homepage,
      SettingsEditComponent,
      SettingsViewComponent,
      SettingsSetupIncompleteComponent,
      SetupComponent,
      overrideSetupSuccessNotification,
      onCompleteSetup,
      checkRequirements,
      DashboardMainEffectComponent,
      DashboardEntityEffectComponent
    };
    yield {
      payload: {
        settings,
        slug
      },
      type: REGISTER_MODULE
    };
    const registry = yield googlesitekit_data__WEBPACK_IMPORTED_MODULE_5__.commonActions.getRegistry();

    // As we can specify a custom checkRequirements function here, we're
    // invalidating the resolvers for activation checks.
    registry.dispatch(_constants__WEBPACK_IMPORTED_MODULE_6__.CORE_MODULES).invalidateResolution('canActivateModule', [slug]);
    registry.dispatch(_constants__WEBPACK_IMPORTED_MODULE_6__.CORE_MODULES).invalidateResolution('getCheckRequirementsError', [slug]);
  }),
  /**
   * Receives the check requirements error map for specified modules modules.
   *
   * @since 1.22.0
   * @private
   *
   * @param {string} slug  Module slug.
   * @param {Object} error WordPress Error object containing code, message and data properties.
   * @return {Object} Action for RECEIVE_CHECK_REQUIREMENTS_ERROR.
   */
  receiveCheckRequirementsError(slug, error) {
    invariant__WEBPACK_IMPORTED_MODULE_1___default()(slug, 'slug is required');
    invariant__WEBPACK_IMPORTED_MODULE_1___default()((0,lodash__WEBPACK_IMPORTED_MODULE_2__.isPlainObject)(error), 'error is required and must be an object');
    return {
      payload: {
        slug,
        error
      },
      type: RECEIVE_CHECK_REQUIREMENTS_ERROR
    };
  },
  /**
   * Receives the check requirements success for a module.
   *
   * @since 1.22.0
   * @private
   *
   * @param {string} slug Success for a module slug.
   * @return {Object} Action for RECEIVE_CHECK_REQUIREMENTS_SUCCESS.
   */
  receiveCheckRequirementsSuccess(slug) {
    invariant__WEBPACK_IMPORTED_MODULE_1___default()(slug, 'slug is required');
    return {
      payload: {
        slug
      },
      type: RECEIVE_CHECK_REQUIREMENTS_SUCCESS
    };
  },
  /**
   * Receives the recoverable modules for dashboard sharing.
   * Stores recoverable modules in the datastore.
   *
   * @since 1.74.0
   * @private
   *
   * @param {Object} recoverableModules List of recoverable modules.
   * @return {Object} Action for RECEIVE_RECOVERABLE_MODULES.
   */
  receiveRecoverableModules(recoverableModules) {
    invariant__WEBPACK_IMPORTED_MODULE_1___default()(recoverableModules, 'recoverableModules is required.');
    return {
      payload: {
        recoverableModules
      },
      type: RECEIVE_RECOVERABLE_MODULES
    };
  },
  /**
   * Recovers multiple modules on the server.
   *
   * Recovers multiple modules (based on the slugs provided).
   *
   * @since 1.77.0
   *
   * @param {Array.<string>} slugs Array of slugs of the modules to recover.
   * @return {Object} Object with `{response, error}`.
   */
  recoverModules: (0,_js_googlesitekit_data_utils__WEBPACK_IMPORTED_MODULE_12__.createValidatedAction)(slugs => {
    invariant__WEBPACK_IMPORTED_MODULE_1___default()(Array.isArray(slugs), 'slugs must be an array');
  }, function* (slugs) {
    const {
      dispatch,
      select
    } = yield googlesitekit_data__WEBPACK_IMPORTED_MODULE_5__.commonActions.getRegistry();
    const {
      response
    } = yield fetchRecoverModulesStore.actions.fetchRecoverModules(slugs);
    const {
      success
    } = response;
    const successfulRecoveries = Object.keys(success).filter(slug => !!success[slug]);
    for (const slug of successfulRecoveries) {
      const storeName = select(_constants__WEBPACK_IMPORTED_MODULE_6__.CORE_MODULES).getModuleStoreName(slug);

      // Reload the module's settings from the server.
      yield googlesitekit_data__WEBPACK_IMPORTED_MODULE_5__.commonActions.await(dispatch(storeName).fetchGetSettings());
    }
    if (successfulRecoveries.length) {
      // Reload all modules from the server.
      yield fetchGetModulesStore.actions.fetchGetModules();

      // Having reloaded the modules from the server, ensure the list of recoverable modules is also refreshed,
      // as the recoverable modules list is derived from the main list of modules.
      dispatch(_constants__WEBPACK_IMPORTED_MODULE_6__.CORE_MODULES).invalidateResolution('getRecoverableModules', []);

      // Refresh user capabilities from the server.
      yield googlesitekit_data__WEBPACK_IMPORTED_MODULE_5__.commonActions.await(dispatch(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_8__.CORE_USER).refreshCapabilities());
    }
    return {
      response
    };
  }),
  /**
   * Receives the shared ownership modules for dashboard sharing.
   * Stores shared ownership modules in the datastore.
   *
   * Because this is frequently-accessed data, this is usually sourced
   * from a global variable (`_googlesitekitDashboardSharingData`), set by PHP
   * in the `before_print` callback for `googlesitekit-datastore-site`.
   *
   * @since 1.77.0
   * @private
   *
   * @param {Object} sharedOwnershipModules Shared ownership modules, usually supplied via a global variable from PHP.
   * @return {Object} Action for RECEIVE_SHARED_OWNERSHIP_MODULES.
   */
  receiveSharedOwnershipModules(sharedOwnershipModules) {
    invariant__WEBPACK_IMPORTED_MODULE_1___default()(sharedOwnershipModules, 'sharedOwnershipModules is required.');
    return {
      payload: {
        sharedOwnershipModules
      },
      type: RECEIVE_SHARED_OWNERSHIP_MODULES
    };
  },
  /**
   * Clears the recoveredModules in the state.
   *
   * @since 1.87.0
   *
   * @return {Object} Action for RECEIVE_SHARED_OWNERSHIP_MODULES.
   */
  clearRecoveredModules() {
    return {
      payload: {},
      type: CLEAR_RECOVERED_MODULES
    };
  },
  /**
   * Receives inline modules data.
   * Stores inline modules data in the datastore.
   *
   * Because this is frequently-accessed data, this is usually sourced
   * from a global variable (`_googlesitekitModulesData`), set by PHP
   * in the `before_print` callback for `googlesitekit-modules`.
   *
   * @since 1.162.0
   * @private
   *
   * @param {Object} inlineModulesData Inline modules data, usually supplied via a global variable from PHP.
   * @return {Object} Action for RECEIVE_INLINE_MODULES_DATA.
   */
  receiveInlineModulesData: (0,_js_googlesitekit_data_utils__WEBPACK_IMPORTED_MODULE_12__.createValidatedAction)(inlineModulesData => {
    invariant__WEBPACK_IMPORTED_MODULE_1___default()(inlineModulesData, 'inlineModulesData is required');
  }, inlineModulesData => {
    return {
      payload: {
        inlineModulesData
      },
      type: RECEIVE_INLINE_MODULES_DATA
    };
  })
};
const baseControls = {
  [REFETCH_AUTHENTICATION]: (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_5__.createRegistryControl)(({
    dispatch
  }) => () => {
    return dispatch(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_8__.CORE_USER).fetchGetAuthentication();
  }),
  [SELECT_MODULE_REAUTH_URL]: (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_5__.createRegistryControl)(({
    select,
    resolveSelect
  }) => async ({
    payload
  }) => {
    const {
      slug
    } = payload;
    // Ensure the module is loaded before selecting the store name.
    await resolveSelect(_constants__WEBPACK_IMPORTED_MODULE_6__.CORE_MODULES).getModule(slug);
    const storeName = select(_constants__WEBPACK_IMPORTED_MODULE_6__.CORE_MODULES).getModuleStoreName(slug);

    // If a storeName wasn't specified on registerModule we assume there is no store for this module
    if (!storeName) {
      return null;
    }
    if (select(storeName)?.getAdminReauthURL) {
      return await resolveSelect(storeName).getAdminReauthURL();
    }
    return select(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_7__.CORE_SITE).getAdminURL('googlesitekit-dashboard');
  })
};
const baseReducer = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_5__.createReducer)((state, {
  type,
  payload
}) => {
  switch (type) {
    case REGISTER_MODULE:
      {
        const {
          slug,
          settings
        } = payload;
        if (!!state.clientDefinitions[slug]) {
          __webpack_require__.g.console.warn(`Could not register module with slug "${slug}". Module "${slug}" is already registered.`);
          return;
        }
        state.clientDefinitions[slug] = settings;
        break;
      }
    case RECEIVE_CHECK_REQUIREMENTS_ERROR:
      {
        const {
          slug,
          error
        } = payload;
        state.checkRequirementsResults[slug] = error;
        break;
      }
    case RECEIVE_CHECK_REQUIREMENTS_SUCCESS:
      {
        const {
          slug
        } = payload;
        state.checkRequirementsResults[slug] = true;
        break;
      }
    case RECEIVE_RECOVERABLE_MODULES:
      {
        const {
          recoverableModules
        } = payload;
        state.recoverableModules = recoverableModules;
        break;
      }
    case RECEIVE_SHARED_OWNERSHIP_MODULES:
      {
        const {
          sharedOwnershipModules
        } = payload;
        state.sharedOwnershipModules = sharedOwnershipModules;
        break;
      }
    case CLEAR_RECOVERED_MODULES:
      {
        state.recoveredModules = undefined;
        break;
      }
    case RECEIVE_INLINE_MODULES_DATA:
      {
        const {
          inlineModulesData
        } = payload;
        state.inlineModulesData = inlineModulesData;
        break;
      }
    default:
      break;
  }
});
function* waitForModules() {
  const {
    resolveSelect
  } = yield googlesitekit_data__WEBPACK_IMPORTED_MODULE_5__.commonActions.getRegistry();
  yield googlesitekit_data__WEBPACK_IMPORTED_MODULE_5__.commonActions.await(resolveSelect(_constants__WEBPACK_IMPORTED_MODULE_6__.CORE_MODULES).getModules());
}
function* waitForModulesInlineData() {
  const {
    resolveSelect
  } = yield googlesitekit_data__WEBPACK_IMPORTED_MODULE_5__.commonActions.getRegistry();
  yield googlesitekit_data__WEBPACK_IMPORTED_MODULE_5__.commonActions.await(resolveSelect(_constants__WEBPACK_IMPORTED_MODULE_6__.CORE_MODULES).getInlineModulesData());
}
const baseResolvers = {
  *getModules() {
    const registry = yield googlesitekit_data__WEBPACK_IMPORTED_MODULE_5__.commonActions.getRegistry();
    const existingModules = registry.select(_constants__WEBPACK_IMPORTED_MODULE_6__.CORE_MODULES).getModules();
    if (!existingModules) {
      yield fetchGetModulesStore.actions.fetchGetModules();
    }
  },
  *canActivateModule(slug) {
    const registry = yield googlesitekit_data__WEBPACK_IMPORTED_MODULE_5__.commonActions.getRegistry();
    const {
      select,
      resolveSelect
    } = registry;
    const module = yield googlesitekit_data__WEBPACK_IMPORTED_MODULE_5__.commonActions.await(resolveSelect(_constants__WEBPACK_IMPORTED_MODULE_6__.CORE_MODULES).getModule(slug));
    // At this point, all modules are loaded so we can safely select getModule below.

    if (!module) {
      return;
    }
    const inactiveModules = [];
    module.dependencies.forEach(dependencySlug => {
      const dependedentModule = select(_constants__WEBPACK_IMPORTED_MODULE_6__.CORE_MODULES).getModule(dependencySlug);
      if (!dependedentModule?.active) {
        inactiveModules.push(dependedentModule.name);
      }
    });

    // If we have inactive dependencies, there's no need to check if we can
    // activate the module until the dependencies have been activated.
    if (inactiveModules.length) {
      /* translators: Error message text. 1: A flattened list of module names. 2: A module name. */
      const messageTemplate = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)('You need to set up %1$s to gain access to %2$s.', 'google-site-kit');
      const errorMessage = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.sprintf)(messageTemplate, (0,_js_util__WEBPACK_IMPORTED_MODULE_10__.listFormat)(inactiveModules), module.name);
      yield baseActions.receiveCheckRequirementsError(slug, {
        code: _constants__WEBPACK_IMPORTED_MODULE_6__.ERROR_CODE_INSUFFICIENT_MODULE_DEPENDENCIES,
        message: errorMessage,
        data: {
          inactiveModules
        }
      });
    } else {
      try {
        yield googlesitekit_data__WEBPACK_IMPORTED_MODULE_5__.commonActions.await(module.checkRequirements(registry));
        yield baseActions.receiveCheckRequirementsSuccess(slug);
      } catch (error) {
        yield baseActions.receiveCheckRequirementsError(slug, error);
      }
    }
  },
  *hasModuleAccess(slug) {
    const registry = yield googlesitekit_data__WEBPACK_IMPORTED_MODULE_5__.commonActions.getRegistry();
    const existingCheckAccess = registry.select(_constants__WEBPACK_IMPORTED_MODULE_6__.CORE_MODULES).hasModuleAccess(slug);
    if (existingCheckAccess === undefined) {
      yield fetchCheckModuleAccessStore.actions.fetchCheckModuleAccess(slug);
    }
  },
  *getRecoverableModules() {
    const registry = yield googlesitekit_data__WEBPACK_IMPORTED_MODULE_5__.commonActions.getRegistry();
    const modules = yield googlesitekit_data__WEBPACK_IMPORTED_MODULE_5__.commonActions.await(registry.resolveSelect(_constants__WEBPACK_IMPORTED_MODULE_6__.CORE_MODULES).getModules());
    const recoverableModules = Object.entries(modules || {}).reduce((moduleList, [moduleSlug, module]) => {
      if (module.recoverable && !module.internal) {
        moduleList.push(moduleSlug);
      }
      return moduleList;
    }, []);
    yield baseActions.receiveRecoverableModules(recoverableModules);
  },
  *getSharedOwnershipModules() {
    const registry = yield googlesitekit_data__WEBPACK_IMPORTED_MODULE_5__.commonActions.getRegistry();
    if (registry.select(_constants__WEBPACK_IMPORTED_MODULE_6__.CORE_MODULES).getSharedOwnershipModules()) {
      return;
    }
    if (!__webpack_require__.g._googlesitekitDashboardSharingData) {
      __webpack_require__.g.console.error('Could not load core/modules dashboard sharing.');
      return;
    }
    const {
      sharedOwnershipModules
    } = __webpack_require__.g._googlesitekitDashboardSharingData;
    yield baseActions.receiveSharedOwnershipModules(sharedOwnershipModules);
  },
  *getInlineModulesData() {
    const registry = yield googlesitekit_data__WEBPACK_IMPORTED_MODULE_5__.commonActions.getRegistry();
    if (registry.select(_constants__WEBPACK_IMPORTED_MODULE_6__.CORE_MODULES).getInlineModulesData()) {
      return;
    }
    if (!__webpack_require__.g._googlesitekitModulesData) {
      return;
    }
    yield baseActions.receiveInlineModulesData(__webpack_require__.g._googlesitekitModulesData);
  },
  getModule: waitForModules,
  getModuleInlineData: waitForModulesInlineData,
  isModuleActive: waitForModules,
  isModuleConnected: waitForModules
};
const baseSelectors = {
  /**
   * Gets the list of modules registered for use with Site Kit.
   *
   * A module is a section of Site Kit that relates to a particular service,
   * like Google Analytics or Google PageSpeed modules. They can provide
   * admin-only features (like PageSpeed Insights), frontend-only features,
   * or both (eg. Analytics, which can install Analytics <script> tags in the
   * frontend, and show dashboards in the WordPress Admin).
   *
   * Returns an Object/map of objects, keyed by slug, with the following shape when successful:
   * ```
   * slug: {
   *   "slug": "tagmanager",
   *   "name": "Tag Manager",
   *   "description": "Tag Manager creates an easy to manage way to create tags on your site without updating code.",
   *   "homepage": "https://tagmanager.google.com/",
   *   "internal": false,
   *   "active": false,
   *   "connected": false,
   *   "dependencies": [],
   *   "dependents": []
   * }
   * ```
   *
   * @since 1.8.0
   *
   * @param {Object} state Data store's state.
   * @return {(Object|undefined)} Modules available on the site.
   */
  getModules(state) {
    const {
      clientDefinitions,
      serverDefinitions
    } = state;

    // Return `undefined` if modules haven't been loaded yet.
    if (serverDefinitions === undefined) {
      return undefined;
    }

    // `normalizeModules` must be called with stable arguments directly from state.
    // Redefining/spreading these will undermine the memoization!
    return normalizeModules(serverDefinitions, clientDefinitions);
  },
  /**
   * Gets a specific module by slug.
   *
   * Returns a specific module by its slug.
   * Returns `undefined` if state is still loading or if said module doesn't exist.
   *
   * @since 1.8.0
   *
   * @param {Object} state Data store's state.
   * @param {string} slug  Module slug.
   * @return {(Object|undefined)} A specific module object; `undefined` if state is still loading or if said module doesn't exist.
   */
  getModule: (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_5__.createRegistrySelector)(select => (state, slug) => {
    const modules = select(_constants__WEBPACK_IMPORTED_MODULE_6__.CORE_MODULES).getModules();

    // Return `undefined` if modules haven't been loaded yet.
    if (modules === undefined) {
      return undefined;
    }

    // A module with this slug couldn't be found; return `null` to signify the
    // "not found" state.
    if (modules[slug] === undefined) {
      return null;
    }

    // This module exists, so let's return it.
    return modules[slug];
  }),
  /**
   * Gets a specific module icon by slug.
   *
   * Returns a specific module icon by its slug.
   * Returns `null` if state is still loading or if said module doesn't exist or doesn't have an icon.
   *
   * @since 1.23.0
   *
   * @param {Object} state Data store's state.
   * @param {string} slug  Module slug.
   * @return {(WPComponent|undefined|null)} A specific module's icon; `undefined` if state is still loading; `null` if said module doesn't exist or doesn't have an icon.
   */
  getModuleIcon: (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_5__.createRegistrySelector)(select => (state, slug) => {
    const module = select(_constants__WEBPACK_IMPORTED_MODULE_6__.CORE_MODULES).getModule(slug);
    // Return `undefined` if module with this slug isn't loaded yet.
    if (module === undefined) {
      return undefined;
    }

    // A module with this slug couldn't be found or the icon is not found for the module; return `null` to signify the
    // "module not found" or "icon not found" state
    if (module === null || module.Icon === null) {
      return null;
    }

    // This module and the icon exists, so let's return it.
    return module.Icon;
  }),
  /**
   * Gets module dependency names by slug.
   *
   * Returns a list of modules that depend on this module.
   * Returns `undefined` if state is still loading or if said module doesn't exist.
   *
   * @since 1.20.0
   *
   * @param {Object} state Data store's state.
   * @param {string} slug  Module slug.
   * @return {(Array|undefined)} An array of dependency module names; `undefined` if state is still loading.
   */
  getModuleDependencyNames: (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_5__.createRegistrySelector)(select => (state, slug) => {
    const module = select(_constants__WEBPACK_IMPORTED_MODULE_6__.CORE_MODULES).getModule(slug);

    // Return `undefined` if module with this slug isn't loaded yet.
    if (module === undefined) {
      return undefined;
    }

    // A module with this slug couldn't be found; return `[]` to signify the
    // "not found" state.
    if (module === null) {
      return [];
    }

    // Module is found, return the names of the dependencies
    // Modules are already resolved after we getModule() so they can't be undefined.
    const modules = select(_constants__WEBPACK_IMPORTED_MODULE_6__.CORE_MODULES).getModules();
    return module.dependencies.map(dependencySlug => modules[dependencySlug]?.name || dependencySlug);
  }),
  /**
   * Gets module dependant names by slug.
   *
   * Returns a list of modules on which this module depends.
   * Returns `undefined` if state is still loading or if said module doesn't exist.
   *
   * @since 1.20.0
   *
   * @param {Object} state Data store's state.
   * @param {string} slug  Module slug.
   * @return {(Array|undefined)} An array of dependant module names; `undefined` if state is still loading.
   */
  getModuleDependantNames: (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_5__.createRegistrySelector)(select => (state, slug) => {
    const module = select(_constants__WEBPACK_IMPORTED_MODULE_6__.CORE_MODULES).getModule(slug);

    // Return `undefined` if module with this slug isn't loaded yet.
    if (module === undefined) {
      return undefined;
    }

    // A module with this slug couldn't be found; return `[]` to signify the
    // "not found" state.
    if (module === null) {
      return [];
    }

    // Module is found, return the names of the dependants
    // Modules are already resolved after we getModule() so they can't be undefined.
    const modules = select(_constants__WEBPACK_IMPORTED_MODULE_6__.CORE_MODULES).getModules();
    return module.dependants.map(dependantSlug => modules[dependantSlug]?.name || dependantSlug);
  }),
  /**
   * Gets module store name by slug.
   *
   * Returns the store name if preset or null if there is no store name for this module.
   * Returns `undefined` if state is still loading or if said module doesn't exist.
   *
   * @since 1.24.0
   *
   * @param {string} slug Module slug.
   * @return {(string|null|undefined)} `string` of the store name if a name has been set for this module.
   * 									 `null` if no store name was set.
   * 									 `undefined` if state is still loading.
   */
  getModuleStoreName: (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_5__.createRegistrySelector)(select => (state, slug) => {
    const module = select(_constants__WEBPACK_IMPORTED_MODULE_6__.CORE_MODULES).getModule(slug);

    // Return `undefined` if module with this slug isn't loaded yet.
    if (module === undefined) {
      return undefined;
    }

    // Return null if no store name was set
    if (module === null) {
      return null;
    }
    return module.storeName;
  }),
  /**
   * Checks a module's availability status.
   *
   * Note that an otherwise valid module may be removed from the list of available modules
   * by making use of the the googlesitekit_available_modules filter in PHP.
   *
   * Returns `true` if the module is available.
   * Returns `false` if the module is not available.
   * Returns `undefined` if state is still loading.
   *
   * @since 1.85.0
   *
   * @param {Object} state Data store's state.
   * @param {string} slug  Module slug.
   * @return {(boolean|undefined)} `true` when the module is available.
   * 									  `false` when the module is not available.
   * 									  `undefined` if state is still loading.
   */
  isModuleAvailable: (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_5__.createRegistrySelector)(select => (state, slug) => {
    const module = select(_constants__WEBPACK_IMPORTED_MODULE_6__.CORE_MODULES).getModule(slug);

    // Return `undefined` if modules haven't been loaded yet.
    if (module === undefined) {
      return undefined;
    }

    // A module with this slug couldn't be found; return `false` to signify the
    // unavailable state.
    if (module === null) {
      return false;
    }

    // Otherwise, the module exists and is available.
    return true;
  }),
  /**
   * Checks a module's activation status.
   *
   * Returns `true` if the module exists and is active.
   * Returns `false` if the module exists but is not active.
   * Returns `undefined` if state is still loading or if no module with that slug exists.
   *
   * @since 1.8.0
   *
   * @param {Object} state Data store's state.
   * @param {string} slug  Module slug.
   * @return {(boolean|null|undefined)} `true` when the module exists and is active.
   * 									  `undefined` if state is still loading.
   * 									  `null` if said module doesn't exist.
   */
  isModuleActive: (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_5__.createRegistrySelector)(select => (state, slug) => {
    const module = select(_constants__WEBPACK_IMPORTED_MODULE_6__.CORE_MODULES).getModule(slug);

    // Return `undefined` if modules haven't been loaded yet.
    if (module === undefined) {
      return undefined;
    }

    // A module with this slug couldn't be found; return `null` to signify the
    // "not found" state.
    if (module === null) {
      return null;
    }
    return module.active;
  }),
  /**
   * Checks whether a module is connected or not.
   *
   * Returns `true` if the module exists, is active and connected.
   * Returns `false` if the module exists but is either not active or not connected.
   * Returns `undefined` if state is still loading or if no module with that slug exists.
   *
   * @since 1.16.0
   *
   * @param {Object} state Data store's state.
   * @param {string} slug  Module slug.
   * @return {(boolean|null|undefined)} `true` when the module exists, is active and connected, otherwise `false`.
   * 									  `undefined` if state is still loading.
   * 									  `null` if said module doesn't exist.
   */
  isModuleConnected: (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_5__.createRegistrySelector)(select => (state, slug) => {
    const module = select(_constants__WEBPACK_IMPORTED_MODULE_6__.CORE_MODULES).getModule(slug);

    // Return `undefined` if modules haven't been loaded yet.
    if (module === undefined) {
      return undefined;
    }

    // A module with this slug couldn't be found; return `null` to signify the
    // "not found" state.
    if (module === null) {
      return null;
    }
    return module.active && module.connected;
  }),
  /**
   * Checks if a module's status is changing.
   *
   * Returns `true` if the module exists and is changing its `active` flag.
   * Returns `false` if the module exists but is not changing its `active` flag.
   * Returns `undefined` if state is still loading or if no module with that slug exists.
   *
   * @since 1.8.0
   *
   * @param {Object} state Data store's state.
   * @param {string} slug  Module slug.
   * @return {(boolean|undefined)} Activation change status; `undefined` if state is still loading or if no module with that slug exists.
   */
  isDoingSetModuleActivation: (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_5__.createRegistrySelector)(select => (state, slug) => {
    // Return undefined if modules not loaded or invalid slug.
    if (!select(_constants__WEBPACK_IMPORTED_MODULE_6__.CORE_MODULES).getModule(slug)) {
      return undefined;
    }

    // Check if the module is being activated.
    if (select(_constants__WEBPACK_IMPORTED_MODULE_6__.CORE_MODULES).isFetchingSetModuleActivation(slug, true)) {
      return true;
    }

    // Check if the module is being deactivated.
    if (select(_constants__WEBPACK_IMPORTED_MODULE_6__.CORE_MODULES).isFetchingSetModuleActivation(slug, false)) {
      return true;
    }

    // Check if modules data still needs to be refreshed after activation
    // update.
    return state.isAwaitingModulesRefresh;
  }),
  /**
   * Checks if we can activate a module with a given slug.
   *
   * Returns `true` if the module can be activated.
   * Returns `false` if the module can not be activated.
   * Returns `undefined` if slug can not be found in state.
   *
   * @since 1.22.0
   *
   * @param {Object} state Data store's state.
   * @param {string} slug  Module slug.
   * @return {(boolean|undefined)} Can activate module status; `undefined` if state is still loading or if no module with that slug exists.
   */
  canActivateModule(state, slug) {
    invariant__WEBPACK_IMPORTED_MODULE_1___default()(slug, 'slug is required');
    const moduleRequirements = state.checkRequirementsResults[slug];
    if (moduleRequirements === undefined) {
      return undefined;
    }
    return moduleRequirements === true || moduleRequirements?.canActivate === true;
  },
  /**
   * Gets the module activation error for a given slug.
   *
   * Returns `null` if the module can be activated and there is no error.
   * Returns `object` containing code, message and optional data property if there is an activation error for a slug.
   *
   * @since 1.22.0
   *
   * @param {Object} state Data store's state.
   * @param {string} slug  Module slug.
   * @return {(null|Object)} Activation error for a module slug; `null` if there is no error or an error object if we cannot activate a given module.
   */
  getCheckRequirementsError: (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_5__.createRegistrySelector)(select => (state, slug) => {
    invariant__WEBPACK_IMPORTED_MODULE_1___default()(slug, 'slug is required.');
    const {
      checkRequirementsResults
    } = state;
    const canActivate =
    // Need to use registry selector here to ensure resolver is invoked.
    select(_constants__WEBPACK_IMPORTED_MODULE_6__.CORE_MODULES).canActivateModule(slug);
    if (canActivate === undefined || checkRequirementsResults[slug] === true) {
      return null;
    }
    return checkRequirementsResults[slug];
  }),
  /**
   * Gets the module's list of features.
   *
   * Returns a list of features of this module.
   *
   * @since 1.30.0
   *
   * @param {Object} state Data store's state.
   * @param {string} slug  Module slug.
   * @return {(Array|undefined)} An array of features for the module; `undefined` if state is still loading.
   */
  getModuleFeatures: (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_5__.createRegistrySelector)(select => (state, slug) => {
    const modules = select(_constants__WEBPACK_IMPORTED_MODULE_6__.CORE_MODULES).getModules();

    // Return `undefined` if modules haven't been loaded yet.
    if (modules === undefined) {
      return undefined;
    }
    return Array.isArray(modules[slug]?.features) ? modules[slug].features : [];
  }),
  /**
   * Checks if the given module has access.
   *
   * @since 1.70.0
   *
   * @param {Object} state Data store's state.
   * @param {string} slug  Module slug.
   * @return {(boolean|undefined)} `boolean` if the module has check access. If the state is still being resolved, returns `undefined`.
   */
  hasModuleAccess(state, slug) {
    return state.moduleAccess[slug];
  },
  /**
   * Checks if current user has ownership of the given module.
   *
   * @since 1.148.0
   *
   * @param {Object} state Data store's state.
   * @param {string} slug  Module slug.
   * @return {(boolean|null|undefined)} `true` if the user has ownership.
   *                               	    `false` if the user doesn't have ownership.
   *                               	    `null` if the module doesn't exist.
   *                               	    `undefined` If the state is still being resolved.
   */
  hasModuleOwnership: (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_5__.createRegistrySelector)(select => (state, moduleSlug) => {
    const moduleStoreName = select(_constants__WEBPACK_IMPORTED_MODULE_6__.CORE_MODULES).getModuleStoreName(moduleSlug);
    if (moduleStoreName === undefined) {
      return undefined;
    }

    // A store with this name doesn't exist, so the user can't have access to it.
    // This is either caused by a module not being loaded or an incorrect module
    // name being used.
    if (select(moduleStoreName) === null) {
      return null;
    }
    const moduleOwnerID = select(moduleStoreName).getOwnerID();
    const loggedInUserID = select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_8__.CORE_USER).getID();
    if (moduleOwnerID === undefined || loggedInUserID === undefined) {
      return undefined;
    }
    if (moduleOwnerID === loggedInUserID) {
      return true;
    }
    return false;
  }),
  /**
   * Checks if current user has ownership or access to the given module.
   *
   * @since 1.92.0
   *
   * @param {Object} state Data store's state.
   * @param {string} slug  Module slug.
   * @return {(boolean|undefined)} `true` if the user has ownership or access.
   *                               `false` if the user doesn't have ownership or access.
   *                               `undefined` If the state is still being resolved.
   */
  hasModuleOwnershipOrAccess: (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_5__.createRegistrySelector)(select => (state, moduleSlug) => {
    const hasOwnership = select(_constants__WEBPACK_IMPORTED_MODULE_6__.CORE_MODULES).hasModuleOwnership(moduleSlug);
    if (hasOwnership === true) {
      return true;
    }
    if (hasOwnership === undefined) {
      return undefined;
    }

    // If the module doesn't exist, the user can't have ownership or access.
    if (hasOwnership === null) {
      return false;
    }
    return select(_constants__WEBPACK_IMPORTED_MODULE_6__.CORE_MODULES).hasModuleAccess(moduleSlug);
  }),
  /**
   * Gets the list of recoverable modules for dashboard sharing.
   *
   * Returns an Object/map of objects, keyed by slug as same as `getModules`.
   *
   * @since 1.74.0
   *
   * @param {Object} state Data store's state.
   * @return {(Object|undefined)} Recoverable modules available on the site; `undefined` if not loaded.
   */
  getRecoverableModules: (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_5__.createRegistrySelector)(select => state => {
    const modules = select(_constants__WEBPACK_IMPORTED_MODULE_6__.CORE_MODULES).getModules();

    // Return `undefined` if modules OR recoverableModules haven't been loaded yet.
    if (state.recoverableModules === undefined || modules === undefined) {
      return undefined;
    }
    return calculateRecoverableModules(modules, state.recoverableModules);
  }),
  /**
   * Checks if there are any recoverable modules for dashboard sharing.
   *
   * @since 1.133.0
   *
   * @param {Object} state Data store's state.
   * @return {(boolean|undefined)} `true` if there are recoverable modules.
   * 								 `false` if there are none.
   * 								 `undefined` if not loaded.
   */
  hasRecoverableModules: state => {
    // Return `undefined` if recoverableModules haven't been loaded yet.
    if (state.recoverableModules === undefined) {
      return undefined;
    }
    return Object.keys(state.recoverableModules).length > 0;
  },
  /**
   * Gets the list of shared ownership modules for dashboard sharing.
   *
   * Returns an Object/map of objects, keyed by slug as same as `getModules`.
   *
   * @since 1.77.0
   *
   * @param {Object} state Data store's state.
   * @return {(Object|undefined)} Shared ownership modules available on the site; `undefined` if not loaded.
   */
  getSharedOwnershipModules: (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_5__.createRegistrySelector)(select => state => {
    const modules = select(_constants__WEBPACK_IMPORTED_MODULE_6__.CORE_MODULES).getModules();

    // Return `undefined` if modules OR sharedOwnershipModules haven't been loaded yet.
    if (state.sharedOwnershipModules === undefined || modules === undefined) {
      return undefined;
    }
    return Object.values(modules).reduce((sharedOwnershipModules, module) => {
      if (state.sharedOwnershipModules.includes(module.slug)) {
        return {
          ...sharedOwnershipModules,
          [module.slug]: module
        };
      }
      return sharedOwnershipModules;
    }, {});
  }),
  /**
   * Gets the list of non-internal shareable modules for dashboard sharing.
   *
   * Returns an Object/map of objects, keyed by slug as same as `getModules`.
   *
   * @since 1.95.0
   *
   * @param {Object} state Data store's state.
   * @return {(Object|undefined)} Non-internal shareable modules available on the site; `undefined` if not loaded.
   */
  getShareableModules: (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_5__.createRegistrySelector)(select => () => {
    const modules = select(_constants__WEBPACK_IMPORTED_MODULE_6__.CORE_MODULES).getModules();

    // Return early if modules are not loaded.
    if (modules === undefined) {
      return undefined;
    }
    return Object.keys(modules).reduce((acc, slug) => {
      if (modules[slug].shareable) {
        return {
          [slug]: modules[slug],
          ...acc
        };
      }
      return acc;
    }, {});
  }),
  /**
   * Gets recovery errors for recoverable modules.
   *
   * Returns an object keyed by module slug, containing error details and module name,
   * for all recoverable modules that have a corresponding recovery error.
   *
   * @since 1.157.0
   *
   * @param {Object} state Data store's state (unused in this selector).
   * @return {(Object|undefined)} Object of recovery errors keyed by module slug,
   *                              or `undefined` if recoverable modules are not yet available.
   */
  getRecoveryErrors: (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_5__.createRegistrySelector)(select => () => {
    const recoverableModules = select(_constants__WEBPACK_IMPORTED_MODULE_6__.CORE_MODULES).getRecoverableModules();
    if (!recoverableModules) {
      return undefined;
    }
    const recoveredModules = select(_constants__WEBPACK_IMPORTED_MODULE_6__.CORE_MODULES).getRecoveredModules();
    if (!recoveredModules) {
      return {};
    }
    const modules = Object.keys(recoverableModules);
    function getRecoveryError(module) {
      return recoveredModules?.error?.[module];
    }
    return modules.filter(module => !!getRecoveryError(module)).reduce((acc, module) => ({
      ...acc,
      [module]: {
        name: recoverableModules[module].name,
        ...getRecoveryError(module)
      }
    }), {});
  }),
  /**
   * Gets the list of recoverable module slugs the current user has access to.
   *
   * Returns an array of module slugs from `getRecoverableModules` that the user
   * has access to based on `hasModuleAccess`.
   *
   * @since 1.157.0
   *
   * @param {Object} state Data store's state (unused in this selector).
   * @return {(Array<string>|undefined)} Array of accessible recoverable module slugs,
   *                                     or `undefined` if data is not ready.
   */
  getUserRecoverableModuleSlugs: (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_5__.createRegistrySelector)(select => () => {
    const {
      getRecoverableModules,
      hasModuleAccess
    } = select(_constants__WEBPACK_IMPORTED_MODULE_6__.CORE_MODULES);
    const modules = getRecoverableModules();
    if (modules === undefined) {
      return undefined;
    }
    const slugAccessEntries = Object.keys(modules).map(slug => [slug, hasModuleAccess(slug)]);
    if (slugAccessEntries.some(([, hasAccess]) => hasAccess === undefined)) {
      return undefined;
    }
    return slugAccessEntries.filter(([, hasAccess]) => hasAccess).map(([slug]) => slug);
  }),
  getRecoveredModules(state) {
    return state.recoveredModules;
  },
  /**
   * Gets the details link URL for a module.
   *
   * Returns the module homepage by default. This can be overwritten by a
   * custom selector of the same name in the module store implementation.
   *
   * @since 1.144.0
   *
   * @param {Object} state Data store's state.
   * @param {string} slug  Module slug.
   * @return {(string|null|undefined)} Details link URL; `null` if module is not available, or does not have a homepage. `undefined` if data is still loading.
   */
  getDetailsLinkURL: (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_5__.createRegistrySelector)(select => (state, slug) => {
    const module = select(_constants__WEBPACK_IMPORTED_MODULE_6__.CORE_MODULES).getModule(slug);
    if (module === undefined) {
      return undefined;
    }
    if (module === null) {
      return null;
    }
    const storeName = select(_constants__WEBPACK_IMPORTED_MODULE_6__.CORE_MODULES).getModuleStoreName(slug);
    const {
      getDetailsLinkURL
    } = select(storeName) || {};
    if (typeof getDetailsLinkURL === 'function') {
      return getDetailsLinkURL();
    }
    if (!module.homepage) {
      return null;
    }
    return select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_8__.CORE_USER).getAccountChooserURL(module.homepage);
  }),
  /**
   * Gets inline modules data.
   *
   * Returns all inline modules data that was loaded from the global variable.
   *
   * @since 1.162.0
   *
   * @param {Object} state Data store's state.
   * @return {(Object|undefined)} Inline modules data object; `undefined` if not loaded.
   */
  getInlineModulesData: state => {
    return state.inlineModulesData;
  },
  /**
   * Gets inline data for a specific module.
   *
   * Returns inline data for the specified module slug.
   *
   * @since 1.162.0
   *
   * @param {Object} state Data store's state.
   * @param {string} slug  Module slug.
   * @return {(Object|undefined)} Module inline data object; `undefined` if not loaded.
   */
  getModuleInlineData: (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_5__.createRegistrySelector)(select => (state, slug) => {
    const inlineModulesData = select(_constants__WEBPACK_IMPORTED_MODULE_6__.CORE_MODULES).getInlineModulesData();
    if (inlineModulesData === undefined) {
      return undefined;
    }
    return inlineModulesData[slug];
  })
};
const store = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_5__.combineStores)(fetchGetModulesStore, fetchSetModuleActivationStore, fetchCheckModuleAccessStore, fetchRecoverModulesStore, {
  initialState: baseInitialState,
  actions: baseActions,
  controls: baseControls,
  reducer: baseReducer,
  resolvers: baseResolvers,
  selectors: baseSelectors
});
const initialState = store.initialState;
const actions = store.actions;
const controls = store.controls;
const reducer = store.reducer;
const resolvers = store.resolvers;
const selectors = store.selectors;
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (store);

/***/ }),

/***/ "./js/googlesitekit/modules/datastore/settings-panel.js":
/*!**************************************************************!*\
  !*** ./js/googlesitekit/modules/datastore/settings-panel.js ***!
  \**************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   actions: () => (/* binding */ actions),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   initialState: () => (/* binding */ initialState),
/* harmony export */   reducer: () => (/* binding */ reducer),
/* harmony export */   selectors: () => (/* binding */ selectors)
/* harmony export */ });
/* harmony import */ var invariant__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! invariant */ "../node_modules/invariant/browser.js");
/* harmony import */ var invariant__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(invariant__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__);
/**
 * `core/modules` data store settings panel
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * Internal dependencies
 */


// Actions
const SET_MODULE_SETTINGS_PANEL_STATE = 'SET_MODULE_SETTINGS_PANEL_STATE';
const initialState = {
  settingsPanel: {
    currentModule: null,
    isEditing: false
  }
};
const actions = {
  /**
   * Sets the module settings panel state for a given module.
   *
   * @since 1.22.0
   *
   * @param {string} slug  Module slug.
   * @param {string} value New setting for module, one of: closed, edit, view.
   * @return {Object} Action for SET_MODULE_SETTINGS_PANEL_STATE.
   */
  setModuleSettingsPanelState(slug, value) {
    invariant__WEBPACK_IMPORTED_MODULE_0___default()(slug, 'slug is required.');
    const validValues = ['closed', 'edit', 'view'];
    invariant__WEBPACK_IMPORTED_MODULE_0___default()(validValues.includes(value), `value should be one of ${validValues.join()} `);
    return {
      payload: {
        slug,
        value
      },
      type: SET_MODULE_SETTINGS_PANEL_STATE
    };
  }
};
const reducer = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.createReducer)((state, {
  type,
  payload
}) => {
  switch (type) {
    case SET_MODULE_SETTINGS_PANEL_STATE:
      {
        const {
          slug,
          value
        } = payload;
        const settingsPanel = {
          ...state.settingsPanel
        };
        settingsPanel.currentModule = 'closed' === value ? null : slug;
        settingsPanel.isEditing = 'edit' === value;
        state.settingsPanel = settingsPanel;
        break;
      }
    default:
      break;
  }
});
const selectors = {
  /**
   * Gets the settings panel state for a given module.
   *
   * @since 1.22.0
   *
   * @param {Object} state Data store's state.
   * @param {string} slug  Module slug.
   * @return {string} Module settings panel state for a given module as one of: 'view', 'edit', or 'closed'.
   */
  getModuleSettingsPanelState: (state, slug) => {
    invariant__WEBPACK_IMPORTED_MODULE_0___default()(slug, 'slug is required.');
    const {
      currentModule,
      isEditing
    } = state.settingsPanel;
    if (currentModule === slug) {
      return isEditing ? 'edit' : 'view';
    }
    return 'closed';
  },
  /**
   * Checks whether the module settings panel is open for a given module.
   *
   * @since 1.22.0
   *
   * @param {Object} state Data store's state.
   * @param {string} slug  Module slug.
   * @return {boolean} Whether or not the module settings panel is open for the module.
   */
  isModuleSettingsPanelOpen: (state, slug) => {
    invariant__WEBPACK_IMPORTED_MODULE_0___default()(slug, 'slug is required.');
    return slug === state.settingsPanel.currentModule;
  },
  /**
   * Checks whether the module settings panel is closed for a given module.
   *
   * @since 1.22.0
   *
   * @param {Object} state Data store's state.
   * @param {string} slug  Module slug.
   * @return {boolean} Whether or not the module settings panel is closed for the module.
   */
  isModuleSettingsPanelClosed: (state, slug) => {
    invariant__WEBPACK_IMPORTED_MODULE_0___default()(slug, 'slug is required.');
    return slug !== state.settingsPanel.currentModule;
  },
  /**
   * Checks whether the module settings panel is in edit state for a given module.
   *
   * @since 1.22.0
   *
   * @param {Object} state Data store's state.
   * @param {string} slug  Module slug.
   * @return {boolean} Whether or not the module settings panel is in edit state for the module.
   */
  isModuleSettingsPanelEdit: (state, slug) => {
    invariant__WEBPACK_IMPORTED_MODULE_0___default()(slug, 'slug is required.');
    const {
      currentModule,
      isEditing
    } = state.settingsPanel;
    return slug === currentModule && isEditing;
  },
  /**
   * Checks whether the module settings panel is locked for a given module.
   *
   * @since 1.22.0
   *
   * @param {Object} state Data store's state.
   * @param {string} slug  Module slug.
   * @return {boolean} Whether or not the module settings panel is locked for the module.
   */
  isModuleSettingsPanelLocked: (state, slug) => {
    invariant__WEBPACK_IMPORTED_MODULE_0___default()(slug, 'slug is required.');
    const {
      currentModule,
      isEditing
    } = state.settingsPanel;
    return slug !== currentModule && isEditing;
  }
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  actions,
  initialState,
  reducer,
  selectors
});

/***/ }),

/***/ "./js/googlesitekit/modules/datastore/settings.js":
/*!********************************************************!*\
  !*** ./js/googlesitekit/modules/datastore/settings.js ***!
  \********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   actions: () => (/* binding */ actions),
/* harmony export */   controls: () => (/* binding */ controls),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   selectors: () => (/* binding */ selectors)
/* harmony export */ });
/* harmony import */ var invariant__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! invariant */ "../node_modules/invariant/browser.js");
/* harmony import */ var invariant__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(invariant__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./constants */ "./js/googlesitekit/modules/datastore/constants.js");
/* harmony import */ var _js_googlesitekit_data_utils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/googlesitekit/data/utils */ "./js/googlesitekit/data/utils.js");
/**
 * `core/modules` data store settings
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * Internal dependencies
 */



const SUBMIT_MODULE_CHANGES = 'SUBMIT_MODULE_CHANGES';
const ROLLBACK_MODULE_CHANGES = 'ROLLBACK_MODULE_CHANGES';
const actions = {
  /**
   * Submits all changes for a module.
   *
   * @since 1.20.0
   *
   * @param {string} slug Slug for module store.
   * @return {Object} Module's submitChanges response object if it exists, otherwise object with `error` property if it doesn't.
   */
  submitChanges: (0,_js_googlesitekit_data_utils__WEBPACK_IMPORTED_MODULE_3__.createValidatedAction)(slug => {
    invariant__WEBPACK_IMPORTED_MODULE_0___default()(slug, 'slug is required.');
  }, function* (slug) {
    return yield {
      type: SUBMIT_MODULE_CHANGES,
      payload: {
        slug
      }
    };
  }),
  /**
   * Rolls back all changes for a module.
   *
   * @since 1.45.0
   *
   * @param {string} slug Slug for module store.
   * @return {Object} Module's rollbackChanges results.
   */
  rollbackChanges: (0,_js_googlesitekit_data_utils__WEBPACK_IMPORTED_MODULE_3__.createValidatedAction)(slug => {
    invariant__WEBPACK_IMPORTED_MODULE_0___default()(slug, 'slug is required.');
  }, function* (slug) {
    return yield {
      type: ROLLBACK_MODULE_CHANGES,
      payload: {
        slug
      }
    };
  })
};
const controls = {
  [SUBMIT_MODULE_CHANGES]: (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.createRegistryControl)(registry => ({
    payload
  }) => {
    const {
      slug
    } = payload;
    const storeName = registry.select(_constants__WEBPACK_IMPORTED_MODULE_2__.CORE_MODULES).getModuleStoreName(slug);
    if (!storeName) {
      return {
        error: `The module '${slug}' does not have a store.`
      };
    }
    const {
      submitChanges
    } = registry.dispatch(storeName);
    if (!submitChanges) {
      return {
        error: `The module '${slug}' does not have a submitChanges() action.`
      };
    }
    return submitChanges(slug);
  }),
  [ROLLBACK_MODULE_CHANGES]: (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.createRegistryControl)(registry => ({
    payload
  }) => {
    const {
      slug
    } = payload;
    const storeName = registry.select(_constants__WEBPACK_IMPORTED_MODULE_2__.CORE_MODULES).getModuleStoreName(slug);
    if (!storeName) {
      return {
        error: `The module '${slug}' does not have a store.`
      };
    }
    const {
      rollbackChanges
    } = registry.dispatch(storeName);
    if (rollbackChanges) {
      return rollbackChanges(slug);
    }
    return {
      error: `The module '${slug}' does not support rollbackChanges().`
    };
  })
};
const selectors = {
  /**
   * Checks whether settings edit dependencies are currently loading for a module.
   *
   * @since 1.144.0
   *
   * @param {string} slug Module slug.
   * @return {boolean?} Whether or not settings edit dependencies are currently loading for the module,
   *                    or `undefined` if the store doesn't exist.
   */
  areSettingsEditDependenciesLoaded: (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.createRegistrySelector)(select => (state, slug) => {
    invariant__WEBPACK_IMPORTED_MODULE_0___default()(slug, 'slug is required.');
    const storeName = select(_constants__WEBPACK_IMPORTED_MODULE_2__.CORE_MODULES).getModuleStoreName(slug);
    const moduleSelectors = select(storeName);
    if (!moduleSelectors) {
      return undefined;
    }
    return (
      // If the module doesn't implement the selector, consider dependencies loaded,
      !moduleSelectors.areSettingsEditDependenciesLoaded ||
      // otherwise defer to the result of the selector.
      !!moduleSelectors.areSettingsEditDependenciesLoaded()
    );
  }),
  /**
   * Checks whether changes are currently being submitted for a module.
   *
   * @since 1.20.0
   *
   * @param {string} slug Slug for module store.
   * @return {Object} Module's submitChanges response object if it exists, otherwise object with `error` property if it doesn't.
   */
  isDoingSubmitChanges: (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.createRegistrySelector)(select => (state, slug) => {
    invariant__WEBPACK_IMPORTED_MODULE_0___default()(slug, 'slug is required.');
    const storeName = select(_constants__WEBPACK_IMPORTED_MODULE_2__.CORE_MODULES).getModuleStoreName(slug);
    return !!select(storeName)?.isDoingSubmitChanges?.();
  }),
  /**
   * Checks whether we can submit changes for a module.
   *
   * @since 1.20.0
   *
   * @param {string} slug Slug for module store.
   * @return {boolean} Whether the module supports submitting changes.
   */
  canSubmitChanges: (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.createRegistrySelector)(select => (state, slug) => {
    invariant__WEBPACK_IMPORTED_MODULE_0___default()(slug, 'slug is required.');
    const storeName = select(_constants__WEBPACK_IMPORTED_MODULE_2__.CORE_MODULES).getModuleStoreName(slug);
    return !!select(storeName)?.canSubmitChanges?.();
  }),
  /**
   * Checks whether there are changes to save for a module.
   *
   * @since 1.125.0
   *
   * @param {string} slug Slug for module store.
   * @return {boolean} Whether changes have been made in the settings form.
   */
  haveSettingsChanged: (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.createRegistrySelector)(select => (state, slug) => {
    invariant__WEBPACK_IMPORTED_MODULE_0___default()(slug, 'slug is required.');
    const storeName = select(_constants__WEBPACK_IMPORTED_MODULE_2__.CORE_MODULES).getModuleStoreName(slug);
    return !!select(storeName)?.haveSettingsChanged?.();
  })
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  actions,
  controls,
  selectors
});

/***/ }),

/***/ "./js/googlesitekit/modules/datastore/sharing-settings.js":
/*!****************************************************************!*\
  !*** ./js/googlesitekit/modules/datastore/sharing-settings.js ***!
  \****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   INVARIANT_DOING_SUBMIT_SHARING_CHANGES: () => (/* binding */ INVARIANT_DOING_SUBMIT_SHARING_CHANGES),
/* harmony export */   INVARIANT_SHARING_SETTINGS_NOT_CHANGED: () => (/* binding */ INVARIANT_SHARING_SETTINGS_NOT_CHANGED),
/* harmony export */   actions: () => (/* binding */ actions),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   initialState: () => (/* binding */ initialState),
/* harmony export */   reducer: () => (/* binding */ reducer),
/* harmony export */   selectors: () => (/* binding */ selectors)
/* harmony export */ });
/* harmony import */ var invariant__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! invariant */ "../node_modules/invariant/browser.js");
/* harmony import */ var invariant__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(invariant__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! lodash */ "../node_modules/lodash/lodash.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var googlesitekit_api__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! googlesitekit-api */ "googlesitekit-api");
/* harmony import */ var googlesitekit_api__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_api__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _js_googlesitekit_data_create_fetch_store__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/googlesitekit/data/create-fetch-store */ "./js/googlesitekit/data/create-fetch-store.js");
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./constants */ "./js/googlesitekit/modules/datastore/constants.js");
/* harmony import */ var _js_googlesitekit_data_utils__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @/js/googlesitekit/data/utils */ "./js/googlesitekit/data/utils.js");
/**
 * `core/modules` data store: module sharing settings
 *
 * Site Kit by Google, Copyright 2022 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * Internal dependencies
 */






// Actions
const SET_SHARING_MANAGEMENT = 'SET_SHARING_MANAGEMENT';
const SET_SHARED_ROLES = 'SET_SHARED_ROLES';
const RECEIVE_GET_SHARING_SETTINGS = 'RECEIVE_GET_SHARING_SETTINGS';
const RECEIVE_SHAREABLE_ROLES = 'RECEIVE_SHAREABLE_ROLES';
const START_SUBMIT_SHARING_CHANGES = 'START_SUBMIT_SHARING_CHANGES';
const FINISH_SUBMIT_SHARING_CHANGES = 'FINISH_SUBMIT_SHARING_CHANGES';
const ROLLBACK_SHARING_SETTINGS = 'ROLLBACK_SHARING_SETTINGS';
const RECEIVE_DEFAULT_SHARED_OWNERSHIP_MODULE_SETTINGS = 'RECEIVE_DEFAULT_SHARED_OWNERSHIP_MODULE_SETTINGS';

// Invariant error messages.
const INVARIANT_DOING_SUBMIT_SHARING_CHANGES = 'cannot submit sharing changes while submitting changes';
const INVARIANT_SHARING_SETTINGS_NOT_CHANGED = 'cannot submit changes if sharing settings have not changed';
const validManagementValues = ['all_admins', 'owner'];
const baseInitialState = {
  sharingSettings: undefined,
  savedSharingSettings: undefined,
  shareableRoles: undefined,
  isDoingSubmitSharingChanges: undefined,
  defaultSharedOwnershipModuleSettings: undefined
};
const fetchSaveSharingSettingsStore = (0,_js_googlesitekit_data_create_fetch_store__WEBPACK_IMPORTED_MODULE_4__.createFetchStore)({
  baseName: 'saveSharingSettings',
  controlCallback: ({
    savedSharingSettings
  }) => {
    return (0,googlesitekit_api__WEBPACK_IMPORTED_MODULE_2__.set)('core', 'modules', 'sharing-settings', savedSharingSettings);
  },
  reducerCallback: (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__.createReducer)((state, {
    settings
  }) => {
    state.savedSharingSettings = settings;
    state.sharingSettings = settings;
  }),
  argsToParams: savedSharingSettings => ({
    savedSharingSettings
  }),
  validateParams: ({
    savedSharingSettings
  } = {}) => {
    invariant__WEBPACK_IMPORTED_MODULE_0___default()(savedSharingSettings, 'savedSharingSettings is required.');
  }
});
const fetchResetSharingSettingsStore = (0,_js_googlesitekit_data_create_fetch_store__WEBPACK_IMPORTED_MODULE_4__.createFetchStore)({
  baseName: 'resetSharingSettings',
  controlCallback: ({}) => {
    return (0,googlesitekit_api__WEBPACK_IMPORTED_MODULE_2__.set)('core', 'modules', 'sharing-settings', {}, {
      method: 'DELETE'
    });
  },
  reducerCallback: (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__.createReducer)(state => {
    state.savedSharingSettings = {};
    state.sharingSettings = {};
  })
});
const baseActions = {
  /**
   * Sets the sharing settings management of a given module.
   *
   * @since 1.77.0
   *
   * @param {string} moduleSlug Module slug.
   * @param {string} management New management for a module, one of all_admins | owner.
   * @return {Object} Action for SET_SHARING_MANAGEMENT.
   */
  setSharingManagement(moduleSlug, management) {
    invariant__WEBPACK_IMPORTED_MODULE_0___default()(moduleSlug, 'moduleSlug is required.');
    invariant__WEBPACK_IMPORTED_MODULE_0___default()(validManagementValues.includes(management), `management must be one of: ${validManagementValues.join(', ')}.`);
    return {
      payload: {
        moduleSlug,
        management
      },
      type: SET_SHARING_MANAGEMENT
    };
  },
  /**
   * Sets the sharing settings shared roles of a given module.
   *
   * @since 1.77.0
   *
   * @param {string}   moduleSlug Module slug.
   * @param {string[]} roles      List of roles the module is shared with.
   * @return {Object} Action for SET_SHARED_ROLES.
   */
  setSharedRoles(moduleSlug, roles) {
    invariant__WEBPACK_IMPORTED_MODULE_0___default()(moduleSlug, 'moduleSlug is required.');
    invariant__WEBPACK_IMPORTED_MODULE_0___default()(Array.isArray(roles) && roles.every(role => typeof role === 'string'), 'roles must be an array of strings.');
    return {
      payload: {
        moduleSlug,
        roles
      },
      type: SET_SHARED_ROLES
    };
  },
  /**
   * Saves sharingSettings for dashboard sharing.
   *
   * Save sharingSettings for dashboard sharing.
   * Update ownerID from the response for the modules in the sharingSettings state.
   *
   * @since 1.77.0
   *
   * @return {Object} Object with `{response, error}`.
   */
  *saveSharingSettings() {
    const registry = yield googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__.commonActions.getRegistry();
    yield {
      type: START_SUBMIT_SHARING_CHANGES,
      payload: {}
    };
    const sharingSettings = registry.select(_constants__WEBPACK_IMPORTED_MODULE_5__.CORE_MODULES).getSharingSettings();
    const {
      response,
      error
    } = yield fetchSaveSharingSettingsStore.actions.fetchSaveSharingSettings(sharingSettings);

    // Update module owner IDs in the sharing settings modules.
    if (!error && Object.keys(response.newOwnerIDs).length) {
      for (const [slug, ownerID] of Object.entries(response.newOwnerIDs)) {
        const storeName = registry.select(_constants__WEBPACK_IMPORTED_MODULE_5__.CORE_MODULES).getModuleStoreName(slug);
        registry.dispatch(storeName).setOwnerID(ownerID);
      }
    }
    yield {
      type: FINISH_SUBMIT_SHARING_CHANGES,
      payload: {}
    };
    return {
      response,
      error
    };
  },
  /**
   * Resets sharingSettings for dashboard sharing.
   *
   * Reset sharingSettings for dashboard sharing.
   *
   * @since 1.84.0
   *
   * @return {Object} Object with `{response, error}`.
   */
  *resetSharingSettings() {
    yield {
      type: START_SUBMIT_SHARING_CHANGES,
      payload: {}
    };
    const {
      response,
      error
    } = yield fetchResetSharingSettingsStore.actions.fetchResetSharingSettings();
    yield {
      type: FINISH_SUBMIT_SHARING_CHANGES,
      payload: {}
    };
    return {
      response,
      error
    };
  },
  /**
   * Receives sharingSettings for dashboard sharing.
   * Stores sharingSettings in the datastore.
   *
   * Because this is frequently-accessed data, this is usually sourced
   * from a global variable (`_googlesitekitDashboardSharingData`), set by PHP
   * in the `before_print` callback for `googlesitekit-datastore-site`.
   *
   * @since 1.77.0
   *
   * @param {Object} sharingSettings Sharing settings for modules with `management` and `sharedRoles` properties.
   * @return {Object} Action for RECEIVE_GET_SHARING_SETTINGS.
   */
  receiveGetSharingSettings(sharingSettings) {
    invariant__WEBPACK_IMPORTED_MODULE_0___default()(sharingSettings, 'sharingSettings is required.');
    return {
      payload: {
        sharingSettings
      },
      type: RECEIVE_GET_SHARING_SETTINGS
    };
  },
  /**
   * Receives shareableRoles for dashboard sharing.
   * Stores shareableRoles in the datastore.
   *
   * Because this is frequently-accessed data, this is usually sourced
   * from a global variable (`_googlesitekitDashboardSharingData`), set by PHP
   * in the `before_print` callback for `googlesitekit-datastore-site`.
   *
   * @since 1.77.0
   *
   * @param {Object} shareableRoles Shareable Roles for modules with `management` and `sharedRoles` properties.
   * @return {Object} Action for RECEIVE_SHAREABLE_ROLES.
   */
  receiveShareableRoles(shareableRoles) {
    invariant__WEBPACK_IMPORTED_MODULE_0___default()(shareableRoles, 'shareableRoles is required.');
    return {
      payload: {
        shareableRoles
      },
      type: RECEIVE_SHAREABLE_ROLES
    };
  },
  /**
   * Restores the sharing settings to the currently saved values.
   *
   * @since 1.78.0
   *
   * @return {Object} Action for ROLLBACK_SHARING_SETTINGS.
   */
  rollbackSharingSettings() {
    return {
      payload: {},
      type: ROLLBACK_SHARING_SETTINGS
    };
  },
  /**
   * Receives defaultSharedOwnershipModuleSettings for dashboard sharing.
   * Stores defaultSharedOwnershipModuleSettings in the datastore.
   *
   * Because this is frequently-accessed data, this is usually sourced
   * from a global variable (`_googlesitekitDashboardSharingData`), set by PHP
   * in the `before_print` callback for `googlesitekit-datastore-site`.
   *
   * @since 1.85.0
   *
   * @param {Object} defaultSharedOwnershipModuleSettings Default sharing settings for the shared ownership modules.
   * @return {Object} Action for RECEIVE_DEFAULT_SHARED_OWNERSHIP_MODULE_SETTINGS.
   */
  receiveDefaultSharedOwnershipModuleSettings(defaultSharedOwnershipModuleSettings) {
    invariant__WEBPACK_IMPORTED_MODULE_0___default()(defaultSharedOwnershipModuleSettings, 'defaultSharedOwnershipModuleSettings is required.');
    return {
      payload: {
        defaultSharedOwnershipModuleSettings
      },
      type: RECEIVE_DEFAULT_SHARED_OWNERSHIP_MODULE_SETTINGS
    };
  }
};
const baseReducer = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__.createReducer)((state, {
  type,
  payload
}) => {
  switch (type) {
    case SET_SHARING_MANAGEMENT:
      {
        const {
          moduleSlug,
          management
        } = payload;
        state.sharingSettings[moduleSlug] = {
          ...state.sharingSettings[moduleSlug],
          management
        };
        break;
      }
    case SET_SHARED_ROLES:
      {
        const {
          moduleSlug,
          roles
        } = payload;
        state.sharingSettings[moduleSlug] = {
          ...state.sharingSettings[moduleSlug],
          sharedRoles: roles
        };
        break;
      }
    case RECEIVE_GET_SHARING_SETTINGS:
      {
        const {
          sharingSettings
        } = payload;
        state.sharingSettings = sharingSettings;
        state.savedSharingSettings = sharingSettings;
        break;
      }
    case RECEIVE_SHAREABLE_ROLES:
      {
        const {
          shareableRoles
        } = payload;
        state.shareableRoles = shareableRoles;
        break;
      }
    case START_SUBMIT_SHARING_CHANGES:
      {
        state.isDoingSubmitSharingChanges = true;
        break;
      }
    case FINISH_SUBMIT_SHARING_CHANGES:
      {
        state.isDoingSubmitSharingChanges = false;
        break;
      }
    case ROLLBACK_SHARING_SETTINGS:
      {
        state.sharingSettings = state.savedSharingSettings;
        break;
      }
    case RECEIVE_DEFAULT_SHARED_OWNERSHIP_MODULE_SETTINGS:
      {
        const {
          defaultSharedOwnershipModuleSettings
        } = payload;
        state.defaultSharedOwnershipModuleSettings = defaultSharedOwnershipModuleSettings;
        break;
      }
    default:
      break;
  }
});
const baseResolvers = {
  *getSharingSettings() {
    const registry = yield googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__.commonActions.getRegistry();
    if (registry.select(_constants__WEBPACK_IMPORTED_MODULE_5__.CORE_MODULES).getSharingSettings()) {
      return;
    }
    if (!__webpack_require__.g._googlesitekitDashboardSharingData) {
      __webpack_require__.g.console.error('Could not load core/modules dashboard sharing settings.');
      return;
    }
    const {
      settings
    } = __webpack_require__.g._googlesitekitDashboardSharingData;
    yield actions.receiveGetSharingSettings(settings);
  },
  *getShareableRoles() {
    const registry = yield googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__.commonActions.getRegistry();
    if (registry.select(_constants__WEBPACK_IMPORTED_MODULE_5__.CORE_MODULES).getShareableRoles()) {
      return;
    }
    if (!__webpack_require__.g._googlesitekitDashboardSharingData) {
      __webpack_require__.g.console.error('Could not load core/modules dashboard sharing roles.');
      return;
    }
    const {
      roles
    } = __webpack_require__.g._googlesitekitDashboardSharingData;
    yield actions.receiveShareableRoles(roles);
  },
  *getDefaultSharedOwnershipModuleSettings() {
    const registry = yield googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__.commonActions.getRegistry();
    if (registry.select(_constants__WEBPACK_IMPORTED_MODULE_5__.CORE_MODULES).getDefaultSharedOwnershipModuleSettings()) {
      return;
    }
    if (!__webpack_require__.g._googlesitekitDashboardSharingData) {
      __webpack_require__.g.console.error('Could not load core/modules dashboard sharing.');
      return;
    }
    const {
      defaultSharedOwnershipModuleSettings
    } = __webpack_require__.g._googlesitekitDashboardSharingData;
    yield baseActions.receiveDefaultSharedOwnershipModuleSettings(defaultSharedOwnershipModuleSettings);
  }
};
function validateCanSubmitSharingChanges(select) {
  const strictSelect = (0,_js_googlesitekit_data_utils__WEBPACK_IMPORTED_MODULE_6__.createStrictSelect)(select);
  const {
    isDoingSubmitSharingChanges,
    haveSharingSettingsChanged
  } = strictSelect(_constants__WEBPACK_IMPORTED_MODULE_5__.CORE_MODULES);
  invariant__WEBPACK_IMPORTED_MODULE_0___default()(!isDoingSubmitSharingChanges(), INVARIANT_DOING_SUBMIT_SHARING_CHANGES);
  invariant__WEBPACK_IMPORTED_MODULE_0___default()(haveSharingSettingsChanged(), INVARIANT_SHARING_SETTINGS_NOT_CHANGED);
}
const {
  safeSelector: canSubmitSharingChanges,
  dangerousSelector: __dangerousCanSubmitSharingChanges
} = (0,_js_googlesitekit_data_utils__WEBPACK_IMPORTED_MODULE_6__.createValidationSelector)(validateCanSubmitSharingChanges);
const baseSelectors = {
  canSubmitSharingChanges,
  __dangerousCanSubmitSharingChanges,
  /**
   * Gets the current dashboard sharing settings.
   *
   * @since 1.77.0
   *
   * @param {Object} state Data store's state.
   * @return {(Object|undefined)} Sharing Settings object. Returns undefined if it is not loaded yet.
   */
  getSharingSettings(state) {
    const {
      sharingSettings
    } = state;
    return sharingSettings;
  },
  /**
   * Gets the current dashboard shareable roles.
   *
   * @since 1.77.0
   *
   * @param {Object} state Data store's state.
   * @return {(Object|undefined)} Shareable Roles object. Returns undefined if it is not loaded yet.
   */
  getShareableRoles(state) {
    const {
      shareableRoles
    } = state;
    return shareableRoles;
  },
  /**
   * Gets the dashboard sharing management for the given module.
   *
   * Returns the module's sharing management string.
   *
   * @since 1.77.0
   *
   * @param {Object} state      Data store's state.
   * @param {string} moduleSlug Module slug.
   * @return {(string|null|undefined)} The module's sharing management string, null if there is none,
   *                                   undefined if not loaded yet.
   */
  getSharingManagement: (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__.createRegistrySelector)(select => (state, moduleSlug) => {
    invariant__WEBPACK_IMPORTED_MODULE_0___default()(moduleSlug, 'moduleSlug is required.');
    const sharingSettings = select(_constants__WEBPACK_IMPORTED_MODULE_5__.CORE_MODULES).getSharingSettings();
    if (sharingSettings === undefined) {
      return undefined;
    }
    return sharingSettings[moduleSlug]?.management || null;
  }),
  /**
   * Gets the shared roles for the given module.
   *
   * Returns the module's shared roles list.
   *
   * @since 1.77.0
   *
   * @param {Object} state      Data store's state.
   * @param {string} moduleSlug Module slug.
   * @return {(Array|null|undefined)} The module's shared roles array, null if there is none,
   *                                   undefined if not loaded yet.
   */
  getSharedRoles: (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__.createRegistrySelector)(select => (state, moduleSlug) => {
    invariant__WEBPACK_IMPORTED_MODULE_0___default()(moduleSlug, 'moduleSlug is required.');
    const sharingSettings = select(_constants__WEBPACK_IMPORTED_MODULE_5__.CORE_MODULES).getSharingSettings();
    if (sharingSettings === undefined) {
      return undefined;
    }
    return sharingSettings[moduleSlug]?.sharedRoles || null;
  }),
  /**
   * Indicates whether the current sharing settings have changed from what is saved.
   *
   * @since 1.77.0
   *
   * @param {Object}     state Data store's state.
   * @param {Array|null} keys  Sharing Settings keys to check; if not provided, all sharing settings are checked.
   * @return {boolean} True if the sharing settings have changed, false otherwise.
   */
  haveSharingSettingsChanged(state, keys = null) {
    const {
      sharingSettings,
      savedSharingSettings
    } = state;
    if (keys) {
      return !(0,lodash__WEBPACK_IMPORTED_MODULE_1__.isEqual)((0,lodash__WEBPACK_IMPORTED_MODULE_1__.pick)(sharingSettings, keys), (0,lodash__WEBPACK_IMPORTED_MODULE_1__.pick)(savedSharingSettings, keys));
    }
    return !(0,lodash__WEBPACK_IMPORTED_MODULE_1__.isEqual)(sharingSettings, savedSharingSettings);
  },
  /**
   * Compares current sharing settings management OR sharedRoles have changed from what is saved.
   *
   * @since 1.78.0
   *
   * @param {Object} state Data store's state.
   * @param {string} key   Sharing Settings property key to check; one of `management` | `sharedRoles`.
   * @return {boolean|undefined} True if the sharing settings have changed, false otherwise, `undefined` if not yet loaded.
   */
  haveSharingSettingsExpanded(state, key) {
    const validKeys = ['management', 'sharedRoles'];
    invariant__WEBPACK_IMPORTED_MODULE_0___default()(validKeys.includes(key), `key must be one of: ${validKeys.join(', ')}.`);
    const {
      sharingSettings,
      savedSharingSettings
    } = state;
    if (sharingSettings === undefined || savedSharingSettings === undefined) {
      return undefined;
    }

    // Return `true` if the management setting for any module has been
    // changed from `owner` to `all_admins`.
    if (key === 'management') {
      return Object.keys(sharingSettings).some(moduleSlug => {
        const hasInitialManagementChanged = savedSharingSettings[moduleSlug]?.management !== sharingSettings[moduleSlug]?.management;
        return hasInitialManagementChanged && sharingSettings[moduleSlug]?.management === 'all_admins';
      });
    }

    // Return `true` if sharing settings for any module contain roles
    // that haven't been previously selected.
    if (key === 'sharedRoles') {
      return Object.keys(sharingSettings).some(moduleSlug => {
        return sharingSettings[moduleSlug]?.sharedRoles?.filter(currentRole => !savedSharingSettings[moduleSlug]?.sharedRoles?.includes(currentRole)).length > 0;
      });
    }
    return false;
  },
  /**
   * Indicates whether the current sharing settings have changed from what is saved for the given module.
   *
   * @since 1.80.0
   *
   * @param {Object}     state      Data store's state.
   * @param {string}     moduleSlug Module slug.
   * @param {Array|null} keys       Sharing Settings keys to check; if not provided, all sharing settings are checked.
   * @return {boolean|undefined} True if the given module's sharing settings have changed; false otherwise; `undefined` if not yet loaded.
   */
  haveModuleSharingSettingsChanged(state, moduleSlug, keys = null) {
    invariant__WEBPACK_IMPORTED_MODULE_0___default()(moduleSlug, 'moduleSlug is required.');
    const {
      sharingSettings,
      savedSharingSettings
    } = state;
    if (sharingSettings === undefined || savedSharingSettings === undefined) {
      return undefined;
    }
    if (keys) {
      return !(0,lodash__WEBPACK_IMPORTED_MODULE_1__.isEqual)((0,lodash__WEBPACK_IMPORTED_MODULE_1__.pick)(sharingSettings[moduleSlug], keys), (0,lodash__WEBPACK_IMPORTED_MODULE_1__.pick)(savedSharingSettings[moduleSlug], keys));
    }
    return !(0,lodash__WEBPACK_IMPORTED_MODULE_1__.isEqual)(sharingSettings[moduleSlug], savedSharingSettings[moduleSlug]);
  },
  /**
   * Checks whether sharing settings changes are currently being submitted.
   *
   * @since 1.77.0
   *
   * @param {Object} state Data store's state.
   * @return {boolean} TRUE if submitting, otherwise FALSE.
   */
  isDoingSubmitSharingChanges(state) {
    return !!state.isDoingSubmitSharingChanges;
  },
  /**
   * Gets the default sharing settings for shared ownership modules.
   *
   * @since 1.85.0
   *
   * @param {Object} state Data store's state.
   * @return {(Object|undefined)} Sharing Settings object. Returns undefined if it is not loaded yet.
   */
  getDefaultSharedOwnershipModuleSettings(state) {
    const {
      defaultSharedOwnershipModuleSettings
    } = state;
    return defaultSharedOwnershipModuleSettings;
  },
  /**
   * Indicates whether the sharing settings have updated from default.
   *
   * @since 1.85.0
   *
   * @param {Object} state Data store's state.
   * @return {boolean} True if the sharing settings have updated, false otherwise.
   */
  haveSharingSettingsUpdated(state) {
    const {
      savedSharingSettings,
      sharedOwnershipModules
    } = state;
    if ((0,lodash__WEBPACK_IMPORTED_MODULE_1__.isEmpty)(savedSharingSettings) || (0,lodash__WEBPACK_IMPORTED_MODULE_1__.isEmpty)(sharedOwnershipModules)) {
      return false;
    }
    return Object.keys(savedSharingSettings).some(moduleSlug => {
      const {
        sharedRoles,
        management
      } = savedSharingSettings[moduleSlug];
      const isSharedOwnershipModule = sharedOwnershipModules.includes(moduleSlug);
      const defaultManagement = isSharedOwnershipModule ? 'all_admins' : 'owner';
      return sharedRoles.length > 0 || management !== defaultManagement;
    });
  }
};
const store = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__.combineStores)(fetchSaveSharingSettingsStore, fetchResetSharingSettingsStore, {
  initialState: baseInitialState,
  actions: baseActions,
  selectors: baseSelectors,
  reducer: baseReducer,
  resolvers: baseResolvers
});
const initialState = store.initialState;
const actions = store.actions;
const selectors = store.selectors;
const reducer = store.reducer;
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (store);

/***/ }),

/***/ "./js/googlesitekit/modules/index.js":
/*!*******************************************!*\
  !*** ./js/googlesitekit/modules/index.js ***!
  \*******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   createModules: () => (/* binding */ createModules),
/* harmony export */   registerStore: () => (/* reexport safe */ _datastore__WEBPACK_IMPORTED_MODULE_2__.registerStore)
/* harmony export */ });
/* harmony import */ var _create_module_store__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./create-module-store */ "./js/googlesitekit/modules/create-module-store.js");
/* harmony import */ var _datastore_constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./datastore/constants */ "./js/googlesitekit/modules/datastore/constants.js");
/* harmony import */ var _datastore__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./datastore */ "./js/googlesitekit/modules/datastore/index.js");
/**
 * Modules API.
 *
 * Provides API functions to manage modules.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Internal dependencies
 */




/**
 * Creates a new instance of Modules.
 *
 * @since 1.26.0
 *
 * @param {Object}   registry          Datastore registry.
 * @param {Function} registry.dispatch Registry dispatch function.
 * @return {Object} Modules instance.
 */
function createModules({
  dispatch
}) {
  const Modules = {
    createModuleStore: _create_module_store__WEBPACK_IMPORTED_MODULE_0__.createModuleStore,
    /**
     * Activates a module on the server.
     *
     * Activate a module (based on the slug provided).
     *
     * @since 1.8.0
     *
     * @param {string} slug Slug of the module to activate.
     * @return {Promise} The dispatched action.
     */
    activateModule: slug => {
      return dispatch(_datastore_constants__WEBPACK_IMPORTED_MODULE_1__.CORE_MODULES).activateModule(slug);
    },
    /**
     * Deactivates a module on the server.
     *
     * Deactivate a module (based on the slug provided).
     *
     * @since 1.8.0
     *
     * @param {string} slug Slug of the module to activate.
     * @return {Promise} The dispatched action.
     */
    deactivateModule: slug => {
      return dispatch(_datastore_constants__WEBPACK_IMPORTED_MODULE_1__.CORE_MODULES).deactivateModule(slug);
    },
    /**
     * Registers a module.
     *
     * @since 1.13.0
     * @since 1.20.0 Introduced the ability to register settings and setup components.
     * @since 1.22.0 Introduced the ability to add a checkRequirements function.
     * @since 1.23.0 Introduced the ability to register an Icon component.
     * @since 1.35.0 Introduced a registry parameter for checkRequirements.
     * @since 1.132.0 Introduced dashboard effect components.
     *
     * @param {string}      slug                                      Module slug.
     * @param {Object}      [settings]                                Optional. Module settings.
     * @param {string}      [settings.name]                           Optional. Module name. Default is the slug.
     * @param {string}      [settings.description]                    Optional. Module description. Default empty string.
     * @param {WPComponent} [settings.Icon]                           Optional. React component to render module icon. Default none.
     * @param {number}      [settings.order]                          Optional. Numeric indicator for module order. Default 10.
     * @param {string}      [settings.homepage]                       Optional. Module homepage URL. Default empty string.
     * @param {WPComponent} [settings.SettingsEditComponent]          Optional. React component to render the settings edit panel. Default none.
     * @param {WPComponent} [settings.SettingsViewComponent]          Optional. React component to render the settings view panel. Default none.
     * @param {WPComponent} [settings.SetupComponent]                 Optional. React component to render the setup panel. Default none.
     * @param {WPComponent} [settings.DashboardMainEffectComponent]   Optional. React component to render the effects on main dashboard. Default none.
     * @param {WPComponent} [settings.DashboardEntityEffectComponent] Optional. React component to render the effects on entity dashboard. Default none.
     * @return {Promise} The dispatched action.
     */
    registerModule: (slug, settings) => {
      return dispatch(_datastore_constants__WEBPACK_IMPORTED_MODULE_1__.CORE_MODULES).registerModule(slug, settings);
    }
  };
  return Modules;
}

/***/ }),

/***/ "./js/material-components/layout/Cell.js":
/*!***********************************************!*\
  !*** ./js/material-components/layout/Cell.js ***!
  \***********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Cell)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Material UI > Layout > Cell component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



function Cell(props) {
  const {
    className,
    alignTop,
    alignMiddle,
    alignBottom,
    alignRight,
    alignLeft,
    smAlignRight,
    mdAlignRight,
    lgAlignRight,
    smSize,
    smStart,
    smOrder,
    mdSize,
    mdStart,
    mdOrder,
    lgSize,
    lgStart,
    lgOrder,
    size,
    children,
    ...otherProps
  } = props;
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", {
    ...otherProps,
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()(className, 'mdc-layout-grid__cell', {
      'mdc-layout-grid__cell--align-top': alignTop,
      'mdc-layout-grid__cell--align-middle': alignMiddle,
      'mdc-layout-grid__cell--align-bottom': alignBottom,
      'mdc-layout-grid__cell--align-right': alignRight,
      'mdc-layout-grid__cell--align-left': alignLeft,
      'mdc-layout-grid__cell--align-right-phone': smAlignRight,
      'mdc-layout-grid__cell--align-right-tablet': mdAlignRight,
      'mdc-layout-grid__cell--align-right-desktop': lgAlignRight,
      [`mdc-layout-grid__cell--span-${size}`]: 12 >= size && size > 0,
      [`mdc-layout-grid__cell--span-${lgSize}-desktop`]: 12 >= lgSize && lgSize > 0,
      [`mdc-layout-grid__cell--start-${lgStart}-desktop`]: 12 >= lgStart && lgStart > 0,
      [`mdc-layout-grid__cell--order-${lgOrder}-desktop`]: 12 >= lgOrder && lgOrder > 0,
      [`mdc-layout-grid__cell--span-${mdSize}-tablet`]: 8 >= mdSize && mdSize > 0,
      [`mdc-layout-grid__cell--start-${mdStart}-tablet`]: 8 >= mdStart && mdStart > 0,
      [`mdc-layout-grid__cell--order-${mdOrder}-tablet`]: 8 >= mdOrder && mdOrder > 0,
      [`mdc-layout-grid__cell--span-${smSize}-phone`]: 4 >= smSize && smSize > 0,
      [`mdc-layout-grid__cell--start-${smStart}-phone`]: 4 >= smStart && smStart > 0,
      [`mdc-layout-grid__cell--order-${smOrder}-phone`]: 4 >= smOrder && smOrder > 0
    }),
    children: children
  });
}
Cell.propTypes = {
  smSize: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().number),
  smStart: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().number),
  smOrder: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().number),
  mdSize: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().number),
  mdStart: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().number),
  mdOrder: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().number),
  lgSize: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().number),
  lgStart: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().number),
  lgOrder: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().number),
  size: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().number),
  alignTop: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().bool),
  alignMiddle: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().bool),
  alignBottom: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().bool),
  alignRight: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().bool),
  alignLeft: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().bool),
  smAlignRight: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().bool),
  mdAlignRight: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().bool),
  lgAlignRight: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().bool),
  className: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().string),
  children: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().node)
};
Cell.defaultProps = {
  className: '',
  size: 0,
  smSize: 0,
  smStart: 0,
  smOrder: 0,
  mdSize: 0,
  mdStart: 0,
  mdOrder: 0,
  lgSize: 0,
  lgStart: 0,
  lgOrder: 0
};

/***/ }),

/***/ "./js/material-components/layout/Grid.js":
/*!***********************************************!*\
  !*** ./js/material-components/layout/Grid.js ***!
  \***********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Material UI > Layout > Grid component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * WordPress dependencies
 */


const Grid = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.forwardRef)(({
  alignLeft,
  fill,
  className,
  children,
  collapsed,
  ...otherProps
}, ref) => {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", {
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('mdc-layout-grid', className, {
      'mdc-layout-grid--align-left': alignLeft,
      'mdc-layout-grid--collapsed': collapsed,
      'mdc-layout-grid--fill': fill
    }),
    ...otherProps,
    ref: ref,
    children: children
  });
});
Grid.displayName = 'Grid';
Grid.propTypes = {
  alignLeft: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().bool),
  fill: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().bool),
  className: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  collapsed: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().bool),
  children: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().node)
};
Grid.defaultProps = {
  className: ''
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Grid);

/***/ }),

/***/ "./js/material-components/layout/Row.js":
/*!**********************************************!*\
  !*** ./js/material-components/layout/Row.js ***!
  \**********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Material UI > Layout > Row component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * WordPress dependencies
 */


const Row = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.forwardRef)(({
  className,
  children,
  ...otherProps
}, ref) => {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", {
    ref: ref,
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('mdc-layout-grid__inner', className),
    ...otherProps,
    children: children
  });
});
Row.displayName = 'Row';
Row.propTypes = {
  className: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  children: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().node)
};
Row.defaultProps = {
  className: ''
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Row);

/***/ }),

/***/ "./js/material-components/layout/index.js":
/*!************************************************!*\
  !*** ./js/material-components/layout/index.js ***!
  \************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Cell: () => (/* reexport safe */ _Cell__WEBPACK_IMPORTED_MODULE_0__["default"]),
/* harmony export */   Grid: () => (/* reexport safe */ _Grid__WEBPACK_IMPORTED_MODULE_2__["default"]),
/* harmony export */   Row: () => (/* reexport safe */ _Row__WEBPACK_IMPORTED_MODULE_1__["default"])
/* harmony export */ });
/* harmony import */ var _Cell__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./Cell */ "./js/material-components/layout/Cell.js");
/* harmony import */ var _Row__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Row */ "./js/material-components/layout/Row.js");
/* harmony import */ var _Grid__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./Grid */ "./js/material-components/layout/Grid.js");
/**
 * Material UI > Layout components.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */





/***/ }),

/***/ "./js/util/chart.js":
/*!**************************!*\
  !*** ./js/util/chart.js ***!
  \**************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   calculateDifferenceBetweenChartValues: () => (/* binding */ calculateDifferenceBetweenChartValues),
/* harmony export */   getChartDifferenceArrow: () => (/* binding */ getChartDifferenceArrow),
/* harmony export */   isSingleSlice: () => (/* binding */ isSingleSlice)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/@wordpress/element/build-module/serialize.js");
/* harmony import */ var _js_components_ChangeArrow__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @/js/components/ChangeArrow */ "./js/components/ChangeArrow.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Utility functions for charts.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */


/**
 * Gets the up/down SVG arrow for Google Chart tooltips.
 *
 * @since 1.30.0
 *
 * @param {number}  difference            The difference which can be positive or negative.
 * @param {string}  [options]             Options to be passed to the ChangeArrow component.
 * @param {boolean} [options.invertColor] Whether we need to reverse the +/- colors of the arrow.
 * @return {string} SVG for the +/- difference.
 */

function getChartDifferenceArrow(difference, options = {}) {
  if (Number.isNaN(Number(difference))) {
    return '';
  }
  const {
    invertColor = false
  } = options;
  return (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__["default"])(/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)(_js_components_ChangeArrow__WEBPACK_IMPORTED_MODULE_0__["default"], {
    direction: difference > 0 ? 'up' : 'down',
    invertColor: invertColor
  }));
}

/**
 * Checks if there is a single row of data or one row is contributing 100% of the total for a given dimension.
 *
 * @since 1.31.0
 *
 * @param {Array.<Object>} report An array of report data objects.
 * @return {(boolean|undefined)} Returns undefined if report is undefined, true/false for the above conditions.
 */
function isSingleSlice(report) {
  if (report === undefined) {
    return undefined;
  }
  if (report?.[0]?.data?.rows?.length === 1 || report?.[0]?.data?.rows?.[0]?.metrics?.[0]?.values?.[0] === report?.[0]?.data?.totals?.[0]?.values?.[0]) {
    return true;
  }
  return false;
}

/**
 * Calculates difference between two chart values.
 *
 * @since 1.48.0
 *
 * @param {number} currentValue  Current chart value.
 * @param {number} previousValue Previous chart value.
 * @return {number} The difference.
 */
function calculateDifferenceBetweenChartValues(currentValue, previousValue) {
  if (currentValue > 0 && previousValue > 0) {
    return currentValue / previousValue - 1;
  }
  if (currentValue > 0) {
    return 1;
  }
  if (previousValue > 0) {
    return -1;
  }
  return 0;
}

/***/ }),

/***/ "./js/util/convert-time.js":
/*!*********************************!*\
  !*** ./js/util/convert-time.js ***!
  \*********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   convertDateStringToUNIXTimestamp: () => (/* binding */ convertDateStringToUNIXTimestamp),
/* harmony export */   convertSecondsToArray: () => (/* binding */ convertSecondsToArray)
/* harmony export */ });
/**
 * Time related utility functions.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Converts seconds into an array with the following values [HH, MM, SS, MS] as described below.
 * HH: hours.
 * MM: minutes.
 * SS: seconds.
 * MS: milliseconds.
 *
 * For example, passing 196.385 returns [ 0, 3, 16, 385 ].
 *
 * @since 1.27.0
 *
 * @param {number} seconds The number of seconds.
 * @return {Array} Array containing the hours, minutes, seconds and milliseconds.
 */
function convertSecondsToArray(seconds) {
  seconds = parseFloat(seconds);
  if (isNaN(seconds) || 0 === seconds) {
    return [0, 0, 0, 0];
  }
  return [Math.floor(seconds / 60 / 60), Math.floor(seconds / 60 % 60), Math.floor(seconds % 60), Math.floor(seconds * 1000) - Math.floor(seconds) * 1000];
}

/**
 * Converts Date time string into UNIX timestamp in milliseconds.
 *
 * For example, passing "2014-10-02T15:01:23Z" returns 1412262083000.
 *
 * @since 1.116.0
 *
 * @param {string} dateStringValue The date time string.
 * @return {number} UNIX timestamp in milliseconds.
 */
function convertDateStringToUNIXTimestamp(dateStringValue) {
  const unixTimestamp = dateStringValue && !Number.isInteger(dateStringValue) ?
  // Valid use of `new Date()` with an argument, because this should only
  // be passed full time strings, not `YYYY-MM-DD` style dates.
  //
  // See: https://github.com/google/site-kit-wp/pull/9459#discussion_r1790660073
  // eslint-disable-next-line sitekit/no-direct-date
  new Date(dateStringValue).getTime() : dateStringValue;
  if (isNaN(unixTimestamp) || !unixTimestamp) {
    return 0;
  }
  return unixTimestamp;
}

/***/ }),

/***/ "./js/util/dates.js":
/*!**************************!*\
  !*** ./js/util/dates.js ***!
  \**************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   DAY_IN_SECONDS: () => (/* binding */ DAY_IN_SECONDS),
/* harmony export */   HOUR_IN_SECONDS: () => (/* binding */ HOUR_IN_SECONDS),
/* harmony export */   INVALID_DATE_INSTANCE_ERROR: () => (/* binding */ INVALID_DATE_INSTANCE_ERROR),
/* harmony export */   INVALID_DATE_RANGE_ERROR: () => (/* binding */ INVALID_DATE_RANGE_ERROR),
/* harmony export */   INVALID_DATE_STRING_ERROR: () => (/* binding */ INVALID_DATE_STRING_ERROR),
/* harmony export */   MINUTE_IN_SECONDS: () => (/* binding */ MINUTE_IN_SECONDS),
/* harmony export */   MONTH_IN_SECONDS: () => (/* binding */ MONTH_IN_SECONDS),
/* harmony export */   WEEK_IN_SECONDS: () => (/* binding */ WEEK_IN_SECONDS),
/* harmony export */   dateSub: () => (/* binding */ dateSub),
/* harmony export */   getAvailableDateRanges: () => (/* binding */ getAvailableDateRanges),
/* harmony export */   getCurrentDateRangeDayCount: () => (/* binding */ getCurrentDateRangeDayCount),
/* harmony export */   getDateString: () => (/* binding */ getDateString),
/* harmony export */   getPreviousDate: () => (/* binding */ getPreviousDate),
/* harmony export */   isValidDateRange: () => (/* binding */ isValidDateRange),
/* harmony export */   isValidDateString: () => (/* binding */ isValidDateString),
/* harmony export */   stringToDate: () => (/* binding */ stringToDate)
/* harmony export */ });
/* harmony import */ var invariant__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! invariant */ "../node_modules/invariant/browser.js");
/* harmony import */ var invariant__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(invariant__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! lodash */ "../node_modules/lodash/lodash.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__);
/**
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * WordPress dependencies
 */

const INVALID_DATE_INSTANCE_ERROR = 'Date param must construct to a valid date instance or be a valid date instance itself.';
const INVALID_DATE_STRING_ERROR = 'Invalid dateString parameter, it must be a string.';
const INVALID_DATE_RANGE_ERROR = 'Invalid date range, it must be a string with the format "last-x-days".';
const MINUTE_IN_SECONDS = 60;
const HOUR_IN_SECONDS = 60 * MINUTE_IN_SECONDS;
const DAY_IN_SECONDS = 24 * HOUR_IN_SECONDS;
const WEEK_IN_SECONDS = 7 * DAY_IN_SECONDS;
const MONTH_IN_SECONDS = 30 * DAY_IN_SECONDS;

/**
 * Gets the hash of available date ranges.
 *
 * @since 1.12.0
 *
 * @return {Object} The object hash where every key is a date range slug, and the value is an object with the date range slug and its translation.
 */
function getAvailableDateRanges() {
  function label(days) {
    return (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.sprintf)(/* translators: %s: number of days */
    (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__._n)('Last %s day', 'Last %s days', days, 'google-site-kit'), days);
  }
  return {
    'last-7-days': {
      slug: 'last-7-days',
      label: label(7),
      days: 7
    },
    'last-14-days': {
      slug: 'last-14-days',
      label: label(14),
      days: 14
    },
    'last-28-days': {
      slug: 'last-28-days',
      label: label(28),
      days: 28
    },
    'last-90-days': {
      slug: 'last-90-days',
      label: label(90),
      days: 90
    }
  };
}

/**
 * Gets the current dateRange day count.
 *
 * @since 1.19.0
 * @since 1.26.0 `dateRange` is now a required argument.
 *
 * @param {string} dateRange The date range slug.
 * @return {number} The number of days in the range.
 */
function getCurrentDateRangeDayCount(dateRange) {
  const daysMatch = dateRange.match(/last-(\d+)-days/);
  if (daysMatch && daysMatch[1]) {
    return parseInt(daysMatch[1], 10);
  }
  throw new Error('Unrecognized date range slug.');
}

/**
 * Asserts whether a given date string is valid or invalid.
 *
 * @since 1.18.0
 *
 * @param {string} dateString Date string to be asserted against. Defaults to an empty string.
 * @return {boolean}          True if the given date string is valid.
 */
function isValidDateString(dateString = '') {
  if (!(0,lodash__WEBPACK_IMPORTED_MODULE_1__.isString)(dateString)) {
    return false;
  }
  const dateArray = dateString.split('-');
  if (dateArray.length !== 3) {
    return false;
  }

  // Valid use of `new Date()`, constructing a new date from the string.
  // eslint-disable-next-line sitekit/no-direct-date
  const date = new Date(dateString);
  return (0,lodash__WEBPACK_IMPORTED_MODULE_1__.isDate)(date) && !isNaN(date);
}

/**
 * Parses the given Date instance and returns a date string (YYYY-MM-DD).
 *
 * @since 1.18.0
 * @since 1.85.0 Updated the function signature to only accept a Date argument.
 *
 * @param {Date} date Date to parse into a string.
 * @return {string}                 The parsed date string (YYYY-MM-DD).
 */
function getDateString(date) {
  invariant__WEBPACK_IMPORTED_MODULE_0___default()((0,lodash__WEBPACK_IMPORTED_MODULE_1__.isDate)(date) && !isNaN(date), INVALID_DATE_INSTANCE_ERROR);
  const month = `${date.getMonth() + 1}`;
  const day = `${date.getDate()}`;
  const year = date.getFullYear();
  return [year, month.length < 2 ? `0${month}` : month, day.length < 2 ? `0${day}` : day].join('-');
}

/**
 * Converts a valid date string to a Date instance.
 *
 * @since 1.38.0
 *
 * @param {string} dateString The date string to parse.
 * @return {Date} Date instance.
 */
function stringToDate(dateString) {
  invariant__WEBPACK_IMPORTED_MODULE_0___default()(isValidDateString(dateString), INVALID_DATE_STRING_ERROR);

  /**
   * Split date into explicit parts rather than pass directly into date constructor
   * to avoid timezone issues caused by parsing as UTC. Ensures date is accurate for
   * the user's local time, otherwise has a chance to return a different day than was
   * passed in depending on timezone.
   */
  const [year, month, day] = dateString.split('-');
  return new Date(year, month - 1, day);
}

/**
 * Parses the given date and returns the previous date (daysBefore).
 *
 * @since 1.18.0
 *
 * @param {string} relativeDate Date string (YYYY-MM-DD) to subtract days from.
 * @param {number} daysBefore   Number of days to subtract from relativeDate.
 * @return {string}             The date string (YYYY-MM-DD) for the previous date.
 */
function getPreviousDate(relativeDate, daysBefore) {
  return getDateString(dateSub(relativeDate, daysBefore * DAY_IN_SECONDS));
}

/**
 * Asserts whether a given dateRange string is valid or invalid.
 *
 * @since 1.18.0
 *
 * @param {string} dateRange Date string to be asserted against. Defaults to an empty string.
 * @return {boolean}          True if the given dateRange string is valid.
 */
function isValidDateRange(dateRange) {
  const parts = dateRange.split('-');
  return parts.length === 3 && parts[0] === 'last' && !Number.isNaN(parts[1]) && !Number.isNaN(parseFloat(parts[1])) && parts[2] === 'days';
}

/**
 * Subtracts duration from the prodived date and returns it.
 *
 * @since 1.132.0
 *
 * @param {Date|string} relativeDate Date string (YYYY-MM-DD) or date object to subtract duration from.
 * @param {number}      duration     The duration in seconds to subtract from relativeDate.
 * @return {Date} Resulting date.
 */
function dateSub(relativeDate, duration) {
  invariant__WEBPACK_IMPORTED_MODULE_0___default()(isValidDateString(relativeDate) || (0,lodash__WEBPACK_IMPORTED_MODULE_1__.isDate)(relativeDate) && !isNaN(relativeDate), INVALID_DATE_STRING_ERROR);
  const timestamp = isValidDateString(relativeDate) ? Date.parse(relativeDate) : relativeDate.getTime();

  // Valid use of `new Date()` using calculations.
  // eslint-disable-next-line sitekit/no-direct-date
  return new Date(timestamp - duration * 1000);
}

/***/ }),

/***/ "./js/util/i18n.js":
/*!*************************!*\
  !*** ./js/util/i18n.js ***!
  \*************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   createDurationFormat: () => (/* binding */ createDurationFormat),
/* harmony export */   expandNumFmtOptions: () => (/* binding */ expandNumFmtOptions),
/* harmony export */   getLocale: () => (/* binding */ getLocale),
/* harmony export */   listFormat: () => (/* binding */ listFormat),
/* harmony export */   numFmt: () => (/* binding */ numFmt),
/* harmony export */   numberFormat: () => (/* binding */ numberFormat),
/* harmony export */   prepareForReadableLargeNumber: () => (/* binding */ prepareForReadableLargeNumber),
/* harmony export */   readableLargeNumber: () => (/* binding */ readableLargeNumber)
/* harmony export */ });
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! lodash */ "../node_modules/lodash/lodash.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var memize__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! memize */ "../node_modules/memize/index.js");
/* harmony import */ var memize__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(memize__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__);
/**
 * Internationalization Utilities.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * WordPress dependencies
 */


/**
 * Converts seconds to a display ready string indicating
 * the number of hours, minutes and seconds that have elapsed.
 *
 * For example, passing 65 returns '1m 5s'.
 *
 * @since 1.0.0
 * @since 1.28.0 Refactored and renamed to improve localization.
 * @private
 *
 * @param {number}                     durationInSeconds The number of seconds.
 * @param {(Intl.NumberFormatOptions)} [options]         Optional formatting options.
 * @return {string} Human readable string indicating time elapsed.
 */
function durationFormat(durationInSeconds, options = {}) {
  const {
    formatUnit,
    formatDecimal
  } = createDurationFormat(durationInSeconds, options);
  try {
    // Some browsers, e.g. Safari, throw a RangeError when options.style is
    // not one of decimal, percent, or currency.
    return formatUnit();
  } catch {
    // Fallback to XXh YYm ZZs using localized decimals with hardcoded units.
    return formatDecimal();
  }
}

/**
 * Converts seconds to a display ready string indicating
 * the number of hours, minutes and seconds that have elapsed
 * in ISO format - HH:mm:ss.
 *
 * If the duration is less than an hour, the HH part of the string
 * is truncated.
 * For example, passing 65 returns '01:05'.
 * Passing 5400 returns '01:30:00'.
 *
 * @since 1.111.0
 * @private
 *
 * @param {number} durationInSeconds The number of seconds.
 * @return {string} Human readable string indicating time elapsed.
 */
function durationISOFormat(durationInSeconds) {
  let {
    hours,
    minutes,
    seconds
  } = parseDuration(durationInSeconds);
  seconds = ('0' + seconds).slice(-2);
  minutes = ('0' + minutes).slice(-2);
  hours = ('0' + hours).slice(-2);
  return hours === '00' ? `${minutes}:${seconds}` : `${hours}:${minutes}:${seconds}`;
}

/**
 * Parses the duration in seconds into hours, minutes and seconds.
 *
 * @since 1.111.0
 * @private
 *
 * @param {number} durationInSeconds The number of seconds.
 * @return {Object} Number of hours, minutes and seconds equivalent
 * to the given duration in seconds.
 */
function parseDuration(durationInSeconds) {
  durationInSeconds = parseInt(durationInSeconds, 10);
  if (Number.isNaN(durationInSeconds)) {
    durationInSeconds = 0;
  }
  const hours = Math.floor(durationInSeconds / 60 / 60);
  const minutes = Math.floor(durationInSeconds / 60 % 60);
  const seconds = Math.floor(durationInSeconds % 60);
  return {
    hours,
    minutes,
    seconds
  };
}

/**
 * Creates duration formatting utilities.
 *
 * Not intended to be used directly.
 * Use `numFmt( number, { style: 'duration' } )` instead.
 *
 * @since 1.29.0
 * @private
 *
 * @param {number} durationInSeconds Duration to format.
 * @param {Object} [options]         Formatting options.
 * @return {Object} Formatting functions.
 */
function createDurationFormat(durationInSeconds, options = {}) {
  const {
    hours,
    minutes,
    seconds
  } = parseDuration(durationInSeconds);
  return {
    hours,
    minutes,
    seconds,
    formatUnit() {
      const {
        unitDisplay = 'short',
        ...restOptions
      } = options;
      const commonOptions = {
        unitDisplay,
        ...restOptions,
        style: 'unit'
      };
      if (durationInSeconds === 0) {
        return numberFormat(seconds, {
          ...commonOptions,
          unit: 'second'
        });
      }
      return (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.sprintf)(/* translators: 1: formatted seconds, 2: formatted minutes, 3: formatted hours */
      (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__._x)('%3$s %2$s %1$s', 'duration of time: hh mm ss', 'google-site-kit'), seconds ? numberFormat(seconds, {
        ...commonOptions,
        unit: 'second'
      }) : '', minutes ? numberFormat(minutes, {
        ...commonOptions,
        unit: 'minute'
      }) : '', hours ? numberFormat(hours, {
        ...commonOptions,
        unit: 'hour'
      }) : '').trim();
    },
    /**
     * Formats the duration using integers and translatable strings.
     * This is only used as a fallback when the above `formatUnit` fails.
     *
     * @since 1.29.0
     *
     * @return {string} Formatted duration.
     */
    formatDecimal() {
      const formattedSeconds = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.sprintf)(
      // translators: %s: number of seconds with "s" as the abbreviated unit.
      (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('%ds', 'google-site-kit'), seconds);
      if (durationInSeconds === 0) {
        return formattedSeconds;
      }
      const formattedMinutes = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.sprintf)(
      // translators: %s: number of minutes with "m" as the abbreviated unit.
      (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('%dm', 'google-site-kit'), minutes);
      const formattedHours = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.sprintf)(
      // translators: %s: number of hours with "h" as the abbreviated unit.
      (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('%dh', 'google-site-kit'), hours);
      return (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.sprintf)(/* translators: 1: formatted seconds, 2: formatted minutes, 3: formatted hours */
      (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__._x)('%3$s %2$s %1$s', 'duration of time: hh mm ss', 'google-site-kit'), seconds ? formattedSeconds : '', minutes ? formattedMinutes : '', hours ? formattedHours : '').trim();
    }
  };
}

/**
 * Prepares a number to be used in readableLargeNumber.
 *
 * @since 1.7.0
 *
 * @param {number} number The large number to prepare.
 * @return {number} The prepared number.
 */
function prepareForReadableLargeNumber(number) {
  if (1000000 <= number) {
    return Math.round(number / 100000) / 10;
  }
  if (10000 <= number) {
    return Math.round(number / 1000);
  }
  if (1000 <= number) {
    return Math.round(number / 100) / 10;
  }
  return number;
}

/**
 * Formats a large number for shortened display.
 *
 * @since 1.0.0
 *
 * @param {number} number The large number to format.
 * @return {string} The formatted number.
 */
function readableLargeNumber(number) {
  const withSingleDecimal = {
    minimumFractionDigits: 1,
    maximumFractionDigits: 1
  };

  // Numbers over 1,000,000 round normally and display a single decimal unless the decimal is 0.
  if (1000000 <= number) {
    return (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.sprintf)(
    // translators: %s: an abbreviated number in millions.
    (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('%sM', 'google-site-kit'), numberFormat(prepareForReadableLargeNumber(number), number % 10 === 0 ? {} : withSingleDecimal));
  }

  // Numbers between 10,000 and 1,000,000 round normally and have no decimals
  if (10000 <= number) {
    return (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.sprintf)(
    // translators: %s: an abbreviated number in thousands.
    (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('%sK', 'google-site-kit'), numberFormat(prepareForReadableLargeNumber(number)));
  }

  // Numbers between 1,000 and 10,000 round normally and display a single decimal unless the decimal is 0.
  if (1000 <= number) {
    return (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.sprintf)(
    // translators: %s: an abbreviated number in thousands.
    (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('%sK', 'google-site-kit'), numberFormat(prepareForReadableLargeNumber(number), number % 10 === 0 ? {} : withSingleDecimal));
  }
  return numberFormat(number, {
    signDisplay: 'never',
    maximumFractionDigits: 1
  });
}

/**
 * Parses formatting options and returns an object with options for selected formatting.
 *
 * @since 1.103.0
 *
 * @param {(Intl.NumberFormatOptions|string)} options Formatting options or unit shorthand. Possible shorthand values are '%', 's', or a currency code.
 * @return {Object} Formatting options.
 */
function expandNumFmtOptions(options) {
  let formatOptions = {};

  // Expand shorthand values for units.
  if ('%' === options) {
    formatOptions = {
      style: 'percent',
      maximumFractionDigits: 2
    };
  } else if ('s' === options) {
    formatOptions = {
      style: 'duration',
      unitDisplay: 'narrow'
    };
  } else if (!!options && typeof options === 'string') {
    formatOptions = {
      style: 'currency',
      currency: options
    };
  } else if ((0,lodash__WEBPACK_IMPORTED_MODULE_0__.isPlainObject)(options)) {
    formatOptions = {
      ...options
    };
  }
  return formatOptions;
}

/**
 * Formats a number with unit using the JS Internationalization Number Format API.
 *
 * In addition to the supported 'style' values of the lower-level `numberFormat` function, this function
 * supports two additional 'style' values 'metric' and 'duration' (expects a number in seconds).
 *
 * Another differentiation in behavior is that by default the function will use 'metric' formatting instead
 * of 'decimal' formatting.
 *
 * @since 1.24.0
 *
 * @param {number|string}                     number    The number to format.
 * @param {(Intl.NumberFormatOptions|string)} [options] Formatting options or unit shorthand.
 *                                                      Possible shorthand values are '%', 's',
 *                                                      or a currency code.
 * @return {string} The formatted number.
 */
function numFmt(number, options = {}) {
  // Cast parsable values to numeric types.
  number = (0,lodash__WEBPACK_IMPORTED_MODULE_0__.isFinite)(number) ? number : Number(number);
  if (!(0,lodash__WEBPACK_IMPORTED_MODULE_0__.isFinite)(number)) {
    // eslint-disable-next-line no-console
    console.warn('Invalid number', number, typeof number);
    number = 0;
  }
  const formatOptions = expandNumFmtOptions(options);
  const {
    style = 'metric'
  } = formatOptions; // Note: `metric` is our custom, default style.

  if ('metric' === style) {
    return readableLargeNumber(number);
  }
  if ('duration' === style) {
    return durationFormat(number, formatOptions);
  }
  if ('durationISO' === style) {
    return durationISOFormat(number);
  }
  return numberFormat(number, formatOptions);
}

// Warn once for a given message.
const warnOnce = memize__WEBPACK_IMPORTED_MODULE_1___default()(console.warn); // eslint-disable-line no-console

/**
 * Formats a number using the JS Internationalization Number Format API.
 *
 * @since 1.8.0
 * @see {@link https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/NumberFormat/NumberFormat|`options` parameter} For all available formatting options.
 *
 * @param {number}                   number           The number to format.
 * @param {Intl.NumberFormatOptions} [options]        Formatting options.
 * @param {string}                   [options.locale] Locale to use for formatting. Defaults to current locale used by Site Kit.
 * @return {string} The formatted number.
 */
function numberFormat(number, options = {}) {
  const {
    locale = getLocale(),
    ...formatOptions
  } = options;
  try {
    /**
     * Per https://github.com/google/site-kit-wp/issues/3255 there have been issues with some versions of Safari
     * on some operating systems throwing issues with some parameters in the formatOptions.
     *
     * If an error is thrown, we remove some troublesome params from the formatOptions object and fallback to no formatting.
     *
     * This allows us to degrade somewhat gracefully without breaking the dashboard for users of unaffected browsers.
     */
    return new Intl.NumberFormat(locale, formatOptions).format(number);
  } catch (error) {
    warnOnce(`Site Kit numberFormat error: Intl.NumberFormat( ${JSON.stringify(locale)}, ${JSON.stringify(formatOptions)} ).format( ${typeof number} )`, error.message);
  }

  // Remove these key/values from formatOptions.
  const unstableFormatOptionValues = {
    currencyDisplay: 'narrow',
    currencySign: 'accounting',
    style: 'unit'
  };

  // Remove these keys from formatOptions irrespective of value.
  const unstableFormatOptions = ['signDisplay', 'compactDisplay'];
  const reducedFormatOptions = {};
  for (const [key, value] of Object.entries(formatOptions)) {
    if (unstableFormatOptionValues[key] && value === unstableFormatOptionValues[key]) {
      continue;
    }
    if (unstableFormatOptions.includes(key)) {
      continue;
    }
    reducedFormatOptions[key] = value;
  }
  try {
    return new Intl.NumberFormat(locale, reducedFormatOptions).format(number);
  } catch {
    return new Intl.NumberFormat(locale).format(number);
  }
}

/**
 * Flattens an array of strings into a string using the JS Internationalization List Format API.
 *
 * @since 1.23.0
 * @see {@link https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Intl/ListFormat/ListFormat|`options` parameter} For all available options.
 *
 * @param {Array}  list             The list to flatten.
 * @param {Object} [options]        Formatting options.
 * @param {string} [options.locale] Locale to use for formatting. Defaults to current locale used by Site Kit.
 * @param {string} [options.style]  Length of the formatted message. Defaults to long.
 * @param {string} [options.type]   Type of list. Defaults to 'conjunction' (A, B, and C).
 *                                  Also available 'disjunction' (A, B, or C)
 *                                  Also available 'unit' (5 pounds, 12 ounces)
 * @return {string} The flattened list.
 */
function listFormat(list, options = {}) {
  const {
    locale = getLocale(),
    style = 'long',
    type = 'conjunction'
  } = options;

  // Not all browsers support Intl.Listformat per
  // https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Intl/ListFormat/ListFormat#Browser_compatibility
  // We've seen that the built versions don't polyfill for the unsupported browsers (iOS/safari) so we provide a fallback.
  if (Intl.ListFormat) {
    const formatter = new Intl.ListFormat(locale, {
      style,
      type
    });
    return formatter.format(list);
  }

  /* translators: used between list items, there is a space after the comma. */
  const listSeparator = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)(', ', 'google-site-kit');
  return list.join(listSeparator);
}

/**
 * Gets the current locale for use with browser APIs.
 *
 * @since 1.8.0
 *
 * @param {Object} _global The global window object.
 * @return {string} Current Site Kit locale if set, otherwise the current language set by the browser.
 *                  E.g. `en-US` or `de-DE`
 */
function getLocale(_global = __webpack_require__.g) {
  const siteKitLocale = (0,lodash__WEBPACK_IMPORTED_MODULE_0__.get)(_global, ['_googlesitekitLegacyData', 'locale']);
  if (siteKitLocale) {
    const matches = siteKitLocale.match(/^(\w{2})?(_)?(\w{2})/);
    if (matches && matches[0]) {
      return matches[0].replace(/_/g, '-');
    }
  }
  return _global.navigator.language;
}

/***/ }),

/***/ "./js/util/index.js":
/*!**************************!*\
  !*** ./js/util/index.js ***!
  \**************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   DAY_IN_SECONDS: () => (/* reexport safe */ _dates__WEBPACK_IMPORTED_MODULE_8__.DAY_IN_SECONDS),
/* harmony export */   HOUR_IN_SECONDS: () => (/* reexport safe */ _dates__WEBPACK_IMPORTED_MODULE_8__.HOUR_IN_SECONDS),
/* harmony export */   INVALID_DATE_INSTANCE_ERROR: () => (/* reexport safe */ _dates__WEBPACK_IMPORTED_MODULE_8__.INVALID_DATE_INSTANCE_ERROR),
/* harmony export */   INVALID_DATE_RANGE_ERROR: () => (/* reexport safe */ _dates__WEBPACK_IMPORTED_MODULE_8__.INVALID_DATE_RANGE_ERROR),
/* harmony export */   INVALID_DATE_STRING_ERROR: () => (/* reexport safe */ _dates__WEBPACK_IMPORTED_MODULE_8__.INVALID_DATE_STRING_ERROR),
/* harmony export */   MINUTE_IN_SECONDS: () => (/* reexport safe */ _dates__WEBPACK_IMPORTED_MODULE_8__.MINUTE_IN_SECONDS),
/* harmony export */   MONTH_IN_SECONDS: () => (/* reexport safe */ _dates__WEBPACK_IMPORTED_MODULE_8__.MONTH_IN_SECONDS),
/* harmony export */   WEEK_IN_SECONDS: () => (/* reexport safe */ _dates__WEBPACK_IMPORTED_MODULE_8__.WEEK_IN_SECONDS),
/* harmony export */   calculateChange: () => (/* binding */ calculateChange),
/* harmony export */   calculateDifferenceBetweenChartValues: () => (/* reexport safe */ _chart__WEBPACK_IMPORTED_MODULE_9__.calculateDifferenceBetweenChartValues),
/* harmony export */   convertDateStringToUNIXTimestamp: () => (/* reexport safe */ _convert_time__WEBPACK_IMPORTED_MODULE_7__.convertDateStringToUNIXTimestamp),
/* harmony export */   convertSecondsToArray: () => (/* reexport safe */ _convert_time__WEBPACK_IMPORTED_MODULE_7__.convertSecondsToArray),
/* harmony export */   createDurationFormat: () => (/* reexport safe */ _i18n__WEBPACK_IMPORTED_MODULE_5__.createDurationFormat),
/* harmony export */   dateSub: () => (/* reexport safe */ _dates__WEBPACK_IMPORTED_MODULE_8__.dateSub),
/* harmony export */   decodeHTMLEntity: () => (/* binding */ decodeHTMLEntity),
/* harmony export */   expandNumFmtOptions: () => (/* reexport safe */ _i18n__WEBPACK_IMPORTED_MODULE_5__.expandNumFmtOptions),
/* harmony export */   getAvailableDateRanges: () => (/* reexport safe */ _dates__WEBPACK_IMPORTED_MODULE_8__.getAvailableDateRanges),
/* harmony export */   getChartDifferenceArrow: () => (/* reexport safe */ _chart__WEBPACK_IMPORTED_MODULE_9__.getChartDifferenceArrow),
/* harmony export */   getCurrentDateRangeDayCount: () => (/* reexport safe */ _dates__WEBPACK_IMPORTED_MODULE_8__.getCurrentDateRangeDayCount),
/* harmony export */   getDateString: () => (/* reexport safe */ _dates__WEBPACK_IMPORTED_MODULE_8__.getDateString),
/* harmony export */   getFullURL: () => (/* reexport safe */ _urls__WEBPACK_IMPORTED_MODULE_10__.getFullURL),
/* harmony export */   getLocale: () => (/* reexport safe */ _i18n__WEBPACK_IMPORTED_MODULE_5__.getLocale),
/* harmony export */   getPreviousDate: () => (/* reexport safe */ _dates__WEBPACK_IMPORTED_MODULE_8__.getPreviousDate),
/* harmony export */   getStorage: () => (/* reexport safe */ _storage__WEBPACK_IMPORTED_MODULE_4__.getStorage),
/* harmony export */   getURLPath: () => (/* reexport safe */ _urls__WEBPACK_IMPORTED_MODULE_10__.getURLPath),
/* harmony export */   isHashOnly: () => (/* reexport safe */ _urls__WEBPACK_IMPORTED_MODULE_10__.isHashOnly),
/* harmony export */   isNumeric: () => (/* reexport safe */ _isnumeric__WEBPACK_IMPORTED_MODULE_12__.isNumeric),
/* harmony export */   isSingleSlice: () => (/* reexport safe */ _chart__WEBPACK_IMPORTED_MODULE_9__.isSingleSlice),
/* harmony export */   isValidDateRange: () => (/* reexport safe */ _dates__WEBPACK_IMPORTED_MODULE_8__.isValidDateRange),
/* harmony export */   isValidDateString: () => (/* reexport safe */ _dates__WEBPACK_IMPORTED_MODULE_8__.isValidDateString),
/* harmony export */   isValidNumericID: () => (/* reexport safe */ _is_valid_numeric_id__WEBPACK_IMPORTED_MODULE_11__.isValidNumericID),
/* harmony export */   listFormat: () => (/* reexport safe */ _i18n__WEBPACK_IMPORTED_MODULE_5__.listFormat),
/* harmony export */   markdownToHTML: () => (/* reexport safe */ _markdown__WEBPACK_IMPORTED_MODULE_6__.markdownToHTML),
/* harmony export */   normalizeURL: () => (/* reexport safe */ _urls__WEBPACK_IMPORTED_MODULE_10__.normalizeURL),
/* harmony export */   numFmt: () => (/* reexport safe */ _i18n__WEBPACK_IMPORTED_MODULE_5__.numFmt),
/* harmony export */   numberFormat: () => (/* reexport safe */ _i18n__WEBPACK_IMPORTED_MODULE_5__.numberFormat),
/* harmony export */   partitionReport: () => (/* reexport safe */ _partition_report__WEBPACK_IMPORTED_MODULE_14__.partitionReport),
/* harmony export */   prepareForReadableLargeNumber: () => (/* reexport safe */ _i18n__WEBPACK_IMPORTED_MODULE_5__.prepareForReadableLargeNumber),
/* harmony export */   readableLargeNumber: () => (/* reexport safe */ _i18n__WEBPACK_IMPORTED_MODULE_5__.readableLargeNumber),
/* harmony export */   safelySort: () => (/* reexport safe */ _safely_sort__WEBPACK_IMPORTED_MODULE_13__.safelySort),
/* harmony export */   sanitizeHTML: () => (/* reexport safe */ _sanitize__WEBPACK_IMPORTED_MODULE_2__.sanitizeHTML),
/* harmony export */   shortenURL: () => (/* reexport safe */ _urls__WEBPACK_IMPORTED_MODULE_10__.shortenURL),
/* harmony export */   storageAvailable: () => (/* reexport safe */ _storage__WEBPACK_IMPORTED_MODULE_4__.storageAvailable),
/* harmony export */   stringToDate: () => (/* reexport safe */ _dates__WEBPACK_IMPORTED_MODULE_8__.stringToDate),
/* harmony export */   stringifyObject: () => (/* reexport safe */ _stringify__WEBPACK_IMPORTED_MODULE_3__.stringifyObject),
/* harmony export */   trackEvent: () => (/* reexport safe */ _tracking__WEBPACK_IMPORTED_MODULE_1__.trackEvent),
/* harmony export */   trackEventOnce: () => (/* reexport safe */ _tracking__WEBPACK_IMPORTED_MODULE_1__.trackEventOnce),
/* harmony export */   untrailingslashit: () => (/* reexport safe */ _sanitize__WEBPACK_IMPORTED_MODULE_2__.untrailingslashit),
/* harmony export */   validateJSON: () => (/* binding */ validateJSON)
/* harmony export */ });
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! lodash */ "../node_modules/lodash/lodash.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _tracking__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./tracking */ "./js/util/tracking/index.js");
/* harmony import */ var _sanitize__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./sanitize */ "./js/util/sanitize.js");
/* harmony import */ var _stringify__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./stringify */ "./js/util/stringify.js");
/* harmony import */ var _storage__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./storage */ "./js/util/storage.js");
/* harmony import */ var _i18n__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./i18n */ "./js/util/i18n.js");
/* harmony import */ var _markdown__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./markdown */ "./js/util/markdown.js");
/* harmony import */ var _convert_time__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./convert-time */ "./js/util/convert-time.js");
/* harmony import */ var _dates__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./dates */ "./js/util/dates.js");
/* harmony import */ var _chart__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./chart */ "./js/util/chart.js");
/* harmony import */ var _urls__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./urls */ "./js/util/urls.js");
/* harmony import */ var _is_valid_numeric_id__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./is-valid-numeric-id */ "./js/util/is-valid-numeric-id.js");
/* harmony import */ var _isnumeric__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ./isnumeric */ "./js/util/isnumeric.js");
/* harmony import */ var _safely_sort__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ./safely-sort */ "./js/util/safely-sort.js");
/* harmony import */ var _partition_report__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ./partition-report */ "./js/util/partition-report.js");
/**
 * Utility functions.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * Internal dependencies
 */
















/**
 * Calculates the change between two values.
 *
 * @since 1.24.0
 *
 * @param {number} previous The previous value.
 * @param {number} current  The current value.
 * @return {(number|null)} The percent change. Null if the input or output is invalid.
 */
function calculateChange(previous, current) {
  function isZero(value) {
    return value === '0' || value === 0;
  }

  // Prevent null result when both values are legitimately zero.
  if (isZero(previous) && isZero(current)) {
    return 0;
  }

  // Prevent divide by zero errors.
  if (isZero(previous) || Number.isNaN(previous)) {
    return null;
  }

  // Avoid NaN at all costs.
  const change = (current - previous) / previous;
  if (Number.isNaN(change) || !Number.isFinite(change)) {
    return null;
  }
  return change;
}

/**
 * Verifies whether JSON is valid.
 *
 * @since 1.0.0
 *
 * @param {string} stringToValidate The string to validate.
 * @return {boolean} Indicates JSON is valid.
 */
function validateJSON(stringToValidate) {
  try {
    return JSON.parse(stringToValidate) && !!stringToValidate;
  } catch (e) {
    return false;
  }
}

/**
 * Converts HTML text into an HTML entity.
 *
 * _.unescape doesn't seem to decode some entities for admin bar titles.
 * adding combination in this helper as a workaround.
 *
 * @since 1.0.0
 *
 * @param {string} str The string to decode.
 * @return {string} Decoded HTML entity.
 */
function decodeHTMLEntity(str) {
  if (!str) {
    return '';
  }
  const decoded = str.replace(/&#(\d+);/g, (match, dec) => {
    return String.fromCharCode(dec);
  }).replace(/(\\)/g, '');
  return (0,lodash__WEBPACK_IMPORTED_MODULE_0__.unescape)(decoded);
}

/***/ }),

/***/ "./js/util/is-valid-numeric-id.js":
/*!****************************************!*\
  !*** ./js/util/is-valid-numeric-id.js ***!
  \****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   isValidNumericID: () => (/* binding */ isValidNumericID)
/* harmony export */ });
/**
 * Utility function related to checking if a given value is numeric.
 *
 * Site Kit by Google, Copyright 2022 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Checks the given value to see if it is a positive integer.
 *
 * @since 1.11.0 Function introduced.
 * @since 1.90.0 Moved outside Tag Manager to a generic utility function.
 *
 * @param {*} input Value to check.
 * @return {boolean} Validity.
 */
function isValidNumericID(input) {
  const id = parseFloat(input) || 0;
  if (!Number.isInteger(id)) {
    return false;
  }
  return id > 0;
}

/***/ }),

/***/ "./js/util/isnumeric.js":
/*!******************************!*\
  !*** ./js/util/isnumeric.js ***!
  \******************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   isNumeric: () => (/* binding */ isNumeric)
/* harmony export */ });
/**
 * Utility function related to checking if a given value is numeric.
 *
 * Site Kit by Google, Copyright 2022 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Checks if a given value is numeric.
 *
 * @since 1.80.0
 *
 * @param {*} value The value to check.
 * @return {boolean} TRUE if a value is numeric FALSE otherwise.
 */
function isNumeric(value) {
  if (typeof value === 'number') {
    return true;
  }
  const string = (value || '').toString();
  if (!string) {
    return false;
  }
  return !isNaN(string);
}

/***/ }),

/***/ "./js/util/markdown.js":
/*!*****************************!*\
  !*** ./js/util/markdown.js ***!
  \*****************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   markdownToHTML: () => (/* binding */ markdownToHTML)
/* harmony export */ });
/**
 * Markdown utility.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Replaces markdown links with its HTML equivalents.
 *
 * @since 1.22.0
 *
 * @param {string} text Markdown text.
 * @return {string} Text with HTML links.
 */
function markdownLinks(text) {
  return text.replace(new RegExp('\\[([^\\]]+)\\]\\((https?://[^/]+\\.\\w+/?.*?)\\)', 'gi'), '<a href="$2" target="_blank" rel="noopener noreferrer">$1</a>');
}

/**
 * Adds paragraphs to the text.
 *
 * @since 1.22.0
 *
 * @param {string} text Markdown text.
 * @return {string} Text with HTML links.
 */
function markdownParagraphs(text) {
  return `<p>${text.replace(/\n{2,}/g, '</p><p>')}</p>`;
}

/**
 * Replaces line breaks in the text.
 *
 * @since 1.22.0
 *
 * @param {string} text Markdown text.
 * @return {string} Text with HTML links.
 */
function markdownBreaks(text) {
  return text.replace(/\n/gi, '<br>');
}

/**
 * Converts markdown to HTML.
 *
 * @since 1.22.0
 *
 * @param {string} text Markdown text.
 * @return {string} HTML version of the markdown text.
 */
function markdownToHTML(text) {
  const rules = [markdownLinks, markdownParagraphs, markdownBreaks];
  let html = text;
  for (const rule of rules) {
    html = rule(html);
  }
  return html;
}

/***/ }),

/***/ "./js/util/partition-report.js":
/*!*************************************!*\
  !*** ./js/util/partition-report.js ***!
  \*************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   partitionReport: () => (/* binding */ partitionReport)
/* harmony export */ });
/* harmony import */ var invariant__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! invariant */ "../node_modules/invariant/browser.js");
/* harmony import */ var invariant__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(invariant__WEBPACK_IMPORTED_MODULE_0__);
/**
 * Report partitioning utility.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * Splits report data into segments for current and comparison ranges.
 *
 * @since 1.33.0
 * @since 1.34.0 Updated to support incomplete `report` arrays.
 *
 * @param {Array}  report               Report rows.
 * @param {Object} args                 Additional arguments.
 * @param {number} args.dateRangeLength Date range length of report segments.
 * @return {Object} Object with keys for `compareRange` and `currentRange`.
 */
function partitionReport(report, {
  dateRangeLength
}) {
  invariant__WEBPACK_IMPORTED_MODULE_0___default()(Array.isArray(report), 'report must be an array to partition.');
  invariant__WEBPACK_IMPORTED_MODULE_0___default()(Number.isInteger(dateRangeLength) && dateRangeLength > 0, 'dateRangeLength must be a positive integer.');

  // Use a negative date range length for reverse slicing.
  const _dateRangeLength = -1 * dateRangeLength;
  return {
    // The current range should always be sliced from the end.
    currentRange: report.slice(_dateRangeLength),
    // The compare range continues from where the current left off (slicing towards the start),
    // and may be shorter (where older data is not available yet) which is fine.
    compareRange: report.slice(_dateRangeLength * 2, _dateRangeLength)
  };
}

/***/ }),

/***/ "./js/util/purify.js":
/*!***************************!*\
  !*** ./js/util/purify.js ***!
  \***************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   purify: () => (/* binding */ purify)
/* harmony export */ });
/* harmony import */ var dompurify__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! dompurify */ "../node_modules/dompurify/dist/purify.js");
/* harmony import */ var dompurify__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(dompurify__WEBPACK_IMPORTED_MODULE_0__);
/**
 * External dependencies
 */

const purify = dompurify__WEBPACK_IMPORTED_MODULE_0___default()(__webpack_require__.g);

/***/ }),

/***/ "./js/util/safely-sort.js":
/*!********************************!*\
  !*** ./js/util/safely-sort.js ***!
  \********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   safelySort: () => (/* binding */ safelySort)
/* harmony export */ });
/**
 * `safelySort` utility function.
 *
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Sorts an array without causing the mutation if the given parameter is an array.
 * If the parameter is not an array, it returns the parameter as is.
 *
 * @since 1.110.0
 * @since 1.128.0 Moved to the common utility directory from the key metrics directory.
 *
 * @param {Array|*} arr Param to be sorted.
 * @return {Array|*} 	Safely sorted array without mutation.
 */
function safelySort(arr) {
  return Array.isArray(arr) ? [...arr].sort() : arr;
}

/***/ }),

/***/ "./js/util/sanitize.js":
/*!*****************************!*\
  !*** ./js/util/sanitize.js ***!
  \*****************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   sanitizeHTML: () => (/* binding */ sanitizeHTML),
/* harmony export */   untrailingslashit: () => (/* binding */ untrailingslashit)
/* harmony export */ });
/* harmony import */ var _purify__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./purify */ "./js/util/purify.js");
/**
 * Internal dependencies
 */

function sanitizeHTML(unsafeHTML, domPurifyConfig = {}) {
  return {
    __html: _purify__WEBPACK_IMPORTED_MODULE_0__.purify.sanitize(unsafeHTML, domPurifyConfig)
  };
}

/**
 * Takes a string or an URL object, removes the trailing slash if any and returns it.
 *
 * @since 1.20.0
 * @private
 *
 * @param {Object|string} url A string with or without trailing slash or an URL object.
 * @return {string|undefined} The URL string after removing the trailing slash.
 */
function untrailingslashit(url) {
  const originalURL = typeof url === 'object' ? url.toString() : url;
  return originalURL?.replace?.(/\/+$/, '');
}

/***/ }),

/***/ "./js/util/storage.js":
/*!****************************!*\
  !*** ./js/util/storage.js ***!
  \****************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   getStorage: () => (/* binding */ getStorage),
/* harmony export */   storageAvailable: () => (/* binding */ storageAvailable)
/* harmony export */ });
/**
 * Storage abstraction.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Detects whether browser storage is both supported and available.
 *
 * @since 1.0.0
 *
 * @param {string} type Browser storage to test. ex localStorage or sessionStorage.
 * @return {boolean} True if the given storage is available, false otherwise.
 */
function storageAvailable(type) {
  const storage = __webpack_require__.g[type];
  if (!storage) {
    return false;
  }
  try {
    const x = '__storage_test__';
    storage.setItem(x, x);
    storage.removeItem(x);
    return true;
  } catch (e) {
    return e instanceof DOMException && (
    // everything except Firefox
    22 === e.code ||
    // Firefox
    1014 === e.code ||
    // test name field too, because code might not be present
    // everything except Firefox
    'QuotaExceededError' === e.name ||
    // Firefox
    'NS_ERROR_DOM_QUOTA_REACHED' === e.name) &&
    // acknowledge QuotaExceededError only if there's something already stored
    0 !== storage.length;
  }
}

// Custom no-op implementation of window.Storage.
class NullStorage {
  get length() {
    return 0;
  }
  key() {
    return null;
  }
  getItem() {
    return null;
  }
  setItem() {
    // Empty method body.
  }
  removeItem() {
    // Empty method body.
  }
  clear() {
    // Empty method body.
  }
}
let storageObj;

/**
 * Gets the storage object to use.
 *
 * @since 1.0.0
 *
 * @return {Storage} Either window.sessionStorage, window.localStorage', or a
 *                   no-op implementation if neither is available.
 */
function getStorage() {
  // Only run the logic to determine the storage object once.
  if (!storageObj) {
    if (storageAvailable('sessionStorage')) {
      storageObj = __webpack_require__.g.sessionStorage;
    } else if (storageAvailable('localStorage')) {
      storageObj = __webpack_require__.g.localStorage;
    } else {
      storageObj = new NullStorage();
    }
  }
  return storageObj;
}

/***/ }),

/***/ "./js/util/stringify.js":
/*!******************************!*\
  !*** ./js/util/stringify.js ***!
  \******************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   stringifyObject: () => (/* binding */ stringifyObject)
/* harmony export */ });
/* harmony import */ var md5__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! md5 */ "../node_modules/md5/md5.js");
/* harmony import */ var md5__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(md5__WEBPACK_IMPORTED_MODULE_0__);
/**
 * Stringify function.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * Transforms an object into a hash string.
 *
 * This function can be used to e.g. generate cache keys, based on the given
 * object. Object properties are sorted, so even if they are provided in
 * different order, the hash will match. The function furthermore supports
 * nested objects.
 *
 * @since 1.7.0
 *
 * @param {Object} obj The object to stringify.
 * @return {string} Hash for the object.
 */
function stringifyObject(obj) {
  return md5__WEBPACK_IMPORTED_MODULE_0___default()(JSON.stringify(sortObjectProperties(obj)));
}
function sortObjectProperties(obj) {
  const orderedData = {};
  Object.keys(obj).sort().forEach(key => {
    let val = obj[key];
    if (val && 'object' === typeof val && !Array.isArray(val)) {
      val = sortObjectProperties(val);
    }
    orderedData[key] = val;
  });
  return orderedData;
}

/***/ }),

/***/ "./js/util/tracking/constants.js":
/*!***************************************!*\
  !*** ./js/util/tracking/constants.js ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   DATA_LAYER: () => (/* binding */ DATA_LAYER),
/* harmony export */   SCRIPT_IDENTIFIER: () => (/* binding */ SCRIPT_IDENTIFIER)
/* harmony export */ });
/**
 * Constants related to event tracking.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Data layer global used for internal/private Site Kit data.
 *
 * @since 1.8.0
 * @private
 */
const DATA_LAYER = '_googlesitekitDataLayer';

/**
 * The `gtag` `<script>` identifier.
 *
 * @since 1.8.0
 * @private
 */
const SCRIPT_IDENTIFIER = 'data-googlesitekit-gtag';

/***/ }),

/***/ "./js/util/tracking/createDataLayerPush.js":
/*!*************************************************!*\
  !*** ./js/util/tracking/createDataLayerPush.js ***!
  \*************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ createDataLayerPush)
/* harmony export */ });
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./constants */ "./js/util/tracking/constants.js");
/**
 * Internal dependencies
 */


/**
 * Returns a function which, when invoked will initialize the dataLayer and push data onto it.
 *
 * @since 1.3.0
 *
 * @param {Object} target Object to enhance with dataLayer data.
 * @return {Function} Function that pushes data onto the dataLayer.
 */
function createDataLayerPush(target) {
  /**
   * Pushes data onto the data layer.
   *
   * Must push an instance of Arguments to the target.
   * Using an ES6 spread operator (i.e. `...args`) will cause tracking events to
   * _silently_ fail.
   *
   * @since 1.0.0
   * @see {@link https://github.com/google/site-kit-wp/issues/1181}
   */
  return function dataLayerPush() {
    target[_constants__WEBPACK_IMPORTED_MODULE_0__.DATA_LAYER] = target[_constants__WEBPACK_IMPORTED_MODULE_0__.DATA_LAYER] || [];
    target[_constants__WEBPACK_IMPORTED_MODULE_0__.DATA_LAYER].push(arguments);
  };
}

/***/ }),

/***/ "./js/util/tracking/createInitializeSnippet.js":
/*!*****************************************************!*\
  !*** ./js/util/tracking/createInitializeSnippet.js ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ createInitializeSnippet)
/* harmony export */ });
/* harmony import */ var _createDataLayerPush__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./createDataLayerPush */ "./js/util/tracking/createDataLayerPush.js");
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./constants */ "./js/util/tracking/constants.js");
/* harmony import */ var _js_features_index__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/features/index */ "./js/features/index.js");
/**
 * Internal dependencies
 */




/**
 * Returns a function which, when invoked injects the gtag script if necessary.
 *
 * @since 1.44.0
 *
 * @param {Object} config          Tracking configuration.
 * @param {Object} dataLayerTarget Data layer parent object.
 * @return {Function} Function that injects gtag script if it isn't yet present.
 */
function createInitializeSnippet(config, dataLayerTarget) {
  const dataLayerPush = (0,_createDataLayerPush__WEBPACK_IMPORTED_MODULE_0__["default"])(dataLayerTarget);
  let hasInsertedTag;
  const {
    activeModules,
    referenceSiteURL,
    userIDHash,
    userRoles = [],
    isAuthenticated,
    pluginVersion
  } = config;

  /**
   * Injects the necessary script tag if not present.
   *
   * @since 1.118.0
   *
   * @return {boolean|Object} Tag src as scriptTagSrc property.
   */
  return function initializeSnippet() {
    const {
      document
    } = __webpack_require__.g;
    if (undefined === hasInsertedTag) {
      hasInsertedTag = !!document.querySelector(`script[${_constants__WEBPACK_IMPORTED_MODULE_1__.SCRIPT_IDENTIFIER}]`);
    }
    if (hasInsertedTag) {
      return false;
    }
    hasInsertedTag = true;

    // Sometimes the user roles returned by Site Kit/WordPress is not an
    // array, as expected, so we guard against it here.
    //
    // See: https://github.com/google/site-kit-wp/issues/8266
    const userRolesAsString = userRoles?.length ? userRoles.join(',') : '';

    // We should use the real time, and not the reference date, when
    // measuring when we initialized tracking.
    dataLayerPush('js', new Date()); // eslint-disable-line sitekit/no-direct-date
    dataLayerPush('config', config.trackingID, {
      groups: 'site_kit',
      send_page_view: config.isSiteKitScreen,
      domain: referenceSiteURL,
      plugin_version: pluginVersion || '',
      enabled_features: Array.from(_js_features_index__WEBPACK_IMPORTED_MODULE_2__.enabledFeatures).join(','),
      active_modules: activeModules.join(','),
      authenticated: isAuthenticated ? '1' : '0',
      user_properties: {
        user_roles: userRolesAsString,
        user_identifier: userIDHash
      }
    });

    // If not present, inject it and initialize dataLayer.
    const scriptTag = document.createElement('script');
    scriptTag.setAttribute(_constants__WEBPACK_IMPORTED_MODULE_1__.SCRIPT_IDENTIFIER, '');
    scriptTag.async = true;
    scriptTag.src = `https://www.googletagmanager.com/gtag/js?id=${config.trackingID}&l=${_constants__WEBPACK_IMPORTED_MODULE_1__.DATA_LAYER}`;
    document.head.appendChild(scriptTag);
    return {
      scriptTagSrc: `https://www.googletagmanager.com/gtag/js?id=${config.trackingID}&l=${_constants__WEBPACK_IMPORTED_MODULE_1__.DATA_LAYER}`
    };
  };
}

/***/ }),

/***/ "./js/util/tracking/createTrackEvent.js":
/*!**********************************************!*\
  !*** ./js/util/tracking/createTrackEvent.js ***!
  \**********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ createTrackEvent)
/* harmony export */ });
/* harmony import */ var _createDataLayerPush__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./createDataLayerPush */ "./js/util/tracking/createDataLayerPush.js");
/**
 * Internal dependencies
 */


/**
 * Returns a function which, when invoked tracks a single event.
 *
 * @since 1.3.0
 *
 * @param {Object}   config            Tracking configuration.
 * @param {Object}   dataLayerTarget   Data layer parent object.
 * @param {Function} initializeSnippet Function to initialize tracking.
 * @param {Object}   _global           The global window object.
 * @return {Function} Function that tracks an event.
 */
function createTrackEvent(config, dataLayerTarget, initializeSnippet, _global) {
  const dataLayerPush = (0,_createDataLayerPush__WEBPACK_IMPORTED_MODULE_0__["default"])(dataLayerTarget);

  /**
   * Send an Analytics tracking event.
   *
   * @since 1.3.0
   *
   * @param {string} category The category of the event.
   * @param {string} action   The action name of the event.
   * @param {string} [label]  Optional. The label of the event.
   * @param {number} [value]  Optional. A non-negative integer that will appear as the event value.
   * @return {Promise} Promise that always resolves.
   */
  // eslint-disable-next-line require-await
  return async function trackEvent(category, action, label, value) {
    const {
      trackingEnabled
    } = config;
    if (!trackingEnabled) {
      // Resolve immediately if tracking is disabled.
      return null;
    }
    initializeSnippet();
    const eventData = {
      send_to: 'site_kit',
      event_category: category,
      event_label: label,
      value
    };
    return new Promise(resolve => {
      // This timeout ensures a tracking event does not block the user
      // event if it is not sent (in time).
      // If the event beacon fails, it shouldn't reject the promise since event
      // tracking should not result in user-facing errors. It will just
      // trigger a console warning.
      function failCallback() {
        _global.console.warn(`Tracking event "${action}" (category "${category}") took too long to fire.`);
        resolve();
      }
      const failTimeout = setTimeout(failCallback, 1000);
      // eslint-disable-next-line camelcase
      function event_callback() {
        clearTimeout(failTimeout);
        resolve();
      }
      dataLayerPush('event', action, {
        ...eventData,
        event_callback
      });

      // If the client-side opt-out is present, the event_callback will never be called
      // so we call it here to prevent the warning and added delay.
      if (_global._gaUserPrefs?.ioo?.()) {
        event_callback();
      }
    });
  };
}

/***/ }),

/***/ "./js/util/tracking/createTracking.js":
/*!********************************************!*\
  !*** ./js/util/tracking/createTracking.js ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ createTracking)
/* harmony export */ });
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! lodash */ "../node_modules/lodash/lodash.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _createInitializeSnippet__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./createInitializeSnippet */ "./js/util/tracking/createInitializeSnippet.js");
/* harmony import */ var _createTrackEvent__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./createTrackEvent */ "./js/util/tracking/createTrackEvent.js");
/**
 * Site Kit by Google, Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * Internal dependencies
 */


const DEFAULT_CONFIG = {
  activeModules: [],
  isAuthenticated: false,
  referenceSiteURL: '',
  trackingEnabled: false,
  trackingID: '',
  userIDHash: '',
  userRoles: []
};

/**
 * Initializes tracking.
 *
 * @since 1.3.0
 *
 * @param {Object} newConfig       New configuration.
 * @param {Object} dataLayerTarget Data layer parent object.
 * @param {Object} _global         The global window object.
 * @return {Object} Tracking config.
 */
function createTracking(newConfig, dataLayerTarget = __webpack_require__.g, _global = __webpack_require__.g) {
  const config = {
    ...DEFAULT_CONFIG,
    ...newConfig
  };
  // Remove any trailing slash from the reference URL.
  if (config.referenceSiteURL) {
    config.referenceSiteURL = config.referenceSiteURL.toString().replace(/\/+$/, '');
  }
  const initializeSnippet = (0,_createInitializeSnippet__WEBPACK_IMPORTED_MODULE_1__["default"])(config, dataLayerTarget);
  const trackEvent = (0,_createTrackEvent__WEBPACK_IMPORTED_MODULE_2__["default"])(config, dataLayerTarget, initializeSnippet, _global);
  const onceTrackedEventsMap = {};
  function trackEventOnce(...params) {
    const key = JSON.stringify(params);
    if (!onceTrackedEventsMap[key]) {
      onceTrackedEventsMap[key] = (0,lodash__WEBPACK_IMPORTED_MODULE_0__.once)(trackEvent);
    }
    onceTrackedEventsMap[key](...params);
  }
  return {
    enableTracking: function enableTracking() {
      config.trackingEnabled = true;
    },
    disableTracking: function disableTracking() {
      config.trackingEnabled = false;
    },
    initializeSnippet,
    isTrackingEnabled: function isTrackingEnabled() {
      return !!config.trackingEnabled;
    },
    trackEvent,
    trackEventOnce
  };
}

/***/ }),

/***/ "./js/util/tracking/index.js":
/*!***********************************!*\
  !*** ./js/util/tracking/index.js ***!
  \***********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   disableTracking: () => (/* binding */ disableTracking),
/* harmony export */   enableTracking: () => (/* binding */ enableTracking),
/* harmony export */   isTrackingEnabled: () => (/* binding */ isTrackingEnabled),
/* harmony export */   toggleTracking: () => (/* binding */ toggleTracking),
/* harmony export */   trackEvent: () => (/* binding */ trackEvent),
/* harmony export */   trackEventOnce: () => (/* binding */ trackEventOnce)
/* harmony export */ });
/* harmony import */ var _createTracking__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./createTracking */ "./js/util/tracking/createTracking.js");
/**
 * Event tracking utilities.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/* eslint-disable sitekit/jsdoc-no-unnamed-boolean-params */

/**
 * Internal dependencies
 */

const {
  activeModules = [],
  isSiteKitScreen,
  trackingEnabled,
  trackingID,
  referenceSiteURL,
  userIDHash,
  isAuthenticated,
  userRoles
} = __webpack_require__.g._googlesitekitTrackingData || {};
const {
  GOOGLESITEKIT_VERSION: pluginVersion
} = __webpack_require__.g;
const initialConfig = {
  activeModules,
  trackingEnabled,
  trackingID,
  referenceSiteURL,
  userIDHash,
  isSiteKitScreen,
  userRoles,
  isAuthenticated,
  pluginVersion
};
const {
  enableTracking,
  disableTracking,
  isTrackingEnabled,
  initializeSnippet,
  trackEvent,
  trackEventOnce
} = (0,_createTracking__WEBPACK_IMPORTED_MODULE_0__["default"])(initialConfig);

/**
 * Changes the active state of tracking.
 *
 * @since 1.3.0
 *
 * @param {boolean} activeStatus The new state to set.
 */
function toggleTracking(activeStatus) {
  if (!!activeStatus) {
    enableTracking();
  } else {
    disableTracking();
  }
}

// Bootstrap on import if tracking is allowed.
if (isSiteKitScreen && trackingEnabled) {
  initializeSnippet();
}


/***/ }),

/***/ "./js/util/urls.js":
/*!*************************!*\
  !*** ./js/util/urls.js ***!
  \*************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   getFullURL: () => (/* binding */ getFullURL),
/* harmony export */   getURLPath: () => (/* binding */ getURLPath),
/* harmony export */   isHashOnly: () => (/* binding */ isHashOnly),
/* harmony export */   normalizeURL: () => (/* binding */ normalizeURL),
/* harmony export */   shortenURL: () => (/* binding */ shortenURL)
/* harmony export */ });
/* harmony import */ var _wordpress_url__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/url */ "../node_modules/@wordpress/url/build-module/is-url.js");
/**
 * URL pathname getter utility function.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */


/**
 * Returns the path from a URL, omitting its protocol, hostname, query params, and hash.
 *
 * @since 1.24.0
 *
 * @param {string} url The URL to get the path from.
 * @return {string} The URL path.
 */
function getURLPath(url) {
  try {
    return new URL(url).pathname;
  } catch {}
  return null;
}

/**
 * Returns the absolute URL from a path including the siteURL.
 *
 * @since 1.32.0
 *
 * @param {string} siteURL The siteURL fo the WordPress install.
 * @param {string} path    The path.
 * @return {string} The URL path.
 */
function getFullURL(siteURL, path) {
  try {
    return new URL(path, siteURL).href;
  } catch {}
  return (typeof siteURL === 'string' ? siteURL : '') + (typeof path === 'string' ? path : '');
}

/**
 * Normalizes URL by removing protocol, www subdomain and trailing slash.
 *
 * @since 1.33.0
 *
 * @param {string} incomingURL The original URL.
 * @return {string} Normalized URL.
 */
function normalizeURL(incomingURL) {
  if (typeof incomingURL !== 'string') {
    return incomingURL;
  }
  return incomingURL
  // Remove protocol and optional "www." prefix from the URL.
  .replace(/^https?:\/\/(www\.)?/i, '')
  // Remove trailing slash.
  .replace(/\/$/, '');
}

/**
 * Checks if a string is not a full URL and simply a hash / anchor link.
 *
 * @since 1.49.0
 *
 * @param {string} url The URL or Hash string to test.
 * @return {boolean} Returns true if the string is only a hash and not a full URL.
 */
function isHashOnly(url) {
  return /^#\w[A-Za-z0-9-_]*$/.test(url);
}

/**
 * Shortens a URL to fit a given length.
 *
 * @since 1.49.0
 *
 * @param {string} url      The original URL to shorten.
 * @param {number} maxChars The maximum length of the URL.
 * @return {string} The shortened URL.
 */
function shortenURL(url, maxChars) {
  if (!(0,_wordpress_url__WEBPACK_IMPORTED_MODULE_0__.isURL)(url)) {
    return url;
  }
  if (url.length <= maxChars) {
    return url;
  }
  const urlObject = new URL(url);
  const shortenedURL = url.replace(urlObject.origin, '');
  if (shortenedURL.length < maxChars) {
    return shortenedURL;
  }
  const extraChars = shortenedURL.length - Math.floor(maxChars) + 1; // 1 is the length of "…".
  return '…' + shortenedURL.substr(extraChars);
}

/***/ }),

/***/ "./svg/icons/arrow-inverse.svg":
/*!*************************************!*\
  !*** ./svg/icons/arrow-inverse.svg ***!
  \*************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "../node_modules/react/index.js");
var _g;
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }

const SvgArrowInverse = props => /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("svg", _extends({
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 13 13"
}, props), _g || (_g = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("g", {
  fill: "none",
  fillRule: "evenodd"
}, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("circle", {
  cx: 6.5,
  cy: 6.5,
  r: 6.5,
  fill: "#FFF"
}), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("path", {
  fill: "currentColor",
  d: "M3.461 6.96h5.15L6.36 9.21a.464.464 0 0 0 .325.79.46.46 0 0 0 .325-.135l3.037-3.038a.46.46 0 0 0 0-.65L7.015 3.135a.46.46 0 0 0-.65.65L8.61 6.039H3.461a.46.46 0 0 0-.461.46c0 .254.207.462.461.462z"
}), ".")));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (SvgArrowInverse);

/***/ }),

/***/ "./svg/icons/arrow.svg":
/*!*****************************!*\
  !*** ./svg/icons/arrow.svg ***!
  \*****************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "../node_modules/react/index.js");
var _g;
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }

const SvgArrow = props => /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("svg", _extends({
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 13 13"
}, props), _g || (_g = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("g", {
  fill: "none",
  fillRule: "evenodd"
}, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("circle", {
  cx: 6.5,
  cy: 6.5,
  r: 6.5,
  fill: "currentColor"
}), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("path", {
  fill: "#FFF",
  d: "M3.461 6.96h5.15L6.36 9.21a.464.464 0 0 0 .325.79.46.46 0 0 0 .325-.135l3.037-3.038a.46.46 0 0 0 0-.65L7.015 3.135a.46.46 0 0 0-.65.65L8.61 6.039H3.461a.46.46 0 0 0-.461.46c0 .254.207.462.461.462z"
}), ".")));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (SvgArrow);

/***/ }),

/***/ "./svg/icons/back.svg":
/*!****************************!*\
  !*** ./svg/icons/back.svg ***!
  \****************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "../node_modules/react/index.js");
var _path;
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }

const SvgBack = props => /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("svg", _extends({
  xmlns: "http://www.w3.org/2000/svg",
  fill: "currentColor",
  viewBox: "0 0 24 24"
}, props), _path || (_path = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("path", {
  d: "m12 20-8-8 8-8 1.425 1.4-5.6 5.6H20v2H7.825l5.6 5.6z"
})));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (SvgBack);

/***/ }),

/***/ "./svg/icons/check-fill.svg":
/*!**********************************!*\
  !*** ./svg/icons/check-fill.svg ***!
  \**********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "../node_modules/react/index.js");
var _path;
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }

const SvgCheckFill = props => /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("svg", _extends({
  xmlns: "http://www.w3.org/2000/svg",
  fill: "none",
  viewBox: "0 0 24 24"
}, props), _path || (_path = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("path", {
  fill: "currentColor",
  fillRule: "evenodd",
  d: "M12 1C5.925 1 1 5.925 1 12s4.925 11 11 11 11-4.925 11-11S18.075 1 12 1m4.806 8.592.592-.806-1.612-1.184-.592.806-3.89 5.296c-.166.226-.36.296-.512.296s-.346-.07-.512-.296l-1.474-2.007-.592-.806-1.612 1.184.592.806 1.474 2.007C9.191 15.6 9.971 16 10.792 16s1.6-.4 2.124-1.112z",
  clipRule: "evenodd"
})));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (SvgCheckFill);

/***/ }),

/***/ "./svg/icons/external-rounded.svg":
/*!****************************************!*\
  !*** ./svg/icons/external-rounded.svg ***!
  \****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "../node_modules/react/index.js");
var _path;
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }

const SvgExternalRounded = props => /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("svg", _extends({
  xmlns: "http://www.w3.org/2000/svg",
  fill: "none",
  viewBox: "0 0 13 14"
}, props), _path || (_path = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("path", {
  stroke: "currentColor",
  strokeWidth: 1.5,
  d: "M4.5 1.5H3a2 2 0 0 0-2 2v7a2 2 0 0 0 2 2h7a2 2 0 0 0 2-2V9M7 1.5h5v5M5 8.5 11.5 2"
})));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (SvgExternalRounded);

/***/ }),

/***/ "./svg/icons/external.svg":
/*!********************************!*\
  !*** ./svg/icons/external.svg ***!
  \********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "../node_modules/react/index.js");
var _path;
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }

const SvgExternal = props => /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("svg", _extends({
  xmlns: "http://www.w3.org/2000/svg",
  fill: "currentColor",
  viewBox: "0 0 24 24"
}, props), _path || (_path = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("path", {
  d: "M5 21a2 2 0 0 1-1.425-.575A2 2 0 0 1 3 19V5q0-.825.575-1.4Q4.175 3 5 3h7v2H5v14h14v-7h2v7q0 .825-.6 1.425Q19.825 21 19 21zm4.7-5.3-1.4-1.4L17.6 5H14V3h7v7h-2V6.4z"
})));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (SvgExternal);

/***/ }),

/***/ "./svg/icons/star-fill.svg":
/*!*********************************!*\
  !*** ./svg/icons/star-fill.svg ***!
  \*********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "../node_modules/react/index.js");
var _path;
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }

const SvgStarFill = props => /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("svg", _extends({
  xmlns: "http://www.w3.org/2000/svg",
  fill: "none",
  viewBox: "0 0 24 24"
}, props), _path || (_path = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("path", {
  fill: "currentColor",
  d: "m5.825 22 2.325-7.6L2 10h7.6L12 2l2.4 8H22l-6.15 4.4 2.325 7.6L12 17.3z"
})));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (SvgStarFill);

/***/ }),

/***/ "./svg/icons/warning-notice.svg":
/*!**************************************!*\
  !*** ./svg/icons/warning-notice.svg ***!
  \**************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "../node_modules/react/index.js");
var _path;
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }

const SvgWarningNotice = props => /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("svg", _extends({
  xmlns: "http://www.w3.org/2000/svg",
  fill: "none",
  viewBox: "0 0 24 24"
}, props), _path || (_path = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("path", {
  fill: "currentColor",
  d: "M12 1c6.075 0 11 4.925 11 11s-4.925 11-11 11S1 18.075 1 12 5.925 1 12 1m0 14a1.5 1.5 0 1 0 0 3 1.5 1.5 0 0 0 0-3m-1-2h2V6h-2z"
})));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (SvgWarningNotice);

/***/ }),

/***/ "@wordpress/i18n":
/*!*****************************************!*\
  !*** external ["googlesitekit","i18n"] ***!
  \*****************************************/
/***/ ((module) => {

module.exports = googlesitekit.i18n;

/***/ }),

/***/ "googlesitekit-api":
/*!****************************************!*\
  !*** external ["googlesitekit","api"] ***!
  \****************************************/
/***/ ((module) => {

module.exports = googlesitekit.api;

/***/ }),

/***/ "googlesitekit-components":
/*!***********************************************!*\
  !*** external ["googlesitekit","components"] ***!
  \***********************************************/
/***/ ((module) => {

module.exports = googlesitekit.components;

/***/ }),

/***/ "googlesitekit-data":
/*!*****************************************!*\
  !*** external ["googlesitekit","data"] ***!
  \*****************************************/
/***/ ((module) => {

module.exports = googlesitekit.data;

/***/ })

},
/******/ __webpack_require__ => { // webpackRuntimeModules
/******/ var __webpack_exec__ = (moduleId) => (__webpack_require__(__webpack_require__.s = moduleId))
/******/ __webpack_require__.O(0, ["googlesitekit-vendor"], () => (__webpack_exec__("./js/googlesitekit-modules.js")));
/******/ var __webpack_exports__ = __webpack_require__.O();
/******/ }
]);
//# sourceMappingURL=googlesitekit-modules.js.map