"use strict";
(globalThis["__googlesitekit_webpackJsonp"] = globalThis["__googlesitekit_webpackJsonp"] || []).push([["googlesitekit-settings"],{

/***/ "./js/components/AdminMenuTooltip/AdminMenuTooltip.js":
/*!************************************************************!*\
  !*** ./js/components/AdminMenuTooltip/AdminMenuTooltip.js ***!
  \************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   AdminMenuTooltip: () => (/* binding */ AdminMenuTooltip)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _js_components_JoyrideTooltip__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/components/JoyrideTooltip */ "./js/components/JoyrideTooltip.js");
/* harmony import */ var _js_googlesitekit_datastore_ui_constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/googlesitekit/datastore/ui/constants */ "./js/googlesitekit/datastore/ui/constants.js");
/* harmony import */ var _js_util__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/util */ "./js/util/index.js");
/* harmony import */ var _js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/hooks/useViewContext */ "./js/hooks/useViewContext.js");
/* harmony import */ var _js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/hooks/useBreakpoint */ "./js/hooks/useBreakpoint.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * AdminMenuTooltip component.
 *
 * Site Kit by Google, Copyright 2022 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */







function AdminMenuTooltip() {
  const viewContext = (0,_js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_4__["default"])();
  const {
    setValue
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useDispatch)(_js_googlesitekit_datastore_ui_constants__WEBPACK_IMPORTED_MODULE_2__.CORE_UI);
  const breakpoint = (0,_js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_5__.useBreakpoint)();
  const {
    isTooltipVisible = false,
    tooltipSlug,
    title,
    content,
    dismissLabel
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useSelect)(select => select(_js_googlesitekit_datastore_ui_constants__WEBPACK_IMPORTED_MODULE_2__.CORE_UI).getValue('admin-menu-tooltip') || {
    isTooltipVisible: false
  });
  function handleViewTooltip() {
    (0,_js_util__WEBPACK_IMPORTED_MODULE_3__.trackEvent)(`${viewContext}_${tooltipSlug}`, 'tooltip_view');
  }
  const handleDismissTooltip = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_7__.useCallback)(() => {
    // Track dismiss event.
    if (tooltipSlug) {
      (0,_js_util__WEBPACK_IMPORTED_MODULE_3__.trackEvent)(`${viewContext}_${tooltipSlug}`, 'tooltip_dismiss');
    }
    setValue('admin-menu-tooltip', undefined);
  }, [setValue, tooltipSlug, viewContext]);
  if (!isTooltipVisible) {
    return null;
  }
  const defaultTarget = '#adminmenu [href*="page=googlesitekit-settings"]';
  const isMobileTablet = breakpoint === _js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_5__.BREAKPOINT_SMALL || breakpoint === _js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_5__.BREAKPOINT_TABLET;
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(_js_components_JoyrideTooltip__WEBPACK_IMPORTED_MODULE_1__["default"], {
    target: isMobileTablet ? 'body' : defaultTarget,
    placement: isMobileTablet ? 'center' : 'right',
    className: isMobileTablet ? 'googlesitekit-tour-tooltip__modal_step' : 'googlesitekit-tour-tooltip__fixed-settings-tooltip',
    disableOverlay: !isMobileTablet,
    slug: "ga4-activation-banner-admin-menu-tooltip",
    title: title,
    content: content,
    dismissLabel: dismissLabel,
    onView: handleViewTooltip,
    onDismiss: handleDismissTooltip
  });
}

/***/ }),

/***/ "./js/components/AdminMenuTooltip/index.js":
/*!*************************************************!*\
  !*** ./js/components/AdminMenuTooltip/index.js ***!
  \*************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   AdminMenuTooltip: () => (/* reexport safe */ _AdminMenuTooltip__WEBPACK_IMPORTED_MODULE_1__.AdminMenuTooltip),
/* harmony export */   useShowTooltip: () => (/* reexport safe */ _useShowTooltip__WEBPACK_IMPORTED_MODULE_0__.useShowTooltip)
/* harmony export */ });
/* harmony import */ var _useShowTooltip__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./useShowTooltip */ "./js/components/AdminMenuTooltip/useShowTooltip.js");
/* harmony import */ var _AdminMenuTooltip__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./AdminMenuTooltip */ "./js/components/AdminMenuTooltip/AdminMenuTooltip.js");



/***/ }),

/***/ "./js/components/AdminMenuTooltip/useShowTooltip.js":
/*!**********************************************************!*\
  !*** ./js/components/AdminMenuTooltip/useShowTooltip.js ***!
  \**********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   useShowTooltip: () => (/* binding */ useShowTooltip)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _js_googlesitekit_datastore_ui_constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/googlesitekit/datastore/ui/constants */ "./js/googlesitekit/datastore/ui/constants.js");



function useShowTooltip(tooltipSettings) {
  const {
    setValue
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useDispatch)(_js_googlesitekit_datastore_ui_constants__WEBPACK_IMPORTED_MODULE_1__.CORE_UI);
  return (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useCallback)(() => {
    setValue('admin-menu-tooltip', {
      isTooltipVisible: true,
      ...tooltipSettings
    });
  }, [setValue, tooltipSettings]);
}

/***/ }),

/***/ "./js/components/Badge.js":
/*!********************************!*\
  !*** ./js/components/Badge.js ***!
  \********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Badge component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * WordPress dependencies
 */


const Badge = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.forwardRef)(({
  label,
  className,
  hasLeftSpacing = false,
  ...rest
}, ref) => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("span", {
  ref: ref,
  ...rest,
  className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-badge', className, {
    'googlesitekit-badge--has-left-spacing': hasLeftSpacing
  }),
  children: label
}));
Badge.displayName = 'Badge';
Badge.propTypes = {
  label: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string).isRequired,
  hasLeftSpacing: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().bool)
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Badge);

/***/ }),

/***/ "./js/components/BadgeWithTooltip.js":
/*!*******************************************!*\
  !*** ./js/components/BadgeWithTooltip.js ***!
  \*******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ BadgeWithTooltip)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _InfoTooltip__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./InfoTooltip */ "./js/components/InfoTooltip.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * BadgeWithTooltip component.
 *
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * Internal dependencies
 */


function BadgeWithTooltip({
  className = '',
  label,
  onTooltipOpen,
  tooltipTitle
}) {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)("span", {
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-badge-with-tooltip', 'googlesitekit-badge', className),
    children: [label, tooltipTitle && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)(_InfoTooltip__WEBPACK_IMPORTED_MODULE_1__["default"], {
      onOpen: onTooltipOpen,
      title: tooltipTitle
    })]
  });
}
BadgeWithTooltip.propTypes = {
  onTooltipOpen: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().func),
  tooltipTitle: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().node),
  className: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  label: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().node).isRequired
};

/***/ }),

/***/ "./js/components/Banner/CTAButton.js":
/*!*******************************************!*\
  !*** ./js/components/Banner/CTAButton.js ***!
  \*******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ CTAButton)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! googlesitekit-components */ "googlesitekit-components");
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_components__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * Internal dependencies
 */


function CTAButton({
  label,
  ariaLabel,
  disabled,
  inProgress,
  onClick,
  href
}) {
  if (!label || !onClick && !href) {
    return null;
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_0__.SpinnerButton, {
    className: "googlesitekit-banner__cta",
    "aria-label": ariaLabel,
    disabled: disabled || inProgress,
    isSaving: inProgress,
    onClick: onClick,
    href: href,
    children: label
  });
}
CTAButton.propTypes = {
  label: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().string),
  ariaLabel: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().string),
  disabled: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().bool),
  inProgress: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().bool),
  onClick: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().func),
  href: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().string),
  dismissOnClick: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().bool),
  dismissOptions: prop_types__WEBPACK_IMPORTED_MODULE_2___default().shape({
    expiresInSeconds: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().number),
    skipHidingFromQueue: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().bool)
  })
};

/***/ }),

/***/ "./js/components/Banner/Description.js":
/*!*********************************************!*\
  !*** ./js/components/Banner/Description.js ***!
  \*********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Description)
/* harmony export */ });
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _js_util__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/util */ "./js/util/index.js");
/* harmony import */ var _LearnMoreLink__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./LearnMoreLink */ "./js/components/Banner/LearnMoreLink.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */



function Description({
  className,
  description,
  learnMoreLink,
  additionalDescription,
  children
}) {
  function renderDescription() {
    if ((0,_wordpress_element__WEBPACK_IMPORTED_MODULE_4__.isValidElement)(description)) {
      return description;
    }
    if ('string' === typeof description) {
      return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("span", {
        dangerouslySetInnerHTML: (0,_js_util__WEBPACK_IMPORTED_MODULE_1__.sanitizeHTML)(description, {
          ALLOWED_TAGS: ['strong', 'em', 'br', 'a'],
          ALLOWED_ATTR: ['href']
        })
      });
    }
    return description;
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-banner__description', className),
    children: [renderDescription(), ' ', learnMoreLink?.href && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_LearnMoreLink__WEBPACK_IMPORTED_MODULE_2__["default"], {
      ...learnMoreLink
    }), additionalDescription && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
      className: "googlesitekit-banner__additional-description",
      children: additionalDescription
    }), children]
  });
}
Description.propTypes = {
  className: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().string),
  description: prop_types__WEBPACK_IMPORTED_MODULE_5___default().oneOfType([(prop_types__WEBPACK_IMPORTED_MODULE_5___default().string), (prop_types__WEBPACK_IMPORTED_MODULE_5___default().node)]),
  learnMoreLink: prop_types__WEBPACK_IMPORTED_MODULE_5___default().shape(_LearnMoreLink__WEBPACK_IMPORTED_MODULE_2__["default"].propTypes),
  additionalDescription: prop_types__WEBPACK_IMPORTED_MODULE_5___default().oneOfType([(prop_types__WEBPACK_IMPORTED_MODULE_5___default().string), (prop_types__WEBPACK_IMPORTED_MODULE_5___default().node)]),
  children: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().node)
};

/***/ }),

/***/ "./js/components/Banner/DismissButton.js":
/*!***********************************************!*\
  !*** ./js/components/Banner/DismissButton.js ***!
  \***********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ DismissButton)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-components */ "googlesitekit-components");
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */


function DismissButton({
  className,
  label = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Maybe later', 'google-site-kit'),
  onClick,
  disabled,
  tertiary = true
}) {
  if (!onClick) {
    return null;
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__.Button, {
    className: className,
    onClick: onClick,
    disabled: disabled,
    tertiary: tertiary,
    children: label
  });
}
DismissButton.propTypes = {
  className: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  label: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  onClick: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().func),
  disabled: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().bool),
  tertiary: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().bool),
  dismissOptions: prop_types__WEBPACK_IMPORTED_MODULE_3___default().shape({
    expiresInSeconds: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().number),
    skipHidingFromQueue: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().bool)
  })
};

/***/ }),

/***/ "./js/components/Banner/Footer.js":
/*!****************************************!*\
  !*** ./js/components/Banner/Footer.js ***!
  \****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Footer)
/* harmony export */ });
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



function Footer({
  className,
  children
}) {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", {
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-banner__footer', className),
    children: children
  });
}
Footer.propTypes = {
  className: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().string),
  children: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().node)
};

/***/ }),

/***/ "./js/components/Banner/HelpText.js":
/*!******************************************!*\
  !*** ./js/components/Banner/HelpText.js ***!
  \******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ HelpText)
/* harmony export */ });
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



function HelpText({
  className,
  children
}) {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("p", {
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-banner__help-text', className),
    children: children
  });
}
HelpText.propTypes = {
  className: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().string),
  children: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().node)
};

/***/ }),

/***/ "./js/components/Banner/LearnMoreLink.js":
/*!***********************************************!*\
  !*** ./js/components/Banner/LearnMoreLink.js ***!
  \***********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ LearnMoreLink)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _js_components_Link__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/components/Link */ "./js/components/Link.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */


function LearnMoreLink({
  href,
  className,
  label = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Learn more', 'google-site-kit'),
  external = true,
  onClick = () => {}
}) {
  if (!href) {
    return null;
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)(_js_components_Link__WEBPACK_IMPORTED_MODULE_1__["default"], {
    href: href,
    className: className,
    onClick: onClick,
    external: external,
    children: label
  });
}
LearnMoreLink.propTypes = {
  href: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string).isRequired,
  className: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  label: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  external: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().bool),
  onClick: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().func)
};

/***/ }),

/***/ "./js/components/Banner/Title.js":
/*!***************************************!*\
  !*** ./js/components/Banner/Title.js ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Title)
/* harmony export */ });
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



function Title({
  className,
  children
}) {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("p", {
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-banner__title', className),
    children: children
  });
}
Title.propTypes = {
  className: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().string),
  children: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().node)
};

/***/ }),

/***/ "./js/components/Banner/TitleIcon.js":
/*!*******************************************!*\
  !*** ./js/components/Banner/TitleIcon.js ***!
  \*******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ TitleIcon)
/* harmony export */ });
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



function TitleIcon({
  className,
  children
}) {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", {
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-banner__title-icon', className),
    children: children
  });
}
TitleIcon.propTypes = {
  className: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().string),
  children: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().node)
};

/***/ }),

/***/ "./js/components/Banner/index.js":
/*!***************************************!*\
  !*** ./js/components/Banner/index.js ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_13___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_13__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/hooks/useBreakpoint */ "./js/hooks/useBreakpoint.js");
/* harmony import */ var _TitleIcon__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./TitleIcon */ "./js/components/Banner/TitleIcon.js");
/* harmony import */ var _Title__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./Title */ "./js/components/Banner/Title.js");
/* harmony import */ var _Description__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./Description */ "./js/components/Banner/Description.js");
/* harmony import */ var _HelpText__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./HelpText */ "./js/components/Banner/HelpText.js");
/* harmony import */ var _LearnMoreLink__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./LearnMoreLink */ "./js/components/Banner/LearnMoreLink.js");
/* harmony import */ var _CTAButton__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./CTAButton */ "./js/components/Banner/CTAButton.js");
/* harmony import */ var _DismissButton__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./DismissButton */ "./js/components/Banner/DismissButton.js");
/* harmony import */ var _Footer__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./Footer */ "./js/components/Banner/Footer.js");
/* harmony import */ var _js_components_Notice__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @/js/components/Notice */ "./js/components/Notice/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */











const Banner = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_12__.forwardRef)(({
  className,
  titleIcon,
  title,
  description,
  additionalDescription,
  errorText,
  helpText,
  learnMoreLink,
  dismissButton,
  ctaButton,
  svg,
  // NOTE: SVGs must be imported with the ?url suffix for use as a backgroundImage in this component.
  footer
}, ref) => {
  const breakpoint = (0,_js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_1__.useBreakpoint)();
  const isMobileOrTablet = breakpoint === _js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_1__.BREAKPOINT_SMALL || breakpoint === _js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_1__.BREAKPOINT_TABLET;
  let SVGData = null;
  if (isMobileOrTablet && svg?.mobile) {
    SVGData = svg.mobile;
  } else if (!isMobileOrTablet && svg?.desktop) {
    SVGData = svg.desktop;
  }
  const svgMode = svg?.verticalPosition ? svg.verticalPosition : 'center';
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("div", {
    ref: ref,
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-banner', className),
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("div", {
      className: "googlesitekit-banner__content",
      children: [titleIcon && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_TitleIcon__WEBPACK_IMPORTED_MODULE_2__["default"], {
        children: titleIcon
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_Title__WEBPACK_IMPORTED_MODULE_3__["default"], {
        children: title
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_Description__WEBPACK_IMPORTED_MODULE_4__["default"], {
        description: description,
        learnMoreLink: learnMoreLink,
        additionalDescription: additionalDescription
      }), helpText && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_HelpText__WEBPACK_IMPORTED_MODULE_5__["default"], {
        children: helpText
      }), errorText && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_js_components_Notice__WEBPACK_IMPORTED_MODULE_10__["default"], {
        type: "error",
        description: errorText
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("div", {
        className: "googlesitekit-notice__action",
        children: [ctaButton && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_CTAButton__WEBPACK_IMPORTED_MODULE_7__["default"], {
          ...ctaButton
        }), dismissButton?.onClick && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_DismissButton__WEBPACK_IMPORTED_MODULE_8__["default"], {
          ...dismissButton
        })]
      })]
    }), SVGData && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("div", {
      className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-banner__svg-wrapper', {
        [`googlesitekit-banner__svg-wrapper--${svgMode}`]: svgMode
      }),
      style: {
        backgroundImage: `url(${SVGData})`
      }
    }), footer && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_Footer__WEBPACK_IMPORTED_MODULE_9__["default"], {
      children: footer
    })]
  });
});
Banner.propTypes = {
  titleIcon: (prop_types__WEBPACK_IMPORTED_MODULE_13___default().node),
  title: (prop_types__WEBPACK_IMPORTED_MODULE_13___default().string),
  description: prop_types__WEBPACK_IMPORTED_MODULE_13___default().oneOfType([(prop_types__WEBPACK_IMPORTED_MODULE_13___default().string), (prop_types__WEBPACK_IMPORTED_MODULE_13___default().node)]),
  additionalDescription: prop_types__WEBPACK_IMPORTED_MODULE_13___default().oneOfType([(prop_types__WEBPACK_IMPORTED_MODULE_13___default().string), (prop_types__WEBPACK_IMPORTED_MODULE_13___default().node)]),
  errorText: (prop_types__WEBPACK_IMPORTED_MODULE_13___default().string),
  helpText: (prop_types__WEBPACK_IMPORTED_MODULE_13___default().string),
  learnMoreLink: prop_types__WEBPACK_IMPORTED_MODULE_13___default().shape(_LearnMoreLink__WEBPACK_IMPORTED_MODULE_6__["default"].propTypes),
  dismissButton: prop_types__WEBPACK_IMPORTED_MODULE_13___default().shape(_DismissButton__WEBPACK_IMPORTED_MODULE_8__["default"].propTypes),
  ctaButton: prop_types__WEBPACK_IMPORTED_MODULE_13___default().shape(_CTAButton__WEBPACK_IMPORTED_MODULE_7__["default"].propTypes),
  svg: prop_types__WEBPACK_IMPORTED_MODULE_13___default().shape({
    desktop: (prop_types__WEBPACK_IMPORTED_MODULE_13___default().elementType),
    mobile: (prop_types__WEBPACK_IMPORTED_MODULE_13___default().elementType),
    verticalPosition: prop_types__WEBPACK_IMPORTED_MODULE_13___default().oneOf(['top', 'center', 'bottom'])
  }),
  footer: (prop_types__WEBPACK_IMPORTED_MODULE_13___default().node)
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Banner);

/***/ }),

/***/ "./js/components/ChangeArrow.js":
/*!**************************************!*\
  !*** ./js/components/ChangeArrow.js ***!
  \**************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * External dependencies
 */



function ChangeArrow({
  direction,
  invertColor,
  width,
  height
}) {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("svg", {
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-change-arrow', `googlesitekit-change-arrow--${direction}`, {
      'googlesitekit-change-arrow--inverted-color': invertColor
    }),
    width: width,
    height: height,
    viewBox: "0 0 10 10",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg",
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("path", {
      d: "M5.625 10L5.625 2.375L9.125 5.875L10 5L5 -1.76555e-07L-2.7055e-07 5L0.875 5.875L4.375 2.375L4.375 10L5.625 10Z",
      fill: "currentColor"
    })
  });
}
ChangeArrow.propTypes = {
  direction: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().string),
  invertColor: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().bool),
  width: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().number),
  height: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().number)
};
ChangeArrow.defaultProps = {
  direction: 'up',
  invertColor: false,
  width: 9,
  height: 9
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ChangeArrow);

/***/ }),

/***/ "./js/components/ChangeBadge.js":
/*!**************************************!*\
  !*** ./js/components/ChangeBadge.js ***!
  \**************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ ChangeBadge)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _js_util__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/util */ "./js/util/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * ChangeBadge component.
 *
 * Site Kit by Google, Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * Internal dependencies
 */


function ChangeBadge(props) {
  const {
    previousValue,
    currentValue,
    isAbsolute
  } = props;
  const change = isAbsolute ? currentValue - previousValue : (0,_js_util__WEBPACK_IMPORTED_MODULE_1__.calculateChange)(previousValue, currentValue);
  const isNegative = change < 0;
  const isZero = change === 0;

  // Do not display the change badge if the change value can't be calculated.
  if (change === null) {
    return null;
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("div", {
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-change-badge', {
      'googlesitekit-change-badge--negative': isNegative,
      'googlesitekit-change-badge--zero': isZero
    }),
    children: (0,_js_util__WEBPACK_IMPORTED_MODULE_1__.numFmt)(change, {
      style: 'percent',
      signDisplay: 'exceptZero',
      maximumFractionDigits: 1
    })
  });
}
ChangeBadge.propTypes = {
  isAbsolute: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().bool),
  previousValue: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().number).isRequired,
  currentValue: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().number).isRequired
};

/***/ }),

/***/ "./js/components/DashboardNavigation/Navigation/hooks/useNavChipHelpers.js":
/*!*********************************************************************************!*\
  !*** ./js/components/DashboardNavigation/Navigation/hooks/useNavChipHelpers.js ***!
  \*********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ useNavChipHelpers)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _js_util_scroll__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @/js/util/scroll */ "./js/util/scroll.js");
/* harmony import */ var _js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/hooks/useBreakpoint */ "./js/hooks/useBreakpoint.js");
/* harmony import */ var _js_hooks_useViewOnly__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/hooks/useViewOnly */ "./js/hooks/useViewOnly.js");
/* harmony import */ var _js_googlesitekit_constants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/googlesitekit/constants */ "./js/googlesitekit/constants.js");
/**
 * Navigation `useNavChipHelpers` hook.
 *
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */





/**
 * Returns helper data and functions for navigation chips.
 *
 * @since 1.159.0
 *
 * @param {Object}        params                 Parameters for the hook.
 * @param {Array<string>} params.visibleSections The sections that are currently visible.
 * @return {Object} An object containing helper data and functions for navigation chips.
 */
function useNavChipHelpers({
  visibleSections
}) {
  const breakpoint = (0,_js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_1__.useBreakpoint)();
  const viewOnlyDashboard = (0,_js_hooks_useViewOnly__WEBPACK_IMPORTED_MODULE_2__["default"])();

  /**
   * Gets the default chip ID based on the visibility of various sections.
   *
   * @since 1.159.0
   *
   * @return {string} The default chip ID.
   */
  const getDefaultChipID = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_4__.useCallback)(() => {
    if (visibleSections.includes(_js_googlesitekit_constants__WEBPACK_IMPORTED_MODULE_3__.ANCHOR_ID_KEY_METRICS)) {
      return _js_googlesitekit_constants__WEBPACK_IMPORTED_MODULE_3__.ANCHOR_ID_KEY_METRICS;
    }
    if (!viewOnlyDashboard) {
      return _js_googlesitekit_constants__WEBPACK_IMPORTED_MODULE_3__.ANCHOR_ID_TRAFFIC;
    }
    return visibleSections[0] || '';
  }, [viewOnlyDashboard, visibleSections]);
  const defaultChipID = getDefaultChipID();

  /**
   * Checks if a chip ID is valid based on the visible sections.
   *
   * @since 1.159.0
   *
   * @param {string} chipID The chip ID to validate.
   * @return {boolean} True if the chip ID is valid, false otherwise.
   */
  const isValidChipID = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_4__.useCallback)(chipID => visibleSections.includes(chipID), [visibleSections]);

  /**
   * Updates the URL hash to reflect the selected chip ID.
   *
   * @since 1.159.0
   *
   * @param {string} chipID The chip ID to update in the URL hash.
   * @return {void}
   */
  const updateURLHash = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_4__.useCallback)(chipID => {
    __webpack_require__.g.history.replaceState({}, '', `#${chipID}`);
  }, []);

  /**
   * Calculates the scroll position for a given chip ID.
   *
   * @since 1.159.0
   *
   * @param {string} chipID The chip ID for which to calculate the scroll position.
   * @return {number} The calculated scroll position.
   */
  const calculateScrollPosition = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_4__.useCallback)(chipID => {
    return chipID !== defaultChipID ? (0,_js_util_scroll__WEBPACK_IMPORTED_MODULE_0__.getNavigationalScrollTop)(`#${chipID}`, breakpoint) : 0;
  }, [breakpoint, defaultChipID]);

  /**
   * Scrolls to the position of a given chip ID.
   *
   * @since 1.159.0
   *
   * @param {string} chipID The chip ID to scroll to.
   * @return {void}
   */
  const scrollToChip = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_4__.useCallback)(chipID => {
    __webpack_require__.g.scrollTo({
      top: calculateScrollPosition(chipID, breakpoint, defaultChipID),
      behavior: 'smooth'
    });
  }, [breakpoint, calculateScrollPosition, defaultChipID]);

  /**
   * Finds the closest section ID based on the current scroll position.
   *
   * @since 1.159.0
   *
   * @param {Object} ref The reference to the navigation element.
   * @return {string} The ID of the closest section.
   */
  const findClosestSection = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_4__.useCallback)(ref => {
    var _ref$current$getBound;
    const entityHeader = document.querySelector('.googlesitekit-entity-header')?.getBoundingClientRect?.()?.bottom;
    const {
      bottom
    } = (_ref$current$getBound = ref?.current?.getBoundingClientRect?.()) !== null && _ref$current$getBound !== void 0 ? _ref$current$getBound : {};
    const margin = 20;
    let closest;
    let closestID = defaultChipID;
    for (const areaID of visibleSections) {
      const area = document.getElementById(areaID);
      if (!area) {
        continue;
      }
      const top = area.getBoundingClientRect().top - margin - (entityHeader || bottom || 0);
      if (top < 0 && (closest === undefined || closest < top)) {
        closest = top;
        closestID = areaID;
      }
    }
    return closestID;
  }, [defaultChipID, visibleSections]);
  return {
    calculateScrollPosition,
    defaultChipID,
    findClosestSection,
    isValidChipID,
    scrollToChip,
    updateURLHash
  };
}

/***/ }),

/***/ "./js/components/DashboardNavigation/Navigation/hooks/useVisibleSections.js":
/*!**********************************************************************************!*\
  !*** ./js/components/DashboardNavigation/Navigation/hooks/useVisibleSections.js ***!
  \**********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   contexts: () => (/* binding */ contexts),
/* harmony export */   "default": () => (/* binding */ useVisibleSections)
/* harmony export */ });
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _js_googlesitekit_constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/googlesitekit/constants */ "./js/googlesitekit/constants.js");
/* harmony import */ var _js_googlesitekit_widgets_default_contexts__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/googlesitekit/widgets/default-contexts */ "./js/googlesitekit/widgets/default-contexts.js");
/* harmony import */ var _js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/googlesitekit/datastore/user/constants */ "./js/googlesitekit/datastore/user/constants.js");
/* harmony import */ var _js_googlesitekit_widgets_datastore_constants__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/googlesitekit/widgets/datastore/constants */ "./js/googlesitekit/widgets/datastore/constants.js");
/* harmony import */ var _js_hooks_useDashboardType__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/hooks/useDashboardType */ "./js/hooks/useDashboardType.js");
/* harmony import */ var _js_hooks_useViewOnly__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @/js/hooks/useViewOnly */ "./js/hooks/useViewOnly.js");
/**
 * Navigation `useVisibleSections` hook.
 *
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Internal dependencies
 */







const contexts = {
  [_js_hooks_useDashboardType__WEBPACK_IMPORTED_MODULE_5__.DASHBOARD_TYPE_MAIN]: {
    [_js_googlesitekit_constants__WEBPACK_IMPORTED_MODULE_1__.ANCHOR_ID_KEY_METRICS]: _js_googlesitekit_widgets_default_contexts__WEBPACK_IMPORTED_MODULE_2__.CONTEXT_MAIN_DASHBOARD_KEY_METRICS,
    [_js_googlesitekit_constants__WEBPACK_IMPORTED_MODULE_1__.ANCHOR_ID_TRAFFIC]: _js_googlesitekit_widgets_default_contexts__WEBPACK_IMPORTED_MODULE_2__.CONTEXT_MAIN_DASHBOARD_TRAFFIC,
    [_js_googlesitekit_constants__WEBPACK_IMPORTED_MODULE_1__.ANCHOR_ID_CONTENT]: _js_googlesitekit_widgets_default_contexts__WEBPACK_IMPORTED_MODULE_2__.CONTEXT_MAIN_DASHBOARD_CONTENT,
    [_js_googlesitekit_constants__WEBPACK_IMPORTED_MODULE_1__.ANCHOR_ID_SPEED]: _js_googlesitekit_widgets_default_contexts__WEBPACK_IMPORTED_MODULE_2__.CONTEXT_MAIN_DASHBOARD_SPEED,
    [_js_googlesitekit_constants__WEBPACK_IMPORTED_MODULE_1__.ANCHOR_ID_MONETIZATION]: _js_googlesitekit_widgets_default_contexts__WEBPACK_IMPORTED_MODULE_2__.CONTEXT_MAIN_DASHBOARD_MONETIZATION
  },
  [_js_hooks_useDashboardType__WEBPACK_IMPORTED_MODULE_5__.DASHBOARD_TYPE_ENTITY]: {
    [_js_googlesitekit_constants__WEBPACK_IMPORTED_MODULE_1__.ANCHOR_ID_TRAFFIC]: _js_googlesitekit_widgets_default_contexts__WEBPACK_IMPORTED_MODULE_2__.CONTEXT_ENTITY_DASHBOARD_TRAFFIC,
    [_js_googlesitekit_constants__WEBPACK_IMPORTED_MODULE_1__.ANCHOR_ID_CONTENT]: _js_googlesitekit_widgets_default_contexts__WEBPACK_IMPORTED_MODULE_2__.CONTEXT_ENTITY_DASHBOARD_CONTENT,
    [_js_googlesitekit_constants__WEBPACK_IMPORTED_MODULE_1__.ANCHOR_ID_SPEED]: _js_googlesitekit_widgets_default_contexts__WEBPACK_IMPORTED_MODULE_2__.CONTEXT_ENTITY_DASHBOARD_SPEED,
    [_js_googlesitekit_constants__WEBPACK_IMPORTED_MODULE_1__.ANCHOR_ID_MONETIZATION]: _js_googlesitekit_widgets_default_contexts__WEBPACK_IMPORTED_MODULE_2__.CONTEXT_ENTITY_DASHBOARD_MONETIZATION
  }
};

/**
 * Returns the visible sections for the dashboard navigation.
 *
 * @since 1.159.0
 *
 * @return {Array<string>} The visible sections.
 */
function useVisibleSections() {
  const dashboardType = (0,_js_hooks_useDashboardType__WEBPACK_IMPORTED_MODULE_5__["default"])();
  const viewOnlyDashboard = (0,_js_hooks_useViewOnly__WEBPACK_IMPORTED_MODULE_6__["default"])();
  return (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useSelect)(select => {
    const viewableModules = viewOnlyDashboard ? select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_USER).getViewableModules() : null;
    const isKeyMetricsWidgetHidden = select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_USER).isKeyMetricsWidgetHidden();
    const widgetContextOptions = {
      modules: viewableModules ? viewableModules : undefined
    };
    return Object.keys(contexts[dashboardType]).reduce((visibleSections, section) => {
      // Skip key metrics section if it's hidden.
      if (section === _js_googlesitekit_constants__WEBPACK_IMPORTED_MODULE_1__.ANCHOR_ID_KEY_METRICS && isKeyMetricsWidgetHidden) {
        return visibleSections;
      }
      if (select(_js_googlesitekit_widgets_datastore_constants__WEBPACK_IMPORTED_MODULE_4__.CORE_WIDGETS).isWidgetContextActive(contexts[dashboardType][section], widgetContextOptions)) {
        visibleSections.push(section);
      }
      return visibleSections;
    }, []);
  });
}

/***/ }),

/***/ "./js/components/DashboardNavigation/Navigation/index.js":
/*!***************************************************************!*\
  !*** ./js/components/DashboardNavigation/Navigation/index.js ***!
  \***************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Navigation)
/* harmony export */ });
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react_use__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! react-use */ "../node_modules/react-use/esm/useMount.js");
/* harmony import */ var _material_react_chips__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @material/react-chips */ "../node_modules/@material/react-chips/dist/index.js");
/* harmony import */ var _material_react_chips__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_material_react_chips__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_compose__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! @wordpress/compose */ "../node_modules/@wordpress/compose/build-module/hooks/use-throttle/index.js");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _js_googlesitekit_constants__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/googlesitekit/constants */ "./js/googlesitekit/constants.js");
/* harmony import */ var _js_googlesitekit_datastore_ui_constants__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/googlesitekit/datastore/ui/constants */ "./js/googlesitekit/datastore/ui/constants.js");
/* harmony import */ var _js_util__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @/js/util */ "./js/util/index.js");
/* harmony import */ var _js_hooks_useDashboardType__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @/js/hooks/useDashboardType */ "./js/hooks/useDashboardType.js");
/* harmony import */ var _hooks_useNavChipHelpers__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./hooks/useNavChipHelpers */ "./js/components/DashboardNavigation/Navigation/hooks/useNavChipHelpers.js");
/* harmony import */ var _js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @/js/hooks/useViewContext */ "./js/hooks/useViewContext.js");
/* harmony import */ var _hooks_useVisibleSections__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./hooks/useVisibleSections */ "./js/components/DashboardNavigation/Navigation/hooks/useVisibleSections.js");
/* harmony import */ var _svg_icons_nav_content_icon_svg__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @/svg/icons/nav-content-icon.svg */ "./svg/icons/nav-content-icon.svg");
/* harmony import */ var _svg_icons_nav_key_metrics_icon_svg__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! @/svg/icons/nav-key-metrics-icon.svg */ "./svg/icons/nav-key-metrics-icon.svg");
/* harmony import */ var _svg_icons_nav_monetization_icon_svg__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! @/svg/icons/nav-monetization-icon.svg */ "./svg/icons/nav-monetization-icon.svg");
/* harmony import */ var _svg_icons_nav_speed_icon_svg__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! @/svg/icons/nav-speed-icon.svg */ "./svg/icons/nav-speed-icon.svg");
/* harmony import */ var _svg_icons_nav_traffic_icon_svg__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! @/svg/icons/nav-traffic-icon.svg */ "./svg/icons/nav-traffic-icon.svg");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Navigation component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */




/**
 * WordPress dependencies
 */




/**
 * Internal dependencies
 */














function Navigation() {
  const dashboardType = (0,_js_hooks_useDashboardType__WEBPACK_IMPORTED_MODULE_7__["default"])();
  const elementRef = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_17__.useRef)();
  const viewContext = (0,_js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_9__["default"])();
  const visibleSections = (0,_hooks_useVisibleSections__WEBPACK_IMPORTED_MODULE_10__["default"])();
  const {
    calculateScrollPosition,
    defaultChipID,
    findClosestSection,
    isValidChipID,
    scrollToChip,
    updateURLHash
  } = (0,_hooks_useNavChipHelpers__WEBPACK_IMPORTED_MODULE_8__["default"])({
    visibleSections
  });
  const initialHash = __webpack_require__.g.location.hash?.substring(1);
  const [isJumpingTo, setIsJumpingTo] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_17__.useState)(initialHash || undefined);
  const [isSticky, setIsSticky] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_17__.useState)(false);
  const [selectedID, setSelectedID] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_17__.useState)(initialHash);
  const {
    setValue
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__.useDispatch)(_js_googlesitekit_datastore_ui_constants__WEBPACK_IMPORTED_MODULE_5__.CORE_UI);

  /**
   * Handles the selection of a chip.
   *
   * @since 1.159.0
   *
   * @param {Object} event The click event.
   * @return {void}
   */
  const handleSelect = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_17__.useCallback)(({
    target
  }) => {
    const chip = target.closest('.mdc-chip');
    const chipID =
    // Uses non-acronym case to meet DOM data attribute standards.
    // eslint-disable-next-line sitekit/acronym-case
    chip?.dataset?.contextId;

    // Update URL and scroll to the selected chip.
    updateURLHash(chipID);
    setIsJumpingTo(chipID);
    scrollToChip(chipID);

    // Track user event.
    (0,_js_util__WEBPACK_IMPORTED_MODULE_6__.trackEvent)(`${viewContext}_navigation`, 'tab_select', chipID);
    setTimeout(() => {
      setValue(_js_googlesitekit_datastore_ui_constants__WEBPACK_IMPORTED_MODULE_5__.ACTIVE_CONTEXT_ID, chipID);
    }, 50);
  }, [scrollToChip, setValue, updateURLHash, viewContext]);

  /**
   * Determines the sticky state of navigation based on scroll position.
   *
   * @since 1.159.0
   *
   * @return {void}
   */
  const handleSticky = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_17__.useCallback)(() => {
    if (!elementRef?.current) {
      return;
    }
    const {
      top
    } = elementRef?.current?.getBoundingClientRect();
    if (__webpack_require__.g.scrollY === 0) {
      setIsSticky(false);
    } else {
      const headerBottom = document.querySelector('.googlesitekit-header')?.getBoundingClientRect?.()?.bottom;
      setIsSticky(top === headerBottom);
    }
  }, []);

  /**
   * Determines the selected state of a chip based on scroll position.
   *
   * @since 1.159.0
   *
   * @param {Event} event The scroll event.
   * @return {void}
   */
  const handleSelectedChip = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_17__.useCallback)(event => {
    function changeSelectedChip(chipID) {
      setValue(_js_googlesitekit_datastore_ui_constants__WEBPACK_IMPORTED_MODULE_5__.ACTIVE_CONTEXT_ID, undefined);
      setSelectedID(chipID);
      setIsJumpingTo(undefined);
    }
    const closestID = findClosestSection(elementRef);

    // Check if user clicked on a chip and is actively jumping to it.
    if (isJumpingTo) {
      if (isJumpingTo === closestID) {
        changeSelectedChip(closestID);
      }
    } else {
      const {
        hash
      } = __webpack_require__.g.location;
      if (closestID !== hash?.substring(1)) {
        if (event) {
          (0,_js_util__WEBPACK_IMPORTED_MODULE_6__.trackEvent)(`${viewContext}_navigation`, 'tab_scroll', closestID);
        }
        updateURLHash(closestID);
        changeSelectedChip(closestID);
      }
    }
  }, [findClosestSection, isJumpingTo, setValue, updateURLHash, viewContext]);

  // Set up initial chip on mount.
  (0,react_use__WEBPACK_IMPORTED_MODULE_18__["default"])(() => {
    // If no initial hash is set, set the default chip as selected.
    if (!initialHash) {
      setSelectedID(defaultChipID);
      setTimeout(() => updateURLHash(defaultChipID));
      return;
    }
    const chipID = isValidChipID(initialHash) ? initialHash : defaultChipID;

    // Set initial/default chip ID in state.
    setSelectedID(chipID);
    setValue(_js_googlesitekit_datastore_ui_constants__WEBPACK_IMPORTED_MODULE_5__.ACTIVE_CONTEXT_ID, chipID);

    // Scroll to the chip position.
    setTimeout(() => {
      const scrollTo = calculateScrollPosition(chipID);
      if (__webpack_require__.g.scrollY === scrollTo) {
        setValue(_js_googlesitekit_datastore_ui_constants__WEBPACK_IMPORTED_MODULE_5__.ACTIVE_CONTEXT_ID, undefined);
        return;
      }
      scrollToChip(chipID);
    }, 50);
  });
  const onScroll = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_17__.useCallback)(event => {
    handleSticky();
    handleSelectedChip(event);
  }, [handleSelectedChip, handleSticky]);
  const throttledOnScroll = (0,_wordpress_compose__WEBPACK_IMPORTED_MODULE_19__["default"])(onScroll, 150);

  // Handle scroll events to update sticky state and selected chip.
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_17__.useEffect)(() => {
    __webpack_require__.g.addEventListener('scroll', throttledOnScroll);
    return () => {
      __webpack_require__.g.removeEventListener('scroll', throttledOnScroll);
    };
  }, [throttledOnScroll]);
  const chips = {
    [_js_googlesitekit_constants__WEBPACK_IMPORTED_MODULE_4__.ANCHOR_ID_KEY_METRICS]: {
      label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Key metrics', 'google-site-kit'),
      icon: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx)(_svg_icons_nav_key_metrics_icon_svg__WEBPACK_IMPORTED_MODULE_12__["default"], {
        width: "18",
        height: "16"
      })
    },
    [_js_googlesitekit_constants__WEBPACK_IMPORTED_MODULE_4__.ANCHOR_ID_TRAFFIC]: {
      label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Traffic', 'google-site-kit'),
      icon: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx)(_svg_icons_nav_traffic_icon_svg__WEBPACK_IMPORTED_MODULE_15__["default"], {
        width: "18",
        height: "16"
      })
    },
    [_js_googlesitekit_constants__WEBPACK_IMPORTED_MODULE_4__.ANCHOR_ID_CONTENT]: {
      label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Content', 'google-site-kit'),
      icon: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx)(_svg_icons_nav_content_icon_svg__WEBPACK_IMPORTED_MODULE_11__["default"], {
        width: "18",
        height: "18"
      })
    },
    [_js_googlesitekit_constants__WEBPACK_IMPORTED_MODULE_4__.ANCHOR_ID_SPEED]: {
      label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Speed', 'google-site-kit'),
      icon: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx)(_svg_icons_nav_speed_icon_svg__WEBPACK_IMPORTED_MODULE_14__["default"], {
        width: "20",
        height: "16"
      })
    },
    [_js_googlesitekit_constants__WEBPACK_IMPORTED_MODULE_4__.ANCHOR_ID_MONETIZATION]: {
      label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Monetization', 'google-site-kit'),
      icon: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx)(_svg_icons_nav_monetization_icon_svg__WEBPACK_IMPORTED_MODULE_13__["default"], {
        width: "18",
        height: "16"
      })
    }
  };
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx)("nav", {
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('mdc-chip-set', 'googlesitekit-navigation', `googlesitekit-navigation--${dashboardType}`, {
      'googlesitekit-navigation--is-sticky': isSticky
    }),
    ref: elementRef,
    children: visibleSections.map(anchorID => {
      return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx)(_material_react_chips__WEBPACK_IMPORTED_MODULE_1__.Chip, {
        id: anchorID,
        label: chips[anchorID].label,
        leadingIcon: chips[anchorID].icon,
        onClick: handleSelect,
        selected: selectedID === anchorID,
        "data-context-id": anchorID
      }, anchorID);
    })
  });
}

/***/ }),

/***/ "./js/components/DashboardNavigation/index.js":
/*!****************************************************!*\
  !*** ./js/components/DashboardNavigation/index.js ***!
  \****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ DashboardNavigation)
/* harmony export */ });
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/googlesitekit/datastore/user/constants */ "./js/googlesitekit/datastore/user/constants.js");
/* harmony import */ var _js_hooks_useViewOnly__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/hooks/useViewOnly */ "./js/hooks/useViewOnly.js");
/* harmony import */ var _js_components_LoadingWrapper__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/components/LoadingWrapper */ "./js/components/LoadingWrapper.js");
/* harmony import */ var _Navigation__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./Navigation */ "./js/components/DashboardNavigation/Navigation/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * DashboardNavigation component.
 *
 * Site Kit by Google, Copyright 2022 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Internal dependencies
 */






function DashboardNavigation() {
  const viewOnlyDashboard = (0,_js_hooks_useViewOnly__WEBPACK_IMPORTED_MODULE_2__["default"])();
  const viewableModules = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useSelect)(select => {
    if (!viewOnlyDashboard) {
      return null;
    }
    return select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_1__.CORE_USER).getViewableModules();
  });
  const keyMetrics = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useSelect)(select => select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_1__.CORE_USER).getKeyMetrics());

  // The Navigation component relies on the resolution of the above selectors to check if individual
  // widgetContexts are active. The results of these checks are used to determine the `defaultChipID`
  // which 'highlights' the first chip and sets the corresponding hash on page load.
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_js_components_LoadingWrapper__WEBPACK_IMPORTED_MODULE_3__["default"], {
    loading: viewableModules === undefined || keyMetrics === undefined,
    width: "100%",
    smallHeight: "59px",
    height: "71px",
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_Navigation__WEBPACK_IMPORTED_MODULE_4__["default"], {})
  });
}

/***/ }),

/***/ "./js/components/EntityHeader.js":
/*!***************************************!*\
  !*** ./js/components/EntityHeader.js ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_compose__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! @wordpress/compose */ "../node_modules/@wordpress/compose/build-module/hooks/use-throttle/index.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! googlesitekit-components */ "googlesitekit-components");
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_components__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/googlesitekit/datastore/site/constants */ "./js/googlesitekit/datastore/site/constants.js");
/* harmony import */ var _svg_icons_keyboard_backspace_svg__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/svg/icons/keyboard-backspace.svg */ "./svg/icons/keyboard-backspace.svg");
/* harmony import */ var _js_googlesitekit_datastore_location_constants__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/googlesitekit/datastore/location/constants */ "./js/googlesitekit/datastore/location/constants.js");
/* harmony import */ var _Link__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./Link */ "./js/components/Link.js");
/* harmony import */ var _Typography_P__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./Typography/P */ "./js/components/Typography/P.js");
/* harmony import */ var _js_util_urls__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @/js/util/urls */ "./js/util/urls.js");
/* harmony import */ var _js_util__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @/js/util */ "./js/util/index.js");
/* harmony import */ var _js_hooks_useDashboardType__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @/js/hooks/useDashboardType */ "./js/hooks/useDashboardType.js");
/* harmony import */ var _js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @/js/hooks/useViewContext */ "./js/hooks/useViewContext.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * EntityHeader component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */




/**
 * Internal dependencies
 */












function EntityHeader() {
  const viewContext = (0,_js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_11__["default"])();
  const dashboardType = (0,_js_hooks_useDashboardType__WEBPACK_IMPORTED_MODULE_10__["default"])();
  const currentEntityTitle = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_SITE).getCurrentEntityTitle());
  const entityURL = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_SITE).getCurrentEntityURL());
  const headerDetailsRef = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_13__.useRef)();
  const [url, setURL] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_13__.useState)(entityURL);
  const shortenEntityURL = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_13__.useCallback)(() => {
    if (!headerDetailsRef.current) {
      return;
    }

    // Remove 40 px for margins + SVG at the end of the URL link.
    const availableWidth = headerDetailsRef.current.clientWidth - 40;
    const urlFontSize = __webpack_require__.g.getComputedStyle(headerDetailsRef.current.lastChild, null).getPropertyValue('font-size');
    const fontSize = parseFloat(urlFontSize);

    // 2 is appox. the minimum character constant for sans-serif fonts:
    // https://pearsonified.com/characters-per-line/
    const maxChars = availableWidth * 2 / fontSize;
    setURL((0,_js_util_urls__WEBPACK_IMPORTED_MODULE_8__.shortenURL)(entityURL, maxChars));
  }, [entityURL]);
  const throttledShortenEntityURL = (0,_wordpress_compose__WEBPACK_IMPORTED_MODULE_14__["default"])(shortenEntityURL, 150);
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_13__.useEffect)(() => {
    __webpack_require__.g.addEventListener('resize', throttledShortenEntityURL);
    return () => {
      __webpack_require__.g.removeEventListener('resize', throttledShortenEntityURL);
    };
  }, [throttledShortenEntityURL]);
  const {
    navigateTo
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useDispatch)(_js_googlesitekit_datastore_location_constants__WEBPACK_IMPORTED_MODULE_5__.CORE_LOCATION);
  const returnURL = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_SITE).getAdminURL('googlesitekit-dashboard'));
  const onClick = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_13__.useCallback)(() => {
    (0,_js_util__WEBPACK_IMPORTED_MODULE_9__.trackEvent)(`${viewContext}_navigation`, 'return_to_dashboard');
    navigateTo(returnURL);
  }, [returnURL, navigateTo, viewContext]);
  if (_js_hooks_useDashboardType__WEBPACK_IMPORTED_MODULE_10__.DASHBOARD_TYPE_ENTITY !== dashboardType || entityURL === null || currentEntityTitle === null) {
    return null;
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsxs)("div", {
    className: "googlesitekit-entity-header",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx)("div", {
      className: "googlesitekit-entity-header__back",
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_2__.Button, {
        icon: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx)(_svg_icons_keyboard_backspace_svg__WEBPACK_IMPORTED_MODULE_4__["default"], {
          width: 24,
          height: 24
        })
        // This is duplicated because on small screens, the text supplied to the
        // Button is rendered as a sub-component and is set to `display: none`,
        // but the button itself remains on-screen (and thus this aria-label is
        // accessible to screen-readers).
        ,
        "aria-label": (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Back to dashboard', 'google-site-kit'),
        onClick: onClick,
        text: true,
        tertiary: true,
        children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Back to dashboard', 'google-site-kit')
      })
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsxs)("div", {
      ref: headerDetailsRef,
      className: "googlesitekit-entity-header__details",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx)(_Typography_P__WEBPACK_IMPORTED_MODULE_7__["default"], {
        children: currentEntityTitle
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx)(_Link__WEBPACK_IMPORTED_MODULE_6__["default"], {
        href: entityURL,
        "aria-label": entityURL,
        secondary: true,
        external: true,
        children: url
      })]
    })]
  });
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (EntityHeader);

/***/ }),

/***/ "./js/components/ErrorHandler/index.js":
/*!*********************************************!*\
  !*** ./js/components/ErrorHandler/index.js ***!
  \*********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _js_components_GenericErrorHandlerActions__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/components/GenericErrorHandlerActions */ "./js/components/GenericErrorHandlerActions.js");
/* harmony import */ var _js_components_Root_ViewContextContext__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/components/Root/ViewContextContext */ "./js/components/Root/ViewContextContext.js");
/* harmony import */ var _js_googlesitekit_notifications_components_layout_BannerNotification__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/googlesitekit/notifications/components/layout/BannerNotification */ "./js/googlesitekit/notifications/components/layout/BannerNotification.js");
/* harmony import */ var _js_util__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/util */ "./js/util/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * ErrorHandler component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */





class ErrorHandler extends _wordpress_element__WEBPACK_IMPORTED_MODULE_6__.Component {
  constructor(props) {
    super(props);
    this.state = {
      error: null,
      info: null,
      copied: false
    };
  }
  componentDidCatch(error, info) {
    __webpack_require__.g.console.error('Caught an error:', error, info);
    this.setState({
      error,
      info
    });
    (0,_js_util__WEBPACK_IMPORTED_MODULE_4__.trackEvent)('react_error', `handle_${this.context || 'unknown'}_error`,
    // label has a max-length of 500 bytes.
    `${error?.message}\n${info?.componentStack}`.slice(0, 500));
  }
  render() {
    const {
      children
    } = this.props;
    const {
      error,
      info
    } = this.state;

    // If there is no caught error, render the children components normally.
    if (!error) {
      return children;
    }
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_js_googlesitekit_notifications_components_layout_BannerNotification__WEBPACK_IMPORTED_MODULE_3__["default"], {
      notificationID: "googlesitekit-error",
      className: "googlesitekit-error-handler",
      type: "error",
      title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Site Kit encountered an error', 'google-site-kit'),
      description: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)(_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.Fragment, {
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_js_components_GenericErrorHandlerActions__WEBPACK_IMPORTED_MODULE_1__["default"], {
          message: error.message,
          componentStack: info.componentStack
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)("pre", {
          className: "googlesitekit-overflow-auto",
          children: [error.message, info.componentStack]
        })]
      })
    });
  }
}
ErrorHandler.contextType = _js_components_Root_ViewContextContext__WEBPACK_IMPORTED_MODULE_2__["default"];
ErrorHandler.propTypes = {
  /** @ignore */
  children: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().node).isRequired
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ErrorHandler);

/***/ }),

/***/ "./js/components/ErrorNotice.js":
/*!**************************************!*\
  !*** ./js/components/ErrorNotice.js ***!
  \**************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ ErrorNotice)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_url__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @wordpress/url */ "../node_modules/@wordpress/url/build-module/is-url.js");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _js_util_errors__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/util/errors */ "./js/util/errors.js");
/* harmony import */ var _Notice__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./Notice */ "./js/components/Notice/index.js");
/* harmony import */ var _js_util__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/util */ "./js/util/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * ErrorNotice component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */




/**
 * Internal dependencies
 */





function ErrorNotice({
  className,
  error,
  hasButton = false,
  storeName,
  message = error.message,
  noPrefix = false,
  skipRetryMessage,
  hideIcon = false
}) {
  const dispatch = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useDispatch)();
  const selectorData = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => {
    if (!storeName) {
      return null;
    }
    return select(storeName).getSelectorDataForError(error);
  });
  const handleRetry = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.useCallback)(() => {
    dispatch(selectorData.storeName).invalidateResolution(selectorData.name, selectorData.args);
  }, [dispatch, selectorData]);

  // Do not display if there is no error and no direct message text is passed as a direct prop.
  // Also do not display if the error is for missing scopes as these are handled by a popup modal.
  if (!message || (0,_js_util_errors__WEBPACK_IMPORTED_MODULE_2__.isPermissionScopeError)(error)) {
    return null;
  }
  const shouldDisplayRetry = hasButton && (0,_js_util_errors__WEBPACK_IMPORTED_MODULE_2__.isErrorRetryable)(error, selectorData);

  /**
   * Error message to display to the user. Sometimes we append a retry message
   * or a reconnect URL, so we create a new variable for the message to display.
   */
  let errorMessageWithModifications = message;

  // Append "Try again" messaging if no retry button is present.
  if (!hasButton && !skipRetryMessage) {
    errorMessageWithModifications = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.sprintf)(/* translators: %s: Error message from Google API. */
    (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('%s (Please try again.)', 'google-site-kit'), errorMessageWithModifications);
  }
  if (!noPrefix) {
    errorMessageWithModifications = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.sprintf)(/* translators: $%s: Error message */
    (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Error: %s', 'google-site-kit'), errorMessageWithModifications);
  }
  const reconnectURL = error?.data?.reconnectURL;
  if (reconnectURL && (0,_wordpress_url__WEBPACK_IMPORTED_MODULE_7__.isURL)(reconnectURL)) {
    /**
     * This error message uses HTML tags without using
     * `createInterpolateElement` because the error messages
     * that come from the server/API can also contain HTML (eg. links)
     * we want to render.
     *
     * Instead of creating a React node using `createInterpolateElement`,
     * we use `dangerouslySetInnerHTML` to allow the HTML we create and from
     * the server/API to be rendered as-intended.
     */
    errorMessageWithModifications = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.sprintf)(/* translators: 1: Original error message 2: Reconnect URL */
    (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('%1$s To fix this, <a href="%2$s">redo the plugin setup</a>.', 'google-site-kit'), errorMessageWithModifications, reconnectURL);
  }
  const sanitizeArgs = {
    ALLOWED_TAGS: ['a'],
    ALLOWED_ATTR: ['href']
  };
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_Notice__WEBPACK_IMPORTED_MODULE_3__["default"], {
    className: className,
    type: _Notice__WEBPACK_IMPORTED_MODULE_3__["default"].TYPES.ERROR,
    description:
    /*#__PURE__*/
    // The error messages that come from the server/API can contain
    // HTML (eg. links), so we use `dangerouslySetInnerHTML` and sanitize
    // the HTML to render these links.
    //
    // We tried to use `createInterpolateElement` but it does not work
    // with HTML tags that come from the server/API.
    (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("span", {
      dangerouslySetInnerHTML: (0,_js_util__WEBPACK_IMPORTED_MODULE_4__.sanitizeHTML)(errorMessageWithModifications, sanitizeArgs)
    }),
    ctaButton: shouldDisplayRetry ? {
      label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Retry', 'google-site-kit'),
      onClick: handleRetry
    } : undefined,
    hideIcon: hideIcon
  });
}
ErrorNotice.propTypes = {
  className: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().string),
  error: prop_types__WEBPACK_IMPORTED_MODULE_8___default().shape({
    message: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().string)
  }),
  hasButton: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().bool),
  storeName: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().string),
  message: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().string),
  noPrefix: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().bool),
  skipRetryMessage: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().bool),
  hideIcon: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().bool)
};

/***/ }),

/***/ "./js/components/FeatureTours.js":
/*!***************************************!*\
  !*** ./js/components/FeatureTours.js ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ FeatureTours)
/* harmony export */ });
/* harmony import */ var react_use__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! react-use */ "../node_modules/react-use/esm/useMount.js");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/googlesitekit/datastore/user/constants */ "./js/googlesitekit/datastore/user/constants.js");
/* harmony import */ var _js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/hooks/useViewContext */ "./js/hooks/useViewContext.js");
/* harmony import */ var _TourTooltips__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./TourTooltips */ "./js/components/TourTooltips.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Feature Tours component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */





function FeatureTours() {
  const viewContext = (0,_js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_2__["default"])();
  const {
    triggerTourForView
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useDispatch)(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_1__.CORE_USER);
  (0,react_use__WEBPACK_IMPORTED_MODULE_5__["default"])(() => {
    triggerTourForView(viewContext);
  });
  const tour = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useSelect)(select => select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_1__.CORE_USER).getCurrentTour());
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.useEffect)(() => {
    if (!tour) {
      // Return noop cleanup function to satisfy consistent-return rule.
      return () => {};
    }
    const dashboardElement = document.getElementById('js-googlesitekit-main-dashboard');
    if (!dashboardElement) {
      // Return noop cleanup function to satisfy consistent-return rule.
      return () => {};
    }
    const observer = new ResizeObserver(() => {
      __webpack_require__.g.dispatchEvent(new Event('resize'));
    });
    observer.observe(dashboardElement);
    return () => {
      observer.disconnect();
    };
  }, [tour]);
  if (!tour) {
    return null;
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(_TourTooltips__WEBPACK_IMPORTED_MODULE_3__["default"], {
    tourID: tour.slug,
    steps: tour.steps,
    gaEventCategory: tour.gaEventCategory,
    callback: tour.callback
  });
}

/***/ }),

/***/ "./js/components/FeaturesProvider/FeaturesContext.js":
/*!***********************************************************!*\
  !*** ./js/components/FeaturesProvider/FeaturesContext.js ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _js_features__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @/js/features */ "./js/features/index.js");
/**
 * Feature Flags context for React components.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */

const FeaturesContext = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createContext)(_js_features__WEBPACK_IMPORTED_MODULE_0__.enabledFeatures);
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (FeaturesContext);

/***/ }),

/***/ "./js/components/FeaturesProvider/index.js":
/*!*************************************************!*\
  !*** ./js/components/FeaturesProvider/index.js ***!
  \*************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Consumer: () => (/* binding */ Consumer),
/* harmony export */   Provider: () => (/* binding */ Provider),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _FeaturesContext__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./FeaturesContext */ "./js/components/FeaturesProvider/FeaturesContext.js");
/**
 * Feature Flags Provider component.
 *
 * Site Kit by Google, Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Internal dependencies
 */

const {
  Consumer,
  Provider
} = _FeaturesContext__WEBPACK_IMPORTED_MODULE_0__["default"];
const FeaturesProvider = Provider;
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (FeaturesProvider);

/***/ }),

/***/ "./js/components/GenericErrorHandlerActions.js":
/*!*****************************************************!*\
  !*** ./js/components/GenericErrorHandlerActions.js ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ GenericErrorHandlerActions)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Link__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Link */ "./js/components/Link.js");
/* harmony import */ var _ReportErrorButton__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./ReportErrorButton */ "./js/components/ReportErrorButton/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * GenericErrorHandlerActions component.
 *
 * Site Kit by Google, Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */



function GenericErrorHandlerActions({
  message,
  componentStack
}) {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
    className: "googlesitekit-generic-error-handler-actions",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_ReportErrorButton__WEBPACK_IMPORTED_MODULE_2__["default"], {
      message: message,
      componentStack: componentStack
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_Link__WEBPACK_IMPORTED_MODULE_1__["default"], {
      href: "https://wordpress.org/support/plugin/google-site-kit/",
      external: true,
      children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Report this problem', 'google-site-kit')
    })]
  });
}
GenericErrorHandlerActions.propTypes = {
  message: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().string),
  componentStack: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().string)
};

/***/ }),

/***/ "./js/components/Header.js":
/*!*********************************!*\
  !*** ./js/components/Header.js ***!
  \*********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_21___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_21__);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react_use_observer__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! react-use-observer */ "../node_modules/react-use-observer/es/useMutationObserver.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _Logo__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./Logo */ "./js/components/Logo.js");
/* harmony import */ var _UserMenu__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./UserMenu */ "./js/components/UserMenu/index.js");
/* harmony import */ var _js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/googlesitekit/datastore/user/constants */ "./js/googlesitekit/datastore/user/constants.js");
/* harmony import */ var _js_material_components__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @/js/material-components */ "./js/material-components/index.js");
/* harmony import */ var _DashboardNavigation__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./DashboardNavigation */ "./js/components/DashboardNavigation/index.js");
/* harmony import */ var _EntityHeader__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./EntityHeader */ "./js/components/EntityHeader.js");
/* harmony import */ var _ViewOnlyMenu__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./ViewOnlyMenu */ "./js/components/ViewOnlyMenu/index.js");
/* harmony import */ var _js_hooks_useViewOnly__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @/js/hooks/useViewOnly */ "./js/hooks/useViewOnly.js");
/* harmony import */ var _js_hooks_useDashboardType__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @/js/hooks/useDashboardType */ "./js/hooks/useDashboardType.js");
/* harmony import */ var _Link__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ./Link */ "./js/components/Link.js");
/* harmony import */ var _notifications_LegacyNotifications__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ./notifications/LegacyNotifications */ "./js/components/notifications/LegacyNotifications.js");
/* harmony import */ var _notifications_Notifications__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ./notifications/Notifications */ "./js/components/notifications/Notifications.js");
/* harmony import */ var _js_googlesitekit_notifications_constants__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! @/js/googlesitekit/notifications/constants */ "./js/googlesitekit/notifications/constants.js");
/* harmony import */ var _js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! @/js/googlesitekit/datastore/site/constants */ "./js/googlesitekit/datastore/site/constants.js");
/* harmony import */ var _js_hooks_useGlobalTrackingEffect__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! @/js/hooks/useGlobalTrackingEffect */ "./js/hooks/useGlobalTrackingEffect.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Header component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */




/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */

















function Header({
  children,
  subHeader,
  showNavigation
}) {
  const isDashboard = !!(0,_js_hooks_useDashboardType__WEBPACK_IMPORTED_MODULE_11__["default"])();
  const isViewOnly = (0,_js_hooks_useViewOnly__WEBPACK_IMPORTED_MODULE_10__["default"])();
  (0,_js_hooks_useGlobalTrackingEffect__WEBPACK_IMPORTED_MODULE_17__.useGlobalTrackingEffect)();
  const dashboardURL = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.useSelect)(select => select(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_16__.CORE_SITE).getAdminURL('googlesitekit-dashboard'));
  const isAuthenticated = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.useSelect)(select => select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_5__.CORE_USER).isAuthenticated());
  const [subHeaderRef, subHeaderMutation] = (0,react_use_observer__WEBPACK_IMPORTED_MODULE_19__["default"])({
    childList: true
  });
  const hasSubheader = !!subHeaderMutation.target?.childElementCount;
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsxs)(_wordpress_element__WEBPACK_IMPORTED_MODULE_20__.Fragment, {
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx)("header", {
      className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-header', {
        'googlesitekit-header--has-subheader': hasSubheader,
        'googlesitekit-header--has-navigation': showNavigation
      }),
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx)(_js_material_components__WEBPACK_IMPORTED_MODULE_6__.Grid, {
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsxs)(_js_material_components__WEBPACK_IMPORTED_MODULE_6__.Row, {
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx)(_js_material_components__WEBPACK_IMPORTED_MODULE_6__.Cell, {
            smSize: 1,
            mdSize: 2,
            lgSize: 4,
            className: "googlesitekit-header__logo",
            alignMiddle: true,
            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx)(_Link__WEBPACK_IMPORTED_MODULE_12__["default"], {
              "aria-label": (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Go to dashboard', 'google-site-kit'),
              className: "googlesitekit-header__logo-link",
              href: dashboardURL,
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx)(_Logo__WEBPACK_IMPORTED_MODULE_3__["default"], {})
            })
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsxs)(_js_material_components__WEBPACK_IMPORTED_MODULE_6__.Cell, {
            smSize: 3,
            mdSize: 6,
            lgSize: 8,
            className: "googlesitekit-header__children",
            alignMiddle: true,
            children: [children, !isAuthenticated && isDashboard && isViewOnly && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx)(_ViewOnlyMenu__WEBPACK_IMPORTED_MODULE_9__["default"], {}), isAuthenticated && !isViewOnly && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx)(_UserMenu__WEBPACK_IMPORTED_MODULE_4__["default"], {})]
          })]
        })
      })
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx)("div", {
      className: "googlesitekit-subheader",
      ref: subHeaderRef,
      children: subHeader
    }), showNavigation && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx)(_DashboardNavigation__WEBPACK_IMPORTED_MODULE_7__["default"], {}), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx)(_EntityHeader__WEBPACK_IMPORTED_MODULE_8__["default"], {}), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx)(_notifications_LegacyNotifications__WEBPACK_IMPORTED_MODULE_13__["default"], {}), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx)(_notifications_Notifications__WEBPACK_IMPORTED_MODULE_14__["default"], {
      areaSlug: _js_googlesitekit_notifications_constants__WEBPACK_IMPORTED_MODULE_15__.NOTIFICATION_AREAS.HEADER
    })]
  });
}
Header.displayName = 'Header';
Header.propTypes = {
  children: (prop_types__WEBPACK_IMPORTED_MODULE_21___default().node),
  subHeader: (prop_types__WEBPACK_IMPORTED_MODULE_21___default().element),
  showNavigation: (prop_types__WEBPACK_IMPORTED_MODULE_21___default().bool)
};
Header.defaultProps = {
  children: null,
  subHeader: null
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Header);

/***/ }),

/***/ "./js/components/IconWrapper.js":
/*!**************************************!*\
  !*** ./js/components/IconWrapper.js ***!
  \**************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ IconWrapper)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * IconWrapper component.
 *
 * Site Kit by Google, Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


function IconWrapper({
  children,
  marginLeft,
  marginRight
}) {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("span", {
    className: "googlesitekit-icon-wrapper",
    style: {
      marginLeft,
      marginRight
    },
    children: children
  });
}
IconWrapper.propTypes = {
  children: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().node).isRequired,
  marginLeft: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().number),
  marginRight: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().number)
};

/***/ }),

/***/ "./js/components/InViewProvider/InViewContext.js":
/*!*******************************************************!*\
  !*** ./js/components/InViewProvider/InViewContext.js ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/**
 * InView context for React components.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */

const InViewContext = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createContext)(false);
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (InViewContext);

/***/ }),

/***/ "./js/components/InViewProvider/index.js":
/*!***********************************************!*\
  !*** ./js/components/InViewProvider/index.js ***!
  \***********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Consumer: () => (/* binding */ Consumer),
/* harmony export */   Provider: () => (/* binding */ Provider),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _InViewContext__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./InViewContext */ "./js/components/InViewProvider/InViewContext.js");
/**
 * In-view Provider component.
 *
 * Site Kit by Google, Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Internal dependencies
 */

const {
  Consumer,
  Provider
} = _InViewContext__WEBPACK_IMPORTED_MODULE_0__["default"];
const InViewProvider = Provider;
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (InViewProvider);

/***/ }),

/***/ "./js/components/InfoTooltip.js":
/*!**************************************!*\
  !*** ./js/components/InfoTooltip.js ***!
  \**************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ InfoTooltip)
/* harmony export */ });
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-components */ "googlesitekit-components");
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _svg_icons_info_green_svg__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/svg/icons/info-green.svg */ "./svg/icons/info-green.svg");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * InfoTooltip component.
 *
 * Site Kit by Google, Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * Internal dependencies
 */



function InfoTooltip({
  onOpen,
  title,
  tooltipClassName
}) {
  if (!title) {
    return null;
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__.Tooltip, {
    className: "googlesitekit-info-tooltip",
    tooltipClassName: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-info-tooltip__content', tooltipClassName),
    title: title,
    placement: "top",
    enterTouchDelay: 0,
    leaveTouchDelay: 5000,
    onOpen: onOpen,
    interactive: true,
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("span", {
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_svg_icons_info_green_svg__WEBPACK_IMPORTED_MODULE_2__["default"], {
        width: "16",
        height: "16"
      })
    })
  });
}
InfoTooltip.propTypes = {
  onOpen: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().func),
  title: prop_types__WEBPACK_IMPORTED_MODULE_4___default().oneOfType([(prop_types__WEBPACK_IMPORTED_MODULE_4___default().string), (prop_types__WEBPACK_IMPORTED_MODULE_4___default().element)]),
  tooltipClassName: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().string)
};

/***/ }),

/***/ "./js/components/JoyrideTooltip.js":
/*!*****************************************!*\
  !*** ./js/components/JoyrideTooltip.js ***!
  \*****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ JoyrideTooltip)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var react_joyride__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! react-joyride */ "../node_modules/react-joyride/dist/index.mjs");
/* harmony import */ var react_use__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! react-use */ "../node_modules/react-use/esm/useInterval.js");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _TourTooltip__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./TourTooltip */ "./js/components/TourTooltip.js");
/* harmony import */ var _Portal__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Portal */ "./js/components/Portal.js");
/* harmony import */ var _TourTooltips__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./TourTooltips */ "./js/components/TourTooltips.js");
/* harmony import */ var _js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/hooks/useBreakpoint */ "./js/hooks/useBreakpoint.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * JoyRideTooltip component.
 *
 * Site Kit by Google, Copyright 2022 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */




/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */





function JoyrideTooltip(props) {
  const {
    title,
    content,
    dismissLabel,
    disableOverlay = true,
    target,
    cta = false,
    className,
    styles = {},
    slug = '',
    placement = 'auto',
    onDismiss = () => {},
    onView = () => {},
    onTourStart = () => {},
    onTourEnd = () => {}
  } = props;
  function checkIfTargetExists() {
    return !!__webpack_require__.g.document.querySelector(target);
  }
  const [targetExists, setTargetExists] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_5__.useState)(checkIfTargetExists);
  const breakpoint = (0,_js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_3__.useBreakpoint)();
  const isMobileTablet = breakpoint === _js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_3__.BREAKPOINT_SMALL || breakpoint === _js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_3__.BREAKPOINT_TABLET;
  const [shouldRun, setShouldRun] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_5__.useState)(true);
  const previousIsMobileTabletRef = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_5__.useRef)(isMobileTablet);
  (0,react_use__WEBPACK_IMPORTED_MODULE_6__["default"])(() => {
    if (checkIfTargetExists()) {
      setTargetExists(true);
    }
  },
  // An delay of null will stop the interval.
  targetExists ? null : 250);
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_5__.useEffect)(() => {
    // eslint-disable-next-line sitekit/function-declaration-consistency
    let disconnect = () => {};
    if (typeof __webpack_require__.g.ResizeObserver === 'function') {
      const targetElement = __webpack_require__.g.document.querySelector(target);
      if (targetElement) {
        const resizeObserver = new ResizeObserver(() => {
          // Dispatch a window resize event to trigger the tooltip to reposition.
          __webpack_require__.g.dispatchEvent(new Event('resize'));
        });
        resizeObserver.observe(targetElement);
        disconnect = () => resizeObserver.disconnect();
      }
    }
    return disconnect;
  }, [target, targetExists]);

  // Reset the component between mobile and desktop layouts they use different
  // targets which requires the tooltip to be re-rendered to display correctly.
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_5__.useEffect)(() => {
    let timeoutID;
    if (previousIsMobileTabletRef.current !== isMobileTablet) {
      setShouldRun(false);
      timeoutID = setTimeout(() => {
        setShouldRun(true);
      }, 50);
      previousIsMobileTabletRef.current = isMobileTablet;
    }
    return () => {
      if (timeoutID) {
        clearTimeout(timeoutID);
      }
    };
  }, [isMobileTablet]);

  // Joyride expects the step's target to be in the DOM immediately
  // so we need to wait for it in some cases, e.g. loading data.
  if (!targetExists) {
    return null;
  }
  const steps = [{
    title,
    target,
    content,
    disableBeacon: true,
    isFixed: true,
    placement,
    cta,
    className
  }];

  // Provides button content as well as aria-label & title attribute values.
  const joyrideLocale = {
    close: dismissLabel,
    last: dismissLabel
  };
  function callback({
    type
  }) {
    switch (type) {
      case react_joyride__WEBPACK_IMPORTED_MODULE_7__.EVENTS.TOUR_START:
        onTourStart();
        __webpack_require__.g.document.body.classList.add('googlesitekit-showing-tooltip');
        break;
      case react_joyride__WEBPACK_IMPORTED_MODULE_7__.EVENTS.TOUR_END:
        onTourEnd();
        __webpack_require__.g.document.body.classList.remove('googlesitekit-showing-tooltip');
        break;
      case react_joyride__WEBPACK_IMPORTED_MODULE_7__.EVENTS.STEP_AFTER:
        // This is not strictly necessary as the tooltip will hide without it,
        // but this allows the consumer of the component to clean up
        // post-dismiss.
        onDismiss();
        break;
      case react_joyride__WEBPACK_IMPORTED_MODULE_7__.EVENTS.TOOLTIP:
        onView();
        break;
    }
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(_Portal__WEBPACK_IMPORTED_MODULE_1__["default"], {
    slug: slug,
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(react_joyride__WEBPACK_IMPORTED_MODULE_7__["default"], {
      callback: callback,
      disableOverlay: disableOverlay,
      spotlightPadding: 0,
      floaterProps: _TourTooltips__WEBPACK_IMPORTED_MODULE_2__.floaterProps,
      locale: joyrideLocale,
      steps: steps,
      styles: {
        ..._TourTooltips__WEBPACK_IMPORTED_MODULE_2__.joyrideStyles,
        ...styles,
        options: {
          ..._TourTooltips__WEBPACK_IMPORTED_MODULE_2__.joyrideStyles.options,
          ...styles?.options
        },
        spotlight: {
          ..._TourTooltips__WEBPACK_IMPORTED_MODULE_2__.joyrideStyles.spotlight,
          ...styles?.spotlight
        }
      },
      tooltipComponent: _TourTooltip__WEBPACK_IMPORTED_MODULE_0__["default"],
      run: shouldRun,
      disableScrolling: true
    })
  });
}
JoyrideTooltip.propTypes = {
  title: prop_types__WEBPACK_IMPORTED_MODULE_8__.PropTypes.node,
  content: prop_types__WEBPACK_IMPORTED_MODULE_8__.PropTypes.string,
  disableOverlay: prop_types__WEBPACK_IMPORTED_MODULE_8__.PropTypes.bool,
  dismissLabel: prop_types__WEBPACK_IMPORTED_MODULE_8__.PropTypes.string,
  target: prop_types__WEBPACK_IMPORTED_MODULE_8__.PropTypes.string.isRequired,
  onDismiss: prop_types__WEBPACK_IMPORTED_MODULE_8__.PropTypes.func,
  onShow: prop_types__WEBPACK_IMPORTED_MODULE_8__.PropTypes.func,
  className: prop_types__WEBPACK_IMPORTED_MODULE_8__.PropTypes.string,
  styles: prop_types__WEBPACK_IMPORTED_MODULE_8__.PropTypes.object,
  slug: prop_types__WEBPACK_IMPORTED_MODULE_8__.PropTypes.string,
  placement: prop_types__WEBPACK_IMPORTED_MODULE_8__.PropTypes.string,
  onView: prop_types__WEBPACK_IMPORTED_MODULE_8__.PropTypes.func
};

/***/ }),

/***/ "./js/components/KeyMetrics/ConfirmSitePurposeChangeModal.js":
/*!*******************************************************************!*\
  !*** ./js/components/KeyMetrics/ConfirmSitePurposeChangeModal.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_19___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_19__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _wordpress_compose__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! @wordpress/compose */ "../node_modules/@wordpress/compose/build-module/hooks/use-previous/index.js");
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-components */ "googlesitekit-components");
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/googlesitekit/datastore/user/constants */ "./js/googlesitekit/datastore/user/constants.js");
/* harmony import */ var _js_googlesitekit_datastore_forms_constants__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/googlesitekit/datastore/forms/constants */ "./js/googlesitekit/datastore/forms/constants.js");
/* harmony import */ var _key_metrics_widgets__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./key-metrics-widgets */ "./js/components/KeyMetrics/key-metrics-widgets.js");
/* harmony import */ var _js_components_user_input_util_constants__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @/js/components/user-input/util/constants */ "./js/components/user-input/util/constants.js");
/* harmony import */ var _js_googlesitekit_datastore_ui_constants__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @/js/googlesitekit/datastore/ui/constants */ "./js/googlesitekit/datastore/ui/constants.js");
/* harmony import */ var _js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @/js/modules/analytics-4/datastore/constants */ "./js/modules/analytics-4/datastore/constants.js");
/* harmony import */ var _js_modules_analytics_4_constants__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @/js/modules/analytics-4/constants */ "./js/modules/analytics-4/constants.js");
/* harmony import */ var _js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @/js/googlesitekit/modules/datastore/constants */ "./js/googlesitekit/modules/datastore/constants.js");
/* harmony import */ var _js_util__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @/js/util */ "./js/util/index.js");
/* harmony import */ var _js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! @/js/hooks/useViewContext */ "./js/hooks/useViewContext.js");
/* harmony import */ var _js_components_Typography__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! @/js/components/Typography */ "./js/components/Typography/index.js");
/* harmony import */ var _js_hooks_useFormValue__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! @/js/hooks/useFormValue */ "./js/hooks/useFormValue.js");
/* harmony import */ var _js_components_Typography_P__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! @/js/components/Typography/P */ "./js/components/Typography/P.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * ConfirmSitePurposeChangeModal component.
 *
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */




/**
 * Internal dependencies
 */
















function ConfirmSitePurposeChangeModal({
  dialogActive = false,
  handleDialog = null
}) {
  const viewContext = (0,_js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_12__["default"])();
  const [isSaving, setIsSaving] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_17__.useState)(false);
  const [currentMetricsSnapshot, setCurrentMetricsSnapshot] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_17__.useState)(null);
  const includeConversionTailoredMetrics = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.useSelect)(select => select(_js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_8__.MODULES_ANALYTICS_4).shouldIncludeConversionTailoredMetrics());
  const newMetrics = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.useSelect)(select => select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_USER).getAnswerBasedMetrics(null, includeConversionTailoredMetrics));
  const savedPurposeSnapshot = (0,_js_hooks_useFormValue__WEBPACK_IMPORTED_MODULE_14__["default"])(_js_components_user_input_util_constants__WEBPACK_IMPORTED_MODULE_6__.FORM_USER_INPUT_QUESTION_SNAPSHOT, _js_components_user_input_util_constants__WEBPACK_IMPORTED_MODULE_6__.USER_INPUT_QUESTIONS_PURPOSE);
  const savedPurpose = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.useSelect)(select => select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_USER).getSavedUserInputSettings());
  const currentMetrics = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.useSelect)(select => {
    if (!savedPurpose?.purpose?.values?.length) {
      return [];
    }
    if (savedPurpose?.purpose?.values?.[0] === 'other') {
      return select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_USER).getKeyMetrics();
    }
    return select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_USER).getAnswerBasedMetrics(savedPurpose?.purpose?.values?.[0]);
  });
  const {
    setValues
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.useDispatch)(_js_googlesitekit_datastore_forms_constants__WEBPACK_IMPORTED_MODULE_4__.CORE_FORMS);
  const {
    setValues: setUIValues
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.useDispatch)(_js_googlesitekit_datastore_ui_constants__WEBPACK_IMPORTED_MODULE_7__.CORE_UI);
  const {
    resetUserInputSettings
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.useDispatch)(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_USER);
  const onClose = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_17__.useCallback)(async () => {
    if (savedPurposeSnapshot?.length) {
      await resetUserInputSettings();
      setValues(_js_components_user_input_util_constants__WEBPACK_IMPORTED_MODULE_6__.FORM_USER_INPUT_QUESTION_SNAPSHOT, {
        [_js_components_user_input_util_constants__WEBPACK_IMPORTED_MODULE_6__.USER_INPUT_QUESTIONS_PURPOSE]: undefined
      });
    }
    setUIValues({
      [_js_components_user_input_util_constants__WEBPACK_IMPORTED_MODULE_6__.USER_INPUT_CURRENTLY_EDITING_KEY]: undefined
    });
    handleDialog();
    setIsSaving(false);
  }, [handleDialog, savedPurposeSnapshot, resetUserInputSettings, setValues, setUIValues]);
  const userInputPurposeConversionEvents = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.useSelect)(select => {
    const isGA4Connected = select(_js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_10__.CORE_MODULES).isModuleConnected(_js_modules_analytics_4_constants__WEBPACK_IMPORTED_MODULE_9__.MODULE_SLUG_ANALYTICS_4);
    if (!isGA4Connected) {
      return [];
    }
    return select(_js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_8__.MODULES_ANALYTICS_4).getUserInputPurposeConversionEvents();
  });
  const {
    setUserInputSetting,
    saveUserInputSettings
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.useDispatch)(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_USER);
  const saveChanges = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_17__.useCallback)(async () => {
    setIsSaving(true);
    // Update 'includeConversionEvents' setting with included conversion events,
    // to mark that their respective metrics should be included in the
    // list of tailored metrics and persist on the dashboard in case events are lost.
    setUserInputSetting('includeConversionEvents', userInputPurposeConversionEvents);
    await saveUserInputSettings();
    onClose();
  }, [saveUserInputSettings, onClose, setIsSaving, setUserInputSetting, userInputPurposeConversionEvents]);
  const prevDialogActive = (0,_wordpress_compose__WEBPACK_IMPORTED_MODULE_18__["default"])(dialogActive);
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_17__.useEffect)(() => {
    if (prevDialogActive === true && dialogActive === false) {
      if (isSaving) {
        // Handle internal tracking when confirmation CTA is clicked.
        (0,_js_util__WEBPACK_IMPORTED_MODULE_11__.trackEvent)(`${viewContext}_kmw-settings-tailored-metrics-suggestions`, 'confirm_update_metrics_selection', 'conversion_reporting');
      } else {
        // Handle internal tracking when keep existing metrics CTA is clicked
        // or the modal is closed via other means.
        (0,_js_util__WEBPACK_IMPORTED_MODULE_11__.trackEvent)(`${viewContext}_kmw-settings-tailored-metrics-suggestions`, 'cancel_update_metrics_selection', 'conversion_reporting');
      }
    }
  }, [prevDialogActive, dialogActive, isSaving, viewContext]);
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_17__.useEffect)(() => {
    // Preserve current metrics list in a snapshot, so after site purpose is updated in the modal
    // the previous list shown under current metrics is not changing last moment during update.
    if (savedPurpose?.purpose?.values?.[0] && currentMetricsSnapshot === null && currentMetrics !== undefined) {
      setCurrentMetricsSnapshot(currentMetrics);
    }
  }, [savedPurpose, currentMetricsSnapshot, currentMetrics, setCurrentMetricsSnapshot]);
  const previousIsSaving = (0,_wordpress_compose__WEBPACK_IMPORTED_MODULE_18__["default"])(isSaving);
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_17__.useEffect)(() => {
    if (previousIsSaving && !isSaving && !dialogActive && currentMetricsSnapshot !== null) {
      // Reset metrics snapshot once saving is done dialog is closed. Timeout is needed
      // to delay reset since modal has closing animation.
      setTimeout(() => {
        setCurrentMetricsSnapshot(null);
      }, 50);
    }
  }, [previousIsSaving, isSaving, dialogActive, currentMetricsSnapshot, setCurrentMetricsSnapshot]);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsxs)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__.Dialog, {
    open: dialogActive,
    "aria-describedby": undefined,
    tabIndex: "-1",
    className: "googlesitekit-dialog-confirm-site-purpose-change",
    onClose: onClose,
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__.DialogTitle, {
      children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Tailored metrics suggestions', 'google-site-kit')
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsxs)(_js_components_Typography_P__WEBPACK_IMPORTED_MODULE_15__["default"], {
      children: [(0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('You have changed your website purpose. We can suggest new tailored metrics for you based on your answers or you can keep your current metrics selection on your dashboard.', 'google-site-kit'), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx)("br", {}), (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('You can always edit your metrics selection from the dashboard.', 'google-site-kit')]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__.DialogContent, {
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsxs)("div", {
        className: "mdc-layout-grid__inner",
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsxs)("div", {
          className: "mdc-layout-grid__cell mdc-layout-grid__cell--span-6-desktop mdc-layout-grid__cell--span-4-tablet mdc-layout-grid__cell--span-4-phone",
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx)(_js_components_Typography__WEBPACK_IMPORTED_MODULE_13__["default"], {
            as: "h3",
            size: "small",
            type: "headline",
            children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Current metrics', 'google-site-kit')
          }), !!currentMetricsSnapshot && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx)("ul", {
            className: "mdc-list mdc-list--underlined mdc-list--non-interactive",
            children: currentMetricsSnapshot.map(item => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx)("li", {
              className: "mdc-list-item",
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx)("span", {
                className: "mdc-list-item__text",
                children: _key_metrics_widgets__WEBPACK_IMPORTED_MODULE_5__.KEY_METRICS_WIDGETS[item]?.title
              })
            }, item))
          })]
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsxs)("div", {
          className: "mdc-layout-grid__cell mdc-layout-grid__cell--span-6-desktop mdc-layout-grid__cell--span-4-tablet mdc-layout-grid__cell--span-4-phone",
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx)(_js_components_Typography__WEBPACK_IMPORTED_MODULE_13__["default"], {
            as: "h3",
            size: "small",
            type: "headline",
            children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('New tailored metrics', 'google-site-kit')
          }), !!newMetrics && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx)("ul", {
            className: "mdc-list mdc-list--underlined mdc-list--non-interactive",
            children: newMetrics.map(item => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx)("li", {
              className: "mdc-list-item",
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx)("span", {
                className: "mdc-list-item__text",
                children: _key_metrics_widgets__WEBPACK_IMPORTED_MODULE_5__.KEY_METRICS_WIDGETS[item]?.title
              })
            }, item))
          })]
        })]
      })
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsxs)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__.DialogFooter, {
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__.Button, {
        className: "mdc-dialog__cancel-button",
        onClick: onClose,
        tertiary: true,
        children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Keep current selection', 'google-site-kit')
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__.SpinnerButton, {
        isSaving: isSaving,
        onClick: saveChanges,
        children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Update metrics selection', 'google-site-kit')
      })]
    })]
  });
}
ConfirmSitePurposeChangeModal.propTypes = {
  dialogActive: (prop_types__WEBPACK_IMPORTED_MODULE_19___default().bool),
  handleDialog: (prop_types__WEBPACK_IMPORTED_MODULE_19___default().func)
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ConfirmSitePurposeChangeModal);

/***/ }),

/***/ "./js/components/KeyMetrics/ConversionReportingSettingsSubtleNotification.js":
/*!***********************************************************************************!*\
  !*** ./js/components/KeyMetrics/ConversionReportingSettingsSubtleNotification.js ***!
  \***********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ ConversionReportingSettingsSubtleNotification)
/* harmony export */ });
/* harmony import */ var react_use__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! react-use */ "../node_modules/react-use/esm/useIntersection.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/googlesitekit/datastore/site/constants */ "./js/googlesitekit/datastore/site/constants.js");
/* harmony import */ var _js_util__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/util */ "./js/util/index.js");
/* harmony import */ var _js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/hooks/useViewContext */ "./js/hooks/useViewContext.js");
/* harmony import */ var _js_components_Notice__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/components/Notice */ "./js/components/Notice/index.js");
/* harmony import */ var _js_material_components__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @/js/material-components */ "./js/material-components/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * ConversionReportingSettingsSubtleNotification component.
 *
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */







function ConversionReportingSettingsSubtleNotification() {
  const viewContext = (0,_js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_4__["default"])();
  const [isNavigating, setIsNavigating] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_8__.useState)(false);
  const [isViewed, setIsViewed] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_8__.useState)(false);
  const notificationRef = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_8__.useRef)();
  const intersectionEntry = (0,react_use__WEBPACK_IMPORTED_MODULE_9__["default"])(notificationRef, {
    threshold: 0.25
  });
  const inView = !!intersectionEntry?.intersectionRatio;

  // Track when the notification is viewed.
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_8__.useEffect)(() => {
    if (!isViewed && inView) {
      // Handle internal tracking.
      (0,_js_util__WEBPACK_IMPORTED_MODULE_3__.trackEvent)(`${viewContext}_kmw-settings-change-from-manual-to-tailored`, 'view_notification', 'conversion_reporting');
      setIsViewed(true);
    }
  }, [isViewed, inView, viewContext]);
  const userInputURL = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_2__.CORE_SITE).getAdminURL('googlesitekit-user-input'));
  const handleCTAClick = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_8__.useCallback)(() => {
    setIsNavigating(true);

    // Handle internal tracking.
    (0,_js_util__WEBPACK_IMPORTED_MODULE_3__.trackEvent)(`${viewContext}_kmw-settings-change-from-manual-to-tailored`, 'confirm_get_tailored_metrics', 'conversion_reporting');
  }, [setIsNavigating, viewContext]);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_js_material_components__WEBPACK_IMPORTED_MODULE_6__.Grid, {
    ref: notificationRef,
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_js_material_components__WEBPACK_IMPORTED_MODULE_6__.Row, {
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_js_material_components__WEBPACK_IMPORTED_MODULE_6__.Cell, {
        size: 12,
        alignMiddle: true,
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_js_components_Notice__WEBPACK_IMPORTED_MODULE_5__["default"], {
          type: "new",
          title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Personalize your metrics', 'google-site-kit'),
          description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Set up your goals by answering 3 quick questions to help us show the most relevant data for your site', 'google-site-kit'),
          ctaButton: {
            label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Get tailored metrics', 'google-site-kit'),
            onClick: handleCTAClick,
            inProgress: isNavigating,
            disabled: isNavigating,
            href: userInputURL
          }
        })
      })
    })
  });
}

/***/ }),

/***/ "./js/components/KeyMetrics/constants.js":
/*!***********************************************!*\
  !*** ./js/components/KeyMetrics/constants.js ***!
  \***********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   EFFECTIVE_SELECTION: () => (/* binding */ EFFECTIVE_SELECTION),
/* harmony export */   KEY_METRICS_GROUP_CONTENT_PERFORMANCE: () => (/* binding */ KEY_METRICS_GROUP_CONTENT_PERFORMANCE),
/* harmony export */   KEY_METRICS_GROUP_CURRENT: () => (/* binding */ KEY_METRICS_GROUP_CURRENT),
/* harmony export */   KEY_METRICS_GROUP_DRIVING_TRAFFIC: () => (/* binding */ KEY_METRICS_GROUP_DRIVING_TRAFFIC),
/* harmony export */   KEY_METRICS_GROUP_GENERATING_LEADS: () => (/* binding */ KEY_METRICS_GROUP_GENERATING_LEADS),
/* harmony export */   KEY_METRICS_GROUP_SELLING_PRODUCTS: () => (/* binding */ KEY_METRICS_GROUP_SELLING_PRODUCTS),
/* harmony export */   KEY_METRICS_GROUP_SUGGESTED: () => (/* binding */ KEY_METRICS_GROUP_SUGGESTED),
/* harmony export */   KEY_METRICS_GROUP_VISITORS: () => (/* binding */ KEY_METRICS_GROUP_VISITORS),
/* harmony export */   KEY_METRICS_SELECTED: () => (/* binding */ KEY_METRICS_SELECTED),
/* harmony export */   KEY_METRICS_SELECTION_FORM: () => (/* binding */ KEY_METRICS_SELECTION_FORM),
/* harmony export */   KEY_METRICS_SELECTION_PANEL_OPENED_KEY: () => (/* binding */ KEY_METRICS_SELECTION_PANEL_OPENED_KEY),
/* harmony export */   KEY_METRICS_SETUP_CTA_WIDGET_SLUG: () => (/* binding */ KEY_METRICS_SETUP_CTA_WIDGET_SLUG),
/* harmony export */   MAX_SELECTED_METRICS_COUNT: () => (/* binding */ MAX_SELECTED_METRICS_COUNT),
/* harmony export */   MIN_SELECTED_METRICS_COUNT: () => (/* binding */ MIN_SELECTED_METRICS_COUNT),
/* harmony export */   UNSTAGED_SELECTION: () => (/* binding */ UNSTAGED_SELECTION)
/* harmony export */ });
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/**
 * Key Metrics components - constants.
 *
 * Site Kit by Google, Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */

const KEY_METRICS_SETUP_CTA_WIDGET_SLUG = 'key-metrics-setup-cta-widget';
const KEY_METRICS_SELECTION_PANEL_OPENED_KEY = 'googlesitekit-key-metrics-selection-panel-opened';
const KEY_METRICS_SELECTION_FORM = 'key-metrics-selection-form';
const KEY_METRICS_SELECTED = 'key-metrics-selected';
const EFFECTIVE_SELECTION = 'key-metrics-effective-selection';
const UNSTAGED_SELECTION = 'key-metrics-unstaged-selection';
const MIN_SELECTED_METRICS_COUNT = 2;
const MAX_SELECTED_METRICS_COUNT = 8;
const KEY_METRICS_GROUP_CURRENT = {
  SLUG: 'current-selection',
  LABEL: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Current selection', 'google-site-kit')
};
const KEY_METRICS_GROUP_SUGGESTED = {
  SLUG: 'suggested',
  LABEL: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Suggested', 'google-site-kit')
};
const KEY_METRICS_GROUP_VISITORS = {
  SLUG: 'visitors',
  LABEL: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Visitors', 'google-site-kit')
};
const KEY_METRICS_GROUP_DRIVING_TRAFFIC = {
  SLUG: 'driving-traffic',
  LABEL: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Driving traffic', 'google-site-kit')
};
const KEY_METRICS_GROUP_GENERATING_LEADS = {
  SLUG: 'generating-leads',
  LABEL: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Generating leads', 'google-site-kit')
};
const KEY_METRICS_GROUP_SELLING_PRODUCTS = {
  SLUG: 'selling-products',
  LABEL: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Selling products', 'google-site-kit')
};
const KEY_METRICS_GROUP_CONTENT_PERFORMANCE = {
  SLUG: 'content-performance',
  LABEL: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Content performance', 'google-site-kit')
};

/***/ }),

/***/ "./js/components/KeyMetrics/key-metrics-widgets.js":
/*!*********************************************************!*\
  !*** ./js/components/KeyMetrics/key-metrics-widgets.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   KEY_METRICS_WIDGETS: () => (/* binding */ KEY_METRICS_WIDGETS)
/* harmony export */ });
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/googlesitekit/datastore/user/constants */ "./js/googlesitekit/datastore/user/constants.js");
/* harmony import */ var _js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/googlesitekit/datastore/site/constants */ "./js/googlesitekit/datastore/site/constants.js");
/* harmony import */ var _js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/modules/analytics-4/datastore/constants */ "./js/modules/analytics-4/datastore/constants.js");
/* harmony import */ var _shouldDisplayWidgetWithConversionEvent__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./shouldDisplayWidgetWithConversionEvent */ "./js/components/KeyMetrics/shouldDisplayWidgetWithConversionEvent.js");
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./constants */ "./js/components/KeyMetrics/constants.js");
/**
 * Key Metrics widgets metadata.
 *
 * Site Kit by Google, Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */






/**
 * Determines whether to show a widget the requires Analytics 4 and AdSense to be linked.
 *
 * For admin dashboards, the widget will be shown if both modules are activate so that
 * the connection CTA can be shown if they have not been linked.
 *
 * For view-only dashboards, the widget will only be displayed if both modules are linked.
 *
 * @since 1.121.0
 *
 * @param {Object}   options                     Options object.
 * @param {Function} options.select              Data store select function.
 * @param {boolean}  options.isViewOnlyDashboard Whether the current dashboard is view only.
 * @return {boolean} Whether to display the widget.
 */
function shouldDisplayWidgetWithAnalytics4AndAdSenseLinked({
  select,
  isViewOnlyDashboard
}) {
  if (!isViewOnlyDashboard) {
    return true;
  }
  if (isViewOnlyDashboard && select(_js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_3__.MODULES_ANALYTICS_4).getAdSenseLinked()) {
    return true;
  }
  return false;
}

/**
 * Determines whether to display a widget that requires custom dimensions in the key
 * metrics selection panel.
 *
 * All widgets are displayed in authenticated dashboard. However, in view only dashboard,
 * widgets that require custom dimensions will only be displayed if the required custom
 * dimensions are available in the shared property.
 *
 * This function is attached to the widget object that requires the custom dimensions and
 * has the `requiredCustomDimensions` property.
 *
 * @since 1.113.0
 *
 * @param {Object}   options                     Options object.
 * @param {Function} options.select              Data store select function.
 * @param {boolean}  options.isViewOnlyDashboard Whether the current dashboard is view only.
 * @return {boolean} Whether to display the widget.
 */
function shouldDisplayWidgetWithCustomDimensions({
  select,
  isViewOnlyDashboard
}) {
  if (!isViewOnlyDashboard) {
    return true;
  }
  return select(_js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_3__.MODULES_ANALYTICS_4).hasCustomDimensions(
  // This property is available to the widget object that requires the
  // custom dimensions, where the function is attached.
  this.requiredCustomDimensions);
}
const KEY_METRICS_WIDGETS = {
  [_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_1__.KM_ANALYTICS_ADSENSE_TOP_EARNING_CONTENT]: {
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Top earning pages', 'google-site-kit'),
    description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Pages that generated the most AdSense revenue', 'google-site-kit'),
    infoTooltip: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Pages that generated the most AdSense revenue', 'google-site-kit'),
    displayInSelectionPanel: shouldDisplayWidgetWithAnalytics4AndAdSenseLinked,
    displayInList: shouldDisplayWidgetWithAnalytics4AndAdSenseLinked,
    metadata: {
      group: _constants__WEBPACK_IMPORTED_MODULE_5__.KEY_METRICS_GROUP_CONTENT_PERFORMANCE.SLUG
    }
  },
  [_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_1__.KM_ANALYTICS_TOP_RECENT_TRENDING_PAGES]: {
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Top recent trending pages', 'google-site-kit'),
    description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Pages with the most pageviews published in the last 3 days', 'google-site-kit'),
    infoTooltip: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Pages with the most pageviews published in the last 3 days', 'google-site-kit'),
    requiredCustomDimensions: ['googlesitekit_post_date'],
    displayInSelectionPanel: shouldDisplayWidgetWithCustomDimensions,
    displayInWidgetArea: shouldDisplayWidgetWithCustomDimensions,
    displayInList: shouldDisplayWidgetWithCustomDimensions,
    metadata: {
      group: _constants__WEBPACK_IMPORTED_MODULE_5__.KEY_METRICS_GROUP_CONTENT_PERFORMANCE.SLUG
    }
  },
  [_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_1__.KM_ANALYTICS_POPULAR_AUTHORS]: {
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Most popular authors by pageviews', 'google-site-kit'),
    description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Authors whose posts got the most visits', 'google-site-kit'),
    infoTooltip: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Authors whose posts got the most visits', 'google-site-kit'),
    requiredCustomDimensions: ['googlesitekit_post_author'],
    displayInSelectionPanel: shouldDisplayWidgetWithCustomDimensions,
    displayInWidgetArea: shouldDisplayWidgetWithCustomDimensions,
    displayInList: shouldDisplayWidgetWithCustomDimensions,
    metadata: {
      group: _constants__WEBPACK_IMPORTED_MODULE_5__.KEY_METRICS_GROUP_CONTENT_PERFORMANCE.SLUG
    }
  },
  [_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_1__.KM_ANALYTICS_TOP_CATEGORIES]: {
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Top categories by pageviews', 'google-site-kit'),
    description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Categories that your site visitors viewed the most', 'google-site-kit'),
    infoTooltip: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Categories that your site visitors viewed the most', 'google-site-kit'),
    requiredCustomDimensions: ['googlesitekit_post_categories'],
    displayInSelectionPanel: shouldDisplayWidgetWithCustomDimensions,
    displayInWidgetArea: shouldDisplayWidgetWithCustomDimensions,
    displayInList: shouldDisplayWidgetWithCustomDimensions,
    metadata: {
      group: _constants__WEBPACK_IMPORTED_MODULE_5__.KEY_METRICS_GROUP_CONTENT_PERFORMANCE.SLUG
    }
  },
  [_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_1__.KM_ANALYTICS_POPULAR_CONTENT]: {
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Most popular content by pageviews', 'google-site-kit'),
    description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Pages that brought in the most visitors', 'google-site-kit'),
    infoTooltip: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Pages your visitors read the most', 'google-site-kit'),
    metadata: {
      group: _constants__WEBPACK_IMPORTED_MODULE_5__.KEY_METRICS_GROUP_CONTENT_PERFORMANCE.SLUG
    }
  },
  [_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_1__.KM_ANALYTICS_POPULAR_PRODUCTS]: {
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Most popular products by pageviews', 'google-site-kit'),
    description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Products that brought in the most visitors', 'google-site-kit'),
    requiredCustomDimensions: ['googlesitekit_post_type'],
    displayInSelectionPanel: ({
      select
    }) => select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_1__.CORE_USER).isKeyMetricActive(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_1__.KM_ANALYTICS_POPULAR_PRODUCTS) || select(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_2__.CORE_SITE).getProductPostType(),
    displayInWidgetArea: shouldDisplayWidgetWithCustomDimensions,
    metadata: {
      group: _constants__WEBPACK_IMPORTED_MODULE_5__.KEY_METRICS_GROUP_SELLING_PRODUCTS.SLUG
    }
  },
  [_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_1__.KM_ANALYTICS_PAGES_PER_VISIT]: {
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Pages per visit', 'google-site-kit'),
    description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Number of pages visitors viewed per session on average', 'google-site-kit'),
    infoTooltip: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Number of pages visitors viewed per session on average', 'google-site-kit'),
    metadata: {
      group: _constants__WEBPACK_IMPORTED_MODULE_5__.KEY_METRICS_GROUP_VISITORS.SLUG
    }
  },
  [_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_1__.KM_ANALYTICS_VISIT_LENGTH]: {
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Visit length', 'google-site-kit'),
    description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Average duration of engaged visits', 'google-site-kit'),
    infoTooltip: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Average duration of engaged visits', 'google-site-kit'),
    metadata: {
      group: _constants__WEBPACK_IMPORTED_MODULE_5__.KEY_METRICS_GROUP_VISITORS.SLUG
    }
  },
  [_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_1__.KM_ANALYTICS_VISITS_PER_VISITOR]: {
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Visits per visitor', 'google-site-kit'),
    description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Average number of sessions per site visitor', 'google-site-kit'),
    infoTooltip: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Average number of sessions per site visitor', 'google-site-kit'),
    metadata: {
      group: _constants__WEBPACK_IMPORTED_MODULE_5__.KEY_METRICS_GROUP_VISITORS.SLUG
    }
  },
  [_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_1__.KM_ANALYTICS_MOST_ENGAGING_PAGES]: {
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Most engaging pages', 'google-site-kit'),
    description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Pages with the highest engagement rate', 'google-site-kit'),
    infoTooltip: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Pages with the highest engagement rate', 'google-site-kit'),
    metadata: {
      group: _constants__WEBPACK_IMPORTED_MODULE_5__.KEY_METRICS_GROUP_CONTENT_PERFORMANCE.SLUG
    }
  },
  [_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_1__.KM_ANALYTICS_LEAST_ENGAGING_PAGES]: {
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Least engaging pages', 'google-site-kit'),
    description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Pages with the highest percentage of visitors that left without engagement with your site', 'google-site-kit'),
    infoTooltip: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Percentage of visitors that left without engagement with your site', 'google-site-kit'),
    metadata: {
      group: _constants__WEBPACK_IMPORTED_MODULE_5__.KEY_METRICS_GROUP_CONTENT_PERFORMANCE.SLUG
    }
  },
  [_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_1__.KM_ANALYTICS_TOP_RETURNING_VISITOR_PAGES]: {
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Top pages by returning visitors', 'google-site-kit'),
    description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Pages that attracted the most returning visitors', 'google-site-kit'),
    infoTooltip: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Pages that attracted the most returning visitors', 'google-site-kit'),
    metadata: {
      group: _constants__WEBPACK_IMPORTED_MODULE_5__.KEY_METRICS_GROUP_VISITORS.SLUG
    }
  },
  [_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_1__.KM_ANALYTICS_NEW_VISITORS]: {
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('New visitors', 'google-site-kit'),
    description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('How many new visitors you got and how the overall audience changed', 'google-site-kit'),
    infoTooltip: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Portion of visitors who visited your site for the first time in this timeframe', 'google-site-kit'),
    metadata: {
      group: _constants__WEBPACK_IMPORTED_MODULE_5__.KEY_METRICS_GROUP_VISITORS.SLUG
    }
  },
  [_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_1__.KM_ANALYTICS_RETURNING_VISITORS]: {
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Returning visitors', 'google-site-kit'),
    description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Portion of people who visited your site more than once', 'google-site-kit'),
    infoTooltip: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Portion of your site’s visitors that returned at least once in this timeframe', 'google-site-kit'),
    metadata: {
      group: _constants__WEBPACK_IMPORTED_MODULE_5__.KEY_METRICS_GROUP_VISITORS.SLUG
    }
  },
  [_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_1__.KM_ANALYTICS_TOP_TRAFFIC_SOURCE]: {
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Top traffic source', 'google-site-kit'),
    description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Channel which brought in the most visitors to your site', 'google-site-kit'),
    infoTooltip: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Channel (e.g. social, paid, search) that brought in the most visitors to your site', 'google-site-kit'),
    metadata: {
      group: _constants__WEBPACK_IMPORTED_MODULE_5__.KEY_METRICS_GROUP_DRIVING_TRAFFIC.SLUG
    }
  },
  [_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_1__.KM_ANALYTICS_TOP_TRAFFIC_SOURCE_DRIVING_ADD_TO_CART]: {
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Top traffic source driving add to cart', 'google-site-kit'),
    description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Channel which brought in the most add to cart events to your site', 'google-site-kit'),
    infoTooltip: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Channel (e.g. social, paid, search) that brought in the most add to cart events to your site', 'google-site-kit'),
    requiredConversionEventName: [_js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_3__.ENUM_CONVERSION_EVENTS.ADD_TO_CART],
    displayInSelectionPanel: _shouldDisplayWidgetWithConversionEvent__WEBPACK_IMPORTED_MODULE_4__.shouldDisplayWidgetWithConversionEvent,
    displayInList: _shouldDisplayWidgetWithConversionEvent__WEBPACK_IMPORTED_MODULE_4__.shouldDisplayWidgetWithConversionEvent,
    metadata: {
      group: _constants__WEBPACK_IMPORTED_MODULE_5__.KEY_METRICS_GROUP_SELLING_PRODUCTS.SLUG
    }
  },
  [_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_1__.KM_ANALYTICS_TOP_TRAFFIC_SOURCE_DRIVING_LEADS]: {
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Top traffic source driving leads', 'google-site-kit'),
    description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Channel which brought in the most leads to your site', 'google-site-kit'),
    infoTooltip: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Channel (e.g. social, paid, search) that brought in the most leads to your site', 'google-site-kit'),
    requiredConversionEventName: [_js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_3__.ENUM_CONVERSION_EVENTS.SUBMIT_LEAD_FORM, _js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_3__.ENUM_CONVERSION_EVENTS.CONTACT, _js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_3__.ENUM_CONVERSION_EVENTS.GENERATE_LEAD],
    displayInSelectionPanel: _shouldDisplayWidgetWithConversionEvent__WEBPACK_IMPORTED_MODULE_4__.shouldDisplayWidgetWithConversionEvent,
    displayInList: _shouldDisplayWidgetWithConversionEvent__WEBPACK_IMPORTED_MODULE_4__.shouldDisplayWidgetWithConversionEvent,
    metadata: {
      group: _constants__WEBPACK_IMPORTED_MODULE_5__.KEY_METRICS_GROUP_GENERATING_LEADS.SLUG
    }
  },
  [_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_1__.KM_ANALYTICS_TOP_TRAFFIC_SOURCE_DRIVING_PURCHASES]: {
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Top traffic source driving purchases', 'google-site-kit'),
    description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Channel which brought in the most purchases to your site', 'google-site-kit'),
    infoTooltip: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Channel (e.g. social, paid, search) that brought in the most purchases to your site', 'google-site-kit'),
    requiredConversionEventName: [_js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_3__.ENUM_CONVERSION_EVENTS.PURCHASE],
    displayInSelectionPanel: _shouldDisplayWidgetWithConversionEvent__WEBPACK_IMPORTED_MODULE_4__.shouldDisplayWidgetWithConversionEvent,
    displayInList: _shouldDisplayWidgetWithConversionEvent__WEBPACK_IMPORTED_MODULE_4__.shouldDisplayWidgetWithConversionEvent,
    metadata: {
      group: _constants__WEBPACK_IMPORTED_MODULE_5__.KEY_METRICS_GROUP_SELLING_PRODUCTS.SLUG
    }
  },
  [_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_1__.KM_ANALYTICS_ENGAGED_TRAFFIC_SOURCE]: {
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Most engaged traffic source', 'google-site-kit'),
    description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Visitors coming via this channel spent the most time on your site', 'google-site-kit'),
    infoTooltip: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Channel (e.g. social, paid, search) that brought in the most visitors who had a meaningful engagement with your site', 'google-site-kit'),
    metadata: {
      group: _constants__WEBPACK_IMPORTED_MODULE_5__.KEY_METRICS_GROUP_DRIVING_TRAFFIC.SLUG
    }
  },
  [_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_1__.KM_ANALYTICS_TOP_CONVERTING_TRAFFIC_SOURCE]: {
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Top converting traffic source', 'google-site-kit'),
    description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Channel which brought in the most visits that resulted in key events', 'google-site-kit'),
    infoTooltip: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Channel (e.g. social, paid, search) that brought in visitors who generated the most key events', 'google-site-kit'),
    metadata: {
      group: _constants__WEBPACK_IMPORTED_MODULE_5__.KEY_METRICS_GROUP_DRIVING_TRAFFIC.SLUG
    }
  },
  [_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_1__.KM_ANALYTICS_TOP_CITIES]: {
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Top cities driving traffic', 'google-site-kit'),
    description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Which cities you get the most visitors from', 'google-site-kit'),
    infoTooltip: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('The cities where most of your visitors came from', 'google-site-kit'),
    metadata: {
      group: _constants__WEBPACK_IMPORTED_MODULE_5__.KEY_METRICS_GROUP_DRIVING_TRAFFIC.SLUG
    }
  },
  [_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_1__.KM_ANALYTICS_TOP_CITIES_DRIVING_LEADS]: {
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Top cities driving leads', 'google-site-kit'),
    description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Cities driving the most contact form submissions', 'google-site-kit'),
    infoTooltip: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Cities driving the most contact form submissions', 'google-site-kit'),
    requiredConversionEventName: [_js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_3__.ENUM_CONVERSION_EVENTS.SUBMIT_LEAD_FORM, _js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_3__.ENUM_CONVERSION_EVENTS.CONTACT, _js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_3__.ENUM_CONVERSION_EVENTS.GENERATE_LEAD],
    displayInSelectionPanel: _shouldDisplayWidgetWithConversionEvent__WEBPACK_IMPORTED_MODULE_4__.shouldDisplayWidgetWithConversionEvent,
    displayInList: _shouldDisplayWidgetWithConversionEvent__WEBPACK_IMPORTED_MODULE_4__.shouldDisplayWidgetWithConversionEvent,
    metadata: {
      group: _constants__WEBPACK_IMPORTED_MODULE_5__.KEY_METRICS_GROUP_GENERATING_LEADS.SLUG
    }
  },
  [_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_1__.KM_ANALYTICS_TOP_CITIES_DRIVING_ADD_TO_CART]: {
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Top cities driving add to cart', 'google-site-kit'),
    description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Cities where visitors most frequently add products to their carts', 'google-site-kit'),
    infoTooltip: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Cities where visitors most frequently add products to their carts', 'google-site-kit'),
    requiredConversionEventName: [_js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_3__.ENUM_CONVERSION_EVENTS.ADD_TO_CART],
    displayInSelectionPanel: _shouldDisplayWidgetWithConversionEvent__WEBPACK_IMPORTED_MODULE_4__.shouldDisplayWidgetWithConversionEvent,
    displayInList: _shouldDisplayWidgetWithConversionEvent__WEBPACK_IMPORTED_MODULE_4__.shouldDisplayWidgetWithConversionEvent,
    metadata: {
      group: _constants__WEBPACK_IMPORTED_MODULE_5__.KEY_METRICS_GROUP_SELLING_PRODUCTS.SLUG
    }
  },
  [_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_1__.KM_ANALYTICS_TOP_CITIES_DRIVING_PURCHASES]: {
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Top cities driving purchases', 'google-site-kit'),
    description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Cities driving the most purchases', 'google-site-kit'),
    infoTooltip: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Cities driving the most purchases', 'google-site-kit'),
    requiredConversionEventName: [_js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_3__.ENUM_CONVERSION_EVENTS.PURCHASE],
    displayInSelectionPanel: _shouldDisplayWidgetWithConversionEvent__WEBPACK_IMPORTED_MODULE_4__.shouldDisplayWidgetWithConversionEvent,
    displayInList: _shouldDisplayWidgetWithConversionEvent__WEBPACK_IMPORTED_MODULE_4__.shouldDisplayWidgetWithConversionEvent,
    metadata: {
      group: _constants__WEBPACK_IMPORTED_MODULE_5__.KEY_METRICS_GROUP_SELLING_PRODUCTS.SLUG
    }
  },
  [_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_1__.KM_ANALYTICS_TOP_DEVICE_DRIVING_PURCHASES]: {
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Top device driving purchases', 'google-site-kit'),
    description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Top device driving the most purchases', 'google-site-kit'),
    infoTooltip: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Top device driving the most purchases', 'google-site-kit'),
    requiredConversionEventName: [_js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_3__.ENUM_CONVERSION_EVENTS.PURCHASE],
    displayInSelectionPanel: _shouldDisplayWidgetWithConversionEvent__WEBPACK_IMPORTED_MODULE_4__.shouldDisplayWidgetWithConversionEvent,
    displayInList: _shouldDisplayWidgetWithConversionEvent__WEBPACK_IMPORTED_MODULE_4__.shouldDisplayWidgetWithConversionEvent,
    metadata: {
      group: _constants__WEBPACK_IMPORTED_MODULE_5__.KEY_METRICS_GROUP_SELLING_PRODUCTS.SLUG
    }
  },
  [_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_1__.KM_ANALYTICS_TOP_COUNTRIES]: {
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Top countries driving traffic', 'google-site-kit'),
    description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Which countries you get the most visitors from', 'google-site-kit'),
    infoTooltip: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('The countries where most of your visitors came from', 'google-site-kit'),
    metadata: {
      group: _constants__WEBPACK_IMPORTED_MODULE_5__.KEY_METRICS_GROUP_DRIVING_TRAFFIC.SLUG
    }
  },
  [_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_1__.KM_SEARCH_CONSOLE_POPULAR_KEYWORDS]: {
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Top performing keywords', 'google-site-kit'),
    description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('What people searched for before they came to your site', 'google-site-kit'),
    infoTooltip: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('The top search queries for your site by highest clickthrough rate', 'google-site-kit'),
    metadata: {
      group: _constants__WEBPACK_IMPORTED_MODULE_5__.KEY_METRICS_GROUP_DRIVING_TRAFFIC.SLUG
    }
  },
  [_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_1__.KM_ANALYTICS_TOP_PAGES_DRIVING_LEADS]: {
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Top pages driving leads', 'google-site-kit'),
    description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Pages on which forms are most frequently submitted', 'google-site-kit'),
    requiredConversionEventName: [_js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_3__.ENUM_CONVERSION_EVENTS.SUBMIT_LEAD_FORM, _js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_3__.ENUM_CONVERSION_EVENTS.CONTACT, _js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_3__.ENUM_CONVERSION_EVENTS.GENERATE_LEAD],
    displayInSelectionPanel: _shouldDisplayWidgetWithConversionEvent__WEBPACK_IMPORTED_MODULE_4__.shouldDisplayWidgetWithConversionEvent,
    displayInList: _shouldDisplayWidgetWithConversionEvent__WEBPACK_IMPORTED_MODULE_4__.shouldDisplayWidgetWithConversionEvent,
    metadata: {
      group: _constants__WEBPACK_IMPORTED_MODULE_5__.KEY_METRICS_GROUP_GENERATING_LEADS.SLUG
    }
  }
};


/***/ }),

/***/ "./js/components/KeyMetrics/shouldDisplayWidgetWithConversionEvent.js":
/*!****************************************************************************!*\
  !*** ./js/components/KeyMetrics/shouldDisplayWidgetWithConversionEvent.js ***!
  \****************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   shouldDisplayWidgetWithConversionEvent: () => (/* binding */ shouldDisplayWidgetWithConversionEvent)
/* harmony export */ });
/* harmony import */ var _js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @/js/googlesitekit/datastore/user/constants */ "./js/googlesitekit/datastore/user/constants.js");
/* harmony import */ var _js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/modules/analytics-4/datastore/constants */ "./js/modules/analytics-4/datastore/constants.js");
/**
 * Key Metrics shouldDisplayWidgetWithConversionEvent function.
 *
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Internal dependencies
 */



/**
 * Determines whether to display a widget that requires conversion reporting events
 * in the key metrics selection panel.
 *
 * This function is attached to the widget object that requires the conversion reporting events and
 * has the `requiredConversionEventName` property.
 *
 * @since 1.136.0
 * @since 1.137.0 Moved function to its own file.
 *
 * @param {Object}   options        Options object.
 * @param {Function} options.select Data store select function.
 * @param {string}   options.slug   Key metric widget slug.
 * @return {boolean} Whether to display the widget.
 */
function shouldDisplayWidgetWithConversionEvent({
  select,
  slug
}) {
  return select(_js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_1__.MODULES_ANALYTICS_4).hasConversionReportingEvents(
  // This property is available to the widget object that requires the
  // conversion reporting events, where the function is attached.
  this.requiredConversionEventName) || select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_0__.CORE_USER).isKeyMetricActive(slug);
}

/***/ }),

/***/ "./js/components/LeanCTABanner.js":
/*!****************************************!*\
  !*** ./js/components/LeanCTABanner.js ***!
  \****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * LeanCTABanner component.
 *
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * WordPress dependencies
 */


const LeanCTABanner = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.forwardRef)(({
  className,
  children,
  Icon,
  SVGGraphic
}, ref) => {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsxs)("div", {
    ref: ref,
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-lean-cta-banner', className),
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsxs)("div", {
      className: "googlesitekit-lean-cta-banner__body",
      children: [Icon && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", {
        className: "googlesitekit-lean-cta-banner__body-icon",
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)(Icon, {
          width: "32",
          height: "32"
        })
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", {
        className: "googlesitekit-lean-cta-banner__body-content",
        children: children
      })]
    }), SVGGraphic && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", {
      className: "googlesitekit-lean-cta-banner__graphic",
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)(SVGGraphic, {})
    })]
  });
});
LeanCTABanner.propTypes = {
  className: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  children: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().node).isRequired,
  Icon: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().elementType),
  SVGGraphic: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().elementType)
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (LeanCTABanner);

/***/ }),

/***/ "./js/components/Link.js":
/*!*******************************!*\
  !*** ./js/components/Link.js ***!
  \*******************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_10__);
/* harmony import */ var react_router_dom__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! react-router-dom */ "../node_modules/react-router-dom/esm/react-router-dom.js");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _svg_icons_arrow_svg__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/svg/icons/arrow.svg */ "./svg/icons/arrow.svg");
/* harmony import */ var _svg_icons_arrow_inverse_svg__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/svg/icons/arrow-inverse.svg */ "./svg/icons/arrow-inverse.svg");
/* harmony import */ var _svg_icons_back_svg__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/svg/icons/back.svg */ "./svg/icons/back.svg");
/* harmony import */ var _svg_icons_external_svg__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/svg/icons/external.svg */ "./svg/icons/external.svg");
/* harmony import */ var _IconWrapper__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./IconWrapper */ "./js/components/IconWrapper.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Link component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */




/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */






const BUTTON = 'BUTTON';
const BUTTON_DISABLED = 'BUTTON_DISABLED';
const EXTERNAL_LINK = 'EXTERNAL_LINK';
const LINK = 'LINK';
const ROUTER_LINK = 'ROUTER_LINK';
const Link = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_8__.forwardRef)((props, ref) => {
  const {
    'aria-label': ariaLabelProp,
    secondary = false,
    arrow = false,
    back = false,
    caps = false,
    children,
    className = '',
    danger = false,
    disabled = false,
    external = false,
    hideExternalIndicator = false,
    href = '',
    inverse = false,
    noFlex = false,
    onClick,
    small = false,
    standalone = false,
    linkButton = false,
    to,
    leadingIcon,
    trailingIcon,
    ...otherProps
  } = props;
  function getType() {
    // Force button element if `onClick` prop is passed and there's no `href`
    // or `to` prop.
    if (!href && !to && onClick) {
      if (disabled) {
        return BUTTON_DISABLED;
      }
      return BUTTON;
    }

    // Only `RouterLink` uses the `to` prop.
    if (to) {
      return ROUTER_LINK;
    }

    // The external prop means this is an external link, which will also output
    // an `<a>` tag.
    if (external) {
      return EXTERNAL_LINK;
    }

    // A regular `<a>` tag without external indicators.
    return LINK;
  }
  const type = getType();
  function getLinkComponent() {
    if (type === BUTTON || type === BUTTON_DISABLED) {
      return 'button';
    }
    if (type === ROUTER_LINK) {
      return react_router_dom__WEBPACK_IMPORTED_MODULE_9__.Link;
    }
    return 'a';
  }
  function getAriaLabel() {
    // Otherwise, create an ARIA label if the link opens in a new window
    // or is disabled, to add extra context to the link.
    let labelSuffix;
    if (type === EXTERNAL_LINK) {
      labelSuffix = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__._x)('(opens in a new tab)', 'screen reader text', 'google-site-kit');
    }
    if (type === BUTTON_DISABLED) {
      labelSuffix = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__._x)('(disabled)', 'screen reader text', 'google-site-kit');
    }
    if (!labelSuffix) {
      return ariaLabelProp;
    }

    // If an ARIA label was supplied, use that.
    if (ariaLabelProp) {
      return `${ariaLabelProp} ${labelSuffix}`;
    }

    // Otherwise, use the children prop if it's a string.
    if (typeof children === 'string') {
      return `${children} ${labelSuffix}`;
    }

    // If there isn't a string we can use to create the label, we shouldn't
    // make one; otherwise we'll only create an ARIA label that says
    // "(opens in a new tab)", which is not good.
    return undefined;
  }
  const LinkComponent = getLinkComponent();
  const ariaLabel = getAriaLabel();

  // Set the prefix/suffix icons, based on the type of link this is and
  // the props supplied.
  let leadingIconToUse = leadingIcon;
  let trailingIconToUse = trailingIcon;
  if (back) {
    leadingIconToUse = /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_svg_icons_back_svg__WEBPACK_IMPORTED_MODULE_4__["default"], {
      width: 14,
      height: 14
    });
  }
  if (external && !hideExternalIndicator) {
    trailingIconToUse = /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_svg_icons_external_svg__WEBPACK_IMPORTED_MODULE_5__["default"], {
      width: 14,
      height: 14
    });
  }
  if (arrow && !inverse) {
    trailingIconToUse = /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_svg_icons_arrow_svg__WEBPACK_IMPORTED_MODULE_2__["default"], {
      width: 14,
      height: 14
    });
  }
  if (arrow && inverse) {
    trailingIconToUse = /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_svg_icons_arrow_inverse_svg__WEBPACK_IMPORTED_MODULE_3__["default"], {
      width: 14,
      height: 14
    });
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsxs)(LinkComponent, {
    "aria-label": ariaLabel,
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-cta-link', className, {
      'googlesitekit-cta-link--secondary': secondary,
      'googlesitekit-cta-link--inverse': inverse,
      'googlesitekit-cta-link--small': small,
      'googlesitekit-cta-link--caps': caps,
      'googlesitekit-cta-link--danger': danger,
      'googlesitekit-cta-link--disabled': disabled,
      'googlesitekit-cta-link--standalone': standalone,
      'googlesitekit-cta-link--link-button': linkButton,
      'googlesitekit-cta-link--no-flex': !!noFlex
    }),
    disabled: disabled,
    href: (type === LINK || type === EXTERNAL_LINK) && !disabled ? href : undefined,
    onClick: onClick,
    rel: type === EXTERNAL_LINK ? 'noopener noreferrer' : undefined,
    ref: ref,
    target: type === EXTERNAL_LINK ? '_blank' : undefined,
    to: to,
    ...otherProps,
    children: [!!leadingIconToUse && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_IconWrapper__WEBPACK_IMPORTED_MODULE_6__["default"], {
      marginRight: 5,
      children: leadingIconToUse
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)("span", {
      className: "googlesitekit-cta-link__contents",
      children: children
    }), !!trailingIconToUse && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_IconWrapper__WEBPACK_IMPORTED_MODULE_6__["default"], {
      marginLeft: 5,
      children: trailingIconToUse
    })]
  });
});
Link.propTypes = {
  arrow: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().bool),
  back: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().bool),
  caps: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().bool),
  children: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().node),
  className: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().string),
  danger: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().bool),
  disabled: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().bool),
  external: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().bool),
  hideExternalIndicator: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().bool),
  href: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().string),
  inverse: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().bool),
  leadingIcon: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().node),
  linkButton: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().bool),
  noFlex: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().bool),
  onClick: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().func),
  small: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().bool),
  standalone: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().bool),
  to: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().string),
  trailingIcon: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().node)
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Link);

/***/ }),

/***/ "./js/components/LoadingWrapper.js":
/*!*****************************************!*\
  !*** ./js/components/LoadingWrapper.js ***!
  \*****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ LoadingWrapper)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _PreviewBlock__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./PreviewBlock */ "./js/components/PreviewBlock.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * LoadingWrapper component.
 *
 * Site Kit by Google, Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * Internal dependencies
 */


function LoadingWrapper({
  loading,
  children,
  ...previewBlockProps
}) {
  if (loading) {
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)(_PreviewBlock__WEBPACK_IMPORTED_MODULE_0__["default"], {
      ...previewBlockProps
    });
  }
  return children;
}
LoadingWrapper.propTypes = {
  loading: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().bool),
  children: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().node),
  ..._PreviewBlock__WEBPACK_IMPORTED_MODULE_0__["default"].propTypes
};

/***/ }),

/***/ "./js/components/Logo.js":
/*!*******************************!*\
  !*** ./js/components/Logo.js ***!
  \*******************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _svg_graphics_logo_g_svg__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/svg/graphics/logo-g.svg */ "./svg/graphics/logo-g.svg");
/* harmony import */ var _svg_graphics_logo_sitekit_svg__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/svg/graphics/logo-sitekit.svg */ "./svg/graphics/logo-sitekit.svg");
/* harmony import */ var _VisuallyHidden__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./VisuallyHidden */ "./js/components/VisuallyHidden.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Logo component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */




function Logo() {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsxs)("div", {
    className: "googlesitekit-logo",
    "aria-hidden": "true",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(_svg_graphics_logo_g_svg__WEBPACK_IMPORTED_MODULE_1__["default"], {
      className: "googlesitekit-logo__logo-g",
      height: "34",
      width: "32"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(_svg_graphics_logo_sitekit_svg__WEBPACK_IMPORTED_MODULE_2__["default"], {
      className: "googlesitekit-logo__logo-sitekit",
      height: "26",
      width: "99"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(_VisuallyHidden__WEBPACK_IMPORTED_MODULE_3__["default"], {
      children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Site Kit by Google Logo', 'google-site-kit')
    })]
  });
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Logo);

/***/ }),

/***/ "./js/components/ModalDialog.js":
/*!**************************************!*\
  !*** ./js/components/ModalDialog.js ***!
  \**************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_compose__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @wordpress/compose */ "../node_modules/@wordpress/compose/build-module/hooks/use-instance-id/index.js");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/@wordpress/element/build-module/create-interpolate-element.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! googlesitekit-components */ "googlesitekit-components");
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_components__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _svg_icons_warning_svg__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/svg/icons/warning.svg */ "./svg/icons/warning.svg");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * ModalDialog component.
 *
 * Site Kit by Google, Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * WordPress dependencies
 */




/**
 * Internal dependencies
 */



function ModalDialog({
  className = '',
  dialogActive = false,
  handleCancel = null,
  onOpen = null,
  onClose = null,
  title = null,
  provides,
  handleConfirm,
  subtitle,
  confirmButton = null,
  dependentModules,
  danger = false,
  inProgress = false,
  small = false,
  medium = false,
  buttonLink = null
}) {
  const instanceID = (0,_wordpress_compose__WEBPACK_IMPORTED_MODULE_5__["default"])(ModalDialog);
  const describedByID = `googlesitekit-dialog-description-${instanceID}`;
  const hasProvides = !!(provides && provides.length);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsxs)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_2__.Dialog, {
    open: dialogActive,
    onOpen: onOpen,
    onClose: onClose,
    "aria-describedby": hasProvides ? describedByID : undefined,
    tabIndex: "-1",
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()(className, {
      'googlesitekit-dialog-sm': small,
      'googlesitekit-dialog-md': medium
    }),
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsxs)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_2__.DialogTitle, {
      children: [danger && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(_svg_icons_warning_svg__WEBPACK_IMPORTED_MODULE_3__["default"], {
        width: 28,
        height: 28
      }), title]
    }),
    // Ensure we don't render anything at all if subtitle is falsy, as Dialog expects all its children to be elements and a falsy value will result in an error.
    subtitle ? /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("p", {
      className: "mdc-dialog__lead",
      children: subtitle
    }) : [], /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsxs)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_2__.DialogContent, {
      children: [hasProvides && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("section", {
        id: describedByID,
        className: "mdc-dialog__provides",
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("ul", {
          className: "mdc-list mdc-list--underlined mdc-list--non-interactive",
          children: provides.map(attribute => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("li", {
            className: "mdc-list-item",
            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("span", {
              className: "mdc-list-item__text",
              children: attribute
            })
          }, attribute))
        })
      }), dependentModules && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("p", {
        className: "mdc-dialog__dependencies",
        children: (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__["default"])((0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.sprintf)(/* translators: %s is replaced with the dependent modules. */
        (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('<strong>Note:</strong> %s', 'google-site-kit'), dependentModules), {
          strong: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("strong", {})
        })
      })]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsxs)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_2__.DialogFooter, {
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_2__.Button, {
        className: "mdc-dialog__cancel-button",
        onClick: handleCancel,
        disabled: inProgress,
        tertiary: true,
        children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Cancel', 'google-site-kit')
      }), buttonLink ? /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_2__.Button, {
        href: buttonLink,
        onClick: handleConfirm,
        target: "_blank",
        danger: danger,
        children: confirmButton
      }) : /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_2__.SpinnerButton, {
        onClick: handleConfirm,
        danger: danger,
        disabled: inProgress,
        isSaving: inProgress,
        children: confirmButton || (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Disconnect', 'google-site-kit')
      })]
    })]
  });
}
ModalDialog.displayName = 'Dialog';
ModalDialog.propTypes = {
  className: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().string),
  dialogActive: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().bool),
  handleDialog: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().func),
  handleConfirm: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().func).isRequired,
  onOpen: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().func),
  onClose: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().func),
  title: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().string),
  confirmButton: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().string),
  danger: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().bool),
  small: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().bool),
  medium: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().bool),
  buttonLink: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().string)
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ModalDialog);

/***/ }),

/***/ "./js/components/ModuleIcon.js":
/*!*************************************!*\
  !*** ./js/components/ModuleIcon.js ***!
  \*************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ ModuleIcon)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/googlesitekit/modules/datastore/constants */ "./js/googlesitekit/modules/datastore/constants.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * ModuleIcon component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * Internal dependencies
 */



function ModuleIcon({
  slug,
  size,
  ...props
}) {
  const ModuleIconComponent = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useSelect)(select => select(_js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_1__.CORE_MODULES).getModuleIcon(slug));
  if (!ModuleIconComponent) {
    return null;
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)(ModuleIconComponent, {
    width: size,
    height: size,
    ...props
  });
}
ModuleIcon.propTypes = {
  slug: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string).isRequired,
  size: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().number)
};
ModuleIcon.defaultProps = {
  size: 33
};

/***/ }),

/***/ "./js/components/NewBadge.js":
/*!***********************************!*\
  !*** ./js/components/NewBadge.js ***!
  \***********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! googlesitekit-components */ "googlesitekit-components");
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_components__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _Badge__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./Badge */ "./js/components/Badge.js");
/* harmony import */ var _Link__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./Link */ "./js/components/Link.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * NewBadge component.
 *
 * Site Kit by Google, Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */




function NewBadge({
  tooltipTitle,
  learnMoreLink,
  forceOpen,
  hasLeftSpacing,
  hasNoSpacing,
  onLearnMoreClick = () => {}
}) {
  const badgeComponent = /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_Badge__WEBPACK_IMPORTED_MODULE_3__["default"], {
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-new-badge', {
      'googlesitekit-new-badge--has-no-spacing': hasNoSpacing
    }),
    label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('New', 'google-site-kit'),
    hasLeftSpacing: hasLeftSpacing
  });
  if (!tooltipTitle) {
    return badgeComponent;
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_2__.Tooltip, {
    tooltipClassName: "googlesitekit-new-badge__tooltip",
    title: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)(_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.Fragment, {
      children: [tooltipTitle, /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("br", {}), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_Link__WEBPACK_IMPORTED_MODULE_4__["default"], {
        href: learnMoreLink,
        onClick: onLearnMoreClick,
        external: true,
        hideExternalIndicator: true,
        children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Learn more', 'google-site-kit')
      })]
    }),
    placement: "top",
    enterTouchDelay: 0,
    leaveTouchDelay: 5000,
    open: forceOpen,
    interactive: true,
    children: badgeComponent
  });
}
NewBadge.propTypes = {
  tooltipTitle: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().string),
  learnMoreLink: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().string),
  forceOpen: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().bool),
  onLearnMoreClick: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().func),
  hasLeftSpacing: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().bool),
  hasNoSpacing: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().bool)
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (NewBadge);

/***/ }),

/***/ "./js/components/Notice/CTAButton.js":
/*!*******************************************!*\
  !*** ./js/components/Notice/CTAButton.js ***!
  \*******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ CTAButton)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! googlesitekit-components */ "googlesitekit-components");
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_components__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _svg_icons_external_svg__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/svg/icons/external.svg */ "./svg/icons/external.svg");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * Internal dependencies
 */



function CTAButton({
  label,
  disabled,
  inProgress,
  onClick,
  href,
  external,
  hideExternalIndicator
}) {
  let trailingIconToUse;
  if (external && !hideExternalIndicator) {
    trailingIconToUse = /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)(_svg_icons_external_svg__WEBPACK_IMPORTED_MODULE_1__["default"], {
      width: 14,
      height: 14
    });
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_0__.SpinnerButton, {
    className: "googlesitekit-notice__cta",
    disabled: disabled,
    isSaving: inProgress,
    onClick: onClick,
    href: href,
    target: external ? '_blank' : '_self',
    trailingIcon: trailingIconToUse,
    children: label
  });
}
CTAButton.propTypes = {
  label: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string).isRequired,
  disabled: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().bool),
  inProgress: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().bool),
  onClick: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().func),
  href: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  external: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().bool),
  hideExternalIndicator: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().bool)
};

/***/ }),

/***/ "./js/components/Notice/Description.js":
/*!*********************************************!*\
  !*** ./js/components/Notice/Description.js ***!
  \*********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Description)
/* harmony export */ });
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



function Description({
  className,
  children
}) {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("p", {
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-notice__description', className),
    children: children
  });
}
Description.propTypes = {
  className: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().string),
  children: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().node)
};

/***/ }),

/***/ "./js/components/Notice/DismissButton.js":
/*!***********************************************!*\
  !*** ./js/components/Notice/DismissButton.js ***!
  \***********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ DismissButton)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-components */ "googlesitekit-components");
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */


function DismissButton({
  label = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Got it', 'google-site-kit'),
  onClick,
  disabled
}) {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__.Button, {
    onClick: onClick,
    disabled: disabled,
    tertiary: true,
    children: label
  });
}
DismissButton.propTypes = {
  label: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  onClick: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().func).isRequired,
  disabled: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().bool)
};

/***/ }),

/***/ "./js/components/Notice/Icon.js":
/*!**************************************!*\
  !*** ./js/components/Notice/Icon.js ***!
  \**************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Icon)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _svg_icons_check_fill_svg__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @/svg/icons/check-fill.svg */ "./svg/icons/check-fill.svg");
/* harmony import */ var _svg_icons_warning_notice_svg__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/svg/icons/warning-notice.svg */ "./svg/icons/warning-notice.svg");
/* harmony import */ var _svg_icons_star_fill_svg__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/svg/icons/star-fill.svg */ "./svg/icons/star-fill.svg");
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./constants */ "./js/components/Notice/constants.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * Internal dependencies
 */





const typeIconMap = {
  [_constants__WEBPACK_IMPORTED_MODULE_3__.TYPES.NEW]: _svg_icons_star_fill_svg__WEBPACK_IMPORTED_MODULE_2__["default"],
  [_constants__WEBPACK_IMPORTED_MODULE_3__.TYPES.SUCCESS]: _svg_icons_check_fill_svg__WEBPACK_IMPORTED_MODULE_0__["default"],
  [_constants__WEBPACK_IMPORTED_MODULE_3__.TYPES.INFO]: _svg_icons_warning_notice_svg__WEBPACK_IMPORTED_MODULE_1__["default"],
  [_constants__WEBPACK_IMPORTED_MODULE_3__.TYPES.WARNING]: _svg_icons_warning_notice_svg__WEBPACK_IMPORTED_MODULE_1__["default"],
  [_constants__WEBPACK_IMPORTED_MODULE_3__.TYPES.ERROR]: _svg_icons_warning_notice_svg__WEBPACK_IMPORTED_MODULE_1__["default"]
};
function Icon({
  type
}) {
  const IconComponent = typeIconMap[type] || _svg_icons_warning_notice_svg__WEBPACK_IMPORTED_MODULE_1__["default"];
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(IconComponent, {
    width: 24,
    height: 24
  });
}
Icon.propTypes = {
  type: prop_types__WEBPACK_IMPORTED_MODULE_5___default().oneOf(Object.values(_constants__WEBPACK_IMPORTED_MODULE_3__.TYPES))
};

/***/ }),

/***/ "./js/components/Notice/Title.js":
/*!***************************************!*\
  !*** ./js/components/Notice/Title.js ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Title)
/* harmony export */ });
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



function Title({
  className,
  children
}) {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("p", {
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-notice__title', className),
    children: children
  });
}
Title.propTypes = {
  className: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().string),
  children: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().node)
};

/***/ }),

/***/ "./js/components/Notice/constants.js":
/*!*******************************************!*\
  !*** ./js/components/Notice/constants.js ***!
  \*******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   TYPES: () => (/* binding */ TYPES)
/* harmony export */ });
/**
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

const TYPES = {
  NEW: 'new',
  SUCCESS: 'success',
  WARNING: 'warning',
  INFO: 'info',
  ERROR: 'error'
};

/***/ }),

/***/ "./js/components/Notice/index.js":
/*!***************************************!*\
  !*** ./js/components/Notice/index.js ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _Icon__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Icon */ "./js/components/Notice/Icon.js");
/* harmony import */ var _Title__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./Title */ "./js/components/Notice/Title.js");
/* harmony import */ var _Description__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./Description */ "./js/components/Notice/Description.js");
/* harmony import */ var _CTAButton__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./CTAButton */ "./js/components/Notice/CTAButton.js");
/* harmony import */ var _DismissButton__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./DismissButton */ "./js/components/Notice/DismissButton.js");
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./constants */ "./js/components/Notice/constants.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */







const Notice = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_8__.forwardRef)(({
  className,
  title,
  description,
  dismissButton,
  ctaButton,
  type = _constants__WEBPACK_IMPORTED_MODULE_6__.TYPES.INFO,
  children,
  hideIcon
}, ref) => {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsxs)("div", {
    ref: ref,
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-notice', `googlesitekit-notice--${type}`, className),
    children: [!hideIcon && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)("div", {
      className: "googlesitekit-notice__icon",
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_Icon__WEBPACK_IMPORTED_MODULE_1__["default"], {
        type: type
      })
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsxs)("div", {
      className: "googlesitekit-notice__content",
      children: [title && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_Title__WEBPACK_IMPORTED_MODULE_2__["default"], {
        children: title
      }), description && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_Description__WEBPACK_IMPORTED_MODULE_3__["default"], {
        children: description
      })]
    }), (dismissButton?.label || dismissButton?.onClick || ctaButton?.label && (ctaButton?.onClick || ctaButton?.href) || children) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsxs)("div", {
      className: "googlesitekit-notice__action",
      children: [children, (dismissButton?.label || dismissButton?.onClick) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_DismissButton__WEBPACK_IMPORTED_MODULE_5__["default"], {
        label: dismissButton.label,
        onClick: dismissButton.onClick,
        disabled: dismissButton.disabled
      }), ctaButton?.label && (ctaButton?.onClick || ctaButton?.href) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_CTAButton__WEBPACK_IMPORTED_MODULE_4__["default"], {
        label: ctaButton.label,
        onClick: ctaButton.onClick,
        inProgress: ctaButton.inProgress,
        disabled: ctaButton.disabled,
        href: ctaButton.href,
        external: ctaButton.external,
        hideExternalIndicator: ctaButton.hideExternalIndicator
      })]
    })]
  });
});
Notice.TYPES = _constants__WEBPACK_IMPORTED_MODULE_6__.TYPES;
Notice.propTypes = {
  className: (prop_types__WEBPACK_IMPORTED_MODULE_9___default().string),
  title: prop_types__WEBPACK_IMPORTED_MODULE_9___default().oneOfType([(prop_types__WEBPACK_IMPORTED_MODULE_9___default().string), (prop_types__WEBPACK_IMPORTED_MODULE_9___default().object)]),
  description: (prop_types__WEBPACK_IMPORTED_MODULE_9___default().node),
  type: prop_types__WEBPACK_IMPORTED_MODULE_9___default().oneOf(Object.values(_constants__WEBPACK_IMPORTED_MODULE_6__.TYPES)),
  dismissButton: prop_types__WEBPACK_IMPORTED_MODULE_9___default().shape(_DismissButton__WEBPACK_IMPORTED_MODULE_5__["default"].propTypes),
  ctaButton: prop_types__WEBPACK_IMPORTED_MODULE_9___default().shape({
    ..._CTAButton__WEBPACK_IMPORTED_MODULE_4__["default"].propTypes,
    label: (prop_types__WEBPACK_IMPORTED_MODULE_9___default().string) // CTAButton label should not be required for this parent component.
  }),
  children: (prop_types__WEBPACK_IMPORTED_MODULE_9___default().node),
  hideIcon: (prop_types__WEBPACK_IMPORTED_MODULE_9___default().bool)
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Notice);

/***/ }),

/***/ "./js/components/NotificationFromServer.js":
/*!*************************************************!*\
  !*** ./js/components/NotificationFromServer.js ***!
  \*************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _js_googlesitekit_notifications_components_layout_BannerNotification__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @/js/googlesitekit/notifications/components/layout/BannerNotification */ "./js/googlesitekit/notifications/components/layout/BannerNotification.js");
/* harmony import */ var _js_util__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/util */ "./js/util/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * NotificationFromServer component.
 *
 * Component used to render notifications from the server, such as
 * those from `CORE_SITE` or `MODULES_*` data stores.
 *
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */



/**
 * Maps props received from the server (e.g. from a `select( CORE_SITE ).getNotifications()`
 * selector call) to the props expected by the new BannerNotification component.
 *
 * @since 1.157.0
 *
 * @param {Object}     props                     Component props.
 * @param {string}     props.id                  Notification ID/slug.
 * @param {?ReactNode} props.titleIcon           Icon to display above the title.
 * @param {string}     props.title               Notification title/heading.
 * @param {?ReactNode} props.content             Description for notification.
 * @param {string}     props.ctaLabel            Label for the call-to-action button.
 * @param {?string}    props.ctaTarget           `target` for the call-to-action link, e.g. `_blank`. Optional.
 * @param {?string}    props.ctaURL              URL for the call-to-action link.
 * @param {?boolean}   props.dismissible         Whether the notification is dismissible. Optional.
 * @param {?string}    props.dismissLabel        Label for the dismiss button. Optional.
 * @param {?string}    props.learnMoreLabel      Label for the "Learn More" link. Optional.
 * @param {?string}    props.learnMoreURL        URL for the "Learn More" link. Optional.
 * @param {?Function}  props.onCTAClick          Callback to run when CTA is clicked. Optional.
 * @param {?Function}  props.onDismissClick      Callback to run when the Dismiss button is clicked. Optional.
 * @param {?Object}    props.gaTrackingEventArgs Custom GA tracking event category and label options. Optional.
 * @return {JSX.Element} Notification component.
 */

function NotificationFromServer({
  id,
  titleIcon,
  title,
  content,
  ctaLabel,
  ctaTarget,
  ctaURL,
  dismissible,
  dismissLabel,
  learnMoreLabel,
  learnMoreURL,
  onCTAClick,
  onDismissClick,
  gaTrackingEventArgs
}) {
  // Notifications from the server should not be dismissed permanently in the database.
  // CoreSiteBannerNotifications are "marked as accepted/dismissed" on the server.
  // AdSense Alerts are not dismissed permanently either, they keep coming back until the
  // issue that raises the alert is resolved. Thus we expire the dismissal after an hour,
  // which was the behaviour prevalent in the legacy BannerNotification component that cached
  // dismissals for an hour in browser storage.
  const dismissOptions = {
    expiresInSeconds: _js_util__WEBPACK_IMPORTED_MODULE_1__.HOUR_IN_SECONDS
  };
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)(_js_googlesitekit_notifications_components_layout_BannerNotification__WEBPACK_IMPORTED_MODULE_0__["default"], {
    notificationID: id,
    type: _js_googlesitekit_notifications_components_layout_BannerNotification__WEBPACK_IMPORTED_MODULE_0__.TYPES.WARNING,
    titleIcon: titleIcon ? titleIcon : undefined,
    title: title,
    description: content,
    learnMoreLink: learnMoreURL ? {
      label: learnMoreLabel,
      href: learnMoreURL
    } : undefined,
    ctaButton: {
      label: ctaLabel,
      href: ctaURL,
      target: ctaTarget,
      onClick: onCTAClick,
      dismissOptions
    },
    dismissButton: dismissible ? {
      label: dismissLabel,
      onClick: onDismissClick,
      dismissOptions
    } : undefined,
    gaTrackingEventArgs: gaTrackingEventArgs
  });
}
NotificationFromServer.propTypes = {
  id: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string).isRequired,
  title: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string).isRequired,
  content: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().node),
  ctaLabel: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  ctaTarget: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  ctaURL: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  dismissible: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().bool),
  dismissLabel: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  learnMoreLabel: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  learnMoreURL: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  onCTAClick: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().func),
  onDismissClick: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().func),
  gaTrackingEventArgs: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().object)
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (NotificationFromServer);

/***/ }),

/***/ "./js/components/Null.js":
/*!*******************************!*\
  !*** ./js/components/Null.js ***!
  \*******************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Null)
/* harmony export */ });
/**
 * Null component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

function Null() {
  return null;
}

/***/ }),

/***/ "./js/components/OptIn.js":
/*!********************************!*\
  !*** ./js/components/OptIn.js ***!
  \********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ OptIn)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_12___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_12__);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/@wordpress/element/build-module/create-interpolate-element.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! googlesitekit-components */ "googlesitekit-components");
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_components__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/googlesitekit/datastore/user/constants */ "./js/googlesitekit/datastore/user/constants.js");
/* harmony import */ var _js_util_tracking__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/util/tracking */ "./js/util/tracking/index.js");
/* harmony import */ var _Link__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./Link */ "./js/components/Link.js");
/* harmony import */ var _js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @/js/hooks/useViewContext */ "./js/hooks/useViewContext.js");
/* harmony import */ var _js_hooks_useDebounce__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @/js/hooks/useDebounce */ "./js/hooks/useDebounce.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * OptIn component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */








function OptIn({
  id = 'googlesitekit-opt-in',
  name = 'optIn',
  className,
  trackEventCategory,
  alignLeftCheckbox = false
}) {
  const [checked, setChecked] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_10__.useState)();
  const enabled = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.useSelect)(select => select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_4__.CORE_USER).isTrackingEnabled());
  const error = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.useSelect)(select => select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_4__.CORE_USER).getErrorForAction('setTrackingEnabled', [!enabled]));
  const {
    setTrackingEnabled
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.useDispatch)(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_4__.CORE_USER);
  const viewContext = (0,_js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_7__["default"])();
  const handleOptIn = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_10__.useCallback)(async isChecked => {
    const {
      response,
      error: responseError
    } = await setTrackingEnabled(isChecked);
    if (!responseError) {
      (0,_js_util_tracking__WEBPACK_IMPORTED_MODULE_5__.toggleTracking)(response.enabled);
      if (response.enabled) {
        (0,_js_util_tracking__WEBPACK_IMPORTED_MODULE_5__.trackEvent)(trackEventCategory || viewContext, 'tracking_optin');
      }
    } else {
      setChecked(enabled);
    }
  }, [enabled, setTrackingEnabled, trackEventCategory, viewContext]);
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_10__.useEffect)(() => {
    if (enabled !== undefined && checked === undefined) {
      setChecked(enabled);
    }
  }, [enabled, checked]);
  const debouncedHandleOptIn = (0,_js_hooks_useDebounce__WEBPACK_IMPORTED_MODULE_8__.useDebounce)(handleOptIn, 300);
  const handleCheck = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_10__.useCallback)(e => {
    const isChecked = e.target.checked;
    setChecked(isChecked);
    debouncedHandleOptIn(isChecked);
  }, [debouncedHandleOptIn]);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsxs)("div", {
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-opt-in', className),
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_3__.Checkbox, {
      id: id,
      name: name,
      value: "1",
      checked: checked,
      onChange: handleCheck,
      loading: enabled === undefined,
      alignLeft: alignLeftCheckbox,
      children: (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_11__["default"])((0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('<span>Help us improve Site Kit by sharing anonymous usage data.</span> <span>All collected data is treated in accordance with the <a>Google Privacy Policy.</a></span>', 'google-site-kit'), {
        a: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)(_Link__WEBPACK_IMPORTED_MODULE_6__["default"], {
          href: "https://policies.google.com/privacy",
          external: true
        }, "link"),
        span: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)("span", {})
      })
    }), error?.message && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)("div", {
      className: "googlesitekit-error-text",
      children: error?.message
    })]
  });
}
OptIn.propTypes = {
  id: (prop_types__WEBPACK_IMPORTED_MODULE_12___default().string),
  name: (prop_types__WEBPACK_IMPORTED_MODULE_12___default().string),
  className: (prop_types__WEBPACK_IMPORTED_MODULE_12___default().string),
  trackEventCategory: (prop_types__WEBPACK_IMPORTED_MODULE_12___default().string),
  alignLeftCheckbox: (prop_types__WEBPACK_IMPORTED_MODULE_12___default().bool)
};

/***/ }),

/***/ "./js/components/OverlayCard/Body.js":
/*!*******************************************!*\
  !*** ./js/components/OverlayCard/Body.js ***!
  \*******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Body)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @/js/hooks/useBreakpoint */ "./js/hooks/useBreakpoint.js");
/* harmony import */ var _Title__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Title */ "./js/components/OverlayCard/Title.js");
/* harmony import */ var _Description__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./Description */ "./js/components/OverlayCard/Description.js");
/* harmony import */ var _DismissButton__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./DismissButton */ "./js/components/OverlayCard/DismissButton.js");
/* harmony import */ var _CTAButton__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./CTAButton */ "./js/components/OverlayCard/CTAButton.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * OverlayCard Body component.
 *
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */






function Body({
  title,
  description,
  ctaButton,
  dismissButton,
  GraphicDesktop,
  GraphicMobile
}) {
  const breakpoint = (0,_js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_0__.useBreakpoint)();
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)(_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.Fragment, {
    children: [breakpoint !== _js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_0__.BREAKPOINT_SMALL && GraphicDesktop && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("div", {
      className: "googlesitekit-overlay-card__graphic",
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(GraphicDesktop, {})
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)("div", {
      className: "googlesitekit-overlay-card__body",
      children: [title && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_Title__WEBPACK_IMPORTED_MODULE_1__["default"], {
        children: title
      }), description && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_Description__WEBPACK_IMPORTED_MODULE_2__["default"], {
        children: description
      })]
    }), (ctaButton || dismissButton) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)("div", {
      className: "googlesitekit-overlay-card__actions",
      children: [dismissButton && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_DismissButton__WEBPACK_IMPORTED_MODULE_3__["default"], {
        ...dismissButton
      }), ctaButton && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_CTAButton__WEBPACK_IMPORTED_MODULE_4__["default"], {
        ...ctaButton
      })]
    }), breakpoint === _js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_0__.BREAKPOINT_SMALL && GraphicMobile && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(GraphicMobile, {})]
  });
}
Body.propTypes = {
  title: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().node),
  description: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().node),
  ctaButton: prop_types__WEBPACK_IMPORTED_MODULE_7___default().shape({
    ..._DismissButton__WEBPACK_IMPORTED_MODULE_3__.buttonProps,
    href: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().string),
    target: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().string),
    trailingIcon: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().element)
  }),
  dismissButton: prop_types__WEBPACK_IMPORTED_MODULE_7___default().shape({
    ..._DismissButton__WEBPACK_IMPORTED_MODULE_3__.buttonProps
  }),
  GraphicDesktop: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().elementType),
  GraphicMobile: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().elementType)
};

/***/ }),

/***/ "./js/components/OverlayCard/CTAButton.js":
/*!************************************************!*\
  !*** ./js/components/OverlayCard/CTAButton.js ***!
  \************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ CTAButton)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! googlesitekit-components */ "googlesitekit-components");
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_components__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _DismissButton__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./DismissButton */ "./js/components/OverlayCard/DismissButton.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * OverlayCard CTAButton component.
 *
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * Internal dependencies
 */



function CTAButton(props) {
  const {
    label,
    ...otherProps
  } = props;
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_0__.Button, {
    ...otherProps,
    children: label
  });
}
CTAButton.propTypes = {
  ..._DismissButton__WEBPACK_IMPORTED_MODULE_1__.buttonProps,
  href: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  target: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  trailingIcon: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().object)
};

/***/ }),

/***/ "./js/components/OverlayCard/Description.js":
/*!**************************************************!*\
  !*** ./js/components/OverlayCard/Description.js ***!
  \**************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Description)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * OverlayCard Description component.
 *
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


function Description({
  children
}) {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("p", {
    className: "googlesitekit-overlay-card__description",
    children: children
  });
}
Description.propTypes = {
  children: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().node).isRequired
};

/***/ }),

/***/ "./js/components/OverlayCard/DismissButton.js":
/*!****************************************************!*\
  !*** ./js/components/OverlayCard/DismissButton.js ***!
  \****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   buttonProps: () => (/* binding */ buttonProps),
/* harmony export */   "default": () => (/* binding */ DismissButton)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-components */ "googlesitekit-components");
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * OverlayCard DismissButton component.
 *
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */


function DismissButton({
  label = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Maybe later', 'google-site-kit'),
  onClick,
  disabled
}) {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__.Button, {
    onClick: onClick,
    disabled: disabled,
    tertiary: true,
    children: label
  });
}
const buttonProps = {
  label: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  onClick: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().func),
  disabled: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().bool)
};
DismissButton.propTypes = buttonProps;

/***/ }),

/***/ "./js/components/OverlayCard/Title.js":
/*!********************************************!*\
  !*** ./js/components/OverlayCard/Title.js ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Title)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _js_components_Typography__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @/js/components/Typography */ "./js/components/Typography/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * OverlayCard Title component.
 *
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



function Title({
  children
}) {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)(_js_components_Typography__WEBPACK_IMPORTED_MODULE_0__["default"], {
    as: "h3",
    size: "medium",
    type: "title",
    className: "googlesitekit-overlay-card__title",
    children: children
  });
}
Title.propTypes = {
  children: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().node).isRequired
};

/***/ }),

/***/ "./js/components/OverlayCard/index.js":
/*!********************************************!*\
  !*** ./js/components/OverlayCard/index.js ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ OverlayCard)
/* harmony export */ });
/* harmony import */ var _material_ui_core__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @material-ui/core */ "../node_modules/@material-ui/core/esm/Slide/Slide.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/hooks/useBreakpoint */ "./js/hooks/useBreakpoint.js");
/* harmony import */ var _Body__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./Body */ "./js/components/OverlayCard/Body.js");
/* harmony import */ var _DismissButton__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./DismissButton */ "./js/components/OverlayCard/DismissButton.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * OverlayCard component.
 *
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */




/**
 * Internal dependencies
 */




function OverlayCard(props) {
  const {
    visible,
    className,
    ...cardProps
  } = props;
  const breakpoint = (0,_js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_1__.useBreakpoint)();
  if (!visible) {
    return null;
  }
  const body = /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("div", {
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-overlay-card', className),
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(_Body__WEBPACK_IMPORTED_MODULE_2__["default"], {
      ...cardProps
    })
  });
  if (breakpoint === _js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_1__.BREAKPOINT_SMALL) {
    return body;
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(_material_ui_core__WEBPACK_IMPORTED_MODULE_5__["default"], {
    direction: "up",
    in: visible,
    children: body
  });
}
OverlayCard.propTypes = {
  className: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().string),
  title: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().string),
  description: prop_types__WEBPACK_IMPORTED_MODULE_6___default().oneOfType([(prop_types__WEBPACK_IMPORTED_MODULE_6___default().string), (prop_types__WEBPACK_IMPORTED_MODULE_6___default().object)]),
  ctaButton: prop_types__WEBPACK_IMPORTED_MODULE_6___default().shape({
    ..._DismissButton__WEBPACK_IMPORTED_MODULE_3__.buttonProps,
    href: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().string),
    target: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().string),
    trailingIcon: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().object)
  }),
  dismissButton: prop_types__WEBPACK_IMPORTED_MODULE_6___default().shape(_DismissButton__WEBPACK_IMPORTED_MODULE_3__.buttonProps),
  GraphicDesktop: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().elementType),
  GraphicMobile: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().elementType),
  visible: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().bool)
};
OverlayCard.defaultProps = {
  visible: false
};

/***/ }),

/***/ "./js/components/PageHeader.js":
/*!*************************************!*\
  !*** ./js/components/PageHeader.js ***!
  \*************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ PageHeader)
/* harmony export */ });
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var _js_material_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/material-components */ "./js/material-components/index.js");
/* harmony import */ var _svg_icons_connected_svg__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/svg/icons/connected.svg */ "./svg/icons/connected.svg");
/* harmony import */ var _svg_icons_exclamation_svg__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/svg/icons/exclamation.svg */ "./svg/icons/exclamation.svg");
/* harmony import */ var _IconWrapper__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./IconWrapper */ "./js/components/IconWrapper.js");
/* harmony import */ var _Typography__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./Typography */ "./js/components/Typography/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * PageHeader component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * External dependencies
 */



/**
 * Internal dependencies
 */






function PageHeader(props) {
  const {
    title,
    icon,
    className,
    status,
    statusText,
    fullWidth,
    children
  } = props;
  const titleCellProps = fullWidth ? {
    size: 12
  } : {
    smSize: 4,
    mdSize: 4,
    lgSize: 6
  };

  // Determine whether the details cell should display.
  const hasDetails = '' !== status || Boolean(children);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("header", {
    className: "googlesitekit-page-header",
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)(_js_material_components__WEBPACK_IMPORTED_MODULE_1__.Row, {
      children: [title && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)(_js_material_components__WEBPACK_IMPORTED_MODULE_1__.Cell, {
        ...titleCellProps,
        children: [icon, /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(_Typography__WEBPACK_IMPORTED_MODULE_5__["default"], {
          as: "h1",
          className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-page-header__title', className),
          size: "medium",
          type: "title",
          children: title
        })]
      }), hasDetails && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(_js_material_components__WEBPACK_IMPORTED_MODULE_1__.Cell, {
        smSize: 4,
        mdSize: 4,
        lgSize: 6,
        alignBottom: true,
        mdAlignRight: true,
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)("div", {
          className: "googlesitekit-page-header__details",
          children: [status && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)("span", {
            className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-page-header__status', `googlesitekit-page-header__status--${status}`),
            children: [statusText, /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(_IconWrapper__WEBPACK_IMPORTED_MODULE_4__["default"], {
              children: 'connected' === status ? /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(_svg_icons_connected_svg__WEBPACK_IMPORTED_MODULE_2__["default"], {
                width: 10,
                height: 8
              }) : /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(_svg_icons_exclamation_svg__WEBPACK_IMPORTED_MODULE_3__["default"], {
                width: 2,
                height: 12
              })
            })]
          }), children]
        })
      })]
    })
  });
}
PageHeader.propTypes = {
  title: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().string),
  icon: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().node),
  className: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().string),
  status: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().string),
  statusText: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().string),
  fullWidth: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().bool)
};
PageHeader.defaultProps = {
  title: '',
  icon: null,
  className: 'googlesitekit-heading-3',
  status: '',
  statusText: '',
  fullWidth: false
};

/***/ }),

/***/ "./js/components/PermissionsModal/AuthenticatedPermissionsModal.js":
/*!*************************************************************************!*\
  !*** ./js/components/PermissionsModal/AuthenticatedPermissionsModal.js ***!
  \*************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _js_components_RefocusableModalDialog__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/components/RefocusableModalDialog */ "./js/components/RefocusableModalDialog.js");
/* harmony import */ var _js_googlesitekit_datastore_forms_constants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/googlesitekit/datastore/forms/constants */ "./js/googlesitekit/datastore/forms/constants.js");
/* harmony import */ var _js_googlesitekit_datastore_location_constants__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/googlesitekit/datastore/location/constants */ "./js/googlesitekit/datastore/location/constants.js");
/* harmony import */ var _js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/googlesitekit/datastore/user/constants */ "./js/googlesitekit/datastore/user/constants.js");
/* harmony import */ var _js_googlesitekit_data_create_snapshot_store__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @/js/googlesitekit/data/create-snapshot-store */ "./js/googlesitekit/data/create-snapshot-store.js");
/* harmony import */ var _js_components_Portal__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @/js/components/Portal */ "./js/components/Portal.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * AuthenticatedPermissionsModal component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */








function AuthenticatedPermissionsModal() {
  const registry = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useRegistry)();
  const permissionsError = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_5__.CORE_USER).getPermissionScopeError());
  const unsatisfiedScopes = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_5__.CORE_USER).getUnsatisfiedScopes());
  const connectURL = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_5__.CORE_USER).getConnectURL({
    additionalScopes: permissionsError?.data?.scopes,
    redirectURL: permissionsError?.data?.redirectURL || __webpack_require__.g.location.href,
    errorRedirectURL: permissionsError?.data?.errorRedirectURL
  }));
  const {
    clearPermissionScopeError
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useDispatch)(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_5__.CORE_USER);
  const {
    navigateTo
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useDispatch)(_js_googlesitekit_datastore_location_constants__WEBPACK_IMPORTED_MODULE_4__.CORE_LOCATION);
  const {
    setValues
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useDispatch)(_js_googlesitekit_datastore_forms_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_FORMS);
  const onCancel = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.useCallback)(() => {
    clearPermissionScopeError();
  }, [clearPermissionScopeError]);
  const onConfirm = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.useCallback)(async () => {
    // Temporary store permissions error, so data like `scopes` and `redirectURL`
    // can be used in `Permission error` notification.
    setValues(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_5__.FORM_TEMPORARY_PERSIST_PERMISSION_ERROR, {
      permissionsError
    });
    // If we have a datastores to snapshot before navigating away to the
    // authorization page, do that first.
    await (0,_js_googlesitekit_data_create_snapshot_store__WEBPACK_IMPORTED_MODULE_6__.snapshotAllStores)(registry);

    // Navigate to the authorization page.
    navigateTo(connectURL);
  }, [registry, connectURL, navigateTo, permissionsError, setValues]);
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.useEffect)(() => {
    // If error has flag to skip the modal, redirect to the authorization
    // page immediately without prompting the user, essentially short-
    // circuiting to the confirm step.
    async function confirmIfSkipModal() {
      if (permissionsError?.data?.skipModal && permissionsError?.data?.scopes?.length) {
        await onConfirm();
      }
    }
    confirmIfSkipModal();
  }, [onConfirm, permissionsError]);
  if (!permissionsError) {
    return null;
  }

  // If there aren't any scopes for us to request, there's no reason to show
  // the modal. Log a console warning if this happens and return `null`.
  if (!permissionsError?.data?.scopes?.length) {
    __webpack_require__.g.console.warn('permissionsError lacks scopes array to use for redirect, so not showing the PermissionsModal. permissionsError was:', permissionsError);
    return null;
  }
  if (permissionsError?.data?.skipModal) {
    return null;
  }
  if (unsatisfiedScopes && permissionsError?.data?.scopes.every(scope => unsatisfiedScopes.includes(scope))) {
    return null;
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(_js_components_Portal__WEBPACK_IMPORTED_MODULE_7__["default"], {
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(_js_components_RefocusableModalDialog__WEBPACK_IMPORTED_MODULE_2__["default"], {
      title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Additional Permissions Required', 'google-site-kit'),
      subtitle: permissionsError.message,
      confirmButton: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Proceed', 'google-site-kit'),
      handleConfirm: onConfirm,
      handleCancel: onCancel,
      onClose: onCancel,
      dialogActive: true,
      medium: true
    })
  });
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (AuthenticatedPermissionsModal);

/***/ }),

/***/ "./js/components/PermissionsModal/index.js":
/*!*************************************************!*\
  !*** ./js/components/PermissionsModal/index.js ***!
  \*************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _AuthenticatedPermissionsModal__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./AuthenticatedPermissionsModal */ "./js/components/PermissionsModal/AuthenticatedPermissionsModal.js");
/* harmony import */ var _js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/googlesitekit/datastore/user/constants */ "./js/googlesitekit/datastore/user/constants.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * PermissionsModal component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Internal dependencies
 */




function PermissionsModal() {
  const isAuthenticated = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useSelect)(select => select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_2__.CORE_USER).isAuthenticated());
  if (isAuthenticated) {
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_AuthenticatedPermissionsModal__WEBPACK_IMPORTED_MODULE_1__["default"], {});
  }
  return null;
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (PermissionsModal);

/***/ }),

/***/ "./js/components/Portal.js":
/*!*********************************!*\
  !*** ./js/components/Portal.js ***!
  \*********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_use__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react-use */ "../node_modules/react-use/esm/useEffectOnce.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react-dom/index.js");
/**
 * Portal component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * WordPress dependencies
 */

function Portal({
  children,
  slug
}) {
  // Using state as we need `el` to not change when the component re-renders
  const [el] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.useState)(document.createElement('div'));
  (0,react_use__WEBPACK_IMPORTED_MODULE_1__["default"])(() => {
    if (slug) {
      el.classList.add(`googlesitekit-portal-${slug}`);
    }
    const root = document.querySelector('.googlesitekit-plugin') || document.body;
    root.appendChild(el);
    return () => root.removeChild(el);
  });
  return (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.createPortal)(children, el);
}
Portal.propTypes = {
  slug: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  children: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().node)
};
Portal.defaultProps = {
  slug: '',
  children: null
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Portal);

/***/ }),

/***/ "./js/components/PreviewBlock.js":
/*!***************************************!*\
  !*** ./js/components/PreviewBlock.js ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/hooks/useBreakpoint */ "./js/hooks/useBreakpoint.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * PreviewBlock component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * Internal dependencies
 */


function PreviewBlock({
  className,
  width,
  height,
  shape,
  padding,
  smallWidth,
  smallHeight,
  tabletWidth,
  tabletHeight,
  desktopWidth,
  desktopHeight
}) {
  const breakpoint = (0,_js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_1__.useBreakpoint)();
  const blockDimensions = {
    width: {
      [_js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_1__.BREAKPOINT_SMALL]: smallWidth,
      [_js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_1__.BREAKPOINT_TABLET]: tabletWidth,
      [_js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_1__.BREAKPOINT_DESKTOP]: desktopWidth,
      [_js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_1__.BREAKPOINT_XLARGE]: desktopWidth
    },
    height: {
      [_js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_1__.BREAKPOINT_SMALL]: smallHeight,
      [_js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_1__.BREAKPOINT_TABLET]: tabletHeight,
      [_js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_1__.BREAKPOINT_DESKTOP]: desktopHeight,
      [_js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_1__.BREAKPOINT_XLARGE]: desktopWidth
    }
  };
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("div", {
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-preview-block', className, {
      'googlesitekit-preview-block--padding': padding
    }),
    style: {
      width: blockDimensions.width[breakpoint] || width,
      height: blockDimensions.height[breakpoint] || height
    },
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("div", {
      className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-preview-block__wrapper', {
        'googlesitekit-preview-block__wrapper--circle': shape === 'circular'
      })
    })
  });
}
PreviewBlock.propTypes = {
  className: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  width: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  height: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  shape: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  padding: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().bool),
  smallWidth: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  smallHeight: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  tabletWidth: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  tabletHeight: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  desktopWidth: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  desktopHeight: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string)
};
PreviewBlock.defaultProps = {
  className: undefined,
  width: '100px',
  height: '100px',
  shape: 'square',
  padding: false,
  smallWidth: undefined,
  smallHeight: undefined,
  tabletWidth: undefined,
  tabletHeight: undefined,
  desktopWidth: undefined,
  desktopHeight: undefined
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (PreviewBlock);

/***/ }),

/***/ "./js/components/RecoverableModules.js":
/*!*********************************************!*\
  !*** ./js/components/RecoverableModules.js ***!
  \*********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ RecoverableModules)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/googlesitekit/modules/datastore/constants */ "./js/googlesitekit/modules/datastore/constants.js");
/* harmony import */ var _notifications_CTA__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./notifications/CTA */ "./js/components/notifications/CTA.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * RecoverableModules component.
 *
 * Site Kit by Google, Copyright 2022 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */




function RecoverableModules({
  moduleSlugs
}) {
  const moduleNames = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => {
    const modules = select(_js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_2__.CORE_MODULES).getModules();
    if (modules === undefined) {
      return undefined;
    }
    return moduleSlugs.map(moduleSlug => modules[moduleSlug].name);
  });
  if (moduleNames === undefined) {
    return null;
  }
  const description = moduleNames.length === 1 ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.sprintf)(/* translators: %s: Module name */
  (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('%s data was previously shared by an admin who no longer has access. Please contact another admin to restore it.', 'google-site-kit'), moduleNames[0]) : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.sprintf)(/* translators: %s: List of module names */
  (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('The data for the following modules was previously shared by an admin who no longer has access: %s. Please contact another admin to restore it.', 'google-site-kit'), moduleNames.join((0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__._x)(', ', 'Recoverable modules', 'google-site-kit')));
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(_notifications_CTA__WEBPACK_IMPORTED_MODULE_3__["default"], {
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Data Unavailable', 'google-site-kit'),
    description: description
  });
}
RecoverableModules.propTypes = {
  moduleSlugs: prop_types__WEBPACK_IMPORTED_MODULE_5___default().arrayOf((prop_types__WEBPACK_IMPORTED_MODULE_5___default().string)).isRequired
};

/***/ }),

/***/ "./js/components/RefocusableModalDialog.js":
/*!*************************************************!*\
  !*** ./js/components/RefocusableModalDialog.js ***!
  \*************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _wordpress_compose__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @wordpress/compose */ "../node_modules/@wordpress/compose/build-module/hooks/use-previous/index.js");
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! googlesitekit-components */ "googlesitekit-components");
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_components__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _ModalDialog__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./ModalDialog */ "./js/components/ModalDialog.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * ModalDialog component.
 *
 * Site Kit by Google, Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */



// Use a singleton variable to store the clicked element before any dialog opens.
// We need to do this at the module level since the component may not be mounted
// when the user initiates an action that will open the dialog.

let previouslyClickedElement = null;

// Set up a global event listener to capture the clicked element before any dialog opens.
// This needs to happen at the module level to ensure it's set up before any user interaction.
function setupFocusTracker() {
  if (typeof __webpack_require__.g === 'undefined' || !__webpack_require__.g.document || __webpack_require__.g._googlesitekitModalFocusTrackerInitialized) {
    return;
  }
  function captureActiveElementOnClick(event) {
    // Store the clicked (or keyboard-activated) element when user clicks.
    // This will be the element that was clicked right before the dialog opens.
    const nearestParentButtonOrAnchor = event.target.closest('button, a, input');
    if (nearestParentButtonOrAnchor && !nearestParentButtonOrAnchor.classList.contains('mdc-dialog__cancel-button')) {
      previouslyClickedElement = nearestParentButtonOrAnchor;
    }
  }
  __webpack_require__.g.document.addEventListener('mousedown', captureActiveElementOnClick);
  __webpack_require__.g.document.addEventListener('keydown', event => {
    if (event.key === 'Enter' || event.key === ' ') {
      captureActiveElementOnClick(event);
    }
  });
  __webpack_require__.g._googlesitekitModalFocusTrackerInitialized = true;
}
setupFocusTracker();
function RefocusableModalDialog({
  dialogActive = false,
  refocusQuerySelector = null,
  ...modalDialogProps
}) {
  const handleElementRefocus = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_3__.useCallback)(() => {
    setTimeout(() => {
      const elementToFocus = refocusQuerySelector ? document.querySelector(refocusQuerySelector) : previouslyClickedElement;
      if (elementToFocus && document.body.contains(elementToFocus)) {
        elementToFocus.focus();
      }
      if (!refocusQuerySelector) {
        previouslyClickedElement = null;
      }
    });
  }, [refocusQuerySelector]);
  const previousDialogActive = (0,_wordpress_compose__WEBPACK_IMPORTED_MODULE_4__["default"])(dialogActive);
  // Handle re-focus of the button which triggered the modal.
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_3__.useEffect)(() => {
    if (previousDialogActive === true && dialogActive === false) {
      handleElementRefocus();
    }
    return () => {
      // In majority of cases the modal is conditionally rendered, so dialogActive
      // will not be passed, as component will be unmounted/removed from the DOM.
      handleElementRefocus();
    };
  }, [previousDialogActive, dialogActive, handleElementRefocus]);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)(_ModalDialog__WEBPACK_IMPORTED_MODULE_1__["default"], {
    dialogActive: dialogActive,
    ...modalDialogProps
  });
}
RefocusableModalDialog.propTypes = {
  dialogActive: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().bool),
  refocusQuerySelector: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().string),
  ...googlesitekit_components__WEBPACK_IMPORTED_MODULE_0__.Dialog.propTypes
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (RefocusableModalDialog);

/***/ }),

/***/ "./js/components/ReportError.js":
/*!**************************************!*\
  !*** ./js/components/ReportError.js ***!
  \**************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ ReportError)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_13___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_13__);
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! lodash */ "../node_modules/lodash/lodash.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/googlesitekit/modules/datastore/constants */ "./js/googlesitekit/modules/datastore/constants.js");
/* harmony import */ var _js_util_errors__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/util/errors */ "./js/util/errors.js");
/* harmony import */ var _js_util_insufficient_permissions_error_description__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/util/insufficient-permissions-error-description */ "./js/util/insufficient-permissions-error-description.js");
/* harmony import */ var _js_util_purify__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @/js/util/purify */ "./js/util/purify.js");
/* harmony import */ var _notifications_CTA__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./notifications/CTA */ "./js/components/notifications/CTA.js");
/* harmony import */ var _ReportErrorActions__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./ReportErrorActions */ "./js/components/ReportErrorActions.js");
/* harmony import */ var _js_hooks_useViewOnly__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @/js/hooks/useViewOnly */ "./js/hooks/useViewOnly.js");
/* harmony import */ var _ErrorNotice__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./ErrorNotice */ "./js/components/ErrorNotice.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * ReportError component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */










function ReportError({
  moduleSlug,
  error
}) {
  const isViewOnly = (0,_js_hooks_useViewOnly__WEBPACK_IMPORTED_MODULE_9__["default"])();
  const module = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.useSelect)(select => select(_js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_MODULES).getModule(moduleSlug));
  const errors = Array.isArray(error) ? error : [error];
  let title;
  function getMessage(err) {
    if ((0,_js_util_errors__WEBPACK_IMPORTED_MODULE_4__.isInsufficientPermissionsError)(err)) {
      if (isViewOnly) {
        title = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.sprintf)(/* translators: %s: module name */
        (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Access lost to %s', 'google-site-kit'), module?.name);
        return (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.sprintf)(/* translators: %s: module name */
        (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('The administrator sharing this module with you has lost access to the %s service, so you won’t be able to see stats from it on the Site Kit dashboard. You can contact them or another administrator to restore access.', 'google-site-kit'), module?.name);
      }
      title = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.sprintf)(/* translators: %s: module name */
      (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Insufficient permissions in %s', 'google-site-kit'), module?.name);
      return (0,_js_util_insufficient_permissions_error_description__WEBPACK_IMPORTED_MODULE_5__.getInsufficientPermissionsErrorDescription)(err.message, module);
    }
    return (0,_js_util_errors__WEBPACK_IMPORTED_MODULE_4__.getReportErrorMessage)(err);
  }
  const uniqueErrors = (0,lodash__WEBPACK_IMPORTED_MODULE_0__.uniqWith)(errors.map(err => ({
    ...err,
    message: getMessage(err),
    reconnectURL: err.data?.reconnectURL
  })), (errorA, errorB) => errorA.message === errorB.message && errorA.reconnectURL === errorB.reconnectURL);
  const hasInsufficientPermissionsError = errors.some(err => (0,_js_util_errors__WEBPACK_IMPORTED_MODULE_4__.isInsufficientPermissionsError)(err));
  if (!hasInsufficientPermissionsError && uniqueErrors.length === 1) {
    title = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.sprintf)(/* translators: %s: module name */
    (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Data error in %s', 'google-site-kit'), module?.name);
  } else if (!hasInsufficientPermissionsError && uniqueErrors.length > 1) {
    title = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.sprintf)(/* translators: %s: module name */
    (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Data errors in %s', 'google-site-kit'), module?.name);
  }
  const description = /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_wordpress_element__WEBPACK_IMPORTED_MODULE_12__.Fragment, {
    children: uniqueErrors.map(errorForNotice => {
      const reconnectURL = errorForNotice?.data?.reconnectURL;
      return reconnectURL ? /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_ErrorNotice__WEBPACK_IMPORTED_MODULE_10__["default"], {
        error: errorForNotice,
        message: errorForNotice.message
      }, errorForNotice.message) : /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("p", {
        children: _js_util_purify__WEBPACK_IMPORTED_MODULE_6__.purify.sanitize(errorForNotice.message, {
          // Ensures no HTML tags are passed as they would be
          // escaped by React and appear as strings.
          ALLOWED_TAGS: []
        })
      }, errorForNotice.message);
    })
  });
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_notifications_CTA__WEBPACK_IMPORTED_MODULE_7__["default"], {
    title: title,
    description: description,
    error: true,
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_ReportErrorActions__WEBPACK_IMPORTED_MODULE_8__["default"], {
      moduleSlug: moduleSlug,
      error: error
    })
  });
}
ReportError.propTypes = {
  moduleSlug: (prop_types__WEBPACK_IMPORTED_MODULE_13___default().string).isRequired,
  error: prop_types__WEBPACK_IMPORTED_MODULE_13___default().oneOfType([prop_types__WEBPACK_IMPORTED_MODULE_13___default().arrayOf((prop_types__WEBPACK_IMPORTED_MODULE_13___default().object)), (prop_types__WEBPACK_IMPORTED_MODULE_13___default().object)]).isRequired
};

/***/ }),

/***/ "./js/components/ReportErrorActions.js":
/*!*********************************************!*\
  !*** ./js/components/ReportErrorActions.js ***!
  \*********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ ReportErrorActions)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_11___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_11__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/@wordpress/element/build-module/create-interpolate-element.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! googlesitekit-components */ "googlesitekit-components");
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_components__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/googlesitekit/datastore/site/constants */ "./js/googlesitekit/datastore/site/constants.js");
/* harmony import */ var _js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/googlesitekit/modules/datastore/constants */ "./js/googlesitekit/modules/datastore/constants.js");
/* harmony import */ var _js_util_errors__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/util/errors */ "./js/util/errors.js");
/* harmony import */ var _js_hooks_useViewOnly__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @/js/hooks/useViewOnly */ "./js/hooks/useViewOnly.js");
/* harmony import */ var _Link__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./Link */ "./js/components/Link.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * ReportErrorActions component.
 *
 * Site Kit by Google, Copyright 2022 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */








function ReportErrorActions(props) {
  const {
    moduleSlug,
    error,
    GetHelpLink,
    hideGetHelpLink,
    buttonVariant,
    onRetry,
    onRequestAccess,
    getHelpClassName,
    RequestAccessButton,
    RetryButton
  } = props;
  const isViewOnly = (0,_js_hooks_useViewOnly__WEBPACK_IMPORTED_MODULE_6__["default"])();
  const storeName = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_4__.CORE_MODULES).getModuleStoreName(moduleSlug));
  const requestAccessURL = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => typeof select(storeName)?.getServiceEntityAccessURL === 'function' ? select(storeName).getServiceEntityAccessURL() : null);
  const errors = Array.isArray(error) ? error : [error];
  const errorsWithSelectorData = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => errors.map(err => {
    const selectorData = select(storeName)?.getSelectorDataForError(err);
    return {
      ...err,
      selectorData
    };
  }));
  const retryableErrors = errorsWithSelectorData?.filter(err => (0,_js_util_errors__WEBPACK_IMPORTED_MODULE_5__.isErrorRetryable)(err, err.selectorData) && err.selectorData.name === 'getReport');
  const showRetry = !!retryableErrors.length;
  const errorTroubleshootingLinkURL = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => {
    const err = {
      ...(showRetry ? retryableErrors[0] : errors[0])
    };
    if ((0,_js_util_errors__WEBPACK_IMPORTED_MODULE_5__.isInsufficientPermissionsError)(err)) {
      err.code = `${moduleSlug}_insufficient_permissions`;
    }
    return select(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_SITE).getErrorTroubleshootingLinkURL(err);
  });
  const dispatch = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useDispatch)();
  const hasInsufficientPermissionsError = errors.some(err => (0,_js_util_errors__WEBPACK_IMPORTED_MODULE_5__.isInsufficientPermissionsError)(err));
  const handleRetry = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.useCallback)(() => {
    retryableErrors.forEach(err => {
      const {
        selectorData
      } = err;
      dispatch(selectorData.storeName).invalidateResolution(selectorData.name, selectorData.args);
    });
    onRetry?.();
  }, [dispatch, retryableErrors, onRetry]);
  const showRequestAccessURL = requestAccessURL && hasInsufficientPermissionsError && !isViewOnly;
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsxs)("div", {
    className: "googlesitekit-report-error-actions",
    children: [showRequestAccessURL && (typeof RequestAccessButton === 'function' ? /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(RequestAccessButton, {
      requestAccessURL: requestAccessURL
    }) : /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_2__.Button, {
      onClick: onRequestAccess,
      href: requestAccessURL,
      target: "_blank",
      danger: buttonVariant === 'danger',
      tertiary: buttonVariant === 'tertiary',
      children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Request access', 'google-site-kit')
    })), showRetry && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsxs)(_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.Fragment, {
      children: [typeof RetryButton === 'function' ? /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(RetryButton, {
        handleRetry: handleRetry
      }) : /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_2__.Button, {
        onClick: handleRetry,
        danger: buttonVariant === 'danger',
        tertiary: buttonVariant === 'tertiary',
        children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Retry', 'google-site-kit')
      }), !hideGetHelpLink && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)("span", {
        className: "googlesitekit-error-retry-text",
        children: (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_10__["default"])((0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Retry didn’t work? <HelpLink />', 'google-site-kit'), {
          HelpLink: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(_Link__WEBPACK_IMPORTED_MODULE_7__["default"], {
            href: errorTroubleshootingLinkURL,
            external: true,
            hideExternalIndicator: true,
            children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Get help', 'google-site-kit')
          })
        })
      })]
    }), !showRetry && !hideGetHelpLink && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)("div", {
      className: getHelpClassName,
      children: typeof GetHelpLink === 'function' ? /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(GetHelpLink, {
        linkURL: errorTroubleshootingLinkURL
      }) : /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(_Link__WEBPACK_IMPORTED_MODULE_7__["default"], {
        href: errorTroubleshootingLinkURL,
        external: true,
        hideExternalIndicator: true,
        children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Get help', 'google-site-kit')
      })
    })]
  });
}
ReportErrorActions.propTypes = {
  moduleSlug: (prop_types__WEBPACK_IMPORTED_MODULE_11___default().string).isRequired,
  error: prop_types__WEBPACK_IMPORTED_MODULE_11___default().oneOfType([prop_types__WEBPACK_IMPORTED_MODULE_11___default().arrayOf((prop_types__WEBPACK_IMPORTED_MODULE_11___default().object)), (prop_types__WEBPACK_IMPORTED_MODULE_11___default().object)]).isRequired,
  GetHelpLink: (prop_types__WEBPACK_IMPORTED_MODULE_11___default().elementType),
  hideGetHelpLink: (prop_types__WEBPACK_IMPORTED_MODULE_11___default().bool),
  buttonVariant: (prop_types__WEBPACK_IMPORTED_MODULE_11___default().string),
  onRetry: (prop_types__WEBPACK_IMPORTED_MODULE_11___default().func),
  onRequestAccess: (prop_types__WEBPACK_IMPORTED_MODULE_11___default().func),
  getHelpClassName: (prop_types__WEBPACK_IMPORTED_MODULE_11___default().string),
  RequestAccessButton: (prop_types__WEBPACK_IMPORTED_MODULE_11___default().elementType),
  RetryButton: (prop_types__WEBPACK_IMPORTED_MODULE_11___default().elementType)
};

/***/ }),

/***/ "./js/components/ReportErrorButton/index.js":
/*!**************************************************!*\
  !*** ./js/components/ReportErrorButton/index.js ***!
  \**************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var clipboard_copy__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! clipboard-copy */ "../node_modules/clipboard-copy/index.js");
/* harmony import */ var clipboard_copy__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(clipboard_copy__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @wordpress/icons */ "../node_modules/@wordpress/icons/build-module/icon/index.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @wordpress/icons */ "../node_modules/@wordpress/icons/build-module/library/check.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @wordpress/icons */ "../node_modules/@wordpress/icons/build-module/library/stack.js");
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! googlesitekit-components */ "googlesitekit-components");
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_components__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * ReportErrorButton component.
 *
 * Site Kit by Google, Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * WordPress dependencies
 */




/**
 * Internal dependencies
 */


function ReportErrorButton({
  message,
  componentStack
}) {
  const [copied, setCopied] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_4__.useState)(false);
  function onErrorClick() {
    // Copy message with wrapping backticks for code block formatting on wp.org.
    clipboard_copy__WEBPACK_IMPORTED_MODULE_0___default()(`\`\`\`\n${message}\n${componentStack}\n\`\`\``);
    setCopied(true);
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_2__.Button, {
    "aria-label": copied ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Error message copied to clipboard. Click to copy the error message again.', 'google-site-kit') : undefined,
    onClick: onErrorClick,
    trailingIcon: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_icons__WEBPACK_IMPORTED_MODULE_5__["default"], {
      className: "mdc-button__icon",
      icon: copied ? _wordpress_icons__WEBPACK_IMPORTED_MODULE_6__["default"] : _wordpress_icons__WEBPACK_IMPORTED_MODULE_7__["default"]
    }),
    children: copied ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Copied to clipboard', 'google-site-kit') : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Copy error contents', 'google-site-kit')
  });
}
ReportErrorButton.propTypes = {
  message: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().string),
  componentStack: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().string)
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ReportErrorButton);

/***/ }),

/***/ "./js/components/ReportZero.js":
/*!*************************************!*\
  !*** ./js/components/ReportZero.js ***!
  \*************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ ReportZero)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/googlesitekit/modules/datastore/constants */ "./js/googlesitekit/modules/datastore/constants.js");
/* harmony import */ var _notifications_CTA__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./notifications/CTA */ "./js/components/notifications/CTA.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * ReportZero component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */




function ReportZero({
  moduleSlug
}) {
  const module = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_2__.CORE_MODULES).getModule(moduleSlug));
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(_notifications_CTA__WEBPACK_IMPORTED_MODULE_3__["default"], {
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.sprintf)(/* translators: %s: Module name */
    (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('%s Gathering Data', 'google-site-kit'), module?.name),
    description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.sprintf)(/* translators: %s: Module name */
    (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('%s data is not yet available, please check back later', 'google-site-kit'), module?.name)
  });
}
ReportZero.propTypes = {
  moduleSlug: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().string).isRequired
};

/***/ }),

/***/ "./js/components/ResetButton.js":
/*!**************************************!*\
  !*** ./js/components/ResetButton.js ***!
  \**************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/@wordpress/element/build-module/create-interpolate-element.js");
/* harmony import */ var _wordpress_keycodes__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! @wordpress/keycodes */ "../node_modules/@wordpress/keycodes/build-module/index.js");
/* harmony import */ var _js_hooks_useDebounce__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/hooks/useDebounce */ "./js/hooks/useDebounce.js");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _ModalDialog__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./ModalDialog */ "./js/components/ModalDialog.js");
/* harmony import */ var _js_googlesitekit_api_cache__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/googlesitekit/api/cache */ "./js/googlesitekit/api/cache.js");
/* harmony import */ var _Portal__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./Portal */ "./js/components/Portal.js");
/* harmony import */ var _Link__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./Link */ "./js/components/Link.js");
/* harmony import */ var _js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @/js/googlesitekit/datastore/site/constants */ "./js/googlesitekit/datastore/site/constants.js");
/* harmony import */ var _js_googlesitekit_datastore_location_constants__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @/js/googlesitekit/datastore/location/constants */ "./js/googlesitekit/datastore/location/constants.js");
/* harmony import */ var _js_util_tracking__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @/js/util/tracking */ "./js/util/tracking/index.js");
/* harmony import */ var _js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @/js/hooks/useViewContext */ "./js/hooks/useViewContext.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * ResetButton component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */





/**
 * Internal dependencies
 */










function ResetButton({
  children
}) {
  const postResetURL = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.useSelect)(select => select(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_7__.CORE_SITE).getAdminURL('googlesitekit-splash', {
    notification: 'reset_success'
  }));
  const isDoingReset = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.useSelect)(select => select(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_7__.CORE_SITE).isDoingReset());
  const isNavigatingToPostResetURL = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.useSelect)(select => select(_js_googlesitekit_datastore_location_constants__WEBPACK_IMPORTED_MODULE_8__.CORE_LOCATION).isNavigatingTo(postResetURL || ''));
  const [inProgress, setInProgress] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_12__.useState)(false);
  const [dialogActive, setDialogActive] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_12__.useState)(false);

  /*
   * Using debounce here because the spinner has to render across two separate calls.
   * Rather than risk it flickering on and off in between the reset call completing and
   * the navigate call starting, we will just set a debounce to keep the spinner for 3 seconds.
   */
  const debouncedSetInProgress = (0,_js_hooks_useDebounce__WEBPACK_IMPORTED_MODULE_1__.useDebounce)(setInProgress, 3000);
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_12__.useEffect)(() => {
    if (isDoingReset || isNavigatingToPostResetURL) {
      setInProgress(true);
    } else {
      debouncedSetInProgress(false);
    }
  }, [isDoingReset, isNavigatingToPostResetURL, debouncedSetInProgress]);
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_12__.useEffect)(() => {
    function handleCloseModal(event) {
      if (_wordpress_keycodes__WEBPACK_IMPORTED_MODULE_13__.ESCAPE === event.keyCode) {
        // Only close the modal if the "Escape" key is pressed.
        setDialogActive(false);
      }
    }
    if (dialogActive) {
      // When the dialogActive changes and it is set to true(has opened), add the event listener.
      __webpack_require__.g.addEventListener('keyup', handleCloseModal, false);
    }
    // Remove the event listener when the dialog is removed; there's no need
    // to have it attached when it won't be used.
    return () => {
      if (dialogActive) {
        // When the dialogActive is true(is open) and its value changes, remove the event listener.
        __webpack_require__.g.removeEventListener('keyup', handleCloseModal);
      }
    };
  }, [dialogActive]);
  const {
    reset
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.useDispatch)(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_7__.CORE_SITE);
  const {
    navigateTo
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.useDispatch)(_js_googlesitekit_datastore_location_constants__WEBPACK_IMPORTED_MODULE_8__.CORE_LOCATION);
  const viewContext = (0,_js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_10__["default"])();
  const handleUnlinkConfirm = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_12__.useCallback)(async () => {
    await reset();
    await (0,_js_googlesitekit_api_cache__WEBPACK_IMPORTED_MODULE_4__.clearCache)();
    await (0,_js_util_tracking__WEBPACK_IMPORTED_MODULE_9__.trackEvent)(viewContext, 'reset_plugin');
    navigateTo(postResetURL);
  }, [navigateTo, postResetURL, reset, viewContext]);
  const openDialog = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_12__.useCallback)(() => {
    setDialogActive(true);
  }, []);
  const closeDialog = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_12__.useCallback)(() => {
    setDialogActive(false);
  }, []);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)(_wordpress_element__WEBPACK_IMPORTED_MODULE_12__.Fragment, {
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_Link__WEBPACK_IMPORTED_MODULE_6__["default"], {
      className: "googlesitekit-reset-button",
      onClick: openDialog,
      children: children || (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Reset Site Kit', 'google-site-kit')
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_Portal__WEBPACK_IMPORTED_MODULE_5__["default"], {
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_ModalDialog__WEBPACK_IMPORTED_MODULE_3__["default"], {
        dialogActive: dialogActive,
        handleConfirm: handleUnlinkConfirm,
        handleCancel: closeDialog,
        onClose: closeDialog,
        title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Reset Site Kit', 'google-site-kit'),
        subtitle: (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_14__["default"])((0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Resetting will disconnect all users and remove all Site Kit settings and data within WordPress. <br />You and any other users who wish to use Site Kit will need to reconnect to restore access.', 'google-site-kit'), {
          br: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("br", {})
        }),
        confirmButton: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Reset', 'google-site-kit'),
        inProgress: inProgress,
        danger: true,
        small: true
      })
    })]
  });
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ResetButton);

/***/ }),

/***/ "./js/components/RestoreSnapshots/index.js":
/*!*************************************************!*\
  !*** ./js/components/RestoreSnapshots/index.js ***!
  \*************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _js_googlesitekit_data_create_snapshot_store__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/googlesitekit/data/create-snapshot-store */ "./js/googlesitekit/data/create-snapshot-store.js");
/**
 * Snapshot restoration component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */


function RestoreSnapshots({
  children
}) {
  const registry = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useRegistry)();
  const [restoredSnapshots, setRestoredSnapshots] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(false);
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useEffect)(() => {
    if (!restoredSnapshots) {
      (async () => {
        await (0,_js_googlesitekit_data_create_snapshot_store__WEBPACK_IMPORTED_MODULE_1__.restoreAllSnapshots)(registry);
        setRestoredSnapshots(true);
      })();
    }
  }, [registry, restoredSnapshots]);
  if (!restoredSnapshots) {
    return null;
  }
  return children;
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (RestoreSnapshots);

/***/ }),

/***/ "./js/components/Root/ViewContextContext.js":
/*!**************************************************!*\
  !*** ./js/components/Root/ViewContextContext.js ***!
  \**************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Consumer: () => (/* binding */ Consumer),
/* harmony export */   Provider: () => (/* binding */ Provider),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/**
 * View Context context for React components.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */

const ViewContextContext = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createContext)('');
const {
  Consumer,
  Provider
} = ViewContextContext;
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ViewContextContext);

/***/ }),

/***/ "./js/components/Root/index.js":
/*!*************************************!*\
  !*** ./js/components/Root/index.js ***!
  \*************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Root)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_14___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_14__);
/* harmony import */ var _material_ui_core__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @material-ui/core */ "../node_modules/@material-ui/core/esm/styles/createMuiStrictModeTheme.js");
/* harmony import */ var _material_ui_core__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! @material-ui/core */ "../node_modules/@material-ui/styles/esm/ThemeProvider/ThemeProvider.js");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _js_components_ErrorHandler__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/components/ErrorHandler */ "./js/components/ErrorHandler/index.js");
/* harmony import */ var _js_components_FeaturesProvider__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/components/FeaturesProvider */ "./js/components/FeaturesProvider/index.js");
/* harmony import */ var _js_features__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/features */ "./js/features/index.js");
/* harmony import */ var _js_components_PermissionsModal__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/components/PermissionsModal */ "./js/components/PermissionsModal/index.js");
/* harmony import */ var _js_components_RestoreSnapshots__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/components/RestoreSnapshots */ "./js/components/RestoreSnapshots/index.js");
/* harmony import */ var _js_components_FeatureTours__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @/js/components/FeatureTours */ "./js/components/FeatureTours.js");
/* harmony import */ var _ViewContextContext__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./ViewContextContext */ "./js/components/Root/ViewContextContext.js");
/* harmony import */ var _js_components_InViewProvider__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @/js/components/InViewProvider */ "./js/components/InViewProvider/index.js");
/* harmony import */ var _js_util_is_site_kit_screen__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @/js/util/is-site-kit-screen */ "./js/util/is-site-kit-screen.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Root component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */











function Root({
  children,
  registry,
  viewContext = null
}) {
  const theme =  false ? 0 : _material_ui_core__WEBPACK_IMPORTED_MODULE_11__["default"]; // eslint-disable-line camelcase

  const [inViewState] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_12__.useState)({
    key: 'Root',
    value: true
  });
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)(_wordpress_element__WEBPACK_IMPORTED_MODULE_12__.StrictMode, {
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)(_js_components_InViewProvider__WEBPACK_IMPORTED_MODULE_8__["default"], {
      value: inViewState,
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)(googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.RegistryProvider, {
        value: registry,
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)(_js_components_FeaturesProvider__WEBPACK_IMPORTED_MODULE_2__["default"], {
          value: _js_features__WEBPACK_IMPORTED_MODULE_3__.enabledFeatures,
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)(_ViewContextContext__WEBPACK_IMPORTED_MODULE_7__.Provider, {
            value: viewContext,
            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)(_material_ui_core__WEBPACK_IMPORTED_MODULE_13__["default"], {
              theme: theme(),
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsxs)(_js_components_ErrorHandler__WEBPACK_IMPORTED_MODULE_1__["default"], {
                children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsxs)(_js_components_RestoreSnapshots__WEBPACK_IMPORTED_MODULE_5__["default"], {
                  children: [children, viewContext && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)(_js_components_FeatureTours__WEBPACK_IMPORTED_MODULE_6__["default"], {})]
                }), (0,_js_util_is_site_kit_screen__WEBPACK_IMPORTED_MODULE_9__.isSiteKitScreen)(viewContext) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)(_js_components_PermissionsModal__WEBPACK_IMPORTED_MODULE_4__["default"], {})]
              })
            })
          })
        })
      })
    })
  });
}
Root.propTypes = {
  children: (prop_types__WEBPACK_IMPORTED_MODULE_14___default().node),
  registry: (prop_types__WEBPACK_IMPORTED_MODULE_14___default().object),
  viewContext: (prop_types__WEBPACK_IMPORTED_MODULE_14___default().string).isRequired
};
Root.defaultProps = {
  registry: (googlesitekit_data__WEBPACK_IMPORTED_MODULE_0___default())
};

/***/ }),

/***/ "./js/components/SelectionBox.js":
/*!***************************************!*\
  !*** ./js/components/SelectionBox.js ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ SelectionBox)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-components */ "googlesitekit-components");
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * SelectionBox component.
 *
 * Site Kit by Google, Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * Internal dependencies
 */


function SelectionBox({
  badge,
  checked,
  children,
  disabled,
  id,
  onChange,
  title,
  value
}) {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("div", {
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-selection-box', {
      'googlesitekit-selection-box--disabled': disabled
    }),
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__.Checkbox, {
      checked: checked,
      description: children,
      disabled: disabled,
      id: id,
      name: id,
      onChange: onChange,
      value: value,
      badge: badge,
      children: title
    })
  });
}
SelectionBox.propTypes = {
  badge: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().node),
  checked: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().bool),
  children: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().node),
  disabled: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().bool),
  id: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  onChange: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().func),
  title: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  value: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string)
};

/***/ }),

/***/ "./js/components/SelectionPanel/SelectionPanel.js":
/*!********************************************************!*\
  !*** ./js/components/SelectionPanel/SelectionPanel.js ***!
  \********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ SelectionPanel)
/* harmony export */ });
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _js_components_SideSheet__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/components/SideSheet */ "./js/components/SideSheet.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Selection Panel component.
 *
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * Internal dependencies
 */


function SelectionPanel({
  children,
  isOpen,
  isLoading,
  onOpen,
  closePanel,
  className
}) {
  const classNameSelector = className?.split(/\s+/).map(name => `.${name}`).join('');
  const initialFocus = classNameSelector ? `${classNameSelector} .googlesitekit-selection-panel-item .googlesitekit-selection-box input` : '.googlesitekit-selection-panel-item .googlesitekit-selection-box input';
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)(_js_components_SideSheet__WEBPACK_IMPORTED_MODULE_1__["default"], {
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-selection-panel', className),
    isOpen: isOpen,
    isLoading: isLoading,
    onOpen: onOpen,
    closeSheet: closePanel,
    focusTrapOptions: {
      initialFocus
    },
    children: children
  });
}
SelectionPanel.propTypes = {
  children: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().node),
  isOpen: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().bool),
  isLoading: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().bool),
  onOpen: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().func),
  closePanel: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().func),
  className: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string)
};

/***/ }),

/***/ "./js/components/SelectionPanel/SelectionPanelFooter.js":
/*!**************************************************************!*\
  !*** ./js/components/SelectionPanel/SelectionPanelFooter.js ***!
  \**************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ SelectionPanelFooter)
/* harmony export */ });
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! lodash */ "../node_modules/lodash/lodash.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_12___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_12__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/@wordpress/element/build-module/create-interpolate-element.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! googlesitekit-components */ "googlesitekit-components");
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_components__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _js_components_ErrorNotice__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/components/ErrorNotice */ "./js/components/ErrorNotice.js");
/* harmony import */ var _js_util__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/util */ "./js/util/index.js");
/* harmony import */ var _js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @/js/modules/analytics-4/datastore/constants */ "./js/modules/analytics-4/datastore/constants.js");
/* harmony import */ var _js_components_PreviewBlock__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @/js/components/PreviewBlock */ "./js/components/PreviewBlock.js");
/* harmony import */ var _js_components_Notice__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @/js/components/Notice */ "./js/components/Notice/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Selection Panel Footer component.
 *
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */








function SelectionPanelFooter({
  savedItemSlugs = [],
  selectedItemSlugs = [],
  saveSettings = () => {},
  saveError,
  itemLimitError,
  minSelectedItemCount = 0,
  maxSelectedItemCount = 0,
  isBusy,
  onSaveSuccess = () => {},
  onCancel = () => {},
  isOpen,
  closePanel = () => {}
}) {
  const [finalButtonText, setFinalButtonText] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_10__.useState)(null);
  const [wasSaved, setWasSaved] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_10__.useState)(false);
  const isLoading = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.useSelect)(select => select(_js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_6__.MODULES_ANALYTICS_4).isFetchingSyncAvailableAudiences());
  const haveSettingsChanged = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_10__.useMemo)(() => {
    // Arrays need to be sorted to match in `isEqual`.
    return !(0,lodash__WEBPACK_IMPORTED_MODULE_0__.isEqual)((0,_js_util__WEBPACK_IMPORTED_MODULE_5__.safelySort)(selectedItemSlugs), (0,_js_util__WEBPACK_IMPORTED_MODULE_5__.safelySort)(savedItemSlugs));
  }, [savedItemSlugs, selectedItemSlugs]);
  const currentButtonText = savedItemSlugs?.length > 0 && haveSettingsChanged ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Apply changes', 'google-site-kit') : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Save selection', 'google-site-kit');
  const onSaveClick = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_10__.useCallback)(async () => {
    const {
      error
    } = await saveSettings(selectedItemSlugs);
    if (!error) {
      onSaveSuccess();

      // Close the panel after saving.
      closePanel();

      // Lock the button label while panel is closing.
      setFinalButtonText(currentButtonText);
      setWasSaved(true);
    }
  }, [saveSettings, selectedItemSlugs, onSaveSuccess, closePanel, currentButtonText]);
  const onCancelClick = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_10__.useCallback)(() => {
    closePanel();
    onCancel();
  }, [closePanel, onCancel]);
  const [prevIsOpen, setPrevIsOpen] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_10__.useState)(null);
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_10__.useEffect)(() => {
    if (prevIsOpen !== null) {
      // If current isOpen is true, and different from prevIsOpen
      // meaning it transitioned from false to true and it is not
      // in closing transition, we should reset the button label
      // locked when save button was clicked.
      if (prevIsOpen !== isOpen) {
        if (isOpen) {
          setFinalButtonText(null);
          setWasSaved(false);
        }
      }
    }
    setPrevIsOpen(isOpen);
  }, [isOpen, prevIsOpen]);
  const selectedItemCount = selectedItemSlugs?.length || 0;
  const itemCountElement = isLoading ? /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)(_js_components_PreviewBlock__WEBPACK_IMPORTED_MODULE_7__["default"], {
    width: "89px",
    height: "20px"
  }) : /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)("p", {
    className: "googlesitekit-selection-panel-footer__item-count",
    children: (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_11__["default"])((0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.sprintf)(/* translators: 1: Number of selected items. 2: Maximum number of items that can be selected. */
    (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('%1$d selected <MaxCount>(up to %2$d)</MaxCount>', 'google-site-kit'), selectedItemCount, maxSelectedItemCount), {
      MaxCount: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)("span", {
        className: "googlesitekit-selection-panel-footer__item-count--max-count"
      })
    })
  });
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsxs)("footer", {
    className: "googlesitekit-selection-panel-footer",
    children: [saveError && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)(_js_components_ErrorNotice__WEBPACK_IMPORTED_MODULE_4__["default"], {
      error: saveError
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsxs)("div", {
      className: "googlesitekit-selection-panel-footer__content",
      children: [haveSettingsChanged && itemLimitError ? /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)(_js_components_Notice__WEBPACK_IMPORTED_MODULE_8__["default"], {
        type: _js_components_Notice__WEBPACK_IMPORTED_MODULE_8__["default"].TYPES.ERROR,
        description: itemLimitError
      }) : itemCountElement, /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsxs)("div", {
        className: "googlesitekit-selection-panel-footer__actions",
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_3__.Button, {
          onClick: onCancelClick,
          disabled: isBusy,
          tertiary: true,
          children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Cancel', 'google-site-kit')
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_3__.SpinnerButton, {
          onClick: onSaveClick,
          isSaving: isBusy,
          disabled: selectedItemCount < minSelectedItemCount || selectedItemCount > maxSelectedItemCount || isBusy || !isOpen && wasSaved,
          children: finalButtonText || currentButtonText
        })]
      })]
    })]
  });
}
SelectionPanelFooter.propTypes = {
  savedItemSlugs: (prop_types__WEBPACK_IMPORTED_MODULE_12___default().array),
  selectedItemSlugs: (prop_types__WEBPACK_IMPORTED_MODULE_12___default().array),
  saveSettings: (prop_types__WEBPACK_IMPORTED_MODULE_12___default().func),
  saveError: (prop_types__WEBPACK_IMPORTED_MODULE_12___default().object),
  itemLimitError: (prop_types__WEBPACK_IMPORTED_MODULE_12___default().string),
  minSelectedItemCount: (prop_types__WEBPACK_IMPORTED_MODULE_12___default().number),
  maxSelectedItemCount: (prop_types__WEBPACK_IMPORTED_MODULE_12___default().number),
  isBusy: (prop_types__WEBPACK_IMPORTED_MODULE_12___default().bool),
  onSaveSuccess: (prop_types__WEBPACK_IMPORTED_MODULE_12___default().func),
  onCancel: (prop_types__WEBPACK_IMPORTED_MODULE_12___default().func),
  isOpen: (prop_types__WEBPACK_IMPORTED_MODULE_12___default().bool),
  closePanel: (prop_types__WEBPACK_IMPORTED_MODULE_12___default().func)
};

/***/ }),

/***/ "./js/components/SelectionPanel/SelectionPanelHeader.js":
/*!**************************************************************!*\
  !*** ./js/components/SelectionPanel/SelectionPanelHeader.js ***!
  \**************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ SelectionPanelHeader)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _js_components_Link__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @/js/components/Link */ "./js/components/Link.js");
/* harmony import */ var _svg_icons_close_svg__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/svg/icons/close.svg */ "./svg/icons/close.svg");
/* harmony import */ var _js_components_Typography__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/components/Typography */ "./js/components/Typography/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Selection Panel Header component.
 *
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * Internal dependencies
 */




function SelectionPanelHeader({
  children,
  title,
  onCloseClick
}) {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("header", {
    className: "googlesitekit-selection-panel-header",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
      className: "googlesitekit-selection-panel-header__row",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_js_components_Typography__WEBPACK_IMPORTED_MODULE_2__["default"], {
        as: "h3",
        size: "small",
        type: "headline",
        children: title
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_js_components_Link__WEBPACK_IMPORTED_MODULE_0__["default"], {
        className: "googlesitekit-selection-panel-header__close",
        onClick: onCloseClick,
        linkButton: true,
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_svg_icons_close_svg__WEBPACK_IMPORTED_MODULE_1__["default"], {
          width: "15",
          height: "15"
        })
      })]
    }), children]
  });
}
SelectionPanelHeader.propTypes = {
  children: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().node),
  title: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().string),
  onCloseClick: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().func)
};

/***/ }),

/***/ "./js/components/SelectionPanel/SelectionPanelItem.js":
/*!************************************************************!*\
  !*** ./js/components/SelectionPanel/SelectionPanelItem.js ***!
  \************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ SelectionPanelItem)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _js_components_SelectionBox__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/components/SelectionBox */ "./js/components/SelectionBox.js");
/* harmony import */ var _js_components_Badge__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/components/Badge */ "./js/components/Badge.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Selection Panel Item component.
 *
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */



function SelectionPanelItem({
  children,
  id,
  slug,
  title,
  description,
  isItemSelected,
  isItemDisabled,
  onCheckboxChange,
  subtitle,
  suffix,
  badge,
  isNewlyDetected
}) {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
    className: "googlesitekit-selection-panel-item",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)(_js_components_SelectionBox__WEBPACK_IMPORTED_MODULE_1__["default"], {
      badge: badge,
      checked: isItemSelected,
      disabled: isItemDisabled,
      id: id,
      onChange: onCheckboxChange,
      title: title,
      value: slug,
      children: [subtitle && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("span", {
        className: "googlesitekit-selection-panel-item__subtitle",
        children: subtitle
      }), description, children]
    }), isNewlyDetected && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_js_components_Badge__WEBPACK_IMPORTED_MODULE_2__["default"], {
      label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('New', 'google-site-kit')
    }), suffix && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("span", {
      className: "googlesitekit-selection-panel-item__suffix",
      children: suffix
    })]
  });
}
SelectionPanelItem.propTypes = {
  children: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().node),
  id: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().string),
  slug: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().string),
  title: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().string),
  description: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().string),
  isItemSelected: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().bool),
  isItemDisabled: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().bool),
  onCheckboxChange: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().func),
  subtitle: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().string),
  suffix: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().node),
  badge: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().node),
  isNewlyDetected: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().bool)
};

/***/ }),

/***/ "./js/components/SelectionPanel/SelectionPanelItems.js":
/*!*************************************************************!*\
  !*** ./js/components/SelectionPanel/SelectionPanelItems.js ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ SelectionPanelItems)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Selection Panel Items component.
 *
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */



function SelectionPanelItems({
  currentSelectionTitle = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Current selection', 'google-site-kit'),
  availableItemsTitle = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Additional items', 'google-site-kit'),
  savedItemSlugs = [],
  availableSavedItems = {},
  availableUnsavedItems = {},
  ItemComponent,
  notice
}) {
  function renderItems(items) {
    return Object.keys(items).map(slug => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)(ItemComponent, {
      slug: slug,
      savedItemSlugs: savedItemSlugs,
      ...items[slug]
    }, slug));
  }
  const availableUnsavedItemsCount = Object.keys(availableUnsavedItems).length;
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsxs)("div", {
    className: "googlesitekit-selection-panel-items",
    children: [
    // Split list into two sections with sub-headings for current selection and
    // additional items if there are already saved items.
    savedItemSlugs.length !== 0 && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsxs)(_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.Fragment, {
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("p", {
        className: "googlesitekit-selection-panel-items__subheading",
        children: currentSelectionTitle
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", {
        className: "googlesitekit-selection-panel-items__subsection",
        children: renderItems(availableSavedItems)
      }), availableUnsavedItemsCount > 0 && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("p", {
        className: "googlesitekit-selection-panel-items__subheading",
        children: availableItemsTitle
      })]
    }), availableUnsavedItemsCount > 0 && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", {
      className: "googlesitekit-selection-panel-items__subsection",
      children: renderItems(availableUnsavedItems)
    }), notice]
  });
}
SelectionPanelItems.propTypes = {
  currentSelectionTitle: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  availableItemsTitle: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  savedItemSlugs: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().array),
  availableSavedItems: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().object),
  availableUnsavedItems: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().object),
  ItemComponent: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().elementType),
  notice: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().node)
};

/***/ }),

/***/ "./js/components/SelectionPanel/index.js":
/*!***********************************************!*\
  !*** ./js/components/SelectionPanel/index.js ***!
  \***********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   SelectionPanelFooter: () => (/* reexport safe */ _SelectionPanelFooter__WEBPACK_IMPORTED_MODULE_4__["default"]),
/* harmony export */   SelectionPanelHeader: () => (/* reexport safe */ _SelectionPanelHeader__WEBPACK_IMPORTED_MODULE_1__["default"]),
/* harmony export */   SelectionPanelItem: () => (/* reexport safe */ _SelectionPanelItem__WEBPACK_IMPORTED_MODULE_2__["default"]),
/* harmony export */   SelectionPanelItems: () => (/* reexport safe */ _SelectionPanelItems__WEBPACK_IMPORTED_MODULE_3__["default"]),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _SelectionPanel__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./SelectionPanel */ "./js/components/SelectionPanel/SelectionPanel.js");
/* harmony import */ var _SelectionPanelHeader__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./SelectionPanelHeader */ "./js/components/SelectionPanel/SelectionPanelHeader.js");
/* harmony import */ var _SelectionPanelItem__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./SelectionPanelItem */ "./js/components/SelectionPanel/SelectionPanelItem.js");
/* harmony import */ var _SelectionPanelItems__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./SelectionPanelItems */ "./js/components/SelectionPanel/SelectionPanelItems.js");
/* harmony import */ var _SelectionPanelFooter__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./SelectionPanelFooter */ "./js/components/SelectionPanel/SelectionPanelFooter.js");
/**
 * Selection Panel components.
 *
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Internal dependencies
 */





/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_SelectionPanel__WEBPACK_IMPORTED_MODULE_0__["default"]);

/***/ }),

/***/ "./js/components/SideSheet.js":
/*!************************************!*\
  !*** ./js/components/SideSheet.js ***!
  \************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ SideSheet)
/* harmony export */ });
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var focus_trap_react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! focus-trap-react */ "../node_modules/focus-trap-react/dist/focus-trap-react.js");
/* harmony import */ var focus_trap_react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(focus_trap_react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var react_use__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! react-use */ "../node_modules/react-use/esm/useClickAway.js");
/* harmony import */ var react_use__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! react-use */ "../node_modules/react-use/esm/useKey.js");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _wordpress_keycodes__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @wordpress/keycodes */ "../node_modules/@wordpress/keycodes/build-module/index.js");
/* harmony import */ var _Portal__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./Portal */ "./js/components/Portal.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * SideSheet component
 *
 * This component is named after Material Side Sheets
 * (https://m3.material.io/components/side-sheets/overview), which is
 * planned but not yet implemented for Web. Once available, we could look
 * into moving this to `googlesitekit-components` and replacing it with
 * the Material implementation.
 *
 * Site Kit by Google, Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */





/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */


function SideSheet({
  className,
  children,
  isOpen,
  isLoading,
  onOpen = () => {},
  closeSheet = () => {},
  focusTrapOptions = {}
}) {
  const sideSheetRef = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_4__.useRef)();
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_4__.useEffect)(() => {
    if (isOpen) {
      onOpen();
      document.body.classList.add('googlesitekit-side-sheet-scroll-lock');
    } else {
      document.body.classList.remove('googlesitekit-side-sheet-scroll-lock');
    }
  }, [isOpen, onOpen]);
  (0,react_use__WEBPACK_IMPORTED_MODULE_5__["default"])(sideSheetRef, closeSheet);
  (0,react_use__WEBPACK_IMPORTED_MODULE_6__["default"])(event => isOpen && _wordpress_keycodes__WEBPACK_IMPORTED_MODULE_7__.ESCAPE === event.keyCode, closeSheet);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)(_Portal__WEBPACK_IMPORTED_MODULE_2__["default"], {
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)((focus_trap_react__WEBPACK_IMPORTED_MODULE_1___default()), {
      active: !!isOpen && !isLoading,
      focusTrapOptions: {
        fallbackFocus: 'body',
        ...focusTrapOptions
      },
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("section", {
        ref: sideSheetRef,
        className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-side-sheet', className, {
          'googlesitekit-side-sheet--open': isOpen
        }),
        role: "dialog",
        "aria-modal": "true",
        "aria-hidden": !isOpen,
        tabIndex: "0",
        children: children
      })
    }), isOpen && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("span", {
      className: "googlesitekit-side-sheet-overlay"
    })]
  });
}
SideSheet.propTypes = {
  className: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().string),
  children: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().node),
  isOpen: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().bool),
  isLoading: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().bool),
  onOpen: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().func),
  closeSheet: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().func),
  focusTrapOptions: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().object)
};

/***/ }),

/***/ "./js/components/SourceLink.js":
/*!*************************************!*\
  !*** ./js/components/SourceLink.js ***!
  \*************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/@wordpress/element/build-module/create-interpolate-element.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _Link__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./Link */ "./js/components/Link.js");
/* harmony import */ var _js_hooks_useViewOnly__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/hooks/useViewOnly */ "./js/hooks/useViewOnly.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * SourceLink component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */



function SourceLink({
  name,
  href,
  className,
  external
}) {
  const viewOnlyDashboard = (0,_js_hooks_useViewOnly__WEBPACK_IMPORTED_MODULE_3__["default"])();
  if (viewOnlyDashboard) {
    return null;
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("div", {
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-source-link', className),
    children: (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_5__["default"])((0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.sprintf)(/* translators: %s: source link */
    (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Source: %s', 'google-site-kit'), `<a>${name}</a>`), {
      a: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(_Link__WEBPACK_IMPORTED_MODULE_2__["default"], {
        href: href,
        external: external
      }, "link")
    })
  });
}
SourceLink.propTypes = {
  name: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().string),
  href: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().string),
  className: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().string),
  external: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().bool)
};
SourceLink.defaultProps = {
  name: '',
  href: '',
  className: '',
  external: false
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (SourceLink);

/***/ }),

/***/ "./js/components/Spinner.js":
/*!**********************************!*\
  !*** ./js/components/Spinner.js ***!
  \**********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Spinner component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * A single module. Keeps track of its own active state and settings.
 */

function Spinner({
  isSaving,
  style = {}
}) {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("span", {
    className: "spinner",
    style: {
      display: isSaving ? 'inline-block' : 'none',
      float: 'none',
      marginTop: '0',
      visibility: 'visible',
      ...style
    }
  });
}
Spinner.propTypes = {
  isSaving: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().bool),
  style: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().object)
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Spinner);

/***/ }),

/***/ "./js/components/TourTooltip.js":
/*!**************************************!*\
  !*** ./js/components/TourTooltip.js ***!
  \**************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ TourTooltip)
/* harmony export */ });
/* harmony import */ var _material_react_card__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @material/react-card */ "../node_modules/@material/react-card/dist/index.js");
/* harmony import */ var _material_react_card__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_material_react_card__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! googlesitekit-components */ "googlesitekit-components");
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_components__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _js_util_create_incremental_array_by_size__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/util/create-incremental-array-by-size */ "./js/util/create-incremental-array-by-size.js");
/* harmony import */ var _svg_icons_close_svg__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/svg/icons/close.svg */ "./svg/icons/close.svg");
/* harmony import */ var _Typography__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./Typography */ "./js/components/Typography/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * TourTooltip component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */




/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */





function TourTooltip({
  backProps,
  closeProps,
  index,
  primaryProps,
  size,
  step,
  tooltipProps
}) {
  const indicatorArray = size > 1 ? (0,_js_util_create_incremental_array_by_size__WEBPACK_IMPORTED_MODULE_4__.createIncrementalArrayBySize)(size) : [];
  function getIndicatorClassName(indicatorIndex) {
    return classnames__WEBPACK_IMPORTED_MODULE_1___default()('googlesitekit-tooltip-indicator', {
      active: indicatorIndex === index
    });
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)("div", {
    className: classnames__WEBPACK_IMPORTED_MODULE_1___default()('googlesitekit-tour-tooltip', step.className),
    ...tooltipProps,
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsxs)((_material_react_card__WEBPACK_IMPORTED_MODULE_0___default()), {
      className: "googlesitekit-tooltip-card",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsxs)("div", {
        className: "googlesitekit-tooltip-body",
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_Typography__WEBPACK_IMPORTED_MODULE_6__["default"], {
          as: "h2",
          className: "googlesitekit-tooltip-title",
          size: "medium",
          type: "title",
          children: step.title
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)("div", {
          className: "googlesitekit-tooltip-content",
          children: step.content
        })]
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsxs)(_material_react_card__WEBPACK_IMPORTED_MODULE_0__.CardActions, {
        className: "googlesitekit-tooltip-actions",
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)("ul", {
          className: "googlesitekit-tooltip-indicators",
          children: indicatorArray.map(indicatorIndex => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)("li", {
            className: getIndicatorClassName(indicatorIndex)
          }, `indicator-${indicatorIndex}`))
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsxs)("div", {
          className: "googlesitekit-tooltip-buttons",
          children: [index !== 0 && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_3__.Button, {
            className: "googlesitekit-tooltip-button",
            text: true,
            ...backProps,
            children: backProps.title
          }), step.cta, primaryProps.title && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_3__.Button, {
            className: "googlesitekit-tooltip-button",
            text: true,
            ...primaryProps,
            children: primaryProps.title
          })]
        })]
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_3__.Button, {
        className: "googlesitekit-tooltip-close",
        icon: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_svg_icons_close_svg__WEBPACK_IMPORTED_MODULE_5__["default"], {
          width: "14",
          height: "14"
        }),
        onClick: closeProps.onClick,
        "aria-label": (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Close', 'google-site-kit'),
        text: true,
        hideTooltipTitle: true
      })]
    })
  });
}

/**
 * All props are provided directly from `react-joyride`, intended for custom components.
 *
 * @since 1.28.0
 * @see {@link https://docs.react-joyride.com/custom-components#props-1}.
 */
TourTooltip.propTypes = {
  backProps: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().object).isRequired,
  closeProps: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().object).isRequired,
  index: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().number).isRequired,
  isLastStep: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().bool).isRequired,
  primaryProps: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().object).isRequired,
  size: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().number).isRequired,
  step: prop_types__WEBPACK_IMPORTED_MODULE_8___default().shape({
    content: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().node),
    title: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().node),
    cta: prop_types__WEBPACK_IMPORTED_MODULE_8___default().oneOfType([(prop_types__WEBPACK_IMPORTED_MODULE_8___default().element), (prop_types__WEBPACK_IMPORTED_MODULE_8___default().bool)]),
    className: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().string)
  }).isRequired,
  tooltipProps: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().object).isRequired
};

/***/ }),

/***/ "./js/components/TourTooltips.js":
/*!***************************************!*\
  !*** ./js/components/TourTooltips.js ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   GA_ACTIONS: () => (/* binding */ GA_ACTIONS),
/* harmony export */   "default": () => (/* binding */ TourTooltips),
/* harmony export */   floaterProps: () => (/* binding */ floaterProps),
/* harmony export */   joyrideStyles: () => (/* binding */ joyrideStyles)
/* harmony export */ });
/* harmony import */ var react_use__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! react-use */ "../node_modules/react-use/esm/useMount.js");
/* harmony import */ var react_joyride__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! react-joyride */ "../node_modules/react-joyride/dist/index.mjs");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_10__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _js_googlesitekit_datastore_ui_constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/googlesitekit/datastore/ui/constants */ "./js/googlesitekit/datastore/ui/constants.js");
/* harmony import */ var _js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/googlesitekit/datastore/user/constants */ "./js/googlesitekit/datastore/user/constants.js");
/* harmony import */ var _js_util_tracking__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/util/tracking */ "./js/util/tracking/index.js");
/* harmony import */ var _TourTooltip__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./TourTooltip */ "./js/components/TourTooltip.js");
/* harmony import */ var _js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @/js/hooks/useViewContext */ "./js/hooks/useViewContext.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * TourTooltips component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */




/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */







/** For available options, see: {@link https://github.com/gilbarbara/react-joyride/blob/3e08384415a831b20ce21c8423b6c271ad419fbf/src/styles.js}. */

const joyrideStyles = {
  options: {
    arrowColor: '#3c7251',
    // $c-content-primary
    backgroundColor: '#3c7251',
    // $c-content-primary
    overlayColor: 'rgba(0, 0, 0, 0.6)',
    textColor: '#fff',
    // $c-content-on-primary
    zIndex: 20000
  },
  spotlight: {
    border: '2px solid #3c7251',
    // $c-content-primary
    backgroundColor: '#fff'
  }
};

// Provides button content as well as aria-label & title attribute values.
const joyrideLocale = {
  back: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Back', 'google-site-kit'),
  close: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Close', 'google-site-kit'),
  last: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Got it', 'google-site-kit'),
  next: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Next', 'google-site-kit')
};

/** For available options, see: {@link https://github.com/gilbarbara/react-floater#props}. */
const floaterProps = {
  disableAnimation: true,
  styles: {
    arrow: {
      length: 8,
      margin: 56,
      spread: 16
    },
    floater: {
      filter: 'drop-shadow(rgba(60, 64, 67, 0.3) 0px 1px 2px) drop-shadow(rgba(60, 64, 67, 0.15) 0px 2px 6px)'
    }
  }
};

// GA Event Tracking actions (do not change!)
const GA_ACTIONS = {
  VIEW: 'feature_tooltip_view',
  NEXT: 'feature_tooltip_advance',
  PREV: 'feature_tooltip_return',
  DISMISS: 'feature_tooltip_dismiss',
  COMPLETE: 'feature_tooltip_complete'
};
function TourTooltips({
  steps,
  tourID,
  gaEventCategory,
  callback
}) {
  const stepKey = `${tourID}-step`;
  const runKey = `${tourID}-run`;
  const {
    setValue
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useDispatch)(_js_googlesitekit_datastore_ui_constants__WEBPACK_IMPORTED_MODULE_2__.CORE_UI);
  const {
    dismissTour
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useDispatch)(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_USER);
  const registry = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useRegistry)();
  const viewContext = (0,_js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_6__["default"])();
  const stepIndex = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_datastore_ui_constants__WEBPACK_IMPORTED_MODULE_2__.CORE_UI).getValue(stepKey) || 0);
  const run = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => {
    return select(_js_googlesitekit_datastore_ui_constants__WEBPACK_IMPORTED_MODULE_2__.CORE_UI).getValue(runKey) && select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_USER).isTourDismissed(tourID) === false;
  });
  function changeStep(index, action) {
    return setValue(stepKey, index + (action === react_joyride__WEBPACK_IMPORTED_MODULE_8__.ACTIONS.PREV ? -1 : 1));
  }
  function startTour() {
    __webpack_require__.g.document.body.classList.add('googlesitekit-showing-feature-tour', `googlesitekit-showing-feature-tour--${tourID}`);
    setValue(runKey, true);
  }
  function endTour() {
    __webpack_require__.g.document.body.classList.remove('googlesitekit-showing-feature-tour', `googlesitekit-showing-feature-tour--${tourID}`);
    // Dismiss tour to avoid unwanted repeat viewing.
    dismissTour(tourID);
  }
  function trackAllTourEvents({
    index,
    action,
    lifecycle,
    size,
    status,
    type
  }) {
    // The index is 0-based, but step numbers are 1-based.
    const stepNumber = index + 1;
    const eventCategory = typeof gaEventCategory === 'function' ? gaEventCategory(viewContext) : gaEventCategory;
    if (type === react_joyride__WEBPACK_IMPORTED_MODULE_8__.EVENTS.TOOLTIP && lifecycle === react_joyride__WEBPACK_IMPORTED_MODULE_8__.LIFECYCLE.TOOLTIP) {
      (0,_js_util_tracking__WEBPACK_IMPORTED_MODULE_4__.trackEvent)(eventCategory, GA_ACTIONS.VIEW, stepNumber);
    } else if (action === react_joyride__WEBPACK_IMPORTED_MODULE_8__.ACTIONS.CLOSE && lifecycle === react_joyride__WEBPACK_IMPORTED_MODULE_8__.LIFECYCLE.COMPLETE) {
      (0,_js_util_tracking__WEBPACK_IMPORTED_MODULE_4__.trackEvent)(eventCategory, GA_ACTIONS.DISMISS, stepNumber);
    } else if (action === react_joyride__WEBPACK_IMPORTED_MODULE_8__.ACTIONS.NEXT && status === react_joyride__WEBPACK_IMPORTED_MODULE_8__.STATUS.FINISHED && type === react_joyride__WEBPACK_IMPORTED_MODULE_8__.EVENTS.TOUR_END &&
    // Here we need to additionally check the size === stepNumber because
    // it is the only way to differentiate the status/event combination
    // from an identical combination that happens immediately after completion
    // on index `0` to avoid duplicate measurement.
    size === stepNumber) {
      (0,_js_util_tracking__WEBPACK_IMPORTED_MODULE_4__.trackEvent)(eventCategory, GA_ACTIONS.COMPLETE, stepNumber);
    }
    if (lifecycle !== react_joyride__WEBPACK_IMPORTED_MODULE_8__.LIFECYCLE.COMPLETE || status === react_joyride__WEBPACK_IMPORTED_MODULE_8__.STATUS.FINISHED) {
      return;
    }
    if (action === react_joyride__WEBPACK_IMPORTED_MODULE_8__.ACTIONS.PREV) {
      (0,_js_util_tracking__WEBPACK_IMPORTED_MODULE_4__.trackEvent)(eventCategory, GA_ACTIONS.PREV, stepNumber);
    }
    if (action === react_joyride__WEBPACK_IMPORTED_MODULE_8__.ACTIONS.NEXT) {
      (0,_js_util_tracking__WEBPACK_IMPORTED_MODULE_4__.trackEvent)(eventCategory, GA_ACTIONS.NEXT, stepNumber);
    }
  }

  /**
   * Handles `react-joyride` state changes using callback function.
   *
   * @typedef {Object} JoyrideCallbackData
   * @property {string} action The action that updated the state.
   * @property {status} status The tour's status.
   * @property {number} index  Step index.
   * @property {string} type   Specific type (tour, step, beacon).
   *
   * @since 1.28.0
   * @since 1.38.0 Calls new callback prop.
   * @see {@link https://docs.react-joyride.com/callback} Example data provided by `react-joyride`.
   * @see {@link https://docs.react-joyride.com/constants} State & lifecycle constants used by `react-joyride`.
   *
   * @param {JoyrideCallbackData} data Data object provided via `react-joyride` callback prop.
   */
  function handleJoyrideCallback(data) {
    trackAllTourEvents(data);
    const {
      action,
      index,
      status,
      step,
      type
    } = data;
    const hasCloseAction = action === react_joyride__WEBPACK_IMPORTED_MODULE_8__.ACTIONS.CLOSE;
    const shouldChangeStep = !hasCloseAction && [react_joyride__WEBPACK_IMPORTED_MODULE_8__.EVENTS.STEP_AFTER, react_joyride__WEBPACK_IMPORTED_MODULE_8__.EVENTS.TARGET_NOT_FOUND].includes(type);
    const isFinishedOrSkipped = [react_joyride__WEBPACK_IMPORTED_MODULE_8__.STATUS.FINISHED, react_joyride__WEBPACK_IMPORTED_MODULE_8__.STATUS.SKIPPED].includes(status);
    const shouldCloseFromButtonClick = hasCloseAction && type === react_joyride__WEBPACK_IMPORTED_MODULE_8__.EVENTS.STEP_AFTER;
    const shouldEndTour = isFinishedOrSkipped || shouldCloseFromButtonClick;

    // Center the target in the viewport when transitioning to the step.
    if (react_joyride__WEBPACK_IMPORTED_MODULE_8__.EVENTS.STEP_BEFORE === type) {
      let el = step.target;
      if ('string' === typeof step.target) {
        el = __webpack_require__.g.document.querySelector(step.target);
      }
      el?.scrollIntoView?.({
        block: 'center'
      });
    }
    if (shouldChangeStep) {
      changeStep(index, action);
    } else if (shouldEndTour) {
      endTour();
    }
    if (callback) {
      callback(data, registry);
    }
  }

  // Start tour on initial render
  (0,react_use__WEBPACK_IMPORTED_MODULE_9__["default"])(startTour);
  const parsedSteps = steps.map(step => ({
    disableBeacon: true,
    isFixed: true,
    placement: 'auto',
    ...step
  }));
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(react_joyride__WEBPACK_IMPORTED_MODULE_8__["default"], {
    callback: handleJoyrideCallback,
    floaterProps: floaterProps,
    locale: joyrideLocale,
    run: run,
    stepIndex: stepIndex,
    steps: parsedSteps,
    styles: joyrideStyles,
    tooltipComponent: _TourTooltip__WEBPACK_IMPORTED_MODULE_5__["default"],
    continuous: true,
    disableOverlayClose: true,
    disableScrolling: true,
    showProgress: true
  });
}

/** For available properties & docs for `steps`, see: {@link https://docs.react-joyride.com/step#options}. */
TourTooltips.propTypes = {
  steps: prop_types__WEBPACK_IMPORTED_MODULE_10___default().arrayOf((prop_types__WEBPACK_IMPORTED_MODULE_10___default().object)).isRequired,
  tourID: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().string).isRequired,
  gaEventCategory: prop_types__WEBPACK_IMPORTED_MODULE_10___default().oneOfType([(prop_types__WEBPACK_IMPORTED_MODULE_10___default().string), (prop_types__WEBPACK_IMPORTED_MODULE_10___default().func)]).isRequired,
  callback: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().func)
};

/***/ }),

/***/ "./js/components/Typography/P.js":
/*!***************************************!*\
  !*** ./js/components/Typography/P.js ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ P)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @/js/hooks/useBreakpoint */ "./js/hooks/useBreakpoint.js");
/* harmony import */ var ___WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! . */ "./js/components/Typography/index.js");
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./constants */ "./js/components/Typography/constants.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * Internal dependencies
 */




function P({
  type = _constants__WEBPACK_IMPORTED_MODULE_2__.TYPE_BODY,
  size,
  children,
  ...props
}) {
  const breakpoint = (0,_js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_0__.useBreakpoint)();
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(___WEBPACK_IMPORTED_MODULE_1__["default"], {
    as: "p",
    type: type,
    size: size || (breakpoint === _js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_0__.BREAKPOINT_SMALL ? _constants__WEBPACK_IMPORTED_MODULE_2__.SIZE_SMALL : _constants__WEBPACK_IMPORTED_MODULE_2__.SIZE_MEDIUM),
    ...props,
    children: children
  });
}
P.propTypes = {
  type: prop_types__WEBPACK_IMPORTED_MODULE_4___default().oneOf(_constants__WEBPACK_IMPORTED_MODULE_2__.VALID_TYPES),
  size: prop_types__WEBPACK_IMPORTED_MODULE_4___default().oneOf(_constants__WEBPACK_IMPORTED_MODULE_2__.VALID_SIZES)
};

/***/ }),

/***/ "./js/components/Typography/constants.js":
/*!***********************************************!*\
  !*** ./js/components/Typography/constants.js ***!
  \***********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   SIZE_LARGE: () => (/* binding */ SIZE_LARGE),
/* harmony export */   SIZE_MEDIUM: () => (/* binding */ SIZE_MEDIUM),
/* harmony export */   SIZE_SMALL: () => (/* binding */ SIZE_SMALL),
/* harmony export */   TYPE_BODY: () => (/* binding */ TYPE_BODY),
/* harmony export */   TYPE_DISPLAY: () => (/* binding */ TYPE_DISPLAY),
/* harmony export */   TYPE_HEADLINE: () => (/* binding */ TYPE_HEADLINE),
/* harmony export */   TYPE_LABEL: () => (/* binding */ TYPE_LABEL),
/* harmony export */   TYPE_TITLE: () => (/* binding */ TYPE_TITLE),
/* harmony export */   VALID_SIZES: () => (/* binding */ VALID_SIZES),
/* harmony export */   VALID_TYPES: () => (/* binding */ VALID_TYPES)
/* harmony export */ });
/**
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

const TYPE_DISPLAY = 'display';
const TYPE_HEADLINE = 'headline';
const TYPE_TITLE = 'title';
const TYPE_BODY = 'body';
const TYPE_LABEL = 'label';
const VALID_TYPES = [TYPE_BODY, TYPE_DISPLAY, TYPE_HEADLINE, TYPE_LABEL, TYPE_TITLE];
const SIZE_SMALL = 'small';
const SIZE_MEDIUM = 'medium';
const SIZE_LARGE = 'large';
const VALID_SIZES = [SIZE_SMALL, SIZE_MEDIUM, SIZE_LARGE];

/***/ }),

/***/ "./js/components/Typography/index.js":
/*!*******************************************!*\
  !*** ./js/components/Typography/index.js ***!
  \*******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Typography)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./constants */ "./js/components/Typography/constants.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * Internal dependencies
 */


function Typography({
  className,
  type,
  size,
  as: Component = 'span',
  children,
  ...props
}) {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)(Component, {
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-typography', className, {
      [`googlesitekit-typography--${type}`]: type && _constants__WEBPACK_IMPORTED_MODULE_1__.VALID_TYPES.includes(type),
      [`googlesitekit-typography--${size}`]: size && _constants__WEBPACK_IMPORTED_MODULE_1__.VALID_SIZES.includes(size)
    }),
    ...props,
    children: children
  });
}
Typography.propTypes = {
  className: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  type: prop_types__WEBPACK_IMPORTED_MODULE_3___default().oneOf(_constants__WEBPACK_IMPORTED_MODULE_1__.VALID_TYPES),
  size: prop_types__WEBPACK_IMPORTED_MODULE_3___default().oneOf(_constants__WEBPACK_IMPORTED_MODULE_1__.VALID_SIZES),
  as: prop_types__WEBPACK_IMPORTED_MODULE_3___default().oneOfType([(prop_types__WEBPACK_IMPORTED_MODULE_3___default().string), (prop_types__WEBPACK_IMPORTED_MODULE_3___default().elementType)])
};

/***/ }),

/***/ "./js/components/UserMenu/Details.js":
/*!*******************************************!*\
  !*** ./js/components/UserMenu/Details.js ***!
  \*******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Details)
/* harmony export */ });
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/googlesitekit/datastore/user/constants */ "./js/googlesitekit/datastore/user/constants.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * UserMenu Details component.
 *
 * Site Kit by Google, Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */



function Details() {
  const userPicture = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_2__.CORE_USER).getPicture());
  const userFullName = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_2__.CORE_USER).getFullName());
  const userEmail = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_2__.CORE_USER).getEmail());
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
    className: "googlesitekit-user-menu__details",
    "aria-label": (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Google account', 'google-site-kit'),
    children: [!!userPicture && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("img", {
      className: "googlesitekit-user-menu__details-avatar",
      src: userPicture,
      alt: ""
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
      className: "googlesitekit-user-menu__details-info",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("p", {
        className: "googlesitekit-user-menu__details-info__name",
        children: userFullName
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("p", {
        className: "googlesitekit-user-menu__details-info__email",
        "aria-label": (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Email', 'google-site-kit'),
        children: userEmail
      })]
    })]
  });
}

/***/ }),

/***/ "./js/components/UserMenu/Item.js":
/*!****************************************!*\
  !*** ./js/components/UserMenu/Item.js ***!
  \****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Item)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * UserMenu Item component.
 *
 * Site Kit by Google, Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


function Item({
  icon,
  label
}) {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
    className: "googlesitekit-user-menu__item",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", {
      className: "googlesitekit-user-menu__item-icon",
      children: icon
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("span", {
      className: "googlesitekit-user-menu__item-label",
      children: label
    })]
  });
}
Item.propTypes = {
  icon: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().node),
  label: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string)
};

/***/ }),

/***/ "./js/components/UserMenu/index.js":
/*!*****************************************!*\
  !*** ./js/components/UserMenu/index.js ***!
  \*****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ UserMenu)
/* harmony export */ });
/* harmony import */ var react_use__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! react-use */ "../node_modules/react-use/esm/useClickAway.js");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_keycodes__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! @wordpress/keycodes */ "../node_modules/@wordpress/keycodes/build-module/index.js");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! googlesitekit-components */ "googlesitekit-components");
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_components__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _js_components_ModalDialog__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/components/ModalDialog */ "./js/components/ModalDialog.js");
/* harmony import */ var _js_util__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/util */ "./js/util/index.js");
/* harmony import */ var _js_googlesitekit_api_cache__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/googlesitekit/api/cache */ "./js/googlesitekit/api/cache.js");
/* harmony import */ var _js_components_Portal__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @/js/components/Portal */ "./js/components/Portal.js");
/* harmony import */ var _Details__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./Details */ "./js/components/UserMenu/Details.js");
/* harmony import */ var _Item__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./Item */ "./js/components/UserMenu/Item.js");
/* harmony import */ var _svg_icons_disconnect_svg__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @/svg/icons/disconnect.svg */ "./svg/icons/disconnect.svg");
/* harmony import */ var _svg_icons_manage_sites_svg__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @/svg/icons/manage-sites.svg */ "./svg/icons/manage-sites.svg");
/* harmony import */ var _js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @/js/googlesitekit/datastore/site/constants */ "./js/googlesitekit/datastore/site/constants.js");
/* harmony import */ var _js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! @/js/googlesitekit/datastore/user/constants */ "./js/googlesitekit/datastore/user/constants.js");
/* harmony import */ var _js_googlesitekit_datastore_location_constants__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! @/js/googlesitekit/datastore/location/constants */ "./js/googlesitekit/datastore/location/constants.js");
/* harmony import */ var _js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! @/js/modules/analytics-4/datastore/constants */ "./js/modules/analytics-4/datastore/constants.js");
/* harmony import */ var _js_hooks_useKeyCodesInside__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! @/js/hooks/useKeyCodesInside */ "./js/hooks/useKeyCodesInside.js");
/* harmony import */ var _js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! @/js/hooks/useViewContext */ "./js/hooks/useViewContext.js");
/* harmony import */ var _js_hooks_useFormValue__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! @/js/hooks/useFormValue */ "./js/hooks/useFormValue.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * UserMenu component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */




/**
 * Internal dependencies
 */


















function UserMenu() {
  const proxyPermissionsURL = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_11__.CORE_SITE).getProxyPermissionsURL());
  const userEmail = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_12__.CORE_USER).getEmail());
  const userPicture = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_12__.CORE_USER).getPicture());
  const userFullName = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_12__.CORE_USER).getFullName());
  const postDisconnectURL = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_11__.CORE_SITE).getAdminURL('googlesitekit-splash', {
    googlesitekit_context: 'revoked'
  }));
  const isAutoCreatingCustomDimensionsForAudience = (0,_js_hooks_useFormValue__WEBPACK_IMPORTED_MODULE_17__["default"])(_js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_14__.AUDIENCE_TILE_CUSTOM_DIMENSION_CREATE, 'isAutoCreatingCustomDimensionsForAudience');
  const [dialogActive, toggleDialog] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_19__.useState)(false);
  const [menuOpen, setMenuOpen] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_19__.useState)(false);
  const menuWrapperRef = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_19__.useRef)();
  const menuButtonRef = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_19__.useRef)();
  const viewContext = (0,_js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_16__["default"])();
  const {
    navigateTo
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useDispatch)(_js_googlesitekit_datastore_location_constants__WEBPACK_IMPORTED_MODULE_13__.CORE_LOCATION);
  (0,react_use__WEBPACK_IMPORTED_MODULE_20__["default"])(menuWrapperRef, () => setMenuOpen(false));
  (0,_js_hooks_useKeyCodesInside__WEBPACK_IMPORTED_MODULE_15__.useKeyCodesInside)([_wordpress_keycodes__WEBPACK_IMPORTED_MODULE_21__.ESCAPE, _wordpress_keycodes__WEBPACK_IMPORTED_MODULE_21__.TAB], menuWrapperRef, () => {
    setMenuOpen(false);
    // Reinstate menu button focus when menu is closed.
    menuButtonRef.current?.focus();
  });
  function handleClose() {
    toggleDialog(false);
    setMenuOpen(false);
  }
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_19__.useEffect)(() => {
    function handleEscapeKeyPress(e) {
      // Close if Escape key is pressed.
      if (_wordpress_keycodes__WEBPACK_IMPORTED_MODULE_21__.ESCAPE === e.keyCode) {
        handleClose();
      }
    }
    __webpack_require__.g.addEventListener('keyup', handleEscapeKeyPress);
    return () => {
      __webpack_require__.g.removeEventListener('keyup', handleEscapeKeyPress);
    };
  }, []);
  const handleMenu = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_19__.useCallback)(() => {
    if (!menuOpen) {
      (0,_js_util__WEBPACK_IMPORTED_MODULE_4__.trackEvent)(`${viewContext}_headerbar`, 'open_usermenu');
    }
    setMenuOpen(!menuOpen);
  }, [menuOpen, viewContext]);
  const handleDialog = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_19__.useCallback)(() => {
    toggleDialog(!dialogActive);
    setMenuOpen(false);
  }, [dialogActive]);
  const handleMenuItemSelect = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_19__.useCallback)(async (_index, event) => {
    const {
      detail: {
        item
      }
    } = event;
    switch (item?.id) {
      case 'manage-sites':
        if (proxyPermissionsURL) {
          await (0,_js_util__WEBPACK_IMPORTED_MODULE_4__.trackEvent)(`${viewContext}_headerbar_usermenu`, 'manage_sites');
          navigateTo(proxyPermissionsURL);
        }
        break;
      case 'disconnect':
        handleDialog();
        break;
      default:
        handleMenu();
    }
  }, [proxyPermissionsURL, handleMenu, handleDialog, navigateTo, viewContext]);

  // Log the user out if they confirm the dialog.
  const handleUnlinkConfirm = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_19__.useCallback)(async () => {
    // Close the modal.
    toggleDialog(false);
    await (0,_js_googlesitekit_api_cache__WEBPACK_IMPORTED_MODULE_5__.clearCache)();
    await (0,_js_util__WEBPACK_IMPORTED_MODULE_4__.trackEvent)(`${viewContext}_headerbar_usermenu`, 'disconnect_user');

    // Navigate back to the splash screen to reconnect.
    navigateTo(postDisconnectURL);
  }, [postDisconnectURL, navigateTo, viewContext]);
  if (!userEmail) {
    return null;
  }
  let accountLabel;
  if (userFullName && userEmail) {
    accountLabel = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.sprintf)(/* translators: Account info text. 1: User's (full) name 2: User's email address. */
    (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Google Account for %1$s (Email: %2$s)', 'google-site-kit'), userFullName, userEmail);
  }
  if (userFullName && !userEmail) {
    accountLabel = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.sprintf)(/* translators: Account info text. 1: User's (full) name. */
    (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Google Account for %1$s', 'google-site-kit'), userFullName);
  }
  if (!userFullName && userEmail) {
    accountLabel = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.sprintf)(/* translators: Account info text. 1: User's email address. */
    (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Google Account (Email: %1$s)', 'google-site-kit'), userEmail);
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsxs)(_wordpress_element__WEBPACK_IMPORTED_MODULE_19__.Fragment, {
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsxs)("div", {
      ref: menuWrapperRef,
      className: "googlesitekit-user-selector googlesitekit-dropdown-menu googlesitekit-dropdown-menu__icon-menu mdc-menu-surface--anchor",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_2__.Button, {
        disabled: isAutoCreatingCustomDimensionsForAudience,
        ref: menuButtonRef,
        className: "googlesitekit-header__dropdown mdc-button--dropdown googlesitekit-border-radius-round--tablet googlesitekit-border-radius-round--phone googlesitekit-border-radius-round googlesitekit-button-icon",
        onClick: handleMenu,
        icon: !!userPicture && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx)("i", {
          className: "mdc-button__icon mdc-button__account",
          "aria-hidden": "true",
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx)("img", {
            className: "mdc-button__icon--image",
            src: userPicture,
            alt: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('User Avatar', 'google-site-kit')
          })
        }),
        "aria-haspopup": "menu",
        "aria-expanded": menuOpen,
        "aria-controls": "user-menu",
        "aria-label": isAutoCreatingCustomDimensionsForAudience ? undefined : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Account', 'google-site-kit'),
        tooltipEnterDelayInMS: 500,
        customizedTooltip: isAutoCreatingCustomDimensionsForAudience ? null : /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsxs)("span", {
          "aria-label": accountLabel,
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx)("strong", {
            children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Google Account', 'google-site-kit')
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx)("br", {}), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx)("br", {}), userFullName, userFullName && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx)("br", {}), userEmail]
        }),
        text: true,
        tooltip: true
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsxs)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_2__.Menu, {
        className: "googlesitekit-user-menu",
        menuOpen: menuOpen,
        onSelected: handleMenuItemSelect,
        id: "user-menu",
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx)("li", {
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx)(_Details__WEBPACK_IMPORTED_MODULE_7__["default"], {})
        }), !!proxyPermissionsURL && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx)("li", {
          id: "manage-sites",
          className: "mdc-list-item",
          role: "menuitem",
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx)(_Item__WEBPACK_IMPORTED_MODULE_8__["default"], {
            icon: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx)(_svg_icons_manage_sites_svg__WEBPACK_IMPORTED_MODULE_10__["default"], {
              width: "22"
            }),
            label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Manage Sites', 'google-site-kit')
          })
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx)("li", {
          id: "disconnect",
          className: "mdc-list-item",
          role: "menuitem",
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx)(_Item__WEBPACK_IMPORTED_MODULE_8__["default"], {
            icon: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx)(_svg_icons_disconnect_svg__WEBPACK_IMPORTED_MODULE_9__["default"], {
              width: "22"
            }),
            label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Disconnect', 'google-site-kit')
          })
        })]
      })]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx)(_js_components_Portal__WEBPACK_IMPORTED_MODULE_6__["default"], {
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx)(_js_components_ModalDialog__WEBPACK_IMPORTED_MODULE_3__["default"], {
        dialogActive: dialogActive,
        handleConfirm: handleUnlinkConfirm,
        handleCancel: handleClose,
        onClose: handleClose,
        title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Disconnect', 'google-site-kit'),
        subtitle: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Disconnecting Site Kit by Google will remove your access to all services. After disconnecting, you will need to re-authorize to restore service.', 'google-site-kit'),
        confirmButton: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Disconnect', 'google-site-kit'),
        danger: true,
        small: true
      })
    })]
  });
}

/***/ }),

/***/ "./js/components/ViewOnlyMenu/Description.js":
/*!***************************************************!*\
  !*** ./js/components/ViewOnlyMenu/Description.js ***!
  \***************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Description)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/@wordpress/element/build-module/create-interpolate-element.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! googlesitekit-components */ "googlesitekit-components");
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_components__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _js_components_Typography_P__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/components/Typography/P */ "./js/components/Typography/P.js");
/* harmony import */ var _js_googlesitekit_datastore_location_constants__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/googlesitekit/datastore/location/constants */ "./js/googlesitekit/datastore/location/constants.js");
/* harmony import */ var _js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/googlesitekit/datastore/site/constants */ "./js/googlesitekit/datastore/site/constants.js");
/* harmony import */ var _js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @/js/googlesitekit/datastore/user/constants */ "./js/googlesitekit/datastore/user/constants.js");
/* harmony import */ var _js_util__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @/js/util */ "./js/util/index.js");
/* harmony import */ var _js_components_Link__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @/js/components/Link */ "./js/components/Link.js");
/* harmony import */ var _js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @/js/hooks/useViewContext */ "./js/hooks/useViewContext.js");
/* harmony import */ var _js_googlesitekit_api_cache__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @/js/googlesitekit/api/cache */ "./js/googlesitekit/api/cache.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * ViewOnlyMenu > Description component.
 *
 * Site Kit by Google, Copyright 2022 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */











function Description() {
  const viewContext = (0,_js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_9__["default"])();
  const canAuthenticate = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_6__.CORE_USER).hasCapability(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_6__.PERMISSION_AUTHENTICATE));
  const proxySetupURL = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_5__.CORE_SITE).getProxySetupURL());
  const documentationURL = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => {
    return select(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_5__.CORE_SITE).getDocumentationLinkURL('dashboard-sharing');
  });
  const {
    navigateTo
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useDispatch)(_js_googlesitekit_datastore_location_constants__WEBPACK_IMPORTED_MODULE_4__.CORE_LOCATION);
  const onButtonClick = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_12__.useCallback)(async event => {
    event.preventDefault();
    await Promise.all([
    // Cache the start of the user setup journey.
    // This will be used for event tracking logic after successful setup.
    (0,_js_googlesitekit_api_cache__WEBPACK_IMPORTED_MODULE_10__.setItem)('start_user_setup', true), (0,_js_util__WEBPACK_IMPORTED_MODULE_7__.trackEvent)(`${viewContext}_headerbar_viewonly`, 'start_user_setup', proxySetupURL ? 'proxy' : 'custom-oauth')]);
    navigateTo(proxySetupURL);
  }, [proxySetupURL, navigateTo, viewContext]);
  const onLinkClick = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_12__.useCallback)(() => {
    (0,_js_util__WEBPACK_IMPORTED_MODULE_7__.trackEvent)(`${viewContext}_headerbar_viewonly`, 'click_learn_more_link');
  }, [viewContext]);
  const description = canAuthenticate ? (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_13__["default"])((0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("You can see stats from all shared Google services, but you can't make any changes. <strong>Sign in to connect more services and control sharing access.</strong>", 'google-site-kit'), {
    strong: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("strong", {})
  }) : (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_13__["default"])((0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("You can see stats from all shared Google services, but you can't make any changes. <a>Learn more</a>", 'google-site-kit'), {
    a: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_js_components_Link__WEBPACK_IMPORTED_MODULE_8__["default"], {
      href: documentationURL,
      onClick: onLinkClick,
      "aria-label": (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Learn more about dashboard sharing', 'google-site-kit'),
      external: true
    })
  });
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("li", {
    className: "googlesitekit-view-only-menu__list-item googlesitekit-view-only-menu__description",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_js_components_Typography_P__WEBPACK_IMPORTED_MODULE_3__["default"], {
      children: description
    }), canAuthenticate && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_2__.Button, {
      onClick: onButtonClick,
      children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__._x)('Sign in with Google', 'Service name', 'google-site-kit')
    })]
  });
}

/***/ }),

/***/ "./js/components/ViewOnlyMenu/Service.js":
/*!***********************************************!*\
  !*** ./js/components/ViewOnlyMenu/Service.js ***!
  \***********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Service)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/@wordpress/element/build-module/create-interpolate-element.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/googlesitekit/modules/datastore/constants */ "./js/googlesitekit/modules/datastore/constants.js");
/* harmony import */ var _js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/googlesitekit/datastore/user/constants */ "./js/googlesitekit/datastore/user/constants.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * ViewOnlyMenu > Service component.
 *
 * Site Kit by Google, Copyright 2022 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */




function Service({
  module
}) {
  const canAuthenticate = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_USER).hasCapability(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_3__.PERMISSION_AUTHENTICATE));
  const {
    name,
    owner
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_2__.CORE_MODULES).getModule(module) || {});
  const Icon = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_2__.CORE_MODULES).getModuleIcon(module));
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsxs)("li", {
    className: "googlesitekit-view-only-menu__service",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("span", {
      className: "googlesitekit-view-only-menu__service--icon",
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(Icon, {
        height: 26
      })
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("span", {
      className: "googlesitekit-view-only-menu__service--name",
      children: name
    }), canAuthenticate && owner?.login && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("span", {
      className: "googlesitekit-view-only-menu__service--owner",
      children: (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_5__["default"])((0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.sprintf)(/* translators: %s: module owner Google Account email address */
      (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Shared by <strong>%s</strong>', 'google-site-kit'), owner.login), {
        strong: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("strong", {
          title: owner.login
        })
      })
    })]
  });
}
Service.propTypes = {
  module: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().string).isRequired
};

/***/ }),

/***/ "./js/components/ViewOnlyMenu/SharedServices.js":
/*!******************************************************!*\
  !*** ./js/components/ViewOnlyMenu/SharedServices.js ***!
  \******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ SharedServices)
/* harmony export */ });
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/googlesitekit/datastore/user/constants */ "./js/googlesitekit/datastore/user/constants.js");
/* harmony import */ var _Service__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./Service */ "./js/components/ViewOnlyMenu/Service.js");
/* harmony import */ var _js_components_Typography__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/components/Typography */ "./js/components/Typography/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * ViewOnlyMenu > SharedServices component.
 *
 * Site Kit by Google, Copyright 2022 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */





function SharedServices() {
  const viewableModules = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_2__.CORE_USER).getViewableModules());
  if (viewableModules === undefined) {
    return null;
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)("li", {
    className: "googlesitekit-view-only-menu__list-item",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_js_components_Typography__WEBPACK_IMPORTED_MODULE_4__["default"], {
      as: "h4",
      size: "large",
      type: "title",
      children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Shared services', 'google-site-kit')
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("ul", {
      children: viewableModules.map(moduleSlug => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_Service__WEBPACK_IMPORTED_MODULE_3__["default"], {
        module: moduleSlug
      }, moduleSlug))
    })]
  });
}

/***/ }),

/***/ "./js/components/ViewOnlyMenu/Tracking.js":
/*!************************************************!*\
  !*** ./js/components/ViewOnlyMenu/Tracking.js ***!
  \************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Tracking)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/@wordpress/element/build-module/create-interpolate-element.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _js_components_OptIn__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/components/OptIn */ "./js/components/OptIn.js");
/* harmony import */ var _js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/hooks/useViewContext */ "./js/hooks/useViewContext.js");
/* harmony import */ var _js_components_Typography_P__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/components/Typography/P */ "./js/components/Typography/P.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * ViewOnlyMenu > Tracking component.
 *
 * Site Kit by Google, Copyright 2022 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */




function Tracking() {
  const viewContext = (0,_js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_2__["default"])();
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsxs)("li", {
    className: "googlesitekit-view-only-menu__list-item",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(_js_components_Typography_P__WEBPACK_IMPORTED_MODULE_3__["default"], {
      children: (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_5__["default"])((0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Thanks for using Site Kit!<br />Help us make it even better', 'google-site-kit'), {
        br: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("br", {})
      })
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(_js_components_OptIn__WEBPACK_IMPORTED_MODULE_1__["default"], {
      trackEventCategory: `${viewContext}_headerbar_viewonly`,
      alignCheckboxLeft: true
    })]
  });
}

/***/ }),

/***/ "./js/components/ViewOnlyMenu/index.js":
/*!*********************************************!*\
  !*** ./js/components/ViewOnlyMenu/index.js ***!
  \*********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ ViewOnlyMenu)
/* harmony export */ });
/* harmony import */ var react_use__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! react-use */ "../node_modules/react-use/esm/useClickAway.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_keycodes__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! @wordpress/keycodes */ "../node_modules/@wordpress/keycodes/build-module/index.js");
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! googlesitekit-components */ "googlesitekit-components");
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_components__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/hooks/useViewContext */ "./js/hooks/useViewContext.js");
/* harmony import */ var _js_hooks_useKeyCodesInside__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/hooks/useKeyCodesInside */ "./js/hooks/useKeyCodesInside.js");
/* harmony import */ var _js_util__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/util */ "./js/util/index.js");
/* harmony import */ var _svg_icons_view_svg__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @/svg/icons/view.svg */ "./svg/icons/view.svg");
/* harmony import */ var _Description__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./Description */ "./js/components/ViewOnlyMenu/Description.js");
/* harmony import */ var _SharedServices__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./SharedServices */ "./js/components/ViewOnlyMenu/SharedServices.js");
/* harmony import */ var _Tracking__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./Tracking */ "./js/components/ViewOnlyMenu/Tracking.js");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_10__);
/* harmony import */ var _js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @/js/googlesitekit/datastore/user/constants */ "./js/googlesitekit/datastore/user/constants.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * ViewOnlyMenu component.
 *
 * Site Kit by Google, Copyright 2022 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * WordPress dependencies
 */




/**
 * Internal dependencies
 */











function ViewOnlyMenu() {
  const [menuOpen, setMenuOpen] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_13__.useState)(false);
  const menuWrapperRef = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_13__.useRef)();
  const viewContext = (0,_js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_3__["default"])();
  (0,react_use__WEBPACK_IMPORTED_MODULE_14__["default"])(menuWrapperRef, () => setMenuOpen(false));
  (0,_js_hooks_useKeyCodesInside__WEBPACK_IMPORTED_MODULE_4__.useKeyCodesInside)([_wordpress_keycodes__WEBPACK_IMPORTED_MODULE_15__.ESCAPE, _wordpress_keycodes__WEBPACK_IMPORTED_MODULE_15__.TAB], menuWrapperRef, () => setMenuOpen(false));
  const toggleMenu = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_13__.useCallback)(() => {
    if (!menuOpen) {
      (0,_js_util__WEBPACK_IMPORTED_MODULE_5__.trackEvent)(`${viewContext}_headerbar`, 'open_viewonly');
    }
    setMenuOpen(!menuOpen);
  }, [menuOpen, viewContext]);
  const canAuthenticate = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_10__.useSelect)(select => select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_11__.CORE_USER).hasCapability(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_11__.PERMISSION_AUTHENTICATE));
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsxs)("div", {
    ref: menuWrapperRef,
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-view-only-menu', 'googlesitekit-dropdown-menu', 'googlesitekit-dropdown-menu__icon-menu', 'mdc-menu-surface--anchor', {
      'googlesitekit-view-only-menu--user-can-authenticate': canAuthenticate
    }),
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_2__.Button, {
      className: "googlesitekit-header__dropdown mdc-button--dropdown googlesitekit-border-radius-round--phone googlesitekit-button-icon",
      onClick: toggleMenu,
      icon: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx)("span", {
        className: "mdc-button__icon",
        "aria-hidden": "true",
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx)(_svg_icons_view_svg__WEBPACK_IMPORTED_MODULE_6__["default"], {
          className: "mdc-button__icon--image"
        })
      }),
      "aria-haspopup": "menu",
      "aria-expanded": menuOpen,
      "aria-controls": "view-only-menu",
      "aria-label": (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('View only', 'google-site-kit'),
      tooltipEnterDelayInMS: 500,
      text: true,
      tooltip: true,
      children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('View only', 'google-site-kit')
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsxs)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_2__.Menu, {
      menuOpen: menuOpen,
      onSelected: toggleMenu,
      id: "view-only-menu",
      nonInteractive: true,
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx)(_Description__WEBPACK_IMPORTED_MODULE_7__["default"], {}), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx)(_SharedServices__WEBPACK_IMPORTED_MODULE_8__["default"], {}), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx)("li", {
        className: "mdc-list-divider",
        role: "separator"
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx)(_Tracking__WEBPACK_IMPORTED_MODULE_9__["default"], {})]
    })]
  });
}

/***/ }),

/***/ "./js/components/VisuallyHidden.js":
/*!*****************************************!*\
  !*** ./js/components/VisuallyHidden.js ***!
  \*****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Visually Hidden component, mainly used for screen-reader text.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



function VisuallyHidden({
  className,
  children,
  ...otherProps
}) {
  if (!children) {
    return null;
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("span", {
    ...otherProps,
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('screen-reader-text', className),
    children: children
  });
}
VisuallyHidden.propTypes = {
  className: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().string),
  children: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().node)
};
VisuallyHidden.defaultProps = {
  className: ''
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (VisuallyHidden);

/***/ }),

/***/ "./js/components/consent-mode/ConfirmDisableConsentModeDialog.js":
/*!***********************************************************************!*\
  !*** ./js/components/consent-mode/ConfirmDisableConsentModeDialog.js ***!
  \***********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ ConfirmDisableConsentModeDialog)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_11___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_11__);
/* harmony import */ var react_use__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! react-use */ "../node_modules/react-use/esm/useMount.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/googlesitekit/modules/datastore/constants */ "./js/googlesitekit/modules/datastore/constants.js");
/* harmony import */ var _js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/googlesitekit/datastore/site/constants */ "./js/googlesitekit/datastore/site/constants.js");
/* harmony import */ var _js_util__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/util */ "./js/util/index.js");
/* harmony import */ var _js_modules_ads_constants__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/modules/ads/constants */ "./js/modules/ads/constants.js");
/* harmony import */ var _js_modules_analytics_4_constants__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @/js/modules/analytics-4/constants */ "./js/modules/analytics-4/constants.js");
/* harmony import */ var _js_components_RefocusableModalDialog__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @/js/components/RefocusableModalDialog */ "./js/components/RefocusableModalDialog.js");
/* harmony import */ var _js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @/js/hooks/useViewContext */ "./js/hooks/useViewContext.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */









function ConfirmDisableConsentModeDialog({
  onConfirm,
  onCancel
}) {
  const viewContext = (0,_js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_8__["default"])();
  const isAdsConnected = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_SITE).isAdsConnectedUncached());
  const dependentModuleNames = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => [_js_modules_analytics_4_constants__WEBPACK_IMPORTED_MODULE_6__.MODULE_SLUG_ANALYTICS_4, _js_modules_ads_constants__WEBPACK_IMPORTED_MODULE_5__.MODULE_SLUG_ADS].reduce((names, slug) => {
    if (select(_js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_2__.CORE_MODULES).isModuleConnected(slug)) {
      return [...names, select(_js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_2__.CORE_MODULES).getModule(slug).name];
    }
    return names;
  }, []));
  const dependentModulesText = dependentModuleNames.length > 0 ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.sprintf)(/* translators: %s: list of dependent modules */
  (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('these active modules depend on consent mode and will be affected: %s', 'google-site-kit'), (0,_js_util__WEBPACK_IMPORTED_MODULE_4__.listFormat)(dependentModuleNames)) : null;
  (0,react_use__WEBPACK_IMPORTED_MODULE_10__["default"])(() => {
    (0,_js_util__WEBPACK_IMPORTED_MODULE_4__.trackEvent)(`${viewContext}_CoMo`, 'view_modal');
  });
  let provides = [(0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Track how visitors interact with your site', 'google-site-kit')];
  let subtitle = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Disabling consent mode may affect your ability in the European Economic Area, the UK and Switzerland to:', 'google-site-kit');
  if (isAdsConnected) {
    provides = [(0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Performance of your Ad campaigns', 'google-site-kit'), (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('How visitors interact with your site via Analytics', 'google-site-kit')];
    subtitle = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Disabling consent mode may affect your ability to track these in the European Economic Area, the UK and Switzerland:', 'google-site-kit');
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)(_js_components_RefocusableModalDialog__WEBPACK_IMPORTED_MODULE_7__["default"], {
    className: "googlesitekit-settings-module__confirm-disconnect-modal",
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Disable consent mode?', 'google-site-kit'),
    subtitle: subtitle,
    handleConfirm: onConfirm,
    handleCancel: onCancel,
    onClose: onCancel,
    provides: provides,
    dependentModules: dependentModulesText,
    confirmButton: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Disable', 'google-site-kit'),
    dialogActive: true,
    danger: true
  });
}
ConfirmDisableConsentModeDialog.propTypes = {
  onConfirm: (prop_types__WEBPACK_IMPORTED_MODULE_11___default().func).isRequired,
  onCancel: (prop_types__WEBPACK_IMPORTED_MODULE_11___default().func).isRequired
};

/***/ }),

/***/ "./js/components/consent-mode/ConsentModeSwitch.js":
/*!*********************************************************!*\
  !*** ./js/components/consent-mode/ConsentModeSwitch.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ ConsentModeSwitch)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/@wordpress/element/build-module/create-interpolate-element.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-components */ "googlesitekit-components");
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/googlesitekit/datastore/site/constants */ "./js/googlesitekit/datastore/site/constants.js");
/* harmony import */ var _js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/googlesitekit/datastore/user/constants */ "./js/googlesitekit/datastore/user/constants.js");
/* harmony import */ var _js_components_Link__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/components/Link */ "./js/components/Link.js");
/* harmony import */ var _js_components_LoadingWrapper__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @/js/components/LoadingWrapper */ "./js/components/LoadingWrapper.js");
/* harmony import */ var _ConfirmDisableConsentModeDialog__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./ConfirmDisableConsentModeDialog */ "./js/components/consent-mode/ConfirmDisableConsentModeDialog.js");
/* harmony import */ var _js_util__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @/js/util */ "./js/util/index.js");
/* harmony import */ var _js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @/js/hooks/useViewContext */ "./js/hooks/useViewContext.js");
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./constants */ "./js/components/consent-mode/constants.js");
/* harmony import */ var _js_components_ErrorNotice__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @/js/components/ErrorNotice */ "./js/components/ErrorNotice.js");
/* harmony import */ var _js_components_Typography_P__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! @/js/components/Typography/P */ "./js/components/Typography/P.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */













function ConsentModeSwitch({
  loading
}) {
  const viewContext = (0,_js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_9__["default"])();
  const [saveError, setSaveError] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_14__.useState)(null);
  const [showConfirmDialog, setShowConfirmDialog] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_14__.useState)(false);
  const isConsentModeEnabled = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.useSelect)(select => select(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_SITE).isConsentModeEnabled());
  const consentModeDocumentationURL = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.useSelect)(select => select(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_SITE).getDocumentationLinkURL('consent-mode'));
  const isSaving = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.useSelect)(select => select(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_SITE).isFetchingSaveConsentModeSettings());
  const {
    setConsentModeEnabled,
    saveConsentModeSettings
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.useDispatch)(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_SITE);
  const {
    dismissPrompt,
    triggerSurvey
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.useDispatch)(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_4__.CORE_USER);
  const isDismissed = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.useSelect)(select => select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_4__.CORE_USER).isPromptDismissed(_constants__WEBPACK_IMPORTED_MODULE_10__.CONSENT_MODE_SETUP_CTA_WIDGET_SLUG));
  async function saveSettings() {
    setSaveError(null);
    const promises = [saveConsentModeSettings(), triggerSurvey('enable_como', {
      ttl: _js_util__WEBPACK_IMPORTED_MODULE_8__.DAY_IN_SECONDS
    })];
    const [{
      error
    }] = await Promise.all(promises);
    if (error) {
      setSaveError(error);
      return;
    }
    if (!isDismissed) {
      await dismissPrompt(_constants__WEBPACK_IMPORTED_MODULE_10__.CONSENT_MODE_SETUP_CTA_WIDGET_SLUG);
    }
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsxs)(_wordpress_element__WEBPACK_IMPORTED_MODULE_14__.Fragment, {
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsxs)("div", {
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx)(_js_components_LoadingWrapper__WEBPACK_IMPORTED_MODULE_6__["default"], {
        loading: loading,
        width: "180px",
        height: "21.3px",
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__.Switch, {
          label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Enable consent mode', 'google-site-kit'),
          checked: isConsentModeEnabled,
          disabled: loading || isSaving,
          onClick: () => {
            // If Consent Mode is currently enabled, show a confirmation
            // dialog warning users about the impact of disabling it.
            if (isConsentModeEnabled) {
              (0,_js_util__WEBPACK_IMPORTED_MODULE_8__.trackEvent)(`${viewContext}_CoMo`, 'como_disable');
              setShowConfirmDialog(true);
            } else {
              (0,_js_util__WEBPACK_IMPORTED_MODULE_8__.trackEvent)(`${viewContext}_CoMo`, 'como_enable');

              // Consent Mode is not currently enabled, so this toggle
              // enables it.
              setConsentModeEnabled(true);
              saveSettings();
            }
          },
          hideLabel: false
        })
      }), saveError && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx)(_js_components_ErrorNotice__WEBPACK_IMPORTED_MODULE_11__["default"], {
        message: saveError.message
      }), !loading && isConsentModeEnabled && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx)("p", {
        className: "googlesitekit-settings-consent-mode-switch__enabled-notice",
        children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Site Kit added the necessary code to your tag to comply with Consent Mode.', 'google-site-kit')
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx)(_js_components_LoadingWrapper__WEBPACK_IMPORTED_MODULE_6__["default"], {
        className: "googlesitekit-settings-consent-mode-switch-description--loading",
        loading: loading,
        width: "750px",
        height: "42px",
        smallWidth: "386px",
        smallHeight: "84px",
        tabletWidth: "540px",
        tabletHeight: "84px",
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx)(_js_components_Typography_P__WEBPACK_IMPORTED_MODULE_12__["default"], {
          children: (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_15__["default"])((0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Consent mode will help adjust tracking on your site, so only visitors who have explicitly given consent are tracked. <br />This is required in some parts of the world, like the European Economic Area. <a>Learn more</a>', 'google-site-kit'), {
            br: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx)("br", {}),
            a: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx)(_js_components_Link__WEBPACK_IMPORTED_MODULE_5__["default"], {
              href: consentModeDocumentationURL,
              "aria-label": (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Learn more about consent mode', 'google-site-kit'),
              onClick: async () => {
                await (0,_js_util__WEBPACK_IMPORTED_MODULE_8__.trackEvent)(`${viewContext}_CoMo`, 'como_learn_more');
              },
              external: true
            })
          })
        })
      })]
    }), showConfirmDialog && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx)(_ConfirmDisableConsentModeDialog__WEBPACK_IMPORTED_MODULE_7__["default"], {
      onConfirm: () => {
        (0,_js_util__WEBPACK_IMPORTED_MODULE_8__.trackEvent)(`${viewContext}_CoMo`, 'confirm_disconnect');
        setConsentModeEnabled(false);
        setShowConfirmDialog(false);
        saveSettings();
      },
      onCancel: () => {
        (0,_js_util__WEBPACK_IMPORTED_MODULE_8__.trackEvent)(`${viewContext}_CoMo`, 'cancel_disconnect');
        setShowConfirmDialog(false);
      }
    })]
  });
}

/***/ }),

/***/ "./js/components/consent-mode/WPConsentAPIRequirement.js":
/*!***************************************************************!*\
  !*** ./js/components/consent-mode/WPConsentAPIRequirement.js ***!
  \***************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ WPConsentAPIRequirement)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _js_components_Typography__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @/js/components/Typography */ "./js/components/Typography/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



function WPConsentAPIRequirement({
  title,
  description,
  footer
}) {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsxs)("div", {
    className: "googlesitekit-settings-consent-mode-requirement",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)(_js_components_Typography__WEBPACK_IMPORTED_MODULE_0__["default"], {
      as: "h4",
      size: "large",
      type: "title",
      children: title
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("p", {
      className: "googlesitekit-settings-consent-mode-requirement__description",
      children: description
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("footer", {
      className: "googlesitekit-settings-consent-mode-requirement__footer",
      children: footer
    })]
  });
}
WPConsentAPIRequirement.propTypes = {
  title: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().string).isRequired,
  description: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().node).isRequired,
  footer: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().node).isRequired
};

/***/ }),

/***/ "./js/components/consent-mode/WPConsentAPIRequirements.js":
/*!****************************************************************!*\
  !*** ./js/components/consent-mode/WPConsentAPIRequirements.js ***!
  \****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ WPConsentAPIRequirements)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/@wordpress/element/build-module/create-interpolate-element.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _js_googlesitekit_components_gm2_SpinnerButton__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/googlesitekit/components-gm2/SpinnerButton */ "./js/googlesitekit/components-gm2/SpinnerButton.js");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _js_material_components__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/material-components */ "./js/material-components/index.js");
/* harmony import */ var _js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/googlesitekit/datastore/site/constants */ "./js/googlesitekit/datastore/site/constants.js");
/* harmony import */ var _js_components_Link__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/components/Link */ "./js/components/Link.js");
/* harmony import */ var _WPConsentAPIRequirement__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./WPConsentAPIRequirement */ "./js/components/consent-mode/WPConsentAPIRequirement.js");
/* harmony import */ var _svg_icons_tick_svg__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @/svg/icons/tick.svg */ "./svg/icons/tick.svg");
/* harmony import */ var _js_util__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @/js/util */ "./js/util/index.js");
/* harmony import */ var _js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @/js/hooks/useViewContext */ "./js/hooks/useViewContext.js");
/* harmony import */ var _js_components_ErrorNotice__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @/js/components/ErrorNotice */ "./js/components/ErrorNotice.js");
/* harmony import */ var _js_components_Notice__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @/js/components/Notice */ "./js/components/Notice/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */












function WPConsentAPIRequirements() {
  const viewContext = (0,_js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_9__["default"])();
  const wpConsentAPIDocumentationURL = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.useSelect)(select => select(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_4__.CORE_SITE).getDocumentationLinkURL('wp-consent-api'));
  const consentManagementPlatformDocumentationURL = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.useSelect)(select => select(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_4__.CORE_SITE).getDocumentationLinkURL('consent-management-platform'));
  const {
    hasConsentAPI,
    wpConsentPlugin
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.useSelect)(select => select(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_4__.CORE_SITE).getConsentAPIInfo());
  const {
    installActivateWPConsentAPI,
    activateConsentAPI
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.useDispatch)(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_4__.CORE_SITE);

  // Check for `installActivateWPConsentAPIError` errors, mostly to cover
  // the case if user is offline, but also any other potential
  // case that nonces fetch fails. As `installActivateWPConsentAPI`
  // action will invoke fetch for nonce, and when offline this will fail.
  const installActivateWPConsentAPIError = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.useSelect)(select => select(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_4__.CORE_SITE).getErrorForAction('installActivateWPConsentAPI'));
  const isInstallingAndActivating = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.useSelect)(select => select(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_4__.CORE_SITE).isApiFetching());
  const isActivating = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.useSelect)(select => select(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_4__.CORE_SITE).isFetchingActivateConsentAPI());
  const apiInstallResponse = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.useSelect)(select => select(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_4__.CORE_SITE).getApiInstallResponse());
  const apiInstallHasError = (installActivateWPConsentAPIError ? installActivateWPConsentAPIError.message : null) || apiInstallResponse?.error;
  const cellProps = {
    smSize: 4,
    mdSize: 4,
    lgSize: 6
  };
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_13__.useEffect)(() => {
    if (hasConsentAPI) {
      (0,_js_util__WEBPACK_IMPORTED_MODULE_8__.trackEvent)(`${viewContext}_CoMo`, 'wp_consent_api_active');
    }
  }, [hasConsentAPI, viewContext]);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsxs)(_wordpress_element__WEBPACK_IMPORTED_MODULE_13__.Fragment, {
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx)("p", {
      className: "googlesitekit-settings-consent-mode-requirements__description",
      children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('In order for consent mode to work properly, these requirements must be met:', 'google-site-kit')
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx)(_js_material_components__WEBPACK_IMPORTED_MODULE_3__.Grid, {
      className: "googlesitekit-settings-consent-mode-requirements__grid",
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsxs)(_js_material_components__WEBPACK_IMPORTED_MODULE_3__.Row, {
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx)(_js_material_components__WEBPACK_IMPORTED_MODULE_3__.Cell, {
          ...cellProps,
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx)(_WPConsentAPIRequirement__WEBPACK_IMPORTED_MODULE_6__["default"], {
            title: wpConsentPlugin?.installed ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Activate WP Consent API', 'google-site-kit') : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Install WP Consent API', 'google-site-kit'),
            description: (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_14__["default"])((0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('WP Consent API is a plugin that standardizes the communication of accepted consent categories between plugins. <a>Learn more</a>', 'google-site-kit'), {
              a: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx)(_js_components_Link__WEBPACK_IMPORTED_MODULE_5__["default"], {
                href: wpConsentAPIDocumentationURL,
                "aria-label": (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Learn more about the WP Consent API', 'google-site-kit'),
                onClick: async () => {
                  await (0,_js_util__WEBPACK_IMPORTED_MODULE_8__.trackEvent)(`${viewContext}_CoMo`, 'wp_consent_api_learn_more');
                },
                external: true
              })
            }),
            footer: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsxs)(_wordpress_element__WEBPACK_IMPORTED_MODULE_13__.Fragment, {
              children: [hasConsentAPI && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsxs)("div", {
                className: "googlesitekit-settings-consent-mode-requirement__consent-api-detected-wrapper",
                children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx)("span", {
                  className: "googlesitekit-settings-consent-mode-requirement__consent-api-detected-icon",
                  children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx)(_svg_icons_tick_svg__WEBPACK_IMPORTED_MODULE_7__["default"], {})
                }), (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Site Kit detected WP Consent API for your site', 'google-site-kit')]
              }), !hasConsentAPI && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsxs)(_wordpress_element__WEBPACK_IMPORTED_MODULE_13__.Fragment, {
                children: [wpConsentPlugin.installed && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsxs)(_wordpress_element__WEBPACK_IMPORTED_MODULE_13__.Fragment, {
                  children: [!!apiInstallResponse?.error && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx)(_js_components_ErrorNotice__WEBPACK_IMPORTED_MODULE_10__["default"], {
                    message: apiInstallResponse?.error,
                    skipRetryMessage: true,
                    hideIcon: true
                  }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx)(_js_googlesitekit_components_gm2_SpinnerButton__WEBPACK_IMPORTED_MODULE_1__["default"], {
                    className: "googlesitekit-settings-consent-mode-requirement__install-button",
                    isSaving: isActivating,
                    disabled: isActivating,
                    onClick: async () => {
                      activateConsentAPI();
                      await (0,_js_util__WEBPACK_IMPORTED_MODULE_8__.trackEvent)(`${viewContext}_CoMo`, 'wp_consent_api_activate');
                    },
                    children: !!apiInstallResponse?.error ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Retry', 'google-site-kit') : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Activate', 'google-site-kit')
                  })]
                }), !wpConsentPlugin.installed && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsxs)(_wordpress_element__WEBPACK_IMPORTED_MODULE_13__.Fragment, {
                  children: [apiInstallHasError && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx)(_js_components_ErrorNotice__WEBPACK_IMPORTED_MODULE_10__["default"], {
                    message: apiInstallHasError,
                    skipRetryMessage: true,
                    hideIcon: true
                  }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx)(_js_googlesitekit_components_gm2_SpinnerButton__WEBPACK_IMPORTED_MODULE_1__["default"], {
                    className: "googlesitekit-settings-consent-mode-requirement__install-button",
                    isSaving: isInstallingAndActivating,
                    disabled: isInstallingAndActivating,
                    onClick: async () => {
                      installActivateWPConsentAPI();
                      await (0,_js_util__WEBPACK_IMPORTED_MODULE_8__.trackEvent)(`${viewContext}_CoMo`, 'wp_consent_api_install');
                    },
                    children: apiInstallHasError ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Retry', 'google-site-kit') : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Install', 'google-site-kit')
                  })]
                })]
              })]
            })
          })
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx)(_js_material_components__WEBPACK_IMPORTED_MODULE_3__.Cell, {
          ...cellProps,
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx)(_WPConsentAPIRequirement__WEBPACK_IMPORTED_MODULE_6__["default"], {
            title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Install consent management plugin', 'google-site-kit'),
            description: (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_14__["default"])((0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('You’ll need a plugin compatible with the WP Consent API to display a notice to site visitors and get their consent for tracking. WordPress offers a variety of consent plugins you can choose from. <a>See suggested plugins</a>', 'google-site-kit'), {
              a: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx)(_js_components_Link__WEBPACK_IMPORTED_MODULE_5__["default"], {
                href: consentManagementPlatformDocumentationURL,
                "aria-label": (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Suggested consent management plugins', 'google-site-kit'),
                onClick: async () => {
                  await (0,_js_util__WEBPACK_IMPORTED_MODULE_8__.trackEvent)(`${viewContext}_CoMo`, 'consent_mgmt_plugin_learn_more');
                },
                external: true
              })
            }),
            footer: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx)(_js_components_Notice__WEBPACK_IMPORTED_MODULE_11__["default"], {
              type: _js_components_Notice__WEBPACK_IMPORTED_MODULE_11__["default"].TYPES.INFO,
              className: "googlesitekit-notice--small",
              description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Make sure you have installed a plugin compatible with WP Consent API (Site Kit isn't able to verify the compatibility of all WP plugins).", 'google-site-kit')
            })
          })
        })]
      })
    })]
  });
}

/***/ }),

/***/ "./js/components/consent-mode/constants.js":
/*!*************************************************!*\
  !*** ./js/components/consent-mode/constants.js ***!
  \*************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   CONSENT_MODE_SETUP_CTA_WIDGET_SLUG: () => (/* binding */ CONSENT_MODE_SETUP_CTA_WIDGET_SLUG)
/* harmony export */ });
/**
 * Consent Mode components - constants.
 *
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

const CONSENT_MODE_SETUP_CTA_WIDGET_SLUG = 'consent-mode-setup-cta-widget';

/***/ }),

/***/ "./js/components/help/HelpMenu.js":
/*!****************************************!*\
  !*** ./js/components/help/HelpMenu.js ***!
  \****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ HelpMenu)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_15___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_15__);
/* harmony import */ var react_use__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! react-use */ "../node_modules/react-use/esm/useClickAway.js");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _wordpress_keycodes__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! @wordpress/keycodes */ "../node_modules/@wordpress/keycodes/build-module/index.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! googlesitekit-components */ "googlesitekit-components");
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_components__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _svg_icons_help_svg__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/svg/icons/help.svg */ "./svg/icons/help.svg");
/* harmony import */ var _js_hooks_useKeyCodesInside__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/hooks/useKeyCodesInside */ "./js/hooks/useKeyCodesInside.js");
/* harmony import */ var _js_util__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/util */ "./js/util/index.js");
/* harmony import */ var _HelpMenuLink__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./HelpMenuLink */ "./js/components/help/HelpMenuLink.js");
/* harmony import */ var _js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @/js/googlesitekit/modules/datastore/constants */ "./js/googlesitekit/modules/datastore/constants.js");
/* harmony import */ var _js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @/js/hooks/useViewContext */ "./js/hooks/useViewContext.js");
/* harmony import */ var _js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @/js/googlesitekit/datastore/site/constants */ "./js/googlesitekit/datastore/site/constants.js");
/* harmony import */ var _js_modules_adsense_constants__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @/js/modules/adsense/constants */ "./js/modules/adsense/constants.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * HelpMenu component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * WordPress dependencies
 */




/**
 * Internal dependencies
 */











function HelpMenu({
  children
}) {
  const [menuOpen, setMenuOpen] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_12__.useState)(false);
  const menuWrapperRef = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_12__.useRef)();
  const viewContext = (0,_js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_8__["default"])();
  (0,react_use__WEBPACK_IMPORTED_MODULE_13__["default"])(menuWrapperRef, () => setMenuOpen(false));
  (0,_js_hooks_useKeyCodesInside__WEBPACK_IMPORTED_MODULE_4__.useKeyCodesInside)([_wordpress_keycodes__WEBPACK_IMPORTED_MODULE_14__.ESCAPE, _wordpress_keycodes__WEBPACK_IMPORTED_MODULE_14__.TAB], menuWrapperRef, () => setMenuOpen(false));
  const adSenseModuleActive = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_7__.CORE_MODULES).isModuleActive(_js_modules_adsense_constants__WEBPACK_IMPORTED_MODULE_10__.MODULE_SLUG_ADSENSE));
  const handleMenu = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_12__.useCallback)(() => {
    if (!menuOpen) {
      (0,_js_util__WEBPACK_IMPORTED_MODULE_5__.trackEvent)(`${viewContext}_headerbar`, 'open_helpmenu');
    }
    setMenuOpen(!menuOpen);
  }, [menuOpen, viewContext]);
  const handleMenuSelected = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_12__.useCallback)(() => {
    setMenuOpen(false);
  }, []);
  const fixCommonIssuesURL = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => {
    return select(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_9__.CORE_SITE).getDocumentationLinkURL('fix-common-issues');
  });
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("div", {
    ref: menuWrapperRef,
    className: "googlesitekit-dropdown-menu googlesitekit-dropdown-menu__icon-menu mdc-menu-surface--anchor",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_2__.Button, {
      "aria-controls": "googlesitekit-help-menu",
      "aria-expanded": menuOpen,
      "aria-label": (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Help', 'google-site-kit'),
      "aria-haspopup": "menu",
      className: "googlesitekit-header__dropdown googlesitekit-border-radius-round googlesitekit-button-icon googlesitekit-help-menu__button mdc-button--dropdown",
      icon: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_svg_icons_help_svg__WEBPACK_IMPORTED_MODULE_3__["default"], {
        width: "20",
        height: "20"
      }),
      onClick: handleMenu,
      tooltipEnterDelayInMS: 500,
      text: true
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_2__.Menu, {
      className: "googlesitekit-width-auto",
      menuOpen: menuOpen,
      id: "googlesitekit-help-menu",
      onSelected: handleMenuSelected,
      children: [children, /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_HelpMenuLink__WEBPACK_IMPORTED_MODULE_6__["default"], {
        gaEventLabel: "fix_common_issues",
        href: fixCommonIssuesURL,
        children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Fix common issues', 'google-site-kit')
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_HelpMenuLink__WEBPACK_IMPORTED_MODULE_6__["default"], {
        gaEventLabel: "documentation",
        href: "https://sitekit.withgoogle.com/documentation/",
        children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Read help docs', 'google-site-kit')
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_HelpMenuLink__WEBPACK_IMPORTED_MODULE_6__["default"], {
        gaEventLabel: "support_forum",
        href: "https://wordpress.org/support/plugin/google-site-kit/",
        children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Get support', 'google-site-kit')
      }), adSenseModuleActive && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_HelpMenuLink__WEBPACK_IMPORTED_MODULE_6__["default"], {
        gaEventLabel: "adsense_help",
        href: "https://support.google.com/adsense/",
        children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Get help with AdSense', 'google-site-kit')
      })]
    })]
  });
}
HelpMenu.propTypes = {
  children: (prop_types__WEBPACK_IMPORTED_MODULE_15___default().node)
};

/***/ }),

/***/ "./js/components/help/HelpMenuLink.js":
/*!********************************************!*\
  !*** ./js/components/help/HelpMenuLink.js ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _js_components_Link__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @/js/components/Link */ "./js/components/Link.js");
/* harmony import */ var _js_util__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/util */ "./js/util/index.js");
/* harmony import */ var _js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/hooks/useViewContext */ "./js/hooks/useViewContext.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * HelpMenuLink component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */




function HelpMenuLink({
  children,
  href,
  gaEventLabel
}) {
  const viewContext = (0,_js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_2__["default"])();
  const onClick = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_4__.useCallback)(async () => {
    if (gaEventLabel) {
      await (0,_js_util__WEBPACK_IMPORTED_MODULE_1__.trackEvent)(`${viewContext}_headerbar_helpmenu`, 'click_outgoing_link', gaEventLabel);
    }
  }, [gaEventLabel, viewContext]);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("li", {
    className: "googlesitekit-help-menu-link mdc-list-item",
    role: "none",
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_js_components_Link__WEBPACK_IMPORTED_MODULE_0__["default"], {
      className: "mdc-list-item__text",
      href: href,
      role: "menuitem",
      onClick: onClick,
      external: true,
      hideExternalIndicator: true,
      children: children
    })
  });
}
HelpMenuLink.propTypes = {
  children: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().node).isRequired,
  href: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().string).isRequired,
  gaEventLabel: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().string)
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (HelpMenuLink);

/***/ }),

/***/ "./js/components/layout/Layout.js":
/*!****************************************!*\
  !*** ./js/components/layout/Layout.js ***!
  \****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _LayoutHeader__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./LayoutHeader */ "./js/components/layout/LayoutHeader.js");
/* harmony import */ var _LayoutFooter__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./LayoutFooter */ "./js/components/layout/LayoutFooter.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Layout component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */



class Layout extends _wordpress_element__WEBPACK_IMPORTED_MODULE_4__.Component {
  render() {
    const {
      header,
      footer,
      children,
      title,
      badge,
      headerCTALabel,
      headerCTALink,
      footerCTALabel,
      footerCTALink,
      footerContent,
      className,
      fill,
      relative,
      rounded = false,
      transparent = false,
      ...otherProps
    } = this.props;
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
      className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-layout', className, {
        'googlesitekit-layout--fill': fill,
        'googlesitekit-layout--relative': relative,
        'googlesitekit-layout--rounded': rounded,
        'googlesitekit-layout--transparent': transparent
      }),
      ...otherProps,
      children: [header && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_LayoutHeader__WEBPACK_IMPORTED_MODULE_1__["default"], {
        title: title,
        badge: badge,
        ctaLabel: headerCTALabel,
        ctaLink: headerCTALink
      }), children, footer && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_LayoutFooter__WEBPACK_IMPORTED_MODULE_2__["default"], {
        ctaLabel: footerCTALabel,
        ctaLink: footerCTALink,
        footerContent: footerContent
      })]
    });
  }
}
Layout.propTypes = {
  header: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().bool),
  footer: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().bool),
  children: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().node).isRequired,
  title: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().string),
  badge: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().node),
  headerCTALabel: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().string),
  headerCTALink: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().string),
  footerCTALabel: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().string),
  footerCTALink: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().string),
  footerContent: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().node),
  className: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().string),
  fill: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().bool),
  relative: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().bool),
  rounded: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().bool),
  transparent: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().bool)
};
Layout.defaultProps = {
  header: false,
  footer: false,
  title: '',
  badge: null,
  headerCTALabel: '',
  headerCTALink: '',
  footerCTALabel: '',
  footerCTALink: '',
  footerContent: null,
  className: '',
  fill: false,
  relative: false
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Layout);

/***/ }),

/***/ "./js/components/layout/LayoutFooter.js":
/*!**********************************************!*\
  !*** ./js/components/layout/LayoutFooter.js ***!
  \**********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _js_material_components__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @/js/material-components */ "./js/material-components/index.js");
/* harmony import */ var _js_components_SourceLink__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/components/SourceLink */ "./js/components/SourceLink.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * LayoutFooter component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */



class LayoutFooter extends _wordpress_element__WEBPACK_IMPORTED_MODULE_3__.Component {
  render() {
    const {
      ctaLabel,
      ctaLink,
      footerContent
    } = this.props;
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("footer", {
      className: "googlesitekit-layout__footer",
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)(_js_material_components__WEBPACK_IMPORTED_MODULE_0__.Grid, {
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)(_js_material_components__WEBPACK_IMPORTED_MODULE_0__.Row, {
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)(_js_material_components__WEBPACK_IMPORTED_MODULE_0__.Cell, {
            size: 12,
            children: [ctaLink && ctaLabel && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)(_js_components_SourceLink__WEBPACK_IMPORTED_MODULE_1__["default"], {
              className: "googlesitekit-data-block__source",
              name: ctaLabel,
              href: ctaLink,
              external: true
            }), footerContent]
          })
        })
      })
    });
  }
}
LayoutFooter.propTypes = {
  ctaLabel: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().string),
  ctaLink: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().string)
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (LayoutFooter);

/***/ }),

/***/ "./js/components/layout/LayoutHeader.js":
/*!**********************************************!*\
  !*** ./js/components/layout/LayoutHeader.js ***!
  \**********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _js_material_components__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @/js/material-components */ "./js/material-components/index.js");
/* harmony import */ var _js_components_Link__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/components/Link */ "./js/components/Link.js");
/* harmony import */ var _js_components_Typography__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/components/Typography */ "./js/components/Typography/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * LayoutHeader component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */




class LayoutHeader extends _wordpress_element__WEBPACK_IMPORTED_MODULE_4__.Component {
  render() {
    const {
      title,
      badge,
      ctaLabel,
      ctaLink
    } = this.props;
    const titleCellProps = ctaLink ? {
      alignMiddle: true,
      smSize: 4,
      lgSize: 6
    } : {
      alignMiddle: true,
      smSize: 4,
      mdSize: 8,
      lgSize: 12
    };
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("header", {
      className: "googlesitekit-layout__header",
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_js_material_components__WEBPACK_IMPORTED_MODULE_0__.Grid, {
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)(_js_material_components__WEBPACK_IMPORTED_MODULE_0__.Row, {
          children: [title && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_js_material_components__WEBPACK_IMPORTED_MODULE_0__.Cell, {
            ...titleCellProps,
            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)(_js_components_Typography__WEBPACK_IMPORTED_MODULE_2__["default"], {
              as: "h3",
              size: "small",
              type: "title",
              className: "googlesitekit-subheading-1 googlesitekit-layout__header-title",
              children: [title, badge]
            })
          }), ctaLink && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_js_material_components__WEBPACK_IMPORTED_MODULE_0__.Cell, {
            smSize: 4,
            lgSize: 6,
            alignMiddle: true,
            mdAlignRight: true,
            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_js_components_Link__WEBPACK_IMPORTED_MODULE_1__["default"], {
              href: ctaLink,
              external: true,
              children: ctaLabel
            })
          })]
        })
      })
    });
  }
}
LayoutHeader.propTypes = {
  title: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().string),
  badge: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().node),
  ctaLabel: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().string),
  ctaLink: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().string)
};
LayoutHeader.defaultProps = {
  title: '',
  badge: null,
  ctaLabel: '',
  ctaLink: ''
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (LayoutHeader);

/***/ }),

/***/ "./js/components/notifications/AdBlockerWarning.js":
/*!*********************************************************!*\
  !*** ./js/components/notifications/AdBlockerWarning.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ AdBlockerWarning)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/googlesitekit/datastore/site/constants */ "./js/googlesitekit/datastore/site/constants.js");
/* harmony import */ var _js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/googlesitekit/modules/datastore/constants */ "./js/googlesitekit/modules/datastore/constants.js");
/* harmony import */ var _AdBlockerWarningMessage__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./AdBlockerWarningMessage */ "./js/components/notifications/AdBlockerWarningMessage.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * AdSense AdBlockerWarning component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * Internal dependencies
 */





function AdBlockerWarning({
  moduleSlug,
  className
}) {
  const storeName = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useSelect)(select => select(_js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_2__.CORE_MODULES).getModuleStoreName(moduleSlug));
  const adBlockerWarningMessage = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useSelect)(select => select(storeName)?.getAdBlockerWarningMessage());
  const getHelpLink = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useSelect)(select => select(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_1__.CORE_SITE).getDocumentationLinkURL(`${moduleSlug}-ad-blocker-detected`));
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(_AdBlockerWarningMessage__WEBPACK_IMPORTED_MODULE_3__["default"], {
    className: className,
    getHelpLink: getHelpLink,
    warningMessage: adBlockerWarningMessage
  });
}
AdBlockerWarning.propTypes = {
  className: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().string),
  moduleSlug: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().string).isRequired
};

/***/ }),

/***/ "./js/components/notifications/AdBlockerWarningMessage.js":
/*!****************************************************************!*\
  !*** ./js/components/notifications/AdBlockerWarningMessage.js ***!
  \****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ AdBlockerWarningMessage)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/@wordpress/element/build-module/create-interpolate-element.js");
/* harmony import */ var _js_components_Link__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/components/Link */ "./js/components/Link.js");
/* harmony import */ var _svg_icons_external_rounded_svg__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/svg/icons/external-rounded.svg */ "./svg/icons/external-rounded.svg");
/* harmony import */ var _js_components_Notice__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/components/Notice */ "./js/components/Notice/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * AdBlockerWarningMessage component.
 *
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */




function AdBlockerWarningMessage({
  getHelpLink = '',
  warningMessage = null
}) {
  if (!warningMessage) {
    return null;
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(_js_components_Notice__WEBPACK_IMPORTED_MODULE_3__["default"], {
    className: "googlesitekit-notice--small",
    type: _js_components_Notice__WEBPACK_IMPORTED_MODULE_3__["default"].TYPES.WARNING,
    description: (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_5__["default"])((0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.sprintf)(/* translators: 1: The warning message. 2: "Get help" text. */
    (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('%1$s. <Link><Strong>%2$s</Strong></Link>', 'google-site-kit'), warningMessage, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Get help', 'google-site-kit')), {
      Link: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(_js_components_Link__WEBPACK_IMPORTED_MODULE_1__["default"], {
        href: getHelpLink,
        trailingIcon: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(_svg_icons_external_rounded_svg__WEBPACK_IMPORTED_MODULE_2__["default"], {
          width: 15,
          height: 15
        }),
        external: true,
        hideExternalIndicator: true
      }),
      Strong: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("strong", {})
    }),
    hideIcon: true
  });
}
AdBlockerWarningMessage.propTypes = {
  getHelpLink: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().string),
  warningMessage: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().string)
};

/***/ }),

/***/ "./js/components/notifications/CTA.js":
/*!********************************************!*\
  !*** ./js/components/notifications/CTA.js ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-components */ "googlesitekit-components");
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _js_components_Link__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/components/Link */ "./js/components/Link.js");
/* harmony import */ var _js_components_Typography__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/components/Typography */ "./js/components/Typography/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * CTA component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * Internal dependencies
 */




function CTA({
  title,
  headerText,
  headerContent,
  description,
  ctaLink,
  ctaLabel,
  ctaLinkExternal,
  ctaType,
  error,
  onClick,
  'aria-label': ariaLabel,
  children
}) {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsxs)("div", {
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-cta', {
      'googlesitekit-cta--error': error
    }),
    children: [(headerText || headerContent) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsxs)("div", {
      className: "googlesitekit-cta__header",
      children: [headerText && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(_js_components_Typography__WEBPACK_IMPORTED_MODULE_3__["default"], {
        as: "h2",
        size: "small",
        type: "label",
        className: "googlesitekit-cta__header_text",
        children: headerText
      }), headerContent]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsxs)("div", {
      className: "googlesitekit-cta__body",
      children: [title && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(_js_components_Typography__WEBPACK_IMPORTED_MODULE_3__["default"], {
        as: "h3",
        size: "small",
        type: "title",
        className: "googlesitekit-cta__title",
        children: title
      }), description && typeof description === 'string' && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("p", {
        className: "googlesitekit-cta__description",
        children: description
      }), description && typeof description !== 'string' && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("div", {
        className: "googlesitekit-cta__description",
        children: description
      }), ctaLabel && ctaType === 'button' && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__.Button, {
        "aria-label": ariaLabel,
        href: ctaLink,
        onClick: onClick,
        children: ctaLabel
      }), ctaLabel && ctaType === 'link' && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(_js_components_Link__WEBPACK_IMPORTED_MODULE_2__["default"], {
        href: ctaLink,
        onClick: onClick,
        "aria-label": ariaLabel,
        external: ctaLinkExternal,
        hideExternalIndicator: ctaLinkExternal,
        arrow: true,
        children: ctaLabel
      }), children]
    })]
  });
}
CTA.propTypes = {
  title: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().string).isRequired,
  headerText: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().string),
  description: prop_types__WEBPACK_IMPORTED_MODULE_5___default().oneOfType([(prop_types__WEBPACK_IMPORTED_MODULE_5___default().string), (prop_types__WEBPACK_IMPORTED_MODULE_5___default().node)]),
  ctaLink: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().string),
  ctaLinkExternal: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().bool),
  ctaLabel: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().string),
  ctaType: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().string),
  'aria-label': (prop_types__WEBPACK_IMPORTED_MODULE_5___default().string),
  error: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().bool),
  onClick: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().func),
  children: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().node),
  headerContent: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().node)
};
CTA.defaultProps = {
  title: '',
  headerText: '',
  headerContent: '',
  description: '',
  ctaLink: '',
  ctaLabel: '',
  ctaType: 'link',
  error: false,
  onClick: () => {}
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (CTA);

/***/ }),

/***/ "./js/components/notifications/CoreSiteBannerNotification.js":
/*!*******************************************************************!*\
  !*** ./js/components/notifications/CoreSiteBannerNotification.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/googlesitekit/datastore/site/constants */ "./js/googlesitekit/datastore/site/constants.js");
/* harmony import */ var _js_components_NotificationFromServer__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/components/NotificationFromServer */ "./js/components/NotificationFromServer.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * CoreSiteBannerNotification component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */




function CoreSiteBannerNotification({
  id,
  ...props
}) {
  const {
    dismissNotification,
    acceptNotification
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useDispatch)(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_2__.CORE_SITE);
  const onCTAClick = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_5__.useCallback)(() => {
    acceptNotification(id);
  }, [id, acceptNotification]);
  const onDismissClick = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_5__.useCallback)(() => {
    dismissNotification(id);
  }, [id, dismissNotification]);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(_js_components_NotificationFromServer__WEBPACK_IMPORTED_MODULE_3__["default"], {
    onCTAClick: onCTAClick,
    onDismissClick: onDismissClick,
    ...props,
    id: id
  });
}
CoreSiteBannerNotification.propTypes = {
  content: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().string),
  ctaLabel: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().string),
  ctaTarget: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().string),
  ctaURL: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().string),
  dismissLabel: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().string),
  dismissible: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().bool),
  gaTrackingEventArgs: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().object),
  id: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().string).isRequired,
  learnMoreLabel: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().string),
  learnMoreURL: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().string),
  title: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().string).isRequired
};
CoreSiteBannerNotification.defaultProps = {
  content: '',
  ctaLabel: '',
  ctaTarget: '',
  ctaURL: '',
  dismissLabel: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('OK, Got it!', 'google-site-kit'),
  dismissible: true,
  learnMoreLabel: '',
  learnMoreURL: ''
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (CoreSiteBannerNotification);

/***/ }),

/***/ "./js/components/notifications/CoreSiteBannerNotifications.js":
/*!********************************************************************!*\
  !*** ./js/components/notifications/CoreSiteBannerNotifications.js ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/hooks/useViewContext */ "./js/hooks/useViewContext.js");
/* harmony import */ var _js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/googlesitekit/datastore/site/constants */ "./js/googlesitekit/datastore/site/constants.js");
/* harmony import */ var _js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/googlesitekit/datastore/user/constants */ "./js/googlesitekit/datastore/user/constants.js");
/* harmony import */ var _js_googlesitekit_notifications_datastore_constants__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/googlesitekit/notifications/datastore/constants */ "./js/googlesitekit/notifications/datastore/constants.js");
/* harmony import */ var _js_googlesitekit_notifications_constants__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/googlesitekit/notifications/constants */ "./js/googlesitekit/notifications/constants.js");
/* harmony import */ var _CoreSiteBannerNotification__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./CoreSiteBannerNotification */ "./js/components/notifications/CoreSiteBannerNotification.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * CoreSiteBannerNotifications component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */








const MAX_SECONDS_FOR_SURVEY = 5;

/**
 * Registers notifications from the server, if any exist in the data store.
 *
 * This is a side-effect component that does not render anything directly.
 *
 * @since 1.157.0
 *
 * @return {null} Returns null as this component does not render anything directly.
 */
function CoreSiteBannerNotifications() {
  const viewContext = (0,_js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_1__["default"])();
  const [surveysHaveLoaded, setSurveysHaveLoaded] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_8__.useState)(false);
  const [hasSurveys, setHasSurveys] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_8__.useState)(false);

  // This check doesn't rely on an actual date; we only need to track the
  // elapsed number of seconds since this component was rendered to see when
  // to cause a survey to appear after page load.
  const startTime = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_8__.useRef)(Date.now()); // eslint-disable-line sitekit/no-direct-date

  const surveys = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useSelect)(select => select(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_2__.CORE_SITE).isUsingProxy() && select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_USER).areSurveysOnCooldown() === false ? select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_USER).getCurrentSurvey() : null);
  const [registeredNotifications, setRegisteredNotifications] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_8__.useState)([]);
  const {
    registerNotification
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useDispatch)(_js_googlesitekit_notifications_datastore_constants__WEBPACK_IMPORTED_MODULE_4__.CORE_NOTIFICATIONS);
  const notifications = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useSelect)(select => select(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_2__.CORE_SITE).getNotifications());
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_8__.useEffect)(() => {
    const timer = setTimeout(() => {
      if (!hasSurveys) {
        setSurveysHaveLoaded(true);
      }
    }, MAX_SECONDS_FOR_SURVEY * 1000);
    return () => {
      clearTimeout(timer);
    };
  }, [hasSurveys]);
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_8__.useEffect)(() => {
    const secondsElapsed = Math.floor(
    // See comment above; this is just about tracking elapsed
    // seconds since this component first rendered, so we
    // shouldn't use the reference date.
    (Date.now() - startTime.current) / 1000 // eslint-disable-line sitekit/no-direct-date
    );
    // Surveys that were received in time prevent the render, surveys loaded
    // after a set amount of time do not prevent notifications from rendering.
    if (secondsElapsed < MAX_SECONDS_FOR_SURVEY && surveys) {
      setHasSurveys(true);
    }
  }, [startTime, surveys, setHasSurveys]);
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_8__.useEffect)(() => {
    // If surveys haven't loaded yet or there are surveys on-screen, we don't
    // register any server notifications.
    if (!surveysHaveLoaded || hasSurveys) {
      return;
    }

    // Register any notifications from the server that haven't yet been
    // registered.
    //
    // (Usually there will be one, if any, notification from the server.)
    notifications?.forEach(notification => {
      if (registeredNotifications.includes(notification.id)) {
        return;
      }

      // Before refactoring our Banner Notifications, `CoreSiteBannerNotification` added the
      // constant GA event category (initalised below) but the notification ID from the server
      // was passed as the event label to differentiate multiple notifications from
      // the server. So we continue to do that here for consistency with historical events.
      const gaTrackingEventArgs = {
        category: `${viewContext}_remote-site-notification`,
        label: notification.id
      };
      registerNotification(notification.id, {
        Component({
          Notification
        }) {
          return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(Notification, {
            gaTrackingEventArgs: gaTrackingEventArgs,
            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_CoreSiteBannerNotification__WEBPACK_IMPORTED_MODULE_6__["default"], {
              ...notification,
              gaTrackingEventArgs: gaTrackingEventArgs
            })
          });
        },
        priority: notification.priority,
        areaSlug: _js_googlesitekit_notifications_constants__WEBPACK_IMPORTED_MODULE_5__.NOTIFICATION_AREAS.HEADER,
        isDismissible: notification.dismissible
      });
      setRegisteredNotifications(previousRegisteredNotifications => {
        previousRegisteredNotifications.push(notification.id);
        return previousRegisteredNotifications;
      });
    });
  }, [viewContext, hasSurveys, notifications, registerNotification, registeredNotifications, surveysHaveLoaded]);
  return null;
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (CoreSiteBannerNotifications);

/***/ }),

/***/ "./js/components/notifications/InternalServerError.js":
/*!************************************************************!*\
  !*** ./js/components/notifications/InternalServerError.js ***!
  \************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ InternalServerError)
/* harmony export */ });
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/googlesitekit/datastore/site/constants */ "./js/googlesitekit/datastore/site/constants.js");
/* harmony import */ var _js_googlesitekit_notifications_components_layout_BannerNotification__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/googlesitekit/notifications/components/layout/BannerNotification */ "./js/googlesitekit/notifications/components/layout/BannerNotification.js");
/* harmony import */ var _js_googlesitekit_notifications_components_Notification__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/googlesitekit/notifications/components/Notification */ "./js/googlesitekit/notifications/components/Notification/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * InternalServerError component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Internal dependencies
 */





function InternalServerError() {
  const error = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useSelect)(select => select(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_1__.CORE_SITE).getInternalServerError());
  if (!error) {
    return null;
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(_js_googlesitekit_notifications_components_Notification__WEBPACK_IMPORTED_MODULE_3__["default"], {
    id: "internal-server-error",
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(_js_googlesitekit_notifications_components_layout_BannerNotification__WEBPACK_IMPORTED_MODULE_2__["default"], {
      notificationID: "internal-server-error",
      type: _js_googlesitekit_notifications_components_layout_BannerNotification__WEBPACK_IMPORTED_MODULE_2__.TYPES.ERROR,
      title: error.title,
      description: error.description
    })
  });
}

/***/ }),

/***/ "./js/components/notifications/LegacyNotifications.js":
/*!************************************************************!*\
  !*** ./js/components/notifications/LegacyNotifications.js ***!
  \************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ LegacyNotifications)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/googlesitekit/datastore/user/constants */ "./js/googlesitekit/datastore/user/constants.js");
/* harmony import */ var _CoreSiteBannerNotifications__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./CoreSiteBannerNotifications */ "./js/components/notifications/CoreSiteBannerNotifications.js");
/* harmony import */ var _js_hooks_useViewOnly__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/hooks/useViewOnly */ "./js/hooks/useViewOnly.js");
/* harmony import */ var _js_hooks_useDashboardType__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/hooks/useDashboardType */ "./js/hooks/useDashboardType.js");
/* harmony import */ var _InternalServerError__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./InternalServerError */ "./js/components/notifications/InternalServerError.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * BannerNotifications component.
 *
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */







function LegacyNotifications() {
  const viewOnly = (0,_js_hooks_useViewOnly__WEBPACK_IMPORTED_MODULE_3__["default"])();
  const dashboardType = (0,_js_hooks_useDashboardType__WEBPACK_IMPORTED_MODULE_4__["default"])();
  const isAuthenticated = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useSelect)(select => select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_1__.CORE_USER).isAuthenticated());
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)(_wordpress_element__WEBPACK_IMPORTED_MODULE_7__.Fragment, {
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(_InternalServerError__WEBPACK_IMPORTED_MODULE_5__["default"], {}), !viewOnly && dashboardType === _js_hooks_useDashboardType__WEBPACK_IMPORTED_MODULE_4__.DASHBOARD_TYPE_MAIN && isAuthenticated && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(_CoreSiteBannerNotifications__WEBPACK_IMPORTED_MODULE_2__["default"], {})]
  });
}

/***/ }),

/***/ "./js/components/notifications/ModuleSettingsWarning.js":
/*!**************************************************************!*\
  !*** ./js/components/notifications/ModuleSettingsWarning.js ***!
  \**************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ ModuleSettingsWarning)
/* harmony export */ });
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/googlesitekit/modules/datastore/constants */ "./js/googlesitekit/modules/datastore/constants.js");
/* harmony import */ var _js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/googlesitekit/datastore/user/constants */ "./js/googlesitekit/datastore/user/constants.js");
/* harmony import */ var _AdBlockerWarning__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./AdBlockerWarning */ "./js/components/notifications/AdBlockerWarning.js");
/* harmony import */ var _js_components_Notice__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/components/Notice */ "./js/components/Notice/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * ModuleSettingsWarning component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Internal dependencies
 */






function ModuleSettingsWarning({
  slug
}) {
  const error = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useSelect)(select => select(_js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_1__.CORE_MODULES)?.getCheckRequirementsError(slug));
  if (!error) {
    return null;
  }

  // The AdBlockerWarning component also renders the "Get help"
  // documentation URL in addition to the error message.
  if (_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_2__.ERROR_CODE_ADBLOCKER_ACTIVE === error.code) {
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_AdBlockerWarning__WEBPACK_IMPORTED_MODULE_3__["default"], {
      moduleSlug: slug
    });
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_js_components_Notice__WEBPACK_IMPORTED_MODULE_4__["default"], {
    className: "googlesitekit-notice--small",
    type: _js_components_Notice__WEBPACK_IMPORTED_MODULE_4__["default"].TYPES.WARNING,
    description: error.message,
    hideIcon: true
  });
}

/***/ }),

/***/ "./js/components/notifications/Notifications.js":
/*!******************************************************!*\
  !*** ./js/components/notifications/Notifications.js ***!
  \******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Notifications)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/hooks/useViewContext */ "./js/hooks/useViewContext.js");
/* harmony import */ var _js_googlesitekit_notifications_datastore_constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/googlesitekit/notifications/datastore/constants */ "./js/googlesitekit/notifications/datastore/constants.js");
/* harmony import */ var _js_googlesitekit_notifications_constants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/googlesitekit/notifications/constants */ "./js/googlesitekit/notifications/constants.js");
/* harmony import */ var _js_googlesitekit_notifications_util_component_props__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/googlesitekit/notifications/util/component-props */ "./js/googlesitekit/notifications/util/component-props.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Notifications component.
 *
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * Internal dependencies
 */






function Notifications({
  areaSlug,
  groupID = _js_googlesitekit_notifications_constants__WEBPACK_IMPORTED_MODULE_3__.NOTIFICATION_GROUPS.DEFAULT
}) {
  const viewContext = (0,_js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_1__["default"])();
  const queuedNotifications = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useSelect)(select => select(_js_googlesitekit_notifications_datastore_constants__WEBPACK_IMPORTED_MODULE_2__.CORE_NOTIFICATIONS).getQueuedNotifications(viewContext, groupID));
  if (queuedNotifications?.[0] === undefined || queuedNotifications?.[0]?.areaSlug !== areaSlug) {
    return null;
  }
  const {
    id,
    Component: ActiveNotification
  } = queuedNotifications[0];
  const props = {
    ...(0,_js_googlesitekit_notifications_util_component_props__WEBPACK_IMPORTED_MODULE_4__.getNotificationComponentProps)(id)
  };
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(ActiveNotification, {
    ...props
  });
}
Notifications.propTypes = {
  viewContext: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().string),
  areaSlug: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().string)
};

/***/ }),

/***/ "./js/components/settings/SettingsActiveModule/ConfirmDisconnect.js":
/*!**************************************************************************!*\
  !*** ./js/components/settings/SettingsActiveModule/ConfirmDisconnect.js ***!
  \**************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ ConfirmDisconnect)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_13___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_13__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _wordpress_keycodes__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! @wordpress/keycodes */ "../node_modules/@wordpress/keycodes/build-module/index.js");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _js_components_RefocusableModalDialog__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/components/RefocusableModalDialog */ "./js/components/RefocusableModalDialog.js");
/* harmony import */ var _js_googlesitekit_datastore_location_constants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/googlesitekit/datastore/location/constants */ "./js/googlesitekit/datastore/location/constants.js");
/* harmony import */ var _js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/googlesitekit/modules/datastore/constants */ "./js/googlesitekit/modules/datastore/constants.js");
/* harmony import */ var _js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/googlesitekit/datastore/site/constants */ "./js/googlesitekit/datastore/site/constants.js");
/* harmony import */ var _js_googlesitekit_datastore_ui_constants__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @/js/googlesitekit/datastore/ui/constants */ "./js/googlesitekit/datastore/ui/constants.js");
/* harmony import */ var _js_googlesitekit_api_cache__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @/js/googlesitekit/api/cache */ "./js/googlesitekit/api/cache.js");
/* harmony import */ var _js_util__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @/js/util */ "./js/util/index.js");
/* harmony import */ var _js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @/js/hooks/useViewContext */ "./js/hooks/useViewContext.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * ConfirmDisconnect component for SettingsActiveModule.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */




/**
 * Internal dependencies
 */










function ConfirmDisconnect({
  slug
}) {
  const viewContext = (0,_js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_9__["default"])();
  const [isDeactivating, setIsDeactivating] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_11__.useState)(false);
  const {
    setValue
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useDispatch)(_js_googlesitekit_datastore_ui_constants__WEBPACK_IMPORTED_MODULE_6__.CORE_UI);
  const dialogActiveKey = `module-${slug}-dialogActive`;
  const dependentModules = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_4__.CORE_MODULES).getModuleDependantNames(slug));
  const features = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_4__.CORE_MODULES).getModuleFeatures(slug));
  const module = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_4__.CORE_MODULES).getModule(slug));
  const settingsURL = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_5__.CORE_SITE).getAdminURL('googlesitekit-settings'));
  const dialogActive = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_datastore_ui_constants__WEBPACK_IMPORTED_MODULE_6__.CORE_UI).getValue(dialogActiveKey));
  const onClose = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_11__.useCallback)(() => {
    setValue(dialogActiveKey, false);
  }, [dialogActiveKey, setValue]);
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_11__.useEffect)(() => {
    function onKeyPress(event) {
      if (_wordpress_keycodes__WEBPACK_IMPORTED_MODULE_12__.ESCAPE === event.keyCode && dialogActive) {
        onClose();
      }
    }
    __webpack_require__.g.addEventListener('keydown', onKeyPress);
    return () => {
      __webpack_require__.g.removeEventListener('keydown', onKeyPress);
    };
  }, [dialogActive, onClose]);
  const {
    deactivateModule
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useDispatch)(_js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_4__.CORE_MODULES);
  const {
    navigateTo
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useDispatch)(_js_googlesitekit_datastore_location_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_LOCATION);
  const handleDisconnect = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_11__.useCallback)(async () => {
    if (module.forceActive) {
      return;
    }
    setIsDeactivating(true);
    const {
      error
    } = await deactivateModule(slug);
    if (!error) {
      await (0,_js_googlesitekit_api_cache__WEBPACK_IMPORTED_MODULE_7__.clearCache)();
      await (0,_js_util__WEBPACK_IMPORTED_MODULE_8__.trackEvent)(`${viewContext}_module-list`, 'deactivate_module', slug);
      navigateTo(settingsURL);
    } else {
      // Only set deactivating to false if there is an error.
      setIsDeactivating(false);
    }
  }, [slug, module?.forceActive, settingsURL, deactivateModule, navigateTo, viewContext]);
  if (!module || !dialogActive) {
    return null;
  }
  const {
    name
  } = module;
  const title = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.sprintf)(/* translators: %s: module name */
  (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Disconnect %s from Site Kit?', 'google-site-kit'), name);
  let dependentModulesText = null;
  if (dependentModules.length > 0) {
    dependentModulesText = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.sprintf)(/* translators: 1: module name, 2: list of dependent modules */
    (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('these active modules depend on %1$s and will also be disconnected: %2$s', 'google-site-kit'), name, (0,_js_util__WEBPACK_IMPORTED_MODULE_8__.listFormat)(dependentModules));
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)(_js_components_RefocusableModalDialog__WEBPACK_IMPORTED_MODULE_2__["default"], {
    className: "googlesitekit-settings-module__confirm-disconnect-modal",
    handleCancel: onClose,
    onClose: onClose,
    title: title,
    provides: features,
    handleConfirm: handleDisconnect,
    dependentModules: dependentModulesText,
    inProgress: isDeactivating,
    dialogActive: true,
    danger: true
  });
}
ConfirmDisconnect.propTypes = {
  slug: (prop_types__WEBPACK_IMPORTED_MODULE_13___default().string).isRequired
};

/***/ }),

/***/ "./js/components/settings/SettingsActiveModule/Footer.js":
/*!***************************************************************!*\
  !*** ./js/components/settings/SettingsActiveModule/Footer.js ***!
  \***************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Footer)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_12___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_12__);
/* harmony import */ var react_router_dom__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! react-router-dom */ "../node_modules/react-router/esm/react-router.js");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/googlesitekit/modules/datastore/constants */ "./js/googlesitekit/modules/datastore/constants.js");
/* harmony import */ var _js_material_components__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/material-components */ "./js/material-components/index.js");
/* harmony import */ var _js_util__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/util */ "./js/util/index.js");
/* harmony import */ var _js_googlesitekit_api_cache__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/googlesitekit/api/cache */ "./js/googlesitekit/api/cache.js");
/* harmony import */ var _js_googlesitekit_datastore_ui_constants__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/googlesitekit/datastore/ui/constants */ "./js/googlesitekit/datastore/ui/constants.js");
/* harmony import */ var _js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @/js/hooks/useViewContext */ "./js/hooks/useViewContext.js");
/* harmony import */ var _FooterPrimaryAction__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./FooterPrimaryAction */ "./js/components/settings/SettingsActiveModule/FooterPrimaryAction.js");
/* harmony import */ var _FooterSecondaryAction__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./FooterSecondaryAction */ "./js/components/settings/SettingsActiveModule/FooterSecondaryAction.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Footer component for SettingsActiveModule.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */










function Footer({
  slug
}) {
  const viewContext = (0,_js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_6__["default"])();
  const history = (0,react_router_dom__WEBPACK_IMPORTED_MODULE_10__.useHistory)();
  const {
    action,
    moduleSlug
  } = (0,react_router_dom__WEBPACK_IMPORTED_MODULE_10__.useParams)();
  const isEditing = action === 'edit' && moduleSlug === slug;
  const errorKey = `module-${slug}-error`;
  const dialogActiveKey = `module-${slug}-dialogActive`;
  const isSavingKey = `module-${slug}-isSaving`;
  const dialogActive = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useSelect)(select => select(_js_googlesitekit_datastore_ui_constants__WEBPACK_IMPORTED_MODULE_5__.CORE_UI).getValue(dialogActiveKey));
  const isSaving = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useSelect)(select => select(_js_googlesitekit_datastore_ui_constants__WEBPACK_IMPORTED_MODULE_5__.CORE_UI).getValue(isSavingKey));
  const module = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useSelect)(select => select(_js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_1__.CORE_MODULES).getModule(slug));
  const {
    submitChanges
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useDispatch)(_js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_1__.CORE_MODULES);
  const {
    clearErrors
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useDispatch)(module?.storeName) || {};
  const {
    setValue
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useDispatch)(_js_googlesitekit_datastore_ui_constants__WEBPACK_IMPORTED_MODULE_5__.CORE_UI);
  const handleClose = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_11__.useCallback)(async () => {
    await (0,_js_util__WEBPACK_IMPORTED_MODULE_3__.trackEvent)(`${viewContext}_module-list`, 'cancel_module_settings', slug);
    await clearErrors?.();
    history.push(`/connected-services/${slug}`);
  }, [clearErrors, history, viewContext, slug]);
  const handleConfirm = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_11__.useCallback)(async event => {
    event.preventDefault();
    setValue(isSavingKey, true);
    const {
      error: submissionError
    } = await submitChanges(slug);
    setValue(isSavingKey, false);
    if (submissionError) {
      setValue(errorKey, submissionError);
    } else {
      await (0,_js_util__WEBPACK_IMPORTED_MODULE_3__.trackEvent)(`${viewContext}_module-list`, 'update_module_settings', slug);
      setValue(errorKey, undefined);
      await clearErrors?.();
      history.push(`/connected-services/${slug}`);
      await (0,_js_googlesitekit_api_cache__WEBPACK_IMPORTED_MODULE_4__.clearCache)();
    }
  }, [setValue, isSavingKey, submitChanges, slug, errorKey, clearErrors, history, viewContext]);
  const handleDialog = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_11__.useCallback)(() => {
    setValue(dialogActiveKey, !dialogActive);
  }, [dialogActive, dialogActiveKey, setValue]);
  const handleEdit = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_11__.useCallback)(() => {
    (0,_js_util__WEBPACK_IMPORTED_MODULE_3__.trackEvent)(`${viewContext}_module-list`, 'edit_module_settings', slug);
  }, [slug, viewContext]);
  if (!module) {
    return null;
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)("footer", {
    className: "googlesitekit-settings-module__footer",
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)(_js_material_components__WEBPACK_IMPORTED_MODULE_2__.Grid, {
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsxs)(_js_material_components__WEBPACK_IMPORTED_MODULE_2__.Row, {
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)(_js_material_components__WEBPACK_IMPORTED_MODULE_2__.Cell, {
          lgSize: 6,
          mdSize: 8,
          smSize: 4,
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)(_FooterPrimaryAction__WEBPACK_IMPORTED_MODULE_7__["default"], {
            slug: slug,
            isEditing: isEditing,
            isSaving: isSaving,
            handleConfirm: handleConfirm,
            handleClose: handleClose,
            handleEdit: handleEdit
          })
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)(_js_material_components__WEBPACK_IMPORTED_MODULE_2__.Cell, {
          lgSize: 6,
          mdSize: 8,
          smSize: 4,
          alignMiddle: true,
          lgAlignRight: true,
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)(_FooterSecondaryAction__WEBPACK_IMPORTED_MODULE_8__["default"], {
            slug: slug,
            isEditing: isEditing,
            handleDialog: handleDialog
          })
        })]
      })
    })
  });
}
Footer.propTypes = {
  slug: (prop_types__WEBPACK_IMPORTED_MODULE_12___default().string).isRequired
};

/***/ }),

/***/ "./js/components/settings/SettingsActiveModule/FooterPrimaryAction.js":
/*!****************************************************************************!*\
  !*** ./js/components/settings/SettingsActiveModule/FooterPrimaryAction.js ***!
  \****************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ FooterPrimaryAction)
/* harmony export */ });
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-components */ "googlesitekit-components");
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _js_components_Link__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/components/Link */ "./js/components/Link.js");
/* harmony import */ var _svg_icons_pencil_svg__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/svg/icons/pencil.svg */ "./svg/icons/pencil.svg");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/googlesitekit/modules/datastore/constants */ "./js/googlesitekit/modules/datastore/constants.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * FooterPrimaryAction component for SettingsActiveModule.
 *
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */






function FooterPrimaryAction({
  slug,
  isEditing,
  isSaving,
  handleConfirm,
  handleClose,
  handleEdit
}) {
  const module = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_4__.useSelect)(select => select(_js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_5__.CORE_MODULES).getModule(slug));
  const moduleConnected = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_4__.useSelect)(select => select(_js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_5__.CORE_MODULES).isModuleConnected(slug));
  const areSettingsEditDependenciesLoaded = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_4__.useSelect)(select => select(_js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_5__.CORE_MODULES).areSettingsEditDependenciesLoaded(slug));
  const canSubmitChanges = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_4__.useSelect)(select => select(_js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_5__.CORE_MODULES).canSubmitChanges(slug));
  const haveSettingsChanged = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_4__.useSelect)(select => select(_js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_5__.CORE_MODULES).haveSettingsChanged(slug));
  const hasSettings = !!module?.SettingsEditComponent;
  if (isEditing || isSaving) {
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)(_wordpress_element__WEBPACK_IMPORTED_MODULE_7__.Fragment, {
      children: [hasSettings && moduleConnected ? /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__.SpinnerButton, {
        disabled: isSaving || !areSettingsEditDependenciesLoaded || !canSubmitChanges && haveSettingsChanged,
        onClick: handleConfirm,
        isSaving: isSaving,
        children: (() => {
          if (haveSettingsChanged) {
            return (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Confirm changes', 'google-site-kit');
          }
          return (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Save', 'google-site-kit');
        })()
      }) : /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__.Button, {
        onClick: handleClose,
        children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Close', 'google-site-kit')
      }), hasSettings && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__.Button, {
        className: "googlesitekit-settings-module__footer-cancel",
        onClick: handleClose,
        tertiary: true,
        children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Cancel', 'google-site-kit')
      })]
    });
  }
  if (hasSettings || !module?.forceActive) {
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(_js_components_Link__WEBPACK_IMPORTED_MODULE_2__["default"], {
      className: "googlesitekit-settings-module__edit-button",
      to: `/connected-services/${slug}/edit`,
      onClick: handleEdit,
      "aria-label": (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.sprintf)(/* translators: %s is replaced with the module name */
      (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Edit %s settings', 'google-site-kit'), module?.name),
      trailingIcon: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(_svg_icons_pencil_svg__WEBPACK_IMPORTED_MODULE_3__["default"], {
        className: "googlesitekit-settings-module__edit-button-icon",
        width: 10,
        height: 10
      }),
      children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Edit', 'google-site-kit')
    });
  }
  return null;
}

/***/ }),

/***/ "./js/components/settings/SettingsActiveModule/FooterSecondaryAction.js":
/*!******************************************************************************!*\
  !*** ./js/components/settings/SettingsActiveModule/FooterSecondaryAction.js ***!
  \******************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ FooterSecondaryAction)
/* harmony export */ });
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _js_components_Link__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/components/Link */ "./js/components/Link.js");
/* harmony import */ var _svg_icons_trash_svg__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/svg/icons/trash.svg */ "./svg/icons/trash.svg");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/googlesitekit/modules/datastore/constants */ "./js/googlesitekit/modules/datastore/constants.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * FooterSecondaryAction component for SettingsActiveModule.
 *
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */





function FooterSecondaryAction({
  slug,
  isEditing,
  handleDialog
}) {
  const module = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__.useSelect)(select => select(_js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_4__.CORE_MODULES).getModule(slug));
  const moduleHomepage = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__.useSelect)(select => select(_js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_4__.CORE_MODULES).getDetailsLinkURL(slug));
  if (isEditing && !module?.forceActive) {
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_js_components_Link__WEBPACK_IMPORTED_MODULE_1__["default"], {
      className: "googlesitekit-settings-module__remove-button",
      onClick: handleDialog,
      trailingIcon: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_svg_icons_trash_svg__WEBPACK_IMPORTED_MODULE_2__["default"], {
        className: "googlesitekit-settings-module__remove-button-icon",
        width: 13,
        height: 13
      }),
      danger: true,
      children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.sprintf)(/* translators: %s is replaced with the module name */
      (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Disconnect %s from Site Kit', 'google-site-kit'), module?.name)
    });
  }
  if (!isEditing && module?.connected && moduleHomepage) {
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_js_components_Link__WEBPACK_IMPORTED_MODULE_1__["default"], {
      href: moduleHomepage,
      className: "googlesitekit-settings-module__cta-button",
      external: true,
      children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.sprintf)(/* translators: %s is replaced with the module name */
      (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('See full details in %s', 'google-site-kit'), module?.name)
    });
  }
  return null;
}

/***/ }),

/***/ "./js/components/settings/SettingsActiveModule/Header.js":
/*!***************************************************************!*\
  !*** ./js/components/settings/SettingsActiveModule/Header.js ***!
  \***************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Header)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_26__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_26___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_26__);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react_router_dom__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(/*! react-router-dom */ "../node_modules/react-router/esm/react-router.js");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _wordpress_keycodes__WEBPACK_IMPORTED_MODULE_25__ = __webpack_require__(/*! @wordpress/keycodes */ "../node_modules/@wordpress/keycodes/build-module/index.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! googlesitekit-components */ "googlesitekit-components");
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_components__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _js_googlesitekit_datastore_location_constants__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/googlesitekit/datastore/location/constants */ "./js/googlesitekit/datastore/location/constants.js");
/* harmony import */ var _js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/googlesitekit/modules/datastore/constants */ "./js/googlesitekit/modules/datastore/constants.js");
/* harmony import */ var _js_components_settings_constants__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @/js/components/settings/constants */ "./js/components/settings/constants.js");
/* harmony import */ var _js_material_components__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @/js/material-components */ "./js/material-components/index.js");
/* harmony import */ var _js_hooks_useKeyCodesInside__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @/js/hooks/useKeyCodesInside */ "./js/hooks/useKeyCodesInside.js");
/* harmony import */ var _js_components_ModuleIcon__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @/js/components/ModuleIcon */ "./js/components/ModuleIcon.js");
/* harmony import */ var _js_components_Badge__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @/js/components/Badge */ "./js/components/Badge.js");
/* harmony import */ var _js_components_NewBadge__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @/js/components/NewBadge */ "./js/components/NewBadge.js");
/* harmony import */ var _js_util__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! @/js/util */ "./js/util/index.js");
/* harmony import */ var _js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! @/js/hooks/useViewContext */ "./js/hooks/useViewContext.js");
/* harmony import */ var _svg_icons_connected_svg__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! @/svg/icons/connected.svg */ "./svg/icons/connected.svg");
/* harmony import */ var _svg_icons_warning_v2_svg__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! @/svg/icons/warning-v2.svg */ "./svg/icons/warning-v2.svg");
/* harmony import */ var _svg_icons_chevron_down_v2_svg__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! @/svg/icons/chevron-down-v2.svg */ "./svg/icons/chevron-down-v2.svg");
/* harmony import */ var _js_components_IconWrapper__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! @/js/components/IconWrapper */ "./js/components/IconWrapper.js");
/* harmony import */ var _js_googlesitekit_data__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! @/js/googlesitekit-data */ "./js/googlesitekit-data.js");
/* harmony import */ var _js_components_Typography__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! @/js/components/Typography */ "./js/components/Typography/index.js");
/* harmony import */ var _js_components_Typography_P__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! @/js/components/Typography/P */ "./js/components/Typography/P.js");
/* harmony import */ var _js_components_Typography_constants__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! @/js/components/Typography/constants */ "./js/components/Typography/constants.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Header component for SettingsActiveModule.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */




/**
 * WordPress dependencies
 */




/**
 * Internal dependencies
 */





















function Header({
  slug
}) {
  const viewContext = (0,_js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_13__["default"])();
  const history = (0,react_router_dom__WEBPACK_IMPORTED_MODULE_23__.useHistory)();
  const headerRef = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_24__.useRef)();
  const {
    moduleSlug
  } = (0,react_router_dom__WEBPACK_IMPORTED_MODULE_23__.useParams)();
  const isOpen = moduleSlug === slug;
  const storeName = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.useSelect)(select => select(_js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_5__.CORE_MODULES).getModuleStoreName(slug));
  const adminReauthURL = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.useSelect)(select => select(storeName)?.getAdminReauthURL?.());
  const module = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.useSelect)(select => select(_js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_5__.CORE_MODULES).getModule(slug));
  const requirementsError = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.useSelect)(select => select(_js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_5__.CORE_MODULES)?.getCheckRequirementsError(slug));
  const {
    navigateTo
  } = (0,_js_googlesitekit_data__WEBPACK_IMPORTED_MODULE_18__.useDispatch)(_js_googlesitekit_datastore_location_constants__WEBPACK_IMPORTED_MODULE_4__.CORE_LOCATION);
  const isNavigatingToAdminReAuthURL = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.useSelect)(select => adminReauthURL && select(_js_googlesitekit_datastore_location_constants__WEBPACK_IMPORTED_MODULE_4__.CORE_LOCATION).isNavigatingTo(adminReauthURL));
  const openHeader = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_24__.useCallback)(() => {
    if (isOpen) {
      return;
    }
    history.push(`/connected-services/${slug}`);
    (0,_js_util__WEBPACK_IMPORTED_MODULE_12__.trackEvent)(`${viewContext}_module-list`, 'view_module_settings', slug);
  }, [history, slug, viewContext, isOpen]);
  const closeHeader = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_24__.useCallback)(() => {
    if (!isOpen) {
      return;
    }
    history.push('/connected-services');
    (0,_js_util__WEBPACK_IMPORTED_MODULE_12__.trackEvent)(`${viewContext}_module-list`, 'close_module_settings', slug);
  }, [history, slug, viewContext, isOpen]);
  const onActionClick = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_24__.useCallback)(event => {
    event.stopPropagation();
    navigateTo(adminReauthURL);
  }, [navigateTo, adminReauthURL]);
  (0,_js_hooks_useKeyCodesInside__WEBPACK_IMPORTED_MODULE_8__.useKeyCodesInside)([_wordpress_keycodes__WEBPACK_IMPORTED_MODULE_25__.ENTER], headerRef, isOpen ? closeHeader : openHeader);
  (0,_js_hooks_useKeyCodesInside__WEBPACK_IMPORTED_MODULE_8__.useKeyCodesInside)([_wordpress_keycodes__WEBPACK_IMPORTED_MODULE_25__.ESCAPE], headerRef, closeHeader);
  const {
    name,
    connected
  } = module;
  if (!module) {
    return null;
  }
  let moduleStatus = null;
  if (connected) {
    moduleStatus = /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)(_js_components_Typography_P__WEBPACK_IMPORTED_MODULE_20__["default"], {
      size: _js_components_Typography_constants__WEBPACK_IMPORTED_MODULE_21__.SIZE_MEDIUM,
      children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Connected', 'google-site-kit')
    });
  } else {
    moduleStatus = /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_3__.Button, {
      onClick: onActionClick,
      disabled: requirementsError || isNavigatingToAdminReAuthURL,
      inverse: true,
      children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.sprintf)(/* translators: %s: module name. */
      (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Complete setup for %s', 'google-site-kit'), name)
    });
  }
  return (
    /*#__PURE__*/
    // eslint-disable-next-line jsx-a11y/click-events-have-key-events
    (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsxs)("div", {
      className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-settings-module__header', {
        'googlesitekit-settings-module__header--open': isOpen
      }),
      id: `googlesitekit-settings-module__header--${slug}`,
      type: "button",
      role: "tab",
      "aria-selected": isOpen,
      "aria-expanded": isOpen,
      "aria-controls": `googlesitekit-settings-module__content--${slug}`,
      to: `/connected-services${isOpen ? '' : `/${slug}`}`,
      onClick: isOpen ? closeHeader : openHeader,
      ref: headerRef,
      tabIndex: "0",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)(_js_material_components__WEBPACK_IMPORTED_MODULE_7__.Grid, {
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsxs)(_js_material_components__WEBPACK_IMPORTED_MODULE_7__.Row, {
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsxs)(_js_material_components__WEBPACK_IMPORTED_MODULE_7__.Cell, {
            lgSize: 6,
            mdSize: 4,
            smSize: 4,
            className: "googlesitekit-settings-module__heading",
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)(_js_components_ModuleIcon__WEBPACK_IMPORTED_MODULE_9__["default"], {
              slug: slug,
              size: 40,
              className: "googlesitekit-settings-module__heading-icon"
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)(_js_components_Typography__WEBPACK_IMPORTED_MODULE_19__["default"], {
              as: "h3",
              type: "title",
              size: "large",
              className: "googlesitekit-settings-module__title",
              children: name
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsxs)("div", {
              className: "googlesitekit-settings-module__heading-badges",
              children: [_js_components_settings_constants__WEBPACK_IMPORTED_MODULE_6__.EXPERIMENTAL_MODULES.includes(slug) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)(_js_components_Badge__WEBPACK_IMPORTED_MODULE_10__["default"], {
                label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Experimental', 'google-site-kit'),
                hasLeftSpacing: true
              }), _js_components_settings_constants__WEBPACK_IMPORTED_MODULE_6__.BETA_MODULES.includes(slug) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)(_js_components_Badge__WEBPACK_IMPORTED_MODULE_10__["default"], {
                className: "googlesitekit-badge--beta",
                label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Beta', 'google-site-kit'),
                hasLeftSpacing: true
              }), _js_components_settings_constants__WEBPACK_IMPORTED_MODULE_6__.NEW_MODULES.includes(slug) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)(_js_components_NewBadge__WEBPACK_IMPORTED_MODULE_11__["default"], {
                hasLeftSpacing: true
              })]
            })]
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)(_js_material_components__WEBPACK_IMPORTED_MODULE_7__.Cell, {
            lgSize: 6,
            mdSize: 4,
            smSize: 4,
            alignMiddle: true,
            mdAlignRight: true,
            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsxs)("div", {
              className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-settings-module__status', {
                'googlesitekit-settings-module__status--connected': connected,
                'googlesitekit-settings-module__status--not-connected': !connected
              }),
              children: [moduleStatus, /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)("span", {
                className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-settings-module__status-icon', {
                  'googlesitekit-settings-module__status-icon--connected': connected,
                  'googlesitekit-settings-module__status-icon--not-connected': !connected
                }),
                children: connected ? /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)(_svg_icons_connected_svg__WEBPACK_IMPORTED_MODULE_14__["default"], {
                  width: 10,
                  height: 8
                }) : /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)(_svg_icons_warning_v2_svg__WEBPACK_IMPORTED_MODULE_15__["default"], {
                  width: 19,
                  height: 17
                })
              })]
            })
          })]
        })
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)(_js_components_IconWrapper__WEBPACK_IMPORTED_MODULE_17__["default"], {
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)(_svg_icons_chevron_down_v2_svg__WEBPACK_IMPORTED_MODULE_16__["default"], {
          width: 12,
          height: 8,
          className: "icon-chevron-down"
        })
      })]
    })
  );
}
Header.propTypes = {
  slug: (prop_types__WEBPACK_IMPORTED_MODULE_26___default().string).isRequired
};

/***/ }),

/***/ "./js/components/settings/SettingsActiveModule/index.js":
/*!**************************************************************!*\
  !*** ./js/components/settings/SettingsActiveModule/index.js ***!
  \**************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ SettingsActiveModule)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_12___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_12__);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react_router_dom__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! react-router-dom */ "../node_modules/react-router/esm/react-router.js");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/googlesitekit/modules/datastore/constants */ "./js/googlesitekit/modules/datastore/constants.js");
/* harmony import */ var _js_googlesitekit_datastore_ui_constants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/googlesitekit/datastore/ui/constants */ "./js/googlesitekit/datastore/ui/constants.js");
/* harmony import */ var _js_material_components__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/material-components */ "./js/material-components/index.js");
/* harmony import */ var _js_components_settings_SettingsOverlay__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/components/settings/SettingsOverlay */ "./js/components/settings/SettingsOverlay.js");
/* harmony import */ var _js_components_settings_SettingsRenderer__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @/js/components/settings/SettingsRenderer */ "./js/components/settings/SettingsRenderer.js");
/* harmony import */ var _Header__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./Header */ "./js/components/settings/SettingsActiveModule/Header.js");
/* harmony import */ var _Footer__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./Footer */ "./js/components/settings/SettingsActiveModule/Footer.js");
/* harmony import */ var _ConfirmDisconnect__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./ConfirmDisconnect */ "./js/components/settings/SettingsActiveModule/ConfirmDisconnect.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * SettingsActiveModule component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */




/**
 * Internal dependencies
 */










function SettingsActiveModule(props) {
  const {
    slug
  } = props;
  const {
    action,
    moduleSlug
  } = (0,react_router_dom__WEBPACK_IMPORTED_MODULE_11__.useParams)();
  const isEditing = action === 'edit';
  const isOpen = moduleSlug === slug;
  const isLocked = moduleSlug !== slug && isEditing;
  const errorKey = `module-${slug}-error`;
  const deactivationError = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_2__.CORE_MODULES).getErrorForAction('deactivateModule', [slug]));
  const error = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_datastore_ui_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_UI).getValue(errorKey));
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsxs)("div", {
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-settings-module', 'googlesitekit-settings-module--active', `googlesitekit-settings-module--${slug}`, {
      'googlesitekit-settings-module--error': (error || deactivationError) && isEditing
    }),
    children: [isLocked && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)(_js_components_settings_SettingsOverlay__WEBPACK_IMPORTED_MODULE_5__["default"], {
      compress: !isOpen
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)(_Header__WEBPACK_IMPORTED_MODULE_7__["default"], {
      slug: slug
    }), isOpen && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsxs)("div", {
      id: `googlesitekit-settings-module__content--${slug}`,
      className: "googlesitekit-settings-module__content googlesitekit-settings-module__content--open",
      role: "tabpanel",
      "aria-labelledby": `googlesitekit-settings-module__header--${slug}`,
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)(_js_material_components__WEBPACK_IMPORTED_MODULE_4__.Grid, {
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)(_js_material_components__WEBPACK_IMPORTED_MODULE_4__.Row, {
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)(_js_material_components__WEBPACK_IMPORTED_MODULE_4__.Cell, {
            size: 12,
            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)(_js_components_settings_SettingsRenderer__WEBPACK_IMPORTED_MODULE_6__["default"], {
              slug: slug
            })
          })
        })
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)(_Footer__WEBPACK_IMPORTED_MODULE_8__["default"], {
        slug: slug
      })]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)(_ConfirmDisconnect__WEBPACK_IMPORTED_MODULE_9__["default"], {
      slug: slug
    })]
  });
}
SettingsActiveModule.propTypes = {
  slug: (prop_types__WEBPACK_IMPORTED_MODULE_12___default().string).isRequired
};

/***/ }),

/***/ "./js/components/settings/SettingsActiveModules.js":
/*!*********************************************************!*\
  !*** ./js/components/settings/SettingsActiveModules.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ SettingsActiveModules)
/* harmony export */ });
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/googlesitekit/modules/datastore/constants */ "./js/googlesitekit/modules/datastore/constants.js");
/* harmony import */ var _js_components_layout_Layout__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/components/layout/Layout */ "./js/components/layout/Layout.js");
/* harmony import */ var _SettingsActiveModule__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./SettingsActiveModule */ "./js/components/settings/SettingsActiveModule/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * SettingsActiveModules component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Internal dependencies
 */





function SettingsActiveModules() {
  const modules = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useSelect)(select => select(_js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_1__.CORE_MODULES).getModules());
  if (!modules) {
    return null;
  }
  const activeModules = Object.keys(modules).map(slug => modules[slug]).filter(({
    internal,
    active
  }) => !internal && active).sort((a, b) => a.order - b.order);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(_js_components_layout_Layout__WEBPACK_IMPORTED_MODULE_2__["default"], {
    rounded: true,
    children: activeModules.map(({
      slug
    }) => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(_SettingsActiveModule__WEBPACK_IMPORTED_MODULE_3__["default"], {
      slug: slug
    }, slug))
  });
}

/***/ }),

/***/ "./js/components/settings/SettingsAdmin.js":
/*!*************************************************!*\
  !*** ./js/components/settings/SettingsAdmin.js ***!
  \*************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ SettingsAdmin)
/* harmony export */ });
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/googlesitekit/modules/datastore/constants */ "./js/googlesitekit/modules/datastore/constants.js");
/* harmony import */ var _js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/googlesitekit/datastore/user/constants */ "./js/googlesitekit/datastore/user/constants.js");
/* harmony import */ var _js_modules_search_console_datastore_constants__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/modules/search-console/datastore/constants */ "./js/modules/search-console/datastore/constants.js");
/* harmony import */ var _js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/modules/analytics-4/datastore/constants */ "./js/modules/analytics-4/datastore/constants.js");
/* harmony import */ var _js_modules_analytics_4_constants__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @/js/modules/analytics-4/constants */ "./js/modules/analytics-4/constants.js");
/* harmony import */ var _js_components_layout_Layout__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @/js/components/layout/Layout */ "./js/components/layout/Layout.js");
/* harmony import */ var _js_material_components__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @/js/material-components */ "./js/material-components/index.js");
/* harmony import */ var _js_components_OptIn__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @/js/components/OptIn */ "./js/components/OptIn.js");
/* harmony import */ var _js_components_ResetButton__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @/js/components/ResetButton */ "./js/components/ResetButton.js");
/* harmony import */ var _SettingsCardConsentMode__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./SettingsCardConsentMode */ "./js/components/settings/SettingsCardConsentMode.js");
/* harmony import */ var _SettingsCardKeyMetrics__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ./SettingsCardKeyMetrics */ "./js/components/settings/SettingsCardKeyMetrics.js");
/* harmony import */ var _SettingsPlugin__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ./SettingsPlugin */ "./js/components/settings/SettingsPlugin.js");
/* harmony import */ var _svg_icons_connected_svg__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! @/svg/icons/connected.svg */ "./svg/icons/connected.svg");
/* harmony import */ var _js_components_PreviewBlock__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! @/js/components/PreviewBlock */ "./js/components/PreviewBlock.js");
/* harmony import */ var _js_modules_analytics_4_components_audience_segmentation_settings_SettingsCardVisitorGroups__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! @/js/modules/analytics-4/components/audience-segmentation/settings/SettingsCardVisitorGroups */ "./js/modules/analytics-4/components/audience-segmentation/settings/SettingsCardVisitorGroups/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * SettingsOverview component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */

















function SettingsAdmin() {
  const configuredAudiences = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_USER).getConfiguredAudiences());
  const isAnalyticsConnected = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_2__.CORE_MODULES).isModuleConnected(_js_modules_analytics_4_constants__WEBPACK_IMPORTED_MODULE_6__.MODULE_SLUG_ANALYTICS_4));
  const isSearchConsoleGatheringData = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_modules_search_console_datastore_constants__WEBPACK_IMPORTED_MODULE_4__.MODULES_SEARCH_CONSOLE).isGatheringData());
  const isAnalyticsGatheringData = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => {
    if (!isAnalyticsConnected) {
      return false;
    }
    return select(_js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_5__.MODULES_ANALYTICS_4).isGatheringData();
  });
  const showKeyMetricsSettings = isAnalyticsConnected && isSearchConsoleGatheringData === false && isAnalyticsGatheringData === false;
  const showKeyMetricsSettingsLoading = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => {
    if (!select(_js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_2__.CORE_MODULES).hasFinishedResolution('isModuleConnected', [_js_modules_analytics_4_constants__WEBPACK_IMPORTED_MODULE_6__.MODULE_SLUG_ANALYTICS_4])) {
      return true;
    }

    // The resolvers below are never resolved if Analytics is disconnected,
    // so if it's disconnected, return early.
    //
    // Because they're never called nothing else can be loading.
    if (isAnalyticsConnected === false) {
      return false;
    }
    if (!select(_js_modules_search_console_datastore_constants__WEBPACK_IMPORTED_MODULE_4__.MODULES_SEARCH_CONSOLE).hasFinishedResolution('isGatheringData') || !select(_js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_5__.MODULES_ANALYTICS_4).hasFinishedResolution('isGatheringData')) {
      return true;
    }
    return false;
  });

  // Show a loading skeleton to prevent a layout shift.
  if (showKeyMetricsSettingsLoading) {
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_17__.jsxs)(_js_material_components__WEBPACK_IMPORTED_MODULE_8__.Row, {
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_17__.jsx)(_js_material_components__WEBPACK_IMPORTED_MODULE_8__.Cell, {
        size: 12,
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_17__.jsx)(_js_components_PreviewBlock__WEBPACK_IMPORTED_MODULE_15__["default"], {
          width: "100%",
          smallHeight: "100px",
          tabletHeight: "100px",
          desktopHeight: "200px"
        })
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_17__.jsx)(_js_material_components__WEBPACK_IMPORTED_MODULE_8__.Cell, {
        size: 12,
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_17__.jsx)(_js_components_PreviewBlock__WEBPACK_IMPORTED_MODULE_15__["default"], {
          width: "100%",
          smallHeight: "100px",
          tabletHeight: "100px",
          desktopHeight: "200px"
        })
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_17__.jsx)(_js_material_components__WEBPACK_IMPORTED_MODULE_8__.Cell, {
        size: 12,
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_17__.jsx)(_js_components_PreviewBlock__WEBPACK_IMPORTED_MODULE_15__["default"], {
          width: "100%",
          smallHeight: "100px",
          tabletHeight: "100px",
          desktopHeight: "200px"
        })
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_17__.jsx)(_js_material_components__WEBPACK_IMPORTED_MODULE_8__.Cell, {
        size: 12,
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_17__.jsx)(_js_components_PreviewBlock__WEBPACK_IMPORTED_MODULE_15__["default"], {
          width: "100%",
          smallHeight: "100px",
          tabletHeight: "100px",
          desktopHeight: "200px"
        })
      })]
    });
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_17__.jsxs)(_js_material_components__WEBPACK_IMPORTED_MODULE_8__.Row, {
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_17__.jsx)(_js_material_components__WEBPACK_IMPORTED_MODULE_8__.Cell, {
      size: 12,
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_17__.jsx)(_SettingsCardConsentMode__WEBPACK_IMPORTED_MODULE_11__["default"], {})
    }), showKeyMetricsSettings && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_17__.jsx)(_js_material_components__WEBPACK_IMPORTED_MODULE_8__.Cell, {
      size: 12,
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_17__.jsx)(_SettingsCardKeyMetrics__WEBPACK_IMPORTED_MODULE_12__["default"], {})
    }), (isAnalyticsConnected || !!configuredAudiences) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_17__.jsx)(_js_material_components__WEBPACK_IMPORTED_MODULE_8__.Cell, {
      size: 12,
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_17__.jsx)(_js_modules_analytics_4_components_audience_segmentation_settings_SettingsCardVisitorGroups__WEBPACK_IMPORTED_MODULE_16__["default"], {})
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_17__.jsx)(_js_material_components__WEBPACK_IMPORTED_MODULE_8__.Cell, {
      size: 12,
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_17__.jsx)(_js_components_layout_Layout__WEBPACK_IMPORTED_MODULE_7__["default"], {
        title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Plugin Status', 'google-site-kit'),
        header: true,
        rounded: true,
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_17__.jsxs)("div", {
          className: "googlesitekit-settings-module googlesitekit-settings-module--active",
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_17__.jsx)(_js_material_components__WEBPACK_IMPORTED_MODULE_8__.Grid, {
            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_17__.jsx)(_js_material_components__WEBPACK_IMPORTED_MODULE_8__.Row, {
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_17__.jsx)(_js_material_components__WEBPACK_IMPORTED_MODULE_8__.Cell, {
                size: 12,
                children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_17__.jsx)("div", {
                  className: "googlesitekit-settings-module__meta-items",
                  children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_17__.jsxs)("p", {
                    className: "googlesitekit-settings-module__status",
                    children: [(0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Site Kit is connected', 'google-site-kit'), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_17__.jsx)("span", {
                      className: "googlesitekit-settings-module__status-icon googlesitekit-settings-module__status-icon--connected",
                      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_17__.jsx)(_svg_icons_connected_svg__WEBPACK_IMPORTED_MODULE_14__["default"], {
                        width: 10,
                        height: 8
                      })
                    })]
                  })
                })
              })
            })
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_17__.jsx)("footer", {
            className: "googlesitekit-settings-module__footer",
            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_17__.jsx)(_js_material_components__WEBPACK_IMPORTED_MODULE_8__.Grid, {
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_17__.jsx)(_js_material_components__WEBPACK_IMPORTED_MODULE_8__.Row, {
                children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_17__.jsx)(_js_material_components__WEBPACK_IMPORTED_MODULE_8__.Cell, {
                  size: 12,
                  children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_17__.jsx)(_js_components_ResetButton__WEBPACK_IMPORTED_MODULE_10__["default"], {})
                })
              })
            })
          })]
        })
      })
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_17__.jsx)(_js_material_components__WEBPACK_IMPORTED_MODULE_8__.Cell, {
      size: 12,
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_17__.jsx)(_SettingsPlugin__WEBPACK_IMPORTED_MODULE_13__["default"], {})
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_17__.jsx)(_js_material_components__WEBPACK_IMPORTED_MODULE_8__.Cell, {
      size: 12,
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_17__.jsx)(_js_components_layout_Layout__WEBPACK_IMPORTED_MODULE_7__["default"], {
        className: "googlesitekit-settings-meta",
        title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Tracking', 'google-site-kit'),
        header: true,
        fill: true,
        rounded: true,
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_17__.jsx)("div", {
          className: "googlesitekit-settings-module googlesitekit-settings-module--active",
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_17__.jsx)(_js_material_components__WEBPACK_IMPORTED_MODULE_8__.Grid, {
            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_17__.jsx)(_js_material_components__WEBPACK_IMPORTED_MODULE_8__.Row, {
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_17__.jsx)(_js_material_components__WEBPACK_IMPORTED_MODULE_8__.Cell, {
                size: 12,
                children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_17__.jsx)("div", {
                  className: "googlesitekit-settings-module__meta-items",
                  children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_17__.jsx)("div", {
                    className: "googlesitekit-settings-module__meta-item googlesitekit-settings-module__meta-item--nomargin",
                    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_17__.jsx)(_js_components_OptIn__WEBPACK_IMPORTED_MODULE_9__["default"], {})
                  })
                })
              })
            })
          })
        })
      })
    })]
  });
}

/***/ }),

/***/ "./js/components/settings/SettingsApp.js":
/*!***********************************************!*\
  !*** ./js/components/settings/SettingsApp.js ***!
  \***********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_router_dom__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! react-router-dom */ "../node_modules/react-router/esm/react-router.js");
/* harmony import */ var react_router_dom__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! react-router-dom */ "../node_modules/react-router-dom/esm/react-router-dom.js");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-components */ "googlesitekit-components");
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _js_components_Header__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/components/Header */ "./js/components/Header.js");
/* harmony import */ var _js_components_PageHeader__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/components/PageHeader */ "./js/components/PageHeader.js");
/* harmony import */ var _js_components_layout_Layout__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/components/layout/Layout */ "./js/components/layout/Layout.js");
/* harmony import */ var _SettingsModules__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./SettingsModules */ "./js/components/settings/SettingsModules.js");
/* harmony import */ var _js_material_components__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @/js/material-components */ "./js/material-components/index.js");
/* harmony import */ var _js_components_help_HelpMenu__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @/js/components/help/HelpMenu */ "./js/components/help/HelpMenu.js");
/* harmony import */ var _js_util_tracking__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @/js/util/tracking */ "./js/util/tracking/index.js");
/* harmony import */ var _js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @/js/hooks/useViewContext */ "./js/hooks/useViewContext.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * SettingsApp component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */










function SettingsApp() {
  const location = (0,react_router_dom__WEBPACK_IMPORTED_MODULE_11__.useLocation)();
  // Prevent pushing to hash history if it would send you to the same URL.
  // (Without this React Router will trigger a warning.)
  function shouldReplaceHistory(path) {
    return  false && 0;
  }
  const [, basePath] = location.pathname.split('/');
  const activeTab = SettingsApp.basePathToTabIndex[basePath];
  const viewContext = (0,_js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_9__["default"])();
  const handleTabChange = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_12__.useCallback)(() => {
    (0,_js_util_tracking__WEBPACK_IMPORTED_MODULE_8__.trackEvent)(viewContext, 'tab_select', basePath);
  }, [basePath, viewContext]);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsxs)(_wordpress_element__WEBPACK_IMPORTED_MODULE_12__.Fragment, {
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)(_js_components_Header__WEBPACK_IMPORTED_MODULE_2__["default"], {
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)(_js_components_help_HelpMenu__WEBPACK_IMPORTED_MODULE_7__["default"], {})
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)("div", {
      className: "googlesitekit-module-page",
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)(_js_material_components__WEBPACK_IMPORTED_MODULE_6__.Grid, {
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsxs)(_js_material_components__WEBPACK_IMPORTED_MODULE_6__.Row, {
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)(_js_material_components__WEBPACK_IMPORTED_MODULE_6__.Cell, {
            size: 12,
            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)(_js_components_PageHeader__WEBPACK_IMPORTED_MODULE_3__["default"], {
              title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Settings', 'google-site-kit')
            })
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)(_js_material_components__WEBPACK_IMPORTED_MODULE_6__.Cell, {
            size: 12,
            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)(_js_components_layout_Layout__WEBPACK_IMPORTED_MODULE_4__["default"], {
              transparent: true,
              rounded: true,
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsxs)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__.TabBar, {
                activeIndex: activeTab,
                className: "googlesitekit-tab-bar__settings",
                handleActiveIndexUpdate: handleTabChange,
                children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__.Tab, {
                  tag: react_router_dom__WEBPACK_IMPORTED_MODULE_13__.Link,
                  to: "/connected-services",
                  replace: shouldReplaceHistory('connected-services'),
                  children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)("span", {
                    className: "mdc-tab__text-label",
                    children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Connected Services', 'google-site-kit')
                  })
                }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__.Tab, {
                  tag: react_router_dom__WEBPACK_IMPORTED_MODULE_13__.Link,
                  to: "/connect-more-services",
                  replace: shouldReplaceHistory('connect-more-services'),
                  children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)("span", {
                    className: "mdc-tab__text-label",
                    children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Connect More Services', 'google-site-kit')
                  })
                }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__.Tab, {
                  tag: react_router_dom__WEBPACK_IMPORTED_MODULE_13__.Link,
                  to: "/admin-settings",
                  replace: shouldReplaceHistory('admin-settings'),
                  children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)("span", {
                    className: "mdc-tab__text-label",
                    children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Admin Settings', 'google-site-kit')
                  })
                })]
              })
            })
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)(_js_material_components__WEBPACK_IMPORTED_MODULE_6__.Cell, {
            size: 12,
            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)(_SettingsModules__WEBPACK_IMPORTED_MODULE_5__["default"], {})
          })]
        })
      })
    })]
  });
}
SettingsApp.propTypes = {};

// Necessary to set `TabBar.activeIndex`
SettingsApp.basePathToTabIndex = {
  'connected-services': 0,
  'connect-more-services': 1,
  'admin-settings': 2
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ((0,react_router_dom__WEBPACK_IMPORTED_MODULE_11__.withRouter)(SettingsApp));

/***/ }),

/***/ "./js/components/settings/SettingsCardConsentMode.js":
/*!***********************************************************!*\
  !*** ./js/components/settings/SettingsCardConsentMode.js ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ SettingsCardConsentMode)
/* harmony export */ });
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react_use__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! react-use */ "../node_modules/react-use/esm/useIntersection.js");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/googlesitekit/datastore/site/constants */ "./js/googlesitekit/datastore/site/constants.js");
/* harmony import */ var _js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/googlesitekit/datastore/user/constants */ "./js/googlesitekit/datastore/user/constants.js");
/* harmony import */ var _js_material_components__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/material-components */ "./js/material-components/index.js");
/* harmony import */ var _js_components_Badge__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @/js/components/Badge */ "./js/components/Badge.js");
/* harmony import */ var _js_components_consent_mode_ConsentModeSwitch__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @/js/components/consent-mode/ConsentModeSwitch */ "./js/components/consent-mode/ConsentModeSwitch.js");
/* harmony import */ var _js_components_consent_mode_WPConsentAPIRequirements__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @/js/components/consent-mode/WPConsentAPIRequirements */ "./js/components/consent-mode/WPConsentAPIRequirements.js");
/* harmony import */ var _js_components_layout_Layout__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @/js/components/layout/Layout */ "./js/components/layout/Layout.js");
/* harmony import */ var _js_util__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @/js/util */ "./js/util/index.js");
/* harmony import */ var _js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @/js/hooks/useViewContext */ "./js/hooks/useViewContext.js");
/* harmony import */ var _js_components_Notice__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! @/js/components/Notice */ "./js/components/Notice/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */












function SettingsCardConsentMode() {
  const viewContext = (0,_js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_11__["default"])();
  const isAdsConnected = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.useSelect)(select => select(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_SITE).isAdsConnectedUncached());
  const isConsentModeEnabled = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.useSelect)(select => select(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_SITE).isConsentModeEnabled());
  const consentAPIInfo = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.useSelect)(select => select(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_SITE).getConsentAPIInfo());
  const isLoading = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.useSelect)(select => {
    const {
      isResolving,
      hasFinishedResolution
    } = select(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_SITE);
    return !hasFinishedResolution('getConsentModeSettings') || !hasFinishedResolution('getConsentAPIInfo') || isResolving('getConsentModeSettings') || isResolving('getConsentAPIInfo');
  });
  const trackingRef = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_14__.useRef)();
  const intersectionEntry = (0,react_use__WEBPACK_IMPORTED_MODULE_15__["default"])(trackingRef, {
    threshold: 0.25
  });
  const [hasBeenInView, setHasBeenInView] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_14__.useState)(false);
  const inView = !!intersectionEntry?.intersectionRatio;
  const {
    triggerSurvey
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.useDispatch)(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_4__.CORE_USER);
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_14__.useEffect)(() => {
    if (inView && !hasBeenInView) {
      // Track an event when the user sees the Consent Mode settings.
      (0,_js_util__WEBPACK_IMPORTED_MODULE_10__.trackEvent)(`${viewContext}_CoMo`, 'view_requirements');
      if (isAdsConnected && isConsentModeEnabled === false) {
        triggerSurvey('view_como_setup_cta', {
          ttl: _js_util__WEBPACK_IMPORTED_MODULE_10__.DAY_IN_SECONDS
        });
      }
      setHasBeenInView(true);
    }
  }, [inView, hasBeenInView, viewContext, triggerSurvey, isAdsConnected, isConsentModeEnabled]);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx)(_js_components_layout_Layout__WEBPACK_IMPORTED_MODULE_9__["default"], {
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Consent Mode', 'google-site-kit'),
    badge: isAdsConnected ? /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx)(_js_components_Badge__WEBPACK_IMPORTED_MODULE_6__["default"], {
      className: "googlesitekit-badge--primary",
      label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Recommended', 'google-site-kit')
    }) : null,
    header: true,
    rounded: true,
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx)("div", {
      className: "googlesitekit-settings-module googlesitekit-settings-module--active googlesitekit-settings-consent-mode",
      ref: trackingRef,
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsxs)(_js_material_components__WEBPACK_IMPORTED_MODULE_5__.Grid, {
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx)(_js_material_components__WEBPACK_IMPORTED_MODULE_5__.Row, {
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx)(_js_material_components__WEBPACK_IMPORTED_MODULE_5__.Cell, {
            size: 12,
            className: classnames__WEBPACK_IMPORTED_MODULE_0___default()({
              'googlesitekit-overflow-hidden': isLoading
            }),
            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx)(_js_components_consent_mode_ConsentModeSwitch__WEBPACK_IMPORTED_MODULE_7__["default"], {
              loading: isLoading
            })
          })
        }), !isLoading && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsxs)(_wordpress_element__WEBPACK_IMPORTED_MODULE_14__.Fragment, {
          children: [isAdsConnected && !isConsentModeEnabled && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx)(_js_material_components__WEBPACK_IMPORTED_MODULE_5__.Row, {
            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx)(_js_material_components__WEBPACK_IMPORTED_MODULE_5__.Cell, {
              size: 12,
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx)(_js_components_Notice__WEBPACK_IMPORTED_MODULE_12__["default"], {
                type: _js_components_Notice__WEBPACK_IMPORTED_MODULE_12__["default"].TYPES.INFO,
                description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('If you have Google Ads campaigns for this site, it’s highly recommended to enable Consent mode - otherwise, you won’t be able to collect any metrics on the effectiveness of your campaigns in regions like the European Economic Area.', 'google-site-kit')
              })
            })
          }), !!consentAPIInfo && isConsentModeEnabled && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx)(_js_material_components__WEBPACK_IMPORTED_MODULE_5__.Row, {
            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx)(_js_material_components__WEBPACK_IMPORTED_MODULE_5__.Cell, {
              size: 12,
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx)(_js_components_consent_mode_WPConsentAPIRequirements__WEBPACK_IMPORTED_MODULE_8__["default"], {})
            })
          })]
        })]
      })
    })
  });
}

/***/ }),

/***/ "./js/components/settings/SettingsCardKeyMetrics.js":
/*!**********************************************************!*\
  !*** ./js/components/settings/SettingsCardKeyMetrics.js ***!
  \**********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ SettingsCardKeyMetrics)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/googlesitekit/datastore/user/constants */ "./js/googlesitekit/datastore/user/constants.js");
/* harmony import */ var _js_util__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/util */ "./js/util/index.js");
/* harmony import */ var _js_components_KeyMetrics_ConversionReportingSettingsSubtleNotification__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/components/KeyMetrics/ConversionReportingSettingsSubtleNotification */ "./js/components/KeyMetrics/ConversionReportingSettingsSubtleNotification.js");
/* harmony import */ var _SettingsKeyMetrics__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./SettingsKeyMetrics */ "./js/components/settings/SettingsKeyMetrics.js");
/* harmony import */ var _js_components_user_input_UserInputPreview__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @/js/components/user-input/UserInputPreview */ "./js/components/user-input/UserInputPreview.js");
/* harmony import */ var _js_components_layout_Layout__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @/js/components/layout/Layout */ "./js/components/layout/Layout.js");
/* harmony import */ var _js_material_components__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @/js/material-components */ "./js/material-components/index.js");
/* harmony import */ var _js_components_surveys_SurveyViewTrigger__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @/js/components/surveys/SurveyViewTrigger */ "./js/components/surveys/SurveyViewTrigger.js");
/* harmony import */ var _js_components_PreviewBlock__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @/js/components/PreviewBlock */ "./js/components/PreviewBlock.js");
/* harmony import */ var _js_hooks_useInView__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @/js/hooks/useInView */ "./js/hooks/useInView.js");
/* harmony import */ var _js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! @/js/hooks/useViewContext */ "./js/hooks/useViewContext.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * SettingsCardKeyMetrics component.
 *
 * Site Kit by Google, Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */













function SettingsCardKeyMetrics() {
  const viewContext = (0,_js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_12__["default"])();
  const inView = (0,_js_hooks_useInView__WEBPACK_IMPORTED_MODULE_11__.useInView)();
  const isUserInputCompleted = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_2__.CORE_USER).isUserInputCompleted());
  const isGetUserInputSettingsLoading = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => {
    // Ensure that `getUserInputSettings()` is called here in order to trigger its resolver, which we
    // want to track for the loading state. Invoking the selector here rather than relying on one of
    // the child components to call it avoids a brief flicker of the loaded state.
    select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_2__.CORE_USER).getUserInputSettings();
    return select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_2__.CORE_USER).isResolving('getUserInputSettings', []);
  });
  const isUserInputCompletedLoading = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => !select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_2__.CORE_USER).hasFinishedResolution('isUserInputCompleted'));
  const gaEventCategory = `${viewContext}_kmw`;
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_14__.useEffect)(() => {
    if (isUserInputCompleted) {
      (0,_js_util__WEBPACK_IMPORTED_MODULE_3__.trackEvent)(gaEventCategory, 'summary_view');
    }
  }, [isUserInputCompleted, gaEventCategory]);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx)(_js_components_layout_Layout__WEBPACK_IMPORTED_MODULE_7__["default"], {
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Key Metrics', 'google-site-kit'),
    header: true,
    rounded: true,
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsxs)("div", {
      className: "googlesitekit-settings-module googlesitekit-settings-module--active googlesitekit-settings-user-input",
      children: [isUserInputCompletedLoading && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx)(_js_components_PreviewBlock__WEBPACK_IMPORTED_MODULE_10__["default"], {
        width: "100%",
        smallHeight: "100px",
        tabletHeight: "100px",
        desktopHeight: "117px"
      }), isUserInputCompleted && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsxs)(_wordpress_element__WEBPACK_IMPORTED_MODULE_14__.Fragment, {
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx)(_SettingsKeyMetrics__WEBPACK_IMPORTED_MODULE_5__["default"], {
          loading: isGetUserInputSettingsLoading
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx)(_js_material_components__WEBPACK_IMPORTED_MODULE_8__.Grid, {
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx)(_js_material_components__WEBPACK_IMPORTED_MODULE_8__.Row, {
            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx)(_js_material_components__WEBPACK_IMPORTED_MODULE_8__.Cell, {
              size: 12,
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx)(_js_components_user_input_UserInputPreview__WEBPACK_IMPORTED_MODULE_6__["default"], {
                loading: isGetUserInputSettingsLoading,
                settingsView: true
              })
            })
          })
        })]
      }), isUserInputCompleted === false && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsxs)(_wordpress_element__WEBPACK_IMPORTED_MODULE_14__.Fragment, {
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx)(_SettingsKeyMetrics__WEBPACK_IMPORTED_MODULE_5__["default"], {}), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsxs)(_wordpress_element__WEBPACK_IMPORTED_MODULE_14__.Fragment, {
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx)(_js_components_KeyMetrics_ConversionReportingSettingsSubtleNotification__WEBPACK_IMPORTED_MODULE_4__["default"], {}), inView && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx)(_js_components_surveys_SurveyViewTrigger__WEBPACK_IMPORTED_MODULE_9__["default"], {
            triggerID: "view_kmw_setup_cta",
            ttl: _js_util__WEBPACK_IMPORTED_MODULE_3__.WEEK_IN_SECONDS
          })]
        })]
      })]
    })
  });
}

/***/ }),

/***/ "./js/components/settings/SettingsInactiveModules.js":
/*!***********************************************************!*\
  !*** ./js/components/settings/SettingsInactiveModules.js ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ SettingsInactiveModules)
/* harmony export */ });
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/googlesitekit/modules/datastore/constants */ "./js/googlesitekit/modules/datastore/constants.js");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _js_components_layout_Layout__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/components/layout/Layout */ "./js/components/layout/Layout.js");
/* harmony import */ var _SetupModule__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./SetupModule */ "./js/components/settings/SetupModule.js");
/* harmony import */ var _js_material_components__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/material-components */ "./js/material-components/index.js");
/* harmony import */ var _js_components_Notice__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @/js/components/Notice */ "./js/components/Notice/index.js");
/* harmony import */ var _js_components_Notice_constants__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @/js/components/Notice/constants */ "./js/components/Notice/constants.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * SettingsInactiveModules component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */








function SettingsInactiveModules() {
  const modules = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.useSelect)(select => select(_js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_1__.CORE_MODULES).getModules());
  if (!modules) {
    return null;
  }
  const inactiveModules = Object.keys(modules).map(slug => modules[slug]).filter(({
    internal,
    active
  }) => !internal && !active).sort((a, b) => a.order - b.order);
  if (inactiveModules.length === 0) {
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(_js_components_Notice__WEBPACK_IMPORTED_MODULE_6__["default"], {
      id: "no-more-modules",
      title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Congrats, you’ve connected all services!', 'google-site-kit'),
      description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('We’re working on adding new services to Site Kit by Google all the time, so please check back in the future', 'google-site-kit'),
      type: _js_components_Notice_constants__WEBPACK_IMPORTED_MODULE_7__.TYPES.SUCCESS
    });
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(_js_components_layout_Layout__WEBPACK_IMPORTED_MODULE_3__["default"], {
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Connect More Services to Gain More Insights', 'google-site-kit'),
    header: true,
    rounded: true,
    relative: true,
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(_js_material_components__WEBPACK_IMPORTED_MODULE_5__.Grid, {
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(_js_material_components__WEBPACK_IMPORTED_MODULE_5__.Row, {
        children: inactiveModules.map(({
          slug,
          name,
          description
        }) => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(_js_material_components__WEBPACK_IMPORTED_MODULE_5__.Cell, {
          size: 4,
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(_SetupModule__WEBPACK_IMPORTED_MODULE_4__["default"], {
            slug: slug,
            name: name,
            description: description
          })
        }, slug))
      })
    })
  });
}

/***/ }),

/***/ "./js/components/settings/SettingsKeyMetrics.js":
/*!******************************************************!*\
  !*** ./js/components/settings/SettingsKeyMetrics.js ***!
  \******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ SettingsKeyMetrics)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-components */ "googlesitekit-components");
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/googlesitekit/datastore/user/constants */ "./js/googlesitekit/datastore/user/constants.js");
/* harmony import */ var _js_material_components__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/material-components */ "./js/material-components/index.js");
/* harmony import */ var _js_components_PreviewBlock__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/components/PreviewBlock */ "./js/components/PreviewBlock.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * SettingsKeyMetrics component.
 *
 * Site Kit by Google, Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */






function SettingsKeyMetrics({
  loading = false
}) {
  const keyMetricsWidgetHidden = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.useSelect)(select => select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_USER).isKeyMetricsWidgetHidden());
  const keyMetrics = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.useSelect)(select => select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_USER).getKeyMetrics());
  const {
    setKeyMetricsSetting,
    saveKeyMetricsSettings
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.useDispatch)(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_USER);
  const handleKeyMetricsToggle = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_7__.useCallback)(async () => {
    await setKeyMetricsSetting('isWidgetHidden', !keyMetricsWidgetHidden);
    await saveKeyMetricsSettings({
      widgetSlugs: undefined
    });
  }, [keyMetricsWidgetHidden, saveKeyMetricsSettings, setKeyMetricsSetting]);
  if (loading) {
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(_js_material_components__WEBPACK_IMPORTED_MODULE_4__.Grid, {
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(_js_material_components__WEBPACK_IMPORTED_MODULE_4__.Row, {
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(_js_material_components__WEBPACK_IMPORTED_MODULE_4__.Cell, {
          size: 12,
          className: "googlesitekit-overflow-hidden",
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(_js_components_PreviewBlock__WEBPACK_IMPORTED_MODULE_5__["default"], {
            width: "260px",
            height: "21.3px"
          })
        })
      })
    });
  }
  if (keyMetricsWidgetHidden === undefined || !keyMetrics?.length) {
    return null;
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(_js_material_components__WEBPACK_IMPORTED_MODULE_4__.Grid, {
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(_js_material_components__WEBPACK_IMPORTED_MODULE_4__.Row, {
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(_js_material_components__WEBPACK_IMPORTED_MODULE_4__.Cell, {
        size: 12,
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__.Switch, {
          label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Display key metrics in dashboard', 'google-site-kit'),
          checked: !keyMetricsWidgetHidden,
          onClick: handleKeyMetricsToggle,
          hideLabel: false
        })
      })
    })
  });
}
SettingsKeyMetrics.propTypes = {
  loading: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().bool)
};

/***/ }),

/***/ "./js/components/settings/SettingsModules.js":
/*!***************************************************!*\
  !*** ./js/components/settings/SettingsModules.js ***!
  \***************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_router_dom__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! react-router-dom */ "../node_modules/react-router/esm/react-router.js");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/googlesitekit/modules/datastore/constants */ "./js/googlesitekit/modules/datastore/constants.js");
/* harmony import */ var _SettingsAdmin__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./SettingsAdmin */ "./js/components/settings/SettingsAdmin.js");
/* harmony import */ var _SettingsActiveModules__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./SettingsActiveModules */ "./js/components/settings/SettingsActiveModules.js");
/* harmony import */ var _SettingsInactiveModules__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./SettingsInactiveModules */ "./js/components/settings/SettingsInactiveModules.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * SettingsModules component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * Internal dependencies
 */






function SettingsModules() {
  const modules = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useSelect)(select => select(_js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_1__.CORE_MODULES).getModules());
  if (modules === undefined || !Object.values(modules).length) {
    return null;
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)(react_router_dom__WEBPACK_IMPORTED_MODULE_6__.Switch, {
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(react_router_dom__WEBPACK_IMPORTED_MODULE_6__.Route, {
      path: "/connected-services/:moduleSlug/:action",
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_SettingsActiveModules__WEBPACK_IMPORTED_MODULE_3__["default"], {})
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(react_router_dom__WEBPACK_IMPORTED_MODULE_6__.Route, {
      path: "/connected-services/:moduleSlug",
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_SettingsActiveModules__WEBPACK_IMPORTED_MODULE_3__["default"], {})
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(react_router_dom__WEBPACK_IMPORTED_MODULE_6__.Route, {
      path: "/connected-services",
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_SettingsActiveModules__WEBPACK_IMPORTED_MODULE_3__["default"], {})
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(react_router_dom__WEBPACK_IMPORTED_MODULE_6__.Route, {
      path: "/connect-more-services",
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_SettingsInactiveModules__WEBPACK_IMPORTED_MODULE_4__["default"], {})
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(react_router_dom__WEBPACK_IMPORTED_MODULE_6__.Route, {
      path: "/admin-settings",
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_SettingsAdmin__WEBPACK_IMPORTED_MODULE_2__["default"], {})
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(react_router_dom__WEBPACK_IMPORTED_MODULE_6__.Redirect, {
      from: "/settings/:moduleSlug/edit",
      to: "/connected-services/:moduleSlug/edit"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(react_router_dom__WEBPACK_IMPORTED_MODULE_6__.Redirect, {
      from: "/settings/:moduleSlug",
      to: "/connected-services/:moduleSlug"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(react_router_dom__WEBPACK_IMPORTED_MODULE_6__.Redirect, {
      from: "/settings",
      to: "/connected-services"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(react_router_dom__WEBPACK_IMPORTED_MODULE_6__.Redirect, {
      from: "/connect",
      to: "/connect-more-services"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(react_router_dom__WEBPACK_IMPORTED_MODULE_6__.Redirect, {
      from: "/admin",
      to: "/admin-settings"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(react_router_dom__WEBPACK_IMPORTED_MODULE_6__.Redirect, {
      to: "/connected-services"
    })]
  });
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (SettingsModules);

/***/ }),

/***/ "./js/components/settings/SettingsOverlay.js":
/*!***************************************************!*\
  !*** ./js/components/settings/SettingsOverlay.js ***!
  \***************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _svg_icons_lock_svg__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/svg/icons/lock.svg */ "./svg/icons/lock.svg");
/* harmony import */ var _js_components_Typography__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/components/Typography */ "./js/components/Typography/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * SettingsOverlay component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */



function SettingsOverlay({
  compress
}) {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("div", {
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-overlay', {
      'googlesitekit-overlay--compress': compress
    }),
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsxs)("div", {
      className: "googlesitekit-overlay__wrapper",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("div", {
        className: "googlesitekit-overlay__icon",
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(_svg_icons_lock_svg__WEBPACK_IMPORTED_MODULE_2__["default"], {
          width: "22",
          height: "30"
        })
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(_js_components_Typography__WEBPACK_IMPORTED_MODULE_3__["default"], {
        as: "h3",
        size: "medium",
        type: "title",
        className: " googlesitekit-heading-2 googlesitekit-overlay__title ",
        children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Section locked while editing', 'google-site-kit')
      })]
    })
  });
}
SettingsOverlay.propTypes = {
  compress: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().bool)
};
SettingsOverlay.defaultProps = {
  compress: false
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (SettingsOverlay);

/***/ }),

/***/ "./js/components/settings/SettingsPlugin.js":
/*!**************************************************!*\
  !*** ./js/components/settings/SettingsPlugin.js ***!
  \**************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ SettingsPlugin)
/* harmony export */ });
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! googlesitekit-components */ "googlesitekit-components");
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_components__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/googlesitekit/datastore/site/constants */ "./js/googlesitekit/datastore/site/constants.js");
/* harmony import */ var _js_material_components__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/material-components */ "./js/material-components/index.js");
/* harmony import */ var _js_components_layout_Layout__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/components/layout/Layout */ "./js/components/layout/Layout.js");
/* harmony import */ var _js_util__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @/js/util */ "./js/util/index.js");
/* harmony import */ var _js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @/js/hooks/useViewContext */ "./js/hooks/useViewContext.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * SettingsPlugin component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */








function SettingsPlugin() {
  const showAdminBar = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_SITE).getShowAdminBar());
  const {
    setShowAdminBar
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useDispatch)(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_SITE);
  const viewContext = (0,_js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_7__["default"])();
  const onAdminBarToggle = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.useCallback)(({
    target
  }) => {
    const action = target.checked ? 'enable_admin_bar_menu' : 'disable_admin_bar_menu';
    setShowAdminBar(!!target.checked);
    (0,_js_util__WEBPACK_IMPORTED_MODULE_6__.trackEvent)(viewContext, action);
  }, [setShowAdminBar, viewContext]);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(_js_components_layout_Layout__WEBPACK_IMPORTED_MODULE_5__["default"], {
    className: "googlesitekit-settings-meta",
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Plugin Settings', 'google-site-kit'),
    header: true,
    fill: true,
    rounded: true,
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)("div", {
      className: "googlesitekit-settings-module googlesitekit-settings-module--active",
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(_js_material_components__WEBPACK_IMPORTED_MODULE_4__.Grid, {
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(_js_material_components__WEBPACK_IMPORTED_MODULE_4__.Row, {
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(_js_material_components__WEBPACK_IMPORTED_MODULE_4__.Cell, {
            size: 12,
            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)("div", {
              className: "googlesitekit-settings-module__meta-items",
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)("div", {
                className: "googlesitekit-settings-module__meta-item googlesitekit-settings-module__meta-item--nomargin",
                children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_2__.Checkbox, {
                  id: "admin-bar-toggle",
                  name: "admin-bar-toggle",
                  value: "1",
                  checked: showAdminBar,
                  onChange: onAdminBarToggle,
                  disabled: showAdminBar === undefined,
                  loading: showAdminBar === undefined,
                  children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)("span", {
                    children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Display relevant page stats in the Admin bar', 'google-site-kit')
                  })
                })
              })
            })
          })
        })
      })
    })
  });
}

/***/ }),

/***/ "./js/components/settings/SettingsRenderer.js":
/*!****************************************************!*\
  !*** ./js/components/settings/SettingsRenderer.js ***!
  \****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ SettingsRenderer)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var react_router_dom__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react-router-dom */ "../node_modules/react-router/esm/react-router.js");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/googlesitekit/modules/datastore/constants */ "./js/googlesitekit/modules/datastore/constants.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Settings Renderer component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */



function SettingsRenderer({
  slug
}) {
  const {
    action,
    moduleSlug
  } = (0,react_router_dom__WEBPACK_IMPORTED_MODULE_3__.useParams)();
  const isEditing = action === 'edit';
  const isOpen = moduleSlug === slug;
  const [initiallyConnected, setInitiallyConnected] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_4__.useState)();
  const isDoingSubmitChanges = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useSelect)(select => select(_js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_1__.CORE_MODULES).isDoingSubmitChanges(slug));
  const {
    SettingsEditComponent,
    SettingsViewComponent,
    SettingsSetupIncompleteComponent,
    moduleLoaded,
    connected
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useSelect)(select => {
    const module = select(_js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_1__.CORE_MODULES).getModule(slug);
    return {
      ...module,
      moduleLoaded: !!module
    };
  });

  // Store the initial connected state once the module is loaded.
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_4__.useEffect)(() => {
    if (moduleLoaded && initiallyConnected === undefined) {
      setInitiallyConnected(connected);
    }
  }, [moduleLoaded, initiallyConnected, connected]);

  // Rollback any temporary selections to saved values if settings have changed and no longer editing.
  const {
    rollbackChanges
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useDispatch)(_js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_1__.CORE_MODULES);
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_4__.useEffect)(() => {
    if (!isDoingSubmitChanges && !isEditing) {
      rollbackChanges(slug);
    }
  }, [slug, rollbackChanges, isDoingSubmitChanges, isEditing]);
  if (!isOpen || !moduleLoaded) {
    return null;
  } else if (isOpen && initiallyConnected === false) {
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)(SettingsSetupIncompleteComponent, {
      slug: slug
    });
  }
  if (isEditing && SettingsEditComponent) {
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)(SettingsEditComponent, {});
  } else if (SettingsViewComponent) {
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)(SettingsViewComponent, {});
  }
  return null;
}

/***/ }),

/***/ "./js/components/settings/SetupModule.js":
/*!***********************************************!*\
  !*** ./js/components/settings/SetupModule.js ***!
  \***********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ SetupModule)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_19___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_19__);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _js_components_ModuleIcon__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/components/ModuleIcon */ "./js/components/ModuleIcon.js");
/* harmony import */ var _js_components_Spinner__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/components/Spinner */ "./js/components/Spinner.js");
/* harmony import */ var _js_components_Link__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/components/Link */ "./js/components/Link.js");
/* harmony import */ var _js_components_Badge__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @/js/components/Badge */ "./js/components/Badge.js");
/* harmony import */ var _js_components_notifications_ModuleSettingsWarning_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @/js/components/notifications/ModuleSettingsWarning.js */ "./js/components/notifications/ModuleSettingsWarning.js");
/* harmony import */ var _js_components_NewBadge_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @/js/components/NewBadge.js */ "./js/components/NewBadge.js");
/* harmony import */ var _js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @/js/googlesitekit/datastore/site/constants */ "./js/googlesitekit/datastore/site/constants.js");
/* harmony import */ var _js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @/js/googlesitekit/modules/datastore/constants */ "./js/googlesitekit/modules/datastore/constants.js");
/* harmony import */ var _js_googlesitekit_datastore_location_constants__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @/js/googlesitekit/datastore/location/constants */ "./js/googlesitekit/datastore/location/constants.js");
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ./constants */ "./js/components/settings/constants.js");
/* harmony import */ var _js_googlesitekit_api_cache__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! @/js/googlesitekit/api/cache */ "./js/googlesitekit/api/cache.js");
/* harmony import */ var _js_util__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! @/js/util */ "./js/util/index.js");
/* harmony import */ var _js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! @/js/hooks/useViewContext */ "./js/hooks/useViewContext.js");
/* harmony import */ var _js_components_Typography__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! @/js/components/Typography */ "./js/components/Typography/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * SetupModule component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */
















function SetupModule({
  slug,
  name,
  description
}) {
  const viewContext = (0,_js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_15__["default"])();
  const [isSaving, setIsSaving] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_18__.useState)(false);
  const {
    activateModule
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.useDispatch)(_js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_10__.CORE_MODULES);
  const {
    navigateTo
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.useDispatch)(_js_googlesitekit_datastore_location_constants__WEBPACK_IMPORTED_MODULE_11__.CORE_LOCATION);
  const {
    setInternalServerError
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.useDispatch)(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_9__.CORE_SITE);
  const onSetup = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_18__.useCallback)(async () => {
    setIsSaving(true);
    const {
      error,
      response
    } = await activateModule(slug);
    if (!error) {
      await (0,_js_util__WEBPACK_IMPORTED_MODULE_14__.trackEvent)(`${viewContext}_module-list`, 'activate_module', slug);
      await (0,_js_googlesitekit_api_cache__WEBPACK_IMPORTED_MODULE_13__.setItem)('module_setup', slug, {
        ttl: 300
      });
      navigateTo(response.moduleReauthURL);
    } else {
      setInternalServerError({
        id: 'activate-module-error',
        description: error.message
      });
      setIsSaving(false);
    }
  }, [activateModule, navigateTo, setInternalServerError, slug, viewContext]);
  const canActivateModule = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.useSelect)(select => select(_js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_10__.CORE_MODULES).canActivateModule(slug));
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_17__.jsxs)("div", {
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-settings-connect-module', `googlesitekit-settings-connect-module--${slug}`),
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_17__.jsx)("div", {
      className: "googlesitekit-settings-connect-module__switch",
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_17__.jsx)(_js_components_Spinner__WEBPACK_IMPORTED_MODULE_4__["default"], {
        isSaving: isSaving
      })
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_17__.jsx)("div", {
      className: "googlesitekit-settings-connect-module__logo",
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_17__.jsx)(_js_components_ModuleIcon__WEBPACK_IMPORTED_MODULE_3__["default"], {
        slug: slug
      })
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_17__.jsxs)("div", {
      className: "googlesitekit-settings-connect-module__heading",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_17__.jsx)(_js_components_Typography__WEBPACK_IMPORTED_MODULE_16__["default"], {
        as: "h3",
        type: "title",
        size: "small",
        className: " googlesitekit-subheading-1 googlesitekit-settings-connect-module__title ",
        children: name
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_17__.jsxs)("div", {
        className: "googlesitekit-settings-connect-module__badges",
        children: [_constants__WEBPACK_IMPORTED_MODULE_12__.EXPERIMENTAL_MODULES.includes(slug) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_17__.jsx)(_js_components_Badge__WEBPACK_IMPORTED_MODULE_6__["default"], {
          label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Experimental', 'google-site-kit')
        }), _constants__WEBPACK_IMPORTED_MODULE_12__.BETA_MODULES.includes(slug) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_17__.jsx)(_js_components_Badge__WEBPACK_IMPORTED_MODULE_6__["default"], {
          className: "googlesitekit-badge--beta",
          label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Beta', 'google-site-kit')
        }), _constants__WEBPACK_IMPORTED_MODULE_12__.NEW_MODULES.includes(slug) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_17__.jsx)(_js_components_NewBadge_js__WEBPACK_IMPORTED_MODULE_8__["default"], {
          hasNoSpacing: true
        })]
      })]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_17__.jsx)("p", {
      className: "googlesitekit-settings-connect-module__text",
      children: description
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_17__.jsx)("p", {
      className: "googlesitekit-settings-connect-module__cta",
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_17__.jsx)(_js_components_Link__WEBPACK_IMPORTED_MODULE_5__["default"], {
        onClick: onSetup,
        href: "",
        disabled: !canActivateModule || isSaving,
        arrow: true,
        children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.sprintf)(/* translators: %s: module name */
        (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Set up %s', 'google-site-kit'), name)
      })
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_17__.jsx)(_js_components_notifications_ModuleSettingsWarning_js__WEBPACK_IMPORTED_MODULE_7__["default"], {
      slug: slug
    })]
  }, slug);
}
SetupModule.propTypes = {
  slug: (prop_types__WEBPACK_IMPORTED_MODULE_19___default().string).isRequired,
  name: (prop_types__WEBPACK_IMPORTED_MODULE_19___default().string).isRequired,
  description: (prop_types__WEBPACK_IMPORTED_MODULE_19___default().string).isRequired
};

/***/ }),

/***/ "./js/components/settings/constants.js":
/*!*********************************************!*\
  !*** ./js/components/settings/constants.js ***!
  \*********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   BETA_MODULES: () => (/* binding */ BETA_MODULES),
/* harmony export */   EXPERIMENTAL_MODULES: () => (/* binding */ EXPERIMENTAL_MODULES),
/* harmony export */   NEW_MODULES: () => (/* binding */ NEW_MODULES)
/* harmony export */ });
/* harmony import */ var _js_modules_ads_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @/js/modules/ads/constants */ "./js/modules/ads/constants.js");
/* harmony import */ var _js_modules_sign_in_with_google_constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/modules/sign-in-with-google/constants */ "./js/modules/sign-in-with-google/constants.js");
/* harmony import */ var _js_modules_reader_revenue_manager_constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/modules/reader-revenue-manager/constants */ "./js/modules/reader-revenue-manager/constants.js");
/**
 * Settings constants.
 *
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */




const NEW_MODULES = [_js_modules_ads_constants__WEBPACK_IMPORTED_MODULE_0__.MODULE_SLUG_ADS, _js_modules_reader_revenue_manager_constants__WEBPACK_IMPORTED_MODULE_2__.MODULE_SLUG_READER_REVENUE_MANAGER, _js_modules_sign_in_with_google_constants__WEBPACK_IMPORTED_MODULE_1__.MODULE_SLUG_SIGN_IN_WITH_GOOGLE];
const BETA_MODULES = [_js_modules_sign_in_with_google_constants__WEBPACK_IMPORTED_MODULE_1__.MODULE_SLUG_SIGN_IN_WITH_GOOGLE];
const EXPERIMENTAL_MODULES = [];

/***/ }),

/***/ "./js/components/surveys/SurveyViewTrigger.js":
/*!****************************************************!*\
  !*** ./js/components/surveys/SurveyViewTrigger.js ***!
  \****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ SurveyViewTrigger)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/googlesitekit/datastore/user/constants */ "./js/googlesitekit/datastore/user/constants.js");
/**
 * SurveyViewTrigger component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */


/**
 * External dependencies
 */


/**
 * Internal dependencies
 */


function SurveyViewTrigger({
  triggerID,
  ttl = 0
}) {
  const {
    triggerSurvey
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useDispatch)(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_1__.CORE_USER);
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useEffect)(() => {
    triggerSurvey(triggerID, {
      ttl
    });
  }, [triggerID, ttl, triggerSurvey]);
  return null;
}
SurveyViewTrigger.propTypes = {
  triggerID: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string).isRequired,
  ttl: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().number)
};

/***/ }),

/***/ "./js/components/user-input/CancelUserInputButton.js":
/*!***********************************************************!*\
  !*** ./js/components/user-input/CancelUserInputButton.js ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ CancelUserInputButton)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! googlesitekit-components */ "googlesitekit-components");
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_components__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/googlesitekit/datastore/site/constants */ "./js/googlesitekit/datastore/site/constants.js");
/* harmony import */ var _js_googlesitekit_datastore_location_constants__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/googlesitekit/datastore/location/constants */ "./js/googlesitekit/datastore/location/constants.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Cancel User Input Button Component.
 *
 * Site Kit by Google, Copyright 2022 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */





function CancelUserInputButton({
  disabled
}) {
  const dashboardURL = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_SITE).getAdminURL('googlesitekit-dashboard'));
  const {
    navigateTo
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useDispatch)(_js_googlesitekit_datastore_location_constants__WEBPACK_IMPORTED_MODULE_4__.CORE_LOCATION);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_2__.Button, {
    className: "googlesitekit-user-input__buttons--cancel",
    onClick: () => navigateTo(dashboardURL),
    disabled: disabled,
    tertiary: true,
    children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Cancel', 'google-site-kit')
  });
}
CancelUserInputButton.propTypes = {
  disabled: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().bool)
};

/***/ }),

/***/ "./js/components/user-input/KeyMetricsSettingsSellProductsSubtleNotification.js":
/*!**************************************************************************************!*\
  !*** ./js/components/user-input/KeyMetricsSettingsSellProductsSubtleNotification.js ***!
  \**************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ KeyMetricsSettingsSellProductsSubtleNotification)
/* harmony export */ });
/* harmony import */ var react_use__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! react-use */ "../node_modules/react-use/esm/useIntersection.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/hooks/useViewContext */ "./js/hooks/useViewContext.js");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _js_components_Notice__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/components/Notice */ "./js/components/Notice/index.js");
/* harmony import */ var _js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/googlesitekit/datastore/user/constants */ "./js/googlesitekit/datastore/user/constants.js");
/* harmony import */ var _util_constants__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./util/constants */ "./js/components/user-input/util/constants.js");
/* harmony import */ var _js_util__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @/js/util */ "./js/util/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * KeyMetricsSettingsSellProductsSubtleNotification component.
 *
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */







function KeyMetricsSettingsSellProductsSubtleNotification() {
  const viewContext = (0,_js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_1__["default"])();
  const {
    dismissItem
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.useDispatch)(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_4__.CORE_USER);
  const [isViewed, setIsViewed] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_8__.useState)(false);
  const notificationRef = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_8__.useRef)();
  const intersectionEntry = (0,react_use__WEBPACK_IMPORTED_MODULE_9__["default"])(notificationRef, {
    threshold: 0.25
  });
  const inView = !!intersectionEntry?.intersectionRatio;

  // Track when the notification is viewed.
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_8__.useEffect)(() => {
    if (!isViewed && inView) {
      // Handle internal tracking.
      (0,_js_util__WEBPACK_IMPORTED_MODULE_6__.trackEvent)(`${viewContext}_kmw-settings-suggested-site-purpose-edit-notification`, 'view_notification', 'conversion_reporting');
      setIsViewed(true);
    }
  }, [isViewed, inView, viewContext]);
  const isDismissed = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.useSelect)(select => select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_4__.CORE_USER).isItemDismissed(_util_constants__WEBPACK_IMPORTED_MODULE_5__.USER_INPUT_LEGACY_SITE_PURPOSE_DISMISSED_ITEM_KEY));
  const onDismiss = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_8__.useCallback)(async () => {
    await dismissItem(_util_constants__WEBPACK_IMPORTED_MODULE_5__.USER_INPUT_LEGACY_SITE_PURPOSE_DISMISSED_ITEM_KEY);
    // Handle internal tracking.
    (0,_js_util__WEBPACK_IMPORTED_MODULE_6__.trackEvent)(`${viewContext}_kmw-settings-suggested-site-purpose-edit-notification`, 'confirm_notification', 'conversion_reporting');
  }, [dismissItem, viewContext]);
  if (isDismissed) {
    return null;
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_js_components_Notice__WEBPACK_IMPORTED_MODULE_3__["default"], {
    type: _js_components_Notice__WEBPACK_IMPORTED_MODULE_3__["default"].TYPES.WARNING,
    description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('To allow better personalization of suggested metrics, we have updated the answers list for this question with more accurate options. We recommend that you edit your answer.', 'google-site-kit'),
    dismissButton: {
      onClick: onDismiss
    }
  });
}

/***/ }),

/***/ "./js/components/user-input/UserInputEditModeContent.js":
/*!**************************************************************!*\
  !*** ./js/components/user-input/UserInputEditModeContent.js ***!
  \**************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ UserInputEditModeContent)
/* harmony export */ });
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! googlesitekit-components */ "googlesitekit-components");
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_components__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _js_googlesitekit_datastore_location_constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/googlesitekit/datastore/location/constants */ "./js/googlesitekit/datastore/location/constants.js");
/* harmony import */ var _js_googlesitekit_datastore_ui_constants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/googlesitekit/datastore/ui/constants */ "./js/googlesitekit/datastore/ui/constants.js");
/* harmony import */ var _js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/googlesitekit/datastore/user/constants */ "./js/googlesitekit/datastore/user/constants.js");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _js_components_ErrorNotice__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @/js/components/ErrorNotice */ "./js/components/ErrorNotice.js");
/* harmony import */ var _js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @/js/hooks/useViewContext */ "./js/hooks/useViewContext.js");
/* harmony import */ var _js_util__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @/js/util */ "./js/util/index.js");
/* harmony import */ var _UserInputQuestionAuthor__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./UserInputQuestionAuthor */ "./js/components/user-input/UserInputQuestionAuthor.js");
/* harmony import */ var _UserInputSelectOptions__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./UserInputSelectOptions */ "./js/components/user-input/UserInputSelectOptions.js");
/* harmony import */ var _util_validation__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./util/validation */ "./js/components/user-input/util/validation.js");
/* harmony import */ var _util_constants__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ./util/constants */ "./js/components/user-input/util/constants.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * User Input Edit Mode Content.
 *
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */




/**
 * Internal dependencies
 */












function UserInputEditModeContent({
  onChange,
  options,
  settingsView,
  slug,
  values
}) {
  const answerHasError = (0,_util_validation__WEBPACK_IMPORTED_MODULE_11__.hasErrorForAnswer)(values);
  const currentlyEditingSlug = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_5__.useSelect)(select => select(_js_googlesitekit_datastore_ui_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_UI).getValue(_util_constants__WEBPACK_IMPORTED_MODULE_12__.USER_INPUT_CURRENTLY_EDITING_KEY));
  const editButtonRef = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_14__.useRef)();
  const errorMessage = (0,_util_validation__WEBPACK_IMPORTED_MODULE_11__.getErrorMessageForAnswer)(values, _util_constants__WEBPACK_IMPORTED_MODULE_12__.USER_INPUT_MAX_ANSWERS[slug]);
  const gaEventCategory = `${(0,_js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_7__["default"])()}_kmw`;
  const hasSettingChanged = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_5__.useSelect)(select => select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_4__.CORE_USER).hasUserInputSettingChanged(slug));
  const isEditing = currentlyEditingSlug === slug;
  const isNavigating = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_5__.useSelect)(select => select(_js_googlesitekit_datastore_location_constants__WEBPACK_IMPORTED_MODULE_2__.CORE_LOCATION).isNavigating());
  const userInputSettings = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_5__.useSelect)(select => select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_4__.CORE_USER).getUserInputSettings());
  const isSavingSettings = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_5__.useSelect)(select => select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_4__.CORE_USER).isSavingUserInputSettings(userInputSettings));
  const userInputValuesHaveErrors = (0,_util_validation__WEBPACK_IMPORTED_MODULE_11__.hasErrorForAnswer)(userInputSettings?.[slug]?.values || []);
  const isScreenLoading = isSavingSettings || isNavigating;
  const saveSettingsError = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_5__.useSelect)(select => select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_4__.CORE_USER).getErrorForAction('saveUserInputSettings', []));
  const {
    resetUserInputSettings,
    saveUserInputSettings
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_5__.useDispatch)(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_4__.CORE_USER);
  const {
    setValues
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_5__.useDispatch)(_js_googlesitekit_datastore_ui_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_UI);
  const {
    USER_INPUT_ANSWERS_PURPOSE: USER_INPUT_ANSWERS_PURPOSE_DESCRIPTIONS
  } = (0,_util_constants__WEBPACK_IMPORTED_MODULE_12__.getUserInputAnswersDescription)();
  const toggleEditMode = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_14__.useCallback)(() => {
    if (isEditing) {
      setValues({
        [_util_constants__WEBPACK_IMPORTED_MODULE_12__.USER_INPUT_CURRENTLY_EDITING_KEY]: undefined
      });
      editButtonRef.current?.focus?.();
    } else {
      (0,_js_util__WEBPACK_IMPORTED_MODULE_8__.trackEvent)(gaEventCategory, 'question_edit', slug);
      setValues({
        [_util_constants__WEBPACK_IMPORTED_MODULE_12__.USER_INPUT_CURRENTLY_EDITING_KEY]: slug
      });
    }
  }, [gaEventCategory, isEditing, setValues, slug]);
  const handleOnCancelClick = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_14__.useCallback)(async () => {
    if (isScreenLoading) {
      return;
    }
    await resetUserInputSettings();
    toggleEditMode();
  }, [isScreenLoading, resetUserInputSettings, toggleEditMode]);
  const submitChanges = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_14__.useCallback)(async () => {
    if (answerHasError) {
      return;
    }
    if (_util_constants__WEBPACK_IMPORTED_MODULE_12__.USER_INPUT_QUESTIONS_PURPOSE === slug && onChange) {
      onChange();
    } else {
      const response = await saveUserInputSettings();
      if (!response.error) {
        (0,_js_util__WEBPACK_IMPORTED_MODULE_8__.trackEvent)(gaEventCategory, 'question_update', slug);
        toggleEditMode();
      }
    }
  }, [answerHasError, gaEventCategory, onChange, saveUserInputSettings, slug, toggleEditMode]);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsxs)(_wordpress_element__WEBPACK_IMPORTED_MODULE_14__.Fragment, {
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx)(_UserInputSelectOptions__WEBPACK_IMPORTED_MODULE_10__["default"], {
      slug: slug,
      max: _util_constants__WEBPACK_IMPORTED_MODULE_12__.USER_INPUT_MAX_ANSWERS[slug],
      options: options,
      descriptions: USER_INPUT_ANSWERS_PURPOSE_DESCRIPTIONS,
      alignLeftOptions: true
    }), errorMessage && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx)("p", {
      className: "googlesitekit-error-text",
      children: errorMessage
    }), settingsView && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsxs)(_wordpress_element__WEBPACK_IMPORTED_MODULE_14__.Fragment, {
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx)(_UserInputQuestionAuthor__WEBPACK_IMPORTED_MODULE_9__["default"], {
        slug: slug
      }), saveSettingsError && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx)(_js_components_ErrorNotice__WEBPACK_IMPORTED_MODULE_6__["default"], {
        error: saveSettingsError
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsxs)("div", {
        className: "googlesitekit-user-input__preview-actions",
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_0__.SpinnerButton, {
          disabled: answerHasError || userInputValuesHaveErrors,
          onClick: hasSettingChanged ? submitChanges : toggleEditMode,
          isSaving: isScreenLoading,
          children: hasSettingChanged || isSavingSettings ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Apply changes', 'google-site-kit') : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Save', 'google-site-kit')
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_0__.Button, {
          disabled: isScreenLoading,
          onClick: handleOnCancelClick,
          tertiary: true,
          children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Cancel', 'google-site-kit')
        })]
      })]
    })]
  });
}

/***/ }),

/***/ "./js/components/user-input/UserInputPreview.js":
/*!******************************************************!*\
  !*** ./js/components/user-input/UserInputPreview.js ***!
  \******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ UserInputPreview)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_23___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_23__);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! googlesitekit-components */ "googlesitekit-components");
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_components__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/googlesitekit/datastore/user/constants */ "./js/googlesitekit/datastore/user/constants.js");
/* harmony import */ var _js_googlesitekit_datastore_location_constants__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/googlesitekit/datastore/location/constants */ "./js/googlesitekit/datastore/location/constants.js");
/* harmony import */ var _js_googlesitekit_datastore_ui_constants__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @/js/googlesitekit/datastore/ui/constants */ "./js/googlesitekit/datastore/ui/constants.js");
/* harmony import */ var _util_constants__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./util/constants */ "./js/components/user-input/util/constants.js");
/* harmony import */ var _UserInputPreviewGroup__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./UserInputPreviewGroup */ "./js/components/user-input/UserInputPreviewGroup.js");
/* harmony import */ var _UserInputQuestionNotice__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./UserInputQuestionNotice */ "./js/components/user-input/UserInputQuestionNotice.js");
/* harmony import */ var _js_hooks_useQueryArg__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @/js/hooks/useQueryArg */ "./js/hooks/useQueryArg.js");
/* harmony import */ var _js_components_ErrorNotice__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @/js/components/ErrorNotice */ "./js/components/ErrorNotice.js");
/* harmony import */ var _js_components_LoadingWrapper__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! @/js/components/LoadingWrapper */ "./js/components/LoadingWrapper.js");
/* harmony import */ var _CancelUserInputButton__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ./CancelUserInputButton */ "./js/components/user-input/CancelUserInputButton.js");
/* harmony import */ var _util_validation__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ./util/validation */ "./js/components/user-input/util/validation.js");
/* harmony import */ var _js_components_Portal__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! @/js/components/Portal */ "./js/components/Portal.js");
/* harmony import */ var _js_components_KeyMetrics_ConfirmSitePurposeChangeModal__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! @/js/components/KeyMetrics/ConfirmSitePurposeChangeModal */ "./js/components/KeyMetrics/ConfirmSitePurposeChangeModal.js");
/* harmony import */ var _js_googlesitekit_datastore_forms_constants__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! @/js/googlesitekit/datastore/forms/constants */ "./js/googlesitekit/datastore/forms/constants.js");
/* harmony import */ var _js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! @/js/modules/analytics-4/datastore/constants */ "./js/modules/analytics-4/datastore/constants.js");
/* harmony import */ var _KeyMetricsSettingsSellProductsSubtleNotification__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! ./KeyMetricsSettingsSellProductsSubtleNotification */ "./js/components/user-input/KeyMetricsSettingsSellProductsSubtleNotification.js");
/* harmony import */ var _js_hooks_useFormValue__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! @/js/hooks/useFormValue */ "./js/hooks/useFormValue.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * User Input Preview.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */




















function UserInputPreview(props) {
  const {
    goBack,
    submitChanges,
    error,
    loading = false,
    settingsView = false
  } = props;
  const previewContainer = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_22__.useRef)();
  const [isModalOpen, toggleIsModalOpen] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_22__.useState)(false);
  const handleModal = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_22__.useCallback)(() => {
    toggleIsModalOpen(false);
  }, [toggleIsModalOpen]);
  const settings = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__.useSelect)(select => select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_4__.CORE_USER).getSavedUserInputSettings());
  const isSavingSettings = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__.useSelect)(select => select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_4__.CORE_USER).isSavingUserInputSettings(settings));
  const isNavigating = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__.useSelect)(select => select(_js_googlesitekit_datastore_location_constants__WEBPACK_IMPORTED_MODULE_5__.CORE_LOCATION).isNavigating());
  const isEditing = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__.useSelect)(select => !!select(_js_googlesitekit_datastore_ui_constants__WEBPACK_IMPORTED_MODULE_6__.CORE_UI).getValue(_util_constants__WEBPACK_IMPORTED_MODULE_7__.USER_INPUT_CURRENTLY_EDITING_KEY));
  const isScreenLoading = isSavingSettings || isNavigating;
  const {
    USER_INPUT_ANSWERS_PURPOSE,
    USER_INPUT_ANSWERS_POST_FREQUENCY,
    USER_INPUT_ANSWERS_GOALS
  } = (0,_util_constants__WEBPACK_IMPORTED_MODULE_7__.getUserInputAnswers)();
  const [page] = (0,_js_hooks_useQueryArg__WEBPACK_IMPORTED_MODULE_10__["default"])('page');
  const hasError = _util_constants__WEBPACK_IMPORTED_MODULE_7__.USER_INPUT_QUESTIONS_LIST.some(slug => (0,_util_validation__WEBPACK_IMPORTED_MODULE_14__.hasErrorForAnswer)(settings?.[slug]?.values || []));
  const onSaveClick = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_22__.useCallback)(() => {
    if (hasError || isScreenLoading) {
      return;
    }
    submitChanges();
  }, [hasError, isScreenLoading, submitChanges]);
  const {
    saveUserInputSettings
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__.useDispatch)(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_4__.CORE_USER);
  const savedPurposeSnapshot = (0,_js_hooks_useFormValue__WEBPACK_IMPORTED_MODULE_20__["default"])(_util_constants__WEBPACK_IMPORTED_MODULE_7__.FORM_USER_INPUT_QUESTION_SNAPSHOT, _util_constants__WEBPACK_IMPORTED_MODULE_7__.USER_INPUT_QUESTIONS_PURPOSE);
  const savedPurpose = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__.useSelect)(select => select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_4__.CORE_USER).getSavedUserInputSettings());
  const currentMetrics = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__.useSelect)(select => {
    if (savedPurpose === undefined || !savedPurpose?.purpose?.values?.length) {
      return [];
    }
    return select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_4__.CORE_USER).getAnswerBasedMetrics(savedPurpose?.purpose?.values?.[0]);
  });
  const includeConversionTailoredMetrics = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__.useSelect)(select => select(_js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_18__.MODULES_ANALYTICS_4).shouldIncludeConversionTailoredMetrics());
  const newMetrics = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__.useSelect)(select => select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_4__.CORE_USER).getAnswerBasedMetrics(null, includeConversionTailoredMetrics));
  const {
    resetUserInputSettings
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__.useDispatch)(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_4__.CORE_USER);
  const {
    setValues
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__.useDispatch)(_js_googlesitekit_datastore_forms_constants__WEBPACK_IMPORTED_MODULE_17__.CORE_FORMS);
  const {
    setValues: setUIValues
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__.useDispatch)(_js_googlesitekit_datastore_ui_constants__WEBPACK_IMPORTED_MODULE_6__.CORE_UI);
  async function openModalIfMetricsChanged() {
    const differenceInMetrics = newMetrics.filter(x => !currentMetrics.includes(x));
    if (0 !== differenceInMetrics.length) {
      toggleIsModalOpen(true);
    } else {
      await saveUserInputSettings();
      if (savedPurposeSnapshot?.length) {
        await resetUserInputSettings();
        setValues(_util_constants__WEBPACK_IMPORTED_MODULE_7__.FORM_USER_INPUT_QUESTION_SNAPSHOT, {
          [_util_constants__WEBPACK_IMPORTED_MODULE_7__.USER_INPUT_QUESTIONS_PURPOSE]: undefined
        });
      }
      setUIValues({
        [_util_constants__WEBPACK_IMPORTED_MODULE_7__.USER_INPUT_CURRENTLY_EDITING_KEY]: undefined
      });
    }
  }
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_22__.useEffect)(() => {
    if (!previewContainer?.current || page?.startsWith('googlesitekit-settings')) {
      return;
    }
    const buttonEl = previewContainer.current.querySelector('.mdc-button');
    if (buttonEl) {
      setTimeout(() => {
        buttonEl.focus();
      }, 50);
    }
  }, [page]);
  const {
    setUserInputSetting
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__.useDispatch)(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_4__.CORE_USER);
  const currentlyEditingSlug = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__.useSelect)(select => select(_js_googlesitekit_datastore_ui_constants__WEBPACK_IMPORTED_MODULE_6__.CORE_UI).getValue(_util_constants__WEBPACK_IMPORTED_MODULE_7__.USER_INPUT_CURRENTLY_EDITING_KEY));
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_22__.useEffect)(() => {
    const purposeValues = [...(settings?.purpose?.values || [])];
    if (_util_constants__WEBPACK_IMPORTED_MODULE_7__.USER_INPUT_QUESTIONS_PURPOSE === currentlyEditingSlug && purposeValues.includes('sell_products_or_service')) {
      setUserInputSetting(_util_constants__WEBPACK_IMPORTED_MODULE_7__.USER_INPUT_QUESTIONS_PURPOSE, ['sell_products']);
      setValues(_util_constants__WEBPACK_IMPORTED_MODULE_7__.FORM_USER_INPUT_QUESTION_SNAPSHOT, {
        [_util_constants__WEBPACK_IMPORTED_MODULE_7__.USER_INPUT_QUESTIONS_PURPOSE]: ['sell_products_or_service']
      });
    }
  }, [settings, setUserInputSetting, currentlyEditingSlug, setValues]);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_21__.jsxs)("div", {
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-user-input__preview', {
      'googlesitekit-user-input__preview--editing': isEditing
    }),
    ref: previewContainer,
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_21__.jsxs)("div", {
      className: "googlesitekit-user-input__preview-contents",
      children: [!settingsView && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_21__.jsx)("p", {
        className: "googlesitekit-user-input__preview-subheader",
        children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Review your answers', 'google-site-kit')
      }), settingsView && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_21__.jsx)("div", {
        className: "googlesitekit-settings-user-input__heading-container",
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_21__.jsx)(_js_components_LoadingWrapper__WEBPACK_IMPORTED_MODULE_12__["default"], {
          loading: loading,
          width: "275px",
          height: "16px",
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_21__.jsx)("p", {
            className: "googlesitekit-settings-user-input__heading",
            children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Edit your answers for more personalized metrics:', 'google-site-kit')
          })
        })
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_21__.jsx)(_UserInputPreviewGroup__WEBPACK_IMPORTED_MODULE_8__["default"], {
        slug: _util_constants__WEBPACK_IMPORTED_MODULE_7__.USER_INPUT_QUESTIONS_PURPOSE,
        title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('What is the main purpose of this site?', 'google-site-kit'),
        subtitle: settings?.purpose?.values.includes('sell_products_or_service') ? _KeyMetricsSettingsSellProductsSubtleNotification__WEBPACK_IMPORTED_MODULE_19__["default"] : null,
        values: settings?.purpose?.values || [],
        options: USER_INPUT_ANSWERS_PURPOSE,
        loading: loading,
        settingsView: settingsView,
        onChange: openModalIfMetricsChanged
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_21__.jsx)(_UserInputPreviewGroup__WEBPACK_IMPORTED_MODULE_8__["default"], {
        slug: _util_constants__WEBPACK_IMPORTED_MODULE_7__.USER_INPUT_QUESTION_POST_FREQUENCY,
        title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('How often do you create new content for this site?', 'google-site-kit'),
        values: settings?.postFrequency?.values || [],
        options: USER_INPUT_ANSWERS_POST_FREQUENCY,
        loading: loading,
        settingsView: settingsView
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_21__.jsx)(_UserInputPreviewGroup__WEBPACK_IMPORTED_MODULE_8__["default"], {
        slug: _util_constants__WEBPACK_IMPORTED_MODULE_7__.USER_INPUT_QUESTIONS_GOALS,
        title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('What are your top 3 goals for this site?', 'google-site-kit'),
        values: settings?.goals?.values || [],
        options: USER_INPUT_ANSWERS_GOALS,
        loading: loading,
        settingsView: settingsView
      }), error && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_21__.jsx)(_js_components_ErrorNotice__WEBPACK_IMPORTED_MODULE_11__["default"], {
        error: error
      })]
    }), !settingsView && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_21__.jsxs)(_wordpress_element__WEBPACK_IMPORTED_MODULE_22__.Fragment, {
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_21__.jsx)("div", {
        className: "googlesitekit-user-input__preview-notice",
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_21__.jsx)(_UserInputQuestionNotice__WEBPACK_IMPORTED_MODULE_9__["default"], {})
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_21__.jsxs)("div", {
        className: "googlesitekit-user-input__footer googlesitekit-user-input__buttons",
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_21__.jsxs)("div", {
          className: "googlesitekit-user-input__footer-nav",
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_21__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_2__.SpinnerButton, {
            className: "googlesitekit-user-input__buttons--next",
            onClick: onSaveClick,
            disabled: hasError || isScreenLoading,
            isSaving: isScreenLoading,
            children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Save', 'google-site-kit')
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_21__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_2__.Button, {
            className: "googlesitekit-user-input__buttons--back",
            onClick: goBack,
            disabled: isScreenLoading,
            tertiary: true,
            children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Back', 'google-site-kit')
          })]
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_21__.jsx)("div", {
          className: "googlesitekit-user-input__footer-cancel",
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_21__.jsx)(_CancelUserInputButton__WEBPACK_IMPORTED_MODULE_13__["default"], {
            disabled: isScreenLoading
          })
        })]
      })]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_21__.jsx)(_js_components_Portal__WEBPACK_IMPORTED_MODULE_15__["default"], {
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_21__.jsx)(_js_components_KeyMetrics_ConfirmSitePurposeChangeModal__WEBPACK_IMPORTED_MODULE_16__["default"], {
        dialogActive: isModalOpen,
        handleDialog: handleModal
      })
    })]
  });
}
UserInputPreview.propTypes = {
  submitChanges: (prop_types__WEBPACK_IMPORTED_MODULE_23___default().func),
  goBack: (prop_types__WEBPACK_IMPORTED_MODULE_23___default().func),
  error: (prop_types__WEBPACK_IMPORTED_MODULE_23___default().object),
  loading: (prop_types__WEBPACK_IMPORTED_MODULE_23___default().bool),
  settingsView: (prop_types__WEBPACK_IMPORTED_MODULE_23___default().bool)
};

/***/ }),

/***/ "./js/components/user-input/UserInputPreviewAnswers.js":
/*!*************************************************************!*\
  !*** ./js/components/user-input/UserInputPreviewAnswers.js ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ UserInputPreviewAnswers)
/* harmony export */ });
/* harmony import */ var _js_components_LoadingWrapper__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @/js/components/LoadingWrapper */ "./js/components/LoadingWrapper.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * User Input Preview Answers.
 *
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Internal dependencies
 */


function UserInputPreviewAnswers({
  loading,
  errorMessage,
  options,
  values
}) {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", {
    className: "googlesitekit-user-input__preview-answers",
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsxs)(_js_components_LoadingWrapper__WEBPACK_IMPORTED_MODULE_0__["default"], {
      loading: loading,
      width: "340px",
      height: "36px",
      children: [errorMessage && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("p", {
        className: "googlesitekit-error-text",
        children: errorMessage
      }), !errorMessage && values.map(value => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", {
        className: "googlesitekit-user-input__preview-answer",
        children: options[value]
      }, value))]
    })
  });
}

/***/ }),

/***/ "./js/components/user-input/UserInputPreviewGroup.js":
/*!***********************************************************!*\
  !*** ./js/components/user-input/UserInputPreviewGroup.js ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ UserInputPreviewGroup)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_20___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_20__);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _wordpress_compose__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! @wordpress/compose */ "../node_modules/@wordpress/compose/build-module/hooks/use-previous/index.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _js_googlesitekit_datastore_ui_constants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/googlesitekit/datastore/ui/constants */ "./js/googlesitekit/datastore/ui/constants.js");
/* harmony import */ var _js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/googlesitekit/datastore/user/constants */ "./js/googlesitekit/datastore/user/constants.js");
/* harmony import */ var _js_googlesitekit_datastore_location_constants__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/googlesitekit/datastore/location/constants */ "./js/googlesitekit/datastore/location/constants.js");
/* harmony import */ var _js_util__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @/js/util */ "./js/util/index.js");
/* harmony import */ var _util_validation__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./util/validation */ "./js/components/user-input/util/validation.js");
/* harmony import */ var _js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @/js/hooks/useViewContext */ "./js/hooks/useViewContext.js");
/* harmony import */ var _util_constants__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./util/constants */ "./js/components/user-input/util/constants.js");
/* harmony import */ var _js_components_Link__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @/js/components/Link */ "./js/components/Link.js");
/* harmony import */ var _js_components_LoadingWrapper__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @/js/components/LoadingWrapper */ "./js/components/LoadingWrapper.js");
/* harmony import */ var _svg_icons_chevron_down_svg__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! @/svg/icons/chevron-down.svg */ "./svg/icons/chevron-down.svg");
/* harmony import */ var _UserInputPreviewAnswers__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ./UserInputPreviewAnswers */ "./js/components/user-input/UserInputPreviewAnswers.js");
/* harmony import */ var _UserInputEditModeContent__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ./UserInputEditModeContent */ "./js/components/user-input/UserInputEditModeContent.js");
/* harmony import */ var _js_hooks_useFormValue__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! @/js/hooks/useFormValue */ "./js/hooks/useFormValue.js");
/* harmony import */ var _js_components_Typography_P__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! @/js/components/Typography/P */ "./js/components/Typography/P.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * User Input Preview Group.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * WordPress dependencies
 */




/**
 * Internal dependencies
 */
















function UserInputPreviewGroup({
  slug,
  title,
  subtitle,
  values,
  options = {},
  loading = false,
  settingsView = false,
  onChange
}) {
  const viewContext = (0,_js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_8__["default"])();
  const isNavigating = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.useSelect)(select => select(_js_googlesitekit_datastore_location_constants__WEBPACK_IMPORTED_MODULE_5__.CORE_LOCATION).isNavigating());
  const currentlyEditingSlug = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.useSelect)(select => select(_js_googlesitekit_datastore_ui_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_UI).getValue(_util_constants__WEBPACK_IMPORTED_MODULE_9__.USER_INPUT_CURRENTLY_EDITING_KEY));
  const isSavingSettings = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.useSelect)(select => {
    const userInputSettings = select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_4__.CORE_USER).getUserInputSettings();
    return select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_4__.CORE_USER).isSavingUserInputSettings(userInputSettings);
  });
  const savedPurposeAnswer = (0,_js_hooks_useFormValue__WEBPACK_IMPORTED_MODULE_15__["default"])(_util_constants__WEBPACK_IMPORTED_MODULE_9__.FORM_USER_INPUT_QUESTION_SNAPSHOT, _util_constants__WEBPACK_IMPORTED_MODULE_9__.USER_INPUT_QUESTIONS_PURPOSE);
  const previousPurposeAnswer = (0,_wordpress_compose__WEBPACK_IMPORTED_MODULE_18__["default"])(savedPurposeAnswer);
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_19__.useEffect)(() => {
    // If user purpose is opened currently saved value was snapshot
    // and it will differ from previous value. Once modal is closed
    // the edit button will be toggled, and snapshotted value will be undefined
    // while previously it had value, that will mark that modal is closed and we should
    // return focus to the edit button.
    if (slug === _util_constants__WEBPACK_IMPORTED_MODULE_9__.USER_INPUT_QUESTIONS_PURPOSE && previousPurposeAnswer !== savedPurposeAnswer && savedPurposeAnswer === undefined) {
      setTimeout(() => {
        editButtonRef.current?.focus?.();
      }, 100);
    }
  }, [savedPurposeAnswer, previousPurposeAnswer, slug]);
  const {
    setValues
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.useDispatch)(_js_googlesitekit_datastore_ui_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_UI);
  const {
    resetUserInputSettings
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.useDispatch)(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_4__.CORE_USER);
  const isEditing = currentlyEditingSlug === slug;
  const isScreenLoading = isSavingSettings || isNavigating;
  const gaEventCategory = `${viewContext}_kmw`;
  const toggleEditMode = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_19__.useCallback)(() => {
    if (isEditing) {
      setValues({
        [_util_constants__WEBPACK_IMPORTED_MODULE_9__.USER_INPUT_CURRENTLY_EDITING_KEY]: undefined
      });
      editButtonRef.current?.focus?.();
    } else {
      (0,_js_util__WEBPACK_IMPORTED_MODULE_6__.trackEvent)(gaEventCategory, 'question_edit', slug);
      setValues({
        [_util_constants__WEBPACK_IMPORTED_MODULE_9__.USER_INPUT_CURRENTLY_EDITING_KEY]: slug
      });
    }
  }, [gaEventCategory, isEditing, setValues, slug]);
  const errorMessage = (0,_util_validation__WEBPACK_IMPORTED_MODULE_7__.getErrorMessageForAnswer)(values, _util_constants__WEBPACK_IMPORTED_MODULE_9__.USER_INPUT_MAX_ANSWERS[slug]);
  const editButtonRef = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_19__.useRef)();
  const handleOnEditClick = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_19__.useCallback)(async () => {
    if (settingsView) {
      if (isScreenLoading || !!currentlyEditingSlug && !isEditing) {
        return;
      }

      // Do not preserve changes if preview group is collapsed with individual CTAs.
      if (isEditing) {
        await resetUserInputSettings();
      }
    }
    toggleEditMode();
  }, [settingsView, isScreenLoading, currentlyEditingSlug, isEditing, resetUserInputSettings, toggleEditMode]);
  const Subtitle = typeof subtitle === 'function' ? subtitle : undefined;
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_17__.jsxs)("div", {
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-user-input__preview-group', {
      'googlesitekit-user-input__preview-group--editing': isEditing,
      'googlesitekit-user-input__preview-group--individual-cta': settingsView
    }),
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_17__.jsxs)("div", {
      className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-user-input__preview-group-title', {
        'googlesitekit-user-input__preview-group-title-with-subtitle': Subtitle || subtitle
      }),
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_17__.jsx)(_js_components_LoadingWrapper__WEBPACK_IMPORTED_MODULE_11__["default"], {
        loading: loading,
        width: "340px",
        height: "21px",
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_17__.jsx)(_js_components_Typography_P__WEBPACK_IMPORTED_MODULE_16__["default"], {
          children: title
        })
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_17__.jsx)(_js_components_LoadingWrapper__WEBPACK_IMPORTED_MODULE_11__["default"], {
        loading: loading,
        className: "googlesitekit-margin-left-auto",
        width: "60px",
        height: "26px",
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_17__.jsxs)(_js_components_Link__WEBPACK_IMPORTED_MODULE_10__["default"], {
          onClick: handleOnEditClick,
          ref: editButtonRef,
          disabled: isScreenLoading || !!currentlyEditingSlug && !isEditing,
          trailingIcon: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_17__.jsx)(_svg_icons_chevron_down_svg__WEBPACK_IMPORTED_MODULE_12__["default"], {
            width: 20,
            height: 20
          }),
          secondary: true,
          linkButton: true,
          children: [isEditing && (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Close', 'google-site-kit'), !isEditing && (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Edit', 'google-site-kit')]
        })
      })]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_17__.jsx)(_js_components_LoadingWrapper__WEBPACK_IMPORTED_MODULE_11__["default"], {
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_17__.jsxs)("div", {
        className: "googlesitekit-user-input__preview-group-subtitle",
        children: [Subtitle && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_17__.jsx)("div", {
          className: "googlesitekit-user-input__preview-group-subtitle-component",
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_17__.jsx)(Subtitle, {})
        }), !Subtitle && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_17__.jsx)(_js_components_Typography_P__WEBPACK_IMPORTED_MODULE_16__["default"], {
          children: subtitle
        })]
      })
    }), !isEditing && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_17__.jsx)(_UserInputPreviewAnswers__WEBPACK_IMPORTED_MODULE_13__["default"], {
      values: values,
      options: options,
      loading: loading,
      errorMessage: errorMessage
    }), isEditing && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_17__.jsx)(_UserInputEditModeContent__WEBPACK_IMPORTED_MODULE_14__["default"], {
      slug: slug,
      options: options,
      onChange: onChange,
      settingsView: settingsView,
      values: values
    })]
  });
}
UserInputPreviewGroup.propTypes = {
  slug: (prop_types__WEBPACK_IMPORTED_MODULE_20___default().string).isRequired,
  title: (prop_types__WEBPACK_IMPORTED_MODULE_20___default().string).isRequired,
  subtitle: prop_types__WEBPACK_IMPORTED_MODULE_20___default().oneOfType([(prop_types__WEBPACK_IMPORTED_MODULE_20___default().string), (prop_types__WEBPACK_IMPORTED_MODULE_20___default().elementType)]),
  values: prop_types__WEBPACK_IMPORTED_MODULE_20___default().arrayOf((prop_types__WEBPACK_IMPORTED_MODULE_20___default().string)).isRequired,
  options: prop_types__WEBPACK_IMPORTED_MODULE_20___default().shape({}),
  loading: (prop_types__WEBPACK_IMPORTED_MODULE_20___default().bool),
  settingsView: (prop_types__WEBPACK_IMPORTED_MODULE_20___default().bool),
  onChange: (prop_types__WEBPACK_IMPORTED_MODULE_20___default().func)
};

/***/ }),

/***/ "./js/components/user-input/UserInputQuestionAuthor.js":
/*!*************************************************************!*\
  !*** ./js/components/user-input/UserInputQuestionAuthor.js ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ UserInputQuestionAuthor)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/googlesitekit/datastore/user/constants */ "./js/googlesitekit/datastore/user/constants.js");
/* harmony import */ var _js_components_Typography_P__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/components/Typography/P */ "./js/components/Typography/P.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * User Input Question Author Component.
 *
 * Site Kit by Google, Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */




function UserInputQuestionAuthor({
  slug
}) {
  const author = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_2__.CORE_USER).getUserInputSettingAuthor(slug));
  if (!author || !author.photo || !author.login) {
    return null;
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsxs)("div", {
    className: "googlesitekit-user-input__author",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(_js_components_Typography_P__WEBPACK_IMPORTED_MODULE_3__["default"], {
      children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('This question has been answered by:', 'google-site-kit')
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsxs)("div", {
      className: "googlesitekit-user-input__author-info",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("img", {
        alt: author.login,
        src: author.photo
      }), author.login]
    })]
  });
}
UserInputQuestionAuthor.propTypes = {
  slug: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().string).isRequired
};

/***/ }),

/***/ "./js/components/user-input/UserInputQuestionNotice.js":
/*!*************************************************************!*\
  !*** ./js/components/user-input/UserInputQuestionNotice.js ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ UserInputQuestionNotice)
/* harmony export */ });
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * User Input Question Notice.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */


function UserInputQuestionNotice({
  className
}) {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("p", {
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()(className, 'googlesitekit-user-input__question-notice'),
    children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('You can always edit your answers later in Settings', 'google-site-kit')
  });
}

/***/ }),

/***/ "./js/components/user-input/UserInputSelectOptions.js":
/*!************************************************************!*\
  !*** ./js/components/user-input/UserInputSelectOptions.js ***!
  \************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ UserInputSelectOptions)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_13___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_13__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _wordpress_keycodes__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! @wordpress/keycodes */ "../node_modules/@wordpress/keycodes/build-module/index.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! googlesitekit-components */ "googlesitekit-components");
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_components__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/googlesitekit/datastore/user/constants */ "./js/googlesitekit/datastore/user/constants.js");
/* harmony import */ var _js_googlesitekit_datastore_forms_constants__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/googlesitekit/datastore/forms/constants */ "./js/googlesitekit/datastore/forms/constants.js");
/* harmony import */ var _js_googlesitekit_datastore_location_constants__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/googlesitekit/datastore/location/constants */ "./js/googlesitekit/datastore/location/constants.js");
/* harmony import */ var _js_material_components__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @/js/material-components */ "./js/material-components/index.js");
/* harmony import */ var _util_constants__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./util/constants */ "./js/components/user-input/util/constants.js");
/* harmony import */ var _js_util__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @/js/util */ "./js/util/index.js");
/* harmony import */ var _js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @/js/hooks/useViewContext */ "./js/hooks/useViewContext.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * User Input Select Options.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */




/**
 * Internal dependencies
 */










function UserInputSelectOptions({
  slug,
  descriptions,
  options,
  max,
  next,
  showInstructions,
  alignLeftOptions
}) {
  const viewContext = (0,_js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_9__["default"])();
  const values = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_USER).getUserInputSetting(slug) || []);
  const isSavingSettings = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_USER).isSavingUserInputSettings(values));
  const isNavigating = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_datastore_location_constants__WEBPACK_IMPORTED_MODULE_5__.CORE_LOCATION).isNavigating());
  const {
    setUserInputSetting
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useDispatch)(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_USER);
  const optionsRef = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_11__.useRef)();
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_11__.useEffect)(() => {
    if (!optionsRef?.current) {
      return;
    }
    function focusOption(element) {
      if (element) {
        setTimeout(() => {
          element.focus();
        }, 50);
      }
    }
    const optionType = max === 1 ? 'radio' : 'checkbox';
    const checkedEl = optionsRef.current.querySelector(`input[type="${optionType}"]:checked`);
    if (checkedEl) {
      focusOption(checkedEl);
    } else {
      const el = optionsRef.current.querySelector(`input[type="${optionType}"]`);
      focusOption(el);
    }
  }, [max]);
  const {
    setValues
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useDispatch)(_js_googlesitekit_datastore_forms_constants__WEBPACK_IMPORTED_MODULE_4__.CORE_FORMS);
  const onClick = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_11__.useCallback)(event => {
    const {
      target
    } = event;
    const {
      value,
      checked
    } = target;
    const newValues = new Set([value, ...values]);
    if (!checked) {
      newValues.delete(value);
    }
    const gaEventName = slug === _util_constants__WEBPACK_IMPORTED_MODULE_7__.USER_INPUT_QUESTION_POST_FREQUENCY ? 'content_frequency_question_answer' : `site_${slug}_question_answer`;
    const checkedValues = Array.from(newValues).slice(0, max);
    (0,_js_util__WEBPACK_IMPORTED_MODULE_8__.trackEvent)(`${viewContext}_kmw`, gaEventName, checkedValues.join());
    if (slug === _util_constants__WEBPACK_IMPORTED_MODULE_7__.USER_INPUT_QUESTIONS_PURPOSE) {
      setValues(_util_constants__WEBPACK_IMPORTED_MODULE_7__.FORM_USER_INPUT_QUESTION_SNAPSHOT, {
        [slug]: values
      });
    }
    setUserInputSetting(slug, checkedValues);
  }, [max, setUserInputSetting, slug, values, viewContext, setValues]);
  const onKeyDown = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_11__.useCallback)(event => {
    if (event.keyCode === _wordpress_keycodes__WEBPACK_IMPORTED_MODULE_12__.ENTER && values.length > 0 && values.length <= max && !values.includes('') && next && typeof next === 'function') {
      next();
    }
  }, [values, next, max]);
  const onClickProps = {
    [max > 1 ? 'onChange' : 'onClick']: onClick
  };
  const ListComponent = max === 1 ? googlesitekit_components__WEBPACK_IMPORTED_MODULE_2__.Radio : googlesitekit_components__WEBPACK_IMPORTED_MODULE_2__.Checkbox;
  const items = Object.keys(options).map(optionSlug => {
    if ('sell_products_or_service' === optionSlug) {
      return false;
    }
    const props = {
      id: `${slug}-${optionSlug}`,
      value: optionSlug,
      description: descriptions?.[optionSlug],
      checked: values.includes(optionSlug),
      onKeyDown,
      alignLeft: alignLeftOptions,
      ...onClickProps
    };
    if (max > 1) {
      props.disabled = values.length >= max && !values.includes(optionSlug);
      props.name = `${slug}-${optionSlug}`;
    } else {
      props.name = slug;
    }
    if (isSavingSettings || isNavigating) {
      props.disabled = true;
    }
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)("div", {
      className: "googlesitekit-user-input__select-option",
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)(ListComponent, {
        ...props,
        children: options[optionSlug]
      })
    }, optionSlug);
  });
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsxs)(_js_material_components__WEBPACK_IMPORTED_MODULE_6__.Cell, {
    className: "googlesitekit-user-input__select-options-wrapper",
    lgStart: 6,
    lgSize: 6,
    mdSize: 8,
    smSize: 4,
    children: [showInstructions && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)("p", {
      className: "googlesitekit-user-input__select-instruction",
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)("span", {
        children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.sprintf)(/* translators: %s: number of answers allowed. */
        (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__._n)('Select only %d answer', 'Select up to %d answers', max, 'google-site-kit'), max)
      })
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)("div", {
      className: "googlesitekit-user-input__select-options",
      ref: optionsRef,
      children: items
    })]
  });
}
UserInputSelectOptions.propTypes = {
  slug: (prop_types__WEBPACK_IMPORTED_MODULE_13___default().string).isRequired,
  descriptions: prop_types__WEBPACK_IMPORTED_MODULE_13___default().shape({}),
  options: prop_types__WEBPACK_IMPORTED_MODULE_13___default().shape({}).isRequired,
  max: (prop_types__WEBPACK_IMPORTED_MODULE_13___default().number),
  next: (prop_types__WEBPACK_IMPORTED_MODULE_13___default().func),
  showInstructions: (prop_types__WEBPACK_IMPORTED_MODULE_13___default().bool),
  alignLeftOptions: (prop_types__WEBPACK_IMPORTED_MODULE_13___default().bool)
};
UserInputSelectOptions.defaultProps = {
  max: 1,
  showInstructions: false,
  alignLeftOptions: false
};

/***/ }),

/***/ "./js/components/user-input/util/constants.js":
/*!****************************************************!*\
  !*** ./js/components/user-input/util/constants.js ***!
  \****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   FORM_USER_INPUT_QUESTION_NUMBER: () => (/* binding */ FORM_USER_INPUT_QUESTION_NUMBER),
/* harmony export */   FORM_USER_INPUT_QUESTION_SNAPSHOT: () => (/* binding */ FORM_USER_INPUT_QUESTION_SNAPSHOT),
/* harmony export */   USER_INPUT_CURRENTLY_EDITING_KEY: () => (/* binding */ USER_INPUT_CURRENTLY_EDITING_KEY),
/* harmony export */   USER_INPUT_LEGACY_SITE_PURPOSE_DISMISSED_ITEM_KEY: () => (/* binding */ USER_INPUT_LEGACY_SITE_PURPOSE_DISMISSED_ITEM_KEY),
/* harmony export */   USER_INPUT_MAX_ANSWERS: () => (/* binding */ USER_INPUT_MAX_ANSWERS),
/* harmony export */   USER_INPUT_PURPOSE_TO_CONVERSION_EVENTS_MAPPING: () => (/* binding */ USER_INPUT_PURPOSE_TO_CONVERSION_EVENTS_MAPPING),
/* harmony export */   USER_INPUT_QUESTIONS_GOALS: () => (/* binding */ USER_INPUT_QUESTIONS_GOALS),
/* harmony export */   USER_INPUT_QUESTIONS_LIST: () => (/* binding */ USER_INPUT_QUESTIONS_LIST),
/* harmony export */   USER_INPUT_QUESTIONS_PURPOSE: () => (/* binding */ USER_INPUT_QUESTIONS_PURPOSE),
/* harmony export */   USER_INPUT_QUESTION_POST_FREQUENCY: () => (/* binding */ USER_INPUT_QUESTION_POST_FREQUENCY),
/* harmony export */   getUserInputAnswers: () => (/* binding */ getUserInputAnswers),
/* harmony export */   getUserInputAnswersDescription: () => (/* binding */ getUserInputAnswersDescription),
/* harmony export */   getUserInputQuestions: () => (/* binding */ getUserInputQuestions)
/* harmony export */ });
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/modules/analytics-4/datastore/constants */ "./js/modules/analytics-4/datastore/constants.js");
/**
 * User Input Answers.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */

const USER_INPUT_QUESTIONS_PURPOSE = 'purpose';
const USER_INPUT_QUESTION_POST_FREQUENCY = 'postFrequency';
const USER_INPUT_QUESTIONS_GOALS = 'goals';
const USER_INPUT_QUESTIONS_LIST = [USER_INPUT_QUESTIONS_PURPOSE, USER_INPUT_QUESTION_POST_FREQUENCY, USER_INPUT_QUESTIONS_GOALS];
const USER_INPUT_MAX_ANSWERS = {
  [USER_INPUT_QUESTIONS_PURPOSE]: 1,
  [USER_INPUT_QUESTION_POST_FREQUENCY]: 1,
  [USER_INPUT_QUESTIONS_GOALS]: 3
};
const USER_INPUT_CURRENTLY_EDITING_KEY = 'googlesitekit-user-input-currently-editing';
const FORM_USER_INPUT_QUESTION_NUMBER = 'user_input_question_number';
const FORM_USER_INPUT_QUESTION_SNAPSHOT = 'user_input_question_snapshot';
const USER_INPUT_LEGACY_SITE_PURPOSE_DISMISSED_ITEM_KEY = 'user-input-legacy-site-purpose-dismissed-item';
const USER_INPUT_PURPOSE_TO_CONVERSION_EVENTS_MAPPING = {
  publish_blog: [_js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_1__.ENUM_CONVERSION_EVENTS.CONTACT, _js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_1__.ENUM_CONVERSION_EVENTS.GENERATE_LEAD, _js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_1__.ENUM_CONVERSION_EVENTS.SUBMIT_LEAD_FORM],
  publish_news: [_js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_1__.ENUM_CONVERSION_EVENTS.CONTACT, _js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_1__.ENUM_CONVERSION_EVENTS.GENERATE_LEAD, _js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_1__.ENUM_CONVERSION_EVENTS.SUBMIT_LEAD_FORM],
  monetize_content: [],
  sell_products_or_service: [_js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_1__.ENUM_CONVERSION_EVENTS.PURCHASE, _js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_1__.ENUM_CONVERSION_EVENTS.ADD_TO_CART],
  sell_products: [_js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_1__.ENUM_CONVERSION_EVENTS.PURCHASE, _js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_1__.ENUM_CONVERSION_EVENTS.ADD_TO_CART],
  provide_services: [_js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_1__.ENUM_CONVERSION_EVENTS.CONTACT, _js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_1__.ENUM_CONVERSION_EVENTS.GENERATE_LEAD, _js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_1__.ENUM_CONVERSION_EVENTS.SUBMIT_LEAD_FORM],
  share_portfolio: [_js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_1__.ENUM_CONVERSION_EVENTS.CONTACT, _js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_1__.ENUM_CONVERSION_EVENTS.GENERATE_LEAD, _js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_1__.ENUM_CONVERSION_EVENTS.SUBMIT_LEAD_FORM],
  other: []
};

/**
 * Gets available questions for user input settings.
 *
 * @since 1.139.0
 * @private
 *
 * @return {Object} Questions object.
 */
function getUserInputQuestions() {
  const description = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Based on your answer, Site Kit will suggest the metrics you see on your dashboard to help you track how close you’re getting to your specific goals', 'google-site-kit');
  return [{
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('What is the main purpose of this site?', 'google-site-kit'),
    description
  }, {
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('How often do you create new content for this site?', 'google-site-kit'),
    description
  }, {
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('What are your top 3 goals for this site?', 'google-site-kit'),
    description
  }];
}

/**
 * Gets available answers for user input settings.
 *
 * @since 1.20.0
 * @private
 *
 * @return {Object} Answers object.
 */
function getUserInputAnswers() {
  return {
    USER_INPUT_ANSWERS_PURPOSE: {
      sell_products_or_service: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Sell products or services', 'google-site-kit'),
      sell_products: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Sell products', 'google-site-kit'),
      provide_services: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Provide services', 'google-site-kit'),
      monetize_content: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Monetize content', 'google-site-kit'),
      publish_blog: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Publish a blog', 'google-site-kit'),
      publish_news: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Publish news content', 'google-site-kit'),
      share_portfolio: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Portfolio or business card', 'google-site-kit'),
      other: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Other', 'google-site-kit')
    },
    USER_INPUT_ANSWERS_POST_FREQUENCY: {
      never: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Never', 'google-site-kit'),
      daily: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Daily', 'google-site-kit'),
      weekly: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Weekly', 'google-site-kit'),
      monthly: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Monthly', 'google-site-kit'),
      other: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Other', 'google-site-kit')
    },
    USER_INPUT_ANSWERS_GOALS: {
      retaining_visitors: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Retain visitors, turn them into loyal readers or customers', 'google-site-kit'),
      improving_performance: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Improve speed and performance', 'google-site-kit'),
      finding_new_topics: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Find new topics to write about that connect with my audience', 'google-site-kit'),
      growing_audience: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Grow my audience', 'google-site-kit'),
      expanding_business: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Expand my business into new cities, states or markets', 'google-site-kit'),
      generating_revenue: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Generate more revenue', 'google-site-kit'),
      generating_leads: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Generate leads', 'google-site-kit'),
      help_better_rank: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Help my content rank in a better position in Google search results', 'google-site-kit'),
      understanding_content_performance: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Understand which content is performing best', 'google-site-kit'),
      encourage_to_post: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Encouragement to post more frequently', 'google-site-kit'),
      other: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Other', 'google-site-kit')
    }
  };
}

/**
 * Gets available answer descriptions for user input settings.
 *
 * @since 1.139.0
 * @private
 *
 * @return {Object} Answer descriptions object.
 */
function getUserInputAnswersDescription() {
  return {
    USER_INPUT_ANSWERS_PURPOSE: {
      sell_products_or_service: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('E.g. selling products like devices, apparel, equipment, etc. or offering services like courses, consulting, tutoring, etc.', 'google-site-kit'),
      sell_products: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('E.g. selling devices, apparel, equipment, etc.', 'google-site-kit'),
      provide_services: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('E.g. offering courses, consulting, tutoring, etc.', 'google-site-kit'),
      monetize_content: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Using display ads, affiliate links, sponsored content, etc.', 'google-site-kit'),
      publish_blog: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Writing on a topic you’re passionate about, no focus on monetizing content', 'google-site-kit'),
      publish_news: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('E.g. local news, investigative pieces, interviews, etc.', 'google-site-kit'),
      share_portfolio: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('My website represents me or my company', 'google-site-kit'),
      other: undefined
    }
  };
}

/***/ }),

/***/ "./js/components/user-input/util/validation.js":
/*!*****************************************************!*\
  !*** ./js/components/user-input/util/validation.js ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   getErrorMessageForAnswer: () => (/* binding */ getErrorMessageForAnswer),
/* harmony export */   hasErrorForAnswer: () => (/* binding */ hasErrorForAnswer)
/* harmony export */ });
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/**
 * User Input Validation Utilities.
 *
 * Site Kit by Google, Copyright 2022 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */


/**
 * Returns a boolean indicating whether the given answer has an error.
 *
 * @since 1.92.0
 *
 * @param {string[]} values Array of values to validate.
 * @return {boolean} True if the answer has an error, false otherwise.
 */
function hasErrorForAnswer(values) {
  return values.length === 0;
}

/**
 * Returns an error message for the given answer, or null if the answer is valid.
 *
 * @since 1.92.0
 *
 * @param {string[]} values Array of values to validate.
 * @param {number}   [max]  Maximum number of values allowed. Defaults to 1.
 * @return {string|null} Error message, or null if the answer is valid.
 */
function getErrorMessageForAnswer(values, max = 1) {
  if (values.length === 0) {
    return max === 1 ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Please select an answer', 'google-site-kit') : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Please select at least 1 answer', 'google-site-kit');
  }
  return null;
}

/***/ }),

/***/ "./js/features/index.js":
/*!******************************!*\
  !*** ./js/features/index.js ***!
  \******************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   enabledFeatures: () => (/* binding */ enabledFeatures),
/* harmony export */   isFeatureEnabled: () => (/* binding */ isFeatureEnabled)
/* harmony export */ });
/**
 * Feature flags.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

const enabledFeatures = new Set(__webpack_require__.g?._googlesitekitBaseData?.enabledFeatures || []);

/**
 * Returns true if a feature is enabled; false otherwise.
 *
 * @since 1.25.0
 * @since 1.33.0 Changed _enabledFeatures argument to be a `Set` instead of `Array`.
 *
 * @param {string} feature            The name of the feature to check.
 * @param {Set}    [_enabledFeatures] Optional. The set of enabled features. Uses `enabledFeatures` set by the server in a global JS variable, by default.
 * @return {boolean} `true` if a feature is enabled; `false` otherwise.
 */
function isFeatureEnabled(feature, _enabledFeatures = enabledFeatures) {
  if (!(_enabledFeatures instanceof Set)) {
    return false;
  }
  return _enabledFeatures.has(feature);
}

/***/ }),

/***/ "./js/googlesitekit-data.js":
/*!**********************************!*\
  !*** ./js/googlesitekit-data.js ***!
  \**********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   RegistryProvider: () => (/* reexport safe */ _googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.RegistryProvider),
/* harmony export */   combineStores: () => (/* reexport safe */ _googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.combineStores),
/* harmony export */   commonActions: () => (/* reexport safe */ _googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.commonActions),
/* harmony export */   commonControls: () => (/* reexport safe */ _googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.commonControls),
/* harmony export */   commonStore: () => (/* reexport safe */ _googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.commonStore),
/* harmony export */   controls: () => (/* reexport safe */ _googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.controls),
/* harmony export */   createReducer: () => (/* reexport safe */ _googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.createReducer),
/* harmony export */   createRegistryControl: () => (/* reexport safe */ _googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.createRegistryControl),
/* harmony export */   createRegistrySelector: () => (/* reexport safe */ _googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.createRegistrySelector),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   useDispatch: () => (/* reexport safe */ _googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useDispatch),
/* harmony export */   useInViewSelect: () => (/* reexport safe */ _googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useInViewSelect),
/* harmony export */   useRegistry: () => (/* reexport safe */ _googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useRegistry),
/* harmony export */   useSelect: () => (/* reexport safe */ _googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useSelect),
/* harmony export */   withDispatch: () => (/* reexport safe */ _googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.withDispatch),
/* harmony export */   withSelect: () => (/* reexport safe */ _googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.withSelect)
/* harmony export */ });
/* harmony import */ var _googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./googlesitekit/data */ "./js/googlesitekit/data/index.js");
/**
 * Public Data store entrypoint.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Internal dependencies
 */

if (typeof __webpack_require__.g.googlesitekit === 'undefined') {
  __webpack_require__.g.googlesitekit = {};
}
__webpack_require__.g.googlesitekit.data = _googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__["default"];

// This is only exported for Jest and is not used in production.
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__["default"]);


/***/ }),

/***/ "./js/googlesitekit-settings.js":
/*!**************************************!*\
  !*** ./js/googlesitekit-settings.js ***!
  \**************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react_router_dom__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! react-router-dom */ "../node_modules/react-router-dom/esm/react-router-dom.js");
/* harmony import */ var _wordpress_dom_ready__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @wordpress/dom-ready */ "../node_modules/@wordpress/dom-ready/build-module/index.js");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react-dom/index.js");
/* harmony import */ var _components_Root__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./components/Root */ "./js/components/Root/index.js");
/* harmony import */ var _components_settings_SettingsApp__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./components/settings/SettingsApp */ "./js/components/settings/SettingsApp.js");
/* harmony import */ var _googlesitekit_constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./googlesitekit/constants */ "./js/googlesitekit/constants.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Settings component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */




// Initialize the app once the DOM is ready.

(0,_wordpress_dom_ready__WEBPACK_IMPORTED_MODULE_4__["default"])(() => {
  const renderTarget = document.getElementById('js-googlesitekit-settings');
  if (renderTarget) {
    (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_5__.render)(/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_components_Root__WEBPACK_IMPORTED_MODULE_0__["default"], {
      viewContext: _googlesitekit_constants__WEBPACK_IMPORTED_MODULE_2__.VIEW_CONTEXT_SETTINGS,
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(react_router_dom__WEBPACK_IMPORTED_MODULE_6__.HashRouter, {
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_components_settings_SettingsApp__WEBPACK_IMPORTED_MODULE_1__["default"], {})
      })
    }), renderTarget);
  }
});

/***/ }),

/***/ "./js/googlesitekit/api/cache.js":
/*!***************************************!*\
  !*** ./js/googlesitekit/api/cache.js ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   STORAGE_KEY_PREFIX: () => (/* binding */ STORAGE_KEY_PREFIX),
/* harmony export */   STORAGE_KEY_PREFIX_ROOT: () => (/* binding */ STORAGE_KEY_PREFIX_ROOT),
/* harmony export */   clearCache: () => (/* binding */ clearCache),
/* harmony export */   deleteItem: () => (/* binding */ deleteItem),
/* harmony export */   getItem: () => (/* binding */ getItem),
/* harmony export */   getKeys: () => (/* binding */ getKeys),
/* harmony export */   getStorage: () => (/* binding */ getStorage),
/* harmony export */   isStorageAvailable: () => (/* binding */ isStorageAvailable),
/* harmony export */   resetDefaultStorageOrder: () => (/* binding */ resetDefaultStorageOrder),
/* harmony export */   setItem: () => (/* binding */ setItem),
/* harmony export */   setSelectedStorageBackend: () => (/* binding */ setSelectedStorageBackend),
/* harmony export */   setStorageOrder: () => (/* binding */ setStorageOrder)
/* harmony export */ });
/* harmony import */ var _js_util__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @/js/util */ "./js/util/index.js");
/**
 * Caching functions and cache management for API requests.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Internal dependencies
 */


/**
 * Prefix used for all Site Kit keys.
 *
 * Anything not using this prefix should not be touched by this library.
 *
 * @since 1.96.0
 * @private
 */
const STORAGE_KEY_PREFIX_ROOT = 'googlesitekit_';

/**
 * Prefix used for all Site Kit keys for the current Site Kit version.
 *
 * Anything not using this key should not be touched by this library.
 *
 * @since 1.5.0
 * @since 1.92.0 Updated to include a user, session, and blog-specific hash.
 * @since 1.96.0 Updated to make use of the new STORAGE_KEY_PREFIX_ROOT constant.
 * @private
 */
const STORAGE_KEY_PREFIX = `${STORAGE_KEY_PREFIX_ROOT}${"1.162.0"}_${__webpack_require__.g._googlesitekitBaseData.storagePrefix}_`;
const defaultOrder = ['sessionStorage', 'localStorage'];
let storageBackend;
let storageOrder = [...defaultOrder];

/**
 * Overrides the storage backend.
 *
 * Largely used for tests. Should not be used directly.
 *
 * @since 1.5.0
 * @private
 *
 * @param {*} backend Backend to set for the cache.
 */
function setSelectedStorageBackend(backend) {
  storageBackend = backend;
}

/**
 * Overrides the priority of storage mechanisms.
 *
 * Largely used for tests. Implicitly resets the selected storage backend,
 * causing `_getStorage` to re-run its checks for the best available
 * storage backend.
 *
 * @since 1.5.0
 * @private
 *
 * @param {Array} order Ordered array of storage backends to use.
 */
function setStorageOrder(order) {
  storageOrder = [...order];
  setSelectedStorageBackend(undefined);
}

/**
 * Resets the storage mechanism order.
 *
 * Largely used for tests. Implicitly resets the selected storage backend,
 * causing `_getStorage` to re-run its checks for the best available
 * storage backend.
 *
 * @since 1.5.0
 * @private
 */
function resetDefaultStorageOrder() {
  storageOrder = [...defaultOrder];
  setSelectedStorageBackend(undefined);
}

/**
 * Detects whether browser storage is both supported and available.
 *
 * @since 1.5.0
 * @private
 *
 * @param {string} type Browser storage to test. Should be one of `localStorage` or `sessionStorage`.
 * @return {boolean} True if the given storage is available, false otherwise.
 */
// eslint-disable-next-line require-await
async function isStorageAvailable(type) {
  const storage = __webpack_require__.g[type];
  if (!storage) {
    return false;
  }
  try {
    const x = '__storage_test__';
    storage.setItem(x, x);
    storage.removeItem(x);
    return true;
  } catch (e) {
    return e instanceof DOMException && (
    // everything except Firefox
    22 === e.code ||
    // Firefox
    1014 === e.code ||
    // test name field too, because code might not be present
    // everything except Firefox
    'QuotaExceededError' === e.name ||
    // Firefox
    'NS_ERROR_DOM_QUOTA_REACHED' === e.name) &&
    // acknowledge QuotaExceededError only if there's something already stored
    0 !== storage.length;
  }
}

/**
 * Gets the storage object to use.
 *
 * @since 1.5.0
 * @private
 *
 * @return {Storage|null} A storage mechanism (`localStorage` or `sessionStorage`) if available; otherwise returns `null`.
 */
async function getStorage() {
  if (storageBackend !== undefined) {
    return storageBackend;
  }

  // Only run the logic to determine the storage object once.
  for (const backend of storageOrder) {
    if (storageBackend) {
      continue;
    }
    if (await isStorageAvailable(backend)) {
      storageBackend = __webpack_require__.g[backend];
    }
  }
  if (storageBackend === undefined) {
    storageBackend = null;
  }
  return storageBackend;
}

/**
 * Gets cached data.
 *
 * Get cached data from the persistent storage cache.
 *
 * @since 1.5.0
 *
 * @param {string} key Name of cache key.
 * @return {Promise} A promise returned, containing an object with the cached value (if found) and whether or not there was a cache hit.
 */
async function getItem(key) {
  const storage = await getStorage();
  if (storage) {
    const cachedData = storage.getItem(`${STORAGE_KEY_PREFIX}${key}`);
    if (cachedData) {
      const parsedData = JSON.parse(cachedData);
      const {
        timestamp,
        ttl,
        value,
        isError
      } = parsedData;

      // Ensure a timestamp is found, otherwise this isn't a valid cache hit.
      // (We don't check for a truthy `value`, because it could be legitimately
      // false-y if `0`, `null`, etc.)
      if (timestamp && (!ttl ||
      // Ensure the cached data isn't too old.
      // The cache dates shouldn't rely on reference
      // dates for cache expiration. This is a case
      // where we actually want to rely on
      // the _actual_ date/time the data was set.
      Math.round(Date.now() / 1000) - timestamp < ttl) // eslint-disable-line sitekit/no-direct-date
      ) {
        return {
          cacheHit: true,
          value,
          isError
        };
      }
    }
  }
  return {
    cacheHit: false,
    value: undefined
  };
}

/**
 * Sets cached data using a key.
 *
 * Save data to the relevant local storage mechanism, if available.
 * By default, data is saved with a one hour (60 minute) TTL.
 *
 * @since 1.5.0
 *
 * @param {string}  key              Name of cache key.
 * @param {*}       value            Value to store in the cache.
 * @param {Object}  args             Optional object containing ttl, timestamp and isError keys.
 * @param {number}  [args.ttl]       Optional. Validity of the cached item in seconds.
 * @param {number}  [args.timestamp] Optional. Timestamp when the cached item was created.
 * @param {boolean} [args.isError]   Optional. Whether the cached item is an error.
 * @return {Promise} A promise: resolves to `true` if the value was saved; `false` if not (usually because no storage method was available).
 */
async function setItem(key, value, {
  ttl = _js_util__WEBPACK_IMPORTED_MODULE_0__.HOUR_IN_SECONDS,
  // Cached times should rely on real times, not the reference date,
  // so the cache timeouts are consistent even when changing
  // the reference dates when developing/testing.
  timestamp = Math.round(Date.now() / 1000),
  // eslint-disable-line sitekit/no-direct-date
  isError = false
} = {}) {
  const storage = await getStorage();
  if (storage) {
    try {
      storage.setItem(`${STORAGE_KEY_PREFIX}${key}`, JSON.stringify({
        timestamp,
        ttl,
        value,
        isError
      }));
      return true;
    } catch (error) {
      __webpack_require__.g.console.warn('Encountered an unexpected storage error:', error);
      return false;
    }
  }
  return false;
}

/**
 * Removes cached data by key.
 *
 * Remove one piece of cached data from the persistent storage cache, by key.
 *
 * @since 1.5.0
 *
 * @param {string} key Name of cache key.
 * @return {Promise} A promise: resolves to `true` if the value was deleted; `false` if not (usually because no storage method was available).
 */
async function deleteItem(key) {
  const storage = await getStorage();
  if (storage) {
    try {
      const fullKey = key.startsWith(STORAGE_KEY_PREFIX_ROOT) ? key : `${STORAGE_KEY_PREFIX}${key}`;
      storage.removeItem(fullKey);
      return true;
    } catch (error) {
      __webpack_require__.g.console.warn('Encountered an unexpected storage error:', error);
      return false;
    }
  }
  return false;
}

/**
 * Gets all cache keys created by Site Kit.
 *
 * @since 1.5.0
 *
 * @return {Promise} A promise: resolves to an array of all keys.
 */
async function getKeys() {
  const storage = await getStorage();
  if (storage) {
    try {
      const keys = [];
      for (let i = 0; i < storage.length; i++) {
        const itemKey = storage.key(i);
        if (itemKey.indexOf(STORAGE_KEY_PREFIX_ROOT) === 0) {
          keys.push(itemKey);
        }
      }
      return keys;
    } catch (error) {
      __webpack_require__.g.console.warn('Encountered an unexpected storage error:', error);
      return [];
    }
  }
  return [];
}

/**
 * Removes the entire cache created by Site Kit.
 *
 * @since 1.5.0
 *
 * @return {Promise} A promise: resolves to `true` if the cache was cleared; `false` if there was an error.
 */
async function clearCache() {
  const storage = await getStorage();
  if (storage) {
    const keys = await getKeys();
    for (const key of keys) {
      await deleteItem(key);
    }
    return true;
  }
  return false;
}

/***/ }),

/***/ "./js/googlesitekit/components-gm2/Button/MaybeTooltip.js":
/*!****************************************************************!*\
  !*** ./js/googlesitekit/components-gm2/Button/MaybeTooltip.js ***!
  \****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ MaybeTooltip)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _js_googlesitekit_components_gm2_Tooltip__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @/js/googlesitekit/components-gm2/Tooltip */ "./js/googlesitekit/components-gm2/Tooltip.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * MaybeTooltip component.
 *
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * Internal dependencies
 */


function MaybeTooltip({
  children,
  disabled = false,
  tooltip = false,
  tooltipTitle = null,
  hasIconOnly = false,
  tooltipEnterDelayInMS = 100
}) {
  if (!disabled && (tooltip && tooltipTitle || hasIconOnly && tooltipTitle)) {
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)(_js_googlesitekit_components_gm2_Tooltip__WEBPACK_IMPORTED_MODULE_0__["default"], {
      title: tooltipTitle,
      enterDelay: tooltipEnterDelayInMS,
      children: children
    });
  }
  return children;
}
MaybeTooltip.propTypes = {
  children: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().node).isRequired,
  disabled: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().bool),
  tooltip: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().bool),
  tooltipTitle: prop_types__WEBPACK_IMPORTED_MODULE_2___default().oneOfType([(prop_types__WEBPACK_IMPORTED_MODULE_2___default().string), (prop_types__WEBPACK_IMPORTED_MODULE_2___default().element)]),
  hasIconOnly: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().bool),
  tooltipEnterDelayInMS: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().number)
};

/***/ }),

/***/ "./js/googlesitekit/components-gm2/Button/SemanticButton.js":
/*!******************************************************************!*\
  !*** ./js/googlesitekit/components-gm2/Button/SemanticButton.js ***!
  \******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * SemanticButton component.
 *
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * WordPress dependencies
 */


const SemanticButton = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.forwardRef)(({
  children,
  href,
  text,
  className,
  danger,
  disabled,
  target,
  'aria-label': ariaLabel,
  inverse,
  tertiary,
  callout,
  calloutStyle,
  ...extraProps
}, ref) => {
  // Use a button if disabled, even if a href is provided to ensure expected behavior.
  const ButtonTag = href && !disabled ? 'a' : 'button';
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)(ButtonTag, {
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('mdc-button', className, {
      'mdc-button--raised': !text && !tertiary && !callout,
      'mdc-button--danger': danger,
      'mdc-button--inverse': inverse,
      'mdc-button--tertiary': tertiary,
      'mdc-button--callout': callout,
      'mdc-button--callout-primary': callout || calloutStyle === 'primary',
      'mdc-button--callout-warning': calloutStyle === 'warning',
      'mdc-button--callout-error': calloutStyle === 'error'
    }),
    href: disabled ? undefined : href,
    ref: ref,
    disabled: !!disabled,
    "aria-label": ariaLabel,
    target: target || '_self',
    role: 'a' === ButtonTag ? 'button' : undefined,
    ...extraProps,
    children: children
  });
});
SemanticButton.propTypes = {
  children: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().node),
  href: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  text: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().bool),
  className: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  danger: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().bool),
  disabled: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().bool),
  target: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  'aria-label': (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  inverse: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().bool),
  tertiary: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().bool),
  callout: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().bool),
  calloutStyle: prop_types__WEBPACK_IMPORTED_MODULE_3___default().oneOf(['primary', 'warning', 'error'])
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (SemanticButton);

/***/ }),

/***/ "./js/googlesitekit/components-gm2/Button/index.js":
/*!*********************************************************!*\
  !*** ./js/googlesitekit/components-gm2/Button/index.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var _react_hook_merged_ref__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @react-hook/merged-ref */ "../node_modules/@react-hook/merged-ref/dist/module/index.js");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _js_material_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/material-components */ "./js/material-components/index.js");
/* harmony import */ var _SemanticButton__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./SemanticButton */ "./js/googlesitekit/components-gm2/Button/SemanticButton.js");
/* harmony import */ var _MaybeTooltip__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./MaybeTooltip */ "./js/googlesitekit/components-gm2/Button/MaybeTooltip.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Button component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */




const Button = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_5__.forwardRef)(({
  children,
  href = null,
  text = false,
  className = '',
  danger = false,
  disabled = false,
  target,
  icon = null,
  trailingIcon = null,
  'aria-label': ariaLabel,
  title = null,
  customizedTooltip = null,
  tooltip = false,
  inverse = false,
  hideTooltipTitle = false,
  tooltipEnterDelayInMS = 100,
  tertiary = false,
  callout = false,
  calloutStyle = null,
  ...extraProps
}, ref) => {
  const buttonRef = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_5__.useCallback)(el => {
    if (el !== null) {
      _js_material_components__WEBPACK_IMPORTED_MODULE_1__.MDCRipple.attachTo(el);
    }
  }, []);
  const mergedRefs = (0,_react_hook_merged_ref__WEBPACK_IMPORTED_MODULE_6__["default"])(ref, buttonRef);
  function getAriaLabel() {
    let label = ariaLabel;
    if (target !== '_blank') {
      return label;
    }
    const newTabText = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__._x)('(opens in a new tab)', 'screen reader text', 'google-site-kit');
    if (typeof children === 'string') {
      label = label || children;
    }
    if (label) {
      return `${label} ${newTabText}`;
    }
    return newTabText;
  }
  const tooltipTitle = !hideTooltipTitle ? title || customizedTooltip || ariaLabel : null;
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(_MaybeTooltip__WEBPACK_IMPORTED_MODULE_3__["default"], {
    disabled: disabled,
    tooltip: tooltip,
    tooltipTitle: tooltipTitle,
    hasIconOnly: !!icon && children === undefined,
    tooltipEnterDelayInMS: tooltipEnterDelayInMS,
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsxs)(_SemanticButton__WEBPACK_IMPORTED_MODULE_2__["default"], {
      href: href,
      disabled: disabled,
      className: className,
      danger: danger,
      text: text,
      tertiary: tertiary,
      inverse: inverse,
      callout: callout,
      calloutStyle: calloutStyle,
      ref: mergedRefs,
      "aria-label": getAriaLabel(),
      target: target || '_self',
      ...extraProps,
      children: [icon, children && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("span", {
        className: "mdc-button__label",
        children: children
      }), trailingIcon]
    })
  });
});
Button.propTypes = {
  onClick: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().func),
  children: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().node),
  href: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().string),
  text: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().bool),
  className: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().string),
  danger: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().bool),
  disabled: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().bool),
  icon: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().element),
  trailingIcon: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().element),
  title: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().string),
  customizedTooltip: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().element),
  tooltip: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().bool),
  inverse: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().bool),
  hideTooltipTitle: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().bool),
  callout: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().bool),
  calloutStyle: prop_types__WEBPACK_IMPORTED_MODULE_7___default().oneOf(['primary', 'warning', 'error'])
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Button);

/***/ }),

/***/ "./js/googlesitekit/components-gm2/CircularProgress.js":
/*!*************************************************************!*\
  !*** ./js/googlesitekit/components-gm2/CircularProgress.js ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ CircularProgress)
/* harmony export */ });
/* harmony import */ var _material_ui_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @material-ui/core */ "../node_modules/@material-ui/core/esm/CircularProgress/CircularProgress.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * CircularProgress component.
 *
 * Site Kit by Google, Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


function CircularProgress(props) {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_material_ui_core__WEBPACK_IMPORTED_MODULE_1__["default"], {
    ...props
  });
}

/***/ }),

/***/ "./js/googlesitekit/components-gm2/SpinnerButton.js":
/*!**********************************************************!*\
  !*** ./js/googlesitekit/components-gm2/SpinnerButton.js ***!
  \**********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   SPINNER_POSITION: () => (/* binding */ SPINNER_POSITION),
/* harmony export */   "default": () => (/* binding */ SpinnerButton)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Button__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Button */ "./js/googlesitekit/components-gm2/Button/index.js");
/* harmony import */ var _CircularProgress__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./CircularProgress */ "./js/googlesitekit/components-gm2/CircularProgress.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Site Kit by Google, Copyright 2022 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * Internal dependencies
 */



const SPINNER_POSITION = {
  BEFORE: 'before',
  AFTER: 'after'
};
function SpinnerButton(props) {
  const {
    className,
    onClick = () => {},
    isSaving = false,
    spinnerPosition = SPINNER_POSITION.AFTER,
    ...restProps
  } = props;
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_Button__WEBPACK_IMPORTED_MODULE_1__["default"], {
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()(className, 'googlesitekit-button-icon--spinner', {
      'googlesitekit-button-icon--spinner__running': isSaving,
      'googlesitekit-button-icon--spinner__before': spinnerPosition === SPINNER_POSITION.BEFORE,
      'googlesitekit-button-icon--spinner__after': spinnerPosition === SPINNER_POSITION.AFTER
    }),
    icon: isSaving && spinnerPosition === SPINNER_POSITION.BEFORE ? /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_CircularProgress__WEBPACK_IMPORTED_MODULE_2__["default"], {
      size: 14
    }) : undefined,
    trailingIcon: isSaving && spinnerPosition === SPINNER_POSITION.AFTER ? /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_CircularProgress__WEBPACK_IMPORTED_MODULE_2__["default"], {
      size: 14
    }) : undefined,
    onClick: onClick,
    ...restProps
  });
}
SpinnerButton.propTypes = {
  className: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().string),
  onClick: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().func),
  isSaving: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().bool),
  spinnerPosition: prop_types__WEBPACK_IMPORTED_MODULE_4___default().oneOf(Object.values(SPINNER_POSITION))
};

/***/ }),

/***/ "./js/googlesitekit/components-gm2/Tooltip.js":
/*!****************************************************!*\
  !*** ./js/googlesitekit/components-gm2/Tooltip.js ***!
  \****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Tooltip)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _material_ui_core__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @material-ui/core */ "../node_modules/@material-ui/core/esm/Tooltip/Tooltip.js");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Tooltip component.
 *
 * Site Kit by Google, Copyright 2022 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */




/**
 * WordPress dependencies
 */


function Tooltip({
  children,
  popperClassName,
  tooltipClassName,
  onOpen,
  onClose,
  ...props
}) {
  const isOpen = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useRef)(false);
  const handleOpen = onOpen ? () => {
    // This fixes a bug where the `onOpen` callback is called when the tooltip is already open.
    if (isOpen.current) {
      return;
    }
    isOpen.current = true;
    onOpen?.();
  } : undefined;
  const handleClose = onOpen ? () => {
    isOpen.current = false;
    onClose?.();
  } : onClose;
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)(_material_ui_core__WEBPACK_IMPORTED_MODULE_3__["default"], {
    classes: {
      popper: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-tooltip-popper', popperClassName),
      tooltip: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-tooltip', tooltipClassName)
    },
    onOpen: handleOpen,
    onClose: handleClose,
    ...props,
    arrow: true,
    children: children
  });
}
Tooltip.propTypes = {
  children: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().node),
  popperClassName: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().string),
  tooltipClassName: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().string),
  onOpen: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().func),
  onClose: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().func)
};

/***/ }),

/***/ "./js/googlesitekit/constants.js":
/*!***************************************!*\
  !*** ./js/googlesitekit/constants.js ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ANCHOR_ID_CONTENT: () => (/* binding */ ANCHOR_ID_CONTENT),
/* harmony export */   ANCHOR_ID_KEY_METRICS: () => (/* binding */ ANCHOR_ID_KEY_METRICS),
/* harmony export */   ANCHOR_ID_MONETIZATION: () => (/* binding */ ANCHOR_ID_MONETIZATION),
/* harmony export */   ANCHOR_ID_SPEED: () => (/* binding */ ANCHOR_ID_SPEED),
/* harmony export */   ANCHOR_ID_TRAFFIC: () => (/* binding */ ANCHOR_ID_TRAFFIC),
/* harmony export */   SITE_KIT_VIEW_CONTEXTS: () => (/* binding */ SITE_KIT_VIEW_CONTEXTS),
/* harmony export */   SITE_KIT_VIEW_ONLY_CONTEXTS: () => (/* binding */ SITE_KIT_VIEW_ONLY_CONTEXTS),
/* harmony export */   VIEW_CONTEXT_ACTIVATION: () => (/* binding */ VIEW_CONTEXT_ACTIVATION),
/* harmony export */   VIEW_CONTEXT_ADMIN_BAR: () => (/* binding */ VIEW_CONTEXT_ADMIN_BAR),
/* harmony export */   VIEW_CONTEXT_ADMIN_BAR_VIEW_ONLY: () => (/* binding */ VIEW_CONTEXT_ADMIN_BAR_VIEW_ONLY),
/* harmony export */   VIEW_CONTEXT_AD_BLOCKING_RECOVERY: () => (/* binding */ VIEW_CONTEXT_AD_BLOCKING_RECOVERY),
/* harmony export */   VIEW_CONTEXT_ENTITY_DASHBOARD: () => (/* binding */ VIEW_CONTEXT_ENTITY_DASHBOARD),
/* harmony export */   VIEW_CONTEXT_ENTITY_DASHBOARD_VIEW_ONLY: () => (/* binding */ VIEW_CONTEXT_ENTITY_DASHBOARD_VIEW_ONLY),
/* harmony export */   VIEW_CONTEXT_MAIN_DASHBOARD: () => (/* binding */ VIEW_CONTEXT_MAIN_DASHBOARD),
/* harmony export */   VIEW_CONTEXT_MAIN_DASHBOARD_VIEW_ONLY: () => (/* binding */ VIEW_CONTEXT_MAIN_DASHBOARD_VIEW_ONLY),
/* harmony export */   VIEW_CONTEXT_METRIC_SELECTION: () => (/* binding */ VIEW_CONTEXT_METRIC_SELECTION),
/* harmony export */   VIEW_CONTEXT_MODULE: () => (/* binding */ VIEW_CONTEXT_MODULE),
/* harmony export */   VIEW_CONTEXT_MODULE_SETUP: () => (/* binding */ VIEW_CONTEXT_MODULE_SETUP),
/* harmony export */   VIEW_CONTEXT_POSTS_LIST: () => (/* binding */ VIEW_CONTEXT_POSTS_LIST),
/* harmony export */   VIEW_CONTEXT_SETTINGS: () => (/* binding */ VIEW_CONTEXT_SETTINGS),
/* harmony export */   VIEW_CONTEXT_SPLASH: () => (/* binding */ VIEW_CONTEXT_SPLASH),
/* harmony export */   VIEW_CONTEXT_USER_INPUT: () => (/* binding */ VIEW_CONTEXT_USER_INPUT),
/* harmony export */   VIEW_CONTEXT_WP_BLOCK_EDITOR: () => (/* binding */ VIEW_CONTEXT_WP_BLOCK_EDITOR),
/* harmony export */   VIEW_CONTEXT_WP_DASHBOARD: () => (/* binding */ VIEW_CONTEXT_WP_DASHBOARD),
/* harmony export */   VIEW_CONTEXT_WP_DASHBOARD_VIEW_ONLY: () => (/* binding */ VIEW_CONTEXT_WP_DASHBOARD_VIEW_ONLY)
/* harmony export */ });
/**
 * Core constants.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

const VIEW_CONTEXT_MAIN_DASHBOARD = 'mainDashboard';
const VIEW_CONTEXT_ENTITY_DASHBOARD = 'entityDashboard';
const VIEW_CONTEXT_MAIN_DASHBOARD_VIEW_ONLY = 'mainDashboardViewOnly';
const VIEW_CONTEXT_ENTITY_DASHBOARD_VIEW_ONLY = 'entityDashboardViewOnly';
const VIEW_CONTEXT_POSTS_LIST = 'postsList';
const VIEW_CONTEXT_USER_INPUT = 'userInput';
const VIEW_CONTEXT_ACTIVATION = 'activation';
const VIEW_CONTEXT_SPLASH = 'splash';
const VIEW_CONTEXT_ADMIN_BAR = 'adminBar';
const VIEW_CONTEXT_ADMIN_BAR_VIEW_ONLY = 'adminBarViewOnly';
const VIEW_CONTEXT_SETTINGS = 'settings';
const VIEW_CONTEXT_AD_BLOCKING_RECOVERY = 'adBlockingRecovery';
const VIEW_CONTEXT_MODULE = 'module';
const VIEW_CONTEXT_WP_DASHBOARD = 'wpDashboard';
const VIEW_CONTEXT_WP_DASHBOARD_VIEW_ONLY = 'wpDashboardViewOnly';
const VIEW_CONTEXT_MODULE_SETUP = 'moduleSetup';
const VIEW_CONTEXT_METRIC_SELECTION = 'metricSelection';
const VIEW_CONTEXT_WP_BLOCK_EDITOR = 'wpBlockEditor';

// Anchor ID Constants
const ANCHOR_ID_KEY_METRICS = 'key-metrics';
const ANCHOR_ID_TRAFFIC = 'traffic';
const ANCHOR_ID_CONTENT = 'content';
const ANCHOR_ID_SPEED = 'speed';
const ANCHOR_ID_MONETIZATION = 'monetization';

// Site Kit only view contexts
const SITE_KIT_VIEW_CONTEXTS = [VIEW_CONTEXT_MAIN_DASHBOARD, VIEW_CONTEXT_ENTITY_DASHBOARD, VIEW_CONTEXT_MAIN_DASHBOARD_VIEW_ONLY, VIEW_CONTEXT_ENTITY_DASHBOARD_VIEW_ONLY, VIEW_CONTEXT_USER_INPUT, VIEW_CONTEXT_SPLASH, VIEW_CONTEXT_SETTINGS, VIEW_CONTEXT_MODULE_SETUP, VIEW_CONTEXT_METRIC_SELECTION];

// Site Kit view-only contexts
const SITE_KIT_VIEW_ONLY_CONTEXTS = [VIEW_CONTEXT_MAIN_DASHBOARD_VIEW_ONLY, VIEW_CONTEXT_ENTITY_DASHBOARD_VIEW_ONLY, VIEW_CONTEXT_ADMIN_BAR_VIEW_ONLY, VIEW_CONTEXT_WP_DASHBOARD_VIEW_ONLY];

/***/ }),

/***/ "./js/googlesitekit/data/create-reducer.js":
/*!*************************************************!*\
  !*** ./js/googlesitekit/data/create-reducer.js ***!
  \*************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   createReducer: () => (/* binding */ createReducer)
/* harmony export */ });
/* harmony import */ var immer__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! immer */ "../node_modules/immer/dist/immer.esm.mjs");
/**
 * Create Immer reducer utility function.
 *
 * Site Kit by Google, Copyright 2022 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * Creates an Immer-enabled reducer.
 *
 * @since 1.84.0
 *
 * @param {Function} reducerFunction A reducer function that follows the curried Immer recipe pattern.
 * @return {Function} An Immer-enabled reducer.
 */
function createReducer(reducerFunction) {
  return (0,immer__WEBPACK_IMPORTED_MODULE_0__["default"])(reducerFunction);
}

/***/ }),

/***/ "./js/googlesitekit/data/create-snapshot-store.js":
/*!********************************************************!*\
  !*** ./js/googlesitekit/data/create-snapshot-store.js ***!
  \********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   createSnapshotStore: () => (/* binding */ createSnapshotStore),
/* harmony export */   getStoresWithSnapshots: () => (/* binding */ getStoresWithSnapshots),
/* harmony export */   restoreAllSnapshots: () => (/* binding */ restoreAllSnapshots),
/* harmony export */   snapshotAllStores: () => (/* binding */ snapshotAllStores)
/* harmony export */ });
/* harmony import */ var invariant__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! invariant */ "../node_modules/invariant/browser.js");
/* harmony import */ var invariant__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(invariant__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _js_googlesitekit_api_cache__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/googlesitekit/api/cache */ "./js/googlesitekit/api/cache.js");
/* harmony import */ var _js_util__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/util */ "./js/util/index.js");
/**
 * Provides a datastore for snapshotting and restoring state.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * Internal dependencies
 */




// Actions
const CREATE_SNAPSHOT = 'CREATE_SNAPSHOT';
const DELETE_SNAPSHOT = 'DELETE_SNAPSHOT';
const RESTORE_SNAPSHOT = 'RESTORE_SNAPSHOT';
const SET_STATE_FROM_SNAPSHOT = 'SET_STATE_FROM_SNAPSHOT';

/**
 * Creates a store object that includes actions and controls for restoring/creating state snapshots.
 *
 * @since 1.9.0
 * @private
 *
 * @param {string} storeName The name of the store to snapshot in the cache.
 * @return {Object} The snapshot store object.
 */
function createSnapshotStore(storeName) {
  invariant__WEBPACK_IMPORTED_MODULE_0___default()(storeName, 'storeName is required to create a snapshot store.');
  const initialState = {};
  const actions = {
    /**
     * Deletes a snapshot of state for a storeName, using our cache API.
     *
     * @since 1.9.0
     * @private
     *
     * @return {boolean} Cache deletion response.
     */
    *deleteSnapshot() {
      const cacheResult = yield {
        payload: {},
        type: DELETE_SNAPSHOT
      };
      return cacheResult;
    },
    /**
     * Restores a snapshot of state for a storeName, if available, using our cache API.
     *
     * @since 1.9.0
     * @private
     *
     * @param {Object}  [options]                   Options object.
     * @param {boolean} [options.clearAfterRestore] Whether or not to delete snapshot after restore. Default: true.
     * @return {boolean} Cache restoration response.
     */
    *restoreSnapshot(options = {}) {
      const {
        clearAfterRestore = true
      } = options;
      const {
        cacheHit,
        value
      } = yield {
        payload: {},
        type: RESTORE_SNAPSHOT
      };
      if (cacheHit) {
        yield {
          payload: {
            snapshot: value
          },
          type: SET_STATE_FROM_SNAPSHOT
        };
        if (clearAfterRestore) {
          yield {
            payload: {},
            type: DELETE_SNAPSHOT
          };
        }
      }
      return cacheHit;
    },
    /**
     * Creates a snapshot of the current state of this store, using our cache API.
     *
     * @since 1.9.0
     * @private
     *
     * @return {boolean} Cache write response.
     */
    *createSnapshot() {
      const cacheResult = yield {
        payload: {},
        type: CREATE_SNAPSHOT
      };
      return cacheResult;
    }
  };
  const controls = {
    [DELETE_SNAPSHOT]: () => {
      return (0,_js_googlesitekit_api_cache__WEBPACK_IMPORTED_MODULE_2__.deleteItem)(`datastore::cache::${storeName}`);
    },
    [CREATE_SNAPSHOT]: (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.createRegistryControl)(registry => () => {
      return (0,_js_googlesitekit_api_cache__WEBPACK_IMPORTED_MODULE_2__.setItem)(`datastore::cache::${storeName}`, registry.stores[storeName].store.getState());
    }),
    [RESTORE_SNAPSHOT]: () => {
      // Only get snapshots made within the last hour.
      return (0,_js_googlesitekit_api_cache__WEBPACK_IMPORTED_MODULE_2__.getItem)(`datastore::cache::${storeName}`, _js_util__WEBPACK_IMPORTED_MODULE_3__.HOUR_IN_SECONDS);
    }
  };
  function reducer(state = initialState, {
    type,
    payload
  }) {
    // eslint-disable-line no-shadow
    switch (type) {
      case SET_STATE_FROM_SNAPSHOT:
        {
          const {
            snapshot
          } = payload;
          // Exclude any top-level errors from the restored state.
          // eslint-disable-next-line no-unused-vars
          const {
            error,
            ...newState
          } = snapshot;
          return newState;
        }
      default:
        {
          return state;
        }
    }
  }
  return {
    initialState,
    actions,
    controls,
    reducer
  };
}

/**
 * Inspects a registry to find all stores that support our snapshot features.
 *
 * @since 1.9.0
 * @private
 *
 * @param {wp.data.registry} registry Optional. Registry object to inspect for stores that support state restoration. Defaults to `googlesitekit.data`.
 * @return {Object} The snapshot store object.
 */
function getStoresWithSnapshots(registry = (googlesitekit_data__WEBPACK_IMPORTED_MODULE_1___default())) {
  return Object.values(registry.stores).filter(store => {
    return Object.keys(store.getActions()).includes('restoreSnapshot');
  });
}

/**
 * Creates snapshots of all supporting stores.
 *
 * @since 1.9.0
 * @private
 *
 * @param {wp.data.registry} [registry] Optional. Registry object to inspect for stores that support state restoration. Defaults to `googlesitekit.data`.
 * @return {Promise} Promise resolves once all snapshots have been taken.
 */
function snapshotAllStores(registry = (googlesitekit_data__WEBPACK_IMPORTED_MODULE_1___default())) {
  return Promise.all(getStoresWithSnapshots(registry).map(store => {
    return store.getActions().createSnapshot();
  }));
}

/**
 * Restores state for all snapshots that support it.
 *
 * Only restores snapshots for stores that have `restoreSnapshot` action, and
 * clears the snapshot afterward, so more stores will not be restored unless
 * a snapshot was saved on the last pageview.
 *
 * @since 1.9.0
 * @private
 *
 * @param {wp.data.registry} [registry] Optional. Registry object to inspect for stores that support state restoration. Defaults to `googlesitekit.data`.
 * @return {Promise} Promise resolves once all snapshots have been restored.
 */
function restoreAllSnapshots(registry = (googlesitekit_data__WEBPACK_IMPORTED_MODULE_1___default())) {
  return Promise.all(getStoresWithSnapshots(registry).map(store => {
    return store.getActions().restoreSnapshot();
  }));
}

/***/ }),

/***/ "./js/googlesitekit/data/index.js":
/*!****************************************!*\
  !*** ./js/googlesitekit/data/index.js ***!
  \****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   RegistryProvider: () => (/* reexport safe */ _wordpress_data__WEBPACK_IMPORTED_MODULE_11__["default"]),
/* harmony export */   combineStores: () => (/* reexport safe */ _utils__WEBPACK_IMPORTED_MODULE_1__.combineStores),
/* harmony export */   commonActions: () => (/* reexport safe */ _utils__WEBPACK_IMPORTED_MODULE_1__.commonActions),
/* harmony export */   commonControls: () => (/* reexport safe */ _utils__WEBPACK_IMPORTED_MODULE_1__.commonControls),
/* harmony export */   commonStore: () => (/* reexport safe */ _utils__WEBPACK_IMPORTED_MODULE_1__.commonStore),
/* harmony export */   controls: () => (/* reexport safe */ _wordpress_data__WEBPACK_IMPORTED_MODULE_4__.controls),
/* harmony export */   createReducer: () => (/* reexport safe */ _create_reducer__WEBPACK_IMPORTED_MODULE_2__.createReducer),
/* harmony export */   createRegistryControl: () => (/* reexport safe */ _wordpress_data__WEBPACK_IMPORTED_MODULE_5__.createRegistryControl),
/* harmony export */   createRegistrySelector: () => (/* reexport safe */ _wordpress_data__WEBPACK_IMPORTED_MODULE_5__.createRegistrySelector),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   useDispatch: () => (/* reexport safe */ _wordpress_data__WEBPACK_IMPORTED_MODULE_7__["default"]),
/* harmony export */   useInViewSelect: () => (/* reexport safe */ _js_hooks_useInViewSelect__WEBPACK_IMPORTED_MODULE_0__.useInViewSelect),
/* harmony export */   useRegistry: () => (/* reexport safe */ _wordpress_data__WEBPACK_IMPORTED_MODULE_8__["default"]),
/* harmony export */   useSelect: () => (/* reexport safe */ _wordpress_data__WEBPACK_IMPORTED_MODULE_6__["default"]),
/* harmony export */   withDispatch: () => (/* reexport safe */ _wordpress_data__WEBPACK_IMPORTED_MODULE_10__["default"]),
/* harmony export */   withSelect: () => (/* reexport safe */ _wordpress_data__WEBPACK_IMPORTED_MODULE_9__["default"])
/* harmony export */ });
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/data */ "../node_modules/@wordpress/data/build-module/registry.js");
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @wordpress/data */ "../node_modules/@wordpress/data/build-module/controls.js");
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @wordpress/data */ "../node_modules/@wordpress/data/build-module/factory.js");
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @wordpress/data */ "../node_modules/@wordpress/data/build-module/components/use-select/index.js");
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @wordpress/data */ "../node_modules/@wordpress/data/build-module/components/use-dispatch/use-dispatch.js");
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @wordpress/data */ "../node_modules/@wordpress/data/build-module/components/registry-provider/use-registry.js");
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @wordpress/data */ "../node_modules/@wordpress/data/build-module/components/with-select/index.js");
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @wordpress/data */ "../node_modules/@wordpress/data/build-module/components/with-dispatch/index.js");
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @wordpress/data */ "../node_modules/@wordpress/data/build-module/components/registry-provider/context.js");
/* harmony import */ var _js_hooks_useInViewSelect__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @/js/hooks/useInViewSelect */ "./js/hooks/useInViewSelect.js");
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./utils */ "./js/googlesitekit/data/utils.js");
/* harmony import */ var _create_reducer__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./create-reducer */ "./js/googlesitekit/data/create-reducer.js");
/**
 * Site Kit @wordpress/data (eg Redux-style) data store.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */




/**
 * The Site Kit data registry.
 *
 * This should not be imported directly outside of `googlesitekit-*` files
 * that need access to the registry to register datastores/widgets/etc.
 *
 * Instead, use the exported functions (eg `useSelect`,
 * `createRegistrySelector`, etc.) from the `googlesitekit-data` package to
 * access parts of the registry.
 *
 * @since 1.3.0 Data registry introduced.
 * @since 1.130.0 Deprecated for general use in favor of named exports from `googlesitekit-data` package.
 * @deprecated
 */
const Data = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_3__.createRegistry)({}, __webpack_require__.g.wp?.data);

// Attach some of our utility functions to the registry so third-party
// developers can use them.
Data.combineStores = _utils__WEBPACK_IMPORTED_MODULE_1__.combineStores;
Data.commonActions = _utils__WEBPACK_IMPORTED_MODULE_1__.commonActions;
Data.commonControls = _utils__WEBPACK_IMPORTED_MODULE_1__.commonControls;
Data.commonStore = _utils__WEBPACK_IMPORTED_MODULE_1__.commonStore;
Data.createReducer = _create_reducer__WEBPACK_IMPORTED_MODULE_2__.createReducer;

// Attach our custom, useInViewSelect hook to the registry so third-party
// developers can use it.
Data.useInViewSelect = _js_hooks_useInViewSelect__WEBPACK_IMPORTED_MODULE_0__.useInViewSelect;

// Attach some WordPress data functions to the registry so third-party
// developers can use them without importing '@wordpress/data'.
Data.controls = _wordpress_data__WEBPACK_IMPORTED_MODULE_4__.controls;
Data.createRegistryControl = _wordpress_data__WEBPACK_IMPORTED_MODULE_5__.createRegistryControl;
Data.createRegistrySelector = _wordpress_data__WEBPACK_IMPORTED_MODULE_5__.createRegistrySelector;
Data.useSelect = _wordpress_data__WEBPACK_IMPORTED_MODULE_6__["default"];
Data.useDispatch = _wordpress_data__WEBPACK_IMPORTED_MODULE_7__["default"];
Data.useRegistry = _wordpress_data__WEBPACK_IMPORTED_MODULE_8__["default"];
Data.withSelect = _wordpress_data__WEBPACK_IMPORTED_MODULE_9__["default"];
Data.withDispatch = _wordpress_data__WEBPACK_IMPORTED_MODULE_10__["default"];
Data.RegistryProvider = _wordpress_data__WEBPACK_IMPORTED_MODULE_11__["default"];

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Data);

/***/ }),

/***/ "./js/googlesitekit/data/transform-case.js":
/*!*************************************************!*\
  !*** ./js/googlesitekit/data/transform-case.js ***!
  \*************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   camelCaseToConstantCase: () => (/* binding */ camelCaseToConstantCase),
/* harmony export */   camelCaseToPascalCase: () => (/* binding */ camelCaseToPascalCase),
/* harmony export */   hyphenCaseToPascalCase: () => (/* binding */ hyphenCaseToPascalCase)
/* harmony export */ });
/**
 * Data store utilities for transforming names to a certain case.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Transforms a camelCase name into its PascalCase name.
 *
 * @since 1.10.0
 * @private
 *
 * @param {string} name "camelCase" name to transform.
 * @return {string} PascalCase name.
 */
function camelCaseToPascalCase(name) {
  return name.charAt(0).toUpperCase() + name.slice(1);
}

/**
 * Transforms a camelCase name into its CONSTANT_CASE name.
 *
 * @since 1.10.0
 * @private
 *
 * @param {string} name "camelCase" name to transform.
 * @return {string} CONSTANT_CASE name.
 */
function camelCaseToConstantCase(name) {
  return name.replace(/([a-z0-9]{1})([A-Z]{1})/g, '$1_$2').toUpperCase();
}

/**
 * Transforms a hyphen-case name into its PascalCase name.
 *
 * @since 1.30.0
 * @private
 *
 * @param {string} name "hyphen-case" name to transform.
 * @return {string} PascalCase name.
 */
function hyphenCaseToPascalCase(name) {
  return name.split('-').map(part => part.charAt(0).toUpperCase() + part.slice(1)).join('');
}

/***/ }),

/***/ "./js/googlesitekit/data/utils.js":
/*!****************************************!*\
  !*** ./js/googlesitekit/data/utils.js ***!
  \****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   collect: () => (/* binding */ collect),
/* harmony export */   collectActions: () => (/* binding */ collectActions),
/* harmony export */   collectControls: () => (/* binding */ collectControls),
/* harmony export */   collectName: () => (/* binding */ collectName),
/* harmony export */   collectReducers: () => (/* binding */ collectReducers),
/* harmony export */   collectResolvers: () => (/* binding */ collectResolvers),
/* harmony export */   collectSelectors: () => (/* binding */ collectSelectors),
/* harmony export */   collectState: () => (/* binding */ collectState),
/* harmony export */   combineStores: () => (/* binding */ combineStores),
/* harmony export */   commonActions: () => (/* binding */ commonActions),
/* harmony export */   commonControls: () => (/* binding */ commonControls),
/* harmony export */   commonStore: () => (/* binding */ commonStore),
/* harmony export */   createStrictSelect: () => (/* binding */ createStrictSelect),
/* harmony export */   createValidatedAction: () => (/* binding */ createValidatedAction),
/* harmony export */   createValidationSelector: () => (/* binding */ createValidationSelector)
/* harmony export */ });
/* harmony import */ var invariant__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! invariant */ "../node_modules/invariant/browser.js");
/* harmony import */ var invariant__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(invariant__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var memize__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! memize */ "../node_modules/memize/index.js");
/* harmony import */ var memize__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(memize__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! lodash */ "../node_modules/lodash/lodash.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/data */ "../node_modules/@wordpress/data/build-module/factory.js");
/**
 * Data store utilities.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */




/**
 * WordPress dependencies
 */

const GET_REGISTRY = 'GET_REGISTRY';
const AWAIT = 'AWAIT';

/**
 * Collects and combines multiple objects of similar shape.
 *
 * Used to combine objects like actions, selectors, etc. for a data
 * store while ensuring no keys/action names/selector names are duplicated.
 *
 * Effectively this is an object spread, but throws an error if keys are
 * duplicated.
 *
 * @since 1.5.0
 * @private
 *
 * @param {...Object} items A list of arguments, each one should be an object to combine into one.
 * @return {Object} The combined object.
 */
function collect(...items) {
  const collectedObject = items.reduce((acc, item) => {
    return {
      ...acc,
      ...item
    };
  }, {});
  const functionNames = items.reduce((acc, itemSet) => {
    return [...acc, ...Object.keys(itemSet)];
  }, []);
  const duplicates = findDuplicates(functionNames);
  invariant__WEBPACK_IMPORTED_MODULE_0___default()(duplicates.length === 0, `collect() cannot accept collections with duplicate keys. Your call to collect() contains the following duplicated functions: ${duplicates.join(', ')}. Check your data stores for duplicates.`);
  return collectedObject;
}

/**
 * Collects all actions.
 *
 * @since 1.5.0
 *
 * @param {...Object} args A list of objects, each containing their own actions.
 * @return {Object} The combined object.
 */
const collectActions = collect;

/**
 * Collects all controls.
 *
 * @since 1.5.0
 *
 * @param {...Object} args A list of objects, each containing their own controls.
 * @return {Object} The combined object.
 */
const collectControls = collect;

/**
 * Collects all reducers and (optionally) provides initial state.
 *
 * If the first argument passed is not a function, it will be used as the
 * combined reducer's `initialState`.
 *
 * @since 1.5.0
 *
 * @param {...(Object|Function)} args A list of reducers, each containing their own controls. If the first argument is not a function, it will be used as the combined reducer's `initialState`.
 * @return {Function} A Redux-style reducer.
 */
function collectReducers(...args) {
  const reducers = [...args];
  let initialState;
  if (typeof reducers[0] !== 'function') {
    initialState = reducers.shift();
  }
  return (state = initialState, action = {}) => {
    return reducers.reduce((newState, reducer) => {
      return reducer(newState, action);
    }, state);
  };
}

/**
 * Collects all resolvers.
 *
 * @since 1.5.0
 *
 * @param {...Object} args A list of objects, each containing their own resolvers.
 * @return {Object} The combined object.
 */
const collectResolvers = collect;

/**
 * Collects all selectors.
 *
 * @since 1.5.0
 *
 * @param {...Object} args A list of objects, each containing their own selectors.
 * @return {Object} The combined object.
 */
const collectSelectors = collect;

/**
 * Collects all state values.
 *
 * @since 1.5.0
 *
 * @param {...Object} args A list of objects, each containing their own state values.
 * @return {Object} The combined object.
 */
const collectState = collect;

/**
 * Collects all store names.
 *
 * This function's main purpose is to ensure generated store names for a single store match.
 *
 * @since 1.6.0
 *
 * @param {...string} args A list of store names, all of which must be equal.
 * @return {string} The single store name.
 */
function collectName(...args) {
  const names = [...args];
  const duplicates = findDuplicates(names);
  invariant__WEBPACK_IMPORTED_MODULE_0___default()(duplicates.length === names.length - 1, 'collectName() must not receive different names.');
  return names.shift();
}

/**
 * Passes through state unmodified; eg. an empty reducer.
 *
 * @since 1.8.0
 * @private
 *
 * @param {Object} state A store's state.
 * @return {Object} The same state data as passed in `state`.
 */
function passthroughReducer(state) {
  return state;
}

/**
 * Combines multiple stores.
 *
 * @since 1.8.0
 *
 * @param {...Object} stores A list of objects, each a store containing one or more of the following keys: initialState, actions, controls, reducer, resolvers, selectors.
 * @return {Object} The combined store.
 */
function combineStores(...stores) {
  const combinedInitialState = collectState(...stores.map(store => store.initialState || {}));
  return {
    initialState: combinedInitialState,
    controls: collectControls(...stores.map(store => store.controls || {})),
    actions: collectActions(...stores.map(store => store.actions || {})),
    reducer: collectReducers(combinedInitialState, ...stores.map(store => store.reducer || passthroughReducer)),
    resolvers: collectResolvers(...stores.map(store => store.resolvers || {})),
    selectors: collectSelectors(...stores.map(store => store.selectors || {}))
  };
}

/**
 * An object of common actions most stores will use.
 *
 * @since 1.7.0
 *
 * @return {Object} Key/value list of common actions most stores will want.
 */
const commonActions = {
  /**
   * Dispatches an action and calls a control to get the current data registry.
   *
   * Useful for controls and resolvers that wish to dispatch actions/use selectors
   * on the current data registry.
   *
   * @since 1.7.0
   *
   * @return {Object} FSA-compatible action.
   */
  getRegistry() {
    return {
      payload: {},
      type: GET_REGISTRY
    };
  },
  /**
   * Dispatches an action and calls a control to return the promise resolution.
   *
   * Useful for controls and resolvers that wish to call an asynchronous function or other promise.
   *
   * @since 1.22.0
   *
   * @param {Promise} value A promise to resolve.
   * @return {Object} Object with resolved promise.
   */
  *await(value) {
    return {
      payload: {
        value
      },
      type: AWAIT
    };
  }
};

/**
 * An object of common controls most stores will use.
 *
 * @since 1.7.0
 *
 * @return {Object} Key/value list of common controls most stores will want.
 */
const commonControls = {
  /**
   * Returns the current registry.
   *
   * Useful for controls and resolvers that wish to dispatch actions/use selectors
   * on the current data registry.
   *
   * @since 1.7.0
   *
   * @return {Object} FSA-compatible action.
   */
  [GET_REGISTRY]: (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_3__.createRegistryControl)(registry => () => registry),
  /**
   * Returns a resolved promise.
   *
   * @since 1.22.0
   *
   * @param {Object} payload         Object containing a promise.
   * @param {Object} payload.payload Object containing a promise.
   * @return {*} Resolved promise.
   */
  [AWAIT]: ({
    payload
  }) => payload.value
};

/**
 * Finds all duplicate items in an array and return them.
 *
 * @since 1.5.0
 * @private
 *
 * @param {Array} array Any array.
 * @return {Array} All values in the input array that were duplicated.
 */
function findDuplicates(array) {
  const duplicates = [];
  const counts = {};
  for (let i = 0; i < array.length; i++) {
    const item = array[i];
    counts[item] = counts[item] >= 1 ? counts[item] + 1 : 1;
    if (counts[item] > 1) {
      duplicates.push(item);
    }
  }
  return duplicates;
}

/**
 * A store containing the common actions, controls and reducer that all stores will use.
 *
 * @since 1.8.0
 *
 * @return {Object} Object with common actions, controls and reducer.
 */
const commonStore = {
  actions: commonActions,
  controls: commonControls,
  reducer: passthroughReducer
};

/**
 * Creates a strict version of registry.select for ensuring that a selector is resolved at the time of calling.
 *
 * Not intended to be used directly. This is useful in the context of validation functions
 * to save checking for undefined on every result.
 *
 * Given the registry.select function instance, a new function is returned
 * with the same API as `select()` but will throw an error if the result
 * of the selector function is `undefined`.
 *
 * Ideally this would use something like `hasFinishedResolution` instead,
 * but there is no way to traverse the selectors used internally to identify
 * dependent selectors that have resolvers as many selectors are composed of
 * higher-level selectors internally which is where a resolver is normally implemented.
 *
 * @since 1.18.0
 * @private
 *
 * @param {Function} select The registry.select function.
 * @return {Function} The strict version of registry.select.
 */
function createStrictSelect(select) {
  return storeName => {
    return getStrictSelectors(select(storeName));
  };
}

// Based on {@link https://github.com/WordPress/gutenberg/blob/b1c8026087dfb026eff0a023a5f7febe28c876de/packages/data/src/registry.js#L91}
const getStrictSelectors = memize__WEBPACK_IMPORTED_MODULE_1___default()(selectors => (0,lodash__WEBPACK_IMPORTED_MODULE_2__.mapValues)(selectors, (selector, selectorName) => (...args) => {
  const returnValue = selector(...args);
  invariant__WEBPACK_IMPORTED_MODULE_0___default()(returnValue !== undefined, `${selectorName}(...) is not resolved`);
  return returnValue;
}));

/**
 * Creates two registry selectors that call the incoming function to validate the current state.
 *
 * @since 1.19.0
 *
 * @param {Function} validate         Validation function callback.
 * @param {Object}   [options]        Options to modify the behavior of the generated selectors.
 * @param {boolean}  [options.negate] Whether to negate the boolean result or not. Default: false.
 * @return {Object} Safe and dangerous selectors.
 */
function createValidationSelector(validate, {
  negate = false
} = {}) {
  const safeSelector = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_3__.createRegistrySelector)(select => (state, ...args) => {
    const pass = negate ? false : true;
    const fail = negate ? true : false;
    try {
      validate(select, state, ...args);
      return pass;
    } catch {
      return fail;
    }
  });
  const dangerousSelector = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_3__.createRegistrySelector)(select => (state, ...args) => {
    validate(select, state, ...args);
  });
  return {
    safeSelector,
    dangerousSelector
  };
}

/**
 * Creates a validated action creator.
 *
 * @since 1.32.0
 *
 * @param {Function} validate      A function for validating action arguments.
 * @param {Function} actionCreator A function for returning or yielding redux-style actions.
 * @return {Function} An enhanced action creator.
 */
function createValidatedAction(validate, actionCreator) {
  invariant__WEBPACK_IMPORTED_MODULE_0___default()(typeof validate === 'function', 'a validator function is required.');
  invariant__WEBPACK_IMPORTED_MODULE_0___default()(typeof actionCreator === 'function', 'an action creator function is required.');
  invariant__WEBPACK_IMPORTED_MODULE_0___default()(validate[Symbol.toStringTag] !== 'Generator' && validate[Symbol.toStringTag] !== 'GeneratorFunction', 'an action’s validator function must not be a generator.');
  return (...args) => {
    validate(...args);
    return actionCreator(...args);
  };
}

/***/ }),

/***/ "./js/googlesitekit/datastore/forms/constants.js":
/*!*******************************************************!*\
  !*** ./js/googlesitekit/datastore/forms/constants.js ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   CORE_FORMS: () => (/* binding */ CORE_FORMS)
/* harmony export */ });
/**
 * `core/forms` data store: constants.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

const CORE_FORMS = 'core/forms';

/***/ }),

/***/ "./js/googlesitekit/datastore/location/constants.js":
/*!**********************************************************!*\
  !*** ./js/googlesitekit/datastore/location/constants.js ***!
  \**********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   CORE_LOCATION: () => (/* binding */ CORE_LOCATION)
/* harmony export */ });
/**
 * `core/location` data store: constants.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

const CORE_LOCATION = 'core/location';

/***/ }),

/***/ "./js/googlesitekit/datastore/site/constants.js":
/*!******************************************************!*\
  !*** ./js/googlesitekit/datastore/site/constants.js ***!
  \******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   AMP_MODE_PRIMARY: () => (/* binding */ AMP_MODE_PRIMARY),
/* harmony export */   AMP_MODE_SECONDARY: () => (/* binding */ AMP_MODE_SECONDARY),
/* harmony export */   CORE_SITE: () => (/* binding */ CORE_SITE)
/* harmony export */ });
/**
 * `core/site` data store: constants.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

const CORE_SITE = 'core/site';
const AMP_MODE_PRIMARY = 'primary';
const AMP_MODE_SECONDARY = 'secondary';

/***/ }),

/***/ "./js/googlesitekit/datastore/ui/constants.js":
/*!****************************************************!*\
  !*** ./js/googlesitekit/datastore/ui/constants.js ***!
  \****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ACTIVE_CONTEXT_ID: () => (/* binding */ ACTIVE_CONTEXT_ID),
/* harmony export */   CORE_UI: () => (/* binding */ CORE_UI)
/* harmony export */ });
/**
 * `core/ui` data store: constants.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

const CORE_UI = 'core/ui';
const ACTIVE_CONTEXT_ID = 'activeContextID';

/***/ }),

/***/ "./js/googlesitekit/datastore/user/constants.js":
/*!******************************************************!*\
  !*** ./js/googlesitekit/datastore/user/constants.js ***!
  \******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   CORE_USER: () => (/* binding */ CORE_USER),
/* harmony export */   DISCONNECTED_REASON_CONNECTED_URL_MISMATCH: () => (/* binding */ DISCONNECTED_REASON_CONNECTED_URL_MISMATCH),
/* harmony export */   ERROR_CODE_ADBLOCKER_ACTIVE: () => (/* binding */ ERROR_CODE_ADBLOCKER_ACTIVE),
/* harmony export */   FORM_TEMPORARY_PERSIST_PERMISSION_ERROR: () => (/* binding */ FORM_TEMPORARY_PERSIST_PERMISSION_ERROR),
/* harmony export */   GLOBAL_SURVEYS_TIMEOUT_SLUG: () => (/* binding */ GLOBAL_SURVEYS_TIMEOUT_SLUG),
/* harmony export */   KM_ANALYTICS_ADSENSE_TOP_EARNING_CONTENT: () => (/* binding */ KM_ANALYTICS_ADSENSE_TOP_EARNING_CONTENT),
/* harmony export */   KM_ANALYTICS_ENGAGED_TRAFFIC_SOURCE: () => (/* binding */ KM_ANALYTICS_ENGAGED_TRAFFIC_SOURCE),
/* harmony export */   KM_ANALYTICS_LEAST_ENGAGING_PAGES: () => (/* binding */ KM_ANALYTICS_LEAST_ENGAGING_PAGES),
/* harmony export */   KM_ANALYTICS_MOST_ENGAGING_PAGES: () => (/* binding */ KM_ANALYTICS_MOST_ENGAGING_PAGES),
/* harmony export */   KM_ANALYTICS_NEW_VISITORS: () => (/* binding */ KM_ANALYTICS_NEW_VISITORS),
/* harmony export */   KM_ANALYTICS_PAGES_PER_VISIT: () => (/* binding */ KM_ANALYTICS_PAGES_PER_VISIT),
/* harmony export */   KM_ANALYTICS_POPULAR_AUTHORS: () => (/* binding */ KM_ANALYTICS_POPULAR_AUTHORS),
/* harmony export */   KM_ANALYTICS_POPULAR_CONTENT: () => (/* binding */ KM_ANALYTICS_POPULAR_CONTENT),
/* harmony export */   KM_ANALYTICS_POPULAR_PRODUCTS: () => (/* binding */ KM_ANALYTICS_POPULAR_PRODUCTS),
/* harmony export */   KM_ANALYTICS_RETURNING_VISITORS: () => (/* binding */ KM_ANALYTICS_RETURNING_VISITORS),
/* harmony export */   KM_ANALYTICS_TOP_CATEGORIES: () => (/* binding */ KM_ANALYTICS_TOP_CATEGORIES),
/* harmony export */   KM_ANALYTICS_TOP_CITIES: () => (/* binding */ KM_ANALYTICS_TOP_CITIES),
/* harmony export */   KM_ANALYTICS_TOP_CITIES_DRIVING_ADD_TO_CART: () => (/* binding */ KM_ANALYTICS_TOP_CITIES_DRIVING_ADD_TO_CART),
/* harmony export */   KM_ANALYTICS_TOP_CITIES_DRIVING_LEADS: () => (/* binding */ KM_ANALYTICS_TOP_CITIES_DRIVING_LEADS),
/* harmony export */   KM_ANALYTICS_TOP_CITIES_DRIVING_PURCHASES: () => (/* binding */ KM_ANALYTICS_TOP_CITIES_DRIVING_PURCHASES),
/* harmony export */   KM_ANALYTICS_TOP_CONVERTING_TRAFFIC_SOURCE: () => (/* binding */ KM_ANALYTICS_TOP_CONVERTING_TRAFFIC_SOURCE),
/* harmony export */   KM_ANALYTICS_TOP_COUNTRIES: () => (/* binding */ KM_ANALYTICS_TOP_COUNTRIES),
/* harmony export */   KM_ANALYTICS_TOP_DEVICE_DRIVING_PURCHASES: () => (/* binding */ KM_ANALYTICS_TOP_DEVICE_DRIVING_PURCHASES),
/* harmony export */   KM_ANALYTICS_TOP_PAGES_DRIVING_LEADS: () => (/* binding */ KM_ANALYTICS_TOP_PAGES_DRIVING_LEADS),
/* harmony export */   KM_ANALYTICS_TOP_RECENT_TRENDING_PAGES: () => (/* binding */ KM_ANALYTICS_TOP_RECENT_TRENDING_PAGES),
/* harmony export */   KM_ANALYTICS_TOP_RETURNING_VISITOR_PAGES: () => (/* binding */ KM_ANALYTICS_TOP_RETURNING_VISITOR_PAGES),
/* harmony export */   KM_ANALYTICS_TOP_TRAFFIC_SOURCE: () => (/* binding */ KM_ANALYTICS_TOP_TRAFFIC_SOURCE),
/* harmony export */   KM_ANALYTICS_TOP_TRAFFIC_SOURCE_DRIVING_ADD_TO_CART: () => (/* binding */ KM_ANALYTICS_TOP_TRAFFIC_SOURCE_DRIVING_ADD_TO_CART),
/* harmony export */   KM_ANALYTICS_TOP_TRAFFIC_SOURCE_DRIVING_LEADS: () => (/* binding */ KM_ANALYTICS_TOP_TRAFFIC_SOURCE_DRIVING_LEADS),
/* harmony export */   KM_ANALYTICS_TOP_TRAFFIC_SOURCE_DRIVING_PURCHASES: () => (/* binding */ KM_ANALYTICS_TOP_TRAFFIC_SOURCE_DRIVING_PURCHASES),
/* harmony export */   KM_ANALYTICS_VISITS_PER_VISITOR: () => (/* binding */ KM_ANALYTICS_VISITS_PER_VISITOR),
/* harmony export */   KM_ANALYTICS_VISIT_LENGTH: () => (/* binding */ KM_ANALYTICS_VISIT_LENGTH),
/* harmony export */   KM_SEARCH_CONSOLE_POPULAR_KEYWORDS: () => (/* binding */ KM_SEARCH_CONSOLE_POPULAR_KEYWORDS),
/* harmony export */   PERMISSION_AUTHENTICATE: () => (/* binding */ PERMISSION_AUTHENTICATE),
/* harmony export */   PERMISSION_DELEGATE_MODULE_SHARING_MANAGEMENT: () => (/* binding */ PERMISSION_DELEGATE_MODULE_SHARING_MANAGEMENT),
/* harmony export */   PERMISSION_MANAGE_MODULE_SHARING_OPTIONS: () => (/* binding */ PERMISSION_MANAGE_MODULE_SHARING_OPTIONS),
/* harmony export */   PERMISSION_MANAGE_OPTIONS: () => (/* binding */ PERMISSION_MANAGE_OPTIONS),
/* harmony export */   PERMISSION_READ_SHARED_MODULE_DATA: () => (/* binding */ PERMISSION_READ_SHARED_MODULE_DATA),
/* harmony export */   PERMISSION_SETUP: () => (/* binding */ PERMISSION_SETUP),
/* harmony export */   PERMISSION_UPDATE_PLUGINS: () => (/* binding */ PERMISSION_UPDATE_PLUGINS),
/* harmony export */   PERMISSION_VIEW_DASHBOARD: () => (/* binding */ PERMISSION_VIEW_DASHBOARD),
/* harmony export */   PERMISSION_VIEW_MODULE_DETAILS: () => (/* binding */ PERMISSION_VIEW_MODULE_DETAILS),
/* harmony export */   PERMISSION_VIEW_POSTS_INSIGHTS: () => (/* binding */ PERMISSION_VIEW_POSTS_INSIGHTS),
/* harmony export */   PERMISSION_VIEW_SHARED_DASHBOARD: () => (/* binding */ PERMISSION_VIEW_SHARED_DASHBOARD),
/* harmony export */   allKeyMetricsTileWidgets: () => (/* binding */ allKeyMetricsTileWidgets),
/* harmony export */   keyMetricsGA4Widgets: () => (/* binding */ keyMetricsGA4Widgets)
/* harmony export */ });
/**
 * `core/user` data store: constants.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

const CORE_USER = 'core/user';
const DISCONNECTED_REASON_CONNECTED_URL_MISMATCH = 'connected_url_mismatch';
const GLOBAL_SURVEYS_TIMEOUT_SLUG = '__global';
const FORM_TEMPORARY_PERSIST_PERMISSION_ERROR = 'temporary_persist_permission_error';
const ERROR_CODE_ADBLOCKER_ACTIVE = 'adblocker_active';

// Permissions list.
const PERMISSION_AUTHENTICATE = 'googlesitekit_authenticate';
const PERMISSION_SETUP = 'googlesitekit_setup';
const PERMISSION_VIEW_POSTS_INSIGHTS = 'googlesitekit_view_posts_insights';
const PERMISSION_VIEW_DASHBOARD = 'googlesitekit_view_dashboard';
const PERMISSION_VIEW_SHARED_DASHBOARD = 'googlesitekit_view_shared_dashboard';
const PERMISSION_VIEW_MODULE_DETAILS = 'googlesitekit_view_module_details';
const PERMISSION_MANAGE_OPTIONS = 'googlesitekit_manage_options';
const PERMISSION_READ_SHARED_MODULE_DATA = 'googlesitekit_read_shared_module_data';
const PERMISSION_MANAGE_MODULE_SHARING_OPTIONS = 'googlesitekit_manage_module_sharing_options';
const PERMISSION_DELEGATE_MODULE_SHARING_MANAGEMENT = 'googlesitekit_delegate_module_sharing_management';
const PERMISSION_UPDATE_PLUGINS = 'googlesitekit_update_plugins';

// Key Metrics Widgets
const KM_ANALYTICS_ADSENSE_TOP_EARNING_CONTENT = 'kmAnalyticsAdSenseTopEarningContent';
const KM_ANALYTICS_ENGAGED_TRAFFIC_SOURCE = 'kmAnalyticsEngagedTrafficSource';
const KM_ANALYTICS_LEAST_ENGAGING_PAGES = 'kmAnalyticsLeastEngagingPages';
const KM_ANALYTICS_NEW_VISITORS = 'kmAnalyticsNewVisitors';
const KM_ANALYTICS_POPULAR_AUTHORS = 'kmAnalyticsPopularAuthors';
const KM_ANALYTICS_POPULAR_CONTENT = 'kmAnalyticsPopularContent';
const KM_ANALYTICS_POPULAR_PRODUCTS = 'kmAnalyticsPopularProducts';
const KM_ANALYTICS_RETURNING_VISITORS = 'kmAnalyticsReturningVisitors';
const KM_ANALYTICS_TOP_CITIES = 'kmAnalyticsTopCities';
const KM_ANALYTICS_TOP_CITIES_DRIVING_LEADS = 'kmAnalyticsTopCitiesDrivingLeads';
const KM_ANALYTICS_TOP_CITIES_DRIVING_ADD_TO_CART = 'kmAnalyticsTopCitiesDrivingAddToCart';
const KM_ANALYTICS_TOP_CITIES_DRIVING_PURCHASES = 'kmAnalyticsTopCitiesDrivingPurchases';
const KM_ANALYTICS_TOP_DEVICE_DRIVING_PURCHASES = 'kmAnalyticsTopDeviceDrivingPurchases';
const KM_ANALYTICS_TOP_CONVERTING_TRAFFIC_SOURCE = 'kmAnalyticsTopConvertingTrafficSource';
const KM_ANALYTICS_TOP_COUNTRIES = 'kmAnalyticsTopCountries';
const KM_ANALYTICS_TOP_PAGES_DRIVING_LEADS = 'kmAnalyticsTopPagesDrivingLeads';
const KM_ANALYTICS_TOP_RECENT_TRENDING_PAGES = 'kmAnalyticsTopRecentTrendingPages';
const KM_ANALYTICS_TOP_TRAFFIC_SOURCE = 'kmAnalyticsTopTrafficSource';
const KM_ANALYTICS_TOP_TRAFFIC_SOURCE_DRIVING_ADD_TO_CART = 'kmAnalyticsTopTrafficSourceDrivingAddToCart';
const KM_ANALYTICS_TOP_TRAFFIC_SOURCE_DRIVING_LEADS = 'kmAnalyticsTopTrafficSourceDrivingLeads';
const KM_ANALYTICS_TOP_TRAFFIC_SOURCE_DRIVING_PURCHASES = 'kmAnalyticsTopTrafficSourceDrivingPurchases';
const KM_ANALYTICS_PAGES_PER_VISIT = 'kmAnalyticsPagesPerVisit';
const KM_ANALYTICS_VISIT_LENGTH = 'kmAnalyticsVisitLength';
const KM_ANALYTICS_TOP_RETURNING_VISITOR_PAGES = 'kmAnalyticsTopReturningVisitorPages';
const KM_SEARCH_CONSOLE_POPULAR_KEYWORDS = 'kmSearchConsolePopularKeywords';
const KM_ANALYTICS_VISITS_PER_VISITOR = 'kmAnalyticsVisitsPerVisitor';
const KM_ANALYTICS_MOST_ENGAGING_PAGES = 'kmAnalyticsMostEngagingPages';
const KM_ANALYTICS_TOP_CATEGORIES = 'kmAnalyticsTopCategories';
const keyMetricsGA4Widgets = [KM_ANALYTICS_ADSENSE_TOP_EARNING_CONTENT, KM_ANALYTICS_ENGAGED_TRAFFIC_SOURCE, KM_ANALYTICS_LEAST_ENGAGING_PAGES, KM_ANALYTICS_NEW_VISITORS, KM_ANALYTICS_POPULAR_AUTHORS, KM_ANALYTICS_POPULAR_CONTENT, KM_ANALYTICS_POPULAR_PRODUCTS, KM_ANALYTICS_RETURNING_VISITORS, KM_ANALYTICS_TOP_CATEGORIES, KM_ANALYTICS_TOP_CITIES, KM_ANALYTICS_TOP_CITIES_DRIVING_LEADS, KM_ANALYTICS_TOP_CITIES_DRIVING_ADD_TO_CART, KM_ANALYTICS_TOP_CITIES_DRIVING_PURCHASES, KM_ANALYTICS_TOP_DEVICE_DRIVING_PURCHASES, KM_ANALYTICS_TOP_CONVERTING_TRAFFIC_SOURCE, KM_ANALYTICS_TOP_COUNTRIES, KM_ANALYTICS_TOP_RECENT_TRENDING_PAGES, KM_ANALYTICS_TOP_TRAFFIC_SOURCE, KM_ANALYTICS_TOP_TRAFFIC_SOURCE_DRIVING_ADD_TO_CART, KM_ANALYTICS_PAGES_PER_VISIT, KM_ANALYTICS_VISIT_LENGTH, KM_ANALYTICS_TOP_RETURNING_VISITOR_PAGES, KM_ANALYTICS_VISITS_PER_VISITOR, KM_ANALYTICS_MOST_ENGAGING_PAGES, KM_ANALYTICS_TOP_CATEGORIES];
const allKeyMetricsTileWidgets = [...keyMetricsGA4Widgets, KM_SEARCH_CONSOLE_POPULAR_KEYWORDS];

/***/ }),

/***/ "./js/googlesitekit/modules/datastore/constants.js":
/*!*********************************************************!*\
  !*** ./js/googlesitekit/modules/datastore/constants.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   CORE_MODULES: () => (/* binding */ CORE_MODULES),
/* harmony export */   ERROR_CODE_INSUFFICIENT_MODULE_DEPENDENCIES: () => (/* binding */ ERROR_CODE_INSUFFICIENT_MODULE_DEPENDENCIES)
/* harmony export */ });
/**
 * `core/modules` data store: constants.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

const CORE_MODULES = 'core/modules';
const ERROR_CODE_INSUFFICIENT_MODULE_DEPENDENCIES = 'insufficient_module_dependencies';

/***/ }),

/***/ "./js/googlesitekit/notifications/components/Notification/ViewedStateObserver.js":
/*!***************************************************************************************!*\
  !*** ./js/googlesitekit/notifications/components/Notification/ViewedStateObserver.js ***!
  \***************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ ViewedStateObserver)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _js_googlesitekit_datastore_ui_constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/googlesitekit/datastore/ui/constants */ "./js/googlesitekit/datastore/ui/constants.js");
/* harmony import */ var _js_googlesitekit_notifications_datastore_constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/googlesitekit/notifications/datastore/constants */ "./js/googlesitekit/notifications/datastore/constants.js");
/* harmony import */ var _js_hooks_useLatestIntersection__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/hooks/useLatestIntersection */ "./js/hooks/useLatestIntersection.js");
/* harmony import */ var _js_googlesitekit_notifications_hooks_useHasBeenViewed__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/googlesitekit/notifications/hooks/useHasBeenViewed */ "./js/googlesitekit/notifications/hooks/useHasBeenViewed.js");
/**
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */





function ViewedStateObserver({
  id,
  observeRef,
  threshold
}) {
  const intersectionEntry = (0,_js_hooks_useLatestIntersection__WEBPACK_IMPORTED_MODULE_3__["default"])(observeRef, {
    threshold
  });
  const {
    setValue
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useDispatch)(_js_googlesitekit_datastore_ui_constants__WEBPACK_IMPORTED_MODULE_1__.CORE_UI);
  const {
    markNotificationSeen
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useDispatch)(_js_googlesitekit_notifications_datastore_constants__WEBPACK_IMPORTED_MODULE_2__.CORE_NOTIFICATIONS);
  const isInView = !!intersectionEntry?.isIntersecting;
  const viewed = (0,_js_googlesitekit_notifications_hooks_useHasBeenViewed__WEBPACK_IMPORTED_MODULE_4__.useHasBeenViewed)(id);
  const timeoutRef = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_5__.useRef)();
  function clearExistingTimeout() {
    if (timeoutRef.current) {
      clearTimeout(timeoutRef.current);
    }
  }
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_5__.useEffect)(() => {
    // If notification is not viewed yet and is in view, start the timer.
    if (!viewed && isInView) {
      clearExistingTimeout();

      // Set a new timeout for 3 seconds.
      timeoutRef.current = setTimeout(() => {
        // Only mark as viewed if still in view after 3 seconds.
        if (intersectionEntry?.isIntersecting) {
          setValue(_js_googlesitekit_notifications_hooks_useHasBeenViewed__WEBPACK_IMPORTED_MODULE_4__.useHasBeenViewed.getKey(id), true);
          markNotificationSeen(id);
        }
      }, 3000);
    } else if (!isInView && timeoutRef.current) {
      clearExistingTimeout();
    }

    // Cleanup function to clear timeout on unmount or when dependencies change.
    return () => {
      clearExistingTimeout();
    };
  }, [viewed, isInView, setValue, markNotificationSeen, id, intersectionEntry]);
  return null;
}
ViewedStateObserver.propTypes = {
  id: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().string),
  observeRef: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().object),
  threshold: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().number)
};

/***/ }),

/***/ "./js/googlesitekit/notifications/components/Notification/index.js":
/*!*************************************************************************!*\
  !*** ./js/googlesitekit/notifications/components/Notification/index.js ***!
  \*************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Notification)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _ViewedStateObserver__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./ViewedStateObserver */ "./js/googlesitekit/notifications/components/Notification/ViewedStateObserver.js");
/* harmony import */ var _js_googlesitekit_notifications_hooks_useHasBeenViewed__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/googlesitekit/notifications/hooks/useHasBeenViewed */ "./js/googlesitekit/notifications/hooks/useHasBeenViewed.js");
/* harmony import */ var _js_googlesitekit_notifications_hooks_useNotificationEvents__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/googlesitekit/notifications/hooks/useNotificationEvents */ "./js/googlesitekit/notifications/hooks/useNotificationEvents.js");
/* harmony import */ var _js_googlesitekit_notifications_datastore_constants__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/googlesitekit/notifications/datastore/constants */ "./js/googlesitekit/notifications/datastore/constants.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */






function Notification({
  id,
  className,
  gaTrackingEventArgs,
  children,
  onView
}) {
  const ref = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.useRef)();
  const viewed = (0,_js_googlesitekit_notifications_hooks_useHasBeenViewed__WEBPACK_IMPORTED_MODULE_2__.useHasBeenViewed)(id);
  const trackEvents = (0,_js_googlesitekit_notifications_hooks_useNotificationEvents__WEBPACK_IMPORTED_MODULE_3__["default"])(id, gaTrackingEventArgs?.category, {
    viewAction: gaTrackingEventArgs?.viewAction
  });
  const [isViewedOnce, setIsViewedOnce] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.useState)(false);
  const viewedDates = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useSelect)(select => select(_js_googlesitekit_notifications_datastore_constants__WEBPACK_IMPORTED_MODULE_4__.CORE_NOTIFICATIONS).getNotificationSeenDates(id));
  const {
    dismissNotification
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useDispatch)(_js_googlesitekit_notifications_datastore_constants__WEBPACK_IMPORTED_MODULE_4__.CORE_NOTIFICATIONS);

  // Track view once and check if notification should be dismissed.
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.useEffect)(() => {
    if (!isViewedOnce && viewed) {
      trackEvents.view(gaTrackingEventArgs?.label, gaTrackingEventArgs?.value);
      onView?.();
      setIsViewedOnce(true);
    }

    // If the notification has been viewed on 3 distinct days, dismiss it permanently for the next view.
    if (viewedDates?.length >= 3) {
      dismissNotification(id, {
        skipHidingFromQueue: true
      });
    }
  }, [viewed, trackEvents, isViewedOnce, gaTrackingEventArgs, onView, viewedDates, dismissNotification, id]);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)("section", {
    id: id,
    ref: ref,
    className: className,
    children: [children, !viewed && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_ViewedStateObserver__WEBPACK_IMPORTED_MODULE_1__["default"], {
      id: id,
      observeRef: ref,
      threshold: 0.5
    })]
  });
}
Notification.propTypes = {
  id: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().string),
  className: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().string),
  gaTrackingEventArgs: prop_types__WEBPACK_IMPORTED_MODULE_7___default().shape({
    category: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().string),
    viewAction: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().string),
    label: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().string),
    value: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().string)
  }),
  children: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().node),
  onView: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().func)
};

/***/ }),

/***/ "./js/googlesitekit/notifications/components/layout/BannerNotification.js":
/*!********************************************************************************!*\
  !*** ./js/googlesitekit/notifications/components/layout/BannerNotification.js ***!
  \********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   TYPES: () => (/* binding */ TYPES),
/* harmony export */   "default": () => (/* binding */ BannerNotification)
/* harmony export */ });
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_12___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_12__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _js_googlesitekit_notifications_datastore_constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/googlesitekit/notifications/datastore/constants */ "./js/googlesitekit/notifications/datastore/constants.js");
/* harmony import */ var _js_googlesitekit_notifications_hooks_useNotificationEvents__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/googlesitekit/notifications/hooks/useNotificationEvents */ "./js/googlesitekit/notifications/hooks/useNotificationEvents.js");
/* harmony import */ var _js_components_Banner__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/components/Banner */ "./js/components/Banner/index.js");
/* harmony import */ var _js_components_Banner_LearnMoreLink__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/components/Banner/LearnMoreLink */ "./js/components/Banner/LearnMoreLink.js");
/* harmony import */ var _js_components_Banner_CTAButton__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @/js/components/Banner/CTAButton */ "./js/components/Banner/CTAButton.js");
/* harmony import */ var _js_components_Banner_DismissButton__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @/js/components/Banner/DismissButton */ "./js/components/Banner/DismissButton.js");
/* harmony import */ var _js_material_components__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @/js/material-components */ "./js/material-components/index.js");
/* harmony import */ var _svg_graphics_banner_warning_svg_url__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @/svg/graphics/banner-warning.svg?url */ "./svg/graphics/banner-warning.svg?url");
/* harmony import */ var _svg_graphics_banner_error_svg_url__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @/svg/graphics/banner-error.svg?url */ "./svg/graphics/banner-error.svg?url");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * BannerNotification layout component.
 *
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * Internal dependencies
 */











const TYPES = {
  INFO: 'info',
  ERROR: 'error',
  WARNING: 'warning'
};
function BannerNotification({
  notificationID,
  type = TYPES.INFO,
  learnMoreLink,
  dismissButton,
  ctaButton,
  gaTrackingEventArgs,
  ...props
}) {
  const trackEvents = (0,_js_googlesitekit_notifications_hooks_useNotificationEvents__WEBPACK_IMPORTED_MODULE_3__["default"])(notificationID, gaTrackingEventArgs?.category);
  const {
    dismissNotification
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useDispatch)(_js_googlesitekit_notifications_datastore_constants__WEBPACK_IMPORTED_MODULE_2__.CORE_NOTIFICATIONS);
  async function handleDismissWithTrackEvent(event) {
    await dismissButton?.onClick?.(event);
    trackEvents.dismiss(gaTrackingEventArgs?.label, gaTrackingEventArgs?.value);
    dismissNotification(notificationID, {
      ...dismissButton?.dismissOptions
    });
  }
  async function handleCTAClickWithTrackEvent(event) {
    trackEvents.confirm(gaTrackingEventArgs?.label, gaTrackingEventArgs?.value);
    await ctaButton?.onClick?.(event);
    if (ctaButton?.dismissOnClick) {
      dismissNotification(notificationID, {
        ...ctaButton?.dismissOptions
      });
    }
  }
  async function handleLearnMoreClickWithTrackEvent(event) {
    trackEvents.clickLearnMore(gaTrackingEventArgs?.label, gaTrackingEventArgs?.value);
    await learnMoreLink?.onClick?.(event);
  }
  let SVGData = props?.svg;
  if (!SVGData && type !== TYPES.INFO) {
    SVGData = {
      desktop: undefined,
      mobile: undefined,
      verticalPosition: 'center'
    };
    if (type === TYPES.WARNING) {
      SVGData.desktop = _svg_graphics_banner_warning_svg_url__WEBPACK_IMPORTED_MODULE_9__["default"];
    }
    if (type === TYPES.ERROR) {
      SVGData.desktop = _svg_graphics_banner_error_svg_url__WEBPACK_IMPORTED_MODULE_10__["default"];
    }
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("div", {
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-banner-notification', `googlesitekit-banner-notification--${type}`),
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_js_material_components__WEBPACK_IMPORTED_MODULE_8__.Grid, {
      className: "googlesitekit-page-content",
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_js_material_components__WEBPACK_IMPORTED_MODULE_8__.Row, {
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_js_material_components__WEBPACK_IMPORTED_MODULE_8__.Cell, {
          size: 12,
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_js_components_Banner__WEBPACK_IMPORTED_MODULE_4__["default"], {
            learnMoreLink: learnMoreLink && {
              ...learnMoreLink,
              onClick: handleLearnMoreClickWithTrackEvent
            },
            dismissButton: dismissButton && {
              ...dismissButton,
              onClick: handleDismissWithTrackEvent
            },
            ctaButton: ctaButton && {
              ...ctaButton,
              onClick: handleCTAClickWithTrackEvent
            },
            svg: SVGData,
            ...props
          })
        })
      })
    })
  });
}
BannerNotification.propTypes = {
  notificationID: (prop_types__WEBPACK_IMPORTED_MODULE_12___default().string).isRequired,
  type: prop_types__WEBPACK_IMPORTED_MODULE_12___default().oneOf(Object.values(TYPES)),
  titleIcon: (prop_types__WEBPACK_IMPORTED_MODULE_12___default().node),
  title: (prop_types__WEBPACK_IMPORTED_MODULE_12___default().string),
  description: prop_types__WEBPACK_IMPORTED_MODULE_12___default().oneOfType([(prop_types__WEBPACK_IMPORTED_MODULE_12___default().string), (prop_types__WEBPACK_IMPORTED_MODULE_12___default().node)]),
  learnMoreLink: prop_types__WEBPACK_IMPORTED_MODULE_12___default().shape(_js_components_Banner_LearnMoreLink__WEBPACK_IMPORTED_MODULE_5__["default"].propTypes),
  dismissButton: prop_types__WEBPACK_IMPORTED_MODULE_12___default().shape(_js_components_Banner_DismissButton__WEBPACK_IMPORTED_MODULE_7__["default"].propTypes),
  ctaButton: prop_types__WEBPACK_IMPORTED_MODULE_12___default().shape(_js_components_Banner_CTAButton__WEBPACK_IMPORTED_MODULE_6__["default"].propTypes),
  gaTrackingEventArgs: prop_types__WEBPACK_IMPORTED_MODULE_12___default().shape({
    category: (prop_types__WEBPACK_IMPORTED_MODULE_12___default().string),
    label: (prop_types__WEBPACK_IMPORTED_MODULE_12___default().string),
    value: (prop_types__WEBPACK_IMPORTED_MODULE_12___default().number)
  })
};

/***/ }),

/***/ "./js/googlesitekit/notifications/components/layout/NoticeNotification.js":
/*!********************************************************************************!*\
  !*** ./js/googlesitekit/notifications/components/layout/NoticeNotification.js ***!
  \********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ NoticeNotification)
/* harmony export */ });
/* harmony import */ var _js_components_Notice__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @/js/components/Notice */ "./js/components/Notice/index.js");
/* harmony import */ var _js_googlesitekit_notifications_hooks_useNotificationEvents__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/googlesitekit/notifications/hooks/useNotificationEvents */ "./js/googlesitekit/notifications/hooks/useNotificationEvents.js");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _js_googlesitekit_notifications_datastore_constants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/googlesitekit/notifications/datastore/constants */ "./js/googlesitekit/notifications/datastore/constants.js");
/* harmony import */ var _js_material_components__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/material-components */ "./js/material-components/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Internal dependencies
 */







function NoticeNotification({
  notificationID,
  children,
  dismissButton,
  ctaButton,
  gaTrackingEventArgs,
  ...props
}) {
  const trackEvents = (0,_js_googlesitekit_notifications_hooks_useNotificationEvents__WEBPACK_IMPORTED_MODULE_1__["default"])(notificationID);
  const {
    dismissNotification
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.useDispatch)(_js_googlesitekit_notifications_datastore_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_NOTIFICATIONS);
  async function handleDismissWithTrackEvent(event) {
    await dismissButton?.onClick?.(event);
    trackEvents.dismiss(gaTrackingEventArgs?.label, gaTrackingEventArgs?.value);
    dismissNotification(notificationID, {
      ...(dismissButton?.dismissOptions || {})
    });
  }
  async function handleCTAClickWithTrackEvent(event) {
    await ctaButton?.onClick?.(event);
    trackEvents.confirm(gaTrackingEventArgs?.label, gaTrackingEventArgs?.value);
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_js_material_components__WEBPACK_IMPORTED_MODULE_4__.Grid, {
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_js_material_components__WEBPACK_IMPORTED_MODULE_4__.Row, {
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_js_material_components__WEBPACK_IMPORTED_MODULE_4__.Cell, {
        size: 12,
        alignMiddle: true,
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_js_components_Notice__WEBPACK_IMPORTED_MODULE_0__["default"], {
          dismissButton: {
            ...dismissButton,
            onClick: handleDismissWithTrackEvent
          },
          ctaButton: {
            ...ctaButton,
            onClick: handleCTAClickWithTrackEvent
          },
          ...props,
          children: children
        })
      })
    })
  });
}
NoticeNotification.propTypes = {
  notificationID: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().string).isRequired,
  children: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().node),
  dismissButton: prop_types__WEBPACK_IMPORTED_MODULE_6___default().oneOfType([(prop_types__WEBPACK_IMPORTED_MODULE_6___default().bool), (prop_types__WEBPACK_IMPORTED_MODULE_6___default().object)]),
  ctaButton: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().object),
  gaTrackingEventArgs: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().object)
};

/***/ }),

/***/ "./js/googlesitekit/notifications/components/layout/OverlayNotification.js":
/*!*********************************************************************************!*\
  !*** ./js/googlesitekit/notifications/components/layout/OverlayNotification.js ***!
  \*********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ OverlayNotification)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _js_googlesitekit_notifications_datastore_constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/googlesitekit/notifications/datastore/constants */ "./js/googlesitekit/notifications/datastore/constants.js");
/* harmony import */ var _js_googlesitekit_notifications_hooks_useNotificationEvents__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/googlesitekit/notifications/hooks/useNotificationEvents */ "./js/googlesitekit/notifications/hooks/useNotificationEvents.js");
/* harmony import */ var _js_components_OverlayCard__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/components/OverlayCard */ "./js/components/OverlayCard/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * OverlayNotification layout component.
 *
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * Internal dependencies
 */





function OverlayNotification({
  notificationID,
  ctaButton,
  dismissButton,
  gaTrackingEventArgs,
  ...props
}) {
  const trackEvents = (0,_js_googlesitekit_notifications_hooks_useNotificationEvents__WEBPACK_IMPORTED_MODULE_2__["default"])(notificationID, gaTrackingEventArgs?.category, {
    confirmAction: gaTrackingEventArgs?.confirmAction,
    dismissAction: gaTrackingEventArgs?.dismissAction
  });
  const {
    dismissNotification
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useDispatch)(_js_googlesitekit_notifications_datastore_constants__WEBPACK_IMPORTED_MODULE_1__.CORE_NOTIFICATIONS);
  async function handleDismissWithTrackEvent(event) {
    await dismissButton?.onClick?.(event);
    trackEvents.dismiss(gaTrackingEventArgs?.label, gaTrackingEventArgs?.value);
    dismissNotification(notificationID, {
      ...dismissButton.dismissOptions
    });
  }
  async function handleCTAClickWithTrackEvent(event) {
    trackEvents.confirm(gaTrackingEventArgs?.label, gaTrackingEventArgs?.value);
    await ctaButton?.onClick?.(event);
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(_js_components_OverlayCard__WEBPACK_IMPORTED_MODULE_3__["default"], {
    ctaButton: {
      ...ctaButton,
      onClick: handleCTAClickWithTrackEvent
    },
    dismissButton: {
      ...dismissButton,
      onClick: handleDismissWithTrackEvent
    },
    ...props,
    visible: true
  });
}
OverlayNotification.propTypes = {
  notificationID: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().string),
  ctaButton: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().object),
  dismissButton: prop_types__WEBPACK_IMPORTED_MODULE_5___default().oneOfType([(prop_types__WEBPACK_IMPORTED_MODULE_5___default().object), (prop_types__WEBPACK_IMPORTED_MODULE_5___default().bool)])
};

/***/ }),

/***/ "./js/googlesitekit/notifications/components/layout/SetupCTA.js":
/*!**********************************************************************!*\
  !*** ./js/googlesitekit/notifications/components/layout/SetupCTA.js ***!
  \**********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ SetupCTA)
/* harmony export */ });
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_12___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_12__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _js_googlesitekit_notifications_datastore_constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/googlesitekit/notifications/datastore/constants */ "./js/googlesitekit/notifications/datastore/constants.js");
/* harmony import */ var _js_googlesitekit_notifications_hooks_useNotificationEvents__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/googlesitekit/notifications/hooks/useNotificationEvents */ "./js/googlesitekit/notifications/hooks/useNotificationEvents.js");
/* harmony import */ var _js_components_Banner__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/components/Banner */ "./js/components/Banner/index.js");
/* harmony import */ var _js_components_Banner_LearnMoreLink__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/components/Banner/LearnMoreLink */ "./js/components/Banner/LearnMoreLink.js");
/* harmony import */ var _js_components_Banner_CTAButton__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @/js/components/Banner/CTAButton */ "./js/components/Banner/CTAButton.js");
/* harmony import */ var _js_components_Banner_DismissButton__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @/js/components/Banner/DismissButton */ "./js/components/Banner/DismissButton.js");
/* harmony import */ var _js_material_components__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @/js/material-components */ "./js/material-components/index.js");
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! googlesitekit-components */ "googlesitekit-components");
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_components__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * SetupCTA layout component.
 *
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */










function SetupCTA({
  notificationID,
  title,
  description,
  errorText,
  helpText,
  learnMoreLink,
  dismissButton,
  ctaButton,
  svg,
  footer,
  gaTrackingEventArgs,
  waitingProgress,
  ...props
}) {
  const trackEvents = (0,_js_googlesitekit_notifications_hooks_useNotificationEvents__WEBPACK_IMPORTED_MODULE_3__["default"])(notificationID, gaTrackingEventArgs?.category);
  const {
    dismissNotification
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useDispatch)(_js_googlesitekit_notifications_datastore_constants__WEBPACK_IMPORTED_MODULE_2__.CORE_NOTIFICATIONS);
  async function handleDismissWithTrackEvent(event) {
    await dismissButton?.onClick?.(event);
    trackEvents.dismiss(gaTrackingEventArgs?.label, gaTrackingEventArgs?.value);
    dismissNotification(notificationID, {
      ...dismissButton?.dismissOptions
    });
  }
  async function handleCTAClickWithTrackEvent(event) {
    trackEvents.confirm(gaTrackingEventArgs?.label, gaTrackingEventArgs?.value);
    await ctaButton?.onClick?.(event);
    if (ctaButton?.dismissOnClick) {
      dismissNotification(notificationID, {
        ...ctaButton?.dismissOptions
      });
    }
  }
  async function handleLearnMoreClickWithTrackEvent(event) {
    trackEvents.clickLearnMore(gaTrackingEventArgs?.label, gaTrackingEventArgs?.value);
    await learnMoreLink?.onClick?.(event);
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsxs)(_wordpress_element__WEBPACK_IMPORTED_MODULE_11__.Fragment, {
    children: [!!waitingProgress && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_9__.ProgressBar, {
      className: "googlesitekit-banner__progress-bar",
      ...waitingProgress
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)("div", {
      className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-widget-context', {
        'googlesitekit-widget-context--with-progress-bar': !!waitingProgress
      }),
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)(_js_material_components__WEBPACK_IMPORTED_MODULE_8__.Grid, {
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)(_js_material_components__WEBPACK_IMPORTED_MODULE_8__.Row, {
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)(_js_material_components__WEBPACK_IMPORTED_MODULE_8__.Cell, {
            size: 12,
            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)(_js_components_Banner__WEBPACK_IMPORTED_MODULE_4__["default"], {
              className: "googlesitekit-banner--setup-cta",
              title: title,
              description: description,
              errorText: errorText,
              helpText: helpText,
              learnMoreLink: learnMoreLink && {
                ...learnMoreLink,
                onClick: handleLearnMoreClickWithTrackEvent
              },
              dismissButton: dismissButton && {
                ...dismissButton,
                onClick: handleDismissWithTrackEvent
              },
              ctaButton: ctaButton && {
                ...ctaButton,
                onClick: handleCTAClickWithTrackEvent
              },
              svg: svg,
              footer: footer,
              ...props
            })
          })
        })
      })
    })]
  });
}
SetupCTA.propTypes = {
  notificationID: (prop_types__WEBPACK_IMPORTED_MODULE_12___default().string),
  title: (prop_types__WEBPACK_IMPORTED_MODULE_12___default().string),
  description: prop_types__WEBPACK_IMPORTED_MODULE_12___default().oneOfType([(prop_types__WEBPACK_IMPORTED_MODULE_12___default().string), (prop_types__WEBPACK_IMPORTED_MODULE_12___default().node)]),
  errorText: (prop_types__WEBPACK_IMPORTED_MODULE_12___default().string),
  helpText: (prop_types__WEBPACK_IMPORTED_MODULE_12___default().string),
  learnMoreLink: prop_types__WEBPACK_IMPORTED_MODULE_12___default().shape(_js_components_Banner_LearnMoreLink__WEBPACK_IMPORTED_MODULE_5__["default"].propTypes),
  dismissButton: prop_types__WEBPACK_IMPORTED_MODULE_12___default().shape(_js_components_Banner_DismissButton__WEBPACK_IMPORTED_MODULE_7__["default"].propTypes),
  ctaButton: prop_types__WEBPACK_IMPORTED_MODULE_12___default().shape(_js_components_Banner_CTAButton__WEBPACK_IMPORTED_MODULE_6__["default"].propTypes),
  svg: prop_types__WEBPACK_IMPORTED_MODULE_12___default().shape({
    desktop: (prop_types__WEBPACK_IMPORTED_MODULE_12___default().elementType),
    mobile: (prop_types__WEBPACK_IMPORTED_MODULE_12___default().elementType),
    verticalPosition: prop_types__WEBPACK_IMPORTED_MODULE_12___default().oneOf(['top', 'center', 'bottom'])
  }),
  footer: (prop_types__WEBPACK_IMPORTED_MODULE_12___default().node),
  gaTrackingEventArgs: prop_types__WEBPACK_IMPORTED_MODULE_12___default().shape({
    category: (prop_types__WEBPACK_IMPORTED_MODULE_12___default().string),
    label: (prop_types__WEBPACK_IMPORTED_MODULE_12___default().string),
    value: (prop_types__WEBPACK_IMPORTED_MODULE_12___default().number)
  }),
  waitingProgress: prop_types__WEBPACK_IMPORTED_MODULE_12___default().shape(googlesitekit_components__WEBPACK_IMPORTED_MODULE_9__.ProgressBar.propTypes)
};

/***/ }),

/***/ "./js/googlesitekit/notifications/constants.js":
/*!*****************************************************!*\
  !*** ./js/googlesitekit/notifications/constants.js ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   GTG_HEALTH_CHECK_WARNING_NOTIFICATION_ID: () => (/* binding */ GTG_HEALTH_CHECK_WARNING_NOTIFICATION_ID),
/* harmony export */   GTG_SETUP_CTA_BANNER_NOTIFICATION: () => (/* binding */ GTG_SETUP_CTA_BANNER_NOTIFICATION),
/* harmony export */   NOTIFICATION_AREAS: () => (/* binding */ NOTIFICATION_AREAS),
/* harmony export */   NOTIFICATION_GROUPS: () => (/* binding */ NOTIFICATION_GROUPS),
/* harmony export */   PRIORITY: () => (/* binding */ PRIORITY)
/* harmony export */ });
/**
 * Notifications API constants.
 *
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

const GTG_HEALTH_CHECK_WARNING_NOTIFICATION_ID = 'warning-notification-gtg';
const GTG_SETUP_CTA_BANNER_NOTIFICATION = 'gtg-setup-cta';
const PRIORITY = {
  ERROR_HIGH: 30,
  ERROR_LOW: 60,
  WARNING: 100,
  INFO: 150,
  SETUP_CTA_HIGH: 150,
  SETUP_CTA_LOW: 200
};
const NOTIFICATION_AREAS = {
  HEADER: 'notification-area-header',
  DASHBOARD_TOP: 'notification-area-dashboard-top',
  OVERLAYS: 'notification-area-overlays'
};
const NOTIFICATION_GROUPS = {
  DEFAULT: 'default',
  SETUP_CTAS: 'setup-ctas'
};

/***/ }),

/***/ "./js/googlesitekit/notifications/datastore/constants.js":
/*!***************************************************************!*\
  !*** ./js/googlesitekit/notifications/datastore/constants.js ***!
  \***************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   CORE_NOTIFICATIONS: () => (/* binding */ CORE_NOTIFICATIONS),
/* harmony export */   NOTIFICATION_VIEW_CONTEXTS: () => (/* binding */ NOTIFICATION_VIEW_CONTEXTS)
/* harmony export */ });
/* harmony import */ var _js_googlesitekit_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @/js/googlesitekit/constants */ "./js/googlesitekit/constants.js");
/**
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


const CORE_NOTIFICATIONS = 'core/notifications';
const NOTIFICATION_VIEW_CONTEXTS = [_js_googlesitekit_constants__WEBPACK_IMPORTED_MODULE_0__.VIEW_CONTEXT_SPLASH, _js_googlesitekit_constants__WEBPACK_IMPORTED_MODULE_0__.VIEW_CONTEXT_MAIN_DASHBOARD, _js_googlesitekit_constants__WEBPACK_IMPORTED_MODULE_0__.VIEW_CONTEXT_ENTITY_DASHBOARD, _js_googlesitekit_constants__WEBPACK_IMPORTED_MODULE_0__.VIEW_CONTEXT_MAIN_DASHBOARD_VIEW_ONLY, _js_googlesitekit_constants__WEBPACK_IMPORTED_MODULE_0__.VIEW_CONTEXT_ENTITY_DASHBOARD_VIEW_ONLY];

/***/ }),

/***/ "./js/googlesitekit/notifications/hooks/useHasBeenViewed.js":
/*!******************************************************************!*\
  !*** ./js/googlesitekit/notifications/hooks/useHasBeenViewed.js ***!
  \******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   useHasBeenViewed: () => (/* binding */ useHasBeenViewed)
/* harmony export */ });
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _js_googlesitekit_datastore_ui_constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/googlesitekit/datastore/ui/constants */ "./js/googlesitekit/datastore/ui/constants.js");
/**
 * `useHasBeenViewed` hook.
 *
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Internal dependencies
 */


function getKey(id) {
  return `notification/${id}/viewed`;
}
function useHasBeenViewed(id) {
  return (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useSelect)(select => !!select(_js_googlesitekit_datastore_ui_constants__WEBPACK_IMPORTED_MODULE_1__.CORE_UI).getValue(getKey(id)), [id]);
}
useHasBeenViewed.getKey = getKey;

/***/ }),

/***/ "./js/googlesitekit/notifications/hooks/useNotificationEvents.js":
/*!***********************************************************************!*\
  !*** ./js/googlesitekit/notifications/hooks/useNotificationEvents.js ***!
  \***********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ useNotificationEvents)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @/js/hooks/useViewContext */ "./js/hooks/useViewContext.js");
/* harmony import */ var _js_util__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/util */ "./js/util/index.js");
/**
 * `useNotificationEvents` hook.
 *
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */


function useNotificationEvents(id, category, {
  viewAction = 'view_notification',
  confirmAction = 'confirm_notification',
  dismissAction = 'dismiss_notification',
  clickLearnMoreAction = 'click_learn_more_link'
} = {}) {
  const viewContext = (0,_js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_0__["default"])();
  const eventCategory = category !== null && category !== void 0 ? category : `${viewContext}_${id}`;
  const view = (0,_wordpress_element