"use strict";
(globalThis["__googlesitekit_webpackJsonp"] = globalThis["__googlesitekit_webpackJsonp"] || []).push([["googlesitekit-datastore-site"],{

/***/ "./js/api-fetch-shim.js":
/*!******************************!*\
  !*** ./js/api-fetch-shim.js ***!
  \******************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   __esModule: () => (/* reexport safe */ _wordpress_api_fetch_non_shim__WEBPACK_IMPORTED_MODULE_0__.__esModule),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_api_fetch_non_shim__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/api-fetch__non-shim */ "../node_modules/@wordpress/api-fetch/build/index.js");
/* harmony import */ var _googlesitekit_api_middleware_preloading_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./googlesitekit/api/middleware/preloading.js */ "./js/googlesitekit/api/middleware/preloading.js");
/**
 * API Fetch Shim.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */

const {
  nonce,
  nonceEndpoint,
  preloadedData,
  rootURL
} = __webpack_require__.g._googlesitekitAPIFetchData || {};
_wordpress_api_fetch_non_shim__WEBPACK_IMPORTED_MODULE_0__["default"].nonceEndpoint = nonceEndpoint;
_wordpress_api_fetch_non_shim__WEBPACK_IMPORTED_MODULE_0__["default"].nonceMiddleware = _wordpress_api_fetch_non_shim__WEBPACK_IMPORTED_MODULE_0__["default"].createNonceMiddleware(nonce);
_wordpress_api_fetch_non_shim__WEBPACK_IMPORTED_MODULE_0__["default"].rootURLMiddleware = _wordpress_api_fetch_non_shim__WEBPACK_IMPORTED_MODULE_0__["default"].createRootURLMiddleware(rootURL);
_wordpress_api_fetch_non_shim__WEBPACK_IMPORTED_MODULE_0__["default"].preloadingMiddleware = (0,_googlesitekit_api_middleware_preloading_js__WEBPACK_IMPORTED_MODULE_1__["default"])(preloadedData);
_wordpress_api_fetch_non_shim__WEBPACK_IMPORTED_MODULE_0__["default"].use(_wordpress_api_fetch_non_shim__WEBPACK_IMPORTED_MODULE_0__["default"].nonceMiddleware);
_wordpress_api_fetch_non_shim__WEBPACK_IMPORTED_MODULE_0__["default"].use(_wordpress_api_fetch_non_shim__WEBPACK_IMPORTED_MODULE_0__["default"].mediaUploadMiddleware);
_wordpress_api_fetch_non_shim__WEBPACK_IMPORTED_MODULE_0__["default"].use(_wordpress_api_fetch_non_shim__WEBPACK_IMPORTED_MODULE_0__["default"].rootURLMiddleware);
_wordpress_api_fetch_non_shim__WEBPACK_IMPORTED_MODULE_0__["default"].use(_wordpress_api_fetch_non_shim__WEBPACK_IMPORTED_MODULE_0__["default"].preloadingMiddleware);

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_wordpress_api_fetch_non_shim__WEBPACK_IMPORTED_MODULE_0__["default"]);

/***/ }),

/***/ "./js/components/ChangeArrow.js":
/*!**************************************!*\
  !*** ./js/components/ChangeArrow.js ***!
  \**************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * External dependencies
 */



function ChangeArrow({
  direction,
  invertColor,
  width,
  height
}) {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("svg", {
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-change-arrow', `googlesitekit-change-arrow--${direction}`, {
      'googlesitekit-change-arrow--inverted-color': invertColor
    }),
    width: width,
    height: height,
    viewBox: "0 0 10 10",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg",
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("path", {
      d: "M5.625 10L5.625 2.375L9.125 5.875L10 5L5 -1.76555e-07L-2.7055e-07 5L0.875 5.875L4.375 2.375L4.375 10L5.625 10Z",
      fill: "currentColor"
    })
  });
}
ChangeArrow.propTypes = {
  direction: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().string),
  invertColor: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().bool),
  width: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().number),
  height: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().number)
};
ChangeArrow.defaultProps = {
  direction: 'up',
  invertColor: false,
  width: 9,
  height: 9
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ChangeArrow);

/***/ }),

/***/ "./js/features/index.js":
/*!******************************!*\
  !*** ./js/features/index.js ***!
  \******************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   enabledFeatures: () => (/* binding */ enabledFeatures),
/* harmony export */   isFeatureEnabled: () => (/* binding */ isFeatureEnabled)
/* harmony export */ });
/**
 * Feature flags.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

const enabledFeatures = new Set(__webpack_require__.g?._googlesitekitBaseData?.enabledFeatures || []);

/**
 * Returns true if a feature is enabled; false otherwise.
 *
 * @since 1.25.0
 * @since 1.33.0 Changed _enabledFeatures argument to be a `Set` instead of `Array`.
 *
 * @param {string} feature            The name of the feature to check.
 * @param {Set}    [_enabledFeatures] Optional. The set of enabled features. Uses `enabledFeatures` set by the server in a global JS variable, by default.
 * @return {boolean} `true` if a feature is enabled; `false` otherwise.
 */
function isFeatureEnabled(feature, _enabledFeatures = enabledFeatures) {
  if (!(_enabledFeatures instanceof Set)) {
    return false;
  }
  return _enabledFeatures.has(feature);
}

/***/ }),

/***/ "./js/googlesitekit-datastore-site.js":
/*!********************************************!*\
  !*** ./js/googlesitekit-datastore-site.js ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _googlesitekit_datastore_site__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./googlesitekit/datastore/site */ "./js/googlesitekit/datastore/site/index.js");
/**
 * Entrypoint for the "core/site" data store.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Internal dependencies
 */


(0,_googlesitekit_datastore_site__WEBPACK_IMPORTED_MODULE_1__.registerStore)((googlesitekit_data__WEBPACK_IMPORTED_MODULE_0___default()));

/***/ }),

/***/ "./js/googlesitekit/api/cache.js":
/*!***************************************!*\
  !*** ./js/googlesitekit/api/cache.js ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   STORAGE_KEY_PREFIX: () => (/* binding */ STORAGE_KEY_PREFIX),
/* harmony export */   STORAGE_KEY_PREFIX_ROOT: () => (/* binding */ STORAGE_KEY_PREFIX_ROOT),
/* harmony export */   clearCache: () => (/* binding */ clearCache),
/* harmony export */   deleteItem: () => (/* binding */ deleteItem),
/* harmony export */   getItem: () => (/* binding */ getItem),
/* harmony export */   getKeys: () => (/* binding */ getKeys),
/* harmony export */   getStorage: () => (/* binding */ getStorage),
/* harmony export */   isStorageAvailable: () => (/* binding */ isStorageAvailable),
/* harmony export */   resetDefaultStorageOrder: () => (/* binding */ resetDefaultStorageOrder),
/* harmony export */   setItem: () => (/* binding */ setItem),
/* harmony export */   setSelectedStorageBackend: () => (/* binding */ setSelectedStorageBackend),
/* harmony export */   setStorageOrder: () => (/* binding */ setStorageOrder)
/* harmony export */ });
/* harmony import */ var _js_util__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @/js/util */ "./js/util/index.js");
/**
 * Caching functions and cache management for API requests.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Internal dependencies
 */


/**
 * Prefix used for all Site Kit keys.
 *
 * Anything not using this prefix should not be touched by this library.
 *
 * @since 1.96.0
 * @private
 */
const STORAGE_KEY_PREFIX_ROOT = 'googlesitekit_';

/**
 * Prefix used for all Site Kit keys for the current Site Kit version.
 *
 * Anything not using this key should not be touched by this library.
 *
 * @since 1.5.0
 * @since 1.92.0 Updated to include a user, session, and blog-specific hash.
 * @since 1.96.0 Updated to make use of the new STORAGE_KEY_PREFIX_ROOT constant.
 * @private
 */
const STORAGE_KEY_PREFIX = `${STORAGE_KEY_PREFIX_ROOT}${"1.164.0"}_${__webpack_require__.g._googlesitekitBaseData.storagePrefix}_`;
const defaultOrder = ['sessionStorage', 'localStorage'];
let storageBackend;
let storageOrder = [...defaultOrder];

/**
 * Overrides the storage backend.
 *
 * Largely used for tests. Should not be used directly.
 *
 * @since 1.5.0
 * @private
 *
 * @param {*} backend Backend to set for the cache.
 */
function setSelectedStorageBackend(backend) {
  storageBackend = backend;
}

/**
 * Overrides the priority of storage mechanisms.
 *
 * Largely used for tests. Implicitly resets the selected storage backend,
 * causing `_getStorage` to re-run its checks for the best available
 * storage backend.
 *
 * @since 1.5.0
 * @private
 *
 * @param {Array} order Ordered array of storage backends to use.
 */
function setStorageOrder(order) {
  storageOrder = [...order];
  setSelectedStorageBackend(undefined);
}

/**
 * Resets the storage mechanism order.
 *
 * Largely used for tests. Implicitly resets the selected storage backend,
 * causing `_getStorage` to re-run its checks for the best available
 * storage backend.
 *
 * @since 1.5.0
 * @private
 */
function resetDefaultStorageOrder() {
  storageOrder = [...defaultOrder];
  setSelectedStorageBackend(undefined);
}

/**
 * Detects whether browser storage is both supported and available.
 *
 * @since 1.5.0
 * @private
 *
 * @param {string} type Browser storage to test. Should be one of `localStorage` or `sessionStorage`.
 * @return {boolean} True if the given storage is available, false otherwise.
 */
// eslint-disable-next-line require-await
async function isStorageAvailable(type) {
  const storage = __webpack_require__.g[type];
  if (!storage) {
    return false;
  }
  try {
    const x = '__storage_test__';
    storage.setItem(x, x);
    storage.removeItem(x);
    return true;
  } catch (e) {
    return e instanceof DOMException && (
    // everything except Firefox
    22 === e.code ||
    // Firefox
    1014 === e.code ||
    // test name field too, because code might not be present
    // everything except Firefox
    'QuotaExceededError' === e.name ||
    // Firefox
    'NS_ERROR_DOM_QUOTA_REACHED' === e.name) &&
    // acknowledge QuotaExceededError only if there's something already stored
    0 !== storage.length;
  }
}

/**
 * Gets the storage object to use.
 *
 * @since 1.5.0
 * @private
 *
 * @return {Storage|null} A storage mechanism (`localStorage` or `sessionStorage`) if available; otherwise returns `null`.
 */
async function getStorage() {
  if (storageBackend !== undefined) {
    return storageBackend;
  }

  // Only run the logic to determine the storage object once.
  for (const backend of storageOrder) {
    if (storageBackend) {
      continue;
    }
    if (await isStorageAvailable(backend)) {
      storageBackend = __webpack_require__.g[backend];
    }
  }
  if (storageBackend === undefined) {
    storageBackend = null;
  }
  return storageBackend;
}

/**
 * Gets cached data.
 *
 * Get cached data from the persistent storage cache.
 *
 * @since 1.5.0
 *
 * @param {string} key Name of cache key.
 * @return {Promise} A promise returned, containing an object with the cached value (if found) and whether or not there was a cache hit.
 */
async function getItem(key) {
  const storage = await getStorage();
  if (storage) {
    const cachedData = storage.getItem(`${STORAGE_KEY_PREFIX}${key}`);
    if (cachedData) {
      const parsedData = JSON.parse(cachedData);
      const {
        timestamp,
        ttl,
        value,
        isError
      } = parsedData;

      // Ensure a timestamp is found, otherwise this isn't a valid cache hit.
      // (We don't check for a truthy `value`, because it could be legitimately
      // false-y if `0`, `null`, etc.)
      if (timestamp && (!ttl ||
      // Ensure the cached data isn't too old.
      // The cache dates shouldn't rely on reference
      // dates for cache expiration. This is a case
      // where we actually want to rely on
      // the _actual_ date/time the data was set.
      Math.round(Date.now() / 1000) - timestamp < ttl) // eslint-disable-line sitekit/no-direct-date
      ) {
        return {
          cacheHit: true,
          value,
          isError
        };
      }
    }
  }
  return {
    cacheHit: false,
    value: undefined
  };
}

/**
 * Sets cached data using a key.
 *
 * Save data to the relevant local storage mechanism, if available.
 * By default, data is saved with a one hour (60 minute) TTL.
 *
 * @since 1.5.0
 *
 * @param {string}  key              Name of cache key.
 * @param {*}       value            Value to store in the cache.
 * @param {Object}  args             Optional object containing ttl, timestamp and isError keys.
 * @param {number}  [args.ttl]       Optional. Validity of the cached item in seconds.
 * @param {number}  [args.timestamp] Optional. Timestamp when the cached item was created.
 * @param {boolean} [args.isError]   Optional. Whether the cached item is an error.
 * @return {Promise} A promise: resolves to `true` if the value was saved; `false` if not (usually because no storage method was available).
 */
async function setItem(key, value, {
  ttl = _js_util__WEBPACK_IMPORTED_MODULE_0__.HOUR_IN_SECONDS,
  // Cached times should rely on real times, not the reference date,
  // so the cache timeouts are consistent even when changing
  // the reference dates when developing/testing.
  timestamp = Math.round(Date.now() / 1000),
  // eslint-disable-line sitekit/no-direct-date
  isError = false
} = {}) {
  const storage = await getStorage();
  if (storage) {
    try {
      storage.setItem(`${STORAGE_KEY_PREFIX}${key}`, JSON.stringify({
        timestamp,
        ttl,
        value,
        isError
      }));
      return true;
    } catch (error) {
      __webpack_require__.g.console.warn('Encountered an unexpected storage error:', error);
      return false;
    }
  }
  return false;
}

/**
 * Removes cached data by key.
 *
 * Remove one piece of cached data from the persistent storage cache, by key.
 *
 * @since 1.5.0
 *
 * @param {string} key Name of cache key.
 * @return {Promise} A promise: resolves to `true` if the value was deleted; `false` if not (usually because no storage method was available).
 */
async function deleteItem(key) {
  const storage = await getStorage();
  if (storage) {
    try {
      const fullKey = key.startsWith(STORAGE_KEY_PREFIX_ROOT) ? key : `${STORAGE_KEY_PREFIX}${key}`;
      storage.removeItem(fullKey);
      return true;
    } catch (error) {
      __webpack_require__.g.console.warn('Encountered an unexpected storage error:', error);
      return false;
    }
  }
  return false;
}

/**
 * Gets all cache keys created by Site Kit.
 *
 * @since 1.5.0
 *
 * @return {Promise} A promise: resolves to an array of all keys.
 */
async function getKeys() {
  const storage = await getStorage();
  if (storage) {
    try {
      const keys = [];
      for (let i = 0; i < storage.length; i++) {
        const itemKey = storage.key(i);
        if (itemKey.indexOf(STORAGE_KEY_PREFIX_ROOT) === 0) {
          keys.push(itemKey);
        }
      }
      return keys;
    } catch (error) {
      __webpack_require__.g.console.warn('Encountered an unexpected storage error:', error);
      return [];
    }
  }
  return [];
}

/**
 * Removes the entire cache created by Site Kit.
 *
 * @since 1.5.0
 *
 * @return {Promise} A promise: resolves to `true` if the cache was cleared; `false` if there was an error.
 */
async function clearCache() {
  const storage = await getStorage();
  if (storage) {
    const keys = await getKeys();
    for (const key of keys) {
      await deleteItem(key);
    }
    return true;
  }
  return false;
}

/***/ }),

/***/ "./js/googlesitekit/api/middleware/preloading.js":
/*!*******************************************************!*\
  !*** ./js/googlesitekit/api/middleware/preloading.js ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_api_fetch_build_middlewares_preloading__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/api-fetch/build/middlewares/preloading */ "../node_modules/@wordpress/api-fetch/build/middlewares/preloading.js");
/**
 * Custom preloading middleware.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies.
 */


/**
 * Creates a preloading middleware.
 *
 * Based on preloadMiddleware from from @wordpress/api-fetch, this middle is a single-use per-endpoint and provides cached
 * data for the first request only and any subsequent requests reach the server.
 *
 * @since 1.13.0
 *
 * @param {Object} preloadedData Preloaded data paths.
 * @return {Function} Function.
 */
function createPreloadingMiddleware(preloadedData) {
  const cache = Object.keys(preloadedData).reduce((result, path) => {
    result[(0,_wordpress_api_fetch_build_middlewares_preloading__WEBPACK_IMPORTED_MODULE_0__.getStablePath)(path)] = preloadedData[path];
    return result;
  }, {});
  let cacheHasExpired = false;
  return (options, next) => {
    if (cacheHasExpired) {
      return next(options);
    }
    setTimeout(() => {
      cacheHasExpired = true;
    }, 3000);
    const {
      parse = true
    } = options;
    const uri = options.path;
    if (typeof options.path === 'string') {
      const method = options.method?.toUpperCase() || 'GET';
      const path = (0,_wordpress_api_fetch_build_middlewares_preloading__WEBPACK_IMPORTED_MODULE_0__.getStablePath)(uri);
      if (parse && 'GET' === method && cache[path]) {
        const result = Promise.resolve(cache[path].body);
        delete cache[path];
        return result;
      } else if ('OPTIONS' === method && cache[method] && cache[method][path]) {
        const result = Promise.resolve(cache[method][path]);
        delete cache[method][path];
        return result;
      }
    }
    return next(options);
  };
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (createPreloadingMiddleware);

/***/ }),

/***/ "./js/googlesitekit/data/create-error-store.js":
/*!*****************************************************!*\
  !*** ./js/googlesitekit/data/create-error-store.js ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   actions: () => (/* binding */ actions),
/* harmony export */   createErrorStore: () => (/* binding */ createErrorStore),
/* harmony export */   generateErrorKey: () => (/* binding */ generateErrorKey)
/* harmony export */ });
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @wordpress/data */ "../node_modules/@wordpress/data/build-module/factory.js");
/* harmony import */ var invariant__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! invariant */ "../node_modules/invariant/browser.js");
/* harmony import */ var invariant__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(invariant__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var md5__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! md5 */ "../node_modules/md5/md5.js");
/* harmony import */ var md5__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(md5__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _js_util__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/util */ "./js/util/index.js");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__);
/**
 * API function to create fetch store.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */


/**
 * External dependencies
 */


const RECEIVE_ERROR = 'RECEIVE_ERROR';
const CLEAR_ERROR = 'CLEAR_ERROR';
const CLEAR_ERRORS = 'CLEAR_ERRORS';

/**
 * Internal dependencies
 */


function generateErrorKey(baseName, args) {
  if (args && Array.isArray(args)) {
    const stringifiedArgs = args.map(item => {
      return 'object' === typeof item ? (0,_js_util__WEBPACK_IMPORTED_MODULE_2__.stringifyObject)(item) : item;
    });
    return `${baseName}::${md5__WEBPACK_IMPORTED_MODULE_1___default()(JSON.stringify(stringifiedArgs))}`;
  }
  return baseName;
}
const actions = {
  receiveError(error, baseName, args = []) {
    invariant__WEBPACK_IMPORTED_MODULE_0___default()(error, 'error is required.');
    invariant__WEBPACK_IMPORTED_MODULE_0___default()(baseName, 'baseName is required.');
    invariant__WEBPACK_IMPORTED_MODULE_0___default()(args && Array.isArray(args), 'args must be an array.');
    return {
      type: RECEIVE_ERROR,
      payload: {
        error,
        baseName,
        args
      }
    };
  },
  clearError(baseName, args = []) {
    invariant__WEBPACK_IMPORTED_MODULE_0___default()(baseName, 'baseName is required.');
    invariant__WEBPACK_IMPORTED_MODULE_0___default()(args && Array.isArray(args), 'args must be an array.');
    return {
      type: CLEAR_ERROR,
      payload: {
        baseName,
        args
      }
    };
  },
  clearErrors(baseName) {
    return {
      type: CLEAR_ERRORS,
      payload: {
        baseName
      }
    };
  }
};
function createErrorStore(storeName) {
  invariant__WEBPACK_IMPORTED_MODULE_0___default()(storeName, 'storeName must be defined.');
  const initialState = {
    errors: {},
    errorArgs: {}
  };
  const reducer = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__.createReducer)((state, {
    type,
    payload
  }) => {
    switch (type) {
      case RECEIVE_ERROR:
        {
          const {
            baseName,
            args,
            error
          } = payload;
          const key = generateErrorKey(baseName, args);
          state.errors = state.errors || {};
          state.errorArgs = state.errorArgs || {};
          state.errors[key] = error;
          state.errorArgs[key] = args;
          break;
        }
      case CLEAR_ERROR:
        {
          const {
            baseName,
            args
          } = payload;
          const key = generateErrorKey(baseName, args);
          state.errors = state.errors || {};
          state.errorArgs = state.errorArgs || {};
          delete state.errors[key];
          delete state.errorArgs[key];
          break;
        }
      case CLEAR_ERRORS:
        {
          const {
            baseName
          } = payload;
          if (baseName) {
            state.errors = state.errors || {};
            state.errorArgs = state.errorArgs || {};
            for (const key in state.errors) {
              if (key === baseName || key.startsWith(`${baseName}::`)) {
                delete state.errors[key];
                delete state.errorArgs[key];
              }
            }
          } else {
            state.errors = {};
            state.errorArgs = {};
          }
          break;
        }
    }
  });
  const controls = {};
  const resolvers = {};
  const selectors = {
    /**
     * Retrieves the error object from state.
     *
     * Error object has the format:
     *
     * ```
     * {
     *   code: <String>,
     *   message: <String>,
     *   data: <Object>
     * }
     * ```
     *
     * @since 1.15.0
     *
     * @param {Object}      state        Data store's state.
     * @param {string}      selectorName Selector name.
     * @param {Array.<any>} [args]       Arguments passed to selector (default `[]`).
     * @return {(Object|undefined)} Error object if exists, otherwise undefined.
     */
    getErrorForSelector(state, selectorName, args = []) {
      invariant__WEBPACK_IMPORTED_MODULE_0___default()(selectorName, 'selectorName is required.');
      return selectors.getError(state, selectorName, args);
    },
    /**
     * Retrieves the error object from state.
     *
     *```
     * {
     *   code: <String>,
     *   message: <String>,
     *   data: <Object>
     * }
     * ```
     *
     * @since 1.15.0
     *
     * @param {Object}      state      Data store's state.
     * @param {string}      actionName Action name.
     * @param {Array.<any>} [args]     Arguments passed to action (default `[]`).
     * @return {(Object|undefined)} Error object if exists, otherwise undefined.
     */
    getErrorForAction(state, actionName, args = []) {
      invariant__WEBPACK_IMPORTED_MODULE_0___default()(actionName, 'actionName is required.');
      return selectors.getError(state, actionName, args);
    },
    /**
     * Retrieves the error object from state.
     *
     *```
     * {
     *   code: <String>,
     *   message: <String>,
     *   data: <Object>
     * }
     * ```
     *
     * @since 1.15.0
     * @private
     *
     * @param {Object}      state      Data store's state.
     * @param {string}      [baseName] Selector or action name.
     * @param {Array.<any>} [args]     Arguments array.
     * @return {(Object|undefined)} Error object if exists, otherwise undefined.
     */
    getError(state, baseName, args) {
      const {
        errors
      } = state;
      invariant__WEBPACK_IMPORTED_MODULE_0___default()(baseName, 'baseName is required.');
      return errors[generateErrorKey(baseName, args)];
    },
    /**
     * Gets a list of all unique errors.
     *
     * @since 1.19.0
     *
     * @param {Object} state Data store's state.
     * @return {Object[]} Unique set of errors.
     */
    getErrors(state) {
      const errorsSet = new Set(Object.values(state.errors));
      return Array.from(errorsSet);
    },
    /**
     * Gets the meta-data for a given error object, or null if the error is not found.
     *
     * Returns meta-data in the format:
     *
     * ```
     *	{
     *		baseName: <string>,
     *		args: <Array>
     *	}
     * ```
     *
     * @since 1.84.0
     *
     * @param {Object} state Data store's state.
     * @param {Object} error Error object.
     * @return {Object|null} Meta-data for the given error object, or null if the error is not found.
     */
    getMetaDataForError(state, error) {
      const key = Object.keys(state.errors).find(errorKey => state.errors[errorKey] === error);
      if (key) {
        const baseName = key.substring(0, key.indexOf('::'));
        return {
          baseName,
          args: state.errorArgs[key]
        };
      }
      return null;
    },
    /**
     * Gets the selector data for a given error object, or null if no selector data is available.
     *
     * Returns selector data in the format:
     *
     * ```
     *	{
     *		storeName: <string>,
     *		name: <string>,
     *		args: <Array>
     *	}
     * ```
     *
     * @since 1.87.0
     *
     * @param {Object} state Data store's state.
     * @param {Object} error Error object.
     * @return {Object|null} Selector data for the given error object, or null if no selector data is available.
     */
    getSelectorDataForError: (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_4__.createRegistrySelector)(select => function (state, error) {
      const metaData = select(storeName).getMetaDataForError(error);
      if (metaData) {
        const {
          baseName: name,
          args
        } = metaData;
        const isSelector = !!select(storeName)[name];
        if (isSelector) {
          return {
            storeName,
            name,
            args
          };
        }
      }
      return null;
    }),
    /**
     * Determines whether the datastore has errors or not.
     *
     * @since 1.15.0
     *
     * @param {Object} state Data store's state.
     * @return {boolean} TRUE if the datastore has errors, otherwise FALSE.
     */
    hasErrors(state) {
      return selectors.getErrors(state).length > 0;
    }
  };
  return {
    initialState,
    actions,
    controls,
    reducer,
    resolvers,
    selectors
  };
}

/***/ }),

/***/ "./js/googlesitekit/data/create-fetch-store.js":
/*!*****************************************************!*\
  !*** ./js/googlesitekit/data/create-fetch-store.js ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   createFetchStore: () => (/* binding */ createFetchStore)
/* harmony export */ });
/* harmony import */ var invariant__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! invariant */ "../node_modules/invariant/browser.js");
/* harmony import */ var invariant__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(invariant__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! lodash */ "../node_modules/lodash/lodash.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _create_error_store__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./create-error-store */ "./js/googlesitekit/data/create-error-store.js");
/* harmony import */ var _transform_case__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./transform-case */ "./js/googlesitekit/data/transform-case.js");
/* harmony import */ var _js_util__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/util */ "./js/util/index.js");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_5__);
/**
 * API function to create fetch store.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * Internal dependencies
 */




function defaultReducerCallback(state) {
  return state;
}
function defaultArgsToParams() {
  return {};
}
function defaultValidateParams() {}

// Get access to error store action creators.
// If the parent store doesn't include the error store,
// yielded error actions will be a no-op.
const {
  clearError,
  receiveError
} = _create_error_store__WEBPACK_IMPORTED_MODULE_2__.actions;

/**
 * Creates a store object implementing the necessary infrastructure for a
 * single fetch action.
 *
 * This function returns a partial store object with the following:
 * * action creators to fetch and to receive the data
 * * control to issue the API request
 * * reducer to set API request flag and receive the response
 * * selector to check whether the API request is in progress via a flag
 *
 * The names of the pieces are based on the baseName provided.
 * For example, if baseName is 'saveSettings':
 * * The fetch action creator is called 'fetchSaveSettings'.
 * * The receive action creator is called 'receiveSaveSettings'.
 * * The fetching selector is called 'isFetchingSaveSettings'.
 *
 * All parts of the returned store objects should be considered internal. A
 * public action or selector should be implemented to actually call the
 * fetch action included in the returned store object.
 *
 * For example, if the fetch store is intended for an API-based
 * action 'storeMySetting':
 * * The basename passed should be 'storeMySetting'.
 * * The action 'storeMySetting' should call 'fetchStoreMySetting'.
 *
 * Or, if the fetch store is intended for an API-based selector
 * 'getSomeData':
 * * The baseName passed should be 'getSomeData'.
 * * The resolver for 'getSomeData' should call 'fetchGetSomeData'.
 *
 * @since 1.10.0
 * @private
 *
 * @param {Object}   args                   Arguments for creating the fetch store.
 * @param {string}   args.baseName          The base name to use for all the created infrastructure.
 * @param {Function} args.controlCallback   Callback function to issue the API request. Will be used inside the
 *                                          control. The function receives a params object based on argsToParams,
 *                                          i.e. the respective values passed to the action.
 * @param {Function} [args.reducerCallback] Optional. Callback function to modify state based on the API response.
 *                                          Will be used inside the reducer. The function receives the store's state
 *                                          object as first parameter, the API response as second parameter, and the
 *                                          params object for the request (see above) as third parameter. If not
 *                                          provided, the default will return the unmodified state.
 * @param {Function} [args.argsToParams]    Optional. Function that reduces the given list of arguments
 *                                          into a object of key/value parameters, with the argument names used as keys.
 *                                          If not provided, the default function will return an empty object,
 *                                          essentially indicating that no arguments are supported/required.
 * @param {Function} [args.validateParams]  Optional. Function that validates the given parameters object created by `argsToParams`.
 *                                          Any invalid parameters should cause a respective error to be thrown.
 * @return {Object} Partial store object with properties 'actions', 'controls', 'reducer', 'resolvers', and 'selectors'.
 */
function createFetchStore({
  baseName,
  controlCallback,
  reducerCallback = defaultReducerCallback,
  argsToParams = defaultArgsToParams,
  validateParams = defaultValidateParams
}) {
  invariant__WEBPACK_IMPORTED_MODULE_0___default()(baseName, 'baseName is required.');
  invariant__WEBPACK_IMPORTED_MODULE_0___default()('function' === typeof controlCallback, 'controlCallback is required and must be a function.');
  invariant__WEBPACK_IMPORTED_MODULE_0___default()('function' === typeof reducerCallback, 'reducerCallback must be a function.');
  invariant__WEBPACK_IMPORTED_MODULE_0___default()('function' === typeof argsToParams, 'argsToParams must be a function.');
  invariant__WEBPACK_IMPORTED_MODULE_0___default()('function' === typeof validateParams, 'validateParams must be a function.');

  // If validating the result of argsToParams without any arguments does not result in an error, we
  // know params is okay to be empty.
  let requiresParams;
  try {
    validateParams(argsToParams());
    requiresParams = false;
  } catch (error) {
    requiresParams = true;
  }
  const pascalCaseBaseName = (0,_transform_case__WEBPACK_IMPORTED_MODULE_3__.camelCaseToPascalCase)(baseName);
  const constantBaseName = (0,_transform_case__WEBPACK_IMPORTED_MODULE_3__.camelCaseToConstantCase)(baseName);
  const FETCH = `FETCH_${constantBaseName}`;
  const START_FETCH = `START_${FETCH}`;
  const FINISH_FETCH = `FINISH_${FETCH}`;
  const CATCH_FETCH = `CATCH_${FETCH}`;
  const RECEIVE = `RECEIVE_${constantBaseName}`;
  const fetchCreator = `fetch${pascalCaseBaseName}`;
  const receiveCreator = `receive${pascalCaseBaseName}`;
  const isFetching = `isFetching${pascalCaseBaseName}`;
  const initialState = {
    [isFetching]: {}
  };
  function* fetchGenerator(params, args) {
    let response;
    let error;
    yield {
      payload: {
        params
      },
      type: START_FETCH
    };
    yield clearError(baseName, args);
    try {
      response = yield {
        payload: {
          params
        },
        type: FETCH
      };
      yield actions[receiveCreator](response, params);
      yield {
        payload: {
          params
        },
        type: FINISH_FETCH
      };
    } catch (e) {
      error = e;
      yield receiveError(error, baseName, args);
      yield {
        payload: {
          params
        },
        type: CATCH_FETCH
      };
    }
    return {
      response,
      error
    };
  }
  const actions = {
    [fetchCreator](...args) {
      const params = argsToParams(...args);
      // In order for params validation to throw an error as expected,
      // this function cannot be a generator.
      validateParams(params);

      // The normal fetch action generator is invoked as the return here
      // to preserve asynchronous behavior without registering another action creator.
      return fetchGenerator(params, args);
    },
    [receiveCreator](response, params) {
      invariant__WEBPACK_IMPORTED_MODULE_0___default()(response !== undefined, 'response is required.');
      if (requiresParams) {
        invariant__WEBPACK_IMPORTED_MODULE_0___default()((0,lodash__WEBPACK_IMPORTED_MODULE_1__.isPlainObject)(params), 'params is required.');
        validateParams(params);
      } else {
        params = {};
      }
      return {
        payload: {
          response,
          params
        },
        type: RECEIVE
      };
    }
  };
  const controls = {
    [FETCH]: ({
      payload
    }) => {
      return controlCallback(payload.params);
    }
  };
  const reducer = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_5__.createReducer)((state, {
    type,
    payload
  }) => {
    switch (type) {
      case START_FETCH:
        {
          const {
            params
          } = payload;
          state[isFetching] = state[isFetching] || {};
          state[isFetching][(0,_js_util__WEBPACK_IMPORTED_MODULE_4__.stringifyObject)(params)] = true;
          return state;
        }
      case RECEIVE:
        {
          const {
            response,
            params
          } = payload;
          return reducerCallback(state, response, params);
        }
      case FINISH_FETCH:
        {
          const {
            params
          } = payload;
          state[isFetching] = state[isFetching] || {};
          state[isFetching][(0,_js_util__WEBPACK_IMPORTED_MODULE_4__.stringifyObject)(params)] = false;
          return state;
        }
      case CATCH_FETCH:
        {
          const {
            params
          } = payload;
          state[isFetching] = state[isFetching] || {};
          state[isFetching][(0,_js_util__WEBPACK_IMPORTED_MODULE_4__.stringifyObject)(params)] = false;
          return state;
        }
      default:
        return state;
    }
  });
  const selectors = {
    [isFetching]: (state, ...args) => {
      if (state[isFetching] === undefined) {
        return false;
      }
      let params;
      try {
        params = argsToParams(...args);
        validateParams(params);
      } catch (err) {
        // If parameters are invalid, fail silently here. It likely is
        // because some dependency selector is still resolving.
        return false;
      }
      return !!state[isFetching][(0,_js_util__WEBPACK_IMPORTED_MODULE_4__.stringifyObject)(params)];
    }
  };
  return {
    initialState,
    actions,
    controls,
    reducer,
    resolvers: {},
    selectors
  };
}

/***/ }),

/***/ "./js/googlesitekit/data/create-notifications-store.js":
/*!*************************************************************!*\
  !*** ./js/googlesitekit/data/create-notifications-store.js ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   createNotificationsStore: () => (/* binding */ createNotificationsStore)
/* harmony export */ });
/* harmony import */ var invariant__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! invariant */ "../node_modules/invariant/browser.js");
/* harmony import */ var invariant__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(invariant__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var googlesitekit_api__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-api */ "googlesitekit-api");
/* harmony import */ var googlesitekit_api__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_api__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _create_fetch_store__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./create-fetch-store */ "./js/googlesitekit/data/create-fetch-store.js");
/**
 * Provides API functions to create a datastore for notifications.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * Internal dependencies
 */




/**
 * Creates a store object that includes actions and selectors for managing notifications.
 *
 * The three required parameters hook up the store to the respective REST API endpoint.
 *
 * @since 1.6.0
 * @private
 *
 * @param {string}  type              The data to access. One of 'core' or 'modules'.
 * @param {string}  identifier        The data identifier, eg. a module slug like search-console.
 * @param {string}  datapoint         The endpoint to request data from, e.g. 'notifications'.
 * @param {Object}  options           Optional. Options to consider for the store.
 * @param {boolean} options.server    Enable server notifications. `true` by default.
 * @param {number}  options.storeName Store name to use. Default is '{type}/{identifier}'.
 * @return {Object} The notifications store object, with additional `STORE_NAME` and
 *                  `initialState` properties.
 */
function createNotificationsStore(type, identifier, datapoint, {
  server = true,
  storeName = undefined
} = {}) {
  invariant__WEBPACK_IMPORTED_MODULE_0___default()(type, 'type is required.');
  invariant__WEBPACK_IMPORTED_MODULE_0___default()(identifier, 'identifier is required.');
  invariant__WEBPACK_IMPORTED_MODULE_0___default()(datapoint, 'datapoint is required.');
  const STORE_NAME = storeName || `${type}/${identifier}`;
  const initialState = {
    serverNotifications: server ? undefined : {}
  };
  const fetchGetNotificationsStore = (0,_create_fetch_store__WEBPACK_IMPORTED_MODULE_3__.createFetchStore)({
    baseName: 'getNotifications',
    controlCallback: () => {
      return (0,googlesitekit_api__WEBPACK_IMPORTED_MODULE_1__.get)(type, identifier, datapoint);
    },
    reducerCallback: (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.createReducer)((state, notifications) => {
      state.serverNotifications = notifications.reduce((acc, notification) => {
        return {
          ...acc,
          [notification.id]: notification
        };
      }, {});
    })
  });
  const actions = {};
  const controls = {};

  // eslint-disable-next-line no-shadow
  function reducer(state = initialState, {
    type
  }) {
    switch (type) {
      default:
        {
          return state;
        }
    }
  }
  const resolvers = {
    *getNotifications() {
      const registry = yield googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.commonActions.getRegistry();
      const notifications = registry.select(STORE_NAME).getNotifications();
      if (!notifications) {
        yield fetchGetNotificationsStore.actions.fetchGetNotifications();
      }
    }
  };

  // If server notifications are disabled, we should remove the getNotifications
  // resolver. If we set it as `undefined` we'll encounter issues with an `undefined`
  // resolver, because @wordpress/data will still try to register the resolver because
  // it sees a key. And this is nicer than a no-op resolver.
  if (!server) {
    delete resolvers.getNotifications;
  }
  const selectors = {
    /**
     * Gets the current notifications.
     *
     * Returns `undefined` if notifications are not available/loaded.
     *
     * @since 1.6.0
     *
     * @param {Object} state Data store's state.
     * @return {(Array|undefined)} Current list of notifications.
     */
    getNotifications(state) {
      const {
        serverNotifications
      } = state;

      // If there are no client notifications and the server notifications
      // haven't loaded yet, return `undefined` (the value of
      // `serverNotifications` here) to signify to anything using this
      // selector that notifications have not loaded yet.
      if ('undefined' === typeof serverNotifications) {
        return serverNotifications;
      }

      // If there are any notifications from either the client or server,
      // we should return them, even if the server notifications haven't
      // finished loading yet.
      return Object.values({
        ...(serverNotifications || {})
      });
    }
  };
  const store = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.combineStores)(fetchGetNotificationsStore, {
    initialState,
    actions,
    controls,
    reducer,
    resolvers,
    selectors
  });
  return {
    ...store,
    STORE_NAME
  };
}

/***/ }),

/***/ "./js/googlesitekit/data/create-snapshot-store.js":
/*!********************************************************!*\
  !*** ./js/googlesitekit/data/create-snapshot-store.js ***!
  \********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   createSnapshotStore: () => (/* binding */ createSnapshotStore),
/* harmony export */   getStoresWithSnapshots: () => (/* binding */ getStoresWithSnapshots),
/* harmony export */   restoreAllSnapshots: () => (/* binding */ restoreAllSnapshots),
/* harmony export */   snapshotAllStores: () => (/* binding */ snapshotAllStores)
/* harmony export */ });
/* harmony import */ var invariant__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! invariant */ "../node_modules/invariant/browser.js");
/* harmony import */ var invariant__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(invariant__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! lodash */ "../node_modules/lodash/lodash.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _js_googlesitekit_api_cache__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/googlesitekit/api/cache */ "./js/googlesitekit/api/cache.js");
/* harmony import */ var _js_util__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/util */ "./js/util/index.js");
/**
 * Provides a datastore for snapshotting and restoring state.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * Internal dependencies
 */




// Actions
const CREATE_SNAPSHOT = 'CREATE_SNAPSHOT';
const DELETE_SNAPSHOT = 'DELETE_SNAPSHOT';
const RESTORE_SNAPSHOT = 'RESTORE_SNAPSHOT';
const SET_STATE_FROM_SNAPSHOT = 'SET_STATE_FROM_SNAPSHOT';

/**
 * Creates a store object that includes actions and controls for restoring/creating state snapshots.
 *
 * @since 1.9.0
 * @since 1.163.0 Added the ability to pick specific parts of the state to save in the snapshot.
 * @private
 *
 * @param {string}          storeName                The name of the store to snapshot in the cache.
 * @param {Object}          [options]                Optional configuration object.
 * @param {string|string[]} [options.keysToSnapshot] Property path(s) to pick from state when creating snapshots.
 * @return {Object} The snapshot store object.
 */
function createSnapshotStore(storeName, {
  keysToSnapshot
} = {}) {
  invariant__WEBPACK_IMPORTED_MODULE_0___default()(storeName, 'storeName is required to create a snapshot store.');
  const initialState = {};
  const actions = {
    /**
     * Deletes a snapshot of state for a storeName, using our cache API.
     *
     * @since 1.9.0
     * @private
     *
     * @return {boolean} Cache deletion response.
     */
    *deleteSnapshot() {
      const cacheResult = yield {
        payload: {},
        type: DELETE_SNAPSHOT
      };
      return cacheResult;
    },
    /**
     * Restores a snapshot of state for a storeName, if available, using our cache API.
     *
     * @since 1.9.0
     * @private
     *
     * @param {Object}  [options]                   Options object.
     * @param {boolean} [options.clearAfterRestore] Whether or not to delete snapshot after restore. Default: true.
     * @return {boolean} Cache restoration response.
     */
    *restoreSnapshot(options = {}) {
      const {
        clearAfterRestore = true
      } = options;
      const {
        cacheHit,
        value
      } = yield {
        payload: {},
        type: RESTORE_SNAPSHOT
      };
      if (cacheHit) {
        yield {
          payload: {
            snapshot: value
          },
          type: SET_STATE_FROM_SNAPSHOT
        };
        if (clearAfterRestore) {
          yield {
            payload: {},
            type: DELETE_SNAPSHOT
          };
        }
      }
      return cacheHit;
    },
    /**
     * Creates a snapshot of the current state of this store, using our cache API.
     *
     * @since 1.9.0
     * @private
     *
     * @return {boolean} Cache write response.
     */
    *createSnapshot() {
      const cacheResult = yield {
        payload: {},
        type: CREATE_SNAPSHOT
      };
      return cacheResult;
    }
  };
  const controls = {
    [DELETE_SNAPSHOT]: () => {
      return (0,_js_googlesitekit_api_cache__WEBPACK_IMPORTED_MODULE_3__.deleteItem)(`datastore::cache::${storeName}`);
    },
    [CREATE_SNAPSHOT]: (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.createRegistryControl)(registry => () => {
      const state = registry.stores[storeName].store.getState();
      const stateToSnapshot = keysToSnapshot?.length > 0 ? (0,lodash__WEBPACK_IMPORTED_MODULE_1__.pick)(state, keysToSnapshot) : state;
      return (0,_js_googlesitekit_api_cache__WEBPACK_IMPORTED_MODULE_3__.setItem)(`datastore::cache::${storeName}`, stateToSnapshot);
    }),
    [RESTORE_SNAPSHOT]: () => {
      // Only get snapshots made within the last hour.
      return (0,_js_googlesitekit_api_cache__WEBPACK_IMPORTED_MODULE_3__.getItem)(`datastore::cache::${storeName}`, _js_util__WEBPACK_IMPORTED_MODULE_4__.HOUR_IN_SECONDS);
    }
  };
  function reducer(state = initialState, {
    type,
    payload
  }) {
    // eslint-disable-line no-shadow
    switch (type) {
      case SET_STATE_FROM_SNAPSHOT:
        {
          const {
            snapshot
          } = payload;
          // Exclude any top-level errors from the restored state.
          // eslint-disable-next-line no-unused-vars
          const {
            error,
            ...newState
          } = snapshot;

          // If only a part of the state has been added to the snapshot, then
          // we should update the initial state with partial data restored
          // from the snapshot.
          if (keysToSnapshot?.length > 0) {
            return {
              ...state,
              ...newState
            };
          }
          return newState;
        }
      default:
        {
          return state;
        }
    }
  }
  return {
    initialState,
    actions,
    controls,
    reducer
  };
}

/**
 * Inspects a registry to find all stores that support our snapshot features.
 *
 * @since 1.9.0
 * @private
 *
 * @param {wp.data.registry} registry Optional. Registry object to inspect for stores that support state restoration. Defaults to `googlesitekit.data`.
 * @return {Object} The snapshot store object.
 */
function getStoresWithSnapshots(registry = (googlesitekit_data__WEBPACK_IMPORTED_MODULE_2___default())) {
  return Object.values(registry.stores).filter(store => {
    return Object.keys(store.getActions()).includes('restoreSnapshot');
  });
}

/**
 * Creates snapshots of all supporting stores.
 *
 * @since 1.9.0
 * @private
 *
 * @param {wp.data.registry} [registry] Optional. Registry object to inspect for stores that support state restoration. Defaults to `googlesitekit.data`.
 * @return {Promise} Promise resolves once all snapshots have been taken.
 */
function snapshotAllStores(registry = (googlesitekit_data__WEBPACK_IMPORTED_MODULE_2___default())) {
  return Promise.all(getStoresWithSnapshots(registry).map(store => {
    return store.getActions().createSnapshot();
  }));
}

/**
 * Restores state for all snapshots that support it.
 *
 * Only restores snapshots for stores that have `restoreSnapshot` action, and
 * clears the snapshot afterward, so more stores will not be restored unless
 * a snapshot was saved on the last pageview.
 *
 * @since 1.9.0
 * @private
 *
 * @param {wp.data.registry} [registry] Optional. Registry object to inspect for stores that support state restoration. Defaults to `googlesitekit.data`.
 * @return {Promise} Promise resolves once all snapshots have been restored.
 */
function restoreAllSnapshots(registry = (googlesitekit_data__WEBPACK_IMPORTED_MODULE_2___default())) {
  return Promise.all(getStoresWithSnapshots(registry).map(store => {
    return store.getActions().restoreSnapshot();
  }));
}

/***/ }),

/***/ "./js/googlesitekit/data/transform-case.js":
/*!*************************************************!*\
  !*** ./js/googlesitekit/data/transform-case.js ***!
  \*************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   camelCaseToConstantCase: () => (/* binding */ camelCaseToConstantCase),
/* harmony export */   camelCaseToPascalCase: () => (/* binding */ camelCaseToPascalCase),
/* harmony export */   hyphenCaseToPascalCase: () => (/* binding */ hyphenCaseToPascalCase)
/* harmony export */ });
/**
 * Data store utilities for transforming names to a certain case.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Transforms a camelCase name into its PascalCase name.
 *
 * @since 1.10.0
 * @private
 *
 * @param {string} name "camelCase" name to transform.
 * @return {string} PascalCase name.
 */
function camelCaseToPascalCase(name) {
  return name.charAt(0).toUpperCase() + name.slice(1);
}

/**
 * Transforms a camelCase name into its CONSTANT_CASE name.
 *
 * @since 1.10.0
 * @private
 *
 * @param {string} name "camelCase" name to transform.
 * @return {string} CONSTANT_CASE name.
 */
function camelCaseToConstantCase(name) {
  return name.replace(/([a-z0-9]{1})([A-Z]{1})/g, '$1_$2').toUpperCase();
}

/**
 * Transforms a hyphen-case name into its PascalCase name.
 *
 * @since 1.30.0
 * @private
 *
 * @param {string} name "hyphen-case" name to transform.
 * @return {string} PascalCase name.
 */
function hyphenCaseToPascalCase(name) {
  return name.split('-').map(part => part.charAt(0).toUpperCase() + part.slice(1)).join('');
}

/***/ }),

/***/ "./js/googlesitekit/data/utils.js":
/*!****************************************!*\
  !*** ./js/googlesitekit/data/utils.js ***!
  \****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   collect: () => (/* binding */ collect),
/* harmony export */   collectActions: () => (/* binding */ collectActions),
/* harmony export */   collectControls: () => (/* binding */ collectControls),
/* harmony export */   collectName: () => (/* binding */ collectName),
/* harmony export */   collectReducers: () => (/* binding */ collectReducers),
/* harmony export */   collectResolvers: () => (/* binding */ collectResolvers),
/* harmony export */   collectSelectors: () => (/* binding */ collectSelectors),
/* harmony export */   collectState: () => (/* binding */ collectState),
/* harmony export */   combineStores: () => (/* binding */ combineStores),
/* harmony export */   commonActions: () => (/* binding */ commonActions),
/* harmony export */   commonControls: () => (/* binding */ commonControls),
/* harmony export */   commonStore: () => (/* binding */ commonStore),
/* harmony export */   createStrictSelect: () => (/* binding */ createStrictSelect),
/* harmony export */   createValidatedAction: () => (/* binding */ createValidatedAction),
/* harmony export */   createValidationSelector: () => (/* binding */ createValidationSelector)
/* harmony export */ });
/* harmony import */ var invariant__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! invariant */ "../node_modules/invariant/browser.js");
/* harmony import */ var invariant__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(invariant__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var memize__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! memize */ "../node_modules/memize/index.js");
/* harmony import */ var memize__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(memize__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! lodash */ "../node_modules/lodash/lodash.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/data */ "../node_modules/@wordpress/data/build-module/factory.js");
/**
 * Data store utilities.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */




/**
 * WordPress dependencies
 */

const GET_REGISTRY = 'GET_REGISTRY';
const AWAIT = 'AWAIT';

/**
 * Collects and combines multiple objects of similar shape.
 *
 * Used to combine objects like actions, selectors, etc. for a data
 * store while ensuring no keys/action names/selector names are duplicated.
 *
 * Effectively this is an object spread, but throws an error if keys are
 * duplicated.
 *
 * @since 1.5.0
 * @private
 *
 * @param {...Object} items A list of arguments, each one should be an object to combine into one.
 * @return {Object} The combined object.
 */
function collect(...items) {
  const collectedObject = items.reduce((acc, item) => {
    return {
      ...acc,
      ...item
    };
  }, {});
  const functionNames = items.reduce((acc, itemSet) => {
    return [...acc, ...Object.keys(itemSet)];
  }, []);
  const duplicates = findDuplicates(functionNames);
  invariant__WEBPACK_IMPORTED_MODULE_0___default()(duplicates.length === 0, `collect() cannot accept collections with duplicate keys. Your call to collect() contains the following duplicated functions: ${duplicates.join(', ')}. Check your data stores for duplicates.`);
  return collectedObject;
}

/**
 * Collects all actions.
 *
 * @since 1.5.0
 *
 * @param {...Object} args A list of objects, each containing their own actions.
 * @return {Object} The combined object.
 */
const collectActions = collect;

/**
 * Collects all controls.
 *
 * @since 1.5.0
 *
 * @param {...Object} args A list of objects, each containing their own controls.
 * @return {Object} The combined object.
 */
const collectControls = collect;

/**
 * Collects all reducers and (optionally) provides initial state.
 *
 * If the first argument passed is not a function, it will be used as the
 * combined reducer's `initialState`.
 *
 * @since 1.5.0
 *
 * @param {...(Object|Function)} args A list of reducers, each containing their own controls. If the first argument is not a function, it will be used as the combined reducer's `initialState`.
 * @return {Function} A Redux-style reducer.
 */
function collectReducers(...args) {
  const reducers = [...args];
  let initialState;
  if (typeof reducers[0] !== 'function') {
    initialState = reducers.shift();
  }
  return (state = initialState, action = {}) => {
    return reducers.reduce((newState, reducer) => {
      return reducer(newState, action);
    }, state);
  };
}

/**
 * Collects all resolvers.
 *
 * @since 1.5.0
 *
 * @param {...Object} args A list of objects, each containing their own resolvers.
 * @return {Object} The combined object.
 */
const collectResolvers = collect;

/**
 * Collects all selectors.
 *
 * @since 1.5.0
 *
 * @param {...Object} args A list of objects, each containing their own selectors.
 * @return {Object} The combined object.
 */
const collectSelectors = collect;

/**
 * Collects all state values.
 *
 * @since 1.5.0
 *
 * @param {...Object} args A list of objects, each containing their own state values.
 * @return {Object} The combined object.
 */
const collectState = collect;

/**
 * Collects all store names.
 *
 * This function's main purpose is to ensure generated store names for a single store match.
 *
 * @since 1.6.0
 *
 * @param {...string} args A list of store names, all of which must be equal.
 * @return {string} The single store name.
 */
function collectName(...args) {
  const names = [...args];
  const duplicates = findDuplicates(names);
  invariant__WEBPACK_IMPORTED_MODULE_0___default()(duplicates.length === names.length - 1, 'collectName() must not receive different names.');
  return names.shift();
}

/**
 * Passes through state unmodified; eg. an empty reducer.
 *
 * @since 1.8.0
 * @private
 *
 * @param {Object} state A store's state.
 * @return {Object} The same state data as passed in `state`.
 */
function passthroughReducer(state) {
  return state;
}

/**
 * Combines multiple stores.
 *
 * @since 1.8.0
 *
 * @param {...Object} stores A list of objects, each a store containing one or more of the following keys: initialState, actions, controls, reducer, resolvers, selectors.
 * @return {Object} The combined store.
 */
function combineStores(...stores) {
  const combinedInitialState = collectState(...stores.map(store => store.initialState || {}));
  return {
    initialState: combinedInitialState,
    controls: collectControls(...stores.map(store => store.controls || {})),
    actions: collectActions(...stores.map(store => store.actions || {})),
    reducer: collectReducers(combinedInitialState, ...stores.map(store => store.reducer || passthroughReducer)),
    resolvers: collectResolvers(...stores.map(store => store.resolvers || {})),
    selectors: collectSelectors(...stores.map(store => store.selectors || {}))
  };
}

/**
 * An object of common actions most stores will use.
 *
 * @since 1.7.0
 *
 * @return {Object} Key/value list of common actions most stores will want.
 */
const commonActions = {
  /**
   * Dispatches an action and calls a control to get the current data registry.
   *
   * Useful for controls and resolvers that wish to dispatch actions/use selectors
   * on the current data registry.
   *
   * @since 1.7.0
   *
   * @return {Object} FSA-compatible action.
   */
  getRegistry() {
    return {
      payload: {},
      type: GET_REGISTRY
    };
  },
  /**
   * Dispatches an action and calls a control to return the promise resolution.
   *
   * Useful for controls and resolvers that wish to call an asynchronous function or other promise.
   *
   * @since 1.22.0
   *
   * @param {Promise} value A promise to resolve.
   * @return {Object} Object with resolved promise.
   */
  *await(value) {
    return {
      payload: {
        value
      },
      type: AWAIT
    };
  }
};

/**
 * An object of common controls most stores will use.
 *
 * @since 1.7.0
 *
 * @return {Object} Key/value list of common controls most stores will want.
 */
const commonControls = {
  /**
   * Returns the current registry.
   *
   * Useful for controls and resolvers that wish to dispatch actions/use selectors
   * on the current data registry.
   *
   * @since 1.7.0
   *
   * @return {Object} FSA-compatible action.
   */
  [GET_REGISTRY]: (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_3__.createRegistryControl)(registry => () => registry),
  /**
   * Returns a resolved promise.
   *
   * @since 1.22.0
   *
   * @param {Object} payload         Object containing a promise.
   * @param {Object} payload.payload Object containing a promise.
   * @return {*} Resolved promise.
   */
  [AWAIT]: ({
    payload
  }) => payload.value
};

/**
 * Finds all duplicate items in an array and return them.
 *
 * @since 1.5.0
 * @private
 *
 * @param {Array} array Any array.
 * @return {Array} All values in the input array that were duplicated.
 */
function findDuplicates(array) {
  const duplicates = [];
  const counts = {};
  for (let i = 0; i < array.length; i++) {
    const item = array[i];
    counts[item] = counts[item] >= 1 ? counts[item] + 1 : 1;
    if (counts[item] > 1) {
      duplicates.push(item);
    }
  }
  return duplicates;
}

/**
 * A store containing the common actions, controls and reducer that all stores will use.
 *
 * @since 1.8.0
 *
 * @return {Object} Object with common actions, controls and reducer.
 */
const commonStore = {
  actions: commonActions,
  controls: commonControls,
  reducer: passthroughReducer
};

/**
 * Creates a strict version of registry.select for ensuring that a selector is resolved at the time of calling.
 *
 * Not intended to be used directly. This is useful in the context of validation functions
 * to save checking for undefined on every result.
 *
 * Given the registry.select function instance, a new function is returned
 * with the same API as `select()` but will throw an error if the result
 * of the selector function is `undefined`.
 *
 * Ideally this would use something like `hasFinishedResolution` instead,
 * but there is no way to traverse the selectors used internally to identify
 * dependent selectors that have resolvers as many selectors are composed of
 * higher-level selectors internally which is where a resolver is normally implemented.
 *
 * @since 1.18.0
 * @private
 *
 * @param {Function} select The registry.select function.
 * @return {Function} The strict version of registry.select.
 */
function createStrictSelect(select) {
  return storeName => {
    return getStrictSelectors(select(storeName));
  };
}

// Based on {@link https://github.com/WordPress/gutenberg/blob/b1c8026087dfb026eff0a023a5f7febe28c876de/packages/data/src/registry.js#L91}
const getStrictSelectors = memize__WEBPACK_IMPORTED_MODULE_1___default()(selectors => (0,lodash__WEBPACK_IMPORTED_MODULE_2__.mapValues)(selectors, (selector, selectorName) => (...args) => {
  const returnValue = selector(...args);
  invariant__WEBPACK_IMPORTED_MODULE_0___default()(returnValue !== undefined, `${selectorName}(...) is not resolved`);
  return returnValue;
}));

/**
 * Creates two registry selectors that call the incoming function to validate the current state.
 *
 * @since 1.19.0
 *
 * @param {Function} validate         Validation function callback.
 * @param {Object}   [options]        Options to modify the behavior of the generated selectors.
 * @param {boolean}  [options.negate] Whether to negate the boolean result or not. Default: false.
 * @return {Object} Safe and dangerous selectors.
 */
function createValidationSelector(validate, {
  negate = false
} = {}) {
  const safeSelector = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_3__.createRegistrySelector)(select => (state, ...args) => {
    const pass = negate ? false : true;
    const fail = negate ? true : false;
    try {
      validate(select, state, ...args);
      return pass;
    } catch {
      return fail;
    }
  });
  const dangerousSelector = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_3__.createRegistrySelector)(select => (state, ...args) => {
    validate(select, state, ...args);
  });
  return {
    safeSelector,
    dangerousSelector
  };
}

/**
 * Creates a validated action creator.
 *
 * @since 1.32.0
 *
 * @param {Function} validate      A function for validating action arguments.
 * @param {Function} actionCreator A function for returning or yielding redux-style actions.
 * @return {Function} An enhanced action creator.
 */
function createValidatedAction(validate, actionCreator) {
  invariant__WEBPACK_IMPORTED_MODULE_0___default()(typeof validate === 'function', 'a validator function is required.');
  invariant__WEBPACK_IMPORTED_MODULE_0___default()(typeof actionCreator === 'function', 'an action creator function is required.');
  invariant__WEBPACK_IMPORTED_MODULE_0___default()(validate[Symbol.toStringTag] !== 'Generator' && validate[Symbol.toStringTag] !== 'GeneratorFunction', 'an action’s validator function must not be a generator.');
  return (...args) => {
    validate(...args);
    return actionCreator(...args);
  };
}

/***/ }),

/***/ "./js/googlesitekit/datastore/site/cache.js":
/*!**************************************************!*\
  !*** ./js/googlesitekit/datastore/site/cache.js ***!
  \**************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   actions: () => (/* binding */ actions),
/* harmony export */   baseControls: () => (/* binding */ baseControls),
/* harmony export */   controls: () => (/* binding */ controls),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   initialState: () => (/* binding */ initialState),
/* harmony export */   reducer: () => (/* binding */ reducer),
/* harmony export */   resolvers: () => (/* binding */ resolvers),
/* harmony export */   selectors: () => (/* binding */ selectors)
/* harmony export */ });
/* harmony import */ var invariant__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! invariant */ "../node_modules/invariant/browser.js");
/* harmony import */ var invariant__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(invariant__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _js_googlesitekit_api_cache__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/googlesitekit/api/cache */ "./js/googlesitekit/api/cache.js");
/**
 * `core/site` data store: client side cache.
 *
 * Site Kit by Google, Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * Internal dependencies
 */



// Actions.
const CACHE_SET_ITEM = 'CACHE_SET_ITEM';
const baseInitialState = {};
const baseActions = {
  /**
   * Yields to setItem function which sets cached data using a key.
   *
   * @since 1.109.0
   * @see setItem
   *
   * @param {string}  key              Name of cache key.
   * @param {*}       value            Value to store in the cache.
   * @param {Object}  args             Optional object containing ttl, timestamp and isError keys.
   * @param {number}  [args.ttl]       Optional. Validity of the cached item in seconds.
   * @param {number}  [args.timestamp] Optional. Timestamp when the cached item was created.
   * @param {boolean} [args.isError]   Optional. Whether the cached item is an error.
   */
  *setCacheItem(key, value, args) {
    invariant__WEBPACK_IMPORTED_MODULE_0___default()(key, 'key is required');
    invariant__WEBPACK_IMPORTED_MODULE_0___default()(value !== undefined, 'value is required');
    yield {
      type: CACHE_SET_ITEM,
      payload: {
        key,
        value,
        args
      }
    };
  }
};

// Base Controls
const baseControls = {
  [CACHE_SET_ITEM]: async ({
    payload
  }) => {
    const {
      key,
      value,
      args
    } = payload;
    await (0,_js_googlesitekit_api_cache__WEBPACK_IMPORTED_MODULE_2__.setItem)(key, value, args);
  }
};
const store = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.combineStores)({
  initialState: baseInitialState,
  actions: baseActions,
  controls: baseControls
});
const initialState = store.initialState;
const actions = store.actions;
const controls = store.controls;
const reducer = store.reducer;
const resolvers = store.resolvers;
const selectors = store.selectors;
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (store);

/***/ }),

/***/ "./js/googlesitekit/datastore/site/connection.js":
/*!*******************************************************!*\
  !*** ./js/googlesitekit/datastore/site/connection.js ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   actions: () => (/* binding */ actions),
/* harmony export */   controls: () => (/* binding */ controls),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   initialState: () => (/* binding */ initialState),
/* harmony export */   reducer: () => (/* binding */ reducer),
/* harmony export */   resolvers: () => (/* binding */ resolvers),
/* harmony export */   selectors: () => (/* binding */ selectors)
/* harmony export */ });
/* harmony import */ var googlesitekit_api__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! googlesitekit-api */ "googlesitekit-api");
/* harmony import */ var googlesitekit_api__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_api__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./constants */ "./js/googlesitekit/datastore/site/constants.js");
/* harmony import */ var _js_googlesitekit_data_create_fetch_store__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/googlesitekit/data/create-fetch-store */ "./js/googlesitekit/data/create-fetch-store.js");
/**
 * `core/site` data store: connection info.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Internal dependencies
 */




const fetchGetConnectionStore = (0,_js_googlesitekit_data_create_fetch_store__WEBPACK_IMPORTED_MODULE_3__.createFetchStore)({
  baseName: 'getConnection',
  controlCallback: () => {
    return (0,googlesitekit_api__WEBPACK_IMPORTED_MODULE_0__.get)('core', 'site', 'connection', undefined, {
      useCache: false
    });
  },
  reducerCallback: (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.createReducer)((state, connection) => {
    state.connection = connection;
  })
});
const baseInitialState = {
  connection: undefined
};
const baseResolvers = {
  *getConnection() {
    const registry = yield googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.commonActions.getRegistry();
    const existingConnection = registry.select(_constants__WEBPACK_IMPORTED_MODULE_2__.CORE_SITE).getConnection();
    if (!existingConnection) {
      yield fetchGetConnectionStore.actions.fetchGetConnection();
    }
  }
};
const baseSelectors = {
  /**
   * Gets the connection info for this site.
   *
   * Returns `undefined` if the connection info is not available/loaded.
   *
   * Returns an object with the shape when successful:
   * ```
   * {
   *   connected: <Boolean>,
   *   resettable: <Boolean>,
   *   setupCompleted: <Boolean>,
   * }
   * ```
   *
   * @since 1.5.0
   * @private
   *
   * @param {Object} state Data store's state.
   * @return {(Object|undefined)} Site connection info.
   */
  getConnection(state) {
    const {
      connection
    } = state;
    return connection;
  },
  /**
   * Gets owner ID.
   *
   * @since 1.16.0
   *
   * @param {Object} state Data store's state.
   * @return {number|undefined} Owner ID if it exists, otherwise undefined.
   */
  getOwnerID: (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.createRegistrySelector)(select => () => {
    const {
      ownerID
    } = select(_constants__WEBPACK_IMPORTED_MODULE_2__.CORE_SITE).getConnection() || {};
    return ownerID;
  }),
  /**
   * Gets information about connected admins.
   *
   * @since 1.14.0
   *
   * @param {Object} state Data store's state.
   * @return {(boolean|undefined)} TRUE if there are connected admins, otherwise FALSE or undefined if information is not available yet.
   */
  hasConnectedAdmins: (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.createRegistrySelector)(select => () => {
    const {
      hasConnectedAdmins
    } = select(_constants__WEBPACK_IMPORTED_MODULE_2__.CORE_SITE).getConnection() || {};
    return hasConnectedAdmins;
  }),
  /**
   * Gets the Site Kit connection status for this site.
   *
   * Returns `true` if the site is connected to Site Kit, `false` if
   * not. Returns `undefined` if the connection info is not available/loaded.
   *
   * @since 1.7.0
   *
   * @param {Object} state Data store's state.
   * @return {(boolean|undefined)} Site connection status.
   */
  isConnected: (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.createRegistrySelector)(select => () => {
    const connection = select(_constants__WEBPACK_IMPORTED_MODULE_2__.CORE_SITE).getConnection();
    return typeof connection !== 'undefined' ? connection.connected : connection;
  }),
  /**
   * Gets the Site Kit reset availability for this site.
   *
   * Returns `true` if the site is connected to Site Kit and
   * the connection can be reset, `false` if reset is not available.
   * Returns `undefined` if the connection info is not available/loaded.
   *
   * @since 1.7.0
   *
   * @param {Object} state Data store's state.
   * @return {(boolean|undefined)} Site reset status.
   */
  isResettable: (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.createRegistrySelector)(select => () => {
    const connection = select(_constants__WEBPACK_IMPORTED_MODULE_2__.CORE_SITE).getConnection();
    return typeof connection !== 'undefined' ? connection.resettable : connection;
  }),
  /**
   * Gets the Site Kit setup status.
   *
   * Returns `true` if the site is connected to Site Kit and
   * the connection can be reset, `false` if reset is not available.
   * Returns `undefined` if the connection info is not available/loaded.
   *
   * @since 1.7.0
   *
   * @param {Object} state Data store's state.
   * @return {(boolean|undefined)} Site setup completion status.
   */
  isSetupCompleted: (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.createRegistrySelector)(select => () => {
    const connection = select(_constants__WEBPACK_IMPORTED_MODULE_2__.CORE_SITE).getConnection();
    return typeof connection !== 'undefined' ? connection.setupCompleted : connection;
  }),
  /**
   * Gets the Site Kit information about admin users.
   *
   * Returns `true` if the site has multiple admins, `false` if it has just one admin.
   *
   * @since 1.29.0
   *
   * @param {Object} state Data store's state.
   * @return {(boolean|undefined)} Multiple admins status.
   */
  hasMultipleAdmins: (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.createRegistrySelector)(select => () => {
    return select(_constants__WEBPACK_IMPORTED_MODULE_2__.CORE_SITE).getConnection()?.hasMultipleAdmins;
  })
};
const store = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.combineStores)(fetchGetConnectionStore, {
  initialState: baseInitialState,
  resolvers: baseResolvers,
  selectors: baseSelectors
});
const initialState = store.initialState;
const actions = store.actions;
const controls = store.controls;
const reducer = store.reducer;
const resolvers = store.resolvers;
const selectors = store.selectors;
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (store);

/***/ }),

/***/ "./js/googlesitekit/datastore/site/consent-mode.js":
/*!*********************************************************!*\
  !*** ./js/googlesitekit/datastore/site/consent-mode.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   actions: () => (/* binding */ actions),
/* harmony export */   controls: () => (/* binding */ controls),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   initialState: () => (/* binding */ initialState),
/* harmony export */   reducer: () => (/* binding */ reducer),
/* harmony export */   resolvers: () => (/* binding */ resolvers),
/* harmony export */   selectors: () => (/* binding */ selectors)
/* harmony export */ });
/* harmony import */ var invariant__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! invariant */ "../node_modules/invariant/browser.js");
/* harmony import */ var invariant__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(invariant__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! lodash */ "../node_modules/lodash/lodash.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var googlesitekit_api__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! googlesitekit-api */ "googlesitekit-api");
/* harmony import */ var googlesitekit_api__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_api__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _js_googlesitekit_data_create_fetch_store__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/googlesitekit/data/create-fetch-store */ "./js/googlesitekit/data/create-fetch-store.js");
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./constants */ "./js/googlesitekit/datastore/site/constants.js");
/* harmony import */ var _js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @/js/googlesitekit/datastore/user/constants */ "./js/googlesitekit/datastore/user/constants.js");
/* harmony import */ var _js_googlesitekit_data_create_error_store__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @/js/googlesitekit/data/create-error-store */ "./js/googlesitekit/data/create-error-store.js");
/**
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * Internal dependencies
 */






const {
  clearError,
  receiveError
} = _js_googlesitekit_data_create_error_store__WEBPACK_IMPORTED_MODULE_7__.actions;
const {
  getRegistry
} = googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__.commonActions;
const SET_CONSENT_MODE_ENABLED = 'SET_CONSENT_MODE_ENABLED';
const INSTALL_ACTIVATE_WP_CONSENT_API_RESPONSE = 'INSTALL_ACTIVATE_WP_CONSENT_API_RESPONSE';
const INSTALL_ACTIVATE_WP_CONSENT_API_FETCHING = 'INSTALL_ACTIVATE_WP_CONSENT_API_FETCHING';
const settingsReducerCallback = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__.createReducer)((state, settings) => {
  state.consentMode.settings = settings;
});
const fetchGetConsentModeSettingsStore = (0,_js_googlesitekit_data_create_fetch_store__WEBPACK_IMPORTED_MODULE_4__.createFetchStore)({
  baseName: 'getConsentModeSettings',
  controlCallback: () => {
    return (0,googlesitekit_api__WEBPACK_IMPORTED_MODULE_2__.get)('core', 'site', 'consent-mode', null, {
      useCache: false
    });
  },
  reducerCallback: settingsReducerCallback
});
const fetchSaveConsentModeSettingsStore = (0,_js_googlesitekit_data_create_fetch_store__WEBPACK_IMPORTED_MODULE_4__.createFetchStore)({
  baseName: 'saveConsentModeSettings',
  controlCallback: ({
    settings
  }) => {
    return (0,googlesitekit_api__WEBPACK_IMPORTED_MODULE_2__.set)('core', 'site', 'consent-mode', {
      settings
    });
  },
  reducerCallback: settingsReducerCallback,
  argsToParams: settings => {
    return {
      settings
    };
  },
  validateParams: ({
    settings
  }) => {
    invariant__WEBPACK_IMPORTED_MODULE_0___default()((0,lodash__WEBPACK_IMPORTED_MODULE_1__.isPlainObject)(settings), 'settings must be a plain object.');
  }
});
const fetchGetConsentAPIInfoStore = (0,_js_googlesitekit_data_create_fetch_store__WEBPACK_IMPORTED_MODULE_4__.createFetchStore)({
  baseName: 'getConsentAPIInfo',
  controlCallback: () => {
    return (0,googlesitekit_api__WEBPACK_IMPORTED_MODULE_2__.get)('core', 'site', 'consent-api-info', null, {
      useCache: false
    });
  },
  reducerCallback: (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__.createReducer)((state, apiInfo) => {
    state.consentMode.apiInfo = apiInfo;
  })
});
const fetchInstallActivateWPConsentAPI = (0,_js_googlesitekit_data_create_fetch_store__WEBPACK_IMPORTED_MODULE_4__.createFetchStore)({
  baseName: 'installActivateWPConsentAPI',
  controlCallback: async ({
    nonce
  }) => {
    /**
     * This function utilizes an AJAX approach instead of the standardized REST approach
     * due to the requirement of the Plugin_Upgrader class, which relies on functions
     * from `admin.php` among others. These functions are properly loaded during the
     * AJAX callback, ensuring the installation and activation processes can execute correctly.
     */
    const data = new FormData();
    data.append('action', 'install_activate_wp_consent_api');
    data.append('_ajax_nonce', nonce);
    const response = await fetch(__webpack_require__.g.ajaxurl, {
      method: 'POST',
      credentials: 'same-origin',
      body: data
    });
    return response.json();
  },
  argsToParams: ({
    nonce
  }) => {
    return {
      nonce
    };
  },
  validateParams: ({
    nonce
  }) => {
    invariant__WEBPACK_IMPORTED_MODULE_0___default()(typeof nonce === 'string', 'nonce must be a string.');
  }
});
const fetchActivateConsentAPI = (0,_js_googlesitekit_data_create_fetch_store__WEBPACK_IMPORTED_MODULE_4__.createFetchStore)({
  baseName: 'activateConsentAPI',
  controlCallback: () => {
    return (0,googlesitekit_api__WEBPACK_IMPORTED_MODULE_2__.set)('core', 'site', 'consent-api-activate', null, {
      useCache: false
    });
  }
});
const fetchGetAdsMeasurementStatusStore = (0,_js_googlesitekit_data_create_fetch_store__WEBPACK_IMPORTED_MODULE_4__.createFetchStore)({
  baseName: 'getAdsMeasurementStatus',
  controlCallback: ({
    useCache
  }) => {
    return (0,googlesitekit_api__WEBPACK_IMPORTED_MODULE_2__.get)('core', 'site', 'ads-measurement-status', null, {
      useCache
    });
  },
  reducerCallback: (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__.createReducer)((state, response, {
    useCache
  }) => {
    state.consentMode.adsConnected = response.connected;
    if (!useCache) {
      state.consentMode.adsConnectedUncached = response.connected;
    }
  }),
  argsToParams: ({
    useCache
  } = {}) => ({
    useCache
  }),
  validateParams: ({
    useCache
  }) => {
    invariant__WEBPACK_IMPORTED_MODULE_0___default()(typeof useCache === 'boolean', 'useCache must be a boolean.');
  }
});
const baseInitialState = {
  consentMode: {
    settings: undefined,
    apiInfo: undefined,
    apiInstallResponse: undefined,
    isApiFetching: undefined,
    adsConnected: undefined,
    adsConnectedUncached: undefined
  }
};
const baseActions = {
  /**
   * Saves the consent mode settings.
   *
   * @since 1.122.0
   *
   * @return {Object} Object with `response` and `error`.
   */
  *saveConsentModeSettings() {
    const {
      select
    } = yield getRegistry();
    const settings = select(_constants__WEBPACK_IMPORTED_MODULE_5__.CORE_SITE).getConsentModeSettings();
    return yield fetchSaveConsentModeSettingsStore.actions.fetchSaveConsentModeSettings(settings);
  },
  /**
   * Sets the consent mode enabled status.
   *
   * @since 1.122.0
   *
   * @param {string} enabled Consent mode enabled status.
   * @return {Object} Redux-style action.
   */
  setConsentModeEnabled(enabled) {
    return {
      type: SET_CONSENT_MODE_ENABLED,
      payload: {
        enabled
      }
    };
  },
  /**
   * Installs and activates the WP Consent API Plugin on the backend.
   *
   * @since 1.132.0
   */
  *installActivateWPConsentAPI() {
    const registry = yield getRegistry();
    yield clearError('installActivateWPConsentAPI', []);
    yield {
      type: INSTALL_ACTIVATE_WP_CONSENT_API_FETCHING,
      payload: true
    };
    yield googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__.commonActions.await(registry.resolveSelect(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_6__.CORE_USER).getNonces());
    const nonce = registry.select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_6__.CORE_USER).getNonce('updates');
    if (nonce === undefined) {
      const error = registry.select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_6__.CORE_USER).getErrorForSelector('getNonces');
      yield receiveError(error, 'installActivateWPConsentAPI', []);
      yield {
        type: INSTALL_ACTIVATE_WP_CONSENT_API_FETCHING,
        payload: false
      };
      registry.dispatch(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_6__.CORE_USER).invalidateResolution('getNonces', []);
      return;
    }
    const {
      response
    } = yield fetchInstallActivateWPConsentAPI.actions.fetchInstallActivateWPConsentAPI({
      nonce
    });
    yield {
      type: INSTALL_ACTIVATE_WP_CONSENT_API_RESPONSE,
      payload: response
    };
    yield {
      type: INSTALL_ACTIVATE_WP_CONSENT_API_FETCHING,
      payload: false
    };

    // Fetch the latest info, if plugin is installed and activated it will show the success message.
    yield fetchGetConsentAPIInfoStore.actions.fetchGetConsentAPIInfo();
  },
  /**
   * Activates the WP Consent API Plugin on the backend.
   *
   * @since 1.132.0
   */
  *activateConsentAPI() {
    const response = yield fetchActivateConsentAPI.actions.fetchActivateConsentAPI();
    yield {
      type: INSTALL_ACTIVATE_WP_CONSENT_API_RESPONSE,
      payload: response
    };

    // Fetch the latest info, if plugin is activated it will show the success message.
    yield fetchGetConsentAPIInfoStore.actions.fetchGetConsentAPIInfo();
  }
};
const baseControls = {};
const baseReducer = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__.createReducer)((state, {
  type,
  payload
}) => {
  switch (type) {
    case SET_CONSENT_MODE_ENABLED:
      state.consentMode.settings = state.consentMode.settings || {};
      state.consentMode.settings.enabled = !!payload.enabled;
      break;
    case INSTALL_ACTIVATE_WP_CONSENT_API_RESPONSE:
      state.consentMode.apiInstallResponse = payload;
      break;
    case INSTALL_ACTIVATE_WP_CONSENT_API_FETCHING:
      state.consentMode.isApiFetching = payload;
      break;
    default:
      break;
  }
});
const baseSelectors = {
  /**
   * Gets the consent mode settings.
   *
   * @since 1.122.0
   *
   * @param {Object} state Data store's state.
   * @return {Object|undefined} Consent mode settings, or `undefined` if not loaded.
   */
  getConsentModeSettings: state => {
    return state.consentMode.settings;
  },
  /**
   * Gets the consent mode enabled status.
   *
   * @since 1.122.0
   *
   * @return {boolean|undefined} Consent mode enabled status, or `undefined` if not loaded.
   */
  isConsentModeEnabled: (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__.createRegistrySelector)(select => () => {
    const {
      enabled
    } = select(_constants__WEBPACK_IMPORTED_MODULE_5__.CORE_SITE).getConsentModeSettings() || {};
    return enabled;
  }),
  /**
   * Gets the WP consent mode API info.
   *
   * @since 1.122.0
   *
   * @param {Object} state Data store's state.
   * @return {Object|undefined} WP consent mode API info, or `undefined` if not loaded.
   */
  getConsentAPIInfo: state => {
    return state.consentMode.apiInfo;
  },
  /**
   * Gets the WP Consent API Install/Activate Response.
   *
   * @since 1.132.0
   *
   * @param {Object} state Data store's state.
   * @return {Object|undefined} WP consent mode API response, or `undefined` if not loaded.
   */
  getApiInstallResponse: state => {
    return state.consentMode.apiInstallResponse;
  },
  /**
   * Gets the WP Consent API Install/Activate isApiFetching value.
   *
   * @since 1.132.0
   *
   * @param {Object} state Data store's state.
   * @return {boolean|undefined} Gets the value if WP consent mode API is currently fetching, or `undefined` if not loaded.
   */
  isApiFetching: state => {
    return state.consentMode.isApiFetching;
  },
  /**
   * Returns true if Google Ads is in use, either through a linked Analytics & Ads
   * account, an Ads conversion tracking ID, or via Analytics tag config.
   *
   * @since 1.124.0
   * @since 1.125.0 Updated to consider Ads connection status via the Analytics tag config, and to source Conversion ID field from Ads module.
   * @since 1.142.0 Updated to a simple selector which returns value from the state.
   *
   * @param {Object} state Data store's state.
   * @return {boolean|undefined} True if Google Ads is in use, false otherwise. Undefined if the selectors have not loaded.
   */
  isAdsConnected: state => {
    return state.consentMode.adsConnected;
  },
  /**
   * Returns true if Google Ads is in use, but ensures fresh data is fetched.
   *
   * @since 1.151.0
   *
   * @param {Object} state Data store's state.
   * @return {boolean|undefined} True if Google Ads is in use, false otherwise. Undefined if the selectors have not loaded.
   */
  isAdsConnectedUncached: state => {
    return state.consentMode.adsConnectedUncached;
  }
};
const baseResolvers = {
  *getConsentModeSettings() {
    const {
      select
    } = yield getRegistry();
    if (select(_constants__WEBPACK_IMPORTED_MODULE_5__.CORE_SITE).getConsentModeSettings()) {
      return;
    }
    yield fetchGetConsentModeSettingsStore.actions.fetchGetConsentModeSettings();
  },
  *getConsentAPIInfo() {
    const {
      select
    } = yield getRegistry();
    if (select(_constants__WEBPACK_IMPORTED_MODULE_5__.CORE_SITE).getConsentAPIInfo()) {
      return;
    }
    yield fetchGetConsentAPIInfoStore.actions.fetchGetConsentAPIInfo();
  },
  *isAdsConnected() {
    const {
      select
    } = yield getRegistry();
    if (select(_constants__WEBPACK_IMPORTED_MODULE_5__.CORE_SITE).isAdsConnected() !== undefined) {
      return;
    }
    yield fetchGetAdsMeasurementStatusStore.actions.fetchGetAdsMeasurementStatus({
      useCache: true
    });
  },
  *isAdsConnectedUncached() {
    const {
      select
    } = yield getRegistry();
    if (select(_constants__WEBPACK_IMPORTED_MODULE_5__.CORE_SITE).isAdsConnectedUncached() !== undefined) {
      return;
    }
    yield fetchGetAdsMeasurementStatusStore.actions.fetchGetAdsMeasurementStatus({
      useCache: false
    });
  }
};
const store = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__.combineStores)(fetchGetConsentModeSettingsStore, fetchSaveConsentModeSettingsStore, fetchGetConsentAPIInfoStore, fetchInstallActivateWPConsentAPI, fetchActivateConsentAPI, fetchGetAdsMeasurementStatusStore, {
  initialState: baseInitialState,
  actions: baseActions,
  controls: baseControls,
  reducer: baseReducer,
  resolvers: baseResolvers,
  selectors: baseSelectors
});
const initialState = store.initialState;
const actions = store.actions;
const controls = store.controls;
const reducer = store.reducer;
const resolvers = store.resolvers;
const selectors = store.selectors;
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (store);

/***/ }),

/***/ "./js/googlesitekit/datastore/site/constants.js":
/*!******************************************************!*\
  !*** ./js/googlesitekit/datastore/site/constants.js ***!
  \******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   AMP_MODE_PRIMARY: () => (/* binding */ AMP_MODE_PRIMARY),
/* harmony export */   AMP_MODE_SECONDARY: () => (/* binding */ AMP_MODE_SECONDARY),
/* harmony export */   CORE_SITE: () => (/* binding */ CORE_SITE)
/* harmony export */ });
/**
 * `core/site` data store: constants.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

const CORE_SITE = 'core/site';
const AMP_MODE_PRIMARY = 'primary';
const AMP_MODE_SECONDARY = 'secondary';

/***/ }),

/***/ "./js/googlesitekit/datastore/site/conversion-tracking.js":
/*!****************************************************************!*\
  !*** ./js/googlesitekit/datastore/site/conversion-tracking.js ***!
  \****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   actions: () => (/* binding */ actions),
/* harmony export */   controls: () => (/* binding */ controls),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   initialState: () => (/* binding */ initialState),
/* harmony export */   reducer: () => (/* binding */ reducer),
/* harmony export */   resolvers: () => (/* binding */ resolvers),
/* harmony export */   selectors: () => (/* binding */ selectors)
/* harmony export */ });
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! lodash */ "../node_modules/lodash/lodash.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var invariant__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! invariant */ "../node_modules/invariant/browser.js");
/* harmony import */ var invariant__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(invariant__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var googlesitekit_api__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! googlesitekit-api */ "googlesitekit-api");
/* harmony import */ var googlesitekit_api__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_api__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _js_googlesitekit_data_create_fetch_store__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/googlesitekit/data/create-fetch-store */ "./js/googlesitekit/data/create-fetch-store.js");
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./constants */ "./js/googlesitekit/datastore/site/constants.js");
/**
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * Internal dependencies
 */




const {
  getRegistry
} = googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__.commonActions;
const SET_CONVERSION_TRACKING_ENABLED = 'SET_CONVERSION_TRACKING_ENABLED';
const RESET_CONVERSION_TRACKING_SETTINGS = 'RESET_CONVERSION_TRACKING_SETTINGS';
const settingsReducerCallback = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__.createReducer)((state, settings) => {
  state.conversionTracking.settings = settings;
  state.conversionTracking.savedSettings = settings;
});
const fetchGetConversionTrackingSettingsStore = (0,_js_googlesitekit_data_create_fetch_store__WEBPACK_IMPORTED_MODULE_4__.createFetchStore)({
  baseName: 'getConversionTrackingSettings',
  controlCallback: () => {
    return (0,googlesitekit_api__WEBPACK_IMPORTED_MODULE_2__.get)('core', 'site', 'conversion-tracking', null, {
      useCache: false
    });
  },
  reducerCallback: settingsReducerCallback
});
const fetchSaveConversionTrackingSettingsStore = (0,_js_googlesitekit_data_create_fetch_store__WEBPACK_IMPORTED_MODULE_4__.createFetchStore)({
  baseName: 'saveConversionTrackingSettings',
  controlCallback: ({
    settings
  }) => {
    return (0,googlesitekit_api__WEBPACK_IMPORTED_MODULE_2__.set)('core', 'site', 'conversion-tracking', {
      settings
    });
  },
  reducerCallback: settingsReducerCallback,
  argsToParams: settings => {
    return {
      settings
    };
  },
  validateParams: ({
    settings
  }) => {
    invariant__WEBPACK_IMPORTED_MODULE_1___default()((0,lodash__WEBPACK_IMPORTED_MODULE_0__.isPlainObject)(settings), 'settings must be a plain object.');
  }
});
const baseInitialState = {
  conversionTracking: {
    settings: undefined,
    savedSettings: undefined
  }
};
const baseActions = {
  /**
   * Saves the Conversion Tracking settings.
   *
   * @since 1.128.0
   *
   * @return {Object} Object with `response` and `error`.
   */
  *saveConversionTrackingSettings() {
    const {
      select
    } = yield getRegistry();
    const settings = select(_constants__WEBPACK_IMPORTED_MODULE_5__.CORE_SITE).getConversionTrackingSettings();
    return yield fetchSaveConversionTrackingSettingsStore.actions.fetchSaveConversionTrackingSettings(settings);
  },
  /**
   * Sets the Conversion Tracking enabled status.
   *
   * @since 1.128.0
   *
   * @param {string} enabled Consent mode enabled status.
   * @return {Object} Redux-style action.
   */
  setConversionTrackingEnabled(enabled) {
    return {
      type: SET_CONVERSION_TRACKING_ENABLED,
      payload: {
        enabled
      }
    };
  },
  /**
   * Returns the current settings back to the current saved values.
   *
   * @since 1.129.0
   * @private
   *
   * @return {Object} Redux-style action.
   */
  resetConversionTrackingSettings() {
    return {
      payload: {},
      type: RESET_CONVERSION_TRACKING_SETTINGS
    };
  }
};
const baseControls = {};
const baseReducer = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__.createReducer)((state, {
  type,
  payload
}) => {
  switch (type) {
    case SET_CONVERSION_TRACKING_ENABLED:
      state.conversionTracking.settings = state.conversionTracking.settings || {};
      state.conversionTracking.settings.enabled = !!payload.enabled;
      break;
    case RESET_CONVERSION_TRACKING_SETTINGS:
      state.conversionTracking.settings = state.conversionTracking.savedSettings;
      break;
    default:
      break;
  }
});
const baseSelectors = {
  /**
   * Gets the Conversion Tracking settings.
   *
   * @since 1.128.0
   *
   * @param {Object} state Data store's state.
   * @return {Object|undefined} Conversion Tracking settings, or `undefined` if not loaded.
   */
  getConversionTrackingSettings: state => {
    return state.conversionTracking.settings;
  },
  /**
   * Gets the consent mode enabled status.
   *
   * @since 1.128.0
   *
   * @return {boolean|undefined} Consent mode enabled status, or `undefined` if not loaded.
   */
  isConversionTrackingEnabled: (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__.createRegistrySelector)(select => () => {
    const {
      enabled
    } = select(_constants__WEBPACK_IMPORTED_MODULE_5__.CORE_SITE).getConversionTrackingSettings() || {};
    return enabled;
  }),
  /**
   * Indicates whether the current settings have changed from what is saved.
   *
   * @since 1.128.0
   *
   * @param {Object} state Data store's state.
   * @return {boolean} True if the settings have changed, false otherwise.
   */
  haveConversionTrackingSettingsChanged(state) {
    const {
      settings,
      savedSettings
    } = state.conversionTracking;
    return !(0,lodash__WEBPACK_IMPORTED_MODULE_0__.isEqual)(settings, savedSettings);
  }
};
const baseResolvers = {
  *getConversionTrackingSettings() {
    const {
      select
    } = yield getRegistry();
    const conversionTrackingSettings = select(_constants__WEBPACK_IMPORTED_MODULE_5__.CORE_SITE).getConversionTrackingSettings();
    if (conversionTrackingSettings) {
      return;
    }
    yield fetchGetConversionTrackingSettingsStore.actions.fetchGetConversionTrackingSettings();
  }
};
const store = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__.combineStores)(fetchGetConversionTrackingSettingsStore, fetchSaveConversionTrackingSettingsStore, {
  initialState: baseInitialState,
  actions: baseActions,
  controls: baseControls,
  reducer: baseReducer,
  resolvers: baseResolvers,
  selectors: baseSelectors
});
const initialState = store.initialState;
const actions = store.actions;
const controls = store.controls;
const reducer = store.reducer;
const resolvers = store.resolvers;
const selectors = store.selectors;
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (store);

/***/ }),

/***/ "./js/googlesitekit/datastore/site/developer-plugin.js":
/*!*************************************************************!*\
  !*** ./js/googlesitekit/datastore/site/developer-plugin.js ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   actions: () => (/* binding */ actions),
/* harmony export */   controls: () => (/* binding */ controls),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   initialState: () => (/* binding */ initialState),
/* harmony export */   reducer: () => (/* binding */ reducer),
/* harmony export */   resolvers: () => (/* binding */ resolvers),
/* harmony export */   selectors: () => (/* binding */ selectors)
/* harmony export */ });
/* harmony import */ var googlesitekit_api__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! googlesitekit-api */ "googlesitekit-api");
/* harmony import */ var googlesitekit_api__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_api__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./constants */ "./js/googlesitekit/datastore/site/constants.js");
/* harmony import */ var _js_googlesitekit_data_create_fetch_store__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/googlesitekit/data/create-fetch-store */ "./js/googlesitekit/data/create-fetch-store.js");
/**
 * `core/site` data store: developer plugin.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Internal dependencies
 */




const fetchGetDeveloperPluginState = (0,_js_googlesitekit_data_create_fetch_store__WEBPACK_IMPORTED_MODULE_3__.createFetchStore)({
  baseName: 'getDeveloperPluginState',
  controlCallback: () => {
    return (0,googlesitekit_api__WEBPACK_IMPORTED_MODULE_0__.get)('core', 'site', 'developer-plugin', undefined, {
      useCache: false
    });
  },
  reducerCallback: (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.createReducer)((state, developerPluginState) => {
    state.developerPluginState = developerPluginState;
  })
});
const baseInitialState = {
  developerPluginState: undefined
};
const baseResolvers = {
  *getDeveloperPluginState() {
    const registry = yield googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.commonActions.getRegistry();
    const existingDeveloperPluginState = registry.select(_constants__WEBPACK_IMPORTED_MODULE_2__.CORE_SITE).getDeveloperPluginState();
    if (!existingDeveloperPluginState) {
      yield fetchGetDeveloperPluginState.actions.fetchGetDeveloperPluginState();
    }
  }
};
const baseSelectors = {
  /**
   * Gets the developer plugin state info for this site.
   *
   * Returns `undefined` if the developer plugin state is not available/loaded.
   *
   * Returns an object with the shape when successful:
   * ```
   * {
   *   active: <Boolean>,
   *   activateURL: <String>,
   *   configureURL: <String>,
   *   installURL: <String>,
   *   installed: <Boolean>,
   * }
   * ```
   *
   * @since 1.21.0
   * @private
   *
   * @param {Object} state Data store's state.
   * @return {(Object|undefined)} Developer plugin state.
   */
  getDeveloperPluginState(state) {
    return state.developerPluginState;
  }
};
const store = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.combineStores)(fetchGetDeveloperPluginState, {
  initialState: baseInitialState,
  resolvers: baseResolvers,
  selectors: baseSelectors
});
const initialState = store.initialState;
const actions = store.actions;
const controls = store.controls;
const reducer = store.reducer;
const resolvers = store.resolvers;
const selectors = store.selectors;
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (store);

/***/ }),

/***/ "./js/googlesitekit/datastore/site/email-reporting.js":
/*!************************************************************!*\
  !*** ./js/googlesitekit/datastore/site/email-reporting.js ***!
  \************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   actions: () => (/* binding */ actions),
/* harmony export */   baseReducer: () => (/* binding */ baseReducer),
/* harmony export */   controls: () => (/* binding */ controls),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   initialState: () => (/* binding */ initialState),
/* harmony export */   reducer: () => (/* binding */ reducer),
/* harmony export */   resolvers: () => (/* binding */ resolvers),
/* harmony export */   selectors: () => (/* binding */ selectors)
/* harmony export */ });
/* harmony import */ var invariant__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! invariant */ "../node_modules/invariant/browser.js");
/* harmony import */ var invariant__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(invariant__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! lodash */ "../node_modules/lodash/lodash.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var googlesitekit_api__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! googlesitekit-api */ "googlesitekit-api");
/* harmony import */ var googlesitekit_api__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_api__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./constants */ "./js/googlesitekit/datastore/site/constants.js");
/* harmony import */ var _js_googlesitekit_data_create_fetch_store__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/googlesitekit/data/create-fetch-store */ "./js/googlesitekit/data/create-fetch-store.js");
/**
 * `core/site` data store: Email Reporting settings.
 *
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * Internal dependencies
 */




const baseInitialState = {
  emailReporting: {
    settings: undefined,
    savedSettings: undefined
  }
};
const fetchStoreReducerCallback = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__.createReducer)((state, emailReportingSettings) => {
  state.emailReporting.settings = emailReportingSettings;
  state.emailReporting.savedSettings = emailReportingSettings;
});
const fetchGetEmailReportingSettingsStore = (0,_js_googlesitekit_data_create_fetch_store__WEBPACK_IMPORTED_MODULE_5__.createFetchStore)({
  baseName: 'getEmailReportingSettings',
  controlCallback: () => (0,googlesitekit_api__WEBPACK_IMPORTED_MODULE_2__.get)('core', 'site', 'email-reporting', undefined, {
    useCache: false
  }),
  reducerCallback: fetchStoreReducerCallback
});
const fetchSaveEmailReportingSettingsStore = (0,_js_googlesitekit_data_create_fetch_store__WEBPACK_IMPORTED_MODULE_5__.createFetchStore)({
  baseName: 'saveEmailReportingSettings',
  controlCallback: settings => (0,googlesitekit_api__WEBPACK_IMPORTED_MODULE_2__.set)('core', 'site', 'email-reporting', {
    settings
  }),
  reducerCallback: fetchStoreReducerCallback,
  argsToParams: settings => settings,
  validateParams: settings => {
    invariant__WEBPACK_IMPORTED_MODULE_0___default()((0,lodash__WEBPACK_IMPORTED_MODULE_1__.isPlainObject)(settings), 'Email Reporting settings should be an object.');
    invariant__WEBPACK_IMPORTED_MODULE_0___default()(typeof settings.enabled === 'boolean', 'enabled should be a boolean.');
  }
});

// Actions
const SET_EMAIL_REPORTING_SETTINGS = 'SET_EMAIL_REPORTING_SETTINGS';
const baseActions = {
  /**
   * Saves the email reporting settings.
   *
   * @since n.e.x.t
   *
   * @return {Object} Object with `response` and `error`.
   */
  *saveEmailReportingSettings() {
    const {
      select
    } = yield googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__.commonActions.getRegistry();
    const settings = select(_constants__WEBPACK_IMPORTED_MODULE_4__.CORE_SITE).getEmailReportingSettings();
    const results = yield fetchSaveEmailReportingSettingsStore.actions.fetchSaveEmailReportingSettings(settings);
    return results;
  },
  /**
   * Sets email reporting enabled state.
   *
   * @since n.e.x.t
   *
   * @param {*} enabled Whether email reporting is enabled.
   * @return {Object} Redux-style action.
   */
  setEmailReportingEnabled(enabled) {
    invariant__WEBPACK_IMPORTED_MODULE_0___default()(typeof enabled === 'boolean', 'enabled should be a boolean.');
    return {
      type: SET_EMAIL_REPORTING_SETTINGS,
      payload: {
        settings: {
          enabled
        }
      }
    };
  }
};
const baseReducer = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__.createReducer)((state, action) => {
  const {
    type,
    payload
  } = action;
  switch (type) {
    case SET_EMAIL_REPORTING_SETTINGS:
      {
        state.emailReporting.settings = {
          ...state.emailReporting.settings,
          ...payload.settings
        };
        break;
      }
    default:
      break;
  }
});
const baseResolvers = {
  *getEmailReportingSettings() {
    const registry = yield googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__.commonActions.getRegistry();
    const emailReportingSettings = registry.select(_constants__WEBPACK_IMPORTED_MODULE_4__.CORE_SITE).getEmailReportingSettings();
    if (emailReportingSettings === undefined) {
      yield fetchGetEmailReportingSettingsStore.actions.fetchGetEmailReportingSettings();
    }
  }
};
const baseSelectors = {
  /**
   * Gets the email reporting settings.
   *
   * @since n.e.x.t
   *
   * @param {Object} state Data store's state.
   * @return {(Object|undefined)} Email Reporting settings; `undefined` if not loaded.
   */
  getEmailReportingSettings(state) {
    return state.emailReporting?.settings;
  },
  /**
   * Determines whether email reporting is enabled.
   *
   * @since n.e.x.t
   *
   * @param {Object} state Data store's state.
   * @return {boolean} TRUE if email reporting is enabled, otherwise FALSE.
   */
  isEmailReportingEnabled(state) {
    const settings = state.emailReporting?.settings;
    return !!settings?.enabled;
  }
};
const store = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__.combineStores)(fetchGetEmailReportingSettingsStore, fetchSaveEmailReportingSettingsStore, {
  initialState: baseInitialState,
  actions: baseActions,
  reducer: baseReducer,
  resolvers: baseResolvers,
  selectors: baseSelectors
});
const initialState = store.initialState;
const actions = store.actions;
const controls = store.controls;
const reducer = store.reducer;
const resolvers = store.resolvers;
const selectors = store.selectors;
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (store);

/***/ }),

/***/ "./js/googlesitekit/datastore/site/enable-auto-update.js":
/*!***************************************************************!*\
  !*** ./js/googlesitekit/datastore/site/enable-auto-update.js ***!
  \***************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   actions: () => (/* binding */ actions),
/* harmony export */   controls: () => (/* binding */ controls),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   initialState: () => (/* binding */ initialState),
/* harmony export */   reducer: () => (/* binding */ reducer),
/* harmony export */   resolvers: () => (/* binding */ resolvers),
/* harmony export */   selectors: () => (/* binding */ selectors)
/* harmony export */ });
/* harmony import */ var invariant__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! invariant */ "../node_modules/invariant/browser.js");
/* harmony import */ var invariant__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(invariant__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./constants */ "./js/googlesitekit/datastore/site/constants.js");
/* harmony import */ var _js_googlesitekit_data_create_fetch_store__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/googlesitekit/data/create-fetch-store */ "./js/googlesitekit/data/create-fetch-store.js");
/* harmony import */ var _js_googlesitekit_data_create_error_store__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/googlesitekit/data/create-error-store */ "./js/googlesitekit/data/create-error-store.js");
/* harmony import */ var _js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/googlesitekit/datastore/user/constants */ "./js/googlesitekit/datastore/user/constants.js");
/**
 * `core/site` data store: handle "Auto-updating" of Site Kit plugin in WordPress.
 *
 * Site Kit by Google, Copyright 2022 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * Internal dependencies
 */





const {
  receiveError,
  clearError
} = _js_googlesitekit_data_create_error_store__WEBPACK_IMPORTED_MODULE_4__.actions;
const fetchEnableAutoUpdateStore = (0,_js_googlesitekit_data_create_fetch_store__WEBPACK_IMPORTED_MODULE_3__.createFetchStore)({
  baseName: 'enableAutoUpdate',
  controlCallback: async ({
    nonce,
    pluginBasename
  }) => {
    const data = new FormData();
    data.append('action', 'toggle-auto-updates');
    data.append('_ajax_nonce', nonce);
    data.append('state', 'enable');
    data.append('type', 'plugin');
    data.append('asset', pluginBasename);
    const response = await fetch(__webpack_require__.g.ajaxurl, {
      method: 'POST',
      credentials: 'same-origin',
      body: data
    });
    return response.json();
  },
  argsToParams: ({
    nonce,
    pluginBasename
  }) => {
    return {
      nonce,
      pluginBasename
    };
  },
  validateParams: ({
    nonce,
    pluginBasename
  }) => {
    invariant__WEBPACK_IMPORTED_MODULE_0___default()(typeof nonce === 'string', 'nonce must be a string.');
    invariant__WEBPACK_IMPORTED_MODULE_0___default()(typeof pluginBasename === 'string', 'pluginBasename must be a string.');
  }
});
const baseInitialState = {};
const baseActions = {
  /**
   * Enables auto updates for Site Kit.
   *
   * @since 1.93.0
   */
  *enableAutoUpdate() {
    yield clearError('enableAutoUpdate', []);
    const registry = yield googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.commonActions.getRegistry();
    yield googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.commonActions.await(registry.resolveSelect(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_5__.CORE_USER).getNonces());
    yield googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.commonActions.await(registry.resolveSelect(_constants__WEBPACK_IMPORTED_MODULE_2__.CORE_SITE).getSiteInfo());
    const nonce = registry.select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_5__.CORE_USER).getNonce('updates');
    const pluginBasename = registry.select(_constants__WEBPACK_IMPORTED_MODULE_2__.CORE_SITE).getPluginBasename();
    const {
      response,
      error
    } = yield fetchEnableAutoUpdateStore.actions.fetchEnableAutoUpdate({
      nonce,
      pluginBasename
    });
    if (response?.success) {
      registry.dispatch(_constants__WEBPACK_IMPORTED_MODULE_2__.CORE_SITE).setSiteKitAutoUpdatesEnabled(true);
    }
    if (error) {
      yield receiveError(error, 'enableAutoUpdate', []);
    }
  }
};
const baseSelectors = {
  /**
   * Checks if enableAutoUpdate action is in-process.
   *
   * @since 1.93.0
   *
   * @param {Object} state          Data store's state.
   * @param {string} nonce          The nonce string.
   * @param {string} pluginBasename The plugin base name.
   * @return {boolean} `true` if enableAutoUpdate is in-flight; `false` if not.
   */
  isDoingEnableAutoUpdate: (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.createRegistrySelector)(select => () => {
    const nonce = select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_5__.CORE_USER).getNonce('updates');
    const pluginBasename = select(_constants__WEBPACK_IMPORTED_MODULE_2__.CORE_SITE).getPluginBasename();
    if (nonce === undefined || pluginBasename === undefined) {
      return false;
    }
    return select(_constants__WEBPACK_IMPORTED_MODULE_2__.CORE_SITE).isFetchingEnableAutoUpdate({
      nonce,
      pluginBasename
    });
  })
};
const store = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.combineStores)(fetchEnableAutoUpdateStore, {
  initialState: baseInitialState,
  actions: baseActions,
  selectors: baseSelectors
});
const initialState = store.initialState;
const actions = store.actions;
const controls = store.controls;
const reducer = store.reducer;
const resolvers = store.resolvers;
const selectors = store.selectors;
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (store);

/***/ }),

/***/ "./js/googlesitekit/datastore/site/errors.js":
/*!***************************************************!*\
  !*** ./js/googlesitekit/datastore/site/errors.js ***!
  \***************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   actions: () => (/* binding */ actions),
/* harmony export */   baseReducer: () => (/* binding */ baseReducer),
/* harmony export */   controls: () => (/* binding */ controls),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   initialState: () => (/* binding */ initialState),
/* harmony export */   reducer: () => (/* binding */ reducer),
/* harmony export */   resolvers: () => (/* binding */ resolvers),
/* harmony export */   selectors: () => (/* binding */ selectors)
/* harmony export */ });
/* harmony import */ var invariant__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! invariant */ "../node_modules/invariant/browser.js");
/* harmony import */ var invariant__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(invariant__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! lodash */ "../node_modules/lodash/lodash.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__);
/**
 * `core/site` data store: Error info.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */


// Actions
const SET_SERVER_ERROR = 'SET_SERVER_ERROR';
const CLEAR_SERVER_ERROR = 'CLEAR_SERVER_ERROR';
const baseInitialState = {
  internalServerError: undefined
};
const baseActions = {
  /**
   * Sets the internal server error.
   *
   * @since 1.38.0
   *
   * @param {Object} error             Internal server error object.
   * @param {string} error.id          Error notification ID.
   * @param {string} [error.title]     Optional. Error notification title. Default is "Internal Server Error".
   * @param {string} error.description Error notification message.
   * @param {string} [error.format]    Optional. Error notification format. Valid values "small" and "large". Default is "small".
   * @param {string} [error.type]      Optional. Error notification type. Valid values "win-warning" and "win-error". Default is "win-error".
   * @return {Object} Redux-style action.
   */
  setInternalServerError(error) {
    invariant__WEBPACK_IMPORTED_MODULE_0___default()((0,lodash__WEBPACK_IMPORTED_MODULE_1__.isPlainObject)(error), 'internalServerError must be a plain object.');
    const {
      title = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Internal Server Error', 'google-site-kit'),
      format = 'small',
      type = 'win-error',
      ...props
    } = error;
    return {
      type: SET_SERVER_ERROR,
      payload: {
        internalServerError: {
          title,
          format,
          type,
          ...props
        }
      }
    };
  },
  /**
   * Clears the internal server error, if one was previously set.
   *
   * @since 1.38.0
   *
   * @return {Object} Redux-style action.
   */
  clearInternalServerError() {
    return {
      type: CLEAR_SERVER_ERROR
    };
  }
};
const baseReducer = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__.createReducer)((state, {
  type,
  payload
}) => {
  switch (type) {
    case SET_SERVER_ERROR:
      state.internalServerError = payload.internalServerError;
      break;
    case CLEAR_SERVER_ERROR:
      state.internalServerError = undefined;
      break;
    default:
      break;
  }
});
const baseResolvers = {};
const baseSelectors = {
  /**
   * Gets the internal server error.
   *
   * @since 1.38.0
   * @private
   *
   * @param {Object} state Data store's state.
   * @return {(Object|undefined)} Error info.
   */
  getInternalServerError(state) {
    return state.internalServerError;
  }
};
const store = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__.combineStores)({
  initialState: baseInitialState,
  actions: baseActions,
  reducer: baseReducer,
  resolvers: baseResolvers,
  selectors: baseSelectors
});
const initialState = store.initialState;
const actions = store.actions;
const controls = store.controls;
const reducer = store.reducer;
const resolvers = store.resolvers;
const selectors = store.selectors;
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (store);

/***/ }),

/***/ "./js/googlesitekit/datastore/site/google-tag-gateway.js":
/*!***************************************************************!*\
  !*** ./js/googlesitekit/datastore/site/google-tag-gateway.js ***!
  \***************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   actions: () => (/* binding */ actions),
/* harmony export */   controls: () => (/* binding */ controls),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   initialState: () => (/* binding */ initialState),
/* harmony export */   reducer: () => (/* binding */ reducer),
/* harmony export */   resolvers: () => (/* binding */ resolvers),
/* harmony export */   selectors: () => (/* binding */ selectors)
/* harmony export */ });
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! lodash */ "../node_modules/lodash/lodash.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var invariant__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! invariant */ "../node_modules/invariant/browser.js");
/* harmony import */ var invariant__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(invariant__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var googlesitekit_api__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! googlesitekit-api */ "googlesitekit-api");
/* harmony import */ var googlesitekit_api__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_api__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./constants */ "./js/googlesitekit/datastore/site/constants.js");
/* harmony import */ var _js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/googlesitekit/datastore/user/constants */ "./js/googlesitekit/datastore/user/constants.js");
/* harmony import */ var _js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @/js/googlesitekit/modules/datastore/constants */ "./js/googlesitekit/modules/datastore/constants.js");
/* harmony import */ var _js_modules_ads_constants__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @/js/modules/ads/constants */ "./js/modules/ads/constants.js");
/* harmony import */ var _js_modules_analytics_4_constants__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @/js/modules/analytics-4/constants */ "./js/modules/analytics-4/constants.js");
/* harmony import */ var _js_googlesitekit_data_create_fetch_store__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @/js/googlesitekit/data/create-fetch-store */ "./js/googlesitekit/data/create-fetch-store.js");
/* harmony import */ var _js_features__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @/js/features */ "./js/features/index.js");
/* harmony import */ var _js_modules_tagmanager_constants__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @/js/modules/tagmanager/constants */ "./js/modules/tagmanager/constants.js");
/**
 * `core/site` data store: google-tag-gateway.
 *
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/* eslint-disable sitekit/jsdoc-no-unnamed-boolean-params */

/**
 * External dependencies
 */



/**
 * Internal dependencies
 */










const SET_GOOGLE_TAG_GATEWAY_ENABLED = 'SET_GOOGLE_TAG_GATEWAY_ENABLED';
const RESET_GOOGLE_TAG_GATEWAY_SETTINGS = 'RESET_GOOGLE_TAG_GATEWAY_SETTINGS';
const settingsReducerCallback = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__.createReducer)((state, googleTagGatewaySettings) => {
  state.googleTagGatewaySettings = googleTagGatewaySettings;
  state.googleTagGatewaySavedSettings = googleTagGatewaySettings;
});
const fetchGetGoogleTagGatewaySettingsStore = (0,_js_googlesitekit_data_create_fetch_store__WEBPACK_IMPORTED_MODULE_9__.createFetchStore)({
  baseName: 'getGoogleTagGatewaySettings',
  controlCallback: () => (0,googlesitekit_api__WEBPACK_IMPORTED_MODULE_2__.get)('core', 'site', 'gtg-settings', undefined, {
    useCache: false
  }),
  reducerCallback: settingsReducerCallback
});
const fetchSaveGoogleTagGatewaySettingsStore = (0,_js_googlesitekit_data_create_fetch_store__WEBPACK_IMPORTED_MODULE_9__.createFetchStore)({
  baseName: 'saveGoogleTagGatewaySettings',
  controlCallback: ({
    settings
  }) => {
    return (0,googlesitekit_api__WEBPACK_IMPORTED_MODULE_2__.set)('core', 'site', 'gtg-settings', {
      settings
    });
  },
  reducerCallback: settingsReducerCallback,
  argsToParams: settings => {
    const {
      isEnabled
    } = settings || {};
    return {
      settings: {
        isEnabled
      }
    };
  },
  validateParams: ({
    settings
  }) => {
    invariant__WEBPACK_IMPORTED_MODULE_1___default()((0,lodash__WEBPACK_IMPORTED_MODULE_0__.isPlainObject)(settings), 'settings must be a plain object.');
    invariant__WEBPACK_IMPORTED_MODULE_1___default()(typeof settings.isEnabled === 'boolean', 'isEnabled must be a boolean.');
    invariant__WEBPACK_IMPORTED_MODULE_1___default()(Object.keys(settings).length === 1, 'settings must have only the `isEnabled` property.');
  }
});
const fetchGetGTGServerRequirementStatusStore = (0,_js_googlesitekit_data_create_fetch_store__WEBPACK_IMPORTED_MODULE_9__.createFetchStore)({
  baseName: 'getGTGServerRequirementStatus',
  controlCallback: () => (0,googlesitekit_api__WEBPACK_IMPORTED_MODULE_2__.get)('core', 'site', 'gtg-server-requirement-status', undefined, {
    useCache: false
  }),
  reducerCallback: settingsReducerCallback
});
const baseInitialState = {
  googleTagGatewaySettings: undefined,
  googleTagGatewaySavedSettings: undefined
};
const baseActions = {
  /**
   * Saves the Google tag gateway settings.
   *
   * @since 1.141.0
   * @since 1.145.0 Added the survey trigger.
   * @since 1.157.0 Renamed from `saveFirstPartyModeSettings` to `saveGoogleTagGatewaySettings`.
   *
   * @return {Object} Object with `response` and `error`.
   */
  *saveGoogleTagGatewaySettings() {
    const {
      dispatch,
      select
    } = yield googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__.commonActions.getRegistry();
    const settings = select(_constants__WEBPACK_IMPORTED_MODULE_4__.CORE_SITE).getGoogleTagGatewaySettings();
    const results = yield fetchSaveGoogleTagGatewaySettingsStore.actions.fetchSaveGoogleTagGatewaySettings(settings);
    if (results?.response?.isEnabled) {
      yield googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__.commonActions.await(dispatch(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_5__.CORE_USER).triggerSurvey('gtg_setup_completed'));
    }
    return results;
  },
  /**
   * Sets the Google tag gateway enabled status.
   *
   * @since 1.141.0
   * @since 1.157.0 Renamed from `setFirstPartyModeEnabled` to `setGoogleTagGatewayEnabled`.
   *
   * @param {boolean} isEnabled Google tag gateway enabled status.
   * @return {Object} Redux-style action.
   */
  setGoogleTagGatewayEnabled(isEnabled) {
    return {
      type: SET_GOOGLE_TAG_GATEWAY_ENABLED,
      payload: {
        isEnabled
      }
    };
  },
  /**
   * Returns the current settings back to the current saved values.
   *
   * @since 1.142.0
   * @since 1.157.0 Renamed from `resetFirstPartyModeSettings` to `resetGoogleTagGatewaySettings`.
   *
   * @return {Object} Redux-style action.
   */
  resetGoogleTagGatewaySettings() {
    return {
      payload: {},
      type: RESET_GOOGLE_TAG_GATEWAY_SETTINGS
    };
  }
};
const baseControls = {};
const baseReducer = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__.createReducer)((state, {
  type,
  payload
}) => {
  switch (type) {
    case SET_GOOGLE_TAG_GATEWAY_ENABLED:
      {
        state.googleTagGatewaySettings = state.googleTagGatewaySettings || {};
        state.googleTagGatewaySettings.isEnabled = !!payload.isEnabled;
        break;
      }
    case RESET_GOOGLE_TAG_GATEWAY_SETTINGS:
      {
        state.googleTagGatewaySettings = state.googleTagGatewaySavedSettings;
        break;
      }
    default:
      break;
  }
});
const baseResolvers = {
  *getGoogleTagGatewaySettings() {
    const {
      select
    } = yield googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__.commonActions.getRegistry();
    const settings = select(_constants__WEBPACK_IMPORTED_MODULE_4__.CORE_SITE).getGoogleTagGatewaySettings();
    if (settings === undefined) {
      yield fetchGetGoogleTagGatewaySettingsStore.actions.fetchGetGoogleTagGatewaySettings();
    }
  }
};
const baseSelectors = {
  /**
   * Gets the Google tag gateway settings.
   *
   * @since 1.141.0
   * @since 1.157.0 Renamed from `getFirstPartyModeSettings` to `getGoogleTagGatewaySettings`.
   *
   * @param {Object} state Data store's state.
   * @return {Object|undefined} Google tag gateway settings, or undefined if not loaded.
   */
  getGoogleTagGatewaySettings: state => {
    return state.googleTagGatewaySettings;
  },
  /**
   * Checks if Google tag gateway is enabled.
   *
   * @since 1.141.0
   * @since 1.157.0 Renamed from `isFirstPartyModeEnabled` to `isGoogleTagGatewayEnabled`.
   *
   * @param {Object} state Data store's state.
   * @return {boolean|undefined} True if Google tag gateway is enabled, otherwise false. Returns undefined if the state is not loaded.
   */
  isGoogleTagGatewayEnabled: (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__.createRegistrySelector)(select => () => {
    const {
      isEnabled
    } = select(_constants__WEBPACK_IMPORTED_MODULE_4__.CORE_SITE).getGoogleTagGatewaySettings() || {};
    return isEnabled;
  }),
  /**
   * Checks if the GTG service is determined to be healthy.
   *
   * @since 1.141.0
   * @since 1.157.0 Renamed from `isFPMHealthy` to `isGTGHealthy`.
   *
   * @param {Object} state Data store's state.
   * @return {boolean|null|undefined} True if the GTG service is healthy, otherwise false. Returns undefined if the state is not loaded.
   */
  isGTGHealthy: (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__.createRegistrySelector)(select => () => {
    const {
      isGTGHealthy
    } = select(_constants__WEBPACK_IMPORTED_MODULE_4__.CORE_SITE).getGoogleTagGatewaySettings() || {};
    return isGTGHealthy;
  }),
  /**
   * Checks if the GTag proxy script is accessible.
   *
   * @since 1.141.0
   *
   * @param {Object} state Data store's state.
   * @return {boolean|null|undefined} True if the `gtg/measurement.php` proxy script is accessible, otherwise false. Returns undefined if the state is not loaded.
   */
  isScriptAccessEnabled: (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__.createRegistrySelector)(select => () => {
    const {
      isScriptAccessEnabled
    } = select(_constants__WEBPACK_IMPORTED_MODULE_4__.CORE_SITE).getGoogleTagGatewaySettings() || {};
    return isScriptAccessEnabled;
  }),
  /**
   * Indicates whether the current Google tag gateway settings have changed from what is saved.
   *
   * @since 1.142.0
   * @since 1.157.0 Renamed from `haveFirstPartyModeSettingsChanged` to `haveGoogleTagGatewaySettingsChanged`.
   *
   * @param {Object} state Data store's state.
   * @return {boolean} True if the settings have changed, false otherwise.
   */
  haveGoogleTagGatewaySettingsChanged(state) {
    const {
      googleTagGatewaySettings,
      googleTagGatewaySavedSettings
    } = state;
    return !(0,lodash__WEBPACK_IMPORTED_MODULE_0__.isEqual)(googleTagGatewaySettings, googleTagGatewaySavedSettings);
  },
  /**
   * Checks if any Google tag gateway module is connected.
   *
   * @since 1.157.0
   *
   * @param {Object} state Data store's state.
   * @return {boolean} True if any Google tag gateway module is connected, false otherwise.
   */
  isAnyGoogleTagGatewayModuleConnected: (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__.createRegistrySelector)(select => () => {
    if (!(0,_js_features__WEBPACK_IMPORTED_MODULE_10__.isFeatureEnabled)('googleTagGateway')) {
      return false;
    }
    const {
      isModuleConnected
    } = select(_js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_6__.CORE_MODULES);
    return isModuleConnected(_js_modules_analytics_4_constants__WEBPACK_IMPORTED_MODULE_8__.MODULE_SLUG_ANALYTICS_4) || isModuleConnected(_js_modules_ads_constants__WEBPACK_IMPORTED_MODULE_7__.MODULE_SLUG_ADS) || isModuleConnected(_js_modules_tagmanager_constants__WEBPACK_IMPORTED_MODULE_11__.MODULE_SLUG_TAGMANAGER);
  })
};
const store = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__.combineStores)(fetchGetGoogleTagGatewaySettingsStore, fetchSaveGoogleTagGatewaySettingsStore, fetchGetGTGServerRequirementStatusStore, {
  initialState: baseInitialState,
  actions: baseActions,
  controls: baseControls,
  reducer: baseReducer,
  resolvers: baseResolvers,
  selectors: baseSelectors
});
const initialState = store.initialState;
const actions = store.actions;
const controls = store.controls;
const reducer = store.reducer;
const resolvers = store.resolvers;
const selectors = store.selectors;
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (store);

/***/ }),

/***/ "./js/googlesitekit/datastore/site/html.js":
/*!*************************************************!*\
  !*** ./js/googlesitekit/datastore/site/html.js ***!
  \*************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   actions: () => (/* binding */ actions),
/* harmony export */   baseInitialState: () => (/* binding */ baseInitialState),
/* harmony export */   baseResolvers: () => (/* binding */ baseResolvers),
/* harmony export */   baseSelectors: () => (/* binding */ baseSelectors),
/* harmony export */   controls: () => (/* binding */ controls),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   initialState: () => (/* binding */ initialState),
/* harmony export */   reducer: () => (/* binding */ reducer),
/* harmony export */   resolvers: () => (/* binding */ resolvers),
/* harmony export */   selectors: () => (/* binding */ selectors)
/* harmony export */ });
/* harmony import */ var invariant__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! invariant */ "../node_modules/invariant/browser.js");
/* harmony import */ var invariant__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(invariant__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_url__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @wordpress/url */ "../node_modules/@wordpress/url/build-module/is-url.js");
/* harmony import */ var _wordpress_url__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @wordpress/url */ "../node_modules/@wordpress/url/build-module/add-query-args.js");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var googlesitekit_api__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! googlesitekit-api */ "googlesitekit-api");
/* harmony import */ var googlesitekit_api__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_api__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./constants */ "./js/googlesitekit/datastore/site/constants.js");
/* harmony import */ var _js_googlesitekit_data_create_fetch_store__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/googlesitekit/data/create-fetch-store */ "./js/googlesitekit/data/create-fetch-store.js");
/* harmony import */ var _js_util_tag__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/util/tag */ "./js/util/tag.js");
/**
 * `core/site` data store: HTML for URL.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */





const fetchHTMLForURLStore = (0,_js_googlesitekit_data_create_fetch_store__WEBPACK_IMPORTED_MODULE_4__.createFetchStore)({
  baseName: 'getHTMLForURL',
  argsToParams: url => {
    return {
      url
    };
  },
  validateParams: ({
    url
  } = {}) => {
    invariant__WEBPACK_IMPORTED_MODULE_0___default()((0,_wordpress_url__WEBPACK_IMPORTED_MODULE_6__.isURL)(url), 'a valid url is required to fetch HTML.');
  },
  controlCallback: async ({
    url
  }) => {
    const fetchHTMLOptions = {
      credentials: 'omit'
    };
    const fetchHTMLQueryArgs = {
      // Indicates a tag checking request. This lets Site Kit know not to output its own tags.
      tagverify: 1,
      // Add a timestamp for cache-busting.
      //
      // This value is used for cache-busting, so we don't want to rely on
      // the reference date. We should always use the current time.
      timestamp: Date.now() // eslint-disable-line sitekit/no-direct-date
    };
    const response = await fetch((0,_wordpress_url__WEBPACK_IMPORTED_MODULE_7__.addQueryArgs)(url, fetchHTMLQueryArgs), fetchHTMLOptions);

    // If response contains HTML, return that. Return null in other cases.
    try {
      const html = await response.text();
      if (html === '' || html === undefined) {
        return null;
      }
      return html;
    } catch {
      return null;
    }
  },
  reducerCallback: (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.createReducer)((state, htmlForURL, {
    url
  }) => {
    state.htmlForURL[url] = htmlForURL;
  })
});

// Actions
const RESET_HTML_FOR_URL = 'RESET_HTML_FOR_URL';
const CHECK_FOR_SETUP_TAG = 'CHECK_FOR_SETUP_TAG';

// Errors
const ERROR_FETCH_FAIL = 'check_fetch_failed';
const ERROR_TOKEN_MISMATCH = 'setup_token_mismatch';
const baseInitialState = {
  htmlForURL: {}
};
const baseActions = {
  /**
   * Resets the HTML for a given URL.
   *
   * @since 1.13.0
   * @private
   *
   * @param {string} url URL for which the HTML should be reset.
   * @return {Object} Redux-style action.
   */
  *resetHTMLForURL(url) {
    const {
      dispatch
    } = yield googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.commonActions.getRegistry();
    yield {
      payload: {
        url
      },
      type: RESET_HTML_FOR_URL
    };
    return dispatch(_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_SITE).invalidateResolutionForStoreSelector('getHTMLForURL');
  },
  *checkForSetupTag() {
    return yield {
      payload: {},
      type: CHECK_FOR_SETUP_TAG
    };
  }
};
const baseControls = {
  [CHECK_FOR_SETUP_TAG]: (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.createRegistryControl)(registry => async () => {
    let error;
    let response;
    let token;
    let tokenMatch = false;
    try {
      ({
        token
      } = await (0,googlesitekit_api__WEBPACK_IMPORTED_MODULE_2__.set)('core', 'site', 'setup-tag'));
      const homeURL = await registry.select(_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_SITE).getHomeURL();
      ({
        response,
        error
      } = await registry.dispatch(_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_SITE).fetchGetHTMLForURL(homeURL));
    } catch {
      error = ERROR_FETCH_FAIL;
    }
    if (!error) {
      const scrapedTag = (0,_js_util_tag__WEBPACK_IMPORTED_MODULE_5__.extractExistingTag)(response, [/<meta name="googlesitekit-setup" content="([a-z0-9-]+)"/]);
      tokenMatch = token === scrapedTag;
      if (!tokenMatch) {
        error = ERROR_TOKEN_MISMATCH;
      }
    }
    return {
      response: tokenMatch,
      error
    };
  })
};
const baseReducer = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.createReducer)((state, {
  type,
  payload
}) => {
  switch (type) {
    case RESET_HTML_FOR_URL:
      const {
        url
      } = payload;
      state.htmlForURL[url] = undefined;
      break;
    default:
      break;
  }
});
const baseResolvers = {
  *getHTMLForURL(url) {
    const registry = yield googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.commonActions.getRegistry();
    const existingHTML = registry.select(_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_SITE).getHTMLForURL(url);
    if (existingHTML === undefined) {
      yield fetchHTMLForURLStore.actions.fetchGetHTMLForURL(url);
    }
  }
};
const baseSelectors = {
  /**
   * Gets the HTML for a given URL.
   *
   * Returns `undefined` if the HTML is not available/loaded.
   *
   * Returns a string representation of the HTML when successful.
   *
   * @since 1.13.0
   * @private
   *
   * @param {Object} state Data store's state.
   * @param {string} url   URL for which to fetch HTML.
   * @return {(string|undefined)} String representation of HTML for given URL, or `undefined` if not loaded yet.
   */
  getHTMLForURL(state, url) {
    return state.htmlForURL[url];
  }
};
const store = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.combineStores)(fetchHTMLForURLStore, {
  initialState: baseInitialState,
  actions: baseActions,
  controls: baseControls,
  reducer: baseReducer,
  resolvers: baseResolvers,
  selectors: baseSelectors
});
const initialState = store.initialState;
const actions = store.actions;
const controls = store.controls;
const reducer = store.reducer;
const resolvers = store.resolvers;
const selectors = store.selectors;
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (store);

/***/ }),

/***/ "./js/googlesitekit/datastore/site/index.js":
/*!**************************************************!*\
  !*** ./js/googlesitekit/datastore/site/index.js ***!
  \**************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   actions: () => (/* binding */ actions),
/* harmony export */   controls: () => (/* binding */ controls),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   initialState: () => (/* binding */ initialState),
/* harmony export */   reducer: () => (/* binding */ reducer),
/* harmony export */   registerStore: () => (/* binding */ registerStore),
/* harmony export */   resolvers: () => (/* binding */ resolvers),
/* harmony export */   selectors: () => (/* binding */ selectors)
/* harmony export */ });
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _js_googlesitekit_data_create_error_store__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/googlesitekit/data/create-error-store */ "./js/googlesitekit/data/create-error-store.js");
/* harmony import */ var _js_googlesitekit_data_create_snapshot_store__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/googlesitekit/data/create-snapshot-store */ "./js/googlesitekit/data/create-snapshot-store.js");
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./constants */ "./js/googlesitekit/datastore/site/constants.js");
/* harmony import */ var _cache__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./cache */ "./js/googlesitekit/datastore/site/cache.js");
/* harmony import */ var _connection__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./connection */ "./js/googlesitekit/datastore/site/connection.js");
/* harmony import */ var _consent_mode__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./consent-mode */ "./js/googlesitekit/datastore/site/consent-mode.js");
/* harmony import */ var _conversion_tracking__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./conversion-tracking */ "./js/googlesitekit/datastore/site/conversion-tracking.js");
/* harmony import */ var _email_reporting__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./email-reporting */ "./js/googlesitekit/datastore/site/email-reporting.js");
/* harmony import */ var _errors__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./errors */ "./js/googlesitekit/datastore/site/errors.js");
/* harmony import */ var _google_tag_gateway__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./google-tag-gateway */ "./js/googlesitekit/datastore/site/google-tag-gateway.js");
/* harmony import */ var _html__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./html */ "./js/googlesitekit/datastore/site/html.js");
/* harmony import */ var _info__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ./info */ "./js/googlesitekit/datastore/site/info.js");
/* harmony import */ var _reset__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ./reset */ "./js/googlesitekit/datastore/site/reset.js");
/* harmony import */ var _enable_auto_update__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ./enable-auto-update */ "./js/googlesitekit/datastore/site/enable-auto-update.js");
/* harmony import */ var _settings__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ./settings */ "./js/googlesitekit/datastore/site/settings.js");
/* harmony import */ var _urls__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ./urls */ "./js/googlesitekit/datastore/site/urls.js");
/* harmony import */ var _developer_plugin__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! ./developer-plugin */ "./js/googlesitekit/datastore/site/developer-plugin.js");
/* harmony import */ var _notifications__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! ./notifications */ "./js/googlesitekit/datastore/site/notifications.js");
/**
 * `core/site` data store
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Internal dependencies
 */



















const store = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.combineStores)(googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.commonStore, _connection__WEBPACK_IMPORTED_MODULE_5__["default"], _consent_mode__WEBPACK_IMPORTED_MODULE_6__["default"], _conversion_tracking__WEBPACK_IMPORTED_MODULE_7__["default"], _email_reporting__WEBPACK_IMPORTED_MODULE_8__["default"], _errors__WEBPACK_IMPORTED_MODULE_9__["default"], _google_tag_gateway__WEBPACK_IMPORTED_MODULE_10__["default"], _html__WEBPACK_IMPORTED_MODULE_11__["default"], _info__WEBPACK_IMPORTED_MODULE_12__["default"], _developer_plugin__WEBPACK_IMPORTED_MODULE_17__["default"], _reset__WEBPACK_IMPORTED_MODULE_13__["default"], _enable_auto_update__WEBPACK_IMPORTED_MODULE_14__["default"], _settings__WEBPACK_IMPORTED_MODULE_15__["default"], _urls__WEBPACK_IMPORTED_MODULE_16__["default"], _notifications__WEBPACK_IMPORTED_MODULE_18__["default"], _cache__WEBPACK_IMPORTED_MODULE_4__["default"], (0,_js_googlesitekit_data_create_error_store__WEBPACK_IMPORTED_MODULE_1__.createErrorStore)(_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_SITE), (0,_js_googlesitekit_data_create_snapshot_store__WEBPACK_IMPORTED_MODULE_2__.createSnapshotStore)(_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_SITE, {
  pick: ['conversionTracking']
}));
const initialState = store.initialState;
const actions = store.actions;
const controls = store.controls;
const reducer = store.reducer;
const resolvers = store.resolvers;
const selectors = store.selectors;
function registerStore(registry) {
  registry.registerStore(_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_SITE, store);
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (store);

/***/ }),

/***/ "./js/googlesitekit/datastore/site/info.js":
/*!*************************************************!*\
  !*** ./js/googlesitekit/datastore/site/info.js ***!
  \*************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   actions: () => (/* binding */ actions),
/* harmony export */   controls: () => (/* binding */ controls),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   initialState: () => (/* binding */ initialState),
/* harmony export */   reducer: () => (/* binding */ reducer),
/* harmony export */   resolvers: () => (/* binding */ resolvers),
/* harmony export */   selectors: () => (/* binding */ selectors)
/* harmony export */ });
/* harmony import */ var invariant__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! invariant */ "../node_modules/invariant/browser.js");
/* harmony import */ var invariant__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(invariant__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var query_string__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! query-string */ "../node_modules/query-string/index.js");
/* harmony import */ var _wordpress_url__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @wordpress/url */ "../node_modules/@wordpress/url/build-module/add-query-args.js");
/* harmony import */ var _wordpress_url__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @wordpress/url */ "../node_modules/@wordpress/url/build-module/get-query-arg.js");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./constants */ "./js/googlesitekit/datastore/site/constants.js");
/* harmony import */ var _js_util__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/util */ "./js/util/index.js");
/* harmony import */ var _js_util_negate__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/util/negate */ "./js/util/negate.js");
/**
 * `core/site` data store: site info.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/* eslint-disable sitekit/jsdoc-no-unnamed-boolean-params */

/**
 * External dependencies
 */



/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */




function getSiteInfoProperty(propName) {
  return (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.createRegistrySelector)(select => () => {
    const siteInfo = select(_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_SITE).getSiteInfo() || {};
    return siteInfo[propName];
  });
}

// Actions
const RECEIVE_SITE_INFO = 'RECEIVE_SITE_INFO';
const RECEIVE_PERMALINK_PARAM = 'RECEIVE_PERMALINK_PARAM';
const SET_SITE_KIT_AUTO_UPDATES_ENABLED = 'SET_SITE_KIT_AUTO_UPDATES_ENABLED';
const SET_KEY_METRICS_SETUP_COMPLETED_BY = 'SET_KEY_METRICS_SETUP_COMPLETED_BY';
const SET_SETUP_ERROR_CODE = 'SET_SETUP_ERROR_CODE';
const initialState = {
  siteInfo: undefined,
  permaLink: false
};
const actions = {
  /**
   * Stores site info in the datastore.
   *
   * Because this is frequently-accessed data, this is usually sourced
   * from a global variable (`_googlesitekitSiteData`), set by PHP
   * in the `before_print` callback for `googlesitekit-datastore-site`.
   *
   * @since 1.7.0
   * @private
   *
   * @param {Object} siteInfo Site info, usually supplied via a global variable from PHP.
   * @return {Object} Redux-style action.
   */
  receiveSiteInfo(siteInfo) {
    invariant__WEBPACK_IMPORTED_MODULE_0___default()(siteInfo, 'siteInfo is required.');
    return {
      payload: {
        siteInfo
      },
      type: RECEIVE_SITE_INFO
    };
  },
  receivePermaLinkParam(permaLink) {
    invariant__WEBPACK_IMPORTED_MODULE_0___default()(permaLink, 'permaLink is required.');
    return {
      payload: {
        permaLink
      },
      type: RECEIVE_PERMALINK_PARAM
    };
  },
  /**
   * Sets `siteKitAutoUpdatesEnabled` value; if set to `true` this will
   * enable auto-updates for Site Kit. Set to `false` to disable this
   * behaviour.
   *
   * @since 1.93.0
   *
   * @param {boolean} siteKitAutoUpdatesEnabled Whether Site Kit auto-updates are enabled.
   * @return {Object} Redux-style action.
   */
  setSiteKitAutoUpdatesEnabled(siteKitAutoUpdatesEnabled) {
    invariant__WEBPACK_IMPORTED_MODULE_0___default()(typeof siteKitAutoUpdatesEnabled === 'boolean', 'siteKitAutoUpdatesEnabled must be a boolean.');
    return {
      payload: {
        siteKitAutoUpdatesEnabled
      },
      type: SET_SITE_KIT_AUTO_UPDATES_ENABLED
    };
  },
  /**
   * Sets the `setKeyMetricsSetupCompletedBy` value.
   *
   * @since 1.113.0
   *
   * @param {number} keyMetricsSetupCompletedBy Positive integer if key metrics setup is completed, otherwise 0.
   * @return {Object} Redux-style action.
   */
  setKeyMetricsSetupCompletedBy(keyMetricsSetupCompletedBy) {
    invariant__WEBPACK_IMPORTED_MODULE_0___default()(typeof keyMetricsSetupCompletedBy === 'number', 'keyMetricsSetupCompletedBy must be a number.');
    return {
      payload: {
        keyMetricsSetupCompletedBy
      },
      type: SET_KEY_METRICS_SETUP_COMPLETED_BY
    };
  },
  /**
   * Sets `setupErrorCode` value.
   *
   * @since 1.131.0
   *
   * @param {string|null} setupErrorCode Error code from setup, or `null` if no error.
   * @return {Object} Redux-style action.
   */
  setSetupErrorCode(setupErrorCode) {
    // setupErrorCode can be a string or null.
    invariant__WEBPACK_IMPORTED_MODULE_0___default()(typeof setupErrorCode === 'string' || setupErrorCode === null, 'setupErrorCode must be a string or null.');
    return {
      payload: {
        setupErrorCode
      },
      type: SET_SETUP_ERROR_CODE
    };
  }
};
const controls = {};
const reducer = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.createReducer)((state, {
  payload,
  type
}) => {
  switch (type) {
    case RECEIVE_SITE_INFO:
      const {
        adminURL,
        ampMode,
        currentEntityID,
        currentEntityTitle,
        currentEntityType,
        currentEntityURL,
        homeURL,
        proxyPermissionsURL,
        proxySetupURL,
        referenceSiteURL,
        setupErrorCode,
        setupErrorMessage,
        setupErrorRedoURL,
        siteName,
        siteLocale,
        timezone,
        startOfWeek,
        usingProxy,
        webStoriesActive,
        proxySupportLinkURL,
        widgetsAdminURL,
        postTypes,
        wpVersion,
        updateCoreURL,
        changePluginAutoUpdatesCapacity,
        siteKitAutoUpdatesEnabled,
        pluginBasename,
        productPostType,
        keyMetricsSetupCompletedBy,
        keyMetricsSetupNew,
        consentModeRegions,
        anyoneCanRegister,
        isMultisite
      } = payload.siteInfo;
      state.siteInfo = {
        adminURL,
        ampMode,
        currentEntityID: parseInt(currentEntityID, 10),
        currentEntityTitle,
        currentEntityType,
        currentEntityURL,
        homeURL,
        proxyPermissionsURL,
        proxySetupURL,
        referenceSiteURL,
        setupErrorCode,
        setupErrorMessage,
        setupErrorRedoURL,
        siteName,
        siteLocale,
        timezone,
        startOfWeek,
        usingProxy,
        webStoriesActive,
        proxySupportLinkURL,
        widgetsAdminURL,
        postTypes,
        wpVersion,
        updateCoreURL,
        changePluginAutoUpdatesCapacity,
        siteKitAutoUpdatesEnabled,
        pluginBasename,
        productPostType,
        keyMetricsSetupCompletedBy,
        keyMetricsSetupNew,
        consentModeRegions,
        anyoneCanRegister,
        isMultisite
      };
      break;
    case RECEIVE_PERMALINK_PARAM:
      {
        state.permaLink = payload.permaLink;
        break;
      }
    case SET_SITE_KIT_AUTO_UPDATES_ENABLED:
      {
        if (!state.siteInfo) {
          state.siteInfo = {};
        }
        state.siteInfo.siteKitAutoUpdatesEnabled = payload.siteKitAutoUpdatesEnabled;
        break;
      }
    case SET_KEY_METRICS_SETUP_COMPLETED_BY:
      {
        if (!state.siteInfo) {
          state.siteInfo = {};
        }
        state.siteInfo.keyMetricsSetupCompletedBy = payload.keyMetricsSetupCompletedBy;
        break;
      }
    case SET_SETUP_ERROR_CODE:
      {
        if (!state.siteInfo) {
          state.siteInfo = {};
        }
        state.siteInfo.setupErrorCode = payload.setupErrorCode;
        break;
      }
    default:
      break;
  }
});
const resolvers = {
  *getSiteInfo() {
    const registry = yield googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.commonActions.getRegistry();
    if (registry.select(_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_SITE).getSiteInfo()) {
      return;
    }
    if (!__webpack_require__.g._googlesitekitBaseData || !__webpack_require__.g._googlesitekitEntityData) {
      __webpack_require__.g.console.error('Could not load core/site info.');
      return;
    }
    const {
      adminURL,
      ampMode,
      homeURL,
      proxyPermissionsURL,
      proxySetupURL,
      referenceSiteURL,
      setupErrorCode,
      setupErrorMessage,
      setupErrorRedoURL,
      siteName,
      siteLocale,
      timezone,
      startOfWeek,
      usingProxy,
      webStoriesActive,
      proxySupportLinkURL,
      widgetsAdminURL,
      postTypes,
      wpVersion,
      updateCoreURL,
      changePluginAutoUpdatesCapacity,
      siteKitAutoUpdatesEnabled,
      pluginBasename,
      productPostType,
      keyMetricsSetupCompletedBy,
      keyMetricsSetupNew,
      consentModeRegions,
      anyoneCanRegister,
      isMultisite
    } = __webpack_require__.g._googlesitekitBaseData;
    const {
      currentEntityID,
      currentEntityTitle,
      currentEntityType,
      currentEntityURL
    } = __webpack_require__.g._googlesitekitEntityData;
    yield actions.receiveSiteInfo({
      adminURL,
      ampMode,
      currentEntityID,
      currentEntityTitle,
      currentEntityType,
      currentEntityURL,
      homeURL,
      proxyPermissionsURL,
      proxySetupURL,
      referenceSiteURL,
      setupErrorCode,
      setupErrorMessage,
      setupErrorRedoURL,
      siteName,
      siteLocale,
      timezone,
      startOfWeek,
      postTypes,
      usingProxy: !!usingProxy,
      webStoriesActive,
      proxySupportLinkURL,
      widgetsAdminURL,
      wpVersion,
      updateCoreURL,
      changePluginAutoUpdatesCapacity,
      siteKitAutoUpdatesEnabled,
      pluginBasename,
      productPostType,
      keyMetricsSetupCompletedBy,
      keyMetricsSetupNew,
      consentModeRegions,
      anyoneCanRegister,
      isMultisite
    });
  }
};
const selectors = {
  /**
   * Gets all site info from this data store.
   *
   * Not intended to be used publicly; this is largely here so other selectors can
   * request data using the selector/resolver pattern.
   *
   * @since 1.7.0
   * @private
   *
   * @param {Object} state Data store's state.
   * @return {(Object|undefined)} Site connection info.
   */
  getSiteInfo(state) {
    return state.siteInfo;
  },
  /**
   * Gets a site's admin URL.
   *
   * @since 1.7.0
   *
   * @param {Object}             state Data store's state.
   * @param {(string|undefined)} page  Optional page query argument ( Simple format: 'test-page' or Full format: 'custom.php?page=test-page' ) to add to admin URL. If not provided, the base admin URL is returned.
   * @param {(Object|undefined)} args  Optional additional query arguments to add to admin URL.
   * @return {(string|undefined)} This site's admin URL.
   */
  getAdminURL: (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.createRegistrySelector)(select => (state, page, args = {}) => {
    const {
      adminURL
    } = select(_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_SITE).getSiteInfo() || {};

    // Return adminURL if undefined, or if no page supplied.
    if (adminURL === undefined || page === undefined) {
      return adminURL;
    }
    const baseURL = adminURL[adminURL.length - 1] === '/' ? adminURL : `${adminURL}/`;
    let pageArg = page;
    let phpFile = 'admin.php';

    // If page argument is full format (i.e. 'admin.php?page=google-site-kit'), extract php file and pageArg, returning early with adminURL if no 'page' param found.
    if (page.indexOf('.php?') !== -1) {
      const splitPage = page.split('?');
      pageArg = query_string__WEBPACK_IMPORTED_MODULE_1__.parse(splitPage.pop()).page;
      if (!pageArg) {
        return adminURL;
      }
      phpFile = splitPage.shift();
    }

    // Since page should be first query arg, create queryArgs without 'page' to prevent a 'page' in args from overriding it.
    const {
      page: extraPage,
      ...queryArgs
    } = args; // eslint-disable-line no-unused-vars

    return (0,_wordpress_url__WEBPACK_IMPORTED_MODULE_6__.addQueryArgs)(`${baseURL}${phpFile}`, {
      page: pageArg,
      ...queryArgs
    });
  }),
  /**
   * Gets a site's AMP mode.
   *
   * @since 1.7.0
   *
   * @param {Object} state Data store's state.
   * @return {(string|undefined)} AMP Mode.
   */
  getAMPMode: getSiteInfoProperty('ampMode'),
  /**
   * Gets the current entity's ID.
   *
   * @since 1.7.0
   *
   * @param {Object} state Data store's state.
   * @return {(number|null|undefined)} Current entity's ID, null if there is
   *                                   none, undefined if not loaded yet.
   */
  getCurrentEntityID: getSiteInfoProperty('currentEntityID'),
  /**
   * Gets the current entity's title.
   *
   * @since 1.7.0
   *
   * @param {Object} state Data store's state.
   * @return {(string|null|undefined)} Current entity's title, null if there
   *                                   is none, undefined if not loaded yet.
   */
  getCurrentEntityTitle: getSiteInfoProperty('currentEntityTitle'),
  /**
   * Gets the current entity's title.
   *
   * @since 1.7.0
   *
   * @param {Object} state Data store's state.
   * @return {(string|null|undefined)} Current entity's type, null if there
   *                                   is none, undefined if not loaded yet.
   */
  getCurrentEntityType: getSiteInfoProperty('currentEntityType'),
  /**
   * Gets the current entity's reference URL.
   *
   * @since 1.7.0
   *
   * @param {Object} state Data store's state.
   * @return {(string|null|undefined)} Current entity's URL, null if there is
   *                                   none, undefined if not loaded yet.
   */
  getCurrentEntityURL: getSiteInfoProperty('currentEntityURL'),
  /**
   * Gets a site's homepage URL.
   *
   * @since 1.7.0
   *
   * @param {Object} state Data store's state.
   * @return {(string|undefined)} This site's home URL.
   */
  getHomeURL: getSiteInfoProperty('homeURL'),
  /**
   * Gets a site's reference site URL.
   *
   * @since 1.7.0
   *
   * @param {Object} state Data store's state.
   * @return {(string|undefined)} The reference site URL.
   */
  getReferenceSiteURL: getSiteInfoProperty('referenceSiteURL'),
  /**
   * Gets proxy setup URL.
   *
   * @since 1.14.0
   *
   * @return {string} Proxy setup URL if available, otherwise an empty string.
   */
  getProxySetupURL: getSiteInfoProperty('proxySetupURL'),
  /**
   * Gets proxy permissions URL.
   *
   * @since 1.14.0
   *
   * @return {string} Proxy permissions URL if available, otherwise an empty string.
   */
  getProxyPermissionsURL: getSiteInfoProperty('proxyPermissionsURL'),
  /**
   * Gets the current reference URL to use.
   *
   * This selector should be used to get the contextual URL for requesting
   * URL-specific data from Google APIs.
   *
   * If a current entity exists, this will return the same value as the
   * `getCurrentEntityURL` selector. Otherwise it will fall back to returning
   * the same value as the `getReferenceSiteURL` selector.
   *
   * @since 1.10.0
   *
   * @param {Object} state Data store's state.
   * @return {(string|undefined)} The current reference URL, or undefined if
   *                              not loaded yet.
   */
  getCurrentReferenceURL: (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.createRegistrySelector)(select => () => {
    // Use current entity URL if present or still loading.
    const currentEntityURL = select(_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_SITE).getCurrentEntityURL();
    if (currentEntityURL !== null) {
      return currentEntityURL;
    }

    // Otherwise fall back to reference site URL.
    return select(_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_SITE).getReferenceSiteURL();
  }),
  /**
   * Returns true if this site supports AMP.
   *
   * @since 1.7.0
   * @since 1.11.0 Renamed from isAmp to isAMP.
   *
   * @param {Object} state Data store's state.
   * @return {(string|undefined)} `true` if AMP support is enabled, `false` if not. Returns `undefined` if not loaded.
   */
  isAMP: (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.createRegistrySelector)(select => () => {
    const ampMode = select(_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_SITE).getAMPMode();
    if (ampMode === undefined) {
      return undefined;
    }
    return !!ampMode;
  }),
  /**
   * Checks if the site is in the primary AMP mode.
   *
   * @since 1.12.0
   *
   * @return {(boolean|undefined)} `true` or `false` if the site is in the primary AMP mode. Returns `undefined` if not loaded.
   */
  isPrimaryAMP: (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.createRegistrySelector)(select => () => {
    const ampMode = select(_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_SITE).getAMPMode();
    if (ampMode === undefined) {
      return undefined;
    }
    return ampMode === _constants__WEBPACK_IMPORTED_MODULE_3__.AMP_MODE_PRIMARY;
  }),
  /**
   * Checks if the site is in a secondary AMP mode.
   *
   * @since 1.12.0
   *
   * @return {(boolean|undefined)} `true` or `false` if the site is in a secondary AMP mode. Returns `undefined` if not loaded.
   */
  isSecondaryAMP: (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.createRegistrySelector)(select => () => {
    const ampMode = select(_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_SITE).getAMPMode();
    if (ampMode === undefined) {
      return undefined;
    }
    return ampMode === _constants__WEBPACK_IMPORTED_MODULE_3__.AMP_MODE_SECONDARY;
  }),
  /**
   * Retrieves an admin settings URL, pointing to either network or single-site settings
   * depending on whether the site is multisite.
   *
   * @since 1.146.0
   *
   * @return {string|undefined} The admin settings URL, or undefined if required data is unavailable.
   */
  getAdminSettingsURL: (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.createRegistrySelector)(select => () => {
    const adminURL = select(_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_SITE).getAdminURL();
    const isMultisite = select(_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_SITE).isMultisite();
    if (adminURL === undefined || isMultisite === undefined) {
      return undefined;
    }
    return new URL(isMultisite === true ? 'network/settings.php' : 'options-general.php', adminURL).href;
  }),
  /**
   * Gets a site's timezone.
   *
   * @since 1.9.0
   *
   * @param {Object} state Data store's state.
   * @return {(string|undefined)} The timezone.
   */
  getTimezone: getSiteInfoProperty('timezone'),
  /**
   * Gets the WordPress "start of week" option for the site.
   *
   * 0 = Sunday, 1 = Monday, ... 6 = Saturday.
   *
   * @since 1.164.0
   *
   * @param {Object} state Data store's state.
   * @return {(number|undefined)} The start of week index, or undefined while loading.
   */
  getStartOfWeek: getSiteInfoProperty('startOfWeek'),
  /**
   * Returns true if this site is using the proxy service.
   *
   * @since 1.9.0
   *
   * @param {Object} state Data store's state.
   * @return {(boolean|undefined)} `true` if the proxy service is in use, `false` if not. Returns `undefined` if not loaded.
   */
  isUsingProxy: getSiteInfoProperty('usingProxy'),
  /**
   * Gets a site's name.
   *
   * @since 1.9.0
   *
   * @param {Object} state Data store's state.
   * @return {(string|undefined)} The site name.
   */
  getSiteName: getSiteInfoProperty('siteName'),
  /**
   * Gets a site's locale.
   *
   * @since 1.147.0
   *
   * @return {(string|undefined)} The site locale.
   */
  getSiteLocale: (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.createRegistrySelector)(select => () => select(_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_SITE).getSiteInfo()?.siteLocale?.replace('_', '-')),
  /**
   * Gets a setup error code, if one exists.
   *
   * @since 1.80.0
   *
   * @param {Object} state Data store's state.
   * @return {(string|undefined)} An error code from setup, if one exists. Will be `null` if no error exists; `undefined` when loading.
   */
  getSetupErrorCode: getSiteInfoProperty('setupErrorCode'),
  /**
   * Gets a setup error message, if one exists.
   *
   * @since 1.77.0
   *
   * @param {Object} state Data store's state.
   * @return {(string|null|undefined)} An error message from setup, if one exists. Will be `null` if no error exists; `undefined` when loading.
   */
  getSetupErrorMessage: getSiteInfoProperty('setupErrorMessage'),
  /**
   * Gets a setup redo URL, if one exists after encountering a setup error.
   *
   * This URL will be used to redo the setup process if a user encountered
   * an error.
   *
   * @since 1.77.0
   *
   * @param {Object} state Data store's state.
   * @return {(string|null|undefined)} The setup URL, if one exists. Will be `null` if no error exists and thus the setup redo URL doesn't exist; `undefined` when loading.
   */
  getSetupErrorRedoURL: getSiteInfoProperty('setupErrorRedoURL'),
  /**
   * Gets the proxy support URL.
   *
   * @since 1.80.0
   *
   * @param {Object} state Data store's state.
   * @return {(string|null)} The proxy support URL.
   */
  getProxySupportLinkURL: getSiteInfoProperty('proxySupportLinkURL'),
  /**
   * Gets the admin widgets editor URL.
   *
   * @since 1.81.0
   *
   * @param {Object} state Data store's state.
   * @return {(string|null)} The proxy support URL.
   */
  getWidgetsAdminURL: getSiteInfoProperty('widgetsAdminURL'),
  /**
   * Gets the public post types.
   *
   * @since 1.81.0
   *
   * @param {Object} state Data store's state.
   * @return {Array.<Object>} The public post types.
   */
  getPostTypes: getSiteInfoProperty('postTypes'),
  /**
   * Gets the 'permaLink' query parameter.
   *
   * @since 1.18.0
   *
   * @param {Object} state Data store's state.
   * @return {(string|boolean)} Value of the 'permaLink' query parameter or `false` if not set.
   */
  getPermaLinkParam: state => {
    if (state.permaLink) {
      return state.permaLink;
    }
    const queryArg = (0,_wordpress_url__WEBPACK_IMPORTED_MODULE_7__.getQueryArg)(__webpack_require__.g.location.href, 'permaLink');
    return queryArg ? queryArg : false;
  },
  /**
   * Returns true if this site has the Web Stories plugin enabled.
   *
   * @since 1.27.0
   *
   * @param {Object} state Data store's state.
   * @return {(boolean|undefined)} `true` if the Web Stories plugin is enabled, `false` if not. Returns `undefined` if not loaded.
   */
  isWebStoriesActive: getSiteInfoProperty('webStoriesActive'),
  /**
   * Determines whether the provided URL matches reference site URL or not.
   *
   * @since 1.32.0
   *
   * @param {string} url The URL to compare with the reference site URL.
   * @return {boolean} TRUE if the URL matches reference site URL, otherwise FALSE.
   */
  isSiteURLMatch: (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.createRegistrySelector)(select => (state, url) => {
    const referenceURL = select(_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_SITE).getReferenceSiteURL();
    return (0,_js_util__WEBPACK_IMPORTED_MODULE_4__.normalizeURL)(referenceURL) === (0,_js_util__WEBPACK_IMPORTED_MODULE_4__.normalizeURL)(url);
  }),
  /**
   * Gets an array with site URL permutations.
   *
   * @since 1.34.0
   *
   * @return {Array.<string>} An array with permutations.
   */
  getSiteURLPermutations: (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.createRegistrySelector)(select => () => {
    const referenceURL = select(_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_SITE).getReferenceSiteURL();
    const permutations = [];
    const url = new URL(referenceURL);
    url.hostname = url.hostname.replace(/^www\./i, '');
    url.protocol = 'http';
    permutations.push((0,_js_util__WEBPACK_IMPORTED_MODULE_4__.untrailingslashit)(url));
    url.protocol = 'https';
    permutations.push((0,_js_util__WEBPACK_IMPORTED_MODULE_4__.untrailingslashit)(url));
    url.hostname = 'www.' + url.hostname;
    permutations.push((0,_js_util__WEBPACK_IMPORTED_MODULE_4__.untrailingslashit)(url));
    url.protocol = 'http';
    permutations.push((0,_js_util__WEBPACK_IMPORTED_MODULE_4__.untrailingslashit)(url));
    return permutations;
  }),
  /**
   * Gets the WordPress version object.
   *
   * @since 1.85.0
   *
   * @param {Object} state Data store's state.
   * @return {(Object|undefined)} WordPress version object.
   */
  getWPVersion: getSiteInfoProperty('wpVersion'),
  /**
   * Gets the WordPress update core URL.
   *
   * @since 1.85.0
   *
   * @param {Object} state Data store's state.
   * @return {(Object|undefined)} WordPress update core URL.
   */
  getUpdateCoreURL: getSiteInfoProperty('updateCoreURL'),
  /**
   * Determines if Site Kit auto update settings can be changed.
   *
   * Auto update settings can not be changed if plugin updates are disabled site-wide
   * or if Site Kit auto updates are enforced by a PHP filter.
   *
   * @since 1.93.0
   *
   * @param {Object} state Data store's state.
   * @return {(boolean|undefined)} `true` if plugin auto updates are enabled, otherwise `false`.
   */
  hasChangePluginAutoUpdatesCapacity: getSiteInfoProperty('changePluginAutoUpdatesCapacity'),
  /**
   * Determines if the auto updates are enabled for the Site Kit plugin.
   *
   * @since 1.93.0
   *
   * @param {Object} state Data store's state.
   * @return {(boolean|undefined)} `true` if Site Kit auto updates are enabled, otherwise `false`.
   */
  getSiteKitAutoUpdatesEnabled: getSiteInfoProperty('siteKitAutoUpdatesEnabled'),
  /**
   * Get the plugin basename.
   *
   * @since 1.93.0
   *
   * @param {Object} state Data store's state.
   * @return {string} The basename of plugin, e.g. `'google-site-kit/google-site-kit.php'`.
   */
  getPluginBasename: getSiteInfoProperty('pluginBasename'),
  /**
   * Get the user ID of the user who setup Key Metrics widget if present.
   *
   * @since 1.113.0
   *
   * @return {number} `ID` of the user who did initial setup of the Key Metrics widget, if setup was done, otherwise `0`.
   */
  getKeyMetricsSetupCompletedBy: getSiteInfoProperty('keyMetricsSetupCompletedBy'),
  /**
   * Gets the state of whether or not Key Metrics was recently set up.
   *
   * @since 1.115.0
   *
   * @return {boolean} `true` if recently set up, otherwise `false`.
   */
  getKeyMetricsSetupNew: getSiteInfoProperty('keyMetricsSetupNew'),
  /**
   * Determines whether the current WordPress site has the minimum required version.
   * Currently, the minimum required version is 5.2.
   *
   * @since 1.85.0
   *
   * @param {string} minimumWPVersion The minimum required WordPress version.
   * @return {(boolean|undefined)} `true` if the WordPress site's version is greater than or equal to the minimum required version, `false` if not. Returns `undefined` if not loaded.
   */
  hasMinimumWordPressVersion: (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.createRegistrySelector)(select => (state, minimumWPVersion) => {
    invariant__WEBPACK_IMPORTED_MODULE_0___default()(minimumWPVersion, 'minimumWPVersion is required.');
    const {
      major,
      minor
    } = select(_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_SITE).getWPVersion() || {};
    if (major === undefined || minor === undefined) {
      return undefined;
    }
    const [minimumMajor, minimumMinor = 0] = minimumWPVersion.split('.').map(v => parseInt(v, 10));
    return minimumMajor < major || minimumMajor === major && minimumMinor <= minor;
  }),
  /**
   * Gets product post type.
   *
   * @since 1.116.0
   *
   * @return {string|null} The product post type or null if not present.
   */
  getProductPostType: getSiteInfoProperty('productPostType'),
  /**
   * Checks if the Key Metrics widget has been setup either if at least one user
   * has answered the User Input questionnaire or picked their own metrics.
   *
   * @since 1.108.0
   *
   * @param {Object} state Data store's state.
   * @return {(boolean|undefined)} `true` if the Key Metrics widget has been setup, otherwise `false`.
   */
  isKeyMetricsSetupCompleted: state => {
    // Here we double-negate the value of the setup completed by state
    // in order to cast it to a boolean, but only if it's not undefined.
    return (0,_js_util_negate__WEBPACK_IMPORTED_MODULE_5__.negateDefined)((0,_js_util_negate__WEBPACK_IMPORTED_MODULE_5__.negateDefined)(selectors.getKeyMetricsSetupCompletedBy(state)));
  },
  /**
   * Get the static list of consent mode regions.
   *
   * @since 1.128.0
   *
   * @return {Array<string>} Array of consent mode regions.
   */
  getConsentModeRegions: getSiteInfoProperty('consentModeRegions'),
  /**
   * Checks if user registrations are open on this WordPress site.
   *
   * @since 1.141.0
   *
   * @param {Object} state Data store's state.
   * @return {boolean|undefined} `true` if registrations are open; `false` if not. Returns `undefined` if not yet loaded.
   */
  getAnyoneCanRegister: getSiteInfoProperty('anyoneCanRegister'),
  /**
   * Checks if WordPress site is running in the multisite mode.
   *
   * @since 1.142.0
   *
   * @param {Object} state Data store's state.
   * @return {boolean|undefined} `true` if it is multisite; `false` if not. Returns `undefined` if not yet loaded.
   */
  isMultisite: getSiteInfoProperty('isMultisite')
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  initialState,
  actions,
  controls,
  reducer,
  resolvers,
  selectors
});

/***/ }),

/***/ "./js/googlesitekit/datastore/site/notifications.js":
/*!**********************************************************!*\
  !*** ./js/googlesitekit/datastore/site/notifications.js ***!
  \**********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var invariant__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! invariant */ "../node_modules/invariant/browser.js");
/* harmony import */ var invariant__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(invariant__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var googlesitekit_api__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-api */ "googlesitekit-api");
/* harmony import */ var googlesitekit_api__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_api__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./constants */ "./js/googlesitekit/datastore/site/constants.js");
/* harmony import */ var _js_googlesitekit_data_create_notifications_store__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/googlesitekit/data/create-notifications-store */ "./js/googlesitekit/data/create-notifications-store.js");
/* harmony import */ var _js_googlesitekit_data_create_fetch_store__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/googlesitekit/data/create-fetch-store */ "./js/googlesitekit/data/create-fetch-store.js");
/* harmony import */ var _js_googlesitekit_data_utils__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @/js/googlesitekit/data/utils */ "./js/googlesitekit/data/utils.js");
/* harmony import */ var _js_googlesitekit_data_create_error_store__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @/js/googlesitekit/data/create-error-store */ "./js/googlesitekit/data/create-error-store.js");
/**
 * `core/site` data store: notifications.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * Internal dependencies
 */







const ACCEPTED = 'accepted';
const DISMISSED = 'dismissed';
function isValidNotificationID(notificationID) {
  return 'string' === typeof notificationID;
}
const fetchMarkNotificationStore = (0,_js_googlesitekit_data_create_fetch_store__WEBPACK_IMPORTED_MODULE_5__.createFetchStore)({
  baseName: 'markNotification',
  controlCallback: ({
    notificationID,
    notificationState
  }) => {
    return (0,googlesitekit_api__WEBPACK_IMPORTED_MODULE_1__.set)('core', 'site', 'mark-notification', {
      notificationID,
      notificationState
    });
  },
  argsToParams: ({
    notificationID,
    notificationState
  }) => {
    return {
      notificationID,
      notificationState
    };
  },
  validateParams: ({
    notificationID,
    notificationState
  } = {}) => {
    invariant__WEBPACK_IMPORTED_MODULE_0___default()([ACCEPTED, DISMISSED].includes(notificationState), 'notificationState must be accepted or dismissed.');
    invariant__WEBPACK_IMPORTED_MODULE_0___default()(isValidNotificationID(notificationID), 'a valid notification ID is required to mark a notification.');
  }
});
const baseActions = {
  /**
   * Marks the given notification as accepted.
   *
   * @since 1.47.0
   *
   * @param {string} id Notification ID.
   * @return {Object} Object with `response` and `error`.
   */
  acceptNotification: (0,_js_googlesitekit_data_utils__WEBPACK_IMPORTED_MODULE_6__.createValidatedAction)(notificationID => {
    invariant__WEBPACK_IMPORTED_MODULE_0___default()(isValidNotificationID(notificationID), 'a valid notification ID is required to accept a notification.');
  }, function* (notificationID) {
    const {
      response,
      error
    } = yield fetchMarkNotificationStore.actions.fetchMarkNotification({
      notificationID,
      notificationState: ACCEPTED
    });
    if (error) {
      yield _js_googlesitekit_data_create_error_store__WEBPACK_IMPORTED_MODULE_7__.actions.receiveError(error, 'acceptNotification', [notificationID]);
    }
    return {
      response,
      error
    };
  }),
  /**
   * Marks the given notification as dismissed.
   *
   * @since 1.47.0
   *
   * @param {string} id Notification ID.
   * @return {Object} Object with `response` and `error`.
   */
  dismissNotification: (0,_js_googlesitekit_data_utils__WEBPACK_IMPORTED_MODULE_6__.createValidatedAction)(notificationID => {
    invariant__WEBPACK_IMPORTED_MODULE_0___default()(isValidNotificationID(notificationID), 'a valid notification ID is required to dismiss a notification.');
  }, function* (notificationID) {
    const {
      response,
      error
    } = yield fetchMarkNotificationStore.actions.fetchMarkNotification({
      notificationID,
      notificationState: DISMISSED
    });
    if (error) {
      yield _js_googlesitekit_data_create_error_store__WEBPACK_IMPORTED_MODULE_7__.actions.receiveError(error, 'dismissNotification', [notificationID]);
    }
    return {
      response,
      error
    };
  })
};
const notifications = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.combineStores)((0,_js_googlesitekit_data_create_notifications_store__WEBPACK_IMPORTED_MODULE_4__.createNotificationsStore)('core', 'site', 'notifications', {
  storeName: _constants__WEBPACK_IMPORTED_MODULE_3__.CORE_SITE
}), fetchMarkNotificationStore, {
  actions: baseActions
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (notifications);

/***/ }),

/***/ "./js/googlesitekit/datastore/site/reset.js":
/*!**************************************************!*\
  !*** ./js/googlesitekit/datastore/site/reset.js ***!
  \**************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   actions: () => (/* binding */ actions),
/* harmony export */   controls: () => (/* binding */ controls),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   initialState: () => (/* binding */ initialState),
/* harmony export */   reducer: () => (/* binding */ reducer),
/* harmony export */   resolvers: () => (/* binding */ resolvers),
/* harmony export */   selectors: () => (/* binding */ selectors)
/* harmony export */ });
/* harmony import */ var googlesitekit_api__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! googlesitekit-api */ "googlesitekit-api");
/* harmony import */ var googlesitekit_api__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_api__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./constants */ "./js/googlesitekit/datastore/site/constants.js");
/* harmony import */ var _js_googlesitekit_data_create_fetch_store__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/googlesitekit/data/create-fetch-store */ "./js/googlesitekit/data/create-fetch-store.js");
/**
 * `core/site` data store: reset connection.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Internal dependencies
 */




const fetchResetStore = (0,_js_googlesitekit_data_create_fetch_store__WEBPACK_IMPORTED_MODULE_3__.createFetchStore)({
  baseName: 'reset',
  controlCallback: () => {
    return (0,googlesitekit_api__WEBPACK_IMPORTED_MODULE_0__.set)('core', 'site', 'reset');
  }
});
const baseInitialState = {};
const baseActions = {
  /**
   * Resets the website's connection info to Site Kit.
   *
   * WARNING: This causes the website's connection with Google Site Kit to be
   * removed and will require re-authentication. Use this action with caution,
   * and always request user confirmation before dispatching.
   *
   * @since 1.5.0
   */
  *reset() {
    yield fetchResetStore.actions.fetchReset();
  }
};
const baseSelectors = {
  /**
   * Checks if reset action is in-process.
   *
   * @since 1.5.0
   *
   * @return {boolean} `true` if resetting is in-flight; `false` if not.
   */
  isDoingReset: (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.createRegistrySelector)(select => () => {
    return select(_constants__WEBPACK_IMPORTED_MODULE_2__.CORE_SITE).isFetchingReset();
  })
};
const store = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.combineStores)(fetchResetStore, {
  initialState: baseInitialState,
  actions: baseActions,
  selectors: baseSelectors
});
const initialState = store.initialState;
const actions = store.actions;
const controls = store.controls;
const reducer = store.reducer;
const resolvers = store.resolvers;
const selectors = store.selectors;
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (store);

/***/ }),

/***/ "./js/googlesitekit/datastore/site/settings.js":
/*!*****************************************************!*\
  !*** ./js/googlesitekit/datastore/site/settings.js ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   actions: () => (/* binding */ actions),
/* harmony export */   controls: () => (/* binding */ controls),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   initialState: () => (/* binding */ initialState),
/* harmony export */   reducer: () => (/* binding */ reducer),
/* harmony export */   resolvers: () => (/* binding */ resolvers),
/* harmony export */   selectors: () => (/* binding */ selectors)
/* harmony export */ });
/* harmony import */ var invariant__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! invariant */ "../node_modules/invariant/browser.js");
/* harmony import */ var invariant__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(invariant__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var googlesitekit_api__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-api */ "googlesitekit-api");
/* harmony import */ var googlesitekit_api__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_api__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./constants */ "./js/googlesitekit/datastore/site/constants.js");
/* harmony import */ var _js_googlesitekit_data_create_fetch_store__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/googlesitekit/data/create-fetch-store */ "./js/googlesitekit/data/create-fetch-store.js");
/**
 * `core/site` data store: settings.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/* eslint-disable sitekit/jsdoc-no-unnamed-boolean-params */

/**
 * External dependencies
 */


/**
 * Internal dependencies
 */




const fetchGetAdminBarSettingsStore = (0,_js_googlesitekit_data_create_fetch_store__WEBPACK_IMPORTED_MODULE_4__.createFetchStore)({
  baseName: 'getAdminBarSettings',
  controlCallback: () => (0,googlesitekit_api__WEBPACK_IMPORTED_MODULE_1__.get)('core', 'site', 'admin-bar-settings', undefined, {
    useCache: false
  }),
  reducerCallback: (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.createReducer)((state, adminBarSettings) => {
    state.adminBarSettings = {
      ...(state.adminBarSettings || {}),
      ...adminBarSettings
    };
  })
});
const fetchSetAdminBarSettingsStore = (0,_js_googlesitekit_data_create_fetch_store__WEBPACK_IMPORTED_MODULE_4__.createFetchStore)({
  baseName: 'setAdminBarSettings',
  controlCallback: ({
    enabled
  }) => (0,googlesitekit_api__WEBPACK_IMPORTED_MODULE_1__.set)('core', 'site', 'admin-bar-settings', {
    enabled
  }),
  reducerCallback: (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.createReducer)((state, adminBarSettings) => {
    state.adminBarSettings = {
      ...(state.adminBarSettings || {}),
      ...adminBarSettings
    };
  }),
  argsToParams({
    enabled
  }) {
    return {
      enabled
    };
  },
  validateParams({
    enabled
  }) {
    invariant__WEBPACK_IMPORTED_MODULE_0___default()(typeof enabled === 'boolean', 'enabled must be of boolean type');
  }
});
const baseInitialState = {
  adminBarSettings: undefined
};
const baseActions = {
  /**
   * Sets showAdminBar setting.
   *
   * @since 1.39.0
   *
   * @param {boolean} enabled Whether to show or hide the admin bar.
   * @return {Object} Object with `response` and `error`.
   */
  *setShowAdminBar(enabled) {
    const {
      response,
      error
    } = yield fetchSetAdminBarSettingsStore.actions.fetchSetAdminBarSettings({
      enabled
    });
    return {
      response,
      error
    };
  }
};
const baseControls = {};
function baseReducer(state, {
  type
}) {
  switch (type) {
    default:
      return state;
  }
}
const baseResolvers = {
  *getAdminBarSettings() {
    const {
      select
    } = yield googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.commonActions.getRegistry();
    const settings = select(_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_SITE).getAdminBarSettings();
    if (settings === undefined) {
      yield fetchGetAdminBarSettingsStore.actions.fetchGetAdminBarSettings();
    }
  }
};
const baseSelectors = {
  /**
   * Gets admin bar settings.
   *
   * @since 1.39.0
   *
   * @param {Object} state Data store's state.
   * @return {boolean} Admin bar setting if they have been already resolved, otherwise undefined.
   */
  getAdminBarSettings(state) {
    return state.adminBarSettings;
  },
  /**
   * Gets showAdminBar setting.
   *
   * @since 1.39.0
   *
   * @param {Object} state Data store's state.
   * @return {boolean} The showAdminBar setting if it has been already resolved, otherwise undefined.
   */
  getShowAdminBar: (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.createRegistrySelector)(select => () => {
    return select(_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_SITE).getAdminBarSettings()?.enabled;
  }),
  /**
   * Gets the URL for the module settings page.
   *
   * @since 1.157.0
   *
   * @param {Object} state      Data store's state.
   * @param {string} moduleSlug The slug of the module.
   * @return {string} The URL for the module settings page.
   */
  getModuleSettingsURL: (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.createRegistrySelector)(select => (state, moduleSlug) => {
    invariant__WEBPACK_IMPORTED_MODULE_0___default()(moduleSlug, 'moduleSlug is required to get module settings URL');
    const baseURL = select(_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_SITE).getAdminURL('googlesitekit-settings');
    return `${baseURL}#connected-services/${moduleSlug}`;
  }),
  /**
   * Gets the URL for the module settings edit page.
   *
   * @since 1.157.0
   *
   * @param {Object} state      Data store's state.
   * @param {string} moduleSlug The slug of the module.
   * @return {string} The URL for the module settings edit page.
   */
  getModuleSettingsEditURL: (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.createRegistrySelector)(select => (state, moduleSlug) => {
    invariant__WEBPACK_IMPORTED_MODULE_0___default()(moduleSlug, 'moduleSlug is required to get module settings edit URL');
    const settingsURL = select(_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_SITE).getModuleSettingsURL(moduleSlug);
    return `${settingsURL}/edit`;
  }),
  /**
   * Gets the URL for the "Connect More Services" page.
   *
   * @since 1.157.0
   *
   * @param {Object} state Data store's state.
   * @return {string} The URL for the "Connect More Services" page.
   */
  getConnectMoreServicesURL: (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.createRegistrySelector)(select => () => {
    const baseURL = select(_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_SITE).getAdminURL('googlesitekit-settings');
    return `${baseURL}#connect-more-services`;
  }),
  /**
   * Gets the URL for the admin settings page.
   *
   * @since 1.157.0
   *
   * @param {Object} state Data store's state.
   * @param {Object} args  Optional additional query arguments to add to admin URL.
   * @return {string} The URL for the admin settings page.
   */
  getSiteKitAdminSettingsURL: (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.createRegistrySelector)(select => (state, args) => {
    const baseURL = select(_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_SITE).getAdminURL('googlesitekit-settings', args);
    return `${baseURL}#/admin-settings`;
  })
};
const store = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.combineStores)(fetchGetAdminBarSettingsStore, fetchSetAdminBarSettingsStore, {
  initialState: baseInitialState,
  actions: baseActions,
  controls: baseControls,
  reducer: baseReducer,
  resolvers: baseResolvers,
  selectors: baseSelectors
});
const initialState = store.initialState;
const actions = store.actions;
const controls = store.controls;
const reducer = store.reducer;
const resolvers = store.resolvers;
const selectors = store.selectors;
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (store);

/***/ }),

/***/ "./js/googlesitekit/datastore/site/urls.js":
/*!*************************************************!*\
  !*** ./js/googlesitekit/datastore/site/urls.js ***!
  \*************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   selectors: () => (/* binding */ selectors)
/* harmony export */ });
/* harmony import */ var invariant__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! invariant */ "../node_modules/invariant/browser.js");
/* harmony import */ var invariant__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(invariant__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./constants */ "./js/googlesitekit/datastore/site/constants.js");
/* harmony import */ var _js_util__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/util */ "./js/util/index.js");
/**
 * `core/site` data store: urls.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * Internal dependencies
 */



const selectors = {
  /**
   * Gets an external Google URL that includes the user's locale.
   *
   * @since 1.36.0
   *
   * @param {Object} state          Data store's state.
   * @param {Object} [args]         Optional arguments for the resulting URL.
   * @param {string} [args.website] Base URL hostname and schema.
   * @param {string} [args.path]    URL path to build complete URL with starting slash.
   * @param {Object} [args.query]   Object to append query to the URL.
   * @param {string} [args.hash]    Optional hash.
   * @param {string} [args.locale]  Optional locale.
   * @return {(string|null)} The URL containing the user's locale or `null` if path is not set.
   */
  getGoogleLocaleAwareURL(state, args) {
    const currentLocale = (0,_js_util__WEBPACK_IMPORTED_MODULE_3__.getLocale)();
    const {
      website,
      path,
      query,
      hash,
      locale = currentLocale.match(/^([a-zA-Z]+[-_]?[a-zA-Z]*)/)?.[0] || currentLocale
    } = args || {};
    if (!path) {
      return null;
    }
    const url = new URL(website);
    url.pathname = path;
    url.hash = hash || '';
    const params = {
      ...query,
      hl: locale
    };
    for (const key in params) {
      url.searchParams.set(key, params[key]);
    }
    return url.toString();
  },
  /**
   * Gets an external help link that includes the user's locale.
   *
   * @since 1.24.0
   *
   * @param {Object} state        Data store's state.
   * @param {Object} [args]       Optional arguments for the resulting URL.
   * @param {string} [args.path]  URL path to build complete URL with starting slash.
   * @param {Object} [args.query] Object to append query to the URL.
   * @param {string} [args.hash]  Optional hash.
   * @return {(string|null)} The URL containing the user's locale or `null` if path is not set.
   */
  getGoogleSupportURL: (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.createRegistrySelector)(select => (state, args) => {
    return select(_constants__WEBPACK_IMPORTED_MODULE_2__.CORE_SITE).getGoogleLocaleAwareURL({
      ...args,
      website: 'https://support.google.com'
    });
  }),
  /**
   * Gets the Google privacy policy URL.
   *
   * @since 1.36.0
   *
   * @param {Object} state Data store's state.
   * @return {string} The Google privacy policy URL.
   */
  getGooglePrivacyPolicyURL: (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.createRegistrySelector)(select => () => {
    return select(_constants__WEBPACK_IMPORTED_MODULE_2__.CORE_SITE).getGoogleLocaleAwareURL({
      website: 'https://myaccount.google.com',
      path: '/privacypolicy'
    });
  }),
  /**
   * Gets the Site Kit documentation URL.
   *
   * @since 1.80.0
   *
   * @param {Object} state Data store's state.
   * @param {string} slug  The slug of the documentation page.
   * @return {string} The Site Kit support URL.
   */
  getDocumentationLinkURL: (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.createRegistrySelector)(select => (state, slug) => {
    invariant__WEBPACK_IMPORTED_MODULE_0___default()(slug, 'A slug is required.');
    const proxySupportLink = select(_constants__WEBPACK_IMPORTED_MODULE_2__.CORE_SITE).getProxySupportLinkURL();
    return `${proxySupportLink}?doc=${encodeURIComponent(slug)}`;
  }),
  /**
   * Gets the relevant troubleshooting URL.
   *
   * @since 1.80.0
   *
   * @param {Object} state Data store's state.
   * @param {Object} error The error object.
   * @return {string} The Site Kit support URL.
   */
  getErrorTroubleshootingLinkURL: (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.createRegistrySelector)(select => (state, error) => {
    invariant__WEBPACK_IMPORTED_MODULE_0___default()(error, 'An error is required.');
    const proxySupportLink = select(_constants__WEBPACK_IMPORTED_MODULE_2__.CORE_SITE).getProxySupportLinkURL();
    if (error.id && !(0,_js_util__WEBPACK_IMPORTED_MODULE_3__.isNumeric)(error.id)) {
      return `${proxySupportLink}?error_id=${encodeURIComponent(error.id)}`;
    }
    if (error.code && !(0,_js_util__WEBPACK_IMPORTED_MODULE_3__.isNumeric)(error.code)) {
      return `${proxySupportLink}?error_id=${encodeURIComponent(error.code)}`;
    }
    return `${proxySupportLink}?error=${encodeURIComponent(error.message)}`;
  }),
  /**
   * Gets the Google terms of service URL.
   *
   * @since 1.36.0
   *
   * @param {Object} state Data store's state.
   * @return {string} The Google terms URL.
   */
  getGoogleTermsURL: (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.createRegistrySelector)(select => () => {
    return select(_constants__WEBPACK_IMPORTED_MODULE_2__.CORE_SITE).getGoogleLocaleAwareURL({
      website: 'https://policies.google.com',
      path: '/terms'
    });
  })
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  selectors
});

/***/ }),

/***/ "./js/googlesitekit/datastore/user/constants.js":
/*!******************************************************!*\
  !*** ./js/googlesitekit/datastore/user/constants.js ***!
  \******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   CORE_USER: () => (/* binding */ CORE_USER),
/* harmony export */   DISCONNECTED_REASON_CONNECTED_URL_MISMATCH: () => (/* binding */ DISCONNECTED_REASON_CONNECTED_URL_MISMATCH),
/* harmony export */   EMAIL_REPORT_FREQUENCIES: () => (/* binding */ EMAIL_REPORT_FREQUENCIES),
/* harmony export */   ERROR_CODE_ADBLOCKER_ACTIVE: () => (/* binding */ ERROR_CODE_ADBLOCKER_ACTIVE),
/* harmony export */   FORM_TEMPORARY_PERSIST_PERMISSION_ERROR: () => (/* binding */ FORM_TEMPORARY_PERSIST_PERMISSION_ERROR),
/* harmony export */   GLOBAL_SURVEYS_TIMEOUT_SLUG: () => (/* binding */ GLOBAL_SURVEYS_TIMEOUT_SLUG),
/* harmony export */   KM_ANALYTICS_ADSENSE_TOP_EARNING_CONTENT: () => (/* binding */ KM_ANALYTICS_ADSENSE_TOP_EARNING_CONTENT),
/* harmony export */   KM_ANALYTICS_ENGAGED_TRAFFIC_SOURCE: () => (/* binding */ KM_ANALYTICS_ENGAGED_TRAFFIC_SOURCE),
/* harmony export */   KM_ANALYTICS_LEAST_ENGAGING_PAGES: () => (/* binding */ KM_ANALYTICS_LEAST_ENGAGING_PAGES),
/* harmony export */   KM_ANALYTICS_MOST_ENGAGING_PAGES: () => (/* binding */ KM_ANALYTICS_MOST_ENGAGING_PAGES),
/* harmony export */   KM_ANALYTICS_NEW_VISITORS: () => (/* binding */ KM_ANALYTICS_NEW_VISITORS),
/* harmony export */   KM_ANALYTICS_PAGES_PER_VISIT: () => (/* binding */ KM_ANALYTICS_PAGES_PER_VISIT),
/* harmony export */   KM_ANALYTICS_POPULAR_AUTHORS: () => (/* binding */ KM_ANALYTICS_POPULAR_AUTHORS),
/* harmony export */   KM_ANALYTICS_POPULAR_CONTENT: () => (/* binding */ KM_ANALYTICS_POPULAR_CONTENT),
/* harmony export */   KM_ANALYTICS_POPULAR_PRODUCTS: () => (/* binding */ KM_ANALYTICS_POPULAR_PRODUCTS),
/* harmony export */   KM_ANALYTICS_RETURNING_VISITORS: () => (/* binding */ KM_ANALYTICS_RETURNING_VISITORS),
/* harmony export */   KM_ANALYTICS_TOP_CATEGORIES: () => (/* binding */ KM_ANALYTICS_TOP_CATEGORIES),
/* harmony export */   KM_ANALYTICS_TOP_CITIES: () => (/* binding */ KM_ANALYTICS_TOP_CITIES),
/* harmony export */   KM_ANALYTICS_TOP_CITIES_DRIVING_ADD_TO_CART: () => (/* binding */ KM_ANALYTICS_TOP_CITIES_DRIVING_ADD_TO_CART),
/* harmony export */   KM_ANALYTICS_TOP_CITIES_DRIVING_LEADS: () => (/* binding */ KM_ANALYTICS_TOP_CITIES_DRIVING_LEADS),
/* harmony export */   KM_ANALYTICS_TOP_CITIES_DRIVING_PURCHASES: () => (/* binding */ KM_ANALYTICS_TOP_CITIES_DRIVING_PURCHASES),
/* harmony export */   KM_ANALYTICS_TOP_CONVERTING_TRAFFIC_SOURCE: () => (/* binding */ KM_ANALYTICS_TOP_CONVERTING_TRAFFIC_SOURCE),
/* harmony export */   KM_ANALYTICS_TOP_COUNTRIES: () => (/* binding */ KM_ANALYTICS_TOP_COUNTRIES),
/* harmony export */   KM_ANALYTICS_TOP_DEVICE_DRIVING_PURCHASES: () => (/* binding */ KM_ANALYTICS_TOP_DEVICE_DRIVING_PURCHASES),
/* harmony export */   KM_ANALYTICS_TOP_PAGES_DRIVING_LEADS: () => (/* binding */ KM_ANALYTICS_TOP_PAGES_DRIVING_LEADS),
/* harmony export */   KM_ANALYTICS_TOP_RECENT_TRENDING_PAGES: () => (/* binding */ KM_ANALYTICS_TOP_RECENT_TRENDING_PAGES),
/* harmony export */   KM_ANALYTICS_TOP_RETURNING_VISITOR_PAGES: () => (/* binding */ KM_ANALYTICS_TOP_RETURNING_VISITOR_PAGES),
/* harmony export */   KM_ANALYTICS_TOP_TRAFFIC_SOURCE: () => (/* binding */ KM_ANALYTICS_TOP_TRAFFIC_SOURCE),
/* harmony export */   KM_ANALYTICS_TOP_TRAFFIC_SOURCE_DRIVING_ADD_TO_CART: () => (/* binding */ KM_ANALYTICS_TOP_TRAFFIC_SOURCE_DRIVING_ADD_TO_CART),
/* harmony export */   KM_ANALYTICS_TOP_TRAFFIC_SOURCE_DRIVING_LEADS: () => (/* binding */ KM_ANALYTICS_TOP_TRAFFIC_SOURCE_DRIVING_LEADS),
/* harmony export */   KM_ANALYTICS_TOP_TRAFFIC_SOURCE_DRIVING_PURCHASES: () => (/* binding */ KM_ANALYTICS_TOP_TRAFFIC_SOURCE_DRIVING_PURCHASES),
/* harmony export */   KM_ANALYTICS_VISITS_PER_VISITOR: () => (/* binding */ KM_ANALYTICS_VISITS_PER_VISITOR),
/* harmony export */   KM_ANALYTICS_VISIT_LENGTH: () => (/* binding */ KM_ANALYTICS_VISIT_LENGTH),
/* harmony export */   KM_SEARCH_CONSOLE_POPULAR_KEYWORDS: () => (/* binding */ KM_SEARCH_CONSOLE_POPULAR_KEYWORDS),
/* harmony export */   PERMISSION_AUTHENTICATE: () => (/* binding */ PERMISSION_AUTHENTICATE),
/* harmony export */   PERMISSION_DELEGATE_MODULE_SHARING_MANAGEMENT: () => (/* binding */ PERMISSION_DELEGATE_MODULE_SHARING_MANAGEMENT),
/* harmony export */   PERMISSION_MANAGE_MODULE_SHARING_OPTIONS: () => (/* binding */ PERMISSION_MANAGE_MODULE_SHARING_OPTIONS),
/* harmony export */   PERMISSION_MANAGE_OPTIONS: () => (/* binding */ PERMISSION_MANAGE_OPTIONS),
/* harmony export */   PERMISSION_READ_SHARED_MODULE_DATA: () => (/* binding */ PERMISSION_READ_SHARED_MODULE_DATA),
/* harmony export */   PERMISSION_SETUP: () => (/* binding */ PERMISSION_SETUP),
/* harmony export */   PERMISSION_UPDATE_PLUGINS: () => (/* binding */ PERMISSION_UPDATE_PLUGINS),
/* harmony export */   PERMISSION_VIEW_DASHBOARD: () => (/* binding */ PERMISSION_VIEW_DASHBOARD),
/* harmony export */   PERMISSION_VIEW_MODULE_DETAILS: () => (/* binding */ PERMISSION_VIEW_MODULE_DETAILS),
/* harmony export */   PERMISSION_VIEW_POSTS_INSIGHTS: () => (/* binding */ PERMISSION_VIEW_POSTS_INSIGHTS),
/* harmony export */   PERMISSION_VIEW_SHARED_DASHBOARD: () => (/* binding */ PERMISSION_VIEW_SHARED_DASHBOARD),
/* harmony export */   allKeyMetricsTileWidgets: () => (/* binding */ allKeyMetricsTileWidgets),
/* harmony export */   keyMetricsGA4Widgets: () => (/* binding */ keyMetricsGA4Widgets)
/* harmony export */ });
/**
 * `core/user` data store: constants.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

const CORE_USER = 'core/user';
const DISCONNECTED_REASON_CONNECTED_URL_MISMATCH = 'connected_url_mismatch';
const GLOBAL_SURVEYS_TIMEOUT_SLUG = '__global';
const FORM_TEMPORARY_PERSIST_PERMISSION_ERROR = 'temporary_persist_permission_error';
const ERROR_CODE_ADBLOCKER_ACTIVE = 'adblocker_active';

// Email Report Frequency options.
const EMAIL_REPORT_FREQUENCIES = ['weekly', 'monthly', 'quarterly'];

// Permissions list.
const PERMISSION_AUTHENTICATE = 'googlesitekit_authenticate';
const PERMISSION_SETUP = 'googlesitekit_setup';
const PERMISSION_VIEW_POSTS_INSIGHTS = 'googlesitekit_view_posts_insights';
const PERMISSION_VIEW_DASHBOARD = 'googlesitekit_view_dashboard';
const PERMISSION_VIEW_SHARED_DASHBOARD = 'googlesitekit_view_shared_dashboard';
const PERMISSION_VIEW_MODULE_DETAILS = 'googlesitekit_view_module_details';
const PERMISSION_MANAGE_OPTIONS = 'googlesitekit_manage_options';
const PERMISSION_READ_SHARED_MODULE_DATA = 'googlesitekit_read_shared_module_data';
const PERMISSION_MANAGE_MODULE_SHARING_OPTIONS = 'googlesitekit_manage_module_sharing_options';
const PERMISSION_DELEGATE_MODULE_SHARING_MANAGEMENT = 'googlesitekit_delegate_module_sharing_management';
const PERMISSION_UPDATE_PLUGINS = 'googlesitekit_update_plugins';

// Key Metrics Widgets
const KM_ANALYTICS_ADSENSE_TOP_EARNING_CONTENT = 'kmAnalyticsAdSenseTopEarningContent';
const KM_ANALYTICS_ENGAGED_TRAFFIC_SOURCE = 'kmAnalyticsEngagedTrafficSource';
const KM_ANALYTICS_LEAST_ENGAGING_PAGES = 'kmAnalyticsLeastEngagingPages';
const KM_ANALYTICS_NEW_VISITORS = 'kmAnalyticsNewVisitors';
const KM_ANALYTICS_POPULAR_AUTHORS = 'kmAnalyticsPopularAuthors';
const KM_ANALYTICS_POPULAR_CONTENT = 'kmAnalyticsPopularContent';
const KM_ANALYTICS_POPULAR_PRODUCTS = 'kmAnalyticsPopularProducts';
const KM_ANALYTICS_RETURNING_VISITORS = 'kmAnalyticsReturningVisitors';
const KM_ANALYTICS_TOP_CITIES = 'kmAnalyticsTopCities';
const KM_ANALYTICS_TOP_CITIES_DRIVING_LEADS = 'kmAnalyticsTopCitiesDrivingLeads';
const KM_ANALYTICS_TOP_CITIES_DRIVING_ADD_TO_CART = 'kmAnalyticsTopCitiesDrivingAddToCart';
const KM_ANALYTICS_TOP_CITIES_DRIVING_PURCHASES = 'kmAnalyticsTopCitiesDrivingPurchases';
const KM_ANALYTICS_TOP_DEVICE_DRIVING_PURCHASES = 'kmAnalyticsTopDeviceDrivingPurchases';
const KM_ANALYTICS_TOP_CONVERTING_TRAFFIC_SOURCE = 'kmAnalyticsTopConvertingTrafficSource';
const KM_ANALYTICS_TOP_COUNTRIES = 'kmAnalyticsTopCountries';
const KM_ANALYTICS_TOP_PAGES_DRIVING_LEADS = 'kmAnalyticsTopPagesDrivingLeads';
const KM_ANALYTICS_TOP_RECENT_TRENDING_PAGES = 'kmAnalyticsTopRecentTrendingPages';
const KM_ANALYTICS_TOP_TRAFFIC_SOURCE = 'kmAnalyticsTopTrafficSource';
const KM_ANALYTICS_TOP_TRAFFIC_SOURCE_DRIVING_ADD_TO_CART = 'kmAnalyticsTopTrafficSourceDrivingAddToCart';
const KM_ANALYTICS_TOP_TRAFFIC_SOURCE_DRIVING_LEADS = 'kmAnalyticsTopTrafficSourceDrivingLeads';
const KM_ANALYTICS_TOP_TRAFFIC_SOURCE_DRIVING_PURCHASES = 'kmAnalyticsTopTrafficSourceDrivingPurchases';
const KM_ANALYTICS_PAGES_PER_VISIT = 'kmAnalyticsPagesPerVisit';
const KM_ANALYTICS_VISIT_LENGTH = 'kmAnalyticsVisitLength';
const KM_ANALYTICS_TOP_RETURNING_VISITOR_PAGES = 'kmAnalyticsTopReturningVisitorPages';
const KM_SEARCH_CONSOLE_POPULAR_KEYWORDS = 'kmSearchConsolePopularKeywords';
const KM_ANALYTICS_VISITS_PER_VISITOR = 'kmAnalyticsVisitsPerVisitor';
const KM_ANALYTICS_MOST_ENGAGING_PAGES = 'kmAnalyticsMostEngagingPages';
const KM_ANALYTICS_TOP_CATEGORIES = 'kmAnalyticsTopCategories';
const keyMetricsGA4Widgets = [KM_ANALYTICS_ADSENSE_TOP_EARNING_CONTENT, KM_ANALYTICS_ENGAGED_TRAFFIC_SOURCE, KM_ANALYTICS_LEAST_ENGAGING_PAGES, KM_ANALYTICS_NEW_VISITORS, KM_ANALYTICS_POPULAR_AUTHORS, KM_ANALYTICS_POPULAR_CONTENT, KM_ANALYTICS_POPULAR_PRODUCTS, KM_ANALYTICS_RETURNING_VISITORS, KM_ANALYTICS_TOP_CATEGORIES, KM_ANALYTICS_TOP_CITIES, KM_ANALYTICS_TOP_CITIES_DRIVING_LEADS, KM_ANALYTICS_TOP_CITIES_DRIVING_ADD_TO_CART, KM_ANALYTICS_TOP_CITIES_DRIVING_PURCHASES, KM_ANALYTICS_TOP_DEVICE_DRIVING_PURCHASES, KM_ANALYTICS_TOP_CONVERTING_TRAFFIC_SOURCE, KM_ANALYTICS_TOP_COUNTRIES, KM_ANALYTICS_TOP_RECENT_TRENDING_PAGES, KM_ANALYTICS_TOP_TRAFFIC_SOURCE, KM_ANALYTICS_TOP_TRAFFIC_SOURCE_DRIVING_ADD_TO_CART, KM_ANALYTICS_PAGES_PER_VISIT, KM_ANALYTICS_VISIT_LENGTH, KM_ANALYTICS_TOP_RETURNING_VISITOR_PAGES, KM_ANALYTICS_VISITS_PER_VISITOR, KM_ANALYTICS_MOST_ENGAGING_PAGES, KM_ANALYTICS_TOP_CATEGORIES];
const allKeyMetricsTileWidgets = [...keyMetricsGA4Widgets, KM_SEARCH_CONSOLE_POPULAR_KEYWORDS];

/***/ }),

/***/ "./js/googlesitekit/modules/datastore/constants.js":
/*!*********************************************************!*\
  !*** ./js/googlesitekit/modules/datastore/constants.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   CORE_MODULES: () => (/* binding */ CORE_MODULES),
/* harmony export */   ERROR_CODE_INSUFFICIENT_MODULE_DEPENDENCIES: () => (/* binding */ ERROR_CODE_INSUFFICIENT_MODULE_DEPENDENCIES)
/* harmony export */ });
/**
 * `core/modules` data store: constants.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

const CORE_MODULES = 'core/modules';
const ERROR_CODE_INSUFFICIENT_MODULE_DEPENDENCIES = 'insufficient_module_dependencies';

/***/ }),

/***/ "./js/modules/ads/constants.js":
/*!*************************************!*\
  !*** ./js/modules/ads/constants.js ***!
  \*************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   MODULE_SLUG_ADS: () => (/* binding */ MODULE_SLUG_ADS)
/* harmony export */ });
/**
 * Ads module constants.
 *
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

const MODULE_SLUG_ADS = 'ads';

/***/ }),

/***/ "./js/modules/analytics-4/constants.js":
/*!*********************************************!*\
  !*** ./js/modules/analytics-4/constants.js ***!
  \*********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ACTIVATION_ACKNOWLEDGEMENT_TOOLTIP_STATE_KEY: () => (/* binding */ ACTIVATION_ACKNOWLEDGEMENT_TOOLTIP_STATE_KEY),
/* harmony export */   ACTIVATION_STEP_IN_PROGRESS: () => (/* binding */ ACTIVATION_STEP_IN_PROGRESS),
/* harmony export */   ACTIVATION_STEP_REMINDER: () => (/* binding */ ACTIVATION_STEP_REMINDER),
/* harmony export */   ACTIVATION_STEP_SETUP: () => (/* binding */ ACTIVATION_STEP_SETUP),
/* harmony export */   ACTIVATION_STEP_SUCCESS: () => (/* binding */ ACTIVATION_STEP_SUCCESS),
/* harmony export */   ENHANCED_MEASUREMENT_ACTIVATION_BANNER_TOOLTIP_STATE_KEY: () => (/* binding */ ENHANCED_MEASUREMENT_ACTIVATION_BANNER_TOOLTIP_STATE_KEY),
/* harmony export */   GA4_ACTIVATION_BANNER_STATE_KEY: () => (/* binding */ GA4_ACTIVATION_BANNER_STATE_KEY),
/* harmony export */   GA4_AUTO_SWITCH_DATE: () => (/* binding */ GA4_AUTO_SWITCH_DATE),
/* harmony export */   KM_CONNECT_GA4_CTA_WIDGET_DISMISSED_ITEM_KEY: () => (/* binding */ KM_CONNECT_GA4_CTA_WIDGET_DISMISSED_ITEM_KEY),
/* harmony export */   LEGACY_ENHANCED_MEASUREMENT_ACTIVATION_BANNER_DISMISSED_ITEM_KEY: () => (/* binding */ LEGACY_ENHANCED_MEASUREMENT_ACTIVATION_BANNER_DISMISSED_ITEM_KEY),
/* harmony export */   MODULE_SLUG_ANALYTICS_4: () => (/* binding */ MODULE_SLUG_ANALYTICS_4),
/* harmony export */   REPORT_ARGS_DATA_FILTERS_KEY: () => (/* binding */ REPORT_ARGS_DATA_FILTERS_KEY),
/* harmony export */   REPORT_ARGS_NAV_KEY: () => (/* binding */ REPORT_ARGS_NAV_KEY),
/* harmony export */   REPORT_ARGS_SELECTED_DIMENSION_KEY: () => (/* binding */ REPORT_ARGS_SELECTED_DIMENSION_KEY),
/* harmony export */   REPORT_ARGS_SELECTED_METRIC_KEY: () => (/* binding */ REPORT_ARGS_SELECTED_METRIC_KEY)
/* harmony export */ });
/**
 * GA4 module constants.
 *
 * Site Kit by Google, Copyright 2022 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

const ACTIVATION_STEP_REMINDER = 0;
const ACTIVATION_STEP_SETUP = 1;
const ACTIVATION_STEP_SUCCESS = 2;
const ACTIVATION_STEP_IN_PROGRESS = 3;
const ACTIVATION_ACKNOWLEDGEMENT_TOOLTIP_STATE_KEY = 'activation-acknowledgement-tooltip-state';
const GA4_ACTIVATION_BANNER_STATE_KEY = 'ga4-activation-banner-state';
const ENHANCED_MEASUREMENT_ACTIVATION_BANNER_TOOLTIP_STATE_KEY = 'enhanced-measurement-activation-banner-tooltip-state';
const LEGACY_ENHANCED_MEASUREMENT_ACTIVATION_BANNER_DISMISSED_ITEM_KEY = 'enhanced-measurement-activation-banner-dismissed-item';
const REPORT_ARGS_SELECTED_METRIC_KEY = '_r.explorerCard..selmet';
const REPORT_ARGS_SELECTED_DIMENSION_KEY = '_r.explorerCard..seldim';
const REPORT_ARGS_DATA_FILTERS_KEY = '_r..dataFilters';
const REPORT_ARGS_NAV_KEY = '_r..nav';
const KM_CONNECT_GA4_CTA_WIDGET_DISMISSED_ITEM_KEY = 'key-metrics-connect-ga4-cta-widget';

/**
 * Date that Site Kit will automatically switch to using GA4: September 25, 2023.
 *
 * With Site Kit's maximum date range being three months, once this period has passed since the UA cutoff date,
 * it will no longer be able to show any historical data for UA and will automatically switch to GA4.
 * For operational reasons, we automatically make the switch a few days before the three month cutoff point.
 *
 * @since 1.107.0
 * @see UA_CUTOFF_DATE.
 */
const GA4_AUTO_SWITCH_DATE = '2023-09-25';
const MODULE_SLUG_ANALYTICS_4 = 'analytics-4';

/***/ }),

/***/ "./js/modules/tagmanager/constants.js":
/*!********************************************!*\
  !*** ./js/modules/tagmanager/constants.js ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   MODULE_SLUG_TAGMANAGER: () => (/* binding */ MODULE_SLUG_TAGMANAGER)
/* harmony export */ });
/**
 * Tag Manager module constants.
 *
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

const MODULE_SLUG_TAGMANAGER = 'tagmanager';

/***/ }),

/***/ "./js/util/chart.js":
/*!**************************!*\
  !*** ./js/util/chart.js ***!
  \**************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   calculateDifferenceBetweenChartValues: () => (/* binding */ calculateDifferenceBetweenChartValues),
/* harmony export */   getChartDifferenceArrow: () => (/* binding */ getChartDifferenceArrow),
/* harmony export */   isSingleSlice: () => (/* binding */ isSingleSlice)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/@wordpress/element/build-module/serialize.js");
/* harmony import */ var _js_components_ChangeArrow__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @/js/components/ChangeArrow */ "./js/components/ChangeArrow.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Utility functions for charts.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */


/**
 * Gets the up/down SVG arrow for Google Chart tooltips.
 *
 * @since 1.30.0
 *
 * @param {number}  difference            The difference which can be positive or negative.
 * @param {string}  [options]             Options to be passed to the ChangeArrow component.
 * @param {boolean} [options.invertColor] Whether we need to reverse the +/- colors of the arrow.
 * @return {string} SVG for the +/- difference.
 */

function getChartDifferenceArrow(difference, options = {}) {
  if (Number.isNaN(Number(difference))) {
    return '';
  }
  const {
    invertColor = false
  } = options;
  return (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__["default"])(/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)(_js_components_ChangeArrow__WEBPACK_IMPORTED_MODULE_0__["default"], {
    direction: difference > 0 ? 'up' : 'down',
    invertColor: invertColor
  }));
}

/**
 * Checks if there is a single row of data or one row is contributing 100% of the total for a given dimension.
 *
 * @since 1.31.0
 *
 * @param {Array.<Object>} report An array of report data objects.
 * @return {(boolean|undefined)} Returns undefined if report is undefined, true/false for the above conditions.
 */
function isSingleSlice(report) {
  if (report === undefined) {
    return undefined;
  }
  if (report?.[0]?.data?.rows?.length === 1 || report?.[0]?.data?.rows?.[0]?.metrics?.[0]?.values?.[0] === report?.[0]?.data?.totals?.[0]?.values?.[0]) {
    return true;
  }
  return false;
}

/**
 * Calculates difference between two chart values.
 *
 * @since 1.48.0
 *
 * @param {number} currentValue  Current chart value.
 * @param {number} previousValue Previous chart value.
 * @return {number} The difference.
 */
function calculateDifferenceBetweenChartValues(currentValue, previousValue) {
  if (currentValue > 0 && previousValue > 0) {
    return currentValue / previousValue - 1;
  }
  if (currentValue > 0) {
    return 1;
  }
  if (previousValue > 0) {
    return -1;
  }
  return 0;
}

/***/ }),

/***/ "./js/util/convert-time.js":
/*!*********************************!*\
  !*** ./js/util/convert-time.js ***!
  \*********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   convertDateStringToUNIXTimestamp: () => (/* binding */ convertDateStringToUNIXTimestamp),
/* harmony export */   convertSecondsToArray: () => (/* binding */ convertSecondsToArray)
/* harmony export */ });
/**
 * Time related utility functions.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Converts seconds into an array with the following values [HH, MM, SS, MS] as described below.
 * HH: hours.
 * MM: minutes.
 * SS: seconds.
 * MS: milliseconds.
 *
 * For example, passing 196.385 returns [ 0, 3, 16, 385 ].
 *
 * @since 1.27.0
 *
 * @param {number} seconds The number of seconds.
 * @return {Array} Array containing the hours, minutes, seconds and milliseconds.
 */
function convertSecondsToArray(seconds) {
  seconds = parseFloat(seconds);
  if (isNaN(seconds) || 0 === seconds) {
    return [0, 0, 0, 0];
  }
  return [Math.floor(seconds / 60 / 60), Math.floor(seconds / 60 % 60), Math.floor(seconds % 60), Math.floor(seconds * 1000) - Math.floor(seconds) * 1000];
}

/**
 * Converts Date time string into UNIX timestamp in milliseconds.
 *
 * For example, passing "2014-10-02T15:01:23Z" returns 1412262083000.
 *
 * @since 1.116.0
 *
 * @param {string} dateStringValue The date time string.
 * @return {number} UNIX timestamp in milliseconds.
 */
function convertDateStringToUNIXTimestamp(dateStringValue) {
  const unixTimestamp = dateStringValue && !Number.isInteger(dateStringValue) ?
  // Valid use of `new Date()` with an argument, because this should only
  // be passed full time strings, not `YYYY-MM-DD` style dates.
  //
  // See: https://github.com/google/site-kit-wp/pull/9459#discussion_r1790660073
  // eslint-disable-next-line sitekit/no-direct-date
  new Date(dateStringValue).getTime() : dateStringValue;
  if (isNaN(unixTimestamp) || !unixTimestamp) {
    return 0;
  }
  return unixTimestamp;
}

/***/ }),

/***/ "./js/util/dates.js":
/*!**************************!*\
  !*** ./js/util/dates.js ***!
  \**************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   DAY_IN_SECONDS: () => (/* binding */ DAY_IN_SECONDS),
/* harmony export */   HOUR_IN_SECONDS: () => (/* binding */ HOUR_IN_SECONDS),
/* harmony export */   INVALID_DATE_INSTANCE_ERROR: () => (/* binding */ INVALID_DATE_INSTANCE_ERROR),
/* harmony export */   INVALID_DATE_RANGE_ERROR: () => (/* binding */ INVALID_DATE_RANGE_ERROR),
/* harmony export */   INVALID_DATE_STRING_ERROR: () => (/* binding */ INVALID_DATE_STRING_ERROR),
/* harmony export */   MINUTE_IN_SECONDS: () => (/* binding */ MINUTE_IN_SECONDS),
/* harmony export */   MONTH_IN_SECONDS: () => (/* binding */ MONTH_IN_SECONDS),
/* harmony export */   WEEK_IN_SECONDS: () => (/* binding */ WEEK_IN_SECONDS),
/* harmony export */   dateSub: () => (/* binding */ dateSub),
/* harmony export */   getAvailableDateRanges: () => (/* binding */ getAvailableDateRanges),
/* harmony export */   getCurrentDateRangeDayCount: () => (/* binding */ getCurrentDateRangeDayCount),
/* harmony export */   getDateString: () => (/* binding */ getDateString),
/* harmony export */   getPreviousDate: () => (/* binding */ getPreviousDate),
/* harmony export */   isValidDateRange: () => (/* binding */ isValidDateRange),
/* harmony export */   isValidDateString: () => (/* binding */ isValidDateString),
/* harmony export */   stringToDate: () => (/* binding */ stringToDate)
/* harmony export */ });
/* harmony import */ var invariant__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! invariant */ "../node_modules/invariant/browser.js");
/* harmony import */ var invariant__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(invariant__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! lodash */ "../node_modules/lodash/lodash.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__);
/**
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * WordPress dependencies
 */

const INVALID_DATE_INSTANCE_ERROR = 'Date param must construct to a valid date instance or be a valid date instance itself.';
const INVALID_DATE_STRING_ERROR = 'Invalid dateString parameter, it must be a string.';
const INVALID_DATE_RANGE_ERROR = 'Invalid date range, it must be a string with the format "last-x-days".';
const MINUTE_IN_SECONDS = 60;
const HOUR_IN_SECONDS = 60 * MINUTE_IN_SECONDS;
const DAY_IN_SECONDS = 24 * HOUR_IN_SECONDS;
const WEEK_IN_SECONDS = 7 * DAY_IN_SECONDS;
const MONTH_IN_SECONDS = 30 * DAY_IN_SECONDS;

/**
 * Gets the hash of available date ranges.
 *
 * @since 1.12.0
 *
 * @return {Object} The object hash where every key is a date range slug, and the value is an object with the date range slug and its translation.
 */
function getAvailableDateRanges() {
  function label(days) {
    return (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.sprintf)(/* translators: %s: number of days */
    (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__._n)('Last %s day', 'Last %s days', days, 'google-site-kit'), days);
  }
  return {
    'last-7-days': {
      slug: 'last-7-days',
      label: label(7),
      days: 7
    },
    'last-14-days': {
      slug: 'last-14-days',
      label: label(14),
      days: 14
    },
    'last-28-days': {
      slug: 'last-28-days',
      label: label(28),
      days: 28
    },
    'last-90-days': {
      slug: 'last-90-days',
      label: label(90),
      days: 90
    }
  };
}

/**
 * Gets the current dateRange day count.
 *
 * @since 1.19.0
 * @since 1.26.0 `dateRange` is now a required argument.
 *
 * @param {string} dateRange The date range slug.
 * @return {number} The number of days in the range.
 */
function getCurrentDateRangeDayCount(dateRange) {
  const daysMatch = dateRange.match(/last-(\d+)-days/);
  if (daysMatch && daysMatch[1]) {
    return parseInt(daysMatch[1], 10);
  }
  throw new Error('Unrecognized date range slug.');
}

/**
 * Asserts whether a given date string is valid or invalid.
 *
 * @since 1.18.0
 *
 * @param {string} dateString Date string to be asserted against. Defaults to an empty string.
 * @return {boolean}          True if the given date string is valid.
 */
function isValidDateString(dateString = '') {
  if (!(0,lodash__WEBPACK_IMPORTED_MODULE_1__.isString)(dateString)) {
    return false;
  }
  const dateArray = dateString.split('-');
  if (dateArray.length !== 3) {
    return false;
  }

  // Valid use of `new Date()`, constructing a new date from the string.
  // eslint-disable-next-line sitekit/no-direct-date
  const date = new Date(dateString);
  return (0,lodash__WEBPACK_IMPORTED_MODULE_1__.isDate)(date) && !isNaN(date);
}

/**
 * Parses the given Date instance and returns a date string (YYYY-MM-DD).
 *
 * @since 1.18.0
 * @since 1.85.0 Updated the function signature to only accept a Date argument.
 *
 * @param {Date} date Date to parse into a string.
 * @return {string}                 The parsed date string (YYYY-MM-DD).
 */
function getDateString(date) {
  invariant__WEBPACK_IMPORTED_MODULE_0___default()((0,lodash__WEBPACK_IMPORTED_MODULE_1__.isDate)(date) && !isNaN(date), INVALID_DATE_INSTANCE_ERROR);
  const month = `${date.getMonth() + 1}`;
  const day = `${date.getDate()}`;
  const year = date.getFullYear();
  return [year, month.length < 2 ? `0${month}` : month, day.length < 2 ? `0${day}` : day].join('-');
}

/**
 * Converts a valid date string to a Date instance.
 *
 * @since 1.38.0
 *
 * @param {string} dateString The date string to parse.
 * @return {Date} Date instance.
 */
function stringToDate(dateString) {
  invariant__WEBPACK_IMPORTED_MODULE_0___default()(isValidDateString(dateString), INVALID_DATE_STRING_ERROR);

  /**
   * Split date into explicit parts rather than pass directly into date constructor
   * to avoid timezone issues caused by parsing as UTC. Ensures date is accurate for
   * the user's local time, otherwise has a chance to return a different day than was
   * passed in depending on timezone.
   */
  const [year, month, day] = dateString.split('-');
  return new Date(year, month - 1, day);
}

/**
 * Parses the given date and returns the previous date (daysBefore).
 *
 * @since 1.18.0
 *
 * @param {string} relativeDate Date string (YYYY-MM-DD) to subtract days from.
 * @param {number} daysBefore   Number of days to subtract from relativeDate.
 * @return {string}             The date string (YYYY-MM-DD) for the previous date.
 */
function getPreviousDate(relativeDate, daysBefore) {
  return getDateString(dateSub(relativeDate, daysBefore * DAY_IN_SECONDS));
}

/**
 * Asserts whether a given dateRange string is valid or invalid.
 *
 * @since 1.18.0
 *
 * @param {string} dateRange Date string to be asserted against. Defaults to an empty string.
 * @return {boolean}          True if the given dateRange string is valid.
 */
function isValidDateRange(dateRange) {
  const parts = dateRange.split('-');
  return parts.length === 3 && parts[0] === 'last' && !Number.isNaN(parts[1]) && !Number.isNaN(parseFloat(parts[1])) && parts[2] === 'days';
}

/**
 * Subtracts duration from the prodived date and returns it.
 *
 * @since 1.132.0
 *
 * @param {Date|string} relativeDate Date string (YYYY-MM-DD) or date object to subtract duration from.
 * @param {number}      duration     The duration in seconds to subtract from relativeDate.
 * @return {Date} Resulting date.
 */
function dateSub(relativeDate, duration) {
  invariant__WEBPACK_IMPORTED_MODULE_0___default()(isValidDateString(relativeDate) || (0,lodash__WEBPACK_IMPORTED_MODULE_1__.isDate)(relativeDate) && !isNaN(relativeDate), INVALID_DATE_STRING_ERROR);
  const timestamp = isValidDateString(relativeDate) ? Date.parse(relativeDate) : relativeDate.getTime();

  // Valid use of `new Date()` using calculations.
  // eslint-disable-next-line sitekit/no-direct-date
  return new Date(timestamp - duration * 1000);
}

/***/ }),

/***/ "./js/util/i18n.js":
/*!*************************!*\
  !*** ./js/util/i18n.js ***!
  \*************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   createDurationFormat: () => (/* binding */ createDurationFormat),
/* harmony export */   expandNumFmtOptions: () => (/* binding */ expandNumFmtOptions),
/* harmony export */   getLocale: () => (/* binding */ getLocale),
/* harmony export */   listFormat: () => (/* binding */ listFormat),
/* harmony export */   numFmt: () => (/* binding */ numFmt),
/* harmony export */   numberFormat: () => (/* binding */ numberFormat),
/* harmony export */   prepareForReadableLargeNumber: () => (/* binding */ prepareForReadableLargeNumber),
/* harmony export */   readableLargeNumber: () => (/* binding */ readableLargeNumber)
/* harmony export */ });
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! lodash */ "../node_modules/lodash/lodash.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var memize__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! memize */ "../node_modules/memize/index.js");
/* harmony import */ var memize__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(memize__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__);
/**
 * Internationalization Utilities.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * WordPress dependencies
 */


/**
 * Converts seconds to a display ready string indicating
 * the number of hours, minutes and seconds that have elapsed.
 *
 * For example, passing 65 returns '1m 5s'.
 *
 * @since 1.0.0
 * @since 1.28.0 Refactored and renamed to improve localization.
 * @private
 *
 * @param {number}                     durationInSeconds The number of seconds.
 * @param {(Intl.NumberFormatOptions)} [options]         Optional formatting options.
 * @return {string} Human readable string indicating time elapsed.
 */
function durationFormat(durationInSeconds, options = {}) {
  const {
    formatUnit,
    formatDecimal
  } = createDurationFormat(durationInSeconds, options);
  try {
    // Some browsers, e.g. Safari, throw a RangeError when options.style is
    // not one of decimal, percent, or currency.
    return formatUnit();
  } catch {
    // Fallback to XXh YYm ZZs using localized decimals with hardcoded units.
    return formatDecimal();
  }
}

/**
 * Converts seconds to a display ready string indicating
 * the number of hours, minutes and seconds that have elapsed
 * in ISO format - HH:mm:ss.
 *
 * If the duration is less than an hour, the HH part of the string
 * is truncated.
 * For example, passing 65 returns '01:05'.
 * Passing 5400 returns '01:30:00'.
 *
 * @since 1.111.0
 * @private
 *
 * @param {number} durationInSeconds The number of seconds.
 * @return {string} Human readable string indicating time elapsed.
 */
function durationISOFormat(durationInSeconds) {
  let {
    hours,
    minutes,
    seconds
  } = parseDuration(durationInSeconds);
  seconds = ('0' + seconds).slice(-2);
  minutes = ('0' + minutes).slice(-2);
  hours = ('0' + hours).slice(-2);
  return hours === '00' ? `${minutes}:${seconds}` : `${hours}:${minutes}:${seconds}`;
}

/**
 * Parses the duration in seconds into hours, minutes and seconds.
 *
 * @since 1.111.0
 * @private
 *
 * @param {number} durationInSeconds The number of seconds.
 * @return {Object} Number of hours, minutes and seconds equivalent
 * to the given duration in seconds.
 */
function parseDuration(durationInSeconds) {
  durationInSeconds = parseInt(durationInSeconds, 10);
  if (Number.isNaN(durationInSeconds)) {
    durationInSeconds = 0;
  }
  const hours = Math.floor(durationInSeconds / 60 / 60);
  const minutes = Math.floor(durationInSeconds / 60 % 60);
  const seconds = Math.floor(durationInSeconds % 60);
  return {
    hours,
    minutes,
    seconds
  };
}

/**
 * Creates duration formatting utilities.
 *
 * Not intended to be used directly.
 * Use `numFmt( number, { style: 'duration' } )` instead.
 *
 * @since 1.29.0
 * @private
 *
 * @param {number} durationInSeconds Duration to format.
 * @param {Object} [options]         Formatting options.
 * @return {Object} Formatting functions.
 */
function createDurationFormat(durationInSeconds, options = {}) {
  const {
    hours,
    minutes,
    seconds
  } = parseDuration(durationInSeconds);
  return {
    hours,
    minutes,
    seconds,
    formatUnit() {
      const {
        unitDisplay = 'short',
        ...restOptions
      } = options;
      const commonOptions = {
        unitDisplay,
        ...restOptions,
        style: 'unit'
      };
      if (durationInSeconds === 0) {
        return numberFormat(seconds, {
          ...commonOptions,
          unit: 'second'
        });
      }
      return (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.sprintf)(/* translators: 1: formatted seconds, 2: formatted minutes, 3: formatted hours */
      (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__._x)('%3$s %2$s %1$s', 'duration of time: hh mm ss', 'google-site-kit'), seconds ? numberFormat(seconds, {
        ...commonOptions,
        unit: 'second'
      }) : '', minutes ? numberFormat(minutes, {
        ...commonOptions,
        unit: 'minute'
      }) : '', hours ? numberFormat(hours, {
        ...commonOptions,
        unit: 'hour'
      }) : '').trim();
    },
    /**
     * Formats the duration using integers and translatable strings.
     * This is only used as a fallback when the above `formatUnit` fails.
     *
     * @since 1.29.0
     *
     * @return {string} Formatted duration.
     */
    formatDecimal() {
      const formattedSeconds = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.sprintf)(
      // translators: %s: number of seconds with "s" as the abbreviated unit.
      (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('%ds', 'google-site-kit'), seconds);
      if (durationInSeconds === 0) {
        return formattedSeconds;
      }
      const formattedMinutes = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.sprintf)(
      // translators: %s: number of minutes with "m" as the abbreviated unit.
      (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('%dm', 'google-site-kit'), minutes);
      const formattedHours = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.sprintf)(
      // translators: %s: number of hours with "h" as the abbreviated unit.
      (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('%dh', 'google-site-kit'), hours);
      return (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.sprintf)(/* translators: 1: formatted seconds, 2: formatted minutes, 3: formatted hours */
      (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__._x)('%3$s %2$s %1$s', 'duration of time: hh mm ss', 'google-site-kit'), seconds ? formattedSeconds : '', minutes ? formattedMinutes : '', hours ? formattedHours : '').trim();
    }
  };
}

/**
 * Prepares a number to be used in readableLargeNumber.
 *
 * @since 1.7.0
 *
 * @param {number} number The large number to prepare.
 * @return {number} The prepared number.
 */
function prepareForReadableLargeNumber(number) {
  if (1000000 <= number) {
    return Math.round(number / 100000) / 10;
  }
  if (10000 <= number) {
    return Math.round(number / 1000);
  }
  if (1000 <= number) {
    return Math.round(number / 100) / 10;
  }
  return number;
}

/**
 * Formats a large number for shortened display.
 *
 * @since 1.0.0
 *
 * @param {number} number The large number to format.
 * @return {string} The formatted number.
 */
function readableLargeNumber(number) {
  const withSingleDecimal = {
    minimumFractionDigits: 1,
    maximumFractionDigits: 1
  };

  // Numbers over 1,000,000 round normally and display a single decimal unless the decimal is 0.
  if (1000000 <= number) {
    return (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.sprintf)(
    // translators: %s: an abbreviated number in millions.
    (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('%sM', 'google-site-kit'), numberFormat(prepareForReadableLargeNumber(number), number % 10 === 0 ? {} : withSingleDecimal));
  }

  // Numbers between 10,000 and 1,000,000 round normally and have no decimals
  if (10000 <= number) {
    return (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.sprintf)(
    // translators: %s: an abbreviated number in thousands.
    (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('%sK', 'google-site-kit'), numberFormat(prepareForReadableLargeNumber(number)));
  }

  // Numbers between 1,000 and 10,000 round normally and display a single decimal unless the decimal is 0.
  if (1000 <= number) {
    return (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.sprintf)(
    // translators: %s: an abbreviated number in thousands.
    (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('%sK', 'google-site-kit'), numberFormat(prepareForReadableLargeNumber(number), number % 10 === 0 ? {} : withSingleDecimal));
  }
  return numberFormat(number, {
    signDisplay: 'never',
    maximumFractionDigits: 1
  });
}

/**
 * Parses formatting options and returns an object with options for selected formatting.
 *
 * @since 1.103.0
 *
 * @param {(Intl.NumberFormatOptions|string)} options Formatting options or unit shorthand. Possible shorthand values are '%', 's', or a currency code.
 * @return {Object} Formatting options.
 */
function expandNumFmtOptions(options) {
  let formatOptions = {};

  // Expand shorthand values for units.
  if ('%' === options) {
    formatOptions = {
      style: 'percent',
      maximumFractionDigits: 2
    };
  } else if ('s' === options) {
    formatOptions = {
      style: 'duration',
      unitDisplay: 'narrow'
    };
  } else if (!!options && typeof options === 'string') {
    formatOptions = {
      style: 'currency',
      currency: options
    };
  } else if ((0,lodash__WEBPACK_IMPORTED_MODULE_0__.isPlainObject)(options)) {
    formatOptions = {
      ...options
    };
  }
  return formatOptions;
}

/**
 * Formats a number with unit using the JS Internationalization Number Format API.
 *
 * In addition to the supported 'style' values of the lower-level `numberFormat` function, this function
 * supports two additional 'style' values 'metric' and 'duration' (expects a number in seconds).
 *
 * Another differentiation in behavior is that by default the function will use 'metric' formatting instead
 * of 'decimal' formatting.
 *
 * @since 1.24.0
 *
 * @param {number|string}                     number    The number to format.
 * @param {(Intl.NumberFormatOptions|string)} [options] Formatting options or unit shorthand.
 *                                                      Possible shorthand values are '%', 's',
 *                                                      or a currency code.
 * @return {string} The formatted number.
 */
function numFmt(number, options = {}) {
  // Cast parsable values to numeric types.
  number = (0,lodash__WEBPACK_IMPORTED_MODULE_0__.isFinite)(number) ? number : Number(number);
  if (!(0,lodash__WEBPACK_IMPORTED_MODULE_0__.isFinite)(number)) {
    // eslint-disable-next-line no-console
    console.warn('Invalid number', number, typeof number);
    number = 0;
  }
  const formatOptions = expandNumFmtOptions(options);
  const {
    style = 'metric'
  } = formatOptions; // Note: `metric` is our custom, default style.

  if ('metric' === style) {
    return readableLargeNumber(number);
  }
  if ('duration' === style) {
    return durationFormat(number, formatOptions);
  }
  if ('durationISO' === style) {
    return durationISOFormat(number);
  }
  return numberFormat(number, formatOptions);
}

// Warn once for a given message.
const warnOnce = memize__WEBPACK_IMPORTED_MODULE_1___default()(console.warn); // eslint-disable-line no-console

/**
 * Formats a number using the JS Internationalization Number Format API.
 *
 * @since 1.8.0
 * @see {@link https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/NumberFormat/NumberFormat|`options` parameter} For all available formatting options.
 *
 * @param {number}                   number           The number to format.
 * @param {Intl.NumberFormatOptions} [options]        Formatting options.
 * @param {string}                   [options.locale] Locale to use for formatting. Defaults to current locale used by Site Kit.
 * @return {string} The formatted number.
 */
function numberFormat(number, options = {}) {
  const {
    locale = getLocale(),
    ...formatOptions
  } = options;
  try {
    /**
     * Per https://github.com/google/site-kit-wp/issues/3255 there have been issues with some versions of Safari
     * on some operating systems throwing issues with some parameters in the formatOptions.
     *
     * If an error is thrown, we remove some troublesome params from the formatOptions object and fallback to no formatting.
     *
     * This allows us to degrade somewhat gracefully without breaking the dashboard for users of unaffected browsers.
     */
    return new Intl.NumberFormat(locale, formatOptions).format(number);
  } catch (error) {
    warnOnce(`Site Kit numberFormat error: Intl.NumberFormat( ${JSON.stringify(locale)}, ${JSON.stringify(formatOptions)} ).format( ${typeof number} )`, error.message);
  }

  // Remove these key/values from formatOptions.
  const unstableFormatOptionValues = {
    currencyDisplay: 'narrow',
    currencySign: 'accounting',
    style: 'unit'
  };

  // Remove these keys from formatOptions irrespective of value.
  const unstableFormatOptions = ['signDisplay', 'compactDisplay'];
  const reducedFormatOptions = {};
  for (const [key, value] of Object.entries(formatOptions)) {
    if (unstableFormatOptionValues[key] && value === unstableFormatOptionValues[key]) {
      continue;
    }
    if (unstableFormatOptions.includes(key)) {
      continue;
    }
    reducedFormatOptions[key] = value;
  }
  try {
    return new Intl.NumberFormat(locale, reducedFormatOptions).format(number);
  } catch {
    return new Intl.NumberFormat(locale).format(number);
  }
}

/**
 * Flattens an array of strings into a string using the JS Internationalization List Format API.
 *
 * @since 1.23.0
 * @see {@link https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Intl/ListFormat/ListFormat|`options` parameter} For all available options.
 *
 * @param {Array}  list             The list to flatten.
 * @param {Object} [options]        Formatting options.
 * @param {string} [options.locale] Locale to use for formatting. Defaults to current locale used by Site Kit.
 * @param {string} [options.style]  Length of the formatted message. Defaults to long.
 * @param {string} [options.type]   Type of list. Defaults to 'conjunction' (A, B, and C).
 *                                  Also available 'disjunction' (A, B, or C)
 *                                  Also available 'unit' (5 pounds, 12 ounces)
 * @return {string} The flattened list.
 */
function listFormat(list, options = {}) {
  const {
    locale = getLocale(),
    style = 'long',
    type = 'conjunction'
  } = options;

  // Not all browsers support Intl.Listformat per
  // https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Intl/ListFormat/ListFormat#Browser_compatibility
  // We've seen that the built versions don't polyfill for the unsupported browsers (iOS/safari) so we provide a fallback.
  if (Intl.ListFormat) {
    const formatter = new Intl.ListFormat(locale, {
      style,
      type
    });
    return formatter.format(list);
  }

  /* translators: used between list items, there is a space after the comma. */
  const listSeparator = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)(', ', 'google-site-kit');
  return list.join(listSeparator);
}

/**
 * Gets the current locale for use with browser APIs.
 *
 * @since 1.8.0
 *
 * @param {Object} _global The global window object.
 * @return {string} Current Site Kit locale if set, otherwise the current language set by the browser.
 *                  E.g. `en-US` or `de-DE`
 */
function getLocale(_global = __webpack_require__.g) {
  const siteKitLocale = (0,lodash__WEBPACK_IMPORTED_MODULE_0__.get)(_global, ['_googlesitekitLegacyData', 'locale']);
  if (siteKitLocale) {
    const matches = siteKitLocale.match(/^(\w{2})?(_)?(\w{2})/);
    if (matches && matches[0]) {
      return matches[0].replace(/_/g, '-');
    }
  }
  return _global.navigator.language;
}

/***/ }),

/***/ "./js/util/index.js":
/*!**************************!*\
  !*** ./js/util/index.js ***!
  \**************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   DAY_IN_SECONDS: () => (/* reexport safe */ _dates__WEBPACK_IMPORTED_MODULE_8__.DAY_IN_SECONDS),
/* harmony export */   HOUR_IN_SECONDS: () => (/* reexport safe */ _dates__WEBPACK_IMPORTED_MODULE_8__.HOUR_IN_SECONDS),
/* harmony export */   INVALID_DATE_INSTANCE_ERROR: () => (/* reexport safe */ _dates__WEBPACK_IMPORTED_MODULE_8__.INVALID_DATE_INSTANCE_ERROR),
/* harmony export */   INVALID_DATE_RANGE_ERROR: () => (/* reexport safe */ _dates__WEBPACK_IMPORTED_MODULE_8__.INVALID_DATE_RANGE_ERROR),
/* harmony export */   INVALID_DATE_STRING_ERROR: () => (/* reexport safe */ _dates__WEBPACK_IMPORTED_MODULE_8__.INVALID_DATE_STRING_ERROR),
/* harmony export */   MINUTE_IN_SECONDS: () => (/* reexport safe */ _dates__WEBPACK_IMPORTED_MODULE_8__.MINUTE_IN_SECONDS),
/* harmony export */   MONTH_IN_SECONDS: () => (/* reexport safe */ _dates__WEBPACK_IMPORTED_MODULE_8__.MONTH_IN_SECONDS),
/* harmony export */   WEEK_IN_SECONDS: () => (/* reexport safe */ _dates__WEBPACK_IMPORTED_MODULE_8__.WEEK_IN_SECONDS),
/* harmony export */   calculateChange: () => (/* binding */ calculateChange),
/* harmony export */   calculateDifferenceBetweenChartValues: () => (/* reexport safe */ _chart__WEBPACK_IMPORTED_MODULE_9__.calculateDifferenceBetweenChartValues),
/* harmony export */   convertDateStringToUNIXTimestamp: () => (/* reexport safe */ _convert_time__WEBPACK_IMPORTED_MODULE_7__.convertDateStringToUNIXTimestamp),
/* harmony export */   convertSecondsToArray: () => (/* reexport safe */ _convert_time__WEBPACK_IMPORTED_MODULE_7__.convertSecondsToArray),
/* harmony export */   createDurationFormat: () => (/* reexport safe */ _i18n__WEBPACK_IMPORTED_MODULE_5__.createDurationFormat),
/* harmony export */   dateSub: () => (/* reexport safe */ _dates__WEBPACK_IMPORTED_MODULE_8__.dateSub),
/* harmony export */   decodeHTMLEntity: () => (/* binding */ decodeHTMLEntity),
/* harmony export */   expandNumFmtOptions: () => (/* reexport safe */ _i18n__WEBPACK_IMPORTED_MODULE_5__.expandNumFmtOptions),
/* harmony export */   getAvailableDateRanges: () => (/* reexport safe */ _dates__WEBPACK_IMPORTED_MODULE_8__.getAvailableDateRanges),
/* harmony export */   getChartDifferenceArrow: () => (/* reexport safe */ _chart__WEBPACK_IMPORTED_MODULE_9__.getChartDifferenceArrow),
/* harmony export */   getCurrentDateRangeDayCount: () => (/* reexport safe */ _dates__WEBPACK_IMPORTED_MODULE_8__.getCurrentDateRangeDayCount),
/* harmony export */   getDateString: () => (/* reexport safe */ _dates__WEBPACK_IMPORTED_MODULE_8__.getDateString),
/* harmony export */   getFullURL: () => (/* reexport safe */ _urls__WEBPACK_IMPORTED_MODULE_10__.getFullURL),
/* harmony export */   getLocale: () => (/* reexport safe */ _i18n__WEBPACK_IMPORTED_MODULE_5__.getLocale),
/* harmony export */   getPreviousDate: () => (/* reexport safe */ _dates__WEBPACK_IMPORTED_MODULE_8__.getPreviousDate),
/* harmony export */   getStorage: () => (/* reexport safe */ _storage__WEBPACK_IMPORTED_MODULE_4__.getStorage),
/* harmony export */   getURLPath: () => (/* reexport safe */ _urls__WEBPACK_IMPORTED_MODULE_10__.getURLPath),
/* harmony export */   isHashOnly: () => (/* reexport safe */ _urls__WEBPACK_IMPORTED_MODULE_10__.isHashOnly),
/* harmony export */   isNumeric: () => (/* reexport safe */ _isnumeric__WEBPACK_IMPORTED_MODULE_12__.isNumeric),
/* harmony export */   isSingleSlice: () => (/* reexport safe */ _chart__WEBPACK_IMPORTED_MODULE_9__.isSingleSlice),
/* harmony export */   isValidDateRange: () => (/* reexport safe */ _dates__WEBPACK_IMPORTED_MODULE_8__.isValidDateRange),
/* harmony export */   isValidDateString: () => (/* reexport safe */ _dates__WEBPACK_IMPORTED_MODULE_8__.isValidDateString),
/* harmony export */   isValidNumericID: () => (/* reexport safe */ _is_valid_numeric_id__WEBPACK_IMPORTED_MODULE_11__.isValidNumericID),
/* harmony export */   listFormat: () => (/* reexport safe */ _i18n__WEBPACK_IMPORTED_MODULE_5__.listFormat),
/* harmony export */   markdownToHTML: () => (/* reexport safe */ _markdown__WEBPACK_IMPORTED_MODULE_6__.markdownToHTML),
/* harmony export */   normalizeURL: () => (/* reexport safe */ _urls__WEBPACK_IMPORTED_MODULE_10__.normalizeURL),
/* harmony export */   numFmt: () => (/* reexport safe */ _i18n__WEBPACK_IMPORTED_MODULE_5__.numFmt),
/* harmony export */   numberFormat: () => (/* reexport safe */ _i18n__WEBPACK_IMPORTED_MODULE_5__.numberFormat),
/* harmony export */   partitionReport: () => (/* reexport safe */ _partition_report__WEBPACK_IMPORTED_MODULE_14__.partitionReport),
/* harmony export */   prepareForReadableLargeNumber: () => (/* reexport safe */ _i18n__WEBPACK_IMPORTED_MODULE_5__.prepareForReadableLargeNumber),
/* harmony export */   readableLargeNumber: () => (/* reexport safe */ _i18n__WEBPACK_IMPORTED_MODULE_5__.readableLargeNumber),
/* harmony export */   safelySort: () => (/* reexport safe */ _safely_sort__WEBPACK_IMPORTED_MODULE_13__.safelySort),
/* harmony export */   sanitizeHTML: () => (/* reexport safe */ _sanitize__WEBPACK_IMPORTED_MODULE_2__.sanitizeHTML),
/* harmony export */   shortenURL: () => (/* reexport safe */ _urls__WEBPACK_IMPORTED_MODULE_10__.shortenURL),
/* harmony export */   storageAvailable: () => (/* reexport safe */ _storage__WEBPACK_IMPORTED_MODULE_4__.storageAvailable),
/* harmony export */   stringToDate: () => (/* reexport safe */ _dates__WEBPACK_IMPORTED_MODULE_8__.stringToDate),
/* harmony export */   stringifyObject: () => (/* reexport safe */ _stringify__WEBPACK_IMPORTED_MODULE_3__.stringifyObject),
/* harmony export */   trackEvent: () => (/* reexport safe */ _tracking__WEBPACK_IMPORTED_MODULE_1__.trackEvent),
/* harmony export */   trackEventOnce: () => (/* reexport safe */ _tracking__WEBPACK_IMPORTED_MODULE_1__.trackEventOnce),
/* harmony export */   untrailingslashit: () => (/* reexport safe */ _sanitize__WEBPACK_IMPORTED_MODULE_2__.untrailingslashit),
/* harmony export */   validateJSON: () => (/* binding */ validateJSON)
/* harmony export */ });
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! lodash */ "../node_modules/lodash/lodash.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _tracking__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./tracking */ "./js/util/tracking/index.js");
/* harmony import */ var _sanitize__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./sanitize */ "./js/util/sanitize.js");
/* harmony import */ var _stringify__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./stringify */ "./js/util/stringify.js");
/* harmony import */ var _storage__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./storage */ "./js/util/storage.js");
/* harmony import */ var _i18n__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./i18n */ "./js/util/i18n.js");
/* harmony import */ var _markdown__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./markdown */ "./js/util/markdown.js");
/* harmony import */ var _convert_time__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./convert-time */ "./js/util/convert-time.js");
/* harmony import */ var _dates__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./dates */ "./js/util/dates.js");
/* harmony import */ var _chart__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./chart */ "./js/util/chart.js");
/* harmony import */ var _urls__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./urls */ "./js/util/urls.js");
/* harmony import */ var _is_valid_numeric_id__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./is-valid-numeric-id */ "./js/util/is-valid-numeric-id.js");
/* harmony import */ var _isnumeric__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ./isnumeric */ "./js/util/isnumeric.js");
/* harmony import */ var _safely_sort__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ./safely-sort */ "./js/util/safely-sort.js");
/* harmony import */ var _partition_report__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ./partition-report */ "./js/util/partition-report.js");
/**
 * Utility functions.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * Internal dependencies
 */
















/**
 * Calculates the change between two values.
 *
 * @since 1.24.0
 *
 * @param {number} previous The previous value.
 * @param {number} current  The current value.
 * @return {(number|null)} The percent change. Null if the input or output is invalid.
 */
function calculateChange(previous, current) {
  function isZero(value) {
    return value === '0' || value === 0;
  }

  // Prevent null result when both values are legitimately zero.
  if (isZero(previous) && isZero(current)) {
    return 0;
  }

  // Prevent divide by zero errors.
  if (isZero(previous) || Number.isNaN(previous)) {
    return null;
  }

  // Avoid NaN at all costs.
  const change = (current - previous) / previous;
  if (Number.isNaN(change) || !Number.isFinite(change)) {
    return null;
  }
  return change;
}

/**
 * Verifies whether JSON is valid.
 *
 * @since 1.0.0
 *
 * @param {string} stringToValidate The string to validate.
 * @return {boolean} Indicates JSON is valid.
 */
function validateJSON(stringToValidate) {
  try {
    return JSON.parse(stringToValidate) && !!stringToValidate;
  } catch (e) {
    return false;
  }
}

/**
 * Converts HTML text into an HTML entity.
 *
 * _.unescape doesn't seem to decode some entities for admin bar titles.
 * adding combination in this helper as a workaround.
 *
 * @since 1.0.0
 *
 * @param {string} str The string to decode.
 * @return {string} Decoded HTML entity.
 */
function decodeHTMLEntity(str) {
  if (!str) {
    return '';
  }
  const decoded = str.replace(/&#(\d+);/g, (match, dec) => {
    return String.fromCharCode(dec);
  }).replace(/(\\)/g, '');
  return (0,lodash__WEBPACK_IMPORTED_MODULE_0__.unescape)(decoded);
}

/***/ }),

/***/ "./js/util/is-valid-numeric-id.js":
/*!****************************************!*\
  !*** ./js/util/is-valid-numeric-id.js ***!
  \****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   isValidNumericID: () => (/* binding */ isValidNumericID)
/* harmony export */ });
/**
 * Utility function related to checking if a given value is numeric.
 *
 * Site Kit by Google, Copyright 2022 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Checks the given value to see if it is a positive integer.
 *
 * @since 1.11.0 Function introduced.
 * @since 1.90.0 Moved outside Tag Manager to a generic utility function.
 *
 * @param {*} input Value to check.
 * @return {boolean} Validity.
 */
function isValidNumericID(input) {
  const id = parseFloat(input) || 0;
  if (!Number.isInteger(id)) {
    return false;
  }
  return id > 0;
}

/***/ }),

/***/ "./js/util/isnumeric.js":
/*!******************************!*\
  !*** ./js/util/isnumeric.js ***!
  \******************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   isNumeric: () => (/* binding */ isNumeric)
/* harmony export */ });
/**
 * Utility function related to checking if a given value is numeric.
 *
 * Site Kit by Google, Copyright 2022 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Checks if a given value is numeric.
 *
 * @since 1.80.0
 *
 * @param {*} value The value to check.
 * @return {boolean} TRUE if a value is numeric FALSE otherwise.
 */
function isNumeric(value) {
  if (typeof value === 'number') {
    return true;
  }
  const string = (value || '').toString();
  if (!string) {
    return false;
  }
  return !isNaN(string);
}

/***/ }),

/***/ "./js/util/markdown.js":
/*!*****************************!*\
  !*** ./js/util/markdown.js ***!
  \*****************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   markdownToHTML: () => (/* binding */ markdownToHTML)
/* harmony export */ });
/**
 * Markdown utility.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Replaces markdown links with its HTML equivalents.
 *
 * @since 1.22.0
 *
 * @param {string} text Markdown text.
 * @return {string} Text with HTML links.
 */
function markdownLinks(text) {
  return text.replace(new RegExp('\\[([^\\]]+)\\]\\((https?://[^/]+\\.\\w+/?.*?)\\)', 'gi'), '<a href="$2" target="_blank" rel="noopener noreferrer">$1</a>');
}

/**
 * Adds paragraphs to the text.
 *
 * @since 1.22.0
 *
 * @param {string} text Markdown text.
 * @return {string} Text with HTML links.
 */
function markdownParagraphs(text) {
  return `<p>${text.replace(/\n{2,}/g, '</p><p>')}</p>`;
}

/**
 * Replaces line breaks in the text.
 *
 * @since 1.22.0
 *
 * @param {string} text Markdown text.
 * @return {string} Text with HTML links.
 */
function markdownBreaks(text) {
  return text.replace(/\n/gi, '<br>');
}

/**
 * Converts markdown to HTML.
 *
 * @since 1.22.0
 *
 * @param {string} text Markdown text.
 * @return {string} HTML version of the markdown text.
 */
function markdownToHTML(text) {
  const rules = [markdownLinks, markdownParagraphs, markdownBreaks];
  let html = text;
  for (const rule of rules) {
    html = rule(html);
  }
  return html;
}

/***/ }),

/***/ "./js/util/negate.js":
/*!***************************!*\
  !*** ./js/util/negate.js ***!
  \***************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   negateDefined: () => (/* binding */ negateDefined)
/* harmony export */ });
/**
 * Negation utils.
 *
 * Site Kit by Google, Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Negates a defined value.
 *
 * @since 1.99.0
 *
 * @param {*} value The value to negate.
 * @return {(boolean|undefined)} The negated value, if defined.
 */
function negateDefined(value) {
  if (value === undefined) {
    return undefined;
  }
  return !value;
}

/***/ }),

/***/ "./js/util/partition-report.js":
/*!*************************************!*\
  !*** ./js/util/partition-report.js ***!
  \*************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   partitionReport: () => (/* binding */ partitionReport)
/* harmony export */ });
/* harmony import */ var invariant__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! invariant */ "../node_modules/invariant/browser.js");
/* harmony import */ var invariant__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(invariant__WEBPACK_IMPORTED_MODULE_0__);
/**
 * Report partitioning utility.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * Splits report data into segments for current and comparison ranges.
 *
 * @since 1.33.0
 * @since 1.34.0 Updated to support incomplete `report` arrays.
 *
 * @param {Array}  report               Report rows.
 * @param {Object} args                 Additional arguments.
 * @param {number} args.dateRangeLength Date range length of report segments.
 * @return {Object} Object with keys for `compareRange` and `currentRange`.
 */
function partitionReport(report, {
  dateRangeLength
}) {
  invariant__WEBPACK_IMPORTED_MODULE_0___default()(Array.isArray(report), 'report must be an array to partition.');
  invariant__WEBPACK_IMPORTED_MODULE_0___default()(Number.isInteger(dateRangeLength) && dateRangeLength > 0, 'dateRangeLength must be a positive integer.');

  // Use a negative date range length for reverse slicing.
  const _dateRangeLength = -1 * dateRangeLength;
  return {
    // The current range should always be sliced from the end.
    currentRange: report.slice(_dateRangeLength),
    // The compare range continues from where the current left off (slicing towards the start),
    // and may be shorter (where older data is not available yet) which is fine.
    compareRange: report.slice(_dateRangeLength * 2, _dateRangeLength)
  };
}

/***/ }),

/***/ "./js/util/purify.js":
/*!***************************!*\
  !*** ./js/util/purify.js ***!
  \***************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   purify: () => (/* binding */ purify)
/* harmony export */ });
/* harmony import */ var dompurify__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! dompurify */ "../node_modules/dompurify/dist/purify.js");
/* harmony import */ var dompurify__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(dompurify__WEBPACK_IMPORTED_MODULE_0__);
/**
 * External dependencies
 */

const purify = dompurify__WEBPACK_IMPORTED_MODULE_0___default()(__webpack_require__.g);

/***/ }),

/***/ "./js/util/safely-sort.js":
/*!********************************!*\
  !*** ./js/util/safely-sort.js ***!
  \********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   safelySort: () => (/* binding */ safelySort)
/* harmony export */ });
/**
 * `safelySort` utility function.
 *
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Sorts an array without causing the mutation if the given parameter is an array.
 * If the parameter is not an array, it returns the parameter as is.
 *
 * @since 1.110.0
 * @since 1.128.0 Moved to the common utility directory from the key metrics directory.
 *
 * @param {Array|*} arr Param to be sorted.
 * @return {Array|*} 	Safely sorted array without mutation.
 */
function safelySort(arr) {
  return Array.isArray(arr) ? [...arr].sort() : arr;
}

/***/ }),

/***/ "./js/util/sanitize.js":
/*!*****************************!*\
  !*** ./js/util/sanitize.js ***!
  \*****************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   sanitizeHTML: () => (/* binding */ sanitizeHTML),
/* harmony export */   untrailingslashit: () => (/* binding */ untrailingslashit)
/* harmony export */ });
/* harmony import */ var _purify__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./purify */ "./js/util/purify.js");
/**
 * Internal dependencies
 */

function sanitizeHTML(unsafeHTML, domPurifyConfig = {}) {
  return {
    __html: _purify__WEBPACK_IMPORTED_MODULE_0__.purify.sanitize(unsafeHTML, domPurifyConfig)
  };
}

/**
 * Takes a string or an URL object, removes the trailing slash if any and returns it.
 *
 * @since 1.20.0
 * @private
 *
 * @param {Object|string} url A string with or without trailing slash or an URL object.
 * @return {string|undefined} The URL string after removing the trailing slash.
 */
function untrailingslashit(url) {
  const originalURL = typeof url === 'object' ? url.toString() : url;
  return originalURL?.replace?.(/\/+$/, '');
}

/***/ }),

/***/ "./js/util/storage.js":
/*!****************************!*\
  !*** ./js/util/storage.js ***!
  \****************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   getStorage: () => (/* binding */ getStorage),
/* harmony export */   storageAvailable: () => (/* binding */ storageAvailable)
/* harmony export */ });
/**
 * Storage abstraction.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Detects whether browser storage is both supported and available.
 *
 * @since 1.0.0
 *
 * @param {string} type Browser storage to test. ex localStorage or sessionStorage.
 * @return {boolean} True if the given storage is available, false otherwise.
 */
function storageAvailable(type) {
  const storage = __webpack_require__.g[type];
  if (!storage) {
    return false;
  }
  try {
    const x = '__storage_test__';
    storage.setItem(x, x);
    storage.removeItem(x);
    return true;
  } catch (e) {
    return e instanceof DOMException && (
    // everything except Firefox
    22 === e.code ||
    // Firefox
    1014 === e.code ||
    // test name field too, because code might not be present
    // everything except Firefox
    'QuotaExceededError' === e.name ||
    // Firefox
    'NS_ERROR_DOM_QUOTA_REACHED' === e.name) &&
    // acknowledge QuotaExceededError only if there's something already stored
    0 !== storage.length;
  }
}

// Custom no-op implementation of window.Storage.
class NullStorage {
  get length() {
    return 0;
  }
  key() {
    return null;
  }
  getItem() {
    return null;
  }
  setItem() {
    // Empty method body.
  }
  removeItem() {
    // Empty method body.
  }
  clear() {
    // Empty method body.
  }
}
let storageObj;

/**
 * Gets the storage object to use.
 *
 * @since 1.0.0
 *
 * @return {Storage} Either window.sessionStorage, window.localStorage', or a
 *                   no-op implementation if neither is available.
 */
function getStorage() {
  // Only run the logic to determine the storage object once.
  if (!storageObj) {
    if (storageAvailable('sessionStorage')) {
      storageObj = __webpack_require__.g.sessionStorage;
    } else if (storageAvailable('localStorage')) {
      storageObj = __webpack_require__.g.localStorage;
    } else {
      storageObj = new NullStorage();
    }
  }
  return storageObj;
}

/***/ }),

/***/ "./js/util/stringify.js":
/*!******************************!*\
  !*** ./js/util/stringify.js ***!
  \******************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   stringifyObject: () => (/* binding */ stringifyObject)
/* harmony export */ });
/* harmony import */ var md5__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! md5 */ "../node_modules/md5/md5.js");
/* harmony import */ var md5__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(md5__WEBPACK_IMPORTED_MODULE_0__);
/**
 * Stringify function.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * Transforms an object into a hash string.
 *
 * This function can be used to e.g. generate cache keys, based on the given
 * object. Object properties are sorted, so even if they are provided in
 * different order, the hash will match. The function furthermore supports
 * nested objects.
 *
 * @since 1.7.0
 *
 * @param {Object} obj The object to stringify.
 * @return {string} Hash for the object.
 */
function stringifyObject(obj) {
  return md5__WEBPACK_IMPORTED_MODULE_0___default()(JSON.stringify(sortObjectProperties(obj)));
}
function sortObjectProperties(obj) {
  const orderedData = {};
  Object.keys(obj).sort().forEach(key => {
    let val = obj[key];
    if (val && 'object' === typeof val && !Array.isArray(val)) {
      val = sortObjectProperties(val);
    }
    orderedData[key] = val;
  });
  return orderedData;
}

/***/ }),

/***/ "./js/util/tag.js":
/*!************************!*\
  !*** ./js/util/tag.js ***!
  \************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   extractExistingTag: () => (/* binding */ extractExistingTag),
/* harmony export */   getExistingTagURLs: () => (/* binding */ getExistingTagURLs)
/* harmony export */ });
/* harmony import */ var invariant__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! invariant */ "../node_modules/invariant/browser.js");
/* harmony import */ var invariant__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(invariant__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! lodash */ "../node_modules/lodash/lodash.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/api-fetch */ "./js/api-fetch-shim.js");
/* harmony import */ var _wordpress_url__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @wordpress/url */ "../node_modules/@wordpress/url/build-module/is-url.js");
/* harmony import */ var _wordpress_url__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @wordpress/url */ "../node_modules/@wordpress/url/build-module/add-query-args.js");
/* harmony import */ var _js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/googlesitekit/datastore/site/constants */ "./js/googlesitekit/datastore/site/constants.js");
/**
 * Utility functions for Tags
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */


/**
 * Extracts a tag from the given HTML string matched by given matchers.
 *
 * @since 1.13.0
 *
 * @param {string} html        The string of html from which to extract the tag.
 * @param {Array}  tagMatchers An array of the matchers to use.
 * @return {(string|boolean)} The tag id if found, otherwise false.
 */
function extractExistingTag(html, tagMatchers) {
  const matchingPattern = tagMatchers.find(pattern => pattern.test(html));
  if (matchingPattern) {
    return matchingPattern.exec(html)[1];
  }
  return false;
}

/**
 * Gets the existing tag URLs.
 *
 * @since 1.13.0
 *
 * @param {Object} args           Arguments to use to get URLs.
 * @param {string} args.homeURL   The site's home URL.
 * @param {string} [args.ampMode] Optional. The site's AMP mode.
 * @return {Array} An array of the existing tag URLs.
 */
const getExistingTagURLs = (0,lodash__WEBPACK_IMPORTED_MODULE_1__.memoize)(async ({
  homeURL,
  ampMode
}) => {
  invariant__WEBPACK_IMPORTED_MODULE_0___default()((0,_wordpress_url__WEBPACK_IMPORTED_MODULE_4__.isURL)(homeURL), 'homeURL must be valid URL');

  // Initialize urls with home URL
  const urls = [homeURL];

  // Add first post in AMP mode if AMP mode is secondary.
  if (_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_3__.AMP_MODE_SECONDARY === ampMode) {
    try {
      const ampPostURL = await (0,_wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_2__["default"])({
        path: '/wp/v2/posts?per_page=1'
      }).then(posts => posts.slice(0, 1).map(post => (0,_wordpress_url__WEBPACK_IMPORTED_MODULE_5__.addQueryArgs)(post.link, {
        amp: 1
      })).pop());
      if (ampPostURL) {
        urls.push(ampPostURL);
      }
    } catch {
      return urls;
    }
  }
  return urls;
});

/***/ }),

/***/ "./js/util/tracking/constants.js":
/*!***************************************!*\
  !*** ./js/util/tracking/constants.js ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   DATA_LAYER: () => (/* binding */ DATA_LAYER),
/* harmony export */   SCRIPT_IDENTIFIER: () => (/* binding */ SCRIPT_IDENTIFIER)
/* harmony export */ });
/**
 * Constants related to event tracking.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Data layer global used for internal/private Site Kit data.
 *
 * @since 1.8.0
 * @private
 */
const DATA_LAYER = '_googlesitekitDataLayer';

/**
 * The `gtag` `<script>` identifier.
 *
 * @since 1.8.0
 * @private
 */
const SCRIPT_IDENTIFIER = 'data-googlesitekit-gtag';

/***/ }),

/***/ "./js/util/tracking/createDataLayerPush.js":
/*!*************************************************!*\
  !*** ./js/util/tracking/createDataLayerPush.js ***!
  \*************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ createDataLayerPush)
/* harmony export */ });
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./constants */ "./js/util/tracking/constants.js");
/**
 * Internal dependencies
 */


/**
 * Returns a function which, when invoked will initialize the dataLayer and push data onto it.
 *
 * @since 1.3.0
 *
 * @param {Object} target Object to enhance with dataLayer data.
 * @return {Function} Function that pushes data onto the dataLayer.
 */
function createDataLayerPush(target) {
  /**
   * Pushes data onto the data layer.
   *
   * Must push an instance of Arguments to the target.
   * Using an ES6 spread operator (i.e. `...args`) will cause tracking events to
   * _silently_ fail.
   *
   * @since 1.0.0
   * @see {@link https://github.com/google/site-kit-wp/issues/1181}
   */
  return function dataLayerPush() {
    target[_constants__WEBPACK_IMPORTED_MODULE_0__.DATA_LAYER] = target[_constants__WEBPACK_IMPORTED_MODULE_0__.DATA_LAYER] || [];
    target[_constants__WEBPACK_IMPORTED_MODULE_0__.DATA_LAYER].push(arguments);
  };
}

/***/ }),

/***/ "./js/util/tracking/createInitializeSnippet.js":
/*!*****************************************************!*\
  !*** ./js/util/tracking/createInitializeSnippet.js ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ createInitializeSnippet)
/* harmony export */ });
/* harmony import */ var _createDataLayerPush__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./createDataLayerPush */ "./js/util/tracking/createDataLayerPush.js");
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./constants */ "./js/util/tracking/constants.js");
/* harmony import */ var _js_features_index__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/features/index */ "./js/features/index.js");
/**
 * Internal dependencies
 */




/**
 * Returns a function which, when invoked injects the gtag script if necessary.
 *
 * @since 1.44.0
 *
 * @param {Object} config          Tracking configuration.
 * @param {Object} dataLayerTarget Data layer parent object.
 * @return {Function} Function that injects gtag script if it isn't yet present.
 */
function createInitializeSnippet(config, dataLayerTarget) {
  const dataLayerPush = (0,_createDataLayerPush__WEBPACK_IMPORTED_MODULE_0__["default"])(dataLayerTarget);
  let hasInsertedTag;
  const {
    activeModules,
    referenceSiteURL,
    userIDHash,
    userRoles = [],
    isAuthenticated,
    pluginVersion
  } = config;

  /**
   * Injects the necessary script tag if not present.
   *
   * @since 1.118.0
   *
   * @return {boolean|Object} Tag src as scriptTagSrc property.
   */
  return function initializeSnippet() {
    const {
      document
    } = __webpack_require__.g;
    if (undefined === hasInsertedTag) {
      hasInsertedTag = !!document.querySelector(`script[${_constants__WEBPACK_IMPORTED_MODULE_1__.SCRIPT_IDENTIFIER}]`);
    }
    if (hasInsertedTag) {
      return false;
    }
    hasInsertedTag = true;

    // Sometimes the user roles returned by Site Kit/WordPress is not an
    // array, as expected, so we guard against it here.
    //
    // See: https://github.com/google/site-kit-wp/issues/8266
    const userRolesAsString = userRoles?.length ? userRoles.join(',') : '';

    // We should use the real time, and not the reference date, when
    // measuring when we initialized tracking.
    dataLayerPush('js', new Date()); // eslint-disable-line sitekit/no-direct-date
    dataLayerPush('config', config.trackingID, {
      groups: 'site_kit',
      send_page_view: config.isSiteKitScreen,
      domain: referenceSiteURL,
      plugin_version: pluginVersion || '',
      enabled_features: Array.from(_js_features_index__WEBPACK_IMPORTED_MODULE_2__.enabledFeatures).join(','),
      active_modules: activeModules.join(','),
      authenticated: isAuthenticated ? '1' : '0',
      user_properties: {
        user_roles: userRolesAsString,
        user_identifier: userIDHash
      }
    });

    // If not present, inject it and initialize dataLayer.
    const scriptTag = document.createElement('script');
    scriptTag.setAttribute(_constants__WEBPACK_IMPORTED_MODULE_1__.SCRIPT_IDENTIFIER, '');
    scriptTag.async = true;
    scriptTag.src = `https://www.googletagmanager.com/gtag/js?id=${config.trackingID}&l=${_constants__WEBPACK_IMPORTED_MODULE_1__.DATA_LAYER}`;
    document.head.appendChild(scriptTag);
    return {
      scriptTagSrc: `https://www.googletagmanager.com/gtag/js?id=${config.trackingID}&l=${_constants__WEBPACK_IMPORTED_MODULE_1__.DATA_LAYER}`
    };
  };
}

/***/ }),

/***/ "./js/util/tracking/createTrackEvent.js":
/*!**********************************************!*\
  !*** ./js/util/tracking/createTrackEvent.js ***!
  \**********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ createTrackEvent)
/* harmony export */ });
/* harmony import */ var _createDataLayerPush__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./createDataLayerPush */ "./js/util/tracking/createDataLayerPush.js");
/**
 * Internal dependencies
 */


/**
 * Returns a function which, when invoked tracks a single event.
 *
 * @since 1.3.0
 *
 * @param {Object}   config            Tracking configuration.
 * @param {Object}   dataLayerTarget   Data layer parent object.
 * @param {Function} initializeSnippet Function to initialize tracking.
 * @param {Object}   _global           The global window object.
 * @return {Function} Function that tracks an event.
 */
function createTrackEvent(config, dataLayerTarget, initializeSnippet, _global) {
  const dataLayerPush = (0,_createDataLayerPush__WEBPACK_IMPORTED_MODULE_0__["default"])(dataLayerTarget);

  /**
   * Send an Analytics tracking event.
   *
   * @since 1.3.0
   *
   * @param {string} category The category of the event.
   * @param {string} action   The action name of the event.
   * @param {string} [label]  Optional. The label of the event.
   * @param {number} [value]  Optional. A non-negative integer that will appear as the event value.
   * @return {Promise} Promise that always resolves.
   */
  // eslint-disable-next-line require-await
  return async function trackEvent(category, action, label, value) {
    const {
      trackingEnabled
    } = config;
    if (!trackingEnabled) {
      // Resolve immediately if tracking is disabled.
      return null;
    }
    initializeSnippet();
    const eventData = {
      send_to: 'site_kit',
      event_category: category,
      event_label: label,
      value
    };
    return new Promise(resolve => {
      // This timeout ensures a tracking event does not block the user
      // event if it is not sent (in time).
      // If the event beacon fails, it shouldn't reject the promise since event
      // tracking should not result in user-facing errors. It will just
      // trigger a console warning.
      function failCallback() {
        _global.console.warn(`Tracking event "${action}" (category "${category}") took too long to fire.`);
        resolve();
      }
      const failTimeout = setTimeout(failCallback, 1000);
      // eslint-disable-next-line camelcase
      function event_callback() {
        clearTimeout(failTimeout);
        resolve();
      }
      dataLayerPush('event', action, {
        ...eventData,
        event_callback
      });

      // If the client-side opt-out is present, the event_callback will never be called
      // so we call it here to prevent the warning and added delay.
      if (_global._gaUserPrefs?.ioo?.()) {
        event_callback();
      }
    });
  };
}

/***/ }),

/***/ "./js/util/tracking/createTracking.js":
/*!********************************************!*\
  !*** ./js/util/tracking/createTracking.js ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ createTracking)
/* harmony export */ });
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! lodash */ "../node_modules/lodash/lodash.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _createInitializeSnippet__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./createInitializeSnippet */ "./js/util/tracking/createInitializeSnippet.js");
/* harmony import */ var _createTrackEvent__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./createTrackEvent */ "./js/util/tracking/createTrackEvent.js");
/**
 * Site Kit by Google, Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * Internal dependencies
 */


const DEFAULT_CONFIG = {
  activeModules: [],
  isAuthenticated: false,
  referenceSiteURL: '',
  trackingEnabled: false,
  trackingID: '',
  userIDHash: '',
  userRoles: []
};

/**
 * Initializes tracking.
 *
 * @since 1.3.0
 *
 * @param {Object} newConfig       New configuration.
 * @param {Object} dataLayerTarget Data layer parent object.
 * @param {Object} _global         The global window object.
 * @return {Object} Tracking config.
 */
function createTracking(newConfig, dataLayerTarget = __webpack_require__.g, _global = __webpack_require__.g) {
  const config = {
    ...DEFAULT_CONFIG,
    ...newConfig
  };
  // Remove any trailing slash from the reference URL.
  if (config.referenceSiteURL) {
    config.referenceSiteURL = config.referenceSiteURL.toString().replace(/\/+$/, '');
  }
  const initializeSnippet = (0,_createInitializeSnippet__WEBPACK_IMPORTED_MODULE_1__["default"])(config, dataLayerTarget);
  const trackEvent = (0,_createTrackEvent__WEBPACK_IMPORTED_MODULE_2__["default"])(config, dataLayerTarget, initializeSnippet, _global);
  const onceTrackedEventsMap = {};
  function trackEventOnce(...params) {
    const key = JSON.stringify(params);
    if (!onceTrackedEventsMap[key]) {
      onceTrackedEventsMap[key] = (0,lodash__WEBPACK_IMPORTED_MODULE_0__.once)(trackEvent);
    }
    onceTrackedEventsMap[key](...params);
  }
  return {
    enableTracking: function enableTracking() {
      config.trackingEnabled = true;
    },
    disableTracking: function disableTracking() {
      config.trackingEnabled = false;
    },
    initializeSnippet,
    isTrackingEnabled: function isTrackingEnabled() {
      return !!config.trackingEnabled;
    },
    trackEvent,
    trackEventOnce
  };
}

/***/ }),

/***/ "./js/util/tracking/index.js":
/*!***********************************!*\
  !*** ./js/util/tracking/index.js ***!
  \***********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   disableTracking: () => (/* binding */ disableTracking),
/* harmony export */   enableTracking: () => (/* binding */ enableTracking),
/* harmony export */   isTrackingEnabled: () => (/* binding */ isTrackingEnabled),
/* harmony export */   toggleTracking: () => (/* binding */ toggleTracking),
/* harmony export */   trackEvent: () => (/* binding */ trackEvent),
/* harmony export */   trackEventOnce: () => (/* binding */ trackEventOnce)
/* harmony export */ });
/* harmony import */ var _createTracking__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./createTracking */ "./js/util/tracking/createTracking.js");
/**
 * Event tracking utilities.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/* eslint-disable sitekit/jsdoc-no-unnamed-boolean-params */

/**
 * Internal dependencies
 */

const {
  activeModules = [],
  isSiteKitScreen,
  trackingEnabled,
  trackingID,
  referenceSiteURL,
  userIDHash,
  isAuthenticated,
  userRoles
} = __webpack_require__.g._googlesitekitTrackingData || {};
const {
  GOOGLESITEKIT_VERSION: pluginVersion
} = __webpack_require__.g;
const initialConfig = {
  activeModules,
  trackingEnabled,
  trackingID,
  referenceSiteURL,
  userIDHash,
  isSiteKitScreen,
  userRoles,
  isAuthenticated,
  pluginVersion
};
const {
  enableTracking,
  disableTracking,
  isTrackingEnabled,
  initializeSnippet,
  trackEvent,
  trackEventOnce
} = (0,_createTracking__WEBPACK_IMPORTED_MODULE_0__["default"])(initialConfig);

/**
 * Changes the active state of tracking.
 *
 * @since 1.3.0
 *
 * @param {boolean} activeStatus The new state to set.
 */
function toggleTracking(activeStatus) {
  if (!!activeStatus) {
    enableTracking();
  } else {
    disableTracking();
  }
}

// Bootstrap on import if tracking is allowed.
if (isSiteKitScreen && trackingEnabled) {
  initializeSnippet();
}


/***/ }),

/***/ "./js/util/urls.js":
/*!*************************!*\
  !*** ./js/util/urls.js ***!
  \*************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   getFullURL: () => (/* binding */ getFullURL),
/* harmony export */   getURLPath: () => (/* binding */ getURLPath),
/* harmony export */   isHashOnly: () => (/* binding */ isHashOnly),
/* harmony export */   normalizeURL: () => (/* binding */ normalizeURL),
/* harmony export */   shortenURL: () => (/* binding */ shortenURL)
/* harmony export */ });
/* harmony import */ var _wordpress_url__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/url */ "../node_modules/@wordpress/url/build-module/is-url.js");
/**
 * URL pathname getter utility function.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */


/**
 * Returns the path from a URL, omitting its protocol, hostname, query params, and hash.
 *
 * @since 1.24.0
 *
 * @param {string} url The URL to get the path from.
 * @return {string} The URL path.
 */
function getURLPath(url) {
  try {
    return new URL(url).pathname;
  } catch {}
  return null;
}

/**
 * Returns the absolute URL from a path including the siteURL.
 *
 * @since 1.32.0
 *
 * @param {string} siteURL The siteURL fo the WordPress install.
 * @param {string} path    The path.
 * @return {string} The URL path.
 */
function getFullURL(siteURL, path) {
  try {
    return new URL(path, siteURL).href;
  } catch {}
  return (typeof siteURL === 'string' ? siteURL : '') + (typeof path === 'string' ? path : '');
}

/**
 * Normalizes URL by removing protocol, www subdomain and trailing slash.
 *
 * @since 1.33.0
 *
 * @param {string} incomingURL The original URL.
 * @return {string} Normalized URL.
 */
function normalizeURL(incomingURL) {
  if (typeof incomingURL !== 'string') {
    return incomingURL;
  }
  return incomingURL
  // Remove protocol and optional "www." prefix from the URL.
  .replace(/^https?:\/\/(www\.)?/i, '')
  // Remove trailing slash.
  .replace(/\/$/, '');
}

/**
 * Checks if a string is not a full URL and simply a hash / anchor link.
 *
 * @since 1.49.0
 *
 * @param {string} url The URL or Hash string to test.
 * @return {boolean} Returns true if the string is only a hash and not a full URL.
 */
function isHashOnly(url) {
  return /^#\w[A-Za-z0-9-_]*$/.test(url);
}

/**
 * Shortens a URL to fit a given length.
 *
 * @since 1.49.0
 *
 * @param {string} url      The original URL to shorten.
 * @param {number} maxChars The maximum length of the URL.
 * @return {string} The shortened URL.
 */
function shortenURL(url, maxChars) {
  if (!(0,_wordpress_url__WEBPACK_IMPORTED_MODULE_0__.isURL)(url)) {
    return url;
  }
  if (url.length <= maxChars) {
    return url;
  }
  const urlObject = new URL(url);
  const shortenedURL = url.replace(urlObject.origin, '');
  if (shortenedURL.length < maxChars) {
    return shortenedURL;
  }
  const extraChars = shortenedURL.length - Math.floor(maxChars) + 1; // 1 is the length of "…".
  return '…' + shortenedURL.substr(extraChars);
}

/***/ }),

/***/ "@wordpress/i18n":
/*!*****************************************!*\
  !*** external ["googlesitekit","i18n"] ***!
  \*****************************************/
/***/ ((module) => {

module.exports = googlesitekit.i18n;

/***/ }),

/***/ "googlesitekit-api":
/*!****************************************!*\
  !*** external ["googlesitekit","api"] ***!
  \****************************************/
/***/ ((module) => {

module.exports = googlesitekit.api;

/***/ }),

/***/ "googlesitekit-data":
/*!*****************************************!*\
  !*** external ["googlesitekit","data"] ***!
  \*****************************************/
/***/ ((module) => {

module.exports = googlesitekit.data;

/***/ })

},
/******/ __webpack_require__ => { // webpackRuntimeModules
/******/ var __webpack_exec__ = (moduleId) => (__webpack_require__(__webpack_require__.s = moduleId))
/******/ __webpack_require__.O(0, ["googlesitekit-vendor"], () => (__webpack_exec__("./js/googlesitekit-datastore-site.js")));
/******/ var __webpack_exports__ = __webpack_require__.O();
/******/ }
]);
//# sourceMappingURL=googlesitekit-datastore-site.js.map