"use strict";
(globalThis["__googlesitekit_webpackJsonp"] = globalThis["__googlesitekit_webpackJsonp"] || []).push([["googlesitekit-widgets"],{

/***/ "./js/components/AdminScreenTooltip/AdminScreenTooltip.js":
/*!****************************************************************!*\
  !*** ./js/components/AdminScreenTooltip/AdminScreenTooltip.js ***!
  \****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   AdminScreenTooltip: () => (/* binding */ AdminScreenTooltip)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _js_components_JoyrideTooltip__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/components/JoyrideTooltip */ "./js/components/JoyrideTooltip.js");
/* harmony import */ var _js_googlesitekit_datastore_ui_constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/googlesitekit/datastore/ui/constants */ "./js/googlesitekit/datastore/ui/constants.js");
/* harmony import */ var _js_util__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/util */ "./js/util/index.js");
/* harmony import */ var _js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/hooks/useViewContext */ "./js/hooks/useViewContext.js");
/* harmony import */ var _js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/hooks/useBreakpoint */ "./js/hooks/useBreakpoint.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * AdminMenuTooltip component.
 *
 * Site Kit by Google, Copyright 2022 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */







function AdminScreenTooltip() {
  const viewContext = (0,_js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_4__["default"])();
  const {
    setValue
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useDispatch)(_js_googlesitekit_datastore_ui_constants__WEBPACK_IMPORTED_MODULE_2__.CORE_UI);
  const breakpoint = (0,_js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_5__.useBreakpoint)();
  const {
    isTooltipVisible = false,
    target,
    placement,
    className,
    tooltipSlug,
    title,
    content,
    dismissLabel
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useSelect)(select => select(_js_googlesitekit_datastore_ui_constants__WEBPACK_IMPORTED_MODULE_2__.CORE_UI).getValue('admin-screen-tooltip') || {
    isTooltipVisible: false
  });
  function handleViewTooltip() {
    (0,_js_util__WEBPACK_IMPORTED_MODULE_3__.trackEvent)(`${viewContext}_${tooltipSlug}`, 'tooltip_view');
  }
  const handleDismissTooltip = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_7__.useCallback)(() => {
    // Track dismiss event.
    if (tooltipSlug) {
      (0,_js_util__WEBPACK_IMPORTED_MODULE_3__.trackEvent)(`${viewContext}_${tooltipSlug}`, 'tooltip_dismiss');
    }
    setValue('admin-screen-tooltip', undefined);
  }, [setValue, tooltipSlug, viewContext]);
  if (!isTooltipVisible) {
    return null;
  }
  const isMobileTablet = breakpoint === _js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_5__.BREAKPOINT_SMALL || breakpoint === _js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_5__.BREAKPOINT_TABLET;
  const desktopTarget = target !== null && target !== void 0 ? target : '#adminmenu [href*="page=googlesitekit-settings"]';
  const desktopPlacement = placement !== null && placement !== void 0 ? placement : 'right';
  function desktopClassName() {
    if (className) {
      return className;
    }
    return !target ? 'googlesitekit-tour-tooltip__fixed-settings-tooltip' : undefined;
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(_js_components_JoyrideTooltip__WEBPACK_IMPORTED_MODULE_1__["default"], {
    target: isMobileTablet ? 'body' : desktopTarget,
    placement: isMobileTablet ? 'center' : desktopPlacement,
    className: isMobileTablet ? 'googlesitekit-tour-tooltip__modal_step' : desktopClassName(),
    disableOverlay: !isMobileTablet,
    slug: "admin-screen-tooltip",
    title: title,
    content: content,
    dismissLabel: dismissLabel,
    onView: handleViewTooltip,
    onDismiss: handleDismissTooltip
  });
}

/***/ }),

/***/ "./js/components/AdminScreenTooltip/index.js":
/*!***************************************************!*\
  !*** ./js/components/AdminScreenTooltip/index.js ***!
  \***************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   AdminScreenTooltip: () => (/* reexport safe */ _AdminScreenTooltip__WEBPACK_IMPORTED_MODULE_1__.AdminScreenTooltip),
/* harmony export */   useShowTooltip: () => (/* reexport safe */ _useShowTooltip__WEBPACK_IMPORTED_MODULE_0__.useShowTooltip)
/* harmony export */ });
/* harmony import */ var _useShowTooltip__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./useShowTooltip */ "./js/components/AdminScreenTooltip/useShowTooltip.js");
/* harmony import */ var _AdminScreenTooltip__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./AdminScreenTooltip */ "./js/components/AdminScreenTooltip/AdminScreenTooltip.js");



/***/ }),

/***/ "./js/components/AdminScreenTooltip/useShowTooltip.js":
/*!************************************************************!*\
  !*** ./js/components/AdminScreenTooltip/useShowTooltip.js ***!
  \************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   useShowTooltip: () => (/* binding */ useShowTooltip)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _js_googlesitekit_datastore_ui_constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/googlesitekit/datastore/ui/constants */ "./js/googlesitekit/datastore/ui/constants.js");



function useShowTooltip(tooltipSettings) {
  const {
    setValue
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useDispatch)(_js_googlesitekit_datastore_ui_constants__WEBPACK_IMPORTED_MODULE_1__.CORE_UI);
  return (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useCallback)(() => {
    setValue('admin-screen-tooltip', {
      isTooltipVisible: true,
      ...tooltipSettings
    });
  }, [setValue, tooltipSettings]);
}

/***/ }),

/***/ "./js/components/Badge.js":
/*!********************************!*\
  !*** ./js/components/Badge.js ***!
  \********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Badge component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * WordPress dependencies
 */


const Badge = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.forwardRef)(({
  label,
  className,
  hasLeftSpacing = false,
  ...rest
}, ref) => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("span", {
  ref: ref,
  ...rest,
  className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-badge', className, {
    'googlesitekit-badge--has-left-spacing': hasLeftSpacing
  }),
  children: label
}));
Badge.displayName = 'Badge';
Badge.propTypes = {
  label: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string).isRequired,
  hasLeftSpacing: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().bool)
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Badge);

/***/ }),

/***/ "./js/components/BadgeWithTooltip.js":
/*!*******************************************!*\
  !*** ./js/components/BadgeWithTooltip.js ***!
  \*******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ BadgeWithTooltip)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _InfoTooltip__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./InfoTooltip */ "./js/components/InfoTooltip.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * BadgeWithTooltip component.
 *
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * Internal dependencies
 */


function BadgeWithTooltip({
  className = '',
  label,
  onTooltipOpen,
  tooltipTitle
}) {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)("span", {
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-badge-with-tooltip', 'googlesitekit-badge', className),
    children: [label, tooltipTitle && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)(_InfoTooltip__WEBPACK_IMPORTED_MODULE_1__["default"], {
      onOpen: onTooltipOpen,
      title: tooltipTitle
    })]
  });
}
BadgeWithTooltip.propTypes = {
  onTooltipOpen: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().func),
  tooltipTitle: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().node),
  className: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  label: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().node).isRequired
};

/***/ }),

/***/ "./js/components/Banner/CTAButton.js":
/*!*******************************************!*\
  !*** ./js/components/Banner/CTAButton.js ***!
  \*******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ CTAButton)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! googlesitekit-components */ "googlesitekit-components");
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_components__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * Internal dependencies
 */


function CTAButton({
  label,
  ariaLabel,
  disabled,
  inProgress,
  onClick,
  href
}) {
  if (!label || !onClick && !href) {
    return null;
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_0__.SpinnerButton, {
    className: "googlesitekit-banner__cta",
    "aria-label": ariaLabel,
    disabled: disabled || inProgress,
    isSaving: inProgress,
    onClick: onClick,
    href: href,
    children: label
  });
}
CTAButton.propTypes = {
  label: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().string),
  ariaLabel: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().string),
  disabled: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().bool),
  inProgress: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().bool),
  onClick: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().func),
  href: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().string),
  dismissOnClick: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().bool),
  dismissOptions: prop_types__WEBPACK_IMPORTED_MODULE_2___default().shape({
    expiresInSeconds: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().number),
    skipHidingFromQueue: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().bool)
  })
};

/***/ }),

/***/ "./js/components/Banner/Description.js":
/*!*********************************************!*\
  !*** ./js/components/Banner/Description.js ***!
  \*********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Description)
/* harmony export */ });
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _js_util__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/util */ "./js/util/index.js");
/* harmony import */ var _LearnMoreLink__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./LearnMoreLink */ "./js/components/Banner/LearnMoreLink.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */



function Description({
  className,
  description,
  learnMoreLink,
  additionalDescription,
  children
}) {
  function renderDescription() {
    if ((0,_wordpress_element__WEBPACK_IMPORTED_MODULE_4__.isValidElement)(description)) {
      return description;
    }
    if ('string' === typeof description) {
      return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("span", {
        dangerouslySetInnerHTML: (0,_js_util__WEBPACK_IMPORTED_MODULE_1__.sanitizeHTML)(description, {
          ALLOWED_TAGS: ['strong', 'em', 'br', 'a'],
          ALLOWED_ATTR: ['href']
        })
      });
    }
    return description;
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-banner__description', className),
    children: [renderDescription(), ' ', learnMoreLink?.href && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_LearnMoreLink__WEBPACK_IMPORTED_MODULE_2__["default"], {
      ...learnMoreLink
    }), additionalDescription && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
      className: "googlesitekit-banner__additional-description",
      children: additionalDescription
    }), children]
  });
}
Description.propTypes = {
  className: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().string),
  description: prop_types__WEBPACK_IMPORTED_MODULE_5___default().oneOfType([(prop_types__WEBPACK_IMPORTED_MODULE_5___default().string), (prop_types__WEBPACK_IMPORTED_MODULE_5___default().node)]),
  learnMoreLink: prop_types__WEBPACK_IMPORTED_MODULE_5___default().shape(_LearnMoreLink__WEBPACK_IMPORTED_MODULE_2__["default"].propTypes),
  additionalDescription: prop_types__WEBPACK_IMPORTED_MODULE_5___default().oneOfType([(prop_types__WEBPACK_IMPORTED_MODULE_5___default().string), (prop_types__WEBPACK_IMPORTED_MODULE_5___default().node)]),
  children: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().node)
};

/***/ }),

/***/ "./js/components/Banner/DismissButton.js":
/*!***********************************************!*\
  !*** ./js/components/Banner/DismissButton.js ***!
  \***********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ DismissButton)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-components */ "googlesitekit-components");
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */


function DismissButton({
  className,
  label = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Maybe later', 'google-site-kit'),
  onClick,
  disabled,
  tertiary = true
}) {
  if (!onClick) {
    return null;
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__.Button, {
    className: className,
    onClick: onClick,
    disabled: disabled,
    tertiary: tertiary,
    children: label
  });
}
DismissButton.propTypes = {
  className: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  label: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  onClick: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().func),
  disabled: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().bool),
  tertiary: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().bool),
  dismissOptions: prop_types__WEBPACK_IMPORTED_MODULE_3___default().shape({
    expiresInSeconds: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().number),
    skipHidingFromQueue: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().bool)
  })
};

/***/ }),

/***/ "./js/components/Banner/Footer.js":
/*!****************************************!*\
  !*** ./js/components/Banner/Footer.js ***!
  \****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Footer)
/* harmony export */ });
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



function Footer({
  className,
  children
}) {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", {
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-banner__footer', className),
    children: children
  });
}
Footer.propTypes = {
  className: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().string),
  children: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().node)
};

/***/ }),

/***/ "./js/components/Banner/HelpText.js":
/*!******************************************!*\
  !*** ./js/components/Banner/HelpText.js ***!
  \******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ HelpText)
/* harmony export */ });
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



function HelpText({
  className,
  children
}) {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("p", {
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-banner__help-text', className),
    children: children
  });
}
HelpText.propTypes = {
  className: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().string),
  children: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().node)
};

/***/ }),

/***/ "./js/components/Banner/LearnMoreLink.js":
/*!***********************************************!*\
  !*** ./js/components/Banner/LearnMoreLink.js ***!
  \***********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ LearnMoreLink)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _js_components_Link__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/components/Link */ "./js/components/Link.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */


function LearnMoreLink({
  href,
  className,
  label = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Learn more', 'google-site-kit'),
  external = true,
  onClick = () => {}
}) {
  if (!href) {
    return null;
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)(_js_components_Link__WEBPACK_IMPORTED_MODULE_1__["default"], {
    href: href,
    className: className,
    onClick: onClick,
    external: external,
    children: label
  });
}
LearnMoreLink.propTypes = {
  href: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string).isRequired,
  className: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  label: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  external: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().bool),
  onClick: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().func)
};

/***/ }),

/***/ "./js/components/Banner/Title.js":
/*!***************************************!*\
  !*** ./js/components/Banner/Title.js ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Title)
/* harmony export */ });
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



function Title({
  className,
  children
}) {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("p", {
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-banner__title', className),
    children: children
  });
}
Title.propTypes = {
  className: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().string),
  children: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().node)
};

/***/ }),

/***/ "./js/components/Banner/TitleIcon.js":
/*!*******************************************!*\
  !*** ./js/components/Banner/TitleIcon.js ***!
  \*******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ TitleIcon)
/* harmony export */ });
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



function TitleIcon({
  className,
  children
}) {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", {
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-banner__title-icon', className),
    children: children
  });
}
TitleIcon.propTypes = {
  className: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().string),
  children: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().node)
};

/***/ }),

/***/ "./js/components/Banner/index.js":
/*!***************************************!*\
  !*** ./js/components/Banner/index.js ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_13___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_13__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/hooks/useBreakpoint */ "./js/hooks/useBreakpoint.js");
/* harmony import */ var _TitleIcon__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./TitleIcon */ "./js/components/Banner/TitleIcon.js");
/* harmony import */ var _Title__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./Title */ "./js/components/Banner/Title.js");
/* harmony import */ var _Description__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./Description */ "./js/components/Banner/Description.js");
/* harmony import */ var _HelpText__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./HelpText */ "./js/components/Banner/HelpText.js");
/* harmony import */ var _LearnMoreLink__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./LearnMoreLink */ "./js/components/Banner/LearnMoreLink.js");
/* harmony import */ var _CTAButton__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./CTAButton */ "./js/components/Banner/CTAButton.js");
/* harmony import */ var _DismissButton__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./DismissButton */ "./js/components/Banner/DismissButton.js");
/* harmony import */ var _Footer__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./Footer */ "./js/components/Banner/Footer.js");
/* harmony import */ var _js_components_Notice__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @/js/components/Notice */ "./js/components/Notice/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */











const Banner = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_12__.forwardRef)(({
  className,
  titleIcon,
  title,
  description,
  additionalDescription,
  errorText,
  helpText,
  learnMoreLink,
  dismissButton,
  ctaButton,
  svg,
  // NOTE: SVGs must be imported with the ?url suffix for use as a backgroundImage in this component.
  footer
}, ref) => {
  const breakpoint = (0,_js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_1__.useBreakpoint)();
  const isMobileOrTablet = breakpoint === _js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_1__.BREAKPOINT_SMALL || breakpoint === _js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_1__.BREAKPOINT_TABLET;
  let SVGData = null;
  if (isMobileOrTablet && svg?.mobile) {
    SVGData = svg.mobile;
  } else if (!isMobileOrTablet && svg?.desktop) {
    SVGData = svg.desktop;
  }
  const svgMode = svg?.verticalPosition ? svg.verticalPosition : 'center';
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("div", {
    ref: ref,
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-banner', className),
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("div", {
      className: "googlesitekit-banner__content",
      children: [titleIcon && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_TitleIcon__WEBPACK_IMPORTED_MODULE_2__["default"], {
        children: titleIcon
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_Title__WEBPACK_IMPORTED_MODULE_3__["default"], {
        children: title
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_Description__WEBPACK_IMPORTED_MODULE_4__["default"], {
        description: description,
        learnMoreLink: learnMoreLink,
        additionalDescription: additionalDescription
      }), helpText && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_HelpText__WEBPACK_IMPORTED_MODULE_5__["default"], {
        children: helpText
      }), errorText && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_js_components_Notice__WEBPACK_IMPORTED_MODULE_10__["default"], {
        type: "error",
        description: errorText
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("div", {
        className: "googlesitekit-notice__action",
        children: [ctaButton && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_CTAButton__WEBPACK_IMPORTED_MODULE_7__["default"], {
          ...ctaButton
        }), dismissButton?.onClick && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_DismissButton__WEBPACK_IMPORTED_MODULE_8__["default"], {
          ...dismissButton
        })]
      })]
    }), SVGData && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("div", {
      className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-banner__svg-wrapper', {
        [`googlesitekit-banner__svg-wrapper--${svgMode}`]: svgMode
      }),
      style: {
        backgroundImage: `url(${SVGData})`
      }
    }), footer && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_Footer__WEBPACK_IMPORTED_MODULE_9__["default"], {
      children: footer
    })]
  });
});
Banner.propTypes = {
  titleIcon: (prop_types__WEBPACK_IMPORTED_MODULE_13___default().node),
  title: (prop_types__WEBPACK_IMPORTED_MODULE_13___default().string),
  description: prop_types__WEBPACK_IMPORTED_MODULE_13___default().oneOfType([(prop_types__WEBPACK_IMPORTED_MODULE_13___default().string), (prop_types__WEBPACK_IMPORTED_MODULE_13___default().node)]),
  additionalDescription: prop_types__WEBPACK_IMPORTED_MODULE_13___default().oneOfType([(prop_types__WEBPACK_IMPORTED_MODULE_13___default().string), (prop_types__WEBPACK_IMPORTED_MODULE_13___default().node)]),
  errorText: (prop_types__WEBPACK_IMPORTED_MODULE_13___default().string),
  helpText: (prop_types__WEBPACK_IMPORTED_MODULE_13___default().string),
  learnMoreLink: prop_types__WEBPACK_IMPORTED_MODULE_13___default().shape(_LearnMoreLink__WEBPACK_IMPORTED_MODULE_6__["default"].propTypes),
  dismissButton: prop_types__WEBPACK_IMPORTED_MODULE_13___default().shape(_DismissButton__WEBPACK_IMPORTED_MODULE_8__["default"].propTypes),
  ctaButton: prop_types__WEBPACK_IMPORTED_MODULE_13___default().shape(_CTAButton__WEBPACK_IMPORTED_MODULE_7__["default"].propTypes),
  svg: prop_types__WEBPACK_IMPORTED_MODULE_13___default().shape({
    desktop: (prop_types__WEBPACK_IMPORTED_MODULE_13___default().elementType),
    mobile: (prop_types__WEBPACK_IMPORTED_MODULE_13___default().elementType),
    verticalPosition: prop_types__WEBPACK_IMPORTED_MODULE_13___default().oneOf(['top', 'center', 'bottom'])
  }),
  footer: (prop_types__WEBPACK_IMPORTED_MODULE_13___default().node)
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Banner);

/***/ }),

/***/ "./js/components/ChangeArrow.js":
/*!**************************************!*\
  !*** ./js/components/ChangeArrow.js ***!
  \**************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * External dependencies
 */



function ChangeArrow({
  direction,
  invertColor,
  width,
  height
}) {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("svg", {
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-change-arrow', `googlesitekit-change-arrow--${direction}`, {
      'googlesitekit-change-arrow--inverted-color': invertColor
    }),
    width: width,
    height: height,
    viewBox: "0 0 10 10",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg",
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("path", {
      d: "M5.625 10L5.625 2.375L9.125 5.875L10 5L5 -1.76555e-07L-2.7055e-07 5L0.875 5.875L4.375 2.375L4.375 10L5.625 10Z",
      fill: "currentColor"
    })
  });
}
ChangeArrow.propTypes = {
  direction: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().string),
  invertColor: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().bool),
  width: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().number),
  height: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().number)
};
ChangeArrow.defaultProps = {
  direction: 'up',
  invertColor: false,
  width: 9,
  height: 9
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ChangeArrow);

/***/ }),

/***/ "./js/components/ChangeBadge.js":
/*!**************************************!*\
  !*** ./js/components/ChangeBadge.js ***!
  \**************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ ChangeBadge)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _js_util__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/util */ "./js/util/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * ChangeBadge component.
 *
 * Site Kit by Google, Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * Internal dependencies
 */


function ChangeBadge(props) {
  const {
    previousValue,
    currentValue,
    isAbsolute
  } = props;
  const change = isAbsolute ? currentValue - previousValue : (0,_js_util__WEBPACK_IMPORTED_MODULE_1__.calculateChange)(previousValue, currentValue);
  const isNegative = change < 0;
  const isZero = change === 0;

  // Do not display the change badge if the change value can't be calculated.
  if (change === null) {
    return null;
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("div", {
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-change-badge', {
      'googlesitekit-change-badge--negative': isNegative,
      'googlesitekit-change-badge--zero': isZero
    }),
    children: (0,_js_util__WEBPACK_IMPORTED_MODULE_1__.numFmt)(change, {
      style: 'percent',
      signDisplay: 'exceptZero',
      maximumFractionDigits: 1
    })
  });
}
ChangeBadge.propTypes = {
  isAbsolute: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().bool),
  previousValue: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().number).isRequired,
  currentValue: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().number).isRequired
};

/***/ }),

/***/ "./js/components/ErrorNotice.js":
/*!**************************************!*\
  !*** ./js/components/ErrorNotice.js ***!
  \**************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ ErrorNotice)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_url__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @wordpress/url */ "../node_modules/@wordpress/url/build-module/is-url.js");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _js_util_errors__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/util/errors */ "./js/util/errors.js");
/* harmony import */ var _Notice__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./Notice */ "./js/components/Notice/index.js");
/* harmony import */ var _js_util__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/util */ "./js/util/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * ErrorNotice component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */




/**
 * Internal dependencies
 */





function ErrorNotice({
  className,
  error,
  hasButton = false,
  storeName,
  message = error.message,
  noPrefix = false,
  skipRetryMessage,
  hideIcon = false
}) {
  const dispatch = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useDispatch)();
  const selectorData = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => {
    if (!storeName) {
      return null;
    }
    return select(storeName).getSelectorDataForError(error);
  });
  const handleRetry = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.useCallback)(() => {
    dispatch(selectorData.storeName).invalidateResolution(selectorData.name, selectorData.args);
  }, [dispatch, selectorData]);

  // Do not display if there is no error and no direct message text is passed as a direct prop.
  // Also do not display if the error is for missing scopes as these are handled by a popup modal.
  if (!message || (0,_js_util_errors__WEBPACK_IMPORTED_MODULE_2__.isPermissionScopeError)(error)) {
    return null;
  }
  const shouldDisplayRetry = hasButton && (0,_js_util_errors__WEBPACK_IMPORTED_MODULE_2__.isErrorRetryable)(error, selectorData);

  /**
   * Error message to display to the user. Sometimes we append a retry message
   * or a reconnect URL, so we create a new variable for the message to display.
   */
  let errorMessageWithModifications = message;

  // Append "Try again" messaging if no retry button is present.
  if (!hasButton && !skipRetryMessage) {
    errorMessageWithModifications = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.sprintf)(/* translators: %s: Error message from Google API. */
    (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('%s (Please try again.)', 'google-site-kit'), errorMessageWithModifications);
  }
  if (!noPrefix) {
    errorMessageWithModifications = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.sprintf)(/* translators: $%s: Error message */
    (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Error: %s', 'google-site-kit'), errorMessageWithModifications);
  }
  const reconnectURL = error?.data?.reconnectURL;
  if (reconnectURL && (0,_wordpress_url__WEBPACK_IMPORTED_MODULE_7__.isURL)(reconnectURL)) {
    /**
     * This error message uses HTML tags without using
     * `createInterpolateElement` because the error messages
     * that come from the server/API can also contain HTML (eg. links)
     * we want to render.
     *
     * Instead of creating a React node using `createInterpolateElement`,
     * we use `dangerouslySetInnerHTML` to allow the HTML we create and from
     * the server/API to be rendered as-intended.
     */
    errorMessageWithModifications = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.sprintf)(/* translators: 1: Original error message 2: Reconnect URL */
    (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('%1$s To fix this, <a href="%2$s">redo the plugin setup</a>.', 'google-site-kit'), errorMessageWithModifications, reconnectURL);
  }
  const sanitizeArgs = {
    ALLOWED_TAGS: ['a'],
    ALLOWED_ATTR: ['href']
  };
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_Notice__WEBPACK_IMPORTED_MODULE_3__["default"], {
    className: className,
    type: _Notice__WEBPACK_IMPORTED_MODULE_3__["default"].TYPES.ERROR,
    description:
    /*#__PURE__*/
    // The error messages that come from the server/API can contain
    // HTML (eg. links), so we use `dangerouslySetInnerHTML` and sanitize
    // the HTML to render these links.
    //
    // We tried to use `createInterpolateElement` but it does not work
    // with HTML tags that come from the server/API.
    (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("span", {
      dangerouslySetInnerHTML: (0,_js_util__WEBPACK_IMPORTED_MODULE_4__.sanitizeHTML)(errorMessageWithModifications, sanitizeArgs)
    }),
    ctaButton: shouldDisplayRetry ? {
      label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Retry', 'google-site-kit'),
      onClick: handleRetry
    } : undefined,
    hideIcon: hideIcon
  });
}
ErrorNotice.propTypes = {
  className: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().string),
  error: prop_types__WEBPACK_IMPORTED_MODULE_8___default().shape({
    message: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().string)
  }),
  hasButton: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().bool),
  storeName: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().string),
  message: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().string),
  noPrefix: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().bool),
  skipRetryMessage: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().bool),
  hideIcon: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().bool)
};

/***/ }),

/***/ "./js/components/IconWrapper.js":
/*!**************************************!*\
  !*** ./js/components/IconWrapper.js ***!
  \**************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ IconWrapper)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * IconWrapper component.
 *
 * Site Kit by Google, Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


function IconWrapper({
  children,
  marginLeft,
  marginRight
}) {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("span", {
    className: "googlesitekit-icon-wrapper",
    style: {
      marginLeft,
      marginRight
    },
    children: children
  });
}
IconWrapper.propTypes = {
  children: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().node).isRequired,
  marginLeft: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().number),
  marginRight: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().number)
};

/***/ }),

/***/ "./js/components/InViewProvider/InViewContext.js":
/*!*******************************************************!*\
  !*** ./js/components/InViewProvider/InViewContext.js ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/**
 * InView context for React components.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */

const InViewContext = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createContext)(false);
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (InViewContext);

/***/ }),

/***/ "./js/components/InViewProvider/index.js":
/*!***********************************************!*\
  !*** ./js/components/InViewProvider/index.js ***!
  \***********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Consumer: () => (/* binding */ Consumer),
/* harmony export */   Provider: () => (/* binding */ Provider),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _InViewContext__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./InViewContext */ "./js/components/InViewProvider/InViewContext.js");
/**
 * In-view Provider component.
 *
 * Site Kit by Google, Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Internal dependencies
 */

const {
  Consumer,
  Provider
} = _InViewContext__WEBPACK_IMPORTED_MODULE_0__["default"];
const InViewProvider = Provider;
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (InViewProvider);

/***/ }),

/***/ "./js/components/InfoTooltip.js":
/*!**************************************!*\
  !*** ./js/components/InfoTooltip.js ***!
  \**************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ InfoTooltip)
/* harmony export */ });
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-components */ "googlesitekit-components");
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _svg_icons_info_green_svg__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/svg/icons/info-green.svg */ "./svg/icons/info-green.svg");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * InfoTooltip component.
 *
 * Site Kit by Google, Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * Internal dependencies
 */



function InfoTooltip({
  onOpen,
  title,
  tooltipClassName
}) {
  if (!title) {
    return null;
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__.Tooltip, {
    className: "googlesitekit-info-tooltip",
    tooltipClassName: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-info-tooltip__content', tooltipClassName),
    title: title,
    placement: "top",
    enterTouchDelay: 0,
    leaveTouchDelay: 5000,
    onOpen: onOpen,
    interactive: true,
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("span", {
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_svg_icons_info_green_svg__WEBPACK_IMPORTED_MODULE_2__["default"], {
        width: "16",
        height: "16"
      })
    })
  });
}
InfoTooltip.propTypes = {
  onOpen: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().func),
  title: prop_types__WEBPACK_IMPORTED_MODULE_4___default().oneOfType([(prop_types__WEBPACK_IMPORTED_MODULE_4___default().string), (prop_types__WEBPACK_IMPORTED_MODULE_4___default().element)]),
  tooltipClassName: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().string)
};

/***/ }),

/***/ "./js/components/JoyrideTooltip.js":
/*!*****************************************!*\
  !*** ./js/components/JoyrideTooltip.js ***!
  \*****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ JoyrideTooltip)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var react_joyride__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! react-joyride */ "../node_modules/react-joyride/dist/index.mjs");
/* harmony import */ var react_use__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! react-use */ "../node_modules/react-use/esm/useInterval.js");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _TourTooltip__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./TourTooltip */ "./js/components/TourTooltip.js");
/* harmony import */ var _Portal__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Portal */ "./js/components/Portal.js");
/* harmony import */ var _TourTooltips__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./TourTooltips */ "./js/components/TourTooltips.js");
/* harmony import */ var _js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/hooks/useBreakpoint */ "./js/hooks/useBreakpoint.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * JoyRideTooltip component.
 *
 * Site Kit by Google, Copyright 2022 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */




/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */





function JoyrideTooltip(props) {
  const {
    title,
    content,
    dismissLabel,
    disableOverlay = true,
    target,
    cta = false,
    className,
    styles = {},
    slug = '',
    placement = 'auto',
    onDismiss = () => {},
    onView = () => {},
    onTourStart = () => {},
    onTourEnd = () => {}
  } = props;
  function checkIfTargetExists() {
    return !!__webpack_require__.g.document.querySelector(target);
  }
  const [targetExists, setTargetExists] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_5__.useState)(checkIfTargetExists);
  const breakpoint = (0,_js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_3__.useBreakpoint)();
  const isMobileTablet = breakpoint === _js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_3__.BREAKPOINT_SMALL || breakpoint === _js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_3__.BREAKPOINT_TABLET;
  const [shouldRun, setShouldRun] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_5__.useState)(true);
  const previousIsMobileTabletRef = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_5__.useRef)(isMobileTablet);
  (0,react_use__WEBPACK_IMPORTED_MODULE_6__["default"])(() => {
    if (checkIfTargetExists()) {
      setTargetExists(true);
    }
  },
  // An delay of null will stop the interval.
  targetExists ? null : 250);
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_5__.useEffect)(() => {
    // eslint-disable-next-line sitekit/function-declaration-consistency
    let disconnect = () => {};
    if (typeof __webpack_require__.g.ResizeObserver === 'function') {
      const targetElement = __webpack_require__.g.document.querySelector(target);
      if (targetElement) {
        const resizeObserver = new ResizeObserver(() => {
          // Dispatch a window resize event to trigger the tooltip to reposition.
          __webpack_require__.g.dispatchEvent(new Event('resize'));
        });
        resizeObserver.observe(targetElement);
        disconnect = () => resizeObserver.disconnect();
      }
    }
    return disconnect;
  }, [target, targetExists]);

  // Reset the component between mobile and desktop layouts they use different
  // targets which requires the tooltip to be re-rendered to display correctly.
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_5__.useEffect)(() => {
    let timeoutID;
    if (previousIsMobileTabletRef.current !== isMobileTablet) {
      setShouldRun(false);
      timeoutID = setTimeout(() => {
        setShouldRun(true);
      }, 50);
      previousIsMobileTabletRef.current = isMobileTablet;
    }
    return () => {
      if (timeoutID) {
        clearTimeout(timeoutID);
      }
    };
  }, [isMobileTablet]);

  // Joyride expects the step's target to be in the DOM immediately
  // so we need to wait for it in some cases, e.g. loading data.
  if (!targetExists) {
    return null;
  }
  const steps = [{
    title,
    target,
    content,
    disableBeacon: true,
    isFixed: true,
    placement,
    cta,
    className
  }];

  // Provides button content as well as aria-label & title attribute values.
  const joyrideLocale = {
    close: dismissLabel,
    last: dismissLabel
  };
  function callback({
    type
  }) {
    switch (type) {
      case react_joyride__WEBPACK_IMPORTED_MODULE_7__.EVENTS.TOUR_START:
        onTourStart();
        __webpack_require__.g.document.body.classList.add('googlesitekit-showing-tooltip');
        break;
      case react_joyride__WEBPACK_IMPORTED_MODULE_7__.EVENTS.TOUR_END:
        onTourEnd();
        __webpack_require__.g.document.body.classList.remove('googlesitekit-showing-tooltip');
        break;
      case react_joyride__WEBPACK_IMPORTED_MODULE_7__.EVENTS.STEP_AFTER:
        // This is not strictly necessary as the tooltip will hide without it,
        // but this allows the consumer of the component to clean up
        // post-dismiss.
        onDismiss();
        break;
      case react_joyride__WEBPACK_IMPORTED_MODULE_7__.EVENTS.TOOLTIP:
        onView();
        break;
    }
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(_Portal__WEBPACK_IMPORTED_MODULE_1__["default"], {
    slug: slug,
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(react_joyride__WEBPACK_IMPORTED_MODULE_7__["default"], {
      callback: callback,
      disableOverlay: disableOverlay,
      spotlightPadding: 0,
      floaterProps: _TourTooltips__WEBPACK_IMPORTED_MODULE_2__.floaterProps,
      locale: joyrideLocale,
      steps: steps,
      styles: {
        ..._TourTooltips__WEBPACK_IMPORTED_MODULE_2__.joyrideStyles,
        ...styles,
        options: {
          ..._TourTooltips__WEBPACK_IMPORTED_MODULE_2__.joyrideStyles.options,
          ...styles?.options
        },
        spotlight: {
          ..._TourTooltips__WEBPACK_IMPORTED_MODULE_2__.joyrideStyles.spotlight,
          ...styles?.spotlight
        }
      },
      tooltipComponent: _TourTooltip__WEBPACK_IMPORTED_MODULE_0__["default"],
      run: shouldRun,
      disableScrolling: true
    })
  });
}
JoyrideTooltip.propTypes = {
  title: prop_types__WEBPACK_IMPORTED_MODULE_8__.PropTypes.node,
  content: prop_types__WEBPACK_IMPORTED_MODULE_8__.PropTypes.string,
  disableOverlay: prop_types__WEBPACK_IMPORTED_MODULE_8__.PropTypes.bool,
  dismissLabel: prop_types__WEBPACK_IMPORTED_MODULE_8__.PropTypes.string,
  target: prop_types__WEBPACK_IMPORTED_MODULE_8__.PropTypes.string.isRequired,
  onDismiss: prop_types__WEBPACK_IMPORTED_MODULE_8__.PropTypes.func,
  onShow: prop_types__WEBPACK_IMPORTED_MODULE_8__.PropTypes.func,
  className: prop_types__WEBPACK_IMPORTED_MODULE_8__.PropTypes.string,
  styles: prop_types__WEBPACK_IMPORTED_MODULE_8__.PropTypes.object,
  slug: prop_types__WEBPACK_IMPORTED_MODULE_8__.PropTypes.string,
  placement: prop_types__WEBPACK_IMPORTED_MODULE_8__.PropTypes.string,
  onView: prop_types__WEBPACK_IMPORTED_MODULE_8__.PropTypes.func
};

/***/ }),

/***/ "./js/components/KeyMetrics/AddMetricCTATile.js":
/*!******************************************************!*\
  !*** ./js/components/KeyMetrics/AddMetricCTATile.js ***!
  \******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ AddMetricCTATile)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_11___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_11__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var react_use__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! react-use */ "../node_modules/react-use/esm/useIntersection.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_keycodes__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @wordpress/keycodes */ "../node_modules/@wordpress/keycodes/build-module/index.js");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _js_googlesitekit_datastore_ui_constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/googlesitekit/datastore/ui/constants */ "./js/googlesitekit/datastore/ui/constants.js");
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./constants */ "./js/components/KeyMetrics/constants.js");
/* harmony import */ var _svg_icons_plus_svg__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/svg/icons/plus.svg */ "./svg/icons/plus.svg");
/* harmony import */ var _js_util__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/util */ "./js/util/index.js");
/* harmony import */ var _js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @/js/hooks/useViewContext */ "./js/hooks/useViewContext.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * AddMetricCTATile component.
 *
 * Site Kit by Google, Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */





/**
 * Internal dependencies
 */







function AddMetricCTATile({
  Widget
}) {
  const trackingRef = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_8__.useRef)();
  const {
    setValue
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useDispatch)(_js_googlesitekit_datastore_ui_constants__WEBPACK_IMPORTED_MODULE_2__.CORE_UI);
  const viewContext = (0,_js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_6__["default"])();
  const trackingCategory = `${viewContext}_kmw`;
  const openMetricsSelectionPanel = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_8__.useCallback)(event => {
    if (event.type === 'keydown' && ![_wordpress_keycodes__WEBPACK_IMPORTED_MODULE_9__.ENTER, _wordpress_keycodes__WEBPACK_IMPORTED_MODULE_9__.SPACE].includes(event.keyCode)) {
      return;
    }

    // Prevent scroll when spacebar is hit.
    event.preventDefault();
    setValue(_constants__WEBPACK_IMPORTED_MODULE_3__.KEY_METRICS_SELECTION_PANEL_OPENED_KEY, true);
    (0,_js_util__WEBPACK_IMPORTED_MODULE_5__.trackEvent)(trackingCategory, 'add_metric_click');
  }, [setValue, trackingCategory]);
  const intersectionEntry = (0,react_use__WEBPACK_IMPORTED_MODULE_10__["default"])(trackingRef, {
    threshold: 0.25
  });
  const [hasBeenInView, setHasBeenInView] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_8__.useState)(false);
  const inView = !!intersectionEntry?.intersectionRatio;
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_8__.useEffect)(() => {
    if (inView && !hasBeenInView) {
      (0,_js_util__WEBPACK_IMPORTED_MODULE_5__.trackEvent)(trackingCategory, 'add_metric_view');
      setHasBeenInView(true);
    }
  }, [inView, trackingCategory, hasBeenInView]);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(Widget, {
    className: "googlesitekit-widget--addMetricCTATile",
    noPadding: true,
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsxs)("div", {
      ref: trackingRef,
      className: "googlesitekit-km-add-metric-cta-tile",
      onClick: openMetricsSelectionPanel,
      onKeyDown: openMetricsSelectionPanel,
      tabIndex: 0,
      role: "button",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)("div", {
        className: "googlesitekit-km-add-metric-cta-tile__icon",
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_svg_icons_plus_svg__WEBPACK_IMPORTED_MODULE_4__["default"], {
          width: 16,
          height: 16
        })
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)("p", {
        className: "googlesitekit-km-add-metric-cta-tile__text",
        children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Add a metric', 'google-site-kit')
      })]
    })
  });
}
AddMetricCTATile.propTypes = {
  Widget: (prop_types__WEBPACK_IMPORTED_MODULE_11___default().elementType).isRequired
};

/***/ }),

/***/ "./js/components/KeyMetrics/ChangeMetricsLink.js":
/*!*******************************************************!*\
  !*** ./js/components/KeyMetrics/ChangeMetricsLink.js ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ ChangeMetricsLink)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _js_googlesitekit_datastore_ui_constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/googlesitekit/datastore/ui/constants */ "./js/googlesitekit/datastore/ui/constants.js");
/* harmony import */ var _js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/googlesitekit/datastore/user/constants */ "./js/googlesitekit/datastore/user/constants.js");
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./constants */ "./js/components/KeyMetrics/constants.js");
/* harmony import */ var _js_components_Link__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/components/Link */ "./js/components/Link.js");
/* harmony import */ var _svg_icons_pencil_alt_svg__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @/svg/icons/pencil-alt.svg */ "./svg/icons/pencil-alt.svg");
/* harmony import */ var _SetupCompletedSurveyTrigger__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./SetupCompletedSurveyTrigger */ "./js/components/KeyMetrics/SetupCompletedSurveyTrigger.js");
/* harmony import */ var _js_util__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @/js/util */ "./js/util/index.js");
/* harmony import */ var _js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @/js/hooks/useViewContext */ "./js/hooks/useViewContext.js");
/* harmony import */ var _hooks_useChangeMetricsFeatureTourEffect__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./hooks/useChangeMetricsFeatureTourEffect */ "./js/components/KeyMetrics/hooks/useChangeMetricsFeatureTourEffect.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Key Metrics ChangeMetricsLink component.
 *
 * Site Kit by Google, Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */











function ChangeMetricsLink() {
  const keyMetrics = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_USER).getKeyMetrics());
  const viewContext = (0,_js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_9__["default"])();
  const {
    setValue
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useDispatch)(_js_googlesitekit_datastore_ui_constants__WEBPACK_IMPORTED_MODULE_2__.CORE_UI);
  const openMetricsSelectionPanel = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_12__.useCallback)(() => {
    setValue(_constants__WEBPACK_IMPORTED_MODULE_4__.KEY_METRICS_SELECTION_PANEL_OPENED_KEY, true);
    (0,_js_util__WEBPACK_IMPORTED_MODULE_8__.trackEvent)(`${viewContext}_kmw`, 'change_metrics');
  }, [setValue, viewContext]);
  const renderChangeMetricLink = Array.isArray(keyMetrics) && keyMetrics?.length > 0;
  (0,_hooks_useChangeMetricsFeatureTourEffect__WEBPACK_IMPORTED_MODULE_10__.useChangeMetricsFeatureTourEffect)({
    renderChangeMetricLink
  });
  if (!renderChangeMetricLink) {
    return null;
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)(_wordpress_element__WEBPACK_IMPORTED_MODULE_12__.Fragment, {
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_js_components_Link__WEBPACK_IMPORTED_MODULE_5__["default"], {
      className: "googlesitekit-widget-area__cta-link googlesitekit-km-change-metrics-cta",
      onClick: openMetricsSelectionPanel,
      leadingIcon: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_svg_icons_pencil_alt_svg__WEBPACK_IMPORTED_MODULE_6__["default"], {
        width: 22,
        height: 22
      }),
      secondary: true,
      linkButton: true,
      children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Change metrics', 'google-site-kit')
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_SetupCompletedSurveyTrigger__WEBPACK_IMPORTED_MODULE_7__["default"], {})]
  });
}

/***/ }),

/***/ "./js/components/KeyMetrics/ChipTabGroup/Chip.js":
/*!*******************************************************!*\
  !*** ./js/components/KeyMetrics/ChipTabGroup/Chip.js ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Chip)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-components */ "googlesitekit-components");
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _js_components_KeyMetrics_constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/components/KeyMetrics/constants */ "./js/components/KeyMetrics/constants.js");
/* harmony import */ var _svg_icons_check_2_svg__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/svg/icons/check-2.svg */ "./svg/icons/check-2.svg");
/* harmony import */ var _svg_icons_star_fill_svg__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/svg/icons/star-fill.svg */ "./svg/icons/star-fill.svg");
/* harmony import */ var _js_components_Null__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/components/Null */ "./js/components/Null.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Chip component.
 *
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * Internal dependencies
 */






const icons = {
  [_js_components_KeyMetrics_constants__WEBPACK_IMPORTED_MODULE_2__.KEY_METRICS_GROUP_CURRENT.SLUG]: _svg_icons_check_2_svg__WEBPACK_IMPORTED_MODULE_3__["default"],
  [_js_components_KeyMetrics_constants__WEBPACK_IMPORTED_MODULE_2__.KEY_METRICS_GROUP_SUGGESTED.SLUG]: _svg_icons_star_fill_svg__WEBPACK_IMPORTED_MODULE_4__["default"]
};
function Chip({
  slug,
  label,
  isActive,
  onClick,
  hasNewBadge = false,
  selectedCount = 0
}) {
  const Icon = icons[slug] || _js_components_Null__WEBPACK_IMPORTED_MODULE_5__["default"];
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__.Button, {
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-chip-tab-group__chip-item', {
      'googlesitekit-chip-tab-group__chip-item--active': isActive
    }),
    icon: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(Icon, {
      width: 12,
      height: 12,
      className: `googlesitekit-chip-tab-group__chip-item-svg googlesitekit-chip-tab-group__chip-item-svg__${slug}`
    }),
    trailingIcon: selectedCount > 0 ? /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)("span", {
      className: "googlesitekit-chip-tab-group__chip-item-count",
      children: ["(", selectedCount, ")"]
    }) : null,
    onClick: () => onClick(slug),
    children: [label, hasNewBadge && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("span", {
      className: "googlesitekit-chip-tab-group__chip-item-new-dot"
    })]
  });
}
Chip.propTypes = {
  slug: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().string).isRequired,
  label: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().string).isRequired,
  isActive: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().bool),
  hasNewBadge: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().bool),
  selectedCount: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().number),
  onClick: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().func).isRequired
};

/***/ }),

/***/ "./js/components/KeyMetrics/ChipTabGroup/TabContent.js":
/*!*************************************************************!*\
  !*** ./js/components/KeyMetrics/ChipTabGroup/TabContent.js ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ TabContent)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _js_components_KeyMetrics_MetricsSelectionPanel_MetricItem__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/components/KeyMetrics/MetricsSelectionPanel/MetricItem */ "./js/components/KeyMetrics/MetricsSelectionPanel/MetricItem.js");
/* harmony import */ var _svg_graphics_key_metrics_no_selected_items_svg__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/svg/graphics/key-metrics-no-selected-items.svg */ "./svg/graphics/key-metrics-no-selected-items.svg");
/* harmony import */ var _js_components_Typography_P__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/components/Typography/P */ "./js/components/Typography/P.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * TabContent component.
 *
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */




function TabContent({
  activeMetricItems,
  newlyDetectedMetrics,
  savedItemSlugs
}) {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsxs)("div", {
    className: "googlesitekit-chip-tab-group__tab-item",
    children: [Object.keys(activeMetricItems).map(slug => {
      const metricGroup = activeMetricItems[slug].group;
      const isNewlyDetected = newlyDetectedMetrics?.[metricGroup]?.includes(slug);
      return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(_js_components_KeyMetrics_MetricsSelectionPanel_MetricItem__WEBPACK_IMPORTED_MODULE_1__["default"], {
        slug: slug,
        savedItemSlugs: savedItemSlugs,
        isNewlyDetected: isNewlyDetected,
        ...activeMetricItems[slug]
      }, slug);
    }), !Object.keys(activeMetricItems).length && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsxs)("div", {
      className: "googlesitekit-chip-tab-group__graphic",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(_svg_graphics_key_metrics_no_selected_items_svg__WEBPACK_IMPORTED_MODULE_2__["default"], {
        height: 250
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(_js_components_Typography_P__WEBPACK_IMPORTED_MODULE_3__["default"], {
        children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('No metrics were selected yet', 'google-site-kit')
      })]
    })]
  });
}
TabContent.propTypes = {
  activeMetricItems: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().object).isRequired,
  newlyDetectedMetrics: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().object).isRequired,
  savedItemSlugs: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().array)
};

/***/ }),

/***/ "./js/components/KeyMetrics/ChipTabGroup/TabItems.js":
/*!***********************************************************!*\
  !*** ./js/components/KeyMetrics/ChipTabGroup/TabItems.js ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ TabItems)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! googlesitekit-components */ "googlesitekit-components");
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_components__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Chip__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Chip */ "./js/components/KeyMetrics/ChipTabGroup/Chip.js");
/* harmony import */ var _svg_icons_check_2_svg__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/svg/icons/check-2.svg */ "./svg/icons/check-2.svg");
/* harmony import */ var _svg_icons_star_fill_svg__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/svg/icons/star-fill.svg */ "./svg/icons/star-fill.svg");
/* harmony import */ var _js_components_Null__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/components/Null */ "./js/components/Null.js");
/* harmony import */ var _js_components_KeyMetrics_constants__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/components/KeyMetrics/constants */ "./js/components/KeyMetrics/constants.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * TabItems component.
 *
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * Internal dependencies
 */







const icons = {
  [_js_components_KeyMetrics_constants__WEBPACK_IMPORTED_MODULE_5__.KEY_METRICS_GROUP_CURRENT.SLUG]: _svg_icons_check_2_svg__WEBPACK_IMPORTED_MODULE_2__["default"],
  [_js_components_KeyMetrics_constants__WEBPACK_IMPORTED_MODULE_5__.KEY_METRICS_GROUP_SUGGESTED.SLUG]: _svg_icons_star_fill_svg__WEBPACK_IMPORTED_MODULE_3__["default"]
};
function TabItems({
  containerRef,
  isMobileBreakpoint,
  chipItemRows,
  allGroups,
  isActive,
  onChipChange,
  selectedCounts,
  newlyDetectedMetrics,
  activeGroupIndex
}) {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)("div", {
    className: "googlesitekit-chip-tab-group__tab-items",
    ref: containerRef,
    children: [!isMobileBreakpoint && chipItemRows.map(row => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("div", {
      className: "googlesitekit-chip-tab-group__tab-items-row",
      children: row.map(group => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(_Chip__WEBPACK_IMPORTED_MODULE_1__["default"], {
        slug: group.SLUG,
        label: group.LABEL,
        hasNewBadge: !!newlyDetectedMetrics?.[group.SLUG],
        isActive: group.SLUG === isActive,
        onClick: onChipChange,
        selectedCount: selectedCounts[group.SLUG]
      }, group.SLUG))
    }, `row-${row[0].SLUG}`)), isMobileBreakpoint && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_0__.TabBar, {
      activeIndex: activeGroupIndex,
      handleActiveIndexUpdate: index => onChipChange(null, index),
      children: allGroups.map((group, index) => {
        const Icon = icons[group.SLUG] || _js_components_Null__WEBPACK_IMPORTED_MODULE_4__["default"];
        return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_0__.Tab, {
          "aria-label": group.LABEL,
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(Icon, {
            width: 12,
            height: 12,
            className: `googlesitekit-chip-tab-group__chip-item-svg googlesitekit-chip-tab-group__tab-item-mobile-svg googlesitekit-chip-tab-group__chip-item-svg__${group.SLUG}`
          }), group.LABEL, selectedCounts[group.SLUG] > 0 && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)("span", {
            className: "googlesitekit-chip-tab-group__chip-item-count",
            children: ["(", selectedCounts[group.SLUG], ")"]
          }), !!newlyDetectedMetrics?.[group.SLUG] && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("span", {
            className: "googlesitekit-chip-tab-group__chip-item-new-dot"
          })]
        }, index);
      })
    })]
  });
}
TabItems.propTypes = {
  containerRef: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().object),
  isMobileBreakpoint: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().bool),
  chipItemRows: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().array).isRequired,
  allGroups: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().array).isRequired,
  isActive: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().string).isRequired,
  onChipChange: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().func).isRequired,
  selectedCounts: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().object).isRequired,
  newlyDetectedMetrics: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().object).isRequired,
  activeGroupIndex: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().number).isRequired
};

/***/ }),

/***/ "./js/components/KeyMetrics/ChipTabGroup/index.js":
/*!********************************************************!*\
  !*** ./js/components/KeyMetrics/ChipTabGroup/index.js ***!
  \********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ ChipTabGroup)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _wordpress_compose__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! @wordpress/compose */ "../node_modules/@wordpress/compose/build-module/hooks/use-previous/index.js");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _js_components_KeyMetrics_constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/components/KeyMetrics/constants */ "./js/components/KeyMetrics/constants.js");
/* harmony import */ var _js_googlesitekit_datastore_forms_constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/googlesitekit/datastore/forms/constants */ "./js/googlesitekit/datastore/forms/constants.js");
/* harmony import */ var _js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/modules/analytics-4/datastore/constants */ "./js/modules/analytics-4/datastore/constants.js");
/* harmony import */ var _js_modules_analytics_4_constants__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/modules/analytics-4/constants */ "./js/modules/analytics-4/constants.js");
/* harmony import */ var _js_googlesitekit_datastore_ui_constants__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/googlesitekit/datastore/ui/constants */ "./js/googlesitekit/datastore/ui/constants.js");
/* harmony import */ var _js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @/js/googlesitekit/datastore/user/constants */ "./js/googlesitekit/datastore/user/constants.js");
/* harmony import */ var _js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @/js/googlesitekit/modules/datastore/constants */ "./js/googlesitekit/modules/datastore/constants.js");
/* harmony import */ var _js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @/js/hooks/useBreakpoint */ "./js/hooks/useBreakpoint.js");
/* harmony import */ var _js_hooks_useFormValue__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @/js/hooks/useFormValue */ "./js/hooks/useFormValue.js");
/* harmony import */ var _js_components_KeyMetrics_hooks_useCurrentlyActiveEvents__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @/js/components/KeyMetrics/hooks/useCurrentlyActiveEvents */ "./js/components/KeyMetrics/hooks/useCurrentlyActiveEvents.js");
/* harmony import */ var _js_components_KeyMetrics_hooks_useKeyMetricsGroups__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @/js/components/KeyMetrics/hooks/useKeyMetricsGroups */ "./js/components/KeyMetrics/hooks/useKeyMetricsGroups.js");
/* harmony import */ var _js_components_KeyMetrics_hooks_useFilteredKeyMetrics__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! @/js/components/KeyMetrics/hooks/useFilteredKeyMetrics */ "./js/components/KeyMetrics/hooks/useFilteredKeyMetrics.js");
/* harmony import */ var _js_components_KeyMetrics_hooks_useOverflowingTabs__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! @/js/components/KeyMetrics/hooks/useOverflowingTabs */ "./js/components/KeyMetrics/hooks/useOverflowingTabs.js");
/* harmony import */ var _js_components_KeyMetrics_hooks_useNewBadgeEvents__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! @/js/components/KeyMetrics/hooks/useNewBadgeEvents */ "./js/components/KeyMetrics/hooks/useNewBadgeEvents.js");
/* harmony import */ var _TabItems__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ./TabItems */ "./js/components/KeyMetrics/ChipTabGroup/TabItems.js");
/* harmony import */ var _TabContent__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ./TabContent */ "./js/components/KeyMetrics/ChipTabGroup/TabContent.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * ChipTabGroup component.
 *
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */


















const emptyArray = Object.freeze([]);
function ChipTabGroup({
  allMetricItems,
  savedItemSlugs
}) {
  const containerRef = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_18__.useRef)();
  const [isActive, setIsActive] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_18__.useState)(_js_components_KeyMetrics_constants__WEBPACK_IMPORTED_MODULE_1__.KEY_METRICS_GROUP_CURRENT.SLUG);
  // Used for mobile chip tabs, which leverages the TabBar component for seemless horizontal scroll
  // but it accepts a numerical index for the active tab.
  const [activeGroupIndex, setActiveGroupIndex] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_18__.useState)(0);
  const breakpoint = (0,_js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_8__.useBreakpoint)();
  const isMobileBreakpoint = breakpoint === _js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_8__.BREAKPOINT_SMALL;
  const selectedMetrics = (0,_js_hooks_useFormValue__WEBPACK_IMPORTED_MODULE_9__["default"])(_js_components_KeyMetrics_constants__WEBPACK_IMPORTED_MODULE_1__.KEY_METRICS_SELECTION_FORM, _js_components_KeyMetrics_constants__WEBPACK_IMPORTED_MODULE_1__.KEY_METRICS_SELECTED);
  const effectiveSelection = (0,_js_hooks_useFormValue__WEBPACK_IMPORTED_MODULE_9__["default"])(_js_components_KeyMetrics_constants__WEBPACK_IMPORTED_MODULE_1__.KEY_METRICS_SELECTION_FORM, _js_components_KeyMetrics_constants__WEBPACK_IMPORTED_MODULE_1__.EFFECTIVE_SELECTION) || emptyArray;
  const unstagedSelection = (0,_js_hooks_useFormValue__WEBPACK_IMPORTED_MODULE_9__["default"])(_js_components_KeyMetrics_constants__WEBPACK_IMPORTED_MODULE_1__.KEY_METRICS_SELECTION_FORM, _js_components_KeyMetrics_constants__WEBPACK_IMPORTED_MODULE_1__.UNSTAGED_SELECTION) || emptyArray;
  const isUserInputCompleted = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useSelect)(select => select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_6__.CORE_USER).isUserInputCompleted());
  const currentlyActiveEvents = (0,_js_components_KeyMetrics_hooks_useCurrentlyActiveEvents__WEBPACK_IMPORTED_MODULE_10__["default"])();
  const isGA4Connected = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useSelect)(select => select(_js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_7__.CORE_MODULES).isModuleConnected(_js_modules_analytics_4_constants__WEBPACK_IMPORTED_MODULE_4__.MODULE_SLUG_ANALYTICS_4));
  const detectedEvents = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useSelect)(select => {
    if (!isGA4Connected) {
      return [];
    }
    return select(_js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_3__.MODULES_ANALYTICS_4).getDetectedEvents();
  });
  const answerBasedMetrics = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useSelect)(select => select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_6__.CORE_USER).getAnswerBasedMetrics(null, [...(currentlyActiveEvents || []), ...(detectedEvents || [])]));
  const {
    keyMetricsGroups,
    dynamicGroups
  } = (0,_js_components_KeyMetrics_hooks_useKeyMetricsGroups__WEBPACK_IMPORTED_MODULE_11__["default"])({
    detectedEvents,
    currentlyActiveEvents,
    isUserInputCompleted,
    answerBasedMetrics
  });
  const allGroups = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_18__.useMemo)(() => [...dynamicGroups, ...keyMetricsGroups], [dynamicGroups, keyMetricsGroups]);
  const newBadgeEvents = (0,_js_components_KeyMetrics_hooks_useNewBadgeEvents__WEBPACK_IMPORTED_MODULE_14__["default"])();
  const conversionReportingEventWidgets = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useSelect)(select => {
    if (!isGA4Connected) {
      return [];
    }
    return select(_js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_3__.MODULES_ANALYTICS_4).getKeyMetricsConversionEventWidgets();
  });
  const {
    selectedCounts,
    activeMetricItems,
    newlyDetectedMetrics
  } = (0,_js_components_KeyMetrics_hooks_useFilteredKeyMetrics__WEBPACK_IMPORTED_MODULE_12__["default"])({
    allMetricItems,
    isActive,
    effectiveSelection,
    answerBasedMetrics,
    selectedMetrics,
    newBadgeEvents,
    conversionReportingEventWidgets
  });
  const {
    setValues
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useDispatch)(_js_googlesitekit_datastore_forms_constants__WEBPACK_IMPORTED_MODULE_2__.CORE_FORMS);
  const resetUnstagedSelection = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_18__.useCallback)(() => {
    setValues(_js_components_KeyMetrics_constants__WEBPACK_IMPORTED_MODULE_1__.KEY_METRICS_SELECTION_FORM, {
      [_js_components_KeyMetrics_constants__WEBPACK_IMPORTED_MODULE_1__.KEY_METRICS_SELECTED]: selectedMetrics,
      [_js_components_KeyMetrics_constants__WEBPACK_IMPORTED_MODULE_1__.EFFECTIVE_SELECTION]: [...effectiveSelection, ...unstagedSelection],
      [_js_components_KeyMetrics_constants__WEBPACK_IMPORTED_MODULE_1__.UNSTAGED_SELECTION]: []
    });
  }, [selectedMetrics, effectiveSelection, unstagedSelection, setValues]);
  const onChipChange = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_18__.useCallback)((slug, index) => {
    if (!slug) {
      // Set active group for mobile tabs.
      const activeGroup = allGroups[index];
      setActiveGroupIndex(index);
      setIsActive(activeGroup.SLUG);
    } else {
      setIsActive(slug);
    }
    if (unstagedSelection.length) {
      resetUnstagedSelection();
    }
  }, [allGroups, unstagedSelection, setIsActive, resetUnstagedSelection]);
  const isSelectionPanelOpen = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useSelect)(select => select(_js_googlesitekit_datastore_ui_constants__WEBPACK_IMPORTED_MODULE_5__.CORE_UI).getValue(_js_components_KeyMetrics_constants__WEBPACK_IMPORTED_MODULE_1__.KEY_METRICS_SELECTION_PANEL_OPENED_KEY));
  const isSelectionPanelOpenPrevious = (0,_wordpress_compose__WEBPACK_IMPORTED_MODULE_19__["default"])(isSelectionPanelOpen);
  const newlyDetectedMetricsKeys = Object.keys(newlyDetectedMetrics);
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_18__.useEffect)(() => {
    // Ensure that current selection group is always active when selection panel re-opens.
    if (!isSelectionPanelOpenPrevious && isSelectionPanelOpen) {
      setIsActive(_js_components_KeyMetrics_constants__WEBPACK_IMPORTED_MODULE_1__.KEY_METRICS_GROUP_CURRENT.SLUG);
      setActiveGroupIndex(0);
      if (newlyDetectedMetricsKeys.length && isMobileBreakpoint) {
        const firstNewlyDetectedGroup = allGroups.find(group => group.SLUG === newlyDetectedMetricsKeys[0]);
        setActiveGroupIndex(allGroups.indexOf(firstNewlyDetectedGroup));
        setIsActive(firstNewlyDetectedGroup.SLUG);
      } else {
        setActiveGroupIndex(0);
        setIsActive(_js_components_KeyMetrics_constants__WEBPACK_IMPORTED_MODULE_1__.KEY_METRICS_GROUP_CURRENT.SLUG);
      }
    }
    if (isSelectionPanelOpenPrevious && !isSelectionPanelOpen) {
      // Reset the unstaged selection when selection panel is closed.
      resetUnstagedSelection();
    }
  }, [isSelectionPanelOpen, isSelectionPanelOpenPrevious, unstagedSelection, allGroups, isMobileBreakpoint, newlyDetectedMetricsKeys, resetUnstagedSelection]);
  (0,_js_components_KeyMetrics_hooks_useOverflowingTabs__WEBPACK_IMPORTED_MODULE_13__["default"])({
    containerRef,
    isMobileBreakpoint,
    isSelectionPanelOpen,
    isSelectionPanelOpenPrevious
  });
  const chipItemRows = [[...dynamicGroups, ...keyMetricsGroups.slice(0, 2)], [...keyMetricsGroups.slice(2)]];
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_17__.jsxs)("div", {
    className: "googlesitekit-chip-tab-group",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_17__.jsx)(_TabItems__WEBPACK_IMPORTED_MODULE_15__["default"], {
      containerRef: containerRef,
      isMobileBreakpoint: isMobileBreakpoint,
      chipItemRows: chipItemRows,
      allGroups: allGroups,
      isActive: isActive,
      onChipChange: onChipChange,
      selectedCounts: selectedCounts,
      newlyDetectedMetrics: newlyDetectedMetrics,
      activeGroupIndex: activeGroupIndex
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_17__.jsx)(_TabContent__WEBPACK_IMPORTED_MODULE_16__["default"], {
      activeMetricItems: activeMetricItems,
      newlyDetectedMetrics: newlyDetectedMetrics,
      savedItemSlugs: savedItemSlugs
    })]
  });
}

/***/ }),

/***/ "./js/components/KeyMetrics/GetHelpLink.js":
/*!*************************************************!*\
  !*** ./js/components/KeyMetrics/GetHelpLink.js ***!
  \*************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ GetHelpLink)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/@wordpress/element/build-module/create-interpolate-element.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _js_components_Link__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/components/Link */ "./js/components/Link.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * GetHelpLink component.
 *
 * Site Kit by Google, Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */


function GetHelpLink({
  linkURL
}) {
  return (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_3__["default"])(/* translators: %s: get help text. */
  (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Trouble getting access? <HelpLink />', 'google-site-kit'), {
    HelpLink: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)(_js_components_Link__WEBPACK_IMPORTED_MODULE_1__["default"], {
      href: linkURL,
      external: true,
      hideExternalIndicator: true,
      children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Get help', 'google-site-kit')
    })
  });
}
GetHelpLink.propTypes = {
  linkURL: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().string).isRequired
};

/***/ }),

/***/ "./js/components/KeyMetrics/InsufficientPermissionsError.js":
/*!******************************************************************!*\
  !*** ./js/components/KeyMetrics/InsufficientPermissionsError.js ***!
  \******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ InsufficientPermissionsError)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_10__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/@wordpress/element/build-module/create-interpolate-element.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/googlesitekit/datastore/site/constants */ "./js/googlesitekit/datastore/site/constants.js");
/* harmony import */ var _js_components_Link__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/components/Link */ "./js/components/Link.js");
/* harmony import */ var _MetricTileError__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./MetricTileError */ "./js/components/KeyMetrics/MetricTileError.js");
/* harmony import */ var _js_util__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/util */ "./js/util/index.js");
/* harmony import */ var _js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @/js/hooks/useViewContext */ "./js/hooks/useViewContext.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Site Kit by Google, Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */







function InsufficientPermissionsError(props) {
  const {
    moduleSlug,
    onRetry,
    infoTooltip,
    headerText
  } = props;
  const viewContext = (0,_js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_6__["default"])();
  const helpLink = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_2__.CORE_SITE).getErrorTroubleshootingLinkURL({
    code: `${moduleSlug}_insufficient_permissions`
  }));
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_8__.useEffect)(() => {
    (0,_js_util__WEBPACK_IMPORTED_MODULE_5__.trackEventOnce)(`${viewContext}_kmw`, 'insufficient_permissions_error');
  }, [viewContext]);
  const retry = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_8__.useCallback)(() => {
    (0,_js_util__WEBPACK_IMPORTED_MODULE_5__.trackEvent)(`${viewContext}_kmw`, 'insufficient_permissions_error_retry');
    onRetry?.();
  }, [onRetry, viewContext]);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_MetricTileError__WEBPACK_IMPORTED_MODULE_4__["default"], {
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Insufficient permissions', 'google-site-kit'),
    headerText: headerText,
    infoTooltip: infoTooltip,
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsxs)("div", {
      className: "googlesitekit-report-error-actions",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)("span", {
        className: "googlesitekit-error-retry-text",
        children: (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__["default"])((0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Permissions updated? <a>Retry</a>', 'google-site-kit'), {
          a: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_js_components_Link__WEBPACK_IMPORTED_MODULE_3__["default"], {
            onClick: retry
          })
        })
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)("span", {
        className: "googlesitekit-error-retry-text",
        children: (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__["default"])((0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('You’ll need to contact your administrator. <a>Learn more</a>', 'google-site-kit'), {
          a: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_js_components_Link__WEBPACK_IMPORTED_MODULE_3__["default"], {
            href: helpLink,
            external: true,
            hideExternalIndicator: true
          })
        })
      })]
    })
  });
}
InsufficientPermissionsError.propTypes = {
  moduleSlug: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().string).isRequired,
  onRetry: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().func).isRequired,
  headerText: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().string),
  infoTooltip: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().string)
};

/***/ }),

/***/ "./js/components/KeyMetrics/KeyMetricsNewBadge.js":
/*!********************************************************!*\
  !*** ./js/components/KeyMetrics/KeyMetricsNewBadge.js ***!
  \********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ KeyMetricsNewBadge)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/googlesitekit/datastore/site/constants */ "./js/googlesitekit/datastore/site/constants.js");
/* harmony import */ var _js_components_Badge__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/components/Badge */ "./js/components/Badge.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Site Kit by Google, Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */




function KeyMetricsNewBadge() {
  // This is necessary to conditionally render the badge
  // as this component is used in a context where `select` is not in scope.
  const isKeyMetricsSetupNew = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_2__.CORE_SITE).getKeyMetricsSetupNew());
  const isKeyMetricsSetupCompleted = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_2__.CORE_SITE).isKeyMetricsSetupCompleted());
  const [initialKeyMetricsSetupCompleted] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_5__.useState)(isKeyMetricsSetupCompleted);
  const [isNew, setIsNew] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_5__.useState)(isKeyMetricsSetupNew);
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_5__.useEffect)(() => {
    if (!initialKeyMetricsSetupCompleted && isKeyMetricsSetupCompleted) {
      setIsNew(true);
    }
  }, [initialKeyMetricsSetupCompleted, isKeyMetricsSetupCompleted]);

  // In new ACR design "New" badge is shown only initially before
  // KMW is setup, afterwards, "New" badge is not visible anymore.
  if (isKeyMetricsSetupCompleted || !isNew) {
    return null;
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(_js_components_Badge__WEBPACK_IMPORTED_MODULE_3__["default"], {
    className: "googlesitekit-new-badge",
    label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('New', 'google-site-kit')
  });
}

/***/ }),

/***/ "./js/components/KeyMetrics/KeyMetricsSetupCTAWidget.js":
/*!**************************************************************!*\
  !*** ./js/components/KeyMetrics/KeyMetricsSetupCTAWidget.js ***!
  \**************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_19___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_19__);
/* harmony import */ var react_use__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! react-use */ "../node_modules/react-use/esm/useIntersection.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/googlesitekit/datastore/user/constants */ "./js/googlesitekit/datastore/user/constants.js");
/* harmony import */ var _js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/googlesitekit/datastore/site/constants */ "./js/googlesitekit/datastore/site/constants.js");
/* harmony import */ var _js_googlesitekit_datastore_location_constants__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/googlesitekit/datastore/location/constants */ "./js/googlesitekit/datastore/location/constants.js");
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./constants */ "./js/components/KeyMetrics/constants.js");
/* harmony import */ var _js_modules_analytics_4_constants__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @/js/modules/analytics-4/constants */ "./js/modules/analytics-4/constants.js");
/* harmony import */ var _js_util_when_active__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @/js/util/when-active */ "./js/util/when-active.js");
/* harmony import */ var _js_components_AdminScreenTooltip__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @/js/components/AdminScreenTooltip */ "./js/components/AdminScreenTooltip/index.js");
/* harmony import */ var _js_util__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @/js/util */ "./js/util/index.js");
/* harmony import */ var _js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @/js/hooks/useViewContext */ "./js/hooks/useViewContext.js");
/* harmony import */ var _hooks_useDisplayCTAWidget__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./hooks/useDisplayCTAWidget */ "./js/components/KeyMetrics/hooks/useDisplayCTAWidget.js");
/* harmony import */ var _js_components_Banner__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! @/js/components/Banner */ "./js/components/Banner/index.js");
/* harmony import */ var _js_components_Link__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! @/js/components/Link */ "./js/components/Link.js");
/* harmony import */ var _svg_graphics_banner_conversions_setup_cta_svg_url__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! @/svg/graphics/banner-conversions-setup-cta.svg?url */ "./svg/graphics/banner-conversions-setup-cta.svg?url");
/* harmony import */ var _svg_graphics_banner_conversions_setup_cta_mobile_svg_url__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! @/svg/graphics/banner-conversions-setup-cta-mobile.svg?url */ "./svg/graphics/banner-conversions-setup-cta-mobile.svg?url");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * KeyMetricsSetupCTAWidget component.
 *
 * Site Kit by Google, Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */
















function KeyMetricsSetupCTAWidget({
  Widget,
  WidgetNull
}) {
  const trackingRef = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_17__.useRef)();
  const viewContext = (0,_js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_10__["default"])();
  const trackEventCategory = `${viewContext}_kmw-cta-notification`;
  const displayCTAWidget = (0,_hooks_useDisplayCTAWidget__WEBPACK_IMPORTED_MODULE_11__["default"])();
  const ctaLink = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_SITE).getAdminURL('googlesitekit-user-input'));
  const fullScreenSelectionLink = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_SITE).getAdminURL('googlesitekit-metric-selection'));
  const isNavigatingToCTALink = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => ctaLink && select(_js_googlesitekit_datastore_location_constants__WEBPACK_IMPORTED_MODULE_4__.CORE_LOCATION).isNavigatingTo(ctaLink));
  const intersectionEntry = (0,react_use__WEBPACK_IMPORTED_MODULE_18__["default"])(trackingRef, {
    threshold: 0.25
  });
  const [hasBeenInView, setHasBeenInView] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_17__.useState)(false);
  const inView = !!intersectionEntry?.intersectionRatio;
  const {
    triggerSurvey
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useDispatch)(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_2__.CORE_USER);
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_17__.useEffect)(() => {
    if (!inView || hasBeenInView) {
      return;
    }
    (0,_js_util__WEBPACK_IMPORTED_MODULE_9__.trackEvent)(`${viewContext}_kmw-cta-notification`, 'view_notification');
    triggerSurvey('view_kmw_setup_cta', {
      ttl: _js_util__WEBPACK_IMPORTED_MODULE_9__.WEEK_IN_SECONDS
    });
    setHasBeenInView(true);
  }, [inView, hasBeenInView, viewContext, triggerSurvey]);
  const tooltipSettings = {
    tooltipSlug: _constants__WEBPACK_IMPORTED_MODULE_5__.KEY_METRICS_SETUP_CTA_WIDGET_SLUG,
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('You can always set up goals in Settings later', 'google-site-kit'),
    content: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('The Key Metrics section will be added back to your dashboard once you set your goals in Settings', 'google-site-kit'),
    dismissLabel: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Got it', 'google-site-kit')
  };
  const showTooltip = (0,_js_components_AdminScreenTooltip__WEBPACK_IMPORTED_MODULE_8__.useShowTooltip)(tooltipSettings);
  const {
    dismissItem
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useDispatch)(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_2__.CORE_USER);
  const handleDismiss = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_17__.useCallback)(async () => {
    await (0,_js_util__WEBPACK_IMPORTED_MODULE_9__.trackEvent)(trackEventCategory, 'dismiss_notification');
    showTooltip();
    await dismissItem(_constants__WEBPACK_IMPORTED_MODULE_5__.KEY_METRICS_SETUP_CTA_WIDGET_SLUG);
  }, [trackEventCategory, showTooltip, dismissItem]);
  const {
    navigateTo
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useDispatch)(_js_googlesitekit_datastore_location_constants__WEBPACK_IMPORTED_MODULE_4__.CORE_LOCATION);
  const openMetricsSelectionPanel = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_17__.useCallback)(async () => {
    await (0,_js_util__WEBPACK_IMPORTED_MODULE_9__.trackEvent)(trackEventCategory, 'confirm_pick_own_metrics');
    navigateTo(fullScreenSelectionLink);
  }, [trackEventCategory, navigateTo, fullScreenSelectionLink]);
  const onGetTailoredMetricsClick = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_17__.useCallback)(async () => {
    await (0,_js_util__WEBPACK_IMPORTED_MODULE_9__.trackEvent)(trackEventCategory, 'confirm_get_tailored_metrics');
    navigateTo(ctaLink);
  }, [trackEventCategory, navigateTo, ctaLink]);
  if (!displayCTAWidget) {
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx)(WidgetNull, {});
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx)(Widget, {
    noPadding: true,
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx)(_js_components_Banner__WEBPACK_IMPORTED_MODULE_12__["default"], {
      ref: trackingRef,
      className: "googlesitekit-banner--setup-cta",
      title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Get personalized suggestions for user interaction metrics based on your goals', 'google-site-kit'),
      description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Answer 3 questions and we’ll suggest relevant metrics for your dashboard. These metrics will help you track how users interact with your site.', 'google-site-kit'),
      dismissButton: {
        label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Maybe later', 'google-site-kit'),
        onClick: handleDismiss
      },
      ctaButton: {
        label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Get tailored metrics', 'google-site-kit'),
        onClick: onGetTailoredMetricsClick,
        disabled: isNavigatingToCTALink,
        inProgress: isNavigatingToCTALink
      },
      svg: {
        desktop: _svg_graphics_banner_conversions_setup_cta_svg_url__WEBPACK_IMPORTED_MODULE_14__["default"],
        mobile: _svg_graphics_banner_conversions_setup_cta_mobile_svg_url__WEBPACK_IMPORTED_MODULE_15__["default"],
        verticalPosition: 'top'
      },
      footer: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsxs)("div", {
        className: "googlesitekit-widget-key-metrics-footer",
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx)("span", {
          children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Interested in specific metrics?', 'google-site-kit')
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx)(_js_components_Link__WEBPACK_IMPORTED_MODULE_13__["default"], {
          onClick: openMetricsSelectionPanel,
          children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Select your own metrics', 'google-site-kit')
        })]
      })
    })
  });
}
KeyMetricsSetupCTAWidget.propTypes = {
  Widget: (prop_types__WEBPACK_IMPORTED_MODULE_19___default().elementType).isRequired,
  WidgetNull: (prop_types__WEBPACK_IMPORTED_MODULE_19___default().elementType)
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ((0,_js_util_when_active__WEBPACK_IMPORTED_MODULE_7__["default"])({
  moduleName: _js_modules_analytics_4_constants__WEBPACK_IMPORTED_MODULE_6__.MODULE_SLUG_ANALYTICS_4
})(KeyMetricsSetupCTAWidget));

/***/ }),

/***/ "./js/components/KeyMetrics/MetricTileError.js":
/*!*****************************************************!*\
  !*** ./js/components/KeyMetrics/MetricTileError.js ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ MetricTileError)
/* harmony export */ });
/* harmony import */ var _js_components_notifications_CTA__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @/js/components/notifications/CTA */ "./js/components/notifications/CTA.js");
/* harmony import */ var _js_components_InfoTooltip__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/components/InfoTooltip */ "./js/components/InfoTooltip.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * MetricTileError component.
 *
 * Site Kit by Google, Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Internal dependencies
 */



function MetricTileError(props) {
  const {
    children,
    headerText,
    infoTooltip,
    title
  } = props;
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("div", {
    className: "googlesitekit-km-widget-tile--error",
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)(_js_components_notifications_CTA__WEBPACK_IMPORTED_MODULE_0__["default"], {
      title: title,
      headerText: headerText,
      headerContent: infoTooltip && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)(_js_components_InfoTooltip__WEBPACK_IMPORTED_MODULE_1__["default"], {
        title: infoTooltip
      }),
      description: "",
      error: true,
      children: children
    })
  });
}

/***/ }),

/***/ "./js/components/KeyMetrics/MetricTileHeader.js":
/*!******************************************************!*\
  !*** ./js/components/KeyMetrics/MetricTileHeader.js ***!
  \******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ MetricTileHeader)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _js_components_InfoTooltip__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @/js/components/InfoTooltip */ "./js/components/InfoTooltip.js");
/* harmony import */ var _js_components_VisuallyHidden__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/components/VisuallyHidden */ "./js/components/VisuallyHidden.js");
/* harmony import */ var _js_components_Typography__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/components/Typography */ "./js/components/Typography/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * MetricTileHeader component.
 *
 * Site Kit by Google, Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * Internal dependencies
 */




function MetricTileHeader({
  title,
  infoTooltip,
  loading
}) {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
    className: "googlesitekit-km-widget-tile__title-container",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_js_components_Typography__WEBPACK_IMPORTED_MODULE_2__["default"], {
      as: "h3",
      size: "small",
      type: "label",
      className: "googlesitekit-km-widget-tile__title",
      children: title
    }), loading ? /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_js_components_VisuallyHidden__WEBPACK_IMPORTED_MODULE_1__["default"], {
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_js_components_InfoTooltip__WEBPACK_IMPORTED_MODULE_0__["default"], {
        title: infoTooltip
      })
    }) : /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_js_components_InfoTooltip__WEBPACK_IMPORTED_MODULE_0__["default"], {
      title: infoTooltip
    })]
  });
}
MetricTileHeader.propTypes = {
  title: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().string),
  infoTooltip: prop_types__WEBPACK_IMPORTED_MODULE_4___default().oneOfType([(prop_types__WEBPACK_IMPORTED_MODULE_4___default().string), (prop_types__WEBPACK_IMPORTED_MODULE_4___default().element)]),
  loading: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().bool)
};

/***/ }),

/***/ "./js/components/KeyMetrics/MetricTileLoader.js":
/*!******************************************************!*\
  !*** ./js/components/KeyMetrics/MetricTileLoader.js ***!
  \******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ MetricTileLoader)
/* harmony export */ });
/* harmony import */ var _js_components_PreviewBlock__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @/js/components/PreviewBlock */ "./js/components/PreviewBlock.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Loader for `MetricTile` components.
 *
 * Site Kit by Google, Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Internal dependencies
 */


function MetricTileLoader() {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsxs)("div", {
    className: "googlesitekit-km-widget-tile__loading",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)(_js_components_PreviewBlock__WEBPACK_IMPORTED_MODULE_0__["default"], {
      className: "googlesitekit-km-widget-tile__loading-header",
      width: "100%",
      height: "14px"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)(_js_components_PreviewBlock__WEBPACK_IMPORTED_MODULE_0__["default"], {
      className: "googlesitekit-km-widget-tile__loading-body",
      width: "100%",
      height: "53px"
    })]
  });
}

/***/ }),

/***/ "./js/components/KeyMetrics/MetricTileNumeric.js":
/*!*******************************************************!*\
  !*** ./js/components/KeyMetrics/MetricTileNumeric.js ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ MetricTileNumeric)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _js_util__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @/js/util */ "./js/util/index.js");
/* harmony import */ var _js_components_ChangeBadge__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/components/ChangeBadge */ "./js/components/ChangeBadge.js");
/* harmony import */ var _MetricTileWrapper__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./MetricTileWrapper */ "./js/components/KeyMetrics/MetricTileWrapper.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * MetricTileNumeric component.
 *
 * Site Kit by Google, Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * Internal dependencies
 */




function MetricTileNumeric({
  metricValue,
  metricValueFormat,
  subText,
  previousValue,
  currentValue,
  ...props
}) {
  const formatOptions = (0,_js_util__WEBPACK_IMPORTED_MODULE_0__.expandNumFmtOptions)(metricValueFormat);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)(_MetricTileWrapper__WEBPACK_IMPORTED_MODULE_2__["default"], {
    className: "googlesitekit-km-widget-tile--numeric",
    ...props,
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
      className: "googlesitekit-km-widget-tile__metric-container",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
        className: "googlesitekit-km-widget-tile__metric",
        children: (0,_js_util__WEBPACK_IMPORTED_MODULE_0__.numFmt)(metricValue, formatOptions)
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("p", {
        className: "googlesitekit-km-widget-tile__subtext",
        children: subText
      })]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
      className: "googlesitekit-km-widget-tile__metric-change-container",
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_js_components_ChangeBadge__WEBPACK_IMPORTED_MODULE_1__["default"], {
        previousValue: previousValue,
        currentValue: currentValue,
        isAbsolute: formatOptions?.style === 'percent'
      })
    })]
  });
}
MetricTileNumeric.propTypes = {
  metricValue: prop_types__WEBPACK_IMPORTED_MODULE_4___default().oneOfType([(prop_types__WEBPACK_IMPORTED_MODULE_4___default().string), (prop_types__WEBPACK_IMPORTED_MODULE_4___default().number)]),
  metricValueFormat: prop_types__WEBPACK_IMPORTED_MODULE_4___default().oneOfType([(prop_types__WEBPACK_IMPORTED_MODULE_4___default().string), (prop_types__WEBPACK_IMPORTED_MODULE_4___default().object)]),
  subtext: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().string),
  previousValue: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().number),
  currentValue: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().number)
};

/***/ }),

/***/ "./js/components/KeyMetrics/MetricTileTable.js":
/*!*****************************************************!*\
  !*** ./js/components/KeyMetrics/MetricTileTable.js ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ MetricTileTable)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! lodash */ "../node_modules/lodash/lodash.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _MetricTileWrapper__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./MetricTileWrapper */ "./js/components/KeyMetrics/MetricTileWrapper.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Site Kit by Google, Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */




/**
 * Internal dependencies
 */


function MetricTileTable({
  rows = [],
  columns = [],
  limit,
  ZeroState,
  ...props
}) {
  let tileBody = null;
  if (rows?.length > 0) {
    tileBody = rows.slice(0, limit || rows.length).map((row, rowIndex) => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
      className: "googlesitekit-table__body-row",
      children: columns.map(({
        Component,
        field,
        className
      }, colIndex) => {
        const fieldValue = field !== undefined ? (0,lodash__WEBPACK_IMPORTED_MODULE_0__.get)(row, field) : undefined;
        return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
          className: classnames__WEBPACK_IMPORTED_MODULE_1___default()('googlesitekit-table__body-item', className),
          children: [Component && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(Component, {
            row: row,
            fieldValue: fieldValue
          }), !Component && fieldValue]
        }, colIndex);
      })
    }, rowIndex));
  } else if (!!ZeroState) {
    tileBody = /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
      className: "googlesitekit-table__body-row googlesitekit-table__body-row--no-data",
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
        className: "googlesitekit-table__body-zero-data",
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(ZeroState, {})
      })
    });
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_MetricTileWrapper__WEBPACK_IMPORTED_MODULE_2__["default"], {
    className: "googlesitekit-km-widget-tile--table",
    ...props,
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
      className: "googlesitekit-km-widget-tile__table",
      children: tileBody
    })
  });
}
MetricTileTable.propTypes = {
  rows: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().array),
  columns: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().array),
  limit: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().number),
  ZeroState: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().elementType)
};

/***/ }),

/***/ "./js/components/KeyMetrics/MetricTileTablePlainText.js":
/*!**************************************************************!*\
  !*** ./js/components/KeyMetrics/MetricTileTablePlainText.js ***!
  \**************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ MetricTileTablePlainText)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * MetricTileTablePlainText component.
 *
 * Site Kit by Google, Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


function MetricTileTablePlainText({
  content
}) {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("p", {
    className: "googlesitekit-km-widget-tile__table-plain-text",
    children: content
  });
}
MetricTileTablePlainText.propTypes = {
  content: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string).isRequired
};

/***/ }),

/***/ "./js/components/KeyMetrics/MetricTileText.js":
/*!****************************************************!*\
  !*** ./js/components/KeyMetrics/MetricTileText.js ***!
  \****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ MetricTileText)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _js_components_ChangeBadge__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @/js/components/ChangeBadge */ "./js/components/ChangeBadge.js");
/* harmony import */ var _js_util__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/util */ "./js/util/index.js");
/* harmony import */ var _MetricTileWrapper__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./MetricTileWrapper */ "./js/components/KeyMetrics/MetricTileWrapper.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * MetricTileText component.
 *
 * Site Kit by Google, Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * Internal dependencies
 */




function MetricTileText({
  metricValue,
  metricValueFormat,
  subText,
  previousValue,
  currentValue,
  ...props
}) {
  const formatOptions = (0,_js_util__WEBPACK_IMPORTED_MODULE_1__.expandNumFmtOptions)(metricValueFormat);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)(_MetricTileWrapper__WEBPACK_IMPORTED_MODULE_2__["default"], {
    className: "googlesitekit-km-widget-tile--text",
    ...props,
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
      className: "googlesitekit-km-widget-tile__metric-container",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
        className: "googlesitekit-km-widget-tile__metric",
        children: metricValue
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("p", {
        className: "googlesitekit-km-widget-tile__subtext",
        children: subText
      })]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
      className: "googlesitekit-km-widget-tile__metric-change-container",
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_js_components_ChangeBadge__WEBPACK_IMPORTED_MODULE_0__["default"], {
        previousValue: previousValue,
        currentValue: currentValue,
        isAbsolute: formatOptions?.style === 'percent'
      })
    })]
  });
}
MetricTileText.propTypes = {
  metricValue: prop_types__WEBPACK_IMPORTED_MODULE_4___default().oneOfType([(prop_types__WEBPACK_IMPORTED_MODULE_4___default().string), (prop_types__WEBPACK_IMPORTED_MODULE_4___default().number)]),
  subtext: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().string),
  previousValue: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().number),
  currentValue: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().number)
};

/***/ }),

/***/ "./js/components/KeyMetrics/MetricTileWrapper.js":
/*!*******************************************************!*\
  !*** ./js/components/KeyMetrics/MetricTileWrapper.js ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ MetricTileWrapper)
/* harmony export */ });
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! lodash */ "../node_modules/lodash/lodash.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_14___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_14__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _key_metrics_widgets__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./key-metrics-widgets */ "./js/components/KeyMetrics/key-metrics-widgets.js");
/* harmony import */ var _GetHelpLink__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./GetHelpLink */ "./js/components/KeyMetrics/GetHelpLink.js");
/* harmony import */ var _MetricTileLoader__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./MetricTileLoader */ "./js/components/KeyMetrics/MetricTileLoader.js");
/* harmony import */ var _MetricTileError__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./MetricTileError */ "./js/components/KeyMetrics/MetricTileError.js");
/* harmony import */ var _MetricTileHeader__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./MetricTileHeader */ "./js/components/KeyMetrics/MetricTileHeader.js");
/* harmony import */ var _js_components_ReportErrorActions__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @/js/components/ReportErrorActions */ "./js/components/ReportErrorActions.js");
/* harmony import */ var _js_util_errors__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @/js/util/errors */ "./js/util/errors.js");
/* harmony import */ var _js_util__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @/js/util */ "./js/util/index.js");
/* harmony import */ var _js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @/js/hooks/useViewContext */ "./js/hooks/useViewContext.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * MetricTileWrapper component.
 *
 * Site Kit by Google, Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */




/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */










function MetricTileWrapper(props) {
  const {
    className,
    children,
    error,
    loading,
    moduleSlug,
    Widget,
    widgetSlug,
    title = _key_metrics_widgets__WEBPACK_IMPORTED_MODULE_3__.KEY_METRICS_WIDGETS[widgetSlug]?.title,
    infoTooltip = _key_metrics_widgets__WEBPACK_IMPORTED_MODULE_3__.KEY_METRICS_WIDGETS[widgetSlug]?.infoTooltip || _key_metrics_widgets__WEBPACK_IMPORTED_MODULE_3__.KEY_METRICS_WIDGETS[widgetSlug]?.description
  } = props;
  const viewContext = (0,_js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_11__["default"])();
  const hasInsufficientPermissionsReportError = error ? (0,lodash__WEBPACK_IMPORTED_MODULE_1__.castArray)(error).some(_js_util_errors__WEBPACK_IMPORTED_MODULE_9__.isInsufficientPermissionsError) : false;
  const trackRetryEvent = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_13__.useCallback)(() => {
    (0,_js_util__WEBPACK_IMPORTED_MODULE_10__.trackEvent)(`${viewContext}_kmw`, 'data_loading_error_retry');
  }, [viewContext]);
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_13__.useEffect)(() => {
    if (!!error) {
      (0,_js_util__WEBPACK_IMPORTED_MODULE_10__.trackEvent)(`${viewContext}_kmw`, 'data_loading_error');
    }
  }, [viewContext, error]);
  if (error) {
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx)(_MetricTileError__WEBPACK_IMPORTED_MODULE_6__["default"], {
      title: hasInsufficientPermissionsReportError ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Insufficient permissions', 'google-site-kit') : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Data loading failed', 'google-site-kit'),
      headerText: title,
      infoTooltip: infoTooltip,
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx)(_js_components_ReportErrorActions__WEBPACK_IMPORTED_MODULE_8__["default"], {
        moduleSlug: moduleSlug,
        error: error,
        onRetry: trackRetryEvent,
        GetHelpLink: hasInsufficientPermissionsReportError ? _GetHelpLink__WEBPACK_IMPORTED_MODULE_4__["default"] : undefined,
        getHelpClassName: "googlesitekit-error-retry-text"
      })
    });
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx)(Widget, {
    noPadding: true,
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsxs)("div", {
      className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-km-widget-tile', className),
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx)(_MetricTileHeader__WEBPACK_IMPORTED_MODULE_7__["default"], {
        title: title,
        infoTooltip: infoTooltip,
        loading: loading
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsxs)("div", {
        className: "googlesitekit-km-widget-tile__body",
        children: [loading && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx)(_MetricTileLoader__WEBPACK_IMPORTED_MODULE_5__["default"], {}), !loading && children]
      })]
    })
  });
}
MetricTileWrapper.propTypes = {
  Widget: (prop_types__WEBPACK_IMPORTED_MODULE_14___default().elementType).isRequired,
  loading: (prop_types__WEBPACK_IMPORTED_MODULE_14___default().bool),
  title: (prop_types__WEBPACK_IMPORTED_MODULE_14___default().string),
  infoTooltip: prop_types__WEBPACK_IMPORTED_MODULE_14___default().oneOfType([(prop_types__WEBPACK_IMPORTED_MODULE_14___default().string), (prop_types__WEBPACK_IMPORTED_MODULE_14___default().element)]),
  moduleSlug: (prop_types__WEBPACK_IMPORTED_MODULE_14___default().string).isRequired
};

/***/ }),

/***/ "./js/components/KeyMetrics/MetricsSelectionPanel/MetricItem.js":
/*!**********************************************************************!*\
  !*** ./js/components/KeyMetrics/MetricsSelectionPanel/MetricItem.js ***!
  \**********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ MetricItem)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_10__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _js_googlesitekit_datastore_forms_constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/googlesitekit/datastore/forms/constants */ "./js/googlesitekit/datastore/forms/constants.js");
/* harmony import */ var _js_googlesitekit_widgets_datastore_constants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/googlesitekit/widgets/datastore/constants */ "./js/googlesitekit/widgets/datastore/constants.js");
/* harmony import */ var _js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/googlesitekit/modules/datastore/constants */ "./js/googlesitekit/modules/datastore/constants.js");
/* harmony import */ var _js_components_KeyMetrics_constants__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/components/KeyMetrics/constants */ "./js/components/KeyMetrics/constants.js");
/* harmony import */ var _js_components_SelectionPanel__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @/js/components/SelectionPanel */ "./js/components/SelectionPanel/index.js");
/* harmony import */ var _js_hooks_useFormValue__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @/js/hooks/useFormValue */ "./js/hooks/useFormValue.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Key Metrics Selection Panel MetricItem
 *
 * Site Kit by Google, Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */








function MetricItem({
  slug,
  title,
  description,
  isNewlyDetected,
  savedItemSlugs = []
}) {
  const disconnectedModules = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => {
    const {
      getModule
    } = select(_js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_4__.CORE_MODULES);
    const widget = select(_js_googlesitekit_widgets_datastore_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_WIDGETS).getWidget(slug);
    return widget?.modules.reduce((modulesAcc, widgetSlug) => {
      const module = getModule(widgetSlug);
      if (module?.connected || !module?.name) {
        return modulesAcc;
      }
      return [...modulesAcc, module.name];
    }, []);
  });
  const selectedMetrics = (0,_js_hooks_useFormValue__WEBPACK_IMPORTED_MODULE_7__["default"])(_js_components_KeyMetrics_constants__WEBPACK_IMPORTED_MODULE_5__.KEY_METRICS_SELECTION_FORM, _js_components_KeyMetrics_constants__WEBPACK_IMPORTED_MODULE_5__.KEY_METRICS_SELECTED);
  const {
    getValue
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_datastore_forms_constants__WEBPACK_IMPORTED_MODULE_2__.CORE_FORMS));
  const {
    setValues
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useDispatch)(_js_googlesitekit_datastore_forms_constants__WEBPACK_IMPORTED_MODULE_2__.CORE_FORMS);
  const onCheckboxChange = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.useCallback)(event => {
    const metrics = getValue(_js_components_KeyMetrics_constants__WEBPACK_IMPORTED_MODULE_5__.KEY_METRICS_SELECTION_FORM, _js_components_KeyMetrics_constants__WEBPACK_IMPORTED_MODULE_5__.KEY_METRICS_SELECTED);
    const currentlySelectedMetrics = event.target.checked ? metrics.concat([slug]) : metrics.filter(selectedMetric => selectedMetric !== slug);
    setValues(_js_components_KeyMetrics_constants__WEBPACK_IMPORTED_MODULE_5__.KEY_METRICS_SELECTION_FORM, {
      [_js_components_KeyMetrics_constants__WEBPACK_IMPORTED_MODULE_5__.KEY_METRICS_SELECTED]: currentlySelectedMetrics,
      // Unstaged list creates a copy of KM selected list, but unstaged
      // is stored temporary to collect the final selection that will
      // be transfered over to effective selection on tab change and then it is reset.
      [_js_components_KeyMetrics_constants__WEBPACK_IMPORTED_MODULE_5__.UNSTAGED_SELECTION]: currentlySelectedMetrics
    });
  }, [getValue, setValues, slug]);
  const isMetricSelected = selectedMetrics?.includes(slug);
  const isMetricDisabled = !savedItemSlugs.includes(slug) && disconnectedModules.length > 0;
  const id = `key-metric-selection-checkbox-${slug}`;
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(_js_components_SelectionPanel__WEBPACK_IMPORTED_MODULE_6__.SelectionPanelItem, {
    id: id,
    slug: slug,
    title: title,
    description: description,
    isNewlyDetected: isNewlyDetected,
    isItemSelected: isMetricSelected,
    isItemDisabled: isMetricDisabled,
    onCheckboxChange: onCheckboxChange,
    children: disconnectedModules.length > 0 && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)("div", {
      className: "googlesitekit-selection-panel-item-error",
      children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.sprintf)(/* translators: %s: module names. */
      (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__._n)('%s is disconnected, no data to show', '%s are disconnected, no data to show', disconnectedModules.length, 'google-site-kit'), disconnectedModules.join((0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)(' and ', 'google-site-kit')))
    })
  });
}
MetricItem.propTypes = {
  slug: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().string).isRequired,
  title: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().string).isRequired,
  description: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().string).isRequired,
  isNewlyDetected: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().bool),
  savedItemSlugs: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().array)
};

/***/ }),

/***/ "./js/components/KeyMetrics/MetricsWidgetSubtitle.js":
/*!***********************************************************!*\
  !*** ./js/components/KeyMetrics/MetricsWidgetSubtitle.js ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ MetricsWidgetSubtitle)
/* harmony export */ });
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/googlesitekit/datastore/site/constants */ "./js/googlesitekit/datastore/site/constants.js");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * MetricsWidgetSubtitle component.
 *
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */



function MetricsWidgetSubtitle() {
  const isKeyMetricsSetupCompleted = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.useSelect)(select => select(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_1__.CORE_SITE).isKeyMetricsSetupCompleted());
  if (!isKeyMetricsSetupCompleted) {
    return null;
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_element__WEBPACK_IMPORTED_MODULE_4__.Fragment, {
    children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Track progress towards your goals with tailored metrics and important user interaction metrics', 'google-site-kit')
  });
}

/***/ }),

/***/ "./js/components/KeyMetrics/SetupCompletedSurveyTrigger.js":
/*!*****************************************************************!*\
  !*** ./js/components/KeyMetrics/SetupCompletedSurveyTrigger.js ***!
  \*****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ SetupCompletedSurveyTrigger)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/googlesitekit/datastore/site/constants */ "./js/googlesitekit/datastore/site/constants.js");
/* harmony import */ var _js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/googlesitekit/datastore/user/constants */ "./js/googlesitekit/datastore/user/constants.js");
/* harmony import */ var _js_util__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/util */ "./js/util/index.js");
/* harmony import */ var _js_components_surveys_SurveyViewTrigger__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/components/surveys/SurveyViewTrigger */ "./js/components/surveys/SurveyViewTrigger.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Key Metrics SetupCompletedSurveyTrigger component.
 *
 * Site Kit by Google, Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */






function SetupCompletedSurveyTrigger() {
  const isKeyMetricsSetupCompleted = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useSelect)(select => select(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_1__.CORE_SITE).isKeyMetricsSetupCompleted());
  const isKeyMetricsSetupCompletedBy = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useSelect)(select => select(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_1__.CORE_SITE).getKeyMetricsSetupCompletedBy());
  const currentUserID = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useSelect)(select => select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_2__.CORE_USER).getID());
  if (!isKeyMetricsSetupCompleted) {
    return null;
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)(_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.Fragment, {
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_js_components_surveys_SurveyViewTrigger__WEBPACK_IMPORTED_MODULE_4__["default"], {
      triggerID: "view_kmw",
      ttl: _js_util__WEBPACK_IMPORTED_MODULE_3__.WEEK_IN_SECONDS
    }), isKeyMetricsSetupCompletedBy === currentUserID && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_js_components_surveys_SurveyViewTrigger__WEBPACK_IMPORTED_MODULE_4__["default"], {
      triggerID: "view_kmw_setup_completed",
      ttl: _js_util__WEBPACK_IMPORTED_MODULE_3__.WEEK_IN_SECONDS
    })]
  });
}

/***/ }),

/***/ "./js/components/KeyMetrics/constants.js":
/*!***********************************************!*\
  !*** ./js/components/KeyMetrics/constants.js ***!
  \***********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   EFFECTIVE_SELECTION: () => (/* binding */ EFFECTIVE_SELECTION),
/* harmony export */   KEY_METRICS_GROUP_CONTENT_PERFORMANCE: () => (/* binding */ KEY_METRICS_GROUP_CONTENT_PERFORMANCE),
/* harmony export */   KEY_METRICS_GROUP_CURRENT: () => (/* binding */ KEY_METRICS_GROUP_CURRENT),
/* harmony export */   KEY_METRICS_GROUP_DRIVING_TRAFFIC: () => (/* binding */ KEY_METRICS_GROUP_DRIVING_TRAFFIC),
/* harmony export */   KEY_METRICS_GROUP_GENERATING_LEADS: () => (/* binding */ KEY_METRICS_GROUP_GENERATING_LEADS),
/* harmony export */   KEY_METRICS_GROUP_SELLING_PRODUCTS: () => (/* binding */ KEY_METRICS_GROUP_SELLING_PRODUCTS),
/* harmony export */   KEY_METRICS_GROUP_SUGGESTED: () => (/* binding */ KEY_METRICS_GROUP_SUGGESTED),
/* harmony export */   KEY_METRICS_GROUP_VISITORS: () => (/* binding */ KEY_METRICS_GROUP_VISITORS),
/* harmony export */   KEY_METRICS_SELECTED: () => (/* binding */ KEY_METRICS_SELECTED),
/* harmony export */   KEY_METRICS_SELECTION_FORM: () => (/* binding */ KEY_METRICS_SELECTION_FORM),
/* harmony export */   KEY_METRICS_SELECTION_PANEL_OPENED_KEY: () => (/* binding */ KEY_METRICS_SELECTION_PANEL_OPENED_KEY),
/* harmony export */   KEY_METRICS_SETUP_CTA_WIDGET_SLUG: () => (/* binding */ KEY_METRICS_SETUP_CTA_WIDGET_SLUG),
/* harmony export */   MAX_SELECTED_METRICS_COUNT: () => (/* binding */ MAX_SELECTED_METRICS_COUNT),
/* harmony export */   MIN_SELECTED_METRICS_COUNT: () => (/* binding */ MIN_SELECTED_METRICS_COUNT),
/* harmony export */   UNSTAGED_SELECTION: () => (/* binding */ UNSTAGED_SELECTION)
/* harmony export */ });
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/**
 * Key Metrics components - constants.
 *
 * Site Kit by Google, Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */

const KEY_METRICS_SETUP_CTA_WIDGET_SLUG = 'key-metrics-setup-cta-widget';
const KEY_METRICS_SELECTION_PANEL_OPENED_KEY = 'googlesitekit-key-metrics-selection-panel-opened';
const KEY_METRICS_SELECTION_FORM = 'key-metrics-selection-form';
const KEY_METRICS_SELECTED = 'key-metrics-selected';
const EFFECTIVE_SELECTION = 'key-metrics-effective-selection';
const UNSTAGED_SELECTION = 'key-metrics-unstaged-selection';
const MIN_SELECTED_METRICS_COUNT = 2;
const MAX_SELECTED_METRICS_COUNT = 8;
const KEY_METRICS_GROUP_CURRENT = {
  SLUG: 'current-selection',
  LABEL: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Current selection', 'google-site-kit')
};
const KEY_METRICS_GROUP_SUGGESTED = {
  SLUG: 'suggested',
  LABEL: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Suggested', 'google-site-kit')
};
const KEY_METRICS_GROUP_VISITORS = {
  SLUG: 'visitors',
  LABEL: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Visitors', 'google-site-kit')
};
const KEY_METRICS_GROUP_DRIVING_TRAFFIC = {
  SLUG: 'driving-traffic',
  LABEL: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Driving traffic', 'google-site-kit')
};
const KEY_METRICS_GROUP_GENERATING_LEADS = {
  SLUG: 'generating-leads',
  LABEL: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Generating leads', 'google-site-kit')
};
const KEY_METRICS_GROUP_SELLING_PRODUCTS = {
  SLUG: 'selling-products',
  LABEL: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Selling products', 'google-site-kit')
};
const KEY_METRICS_GROUP_CONTENT_PERFORMANCE = {
  SLUG: 'content-performance',
  LABEL: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Content performance', 'google-site-kit')
};

/***/ }),

/***/ "./js/components/KeyMetrics/hooks/useChangeMetricsFeatureTourEffect.js":
/*!*****************************************************************************!*\
  !*** ./js/components/KeyMetrics/hooks/useChangeMetricsFeatureTourEffect.js ***!
  \*****************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   useChangeMetricsFeatureTourEffect: () => (/* binding */ useChangeMetricsFeatureTourEffect)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/googlesitekit/datastore/site/constants */ "./js/googlesitekit/datastore/site/constants.js");
/* harmony import */ var _js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/googlesitekit/datastore/user/constants */ "./js/googlesitekit/datastore/user/constants.js");
/* harmony import */ var _js_feature_tours_shared_key_metrics__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/feature-tours/shared-key-metrics */ "./js/feature-tours/shared-key-metrics.js");
/**
 * Change metrics feature tour hook.
 *
 * Site Kit by Google, Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * Internal dependencies
 */





/**
 * Triggers on demand tour for shared key metrics if all conditions are met.
 *
 * @since 1.113.0
 *
 * @param {Object}  options                        Options object.
 * @param {boolean} options.renderChangeMetricLink If metric link meets the conditions to render.
 */
function useChangeMetricsFeatureTourEffect({
  renderChangeMetricLink
}) {
  const keyMetricsSetupCompletedBy = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useSelect)(select => select(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_1__.CORE_SITE).getKeyMetricsSetupCompletedBy());
  const currentUserID = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useSelect)(select => select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_2__.CORE_USER).getID());
  const {
    triggerOnDemandTour
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useDispatch)(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_2__.CORE_USER);
  const isUserEligibleForTour = Number.isInteger(keyMetricsSetupCompletedBy) && Number.isInteger(currentUserID) && keyMetricsSetupCompletedBy > 0 && currentUserID !== keyMetricsSetupCompletedBy;
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_4__.useEffect)(() => {
    if (renderChangeMetricLink && isUserEligibleForTour) {
      triggerOnDemandTour(_js_feature_tours_shared_key_metrics__WEBPACK_IMPORTED_MODULE_3__["default"]);
    }
  }, [renderChangeMetricLink, isUserEligibleForTour, triggerOnDemandTour]);
}

/***/ }),

/***/ "./js/components/KeyMetrics/hooks/useCurrentlyActiveEvents.js":
/*!********************************************************************!*\
  !*** ./js/components/KeyMetrics/hooks/useCurrentlyActiveEvents.js ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ useCurrentlyActiveEvents)
/* harmony export */ });
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/googlesitekit/datastore/user/constants */ "./js/googlesitekit/datastore/user/constants.js");
/* harmony import */ var _js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/modules/analytics-4/datastore/constants */ "./js/modules/analytics-4/datastore/constants.js");
/**
 * The useCurrentlyActiveEvents hook.
 *
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Internal dependencies
 */




/**
 * Gets the list of currently active conversion events based on user selection
 * or user input settings.
 *
 * @since 1.163.0
 *
 * @return {Array<string>|undefined} List of currently active conversion events.
 */
function useCurrentlyActiveEvents() {
  return (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useSelect)(select => {
    const userPickedMetrics = select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_1__.CORE_USER).getUserPickedMetrics();
    if (userPickedMetrics?.length) {
      // Safe to access without GA4 connection; no network request.
      const keyMetricsConversionEventWidgets = select(_js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_2__.MODULES_ANALYTICS_4).getKeyMetricsConversionEventWidgets();
      return Object.keys(keyMetricsConversionEventWidgets).filter(event => userPickedMetrics.some(metric => keyMetricsConversionEventWidgets[event].includes(metric)));
    }
    const userInputSettings = select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_1__.CORE_USER).getUserInputSettings();
    return userInputSettings?.includeConversionEvents?.values;
  });
}

/***/ }),

/***/ "./js/components/KeyMetrics/hooks/useDisplayCTAWidget.js":
/*!***************************************************************!*\
  !*** ./js/components/KeyMetrics/hooks/useDisplayCTAWidget.js ***!
  \***************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ useDisplayCTAWidget)
/* harmony export */ });
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/googlesitekit/modules/datastore/constants */ "./js/googlesitekit/modules/datastore/constants.js");
/* harmony import */ var _js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/googlesitekit/datastore/user/constants */ "./js/googlesitekit/datastore/user/constants.js");
/* harmony import */ var _js_components_KeyMetrics_constants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/components/KeyMetrics/constants */ "./js/components/KeyMetrics/constants.js");
/* harmony import */ var _js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/modules/analytics-4/datastore/constants */ "./js/modules/analytics-4/datastore/constants.js");
/* harmony import */ var _js_modules_analytics_4_constants__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/modules/analytics-4/constants */ "./js/modules/analytics-4/constants.js");
/* harmony import */ var _js_modules_search_console_datastore_constants__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @/js/modules/search-console/datastore/constants */ "./js/modules/search-console/datastore/constants.js");
/* harmony import */ var _js_modules_search_console_constants__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @/js/modules/search-console/constants */ "./js/modules/search-console/constants.js");
/**
 * Determines whether the CTA widget should be displayed.
 *
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Internal dependencies
 */









/**
 * Determines whether the CTA widget should be displayed.
 *
 * @since 1.140.0
 *
 * @return {boolean} Whether the CTA widget should be displayed.
 */
function useDisplayCTAWidget() {
  return (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useSelect)(select => {
    const isDismissed = select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_2__.CORE_USER).isItemDismissed(_js_components_KeyMetrics_constants__WEBPACK_IMPORTED_MODULE_3__.KEY_METRICS_SETUP_CTA_WIDGET_SLUG);
    const isDismissingItem = select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_2__.CORE_USER).isDismissingItem(_js_components_KeyMetrics_constants__WEBPACK_IMPORTED_MODULE_3__.KEY_METRICS_SETUP_CTA_WIDGET_SLUG);

    // We call isGatheringData() within this hook for completeness as we do not want to rely
    // on it being called in other components. This selector makes report requests which, if they return
    // data, then the `data-available` transients are set. These transients are prefetched as a global on
    // the next page load.

    const searchConsoleDataAvailableOnLoad = isModuleDataAvailableOnLoad(select, _js_modules_search_console_constants__WEBPACK_IMPORTED_MODULE_7__.MODULE_SLUG_SEARCH_CONSOLE, _js_modules_search_console_datastore_constants__WEBPACK_IMPORTED_MODULE_6__.MODULES_SEARCH_CONSOLE);
    const analyticsDataAvailableOnLoad = isModuleDataAvailableOnLoad(select, _js_modules_analytics_4_constants__WEBPACK_IMPORTED_MODULE_5__.MODULE_SLUG_ANALYTICS_4, _js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_4__.MODULES_ANALYTICS_4);
    return isDismissed === false && isDismissingItem === false && searchConsoleDataAvailableOnLoad && analyticsDataAvailableOnLoad;
  }, []);
}
function isModuleDataAvailableOnLoad(select, slug, storeName) {
  if (select(_js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_1__.CORE_MODULES).isModuleConnected(slug)) {
    const {
      isGatheringData,
      isDataAvailableOnLoad
    } = select(storeName);
    isGatheringData();
    return isDataAvailableOnLoad();
  }
  return false;
}

/***/ }),

/***/ "./js/components/KeyMetrics/hooks/useFilteredKeyMetrics.js":
/*!*****************************************************************!*\
  !*** ./js/components/KeyMetrics/hooks/useFilteredKeyMetrics.js ***!
  \*****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ useFilteredKeyMetrics)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _js_components_KeyMetrics_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @/js/components/KeyMetrics/constants */ "./js/components/KeyMetrics/constants.js");
/**
 * The useFilteredKeyMetrics hook.
 *
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */


/**
 * Filters and aggregates key metrics for the active group.
 *
 * @since 1.163.0
 *
 * @param {Object} args                                 Arguments.
 * @param {Object} args.allMetricItems                  All metric items keyed by slug.
 * @param {string} args.isActive                        Active group slug.
 * @param {Array}  args.effectiveSelection              Effective selection list.
 * @param {Array}  args.answerBasedMetrics              Tailored metrics for suggested group.
 * @param {Array}  args.selectedMetrics                 Currently selected metrics.
 * @param {Array}  args.newBadgeEvents                  Events that should show the "New" badge.
 * @param {Object} args.conversionReportingEventWidgets Mapping of event => [metric slugs].
 * @return {Object}                                     Object with `selectedCounts`, `activeMetricItems`, and `newlyDetectedMetrics`.
 */
function useFilteredKeyMetrics({
  allMetricItems = {},
  isActive,
  effectiveSelection = [],
  answerBasedMetrics = [],
  selectedMetrics = [],
  newBadgeEvents = [],
  conversionReportingEventWidgets = {}
}) {
  return (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useMemo)(() => {
    // Currently selected group does not include total selected number, so it will always be 0.
    const selectedCounts = {
      [_js_components_KeyMetrics_constants__WEBPACK_IMPORTED_MODULE_0__.KEY_METRICS_GROUP_CURRENT.SLUG]: 0
    };
    const activeMetricItems = {};
    const newlyDetectedMetrics = {};
    for (const metricItemSlug in allMetricItems) {
      const metricGroup = allMetricItems[metricItemSlug].group;
      if (metricGroup === isActive || isActive === _js_components_KeyMetrics_constants__WEBPACK_IMPORTED_MODULE_0__.KEY_METRICS_GROUP_CURRENT.SLUG && effectiveSelection.includes(metricItemSlug)) {
        activeMetricItems[metricItemSlug] = allMetricItems[metricItemSlug];
      }
      if (isActive === _js_components_KeyMetrics_constants__WEBPACK_IMPORTED_MODULE_0__.KEY_METRICS_GROUP_SUGGESTED.SLUG && answerBasedMetrics.includes(metricItemSlug)) {
        if (answerBasedMetrics.includes(metricItemSlug)) {
          activeMetricItems[metricItemSlug] = allMetricItems[metricItemSlug];
        }
      }
      if (!selectedCounts[metricGroup]) {
        const selectedCount = Object.keys(allMetricItems).filter(slug => {
          // Check if metric slug is in selectedMetrics, so the group count is reflected in real time as metrics are checked/unchecked.
          if (allMetricItems[slug].group === metricGroup && selectedMetrics?.includes(slug)) {
            return true;
          }
          return false;
        }).length;
        selectedCounts[metricGroup] = selectedCount;
      }

      // Check if metric is conversion event related and if new badge should be included.
      if (newBadgeEvents?.length) {
        const isNewlyDetectedKeyMetrics = newBadgeEvents.some(conversionEvent => conversionReportingEventWidgets[conversionEvent].includes(metricItemSlug));
        if (isNewlyDetectedKeyMetrics) {
          var _newlyDetectedMetrics;
          newlyDetectedMetrics[metricGroup] = [...((_newlyDetectedMetrics = newlyDetectedMetrics[metricGroup]) !== null && _newlyDetectedMetrics !== void 0 ? _newlyDetectedMetrics : []), metricItemSlug];
        }
      }
    }
    return {
      selectedCounts,
      activeMetricItems,
      newlyDetectedMetrics
    };
  }, [allMetricItems, isActive, effectiveSelection, answerBasedMetrics, selectedMetrics, newBadgeEvents, conversionReportingEventWidgets]);
}

/***/ }),

/***/ "./js/components/KeyMetrics/hooks/useKeyMetricsGroups.js":
/*!***************************************************************!*\
  !*** ./js/components/KeyMetrics/hooks/useKeyMetricsGroups.js ***!
  \***************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ useKeyMetricsGroups)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @/js/modules/analytics-4/datastore/constants */ "./js/modules/analytics-4/datastore/constants.js");
/* harmony import */ var _js_components_KeyMetrics_constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/components/KeyMetrics/constants */ "./js/components/KeyMetrics/constants.js");
/**
 * The useKeyMetricsGroups hook.
 *
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */



/**
 * Computes the key metrics groups and supporting flags for tailoring.
 *
 * @since 1.163.0
 *
 * @param {Object}  args                       Arguments.
 * @param {Array}   args.detectedEvents        Detected GA4 events.
 * @param {Array}   args.currentlyActiveEvents Currently active events from settings/user picks.
 * @param {boolean} args.isUserInputCompleted  Whether user input is completed.
 * @param {Array}   args.answerBasedMetrics    Tailored metrics based on answers/events.
 * @return {Object}                            Object with `hasGeneratingLeadsGroup`, `hasSellingProductsGroup`, `keyMetricsGroups`, and `dynamicGroups`.
 */
function useKeyMetricsGroups({
  detectedEvents = [],
  currentlyActiveEvents = [],
  isUserInputCompleted,
  answerBasedMetrics = []
}) {
  const hasGeneratingLeadsGroup = [_js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_0__.ENUM_CONVERSION_EVENTS.SUBMIT_LEAD_FORM, _js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_0__.ENUM_CONVERSION_EVENTS.CONTACT, _js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_0__.ENUM_CONVERSION_EVENTS.GENERATE_LEAD].filter(item => detectedEvents?.includes(item) || currentlyActiveEvents?.includes(item));
  const hasSellingProductsGroup = [_js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_0__.ENUM_CONVERSION_EVENTS.ADD_TO_CART, _js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_0__.ENUM_CONVERSION_EVENTS.PURCHASE].filter(item => detectedEvents?.includes(item) || currentlyActiveEvents?.includes(item));
  const keyMetricsGroups = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useMemo)(() => {
    return [_js_components_KeyMetrics_constants__WEBPACK_IMPORTED_MODULE_1__.KEY_METRICS_GROUP_VISITORS, _js_components_KeyMetrics_constants__WEBPACK_IMPORTED_MODULE_1__.KEY_METRICS_GROUP_DRIVING_TRAFFIC, ...(hasGeneratingLeadsGroup?.length ? [_js_components_KeyMetrics_constants__WEBPACK_IMPORTED_MODULE_1__.KEY_METRICS_GROUP_GENERATING_LEADS] : []), ...(hasSellingProductsGroup?.length ? [_js_components_KeyMetrics_constants__WEBPACK_IMPORTED_MODULE_1__.KEY_METRICS_GROUP_SELLING_PRODUCTS] : []), _js_components_KeyMetrics_constants__WEBPACK_IMPORTED_MODULE_1__.KEY_METRICS_GROUP_CONTENT_PERFORMANCE];
  }, [hasGeneratingLeadsGroup, hasSellingProductsGroup]);
  const dynamicGroups = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useMemo)(() => {
    if (isUserInputCompleted && answerBasedMetrics?.length) {
      return [_js_components_KeyMetrics_constants__WEBPACK_IMPORTED_MODULE_1__.KEY_METRICS_GROUP_CURRENT, _js_components_KeyMetrics_constants__WEBPACK_IMPORTED_MODULE_1__.KEY_METRICS_GROUP_SUGGESTED];
    }
    return [_js_components_KeyMetrics_constants__WEBPACK_IMPORTED_MODULE_1__.KEY_METRICS_GROUP_CURRENT];
  }, [isUserInputCompleted, answerBasedMetrics]);
  return {
    hasGeneratingLeadsGroup,
    hasSellingProductsGroup,
    keyMetricsGroups,
    dynamicGroups
  };
}

/***/ }),

/***/ "./js/components/KeyMetrics/hooks/useNewBadgeEvents.js":
/*!*************************************************************!*\
  !*** ./js/components/KeyMetrics/hooks/useNewBadgeEvents.js ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ useNewBadgeEvents)
/* harmony export */ });
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/googlesitekit/modules/datastore/constants */ "./js/googlesitekit/modules/datastore/constants.js");
/* harmony import */ var _js_modules_analytics_4_constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/modules/analytics-4/constants */ "./js/modules/analytics-4/constants.js");
/* harmony import */ var _js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/modules/analytics-4/datastore/constants */ "./js/modules/analytics-4/datastore/constants.js");
/**
 * UseNewBadgeEvents hook.
 *
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Internal dependencies
 */





/**
 * Returns the list of conversion events for which the "New" badge should be shown.
 *
 * Mirrors the logic previously in ChipTabGroup for computing `newBadgeEvents`.
 *
 * @since 1.163.0
 *
 * @return {Array<string>} List of events for which to show the "New" badge.
 */
function useNewBadgeEvents() {
  return (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useSelect)(select => {
    const isGA4Connected = select(_js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_1__.CORE_MODULES).isModuleConnected(_js_modules_analytics_4_constants__WEBPACK_IMPORTED_MODULE_2__.MODULE_SLUG_ANALYTICS_4);
    if (!isGA4Connected) {
      return [];
    }
    const detectedEvents = select(_js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_3__.MODULES_ANALYTICS_4).getDetectedEvents();
    const badgeEvents = select(_js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_3__.MODULES_ANALYTICS_4).getNewBadgeEvents();
    if (detectedEvents?.length && badgeEvents?.length) {
      const detectedLeadEvents = detectedEvents.filter(event => _js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_3__.CONVERSION_REPORTING_LEAD_EVENTS.includes(event));
      const newLeadEvents = badgeEvents.filter(event => _js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_3__.CONVERSION_REPORTING_LEAD_EVENTS.includes(event));
      const newNonLeadEvents = badgeEvents.filter(event => !_js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_3__.CONVERSION_REPORTING_LEAD_EVENTS.includes(event));
      if (detectedLeadEvents?.length > 1 && newLeadEvents.length > 0) {
        return newNonLeadEvents;
      }
    }
    return badgeEvents;
  });
}

/***/ }),

/***/ "./js/components/KeyMetrics/hooks/useOverflowingTabs.js":
/*!**************************************************************!*\
  !*** ./js/components/KeyMetrics/hooks/useOverflowingTabs.js ***!
  \**************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ useOverflowingTabs)
/* harmony export */ });
/* harmony import */ var react_use__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react-use */ "../node_modules/react-use/esm/useEvent.js");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _js_hooks_useDebounce__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @/js/hooks/useDebounce */ "./js/hooks/useDebounce.js");
/**
 * The useOverflowingTabs hook.
 *
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */


/**
 * Ensures that on small screens the last tab is visually cut off to imply
 * scroll, and wires up resize handling and open transitions.
 *
 * @since 1.163.0
 *
 * @param {Object}  args                              Arguments.
 * @param {Object}  args.containerRef                 Ref to the container element.
 * @param {boolean} args.isMobileBreakpoint           Whether current breakpoint is small.
 * @param {boolean} args.isSelectionPanelOpen         Current open state for selection panel.
 * @param {boolean} args.isSelectionPanelOpenPrevious Previous open state for selection panel.
 */
function useOverflowingTabs({
  containerRef,
  isMobileBreakpoint,
  isSelectionPanelOpen,
  isSelectionPanelOpenPrevious
}) {
  // It is not always clear that tabs are scrollable on mobile, so we need to ensure that the last tab item
  // is cutoff to indicate that there are more tabs to scroll to.
  const maybeCutOffLastTabItem = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useCallback)(() => {
    const scrollContainer = containerRef.current?.querySelector('.mdc-tab-scroller__scroll-content');
    if (!isMobileBreakpoint) {
      return;
    }
    const tabItems = containerRef.current?.querySelectorAll('.googlesitekit-chip-tab-group__tab-items .mdc-tab');
    if (!tabItems?.length || !scrollContainer) {
      return;
    }
    const containerRect = containerRef.current?.getBoundingClientRect();
    const visibleItems = [];
    tabItems.forEach((tabItem, index) => {
      const tabItemRect = tabItem.getBoundingClientRect();
      if (tabItemRect.left >= containerRect.left && tabItemRect.right <= containerRect.right) {
        visibleItems.push(index);
      }
    });
    const nextTabItem = tabItems[visibleItems.length];
    if (!nextTabItem) {
      return;
    }
    const nextTabItemRect = nextTabItem.getBoundingClientRect();

    // If the next tab item is either completely off-screen or only barely
    // visible (i.e. cut off by 15px or less, meaning most likely it is still
    // outside the visible area), reduce the column gap so that the last tab
    // item appears properly truncated.
    if (nextTabItemRect.left >= containerRect.right || nextTabItemRect.left - containerRect.right < 0 && -(nextTabItemRect.left - containerRect.right) <= 20) {
      // If there is an inline gap of 2px we already adjusted it once, and
      // the last item is still not cut off, we need to adjust the column
      // gap to 20px to ensure the last item is cut off.
      if (scrollContainer.style.columnGap === '2px') {
        scrollContainer.style.columnGap = '20px';
      } else {
        scrollContainer.style.columnGap = '2px';
      }
      maybeCutOffLastTabItem();
    }
  }, [containerRef, isMobileBreakpoint]);

  // Debounce the maybeCutOffLastTabItem function
  const debouncedMaybeCutOffLastTabItem = (0,_js_hooks_useDebounce__WEBPACK_IMPORTED_MODULE_0__.useDebounce)(maybeCutOffLastTabItem, 50);
  (0,react_use__WEBPACK_IMPORTED_MODULE_2__["default"])('resize', debouncedMaybeCutOffLastTabItem);
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useEffect)(() => {
    if (!isSelectionPanelOpenPrevious && isSelectionPanelOpen) {
      maybeCutOffLastTabItem();
    }
  }, [isSelectionPanelOpen, isSelectionPanelOpenPrevious, maybeCutOffLastTabItem]);
}

/***/ }),

/***/ "./js/components/KeyMetrics/index.js":
/*!*******************************************!*\
  !*** ./js/components/KeyMetrics/index.js ***!
  \*******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ChangeMetricsLink: () => (/* reexport safe */ _ChangeMetricsLink__WEBPACK_IMPORTED_MODULE_0__["default"]),
/* harmony export */   ChipTabGroup: () => (/* reexport safe */ _ChipTabGroup__WEBPACK_IMPORTED_MODULE_8__["default"]),
/* harmony export */   InsufficientPermissionsError: () => (/* reexport safe */ _InsufficientPermissionsError__WEBPACK_IMPORTED_MODULE_1__["default"]),
/* harmony export */   KeyMetricsSetupCTAWidget: () => (/* reexport safe */ _KeyMetricsSetupCTAWidget__WEBPACK_IMPORTED_MODULE_2__["default"]),
/* harmony export */   MetricTileNumeric: () => (/* reexport safe */ _MetricTileNumeric__WEBPACK_IMPORTED_MODULE_3__["default"]),
/* harmony export */   MetricTileTable: () => (/* reexport safe */ _MetricTileTable__WEBPACK_IMPORTED_MODULE_4__["default"]),
/* harmony export */   MetricTileTablePlainText: () => (/* reexport safe */ _MetricTileTablePlainText__WEBPACK_IMPORTED_MODULE_5__["default"]),
/* harmony export */   MetricTileText: () => (/* reexport safe */ _MetricTileText__WEBPACK_IMPORTED_MODULE_6__["default"]),
/* harmony export */   MetricTileWrapper: () => (/* reexport safe */ _MetricTileWrapper__WEBPACK_IMPORTED_MODULE_7__["default"])
/* harmony export */ });
/* harmony import */ var _ChangeMetricsLink__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./ChangeMetricsLink */ "./js/components/KeyMetrics/ChangeMetricsLink.js");
/* harmony import */ var _InsufficientPermissionsError__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./InsufficientPermissionsError */ "./js/components/KeyMetrics/InsufficientPermissionsError.js");
/* harmony import */ var _KeyMetricsSetupCTAWidget__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./KeyMetricsSetupCTAWidget */ "./js/components/KeyMetrics/KeyMetricsSetupCTAWidget.js");
/* harmony import */ var _MetricTileNumeric__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./MetricTileNumeric */ "./js/components/KeyMetrics/MetricTileNumeric.js");
/* harmony import */ var _MetricTileTable__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./MetricTileTable */ "./js/components/KeyMetrics/MetricTileTable.js");
/* harmony import */ var _MetricTileTablePlainText__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./MetricTileTablePlainText */ "./js/components/KeyMetrics/MetricTileTablePlainText.js");
/* harmony import */ var _MetricTileText__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./MetricTileText */ "./js/components/KeyMetrics/MetricTileText.js");
/* harmony import */ var _MetricTileWrapper__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./MetricTileWrapper */ "./js/components/KeyMetrics/MetricTileWrapper.js");
/* harmony import */ var _ChipTabGroup__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./ChipTabGroup */ "./js/components/KeyMetrics/ChipTabGroup/index.js");
/**
 * Site Kit by Google, Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */











/***/ }),

/***/ "./js/components/KeyMetrics/key-metrics-widgets.js":
/*!*********************************************************!*\
  !*** ./js/components/KeyMetrics/key-metrics-widgets.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   KEY_METRICS_WIDGETS: () => (/* binding */ KEY_METRICS_WIDGETS)
/* harmony export */ });
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/googlesitekit/datastore/user/constants */ "./js/googlesitekit/datastore/user/constants.js");
/* harmony import */ var _js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/googlesitekit/datastore/site/constants */ "./js/googlesitekit/datastore/site/constants.js");
/* harmony import */ var _js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/modules/analytics-4/datastore/constants */ "./js/modules/analytics-4/datastore/constants.js");
/* harmony import */ var _shouldDisplayWidgetWithConversionEvent__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./shouldDisplayWidgetWithConversionEvent */ "./js/components/KeyMetrics/shouldDisplayWidgetWithConversionEvent.js");
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./constants */ "./js/components/KeyMetrics/constants.js");
/**
 * Key Metrics widgets metadata.
 *
 * Site Kit by Google, Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */






/**
 * Determines whether to show a widget the requires Analytics 4 and AdSense to be linked.
 *
 * For admin dashboards, the widget will be shown if both modules are activate so that
 * the connection CTA can be shown if they have not been linked.
 *
 * For view-only dashboards, the widget will only be displayed if both modules are linked.
 *
 * @since 1.121.0
 *
 * @param {Object}   options                     Options object.
 * @param {Function} options.select              Data store select function.
 * @param {boolean}  options.isViewOnlyDashboard Whether the current dashboard is view only.
 * @return {boolean} Whether to display the widget.
 */
function shouldDisplayWidgetWithAnalytics4AndAdSenseLinked({
  select,
  isViewOnlyDashboard
}) {
  if (!isViewOnlyDashboard) {
    return true;
  }
  if (isViewOnlyDashboard && select(_js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_3__.MODULES_ANALYTICS_4).getAdSenseLinked()) {
    return true;
  }
  return false;
}

/**
 * Determines whether to display a widget that requires custom dimensions in the key
 * metrics selection panel.
 *
 * All widgets are displayed in authenticated dashboard. However, in view only dashboard,
 * widgets that require custom dimensions will only be displayed if the required custom
 * dimensions are available in the shared property.
 *
 * This function is attached to the widget object that requires the custom dimensions and
 * has the `requiredCustomDimensions` property.
 *
 * @since 1.113.0
 *
 * @param {Object}   options                     Options object.
 * @param {Function} options.select              Data store select function.
 * @param {boolean}  options.isViewOnlyDashboard Whether the current dashboard is view only.
 * @return {boolean} Whether to display the widget.
 */
function shouldDisplayWidgetWithCustomDimensions({
  select,
  isViewOnlyDashboard
}) {
  if (!isViewOnlyDashboard) {
    return true;
  }
  return select(_js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_3__.MODULES_ANALYTICS_4).hasCustomDimensions(
  // This property is available to the widget object that requires the
  // custom dimensions, where the function is attached.
  this.requiredCustomDimensions);
}
const KEY_METRICS_WIDGETS = {
  [_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_1__.KM_ANALYTICS_ADSENSE_TOP_EARNING_CONTENT]: {
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Top earning pages', 'google-site-kit'),
    description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Pages that generated the most AdSense revenue', 'google-site-kit'),
    infoTooltip: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Pages that generated the most AdSense revenue', 'google-site-kit'),
    displayInSelectionPanel: shouldDisplayWidgetWithAnalytics4AndAdSenseLinked,
    displayInList: shouldDisplayWidgetWithAnalytics4AndAdSenseLinked,
    metadata: {
      group: _constants__WEBPACK_IMPORTED_MODULE_5__.KEY_METRICS_GROUP_CONTENT_PERFORMANCE.SLUG
    }
  },
  [_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_1__.KM_ANALYTICS_TOP_RECENT_TRENDING_PAGES]: {
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Top recent trending pages', 'google-site-kit'),
    description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Pages with the most pageviews published in the last 3 days', 'google-site-kit'),
    infoTooltip: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Pages with the most pageviews published in the last 3 days', 'google-site-kit'),
    requiredCustomDimensions: ['googlesitekit_post_date'],
    displayInSelectionPanel: shouldDisplayWidgetWithCustomDimensions,
    displayInWidgetArea: shouldDisplayWidgetWithCustomDimensions,
    displayInList: shouldDisplayWidgetWithCustomDimensions,
    metadata: {
      group: _constants__WEBPACK_IMPORTED_MODULE_5__.KEY_METRICS_GROUP_CONTENT_PERFORMANCE.SLUG
    }
  },
  [_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_1__.KM_ANALYTICS_POPULAR_AUTHORS]: {
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Most popular authors by pageviews', 'google-site-kit'),
    description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Authors whose posts got the most visits', 'google-site-kit'),
    infoTooltip: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Authors whose posts got the most visits', 'google-site-kit'),
    requiredCustomDimensions: ['googlesitekit_post_author'],
    displayInSelectionPanel: shouldDisplayWidgetWithCustomDimensions,
    displayInWidgetArea: shouldDisplayWidgetWithCustomDimensions,
    displayInList: shouldDisplayWidgetWithCustomDimensions,
    metadata: {
      group: _constants__WEBPACK_IMPORTED_MODULE_5__.KEY_METRICS_GROUP_CONTENT_PERFORMANCE.SLUG
    }
  },
  [_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_1__.KM_ANALYTICS_TOP_CATEGORIES]: {
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Top categories by pageviews', 'google-site-kit'),
    description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Categories that your site visitors viewed the most', 'google-site-kit'),
    infoTooltip: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Categories that your site visitors viewed the most', 'google-site-kit'),
    requiredCustomDimensions: ['googlesitekit_post_categories'],
    displayInSelectionPanel: shouldDisplayWidgetWithCustomDimensions,
    displayInWidgetArea: shouldDisplayWidgetWithCustomDimensions,
    displayInList: shouldDisplayWidgetWithCustomDimensions,
    metadata: {
      group: _constants__WEBPACK_IMPORTED_MODULE_5__.KEY_METRICS_GROUP_CONTENT_PERFORMANCE.SLUG
    }
  },
  [_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_1__.KM_ANALYTICS_POPULAR_CONTENT]: {
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Most popular content by pageviews', 'google-site-kit'),
    description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Pages that brought in the most visitors', 'google-site-kit'),
    infoTooltip: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Pages your visitors read the most', 'google-site-kit'),
    metadata: {
      group: _constants__WEBPACK_IMPORTED_MODULE_5__.KEY_METRICS_GROUP_CONTENT_PERFORMANCE.SLUG
    }
  },
  [_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_1__.KM_ANALYTICS_POPULAR_PRODUCTS]: {
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Most popular products by pageviews', 'google-site-kit'),
    description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Products that brought in the most visitors', 'google-site-kit'),
    requiredCustomDimensions: ['googlesitekit_post_type'],
    displayInSelectionPanel: ({
      select
    }) => select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_1__.CORE_USER).isKeyMetricActive(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_1__.KM_ANALYTICS_POPULAR_PRODUCTS) || select(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_2__.CORE_SITE).getProductPostType(),
    displayInWidgetArea: shouldDisplayWidgetWithCustomDimensions,
    metadata: {
      group: _constants__WEBPACK_IMPORTED_MODULE_5__.KEY_METRICS_GROUP_SELLING_PRODUCTS.SLUG
    }
  },
  [_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_1__.KM_ANALYTICS_PAGES_PER_VISIT]: {
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Pages per visit', 'google-site-kit'),
    description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Number of pages visitors viewed per session on average', 'google-site-kit'),
    infoTooltip: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Number of pages visitors viewed per session on average', 'google-site-kit'),
    metadata: {
      group: _constants__WEBPACK_IMPORTED_MODULE_5__.KEY_METRICS_GROUP_VISITORS.SLUG
    }
  },
  [_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_1__.KM_ANALYTICS_VISIT_LENGTH]: {
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Visit length', 'google-site-kit'),
    description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Average duration of engaged visits', 'google-site-kit'),
    infoTooltip: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Average duration of engaged visits', 'google-site-kit'),
    metadata: {
      group: _constants__WEBPACK_IMPORTED_MODULE_5__.KEY_METRICS_GROUP_VISITORS.SLUG
    }
  },
  [_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_1__.KM_ANALYTICS_VISITS_PER_VISITOR]: {
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Visits per visitor', 'google-site-kit'),
    description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Average number of sessions per site visitor', 'google-site-kit'),
    infoTooltip: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Average number of sessions per site visitor', 'google-site-kit'),
    metadata: {
      group: _constants__WEBPACK_IMPORTED_MODULE_5__.KEY_METRICS_GROUP_VISITORS.SLUG
    }
  },
  [_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_1__.KM_ANALYTICS_MOST_ENGAGING_PAGES]: {
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Most engaging pages', 'google-site-kit'),
    description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Pages with the highest engagement rate', 'google-site-kit'),
    infoTooltip: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Pages with the highest engagement rate', 'google-site-kit'),
    metadata: {
      group: _constants__WEBPACK_IMPORTED_MODULE_5__.KEY_METRICS_GROUP_CONTENT_PERFORMANCE.SLUG
    }
  },
  [_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_1__.KM_ANALYTICS_LEAST_ENGAGING_PAGES]: {
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Least engaging pages', 'google-site-kit'),
    description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Pages with the highest percentage of visitors that left without engagement with your site', 'google-site-kit'),
    infoTooltip: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Percentage of visitors that left without engagement with your site', 'google-site-kit'),
    metadata: {
      group: _constants__WEBPACK_IMPORTED_MODULE_5__.KEY_METRICS_GROUP_CONTENT_PERFORMANCE.SLUG
    }
  },
  [_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_1__.KM_ANALYTICS_TOP_RETURNING_VISITOR_PAGES]: {
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Top pages by returning visitors', 'google-site-kit'),
    description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Pages that attracted the most returning visitors', 'google-site-kit'),
    infoTooltip: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Pages that attracted the most returning visitors', 'google-site-kit'),
    metadata: {
      group: _constants__WEBPACK_IMPORTED_MODULE_5__.KEY_METRICS_GROUP_VISITORS.SLUG
    }
  },
  [_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_1__.KM_ANALYTICS_NEW_VISITORS]: {
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('New visitors', 'google-site-kit'),
    description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('How many new visitors you got and how the overall audience changed', 'google-site-kit'),
    infoTooltip: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Portion of visitors who visited your site for the first time in this timeframe', 'google-site-kit'),
    metadata: {
      group: _constants__WEBPACK_IMPORTED_MODULE_5__.KEY_METRICS_GROUP_VISITORS.SLUG
    }
  },
  [_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_1__.KM_ANALYTICS_RETURNING_VISITORS]: {
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Returning visitors', 'google-site-kit'),
    description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Portion of people who visited your site more than once', 'google-site-kit'),
    infoTooltip: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Portion of your site’s visitors that returned at least once in this timeframe', 'google-site-kit'),
    metadata: {
      group: _constants__WEBPACK_IMPORTED_MODULE_5__.KEY_METRICS_GROUP_VISITORS.SLUG
    }
  },
  [_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_1__.KM_ANALYTICS_TOP_TRAFFIC_SOURCE]: {
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Top traffic source', 'google-site-kit'),
    description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Channel which brought in the most visitors to your site', 'google-site-kit'),
    infoTooltip: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Channel (e.g. social, paid, search) that brought in the most visitors to your site', 'google-site-kit'),
    metadata: {
      group: _constants__WEBPACK_IMPORTED_MODULE_5__.KEY_METRICS_GROUP_DRIVING_TRAFFIC.SLUG
    }
  },
  [_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_1__.KM_ANALYTICS_TOP_TRAFFIC_SOURCE_DRIVING_ADD_TO_CART]: {
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Top traffic source driving add to cart', 'google-site-kit'),
    description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Channel which brought in the most add to cart events to your site', 'google-site-kit'),
    infoTooltip: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Channel (e.g. social, paid, search) that brought in the most add to cart events to your site', 'google-site-kit'),
    requiredConversionEventName: [_js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_3__.ENUM_CONVERSION_EVENTS.ADD_TO_CART],
    displayInSelectionPanel: _shouldDisplayWidgetWithConversionEvent__WEBPACK_IMPORTED_MODULE_4__.shouldDisplayWidgetWithConversionEvent,
    displayInList: _shouldDisplayWidgetWithConversionEvent__WEBPACK_IMPORTED_MODULE_4__.shouldDisplayWidgetWithConversionEvent,
    metadata: {
      group: _constants__WEBPACK_IMPORTED_MODULE_5__.KEY_METRICS_GROUP_SELLING_PRODUCTS.SLUG
    }
  },
  [_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_1__.KM_ANALYTICS_TOP_TRAFFIC_SOURCE_DRIVING_LEADS]: {
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Top traffic source driving leads', 'google-site-kit'),
    description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Channel which brought in the most leads to your site', 'google-site-kit'),
    infoTooltip: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Channel (e.g. social, paid, search) that brought in the most leads to your site', 'google-site-kit'),
    requiredConversionEventName: [_js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_3__.ENUM_CONVERSION_EVENTS.SUBMIT_LEAD_FORM, _js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_3__.ENUM_CONVERSION_EVENTS.CONTACT, _js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_3__.ENUM_CONVERSION_EVENTS.GENERATE_LEAD],
    displayInSelectionPanel: _shouldDisplayWidgetWithConversionEvent__WEBPACK_IMPORTED_MODULE_4__.shouldDisplayWidgetWithConversionEvent,
    displayInList: _shouldDisplayWidgetWithConversionEvent__WEBPACK_IMPORTED_MODULE_4__.shouldDisplayWidgetWithConversionEvent,
    metadata: {
      group: _constants__WEBPACK_IMPORTED_MODULE_5__.KEY_METRICS_GROUP_GENERATING_LEADS.SLUG
    }
  },
  [_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_1__.KM_ANALYTICS_TOP_TRAFFIC_SOURCE_DRIVING_PURCHASES]: {
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Top traffic source driving purchases', 'google-site-kit'),
    description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Channel which brought in the most purchases to your site', 'google-site-kit'),
    infoTooltip: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Channel (e.g. social, paid, search) that brought in the most purchases to your site', 'google-site-kit'),
    requiredConversionEventName: [_js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_3__.ENUM_CONVERSION_EVENTS.PURCHASE],
    displayInSelectionPanel: _shouldDisplayWidgetWithConversionEvent__WEBPACK_IMPORTED_MODULE_4__.shouldDisplayWidgetWithConversionEvent,
    displayInList: _shouldDisplayWidgetWithConversionEvent__WEBPACK_IMPORTED_MODULE_4__.shouldDisplayWidgetWithConversionEvent,
    metadata: {
      group: _constants__WEBPACK_IMPORTED_MODULE_5__.KEY_METRICS_GROUP_SELLING_PRODUCTS.SLUG
    }
  },
  [_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_1__.KM_ANALYTICS_ENGAGED_TRAFFIC_SOURCE]: {
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Most engaged traffic source', 'google-site-kit'),
    description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Visitors coming via this channel spent the most time on your site', 'google-site-kit'),
    infoTooltip: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Channel (e.g. social, paid, search) that brought in the most visitors who had a meaningful engagement with your site', 'google-site-kit'),
    metadata: {
      group: _constants__WEBPACK_IMPORTED_MODULE_5__.KEY_METRICS_GROUP_DRIVING_TRAFFIC.SLUG
    }
  },
  [_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_1__.KM_ANALYTICS_TOP_CONVERTING_TRAFFIC_SOURCE]: {
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Top converting traffic source', 'google-site-kit'),
    description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Channel which brought in the most visits that resulted in key events', 'google-site-kit'),
    infoTooltip: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Channel (e.g. social, paid, search) that brought in visitors who generated the most key events', 'google-site-kit'),
    metadata: {
      group: _constants__WEBPACK_IMPORTED_MODULE_5__.KEY_METRICS_GROUP_DRIVING_TRAFFIC.SLUG
    }
  },
  [_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_1__.KM_ANALYTICS_TOP_CITIES]: {
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Top cities driving traffic', 'google-site-kit'),
    description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Which cities you get the most visitors from', 'google-site-kit'),
    infoTooltip: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('The cities where most of your visitors came from', 'google-site-kit'),
    metadata: {
      group: _constants__WEBPACK_IMPORTED_MODULE_5__.KEY_METRICS_GROUP_DRIVING_TRAFFIC.SLUG
    }
  },
  [_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_1__.KM_ANALYTICS_TOP_CITIES_DRIVING_LEADS]: {
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Top cities driving leads', 'google-site-kit'),
    description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Cities driving the most contact form submissions', 'google-site-kit'),
    infoTooltip: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Cities driving the most contact form submissions', 'google-site-kit'),
    requiredConversionEventName: [_js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_3__.ENUM_CONVERSION_EVENTS.SUBMIT_LEAD_FORM, _js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_3__.ENUM_CONVERSION_EVENTS.CONTACT, _js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_3__.ENUM_CONVERSION_EVENTS.GENERATE_LEAD],
    displayInSelectionPanel: _shouldDisplayWidgetWithConversionEvent__WEBPACK_IMPORTED_MODULE_4__.shouldDisplayWidgetWithConversionEvent,
    displayInList: _shouldDisplayWidgetWithConversionEvent__WEBPACK_IMPORTED_MODULE_4__.shouldDisplayWidgetWithConversionEvent,
    metadata: {
      group: _constants__WEBPACK_IMPORTED_MODULE_5__.KEY_METRICS_GROUP_GENERATING_LEADS.SLUG
    }
  },
  [_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_1__.KM_ANALYTICS_TOP_CITIES_DRIVING_ADD_TO_CART]: {
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Top cities driving add to cart', 'google-site-kit'),
    description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Cities where visitors most frequently add products to their carts', 'google-site-kit'),
    infoTooltip: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Cities where visitors most frequently add products to their carts', 'google-site-kit'),
    requiredConversionEventName: [_js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_3__.ENUM_CONVERSION_EVENTS.ADD_TO_CART],
    displayInSelectionPanel: _shouldDisplayWidgetWithConversionEvent__WEBPACK_IMPORTED_MODULE_4__.shouldDisplayWidgetWithConversionEvent,
    displayInList: _shouldDisplayWidgetWithConversionEvent__WEBPACK_IMPORTED_MODULE_4__.shouldDisplayWidgetWithConversionEvent,
    metadata: {
      group: _constants__WEBPACK_IMPORTED_MODULE_5__.KEY_METRICS_GROUP_SELLING_PRODUCTS.SLUG
    }
  },
  [_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_1__.KM_ANALYTICS_TOP_CITIES_DRIVING_PURCHASES]: {
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Top cities driving purchases', 'google-site-kit'),
    description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Cities driving the most purchases', 'google-site-kit'),
    infoTooltip: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Cities driving the most purchases', 'google-site-kit'),
    requiredConversionEventName: [_js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_3__.ENUM_CONVERSION_EVENTS.PURCHASE],
    displayInSelectionPanel: _shouldDisplayWidgetWithConversionEvent__WEBPACK_IMPORTED_MODULE_4__.shouldDisplayWidgetWithConversionEvent,
    displayInList: _shouldDisplayWidgetWithConversionEvent__WEBPACK_IMPORTED_MODULE_4__.shouldDisplayWidgetWithConversionEvent,
    metadata: {
      group: _constants__WEBPACK_IMPORTED_MODULE_5__.KEY_METRICS_GROUP_SELLING_PRODUCTS.SLUG
    }
  },
  [_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_1__.KM_ANALYTICS_TOP_DEVICE_DRIVING_PURCHASES]: {
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Top device driving purchases', 'google-site-kit'),
    description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Top device driving the most purchases', 'google-site-kit'),
    infoTooltip: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Top device driving the most purchases', 'google-site-kit'),
    requiredConversionEventName: [_js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_3__.ENUM_CONVERSION_EVENTS.PURCHASE],
    displayInSelectionPanel: _shouldDisplayWidgetWithConversionEvent__WEBPACK_IMPORTED_MODULE_4__.shouldDisplayWidgetWithConversionEvent,
    displayInList: _shouldDisplayWidgetWithConversionEvent__WEBPACK_IMPORTED_MODULE_4__.shouldDisplayWidgetWithConversionEvent,
    metadata: {
      group: _constants__WEBPACK_IMPORTED_MODULE_5__.KEY_METRICS_GROUP_SELLING_PRODUCTS.SLUG
    }
  },
  [_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_1__.KM_ANALYTICS_TOP_COUNTRIES]: {
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Top countries driving traffic', 'google-site-kit'),
    description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Which countries you get the most visitors from', 'google-site-kit'),
    infoTooltip: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('The countries where most of your visitors came from', 'google-site-kit'),
    metadata: {
      group: _constants__WEBPACK_IMPORTED_MODULE_5__.KEY_METRICS_GROUP_DRIVING_TRAFFIC.SLUG
    }
  },
  [_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_1__.KM_SEARCH_CONSOLE_POPULAR_KEYWORDS]: {
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Top performing keywords', 'google-site-kit'),
    description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('What people searched for before they came to your site', 'google-site-kit'),
    infoTooltip: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('The top search queries for your site by highest clickthrough rate', 'google-site-kit'),
    metadata: {
      group: _constants__WEBPACK_IMPORTED_MODULE_5__.KEY_METRICS_GROUP_DRIVING_TRAFFIC.SLUG
    }
  },
  [_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_1__.KM_ANALYTICS_TOP_PAGES_DRIVING_LEADS]: {
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Top pages driving leads', 'google-site-kit'),
    description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Pages on which forms are most frequently submitted', 'google-site-kit'),
    requiredConversionEventName: [_js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_3__.ENUM_CONVERSION_EVENTS.SUBMIT_LEAD_FORM, _js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_3__.ENUM_CONVERSION_EVENTS.CONTACT, _js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_3__.ENUM_CONVERSION_EVENTS.GENERATE_LEAD],
    displayInSelectionPanel: _shouldDisplayWidgetWithConversionEvent__WEBPACK_IMPORTED_MODULE_4__.shouldDisplayWidgetWithConversionEvent,
    displayInList: _shouldDisplayWidgetWithConversionEvent__WEBPACK_IMPORTED_MODULE_4__.shouldDisplayWidgetWithConversionEvent,
    metadata: {
      group: _constants__WEBPACK_IMPORTED_MODULE_5__.KEY_METRICS_GROUP_GENERATING_LEADS.SLUG
    }
  }
};


/***/ }),

/***/ "./js/components/KeyMetrics/shouldDisplayWidgetWithConversionEvent.js":
/*!****************************************************************************!*\
  !*** ./js/components/KeyMetrics/shouldDisplayWidgetWithConversionEvent.js ***!
  \****************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   shouldDisplayWidgetWithConversionEvent: () => (/* binding */ shouldDisplayWidgetWithConversionEvent)
/* harmony export */ });
/* harmony import */ var _js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @/js/googlesitekit/datastore/user/constants */ "./js/googlesitekit/datastore/user/constants.js");
/* harmony import */ var _js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/modules/analytics-4/datastore/constants */ "./js/modules/analytics-4/datastore/constants.js");
/**
 * Key Metrics shouldDisplayWidgetWithConversionEvent function.
 *
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Internal dependencies
 */



/**
 * Determines whether to display a widget that requires conversion reporting events
 * in the key metrics selection panel.
 *
 * This function is attached to the widget object that requires the conversion reporting events and
 * has the `requiredConversionEventName` property.
 *
 * @since 1.136.0
 * @since 1.137.0 Moved function to its own file.
 *
 * @param {Object}   options        Options object.
 * @param {Function} options.select Data store select function.
 * @param {string}   options.slug   Key metric widget slug.
 * @return {boolean} Whether to display the widget.
 */
function shouldDisplayWidgetWithConversionEvent({
  select,
  slug
}) {
  return select(_js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_1__.MODULES_ANALYTICS_4).hasConversionReportingEvents(
  // This property is available to the widget object that requires the
  // conversion reporting events, where the function is attached.
  this.requiredConversionEventName) || select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_0__.CORE_USER).isKeyMetricActive(slug);
}

/***/ }),

/***/ "./js/components/LeanCTABanner.js":
/*!****************************************!*\
  !*** ./js/components/LeanCTABanner.js ***!
  \****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * LeanCTABanner component.
 *
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * WordPress dependencies
 */


const LeanCTABanner = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.forwardRef)(({
  className,
  children,
  Icon,
  SVGGraphic
}, ref) => {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsxs)("div", {
    ref: ref,
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-lean-cta-banner', className),
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsxs)("div", {
      className: "googlesitekit-lean-cta-banner__body",
      children: [Icon && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", {
        className: "googlesitekit-lean-cta-banner__body-icon",
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)(Icon, {
          width: "32",
          height: "32"
        })
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", {
        className: "googlesitekit-lean-cta-banner__body-content",
        children: children
      })]
    }), SVGGraphic && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", {
      className: "googlesitekit-lean-cta-banner__graphic",
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)(SVGGraphic, {})
    })]
  });
});
LeanCTABanner.propTypes = {
  className: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  children: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().node).isRequired,
  Icon: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().elementType),
  SVGGraphic: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().elementType)
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (LeanCTABanner);

/***/ }),

/***/ "./js/components/Link.js":
/*!*******************************!*\
  !*** ./js/components/Link.js ***!
  \*******************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_10__);
/* harmony import */ var react_router_dom__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! react-router-dom */ "../node_modules/react-router-dom/esm/react-router-dom.js");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _svg_icons_arrow_svg__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/svg/icons/arrow.svg */ "./svg/icons/arrow.svg");
/* harmony import */ var _svg_icons_arrow_inverse_svg__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/svg/icons/arrow-inverse.svg */ "./svg/icons/arrow-inverse.svg");
/* harmony import */ var _svg_icons_back_svg__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/svg/icons/back.svg */ "./svg/icons/back.svg");
/* harmony import */ var _svg_icons_external_svg__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/svg/icons/external.svg */ "./svg/icons/external.svg");
/* harmony import */ var _IconWrapper__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./IconWrapper */ "./js/components/IconWrapper.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Link component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */




/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */






const BUTTON = 'BUTTON';
const BUTTON_DISABLED = 'BUTTON_DISABLED';
const EXTERNAL_LINK = 'EXTERNAL_LINK';
const LINK = 'LINK';
const ROUTER_LINK = 'ROUTER_LINK';
const Link = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_8__.forwardRef)((props, ref) => {
  const {
    'aria-label': ariaLabelProp,
    secondary = false,
    arrow = false,
    back = false,
    caps = false,
    children,
    className = '',
    danger = false,
    disabled = false,
    external = false,
    hideExternalIndicator = false,
    href = '',
    inverse = false,
    noFlex = false,
    onClick,
    small = false,
    standalone = false,
    linkButton = false,
    to,
    leadingIcon,
    trailingIcon,
    ...otherProps
  } = props;
  function getType() {
    // Force button element if `onClick` prop is passed and there's no `href`
    // or `to` prop.
    if (!href && !to && onClick) {
      if (disabled) {
        return BUTTON_DISABLED;
      }
      return BUTTON;
    }

    // Only `RouterLink` uses the `to` prop.
    if (to) {
      return ROUTER_LINK;
    }

    // The external prop means this is an external link, which will also output
    // an `<a>` tag.
    if (external) {
      return EXTERNAL_LINK;
    }

    // A regular `<a>` tag without external indicators.
    return LINK;
  }
  const type = getType();
  function getLinkComponent() {
    if (type === BUTTON || type === BUTTON_DISABLED) {
      return 'button';
    }
    if (type === ROUTER_LINK) {
      return react_router_dom__WEBPACK_IMPORTED_MODULE_9__.Link;
    }
    return 'a';
  }
  function getAriaLabel() {
    // Otherwise, create an ARIA label if the link opens in a new window
    // or is disabled, to add extra context to the link.
    let labelSuffix;
    if (type === EXTERNAL_LINK) {
      labelSuffix = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__._x)('(opens in a new tab)', 'screen reader text', 'google-site-kit');
    }
    if (type === BUTTON_DISABLED) {
      labelSuffix = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__._x)('(disabled)', 'screen reader text', 'google-site-kit');
    }
    if (!labelSuffix) {
      return ariaLabelProp;
    }

    // If an ARIA label was supplied, use that.
    if (ariaLabelProp) {
      return `${ariaLabelProp} ${labelSuffix}`;
    }

    // Otherwise, use the children prop if it's a string.
    if (typeof children === 'string') {
      return `${children} ${labelSuffix}`;
    }

    // If there isn't a string we can use to create the label, we shouldn't
    // make one; otherwise we'll only create an ARIA label that says
    // "(opens in a new tab)", which is not good.
    return undefined;
  }
  const LinkComponent = getLinkComponent();
  const ariaLabel = getAriaLabel();

  // Set the prefix/suffix icons, based on the type of link this is and
  // the props supplied.
  let leadingIconToUse = leadingIcon;
  let trailingIconToUse = trailingIcon;
  if (back) {
    leadingIconToUse = /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_svg_icons_back_svg__WEBPACK_IMPORTED_MODULE_4__["default"], {
      width: 14,
      height: 14
    });
  }
  if (external && !hideExternalIndicator) {
    trailingIconToUse = /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_svg_icons_external_svg__WEBPACK_IMPORTED_MODULE_5__["default"], {
      width: 14,
      height: 14
    });
  }
  if (arrow && !inverse) {
    trailingIconToUse = /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_svg_icons_arrow_svg__WEBPACK_IMPORTED_MODULE_2__["default"], {
      width: 14,
      height: 14
    });
  }
  if (arrow && inverse) {
    trailingIconToUse = /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_svg_icons_arrow_inverse_svg__WEBPACK_IMPORTED_MODULE_3__["default"], {
      width: 14,
      height: 14
    });
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsxs)(LinkComponent, {
    "aria-label": ariaLabel,
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-cta-link', className, {
      'googlesitekit-cta-link--secondary': secondary,
      'googlesitekit-cta-link--inverse': inverse,
      'googlesitekit-cta-link--small': small,
      'googlesitekit-cta-link--caps': caps,
      'googlesitekit-cta-link--danger': danger,
      'googlesitekit-cta-link--disabled': disabled,
      'googlesitekit-cta-link--standalone': standalone,
      'googlesitekit-cta-link--link-button': linkButton,
      'googlesitekit-cta-link--no-flex': !!noFlex
    }),
    disabled: disabled,
    href: (type === LINK || type === EXTERNAL_LINK) && !disabled ? href : undefined,
    onClick: onClick,
    rel: type === EXTERNAL_LINK ? 'noopener noreferrer' : undefined,
    ref: ref,
    target: type === EXTERNAL_LINK ? '_blank' : undefined,
    to: to,
    ...otherProps,
    children: [!!leadingIconToUse && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_IconWrapper__WEBPACK_IMPORTED_MODULE_6__["default"], {
      marginRight: 5,
      children: leadingIconToUse
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)("span", {
      className: "googlesitekit-cta-link__contents",
      children: children
    }), !!trailingIconToUse && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_IconWrapper__WEBPACK_IMPORTED_MODULE_6__["default"], {
      marginLeft: 5,
      children: trailingIconToUse
    })]
  });
});
Link.propTypes = {
  arrow: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().bool),
  back: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().bool),
  caps: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().bool),
  children: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().node),
  className: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().string),
  danger: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().bool),
  disabled: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().bool),
  external: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().bool),
  hideExternalIndicator: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().bool),
  href: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().string),
  inverse: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().bool),
  leadingIcon: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().node),
  linkButton: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().bool),
  noFlex: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().bool),
  onClick: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().func),
  small: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().bool),
  standalone: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().bool),
  to: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().string),
  trailingIcon: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().node)
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Link);

/***/ }),

/***/ "./js/components/ModalDialog.js":
/*!**************************************!*\
  !*** ./js/components/ModalDialog.js ***!
  \**************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_compose__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @wordpress/compose */ "../node_modules/@wordpress/compose/build-module/hooks/use-instance-id/index.js");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/@wordpress/element/build-module/create-interpolate-element.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! googlesitekit-components */ "googlesitekit-components");
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_components__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _svg_icons_warning_svg__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/svg/icons/warning.svg */ "./svg/icons/warning.svg");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * ModalDialog component.
 *
 * Site Kit by Google, Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * WordPress dependencies
 */




/**
 * Internal dependencies
 */



function ModalDialog({
  className = '',
  dialogActive = false,
  handleCancel = null,
  onOpen = null,
  onClose = null,
  title = null,
  provides,
  handleConfirm,
  subtitle,
  confirmButton = null,
  dependentModules,
  danger = false,
  inProgress = false,
  small = false,
  medium = false,
  buttonLink = null
}) {
  const instanceID = (0,_wordpress_compose__WEBPACK_IMPORTED_MODULE_5__["default"])(ModalDialog);
  const describedByID = `googlesitekit-dialog-description-${instanceID}`;
  const hasProvides = !!(provides && provides.length);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsxs)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_2__.Dialog, {
    open: dialogActive,
    onOpen: onOpen,
    onClose: onClose,
    "aria-describedby": hasProvides ? describedByID : undefined,
    tabIndex: "-1",
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()(className, {
      'googlesitekit-dialog-sm': small,
      'googlesitekit-dialog-md': medium
    }),
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsxs)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_2__.DialogTitle, {
      children: [danger && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(_svg_icons_warning_svg__WEBPACK_IMPORTED_MODULE_3__["default"], {
        width: 28,
        height: 28
      }), title]
    }),
    // Ensure we don't render anything at all if subtitle is falsy, as Dialog expects all its children to be elements and a falsy value will result in an error.
    subtitle ? /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("p", {
      className: "mdc-dialog__lead",
      children: subtitle
    }) : [], /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsxs)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_2__.DialogContent, {
      children: [hasProvides && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("section", {
        id: describedByID,
        className: "mdc-dialog__provides",
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("ul", {
          className: "mdc-list mdc-list--underlined mdc-list--non-interactive",
          children: provides.map(attribute => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("li", {
            className: "mdc-list-item",
            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("span", {
              className: "mdc-list-item__text",
              children: attribute
            })
          }, attribute))
        })
      }), dependentModules && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("p", {
        className: "mdc-dialog__dependencies",
        children: (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__["default"])((0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.sprintf)(/* translators: %s is replaced with the dependent modules. */
        (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('<strong>Note:</strong> %s', 'google-site-kit'), dependentModules), {
          strong: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("strong", {})
        })
      })]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsxs)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_2__.DialogFooter, {
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_2__.Button, {
        className: "mdc-dialog__cancel-button",
        onClick: handleCancel,
        disabled: inProgress,
        tertiary: true,
        children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Cancel', 'google-site-kit')
      }), buttonLink ? /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_2__.Button, {
        href: buttonLink,
        onClick: handleConfirm,
        target: "_blank",
        danger: danger,
        children: confirmButton
      }) : /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_2__.SpinnerButton, {
        onClick: handleConfirm,
        danger: danger,
        disabled: inProgress,
        isSaving: inProgress,
        children: confirmButton || (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Disconnect', 'google-site-kit')
      })]
    })]
  });
}
ModalDialog.displayName = 'Dialog';
ModalDialog.propTypes = {
  className: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().string),
  dialogActive: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().bool),
  handleDialog: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().func),
  handleConfirm: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().func).isRequired,
  onOpen: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().func),
  onClose: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().func),
  title: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().string),
  confirmButton: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().string),
  danger: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().bool),
  small: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().bool),
  medium: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().bool),
  buttonLink: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().string)
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ModalDialog);

/***/ }),

/***/ "./js/components/NewBadge.js":
/*!***********************************!*\
  !*** ./js/components/NewBadge.js ***!
  \***********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! googlesitekit-components */ "googlesitekit-components");
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_components__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _Badge__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./Badge */ "./js/components/Badge.js");
/* harmony import */ var _Link__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./Link */ "./js/components/Link.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * NewBadge component.
 *
 * Site Kit by Google, Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */




function NewBadge({
  tooltipTitle,
  learnMoreLink,
  forceOpen,
  hasLeftSpacing,
  hasNoSpacing,
  onLearnMoreClick = () => {}
}) {
  const badgeComponent = /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_Badge__WEBPACK_IMPORTED_MODULE_3__["default"], {
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-new-badge', {
      'googlesitekit-new-badge--has-no-spacing': hasNoSpacing
    }),
    label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('New', 'google-site-kit'),
    hasLeftSpacing: hasLeftSpacing
  });
  if (!tooltipTitle) {
    return badgeComponent;
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_2__.Tooltip, {
    tooltipClassName: "googlesitekit-new-badge__tooltip",
    title: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)(_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.Fragment, {
      children: [tooltipTitle, /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("br", {}), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_Link__WEBPACK_IMPORTED_MODULE_4__["default"], {
        href: learnMoreLink,
        onClick: onLearnMoreClick,
        external: true,
        hideExternalIndicator: true,
        children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Learn more', 'google-site-kit')
      })]
    }),
    placement: "top",
    enterTouchDelay: 0,
    leaveTouchDelay: 5000,
    open: forceOpen,
    interactive: true,
    children: badgeComponent
  });
}
NewBadge.propTypes = {
  tooltipTitle: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().string),
  learnMoreLink: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().string),
  forceOpen: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().bool),
  onLearnMoreClick: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().func),
  hasLeftSpacing: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().bool),
  hasNoSpacing: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().bool)
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (NewBadge);

/***/ }),

/***/ "./js/components/Notice/CTAButton.js":
/*!*******************************************!*\
  !*** ./js/components/Notice/CTAButton.js ***!
  \*******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ CTAButton)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! googlesitekit-components */ "googlesitekit-components");
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_components__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _svg_icons_external_svg__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/svg/icons/external.svg */ "./svg/icons/external.svg");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * Internal dependencies
 */



function CTAButton({
  label,
  disabled,
  inProgress,
  onClick,
  href,
  external,
  hideExternalIndicator
}) {
  let trailingIconToUse;
  if (external && !hideExternalIndicator) {
    trailingIconToUse = /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)(_svg_icons_external_svg__WEBPACK_IMPORTED_MODULE_1__["default"], {
      width: 14,
      height: 14
    });
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_0__.SpinnerButton, {
    className: "googlesitekit-notice__cta",
    disabled: disabled,
    isSaving: inProgress,
    onClick: onClick,
    href: href,
    target: external ? '_blank' : '_self',
    trailingIcon: trailingIconToUse,
    children: label
  });
}
CTAButton.propTypes = {
  label: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string).isRequired,
  disabled: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().bool),
  inProgress: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().bool),
  onClick: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().func),
  href: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  external: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().bool),
  hideExternalIndicator: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().bool)
};

/***/ }),

/***/ "./js/components/Notice/Description.js":
/*!*********************************************!*\
  !*** ./js/components/Notice/Description.js ***!
  \*********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Description)
/* harmony export */ });
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



function Description({
  className,
  children
}) {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("p", {
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-notice__description', className),
    children: children
  });
}
Description.propTypes = {
  className: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().string),
  children: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().node)
};

/***/ }),

/***/ "./js/components/Notice/DismissButton.js":
/*!***********************************************!*\
  !*** ./js/components/Notice/DismissButton.js ***!
  \***********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ DismissButton)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-components */ "googlesitekit-components");
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */


function DismissButton({
  label = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Got it', 'google-site-kit'),
  onClick,
  disabled
}) {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__.Button, {
    onClick: onClick,
    disabled: disabled,
    tertiary: true,
    children: label
  });
}
DismissButton.propTypes = {
  label: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  onClick: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().func).isRequired,
  disabled: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().bool)
};

/***/ }),

/***/ "./js/components/Notice/Icon.js":
/*!**************************************!*\
  !*** ./js/components/Notice/Icon.js ***!
  \**************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Icon)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _svg_icons_check_fill_svg__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @/svg/icons/check-fill.svg */ "./svg/icons/check-fill.svg");
/* harmony import */ var _svg_icons_warning_notice_svg__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/svg/icons/warning-notice.svg */ "./svg/icons/warning-notice.svg");
/* harmony import */ var _svg_icons_star_fill_svg__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/svg/icons/star-fill.svg */ "./svg/icons/star-fill.svg");
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./constants */ "./js/components/Notice/constants.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * Internal dependencies
 */





const typeIconMap = {
  [_constants__WEBPACK_IMPORTED_MODULE_3__.TYPES.NEW]: _svg_icons_star_fill_svg__WEBPACK_IMPORTED_MODULE_2__["default"],
  [_constants__WEBPACK_IMPORTED_MODULE_3__.TYPES.SUCCESS]: _svg_icons_check_fill_svg__WEBPACK_IMPORTED_MODULE_0__["default"],
  [_constants__WEBPACK_IMPORTED_MODULE_3__.TYPES.INFO]: _svg_icons_warning_notice_svg__WEBPACK_IMPORTED_MODULE_1__["default"],
  [_constants__WEBPACK_IMPORTED_MODULE_3__.TYPES.WARNING]: _svg_icons_warning_notice_svg__WEBPACK_IMPORTED_MODULE_1__["default"],
  [_constants__WEBPACK_IMPORTED_MODULE_3__.TYPES.ERROR]: _svg_icons_warning_notice_svg__WEBPACK_IMPORTED_MODULE_1__["default"]
};
function Icon({
  type
}) {
  const IconComponent = typeIconMap[type] || _svg_icons_warning_notice_svg__WEBPACK_IMPORTED_MODULE_1__["default"];
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(IconComponent, {
    width: 24,
    height: 24
  });
}
Icon.propTypes = {
  type: prop_types__WEBPACK_IMPORTED_MODULE_5___default().oneOf(Object.values(_constants__WEBPACK_IMPORTED_MODULE_3__.TYPES))
};

/***/ }),

/***/ "./js/components/Notice/Title.js":
/*!***************************************!*\
  !*** ./js/components/Notice/Title.js ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Title)
/* harmony export */ });
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



function Title({
  className,
  children
}) {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("p", {
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-notice__title', className),
    children: children
  });
}
Title.propTypes = {
  className: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().string),
  children: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().node)
};

/***/ }),

/***/ "./js/components/Notice/constants.js":
/*!*******************************************!*\
  !*** ./js/components/Notice/constants.js ***!
  \*******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   TYPES: () => (/* binding */ TYPES)
/* harmony export */ });
/**
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

const TYPES = {
  NEW: 'new',
  SUCCESS: 'success',
  WARNING: 'warning',
  INFO: 'info',
  INFO_ALT: 'info-alt',
  ERROR: 'error'
};

/***/ }),

/***/ "./js/components/Notice/index.js":
/*!***************************************!*\
  !*** ./js/components/Notice/index.js ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _Icon__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Icon */ "./js/components/Notice/Icon.js");
/* harmony import */ var _Title__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./Title */ "./js/components/Notice/Title.js");
/* harmony import */ var _Description__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./Description */ "./js/components/Notice/Description.js");
/* harmony import */ var _CTAButton__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./CTAButton */ "./js/components/Notice/CTAButton.js");
/* harmony import */ var _DismissButton__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./DismissButton */ "./js/components/Notice/DismissButton.js");
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./constants */ "./js/components/Notice/constants.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */







const Notice = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_8__.forwardRef)(({
  className,
  title,
  description,
  dismissButton,
  ctaButton,
  type = _constants__WEBPACK_IMPORTED_MODULE_6__.TYPES.INFO,
  children,
  hideIcon
}, ref) => {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsxs)("div", {
    ref: ref,
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-notice', `googlesitekit-notice--${type}`, className),
    children: [!hideIcon && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)("div", {
      className: "googlesitekit-notice__icon",
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_Icon__WEBPACK_IMPORTED_MODULE_1__["default"], {
        type: type
      })
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsxs)("div", {
      className: "googlesitekit-notice__content",
      children: [title && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_Title__WEBPACK_IMPORTED_MODULE_2__["default"], {
        children: title
      }), description && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_Description__WEBPACK_IMPORTED_MODULE_3__["default"], {
        children: description
      })]
    }), (dismissButton?.label || dismissButton?.onClick || ctaButton?.label && (ctaButton?.onClick || ctaButton?.href) || children) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsxs)("div", {
      className: "googlesitekit-notice__action",
      children: [children, (dismissButton?.label || dismissButton?.onClick) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_DismissButton__WEBPACK_IMPORTED_MODULE_5__["default"], {
        label: dismissButton.label,
        onClick: dismissButton.onClick,
        disabled: dismissButton.disabled
      }), ctaButton?.label && (ctaButton?.onClick || ctaButton?.href) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_CTAButton__WEBPACK_IMPORTED_MODULE_4__["default"], {
        label: ctaButton.label,
        onClick: ctaButton.onClick,
        inProgress: ctaButton.inProgress,
        disabled: ctaButton.disabled,
        href: ctaButton.href,
        external: ctaButton.external,
        hideExternalIndicator: ctaButton.hideExternalIndicator
      })]
    })]
  });
});
Notice.TYPES = _constants__WEBPACK_IMPORTED_MODULE_6__.TYPES;
Notice.propTypes = {
  className: (prop_types__WEBPACK_IMPORTED_MODULE_9___default().string),
  title: prop_types__WEBPACK_IMPORTED_MODULE_9___default().oneOfType([(prop_types__WEBPACK_IMPORTED_MODULE_9___default().string), (prop_types__WEBPACK_IMPORTED_MODULE_9___default().object)]),
  description: (prop_types__WEBPACK_IMPORTED_MODULE_9___default().node),
  type: prop_types__WEBPACK_IMPORTED_MODULE_9___default().oneOf(Object.values(_constants__WEBPACK_IMPORTED_MODULE_6__.TYPES)),
  dismissButton: prop_types__WEBPACK_IMPORTED_MODULE_9___default().shape(_DismissButton__WEBPACK_IMPORTED_MODULE_5__["default"].propTypes),
  ctaButton: prop_types__WEBPACK_IMPORTED_MODULE_9___default().shape({
    ..._CTAButton__WEBPACK_IMPORTED_MODULE_4__["default"].propTypes,
    label: (prop_types__WEBPACK_IMPORTED_MODULE_9___default().string) // CTAButton label should not be required for this parent component.
  }),
  children: (prop_types__WEBPACK_IMPORTED_MODULE_9___default().node),
  hideIcon: (prop_types__WEBPACK_IMPORTED_MODULE_9___default().bool)
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Notice);

/***/ }),

/***/ "./js/components/Null.js":
/*!*******************************!*\
  !*** ./js/components/Null.js ***!
  \*******************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Null)
/* harmony export */ });
/**
 * Null component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

function Null() {
  return null;
}

/***/ }),

/***/ "./js/components/OverlayCard/Body.js":
/*!*******************************************!*\
  !*** ./js/components/OverlayCard/Body.js ***!
  \*******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Body)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @/js/hooks/useBreakpoint */ "./js/hooks/useBreakpoint.js");
/* harmony import */ var _Title__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Title */ "./js/components/OverlayCard/Title.js");
/* harmony import */ var _Description__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./Description */ "./js/components/OverlayCard/Description.js");
/* harmony import */ var _DismissButton__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./DismissButton */ "./js/components/OverlayCard/DismissButton.js");
/* harmony import */ var _CTAButton__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./CTAButton */ "./js/components/OverlayCard/CTAButton.js");
/* harmony import */ var _js_components_NewBadge__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/components/NewBadge */ "./js/components/NewBadge.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * OverlayCard Body component.
 *
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */







function Body({
  title,
  description,
  ctaButton,
  dismissButton,
  GraphicDesktop,
  GraphicMobile,
  newBadge
}) {
  const breakpoint = (0,_js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_0__.useBreakpoint)();
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)(_wordpress_element__WEBPACK_IMPORTED_MODULE_7__.Fragment, {
    children: [breakpoint !== _js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_0__.BREAKPOINT_SMALL && GraphicDesktop && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("div", {
      className: "googlesitekit-overlay-card__graphic",
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(GraphicDesktop, {})
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)("div", {
      className: "googlesitekit-overlay-card__body",
      children: [newBadge && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("div", {
        className: "googlesitekit-overlay-card__badge",
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(_js_components_NewBadge__WEBPACK_IMPORTED_MODULE_5__["default"], {
          hasNoSpacing: true
        })
      }), title && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(_Title__WEBPACK_IMPORTED_MODULE_1__["default"], {
        children: title
      }), description && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(_Description__WEBPACK_IMPORTED_MODULE_2__["default"], {
        children: description
      })]
    }), (ctaButton || dismissButton) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)("div", {
      className: "googlesitekit-overlay-card__actions",
      children: [dismissButton && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(_DismissButton__WEBPACK_IMPORTED_MODULE_3__["default"], {
        ...dismissButton
      }), ctaButton && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(_CTAButton__WEBPACK_IMPORTED_MODULE_4__["default"], {
        ...ctaButton
      })]
    }), breakpoint === _js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_0__.BREAKPOINT_SMALL && GraphicMobile && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(GraphicMobile, {})]
  });
}
Body.propTypes = {
  title: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().node),
  description: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().node),
  ctaButton: prop_types__WEBPACK_IMPORTED_MODULE_8___default().shape({
    ..._DismissButton__WEBPACK_IMPORTED_MODULE_3__.buttonProps,
    href: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().string),
    target: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().string),
    trailingIcon: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().element)
  }),
  dismissButton: prop_types__WEBPACK_IMPORTED_MODULE_8___default().shape({
    ..._DismissButton__WEBPACK_IMPORTED_MODULE_3__.buttonProps
  }),
  GraphicDesktop: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().elementType),
  GraphicMobile: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().elementType),
  newBadge: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().bool)
};

/***/ }),

/***/ "./js/components/OverlayCard/CTAButton.js":
/*!************************************************!*\
  !*** ./js/components/OverlayCard/CTAButton.js ***!
  \************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ CTAButton)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! googlesitekit-components */ "googlesitekit-components");
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_components__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _DismissButton__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./DismissButton */ "./js/components/OverlayCard/DismissButton.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * OverlayCard CTAButton component.
 *
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * Internal dependencies
 */



function CTAButton(props) {
  const {
    label,
    ...otherProps
  } = props;
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_0__.Button, {
    ...otherProps,
    children: label
  });
}
CTAButton.propTypes = {
  ..._DismissButton__WEBPACK_IMPORTED_MODULE_1__.buttonProps,
  href: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  target: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  trailingIcon: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().object)
};

/***/ }),

/***/ "./js/components/OverlayCard/Description.js":
/*!**************************************************!*\
  !*** ./js/components/OverlayCard/Description.js ***!
  \**************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Description)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * OverlayCard Description component.
 *
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


function Description({
  children
}) {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("p", {
    className: "googlesitekit-overlay-card__description",
    children: children
  });
}
Description.propTypes = {
  children: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().node).isRequired
};

/***/ }),

/***/ "./js/components/OverlayCard/DismissButton.js":
/*!****************************************************!*\
  !*** ./js/components/OverlayCard/DismissButton.js ***!
  \****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   buttonProps: () => (/* binding */ buttonProps),
/* harmony export */   "default": () => (/* binding */ DismissButton)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-components */ "googlesitekit-components");
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * OverlayCard DismissButton component.
 *
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */


function DismissButton({
  label = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Maybe later', 'google-site-kit'),
  onClick,
  disabled
}) {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__.Button, {
    onClick: onClick,
    disabled: disabled,
    tertiary: true,
    children: label
  });
}
const buttonProps = {
  label: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  onClick: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().func),
  disabled: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().bool)
};
DismissButton.propTypes = buttonProps;

/***/ }),

/***/ "./js/components/OverlayCard/Title.js":
/*!********************************************!*\
  !*** ./js/components/OverlayCard/Title.js ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Title)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _js_components_Typography__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @/js/components/Typography */ "./js/components/Typography/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * OverlayCard Title component.
 *
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



function Title({
  children
}) {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)(_js_components_Typography__WEBPACK_IMPORTED_MODULE_0__["default"], {
    as: "h3",
    size: "medium",
    type: "title",
    className: "googlesitekit-overlay-card__title",
    children: children
  });
}
Title.propTypes = {
  children: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().node).isRequired
};

/***/ }),

/***/ "./js/components/OverlayCard/index.js":
/*!********************************************!*\
  !*** ./js/components/OverlayCard/index.js ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ OverlayCard)
/* harmony export */ });
/* harmony import */ var _material_ui_core__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @material-ui/core */ "../node_modules/@material-ui/core/esm/Slide/Slide.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/hooks/useBreakpoint */ "./js/hooks/useBreakpoint.js");
/* harmony import */ var _Body__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./Body */ "./js/components/OverlayCard/Body.js");
/* harmony import */ var _DismissButton__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./DismissButton */ "./js/components/OverlayCard/DismissButton.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * OverlayCard component.
 *
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */




/**
 * Internal dependencies
 */




function OverlayCard(props) {
  const {
    visible,
    className,
    ...cardProps
  } = props;
  const breakpoint = (0,_js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_1__.useBreakpoint)();
  if (!visible) {
    return null;
  }
  const body = /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("div", {
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-overlay-card', className),
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(_Body__WEBPACK_IMPORTED_MODULE_2__["default"], {
      ...cardProps
    })
  });
  if (breakpoint === _js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_1__.BREAKPOINT_SMALL) {
    return body;
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(_material_ui_core__WEBPACK_IMPORTED_MODULE_5__["default"], {
    direction: "up",
    in: visible,
    children: body
  });
}
OverlayCard.propTypes = {
  className: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().string),
  title: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().string),
  description: prop_types__WEBPACK_IMPORTED_MODULE_6___default().oneOfType([(prop_types__WEBPACK_IMPORTED_MODULE_6___default().string), (prop_types__WEBPACK_IMPORTED_MODULE_6___default().object)]),
  ctaButton: prop_types__WEBPACK_IMPORTED_MODULE_6___default().shape({
    ..._DismissButton__WEBPACK_IMPORTED_MODULE_3__.buttonProps,
    href: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().string),
    target: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().string),
    trailingIcon: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().object)
  }),
  dismissButton: prop_types__WEBPACK_IMPORTED_MODULE_6___default().shape(_DismissButton__WEBPACK_IMPORTED_MODULE_3__.buttonProps),
  GraphicDesktop: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().elementType),
  GraphicMobile: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().elementType),
  newBadge: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().bool),
  visible: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().bool)
};
OverlayCard.defaultProps = {
  visible: false
};

/***/ }),

/***/ "./js/components/Portal.js":
/*!*********************************!*\
  !*** ./js/components/Portal.js ***!
  \*********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_use__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react-use */ "../node_modules/react-use/esm/useEffectOnce.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react-dom/index.js");
/**
 * Portal component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * WordPress dependencies
 */

function Portal({
  children,
  slug
}) {
  // Using state as we need `el` to not change when the component re-renders
  const [el] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.useState)(document.createElement('div'));
  (0,react_use__WEBPACK_IMPORTED_MODULE_1__["default"])(() => {
    if (slug) {
      el.classList.add(`googlesitekit-portal-${slug}`);
    }
    const root = document.querySelector('.googlesitekit-plugin') || document.body;
    root.appendChild(el);
    return () => root.removeChild(el);
  });
  return (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.createPortal)(children, el);
}
Portal.propTypes = {
  slug: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  children: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().node)
};
Portal.defaultProps = {
  slug: '',
  children: null
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Portal);

/***/ }),

/***/ "./js/components/PreviewBlock.js":
/*!***************************************!*\
  !*** ./js/components/PreviewBlock.js ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/hooks/useBreakpoint */ "./js/hooks/useBreakpoint.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * PreviewBlock component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * Internal dependencies
 */


function PreviewBlock({
  className,
  width,
  height,
  shape,
  padding,
  smallWidth,
  smallHeight,
  tabletWidth,
  tabletHeight,
  desktopWidth,
  desktopHeight
}) {
  const breakpoint = (0,_js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_1__.useBreakpoint)();
  const blockDimensions = {
    width: {
      [_js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_1__.BREAKPOINT_SMALL]: smallWidth,
      [_js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_1__.BREAKPOINT_TABLET]: tabletWidth,
      [_js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_1__.BREAKPOINT_DESKTOP]: desktopWidth,
      [_js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_1__.BREAKPOINT_XLARGE]: desktopWidth
    },
    height: {
      [_js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_1__.BREAKPOINT_SMALL]: smallHeight,
      [_js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_1__.BREAKPOINT_TABLET]: tabletHeight,
      [_js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_1__.BREAKPOINT_DESKTOP]: desktopHeight,
      [_js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_1__.BREAKPOINT_XLARGE]: desktopWidth
    }
  };
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("div", {
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-preview-block', className, {
      'googlesitekit-preview-block--padding': padding
    }),
    style: {
      width: blockDimensions.width[breakpoint] || width,
      height: blockDimensions.height[breakpoint] || height
    },
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("div", {
      className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-preview-block__wrapper', {
        'googlesitekit-preview-block__wrapper--circle': shape === 'circular'
      })
    })
  });
}
PreviewBlock.propTypes = {
  className: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  width: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  height: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  shape: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  padding: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().bool),
  smallWidth: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  smallHeight: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  tabletWidth: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  tabletHeight: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  desktopWidth: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  desktopHeight: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string)
};
PreviewBlock.defaultProps = {
  className: undefined,
  width: '100px',
  height: '100px',
  shape: 'square',
  padding: false,
  smallWidth: undefined,
  smallHeight: undefined,
  tabletWidth: undefined,
  tabletHeight: undefined,
  desktopWidth: undefined,
  desktopHeight: undefined
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (PreviewBlock);

/***/ }),

/***/ "./js/components/RecoverableModules.js":
/*!*********************************************!*\
  !*** ./js/components/RecoverableModules.js ***!
  \*********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ RecoverableModules)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/googlesitekit/modules/datastore/constants */ "./js/googlesitekit/modules/datastore/constants.js");
/* harmony import */ var _notifications_CTA__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./notifications/CTA */ "./js/components/notifications/CTA.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * RecoverableModules component.
 *
 * Site Kit by Google, Copyright 2022 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */




function RecoverableModules({
  moduleSlugs
}) {
  const moduleNames = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => {
    const modules = select(_js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_2__.CORE_MODULES).getModules();
    if (modules === undefined) {
      return undefined;
    }
    return moduleSlugs.map(moduleSlug => modules[moduleSlug].name);
  });
  if (moduleNames === undefined) {
    return null;
  }
  const description = moduleNames.length === 1 ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.sprintf)(/* translators: %s: Module name */
  (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('%s data was previously shared by an admin who no longer has access. Please contact another admin to restore it.', 'google-site-kit'), moduleNames[0]) : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.sprintf)(/* translators: %s: List of module names */
  (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('The data for the following modules was previously shared by an admin who no longer has access: %s. Please contact another admin to restore it.', 'google-site-kit'), moduleNames.join((0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__._x)(', ', 'Recoverable modules', 'google-site-kit')));
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(_notifications_CTA__WEBPACK_IMPORTED_MODULE_3__["default"], {
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Data Unavailable', 'google-site-kit'),
    description: description
  });
}
RecoverableModules.propTypes = {
  moduleSlugs: prop_types__WEBPACK_IMPORTED_MODULE_5___default().arrayOf((prop_types__WEBPACK_IMPORTED_MODULE_5___default().string)).isRequired
};

/***/ }),

/***/ "./js/components/RefocusableModalDialog.js":
/*!*************************************************!*\
  !*** ./js/components/RefocusableModalDialog.js ***!
  \*************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _wordpress_compose__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @wordpress/compose */ "../node_modules/@wordpress/compose/build-module/hooks/use-previous/index.js");
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! googlesitekit-components */ "googlesitekit-components");
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_components__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _ModalDialog__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./ModalDialog */ "./js/components/ModalDialog.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * ModalDialog component.
 *
 * Site Kit by Google, Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */



// Use a singleton variable to store the clicked element before any dialog opens.
// We need to do this at the module level since the component may not be mounted
// when the user initiates an action that will open the dialog.

let previouslyClickedElement = null;

// Set up a global event listener to capture the clicked element before any dialog opens.
// This needs to happen at the module level to ensure it's set up before any user interaction.
function setupFocusTracker() {
  if (typeof __webpack_require__.g === 'undefined' || !__webpack_require__.g.document || __webpack_require__.g._googlesitekitModalFocusTrackerInitialized) {
    return;
  }
  function captureActiveElementOnClick(event) {
    // Store the clicked (or keyboard-activated) element when user clicks.
    // This will be the element that was clicked right before the dialog opens.
    const nearestParentButtonOrAnchor = event.target.closest('button, a, input');
    if (nearestParentButtonOrAnchor && !nearestParentButtonOrAnchor.classList.contains('mdc-dialog__cancel-button')) {
      previouslyClickedElement = nearestParentButtonOrAnchor;
    }
  }
  __webpack_require__.g.document.addEventListener('mousedown', captureActiveElementOnClick);
  __webpack_require__.g.document.addEventListener('keydown', event => {
    if (event.key === 'Enter' || event.key === ' ') {
      captureActiveElementOnClick(event);
    }
  });
  __webpack_require__.g._googlesitekitModalFocusTrackerInitialized = true;
}
setupFocusTracker();
function RefocusableModalDialog({
  dialogActive = false,
  refocusQuerySelector = null,
  ...modalDialogProps
}) {
  const handleElementRefocus = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_3__.useCallback)(() => {
    setTimeout(() => {
      const elementToFocus = refocusQuerySelector ? document.querySelector(refocusQuerySelector) : previouslyClickedElement;
      if (elementToFocus && document.body.contains(elementToFocus)) {
        elementToFocus.focus();
      }
      if (!refocusQuerySelector) {
        previouslyClickedElement = null;
      }
    });
  }, [refocusQuerySelector]);
  const previousDialogActive = (0,_wordpress_compose__WEBPACK_IMPORTED_MODULE_4__["default"])(dialogActive);
  // Handle re-focus of the button which triggered the modal.
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_3__.useEffect)(() => {
    if (previousDialogActive === true && dialogActive === false) {
      handleElementRefocus();
    }
    return () => {
      // In majority of cases the modal is conditionally rendered, so dialogActive
      // will not be passed, as component will be unmounted/removed from the DOM.
      handleElementRefocus();
    };
  }, [previousDialogActive, dialogActive, handleElementRefocus]);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)(_ModalDialog__WEBPACK_IMPORTED_MODULE_1__["default"], {
    dialogActive: dialogActive,
    ...modalDialogProps
  });
}
RefocusableModalDialog.propTypes = {
  dialogActive: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().bool),
  refocusQuerySelector: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().string),
  ...googlesitekit_components__WEBPACK_IMPORTED_MODULE_0__.Dialog.propTypes
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (RefocusableModalDialog);

/***/ }),

/***/ "./js/components/ReportError.js":
/*!**************************************!*\
  !*** ./js/components/ReportError.js ***!
  \**************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ ReportError)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_13___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_13__);
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! lodash */ "../node_modules/lodash/lodash.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/googlesitekit/modules/datastore/constants */ "./js/googlesitekit/modules/datastore/constants.js");
/* harmony import */ var _js_util_errors__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/util/errors */ "./js/util/errors.js");
/* harmony import */ var _js_util_insufficient_permissions_error_description__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/util/insufficient-permissions-error-description */ "./js/util/insufficient-permissions-error-description.js");
/* harmony import */ var _js_util_purify__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @/js/util/purify */ "./js/util/purify.js");
/* harmony import */ var _notifications_CTA__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./notifications/CTA */ "./js/components/notifications/CTA.js");
/* harmony import */ var _ReportErrorActions__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./ReportErrorActions */ "./js/components/ReportErrorActions.js");
/* harmony import */ var _js_hooks_useViewOnly__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @/js/hooks/useViewOnly */ "./js/hooks/useViewOnly.js");
/* harmony import */ var _ErrorNotice__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./ErrorNotice */ "./js/components/ErrorNotice.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * ReportError component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */










function ReportError({
  moduleSlug,
  error
}) {
  const isViewOnly = (0,_js_hooks_useViewOnly__WEBPACK_IMPORTED_MODULE_9__["default"])();
  const module = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.useSelect)(select => select(_js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_MODULES).getModule(moduleSlug));
  const errors = Array.isArray(error) ? error : [error];
  let title;
  function getMessage(err) {
    if ((0,_js_util_errors__WEBPACK_IMPORTED_MODULE_4__.isInsufficientPermissionsError)(err)) {
      if (isViewOnly) {
        title = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.sprintf)(/* translators: %s: module name */
        (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Access lost to %s', 'google-site-kit'), module?.name);
        return (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.sprintf)(/* translators: %s: module name */
        (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('The administrator sharing this module with you has lost access to the %s service, so you won’t be able to see stats from it on the Site Kit dashboard. You can contact them or another administrator to restore access.', 'google-site-kit'), module?.name);
      }
      title = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.sprintf)(/* translators: %s: module name */
      (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Insufficient permissions in %s', 'google-site-kit'), module?.name);
      return (0,_js_util_insufficient_permissions_error_description__WEBPACK_IMPORTED_MODULE_5__.getInsufficientPermissionsErrorDescription)(err.message, module);
    }
    return (0,_js_util_errors__WEBPACK_IMPORTED_MODULE_4__.getReportErrorMessage)(err);
  }
  const uniqueErrors = (0,lodash__WEBPACK_IMPORTED_MODULE_0__.uniqWith)(errors.map(err => ({
    ...err,
    message: getMessage(err),
    reconnectURL: err.data?.reconnectURL
  })), (errorA, errorB) => errorA.message === errorB.message && errorA.reconnectURL === errorB.reconnectURL);
  const hasInsufficientPermissionsError = errors.some(err => (0,_js_util_errors__WEBPACK_IMPORTED_MODULE_4__.isInsufficientPermissionsError)(err));
  if (!hasInsufficientPermissionsError && uniqueErrors.length === 1) {
    title = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.sprintf)(/* translators: %s: module name */
    (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Data error in %s', 'google-site-kit'), module?.name);
  } else if (!hasInsufficientPermissionsError && uniqueErrors.length > 1) {
    title = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.sprintf)(/* translators: %s: module name */
    (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Data errors in %s', 'google-site-kit'), module?.name);
  }
  const description = /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_wordpress_element__WEBPACK_IMPORTED_MODULE_12__.Fragment, {
    children: uniqueErrors.map(errorForNotice => {
      const reconnectURL = errorForNotice?.data?.reconnectURL;
      return reconnectURL ? /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_ErrorNotice__WEBPACK_IMPORTED_MODULE_10__["default"], {
        error: errorForNotice,
        message: errorForNotice.message
      }, errorForNotice.message) : /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("p", {
        children: _js_util_purify__WEBPACK_IMPORTED_MODULE_6__.purify.sanitize(errorForNotice.message, {
          // Ensures no HTML tags are passed as they would be
          // escaped by React and appear as strings.
          ALLOWED_TAGS: []
        })
      }, errorForNotice.message);
    })
  });
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_notifications_CTA__WEBPACK_IMPORTED_MODULE_7__["default"], {
    title: title,
    description: description,
    error: true,
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_ReportErrorActions__WEBPACK_IMPORTED_MODULE_8__["default"], {
      moduleSlug: moduleSlug,
      error: error
    })
  });
}
ReportError.propTypes = {
  moduleSlug: (prop_types__WEBPACK_IMPORTED_MODULE_13___default().string).isRequired,
  error: prop_types__WEBPACK_IMPORTED_MODULE_13___default().oneOfType([prop_types__WEBPACK_IMPORTED_MODULE_13___default().arrayOf((prop_types__WEBPACK_IMPORTED_MODULE_13___default().object)), (prop_types__WEBPACK_IMPORTED_MODULE_13___default().object)]).isRequired
};

/***/ }),

/***/ "./js/components/ReportErrorActions.js":
/*!*********************************************!*\
  !*** ./js/components/ReportErrorActions.js ***!
  \*********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ ReportErrorActions)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_11___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_11__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/@wordpress/element/build-module/create-interpolate-element.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! googlesitekit-components */ "googlesitekit-components");
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_components__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/googlesitekit/datastore/site/constants */ "./js/googlesitekit/datastore/site/constants.js");
/* harmony import */ var _js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/googlesitekit/modules/datastore/constants */ "./js/googlesitekit/modules/datastore/constants.js");
/* harmony import */ var _js_util_errors__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/util/errors */ "./js/util/errors.js");
/* harmony import */ var _js_hooks_useViewOnly__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @/js/hooks/useViewOnly */ "./js/hooks/useViewOnly.js");
/* harmony import */ var _Link__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./Link */ "./js/components/Link.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * ReportErrorActions component.
 *
 * Site Kit by Google, Copyright 2022 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */








function ReportErrorActions(props) {
  const {
    moduleSlug,
    error,
    GetHelpLink,
    hideGetHelpLink,
    buttonVariant,
    onRetry,
    onRequestAccess,
    getHelpClassName,
    RequestAccessButton,
    RetryButton
  } = props;
  const isViewOnly = (0,_js_hooks_useViewOnly__WEBPACK_IMPORTED_MODULE_6__["default"])();
  const storeName = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_4__.CORE_MODULES).getModuleStoreName(moduleSlug));
  const requestAccessURL = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => typeof select(storeName)?.getServiceEntityAccessURL === 'function' ? select(storeName).getServiceEntityAccessURL() : null);
  const errors = Array.isArray(error) ? error : [error];
  const errorsWithSelectorData = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => errors.map(err => {
    const selectorData = select(storeName)?.getSelectorDataForError(err);
    return {
      ...err,
      selectorData
    };
  }));
  const retryableErrors = errorsWithSelectorData?.filter(err => (0,_js_util_errors__WEBPACK_IMPORTED_MODULE_5__.isErrorRetryable)(err, err.selectorData) && err.selectorData.name === 'getReport');
  const showRetry = !!retryableErrors.length;
  const errorTroubleshootingLinkURL = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => {
    const err = {
      ...(showRetry ? retryableErrors[0] : errors[0])
    };
    if ((0,_js_util_errors__WEBPACK_IMPORTED_MODULE_5__.isInsufficientPermissionsError)(err)) {
      err.code = `${moduleSlug}_insufficient_permissions`;
    }
    return select(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_SITE).getErrorTroubleshootingLinkURL(err);
  });
  const dispatch = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useDispatch)();
  const hasInsufficientPermissionsError = errors.some(err => (0,_js_util_errors__WEBPACK_IMPORTED_MODULE_5__.isInsufficientPermissionsError)(err));
  const handleRetry = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.useCallback)(() => {
    retryableErrors.forEach(err => {
      const {
        selectorData
      } = err;
      dispatch(selectorData.storeName).invalidateResolution(selectorData.name, selectorData.args);
    });
    onRetry?.();
  }, [dispatch, retryableErrors, onRetry]);
  const showRequestAccessURL = requestAccessURL && hasInsufficientPermissionsError && !isViewOnly;
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsxs)("div", {
    className: "googlesitekit-report-error-actions",
    children: [showRequestAccessURL && (typeof RequestAccessButton === 'function' ? /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(RequestAccessButton, {
      requestAccessURL: requestAccessURL
    }) : /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_2__.Button, {
      onClick: onRequestAccess,
      href: requestAccessURL,
      target: "_blank",
      danger: buttonVariant === 'danger',
      tertiary: buttonVariant === 'tertiary',
      children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Request access', 'google-site-kit')
    })), showRetry && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsxs)(_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.Fragment, {
      children: [typeof RetryButton === 'function' ? /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(RetryButton, {
        handleRetry: handleRetry
      }) : /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_2__.Button, {
        onClick: handleRetry,
        danger: buttonVariant === 'danger',
        tertiary: buttonVariant === 'tertiary',
        children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Retry', 'google-site-kit')
      }), !hideGetHelpLink && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)("span", {
        className: "googlesitekit-error-retry-text",
        children: (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_10__["default"])((0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Retry didn’t work? <HelpLink />', 'google-site-kit'), {
          HelpLink: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(_Link__WEBPACK_IMPORTED_MODULE_7__["default"], {
            href: errorTroubleshootingLinkURL,
            external: true,
            hideExternalIndicator: true,
            children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Get help', 'google-site-kit')
          })
        })
      })]
    }), !showRetry && !hideGetHelpLink && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)("div", {
      className: getHelpClassName,
      children: typeof GetHelpLink === 'function' ? /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(GetHelpLink, {
        linkURL: errorTroubleshootingLinkURL
      }) : /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(_Link__WEBPACK_IMPORTED_MODULE_7__["default"], {
        href: errorTroubleshootingLinkURL,
        external: true,
        hideExternalIndicator: true,
        children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Get help', 'google-site-kit')
      })
    })]
  });
}
ReportErrorActions.propTypes = {
  moduleSlug: (prop_types__WEBPACK_IMPORTED_MODULE_11___default().string).isRequired,
  error: prop_types__WEBPACK_IMPORTED_MODULE_11___default().oneOfType([prop_types__WEBPACK_IMPORTED_MODULE_11___default().arrayOf((prop_types__WEBPACK_IMPORTED_MODULE_11___default().object)), (prop_types__WEBPACK_IMPORTED_MODULE_11___default().object)]).isRequired,
  GetHelpLink: (prop_types__WEBPACK_IMPORTED_MODULE_11___default().elementType),
  hideGetHelpLink: (prop_types__WEBPACK_IMPORTED_MODULE_11___default().bool),
  buttonVariant: (prop_types__WEBPACK_IMPORTED_MODULE_11___default().string),
  onRetry: (prop_types__WEBPACK_IMPORTED_MODULE_11___default().func),
  onRequestAccess: (prop_types__WEBPACK_IMPORTED_MODULE_11___default().func),
  getHelpClassName: (prop_types__WEBPACK_IMPORTED_MODULE_11___default().string),
  RequestAccessButton: (prop_types__WEBPACK_IMPORTED_MODULE_11___default().elementType),
  RetryButton: (prop_types__WEBPACK_IMPORTED_MODULE_11___default().elementType)
};

/***/ }),

/***/ "./js/components/ReportZero.js":
/*!*************************************!*\
  !*** ./js/components/ReportZero.js ***!
  \*************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ ReportZero)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/googlesitekit/modules/datastore/constants */ "./js/googlesitekit/modules/datastore/constants.js");
/* harmony import */ var _notifications_CTA__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./notifications/CTA */ "./js/components/notifications/CTA.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * ReportZero component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */




function ReportZero({
  moduleSlug
}) {
  const module = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_2__.CORE_MODULES).getModule(moduleSlug));
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(_notifications_CTA__WEBPACK_IMPORTED_MODULE_3__["default"], {
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.sprintf)(/* translators: %s: Module name */
    (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('%s Gathering Data', 'google-site-kit'), module?.name),
    description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.sprintf)(/* translators: %s: Module name */
    (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('%s data is not yet available, please check back later', 'google-site-kit'), module?.name)
  });
}
ReportZero.propTypes = {
  moduleSlug: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().string).isRequired
};

/***/ }),

/***/ "./js/components/Root/ViewContextContext.js":
/*!**************************************************!*\
  !*** ./js/components/Root/ViewContextContext.js ***!
  \**************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Consumer: () => (/* binding */ Consumer),
/* harmony export */   Provider: () => (/* binding */ Provider),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/**
 * View Context context for React components.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */

const ViewContextContext = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createContext)('');
const {
  Consumer,
  Provider
} = ViewContextContext;
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ViewContextContext);

/***/ }),

/***/ "./js/components/SelectionBox.js":
/*!***************************************!*\
  !*** ./js/components/SelectionBox.js ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ SelectionBox)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-components */ "googlesitekit-components");
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * SelectionBox component.
 *
 * Site Kit by Google, Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * Internal dependencies
 */


function SelectionBox({
  badge,
  checked,
  children,
  disabled,
  id,
  onChange,
  title,
  value
}) {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("div", {
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-selection-box', {
      'googlesitekit-selection-box--disabled': disabled
    }),
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__.Checkbox, {
      checked: checked,
      description: children,
      disabled: disabled,
      id: id,
      name: id,
      onChange: onChange,
      value: value,
      badge: badge,
      children: title
    })
  });
}
SelectionBox.propTypes = {
  badge: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().node),
  checked: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().bool),
  children: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().node),
  disabled: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().bool),
  id: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  onChange: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().func),
  title: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  value: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string)
};

/***/ }),

/***/ "./js/components/SelectionPanel/SelectionPanel.js":
/*!********************************************************!*\
  !*** ./js/components/SelectionPanel/SelectionPanel.js ***!
  \********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ SelectionPanel)
/* harmony export */ });
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _js_components_SideSheet__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/components/SideSheet */ "./js/components/SideSheet.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Selection Panel component.
 *
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * Internal dependencies
 */


function SelectionPanel({
  children,
  isOpen,
  isLoading,
  onOpen,
  closePanel,
  className
}) {
  const classNameSelector = className?.split(/\s+/).map(name => `.${name}`).join('');
  const initialFocus = classNameSelector ? `${classNameSelector} .googlesitekit-selection-panel-item .googlesitekit-selection-box input` : '.googlesitekit-selection-panel-item .googlesitekit-selection-box input';
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)(_js_components_SideSheet__WEBPACK_IMPORTED_MODULE_1__["default"], {
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-selection-panel', className),
    isOpen: isOpen,
    isLoading: isLoading,
    onOpen: onOpen,
    closeSheet: closePanel,
    focusTrapOptions: {
      initialFocus
    },
    children: children
  });
}
SelectionPanel.propTypes = {
  children: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().node),
  isOpen: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().bool),
  isLoading: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().bool),
  onOpen: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().func),
  closePanel: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().func),
  className: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string)
};

/***/ }),

/***/ "./js/components/SelectionPanel/SelectionPanelError.js":
/*!*************************************************************!*\
  !*** ./js/components/SelectionPanel/SelectionPanelError.js ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ SelectionPanelError)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _js_util_geometry__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @/js/util/geometry */ "./js/util/geometry.js");
/* harmony import */ var _js_components_ErrorNotice__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/components/ErrorNotice */ "./js/components/ErrorNotice.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Selection Panel Error
 *
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */



function SelectionPanelError({
  error,
  noPrefix = true,
  skipRetryMessage = true
}) {
  const noticeRef = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_3__.useRef)();

  // Scroll the metric item (normally the last item in the panel)
  // being overlapped by the error.
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_3__.useEffect)(() => {
    if (error) {
      const currentFocusedElement = __webpack_require__.g.document.activeElement;
      if (currentFocusedElement && currentFocusedElement.closest('.googlesitekit-selection-panel-item') && (0,_js_util_geometry__WEBPACK_IMPORTED_MODULE_0__.elementsOverlap)(noticeRef.current, currentFocusedElement)) {
        currentFocusedElement.scrollIntoView();
      }
    }
  }, [error]);
  if (!error) {
    return null;
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("div", {
    ref: noticeRef,
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)(_js_components_ErrorNotice__WEBPACK_IMPORTED_MODULE_1__["default"], {
      className: "googlesitekit-notice--square googlesitekit-selection-panel-error",
      error: error,
      noPrefix: noPrefix,
      skipRetryMessage: skipRetryMessage
    })
  });
}
SelectionPanelError.propTypes = {
  error: prop_types__WEBPACK_IMPORTED_MODULE_4___default().shape({
    message: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().string)
  }),
  noPrefix: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().bool),
  skipRetryMessage: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().bool)
};

/***/ }),

/***/ "./js/components/SelectionPanel/SelectionPanelFooter.js":
/*!**************************************************************!*\
  !*** ./js/components/SelectionPanel/SelectionPanelFooter.js ***!
  \**************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ SelectionPanelFooter)
/* harmony export */ });
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! lodash */ "../node_modules/lodash/lodash.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_11___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_11__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/@wordpress/element/build-module/create-interpolate-element.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! googlesitekit-components */ "googlesitekit-components");
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_components__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _js_util__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/util */ "./js/util/index.js");
/* harmony import */ var _js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/modules/analytics-4/datastore/constants */ "./js/modules/analytics-4/datastore/constants.js");
/* harmony import */ var _js_components_PreviewBlock__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @/js/components/PreviewBlock */ "./js/components/PreviewBlock.js");
/* harmony import */ var _js_components_Notice__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @/js/components/Notice */ "./js/components/Notice/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Selection Panel Footer component.
 *
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */







function SelectionPanelFooter({
  savedItemSlugs = [],
  selectedItemSlugs = [],
  saveSettings = () => {},
  itemLimitError,
  minSelectedItemCount = 0,
  maxSelectedItemCount = 0,
  isBusy,
  onSaveSuccess = () => {},
  onCancel = () => {},
  isOpen,
  closePanel = () => {}
}) {
  const [finalButtonText, setFinalButtonText] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.useState)(null);
  const [wasSaved, setWasSaved] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.useState)(false);
  const isLoading = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.useSelect)(select => select(_js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_5__.MODULES_ANALYTICS_4).isFetchingSyncAvailableAudiences());
  const haveSettingsChanged = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.useMemo)(() => {
    // Arrays need to be sorted to match in `isEqual`.
    return !(0,lodash__WEBPACK_IMPORTED_MODULE_0__.isEqual)((0,_js_util__WEBPACK_IMPORTED_MODULE_4__.safelySort)(selectedItemSlugs), (0,_js_util__WEBPACK_IMPORTED_MODULE_4__.safelySort)(savedItemSlugs));
  }, [savedItemSlugs, selectedItemSlugs]);
  const currentButtonText = savedItemSlugs?.length > 0 && haveSettingsChanged ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Apply changes', 'google-site-kit') : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Save selection', 'google-site-kit');
  const onSaveClick = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.useCallback)(async () => {
    const {
      error
    } = await saveSettings(selectedItemSlugs);
    if (!error) {
      onSaveSuccess();

      // Close the panel after saving.
      closePanel();

      // Lock the button label while panel is closing.
      setFinalButtonText(currentButtonText);
      setWasSaved(true);
    }
  }, [saveSettings, selectedItemSlugs, onSaveSuccess, closePanel, currentButtonText]);
  const onCancelClick = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.useCallback)(() => {
    closePanel();
    onCancel();
  }, [closePanel, onCancel]);
  const [prevIsOpen, setPrevIsOpen] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.useState)(null);
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.useEffect)(() => {
    if (prevIsOpen !== null) {
      // If current isOpen is true, and different from prevIsOpen
      // meaning it transitioned from false to true and it is not
      // in closing transition, we should reset the button label
      // locked when save button was clicked.
      if (prevIsOpen !== isOpen) {
        if (isOpen) {
          setFinalButtonText(null);
          setWasSaved(false);
        }
      }
    }
    setPrevIsOpen(isOpen);
  }, [isOpen, prevIsOpen]);
  const selectedItemCount = selectedItemSlugs?.length || 0;
  const itemCountElement = isLoading ? /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(_js_components_PreviewBlock__WEBPACK_IMPORTED_MODULE_6__["default"], {
    width: "89px",
    height: "20px"
  }) : /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)("p", {
    className: "googlesitekit-selection-panel-footer__item-count",
    children: (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_10__["default"])((0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.sprintf)(/* translators: 1: Number of selected items. 2: Maximum number of items that can be selected. */
    (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('%1$d selected <MaxCount>(up to %2$d)</MaxCount>', 'google-site-kit'), selectedItemCount, maxSelectedItemCount), {
      MaxCount: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)("span", {
        className: "googlesitekit-selection-panel-footer__item-count--max-count"
      })
    })
  });
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)("footer", {
    className: "googlesitekit-selection-panel-footer",
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsxs)("div", {
      className: "googlesitekit-selection-panel-footer__content",
      children: [haveSettingsChanged && itemLimitError ? /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(_js_components_Notice__WEBPACK_IMPORTED_MODULE_7__["default"], {
        type: _js_components_Notice__WEBPACK_IMPORTED_MODULE_7__["default"].TYPES.ERROR,
        description: itemLimitError
      }) : itemCountElement, /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsxs)("div", {
        className: "googlesitekit-selection-panel-footer__actions",
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_3__.Button, {
          onClick: onCancelClick,
          disabled: isBusy,
          tertiary: true,
          children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Cancel', 'google-site-kit')
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_3__.SpinnerButton, {
          onClick: onSaveClick,
          isSaving: isBusy,
          disabled: selectedItemCount < minSelectedItemCount || selectedItemCount > maxSelectedItemCount || isBusy || !isOpen && wasSaved,
          children: finalButtonText || currentButtonText
        })]
      })]
    })
  });
}
SelectionPanelFooter.propTypes = {
  savedItemSlugs: (prop_types__WEBPACK_IMPORTED_MODULE_11___default().array),
  selectedItemSlugs: (prop_types__WEBPACK_IMPORTED_MODULE_11___default().array),
  saveSettings: (prop_types__WEBPACK_IMPORTED_MODULE_11___default().func),
  itemLimitError: (prop_types__WEBPACK_IMPORTED_MODULE_11___default().string),
  minSelectedItemCount: (prop_types__WEBPACK_IMPORTED_MODULE_11___default().number),
  maxSelectedItemCount: (prop_types__WEBPACK_IMPORTED_MODULE_11___default().number),
  isBusy: (prop_types__WEBPACK_IMPORTED_MODULE_11___default().bool),
  onSaveSuccess: (prop_types__WEBPACK_IMPORTED_MODULE_11___default().func),
  onCancel: (prop_types__WEBPACK_IMPORTED_MODULE_11___default().func),
  isOpen: (prop_types__WEBPACK_IMPORTED_MODULE_11___default().bool),
  closePanel: (prop_types__WEBPACK_IMPORTED_MODULE_11___default().func)
};

/***/ }),

/***/ "./js/components/SelectionPanel/SelectionPanelHeader.js":
/*!**************************************************************!*\
  !*** ./js/components/SelectionPanel/SelectionPanelHeader.js ***!
  \**************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ SelectionPanelHeader)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _js_components_Link__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @/js/components/Link */ "./js/components/Link.js");
/* harmony import */ var _svg_icons_close_svg__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/svg/icons/close.svg */ "./svg/icons/close.svg");
/* harmony import */ var _js_components_Typography__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/components/Typography */ "./js/components/Typography/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Selection Panel Header component.
 *
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * Internal dependencies
 */




function SelectionPanelHeader({
  children,
  title,
  onCloseClick
}) {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("header", {
    className: "googlesitekit-selection-panel-header",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
      className: "googlesitekit-selection-panel-header__row",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_js_components_Typography__WEBPACK_IMPORTED_MODULE_2__["default"], {
        as: "h3",
        size: "small",
        type: "headline",
        children: title
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_js_components_Link__WEBPACK_IMPORTED_MODULE_0__["default"], {
        className: "googlesitekit-selection-panel-header__close",
        onClick: onCloseClick,
        linkButton: true,
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_svg_icons_close_svg__WEBPACK_IMPORTED_MODULE_1__["default"], {
          width: "15",
          height: "15"
        })
      })]
    }), children]
  });
}
SelectionPanelHeader.propTypes = {
  children: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().node),
  title: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().string),
  onCloseClick: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().func)
};

/***/ }),

/***/ "./js/components/SelectionPanel/SelectionPanelItem.js":
/*!************************************************************!*\
  !*** ./js/components/SelectionPanel/SelectionPanelItem.js ***!
  \************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ SelectionPanelItem)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _js_components_SelectionBox__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/components/SelectionBox */ "./js/components/SelectionBox.js");
/* harmony import */ var _js_components_Badge__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/components/Badge */ "./js/components/Badge.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Selection Panel Item component.
 *
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */



function SelectionPanelItem({
  children,
  id,
  slug,
  title,
  description,
  isItemSelected,
  isItemDisabled,
  onCheckboxChange,
  subtitle,
  suffix,
  badge,
  isNewlyDetected
}) {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
    className: "googlesitekit-selection-panel-item",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)(_js_components_SelectionBox__WEBPACK_IMPORTED_MODULE_1__["default"], {
      badge: badge,
      checked: isItemSelected,
      disabled: isItemDisabled,
      id: id,
      onChange: onCheckboxChange,
      title: title,
      value: slug,
      children: [subtitle && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("span", {
        className: "googlesitekit-selection-panel-item__subtitle",
        children: subtitle
      }), description, children]
    }), isNewlyDetected && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_js_components_Badge__WEBPACK_IMPORTED_MODULE_2__["default"], {
      label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('New', 'google-site-kit')
    }), suffix && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("span", {
      className: "googlesitekit-selection-panel-item__suffix",
      children: suffix
    })]
  });
}
SelectionPanelItem.propTypes = {
  children: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().node),
  id: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().string),
  slug: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().string),
  title: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().string),
  description: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().string),
  isItemSelected: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().bool),
  isItemDisabled: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().bool),
  onCheckboxChange: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().func),
  subtitle: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().string),
  suffix: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().node),
  badge: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().node),
  isNewlyDetected: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().bool)
};

/***/ }),

/***/ "./js/components/SelectionPanel/SelectionPanelItems.js":
/*!*************************************************************!*\
  !*** ./js/components/SelectionPanel/SelectionPanelItems.js ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ SelectionPanelItems)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Selection Panel Items component.
 *
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */



function SelectionPanelItems({
  currentSelectionTitle = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Current selection', 'google-site-kit'),
  availableItemsTitle = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Additional items', 'google-site-kit'),
  savedItemSlugs = [],
  availableSavedItems = {},
  availableUnsavedItems = {},
  ItemComponent,
  notice
}) {
  function renderItems(items) {
    return Object.keys(items).map(slug => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)(ItemComponent, {
      slug: slug,
      savedItemSlugs: savedItemSlugs,
      ...items[slug]
    }, slug));
  }
  const availableUnsavedItemsCount = Object.keys(availableUnsavedItems).length;
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsxs)("div", {
    className: "googlesitekit-selection-panel-items",
    children: [
    // Split list into two sections with sub-headings for current selection and
    // additional items if there are already saved items.
    savedItemSlugs.length !== 0 && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsxs)(_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.Fragment, {
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("p", {
        className: "googlesitekit-selection-panel-items__subheading",
        children: currentSelectionTitle
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", {
        className: "googlesitekit-selection-panel-items__subsection",
        children: renderItems(availableSavedItems)
      }), availableUnsavedItemsCount > 0 && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("p", {
        className: "googlesitekit-selection-panel-items__subheading",
        children: availableItemsTitle
      })]
    }), availableUnsavedItemsCount > 0 && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", {
      className: "googlesitekit-selection-panel-items__subsection",
      children: renderItems(availableUnsavedItems)
    }), notice]
  });
}
SelectionPanelItems.propTypes = {
  currentSelectionTitle: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  availableItemsTitle: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  savedItemSlugs: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().array),
  availableSavedItems: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().object),
  availableUnsavedItems: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().object),
  ItemComponent: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().elementType),
  notice: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().node)
};

/***/ }),

/***/ "./js/components/SelectionPanel/index.js":
/*!***********************************************!*\
  !*** ./js/components/SelectionPanel/index.js ***!
  \***********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   SelectionPanelFooter: () => (/* reexport safe */ _SelectionPanelFooter__WEBPACK_IMPORTED_MODULE_4__["default"]),
/* harmony export */   SelectionPanelHeader: () => (/* reexport safe */ _SelectionPanelHeader__WEBPACK_IMPORTED_MODULE_1__["default"]),
/* harmony export */   SelectionPanelItem: () => (/* reexport safe */ _SelectionPanelItem__WEBPACK_IMPORTED_MODULE_2__["default"]),
/* harmony export */   SelectionPanelItems: () => (/* reexport safe */ _SelectionPanelItems__WEBPACK_IMPORTED_MODULE_3__["default"]),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _SelectionPanel__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./SelectionPanel */ "./js/components/SelectionPanel/SelectionPanel.js");
/* harmony import */ var _SelectionPanelHeader__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./SelectionPanelHeader */ "./js/components/SelectionPanel/SelectionPanelHeader.js");
/* harmony import */ var _SelectionPanelItem__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./SelectionPanelItem */ "./js/components/SelectionPanel/SelectionPanelItem.js");
/* harmony import */ var _SelectionPanelItems__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./SelectionPanelItems */ "./js/components/SelectionPanel/SelectionPanelItems.js");
/* harmony import */ var _SelectionPanelFooter__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./SelectionPanelFooter */ "./js/components/SelectionPanel/SelectionPanelFooter.js");
/**
 * Selection Panel components.
 *
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Internal dependencies
 */





/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_SelectionPanel__WEBPACK_IMPORTED_MODULE_0__["default"]);

/***/ }),

/***/ "./js/components/SideSheet.js":
/*!************************************!*\
  !*** ./js/components/SideSheet.js ***!
  \************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ SideSheet)
/* harmony export */ });
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var focus_trap_react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! focus-trap-react */ "../node_modules/focus-trap-react/dist/focus-trap-react.js");
/* harmony import */ var focus_trap_react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(focus_trap_react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var react_use__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! react-use */ "../node_modules/react-use/esm/useClickAway.js");
/* harmony import */ var react_use__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! react-use */ "../node_modules/react-use/esm/useKey.js");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _wordpress_keycodes__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @wordpress/keycodes */ "../node_modules/@wordpress/keycodes/build-module/index.js");
/* harmony import */ var _Portal__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./Portal */ "./js/components/Portal.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * SideSheet component
 *
 * This component is named after Material Side Sheets
 * (https://m3.material.io/components/side-sheets/overview), which is
 * planned but not yet implemented for Web. Once available, we could look
 * into moving this to `googlesitekit-components` and replacing it with
 * the Material implementation.
 *
 * Site Kit by Google, Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */





/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */


function SideSheet({
  className,
  children,
  isOpen,
  isLoading,
  onOpen = () => {},
  closeSheet = () => {},
  focusTrapOptions = {}
}) {
  const sideSheetRef = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_4__.useRef)();
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_4__.useEffect)(() => {
    if (isOpen) {
      onOpen();
      document.body.classList.add('googlesitekit-side-sheet-scroll-lock');
    } else {
      document.body.classList.remove('googlesitekit-side-sheet-scroll-lock');
    }
  }, [isOpen, onOpen]);
  (0,react_use__WEBPACK_IMPORTED_MODULE_5__["default"])(sideSheetRef, closeSheet);
  (0,react_use__WEBPACK_IMPORTED_MODULE_6__["default"])(event => isOpen && _wordpress_keycodes__WEBPACK_IMPORTED_MODULE_7__.ESCAPE === event.keyCode, closeSheet);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)(_Portal__WEBPACK_IMPORTED_MODULE_2__["default"], {
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)((focus_trap_react__WEBPACK_IMPORTED_MODULE_1___default()), {
      active: !!isOpen && !isLoading,
      focusTrapOptions: {
        fallbackFocus: 'body',
        ...focusTrapOptions
      },
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("section", {
        ref: sideSheetRef,
        className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-side-sheet', className, {
          'googlesitekit-side-sheet--open': isOpen
        }),
        role: "dialog",
        "aria-modal": "true",
        "aria-hidden": !isOpen,
        tabIndex: "0",
        children: children
      })
    }), isOpen && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("span", {
      className: "googlesitekit-side-sheet-overlay"
    })]
  });
}
SideSheet.propTypes = {
  className: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().string),
  children: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().node),
  isOpen: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().bool),
  isLoading: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().bool),
  onOpen: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().func),
  closeSheet: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().func),
  focusTrapOptions: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().object)
};

/***/ }),

/***/ "./js/components/SourceLink.js":
/*!*************************************!*\
  !*** ./js/components/SourceLink.js ***!
  \*************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/@wordpress/element/build-module/create-interpolate-element.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _Link__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./Link */ "./js/components/Link.js");
/* harmony import */ var _js_hooks_useViewOnly__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/hooks/useViewOnly */ "./js/hooks/useViewOnly.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * SourceLink component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */



function SourceLink({
  name,
  href,
  className,
  external
}) {
  const viewOnlyDashboard = (0,_js_hooks_useViewOnly__WEBPACK_IMPORTED_MODULE_3__["default"])();
  if (viewOnlyDashboard) {
    return null;
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("div", {
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-source-link', className),
    children: (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_5__["default"])((0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.sprintf)(/* translators: %s: source link */
    (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Source: %s', 'google-site-kit'), `<a>${name}</a>`), {
      a: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(_Link__WEBPACK_IMPORTED_MODULE_2__["default"], {
        href: href,
        external: external
      }, "link")
    })
  });
}
SourceLink.propTypes = {
  name: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().string),
  href: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().string),
  className: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().string),
  external: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().bool)
};
SourceLink.defaultProps = {
  name: '',
  href: '',
  className: '',
  external: false
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (SourceLink);

/***/ }),

/***/ "./js/components/TourTooltip.js":
/*!**************************************!*\
  !*** ./js/components/TourTooltip.js ***!
  \**************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ TourTooltip)
/* harmony export */ });
/* harmony import */ var _material_react_card__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @material/react-card */ "../node_modules/@material/react-card/dist/index.js");
/* harmony import */ var _material_react_card__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_material_react_card__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! googlesitekit-components */ "googlesitekit-components");
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_components__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _js_util_create_incremental_array_by_size__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/util/create-incremental-array-by-size */ "./js/util/create-incremental-array-by-size.js");
/* harmony import */ var _svg_icons_close_svg__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/svg/icons/close.svg */ "./svg/icons/close.svg");
/* harmony import */ var _Typography__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./Typography */ "./js/components/Typography/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * TourTooltip component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */




/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */





function TourTooltip({
  backProps,
  closeProps,
  index,
  primaryProps,
  size,
  step,
  tooltipProps
}) {
  const indicatorArray = size > 1 ? (0,_js_util_create_incremental_array_by_size__WEBPACK_IMPORTED_MODULE_4__.createIncrementalArrayBySize)(size) : [];
  function getIndicatorClassName(indicatorIndex) {
    return classnames__WEBPACK_IMPORTED_MODULE_1___default()('googlesitekit-tooltip-indicator', {
      active: indicatorIndex === index
    });
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)("div", {
    className: classnames__WEBPACK_IMPORTED_MODULE_1___default()('googlesitekit-tour-tooltip', step.className),
    ...tooltipProps,
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsxs)((_material_react_card__WEBPACK_IMPORTED_MODULE_0___default()), {
      className: "googlesitekit-tooltip-card",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsxs)("div", {
        className: "googlesitekit-tooltip-body",
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_Typography__WEBPACK_IMPORTED_MODULE_6__["default"], {
          as: "h2",
          className: "googlesitekit-tooltip-title",
          size: "medium",
          type: "title",
          children: step.title
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)("div", {
          className: "googlesitekit-tooltip-content",
          children: step.content
        })]
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsxs)(_material_react_card__WEBPACK_IMPORTED_MODULE_0__.CardActions, {
        className: "googlesitekit-tooltip-actions",
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)("ul", {
          className: "googlesitekit-tooltip-indicators",
          children: indicatorArray.map(indicatorIndex => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)("li", {
            className: getIndicatorClassName(indicatorIndex)
          }, `indicator-${indicatorIndex}`))
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsxs)("div", {
          className: "googlesitekit-tooltip-buttons",
          children: [index !== 0 && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_3__.Button, {
            className: "googlesitekit-tooltip-button",
            text: true,
            ...backProps,
            children: backProps.title
          }), step.cta, primaryProps.title && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_3__.Button, {
            className: "googlesitekit-tooltip-button",
            text: true,
            ...primaryProps,
            children: primaryProps.title
          })]
        })]
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_3__.Button, {
        className: "googlesitekit-tooltip-close",
        icon: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_svg_icons_close_svg__WEBPACK_IMPORTED_MODULE_5__["default"], {
          width: "14",
          height: "14"
        }),
        onClick: closeProps.onClick,
        "aria-label": (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Close', 'google-site-kit'),
        text: true,
        hideTooltipTitle: true
      })]
    })
  });
}

/**
 * All props are provided directly from `react-joyride`, intended for custom components.
 *
 * @since 1.28.0
 * @see {@link https://docs.react-joyride.com/custom-components#props-1}.
 */
TourTooltip.propTypes = {
  backProps: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().object).isRequired,
  closeProps: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().object).isRequired,
  index: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().number).isRequired,
  isLastStep: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().bool).isRequired,
  primaryProps: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().object).isRequired,
  size: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().number).isRequired,
  step: prop_types__WEBPACK_IMPORTED_MODULE_8___default().shape({
    content: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().node),
    title: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().node),
    cta: prop_types__WEBPACK_IMPORTED_MODULE_8___default().oneOfType([(prop_types__WEBPACK_IMPORTED_MODULE_8___default().element), (prop_types__WEBPACK_IMPORTED_MODULE_8___default().bool)]),
    className: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().string)
  }).isRequired,
  tooltipProps: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().object).isRequired
};

/***/ }),

/***/ "./js/components/TourTooltips.js":
/*!***************************************!*\
  !*** ./js/components/TourTooltips.js ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   GA_ACTIONS: () => (/* binding */ GA_ACTIONS),
/* harmony export */   "default": () => (/* binding */ TourTooltips),
/* harmony export */   floaterProps: () => (/* binding */ floaterProps),
/* harmony export */   joyrideStyles: () => (/* binding */ joyrideStyles)
/* harmony export */ });
/* harmony import */ var react_use__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! react-use */ "../node_modules/react-use/esm/useMount.js");
/* harmony import */ var react_joyride__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! react-joyride */ "../node_modules/react-joyride/dist/index.mjs");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_10__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _js_googlesitekit_datastore_ui_constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/googlesitekit/datastore/ui/constants */ "./js/googlesitekit/datastore/ui/constants.js");
/* harmony import */ var _js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/googlesitekit/datastore/user/constants */ "./js/googlesitekit/datastore/user/constants.js");
/* harmony import */ var _js_util_tracking__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/util/tracking */ "./js/util/tracking/index.js");
/* harmony import */ var _TourTooltip__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./TourTooltip */ "./js/components/TourTooltip.js");
/* harmony import */ var _js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @/js/hooks/useViewContext */ "./js/hooks/useViewContext.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * TourTooltips component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */




/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */







/** For available options, see: {@link https://github.com/gilbarbara/react-joyride/blob/3e08384415a831b20ce21c8423b6c271ad419fbf/src/styles.js}. */

const joyrideStyles = {
  options: {
    arrowColor: '#3c7251',
    // $c-content-primary
    backgroundColor: '#3c7251',
    // $c-content-primary
    overlayColor: 'rgba(0, 0, 0, 0.6)',
    textColor: '#fff',
    // $c-content-on-primary
    zIndex: 20000
  },
  spotlight: {
    border: '2px solid #3c7251',
    // $c-content-primary
    backgroundColor: '#fff'
  }
};

// Provides button content as well as aria-label & title attribute values.
const joyrideLocale = {
  back: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Back', 'google-site-kit'),
  close: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Close', 'google-site-kit'),
  last: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Got it', 'google-site-kit'),
  next: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Next', 'google-site-kit')
};

/** For available options, see: {@link https://github.com/gilbarbara/react-floater#props}. */
const floaterProps = {
  disableAnimation: true,
  styles: {
    arrow: {
      length: 8,
      margin: 56,
      spread: 16
    },
    floater: {
      filter: 'drop-shadow(rgba(60, 64, 67, 0.3) 0px 1px 2px) drop-shadow(rgba(60, 64, 67, 0.15) 0px 2px 6px)'
    }
  }
};

// GA Event Tracking actions (do not change!)
const GA_ACTIONS = {
  VIEW: 'feature_tooltip_view',
  NEXT: 'feature_tooltip_advance',
  PREV: 'feature_tooltip_return',
  DISMISS: 'feature_tooltip_dismiss',
  COMPLETE: 'feature_tooltip_complete'
};
function TourTooltips({
  steps,
  tourID,
  gaEventCategory,
  callback
}) {
  const stepKey = `${tourID}-step`;
  const runKey = `${tourID}-run`;
  const {
    setValue
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useDispatch)(_js_googlesitekit_datastore_ui_constants__WEBPACK_IMPORTED_MODULE_2__.CORE_UI);
  const {
    dismissTour
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useDispatch)(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_USER);
  const registry = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useRegistry)();
  const viewContext = (0,_js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_6__["default"])();
  const stepIndex = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_datastore_ui_constants__WEBPACK_IMPORTED_MODULE_2__.CORE_UI).getValue(stepKey) || 0);
  const run = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => {
    return select(_js_googlesitekit_datastore_ui_constants__WEBPACK_IMPORTED_MODULE_2__.CORE_UI).getValue(runKey) && select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_USER).isTourDismissed(tourID) === false;
  });
  function changeStep(index, action) {
    return setValue(stepKey, index + (action === react_joyride__WEBPACK_IMPORTED_MODULE_8__.ACTIONS.PREV ? -1 : 1));
  }
  function startTour() {
    __webpack_require__.g.document.body.classList.add('googlesitekit-showing-feature-tour', `googlesitekit-showing-feature-tour--${tourID}`);
    setValue(runKey, true);
  }
  function endTour() {
    __webpack_require__.g.document.body.classList.remove('googlesitekit-showing-feature-tour', `googlesitekit-showing-feature-tour--${tourID}`);
    // Dismiss tour to avoid unwanted repeat viewing.
    dismissTour(tourID);
  }
  function trackAllTourEvents({
    index,
    action,
    lifecycle,
    size,
    status,
    type
  }) {
    // The index is 0-based, but step numbers are 1-based.
    const stepNumber = index + 1;
    const eventCategory = typeof gaEventCategory === 'function' ? gaEventCategory(viewContext) : gaEventCategory;
    if (type === react_joyride__WEBPACK_IMPORTED_MODULE_8__.EVENTS.TOOLTIP && lifecycle === react_joyride__WEBPACK_IMPORTED_MODULE_8__.LIFECYCLE.TOOLTIP) {
      (0,_js_util_tracking__WEBPACK_IMPORTED_MODULE_4__.trackEvent)(eventCategory, GA_ACTIONS.VIEW, stepNumber);
    } else if (action === react_joyride__WEBPACK_IMPORTED_MODULE_8__.ACTIONS.CLOSE && lifecycle === react_joyride__WEBPACK_IMPORTED_MODULE_8__.LIFECYCLE.COMPLETE) {
      (0,_js_util_tracking__WEBPACK_IMPORTED_MODULE_4__.trackEvent)(eventCategory, GA_ACTIONS.DISMISS, stepNumber);
    } else if (action === react_joyride__WEBPACK_IMPORTED_MODULE_8__.ACTIONS.NEXT && status === react_joyride__WEBPACK_IMPORTED_MODULE_8__.STATUS.FINISHED && type === react_joyride__WEBPACK_IMPORTED_MODULE_8__.EVENTS.TOUR_END &&
    // Here we need to additionally check the size === stepNumber because
    // it is the only way to differentiate the status/event combination
    // from an identical combination that happens immediately after completion
    // on index `0` to avoid duplicate measurement.
    size === stepNumber) {
      (0,_js_util_tracking__WEBPACK_IMPORTED_MODULE_4__.trackEvent)(eventCategory, GA_ACTIONS.COMPLETE, stepNumber);
    }
    if (lifecycle !== react_joyride__WEBPACK_IMPORTED_MODULE_8__.LIFECYCLE.COMPLETE || status === react_joyride__WEBPACK_IMPORTED_MODULE_8__.STATUS.FINISHED) {
      return;
    }
    if (action === react_joyride__WEBPACK_IMPORTED_MODULE_8__.ACTIONS.PREV) {
      (0,_js_util_tracking__WEBPACK_IMPORTED_MODULE_4__.trackEvent)(eventCategory, GA_ACTIONS.PREV, stepNumber);
    }
    if (action === react_joyride__WEBPACK_IMPORTED_MODULE_8__.ACTIONS.NEXT) {
      (0,_js_util_tracking__WEBPACK_IMPORTED_MODULE_4__.trackEvent)(eventCategory, GA_ACTIONS.NEXT, stepNumber);
    }
  }

  /**
   * Handles `react-joyride` state changes using callback function.
   *
   * @typedef {Object} JoyrideCallbackData
   * @property {string} action The action that updated the state.
   * @property {status} status The tour's status.
   * @property {number} index  Step index.
   * @property {string} type   Specific type (tour, step, beacon).
   *
   * @since 1.28.0
   * @since 1.38.0 Calls new callback prop.
   * @see {@link https://docs.react-joyride.com/callback} Example data provided by `react-joyride`.
   * @see {@link https://docs.react-joyride.com/constants} State & lifecycle constants used by `react-joyride`.
   *
   * @param {JoyrideCallbackData} data Data object provided via `react-joyride` callback prop.
   */
  function handleJoyrideCallback(data) {
    trackAllTourEvents(data);
    const {
      action,
      index,
      status,
      step,
      type
    } = data;
    const hasCloseAction = action === react_joyride__WEBPACK_IMPORTED_MODULE_8__.ACTIONS.CLOSE;
    const shouldChangeStep = !hasCloseAction && [react_joyride__WEBPACK_IMPORTED_MODULE_8__.EVENTS.STEP_AFTER, react_joyride__WEBPACK_IMPORTED_MODULE_8__.EVENTS.TARGET_NOT_FOUND].includes(type);
    const isFinishedOrSkipped = [react_joyride__WEBPACK_IMPORTED_MODULE_8__.STATUS.FINISHED, react_joyride__WEBPACK_IMPORTED_MODULE_8__.STATUS.SKIPPED].includes(status);
    const shouldCloseFromButtonClick = hasCloseAction && type === react_joyride__WEBPACK_IMPORTED_MODULE_8__.EVENTS.STEP_AFTER;
    const shouldEndTour = isFinishedOrSkipped || shouldCloseFromButtonClick;

    // Center the target in the viewport when transitioning to the step.
    if (react_joyride__WEBPACK_IMPORTED_MODULE_8__.EVENTS.STEP_BEFORE === type) {
      let el = step.target;
      if ('string' === typeof step.target) {
        el = __webpack_require__.g.document.querySelector(step.target);
      }
      el?.scrollIntoView?.({
        block: 'center'
      });
    }
    if (shouldChangeStep) {
      changeStep(index, action);
    } else if (shouldEndTour) {
      endTour();
    }
    if (callback) {
      callback(data, registry);
    }
  }

  // Start tour on initial render
  (0,react_use__WEBPACK_IMPORTED_MODULE_9__["default"])(startTour);
  const parsedSteps = steps.map(step => ({
    disableBeacon: true,
    isFixed: true,
    placement: 'auto',
    ...step
  }));
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(react_joyride__WEBPACK_IMPORTED_MODULE_8__["default"], {
    callback: handleJoyrideCallback,
    floaterProps: floaterProps,
    locale: joyrideLocale,
    run: run,
    stepIndex: stepIndex,
    steps: parsedSteps,
    styles: joyrideStyles,
    tooltipComponent: _TourTooltip__WEBPACK_IMPORTED_MODULE_5__["default"],
    continuous: true,
    disableOverlayClose: true,
    disableScrolling: true,
    showProgress: true
  });
}

/** For available properties & docs for `steps`, see: {@link https://docs.react-joyride.com/step#options}. */
TourTooltips.propTypes = {
  steps: prop_types__WEBPACK_IMPORTED_MODULE_10___default().arrayOf((prop_types__WEBPACK_IMPORTED_MODULE_10___default().object)).isRequired,
  tourID: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().string).isRequired,
  gaEventCategory: prop_types__WEBPACK_IMPORTED_MODULE_10___default().oneOfType([(prop_types__WEBPACK_IMPORTED_MODULE_10___default().string), (prop_types__WEBPACK_IMPORTED_MODULE_10___default().func)]).isRequired,
  callback: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().func)
};

/***/ }),

/***/ "./js/components/Typography/P.js":
/*!***************************************!*\
  !*** ./js/components/Typography/P.js ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ P)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @/js/hooks/useBreakpoint */ "./js/hooks/useBreakpoint.js");
/* harmony import */ var ___WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! . */ "./js/components/Typography/index.js");
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./constants */ "./js/components/Typography/constants.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * Internal dependencies
 */




function P({
  type = _constants__WEBPACK_IMPORTED_MODULE_2__.TYPE_BODY,
  size,
  children,
  ...props
}) {
  const breakpoint = (0,_js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_0__.useBreakpoint)();
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(___WEBPACK_IMPORTED_MODULE_1__["default"], {
    as: "p",
    type: type,
    size: size || (breakpoint === _js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_0__.BREAKPOINT_SMALL ? _constants__WEBPACK_IMPORTED_MODULE_2__.SIZE_SMALL : _constants__WEBPACK_IMPORTED_MODULE_2__.SIZE_MEDIUM),
    ...props,
    children: children
  });
}
P.propTypes = {
  type: prop_types__WEBPACK_IMPORTED_MODULE_4___default().oneOf(_constants__WEBPACK_IMPORTED_MODULE_2__.VALID_TYPES),
  size: prop_types__WEBPACK_IMPORTED_MODULE_4___default().oneOf(_constants__WEBPACK_IMPORTED_MODULE_2__.VALID_SIZES)
};

/***/ }),

/***/ "./js/components/Typography/constants.js":
/*!***********************************************!*\
  !*** ./js/components/Typography/constants.js ***!
  \***********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   SIZE_LARGE: () => (/* binding */ SIZE_LARGE),
/* harmony export */   SIZE_MEDIUM: () => (/* binding */ SIZE_MEDIUM),
/* harmony export */   SIZE_SMALL: () => (/* binding */ SIZE_SMALL),
/* harmony export */   TYPE_BODY: () => (/* binding */ TYPE_BODY),
/* harmony export */   TYPE_DISPLAY: () => (/* binding */ TYPE_DISPLAY),
/* harmony export */   TYPE_HEADLINE: () => (/* binding */ TYPE_HEADLINE),
/* harmony export */   TYPE_LABEL: () => (/* binding */ TYPE_LABEL),
/* harmony export */   TYPE_TITLE: () => (/* binding */ TYPE_TITLE),
/* harmony export */   VALID_SIZES: () => (/* binding */ VALID_SIZES),
/* harmony export */   VALID_TYPES: () => (/* binding */ VALID_TYPES)
/* harmony export */ });
/**
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

const TYPE_DISPLAY = 'display';
const TYPE_HEADLINE = 'headline';
const TYPE_TITLE = 'title';
const TYPE_BODY = 'body';
const TYPE_LABEL = 'label';
const VALID_TYPES = [TYPE_BODY, TYPE_DISPLAY, TYPE_HEADLINE, TYPE_LABEL, TYPE_TITLE];
const SIZE_SMALL = 'small';
const SIZE_MEDIUM = 'medium';
const SIZE_LARGE = 'large';
const VALID_SIZES = [SIZE_SMALL, SIZE_MEDIUM, SIZE_LARGE];

/***/ }),

/***/ "./js/components/Typography/index.js":
/*!*******************************************!*\
  !*** ./js/components/Typography/index.js ***!
  \*******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Typography)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./constants */ "./js/components/Typography/constants.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * Internal dependencies
 */


function Typography({
  className,
  type,
  size,
  as: Component = 'span',
  children,
  ...props
}) {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)(Component, {
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-typography', className, {
      [`googlesitekit-typography--${type}`]: type && _constants__WEBPACK_IMPORTED_MODULE_1__.VALID_TYPES.includes(type),
      [`googlesitekit-typography--${size}`]: size && _constants__WEBPACK_IMPORTED_MODULE_1__.VALID_SIZES.includes(size)
    }),
    ...props,
    children: children
  });
}
Typography.propTypes = {
  className: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  type: prop_types__WEBPACK_IMPORTED_MODULE_3___default().oneOf(_constants__WEBPACK_IMPORTED_MODULE_1__.VALID_TYPES),
  size: prop_types__WEBPACK_IMPORTED_MODULE_3___default().oneOf(_constants__WEBPACK_IMPORTED_MODULE_1__.VALID_SIZES),
  as: prop_types__WEBPACK_IMPORTED_MODULE_3___default().oneOfType([(prop_types__WEBPACK_IMPORTED_MODULE_3___default().string), (prop_types__WEBPACK_IMPORTED_MODULE_3___default().elementType)])
};

/***/ }),

/***/ "./js/components/VisuallyHidden.js":
/*!*****************************************!*\
  !*** ./js/components/VisuallyHidden.js ***!
  \*****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Visually Hidden component, mainly used for screen-reader text.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



function VisuallyHidden({
  className,
  children,
  ...otherProps
}) {
  if (!children) {
    return null;
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("span", {
    ...otherProps,
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('screen-reader-text', className),
    children: children
  });
}
VisuallyHidden.propTypes = {
  className: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().string),
  children: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().node)
};
VisuallyHidden.defaultProps = {
  className: ''
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (VisuallyHidden);

/***/ }),

/***/ "./js/components/notifications/CTA.js":
/*!********************************************!*\
  !*** ./js/components/notifications/CTA.js ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-components */ "googlesitekit-components");
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _js_components_Link__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/components/Link */ "./js/components/Link.js");
/* harmony import */ var _js_components_Typography__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/components/Typography */ "./js/components/Typography/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * CTA component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * Internal dependencies
 */




function CTA({
  title,
  headerText,
  headerContent,
  description,
  ctaLink,
  ctaLabel,
  ctaLinkExternal,
  ctaType,
  error,
  onClick,
  'aria-label': ariaLabel,
  children
}) {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsxs)("div", {
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-cta', {
      'googlesitekit-cta--error': error
    }),
    children: [(headerText || headerContent) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsxs)("div", {
      className: "googlesitekit-cta__header",
      children: [headerText && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(_js_components_Typography__WEBPACK_IMPORTED_MODULE_3__["default"], {
        as: "h2",
        size: "small",
        type: "label",
        className: "googlesitekit-cta__header_text",
        children: headerText
      }), headerContent]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsxs)("div", {
      className: "googlesitekit-cta__body",
      children: [title && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(_js_components_Typography__WEBPACK_IMPORTED_MODULE_3__["default"], {
        as: "h3",
        size: "small",
        type: "title",
        className: "googlesitekit-cta__title",
        children: title
      }), description && typeof description === 'string' && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("p", {
        className: "googlesitekit-cta__description",
        children: description
      }), description && typeof description !== 'string' && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("div", {
        className: "googlesitekit-cta__description",
        children: description
      }), ctaLabel && ctaType === 'button' && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__.Button, {
        "aria-label": ariaLabel,
        href: ctaLink,
        onClick: onClick,
        children: ctaLabel
      }), ctaLabel && ctaType === 'link' && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(_js_components_Link__WEBPACK_IMPORTED_MODULE_2__["default"], {
        href: ctaLink,
        onClick: onClick,
        "aria-label": ariaLabel,
        external: ctaLinkExternal,
        hideExternalIndicator: ctaLinkExternal,
        arrow: true,
        children: ctaLabel
      }), children]
    })]
  });
}
CTA.propTypes = {
  title: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().string).isRequired,
  headerText: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().string),
  description: prop_types__WEBPACK_IMPORTED_MODULE_5___default().oneOfType([(prop_types__WEBPACK_IMPORTED_MODULE_5___default().string), (prop_types__WEBPACK_IMPORTED_MODULE_5___default().node)]),
  ctaLink: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().string),
  ctaLinkExternal: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().bool),
  ctaLabel: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().string),
  ctaType: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().string),
  'aria-label': (prop_types__WEBPACK_IMPORTED_MODULE_5___default().string),
  error: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().bool),
  onClick: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().func),
  children: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().node),
  headerContent: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().node)
};
CTA.defaultProps = {
  title: '',
  headerText: '',
  headerContent: '',
  description: '',
  ctaLink: '',
  ctaLabel: '',
  ctaType: 'link',
  error: false,
  onClick: () => {}
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (CTA);

/***/ }),

/***/ "./js/components/surveys/SurveyViewTrigger.js":
/*!****************************************************!*\
  !*** ./js/components/surveys/SurveyViewTrigger.js ***!
  \****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ SurveyViewTrigger)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/googlesitekit/datastore/user/constants */ "./js/googlesitekit/datastore/user/constants.js");
/**
 * SurveyViewTrigger component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */


/**
 * External dependencies
 */


/**
 * Internal dependencies
 */


function SurveyViewTrigger({
  triggerID,
  ttl = 0
}) {
  const {
    triggerSurvey
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useDispatch)(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_1__.CORE_USER);
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useEffect)(() => {
    triggerSurvey(triggerID, {
      ttl
    });
  }, [triggerID, ttl, triggerSurvey]);
  return null;
}
SurveyViewTrigger.propTypes = {
  triggerID: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string).isRequired,
  ttl: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().number)
};

/***/ }),

/***/ "./js/feature-tours/shared-key-metrics.js":
/*!************************************************!*\
  !*** ./js/feature-tours/shared-key-metrics.js ***!
  \************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _js_googlesitekit_constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/googlesitekit/constants */ "./js/googlesitekit/constants.js");
/**
 * Site Kit by Google, Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */


/*
 * Internal dependencies
 */

const sharedKeyMetrics = {
  slug: 'sharedKeyMetrics',
  contexts: [_js_googlesitekit_constants__WEBPACK_IMPORTED_MODULE_1__.VIEW_CONTEXT_MAIN_DASHBOARD, _js_googlesitekit_constants__WEBPACK_IMPORTED_MODULE_1__.VIEW_CONTEXT_MAIN_DASHBOARD_VIEW_ONLY, _js_googlesitekit_constants__WEBPACK_IMPORTED_MODULE_1__.VIEW_CONTEXT_ENTITY_DASHBOARD, _js_googlesitekit_constants__WEBPACK_IMPORTED_MODULE_1__.VIEW_CONTEXT_ENTITY_DASHBOARD_VIEW_ONLY],
  gaEventCategory: viewContext => `${viewContext}_shared_key-metrics`,
  steps: [{
    target: '.googlesitekit-km-change-metrics-cta',
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Personalize your key metrics', 'google-site-kit'),
    content: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Another admin has set up these tailored metrics for your site. Click here to personalize them.', 'google-site-kit'),
    placement: 'bottom-start'
  }]
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (sharedKeyMetrics);

/***/ }),

/***/ "./js/features/index.js":
/*!******************************!*\
  !*** ./js/features/index.js ***!
  \******************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   enabledFeatures: () => (/* binding */ enabledFeatures),
/* harmony export */   isFeatureEnabled: () => (/* binding */ isFeatureEnabled)
/* harmony export */ });
/**
 * Feature flags.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

const enabledFeatures = new Set(__webpack_require__.g?._googlesitekitBaseData?.enabledFeatures || []);

/**
 * Returns true if a feature is enabled; false otherwise.
 *
 * @since 1.25.0
 * @since 1.33.0 Changed _enabledFeatures argument to be a `Set` instead of `Array`.
 *
 * @param {string} feature            The name of the feature to check.
 * @param {Set}    [_enabledFeatures] Optional. The set of enabled features. Uses `enabledFeatures` set by the server in a global JS variable, by default.
 * @return {boolean} `true` if a feature is enabled; `false` otherwise.
 */
function isFeatureEnabled(feature, _enabledFeatures = enabledFeatures) {
  if (!(_enabledFeatures instanceof Set)) {
    return false;
  }
  return _enabledFeatures.has(feature);
}

/***/ }),

/***/ "./js/googlesitekit-data.js":
/*!**********************************!*\
  !*** ./js/googlesitekit-data.js ***!
  \**********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   RegistryProvider: () => (/* reexport safe */ _googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.RegistryProvider),
/* harmony export */   combineStores: () => (/* reexport safe */ _googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.combineStores),
/* harmony export */   commonActions: () => (/* reexport safe */ _googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.commonActions),
/* harmony export */   commonControls: () => (/* reexport safe */ _googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.commonControls),
/* harmony export */   commonStore: () => (/* reexport safe */ _googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.commonStore),
/* harmony export */   controls: () => (/* reexport safe */ _googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.controls),
/* harmony export */   createReducer: () => (/* reexport safe */ _googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.createReducer),
/* harmony export */   createRegistryControl: () => (/* reexport safe */ _googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.createRegistryControl),
/* harmony export */   createRegistrySelector: () => (/* reexport safe */ _googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.createRegistrySelector),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   useDispatch: () => (/* reexport safe */ _googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useDispatch),
/* harmony export */   useInViewSelect: () => (/* reexport safe */ _googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useInViewSelect),
/* harmony export */   useRegistry: () => (/* reexport safe */ _googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useRegistry),
/* harmony export */   useSelect: () => (/* reexport safe */ _googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useSelect),
/* harmony export */   withDispatch: () => (/* reexport safe */ _googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.withDispatch),
/* harmony export */   withSelect: () => (/* reexport safe */ _googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.withSelect)
/* harmony export */ });
/* harmony import */ var _googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./googlesitekit/data */ "./js/googlesitekit/data/index.js");
/**
 * Public Data store entrypoint.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Internal dependencies
 */

if (typeof __webpack_require__.g.googlesitekit === 'undefined') {
  __webpack_require__.g.googlesitekit = {};
}
__webpack_require__.g.googlesitekit.data = _googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__["default"];

// This is only exported for Jest and is not used in production.
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__["default"]);


/***/ }),

/***/ "./js/googlesitekit-widgets.js":
/*!*************************************!*\
  !*** ./js/googlesitekit-widgets.js ***!
  \*************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   WIDGET_AREA_STYLES: () => (/* binding */ WIDGET_AREA_STYLES),
/* harmony export */   WIDGET_WIDTHS: () => (/* binding */ WIDGET_WIDTHS),
/* harmony export */   assignWidget: () => (/* binding */ assignWidget),
/* harmony export */   assignWidgetArea: () => (/* binding */ assignWidgetArea),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   isWidgetAreaRegistered: () => (/* binding */ isWidgetAreaRegistered),
/* harmony export */   isWidgetRegistered: () => (/* binding */ isWidgetRegistered),
/* harmony export */   registerWidget: () => (/* binding */ registerWidget),
/* harmony export */   registerWidgetArea: () => (/* binding */ registerWidgetArea)
/* harmony export */ });
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _googlesitekit_widgets__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./googlesitekit/widgets */ "./js/googlesitekit/widgets/index.js");
/**
 * Public Widgets API entrypoint.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Internal dependencies
 */


(0,_googlesitekit_widgets__WEBPACK_IMPORTED_MODULE_1__.registerStore)((googlesitekit_data__WEBPACK_IMPORTED_MODULE_0___default()));
const Widgets = (0,_googlesitekit_widgets__WEBPACK_IMPORTED_MODULE_1__.createWidgets)((googlesitekit_data__WEBPACK_IMPORTED_MODULE_0___default()));
(0,_googlesitekit_widgets__WEBPACK_IMPORTED_MODULE_1__.registerWidgets)(Widgets);
if (typeof __webpack_require__.g.googlesitekit === 'undefined') {
  __webpack_require__.g.googlesitekit = {};
}
__webpack_require__.g.googlesitekit.widgets = Widgets;

// This is only exported for Jest and is not used in production.
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Widgets);
const {
  WIDGET_WIDTHS,
  WIDGET_AREA_STYLES,
  registerWidgetArea,
  registerWidget,
  assignWidgetArea,
  assignWidget,
  isWidgetAreaRegistered,
  isWidgetRegistered
} = Widgets;

/***/ }),

/***/ "./js/googlesitekit/api/cache.js":
/*!***************************************!*\
  !*** ./js/googlesitekit/api/cache.js ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   STORAGE_KEY_PREFIX: () => (/* binding */ STORAGE_KEY_PREFIX),
/* harmony export */   STORAGE_KEY_PREFIX_ROOT: () => (/* binding */ STORAGE_KEY_PREFIX_ROOT),
/* harmony export */   clearCache: () => (/* binding */ clearCache),
/* harmony export */   deleteItem: () => (/* binding */ deleteItem),
/* harmony export */   getItem: () => (/* binding */ getItem),
/* harmony export */   getKeys: () => (/* binding */ getKeys),
/* harmony export */   getStorage: () => (/* binding */ getStorage),
/* harmony export */   isStorageAvailable: () => (/* binding */ isStorageAvailable),
/* harmony export */   resetDefaultStorageOrder: () => (/* binding */ resetDefaultStorageOrder),
/* harmony export */   setItem: () => (/* binding */ setItem),
/* harmony export */   setSelectedStorageBackend: () => (/* binding */ setSelectedStorageBackend),
/* harmony export */   setStorageOrder: () => (/* binding */ setStorageOrder)
/* harmony export */ });
/* harmony import */ var _js_util__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @/js/util */ "./js/util/index.js");
/**
 * Caching functions and cache management for API requests.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Internal dependencies
 */


/**
 * Prefix used for all Site Kit keys.
 *
 * Anything not using this prefix should not be touched by this library.
 *
 * @since 1.96.0
 * @private
 */
const STORAGE_KEY_PREFIX_ROOT = 'googlesitekit_';

/**
 * Prefix used for all Site Kit keys for the current Site Kit version.
 *
 * Anything not using this key should not be touched by this library.
 *
 * @since 1.5.0
 * @since 1.92.0 Updated to include a user, session, and blog-specific hash.
 * @since 1.96.0 Updated to make use of the new STORAGE_KEY_PREFIX_ROOT constant.
 * @private
 */
const STORAGE_KEY_PREFIX = `${STORAGE_KEY_PREFIX_ROOT}${"1.165.0"}_${__webpack_require__.g._googlesitekitBaseData.storagePrefix}_`;
const defaultOrder = ['sessionStorage', 'localStorage'];
let storageBackend;
let storageOrder = [...defaultOrder];

/**
 * Overrides the storage backend.
 *
 * Largely used for tests. Should not be used directly.
 *
 * @since 1.5.0
 * @private
 *
 * @param {*} backend Backend to set for the cache.
 */
function setSelectedStorageBackend(backend) {
  storageBackend = backend;
}

/**
 * Overrides the priority of storage mechanisms.
 *
 * Largely used for tests. Implicitly resets the selected storage backend,
 * causing `_getStorage` to re-run its checks for the best available
 * storage backend.
 *
 * @since 1.5.0
 * @private
 *
 * @param {Array} order Ordered array of storage backends to use.
 */
function setStorageOrder(order) {
  storageOrder = [...order];
  setSelectedStorageBackend(undefined);
}

/**
 * Resets the storage mechanism order.
 *
 * Largely used for tests. Implicitly resets the selected storage backend,
 * causing `_getStorage` to re-run its checks for the best available
 * storage backend.
 *
 * @since 1.5.0
 * @private
 */
function resetDefaultStorageOrder() {
  storageOrder = [...defaultOrder];
  setSelectedStorageBackend(undefined);
}

/**
 * Detects whether browser storage is both supported and available.
 *
 * @since 1.5.0
 * @private
 *
 * @param {string} type Browser storage to test. Should be one of `localStorage` or `sessionStorage`.
 * @return {boolean} True if the given storage is available, false otherwise.
 */
// eslint-disable-next-line require-await
async function isStorageAvailable(type) {
  const storage = __webpack_require__.g[type];
  if (!storage) {
    return false;
  }
  try {
    const x = '__storage_test__';
    storage.setItem(x, x);
    storage.removeItem(x);
    return true;
  } catch (e) {
    return e instanceof DOMException && (
    // everything except Firefox
    22 === e.code ||
    // Firefox
    1014 === e.code ||
    // test name field too, because code might not be present
    // everything except Firefox
    'QuotaExceededError' === e.name ||
    // Firefox
    'NS_ERROR_DOM_QUOTA_REACHED' === e.name) &&
    // acknowledge QuotaExceededError only if there's something already stored
    0 !== storage.length;
  }
}

/**
 * Gets the storage object to use.
 *
 * @since 1.5.0
 * @private
 *
 * @return {Storage|null} A storage mechanism (`localStorage` or `sessionStorage`) if available; otherwise returns `null`.
 */
async function getStorage() {
  if (storageBackend !== undefined) {
    return storageBackend;
  }

  // Only run the logic to determine the storage object once.
  for (const backend of storageOrder) {
    if (storageBackend) {
      continue;
    }
    if (await isStorageAvailable(backend)) {
      storageBackend = __webpack_require__.g[backend];
    }
  }
  if (storageBackend === undefined) {
    storageBackend = null;
  }
  return storageBackend;
}

/**
 * Gets cached data.
 *
 * Get cached data from the persistent storage cache.
 *
 * @since 1.5.0
 *
 * @param {string} key Name of cache key.
 * @return {Promise} A promise returned, containing an object with the cached value (if found) and whether or not there was a cache hit.
 */
async function getItem(key) {
  const storage = await getStorage();
  if (storage) {
    const cachedData = storage.getItem(`${STORAGE_KEY_PREFIX}${key}`);
    if (cachedData) {
      const parsedData = JSON.parse(cachedData);
      const {
        timestamp,
        ttl,
        value,
        isError
      } = parsedData;

      // Ensure a timestamp is found, otherwise this isn't a valid cache hit.
      // (We don't check for a truthy `value`, because it could be legitimately
      // false-y if `0`, `null`, etc.)
      if (timestamp && (!ttl ||
      // Ensure the cached data isn't too old.
      // The cache dates shouldn't rely on reference
      // dates for cache expiration. This is a case
      // where we actually want to rely on
      // the _actual_ date/time the data was set.
      Math.round(Date.now() / 1000) - timestamp < ttl) // eslint-disable-line sitekit/no-direct-date
      ) {
        return {
          cacheHit: true,
          value,
          isError
        };
      }
    }
  }
  return {
    cacheHit: false,
    value: undefined
  };
}

/**
 * Sets cached data using a key.
 *
 * Save data to the relevant local storage mechanism, if available.
 * By default, data is saved with a one hour (60 minute) TTL.
 *
 * @since 1.5.0
 *
 * @param {string}  key              Name of cache key.
 * @param {*}       value            Value to store in the cache.
 * @param {Object}  args             Optional object containing ttl, timestamp and isError keys.
 * @param {number}  [args.ttl]       Optional. Validity of the cached item in seconds.
 * @param {number}  [args.timestamp] Optional. Timestamp when the cached item was created.
 * @param {boolean} [args.isError]   Optional. Whether the cached item is an error.
 * @return {Promise} A promise: resolves to `true` if the value was saved; `false` if not (usually because no storage method was available).
 */
async function setItem(key, value, {
  ttl = _js_util__WEBPACK_IMPORTED_MODULE_0__.HOUR_IN_SECONDS,
  // Cached times should rely on real times, not the reference date,
  // so the cache timeouts are consistent even when changing
  // the reference dates when developing/testing.
  timestamp = Math.round(Date.now() / 1000),
  // eslint-disable-line sitekit/no-direct-date
  isError = false
} = {}) {
  const storage = await getStorage();
  if (storage) {
    try {
      storage.setItem(`${STORAGE_KEY_PREFIX}${key}`, JSON.stringify({
        timestamp,
        ttl,
        value,
        isError
      }));
      return true;
    } catch (error) {
      __webpack_require__.g.console.warn('Encountered an unexpected storage error:', error);
      return false;
    }
  }
  return false;
}

/**
 * Removes cached data by key.
 *
 * Remove one piece of cached data from the persistent storage cache, by key.
 *
 * @since 1.5.0
 *
 * @param {string} key Name of cache key.
 * @return {Promise} A promise: resolves to `true` if the value was deleted; `false` if not (usually because no storage method was available).
 */
async function deleteItem(key) {
  const storage = await getStorage();
  if (storage) {
    try {
      const fullKey = key.startsWith(STORAGE_KEY_PREFIX_ROOT) ? key : `${STORAGE_KEY_PREFIX}${key}`;
      storage.removeItem(fullKey);
      return true;
    } catch (error) {
      __webpack_require__.g.console.warn('Encountered an unexpected storage error:', error);
      return false;
    }
  }
  return false;
}

/**
 * Gets all cache keys created by Site Kit.
 *
 * @since 1.5.0
 *
 * @return {Promise} A promise: resolves to an array of all keys.
 */
async function getKeys() {
  const storage = await getStorage();
  if (storage) {
    try {
      const keys = [];
      for (let i = 0; i < storage.length; i++) {
        const itemKey = storage.key(i);
        if (itemKey.indexOf(STORAGE_KEY_PREFIX_ROOT) === 0) {
          keys.push(itemKey);
        }
      }
      return keys;
    } catch (error) {
      __webpack_require__.g.console.warn('Encountered an unexpected storage error:', error);
      return [];
    }
  }
  return [];
}

/**
 * Removes the entire cache created by Site Kit.
 *
 * @since 1.5.0
 *
 * @return {Promise} A promise: resolves to `true` if the cache was cleared; `false` if there was an error.
 */
async function clearCache() {
  const storage = await getStorage();
  if (storage) {
    const keys = await getKeys();
    for (const key of keys) {
      await deleteItem(key);
    }
    return true;
  }
  return false;
}

/***/ }),

/***/ "./js/googlesitekit/components-gm2/Button/MaybeTooltip.js":
/*!****************************************************************!*\
  !*** ./js/googlesitekit/components-gm2/Button/MaybeTooltip.js ***!
  \****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ MaybeTooltip)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _js_googlesitekit_components_gm2_Tooltip__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @/js/googlesitekit/components-gm2/Tooltip */ "./js/googlesitekit/components-gm2/Tooltip.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * MaybeTooltip component.
 *
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * Internal dependencies
 */


function MaybeTooltip({
  children,
  disabled = false,
  tooltip = false,
  tooltipTitle = null,
  hasIconOnly = false,
  tooltipEnterDelayInMS = 100
}) {
  if (!disabled && (tooltip && tooltipTitle || hasIconOnly && tooltipTitle)) {
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)(_js_googlesitekit_components_gm2_Tooltip__WEBPACK_IMPORTED_MODULE_0__["default"], {
      title: tooltipTitle,
      enterDelay: tooltipEnterDelayInMS,
      children: children
    });
  }
  return children;
}
MaybeTooltip.propTypes = {
  children: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().node).isRequired,
  disabled: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().bool),
  tooltip: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().bool),
  tooltipTitle: prop_types__WEBPACK_IMPORTED_MODULE_2___default().oneOfType([(prop_types__WEBPACK_IMPORTED_MODULE_2___default().string), (prop_types__WEBPACK_IMPORTED_MODULE_2___default().element)]),
  hasIconOnly: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().bool),
  tooltipEnterDelayInMS: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().number)
};

/***/ }),

/***/ "./js/googlesitekit/components-gm2/Button/SemanticButton.js":
/*!******************************************************************!*\
  !*** ./js/googlesitekit/components-gm2/Button/SemanticButton.js ***!
  \******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * SemanticButton component.
 *
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * WordPress dependencies
 */


const SemanticButton = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.forwardRef)(({
  children,
  href,
  text,
  className,
  danger,
  disabled,
  target,
  'aria-label': ariaLabel,
  inverse,
  tertiary,
  callout,
  calloutStyle,
  ...extraProps
}, ref) => {
  // Use a button if disabled, even if a href is provided to ensure expected behavior.
  const ButtonTag = href && !disabled ? 'a' : 'button';
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)(ButtonTag, {
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('mdc-button', className, {
      'mdc-button--raised': !text && !tertiary && !callout,
      'mdc-button--danger': danger,
      'mdc-button--inverse': inverse,
      'mdc-button--tertiary': tertiary,
      'mdc-button--callout': callout,
      'mdc-button--callout-primary': callout || calloutStyle === 'primary',
      'mdc-button--callout-warning': calloutStyle === 'warning',
      'mdc-button--callout-error': calloutStyle === 'error'
    }),
    href: disabled ? undefined : href,
    ref: ref,
    disabled: !!disabled,
    "aria-label": ariaLabel,
    target: target || '_self',
    role: 'a' === ButtonTag ? 'button' : undefined,
    ...extraProps,
    children: children
  });
});
SemanticButton.propTypes = {
  children: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().node),
  href: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  text: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().bool),
  className: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  danger: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().bool),
  disabled: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().bool),
  target: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  'aria-label': (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  inverse: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().bool),
  tertiary: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().bool),
  callout: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().bool),
  calloutStyle: prop_types__WEBPACK_IMPORTED_MODULE_3___default().oneOf(['primary', 'warning', 'error'])
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (SemanticButton);

/***/ }),

/***/ "./js/googlesitekit/components-gm2/Button/index.js":
/*!*********************************************************!*\
  !*** ./js/googlesitekit/components-gm2/Button/index.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var _react_hook_merged_ref__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @react-hook/merged-ref */ "../node_modules/@react-hook/merged-ref/dist/module/index.js");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _js_material_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/material-components */ "./js/material-components/index.js");
/* harmony import */ var _SemanticButton__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./SemanticButton */ "./js/googlesitekit/components-gm2/Button/SemanticButton.js");
/* harmony import */ var _MaybeTooltip__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./MaybeTooltip */ "./js/googlesitekit/components-gm2/Button/MaybeTooltip.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Button component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */




const Button = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_5__.forwardRef)(({
  children,
  href = null,
  text = false,
  className = '',
  danger = false,
  disabled = false,
  target,
  icon = null,
  trailingIcon = null,
  'aria-label': ariaLabel,
  title = null,
  customizedTooltip = null,
  tooltip = false,
  inverse = false,
  hideTooltipTitle = false,
  tooltipEnterDelayInMS = 100,
  tertiary = false,
  callout = false,
  calloutStyle = null,
  ...extraProps
}, ref) => {
  const buttonRef = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_5__.useCallback)(el => {
    if (el !== null) {
      _js_material_components__WEBPACK_IMPORTED_MODULE_1__.MDCRipple.attachTo(el);
    }
  }, []);
  const mergedRefs = (0,_react_hook_merged_ref__WEBPACK_IMPORTED_MODULE_6__["default"])(ref, buttonRef);
  function getAriaLabel() {
    let label = ariaLabel;
    if (target !== '_blank') {
      return label;
    }
    const newTabText = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__._x)('(opens in a new tab)', 'screen reader text', 'google-site-kit');
    if (typeof children === 'string') {
      label = label || children;
    }
    if (label) {
      return `${label} ${newTabText}`;
    }
    return newTabText;
  }
  const tooltipTitle = !hideTooltipTitle ? title || customizedTooltip || ariaLabel : null;
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(_MaybeTooltip__WEBPACK_IMPORTED_MODULE_3__["default"], {
    disabled: disabled,
    tooltip: tooltip,
    tooltipTitle: tooltipTitle,
    hasIconOnly: !!icon && children === undefined,
    tooltipEnterDelayInMS: tooltipEnterDelayInMS,
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsxs)(_SemanticButton__WEBPACK_IMPORTED_MODULE_2__["default"], {
      href: href,
      disabled: disabled,
      className: className,
      danger: danger,
      text: text,
      tertiary: tertiary,
      inverse: inverse,
      callout: callout,
      calloutStyle: calloutStyle,
      ref: mergedRefs,
      "aria-label": getAriaLabel(),
      target: target || '_self',
      ...extraProps,
      children: [icon, children && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("span", {
        className: "mdc-button__label",
        children: children
      }), trailingIcon]
    })
  });
});
Button.propTypes = {
  onClick: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().func),
  children: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().node),
  href: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().string),
  text: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().bool),
  className: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().string),
  danger: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().bool),
  disabled: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().bool),
  icon: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().element),
  trailingIcon: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().element),
  title: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().string),
  customizedTooltip: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().element),
  tooltip: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().bool),
  inverse: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().bool),
  hideTooltipTitle: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().bool),
  callout: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().bool),
  calloutStyle: prop_types__WEBPACK_IMPORTED_MODULE_7___default().oneOf(['primary', 'warning', 'error'])
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Button);

/***/ }),

/***/ "./js/googlesitekit/components-gm2/CircularProgress.js":
/*!*************************************************************!*\
  !*** ./js/googlesitekit/components-gm2/CircularProgress.js ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ CircularProgress)
/* harmony export */ });
/* harmony import */ var _material_ui_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @material-ui/core */ "../node_modules/@material-ui/core/esm/CircularProgress/CircularProgress.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * CircularProgress component.
 *
 * Site Kit by Google, Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


function CircularProgress(props) {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_material_ui_core__WEBPACK_IMPORTED_MODULE_1__["default"], {
    ...props
  });
}

/***/ }),

/***/ "./js/googlesitekit/components-gm2/SpinnerButton.js":
/*!**********************************************************!*\
  !*** ./js/googlesitekit/components-gm2/SpinnerButton.js ***!
  \**********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   SPINNER_POSITION: () => (/* binding */ SPINNER_POSITION),
/* harmony export */   "default": () => (/* binding */ SpinnerButton)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Button__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Button */ "./js/googlesitekit/components-gm2/Button/index.js");
/* harmony import */ var _CircularProgress__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./CircularProgress */ "./js/googlesitekit/components-gm2/CircularProgress.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Site Kit by Google, Copyright 2022 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * Internal dependencies
 */



const SPINNER_POSITION = {
  BEFORE: 'before',
  AFTER: 'after'
};
function SpinnerButton(props) {
  const {
    className,
    onClick = () => {},
    isSaving = false,
    spinnerPosition = SPINNER_POSITION.AFTER,
    ...restProps
  } = props;
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_Button__WEBPACK_IMPORTED_MODULE_1__["default"], {
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()(className, 'googlesitekit-button-icon--spinner', {
      'googlesitekit-button-icon--spinner__running': isSaving,
      'googlesitekit-button-icon--spinner__before': spinnerPosition === SPINNER_POSITION.BEFORE,
      'googlesitekit-button-icon--spinner__after': spinnerPosition === SPINNER_POSITION.AFTER
    }),
    icon: isSaving && spinnerPosition === SPINNER_POSITION.BEFORE ? /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_CircularProgress__WEBPACK_IMPORTED_MODULE_2__["default"], {
      size: 14
    }) : undefined,
    trailingIcon: isSaving && spinnerPosition === SPINNER_POSITION.AFTER ? /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_CircularProgress__WEBPACK_IMPORTED_MODULE_2__["default"], {
      size: 14
    }) : undefined,
    onClick: onClick,
    ...restProps
  });
}
SpinnerButton.propTypes = {
  className: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().string),
  onClick: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().func),
  isSaving: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().bool),
  spinnerPosition: prop_types__WEBPACK_IMPORTED_MODULE_4___default().oneOf(Object.values(SPINNER_POSITION))
};

/***/ }),

/***/ "./js/googlesitekit/components-gm2/Tooltip.js":
/*!****************************************************!*\
  !*** ./js/googlesitekit/components-gm2/Tooltip.js ***!
  \****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Tooltip)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _material_ui_core__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @material-ui/core */ "../node_modules/@material-ui/core/esm/Tooltip/Tooltip.js");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Tooltip component.
 *
 * Site Kit by Google, Copyright 2022 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */




/**
 * WordPress dependencies
 */


function Tooltip({
  children,
  popperClassName,
  tooltipClassName,
  onOpen,
  onClose,
  ...props
}) {
  const isOpen = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useRef)(false);
  const handleOpen = onOpen ? () => {
    // This fixes a bug where the `onOpen` callback is called when the tooltip is already open.
    if (isOpen.current) {
      return;
    }
    isOpen.current = true;
    onOpen?.();
  } : undefined;
  const handleClose = onOpen ? () => {
    isOpen.current = false;
    onClose?.();
  } : onClose;
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)(_material_ui_core__WEBPACK_IMPORTED_MODULE_3__["default"], {
    classes: {
      popper: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-tooltip-popper', popperClassName),
      tooltip: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-tooltip', tooltipClassName)
    },
    onOpen: handleOpen,
    onClose: handleClose,
    ...props,
    arrow: true,
    children: children
  });
}
Tooltip.propTypes = {
  children: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().node),
  popperClassName: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().string),
  tooltipClassName: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().string),
  onOpen: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().func),
  onClose: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().func)
};

/***/ }),

/***/ "./js/googlesitekit/constants.js":
/*!***************************************!*\
  !*** ./js/googlesitekit/constants.js ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ANCHOR_ID_CONTENT: () => (/* binding */ ANCHOR_ID_CONTENT),
/* harmony export */   ANCHOR_ID_KEY_METRICS: () => (/* binding */ ANCHOR_ID_KEY_METRICS),
/* harmony export */   ANCHOR_ID_MONETIZATION: () => (/* binding */ ANCHOR_ID_MONETIZATION),
/* harmony export */   ANCHOR_ID_SPEED: () => (/* binding */ ANCHOR_ID_SPEED),
/* harmony export */   ANCHOR_ID_TRAFFIC: () => (/* binding */ ANCHOR_ID_TRAFFIC),
/* harmony export */   SITE_KIT_VIEW_CONTEXTS: () => (/* binding */ SITE_KIT_VIEW_CONTEXTS),
/* harmony export */   SITE_KIT_VIEW_ONLY_CONTEXTS: () => (/* binding */ SITE_KIT_VIEW_ONLY_CONTEXTS),
/* harmony export */   VIEW_CONTEXT_ACTIVATION: () => (/* binding */ VIEW_CONTEXT_ACTIVATION),
/* harmony export */   VIEW_CONTEXT_ADMIN_BAR: () => (/* binding */ VIEW_CONTEXT_ADMIN_BAR),
/* harmony export */   VIEW_CONTEXT_ADMIN_BAR_VIEW_ONLY: () => (/* binding */ VIEW_CONTEXT_ADMIN_BAR_VIEW_ONLY),
/* harmony export */   VIEW_CONTEXT_AD_BLOCKING_RECOVERY: () => (/* binding */ VIEW_CONTEXT_AD_BLOCKING_RECOVERY),
/* harmony export */   VIEW_CONTEXT_ENTITY_DASHBOARD: () => (/* binding */ VIEW_CONTEXT_ENTITY_DASHBOARD),
/* harmony export */   VIEW_CONTEXT_ENTITY_DASHBOARD_VIEW_ONLY: () => (/* binding */ VIEW_CONTEXT_ENTITY_DASHBOARD_VIEW_ONLY),
/* harmony export */   VIEW_CONTEXT_KEY_METRICS_SETUP: () => (/* binding */ VIEW_CONTEXT_KEY_METRICS_SETUP),
/* harmony export */   VIEW_CONTEXT_MAIN_DASHBOARD: () => (/* binding */ VIEW_CONTEXT_MAIN_DASHBOARD),
/* harmony export */   VIEW_CONTEXT_MAIN_DASHBOARD_VIEW_ONLY: () => (/* binding */ VIEW_CONTEXT_MAIN_DASHBOARD_VIEW_ONLY),
/* harmony export */   VIEW_CONTEXT_METRIC_SELECTION: () => (/* binding */ VIEW_CONTEXT_METRIC_SELECTION),
/* harmony export */   VIEW_CONTEXT_MODULE: () => (/* binding */ VIEW_CONTEXT_MODULE),
/* harmony export */   VIEW_CONTEXT_MODULE_SETUP: () => (/* binding */ VIEW_CONTEXT_MODULE_SETUP),
/* harmony export */   VIEW_CONTEXT_POSTS_LIST: () => (/* binding */ VIEW_CONTEXT_POSTS_LIST),
/* harmony export */   VIEW_CONTEXT_SETTINGS: () => (/* binding */ VIEW_CONTEXT_SETTINGS),
/* harmony export */   VIEW_CONTEXT_SPLASH: () => (/* binding */ VIEW_CONTEXT_SPLASH),
/* harmony export */   VIEW_CONTEXT_USER_INPUT: () => (/* binding */ VIEW_CONTEXT_USER_INPUT),
/* harmony export */   VIEW_CONTEXT_WP_BLOCK_EDITOR: () => (/* binding */ VIEW_CONTEXT_WP_BLOCK_EDITOR),
/* harmony export */   VIEW_CONTEXT_WP_DASHBOARD: () => (/* binding */ VIEW_CONTEXT_WP_DASHBOARD),
/* harmony export */   VIEW_CONTEXT_WP_DASHBOARD_VIEW_ONLY: () => (/* binding */ VIEW_CONTEXT_WP_DASHBOARD_VIEW_ONLY)
/* harmony export */ });
/**
 * Core constants.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

const VIEW_CONTEXT_MAIN_DASHBOARD = 'mainDashboard';
const VIEW_CONTEXT_ENTITY_DASHBOARD = 'entityDashboard';
const VIEW_CONTEXT_MAIN_DASHBOARD_VIEW_ONLY = 'mainDashboardViewOnly';
const VIEW_CONTEXT_ENTITY_DASHBOARD_VIEW_ONLY = 'entityDashboardViewOnly';
const VIEW_CONTEXT_POSTS_LIST = 'postsList';
const VIEW_CONTEXT_USER_INPUT = 'userInput';
const VIEW_CONTEXT_ACTIVATION = 'activation';
const VIEW_CONTEXT_SPLASH = 'splash';
const VIEW_CONTEXT_ADMIN_BAR = 'adminBar';
const VIEW_CONTEXT_ADMIN_BAR_VIEW_ONLY = 'adminBarViewOnly';
const VIEW_CONTEXT_SETTINGS = 'settings';
const VIEW_CONTEXT_AD_BLOCKING_RECOVERY = 'adBlockingRecovery';
const VIEW_CONTEXT_MODULE = 'module';
const VIEW_CONTEXT_WP_DASHBOARD = 'wpDashboard';
const VIEW_CONTEXT_WP_DASHBOARD_VIEW_ONLY = 'wpDashboardViewOnly';
const VIEW_CONTEXT_MODULE_SETUP = 'moduleSetup';
const VIEW_CONTEXT_METRIC_SELECTION = 'metricSelection';
const VIEW_CONTEXT_WP_BLOCK_EDITOR = 'wpBlockEditor';
const VIEW_CONTEXT_KEY_METRICS_SETUP = 'keyMetricsSetup';

// Anchor ID Constants
const ANCHOR_ID_KEY_METRICS = 'key-metrics';
const ANCHOR_ID_TRAFFIC = 'traffic';
const ANCHOR_ID_CONTENT = 'content';
const ANCHOR_ID_SPEED = 'speed';
const ANCHOR_ID_MONETIZATION = 'monetization';

// Site Kit only view contexts
const SITE_KIT_VIEW_CONTEXTS = [VIEW_CONTEXT_MAIN_DASHBOARD, VIEW_CONTEXT_ENTITY_DASHBOARD, VIEW_CONTEXT_MAIN_DASHBOARD_VIEW_ONLY, VIEW_CONTEXT_ENTITY_DASHBOARD_VIEW_ONLY, VIEW_CONTEXT_USER_INPUT, VIEW_CONTEXT_SPLASH, VIEW_CONTEXT_SETTINGS, VIEW_CONTEXT_MODULE_SETUP, VIEW_CONTEXT_METRIC_SELECTION];

// Site Kit view-only contexts
const SITE_KIT_VIEW_ONLY_CONTEXTS = [VIEW_CONTEXT_MAIN_DASHBOARD_VIEW_ONLY, VIEW_CONTEXT_ENTITY_DASHBOARD_VIEW_ONLY, VIEW_CONTEXT_ADMIN_BAR_VIEW_ONLY, VIEW_CONTEXT_WP_DASHBOARD_VIEW_ONLY];

/***/ }),

/***/ "./js/googlesitekit/data/create-error-store.js":
/*!*****************************************************!*\
  !*** ./js/googlesitekit/data/create-error-store.js ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   actions: () => (/* binding */ actions),
/* harmony export */   createErrorStore: () => (/* binding */ createErrorStore),
/* harmony export */   generateErrorKey: () => (/* binding */ generateErrorKey)
/* harmony export */ });
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @wordpress/data */ "../node_modules/@wordpress/data/build-module/factory.js");
/* harmony import */ var invariant__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! invariant */ "../node_modules/invariant/browser.js");
/* harmony import */ var invariant__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(invariant__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var md5__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! md5 */ "../node_modules/md5/md5.js");
/* harmony import */ var md5__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(md5__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _js_util__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/util */ "./js/util/index.js");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__);
/**
 * API function to create fetch store.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */


/**
 * External dependencies
 */


const RECEIVE_ERROR = 'RECEIVE_ERROR';
const CLEAR_ERROR = 'CLEAR_ERROR';
const CLEAR_ERRORS = 'CLEAR_ERRORS';

/**
 * Internal dependencies
 */


function generateErrorKey(baseName, args) {
  if (args && Array.isArray(args)) {
    const stringifiedArgs = args.map(item => {
      return 'object' === typeof item ? (0,_js_util__WEBPACK_IMPORTED_MODULE_2__.stringifyObject)(item) : item;
    });
    return `${baseName}::${md5__WEBPACK_IMPORTED_MODULE_1___default()(JSON.stringify(stringifiedArgs))}`;
  }
  return baseName;
}
const actions = {
  receiveError(error, baseName, args = []) {
    invariant__WEBPACK_IMPORTED_MODULE_0___default()(error, 'error is required.');
    invariant__WEBPACK_IMPORTED_MODULE_0___default()(baseName, 'baseName is required.');
    invariant__WEBPACK_IMPORTED_MODULE_0___default()(args && Array.isArray(args), 'args must be an array.');
    return {
      type: RECEIVE_ERROR,
      payload: {
        error,
        baseName,
        args
      }
    };
  },
  clearError(baseName, args = []) {
    invariant__WEBPACK_IMPORTED_MODULE_0___default()(baseName, 'baseName is required.');
    invariant__WEBPACK_IMPORTED_MODULE_0___default()(args && Array.isArray(args), 'args must be an array.');
    return {
      type: CLEAR_ERROR,
      payload: {
        baseName,
        args
      }
    };
  },
  clearErrors(baseName) {
    return {
      type: CLEAR_ERRORS,
      payload: {
        baseName
      }
    };
  }
};
function createErrorStore(storeName) {
  invariant__WEBPACK_IMPORTED_MODULE_0___default()(storeName, 'storeName must be defined.');
  const initialState = {
    errors: {},
    errorArgs: {}
  };
  const reducer = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__.createReducer)((state, {
    type,
    payload
  }) => {
    switch (type) {
      case RECEIVE_ERROR:
        {
          const {
            baseName,
            args,
            error
          } = payload;
          const key = generateErrorKey(baseName, args);
          state.errors = state.errors || {};
          state.errorArgs = state.errorArgs || {};
          state.errors[key] = error;
          state.errorArgs[key] = args;
          break;
        }
      case CLEAR_ERROR:
        {
          const {
            baseName,
            args
          } = payload;
          const key = generateErrorKey(baseName, args);
          state.errors = state.errors || {};
          state.errorArgs = state.errorArgs || {};
          delete state.errors[key];
          delete state.errorArgs[key];
          break;
        }
      case CLEAR_ERRORS:
        {
          const {
            baseName
          } = payload;
          if (baseName) {
            state.errors = state.errors || {};
            state.errorArgs = state.errorArgs || {};
            for (const key in state.errors) {
              if (key === baseName || key.startsWith(`${baseName}::`)) {
                delete state.errors[key];
                delete state.errorArgs[key];
              }
            }
          } else {
            state.errors = {};
            state.errorArgs = {};
          }
          break;
        }
    }
  });
  const controls = {};
  const resolvers = {};
  const selectors = {
    /**
     * Retrieves the error object from state.
     *
     * Error object has the format:
     *
     * ```
     * {
     *   code: <String>,
     *   message: <String>,
     *   data: <Object>
     * }
     * ```
     *
     * @since 1.15.0
     *
     * @param {Object}      state        Data store's state.
     * @param {string}      selectorName Selector name.
     * @param {Array.<any>} [args]       Arguments passed to selector (default `[]`).
     * @return {(Object|undefined)} Error object if exists, otherwise undefined.
     */
    getErrorForSelector(state, selectorName, args = []) {
      invariant__WEBPACK_IMPORTED_MODULE_0___default()(selectorName, 'selectorName is required.');
      return selectors.getError(state, selectorName, args);
    },
    /**
     * Retrieves the error object from state.
     *
     *```
     * {
     *   code: <String>,
     *   message: <String>,
     *   data: <Object>
     * }
     * ```
     *
     * @since 1.15.0
     *
     * @param {Object}      state      Data store's state.
     * @param {string}      actionName Action name.
     * @param {Array.<any>} [args]     Arguments passed to action (default `[]`).
     * @return {(Object|undefined)} Error object if exists, otherwise undefined.
     */
    getErrorForAction(state, actionName, args = []) {
      invariant__WEBPACK_IMPORTED_MODULE_0___default()(actionName, 'actionName is required.');
      return selectors.getError(state, actionName, args);
    },
    /**
     * Retrieves the error object from state.
     *
     *```
     * {
     *   code: <String>,
     *   message: <String>,
     *   data: <Object>
     * }
     * ```
     *
     * @since 1.15.0
     * @private
     *
     * @param {Object}      state      Data store's state.
     * @param {string}      [baseName] Selector or action name.
     * @param {Array.<any>} [args]     Arguments array.
     * @return {(Object|undefined)} Error object if exists, otherwise undefined.
     */
    getError(state, baseName, args) {
      const {
        errors
      } = state;
      invariant__WEBPACK_IMPORTED_MODULE_0___default()(baseName, 'baseName is required.');
      return errors[generateErrorKey(baseName, args)];
    },
    /**
     * Gets a list of all unique errors.
     *
     * @since 1.19.0
     *
     * @param {Object} state Data store's state.
     * @return {Object[]} Unique set of errors.
     */
    getErrors(state) {
      const errorsSet = new Set(Object.values(state.errors));
      return Array.from(errorsSet);
    },
    /**
     * Gets the meta-data for a given error object, or null if the error is not found.
     *
     * Returns meta-data in the format:
     *
     * ```
     *	{
     *		baseName: <string>,
     *		args: <Array>
     *	}
     * ```
     *
     * @since 1.84.0
     *
     * @param {Object} state Data store's state.
     * @param {Object} error Error object.
     * @return {Object|null} Meta-data for the given error object, or null if the error is not found.
     */
    getMetaDataForError(state, error) {
      const key = Object.keys(state.errors).find(errorKey => state.errors[errorKey] === error);
      if (key) {
        const baseName = key.substring(0, key.indexOf('::'));
        return {
          baseName,
          args: state.errorArgs[key]
        };
      }
      return null;
    },
    /**
     * Gets the selector data for a given error object, or null if no selector data is available.
     *
     * Returns selector data in the format:
     *
     * ```
     *	{
     *		storeName: <string>,
     *		name: <string>,
     *		args: <Array>
     *	}
     * ```
     *
     * @since 1.87.0
     *
     * @param {Object} state Data store's state.
     * @param {Object} error Error object.
     * @return {Object|null} Selector data for the given error object, or null if no selector data is available.
     */
    getSelectorDataForError: (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_4__.createRegistrySelector)(select => function (state, error) {
      const metaData = select(storeName).getMetaDataForError(error);
      if (metaData) {
        const {
          baseName: name,
          args
        } = metaData;
        const isSelector = !!select(storeName)[name];
        if (isSelector) {
          return {
            storeName,
            name,
            args
          };
        }
      }
      return null;
    }),
    /**
     * Determines whether the datastore has errors or not.
     *
     * @since 1.15.0
     *
     * @param {Object} state Data store's state.
     * @return {boolean} TRUE if the datastore has errors, otherwise FALSE.
     */
    hasErrors(state) {
      return selectors.getErrors(state).length > 0;
    }
  };
  return {
    initialState,
    actions,
    controls,
    reducer,
    resolvers,
    selectors
  };
}

/***/ }),

/***/ "./js/googlesitekit/data/create-reducer.js":
/*!*************************************************!*\
  !*** ./js/googlesitekit/data/create-reducer.js ***!
  \*************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   createReducer: () => (/* binding */ createReducer)
/* harmony export */ });
/* harmony import */ var immer__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! immer */ "../node_modules/immer/dist/immer.esm.mjs");
/**
 * Create Immer reducer utility function.
 *
 * Site Kit by Google, Copyright 2022 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * Creates an Immer-enabled reducer.
 *
 * @since 1.84.0
 *
 * @param {Function} reducerFunction A reducer function that follows the curried Immer recipe pattern.
 * @return {Function} An Immer-enabled reducer.
 */
function createReducer(reducerFunction) {
  return (0,immer__WEBPACK_IMPORTED_MODULE_0__["default"])(reducerFunction);
}

/***/ }),

/***/ "./js/googlesitekit/data/index.js":
/*!****************************************!*\
  !*** ./js/googlesitekit/data/index.js ***!
  \****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   RegistryProvider: () => (/* reexport safe */ _wordpress_data__WEBPACK_IMPORTED_MODULE_11__["default"]),
/* harmony export */   combineStores: () => (/* reexport safe */ _utils__WEBPACK_IMPORTED_MODULE_1__.combineStores),
/* harmony export */   commonActions: () => (/* reexport safe */ _utils__WEBPACK_IMPORTED_MODULE_1__.commonActions),
/* harmony export */   commonControls: () => (/* reexport safe */ _utils__WEBPACK_IMPORTED_MODULE_1__.commonControls),
/* harmony export */   commonStore: () => (/* reexport safe */ _utils__WEBPACK_IMPORTED_MODULE_1__.commonStore),
/* harmony export */   controls: () => (/* reexport safe */ _wordpress_data__WEBPACK_IMPORTED_MODULE_4__.controls),
/* harmony export */   createReducer: () => (/* reexport safe */ _create_reducer__WEBPACK_IMPORTED_MODULE_2__.createReducer),
/* harmony export */   createRegistryControl: () => (/* reexport safe */ _wordpress_data__WEBPACK_IMPORTED_MODULE_5__.createRegistryControl),
/* harmony export */   createRegistrySelector: () => (/* reexport safe */ _wordpress_data__WEBPACK_IMPORTED_MODULE_5__.createRegistrySelector),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   useDispatch: () => (/* reexport safe */ _wordpress_data__WEBPACK_IMPORTED_MODULE_7__["default"]),
/* harmony export */   useInViewSelect: () => (/* reexport safe */ _js_hooks_useInViewSelect__WEBPACK_IMPORTED_MODULE_0__.useInViewSelect),
/* harmony export */   useRegistry: () => (/* reexport safe */ _wordpress_data__WEBPACK_IMPORTED_MODULE_8__["default"]),
/* harmony export */   useSelect: () => (/* reexport safe */ _wordpress_data__WEBPACK_IMPORTED_MODULE_6__["default"]),
/* harmony export */   withDispatch: () => (/* reexport safe */ _wordpress_data__WEBPACK_IMPORTED_MODULE_10__["default"]),
/* harmony export */   withSelect: () => (/* reexport safe */ _wordpress_data__WEBPACK_IMPORTED_MODULE_9__["default"])
/* harmony export */ });
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/data */ "../node_modules/@wordpress/data/build-module/registry.js");
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @wordpress/data */ "../node_modules/@wordpress/data/build-module/controls.js");
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @wordpress/data */ "../node_modules/@wordpress/data/build-module/factory.js");
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @wordpress/data */ "../node_modules/@wordpress/data/build-module/components/use-select/index.js");
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @wordpress/data */ "../node_modules/@wordpress/data/build-module/components/use-dispatch/use-dispatch.js");
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @wordpress/data */ "../node_modules/@wordpress/data/build-module/components/registry-provider/use-registry.js");
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @wordpress/data */ "../node_modules/@wordpress/data/build-module/components/with-select/index.js");
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @wordpress/data */ "../node_modules/@wordpress/data/build-module/components/with-dispatch/index.js");
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @wordpress/data */ "../node_modules/@wordpress/data/build-module/components/registry-provider/context.js");
/* harmony import */ var _js_hooks_useInViewSelect__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @/js/hooks/useInViewSelect */ "./js/hooks/useInViewSelect.js");
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./utils */ "./js/googlesitekit/data/utils.js");
/* harmony import */ var _create_reducer__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./create-reducer */ "./js/googlesitekit/data/create-reducer.js");
/**
 * Site Kit @wordpress/data (eg Redux-style) data store.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */




/**
 * @since n.e.x.t
 *
 * @typedef {Object} WPDataRegistry
 * @property {Function} registerStore Given a namespace key and settings
 *                                    object, registers a new namespace
 *                                    store.
 * @property {Function} subscribe     Given a function callback, invokes
 *                                    the callback on any change to state
 *                                    within any registered store.
 * @property {Function} select        Given a namespace key, returns an
 *                                    object of the store's registered
 *                                    selectors.
 * @property {Function} dispatch      Given a namespace key, returns an
 *                                    object of the store's registered
 *                                    action dispatchers.
 * @property {Function} resolveSelect Given a namespace key, returns an
 *                                    object containing the store's
 *                                    selectors modified so that they return
 *                                    promises that resolve to their eventual
 *                                    values, after any resolvers have run.
 */

/**
 * The Site Kit data registry.
 *
 * This should not be imported directly outside of `googlesitekit-*` files
 * that need access to the registry to register datastores/widgets/etc.
 *
 * Instead, use the exported functions (eg `useSelect`,
 * `createRegistrySelector`, etc.) from the `googlesitekit-data` package to
 * access parts of the registry.
 *
 * @since 1.3.0 Data registry introduced.
 * @since 1.130.0 Deprecated for general use in favor of named exports from `googlesitekit-data` package.
 * @deprecated
 */
const Data = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_3__.createRegistry)({}, __webpack_require__.g.wp?.data);

// Attach some of our utility functions to the registry so third-party
// developers can use them.
Data.combineStores = _utils__WEBPACK_IMPORTED_MODULE_1__.combineStores;
Data.commonActions = _utils__WEBPACK_IMPORTED_MODULE_1__.commonActions;
Data.commonControls = _utils__WEBPACK_IMPORTED_MODULE_1__.commonControls;
Data.commonStore = _utils__WEBPACK_IMPORTED_MODULE_1__.commonStore;
Data.createReducer = _create_reducer__WEBPACK_IMPORTED_MODULE_2__.createReducer;

// Attach our custom, useInViewSelect hook to the registry so third-party
// developers can use it.
Data.useInViewSelect = _js_hooks_useInViewSelect__WEBPACK_IMPORTED_MODULE_0__.useInViewSelect;

// Attach some WordPress data functions to the registry so third-party
// developers can use them without importing '@wordpress/data'.
Data.controls = _wordpress_data__WEBPACK_IMPORTED_MODULE_4__.controls;
Data.createRegistryControl = _wordpress_data__WEBPACK_IMPORTED_MODULE_5__.createRegistryControl;
Data.createRegistrySelector = _wordpress_data__WEBPACK_IMPORTED_MODULE_5__.createRegistrySelector;
Data.useSelect = _wordpress_data__WEBPACK_IMPORTED_MODULE_6__["default"];
Data.useDispatch = _wordpress_data__WEBPACK_IMPORTED_MODULE_7__["default"];
Data.useRegistry = _wordpress_data__WEBPACK_IMPORTED_MODULE_8__["default"];
Data.withSelect = _wordpress_data__WEBPACK_IMPORTED_MODULE_9__["default"];
Data.withDispatch = _wordpress_data__WEBPACK_IMPORTED_MODULE_10__["default"];
Data.RegistryProvider = _wordpress_data__WEBPACK_IMPORTED_MODULE_11__["default"];

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Data);

/***/ }),

/***/ "./js/googlesitekit/data/transform-case.js":
/*!*************************************************!*\
  !*** ./js/googlesitekit/data/transform-case.js ***!
  \*************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   camelCaseToConstantCase: () => (/* binding */ camelCaseToConstantCase),
/* harmony export */   camelCaseToPascalCase: () => (/* binding */ camelCaseToPascalCase),
/* harmony export */   hyphenCaseToPascalCase: () => (/* binding */ hyphenCaseToPascalCase)
/* harmony export */ });
/**
 * Data store utilities for transforming names to a certain case.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Transforms a camelCase name into its PascalCase name.
 *
 * @since 1.10.0
 * @private
 *
 * @param {string} name "camelCase" name to transform.
 * @return {string} PascalCase name.
 */
function camelCaseToPascalCase(name) {
  return name.charAt(0).toUpperCase() + name.slice(1);
}

/**
 * Transforms a camelCase name into its CONSTANT_CASE name.
 *
 * @since 1.10.0
 * @private
 *
 * @param {string} name "camelCase" name to transform.
 * @return {string} CONSTANT_CASE name.
 */
function camelCaseToConstantCase(name) {
  return name.replace(/([a-z0-9]{1})([A-Z]{1})/g, '$1_$2').toUpperCase();
}

/**
 * Transforms a hyphen-case name into its PascalCase name.
 *
 * @since 1.30.0
 * @private
 *
 * @param {string} name "hyphen-case" name to transform.
 * @return {string} PascalCase name.
 */
function hyphenCaseToPascalCase(name) {
  return name.split('-').map(part => part.charAt(0).toUpperCase() + part.slice(1)).join('');
}

/***/ }),

/***/ "./js/googlesitekit/data/utils.js":
/*!****************************************!*\
  !*** ./js/googlesitekit/data/utils.js ***!
  \****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   collect: () => (/* binding */ collect),
/* harmony export */   collectActions: () => (/* binding */ collectActions),
/* harmony export */   collectControls: () => (/* binding */ collectControls),
/* harmony export */   collectName: () => (/* binding */ collectName),
/* harmony export */   collectReducers: () => (/* binding */ collectReducers),
/* harmony export */   collectResolvers: () => (/* binding */ collectResolvers),
/* harmony export */   collectSelectors: () => (/* binding */ collectSelectors),
/* harmony export */   collectState: () => (/* binding */ collectState),
/* harmony export */   combineStores: () => (/* binding */ combineStores),
/* harmony export */   commonActions: () => (/* binding */ commonActions),
/* harmony export */   commonControls: () => (/* binding */ commonControls),
/* harmony export */   commonStore: () => (/* binding */ commonStore),
/* harmony export */   createStrictSelect: () => (/* binding */ createStrictSelect),
/* harmony export */   createValidatedAction: () => (/* binding */ createValidatedAction),
/* harmony export */   createValidationSelector: () => (/* binding */ createValidationSelector)
/* harmony export */ });
/* harmony import */ var invariant__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! invariant */ "../node_modules/invariant/browser.js");
/* harmony import */ var invariant__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(invariant__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var memize__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! memize */ "../node_modules/memize/index.js");
/* harmony import */ var memize__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(memize__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! lodash */ "../node_modules/lodash/lodash.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/data */ "../node_modules/@wordpress/data/build-module/factory.js");
/**
 * Data store utilities.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */




/**
 * WordPress dependencies
 */

const GET_REGISTRY = 'GET_REGISTRY';
const AWAIT = 'AWAIT';

/**
 * Collects and combines multiple objects of similar shape.
 *
 * Used to combine objects like actions, selectors, etc. for a data
 * store while ensuring no keys/action names/selector names are duplicated.
 *
 * Effectively this is an object spread, but throws an error if keys are
 * duplicated.
 *
 * @since 1.5.0
 * @private
 *
 * @param {...Object} items A list of arguments, each one should be an object to combine into one.
 * @return {Object} The combined object.
 */
function collect(...items) {
  const collectedObject = items.reduce((acc, item) => {
    return {
      ...acc,
      ...item
    };
  }, {});
  const functionNames = items.reduce((acc, itemSet) => {
    return [...acc, ...Object.keys(itemSet)];
  }, []);
  const duplicates = findDuplicates(functionNames);
  invariant__WEBPACK_IMPORTED_MODULE_0___default()(duplicates.length === 0, `collect() cannot accept collections with duplicate keys. Your call to collect() contains the following duplicated functions: ${duplicates.join(', ')}. Check your data stores for duplicates.`);
  return collectedObject;
}

/**
 * Collects all actions.
 *
 * @since 1.5.0
 *
 * @param {...Object} args A list of objects, each containing their own actions.
 * @return {Object} The combined object.
 */
const collectActions = collect;

/**
 * Collects all controls.
 *
 * @since 1.5.0
 *
 * @param {...Object} args A list of objects, each containing their own controls.
 * @return {Object} The combined object.
 */
const collectControls = collect;

/**
 * Collects all reducers and (optionally) provides initial state.
 *
 * If the first argument passed is not a function, it will be used as the
 * combined reducer's `initialState`.
 *
 * @since 1.5.0
 *
 * @param {...(Object|Function)} args A list of reducers, each containing their own controls. If the first argument is not a function, it will be used as the combined reducer's `initialState`.
 * @return {Function} A Redux-style reducer.
 */
function collectReducers(...args) {
  const reducers = [...args];
  let initialState;
  if (typeof reducers[0] !== 'function') {
    initialState = reducers.shift();
  }
  return (state = initialState, action = {}) => {
    return reducers.reduce((newState, reducer) => {
      return reducer(newState, action);
    }, state);
  };
}

/**
 * Collects all resolvers.
 *
 * @since 1.5.0
 *
 * @param {...Object} args A list of objects, each containing their own resolvers.
 * @return {Object} The combined object.
 */
const collectResolvers = collect;

/**
 * Collects all selectors.
 *
 * @since 1.5.0
 *
 * @param {...Object} args A list of objects, each containing their own selectors.
 * @return {Object} The combined object.
 */
const collectSelectors = collect;

/**
 * Collects all state values.
 *
 * @since 1.5.0
 *
 * @param {...Object} args A list of objects, each containing their own state values.
 * @return {Object} The combined object.
 */
const collectState = collect;

/**
 * Collects all store names.
 *
 * This function's main purpose is to ensure generated store names for a single store match.
 *
 * @since 1.6.0
 *
 * @param {...string} args A list of store names, all of which must be equal.
 * @return {string} The single store name.
 */
function collectName(...args) {
  const names = [...args];
  const duplicates = findDuplicates(names);
  invariant__WEBPACK_IMPORTED_MODULE_0___default()(duplicates.length === names.length - 1, 'collectName() must not receive different names.');
  return names.shift();
}

/**
 * Passes through state unmodified; eg. an empty reducer.
 *
 * @since 1.8.0
 * @private
 *
 * @param {Object} state A store's state.
 * @return {Object} The same state data as passed in `state`.
 */
function passthroughReducer(state) {
  return state;
}

/**
 * Combines multiple stores.
 *
 * @since 1.8.0
 *
 * @param {...Object} stores A list of objects, each a store containing one or more of the following keys: initialState, actions, controls, reducer, resolvers, selectors.
 * @return {Object} The combined store.
 */
function combineStores(...stores) {
  const combinedInitialState = collectState(...stores.map(store => store.initialState || {}));
  return {
    initialState: combinedInitialState,
    controls: collectControls(...stores.map(store => store.controls || {})),
    actions: collectActions(...stores.map(store => store.actions || {})),
    reducer: collectReducers(combinedInitialState, ...stores.map(store => store.reducer || passthroughReducer)),
    resolvers: collectResolvers(...stores.map(store => store.resolvers || {})),
    selectors: collectSelectors(...stores.map(store => store.selectors || {}))
  };
}

/**
 * An object of common actions most stores will use.
 *
 * @since 1.7.0
 *
 * @return {Object} Key/value list of common actions most stores will want.
 */
const commonActions = {
  /**
   * Dispatches an action and calls a control to get the current data registry.
   *
   * Useful for controls and resolvers that wish to dispatch actions/use selectors
   * on the current data registry.
   *
   * @since 1.7.0
   *
   * @return {Object} FSA-compatible action.
   */
  getRegistry() {
    return {
      payload: {},
      type: GET_REGISTRY
    };
  },
  /**
   * Dispatches an action and calls a control to return the promise resolution.
   *
   * Useful for controls and resolvers that wish to call an asynchronous function or other promise.
   *
   * @since 1.22.0
   *
   * @param {Promise} value A promise to resolve.
   * @return {Object} Object with resolved promise.
   */
  *await(value) {
    return {
      payload: {
        value
      },
      type: AWAIT
    };
  }
};

/**
 * An object of common controls most stores will use.
 *
 * @since 1.7.0
 *
 * @return {Object} Key/value list of common controls most stores will want.
 */
const commonControls = {
  /**
   * Returns the current registry.
   *
   * Useful for controls and resolvers that wish to dispatch actions/use selectors
   * on the current data registry.
   *
   * @since 1.7.0
   *
   * @return {Object} FSA-compatible action.
   */
  [GET_REGISTRY]: (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_3__.createRegistryControl)(registry => () => registry),
  /**
   * Returns a resolved promise.
   *
   * @since 1.22.0
   *
   * @param {Object} payload         Object containing a promise.
   * @param {Object} payload.payload Object containing a promise.
   * @return {*} Resolved promise.
   */
  [AWAIT]: ({
    payload
  }) => payload.value
};

/**
 * Finds all duplicate items in an array and return them.
 *
 * @since 1.5.0
 * @private
 *
 * @param {Array} array Any array.
 * @return {Array} All values in the input array that were duplicated.
 */
function findDuplicates(array) {
  const duplicates = [];
  const counts = {};
  for (let i = 0; i < array.length; i++) {
    const item = array[i];
    counts[item] = counts[item] >= 1 ? counts[item] + 1 : 1;
    if (counts[item] > 1) {
      duplicates.push(item);
    }
  }
  return duplicates;
}

/**
 * A store containing the common actions, controls and reducer that all stores will use.
 *
 * @since 1.8.0
 *
 * @return {Object} Object with common actions, controls and reducer.
 */
const commonStore = {
  actions: commonActions,
  controls: commonControls,
  reducer: passthroughReducer
};

/**
 * Creates a strict version of registry.select for ensuring that a selector is resolved at the time of calling.
 *
 * Not intended to be used directly. This is useful in the context of validation functions
 * to save checking for undefined on every result.
 *
 * Given the registry.select function instance, a new function is returned
 * with the same API as `select()` but will throw an error if the result
 * of the selector function is `undefined`.
 *
 * Ideally this would use something like `hasFinishedResolution` instead,
 * but there is no way to traverse the selectors used internally to identify
 * dependent selectors that have resolvers as many selectors are composed of
 * higher-level selectors internally which is where a resolver is normally implemented.
 *
 * @since 1.18.0
 * @private
 *
 * @param {Function} select The registry.select function.
 * @return {Function} The strict version of registry.select.
 */
function createStrictSelect(select) {
  return storeName => {
    return getStrictSelectors(select(storeName));
  };
}

// Based on {@link https://github.com/WordPress/gutenberg/blob/b1c8026087dfb026eff0a023a5f7febe28c876de/packages/data/src/registry.js#L91}
const getStrictSelectors = memize__WEBPACK_IMPORTED_MODULE_1___default()(selectors => (0,lodash__WEBPACK_IMPORTED_MODULE_2__.mapValues)(selectors, (selector, selectorName) => (...args) => {
  const returnValue = selector(...args);
  invariant__WEBPACK_IMPORTED_MODULE_0___default()(returnValue !== undefined, `${selectorName}(...) is not resolved`);
  return returnValue;
}));

/**
 * Creates two registry selectors that call the incoming function to validate the current state.
 *
 * @since 1.19.0
 *
 * @param {Function} validate         Validation function callback.
 * @param {Object}   [options]        Options to modify the behavior of the generated selectors.
 * @param {boolean}  [options.negate] Whether to negate the boolean result or not. Default: false.
 * @return {Object} Safe and dangerous selectors.
 */
function createValidationSelector(validate, {
  negate = false
} = {}) {
  const safeSelector = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_3__.createRegistrySelector)(select => (state, ...args) => {
    const pass = negate ? false : true;
    const fail = negate ? true : false;
    try {
      validate(select, state, ...args);
      return pass;
    } catch {
      return fail;
    }
  });
  const dangerousSelector = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_3__.createRegistrySelector)(select => (state, ...args) => {
    validate(select, state, ...args);
  });
  return {
    safeSelector,
    dangerousSelector
  };
}

/**
 * Creates a validated action creator.
 *
 * @since 1.32.0
 *
 * @param {Function} validate      A function for validating action arguments.
 * @param {Function} actionCreator A function for returning or yielding redux-style actions.
 * @return {Function} An enhanced action creator.
 */
function createValidatedAction(validate, actionCreator) {
  invariant__WEBPACK_IMPORTED_MODULE_0___default()(typeof validate === 'function', 'a validator function is required.');
  invariant__WEBPACK_IMPORTED_MODULE_0___default()(typeof actionCreator === 'function', 'an action creator function is required.');
  invariant__WEBPACK_IMPORTED_MODULE_0___default()(validate[Symbol.toStringTag] !== 'Generator' && validate[Symbol.toStringTag] !== 'GeneratorFunction', 'an action’s validator function must not be a generator.');
  return (...args) => {
    validate(...args);
    return actionCreator(...args);
  };
}

/***/ }),

/***/ "./js/googlesitekit/datastore/forms/constants.js":
/*!*******************************************************!*\
  !*** ./js/googlesitekit/datastore/forms/constants.js ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   CORE_FORMS: () => (/* binding */ CORE_FORMS)
/* harmony export */ });
/**
 * `core/forms` data store: constants.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

const CORE_FORMS = 'core/forms';

/***/ }),

/***/ "./js/googlesitekit/datastore/location/constants.js":
/*!**********************************************************!*\
  !*** ./js/googlesitekit/datastore/location/constants.js ***!
  \**********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   CORE_LOCATION: () => (/* binding */ CORE_LOCATION)
/* harmony export */ });
/**
 * `core/location` data store: constants.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

const CORE_LOCATION = 'core/location';

/***/ }),

/***/ "./js/googlesitekit/datastore/site/constants.js":
/*!******************************************************!*\
  !*** ./js/googlesitekit/datastore/site/constants.js ***!
  \******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   AMP_MODE_PRIMARY: () => (/* binding */ AMP_MODE_PRIMARY),
/* harmony export */   AMP_MODE_SECONDARY: () => (/* binding */ AMP_MODE_SECONDARY),
/* harmony export */   CORE_SITE: () => (/* binding */ CORE_SITE)
/* harmony export */ });
/**
 * `core/site` data store: constants.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

const CORE_SITE = 'core/site';
const AMP_MODE_PRIMARY = 'primary';
const AMP_MODE_SECONDARY = 'secondary';

/***/ }),

/***/ "./js/googlesitekit/datastore/ui/constants.js":
/*!****************************************************!*\
  !*** ./js/googlesitekit/datastore/ui/constants.js ***!
  \****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ACTIVE_CONTEXT_ID: () => (/* binding */ ACTIVE_CONTEXT_ID),
/* harmony export */   CORE_UI: () => (/* binding */ CORE_UI)
/* harmony export */ });
/**
 * `core/ui` data store: constants.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

const CORE_UI = 'core/ui';
const ACTIVE_CONTEXT_ID = 'activeContextID';

/***/ }),

/***/ "./js/googlesitekit/datastore/user/constants.js":
/*!******************************************************!*\
  !*** ./js/googlesitekit/datastore/user/constants.js ***!
  \******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   CORE_USER: () => (/* binding */ CORE_USER),
/* harmony export */   DISCONNECTED_REASON_CONNECTED_URL_MISMATCH: () => (/* binding */ DISCONNECTED_REASON_CONNECTED_URL_MISMATCH),
/* harmony export */   EMAIL_REPORT_FREQUENCIES: () => (/* binding */ EMAIL_REPORT_FREQUENCIES),
/* harmony export */   ERROR_CODE_ADBLOCKER_ACTIVE: () => (/* binding */ ERROR_CODE_ADBLOCKER_ACTIVE),
/* harmony export */   FORM_TEMPORARY_PERSIST_PERMISSION_ERROR: () => (/* binding */ FORM_TEMPORARY_PERSIST_PERMISSION_ERROR),
/* harmony export */   GLOBAL_SURVEYS_TIMEOUT_SLUG: () => (/* binding */ GLOBAL_SURVEYS_TIMEOUT_SLUG),
/* harmony export */   KM_ANALYTICS_ADSENSE_TOP_EARNING_CONTENT: () => (/* binding */ KM_ANALYTICS_ADSENSE_TOP_EARNING_CONTENT),
/* harmony export */   KM_ANALYTICS_ENGAGED_TRAFFIC_SOURCE: () => (/* binding */ KM_ANALYTICS_ENGAGED_TRAFFIC_SOURCE),
/* harmony export */   KM_ANALYTICS_LEAST_ENGAGING_PAGES: () => (/* binding */ KM_ANALYTICS_LEAST_ENGAGING_PAGES),
/* harmony export */   KM_ANALYTICS_MOST_ENGAGING_PAGES: () => (/* binding */ KM_ANALYTICS_MOST_ENGAGING_PAGES),
/* harmony export */   KM_ANALYTICS_NEW_VISITORS: () => (/* binding */ KM_ANALYTICS_NEW_VISITORS),
/* harmony export */   KM_ANALYTICS_PAGES_PER_VISIT: () => (/* binding */ KM_ANALYTICS_PAGES_PER_VISIT),
/* harmony export */   KM_ANALYTICS_POPULAR_AUTHORS: () => (/* binding */ KM_ANALYTICS_POPULAR_AUTHORS),
/* harmony export */   KM_ANALYTICS_POPULAR_CONTENT: () => (/* binding */ KM_ANALYTICS_POPULAR_CONTENT),
/* harmony export */   KM_ANALYTICS_POPULAR_PRODUCTS: () => (/* binding */ KM_ANALYTICS_POPULAR_PRODUCTS),
/* harmony export */   KM_ANALYTICS_RETURNING_VISITORS: () => (/* binding */ KM_ANALYTICS_RETURNING_VISITORS),
/* harmony export */   KM_ANALYTICS_TOP_CATEGORIES: () => (/* binding */ KM_ANALYTICS_TOP_CATEGORIES),
/* harmony export */   KM_ANALYTICS_TOP_CITIES: () => (/* binding */ KM_ANALYTICS_TOP_CITIES),
/* harmony export */   KM_ANALYTICS_TOP_CITIES_DRIVING_ADD_TO_CART: () => (/* binding */ KM_ANALYTICS_TOP_CITIES_DRIVING_ADD_TO_CART),
/* harmony export */   KM_ANALYTICS_TOP_CITIES_DRIVING_LEADS: () => (/* binding */ KM_ANALYTICS_TOP_CITIES_DRIVING_LEADS),
/* harmony export */   KM_ANALYTICS_TOP_CITIES_DRIVING_PURCHASES: () => (/* binding */ KM_ANALYTICS_TOP_CITIES_DRIVING_PURCHASES),
/* harmony export */   KM_ANALYTICS_TOP_CONVERTING_TRAFFIC_SOURCE: () => (/* binding */ KM_ANALYTICS_TOP_CONVERTING_TRAFFIC_SOURCE),
/* harmony export */   KM_ANALYTICS_TOP_COUNTRIES: () => (/* binding */ KM_ANALYTICS_TOP_COUNTRIES),
/* harmony export */   KM_ANALYTICS_TOP_DEVICE_DRIVING_PURCHASES: () => (/* binding */ KM_ANALYTICS_TOP_DEVICE_DRIVING_PURCHASES),
/* harmony export */   KM_ANALYTICS_TOP_PAGES_DRIVING_LEADS: () => (/* binding */ KM_ANALYTICS_TOP_PAGES_DRIVING_LEADS),
/* harmony export */   KM_ANALYTICS_TOP_RECENT_TRENDING_PAGES: () => (/* binding */ KM_ANALYTICS_TOP_RECENT_TRENDING_PAGES),
/* harmony export */   KM_ANALYTICS_TOP_RETURNING_VISITOR_PAGES: () => (/* binding */ KM_ANALYTICS_TOP_RETURNING_VISITOR_PAGES),
/* harmony export */   KM_ANALYTICS_TOP_TRAFFIC_SOURCE: () => (/* binding */ KM_ANALYTICS_TOP_TRAFFIC_SOURCE),
/* harmony export */   KM_ANALYTICS_TOP_TRAFFIC_SOURCE_DRIVING_ADD_TO_CART: () => (/* binding */ KM_ANALYTICS_TOP_TRAFFIC_SOURCE_DRIVING_ADD_TO_CART),
/* harmony export */   KM_ANALYTICS_TOP_TRAFFIC_SOURCE_DRIVING_LEADS: () => (/* binding */ KM_ANALYTICS_TOP_TRAFFIC_SOURCE_DRIVING_LEADS),
/* harmony export */   KM_ANALYTICS_TOP_TRAFFIC_SOURCE_DRIVING_PURCHASES: () => (/* binding */ KM_ANALYTICS_TOP_TRAFFIC_SOURCE_DRIVING_PURCHASES),
/* harmony export */   KM_ANALYTICS_VISITS_PER_VISITOR: () => (/* binding */ KM_ANALYTICS_VISITS_PER_VISITOR),
/* harmony export */   KM_ANALYTICS_VISIT_LENGTH: () => (/* binding */ KM_ANALYTICS_VISIT_LENGTH),
/* harmony export */   KM_SEARCH_CONSOLE_POPULAR_KEYWORDS: () => (/* binding */ KM_SEARCH_CONSOLE_POPULAR_KEYWORDS),
/* harmony export */   PERMISSION_AUTHENTICATE: () => (/* binding */ PERMISSION_AUTHENTICATE),
/* harmony export */   PERMISSION_DELEGATE_MODULE_SHARING_MANAGEMENT: () => (/* binding */ PERMISSION_DELEGATE_MODULE_SHARING_MANAGEMENT),
/* harmony export */   PERMISSION_MANAGE_MODULE_SHARING_OPTIONS: () => (/* binding */ PERMISSION_MANAGE_MODULE_SHARING_OPTIONS),
/* harmony export */   PERMISSION_MANAGE_OPTIONS: () => (/* binding */ PERMISSION_MANAGE_OPTIONS),
/* harmony export */   PERMISSION_READ_SHARED_MODULE_DATA: () => (/* binding */ PERMISSION_READ_SHARED_MODULE_DATA),
/* harmony export */   PERMISSION_SETUP: () => (/* binding */ PERMISSION_SETUP),
/* harmony export */   PERMISSION_UPDATE_PLUGINS: () => (/* binding */ PERMISSION_UPDATE_PLUGINS),
/* harmony export */   PERMISSION_VIEW_DASHBOARD: () => (/* binding */ PERMISSION_VIEW_DASHBOARD),
/* harmony export */   PERMISSION_VIEW_MODULE_DETAILS: () => (/* binding */ PERMISSION_VIEW_MODULE_DETAILS),
/* harmony export */   PERMISSION_VIEW_POSTS_INSIGHTS: () => (/* binding */ PERMISSION_VIEW_POSTS_INSIGHTS),
/* harmony export */   PERMISSION_VIEW_SHARED_DASHBOARD: () => (/* binding */ PERMISSION_VIEW_SHARED_DASHBOARD),
/* harmony export */   allKeyMetricsTileWidgets: () => (/* binding */ allKeyMetricsTileWidgets),
/* harmony export */   keyMetricsGA4Widgets: () => (/* binding */ keyMetricsGA4Widgets)
/* harmony export */ });
/**
 * `core/user` data store: constants.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

const CORE_USER = 'core/user';
const DISCONNECTED_REASON_CONNECTED_URL_MISMATCH = 'connected_url_mismatch';
const GLOBAL_SURVEYS_TIMEOUT_SLUG = '__global';
const FORM_TEMPORARY_PERSIST_PERMISSION_ERROR = 'temporary_persist_permission_error';
const ERROR_CODE_ADBLOCKER_ACTIVE = 'adblocker_active';

// Email Report Frequency options.
const EMAIL_REPORT_FREQUENCIES = ['weekly', 'monthly', 'quarterly'];

// Permissions list.
const PERMISSION_AUTHENTICATE = 'googlesitekit_authenticate';
const PERMISSION_SETUP = 'googlesitekit_setup';
const PERMISSION_VIEW_POSTS_INSIGHTS = 'googlesitekit_view_posts_insights';
const PERMISSION_VIEW_DASHBOARD = 'googlesitekit_view_dashboard';
const PERMISSION_VIEW_SHARED_DASHBOARD = 'googlesitekit_view_shared_dashboard';
const PERMISSION_VIEW_MODULE_DETAILS = 'googlesitekit_view_module_details';
const PERMISSION_MANAGE_OPTIONS = 'googlesitekit_manage_options';
const PERMISSION_READ_SHARED_MODULE_DATA = 'googlesitekit_read_shared_module_data';
const PERMISSION_MANAGE_MODULE_SHARING_OPTIONS = 'googlesitekit_manage_module_sharing_options';
const PERMISSION_DELEGATE_MODULE_SHARING_MANAGEMENT = 'googlesitekit_delegate_module_sharing_management';
const PERMISSION_UPDATE_PLUGINS = 'googlesitekit_update_plugins';

// Key Metrics Widgets
const KM_ANALYTICS_ADSENSE_TOP_EARNING_CONTENT = 'kmAnalyticsAdSenseTopEarningContent';
const KM_ANALYTICS_ENGAGED_TRAFFIC_SOURCE = 'kmAnalyticsEngagedTrafficSource';
const KM_ANALYTICS_LEAST_ENGAGING_PAGES = 'kmAnalyticsLeastEngagingPages';
const KM_ANALYTICS_NEW_VISITORS = 'kmAnalyticsNewVisitors';
const KM_ANALYTICS_POPULAR_AUTHORS = 'kmAnalyticsPopularAuthors';
const KM_ANALYTICS_POPULAR_CONTENT = 'kmAnalyticsPopularContent';
const KM_ANALYTICS_POPULAR_PRODUCTS = 'kmAnalyticsPopularProducts';
const KM_ANALYTICS_RETURNING_VISITORS = 'kmAnalyticsReturningVisitors';
const KM_ANALYTICS_TOP_CITIES = 'kmAnalyticsTopCities';
const KM_ANALYTICS_TOP_CITIES_DRIVING_LEADS = 'kmAnalyticsTopCitiesDrivingLeads';
const KM_ANALYTICS_TOP_CITIES_DRIVING_ADD_TO_CART = 'kmAnalyticsTopCitiesDrivingAddToCart';
const KM_ANALYTICS_TOP_CITIES_DRIVING_PURCHASES = 'kmAnalyticsTopCitiesDrivingPurchases';
const KM_ANALYTICS_TOP_DEVICE_DRIVING_PURCHASES = 'kmAnalyticsTopDeviceDrivingPurchases';
const KM_ANALYTICS_TOP_CONVERTING_TRAFFIC_SOURCE = 'kmAnalyticsTopConvertingTrafficSource';
const KM_ANALYTICS_TOP_COUNTRIES = 'kmAnalyticsTopCountries';
const KM_ANALYTICS_TOP_PAGES_DRIVING_LEADS = 'kmAnalyticsTopPagesDrivingLeads';
const KM_ANALYTICS_TOP_RECENT_TRENDING_PAGES = 'kmAnalyticsTopRecentTrendingPages';
const KM_ANALYTICS_TOP_TRAFFIC_SOURCE = 'kmAnalyticsTopTrafficSource';
const KM_ANALYTICS_TOP_TRAFFIC_SOURCE_DRIVING_ADD_TO_CART = 'kmAnalyticsTopTrafficSourceDrivingAddToCart';
const KM_ANALYTICS_TOP_TRAFFIC_SOURCE_DRIVING_LEADS = 'kmAnalyticsTopTrafficSourceDrivingLeads';
const KM_ANALYTICS_TOP_TRAFFIC_SOURCE_DRIVING_PURCHASES = 'kmAnalyticsTopTrafficSourceDrivingPurchases';
const KM_ANALYTICS_PAGES_PER_VISIT = 'kmAnalyticsPagesPerVisit';
const KM_ANALYTICS_VISIT_LENGTH = 'kmAnalyticsVisitLength';
const KM_ANALYTICS_TOP_RETURNING_VISITOR_PAGES = 'kmAnalyticsTopReturningVisitorPages';
const KM_SEARCH_CONSOLE_POPULAR_KEYWORDS = 'kmSearchConsolePopularKeywords';
const KM_ANALYTICS_VISITS_PER_VISITOR = 'kmAnalyticsVisitsPerVisitor';
const KM_ANALYTICS_MOST_ENGAGING_PAGES = 'kmAnalyticsMostEngagingPages';
const KM_ANALYTICS_TOP_CATEGORIES = 'kmAnalyticsTopCategories';
const keyMetricsGA4Widgets = [KM_ANALYTICS_ADSENSE_TOP_EARNING_CONTENT, KM_ANALYTICS_ENGAGED_TRAFFIC_SOURCE, KM_ANALYTICS_LEAST_ENGAGING_PAGES, KM_ANALYTICS_NEW_VISITORS, KM_ANALYTICS_POPULAR_AUTHORS, KM_ANALYTICS_POPULAR_CONTENT, KM_ANALYTICS_POPULAR_PRODUCTS, KM_ANALYTICS_RETURNING_VISITORS, KM_ANALYTICS_TOP_CATEGORIES, KM_ANALYTICS_TOP_CITIES, KM_ANALYTICS_TOP_CITIES_DRIVING_LEADS, KM_ANALYTICS_TOP_CITIES_DRIVING_ADD_TO_CART, KM_ANALYTICS_TOP_CITIES_DRIVING_PURCHASES, KM_ANALYTICS_TOP_DEVICE_DRIVING_PURCHASES, KM_ANALYTICS_TOP_CONVERTING_TRAFFIC_SOURCE, KM_ANALYTICS_TOP_COUNTRIES, KM_ANALYTICS_TOP_RECENT_TRENDING_PAGES, KM_ANALYTICS_TOP_TRAFFIC_SOURCE, KM_ANALYTICS_TOP_TRAFFIC_SOURCE_DRIVING_ADD_TO_CART, KM_ANALYTICS_PAGES_PER_VISIT, KM_ANALYTICS_VISIT_LENGTH, KM_ANALYTICS_TOP_RETURNING_VISITOR_PAGES, KM_ANALYTICS_VISITS_PER_VISITOR, KM_ANALYTICS_MOST_ENGAGING_PAGES, KM_ANALYTICS_TOP_CATEGORIES];
const allKeyMetricsTileWidgets = [...keyMetricsGA4Widgets, KM_SEARCH_CONSOLE_POPULAR_KEYWORDS];

/***/ }),

/***/ "./js/googlesitekit/modules/datastore/constants.js":
/*!*********************************************************!*\
  !*** ./js/googlesitekit/modules/datastore/constants.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   CORE_MODULES: () => (/* binding */ CORE_MODULES),
/* harmony export */   ERROR_CODE_INSUFFICIENT_MODULE_DEPENDENCIES: () => (/* binding */ ERROR_CODE_INSUFFICIENT_MODULE_DEPENDENCIES)
/* harmony export */ });
/**
 * `core/modules` data store: constants.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

const CORE_MODULES = 'core/modules';
const ERROR_CODE_INSUFFICIENT_MODULE_DEPENDENCIES = 'insufficient_module_dependencies';

/***/ }),

/***/ "./js/googlesitekit/notifications/components/layout/NoticeNotification.js":
/*!********************************************************************************!*\
  !*** ./js/googlesitekit/notifications/components/layout/NoticeNotification.js ***!
  \********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ NoticeNotification)
/* harmony export */ });
/* harmony import */ var _js_components_Notice__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @/js/components/Notice */ "./js/components/Notice/index.js");
/* harmony import */ var _js_googlesitekit_notifications_hooks_useNotificationEvents__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/googlesitekit/notifications/hooks/useNotificationEvents */ "./js/googlesitekit/notifications/hooks/useNotificationEvents.js");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _js_googlesitekit_notifications_datastore_constants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/googlesitekit/notifications/datastore/constants */ "./js/googlesitekit/notifications/datastore/constants.js");
/* harmony import */ var _js_material_components__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/material-components */ "./js/material-components/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Internal dependencies
 */







function NoticeNotification({
  notificationID,
  children,
  dismissButton,
  ctaButton,
  gaTrackingEventArgs,
  ...props
}) {
  const trackEvents = (0,_js_googlesitekit_notifications_hooks_useNotificationEvents__WEBPACK_IMPORTED_MODULE_1__["default"])(notificationID);
  const {
    dismissNotification
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.useDispatch)(_js_googlesitekit_notifications_datastore_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_NOTIFICATIONS);
  async function handleDismissWithTrackEvent(event) {
    await dismissButton?.onClick?.(event);
    trackEvents.dismiss(gaTrackingEventArgs?.label, gaTrackingEventArgs?.value);
    dismissNotification(notificationID, {
      ...(dismissButton?.dismissOptions || {})
    });
  }
  async function handleCTAClickWithTrackEvent(event) {
    trackEvents.confirm(gaTrackingEventArgs?.label, gaTrackingEventArgs?.value);
    await ctaButton?.onClick?.(event);
    if (ctaButton?.dismissOnClick) {
      dismissNotification(notificationID, {
        ...ctaButton?.dismissOptions
      });
    }
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_js_material_components__WEBPACK_IMPORTED_MODULE_4__.Grid, {
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_js_material_components__WEBPACK_IMPORTED_MODULE_4__.Row, {
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_js_material_components__WEBPACK_IMPORTED_MODULE_4__.Cell, {
        size: 12,
        alignMiddle: true,
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_js_components_Notice__WEBPACK_IMPORTED_MODULE_0__["default"], {
          dismissButton: {
            ...dismissButton,
            onClick: handleDismissWithTrackEvent
          },
          ctaButton: {
            ...ctaButton,
            onClick: handleCTAClickWithTrackEvent
          },
          ...props,
          children: children
        })
      })
    })
  });
}
NoticeNotification.propTypes = {
  notificationID: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().string).isRequired,
  children: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().node),
  dismissButton: prop_types__WEBPACK_IMPORTED_MODULE_6___default().oneOfType([(prop_types__WEBPACK_IMPORTED_MODULE_6___default().bool), (prop_types__WEBPACK_IMPORTED_MODULE_6___default().object)]),
  ctaButton: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().object),
  gaTrackingEventArgs: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().object)
};

/***/ }),

/***/ "./js/googlesitekit/notifications/components/layout/OverlayNotification.js":
/*!*********************************************************************************!*\
  !*** ./js/googlesitekit/notifications/components/layout/OverlayNotification.js ***!
  \*********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ OverlayNotification)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _js_googlesitekit_notifications_datastore_constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/googlesitekit/notifications/datastore/constants */ "./js/googlesitekit/notifications/datastore/constants.js");
/* harmony import */ var _js_googlesitekit_notifications_hooks_useNotificationEvents__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/googlesitekit/notifications/hooks/useNotificationEvents */ "./js/googlesitekit/notifications/hooks/useNotificationEvents.js");
/* harmony import */ var _js_components_OverlayCard__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/components/OverlayCard */ "./js/components/OverlayCard/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * OverlayNotification layout component.
 *
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * Internal dependencies
 */





function OverlayNotification({
  notificationID,
  ctaButton,
  dismissButton,
  gaTrackingEventArgs,
  ...props
}) {
  const trackEvents = (0,_js_googlesitekit_notifications_hooks_useNotificationEvents__WEBPACK_IMPORTED_MODULE_2__["default"])(notificationID, gaTrackingEventArgs?.category, {
    confirmAction: gaTrackingEventArgs?.confirmAction,
    dismissAction: gaTrackingEventArgs?.dismissAction
  });
  const {
    dismissNotification
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useDispatch)(_js_googlesitekit_notifications_datastore_constants__WEBPACK_IMPORTED_MODULE_1__.CORE_NOTIFICATIONS);
  async function handleDismissWithTrackEvent(event) {
    await dismissButton?.onClick?.(event);
    trackEvents.dismiss(gaTrackingEventArgs?.label, gaTrackingEventArgs?.value);
    dismissNotification(notificationID, {
      ...dismissButton.dismissOptions
    });
  }
  const {
    dismissOnClick,
    dismissOptions,
    ...otherCTAProps
  } = ctaButton || {};
  async function handleCTAClickWithTrackEvent(event) {
    trackEvents.confirm(gaTrackingEventArgs?.label, gaTrackingEventArgs?.value);
    await ctaButton?.onClick?.(event);
    if (dismissOnClick) {
      dismissNotification(notificationID, {
        ...dismissOptions
      });
    }
  }
  const overlayCTAButton = ctaButton ? {
    ...otherCTAProps,
    onClick: handleCTAClickWithTrackEvent
  } : undefined;
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(_js_components_OverlayCard__WEBPACK_IMPORTED_MODULE_3__["default"], {
    ctaButton: overlayCTAButton,
    dismissButton: {
      ...dismissButton,
      onClick: handleDismissWithTrackEvent
    },
    ...props,
    visible: true
  });
}
OverlayNotification.propTypes = {
  notificationID: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().string),
  ctaButton: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().object),
  dismissButton: prop_types__WEBPACK_IMPORTED_MODULE_5___default().oneOfType([(prop_types__WEBPACK_IMPORTED_MODULE_5___default().object), (prop_types__WEBPACK_IMPORTED_MODULE_5___default().bool)])
};

/***/ }),

/***/ "./js/googlesitekit/notifications/components/layout/SetupCTA.js":
/*!**********************************************************************!*\
  !*** ./js/googlesitekit/notifications/components/layout/SetupCTA.js ***!
  \**********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ SetupCTA)
/* harmony export */ });
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_12___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_12__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _js_googlesitekit_notifications_datastore_constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/googlesitekit/notifications/datastore/constants */ "./js/googlesitekit/notifications/datastore/constants.js");
/* harmony import */ var _js_googlesitekit_notifications_hooks_useNotificationEvents__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/googlesitekit/notifications/hooks/useNotificationEvents */ "./js/googlesitekit/notifications/hooks/useNotificationEvents.js");
/* harmony import */ var _js_components_Banner__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/components/Banner */ "./js/components/Banner/index.js");
/* harmony import */ var _js_components_Banner_LearnMoreLink__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/components/Banner/LearnMoreLink */ "./js/components/Banner/LearnMoreLink.js");
/* harmony import */ var _js_components_Banner_CTAButton__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @/js/components/Banner/CTAButton */ "./js/components/Banner/CTAButton.js");
/* harmony import */ var _js_components_Banner_DismissButton__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @/js/components/Banner/DismissButton */ "./js/components/Banner/DismissButton.js");
/* harmony import */ var _js_material_components__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @/js/material-components */ "./js/material-components/index.js");
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! googlesitekit-components */ "googlesitekit-components");
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_components__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * SetupCTA layout component.
 *
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */










function SetupCTA({
  notificationID,
  title,
  description,
  errorText,
  helpText,
  learnMoreLink,
  dismissButton,
  ctaButton,
  svg,
  footer,
  gaTrackingEventArgs,
  waitingProgress,
  ...props
}) {
  const trackEvents = (0,_js_googlesitekit_notifications_hooks_useNotificationEvents__WEBPACK_IMPORTED_MODULE_3__["default"])(notificationID, gaTrackingEventArgs?.category);
  const {
    dismissNotification
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useDispatch)(_js_googlesitekit_notifications_datastore_constants__WEBPACK_IMPORTED_MODULE_2__.CORE_NOTIFICATIONS);
  async function handleDismissWithTrackEvent(event) {
    await dismissButton?.onClick?.(event);
    trackEvents.dismiss(gaTrackingEventArgs?.label, gaTrackingEventArgs?.value);
    dismissNotification(notificationID, {
      ...dismissButton?.dismissOptions
    });
  }
  async function handleCTAClickWithTrackEvent(event) {
    trackEvents.confirm(gaTrackingEventArgs?.label, gaTrackingEventArgs?.value);
    await ctaButton?.onClick?.(event);
    if (ctaButton?.dismissOnClick) {
      dismissNotification(notificationID, {
        ...ctaButton?.dismissOptions
      });
    }
  }
  async function handleLearnMoreClickWithTrackEvent(event) {
    trackEvents.clickLearnMore(gaTrackingEventArgs?.label, gaTrackingEventArgs?.value);
    await learnMoreLink?.onClick?.(event);
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsxs)(_wordpress_element__WEBPACK_IMPORTED_MODULE_11__.Fragment, {
    children: [!!waitingProgress && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_9__.ProgressBar, {
      className: "googlesitekit-banner__progress-bar",
      ...waitingProgress
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)("div", {
      className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-widget-context', {
        'googlesitekit-widget-context--with-progress-bar': !!waitingProgress
      }),
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)(_js_material_components__WEBPACK_IMPORTED_MODULE_8__.Grid, {
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)(_js_material_components__WEBPACK_IMPORTED_MODULE_8__.Row, {
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)(_js_material_components__WEBPACK_IMPORTED_MODULE_8__.Cell, {
            size: 12,
            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)(_js_components_Banner__WEBPACK_IMPORTED_MODULE_4__["default"], {
              className: "googlesitekit-banner--setup-cta",
              title: title,
              description: description,
              errorText: errorText,
              helpText: helpText,
              learnMoreLink: learnMoreLink && {
                ...learnMoreLink,
                onClick: handleLearnMoreClickWithTrackEvent
              },
              dismissButton: dismissButton && {
                ...dismissButton,
                onClick: handleDismissWithTrackEvent
              },
              ctaButton: ctaButton && {
                ...ctaButton,
                onClick: handleCTAClickWithTrackEvent
              },
              svg: svg,
              footer: footer,
              ...props
            })
          })
        })
      })
    })]
  });
}
SetupCTA.propTypes = {
  notificationID: (prop_types__WEBPACK_IMPORTED_MODULE_12___default().string),
  title: (prop_types__WEBPACK_IMPORTED_MODULE_12___default().string),
  description: prop_types__WEBPACK_IMPORTED_MODULE_12___default().oneOfType([(prop_types__WEBPACK_IMPORTED_MODULE_12___default().string), (prop_types__WEBPACK_IMPORTED_MODULE_12___default().node)]),
  errorText: (prop_types__WEBPACK_IMPORTED_MODULE_12___default().string),
  helpText: (prop_types__WEBPACK_IMPORTED_MODULE_12___default().string),
  learnMoreLink: prop_types__WEBPACK_IMPORTED_MODULE_12___default().shape(_js_components_Banner_LearnMoreLink__WEBPACK_IMPORTED_MODULE_5__["default"].propTypes),
  dismissButton: prop_types__WEBPACK_IMPORTED_MODULE_12___default().shape(_js_components_Banner_DismissButton__WEBPACK_IMPORTED_MODULE_7__["default"].propTypes),
  ctaButton: prop_types__WEBPACK_IMPORTED_MODULE_12___default().shape(_js_components_Banner_CTAButton__WEBPACK_IMPORTED_MODULE_6__["default"].propTypes),
  svg: prop_types__WEBPACK_IMPORTED_MODULE_12___default().shape({
    desktop: (prop_types__WEBPACK_IMPORTED_MODULE_12___default().elementType),
    mobile: (prop_types__WEBPACK_IMPORTED_MODULE_12___default().elementType),
    verticalPosition: prop_types__WEBPACK_IMPORTED_MODULE_12___default().oneOf(['top', 'center', 'bottom'])
  }),
  footer: (prop_types__WEBPACK_IMPORTED_MODULE_12___default().node),
  gaTrackingEventArgs: prop_types__WEBPACK_IMPORTED_MODULE_12___default().shape({
    category: (prop_types__WEBPACK_IMPORTED_MODULE_12___default().string),
    label: (prop_types__WEBPACK_IMPORTED_MODULE_12___default().string),
    value: (prop_types__WEBPACK_IMPORTED_MODULE_12___default().number)
  }),
  waitingProgress: prop_types__WEBPACK_IMPORTED_MODULE_12___default().shape(googlesitekit_components__WEBPACK_IMPORTED_MODULE_9__.ProgressBar.propTypes)
};

/***/ }),

/***/ "./js/googlesitekit/notifications/constants.js":
/*!*****************************************************!*\
  !*** ./js/googlesitekit/notifications/constants.js ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   GTG_HEALTH_CHECK_WARNING_NOTIFICATION_ID: () => (/* binding */ GTG_HEALTH_CHECK_WARNING_NOTIFICATION_ID),
/* harmony export */   GTG_SETUP_CTA_BANNER_NOTIFICATION: () => (/* binding */ GTG_SETUP_CTA_BANNER_NOTIFICATION),
/* harmony export */   NOTIFICATION_AREAS: () => (/* binding */ NOTIFICATION_AREAS),
/* harmony export */   NOTIFICATION_GROUPS: () => (/* binding */ NOTIFICATION_GROUPS),
/* harmony export */   PRIORITY: () => (/* binding */ PRIORITY)
/* harmony export */ });
/**
 * Notifications API constants.
 *
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

const GTG_HEALTH_CHECK_WARNING_NOTIFICATION_ID = 'warning-notification-gtg';
const GTG_SETUP_CTA_BANNER_NOTIFICATION = 'gtg-setup-cta';
const PRIORITY = {
  ERROR_HIGH: 30,
  ERROR_LOW: 60,
  WARNING: 100,
  INFO: 150,
  SETUP_CTA_HIGH: 150,
  SETUP_CTA_LOW: 200
};
const NOTIFICATION_AREAS = {
  HEADER: 'notification-area-header',
  DASHBOARD_TOP: 'notification-area-dashboard-top',
  OVERLAYS: 'notification-area-overlays'
};
const NOTIFICATION_GROUPS = {
  DEFAULT: 'default',
  SETUP_CTAS: 'setup-ctas'
};

/***/ }),

/***/ "./js/googlesitekit/notifications/datastore/constants.js":
/*!***************************************************************!*\
  !*** ./js/googlesitekit/notifications/datastore/constants.js ***!
  \***************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   CORE_NOTIFICATIONS: () => (/* binding */ CORE_NOTIFICATIONS),
/* harmony export */   NOTIFICATION_VIEW_CONTEXTS: () => (/* binding */ NOTIFICATION_VIEW_CONTEXTS)
/* harmony export */ });
/* harmony import */ var _js_googlesitekit_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @/js/googlesitekit/constants */ "./js/googlesitekit/constants.js");
/**
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


const CORE_NOTIFICATIONS = 'core/notifications';
const NOTIFICATION_VIEW_CONTEXTS = [_js_googlesitekit_constants__WEBPACK_IMPORTED_MODULE_0__.VIEW_CONTEXT_SPLASH, _js_googlesitekit_constants__WEBPACK_IMPORTED_MODULE_0__.VIEW_CONTEXT_MAIN_DASHBOARD, _js_googlesitekit_constants__WEBPACK_IMPORTED_MODULE_0__.VIEW_CONTEXT_ENTITY_DASHBOARD, _js_googlesitekit_constants__WEBPACK_IMPORTED_MODULE_0__.VIEW_CONTEXT_MAIN_DASHBOARD_VIEW_ONLY, _js_googlesitekit_constants__WEBPACK_IMPORTED_MODULE_0__.VIEW_CONTEXT_ENTITY_DASHBOARD_VIEW_ONLY];

/***/ }),

/***/ "./js/googlesitekit/notifications/hooks/useNotificationEvents.js":
/*!***********************************************************************!*\
  !*** ./js/googlesitekit/notifications/hooks/useNotificationEvents.js ***!
  \***********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ useNotificationEvents)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @/js/hooks/useViewContext */ "./js/hooks/useViewContext.js");
/* harmony import */ var _js_util__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/util */ "./js/util/index.js");
/**
 * `useNotificationEvents` hook.
 *
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */


function useNotificationEvents(id, category, {
  viewAction = 'view_notification',
  confirmAction = 'confirm_notification',
  dismissAction = 'dismiss_notification',
  clickLearnMoreAction = 'click_learn_more_link'
} = {}) {
  const viewContext = (0,_js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_0__["default"])();
  const eventCategory = category !== null && category !== void 0 ? category : `${viewContext}_${id}`;
  const view = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useCallback)((...args) => {
    return (0,_js_util__WEBPACK_IMPORTED_MODULE_1__.trackEvent)(eventCategory, viewAction, ...args);
  }, [eventCategory, viewAction]);
  const confirm = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useCallback)((...args) => {
    return (0,_js_util__WEBPACK_IMPORTED_MODULE_1__.trackEvent)(eventCategory, confirmAction, ...args);
  }, [eventCategory, confirmAction]);
  const dismiss = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useCallback)((...args) => {
    return (0,_js_util__WEBPACK_IMPORTED_MODULE_1__.trackEvent)(eventCategory, dismissAction, ...args);
  }, [eventCategory, dismissAction]);
  const clickLearnMore = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useCallback)((...args) => {
    return (0,_js_util__WEBPACK_IMPORTED_MODULE_1__.trackEvent)(eventCategory, clickLearnMoreAction, ...args);
  }, [eventCategory, clickLearnMoreAction]);
  return {
    view,
    confirm,
    dismiss,
    clickLearnMore
  };
}

/***/ }),

/***/ "./js/googlesitekit/widgets/components/WPDashboardReportError.js":
/*!***********************************************************************!*\
  !*** ./js/googlesitekit/widgets/components/WPDashboardReportError.js ***!
  \***********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ WPDashboardReportError)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var react_use__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! react-use */ "../node_modules/react-use/esm/useLifecycles.js");
/* harmony import */ var _wordpress_compose__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @wordpress/compose */ "../node_modules/@wordpress/compose/build-module/hooks/use-instance-id/index.js");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _js_googlesitekit_datastore_ui_constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/googlesitekit/datastore/ui/constants */ "./js/googlesitekit/datastore/ui/constants.js");
/* harmony import */ var _js_components_ReportError__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/components/ReportError */ "./js/components/ReportError.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * WPDashboardReportError component.
 *
 * Site Kit by Google, Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */




function WPDashboardReportError({
  moduleSlug,
  error
}) {
  const errorInstanceID = (0,_wordpress_compose__WEBPACK_IMPORTED_MODULE_4__["default"])(WPDashboardReportError, 'WPDashboardReportError');
  const {
    setValue
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useDispatch)(_js_googlesitekit_datastore_ui_constants__WEBPACK_IMPORTED_MODULE_1__.CORE_UI);
  const errorMessage = error.message;
  const selectInstanceID = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useSelect)(select => select(_js_googlesitekit_datastore_ui_constants__WEBPACK_IMPORTED_MODULE_1__.CORE_UI).getValue(`WPDashboardReportError-${moduleSlug}-${errorMessage}`));
  (0,react_use__WEBPACK_IMPORTED_MODULE_5__["default"])(() => {
    setValue(`WPDashboardReportError-${moduleSlug}-${errorMessage}`, errorInstanceID);
  }, () => {
    setValue(`WPDashboardReportError-${moduleSlug}-${errorMessage}`, undefined);
  });
  if (selectInstanceID !== errorInstanceID) {
    return null;
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_js_components_ReportError__WEBPACK_IMPORTED_MODULE_2__["default"], {
    moduleSlug: moduleSlug,
    error: error
  });
}
WPDashboardReportError.propTypes = {
  moduleSlug: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().string).isRequired,
  error: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().object).isRequired
};

/***/ }),

/***/ "./js/googlesitekit/widgets/components/Widget.js":
/*!*******************************************************!*\
  !*** ./js/googlesitekit/widgets/components/Widget.js ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Widget component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * WordPress dependencies
 */


const Widget = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.forwardRef)(({
  children,
  className,
  widgetSlug,
  noPadding,
  Header,
  Footer
}, ref) => {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsxs)("div", {
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-widget', `googlesitekit-widget--${widgetSlug}`, {
      'googlesitekit-widget--no-padding': noPadding
    }, {
      'googlesitekit-widget--with-header': Header
    }, className),
    ref: ref,
    children: [Header && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", {
      className: "googlesitekit-widget__header",
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)(Header, {})
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", {
      className: "googlesitekit-widget__body",
      children: children
    }), Footer && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", {
      className: "googlesitekit-widget__footer",
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)(Footer, {})
    })]
  });
});
Widget.defaultProps = {
  children: undefined,
  noPadding: false
};
Widget.propTypes = {
  children: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().node),
  widgetSlug: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string).isRequired,
  noPadding: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().bool),
  Header: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().elementType),
  Footer: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().elementType)
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Widget);

/***/ }),

/***/ "./js/googlesitekit/widgets/components/WidgetNull.js":
/*!***********************************************************!*\
  !*** ./js/googlesitekit/widgets/components/WidgetNull.js ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ WidgetNull)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _js_googlesitekit_widgets_hooks_useWidgetStateEffect__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @/js/googlesitekit/widgets/hooks/useWidgetStateEffect */ "./js/googlesitekit/widgets/hooks/useWidgetStateEffect.js");
/* harmony import */ var _js_components_Null__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/components/Null */ "./js/components/Null.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * WidgetNull component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * Internal dependencies
 */



// This doesn't need to change.

const metadata = {};

// The supported props must match `Null` (except `widgetSlug`).
function WidgetNull({
  widgetSlug
}) {
  (0,_js_googlesitekit_widgets_hooks_useWidgetStateEffect__WEBPACK_IMPORTED_MODULE_0__["default"])(widgetSlug, _js_components_Null__WEBPACK_IMPORTED_MODULE_1__["default"], metadata);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)(_js_components_Null__WEBPACK_IMPORTED_MODULE_1__["default"], {});
}
WidgetNull.propTypes = {
  widgetSlug: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string).isRequired,
  ..._js_components_Null__WEBPACK_IMPORTED_MODULE_1__["default"].propTypes
};

/***/ }),

/***/ "./js/googlesitekit/widgets/components/WidgetRecoverableModules.js":
/*!*************************************************************************!*\
  !*** ./js/googlesitekit/widgets/components/WidgetRecoverableModules.js ***!
  \*************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ WidgetRecoverableModules)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _js_googlesitekit_widgets_hooks_useWidgetStateEffect__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @/js/googlesitekit/widgets/hooks/useWidgetStateEffect */ "./js/googlesitekit/widgets/hooks/useWidgetStateEffect.js");
/* harmony import */ var _js_components_RecoverableModules__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/components/RecoverableModules */ "./js/components/RecoverableModules.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * WidgetRecoverableModules component.
 *
 * Site Kit by Google, Copyright 2022 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */



// The supported props must match `RecoverableModules` (except `widgetSlug`).

function WidgetRecoverableModules({
  widgetSlug,
  moduleSlugs,
  ...props
}) {
  const metadata = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_3__.useMemo)(() => ({
    // Here we serialize to `moduleSlug` for compatibility with the logic in
    // `combineWidgets()`. In future we may wish to take a less "hacky" approach.
    // See https://github.com/google/site-kit-wp/issues/5376#issuecomment-1165771399.
    moduleSlug: [...moduleSlugs].sort().join(','),
    // We also store `moduleSlugs` in the metadata in order for it to be passed back
    // into RecoverableModules as a prop.
    // See https://github.com/google/site-kit-wp/blob/c272c20eddcca61aae24c9812b6b11dbc15ec673/assets/js/googlesitekit/widgets/components/WidgetAreaRenderer.js#L171.
    moduleSlugs
  }), [moduleSlugs]);
  (0,_js_googlesitekit_widgets_hooks_useWidgetStateEffect__WEBPACK_IMPORTED_MODULE_0__["default"])(widgetSlug, _js_components_RecoverableModules__WEBPACK_IMPORTED_MODULE_1__["default"], metadata);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)(_js_components_RecoverableModules__WEBPACK_IMPORTED_MODULE_1__["default"], {
    moduleSlugs: moduleSlugs,
    ...props
  });
}
WidgetRecoverableModules.propTypes = {
  widgetSlug: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().string).isRequired,
  ..._js_components_RecoverableModules__WEBPACK_IMPORTED_MODULE_1__["default"].propTypes
};

/***/ }),

/***/ "./js/googlesitekit/widgets/components/WidgetReportError.js":
/*!******************************************************************!*\
  !*** ./js/googlesitekit/widgets/components/WidgetReportError.js ***!
  \******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ WidgetReportError)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _js_components_ReportError__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @/js/components/ReportError */ "./js/components/ReportError.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * WidgetReportError component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * Internal dependencies
 */


// eslint-disable-next-line no-unused-vars

function WidgetReportError({
  widgetSlug,
  ...props
}) {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)(_js_components_ReportError__WEBPACK_IMPORTED_MODULE_0__["default"], {
    ...props
  });
}
WidgetReportError.propTypes = {
  widgetSlug: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().string).isRequired,
  ..._js_components_ReportError__WEBPACK_IMPORTED_MODULE_0__["default"].propTypes
};

/***/ }),

/***/ "./js/googlesitekit/widgets/components/WidgetReportZero.js":
/*!*****************************************************************!*\
  !*** ./js/googlesitekit/widgets/components/WidgetReportZero.js ***!
  \*****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ WidgetReportZero)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _js_googlesitekit_widgets_hooks_useWidgetStateEffect__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @/js/googlesitekit/widgets/hooks/useWidgetStateEffect */ "./js/googlesitekit/widgets/hooks/useWidgetStateEffect.js");
/* harmony import */ var _js_components_ReportZero__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/components/ReportZero */ "./js/components/ReportZero.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * WidgetReportZero component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */



// The supported props must match `ReportZero` (except `widgetSlug`).

function WidgetReportZero({
  widgetSlug,
  moduleSlug,
  ...props
}) {
  const metadata = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_3__.useMemo)(() => ({
    moduleSlug
  }), [moduleSlug]);
  (0,_js_googlesitekit_widgets_hooks_useWidgetStateEffect__WEBPACK_IMPORTED_MODULE_0__["default"])(widgetSlug, _js_components_ReportZero__WEBPACK_IMPORTED_MODULE_1__["default"], metadata);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)(_js_components_ReportZero__WEBPACK_IMPORTED_MODULE_1__["default"], {
    moduleSlug: moduleSlug,
    ...props
  });
}
WidgetReportZero.propTypes = {
  widgetSlug: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().string).isRequired,
  ..._js_components_ReportZero__WEBPACK_IMPORTED_MODULE_1__["default"].propTypes
};

/***/ }),

/***/ "./js/googlesitekit/widgets/datastore/areas.js":
/*!*****************************************************!*\
  !*** ./js/googlesitekit/widgets/datastore/areas.js ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   actions: () => (/* binding */ actions),
/* harmony export */   controls: () => (/* binding */ controls),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   initialState: () => (/* binding */ initialState),
/* harmony export */   reducer: () => (/* binding */ reducer),
/* harmony export */   resolvers: () => (/* binding */ resolvers),
/* harmony export */   selectors: () => (/* binding */ selectors)
/* harmony export */ });
/* harmony import */ var invariant__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! invariant */ "../node_modules/invariant/browser.js");
/* harmony import */ var invariant__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(invariant__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./constants */ "./js/googlesitekit/widgets/datastore/constants.js");
/* harmony import */ var _js_util_sort_by_property__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/util/sort-by-property */ "./js/util/sort-by-property.js");
/**
 * `core/widgets` data store: widgets info.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * Internal dependencies
 */



const ASSIGN_WIDGET_AREA = 'ASSIGN_WIDGET_AREA';
const REGISTER_WIDGET_AREA = 'REGISTER_WIDGET_AREA';
const WidgetAreaStyleKeys = Object.keys(_constants__WEBPACK_IMPORTED_MODULE_2__.WIDGET_AREA_STYLES).map(key => `WIDGET_AREA_STYLES.${key}`).join(', ');
const initialState = {
  areas: {},
  contextAssignments: {}
};
const actions = {
  /**
   * Assigns a widget area to one (or several) contexts.
   *
   * Accepts an area slug to register as the first argument, then either a string
   * (for a single context slug) or array of contexts slugs (to assign the widget area
   * to multiple contexts).
   *
   * Does not error if any of the requested contexts do not exist, but will console.warn
   * a message about non-existant contexts.
   *
   * Does not error if the area slug provided does not exist, but will console.warn a
   * message about non-existent areas.
   *
   * @since 1.9.0
   *
   * @param {string}         slug         Widget Area's slug.
   * @param {(string|Array)} contextSlugs Widget Context's slug(s).
   * @return {Object} Redux-style action.
   */
  assignWidgetArea(slug, contextSlugs) {
    return {
      payload: {
        slug,
        contextSlugs: typeof contextSlugs === 'string' ? [contextSlugs] : contextSlugs
      },
      type: ASSIGN_WIDGET_AREA
    };
  },
  /**
   * Creates a widget area with a given name and settings.
   *
   * @since 1.9.0
   * @since 1.107.0 Extended to support an optional CTA component.
   * @since 1.110.0 Extended to support an optional filterActiveWidgets function.
   * @since 1.128.0 Extended to make title optional, support an optional Footer component, and added support for an optional `hasNewBadge` parameter.
   *
   * @param {string}      slug                           Widget Area's slug.
   * @param {Object}      settings                       Widget Area's settings.
   * @param {string}      [settings.title]               Optional. Title for this widget area.
   * @param {string}      [settings.subtitle]            Optional. Subtitle for this widget area.
   * @param {WPComponent} [settings.Icon]                Optional. React component to render icon for this widget area.
   * @param {string}      [settings.style]               Optional. Widget area style (one of "boxes", "composite"). Default: "boxes".
   * @param {number}      [settings.priority]            Optional. Priority for this widget area. Default: 10.
   * @param {boolean}     [settings.hasNewBadge]         Optional. Whether this widget area should display a new badge.
   * @param {WPComponent} [settings.CTA]                 Optional. React component used as CTA appearing beside the subtitle.
   * @param {WPComponent} [settings.Footer]              Optional. React component used as footer for the widget area.
   * @param {Function}    [settings.filterActiveWidgets] Optional. Function used to filter active widgets.
   * @return {Object} Redux-style action.
   */
  registerWidgetArea(slug, {
    priority = 10,
    style = _constants__WEBPACK_IMPORTED_MODULE_2__.WIDGET_AREA_STYLES.BOXES,
    title,
    subtitle,
    Icon,
    hasNewBadge = false,
    CTA,
    Footer,
    filterActiveWidgets
  } = {}) {
    invariant__WEBPACK_IMPORTED_MODULE_0___default()(slug, 'slug is required.');
    invariant__WEBPACK_IMPORTED_MODULE_0___default()(Object.values(_constants__WEBPACK_IMPORTED_MODULE_2__.WIDGET_AREA_STYLES).includes(style), `settings.style must be one of: ${WidgetAreaStyleKeys}.`);
    return {
      payload: {
        slug,
        settings: {
          priority,
          style,
          title,
          subtitle,
          Icon,
          hasNewBadge,
          CTA,
          Footer,
          filterActiveWidgets
        }
      },
      type: REGISTER_WIDGET_AREA
    };
  }
};
const controls = {};
const reducer = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.createReducer)((state, {
  type,
  payload
}) => {
  switch (type) {
    case ASSIGN_WIDGET_AREA:
      {
        const {
          slug,
          contextSlugs
        } = payload;
        contextSlugs.forEach(contextSlug => {
          if (state.contextAssignments[contextSlug] === undefined) {
            state.contextAssignments[contextSlug] = [];
          }
          if (!state.contextAssignments[contextSlug].includes(slug)) {
            state.contextAssignments[contextSlug].push(slug);
          }
        });
        return state;
      }
    case REGISTER_WIDGET_AREA:
      {
        const {
          slug,
          settings
        } = payload;
        if (state.areas[slug] !== undefined) {
          __webpack_require__.g.console.warn(`Could not register widget area with slug "${slug}". Widget area "${slug}" is already registered.`);
          return state;
        }
        state.areas[slug] = {
          ...settings,
          slug
        };
        return state;
      }
    default:
      {
        return state;
      }
  }
});
const resolvers = {};
const selectors = {
  /**
   * Checks if a widget area is active.
   *
   * Returns `true` if the widget area is active.
   * Returns `false` if the widget area is NOT active.
   *
   * @since 1.47.0
   * @since 1.77.0 Add options.modules parameter.
   * @since 1.110.0 Introduced filterActiveWidgets support to allow custom filtering of active widgets.
   *
   * @param {Object}         state             Data store's state.
   * @param {string}         slug              Widget area's slug.
   * @param {Object}         [options]         Optional. Options parameter.
   * @param {Array.<string>} [options.modules] Optional. List of module slugs, when provided the widgets checked will be restricted to those associated with the specified modules.
   * @return {boolean} `true`/`false` based on whether widget area is active.
   */
  isWidgetAreaActive: (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.createRegistrySelector)(select => (state, widgetAreaSlug, options = {}) => {
    invariant__WEBPACK_IMPORTED_MODULE_0___default()(widgetAreaSlug, 'widgetAreaSlug is required to check a widget area is active.');
    const {
      modules
    } = options;
    const widgetArea = select(_constants__WEBPACK_IMPORTED_MODULE_2__.CORE_WIDGETS).getWidgetArea(widgetAreaSlug);
    let areaWidgets = select(_constants__WEBPACK_IMPORTED_MODULE_2__.CORE_WIDGETS).getWidgets(widgetAreaSlug, {
      modules
    });
    if (widgetArea.filterActiveWidgets) {
      areaWidgets = widgetArea.filterActiveWidgets(select, areaWidgets);
    }
    return areaWidgets.some(widget => select(_constants__WEBPACK_IMPORTED_MODULE_2__.CORE_WIDGETS).isWidgetActive(widget.slug));
  }),
  /**
   * Checks if a widget area has been registered.
   *
   * Returns `true` if the widget area has been registered.
   * Returns `false` if the widget area has NOT been registered.
   *
   * @since 1.9.0
   *
   * @param {Object} state Data store's state.
   * @param {string} slug  Widget Area's slug.
   * @return {boolean} `true`/`false` based on whether widget area has been registered.
   */
  isWidgetAreaRegistered(state, slug) {
    const {
      areas
    } = state;
    return areas[slug] !== undefined;
  },
  /**
   * Returns all widget areas registered for a given context.
   *
   * Returns an array of all widget areas for a given context.
   * The widget areas are returned in order of their priority, so can be rendered in
   * the order provided by the selector.
   *
   * @since 1.9.0
   *
   * @param {Object} state       Data store's state.
   * @param {string} contextSlug Widget context to get areas for.
   * @return {Array} An ordered array of widget areas for this context.
   */
  getWidgetAreas(state, contextSlug) {
    invariant__WEBPACK_IMPORTED_MODULE_0___default()(contextSlug, 'contextSlug is required.');
    const {
      areas,
      contextAssignments
    } = state;
    return (0,_js_util_sort_by_property__WEBPACK_IMPORTED_MODULE_3__.sortByProperty)(Object.values(areas).filter(area => {
      return contextAssignments[contextSlug] && contextAssignments[contextSlug].includes(area.slug);
    }), 'priority');
  },
  /**
   * Returns a widget area based on slug.
   *
   * @since 1.11.0
   *
   * @param {Object} state Data store's state.
   * @param {string} slug  Widget area to select.
   * @return {Object|null} A widget area if one is found with a matching slug.
   */
  getWidgetArea(state, slug) {
    invariant__WEBPACK_IMPORTED_MODULE_0___default()(slug, 'slug is required.');
    const {
      areas
    } = state;
    return areas[slug] || null;
  }
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  initialState,
  actions,
  controls,
  reducer,
  resolvers,
  selectors
});

/***/ }),

/***/ "./js/googlesitekit/widgets/datastore/constants.js":
/*!*********************************************************!*\
  !*** ./js/googlesitekit/widgets/datastore/constants.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   CORE_WIDGETS: () => (/* binding */ CORE_WIDGETS),
/* harmony export */   WIDGET_AREA_STYLES: () => (/* binding */ WIDGET_AREA_STYLES),
/* harmony export */   WIDGET_WIDTHS: () => (/* binding */ WIDGET_WIDTHS)
/* harmony export */ });
/**
 * `core/widgets` data store: constants.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

const WIDGET_AREA_STYLES = {
  BOXES: 'boxes',
  COMPOSITE: 'composite'
};
const WIDGET_WIDTHS = {
  QUARTER: 'quarter',
  HALF: 'half',
  FULL: 'full'
};
const CORE_WIDGETS = 'core/widgets';

/***/ }),

/***/ "./js/googlesitekit/widgets/datastore/contexts.js":
/*!********************************************************!*\
  !*** ./js/googlesitekit/widgets/datastore/contexts.js ***!
  \********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   selectors: () => (/* binding */ selectors)
/* harmony export */ });
/* harmony import */ var invariant__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! invariant */ "../node_modules/invariant/browser.js");
/* harmony import */ var invariant__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(invariant__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./constants */ "./js/googlesitekit/widgets/datastore/constants.js");
/**
 * `core/widgets` data store: contexts.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * Internal dependencies
 */


const selectors = {
  /**
   * Checks if a widget context is active.
   *
   * Returns `true` if the widget context is active.
   * Returns `false` if the widget context is NOT active.
   *
   * @since 1.47.0
   * @since 1.77.0 Add options.modules parameter.
   *
   * @param {Object}         state             Data store's state.
   * @param {string}         slug              Widget context's slug.
   * @param {Object}         [options]         Optional. Options parameter.
   * @param {Array.<string>} [options.modules] Optional. List of module slugs, when provided the widgets checked will be restricted to those associated with the specified modules.
   * @return {boolean} `true`/`false` based on whether widget context is active.
   */
  isWidgetContextActive: (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.createRegistrySelector)(select => (state, contextSlug, options = {}) => {
    invariant__WEBPACK_IMPORTED_MODULE_0___default()(contextSlug, 'contextSlug is required to check a widget context is active.');
    const {
      modules
    } = options;
    return select(_constants__WEBPACK_IMPORTED_MODULE_2__.CORE_WIDGETS).getWidgetAreas(contextSlug).some(area => select(_constants__WEBPACK_IMPORTED_MODULE_2__.CORE_WIDGETS).isWidgetAreaActive(area.slug, {
      modules
    }));
  })
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  selectors
});

/***/ }),

/***/ "./js/googlesitekit/widgets/datastore/index.js":
/*!*****************************************************!*\
  !*** ./js/googlesitekit/widgets/datastore/index.js ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   registerStore: () => (/* binding */ registerStore)
/* harmony export */ });
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _areas__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./areas */ "./js/googlesitekit/widgets/datastore/areas.js");
/* harmony import */ var _widgets__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./widgets */ "./js/googlesitekit/widgets/datastore/widgets.js");
/* harmony import */ var _contexts__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./contexts */ "./js/googlesitekit/widgets/datastore/contexts.js");
/* harmony import */ var _js_googlesitekit_data_create_error_store__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/googlesitekit/data/create-error-store */ "./js/googlesitekit/data/create-error-store.js");
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./constants */ "./js/googlesitekit/widgets/datastore/constants.js");
/**
 * `core/widgets` data store
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Internal dependencies
 */






const store = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.combineStores)(googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.commonStore, _areas__WEBPACK_IMPORTED_MODULE_1__["default"], _widgets__WEBPACK_IMPORTED_MODULE_2__["default"], _contexts__WEBPACK_IMPORTED_MODULE_3__["default"], (0,_js_googlesitekit_data_create_error_store__WEBPACK_IMPORTED_MODULE_4__.createErrorStore)(_constants__WEBPACK_IMPORTED_MODULE_5__.CORE_WIDGETS));
function registerStore(registry) {
  registry.registerStore(_constants__WEBPACK_IMPORTED_MODULE_5__.CORE_WIDGETS, store);
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (store);

/***/ }),

/***/ "./js/googlesitekit/widgets/datastore/widgets.js":
/*!*******************************************************!*\
  !*** ./js/googlesitekit/widgets/datastore/widgets.js ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   actions: () => (/* binding */ actions),
/* harmony export */   controls: () => (/* binding */ controls),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   initialState: () => (/* binding */ initialState),
/* harmony export */   reducer: () => (/* binding */ reducer),
/* harmony export */   resolvers: () => (/* binding */ resolvers),
/* harmony export */   selectors: () => (/* binding */ selectors)
/* harmony export */ });
/* harmony import */ var invariant__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! invariant */ "../node_modules/invariant/browser.js");
/* harmony import */ var invariant__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(invariant__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! lodash */ "../node_modules/lodash/lodash.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var immer__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! immer */ "../node_modules/immer/dist/immer.esm.mjs");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _js_googlesitekit_widgets_util__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/googlesitekit/widgets/util */ "./js/googlesitekit/widgets/util/index.js");
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./constants */ "./js/googlesitekit/widgets/datastore/constants.js");
/**
 * `core/widgets` data store: widgets info.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */




/**
 * Internal dependencies
 */



const ASSIGN_WIDGET = 'ASSIGN_WIDGET';
const REGISTER_WIDGET = 'REGISTER_WIDGET';
const SET_WIDGET_STATE = 'SET_WIDGET_STATE';
const UNSET_WIDGET_STATE = 'UNSET_WIDGET_STATE';
const WidgetWidthKeys = Object.keys(_constants__WEBPACK_IMPORTED_MODULE_4__.WIDGET_WIDTHS).map(key => `WIDGET_WIDTHS.${key}`).join(', ');
const initialState = {
  areaAssignments: {},
  widgets: {},
  widgetStates: {}
};
const actions = {
  /**
   * Assigns an existing widget (by slug) to a widget area(s).
   *
   * @since 1.9.0
   *
   * @param {string}         slug      Widget slug.
   * @param {(string|Array)} areaSlugs Widget Area slug(s).
   * @return {Object} Redux-style action.
   */
  assignWidget(slug, areaSlugs) {
    return {
      payload: {
        slug,
        areaSlugs: typeof areaSlugs === 'string' ? [areaSlugs] : areaSlugs
      },
      type: ASSIGN_WIDGET
    };
  },
  /**
   * Registers a widget with a given slug and settings.
   *
   * @since 1.9.0
   * @since 1.12.0  Added wrapWidget setting.
   * @since 1.138.0 Added hideOnBreakpoints setting.
   *
   * @param {string}                slug                         Widget's slug.
   * @param {Object}                settings                     Widget's settings.
   * @param {WPComponent}           settings.Component           React component used to display the contents of this widget.
   * @param {number}                [settings.priority]          Optional. Widget's priority for ordering (lower number is higher priority, like WordPress hooks). Default is: 10.
   * @param {string|Array.<string>} [settings.width]             Optional. Widget's maximum width to occupy. Default is: "quarter". One of: "quarter", "half", "full".
   * @param {boolean}               [settings.wrapWidget]        Optional. Whether to wrap the component with the <Widget> wrapper. Default is: true.
   * @param {string|Array.<string>} [settings.modules]           Optional. Widget's associated modules.
   * @param {Function}              [settings.isActive]          Optional. Callback function to determine if the widget is active.
   * @param {Function}              [settings.isPreloaded]       Optional. Callback function to determine if the widget should be preloaded if not active (requires isActive).
   * @param {Array.<string>}        [settings.hideOnBreakpoints] Optional. Hide widget on selected breakpoints. Array with any of: `BREAKPOINT_SMALL`, `BREAKPOINT_TABLET`, `BREAKPOINT_DESKTOP`, `BREAKPOINT_XLARGE`.
   * @return {Object} Redux-style action.
   */
  registerWidget(slug, {
    Component,
    priority = 10,
    width = _constants__WEBPACK_IMPORTED_MODULE_4__.WIDGET_WIDTHS.QUARTER,
    wrapWidget = true,
    modules,
    isActive,
    isPreloaded,
    hideOnBreakpoints
  } = {}) {
    const allWidths = Object.values(_constants__WEBPACK_IMPORTED_MODULE_4__.WIDGET_WIDTHS);
    invariant__WEBPACK_IMPORTED_MODULE_0___default()(Component, 'component is required to register a widget.');
    invariant__WEBPACK_IMPORTED_MODULE_0___default()(Array.isArray(width) && width.some(allWidths.includes, allWidths) || !Array.isArray(width) && allWidths.includes(width), `Widget width should be one of: ${WidgetWidthKeys}, but "${width}" was provided.`);
    return {
      payload: {
        slug,
        settings: {
          Component,
          priority,
          width,
          wrapWidget,
          modules: (0,_js_googlesitekit_widgets_util__WEBPACK_IMPORTED_MODULE_3__.normalizeWidgetModules)(modules),
          isActive,
          isPreloaded,
          hideOnBreakpoints
        }
      },
      type: REGISTER_WIDGET
    };
  },
  /**
   * Sets widget state for a given widget.
   *
   * Used internally by various components that can be returned by
   * registered widget components.
   *
   * @since 1.25.0
   * @private
   *
   * @param {string}      slug       Widget slug.
   * @param {WPComponent} Component  Component returned by the widget.
   * @param {Object}      [metadata] Relevant metadata / props passed to
   *                                 the Component instance.
   * @return {Object} Redux-style action.
   */
  setWidgetState(slug, Component, metadata = {}) {
    return {
      payload: {
        slug,
        Component,
        metadata
      },
      type: SET_WIDGET_STATE
    };
  },
  /**
   * Unsets widget state for a given widget.
   *
   * The widget state will only be unset if the current widget state matches
   * exactly the passed parameters.
   *
   * Used internally by various components that can be returned by
   * registered widget components.
   *
   * @since 1.25.0
   * @private
   *
   * @param {string}      slug       Widget slug.
   * @param {WPComponent} Component  Component returned by the widget.
   * @param {Object}      [metadata] Relevant metadata / props passed to
   *                                 the Component instance.
   * @return {Object} Redux-style action.
   */
  unsetWidgetState(slug, Component, metadata = {}) {
    return {
      payload: {
        slug,
        Component,
        metadata
      },
      type: UNSET_WIDGET_STATE
    };
  }
};
const controls = {};
const reducer = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.createReducer)((state, {
  type,
  payload
}) => {
  switch (type) {
    case ASSIGN_WIDGET:
      {
        const {
          slug,
          areaSlugs
        } = payload;
        areaSlugs.forEach(areaSlug => {
          if (state.areaAssignments[areaSlug] === undefined) {
            state.areaAssignments[areaSlug] = [];
          }
          if (!state.areaAssignments[areaSlug].includes(slug)) {
            state.areaAssignments[areaSlug].push(slug);
          }
        });
        return state;
      }
    case REGISTER_WIDGET:
      {
        const {
          slug,
          settings
        } = payload;
        if (state.widgets[slug] !== undefined) {
          __webpack_require__.g.console.warn(`Could not register widget with slug "${slug}". Widget "${slug}" is already registered.`);
          return state;
        }
        state.widgets[slug] = {
          ...settings,
          slug
        };
        return state;
      }
    case SET_WIDGET_STATE:
      {
        const {
          slug,
          Component,
          metadata
        } = payload;
        state.widgetStates[slug] = {
          Component,
          metadata
        };
        return state;
      }
    case UNSET_WIDGET_STATE:
      {
        const {
          slug,
          Component,
          metadata
        } = payload;
        if (state.widgetStates?.[slug]?.Component === Component && (0,immer__WEBPACK_IMPORTED_MODULE_5__.original)(state.widgetStates?.[slug]?.metadata) === metadata) {
          delete state.widgetStates[slug];
        }
        return state;
      }
    default:
      {
        return state;
      }
  }
});
const resolvers = {};
const selectors = {
  /**
   * Checks if a widget with a given slug is active.
   *
   * Returns `true` if the widget area is active.
   * Returns `false` if the widget area is NOT active.
   *
   * @since 1.47.0
   *
   * @param {Object} state Data store's state.
   * @param {string} slug  Widget's slug.
   * @return {boolean} `true`/`false` based on whether widget is active.
   */
  isWidgetActive: (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.createRegistrySelector)(select => (state, slug) => {
    invariant__WEBPACK_IMPORTED_MODULE_0___default()(slug, 'slug is required to check a widget is active.');
    return !(0,_js_googlesitekit_widgets_util__WEBPACK_IMPORTED_MODULE_3__.isInactiveWidgetState)(select(_constants__WEBPACK_IMPORTED_MODULE_4__.CORE_WIDGETS).getWidgetState(slug));
  }),
  /**
   * Checks if a widget has been registered with a given slug.
   *
   * Returns `true` if the widget area has been registered.
   * Returns `false` if the widget area has NOT been registered.
   *
   * @since 1.9.0
   *
   * @param {Object} state Data store's state.
   * @param {string} slug  Widget's slug.
   * @return {boolean} `true`/`false` based on whether widget has been registered.
   */
  isWidgetRegistered(state, slug) {
    const {
      widgets
    } = state;
    return widgets[slug] !== undefined;
  },
  /**
   * Checks if a widget with the given slug is in the preloaded state.
   *
   * @since 1.101.0
   *
   * @param {Object} state Data store's state.
   * @param {string} slug  Widget's slug.
   * @return {boolean} `true`/`false` based on whether widget is currently in a preloaded state.
   */
  isWidgetPreloaded: (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.createRegistrySelector)(select => (state, slug) => {
    const {
      widgets
    } = state;
    return !!widgets[slug]?.isPreloaded?.(select);
  }),
  /**
   * Returns all widgets registered for a given widget area.
   *
   * Returns an array of all widgets for a given area.
   * The widgets are returned in order of their priority, so can be rendered in
   * the order provided by the selector.
   *
   * @since 1.9.0
   * @since 1.101.0 Allows widgets to override their active state via an isPreloaded() callback.
   *
   * @param {Object}                state             Data store's state.
   * @param {string}                widgetAreaSlug    Widget context to get areas for.
   * @param {Object}                options           Widgets selection options.
   * @param {string|Array.<string>} [options.modules] Optional. Widget's associated modules.
   * @return {Array} An ordered array of widgets for this area.
   */
  getWidgets: (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.createRegistrySelector)(select => (state, widgetAreaSlug, {
    modules
  } = {}) => {
    invariant__WEBPACK_IMPORTED_MODULE_0___default()(widgetAreaSlug, 'widgetAreaSlug is required.');
    const {
      areaAssignments
    } = state;
    let widgets = Object.values(state.widgets).filter(widget => areaAssignments[widgetAreaSlug]?.includes(widget.slug)).filter(widget => {
      if (typeof widget.isActive !== 'function') {
        return true;
      }
      if (widget.isActive(select)) {
        return true;
      }
      if (typeof widget.isPreloaded !== 'function') {
        return false;
      }
      return widget.isPreloaded(select);
    });
    if (modules) {
      const allowedModules = (0,_js_googlesitekit_widgets_util__WEBPACK_IMPORTED_MODULE_3__.normalizeWidgetModules)(modules);
      widgets = widgets.filter(widget => {
        if (!widget.modules?.length) {
          return true;
        }
        return (0,lodash__WEBPACK_IMPORTED_MODULE_1__.intersection)(widget.modules, allowedModules).length === widget.modules.length;
      });
    }
    return widgets.sort((a, b) => a.priority - b.priority);
  }),
  /**
   * Returns a single widget, by slug.
   *
   * @since 1.11.0
   *
   * @param {Object} state Data store's state.
   * @param {string} slug  Widget slug.
   * @return {Object|null} A widget object, if one exists.
   */
  getWidget(state, slug) {
    invariant__WEBPACK_IMPORTED_MODULE_0___default()(slug, 'slug is required to get a widget.');
    return state.widgets[slug] || null;
  },
  /**
   * Returns the state data of a widget by its slug.
   *
   * Used internally by the WidgetAreaRenderer component to recognize
   * widgets in special states.
   *
   * @since 1.25.0
   * @private
   *
   * @param {Object} state Data store's state.
   * @param {string} slug  Widget slug.
   * @return {Object|null} Object with `Component` and `metadata` properties,
   *                       if the widget has a special state, or `null`.
   */
  getWidgetState(state, slug) {
    return state.widgetStates[slug] || null;
  },
  /**
   * Returns all widget states.
   *
   * @since 1.28.0
   * @private
   *
   * @param {Object} state Data store's state.
   * @return {Object} Widget states, keyed by slug, with a value containing the component and metadata.
   */
  getWidgetStates(state) {
    return state.widgetStates;
  }
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  initialState,
  actions,
  controls,
  reducer,
  resolvers,
  selectors
});

/***/ }),

/***/ "./js/googlesitekit/widgets/default-areas.js":
/*!***************************************************!*\
  !*** ./js/googlesitekit/widgets/default-areas.js ***!
  \***************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   AREA_ENTITY_DASHBOARD_CONTENT_PRIMARY: () => (/* binding */ AREA_ENTITY_DASHBOARD_CONTENT_PRIMARY),
/* harmony export */   AREA_ENTITY_DASHBOARD_MONETIZATION_PRIMARY: () => (/* binding */ AREA_ENTITY_DASHBOARD_MONETIZATION_PRIMARY),
/* harmony export */   AREA_ENTITY_DASHBOARD_SPEED_PRIMARY: () => (/* binding */ AREA_ENTITY_DASHBOARD_SPEED_PRIMARY),
/* harmony export */   AREA_ENTITY_DASHBOARD_TRAFFIC_PRIMARY: () => (/* binding */ AREA_ENTITY_DASHBOARD_TRAFFIC_PRIMARY),
/* harmony export */   AREA_MAIN_DASHBOARD_CONTENT_PRIMARY: () => (/* binding */ AREA_MAIN_DASHBOARD_CONTENT_PRIMARY),
/* harmony export */   AREA_MAIN_DASHBOARD_KEY_METRICS_PRIMARY: () => (/* binding */ AREA_MAIN_DASHBOARD_KEY_METRICS_PRIMARY),
/* harmony export */   AREA_MAIN_DASHBOARD_MONETIZATION_PRIMARY: () => (/* binding */ AREA_MAIN_DASHBOARD_MONETIZATION_PRIMARY),
/* harmony export */   AREA_MAIN_DASHBOARD_SPEED_PRIMARY: () => (/* binding */ AREA_MAIN_DASHBOARD_SPEED_PRIMARY),
/* harmony export */   AREA_MAIN_DASHBOARD_TRAFFIC_AUDIENCE_SEGMENTATION: () => (/* binding */ AREA_MAIN_DASHBOARD_TRAFFIC_AUDIENCE_SEGMENTATION),
/* harmony export */   AREA_MAIN_DASHBOARD_TRAFFIC_PRIMARY: () => (/* binding */ AREA_MAIN_DASHBOARD_TRAFFIC_PRIMARY),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/**
 * Widgets API default areas
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// Main dashboard
const AREA_MAIN_DASHBOARD_KEY_METRICS_PRIMARY = 'mainDashboardKeyMetricsPrimary';
const AREA_MAIN_DASHBOARD_TRAFFIC_PRIMARY = 'mainDashboardTrafficPrimary';
const AREA_MAIN_DASHBOARD_TRAFFIC_AUDIENCE_SEGMENTATION = 'mainDashboardTrafficAudienceSegmentation';
const AREA_MAIN_DASHBOARD_CONTENT_PRIMARY = 'mainDashboardContentPrimary';
const AREA_MAIN_DASHBOARD_SPEED_PRIMARY = 'mainDashboardSpeedPrimary';
const AREA_MAIN_DASHBOARD_MONETIZATION_PRIMARY = 'mainDashboardMonetizationPrimary';
// Entity dashboard
const AREA_ENTITY_DASHBOARD_TRAFFIC_PRIMARY = 'entityDashboardTrafficPrimary';
const AREA_ENTITY_DASHBOARD_CONTENT_PRIMARY = 'entityDashboardContentPrimary';
const AREA_ENTITY_DASHBOARD_SPEED_PRIMARY = 'entityDashboardSpeedPrimary';
const AREA_ENTITY_DASHBOARD_MONETIZATION_PRIMARY = 'entityDashboardMonetizationPrimary';
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  // Main dashboard
  AREA_MAIN_DASHBOARD_KEY_METRICS_PRIMARY,
  AREA_MAIN_DASHBOARD_TRAFFIC_PRIMARY,
  AREA_MAIN_DASHBOARD_CONTENT_PRIMARY,
  AREA_MAIN_DASHBOARD_SPEED_PRIMARY,
  AREA_MAIN_DASHBOARD_MONETIZATION_PRIMARY,
  // Entity dashboard
  AREA_ENTITY_DASHBOARD_TRAFFIC_PRIMARY,
  AREA_ENTITY_DASHBOARD_CONTENT_PRIMARY,
  AREA_ENTITY_DASHBOARD_SPEED_PRIMARY,
  AREA_ENTITY_DASHBOARD_MONETIZATION_PRIMARY
});

/***/ }),

/***/ "./js/googlesitekit/widgets/default-contexts.js":
/*!******************************************************!*\
  !*** ./js/googlesitekit/widgets/default-contexts.js ***!
  \******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   CONTEXT_ENTITY_DASHBOARD_CONTENT: () => (/* binding */ CONTEXT_ENTITY_DASHBOARD_CONTENT),
/* harmony export */   CONTEXT_ENTITY_DASHBOARD_MONETIZATION: () => (/* binding */ CONTEXT_ENTITY_DASHBOARD_MONETIZATION),
/* harmony export */   CONTEXT_ENTITY_DASHBOARD_SPEED: () => (/* binding */ CONTEXT_ENTITY_DASHBOARD_SPEED),
/* harmony export */   CONTEXT_ENTITY_DASHBOARD_TRAFFIC: () => (/* binding */ CONTEXT_ENTITY_DASHBOARD_TRAFFIC),
/* harmony export */   CONTEXT_MAIN_DASHBOARD_CONTENT: () => (/* binding */ CONTEXT_MAIN_DASHBOARD_CONTENT),
/* harmony export */   CONTEXT_MAIN_DASHBOARD_KEY_METRICS: () => (/* binding */ CONTEXT_MAIN_DASHBOARD_KEY_METRICS),
/* harmony export */   CONTEXT_MAIN_DASHBOARD_MONETIZATION: () => (/* binding */ CONTEXT_MAIN_DASHBOARD_MONETIZATION),
/* harmony export */   CONTEXT_MAIN_DASHBOARD_SPEED: () => (/* binding */ CONTEXT_MAIN_DASHBOARD_SPEED),
/* harmony export */   CONTEXT_MAIN_DASHBOARD_TRAFFIC: () => (/* binding */ CONTEXT_MAIN_DASHBOARD_TRAFFIC),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/**
 * Widgets API default contexts
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// Main dashboard
const CONTEXT_MAIN_DASHBOARD_KEY_METRICS = 'mainDashboardKeyMetrics';
const CONTEXT_MAIN_DASHBOARD_TRAFFIC = 'mainDashboardTraffic';
const CONTEXT_MAIN_DASHBOARD_CONTENT = 'mainDashboardContent';
const CONTEXT_MAIN_DASHBOARD_SPEED = 'mainDashboardSpeed';
const CONTEXT_MAIN_DASHBOARD_MONETIZATION = 'mainDashboardMonetization';
// Entity dashboard
const CONTEXT_ENTITY_DASHBOARD_TRAFFIC = 'entityDashboardTraffic';
const CONTEXT_ENTITY_DASHBOARD_CONTENT = 'entityDashboardContent';
const CONTEXT_ENTITY_DASHBOARD_SPEED = 'entityDashboardSpeed';
const CONTEXT_ENTITY_DASHBOARD_MONETIZATION = 'entityDashboardMonetization';
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  // Main dashboard
  CONTEXT_MAIN_DASHBOARD_KEY_METRICS,
  CONTEXT_MAIN_DASHBOARD_TRAFFIC,
  CONTEXT_MAIN_DASHBOARD_CONTENT,
  CONTEXT_MAIN_DASHBOARD_SPEED,
  CONTEXT_MAIN_DASHBOARD_MONETIZATION,
  // Entity dashboard
  CONTEXT_ENTITY_DASHBOARD_TRAFFIC,
  CONTEXT_ENTITY_DASHBOARD_CONTENT,
  CONTEXT_ENTITY_DASHBOARD_SPEED,
  CONTEXT_ENTITY_DASHBOARD_MONETIZATION
});

/***/ }),

/***/ "./js/googlesitekit/widgets/hooks/useWidgetStateEffect.js":
/*!****************************************************************!*\
  !*** ./js/googlesitekit/widgets/hooks/useWidgetStateEffect.js ***!
  \****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ useWidgetStateEffect)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _js_googlesitekit_widgets_datastore_constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/googlesitekit/widgets/datastore/constants */ "./js/googlesitekit/widgets/datastore/constants.js");
/**
 * `useWidgetStateEffect` hook.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */


function useWidgetStateEffect(widgetSlug, Component, metadata) {
  const {
    setWidgetState,
    unsetWidgetState
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useDispatch)(_js_googlesitekit_widgets_datastore_constants__WEBPACK_IMPORTED_MODULE_1__.CORE_WIDGETS);
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useEffect)(() => {
    setWidgetState(widgetSlug, Component, metadata);
    return () => {
      unsetWidgetState(widgetSlug, Component, metadata);
    };
  }, [widgetSlug, Component, metadata, setWidgetState, unsetWidgetState]);
}

/***/ }),

/***/ "./js/googlesitekit/widgets/index.js":
/*!*******************************************!*\
  !*** ./js/googlesitekit/widgets/index.js ***!
  \*******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   createWidgets: () => (/* binding */ createWidgets),
/* harmony export */   registerStore: () => (/* reexport safe */ _datastore__WEBPACK_IMPORTED_MODULE_1__.registerStore),
/* harmony export */   registerWidgets: () => (/* reexport safe */ _register_defaults__WEBPACK_IMPORTED_MODULE_2__.registerDefaults)
/* harmony export */ });
/* harmony import */ var _datastore_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./datastore/constants */ "./js/googlesitekit/widgets/datastore/constants.js");
/* harmony import */ var _datastore__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./datastore */ "./js/googlesitekit/widgets/datastore/index.js");
/* harmony import */ var _register_defaults__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./register-defaults */ "./js/googlesitekit/widgets/register-defaults.js");
/**
 * Widgets API
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Internal dependencies
 */




/**
 * Creates a new instance of Widgets.
 *
 * @since 1.26.0
 *
 * @param {Object}   registry          Datastore registry.
 * @param {Function} registry.select   Registry select function.
 * @param {Function} registry.dispatch Registry dispatch function.
 * @return {Object} Widgets instance.
 */
function createWidgets(registry) {
  const {
    dispatch,
    select
  } = registry;
  const Widgets = {
    /**
     * Supported styles for Site Kit widget areas.
     *
     * @since 1.13.0
     */
    WIDGET_AREA_STYLES: _datastore_constants__WEBPACK_IMPORTED_MODULE_0__.WIDGET_AREA_STYLES,
    /**
     * Supported widths for Site Kit widgets.
     *
     * @since 1.13.0
     */
    WIDGET_WIDTHS: _datastore_constants__WEBPACK_IMPORTED_MODULE_0__.WIDGET_WIDTHS,
    /**
     * Registers a widget area.
     *
     * @since 1.9.0
     *
     * @param {string}         slug                Widget area's slug.
     * @param {Object}         settings            Widget area's settings.
     * @param {string}         settings.title      Title for this widget area.
     * @param {string}         settings.subtitle   Subtitle for this widget area.
     * @param {number}         [settings.priority] Optional. Priority for this widget area. Default: 10.
     * @param {WPComponent}    settings.Icon       Optional. React component to render icon for this widget area.
     * @param {string}         [settings.style]    Optional. Widget area style (one of "boxes", "composite"). Default: "boxes".
     * @param {(string|Array)} [contextSlugs]      Optional. Widget context slug(s).
     */
    registerWidgetArea(slug, settings, contextSlugs) {
      dispatch(_datastore_constants__WEBPACK_IMPORTED_MODULE_0__.CORE_WIDGETS).registerWidgetArea(slug, settings);
      if (contextSlugs) {
        Widgets.assignWidgetArea(slug, contextSlugs);
      }
    },
    /**
     * Registers a widget.
     *
     * @since 1.9.0
     *
     * @param {string}                slug                         Widget's slug.
     * @param {Object}                settings                     Widget's settings.
     * @param {WPComponent}           settings.Component           React component used to display the contents of this widget.
     * @param {number}                [settings.priority]          Optional. Widget's priority for ordering (lower number is higher priority, like WordPress hooks). Default is: 10.
     * @param {string|Array.<string>} [settings.width]             Optional. Widget's maximum width to occupy. Default is: "quarter". One of: "quarter", "half", "full".
     * @param {boolean}               [settings.wrapWidget]        Optional. Whether to wrap the component with the <Widget> wrapper. Default is: true.
     * @param {string|Array.<string>} [settings.modules]           Optional. Widget's associated moduels.
     * @param {Array.<string>}        [settings.hideOnBreakpoints] Optional. Hide widget on selected breakpoints. Array with any of: `BREAKPOINT_SMALL`, `BREAKPOINT_TABLET`, `BREAKPOINT_DESKTOP`, `BREAKPOINT_XLARGE`.
     * @param {(string|Array)}        [widgetAreaSlugs]            Optional. Widget area slug(s).
     */
    registerWidget(slug, settings, widgetAreaSlugs) {
      dispatch(_datastore_constants__WEBPACK_IMPORTED_MODULE_0__.CORE_WIDGETS).registerWidget(slug, settings);
      if (widgetAreaSlugs) {
        Widgets.assignWidget(slug, widgetAreaSlugs);
      }
    },
    /**
     * Assigns a widget area to one (or several) contexts.
     *
     * Accepts an area slug to register as the first argument, then either a string
     * (for a single context slug) or array of contexts slugs (to assign the widget area
     * to multiple contexts).
     *
     * @since 1.9.0
     *
     * @param {string}            slug         Widget Area's slug.
     * @param {(string|string[])} contextSlugs Widget context slug(s).
     */
    assignWidgetArea(slug, contextSlugs) {
      dispatch(_datastore_constants__WEBPACK_IMPORTED_MODULE_0__.CORE_WIDGETS).assignWidgetArea(slug, contextSlugs);
    },
    /**
     * Assigns an existing widget (by slug) to a widget area(s).
     *
     * @since 1.9.0
     *
     * @param {string}            slug            Widget slug.
     * @param {(string|string[])} widgetAreaSlugs Widget area slug(s).
     */
    assignWidget(slug, widgetAreaSlugs) {
      dispatch(_datastore_constants__WEBPACK_IMPORTED_MODULE_0__.CORE_WIDGETS).assignWidget(slug, widgetAreaSlugs);
    },
    /**
     * Checks if a widget area has been registered.
     *
     * Returns `true` if the widget area has been registered.
     * Returns `false` if the widget area has NOT been registered.
     *
     * @since 1.9.0
     *
     * @param {string} slug Widget Area's slug.
     * @return {boolean} `true`/`false` based on whether widget area has been registered.
     */
    isWidgetAreaRegistered(slug) {
      return select(_datastore_constants__WEBPACK_IMPORTED_MODULE_0__.CORE_WIDGETS).isWidgetAreaRegistered(slug);
    },
    /**
     * Checks if a widget has been registered with a given slug.
     *
     * Returns `true` if the widget area has been registered.
     * Returns `false` if the widget area has NOT been registered.
     *
     * @since 1.9.0
     *
     * @param {string} slug Widget's slug.
     * @return {boolean} `true`/`false` based on whether widget has been registered.
     */
    isWidgetRegistered(slug) {
      return select(_datastore_constants__WEBPACK_IMPORTED_MODULE_0__.CORE_WIDGETS).isWidgetRegistered(slug);
    }
  };
  return Widgets;
}

/***/ }),

/***/ "./js/googlesitekit/widgets/register-defaults.js":
/*!*******************************************************!*\
  !*** ./js/googlesitekit/widgets/register-defaults.js ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   registerDefaults: () => (/* binding */ registerDefaults)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _default_contexts__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./default-contexts */ "./js/googlesitekit/widgets/default-contexts.js");
/* harmony import */ var _default_areas__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./default-areas */ "./js/googlesitekit/widgets/default-areas.js");
/* harmony import */ var _js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/googlesitekit/datastore/user/constants */ "./js/googlesitekit/datastore/user/constants.js");
/* harmony import */ var _datastore_constants__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./datastore/constants */ "./js/googlesitekit/widgets/datastore/constants.js");
/* harmony import */ var _js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/googlesitekit/modules/datastore/constants */ "./js/googlesitekit/modules/datastore/constants.js");
/* harmony import */ var _js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @/js/googlesitekit/datastore/site/constants */ "./js/googlesitekit/datastore/site/constants.js");
/* harmony import */ var _js_components_KeyMetrics__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @/js/components/KeyMetrics */ "./js/components/KeyMetrics/index.js");
/* harmony import */ var _js_components_KeyMetrics_AddMetricCTATile__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @/js/components/KeyMetrics/AddMetricCTATile */ "./js/components/KeyMetrics/AddMetricCTATile.js");
/* harmony import */ var _js_components_KeyMetrics_KeyMetricsNewBadge__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @/js/components/KeyMetrics/KeyMetricsNewBadge */ "./js/components/KeyMetrics/KeyMetricsNewBadge.js");
/* harmony import */ var _js_components_KeyMetrics_MetricsWidgetSubtitle__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @/js/components/KeyMetrics/MetricsWidgetSubtitle */ "./js/components/KeyMetrics/MetricsWidgetSubtitle.js");
/* harmony import */ var _js_modules_analytics_4_components_widgets_ConnectGA4CTAWidget__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @/js/modules/analytics-4/components/widgets/ConnectGA4CTAWidget */ "./js/modules/analytics-4/components/widgets/ConnectGA4CTAWidget.js");
/* harmony import */ var _js_modules_analytics_4_components_audience_segmentation_dashboard__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! @/js/modules/analytics-4/components/audience-segmentation/dashboard */ "./js/modules/analytics-4/components/audience-segmentation/dashboard/index.js");
/* harmony import */ var _js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! @/js/hooks/useBreakpoint */ "./js/hooks/useBreakpoint.js");
/* harmony import */ var _js_modules_analytics_4_constants__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! @/js/modules/analytics-4/constants */ "./js/modules/analytics-4/constants.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Widgets API defaults
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */















const {
  ...ADDITIONAL_WIDGET_CONTEXTS
} = _default_contexts__WEBPACK_IMPORTED_MODULE_1__;
const {
  ...ADDITIONAL_WIDGET_AREAS
} = _default_areas__WEBPACK_IMPORTED_MODULE_2__;

/**
 * Defines default widget areas for a given context
 * and registers non-module specific widgets.
 *
 * @since 1.12.0
 *
 * @param {Object} widgetsAPI Widgets API.
 */
function registerDefaults(widgetsAPI) {
  const {
    // Main dashboard
    CONTEXT_MAIN_DASHBOARD_KEY_METRICS,
    CONTEXT_MAIN_DASHBOARD_TRAFFIC,
    CONTEXT_MAIN_DASHBOARD_CONTENT,
    CONTEXT_MAIN_DASHBOARD_SPEED,
    CONTEXT_MAIN_DASHBOARD_MONETIZATION,
    // Entity dashboard
    CONTEXT_ENTITY_DASHBOARD_TRAFFIC,
    CONTEXT_ENTITY_DASHBOARD_CONTENT,
    CONTEXT_ENTITY_DASHBOARD_SPEED,
    CONTEXT_ENTITY_DASHBOARD_MONETIZATION
  } = ADDITIONAL_WIDGET_CONTEXTS;
  const {
    // Main dashboard
    AREA_MAIN_DASHBOARD_KEY_METRICS_PRIMARY,
    AREA_MAIN_DASHBOARD_TRAFFIC_PRIMARY,
    AREA_MAIN_DASHBOARD_TRAFFIC_AUDIENCE_SEGMENTATION,
    AREA_MAIN_DASHBOARD_CONTENT_PRIMARY,
    AREA_MAIN_DASHBOARD_SPEED_PRIMARY,
    AREA_MAIN_DASHBOARD_MONETIZATION_PRIMARY,
    // Entity dashboard
    AREA_ENTITY_DASHBOARD_TRAFFIC_PRIMARY,
    AREA_ENTITY_DASHBOARD_CONTENT_PRIMARY,
    AREA_ENTITY_DASHBOARD_SPEED_PRIMARY,
    AREA_ENTITY_DASHBOARD_MONETIZATION_PRIMARY
  } = ADDITIONAL_WIDGET_AREAS;

  /*
   * Main dashboard areas.
   */

  widgetsAPI.registerWidgetArea(AREA_MAIN_DASHBOARD_KEY_METRICS_PRIMARY, {
    title: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsxs)(_wordpress_element__WEBPACK_IMPORTED_MODULE_16__.Fragment, {
      children: [(0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Key metrics', 'google-site-kit'), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsx)(_js_components_KeyMetrics_KeyMetricsNewBadge__WEBPACK_IMPORTED_MODULE_9__["default"], {})]
    }),
    subtitle: _js_components_KeyMetrics_MetricsWidgetSubtitle__WEBPACK_IMPORTED_MODULE_10__["default"],
    style: _datastore_constants__WEBPACK_IMPORTED_MODULE_4__.WIDGET_AREA_STYLES.BOXES,
    priority: 1,
    CTA: _js_components_KeyMetrics__WEBPACK_IMPORTED_MODULE_7__.ChangeMetricsLink,
    filterActiveWidgets(select, areaWidgets) {
      // Prevent showing only one widget tile in this area when
      // only Search Console is shared.
      // See: https://github.com/google/site-kit-wp/issues/7435
      if (areaWidgets.length === 1 && _js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_3__.allKeyMetricsTileWidgets.includes(areaWidgets[0].slug)) {
        return [];
      }
      return areaWidgets;
    }
  }, CONTEXT_MAIN_DASHBOARD_KEY_METRICS);
  widgetsAPI.registerWidgetArea(AREA_MAIN_DASHBOARD_TRAFFIC_PRIMARY, {
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Find out how your audience is growing', 'google-site-kit'),
    subtitle: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Track your site’s traffic over time', 'google-site-kit'),
    style: _datastore_constants__WEBPACK_IMPORTED_MODULE_4__.WIDGET_AREA_STYLES.BOXES,
    priority: 1
  }, CONTEXT_MAIN_DASHBOARD_TRAFFIC);
  widgetsAPI.registerWidgetArea(AREA_MAIN_DASHBOARD_TRAFFIC_AUDIENCE_SEGMENTATION, {
    subtitle: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Understand how different visitor groups interact with your site', 'google-site-kit'),
    hasNewBadge: true,
    style: _datastore_constants__WEBPACK_IMPORTED_MODULE_4__.WIDGET_AREA_STYLES.BOXES,
    priority: 2,
    CTA: _js_modules_analytics_4_components_audience_segmentation_dashboard__WEBPACK_IMPORTED_MODULE_12__.ChangeGroupsLink,
    Footer: _js_modules_analytics_4_components_audience_segmentation_dashboard__WEBPACK_IMPORTED_MODULE_12__.AudienceAreaFooter,
    filterActiveWidgets(select, areaWidgets) {
      const isAudienceSegmentationWidgetHidden = select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_USER).isAudienceSegmentationWidgetHidden();
      if (isAudienceSegmentationWidgetHidden === undefined || isAudienceSegmentationWidgetHidden) {
        return [];
      }
      return areaWidgets;
    }
  }, CONTEXT_MAIN_DASHBOARD_TRAFFIC);
  widgetsAPI.registerWidgetArea(AREA_MAIN_DASHBOARD_CONTENT_PRIMARY, {
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('See how your content is doing', 'google-site-kit'),
    subtitle: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Keep track of your most popular pages and how people found them from Search', 'google-site-kit'),
    style: _datastore_constants__WEBPACK_IMPORTED_MODULE_4__.WIDGET_AREA_STYLES.BOXES,
    priority: 1
  }, CONTEXT_MAIN_DASHBOARD_CONTENT);
  widgetsAPI.registerWidgetArea(AREA_MAIN_DASHBOARD_SPEED_PRIMARY, {
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Find out how visitors experience your site', 'google-site-kit'),
    subtitle: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Keep track of how fast your pages are and get specific recommendations on what to improve', 'google-site-kit'),
    style: _datastore_constants__WEBPACK_IMPORTED_MODULE_4__.WIDGET_AREA_STYLES.BOXES,
    priority: 1
  }, CONTEXT_MAIN_DASHBOARD_SPEED);
  widgetsAPI.registerWidgetArea(AREA_MAIN_DASHBOARD_MONETIZATION_PRIMARY, {
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Find out how much you’re earning from your content', 'google-site-kit'),
    subtitle: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Track your AdSense revenue over time', 'google-site-kit'),
    style: _datastore_constants__WEBPACK_IMPORTED_MODULE_4__.WIDGET_AREA_STYLES.BOXES,
    priority: 1
  }, CONTEXT_MAIN_DASHBOARD_MONETIZATION);

  /*
   * Entity dashboard areas.
   */

  widgetsAPI.registerWidgetArea(AREA_ENTITY_DASHBOARD_TRAFFIC_PRIMARY, {
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Find out how your audience is growing', 'google-site-kit'),
    subtitle: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Track traffic to this page over time', 'google-site-kit'),
    style: _datastore_constants__WEBPACK_IMPORTED_MODULE_4__.WIDGET_AREA_STYLES.BOXES,
    priority: 1
  }, CONTEXT_ENTITY_DASHBOARD_TRAFFIC);
  widgetsAPI.registerWidgetArea(AREA_ENTITY_DASHBOARD_CONTENT_PRIMARY, {
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('See how your content is doing', 'google-site-kit'),
    subtitle: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Understand how people found this page from Search', 'google-site-kit'),
    style: _datastore_constants__WEBPACK_IMPORTED_MODULE_4__.WIDGET_AREA_STYLES.BOXES,
    priority: 1
  }, CONTEXT_ENTITY_DASHBOARD_CONTENT);
  widgetsAPI.registerWidgetArea(AREA_ENTITY_DASHBOARD_SPEED_PRIMARY, {
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Find out how visitors experience this page', 'google-site-kit'),
    subtitle: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Keep track of how fast your page is and get specific recommendations on what to improve', 'google-site-kit'),
    style: _datastore_constants__WEBPACK_IMPORTED_MODULE_4__.WIDGET_AREA_STYLES.BOXES,
    priority: 1
  }, CONTEXT_ENTITY_DASHBOARD_SPEED);
  widgetsAPI.registerWidgetArea(AREA_ENTITY_DASHBOARD_MONETIZATION_PRIMARY, {
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Find out how much you’re earning from your content', 'google-site-kit'),
    subtitle: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Track your AdSense revenue over time', 'google-site-kit'),
    style: _datastore_constants__WEBPACK_IMPORTED_MODULE_4__.WIDGET_AREA_STYLES.BOXES,
    priority: 1
  }, CONTEXT_ENTITY_DASHBOARD_MONETIZATION);
  widgetsAPI.registerWidget('keyMetricsSetupCTA', {
    Component: _js_components_KeyMetrics__WEBPACK_IMPORTED_MODULE_7__.KeyMetricsSetupCTAWidget,
    width: [widgetsAPI.WIDGET_WIDTHS.FULL],
    priority: 1,
    wrapWidget: false,
    isActive: select => select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_USER).isAuthenticated() && select(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_6__.CORE_SITE).isKeyMetricsSetupCompleted() === false
  }, [AREA_MAIN_DASHBOARD_KEY_METRICS_PRIMARY]);

  /**
   * This widget is only shown if the GA4 module is not connected,
   * AND if the user has four KMW tiles dependent on GA4.
   * If the user has selected less than four KMW tiles dependent on GA4,
   * we show the `ConnectGA4CTATileWidget` instead.
   */
  widgetsAPI.registerWidget('keyMetricsConnectGA4All', {
    Component: _js_modules_analytics_4_components_widgets_ConnectGA4CTAWidget__WEBPACK_IMPORTED_MODULE_11__["default"],
    width: [widgetsAPI.WIDGET_WIDTHS.FULL],
    priority: 1,
    wrapWidget: false,
    isActive: select => {
      const keyMetrics = select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_USER).getKeyMetrics();
      const isGA4Connected = select(_js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_5__.CORE_MODULES).isModuleConnected(_js_modules_analytics_4_constants__WEBPACK_IMPORTED_MODULE_14__.MODULE_SLUG_ANALYTICS_4);
      if (isGA4Connected || !Array.isArray(keyMetrics)) {
        return false;
      }
      const kmAnalyticsWidgetCount = keyMetrics.filter(keyMetric => _js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_3__.keyMetricsGA4Widgets.includes(keyMetric)).length;
      return kmAnalyticsWidgetCount > 3;
    }
  }, [AREA_MAIN_DASHBOARD_KEY_METRICS_PRIMARY]);

  /**
   * Since we allow selecting at least two and at most four key
   * metrics, we're adding two instances of the same AddMetricCTATile
   * widget. Using the isActive property, we'll show one
   * AddMetricCTATile widget if the user has selected three
   * key metrics, or both if they have selected two key metrics.
   */
  widgetsAPI.registerWidget('keyMetricsAddMetricFirst', {
    Component: _js_components_KeyMetrics_AddMetricCTATile__WEBPACK_IMPORTED_MODULE_8__["default"],
    width: [widgetsAPI.WIDGET_WIDTHS.QUARTER],
    priority: 3,
    // GA4 tiles are 1, SC tiles are 2, so these should always be at the end.
    wrapWidget: false,
    isActive: select => {
      const keyMetrics = select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_USER).getKeyMetrics();
      if (!Array.isArray(keyMetrics) || keyMetrics.length < 2) {
        return false;
      }
      return keyMetrics.length < 4;
    }
  }, [AREA_MAIN_DASHBOARD_KEY_METRICS_PRIMARY]);
  widgetsAPI.registerWidget('keyMetricsAddMetricSecond', {
    Component: _js_components_KeyMetrics_AddMetricCTATile__WEBPACK_IMPORTED_MODULE_8__["default"],
    width: [widgetsAPI.WIDGET_WIDTHS.QUARTER],
    priority: 3,
    // GA4 tiles are 1, SC tiles are 2, so these should always be at the end.
    wrapWidget: false,
    isActive: select => {
      const keyMetrics = select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_USER).getKeyMetrics();
      if (!Array.isArray(keyMetrics) || keyMetrics.length < 2) {
        return false;
      }
      return keyMetrics.length < 3;
    }
  }, [AREA_MAIN_DASHBOARD_KEY_METRICS_PRIMARY]);
  widgetsAPI.registerWidget('keyMetricsAddMetricThird', {
    Component: _js_components_KeyMetrics_AddMetricCTATile__WEBPACK_IMPORTED_MODULE_8__["default"],
    width: [widgetsAPI.WIDGET_WIDTHS.QUARTER],
    priority: 3,
    // GA4 tiles are 1, SC tiles are 2, so these should always be at the end.
    wrapWidget: false,
    isActive: select => {
      const keyMetrics = select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_USER).getKeyMetrics();
      if (!Array.isArray(keyMetrics) || keyMetrics.length < 5) {
        return false;
      }
      return keyMetrics.length < 8;
    }
  }, [AREA_MAIN_DASHBOARD_KEY_METRICS_PRIMARY]);
  widgetsAPI.registerWidget('keyMetricsAddMetricFourth', {
    Component: _js_components_KeyMetrics_AddMetricCTATile__WEBPACK_IMPORTED_MODULE_8__["default"],
    width: [widgetsAPI.WIDGET_WIDTHS.QUARTER],
    priority: 3,
    // GA4 tiles are 1, SC tiles are 2, so these should always be at the end.
    wrapWidget: false,
    hideOnBreakpoints: [_js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_13__.BREAKPOINT_SMALL],
    isActive: select => {
      const keyMetrics = select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_USER).getKeyMetrics();
      if (!Array.isArray(keyMetrics) || keyMetrics.length < 5) {
        return false;
      }
      return keyMetrics.length < 7;
    }
  }, [AREA_MAIN_DASHBOARD_KEY_METRICS_PRIMARY]);
  widgetsAPI.registerWidget('keyMetricsAddMetricFifth', {
    Component: _js_components_KeyMetrics_AddMetricCTATile__WEBPACK_IMPORTED_MODULE_8__["default"],
    width: [widgetsAPI.WIDGET_WIDTHS.QUARTER],
    priority: 3,
    // GA4 tiles are 1, SC tiles are 2, so these should always be at the end.
    wrapWidget: false,
    hideOnBreakpoints: [_js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_13__.BREAKPOINT_SMALL],
    isActive: select => {
      const keyMetrics = select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_USER).getKeyMetrics();
      if (!Array.isArray(keyMetrics) || keyMetrics.length < 5) {
        return false;
      }
      return keyMetrics.length < 6;
    }
  }, [AREA_MAIN_DASHBOARD_KEY_METRICS_PRIMARY]);
}

/***/ }),

/***/ "./js/googlesitekit/widgets/util/combine-widgets.js":
/*!**********************************************************!*\
  !*** ./js/googlesitekit/widgets/util/combine-widgets.js ***!
  \**********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   combineWidgets: () => (/* binding */ combineWidgets)
/* harmony export */ });
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! lodash */ "../node_modules/lodash/lodash.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./constants */ "./js/googlesitekit/widgets/util/constants.js");
/**
 * Widgets combination utilities.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * Internal dependencies
 */

function stateAndRowMatch(stateA, stateB, rowA, rowB) {
  return rowA === rowB && (0,lodash__WEBPACK_IMPORTED_MODULE_0__.isEqual)(stateA, stateB);
}

/**
 * Determines whether all the widgets in a given area should be combined.
 *
 * The given widgets in an area can all be combined if they are
 * all from the same module and they are all in the same special
 * state (see #3225).
 *
 * @since 1.34.0
 *
 * @param {Array.<Object>} widgets      List of widgets.
 * @param {Object}         widgetStates Map of widget slug and their
 *                                             state (either an object with
 *                                             `Component` and `metadata`, or
 *                                             `null`).
 * @return {boolean} 			Whether all the widgets should be combined.
 */
function shouldCombineAllWidgets(widgets, widgetStates) {
  const states = {};
  for (let i = 0; i < widgets.length; i++) {
    const widget = widgets[i];
    const widgetState = widgetStates?.[widget.slug];
    const state = widgetState?.Component;
    const module = widgetState?.metadata?.moduleSlug;
    const isSpecialState = _constants__WEBPACK_IMPORTED_MODULE_1__.SPECIAL_WIDGET_STATES.includes(state);
    if (!state || !module || !isSpecialState) {
      return false;
    }
    if (states[module]) {
      if (states[module] !== state) {
        // We have a widget from a given module in a different state from the others.
        return false;
      }
    } else {
      states[module] = state;
    }
  }
  if (Object.keys(states).length > 1) {
    // We have multiple modules, so the widgets can't be combined.
    return false;
  }
  return true;
}

/*
 * Combines consecutive widgets with similar states within the same row.
 *
 * @since 1.25.0
 *
 * @param {Array.<Object>} widgets             List of widgets.
 * @param {Object}         widgetStates        Map of widget slug and their
 *                                             state (either an object with
 *                                             `Component` and `metadata`, or
 *                                             `null`).
 * @param {Object}         layout              Layout arguments from
 *                                             	`getWidgetLayout()`.
 * @param {Array.<number>} layout.columnWidths List of column widths for each
 *                                             widget.
 * @param {Array.<number>} layout.rowIndexes   List of row indexes for each
 *                                             widget.
 * @return {Object} Object with `overrideComponents` property, both of which are a
 * 					list with one item for each widget. Every `overrideComponents`
 * 					entry is either an object with `Component` and `metadata`, or
 * 					`null` (similar to the `widgetStates` parameter).
 */
function combineWidgets(widgets, widgetStates, {
  columnWidths,
  rowIndexes
}) {
  const overrideComponents = [];
  const gridColumnWidths = [...columnWidths];
  if (!widgets?.length) {
    return {
      gridColumnWidths,
      overrideComponents
    };
  }
  let currentState = null;
  let currentRowIndex = -1;
  let columnWidthsBuffer = [];
  if (shouldCombineAllWidgets(widgets, widgetStates)) {
    // All the widgets have the same state, so we should only render one and hide the rest.
    const hiddenRows = Array.from({
      length: widgets.length - 1
    }).fill(0);
    // Since all the components are the same, we can just pick the first.
    const overrideComponent = widgetStates[widgets[0].slug];
    return {
      overrideComponents: [overrideComponent],
      gridColumnWidths: [12,
      // Full width row.
      ...hiddenRows]
    };
  }
  widgets.forEach((widget, i) => {
    overrideComponents.push(null);
    currentState = widgetStates[widget.slug];
    currentRowIndex = rowIndexes[i];

    // If the current widget has a special state...
    if (currentState) {
      if (stateAndRowMatch(currentState, widgetStates[widgets[i + 1]?.slug], currentRowIndex, rowIndexes[i + 1])) {
        // If the current widget state and row index match the next
        // state and row index, hide the widget entirely. Only the last
        // similar instance will be rendered in this case.
        columnWidthsBuffer.push(columnWidths[i]);
        // Mark this column as width = 0, so we can hide it
        gridColumnWidths[i] = 0;
      } else if (columnWidthsBuffer.length > 0) {
        // If the state and row index do not match the next ones and
        // there are already similar instances (from previous
        // iterations), this is the last similar instance, so the
        // combined version will need to be displayed instead of the
        // widget. The combined version will use the common Component
        // and pass all common metadata as props.
        columnWidthsBuffer.push(columnWidths[i]);

        // Get total (desktop) column width. For tablet and phone,
        // the component should span the full width as by definition
        // it is at least a "half" widget wide (which has that behavior).
        const combinedColumnWidth = columnWidthsBuffer.reduce((sum, columnWidth) => sum + columnWidth, 0);
        overrideComponents[i] = currentState;

        // This final column should have the combined width
        gridColumnWidths[i] = combinedColumnWidth;

        // Reset the columnWidthsBuffer variable.
        columnWidthsBuffer = [];
      }
    }
  });
  return {
    gridColumnWidths,
    overrideComponents
  };
}

/***/ }),

/***/ "./js/googlesitekit/widgets/util/constants.js":
/*!****************************************************!*\
  !*** ./js/googlesitekit/widgets/util/constants.js ***!
  \****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   HIDDEN_CLASS: () => (/* binding */ HIDDEN_CLASS),
/* harmony export */   SPECIAL_WIDGET_STATES: () => (/* binding */ SPECIAL_WIDGET_STATES),
/* harmony export */   WIDTH_GRID_COUNTER_MAP: () => (/* binding */ WIDTH_GRID_COUNTER_MAP)
/* harmony export */ });
/* harmony import */ var _js_googlesitekit_widgets_datastore_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @/js/googlesitekit/widgets/datastore/constants */ "./js/googlesitekit/widgets/datastore/constants.js");
/* harmony import */ var _js_components_ReportZero__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/components/ReportZero */ "./js/components/ReportZero.js");
/* harmony import */ var _js_components_RecoverableModules__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/components/RecoverableModules */ "./js/components/RecoverableModules.js");
/**
 * Widgets layout constants.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Internal dependencies
 */



const WIDTH_GRID_COUNTER_MAP = {
  [_js_googlesitekit_widgets_datastore_constants__WEBPACK_IMPORTED_MODULE_0__.WIDGET_WIDTHS.QUARTER]: 3,
  [_js_googlesitekit_widgets_datastore_constants__WEBPACK_IMPORTED_MODULE_0__.WIDGET_WIDTHS.HALF]: 6,
  [_js_googlesitekit_widgets_datastore_constants__WEBPACK_IMPORTED_MODULE_0__.WIDGET_WIDTHS.FULL]: 12
};
const HIDDEN_CLASS = 'googlesitekit-hidden';
const SPECIAL_WIDGET_STATES = [_js_components_ReportZero__WEBPACK_IMPORTED_MODULE_1__["default"], _js_components_RecoverableModules__WEBPACK_IMPORTED_MODULE_2__["default"]];

/***/ }),

/***/ "./js/googlesitekit/widgets/util/get-widget-component-props.js":
/*!*********************************************************************!*\
  !*** ./js/googlesitekit/widgets/util/get-widget-component-props.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   getWidgetComponentProps: () => (/* binding */ getWidgetComponentProps),
/* harmony export */   withWPDashboardWidgetComponentProps: () => (/* binding */ withWPDashboardWidgetComponentProps),
/* harmony export */   withWidgetComponentProps: () => (/* binding */ withWidgetComponentProps)
/* harmony export */ });
/* harmony import */ var memize__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! memize */ "../node_modules/memize/index.js");
/* harmony import */ var memize__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(memize__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _js_googlesitekit_widgets_components_Widget__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/googlesitekit/widgets/components/Widget */ "./js/googlesitekit/widgets/components/Widget.js");
/* harmony import */ var _js_googlesitekit_widgets_components_WidgetReportZero__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/googlesitekit/widgets/components/WidgetReportZero */ "./js/googlesitekit/widgets/components/WidgetReportZero.js");
/* harmony import */ var _js_googlesitekit_widgets_components_WidgetReportError__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/googlesitekit/widgets/components/WidgetReportError */ "./js/googlesitekit/widgets/components/WidgetReportError.js");
/* harmony import */ var _js_googlesitekit_widgets_components_WidgetNull__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/googlesitekit/widgets/components/WidgetNull */ "./js/googlesitekit/widgets/components/WidgetNull.js");
/* harmony import */ var _js_googlesitekit_widgets_components_WidgetRecoverableModules__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/googlesitekit/widgets/components/WidgetRecoverableModules */ "./js/googlesitekit/widgets/components/WidgetRecoverableModules.js");
/* harmony import */ var _js_googlesitekit_widgets_components_WPDashboardReportError__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @/js/googlesitekit/widgets/components/WPDashboardReportError */ "./js/googlesitekit/widgets/components/WPDashboardReportError.js");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Widgets component props utilities.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * Internal dependencies
 */







/**
 * WordPress dependencies
 */


/**
 * Gets the props to pass to a widget's component.
 *
 * @since 1.25.0
 * @since 1.107.0 Added `widgetSlug` to the returned props.
 *
 * @param {string} widgetSlug The widget's slug.
 * @return {Object} Props to pass to the widget component.
 */

const getWidgetComponentProps = memize__WEBPACK_IMPORTED_MODULE_0___default()(widgetSlug => {
  // Scope widget-specific components to the widget instance so that the
  // component does not need to (re-)specify the widget slug.
  return {
    widgetSlug,
    Widget: withWidgetSlug(widgetSlug)(_js_googlesitekit_widgets_components_Widget__WEBPACK_IMPORTED_MODULE_1__["default"]),
    WidgetRecoverableModules: withWidgetSlug(widgetSlug)(_js_googlesitekit_widgets_components_WidgetRecoverableModules__WEBPACK_IMPORTED_MODULE_5__["default"]),
    WidgetReportZero: withWidgetSlug(widgetSlug)(_js_googlesitekit_widgets_components_WidgetReportZero__WEBPACK_IMPORTED_MODULE_2__["default"]),
    WidgetReportError: withWidgetSlug(widgetSlug)(_js_googlesitekit_widgets_components_WidgetReportError__WEBPACK_IMPORTED_MODULE_3__["default"]),
    WidgetNull: withWidgetSlug(widgetSlug)(_js_googlesitekit_widgets_components_WidgetNull__WEBPACK_IMPORTED_MODULE_4__["default"])
  };
});
function withWidgetSlug(widgetSlug) {
  return WrappedComponent => {
    const WithWidgetSlug = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_8__.forwardRef)((props, ref) => {
      return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(WrappedComponent, {
        ...props,
        ref: ref,
        widgetSlug: widgetSlug
      });
    });
    WithWidgetSlug.displayName = 'WithWidgetSlug';
    if (WrappedComponent.displayName || WrappedComponent.name) {
      WithWidgetSlug.displayName += `(${WrappedComponent.displayName || WrappedComponent.name})`;
    }
    return WithWidgetSlug;
  };
}

/**
 * Gets the props and passes them to the widget's component through a HOC.
 *
 * @since 1.26.0
 *
 * @param {string} widgetSlug The slug of the widget.
 * @return {Function} Enhancing function that adds the getWidgetComponentProps to the passed component.
 */
function withWidgetComponentProps(widgetSlug) {
  const widgetComponentProps = getWidgetComponentProps(widgetSlug);
  return WrappedComponent => {
    function DecoratedComponent(props) {
      return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(WrappedComponent, {
        ...props,
        ...widgetComponentProps
      });
    }
    DecoratedComponent.displayName = 'WithWidgetComponentProps';
    if (WrappedComponent.displayName || WrappedComponent.name) {
      DecoratedComponent.displayName += `(${WrappedComponent.displayName || WrappedComponent.name})`;
    }
    return DecoratedComponent;
  };
}

/**
 * Gets the props and passes them to the WP Dashboard widget's component through a HOC.
 *
 * @since 1.114.0
 *
 * @param {string} widgetSlug The slug of the widget.
 * @return {Function} Enhancing function that adds the WP Dashboard specific
 *                    props to the passed component.
 */
function withWPDashboardWidgetComponentProps(widgetSlug) {
  return WrappedComponent => {
    function DecoratedComponent(props) {
      return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(WrappedComponent, {
        ...props,
        WPDashboardReportError: withWidgetSlug(widgetSlug)(_js_googlesitekit_widgets_components_WPDashboardReportError__WEBPACK_IMPORTED_MODULE_6__["default"])
      });
    }
    DecoratedComponent.displayName = 'WithWPDashboardWidgetComponentProps';
    if (WrappedComponent.displayName || WrappedComponent.name) {
      DecoratedComponent.displayName += `(${WrappedComponent.displayName || WrappedComponent.name})`;
    }
    return DecoratedComponent;
  };
}

/***/ }),

/***/ "./js/googlesitekit/widgets/util/get-widget-layout.js":
/*!************************************************************!*\
  !*** ./js/googlesitekit/widgets/util/get-widget-layout.js ***!
  \************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   getWidgetLayout: () => (/* binding */ getWidgetLayout)
/* harmony export */ });
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./constants */ "./js/googlesitekit/widgets/util/constants.js");
/* harmony import */ var _is_inactive_widget_state__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./is-inactive-widget-state */ "./js/googlesitekit/widgets/util/is-inactive-widget-state.js");
/**
 * Widgets layout utilities.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Internal dependencies
 */



/**
 * Adjusts column widths to better fit into the current row knowing that the default sizes don't fill the row completely.
 *
 * @since 1.21.0
 *
 * @param {Array.<number>} columnWidths Current column widths.
 * @param {number}         counter      Current counter.
 * @return {Array} Array where the first element is the updated list of column
 *                 widths, and the second element is the resulting counter
 *                 after the update.
 */
function resizeColumns(columnWidths, counter) {
  // Safeguard: counter must always be 9 for this to work.
  if (counter !== 9) {
    return [columnWidths, counter];
  }
  columnWidths = [...columnWidths];

  // Start counting backwards from the last item.
  let i = columnWidths.length - 1;

  // Go back until counter is 0. The i >= 0 check is an extra safeguard that, with
  // correct usage should never apply, but is still useful to avoid infinite loops
  // if the function was used incorrectly.
  while (counter !== 0 && i >= 0) {
    // Replace the 3-column width with a 4-column width, or the 6-column
    // width with an 8-column width so that the overall row expands from
    // 9 to the full 12 columns.
    if (columnWidths[i] === 3) {
      counter -= 3;
      columnWidths[i] = 4; // Correct the column width.
    } else if (columnWidths[i] === 6) {
      counter -= 6;
      columnWidths[i] = 8; // Correct the column width.
    }
    i--;
  }
  return [columnWidths, counter];
}

/**
 * Gets an array of sizes that widget can take accounting the current counter value.
 *
 * @since 1.21.0
 *
 * @param {number} counter The current counter.
 * @param {Object} widget  Widget object.
 * @return {Array.<Object>} List of objects with `counter` and `width` properties.
 */
function getWidgetSizes(counter, widget) {
  const widths = Array.isArray(widget.width) ? widget.width : [widget.width];
  return widths.map(width => ({
    counter: counter + _constants__WEBPACK_IMPORTED_MODULE_0__.WIDTH_GRID_COUNTER_MAP[width],
    width
  }));
}

/**
 * Gets the first active widget in a list of widgets, after a specified offset,
 * based on a set of widget states specifying which widgets are inactive.
 *
 * @since 1.28.0
 * @private
 *
 * @param {number}         offset       The current index offset.
 * @param {Array.<Object>} widgets      List of widgets.
 * @param {Array.<Object>} widgetStates List of widget states.
 * @return {Object|null} Object representing the next active widget from the widgets array,
 * or null if no more active widgets exist.
 */
function getNextActiveWidget(offset, widgets, widgetStates) {
  while (++offset < widgets.length) {
    if (!(0,_is_inactive_widget_state__WEBPACK_IMPORTED_MODULE_1__.isInactiveWidgetState)(widgetStates[widgets[offset].slug])) {
      return widgets[offset];
    }
  }
  return null;
}

/**
 * Gets widget class names as well as column widths and row indexes for an area.
 *
 * @since 1.25.0
 *
 * @param {Array.<Object>} widgets      List of widgets.
 * @param {Array.<Object>} widgetStates List of widget states.
 * @return {Object} Object with `columnWidths` and `rowIndexes`
 *                  properties, each of which is an array with one item for
 *                  each active widget.
 */
function getWidgetLayout(widgets, widgetStates) {
  let columnWidths = [];
  const rowIndexes = [];
  if (!widgets?.length) {
    return {
      columnWidths,
      rowIndexes
    };
  }
  let counter = 0;
  let rowIndex = 0;
  function ascending({
    counter: a
  }, {
    counter: b
  }) {
    return a - b;
  }
  function descending({
    counter: a
  }, {
    counter: b
  }) {
    return b - a;
  }
  function fitIntoRow({
    counter: width
  }) {
    return width <= 12;
  }
  widgets.forEach((widget, i) => {
    // If a widget is inactive, we set null / 0 values and don't need to calculate a layout.

    if ((0,_is_inactive_widget_state__WEBPACK_IMPORTED_MODULE_1__.isInactiveWidgetState)(widgetStates[widget.slug])) {
      columnWidths.push(0);
      rowIndexes.push(rowIndex);
      return;
    }

    // Get available sizes for the current widget to select the most appropriate width for the current row.
    let sizes = getWidgetSizes(counter, widget);

    // Get the next active widget to help determine the best width for this widget.
    const nextActiveWidget = getNextActiveWidget(i, widgets, widgetStates);
    if (
    // If it is the last widget in the entire widget area.
    null === nextActiveWidget ||
    // Or the next widget can't fit into the current row anyway, then we can try to use alternative sizes.
    getWidgetSizes(sizes.sort(ascending)[0].counter, nextActiveWidget).filter(fitIntoRow).length === 0) {
      // We need to check whether we have a size that can fit into the row and if so, try to get it.
      const hasSizeThatCanFitIntoRow = sizes.some(fitIntoRow);
      if (hasSizeThatCanFitIntoRow) {
        // Sort available sizes to have the descending order.
        sizes = sizes.sort(descending);
        // Filter out only those sizes that fit into the current row.
        sizes = sizes.filter(fitIntoRow);
      }
    }

    // Grab the width of the first size in the sizes list, it's either the default one or the best suiting to the current row.
    const width = sizes[0].width;

    // Populate row index for the widget. The value may be corrected further below.
    rowIndexes.push(rowIndex);

    // Increase column counter based on width.
    counter += _constants__WEBPACK_IMPORTED_MODULE_0__.WIDTH_GRID_COUNTER_MAP[width];

    // If counter is going above 12, this widget is too wide for the current row.
    // So it's going to be the first widget in the next row instead.
    if (counter > 12) {
      counter -= _constants__WEBPACK_IMPORTED_MODULE_0__.WIDTH_GRID_COUNTER_MAP[width];

      // Correct the previously added row index for this widget as it
      // will end up in the following row.
      rowIndexes[i]++;

      // If the column count without the overflowing widget is exactly 9, expand
      // the widths of these widgets slightly to fill the entire 12 columns.
      if (counter === 9) {
        [columnWidths, counter] = resizeColumns(columnWidths, counter);
      }

      // See above, initial counter for the next row of widgets.
      counter = _constants__WEBPACK_IMPORTED_MODULE_0__.WIDTH_GRID_COUNTER_MAP[width];
      rowIndex++;
    } else if (counter === 12) {
      // Or if the counter is exactly 12, the next widget is going to be in a new row.
      counter = 0;
      rowIndex++;
    }

    // Actually set the columnWidth for the current widget. This must be set after
    // potentially resizing, since in that case this will be the overflowing
    // widget which should NOT be adjusted because it will be in the next row.
    columnWidths.push(_constants__WEBPACK_IMPORTED_MODULE_0__.WIDTH_GRID_COUNTER_MAP[width]);
  });
  if (counter === 9) {
    [columnWidths, counter] = resizeColumns(columnWidths, counter);
  }
  return {
    columnWidths,
    rowIndexes
  };
}

/***/ }),

/***/ "./js/googlesitekit/widgets/util/index.js":
/*!************************************************!*\
  !*** ./js/googlesitekit/widgets/util/index.js ***!
  \************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   HIDDEN_CLASS: () => (/* reexport safe */ _constants__WEBPACK_IMPORTED_MODULE_3__.HIDDEN_CLASS),
/* harmony export */   SPECIAL_WIDGET_STATES: () => (/* reexport safe */ _constants__WEBPACK_IMPORTED_MODULE_3__.SPECIAL_WIDGET_STATES),
/* harmony export */   WIDTH_GRID_COUNTER_MAP: () => (/* reexport safe */ _constants__WEBPACK_IMPORTED_MODULE_3__.WIDTH_GRID_COUNTER_MAP),
/* harmony export */   combineWidgets: () => (/* reexport safe */ _combine_widgets__WEBPACK_IMPORTED_MODULE_1__.combineWidgets),
/* harmony export */   getWidgetComponentProps: () => (/* reexport safe */ _get_widget_component_props__WEBPACK_IMPORTED_MODULE_2__.getWidgetComponentProps),
/* harmony export */   getWidgetLayout: () => (/* reexport safe */ _get_widget_layout__WEBPACK_IMPORTED_MODULE_0__.getWidgetLayout),
/* harmony export */   isInactiveWidgetState: () => (/* reexport safe */ _is_inactive_widget_state__WEBPACK_IMPORTED_MODULE_5__.isInactiveWidgetState),
/* harmony export */   normalizeWidgetModules: () => (/* reexport safe */ _widget_modules__WEBPACK_IMPORTED_MODULE_4__.normalizeWidgetModules),
/* harmony export */   withWPDashboardWidgetComponentProps: () => (/* reexport safe */ _get_widget_component_props__WEBPACK_IMPORTED_MODULE_2__.withWPDashboardWidgetComponentProps),
/* harmony export */   withWidgetComponentProps: () => (/* reexport safe */ _get_widget_component_props__WEBPACK_IMPORTED_MODULE_2__.withWidgetComponentProps)
/* harmony export */ });
/* harmony import */ var _get_widget_layout__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./get-widget-layout */ "./js/googlesitekit/widgets/util/get-widget-layout.js");
/* harmony import */ var _combine_widgets__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./combine-widgets */ "./js/googlesitekit/widgets/util/combine-widgets.js");
/* harmony import */ var _get_widget_component_props__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./get-widget-component-props */ "./js/googlesitekit/widgets/util/get-widget-component-props.js");
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./constants */ "./js/googlesitekit/widgets/util/constants.js");
/* harmony import */ var _widget_modules__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./widget-modules */ "./js/googlesitekit/widgets/util/widget-modules.js");
/* harmony import */ var _is_inactive_widget_state__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./is-inactive-widget-state */ "./js/googlesitekit/widgets/util/is-inactive-widget-state.js");
/**
 * Widgets API utilities.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */








/***/ }),

/***/ "./js/googlesitekit/widgets/util/is-inactive-widget-state.js":
/*!*******************************************************************!*\
  !*** ./js/googlesitekit/widgets/util/is-inactive-widget-state.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   isInactiveWidgetState: () => (/* binding */ isInactiveWidgetState)
/* harmony export */ });
/* harmony import */ var _js_components_Null__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @/js/components/Null */ "./js/components/Null.js");
/**
 * Is inactive widget utility.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Internal dependencies
 */


/**
 * Combines consecutive widgets with similar states within the same row.
 *
 * @since 1.28.0
 *
 * @param {Object|null} widgetState Widget state (either an object with `Component` and `metadata`, or `null`).
 * @return {boolean} True if widget is inactive, otherwise false.
 */
function isInactiveWidgetState(widgetState) {
  return !!widgetState && widgetState.Component === _js_components_Null__WEBPACK_IMPORTED_MODULE_0__["default"];
}

/***/ }),

/***/ "./js/googlesitekit/widgets/util/widget-modules.js":
/*!*********************************************************!*\
  !*** ./js/googlesitekit/widgets/util/widget-modules.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   normalizeWidgetModules: () => (/* binding */ normalizeWidgetModules)
/* harmony export */ });
/**
 * Widget's modules utility.
 *
 * Site Kit by Google, Copyright 2022 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Normalizes widget's modules by converting it to an array and filtering out all non-string values.
 *
 * @since 1.71.0
 *
 * @param {string|Array.<string>} modules Widget's mdoules.
 * @return {Array.<string>} Widget's modules list.
 */
function normalizeWidgetModules(modules) {
  return (Array.isArray(modules) ? modules : [modules]).filter(module => typeof module === 'string' && module.length > 0);
}

/***/ }),

/***/ "./js/hooks/useActivateModuleCallback.js":
/*!***********************************************!*\
  !*** ./js/hooks/useActivateModuleCallback.js ***!
  \***********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ useActivateModuleCallback)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/googlesitekit/datastore/site/constants */ "./js/googlesitekit/datastore/site/constants.js");
/* harmony import */ var _js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/googlesitekit/datastore/user/constants */ "./js/googlesitekit/datastore/user/constants.js");
/* harmony import */ var _js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/googlesitekit/modules/datastore/constants */ "./js/googlesitekit/modules/datastore/constants.js");
/* harmony import */ var _js_googlesitekit_datastore_location_constants__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/googlesitekit/datastore/location/constants */ "./js/googlesitekit/datastore/location/constants.js");
/* harmony import */ var _js_googlesitekit_api_cache__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/googlesitekit/api/cache */ "./js/googlesitekit/api/cache.js");
/* harmony import */ var _js_util_tracking__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @/js/util/tracking */ "./js/util/tracking/index.js");
/* harmony import */ var _useViewContext__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./useViewContext */ "./js/hooks/useViewContext.js");
/**
 * `useActivateModuleCallback` hook.
 *
 * Site Kit by Google, Copyright 2022 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */









/**
 * Returns a callback to activate a module. If the call to activate the module is successful, navigate to the reauthentication URL.
 * Returns null if the module doesn't exist or the user can't manage options.
 *
 * @since 1.70.0
 *
 * @param {string} moduleSlug Module slug.
 * @return {Function|null} Callback to activate module, null if the module doesn't exist or the user can't manage options.
 */
function useActivateModuleCallback(moduleSlug) {
  const viewContext = (0,_useViewContext__WEBPACK_IMPORTED_MODULE_7__["default"])();
  const module = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useSelect)(select => select(_js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_MODULES).getModule(moduleSlug));
  const canManageOptions = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useSelect)(select => select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_2__.CORE_USER).hasCapability(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_2__.PERMISSION_MANAGE_OPTIONS));
  const {
    activateModule
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useDispatch)(_js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_MODULES);
  const {
    navigateTo
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useDispatch)(_js_googlesitekit_datastore_location_constants__WEBPACK_IMPORTED_MODULE_4__.CORE_LOCATION);
  const {
    setInternalServerError
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useDispatch)(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_1__.CORE_SITE);
  const activateModuleCallback = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_8__.useCallback)(async () => {
    const {
      error,
      response
    } = await activateModule(moduleSlug);
    if (!error) {
      await (0,_js_util_tracking__WEBPACK_IMPORTED_MODULE_6__.trackEvent)(`${viewContext}_widget-activation-cta`, 'activate_module', moduleSlug);
      await (0,_js_googlesitekit_api_cache__WEBPACK_IMPORTED_MODULE_5__.setItem)('module_setup', moduleSlug, {
        ttl: 300
      });
      navigateTo(response.moduleReauthURL);
    } else {
      setInternalServerError({
        id: `${moduleSlug}-setup-error`,
        description: error.message
      });
    }
  }, [activateModule, moduleSlug, navigateTo, setInternalServerError, viewContext]);
  if (!module?.name || !canManageOptions) {
    return null;
  }
  return activateModuleCallback;
}

/***/ }),

/***/ "./js/hooks/useBreakpoint.js":
/*!***********************************!*\
  !*** ./js/hooks/useBreakpoint.js ***!
  \***********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   BREAKPOINT_DESKTOP: () => (/* binding */ BREAKPOINT_DESKTOP),
/* harmony export */   BREAKPOINT_SMALL: () => (/* binding */ BREAKPOINT_SMALL),
/* harmony export */   BREAKPOINT_TABLET: () => (/* binding */ BREAKPOINT_TABLET),
/* harmony export */   BREAKPOINT_XLARGE: () => (/* binding */ BREAKPOINT_XLARGE),
/* harmony export */   useBreakpoint: () => (/* binding */ useBreakpoint)
/* harmony export */ });
/* harmony import */ var _useWindowSize__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./useWindowSize */ "./js/hooks/useWindowSize.js");
/**
 * `useBreakpoint` hook.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


const BREAKPOINT_XLARGE = 'xlarge';
const BREAKPOINT_DESKTOP = 'desktop';
const BREAKPOINT_TABLET = 'tablet';
const BREAKPOINT_SMALL = 'small';

/**
 * Retrieves the current breakpoint.
 *
 * @since 1.29.0
 *
 * @return {string} The current breakpoint according to the window size.
 */
function useBreakpoint() {
  const onlyWidth = (0,_useWindowSize__WEBPACK_IMPORTED_MODULE_0__.useWindowWidth)();
  if (onlyWidth > 1280) {
    return BREAKPOINT_XLARGE;
  }
  if (onlyWidth > 960) {
    return BREAKPOINT_DESKTOP;
  }
  if (onlyWidth > 600) {
    return BREAKPOINT_TABLET;
  }
  return BREAKPOINT_SMALL;
}

/***/ }),

/***/ "./js/hooks/useCompleteModuleActivationCallback.js":
/*!*********************************************************!*\
  !*** ./js/hooks/useCompleteModuleActivationCallback.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ useCompleteModuleActivationCallback)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/googlesitekit/datastore/user/constants */ "./js/googlesitekit/datastore/user/constants.js");
/* harmony import */ var _js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/googlesitekit/modules/datastore/constants */ "./js/googlesitekit/modules/datastore/constants.js");
/* harmony import */ var _js_googlesitekit_datastore_location_constants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/googlesitekit/datastore/location/constants */ "./js/googlesitekit/datastore/location/constants.js");
/**
 * `useCompleteModuleActivationCallback` hook.
 *
 * Site Kit by Google, Copyright 2022 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */





/**
 * Returns a callback to navigate users to the module's authentication URL.
 *
 * Returns null if the module doesn't exist or the user can't manage options.
 *
 * @since 1.73.0
 *
 * @param {string} moduleSlug Module slug.
 * @return {Function|null} Callback that navigates to a module's reauth URL, null if the module doesn't exist or the user can't manage options.
 */
function useCompleteModuleActivationCallback(moduleSlug) {
  const canManageOptions = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useSelect)(select => select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_1__.CORE_USER).hasCapability(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_1__.PERMISSION_MANAGE_OPTIONS));
  const moduleStoreName = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useSelect)(select => select(_js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_2__.CORE_MODULES).getModuleStoreName(moduleSlug));
  const adminReauthURL = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useSelect)(select => select(moduleStoreName)?.getAdminReauthURL());
  const {
    navigateTo
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useDispatch)(_js_googlesitekit_datastore_location_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_LOCATION);
  const completeModuleActivationCallback = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_4__.useCallback)(() => navigateTo(adminReauthURL), [adminReauthURL, navigateTo]);
  if (!adminReauthURL || !canManageOptions) {
    return null;
  }
  return completeModuleActivationCallback;
}

/***/ }),

/***/ "./js/hooks/useDebounce.js":
/*!*********************************!*\
  !*** ./js/hooks/useDebounce.js ***!
  \*********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   useDebounce: () => (/* binding */ useDebounce)
/* harmony export */ });
/* harmony import */ var use_memo_one__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! use-memo-one */ "../node_modules/use-memo-one/dist/use-memo-one.esm.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! lodash */ "../node_modules/lodash/lodash.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/**
 * `useDebounce` hook, from @wordpress/compose.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// @TODO When we upgrade React to 16.4, we can also upgrade @wordpress/compose, and then this file can be removed.

/**
 * External dependencies
 */



/**
 * WordPress dependencies
 */


/**
 * Debounces a function with Lodash's `debounce`.
 *
 * A new debounced function will be returned and any scheduled calls
 * cancelled if any of the arguments change, including the function to debounce,
 * so please wrap functions created on render in components in `useCallback`.
 *
 * @since 1.26.0
 *
 * @param {...any} args Arguments passed to Lodash's `debounce`.
 * @return {Function} Debounced function.
 */
function useDebounce(...args) {
  const debounced = (0,use_memo_one__WEBPACK_IMPORTED_MODULE_1__.useMemoOne)(() => (0,lodash__WEBPACK_IMPORTED_MODULE_0__.debounce)(...args), args);
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useEffect)(() => () => debounced.cancel(), [debounced]);
  return debounced;
}

/***/ }),

/***/ "./js/hooks/useFormValue.js":
/*!**********************************!*\
  !*** ./js/hooks/useFormValue.js ***!
  \**********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ useFormValue)
/* harmony export */ });
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/data */ "../node_modules/@wordpress/data/build-module/components/use-select/index.js");
/* harmony import */ var _js_googlesitekit_datastore_forms_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @/js/googlesitekit/datastore/forms/constants */ "./js/googlesitekit/datastore/forms/constants.js");
/**
 * Form value hook.
 *
 * Site Kit by Google, Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */


/**
 * Returns the value of a form field.
 *
 * @since 1.160.0
 *
 * @param {string} formName The name of the form.
 * @param {string} key      The key of the form field.
 * @return {string|number|boolean|Array|Object|undefined} The value of the form field, or the default value if provided.
 */
function useFormValue(formName, key) {
  return (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_1__["default"])(select => {
    const {
      getValue
    } = select(_js_googlesitekit_datastore_forms_constants__WEBPACK_IMPORTED_MODULE_0__.CORE_FORMS);
    return getValue(formName, key);
  }, [formName, key]);
}

/***/ }),

/***/ "./js/hooks/useInView.js":
/*!*******************************!*\
  !*** ./js/hooks/useInView.js ***!
  \*******************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   useInView: () => (/* binding */ useInView)
/* harmony export */ });
/* harmony import */ var react_use__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! react-use */ "../node_modules/react-use/esm/useUpdateEffect.js");
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/data */ "../node_modules/@wordpress/data/build-module/components/use-select/index.js");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _js_components_InViewProvider_InViewContext__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @/js/components/InViewProvider/InViewContext */ "./js/components/InViewProvider/InViewContext.js");
/* harmony import */ var _js_googlesitekit_datastore_ui_constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/googlesitekit/datastore/ui/constants */ "./js/googlesitekit/datastore/ui/constants.js");
/**
 * In viewport hook.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */
// Imported directly from `@wordpress/data` to avoid circular
// dependency/imports.



/**
 * Internal dependencies
 */



/**
 * Returns whether the nearest parent component tracking viewport detection is in-view.
 *
 * @since 1.46.0
 *
 * @param {Object}  options        Optional. Options to pass to the request.
 * @param {boolean} options.sticky Set to `true` to always return `true` after the nearest viewport-detecting component has been in-view once. Defaults to `false`.
 * @return {boolean} `true` if the nearest parent component is in-view (or if `sticky` is `true`, if the component has ever been in-view); `false` if not..
 */
function useInView({
  sticky = false
} = {}) {
  const inView = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useContext)(_js_components_InViewProvider_InViewContext__WEBPACK_IMPORTED_MODULE_0__["default"]);
  const [hasBeenInViewOnce, setHasBeenInViewOnce] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(false);
  const resetCount = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_3__["default"])(select => select(_js_googlesitekit_datastore_ui_constants__WEBPACK_IMPORTED_MODULE_1__.CORE_UI).getInViewResetCount());
  const forceInView = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_3__["default"])(select => select(_js_googlesitekit_datastore_ui_constants__WEBPACK_IMPORTED_MODULE_1__.CORE_UI).getValue('forceInView'));
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useEffect)(() => {
    if (inView.value && !hasBeenInViewOnce) {
      setHasBeenInViewOnce(true);
    }
  }, [hasBeenInViewOnce, inView, setHasBeenInViewOnce]);
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useEffect)(() => {
    if (forceInView) {
      setHasBeenInViewOnce(true);
    }
  }, [forceInView]);
  (0,react_use__WEBPACK_IMPORTED_MODULE_4__["default"])(() => {
    setHasBeenInViewOnce(false);
  }, [resetCount]);
  if (sticky && hasBeenInViewOnce) {
    return true;
  }
  return !!inView.value;
}

/***/ }),

/***/ "./js/hooks/useInViewSelect.js":
/*!*************************************!*\
  !*** ./js/hooks/useInViewSelect.js ***!
  \*************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   useInViewSelect: () => (/* binding */ useInViewSelect)
/* harmony export */ });
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/data */ "../node_modules/@wordpress/data/build-module/components/use-select/index.js");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _useInView__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./useInView */ "./js/hooks/useInView.js");
/**
 * Select when in-view hook.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */


/**
 * Returns undefined when the component is not in view.
 *
 * @since 1.131.0 Moved this inline function outside the hook and assigned it a stable function name.
 *
 * @return {undefined} Always returns undefined.
 */
function notInViewCallback() {
  return undefined;
}

/**
 * Returns whether the nearest parent component tracking viewport detection is in-view.
 *
 * @since 1.49.0
 * @private
 *
 * @param {Function} mapSelect Selector to call when this selector's component is considered in-view.
 * @param {Array}    deps      Deps passed to `useInViewSelect`'s `deps` argument.
 * @return {*} The result of the selector if in-view; `undefined` if not in-view.
 */
function useInViewSelect(mapSelect, deps) {
  const isInView = (0,_useInView__WEBPACK_IMPORTED_MODULE_0__.useInView)({
    sticky: true
  });
  const latestSelectorResult = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useRef)();

  // These are "pass-through" dependencies from the parent hook,
  // and the parent should catch any hook rule violations.
  // eslint-disable-next-line react-hooks/exhaustive-deps
  const mapSelectCallback = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useCallback)(mapSelect, deps);
  const selectorResult = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_2__["default"])(isInView ? mapSelectCallback : notInViewCallback);
  if (isInView) {
    latestSelectorResult.current = selectorResult;
  }
  return latestSelectorResult.current;
}

/***/ }),

/***/ "./js/hooks/useViewContext.js":
/*!************************************!*\
  !*** ./js/hooks/useViewContext.js ***!
  \************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _js_components_Root_ViewContextContext__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @/js/components/Root/ViewContextContext */ "./js/components/Root/ViewContextContext.js");
/**
 * `useViewContext` hook.
 *
 * Site Kit by Google, Copyright 2022 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */



/**
 * Returns the current Site Kit viewing context, eg. "dashboard",
 * "entity dashboard", "view-only dashboard", etc.
 *
 * @since 1.74.0
 *
 * @return {string} The current "viewing context" value for the plugin.
 */
function useViewContext() {
  const viewContext = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useContext)(_js_components_Root_ViewContextContext__WEBPACK_IMPORTED_MODULE_0__["default"]);
  return viewContext;
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (useViewContext);

/***/ }),

/***/ "./js/hooks/useViewOnly.js":
/*!*********************************!*\
  !*** ./js/hooks/useViewOnly.js ***!
  \*********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ useViewOnly)
/* harmony export */ });
/* harmony import */ var _js_googlesitekit_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @/js/googlesitekit/constants */ "./js/googlesitekit/constants.js");
/* harmony import */ var _useViewContext__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./useViewContext */ "./js/hooks/useViewContext.js");
/**
 * `useViewOnly` hook.
 *
 * Site Kit by Google, Copyright 2022 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Internal dependencies
 */



/**
 * Determines if the current view context is a "view only" dashboard context.
 *
 * @since 1.72.0
 *
 * @return {boolean} True if current context is a view-only dashboard context, false otherwise.
 */
function useViewOnly() {
  const viewContext = (0,_useViewContext__WEBPACK_IMPORTED_MODULE_1__["default"])();
  return _js_googlesitekit_constants__WEBPACK_IMPORTED_MODULE_0__.SITE_KIT_VIEW_ONLY_CONTEXTS.includes(viewContext);
}

/***/ }),

/***/ "./js/hooks/useWindowSize.js":
/*!***********************************!*\
  !*** ./js/hooks/useWindowSize.js ***!
  \***********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   useWindowHeight: () => (/* binding */ useWindowHeight),
/* harmony export */   useWindowSize: () => (/* binding */ useWindowSize),
/* harmony export */   useWindowWidth: () => (/* binding */ useWindowWidth)
/* harmony export */ });
/* harmony import */ var _react_hook_throttle__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @react-hook/throttle */ "../node_modules/@react-hook/throttle/dist/module/index.js");
/* harmony import */ var _react_hook_event__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @react-hook/event */ "../node_modules/@react-hook/event/dist/module/index.js");
/**
 * `useWindowSize` hook.
 *
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// Copied from https://github.com/jaredLunde/react-hook/blob/b8ac9515e26937e838a36a27001dc46c7f46a390/packages/window-size/throttled/src/index.tsx
// Modified to use global.innerWidth and global.innerHeight instead of document.documentElement.clientWidth and document.documentElement.clientHeight.

/**
 * External dependencies
 */


const emptyObj = {};
const win = typeof __webpack_require__.g === 'undefined' ? null : __webpack_require__.g;
function getSize() {
  return [__webpack_require__.g.innerWidth, __webpack_require__.g.innerHeight];
}
function useWindowSize(options = emptyObj) {
  const {
    fps,
    leading,
    initialWidth = 0,
    initialHeight = 0
  } = options;
  const [size, setThrottledSize] = (0,_react_hook_throttle__WEBPACK_IMPORTED_MODULE_0__.useThrottle)(/* istanbul ignore next */
  typeof document === 'undefined' ? [initialWidth, initialHeight] : getSize, fps, leading);
  function setSize() {
    return setThrottledSize(getSize);
  }
  (0,_react_hook_event__WEBPACK_IMPORTED_MODULE_1__["default"])(win, 'resize', setSize);
  (0,_react_hook_event__WEBPACK_IMPORTED_MODULE_1__["default"])(win, 'orientationchange', setSize);
  return size;
}
function useWindowHeight(options) {
  return useWindowSize(options)[1];
}
function useWindowWidth(options) {
  return useWindowSize(options)[0];
}

/***/ }),

/***/ "./js/material-components/index.js":
/*!*****************************************!*\
  !*** ./js/material-components/index.js ***!
  \*****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Cell: () => (/* reexport safe */ _layout__WEBPACK_IMPORTED_MODULE_1__.Cell),
/* harmony export */   Dialog: () => (/* reexport default from dynamic */ _material_react_dialog__WEBPACK_IMPORTED_MODULE_0___default.a),
/* harmony export */   DialogContent: () => (/* reexport safe */ _material_react_dialog__WEBPACK_IMPORTED_MODULE_0__.DialogContent),
/* harmony export */   DialogFooter: () => (/* reexport safe */ _material_react_dialog__WEBPACK_IMPORTED_MODULE_0__.DialogFooter),
/* harmony export */   Grid: () => (/* reexport safe */ _layout__WEBPACK_IMPORTED_MODULE_1__.Grid),
/* harmony export */   MDCCheckbox: () => (/* reexport safe */ _material_checkbox__WEBPACK_IMPORTED_MODULE_7__.MDCCheckbox),
/* harmony export */   MDCDialog: () => (/* reexport safe */ _material_dialog__WEBPACK_IMPORTED_MODULE_6__.MDCDialog),
/* harmony export */   MDCFormField: () => (/* reexport safe */ _material_form_field__WEBPACK_IMPORTED_MODULE_3__.MDCFormField),
/* harmony export */   MDCMenu: () => (/* reexport safe */ _material_menu__WEBPACK_IMPORTED_MODULE_8__.MDCMenu),
/* harmony export */   MDCRadio: () => (/* reexport safe */ _material_radio__WEBPACK_IMPORTED_MODULE_4__.MDCRadio),
/* harmony export */   MDCRipple: () => (/* reexport safe */ _material_ripple__WEBPACK_IMPORTED_MODULE_2__.MDCRipple),
/* harmony export */   MDCSwitch: () => (/* reexport safe */ _material_switch__WEBPACK_IMPORTED_MODULE_5__.MDCSwitch),
/* harmony export */   Row: () => (/* reexport safe */ _layout__WEBPACK_IMPORTED_MODULE_1__.Row)
/* harmony export */ });
/* harmony import */ var _material_ripple__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @material/ripple */ "../node_modules/@material/ripple/component.js");
/* harmony import */ var _material_form_field__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @material/form-field */ "../node_modules/@material/form-field/component.js");
/* harmony import */ var _material_radio__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @material/radio */ "../node_modules/@material/radio/component.js");
/* harmony import */ var _material_switch__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @material/switch */ "../node_modules/@material/switch/component.js");
/* harmony import */ var _material_dialog__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @material/dialog */ "../node_modules/@material/dialog/component.js");
/* harmony import */ var _material_checkbox__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @material/checkbox */ "../node_modules/@material/checkbox/component.js");
/* harmony import */ var _material_menu__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @material/menu */ "../node_modules/@material/menu/component.js");
/* harmony import */ var _material_react_dialog__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @material/react-dialog */ "../node_modules/@material/react-dialog/dist/index.js");
/* harmony import */ var _material_react_dialog__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_material_react_dialog__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _layout__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./layout */ "./js/material-components/layout/index.js");
/**
 * Material components.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */











/***/ }),

/***/ "./js/material-components/layout/Cell.js":
/*!***********************************************!*\
  !*** ./js/material-components/layout/Cell.js ***!
  \***********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Cell)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Material UI > Layout > Cell component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



function Cell(props) {
  const {
    className,
    alignTop,
    alignMiddle,
    alignBottom,
    alignRight,
    alignLeft,
    smAlignRight,
    mdAlignRight,
    lgAlignRight,
    smSize,
    smStart,
    smOrder,
    mdSize,
    mdStart,
    mdOrder,
    lgSize,
    lgStart,
    lgOrder,
    size,
    children,
    ...otherProps
  } = props;
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", {
    ...otherProps,
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()(className, 'mdc-layout-grid__cell', {
      'mdc-layout-grid__cell--align-top': alignTop,
      'mdc-layout-grid__cell--align-middle': alignMiddle,
      'mdc-layout-grid__cell--align-bottom': alignBottom,
      'mdc-layout-grid__cell--align-right': alignRight,
      'mdc-layout-grid__cell--align-left': alignLeft,
      'mdc-layout-grid__cell--align-right-phone': smAlignRight,
      'mdc-layout-grid__cell--align-right-tablet': mdAlignRight,
      'mdc-layout-grid__cell--align-right-desktop': lgAlignRight,
      [`mdc-layout-grid__cell--span-${size}`]: 12 >= size && size > 0,
      [`mdc-layout-grid__cell--span-${lgSize}-desktop`]: 12 >= lgSize && lgSize > 0,
      [`mdc-layout-grid__cell--start-${lgStart}-desktop`]: 12 >= lgStart && lgStart > 0,
      [`mdc-layout-grid__cell--order-${lgOrder}-desktop`]: 12 >= lgOrder && lgOrder > 0,
      [`mdc-layout-grid__cell--span-${mdSize}-tablet`]: 8 >= mdSize && mdSize > 0,
      [`mdc-layout-grid__cell--start-${mdStart}-tablet`]: 8 >= mdStart && mdStart > 0,
      [`mdc-layout-grid__cell--order-${mdOrder}-tablet`]: 8 >= mdOrder && mdOrder > 0,
      [`mdc-layout-grid__cell--span-${smSize}-phone`]: 4 >= smSize && smSize > 0,
      [`mdc-layout-grid__cell--start-${smStart}-phone`]: 4 >= smStart && smStart > 0,
      [`mdc-layout-grid__cell--order-${smOrder}-phone`]: 4 >= smOrder && smOrder > 0
    }),
    children: children
  });
}
Cell.propTypes = {
  smSize: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().number),
  smStart: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().number),
  smOrder: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().number),
  mdSize: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().number),
  mdStart: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().number),
  mdOrder: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().number),
  lgSize: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().number),
  lgStart: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().number),
  lgOrder: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().number),
  size: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().number),
  alignTop: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().bool),
  alignMiddle: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().bool),
  alignBottom: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().bool),
  alignRight: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().bool),
  alignLeft: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().bool),
  smAlignRight: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().bool),
  mdAlignRight: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().bool),
  lgAlignRight: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().bool),
  className: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().string),
  children: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().node)
};
Cell.defaultProps = {
  className: '',
  size: 0,
  smSize: 0,
  smStart: 0,
  smOrder: 0,
  mdSize: 0,
  mdStart: 0,
  mdOrder: 0,
  lgSize: 0,
  lgStart: 0,
  lgOrder: 0
};

/***/ }),

/***/ "./js/material-components/layout/Grid.js":
/*!***********************************************!*\
  !*** ./js/material-components/layout/Grid.js ***!
  \***********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Material UI > Layout > Grid component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * WordPress dependencies
 */


const Grid = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.forwardRef)(({
  alignLeft,
  fill,
  className,
  children,
  collapsed,
  ...otherProps
}, ref) => {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", {
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('mdc-layout-grid', className, {
      'mdc-layout-grid--align-left': alignLeft,
      'mdc-layout-grid--collapsed': collapsed,
      'mdc-layout-grid--fill': fill
    }),
    ...otherProps,
    ref: ref,
    children: children
  });
});
Grid.displayName = 'Grid';
Grid.propTypes = {
  alignLeft: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().bool),
  fill: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().bool),
  className: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  collapsed: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().bool),
  children: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().node)
};
Grid.defaultProps = {
  className: ''
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Grid);

/***/ }),

/***/ "./js/material-components/layout/Row.js":
/*!**********************************************!*\
  !*** ./js/material-components/layout/Row.js ***!
  \**********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Material UI > Layout > Row component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * WordPress dependencies
 */


const Row = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.forwardRef)(({
  className,
  children,
  ...otherProps
}, ref) => {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", {
    ref: ref,
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('mdc-layout-grid__inner', className),
    ...otherProps,
    children: children
  });
});
Row.displayName = 'Row';
Row.propTypes = {
  className: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  children: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().node)
};
Row.defaultProps = {
  className: ''
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Row);

/***/ }),

/***/ "./js/material-components/layout/index.js":
/*!************************************************!*\
  !*** ./js/material-components/layout/index.js ***!
  \************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Cell: () => (/* reexport safe */ _Cell__WEBPACK_IMPORTED_MODULE_0__["default"]),
/* harmony export */   Grid: () => (/* reexport safe */ _Grid__WEBPACK_IMPORTED_MODULE_2__["default"]),
/* harmony export */   Row: () => (/* reexport safe */ _Row__WEBPACK_IMPORTED_MODULE_1__["default"])
/* harmony export */ });
/* harmony import */ var _Cell__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./Cell */ "./js/material-components/layout/Cell.js");
/* harmony import */ var _Row__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Row */ "./js/material-components/layout/Row.js");
/* harmony import */ var _Grid__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./Grid */ "./js/material-components/layout/Grid.js");
/**
 * Material UI > Layout components.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */





/***/ }),

/***/ "./js/modules/analytics-4/components/audience-segmentation/dashboard/AudienceAreaFooter.js":
/*!*************************************************************************************************!*\
  !*** ./js/modules/analytics-4/components/audience-segmentation/dashboard/AudienceAreaFooter.js ***!
  \*************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ AudienceAreaFooter)
/* harmony export */ });
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/googlesitekit/datastore/user/constants */ "./js/googlesitekit/datastore/user/constants.js");
/* harmony import */ var _js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/modules/analytics-4/datastore/constants */ "./js/modules/analytics-4/datastore/constants.js");
/* harmony import */ var _js_modules_analytics_4_constants__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/modules/analytics-4/constants */ "./js/modules/analytics-4/constants.js");
/* harmony import */ var _js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/googlesitekit/modules/datastore/constants */ "./js/googlesitekit/modules/datastore/constants.js");
/* harmony import */ var _js_components_SourceLink__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @/js/components/SourceLink */ "./js/components/SourceLink.js");
/* harmony import */ var _js_hooks_useViewOnly__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @/js/hooks/useViewOnly */ "./js/hooks/useViewOnly.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * AudienceAreaFooter component.
 *
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */








function AudienceAreaFooter() {
  const viewOnlyDashboard = (0,_js_hooks_useViewOnly__WEBPACK_IMPORTED_MODULE_7__["default"])();
  const dates = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_2__.CORE_USER).getDateRangeDates({
    offsetDays: _js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_3__.DATE_RANGE_OFFSET
  }));
  const sourceLinkURL = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => {
    if (viewOnlyDashboard) {
      return null;
    }
    return select(_js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_3__.MODULES_ANALYTICS_4).getServiceReportURL('audiences', {
      dates
    });
  });
  const isAnalyticsConnected = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_5__.CORE_MODULES).isModuleConnected(_js_modules_analytics_4_constants__WEBPACK_IMPORTED_MODULE_4__.MODULE_SLUG_ANALYTICS_4));
  if (!isAnalyticsConnected) {
    return null;
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(_js_components_SourceLink__WEBPACK_IMPORTED_MODULE_6__["default"], {
    className: "googlesitekit-audience-widget__source",
    name: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__._x)('Analytics', 'Service name', 'google-site-kit'),
    href: sourceLinkURL,
    external: true
  });
}

/***/ }),

/***/ "./js/modules/analytics-4/components/audience-segmentation/dashboard/AudienceErrorModal.js":
/*!*************************************************************************************************!*\
  !*** ./js/modules/analytics-4/components/audience-segmentation/dashboard/AudienceErrorModal.js ***!
  \*************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ AudienceErrorModal)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_11___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_11__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/@wordpress/element/build-module/create-interpolate-element.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _js_components_Link__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/components/Link */ "./js/components/Link.js");
/* harmony import */ var _js_components_RefocusableModalDialog__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/components/RefocusableModalDialog */ "./js/components/RefocusableModalDialog.js");
/* harmony import */ var _js_components_Portal__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/components/Portal */ "./js/components/Portal.js");
/* harmony import */ var _js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/googlesitekit/datastore/site/constants */ "./js/googlesitekit/datastore/site/constants.js");
/* harmony import */ var _js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @/js/modules/analytics-4/datastore/constants */ "./js/modules/analytics-4/datastore/constants.js");
/* harmony import */ var _js_util_errors__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @/js/util/errors */ "./js/util/errors.js");
/* harmony import */ var _js_util__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @/js/util */ "./js/util/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Audience Segmentation AudienceErrorModal component.
 *
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */









function AudienceErrorModal({
  apiErrors,
  hasOAuthError,
  inProgress,
  title,
  description,
  trackEventCategory,
  onCancel = () => {},
  onRetry = () => {}
}) {
  const errors = Array.isArray(apiErrors) ? apiErrors : [apiErrors];
  const helpLink = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_5__.CORE_SITE).getErrorTroubleshootingLinkURL({
    code: 'analytics-4_insufficient_permissions'
  }));
  const requestAccessURL = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_6__.MODULES_ANALYTICS_4).getServiceEntityAccessURL());
  const errorTroubleshootingLinkURL = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_5__.CORE_SITE).getErrorTroubleshootingLinkURL({
    code: 'access_denied'
  }));
  if (!errors.length && !hasOAuthError) {
    return null;
  }
  const hasInsufficientPermissionsError = errors.some(error => (0,_js_util_errors__WEBPACK_IMPORTED_MODULE_7__.isInsufficientPermissionsError)(error));
  function handleConfirm() {
    let action;
    if (hasOAuthError) {
      action = 'auth_error_retry';
    } else if (hasInsufficientPermissionsError) {
      action = 'insufficient_permissions_error_request_access';
    } else {
      action = 'setup_error_retry';
    }
    (0,_js_util__WEBPACK_IMPORTED_MODULE_8__.trackEvent)(trackEventCategory, action).finally(() => {
      if (!hasInsufficientPermissionsError) {
        onRetry();
      }
    });
  }
  function handleCancel() {
    let action;
    if (hasOAuthError) {
      action = 'auth_error_cancel';
    } else if (hasInsufficientPermissionsError) {
      action = 'insufficient_permissions_error_cancel';
    } else {
      action = 'setup_error_cancel';
    }
    (0,_js_util__WEBPACK_IMPORTED_MODULE_8__.trackEvent)(trackEventCategory, action).finally(onCancel);
  }
  let errorTitle, errorDescription, confirmButton, buttonLink;
  if (hasOAuthError) {
    errorTitle = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Analytics update failed', 'google-site-kit');
    errorDescription = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_10__["default"])((0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Setup was interrupted because you did not grant the necessary permissions. <HelpLink />', 'google-site-kit'), {
      HelpLink: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)(_js_components_Link__WEBPACK_IMPORTED_MODULE_2__["default"], {
        href: errorTroubleshootingLinkURL,
        external: true,
        hideExternalIndicator: true,
        children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Get help', 'google-site-kit')
      })
    });
    confirmButton = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Retry', 'google-site-kit');
  } else if (hasInsufficientPermissionsError) {
    errorTitle = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Insufficient permissions', 'google-site-kit');
    errorDescription = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_10__["default"])((0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('You’ll need to contact your administrator. Trouble getting access? <HelpLink />', 'google-site-kit'), {
      HelpLink: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)(_js_components_Link__WEBPACK_IMPORTED_MODULE_2__["default"], {
        href: helpLink,
        external: true,
        hideExternalIndicator: true,
        children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Get help', 'google-site-kit')
      })
    });
    confirmButton = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Request access', 'google-site-kit');
    buttonLink = requestAccessURL;
  } else {
    errorTitle = title || (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Failed to set up visitor groups', 'google-site-kit');
    errorDescription = description || (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Oops! Something went wrong. Retry enabling groups.', 'google-site-kit');
    confirmButton = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Retry', 'google-site-kit');
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)(_js_components_Portal__WEBPACK_IMPORTED_MODULE_4__["default"], {
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)(_js_components_RefocusableModalDialog__WEBPACK_IMPORTED_MODULE_3__["default"], {
      buttonLink: buttonLink,
      title: errorTitle,
      subtitle: errorDescription,
      handleConfirm: handleConfirm,
      confirmButton: confirmButton,
      handleCancel: handleCancel,
      onOpen: () => {
        let action;
        if (hasOAuthError) {
          action = 'auth_error';
        } else if (hasInsufficientPermissionsError) {
          action = 'insufficient_permissions_error';
        } else {
          action = 'setup_error';
        }
        (0,_js_util__WEBPACK_IMPORTED_MODULE_8__.trackEvent)(trackEventCategory, action);
      },
      onClose: onCancel,
      inProgress: inProgress,
      refocusQuerySelector: "#audience_segmentation_setup_cta-notification .googlesitekit-banner__cta",
      danger: true,
      dialogActive: true
    })
  });
}
AudienceErrorModal.propTypes = {
  apiErrors: prop_types__WEBPACK_IMPORTED_MODULE_11___default().oneOfType([prop_types__WEBPACK_IMPORTED_MODULE_11___default().arrayOf((prop_types__WEBPACK_IMPORTED_MODULE_11___default().object)), (prop_types__WEBPACK_IMPORTED_MODULE_11___default().object), (prop_types__WEBPACK_IMPORTED_MODULE_11___default().array)]),
  hasOAuthError: (prop_types__WEBPACK_IMPORTED_MODULE_11___default().bool),
  inProgress: (prop_types__WEBPACK_IMPORTED_MODULE_11___default().bool),
  title: (prop_types__WEBPACK_IMPORTED_MODULE_11___default().string),
  description: (prop_types__WEBPACK_IMPORTED_MODULE_11___default().string),
  trackEventCategory: (prop_types__WEBPACK_IMPORTED_MODULE_11___default().string),
  onCancel: (prop_types__WEBPACK_IMPORTED_MODULE_11___default().func),
  onRetry: (prop_types__WEBPACK_IMPORTED_MODULE_11___default().func)
};

/***/ }),

/***/ "./js/modules/analytics-4/components/audience-segmentation/dashboard/AudienceSegmentationErrorWidget/ErrorWidgetContent.js":
/*!*********************************************************************************************************************************!*\
  !*** ./js/modules/analytics-4/components/audience-segmentation/dashboard/AudienceSegmentationErrorWidget/ErrorWidgetContent.js ***!
  \*********************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _js_material_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/material-components */ "./js/material-components/index.js");
/* harmony import */ var _js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/hooks/useBreakpoint */ "./js/hooks/useBreakpoint.js");
/* harmony import */ var _svg_graphics_audience_segmentation_error_full_width_svg__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/svg/graphics/audience-segmentation-error-full-width.svg */ "./svg/graphics/audience-segmentation-error-full-width.svg");
/* harmony import */ var _js_util_errors__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/util/errors */ "./js/util/errors.js");
/* harmony import */ var _js_components_Typography__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/components/Typography */ "./js/components/Typography/index.js");
/* harmony import */ var _ErrorWidgetDetails__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./ErrorWidgetDetails */ "./js/modules/analytics-4/components/audience-segmentation/dashboard/AudienceSegmentationErrorWidget/ErrorWidgetDetails.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * ErrorWidgetContent component.
 *
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */







const ErrorWidgetContent = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_8__.forwardRef)(({
  Widget,
  errors,
  onRetry,
  onRequestAccess,
  showRetryButton,
  failedAudiences
}, ref) => {
  const breakpoint = (0,_js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_2__.useBreakpoint)();
  const isMobileBreakpoint = breakpoint === _js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_2__.BREAKPOINT_SMALL;
  const isTabletBreakpoint = breakpoint === _js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_2__.BREAKPOINT_TABLET;
  const hasInsufficientPermissionsError = errors.some(_js_util_errors__WEBPACK_IMPORTED_MODULE_4__.isInsufficientPermissionsError);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(Widget, {
    ref: ref,
    className: "googlesitekit-audience-segmentation-error-widget",
    noPadding: true,
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_js_material_components__WEBPACK_IMPORTED_MODULE_1__.Grid, {
      className: "googlesitekit-audience-segmentation-error__widget-primary-cell",
      collapsed: true,
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsxs)(_js_material_components__WEBPACK_IMPORTED_MODULE_1__.Row, {
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsxs)(_js_material_components__WEBPACK_IMPORTED_MODULE_1__.Cell, {
          smSize: 6,
          mdSize: 8,
          lgSize: 7,
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_js_components_Typography__WEBPACK_IMPORTED_MODULE_5__["default"], {
            as: "h3",
            type: "title",
            size: "large",
            children: hasInsufficientPermissionsError ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Insufficient permissions', 'google-site-kit') : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Your visitor groups data loading failed', 'google-site-kit')
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)("div", {
            className: "googlesitekit-widget-audience-segmentation-error__actions",
            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_ErrorWidgetDetails__WEBPACK_IMPORTED_MODULE_6__["default"], {
              failedAudiences: failedAudiences,
              showRetryButton: showRetryButton,
              onRetry: onRetry,
              onRequestAccess: onRequestAccess,
              errors: errors,
              hasInsufficientPermissionsError: hasInsufficientPermissionsError
            })
          })]
        }), !isMobileBreakpoint && !isTabletBreakpoint && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_js_material_components__WEBPACK_IMPORTED_MODULE_1__.Cell, {
          className: "googlesitekit-widget-audience-segmentation-error__svg-wrapper",
          smSize: 6,
          mdSize: 3,
          lgSize: 5,
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_svg_graphics_audience_segmentation_error_full_width_svg__WEBPACK_IMPORTED_MODULE_3__["default"], {
            width: "233px"
          })
        }), isTabletBreakpoint && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_js_material_components__WEBPACK_IMPORTED_MODULE_1__.Cell, {
          className: "googlesitekit-widget-audience-segmentation-error__svg-wrapper",
          mdSize: 8,
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_svg_graphics_audience_segmentation_error_full_width_svg__WEBPACK_IMPORTED_MODULE_3__["default"], {
            width: "233px"
          })
        }), isMobileBreakpoint && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_js_material_components__WEBPACK_IMPORTED_MODULE_1__.Cell, {
          className: "googlesitekit-widget-audience-segmentation-error__svg-wrapper",
          smSize: 8,
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_svg_graphics_audience_segmentation_error_full_width_svg__WEBPACK_IMPORTED_MODULE_3__["default"], {
            width: "233px"
          })
        })]
      })
    })
  });
});
ErrorWidgetContent.propTypes = {
  Widget: (prop_types__WEBPACK_IMPORTED_MODULE_9___default().elementType).isRequired,
  errors: prop_types__WEBPACK_IMPORTED_MODULE_9___default().arrayOf((prop_types__WEBPACK_IMPORTED_MODULE_9___default().object)).isRequired,
  onRetry: (prop_types__WEBPACK_IMPORTED_MODULE_9___default().func).isRequired,
  onRequestAccess: (prop_types__WEBPACK_IMPORTED_MODULE_9___default().func).isRequired,
  showRetryButton: (prop_types__WEBPACK_IMPORTED_MODULE_9___default().bool),
  failedAudiences: prop_types__WEBPACK_IMPORTED_MODULE_9___default().arrayOf((prop_types__WEBPACK_IMPORTED_MODULE_9___default().string))
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ErrorWidgetContent);

/***/ }),

/***/ "./js/modules/analytics-4/components/audience-segmentation/dashboard/AudienceSegmentationErrorWidget/ErrorWidgetDetails.js":
/*!*********************************************************************************************************************************!*\
  !*** ./js/modules/analytics-4/components/audience-segmentation/dashboard/AudienceSegmentationErrorWidget/ErrorWidgetDetails.js ***!
  \*********************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ ErrorWidgetDetails)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _js_components_Typography_P__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/components/Typography/P */ "./js/components/Typography/P.js");
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! googlesitekit-components */ "googlesitekit-components");
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_components__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _js_components_ReportErrorActions__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/components/ReportErrorActions */ "./js/components/ReportErrorActions.js");
/* harmony import */ var _js_modules_analytics_4_components_audience_segmentation_dashboard_GetHelpLink__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/modules/analytics-4/components/audience-segmentation/dashboard/GetHelpLink */ "./js/modules/analytics-4/components/audience-segmentation/dashboard/GetHelpLink.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * ErrorWidgetDetails component.
 *
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */





function ErrorWidgetDetails({
  failedAudiences,
  showRetryButton,
  onRetry,
  onRequestAccess,
  errors,
  hasInsufficientPermissionsError
}) {
  if (failedAudiences?.length) {
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)("div", {
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_js_components_Typography_P__WEBPACK_IMPORTED_MODULE_1__["default"], {
        children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Failed to create the following audiences:', 'google-site-kit')
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("ul", {
        className: "googlesitekit-widget-audience-segmentation-error__failed-audiences",
        children: failedAudiences.map(audience => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("li", {
          children: audience
        }, audience))
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_2__.Button, {
        onClick: onRetry,
        danger: true,
        children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Retry', 'google-site-kit')
      })]
    });
  }
  if (showRetryButton && onRetry) {
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_2__.Button, {
      onClick: onRetry,
      danger: true,
      children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Retry', 'google-site-kit')
    });
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_js_components_ReportErrorActions__WEBPACK_IMPORTED_MODULE_3__["default"], {
    moduleSlug: "analytics-4",
    error: errors,
    GetHelpLink: hasInsufficientPermissionsError ? _js_modules_analytics_4_components_audience_segmentation_dashboard_GetHelpLink__WEBPACK_IMPORTED_MODULE_4__["default"] : undefined,
    hideGetHelpLink: !hasInsufficientPermissionsError,
    buttonVariant: "danger",
    getHelpClassName: "googlesitekit-error-retry-text",
    onRetry: onRetry,
    onRequestAccess: onRequestAccess
  });
}
ErrorWidgetDetails.propTypes = {
  errors: prop_types__WEBPACK_IMPORTED_MODULE_6___default().arrayOf((prop_types__WEBPACK_IMPORTED_MODULE_6___default().object)).isRequired,
  onRetry: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().func).isRequired,
  onRequestAccess: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().func).isRequired,
  showRetryButton: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().bool),
  failedAudiences: prop_types__WEBPACK_IMPORTED_MODULE_6___default().arrayOf((prop_types__WEBPACK_IMPORTED_MODULE_6___default().string)),
  hasInsufficientPermissionsError: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().bool)
};

/***/ }),

/***/ "./js/modules/analytics-4/components/audience-segmentation/dashboard/AudienceSegmentationErrorWidget/index.js":
/*!********************************************************************************************************************!*\
  !*** ./js/modules/analytics-4/components/audience-segmentation/dashboard/AudienceSegmentationErrorWidget/index.js ***!
  \********************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! lodash */ "../node_modules/lodash/lodash.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_13___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_13__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _js_util_when_active__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/util/when-active */ "./js/util/when-active.js");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _js_util_errors__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/util/errors */ "./js/util/errors.js");
/* harmony import */ var _js_googlesitekit_datastore_ui_constants__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/googlesitekit/datastore/ui/constants */ "./js/googlesitekit/datastore/ui/constants.js");
/* harmony import */ var _js_modules_analytics_4_components_audience_segmentation_dashboard_InfoNoticeWidget_constants__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/modules/analytics-4/components/audience-segmentation/dashboard/InfoNoticeWidget/constants */ "./js/modules/analytics-4/components/audience-segmentation/dashboard/InfoNoticeWidget/constants.js");
/* harmony import */ var _ErrorWidgetContent__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./ErrorWidgetContent */ "./js/modules/analytics-4/components/audience-segmentation/dashboard/AudienceSegmentationErrorWidget/ErrorWidgetContent.js");
/* harmony import */ var _js_util_withIntersectionObserver__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @/js/util/withIntersectionObserver */ "./js/util/withIntersectionObserver.js");
/* harmony import */ var _js_util__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @/js/util */ "./js/util/index.js");
/* harmony import */ var _js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @/js/hooks/useViewContext */ "./js/hooks/useViewContext.js");
/* harmony import */ var _js_modules_analytics_4_constants__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @/js/modules/analytics-4/constants */ "./js/modules/analytics-4/constants.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * AudienceSegmentationErrorWidget component.
 *
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */











const ErrorWidgetContentWithIntersectionObserver = (0,_js_util_withIntersectionObserver__WEBPACK_IMPORTED_MODULE_7__["default"])(_ErrorWidgetContent__WEBPACK_IMPORTED_MODULE_6__["default"]);
function AudienceSegmentationErrorWidget({
  Widget,
  errors,
  onRetry,
  showRetryButton,
  failedAudiences
}) {
  const viewContext = (0,_js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_9__["default"])();
  const {
    setValue
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.useDispatch)(_js_googlesitekit_datastore_ui_constants__WEBPACK_IMPORTED_MODULE_4__.CORE_UI);
  const errorsArray = errors ? (0,lodash__WEBPACK_IMPORTED_MODULE_0__.castArray)(errors) : [];
  const hasInsufficientPermissionsError = errorsArray.some(_js_util_errors__WEBPACK_IMPORTED_MODULE_3__.isInsufficientPermissionsError);
  function handleRetry() {
    (0,_js_util__WEBPACK_IMPORTED_MODULE_8__.trackEvent)(`${viewContext}_audiences-all-tiles`, 'data_loading_error_retry').finally(() => {
      setValue(_js_modules_analytics_4_components_audience_segmentation_dashboard_InfoNoticeWidget_constants__WEBPACK_IMPORTED_MODULE_5__.AUDIENCE_INFO_NOTICE_HIDE_UI, false);
      onRetry?.();
    });
  }
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_12__.useEffect)(() => {
    // Set UI key to hide the info notice.
    setValue(_js_modules_analytics_4_components_audience_segmentation_dashboard_InfoNoticeWidget_constants__WEBPACK_IMPORTED_MODULE_5__.AUDIENCE_INFO_NOTICE_HIDE_UI, true);
  }, [setValue]);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(ErrorWidgetContentWithIntersectionObserver, {
    Widget: Widget,
    errors: errorsArray,
    onRetry: handleRetry,
    failedAudiences: failedAudiences,
    onRequestAccess: () => {
      (0,_js_util__WEBPACK_IMPORTED_MODULE_8__.trackEvent)(`${viewContext}_audiences-all-tiles`, 'insufficient_permissions_error_request_access');
    },
    showRetryButton: showRetryButton,
    onInView: () => {
      const action = hasInsufficientPermissionsError ? 'insufficient_permissions_error' : 'data_loading_error';
      (0,_js_util__WEBPACK_IMPORTED_MODULE_8__.trackEvent)(`${viewContext}_audiences-all-tiles`, action);
    }
  });
}
AudienceSegmentationErrorWidget.propTypes = {
  Widget: (prop_types__WEBPACK_IMPORTED_MODULE_13___default().elementType).isRequired,
  errors: prop_types__WEBPACK_IMPORTED_MODULE_13___default().oneOfType([(prop_types__WEBPACK_IMPORTED_MODULE_13___default().object), prop_types__WEBPACK_IMPORTED_MODULE_13___default().arrayOf((prop_types__WEBPACK_IMPORTED_MODULE_13___default().object))]).isRequired,
  onRetry: (prop_types__WEBPACK_IMPORTED_MODULE_13___default().func),
  showRetryButton: (prop_types__WEBPACK_IMPORTED_MODULE_13___default().bool),
  failedAudiences: prop_types__WEBPACK_IMPORTED_MODULE_13___default().arrayOf((prop_types__WEBPACK_IMPORTED_MODULE_13___default().string))
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ((0,_js_util_when_active__WEBPACK_IMPORTED_MODULE_1__["default"])({
  moduleName: _js_modules_analytics_4_constants__WEBPACK_IMPORTED_MODULE_10__.MODULE_SLUG_ANALYTICS_4
})(AudienceSegmentationErrorWidget));

/***/ }),

/***/ "./js/modules/analytics-4/components/audience-segmentation/dashboard/AudienceSegmentationIntroductoryOverlayNotification.js":
/*!**********************************************************************************************************************************!*\
  !*** ./js/modules/analytics-4/components/audience-segmentation/dashboard/AudienceSegmentationIntroductoryOverlayNotification.js ***!
  \**********************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   AUDIENCE_SEGMENTATION_INTRODUCTORY_OVERLAY_NOTIFICATION: () => (/* binding */ AUDIENCE_SEGMENTATION_INTRODUCTORY_OVERLAY_NOTIFICATION),
/* harmony export */   "default": () => (/* binding */ AudienceSegmentationIntroductoryOverlayNotification)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_10__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _svg_graphics_audience_segmentation_introductory_graphic_desktop_svg__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/svg/graphics/audience-segmentation-introductory-graphic-desktop.svg */ "./svg/graphics/audience-segmentation-introductory-graphic-desktop.svg");
/* harmony import */ var _svg_graphics_audience_segmentation_introductory_graphic_mobile_svg__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/svg/graphics/audience-segmentation-introductory-graphic-mobile.svg */ "./svg/graphics/audience-segmentation-introductory-graphic-mobile.svg");
/* harmony import */ var _js_googlesitekit_notifications_components_layout_OverlayNotification__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/googlesitekit/notifications/components/layout/OverlayNotification */ "./js/googlesitekit/notifications/components/layout/OverlayNotification.js");
/* harmony import */ var _js_util_scroll__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/util/scroll */ "./js/util/scroll.js");
/* harmony import */ var _js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @/js/hooks/useBreakpoint */ "./js/hooks/useBreakpoint.js");
/* harmony import */ var _js_googlesitekit_notifications_datastore_constants__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @/js/googlesitekit/notifications/datastore/constants */ "./js/googlesitekit/notifications/datastore/constants.js");
/* harmony import */ var _js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @/js/hooks/useViewContext */ "./js/hooks/useViewContext.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * AudienceSegmentationIntroductoryOverlayNotification component.
 *
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * External dependencies
 */


/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */









const AUDIENCE_SEGMENTATION_INTRODUCTORY_OVERLAY_NOTIFICATION = 'audienceSegmentationIntroductoryOverlayNotification';
function AudienceSegmentationIntroductoryOverlayNotification({
  id,
  Notification
}) {
  const viewContext = (0,_js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_8__["default"])();
  const breakpoint = (0,_js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_6__.useBreakpoint)();
  const {
    dismissNotification
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useDispatch)(_js_googlesitekit_notifications_datastore_constants__WEBPACK_IMPORTED_MODULE_7__.CORE_NOTIFICATIONS);
  function scrollToWidgetAndDismissNotification(event) {
    event.preventDefault();
    const widgetAreaClass = '.googlesitekit-widget-area--mainDashboardTrafficAudienceSegmentation';
    setTimeout(() => {
      __webpack_require__.g.scrollTo({
        top: (0,_js_util_scroll__WEBPACK_IMPORTED_MODULE_5__.getNavigationalScrollTop)(widgetAreaClass, breakpoint),
        behavior: 'smooth'
      });
    }, 0);
    dismissNotification(id);
  }
  const gaTrackingEventArgs = {
    category: `${viewContext}_audiences-secondary-user-intro`
  };
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)(Notification, {
    gaTrackingEventArgs: gaTrackingEventArgs,
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)(_js_googlesitekit_notifications_components_layout_OverlayNotification__WEBPACK_IMPORTED_MODULE_4__["default"], {
      notificationID: id,
      title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('New! Visitor groups', 'google-site-kit'),
      description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('You can now learn more about your site visitor groups by comparing different metrics.', 'google-site-kit'),
      GraphicDesktop: _svg_graphics_audience_segmentation_introductory_graphic_desktop_svg__WEBPACK_IMPORTED_MODULE_2__["default"],
      GraphicMobile: _svg_graphics_audience_segmentation_introductory_graphic_mobile_svg__WEBPACK_IMPORTED_MODULE_3__["default"],
      ctaButton: {
        label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Show me', 'google-site-kit'),
        onClick: scrollToWidgetAndDismissNotification
      },
      dismissButton: {
        label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Got it', 'google-site-kit')
      },
      gaTrackingEventArgs: gaTrackingEventArgs
    })
  });
}
AudienceSegmentationIntroductoryOverlayNotification.propTypes = {
  id: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().string).isRequired,
  Notification: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().elementType).isRequired
};

/***/ }),

/***/ "./js/modules/analytics-4/components/audience-segmentation/dashboard/AudienceSegmentationSetupCTABanner.js":
/*!*****************************************************************************************************************!*\
  !*** ./js/modules/analytics-4/components/audience-segmentation/dashboard/AudienceSegmentationSetupCTABanner.js ***!
  \*****************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   AUDIENCE_SEGMENTATION_SETUP_CTA_NOTIFICATION: () => (/* binding */ AUDIENCE_SEGMENTATION_SETUP_CTA_NOTIFICATION),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_23___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_23__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_compose__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(/*! @wordpress/compose */ "../node_modules/@wordpress/compose/build-module/higher-order/compose.js");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _js_googlesitekit_datastore_forms_constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/googlesitekit/datastore/forms/constants */ "./js/googlesitekit/datastore/forms/constants.js");
/* harmony import */ var _js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/googlesitekit/datastore/user/constants */ "./js/googlesitekit/datastore/user/constants.js");
/* harmony import */ var _js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/googlesitekit/datastore/site/constants */ "./js/googlesitekit/datastore/site/constants.js");
/* harmony import */ var _js_googlesitekit_notifications_datastore_constants__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/googlesitekit/notifications/datastore/constants */ "./js/googlesitekit/notifications/datastore/constants.js");
/* harmony import */ var _js_googlesitekit_notifications_constants__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @/js/googlesitekit/notifications/constants */ "./js/googlesitekit/notifications/constants.js");
/* harmony import */ var _js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @/js/modules/analytics-4/datastore/constants */ "./js/modules/analytics-4/datastore/constants.js");
/* harmony import */ var _js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @/js/hooks/useViewContext */ "./js/hooks/useViewContext.js");
/* harmony import */ var _js_components_AdminScreenTooltip__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @/js/components/AdminScreenTooltip */ "./js/components/AdminScreenTooltip/index.js");
/* harmony import */ var _js_util__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @/js/util */ "./js/util/index.js");
/* harmony import */ var _js_modules_analytics_4_hooks_useEnableAudienceGroup__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @/js/modules/analytics-4/hooks/useEnableAudienceGroup */ "./js/modules/analytics-4/hooks/useEnableAudienceGroup.js");
/* harmony import */ var _js_modules_analytics_4_components_audience_segmentation_dashboard_AudienceErrorModal__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! @/js/modules/analytics-4/components/audience-segmentation/dashboard/AudienceErrorModal */ "./js/modules/analytics-4/components/audience-segmentation/dashboard/AudienceErrorModal.js");
/* harmony import */ var _js_googlesitekit_notifications_components_layout_SetupCTA__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! @/js/googlesitekit/notifications/components/layout/SetupCTA */ "./js/googlesitekit/notifications/components/layout/SetupCTA.js");
/* harmony import */ var _svg_graphics_banner_audience_segmentation_setup_cta_svg_url__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! @/svg/graphics/banner-audience-segmentation-setup-cta.svg?url */ "./svg/graphics/banner-audience-segmentation-setup-cta.svg?url");
/* harmony import */ var _svg_graphics_banner_audience_segmentation_setup_cta_mobile_svg_url__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! @/svg/graphics/banner-audience-segmentation-setup-cta-mobile.svg?url */ "./svg/graphics/banner-audience-segmentation-setup-cta-mobile.svg?url");
/* harmony import */ var _js_modules_analytics_4_constants__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! @/js/modules/analytics-4/constants */ "./js/modules/analytics-4/constants.js");
/* harmony import */ var _js_util_when_active__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! @/js/util/when-active */ "./js/util/when-active.js");
/* harmony import */ var _js_googlesitekit_widgets_util__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! @/js/googlesitekit/widgets/util */ "./js/googlesitekit/widgets/util/index.js");
/* harmony import */ var _AudienceSegmentationSetupSuccessSubtleNotification__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! ./AudienceSegmentationSetupSuccessSubtleNotification */ "./js/modules/analytics-4/components/audience-segmentation/dashboard/AudienceSegmentationSetupSuccessSubtleNotification.js");
/* harmony import */ var _js_hooks_useFormValue__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! @/js/hooks/useFormValue */ "./js/hooks/useFormValue.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * AudienceSegmentationSetupCTABanner component.
 *
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */




/**
 * Internal dependencies
 */





















const AUDIENCE_SEGMENTATION_SETUP_CTA_NOTIFICATION = 'audience_segmentation_setup_cta-notification';
function AudienceSegmentationSetupCTABanner({
  id,
  Notification
}) {
  const viewContext = (0,_js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_8__["default"])();
  const trackEventCategory = `${viewContext}_audiences-setup-cta-dashboard`;
  const {
    dismissNotification,
    registerNotification,
    pinNotification
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useDispatch)(_js_googlesitekit_notifications_datastore_constants__WEBPACK_IMPORTED_MODULE_5__.CORE_NOTIFICATIONS);
  const {
    setValues
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useDispatch)(_js_googlesitekit_datastore_forms_constants__WEBPACK_IMPORTED_MODULE_2__.CORE_FORMS);
  const tooltipSettings = {
    tooltipSlug: id,
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('You can always enable groups in Settings later', 'google-site-kit'),
    content: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('The visitors group section will be added to your dashboard once you set it up.', 'google-site-kit'),
    dismissLabel: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Got it', 'google-site-kit')
  };
  const showTooltip = (0,_js_components_AdminScreenTooltip__WEBPACK_IMPORTED_MODULE_9__.useShowTooltip)(tooltipSettings);
  const isDismissalFinal = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_notifications_datastore_constants__WEBPACK_IMPORTED_MODULE_5__.CORE_NOTIFICATIONS).isNotificationDismissalFinal(id));
  const autoSubmit = (0,_js_hooks_useFormValue__WEBPACK_IMPORTED_MODULE_20__["default"])(_js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_7__.AUDIENCE_SEGMENTATION_SETUP_FORM, 'autoSubmit');
  const [showErrorModal, setShowErrorModal] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_22__.useState)(false);
  const onSuccess = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_22__.useCallback)(() => {
    registerNotification(_AudienceSegmentationSetupSuccessSubtleNotification__WEBPACK_IMPORTED_MODULE_19__.AUDIENCE_SEGMENTATION_SETUP_SUCCESS_NOTIFICATION, {
      Component: _AudienceSegmentationSetupSuccessSubtleNotification__WEBPACK_IMPORTED_MODULE_19__["default"],
      areaSlug: _js_googlesitekit_notifications_constants__WEBPACK_IMPORTED_MODULE_6__.NOTIFICATION_AREAS.DASHBOARD_TOP
    });
    dismissNotification(id);
  }, [registerNotification, dismissNotification, id]);
  const onError = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_22__.useCallback)(() => {
    setShowErrorModal(true);
  }, [setShowErrorModal]);
  const onOAuthNavigation = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_22__.useCallback)(() => pinNotification(id, _js_googlesitekit_notifications_constants__WEBPACK_IMPORTED_MODULE_6__.NOTIFICATION_GROUPS.SETUP_CTAS), [id, pinNotification]);
  const {
    apiErrors,
    failedAudiences,
    isSaving,
    onEnableGroups
  } = (0,_js_modules_analytics_4_hooks_useEnableAudienceGroup__WEBPACK_IMPORTED_MODULE_11__["default"])({
    onSuccess,
    onError,
    onOAuthNavigation
  });
  const {
    clearPermissionScopeError
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useDispatch)(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_USER);
  const {
    setSetupErrorCode
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useDispatch)(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_4__.CORE_SITE);
  const onCancel = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_22__.useCallback)(() => {
    setValues(_js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_7__.AUDIENCE_SEGMENTATION_SETUP_FORM, {
      autoSubmit: false
    });
    clearPermissionScopeError();
    setSetupErrorCode(null);
    setShowErrorModal(false);
  }, [clearPermissionScopeError, setSetupErrorCode, setValues]);
  const setupErrorCode = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_4__.CORE_SITE).getSetupErrorCode());
  const learnMoreLink = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_4__.CORE_SITE).getDocumentationLinkURL('visitor-groups'));
  const hasOAuthError = autoSubmit && setupErrorCode === 'access_denied';
  const gaTrackingProps = {
    gaTrackingEventArgs: {
      category: trackEventCategory
    }
  };
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_21__.jsxs)(_wordpress_element__WEBPACK_IMPORTED_MODULE_22__.Fragment, {
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_21__.jsx)(Notification, {
      ...gaTrackingProps,
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_21__.jsx)(_js_googlesitekit_notifications_components_layout_SetupCTA__WEBPACK_IMPORTED_MODULE_13__["default"], {
        notificationID: id,
        title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Learn how different types of visitors interact with your site', 'google-site-kit'),
        description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Understand what brings new visitors to your site and keeps them coming back. Site Kit can now group your site visitors into relevant segments like "new" and "returning". To set up these new groups, Site Kit needs to update your Google Analytics property.', 'google-site-kit'),
        learnMoreLink: {
          href: learnMoreLink
        },
        ctaButton: {
          label: isSaving ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Enabling groups', 'google-site-kit') : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Enable groups', 'google-site-kit'),
          onClick: onEnableGroups,
          disabled: isSaving,
          inProgress: isSaving
        },
        dismissButton: {
          label: isDismissalFinal ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Don’t show again', 'google-site-kit') : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Maybe later', 'google-site-kit'),
          onClick: showTooltip,
          disabled: isSaving,
          dismissOptions: {
            expiresInSeconds: isDismissalFinal ? 0 : 2 * _js_util__WEBPACK_IMPORTED_MODULE_10__.WEEK_IN_SECONDS
          }
        },
        svg: {
          desktop: _svg_graphics_banner_audience_segmentation_setup_cta_svg_url__WEBPACK_IMPORTED_MODULE_14__["default"],
          mobile: _svg_graphics_banner_audience_segmentation_setup_cta_mobile_svg_url__WEBPACK_IMPORTED_MODULE_15__["default"],
          verticalPosition: 'bottom'
        },
        gaTrackingEventArgs: {
          category: trackEventCategory
        }
      })
    }), (showErrorModal || hasOAuthError) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_21__.jsx)(_js_modules_analytics_4_components_audience_segmentation_dashboard_AudienceErrorModal__WEBPACK_IMPORTED_MODULE_12__["default"], {
      hasOAuthError: hasOAuthError,
      apiErrors: apiErrors.length ? apiErrors : failedAudiences,
      onRetry: onEnableGroups,
      inProgress: isSaving,
      onCancel: hasOAuthError ? onCancel : () => setShowErrorModal(false),
      trackEventCategory: `${viewContext}_audiences-setup`
    })]
  });
}
AudienceSegmentationSetupCTABanner.propTypes = {
  id: (prop_types__WEBPACK_IMPORTED_MODULE_23___default().string),
  Notification: (prop_types__WEBPACK_IMPORTED_MODULE_23___default().elementType)
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ((0,_wordpress_compose__WEBPACK_IMPORTED_MODULE_24__["default"])((0,_js_util_when_active__WEBPACK_IMPORTED_MODULE_17__["default"])({
  moduleName: _js_modules_analytics_4_constants__WEBPACK_IMPORTED_MODULE_16__.MODULE_SLUG_ANALYTICS_4
}), (0,_js_googlesitekit_widgets_util__WEBPACK_IMPORTED_MODULE_18__.withWidgetComponentProps)('audienceSegmentationSetupCTA'))(AudienceSegmentationSetupCTABanner));

/***/ }),

/***/ "./js/modules/analytics-4/components/audience-segmentation/dashboard/AudienceSegmentationSetupSuccessSubtleNotification.js":
/*!*********************************************************************************************************************************!*\
  !*** ./js/modules/analytics-4/components/audience-segmentation/dashboard/AudienceSegmentationSetupSuccessSubtleNotification.js ***!
  \*********************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   AUDIENCE_SEGMENTATION_SETUP_SUCCESS_NOTIFICATION: () => (/* binding */ AUDIENCE_SEGMENTATION_SETUP_SUCCESS_NOTIFICATION),
/* harmony export */   "default": () => (/* binding */ AudienceSegmentationSetupSuccessSubtleNotification)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_10__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _js_googlesitekit_notifications_components_layout_NoticeNotification__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/googlesitekit/notifications/components/layout/NoticeNotification */ "./js/googlesitekit/notifications/components/layout/NoticeNotification.js");
/* harmony import */ var _js_components_Notice_constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/components/Notice/constants */ "./js/components/Notice/constants.js");
/* harmony import */ var _js_util_scroll__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/util/scroll */ "./js/util/scroll.js");
/* harmony import */ var _js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/hooks/useBreakpoint */ "./js/hooks/useBreakpoint.js");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _js_googlesitekit_notifications_datastore_constants__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @/js/googlesitekit/notifications/datastore/constants */ "./js/googlesitekit/notifications/datastore/constants.js");
/* harmony import */ var _js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @/js/googlesitekit/datastore/user/constants */ "./js/googlesitekit/datastore/user/constants.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * AudienceSegmentationSetupSuccessSubtleNotification component.
 *
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */








const AUDIENCE_SEGMENTATION_SETUP_SUCCESS_NOTIFICATION = 'setup-success-notification-audiences';
function AudienceSegmentationSetupSuccessSubtleNotification({
  id,
  Notification
}) {
  const breakpoint = (0,_js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_4__.useBreakpoint)();
  const {
    dismissNotification
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_5__.useDispatch)(_js_googlesitekit_notifications_datastore_constants__WEBPACK_IMPORTED_MODULE_6__.CORE_NOTIFICATIONS);
  const isAudienceSegmentationWidgetHidden = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_5__.useSelect)(select => select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_7__.CORE_USER).isAudienceSegmentationWidgetHidden());
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.useEffect)(() => {
    if (isAudienceSegmentationWidgetHidden) {
      dismissNotification(AUDIENCE_SEGMENTATION_SETUP_SUCCESS_NOTIFICATION);
    }
  }, [dismissNotification, isAudienceSegmentationWidgetHidden]);
  function scrollToWidgetArea(event) {
    event.preventDefault();
    dismissNotification(AUDIENCE_SEGMENTATION_SETUP_SUCCESS_NOTIFICATION);
    setTimeout(() => {
      const widgetClass = '.googlesitekit-widget-area--mainDashboardTrafficAudienceSegmentation';
      __webpack_require__.g.scrollTo({
        top: (0,_js_util_scroll__WEBPACK_IMPORTED_MODULE_3__.getNavigationalScrollTop)(widgetClass, breakpoint),
        behavior: 'smooth'
      });
    }, 50);
  }
  if (isAudienceSegmentationWidgetHidden === undefined) {
    return null;
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(Notification, {
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(_js_googlesitekit_notifications_components_layout_NoticeNotification__WEBPACK_IMPORTED_MODULE_1__["default"], {
      notificationID: id,
      type: _js_components_Notice_constants__WEBPACK_IMPORTED_MODULE_2__.TYPES.SUCCESS,
      title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Success! Visitor groups added to your dashboard', 'google-site-kit'),
      description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Get to know how different types of visitors interact with your site, e.g. which pages they visit and for how long', 'google-site-kit'),
      ctaButton: {
        label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Show me', 'google-site-kit'),
        onClick: scrollToWidgetArea
      },
      dismissButton: true
    })
  });
}
AudienceSegmentationSetupSuccessSubtleNotification.propTypes = {
  id: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().string).isRequired,
  Notification: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().elementType).isRequired
};

/***/ }),

/***/ "./js/modules/analytics-4/components/audience-segmentation/dashboard/AudienceSelectionPanel/AddGroupNotice.js":
/*!********************************************************************************************************************!*\
  !*** ./js/modules/analytics-4/components/audience-segmentation/dashboard/AudienceSelectionPanel/AddGroupNotice.js ***!
  \********************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ AddGroupNotice)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_11___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_11__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./constants */ "./js/modules/analytics-4/components/audience-segmentation/dashboard/AudienceSelectionPanel/constants.js");
/* harmony import */ var _js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/googlesitekit/datastore/user/constants */ "./js/googlesitekit/datastore/user/constants.js");
/* harmony import */ var _svg_icons_info_circle_svg__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/svg/icons/info-circle.svg */ "./svg/icons/info-circle.svg");
/* harmony import */ var _js_modules_analytics_4_components_audience_segmentation_dashboard_InfoNotice__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/modules/analytics-4/components/audience-segmentation/dashboard/InfoNotice */ "./js/modules/analytics-4/components/audience-segmentation/dashboard/InfoNotice.js");
/* harmony import */ var _js_googlesitekit_datastore_ui_constants__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @/js/googlesitekit/datastore/ui/constants */ "./js/googlesitekit/datastore/ui/constants.js");
/* harmony import */ var _js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @/js/modules/analytics-4/datastore/constants */ "./js/modules/analytics-4/datastore/constants.js");
/* harmony import */ var _js_hooks_useFormValue__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @/js/hooks/useFormValue */ "./js/hooks/useFormValue.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Audience Selection Panel Add Group Notice
 *
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */









function AddGroupNotice() {
  const [twoOrMoreAudiencesSelected, setTwoOrMoreAudiencesSelected] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_10__.useState)(false);
  const isDismissed = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useInViewSelect)(select => select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_USER).isItemDismissed(_constants__WEBPACK_IMPORTED_MODULE_2__.AUDIENCE_ADD_GROUP_NOTICE_SLUG));
  const isSelectionPanelOpen = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_datastore_ui_constants__WEBPACK_IMPORTED_MODULE_6__.CORE_UI).getValue(_constants__WEBPACK_IMPORTED_MODULE_2__.AUDIENCE_SELECTION_PANEL_OPENED_KEY));
  const isLoading = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_7__.MODULES_ANALYTICS_4).isFetchingSyncAvailableAudiences());
  const selectedAudiences = (0,_js_hooks_useFormValue__WEBPACK_IMPORTED_MODULE_8__["default"])(_constants__WEBPACK_IMPORTED_MODULE_2__.AUDIENCE_SELECTION_FORM, _constants__WEBPACK_IMPORTED_MODULE_2__.AUDIENCE_SELECTED);
  const {
    dismissItem
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useDispatch)(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_USER);
  const onDismiss = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_10__.useCallback)(async () => {
    await dismissItem(_constants__WEBPACK_IMPORTED_MODULE_2__.AUDIENCE_ADD_GROUP_NOTICE_SLUG);
  }, [dismissItem]);
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_10__.useEffect)(() => {
    if (!Array.isArray(selectedAudiences)) {
      return;
    }
    if (selectedAudiences.length > 1) {
      setTwoOrMoreAudiencesSelected(true);
    }

    // If selected items changed to only 1 or less selected audiences
    // reset the value. Otherwise `twoOrMoreAudiencesSelected` always remains `true`.
    // We are checking if selection panel is closed to do that, so notice is not re-surfaced
    // while selection panel is still open.
    if (!isSelectionPanelOpen && selectedAudiences?.length === 1) {
      setTwoOrMoreAudiencesSelected(false);
    }
  }, [selectedAudiences, isSelectionPanelOpen, setTwoOrMoreAudiencesSelected]);
  if (
  // Do not render the notice if the slection panel is dismissed.
  isDismissed ||
  // Has two or more audiences selected.
  twoOrMoreAudiencesSelected ||
  // Items are showing as preview blocks - re-syncing is still in progress.
  isLoading ||
  // There is no audience selected.
  !selectedAudiences?.length) {
    return null;
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)(_js_modules_analytics_4_components_audience_segmentation_dashboard_InfoNotice__WEBPACK_IMPORTED_MODULE_5__["default"], {
    className: "googlesitekit-audience-selection-panel__add-group-notice",
    content: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('By adding another group to your dashboard, you will be able to compare them and understand which content brings back users from each group', 'google-site-kit'),
    dismissLabel: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Got it', 'google-site-kit'),
    Icon: _svg_icons_info_circle_svg__WEBPACK_IMPORTED_MODULE_4__["default"],
    onDismiss: onDismiss
  });
}
AddGroupNotice.propTypes = {
  savedItemSlugs: (prop_types__WEBPACK_IMPORTED_MODULE_11___default().array)
};

/***/ }),

/***/ "./js/modules/analytics-4/components/audience-segmentation/dashboard/AudienceSelectionPanel/AudienceCreationErrorNotice.js":
/*!*********************************************************************************************************************************!*\
  !*** ./js/modules/analytics-4/components/audience-segmentation/dashboard/AudienceSelectionPanel/AudienceCreationErrorNotice.js ***!
  \*********************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ AudienceCreationErrorNotice)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_14___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_14__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/@wordpress/element/build-module/create-interpolate-element.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/hooks/useViewContext */ "./js/hooks/useViewContext.js");
/* harmony import */ var _js_util_errors__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/util/errors */ "./js/util/errors.js");
/* harmony import */ var _js_util__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/util */ "./js/util/index.js");
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./constants */ "./js/modules/analytics-4/components/audience-segmentation/dashboard/AudienceSelectionPanel/constants.js");
/* harmony import */ var _js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @/js/googlesitekit/datastore/site/constants */ "./js/googlesitekit/datastore/site/constants.js");
/* harmony import */ var _js_googlesitekit_datastore_ui_constants__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @/js/googlesitekit/datastore/ui/constants */ "./js/googlesitekit/datastore/ui/constants.js");
/* harmony import */ var _js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @/js/modules/analytics-4/datastore/constants */ "./js/modules/analytics-4/datastore/constants.js");
/* harmony import */ var _js_components_Link__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @/js/components/Link */ "./js/components/Link.js");
/* harmony import */ var _js_components_Notice__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @/js/components/Notice */ "./js/components/Notice/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Audience Segmentation AudienceCreationErrorNotice component.
 *
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */











function AudienceCreationErrorNotice({
  apiErrors,
  hasOAuthError
}) {
  const viewContext = (0,_js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_2__["default"])();
  const errors = Array.isArray(apiErrors) ? apiErrors : [apiErrors];
  const helpLink = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_6__.CORE_SITE).getErrorTroubleshootingLinkURL({
    code: 'analytics-4_insufficient_permissions'
  }));
  const requestAccessURL = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_8__.MODULES_ANALYTICS_4).getServiceEntityAccessURL());
  const errorTroubleshootingLinkURL = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_6__.CORE_SITE).getErrorTroubleshootingLinkURL({
    code: 'access_denied'
  }));
  const isOpen = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_datastore_ui_constants__WEBPACK_IMPORTED_MODULE_7__.CORE_UI).getValue(_constants__WEBPACK_IMPORTED_MODULE_5__.AUDIENCE_SELECTION_PANEL_OPENED_KEY));
  const hasErrors = errors.length > 0;
  const hasInsufficientPermissionsError = errors.some(error => (0,_js_util_errors__WEBPACK_IMPORTED_MODULE_3__.isInsufficientPermissionsError)(error));

  // Track an event when the notice is viewed.
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_12__.useEffect)(() => {
    if (!isOpen || !hasErrors && !hasOAuthError) {
      return;
    }
    let event = 'setup_error';
    if (hasOAuthError) {
      event = 'auth_error';
    } else if (hasInsufficientPermissionsError) {
      event = 'insufficient_permissions_error';
    }
    (0,_js_util__WEBPACK_IMPORTED_MODULE_4__.trackEvent)(`${viewContext}_audiences-sidebar-create-audiences`, event);
  }, [hasErrors, hasInsufficientPermissionsError, hasOAuthError, isOpen, viewContext]);
  if (!errors.length && !hasOAuthError) {
    return null;
  }
  let errorTitle, errorDescription;
  if (hasOAuthError) {
    errorDescription = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_13__["default"])((0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Setup was interrupted because you didn’t grant the necessary permissions. Click on Create again to retry. If that doesn’t work, <HelpLink />', 'google-site-kit'), {
      HelpLink: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_js_components_Link__WEBPACK_IMPORTED_MODULE_9__["default"], {
        href: errorTroubleshootingLinkURL,
        external: true,
        hideExternalIndicator: true,
        children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('get help', 'google-site-kit')
      })
    });
  } else if (hasInsufficientPermissionsError) {
    errorTitle = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Insufficient permissions', 'google-site-kit');
    errorDescription = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_13__["default"])((0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Contact your administrator. Trouble getting access? <HelpLink />', 'google-site-kit'), {
      HelpLink: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_js_components_Link__WEBPACK_IMPORTED_MODULE_9__["default"], {
        href: helpLink,
        external: true,
        hideExternalIndicator: true,
        children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Get help', 'google-site-kit')
      })
    });
  } else {
    errorTitle = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Analytics update failed', 'google-site-kit');
    errorDescription = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Click on Create to try again.', 'google-site-kit');
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_js_components_Notice__WEBPACK_IMPORTED_MODULE_10__["default"], {
    className: "googlesitekit-audience-creation-error-notice",
    type: _js_components_Notice__WEBPACK_IMPORTED_MODULE_10__["default"].TYPES.ERROR,
    title: errorTitle,
    description: errorDescription,
    ctaButton: hasInsufficientPermissionsError ? {
      label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Request access', 'google-site-kit'),
      href: requestAccessURL,
      onClick: () => {
        (0,_js_util__WEBPACK_IMPORTED_MODULE_4__.trackEvent)(`${viewContext}_audiences-sidebar-create-audiences`, 'insufficient_permissions_error_request_access');
      }
    } : undefined,
    hideIcon: true
  });
}
AudienceCreationErrorNotice.propTypes = {
  apiErrors: prop_types__WEBPACK_IMPORTED_MODULE_14___default().oneOfType([prop_types__WEBPACK_IMPORTED_MODULE_14___default().arrayOf((prop_types__WEBPACK_IMPORTED_MODULE_14___default().object)), (prop_types__WEBPACK_IMPORTED_MODULE_14___default().object), (prop_types__WEBPACK_IMPORTED_MODULE_14___default().array)]),
  hasOAuthError: (prop_types__WEBPACK_IMPORTED_MODULE_14___default().bool)
};

/***/ }),

/***/ "./js/modules/analytics-4/components/audience-segmentation/dashboard/AudienceSelectionPanel/AudienceCreationNotice.js":
/*!****************************************************************************************************************************!*\
  !*** ./js/modules/analytics-4/components/audience-segmentation/dashboard/AudienceSelectionPanel/AudienceCreationNotice.js ***!
  \****************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ AudienceCreationNotice)
/* harmony export */ });
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _wordpress_url__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! @wordpress/url */ "../node_modules/@wordpress/url/build-module/add-query-args.js");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/hooks/useViewContext */ "./js/hooks/useViewContext.js");
/* harmony import */ var _js_util__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/util */ "./js/util/index.js");
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./constants */ "./js/modules/analytics-4/components/audience-segmentation/dashboard/AudienceSelectionPanel/constants.js");
/* harmony import */ var _js_googlesitekit_datastore_forms_constants__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/googlesitekit/datastore/forms/constants */ "./js/googlesitekit/datastore/forms/constants.js");
/* harmony import */ var _js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @/js/googlesitekit/datastore/site/constants */ "./js/googlesitekit/datastore/site/constants.js");
/* harmony import */ var _js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @/js/googlesitekit/datastore/user/constants */ "./js/googlesitekit/datastore/user/constants.js");
/* harmony import */ var _js_googlesitekit_datastore_ui_constants__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @/js/googlesitekit/datastore/ui/constants */ "./js/googlesitekit/datastore/ui/constants.js");
/* harmony import */ var _js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @/js/modules/analytics-4/datastore/constants */ "./js/modules/analytics-4/datastore/constants.js");
/* harmony import */ var _js_util_errors__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @/js/util/errors */ "./js/util/errors.js");
/* harmony import */ var _js_components_Link__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @/js/components/Link */ "./js/components/Link.js");
/* harmony import */ var _js_googlesitekit_components_gm2_SpinnerButton__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! @/js/googlesitekit/components-gm2/SpinnerButton */ "./js/googlesitekit/components-gm2/SpinnerButton.js");
/* harmony import */ var _AudienceCreationErrorNotice__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ./AudienceCreationErrorNotice */ "./js/modules/analytics-4/components/audience-segmentation/dashboard/AudienceSelectionPanel/AudienceCreationErrorNotice.js");
/* harmony import */ var _js_components_Notice__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! @/js/components/Notice */ "./js/components/Notice/index.js");
/* harmony import */ var _js_components_Typography__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! @/js/components/Typography */ "./js/components/Typography/index.js");
/* harmony import */ var _js_hooks_useFormValue__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! @/js/hooks/useFormValue */ "./js/hooks/useFormValue.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Audience Selection Panel AudienceCreationNotice component.
 *
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */




/**
 * Internal dependencies
 */

















function AudienceCreationNotice() {
  const viewContext = (0,_js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_2__["default"])();
  const [isCreatingAudience, setIsCreatingAudience] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_18__.useState)(false);
  const siteKitConfigurableAudiences = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useInViewSelect)(select => {
    const {
      getConfigurableAudiences
    } = select(_js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_9__.MODULES_ANALYTICS_4);
    const audiences = getConfigurableAudiences();
    if (undefined === audiences) {
      return undefined;
    }
    if (!audiences.length) {
      return [];
    }
    return audiences.filter(({
      audienceType
    }) => audienceType === 'SITE_KIT_AUDIENCE');
  });
  const {
    dismissItem
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useDispatch)(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_7__.CORE_USER);
  const {
    setValue
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useDispatch)(_js_googlesitekit_datastore_ui_constants__WEBPACK_IMPORTED_MODULE_8__.CORE_UI);
  const isItemDismissed = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useInViewSelect)(select => select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_7__.CORE_USER).isItemDismissed(_constants__WEBPACK_IMPORTED_MODULE_4__.AUDIENCE_CREATION_NOTICE_SLUG));
  const isEditScopeNoticeDismissed = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useInViewSelect)(select => select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_7__.CORE_USER).isItemDismissed(_constants__WEBPACK_IMPORTED_MODULE_4__.AUDIENCE_CREATION_EDIT_SCOPE_NOTICE_SLUG));
  const hasAnalytics4EditScope = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useInViewSelect)(select => select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_7__.CORE_USER).hasScope(_js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_9__.EDIT_SCOPE));
  const isOpen = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_datastore_ui_constants__WEBPACK_IMPORTED_MODULE_8__.CORE_UI).getValue(_constants__WEBPACK_IMPORTED_MODULE_4__.AUDIENCE_SELECTION_PANEL_OPENED_KEY));
  function onCloseClick() {
    dismissItem(_constants__WEBPACK_IMPORTED_MODULE_4__.AUDIENCE_CREATION_NOTICE_SLUG);
  }
  const redirectURL = (0,_wordpress_url__WEBPACK_IMPORTED_MODULE_19__.addQueryArgs)(__webpack_require__.g.location.href, {
    notification: 'audience_segmentation'
  });
  const {
    setValues
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useDispatch)(_js_googlesitekit_datastore_forms_constants__WEBPACK_IMPORTED_MODULE_5__.CORE_FORMS);
  const {
    setPermissionScopeError
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useDispatch)(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_7__.CORE_USER);
  const {
    createAudience,
    syncAvailableAudiences
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useDispatch)(_js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_9__.MODULES_ANALYTICS_4);
  const isCreatingAudienceFromOAuth = (0,_js_hooks_useFormValue__WEBPACK_IMPORTED_MODULE_16__["default"])(_constants__WEBPACK_IMPORTED_MODULE_4__.AUDIENCE_CREATION_FORM, 'autoSubmit');
  const failedAudienceToCreate = (0,_js_hooks_useFormValue__WEBPACK_IMPORTED_MODULE_16__["default"])(_constants__WEBPACK_IMPORTED_MODULE_4__.AUDIENCE_CREATION_FORM, 'audienceToCreate');
  const [apiErrors, setApiErrors] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_18__.useState)([]);
  const handleCreateAudience = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_18__.useCallback)(async audienceSlug => {
    setIsCreatingAudience(audienceSlug);
    if (!hasAnalytics4EditScope) {
      setValues(_constants__WEBPACK_IMPORTED_MODULE_4__.AUDIENCE_CREATION_FORM, {
        autoSubmit: true,
        audienceToCreate: audienceSlug
      });

      // Set permission scope error to trigger OAuth flow.
      setPermissionScopeError({
        code: _js_util_errors__WEBPACK_IMPORTED_MODULE_10__.ERROR_CODE_MISSING_REQUIRED_SCOPE,
        message: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Additional permissions are required to create a new audience in Analytics.', 'google-site-kit'),
        data: {
          status: 403,
          scopes: [_js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_9__.EDIT_SCOPE],
          skipModal: true,
          redirectURL
        }
      });
      return;
    }
    setValues(_constants__WEBPACK_IMPORTED_MODULE_4__.AUDIENCE_CREATION_FORM, {
      autoSubmit: false,
      audienceToCreate: undefined
    });
    const {
      error
    } = await createAudience(_js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_9__.SITE_KIT_AUDIENCE_DEFINITIONS[audienceSlug]);
    if (!!error) {
      setApiErrors([error]);
    } else {
      setApiErrors([]);
    }
    await syncAvailableAudiences();
    setIsCreatingAudience(false);
    if (!error) {
      setValue(_constants__WEBPACK_IMPORTED_MODULE_4__.AUDIENCE_CREATION_SUCCESS_NOTICE_SLUG, true);
    }
  }, [hasAnalytics4EditScope, createAudience, syncAvailableAudiences, setValues, setPermissionScopeError, redirectURL, setValue]);
  function handleDismissEditScopeNotice() {
    (0,_js_util__WEBPACK_IMPORTED_MODULE_3__.trackEvent)(`${viewContext}_audiences-sidebar-create-audiences`, 'dismiss_oauth_notice').finally(() => {
      dismissItem(_constants__WEBPACK_IMPORTED_MODULE_4__.AUDIENCE_CREATION_EDIT_SCOPE_NOTICE_SLUG);
    });
  }
  const setupErrorCode = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_6__.CORE_SITE).getSetupErrorCode());
  const hasOAuthError = isCreatingAudienceFromOAuth && setupErrorCode === 'access_denied';
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_18__.useEffect)(() => {
    async function createAudienceFromOAuth() {
      if (hasAnalytics4EditScope && isCreatingAudienceFromOAuth) {
        setValue(_constants__WEBPACK_IMPORTED_MODULE_4__.AUDIENCE_SELECTION_PANEL_OPENED_KEY, true);
        await handleCreateAudience(failedAudienceToCreate);
      }
    }
    createAudienceFromOAuth();
  }, [failedAudienceToCreate, handleCreateAudience, hasAnalytics4EditScope, isCreatingAudienceFromOAuth, setValue]);

  // Show the notice if the user has no site kit audiences, or has
  // created one, and the user has not dismissed it.
  const shouldShowNotice = !isItemDismissed && siteKitConfigurableAudiences?.length < 2;

  // Track an event when the notice is viewed.
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_18__.useEffect)(() => {
    if (isOpen && shouldShowNotice) {
      (0,_js_util__WEBPACK_IMPORTED_MODULE_3__.trackEvent)(`${viewContext}_audiences-sidebar-create-audiences`, 'view_notice');
    }
  }, [isOpen, shouldShowNotice, viewContext]);

  // Track an event when the OAuth notice is viewed.
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_18__.useEffect)(() => {
    if (isOpen && !hasAnalytics4EditScope && !isEditScopeNoticeDismissed) {
      (0,_js_util__WEBPACK_IMPORTED_MODULE_3__.trackEvent)(`${viewContext}_audiences-sidebar-create-audiences`, 'view_oauth_notice');
    }
  }, [hasAnalytics4EditScope, isEditScopeNoticeDismissed, isOpen, viewContext]);
  if (!shouldShowNotice) {
    return null;
  }
  const siteKitAvailableAudiences = Object.keys(_js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_9__.SITE_KIT_AUDIENCE_DEFINITIONS).filter(audienceSlug => !siteKitConfigurableAudiences.some(configuredAudience => configuredAudience.audienceSlug === audienceSlug));
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_17__.jsxs)("div", {
    className: "googlesitekit-audience-selection-panel__audience-creation-notice",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_17__.jsx)("div", {
      className: "googlesitekit-audience-selection-panel__audience-creation-notice-header",
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_17__.jsx)("p", {
        className: "googlesitekit-audience-selection-panel__audience-creation-notice-title",
        children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Create groups suggested by Site Kit', 'google-site-kit')
      })
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_17__.jsxs)("div", {
      className: "googlesitekit-audience-selection-panel__audience-creation-notice-body",
      children: [siteKitAvailableAudiences && siteKitAvailableAudiences.map(audienceSlug => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_17__.jsxs)("div", {
        className: "googlesitekit-audience-selection-panel__audience-creation-notice-audience",
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_17__.jsxs)("div", {
          className: "googlesitekit-audience-selection-panel__audience-creation-notice-audience-details",
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_17__.jsx)(_js_components_Typography__WEBPACK_IMPORTED_MODULE_15__["default"], {
            as: "h3",
            type: "title",
            size: "small",
            children: _js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_9__.SITE_KIT_AUDIENCE_DEFINITIONS[audienceSlug].displayName
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_17__.jsx)("p", {
            className: "googlesitekit-audience-selection-panel__audience-creation-notice-audience-description",
            children: _js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_9__.SITE_KIT_AUDIENCE_DEFINITIONS[audienceSlug].description
          })]
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_17__.jsx)("div", {
          className: "googlesitekit-audience-selection-panel__audience-creation-notice-audience-button",
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_17__.jsx)(_js_googlesitekit_components_gm2_SpinnerButton__WEBPACK_IMPORTED_MODULE_12__["default"], {
            spinnerPosition: _js_googlesitekit_components_gm2_SpinnerButton__WEBPACK_IMPORTED_MODULE_12__.SPINNER_POSITION.BEFORE,
            onClick: () => {
              (0,_js_util__WEBPACK_IMPORTED_MODULE_3__.trackEvent)(`${viewContext}_audiences-sidebar-create-audiences`, 'create_audience', audienceSlug).finally(() => {
                handleCreateAudience(audienceSlug);
              });
            },
            isSaving: isCreatingAudience === audienceSlug,
            children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Create', 'google-site-kit')
          })
        })]
      }, audienceSlug)), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_17__.jsx)("div", {
        className: "googlesitekit-audience-selection-panel__audience-creation-notice-dismiss",
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_17__.jsx)(_js_components_Link__WEBPACK_IMPORTED_MODULE_11__["default"], {
          onClick: onCloseClick,
          children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('No thanks', 'google-site-kit')
        })
      })]
    }), !hasAnalytics4EditScope && !isEditScopeNoticeDismissed && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_17__.jsx)(_js_components_Notice__WEBPACK_IMPORTED_MODULE_14__["default"], {
      type: _js_components_Notice__WEBPACK_IMPORTED_MODULE_14__["default"].TYPES.WARNING,
      description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Creating these groups require more data tracking. You will be directed to update your Analytics property.', 'google-site-kit'),
      dismissButton: {
        onClick: handleDismissEditScopeNotice
      },
      hideIcon: true
    }), (apiErrors.length > 0 || hasOAuthError) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_17__.jsx)(_AudienceCreationErrorNotice__WEBPACK_IMPORTED_MODULE_13__["default"], {
      apiErrors: apiErrors,
      hasOAuthError: hasOAuthError
    })]
  });
}

/***/ }),

/***/ "./js/modules/analytics-4/components/audience-segmentation/dashboard/AudienceSelectionPanel/AudienceCreationSuccessNotice.js":
/*!***********************************************************************************************************************************!*\
  !*** ./js/modules/analytics-4/components/audience-segmentation/dashboard/AudienceSelectionPanel/AudienceCreationSuccessNotice.js ***!
  \***********************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ AudienceCreationSuccessNotice)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/hooks/useViewContext */ "./js/hooks/useViewContext.js");
/* harmony import */ var _js_util__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/util */ "./js/util/index.js");
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./constants */ "./js/modules/analytics-4/components/audience-segmentation/dashboard/AudienceSelectionPanel/constants.js");
/* harmony import */ var _js_googlesitekit_datastore_ui_constants__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/googlesitekit/datastore/ui/constants */ "./js/googlesitekit/datastore/ui/constants.js");
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! googlesitekit-components */ "googlesitekit-components");
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_components__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var _svg_icons_check_fill_svg__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @/svg/icons/check-fill.svg */ "./svg/icons/check-fill.svg");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Audience Creation Success Notice component.
 *
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */








function AudienceCreationSuccessNotice() {
  const viewContext = (0,_js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_2__["default"])();
  const {
    setValue
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useDispatch)(_js_googlesitekit_datastore_ui_constants__WEBPACK_IMPORTED_MODULE_5__.CORE_UI);
  const showSuccessNotice = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_datastore_ui_constants__WEBPACK_IMPORTED_MODULE_5__.CORE_UI).getValue(_constants__WEBPACK_IMPORTED_MODULE_4__.AUDIENCE_CREATION_SUCCESS_NOTICE_SLUG));
  const isOpen = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_datastore_ui_constants__WEBPACK_IMPORTED_MODULE_5__.CORE_UI).getValue(_constants__WEBPACK_IMPORTED_MODULE_4__.AUDIENCE_SELECTION_PANEL_OPENED_KEY));

  // Track an event when the notice is viewed.
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.useEffect)(() => {
    if (isOpen && showSuccessNotice) {
      (0,_js_util__WEBPACK_IMPORTED_MODULE_3__.trackEvent)(`${viewContext}_audiences-sidebar-create-audiences-success`, 'view_notification');
    }
  }, [isOpen, showSuccessNotice, viewContext]);
  if (!showSuccessNotice) {
    return null;
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsxs)("div", {
    className: "googlesitekit-audience-selection-panel__success-notice",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)("div", {
      className: "googlesitekit-audience-selection-panel__success-notice-icon",
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(_svg_icons_check_fill_svg__WEBPACK_IMPORTED_MODULE_7__["default"], {
        width: 24,
        height: 24
      })
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)("p", {
      className: "googlesitekit-audience-selection-panel__success-notice-message",
      children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Visitor group created successfully!', 'google-site-kit')
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)("div", {
      className: "googlesitekit-audience-selection-panel__success-notice-actions",
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_6__.Button, {
        onClick: () => {
          (0,_js_util__WEBPACK_IMPORTED_MODULE_3__.trackEvent)(`${viewContext}_audiences-sidebar-create-audiences-success`, 'dismiss_notification').finally(() => {
            setValue(_constants__WEBPACK_IMPORTED_MODULE_4__.AUDIENCE_CREATION_SUCCESS_NOTICE_SLUG, false);
          });
        },
        tertiary: true,
        children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Got it', 'google-site-kit')
      })
    })]
  });
}

/***/ }),

/***/ "./js/modules/analytics-4/components/audience-segmentation/dashboard/AudienceSelectionPanel/AudienceItem.js":
/*!******************************************************************************************************************!*\
  !*** ./js/modules/analytics-4/components/audience-segmentation/dashboard/AudienceSelectionPanel/AudienceItem.js ***!
  \******************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ AudienceItem)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_13___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_13__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./constants */ "./js/modules/analytics-4/components/audience-segmentation/dashboard/AudienceSelectionPanel/constants.js");
/* harmony import */ var _js_googlesitekit_datastore_forms_constants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/googlesitekit/datastore/forms/constants */ "./js/googlesitekit/datastore/forms/constants.js");
/* harmony import */ var _js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/googlesitekit/datastore/user/constants */ "./js/googlesitekit/datastore/user/constants.js");
/* harmony import */ var _js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/modules/analytics-4/datastore/constants */ "./js/modules/analytics-4/datastore/constants.js");
/* harmony import */ var _js_util__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @/js/util */ "./js/util/index.js");
/* harmony import */ var _js_components_NewBadge__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @/js/components/NewBadge */ "./js/components/NewBadge.js");
/* harmony import */ var _js_components_SelectionPanel__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @/js/components/SelectionPanel */ "./js/components/SelectionPanel/index.js");
/* harmony import */ var _js_components_BadgeWithTooltip__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @/js/components/BadgeWithTooltip */ "./js/components/BadgeWithTooltip.js");
/* harmony import */ var _js_hooks_useFormValue__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @/js/hooks/useFormValue */ "./js/hooks/useFormValue.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Audience Selection Panel AudienceItem
 *
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */











function AudienceItem({
  slug,
  title,
  description,
  subtitle,
  userCount,
  audienceType
}) {
  const newBadgeSlug = `${_js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_5__.AUDIENCE_ITEM_NEW_BADGE_SLUG_PREFIX}${slug}`;
  const selectedItems = (0,_js_hooks_useFormValue__WEBPACK_IMPORTED_MODULE_10__["default"])(_constants__WEBPACK_IMPORTED_MODULE_2__.AUDIENCE_SELECTION_FORM, _constants__WEBPACK_IMPORTED_MODULE_2__.AUDIENCE_SELECTED);
  const hasNewBadgeBeenSeen = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_4__.CORE_USER).hasExpirableItem(newBadgeSlug));
  const isNewBadgeActive = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_4__.CORE_USER).isExpirableItemActive(newBadgeSlug));
  const [siteKitUserCountReportError, otherUserCountReportError] = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_5__.MODULES_ANALYTICS_4).getAudienceUserCountReportErrors()) || [];
  const errors = [];
  if (otherUserCountReportError) {
    errors.push(otherUserCountReportError);
  }
  if (siteKitUserCountReportError) {
    errors.push(siteKitUserCountReportError);
  }
  const {
    setValues
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useDispatch)(_js_googlesitekit_datastore_forms_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_FORMS);
  const temporarilyHidden = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_4__.CORE_USER).isItemDismissed(`audience-tile-${slug}`));
  const onCheckboxChange = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_12__.useCallback)(event => {
    setValues(_constants__WEBPACK_IMPORTED_MODULE_2__.AUDIENCE_SELECTION_FORM, {
      [_constants__WEBPACK_IMPORTED_MODULE_2__.AUDIENCE_SELECTED]: event.target.checked ? selectedItems.concat([slug]) : selectedItems.filter(selectedItem => selectedItem !== slug),
      [_constants__WEBPACK_IMPORTED_MODULE_2__.AUDIENCE_SELECTION_CHANGED]: true
    });
  }, [selectedItems, setValues, slug]);

  // Show the new badge if it has not been seen yet, or the badge has been
  // seen and is still active.
  const showNewBadge = 'DEFAULT_AUDIENCE' !== audienceType && (hasNewBadgeBeenSeen === false || isNewBadgeActive);
  const isItemSelected = selectedItems?.includes(slug);
  const id = `audience-selection-checkbox-${slug}`;
  function ItemBadge() {
    if (temporarilyHidden) {
      return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_js_components_BadgeWithTooltip__WEBPACK_IMPORTED_MODULE_9__["default"], {
        label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Temporarily hidden', 'google-site-kit'),
        tooltipTitle: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Site Kit is collecting data for this group. Once data is available the group will be added to your dashboard.', 'google-site-kit')
      });
    } else if (showNewBadge) {
      return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_js_components_NewBadge__WEBPACK_IMPORTED_MODULE_7__["default"], {});
    }
    return null;
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_js_components_SelectionPanel__WEBPACK_IMPORTED_MODULE_8__.SelectionPanelItem, {
    id: id,
    slug: slug,
    title: title,
    subtitle: subtitle,
    description: description,
    isItemSelected: isItemSelected,
    onCheckboxChange: onCheckboxChange,
    suffix: errors.length ? '-' : (0,_js_util__WEBPACK_IMPORTED_MODULE_6__.numFmt)(userCount),
    badge: (temporarilyHidden || showNewBadge) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(ItemBadge, {})
  });
}
AudienceItem.propTypes = {
  slug: (prop_types__WEBPACK_IMPORTED_MODULE_13___default().string).isRequired,
  title: (prop_types__WEBPACK_IMPORTED_MODULE_13___default().string).isRequired,
  description: (prop_types__WEBPACK_IMPORTED_MODULE_13___default().string).isRequired,
  subtitle: (prop_types__WEBPACK_IMPORTED_MODULE_13___default().string),
  userCount: (prop_types__WEBPACK_IMPORTED_MODULE_13___default().number).isRequired,
  audienceType: (prop_types__WEBPACK_IMPORTED_MODULE_13___default().string).isRequired
};

/***/ }),

/***/ "./js/modules/analytics-4/components/audience-segmentation/dashboard/AudienceSelectionPanel/AudienceItemPreviewBlock.js":
/*!******************************************************************************************************************************!*\
  !*** ./js/modules/analytics-4/components/audience-segmentation/dashboard/AudienceSelectionPanel/AudienceItemPreviewBlock.js ***!
  \******************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ AudienceItemPreviewBlock)
/* harmony export */ });
/* harmony import */ var _js_components_PreviewBlock__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @/js/components/PreviewBlock */ "./js/components/PreviewBlock.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * AudienceItemPreviewBlock component.
 *
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Internal dependencies
 */


function AudienceItemPreviewBlock() {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsxs)("div", {
    className: "googlesitekit-selection-panel__loading",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsxs)("div", {
      className: "googlesitekit-selection-panel__loading-left",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)(_js_components_PreviewBlock__WEBPACK_IMPORTED_MODULE_0__["default"], {
        width: "90px",
        height: "20px",
        className: "googlesitekit-selection-panel__loading-item"
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)(_js_components_PreviewBlock__WEBPACK_IMPORTED_MODULE_0__["default"], {
        width: "293px",
        height: "15px",
        className: "googlesitekit-selection-panel__loading-item"
      })]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", {
      className: "googlesitekit-selection-panel__loading-right",
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)(_js_components_PreviewBlock__WEBPACK_IMPORTED_MODULE_0__["default"], {
        width: "43px",
        height: "20px",
        className: "googlesitekit-selection-panel__loading-item"
      })
    })]
  });
}

/***/ }),

/***/ "./js/modules/analytics-4/components/audience-segmentation/dashboard/AudienceSelectionPanel/AudienceItems.js":
/*!*******************************************************************************************************************!*\
  !*** ./js/modules/analytics-4/components/audience-segmentation/dashboard/AudienceSelectionPanel/AudienceItems.js ***!
  \*******************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ AudienceItems)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_16___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_16__);
/* harmony import */ var react_use__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! react-use */ "../node_modules/react-use/esm/useDeepCompareEffect.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./constants */ "./js/modules/analytics-4/components/audience-segmentation/dashboard/AudienceSelectionPanel/constants.js");
/* harmony import */ var _js_googlesitekit_datastore_ui_constants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/googlesitekit/datastore/ui/constants */ "./js/googlesitekit/datastore/ui/constants.js");
/* harmony import */ var _js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/googlesitekit/datastore/user/constants */ "./js/googlesitekit/datastore/user/constants.js");
/* harmony import */ var _js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/modules/analytics-4/datastore/constants */ "./js/modules/analytics-4/datastore/constants.js");
/* harmony import */ var _js_util__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @/js/util */ "./js/util/index.js");
/* harmony import */ var _AudienceItem__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./AudienceItem */ "./js/modules/analytics-4/components/audience-segmentation/dashboard/AudienceSelectionPanel/AudienceItem.js");
/* harmony import */ var _js_components_SelectionPanel__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @/js/components/SelectionPanel */ "./js/components/SelectionPanel/index.js");
/* harmony import */ var _AudienceItemPreviewBlock__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./AudienceItemPreviewBlock */ "./js/modules/analytics-4/components/audience-segmentation/dashboard/AudienceSelectionPanel/AudienceItemPreviewBlock.js");
/* harmony import */ var _AddGroupNotice__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./AddGroupNotice */ "./js/modules/analytics-4/components/audience-segmentation/dashboard/AudienceSelectionPanel/AddGroupNotice.js");
/* harmony import */ var _js_hooks_useViewOnly__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @/js/hooks/useViewOnly */ "./js/hooks/useViewOnly.js");
/* harmony import */ var _AudienceCreationNotice__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ./AudienceCreationNotice */ "./js/modules/analytics-4/components/audience-segmentation/dashboard/AudienceSelectionPanel/AudienceCreationNotice.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Audience Selection Panel Audience Items
 *
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */













function AudienceItems({
  savedItemSlugs = []
}) {
  const [firstView, setFirstView] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_14__.useState)(true);
  const {
    setExpirableItemTimers
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useDispatch)(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_4__.CORE_USER);
  const {
    syncAvailableAudiences
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useDispatch)(_js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_5__.MODULES_ANALYTICS_4);
  const viewOnlyDashboard = (0,_js_hooks_useViewOnly__WEBPACK_IMPORTED_MODULE_11__["default"])();
  const isOpen = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_datastore_ui_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_UI).getValue(_constants__WEBPACK_IMPORTED_MODULE_2__.AUDIENCE_SELECTION_PANEL_OPENED_KEY));
  const isLoading = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_5__.MODULES_ANALYTICS_4).isFetchingSyncAvailableAudiences());
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_14__.useEffect)(() => {
    if (!firstView || !isOpen) {
      return;
    }
    async function syncAudiences() {
      await syncAvailableAudiences();
    }
    setFirstView(false);
    syncAudiences();
  }, [firstView, isOpen, syncAvailableAudiences]);
  const availableAudiences = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useInViewSelect)(select => {
    const {
      getConfigurableAudiences,
      getReport,
      getAudiencesUserCountReportOptions,
      getConfigurableSiteKitAndOtherAudiences,
      hasAudiencePartialData
    } = select(_js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_5__.MODULES_ANALYTICS_4);
    const audiences = getConfigurableAudiences();
    if (undefined === audiences) {
      return undefined;
    }
    if (!audiences.length) {
      return [];
    }

    // eslint-disable-next-line @wordpress/no-unused-vars-before-return -- We might return before `otherAudiences` is used.
    const [siteKitAudiences, otherAudiences] = getConfigurableSiteKitAndOtherAudiences();
    const isSiteKitAudiencePartialData = hasAudiencePartialData(siteKitAudiences);
    const dateRangeDates = select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_4__.CORE_USER).getDateRangeDates({
      offsetDays: _js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_5__.DATE_RANGE_OFFSET
    });

    // Get the user count for the available Site Kit audiences using the `newVsReturning` dimension
    // to avoid the partial data state for these audiences.
    const newVsReturningReport = isSiteKitAudiencePartialData && getReport({
      ...dateRangeDates,
      metrics: [{
        name: 'totalUsers'
      }],
      dimensions: [{
        name: 'newVsReturning'
      }],
      reportID: 'audience-segmentation_audience-items_component_newVsReturningReport'
    });

    // Get the user count for the available audiences using the `audienceResourceName` dimension.
    const audienceResourceNameReport = isSiteKitAudiencePartialData === false || isSiteKitAudiencePartialData === true && otherAudiences?.length > 0 ? getReport(getAudiencesUserCountReportOptions(isSiteKitAudiencePartialData ? otherAudiences : audiences)) : {};
    const {
      rows: newVsReturningRows = []
    } = newVsReturningReport || {};
    const {
      rows: audienceResourceNameRows = []
    } = audienceResourceNameReport || {};
    function findAudienceRow(rows, dimensionValue) {
      return rows.find(row => row?.dimensionValues?.[0]?.value === dimensionValue);
    }
    return audiences.map(audience => {
      let audienceRow;
      if (audience.audienceType === 'SITE_KIT_AUDIENCE' && isSiteKitAudiencePartialData) {
        audienceRow = findAudienceRow(newVsReturningRows, audience.audienceSlug === 'new-visitors' ? 'new' : 'returning');
      } else {
        audienceRow = findAudienceRow(audienceResourceNameRows, audience.name);
      }
      return {
        ...audience,
        userCount: Number(audienceRow?.metricValues?.[0]?.value) || 0
      };
    });
  });
  function audiencesListReducer(acc, {
    audienceType,
    description,
    displayName,
    name,
    userCount
  }) {
    let citation = '';
    switch (audienceType) {
      case 'DEFAULT_AUDIENCE':
        citation = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Created by default by Google Analytics', 'google-site-kit');
        description = '';
        break;
      case 'SITE_KIT_AUDIENCE':
        citation = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Created by Site Kit', 'google-site-kit');
        break;
      case 'USER_AUDIENCE':
        citation = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Already exists in your Analytics property', 'google-site-kit');
        break;
    }
    return {
      ...acc,
      [name]: {
        title: displayName,
        subtitle: description,
        description: citation,
        userCount,
        audienceType
      }
    };
  }
  const availableSavedItems = availableAudiences?.filter(({
    name
  }) => savedItemSlugs.includes(name)).reduce(audiencesListReducer, {});
  const availableUnsavedItems = availableAudiences?.filter(({
    name
  }) => !savedItemSlugs.includes(name)).reduce(audiencesListReducer, {});
  const newBadgesToActivate = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => {
    if (undefined === availableAudiences) {
      return undefined;
    }
    const {
      hasFinishedResolution,
      hasExpirableItem
    } = select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_4__.CORE_USER);
    if (!hasFinishedResolution('getExpirableItems')) {
      return undefined;
    }
    return availableAudiences.filter(({
      audienceType,
      name
    }) => {
      // Only activate if it is not a default audience, the badge is
      // new and the user is viewing it for the first time.
      return 'DEFAULT_AUDIENCE' !== audienceType && !hasExpirableItem(`${_js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_5__.AUDIENCE_ITEM_NEW_BADGE_SLUG_PREFIX}${name}`);
    }).map(({
      name
    }) => {
      return `${_js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_5__.AUDIENCE_ITEM_NEW_BADGE_SLUG_PREFIX}${name}`;
    });
  });

  // Set an expiry for the new badges so that it is no longer shown after
  // a certain time.
  // `useDeepCompareEffect` is used here instead of `useEffect` because
  // the array reference of `newBadgesToActivate` is not reliable and can
  // cause the effect to unexpectedly run multiple times.
  (0,react_use__WEBPACK_IMPORTED_MODULE_15__["default"])(() => {
    if (isOpen &&
    // Only activate when the badge is viewed, i.e. the panel is opened.
    newBadgesToActivate !== undefined && newBadgesToActivate.length) {
      setExpirableItemTimers(newBadgesToActivate.map(slug => ({
        slug,
        expiresInSeconds: _js_util__WEBPACK_IMPORTED_MODULE_6__.WEEK_IN_SECONDS * 4
      })));
    }
  }, [isOpen, setExpirableItemTimers, newBadgesToActivate]);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx)(_js_components_SelectionPanel__WEBPACK_IMPORTED_MODULE_8__.SelectionPanelItems, {
    availableItemsTitle: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Additional groups', 'google-site-kit'),
    availableSavedItems: availableSavedItems,
    availableUnsavedItems: availableUnsavedItems,
    ItemComponent: isLoading ? _AudienceItemPreviewBlock__WEBPACK_IMPORTED_MODULE_9__["default"] : _AudienceItem__WEBPACK_IMPORTED_MODULE_7__["default"],
    savedItemSlugs: savedItemSlugs,
    notice: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsxs)(_wordpress_element__WEBPACK_IMPORTED_MODULE_14__.Fragment, {
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx)(_AddGroupNotice__WEBPACK_IMPORTED_MODULE_10__["default"], {}), !viewOnlyDashboard && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx)(_AudienceCreationNotice__WEBPACK_IMPORTED_MODULE_12__["default"], {})]
    })
  });
}
AudienceItems.propTypes = {
  savedItemSlugs: (prop_types__WEBPACK_IMPORTED_MODULE_16___default().array)
};

/***/ }),

/***/ "./js/modules/analytics-4/components/audience-segmentation/dashboard/AudienceSelectionPanel/Footer.js":
/*!************************************************************************************************************!*\
  !*** ./js/modules/analytics-4/components/audience-segmentation/dashboard/AudienceSelectionPanel/Footer.js ***!
  \************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Footer)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_11___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_11__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/hooks/useViewContext */ "./js/hooks/useViewContext.js");
/* harmony import */ var _js_util__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/util */ "./js/util/index.js");
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./constants */ "./js/modules/analytics-4/components/audience-segmentation/dashboard/AudienceSelectionPanel/constants.js");
/* harmony import */ var _js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/googlesitekit/datastore/user/constants */ "./js/googlesitekit/datastore/user/constants.js");
/* harmony import */ var _js_googlesitekit_datastore_forms_constants__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/googlesitekit/datastore/forms/constants */ "./js/googlesitekit/datastore/forms/constants.js");
/* harmony import */ var _js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @/js/modules/analytics-4/datastore/constants */ "./js/modules/analytics-4/datastore/constants.js");
/* harmony import */ var _js_components_SelectionPanel__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @/js/components/SelectionPanel */ "./js/components/SelectionPanel/index.js");
/* harmony import */ var _js_hooks_useFormValue__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @/js/hooks/useFormValue */ "./js/hooks/useFormValue.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Audience Selection Panel Footer
 *
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */










function Footer({
  isOpen,
  closePanel,
  savedItemSlugs
}) {
  const viewContext = (0,_js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_1__["default"])();
  const selectedItems = (0,_js_hooks_useFormValue__WEBPACK_IMPORTED_MODULE_8__["default"])(_constants__WEBPACK_IMPORTED_MODULE_3__.AUDIENCE_SELECTION_FORM, _constants__WEBPACK_IMPORTED_MODULE_3__.AUDIENCE_SELECTED);
  const {
    setValues
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useDispatch)(_js_googlesitekit_datastore_forms_constants__WEBPACK_IMPORTED_MODULE_5__.CORE_FORMS);
  const isSavingSettings = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useSelect)(select => select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_4__.CORE_USER).isSavingUserAudienceSettings());
  const hiddenTileDismissedItems = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useInViewSelect)(select => {
    const dismissedItems = select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_4__.CORE_USER).getDismissedItems();
    return dismissedItems?.filter(item => item.startsWith('audience-tile-'));
  });
  const availableAudiences = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useSelect)(select => select(_js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_6__.MODULES_ANALYTICS_4).getOrSyncAvailableAudiences());
  const {
    saveUserAudienceSettings,
    removeDismissedItems
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useDispatch)(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_4__.CORE_USER);
  const {
    getConfiguredAudiences
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useSelect)(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_4__.CORE_USER);
  const saveSettings = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_10__.useCallback)(async selectedAudiences => {
    setValues(_constants__WEBPACK_IMPORTED_MODULE_3__.AUDIENCE_SELECTION_FORM, {
      [_constants__WEBPACK_IMPORTED_MODULE_3__.AUDIENCE_SELECTION_DISMISSED_ITEMS_ERROR_SLUG]: null
    });
    let {
      error
    } = await saveUserAudienceSettings({
      configuredAudiences: selectedAudiences
    });
    if (!error) {
      // Determine the list of hidden audiences that have been unselected and need their dismissed state to be cleared.
      const hiddenAudienceDismissedItemsToClear = hiddenTileDismissedItems?.filter(item => {
        const audienceResourceName = item.replace('audience-tile-', '');
        return !selectedAudiences.includes(audienceResourceName);
      }) || [];

      // If all configured audiences are hidden, clear the dismissed state for the first one to unhide it
      if (selectedAudiences.every(audienceResourceName => hiddenTileDismissedItems?.includes(`audience-tile-${audienceResourceName}`))) {
        hiddenAudienceDismissedItemsToClear.push(`audience-tile-${selectedAudiences[0]}`);
      }
      if (hiddenAudienceDismissedItemsToClear?.length > 0) {
        ({
          error
        } = await removeDismissedItems(...hiddenAudienceDismissedItemsToClear));
        if (error) {
          setValues(_constants__WEBPACK_IMPORTED_MODULE_3__.AUDIENCE_SELECTION_FORM, {
            [_constants__WEBPACK_IMPORTED_MODULE_3__.AUDIENCE_SELECTION_DISMISSED_ITEMS_ERROR_SLUG]: error
          });
        }
      }
    }
    return {
      error
    };
  }, [hiddenTileDismissedItems, removeDismissedItems, saveUserAudienceSettings, setValues]);
  const onSaveSuccess = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_10__.useCallback)(() => {
    const audienceTypeLabels = {
      USER_AUDIENCE: 'user',
      SITE_KIT_AUDIENCE: 'site-kit',
      DEFAULT_AUDIENCE: 'default'
    };

    // Call to the selector within the callback ensures that the latest
    // value is used.
    const configuredAudiences = getConfiguredAudiences();
    const eventLabel = Object.keys(audienceTypeLabels).map(type => {
      const audiencesOfType = configuredAudiences.filter(audienceName => {
        const audience = availableAudiences?.find(({
          name
        }) => audienceName === name);
        return audience?.audienceType === type;
      });
      return `${audienceTypeLabels[type]}:${audiencesOfType.length}`;
    }).join(',');
    (0,_js_util__WEBPACK_IMPORTED_MODULE_2__.trackEvent)(`${viewContext}_audiences-sidebar`, 'audiences_sidebar_save', eventLabel);
  }, [availableAudiences, getConfiguredAudiences, viewContext]);
  const onCancel = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_10__.useCallback)(() => {
    (0,_js_util__WEBPACK_IMPORTED_MODULE_2__.trackEvent)(`${viewContext}_audiences-sidebar`, 'audiences_sidebar_cancel');
  }, [viewContext]);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)(_js_components_SelectionPanel__WEBPACK_IMPORTED_MODULE_7__.SelectionPanelFooter, {
    savedItemSlugs: savedItemSlugs,
    selectedItemSlugs: selectedItems,
    saveSettings: saveSettings,
    minSelectedItemCount: _constants__WEBPACK_IMPORTED_MODULE_3__.MIN_SELECTED_AUDIENCES_COUNT,
    maxSelectedItemCount: _constants__WEBPACK_IMPORTED_MODULE_3__.MAX_SELECTED_AUDIENCES_COUNT,
    isBusy: isSavingSettings,
    isOpen: isOpen,
    closePanel: closePanel,
    onSaveSuccess: onSaveSuccess,
    onCancel: onCancel
  });
}
Footer.propTypes = {
  isOpen: (prop_types__WEBPACK_IMPORTED_MODULE_11___default().bool),
  closePanel: (prop_types__WEBPACK_IMPORTED_MODULE_11___default().func).isRequired,
  savedItemSlugs: (prop_types__WEBPACK_IMPORTED_MODULE_11___default().array)
};

/***/ }),

/***/ "./js/modules/analytics-4/components/audience-segmentation/dashboard/AudienceSelectionPanel/Header.js":
/*!************************************************************************************************************!*\
  !*** ./js/modules/analytics-4/components/audience-segmentation/dashboard/AudienceSelectionPanel/Header.js ***!
  \************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Header)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_12___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_12__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/@wordpress/element/build-module/create-interpolate-element.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _js_googlesitekit_datastore_location_constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/googlesitekit/datastore/location/constants */ "./js/googlesitekit/datastore/location/constants.js");
/* harmony import */ var _js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/googlesitekit/datastore/site/constants */ "./js/googlesitekit/datastore/site/constants.js");
/* harmony import */ var _js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/googlesitekit/datastore/user/constants */ "./js/googlesitekit/datastore/user/constants.js");
/* harmony import */ var _js_hooks_useViewOnly__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/hooks/useViewOnly */ "./js/hooks/useViewOnly.js");
/* harmony import */ var _js_components_Link__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @/js/components/Link */ "./js/components/Link.js");
/* harmony import */ var _js_components_Typography_P__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @/js/components/Typography/P */ "./js/components/Typography/P.js");
/* harmony import */ var _js_components_SelectionPanel__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @/js/components/SelectionPanel */ "./js/components/SelectionPanel/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Audience Selection Panel Header
 *
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */









function Header({
  closePanel
}) {
  const isViewOnly = (0,_js_hooks_useViewOnly__WEBPACK_IMPORTED_MODULE_5__["default"])();
  const adminSettingsURL = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_SITE).getSiteKitAdminSettingsURL({
    scrollTo: 'visitor-groups'
  }));
  const isSavingSettings = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_4__.CORE_USER).isSavingUserAudienceSettings());
  const {
    navigateTo
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useDispatch)(_js_googlesitekit_datastore_location_constants__WEBPACK_IMPORTED_MODULE_2__.CORE_LOCATION);
  const onSettingsClick = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_10__.useCallback)(() => navigateTo(adminSettingsURL), [adminSettingsURL, navigateTo]);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)(_js_components_SelectionPanel__WEBPACK_IMPORTED_MODULE_8__.SelectionPanelHeader, {
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Select visitor groups', 'google-site-kit'),
    onCloseClick: closePanel,
    children: !isViewOnly && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)(_js_components_Typography_P__WEBPACK_IMPORTED_MODULE_7__["default"], {
      children: (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_11__["default"])((0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('You can deactivate this widget in <link><strong>Settings</strong></link>', 'google-site-kit'), {
        link: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)(_js_components_Link__WEBPACK_IMPORTED_MODULE_6__["default"], {
          onClick: onSettingsClick,
          disabled: isSavingSettings,
          secondary: true
        }),
        strong: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)("strong", {})
      })
    })
  });
}
Header.propTypes = {
  closePanel: (prop_types__WEBPACK_IMPORTED_MODULE_12___default().func).isRequired
};

/***/ }),

/***/ "./js/modules/analytics-4/components/audience-segmentation/dashboard/AudienceSelectionPanel/LearnMoreLink.js":
/*!*******************************************************************************************************************!*\
  !*** ./js/modules/analytics-4/components/audience-segmentation/dashboard/AudienceSelectionPanel/LearnMoreLink.js ***!
  \*******************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ LearnMoreLink)
/* harmony export */ });
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/@wordpress/element/build-module/create-interpolate-element.js");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/googlesitekit/datastore/site/constants */ "./js/googlesitekit/datastore/site/constants.js");
/* harmony import */ var _js_components_Link__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/components/Link */ "./js/components/Link.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Audience Selection Panel Learn More Link
 *
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */




function LearnMoreLink() {
  const audienceLearnMoreURL = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_2__.CORE_SITE).getGoogleSupportURL({
    path: '/analytics/answer/12799087'
  }));
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("div", {
    className: "googlesitekit-audience-selection-panel__learn-more",
    children: (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_5__["default"])((0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Learn more about grouping site visitors and audiences in <link><strong>Analytics</strong></link>', 'google-site-kit'), {
      link: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(_js_components_Link__WEBPACK_IMPORTED_MODULE_3__["default"], {
        href: audienceLearnMoreURL,
        secondary: true,
        external: true
      }),
      strong: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("strong", {})
    })
  });
}

/***/ }),

/***/ "./js/modules/analytics-4/components/audience-segmentation/dashboard/AudienceSelectionPanel/Panel.js":
/*!***********************************************************************************************************!*\
  !*** ./js/modules/analytics-4/components/audience-segmentation/dashboard/AudienceSelectionPanel/Panel.js ***!
  \***********************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Panel)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/hooks/useViewContext */ "./js/hooks/useViewContext.js");
/* harmony import */ var _js_util__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/util */ "./js/util/index.js");
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./constants */ "./js/modules/analytics-4/components/audience-segmentation/dashboard/AudienceSelectionPanel/constants.js");
/* harmony import */ var _js_googlesitekit_datastore_forms_constants__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/googlesitekit/datastore/forms/constants */ "./js/googlesitekit/datastore/forms/constants.js");
/* harmony import */ var _js_googlesitekit_datastore_ui_constants__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/googlesitekit/datastore/ui/constants */ "./js/googlesitekit/datastore/ui/constants.js");
/* harmony import */ var _js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @/js/googlesitekit/datastore/user/constants */ "./js/googlesitekit/datastore/user/constants.js");
/* harmony import */ var _js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @/js/modules/analytics-4/datastore/constants */ "./js/modules/analytics-4/datastore/constants.js");
/* harmony import */ var _AudienceItems__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./AudienceItems */ "./js/modules/analytics-4/components/audience-segmentation/dashboard/AudienceSelectionPanel/AudienceItems.js");
/* harmony import */ var _SyncErrorNotice__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./SyncErrorNotice */ "./js/modules/analytics-4/components/audience-segmentation/dashboard/AudienceSelectionPanel/SyncErrorNotice.js");
/* harmony import */ var _Footer__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./Footer */ "./js/modules/analytics-4/components/audience-segmentation/dashboard/AudienceSelectionPanel/Footer.js");
/* harmony import */ var _Header__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./Header */ "./js/modules/analytics-4/components/audience-segmentation/dashboard/AudienceSelectionPanel/Header.js");
/* harmony import */ var _LearnMoreLink__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ./LearnMoreLink */ "./js/modules/analytics-4/components/audience-segmentation/dashboard/AudienceSelectionPanel/LearnMoreLink.js");
/* harmony import */ var _js_components_SelectionPanel__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! @/js/components/SelectionPanel */ "./js/components/SelectionPanel/index.js");
/* harmony import */ var _AudienceCreationSuccessNotice__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ./AudienceCreationSuccessNotice */ "./js/modules/analytics-4/components/audience-segmentation/dashboard/AudienceSelectionPanel/AudienceCreationSuccessNotice.js");
/* harmony import */ var _js_hooks_useFormValue__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! @/js/hooks/useFormValue */ "./js/hooks/useFormValue.js");
/* harmony import */ var _SaveErrorNotice__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ./SaveErrorNotice */ "./js/modules/analytics-4/components/audience-segmentation/dashboard/AudienceSelectionPanel/SaveErrorNotice.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Audience Selection Panel
 *
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */


















function Panel() {
  const viewContext = (0,_js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_1__["default"])();
  const isOpen = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useSelect)(select => select(_js_googlesitekit_datastore_ui_constants__WEBPACK_IMPORTED_MODULE_5__.CORE_UI).getValue(_constants__WEBPACK_IMPORTED_MODULE_3__.AUDIENCE_SELECTION_PANEL_OPENED_KEY));
  const isLoading = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useSelect)(select => select(_js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_7__.MODULES_ANALYTICS_4).isFetchingSyncAvailableAudiences());
  const savedItemSlugs = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useInViewSelect)(select => {
    const {
      getConfigurableAudiences
    } = select(_js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_7__.MODULES_ANALYTICS_4);
    const {
      getConfiguredAudiences
    } = select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_6__.CORE_USER);
    const configuredAudiences = getConfiguredAudiences() || [];
    const configurableAudiences = getConfigurableAudiences() || [];
    if (!configurableAudiences.length || !configuredAudiences.length) {
      return [];
    }
    return configurableAudiences.filter(({
      name
    }) => configuredAudiences.includes(name)).map(({
      name
    }) => name);
  });
  const isCreatingAudienceFromOAuth = (0,_js_hooks_useFormValue__WEBPACK_IMPORTED_MODULE_15__["default"])(_constants__WEBPACK_IMPORTED_MODULE_3__.AUDIENCE_CREATION_FORM, 'autoSubmit');
  const {
    setValues
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useDispatch)(_js_googlesitekit_datastore_forms_constants__WEBPACK_IMPORTED_MODULE_4__.CORE_FORMS);
  const {
    setValue
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useDispatch)(_js_googlesitekit_datastore_ui_constants__WEBPACK_IMPORTED_MODULE_5__.CORE_UI);
  const onSideSheetOpen = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_18__.useCallback)(() => {
    setValues(_constants__WEBPACK_IMPORTED_MODULE_3__.AUDIENCE_SELECTION_FORM, {
      [_constants__WEBPACK_IMPORTED_MODULE_3__.AUDIENCE_SELECTED]: savedItemSlugs,
      [_constants__WEBPACK_IMPORTED_MODULE_3__.AUDIENCE_SELECTION_CHANGED]: false
    });
    (0,_js_util__WEBPACK_IMPORTED_MODULE_2__.trackEvent)(`${viewContext}_audiences-sidebar`, 'audiences_sidebar_view');
  }, [savedItemSlugs, setValues, viewContext]);
  const closePanel = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_18__.useCallback)(() => {
    if (isOpen) {
      setValue(_constants__WEBPACK_IMPORTED_MODULE_3__.AUDIENCE_SELECTION_PANEL_OPENED_KEY, false);
      setValue(_constants__WEBPACK_IMPORTED_MODULE_3__.AUDIENCE_CREATION_SUCCESS_NOTICE_SLUG, false);
    }
  }, [setValue, isOpen]);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_17__.jsxs)(_js_components_SelectionPanel__WEBPACK_IMPORTED_MODULE_13__["default"], {
    className: "googlesitekit-audience-selection-panel",
    closePanel: closePanel,
    isOpen: isOpen || isCreatingAudienceFromOAuth,
    isLoading: isLoading,
    onOpen: onSideSheetOpen,
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_17__.jsx)(_Header__WEBPACK_IMPORTED_MODULE_11__["default"], {
      closePanel: closePanel
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_17__.jsx)(_AudienceItems__WEBPACK_IMPORTED_MODULE_8__["default"], {
      savedItemSlugs: savedItemSlugs
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_17__.jsx)(_LearnMoreLink__WEBPACK_IMPORTED_MODULE_12__["default"], {}), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_17__.jsx)(_SaveErrorNotice__WEBPACK_IMPORTED_MODULE_16__["default"], {
      savedItemSlugs: savedItemSlugs
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_17__.jsx)(_SyncErrorNotice__WEBPACK_IMPORTED_MODULE_9__["default"], {}), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_17__.jsx)(_AudienceCreationSuccessNotice__WEBPACK_IMPORTED_MODULE_14__["default"], {}), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_17__.jsx)(_Footer__WEBPACK_IMPORTED_MODULE_10__["default"], {
      closePanel: closePanel,
      isOpen: isOpen,
      savedItemSlugs: savedItemSlugs
    })]
  });
}

/***/ }),

/***/ "./js/modules/analytics-4/components/audience-segmentation/dashboard/AudienceSelectionPanel/RequestAccessButton.js":
/*!*************************************************************************************************************************!*\
  !*** ./js/modules/analytics-4/components/audience-segmentation/dashboard/AudienceSelectionPanel/RequestAccessButton.js ***!
  \*************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ RequestAccessButton)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-components */ "googlesitekit-components");
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _js_util__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/util */ "./js/util/index.js");
/* harmony import */ var _js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/hooks/useViewContext */ "./js/hooks/useViewContext.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Audience Selection Panel Request Access Button
 *
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */




function RequestAccessButton({
  requestAccessURL
}) {
  const viewContext = (0,_js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_3__["default"])();
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__.Button, {
    className: "googlesitekit-audience-selection-panel__error-notice-action",
    href: requestAccessURL,
    target: "_blank",
    onClick: () => {
      (0,_js_util__WEBPACK_IMPORTED_MODULE_2__.trackEvent)(`${viewContext}_audiences-sidebar`, 'insufficient_permissions_error_request_access');
    },
    tertiary: true,
    children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Request access', 'google-site-kit')
  });
}
RequestAccessButton.propTypes = {
  requestAccessURL: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().string).isRequired
};

/***/ }),

/***/ "./js/modules/analytics-4/components/audience-segmentation/dashboard/AudienceSelectionPanel/RetryButton.js":
/*!*****************************************************************************************************************!*\
  !*** ./js/modules/analytics-4/components/audience-segmentation/dashboard/AudienceSelectionPanel/RetryButton.js ***!
  \*****************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ RetryButton)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-components */ "googlesitekit-components");
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _js_util__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/util */ "./js/util/index.js");
/* harmony import */ var _js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/hooks/useViewContext */ "./js/hooks/useViewContext.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Audience Selection Panel Retry Button
 *
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */




function RetryButton({
  handleRetry
}) {
  const viewContext = (0,_js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_3__["default"])();
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__.Button, {
    className: "googlesitekit-audience-selection-panel__error-notice-action",
    onClick: () => {
      handleRetry();
      (0,_js_util__WEBPACK_IMPORTED_MODULE_2__.trackEvent)(`${viewContext}_audiences-sidebar`, 'data_loading_error_retry');
    },
    tertiary: true,
    children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Retry', 'google-site-kit')
  });
}
RetryButton.propTypes = {
  handleRetry: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().func).isRequired
};

/***/ }),

/***/ "./js/modules/analytics-4/components/audience-segmentation/dashboard/AudienceSelectionPanel/SaveErrorNotice.js":
/*!*********************************************************************************************************************!*\
  !*** ./js/modules/analytics-4/components/audience-segmentation/dashboard/AudienceSelectionPanel/SaveErrorNotice.js ***!
  \*********************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ SaveErrorNotice)
/* harmony export */ });
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _js_googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/googlesitekit-data */ "./js/googlesitekit-data.js");
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./constants */ "./js/modules/analytics-4/components/audience-segmentation/dashboard/AudienceSelectionPanel/constants.js");
/* harmony import */ var _js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/googlesitekit/datastore/user/constants */ "./js/googlesitekit/datastore/user/constants.js");
/* harmony import */ var _js_hooks_useFormValue__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/hooks/useFormValue */ "./js/hooks/useFormValue.js");
/* harmony import */ var _js_components_SelectionPanel_SelectionPanelError__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/components/SelectionPanel/SelectionPanelError */ "./js/components/SelectionPanel/SelectionPanelError.js");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! lodash */ "../node_modules/lodash/lodash.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var _js_util__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @/js/util */ "./js/util/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Audience Selection Panel Selected Item Count Error Notice
 *
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */









function SaveErrorNotice({
  savedItemSlugs
}) {
  const selectedItems = (0,_js_hooks_useFormValue__WEBPACK_IMPORTED_MODULE_4__["default"])(_constants__WEBPACK_IMPORTED_MODULE_2__.AUDIENCE_SELECTION_FORM, _constants__WEBPACK_IMPORTED_MODULE_2__.AUDIENCE_SELECTED);
  const dismissedItemsError = (0,_js_hooks_useFormValue__WEBPACK_IMPORTED_MODULE_4__["default"])(_constants__WEBPACK_IMPORTED_MODULE_2__.AUDIENCE_SELECTION_FORM, _constants__WEBPACK_IMPORTED_MODULE_2__.AUDIENCE_SELECTION_DISMISSED_ITEMS_ERROR_SLUG);
  const audienceSettings = (0,_js_googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useInViewSelect)(select => select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_USER).getUserAudienceSettings());
  const saveError = (0,_js_googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_USER).getErrorForAction('saveUserAudienceSettings', [{
    ...audienceSettings,
    configuredAudiences: selectedItems
  }]));
  const selectedItemsCount = selectedItems?.length || 0;
  let itemLimitError;
  if (selectedItemsCount < _constants__WEBPACK_IMPORTED_MODULE_2__.MIN_SELECTED_AUDIENCES_COUNT) {
    itemLimitError = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.sprintf)(/* translators: 1: Minimum number of groups that can be selected. 2: Number of selected groups. */
    (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__._n)('Select at least %1$d group (%2$d selected)', 'Select at least %1$d groups (%2$d selected)', _constants__WEBPACK_IMPORTED_MODULE_2__.MIN_SELECTED_AUDIENCES_COUNT, 'google-site-kit'), _constants__WEBPACK_IMPORTED_MODULE_2__.MIN_SELECTED_AUDIENCES_COUNT, selectedItemsCount);
  } else if (selectedItemsCount > _constants__WEBPACK_IMPORTED_MODULE_2__.MAX_SELECTED_AUDIENCES_COUNT) {
    itemLimitError = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.sprintf)(/* translators: 1: Maximum number of groups that can be selected. 2: Number of selected groups. */
    (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Select up to %1$d groups (%2$d selected)', 'google-site-kit'), _constants__WEBPACK_IMPORTED_MODULE_2__.MAX_SELECTED_AUDIENCES_COUNT, selectedItemsCount);
  }
  const haveSettingsChanged = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.useMemo)(() => {
    // Arrays need to be sorted to match in `isEqual`.
    return !(0,lodash__WEBPACK_IMPORTED_MODULE_6__.isEqual)((0,_js_util__WEBPACK_IMPORTED_MODULE_7__.safelySort)(selectedItems), (0,_js_util__WEBPACK_IMPORTED_MODULE_7__.safelySort)(savedItemSlugs));
  }, [selectedItems, savedItemSlugs]);
  if (!itemLimitError && !saveError && !dismissedItemsError) {
    return null;
  }
  let error = saveError || dismissedItemsError;
  if (haveSettingsChanged && itemLimitError) {
    error = {
      message: itemLimitError
    };
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(_js_components_SelectionPanel_SelectionPanelError__WEBPACK_IMPORTED_MODULE_5__["default"], {
    error: error
  });
}

/***/ }),

/***/ "./js/modules/analytics-4/components/audience-segmentation/dashboard/AudienceSelectionPanel/SyncErrorNotice.js":
/*!*********************************************************************************************************************!*\
  !*** ./js/modules/analytics-4/components/audience-segmentation/dashboard/AudienceSelectionPanel/SyncErrorNotice.js ***!
  \*********************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ SyncErrorNotice)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/@wordpress/element/build-module/create-interpolate-element.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/hooks/useViewContext */ "./js/hooks/useViewContext.js");
/* harmony import */ var _js_util__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/util */ "./js/util/index.js");
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./constants */ "./js/modules/analytics-4/components/audience-segmentation/dashboard/AudienceSelectionPanel/constants.js");
/* harmony import */ var _js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/googlesitekit/datastore/site/constants */ "./js/googlesitekit/datastore/site/constants.js");
/* harmony import */ var _js_googlesitekit_datastore_ui_constants__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @/js/googlesitekit/datastore/ui/constants */ "./js/googlesitekit/datastore/ui/constants.js");
/* harmony import */ var _js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @/js/modules/analytics-4/datastore/constants */ "./js/modules/analytics-4/datastore/constants.js");
/* harmony import */ var _js_util_errors__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @/js/util/errors */ "./js/util/errors.js");
/* harmony import */ var _js_components_Link__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @/js/components/Link */ "./js/components/Link.js");
/* harmony import */ var _js_components_ReportErrorActions__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @/js/components/ReportErrorActions */ "./js/components/ReportErrorActions.js");
/* harmony import */ var _RequestAccessButton__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./RequestAccessButton */ "./js/modules/analytics-4/components/audience-segmentation/dashboard/AudienceSelectionPanel/RequestAccessButton.js");
/* harmony import */ var _RetryButton__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ./RetryButton */ "./js/modules/analytics-4/components/audience-segmentation/dashboard/AudienceSelectionPanel/RetryButton.js");
/* harmony import */ var _js_components_Notice__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! @/js/components/Notice */ "./js/components/Notice/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Audience Selection Panel Error Notice
 *
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */














function SyncErrorNotice() {
  const viewContext = (0,_js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_2__["default"])();
  const syncAvailableAudiencesError = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_7__.MODULES_ANALYTICS_4).getErrorForAction('syncAvailableAudiences'));
  const [siteKitUserCountReportError, otherUserCountReportError] = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useInViewSelect)(select => select(_js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_7__.MODULES_ANALYTICS_4).getAudienceUserCountReportErrors()) || [];
  const helpLink = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_5__.CORE_SITE).getErrorTroubleshootingLinkURL({
    code: 'analytics-4_insufficient_permissions'
  }));
  const isOpen = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_datastore_ui_constants__WEBPACK_IMPORTED_MODULE_6__.CORE_UI).getValue(_constants__WEBPACK_IMPORTED_MODULE_4__.AUDIENCE_SELECTION_PANEL_OPENED_KEY));
  const {
    clearError,
    syncAvailableAudiences
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useDispatch)(_js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_7__.MODULES_ANALYTICS_4);
  const retrySyncAvailableAudiences = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_15__.useCallback)(async () => {
    await clearError('syncAvailableAudiences');
    syncAvailableAudiences();
  }, [clearError, syncAvailableAudiences]);
  const errors = [];
  if (syncAvailableAudiencesError) {
    errors.push(syncAvailableAudiencesError);
  }
  if (otherUserCountReportError) {
    errors.push(otherUserCountReportError);
  }
  if (siteKitUserCountReportError) {
    errors.push(siteKitUserCountReportError);
  }
  const hasErrors = errors.length > 0;
  const hasInsufficientPermissionsError = errors.some(error => (0,_js_util_errors__WEBPACK_IMPORTED_MODULE_8__.isInsufficientPermissionsError)(error));

  // Track an event when the error notice is displayed.
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_15__.useEffect)(() => {
    if (!isOpen || !hasErrors) {
      return;
    }
    (0,_js_util__WEBPACK_IMPORTED_MODULE_3__.trackEvent)(`${viewContext}_audiences-sidebar`, hasInsufficientPermissionsError ? 'insufficient_permissions_error' : 'data_loading_error');
  }, [hasErrors, hasInsufficientPermissionsError, isOpen, viewContext]);
  if (!errors.length) {
    return null;
  }
  const userCountError = [otherUserCountReportError, siteKitUserCountReportError].some(error => !!error);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14__.jsx)(_js_components_Notice__WEBPACK_IMPORTED_MODULE_13__["default"], {
    className: "googlesitekit-audience-selection-panel__error-notice googlesitekit-notice--error googlesitekit-notice--small googlesitekit-notice--square",
    type: _js_components_Notice__WEBPACK_IMPORTED_MODULE_13__["default"].TYPES.ERROR,
    description: hasInsufficientPermissionsError ? (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_16__["default"])((0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Insufficient permissions, contact your administrator. Trouble getting access? <HelpLink />', 'google-site-kit'), {
      HelpLink: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14__.jsx)(_js_components_Link__WEBPACK_IMPORTED_MODULE_9__["default"], {
        href: helpLink,
        external: true,
        hideExternalIndicator: true,
        children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Get help', 'google-site-kit')
      })
    }) : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Data loading failed', 'google-site-kit'),
    hideIcon: true,
    children: hasInsufficientPermissionsError || userCountError ? /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14__.jsx)(_js_components_ReportErrorActions__WEBPACK_IMPORTED_MODULE_10__["default"], {
      moduleSlug: "analytics-4",
      error: errors,
      buttonVariant: "danger",
      RequestAccessButton: _RequestAccessButton__WEBPACK_IMPORTED_MODULE_11__["default"],
      RetryButton: _RetryButton__WEBPACK_IMPORTED_MODULE_12__["default"],
      hideGetHelpLink: true
    }) : /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14__.jsx)(_RetryButton__WEBPACK_IMPORTED_MODULE_12__["default"], {
      handleRetry: retrySyncAvailableAudiences
    })
  });
}

/***/ }),

/***/ "./js/modules/analytics-4/components/audience-segmentation/dashboard/AudienceSelectionPanel/constants.js":
/*!***************************************************************************************************************!*\
  !*** ./js/modules/analytics-4/components/audience-segmentation/dashboard/AudienceSelectionPanel/constants.js ***!
  \***************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   AUDIENCE_ADD_GROUP_NOTICE_SLUG: () => (/* binding */ AUDIENCE_ADD_GROUP_NOTICE_SLUG),
/* harmony export */   AUDIENCE_CREATION_EDIT_SCOPE_NOTICE_SLUG: () => (/* binding */ AUDIENCE_CREATION_EDIT_SCOPE_NOTICE_SLUG),
/* harmony export */   AUDIENCE_CREATION_FORM: () => (/* binding */ AUDIENCE_CREATION_FORM),
/* harmony export */   AUDIENCE_CREATION_NOTICE_SLUG: () => (/* binding */ AUDIENCE_CREATION_NOTICE_SLUG),
/* harmony export */   AUDIENCE_CREATION_SUCCESS_NOTICE_SLUG: () => (/* binding */ AUDIENCE_CREATION_SUCCESS_NOTICE_SLUG),
/* harmony export */   AUDIENCE_SELECTED: () => (/* binding */ AUDIENCE_SELECTED),
/* harmony export */   AUDIENCE_SELECTION_CHANGED: () => (/* binding */ AUDIENCE_SELECTION_CHANGED),
/* harmony export */   AUDIENCE_SELECTION_DISMISSED_ITEMS_ERROR_SLUG: () => (/* binding */ AUDIENCE_SELECTION_DISMISSED_ITEMS_ERROR_SLUG),
/* harmony export */   AUDIENCE_SELECTION_FORM: () => (/* binding */ AUDIENCE_SELECTION_FORM),
/* harmony export */   AUDIENCE_SELECTION_PANEL_OPENED_KEY: () => (/* binding */ AUDIENCE_SELECTION_PANEL_OPENED_KEY),
/* harmony export */   MAX_SELECTED_AUDIENCES_COUNT: () => (/* binding */ MAX_SELECTED_AUDIENCES_COUNT),
/* harmony export */   MIN_SELECTED_AUDIENCES_COUNT: () => (/* binding */ MIN_SELECTED_AUDIENCES_COUNT)
/* harmony export */ });
/**
 * AudienceSelectionPanel components - constants.
 *
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

const AUDIENCE_ADD_GROUP_NOTICE_SLUG = 'audience-segmentation-add-group-notice';
const AUDIENCE_SELECTION_PANEL_OPENED_KEY = 'googlesitekit-audience-selection-panel-opened';
const AUDIENCE_SELECTION_FORM = 'audience-selection-form';
const AUDIENCE_SELECTED = 'audience-selected';
const AUDIENCE_SELECTION_CHANGED = 'audience-selection-changed';
const AUDIENCE_SELECTION_DISMISSED_ITEMS_ERROR_SLUG = 'audience-selection-dismissed-items-error';
const AUDIENCE_CREATION_NOTICE_SLUG = 'audience-segmentation-creation-notice';
const AUDIENCE_CREATION_SUCCESS_NOTICE_SLUG = 'audience-segmentation-creation-success-notice';
const MIN_SELECTED_AUDIENCES_COUNT = 1;
const MAX_SELECTED_AUDIENCES_COUNT = 3;
const AUDIENCE_CREATION_EDIT_SCOPE_NOTICE_SLUG = 'audience-creation-edit-scope-notice';
const AUDIENCE_CREATION_FORM = 'audience-creation-form';

/***/ }),

/***/ "./js/modules/analytics-4/components/audience-segmentation/dashboard/AudienceSelectionPanel/index.js":
/*!***********************************************************************************************************!*\
  !*** ./js/modules/analytics-4/components/audience-segmentation/dashboard/AudienceSelectionPanel/index.js ***!
  \***********************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ AudienceSelectionPanel)
/* harmony export */ });
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./constants */ "./js/modules/analytics-4/components/audience-segmentation/dashboard/AudienceSelectionPanel/constants.js");
/* harmony import */ var _js_googlesitekit_datastore_ui_constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/googlesitekit/datastore/ui/constants */ "./js/googlesitekit/datastore/ui/constants.js");
/* harmony import */ var _js_components_InViewProvider__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/components/InViewProvider */ "./js/components/InViewProvider/index.js");
/* harmony import */ var _Panel__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./Panel */ "./js/modules/analytics-4/components/audience-segmentation/dashboard/AudienceSelectionPanel/Panel.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Audience Selection Panel
 *
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Internal dependencies
 */






function AudienceSelectionPanel() {
  const isOpen = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useSelect)(select => select(_js_googlesitekit_datastore_ui_constants__WEBPACK_IMPORTED_MODULE_2__.CORE_UI).getValue(_constants__WEBPACK_IMPORTED_MODULE_1__.AUDIENCE_SELECTION_PANEL_OPENED_KEY));
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_js_components_InViewProvider__WEBPACK_IMPORTED_MODULE_3__["default"], {
    value: {
      key: 'AudienceSelectionPanel',
      value: !!isOpen
    },
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_Panel__WEBPACK_IMPORTED_MODULE_4__["default"], {})
  });
}

/***/ }),

/***/ "./js/modules/analytics-4/components/audience-segmentation/dashboard/AudienceTilesWidget/AudienceTile/AudienceTileCitiesMetric.js":
/*!****************************************************************************************************************************************!*\
  !*** ./js/modules/analytics-4/components/audience-segmentation/dashboard/AudienceTilesWidget/AudienceTile/AudienceTileCitiesMetric.js ***!
  \****************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ AudienceTileCitiesMetric)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _js_util__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @/js/util */ "./js/util/index.js");
/* harmony import */ var _AudienceTileNoData__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./AudienceTileNoData */ "./js/modules/analytics-4/components/audience-segmentation/dashboard/AudienceTilesWidget/AudienceTile/AudienceTileNoData.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * AudienceTileCitiesMetric component.
 *
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * Internal dependencies
 */



function AudienceTileCitiesMetric({
  TileIcon,
  title,
  topCities
}) {
  const validDimensionValues = topCities?.dimensionValues?.filter(Boolean) || [];
  const hasDimensionValues = !!validDimensionValues.length;
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)("div", {
    className: "googlesitekit-audience-segmentation-tile-metric googlesitekit-audience-segmentation-tile-metric--cities",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("div", {
      className: "googlesitekit-audience-segmentation-tile-metric__icon",
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)(TileIcon, {})
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)("div", {
      className: "googlesitekit-audience-segmentation-tile-metric__container",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("div", {
        className: "googlesitekit-audience-segmentation-tile-metric__title",
        children: title
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)("div", {
        className: "googlesitekit-audience-segmentation-tile-metric__content",
        children: [!hasDimensionValues && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)(_AudienceTileNoData__WEBPACK_IMPORTED_MODULE_1__["default"], {}), hasDimensionValues && validDimensionValues.map((city, index) => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)("div", {
          className: "googlesitekit-audience-segmentation-tile-metric__cities-metric",
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("div", {
            className: "googlesitekit-audience-segmentation-tile-metric__cities-metric-name",
            children: city?.value
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("div", {
            className: "googlesitekit-audience-segmentation-tile-metric__cities-metric-value",
            children: (0,_js_util__WEBPACK_IMPORTED_MODULE_0__.numFmt)(topCities?.metricValues[index]?.value / topCities?.total, {
              style: 'percent',
              maximumFractionDigits: 1
            })
          })]
        }, city?.value))]
      })]
    })]
  });
}
AudienceTileCitiesMetric.propTypes = {
  TileIcon: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().elementType).isRequired,
  title: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string).isRequired,
  topCities: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().object)
};

/***/ }),

/***/ "./js/modules/analytics-4/components/audience-segmentation/dashboard/AudienceTilesWidget/AudienceTile/AudienceTileCollectingData.js":
/*!******************************************************************************************************************************************!*\
  !*** ./js/modules/analytics-4/components/audience-segmentation/dashboard/AudienceTilesWidget/AudienceTile/AudienceTileCollectingData.js ***!
  \******************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ AudienceTileCollectingData)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _svg_graphics_audience_segmentation_collecting_data_svg__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/svg/graphics/audience-segmentation-collecting-data.svg */ "./svg/graphics/audience-segmentation-collecting-data.svg");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * AudienceTileCollectingData component.
 *
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */


function AudienceTileCollectingData() {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)(_wordpress_element__WEBPACK_IMPORTED_MODULE_3__.Fragment, {
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)(_svg_graphics_audience_segmentation_collecting_data_svg__WEBPACK_IMPORTED_MODULE_1__["default"], {
      className: "googlesitekit-audience-segmentation-tile__zero-data-image"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("p", {
      className: "googlesitekit-audience-segmentation-tile__zero-data-description",
      children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Site Kit is collecting data for this group.', 'google-site-kit')
    })]
  });
}

/***/ }),

/***/ "./js/modules/analytics-4/components/audience-segmentation/dashboard/AudienceTilesWidget/AudienceTile/AudienceTileCollectingDataHideable.js":
/*!**************************************************************************************************************************************************!*\
  !*** ./js/modules/analytics-4/components/audience-segmentation/dashboard/AudienceTilesWidget/AudienceTile/AudienceTileCollectingDataHideable.js ***!
  \**************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ AudienceTileCollectingDataHideable)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _js_components_Link__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/components/Link */ "./js/components/Link.js");
/* harmony import */ var _svg_icons_visibility_svg__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/svg/icons/visibility.svg */ "./svg/icons/visibility.svg");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * AudienceTileCollectingDataHideable component.
 *
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */



function AudienceTileCollectingDataHideable({
  onHideTile
}) {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)(_wordpress_element__WEBPACK_IMPORTED_MODULE_4__.Fragment, {
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("p", {
      className: "googlesitekit-audience-segmentation-tile__zero-data-description",
      children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('You can hide this group until data is available.', 'google-site-kit')
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_js_components_Link__WEBPACK_IMPORTED_MODULE_1__["default"], {
      className: "googlesitekit-audience-segmentation-tile-hide-cta",
      onClick: onHideTile,
      leadingIcon: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_svg_icons_visibility_svg__WEBPACK_IMPORTED_MODULE_2__["default"], {
        width: 22,
        height: 22
      }),
      secondary: true,
      linkButton: true,
      children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Temporarily hide', 'google-site-kit')
    })]
  });
}
AudienceTileCollectingDataHideable.propTypes = {
  onHideTile: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().func).isRequired
};

/***/ }),

/***/ "./js/modules/analytics-4/components/audience-segmentation/dashboard/AudienceTilesWidget/AudienceTile/AudienceTileError/TileErrorContent.js":
/*!**************************************************************************************************************************************************!*\
  !*** ./js/modules/analytics-4/components/audience-segmentation/dashboard/AudienceTilesWidget/AudienceTile/AudienceTileError/TileErrorContent.js ***!
  \**************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _js_util_errors__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/util/errors */ "./js/util/errors.js");
/* harmony import */ var _svg_graphics_analytics_audience_segmentation_tile_error_svg__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/svg/graphics/analytics-audience-segmentation-tile-error.svg */ "./svg/graphics/analytics-audience-segmentation-tile-error.svg");
/* harmony import */ var _js_components_ReportErrorActions__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/components/ReportErrorActions */ "./js/components/ReportErrorActions.js");
/* harmony import */ var _js_modules_analytics_4_components_audience_segmentation_dashboard_GetHelpLink__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/modules/analytics-4/components/audience-segmentation/dashboard/GetHelpLink */ "./js/modules/analytics-4/components/audience-segmentation/dashboard/GetHelpLink.js");
/* harmony import */ var _js_components_Typography__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/components/Typography */ "./js/components/Typography/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * TileErrorContent component.
 *
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */






const TileErrorContent = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_7__.forwardRef)(({
  errors,
  onRetry,
  onRequestAccess
}, ref) => {
  const hasInsufficientPermissionsError = errors.some(err => (0,_js_util_errors__WEBPACK_IMPORTED_MODULE_1__.isInsufficientPermissionsError)(err));
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("div", {
    className: "googlesitekit-audience-segmentation-tile-error",
    ref: ref,
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)("div", {
      className: "googlesitekit-audience-segmentation-tile-error__container",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(_svg_graphics_analytics_audience_segmentation_tile_error_svg__WEBPACK_IMPORTED_MODULE_2__["default"], {
        className: "googlesitekit-audience-segmentation-tile-error__image"
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)("div", {
        className: "googlesitekit-audience-segmentation-tile-error__body",
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("div", {
          className: "googlesitekit-audience-segmentation-tile-error__message",
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(_js_components_Typography__WEBPACK_IMPORTED_MODULE_5__["default"], {
            as: "h3",
            type: "headline",
            size: "small",
            className: "googlesitekit-audience-segmentation-tile-error__title",
            children: hasInsufficientPermissionsError ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Insufficient permissions', 'google-site-kit') : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Data loading failed', 'google-site-kit')
          })
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("div", {
          className: "googlesitekit-audience-segmentation-tile-error__actions",
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(_js_components_ReportErrorActions__WEBPACK_IMPORTED_MODULE_3__["default"], {
            moduleSlug: "analytics-4",
            error: errors,
            GetHelpLink: hasInsufficientPermissionsError ? _js_modules_analytics_4_components_audience_segmentation_dashboard_GetHelpLink__WEBPACK_IMPORTED_MODULE_4__["default"] : undefined,
            hideGetHelpLink: !hasInsufficientPermissionsError,
            buttonVariant: "danger",
            onRetry: onRetry,
            onRequestAccess: onRequestAccess
          })
        })]
      })]
    })
  });
});
TileErrorContent.propTypes = {
  errors: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().array).isRequired,
  onRetry: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().func).isRequired,
  onRequestAccess: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().func).isRequired
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (TileErrorContent);

/***/ }),

/***/ "./js/modules/analytics-4/components/audience-segmentation/dashboard/AudienceTilesWidget/AudienceTile/AudienceTileError/index.js":
/*!***************************************************************************************************************************************!*\
  !*** ./js/modules/analytics-4/components/audience-segmentation/dashboard/AudienceTilesWidget/AudienceTile/AudienceTileError/index.js ***!
  \***************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ AudienceTileError)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var _js_util_errors__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @/js/util/errors */ "./js/util/errors.js");
/* harmony import */ var _TileErrorContent__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./TileErrorContent */ "./js/modules/analytics-4/components/audience-segmentation/dashboard/AudienceTilesWidget/AudienceTile/AudienceTileError/TileErrorContent.js");
/* harmony import */ var _js_util_withIntersectionObserver__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/util/withIntersectionObserver */ "./js/util/withIntersectionObserver.js");
/* harmony import */ var _js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/hooks/useViewContext */ "./js/hooks/useViewContext.js");
/* harmony import */ var _js_util__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/util */ "./js/util/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * AudienceTileError component.
 *
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * Internal dependencies
 */






const TileErrorContentWithIntersectionObserver = (0,_js_util_withIntersectionObserver__WEBPACK_IMPORTED_MODULE_2__["default"])(_TileErrorContent__WEBPACK_IMPORTED_MODULE_1__["default"]);
function AudienceTileError({
  audienceSlug,
  errors
}) {
  const viewContext = (0,_js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_3__["default"])();
  const hasInsufficientPermissionsError = errors.some(err => (0,_js_util_errors__WEBPACK_IMPORTED_MODULE_0__.isInsufficientPermissionsError)(err));
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(TileErrorContentWithIntersectionObserver, {
    errors: errors,
    onInView: () => {
      const action = hasInsufficientPermissionsError ? 'insufficient_permissions_error' : 'data_loading_error';
      (0,_js_util__WEBPACK_IMPORTED_MODULE_4__.trackEvent)(`${viewContext}_audiences-tile`, action, audienceSlug);
    },
    onRetry: () => {
      (0,_js_util__WEBPACK_IMPORTED_MODULE_4__.trackEvent)(`${viewContext}_audiences-tile`, 'data_loading_error_retry', audienceSlug);
    },
    onRequestAccess: () => {
      (0,_js_util__WEBPACK_IMPORTED_MODULE_4__.trackEvent)(`${viewContext}_audiences-tile`, 'insufficient_permissions_error_request_access', audienceSlug);
    }
  });
}
AudienceTileError.propTypes = {
  audienceSlug: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().string).isRequired,
  errors: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().array).isRequired
};

/***/ }),

/***/ "./js/modules/analytics-4/components/audience-segmentation/dashboard/AudienceTilesWidget/AudienceTile/AudienceTileLoading.js":
/*!***********************************************************************************************************************************!*\
  !*** ./js/modules/analytics-4/components/audience-segmentation/dashboard/AudienceTilesWidget/AudienceTile/AudienceTileLoading.js ***!
  \***********************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ AudienceTileLoading)
/* harmony export */ });
/* harmony import */ var _js_components_PreviewBlock__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @/js/components/PreviewBlock */ "./js/components/PreviewBlock.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * AudienceTileLoading component.
 *
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Internal dependencies
 */


function AudienceTileLoading() {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsxs)("div", {
    className: "googlesitekit-audience-segmentation-tile-loading",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)(_js_components_PreviewBlock__WEBPACK_IMPORTED_MODULE_0__["default"], {
      width: "100%",
      height: "20px"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)(_js_components_PreviewBlock__WEBPACK_IMPORTED_MODULE_0__["default"], {
      width: "100%",
      height: "52px"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)(_js_components_PreviewBlock__WEBPACK_IMPORTED_MODULE_0__["default"], {
      width: "100%",
      height: "52px"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)(_js_components_PreviewBlock__WEBPACK_IMPORTED_MODULE_0__["default"], {
      width: "100%",
      height: "52px"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)(_js_components_PreviewBlock__WEBPACK_IMPORTED_MODULE_0__["default"], {
      width: "100%",
      height: "52px"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)(_js_components_PreviewBlock__WEBPACK_IMPORTED_MODULE_0__["default"], {
      width: "100%",
      height: "52px"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)(_js_components_PreviewBlock__WEBPACK_IMPORTED_MODULE_0__["default"], {
      width: "100%",
      height: "52px"
    })]
  });
}

/***/ }),

/***/ "./js/modules/analytics-4/components/audience-segmentation/dashboard/AudienceTilesWidget/AudienceTile/AudienceTileMetric.js":
/*!**********************************************************************************************************************************!*\
  !*** ./js/modules/analytics-4/components/audience-segmentation/dashboard/AudienceTilesWidget/AudienceTile/AudienceTileMetric.js ***!
  \**********************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ AudienceTileMetric)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _js_util__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @/js/util */ "./js/util/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * AudienceTileMetric component.
 *
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * Internal dependencies
 */


function AudienceTileMetric({
  TileIcon,
  title,
  metricValue,
  Badge,
  metricValueFormat
}) {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsxs)("div", {
    className: "googlesitekit-audience-segmentation-tile-metric",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", {
      className: "googlesitekit-audience-segmentation-tile-metric__icon",
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)(TileIcon, {})
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsxs)("div", {
      className: "googlesitekit-audience-segmentation-tile-metric__container",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", {
        className: "googlesitekit-audience-segmentation-tile-metric__value",
        children: (0,_js_util__WEBPACK_IMPORTED_MODULE_0__.numFmt)(metricValue, metricValueFormat)
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", {
        className: "googlesitekit-audience-segmentation-tile-metric__title",
        children: title
      })]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", {
      className: "googlesitekit-audience-segmentation-tile-metric__badge-container",
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)(Badge, {})
    })]
  });
}
AudienceTileMetric.propTypes = {
  TileIcon: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().elementType).isRequired,
  title: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().string).isRequired,
  metricValue: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().number).isRequired,
  Badge: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().elementType).isRequired,
  metricValueFormat: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().object)
};

/***/ }),

/***/ "./js/modules/analytics-4/components/audience-segmentation/dashboard/AudienceTilesWidget/AudienceTile/AudienceTileNoData.js":
/*!**********************************************************************************************************************************!*\
  !*** ./js/modules/analytics-4/components/audience-segmentation/dashboard/AudienceTilesWidget/AudienceTile/AudienceTileNoData.js ***!
  \**********************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ AudienceTileNoData)
/* harmony export */ });
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * AudienceTileNoData component.
 *
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */


function AudienceTileNoData() {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", {
    className: "googlesitekit-audience-segmentation-tile__no-data",
    children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('No data to show yet', 'google-site-kit')
  });
}

/***/ }),

/***/ "./js/modules/analytics-4/components/audience-segmentation/dashboard/AudienceTilesWidget/AudienceTile/AudienceTilePagesMetric.js":
/*!***************************************************************************************************************************************!*\
  !*** ./js/modules/analytics-4/components/audience-segmentation/dashboard/AudienceTilesWidget/AudienceTile/AudienceTilePagesMetric.js ***!
  \***************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ AudienceTilePagesMetric)
/* harmony export */ });
/* harmony import */ var