/******/ (() => { // webpackBootstrap
/******/ 	// The require scope
/******/ 	var __webpack_require__ = {};
/******/ 	
/************************************************************************/
/******/ 	/* webpack/runtime/global */
/******/ 	(() => {
/******/ 		__webpack_require__.g = (function() {
/******/ 			if (typeof globalThis === 'object') return globalThis;
/******/ 			try {
/******/ 				return this || new Function('return this')();
/******/ 			} catch (e) {
/******/ 				if (typeof window === 'object') return window;
/******/ 			}
/******/ 		})();
/******/ 	})();
/******/ 	
/************************************************************************/
/*!*******************************************!*\
  !*** ./js/event-providers/woocommerce.js ***!
  \*******************************************/
/**
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

((jQuery, _global$_googlesiteki) => {
  if (!jQuery) {
    return;
  }
  const {
    currency: globalCurrency,
    products: globalProducts,
    purchase,
    add_to_cart: addToCart,
    eventsToTrack
  } = ((_global$_googlesiteki = __webpack_require__.g._googlesitekit) === null || _global$_googlesiteki === void 0 ? void 0 : _global$_googlesiteki.wcdata) || {};
  const canTrackAddToCart = eventsToTrack === null || eventsToTrack === void 0 ? void 0 : eventsToTrack.includes('add_to_cart');
  const canTrackPurchase = eventsToTrack === null || eventsToTrack === void 0 ? void 0 : eventsToTrack.includes('purchase');
  if (addToCart && canTrackAddToCart) {
    var _global$_googlesiteki2, _global$_googlesiteki3;
    const {
      price
    } = addToCart;
    const eventData = formatEventData(price, globalCurrency, addToCart);
    (_global$_googlesiteki2 = __webpack_require__.g._googlesitekit) === null || _global$_googlesiteki2 === void 0 || (_global$_googlesiteki3 = _global$_googlesiteki2.gtagEvent) === null || _global$_googlesiteki3 === void 0 || _global$_googlesiteki3.call(_global$_googlesiteki2, 'add_to_cart', eventData);
  }
  if (purchase && canTrackPurchase) {
    var _global$_googlesiteki4, _global$_googlesiteki5, _global$_googlesiteki6;
    const {
      id,
      totals,
      items,
      user_data: userData
    } = purchase;
    const eventData = formatEventData(totals.total_price, totals.currency_code, items, id, totals.shipping_total, totals.tax_total);

    // User data is already normalized from WooCommerce.php.
    if ((_global$_googlesiteki4 = __webpack_require__.g._googlesitekit) !== null && _global$_googlesiteki4 !== void 0 && _global$_googlesiteki4.gtagUserData && userData) {
      eventData.user_data = userData;
    }
    (_global$_googlesiteki5 = __webpack_require__.g._googlesitekit) === null || _global$_googlesiteki5 === void 0 || (_global$_googlesiteki6 = _global$_googlesiteki5.gtagEvent) === null || _global$_googlesiteki6 === void 0 || _global$_googlesiteki6.call(_global$_googlesiteki5, 'purchase', eventData);
  }
  const $body = jQuery('body');
  if (canTrackAddToCart) {
    $body.on('added_to_cart', (event, fragments, cartHash, $button) => {
      var _global$_googlesiteki7, _global$_googlesiteki8;
      // Return early if $button is not a valid jQuery element instance.
      // This can happen when WooCommerce is customized by themes or third-party integrations.
      if (!($button !== null && $button !== void 0 && $button.jquery)) {
        return;
      }
      const productID = parseInt($button.data('product_id'), 10);
      if (!productID) {
        return;
      }
      const productData = (globalProducts === null || globalProducts === void 0 ? void 0 : globalProducts.find(product => (product === null || product === void 0 ? void 0 : product.id) === productID)) || {};
      const {
        price
      } = productData;
      const eventData = formatEventData(price, globalCurrency, productData);
      (_global$_googlesiteki7 = __webpack_require__.g._googlesitekit) === null || _global$_googlesiteki7 === void 0 || (_global$_googlesiteki8 = _global$_googlesiteki7.gtagEvent) === null || _global$_googlesiteki8 === void 0 || _global$_googlesiteki8.call(_global$_googlesiteki7, 'add_to_cart', eventData);
    });
    jQuery('.products-block-post-template .product, .wc-block-product-template .product').each(function () {
      const $productCard = jQuery(this);
      const productID = parseInt($productCard.find('[data-product_id]').attr('data-product_id'), 10);
      if (!productID) {
        return;
      }
      $productCard.on('click', event => {
        var _global$_googlesiteki9, _global$_googlesiteki0;
        const $target = jQuery(event.target);
        const $button = $target.closest('.wc-block-components-product-button [data-product_id]');
        const isAddToCartButton = $button.length && $button.hasClass('add_to_cart_button') && !$button.hasClass('product_type_variable');
        if (!isAddToCartButton) {
          return;
        }
        const productData = (globalProducts === null || globalProducts === void 0 ? void 0 : globalProducts.find(product => (product === null || product === void 0 ? void 0 : product.id) === productID)) || {};
        const {
          price
        } = productData;
        const eventData = formatEventData(price, globalCurrency, productData);
        (_global$_googlesiteki9 = __webpack_require__.g._googlesitekit) === null || _global$_googlesiteki9 === void 0 || (_global$_googlesiteki0 = _global$_googlesiteki9.gtagEvent) === null || _global$_googlesiteki0 === void 0 || _global$_googlesiteki0.call(_global$_googlesiteki9, 'add_to_cart', eventData);
      });
    });
  }
  function formatEventData(value, currency, products) {
    let transactionID = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : null;
    let shipping = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : null;
    let tax = arguments.length > 5 && arguments[5] !== undefined ? arguments[5] : null;
    const formattedData = {
      value: formatPrice(value),
      currency,
      items: []
    };
    if (transactionID) {
      formattedData.transaction_id = transactionID;
    }

    // Shipping can be 0, if only check if shipping is not empty value
    // this will be omitted.
    if (typeof shipping === 'number') {
      formattedData.shipping = shipping;
    }

    // Tax can be 0, if only check if shipping is not empty value
    // this will be omitted.
    if (typeof tax === 'number') {
      formattedData.tax = tax;
    }
    if (products && products.length) {
      for (const product of products) {
        formattedData.items.push(formatProductData(product));
      }
    } else if (products && products.id) {
      formattedData.items = [formatProductData(products)];
    }
    return formattedData;
  }
  function formatProductData(product) {
    const {
      id,
      name,
      price,
      variation,
      quantity,
      categories
    } = product;
    const mappedItem = {
      item_id: id,
      item_name: name,
      price: formatPrice(price)
    };
    if (quantity) {
      mappedItem.quantity = quantity;
    }
    if (variation) {
      mappedItem.item_variant = variation;
    }
    if (categories && categories !== null && categories !== void 0 && categories.length) {
      let categoryIndex = 1;
      for (const category of categories) {
        mappedItem[categoryIndex > 1 ? "item_category".concat(categoryIndex) : 'item_category'] = category.name;
        categoryIndex++;
      }
    }
    return mappedItem;
  }

  /**
   * Returns the price of a product formatted with decimal places if necessary.
   *
   * @since 1.158.0
   *
   * @param {string} price                 The price to parse.
   * @param {number} [currencyMinorUnit=2] The number decimals to show in the currency.
   * @return {number} The price of the product with decimals.
   */
  function formatPrice(price) {
    let currencyMinorUnit = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 2;
    return parseInt(price, 10) / 10 ** currencyMinorUnit;
  }
})(__webpack_require__.g.jQuery);
/******/ })()
;
//# sourceMappingURL=googlesitekit-events-provider-woocommerce.js.map